﻿-- $Id: AtlasMaps.lua 42 2016-07-15 08:11:19Z arith $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2016 - Arith Hsu, Atlas Team <atlas.addon@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

-- Atlas Map Data

--[[
# Structure of JournalInstance.dbc
Column	Field		Type		Notes
------	-------------	--------	----------------------------------------------------------------------------------------------
1	ID		Integer
2	Map ID		Integer		Map ID refer to Map.dbc's 1st column
3	Area ID		Integer		Area ID refer to AreaTable.dbc's 1st column
4~6			Integer
7			Integer
8	Name		String
9	Description	String


# Structure of JournalEncounter.dbc
Column	Field		Type		Notes
------	-------------	--------	----------------------------------------------------------------------------------------------
1	ID		Integer
2	Map ID?		Integer
3	Area ID?	Integer
4~5			Float
6	Selection ID	Integer
7	Instance ID	Integer		Refer to JournalInstance.dbc's 1st column
8	Index		Integer		Boss index
9
10	Name		String		Boss name
11	Description	String		Boss description


# Structure of JournalEncounterCreature.dbc
Column	Field 		Type 		Notes
------	-------------	--------	----------------------------------------------------------------------------------------------
1	ID		Integer
2	encounterID	Integer
3	modelID		Integer
4	Index		Integer
5			Integer
6	name		String


# Structure of LFGDungeons.dbc
Column	Field 		Type 		Notes
------	-------------	--------	----------------------------------------------------------------------------------------------
1 	ID 		Integer 		
2	Map Name	String		Dungeon Name
3	level_min 	Integer 	Minimum level to participate. 
4 	level_max 	Integer 	Maximum level when this dungeon becomes trivial. 
5	rec_level	Integer
6	rec_minlevel	Integer
7	rec_maxlevel	Integer
8 	Map ID	        Integer 	Here you must add the Map Id where you will be ported
9	difficulty	Integer
13	systemname
14	expansion

]]
local BZ = Atlas_GetLocaleLibBabble("LibBabble-SubZone-3.0");
local BF = Atlas_GetLocaleLibBabble("LibBabble-Faction-3.0");
local L = LibStub("AceLocale-3.0"):GetLocale("Atlas");
local ALIL = Atlas_IngameLocales;

local BLUE = "|cff6666ff";
local GREN = "|cff66cc33";
local LBLU = "|cff33cccc";
local _RED = "|cffcc3333";
local ORNG = "|cffcc9933";
local PINK = "|ccfcc33cc";
local PURP = "|cff9900ff";
local WHIT = "|cffffffff";
local YLOW = "|cffcccc33";
local INDENT = "      ";


AtlasMaps = {
--[[
Syntax: 
	MapName = {
		ZoneName = { "Map name" };
		Location = { "Location of this map" };
		LevelRange = "level range";
		MinLevel = "minimum level";
		PlayerLimit = "player limit";
		Acronym = "acronym";
		JournalInstanceID = "journal instance ID"; 	-- ID can be found from JournalInstance.dbc, Column 1 is the dungeon ID, column 8 is dungeon name
		DungeonID = "LFGDungeon ID"; 			-- ID can be fround from LFGDungeons.dbc.txt
		DungeonHeoricID = "LFGDungeon ID for Heroic mode";
		{ "list entry 1" };
		{ "list entry 2" };
		{ "list entry 3" };
		{ "list entry 4" };
	};
]]

--************************************************
-- Instance Entrance Maps
--************************************************

	AuchindounEnt = {
		ZoneName = { BZ["Auchindoun"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Terokkar Forest"] };
		LevelRange = "64-75";
		MinLevel = "62";
		PlayerLimit = "5";
		Acronym = L["Auch"];
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..BZ["Auchenai Crypts"], 10001 };
		{ BLUE.." B) "..BZ["Mana-Tombs"], 10002 };
		{ BLUE.." C) "..BZ["Sethekk Halls"], 10003 };
		{ BLUE.." D) "..BZ["Shadow Labyrinth"], 10004 };
		{ BLUE.." E) "..L["Entrance"], 10005 };
		{ GREN.." 1') "..L["Clarissa"], 10006 };
		{ GREN..INDENT..L["Greatfather Aldrimus"] };
		{ GREN..INDENT..L["Ha'lei"] };
		{ GREN..INDENT..L["Horvon the Armorer <Armorsmith>"] };
		{ GREN..INDENT..L["Ramdor the Mad"] };
		{ GREN.." 2') "..L["Nexus-Prince Haramad"], 10007 };
		{ GREN..INDENT..L["\"Slim\" <Shady Dealer>"] };
		{ GREN..INDENT..L["\"Captain\" Kaftiz"] };
		{ GREN.." 3') "..L["Dealer Tariq <Shady Dealer>"], 10008 };
		{ GREN..INDENT..L["Provisioner Tsaalt"] };
		{ GREN.." 4') "..L["Meeting Stone"], 10009 };
	};
	BlackfathomDeepsEnt = {
		ZoneName = { BZ["Blackfathom Deeps"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Ashenvale"] };
		LevelRange = "22-25";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = L["BFD"];
		JournalInstanceID = "227";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Blackfathom Deeps"], 10002 };
	};
	BlackrockMountainEnt = {
		ZoneName = { BZ["Blackrock Mountain"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		LevelRange = "49-100+";
		MinLevel = "47";
		PlayerLimit = "5/10/25/40";
		Acronym = L["BRM"];
		{ BLUE.." A) "..BZ["Searing Gorge"], 10001 };
		{ BLUE.." B) "..BZ["Burning Steppes"], 10002 };
		{ BLUE.." C) "..BZ["Blackrock Depths"]..L["L-Parenthesis"]..L["BRD"]..L["R-Parenthesis"], 10003 };
		{ BLUE.." D) "..BZ["Lower Blackrock Spire"]..L["L-Parenthesis"]..L["LBRS"]..L["R-Parenthesis"], 10004 };
		{ BLUE..INDENT..BZ["Upper Blackrock Spire"]..L["L-Parenthesis"]..L["UBRS"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Bodley"]..L["L-Parenthesis"]..L["Ghost"]..L["R-Parenthesis"] };
		{ BLUE.." E) "..BZ["The Molten Core"]..L["L-Parenthesis"]..L["MC"]..L["R-Parenthesis"], 10005 };
		{ GREN..INDENT..L["Lothos Riftwaker"] };
		{ BLUE.." F) "..BZ["Blackwing Lair"]..L["L-Parenthesis"]..L["BWL"]..L["R-Parenthesis"], 10006 };
		{ GREN..INDENT..L["Orb of Command"] };
		{ BLUE.." G) "..BZ["Blackrock Caverns"]..L["L-Parenthesis"]..L["BRC"]..L["R-Parenthesis"], 10007 };
		{ ORNG.." 1) "..L["Scarshield Quartermaster <Scarshield Legion>"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"], 10008 };
		{ ORNG.." 2) "..L["The Behemoth"]..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Wanders"]..L["R-Parenthesis"], 10009 };
		{ ORNG.." 3) "..Atlas_GetBossName("Overmaster Pyron")..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"], 10010 };
		{ GREN.." 1') "..L["Meeting Stone"]..L["L-Parenthesis"]..L["BRD"]..L["R-Parenthesis"], 10011 };
		{ GREN.." 2') "..L["Meeting Stone"]..L["L-Parenthesis"]..L["LBRS"]..L["Comma"]..L["UBRS"]..L["R-Parenthesis"], 10012 };
	};
	CavernsOfTimeEnt = {
		ZoneName = { BZ["Caverns of Time"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Tanaris"] };
		LevelRange = "66-85+";
		MinLevel = "66";
		PlayerLimit = "5/10/25";
		Acronym = L["CoT"];
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Hyjal Summit"], 10002 };
		{ BLUE.." C) "..BZ["Old Hillsbrad Foothills"], 10003 };
		{ BLUE.." D) "..BZ["The Black Morass"], 10004 };
		{ BLUE.." E) "..BZ["The Culling of Stratholme"], 10005 };
		{ BLUE.." F) "..BZ["Dragon Soul"], 10006 };
		{ BLUE.." G) "..BZ["End Time"], 10007 };
		{ BLUE.." H) "..BZ["Well of Eternity"], 10008 };
		{ BLUE.." I) "..BZ["Hour of Twilight"], 10009 };
		{ GREN.." 1') "..L["Steward of Time <Keepers of Time>"], 10010 };
		{ GREN.." 2') "..L["Alexston Chrome <Tavern of Time>"], 10011 };
		{ GREN.." 3') "..L["Graveyard"], 10012 };
		{ GREN.." 4') "..L["Yarley <Armorer>"], 10013 };
		{ GREN.." 5') "..L["Bortega <Reagents & Poison Supplies>"], 10014 };
		{ GREN..INDENT..L["Alurmi <Keepers of Time Quartermaster>"] };
		{ GREN..INDENT..L["Galgrom <Provisioner>"] };
		{ GREN.." 6') "..L["Zaladormu"], 10015 };
		{ GREN..INDENT..L["Soridormi <The Scale of Sands>"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Arazmodu <The Scale of Sands>"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN.." 7') "..L["Moonwell"], 10016 };
		{ GREN.." 8') "..L["Andormu <Keepers of Time>"]..L["L-Parenthesis"]..L["Child"]..L["R-Parenthesis"], 10017 };
		{ GREN..INDENT..L["Nozari <Keepers of Time>"]..L["L-Parenthesis"]..L["Child"]..L["R-Parenthesis"] };
		{ GREN.." 9') "..L["Anachronos <Keepers of Time>"], 10018 };
		{ GREN.."10') "..L["Andormu <Keepers of Time>"]..L["L-Parenthesis"]..L["Adult"]..L["R-Parenthesis"], 10019 };
		{ GREN..INDENT..L["Nozari <Keepers of Time>"]..L["L-Parenthesis"]..L["Adult"]..L["R-Parenthesis"] };
	};
	CoTHyjalEnt = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Hyjal Summit"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Tanaris"] };
		LevelRange = "70-73";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = L["CoT3"];
		Module = "Atlas_BurningCrusade";
		{ PURP..L["Event"]..L["Colon"]..L["Battle for Mount Hyjal"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["The Scale of the Sands"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Alliance Base"], 10002 };
		{ BLUE.." C) "..BZ["Horde Encampment"], 10003 };
		{ BLUE.." D) "..BZ["Night Elf Village"], 10004 };
		{ GREN.." 1') "..L["Indormi <Keeper of Ancient Gem Lore>"], 10005 };
		{ GREN..INDENT..L["Tydormu <Keeper of Lost Artifacts>"] };
	};
	CoilfangReservoirEnt = {
		ZoneName = { BZ["Coilfang Reservoir"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Zangarmarsh"] };
		LevelRange = "62-73";
		MinLevel = "61";
		PlayerLimit = "5/25";
		Acronym = L["CR"];
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..BZ["The Slave Pens"], 10001 };
		{ BLUE.." B) "..BZ["The Steamvault"], 10002 };
		{ BLUE.." C) "..BZ["Serpentshrine Cavern"], 10003 };
		{ BLUE.." D) "..BZ["The Underbog"], 10004 };
		{ BLUE.." E) "..L["Entrance"]..L["L-Parenthesis"]..L["Underwater"]..L["R-Parenthesis"], 10005 };
		{ GREN.." 1') "..L["Meeting Stone"], 10006 };
		{ GREN.." 2') "..L["Mortog Steamhead"], 10007 };
	};
	DireMaulEnt = {
		ZoneName = { BZ["Dire Maul"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Feralas"] };
		LevelRange = "38-47";
		MinLevel = "36";
		PlayerLimit = "5";
		Acronym = L["DM"];
		JournalInstanceID = "230";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Dire Maul"]..L["L-Parenthesis"]..L["East"]..L["R-Parenthesis"], 10002 };
		{ BLUE.." C) "..BZ["Dire Maul"]..L["L-Parenthesis"]..L["North"]..L["R-Parenthesis"], 10003 };
		{ BLUE.." D) "..BZ["Dire Maul"]..L["L-Parenthesis"]..L["West"]..L["R-Parenthesis"], 10004 };
		{ GREN.." 1') "..L["Dire Pool"], 10005 };
		{ GREN.." 2') "..L["Dire Maul Arena"], 10006 };
		{ GREN..INDENT..L["Elder Mistwalker"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"] };
	};
	HellfireCitadelEnt = {
		ZoneName = { BZ["Hellfire Citadel"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Hellfire Peninsula"] };
		LevelRange = "59-73";
		MinLevel = "57";
		PlayerLimit = "5/25";
		Acronym = L["HC"];
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..BZ["Hellfire Ramparts"], 10001 };
		{ BLUE.." B) "..BZ["The Shattered Halls"], 10002 };
		{ BLUE.." C) "..BZ["The Blood Furnace"], 10003 };
		{ BLUE.." D) "..BZ["Magtheridon's Lair"], 10004 };
		{ GREN.." 1') "..L["Meeting Stone of Magtheridon's Lair"], 10005 };
		{ GREN.." 2') "..L["Meeting Stone of Hellfire Citadel"], 10006 };
		{ GREN.." 3') "..L["Steps and path to the Blood Furnace"], 10007 };
		{ GREN.." 4') "..L["Path to the Hellfire Ramparts and Shattered Halls"], 10008 };
	};
	IcecrownEnt = {
		ZoneName = { BZ["Icecrown Citadel"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Icecrown"] };
		LevelRange = "80-83";
		MinLevel = "75";
		PlayerLimit = "5/10/25";
		Acronym = L["IC"];
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["The Forge of Souls"], 10002 };
		{ BLUE.." C) "..BZ["Pit of Saron"], 10003 };
		{ BLUE.." D) "..BZ["Halls of Reflection"], 10004 };
		{ BLUE.." E) "..BZ["Icecrown Citadel"], 10005 };
		{ GREN.." 1') "..L["Meeting Stone"], 10006 };
	};
	KarazhanEnt = {
		ZoneName = { BZ["Karazhan"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Deadwind Pass"] };
		DungeonID = "175";
		PlayerLimit = "10";
		Acronym = L["Kara"];
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..BZ["Karazhan"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10001 };
		{ BLUE.." B) "..BZ["Karazhan"]..L["L-Parenthesis"]..L["Back"]..L["R-Parenthesis"], 10002 };
		{ GREN.." 1') "..L["Archmage Leryda"], 10003 };
		{ GREN..INDENT..L["Archmage Alturus"] };
		{ GREN..INDENT..L["Apprentice Darius"] };
		{ GREN.." 2') "..L["Stairs to Underground Pond"], 10004 };
		{ GREN.." 3') "..L["Stairs to Underground Well"], 10005 };
		{ GREN.." 4') "..L["Charred Bone Fragment"], 10006 };
		{ GREN.." 5') "..L["Meeting Stone"], 10007 };
		{ GREN.." 6') "..L["Graveyard"], 10008 };
	};
	MaraudonEnt = {
		ZoneName = { BZ["Maraudon"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Desolace"] };
		LevelRange = "32-39";
		MinLevel = "30";
		PlayerLimit = "5";
		Acronym = L["Mara"];
		JournalInstanceID = "232";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ ORNG..INDENT..L["Cursed Centaur"]..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["The Nameless Prophet"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ BLUE.." B) "..BZ["Maraudon"]..L["L-Parenthesis"]..L["Purple"]..L["R-Parenthesis"], 10002 };
		{ BLUE.." C) "..BZ["Maraudon"]..L["L-Parenthesis"]..L["Orange"]..L["R-Parenthesis"], 10003 };
		{ BLUE.." D) "..BZ["Maraudon"]..L["L-Parenthesis"]..L["Portal"]..L["Comma"]..L["Lower"]..L["R-Parenthesis"], 10004 };
		{ GREN.." 1') "..L["Kherrah"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"], 10005 };
	};
	ScarletMonasteryEnt = {
		ZoneName = { BZ["Scarlet Monastery"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Tirisfal Glades"] };
		LevelRange = "28-40 / 90";
		MinLevel = "26";
		PlayerLimit = "5";
		Acronym = L["SM"];
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Scarlet Monastery"], 10002 };
		{ BLUE.." C) "..BZ["Scarlet Halls"], 10003 };
	};
	TempestKeepEnt = {
		ZoneName = { BZ["Tempest Keep"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Netherstorm"] };
		LevelRange = "70-73";
		MinLevel= "67";
		PlayerLimit = "5/25";
		Acronym = L["TK"];
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..BZ["The Mechanar"], 10001 };
		{ BLUE.." B) "..BZ["The Botanica"], 10002 };
		{ BLUE.." C) "..BZ["The Arcatraz"], 10003 };
		{ BLUE.." D) "..BZ["Tempest Keep"], 10004 };
	};
	TheDeadminesEnt = {
		ZoneName = { BZ["The Deadmines"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Westfall"] };
		LevelRange = "15-16 / 85";
		MinLevel = "15";
		PlayerLimit = "5";
		Acronym = L["VC"];
		JournalInstanceID = "63";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Meeting Stone"] };
		{ BLUE.." B) "..BZ["The Deadmines"], 10002 };
		{ ORNG.." 1) "..Atlas_GetBossName("Marisa du'Paige")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Varies"]..L["R-Parenthesis"], 10003 };
		{ ORNG.." 2) "..Atlas_GetBossName("Brainwashed Noble")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10004 };
		{ ORNG.." 3) "..Atlas_GetBossName("Foreman Thistlenettle"), 10005 };
	};
	TheSunkenTempleEnt = {
		ZoneName = { BZ["Sunken Temple"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Swamp of Sorrows"] };
		DungeonID = "28";
		Acronym = L["ST"];
		JournalInstanceID = "237";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Meeting Stone"] };
		{ GREN..INDENT..L["Lord Itharius"] };
		{ BLUE.." B) "..BZ["Sunken Temple"], 10002 };
		{ WHIT.." 1) "..L["Priestess Udum'bra"], 10003 };
		{ WHIT.." 2) "..L["Gomora the Bloodletter"], 10004 };
		{ WHIT.." 3) "..Atlas_GetBossName("Jammal'an the Prophet", 458), 10005 };
		{ ORNG.." 1) "..L["Captain Wyrmak"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10006 };
	};
	UldamanEnt = {
		ZoneName = { BZ["Uldaman"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Badlands"] };
		DungeonID = "22";
		Acronym = L["Ulda"];
		JournalInstanceID = "239";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Uldaman"], 10002 };
	};
	UlduarEnt = {
		ZoneName = { BZ["Ulduar"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["The Storm Peaks"] };
		LevelRange = "77-83";
		MinLevel = "75";
		PlayerLimit = "5/10/25";
		Acronym = L["Uldu"];
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..BZ["Ulduar"]..L["Colon"]..BZ["Halls of Stone"], 10001 };
		{ BLUE.." B) "..BZ["Ulduar"]..L["Colon"]..BZ["Halls of Lightning"], 10002 };
		{ BLUE.." C) "..BZ["Ulduar"], 10003 };
		{ GREN.." 1') "..L["Meeting Stone"], 10004 };
		{ GREN.." 2') "..L["Graveyard"], 10005 };
		{ GREN.." 3') "..L["Shavalius the Fancy <Flight Master>"], 10006 };
		{ GREN..INDENT..L["Chester Copperpot <General & Trade Supplies>"] };
		{ GREN..INDENT..L["Slosh <Food & Drink>"] };
	};
	WailingCavernsEnt = {
		ZoneName = { BZ["Wailing Caverns"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Northern Barrens"] };
		DungeonID = "1";
		Acronym = L["WC"];
		JournalInstanceID = "240";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Wailing Caverns"], 10002 };
		{ ORNG.." 1) "..Atlas_GetBossName("Trigore the Lasher")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10003 };
		{ ORNG..INDENT..Atlas_GetBossName("Boahn")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"] };
	};

--************************************************
-- Kalimdor Instances (Classic)
--************************************************

	BlackfathomDeeps = {
		ZoneName = { BZ["Blackfathom Deeps"] };
		Location = { BZ["Ashenvale"] };
		DungeonID = "10";
		Acronym = L["BFD"];
		JournalInstanceID = "227";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Je'neu Sancrea <The Earthen Ring>"] };
		{ GREN..INDENT..L["Sentinel Aluwyn"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Zeya"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Ghamoo-ra", 368) };
		{ WHIT.." 2) "..Atlas_GetBossName("Domina", 436) };
		{ GREN..INDENT..L["Altar of Blood"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Subjugator Kor'ul", 426) };
		{ GREN..INDENT..L["Altar of Blood"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Thruk", 1145) };
		{ WHIT.." 5) "..Atlas_GetBossName("Guardian of the Deep", 447) };
		{ WHIT.." 6) "..Atlas_GetBossName("Executioner Gore", 1144) };
		{ WHIT.." 7) "..Atlas_GetBossName("Twilight Lord Bathiel", 437) };
		{ GREN..INDENT..L["Fire of Aku'mai"] };
		{ WHIT.." 8) "..Atlas_GetBossName("Aku'mai", 444) };
		{ GREN..INDENT..L["Spoils of Blackfathom"] };
		{ GREN..INDENT..L["Sentinel Aluwyn"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Zeya"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
	};
	DireMaulEast = {
		ZoneName = { BZ["Dire Maul"]..L["L-Parenthesis"]..L["East"]..L["R-Parenthesis"] };
		Location = { BZ["Feralas"] };
		DungeonID = "34";
		Acronym = L["DM"];
		JournalInstanceID = "230";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["\"Ambassador\" Dagg'thol"] };
		{ GREN..INDENT..L["Furgus Warpwood"] };
		{ BLUE.." B) "..L["Entrance"], 10002 };
		{ BLUE.." C) "..L["Entrance"], 10003 };
		{ BLUE.." D) "..L["Connection"], 10004 };
		{ BLUE.." E) "..L["Exit"], 10005 };
		{ WHIT.." 1) "..Atlas_GetBossName("Lethtendris", 404) };
		{ WHIT..INDENT..Atlas_GetBossName("Pimgib") };
		{ WHIT.." 2) "..Atlas_GetBossName("Hydrospawn", 403) };
		{ WHIT.." 3) "..Atlas_GetBossName("Zevrim Thornhoof", 402)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Alzzin the Wildshaper", 405) };
		{ GREN.." 1') "..Atlas_GetBossName("Pusillin")..L["L-Parenthesis"]..L["Chase Begins"]..L["R-Parenthesis"], 10006 };
		{ GREN.." 2') "..Atlas_GetBossName("Pusillin")..L["L-Parenthesis"]..L["Chase Ends"]..L["R-Parenthesis"], 10007 };
		{ GREN.." 3') "..L["Old Ironbark"]..L["Slash"]..L["Ironbark the Redeemed"], 10008 };
	};
	DireMaulNorth = {
		ZoneName = { BZ["Dire Maul"]..L["L-Parenthesis"]..L["North"]..L["R-Parenthesis"] };
		Location = { BZ["Feralas"] };
		DungeonID = "36";
		Acronym = L["DM"];
		JournalInstanceID = "230";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Druid of the Talon"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Stonemaul Ogre"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Guard Mol'dar", 411) };
		{ WHIT.." 2) "..Atlas_GetBossName("Stomper Kreeg", 412) };
		{ WHIT.." 3) "..Atlas_GetBossName("Guard Fengus", 413) };
		{ WHIT.." 4) "..Atlas_GetBossName("Guard Slip'kik", 414) };
		{ GREN..INDENT..L["Knot Thimblejack"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Captain Kromcrush", 415) };
		{ WHIT.." 6) "..Atlas_GetBossName("King Gordok", 417) };
		{ WHIT..INDENT..Atlas_GetBossName("Cho'Rush the Observer", 416) };
	};
	DireMaulWest = {
		ZoneName = { BZ["Dire Maul"]..L["L-Parenthesis"]..L["West"]..L["R-Parenthesis"] };
		Location = { BZ["Feralas"] };
		DungeonID = "38";
		Acronym = L["DM"];
		JournalInstanceID = "230";
		Module = "Atlas_ClassicWoW";
		{ ORNG..L["Key"]..L["Colon"]..ALIL["J'eevee's Jar"]..L["L-Parenthesis"]..Atlas_GetBossName("Lord Hel'nurath")..L["R-Parenthesis"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-E) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Tendris Warpwood", 406) };
		{ WHIT.." 2) "..Atlas_GetBossName("Magister Kalendris", 408) };
		{ WHIT.." 3) "..Atlas_GetBossName("Illyanna Ravenoak", 407) };
		{ WHIT..INDENT..L["Ferra"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Immol'thar", 409) };
		{ ORNG..INDENT..Atlas_GetBossName("Lord Hel'nurath")..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Prince Tortheldrin", 410) };
		{ ORNG.." 1) "..Atlas_GetBossName("Tsu'zee")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10008 };
		{ GREN.." 1') "..L["Estulan <The Highborne>"], 10003 };
		{ GREN..INDENT..L["Shen'dralar Watcher"] };
		{ GREN.." 2') "..L["Pylons"], 10004 };
		{ GREN.." 3') "..L["Ancient Equine Spirit"], 10005 };
		{ GREN.." 4') "..L["Shen'dralar Ancient"], 10006 };
		{ GREN.." 5') "..BZ["The Athenaeum"], 10007 };
		{ GREN..INDENT..L["Falrin Treeshaper"] };
		{ GREN..INDENT..L["Lorekeeper Lydros"] };
		{ GREN..INDENT..L["Lorekeeper Javon"] };
		{ GREN..INDENT..L["Lorekeeper Kildrath"] };
		{ GREN..INDENT..L["Lorekeeper Mykos"] };
		{ GREN..INDENT..L["Shen'dralar Provisioner"] };
	};
	Maraudon = {
		ZoneName = { BZ["Maraudon"] };
		Location = { BZ["Desolace"] };
		LevelRange = "32-39";
		MinLevel = "30";
		PlayerLimit = "5";
		Acronym = L["Mara"];
		JournalInstanceID = "232";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Orange"]..L["R-Parenthesis"], 10001 };
		{ BLUE.." B) "..L["Entrance"]..L["L-Parenthesis"]..L["Purple"]..L["R-Parenthesis"], 10002 };
		{ BLUE.." C) "..L["Entrance"]..L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10003 };
		{ WHIT.." 1) "..Atlas_GetBossName("Noxxion", 423) };
		{ WHIT.." 2) "..Atlas_GetBossName("Razorlash", 424) };
		{ WHIT.." 3) "..Atlas_GetBossName("Lord Vyletongue", 427) };
		{ WHIT.." 4) "..Atlas_GetBossName("Tinkerer Gizlock", 425) };
		{ WHIT.." 5) "..Atlas_GetBossName("Celebras the Cursed", 428) };
		{ GREN..INDENT..L["Celebras the Redeemed"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Landslide", 429) };
		{ WHIT.." 7) "..Atlas_GetBossName("Rotgrip", 430) };
		{ WHIT.." 8) "..Atlas_GetBossName("Princess Theradras", 431) };
		{ ORNG.." 1) "..Atlas_GetBossName("Meshlok the Harvester")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Wanders"]..L["R-Parenthesis"], 10004 };
		{ GREN.." 1') "..L["Elder Splitrock"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10005 };
	};
	RagefireChasm = {
		ZoneName = { BZ["Ragefire Chasm"] };
		Location = { BZ["Orgrimmar"] };
		DungeonID = "4";
		Acronym = L["RFC"];
		JournalInstanceID = "226";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Adarogg", 694) };
		{ WHIT.." 2) "..Atlas_GetBossName("Dark Shaman Koranthal", 695) };
		{ WHIT.." 3) "..Atlas_GetBossName("Slagmaw", 696) };
		{ WHIT.." 4) "..Atlas_GetBossName("Lava Guard Gordoth", 697) };
		{ GREN.." 1') "..L["Commander Bagran"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"], 10002 };
		{ GREN..INDENT..L["Invoker Xorenth"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 2') "..L["Scout Cage"], 10003 };
	};
	RazorfenDowns = {
		ZoneName = { BZ["Razorfen Downs"] };
		Location = { BZ["Thousand Needles"] };
		DungeonID = "20";
		Acronym = L["RFD"];
		JournalInstanceID = "233";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Koristrasza"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Aarux", 1142) };
		{ WHIT.." 2) "..Atlas_GetBossName("Mordresh Fire Eye", 433) };
		{ WHIT.." 3) "..Atlas_GetBossName("Mushlump", 1143)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Koristrasza"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Death Speaker Blackthorn", 1146) };
		{ WHIT..INDENT..Atlas_GetBossName("Amnennar the Coldbringer", 1141) };
		{ GREN..INDENT..L["Amnennar's Phylactery"] };
	};
	RazorfenKraul = {
		ZoneName = { BZ["Razorfen Kraul"] };
		Location = { BZ["Southern Barrens"] };
		DungeonID = "16";
		Acronym = L["RFK"];
		JournalInstanceID = "234";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Auld Stonespire"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Hunter Bonetusk", 896) };
		{ WHIT.." 2) "..Atlas_GetBossName("Roogug", 895) };
		{ WHIT.." 3) "..Atlas_GetBossName("Warlord Ramtusk", 899) };
		{ WHIT.." 4) "..Atlas_GetBossName("Groyat, the Blind Hunter", 900) };
		{ WHIT.." 5) "..Atlas_GetBossName("Charlga Razorflank", 901) };
		{ ORNG.." 1) "..Atlas_GetBossName("Earthcaller Halmgar")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10002 };
		{ GREN.." 1') "..L["Spirit of Agamaggan <Ancient>"], 10003 };
	};
	TheRuinsofAhnQiraj = {
		ZoneName = { BZ["Ahn'Qiraj"]..L["Colon"]..BZ["Ruins of Ahn'Qiraj"] };
		Location = { BZ["Ahn'Qiraj: The Fallen Kingdom"] };
		DungeonID = "160";
		Acronym = L["AQ10"];
		PlayerLimit = "10";
		Module = "Atlas_ClassicWoW";
		{ ORNG..REPUTATION..L["Colon"]..BF["Cenarion Circle"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Kurinnaxx"), 10002 };
		{ GREN..INDENT..Atlas_GetBossName("Lieutenant General Andorov") };
		{ GREN..INDENT..L["Four Kaldorei Elites"] };
		{ WHIT.." 2) "..Atlas_GetBossName("General Rajaxx"), 10003 };
		{ WHIT..INDENT..L["Captain Qeez"] };
		{ WHIT..INDENT..L["Captain Tuubid"] };
		{ WHIT..INDENT..L["Captain Drenn"] };
		{ WHIT..INDENT..L["Captain Xurrem"] };
		{ WHIT..INDENT..L["Major Yeggeth"] };
		{ WHIT..INDENT..L["Major Pakkon"] };
		{ WHIT..INDENT..L["Colonel Zerran"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Moam")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10004 };
		{ WHIT.." 4) "..Atlas_GetBossName("Buru the Gorger")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10005 };
		{ WHIT.." 5) "..Atlas_GetBossName("Ayamiss the Hunter")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10006 };
		{ WHIT.." 6) "..Atlas_GetBossName("Ossirian the Unscarred"), 10007 };
		{ GREN.." 1') "..L["Safe Room"], 10008 };
	};
	TheTempleofAhnQiraj = {
		ZoneName = { BZ["Ahn'Qiraj"]..L["Colon"]..BZ["Temple of Ahn'Qiraj"] };
		Location = { BZ["Ahn'Qiraj: The Fallen Kingdom"] };
		DungeonID = "161";
		Acronym = L["AQ40"];
		PlayerLimit = "40";
		Module = "Atlas_ClassicWoW";
		{ ORNG..REPUTATION..L["Colon"]..BF["Brood of Nozdormu"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-D) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("The Prophet Skeram")..L["L-Parenthesis"]..L["Outside"]..L["R-Parenthesis"], 10003 };
		{ WHIT.." 2) "..Atlas_GetBossName("The Bug Family")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10004 };
		{ WHIT..INDENT..Atlas_GetBossName("Vem") };
		{ WHIT..INDENT..Atlas_GetBossName("Lord Kri") };
		{ WHIT..INDENT..Atlas_GetBossName("Princess Yauj") };
		{ WHIT.." 3) "..Atlas_GetBossName("Battleguard Sartura"), 10005 };
		{ WHIT.." 4) "..Atlas_GetBossName("Fankriss the Unyielding"), 10006 };
		{ WHIT.." 5) "..Atlas_GetBossName("Viscidus")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10007 };
		{ WHIT.." 6) "..Atlas_GetBossName("Princess Huhuran"), 10008 };
		{ WHIT.." 7) "..Atlas_GetBossName("The Twin Emperors"), 10009 };
		{ WHIT..INDENT..Atlas_GetBossName("Emperor Vek'lor") };
		{ WHIT..INDENT..Atlas_GetBossName("Emperor Vek'nilash") };
		{ GREN..INDENT..L["Teleporter destination"] };
		{ WHIT.." 8) "..Atlas_GetBossName("Ouro")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10010 };
		{ WHIT.." 9) "..Atlas_GetBossName("Eye of C'Thun"), 10011 };
		{ WHIT..INDENT..Atlas_GetBossName("C'Thun") };
		{ GREN.." 1') "..L["Andorgos <Brood of Malygos>"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10012 };
		{ GREN..INDENT..L["Vethsera <Brood of Ysera>"] };
		{ GREN..INDENT..L["Kandrostrasz <Brood of Alexstrasza>"] };
		{ GREN.." 2') "..L["Arygos"], 10013 };
		{ GREN..INDENT..L["Caelestrasz"] };
		{ GREN..INDENT..L["Merithra of the Dream"] };
		{ GREN..INDENT..L["Teleporter destination"] };
	};
	WailingCaverns = {
		ZoneName = { BZ["Wailing Caverns"] };
		Location = { BZ["Northern Barrens"] };
		DungeonID = "1";
		Acronym = L["WC"];
		JournalInstanceID = "240";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Lady Anacondra", 474) };
		{ WHIT.." 2) "..Atlas_GetBossName("Lord Pythas", 476) };
		{ WHIT.." 3) "..Atlas_GetBossName("Lord Cobrahn", 475) };
		{ WHIT.." 4) "..Atlas_GetBossName("Skum", 478) };
		{ WHIT.." 5) "..Atlas_GetBossName("Lord Serpentis", 479)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Verdan the Everliving", 480)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 7) "..Atlas_GetBossName("Mutanus the Devourer", 481) };
		{ GREN..INDENT..L["Naralex"] };
		{ ORNG.." 1) "..Atlas_GetBossName("Kresh", 477)..L["L-Parenthesis"]..L["Varies"]..L["R-Parenthesis"] };
		{ ORNG.." 2) "..Atlas_GetBossName("Deviate Faerie Dragon")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Varies"]..L["R-Parenthesis"], 10002 };
		{ GREN.." 1') "..L["Ebru <Disciple of Naralex>"], 10003 };
		{ GREN..INDENT..L["Nalpak <Disciple of Naralex>"] };
		{ GREN..INDENT..L["Muyoh <Disciple of Naralex>"] };
	};
	ZulFarrak = {
		ZoneName = { BZ["Zul'Farrak"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "24";
		Acronym = L["ZF"];
		JournalInstanceID = "241";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"] };
		{ GREN..INDENT..L["Mazoga's Spirit"] };
		{ GREN..INDENT..L["Tran'rek"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Gahz'rilla", 483)..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Sandfury Executioner") };
		{ WHIT..INDENT..L["Weegli Blastfuse"] };
		{ WHIT..INDENT..Atlas_GetBossName("Sergeant Bly") };
		{ WHIT..INDENT..L["Raven"] };
		{ WHIT..INDENT..Atlas_GetBossName("Oro Eyegouge") };
		{ WHIT..INDENT..Atlas_GetBossName("Murta Grimgut") };
		{ WHIT.." 3) "..Atlas_GetBossName("Nekrum Gutchewer and Shadow Priest Sezz'ziz", 487) };
		{ WHIT.." 4) "..Atlas_GetBossName("Chief Ukorz Sandscalp", 489) };
		{ WHIT..INDENT..Atlas_GetBossName("Ruuzlu") };
		{ WHIT.." 5) "..Atlas_GetBossName("Witch Doctor Zum'rah", 486) };
		{ WHIT.." 6) "..Atlas_GetBossName("Antu'sul", 484) };
		{ ORNG.." 1) "..Atlas_GetBossName("Sandarr Dunereaver")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10002 };
		{ ORNG.." 2) "..Atlas_GetBossName("Hydromancer Velratha", 482) };
		{ ORNG.." 3) "..Atlas_GetBossName("Theka the Martyr", 485) };
		{ ORNG.." 4) "..Atlas_GetBossName("Dustwraith")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Varies"]..L["R-Parenthesis"], 10003 };
		{ ORNG.." 5) "..Atlas_GetBossName("Zerillis")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Wanders"]..L["R-Parenthesis"], 10004 };
		{ GREN.." 1') "..L["Elder Wildmane"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10005 };
	};

--************************************************
-- Eastern Kingdoms Instances (Classic)
--************************************************
	
	BlackrockDepths = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["Blackrock Depths"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		LevelRange = "49-56";
		MinLevel = "47";
		PlayerLimit = "5";
		Acronym = L["BRD"];
		JournalInstanceID = "228";
		Module = "Atlas_ClassicWoW";
		{ ORNG..L["Key"]..L["Colon"]..ALIL["Relic Coffer Key"] };
		{ ORNG..L["Key"]..L["Colon"]..ALIL["Dark Keeper Key"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-D) "..L["Connection"], 10002 };
		{ BLUE.." E) "..BZ["The Molten Core"], 10003 };
		{ WHIT.." 1) "..Atlas_GetBossName("High Interrogator Gerstahn", 369) };
		{ WHIT.." 2) "..Atlas_GetBossName("Lord Roccor", 370)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Houndmaster Grebmar", 371) };
		{ WHIT.." 4) "..Atlas_GetBossName("Bael'Gar", 377) };
		{ WHIT.." 5) "..Atlas_GetBossName("Lord Incendius", 374) };
		{ GREN..INDENT..L["The Black Anvil"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Fineous Darkvire", 376)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT.." 7) "..L["The Vault"] };
		{ WHIT..INDENT..Atlas_GetBossName("Warder Stilgiss", 375) };
		{ WHIT..INDENT..Atlas_GetBossName("Verek") };
		{ WHIT..INDENT..L["Watchman Doomgrip"] };
		{ WHIT.." 8) "..Atlas_GetBossName("Pyromancer Loregrain", 373) };
		{ WHIT.." 9) "..Atlas_GetBossName("Ring of Law", 372) };
		{ ORNG..INDENT..Atlas_GetBossName("High Justice Grimstone", 372, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Anub'shiah")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Eviscerator")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Gorosh the Dervish")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Grizzle")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Hedrum the Creeper")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Ok'thor the Breaker")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Elder Morndeep"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"] };
		{ WHIT.."10) "..Atlas_GetBossName("General Angerforge", 378) };
		{ WHIT.."11) "..Atlas_GetBossName("Golem Lord Argelmach", 379) };
		{ GREN..INDENT..L["Schematic: Field Repair Bot 74A"] };
		{ GREN..INDENT..L["Blacksmithing Plans"] };
		{ WHIT.."12) "..Atlas_GetBossName("Hurley Blackbreath", 380) };
		{ ORNG..INDENT..Atlas_GetBossName("Coren Direbrew")..L["L-Parenthesis"]..L["Brewfest"]..L["R-Parenthesis"] };
		{ WHIT.."13) "..Atlas_GetBossName("Ribbly Screwspigot", 382) };
		{ WHIT.."14) "..Atlas_GetBossName("Phalanx", 381) };
		{ WHIT..INDENT..Atlas_GetBossName("Plugger Spazzring", 383) };
		{ GREN..INDENT..L["Private Rocknot"] };
		{ GREN..INDENT..L["Mistress Nagmara"] }; 
		{ WHIT.."15) "..Atlas_GetBossName("Ambassador Flamelash", 384) };
		{ WHIT.."16) "..Atlas_GetBossName("The Seven", 385) };
		{ WHIT.."17) "..Atlas_GetBossName("Magmus", 386) };
		{ WHIT.."18) "..Atlas_GetBossName("Emperor Dagran Thaurissan", 387) };
		{ WHIT..INDENT..Atlas_GetBossName("Princess Moira Bronzebeard") };
		{ WHIT..INDENT..Atlas_GetBossName("High Priestess of Thaurissan") };
		{ ORNG.." 1) "..Atlas_GetBossName("Panzor the Invincible")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Wanders"]..L["R-Parenthesis"], 10004 };
		{ GREN.." 1') "..L["Jalinda Sprig <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10005 };
		{ GREN..INDENT..L["Oralius <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Thal'trak Proudtusk <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Galamav the Marksman <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Maxwort Uberglint"] };
		{ GREN..INDENT..L["Tinkee Steamboil"] };
		{ GREN..INDENT..L["Yuka Screwspigot <Engineering Supplies>"] };
		{ GREN..INDENT..L["Abandonded Mole Machine"] };
		{ GREN.." 2') "..L["Kevin Dawson <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10006 };
		{ GREN..INDENT..L["Lexlort <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 3') "..L["Prospector Seymour <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10007 };
		{ GREN..INDENT..L["Razal'blade <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 4') "..L["Abandonded Mole Machine"], 10008 };
		{ GREN.." 5') "..L["The Shadowforge Lock"], 10009 };
		{ GREN.." 6') "..L["Blacksmithing Plans"], 10010 };
		{ GREN.." 7') "..L["Mayara Brightwing <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10011 };
		{ GREN..INDENT..L["Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 8') "..L["Lokhtos Darkbargainer <The Thorium Brotherhood>"], 10012 };
		{ GREN.." 9') "..L["Abandonded Mole Machine"], 10013 };
		{ GREN.."10') "..L["Mountaineer Orfus <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10014 };
		{ GREN..INDENT..L["Thunderheart <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.."11') "..L["Marshal Maxwell <Morgan's Militia>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10015 };
		{ GREN..INDENT..L["Warlord Goretooth <Kargath Expeditionary Force>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.."12') "..L["The Black Forge"], 10016 };
		{ GREN.."13') "..L["Core Fragment"], 10017 };
		{ GREN.."14') "..L["Shadowforge Brazier"], 10018 };
	};
	BlackwingLair = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["Blackwing Lair"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		DungeonID = "50";
		PlayerLimit = "40";
		Acronym = L["BWL"];
		Module = "Atlas_ClassicWoW";
		{ ORNG..L["Attunement Required"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Grethok the Controller"), 10003 };
		{ GREN..INDENT..L["Orb of Domination"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Razorgore the Untamed"), 10004 };
		{ WHIT.." 3) "..Atlas_GetBossName("Vaelastrasz the Corrupt"), 10005 };
		{ WHIT.." 4) "..Atlas_GetBossName("Broodlord Lashlayer"), 10006 };
		{ WHIT.." 5) "..Atlas_GetBossName("Firemaw"), 10007 };
		{ WHIT.." 6) "..Atlas_GetBossName("Ebonroc"), 10008 };
		{ WHIT..INDENT..L["Master Elemental Shaper Krixix"] };
		{ WHIT.." 7) "..Atlas_GetBossName("Flamegor"), 10009 };
		{ WHIT.." 8) "..Atlas_GetBossName("Chromaggus"), 10010 };
		{ WHIT.." 9) "..Atlas_GetBossName("Nefarian"), 10011 };
	};
	GnomereganEnt = {
		ZoneName = { BZ["Gnomeregan"]..L["L-Parenthesis"]..L["Entrance"]..L["R-Parenthesis"] };
		Location = { BZ["Dun Morogh"] };
		DungeonID = "14";
		Acronym = L["Gnome"];
		JournalInstanceID = "231";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Meeting Stone"] };
		{ BLUE.." B) "..BZ["Gnomeregan"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10002 };
		{ BLUE.." C) "..BZ["Gnomeregan"]..L["L-Parenthesis"]..L["Back"]..L["R-Parenthesis"], 10003 };
		{ GREN.." 1') "..L["Elevator"], 10004 };
		{ GREN..INDENT..L["Torben Zapblast <Teleportation Specialist>"] };
		{ GREN.." 2') "..L["Mail Box"], 10005 };
	};
	Gnomeregan = {
		ZoneName = { BZ["Gnomeregan"] };
		Location = { BZ["Dun Morogh"] };
		DungeonID = "14";
		Acronym = L["Gnome"];
		JournalInstanceID = "231";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10001 };
		{ BLUE.." B) "..L["Entrance"]..L["L-Parenthesis"]..L["Back"]..L["R-Parenthesis"], 10002 };
		{ BLUE.." C-F) "..L["Connection"], 10003 };
		{ WHIT.." 1) "..Atlas_GetBossName("Grubbis", 419) };
		{ WHIT..INDENT..L["Chomper"] };
		{ GREN..INDENT..L["Blastmaster Emi Shortfuse"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Viscous Fallout", 420)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Electrocutioner 6000", 421) };
		{ WHIT.." 4) "..Atlas_GetBossName("Crowd Pummeler 9-60", 418) };
		{ WHIT.." 5) "..Atlas_GetBossName("Mekgineer Thermaplugg", 422) };
		{ GREN.." 1') "..L["Murd Doc <S.A.F.E.>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10004 };
		{ GREN.." 2') "..BZ["The Clean Zone"], 10005 };
		{ GREN..INDENT..L["Tink Sprocketwhistle <Engineering Supplies>"] };
		{ GREN..INDENT..L["The Sparklematic 5200"] };
		{ GREN..INDENT..L["Mail Box"] };
		{ GREN.." 3') "..L["B.E Barechus <S.A.F.E.>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10006 };
		{ GREN.." 4') "..L["Face <S.A.F.E.>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10007 };
		{ GREN.." 5') "..L["Hann Ibal <S.A.F.E.>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10008 };
	};
	LowerBlackrockSpire = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["Lower Blackrock Spire"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		DungeonID = "32";
		Acronym = L["LBRS"];
		JournalInstanceID = "229";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["Blackrock Mountain"], 10002 };
		{ BLUE.." C) "..BZ["Upper Blackrock Spire"], 10003 };
		{ BLUE.." D-G) "..L["Connection"], 10004 };
		{ WHIT.." 1) "..Atlas_GetBossName("Highlord Omokk", 388) };
		{ WHIT.." 2) "..Atlas_GetBossName("Shadow Hunter Vosh'gajin", 389) };
		{ WHIT.." 3) "..Atlas_GetBossName("War Master Voone", 390) };
		{ WHIT.." 4) "..Atlas_GetBossName("Mother Smolderweb", 391) };
		{ WHIT.." 5) "..Atlas_GetBossName("Urok Doomhowl", 392)..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Urok's Tribute Pile"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Quartermaster Zigris", 393) };
		{ WHIT.." 7) "..Atlas_GetBossName("Halycon", 394) };
		{ WHIT..INDENT..Atlas_GetBossName("Gizrul the Slavener", 395) };
		{ WHIT.." 8) "..Atlas_GetBossName("Overlord Wyrmthalak", 396) };
		{ ORNG.." 1) "..Atlas_GetBossName("Burning Felguard")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Summon"]..L["R-Parenthesis"], 10005 };
		{ ORNG.." 2) "..Atlas_GetBossName("Spirestone Butcher")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10006 };
		{ ORNG.." 3) "..Atlas_GetBossName("Spirestone Battle Lord")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10007 };
		{ ORNG..INDENT..Atlas_GetBossName("Spirestone Lord Magus")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"] };
		{ ORNG.." 4) "..Atlas_GetBossName("Bannok Grimaxe")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10008 };
		{ ORNG.." 5) "..Atlas_GetBossName("Crystal Fang")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10009 };
		{ ORNG.." 6) "..Atlas_GetBossName("Ghok Bashguud")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10010 };
		{ GREN.." 1') "..L["Acride <Scarshield Legion>"], 10011 };
		{ GREN.." 2') "..L["Elder Stonefort"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10012 };
		{ GREN.." 3') "..L["Roughshod Pike"], 10013 };
	};
	MoltenCore = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["The Molten Core"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		DungeonID = "48";
		Acronym = L["MC"];
		PlayerLimit = "40";
		Module = "Atlas_ClassicWoW";
		{ ORNG..L["Attunement Required"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Hydraxian Waterlords"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Lucifron"), 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Magmadar"), 10003 };
		{ WHIT.." 3) "..Atlas_GetBossName("Gehennas"), 10004 };
		{ WHIT.." 4) "..Atlas_GetBossName("Garr"), 10005 };
		{ WHIT.." 5) "..Atlas_GetBossName("Shazzrah"), 10006 };
		{ WHIT.." 6) "..Atlas_GetBossName("Baron Geddon"), 10007 };
		{ WHIT.." 7) "..Atlas_GetBossName("Golemagg the Incinerator"), 10008 };
		{ WHIT.." 8) "..Atlas_GetBossName("Sulfuron Harbinger"), 10009 };
		{ WHIT.." 9) "..Atlas_GetBossName("Majordomo Executus"), 10010 };
		{ WHIT.."10) "..Atlas_GetBossName("Ragnaros"), 10011 };
	};
	StratholmeCrusader = {
		ZoneName = { BZ["Stratholme"]..L["Hyphen"]..BZ["Crusaders' Square"] };
		Location = { BZ["Eastern Plaguelands"] };
		DungeonID = "40";
		Acronym = L["Strat"];
		JournalInstanceID = "236";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10001 };
		{ GREN..INDENT..L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] };
		{ GREN..INDENT..L["Master Craftsman Wilhelm <Brotherhood of the Light>"] };
		{ GREN..INDENT..L["Packmaster Stonebruiser <Brotherhood of the Light>"] };
		{ WHIT.." 1) "..Atlas_GetBossName("The Unforgiven", 450) };
		{ WHIT.." 2) "..Atlas_GetBossName("Timmy the Cruel", 445) };
		{ WHIT.." 3) "..Atlas_GetBossName("Commander Malor", 749) };
		{ WHIT.." 4) "..Atlas_GetBossName("Willey Hopebreaker", 446) };
		{ WHIT.." 5) "..Atlas_GetBossName("Instructor Galford", 448) };
		{ WHIT.." 6) "..Atlas_GetBossName("Balnazzar", 449) };
		{ ORNG.." 1) "..L["Stratholme Courier"], 10002 };
		{ ORNG..INDENT..Atlas_GetBossName("Skul")..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Fras Siabi's Postbox"] };
		{ ORNG.." 2) "..Atlas_GetBossName("Hearthsinger Forresten", 443)..L["L-Parenthesis"]..L["Varies"]..L["R-Parenthesis"], 10003 };
		{ ORNG.." 3) "..Atlas_GetBossName("Risen Hammersmith")..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"], 10004 };
		{ GREN..INDENT..L["Blacksmithing Plans"] };
		{ GREN.." 1') "..L["King's Square Postbox"], 10005 };
		{ GREN.." 2') "..L["Festival Lane Postbox"], 10006 };
		{ GREN.." 3') "..L["Elder Farwhisper"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10007 };
		{ GREN.." 4') "..L["Market Row Postbox"], 10008 };
		{ GREN..INDENT..Atlas_GetBossName("Postmaster Malown")..L["L-Parenthesis"]..L["Varies"]..L["R-Parenthesis"] };
	};
	StratholmeGauntlet = {
		ZoneName = { BZ["Stratholme"]..L["Hyphen"]..BZ["The Gauntlet"] };
		Location = { BZ["Eastern Plaguelands"] };
		DungeonID = "274";
		Acronym = L["Strat"];
		JournalInstanceID = "236";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10001 };
		{ GREN..INDENT..L["Packmaster Stonebruiser <Brotherhood of the Light>"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Baroness Anastari", 451) };
		{ WHIT.." 2) "..Atlas_GetBossName("Nerub'enkan", 452) };
		{ WHIT.." 3) "..Atlas_GetBossName("Maleki the Pallid", 453) };
		{ WHIT.." 4) "..Atlas_GetBossName("Magistrate Barthilas", 454)..L["L-Parenthesis"]..L["Varies"]..L["R-Parenthesis"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Ramstein the Gorger", 455) };
		{ WHIT.." 6) "..Atlas_GetBossName("Lord Aurius Rivendare", 456) };
		{ ORNG.." 1) "..Atlas_GetBossName("Black Guard Swordsmith")..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"], 10003 };
		{ GREN..INDENT..L["Blacksmithing Plans"] };
		{ GREN.." 1') "..L["Archmage Angela Dosantos <Brotherhood of the Light>"], 10002 };
		{ GREN..INDENT..L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] };
		{ GREN..INDENT..L["Crusade Commander Korfax <Brotherhood of the Light>"] };
		{ GREN..INDENT..L["Master Craftsman Wilhelm <Brotherhood of the Light>"] };
	};
	TheStockade = {
		ZoneName = { BZ["The Stockade"] };
		Location = { BZ["Stormwind City"] };
		DungeonID = "12";
		Acronym = L["Stocks"];
		JournalInstanceID = "238";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Randolph Moloch", 466) };
		{ WHIT.." 2) "..Atlas_GetBossName("Hogger", 464) };
		{ WHIT.." 3) "..Atlas_GetBossName("Lord Overheat", 465) };
		{ GREN.." 1') "..L["Rifle Commander Coe"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10002 };
		{ GREN.." 2') "..L["Warden Thelwater"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10003 };
		{ GREN.." 3') "..L["Nurse Lillian"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10004 };
	};
	TheSunkenTemple = {
		ZoneName = { BZ["Sunken Temple"] };
		Location = { BZ["Swamp of Sorrows"] };
		DungeonID = "28";
		Acronym = L["ST"];
		JournalInstanceID = "237";
		Module = "Atlas_ClassicWoW";
		{ ORNG..L["AKA"]..L["Colon"]..BZ["The Temple of Atal'Hakkar"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Avatar of Hakkar", 457) };
		{ WHIT.." 2) "..Atlas_GetBossName("Jammal'an the Prophet", 458) };
		{ WHIT..INDENT..Atlas_GetBossName("Ogom the Wretched") };
		{ WHIT.." 3) "..Atlas_GetBossName("Dreamscythe", 459, 1)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"], 10004 };
		{ WHIT..INDENT..Atlas_GetBossName("Weaver", 459, 2)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Hazzas", 459, 4)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Morphaz", 459, 3)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Shade of Eranikus", 463) };
		{ GREN.." 1') "..L["Lord Itharius"], 10002 };
		{ GREN.." 2') "..L["Elder Starsong"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10003 };
	};
	Uldaman = {
		ZoneName = { BZ["Uldaman"] };
		Location = { BZ["Badlands"] };
		DungeonID = "22";
		Acronym = L["Ulda"];
		JournalInstanceID = "239";
		Module = "Atlas_ClassicWoW";
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10001 };
		{ BLUE.." B) "..L["Entrance"]..L["L-Parenthesis"]..L["Back"]..L["R-Parenthesis"], 10002 };
		{ BLUE.." C) "..L["Connection"], 10003 };
		{ WHIT.." 1) "..Atlas_GetBossName("The Lost Dwarves", 468)..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Olaf", 468, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Eric \"The Swift\"", 468, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Baelog", 468, 1) };
		{ GREN..INDENT..L["Baelog's Chest"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Revelosh", 467) };
		{ WHIT.." 3) "..Atlas_GetBossName("Ironaya", 469) };
		{ WHIT.." 4) "..Atlas_GetBossName("Obsidian Sentinel", 748) };
		{ WHIT.." 5) "..Atlas_GetBossName("Ancient Stone Keeper", 470) };
		{ WHIT.." 6) "..Atlas_GetBossName("Galgann Firehammer", 471) };
		{ WHIT.." 7) "..Atlas_GetBossName("Grimlok", 472) };
		{ WHIT.." 8) "..Atlas_GetBossName("Archaedas", 473) };
		{ GREN.." 1') "..L["Kand Sandseeker <Explorer's League>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10004 };
		{ GREN..INDENT..L["Lead Prospector Durdin <Explorer's League>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Olga Runesworn <Explorer's League>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Aoren Sunglow <The Reliquary>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["High Examiner Tae'thelan Bloodwatcher <The Reliquary>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Lidia Sunglow <The Reliquary>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 2') "..L["Ancient Treasure"], 10005 };
		{ GREN..INDENT..L["The Discs of Norgannon"] };
	};

--************************************************
-- Burning Crusade Instances
--************************************************

	AuchAuchenaiCrypts = {
		ZoneName = { BZ["Auchindoun"]..L["Colon"]..BZ["Auchenai Crypts"] };
		Location = { BZ["Terokkar Forest"] };
		DungeonID = "149";
		DungeonHeroicID = "178";
		Acronym = L["AC"];
		JournalInstanceID = "247";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Lower City"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Draenei Spirit"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Shirrak the Dead Watcher", 523) };
		{ WHIT.." 2) "..Atlas_GetBossName("Exarch Maladaar", 524) };
		{ WHIT..INDENT..L["Avatar of the Martyred"] };
		{ GREN..INDENT..L["D'ore"] };
		{ GREN.." 1') "..L["Tormented Soulpriest"], 10002 };
	};
	AuchManaTombs = {
		ZoneName = { BZ["Auchindoun"]..L["Colon"]..BZ["Mana-Tombs"] };
		Location = { BZ["Terokkar Forest"] };
		DungeonID = "148";
		DungeonHeroicID = "179";
		Acronym = L["MT"];
		JournalInstanceID = "250";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Consortium"] };
		{ ORNG..L["Key"]..L["Colon"]..ALIL["The Eye of Haramad"]..L["L-Parenthesis"]..L["Exalted"]..L["Comma"]..Atlas_GetBossName("Yor")..L["R-Parenthesis"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Artificer Morphalius"] };
		{ GREN..INDENT..L["Mamdy the \"Ologist\""] };
		{ WHIT.." 1) "..Atlas_GetBossName("Pandemonius", 534) };
		{ ORNG..INDENT..L["Shadow Lord Xiraxis"]..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Tavarok", 535) };
		{ WHIT.." 3) "..Atlas_GetBossName("Nexus-Prince Shaffar", 537) };
		{ ORNG..INDENT..Atlas_GetBossName("Yor", 536)..L["L-Parenthesis"]..L["Summon"]..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN.." 1') "..L["Ambassador Pax'ivi"]..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"], 10002 };
		{ GREN.." 2') "..L["Cryo-Engineer Sha'heen"], 10003 };
		{ GREN..INDENT..L["Ethereal Transporter Control Panel"] };
	};
	AuchSethekkHalls = {
		ZoneName = { BZ["Auchindoun"]..L["Colon"]..BZ["Sethekk Halls"] };
		Location = { BZ["Terokkar Forest"] };
		DungeonID = "150";
		DungeonHeroicID = "180";
		Acronym = L["Seth"];
		JournalInstanceID = "252";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Lower City"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Isfar"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Darkweaver Syth", 541) };
		{ GREN..INDENT..L["Dealer Vijaad"] };
		{ GREN..INDENT..L["Lakka"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Anzu", 542)..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["The Saga of Terokk"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Talon King Ikiss", 543) };
	};
	AuchShadowLabyrinth = {
		ZoneName = { BZ["Auchindoun"]..L["Colon"]..BZ["Shadow Labyrinth"] };
		Location = { BZ["Terokkar Forest"] };
		DungeonID = "151";
		DungeonHeroicID = "181";
		Acronym = L["SL"];
		JournalInstanceID = "253";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Lower City"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Field Commander Mahfuun"] };
		{ GREN..INDENT..L["Spy Grik'tha"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Ambassador Hellmaw", 544) };
		{ WHIT.." 2) "..Atlas_GetBossName("Blackheart the Inciter", 545) };
		{ WHIT.." 3) "..Atlas_GetBossName("Grandmaster Vorpil", 546) };
		{ GREN..INDENT..L["The Codex of Blood"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Murmur", 547) };
		{ ORNG.." 1) "..L["First Fragment Guardian"], 10002 };
		{ GREN..INDENT..L["Arcane Container"] };
		{ GREN.." 1') "..L["Spy To'gun"], 10003 };
	};
	BlackTempleStart = {
		ZoneName = { BZ["Black Temple"]..L["MapA"]..L["L-Parenthesis"]..L["Start"]..L["R-Parenthesis"] };
		Location = { BZ["Shadowmoon Valley"] };
		DungeonID = "196";
		Acronym = L["BT"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Ashtongue Deathsworn"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Towards Reliquary of Souls"], 10002 };
		{ BLUE.." C) "..L["Towards Teron Gorefiend"], 10003 };
		{ BLUE.." D) "..L["Towards Illidan Stormrage"], 10004 };
		{ WHIT.." 1) "..Atlas_GetBossName("High Warlord Naj'entus"), 10005 };
		{ WHIT.." 2) "..Atlas_GetBossName("Supremus"), 10006 };
		{ WHIT.." 3) "..Atlas_GetBossName("Shade of Akama"), 10007 };
		{ GREN.." 1') "..L["Spirit of Olum"], 10008 };
		{ GREN.." 2') "..L["Spirit of Udalo"], 10009 };
		{ GREN..INDENT..L["Aluyen <Reagents>"] };
		{ GREN..INDENT..L["Okuno <Ashtongue Deathsworn Quartermaster>"] };
		{ GREN..INDENT..L["Seer Kanai"] };
	};
	BlackTempleBasement = {
		ZoneName = { BZ["Black Temple"]..L["MapB"]..L["L-Parenthesis"]..L["Basement"]..L["R-Parenthesis"] };
		Location = { BZ["Shadowmoon Valley"] };
		DungeonID = "196";
		Acronym = L["BT"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Ashtongue Deathsworn"] };
		{ BLUE.." B) "..L["Entrance"], 10001 };
		{ BLUE.." C) "..L["Entrance"], 10002 };
		{ WHIT.." 4) "..Atlas_GetBossName("Gurtogg Bloodboil"), 10003 };
		{ WHIT.." 5) "..Atlas_GetBossName("Reliquary of Souls"), 10004 };
		{ WHIT..INDENT..Atlas_GetBossName("Essence of Suffering") };
		{ WHIT..INDENT..Atlas_GetBossName("Essence of Desire") };
		{ WHIT..INDENT..Atlas_GetBossName("Essence of Anger") };
		{ WHIT.." 6) "..Atlas_GetBossName("Teron Gorefiend"), 10005 };
	};
	BlackTempleTop = {
		ZoneName = { BZ["Black Temple"]..L["MapC"]..L["L-Parenthesis"]..L["Top"]..L["R-Parenthesis"] };
		Location = { BZ["Shadowmoon Valley"] };
		DungeonID = "196";
		Acronym = L["BT"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Ashtongue Deathsworn"] };
		{ BLUE.." D) "..L["Entrance"], 10001 };
		{ BLUE.." E) "..L["Connection"], 10002 };
		{ WHIT.." 7) "..Atlas_GetBossName("Mother Shahraz"), 10003 };
		{ WHIT.." 8) "..Atlas_GetBossName("The Illidari Council"), 10004 };
		{ WHIT..INDENT..Atlas_GetBossName("Lady Malande")..L["L-Parenthesis"]..L["Priest"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Gathios the Shatterer")..L["L-Parenthesis"]..L["Paladin"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("High Nethermancer Zerevor")..L["L-Parenthesis"]..L["Mage"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Veras Darkshadow")..L["L-Parenthesis"]..L["Rogue"]..L["R-Parenthesis"] };
		{ WHIT.." 9) "..Atlas_GetBossName("Illidan Stormrage"), 10005 };
	};
	CFRSerpentshrineCavern = {
		ZoneName = { BZ["Coilfang Reservoir"]..L["Colon"]..BZ["Serpentshrine Cavern"] };
		Location = { BZ["Zangarmarsh"] };
		DungeonID = "194";
		Acronym = L["SSC"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Cenarion Expedition"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Elevator"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Hydross the Unstable"), 10003 };
		{ WHIT.." 2) "..Atlas_GetBossName("The Lurker Below"), 10004 };
		{ WHIT.." 3) "..Atlas_GetBossName("Leotheras the Blind"), 10005 };
		{ WHIT.." 4) "..Atlas_GetBossName("Fathom-Lord Karathress"), 10006 };
		{ GREN..INDENT..L["Seer Olum"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Morogrim Tidewalker"), 10007 };
		{ WHIT.." 6) "..Atlas_GetBossName("Lady Vashj"), 10008 };
	};
	CFRTheSlavePens = {
		ZoneName = { BZ["Coilfang Reservoir"]..L["Colon"]..BZ["The Slave Pens"] };
		Location = { BZ["Zangarmarsh"] };
		DungeonID = "140";
		DungeonHeroicID = "184";
		Acronym = L["SP"];
		JournalInstanceID = "260";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Cenarion Expedition"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Nahuud"] };
		{ GREN..INDENT..L["Watcher Jhang"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Mennu the Betrayer", 570) };
		{ WHIT.." 2) "..Atlas_GetBossName("Rokmar the Crackler", 571) };
		{ WHIT.." 3) "..Atlas_GetBossName("Quagmirran", 572) };
		{ ORNG.." 1) "..Atlas_GetBossName("Ahune")..L["L-Parenthesis"]..L["Midsummer Festival"]..L["R-Parenthesis"], 10002 };
		{ GREN.." 1') "..L["Weeder Greenthumb"], 10003 };
		{ GREN.." 2') "..L["Skar'this the Heretic"]..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"], 10004 };
		{ GREN.." 3') "..L["Naturalist Bite"], 10005 };
	};
	CFRTheSteamvault = {
		ZoneName = { BZ["Coilfang Reservoir"]..L["Colon"]..BZ["The Steamvault"] };
		Location = { BZ["Zangarmarsh"] };
		DungeonID = "147";
		DungeonHeroicID = "185";
		Acronym = L["SV"];
		JournalInstanceID = "261";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Cenarion Expedition"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Naturalist Bite"] };
		{ GREN..INDENT..L["Watcher Jhang"] };
		{ GREN..INDENT..L["Windcaller Claw"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Hydromancer Thespia", 573) };
		{ GREN..INDENT..L["Main Chambers Access Panel"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Mekgineer Steamrigger", 574) };
		{ GREN..INDENT..L["Main Chambers Access Panel"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Warlord Kalithresh", 575) };
		{ ORNG.." 1) "..L["Second Fragment Guardian"], 10002 };
		{ GREN..INDENT..L["Arcane Container"] };
	};
	CFRTheUnderbog = {
		ZoneName = { BZ["Coilfang Reservoir"]..L["Colon"]..BZ["The Underbog"] };
		Location = { BZ["Zangarmarsh"] };
		DungeonID = "146";
		DungeonHeroicID = "186";
		Acronym = L["UB"];
		JournalInstanceID = "262";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Cenarion Expedition"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Naturalist Bite"] };
		{ GREN..INDENT..L["T'shu"] };
		{ GREN..INDENT..L["Watcher Jhang"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Hungarfen", 576) };
		{ GREN..INDENT..L["The Underspore"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Ghaz'an", 577) };
		{ WHIT.." 3) "..Atlas_GetBossName("Swamplord Musel'ek", 578) };
		{ WHIT..INDENT..Atlas_GetBossName("Claw") };
		{ WHIT.." 4) "..Atlas_GetBossName("The Black Stalker", 579) };
		{ GREN.." 1') "..L["Earthbinder Rayge"], 10002 };
	};
	CoTBlackMorass = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["The Black Morass"] };
		Location = { BZ["Tanaris"] };
		LevelRange = "68-75";
		MinLevel = "68";
		PlayerLimit = "5";
		Acronym = L["CoT2"];
		JournalInstanceID = "255";
		Module = "Atlas_BurningCrusade";
		{ PURP..L["Event"]..L["Colon"]..BZ["Opening of the Dark Portal"] };
		{ ORNG..L["Attunement Required"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Keepers of Time"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Sa'at <Keepers of Time>"] };
		{ ORNG.." X) "..L["Portal"]..L["L-Parenthesis"]..L["Spawn Point"]..L["R-Parenthesis"], 10002 };
		{ WHIT..INDENT..L["Wave 6"]..L["Colon"]..Atlas_GetBossName("Chrono Lord Deja", 552) };
		{ WHIT..INDENT..L["Wave 12"]..L["Colon"]..Atlas_GetBossName("Temporus", 553) };
		{ WHIT..INDENT..L["Wave 18"]..L["Colon"]..Atlas_GetBossName("Aeonus", 554) };
		{ GREN.." 1') "..BZ["The Dark Portal"], 10003 };
		{ GREN..INDENT..Atlas_GetBossName("Medivh") };
	};
	CoTHyjal = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Hyjal Summit"] };
		Location = { BZ["Tanaris"] };
		LevelRange = "70-73";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = L["CoT3"];
		Module = "Atlas_BurningCrusade";
		{ PURP..L["Event"]..L["Colon"]..BZ["The Battle for Mount Hyjal"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["The Scale of the Sands"] };
		{ BLUE.." A) "..BZ["Alliance Base"], 10001 };
		{ GREN..INDENT..L["Lady Jaina Proudmoore"] };
		{ BLUE.." B) "..BZ["Horde Encampment"], 10002 };
		{ GREN..INDENT..L["Thrall <Warchief>"] };
		{ BLUE.." C) "..BZ["Night Elf Village"], 10003 };
		{ GREN..INDENT..L["Tyrande Whisperwind <High Priestess of Elune>"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Rage Winterchill"), 10004 };
		{ WHIT.." 2) "..Atlas_GetBossName("Anetheron"), 10005 };
		{ WHIT.." 3) "..Atlas_GetBossName("Kaz'rogal"), 10006 };
		{ WHIT.." 4) "..Atlas_GetBossName("Azgalor"), 10007 };
		{ WHIT.." 5) "..Atlas_GetBossName("Archimonde"), 10008 };
	};
	CoTOldHillsbrad = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Old Hillsbrad Foothills"] };
		Location = { BZ["Tanaris"] };
		LevelRange = "66-68 / 70";
		MinLevel = "66";
		PlayerLimit = "5";
		Acronym = L["CoT1"];
		JournalInstanceID = "251";
		Module = "Atlas_BurningCrusade";
		{ PURP..L["Event"]..L["Colon"]..BZ["The Escape From Durnholde"] };
		{ ORNG..L["Attunement Required"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Keepers of Time"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Erozion"] };
		{ GREN..INDENT..L["Brazen"] };
		{ BLUE.." B) "..L["Landing Spot"], 10002 };
		{ BLUE.." C) "..BZ["Southshore"], 10003 };
		{ BLUE.." D) "..BZ["Tarren Mill"], 10004 };
		{ WHIT.." 1) "..Atlas_GetBossName("Lieutenant Drake", 538) };
		{ GREN.." 1') "..L["Thrall"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"], 10005 };
		{ WHIT.." 2) "..Atlas_GetBossName("Captain Skarloc", 539) };
		{ GREN..INDENT..L["Thrall"]..L["L-Parenthesis"]..L["Second Stop"]..L["R-Parenthesis"] };
		{ GREN.." 2') "..L["Thrall"]..L["L-Parenthesis"]..L["Third Stop"]..L["R-Parenthesis"], 10006 };
		{ WHIT.." 3) "..Atlas_GetBossName("Epoch Hunter", 540) };
		{ GREN..INDENT..L["Thrall"]..L["L-Parenthesis"]..L["Fourth Stop"]..L["Comma"]..L["Upper"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Taretha"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..L["Don Carlos"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"], 10007 };
		{ WHIT..INDENT..INDENT..L["Guerrero"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Thomas Yance <Travelling Salesman>"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Aged Dalaran Wizard"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN.." 3') "..L["Jonathan Revah"], 10008 };
		{ GREN..INDENT..L["Jerry Carter"] };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..BZ["Southshore"] };
		{ GREN..INDENT..Atlas_GetBossName("Kel'Thuzad") };
		{ GREN..INDENT..L["Helcular"] };
		{ GREN..INDENT..L["Farmer Kent"] };
		{ GREN..INDENT..L["Sally Whitemane"] };
		{ GREN..INDENT..L["Renault Mograine"] };
		{ GREN..INDENT..L["Little Jimmy Vishas"] };
		{ GREN..INDENT..L["Herod the Bully"] };
		{ GREN..INDENT..L["Nat Pagle"] };
		{ GREN..INDENT..L["Hal McAllister"] };
		{ GREN..INDENT..L["Zixil <Aspiring Merchant>"] };
		{ GREN..INDENT..L["Overwatch Mark 0 <Protector>"] };
		{ "" };
		{ ORNG..L["Southshore Inn"] };
		{ GREN..INDENT..L["Captain Edward Hanes"] };
		{ GREN..INDENT..L["Captain Sanders"] };
		{ GREN..INDENT..L["Commander Mograine"] };
		{ GREN..INDENT..L["Isillien"] };
		{ GREN..INDENT..L["Abbendis"] };
		{ GREN..INDENT..L["Fairbanks"] };
		{ GREN..INDENT..Atlas_GetBossName("Tirion Fordring") };
		{ GREN..INDENT..Atlas_GetBossName("Arcanist Doan") };
		{ GREN..INDENT..L["Taelan"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Barkeep Kelly <Bartender>"] };
		{ GREN..INDENT..L["Frances Lin <Barmaid>"] };
		{ GREN..INDENT..L["Chef Jessen <Speciality Meat & Slop>"] };
		{ GREN..INDENT..L["Stalvan Mistmantle"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Phin Odelic <The Kirin Tor>"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ "" };
		{ ORNG..BZ["Southshore Town Hall"] };
		{ GREN..INDENT..L["Magistrate Henry Maleb"] };
		{ GREN..INDENT..L["Raleigh the True"] };
		{ GREN..INDENT..L["Nathanos Marris"] };
		{ GREN..INDENT..L["Bilger the Straight-laced"] };
		{ "" };
		{ ORNG..BZ["Tarren Mill"] };
		{ GREN..INDENT..L["Innkeeper Monica"] };
		{ GREN..INDENT..L["Julie Honeywell"] };
		{ GREN..INDENT..L["Jay Lemieux"] };
		{ GREN..INDENT..L["Young Blanchy"] };
	};
	GruulsLair = {
		ZoneName = { BZ["Gruul's Lair"] };
		Location = { BZ["Blade's Edge Mountains"] };
		DungeonID = "177";
		Acronym = L["GL"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("High King Maulgar"), 10002 };
		{ WHIT..INDENT..Atlas_GetBossName("Kiggler the Crazed")..L["L-Parenthesis"]..L["Shaman"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Blindeye the Seer")..L["L-Parenthesis"]..L["Priest"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Olm the Summoner")..L["L-Parenthesis"]..L["Warlock"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Krosh Firehand")..L["L-Parenthesis"]..L["Mage"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Gruul the Dragonkiller"), 10003 };
	};
	HCBloodFurnace = {
		ZoneName = { BZ["Hellfire Citadel"]..L["Colon"]..BZ["The Blood Furnace"] };
		Location = { BZ["Hellfire Peninsula"] };
		DungeonID = "137";
		DungeonHeroicID = "187";
		Acronym = L["BF"];
		JournalInstanceID = "256";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Honor Hold"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Thrallmar"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Gunny"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Caza'rez"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT.." 1) "..Atlas_GetBossName("The Maker", 555) };
		{ WHIT.." 2) "..Atlas_GetBossName("Broggok", 556) };
		{ WHIT.." 3) "..Atlas_GetBossName("Keli'dan the Breaker", 557) };
	};
	HCHellfireRamparts = {
		ZoneName = { BZ["Hellfire Citadel"]..L["Colon"]..BZ["Hellfire Ramparts"] };
		Location = { BZ["Hellfire Peninsula"] };
		DungeonID = "136";
		DungeonHeroicID = "188";
		Acronym = L["Ramp"];
		JournalInstanceID = "248";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Honor Hold"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Thrallmar"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Advance Scout Chadwick"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Stone Guard Stok'ton"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Watchkeeper Gargolmar", 527) };
		{ WHIT.." 2) "..Atlas_GetBossName("Omor the Unscarred", 528) };
		{ WHIT.." 3) "..Atlas_GetBossName("Vazruden the Herald", 529) };
		{ WHIT..INDENT..Atlas_GetBossName("Nazan") };
		{ GREN..INDENT..L["Reinforced Fel Iron Chest"] };
	};
	HCMagtheridonsLair = {
		ZoneName = { BZ["Hellfire Citadel"]..L["Colon"]..BZ["Magtheridon's Lair"] };
		Location = { BZ["Hellfire Peninsula"] };
		DungeonID = "176";
		Acronym = L["Mag"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Magtheridon"), 10002 };
	};
	HCTheShatteredHalls = {
		ZoneName = { BZ["Hellfire Citadel"]..L["Colon"]..BZ["The Shattered Halls"] };
		Location = { BZ["Hellfire Peninsula"] };
		DungeonID = "138";
		DungeonHeroicID = "189";
		Acronym = L["SH"];
		JournalInstanceID = "259";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Honor Hold"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Thrallmar"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Advance Scout Chadwick"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Gunny"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Caza'rez"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Stone Guard Stok'ton"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Grand Warlock Nethekurse", 566) };
		{ WHIT.." 2) "..Atlas_GetBossName("Blood Guard Porung", 728)..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Warbringer O'mrogg", 568) };
		{ WHIT.." 4) "..Atlas_GetBossName("Warchief Kargath Bladefist", 569) };
		{ WHIT..INDENT..L["Shattered Hand Executioner"]..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Private Jacint"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Rifleman Brownbeard"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Captain Alina"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Scout Orgarr"]..L["L-Parenthesis"]..FACTION_HORDE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Korag Proudmane"]..L["L-Parenthesis"]..FACTION_HORDE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Captain Boneshatter"]..L["L-Parenthesis"]..FACTION_HORDE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN.." 1') "..L["Randy Whizzlesprocket"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"], 10002 };
		{ GREN..INDENT..L["Drisella"]..L["L-Parenthesis"]..FACTION_HORDE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
	};
	KarazhanStart = {
		ZoneName = { BZ["Karazhan"]..L["MapA"]..L["L-Parenthesis"]..L["Start"]..L["R-Parenthesis"] };
		Location = { BZ["Deadwind Pass"] };
		DungeonID = "175";
		Acronym = L["Kara"];
		PlayerLimit = "10";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Violet Eye"] };
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Front"]..L["R-Parenthesis"], 10001 };
		{ BLUE.." B-J) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Attumen the Huntsman"), 10003 };
		{ WHIT..INDENT..Atlas_GetBossName("Midnight") };
		{ WHIT.." 2) "..Atlas_GetBossName("Moroes"), 10004 };
		{ WHIT..INDENT..L["Baroness Dorothea Millstipe"]..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Shadow Priest"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Lady Catriona Von'Indi"]..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Holy Priest"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Lady Keira Berrybuck"]..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Holy Paladin"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Baron Rafe Dreuger"]..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Retribution Paladin"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Lord Robin Daris"]..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Arms Warrior"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Lord Crispin Ference"]..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Protection Warrior"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Maiden of Virtue"), 10005 };
		{ WHIT.." 4) "..Atlas_GetBossName("Opera Event"), 10006 };
		{ ORNG..INDENT..L["Red Riding Hood"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("The Big Bad Wolf") };
		{ ORNG..INDENT..L["Wizard of Oz"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Dorothee") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Tito") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Strawman") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Tinhead") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Roar") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("The Crone") };
		{ ORNG..INDENT..Atlas_GetBossName("Romulo & Julianne")..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Romulo") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Julianne") };
		{ WHIT.." 5 ) "..Atlas_GetBossName("Nightbane")..L["L-Parenthesis"]..L["Summon"]..L["R-Parenthesis"], 10007 };
		{ GREN..INDENT..L["The Master's Terrace"] };
		{ ORNG.." 1) "..L["Servant Quarters"], 10008 };
		{ ORNG..INDENT..Atlas_GetBossName("Hyakiss the Lurker")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ ORNG..INDENT..Atlas_GetBossName("Rokad the Ravager")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ ORNG..INDENT..Atlas_GetBossName("Shadikith the Glider")..L["L-Parenthesis"]..L["Rare"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ GREN.." 1') "..L["Hastings <The Caretaker>"], 10009 };
		{ GREN.." 2') "..L["Berthold <The Doorman>"], 10010 };
		{ GREN.." 3') "..L["Calliard <The Nightman>"], 10011 };
		{ GREN.." 4') "..L["Koren <The Blacksmith>"], 10012 };
		{ GREN.." 5') "..L["Bennett <The Sergeant at Arms>"], 10013 };
		{ GREN.." 6') "..L["Keanna's Log"], 10014 };
		{ GREN.." 7') "..L["Ebonlocke <The Noble>"], 10015 };
		{ GREN.." 8') "..L["Sebastian <The Organist>"], 10016 };
		{ GREN.." 9') "..L["Barnes <The Stage Manager>"], 10017 };
	};
	KarazhanEnd = {
		ZoneName = { BZ["Karazhan"]..L["MapB"]..L["L-Parenthesis"]..L["End"]..L["R-Parenthesis"] };
		Location = { BZ["Deadwind Pass"] };
		DungeonID = "175";
		Acronym = L["Kara"];
		PlayerLimit = "10";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Violet Eye"] };
		{ BLUE.." I) "..L["Path to the Broken Stairs"], 10001 };
		{ BLUE.." J) "..L["Broken Stairs"], 10002 };
		{ BLUE.." K) "..L["Ramp to Guardian's Library"]..L["L-Parenthesis"]..Atlas_GetBossName("Shade of Aran")..L["R-Parenthesis"], 10003 };
		{ BLUE.." L) "..L["Mysterious Bookshelf"]..L["L-Parenthesis"]..Atlas_GetBossName("Terestian Illhoof")..L["R-Parenthesis"], 10004 };
		{ BLUE.." M) "..L["Ramp up to the Celestial Watch"]..L["L-Parenthesis"]..Atlas_GetBossName("Netherspite")..L["R-Parenthesis"], 10005 };
		{ BLUE..INDENT..L["Ramp down to the Gamesman's Hall"]..L["L-Parenthesis"]..Atlas_GetBossName("Chess Event")..L["R-Parenthesis"] };
		{ BLUE.." N) "..L["Ramp to Medivh's Chamber"], 10006 };
		{ BLUE.." O) "..L["Spiral Stairs to Netherspace"]..L["L-Parenthesis"]..Atlas_GetBossName("Prince Malchezaar")..L["R-Parenthesis"], 10007 };
		{ WHIT.." 7) "..Atlas_GetBossName("The Curator"), 10008 };
		{ WHIT.." 8) "..Atlas_GetBossName("Terestian Illhoof"), 10009 };
		{ WHIT..INDENT..Atlas_GetBossName("Kil'rek")..L["L-Parenthesis"]..L["Imp"]..L["R-Parenthesis"] };
		{ WHIT.." 9) "..Atlas_GetBossName("Shade of Aran"), 10010 };
		{ WHIT.."10) "..Atlas_GetBossName("Netherspite"), 10011 };
		{ WHIT.."11) "..Atlas_GetBossName("Chess Event"), 10012 };
		{ GREN..INDENT..Atlas_GetBossName("Dust Covered Chest") };
		{ WHIT.."12) "..Atlas_GetBossName("Prince Malchezaar"), 10013 };
		{ GREN.."10') "..L["Wravien <The Mage>"], 10014 };
		{ GREN.."11') "..L["Gradav <The Warlock>"], 10015 };
		{ GREN.."12') "..L["Kamsis <The Conjurer>"], 10016 };
		{ GREN.."13') "..L["Ythyar"]..L["L-Parenthesis"]..L["Repair"]..L["Comma"]..L["Rewards"]..L["R-Parenthesis"], 10017 };
		{ GREN.."14') "..L["Echo of Medivh"], 10018 };
	};
	MagistersTerrace = {
		ZoneName = { BZ["Magisters' Terrace"] };
		Location = { BZ["Isle of Quel'Danas"] };
		DungeonID = "198";
		DungeonHeroicID = "201";
		Acronym = L["MaT"];
		JournalInstanceID = "249";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["Shattered Sun Offensive"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Exarch Larethor"] };
		{ BLUE.." B) "..L["Exit"]..L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Selin Fireheart", 530) };
		{ GREN..INDENT..L["Fel Crystals"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Vexallus", 531) };
		{ WHIT.." 3) "..Atlas_GetBossName("Priestess Delrissa", 532)..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Apoko"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Shaman"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Eramas Brightblaze"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Monk"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Ellrys Duskhallow"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Warlock"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..L["Fizzle"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Garaxxas"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Hunter"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..L["Sliver <Garaxxas' Pet>"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Kagani Nightstrike"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Rogue"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Warlord Salaris"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Warrior"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Yazzai"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Mage"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Zelfan"]..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["Comma"]..L["Engineer"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Kael'thas Sunstrider", 533) };
		{ GREN.." 1') "..L["Tyrith"], 10003 };
		{ GREN.." 2') "..L["Scrying Orb"], 10004 };
		{ GREN..INDENT..Atlas_GetBossName("Kalecgos") };
	};
	SunwellPlateau = {
		ZoneName = { BZ["Sunwell Plateau"] };
		Location = { BZ["Isle of Quel'Danas"] };
		DungeonID = "199";
		Acronym = L["SuP"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Kalecgos"), 10002 };
		{ WHIT..INDENT..Atlas_GetBossName("Sathrovarr the Corruptor") };
		{ WHIT.." 2) "..Atlas_GetBossName("Brutallus"), 10003 };
		{ WHIT..INDENT..Atlas_GetBossName("Felmyst") };
		{ GREN..INDENT..L["Madrigosa"] };
		{ WHIT.." 3) "..Atlas_GetBossName("The Eredar Twins")..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"], 10004 };
		{ WHIT..INDENT..Atlas_GetBossName("Grand Warlock Alythess")..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Lady Sacrolash")..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("M'uru")..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Entropius")..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Kil'jaeden"), 10005 };
	};
	TempestKeepArcatraz = {
		ZoneName = { BZ["Tempest Keep"]..L["Colon"]..BZ["The Arcatraz"] };
		Location = { BZ["Netherstorm"] };
		DungeonID = "174";
		DungeonHeroicID = "190";
		Acronym = L["Arca"];
		JournalInstanceID = "254";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Sha'tar"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Zereketh the Unbound", 548) };
		{ WHIT.." 2) "..Atlas_GetBossName("Dalliah the Doomsayer", 549) };
		{ WHIT.." 3) "..Atlas_GetBossName("Wrath-Scryer Soccothrates", 550) };
		{ WHIT.." 4) "..Atlas_GetBossName("Harbinger Skyriss", 551) };
		{ WHIT..INDENT..Atlas_GetBossName("Warden Mellichar") };
		{ GREN..INDENT..L["Millhouse Manastorm"] };
		{ ORNG.." 1) "..L["Third Fragment Guardian"], 10002 };
		{ GREN..INDENT..L["Arcane Container"] };
		{ GREN.." 1') "..L["Udalo"], 10003 };
	};
	TempestKeepBotanica = {
		ZoneName = { BZ["Tempest Keep"]..L["Colon"]..BZ["The Botanica"] };
		Location = { BZ["Netherstorm"] };
		DungeonID = "173";
		DungeonHeroicID = "191";
		Acronym = L["Bota"];
		JournalInstanceID = "257";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Sha'tar"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Commander Sarannis", 558) };
		{ WHIT.." 2) "..Atlas_GetBossName("High Botanist Freywinn", 559) };
		{ WHIT.." 3) "..Atlas_GetBossName("Thorngrin the Tender", 560) };
		{ WHIT.." 4) "..Atlas_GetBossName("Laj", 561) };
		{ WHIT.." 5) "..Atlas_GetBossName("Warp Splinter", 562) };
	};
	TempestKeepMechanar = {
		ZoneName = { BZ["Tempest Keep"]..L["Colon"]..BZ["The Mechanar"] };
		Location = { BZ["Netherstorm"] };
		DungeonID = "172";
		DungeonHeroicID = "192";
		Acronym = L["Mech"];
		JournalInstanceID = "258";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Sha'tar"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Gatewatcher Gyro-Kill"), 10003 };
		{ WHIT.." 2) "..Atlas_GetBossName("Gatewatcher Iron-Hand"), 10004 };
		{ WHIT.." 3) "..Atlas_GetBossName("Mechano-Lord Capacitus", 563)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Overcharged Manacell"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Nethermancer Sepethrea", 564) };
		{ WHIT.." 5) "..Atlas_GetBossName("Pathaleon the Calculator", 565) };
		{ GREN.." 1') "..Atlas_GetBossName("Cache of the Legion"), 10005 };
	};
	TempestKeepTheEye = {
		ZoneName = { BZ["Tempest Keep"]..L["Colon"]..BZ["Tempest Keep"] };
		Location = { BZ["Netherstorm"] };
		DungeonID = "193";
		Acronym = L["TK"];
		PlayerLimit = "25";
		Module = "Atlas_BurningCrusade";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Sha'tar"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Al'ar"), 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Void Reaver"), 10003 };
		{ WHIT.." 3) "..Atlas_GetBossName("High Astromancer Solarian"), 10004 };
		{ WHIT.." 4) "..Atlas_GetBossName("Kael'thas Sunstrider"), 10005 };
		{ WHIT..INDENT..Atlas_GetBossName("Thaladred the Darkener")..L["L-Parenthesis"]..L["Warrior"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Master Engineer Telonicus")..L["L-Parenthesis"]..L["Hunter"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Grand Astromancer Capernian")..L["L-Parenthesis"]..L["Mage"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Lord Sanguinar")..L["L-Parenthesis"]..L["Paladin"]..L["R-Parenthesis"] };
	};

--************************************************
-- Wrath of the Lich King Instances
--************************************************

	AhnKahet = {
		ZoneName = { BZ["Ahn'kahet: The Old Kingdom"] };
		Location = { BZ["Dragonblight"] };
		DungeonID = "218";
		DungeonHeroicID = "219";
		Acronym = L["AK, Kahet"];
		JournalInstanceID = "271";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Seer Ixit"] };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Elder Nadox", 580) };
		{ WHIT.." 2) "..Atlas_GetBossName("Prince Taldaram", 581) };
		{ WHIT.." 3) "..Atlas_GetBossName("Amanitar", 583)..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Jedoga Shadowseeker", 582) };
		{ WHIT.." 5) "..Atlas_GetBossName("Herald Volazj", 584) };
		{ GREN.." 1') "..L["Ahn'kahet Brazier"], 10003 };
	};
	AzjolNerub = {
		ZoneName = { BZ["Azjol-Nerub"] };
		Location = { BZ["Dragonblight"] };
		DungeonID = "204";
		DungeonHeroicID = "241";
		Acronym = L["AN, Nerub"];
		JournalInstanceID = "272";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Reclaimer A'zak"] };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ BLUE.." C) "..L["Exit"], 10003 };
		{ WHIT.." 1) "..Atlas_GetBossName("Krik'thir the Gatewatcher", 585) };
		{ WHIT..INDENT..L["Watcher Gashra"] };
		{ WHIT..INDENT..L["Watcher Narjil"] };
		{ WHIT..INDENT..L["Watcher Silthik"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Hadronox", 586) };
		{ WHIT.." 3) "..Atlas_GetBossName("Anub'arak", 587) };
		{ GREN.." 1') "..L["Elder Nurgen"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10004 };
	};
	CoTOldStratholme = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["The Culling of Stratholme"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "209";
		DungeonHeroicID = "210";
		Acronym = L["CoT-Strat"];
		JournalInstanceID = "279";
		Module = "Atlas_WrathoftheLichKing";
		{ PURP..L["Event"]..L["Colon"]..L["The Culling of Stratholme"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Exit"]..L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10002 };
		{ ORNG.." X) "..L["Scourge Invasion Points"], 10003 };
		{ WHIT..INDENT..L["Wave 5"]..L["Colon"]..Atlas_GetBossName("Meathook", 611) };
		{ WHIT..INDENT..L["Wave 10"]..L["Colon"]..Atlas_GetBossName("Salramm the Fleshcrafter", 612) };
		{ WHIT.." 3) "..Atlas_GetBossName("Chrono-Lord Epoch", 613) };
		{ WHIT.." 4) "..Atlas_GetBossName("Infinite Corruptor")..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"], 10004 };
		{ GREN..INDENT..L["Guardian of Time"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Mal'Ganis", 614) };
		{ GREN..INDENT..L["Chromie"] };
		{ GREN.." 1') "..L["Chromie"], 10005 };
	};
	DrakTharonKeep = {
		ZoneName = { BZ["Drak'Tharon Keep"] };
		Location = { BZ["Grizzly Hills"] };
		DungeonID = "214";
		DungeonHeroicID = "215";
		Acronym = L["DTK"];
		JournalInstanceID = "273";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Image of Drakuru"] };
		{ GREN..INDENT..L["Kurzel"] };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Trollgore", 588) };
		{ WHIT.." 2) "..Atlas_GetBossName("Novos the Summoner", 589) };
		{ WHIT.." 3) "..Atlas_GetBossName("King Dred", 590) };
		{ WHIT.." 4) "..Atlas_GetBossName("The Prophet Tharon'ja", 591) };
		{ GREN.." 1') "..L["Elder Kilias"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10003 };
		{ GREN.." 2') "..L["Drakuru's Brazier"], 10004 };
	};
	FHHallsOfReflection = {
		ZoneName = { BZ["The Frozen Halls"]..L["Colon"]..BZ["Halls of Reflection"] };
		Location = { BZ["Icecrown Citadel"] };
		DungeonID = "255";
		DungeonHeroicID = "256";
		Acronym = L["HoR"]..L["Comma"]..L["FH3"];
		JournalInstanceID = "276";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..L["Attunement Required"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Portal"]..L["L-Parenthesis"]..BZ["Dalaran"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Falric", 601)..L["L-Parenthesis"]..L["Wave 5"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Marwyn", 602)..L["L-Parenthesis"]..L["Wave 10"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Escape from Arthas", 603)..L["L-Parenthesis"]..L["Event"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["The Captain's Chest"] };
		{ GREN.." 1') "..L["Lady Jaina Proudmoore"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10003 };
		{ GREN..INDENT..L["Archmage Koreln <Kirin Tor>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Lady Sylvanas Windrunner <Banshee Queen>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dark Ranger Loralen"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
	};
	FHPitOfSaron = {
		ZoneName = { BZ["The Frozen Halls"]..L["Colon"]..BZ["Pit of Saron"] };
		Location = { BZ["Icecrown Citadel"] };
		DungeonID = "253";
		DungeonHeroicID = "254";
		Acronym = L["PoS"]..L["Comma"]..L["FH2"];
		JournalInstanceID = "278";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..L["Attunement Required"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Portal"]..L["L-Parenthesis"]..BZ["Halls of Reflection"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Forgemaster Garfrost", 608) };
		{ GREN..INDENT..L["Martin Victus"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Gorkun Ironskull"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Ick & Krick", 609) };
		{ WHIT.." 3) "..Atlas_GetBossName("Scourgelord Tyrannus", 610) };
		{ WHIT..INDENT..L["Rimefang"] };
		{ GREN.."1') "..L["Lady Jaina Proudmoore"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10003 };
		{ GREN..INDENT..L["Archmage Koreln <Kirin Tor>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Archmage Elandra <Kirin Tor>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Lady Sylvanas Windrunner <Banshee Queen>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dark Ranger Loralen"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dark Ranger Kalira"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
	};
	FHTheForgeOfSouls = {
		ZoneName = { BZ["The Frozen Halls"]..L["Colon"]..BZ["The Forge of Souls"] };
		Location = { BZ["Icecrown Citadel"] };
		DungeonID = "251";
		DungeonHeroicID = "252";
		Acronym = L["FoS"]..L["Comma"]..L["FH1"];
		JournalInstanceID = "280";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Portal"]..L["L-Parenthesis"]..BZ["Pit of Saron"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Bronjahm", 615) };
		{ WHIT.." 2) "..Atlas_GetBossName("Devourer of Souls", 616) };
		{ GREN.." 1') "..L["Lady Jaina Proudmoore"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10003 };
		{ GREN..INDENT..L["Archmage Koreln <Kirin Tor>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Archmage Elandra <Kirin Tor>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Lady Sylvanas Windrunner <Banshee Queen>"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dark Ranger Loralen"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dark Ranger Kalira"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
	};
	Gundrak = {
		ZoneName = { BZ["Gundrak"] };
		Location = { BZ["Zul'Drak"] };
		DungeonID = "216";
		DungeonHeroicID = "217";
		Acronym = L["Gun"];
		JournalInstanceID = "274";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Chronicler Bah'Kini"]..L["Slash"]..L["Tol'mar"] };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Slad'ran", 592) };
		{ WHIT.." 2) "..Atlas_GetBossName("Drakkari Colossus", 593) };
		{ WHIT.." 3) "..Atlas_GetBossName("Moorabi", 594) };
		{ WHIT.." 4) "..Atlas_GetBossName("Eck the Ferocious", 595)..L["L-Parenthesis"]..L["Heroic"]..L["Comma"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Gal'darah", 596) };
		{ GREN.." 1') "..L["Elder Ohanzee"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10003 };
	};
	IcecrownCitadelA = {
		ZoneName = { BZ["Icecrown Citadel"]..L["MapA"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		Location = { BZ["Icecrown"] };
		DungeonID = "279";
		DungeonHeroicID = "280";
		Acronym = L["IC"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Ashen Verdict"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ BLUE.." C) "..L["To next map"], 10003 };
		{ WHIT.." 1) "..Atlas_GetBossName("Lord Marrowgar"), 10004 };
		{ WHIT.." 2) "..Atlas_GetBossName("Lady Deathwhisper"), 10005 };
		{ WHIT.." 3) "..Atlas_GetBossName("Icecrown Gunship Battle")..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10006 };
		{ WHIT.." 4) "..Atlas_GetBossName("Icecrown Gunship Battle")..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"], 10007 };
		{ WHIT.." 5) "..Atlas_GetBossName("Deathbringer Saurfang"), 10008 };
		{ GREN.." 1') "..BZ["Light's Hammer"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10009 };
		{ GREN.." 2') "..BZ["Oratory of the Damned"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10010 };
		{ GREN.." 3') "..BZ["Rampart of Skulls"]..L["L-Parenthesis"]..L["Teleporter"]..L["Comma"]..L["Lower"]..L["R-Parenthesis"], 10011 };
		{ GREN..INDENT..BZ["Deathbringer's Rise"]..L["L-Parenthesis"]..L["Teleporter"]..L["Comma"]..L["Upper"]..L["R-Parenthesis"] };
	};
	IcecrownCitadelB = {
		ZoneName = { BZ["Icecrown Citadel"]..L["MapB"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		Location = { BZ["Icecrown"] };
		DungeonID = "279";
		DungeonHeroicID = "280";
		Acronym = L["IC"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Ashen Verdict"] };
		{ BLUE.." C) "..L["From previous map"], 10001 };
		{ BLUE.." D-H) "..L["Connection"], 10002 };
		{ BLUE.." I) "..L["To next map"], 10003 };
		{ WHIT.." 6) "..L["Stinky"], 10004 };
		{ WHIT.." 7) "..L["Precious"], 10005 };
		{ WHIT.." 8) "..Atlas_GetBossName("Festergut"), 10006 };
		{ WHIT.." 9) "..Atlas_GetBossName("Rotface"), 10007 };
		{ WHIT.."10) "..Atlas_GetBossName("Professor Putricide"), 10008 };
		{ WHIT.."11) "..Atlas_GetBossName("Blood Prince Council"), 10009 };
		{ WHIT..INDENT..Atlas_GetBossName("Prince Keleseth") };
		{ WHIT..INDENT..Atlas_GetBossName("Prince Taldaram") };
		{ WHIT..INDENT..Atlas_GetBossName("Prince Valanar") };
		{ WHIT.."12) "..Atlas_GetBossName("Blood-Queen Lana'thel"), 10010 };
		{ WHIT.."13) "..L["Sister Svalna"], 10011 };
		{ WHIT.."14) "..Atlas_GetBossName("Valithria Dreamwalker"), 10012 };
		{ WHIT.."15) "..Atlas_GetBossName("Sindragosa"), 10013 };
		{ WHIT..INDENT..L["Rimefang"] };
		{ WHIT..INDENT..L["Spinestalker"] };
		{ GREN.." 4') "..L["Upper Spire"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10014 };
		{ GREN.." 5') "..L["Sindragosa's Lair"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10015 };
	};
	IcecrownCitadelC = {
		ZoneName = { BZ["Icecrown Citadel"]..L["MapC"]..L["L-Parenthesis"]..BZ["The Frozen Throne"]..L["R-Parenthesis"] };
		Location = { BZ["Icecrown"] };
		DungeonID = "279";
		DungeonHeroicID = "280";
		Acronym = L["IC"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..REPUTATION..L["Colon"]..BF["The Ashen Verdict"] };
		{ BLUE.." I) "..L["From previous map"], 10001 };
		{ WHIT.."16) "..Atlas_GetBossName("The Lich King"), 10002 };
	};
	Naxxramas = {
		ZoneName = { BZ["Naxxramas"] };
		Location = { BZ["Dragonblight"] };
		DungeonID = "159";
		DungeonHeroicID = "227";
		Acronym = L["Nax"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Mr. Bigglesworth"]..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT..BZ["The Construct Quarter"] };
		{ WHIT..INDENT.."1) "..Atlas_GetBossName("Patchwerk"), 10002 };
		{ WHIT..INDENT.."2) "..Atlas_GetBossName("Grobbulus"), 10003 };
		{ WHIT..INDENT.."3) "..Atlas_GetBossName("Gluth"), 10004 };
		{ WHIT..INDENT.."4) "..Atlas_GetBossName("Thaddius"), 10005 };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Stalagg") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Feugen") };
		{ ORNG..BZ["The Arachnid Quarter"] };
		{ ORNG..INDENT.."1) "..Atlas_GetBossName("Anub'Rekhan"), 10006 };
		{ ORNG..INDENT.."2) "..Atlas_GetBossName("Grand Widow Faerlina"), 10007 };
		{ ORNG..INDENT.."3) "..Atlas_GetBossName("Maexxna"), 10008 };
		{ _RED..BZ["The Military Quarter"] };
		{ _RED..INDENT.."1) "..Atlas_GetBossName("Instructor Razuvious"), 10009 };
		{ _RED..INDENT.."2) "..Atlas_GetBossName("Gothik the Harvester"), 10010 };
		{ _RED..INDENT.."3) "..Atlas_GetBossName("The Four Horsemen"), 10011 };
		{ _RED..INDENT..INDENT..Atlas_GetBossName("Thane Korth'azz") };
		{ _RED..INDENT..INDENT..Atlas_GetBossName("Lady Blaumeux") };
		{ _RED..INDENT..INDENT..Atlas_GetBossName("Baron Rivendare") };
		{ _RED..INDENT..INDENT..Atlas_GetBossName("Sir Zeliek") };
		{ GREN..INDENT..INDENT..Atlas_GetBossName("Four Horsemen Chest") };
		{ PURP..BZ["The Plague Quarter"] };
		{ PURP..INDENT.."1) "..Atlas_GetBossName("Noth the Plaguebringer"), 10012 };
		{ PURP..INDENT.."2) "..Atlas_GetBossName("Heigan the Unclean"), 10013 };
		{ PURP..INDENT.."3) "..Atlas_GetBossName("Loatheb"), 10014 };
		{ GREN..L["Frostwyrm Lair"] };
		{ GREN..INDENT.."1) "..Atlas_GetBossName("Sapphiron"), 10015 };
		{ GREN..INDENT.."2) "..Atlas_GetBossName("Kel'Thuzad"), 10016 };
		{ "" };
		{ GREN.." 1') "..L["Teleporter to Middle"], 10017 };
	};
	ObsidianSanctum = {
		ZoneName = { BZ["Wyrmrest Temple"]..L["Colon"]..BZ["The Obsidian Sanctum"] };
		Location = { BZ["Dragonblight"] };
		DungeonID = "224";
		DungeonHeroicID = "238";
		Acronym = L["OS"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..L["AKA"]..L["Colon"]..L["Black Dragonflight Chamber"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Tenebron"), 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Shadron"), 10003 };
		{ WHIT.." 3) "..Atlas_GetBossName("Vesperon"), 10004 };
		{ WHIT.." 4) "..Atlas_GetBossName("Sartharion"), 10005 };
	};
	OnyxiasLair = {
		ZoneName = { BZ["Onyxia's Lair"] };
		Location = { BZ["Dustwallow Marsh"] };
		DungeonID = "46";
		DungeonHeroicID = "257";
		Acronym = L["Ony"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Onyxia"), 10002 };
	};
	RubySanctum = {
		ZoneName = { BZ["Wyrmrest Temple"]..L["Colon"]..BZ["The Ruby Sanctum"] };
		Location = { BZ["Dragonblight"] };
		DungeonID = "293";
		DungeonHeroicID = "294";
		Acronym = L["RS"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..L["AKA"]..L["Colon"]..L["Red Dragonflight Chamber"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Baltharus the Warborn"), 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Saviana Ragefire"), 10003 };
		{ WHIT.." 3) "..Atlas_GetBossName("General Zarithrian"), 10004 };
		{ WHIT.." 4) "..Atlas_GetBossName("Halion"), 10005 };		
	};
	TheEyeOfEternity = {
		ZoneName = { BZ["The Nexus"]..L["Colon"]..BZ["The Eye of Eternity"] };
		Location = { BZ["Borean Tundra"] };
		DungeonID = "223";
		DungeonHeroicID = "237";
		Acronym = L["TEoE"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"]..L["Slash"]..L["Exit"]..L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Malygos"), 10002 };
	};
	TheNexus = {
		ZoneName = { BZ["The Nexus"]..L["Colon"]..BZ["The Nexus"] };
		Location = { BZ["Borean Tundra"] };
		DungeonID = "225";
		DungeonHeroicID = "226";
		Acronym = L["Nex, Nexus"];
		JournalInstanceID = "281";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Warmage Kaitlyn"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Commander Kolurg", 833)..L["L-Parenthesis"]..FACTION_ALLIANCE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Commander Stoutbeard", 617)..L["L-Parenthesis"]..FACTION_HORDE..L["Comma"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Berinand's Research"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Grand Magus Telestra", 618) };
		{ WHIT.." 3) "..Atlas_GetBossName("Anomalus", 619) };
		{ WHIT.." 4) "..Atlas_GetBossName("Ormorok the Tree-Shaper", 620) };
		{ WHIT.." 5) "..Atlas_GetBossName("Keristrasza", 621) };
		{ GREN.." 1') "..L["Elder Igasho"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10002 };
	};
	TheOculus = {
		ZoneName = { BZ["The Nexus"]..L["Colon"]..BZ["The Oculus"] };
		Location = { BZ["The Nexus"] };
		DungeonID = "206";
		DungeonHeroicID = "211";
		Acronym = L["Ocu"];
		JournalInstanceID = "282";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Portal"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Drakos the Interrogator", 622)..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Belgaristrasz"] };
		{ GREN..INDENT..L["Eternos"] };
		{ GREN..INDENT..L["Verdisa"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Varos Cloudstrider", 623) };
		{ WHIT.." 3) "..Atlas_GetBossName("Mage-Lord Urom", 624)..L["L-Parenthesis"]..L["Middle"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Ley-Guardian Eregos", 625)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ GREN.." 1') "..L["Centrifuge Construct"], 10003 };
		{ GREN.." 2') "..L["Cache of Eregos"]..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"], 10004 };
	};
	TrialOfTheChampion = {
		ZoneName = { L["Crusaders' Coliseum"]..L["Colon"]..BZ["Trial of the Champion"] };
		Location = { BZ["Icecrown"] };
		DungeonID = "245";
		DungeonHeroicID = "249";
		Acronym = L["Champ"];
		JournalInstanceID = "284";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Grand Champions", 834) };
		{ ORNG..INDENT..Atlas_GetBossName("Grand Champions", 834)..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Marshal Jacob Alerius", 834, 1) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Ambrose Boltspark", 834, 2) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Colosos", 834, 5) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Jaelyne Evensong", 834, 3) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Lana Stouthammer", 834, 4) };
		{ ORNG..INDENT..Atlas_GetBossName("Grand Champions", 634)..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Mokra the Skullcrusher", 634, 1) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Eressea Dawnsinger", 634, 2) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Runok Wildmane", 634, 3) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Zul'tore", 634, 4) };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Deathstalker Visceri", 634, 5) };
		{ WHIT..INDENT..Atlas_GetBossName("Eadric the Pure", 635)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Argent Confessor Paletress", 636)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("The Black Knight", 637) };
	};
	TrialOfTheCrusader = {
		ZoneName = { L["Crusaders' Coliseum"]..L["Colon"]..BZ["Trial of the Crusader"] };
		Location = { BZ["Icecrown"] };
		DungeonID = "246";
		DungeonHeroicID = "248";
		Acronym = L["Crus"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ ORNG..L["Heroic: Trial of the Grand Crusader"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Cavern Entrance"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("The Beasts of Northrend"), 10003 };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Gormok the Impaler") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Acidmaw") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Dreadscale") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Icehowl") };
		{ WHIT..INDENT..Atlas_GetBossName("Lord Jaraxxus") };
		{ WHIT..INDENT..Atlas_GetBossName("Faction Champions") };
		{ WHIT..INDENT..Atlas_GetBossName("The Twin Val'kyr") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Fjola Lightbane") };
		{ WHIT..INDENT..INDENT..Atlas_GetBossName("Eydis Darkbane") };
		{ WHIT.." 2) "..Atlas_GetBossName("Anub'arak"), 10004 };
	};
	UlduarA = {
		ZoneName = { BZ["Ulduar"]..L["MapA"]..L["L-Parenthesis"]..L["The Siege"]..L["R-Parenthesis"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "243";
		DungeonHeroicID = "244";
		Acronym = L["Uldu"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..BZ["The Antechamber"], 10002 };
		{ ORNG.." A') "..L["Tower of Life"], 10003 };
		{ ORNG.." B') "..L["Tower of Flame"], 10004 };
		{ ORNG.." C') "..L["Tower of Frost"], 10005 };
		{ ORNG.." D') "..L["Tower of Storms"], 10006 };
		{ WHIT.." 1) "..Atlas_GetBossName("Flame Leviathan"), 10007 };
		{ WHIT.." 2) "..Atlas_GetBossName("Razorscale")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10008 };
		{ WHIT.." 3) "..Atlas_GetBossName("Ignis the Furnace Master")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10009 };
		{ WHIT.." 4) "..Atlas_GetBossName("XT-002 Deconstructor"), 10010 };
		{ GREN.." 1') "..BZ["Expedition Base Camp"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10011 };
		{ GREN.." 2') "..BZ["Formation Grounds"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10012 };
		{ GREN.." 3') "..BZ["The Colossal Forge"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10013 };
		{ GREN.." 4') "..BZ["The Scrapyard"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10014 };
	};
	UlduarB = {
		ZoneName = { BZ["Ulduar"]..L["MapB"]..L["L-Parenthesis"]..BZ["The Antechamber"]..L["R-Parenthesis"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "243";
		DungeonHeroicID = "244";
		Acronym = L["Uldu"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." B) "..L["The Siege"], 10001 };
		{ BLUE.." C) "..L["The Keepers"], 10002 };
		{ WHIT.." 5) "..Atlas_GetBossName("Assembly of Iron")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10003 };
		{ WHIT..INDENT..Atlas_GetBossName("Steelbreaker") };
		{ WHIT..INDENT..Atlas_GetBossName("Runemaster Molgeim") };
		{ WHIT..INDENT..Atlas_GetBossName("Stormcaller Brundir") };
		{ WHIT.." 6) "..Atlas_GetBossName("Kologarn"), 10004 };
		{ WHIT.." 7) "..Atlas_GetBossName("Algalon the Observer")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10005 };
		{ GREN.." 5') "..BZ["The Antechamber"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10006 };
		{ GREN.." 6') "..L["Prospector Doren"], 10007 };
		{ GREN..INDENT..L["Archivum Console"] };
	};
	UlduarC = {
		ZoneName = { BZ["Ulduar"]..L["MapC"]..L["L-Parenthesis"]..L["The Keepers"]..L["R-Parenthesis"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "243";
		DungeonHeroicID = "244";
		Acronym = L["Uldu"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." C) "..BZ["The Antechamber"], 10001 };
		{ BLUE.." D) "..BZ["The Spark of Imagination"], 10002 };
		{ BLUE.." E) "..BZ["The Descent into Madness"], 10003 };
		{ WHIT.." 8) "..Atlas_GetBossName("Auriaya")..L["L-Parenthesis"]..L["Optional"]..L["R-Parenthesis"], 10004 };
		{ WHIT.." 9) "..Atlas_GetBossName("Hodir"), 10005 };
		{ WHIT.."10) "..Atlas_GetBossName("Thorim"), 10006 };
		{ ORNG..INDENT..L["Sif"] };
		{ WHIT.."11) "..Atlas_GetBossName("Freya"), 10007 };
		{ WHIT.."12) "..Atlas_GetBossName("Elder Brightleaf"), 10008 };
		{ WHIT.."13) "..Atlas_GetBossName("Elder Ironbranch"), 10009 };
		{ WHIT.."14) "..Atlas_GetBossName("Elder Stonebark"), 10010 };
		{ GREN.." 7') "..BZ["The Shattered Walkway"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10011 };
		{ GREN.." 8') "..BZ["The Conservatory of Life"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10012 };
	};
	UlduarD = {
		ZoneName = { BZ["Ulduar"]..L["MapD"]..L["L-Parenthesis"]..BZ["The Spark of Imagination"]..L["R-Parenthesis"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "243";
		DungeonHeroicID = "244";
		Acronym = L["Uldu"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." D) "..L["The Keepers"], 10001 };
		{ WHIT.."15) "..Atlas_GetBossName("Mimiron"), 10002 };
		{ GREN.." 9') "..BZ["The Spark of Imagination"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10003 };
	};
	UlduarE = {
		ZoneName = { BZ["Ulduar"]..L["MapE"]..L["L-Parenthesis"]..BZ["The Descent into Madness"]..L["R-Parenthesis"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "243";
		DungeonHeroicID = "244";
		Acronym = L["Uldu"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." E) "..L["The Keepers"], 10001 };
		{ WHIT.."16) "..Atlas_GetBossName("General Vezax"), 10002 };
		{ WHIT.."17) "..Atlas_GetBossName("Yogg-Saron"), 10003 };
		{ GREN..INDENT..Atlas_GetBossName("Sara") };
		{ GREN.."10') "..BZ["The Prison of Yogg-Saron"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10004 };
	};
	UlduarHallsofLightning = {
		ZoneName = { BZ["Ulduar"]..L["Colon"]..BZ["Halls of Lightning"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "207";
		DungeonHeroicID = "212";
		Acronym = L["HoL"];
		JournalInstanceID = "275";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Stormherald Eljrrin"] };
		{ WHIT.." 1) "..Atlas_GetBossName("General Bjarngrim", 597)..L["L-Parenthesis"]..L["Wanders"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Volkhan", 598) };
		{ WHIT.." 3) "..Atlas_GetBossName("Ionar", 599) };
		{ WHIT.." 4) "..Atlas_GetBossName("Loken", 600) };
	};
	UlduarHallsofStone = {
		ZoneName = { BZ["Ulduar"]..L["Colon"]..BZ["Halls of Stone"] };
		Location = { BZ["The Storm Peaks"] };
		DungeonID = "208";
		DungeonHeroicID = "213";
		Acronym = L["HoS"];
		JournalInstanceID = "277";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Kaldir Ironbane"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Krystallus", 604) };
		{ WHIT.." 2) "..Atlas_GetBossName("Maiden of Grief", 605) };
		{ WHIT.." 3) "..Atlas_GetBossName("Tribunal of Ages", 606)..L["L-Parenthesis"]..L["Event"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Tribunal Chest"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Sjonnir The Ironshaper", 607) };
		{ GREN.." 1') "..L["Elder Yurauk"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10002 };
		{ GREN.." 2') "..L["Brann Bronzebeard"], 10003 };
	};
	UtgardeKeep = {
		ZoneName = { BZ["Utgarde Keep"]..L["Colon"]..BZ["Utgarde Keep"] };
		Location = { BZ["Howling Fjord"] };
		DungeonID = "202";
		DungeonHeroicID = "242";
		Acronym = L["UK, Keep"];
		JournalInstanceID = "285";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Defender Mordun"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dark Ranger Marrah"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Prince Keleseth", 638) };
		{ WHIT.." 2) "..Atlas_GetBossName("Skarvold & Dalronn", 639) };
		{ WHIT.." 3) "..Atlas_GetBossName("Ingvar the Plunderer", 640) };
		{ GREN.." 1') "..L["Elder Jarten"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["Comma"]..L["Lower"]..L["R-Parenthesis"], 10003 };
	};
	UtgardePinnacle = {
		ZoneName = { BZ["Utgarde Keep"]..L["Colon"]..BZ["Utgarde Pinnacle"] };
		Location = { BZ["Utgarde Keep"] };
		DungeonID = "203";
		DungeonHeroicID = "205";
		Acronym = L["UP, Pinn"];
		JournalInstanceID = "286";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Brigg Smallshanks"] };
		{ GREN..INDENT..L["Image of Argent Confessor Paletress"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Svala Sorrowgrave", 641) };
		{ WHIT.." 2) "..Atlas_GetBossName("Gortok Palehoof", 642) };
		{ WHIT.." 3) "..Atlas_GetBossName("Skadi the Ruthless", 643) };
		{ WHIT.." 4) "..Atlas_GetBossName("King Ymiron", 644) };
		{ GREN.." 1') "..L["Elder Chogan'gada"]..L["L-Parenthesis"]..L["Lunar Festival"]..L["R-Parenthesis"], 10002 };
	};
	VaultOfArchavon = {
		ZoneName = { BZ["Vault of Archavon"] };
		Location = { BZ["Wintergrasp"] };
		DungeonID = "239";
		DungeonHeroicID = "240";
		Acronym = L["VoA"];
		PlayerLimit = "10/25";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Archavon the Stone Watcher"), 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Emalon the Storm Watcher"), 10003 };
		{ WHIT.." 3) "..Atlas_GetBossName("Koralon the Flame Watcher"), 10004 };
		{ WHIT.." 4) "..Atlas_GetBossName("Toravon the Ice Watcher"), 10005 };
	};
	VioletHold = {
		ZoneName = { BZ["The Violet Hold"] };
		Location = { BZ["Dalaran"] };
		DungeonID = "220";
		DungeonHeroicID = "221";
		Acronym = L["VH"];
		JournalInstanceID = "283";
		Module = "Atlas_WrathoftheLichKing";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Lieutenant Sinclari"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Erekem", 626)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Zuramat the Obliterator", 631)..L["L-Parenthesis"]..L["Upper"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Xevozz", 629)..L["L-Parenthesis"]..L["Lower"]..L["Comma"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Ichoron", 628)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Moragg", 627)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Lavanthor", 630)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Cyanigosa", 632)..L["L-Parenthesis"]..L["Wave 18"]..L["R-Parenthesis"] };
	};

--************************************************
-- Cataclysm Instances
--************************************************

	BaradinHold = {
		ZoneName = { BZ["Baradin Hold"] };
		Location = { BZ["Tol Barad"] };
		DungeonID = "328";
		DungeonHeroicID = "329";
		Acronym = L["BH"];
		PlayerLimit = "10/25";
		JournalInstanceID = "75";
		Module = "Atlas_Cataclysm";
		{ ORNG..REPUTATION..L["Colon"]..BF["Baradin's Wardens"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ ORNG..REPUTATION..L["Colon"]..BF["Hellscream's Reach"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Argaloth", 139) };
		{ WHIT.." 2) "..Atlas_GetBossName("Occu'thar", 140) };
		{ WHIT.." 3) "..Atlas_GetBossName("Alizabal, Mistress of Hate", 339) };
	};
	BlackrockCaverns = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["Blackrock Caverns"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		DungeonID = "303";
		DungeonHeroicID = "323";
		Acronym = L["BRC"];
		JournalInstanceID = "66";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Rom'ogg Bonecrusher", 105) };
		{ WHIT.." 2) "..Atlas_GetBossName("Corla, Herald of Twilight", 106) };
		{ WHIT.." 3) "..Atlas_GetBossName("Karsh Steelbender", 107) };
		{ WHIT.." 4) "..Atlas_GetBossName("Beauty", 108) };
		{ WHIT.." 5) "..Atlas_GetBossName("Ascendant Lord Obsidius", 109) };
		{ GREN.." 1') "..L["Finkle Einhorn"], 10002 };
		{ GREN..INDENT..L["Teleporter"] };
		{ GREN.." 2') "..L["Teleporter"], 10003 };
	};
	BlackwingDescent = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["Blackwing Descent"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		DungeonID = "313";
		DungeonHeroicID = "314";
		Acronym = L["BWD"];
		PlayerLimit = "10/25";
		JournalInstanceID = "73";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Magmaw", 170) };
		{ WHIT.." 2) "..Atlas_GetBossName("Omnotron Defense System", 169) };
		{ WHIT.." 3) "..Atlas_GetBossName("Chimaeron", 172) };
		{ WHIT.." 4) "..Atlas_GetBossName("Maloriak", 173) };
		{ WHIT.." 5) "..Atlas_GetBossName("Atramedes", 171) };
		{ WHIT.." 6) "..Atlas_GetBossName("Nefarian's End", 174) };
	};
	CoTDragonSoulA = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Dragon Soul"]..L["MapA"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "447";
		DungeonHeroicID = "448";
		Acronym = L["CoT-DS"];
		PlayerLimit = "10/25";
		JournalInstanceID = "187";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Portal"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Morchok", 311) };
		{ WHIT.." 5) "..Atlas_GetBossName("Ultraxion", 331)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Dasnurimi <Geologist & Conservator>"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Lord Afrasastrasz"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
	};
	CoTDragonSoulB = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Dragon Soul"]..L["MapB"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "447";
		DungeonHeroicID = "448";
		Acronym = L["CoT-DS"];
		PlayerLimit = "10/25";
		JournalInstanceID = "187";
		Module = "Atlas_Cataclysm";
		{ BLUE.." C-E) "..L["Portal"], 10001 };
		{ WHIT.." 2) "..Atlas_GetBossName("Warlord Zon'ozz", 324) };
		{ WHIT.." 3) "..Atlas_GetBossName("Yor'sahj the Unsleeping", 325) };
		{ WHIT.." 4) "..Atlas_GetBossName("Hagara the Stormbinder", 317) };
	};
	CoTDragonSoulC = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Dragon Soul"]..L["MapC"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "447";
		DungeonHeroicID = "448";
		Acronym = L["CoT-DS"];
		PlayerLimit = "10/25";
		JournalInstanceID = "187";
		Module = "Atlas_Cataclysm";
		{ WHIT.." 6) "..Atlas_GetBossName("Warmaster Blackhorn", 332) };
		{ WHIT.." 7) "..Atlas_GetBossName("Spine of Deathwing", 318) };
		{ WHIT.." 8) "..Atlas_GetBossName("Madness of Deathwing", 333) };
	};
	CoTEndTime = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["End Time"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "435";
		Acronym = L["CoT-ET"];
		JournalInstanceID = "184";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Alurmi"] };
		{ GREN..INDENT..L["Nozdormu"] };
		{ GREN..INDENT..L["Teleporter"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Echo of Baine", 340)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Echo of Jaina", 285)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Echo of Sylvanas", 323)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Echo of Tyrande", 283)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Murozond", 289) };
		{ GREN.." 1') "..L["Teleporter"], 10002 };
	};
	CoTHourOfTwilight = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Hour of Twilight"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "439";
		Acronym = L["CoT-HoT"];
		JournalInstanceID = "186";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Thrall"] };
		{ GREN..INDENT..L["Teleporter"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Arcurion", 322) };
		{ WHIT.." 2) "..Atlas_GetBossName("Asira Dawnslayer", 342) };
		{ WHIT.." 3) "..Atlas_GetBossName("Archbishop Benedictus", 341) };
		{ BLUE..INDENT..L["Portal"]..L["L-Parenthesis"]..BZ["Stormwind"]..L["Slash"]..BZ["Orgrimmar"]..L["R-Parenthesis"] };
	};
	CoTWellOfEternity = {
		ZoneName = { BZ["Caverns of Time"]..L["Colon"]..BZ["Well of Eternity"] };
		Location = { BZ["Tanaris"] };
		DungeonID = "437";
		Acronym = L["CoT-WoE"];
		JournalInstanceID = "185";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Alurmi"] };
		{ GREN..INDENT..L["Nozdormu"] };
		{ GREN..INDENT..L["Teleporter"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Peroth'arn", 290) };
		{ WHIT.." 2) "..Atlas_GetBossName("Queen Azshara", 291) };
		{ WHIT.." 3) "..Atlas_GetBossName("Mannoroth and Varo'then", 292) };
		{ GREN..INDENT..L["Chromie"] };
		{ GREN.." 1') "..Atlas_GetBossName("Illidan Stormrage"), 10002 };
		{ GREN.." 2') "..L["Teleporter"], 10003 };
	};
	Firelands = {
		ZoneName = { BZ["Firelands"] };
		Location = { BZ["Mount Hyjal"] };
		DungeonID = "361";
		DungeonHeroicID = "362";
		Acronym = L["FL"];
		PlayerLimit = "10/25";
		JournalInstanceID = "78";
		Module = "Atlas_Cataclysm";
		{ ORNG..REPUTATION..L["Colon"]..BF["Avengers of Hyjal"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Lurah Wrathvine <Crystallized Firestone Collector>"] };
		{ GREN..INDENT..L["Naresir Stormfury <Avengers of Hyjal Quartermaster>"] };
		{ BLUE.." B) "..L["Connection"]..L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Beth'tilac", 192) };
		{ WHIT.." 2) "..Atlas_GetBossName("Lord Rhyolith", 193) };
		{ WHIT.." 3) "..Atlas_GetBossName("Alysrazor", 194) };
		{ WHIT.." 4) "..Atlas_GetBossName("Shannox", 195) };
		{ WHIT.." 5) "..Atlas_GetBossName("Baleroc, the Gatekeeper", 196) };
		{ WHIT.." 6) "..Atlas_GetBossName("Majordomo Staghelm", 197) };
		{ WHIT.." 7) "..Atlas_GetBossName("Ragnaros", 198) };
		{ GREN.." 1') "..L["Teleporter"], 10003 };
	};
	GrimBatol = {
		ZoneName = { BZ["Grim Batol"] };
		Location = { BZ["Twilight Highlands"] };
		DungeonID = "304";
		DungeonHeroicID = "322";
		Acronym = L["GB"];
		JournalInstanceID = "71";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("General Umbriss", 131) };
		{ WHIT.." 2) "..Atlas_GetBossName("Forgemaster Throngus", 132) };
		{ WHIT.." 3) "..Atlas_GetBossName("Drahga Shadowburner", 133).." & "..Atlas_GetBossName("Valiona", 133, 2) };
		{ WHIT.." 4) "..Atlas_GetBossName("Erudax, the Duke of Below", 134) };
		{ GREN.." 1') "..L["Baleflame"], 10002 };
		{ GREN..INDENT..L["Farseer Tooranu <The Earthen Ring>"] };
		{ GREN..INDENT..L["Velastrasza"] };
	};
	HallsOfOrigination = {
		ZoneName = { BZ["Halls of Origination"] };
		Location = { BZ["Uldum"] };
		DungeonID = "305";
		DungeonHeroicID = "321";
		Acronym = L["HoO"];
		JournalInstanceID = "70";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Temple Guardian Anhuur", 124) };
		{ WHIT.." 2) "..Atlas_GetBossName("Earthrager Ptah", 125) };
		{ WHIT.." 3) "..Atlas_GetBossName("Anraphet", 126) };
		{ WHIT.." 4) "..Atlas_GetBossName("Isiset, Construct of Magic", 127) };
		{ WHIT.." 5) "..Atlas_GetBossName("Ammunae, Construct of Life", 128) };
		{ WHIT.." 6) "..Atlas_GetBossName("Setesh, Construct of Destruction", 129) };
		{ WHIT.." 7) "..Atlas_GetBossName("Rajh, Construct of Sun", 130) };
		{ GREN.." 1') "..L["Teleporter"], 10002 };
		{ GREN.." 2') "..L["Brann Bronzebeard"], 10003 };
		{ GREN.." 3') "..L["Large Stone Obelisk"], 10004 };
	};
	LostCityOfTolvir = {
		ZoneName = { BZ["Lost City of the Tol'vir"] };
		Location = { BZ["Uldum"] };
		DungeonID = "312";
		DungeonHeroicID = "325";
		Acronym = L["LCoT"];
		JournalInstanceID = "69";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Captain Hadan"] };
		{ WHIT.." 1) "..Atlas_GetBossName("General Husam", 117) };
		{ WHIT.." 2) "..Atlas_GetBossName("Lockmaw", 118) };
		{ WHIT..INDENT..Atlas_GetBossName("Augh", 118, 2) };
		{ WHIT.." 3) "..Atlas_GetBossName("High Prophet Barim", 119) };
		{ WHIT.." 4) "..Atlas_GetBossName("Siamat", 122) };
		{ GREN.." 1') "..L["Tol'vir Grave"], 10002 };
	};
	ShadowfangKeep = {
		ZoneName = { BZ["Shadowfang Keep"] };
		Location = { BZ["Silverpine Forest"] };
		DungeonID = "8";
		DungeonHeroicID = "327";
		Acronym = L["SFK"];
		JournalInstanceID = "64";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Baron Ashbury", 96) };
		{ WHIT.." 2) "..Atlas_GetBossName("Baron Silverlaine", 97) };
		{ WHIT..INDENT..Atlas_GetBossName("Odo the Blindwatcher")..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Razorclaw the Butcher")..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Rethilgore")..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Wolf Master Nandos")..L["L-Parenthesis"]..L["Random"]..L["Comma"]..L["Summon"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Commander Springvale", 98) };
		{ WHIT.." 4) "..Atlas_GetBossName("Lord Walden", 99) };
		{ WHIT.." 5) "..Atlas_GetBossName("Lord Godfrey", 100) };
		{ ORNG.." 1) "..L["Apothecary Trio"]..L["L-Parenthesis"]..L["Love is in the Air"]..L["R-Parenthesis"], 10003 };
		{ ORNG..INDENT..L["Apothecary Hummel <Crown Chemical Co.>"] };
		{ ORNG..INDENT..L["Apothecary Baxter <Crown Chemical Co.>"] };
		{ ORNG..INDENT..L["Apothecary Frye <Crown Chemical Co.>"] };
		{ GREN.." 1') "..L["Packleader Ivar Bloodfang"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10004 };
		{ GREN..INDENT..L["Deathstalker Commander Belmont"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 2') "..L["Haunted Stable Hand"]..L["L-Parenthesis"]..L["Teleporter"]..L["R-Parenthesis"], 10005 };
		{ GREN.." 3') "..L["Investigator Fezzen Brasstacks"]..L["L-Parenthesis"]..L["Love is in the Air"]..L["R-Parenthesis"], 10006 };
	};
	TheBastionOfTwilight = {
		ZoneName = { BZ["The Bastion of Twilight"] };
		Location = { BZ["Twilight Highlands"] };
		DungeonID = "315";
		DungeonHeroicID = "316";
		Acronym = L["BoT"];
		PlayerLimit = "10/25";
		JournalInstanceID = "72";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Halfus Wyrmbreaker", 156) };
		{ WHIT.." 2) "..Atlas_GetBossName("Theralion and Valiona", 157) };
		{ GREN..INDENT..L["Teleporter destination"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Ascendant Council", 158) };
		{ GREN..INDENT..L["Teleporter destination"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Cho'gall", 167) };
		{ WHIT.." 5) "..Atlas_GetBossName("Sinestra", 168)..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN.." 1') "..L["Teleporter"], 10003 };
	};
	TheDeadmines = {
		ZoneName = { BZ["The Deadmines"] };
		Location = { BZ["Westfall"] };
		DungeonID = "6";
		DungeonHeroicID = "326";
		Acronym = L["VC"];
		JournalInstanceID = "63";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Glubtok", 89) };
		{ WHIT.." 2) "..Atlas_GetBossName("Lumbering Oaf", 90, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Helix Gearbreaker", 90) };
		{ WHIT.." 3) "..Atlas_GetBossName("Foe Reaper 5000", 91) };
		{ WHIT.." 4) "..Atlas_GetBossName("Admiral Ripsnarl", 92) };
		{ WHIT..INDENT..Atlas_GetBossName("\"Captain\" Cookie", 93) };
		{ WHIT..INDENT..Atlas_GetBossName("Vanessa VanCleef", 95)..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ GREN.." 1') "..L["Lieutenant Horatio Laine"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"], 10003 };
		{ GREN..INDENT..L["Quartermaster Lewis <Quartermaster>"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Slinky Sharpshiv"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Kagtha"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Miss Mayhem"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Vend-O-Tron D-Luxe"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ GREN.." 2') "..L["Teleporter"], 10004 };
	};
	TheStonecore = {
		ZoneName = { BZ["The Stonecore"] };
		Location = { BZ["Deepholm"] };
		DungeonID = "307";
		DungeonHeroicID = "320";
		Acronym = L["TSC"];
		JournalInstanceID = "67";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Earthwarden Yrsa <The Earthen Ring>"] };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Corborus", 110) };
		{ WHIT.." 2) "..Atlas_GetBossName("Slabhide", 111) };
		{ WHIT.." 3) "..Atlas_GetBossName("Ozruk", 112) };
		{ WHIT.." 4) "..Atlas_GetBossName("High Priestess Azil", 113) };
		{ GREN.." 1') "..L["Teleporter"], 10003 };
	};
	TheVortexPinnacle = {
		ZoneName = { BZ["The Vortex Pinnacle"] };
		Location = { BZ["Uldum"] };
		DungeonID = "311";
		DungeonHeroicID = "319";
		Acronym = L["VP"];
		JournalInstanceID = "68";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Itesh"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Grand Vizier Ertan", 114) };
		{ WHIT.." 2) "..Atlas_GetBossName("Altairus", 115) };
		{ WHIT.." 3) "..Atlas_GetBossName("Asaad, Caliph of Zephyrs", 116) };
		{ GREN.." 1') "..L["Teleporter"], 10002 };
		{ GREN.." 2') "..L["Magical Brazier"], 10003 };
	};
	ThroneOfTheFourWinds = {
		ZoneName = { BZ["Throne of the Four Winds"] };
		Location = { BZ["Uldum"] };
		DungeonID = "317";
		DungeonHeroicID = "318";
		Acronym = L["TWT"];
		PlayerLimit = "10/25";
		JournalInstanceID = "74";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("The Conclave of Wind", 154) };
		{ WHIT..INDENT..Atlas_GetBossName("Anshal", 154, 1)..L["L-Parenthesis"]..L["West"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Nezir", 154, 2)..L["L-Parenthesis"]..L["North"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Rohash", 154, 3)..L["L-Parenthesis"]..L["East"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Al'Akir", 155) };
	};
	ThroneOfTheTides = {
		ZoneName = { BZ["The Abyssal Maw"]..L["Colon"]..BZ["Throne of the Tides"] };
		Location = { BZ["Abyssal Depths"]..L["Slash"]..BZ["The Abyssal Maw"] };
		DungeonID = "302";
		DungeonHeroicID = "324";
		Acronym = L["ToTT"];
		JournalInstanceID = "65";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Captain Taylor"]..L["L-Parenthesis"]..FACTION_ALLIANCE..L["R-Parenthesis"] };
		{ GREN..INDENT..L["Legionnaire Nazgrim"]..L["L-Parenthesis"]..FACTION_HORDE..L["R-Parenthesis"] };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Lady Naz'jar", 101) };
		{ WHIT.." 2) "..Atlas_GetBossName("Commander Ulthok, the Festering Prince", 102) };
		{ WHIT.." 3) "..Atlas_GetBossName("Erunak Stonespeaker").." & "..Atlas_GetBossName("Mindbender Ghur'sha", 103) };
		{ WHIT.." 4) "..Atlas_GetBossName("Ozumat", 104) };
		{ GREN..INDENT..L["Neptulon"] };
		{ GREN.." 1') "..L["Teleporter"], 10003 };
	};
	ZulAman = {
		ZoneName = { BZ["Zul'Aman"] };
		Location = { BZ["Ghostlands"] };
		DungeonID = "340";
		Acronym = L["ZA"];
		JournalInstanceID = "77";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Vol'jin"] };
		{ GREN..INDENT..L["Witch Doctor T'wansi"] };
		{ GREN..INDENT..L["Blood Guard Hakkuz <Darkspear Elite>"] };
		{ GREN..INDENT..L["Voodoo Pile"] };
		{ WHIT.." 1) "..Atlas_GetBossName("Akil'zon", 186) };
		{ GREN..INDENT..L["Bakkalzu"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Nalorakk", 187) };
		{ GREN..INDENT..L["Hazlek"] };
		{ GREN..INDENT..L["The Map of Zul'Aman"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Jan'alai", 188) };
		{ GREN..INDENT..L["Norkani"] };
		{ WHIT.." 4) "..Atlas_GetBossName("Halazzi", 189) };
		{ GREN..INDENT..L["Kasha"] };
		{ WHIT.." 5) "..Atlas_GetBossName("Hex Lord Malacrass", 190) };
		{ WHIT..INDENT..L["Thurg"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Gazakroth"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Lord Raadan"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Darkheart"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Alyson Antille"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Slither"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Fenstalker"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..L["Koragg"]..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Daakara", 191) };
		{ GREN.." 1') "..L["Zungam"], 10002 };
		{ GREN.." 2') "..L["Forest Frogs"], 10003 };
		{ GREN..INDENT..L["Eulinda <Reagents>"] };
		{ GREN..INDENT..L["Harald <Food Vendor>"] };
		{ GREN..INDENT..L["Arinoth"] };
		{ GREN..INDENT..L["Kaldrick"] };
		{ GREN..INDENT..L["Lenzo"] };
		{ GREN..INDENT..L["Mawago"] };
		{ GREN..INDENT..L["Melasong"] };
		{ GREN..INDENT..L["Melissa"] };
		{ GREN..INDENT..L["Micah"] };
		{ GREN..INDENT..L["Relissa"] };
		{ GREN..INDENT..L["Rosa"] };
		{ GREN..INDENT..L["Tyllan"] };
	};	
	ZulGurub = {
		ZoneName = { BZ["Zul'Gurub"] };
		Location = { BZ["Northern Stranglethorn"] };
		DungeonID = "334";
		Acronym = L["ZG"];
		JournalInstanceID = "76";
		Module = "Atlas_Cataclysm";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN.." 1') "..L["Meeting Stone"], 10002 };
		{ GREN.." 2') "..L["Briney Boltcutter <Blackwater Financial Interests>"], 10003 };
		{ GREN.." 3') "..L["Vehini <Assault Provisions>"], 10004 };
		{ GREN..INDENT..L["Overseer Blingbang"] };
		{ GREN..INDENT..L["Bloodslayer T'ara <Darkspear Veteran>"] };
		{ GREN..INDENT..L["Bloodslayer Vaena <Darkspear Veteran>"] };
		{ GREN..INDENT..L["Bloodslayer Zala <Darkspear Veteran>"] };
		{ GREN..INDENT..L["Helpful Jungle Monkey"] };
		{ GREN..INDENT..L["Voodoo Pile"] };
		{ WHIT.." 1) "..L["Venomancer Mauri <The Snake's Whisper>"], 10005 };
		{ GREN..INDENT..L["Zanzil's Cauldron of Toxic Torment"] };
		{ WHIT.." 2) "..L["Tiki Lord Mu'Loa"], 10006 };
		{ WHIT.." 3) "..L["Gub <Destroyer of Fish>"], 10007 };
		{ WHIT.." 4) "..L["Venomancer T'Kulu <The Toxic Bite>"], 10008 };
		{ GREN..INDENT..L["Zanzil's Cauldron of Toxic Torment"] };
		{ WHIT.." 5) "..Atlas_GetBossName("High Priest Venoxis", 175) };
		{ WHIT.." 6) "..L["Tor-Tun <The Slumberer>"], 10009 };
		{ WHIT.." 7) "..L["Kaulema the Mover"], 10010 };
		{ WHIT.." 8) "..L["Berserking Boulder Roller"], 10011 };
		{ GREN.." 4') "..L["Zanzil's Cauldron of Frostburn Formula"], 10012 };
		{ WHIT.." 9) "..Atlas_GetBossName("Bloodlord Mandokir", 176) };
		{ WHIT.."10) "..L["Mor'Lek the Dismantler"], 10013 };
		{ WHIT.."11) "..L["Witch Doctor Qu'in <Medicine Woman>"], 10014 };
		{ GREN.." 5') "..L["Zanza the Restless"], 10015 };
		{ WHIT.."12) "..BZ["The Cache of Madness"], 10016 };
		{ WHIT..INDENT..Atlas_GetBossName("Gri'lek", 177)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Hazza'rah", 178)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Renataki", 179)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Wushoolay", 180)..L["L-Parenthesis"]..L["Random"]..L["R-Parenthesis"] };
		{ WHIT.."13) "..L["Mortaxx <The Tolling Bell>"], 10017 };
		{ WHIT.."14) "..L["Tiki Lord Zim'wae"], 10018 };
		{ GREN..INDENT..L["Zanzil's Cauldron of Burning Blood"] };
		{ WHIT.."15) "..Atlas_GetBossName("High Priestess Kilnara", 181)..L["L-Parenthesis"]..L["Basement"]..L["R-Parenthesis"] };
		{ GREN.." 6') "..L["Zanzil's Cauldron of Frostburn Formula"], 10019 };
		{ WHIT.."16) "..Atlas_GetBossName("Zanzil", 184) };
		{ GREN..INDENT..L["Zanzil's Cauldron of Toxic Torment"] };
		{ GREN..INDENT..L["Zanzil's Cauldron of Frostburn Formula"] };
		{ GREN..INDENT..L["Zanzil's Cauldron of Burning Blood"] };
		{ WHIT.."17) "..Atlas_GetBossName("Jin'do the Godbreaker", 185) };
	};

--************************************************
-- Mists of Pandaria Instances
--************************************************

	GateoftheSettingSun = {
		ZoneName = { BZ["Gate of the Setting Sun"] };
		Location = { BZ["Dread Wastes"]..L["Slash"]..BZ["Vale of Eternal Blossoms"] };
		DungeonID = "631";
		DungeonHeroicID = "471";
		Acronym = L["GSS"];
		JournalInstanceID = "303";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN..INDENT..L["Bowmistress Li <Guard Captain>"] };
		{ BLUE.." B) "..L["Exit"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Saboteur Kip'tilak", 655) };
		{ WHIT.." 2) "..Atlas_GetBossName("Striker Ga'dok", 675)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Commander Ri'mok", 676) };
		{ WHIT.." 4) "..Atlas_GetBossName("Raigonn", 649) };
	};
	HeartofFear = {
		ZoneName = { BZ["Heart of Fear"] };
		Location = { BZ["Dread Wastes"] };
		DungeonID = "533";
		DungeonHeroicID = "534";
		Acronym = L["HoF"];
		PlayerLimit = "10/25";
		JournalInstanceID = "330";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Imperial Vizier Zor'lok", 745) };
		{ WHIT.." 2) "..Atlas_GetBossName("Blade Lord Ta'yak", 744) };
		{ WHIT.." 3) "..Atlas_GetBossName("Garalon", 713) };
		{ WHIT.." 4) "..Atlas_GetBossName("Wind Lord Mel'jarak", 741) };
		{ WHIT.." 5) "..Atlas_GetBossName("Amber-Shaper Un'sok", 737) };
		{ WHIT..INDENT..Atlas_GetBossName("Amber Monstrosity", 737, 2) };
		{ WHIT.." 6) "..Atlas_GetBossName("Grand Empress Shek'zeer", 743) };
	};
	MoguShanPalace = {
		ZoneName = { BZ["Mogu'shan Palace"] };
		Location = { BZ["Vale of Eternal Blossoms"] };
		DungeonID = "467";
		DungeonHeroicID = "519";
		Acronym = L["MP"];
		JournalInstanceID = "321";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Trial of the King", 708) };
		{ WHIT..INDENT..Atlas_GetBossName("Haiyan the Unstoppable", 708, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Kuai the Brute", 708, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Ming the Cunning", 708, 2) };
		{ WHIT.." 2) "..Atlas_GetBossName("Gekkan", 690) };
		{ WHIT.." 3) "..Atlas_GetBossName("Xin the Weaponmaster", 698) };
		{ GREN.." 1') "..L["Sinan the Dreamer"], 10003 };
	};
	MoguShanVaults = {
		ZoneName = { BZ["Mogu'shan Vaults"] };
		Location = { BZ["Kun-Lai Summit"] };
		DungeonID = "531";
		DungeonHeroicID = "532";
		Acronym = L["MV"];
		PlayerLimit = "10/25";
		JournalInstanceID = "317";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("The Stone Guard", 679) };
		{ WHIT..INDENT..Atlas_GetBossName("Amethyst Guardian", 679, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Cobalt Guardian", 679, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Jade Guardian", 679, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Jasper Guardian", 679, 4) };
		{ WHIT.." 2) "..Atlas_GetBossName("Feng the Accursed", 689) };
		{ WHIT.." 3) "..Atlas_GetBossName("Gara'jal the Spiritbinder", 682) };
		{ WHIT.." 4) "..Atlas_GetBossName("The Spirit Kings", 687) };
		{ WHIT..INDENT..Atlas_GetBossName("Meng the Demented", 687, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Qiang the Merciless", 687, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Subetai the Swift", 687, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Zian of the Endless Shadow", 687, 4) };
		{ WHIT.." 5) "..Atlas_GetBossName("Elegon", 726) };
		{ WHIT.." 6) "..Atlas_GetBossName("Will of the Emperor", 677) };
		{ WHIT..INDENT..Atlas_GetBossName("Jan-xi", 677, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Qin-xi", 677, 2) };
	};
	ScarletHalls = {
		ZoneName = { BZ["Scarlet Monastery"]..L["Colon"]..BZ["Scarlet Halls"] };
		Location = { BZ["Tirisfal Glades"] };
		DungeonID = "163";
		DungeonHeroicID = "473";
		Acronym = L["Halls"];
		JournalInstanceID = "311";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..L["Commander Lindon"], 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Houndmaster Braun", 660) };
		{ WHIT.." 3) "..Atlas_GetBossName("Armsmaster Harlan", 654) };
		{ WHIT.." 4) "..Atlas_GetBossName("Flameweaver Koegler", 656) };
		{ GREN.." 1') "..L["Hooded Crusader"], 10003 };
		{ INDENT..GREN..L["Bucket of Meaty Dog Food"] };
		{ GREN.." 2') "..L["Reinforced Archery Target"], 10004 };
		{ GREN.." 3') "..L["Bucket of Meaty Dog Food"], 10005 };
	};
	ScarletMonastery = {
		ZoneName = { BZ["Scarlet Monastery"]..L["Colon"]..BZ["Scarlet Monastery"] };
		Location = { BZ["Tirisfal Glades"] };
		DungeonID = "164";
		DungeonHeroicID = "474";
		Acronym = L["SM"];
		JournalInstanceID = "316";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ GREN.." 1') "..L["Hooded Crusader"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Thalnos the Soulrender", 688) };
		{ WHIT.." 2) "..Atlas_GetBossName("Brother Korloff", 671) };
		{ WHIT.." 3) "..Atlas_GetBossName("High Inquisitor Whitemane", 674) };
		{ WHIT..INDENT..Atlas_GetBossName("Commander Durand", 674, 2) };
		{ ORNG.." 1) "..Atlas_GetBossName("Headless Horseman")..L["L-Parenthesis"]..L["Hallow's End"]..L["R-Parenthesis"], 10003 };
	};
	Scholomance = {
		ZoneName = { BZ["Scholomance"] };
		Location = { BZ["Western Plaguelands"] };
		DungeonID = "2";
		DungeonHeroicID = "472";
		Acronym = L["Scholo"];
		JournalInstanceID = "246";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-D) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Instructor Chillheart", 659) };
		{ WHIT..INDENT..L["Instructor Chillheart's Phylactery"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Jandice Barov", 663) };
		{ WHIT.." 3) "..Atlas_GetBossName("Rattlegore", 665) };
		{ WHIT.." 4) "..Atlas_GetBossName("Lilian Voss", 666) };
		{ WHIT.." 5) "..L["Professor Slate"], 10003 };
		{ GREN..INDENT..L["Polyformic Acid Potion"] };
		{ WHIT.." 6) "..Atlas_GetBossName("Darkmaster Gandling", 684) };
		{ GREN.." 1') "..L["Talking Skull"], 10004 };
		{ GREN.." 2') "..L["In the Shadow of the Light"], 10005 };
		{ GREN.." 3') "..L["Kel'Thuzad's Deep Knowledge"], 10006 };
		{ GREN.." 4') "..L["Forbidden Rites and other Rituals Necromantic"], 10007 };
		{ GREN.." 5') "..L["Coffer of Forgotten Souls"], 10008 };
		{ GREN.." 6') "..L["The Dark Grimoire"], 10009 };
	};
	ShadoPanMonasteryA = {
		ZoneName = { BZ["Shado-Pan Monastery"]..L["MapA"] };
		Location = { BZ["Kun-Lai Summit"] };
		DungeonID = "466";
		DungeonHeroicID = "470";
		Acronym = L["SPM"];
		JournalInstanceID = "312";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." B-H) "..L["Connection"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Gu Cloudstrike", 673) };
		{ WHIT..INDENT..Atlas_GetBossName("Azure Serpent", 673, 2) };
		{ WHIT.." 4) "..Atlas_GetBossName("Taran Zhu", 686) };
	};
	ShadoPanMonasteryB = {
		ZoneName = { BZ["Shado-Pan Monastery"]..L["MapB"] };
		Location = { BZ["Kun-Lai Summit"] };
		DungeonID = "466";
		DungeonHeroicID = "470";
		Acronym = L["SPM"];
		JournalInstanceID = "312";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-H) "..L["Connection"], 10002 };
		{ WHIT.." 2) "..Atlas_GetBossName("Master Snowdrift", 657) };
		{ WHIT.." 3) "..Atlas_GetBossName("Sha of Violence", 685) };
		{ GREN.." 1') "..L["Ban Bearheart"], 10003 };
	};
	SiegeofNiuzaoTempleA = {
		ZoneName = { BZ["Siege of Niuzao Temple"]..L["MapA"] };
		Location = { BZ["Townlong Steppes"] };
		DungeonID = "554";
		Acronym = L["SNT"];
		JournalInstanceID = "324";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Vizier Jin'bak", 693) };
		{ GREN.." 1') "..L["Shado-Master Chum Kiu"], 10003 };
	};
	SiegeofNiuzaoTempleB = {
		ZoneName = { BZ["Siege of Niuzao Temple"]..L["MapB"] };
		Location = { BZ["Townlong Steppes"] };
		DungeonID = "554";
		Acronym = L["SNT"];
		JournalInstanceID = "324";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." C) "..L["Connection"], 10001 };
		{ WHIT.." 2) "..Atlas_GetBossName("Commander Vo'jak", 738) };
		{ WHIT.." 3) "..Atlas_GetBossName("General Pa'valak", 692) };
		{ WHIT.." 4) "..Atlas_GetBossName("Wing Leader Ner'onok", 727) };
	};
	SiegeofOrgrimmarA = {
		ZoneName = { BZ["Siege of Orgrimmar"]..L["MapA"] };
		Location = { BZ["Vale of Eternal Blossoms"]..L["Slash"]..BZ["Orgrimmar"] };
		DungeonID = "714";
		DungeonHeroicID = "715";
		Acronym = L["SoO"];
		PlayerLimit = "10-30";
		JournalInstanceID = "369";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-D) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Immerseus", 852) };
		{ WHIT.." 3) "..Atlas_GetBossName("Norushen", 866) };
		{ WHIT..INDENT..Atlas_GetBossName("Amalgam of Corruption", 866, 2) };
		{ WHIT.." 4) "..Atlas_GetBossName("Sha of Pride", 867) };
	};
	SiegeofOrgrimmarB = {
		ZoneName = { BZ["Siege of Orgrimmar"]..L["MapB"] };
		Location = { BZ["Vale of Eternal Blossoms"]..L["Slash"]..BZ["Orgrimmar"] };
		DungeonID = "714";
		DungeonHeroicID = "715";
		Acronym = L["SoO"];
		PlayerLimit = "10-30";
		JournalInstanceID = "369";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." B-C) "..L["Connection"], 10001 };
		{ WHIT.." 2) "..Atlas_GetBossName("The Fallen Protectors", 849) };
		{ WHIT..INDENT..Atlas_GetBossName("He Softfoot", 849, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Rook Stonetoe", 849, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Sun Tenderheart", 849, 3) };
	};
	SiegeofOrgrimmarC = {
		ZoneName = { BZ["Siege of Orgrimmar"]..L["MapC"] };
		Location = { BZ["Vale of Eternal Blossoms"]..L["Slash"]..BZ["Orgrimmar"] };
		DungeonID = "714";
		DungeonHeroicID = "715";
		Acronym = L["SoO"];
		PlayerLimit = "10-30";
		JournalInstanceID = "369";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." D-E) "..L["Connection"], 10001 };
		{ WHIT.." 5) "..Atlas_GetBossName("Galakras", 868) };
		{ WHIT.." 6) "..Atlas_GetBossName("Iron Juggernaut", 864) };
		{ WHIT.." 7) "..Atlas_GetBossName("Kor'kron Dark Shaman", 856) };
		{ WHIT..INDENT..Atlas_GetBossName("Earthbreaker Haromm", 856, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Wavebinder Kardris", 856, 2) };
	};
	SiegeofOrgrimmarD = {
		ZoneName = { BZ["Siege of Orgrimmar"]..L["MapD"] };
		Location = { BZ["Vale of Eternal Blossoms"]..L["Slash"]..BZ["Orgrimmar"] };
		DungeonID = "714";
		DungeonHeroicID = "715";
		Acronym = L["SoO"];
		PlayerLimit = "10-30";
		JournalInstanceID = "369";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." E) "..L["Connection"], 10001 };
		{ WHIT.." 8) "..Atlas_GetBossName("General Nazgrim", 850) };
		{ WHIT.." 9) "..Atlas_GetBossName("Malkorok", 846) };
		{ WHIT.."10) "..Atlas_GetBossName("Spoils of Pandaria", 870) };
		{ WHIT..INDENT..Atlas_GetBossName("Secured Stockpile of Pandaren Spoils", 870, 1) };
		{ WHIT.."11) "..Atlas_GetBossName("Thok the Bloodthirsty", 851) };
		{ WHIT..INDENT..Atlas_GetBossName("Kor'kron Jailer", 851, 2) };
		{ WHIT.."12) "..Atlas_GetBossName("Siegecrafter Blackfuse", 865) };
		{ WHIT.."13) "..Atlas_GetBossName("Paragons of the Klaxxi", 853) };
		{ WHIT..INDENT..Atlas_GetBossName("Hisek the Swarmkeeper", 853, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Iyyokuk the Lucid", 853, 8) };
		{ WHIT..INDENT..Atlas_GetBossName("Ka'roz the Locust", 853, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Kaz'tik the Manipulator", 853, 5) };
		{ WHIT..INDENT..Atlas_GetBossName("Kil'ruk the Wind-Reaver", 853, 9) };
		{ WHIT..INDENT..Atlas_GetBossName("Korven the Prime", 853, 4) };
		{ WHIT..INDENT..Atlas_GetBossName("Rik'kal the Dissector", 853, 7) };
		{ WHIT..INDENT..Atlas_GetBossName("Skeer the Bloodseeker", 853, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Xaril the Poisoned Mind", 853, 6) };
		{ WHIT.."14) "..Atlas_GetBossName("Garrosh Hellscream", 869) };
	};
	StormstoutBrewery = {
		ZoneName = { BZ["Stormstout Brewery"] };
		Location = { BZ["Valley of the Four Winds"] };
		DungeonID = "465";
		DungeonHeroicID = "469";
		Acronym = L["SB"];
		JournalInstanceID = "302";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-E) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Ook-Ook", 668) };
		{ WHIT.." 2) "..Atlas_GetBossName("Hoptallus", 669) };
		{ WHIT.." 3) "..Atlas_GetBossName("Yan-Zhu the Uncasked", 670) };
		{ GREN.." 1') "..L["Auntie Stormstout"], 10003 };
		{ GREN..INDENT..L["Chen Stormstout"] };
	};
	TempleOfTheJadeSerpent = {
		ZoneName = { BZ["Temple of the Jade Serpent"] };
		Location = { BZ["The Jade Forest"] };
		DungeonID = "464";
		DungeonHeroicID = "468";
		Acronym = L["TJS"];
		JournalInstanceID = "313";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Wise Mari", 672) };
		{ WHIT.." 2) "..Atlas_GetBossName("Lorewalker Stonestep", 664) };
		{ WHIT.." 3) "..Atlas_GetBossName("Liu Flameheart", 658) };
		{ WHIT.." 4) "..Atlas_GetBossName("Sha of Doubt", 335) };
		{ GREN.." 1') "..L["Master Windstrong"], 10002 };
		{ GREN..INDENT..L["Priestess Summerpetal"] };
	};
	TerraceofEndlessSpring = {
		ZoneName = { BZ["Terrace of Endless Spring"] };
		Location = { BZ["The Veiled Stair"] };
		DungeonID = "535";
		DungeonHeroicID = "536";
		Acronym = L["TES"];
		PlayerLimit = "10/25";
		JournalInstanceID = "320";
		Module = "Atlas_MistsofPandaria";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Protectors of the Endless", 683) };
		{ WHIT..INDENT..Atlas_GetBossName("Elder Asani", 683, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Elder Regail", 683, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Protector Kaolan", 683, 1) };
		{ WHIT.." 2) "..Atlas_GetBossName("Tsulong", 742) };
		{ WHIT.." 3) "..Atlas_GetBossName("Lei Shi", 729) };
		{ WHIT.." 4) "..Atlas_GetBossName("Sha of Fear", 709) };
	};
	ThroneofThunderA = {
		ZoneName = { BZ["Throne of Thunder"]..L["MapA"] };
		Location = { BZ["Isle of Thunder"] };
		DungeonID = "633";
		DungeonHeroicID = "634";
		Acronym = L["ToT"];
		PlayerLimit = "10/25";
		JournalInstanceID = "362";
		Module = "Atlas_MistsofPandaria";
		{ ORNG..REPUTATION..L["Colon"]..BF["Shado-Pan Assault"] };
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Jin'rokh the Breaker", 827) };
		{ WHIT.." 2) "..Atlas_GetBossName("Horridon", 819) };
		{ WHIT.." 3) "..Atlas_GetBossName("Council of Elders", 816) };
		{ WHIT..INDENT..Atlas_GetBossName("Frost King Malakk", 816, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("High Priestess Mar'li", 816, 4) };
		{ WHIT..INDENT..Atlas_GetBossName("Kazra'jin", 816, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Sul the Sandcrawler", 816, 2) };
		{ ORNG.." 1) "..L["Monara <The Last Queen>"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10003 };
		{ ORNG.." 2) "..L["No'ku Stormsayer <Lord of Tempest>"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10004 };
	};
	ThroneofThunderB = {
		ZoneName = { BZ["Throne of Thunder"]..L["MapB"] };
		Location = { BZ["Isle of Thunder"] };
		DungeonID = "633";
		DungeonHeroicID = "634";
		Acronym = L["ToT"];
		PlayerLimit = "10/25";
		JournalInstanceID = "362";
		Module = "Atlas_MistsofPandaria";
		{ ORNG..REPUTATION..L["Colon"]..BF["Shado-Pan Assault"] };
		{ BLUE.." B-C) "..L["Connection"], 10001 };
		{ WHIT.." 4) "..Atlas_GetBossName("Tortos", 825) };
		{ WHIT.." 5) "..Atlas_GetBossName("Megaera", 821) };
		{ WHIT.." 6) "..Atlas_GetBossName("Ji-Kun", 828) };
		{ ORNG.." 3) "..L["Rocky Horror"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10002 };
	};
	ThroneofThunderC = {
		ZoneName = { BZ["Throne of Thunder"]..L["MapC"] };
		Location = { BZ["Isle of Thunder"] };
		DungeonID = "633";
		DungeonHeroicID = "634";
		Acronym = L["ToT"];
		PlayerLimit = "10/25";
		JournalInstanceID = "362";
		Module = "Atlas_MistsofPandaria";
		{ ORNG..REPUTATION..L["Colon"]..BF["Shado-Pan Assault"] };
		{ BLUE.." C-E) "..L["Connection"], 10001 };
		{ WHIT.." 7) "..Atlas_GetBossName("Durumu the Forgotten", 818) };
		{ ORNG..INDENT..L["Focused Eye"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"] };
		{ ORNG..INDENT..L["Unblinking Eye"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"] };
		{ WHIT.." 8) "..Atlas_GetBossName("Primordius", 820) };
		{ WHIT.." 9) "..Atlas_GetBossName("Dark Animus", 824) };
		{ ORNG.." 4) "..L["Archritualist Kelada"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10002 };
		{ ORNG.." 5) "..L["Flesh'rok the Diseased <Primordial Saurok Horror>"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10003 };
	};
	ThroneofThunderD = {
		ZoneName = { BZ["Throne of Thunder"]..L["MapD"] };
		Location = { BZ["Isle of Thunder"] };
		DungeonID = "633";
		DungeonHeroicID = "634";
		Acronym = L["ToT"];
		PlayerLimit = "10/25";
		JournalInstanceID = "362";
		Module = "Atlas_MistsofPandaria";
		{ ORNG..REPUTATION..L["Colon"]..BF["Shado-Pan Assault"] };
		{ BLUE.." D-F) "..L["Connection"], 10001 };
		{ WHIT.." 10) "..Atlas_GetBossName("Iron Qon", 817) };
		{ WHIT..INDENT..Atlas_GetBossName("Dam'ren", 817, 4) };
		{ WHIT..INDENT..Atlas_GetBossName("Quet'zal", 817, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Ro'shak", 817, 2) };
		{ WHIT.." 11) "..Atlas_GetBossName("Twin Consorts", 829) };
		{ WHIT..INDENT..Atlas_GetBossName("Lu'lin", 829, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Suen", 829, 2) };
		{ WHIT.." 12) "..Atlas_GetBossName("Lei Shen", 832) };
		{ WHIT.." 13) "..Atlas_GetBossName("Ra-den", 831)..L["L-Parenthesis"]..L["Heroic"]..L["R-Parenthesis"] };
		{ ORNG.." 6) "..L["Zao'cho <The Emperor's Shield>"]..L["L-Parenthesis"]..L["Rare"]..L["R-Parenthesis"], 10002 };
	};

--************************************************
-- Warlords of Draenor Instances
--************************************************
	Auchindoun = {
		ZoneName = { BZ["Auchindoun"] };
		Location = { BZ["Talador"] };
		DungeonID = "820";
		DungeonHeroicID = "845";
		Acronym = L["Auch"]; -- taken from BC
		JournalInstanceID = "547";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Vigilant Kaathar", 1185) };
		{ WHIT.." 2) "..Atlas_GetBossName("Soulbinder Nyami", 1186) };
		{ WHIT.." 3) "..Atlas_GetBossName("Azzakel", 1216) };
		{ WHIT..INDENT..Atlas_GetBossName("Blazing Trickster", 1216, 4) };
		{ WHIT..INDENT..Atlas_GetBossName("Cackling Pyromaniac", 1216, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Felguard", 1216, 3) };
		{ WHIT.." 4) "..Atlas_GetBossName("Teron'gor", 1225) };
	};
	BlackrockFoundryA = {
		ZoneName = { BZ["Blackrock Foundry"]..L["MapA"] };
		Location = { BZ["Gorgrond"] };
		DungeonID = "898";
		DungeonHeroicID = "900";
		Acronym = L["BRF"];
		PlayerLimit = "10-30";
		JournalInstanceID = "457";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Gruul", 1161)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 2) "..Atlas_GetBossName("Oregorger the Devourer", 1202, 1)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT.." 3) "..Atlas_GetBossName("Beastlord Darmac", 1122) };
		{ WHIT..INDENT..Atlas_GetBossName("Cruelfang", 1122, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Dreadwing", 1122, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Faultline", 1122, 5) };
		{ WHIT..INDENT..Atlas_GetBossName("Ironcrusher", 1122, 4) };
		{ WHIT.." 6) "..Atlas_GetBossName("Operator Thogar", 1147) };
		{ WHIT.." 7) "..Atlas_GetBossName("The Blast Furnace", 1154)..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Bellows Operator", 1154, 4) };
		{ WHIT..INDENT..Atlas_GetBossName("Firecaller", 1154, 6) };
		{ WHIT..INDENT..Atlas_GetBossName("Foreman Feldspar", 1154, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Furnace Engineer", 1154, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Heart of the Mountain", 1154, 8) };
		{ WHIT..INDENT..Atlas_GetBossName("Primal Elementalist", 1154, 5) };
		{ WHIT..INDENT..Atlas_GetBossName("Security Guard", 1154, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Slag Elemental", 1154, 7) };
		{ WHIT.." 10) "..Atlas_GetBossName("Blackhand", 959)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
	};
	BlackrockFoundryB = {
		ZoneName = { BZ["Blackrock Foundry"]..L["MapB"] };
		Location = { BZ["Gorgrond"] };
		DungeonID = "898";
		DungeonHeroicID = "900";
		Acronym = L["BRF"];
		PlayerLimit = "10-30";
		JournalInstanceID = "457";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." C) "..L["Connection"], 10001 };
		{ WHIT.." 4) "..Atlas_GetBossName("Flamebender Ka'graz", 1123) };
		{ WHIT..INDENT..Atlas_GetBossName("Aknor Steelbringer", 1123, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Cinder Wolf", 1123, 3) };
		{ WHIT.." 5) "..Atlas_GetBossName("Hans'gar and Franzok", 1155) };
		{ WHIT..INDENT..Atlas_GetBossName("Franzok", 1155, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Hans'gar", 1155, 2) };
		{ WHIT.." 8) "..Atlas_GetBossName("Kromog", 1162) };
		{ WHIT.." 9) "..Atlas_GetBossName("The Iron Maidens", 1203) };
		{ WHIT..INDENT..Atlas_GetBossName("Admiral Gar'an", 1203, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Enforcer Sorka", 1203, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Marak the Blooded", 1203, 3) };
	};
	BloodmaulSlagMines = {
		ZoneName = { BZ["Bloodmaul Slag Mines"] };
		Location = { BZ["Frostfire Ridge"] };
		DungeonID = "787";
		DungeonHeroicID = "859";
		Acronym = L["BSM"];
		JournalInstanceID = "385";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Magmolatus", 893) };
		{ WHIT..INDENT..Atlas_GetBossName("Forgemaster Gog'duh", 893, 1) };
		{ WHIT.." 2) "..Atlas_GetBossName("Slave Watcher Crushto", 888) };
		{ WHIT.." 3) "..Atlas_GetBossName("Roltall", 887) };
		{ WHIT.." 4) "..Atlas_GetBossName("Gug'rokk", 889) };

	};
	TheEverbloomA = {
		ZoneName = { BZ["The Everbloom"]..L["MapA"] };
		Location = { BZ["Gorgrond"] };
		DungeonID = "824";
		DungeonHeroicID = "866";
		Acronym = L["EB"];
		JournalInstanceID = "556";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"].. L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Witherbark", 1214) };
		{ WHIT.." 2) "..Atlas_GetBossName("Ancient Protectors", 1207) };
		{ WHIT..INDENT..Atlas_GetBossName("Dulhu", 1207, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Earthshaper Telu", 1207, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Life Warden Gola", 1207, 3) };
		{ WHIT.." 3) "..Atlas_GetBossName("Archmage Sol", 1208) };
		{ WHIT.." 4) "..Atlas_GetBossName("Xeri'tac", 1209)..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"] };
	};
	TheEverbloomB = {
		ZoneName = { BZ["The Everbloom"]..L["MapB"] };
		Location = { BZ["Gorgrond"] };
		DungeonID = "824";
		DungeonHeroicID = "866";
		Acronym = L["EB"];
		JournalInstanceID = "556";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." B) "..L["Connection"].. L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10001 };
		{ WHIT.." 5) "..Atlas_GetBossName("Yalnu", 1210) };
	};
	GrimrailDepot = {
		ZoneName = { BZ["Grimrail Depot"] };
		Location = { BZ["Gorgrond"] };
		DungeonID = "822";
		DungeonHeroicID = "858";
		Acronym = L["GD"];
		JournalInstanceID = "536";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Train Ride"]..L["L-Parenthesis"]..L["Event"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Rocketspark and Borka", 1138) };
		{ WHIT..INDENT..Atlas_GetBossName("Borka the Brute", 1138, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Railmaster Rocketspark", 1138, 1) };
		{ WHIT.." 2) "..Atlas_GetBossName("Nitrogg Thundertower", 1163) };
		{ WHIT..INDENT..Atlas_GetBossName("Assault Cannon", 1163, 2) };
		{ WHIT.." 3) "..Atlas_GetBossName("Skylord Tovra", 1133) };
	};
	HellfireA = {
		ZoneName = { BZ["Hellfire Citadel"]..L["MapA"] };
		Location = { BZ["Tanaan Jungle"] };
		DungeonID = "987";
		DungeonHeroicID = "989";
		Acronym = L["HC"];
		PlayerLimit = "10-30";
		JournalInstanceID = "669";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Hellfire Assault", 1426) };			-- 1
		{ WHIT..INDENT..Atlas_GetBossName("Siegemaster Mar'tak", 1426, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Hellfire Cannon", 1426, 2) };
		{ WHIT.." 2) "..Atlas_GetBossName("Iron Reaver", 1425) };			-- 2
	};
	HellfireB = {
		ZoneName = { BZ["Hellfire Citadel"]..L["MapB"] };
		Location = { BZ["Tanaan Jungle"] };
		DungeonID = "987";
		DungeonHeroicID = "989";
		Acronym = L["HC"];
		PlayerLimit = "10-30";
		JournalInstanceID = "669";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." B/C) "..L["Connection"], 10001 };
		{ WHIT.." 3) "..Atlas_GetBossName("Gorefiend", 1372) };				-- 3
		{ WHIT.." 4) "..Atlas_GetBossName("Kilrogg Deadeye", 1396) };			-- 4
		{ WHIT.." 5) "..Atlas_GetBossName("Hellfire High Council", 1432) };		-- 5
		{ WHIT..INDENT..Atlas_GetBossName("Dia Darkwhisper", 1432, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Gurtogg Bloodboil", 1432, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Blademaster Jubei'thos", 1432, 2) };
	};
	HellfireC = {
		ZoneName = { BZ["Hellfire Citadel"]..L["MapC"] };
		Location = { BZ["Tanaan Jungle"] };
		DungeonID = "987";
		DungeonHeroicID = "989";
		Acronym = L["HC"];
		PlayerLimit = "10-30";
		JournalInstanceID = "669";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." C) "..L["Connection"], 10001 };
		{ WHIT.." 6) "..Atlas_GetBossName("Kormrok", 1392) };				-- 6
	};
	HellfireD = {
		ZoneName = { BZ["Hellfire Citadel"]..L["MapD"] };
		Location = { BZ["Tanaan Jungle"] };
		DungeonID = "987";
		DungeonHeroicID = "989";
		Acronym = L["HC"];
		PlayerLimit = "10-30";
		JournalInstanceID = "669";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." B/C) "..L["Connection"], 10001 };
		{ WHIT.." 7) "..Atlas_GetBossName("Shadow-Lord Iskar", 1433) };			-- 7
		{ WHIT..INDENT..Atlas_GetBossName("Fel Raven", 1433, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Shadowfel Warden", 1433, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Corrupted Priest of Terokk", 1433, 4) };
		{ WHIT..INDENT..Atlas_GetBossName("Illusionary Outcast", 1433, 5) };
		{ WHIT.." 8) "..Atlas_GetBossName("Fel Lord Zakuun", 1391) };			-- 8
		{ WHIT.." 9) "..Atlas_GetBossName("Xhul'horac", 1447) };			-- 9
		{ WHIT.."10) "..Atlas_GetBossName("Socrethar the Eternal", 1427) };		-- 10
		{ WHIT.."11) "..Atlas_GetBossName("Tyrant Velhari", 1394) };			-- 11
	};
	HellfireE = {
		ZoneName = { BZ["Hellfire Citadel"]..L["MapE"] };
		Location = { BZ["Tanaan Jungle"] };
		DungeonID = "987";
		DungeonHeroicID = "989";
		Acronym = L["HC"];
		PlayerLimit = "10-30";
		JournalInstanceID = "669";
		Module = "Atlas_WarlordsofDraenor";
		{ WHIT.."12) "..Atlas_GetBossName("Mannoroth", 1395) };				-- 12
	};
	HellfireF = { 
		ZoneName = { BZ["Hellfire Citadel"]..L["MapF"] };
		Location = { BZ["Tanaan Jungle"] };
		DungeonID = "987";
		DungeonHeroicID = "989";
		Acronym = L["HC"];
		PlayerLimit = "10-30";
		JournalInstanceID = "669";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." D) "..L["Connection"], 10001 };
		{ WHIT.."13) "..Atlas_GetBossName("Archimonde", 1438) };			-- 13 
	};
	HighmaulA = {
		ZoneName = { BZ["Highmaul"]..L["MapA"] };
		Location = { BZ["Nagrand"] };
		DungeonID = "895";
		DungeonHeroicID = "897";
		Acronym = L["HM"];
		PlayerLimit = "10-30";
		JournalInstanceID = "477";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"]..L["L-Parenthesis"]..L["Lower"]..L["R-Parenthesis"], 10001 };
		{ BLUE.." B) "..L["Connection"].. L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Kargath Bladefist", 1128) };
		{ WHIT.." 2) "..Atlas_GetBossName("The Butcher", 971) };
		{ WHIT.." 3) "..Atlas_GetBossName("Tectus", 1195) };
		{ WHIT.." 4) "..Atlas_GetBossName("Brackenspore", 1196) };
		{ WHIT..INDENT..Atlas_GetBossName("Fungal Flesh-Eater", 1196, 2) };
	};
	HighmaulB = {
		ZoneName = { BZ["Highmaul"]..L["MapB"] };
		Location = { BZ["Nagrand"] };
		DungeonID = "895";
		DungeonHeroicID = "897";
		Acronym = L["HM"];
		PlayerLimit = "10-30";
		JournalInstanceID = "477";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." B-D) "..L["Connection"], 10001 };
		{ WHIT.." 5) "..Atlas_GetBossName("Twin Ogron", 1148) };
		{ WHIT..INDENT..Atlas_GetBossName("Phemos", 1148, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Pol", 1148, 1) };
		{ WHIT.." 6) "..Atlas_GetBossName("Ko'ragh", 1153) };
		{ WHIT.." 7) "..Atlas_GetBossName("Imperator Mar'gok", 1197) };
	};
	IronDocks = {
		ZoneName = { BZ["Iron Docks"] };
		Location = { BZ["Gorgrond"] };
		DungeonID = "821";
		DungeonHeroicID = "857";
		Acronym = L["ID"];
		JournalInstanceID = "558";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Fleshrender Nok'gar", 1235) };
		{ WHIT..INDENT..Atlas_GetBossName("Dreadfang", 1235, 2) };
		{ WHIT.." 2) "..Atlas_GetBossName("Grimrail Enforcers", 1236) };
		{ WHIT..INDENT..Atlas_GetBossName("Ahri'ok Dugru", 1236, 1) };
		{ WHIT..INDENT..Atlas_GetBossName("Makogg Emberblade", 1236, 2) };
		{ WHIT..INDENT..Atlas_GetBossName("Nesa \"Hightower\" Nox", 1236, 3) };
		{ WHIT.." 3) "..Atlas_GetBossName("Oshir", 1237) };
		{ WHIT.." 4) "..Atlas_GetBossName("Skulloc", 1238) };
		{ WHIT..INDENT..Atlas_GetBossName("Koramar", 1238, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Zoggosh", 1238, 2) };
	};
	ShadowmoonBurialGrounds = {
		ZoneName = { BZ["Shadowmoon Burial Grounds"] };
		Location = { BZ["Shadowmoon Valley"] };
		DungeonID = "783";
		DungeonHeroicID = "784";
		Acronym = L["SBG"];
		JournalInstanceID = "537";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B) "..L["Connection"].. L["L-Parenthesis"]..L["Portal"]..L["R-Parenthesis"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Sadana Bloodfury", 1139) };
		{ WHIT.." 2) "..Atlas_GetBossName("Nhallish", 1168) };
		{ WHIT.." 3) "..Atlas_GetBossName("Bonemaw", 1140) };
		{ WHIT..INDENT..Atlas_GetBossName("Carrion Worm", 1140, 2) };
		{ WHIT.." 4) "..Atlas_GetBossName("Ner'zhul", 1160) };
		{ WHIT..INDENT..Atlas_GetBossName("Ritual of Bones", 1160, 2) };
	};
	Skyreach = {
		ZoneName = { BZ["Skyreach"] };
		Location = { BZ["Spires of Arak"] };
		DungeonID = "779";
		DungeonHeroicID = "780";
		Acronym = L["SR"];
		JournalInstanceID = "476";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ WHIT.." 1) "..Atlas_GetBossName("Ranjit", 965) };
		{ WHIT.." 2) "..Atlas_GetBossName("Araknath", 966) };
		{ WHIT..INDENT..Atlas_GetBossName("Arakkoa Sun Construct Prototype", 966, 2) };
		{ WHIT.." 3) "..Atlas_GetBossName("Rukhran", 967) };
		{ WHIT..INDENT..Atlas_GetBossName("Solar Flare", 967, 2) };
		{ WHIT.." 4) "..Atlas_GetBossName("High Sage Viryx", 968)..L["L-Parenthesis"]..L["Upper"]..L["R-Parenthesis"] };
		{ WHIT..INDENT..Atlas_GetBossName("Arakkoa Shield Construct", 968, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Arakkoa Solar Zealot", 968, 2) };
	};
	UpperBlackrockSpire = {
		ZoneName = { BZ["Blackrock Mountain"]..L["Colon"]..BZ["Upper Blackrock Spire"] };
		Location = { BZ["Searing Gorge"]..L["Slash"]..BZ["Burning Steppes"] };
		DungeonID = "828";
		DungeonHeroicID = "860";
		Acronym = L["UBRS"];
		JournalInstanceID = "559";
		Module = "Atlas_WarlordsofDraenor";
		{ BLUE.." A) "..L["Entrance"], 10001 };
		{ BLUE.." B-C) "..L["Connection"], 10002 };
		{ WHIT.." 1) "..Atlas_GetBossName("Orebender Gor'ashan", 1226) };
		{ WHIT.." 2) "..Atlas_GetBossName("Kyrak", 1227) };
		{ WHIT..INDENT..Atlas_GetBossName("Drakonid Monstrosity", 1227, 2) };
		{ WHIT.." 3) "..Atlas_GetBossName("Commander Tharbek", 1228) };
		{ WHIT..INDENT..Atlas_GetBossName("Black Iron Guard", 1228, 3) };
		{ WHIT..INDENT..Atlas_GetBossName("Ironbarb Skyreaver", 1228, 2) };
		{ WHIT.." 4) "..Atlas_GetBossName("Ragewing the Untamed", 1229) };
		{ WHIT..INDENT..Atlas_GetBossName("Ragewind Whelp", 1229, 2) };
		{ WHIT.." 5) "..Atlas_GetBossName("Warlord Zaela", 1234) };
	};
};
