﻿-- $Id: Atlas-deDE.lua 31 2016-06-23 07:30:35Z arith $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2016 - Arith Hsu, Atlas Team <atlas.addon@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas", "deDE", false);
-- Localize file must set above to false

-- Deutsche Lokalisierung (German, deDE)
-- Letztes Update: 29.10.2014

if ( GetLocale() == "deDE" ) then
-- Define the leading strings to be ignored while sorting
-- Ex: The Stockade
AtlasSortIgnore = {
	"der (.+)",
	"die (.+)",
	"das (.+)"
}

-- Syntax: ["real_zone_name"] = "localized map zone name"
AtlasZoneSubstitutions = {
	["Ahn'Qiraj"] = "Tempel von Ahn'Qiraj";
	["Der Tempel von Atal'Hakkar"] = "Versunkener Tempel";
--	["Throne of Tides"] = "The Abyssal Maw: Throne of the Tides";
};
end


if L then
L["Abandonded Mole Machine"] = "Verlassene Maulwurfmaschine"
L["Abbendis"] = "Abbendis"
L["AC"] = "Krypta"
L["Acride <Scarshield Legion>"] = "Acride <Schmetterschildlegion>"
L["Adult"] = "Erwachsen"
L["Advance Scout Chadwick"] = "Vorhutsspäher Chadwick"
L["Aged Dalaran Wizard"] = "Gealterter Hexer von Dalaran"
L["Ahn'kahet Brazier"] = "Kohlenbecken von Ahn'kahet"
L["AKA"] = "alias"
L["AK, Kahet"] = "AK, Kahet"
L["Alexi Barov <House of Barov>"] = "Alexi Barov <Haus Barov>"
L["Alexston Chrome <Tavern of Time>"] = "Alexston Chrom <Taverne der Zeit>"
L["Alliance Base"] = "Basis der Allianz"
L["Altar of Blood"] = "Altar des Blutes"
L["Altar of the Deeps"] = "Altar der Tiefen"
L["Alurmi"] = "Alurmi"
L["Alurmi <Keepers of Time Quartermaster>"] = "Alurmi <Rüstmeisterin der Hüter der Zeit>"
L["Aluyen <Reagents>"] = "Aluyen <Reagenzien>"
L["Alyson Antille"] = "Alyson Antille"
L["\"Ambassador\" Dagg'thol"] = "\"Botschafter\" Dagg'thol"
L["Ambassador Pax'ivi"] = "Botschafter Pax'ivi"
L["Ambrose Boltspark"] = "Ambrose Bolzenfunk"
L["Amnennar's Phylactery"] = "Amnennars Phylakterium"
L["Anachronos <Keepers of Time>"] = "Anachronos <Hüter der Zeit>"
L["Ancient Equine Spirit"] = "Uralter Pferdegeist"
L["Ancient Treasure"] = "Antiker Schatz"
L["Andorgos <Brood of Malygos>"] = "Andorgos <Brut Malygos'>"
L["Andormu <Keepers of Time>"] = "Andormu <Hüter der Zeit>"
L["AN, Nerub"] = "AN, Azjol"
L["Aoren Sunglow <The Reliquary>"] = "Aoren Sonnenglanz <Die Archäologische Akademie>"
L["Apoko"] = "Apoko"
L["Apothecary Baxter <Crown Chemical Co.>"] = "Apotheker Baxter <Chemiemanufaktur Krone>"
L["Apothecary Frye <Crown Chemical Co.>"] = "Apotheker Frye <Chemiemanufaktur Krone>"
L["Apothecary Hummel <Crown Chemical Co.>"] = "Apotheker Hummel <Chemiemanufaktur Krone>"
L["Apothecary Trio"] = "Apotheker-Trio"
L["Apprentice Darius"] = "Lehrling Darius"
L["AQ"] = "AQ"
L["AQ10"] = "AQ10"
L["AQ20"] = "AQ20"
L["AQ40"] = "AQ40"
L["Arazmodu <The Scale of Sands>"] = "Arazmodu <Die Wächter der Sande>"
L["Arca"] = "Arka"
L["Arcane Container"] = "Arkaner Behälter"
L["Archivum Console"] = "Archivumkonsole"
L["Archmage Alturus"] = "Erzmagier Alturus"
L["Archmage Angela Dosantos <Brotherhood of the Light>"] = "Erzmagierin Angela Dosantos <Bruderschaft des Lichts>"
L["Archmage Elandra <Kirin Tor>"] = "Erzmagierin Elandra <Kirin Tor>"
L["Archmage Koreln <Kirin Tor>"] = "Erzmagier Koreln <Kirin Tor>"
L["Archmage Leryda"] = "Erzmagierin Leryda"
L["Archritualist Kelada"] = "Erzritualist Kelada"
L["Arinoth"] = "Arinoth"
L["Armory"] = "Waffenkammer"
L["Arms Warrior"] = "Waffenkrieger"
L["Artificer Morphalius"] = "Konstrukteur Morphalius"
L["Arygos"] = "Arygos"
L["Ashelan Northwood"] = "Ashelan Nordwald"
L["ATLAS_BUTTON_CLOSE"] = "Schließen"
L["ATLAS_BUTTON_TOOLTIP_HINT"] = [=[Linke Maustaste drücken, um Atlas zu öffnen.
Mittlere Maustaste drücken, um Atlas-Optionen anzuzeigen.
Rechte Maustaste gedrückt halten, um diesen Schalter zu verschieben.]=]
L["ATLAS_BUTTON_TOOLTIP_TITLE"] = "Atlas"
L["ATLAS_DDL_CONTINENT"] = "Kontinent"
L["ATLAS_DDL_CONTINENT_BROKENISLES"] = "Instanzen der Verheerten Inseln" -- Needs review
L["ATLAS_DDL_CONTINENT_DEEPHOLM"] = "Instanzen in Tiefenheim"
L["ATLAS_DDL_CONTINENT_DRAENOR"] = "Instanzen in Draenor"
L["ATLAS_DDL_CONTINENT_EASTERN"] = "Instanzen der Östlichen Königreiche"
L["ATLAS_DDL_CONTINENT_KALIMDOR"] = "Instanzen von Kalimdor"
L["ATLAS_DDL_CONTINENT_NORTHREND"] = "Instanzen von Nordend"
L["ATLAS_DDL_CONTINENT_OUTLAND"] = "Instanzen der Scherbenwelt"
L["ATLAS_DDL_CONTINENT_PANDARIA"] = "Instanzen in Pandaria"
L["ATLAS_DDL_EXPANSION"] = "Erweiterung"
L["ATLAS_DDL_EXPANSION_BC"] = "Burning Crusade Instanzen"
L["ATLAS_DDL_EXPANSION_CATA"] = "Cataclysm Instanzen"
L["ATLAS_DDL_EXPANSION_LEGION"] = "Legion Instanzen" -- Needs review
L["ATLAS_DDL_EXPANSION_MOP"] = "Mists of Pandaria Instanzen"
L["ATLAS_DDL_EXPANSION_OLD_AO"] = "Instanzen der alten Welt 1/2"
L["ATLAS_DDL_EXPANSION_OLD_PZ"] = "Instanzen der alten Welt 2/2"
L["ATLAS_DDL_EXPANSION_WOD"] = "Warlords of Draenor Instanzen"
L["ATLAS_DDL_EXPANSION_WOTLK"] = "Wrath of the Lich King Instanzen"
L["ATLAS_DDL_LEVEL"] = "Stufe"
L["ATLAS_DDL_LEVEL_100PLUS"] = "Instanzen Stufe 100+"
L["ATLAS_DDL_LEVEL_100TO110"] = "Instanzen Stufe 100–110"
L["ATLAS_DDL_LEVEL_110PLUS"] = "Instanzen Stufe 110+"
L["ATLAS_DDL_LEVEL_45TO60"] = "Instanzen Stufe 45–60"
L["ATLAS_DDL_LEVEL_60TO70"] = "Instanzen Stufe 60–70"
L["ATLAS_DDL_LEVEL_70TO80"] = "Instanzen Stufe 70–80"
L["ATLAS_DDL_LEVEL_80TO85"] = "Instanzen Stufe 80–85"
L["ATLAS_DDL_LEVEL_85PLUS"] = "Instanzen Stufe 85+"
L["ATLAS_DDL_LEVEL_85TO90"] = "Instanzen Stufe 85–90"
L["ATLAS_DDL_LEVEL_90TO100"] = "Instanzen Stufe 90–100"
L["ATLAS_DDL_LEVEL_UNDER45"] = "Instanzen unter Stufe 45"
L["ATLAS_DDL_PARTYSIZE"] = "Gruppengröße"
L["ATLAS_DDL_PARTYSIZE_10_AN"] = "Instanzen für 10 Spieler 1/2"
L["ATLAS_DDL_PARTYSIZE_10_OZ"] = "Instanzen für 10 Spieler 2/2"
L["ATLAS_DDL_PARTYSIZE_20TO40"] = "Instanzen für 20–40 Spieler"
L["ATLAS_DDL_PARTYSIZE_20TO40AH"] = "Instanzen für 20–40 Spieler 1/2"
L["ATLAS_DDL_PARTYSIZE_20TO40IZ"] = "Instanzen für 20–40 Spieler 2/2"
L["ATLAS_DDL_PARTYSIZE_5_AE"] = "Instanzen für 5 Spieler 1/3"
L["ATLAS_DDL_PARTYSIZE_5_FS"] = "Instanzen für 5 Spieler 2/3"
L["ATLAS_DDL_PARTYSIZE_5_TZ"] = "Instanzen für 5 Spieler 3/3"
L["ATLAS_DDL_TYPE"] = "Typ"
L["ATLAS_DDL_TYPE_ENTRANCE"] = "Eingänge"
L["ATLAS_DDL_TYPE_INSTANCE_AB"] = "Instanzen 1/5"
L["ATLAS_DDL_TYPE_INSTANCE_AC"] = "Instanzen A–C"
L["ATLAS_DDL_TYPE_INSTANCE_CF"] = "Instanzen 2/5"
L["ATLAS_DDL_TYPE_INSTANCE_DR"] = "Instanzen D–R"
L["ATLAS_DDL_TYPE_INSTANCE_GM"] = "Instanzen 3/5"
L["ATLAS_DDL_TYPE_INSTANCE_NS"] = "Instanzen 4/5"
L["ATLAS_DDL_TYPE_INSTANCE_SZ"] = "Instanzen S–Z"
L["ATLAS_DDL_TYPE_INSTANCE_TZ"] = "Instanzen 5/5"
L["ATLAS_DEP_MSG1"] = "Atlas hat veraltete Module entdeckt."
L["ATLAS_DEP_MSG2"] = "Daher wurden diese Module deaktiviert."
L["ATLAS_DEP_MSG3"] = "Entfernen Sie diese aus Ihrem Verzeichnis AddOns."
L["ATLAS_DEP_OK"] = "OK"
L["ATLAS_ENTRANCE_BUTTON"] = "Eingang"
L["ATLAS_INFO"] = "Atlas Information"
L["ATLAS_INFO_12200"] = [=[Wichtiger Hinweis:

Da die Addondatei stets größer wird, wurde ein Teil 
der Instanzkarten in getrennte Module verschoben.

Beim Download des Addons von den bekannten Webseiten 
erhält man daher nun lediglich das Haupt-Addon mit den Kernfunktionen 
und den Instanzkarten von Cataclysm.

Wer alle alten Instanzkarten und alle Atlas Plugins benötigt, 
muss diese seperat herunterladen.

Mehr Infos dazu gibt es im Forum:
http://www.atlasmod.com/phpBB3/viewtopic.php?t=1522]=]
L["ATLAS_INFO_12201"] = [=[Bitte beachten Sie, dass ein neues Plugin |cff6666ffAtlas Scenarios|cffffffff mit den Karten der neuen Szenarien erstellt wurde. 

Besuchen Sie für weitere Details unsere Webseite und vergessen Sie nicht,
das Plugin separat zu installieren.
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_INSTANCE_BUTTON"] = "Instanz"
L["ATLAS_LDB_HINT"] = [=[Linke Maustaste drücken, um Atlas zu öffnen.
Rechte Maustaste drücken, um die Atlas-Optionen anzuzeigen.]=]
L["ATLAS_MINIMAPLDB_HINT"] = [=[Linke Maustaste drücken, um Atlas zu öffnen.
Rechte Maustaste drücken, um die Atlas-Optionen anzuzeigen.
Linke Maustaste gedrückt halten, um diesen Schalter zu verschieben.]=]
L["ATLAS_MISSING_MODULE"] = "Atlas hat fehlende Module / Plugins erkannt: "
L["ATLAS_OPTIONS_ACRONYMS"] = "Abkürzungen anzeigen"
L["ATLAS_OPTIONS_ACRONYMS_TIP"] = "Zeigt die Instanz-Abkürzungen in den Kartendetails an."
L["ATLAS_OPTIONS_AUTOSEL"] = "Automatische Kartenauswahl"
L["ATLAS_OPTIONS_AUTOSEL_TIP"] = "Instanzkarte automatisch auswählen. Atlas wählt je nach aktueller Position die beste Instanzkarte aus."
L["ATLAS_OPTIONS_BOSS_DESC"] = "Bossbeschreibungen anzeigen, wenn verfügbar"
L["ATLAS_OPTIONS_BOSS_DESC_SCALE"] = "Skalierung der Bossbeschreibungen auf der Karte"
L["ATLAS_OPTIONS_BOSS_DESC_TIP"] = "Beim Überfahren der Bossnummer mit dem Mauszeiger wird, wenn verfügbar, eine Bossbeschreibung angezeigt."
L["ATLAS_OPTIONS_BUTPOS"] = "Schalterposition"
L["ATLAS_OPTIONS_BUTRAD"] = "Schalterradius"
L["ATLAS_OPTIONS_BUTTON"] = "Optionen"
L["ATLAS_OPTIONS_CATDD"] = "Sortierung der Karten nach:"
L["ATLAS_OPTIONS_CHECKMODULE"] = "Über fehlende Module / Plugins benachrichtigen."
L["ATLAS_OPTIONS_CHECKMODULE_TIP"] = "Aktivieren Sie diese Option, um nach dem Starten von WoW zu prüfen, ob Module / Plugins fehlen."
L["ATLAS_OPTIONS_CLAMPED"] = "Fenster im Bildschirm festhalten"
L["ATLAS_OPTIONS_CLAMPED_TIP"] = "Atlasfenster im Bildschirm festhalten. Deaktivieren, um das Atlasfenster über den Spielfensterrand hinaus bewegen zu können."
L["ATLAS_OPTIONS_COLORINGDROPDOWN"] = "Instanzlisten in Stufenfarben anzeigen"
L["ATLAS_OPTIONS_COLORINGDROPDOWN_TIP"] = "Zeigt die Instanzlisten je nach minimaler Stufe und Spielerstufe mit unterschiedlichen Farben zur Indikation des Schwierigkeitsgrades an. "
L["ATLAS_OPTIONS_CTRL"] = "Steuerung drücken, um Tooltips anzuzeigen"
L["ATLAS_OPTIONS_CTRL_TIP"] = "Aktivieren, um die Kartendetails beim Drücken der Strg-Taste und Überfahren eines Eintrages anzuzeigen. Nützlich, falls der dargestellte Text länger als das Fenster groß ist."
L["ATLAS_OPTIONS_DONTSHOWAGAIN"] = "Diese Information nicht erneut anzeigen."
L["ATLAS_OPTIONS_LOCK"] = "Atlasfenster fixieren"
L["ATLAS_OPTIONS_LOCK_TIP"] = "Atlasfenster fixieren / freigeben."
L["ATLAS_OPTIONS_RCLICK"] = "Rechte Maustaste für Weltkarte drücken"
L["ATLAS_OPTIONS_RCLICK_TIP"] = "Aktiviert das Rechtsklicken im Atlasfenster, um die WoW Weltkarte anzuzeigen."
L["ATLAS_OPTIONS_RESETPOS"] = "Position zurücksetzen"
L["ATLAS_OPTIONS_SCALE"] = "Skalierung des Atlas-Fensters"
L["ATLAS_OPTIONS_SHOWBUT"] = "Minikartenschalter anzeigen"
L["ATLAS_OPTIONS_SHOWBUT_TIP"] = "Atlas' Schalter an der Minikarte anzeigen."
L["ATLAS_OPTIONS_TRANS"] = "Transparenz"
L["ATLAS_SEARCH_UNAVAIL"] = "Suche nicht verfügbar"
L["ATLAS_SLASH"] = "/atlas"
L["ATLAS_SLASH_OPTIONS"] = "Optionen"
L["ATLAS_STRING_CLEAR"] = "Leeren"
L["ATLAS_STRING_LEVELRANGE"] = "Stufe"
L["ATLAS_STRING_LOCATION"] = "Region"
L["ATLAS_STRING_MINLEVEL"] = "Minimale Stufe"
L["ATLAS_STRING_PLAYERLIMIT"] = "Max. Spielerzahl"
L["ATLAS_STRING_RECLEVELRANGE"] = "Empf. Stufe"
L["ATLAS_STRING_SEARCH"] = "Suchen"
L["ATLAS_STRING_SELECT_CAT"] = "Kategorie wählen"
L["ATLAS_STRING_SELECT_MAP"] = "Karte wählen"
L["ATLAS_TITLE"] = "Atlas"
L["Attunement Required"] = "Zugangsquest erforderlich"
L["Auch"] = "Auch"
L["Augh"] = "Augh"
L["Auld Stonespire"] = "Auld Steinkeil"
L["Auntie Stormstout"] = "Tantchen Sturmbräu"
L["Avatar of the Martyred"] = "Avatar des Gemarterten"
L["Back"] = "Hinten"
L["Baelog's Chest"] = "Baelogs Truhe"
L["Bakkalzu"] = "Bakkalzu"
L["Baleflame"] = "Unheilsflamme"
L["Ban Bearheart"] = "Ban Bärenherz"
L["Barkeep Kelly <Bartender>"] = "Barkeeper Kelly <Schankkellner>"
L["Barnes <The Stage Manager>"] = "Barnes <Der Inspizient>"
L["Baroness Dorothea Millstipe"] = "Baroness Dorothea Mühlenstein"
L["Baron Rafe Dreuger"] = "Baron Rafe Dreuger"
L["Basement"] = "Keller"
L["Battle for Mount Hyjal"] = "Schlacht um Berg Hyjal"
L["B.E Barechus <S.A.F.E.>"] = "Bi'ay Bäräkuss <S.I.C.H.E.R.>"
L["Belgaristrasz"] = "Belgaristrasz"
L["Belnistrasz"] = "Belnistrasz"
L["Bennett <The Sergeant at Arms>"] = "Bennett <Die Schutzwache>"
L["Berinand's Research"] = "Berinands Forschungsergebnisse"
L["Berserking Boulder Roller"] = "Wütender Felsroller"
L["Berthold <The Doorman>"] = "Berthold <Der Pförtner>"
L["BF"] = "BK"
L["BFD"] = "BFT"
L["BH"] = "BF"
L["Bilger the Straight-laced"] = "Bilger der Strenge"
L["BINDING_HEADER_ATLAS_TITLE"] = "Atlas Tastaturbelegungen"
L["BINDING_NAME_ATLAS_AUTOSEL"] = "Automatische Auswahl"
L["BINDING_NAME_ATLAS_OPTIONS"] = "Optionen an/aus"
L["BINDING_NAME_ATLAS_TOGGLE"] = "Atlas an/aus"
L["Black Dragonflight Chamber"] = "Kammer des schwarzen Drachenschwarms"
L["Blacksmithing Plans"] = "Schmiedekunstpläne"
L["Blastmaster Emi Shortfuse"] = "Sprengmeisterin Emi Schnellzünd"
L["Blood Guard Hakkuz <Darkspear Elite>"] = "Blutwache Hakkuz <Elite der Dunkelspeere>"
L["Blood of Innocents"] = "Das Blut Unschuldiger"
L["Bloodslayer T'ara <Darkspear Veteran>"] = "Blutschlächterin T'ara <Dunkelspeerveteranin>"
L["Bloodslayer Vaena <Darkspear Veteran>"] = "Blutschlächterin Vaena <Dunkelspeerveteranin>"
L["Bloodslayer Zala <Darkspear Veteran>"] = "Blutschlächterin Zala <Dunkelspeerveteranin>"
L["Bodley"] = "Bodley"
L["Bortega <Reagents & Poison Supplies>"] = "Bortega <Reagenzien & Gifte>"
L["BoT"] = "BdZ"
L["Bota"] = "Bota"
L["Bovaal Whitehorn"] = "Bovaal Weißhorn"
L["Bowmistress Li <Guard Captain>"] = "Bogenmeisterin Li <Wachoffizierin>"
L["Brann Bronzebeard"] = "Brann Bronzebart"
L["Brazen"] = "Brazen"
L["BRC"] = "BRH"
L["BRD"] = "BRT"
L["Brewfest"] = "Braufest"
L["BRF"] = "SFG"
L["Brigg Smallshanks"] = "Brigg Kleinkeul"
L["Briney Boltcutter <Blackwater Financial Interests>"] = "Briney Schraubschneider <Schwarzmeer Kapitalbeteiligungen>"
L["BRM"] = "BRM"
L["Broken Stairs"] = "Beschädigte Treppe"
L["BSM"] = "BSM"
L["BT"] = "BT"
L["Bucket of Meaty Dog Food"] = "Eimer mit fleischigem Hundefutter"
L["BWD"] = "BWD"
L["BWL"] = "BWL"
L["Cache of Eregos"] = "Eregos' Lager"
L["Caelestrasz"] = "Caelestrasz"
L["Calliard <The Nightman>"] = "Calliard <Der Nachtwächter>"
L["Captain Alina"] = "Hauptmann Alina"
L["Captain Boneshatter"] = "Hauptmann Knochenbrecher"
L["Captain Drenn"] = "Hauptmann Drenn"
L["Captain Edward Hanes"] = "Kapitän Edward Hanes"
L["Captain Hadan"] = "Kapitän Hadan"
L["\"Captain\" Kaftiz"] = "\"Kapitän\" Kaftiz"
L["Captain Qeez"] = "Hauptmann Qeez"
L["Captain Sanders"] = "Kapitän Sanders"
L["Captain Taylor"] = "Kapitän Taylor"
L["Captain Tuubid"] = "Hauptmann Tuubid"
L["Captain Wyrmak"] = "Hauptmann Wyrmak"
L["Captain Xurrem"] = "Hauptmann Xurrem"
L["Cath"] = "Kathe"
L["Cathedral"] = "Kathedrale"
L["Cavern Entrance"] = "Höhleneingang"
L["Caza'rez"] = "Caza'rez"
L["Celebras the Redeemed"] = "Celebras der Erlöste"
L["Centrifuge Construct"] = "Zentrifugenkonstrukt"
L["Champ"] = "PDC"
L["Champions of the Alliance"] = "Champions der Allianz"
L["Champions of the Horde"] = "Champions der Horde"
L["Charred Bone Fragment"] = "Verkohltes Knochenfragment"
L["Chase Begins"] = "Jagd beginnt"
L["Chase Ends"] = "Jagd endet"
L["Chef Jessen <Speciality Meat & Slop>"] = "Küchenchef Jessen <Spezialitätenfleisch & Pampe>"
L["Chen Stormstout"] = "Chen Sturmbräu"
L["Chester Copperpot <General & Trade Supplies>"] = "Chester Kupferkessel <Gemischt- & Handwerkswaren>"
L["Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"] = "Chefingenieur Bilgenritzel <Gadgetzan Water Co.>"
L["Child"] = "Kind"
L["Chomper"] = "Mümmler"
L["Chromie"] = "Chromie"
L["Chronicler Bah'Kini"] = "Chronistin Bah'Kini"
L["Clarissa"] = "Clarissa"
L["Click to open Dungeon Journal window."] = "Zum Öffnen des Dungeonkompendiums klicken."
L["Coffer of Forgotten Souls"] = "Truhe der vergessenen Seelen"
L["Colon"] = ": "
L["Colonel Zerran"] = "Oberst Zerran"
L["Colosos"] = "Kolosos"
-- L["Comma"] = ""
L["Commander Bagran"] = "Kommandant Bagran"
L["Commander Lindon"] = "Kommandant Lindon"
L["Commander Mograine"] = "Kommandant Mograine"
L["Compendium of the Fallen"] = "Kompendium der Gefallenen"
L["Connection"] = "Verbindung"
L["Core Fragment"] = "Kernfragment"
L["CoT"] = "HdZ"
L["CoT1"] = "Durnholde, HdZ1"
L["CoT2"] = "Morast, HdZ2"
L["CoT3"] = "Hyjal, HdZ3"
L["CoT-DS"] = "HdZ-DS"
L["CoT-ET"] = "HdZ-EZ"
L["CoT-HoT"] = "HdZ-SdZ"
L["CoT-Strat"] = "HdZ4"
L["CoT-WoE"] = "HdZ-BdE"
L["CR"] = "EK"
L["Crus"] = "PDK"
L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] = "Kreuzzugskommandant Eligor Morgenbringer <Bruderschaft des Lichts>"
L["Crusade Commander Korfax <Brotherhood of the Light>"] = "Kreuzzugskommandant Korfax <Bruderschaft des Lichts>"
L["Crusaders' Coliseum"] = "Kolloseum der Kreuzfahrer"
L["Crusaders' Square Postbox"] = "Briefkasten am Kreuzzüglerplatz"
L["Cryo-Engineer Sha'heen"] = "Kryoingenieur Sha'heen"
L["Cursed Centaur"] = "Verfluchter Zentaur"
L["Darkheart"] = "Düsterherz"
L["Dark Keeper Key"] = "Schlüssel des Dunkelbewahrers"
L["Dark Ranger Kalira"] = "Dunkelläuferin Kalira"
L["Dark Ranger Loralen"] = "Dunkelläuferin Loralen"
L["Dark Ranger Marrah"] = "Dunkelläuferin Marrah"
L["Dark Ranger Velonara"] = "Dunkle Waldläuferin Velonara"
L["Dasnurimi <Geologist & Conservator>"] = "Dasnurimi <Geologin & Konservatorin>"
L["Dealer Tariq <Shady Dealer>"] = "Händler Tariq <Zwielichtiger Händler>"
L["Dealer Vijaad"] = "Händler Vijaad"
L["Deathstalker Commander Belmont"] = "Todespirscherkommandant Belmont"
L["Defender Mordun"] = "Verteidiger Mordun"
L["Dire Maul Arena"] = "Düsterbruch Arena"
L["Dire Pool"] = "Düsterteich"
L["Divination Scryer"] = "Orakel der Anrufung"
L["DM"] = "DM"
L["Dominic"] = "Dominic"
L["Don Carlos"] = "Don Carlos"
L["D'ore"] = "D'ore"
L["Draenei Spirit"] = "Draeneigeist"
L["Drakkisath's Brand"] = "Drakkisaths Brandzeichen"
L["Drakuru's Brazier"] = "Drakuru's Kohlenpfanne"
L["Drisella"] = "Drisella"
L["Druid of the Talon"] = "Druide der Kralle"
L["DTK"] = "Feste"
L["Earthbinder Rayge"] = "Erdbinder Rayge"
L["Earthwarden Yrsa <The Earthen Ring>"] = "Erdwächterin Yrsa <Der Irdene Ring>"
L["East"] = "Osten"
L["EB"] = "IF"
L["Ebonlocke <The Noble>"] = "Schwarzhaupt <Der Adlige>"
L["Ebru <Disciple of Naralex>"] = "Ebru <Jüngerin von Naralex>"
-- L["Echoing Horn of the Damned"] = ""
L["Echo of Medivh"] = "Echo Medivhs"
L["Elder Chogan'gada"] = "Urahne Chogan'gada"
L["Elder Farwhisper"] = "Urahne Fernwisper"
L["Elder Igasho"] = "Urahne Igasho"
L["Elder Jarten"] = "Urahne Jarten"
L["Elder Kilias"] = "Urahne Kilias"
L["Elder Mistwalker"] = "Urahnin Nebelgänger"
L["Elder Morndeep"] = "Urahne Schwermut"
L["Elder Nurgen"] = "Urahne Nurgen"
L["Elder Ohanzee"] = "Urahne Ohanzee"
L["Elder Splitrock"] = "Urahne Splitterfels"
L["Elders' Square Postbox"] = "Briefkasten am Ältestenplatz"
L["Elder Starsong"] = "Urahnin Sternensang"
L["Elder Stonefort"] = "Urahne Steinwehr"
L["Elder Wildmane"] = "Urahnin Wildmähne"
L["Elder Yurauk"] = "Urahne Yurauk"
L["Elevator"] = "Aufzug"
L["Ellrys Duskhallow"] = "Ellrys Dämmerweih"
L["End"] = "Ende"
L["Engineer"] = "Ingenieur"
L["Entrance"] = "Eingang"
L["Eramas Brightblaze"] = "Eramas Leuchtfeuer"
L["Erozion"] = "Erozion"
L["Escape from Durnholde Keep"] = "Flucht aus Burg Durnholde"
L["Estulan <The Highborne>"] = "Estulan <Die Hochgeborenen>"
L["Eternos"] = "Eternos"
L["Ethereal Transporter Control Panel"] = "Bedienungskonsole des Astraltransporters"
L["Eulinda <Reagents>"] = "Eulinda <Reagenzien>"
L["Eva Sarkhoff"] = "Eva Sarkhoff"
L["Event"] = "Ereignis"
L["Exalted"] = "Ehrfürchtig"
L["Exarch Larethor"] = "Exarch Larethor"
L["Exit"] = "Ausgang"
L["Face <S.A.F.E.>"] = "Fähs <S.I.C.H.E.R.>"
L["Fairbanks"] = "Schönufer"
L["Falrin Treeshaper"] = "Falrin Rankenweber"
L["Farmer Kent"] = "Bauer Kent"
L["Farseer Tooranu <The Earthen Ring>"] = "Scharfseher Tooranu <Der Irdene Ring>"
L["Father Flame"] = "Vater Flamme"
L["Fathom Stone"] = "Tiefenstein"
L["Fel Crystals"] = "Teufelskristalle"
L["Fenstalker"] = "Fennpirscher"
L["Ferra"] = "Ferra"
L["Festival Lane Postbox"] = "Briefkasten in der Feststraße"
L["FH1"] = "FH1"
L["FH2"] = "FH2"
L["FH3"] = "FH3"
L["Field Commander Mahfuun"] = "Feldkommandeur Mahfuun"
L["Finkle Einhorn"] = "Finkle Einhorn"
L["Fire of Aku'mai"] = "Feuer von Aku'mai"
L["First Fragment Guardian"] = "Wächter des ersten Teils"
L["Fizzle"] = "Zischel"
L["FL"] = "FL"
L["Flaming Eradicator"] = "Flammender Vernichter"
L["Flesh'rok the Diseased <Primordial Saurok Horror>"] = "Fleisch'rok der Verpestete <Urzeitlicher Saurokschrecken>"
L["Focused Eye"] = "Fokussiertes Auge"
L["Forbidden Rites and other Rituals Necromantic"] = "Verbotene Riten und andere nekromantische Rituale"
L["Forest Frogs"] = "Urwaldfrösche"
L["FoS"] = "Schmiede, SS"
L["Four Kaldorei Elites"] = "Vier Elitesoldaten der Kaldorei"
L["Fourth Stop"] = "Vierter Halt"
L["Frances Lin <Barmaid>"] = "Frances Lin <Bardame>"
L["Fras Siabi's Postbox"] = "Fras Siabis Briefkasten"
L["From previous map"] = "Von vorheriger Karte"
L["Front"] = "Vorne"
L["Frostwyrm Lair"] = "Frostwyrmhöhle"
L["Furgus Warpwood"] = "Furgus Wucherborke"
L["Galamav the Marksman <Kargath Expeditionary Force>"] = "Galamav der Schütze <Expeditionskorps von Kargath>"
L["Galgrom <Provisioner>"] = "Galgrom <Versorger>"
L["Garaxxas"] = "Garaxxas"
L["Gazakroth"] = "Gazakroth"
L["GB"] = "GB"
L["GD"] = "GD"
L["Ghost"] = "Geist"
L["GL"] = "Gruul"
L["Gnome"] = "Gnome"
L["Gomora the Bloodletter"] = "Gomora der Blutvergießer"
L["Gorkun Ironskull"] = "Gorkun Eisenschädel"
L["Gradav <The Warlock>"] = "Gradav <Der Hexenmeister>"
L["Graveyard"] = "Friedhof"
L["Greatfather Aldrimus"] = "Großvater Aldrimus"
L["GSS"] = "TdUS, Tor"
L["Guardian of Time"] = "Wächter der Zeit"
L["Gub <Destroyer of Fish>"] = "Gub <Fischvernichter>"
L["Guerrero"] = "Guerrero"
L["Gun"] = "Gun"
L["Gunny"] = "Gunny"
L["GY"] = "Friedhof"
L["Ha'lei"] = "Ha'lei"
L["Ha'Lei"] = "Ha'Lei"
L["Hallow's End"] = "Schlotternächte"
L["Halls"] = "Hallen"
L["Hal McAllister"] = "Hal McAllister"
L["Hann Ibal <S.A.F.E.>"] = "Hann Ibal <S.I.C.H.E.R.>"
L["Harald <Food Vendor>"] = "Harald <Lebensmittelhändler>"
L["Hastings <The Caretaker>"] = "Hastings <Der Hauswart>"
L["Haunted Stable Hand"] = "Geisterhafter Stallknecht"
L["Hazlek"] = "Hazlek"
L["HC"] = "HZ"
L["Helcular"] = "Helcular"
L["Helpful Jungle Monkey"] = "Hilfreicher Dschungelaffe"
L["Herod the Bully"] = "Herod der Tyrann"
L["Heroic"] = "Heroisch"
L["Heroic: Trial of the Grand Crusader"] = "Heroisch: Prüfung des Obersten Kreuzfahrers"
L["Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"] = "Hierophantin Theodora Mulvadania <Expeditionskorps von Kargath>"
L["High Examiner Tae'thelan Bloodwatcher <The Reliquary>"] = "Oberster Prüfer Tae'thelan Blutwächter <Die Archäologische Akademie>"
L["High Justice Grimstone"] = "Oberrichter Grimmstein"
L["HM"] = "HF"
L["HoF"] = "HdF"
L["HoL"] = "HdB"
L["Holy Paladin"] = "Heiligpaladin"
L["Holy Priest"] = "Heiligpriesterin"
L["HoO"] = "HdU"
L["Hooded Crusader"] = "Vermummte Kreuzfahrerin"
L["HoR"] = "HdR"
L["Horde Encampment"] = "Lager der Horde"
L["Horvon the Armorer <Armorsmith>"] = "Horvon der Rüstungsschmied <Rüstungsschmied>"
L["HoS"] = "HdS"
L["Hunter"] = "Jäger"
-- L["Hyphen"] = ""
L["IC"] = "ICC, Zita"
L["ID"] = "ED"
L["Image of Argent Confessor Paletress"] = "Abbild von Argentumbeichtpatin Blondlocke"
L["Image of Drakuru"] = "Abbild von Drakuru"
L["Imp"] = "Wichtel"
L["Indormi <Keeper of Ancient Gem Lore>"] = "Indormi <Bewahrerin der alten Edelsteinkunde>"
L["Innkeeper Monica"] = "Gastwirtin Monica"
L["Instructor Chillheart's Phylactery"] = "Ausbilderin Kaltherz' Phylakterium"
L["In the Shadow of the Light"] = "Im Schatten des Lichts"
L["Investigator Fezzen Brasstacks"] = "Ermittler Fezzen Kupferstapel"
L["Invoker Xorenth"] = "Herbeirufer Xorenth"
L["Ironbark the Redeemed"] = "Eisenborke der Erlöste"
L["Isfar"] = "Isfar"
L["Isillien"] = "Isillien"
L["Itesh"] = "Itesh"
L["Jaelyne Evensong"] = "Jaelyne Abendlied"
L["Jalinda Sprig <Morgan's Militia>"] = "Jalinda Sprig <Morgans Miliz>"
L["Jay Lemieux"] = "Jay Lemieux"
L["J'eevee's Jar"] = "J'eevees Glas"
L["Je'neu Sancrea <The Earthen Ring>"] = "Je'neu Sancrea <Der Irdene Ring>"
L["Jerry Carter"] = "Jerry Carter"
L["Jonathan Revah"] = "Jonathan Revah"
L["Joseph the Awakened"] = "Joseph der Erweckte"
L["Joseph the Crazed"] = "Joseph der Wahnsinnige"
L["Joseph the Insane <Scarlet Champion>"] = "Joseph der Rasende <Scharlachroter Champion>"
L["Julie Honeywell"] = "Julie Honigbrunn"
L["Kagani Nightstrike"] = "Kagani Nachtschlag"
L["Kagtha"] = "Kagtha"
L["Kaldir Ironbane"] = "Kaldir Eisenbann"
L["Kaldrick"] = "Kaldrick"
L["Kamsis <The Conjurer>"] = "Kamsis <Die Beschwörerin>"
L["Kandrostrasz <Brood of Alexstrasza>"] = "Kandrostrasz <Brut Alexstraszas>"
L["Kand Sandseeker <Explorer's League>"] = "Kand Sandsucher <Forscherliga>"
L["Kara"] = "Kara"
L["Kasha"] = "Kasha"
L["Kaulema the Mover"] = "Kaulema der Beweger"
L["Keanna's Log"] = "Keannas Aufzeichnungen"
L["Kel'Thuzad's Deep Knowledge"] = "Kel'Thuzads tiefgründiges Wissen"
L["Kevin Dawson <Morgan's Militia>"] = "Kevin Dawson <Morgans Miliz>"
L["Key"] = "Schlüssel"
L["Kherrah"] = "Kherrah"
L["King's Square Postbox"] = "Briefkasten am Königsplatz"
L["Knot Thimblejack"] = "Knot Zwingschraub"
L["Koragg"] = "Koragg"
L["Korag Proudmane"] = "Korag Mähnenstolz"
L["Koren <The Blacksmith>"] = "Koren <Der Schmied>"
L["Koristrasza"] = "Koristrasza"
L["Kurzel"] = "Kurzel"
L["Lady Catriona Von'Indi"] = "Lady Catriona Von'Indi"
L["Lady Jaina Proudmoore"] = "Lady Jaina Prachtmeer"
L["Lady Keira Berrybuck"] = "Lady Keira Beerhas"
L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Fürstin Sylvanas Windläufer <Bansheekönigin>"
L["Lakka"] = "Lakka"
L["Lana Stouthammer"] = "Lana Starkhammer"
L["Landing Spot"] = "Landepunkt"
L["Large Stone Obelisk"] = "Große Steintafel"
L["LBRS"] = "LBRS"
L["LCoT"] = "VSdT"
-- L["L-DQuote"] = ""
L["Lead Prospector Durdin <Explorer's League>"] = "Oberausgrabungsleiter Durdin <Forscherliga>"
L["Legionnaire Nazgrim"] = "Legionär Nazgrim"
L["Lenzo"] = "Lenzo"
L["Lexlort <Kargath Expeditionary Force>"] = "Lexlort <Expeditionskorps von Kargath>"
L["Lib"] = "Bib"
L["Library"] = "Bibliothek"
L["Lidia Sunglow <The Reliquary>"] = "Lidia Sonnenglanz <Die Archäologische Akademie>"
L["Lieutenant Horatio Laine"] = "Leutnant Horatio Laine"
L["Lieutenant Sinclari"] = "Leutnant Sinclari"
L["Little Jimmy Vishas"] = "Kleiner Jimmy Vishas"
L["Lokhtos Darkbargainer <The Thorium Brotherhood>"] = "Lokhtos Düsterfeilsch <Die Thoriumbruderschaft>"
L["Lord Afrasastrasz"] = "Lord Afrasastrasz"
L["Lord Crispin Ference"] = "Lord Crispin Ference"
L["Lord Itharius"] = "Lord Itharius"
L["Lord Raadan"] = "Lord Raadan"
L["Lord Robin Daris"] = "Lord Robin Daris"
L["Lorekeeper Javon"] = "Wissenshüter Javon"
L["Lorekeeper Kildrath"] = "Wissenshüter Kildrath"
L["Lorekeeper Lydros"] = "Wissenshüter Lydros"
L["Lorekeeper Mykos"] = "Wissenshüter Mykos"
L["Lorgalis Manuscript"] = "Manuskript von Lorgalis"
L["Lothos Riftwaker"] = "Lothos Felsspalter"
L["Love is in the Air"] = "Liebe liegt in der Luft"
L["Lower"] = "Unten"
-- L["L-Parenthesis"] = ""
-- L["L-SBracket"] = ""
L["Lucien Sarkhoff"] = "Lucien Sarkhoff"
L["Lumbering Oaf"] = "Trampel"
L["Lunar Festival"] = "Mondfest"
L["Lurah Wrathvine <Crystallized Firestone Collector>"] = "Lurah Zornranke <Sammlerin kristallisierten Feuersteins>"
L["Madrigosa"] = "Madrigosa"
L["Mag"] = "Maggi"
L["Mage"] = "Magier"
L["Magical Brazier"] = "Magische Kohlenpfanne"
L["Magistrate Henry Maleb"] = "Magistrat Henry Maleb"
L["Mail Box"] = "Briefkasten"
L["Main Chambers Access Panel"] = "Zugangskonsole der Hauptkammer"
L["Major Pakkon"] = "Major Pakkon"
L["Major Yeggeth"] = "Major Yeggeth"
L["Mamdy the \"Ologist\""] = "Mamdy der \"Ologe\""
L["MapA"] = " [A]"
L["MapB"] = " [B]"
L["MapC"] = " [C]"
L["MapD"] = " [D]"
L["MapE"] = " [E]"
L["MapF"] = " [F]"
-- L["MapG"] = ""
-- L["MapH"] = ""
-- L["MapI"] = ""
-- L["MapJ"] = ""
L["MapsNotFound"] = [=[Für die gewählte Instanz wurde 
keine anzuzeigende Karte gefunden. 

Bitte stellen Sie sicher, dass die erforderlichen 
Atlas-Kartenmodule installiert sind.]=]
L["Mara"] = "Mara"
L["Market Row Postbox"] = "Briefkasten in der Marktgasse"
L["Marshal Jacob Alerius"] = "Marschall Jacob Alerius"
L["Marshal Maxwell <Morgan's Militia>"] = "Marschall Maxwell <Morgans Miliz>"
L["Martin Victus"] = "Martin Victus"
L["Master Craftsman Wilhelm <Brotherhood of the Light>"] = "Meisterhandwerker Wilhelm <Bruderschaft des Lichts>"
L["Master Elemental Shaper Krixix"] = "Meisterelementarformer Krixix"
L["Master Windstrong"] = "Meister Windstark"
L["MaT"] = "TdM"
L["Mawago"] = "Mawago"
L["Maxwort Uberglint"] = "Maxwort Funkelglanz"
L["Mayara Brightwing <Morgan's Militia>"] = "Mayara Wolkenglanz <Morgans Miliz>"
L["Mazoga's Spirit"] = "Mazogas Geist"
L["MC"] = "MC"
L["Mech"] = "Mecha"
L["Meeting Stone"] = "Versammlungsstein"
L["Meeting Stone of Hellfire Citadel"] = "Versammlungsstein der Höllenfeuerzitadelle"
L["Meeting Stone of Magtheridon's Lair"] = "Versammlungsstein für Magtheridons Kammer"
L["Melasong"] = "Melasong"
L["Melissa"] = "Melissa"
L["Merithra of the Dream"] = "Merithra des Traums"
L["Micah"] = "Micah"
L["Middle"] = "Mitte"
L["Midsummer Festival"] = "Sonnenwendfest"
L["Millhouse Manastorm"] = "Millhaus Manasturm"
L["Miss Mayhem"] = "Fräulein Fiasko"
L["Mistress Nagmara"] = "Herrin Nagmara"
L["Monara <The Last Queen>"] = "Monara <Die Letzte Königin>"
L["Monk"] = "Mönch"
L["Moonwell"] = "Mondbrunnen"
L["Mor'Lek the Dismantler"] = "Mor'Lek der Zerleger"
L["Mortaxx <The Tolling Bell>"] = "Mortaxx <Das Schlagen der Stunde>"
L["Mortog Steamhead"] = "Mortog Dampfkopf"
L["Mountaineer Orfus <Morgan's Militia>"] = "Gebirgsjäger Orfus <Morgans Miliz>"
L["MP"] = "MP, Palast"
L["Mr. Bigglesworth"] = "Mr. Bigglesworth"
L["MT"] = "Gruft"
L["Murd Doc <S.A.F.E.>"] = "Murd Doc <S.I.C.H.E.R.>"
L["Muyoh <Disciple of Naralex>"] = "Muyoh <Jünger von Naralex>"
L["MV"] = "MS, Kammer"
L["Mysterious Bookshelf"] = "Verdächtiges Bücherregal"
L["Nahuud"] = "Nahuud"
L["Nalpak <Disciple of Naralex>"] = "Nalpak <Jünger von Naralex>"
L["Naralex"] = "Naralex"
L["Naresir Stormfury <Avengers of Hyjal Quartermaster>"] = "Naresir Sturmwut <Rüstmeister der Rächer des Hyjal>"
L["Nathanos Marris"] = "Nathanos Marris"
L["Nat Pagle"] = "Nat Pagle"
L["Naturalist Bite"] = "Naturalist Biss"
L["Nax"] = "Naxx"
L["Neptulon"] = "Neptulon"
L["Nex, Nexus"] = "Nex"
L["Nexus-Prince Haramad"] = "Nexusprinz Haramad"
L["Night Elf Village"] = "Nachtelfen Dorf"
L["No'ku Stormsayer <Lord of Tempest>"] = "No'ku Sturmsprecher <Herr der Stürme>"
L["Norkani"] = "Norkani"
L["North"] = "Norden"
L["Nozari <Keepers of Time>"] = "Nozari <Hüter der Zeit>"
L["Nozdormu"] = "Nozdormu"
L["Nurse Lillian"] = "Schwester Lillian"
L["Ocu"] = "Ocu"
L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Okuno <Rüstmeister der Todeshörigen>"
L["Old Ironbark"] = "Eisenborke der Große"
L["Olga Runesworn <Explorer's League>"] = "Olga Runenschwur <Forscherliga>"
L["Ony"] = "Ony"
L["Opening of the Dark Portal"] = "Öffnung des Dunklen Portals"
L["Optional"] = "Optional"
L["Oralius <Morgan's Militia>"] = "Oralius <Morgans Miliz>"
L["Orange"] = "Orange"
L["Orb of Command"] = "Befehlskugel"
L["Orb of Domination"] = "Kugel der Herrschaft"
L["OS"] = "Obsi"
L["Outside"] = "Außerhalb"
L["Overcharged Manacell"] = "Überladene Manazelle"
L["Overseer Blingbang"] = "Aufseher Klunkerknall"
L["Overwatch Mark 0 <Protector>"] = "Überwacher V.0 <Beschützer>"
L["Packleader Ivar Bloodfang"] = "Rudelführer Ivar Blutfang"
L["Packmaster Stonebruiser <Brotherhood of the Light>"] = "Rottenkommandant Steinberster <Bruderschaft des Lichts>"
L["Paladin"] = "Paladin"
L["Path to the Broken Stairs"] = "Weg zur Beschädigten Treppe"
L["Path to the Hellfire Ramparts and Shattered Halls"] = "Pfad zum Höllenfeuerbollwerk und den zerschmetterten Hallen"
-- L["Period"] = ""
L["Phin Odelic <The Kirin Tor>"] = "Phin Odelic <Kirin Tor>"
L["Polyformic Acid Potion"] = "Polyformgift"
L["Portal"] = "Portal"
L["PoS"] = "Grube"
L["PossibleMissingModule"] = "Diese Karte ist sehr wahrscheinlich in folgendem Modul enthalten: "
L["Precious"] = "Schatz"
L["Priest"] = "Priester"
L["Priestess Summerpetal"] = "Priesterin Sommerblatt"
L["Priestess Udum'bra"] = "Priesterin Udum'bra"
L["Private Jacint"] = "Gefreiter Jacint"
L["Private Rocknot"] = "Gefreiter Rocknot"
L["Professor Slate"] = "Professor Schiefer"
L["Prospector Doren"] = "Ausgrabungsleiter Doren"
L["Prospector Seymour <Morgan's Militia>"] = "Ausgrabungsleiter Seymour <Morgans Miliz>"
L["Protection Warrior"] = "Schutzkrieger"
L["Provisioner Tsaalt"] = "Versorger Tsaalt"
L["Pumpkin Shrine"] = "Kürbisschrein"
L["Purple"] = "Lila"
L["Pylons"] = "Pylonen"
L["Quartermaster Lewis <Quartermaster>"] = "Rüstmeister Lewis <Rüstmeister>"
L["Raleigh the True"] = "Raleigh der Getreue"
L["Ramdor the Mad"] = "Ramdor der Wahnsinnige"
L["Ramp"] = "BW"
L["Ramp down to the Gamesman's Hall"] = "Rampe nach unten zur Halle der Spieler"
L["Ramp to Guardian's Library"] = "Rampe zur Bibliothek der Beschützer"
L["Ramp to Medivh's Chamber"] = "Rampe zu Medivhs Kammer"
L["Ramp up to the Celestial Watch"] = "Rampe nach oben zur Himmelswacht"
L["Random"] = "Zufällig"
L["Randy Whizzlesprocket"] = "Randy Sauseritzel"
L["Rare"] = "Selten"
L["Raven"] = "Die Krähe"
L["Razal'blade <Kargath Expeditionary Force>"] = "Razal'hieb <Expeditionskorps von Kargath>"
L["Razorfen Spearhide"] = "Speerträger der Klingenhauer"
-- L["R-DQuote"] = ""
L["Reclaimer A'zak"] = "Pionier A'zak"
L["Red Dragonflight Chamber"] = "Kammer des roten Drachenschwarms"
L["Red Riding Hood"] = "Rotkäppchen"
L["Reinforced Archery Target"] = "Verstärkte Zielscheibe"
L["Reinforced Fel Iron Chest"] = "Verstärkte Teufelseisentruhe"
L["Relic Coffer Key"] = "Reliktkastenschlüssel"
L["Relissa"] = "Relissa"
L["Relwyn Shadestar"] = "Relwyn Schattenstern"
L["Renault Mograine"] = "Renault Mograine"
L["Repair"] = "Reparieren"
L["Reputation"] = "Ruf"
L["Retribution Paladin"] = "Vergeltungspaladin"
L["Rewards"] = "Belohnungen"
L["RFC"] = "RF"
L["RFD"] = "Hügel"
L["RFK"] = "Kral"
L["Rifle Commander Coe"] = "Schützenkommandant Coe"
L["Rifleman Brownbeard"] = "Scharfschütze Braunbart"
L["Rimefang"] = "Raufang"
L["Rocky Horror"] = "Krankenstein"
L["Rogue"] = "Schurke"
L["Rosa"] = "Rosa"
L["Roughshod Pike"] = "Beschlagene Pike"
-- L["R-Parenthesis"] = ""
L["RS"] = "RS"
-- L["R-SBracket"] = ""
L["Sa'at <Keepers of Time>"] = "Sa'at <Hüter der Zeit>"
L["Safe Room"] = "Sicherer Raum"
L["Sally Whitemane"] = "Sally Weißsträhne"
L["SB"] = "BS, Brauerei"
L["SBG"] = "SGS"
L["SC"] = "SSC, HdS"
L["Scarshield Quartermaster <Scarshield Legion>"] = "Rüstmeister der Schmetterschilde <Schmetterschildlegion>"
L["Schematic: Field Repair Bot 74A"] = "Bauplan: Feldreparaturbot 74A"
L["Scholo"] = "Scholo"
L["Scourge Invasion Points"] = "Invasionspunkte der Geißel"
L["Scout Cage"] = "Späherkäfig"
L["Scout Orgarr"] = "Späher Orgarr"
L["Scout Thaelrid"] = "Späher Thaelrid"
L["Scrying Orb"] = "Seherkugel"
L["Sebastian <The Organist>"] = "Sebastian <Der Orgelspieler>"
L["Second Fragment Guardian"] = "Wächter des zweiten Teils"
L["Second Stop"] = "Zweiter Halt"
L["Seer Ixit"] = "Seher Ixit"
L["Seer Kanai"] = "Seher Kanai"
L["Seer Olum"] = "Seher Olum"
-- L["Semicolon"] = ""
L["Sentinel Aluwyn"] = "Schildwache Aluwyn"
L["Sentinel-trainee Issara"] = "Schildwachenschülerin Issara"
L["Servant Quarters"] = "Quartier der Diener"
L["Seth"] = "SH"
L["SFK"] = "BSF"
L["SH"] = "ZH"
L["Shado-Master Chum Kiu"] = "Shado-Meister Chum-Kiu"
L["Shadowforge Brazier"] = "Schattenschmiedekohlenpfanne"
L["Shadow Lord Xiraxis"] = "Schattenlord Xiraxis"
L["Shadow Priest"] = "Schattenpriesterin"
L["Shaman"] = "Schamane"
L["Shattered Hand Executioner"] = "Henker der Zerschmetterten Hand"
L["Shavalius the Fancy <Flight Master>"] = "Shavalius der Adrette <Flugmeister>"
L["Shen'dralar Ancient"] = "Uralte Shen'dralar"
L["Shen'dralar Provisioner"] = "Versorger der Shen'dralar"
L["Shen'dralar Watcher"] = "Behüter der Shen'dralar"
L["Shrine of Gelihast"] = "Schrein von Gelihast"
L["Sif"] = "Sif"
L["Sinan the Dreamer"] = "Sinan die Träumerin"
L["Sindragosa's Lair"] = "Sindragosas Hort"
L["Sister Svalna"] = "Schwester Svalna"
L["Skar'this the Heretic"] = "Nar'biss der Ketzer"
L["SL"] = "Laby"
-- L["Slash"] = ""
L["\"Slim\" <Shady Dealer>"] = "Smudo <Zwielichtiger Händler>"
L["Slinky Sharpshiv"] = "Slinky Scharfklinge"
L["Slither"] = "Glibber"
L["Sliver <Garaxxas' Pet>"] = "Splitter <Garaxxas Tier>"
L["Slosh <Food & Drink>"] = "Slosh <Speis & Trank>"
L["SM"] = "Kloster"
L["SNT"] = "BNT, Niuzao"
L["SoO"] = "SuO, OG"
L["Soridormi <The Scale of Sands>"] = "Soridormi <Die Wächter der Sande>"
L["South"] = "Süden"
L["Southshore Inn"] = "Süderstade Gasthaus"
L["SP"] = "SU"
L["Spawn Point"] = "Spawnpunkt"
L["Spinestalker"] = "Wirbelpirscher"
L["Spiral Stairs to Netherspace"] = "Wendeltreppe zum Netherraum"
L["Spirit of Agamaggan <Ancient>"] = "Geist von Agamaggan <Uralter>"
L["Spirit of Olum"] = "Geist von Olum"
L["Spirit of Udalo"] = "Geist von Udalo"
L["SPM"] = "SPK"
L["Spoils of Blackfathom"] = "Schätze der Tiefschwarzen Grotte"
L["Spy Grik'tha"] = "Spionin Grik'tha"
L["Spy To'gun"] = "Spion To'gun"
L["SR"] = "HN"
L["SSC"] = "SSC, HdS"
L["ST"] = "Tempel"
L["Stairs to Underground Pond"] = "Treppe zum Unterirdischen Teich"
L["Stairs to Underground Well"] = "Treppe zum Unterirdischen Brunnen"
L["Stalvan Mistmantle"] = "Stalvan Dunstmantel"
L["Start"] = "Anfang"
L["Steps and path to the Blood Furnace"] = "Stufen und Pfad zum Blutkessel"
L["Steward of Time <Keepers of Time>"] = "Ordner der Zeit <Hüter der Zeit>"
L["Stinky"] = "Stinki"
L["Stocks"] = "Verlies"
L["Stone Guard Kurjack"] = "Steingardist Kurjack"
L["Stone Guard Stok'ton"] = "Steingardist Stok'ton"
L["Stonemaul Ogre"] = "Oger der Steinbrecher"
L["Stormherald Eljrrin"] = "Sturmbote Eljrrin"
L["Strat"] = "Strat"
L["Stratholme Courier"] = "Kurier von Stratholme"
L["Summon"] = "Beschwörbar"
L["Summoner's Tomb"] = "Grab des Beschwörers"
L["SuP"] = "Sunwell"
L["Suspicious Bookshelf"] = "Verdächtiges Bücherregal"
L["SV"] = "DK"
L["Taelan"] = "Taelan"
L["Talking Skull"] = "Sprechender Schädel"
L["Taretha"] = "Taretha"
L["Teleporter"] = "Teleporter"
L["Teleporter destination"] = "Teleportziel"
L["Teleporter to Middle"] = "Teleporter zur Mitte"
L["TEoE"] = "Maly"
L["TES"] = "TdEF, Terrasse"
L["Thal'trak Proudtusk <Kargath Expeditionary Force>"] = "Thal'trak Ehrenhauer <Expeditionskorps von Kargath>"
L["The Behemoth"] = "Das Ungetüm"
L["The Black Anvil"] = "Der Schwarze Amboss"
L["The Black Forge"] = "Die schwarze Schmiede"
L["The Captain's Chest"] = "Die Truhe des Hauptmanns"
L["The Codex of Blood"] = "Kodex des Blutes"
L["The Culling of Stratholme"] = "Das Ausmerzen von Stratholme"
L["The Dark Grimoire"] = "Der dunkle Zauberfoliant"
L["The Dark Portal"] = "Das Dunkle Portal"
L["The Deed to Brill"] = "Die Besitzurkunde für Brill"
L["The Deed to Caer Darrow"] = "Die Besitzurkunde für Darrowehr"
L["The Deed to Southshore"] = "Die Besitzurkunde für Süderstade"
L["The Deed to Tarren Mill"] = "Die Besitzurkunde für Tarrens Mühle"
L["The Discs of Norgannon"] = "Die Scheiben von Norgannon"
L["The Eye of Haramad"] = "Das Auge des Haramad"
L["The Keepers"] = "Die Hüter"
L["The Map of Zul'Aman"] = "Karte von Zul'Aman"
L["The Master's Terrace"] = "Die Terrasse des Meisters"
L["The Nameless Prophet"] = "Der namenlose Prophet"
L["The Saga of Terokk"] = "Die Sage von Terokk"
L["The Shadowforge Lock"] = "Das Schloss der Schattenschmiede"
L["The Siege"] = "Die Belagerung"
L["The Sparklematic 5200"] = "Der Funkelmat 5200"
L["The Underspore"] = "Die Tiefenspore"
L["The Vault"] = "Der Tresorraum"
L["Third Fragment Guardian"] = "Wächter des dritten Teils"
L["Third Stop"] = "Dritter Halt"
L["Thomas Yance <Travelling Salesman>"] = "Thomas Yance <Fliegender Händler>"
L["Thrall"] = "Thrall"
L["Thrall <Warchief>"] = "Thrall <Kriegshäuptling>"
L["Thunderheart <Kargath Expeditionary Force>"] = "Donnerherz <Expeditionskorps von Kargath>"
L["Thurg"] = "Thurg"
L["Tiki Lord Mu'Loa"] = "Tikilord Mu'Loa"
L["Tiki Lord Zim'wae"] = "Tikilord Zim'wae"
L["Tinkee Steamboil"] = "Tinkee Kesseldampf"
L["Tink Sprocketwhistle <Engineering Supplies>"] = "Tink Sprosspfiff <Ingenieursbedarf>"
L["TJS"] = "TdJ, Jade"
L["TK"] = "FdS"
L["Tol'mar"] = "Tol'mar"
L["Tol'vir Grave"] = "Grab der Tol'vir"
L["To next map"] = "Zur nächsten Karte"
L["Top"] = "Spitze"
L["Torben Zapblast <Teleportation Specialist>"] = "Torben Zischknall <Teleportationsspezialist>"
L["Torch Lever"] = "Fackelhebel"
L["Tormented Soulpriest"] = "Gequälte Seelenpriesterin"
L["Tor-Tun <The Slumberer>"] = "Tor-Tun <Der Schläfer>"
L["ToT"] = "TdD"
L["ToTT"] = "TdG"
L["Towards Illidan Stormrage"] = "Zu Illidan Sturmgrimm"
L["Towards Reliquary of Souls"] = "Zum Relikt der Seelen"
L["Towards Teron Gorefiend"] = "Zu Teron Blutschatten"
L["Tower of Flame"] = "Turm der Flammen"
L["Tower of Frost"] = "Turm des Frostes"
L["Tower of Life"] = "Turm des Lebens"
L["Tower of Storms"] = "Turm der Stürme"
L["Train Ride"] = "Zugfahrt"
L["Tran'rek"] = "Tran'rek"
-- L["Transport"] = ""
L["Tribunal Chest"] = "Kiste des Tribunals"
L["TSC"] = "DSK"
L["T'shu"] = "T'shu"
L["Tunnel"] = "Tunnel"
L["TWT"] = "TdVW"
L["Tydormu <Keeper of Lost Artifacts>"] = "Tydormu <Bewahrer der verlorenen Artefakte>"
L["Tyllan"] = "Tyllan"
L["Tyrande Whisperwind <High Priestess of Elune>"] = "Tyrande Wisperwind <Hohepriesterin von Elune>"
L["Tyrith"] = "Tyrith"
L["UB"] = "TS"
L["UBRS"] = "OBRS"
L["Udalo"] = "Udalo"
L["UK, Keep"] = "Burg"
L["Ulda"] = "Ulda"
L["Uldu"] = "Uldu"
L["Unblinking Eye"] = "Starrendes Auge"
L["Underwater"] = "Unter Wasser"
L["Upper"] = "Oben"
L["Upper Spire"] = "Obere Spitze"
L["UP, Pinn"] = "Turm"
L["Urok's Tribute Pile"] = "Uroks Tributhaufen"
L["Varies"] = "Variiert"
L["VC"] = "DM"
L["Vehini <Assault Provisions>"] = "Vehini <Angriffsvorräte>"
L["Velastrasza"] = "Velastrasza"
L["Vend-O-Tron D-Luxe"] = "Kauf-o-Mat 1-A"
L["Venomancer Mauri <The Snake's Whisper>"] = "Giftmischerin Mauri <Das Flüstern der Schlange>"
L["Venomancer T'Kulu <The Toxic Bite>"] = "Giftmischer T'Kulu <Der Toxische Biss>"
L["Verdisa"] = "Verdisa"
L["Vethsera <Brood of Ysera>"] = "Vethsera <Brut Yseras>"
L["VH"] = "VF, Vio"
L["VoA"] = "Archa"
L["Vol'jin"] = "Vol'jin"
L["Voodoo Pile"] = "Voodoohaufen"
L["Vorrel Sengutz"] = "Vorrel Sengutz"
L["VP"] = "VG"
L["Wanders"] = "Wandert"
L["Warden Thelwater"] = "Aufseher Thelwasser"
L["Warlock"] = "Hexenmeister"
L["Warlord Goretooth <Kargath Expeditionary Force>"] = "Kriegsherr Bluthauer <Expeditionskorps von Kargath>"
L["Warlord Salaris"] = "Kriegsherr Salaris"
L["Warmage Kaitlyn"] = "Kriegsmagierin Kaitlyn"
L["Warrior"] = "Krieger"
L["Watcher Gashra"] = "Aufseher Gashra"
L["Watcher Jhang"] = "Behüterin Jhang"
L["Watcher Narjil"] = "Aufseher Narjil"
L["Watcher Silthik"] = "Aufseher Silthik"
L["Watchman Doomgrip"] = "Wachmann Stahlgriff"
L["Wave 10"] = "Welle 10"
L["Wave 12"] = "Welle 12"
L["Wave 18"] = "Welle 18"
L["Wave 5"] = "Welle 5"
L["Wave 6"] = "Welle 6"
L["WC"] = "HdW"
L["Weeder Greenthumb"] = "Jäter Gründaum"
L["Weegli Blastfuse"] = "Weegli Lunte"
L["Weldon Barov <House of Barov>"] = "Weldon Barov <Haus Barov>"
L["West"] = "Westen"
L["Willix the Importer"] = "Willix der Importeur"
L["Windcaller Claw"] = "Windrufer Klaue"
L["Witch Doctor Qu'in <Medicine Woman>"] = "Hexendoktor Qu'in <Medizinfrau>"
L["Witch Doctor T'wansi"] = "Hexendoktor T'wansi"
L["Wizard of Oz"] = "Zauberer von Oz"
L["Wrath of the Lich King"] = "Flucht vor dem Lichkönig"
L["Wravien <The Mage>"] = "Wravien <Der Magier>"
L["Yarley <Armorer>"] = "Yarley <Rüstungsschmied>"
L["Yazzai"] = "Yazzai"
L["Young Blanchy"] = "Kleine Graumähne"
L["Ythyar"] = "Ythyar"
L["Yuka Screwspigot <Engineering Supplies>"] = "Yuka Schraubstutz <Ingenieursbedarf>"
L["ZA"] = "ZA"
L["Zaladormu"] = "Zaladormu"
L["Zanza the Restless"] = "Zanza der Ruhelose"
L["Zanzil's Cauldron of Burning Blood"] = "Zanzils Kessel des brennenden Blutes"
L["Zanzil's Cauldron of Frostburn Formula"] = "Zanzils Kessel des frierenden Fleisches"
L["Zanzil's Cauldron of Toxic Torment"] = "Zanzils Kessel der giftigen Grausamkeit"
L["Zao'cho <The Emperor's Shield>"] = "Zao'cho <Der Schild des Kaisers>"
L["Zelfan"] = "Zelfan"
L["Zeya"] = "Zeya"
L["ZF"] = "ZF"
L["ZG"] = "ZG"
L["Zixil <Aspiring Merchant>"] = "Zixil <Aufstrebender Händler>"
L["Zungam"] = "Zungam"
L["ToC/Description"] = "Instanzkarten-Browser"
L["ToC/Title"] = "Atlas"



end