﻿-- $Id: Atlas-enUS.lua 42 2016-07-15 08:11:19Z arith $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2016 - Arith Hsu, Atlas Team <atlas.addon@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas", "enUS", true, true);
-- Localize file must set above to false, for example:
--    local AL = AceLocale:NewLocale("Atlas", "deDE", false);

-- Atlas English Localization
--if ( GetLocale() ==	"enUS" ) then
-- Define the leading strings to be ignored while sorting
-- Ex: The Stockade
AtlasSortIgnore = {"the (.+)"};

-- Syntax: ["real_zone_name"] = "localized map zone name"
AtlasZoneSubstitutions = {
	["Ahn'Qiraj"] = "Temple of Ahn'Qiraj";
	["The Temple of Atal'Hakkar"] = "Sunken Temple";
--	["Throne of Tides"] = "The Abyssal Maw: Throne of the Tides";
};
--end


if L then
L["Abandonded Mole Machine"] = "Abandonded Mole Machine"
L["Abbendis"] = "Abbendis"
L["AC"] = "AC"
L["Acride <Scarshield Legion>"] = "Acride <Scarshield Legion>"
L["Adult"] = "Adult"
L["Advance Scout Chadwick"] = "Advance Scout Chadwick"
L["Aged Dalaran Wizard"] = "Aged Dalaran Wizard"
L["Ahn'kahet Brazier"] = "Ahn'kahet Brazier"
L["AKA"] = "AKA"
L["AK, Kahet"] = "AK, Kahet"
L["Alexi Barov <House of Barov>"] = "Alexi Barov <House of Barov>"
L["Alexston Chrome <Tavern of Time>"] = "Alexston Chrome <Tavern of Time>"
L["Alliance Base"] = "Alliance Base"
L["Altar of Blood"] = "Altar of Blood"
L["Altar of the Deeps"] = "Altar of the Deeps"
L["Alurmi"] = "Alurmi"
L["Alurmi <Keepers of Time Quartermaster>"] = "Alurmi <Keepers of Time Quartermaster>"
L["Aluyen <Reagents>"] = "Aluyen <Reagents>"
L["Alyson Antille"] = "Alyson Antille"
L["\"Ambassador\" Dagg'thol"] = "\"Ambassador\" Dagg'thol"
L["Ambassador Pax'ivi"] = "Ambassador Pax'ivi"
L["Ambrose Boltspark"] = "Ambrose Boltspark"
L["Amnennar's Phylactery"] = "Amnennar's Phylactery"
L["Anachronos <Keepers of Time>"] = "Anachronos <Keepers of Time>"
L["Ancient Equine Spirit"] = "Ancient Equine Spirit"
L["Ancient Treasure"] = "Ancient Treasure"
L["Andorgos <Brood of Malygos>"] = "Andorgos <Brood of Malygos>"
L["Andormu <Keepers of Time>"] = "Andormu <Keepers of Time>"
L["AN, Nerub"] = "AN, Nerub"
L["Aoren Sunglow <The Reliquary>"] = "Aoren Sunglow <The Reliquary>"
L["Apoko"] = "Apoko"
L["Apothecary Baxter <Crown Chemical Co.>"] = "Apothecary Baxter <Crown Chemical Co.>"
L["Apothecary Frye <Crown Chemical Co.>"] = "Apothecary Frye <Crown Chemical Co.>"
L["Apothecary Hummel <Crown Chemical Co.>"] = "Apothecary Hummel <Crown Chemical Co.>"
L["Apothecary Trio"] = "Apothecary Trio"
L["Apprentice Darius"] = "Apprentice Darius"
L["AQ"] = "AQ"
L["AQ10"] = "AQ10"
L["AQ20"] = "AQ20"
L["AQ40"] = "AQ40"
L["Arazmodu <The Scale of Sands>"] = "Arazmodu <The Scale of Sands>"
L["Arca"] = "Arca"
L["Arcane Container"] = "Arcane Container"
L["Archivum Console"] = "Archivum Console"
L["Archmage Alturus"] = "Archmage Alturus"
L["Archmage Angela Dosantos <Brotherhood of the Light>"] = "Archmage Angela Dosantos <Brotherhood of the Light>"
L["Archmage Elandra <Kirin Tor>"] = "Archmage Elandra <Kirin Tor>"
L["Archmage Koreln <Kirin Tor>"] = "Archmage Koreln <Kirin Tor>"
L["Archmage Leryda"] = "Archmage Leryda"
L["Archritualist Kelada"] = "Archritualist Kelada"
L["Arinoth"] = "Arinoth"
L["Armory"] = "Armory"
L["Arms Warrior"] = "Arms Warrior"
L["Artificer Morphalius"] = "Artificer Morphalius"
L["Arygos"] = "Arygos"
L["Ashelan Northwood"] = "Ashelan Northwood"
L["ATLAS_BUTTON_CLOSE"] = "Close"
L["ATLAS_BUTTON_TOOLTIP_HINT"] = [=[Left-click to open Atlas.
Middle-click for Atlas options.
Right-click and drag to move this button.]=]
L["ATLAS_BUTTON_TOOLTIP_TITLE"] = "Atlas"
L["ATLAS_DDL_CONTINENT"] = "Continent"
L["ATLAS_DDL_CONTINENT_BROKENISLES"] = "Broken Isles Instances"
L["ATLAS_DDL_CONTINENT_DEEPHOLM"] = "Deepholm Instances"
L["ATLAS_DDL_CONTINENT_DRAENOR"] = "Draenor Instances"
L["ATLAS_DDL_CONTINENT_EASTERN"] = "Eastern Kingdoms Instances"
L["ATLAS_DDL_CONTINENT_KALIMDOR"] = "Kalimdor Instances"
L["ATLAS_DDL_CONTINENT_NORTHREND"] = "Northrend Instances"
L["ATLAS_DDL_CONTINENT_OUTLAND"] = "Outland Instances"
L["ATLAS_DDL_CONTINENT_PANDARIA"] = "Pandaria Instances"
L["ATLAS_DDL_EXPANSION"] = "Expansion"
L["ATLAS_DDL_EXPANSION_BC"] = "Burning Crusade Instances"
L["ATLAS_DDL_EXPANSION_CATA"] = "Cataclysm Instances"
L["ATLAS_DDL_EXPANSION_LEGION"] = "Legion Instances"
L["ATLAS_DDL_EXPANSION_MOP"] = "Mists of Pandaria Instances"
L["ATLAS_DDL_EXPANSION_OLD_AO"] = "Old World Instances A-O"
L["ATLAS_DDL_EXPANSION_OLD_PZ"] = "Old World Instances P-Z"
L["ATLAS_DDL_EXPANSION_WOD"] = "Warlords of Draenor Instances"
L["ATLAS_DDL_EXPANSION_WOTLK"] = "Wrath of the Lich King Instances"
L["ATLAS_DDL_LEVEL"] = "Level"
L["ATLAS_DDL_LEVEL_100PLUS"] = "Instances Level 100+"
L["ATLAS_DDL_LEVEL_100TO110"] = "Instances Level 100-110"
L["ATLAS_DDL_LEVEL_110PLUS"] = "Instances Level 110+"
L["ATLAS_DDL_LEVEL_45TO60"] = "Instances Level 45-60"
L["ATLAS_DDL_LEVEL_60TO70"] = "Instances Level 60-70"
L["ATLAS_DDL_LEVEL_70TO80"] = "Instances Level 70-80"
L["ATLAS_DDL_LEVEL_80TO85"] = "Instances Level 80-85"
L["ATLAS_DDL_LEVEL_85PLUS"] = "Instances Level 85+"
L["ATLAS_DDL_LEVEL_85TO90"] = "Instances Level 85-90"
L["ATLAS_DDL_LEVEL_90TO100"] = "Instances Level 90-100"
L["ATLAS_DDL_LEVEL_UNDER45"] = "Instances Under Level 45"
L["ATLAS_DDL_PARTYSIZE"] = "Party Size"
L["ATLAS_DDL_PARTYSIZE_10_AN"] = "Instances for 10 Players A-N"
L["ATLAS_DDL_PARTYSIZE_10_OZ"] = "Instances for 10 Players O-Z"
L["ATLAS_DDL_PARTYSIZE_20TO40"] = "Instances for 20-40 Players"
L["ATLAS_DDL_PARTYSIZE_20TO40AH"] = "Instances for 20-40 Players A-H"
L["ATLAS_DDL_PARTYSIZE_20TO40IZ"] = "Instances for 20-40 Players I-Z"
L["ATLAS_DDL_PARTYSIZE_5_AE"] = "Instances for 5 Players A-E"
L["ATLAS_DDL_PARTYSIZE_5_FS"] = "Instances for 5 Players F-S"
L["ATLAS_DDL_PARTYSIZE_5_TZ"] = "Instances for 5 Players T-Z"
L["ATLAS_DDL_TYPE"] = "Type"
L["ATLAS_DDL_TYPE_ENTRANCE"] = "Entrances"
L["ATLAS_DDL_TYPE_INSTANCE_AB"] = "Instances A-B"
L["ATLAS_DDL_TYPE_INSTANCE_AC"] = "Instances A-C"
L["ATLAS_DDL_TYPE_INSTANCE_CF"] = "Instances C-F"
L["ATLAS_DDL_TYPE_INSTANCE_DR"] = "Instances D-R"
L["ATLAS_DDL_TYPE_INSTANCE_GM"] = "Instances G-M"
L["ATLAS_DDL_TYPE_INSTANCE_NS"] = "Instances N-S"
L["ATLAS_DDL_TYPE_INSTANCE_SZ"] = "Instances S-Z"
L["ATLAS_DDL_TYPE_INSTANCE_TZ"] = "Instances T-Z"
L["ATLAS_DEP_MSG1"] = "Atlas has detected outdated module(s)."
L["ATLAS_DEP_MSG2"] = "They have been disabled for this character."
L["ATLAS_DEP_MSG3"] = "Delete them from your AddOns folder."
L["ATLAS_DEP_OK"] = "Ok"
L["ATLAS_ENTRANCE_BUTTON"] = "Entrance"
L["ATLAS_INFO"] = "Atlas Information"
L["ATLAS_INFO_12200"] = [=[Important Notice:

Due to the concern of increasing addon file size, we have moved out 
part of our dungeon maps and built-in plug-ins into separated addon package.

Users who download our addons from some of the famous game web sites 
may only get our core addon which only include the Atlas core function 
and the latest WoW expansion maps.

If you also want to see all the old expansions' maps, and also want all those 
Atlas plug-ins made by us, you have to download and install them separately.

Read below forum topic for more information:
|cff6666ffhttp://www.atlasmod.com/phpBB3/viewtopic.php?t=1522|cffffffff

Or visit our website to see where to download:
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_INFO_12201"] = [=[Please be advised that we have created a new plug-in - |cff6666ffAtlas Scenarios|cffffffff, to 
provide the brand-new Scenarios maps introduced in WoW 5.0. 

Check out our web site for more details, and don't forget to download / 
install it separately.
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_INSTANCE_BUTTON"] = "Instance"
L["ATLAS_LDB_HINT"] = [=[Left-Click to open Atlas.
Right-Click for Atlas options.]=]
L["ATLAS_MINIMAPLDB_HINT"] = [=[Left-Click to open Atlas.
Right-Click for Atlas options.
Left-click and drag to move this button.]=]
L["ATLAS_MISSING_MODULE"] = "Atlas has detected missing module(s) / plugin(s): "
L["ATLAS_OPTIONS_ACRONYMS"] = "Display Acronyms"
L["ATLAS_OPTIONS_ACRONYMS_TIP"] = "Display the instance's acronym in the map details."
L["ATLAS_OPTIONS_AUTOSEL"] = "Auto-Select Instance Map"
L["ATLAS_OPTIONS_AUTOSEL_TIP"] = "Auto-select instance map, Atlas will detect your location to choose the best instance map for you."
L["ATLAS_OPTIONS_BOSS_DESC"] = "Show boss description when available"
L["ATLAS_OPTIONS_BOSS_DESC_SCALE"] = "Boss Description Map ToolTip Scale"
L["ATLAS_OPTIONS_BOSS_DESC_TIP"] = "When mouse hover the boss number, display the boss description when relative information is available."
L["ATLAS_OPTIONS_BUTPOS"] = "Button Position"
L["ATLAS_OPTIONS_BUTRAD"] = "Button Radius"
L["ATLAS_OPTIONS_BUTTON"] = "Options"
L["ATLAS_OPTIONS_CATDD"] = "Sort Instance Maps by:"
L["ATLAS_OPTIONS_CHECKMODULE"] = "Remind me for missing module(s) / plug-in(s)."
L["ATLAS_OPTIONS_CHECKMODULE_TIP"] = "Enable to perform checking if any missing Atlas module / plug-in after WoW loaded."
L["ATLAS_OPTIONS_CLAMPED"] = "Clamp window to screen"
L["ATLAS_OPTIONS_CLAMPED_TIP"] = "Clamp Atlas window to screen, disable to allow Atlas window can be dragged outside the game screen."
L["ATLAS_OPTIONS_COLORINGDROPDOWN"] = "Show dungeon dropdown in colors"
L["ATLAS_OPTIONS_COLORINGDROPDOWN_TIP"] = "Based on the dungeon's recommended minimul level and player's level, to show the dungeon with difficulty colors."
L["ATLAS_OPTIONS_CTRL"] = "Hold down Control for tooltips"
L["ATLAS_OPTIONS_CTRL_TIP"] = "Enable to show tooltips text while hold down control key and mouse over the map info. Useful when the text is too long to be displayed in the window."
L["ATLAS_OPTIONS_DONTSHOWAGAIN"] = "Don't show the same information again."
L["ATLAS_OPTIONS_LOCK"] = "Lock Atlas window"
L["ATLAS_OPTIONS_LOCK_TIP"] = "Toggle lock / unlock of Atlas window."
L["ATLAS_OPTIONS_RCLICK"] = "Right-Click for World Map"
L["ATLAS_OPTIONS_RCLICK_TIP"] = "Enable the Right-Click in Atlas window to switch to WoW World Map."
L["ATLAS_OPTIONS_RESETPOS"] = "Reset Position"
L["ATLAS_OPTIONS_SCALE"] = "Atlas Frame Scale"
L["ATLAS_OPTIONS_SHOWBUT"] = "Show Button on Minimap"
L["ATLAS_OPTIONS_SHOWBUT_TIP"] = "Show Atlas button around the minimap."
L["ATLAS_OPTIONS_TRANS"] = "Transparency"
L["ATLAS_SEARCH_UNAVAIL"] = "Search Unavailable"
L["ATLAS_SLASH"] = "/atlas"
L["ATLAS_SLASH_OPTIONS"] = "options"
L["ATLAS_STRING_CLEAR"] = "Clear"
L["ATLAS_STRING_LEVELRANGE"] = "Level"
L["ATLAS_STRING_LOCATION"] = "Location"
L["ATLAS_STRING_MINLEVEL"] = "Minimum Level"
L["ATLAS_STRING_PLAYERLIMIT"] = "Player Limit"
L["ATLAS_STRING_RECLEVELRANGE"] = "Rec. Level"
L["ATLAS_STRING_SEARCH"] = "Search"
L["ATLAS_STRING_SELECT_CAT"] = "Select Category"
L["ATLAS_STRING_SELECT_MAP"] = "Select Map"
L["ATLAS_TITLE"] = "Atlas"
L["Attunement Required"] = "Attunement Required"
L["Auch"] = "Auch"
L["Augh"] = "Augh"
L["Auld Stonespire"] = "Auld Stonespire"
L["Auntie Stormstout"] = "Auntie Stormstout"
L["Avatar of the Martyred"] = "Avatar of the Martyred"
L["Back"] = "Back"
L["Baelog's Chest"] = "Baelog's Chest"
L["Bakkalzu"] = "Bakkalzu"
L["Baleflame"] = "Baleflame"
L["Ban Bearheart"] = "Ban Bearheart"
L["Barkeep Kelly <Bartender>"] = "Barkeep Kelly <Bartender>"
L["Barnes <The Stage Manager>"] = "Barnes <The Stage Manager>"
L["Baroness Dorothea Millstipe"] = "Baroness Dorothea Millstipe"
L["Baron Rafe Dreuger"] = "Baron Rafe Dreuger"
L["Basement"] = "Basement"
L["Battle for Mount Hyjal"] = "Battle for Mount Hyjal"
L["B.E Barechus <S.A.F.E.>"] = "B.E Barechus <S.A.F.E.>"
L["Belgaristrasz"] = "Belgaristrasz"
L["Belnistrasz"] = "Belnistrasz"
L["Bennett <The Sergeant at Arms>"] = "Bennett <The Sergeant at Arms>"
L["Berinand's Research"] = "Berinand's Research"
L["Berserking Boulder Roller"] = "Berserking Boulder Roller"
L["Berthold <The Doorman>"] = "Berthold <The Doorman>"
L["BF"] = "BF"
L["BFD"] = "BFD"
L["BH"] = "BH"
L["Bilger the Straight-laced"] = "Bilger the Straight-laced"
L["BINDING_HEADER_ATLAS_TITLE"] = "Atlas Bindings"
L["BINDING_NAME_ATLAS_AUTOSEL"] = "Auto-Select"
L["BINDING_NAME_ATLAS_OPTIONS"] = "Toggle Options"
L["BINDING_NAME_ATLAS_TOGGLE"] = "Toggle Atlas"
L["Black Dragonflight Chamber"] = "Black Dragonflight Chamber"
L["Blacksmithing Plans"] = "Blacksmithing Plans"
L["Blastmaster Emi Shortfuse"] = "Blastmaster Emi Shortfuse"
L["Blood Guard Hakkuz <Darkspear Elite>"] = "Blood Guard Hakkuz <Darkspear Elite>"
L["Blood of Innocents"] = "Blood of Innocents"
L["Bloodslayer T'ara <Darkspear Veteran>"] = "Bloodslayer T'ara <Darkspear Veteran>"
L["Bloodslayer Vaena <Darkspear Veteran>"] = "Bloodslayer Vaena <Darkspear Veteran>"
L["Bloodslayer Zala <Darkspear Veteran>"] = "Bloodslayer Zala <Darkspear Veteran>"
L["Bodley"] = "Bodley"
L["Bortega <Reagents & Poison Supplies>"] = "Bortega <Reagents & Poison Supplies>"
L["BoT"] = "BoT"
L["Bota"] = "Bota"
L["Bovaal Whitehorn"] = "Bovaal Whitehorn"
L["Bowmistress Li <Guard Captain>"] = "Bowmistress Li <Guard Captain>"
L["Brann Bronzebeard"] = "Brann Bronzebeard"
L["Brazen"] = "Brazen"
L["BRC"] = "BRC"
L["BRD"] = "BRD"
L["Brewfest"] = "Brewfest"
L["BRF"] = "BRF"
L["Brigg Smallshanks"] = "Brigg Smallshanks"
L["Briney Boltcutter <Blackwater Financial Interests>"] = "Briney Boltcutter <Blackwater Financial Interests>"
L["BRM"] = "BRM"
L["Broken Stairs"] = "Broken Stairs"
L["BSM"] = "BSM"
L["BT"] = "BT"
L["Bucket of Meaty Dog Food"] = "Bucket of Meaty Dog Food"
L["BWD"] = "BWD"
L["BWL"] = "BWL"
L["Cache of Eregos"] = "Cache of Eregos"
L["Caelestrasz"] = "Caelestrasz"
L["Calliard <The Nightman>"] = "Calliard <The Nightman>"
L["Captain Alina"] = "Captain Alina"
L["Captain Boneshatter"] = "Captain Boneshatter"
L["Captain Drenn"] = "Captain Drenn"
L["Captain Edward Hanes"] = "Captain Edward Hanes"
L["Captain Hadan"] = "Captain Hadan"
L["\"Captain\" Kaftiz"] = "\"Captain\" Kaftiz"
L["Captain Qeez"] = "Captain Qeez"
L["Captain Sanders"] = "Captain Sanders"
L["Captain Taylor"] = "Captain Taylor"
L["Captain Tuubid"] = "Captain Tuubid"
L["Captain Wyrmak"] = "Captain Wyrmak"
L["Captain Xurrem"] = "Captain Xurrem"
L["Cath"] = "Cath"
L["Cathedral"] = "Cathedral"
L["Cavern Entrance"] = "Cavern Entrance"
L["Caza'rez"] = "Caza'rez"
L["Celebras the Redeemed"] = "Celebras the Redeemed"
L["Centrifuge Construct"] = "Centrifuge Construct"
L["Champ"] = "Champ"
L["Champions of the Alliance"] = "Champions of the Alliance"
L["Champions of the Horde"] = "Champions of the Horde"
L["Charred Bone Fragment"] = "Charred Bone Fragment"
L["Chase Begins"] = "Chase Begins"
L["Chase Ends"] = "Chase Ends"
L["Chef Jessen <Speciality Meat & Slop>"] = "Chef Jessen <Speciality Meat & Slop>"
L["Chen Stormstout"] = "Chen Stormstout"
L["Chester Copperpot <General & Trade Supplies>"] = "Chester Copperpot <General & Trade Supplies>"
L["Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"] = "Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"
L["Child"] = "Child"
L["Chomper"] = "Chomper"
L["Chromie"] = "Chromie"
L["Chronicler Bah'Kini"] = "Chronicler Bah'Kini"
L["Clarissa"] = "Clarissa"
L["Click to open Dungeon Journal window."] = "Click to open Dungeon Journal window."
L["Coffer of Forgotten Souls"] = "Coffer of Forgotten Souls"
L["Colon"] = ": "
L["Colonel Zerran"] = "Colonel Zerran"
L["Colosos"] = "Colosos"
L["Comma"] = ", "
L["Commander Bagran"] = "Commander Bagran"
L["Commander Lindon"] = "Commander Lindon"
L["Commander Mograine"] = "Commander Mograine"
L["Compendium of the Fallen"] = "Compendium of the Fallen"
L["Connection"] = "Connection"
L["Core Fragment"] = "Core Fragment"
L["CoT"] = "CoT"
L["CoT1"] = "CoT1"
L["CoT2"] = "CoT2"
L["CoT3"] = "CoT3"
L["CoT-DS"] = "CoT-DS"
L["CoT-ET"] = "CoT-ET"
L["CoT-HoT"] = "CoT-HoT"
L["CoT-Strat"] = "CoT-Strat"
L["CoT-WoE"] = "CoT-WoE"
L["CR"] = "CR"
L["Crus"] = "Crus"
L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] = "Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"
L["Crusade Commander Korfax <Brotherhood of the Light>"] = "Crusade Commander Korfax <Brotherhood of the Light>"
L["Crusaders' Coliseum"] = "Crusaders' Coliseum"
L["Crusaders' Square Postbox"] = "Crusaders' Square Postbox"
L["Cryo-Engineer Sha'heen"] = "Cryo-Engineer Sha'heen"
L["Cursed Centaur"] = "Cursed Centaur"
L["Darkheart"] = "Darkheart"
L["Dark Keeper Key"] = "Dark Keeper Key"
L["Dark Ranger Kalira"] = "Dark Ranger Kalira"
L["Dark Ranger Loralen"] = "Dark Ranger Loralen"
L["Dark Ranger Marrah"] = "Dark Ranger Marrah"
L["Dark Ranger Velonara"] = "Dark Ranger Velonara"
L["Dasnurimi <Geologist & Conservator>"] = "Dasnurimi <Geologist & Conservator>"
L["Dealer Tariq <Shady Dealer>"] = "Dealer Tariq <Shady Dealer>"
L["Dealer Vijaad"] = "Dealer Vijaad"
L["Deathstalker Commander Belmont"] = "Deathstalker Commander Belmont"
L["Defender Mordun"] = "Defender Mordun"
L["Dire Maul Arena"] = "Dire Maul Arena"
L["Dire Pool"] = "Dire Pool"
L["Divination Scryer"] = "Divination Scryer"
L["DM"] = "DM"
L["Dominic"] = "Dominic"
L["Don Carlos"] = "Don Carlos"
L["D'ore"] = "D'ore"
L["Draenei Spirit"] = "Draenei Spirit"
L["Drakkisath's Brand"] = "Drakkisath's Brand"
L["Drakuru's Brazier"] = "Drakuru's Brazier"
L["Drisella"] = "Drisella"
L["Druid of the Talon"] = "Druid of the Talon"
L["DTK"] = "DTK"
L["Earthbinder Rayge"] = "Earthbinder Rayge"
L["Earthwarden Yrsa <The Earthen Ring>"] = "Earthwarden Yrsa <The Earthen Ring>"
L["East"] = "East"
L["EB"] = "EB"
L["Ebonlocke <The Noble>"] = "Ebonlocke <The Noble>"
L["Ebru <Disciple of Naralex>"] = "Ebru <Disciple of Naralex>"
L["Echoing Horn of the Damned"] = "Echoing Horn of the Damned"
L["Echo of Medivh"] = "Echo of Medivh"
L["Elder Chogan'gada"] = "Elder Chogan'gada"
L["Elder Farwhisper"] = "Elder Farwhisper"
L["Elder Igasho"] = "Elder Igasho"
L["Elder Jarten"] = "Elder Jarten"
L["Elder Kilias"] = "Elder Kilias"
L["Elder Mistwalker"] = "Elder Mistwalker"
L["Elder Morndeep"] = "Elder Morndeep"
L["Elder Nurgen"] = "Elder Nurgen"
L["Elder Ohanzee"] = "Elder Ohanzee"
L["Elder Splitrock"] = "Elder Splitrock"
L["Elders' Square Postbox"] = "Elders' Square Postbox"
L["Elder Starsong"] = "Elder Starsong"
L["Elder Stonefort"] = "Elder Stonefort"
L["Elder Wildmane"] = "Elder Wildmane"
L["Elder Yurauk"] = "Elder Yurauk"
L["Elevator"] = "Elevator"
L["Ellrys Duskhallow"] = "Ellrys Duskhallow"
L["End"] = "End"
L["Engineer"] = "Engineer"
L["Entrance"] = "Entrance"
L["Eramas Brightblaze"] = "Eramas Brightblaze"
L["Erozion"] = "Erozion"
L["Escape from Durnholde Keep"] = "Escape from Durnholde Keep"
L["Estulan <The Highborne>"] = "Estulan <The Highborne>"
L["Eternos"] = "Eternos"
L["Ethereal Transporter Control Panel"] = "Ethereal Transporter Control Panel"
L["Eulinda <Reagents>"] = "Eulinda <Reagents>"
L["Eva Sarkhoff"] = "Eva Sarkhoff"
L["Event"] = "Event"
L["Exalted"] = "Exalted"
L["Exarch Larethor"] = "Exarch Larethor"
L["Exit"] = "Exit"
L["Face <S.A.F.E.>"] = "Face <S.A.F.E.>"
L["Fairbanks"] = "Fairbanks"
L["Falrin Treeshaper"] = "Falrin Treeshaper"
L["Farmer Kent"] = "Farmer Kent"
L["Farseer Tooranu <The Earthen Ring>"] = "Farseer Tooranu <The Earthen Ring>"
L["Father Flame"] = "Father Flame"
L["Fathom Stone"] = "Fathom Stone"
L["Fel Crystals"] = "Fel Crystals"
L["Fenstalker"] = "Fenstalker"
L["Ferra"] = "Ferra"
L["Festival Lane Postbox"] = "Festival Lane Postbox"
L["FH1"] = "FH1"
L["FH2"] = "FH2"
L["FH3"] = "FH3"
L["Field Commander Mahfuun"] = "Field Commander Mahfuun"
L["Finkle Einhorn"] = "Finkle Einhorn"
L["Fire of Aku'mai"] = "Fire of Aku'mai"
L["First Fragment Guardian"] = "First Fragment Guardian"
L["Fizzle"] = "Fizzle"
L["FL"] = "FL"
L["Flaming Eradicator"] = "Flaming Eradicator"
L["Flesh'rok the Diseased <Primordial Saurok Horror>"] = "Flesh'rok the Diseased <Primordial Saurok Horror>"
L["Focused Eye"] = "Focused Eye"
L["Forbidden Rites and other Rituals Necromantic"] = "Forbidden Rites and other Rituals Necromantic"
L["Forest Frogs"] = "Forest Frogs"
L["FoS"] = "FoS"
L["Four Kaldorei Elites"] = "Four Kaldorei Elites"
L["Fourth Stop"] = "Fourth Stop"
L["Frances Lin <Barmaid>"] = "Frances Lin <Barmaid>"
L["Fras Siabi's Postbox"] = "Fras Siabi's Postbox"
L["From previous map"] = "From previous map"
L["Front"] = "Front"
L["Frostwyrm Lair"] = "Frostwyrm Lair"
L["Furgus Warpwood"] = "Furgus Warpwood"
L["Galamav the Marksman <Kargath Expeditionary Force>"] = "Galamav the Marksman <Kargath Expeditionary Force>"
L["Galgrom <Provisioner>"] = "Galgrom <Provisioner>"
L["Garaxxas"] = "Garaxxas"
L["Gazakroth"] = "Gazakroth"
L["GB"] = "GB"
L["GD"] = "GD"
L["Ghost"] = "Ghost"
L["GL"] = "GL"
L["Gnome"] = "Gnome"
L["Gomora the Bloodletter"] = "Gomora the Bloodletter"
L["Gorkun Ironskull"] = "Gorkun Ironskull"
L["Gradav <The Warlock>"] = "Gradav <The Warlock>"
L["Graveyard"] = "Graveyard"
L["Greatfather Aldrimus"] = "Greatfather Aldrimus"
L["GSS"] = "GSS"
L["Guardian of Time"] = "Guardian of Time"
L["Gub <Destroyer of Fish>"] = "Gub <Destroyer of Fish>"
L["Guerrero"] = "Guerrero"
L["Gun"] = "Gun"
L["Gunny"] = "Gunny"
L["GY"] = "GY"
L["Ha'lei"] = "Ha'lei"
L["Ha'Lei"] = "Ha'Lei"
L["Hallow's End"] = "Hallow's End"
L["Halls"] = "Halls"
L["Hal McAllister"] = "Hal McAllister"
L["Hann Ibal <S.A.F.E.>"] = "Hann Ibal <S.A.F.E.>"
L["Harald <Food Vendor>"] = "Harald <Food Vendor>"
L["Hastings <The Caretaker>"] = "Hastings <The Caretaker>"
L["Haunted Stable Hand"] = "Haunted Stable Hand"
L["Hazlek"] = "Hazlek"
L["HC"] = "HC"
L["Helcular"] = "Helcular"
L["Helpful Jungle Monkey"] = "Helpful Jungle Monkey"
L["Herod the Bully"] = "Herod the Bully"
L["Heroic"] = "Heroic"
L["Heroic: Trial of the Grand Crusader"] = "Heroic: Trial of the Grand Crusader"
L["Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"] = "Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"
L["High Examiner Tae'thelan Bloodwatcher <The Reliquary>"] = "High Examiner Tae'thelan Bloodwatcher <The Reliquary>"
L["High Justice Grimstone"] = "High Justice Grimstone"
L["HM"] = "HM"
L["HoF"] = "HoF"
L["HoL"] = "HoL"
L["Holy Paladin"] = "Holy Paladin"
L["Holy Priest"] = "Holy Priest"
L["HoO"] = "HoO"
L["Hooded Crusader"] = "Hooded Crusader"
L["HoR"] = "HoR"
L["Horde Encampment"] = "Horde Encampment"
L["Horvon the Armorer <Armorsmith>"] = "Horvon the Armorer <Armorsmith>"
L["HoS"] = "HoS"
L["Hunter"] = "Hunter"
L["Hyphen"] = " - "
L["IC"] = "IC"
L["ID"] = "ID"
L["Image of Argent Confessor Paletress"] = "Image of Argent Confessor Paletress"
L["Image of Drakuru"] = "Image of Drakuru"
L["Imp"] = "Imp"
L["Indormi <Keeper of Ancient Gem Lore>"] = "Indormi <Keeper of Ancient Gem Lore>"
L["Innkeeper Monica"] = "Innkeeper Monica"
L["Instructor Chillheart's Phylactery"] = "Instructor Chillheart's Phylactery"
L["In the Shadow of the Light"] = "In the Shadow of the Light"
L["Investigator Fezzen Brasstacks"] = "Investigator Fezzen Brasstacks"
L["Invoker Xorenth"] = "Invoker Xorenth"
L["Ironbark the Redeemed"] = "Ironbark the Redeemed"
L["Isfar"] = "Isfar"
L["Isillien"] = "Isillien"
L["Itesh"] = "Itesh"
L["Jaelyne Evensong"] = "Jaelyne Evensong"
L["Jalinda Sprig <Morgan's Militia>"] = "Jalinda Sprig <Morgan's Militia>"
L["Jay Lemieux"] = "Jay Lemieux"
L["J'eevee's Jar"] = "J'eevee's Jar"
L["Je'neu Sancrea <The Earthen Ring>"] = "Je'neu Sancrea <The Earthen Ring>"
L["Jerry Carter"] = "Jerry Carter"
L["Jonathan Revah"] = "Jonathan Revah"
L["Joseph the Awakened"] = "Joseph the Awakened"
L["Joseph the Crazed"] = "Joseph the Crazed"
L["Joseph the Insane <Scarlet Champion>"] = "Joseph the Insane <Scarlet Champion>"
L["Julie Honeywell"] = "Julie Honeywell"
L["Kagani Nightstrike"] = "Kagani Nightstrike"
L["Kagtha"] = "Kagtha"
L["Kaldir Ironbane"] = "Kaldir Ironbane"
L["Kaldrick"] = "Kaldrick"
L["Kamsis <The Conjurer>"] = "Kamsis <The Conjurer>"
L["Kandrostrasz <Brood of Alexstrasza>"] = "Kandrostrasz <Brood of Alexstrasza>"
L["Kand Sandseeker <Explorer's League>"] = "Kand Sandseeker <Explorer's League>"
L["Kara"] = "Kara"
L["Kasha"] = "Kasha"
L["Kaulema the Mover"] = "Kaulema the Mover"
L["Keanna's Log"] = "Keanna's Log"
L["Kel'Thuzad's Deep Knowledge"] = "Kel'Thuzad's Deep Knowledge"
L["Kevin Dawson <Morgan's Militia>"] = "Kevin Dawson <Morgan's Militia>"
L["Key"] = "Key"
L["Kherrah"] = "Kherrah"
L["King's Square Postbox"] = "King's Square Postbox"
L["Knot Thimblejack"] = "Knot Thimblejack"
L["Koragg"] = "Koragg"
L["Korag Proudmane"] = "Korag Proudmane"
L["Koren <The Blacksmith>"] = "Koren <The Blacksmith>"
L["Koristrasza"] = "Koristrasza"
L["Kurzel"] = "Kurzel"
L["Lady Catriona Von'Indi"] = "Lady Catriona Von'Indi"
L["Lady Jaina Proudmoore"] = "Lady Jaina Proudmoore"
L["Lady Keira Berrybuck"] = "Lady Keira Berrybuck"
L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Lady Sylvanas Windrunner <Banshee Queen>"
L["Lakka"] = "Lakka"
L["Lana Stouthammer"] = "Lana Stouthammer"
L["Landing Spot"] = "Landing Spot"
L["Large Stone Obelisk"] = "Large Stone Obelisk"
L["LBRS"] = "LBRS"
L["LCoT"] = "LCoT"
L["L-DQuote"] = "\""
L["Lead Prospector Durdin <Explorer's League>"] = "Lead Prospector Durdin <Explorer's League>"
L["Legionnaire Nazgrim"] = "Legionnaire Nazgrim"
L["Lenzo"] = "Lenzo"
L["Lexlort <Kargath Expeditionary Force>"] = "Lexlort <Kargath Expeditionary Force>"
L["Lib"] = "Lib"
L["Library"] = "Library"
L["Lidia Sunglow <The Reliquary>"] = "Lidia Sunglow <The Reliquary>"
L["Lieutenant Horatio Laine"] = "Lieutenant Horatio Laine"
L["Lieutenant Sinclari"] = "Lieutenant Sinclari"
L["Little Jimmy Vishas"] = "Little Jimmy Vishas"
L["Lokhtos Darkbargainer <The Thorium Brotherhood>"] = "Lokhtos Darkbargainer <The Thorium Brotherhood>"
L["Lord Afrasastrasz"] = "Lord Afrasastrasz"
L["Lord Crispin Ference"] = "Lord Crispin Ference"
L["Lord Itharius"] = "Lord Itharius"
L["Lord Raadan"] = "Lord Raadan"
L["Lord Robin Daris"] = "Lord Robin Daris"
L["Lorekeeper Javon"] = "Lorekeeper Javon"
L["Lorekeeper Kildrath"] = "Lorekeeper Kildrath"
L["Lorekeeper Lydros"] = "Lorekeeper Lydros"
L["Lorekeeper Mykos"] = "Lorekeeper Mykos"
L["Lorgalis Manuscript"] = "Lorgalis Manuscript"
L["Lothos Riftwaker"] = "Lothos Riftwaker"
L["Love is in the Air"] = "Love is in the Air"
L["Lower"] = "Lower"
L["L-Parenthesis"] = " ("
L["L-SBracket"] = "["
L["Lucien Sarkhoff"] = "Lucien Sarkhoff"
L["Lumbering Oaf"] = "Lumbering Oaf"
L["Lunar Festival"] = "Lunar Festival"
L["Lurah Wrathvine <Crystallized Firestone Collector>"] = "Lurah Wrathvine <Crystallized Firestone Collector>"
L["Madrigosa"] = "Madrigosa"
L["Mag"] = "Mag"
L["Mage"] = "Mage"
L["Magical Brazier"] = "Magical Brazier"
L["Magistrate Henry Maleb"] = "Magistrate Henry Maleb"
L["Mail Box"] = "Mail Box"
L["Main Chambers Access Panel"] = "Main Chambers Access Panel"
L["Major Pakkon"] = "Major Pakkon"
L["Major Yeggeth"] = "Major Yeggeth"
L["Mamdy the \"Ologist\""] = "Mamdy the \"Ologist\""
L["MapA"] = " [A]"
L["MapB"] = " [B]"
L["MapC"] = " [C]"
L["MapD"] = " [D]"
L["MapE"] = " [E]"
L["MapF"] = " [F]"
L["MapG"] = " [G]"
L["MapH"] = " [H]"
L["MapI"] = " [I]"
L["MapJ"] = " [J]"
L["MapsNotFound"] = [=[Current selected dungeon does not have a 
corresponding map image associated with. 

Please make sure you have installed 
the corresponding Atlas map module(s).]=]
L["Mara"] = "Mara"
L["Market Row Postbox"] = "Market Row Postbox"
L["Marshal Jacob Alerius"] = "Marshal Jacob Alerius"
L["Marshal Maxwell <Morgan's Militia>"] = "Marshal Maxwell <Morgan's Militia>"
L["Martin Victus"] = "Martin Victus"
L["Master Craftsman Wilhelm <Brotherhood of the Light>"] = "Master Craftsman Wilhelm <Brotherhood of the Light>"
L["Master Elemental Shaper Krixix"] = "Master Elemental Shaper Krixix"
L["Master Windstrong"] = "Master Windstrong"
L["MaT"] = "MT"
L["Mawago"] = "Mawago"
L["Maxwort Uberglint"] = "Maxwort Uberglint"
L["Mayara Brightwing <Morgan's Militia>"] = "Mayara Brightwing <Morgan's Militia>"
L["Mazoga's Spirit"] = "Mazoga's Spirit"
L["MC"] = "MC"
L["Mech"] = "Mech"
L["Meeting Stone"] = "Meeting Stone"
L["Meeting Stone of Hellfire Citadel"] = "Meeting Stone of Hellfire Citadel"
L["Meeting Stone of Magtheridon's Lair"] = "Meeting Stone of Magtheridon's Lair"
L["Melasong"] = "Melasong"
L["Melissa"] = "Melissa"
L["Merithra of the Dream"] = "Merithra of the Dream"
L["Micah"] = "Micah"
L["Middle"] = "Middle"
L["Midsummer Festival"] = "Midsummer Festival"
L["Millhouse Manastorm"] = "Millhouse Manastorm"
L["Miss Mayhem"] = "Miss Mayhem"
L["Mistress Nagmara"] = "Mistress Nagmara"
L["Monara <The Last Queen>"] = "Monara <The Last Queen>"
L["Monk"] = "Monk"
L["Moonwell"] = "Moonwell"
L["Mor'Lek the Dismantler"] = "Mor'Lek the Dismantler"
L["Mortaxx <The Tolling Bell>"] = "Mortaxx <The Tolling Bell>"
L["Mortog Steamhead"] = "Mortog Steamhead"
L["Mountaineer Orfus <Morgan's Militia>"] = "Mountaineer Orfus <Morgan's Militia>"
L["MP"] = "MP"
L["Mr. Bigglesworth"] = "Mr. Bigglesworth"
L["MT"] = "MT"
L["Murd Doc <S.A.F.E.>"] = "Murd Doc <S.A.F.E.>"
L["Muyoh <Disciple of Naralex>"] = "Muyoh <Disciple of Naralex>"
L["MV"] = "MV"
L["Mysterious Bookshelf"] = "Mysterious Bookshelf"
L["Nahuud"] = "Nahuud"
L["Nalpak <Disciple of Naralex>"] = "Nalpak <Disciple of Naralex>"
L["Naralex"] = "Naralex"
L["Naresir Stormfury <Avengers of Hyjal Quartermaster>"] = "Naresir Stormfury <Avengers of Hyjal Quartermaster>"
L["Nathanos Marris"] = "Nathanos Marris"
L["Nat Pagle"] = "Nat Pagle"
L["Naturalist Bite"] = "Naturalist Bite"
L["Nax"] = "Nax"
L["Neptulon"] = "Neptulon"
L["Nex, Nexus"] = "Nex, Nexus"
L["Nexus-Prince Haramad"] = "Nexus-Prince Haramad"
L["Night Elf Village"] = "Night Elf Village"
L["No'ku Stormsayer <Lord of Tempest>"] = "No'ku Stormsayer <Lord of Tempest>"
L["Norkani"] = "Norkani"
L["North"] = "North"
L["Nozari <Keepers of Time>"] = "Nozari <Keepers of Time>"
L["Nozdormu"] = "Nozdormu"
L["Nurse Lillian"] = "Nurse Lillian"
L["Ocu"] = "Ocu"
L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Okuno <Ashtongue Deathsworn Quartermaster>"
L["Old Ironbark"] = "Old Ironbark"
L["Olga Runesworn <Explorer's League>"] = "Olga Runesworn <Explorer's League>"
L["Ony"] = "Ony"
L["Opening of the Dark Portal"] = "Opening of the Dark Portal"
L["Optional"] = "Optional"
L["Oralius <Morgan's Militia>"] = "Oralius <Morgan's Militia>"
L["Orange"] = "Orange"
L["Orb of Command"] = "Orb of Command"
L["Orb of Domination"] = "Orb of Domination"
L["OS"] = "OS"
L["Outside"] = "Outside"
L["Overcharged Manacell"] = "Overcharged Manacell"
L["Overseer Blingbang"] = "Overseer Blingbang"
L["Overwatch Mark 0 <Protector>"] = "Overwatch Mark 0 <Protector>"
L["Packleader Ivar Bloodfang"] = "Packleader Ivar Bloodfang"
L["Packmaster Stonebruiser <Brotherhood of the Light>"] = "Packmaster Stonebruiser <Brotherhood of the Light>"
L["Paladin"] = "Paladin"
L["Path to the Broken Stairs"] = "Path to the Broken Stairs"
L["Path to the Hellfire Ramparts and Shattered Halls"] = "Path to the Hellfire Ramparts and Shattered Halls"
L["Period"] = ". "
L["Phin Odelic <The Kirin Tor>"] = "Phin Odelic <The Kirin Tor>"
L["Polyformic Acid Potion"] = "Polyformic Acid Potion"
L["Portal"] = "Portal"
L["PoS"] = "PoS"
L["PossibleMissingModule"] = "It is likely this map is from this module: "
L["Precious"] = "Precious"
L["Priest"] = "Priest"
L["Priestess Summerpetal"] = "Priestess Summerpetal"
L["Priestess Udum'bra"] = "Priestess Udum'bra"
L["Private Jacint"] = "Private Jacint"
L["Private Rocknot"] = "Private Rocknot"
L["Professor Slate"] = "Professor Slate"
L["Prospector Doren"] = "Prospector Doren"
L["Prospector Seymour <Morgan's Militia>"] = "Prospector Seymour <Morgan's Militia>"
L["Protection Warrior"] = "Protection Warrior"
L["Provisioner Tsaalt"] = "Provisioner Tsaalt"
L["Pumpkin Shrine"] = "Pumpkin Shrine"
L["Purple"] = "Purple"
L["Pylons"] = "Pylons"
L["Quartermaster Lewis <Quartermaster>"] = "Quartermaster Lewis <Quartermaster>"
L["Raleigh the True"] = "Raleigh the True"
L["Ramdor the Mad"] = "Ramdor the Mad"
L["Ramp"] = "Ramp"
L["Ramp down to the Gamesman's Hall"] = "Ramp down to the Gamesman's Hall"
L["Ramp to Guardian's Library"] = "Ramp to Guardian's Library"
L["Ramp to Medivh's Chamber"] = "Ramp to Medivh's Chamber"
L["Ramp up to the Celestial Watch"] = "Ramp up to the Celestial Watch"
L["Random"] = "Random"
L["Randy Whizzlesprocket"] = "Randy Whizzlesprocket"
L["Rare"] = "Rare"
L["Raven"] = "Raven"
L["Razal'blade <Kargath Expeditionary Force>"] = "Razal'blade <Kargath Expeditionary Force>"
L["Razorfen Spearhide"] = "Razorfen Spearhide"
L["R-DQuote"] = "\""
L["Reclaimer A'zak"] = "Reclaimer A'zak"
L["Red Dragonflight Chamber"] = "Red Dragonflight Chamber"
L["Red Riding Hood"] = "Red Riding Hood"
L["Reinforced Archery Target"] = "Reinforced Archery Target"
L["Reinforced Fel Iron Chest"] = "Reinforced Fel Iron Chest"
L["Relic Coffer Key"] = "Relic Coffer Key"
L["Relissa"] = "Relissa"
L["Relwyn Shadestar"] = "Relwyn Shadestar"
L["Renault Mograine"] = "Renault Mograine"
L["Repair"] = "Repair"
L["Reputation"] = "Reputation"
L["Retribution Paladin"] = "Retribution Paladin"
L["Rewards"] = "Rewards"
L["RFC"] = "RFC"
L["RFD"] = "RFD"
L["RFK"] = "RFK"
L["Rifle Commander Coe"] = "Rifle Commander Coe"
L["Rifleman Brownbeard"] = "Rifleman Brownbeard"
L["Rimefang"] = "Rimefang"
L["Rocky Horror"] = "Rocky Horror"
L["Rogue"] = "Rogue"
L["Rosa"] = "Rosa"
L["Roughshod Pike"] = "Roughshod Pike"
L["R-Parenthesis"] = ") "
L["RS"] = "RS"
L["R-SBracket"] = "]"
L["Sa'at <Keepers of Time>"] = "Sa'at <Keepers of Time>"
L["Safe Room"] = "Safe Room"
L["Sally Whitemane"] = "Sally Whitemane"
L["SB"] = "SB"
L["SBG"] = "SBG"
L["SC"] = "SC"
L["Scarshield Quartermaster <Scarshield Legion>"] = "Scarshield Quartermaster <Scarshield Legion>"
L["Schematic: Field Repair Bot 74A"] = "Schematic: Field Repair Bot 74A"
L["Scholo"] = "Scholo"
L["Scourge Invasion Points"] = "Scourge Invasion Points"
L["Scout Cage"] = "Scout Cage"
L["Scout Orgarr"] = "Scout Orgarr"
L["Scout Thaelrid"] = "Scout Thaelrid"
L["Scrying Orb"] = "Scrying Orb"
L["Sebastian <The Organist>"] = "Sebastian <The Organist>"
L["Second Fragment Guardian"] = "Second Fragment Guardian"
L["Second Stop"] = "Second Stop"
L["Seer Ixit"] = "Seer Ixit"
L["Seer Kanai"] = "Seer Kanai"
L["Seer Olum"] = "Seer Olum"
L["Semicolon"] = "; "
L["Sentinel Aluwyn"] = "Sentinel Aluwyn"
L["Sentinel-trainee Issara"] = "Sentinel-trainee Issara"
L["Servant Quarters"] = "Servant Quarters"
L["Seth"] = "Seth"
L["SFK"] = "SFK"
L["SH"] = "SH"
L["Shado-Master Chum Kiu"] = "Shado-Master Chum Kiu"
L["Shadowforge Brazier"] = "Shadowforge Brazier"
L["Shadow Lord Xiraxis"] = "Shadow Lord Xiraxis"
L["Shadow Priest"] = "Shadow Priest"
L["Shaman"] = "Shaman"
L["Shattered Hand Executioner"] = "Shattered Hand Executioner"
L["Shavalius the Fancy <Flight Master>"] = "Shavalius the Fancy <Flight Master>"
L["Shen'dralar Ancient"] = "Shen'dralar Ancient"
L["Shen'dralar Provisioner"] = "Shen'dralar Provisioner"
L["Shen'dralar Watcher"] = "Shen'dralar Watcher"
L["Shrine of Gelihast"] = "Shrine of Gelihast"
L["Sif"] = "Sif"
L["Sinan the Dreamer"] = "Sinan the Dreamer"
L["Sindragosa's Lair"] = "Sindragosa's Lair"
L["Sister Svalna"] = "Sister Svalna"
L["Skar'this the Heretic"] = "Skar'this the Heretic"
L["SL"] = "SL"
L["Slash"] = " / "
L["\"Slim\" <Shady Dealer>"] = "\"Slim\" <Shady Dealer>"
L["Slinky Sharpshiv"] = "Slinky Sharpshiv"
L["Slither"] = "Slither"
L["Sliver <Garaxxas' Pet>"] = "Sliver <Garaxxas' Pet>"
L["Slosh <Food & Drink>"] = "Slosh <Food & Drink>"
L["SM"] = "SM"
L["SNT"] = "SNT"
L["SoO"] = "SoO"
L["Soridormi <The Scale of Sands>"] = "Soridormi <The Scale of Sands>"
L["South"] = "South"
L["Southshore Inn"] = "Southshore Inn"
L["SP"] = "SP"
L["Spawn Point"] = "Spawn Point"
L["Spinestalker"] = "Spinestalker"
L["Spiral Stairs to Netherspace"] = "Spiral Stairs to Netherspace"
L["Spirit of Agamaggan <Ancient>"] = "Spirit of Agamaggan <Ancient>"
L["Spirit of Olum"] = "Spirit of Olum"
L["Spirit of Udalo"] = "Spirit of Udalo"
L["SPM"] = "SPM"
L["Spoils of Blackfathom"] = "Spoils of Blackfathom"
L["Spy Grik'tha"] = "Spy Grik'tha"
L["Spy To'gun"] = "Spy To'gun"
L["SR"] = "SR"
L["SSC"] = "SSC"
L["ST"] = "ST"
L["Stairs to Underground Pond"] = "Stairs to Underground Pond"
L["Stairs to Underground Well"] = "Stairs to Underground Well"
L["Stalvan Mistmantle"] = "Stalvan Mistmantle"
L["Start"] = "Start"
L["Steps and path to the Blood Furnace"] = "Steps and path to the Blood Furnace"
L["Steward of Time <Keepers of Time>"] = "Steward of Time <Keepers of Time>"
L["Stinky"] = "Stinky"
L["Stocks"] = "Stocks"
L["Stone Guard Kurjack"] = "Stone Guard Kurjack"
L["Stone Guard Stok'ton"] = "Stone Guard Stok'ton"
L["Stonemaul Ogre"] = "Stonemaul Ogre"
L["Stormherald Eljrrin"] = "Stormherald Eljrrin"
L["Strat"] = "Strat"
L["Stratholme Courier"] = "Stratholme Courier"
L["Summon"] = "Summon"
L["Summoner's Tomb"] = "Summoner's Tomb"
L["SuP"] = "SP"
L["Suspicious Bookshelf"] = "Suspicious Bookshelf"
L["SV"] = "SV"
L["Taelan"] = "Taelan"
L["Talking Skull"] = "Talking Skull"
L["Taretha"] = "Taretha"
L["Teleporter"] = "Teleporter"
L["Teleporter destination"] = "Teleporter destination"
L["Teleporter to Middle"] = "Teleporter to Middle"
L["TEoE"] = "TEoE"
L["TES"] = "TES"
L["Thal'trak Proudtusk <Kargath Expeditionary Force>"] = "Thal'trak Proudtusk <Kargath Expeditionary Force>"
L["The Behemoth"] = "The Behemoth"
L["The Black Anvil"] = "The Black Anvil"
L["The Black Forge"] = "The Black Forge"
L["The Captain's Chest"] = "The Captain's Chest"
L["The Codex of Blood"] = "The Codex of Blood"
L["The Culling of Stratholme"] = "The Culling of Stratholme"
L["The Dark Grimoire"] = "The Dark Grimoire"
L["The Dark Portal"] = "The Dark Portal"
L["The Deed to Brill"] = "The Deed to Brill"
L["The Deed to Caer Darrow"] = "The Deed to Caer Darrow"
L["The Deed to Southshore"] = "The Deed to Southshore"
L["The Deed to Tarren Mill"] = "The Deed to Tarren Mill"
L["The Discs of Norgannon"] = "The Discs of Norgannon"
L["The Eye of Haramad"] = "The Eye of Haramad"
L["The Keepers"] = "The Keepers"
L["The Map of Zul'Aman"] = "The Map of Zul'Aman"
L["The Master's Terrace"] = "The Master's Terrace"
L["The Nameless Prophet"] = "The Nameless Prophet"
L["The Saga of Terokk"] = "The Saga of Terokk"
L["The Shadowforge Lock"] = "The Shadowforge Lock"
L["The Siege"] = "The Siege"
L["The Sparklematic 5200"] = "The Sparklematic 5200"
L["The Underspore"] = "The Underspore"
L["The Vault"] = "The Vault"
L["Third Fragment Guardian"] = "Third Fragment Guardian"
L["Third Stop"] = "Third Stop"
L["Thomas Yance <Travelling Salesman>"] = "Thomas Yance <Travelling Salesman>"
L["Thrall"] = "Thrall"
L["Thrall <Warchief>"] = "Thrall <Warchief>"
L["Thunderheart <Kargath Expeditionary Force>"] = "Thunderheart <Kargath Expeditionary Force>"
L["Thurg"] = "Thurg"
L["Tiki Lord Mu'Loa"] = "Tiki Lord Mu'Loa"
L["Tiki Lord Zim'wae"] = "Tiki Lord Zim'wae"
L["Tinkee Steamboil"] = "Tinkee Steamboil"
L["Tink Sprocketwhistle <Engineering Supplies>"] = "Tink Sprocketwhistle <Engineering Supplies>"
L["TJS"] = "TJS"
L["TK"] = "TK"
L["Tol'mar"] = "Tol'mar"
L["Tol'vir Grave"] = "Tol'vir Grave"
L["To next map"] = "To next map"
L["Top"] = "Top"
L["Torben Zapblast <Teleportation Specialist>"] = "Torben Zapblast <Teleportation Specialist>"
L["Torch Lever"] = "Torch Lever"
L["Tormented Soulpriest"] = "Tormented Soulpriest"
L["Tor-Tun <The Slumberer>"] = "Tor-Tun <The Slumberer>"
L["ToT"] = "ToT"
L["ToTT"] = "ToTT"
L["Towards Illidan Stormrage"] = "Towards Illidan Stormrage"
L["Towards Reliquary of Souls"] = "Towards Reliquary of Souls"
L["Towards Teron Gorefiend"] = "Towards Teron Gorefiend"
L["Tower of Flame"] = "Tower of Flame"
L["Tower of Frost"] = "Tower of Frost"
L["Tower of Life"] = "Tower of Life"
L["Tower of Storms"] = "Tower of Storms"
L["Train Ride"] = "Train Ride"
L["Tran'rek"] = "Tran'rek"
L["Transport"] = "Transport"
L["Tribunal Chest"] = "Tribunal Chest"
L["TSC"] = "TSC"
L["T'shu"] = "T'shu"
L["Tunnel"] = "Tunnel"
L["TWT"] = "TWT"
L["Tydormu <Keeper of Lost Artifacts>"] = "Tydormu <Keeper of Lost Artifacts>"
L["Tyllan"] = "Tyllan"
L["Tyrande Whisperwind <High Priestess of Elune>"] = "Tyrande Whisperwind <High Priestess of Elune>"
L["Tyrith"] = "Tyrith"
L["UB"] = "UB"
L["UBRS"] = "UBRS"
L["Udalo"] = "Udalo"
L["UK, Keep"] = "UK, Keep"
L["Ulda"] = "Ulda"
L["Uldu"] = "Uldu"
L["Unblinking Eye"] = "Unblinking Eye"
L["Underwater"] = "Underwater"
L["Upper"] = "Upper"
L["Upper Spire"] = "Upper Spire"
L["UP, Pinn"] = "UP, Pinn"
L["Urok's Tribute Pile"] = "Urok's Tribute Pile"
L["Varies"] = "Varies"
L["VC"] = "VC"
L["Vehini <Assault Provisions>"] = "Vehini <Assault Provisions>"
L["Velastrasza"] = "Velastrasza"
L["Vend-O-Tron D-Luxe"] = "Vend-O-Tron D-Luxe"
L["Venomancer Mauri <The Snake's Whisper>"] = "Venomancer Mauri <The Snake's Whisper>"
L["Venomancer T'Kulu <The Toxic Bite>"] = "Venomancer T'Kulu <The Toxic Bite>"
L["Verdisa"] = "Verdisa"
L["Vethsera <Brood of Ysera>"] = "Vethsera <Brood of Ysera>"
L["VH"] = "VH"
L["VoA"] = "VoA"
L["Vol'jin"] = "Vol'jin"
L["Voodoo Pile"] = "Voodoo Pile"
L["Vorrel Sengutz"] = "Vorrel Sengutz"
L["VP"] = "VP"
L["Wanders"] = "Wanders"
L["Warden Thelwater"] = "Warden Thelwater"
L["Warlock"] = "Warlock"
L["Warlord Goretooth <Kargath Expeditionary Force>"] = "Warlord Goretooth <Kargath Expeditionary Force>"
L["Warlord Salaris"] = "Warlord Salaris"
L["Warmage Kaitlyn"] = "Warmage Kaitlyn"
L["Warrior"] = "Warrior"
L["Watcher Gashra"] = "Watcher Gashra"
L["Watcher Jhang"] = "Watcher Jhang"
L["Watcher Narjil"] = "Watcher Narjil"
L["Watcher Silthik"] = "Watcher Silthik"
L["Watchman Doomgrip"] = "Watchman Doomgrip"
L["Wave 10"] = "Wave 10"
L["Wave 12"] = "Wave 12"
L["Wave 18"] = "Wave 18"
L["Wave 5"] = "Wave 5"
L["Wave 6"] = "Wave 6"
L["WC"] = "WC"
L["Weeder Greenthumb"] = "Weeder Greenthumb"
L["Weegli Blastfuse"] = "Weegli Blastfuse"
L["Weldon Barov <House of Barov>"] = "Weldon Barov <House of Barov>"
L["West"] = "West"
L["Willix the Importer"] = "Willix the Importer"
L["Windcaller Claw"] = "Windcaller Claw"
L["Witch Doctor Qu'in <Medicine Woman>"] = "Witch Doctor Qu'in <Medicine Woman>"
L["Witch Doctor T'wansi"] = "Witch Doctor T'wansi"
L["Wizard of Oz"] = "Wizard of Oz"
L["Wrath of the Lich King"] = "Wrath of the Lich King"
L["Wravien <The Mage>"] = "Wravien <The Mage>"
L["Yarley <Armorer>"] = "Yarley <Armorer>"
L["Yazzai"] = "Yazzai"
L["Young Blanchy"] = "Young Blanchy"
L["Ythyar"] = "Ythyar"
L["Yuka Screwspigot <Engineering Supplies>"] = "Yuka Screwspigot <Engineering Supplies>"
L["ZA"] = "ZA"
L["Zaladormu"] = "Zaladormu"
L["Zanza the Restless"] = "Zanza the Restless"
L["Zanzil's Cauldron of Burning Blood"] = "Zanzil's Cauldron of Burning Blood"
L["Zanzil's Cauldron of Frostburn Formula"] = "Zanzil's Cauldron of Frostburn Formula"
L["Zanzil's Cauldron of Toxic Torment"] = "Zanzil's Cauldron of Toxic Torment"
L["Zao'cho <The Emperor's Shield>"] = "Zao'cho <The Emperor's Shield>"
L["Zelfan"] = "Zelfan"
L["Zeya"] = "Zeya"
L["ZF"] = "ZF"
L["ZG"] = "ZG"
L["Zixil <Aspiring Merchant>"] = "Zixil <Aspiring Merchant>"
L["Zungam"] = "Zungam"
L["ToC/Description"] = "Instance Map Browser"
L["ToC/Title"] = "Atlas"




end