﻿-- $Id: Atlas-esMX.lua 31 2016-06-23 07:30:35Z arith $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2016 - Arith Hsu, Atlas Team <atlas.addon@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas", "esMX", false);

-- Atlas Spanish (Mexico) Localization
-- Traducido por --> maqjav|Marosth de Tyrande<--
-- maqjav@gmail.com
-- Última Actualización (last update): 05/12/2015

-- Atlas Spanish (Mexico) Localization
if ( GetLocale() == "esMX" ) then
-- Define the leading strings to be ignored while sorting
-- Ex: The Stockade
AtlasSortIgnore = {"the (.+)"};

-- Syntax: ["real_zone_name"] = "localized map zone name"
AtlasZoneSubstitutions = {
	["Ahn'Qiraj"] = "Templo de Ahn'Qiraj";
	["The Temple of Atal'Hakkar"] = "El Templo de Atal'Hakkar";
--	["Throne of Tides"] = "Fauce Abisal: Trono de las Mareas";
};
end


if L then
L["Abandonded Mole Machine"] = "Máquina topo abandonada"
L["Abbendis"] = "Abbendis"
L["AC"] = "CA"
L["Acride <Scarshield Legion>"] = "Acride <Legión Escudo del Estigma>"
L["Adult"] = "Adulto"
L["Advance Scout Chadwick"] = "Explorador táctico Chadwick"
L["Aged Dalaran Wizard"] = "Zhaorí Dalaran envejecido"
L["Ahn'kahet Brazier"] = "Blandón Ahn'kahet"
L["AKA"] = "AKA" -- Needs review
L["AK, Kahet"] = "Kahet"
L["Alexi Barov <House of Barov>"] = "Alexi Barov <Casa Barov>"
L["Alexston Chrome <Tavern of Time>"] = "Alexston Cromo <La Taberna del Tiempo>"
L["Alliance Base"] = "Base de la Alianza"
L["Altar of Blood"] = "Altar de sangre"
L["Altar of the Deeps"] = "Altar de las profundidades"
L["Alurmi"] = "Alurmi"
L["Alurmi <Keepers of Time Quartermaster>"] = "Alurmi <Intendente de los Vigilantes del Tiempo>"
L["Aluyen <Reagents>"] = "Aluyen <Vendedor de Componentes>"
L["Alyson Antille"] = "Alyson Antille"
L["\"Ambassador\" Dagg'thol"] = "\"Embajador\" Dagg'thol"
L["Ambassador Pax'ivi"] = "Embajador Pax'ivi"
L["Ambrose Boltspark"] = "Ambrose Chisparrayo"
L["Amnennar's Phylactery"] = "Filacteria de Ammennar"
L["Anachronos <Keepers of Time>"] = "Anacronos <Vigilantes del Tiempo>"
L["Ancient Equine Spirit"] = "Antiguo espíritu equino"
L["Ancient Treasure"] = "Tesoro Antiguo"
L["Andorgos <Brood of Malygos>"] = "Andorgos <Camada de Malygos>"
L["Andormu <Keepers of Time>"] = "Andormu <Vigilantes del Tiempo"
L["AN, Nerub"] = "AN, Nerub"
L["Aoren Sunglow <The Reliquary>"] = "Aoren Brillo del Sol <El Relicario>"
L["Apoko"] = "Apoko"
L["Apothecary Baxter <Crown Chemical Co.>"] = "Boticario Baxter <Químicos La Corona, S.L.>"
L["Apothecary Frye <Crown Chemical Co.>"] = "Boticario Frye <Químicos La Corona, S.L.>"
L["Apothecary Hummel <Crown Chemical Co.>"] = "Boticario Hummel <Químicos La Corona, S.L.> "
L["Apothecary Trio"] = "Trío de boticarios "
L["Apprentice Darius"] = "Aprendiz Darius"
L["AQ"] = "AQ"
L["AQ10"] = "AQ10"
L["AQ20"] = "AQ20"
L["AQ40"] = "AQ40"
L["Arazmodu <The Scale of Sands>"] = "Arazmodu <La Escama de las Arenas>"
L["Arca"] = "Arca"
L["Arcane Container"] = "Contenedor Arcano"
L["Archivum Console"] = "Consola de El Archivum"
L["Archmage Alturus"] = "Archimago Alturus"
L["Archmage Angela Dosantos <Brotherhood of the Light>"] = "Archimaga Angela Dosantos <Hermandad de la Luz>"
L["Archmage Elandra <Kirin Tor>"] = "Archimaga Elandra <Kirin Tor>"
L["Archmage Koreln <Kirin Tor>"] = "Archimago Koreln <Kirin Tor>"
L["Archmage Leryda"] = "Archimaga Leryda"
L["Archritualist Kelada"] = "Archiritualista Kelada"
L["Arinoth"] = "Arinoth"
L["Armory"] = "Armería"
L["Arms Warrior"] = "Guerrero Armas"
L["Artificer Morphalius"] = "Artificiero Morphalius"
L["Arygos"] = "Arygos"
L["Ashelan Northwood"] = "Ashelan Bosquenorte"
L["ATLAS_BUTTON_CLOSE"] = "Cerrar"
L["ATLAS_BUTTON_TOOLTIP_HINT"] = "Click izquierdo para abrir Atlas.\\nClick central para opciones.\\nClick derecho y arrastrar para mover el icono."
L["ATLAS_BUTTON_TOOLTIP_TITLE"] = "Atlas"
L["ATLAS_DDL_CONTINENT"] = "Continente" -- Needs review
L["ATLAS_DDL_CONTINENT_BROKENISLES"] = "Mazmorras de las Islas Abruptas"
L["ATLAS_DDL_CONTINENT_DEEPHOLM"] = "Mazmorras de Infralar"
L["ATLAS_DDL_CONTINENT_DRAENOR"] = "Mazmorras de Draenor"
L["ATLAS_DDL_CONTINENT_EASTERN"] = "Mazmorras de los Reinos del Este"
L["ATLAS_DDL_CONTINENT_KALIMDOR"] = "Mazmorras de Kalimdor"
L["ATLAS_DDL_CONTINENT_NORTHREND"] = "Mazmorras de Rasganorte"
L["ATLAS_DDL_CONTINENT_OUTLAND"] = "Mazmorras de Terrallende"
L["ATLAS_DDL_CONTINENT_PANDARIA"] = "Mazmorras de Pandaria"
L["ATLAS_DDL_EXPANSION"] = "Expansión" -- Needs review
L["ATLAS_DDL_EXPANSION_BC"] = "Mazmorras de Burning Crusade"
L["ATLAS_DDL_EXPANSION_CATA"] = "Mazmorras de Cataclysm"
L["ATLAS_DDL_EXPANSION_LEGION"] = "Mazmorras de Legion"
L["ATLAS_DDL_EXPANSION_MOP"] = "Mazmorras de Mists of Pandaria"
L["ATLAS_DDL_EXPANSION_OLD_AO"] = "Antiguas Mazmorras A-O"
L["ATLAS_DDL_EXPANSION_OLD_PZ"] = "Antiguas Mazmorras P-Z"
L["ATLAS_DDL_EXPANSION_WOD"] = "Mazmorras de Warlords of Draenor"
L["ATLAS_DDL_EXPANSION_WOTLK"] = "Mazmorras Wrath of the Lich King"
L["ATLAS_DDL_LEVEL"] = "Nivel" -- Needs review
L["ATLAS_DDL_LEVEL_100PLUS"] = "Mazmorras de nivel 100+"
L["ATLAS_DDL_LEVEL_100TO110"] = "Mazmorras de nivel 100-110"
L["ATLAS_DDL_LEVEL_110PLUS"] = "Mazmorras de nivel 110+"
L["ATLAS_DDL_LEVEL_45TO60"] = "Mazmorras de nivel 45-60"
L["ATLAS_DDL_LEVEL_60TO70"] = "Mazmorras de nivel 60-70"
L["ATLAS_DDL_LEVEL_70TO80"] = "Mazmorras de nivel 70-80"
L["ATLAS_DDL_LEVEL_80TO85"] = "Mazmorras de nivel 80-85"
L["ATLAS_DDL_LEVEL_85PLUS"] = "Mazmorras de nivel 85+"
L["ATLAS_DDL_LEVEL_85TO90"] = "Mazmorras de nivel 85-90"
L["ATLAS_DDL_LEVEL_90TO100"] = "Mazmorras de nivel 90-100"
L["ATLAS_DDL_LEVEL_UNDER45"] = "Mazmorras de nivel inferior a 45"
L["ATLAS_DDL_PARTYSIZE"] = "Tamaño del grupo" -- Needs review
L["ATLAS_DDL_PARTYSIZE_10_AN"] = "Mazmorras para 10 jugadores A-N"
L["ATLAS_DDL_PARTYSIZE_10_OZ"] = "Mazmorras para 10 jugadores O-Z"
L["ATLAS_DDL_PARTYSIZE_20TO40"] = "Mazmorras para 20-40 jugadores"
L["ATLAS_DDL_PARTYSIZE_20TO40AH"] = "Mazmorras para 20-40 jugadores A-H"
L["ATLAS_DDL_PARTYSIZE_20TO40IZ"] = "Mazmorras para 20-40 jugadores I-Z"
L["ATLAS_DDL_PARTYSIZE_5_AE"] = "Mazmorras para 5 jugadores A-E"
L["ATLAS_DDL_PARTYSIZE_5_FS"] = "Mazmorras para 5 jugadores F-S"
L["ATLAS_DDL_PARTYSIZE_5_TZ"] = "Mazmorras para 5 jugadores T-Z"
L["ATLAS_DDL_TYPE"] = "Tipo" -- Needs review
L["ATLAS_DDL_TYPE_ENTRANCE"] = "Entradas"
L["ATLAS_DDL_TYPE_INSTANCE_AB"] = "Mazmorras A-B"
L["ATLAS_DDL_TYPE_INSTANCE_AC"] = "Mazmorras  A-C"
L["ATLAS_DDL_TYPE_INSTANCE_CF"] = "Mazmorras C-F"
L["ATLAS_DDL_TYPE_INSTANCE_DR"] = "Mazmorras D-R"
L["ATLAS_DDL_TYPE_INSTANCE_GM"] = "Mazmorras G-M"
L["ATLAS_DDL_TYPE_INSTANCE_NS"] = "Mazmorras N-S"
L["ATLAS_DDL_TYPE_INSTANCE_SZ"] = "Mazmorras S-Z"
L["ATLAS_DDL_TYPE_INSTANCE_TZ"] = "Mazmorras T-Z"
L["ATLAS_DEP_MSG1"] = "Atlas ha detectado uno o varios modulos sin actualizar."
L["ATLAS_DEP_MSG2"] = "Se han sido desactivados para este personaje."
L["ATLAS_DEP_MSG3"] = "Borralos de tu directorio AddOns."
L["ATLAS_DEP_OK"] = "Vale"
L["ATLAS_ENTRANCE_BUTTON"] = "Entrada"
L["ATLAS_INFO"] = "Información de Atlas"
L["ATLAS_INFO_12200"] = [=[Aviso importante:

Debido al aumento del tamaño en los 
archivos de este accesorio, se han separado parte de los mapas de mazmorras, 
y otros accesorios internos en módulos separados.

Los usuarios que descarguen este accesorio desde conocidas páginas web obtendrán 
únicamente el núcleo del accesorio, el cual solo contiene la función del núcleo 
y los mapas de la última expansión.

Los usuarios que también quieran descargar los mapas de las mazmorras antiguas y 
los mapas de todos los plug-ins 
de Atlas hechos por nosotros, tendrán que 
descargarselos por separado.

Para mas información accede a:
http://www.atlasmod.com/phpBB3/viewtopic.php?t=1522]=]
L["ATLAS_INFO_12201"] = [=[Te informamos de que hemos creado un nuevo plug-in - |cff6666ffAtlas Escenarios|cffffffff, 
que contiene los nuevos mapas de los escenarios introducidos en WoW 5.0. 

Para mas detalles aacede a nuestra web, y no olvides de descargarlo / 
instalarlo por separado.
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_INSTANCE_BUTTON"] = "Mazmorra"
L["ATLAS_LDB_HINT"] = [=[Click izquierdo para abrir Atlas.
Click central para opciones.
Click derecho para mostrar el menú.]=]
L["ATLAS_MINIMAPLDB_HINT"] = [=[Click izquierdo para abrir Atlas.
Click derecho para mostrar las opciones.
Click izquierdo y arrastrar para mover este botón.]=]
L["ATLAS_MISSING_MODULE"] = "Atlas has detected missing module(s) / plugin(s): "
L["ATLAS_OPTIONS_ACRONYMS"] = "Mostrar acrónimos"
L["ATLAS_OPTIONS_ACRONYMS_TIP"] = "Muestra el acrónimo de la mazmorra en los detalles del mapa."
L["ATLAS_OPTIONS_AUTOSEL"] = "Auto-Seleccionar mazmorra"
L["ATLAS_OPTIONS_AUTOSEL_TIP"] = "Auto seleccionar mapa de mazmorra. Atlas detectará tu posición y elegirá mostrarte el mapa mas idóneo."
L["ATLAS_OPTIONS_BOSS_DESC"] = "Muestra la descripción del jefe cuando este disponible"
L["ATLAS_OPTIONS_BOSS_DESC_SCALE"] = "Escala de las ventanitas con la descripción del jefe en el mapa"
L["ATLAS_OPTIONS_BOSS_DESC_TIP"] = "Cuando pasas el ratón por encima del número del jefe, muestra la descripción del jefe si la información está disponible."
L["ATLAS_OPTIONS_BUTPOS"] = "Posición del icono"
L["ATLAS_OPTIONS_BUTRAD"] = "Radio del botón"
L["ATLAS_OPTIONS_BUTTON"] = "Opciones"
L["ATLAS_OPTIONS_CATDD"] = "Ordenar los mapas de mazmorra por:"
L["ATLAS_OPTIONS_CHECKMODULE"] = "Recuérdame que módulo(s) / plug-in(s) falta(n)."
L["ATLAS_OPTIONS_CHECKMODULE_TIP"] = "Activar para comprobar si falta algún módulo / plug-in de Atlas después del inicio de WoW."
L["ATLAS_OPTIONS_CLAMPED"] = "Ajustar ventana a la pantalla"
L["ATLAS_OPTIONS_CLAMPED_TIP"] = "Fija la ventana de Atlas. Desactiva el poder mover la ventana de Atlas fuera de la pantalla del juego."
L["ATLAS_OPTIONS_COLORINGDROPDOWN"] = "Mostrar listado de mazmorras con colores"
L["ATLAS_OPTIONS_COLORINGDROPDOWN_TIP"] = "Muestra con colores el nivel de dificultad de la mazmorra, basándose en el nivel mínimo recomendado de la mazmorra y en el nivel del personaje. "
L["ATLAS_OPTIONS_CTRL"] = "Pulsar control para ver las herramientas"
L["ATLAS_OPTIONS_CTRL_TIP"] = "Activa mostrar ventanas emergentes de texto mientras pulsas Ctrl y pasas el ratón por encima de la información del mapa. Es util cuando el texto es demasiado largo y no se puede mostrar en la ventana."
L["ATLAS_OPTIONS_DONTSHOWAGAIN"] = "No mostrar la misma información de nuevo."
L["ATLAS_OPTIONS_LOCK"] = "Bloquea la ventana de Atlas"
L["ATLAS_OPTIONS_LOCK_TIP"] = "Bloquea / desbloquea la ventana de Atlas."
L["ATLAS_OPTIONS_RCLICK"] = "Botón derecho para mapa del mundo"
L["ATLAS_OPTIONS_RCLICK_TIP"] = "Activa click derecho en la ventana del Atlas para cambiar al mapa del mundo."
L["ATLAS_OPTIONS_RESETPOS"] = "Resetear posición"
L["ATLAS_OPTIONS_SCALE"] = "Escala"
L["ATLAS_OPTIONS_SHOWBUT"] = "Mostrar botón en el minimapa"
L["ATLAS_OPTIONS_SHOWBUT_TIP"] = "Muestra el botón de Atlas en el minimapa."
L["ATLAS_OPTIONS_TRANS"] = "Transparencia"
L["ATLAS_SEARCH_UNAVAIL"] = "Buscar no disponible"
L["ATLAS_SLASH"] = "/atlas"
L["ATLAS_SLASH_OPTIONS"] = "opciones"
L["ATLAS_STRING_CLEAR"] = "Limpiar"
L["ATLAS_STRING_LEVELRANGE"] = "Rango de nivel" -- Needs review
L["ATLAS_STRING_LOCATION"] = "Localización"
L["ATLAS_STRING_MINLEVEL"] = "Nivel mínimo"
L["ATLAS_STRING_PLAYERLIMIT"] = "Límite de Jugadores"
L["ATLAS_STRING_RECLEVELRANGE"] = "Rng. nivel" -- Needs review
L["ATLAS_STRING_SEARCH"] = "Buscar"
L["ATLAS_STRING_SELECT_CAT"] = "Seleccionar Categoría"
L["ATLAS_STRING_SELECT_MAP"] = "Seleccionar Mapa"
L["ATLAS_TITLE"] = "Atlas"
L["Attunement Required"] = "Armonización requerida"
L["Auch"] = "Auch"
L["Augh"] = "Augh"
L["Auld Stonespire"] = "Auld Picopiedra"
L["Auntie Stormstout"] = "Tía Cerveza de Trueno"
L["Avatar of the Martyred"] = "Avatar de los Martirizados"
L["Back"] = "Atras"
L["Baelog's Chest"] = "El Cofre de Baelog"
L["Bakkalzu"] = "Bakkalzu"
L["Baleflame"] = "Fardollama"
L["Ban Bearheart"] = "Ban Corazón Fiero"
L["Barkeep Kelly <Bartender>"] = "Posadero Kelly <Camarero>"
L["Barnes <The Stage Manager>"] = "Barnes <El Director de escena>"
L["Baroness Dorothea Millstipe"] = "Baronesa Dorothea Tallolino"
L["Baron Rafe Dreuger"] = "Barón Rafe Dreuger"
L["Basement"] = "Sótano"
L["Battle for Mount Hyjal"] = "La Batalla del Monte Hyjal"
L["B.E Barechus <S.A.F.E.>"] = "B.E Barechus <S.E.G.U.R.O.>"
L["Belgaristrasz"] = "Belgaristrasz"
L["Belnistrasz"] = "Belnistrasz"
L["Bennett <The Sergeant at Arms>"] = "Bennett <El Sargento de Armas>"
L["Berinand's Research"] = "Investigación de Berinand"
L["Berserking Boulder Roller"] = "Rodador de piedra rabioso"
L["Berthold <The Doorman>"] = "Berthold <El Portero>"
L["BF"] = "HS"
L["BFD"] = "CB"
L["BH"] = "BH"
L["Bilger the Straight-laced"] = "Maestro cervecero Bilger"
L["BINDING_HEADER_ATLAS_TITLE"] = "Enlaces Atlas"
L["BINDING_NAME_ATLAS_AUTOSEL"] = "Auto-Selecciona"
L["BINDING_NAME_ATLAS_OPTIONS"] = "Opciones de la Barra"
L["BINDING_NAME_ATLAS_TOGGLE"] = "Barra del Atlas"
L["Black Dragonflight Chamber"] = "Cámara del vuelo Negro"
L["Blacksmithing Plans"] = "Planos de herrero"
L["Blastmaster Emi Shortfuse"] = "Maestro Destructor Emi Plomocorto"
L["Blood Guard Hakkuz <Darkspear Elite>"] = "Guardia de sangre Hakkuz <Élite Lanza Negra>"
L["Blood of Innocents"] = "Sangre inocente"
L["Bloodslayer T'ara <Darkspear Veteran>"] = "Cercenacastas T'ara <Veterana Lanza Negra>"
L["Bloodslayer Vaena <Darkspear Veteran>"] = "Cercenacastas Vaena <Veterana Lanza Negra>"
L["Bloodslayer Zala <Darkspear Veteran>"] = "Cercenacastas Zala <Veterana Lanza Negra>"
L["Bodley"] = "Bodley"
L["Bortega <Reagents & Poison Supplies>"] = "Bortega <Suministros de venenos y componentes>"
L["BoT"] = "BoT"
L["Bota"] = "Inver"
L["Bovaal Whitehorn"] = "Bovaal Cuernoblanco"
L["Bowmistress Li <Guard Captain>"] = "Maestra arquera Li <Capitana de la Guardia>"
L["Brann Bronzebeard"] = "Brann Barbabronce"
L["Brazen"] = "Brazen"
L["BRC"] = "BRC"
L["BRD"] = "PRN"
L["Brewfest"] = "Festival de la cerveza"
L["BRF"] = "BRF"
L["Brigg Smallshanks"] = "Brigg Espinillas"
L["Briney Boltcutter <Blackwater Financial Interests>"] = "Salobre Cortarrayos <Intereses financieros Aguasnegras>"
L["BRM"] = "MRN"
L["Broken Stairs"] = "Escaleras rotas"
L["BSM"] = "BSM"
L["BT"] = "TO"
L["Bucket of Meaty Dog Food"] = "Cubo de comida para perros carnosa"
L["BWD"] = "BWD"
L["BWL"] = "GAN"
L["Cache of Eregos"] = "Alijo de Eregos"
L["Caelestrasz"] = "Caelestrasz"
L["Calliard <The Nightman>"] = "Calliard <El Hombre de la noche>"
L["Captain Alina"] = "Capitán Alina"
L["Captain Boneshatter"] = "Capitán Huesodestrozado"
L["Captain Drenn"] = "Capitán Drenn"
L["Captain Edward Hanes"] = "Capitán Edward Hanes"
L["Captain Hadan"] = "Capitán Hadan"
L["\"Captain\" Kaftiz"] = "\"Capitán\" Kaftiz"
L["Captain Qeez"] = "Capitán Condurso"
L["Captain Sanders"] = "Capitán Sanders"
L["Captain Taylor"] = "Capitán Taylor"
L["Captain Tuubid"] = "Capitán Tuubid"
L["Captain Wyrmak"] = "Capitán Wyrmak"
L["Captain Xurrem"] = "Capitán Xurrem"
L["Cath"] = "Cate"
L["Cathedral"] = "Catedral"
L["Cavern Entrance"] = "Entrada a la caverna"
L["Caza'rez"] = "Caza'rez"
L["Celebras the Redeemed"] = "Celebras el Redimido"
L["Centrifuge Construct"] = "Ensamblaje de centrifugadora"
L["Champ"] = "Camp"
L["Champions of the Alliance"] = "Campeones de la Alianza"
L["Champions of the Horde"] = "Campeones de la Horda"
L["Charred Bone Fragment"] = "Trozo de hueso carbonizado"
L["Chase Begins"] = "Comienza persecución"
L["Chase Ends"] = "Final persecución"
L["Chef Jessen <Speciality Meat & Slop>"] = "Jefe Jessen <Especialidad en carne y bazofia>"
L["Chen Stormstout"] = "Chen Cerveza de Trueno"
L["Chester Copperpot <General & Trade Supplies>"] = "Chester Tarrodecobre <Suministros generales y objetos comerciales>"
L["Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"] = "Ingeniero jefe Pasaquillas <Compañía de aguas de Gadgetzan>"
L["Child"] = "Niño"
L["Chomper"] = "Mastic"
L["Chromie"] = "Cromi"
L["Chronicler Bah'Kini"] = "Cronista Bah'Kini"
L["Clarissa"] = "Clarissa"
L["Click to open Dungeon Journal window."] = "Click para abrir la ventana de la Guía de mazmorras."
L["Coffer of Forgotten Souls"] = "Arca de las almas olvidadas"
L["Colon"] = ": " -- Needs review
L["Colonel Zerran"] = "Coronel Zerran"
L["Colosos"] = "Colosos"
-- L["Comma"] = ""
L["Commander Bagran"] = "Comandante Bagran"
L["Commander Lindon"] = "Comandante Lindon"
L["Commander Mograine"] = "Comandante Mograine"
L["Compendium of the Fallen"] = "Compendio de los Caídos"
L["Connection"] = "Conexión"
L["Core Fragment"] = "Trozo del Núcleo"
L["CoT"] = "CdT"
L["CoT1"] = "CdT1"
L["CoT2"] = "CdT2"
L["CoT3"] = "CdT3"
L["CoT-DS"] = "CdT-AD"
L["CoT-ET"] = "CdT-FD"
L["CoT-HoT"] = "CdT-HC"
L["CoT-Strat"] = "Strat, CdT-Strat"
L["CoT-WoE"] = "CdT-PdT"
L["CR"] = "RCT"
L["Crus"] = "Cruz"
L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] = "Comandante de Cruzada Eligor Albar <Hermandad de la Luz>"
L["Crusade Commander Korfax <Brotherhood of the Light>"] = "Comandante de Cruzada Korfax <Hermandad de la Luz>"
L["Crusaders' Coliseum"] = "Coliseo de los Cruzados"
L["Crusaders' Square Postbox"] = "Buzón de la Plaza de los Cruzados"
L["Cryo-Engineer Sha'heen"] = "Crioingeniero Sha'heen"
L["Cursed Centaur"] = "Centauro maldito"
L["Darkheart"] = "Corazón Oscuro"
L["Dark Keeper Key"] = "Llave de guarda oscuro"
L["Dark Ranger Kalira"] = "Forestal oscura Kalira"
L["Dark Ranger Loralen"] = "Forestal oscura Loralen"
L["Dark Ranger Marrah"] = "Forestal oscura Marrah"
L["Dark Ranger Velonara"] = "Forestal oscura Velonara"
L["Dasnurimi <Geologist & Conservator>"] = "Dasnurimi <Geóloga y conservadora>"
L["Dealer Tariq <Shady Dealer>"] = "Tratante Tariq <Vendedor sospechoso>"
L["Dealer Vijaad"] = "Tratante Vijaad"
L["Deathstalker Commander Belmont"] = "Comandante Mortacechador Belmont"
L["Defender Mordun"] = "Defensor Mordun"
L["Dire Maul Arena"] = "Arena de La Masacre"
L["Dire Pool"] = "Estanque Funesto"
L["Divination Scryer"] = "Cristal de adivinación"
L["DM"] = "LM"
L["Dominic"] = "Dominic"
L["Don Carlos"] = "Don Carlos"
L["D'ore"] = "D'ore"
L["Draenei Spirit"] = "Espíritu draenei"
L["Drakkisath's Brand"] = "Enseña de Drakkisath"
L["Drakuru's Brazier"] = "El blandón de Drakuru"
L["Drisella"] = "Drisella"
L["Druid of the Talon"] = "Druida de la Garfa"
L["DTK"] = "DTK"
L["Earthbinder Rayge"] = "Lingaterra Rayge"
L["Earthwarden Yrsa <The Earthen Ring>"] = "Celadora de la tierra Yrsa <El Anillo de la Tierra>"
L["East"] = "Este"
L["EB"] = "EB"
L["Ebonlocke <The Noble>"] = "Cerranegro <El Noble>"
L["Ebru <Disciple of Naralex>"] = "Ebru <Discípula de Naralex>"
-- L["Echoing Horn of the Damned"] = ""
L["Echo of Medivh"] = "Eco de Medivh"
L["Elder Chogan'gada"] = "Ancestro Chogan'gada"
L["Elder Farwhisper"] = "Ancestro Levesusurro"
L["Elder Igasho"] = "Ancestro Igasho"
L["Elder Jarten"] = "Ancestro Jarten"
L["Elder Kilias"] = "Ancestro Kilias"
L["Elder Mistwalker"] = "Ancestro Caminalba"
L["Elder Morndeep"] = "Ancestro Alborhondo"
L["Elder Nurgen"] = "Ancestro Nurgen"
L["Elder Ohanzee"] = "Ancestro Ohanzee"
L["Elder Splitrock"] = "Ancestro Parterroca"
L["Elders' Square Postbox"] = "Buzón de la plaza de los Ancianos"
L["Elder Starsong"] = "Ancestro Cantoestelar"
L["Elder Stonefort"] = "Ancestro Petraforte"
L["Elder Wildmane"] = "Ancestro Barvacrín"
L["Elder Yurauk"] = "Ancestro Yurauk"
L["Elevator"] = "Ascensor"
L["Ellrys Duskhallow"] = "Ellrys Anochecher Santificado"
L["End"] = "Fin"
L["Engineer"] = "Ingeniero"
L["Entrance"] = "Entrada"
L["Eramas Brightblaze"] = "Eramas Llamarada Brillante"
L["Erozion"] = "Erozion"
L["Escape from Durnholde Keep"] = "Huida de Durnholde"
L["Estulan <The Highborne>"] = "Estulan <Los Altonato>"
L["Eternos"] = "Eternos"
L["Ethereal Transporter Control Panel"] = "Panel de control del transportador etéreo"
L["Eulinda <Reagents>"] = "Eulinda <Componentes>"
L["Eva Sarkhoff"] = "Eva Sarkhoff"
L["Event"] = "Evento"
L["Exalted"] = "Exaltado"
L["Exarch Larethor"] = "Exarca Larethor"
L["Exit"] = "Salida"
L["Face <S.A.F.E.>"] = "Cara <S.E.G.U.R.O.>"
L["Fairbanks"] = "Ribalimpia"
L["Falrin Treeshaper"] = "Falrin Tallarbol"
L["Farmer Kent"] = "Granjero Kent"
L["Farseer Tooranu <The Earthen Ring>"] = "Clarividente Tooranu <El Anillo de la Tierra>"
L["Father Flame"] = "Llama paternal"
L["Fathom Stone"] = "Piedra de las profundidades"
L["Fel Crystals"] = "Cristales Viles"
L["Fenstalker"] = "Fenstalker"
L["Ferra"] = "Ferra"
L["Festival Lane Postbox"] = "Buzón de la calle del Festival"
L["FH1"] = "FH1"
L["FH2"] = "CR2"
L["FH3"] = "CR3"
L["Field Commander Mahfuun"] = "Comandante de campo Mahfuun"
L["Finkle Einhorn"] = "Finkle Einhorn"
L["Fire of Aku'mai"] = "Fuego de Aku'mai"
L["First Fragment Guardian"] = "Guardián del Primer Fragmento"
L["Fizzle"] = "Fizel"
L["FL"] = "FL"
L["Flaming Eradicator"] = "Flaming Eradicator"
L["Flesh'rok the Diseased <Primordial Saurok Horror>"] = "Flesh'rok el Enfermo <Horror saurok primordial>"
L["Focused Eye"] = "Ojo enfocado"
L["Forbidden Rites and other Rituals Necromantic"] = "Ritos prohibidos y otros rituales nigrománticos"
L["Forest Frogs"] = "Ranas del bosque"
L["FoS"] = "FdA"
L["Four Kaldorei Elites"] = "Cuatro Elites Kaldorei"
L["Fourth Stop"] = "Cuarta parada"
L["Frances Lin <Barmaid>"] = "Frances Lin <Camarera>"
L["Fras Siabi's Postbox"] = "Buzón de Fras Siabi"
L["From previous map"] = "Desde mapa anterior"
L["Front"] = "Frente"
L["Frostwyrm Lair"] = "Guarida Vermis de Escarcha"
L["Furgus Warpwood"] = "Furgus Alabeo"
L["Galamav the Marksman <Kargath Expeditionary Force>"] = "Galamav el Tirador <Fuerza Expedicionaria de Kargath>"
L["Galgrom <Provisioner>"] = "Galgrom <Galgrom>"
L["Garaxxas"] = "Garaxxas"
L["Gazakroth"] = "Gazakroth"
L["GB"] = "GB"
L["GD"] = "GD"
L["Ghost"] = "Fantasma"
L["GL"] = "Gruul"
L["Gnome"] = "Gnome"
L["Gomora the Bloodletter"] = "Gomora el Flebotomista"
L["Gorkun Ironskull"] = "Gorkun Testahierro"
L["Gradav <The Warlock>"] = "Gradav <El Brujo>"
L["Graveyard"] = "Cementerio"
L["Greatfather Aldrimus"] = "Abuelo Aldrimus"
L["GSS"] = "GSS"
L["Guardian of Time"] = "Guardián del Tiempo"
L["Gub <Destroyer of Fish>"] = "Gub <Destructor de peces>"
L["Guerrero"] = "Guerrero"
L["Gun"] = "Gun"
L["Gunny"] = "Pistolete"
L["GY"] = "Cemen"
L["Ha'lei"] = "Ha'Lei"
L["Ha'Lei"] = "Ha'Lei"
L["Hallow's End"] = "Halloween"
L["Halls"] = "Salas"
L["Hal McAllister"] = "Hal McAllister"
L["Hann Ibal <S.A.F.E.>"] = "Hann Ibal <S.E.G.U.R.O.>"
L["Harald <Food Vendor>"] = "Harald <Vendedor de alimentos>"
L["Hastings <The Caretaker>"] = "Hastings <El Custodio>"
L["Haunted Stable Hand"] = "Mozo de cuadra encantado"
L["Hazlek"] = "Hazlek"
L["HC"] = "CFI"
L["Helcular"] = "Helcular"
L["Helpful Jungle Monkey"] = "Mono de la selva servicial"
L["Herod the Bully"] = "Herod el Matón"
L["Heroic"] = "Heróico"
L["Heroic: Trial of the Grand Crusader"] = "Heróica: Prueba del Gran Cruzado"
L["Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"] = "Hierofante Theodora Mulvadania <Fuerza Expedicionaria de Kargath>"
L["High Examiner Tae'thelan Bloodwatcher <The Reliquary>"] = "Alto examinador Tae'thelan Mirasangre <El Relicario>"
L["High Justice Grimstone"] = "Alto justiciero Pedrasiniestra"
L["HM"] = "HM"
L["HoF"] = "HoF"
L["HoL"] = "CdR"
L["Holy Paladin"] = "Paladín Sagrado"
L["Holy Priest"] = "Sacerdote Sagrado"
L["HoO"] = "HoO"
L["Hooded Crusader"] = "Cruzada encapuchada"
L["HoR"] = "CdR"
L["Horde Encampment"] = "Emplazamiento Horda"
L["Horvon the Armorer <Armorsmith>"] = "Horvon el Armero <Forjador de armaduras>"
L["HoS"] = "CdP"
L["Hunter"] = "Cazador"
-- L["Hyphen"] = ""
L["IC"] = "CCH"
L["ID"] = "ID"
L["Image of Argent Confessor Paletress"] = "Imagen de la confesora Argenta Cabelloclaro"
L["Image of Drakuru"] = "Imagen de Drakuru"
L["Imp"] = "Duendecillo"
L["Indormi <Keeper of Ancient Gem Lore>"] = "Indormi <Vigilante de conocimiento de gemas antiguas>"
L["Innkeeper Monica"] = "Tabernera Monica"
L["Instructor Chillheart's Phylactery"] = "Filacteria de la instructora Corazón Álgido"
L["In the Shadow of the Light"] = "A la sombra de la Luz"
L["Investigator Fezzen Brasstacks"] = "Investigator Fezzen Brasstacks"
L["Invoker Xorenth"] = "Convocador Xorenth"
L["Ironbark the Redeemed"] = "Cortezaférrea el Redimido"
L["Isfar"] = "Isfar"
L["Isillien"] = "Isillien"
L["Itesh"] = "Itesh"
L["Jaelyne Evensong"] = "Jaelyne Unicanto"
L["Jalinda Sprig <Morgan's Militia>"] = "Jalinda Espiga <Milicia de Morgan>"
L["Jay Lemieux"] = "Jay Lemieux"
L["J'eevee's Jar"] = "Tarro de J'eevee"
L["Je'neu Sancrea <The Earthen Ring>"] = "Je'neu Sancrea <El Anillo de la Tierra>"
L["Jerry Carter"] = "Jerry Carter"
L["Jonathan Revah"] = "Jonathan Revah"
L["Joseph the Awakened"] = "Joseph el Despierto"
L["Joseph the Crazed"] = "Joseph el Enloquecido"
L["Joseph the Insane <Scarlet Champion>"] = "Joseph el Loco <Campeón Escarlata>"
L["Julie Honeywell"] = "Julie Pozo de Miel"
L["Kagani Nightstrike"] = "Kajani Golpe de la Noche"
L["Kagtha"] = "Kagtha"
L["Kaldir Ironbane"] = "Kaldir Temeferro"
L["Kaldrick"] = "Kaldrick"
L["Kamsis <The Conjurer>"] = "Kamsis <La Conjuradora>"
L["Kandrostrasz <Brood of Alexstrasza>"] = "Kandrostrasz <Camada de Alexstrasza>"
L["Kand Sandseeker <Explorer's League>"] = "Kand Buscadunas <Liga de Expedicionarios>"
L["Kara"] = "Kara"
L["Kasha"] = "Kasha"
L["Kaulema the Mover"] = "Kaulema el Influyente"
L["Keanna's Log"] = "Apuntes de Keanna"
L["Kel'Thuzad's Deep Knowledge"] = "Saber profundo de Kel'Thuzad"
L["Kevin Dawson <Morgan's Militia>"] = "Kevin Dawson <Milicia de Morgan>"
L["Key"] = "Llave"
L["Kherrah"] = "Kherrah"
L["King's Square Postbox"] = "Buzón de la Plaza del Rey"
L["Knot Thimblejack"] = "Knot Llavededo"
L["Koragg"] = "Koragg"
L["Korag Proudmane"] = "Korag Proudmane"
L["Koren <The Blacksmith>"] = "Koren <El Herrero>"
L["Koristrasza"] = "Koristrasza"
L["Kurzel"] = "Kurzel"
L["Lady Catriona Von'Indi"] = "Lady Catriona Von'Indi"
L["Lady Jaina Proudmoore"] = "Lady Jaina Valiente"
L["Lady Keira Berrybuck"] = "Lady Keira Bayadol"
L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Lady Sylvanas Brisaveloz <Reina alma en pena>"
L["Lakka"] = "Lakka"
L["Lana Stouthammer"] = "Lana Martillotenaz"
L["Landing Spot"] = "Punto de Aterrizaje"
L["Large Stone Obelisk"] = "Obelisco de piedra grande"
L["LBRS"] = "LBRS"
L["LCoT"] = "LCoT"
-- L["L-DQuote"] = ""
L["Lead Prospector Durdin <Explorer's League>"] = "Prospector jefe Durdin <Liga de Expedicionarios>"
L["Legionnaire Nazgrim"] = "Legionario Nazgrim"
L["Lenzo"] = "Lenzo"
L["Lexlort <Kargath Expeditionary Force>"] = "Lexlort <Fuerza Expedicionaria de Kargath>"
L["Lib"] = "Lib"
L["Library"] = "Biblioteca"
L["Lidia Sunglow <The Reliquary>"] = "Lidia Brillo del Sol <El Relicario>"
L["Lieutenant Horatio Laine"] = "Teniente Horatio Laine"
L["Lieutenant Sinclari"] = "Teniente Sinclari"
L["Little Jimmy Vishas"] = "Pequeño Jimmy Vishas"
L["Lokhtos Darkbargainer <The Thorium Brotherhood>"] = "Lokhtos Tratoscuro <La Hermandad del Torio>"
L["Lord Afrasastrasz"] = "Lord Afrasastrasz"
L["Lord Crispin Ference"] = "Lord Crispin Ference"
L["Lord Itharius"] = "Lord Itharius"
L["Lord Raadan"] = "Lord Raadan"
L["Lord Robin Daris"] = "Lord Robin Daris"
L["Lorekeeper Javon"] = "Tradicionalista Javon"
L["Lorekeeper Kildrath"] = "Tradicionalista Kildrath"
L["Lorekeeper Lydros"] = "Tradicionalista Lydros"
L["Lorekeeper Mykos"] = "Tradicionalista Mykos"
L["Lorgalis Manuscript"] = "Manuscrito de Lorgalis"
L["Lothos Riftwaker"] = "Lothos Levantagrietas"
L["Love is in the Air"] = "Amor en el aire"
L["Lower"] = "Abajo"
-- L["L-Parenthesis"] = ""
-- L["L-SBracket"] = ""
L["Lucien Sarkhoff"] = "Lucien Sarkhoff"
L["Lumbering Oaf"] = "Patán inútil"
L["Lunar Festival"] = "Festival lunar"
L["Lurah Wrathvine <Crystallized Firestone Collector>"] = "Lurah Vid de la Ira <Coleccionista de piedras de fuego cristalizadas>"
L["Madrigosa"] = "Madrigosa"
L["Mag"] = "Mag"
L["Mage"] = "Mago"
L["Magical Brazier"] = "Blandón mágico"
L["Magistrate Henry Maleb"] = "Magistrado Henry Maleb"
L["Mail Box"] = "Buzón"
L["Main Chambers Access Panel"] = "Panel de acceso de la cámara principal"
L["Major Pakkon"] = "Mayor Pakkon"
L["Major Yeggeth"] = "Mayor Yeggeth"
L["Mamdy the \"Ologist\""] = "Mamdy el \"Todólogo\""
L["MapA"] = " [A]"
L["MapB"] = " [B]"
L["MapC"] = " [C]"
L["MapD"] = " [D]"
L["MapE"] = " [E]"
L["MapF"] = " [F]"
-- L["MapG"] = ""
-- L["MapH"] = ""
-- L["MapI"] = ""
-- L["MapJ"] = ""
L["MapsNotFound"] = [=[La mazmorra actual no dispone de su 
imagen de mapa correspondiente. 

Por favor, asegurate de tener instalado 
el módulo(s) de mapas Atlas correspondiente.]=]
L["Mara"] = "Mara"
L["Market Row Postbox"] = "Buzón de la Fila del Mercado"
L["Marshal Jacob Alerius"] = "Mariscal Jacob Alerius"
L["Marshal Maxwell <Morgan's Militia>"] = "Mariscal Maxwell <Milicia de Morgan>"
L["Martin Victus"] = "Martin Victus"
L["Master Craftsman Wilhelm <Brotherhood of the Light>"] = "Maestro artesano Wilhelm <Hermandad de la Luz>"
L["Master Elemental Shaper Krixix"] = "Maestro de los elementos Formacio Krixix"
L["Master Windstrong"] = "Maestro Viento Impetuoso"
L["MaT"] = "BM"
L["Mawago"] = "Mawago"
L["Maxwort Uberglint"] = "Maxwort Suprandor"
L["Mayara Brightwing <Morgan's Militia>"] = "Mayara Alasol <Milicia de Morgan>"
L["Mazoga's Spirit"] = "Espíritu de Mazoga"
L["MC"] = "MC"
L["Mech"] = "Mech"
L["Meeting Stone"] = "Piedra de encuentro"
L["Meeting Stone of Hellfire Citadel"] = "Piedra de encuentro de la Ciudadela de Fuego Infernal"
L["Meeting Stone of Magtheridon's Lair"] = "Piedra de encuentro de la Guarida de Magtheridon"
L["Melasong"] = "Melasong"
L["Melissa"] = "Melissa"
L["Merithra of the Dream"] = "Merithra del Sueño"
L["Micah"] = "Micah"
L["Middle"] = "Medio"
L["Midsummer Festival"] = "Festival del solsticio de verano"
L["Millhouse Manastorm"] = "Molino Tormenta de maná"
L["Miss Mayhem"] = "Miss Caos"
L["Mistress Nagmara"] = "Coima Nagmara"
L["Monara <The Last Queen>"] = "Monara <La Última Reina>"
L["Monk"] = "Monje"
L["Moonwell"] = "Claro de la luna"
L["Mor'Lek the Dismantler"] = "Mor'Lek el Destructor"
L["Mortaxx <The Tolling Bell>"] = "Mortaxx <La campana que dobla>"
L["Mortog Steamhead"] = "Mortog Testavapor"
L["Mountaineer Orfus <Morgan's Militia>"] = "Montaraz Orfus <Milicia de Morgan>"
L["MP"] = "MP"
L["Mr. Bigglesworth"] = "Sr. Biguelvalor"
L["MT"] = "TM"
L["Murd Doc <S.A.F.E.>"] = "Murd Doc <S.E.G.U.R.O.>"
L["Muyoh <Disciple of Naralex>"] = "Muyoh <Discípulo de Naralex>"
L["MV"] = "MV"
L["Mysterious Bookshelf"] = "Publicaciones sospechosas"
L["Nahuud"] = "Nahuud"
L["Nalpak <Disciple of Naralex>"] = "Nalpak <Discípulo de Naralex>"
L["Naralex"] = "Naralex"
L["Naresir Stormfury <Avengers of Hyjal Quartermaster>"] = "Naresir Furiatormenta <Intendente de los Vengadores de Hyjal>"
L["Nathanos Marris"] = "Nathanos Marris"
L["Nat Pagle"] = "Nat Pagle"
L["Naturalist Bite"] = "Naturalista Mordisco"
L["Nax"] = "Nax"
L["Neptulon"] = "Neptulon"
L["Nex, Nexus"] = "Nexo"
L["Nexus-Prince Haramad"] = "Príncipe-nexo Haramad"
L["Night Elf Village"] = "Poblado elfo de la noche"
L["No'ku Stormsayer <Lord of Tempest>"] = "Orador de la tormenta No'ku <Señor de la Tempestad>"
L["Norkani"] = "Norkani"
L["North"] = "Norte"
L["Nozari <Keepers of Time>"] = "Nozari <Vigilantes del Tiempo>"
L["Nozdormu"] = "Nozdormu"
L["Nurse Lillian"] = "Enfermera Lillian"
L["Ocu"] = "Oculus"
L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Okuno <Provisiones Juramorte Lengua de ceniza>"
L["Old Ironbark"] = "Viejo Cortezaférrea"
L["Olga Runesworn <Explorer's League>"] = "Olga Jurarruna <Liga de Expedicionarios>"
L["Ony"] = "Ony"
L["Opening of the Dark Portal"] = "Apertura de El Portal Oscuro"
L["Optional"] = "Opcional"
L["Oralius <Morgan's Militia>"] = "Oralius <Milicia de Morgan>"
L["Orange"] = "Naranja"
L["Orb of Command"] = "Orbe de orden"
L["Orb of Domination"] = "Orbe de dominación"
L["OS"] = "SO"
L["Outside"] = "Fuera"
L["Overcharged Manacell"] = "Célula de maná sobrecargada"
L["Overseer Blingbang"] = "Sobrestante Blingbang"
L["Overwatch Mark 0 <Protector>"] = "Robovigilante Mark 0 <Protector>"
L["Packleader Ivar Bloodfang"] = "Maestro de manada Ivar Colmillo de Sangre"
L["Packmaster Stonebruiser <Brotherhood of the Light>"] = "Maestro de manada Mazadura <Hermandad de la Luz>"
L["Paladin"] = "Paladín"
L["Path to the Broken Stairs"] = "Camino a las Escaleras Rotas"
L["Path to the Hellfire Ramparts and Shattered Halls"] = "Camino a Murallas y Salas Arrasadas"
-- L["Period"] = ""
L["Phin Odelic <The Kirin Tor>"] = "Phin Odelic <Los Kirin Tor>"
L["Polyformic Acid Potion"] = "La ciencia del ácido polifórmico"
L["Portal"] = "Portal"
L["PoS"] = "FdS"
L["PossibleMissingModule"] = "Posiblemente este mapa es de este módulo: "
L["Precious"] = "Precioso"
L["Priest"] = "Sacerdote"
L["Priestess Summerpetal"] = "Sacerdotisa Pétalo Estival"
L["Priestess Udum'bra"] = "Sacerdotisa Udum'bra"
L["Private Jacint"] = "Soldado Jacint"
L["Private Rocknot"] = "Soldado Sinroca"
L["Professor Slate"] = "Profesor Slate"
L["Prospector Doren"] = "Prospector Doren"
L["Prospector Seymour <Morgan's Militia>"] = "Prospector Seymour <Milicia de Morgan>"
L["Protection Warrior"] = "Guerrero Protección"
L["Provisioner Tsaalt"] = "Proveedor Tsaalt"
L["Pumpkin Shrine"] = "Santuario calabaza"
L["Purple"] = "Morado"
L["Pylons"] = "Pilones"
L["Quartermaster Lewis <Quartermaster>"] = "Intendente Lewis <Intendente>"
L["Raleigh the True"] = "Raleigh el Auténtico"
L["Ramdor the Mad"] = "Ramdor el Loco"
L["Ramp"] = "Murallas"
L["Ramp down to the Gamesman's Hall"] = "Bajada a la Sala de Juegos"
L["Ramp to Guardian's Library"] = "Rampa a la Biblioteca del Guardián"
L["Ramp to Medivh's Chamber"] = "Rampa a la Cámara de Medivh"
L["Ramp up to the Celestial Watch"] = "Subida a la Vista Celestial"
L["Random"] = "Aleatorio"
L["Randy Whizzlesprocket"] = "Randy Whizzlesprocket"
L["Rare"] = "Raro"
L["Raven"] = "Cuervo"
L["Razal'blade <Kargath Expeditionary Force>"] = "Razal'filo <Fuerza Expedicionaria de Kargath>"
L["Razorfen Spearhide"] = "Cuerolanza de Rajacieno"
-- L["R-DQuote"] = ""
L["Reclaimer A'zak"] = "Reivindicador A'zak"
L["Red Dragonflight Chamber"] = "La cámara del Vuelo de Dragones Rojo"
L["Red Riding Hood"] = "Caperucita Roja"
L["Reinforced Archery Target"] = "Objetivo de tiro con arco reforzado"
L["Reinforced Fel Iron Chest"] = "Cofre de hierro vil reforzado"
L["Relic Coffer Key"] = "Llave del arca de reliquias"
L["Relissa"] = "Relissa"
L["Relwyn Shadestar"] = "Relwyn Sombrestrella"
L["Renault Mograine"] = "Renault Mograine"
L["Repair"] = "Reparar"
L["Reputation"] = "Reputación"
L["Retribution Paladin"] = "Paladín Reprensión"
L["Rewards"] = "Recompensas"
L["RFC"] = "SI"
L["RFD"] = "ZR"
L["RFK"] = "HR"
L["Rifle Commander Coe"] = "Comandante de rifles Coe"
L["Rifleman Brownbeard"] = "Rifleman Brownbeard"
L["Rimefang"] = "Dientefrío"
L["Rocky Horror"] = "Horror rocoso"
L["Rogue"] = "Pícaro"
L["Rosa"] = "Rosa"
L["Roughshod Pike"] = "Pica férrea"
-- L["R-Parenthesis"] = ""
L["RS"] = "SR"
-- L["R-SBracket"] = ""
L["Sa'at <Keepers of Time>"] = "Sa'at <Vigilantes del Tiempo>"
L["Safe Room"] = "Habitación segura"
L["Sally Whitemane"] = "Sally Melenablanca"
L["SB"] = "SB"
L["SBG"] = "SBG"
L["SC"] = "SC"
L["Scarshield Quartermaster <Scarshield Legion>"] = "Intendente del Escudo del Estigma <Legión Escudo del Estigma>"
L["Schematic: Field Repair Bot 74A"] = "Esquema: robot de reparación de campo 74A"
L["Scholo"] = "Scholo"
L["Scourge Invasion Points"] = "Puntos Invasión de la Plaga"
L["Scout Cage"] = "Caja del explorador"
L["Scout Orgarr"] = "Explorador Orgarr"
L["Scout Thaelrid"] = "Explorador Thaelrid"
L["Scrying Orb"] = "Orbe de visión"
L["Sebastian <The Organist>"] = "Sebastian <El Organista>"
L["Second Fragment Guardian"] = "Guardián del Segundo Fragmento"
L["Second Stop"] = "Segunda parada"
L["Seer Ixit"] = "Vidente Ixit"
L["Seer Kanai"] = "Profeta Kanai"
L["Seer Olum"] = "Profeta Olum"
-- L["Semicolon"] = ""
L["Sentinel Aluwyn"] = "Centinela Aluwyn"
L["Sentinel-trainee Issara"] = "Centinela practicante Issara"
L["Servant Quarters"] = "Aposentos de los sirvientes"
L["Seth"] = "Seth"
L["SFK"] = "SFK"
L["SH"] = "SA"
L["Shado-Master Chum Kiu"] = "Maestro Shado Chum Kiu"
L["Shadowforge Brazier"] = "Blandón Forjatiniebla"
L["Shadow Lord Xiraxis"] = "Señor de las Sombras Xiraxis"
L["Shadow Priest"] = "Sacerdote Sombras"
L["Shaman"] = "Chamán"
L["Shattered Hand Executioner"] = "Ejecutor Mano Destrozada"
L["Shavalius the Fancy <Flight Master>"] = "Shavalius el Extravagante <Maestro de vuelo>"
L["Shen'dralar Ancient"] = "Ancestro Shen'dralar"
L["Shen'dralar Provisioner"] = "Proveedor Shen'dralar"
L["Shen'dralar Watcher"] = "Vigía Shen'dralar"
L["Shrine of Gelihast"] = "Altar de Gelihast"
L["Sif"] = "Sif"
L["Sinan the Dreamer"] = "Sinan la Soñadora <Custodia>"
L["Sindragosa's Lair"] = "Guarida de Sindragosa"
L["Sister Svalna"] = "Hermana Svalna"
L["Skar'this the Heretic"] = "Skar'this el Herético"
L["SL"] = "LS"
-- L["Slash"] = ""
L["\"Slim\" <Shady Dealer>"] = "\"Flaco\" <Vendedor sospechoso>"
L["Slinky Sharpshiv"] = "Finta Navajazos"
L["Slither"] = "Slither"
L["Sliver <Garaxxas' Pet>"] = "Tajada <Mascota de Garaxxas>"
L["Slosh <Food & Drink>"] = "Slosh <Alimentos y bebidas>"
L["SM"] = "SM"
L["SNT"] = "SNT"
L["SoO"] = "SoO"
L["Soridormi <The Scale of Sands>"] = "Soridormi <La Escama de las Arenas>"
L["South"] = "Sur"
L["Southshore Inn"] = "Posada de Costasur"
L["SP"] = "Recinto"
L["Spawn Point"] = "Punto de aparición"
L["Spinestalker"] = "Acechaespinas"
L["Spiral Stairs to Netherspace"] = "Escaleras de caracol a Rencor Abisal"
L["Spirit of Agamaggan <Ancient>"] = "Espíritu de Agamaggan <Anciano>"
L["Spirit of Olum"] = "Espíritu de Olum"
L["Spirit of Udalo"] = "Espíritu de Udalo"
L["SPM"] = "SPM"
L["Spoils of Blackfathom"] = "Botín de las Cavernas de Brazanegra"
L["Spy Grik'tha"] = "Espía Grik'tha"
L["Spy To'gun"] = "Espía To'gun"
L["SR"] = "SR"
L["SSC"] = "CSS"
L["ST"] = "ST"
L["Stairs to Underground Pond"] = "Escaleras a Underground Pond"
L["Stairs to Underground Well"] = "Escaleras a Underground Well"
L["Stalvan Mistmantle"] = "Stalvan Mantoniebla"
L["Start"] = "Comienzo"
L["Steps and path to the Blood Furnace"] = "Escaleras y camino hacia Hornos de Sangre"
L["Steward of Time <Keepers of Time>"] = "Administrador del Tiempo <Vigilantes del Tiempo>"
L["Stinky"] = "Apestoso"
L["Stocks"] = "Mazmorras"
L["Stone Guard Kurjack"] = "Guardia de piedra Kurjack"
L["Stone Guard Stok'ton"] = "Guardia de piedra Stok'ton"
L["Stonemaul Ogre"] = "Ogro Quebrantarrocas"
L["Stormherald Eljrrin"] = "Heraldo de tormenta Eljrrin"
L["Strat"] = "Strat"
L["Stratholme Courier"] = "Mensajero de Stratholme"
L["Summon"] = "Invocar"
L["Summoner's Tomb"] = "Tumba de los invocadores"
L["SuP"] = "MPS"
L["Suspicious Bookshelf"] = "Librería sospechosa"
L["SV"] = "CV"
L["Taelan"] = "Taelan"
L["Talking Skull"] = "Calavera parlante"
L["Taretha"] = "Taretha"
L["Teleporter"] = "Teletransportador"
L["Teleporter destination"] = "Teletransportador de destino"
L["Teleporter to Middle"] = "Teletransporte al centro"
L["TEoE"] = "OE"
L["TES"] = "TES"
L["Thal'trak Proudtusk <Kargath Expeditionary Force>"] = "Thal'trak Colmillo Orgulloso <Fuerza Expedicionaria de Kargath>"
L["The Behemoth"] = "El Behemoth"
L["The Black Anvil"] = "El Yunquenegro"
L["The Black Forge"] = "La Forjanegra"
L["The Captain's Chest"] = "El cofre del Capitán"
L["The Codex of Blood"] = "El Códice de Sangre"
L["The Culling of Stratholme"] = "La Matanza de Stratholme"
L["The Dark Grimoire"] = "El grimorio oscuro"
L["The Dark Portal"] = "El Portal Oscuro"
L["The Deed to Brill"] = "Las escrituras de Rémol"
L["The Deed to Caer Darrow"] = "Las escrituras de Castel Darrow"
L["The Deed to Southshore"] = "Las escrituras de Costasur"
L["The Deed to Tarren Mill"] = "Las escrituras de Molino Tarren"
L["The Discs of Norgannon"] = "Los Discos de Norgannon"
L["The Eye of Haramad"] = "El ojo de Haramad"
L["The Keepers"] = "Los guardiantes"
L["The Map of Zul'Aman"] = "Mapa de Zul'Aman de Budd"
L["The Master's Terrace"] = "El Bancal del Maestro"
L["The Nameless Prophet"] = "El profeta sin nombre"
L["The Saga of Terokk"] = "Esbirro de Terokk"
L["The Shadowforge Lock"] = "El candado de Forjatiniebla"
L["The Siege"] = "El asedio"
L["The Sparklematic 5200"] = "El Destellamatic 5200"
L["The Underspore"] = "La Sotoespora"
L["The Vault"] = "Cámara Negra"
L["Third Fragment Guardian"] = "Guardián del Tercer Fragmento"
L["Third Stop"] = "Tercera parada"
L["Thomas Yance <Travelling Salesman>"] = "Thomas Yance <Vendedor ambulante>"
L["Thrall"] = "Thrall"
L["Thrall <Warchief>"] = "Thrall <Jefe de Guerra>"
L["Thunderheart <Kargath Expeditionary Force>"] = "Corazón Atronador <Fuerza Expedicionaria de Kargath>"
L["Thurg"] = "Thurg"
L["Tiki Lord Mu'Loa"] = "Señor Tiki Mu'Loa"
L["Tiki Lord Zim'wae"] = "Señor Tiki Zim'wae"
L["Tinkee Steamboil"] = "Tinkee Vaporio"
L["Tink Sprocketwhistle <Engineering Supplies>"] = "Tink Silbadentado <Suministros de ingeniería>"
L["TJS"] = "TJS"
L["TK"] = "CT"
L["Tol'mar"] = "Tol'mar"
L["Tol'vir Grave"] = "Tumba de tol'vir"
L["To next map"] = "Al siguiente mapa"
L["Top"] = "Arriba"
L["Torben Zapblast <Teleportation Specialist>"] = "Torben Pumzas <Especialista en teletransporte>"
L["Torch Lever"] = "Palanca Antorcha"
L["Tormented Soulpriest"] = "Sacerdote de almas atormentado"
L["Tor-Tun <The Slumberer>"] = "Tor-Tun <El dormilón>"
L["ToT"] = "ToT"
L["ToTT"] = "ToTT"
L["Towards Illidan Stormrage"] = "Hacia Illidan Tempestira"
L["Towards Reliquary of Souls"] = "Hacia Relicario de Almas"
L["Towards Teron Gorefiend"] = "Hacia Teron Sanguino"
L["Tower of Flame"] = "Torre de Llamas"
L["Tower of Frost"] = "Torre de Escarcha"
L["Tower of Life"] = "Torre de Vida"
L["Tower of Storms"] = "Torre de Tormentas"
L["Train Ride"] = "Viaje en el tren"
L["Tran'rek"] = "Tran'rek"
-- L["Transport"] = ""
L["Tribunal Chest"] = "Cofre del tribunal"
L["TSC"] = "TSC"
L["T'shu"] = "T'shu"
L["Tunnel"] = "Túnel"
L["TWT"] = "TWT"
L["Tydormu <Keeper of Lost Artifacts>"] = "Tydormu <Vigilante de artefactos perdidos>"
L["Tyllan"] = "Tyllan"
L["Tyrande Whisperwind <High Priestess of Elune>"] = "Tyrande Susurravientos <Suma sacerdotisa de Elune>"
L["Tyrith"] = "Tyrith"
L["UB"] = "Soti"
L["UBRS"] = "UBRS"
L["Udalo"] = "Udalo"
L["UK, Keep"] = "GU, Guarida"
L["Ulda"] = "Ulda"
L["Uldu"] = "Uldu"
L["Unblinking Eye"] = "Ojo imperturbable"
L["Underwater"] = "Bajo el agua"
L["Upper"] = "Arriba"
L["Upper Spire"] = "Aguja Superior"
L["UP, Pinn"] = "PU, Pinaculo"
L["Urok's Tribute Pile"] = "Pila de tributo a Urok"
L["Varies"] = "Varios"
L["VC"] = "VC"
L["Vehini <Assault Provisions>"] = "Vehini <Provisiones de ataque>"
L["Velastrasza"] = "Velastrasza"
L["Vend-O-Tron D-Luxe"] = "Vendo-trón Deluxe"
L["Venomancer Mauri <The Snake's Whisper>"] = "Venomante Mauri <El susurro de la serpiente>"
L["Venomancer T'Kulu <The Toxic Bite>"] = "Venomante T'Kulu <La mordedura tóxica>"
L["Verdisa"] = "Verdisa"
L["Vethsera <Brood of Ysera>"] = "Vethsera <Camada de Ysera>"
L["VH"] = "BV"
L["VoA"] = "CdA"
L["Vol'jin"] = "Vol'jin"
L["Voodoo Pile"] = "Montón vudú"
L["Vorrel Sengutz"] = "Vorrel Sengutz"
L["VP"] = "VP"
L["Wanders"] = "Rondando"
L["Warden Thelwater"] = "Celador Thelagua"
L["Warlock"] = "Brujo"
L["Warlord Goretooth <Kargath Expeditionary Force>"] = "Señor de la guerra Dientegore <Fuerza Expedicionaria de Kargath>"
L["Warlord Salaris"] = "Señor de la Guerra Salaris"
L["Warmage Kaitlyn"] = "Maga de guerra Kaitlyn"
L["Warrior"] = "Guerrero"
L["Watcher Gashra"] = "Vigía Gashra"
L["Watcher Jhang"] = "Vigía Jhang"
L["Watcher Narjil"] = "Vigía Narjil"
L["Watcher Silthik"] = "Vigía Silthik"
L["Watchman Doomgrip"] = "Vigía Presaletal"
L["Wave 10"] = "Ola 10"
L["Wave 12"] = "Ola 12"
L["Wave 18"] = "Ola 18"
L["Wave 5"] = "Ola 5"
L["Wave 6"] = "Ola 6"
L["WC"] = "WC"
L["Weeder Greenthumb"] = "Desherbador Pulgaverde"
L["Weegli Blastfuse"] = "Weegli Plomofundido"
L["Weldon Barov <House of Barov>"] = "Weldon Barov <Casa Barov>"
L["West"] = "Oeste"
L["Willix the Importer"] = "Willix el Importador"
L["Windcaller Claw"] = "Clamavientos Zarpa"
L["Witch Doctor Qu'in <Medicine Woman>"] = "Médica bruja Qu'in <Médica bruja>"
L["Witch Doctor T'wansi"] = "Médico brujo T'wansi"
L["Wizard of Oz"] = "El mago de Oz"
L["Wrath of the Lich King"] = "Wrath of the Lich King"
L["Wravien <The Mage>"] = "Wravien <El Mago>"
L["Yarley <Armorer>"] = "Yarley <Armero>"
L["Yazzai"] = "Yazzai"
L["Young Blanchy"] = "Joven Blanchy"
L["Ythyar"] = "Ythyar"
L["Yuka Screwspigot <Engineering Supplies>"] = "Yuka Llavenrosca <Suministros de ingeniería>"
L["ZA"] = "ZA"
L["Zaladormu"] = "Zaladormu"
L["Zanza the Restless"] = "Zanza el Incansable"
L["Zanzil's Cauldron of Burning Blood"] = "Caldero de sangre ardiente de Zanzil"
L["Zanzil's Cauldron of Frostburn Formula"] = "Caldero de fórmula de abrasión de escarcha de Zanzil"
L["Zanzil's Cauldron of Toxic Torment"] = "Caldero de tormento tóxico de Zanzil"
L["Zao'cho <The Emperor's Shield>"] = "Zao'cho <El escudo del Emperador>"
L["Zelfan"] = "Zelfan"
L["Zeya"] = "Zeya"
L["ZF"] = "ZF"
L["ZG"] = "ZG"
L["Zixil <Aspiring Merchant>"] = "Zixil <Aspirante a mercader>"
L["Zungam"] = "Zungam"
L["ToC/Description"] = "Navegador de Mapas de Mazmorras"
L["ToC/Title"] = "Atlas"

end