﻿--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2016 - Arith Hsu, Atlas Team <atlas.addon@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas", "frFR", false);
-- Localize file must set above to false, for example:
-- local AL = AceLocale:NewLocale("Atlas", "frFR", false);

-- Atlas French Localization
-- Sur un travail de Wysiwyg, Khiria, Trasher entre 2007 et 2014
-- Many thanks to all contributors!
-- $Date: 2016-06-23 07:30:35 +0000 (Thu, 23 Jun 2016) $
-- $Revision: 31 $

if ( GetLocale() == "frFR" ) then
-- Define the leading strings to be ignored while sorting
-- Ex: The Stockade
AtlasSortIgnore = {
	"le (.+)", 
	"la (.+)", 
	"les (.+)"
};

-- Syntax: ["real_zone_name"] = "localized map zone name"
AtlasZoneSubstitutions = {
	["Le temple d'Atal'Hakkar"] = "Le temple d'Atal'Hakkar";
	["Ahn'Qiraj"] = "Temple d'Ahn'Qiraj";
};
end


if L then
L["Abandonded Mole Machine"] = "Taupe mécanique abandonnée"
L["Abbendis"] = "Abbendis"
L["AC"] = "AC"
L["Acride <Scarshield Legion>"] = "Acride <Légion du Bouclier balafré>"
L["Adult"] = "Adulte"
L["Advance Scout Chadwick"] = "Eclaireur avancé Chadwick"
L["Aged Dalaran Wizard"] = "Sorcier de Dalaran âgé"
L["Ahn'kahet Brazier"] = "Brasero d'Ahn'kahet"
L["AKA"] = "AKA" -- Needs review
L["AK, Kahet"] = "AK, Kahet"
L["Alexi Barov <House of Barov>"] = "Alexi Barov <Maison Barov>"
L["Alexston Chrome <Tavern of Time>"] = "Alexston Chrome <Gargotte du temps>"
L["Alliance Base"] = "Base de l'Alliance"
L["Altar of Blood"] = "Autel de Sang"
L["Altar of the Deeps"] = "Autel des profondeurs"
L["Alurmi"] = "Alurmi"
L["Alurmi <Keepers of Time Quartermaster>"] = "Alurmi <Intendant des gardiens du Temps>"
L["Aluyen <Reagents>"] = "Aluyen <Composants>"
L["Alyson Antille"] = "Alyson Antille"
L["\"Ambassador\" Dagg'thol"] = "\"Ambassadeur\" Dagg'thol"
L["Ambassador Pax'ivi"] = "Ambassadeur Pax'ivi"
L["Ambrose Boltspark"] = "Ambrose Étinceboulon"
L["Amnennar's Phylactery"] = "Phylactère d'Amnennar"
L["Anachronos <Keepers of Time>"] = "Anachronos <Les Gardiens du temps>"
L["Ancient Equine Spirit"] = "Ancien esprit équin"
L["Ancient Treasure"] = "Trésor Antique"
L["Andorgos <Brood of Malygos>"] = "Andorgos <Rejeton de Malygos>"
L["Andormu <Keepers of Time>"] = "Andormu <Les Gardiens du temps>"
L["AN, Nerub"] = "AN, Nerub"
L["Aoren Sunglow <The Reliquary>"] = "Aoren Soléclat <Le Reliquaire>"
L["Apoko"] = "Apoko"
L["Apothecary Baxter <Crown Chemical Co.>"] = "Apothicaire Baxter <Cie de Chimie La Royale>"
L["Apothecary Frye <Crown Chemical Co.>"] = "Apothicaire Frye <Cie de Chimie La Royale>"
L["Apothecary Hummel <Crown Chemical Co.>"] = "Apothicaire Hummel <Cie de Chimie La Royale>"
L["Apothecary Trio"] = "Trio d'apothicaires"
L["Apprentice Darius"] = "Apprenti Darius"
L["AQ"] = "AQ"
L["AQ10"] = "AQ10"
L["AQ20"] = "AQ20"
L["AQ40"] = "AQ40"
L["Arazmodu <The Scale of Sands>"] = "Arazmodu <La Balance des sables>"
L["Arca"] = "Arca"
L["Arcane Container"] = "Récipient arcanique"
L["Archivum Console"] = "Console de l'Archivum"
L["Archmage Alturus"] = "Archimage Alturus"
L["Archmage Angela Dosantos <Brotherhood of the Light>"] = "Archimage Angela Dosantos <Confrérie de la Lumière>"
L["Archmage Elandra <Kirin Tor>"] = "Archimage Elandra <Kirin Tor>"
L["Archmage Koreln <Kirin Tor>"] = "Archimage Koreln <Kirin Tor>"
L["Archmage Leryda"] = "Archimage Leryda"
L["Archritualist Kelada"] = "Archiritualiste Kelada"
L["Arinoth"] = "Arinoth"
L["Armory"] = "Armurerie"
L["Arms Warrior"] = "Guerrier Armes"
L["Artificer Morphalius"] = "Artificier Morphalius"
L["Arygos"] = "Arygos"
L["Ashelan Northwood"] = "Ashelan Bois-du-nord"
L["ATLAS_BUTTON_CLOSE"] = "Fermer"
L["ATLAS_BUTTON_TOOLTIP_HINT"] = [=[Clic-Gauche pour ouvrir Atlas.
Clic-Milieu pour les options d'Atlas.
Clic-Droit pour déplacer ce bouton.]=]
L["ATLAS_BUTTON_TOOLTIP_TITLE"] = "Atlas"
L["ATLAS_DDL_CONTINENT"] = "Continent" -- Needs review
-- L["ATLAS_DDL_CONTINENT_BROKENISLES"] = ""
L["ATLAS_DDL_CONTINENT_DEEPHOLM"] = "Instances du Tréfonds"
L["ATLAS_DDL_CONTINENT_DRAENOR"] = "Instances de Draenor"
L["ATLAS_DDL_CONTINENT_EASTERN"] = "Instances des Royaumes de l'Est"
L["ATLAS_DDL_CONTINENT_KALIMDOR"] = "Instances de Kalimdor"
L["ATLAS_DDL_CONTINENT_NORTHREND"] = "Instances de Norfendre"
L["ATLAS_DDL_CONTINENT_OUTLAND"] = "Instances de l'Outreterre"
L["ATLAS_DDL_CONTINENT_PANDARIA"] = "Instances de Pandarie"
L["ATLAS_DDL_EXPANSION"] = "Extension" -- Needs review
L["ATLAS_DDL_EXPANSION_BC"] = "Instances Burning Crusade"
L["ATLAS_DDL_EXPANSION_CATA"] = "Instances Cataclysm"
-- L["ATLAS_DDL_EXPANSION_LEGION"] = ""
L["ATLAS_DDL_EXPANSION_MOP"] = "Instances Mists of Pandaria"
L["ATLAS_DDL_EXPANSION_OLD_AO"] = "Instances du Vieux Monde (A-O)"
L["ATLAS_DDL_EXPANSION_OLD_PZ"] = "Instances du Vieux Monde (P-Z)"
L["ATLAS_DDL_EXPANSION_WOD"] = "Instances Warlords of Draenor"
L["ATLAS_DDL_EXPANSION_WOTLK"] = "Instances Wrath of the Lich King"
L["ATLAS_DDL_LEVEL"] = "Niveau" -- Needs review
L["ATLAS_DDL_LEVEL_100PLUS"] = "Instances Niveau 100+"
-- L["ATLAS_DDL_LEVEL_100TO110"] = ""
-- L["ATLAS_DDL_LEVEL_110PLUS"] = ""
L["ATLAS_DDL_LEVEL_45TO60"] = "Instances Niveau 45-60"
L["ATLAS_DDL_LEVEL_60TO70"] = "Instances Niveau 60-70"
L["ATLAS_DDL_LEVEL_70TO80"] = "Instances Niveau 70-80"
L["ATLAS_DDL_LEVEL_80TO85"] = "Instances Niveau 80-85"
L["ATLAS_DDL_LEVEL_85PLUS"] = "Instances Niveau 85+"
L["ATLAS_DDL_LEVEL_85TO90"] = "Instances Niveau 85-90"
L["ATLAS_DDL_LEVEL_90TO100"] = "Instances Niveau 90-100"
L["ATLAS_DDL_LEVEL_UNDER45"] = "Instances avant Niveau 45"
L["ATLAS_DDL_PARTYSIZE"] = "Taille de Groupe" -- Needs review
L["ATLAS_DDL_PARTYSIZE_10_AN"] = "Instances pour 10 Joueurs A-N"
L["ATLAS_DDL_PARTYSIZE_10_OZ"] = "Instances pour 10 Joueurs O-Z"
L["ATLAS_DDL_PARTYSIZE_20TO40"] = "Instances pour 20-40 Joueurs"
L["ATLAS_DDL_PARTYSIZE_20TO40AH"] = "Instances pour 20-40 Joueurs A-H"
L["ATLAS_DDL_PARTYSIZE_20TO40IZ"] = "Instances pour 20-40 Joueurs I-Z"
L["ATLAS_DDL_PARTYSIZE_5_AE"] = "Instances pour 5 Joueurs A-E"
L["ATLAS_DDL_PARTYSIZE_5_FS"] = "Instances pour 5 Joueurs F-S"
L["ATLAS_DDL_PARTYSIZE_5_TZ"] = "Instances pour 5 Joueurs T-Z"
L["ATLAS_DDL_TYPE"] = "Type" -- Needs review
L["ATLAS_DDL_TYPE_ENTRANCE"] = "Entrées"
L["ATLAS_DDL_TYPE_INSTANCE_AB"] = "Instances A-B"
L["ATLAS_DDL_TYPE_INSTANCE_AC"] = "Instances A-C"
L["ATLAS_DDL_TYPE_INSTANCE_CF"] = "Instances C-F"
L["ATLAS_DDL_TYPE_INSTANCE_DR"] = "Instances D-R"
L["ATLAS_DDL_TYPE_INSTANCE_GM"] = "Instances G-M"
L["ATLAS_DDL_TYPE_INSTANCE_NS"] = "Instances N-S"
L["ATLAS_DDL_TYPE_INSTANCE_SZ"] = "Instances S-Z"
L["ATLAS_DDL_TYPE_INSTANCE_TZ"] = "Instances T-Z"
L["ATLAS_DEP_MSG1"] = "Atlas a détecté un ou plusieurs module(s) qui ne sont pas à jour."
L["ATLAS_DEP_MSG2"] = "Ils ont été désactivés pour ce personnage."
L["ATLAS_DEP_MSG3"] = "Les supprimer de votre dossier AddOns."
L["ATLAS_DEP_OK"] = "Ok"
L["ATLAS_ENTRANCE_BUTTON"] = "Entrée"
L["ATLAS_INFO"] = "Atlas Information"
L["ATLAS_INFO_12200"] = [=[Information importante : 

Suite à l'augmentation de la taille des fichiers de l'addon, nous avons déplacé 
une partie de nos cartes des donjons et créé des modules séparés avec. 

Les utilisateurs qui téléchargent nos addons à partir de fameux sites tiers 
pourraient n'avoir que l'addon principal qui ne contient que les fonctions de 
base et les cartes de la dernière extension de WoW. 

Si vous souhaitez également voir les cartes des vieilles extensions, et donc 
avoir tous ces modules Atlas que nous avons fait, vous devez les télécharger 
et les installer séparément. 

Pour plus d'information, lire le sujet suivant sur notre forum : 
|cff6666ffhttp://www.atlasmod.com/phpBB3/viewtopic.php?t=1522|cffffffff 

Ou visiter notre site web pour voir où les télécharger. 
|cff6666ffhttp://www.atlasmod.com/]=]
L["ATLAS_INFO_12201"] = [=[Veuillez noter que nous avons créé un nouveau plug-in - |cff6666ffAtlas Scenarios|cffffffff, 
afin de fournir les cartes des scénarios introduits dans WoW 5.0. 

Visitez notre site web pour plus de détail, et n'oubliez pas de le 
télécharger/installer séparément.]=]
L["ATLAS_INSTANCE_BUTTON"] = "Instance"
L["ATLAS_LDB_HINT"] = [=[Clic-Gauche pour ouvrir Atlas.
Clic-Milieu pour les options d'Atlas.
Clic-Droit pour le menu d'affichage.]=]
L["ATLAS_MINIMAPLDB_HINT"] = [=[Clic-Gauche pour ouvrir Atlas.
Clic-Droit pour les options d'Atlas.
Clic-Gauche et glisser pour déplacer ce bouton.
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_MISSING_MODULE"] = "Atlas a détecté des module(s)/plug-in(s) manquant : "
L["ATLAS_OPTIONS_ACRONYMS"] = "Afficher les acronymes VO/VF"
L["ATLAS_OPTIONS_ACRONYMS_TIP"] = "Afficher les acronymes de l'instance dans les détails de la carte"
L["ATLAS_OPTIONS_AUTOSEL"] = "Sélection automatique de la carte"
L["ATLAS_OPTIONS_AUTOSEL_TIP"] = "Sélection automatique de la carte, Atlas détectera votre localisation pour choisir votre instance à afficher."
L["ATLAS_OPTIONS_BOSS_DESC"] = "Afficher la description des boss, si disponible"
L["ATLAS_OPTIONS_BOSS_DESC_SCALE"] = "Mise à l'échelle de l'info-bulles pour les descriptions de boss sur la carte"
L["ATLAS_OPTIONS_BOSS_DESC_TIP"] = "Afficher la description d'un boss au passage de la souris sur son numéro, si disponible."
L["ATLAS_OPTIONS_BUTPOS"] = "Position du bouton"
L["ATLAS_OPTIONS_BUTRAD"] = "Rayon du bouton"
L["ATLAS_OPTIONS_BUTTON"] = "Options"
L["ATLAS_OPTIONS_CATDD"] = "Trier les instances par :"
L["ATLAS_OPTIONS_CHECKMODULE"] = "Me rappeler en cas de module(s)/plug-in(s) manquant."
L["ATLAS_OPTIONS_CHECKMODULE_TIP"] = "Activer pour vérifier après le chargement de WoW s'il manque un module/plug-in Atlas."
L["ATLAS_OPTIONS_CLAMPED"] = "Fixer la fenêtre à l'écran"
L["ATLAS_OPTIONS_CLAMPED_TIP"] = "Fixer la fenêtre à l'écran, désactiver pour permettre de déplacer le fenêtre d'Atlas."
L["ATLAS_OPTIONS_COLORINGDROPDOWN"] = "Afficher les donjons de la liste par couleurs de difficulté"
L["ATLAS_OPTIONS_COLORINGDROPDOWN_TIP"] = "Basé sur le niveau minimum recommandé par le donjon et le niveau du joueur, pour afficher le donjon avec des couleurs de difficulté."
L["ATLAS_OPTIONS_CTRL"] = "Maintenir la touche Ctrl enfoncée pour voir les infobulles"
L["ATLAS_OPTIONS_CTRL_TIP"] = "Maintenir la touche Ctrl enfoncée pour voir les infobulles au passage de la souris. Très utile quand le texte est trop long pour apparaitre dans la fenêtre."
L["ATLAS_OPTIONS_DONTSHOWAGAIN"] = "Ne pas remontrer de nouveau l'information"
L["ATLAS_OPTIONS_LOCK"] = "Verrouiller la fenêtre d'Atlas"
L["ATLAS_OPTIONS_LOCK_TIP"] = "Verrouiller/déverrouiller la fenêtre d'Atlas"
L["ATLAS_OPTIONS_RCLICK"] = "Clic-Droit pour afficher la carte du monde"
L["ATLAS_OPTIONS_RCLICK_TIP"] = "Active le clic-droit dans la fenêtre Atlas pour afficher la carte du monde."
L["ATLAS_OPTIONS_RESETPOS"] = "Position initiale"
L["ATLAS_OPTIONS_SCALE"] = "Mise à l'échelle de la fenêtre Atlas"
L["ATLAS_OPTIONS_SHOWBUT"] = "Afficher le bouton sur la mini-carte"
L["ATLAS_OPTIONS_SHOWBUT_TIP"] = "Afficher le bouton Atlas autour de la mini-carte"
L["ATLAS_OPTIONS_TRANS"] = "Transparence"
L["ATLAS_SEARCH_UNAVAIL"] = "Recherche Indisponible"
L["ATLAS_SLASH"] = "/atlas"
L["ATLAS_SLASH_OPTIONS"] = "options"
L["ATLAS_STRING_CLEAR"] = "Nettoyer"
L["ATLAS_STRING_LEVELRANGE"] = "Niveau" -- Needs review
L["ATLAS_STRING_LOCATION"] = "Lieu"
L["ATLAS_STRING_MINLEVEL"] = "Niveau Minimum"
L["ATLAS_STRING_PLAYERLIMIT"] = "Limite de joueurs"
L["ATLAS_STRING_RECLEVELRANGE"] = "Niveau recommandé" -- Needs review
L["ATLAS_STRING_SEARCH"] = "Rechercher"
L["ATLAS_STRING_SELECT_CAT"] = "Choix de la catégorie"
L["ATLAS_STRING_SELECT_MAP"] = "Choix de la carte"
L["ATLAS_TITLE"] = "Atlas"
L["Attunement Required"] = "Harmonisation requise"
L["Auch"] = "Auch"
L["Augh"] = "Augh"
L["Auld Stonespire"] = "Cime-de-Pierre le Vieil"
L["Auntie Stormstout"] = "Tatie Brune d’Orage"
L["Avatar of the Martyred"] = "Avatar des martyrs"
L["Back"] = "de derrière"
L["Baelog's Chest"] = "Coffre de Baelog"
L["Bakkalzu"] = "Bakkalzu"
L["Baleflame"] = "Flammosphère"
L["Ban Bearheart"] = "Ban Cœur d’Ours"
L["Barkeep Kelly <Bartender>"] = "Kelly le serveur <Tavernier>"
L["Barnes <The Stage Manager>"] = "Barnes <Le Régisseur>"
L["Baroness Dorothea Millstipe"] = "Baronne Dorothea Millstipe"
L["Baron Rafe Dreuger"] = "Baron Rafe Dreuger"
L["Basement"] = "Sous-sol"
L["Battle for Mount Hyjal"] = "Bataille pour le Mont Hyjal"
L["B.E Barechus <S.A.F.E.>"] = "Bar-à-Coups-Bas <IMUN>"
L["Belgaristrasz"] = "Belgaristrasz"
L["Belnistrasz"] = "Belnistrasz"
L["Bennett <The Sergeant at Arms>"] = "Bennett <L'huissier>"
L["Berinand's Research"] = "Recherches de Bérinand"
L["Berserking Boulder Roller"] = "Lance-rocher berserker"
L["Berthold <The Doorman>"] = "Berthold <Le concierge>"
L["BF"] = "BF"
L["BFD"] = "BFD"
L["BH"] = "BH"
L["Bilger the Straight-laced"] = "Sentine le Guindé"
L["BINDING_HEADER_ATLAS_TITLE"] = "Atlas"
L["BINDING_NAME_ATLAS_AUTOSEL"] = "Auto-Select"
L["BINDING_NAME_ATLAS_OPTIONS"] = "Options [Ouvrir/Fermer]"
L["BINDING_NAME_ATLAS_TOGGLE"] = "Atlas [Ouvrir/Fermer]"
L["Black Dragonflight Chamber"] = "Chambre du vol draconique noir"
L["Blacksmithing Plans"] = "Plans de forge"
L["Blastmaster Emi Shortfuse"] = "Maître-dynamiteur Emi Courtemèche"
L["Blood Guard Hakkuz <Darkspear Elite>"] = "Garde de sang Hakkuz <Soldat d'élite sombrelance>"
L["Blood of Innocents"] = "Sang des innocents"
L["Bloodslayer T'ara <Darkspear Veteran>"] = "Occiseuse T’ara <Vétéran sombrelance>"
L["Bloodslayer Vaena <Darkspear Veteran>"] = "Occiseuse Vaena <Vétéran sombrelance>"
L["Bloodslayer Zala <Darkspear Veteran>"] = "Occiseuse Zala <Vétéran sombrelance>"
L["Bodley"] = "Bodley"
L["Bortega <Reagents & Poison Supplies>"] = "Bortega <Composants & poisons>"
L["BoT"] = "BoT"
L["Bota"] = "Bota"
L["Bovaal Whitehorn"] = "Bovaal Corne-blanche"
L["Bowmistress Li <Guard Captain>"] = "Maître-archer Li <Capitaine de la Garde>"
L["Brann Bronzebeard"] = "Brann Barbe-de-bronze"
L["Brazen"] = "Airain"
L["BRC"] = "BRC"
L["BRD"] = "BRD"
L["Brewfest"] = "Fête des Brasseurs"
L["BRF"] = "BRF"
L["Brigg Smallshanks"] = "Brigg Courtecannes"
L["Briney Boltcutter <Blackwater Financial Interests>"] = "Briney Coupécrou <Intérêts financiers de Baille-Fonds>"
L["BRM"] = "BRM"
L["Broken Stairs"] = "L'Escalier brisé"
L["BSM"] = "BSM"
L["BT"] = "BT"
L["Bucket of Meaty Dog Food"] = "Seau de pâtée pour chien riche en viande"
L["BWD"] = "BWD"
L["BWL"] = "BWL"
L["Cache of Eregos"] = "Cache d'Eregos"
L["Caelestrasz"] = "Caelestrasz"
L["Calliard <The Nightman>"] = "Calliard <Le veilleur de nuit>"
L["Captain Alina"] = "Captaine Alina"
L["Captain Boneshatter"] = "Capitaine Fracasse-os"
L["Captain Drenn"] = "Capitaine Drenn"
L["Captain Edward Hanes"] = "Capitaine Edward Hanes"
L["Captain Hadan"] = "Capitaine Hadan"
L["\"Captain\" Kaftiz"] = "\"Captain\" Kaftiz"
L["Captain Qeez"] = "Capitaine Qeez"
L["Captain Sanders"] = "Capitaine Sanders"
L["Captain Taylor"] = "Capitaine Taylor"
L["Captain Tuubid"] = "Capitaine Tuubid"
L["Captain Wyrmak"] = "Capitaine Wyrmak"
L["Captain Xurrem"] = "Capitaine Xurrem"
L["Cath"] = "Cath"
L["Cathedral"] = "Cathédrale"
L["Cavern Entrance"] = "Entrée de la caverne"
L["Caza'rez"] = "Caza'rez"
L["Celebras the Redeemed"] = "Celebras le Racheté"
L["Centrifuge Construct"] = "Assemblage centrifuge"
L["Champ"] = "Champ"
L["Champions of the Alliance"] = "Champions de l'Alliance"
L["Champions of the Horde"] = "Champions de la Horde"
L["Charred Bone Fragment"] = "Fragment d'os carbonisé"
L["Chase Begins"] = "Début de la chasse"
L["Chase Ends"] = "Fin de la chasse"
L["Chef Jessen <Speciality Meat & Slop>"] = "Chef Jessen <Spécialités de viandes & pâtées>"
L["Chen Stormstout"] = "Chen Brune d’Orage"
L["Chester Copperpot <General & Trade Supplies>"] = "Chester Cuivrepot <Fournitures générales & d'artisanat>"
L["Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"] = "Ingénieur en chef Vizisanie <Cie des eaux de Gadgetzan>"
L["Child"] = "Enfant"
L["Chomper"] = "Mâchouilleur"
L["Chromie"] = "Chromie"
L["Chronicler Bah'Kini"] = "Chroniqueuse Bah'Kini"
L["Clarissa"] = "Clarissa"
L["Click to open Dungeon Journal window."] = "Cliquer pour ouvrir la fenêtre du codex des donjons"
L["Coffer of Forgotten Souls"] = "Coffre des âmes oubliées"
L["Colon"] = " : " -- Needs review
L["Colonel Zerran"] = "Colonel Zerran"
L["Colosos"] = "Colossos"
-- L["Comma"] = ""
L["Commander Bagran"] = "Commandant Bagran"
L["Commander Lindon"] = "Commandant Lindon"
L["Commander Mograine"] = "Commandant Mograine"
L["Compendium of the Fallen"] = "Compendium des Déchus"
L["Connection"] = "Connexion"
L["Core Fragment"] = "Fragment du Magma"
L["CoT"] = "CoT/GT"
L["CoT1"] = "CoT1/G1"
L["CoT2"] = "CoT2/GT2"
L["CoT3"] = "CoT3/GT3"
L["CoT-DS"] = "CoT-DS"
L["CoT-ET"] = "CoT-ET"
L["CoT-HoT"] = "CoT-HoT"
L["CoT-Strat"] = "Strat, CoT-Strat"
L["CoT-WoE"] = "CoT-WoE"
L["CR"] = "CR"
L["Crus"] = "EDC"
L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] = "Commandant de la croisade Eligor Portelaube <Confrérie de la Lumière>"
L["Crusade Commander Korfax <Brotherhood of the Light>"] = "Commandant de la croisade Korfax <Confrérie de la Lumière>"
L["Crusaders' Coliseum"] = "L'épreuve du croisé"
L["Crusaders' Square Postbox"] = "Boîte de la place des Croisés"
L["Cryo-Engineer Sha'heen"] = "Cryo-Ingénieur Sha'heen"
L["Cursed Centaur"] = "Centaure Maudit"
L["Darkheart"] = "Sombrecoeur"
L["Dark Keeper Key"] = "Clé du gardien noir"
L["Dark Ranger Kalira"] = "Forestier-sombre Kalira"
L["Dark Ranger Loralen"] = "Forestier-sombre Loralen"
L["Dark Ranger Marrah"] = "Forestier-sombre Marrah"
L["Dark Ranger Velonara"] = "Forestier-sombre Velonara"
L["Dasnurimi <Geologist & Conservator>"] = "Dasnurimi <Géologue et conservatrice>"
L["Dealer Tariq <Shady Dealer>"] = "Camelot Tariq <Marchand douteux>"
L["Dealer Vijaad"] = "Camelot Vijaad"
L["Deathstalker Commander Belmont"] = "Commandant nécrotraqueur Belmont"
L["Defender Mordun"] = "Défenseur Mordun"
L["Dire Maul Arena"] = "L'Etripoir"
L["Dire Pool"] = "Bassin redoutable"
L["Divination Scryer"] = "Clairvoyant"
L["DM"] = "DM/HT"
L["Dominic"] = "Dominic"
L["Don Carlos"] = "Don Carlos"
L["D'ore"] = "D'ore"
L["Draenei Spirit"] = "Esprit Draenei"
L["Drakkisath's Brand"] = "Marque de Drakkisath"
L["Drakuru's Brazier"] = "Brasero Drakuru"
L["Drisella"] = "Drisella"
L["Druid of the Talon"] = "Druide de la Serre"
L["DTK"] = "DTK"
L["Earthbinder Rayge"] = "Lieur de terre Rayge"
L["Earthwarden Yrsa <The Earthen Ring>"] = "Garde-terre Yrsa <Le Cercle terrestre>"
L["East"] = "Est"
L["EB"] = "EB"
L["Ebonlocke <The Noble>"] = "Bouclenoire <Les nobles>"
L["Ebru <Disciple of Naralex>"] = "Ebru <Disciple de Naralex>"
-- L["Echoing Horn of the Damned"] = ""
L["Echo of Medivh"] = "Echo de Medivh"
L["Elder Chogan'gada"] = "Ancien Chogan'gada"
L["Elder Farwhisper"] = "Ancien Murmeloin"
L["Elder Igasho"] = "Ancien Igasho"
L["Elder Jarten"] = "Ancien Jarten"
L["Elder Kilias"] = "Ancien Kilias"
L["Elder Mistwalker"] = "Ancienne Marche-brume"
L["Elder Morndeep"] = "Ancien Gouffre-du-matin"
L["Elder Nurgen"] = "Ancien Nurgen"
L["Elder Ohanzee"] = "Ancien Ohanzee"
L["Elder Splitrock"] = "Ancien Pierre-fendue"
L["Elders' Square Postbox"] = "Boîte de la place des Anciens"
L["Elder Starsong"] = "Ancienne Chantétoile"
L["Elder Stonefort"] = "Ancien Fort-de-pierre"
L["Elder Wildmane"] = "Ancienne Crin-sauvage"
L["Elder Yurauk"] = "Ancien Yurauk"
L["Elevator"] = "Ascenseur"
L["Ellrys Duskhallow"] = "Ellrys Sanctebrune"
L["End"] = "Fin"
L["Engineer"] = "Ingénieur"
L["Entrance"] = "Entrée"
L["Eramas Brightblaze"] = "Eramas Brillebrasier"
L["Erozion"] = "Erozion"
L["Escape from Durnholde Keep"] = "L'évasion du Fort-de-Durn"
L["Estulan <The Highborne>"] = "Estulan <Le Bien-né>"
L["Eternos"] = "Eternos"
L["Ethereal Transporter Control Panel"] = "Panneau de contrôle du transporteur étherien"
L["Eulinda <Reagents>"] = "Eulinda <Composants>"
L["Eva Sarkhoff"] = "Eva Sarkhoff"
L["Event"] = "Evènement"
L["Exalted"] = "Exalté"
L["Exarch Larethor"] = "Exarque Larethor"
L["Exit"] = "Sortie"
L["Face <S.A.F.E.>"] = "Fuité <IMUN>"
L["Fairbanks"] = "Fairbanks"
L["Falrin Treeshaper"] = "Falrin Sculpteflore"
L["Farmer Kent"] = "Kent le fermier"
L["Farseer Tooranu <The Earthen Ring>"] = "Long-voyant Tooranu <Cercle terrestre>"
L["Father Flame"] = "Père des flammes"
L["Fathom Stone"] = "Noyau de la Brasse"
L["Fel Crystals"] = "Gangrecristaux"
L["Fenstalker"] = "Traquetourbe"
L["Ferra"] = "Ferra"
L["Festival Lane Postbox"] = "Boîte de l'allée du Festival"
L["FH1"] = "FH1"
L["FH2"] = "FH2"
L["FH3"] = "FH3"
L["Field Commander Mahfuun"] = "Commandant Mahfuun"
L["Finkle Einhorn"] = "Finkle Einhorn"
L["Fire of Aku'mai"] = "Feu d'Aku'mai"
L["First Fragment Guardian"] = "Gardien du premier fragment"
L["Fizzle"] = "Féplouf"
L["FL"] = "FL"
L["Flaming Eradicator"] = "Eradicateur enflammé"
L["Flesh'rok the Diseased <Primordial Saurok Horror>"] = "Carne’rok le Malade <Horreur saurok primordiale>"
L["Focused Eye"] = "Oeil focalisé"
L["Forbidden Rites and other Rituals Necromantic"] = "Rites interdits et autres rituels nécromantiques"
L["Forest Frogs"] = "Grenouilles forestière"
L["FoS"] = "FdA"
L["Four Kaldorei Elites"] = "Quatre Elite kaldorei"
L["Fourth Stop"] = "Quatrième arrêt"
L["Frances Lin <Barmaid>"] = "Frances Lin <Serveuse>"
L["Fras Siabi's Postbox"] = "Boîte de Fras Siabi"
L["From previous map"] = "Vers la carte précédente"
L["Front"] = "Principale"
L["Frostwyrm Lair"] = "Repaire de la Wyrm des glaces"
L["Furgus Warpwood"] = "Furgus Crochebois"
L["Galamav the Marksman <Kargath Expeditionary Force>"] = "Galamav le Tireur d'élite <Corps expéditionnaire de Kargath>"
L["Galgrom <Provisioner>"] = "Galgrom <Approvisionneur>"
L["Garaxxas"] = "Garaxxas"
L["Gazakroth"] = "Gazakroth"
L["GB"] = "GB"
L["GD"] = "GD"
L["Ghost"] = "Fantôme"
L["GL"] = "GL"
L["Gnome"] = "Gnome"
L["Gomora the Bloodletter"] = "Gomora le Saigneur"
L["Gorkun Ironskull"] = "Gorkun Crâne-de-fer"
L["Gradav <The Warlock>"] = "Gradav <Le Démoniste>"
L["Graveyard"] = "Cimetière"
L["Greatfather Aldrimus"] = "Grandpère Aldrimus"
L["GSS"] = "GSS"
L["Guardian of Time"] = "Gardien du Temps"
L["Gub <Destroyer of Fish>"] = "Gub <Destructeur de poissons>"
L["Guerrero"] = "Guerrero"
L["Gun"] = "Gun"
L["Gunny"] = "Flingot"
L["GY"] = "GY"
L["Ha'lei"] = "Ha'lei"
L["Ha'Lei"] = "Ha'Lei"
L["Hallow's End"] = "Sanssaint"
L["Halls"] = "Salles"
L["Hal McAllister"] = "Hal McAllister"
L["Hann Ibal <S.A.F.E.>"] = "Hann Ibal <IMUN>"
L["Harald <Food Vendor>"] = "Harald <Vendeur de nourriture>"
L["Hastings <The Caretaker>"] = "Hastings <Le gardien>"
L["Haunted Stable Hand"] = "Palefrenier hanté"
L["Hazlek"] = "Hazlek"
L["HC"] = "HC"
L["Helcular"] = "Helcular"
L["Helpful Jungle Monkey"] = "Singe de la jungle serviable"
L["Herod the Bully"] = "Hérode le Malmeneur"
L["Heroic"] = "Héroïque"
L["Heroic: Trial of the Grand Crusader"] = "Héroïque : L'appel de la grande Croisade"
L["Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"] = "Hiérophante Theodora Mulvadania <Corps expéditionnaire de Kargath>"
L["High Examiner Tae'thelan Bloodwatcher <The Reliquary>"] = "Haut-examinateur Tae'thelan Guette-le-sang <Le Reliquaire>"
L["High Justice Grimstone"] = "Juge Supérieur Mornepierre"
L["HM"] = "HM"
L["HoF"] = "HoF"
L["HoL"] = "HoL"
L["Holy Paladin"] = "Paladin Sacré"
L["Holy Priest"] = "Prêtre Sacré"
L["HoO"] = "HoO"
L["Hooded Crusader"] = "Croisée capuchonnée"
L["HoR"] = "SdR"
L["Horde Encampment"] = "Campement de la Horde"
L["Horvon the Armorer <Armorsmith>"] = "Horvon l'Armurier <Fabricant d'armures>"
L["HoS"] = "HoS"
L["Hunter"] = "Chasseur"
-- L["Hyphen"] = ""
L["IC"] = "ICC"
L["ID"] = "ID"
L["Image of Argent Confessor Paletress"] = "Image du Confesseur d'argent Paletress"
L["Image of Drakuru"] = "Image de Drakuru"
L["Imp"] = "Diablotin"
L["Indormi <Keeper of Ancient Gem Lore>"] = "Indormi <Gardienne du savoir ancien des gemmes>"
L["Innkeeper Monica"] = "Aubergiste Monica"
L["Instructor Chillheart's Phylactery"] = "Phylactère de l'Instructrice Froidecœur"
L["In the Shadow of the Light"] = "À l’ombre de la Lumière"
L["Investigator Fezzen Brasstacks"] = " Enquêteur Fezzen Desfaits"
L["Invoker Xorenth"] = "Invocateur Xorenth"
L["Ironbark the Redeemed"] = "Ecorcefer le Racheté"
L["Isfar"] = "Isfar"
L["Isillien"] = "Isillien"
L["Itesh"] = "Itesh"
L["Jaelyne Evensong"] = "Jaelyne Chant-du-soir"
L["Jalinda Sprig <Morgan's Militia>"] = "Jalinda Brindille <Milice de Morgan>"
L["Jay Lemieux"] = "Jay Lemieux"
L["J'eevee's Jar"] = "Bocal de J'eevee"
L["Je'neu Sancrea <The Earthen Ring>"] = "Je'neu Sancrea <Le Cercle terrestre>"
L["Jerry Carter"] = "Jerry Carter"
L["Jonathan Revah"] = "Jonathan Revah"
L["Joseph the Awakened"] = "Joseph l'Éveillé"
L["Joseph the Crazed"] = "Joseph l'Affolé"
L["Joseph the Insane <Scarlet Champion>"] = "Joseph le Dément <Champion écarlate>"
L["Julie Honeywell"] = "Julie Miellepuits"
L["Kagani Nightstrike"] = "Kagani Heurtenuit"
L["Kagtha"] = "Kagtha"
L["Kaldir Ironbane"] = "Kaldir Plaie-du-fer"
L["Kaldrick"] = "Kaldrick"
L["Kamsis <The Conjurer>"] = "Kamsis <L'Invocateur>"
L["Kandrostrasz <Brood of Alexstrasza>"] = "Kandrostrasz <Rejeton d'Alexstrasza>"
L["Kand Sandseeker <Explorer's League>"] = "Kand Scrutesable <Ligue des explorateurs>"
L["Kara"] = "Kara"
L["Kasha"] = "Kasha"
L["Kaulema the Mover"] = "Kaulema le Déplaceur"
L["Keanna's Log"] = "Journal de Keanna"
L["Kel'Thuzad's Deep Knowledge"] = "Connaissances approfondies de Kel’Thuzad"
L["Kevin Dawson <Morgan's Militia>"] = "Kevin Dawson <Milice de Morgan>"
L["Key"] = "Clé"
L["Kherrah"] = "Kherrah"
L["King's Square Postbox"] = "Boîte de la place du Roi"
L["Knot Thimblejack"] = "Noué Dédodevie"
L["Koragg"] = "Koragg"
L["Korag Proudmane"] = "Korag Proudmane"
L["Koren <The Blacksmith>"] = "Koren <Le forgeron>"
L["Koristrasza"] = "Koristrasza"
L["Kurzel"] = "Kurzel"
L["Lady Catriona Von'Indi"] = "Dame Catriona Von'Indi"
L["Lady Jaina Proudmoore"] = "Dame Jaina Portvaillant"
L["Lady Keira Berrybuck"] = "Dame Keira Berrybuck"
L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Dame Sylvanas Coursevent <Reine banshee>"
L["Lakka"] = "Lakka"
L["Lana Stouthammer"] = "Lana Rudemartel"
L["Landing Spot"] = "Zone d'atterrissage"
L["Large Stone Obelisk"] = "Grand obélisque en pierre"
L["LBRS"] = "LBRS/Pic 1"
L["LCoT"] = "LCoT"
-- L["L-DQuote"] = ""
L["Lead Prospector Durdin <Explorer's League>"] = "Prospecteur en chef Durdin <Ligue des explorateurs>"
L["Legionnaire Nazgrim"] = "Légionnaire Nazgrim"
L["Lenzo"] = "Lenzo"
L["Lexlort <Kargath Expeditionary Force>"] = "Lexlort <Corps expéditionnaire de Kargath>"
L["Lib"] = "Lib"
L["Library"] = "Bibliothèque"
L["Lidia Sunglow <The Reliquary>"] = "Lidia Soléclat <Le Reliquaire>"
L["Lieutenant Horatio Laine"] = "Lieutenant Horatio Laine"
L["Lieutenant Sinclari"] = "Lieutenant Sinclari"
L["Little Jimmy Vishas"] = "Petit Jimmy Vishas"
L["Lokhtos Darkbargainer <The Thorium Brotherhood>"] = "Lokhtos Sombrescompte <La Confrérie du thorium>"
L["Lord Afrasastrasz"] = "Seigneur Afrasastrasz"
L["Lord Crispin Ference"] = "Seigneur Crispin Ference"
L["Lord Itharius"] = "Lord Itharius"
L["Lord Raadan"] = "Seigneur Raadan"
L["Lord Robin Daris"] = "Seigneur Robin Daris"
L["Lorekeeper Javon"] = "Gardien du savoir Javon"
L["Lorekeeper Kildrath"] = "Gardien du savoir Kildrath"
L["Lorekeeper Lydros"] = "Gardien du savoir Lydros"
L["Lorekeeper Mykos"] = "Gardienne du savoir Mykos"
L["Lorgalis Manuscript"] = "Manuscrit de Lorgalis"
L["Lothos Riftwaker"] = "Lothos Ouvrefaille"
L["Love is in the Air"] = "De l'amour dans l'air"
L["Lower"] = "En bas"
-- L["L-Parenthesis"] = ""
-- L["L-SBracket"] = ""
L["Lucien Sarkhoff"] = "Lucien Sarkhoff"
L["Lumbering Oaf"] = "Dadais chancelant"
L["Lunar Festival"] = "Festival lunaire"
L["Lurah Wrathvine <Crystallized Firestone Collector>"] = "Lurah Irevigne <Collectionneuse de pierres de feu cristallisées>"
L["Madrigosa"] = "Madrigosa"
L["Mag"] = "Mag"
L["Mage"] = "Mage"
L["Magical Brazier"] = "Brasero magique"
L["Magistrate Henry Maleb"] = "Magistrat Henry Maleb"
L["Mail Box"] = "Boîte aux lettres"
L["Main Chambers Access Panel"] = "Panneau d'accès de la salle principale"
L["Major Pakkon"] = "Major Parron"
L["Major Yeggeth"] = "Major Yeggeth"
L["Mamdy the \"Ologist\""] = "Mamdy \"l'Ologiste\""
L["MapA"] = " [A]"
L["MapB"] = " [B]"
L["MapC"] = " [C]"
L["MapD"] = " [D]"
L["MapE"] = " [E]"
L["MapF"] = " [F]"
-- L["MapG"] = ""
-- L["MapH"] = ""
-- L["MapI"] = ""
-- L["MapJ"] = ""
L["MapsNotFound"] = [=[Le donjon actuellement sélectionné n'a pas d'image de la carte correspondante.
Assurez-vous d'avoir installé le bon module de cartes d'Atlas]=]
L["Mara"] = "Mara"
L["Market Row Postbox"] = "Boîte de l'allée du Marché"
L["Marshal Jacob Alerius"] = "Maréchal Jacob Alerius"
L["Marshal Maxwell <Morgan's Militia>"] = "Maréchal Maxwell <Milice de Morgan>"
L["Martin Victus"] = "Martin Victus"
L["Master Craftsman Wilhelm <Brotherhood of the Light>"] = "Maître-artisan Wilhelm <Confrérie de la Lumière>"
L["Master Elemental Shaper Krixix"] = "Maître élémentaire Krixix le Sculpteur"
L["Master Windstrong"] = "Maître Vent Violent"
L["MaT"] = "MT"
L["Mawago"] = "Mawago"
L["Maxwort Uberglint"] = "Maxwort Uberbrille"
L["Mayara Brightwing <Morgan's Militia>"] = "Mayara Luisaile <Milice de Morgan>"
L["Mazoga's Spirit"] = "Esprit de Mazoga"
L["MC"] = "MC"
L["Mech"] = "Mech"
L["Meeting Stone"] = "Pierre de rencontre"
L["Meeting Stone of Hellfire Citadel"] = "Pierre de rencontre de la Citadelle des Flammes Infernales"
L["Meeting Stone of Magtheridon's Lair"] = "Pierre de rencontre du repaire de Magtheridon"
L["Melasong"] = "Mélachant"
L["Melissa"] = "Mélissa"
L["Merithra of the Dream"] = "Merithra du Rêve"
L["Micah"] = "Micah"
L["Middle"] = "Milieu"
L["Midsummer Festival"] = "Solstice d'été : la fête du Feu"
L["Millhouse Manastorm"] = "Milhouse Tempête-de-mana"
L["Miss Mayhem"] = "Mademoiselle Chambard"
L["Mistress Nagmara"] = "Gouvernante Nagmara"
L["Monara <The Last Queen>"] = "Monara <La dernière reine>"
L["Monk"] = "Moine"
L["Moonwell"] = "Puits de lune"
L["Mor'Lek the Dismantler"] = "Mor'Lek le Démanteleur"
L["Mortaxx <The Tolling Bell>"] = "Mortaxx <La cloche du glas>"
L["Mortog Steamhead"] = "Mortog Têtavapeur"
L["Mountaineer Orfus <Morgan's Militia>"] = "Montagnard Orfus <Milice de Morgan>"
L["MP"] = "MP"
L["Mr. Bigglesworth"] = "M. Bigglesworth"
L["MT"] = "MT"
L["Murd Doc <S.A.F.E.>"] = "Loupe-Piste <IMUN>"
L["Muyoh <Disciple of Naralex>"] = "Muyoh <Disciple de Naralex>"
L["MV"] = "MV"
L["Mysterious Bookshelf"] = "Bibliotheque suspecte"
L["Nahuud"] = "Nahuud"
L["Nalpak <Disciple of Naralex>"] = "Nalpak <Disciple de Naralex>"
L["Naralex"] = "Naralex"
L["Naresir Stormfury <Avengers of Hyjal Quartermaster>"] = "Naresir Furie-des-Tempêtes <Intendant des Vengeurs d’Hyjal>"
L["Nathanos Marris"] = "Nathanos Marris"
L["Nat Pagle"] = "Nat Pagle"
L["Naturalist Bite"] = "Naturaliste Morsure"
L["Nax"] = "Nax"
L["Neptulon"] = "Neptulon"
L["Nex, Nexus"] = "Nex, Nexus"
L["Nexus-Prince Haramad"] = "Prince-nexus Haramad"
L["Night Elf Village"] = "Village des Elfes de la Nuit"
L["No'ku Stormsayer <Lord of Tempest>"] = "No’ku Parle-Tempête <Seigneur de la tourmente>"
L["Norkani"] = "Norkani"
L["North"] = "Nord"
L["Nozari <Keepers of Time>"] = "Nozari <Les Gardiens du temps>"
L["Nozdormu"] = "Nozdormu"
L["Nurse Lillian"] = "Infirmière Lillian"
L["Ocu"] = "Ocu"
L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Okuno <Intendant des ligemorts cendrelangue>"
L["Old Ironbark"] = "Vieil Ecorcefer"
L["Olga Runesworn <Explorer's League>"] = "Olga Ligerune <Ligue des explorateurs>"
L["Ony"] = "Ony"
L["Opening of the Dark Portal"] = "Ouverture de la Porte des Ténèbres"
L["Optional"] = "Optionel"
L["Oralius <Morgan's Militia>"] = "Oralius <Milice de Morgan>"
L["Orange"] = "Orange"
L["Orb of Command"] = "Orbe de Commandement"
L["Orb of Domination"] = "Orbe de domination"
L["OS"] = "OS"
L["Outside"] = "Extérieur"
L["Overcharged Manacell"] = "Cellule de mana surchargée"
L["Overseer Blingbang"] = "Surveillant Blingbang"
L["Overwatch Mark 0 <Protector>"] = "Vigilant modèle 0 <Protecteur>"
L["Packleader Ivar Bloodfang"] = "Chef de meute Ivar Croc-de-sang"
L["Packmaster Stonebruiser <Brotherhood of the Light>"] = "Maître-fourrier Navrepierre <Confrérie de la Lumière>"
L["Paladin"] = "Paladin"
L["Path to the Broken Stairs"] = "Passage vers l'Escalier brisé"
L["Path to the Hellfire Ramparts and Shattered Halls"] = "Chemin vers les Remparts des Flammes infernales et les salles Brisées"
-- L["Period"] = ""
L["Phin Odelic <The Kirin Tor>"] = "Phin Odelic <Le Kirin Tor>"
L["Polyformic Acid Potion"] = "Potion d'acide polyformique"
L["Portal"] = "Portail"
L["PoS"] = "FdS"
-- L["PossibleMissingModule"] = ""
L["Precious"] = "Bijou"
L["Priest"] = "Prêtre"
L["Priestess Summerpetal"] = "Prêtresse Pétale de l’Été"
L["Priestess Udum'bra"] = "Prêtresse Udum'bra"
L["Private Jacint"] = "Soldat Jacint"
L["Private Rocknot"] = "Soldat Rochenoeud"
L["Professor Slate"] = "Professeur Alambic"
L["Prospector Doren"] = "Prospecteur Doren"
L["Prospector Seymour <Morgan's Militia>"] = "Prospecteur Seymour <Milice de Morgan>"
L["Protection Warrior"] = "Guerrier Protection"
L["Provisioner Tsaalt"] = "Approvisionneur Tsaalt"
L["Pumpkin Shrine"] = "Sanctuaire Citrouille"
L["Purple"] = "Violet"
L["Pylons"] = "Pylônes"
L["Quartermaster Lewis <Quartermaster>"] = "Intendant Lewis <Intendant>"
L["Raleigh the True"] = "Raleigh le Vrai"
L["Ramdor the Mad"] = "Ramdor le Fol"
L["Ramp"] = "Ramp"
L["Ramp down to the Gamesman's Hall"] = "Rampe déscendant vers le Hall du Flambeur"
L["Ramp to Guardian's Library"] = "Rampe vers la Bibliothèque du Gardien"
L["Ramp to Medivh's Chamber"] = "Rampe vers la chambre de Medivh"
L["Ramp up to the Celestial Watch"] = "Rampe montant vers Le Guet céleste"
L["Random"] = "Aléatoire"
L["Randy Whizzlesprocket"] = "Randy Vizirouage"
L["Rare"] = "Rare"
L["Raven"] = "Corbeau"
L["Razal'blade <Kargath Expeditionary Force>"] = "Razal'lame <Corps expéditionnaire de Kargath>"
L["Razorfen Spearhide"] = "Lanceur de Tranchebauge"
-- L["R-DQuote"] = ""
L["Reclaimer A'zak"] = "Récupérateur A'zak"
L["Red Dragonflight Chamber"] = "Chambre du vol draconique Rouge"
L["Red Riding Hood"] = "Petit Chaperon Rouge"
L["Reinforced Archery Target"] = "Cible de tir à l’arc renforcée"
L["Reinforced Fel Iron Chest"] = "Coffre en gangrefer renforcé"
L["Relic Coffer Key"] = "Clé du coffret à relique"
L["Relissa"] = "Relissa"
L["Relwyn Shadestar"] = "Relwyn Sombrétoile"
L["Renault Mograine"] = "Renault Mograine"
L["Repair"] = "Réparation"
L["Reputation"] = "Réputation"
L["Retribution Paladin"] = "Paladin Vindicte"
L["Rewards"] = "Récompenses"
L["RFC"] = "RFC"
L["RFD"] = "RFD"
L["RFK"] = "RFK"
L["Rifle Commander Coe"] = "Commandant d'infanterie légère Coe"
L["Rifleman Brownbeard"] = "Fusilier Brownbeard"
L["Rimefang"] = "Frigecroc"
L["Rocky Horror"] = "Horreur rocheuse"
L["Rogue"] = "Voleur"
L["Rosa"] = "Rosa"
L["Roughshod Pike"] = "Pique de fortune"
-- L["R-Parenthesis"] = ""
L["RS"] = "SR"
-- L["R-SBracket"] = ""
L["Sa'at <Keepers of Time>"] = "Sa'at <Les Gardiens du temps>"
L["Safe Room"] = "Pièce sûre"
L["Sally Whitemane"] = "Sally Blanchetête"
L["SB"] = "SB"
L["SBG"] = "SBG"
L["SC"] = "SSC"
L["Scarshield Quartermaster <Scarshield Legion>"] = "Intendant du Bouclier balafré <Légion du Bouclier balafré>"
L["Schematic: Field Repair Bot 74A"] = "Schéma : Robot réparateur 74A"
L["Scholo"] = "Scholo"
L["Scourge Invasion Points"] = "Points d'invasion du Fléau"
L["Scout Cage"] = "Cage d'éclaireur"
L["Scout Orgarr"] = "Eclaireur Orgarr"
L["Scout Thaelrid"] = "Eclaireur Thaelrid"
L["Scrying Orb"] = "Orbe de divination"
L["Sebastian <The Organist>"] = "Sebastian <L'Organiste>"
L["Second Fragment Guardian"] = "Gardien du second fragment"
L["Second Stop"] = "Deuxième arrêt"
L["Seer Ixit"] = "Voyant Ixit"
L["Seer Kanai"] = "Voyant Kanai"
L["Seer Olum"] = "Voyant Olum"
-- L["Semicolon"] = ""
L["Sentinel Aluwyn"] = "Sentinelle Aluwyn"
L["Sentinel-trainee Issara"] = "Apprentie sentinelle Issara"
L["Servant Quarters"] = "Quartier des serviteurs"
L["Seth"] = "Seth"
L["SFK"] = "SFK"
L["SH"] = "SH"
L["Shado-Master Chum Kiu"] = "Maître-pandashan Chum Kiu"
L["Shadowforge Brazier"] = "Brasero d'ombreforge"
L["Shadow Lord Xiraxis"] = "Seigneur des ténèbres Xiraxis"
L["Shadow Priest"] = "Prêtre Ombre"
L["Shaman"] = "Chaman"
L["Shattered Hand Executioner"] = "Bourreau de la Main brisée"
L["Shavalius the Fancy <Flight Master>"] = "Shavalius l'Élégant <Maître de vol>"
L["Shen'dralar Ancient"] = "Ancienne de Shen'Dralar"
L["Shen'dralar Provisioner"] = "Approvisionneur Shen'dralar"
L["Shen'dralar Watcher"] = "Gardien Shen'dralar"
L["Shrine of Gelihast"] = "Autel de Gelihast"
L["Sif"] = "Sif"
L["Sinan the Dreamer"] = "Sinan la Rêveuse"
L["Sindragosa's Lair"] = "Repaire de Sindragosa"
L["Sister Svalna"] = "Sœur Svalna"
L["Skar'this the Heretic"] = "Skar'this l'Hérétique"
L["SL"] = "SL/Laby"
-- L["Slash"] = ""
L["\"Slim\" <Shady Dealer>"] = "\"Mince\" <Marchand douteux>"
L["Slinky Sharpshiv"] = "Fugace Coutelard"
L["Slither"] = "Sinueux"
L["Sliver <Garaxxas' Pet>"] = "Esquille <Familier de Garaxxas>"
L["Slosh <Food & Drink>"] = "Patauge <Nourriture & boissons>"
L["SM"] = "SM/Le Mona"
L["SNT"] = "SNT"
L["SoO"] = "SoO"
L["Soridormi <The Scale of Sands>"] = "Soridormi <La Balance des sables>"
L["South"] = "Sud"
L["Southshore Inn"] = "Auberge d'Austrivage"
L["SP"] = "SP"
L["Spawn Point"] = "Points d'apparition"
L["Spinestalker"] = "Traquépine"
L["Spiral Stairs to Netherspace"] = "Escalier en spiral vers le Néantespace"
L["Spirit of Agamaggan <Ancient>"] = "Esprit d'Agamaggan <Ancien>"
L["Spirit of Olum"] = "Esprit d'Olum"
L["Spirit of Udalo"] = "Esprit d'Udalo"
L["SPM"] = "SPM"
L["Spoils of Blackfathom"] = "Butin de Brassenoire"
L["Spy Grik'tha"] = "Espionne Grik'tha"
L["Spy To'gun"] = "Espion To'gun"
L["SR"] = "SR"
L["SSC"] = "SSC"
L["ST"] = "ST"
L["Stairs to Underground Pond"] = "Escalier vers le bassin souterrain"
L["Stairs to Underground Well"] = "Escalier vers le puits souterrain"
L["Stalvan Mistmantle"] = "Stalvan Mantebrume"
L["Start"] = "Début"
L["Steps and path to the Blood Furnace"] = "Marches et chemin vers la Fournaise du sang"
L["Steward of Time <Keepers of Time>"] = "Régisseur du temps <Les Gardiens du temps>"
L["Stinky"] = "Kifouette"
L["Stocks"] = "Stocks/Prison"
L["Stone Guard Kurjack"] = "Garde de pierre Kurjack"
L["Stone Guard Stok'ton"] = "Garde de pierre Stok'ton"
L["Stonemaul Ogre"] = "Ogre Cognepierre"
L["Stormherald Eljrrin"] = "Héraut de la tempête Eljrrin"
L["Strat"] = "Strat"
L["Stratholme Courier"] = "Messager de Stratholme"
L["Summon"] = "Invoqué"
L["Summoner's Tomb"] = "La tombe des invocateurs"
L["SuP"] = "SP"
L["Suspicious Bookshelf"] = "Bibliotheque suspecte"
L["SV"] = "SV"
L["Taelan"] = "Taelan"
L["Talking Skull"] = "Crâne parlant"
L["Taretha"] = "Taretha"
L["Teleporter"] = "Téléporteur"
L["Teleporter destination"] = "Destination du téléporteur"
L["Teleporter to Middle"] = "Téléporteur vers le centre"
L["TEoE"] = "Maly"
L["TES"] = "TES"
L["Thal'trak Proudtusk <Kargath Expeditionary Force>"] = "Thal'trak Fière-défense <Corps expéditionnaire de Kargath>"
L["The Behemoth"] = "Le Béhémoth"
L["The Black Anvil"] = "L'Enclume noire"
L["The Black Forge"] = "La Forge noire"
L["The Captain's Chest"] = "Le coffre du capitaine"
L["The Codex of Blood"] = "Codex de sang"
L["The Culling of Stratholme"] = "L'Épuration de Stratholme"
L["The Dark Grimoire"] = "Le grimoire noir"
L["The Dark Portal"] = "La Porte des Ténèbres"
L["The Deed to Brill"] = "Titre de propriété de Brill"
L["The Deed to Caer Darrow"] = "Titre de propriété de Caer Darrow"
L["The Deed to Southshore"] = "Titre de propriété d'Austrivage"
L["The Deed to Tarren Mill"] = "Titre de propriété de Moulin-de-Tarren"
L["The Discs of Norgannon"] = "Les Disques de Norgannon"
L["The Eye of Haramad"] = "L'Oeil d'Haramad"
L["The Keepers"] = "Les Gardiens"
L["The Map of Zul'Aman"] = "La carte de Zul'Aman"
L["The Master's Terrace"] = "La terrasse du Maître"
L["The Nameless Prophet"] = "Le Prophète sans nom"
L["The Saga of Terokk"] = "La Saga de Terokk"
L["The Shadowforge Lock"] = "Le verrou d'Ombreforge"
L["The Siege"] = "Le Siège"
L["The Sparklematic 5200"] = "Le Brille-o-Matic 5200"
L["The Underspore"] = "Palme de sporielle"
L["The Vault"] = "La Chambre forte"
L["Third Fragment Guardian"] = "Gardien du troisième fragment"
L["Third Stop"] = "Troisième arrêt"
L["Thomas Yance <Travelling Salesman>"] = "Thomas Yance <Marchand itinérant>"
L["Thrall"] = "Thrall"
L["Thrall <Warchief>"] = "Thrall <Chef de guerre>"
L["Thunderheart <Kargath Expeditionary Force>"] = "Cœur-de-tonnerre <Corps expéditionnaire de Kargath>"
L["Thurg"] = "Thurg"
L["Tiki Lord Mu'Loa"] = "Seigneur-tiki Mu'Loa"
L["Tiki Lord Zim'wae"] = "Seigneur-tiki Zim'wae"
L["Tinkee Steamboil"] = "Brikolette Toutevapeur"
L["Tink Sprocketwhistle <Engineering Supplies>"] = "Bricolo Sifflepignon <Fournitures d'ingénieur>"
L["TJS"] = "TJS"
L["TK"] = "TK"
L["Tol'mar"] = "Tol'mar"
L["Tol'vir Grave"] = "Tombe tol'vir"
L["To next map"] = "Vers la carte suivante"
L["Top"] = "Haut"
L["Torben Zapblast <Teleportation Specialist>"] = "Torben Zoupébaf <Spécialiste en téléportation>"
L["Torch Lever"] = "Torche levier"
L["Tormented Soulpriest"] = "Prêtre de l'âme tourmenté"
L["Tor-Tun <The Slumberer>"] = "Tor-Tun <Le Dormeur>"
L["ToT"] = "ToT"
L["ToTT"] = "ToTT"
L["Towards Illidan Stormrage"] = "Vers Illidan Hurlorage"
L["Towards Reliquary of Souls"] = "Vers Reliquaire des âmes"
L["Towards Teron Gorefiend"] = "Vers Teron Fielsang"
L["Tower of Flame"] = "Tour des flammes"
L["Tower of Frost"] = "Tour du givre"
L["Tower of Life"] = "Tour de la vie"
L["Tower of Storms"] = "Tour des tempêtes"
-- L["Train Ride"] = ""
L["Tran'rek"] = "Tran'rek"
-- L["Transport"] = ""
L["Tribunal Chest"] = "Coffre du tribunal"
L["TSC"] = "TSC"
L["T'shu"] = "T'shu"
L["Tunnel"] = "Tunnel"
L["TWT"] = "TWT"
L["Tydormu <Keeper of Lost Artifacts>"] = "Tydormu <Gardien des artéfacts sha'tari>"
L["Tyllan"] = "Tyllan"
L["Tyrande Whisperwind <High Priestess of Elune>"] = "Tyrande Murmevent <Grande prêtresse d'Elune>"
L["Tyrith"] = "Tyrith"
L["UB"] = "UB"
L["UBRS"] = "UBRS/Pic 2"
L["Udalo"] = "Udalo"
L["UK, Keep"] = "UK, Keep"
L["Ulda"] = "Ulda"
L["Uldu"] = "Uldu"
L["Unblinking Eye"] = "Oeil impassible"
L["Underwater"] = "Sous l'eau"
L["Upper"] = "En haut"
L["Upper Spire"] = "Flèche supérieure"
L["UP, Pinn"] = "UP, Pinn"
L["Urok's Tribute Pile"] = "Autel des offrandes d'Urok"
L["Varies"] = "Variable"
L["VC"] = "VC"
L["Vehini <Assault Provisions>"] = "Vehini <Provisions d’assaut>"
L["Velastrasza"] = "Velastrasza"
L["Vend-O-Tron D-Luxe"] = "Vend-O-Tron D-Luxe"
L["Venomancer Mauri <The Snake's Whisper>"] = "Venimancienne Mauri <Le murmure du serpent>"
L["Venomancer T'Kulu <The Toxic Bite>"] = "Venimancien T'Kulu <La morsure toxique>"
L["Verdisa"] = "Verdisa"
L["Vethsera <Brood of Ysera>"] = "Vethsera <Rejeton d'Ysera>"
L["VH"] = "VH"
L["VoA"] = "Archa"
L["Vol'jin"] = "Vol'jin"
L["Voodoo Pile"] = "Pile vaudou"
L["Vorrel Sengutz"] = "Vorrel Sengutz"
L["VP"] = "VP"
L["Wanders"] = "Errant"
L["Warden Thelwater"] = "Gardien Thelwater"
L["Warlock"] = "Démoniste"
L["Warlord Goretooth <Kargath Expeditionary Force>"] = "Seigneur de guerre Sangredent <Corps expéditionnaire de Kargath>"
L["Warlord Salaris"] = "Seigneur de guerre Salaris"
L["Warmage Kaitlyn"] = "Mage de guerre Kaitlyn"
L["Warrior"] = "Guerrier"
L["Watcher Gashra"] = "Gardien Gashra"
L["Watcher Jhang"] = "Guetteuse Jhang"
L["Watcher Narjil"] = "Gardien Narjil"
L["Watcher Silthik"] = "Gardien Silthik"
L["Watchman Doomgrip"] = "Sentinelle Ruinepoigne"
L["Wave 10"] = "Vague 10"
L["Wave 12"] = "Vague 12"
L["Wave 18"] = "Vague 18"
L["Wave 5"] = "Vague 5"
L["Wave 6"] = "Vague 6"
L["WC"] = "WC/Lam"
L["Weeder Greenthumb"] = "Weeder la Main-verte"
L["Weegli Blastfuse"] = "Gigoto Explomèche"
L["Weldon Barov <House of Barov>"] = "Weldon Barov <Maison Barov>"
L["West"] = "Ouest"
L["Willix the Importer"] = "Willix l’Importateur"
L["Windcaller Claw"] = "Implorateur céleste Griffe"
L["Witch Doctor Qu'in <Medicine Woman>"] = "Féticheuse Qu'in"
L["Witch Doctor T'wansi"] = "Féticheur T'wansi"
L["Wizard of Oz"] = "Magicien d'Oz"
L["Wrath of the Lich King"] = "Wrath of the Lich King"
L["Wravien <The Mage>"] = "Wravien <Le Mage>"
L["Yarley <Armorer>"] = "Yarley <Armurier>"
L["Yazzai"] = "Yazzai"
L["Young Blanchy"] = "Jeune Blanchy"
L["Ythyar"] = "Ythyar"
L["Yuka Screwspigot <Engineering Supplies>"] = "Yuka Fermevanne <Fournitures d'ingénieur>"
L["ZA"] = "ZA"
L["Zaladormu"] = "Zaladormu"
L["Zanza the Restless"] = "Zanza le Sans-Repos"
L["Zanzil's Cauldron of Burning Blood"] = "Chaudron de sang ardent de Zanzil"
L["Zanzil's Cauldron of Frostburn Formula"] = "Chaudron de formule de brûlure du givre de Zanzil"
L["Zanzil's Cauldron of Toxic Torment"] = "Chaudron de tourment toxique de Zanzil"
L["Zao'cho <The Emperor's Shield>"] = "Zao’cho <Le bouclier de l’empereur>"
L["Zelfan"] = "Zelfan"
L["Zeya"] = "Zeya"
L["ZF"] = "ZF"
L["ZG"] = "ZG"
L["Zixil <Aspiring Merchant>"] = "Zixil <Marchand en herbe>"
L["Zungam"] = "Zungam"
L["ToC/Description"] = "Navigateur de cartes d'instances"
-- L["ToC/Title"] = ""

end