﻿-- $Id: Atlas-ruRU.lua 31 2016-06-23 07:30:35Z arith $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2016 - Arith Hsu, Atlas Team <atlas.addon@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("Atlas", "ruRU", false);

-- Atlas Russian Localization
-- Compiled by Eugene Filatov, bigoblin, StingerSoft
-- Last Update: 23.01.2011
-- $Date: 2016-06-23 07:30:35 +0000 (Thu, 23 Jun 2016) $
-- $Revision: 31 $

if ( GetLocale() == "ruRU" ) then
-- Define the leading strings to be ignored while sorting
-- Ex: The Stockade
AtlasSortIgnore = {"(.+)"};

-- Syntax: ["real_zone_name"] = "localized map zone name"
AtlasZoneSubstitutions = {
	["Ahn'Qiraj"] = "Ан'Кираж";
	["The Temple of Atal'Hakkar"] = "Храм Атал'Хаккара";
--	["Throne of Tides"] = "Бездонная пучина: Трон Приливов";
};
end


if L then
L["Abandonded Mole Machine"] = "Брошенная буровая установка"
L["Abbendis"] = "Аббендис"
L["AC"] = "АГ"
L["Acride <Scarshield Legion>"] = "Секретный агент <Легион Изрубленного Щита>"
L["Adult"] = "Взрослый"
L["Advance Scout Chadwick"] = "Главный разведчик Чадвик"
L["Aged Dalaran Wizard"] = "Даларанский старый волшебник"
L["Ahn'kahet Brazier"] = "Ан'кахетская жаровня"
L["AKA"] = "AKA" -- Needs review
L["AK, Kahet"] = "АК, Кахет"
L["Alexi Barov <House of Barov>"] = "Алексий Баров <Род Баровых>"
L["Alexston Chrome <Tavern of Time>"] = "Алекстон Хром <Таверна Времени>"
L["Alliance Base"] = "База Альянса"
L["Altar of Blood"] = "Алтарь крови"
L["Altar of the Deeps"] = "Алтарь пучины"
L["Alurmi"] = "Алурми"
L["Alurmi <Keepers of Time Quartermaster>"] = "Алурми <Начальник снабжения Хранителей Времени>"
L["Aluyen <Reagents>"] = "Алуйен <Реагенты>"
L["Alyson Antille"] = "Алисон Антиль"
L["\"Ambassador\" Dagg'thol"] = "\"Посланник\"Дагг'тол"
L["Ambassador Pax'ivi"] = "Посол Пакс'иви"
L["Ambrose Boltspark"] = "Амброз Искрокрут"
L["Amnennar's Phylactery"] = "Филактерия Амненнара"
L["Anachronos <Keepers of Time>"] = "Анахронос <Хранители Времени>"
L["Ancient Equine Spirit"] = "Дух древнего коня"
L["Ancient Treasure"] = "Древнее сокровище"
L["Andorgos <Brood of Malygos>"] = "Андоргос <Род Малигоса>"
L["Andormu <Keepers of Time>"] = "Андорму <Хранители Времени>"
L["AN, Nerub"] = "АЖ, Неруб"
L["Aoren Sunglow <The Reliquary>"] = "Аорен Солнечное Сияние <Реликварий>"
L["Apoko"] = "Апоко"
L["Apothecary Baxter <Crown Chemical Co.>"] = "Аптекарь Бакстер <Королевская химическая компания>"
L["Apothecary Frye <Crown Chemical Co.>"] = "Аптекарь Фрай <Королевская химическая компания>"
L["Apothecary Hummel <Crown Chemical Co.>"] = "Аптекарь Хаммел <Королевская химическая компания>"
L["Apothecary Trio"] = "Трио аптекарей"
L["Apprentice Darius"] = "Ученик Дариус"
L["AQ"] = "АКУ"
L["AQ10"] = "АКУ20"
L["AQ20"] = "АКУ20"
L["AQ40"] = "АКУ40"
L["Arazmodu <The Scale of Sands>"] = "Аразмоду <Песчаная Чешуя>"
L["Arca"] = "Арка"
L["Arcane Container"] = "Волшебный контейнер"
L["Archivum Console"] = "Панель управления Архивом"
L["Archmage Alturus"] = "Верховный маг Альтур"
L["Archmage Angela Dosantos <Brotherhood of the Light>"] = "Верховный маг Анджела Досантос <Братство Света>"
L["Archmage Elandra <Kirin Tor>"] = "Верховный маг Эландра <Кирин-Тор>"
L["Archmage Koreln <Kirin Tor>"] = "Верховный маг Корелн <Кирин-Тор>"
L["Archmage Leryda"] = "Верховный маг Лерида"
L["Archritualist Kelada"] = "Предводитель ритуалистов Келад"
L["Arinoth"] = "Аринот"
L["Armory"] = "Оружейная"
L["Arms Warrior"] = "Воин-Оружия"
L["Artificer Morphalius"] = "Работник Морфалиус"
L["Arygos"] = "Аригос"
L["Ashelan Northwood"] = "Эшлан Северный Лес"
L["ATLAS_BUTTON_CLOSE"] = "Закрыть"
L["ATLAS_BUTTON_TOOLTIP_HINT"] = [=[[ЛКМ] - открывает Атлас.
[СКМ] - открывает настройки Атласа.
[ПКМ] + [перемещение] - изменяет позицию кнопки Атласа.]=]
L["ATLAS_BUTTON_TOOLTIP_TITLE"] = "Атлас"
L["ATLAS_DDL_CONTINENT"] = "Континенту" -- Needs review
-- L["ATLAS_DDL_CONTINENT_BROKENISLES"] = ""
L["ATLAS_DDL_CONTINENT_DEEPHOLM"] = "Подземелья Подземья"
L["ATLAS_DDL_CONTINENT_DRAENOR"] = "Подземелья Дренорский"
L["ATLAS_DDL_CONTINENT_EASTERN"] = "Подземелья Восточных королевств"
L["ATLAS_DDL_CONTINENT_KALIMDOR"] = "Подземелья Калимдора"
L["ATLAS_DDL_CONTINENT_NORTHREND"] = "Подземелья Нордскола"
L["ATLAS_DDL_CONTINENT_OUTLAND"] = "Подземелья Запределья"
L["ATLAS_DDL_CONTINENT_PANDARIA"] = "Подземелья Пандории"
L["ATLAS_DDL_EXPANSION"] = "Дополнению" -- Needs review
L["ATLAS_DDL_EXPANSION_BC"] = "Подземелья Пылающего Крестового Похода"
L["ATLAS_DDL_EXPANSION_CATA"] = "Подземелья Cataclysm"
-- L["ATLAS_DDL_EXPANSION_LEGION"] = ""
L["ATLAS_DDL_EXPANSION_MOP"] = "Подземелья Mists of Pandaria"
L["ATLAS_DDL_EXPANSION_OLD_AO"] = "Подземелья Старого Мира A-O"
L["ATLAS_DDL_EXPANSION_OLD_PZ"] = "Подземелья Старого Мира P-Z"
L["ATLAS_DDL_EXPANSION_WOD"] = "Подземелья Warlords of Draenor"
L["ATLAS_DDL_EXPANSION_WOTLK"] = "Подземелья Wrath of the Lich King"
L["ATLAS_DDL_LEVEL"] = "Уровню" -- Needs review
L["ATLAS_DDL_LEVEL_100PLUS"] = "Подземелья уровня 100+"
-- L["ATLAS_DDL_LEVEL_100TO110"] = ""
-- L["ATLAS_DDL_LEVEL_110PLUS"] = ""
L["ATLAS_DDL_LEVEL_45TO60"] = "Подземелья уровня 45-60"
L["ATLAS_DDL_LEVEL_60TO70"] = "Подземелья уровня 60-70"
L["ATLAS_DDL_LEVEL_70TO80"] = "Подземелья уровня 70-80"
L["ATLAS_DDL_LEVEL_80TO85"] = "Подземелья уровня 80-85"
L["ATLAS_DDL_LEVEL_85PLUS"] = "Подземелья уровня 85+"
L["ATLAS_DDL_LEVEL_85TO90"] = "Подземелья уровня 85-90"
L["ATLAS_DDL_LEVEL_90TO100"] = "Подземелья уровня 90-100"
L["ATLAS_DDL_LEVEL_UNDER45"] = "Подземелья уровня ниже 45"
L["ATLAS_DDL_PARTYSIZE"] = "Размеру группы" -- Needs review
L["ATLAS_DDL_PARTYSIZE_10_AN"] = "Подземелья на 10 игроков A-N"
L["ATLAS_DDL_PARTYSIZE_10_OZ"] = "Подземелья на 10 игроков O-Z"
L["ATLAS_DDL_PARTYSIZE_20TO40"] = "Подземелья на 20-40 игроков"
L["ATLAS_DDL_PARTYSIZE_20TO40AH"] = "Подземелья на 20-40 игроков A-H"
L["ATLAS_DDL_PARTYSIZE_20TO40IZ"] = "Подземелья на 20-40 игроков I-Z"
L["ATLAS_DDL_PARTYSIZE_5_AE"] = "Подземелья на 5 игроков A-E"
L["ATLAS_DDL_PARTYSIZE_5_FS"] = "Подземелья на 5 игроков F-S"
L["ATLAS_DDL_PARTYSIZE_5_TZ"] = "Подземелья на 5 игроков T-Z"
L["ATLAS_DDL_TYPE"] = "Типу" -- Needs review
L["ATLAS_DDL_TYPE_ENTRANCE"] = "Входы"
L["ATLAS_DDL_TYPE_INSTANCE_AB"] = "Подземелья A-B"
L["ATLAS_DDL_TYPE_INSTANCE_AC"] = "Подземелья A-C"
L["ATLAS_DDL_TYPE_INSTANCE_CF"] = "Подземелья C-F"
L["ATLAS_DDL_TYPE_INSTANCE_DR"] = "Подземелья D-R"
L["ATLAS_DDL_TYPE_INSTANCE_GM"] = "Подземелья G-M"
L["ATLAS_DDL_TYPE_INSTANCE_NS"] = "Подземелья N-S"
L["ATLAS_DDL_TYPE_INSTANCE_SZ"] = "Подземелья S-Z"
L["ATLAS_DDL_TYPE_INSTANCE_TZ"] = "Подземелья T-Z"
L["ATLAS_DEP_MSG1"] = "Атлас обнаружил устаревший(е) модуль(и)."
L["ATLAS_DEP_MSG2"] = "Они будут отключены для данного персонажа."
L["ATLAS_DEP_MSG3"] = "Удалите их из вашей папки аддонов."
L["ATLAS_DEP_OK"] = "Ok"
L["ATLAS_ENTRANCE_BUTTON"] = "Вход"
L["ATLAS_INFO"] = "Atlas информация"
L["ATLAS_INFO_12200"] = [=[Важное уведомление:

В связи с проблемой увеличение размеров файлов модификации, мы разделили
 модификацию на отдельные модули подземелий.

Пользователи, которые скачивают нашу модификацию с известных веб-сайтов,
 в основном получают только основное ядро, которое включает в себя все
 функции ядра Атласа и карты подземелий Cataclysm'а.

Пользователи, которые хотят загрузить все старые карты подземелий и все
 модули Атласа, сделанные нами, могут их скачать по отдельности.

Для получения дополнительной информации прочтите следующий топик:
|cff6666ffhttp://www.atlasmod.com/phpBB3/viewtopic.php?t=1522|cffffffff

Или посетите наш сайт, чтобы узнать где скачать:
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_INFO_12201"] = [=[Обратите внимание, что мы создали новый плагин - |cff6666ffAtlas Сценарии|cffffffff, который 
обеспечивает совершенно новыми картыми сценарий, введенных в 5.0. 

Для более подробной информации посетите наш веб-сайт, и не забудьте скачать / 
установить его отдельно.
|cff6666ffhttp://www.atlasmod.com/|cffffffff]=]
L["ATLAS_INSTANCE_BUTTON"] = "Подземелье"
L["ATLAS_LDB_HINT"] = [=[[ЛКМ] - открывает Атлас.
[ПКМ] - открывает настройки Атласа.]=]
L["ATLAS_MINIMAPLDB_HINT"] = [=[[ЛКМ] - открывает Атлас.
[ПКМ] + открывает настройки Атласа.
[ЛКМ] + [перемещение] - изменяет позицию кнопки.]=]
L["ATLAS_MISSING_MODULE"] = "Atlas обнаружил недостоющие модули / плагины: "
L["ATLAS_OPTIONS_ACRONYMS"] = "Короткие названия"
L["ATLAS_OPTIONS_ACRONYMS_TIP"] = "Будут отображаться сокрощенные названия подземелий в информации о карте."
L["ATLAS_OPTIONS_AUTOSEL"] = "Автоматический выбор поздемелья"
L["ATLAS_OPTIONS_AUTOSEL_TIP"] = "Автоматический выбор карты поздемелья, Атлас будет определить ваше местоположение, чтобы выбрать лучшую карту подземелья для вас."
L["ATLAS_OPTIONS_BOSS_DESC"] = "Показать описание босса (если доступно)"
L["ATLAS_OPTIONS_BOSS_DESC_SCALE"] = "Размер подсказки описания босса на карте"
L["ATLAS_OPTIONS_BOSS_DESC_TIP"] = "При наведении курсора мышки над номером босса, будет показано описание босса, если такая информация доступна."
L["ATLAS_OPTIONS_BUTPOS"] = "Расположение кнопки"
L["ATLAS_OPTIONS_BUTRAD"] = "Радиус расположения кнопки"
L["ATLAS_OPTIONS_BUTTON"] = "Настройки"
L["ATLAS_OPTIONS_CATDD"] = "Сортировать подземелья по:"
L["ATLAS_OPTIONS_CHECKMODULE"] = "Напоминать о недостоющих модулях / плагинах."
L["ATLAS_OPTIONS_CHECKMODULE_TIP"] = "Выполнение проверки после загрузки WoW, на наличие недостающих модулей / плагинов Atlas'а."
L["ATLAS_OPTIONS_CLAMPED"] = "Не заходить за размеры экрана"
L["ATLAS_OPTIONS_CLAMPED_TIP"] = "Фиксировать окно Атласа на экране, отключение позволит перемещать окно Атласа за пределы игрового экрана."
L["ATLAS_OPTIONS_COLORINGDROPDOWN"] = "Цвет ур. сложности подземелья"
L["ATLAS_OPTIONS_COLORINGDROPDOWN_TIP"] = "Полагаясь на предложенный минимальный уровень подземелья и уровень игрока, окрашивать названия подземелий с учетом их уровня сложности."
L["ATLAS_OPTIONS_CTRL"] = "Удерживайте клавишу [CTRL] для сравнений"
L["ATLAS_OPTIONS_CTRL_TIP"] = "Включить/отключить отображение подсказки при удерживании клавиши CTRL и наведении курсора мышки на информационной карте. Полезно тогда, когда текст слишком длинный, для отображения в окне."
L["ATLAS_OPTIONS_DONTSHOWAGAIN"] = "Не отображать одинаковую информацию снова."
L["ATLAS_OPTIONS_LOCK"] = "Закрепить окно Атласа"
L["ATLAS_OPTIONS_LOCK_TIP"] = "Закрепить / освободить окно Атласа."
L["ATLAS_OPTIONS_RCLICK"] = "[ПКМ] для карты мира"
L["ATLAS_OPTIONS_RCLICK_TIP"] = "Включает отображение мировой карты при нажатии ПКМ в окне Атласа."
L["ATLAS_OPTIONS_RESETPOS"] = "Сбросить позиции"
L["ATLAS_OPTIONS_SCALE"] = "Размер"
L["ATLAS_OPTIONS_SHOWBUT"] = "Показывать кнопку у мини-карты"
L["ATLAS_OPTIONS_SHOWBUT_TIP"] = "Отображать кнопку Атласа у мини-карты."
L["ATLAS_OPTIONS_TRANS"] = "Прозрачность"
L["ATLAS_SEARCH_UNAVAIL"] = "Поиск недоступен"
L["ATLAS_SLASH"] = "/atlas"
L["ATLAS_SLASH_OPTIONS"] = "options"
L["ATLAS_STRING_CLEAR"] = "Сбросить"
L["ATLAS_STRING_LEVELRANGE"] = "Уровень" -- Needs review
L["ATLAS_STRING_LOCATION"] = "Расположение"
L["ATLAS_STRING_MINLEVEL"] = "Минимальный уровень"
L["ATLAS_STRING_PLAYERLIMIT"] = "Лимит игроков"
L["ATLAS_STRING_RECLEVELRANGE"] = "Реком. уровень" -- Needs review
L["ATLAS_STRING_SEARCH"] = "Поиск"
L["ATLAS_STRING_SELECT_CAT"] = "Выбор категории"
L["ATLAS_STRING_SELECT_MAP"] = "Выбор карты"
L["ATLAS_TITLE"] = "Атлас"
L["Attunement Required"] = "Необходима подготавка"
L["Auch"] = "Аук"
L["Augh"] = "Ауг"
L["Auld Stonespire"] = "Ольд Каменное Копье"
L["Auntie Stormstout"] = "Тетушка Буйный Портер"
L["Avatar of the Martyred"] = "Аватара Мученика"
L["Back"] = "Назад"
L["Baelog's Chest"] = "Сундук Бейлога"
L["Bakkalzu"] = "Баккальзу"
L["Baleflame"] = "Пламегон"
L["Ban Bearheart"] = "Бань Медвежье Сердце"
L["Barkeep Kelly <Bartender>"] = "Кабатчик Келли <Бармен>"
L["Barnes <The Stage Manager>"] = "Барнс <Конферансье>"
L["Baroness Dorothea Millstipe"] = "Баронесса Дороти Милстип"
L["Baron Rafe Dreuger"] = "Барон Раф Дреугер"
L["Basement"] = "Подвал"
L["Battle for Mount Hyjal"] = "Битва за Гору Хиджал"
L["B.E Barechus <S.A.F.E.>"] = "Б.Е. Барекус <С.П.А.С.>"
L["Belgaristrasz"] = "Белгаристраз"
L["Belnistrasz"] = "Белнистраз"
L["Bennett <The Sergeant at Arms>"] = "Беннет <Начальник охраны>"
L["Berinand's Research"] = "Исследования Беринарда"
L["Berserking Boulder Roller"] = "Яростный выворачиватель валунов"
L["Berthold <The Doorman>"] = "Бертольд <Привратник>"
L["BF"] = "КК"
L["BFD"] = "НП"
L["BH"] = "КБ"
L["Bilger the Straight-laced"] = "Бочкопуз Крепкосбитый"
L["BINDING_HEADER_ATLAS_TITLE"] = "Сопоставления кнопок"
L["BINDING_NAME_ATLAS_AUTOSEL"] = "Авто-выбор поздемелья"
L["BINDING_NAME_ATLAS_OPTIONS"] = "Настройки Атласа"
L["BINDING_NAME_ATLAS_TOGGLE"] = "Атлас"
L["Black Dragonflight Chamber"] = "Комната черных драконов"
L["Blacksmithing Plans"] = "Чертежи кузнечного дела"
L["Blastmaster Emi Shortfuse"] = "Взрывник Ими Фитилюшка"
L["Blood Guard Hakkuz <Darkspear Elite>"] = "Кровавый страж Хаккуз <Элита племени Черного Копья>"
L["Blood of Innocents"] = "Кровь невинных"
L["Bloodslayer T'ara <Darkspear Veteran>"] = "Умертвительница Т'ара <Ветеран Черного Копья>"
L["Bloodslayer Vaena <Darkspear Veteran>"] = "Умертвительница Ваэна <Ветеран Черного Копья>"
L["Bloodslayer Zala <Darkspear Veteran>"] = "Умертвительница Залла <Ветеран Черного Копья>"
L["Bodley"] = "Бодли"
L["Bortega <Reagents & Poison Supplies>"] = "Бортега <Реагенты и яды>"
L["BoT"] = "СБ"
L["Bota"] = "Бота"
L["Bovaal Whitehorn"] = "Боваал Белый Рог"
L["Bowmistress Li <Guard Captain>"] = "Лучница Ли <Капитан стражи>"
L["Brann Bronzebeard"] = "Бранн Бронзобород"
L["Brazen"] = "Бронзень"
L["BRC"] = "ПСГ"
L["BRD"] = "ГЧГ"
L["Brewfest"] = "Праздника пива"
L["BRF"] = "ЛКЧГ"
L["Brigg Smallshanks"] = "Бригг Мелкотруб"
L["Briney Boltcutter <Blackwater Financial Interests>"] = "Брини Болторез <Финансовый воротила пиратов Черноводья>"
L["BRM"] = "ЧГ"
L["Broken Stairs"] = "Сломаная лесница"
L["BSM"] = "ШКМ"
L["BT"] = "ЧХ"
L["Bucket of Meaty Dog Food"] = "Ведро с собачьим кормом"
L["BWD"] = "ТКТ"
L["BWL"] = "ЛКТ"
L["Cache of Eregos"] = "Тайник Эрегоса"
L["Caelestrasz"] = "Келестраз"
L["Calliard <The Nightman>"] = "Кальярд <Ночной страж>"
L["Captain Alina"] = "Капитан Алина"
L["Captain Boneshatter"] = "Капитан Костолом"
L["Captain Drenn"] = "Капитан Дренн"
L["Captain Edward Hanes"] = "Капитан Эдвард Хейнс"
L["Captain Hadan"] = "Капитан Хадан"
L["\"Captain\" Kaftiz"] = "Капитан Кафтиц"
L["Captain Qeez"] = "Капитан Квиз"
L["Captain Sanders"] = "Капитан Сандерс"
L["Captain Taylor"] = "Капитан Тейлор"
L["Captain Tuubid"] = "Капитан Туубид"
L["Captain Wyrmak"] = "Капитан Змеюк"
L["Captain Xurrem"] = "Капитан Ксуррем"
L["Cath"] = "Соб"
L["Cathedral"] = "Собор"
L["Cavern Entrance"] = "Вход"
L["Caza'rez"] = "Каса'рес"
L["Celebras the Redeemed"] = "Келебрас Освобожденный"
L["Centrifuge Construct"] = "Центрифужное создание"
L["Champ"] = "ИЧ"
L["Champions of the Alliance"] = "Чемпионы Альянса"
L["Champions of the Horde"] = "Чемпионы Орды"
L["Charred Bone Fragment"] = "Фрагмент обугленной кости"
L["Chase Begins"] = "Начало охоты"
L["Chase Ends"] = "Конец охоты"
L["Chef Jessen <Speciality Meat & Slop>"] = "Шеф-повар Джессен <Деликатесное мясо и похлебки>"
L["Chen Stormstout"] = "Чэнь Буйный Портер"
L["Chester Copperpot <General & Trade Supplies>"] = "Честер Медноковш <Потребительские и хозяйственные товары>"
L["Chief Engineer Bilgewhizzle <Gadgetzan Water Co.>"] = "Главный инженер Чепухастер <Компания \"Воды Прибамбасска\">"
L["Child"] = "Ребенок"
L["Chomper"] = "Чавккер"
L["Chromie"] = "Хроми"
L["Chronicler Bah'Kini"] = "Летописец Ба'кини"
L["Clarissa"] = "Кларисса"
L["Click to open Dungeon Journal window."] = "[ЛКМ] - открывает окно журнала подземелий."
L["Coffer of Forgotten Souls"] = "Сундук забытых душ"
L["Colon"] = ": " -- Needs review
L["Colonel Zerran"] = "Полковник Зерран"
L["Colosos"] = "Колосус"
-- L["Comma"] = ""
L["Commander Bagran"] = "Командир Багран"
L["Commander Lindon"] = "Командир Линдон"
L["Commander Mograine"] = "Командир Могрейн"
L["Compendium of the Fallen"] = "\"Компендиум павших\""
L["Connection"] = "Связан"
L["Core Fragment"] = "Осколок из Огненных Недр"
L["CoT"] = "ПВ"
L["CoT1"] = "ПВ1"
L["CoT2"] = "ПВ2"
L["CoT3"] = "ПВ3"
L["CoT-DS"] = "ПВ-ДД"
L["CoT-ET"] = "ПВ-КВ"
L["CoT-HoT"] = "ПВ-ЧС"
L["CoT-Strat"] = "ПВ-Страт"
L["CoT-WoE"] = "ПВ-ИВ"
L["CR"] = "РКК"
L["Crus"] = "Crus"
L["Crusade Commander Eligor Dawnbringer <Brotherhood of the Light>"] = "Командир Элигор Вестник Рассвета <Братство Света>"
L["Crusade Commander Korfax <Brotherhood of the Light>"] = "Командир рыцарей Корфакс <Братство Света>"
L["Crusaders' Coliseum"] = "Колизей Авангарда"
L["Crusaders' Square Postbox"] = "Ключ от почтового ящика на Площади рыцарей"
L["Cryo-Engineer Sha'heen"] = "Крио-инженер Ша'хин"
L["Cursed Centaur"] = "Проклятый кентавр"
L["Darkheart"] = "Черносерд"
L["Dark Keeper Key"] = "Ключ темного хранителя"
L["Dark Ranger Kalira"] = "Темный следопыт Калира"
L["Dark Ranger Loralen"] = "Темный следопыт Лорален"
L["Dark Ranger Marrah"] = "Темный следопыт Марра"
L["Dark Ranger Velonara"] = "Темный следопыт Велонара"
L["Dasnurimi <Geologist & Conservator>"] = "Даснурими <Геолог>"
L["Dealer Tariq <Shady Dealer>"] = "Делец Тариг <Сомнительный делец>"
L["Dealer Vijaad"] = "Делец Виджад"
L["Deathstalker Commander Belmont"] = "Командир стражей смерти Бельмонт"
L["Defender Mordun"] = "Защитник Мордун"
L["Dire Maul Arena"] = "Арена забытого города"
L["Dire Pool"] = "Забытый остров"
L["Divination Scryer"] = "Гадательный кристалл"
L["DM"] = "ЗГ"
L["Dominic"] = "Доминик"
L["Don Carlos"] = "Дон Карлос"
L["D'ore"] = "Д'оре"
L["Draenei Spirit"] = "Дух дренея"
L["Drakkisath's Brand"] = "Клеймо Драккисата"
L["Drakuru's Brazier"] = "Жаровня Дракуру"
L["Drisella"] = "Дризелла"
L["Druid of the Talon"] = "Друид-ворон"
L["DTK"] = "КДТ"
L["Earthbinder Rayge"] = "Землепряд Гневвс"
L["Earthwarden Yrsa <The Earthen Ring>"] = "Хранитель земли Изра <Служители Земли>"
L["East"] = "Восток"
L["EB"] = "ВЧ"
L["Ebonlocke <The Noble>"] = "Чернодрев <Аристократ>"
L["Ebru <Disciple of Naralex>"] = "Эбру <Ученица Наралекса>"
-- L["Echoing Horn of the Damned"] = ""
L["Echo of Medivh"] = "Эхо Медива"
L["Elder Chogan'gada"] = "Предок Чоган'гада"
L["Elder Farwhisper"] = "Старейшина Тихий Шепот"
L["Elder Igasho"] = "Предок Игашо"
L["Elder Jarten"] = "Предок Яртен"
L["Elder Kilias"] = "Предок Килиас"
L["Elder Mistwalker"] = "Старейшина Странник Туманов "
L["Elder Morndeep"] = "Старейшина Рассветень"
L["Elder Nurgen"] = "Предок Нурген"
L["Elder Ohanzee"] = "Предок Оханзи"
L["Elder Splitrock"] = "Старейшина Камнепад"
L["Elders' Square Postbox"] = "Ключ от почтового ящика на Площади старейшины"
L["Elder Starsong"] = "Старейшина Звездная Песня"
L["Elder Stonefort"] = "Старейшина Камнеград"
L["Elder Wildmane"] = "Старейшина Дикая Грива "
L["Elder Yurauk"] = "Предок Яруак"
L["Elevator"] = "Лифт"
L["Ellrys Duskhallow"] = "Эллриса Почитательница Тени"
L["End"] = "Конец"
L["Engineer"] = "Инженер"
L["Entrance"] = "Вход"
L["Eramas Brightblaze"] = "Эрамас Сияющее Пламя"
L["Erozion"] = "Эрозион"
L["Escape from Durnholde Keep"] = "Побег из Дарнхольда"
L["Estulan <The Highborne>"] = "Эстулан <Высокорожденный>"
L["Eternos"] = "Этернос"
L["Ethereal Transporter Control Panel"] = "Пульт управления астрального телепорта"
L["Eulinda <Reagents>"] = "Эулинда <Реагенты>"
L["Eva Sarkhoff"] = "Ева Саркофф"
L["Event"] = "Событие"
L["Exalted"] = "Превознесение"
L["Exarch Larethor"] = "Экзарх Ларетор"
L["Exit"] = "Выход"
L["Face <S.A.F.E.>"] = "Физий <С.П.А.С.>"
L["Fairbanks"] = "Фэйрбанкс"
L["Falrin Treeshaper"] = "Фалрин Садовник"
L["Farmer Kent"] = "Фермер Кент"
L["Farseer Tooranu <The Earthen Ring>"] = "Предсказатель Тоорану <Служители Земли>"
L["Father Flame"] = "Огонь отцов"
L["Fathom Stone"] = "Глубинный Камень"
L["Fel Crystals"] = "Кристалл Скверны"
L["Fenstalker"] = "Болотный ловец"
L["Ferra"] = "Ферра"
L["Festival Lane Postbox"] = "Ключ от почтового ящика на Праздничной улице"
L["FH1"] = "ЛЗ1"
L["FH2"] = "ЛЗ2"
L["FH3"] = "ЛЗ3"
L["Field Commander Mahfuun"] = "Боевой командир Мафуун"
L["Finkle Einhorn"] = "Айс Вентурон"
L["Fire of Aku'mai"] = "Огонь Аку'майя"
L["First Fragment Guardian"] = "Страж первого фрагмента"
L["Fizzle"] = "Пшикс"
L["FL"] = "ОП"
L["Flaming Eradicator"] = "Пылающий искоренитель"
L["Flesh'rok the Diseased <Primordial Saurok Horror>"] = "Мясо'рок Прокаженный <Древний ужас>"
L["Focused Eye"] = "Сосредоточенный глаз"
L["Forbidden Rites and other Rituals Necromantic"] = "Запретные обряды и иные ритуалы некромантов"
L["Forest Frogs"] = "Лесная лягушка"
L["FoS"] = "Кузня Душ"
L["Four Kaldorei Elites"] = "4 Кальдорайских гвардейцев"
L["Fourth Stop"] = "Четвертая остановка"
L["Frances Lin <Barmaid>"] = "Франс Лин <Официантка>"
L["Fras Siabi's Postbox"] = "Ключ от почтового ящика Фраса Сиаби"
L["From previous map"] = "На предыдущую карту"
L["Front"] = "Передний"
L["Frostwyrm Lair"] = "Логово Ледяного Змея"
L["Furgus Warpwood"] = "Фургус Криводрев"
L["Galamav the Marksman <Kargath Expeditionary Force>"] = "Галамав Стрелок <Каргатский экспедиционный корпус>"
L["Galgrom <Provisioner>"] = "Гальгром <Поставщик>"
L["Garaxxas"] = "Гараксас"
L["Gazakroth"] = "Газакрот"
L["GB"] = "ГБ"
L["GD"] = "ДМП"
L["Ghost"] = "Призрак"
L["GL"] = "Груль"
L["Gnome"] = "Гном"
L["Gomora the Bloodletter"] = "Гомора Кровопускатель"
L["Gorkun Ironskull"] = "Горкун Железный Череп"
L["Gradav <The Warlock>"] = "Градав <Чернокнижник>"
L["Graveyard"] = "Кладбище"
L["Greatfather Aldrimus"] = "Великий Отец Алдримус"
L["GSS"] = "ВЗС"
L["Guardian of Time"] = "Хранитель Времени"
L["Gub <Destroyer of Fish>"] = "Габ <Гроза рыб>"
L["Guerrero"] = "Герреро"
L["Gun"] = "Гун"
L["Gunny"] = "Пушкаренок"
L["GY"] = "Кл"
-- L["Ha'lei"] = ""
L["Ha'Lei"] = "Ха'лей"
L["Hallow's End"] = "Тыква"
L["Halls"] = "ЗАо"
L["Hal McAllister"] = "Хал Макаллистер"
L["Hann Ibal <S.A.F.E.>"] = "Ганни Бал <С.П.А.С.>"
L["Harald <Food Vendor>"] = "Гаральд <Продавец еды>"
L["Hastings <The Caretaker>"] = "Гастингс <Управляющий>"
L["Haunted Stable Hand"] = "Дух помощника смотрителя стойл"
L["Hazlek"] = "Хазлек"
L["HC"] = "ЦАП"
L["Helcular"] = "Гелькулар"
L["Helpful Jungle Monkey"] = "Услужливая мартышка"
L["Herod the Bully"] = "Герод Забияка"
L["Heroic"] = "Героический"
L["Heroic: Trial of the Grand Crusader"] = "Героик: Испытание великого крестоносца"
L["Hierophant Theodora Mulvadania <Kargath Expeditionary Force>"] = "Верховная Жрица Теодора Мальвадания"
L["High Examiner Tae'thelan Bloodwatcher <The Reliquary>"] = "Главный дознаватель Тей'телан Кровавый Взор <Реликварий>"
L["High Justice Grimstone"] = "Верховный судья Мрачнокамень"
L["HM"] = "ВМ"
L["HoF"] = "СС"
L["HoL"] = "ЧМ"
L["Holy Paladin"] = "Паладин-Света"
L["Holy Priest"] = "Жрец-Света"
L["HoO"] = "ЧТГС"
L["Hooded Crusader"] = "Рыцарь в капюшоне"
L["HoR"] = "ЗО"
L["Horde Encampment"] = "Стоянка Орды"
L["Horvon the Armorer <Armorsmith>"] = "Хорвон Бронник <Бронник>"
L["HoS"] = "ЧК"
L["Hunter"] = "Охотник"
-- L["Hyphen"] = ""
L["IC"] = "ЦЛК"
L["ID"] = "ЖД"
L["Image of Argent Confessor Paletress"] = "Проекция исповедницы Серебряного Авангарда Пейлтресс"
L["Image of Drakuru"] = "Проекция Дракуру"
L["Imp"] = "Бесс"
L["Indormi <Keeper of Ancient Gem Lore>"] = "Индорми <Хранитель знаний о древних самоцветах>"
L["Innkeeper Monica"] = "Хозяйка таверны Моника"
L["Instructor Chillheart's Phylactery"] = "Филактерия инструктора Ледяное Сердце"
L["In the Shadow of the Light"] = "В тени света"
L["Investigator Fezzen Brasstacks"] = "Испытатель Феззен Клейстр"
L["Invoker Xorenth"] = "Заклинатель Ксорент"
L["Ironbark the Redeemed"] = "Железная Кора - отмщенный"
L["Isfar"] = "Исфар"
L["Isillien"] = "Изиллиен"
L["Itesh"] = "Итеш"
L["Jaelyne Evensong"] = "Джейлин Закатная Песня"
L["Jalinda Sprig <Morgan's Militia>"] = "Джалинда Тирлипунька"
L["Jay Lemieux"] = "Джей Лемье"
L["J'eevee's Jar"] = "Флакон Д'жииви"
L["Je'neu Sancrea <The Earthen Ring>"] = "Дже'неу Санкри <Служители Земли>"
L["Jerry Carter"] = "Джерри Картер"
L["Jonathan Revah"] = "Джонатан Рева"
L["Joseph the Awakened"] = "Джозеф Беспокойный"
L["Joseph the Crazed"] = "Джозеф Безумный"
L["Joseph the Insane <Scarlet Champion>"] = "Джозеф Чокнутый <Воитель из Алого ордена>"
L["Julie Honeywell"] = "Джули Медовушка"
L["Kagani Nightstrike"] = "Кагани Ночной Удар"
L["Kagtha"] = "Кагта"
L["Kaldir Ironbane"] = "Калдир Железоруб"
L["Kaldrick"] = "Кальдрик"
L["Kamsis <The Conjurer>"] = "Камсис <Кудесник>"
L["Kandrostrasz <Brood of Alexstrasza>"] = "Кандострас <Племя Алекстразы>"
L["Kand Sandseeker <Explorer's League>"] = "Канд Искатель Песков <Лига исследователей>"
L["Kara"] = "Кара"
L["Kasha"] = "Кайша"
L["Kaulema the Mover"] = "Каулема Толкатель"
L["Keanna's Log"] = "Записи Кеанны"
L["Kel'Thuzad's Deep Knowledge"] = "Сокровенное знание Кел'Тузада"
L["Kevin Dawson <Morgan's Militia>"] = "Кевин Доусон <Отряд Морганы>"
L["Key"] = "Ключ"
L["Kherrah"] = "Керра"
L["King's Square Postbox"] = "Ключ от почтового ящика на Королевской площали"
L["Knot Thimblejack"] = "Уззл Наперстяк"
L["Koragg"] = "Корагг"
L["Korag Proudmane"] = "Кораг Гордая Грива"
L["Koren <The Blacksmith>"] = "Корен <Кузнец>"
L["Koristrasza"] = "Користраза"
L["Kurzel"] = "Курцель"
L["Lady Catriona Von'Indi"] = "Леди Катриона Фон'Инди"
L["Lady Jaina Proudmoore"] = "Леди Джайна Праудмур"
L["Lady Keira Berrybuck"] = "Леди Кейра Ягодная Корзина"
L["Lady Sylvanas Windrunner <Banshee Queen>"] = "Леди Сильвана Ветрокрылая"
L["Lakka"] = "Лакка"
L["Lana Stouthammer"] = "Лана Твердомолот"
L["Landing Spot"] = "Место высадки"
L["Large Stone Obelisk"] = "Большой каменный обелиск"
L["LBRS"] = "НЧГ"
L["LCoT"] = "ЗГТВ"
-- L["L-DQuote"] = ""
L["Lead Prospector Durdin <Explorer's League>"] = "Старший геолог Дардин <Лига исследователей>"
L["Legionnaire Nazgrim"] = "Легионер Назгрим"
L["Lenzo"] = "Ленцо"
L["Lexlort <Kargath Expeditionary Force>"] = "Лекслорт <Каргатский экспедиционный корпус>"
L["Lib"] = "Биб"
L["Library"] = "Библиотека"
L["Lidia Sunglow <The Reliquary>"] = "Лидия Солнечное Сияние <Реликварий>"
L["Lieutenant Horatio Laine"] = "Лейтенант Горацио Лейн"
L["Lieutenant Sinclari"] = "Лейтенант Синклари"
L["Little Jimmy Vishas"] = "Малыш Джимми Вишас"
L["Lokhtos Darkbargainer <The Thorium Brotherhood>"] = "Локтос Зловещий Торговец"
L["Lord Afrasastrasz"] = "Лорд Афрасастраз"
L["Lord Crispin Ference"] = "Лорд Криспин Ференс"
L["Lord Itharius"] = "Лорд Итар"
L["Lord Raadan"] = "Лорд Раадан"
L["Lord Robin Daris"] = "Лорд Робин Дэрис"
L["Lorekeeper Javon"] = " Сказитель Явон"
L["Lorekeeper Kildrath"] = "Сказитель Килдрат"
L["Lorekeeper Lydros"] = "Сказитель Лидрос"
L["Lorekeeper Mykos"] = "Сказительница Микос"
L["Lorgalis Manuscript"] = "Манускрипт Лоргалиса"
L["Lothos Riftwaker"] = "Лотос Хранитель Портала"
L["Love is in the Air"] = "Любовная лихорадка"
L["Lower"] = "Нижний"
-- L["L-Parenthesis"] = ""
-- L["L-SBracket"] = ""
L["Lucien Sarkhoff"] = "Люсьен Саркофф"
L["Lumbering Oaf"] = "Болванчик"
L["Lunar Festival"] = "Лунный фестиваль"
L["Lurah Wrathvine <Crystallized Firestone Collector>"] = "Лура Гневная Лоза <Собиратель кристаллизованного кремня>"
L["Madrigosa"] = "Мадригоса"
L["Mag"] = "Маги"
L["Mage"] = "Маг"
L["Magical Brazier"] = "Магическая жаровня"
L["Magistrate Henry Maleb"] = "Мировой судья Генри Малеб"
L["Mail Box"] = "Почтовый яшик"
L["Main Chambers Access Panel"] = "Главная камера сгорания - Панель доступа"
L["Major Pakkon"] = "Майор Паккон"
L["Major Yeggeth"] = "Майор Йеггет"
L["Mamdy the \"Ologist\""] = "Мамди по кличке \"Олог\""
-- L["MapA"] = ""
-- L["MapB"] = ""
-- L["MapC"] = ""
-- L["MapD"] = ""
-- L["MapE"] = ""
-- L["MapF"] = ""
-- L["MapG"] = ""
-- L["MapH"] = ""
-- L["MapI"] = ""
-- L["MapJ"] = ""
L["MapsNotFound"] = [=[Текущее выбранное подземелье не имеет 
соответствующего изображения карты. 

Пожалуйста, убедитесь, что вы установили 
соответствующий модуль(и) карт Atlas'а.]=]
L["Mara"] = "Маро"
L["Market Row Postbox"] = "Ключ от почтового ящика в торговом ряду"
L["Marshal Jacob Alerius"] = "Маршал Якоб Алерий"
L["Marshal Maxwell <Morgan's Militia>"] = "Маршал Максвелл <Отряд Морганы>"
L["Martin Victus"] = "Мартин Викт"
L["Master Craftsman Wilhelm <Brotherhood of the Light>"] = "Мастер-ремесленник Вильгельм <Братство Света>"
L["Master Elemental Shaper Krixix"] = "Ваятель стихий Криксикс"
L["Master Windstrong"] = "Мастер Порывистый Ветер"
L["MaT"] = "ТМ"
L["Mawago"] = "Маваго"
L["Maxwort Uberglint"] = "Максворт Суперблеск"
L["Mayara Brightwing <Morgan's Militia>"] = "Майра Светлое Крыло <Отряд Морганы>"
L["Mazoga's Spirit"] = "Дух Мазоги"
L["MC"] = "ОН"
L["Mech"] = "Мех"
L["Meeting Stone"] = "Камень встреч"
L["Meeting Stone of Hellfire Citadel"] = "Камень встреч Цитадели Адского Пламени"
L["Meeting Stone of Magtheridon's Lair"] = "Камень встреч Логова Магтеридона"
L["Melasong"] = "Меласонг"
L["Melissa"] = "Мелисса"
L["Merithra of the Dream"] = "Меритра из Сна"
L["Micah"] = "Мика"
L["Middle"] = "Центр"
L["Midsummer Festival"] = "Огненный солнцеворот"
L["Millhouse Manastorm"] = "Милхаус Манашторм"
L["Miss Mayhem"] = "Мисс Кавардак"
L["Mistress Nagmara"] = "Госпожа Нагмара"
L["Monara <The Last Queen>"] = "Монара <Последняя королева>"
L["Monk"] = "Монах"
L["Moonwell"] = "Лунный колодец"
L["Mor'Lek the Dismantler"] = "Мор'Лек Расчленитель"
L["Mortaxx <The Tolling Bell>"] = "Мортакс <Предвестник смерти>"
L["Mortog Steamhead"] = "Мортог Горячая Голова"
L["Mountaineer Orfus <Morgan's Militia>"] = "Горный пехотинец Орфус <Отряд Морганы>"
L["MP"] = "ДМОГ"
L["Mr. Bigglesworth"] = "Мистер Бигглсуорт"
L["MT"] = "ГМ"
L["Murd Doc <S.A.F.E.>"] = "Мерд-Док <С.П.А.С.>"
L["Muyoh <Disciple of Naralex>"] = "Муйон <Ученик Наралекса>"
L["MV"] = "ПМ"
L["Mysterious Bookshelf"] = "Подозрительные книжные полки"
L["Nahuud"] = "Нахууд"
L["Nalpak <Disciple of Naralex>"] = "Налпак <Ученик Наралекса>"
L["Naralex"] = "Наралекс"
L["Naresir Stormfury <Avengers of Hyjal Quartermaster>"] = "Наресир Штормовая Ярость <Интендант Хиджальских мстителей>"
L["Nathanos Marris"] = "Натанос Маррис"
L["Nat Pagle"] = "Нат Пэгл"
L["Naturalist Bite"] = "Натуралист Кус"
L["Nax"] = "Накс"
L["Neptulon"] = "Нептулон"
L["Nex, Nexus"] = "Некс, Нексус"
L["Nexus-Prince Haramad"] = "Принц Харамад"
L["Night Elf Village"] = "Деревня ночных эльфов"
L["No'ku Stormsayer <Lord of Tempest>"] = "Но'ку Буревестник <Владыка бури>"
L["Norkani"] = "Норкани"
L["North"] = "Север"
L["Nozari <Keepers of Time>"] = "Нозари <Хранители Времени>"
L["Nozdormu"] = "Ноздорму"
L["Nurse Lillian"] = "Медсестра Лилиан"
L["Ocu"] = "Оку"
L["Okuno <Ashtongue Deathsworn Quartermaster>"] = "Окуно <Начальник снабжения Пеплоустов>"
L["Old Ironbark"] = "Старик Железной Коры"
L["Olga Runesworn <Explorer's League>"] = "Ольга Преданная Рунам <Лига исследователей>"
L["Ony"] = "Ony"
L["Opening of the Dark Portal"] = "Открытие Темных врат"
L["Optional"] = "Необяз."
L["Oralius <Morgan's Militia>"] = "Орелий"
L["Orange"] = "Оранжевый"
L["Orb of Command"] = "Сфера Приказа"
L["Orb of Domination"] = "Сфера Приказа"
L["OS"] = "OS"
L["Outside"] = "Снаружи"
L["Overcharged Manacell"] = "Переполненный зарядом контейнер с маной"
L["Overseer Blingbang"] = "Инспектор Бадабум"
L["Overwatch Mark 0 <Protector>"] = "Суперсторож, модель 0 <Заступник>"
L["Packleader Ivar Bloodfang"] = "Вожак стаи Ивар Кровавый Клык"
L["Packmaster Stonebruiser <Brotherhood of the Light>"] = "Караванщик Камнетес <Братство Света>"
L["Paladin"] = "Паладин"
L["Path to the Broken Stairs"] = "Путь к разрушенным лестницам"
L["Path to the Hellfire Ramparts and Shattered Halls"] = "Путь к Бастионам и Разрушенным залам"
-- L["Period"] = ""
L["Phin Odelic <The Kirin Tor>"] = "Фин Оделик <Кирин Тор>"
L["Polyformic Acid Potion"] = "Наука о кислоте"
L["Portal"] = "Портал"
L["PoS"] = "Яма"
L["PossibleMissingModule"] = "Вполне вероятно, эта карта из этого модуля: "
L["Precious"] = "Прелесть"
L["Priest"] = "Жрец"
L["Priestess Summerpetal"] = "Жрица Летний Лепесток"
L["Priestess Udum'bra"] = "Жрица Удум'бра"
L["Private Jacint"] = "Рядовой Джасинт"
L["Private Rocknot"] = "Рядовой Камнеузл"
L["Professor Slate"] = "Профессор Слейт"
L["Prospector Doren"] = "Геолог Дорен"
L["Prospector Seymour <Morgan's Militia>"] = "Геолог Сеймур <Отряд Морганы>"
L["Protection Warrior"] = "Воин-Защиты"
L["Provisioner Tsaalt"] = "Поставщик Тсаальт"
L["Pumpkin Shrine"] = "Святилище Тыквы"
L["Purple"] = "Пурпурный"
L["Pylons"] = "Опоры"
L["Quartermaster Lewis <Quartermaster>"] = "Интендант Льюис <Интендант>"
L["Raleigh the True"] = "Роли Истинный"
L["Ramdor the Mad"] = "Рамдор Безумный"
L["Ramp"] = "Баст"
L["Ramp down to the Gamesman's Hall"] = "Спуск в игровой зал"
L["Ramp to Guardian's Library"] = "Рампа к библиотеку стражи"
L["Ramp to Medivh's Chamber"] = "Рампа в комнату Медива"
L["Ramp up to the Celestial Watch"] = "Подъём к небесному надзору"
L["Random"] = "Случайный"
L["Randy Whizzlesprocket"] = "Рэнди Свистельник"
L["Rare"] = "Редкий"
L["Raven"] = "Ворон"
L["Razal'blade <Kargath Expeditionary Force>"] = "Разал'меч <Каргатский экспедиционный корпус>"
L["Razorfen Spearhide"] = "Копьешкур из племени Иглошкурых"
-- L["R-DQuote"] = ""
L["Reclaimer A'zak"] = "Завоеватель А'зак"
L["Red Dragonflight Chamber"] = "Комната красных драконов"
L["Red Riding Hood"] = "Красная Шапочка"
L["Reinforced Archery Target"] = "Укрепленная мишень"
L["Reinforced Fel Iron Chest"] = "Укрепленный сундук из оскверненного железа"
L["Relic Coffer Key"] = "Ключ от древнего сундука"
L["Relissa"] = "Релисса"
L["Relwyn Shadestar"] = "Релвин Тень Звезды"
L["Renault Mograine"] = "Рено Могрейн"
L["Repair"] = "Починка"
L["Reputation"] = "Репутация"
L["Retribution Paladin"] = "Паладин-Возмездия"
L["Rewards"] = "Награды"
L["RFC"] = "ОгП"
L["RFD"] = "Курганы"
L["RFK"] = "ЛабИ"
L["Rifle Commander Coe"] = "Командир стрелков Коу"
L["Rifleman Brownbeard"] = "Ружейник Буробород"
L["Rimefang"] = "Иней"
L["Rocky Horror"] = "Скальный ужас"
L["Rogue"] = "Разбойник"
L["Rosa"] = "Роза"
L["Roughshod Pike"] = "Наконечник Грубой силы "
-- L["R-Parenthesis"] = ""
L["RS"] = "PC"
-- L["R-SBracket"] = ""
L["Sa'at <Keepers of Time>"] = "Са'ат <Хранители Времени>"
L["Safe Room"] = "Безопасная Комната"
L["Sally Whitemane"] = "Сэлли Белогрив"
L["SB"] = "ХБП"
L["SBG"] = "НПЛ"
L["SC"] = "ЗС"
L["Scarshield Quartermaster <Scarshield Legion>"] = "Интендант из легиона Изрубленного Щита"
L["Schematic: Field Repair Bot 74A"] = "Схема: полевой ремонтный робот 74A"
L["Scholo"] = "Некро"
L["Scourge Invasion Points"] = "Точки вторжения Плети"
L["Scout Cage"] = "Scout Cage"
L["Scout Orgarr"] = "Разведчик Оргарр"
L["Scout Thaelrid"] = "Страж Талрид"
L["Scrying Orb"] = "Гадательный шар Соланиана"
L["Sebastian <The Organist>"] = "Себастиан <Органист>"
L["Second Fragment Guardian"] = "Страж второго фрагмента"
L["Second Stop"] = "Вторая остановка"
L["Seer Ixit"] = "Провидец Изит"
L["Seer Kanai"] = "Провидец Канеи"
L["Seer Olum"] = "Провидец Олум"
-- L["Semicolon"] = ""
L["Sentinel Aluwyn"] = "Часовой Алувин"
L["Sentinel-trainee Issara"] = "Курсант-часовой Иссара"
L["Servant Quarters"] = "Жильё прислуги"
L["Seth"] = "Сетекк"
L["SFK"] = "КТК"
L["SH"] = "РЗ"
L["Shado-Master Chum Kiu"] = "Шадо-мастер Чум Киу"
L["Shadowforge Brazier"] = "Жаровня Тенегорна"
L["Shadow Lord Xiraxis"] = "Владыка теней Зираксис"
L["Shadow Priest"] = "Жрец-Темной магии"
L["Shaman"] = "Шаман"
L["Shattered Hand Executioner"] = "Палач из клана Изувеченной Длани"
L["Shavalius the Fancy <Flight Master>"] = "Шавалий Модник <Распорядитель полетов>"
L["Shen'dralar Ancient"] = "Шен'драларский поставщик"
L["Shen'dralar Provisioner"] = "Шен'драларский поставщик"
L["Shen'dralar Watcher"] = "Шен'драларский дозорный"
L["Shrine of Gelihast"] = "Святилище Гелихастa"
L["Sif"] = "Сиф"
L["Sinan the Dreamer"] = "Сынань Мечтательница"
L["Sindragosa's Lair"] = "Логово Синдрагосы"
L["Sister Svalna"] = "Сестра Свална"
L["Skar'this the Heretic"] = "Скартис Еретик"
L["SL"] = "ТЛ"
-- L["Slash"] = ""
L["\"Slim\" <Shady Dealer>"] = "Тип <Сомнительный делец>"
L["Slinky Sharpshiv"] = "Крадли Дротик"
L["Slither"] = "Скользь"
L["Sliver <Garaxxas' Pet>"] = "Лыббс <Питомец Гараксаса>"
L["Slosh <Food & Drink>"] = "Хлюп <Еда и напитки>"
L["SM"] = "МАО"
L["SNT"] = "ОХН"
L["SoO"] = "Оо"
L["Soridormi <The Scale of Sands>"] = "Соридорми <Песчаная Чешуя>"
L["South"] = "Юг"
L["Southshore Inn"] = "Дома южнобережья"
L["SP"] = "Узи"
L["Spawn Point"] = "Точка рождения"
L["Spinestalker"] = "Хребтохруст"
L["Spiral Stairs to Netherspace"] = "Спиральные лестницы к Пустомари"
L["Spirit of Agamaggan <Ancient>"] = "Дух Агамаггана <Древний>"
L["Spirit of Olum"] = "Олумов дух"
L["Spirit of Udalo"] = "Дух Адало"
L["SPM"] = "МШадо"
L["Spoils of Blackfathom"] = "Трофеи Непроглядной Пучины"
L["Spy Grik'tha"] = "Шпион Грик'та"
L["Spy To'gun"] = "Шпион То'гун"
L["SR"] = "НП"
L["SSC"] = "ЗС"
L["ST"] = "ЗХ"
L["Stairs to Underground Pond"] = "Лестница к Подземному пруду"
L["Stairs to Underground Well"] = "Лестница к Подземному колодцу"
L["Stalvan Mistmantle"] = "Сталван Мистмантл"
L["Start"] = "Начало"
L["Steps and path to the Blood Furnace"] = "Подъем и путь к Кузне Крови"
L["Steward of Time <Keepers of Time>"] = "Распорядитель времени <Хранители Времени>"
L["Stinky"] = "Вонючка"
L["Stocks"] = "Тюрьма"
L["Stone Guard Kurjack"] = "Каменный cтраж Курджак"
L["Stone Guard Stok'ton"] = "Каменный страж Сток'тон"
L["Stonemaul Ogre"] = "Огр из клана Каменного Молота"
L["Stormherald Eljrrin"] = "Штормовестник Элдррин"
L["Strat"] = "Страт"
L["Stratholme Courier"] = "Стратхольмский курьер"
L["Summon"] = "Вызов"
L["Summoner's Tomb"] = "Гробница Призывателей"
L["SuP"] = "СК"
L["Suspicious Bookshelf"] = "Странный книжный шкаф"
L["SV"] = "ПП"
L["Taelan"] = "Таэлан"
L["Talking Skull"] = "Говорящий череп"
L["Taretha"] = "Тарета"
L["Teleporter"] = "Телепорт"
L["Teleporter destination"] = "Назначение телепорта"
L["Teleporter to Middle"] = "Телепорт в центр"
L["TEoE"] = "ОВ"
L["TES"] = "ТВВ"
L["Thal'trak Proudtusk <Kargath Expeditionary Force>"] = "Тал'трак Гордый Клык <Каргатский экспедиционный корпус>"
L["The Behemoth"] = "Чудище"
L["The Black Anvil"] = "Черная наковальня"
L["The Black Forge"] = "Черная Кузня"
L["The Captain's Chest"] = "Сундук капитана"
L["The Codex of Blood"] = "Кодекс Крови"
L["The Culling of Stratholme"] = "Очищение Стратхольма"
L["The Dark Grimoire"] = "Гримуар Тьмы"
L["The Dark Portal"] = "Темный портал"
L["The Deed to Brill"] = "Документы на Брилл"
L["The Deed to Caer Darrow"] = "Документы на Каэр Дарроу"
L["The Deed to Southshore"] = "Документы на Южнобережье"
L["The Deed to Tarren Mill"] = "Документы на Мельницу Таррен"
L["The Discs of Norgannon"] = "Диски Норганнона"
L["The Eye of Haramad"] = "Око Харамада"
L["The Keepers"] = "Хранители"
L["The Map of Zul'Aman"] = "Карта Зул'Амана"
L["The Master's Terrace"] = "Терраса Мастера"
L["The Nameless Prophet"] = "Безымянный пророк"
L["The Saga of Terokk"] = "Сага о Терокке"
L["The Shadowforge Lock"] = "Замок Тенегорна"
L["The Siege"] = "Осада"
L["The Sparklematic 5200"] = "Чистер 5200!"
L["The Underspore"] = "Подспорник"
L["The Vault"] = "Подземелье"
L["Third Fragment Guardian"] = "Страж третьего фрагмента"
L["Third Stop"] = "Третья остановка"
L["Thomas Yance <Travelling Salesman>"] = "Томас Янс <Странствующий торговец>"
L["Thrall"] = "Раб"
L["Thrall <Warchief>"] = "Тралл <Вождь>"
L["Thunderheart <Kargath Expeditionary Force>"] = "Громосерд <Каргатский экспедиционный корпус>"
L["Thurg"] = "Тург"
L["Tiki Lord Mu'Loa"] = "Вождь тики Му'Лоа"
L["Tiki Lord Zim'wae"] = "Вождь тики Зим'вэ"
L["Tinkee Steamboil"] = "Тинки Кипеллер"
L["Tink Sprocketwhistle <Engineering Supplies>"] = "Звяк Пружиносвист <Инженерные материалы>"
L["TJS"] = "ХНЗ"
L["TK"] = "КБ"
L["Tol'mar"] = "Тол'мар"
L["Tol'vir Grave"] = "Тол'вирская могила"
L["To next map"] = "На следеющею карту"
L["Top"] = "Верхний"
L["Torben Zapblast <Teleportation Specialist>"] = "Торбен Запрыгуль <Мастер телепортации>"
L["Torch Lever"] = "Рукоятка факела"
L["Tormented Soulpriest"] = "Измученный жрец душ"
L["Tor-Tun <The Slumberer>"] = "Тор-Тун <Спящий>"
L["ToT"] = "ЗМ"
L["ToTT"] = "ТП"
L["Towards Illidan Stormrage"] = "К Иллидану Ярости Бури"
L["Towards Reliquary of Souls"] = "К Гробнице Душ"
L["Towards Teron Gorefiend"] = "К Терону Кровожадному"
L["Tower of Flame"] = "Башня Пламени"
L["Tower of Frost"] = "Башня Холода"
L["Tower of Life"] = "Башня Жизни"
L["Tower of Storms"] = "Башня Гроз"
-- L["Train Ride"] = ""
L["Tran'rek"] = "Тран'рек"
-- L["Transport"] = ""
L["Tribunal Chest"] = "Сундук Трибунала"
L["TSC"] = "КН"
L["T'shu"] = "Тшу"
L["Tunnel"] = "Туннель"
L["TWT"] = "ТЧВ"
L["Tydormu <Keeper of Lost Artifacts>"] = "Тайдорму <Хранитель утраченных артефактов>"
L["Tyllan"] = "Тиллан"
L["Tyrande Whisperwind <High Priestess of Elune>"] = "Тиранда Шелест Ветра"
L["Tyrith"] = "Тирит"
L["UB"] = "НТ"
L["UBRS"] = "ВЧГ"
L["Udalo"] = "Адало"
L["UK, Keep"] = "УК, Крепость"
L["Ulda"] = "Ульд"
L["Uldu"] = "Ульда"
L["Unblinking Eye"] = "Немигающий глаз"
L["Underwater"] = "Подводный"
L["Upper"] = "Верхний"
L["Upper Spire"] = "Верхний ярус"
L["UP, Pinn"] = "УВ, Вершина"
L["Urok's Tribute Pile"] = "Груда приношений Арроку"
L["Varies"] = "Изменяется"
L["VC"] = "МК"
L["Vehini <Assault Provisions>"] = "Вехини <Поставщик провизии для армии>"
L["Velastrasza"] = "Веластраза"
L["Vend-O-Tron D-Luxe"] = "Торг-о-трон делюкс"
L["Venomancer Mauri <The Snake's Whisper>"] = "Ядомант Маури <Змееязыкая>"
L["Venomancer T'Kulu <The Toxic Bite>"] = "Ядомант Т'Кулу <Ядовитый укус>"
L["Verdisa"] = "Вердиса"
L["Vethsera <Brood of Ysera>"] = "Ветсера <Род Изеры >"
L["VH"] = "АМК"
L["VoA"] = "Склеп"
L["Vol'jin"] = "Вол'джин"
L["Voodoo Pile"] = "Куча черепов вуду"
L["Vorrel Sengutz"] = "Воррел Сенгутц"
L["VP"] = "ВС"
L["Wanders"] = "Странник"
L["Warden Thelwater"] = "Тюремщик Телвотер"
L["Warlock"] = "Чернокнижник"
L["Warlord Goretooth <Kargath Expeditionary Force>"] = "Полководец Клинозуб <Каргатский экспедиционный корпус>"
L["Warlord Salaris"] = "Полководец Саларис"
L["Warmage Kaitlyn"] = "Боевой маг Кейтлин"
L["Warrior"] = "Воин"
L["Watcher Gashra"] = "Дозорный Гашра"
L["Watcher Jhang"] = "Дозорный Джанг"
L["Watcher Narjil"] = "Дозорный Нарджил"
L["Watcher Silthik"] = "Дозорный Силтик"
L["Watchman Doomgrip"] = "Сторож Хватка Смерти"
L["Wave 10"] = "10-ая волна"
L["Wave 12"] = "12-ая волна"
L["Wave 18"] = "18-ая волна"
L["Wave 5"] = "5-ая волна"
L["Wave 6"] = "6-ая волна"
L["WC"] = "ПС"
L["Weeder Greenthumb"] = "Культиватор Зеленопал"
L["Weegli Blastfuse"] = "Вигиль Фитиль"
L["Weldon Barov <House of Barov>"] = "Вэлдон Баров <Род Баровых>"
L["West"] = "Запад"
L["Willix the Importer"] = "Импортер Вилликс"
L["Windcaller Claw"] = "Призыватель ветров Коготь"
L["Witch Doctor Qu'in <Medicine Woman>"] = "Доктор Ку'ин <Тролль-знахарка>"
L["Witch Doctor T'wansi"] = "Знахарь Т'ванши"
L["Wizard of Oz"] = "Волшебник страны Oз"
L["Wrath of the Lich King"] = "Король-лич"
L["Wravien <The Mage>"] = "Вравьен <Маг>"
L["Yarley <Armorer>"] = "Ярли <Бронник>"
L["Yazzai"] = "Яззай"
L["Young Blanchy"] = "Молодая Савраска"
L["Ythyar"] = "Айтар"
L["Yuka Screwspigot <Engineering Supplies>"] = "Юка Крутипроб"
L["ZA"] = "ЗА"
L["Zaladormu"] = "Заладорму"
L["Zanza the Restless"] = "Занза Неупокоенный"
L["Zanzil's Cauldron of Burning Blood"] = "Котел Занзила с пылающей кровью"
L["Zanzil's Cauldron of Frostburn Formula"] = "Котел Занзила с раствором обжигающего холода"
L["Zanzil's Cauldron of Toxic Torment"] = "Котел Занзила с едкой щелочью"
L["Zao'cho <The Emperor's Shield>"] = "Зао'чо <Щит императора>"
L["Zelfan"] = "Зелфан"
L["Zeya"] = "Зейя"
L["ZF"] = "ЗФ"
L["ZG"] = "ЗГ"
L["Zixil <Aspiring Merchant>"] = "Зиксель <Знаменитый купец>"
L["Zungam"] = "Зангам"
L["ToC/Description"] = "Обозреватель подземелий"
-- L["ToC/Title"] = ""




end