﻿-- $Id: constants.es.lua 3607 2011-10-18 10:35:15Z hegarol $
--[[
constants.es.lua --- Traduction ES por maqjav
This file defines an AceLocale table for all the various text strings needed
by AtlasLoot.  In this implementation, if a translation is missing, it will fall
back to the English translation.


]]

--Create the library instance
local AceLocale = LibStub:GetLibrary("AceLocale-3.0");

local AL = AceLocale:NewLocale("AtlasLoot", "esES", false);

if AL then
	-- #########
	-- UI things
	-- #########
	-- AtlasLootFu 
	AL["AtlasLootFu is no longer in use.\nDelete it from your AddOns folder"] = true;

	-- Options
	AL["Options"] = "Opciones";
	AL["Load Loot Modules at Startup"] = "Cargar módulos al iniciar";
	AL["Minimap Button"] = "Botón minimapa";
	AL["Show itemIDs"] = "Muestra los IDs";
	AL["Show Droprates"] = "Muestra indice aparición";
	AL["Safe Chat Links"] = "Enlaces seguros en el chat";
	AL["Comparison TT"] = "Comparaciones";
	AL["Show Comparison Tooltips"] = "Mostrar bocadillos comparar";
	AL["Opaque"] = "Opaco";
	AL["Make Loot Table Opaque"] = "Hacer opaca tabla botines";
	AL["Treat Crafted Items:"] = "Tratar objetos creados";
	AL["As Crafting Spells"] = "Como hechizos creados";
	AL["As Items"] = "Como objetos";
	AL["Reset"] = "Reiniciar";
	AL["Reset Frames"] = "Restaurar marcos";
	AL["Profiles"] = "Perfiles";
	AL["Item Buttons"] = "Botones de objetos";
	AL["Loot Table"] = "Tabla de botín";

	-- Default Frame
	AL["Default Frame"] = "Ventana predeterminada";
	AL["Scale:"] = "Escala";
	AL["Alpha:"] = "Transparencia";
	AL["Only change alpha on leave frame"] = "Solo cambia la transparencia de la ventana principal";

	-- Bindings
	AL["Toggle AtlasLoot"] = "Muestra/oculta AtlasLoot";

	--Help
	AL["Help"] = "Ayuda";
	AL["AtlasLoot Help"] = "Ayuda Atlasloot";
	AL["For further help, see our website and forums: "] = "Para mas ayuda consulta nuestra web y foros: ";
	AL["How to open the standalone Loot Browser:"] = "Como abrir el buscador de objetos estandar:";
	AL["If you have AtlasLootFu enabled, click the minimap button, or alternatively a button generated by a mod like Titan or FuBar.  Finally, you can type '/al' in the chat window."] = "Si tienes AtlasLootFu activado, haz click en el botón del minimapa, o alternativamente en algún botón generado por otro addon como Titan o FuBar.  Finalmente, puedes escribir '/al' en la ventana del chat.";
	AL["How to view an 'unsafe' item:"] = "Como ver un objeto 'no seguro':";
	AL["Unsafe items have a red border around the icon and are marked because you have not seen the item since the last patch or server restart. Right-click the item, then move your mouse back over the item or click the 'Query Server' button at the bottom of the loot page."] = "Los objetos no seguros tienen un borde rojo alrededor de su icono y son marcados porque no has visto dicho objeto en el juego desde el último parche o reinicio de servidor. Haz click-dcho en el objeto y después mueve el cursor por encima del icono o haz click en 'pregunta al servidor' en el pie de la ventana de botín.";
	AL["How to view an item in the Dressing Room:"] = "Como ver un objeto en la ventana del provador:";
	AL["Simply Ctrl+Left Click on the item.  Sometimes the dressing room window is hidden behind the Atlas or AtlasLoot windows, so if nothing seems to happen move your Atlas or AtlasLoot windows and see if anything is hidden."] = "Simplemente haz click Ctrl+Izdo en el objeto.  Algunas veces la ventana del provador está escondida detrás de las ventanas del Atlas o del Atlasloot por lo que si ves que no pasa nada, mueve tu ventana del Atlas y del Atlasloot.";
	AL["How to link an item to someone else:"] = "Como enlazar un objeto a otra persona:";
	AL["Shift+Left Click the item like you would for any other in-game item"] = "Haz lick Shift+izdo en el objeto como harías con cualquier otro objeto del juego";
	AL["How to add an item to the wishlist:"] = "Como añadir un objeto a la lista deseada:";
	AL["Alt+Left Click any item to add it to the wishlist."] = "Haz click Alt+izdo en el objeto que quieres añadir a la lista.";
	AL["How to delete an item from the wishlist:"] = "Como eliminar un objeto de la lista deseada:";
	AL["While on the wishlist screen, just Alt+Left Click on an item to delete it."] = "Mientras estás en la ventana de la lista deseada, solo tienes que hacer click Alt+izdo en el objeto a borrar.";
	AL["What else does the wishlist do?"] = "¿Que mas hace la lista deseada?";
	AL["If you Left Click any item on the wishlist, you can jump to the loot page the item comes from.  Also, on a loot page any item already in your wishlist is marked with a yellow star."] = "Si haces click izquierdo en un objeto de tu lista deseada, puedes saltar a la ventana de botín de donde proviene.  Del mismo modo, los objetos que se encuentran en tu lista aparecen marcados con una estrella amarilla.";
	AL["HELP!! I have broken the mod somehow!"] = "¡¡AYUDA!! De alguna manera he roto el addon";
	AL["Use the reset buttons available in the options menu, or type '/al reset' in your chat window."] = "Utiliza los botones de reinicio disponibles en el menú de opciones o escribe '/al reset' en tu ventana de chat.";

	-- LootButtons
	-- Tooltips
	AL["ItemID:"] = "ObjetoID:";
	AL["Drop Rate: "] = "Prob. de conseguirse: ";
	--AL["DKP"] = true;
	AL["Priority:"] = "Prioridad:";
	AL["Show price and slot if possible"] = "Muestra precio y hueco si es posible";
	AL["Use GameTooltip"] = "Utilizar ventanas del juego";
	AL["Use the standard GameTooltip instead of the custom AtlasLoot tooltip"] = "Utiliza las ventanas estandar del juego en lugar de las ventanas de AtlasLoot";
	-- Unsafe Item
	AL["Item Unavailable"] = "Objeto no disponible";
	AL["|cff0070ddItemID: %d |r\nThis item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world.\n\nYou can right-click to attempt to query the server.  You may be disconnected."] = "|cff0070ddItemID: %d |r\nEste objeto no es seguro.  Para ver este objeto sin riesgo de desconexión primero necesitas verlo en el mundo del juego.\n\nPuedes hacer click-derecho para intentar preguntar al servidor.  Es posible que te desconectes.";
	
	-- Heriloom Config Window
	AL["Heirloom preview"] = "Previsualización de reliquias";
	AL["Change level:"] = "Cambio de nivel:";
	AL["Shift + Right Click to select character level"] = "Shift + click dcho para seleccionar el nivel del personaje";	

	-- LootTableSort
	AL["Sort by Instance"] = "Ordenar por mazmorra";
	AL["Sort loottable by Instance"] = "Ordenar botín por mazmorra";
	AL["Sort by Boss"] = "Ordenar por jefe";
	AL["Sort loottable by Boss"] = "Ordenar botín por jefes";
	AL["Item Name"] = "Nombre del objeto";
	AL["Item Slot"] = "Hueco del objeto";
	AL["Item Quality"] = "Calidad del objeto";

	-- Wishlist 
	AL["Wishlist"] = "ListaDeseada";
	AL["Wishlists"] = "ListaDeseadas";
	AL["Own"] = "Propio";
	AL["Other"] = "Otro";
	AL["Shared"] = "Compartido";
	AL["Wishlist name:"] = "Nombre ListaDeseada:";
	AL["Delete"] = "Borrar";
	AL["Share"] = "Compartir";
	AL["Send Wishlist (%s) to"] = "Enviar ListaDeseada (%s) a";
	AL["Send"] = "Enviar";
	AL[" added to the WishList."] = " añadido a la lista de deseos.";
	AL[" already in the WishList!"] = " ya esta en la lista de deseos";
	AL[" deleted from the WishList."] = " borrado de la lista de deseos";
	AL["Are you sure you want to delete Wishlist |cff1eff00%s|r?"] = "¿Estas seguro de que quieres eliminar la lista deseada |cff1eff00%s|r?";
	AL["default"] = "Predeterminado";
	AL["Use as default wishlist"] = "Utilizar como lista deseada predeterminada";
	AL["Add Wishlist"] = "Añadir Lista Deseada";
	AL["Always use default Wishlist"] = "Utilizar lista predet.";
	AL["Save wishlists at character DB"] = "Guarda la lista deseada en la BD del personaje";
	AL["Saves the wishlists only for |cff1eff00%s-%s|r.\n Other characters cant view the wishlists, but the memory usage is reduced."] = "Guarda la lista deseada solo para |cff1eff00%s-%s|r.\n Los otros personajes no pueden ver estas lista deseadas, pero el uso de memoria se verá reducido.";
	AL["Table Sort"] = "Filtro de tabla";
	AL["Table Sort:"] = "Filtro de tabla:";
	AL["Item Sort:"] = "Filtro de objeto:";

	-- Filter
	AL["Filter"] = "Filtrar";
	AL["Select All Loot"] = "Seleccionar todo el botín";
	AL["Apply Filter:"] = "Aplicar filtro";
	AL["Melee weapons"] = "Armas CaC";
	AL["Ranged weapons"] = "Armas distancia";
	AL["Other"] = "Otro";
	AL["Itemslot"] = "Hueco del objeto";
	AL["Shift + Click on the Filter button opens the config page."] = "Shift + Click en el boton de Filtrar abre la página de configuración.";

	-- Panel
	AL["Hide Panel"] = "Oculta el panel";
	AL["Toggle AL Panel"] = "Panel AtlasLoot";
	AL["Buttons"] = "Botones";

	-- Buttons
	AL["Collections"] = "Colecciones";
	AL["Crafting"] = "Fabricados";
	AL["Factions"] = "Facciones";
	AL["Load Modules"] = "Cargar módulos";
	AL["PvP Rewards"] = "Recompensas JcJ";
	AL["World Events"] = "Eventos mundo";

	-- QuickLooks
	AL["QuickLook"] = "VistaRapida"
	AL["QuickLooks"] = "VistasRapidas";
	AL["Number of QuickLooks:"] = "Número de VistasRapidas";
	AL["Add to QuickLooks:"] = "Añade a VistaRápida";
	AL["Reset Quicklooks"] = "Res. BotínRápido";
	AL["Assign this loot table\n to QuickLook"] = "Asignar esta tabla\n a VistaRapida";
	AL["Show unused QuickLooks in the Panel"] = "Muestra VistasRapidas sin utilizar en el Panel";
	AL["Shows unused QuickLooks as grey buttons in the AtlasLoot Panel"] = "Muestra las VistasRapidas sin utilizar como botones grises en el panel de AtlasLoot";
	-- Single options
	AL["unused"] = "sin usar";
	AL["QuickLook name:"] = "Nombre VistaRapida:";
	AL["Use Boss name"] = "Usa nombre del jefe";
	AL["Use Instance name"] = "Usa nombre de la mazmorra";
	AL["Delete"] = "Borrar";
	AL["Lock"] = "Bloquear";
	AL["Enable"] = "Activo";

	-- Query Server / Query all
	AL["Query Server"] = "Pregun. Servidor";
	AL["Queries the server for all items\non this page. The items will be \nrefreshed when you next mouse \nover them."] = "Pregunta al servidor por todos los objectos \nde esta página, Los objectos serán \nrefrescados al pasar el ratón \nsobre ellos";

	-- Atlas
	AL["Click boss name to view loot."] = "Haz click sobre el nombre del jefe para ver el botín.";

	-- LootTable
	-- title
	AL["Heroic"] = "Heróico";
	AL["25 Man"] = "25 personas";
	AL["25 Man Heroic"] = "25 personas heroica";
	-- buttons
	AL["Show 10 Man Loot"] = "Muestra 10 Pers. Botín";
	AL["Show 25 Man Loot"] = "Muestra 25 Pers. Botín";
	AL["Show Slot"] = "Muestra hueco";
	AL["Show Price"] = "Muestra precio";
	AL["Skill"] = "Habilidad";
	AL["Location"] = "Posición";

	-- #######################################
	-- UI things END
	-- #######################################

	--Text strings for UI objects
	--AL["AtlasLoot"] = true;
	AL["Select Loot Table"] = "Selecciona tabla";
	AL["Select Sub-Table"] = "Selecciona subtabla";
	AL["Various Locations"] = "Se obtiene en diferentes sitios";
	AL["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "Esto es tan solo un buscador de objetos. Para ver el mapa instala el Atlas o Alphamap";
	AL["Back"] = "Atrás";
	AL["Level 60"] = "Nivel 60";
	AL["Level 70"] = "Nivel 70";
	AL["Level 80"] = "Nivel 80";
	AL["Level 85"] = "Nivel 85";
	AL["|cffff0000(unsafe)"] = " |cffff0000(no seguro)";
	AL["Misc"] = "Misc.";
	AL["Rewards"] = "Recompensas";
	AL["Choose Table ..."] = "Elige una tabla...";
	AL["Unknown"] = "Desconocido";
	AL["Reset Wishlist"] = "Res. ListaDeseada";
	AL["Select a Loot Table..."] = "Elige una tabla de Botín...";
	AL["OR"] = "O";
	AL["FuBar Options"] = "Opciones FuBar";
	AL["Attach to Minimap"] = "Sujetar al minimapa";
	AL["Hide FuBar Plugin"] = "Esconder FuBar Plugin";
	AL["Show FuBar Plugin"] = "Mostrar FuBar Plugin"; 
	AL["Position:"] = "Posición:";
	AL["Left"] = "Izquierda";
	AL["Center"] = "Centro";
	AL["Right"] = "Derecha";
	AL["Hide Text"] = "Esconder Texto";
	AL["Hide Icon"] = "Esconder Icono";
	AL["Minimap Button Options"] = "Opciones botón minimapa";

	--Text for Options Panel
	AL["Atlasloot Options"] = "Opciones Atlasloot";
	AL["Default Tooltips"] = "Bocadillos texto predet.";
	AL["Lootlink Tooltips"] = "Bocadillos enlaces";
	AL["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dBocadillos enlaces";
	AL["ItemSync Tooltips"] = "Bocadillos de sincronismo";
	AL["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dBocadillos de sincronismo";
	AL["Use EquipCompare"] = "Utilizar EquipCompare";
	AL["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9dUtilizar EquipCompare";
	AL["Show itemIDs at all times"] = "Mostrar el ID objetos";
	AL["Hide AtlasLoot Panel"] = "Esconder panel de AtlasLoot";
	AL["Show Basic Minimap Button"] = "Mostrar botón básico en el mini mapa";
	AL["|cff9d9d9dShow Basic Minimap Button|r"] = "|cff9d9d9dMostrar botón de Minimapa básico|r";
	AL["Set Minimap Button Position"] = "Elegir la posición del botón del mini mapa";
	AL["Notify on LoD Module Load"] = "Notificar al cargar un módulo";
	AL["Loot Browser Scale: "] = "Escala del buscador: ";
	AL["Button Position: "] = "Posición del botón";
	AL["Button Radius: "] = "Radio del botón";
	AL["Done"] = "Hecho";
	AL["FuBar Toggle"] = "Conmutar FuBar";
	AL["Search Result: %s"] = "Buscar resultado: %s";
	AL["Search on"] = "Buscar en";
	AL["All modules"] = "Todos los módulos";
	AL["If checked, AtlasLoot will load and search across all the modules."] = "Si lo marcas, AtlasLoot lo cargará y buscará por todos los módulos.";
	AL["Search options"] = "Buscar opciones";
	AL["Partial matching"] = "Coincidencia parcial";
	AL["If checked, AtlasLoot search item names for a partial match."] = "Si lo marcas, AtlasLoot buscará el nombre de los objetos con una coincidencia parcial.";
	AL["You don't have any module selected to search on!"] = "¡No tienes marcado ningún módulo donde buscar!";
	--AL["Panel"] = true;

	--Slash commands
	AL["reset"] = "Reiniciar";
	AL["options"] = "Opciones";
	AL["Reset complete!"] = "¡Se ha reiniciado!";

	-- AtlasLoot Panel - Search
	AL["Clear"] = "Limpiar";
	AL["Last Result"] = "Último resultado";
	AL["Search"] = "Buscar";

	-- Crafting Menu
	AL["Crafting Daily Quests"] = "Fabricados misiones diarias";
	AL["Cooking Daily"] = "Cocina diaria";
	AL["Fishing Daily"] = "Pesca diaria";	
	AL["Jewelcrafting Daily"] = "Joyería diaria";
	AL["Crafted Sets"] = "Conjuntos fabricados";
	AL["Crafted Epic Weapons"] = "Armas épicas fabricadas";
	AL["Dragon's Eye"] = "Ojo de dragón";
	--AL["Chimera's Eye"] = true;

	-- Sets/Collections Menu
	--AL["Sets"] = true;
	AL["Set"] = "Conjunto";
	AL["Justice Points"] = "Puntos de justicia";
	AL["Valor Points"] = "Puntos de valor";
	AL["BoE World Epics"] = "Épicos del mundo BoE";
	AL["Legendary Items"] = "Objetos legendários";
	AL["Misc Sets"] = "Conjuntos varios";
	AL["Tier 1/2 Set"] = "Conjunto 1/2";
	AL["Tier 1/2/3 Set"] = "Conjunto 1/2/3";
	AL["Tier 3 Set"] = "Conjunto 3";
	AL["Tier 4/5/6 Set"] = "Conjunto 4/5/6";
	AL["Tier 7/8 Set"] = "Conjunto 7/8";
	AL["Tier 9 Set"] = "Conjunto 9";
	AL["Tier 10 Set"] = "Conjunto 10";
	AL["TCG Items"] = "Objetos TCG"; -- Trading Card Game Items
	AL["Transformation Items"] = "Objetos de transformación";

	-- PvP Menu
	AL["Arathi Basin Sets"] = "Conjuntos de Cuenca de Arathi";
	AL["PvP Accessories"] = "Accesorios JcJ";
	AL["PvP Armor Sets"] = "Conjuntos de armaduras JcJ";
	AL["PvP Weapons"] = "Armas JcJ";
	AL["PvP Non-Set Epics"] = "Épicos JcJ No-Conjuntos";
	AL["PvP Reputation Sets"] = "Conjuntos JcJ por reputación"
	AL["PvP Misc"] = "Diseños Joyería JcJ";
	AL["PVP Gems/Enchants/Jewelcrafting Designs"] = "Diseños Gemas/Encantamientos/Joyería JcJ";

	-- World Events
	AL["Abyssal Council"] = "Consejo abisal";
	AL["Argent Tournament"] = "Torneo Argenta";
	AL["Bash'ir Landing Skyguard Raid"] = "Punto de anclaje de Bash'ir";
	AL["Brewfest"] = "Fiesta de la Cerveza";
	AL["Children's Week"] = "Semana de los niños";
	AL["Day of the Dead"] = "Festividad de los Muertos";
	AL["Ethereum Prison"] = "Prisión de los Etereum";
	AL["Feast of Winter Veil"] = "Festival de Invierno";
	AL["Gurubashi Arena Booty Run"] = "El cofre pirata de Gurubashi";
	AL["Hallow's End"] = "Halloween";
	AL["Harvest Festival"] = "Festival de la Cosecha";
	AL["Love is in the Air"] = "Amor en el aire";
	AL["Lunar Festival"] = "Festival Lunar";
	AL["Midsummer Fire Festival"] = "Festival del Solsticio de Verano";
	AL["Noblegarden"] = "El jardín de los nobles";
	AL["Pilgrim's Bounty"] = "Generosidad del Peregrino";
	AL["Skettis"] = "Skettis";
	AL["Stranglethorn Fishing Extravaganza"] = "Concurso de Pesca";

	--Minimap Button
	AL["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00Click-izdo|r Navegar por las tablas de botines";
	AL["|cffff0000Right-Click|r View Options"] = "|cffff0000Click-dcho|r Ver opciones";
	AL["|cffff0000Shift-Click|r View Options"] = "|cffff0000Shift-Click|r Ver opciones";
	AL["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccClick-izdo + arrastrar|r Mueve el botón del mini mapa";
	AL["|cffccccccRight-Click + Drag|r Move Minimap Button"] = "|cffccccccClick-dcho + arrastrar|r Mueve el botón del mini mapa";

	-- Default Frame
	AL["Select Module"] = "Selecciona módulo";
	AL["Select Instance"] = "Selecciona mazmorra";

	-- Wishlist
	AL["Close"] = "Cerrar";
	AL["Own Wishlists"] = "ListasDeseadas propias";
	AL["Other Wishlists"] = "Otras ListasDeseadas";
	AL["Shared Wishlists"] = "ListasDeseadas compartidas";
	AL["Mark items in loot tables"] = "Marcas objetos en las tablas";
	AL["Mark items from own Wishlist"] = "Marcar objetos de lista propia";
	AL["Mark items from all Wishlists"] = "Marcar objetos de todas";
	AL["Enable Wishlist Sharing"] = "Activar compartir";
	AL["Auto reject in combat"] = "Auto rechazar en combate";
	AL["Edit Wishlist"] = "Editar ListasDeseada";
	AL["Show More Icons"] = "Mostrar mas iconos";
	AL["Edit"] = "Editar";
	AL["Show all Wishlists"] = "Mostrar todas";
	AL["Show own Wishlists"] = "Mostrar todas las propias";
	AL["Show shared Wishlists"] = "Mostrar todas las compartidas";
	AL["You must wait "] = "Tienes que esperar ";
	AL[" seconds before you can send a new Wishlist to "] = " unos segundos antes de poder enviar la ListaDeseada a ";
	AL["Cancel"] = "Cancelar";
	AL["Delete Wishlist %s?"] = "¿Borrar ListaDeseada %s?";
	AL["%s sends you a Wishlist. Accept?"] = "%s te esta enviando una ListaDeseada. ¿Aceptar?";
	AL[" tried to send you a Wishlist. Rejected because you are in combat."] = " intentó enviarte una ListaDeseada. Se rechazó porque estabas en combate.";
	AL[" rejects your Wishlist."] = " rechazada tu ListaDeseada.";
	AL["You can't send Wishlists to yourself"] = "No puedes enviarte ListasDeseadas a ti mismo";
	AL["Please set a default Wishlist."] = "Por favor, elige una ListaDeseada como predeterminada.";
	AL["Set as default Wishlist"] = "Elegir ListaDeseada como predeterminada.";

	--Misc Inventory related words
	AL["Scope"] = "Mira";
	AL["Darkmoon Faire Card"] = "Carta de la Feria de la Luna";
	AL["Banner"] = "Estandarte";
	AL["Set"] = "Conjunto";
	AL["Token"] = "Insignia";
	AL["Combat Pet"] = "Mascota de combate"; --Comprobar
	AL["Fireworks"] = "Fuegos artificiales";
	AL["Transformation Item"] = "Objeto de transformación";
	AL["Keys"] = "Llaves";

	--Extra inventory stuff
	AL["Cloak"] = "Capa";

	--Alchemy
	AL["Battle Elixirs"] = "Elixires de Batalla";
	AL["Guardian Elixirs"] = "Elixires de Guardián";
	AL["Potions"] = "Pociones";
	AL["Transmutes"] = "Transmutaciones";
	AL["Flasks"] = "Frascos";

	-- Blacksmithing
	AL["Cataclysm Vendor Sold Plans"] = "Vendedor de planes de Cataclysm";
	
	--Enchanting
	AL["Enchant Boots"] = "Encantamiento Botas";
	AL["Enchant Bracer"] = "Encantamiento Brazalete";
	AL["Enchant Chest"] = "Encantamiento Pecho";
	AL["Enchant Cloak"] = "Encantamiento Capa";
	AL["Enchant Gloves"] = "Encantamiento Guantes";
	AL["Enchant Ring"] = "Encantamiento Anillo";
	AL["Enchant Shield"] = "Encantamiento Escudo";
	AL["Enchant 2H Weapon"] = "Encantamiento Arma 2 Manos";
	AL["Enchant Weapon"] = "Encantamiento Arma";
	AL["Cataclysm Vendor Sold Formulas"] = "Vendedor de fórmulas de Cataclysm";

	--Inscription
	AL["Major Glyph"] = "Glifos Sublimes";
	AL["Minor Glyph"] = "Glifos Menores";
	AL["Scrolls"] = "Pergaminos";
	AL["Off-Hand Items"] = "Objetos de mano-izda";
	AL["Reagents"] = "Consumibles";
	AL["Book of Glyph Mastery"] = "Libro sobre maestría en glifos";

	--Leatherworking
	AL["Leather Armor"] = "Armaduras de cuero";
	AL["Mail Armor"] = "Armaduras de malla";
	AL["Cloaks"] = "Capas";
	AL["Item Enhancements"] = "Objetos de Mejora";
	AL["Drums, Bags and Misc."] = "Tambores, Bolsas y Misc.";

	--Tailoring
	AL["Cloth Armor"] = "Armadura de tela";
	AL["Shirts"] = "Camisas";
	AL["Bags"] = "Bolsas";

	--Labels for loot descriptions
	AL["Classes:"] = "Clases";
	AL["This Item Begins a Quest"] = "Este objeto empieza una misión";
	AL["Quest Item"] = "Objeto de misión";
	AL["Old Quest Item"] = "Objetos viejos de misiones";
	AL["Quest Reward"] = "Recompensa de misión";
	AL["Old Quest Reward"] = "Recompensas viejas de misiones";
	AL["Shared"] = "Compartido";
	AL["Right Half"] = "Parte derecha";
	AL["Left Half"] = "Parte izquierda";
	AL["Currency"] = "Utiliza recompensas para comprarlo";
	AL["Used to summon boss"] = "Utilizados para invocar jefe";
	AL["Tradable for sunmote + item above"] = "Intercambiable";
	AL["Card Game Item"] = "Juego de cartas";
	AL["Skill Required:"] = "Requerida habilidad:";
	AL["Rating:"] = "Indice:"; -- Shorthand for 'Required Rating' for the personal/team ratings
	--AL["Random Heroic Reward"] = true;
	--AL["Fishing Daily Reward"] = true;
	--AL["Collector's Edition"] = true;
	--AL["Daily Reward"] = true;

	-- Minor Labels for loot table descriptions
	--AL["Classic WoW"] = true;
	--AL["Burning Crusade"] = true;
	--AL["Wrath of the Lich King"] = true;
	--AL["Cataclysm"] = true;
	AL["Entrance"] = "Entrada";
	AL["Dungeon Set 1"] = "Conjunto de Mazmorra 1";
	AL["Dungeon Set 2"] = "Conjunto de Mazmorra 2";
	AL["Dungeon Set 1/2"] = "Conjunto de Mazmorra 1/2";
	AL["Dungeon Set 3"] = "Conjunto de Mazmorra 3";	
	AL["Tier 1"] = "Conjunto T1";
	AL["Tier 2"] = "Conjunto T2";
	AL["Tier 3"] = "Conjunto T3";
	AL["Tier 4"] = "Conjunto T4";
	AL["Tier 5"] = "Conjunto T5";
	AL["Tier 6"] = "Conjunto T6";
	AL["Tier 7"] = "Conjunto T7";
	AL["Tier 8"] = "Conjunto T8";
	AL["Tier 9"] = "Conjunto T9";
	AL["Tier 10"] = "Conjunto T10";
	AL["Tier 11"] = "Conjunto T11";
	AL["10 Man"] = "10 personas";
	AL["10/25 Man"] = "10/25 Personas";
	AL["Epic Set"] = "Conjunto épico";
	AL["Rare Set"] = "Conjunto superior";
	AL["Season 9"] = "Temporada 9";
	AL["Season 10"] = "Temporada 10";
	AL["Season 11"] = "Temporada 11";
	AL["Fire"] = "Fuego";
	AL["Water"] = "Agua";
	AL["Wind"] = "Aire";
	AL["Earth"] = "Tierra";
	AL["Master Angler"] = "Maestro pescador";
	AL["Fire Resistance Gear"] = "Equipamientos con resistencia al fuego";
	AL["Arcane Resistance Gear"] = "Equipamientos con resistencia a lo arcano";
	AL["Nature Resistance Gear"] = "Equipamientos con resistencia a la naturaleza";
	AL["Frost Resistance Gear"] = "Equipamientos con resistencia al hielo";
	AL["Shadow Resistance Gear"] = "Equipamientos con resistencia a las sombras";

	-- Labels for loot table sections
	AL["Additional Heroic Loot"] = "Botin heróico adicional";
	AL["Heroic Mode"] = "Modo heróico";
	AL["Normal Mode"] = "Modo normal";
	AL["Raid"] = "Banda";
	AL["Hard Mode"] = "Modo dificil";
	AL["Bonus Loot"] = "Botín bonus";
	AL["Arena Reward"] = "Recompensas de arena";
	AL["Achievement Reward"] = "Recompensa logro";
	AL["Phase 1"] = "Fase 1";
	AL["Phase 2"] = "Fase 2";
	AL["Phase 3"] = "Fase 3";
	AL["First Prize"] = "Primer precio";
	AL["Rare Fish Rewards"] = "Recompensas superiores pesca";
	AL["Rare Fish"] = "Pescado superior";
	AL["Heirloom"] = "Reliquia";
	AL["Weapons"] = "Armas";
	AL["Accessories"] = "Accesorios";
	AL["Rare"] = "Raras";

	-- Loot Table Names
	AL["Level 30-39"] = "Niveles 30-39";
	AL["Level 40-49"] = "Niveles 40-49";
	AL["Level 50-60"] = "Niveles 50-60";
	AL["Summon"] = "Invocar";
	AL["Random"] = "Aleatorio";
	AL["Brew of the Month Club"] = "Club de la Cerveza del Mes";

	-- Cooking descriptions
	AL["Buff"] = "Ventaja";
	AL["Agility"] = "Agilidad";
	AL["Intellect"] = "Intelecto";
	AL["Strength"] = "Fuerza";
	AL["Agility, Intellect, Strength"] = "Agilidad, Intelecto, Fuerza";
	AL["Spell Power"] = "Poder con hechizos";
	AL["Attack Power"] = "Poder de ataque";
	AL["Spell/Attack Power"] = "Poder de ataque/hechizos";
	AL["Hit Rating"] = "Índice de golpe";
	AL["Crit Rating"] = "Índice de crítico";
	AL["Crit/Hit Rating"] = "Índice de golpe/crítico";
	AL["Haste Rating"] = "Índice de celeridad";
	AL["Dodge Rating"] = "Índice de esquivar";
	AL["Expertise Rating"] = "Índice de pericia";
	AL["Mastery Rating"] = "Índice de maestría";
	AL["Parry Rating"] = "Índice de parada";
	AL["Other Ratings"] = "Otros índices";
	AL["Resistance"] = "Resistencia";
	AL["Health / Second"] = "Vida / Segundo";
	AL["Mana / Second"] = "Maná / Segundo";
	AL["Tracking"] = "Rastreo";
	AL["Emotions"] = "Emociones";
	--AL["Alcohol"] = true;
	AL["Health"] = "Vida";
	AL["Mana"] = "Maná";
	AL["Health and Mana"] = "Vida y maná";
	AL["Other Buffs"] = "Otras ventajas";
	AL["Standard Buffs"] = "Ventajas estandar";
	AL["Food without Buffs"] = "Comida sin ventajas";
	AL["Special"] = "Especial";
	AL["Feasts"] = "Festividades";

	-- Extra Text in Boss lists
	AL["AQ20 Class Sets"] = "Conjuntos por Clase de AQ20";
	AL["AQ Enchants"] = "Encantamientos AQ";
	AL["AQ40 Class Sets"] = "Conjuntos por Clase de AQ40";
	AL["AQ Opening Quest Chain"] = "Apertura de la misión de la cadena AQ";
	AL["Tribute Run"] = "Homenaje de carrera";
	AL["Dire Maul Books"] = "Libros de La Masacre";
	AL["Random Boss Loot"] = "Botín de jefes aleatorios";
	AL["BT Patterns/Plans"] = "Recetas/Planos del Templo Oscuro";
	AL["Hyjal Summit Designs"] = "Diseños de la Cumbre de Hyjal";
	AL["SP Patterns/Plans"] = "Recinto de Esclavos Recetas/Planos";
	AL["Ulduar Formula/Patterns/Plans"] = "Formulas/patrones/planos Ulduar";
	AL["Trial of the Crusader Patterns/Plans"] = "Patrones/planos Prueba del Cruzado";
	AL["BRD Blacksmithing Plans"] = "Planos de herrero BRD";
	-- General titles
	AL["Achievement"] = "Logro";
	AL["Promotional & Card Game"] = "Cartas del juego promocionales";

	-- Companions
	AL["Achievement"] = "Logro";
	AL["Achievement & Faction Reward Companions"] = "Mascotas de recompensa por logro y facción";
	AL["Card Game Companions"] = "Mascotas por cartas del juego";
	AL["Companion Accessories"] = "Accesorios para mascotas";
	AL["Crafted Companions"] = "Mascotas creadas";
	AL["Dungeon/Raid"] = "Mazmorra/Banda";
	AL["Faction"] = "Facción";
	AL["Merchant Sold Companions"] = "Mascotas vendidas por mercaderes";
	AL["Pets"] = "Mascotas";
	AL["Promotional Companions"] = "Mascotas promocionales";
	AL["Quest Reward Companions"] = "Mascotas por recompensa de misión";
	AL["Rare Companions"] = "Mascotas raras";
	AL["Unobtainable Companions"] = "Mascotas inconseguibles";

	-- Mounts
	AL["Alliance Flying Mounts"] = "Monturas voladoras Alianza";
	AL["Alliance Mounts"] = "Monturas Alianza";
	AL["Horde Flying Mounts"] = "Monturas voladoras Horda";
	AL["Horde Mounts"] = "Monturas Horda";
	AL["Card Game Mounts"] = "Monturas juegos de cartas";
	AL["Crafted Mounts"] = "Monturas fabricadas";
	AL["Event Mounts"] = "Monturas eventos";
	AL["Neutral Faction Mounts"] = "Monturas facciones neutrales";
	AL["PvP Mounts"] = "Monturas JcJ";
	AL["Alliance PvP Mounts"] = "Monturas JcJ Alianza";
	AL["Horde PvP Mounts"] = "Monturas JcJ Horda";
	AL["Halaa PvP Mounts"] = "Monturas JcJ Halaa";
	AL["Promotional Mounts"] = "Monturas promocionales"
	AL["Rare Mounts"] = "Monturas raras"
	AL["Unobtainable Mounts"] = "Monturas inconseguibles";

	-- Tabards
	AL["Achievement & Quest Reward Tabards"] = "Tabardos de recompensa de misión y logro";
	AL["Alliance Tabards"] = "Tabardos de la Alianza";
	AL["Card Game Tabards"] = "Tabardos de cartas del juego";
	AL["Horde Tabards"] = "Tabardos de la Horda";
	AL["PvP Tabards"] = "Tabardos JcJ";
	AL["Unobtainable Tabards"] = "Tabardos inconseguibles";

	--Darkmoon Faire
	AL["Darkmoon Faire Rewards"] = "Recompensas Feria de la Luna Negra";
	AL["Low Level Decks"] = "Bajaras de bajo nivel";
	AL["Level 60 Trinkets"] = "Abaloríos nivel 60";
	AL["Level 70 Trinkets"] = "Abaloríos nivel 70";
	AL["Level 60 & 70 Trinkets"] = "Abaloríos nivel 60 y 70";
	AL["Level 80 Trinkets"] = "Abaloríos nivel 80";
	AL["Level 85 Trinkets"] = "Abaloríos nivel 85";

	--Card Game Decks and descriptions
	AL["Loot Card Items"] = "Objetos (juegos de cartas)";
	AL["UDE Items"] = "Objetos (puntos UDE)";

	-- First set
	AL["Heroes of Azeroth"] = "Heroes de Azeroth";
	AL["Landro Longshot"] = "Landro Tirolargo";
	AL["Thunderhead Hippogryph"] = "Hipogrifo Tronatesta";
	AL["Saltwater Snapjaw"] = "Quijaforte marino";

	-- Second set
	AL["Through The Dark Portal"] = "A través del Portal Oscuro";
	AL["King Mukla"] = "Rey Mukla";
	AL["Rest and Relaxation"] = "Descanso y relajación";
	AL["Fortune Telling"] = "La buena aventura"; --Comprobar

	-- Third set
	AL["Fires of Outland"] = "Fuegos de Terrallende";
	AL["Spectral Tiger"] = "Tigre espectral";
	AL["Gone Fishin'"] = "Se fué pescando"; --Comprobar
	AL["Goblin Gumbo"] = "Potaje goblin";

	-- Fourth set
	AL["March of the Legion"] = "Marca de la Legión";
	--AL["Kiting"] = true, FALTA
	--AL["Robotic Homing Chicken"] = true, FALTA
	AL["Paper Airplane"] = "Avión de papel"

	-- Fifth set
	AL["Servants of the Betrayer"] = "Sirvientes del Traidor";
	AL["X-51 Nether-Rocket"] = "Cohete abisal X-51";
	AL["Personal Weather Machine"] = "Máquina del tiempo personal";
	AL["Papa Hummel's Old-fashioned Pet Biscuit"] = "Galleta de mascota retro de papá Hummel"

	-- Sixth set
	AL["Hunt for Illidan"] = "Caza de Illidan"; 
	AL["The Footsteps of Illidan"] = "Las huellas de Illidan"; 
	--AL["Disco Inferno!"] = true, FALTA
	AL["Ethereal Plunderer"] = "Desvalijador etéreo";

	-- Seventh set
	AL["Drums of War"] = "Tambores de guerra";
	--AL["The Red Bearon"] = "The Red Bearon"; --FALTA
	--AL["Owned!"] = true, --FALTA
	--AL["Slashdance"] = true, --FALTA

	-- Eighth set
	AL["Blood of Gladiators"] = "Sangre de Gladiadores";
	AL["Sandbox Tiger"] = "Tigre Balancín";
	AL["Center of Attention"] = "Centro de atención"; --Check
	AL["Foam Sword Rack"] = "Espada de gomaespuma";

	-- Ninth set
	--AL["Fields of Honor"] = true;
	--AL["Path of Cenarius"] = true;
	--AL["Pinata"] = true;
	--AL["El Pollo Grande"] = true;

	-- Tenth set
	AL["Scourgewar"] = "Guerra de la Plaga"; --Check
	AL["Tiny"] = "Pequeño";
	AL["Tuskarr Kite"] = "Cometa colmillarr";
	AL["Spectral Kitten"] = "Gatito espectral"; --Check

	-- Eleventh set
	AL["Wrathgate"] = "Puerta de Cólera";
	--AL["Statue Generator"] = true;
	AL["Landro's Gift"] = "Regalo de Landro";
	AL["Blazing Hippogryph"] = "Hipogrifo llameante";

	-- Twelvth set
	AL["Icecrown"] = "Corona de Hielo";
	AL["Wooly White Rhino"] = "Rinoceronte blanco lanudo";
	AL["Ethereal Portal"] = "Portal etéreo";
	AL["Paint Bomb"] = "Bomba de pintura";

	-- Thirtheenth set
	AL["Worldbreaker"] = "Rompemundos";

	--Battleground Brackets
	AL["Old PvP Rewards"] = "Recompensas JcJ antiguas";
	AL["BG/Open PvP Rewards"] = "Recompensas JcJ Arena/CB";
	AL["Misc. Rewards"] = "Recompensas varias";
	AL["Level 10-19 Rewards"] = "Recompensas de niveles 10-19";
	AL["Level 20-39 Rewards"] = "Recompensas de niveles 20-39";
	AL["Level 20-29 Rewards"] = "Recompensas de niveles 20-29";
	AL["Level 30-39 Rewards"] = "Recompensas de niveles 30-39";
	AL["Level 40-49 Rewards"] = "Recompensas de niveles 40-49";
	AL["Level 50-59 Rewards"] = "Recompensas de niveles 50-59";
	AL["Level 60 Rewards"] = "Recompensas de nivel 60";

	--Brood of Nozdormu Paths
	AL["Path of the Conqueror"] = "El camino del conquistador";
	AL["Path of the Invoker"] = "El camino del invocador";
	AL["Path of the Protector"] = "El camino del protector";

	--Violet Eye Paths
	AL["Path of the Violet Protector"] = "El camino del protector violeta";
	AL["Path of the Violet Mage"] = "El camino del mago violeta";
	AL["Path of the Violet Assassin"] = "El camino del asesino violeta";
	AL["Path of the Violet Restorer"] = "El camino del restaurador violeta";

	-- Ashen Verdict Paths
	AL["Path of Courage"] = "El camino del coraje";
	AL["Path of Destruction"] = "El camino de la destrucción";
	AL["Path of Vengeance"] = "El camino de la venganza";
	AL["Path of Wisdom"] = "El camino de la sabiduría";

	--AQ Opening Event
	AL["Red Scepter Shard"] = "Fragmento de cetro rojo";
	AL["Blue Scepter Shard"] = "Fragmento de cetro azul";
	AL["Green Scepter Shard"] = "Fragmento de cetro verde";
	AL["Scepter of the Shifting Sands"] = "El cetro del Mar de Dunas";

	--World PvP
	AL["Hellfire Fortifications"] = "Fortificaciones de la Península de fuego";
	AL["Twin Spire Ruins"] = "Ruinas de las Agujas Gemelas";
	AL["Spirit Towers"] = "Torres de los espíritus";
	--AL["Halaa"] = true,
	AL["Venture Bay"] = "Bahía Aventura"; --Check

	--Karazhan Opera Event Headings
	AL["Wizard of Oz"] = "El mago de Oz";
	AL["Red Riding Hood"] = "Caperucita roja";

	--Karazhan Animal Boss Types
	AL["Spider"] = "Araña";
	AL["Darkhound"] = "Can oscuro";
	AL["Bat"] = "Murciélago";

	-- AQ20 Tokens
	AL["Qiraji Ornate Hilt"] = "Empuñadura qiraji ornamentada";
	AL["Qiraji Martial Drape"] = "Mantón qiraji marcial";
	AL["Qiraji Magisterial Ring"] = "Anillo qiraji magistral";
	AL["Qiraji Ceremonial Ring"] = "Anillo ceremonial qiraji";
	AL["Qiraji Regal Drape"] = "Mantón qiraji real";
	AL["Qiraji Spiked Hilt"] = "Puño con pinchos qiraji";

	--AQ40 Tokens
	AL["Qiraji Bindings of Dominance"] = "Ataduras de dominio Qiraji";
	AL["Qiraji Bindings of Command"] = "Ataduras de mando Qiraji";
	AL["Vek'nilash's Circlet"] = "Aro de Vek'nilash";
	AL["Vek'lor's Diadem"] = "Diadema de Vek'lor";
	AL["Ouro's Intact Hide"] = "Pellejo intacto de Ouro";
	AL["Skin of the Great Sandworm"] = "Piel del Gran gusano de arena";
	AL["Husk of the Old God"] = "Colmillo del dios antiguo";
	AL["Carapace of the Old God"] = "Caparazón del dios antiguo";

	--Recipe origin strings
	AL["Trainer"] = "Instructor";
	AL["Discovery"] = "Descubierto";
	AL["World Drop"] = "Botín del Mundo";
	AL["Drop"] = "Botín"; 
	AL["Vendor"] = "Vendedor";
	AL["Crafted"] = "Fabricado";

	-- Months
	AL["January"] = "Enero";
	AL["February"] = "Febrero";
	AL["March"] = "Marzo";
	AL["April"] = "Abril";
	AL["May"] = "Mayo";
	AL["June"] = "Junio";
	AL["July"] = "Julio";
	AL["August"] = "Agosto";
	AL["September"] = "Septiembre";
	AL["October"] = "Octubre";
	AL["November"] = "Noviembre";
	AL["December"] = "Diciembre";

	--Specs
	AL["Balance"] = "Equilibrio";
	AL["Feral"] = "Combate Feral";
	AL["Restoration"] = "Restauración";
	AL["Holy"] = "Sagrado";
	AL["Discipline"] = "Disciplina";
	AL["Protection"] = "Protección";
	AL["Retribution"] = "Reprensión";
	AL["Shadow"] = "Sombras";
	--AL["Elemental"] = true,
	AL["Enhancement"] = "Mejora";
	AL["Fury"] = "Furia";
	AL["Demonology"] = "Demonología";
	AL["Destruction"] = "Destrucción";
	AL["Tanking"] = "Tanque";
	--AL["DPS"] = true,

	--Naxx Zones
	AL["Construct Quarter"] = "El Arrabal de los Ensamblajes";
	AL["Arachnid Quarter"] = "El Arrabal Arácnido";
	AL["Military Quarter"] = "El Arrabal Militar";
	AL["Plague Quarter"] = "El Arrabal de la Plaga";
	AL["Frostwyrm Lair"] = "Guarida Helada";

	--NPCs missing from BabbleBoss
	AL["Trash Mobs"] = "Bichos varios";
	AL["Dungeon Set 2 Summonable"] = "Invocación Conjunto de mazmorra 2";
	--AL["Theldren"] = true,
	AL["Sothos and Jarien"] = "Sothos y Jarien";
	AL["Druid of the Fang"] = "Druida del Colmillo";
	AL["Defias Strip Miner"] = "Cantero Defias";
	AL["Defias Overseer/Taskmaster"] = "Sobrestante/Capataz Defias";
	AL["Scarlet Defender/Myrmidon"] = "Defensor/Mirmidón Escarlata";
	AL["Scarlet Champion"] = "Campeón Escarlata";
	AL["Scarlet Centurion"] = "Centurión Escarlata";
	AL["Scarlet Trainee"] = "Practicante Escarlata";
	--AL["Herod/Mograine"] = true,
	AL["Scarlet Protector/Guardsman"] = "Protector/Custodio Escarlata";
	AL["Shadowforge Flame Keeper"] = "Vigilante de la Llama Forjatiniebla";
	AL["Avatar of the Martyred"] = "Avatar de los Martirizados";
	AL["Nexus Stalker"] = "Acechador nexo";
	AL["Auchenai Monk"] = "Monje Auchenai";
	AL["Cabal Fanatic"] = "Fanático de la Cábala";
	AL["Unchained Doombringer"] = "Fatídico desencadenado";
	AL["Crimson Sorcerer"] = "Hechicero Carmesí";
	AL["Thuzadin Shadowcaster"] = "Taumaturgo oscuro Thuzadin";
	AL["Crimson Inquisitor"] = "Inquisidor Carmesí";
	AL["Crimson Battle Mage"] = "Mago de batalla Carmesí";
	AL["Ghoul Ravener"] = "Cuervoso necrófago";
	AL["Spectral Citizen"] = "Ciudadano espectral";
	AL["Spectral Researcher"] = "Investigador espectral";
	AL["Scholomance Adept"] = "Adepto de Scholomance";
	AL["Scholomance Dark Summoner"] = "Invocador Oscuro de Scholomance";
	AL["Blackhand Elite"] = "Élite Puño Negro";
	AL["Blackhand Assassin"] = "Asesino Puño Negro";
	AL["Firebrand Pyromancer"] = "Piromántico Pirotigma";
	AL["Firebrand Invoker"] = "Convocador Pirotigma";
	AL["Firebrand Grunt"] = "Bruto Pirotigma";
	AL["Firebrand Legionnaire"] = "Legionario Pirotigma";
	AL["Spirestone Warlord"] = "Señor de la Guerra Cumbrerroca";
	AL["Spirestone Mystic"] = "Místico Cumbrerroca";
	AL["Anvilrage Captain"] = "Capitán Yunque Colérico";
	AL["Anvilrage Marshal"] = "Alguacil de Yunque Colérico";
	AL["Doomforge Arcanasmith"] = "Arcanorrero de la Forja Maldita";
	AL["Weapon Technician"] = "Técnico de armas";
	AL["Doomforge Craftsman"] = "Artesano de la Forja Maldita";
	AL["Murk Worm"] = "Gusano de la oscuridad";
	AL["Atal'ai Witch Doctor"] = "Médico brujo Atal'ai";
	AL["Raging Skeleton"] = "Esqueleto enfurecido";
	AL["Ethereal Priest"] = "Sacerdote etéreo";
	AL["Sethekk Ravenguard"] = "Guardia cuervo Sethekk";
	AL["Time-Lost Shadowmage"] = "Mago de las Sombras Tiempo Perdido";
	AL["Coilfang Sorceress"] = "Hechicera Colmillo Torcido";
	AL["Coilfang Oracle"] = "Oráculo Colmillo Torcido";
	AL["Shattered Hand Centurion"] = "Centurión Mano Destrozada";
	AL["Eredar Deathbringer"] = "Libramorte Eredar";
	AL["Arcatraz Sentinel"] = "Centinela de Arcatraz";
	AL["Gargantuan Abyssal"] = "Abissal inmenso";
	AL["Sunseeker Botanist"] = "Botánica Buscasol";
	AL["Sunseeker Astromage"] = "Astromago Buscasol";
	AL["Durnholde Rifleman"] = "Fusilero de Durnholde";
	AL["Rift Keeper/Rift Lord"] = "Vigilante/Señor de la falla";
	AL["Crimson Templar"] = "Templario Carmesí";
	AL["Azure Templar"] = "Templario azur";
	AL["Hoary Templar"] = "Templario vetusto";
	AL["Earthen Templar"] = "Templario de tierra";
	AL["The Duke of Cynders"] = "Duque de las Brasas";
	AL["The Duke of Fathoms"] = "Duque de las Profundidades";
	AL["The Duke of Zephyrs"] = "Duque de los Céfiros";
	AL["The Duke of Shards"] = "Duque de las Esquirlas";
	AL["Aether-tech Assistant"] = "Ayudante técnico aether";
	AL["Aether-tech Adept"] = "Aether-tech Adept"; --FALTA
	AL["Aether-tech Master"] = "Aether-tech Master"; --FALTA
	AL["Trelopades"] = "Trelopades"; --FALTA
	AL["King Dorfbruiser"] = "King Dorfbruiser"; --FALTA
	AL["Gorgolon the All-seeing"] = "Gorgolon the All-seeing"; --FALTA
	AL["Matron Li-sahar"] = "Matrona Li-sahar";
	AL["Solus the Eternal"] = "Solus el Eterno";
	AL["Smokywood Pastures Vendor"] = "Vendedor de Pastos de Bosquehumeante";
	AL["Darkscreecher Akkarai"] = "Estridador oscuro Akkarai";
	--AL["Karrog"] = true,
	AL["Gezzarak the Huntress"] = "Gezzarak la Cazadora";
	AL["Vakkiz the Windrager"] = "Vakkiz el Furibundo del Viento";
	--AL["Terokk"] = true,
	AL["Armbreaker Huffaz"] = "Partebrazos Huffaz";
	AL["Fel Tinkerer Zortan"] = "Manitas vil Zortan";
	--AL["Forgosh"] = true,
	--AL["Gul'bor"] = true,
	AL["Malevus the Mad"] = "Malevus el Loco";
	AL["Porfus the Gem Gorger"] = "Porfus el Engullidor de gemas";
	AL["Wrathbringer Laz-tarash"] = "Encolerizador Laz-tarash";
	AL["Bash'ir Landing Stasis Chambers"] = "Cámaras de éxtasis del Alot Bash'ir";
	AL["Templars"] = "Templarios";
	AL["Dukes"] = "Duques";
	AL["High Council"] = "Consejero mayor";
	AL["Scarshield Quartermaster"] = "Intendente del Escudo del Estigma";
	AL["Father Flame"] = "Padre llama";
	--AL["Thomas Yance"] = true,
	AL["Knot Thimblejack"] = "Knot Thimblejack";
	AL["Shen'dralar Provisioner"] = "Proveedor Shen'dralar";
	AL["The Nameles Prophet"] = "El profeta sin nombre";
	AL["Rajaxx's Captains"] = "Capitanes de Rajaxx";
	AL["Razorfen Spearhide"] = "Lanceur de Tranchebauge";
	AL["Magregan Deepshadow"] = "Magregan Sombraprofunda";
	--AL["Don Carlos"] = true,
	--AL["Thomas Yance"] = "Thomas Yance";
	AL["Aged Dalaran Wizard"] = "Zahorí de Dalaran envejecido";
	AL["Felsteed"] = "Corcel vil";
	AL["Shattered Hand Executioner"] = "Verdugo Mano Destrozada";	 
	AL["Time-Lost Proto Drake"] = "Protodraco Tiempo Perdido";
	AL["Razzashi Raptor"] = "Razzashi presto";
	AL["Deviate Ravager/Deviate Guardian"] = "Devastador descarriado/Guardián descarriado";
	--AL["Servant's Quarter Animal Bosses"] = true; FALTA
	AL["Jadefang"] = "Colmillo de Jade";
	--AL["Aeonaxx"] = true;
	AL["Prince Sarsarun"] = "Príncipe Sarsarun";
	AL["Dormus the Camel-Hoarder"] = "Dormus el Acaparacamellos";
	AL["The Behemoth"] = "El Behemoth";
	AL["Master Elemental Shaper Krixix"] = "Maestro de los elementos Formacio Krixix";

	--Zones
	AL["Trial of the Grand Crusader"] = "Prueba del Gran Cruzado";
	AL["Crusader's Square"] = "Plaza de los Cruzados";
	AL["The Gauntlet"] = "El reto"; -- Comprobar

	--Shortcuts for Bossname files
	--AL["Avatar"] = true,	

	--Chests, etc
	--AL["Ring of Law"] = true; FALTA
	AL["Monument of Franclorn Forgewright"] = "Monumento a Franclorn Forjador";
	AL["The Grim Guzzler"] = "El Tragapenas";
	AL["Summoner's Tomb"] = "La tumba de los invocadores"; --Comprobar
	AL["The Secret Safe"] = "El secreto seguro";
	AL["The Vault"] = "La caja fuerte";
	AL["Ogre Tannin Basket"] = "Cesta de Ogro Tanino";
	AL["Fengus's Chest"] = "Cofre de Fengus";
	AL["Unfinished Painting"] = "Pintura sin terminar"; --Comprobar
	AL["Felvine Shard"] = "Fragmento de gangrevid";
	AL["Baelog's Chest"] = "Cofre de Baelog";
	AL["Lorgalis Manuscript"] = "Manuscrito de Lorgalis";
	AL["Fathom Core"] = "Núcleo de las profundidades";
	AL["Gift of Adoration"] = "Ofrenda de adoración";
	AL["Box of Chocolates"] = "Caja de bombones";
	AL["Treat Bag"] = "Bolsa de premios";
	AL["Gaily Wrapped Present"] = "Regalo con envoltorio alegre";
	AL["Festive Gift"] = "Obsequio festivo";
	AL["Ticking Present"] = "Obsequio que hace tic-tac";
	AL["Gently Shaken Gift"] = "Regalo ligeramente agitado";
	AL["Carefully Wrapped Present"] = "Presente envuelto con cuidado";
	AL["Winter Veil Gift"] = "Regalo de Fiesta de Invierno";
	AL["Smokywood Pastures Extra-Special Gift"] = "Obsequio megaespecial de Pastos de Bosquehumeante";
	AL["Brightly Colored Egg"] = "Huevos de colores brillantes"; --Comprobar
	AL["Lunar Festival Fireworks Pack"] = "Paquete de fuegos de artificio del Festival Lunar";
	AL["Lucky Red Envelope"] = "Sobre rojo de la suerte";
	AL["Small Rocket Recipes"] = "Recetas de cohetes pequeños";
	AL["Large Rocket Recipes"] = "Recetas de cohetes grandes";
	AL["Cluster Rocket Recipes"] = "Recetas de traca de cohetes";
	AL["Large Cluster Rocket Recipes"] = "Recetas de traca de cohetes grandes";
	AL["Timed Reward Chest"] = "Cofre de recompensa con tiempo"; --Comprobar
	AL["Timed Reward Chest 1"] = "Cofre de recompensa con tiempo 1";
	AL["Timed Reward Chest 2"] = "Cofre de recompensa con tiempo 2";
	AL["Timed Reward Chest 3"] = "Cofre de recompensa con tiempo 3";
	AL["The Talon King's Coffer"] = "El cofre del Rey Talon";
	AL["Krom Stoutarm's Chest"] = "Tesoro de Krom Rudebras";
	AL["Garrett Family Chest"] = "Tesoro de la familia Garrett";
	AL["Reinforced Fel Iron Chest"] = "Cofre reforzado de hierro vil";
	AL["DM North Tribute Chest"] = "Cofre del tributo de LM norte";
	AL["The Saga of Terokk"] = "La Saga de Terokk";
	AL["First Fragment Guardian"] = "Guardián del primer trozo";
	AL["Second Fragment Guardian"] = "Guardián del segundo trozo";
	AL["Third Fragment Guardian"] = "Guardián del tercer trozo";
	AL["Overcharged Manacell"] = "Célula de maná sobrecargada";
	AL["Mysterious Egg"] = "Huevo misterioso";
	AL["Hyldnir Spoils"] = "Botín Hyldnir";
	AL["Ripe Disgusting Jar"] = "Tarro desagradable maduro";
	AL["Cracked Egg"] = "Huevo roto";
	AL["Small Spice Bag"] = "Bolsa de especias pequeña";
	AL["Lovely Dress Box"] = "Caja de vestido precioso";
	AL["Dinner Suit Box"] = "Caja de traje de noche";
	AL["Bag of Heart Candies"] = "Bolsa de caramelos de corazón";
	AL["Hidden Stash"] = "Alijos escondidos";

	--Error Messages and warnings
	AL["AtlasLoot Error!"] = "¡AtlasLoot error!";
	AL["WishList Full!"] = "¡Lista de deseos llena'";
	AL["No match found for"] = "No se ha encontrado ninguna coincidencia";
	AL[" is safe."] = " es válido.";
	AL["Server queried for "] = "Preguntando al servidor por ";
	AL[".  Right click on any other item to refresh the loot page."] = ".  Haz click-dcho en otro objeto para refrescar la página.";

	--Incomplete Table Registry error message
	AL[" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = " no figura en el registro de botines, por favor informa sobre este mensaje en los foros de AtlasLoot http://www.atlasloot.net";

	--LoD Module disabled or missing
	AL[" is unavailable, the following load on demand module is required: "] = " no está disponible, se necesita el siguiente módulo: ";

	--LoD Module load sequence could not be completed
	AL["Status of the following module could not be determined: "] = "No se ha podido determinar el estado del siguiente módulo: ";

	--LoD Module required has loaded, but loot table is missing
	AL[" could not be accessed, the following module may be out of date: "] = " no se ha podido acceder, el siguiente módulo no debe estar actualizado: ";

	--LoD module not defined
	AL["Loot module returned as nil!"] = "¡El módulo de botín ha retornado null!";

	--LoD module loaded successfully
	AL["sucessfully loaded."] = "cargado satisfactoriamente.";

	--Need a big dataset for searching
	AL["Loading available tables for searching"] = "Cargando las tablas disponibles para búsquedas";

 	--All Available modules loaded
	AL["All Available Modules Loaded"] = "Se han cargado todos los módulos disponibles";
		
	--First time user
	AL["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences."] = "Bienvenido a AtlasLoot Enhanced. Por favor, tómate un momento para elegir tus preferencias.";
	AL["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "Bienvenido a Atlasloot Enhanced. Por favor tómate un momento para elegir tus preferencias en cada bocadillo y enlaces de la ventana de chat.\n\n Puedes volver a abrir esta ventana de opciones escribiendo '/atlasloot'.";
	AL["Setup"] = "Configuración";

	--Old Atlas Detected
	AL["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "Se ha detectado que tu versión de Atlas no coincide con la versión del AtlasLoot para la cual se ha hecho (";
	AL[").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = ").  Dependiendo de algún cambio, puede haber algún error ocasional, con lo que por favor, visita http://www.atlasmod.com/ lo antes posible para posibles actualizaciones.";
	AL["OK"] = "Vale";
	AL["Incompatible Atlas Detected"] = "Se ha detectado un Atlas incompatible ";

	--Unsafe item tooltip
	AL["Unsafe Item"] = "Objeto no seguro";
	AL["This item is not available on your server or your battlegroup yet."] = "Este objeto no está disponible en tu servidor o en tu grupo de batalla todavía";
	AL["You can right-click to attempt to query the server.  You may be disconnected."] = "Puedes hacer Click-dcho para intentar consultar al servidor.\nPuedes ser desconectado.";
end