﻿--[[
constants.fr.lua --- Traduction FR par KKram & Trasher
This file defines an AceLocale table for all the various text strings needed
by AtlasLoot.  In this implementation, if a translation is missing, it will fall
back to the English translation.

The ["text"] = true; shortcut can ONLY be used for English (the root translation).
]]




--Create the library instance
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");







--Register translations
AL:RegisterTranslations("frFR", function() return {
    --Text strings for UI objects
    --["AtlasLoot"] = true,
    ["No match found for"] = "Aucun résultat trouvé pour",
    ["Search"] = "Chercher",
    ["Clear"] = "Effacer",
    ["Select Loot Table"] = "Choisir une Liste",
    ["Select Sub-Table"] = "Choisir une Sous-Liste",
    ["Drop Rate: "] = "Chance de tomber: ",
    --["DKP"] = true,
    ["Priority:"] = "Priorité:",
    ["Click boss name to view loot."] = "Cliquez sur le nom du boss pour voir les objets.",
    ["Various Locations"] = "Lieux divers",
    ["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "Ceci est uniquement un navigateur pour les objets. Pour voir les cartes, installez Atlas ou Alphamap.",
    ["Toggle AL Panel"] = "Panneau AtlasLoot",
    [" is safe."] = " est valide.",
    ["Server queried for "] = "Interrogation du serveur pour ",
    [".  Right click on any other item to refresh the loot page."] = ".  Clic-Droit sur un autre objet permet de rafraîchir la page.",
    ["Back"] = "Retour",
    ["Level 60"] = "Niveau 60",
    ["Level 70"] = "Niveau 70",
    ["|cffff0000(unsafe)"] = " |cffff0000(invalide)",
    ["Misc"] = "Divers",
    ["Rewards"] = "Récompenses",
    ["Heroic Mode"] = "Mode Héroïque",
    ["Normal Mode"] = "Mode Normal",
    --["Raid"] = true,
    --["Factions - Azeroth"] = true,
    ["Factions - Outland"] = "Factions - Outreterre",
    ["Factions - Shattrath City"] = "Factions - Shattrath",
    ["Pre-Burning Crusade"] = "Avant Burning Crusade",
    ["Post-Burning Crusade"] = "Après Burning Crusade",
    ["Choose Table ..."] = "Choisissez une liste...",
    ["Close Menu"] = "Fermer la liste",
    ["Unknown"] = "Inconnu",
    ["Skill Required:"] = "Compétence requise :",
    --["QuickLook"] = true,
    ["Add to QuickLooks:"] = "Ajouter à QuickLook :",
    ["Assign this loot table\n to QuickLook"] = "Assigner cette table de loot\n à QuickLook",
    ["Req. Rating:"] = "Côte perso. :",
    --["Query Server"] = true,
    ["Classic Instances"] = "Instances classiques",
    ["BC Instances"] = "Instances BC",
    --["Burning Crusade"] = true,

    --Text for Options Panel
    ["Atlasloot Options"] = "Options d'Atlasloot",
    ["Safe Chat Links |cff1eff00(recommended)|r"] = "Liens sûrs sur le canal |cff1eff00(recommandé)|r",
    ["Enable all Chat Links |cffff0000(use at own risk)|r"] = "Liens sur le canal tous activés |cffff0000(risquée)|r",
    ["Default Tooltips"] = "Bulles d'aide par défault",
    ["Lootlink Tooltips"] = "Bulles d'aide Lootlink",
    ["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dBulles d'aide Lootlink",
    ["ItemSync Tooltips"] = "Bulles d'aide ItemSync",
    ["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dBulles d'aide ItemSync",
    ["Use EquipCompare"] = "Utiliser EquipCompare",
    ["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9dUtiliser EquipCompare",
    ["Show Comparison Tooltips"] = "Bulles d'aide comparatives",
    ["Make Loot Table Opaque"] = "Fond de liste opaque",
    ["Show itemIDs at all times"] = "Voir l'ID des objets",
    ["Hide AtlasLoot Panel"] = "Cacher le panneau d'AtlasLoot",
    ["Show Minimap Button"] = "Voir le bouton sur la Mini-carte",
    ["Set Minimap Button Position"] = "Position du bouton sur la Mini-carte",
    ["Suppress text spam when querying items"] = "Supprime les messages d'interrogation des objets",
    ["Notify me when a LoD Module is loaded"] = "M'informer quand un module est chargé",
    ["Load all loot modules at startup"] = "Charger tous les modules au démarrage",
    ["AutoQuery items on loot tables |cffff0000(disconnection risk)|r"] = "Interrogation automatique d'une table |cffff0000(risquée)|r",
    ["Done"] = "Ok",
    --["WishList"] = true,
    ["Search Result: %s"] = "Résultat(s) de la recherche : %s",
    ["Last Result"] = "Dernier(s) résultat(s)",
    ["Search on"] = "Recherche activé",
    ["All modules"] = "Tous les modules",
    ["If checked, AtlasLoot will load and search across all the modules."] = "Si coché, AtlasLoot recherche dans tous les modules.",
    ["Search options"] = "Options de la recherche",
    ["Partial matching"] = "Correspondance partielle",
    ["If checked, AtlasLoot search item names for a partial match."] = "Si coché, AtlasLoot recherche le nom d'un objet avec une correspondance partielle.",
    ["You don't have any module selected to search on!"] = "Vous n'avez pas sélectionné de module pour la recherche !",
    --The next 4 lines are the tooltip for the Server Query Button
    --The translation doesn't have to be literal, just re-write the
    --sentences as you would naturally and break them up into 4 roughly
    --equal lines.
    ["Queries the server for all items"] = "Interroge le serveur pour les objets",
    ["on this page. The items will be"] = "de cette page. Les objets seront",
    ["refreshed when you next mouse"] = "mis à jour une fois que vous aurez passé",
    ["over them."] = "votre souris dessus.",
        
    --Slash commands
    ["reset"] = "Réinitialiser",
    --["options"] = true,
    ["Reset complete!"] = "Réinitialisation complète !",

    --Error Messages and warnings
    ["AtlasLoot Error!"] = "Erreur AtlasLoot!",
    ["WishList Full!"] = "WishList complète!",
    [" added to the WishList."] = " a été ajouté à la WishList",
    [" already in the WishList!"] = " est déjà dans la WishList",
    [" deleted from the WishList."] = " a été effacé de la WishList",
    
    --Incomplete Table Registry error message
    [" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = " non répertorié dans la table des objets enregistrés, merci de transmettre ce message sur les forums d'AtlasLoot sur http://www.atlasloot.net",
    
    --LoD Module disabled or missing
    [" is unavailable, the following load on demand module is required: "] = " est indisponible, le module suivant (chargé à la demande) est requis: ",
    
    --LoD Module load sequence could not be completed
    ["Status of the following module could not be determined: "] = "Le status du module suivant n'a pu être déterminé: ",
    
    --LoD Module required has loaded, but loot table is missing
    [" could not be accessed, the following module may be out of date: "] = " n'a pas pu être consulté, le module suivant peut être dépassé: ",
    
    --LoD module loaded successfully
    ["sucessfully loaded."] = "chargement réussi.",
    
    --Need a big dataset for searching
    ["Loading available tables for searching"] = "Chargement des tables disponibles pour la recherche",
    
     --All Available modules loaded
    ["All Available Modules Loaded"] = "Tous les modules disponibles sont chargés.",

    --Minimap Button
    ["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00Clic-Gauche|r Parcours des Listes d'Objets",
    ["|cffff0000Right-Click|r View Options"] = "|cffff0000Clic-Droit|r Affiche les Options",
    ["|cffff0000Shift-Click|r View Options"] = "|cffff0000Shift-Clic|r Affiche les Options",
    ["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccClic-Gauche+Maintenir|r Déplace le bouton sur la Mini-carte",

    --AtlasLoot Panel
    --["Options"] = true,
    --["Collections"] = true,
    --["Factions"] = true,
    --["World Events"] = true,
    ["Load Modules"] = "Load modules",
    ["Crafting"] = "Artisanat",

    --First time user
    ["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences."] = "Bienvenue sur AtlasLoot Enhanced. Veuillez prendre un moment pour définir vos préférences.",
    ["New feature in 4.02.01: Type '/atlasloot options' to bring up the options menu and '/atlasloot reset' to reset AtlasLoot after a disconnect."] = "Nouvelle fonctionnalité dans la version 4.02.01 : Tapez '/atlasloot options' pour faire apparaître le menu des options et '/atlasloot reset' pour réinitialiser AtlasLoot après une déconnexion.",
    ["New feature in 4.03.00: Introducing the Wishlist!  Simply alt-click on any item to add it to the wishlist.  To delete an item from the wishlist, open up your wishlist and alt-click the item to remove it.  It's that simple.  Buttons to view the wishlist have been added to the Atlas interface and the loot browser."] = "Nouvelle fonctionnalité dans la version 4.03.00 : Introduction de la WishList. Alt-Clic pour ajouter un objet à la WishList. Pour supprimer un objet de la WishList, ouvrez votre WishList et faites Alt-Clic sur l'objet à effacer. Des boutons pour voir votre WishList ont été ajoutés sur l'interface d'Atlas et sur le navigateur d'AtlasLoot.",
    ["New feature in 4.05.00: Advanced searching functionality is now available. You can type in a partial item name, for example typing 'elixir' gives all items in the database with 'elixir' in the name.  Big thanks to Kurax for his help."] = "Nouvelle fonctionnalité dans la version 4.05.00 : La fonction de recherche avancée est maintenant disponible. Vous pouvez entrer le nom partiel d'un objet, par exemple entrer 'elixir', ça vous donnera tous les objets de la base de donnée avec le mot 'elixir' dans le nom. Enorme merci à Kurax pour cette aide :)",
    ["New feature in 4.05.00: All professions are now included in the AtlasLoot_Crafting module."] = "Nouvelle fonctionnalité dans la version 4.05.00 : Toutes les professions sont maintenant incluses dans le module AtlasLoot_Crafting.",
    ["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "Bienvenue dans AtlasLoot Enhaced. S'il vous plaît, prenez un moment pour définir vos préférences pour les info-bulles et les liens dans la fenêtre de chat.\n\nLes options peuvent être activées à tout moment en tapant '/atlasloot'.",
    ["Setup"] = "Installation",

    --Old Atlas Detected
    ["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "Il a été détecté que votre version d'Atlas n'est pas adapté à la version d'AtlasLoot, laquelle est étudiée pour (",
    [").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = "). Suivant les changements, des erreurs peuvent survenir, donc vous pouvez consulter le site http://www.***.com/ pour les futures mises à jour.",
    --["OK"] = true,
    ["Incompatible Atlas Detected"] = "Incompatibilité d'Atlas détectée ",

    --Unsafe item tooltip
    ["Unsafe Item"] = "Objet invalide",
    ["Item Unavailable"] = "Objet indisponible",
    ["ItemID:"] = "ObjetID:",
    ["This item is not available on your server or your battlegroup yet."] = "Cet objet n'est pas encore disponible sur votre serveur ou sur votre champ de bataille",
    ["This item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world. This is a restriction enforced by Blizzard since Patch 1.10."] =	"Cet objet n'est pas fiable.\nPour voir cet objet sans risque de déconnexion, vous devez l'avoir déjà vu une fois dans le jeu.\nCette restriction est imposée par Blizzard depuis la mise à jour 1.10.",
    ["You can right-click to attempt to query the server.  You may be disconnected."] = "Un Clic-Droit permet de tenter d'interroger le serveur.\nVous pouvez être déconnecté.",

    --Misc Inventory related words
    ["Mount"] = "Monture",
    ["Enchant"] = "Enchantement",
    ["Trade Goods"] = "Artisanat",
    ["Scope"] = "Lunette de visée",
    ["Pet"] = "Animal de compagnie",
    ["Darkmoon Faire Card"] = "Carte de la foire de Sombrelune",
    ["Book"] = "Livre",
    ["Banner"] = "Etendard",
    --["Set"] = true,
    ["Token"] = "Insigne",
    ["Crafting Reagent"] = "Composant de Craft",
    ["Skinning Knife"] = "Couteau à dépecer",
    ["Herbalism Knife"] = "Couteau d'herboriste",
    ["Fish"] = "Poisson",
    ["Combat Pet"] = "Animal de compagnie de combat",
    ["Fireworks"] = "Feux d'artifice",
    
    --Extra inventory stuff
    ["Cloak"] = "Cape",
    ["Weapons"] = "Armes",

    --Labels for loot descriptions
    ["Classes:"] = "Classes: ",
    ["This Item Begins a Quest"] = "Cet objet permet de lancer une quête",
    ["Quest Item"] = "Objet de Quête",
    ["Quest Reward"] = "Récompense de quête",
    ["Shared"] = "Partagé",
    --["Unique"] = true,
    ["Right Half"] = "Moitié droite",
    ["Left Half"] = "Moitié gauche",
    ["28 Slot Soul Shard"] = "28 emplacements Pierre d'âme",
    ["20 Slot"] = "20 emplacements",
    ["18 Slot"] = "18 emplacements",
    ["16 Slot"] = "16 emplacements",
    ["10 Slot"] = "10 emplacements",
    ["(has random enchantment)"] = "(caractéristiques aléatoires)",
    ["Use to purchase rewards"] = "Pour obtenir les récompenses",
    ["Use to purchase rewards (Horde)"] = "Pour obtenir les récompenses (Horde)",
    ["Use to purchase rewards (Alliance)"] = "Pour obtenir les récompenses (Alliance)",
    --["World Bosses"] = true,
    ["Reputation Factions"] = "Factions de réputation",
    --["Sets/Collections"] = true,
    ["Card Game Item"] = "Objet de Jeu de Carte",
    ["Tier 4"] = "Set T4",
    ["Tier 5"] = "Set T5",
    ["Tier 6"] = "Set T6",
    ["Arena Reward"] = "Récompense d'Arène",
    ["Conjured Item"] = "Objet Conjuré",
    ["Used to summon boss"] = "Utilisé pour invoquer un boss",
    --["Phase 1"] = true,
    --["Phase 2"] = true,
    --["Phase 3"] = true,
    ["Fire"] = "Feu",
    ["Water"] = "Eau",
    ["Wind"] = "Vent",
    ["Earth"] = "Terre",
    ["Master Angler"] = "Meilleur pêcheur",
    ["First Prize"] = "1er prix",
    ["Rare Fish Rewards"] = "Récompenses des poissons rares",
    ["Rare Fish"] = "Poissons rares",
    ["Tradable against sunmote + item above"] = "Echangeable contre une Granule de soleil + l'objet du dessus",
    ["Rare"] = "Rare",
    ["Heroic"] = "Héroïque",
    ["Summon"] = "Invocation",
    ["Random"] = "Aléatoire",
    ["Weapons"] = "Armes",

    --Card Game Decks and descriptions
    ["Upper Deck Card Game Items"] = "Objets des cartes à jouer WoW TCG",
    ["Heroes of Azeroth"] = "Héros d'Azeroth", -- 1ère série
    ["Through The Dark Portal"] = "A Travers la Porte des Ténèbres", -- 2ème série
    ["Fires of Outland"] = "Les Feux de l'Outreterre", -- 3ème série
    ["March of the Legion"] = "Marche de la Légion", -- 4ème série
    ["Servants of the Betrayer"] = "Les Serviteurs du Traître", -- 5ème série
    ["Hunt for Illidan"] = "La Traque d'Illidan", -- 6ème série
    --["Drums of Wars"] = true, -- 7ème série -- A TRADUIRE
    ["Loot Card Items"] = "Objets des cartes à jouer",
    ["UDE Items"] = "Objets (points UDE)",
    ["Landro Longshot"] = "Landro Tirauloin", -- 1ère série
    ["Thunderhead Hippogryph"] = "Hippogryffe Tête-Tonnerre", -- 1ère série
    ["Saltwater Snapjaw"] = "Gueule d'acier des mers", -- 1ère série
    ["King Mukla"] = "Roi Mukla", -- 2ème série
    ["Rest and Relaxation"] = "Repos et relaxation", -- 2ème série
    ["Fortune Telling"] = "La Bonne Aventure", -- 2ème série
    ["Spectral Tiger"] = "Tigre Spectral", -- 3ème série
    ["Gone Fishin'"] = "Parti Pêcher", -- 3ème série
    ["Goblin Gumbo"] = "Gumbo Gobelin", -- 3ème série
    --["Kiting"] = true, -- 4ème série
    ["Robotic Homing Chicken"] = "Poulet Robot Guidé", -- 4ème série
    ["Paper Airplane"] = "Machine volante en papier", -- 4ème série
    ["X-51 Nether-Rocket"] = "Fusée-de-néant X-51", -- 5ème série
    ["Personal Weather Machine"] = "Machine météorologique gobeline", -- 5ème série
    ["Papa Hummel's Old-fashioned Pet Biscuit"] = "Biscuit pour familier à l'ancienne de papa Humme", -- 5ème série
    --["The Footsteps of Illidan"] = true, -- 6ème série
    --["Disco Inferno!"] = true, -- 6ème série
    --["Ethereal Plunderer"] = true, -- 6ème série

    --Battleground Brackets
    ["Misc. Rewards"] = "Récompenses Diverses",
    ["Superior Rewards"] = "Récompenses Supérieurs",
    ["Epic Rewards"] = "Récompenses Epiques",
    ["Level 10-19 Rewards"] = "Récompenses Niveau 10-19",
    ["Level 20-29 Rewards"] = "Récompenses Niveau 20-29",
    ["Level 30-39 Rewards"] = "Récompenses Niveau 30-39",
    ["Level 40-49 Rewards"] = "Récompenses Niveau 40-49",
    ["Level 50-59 Rewards"] = "Récompenses Niveau 50-59",
    ["Level 60 Rewards"] = "Récompenses Niveau 60",

    --Brood of Nozdormu Paths
    ["Path of the Conqueror"] = "La voie du conquérant",
    ["Path of the Invoker"] = "La voie de l'invocateur",
    ["Path of the Protector"] = "La voie du protecteur",

    --Violet Eye Paths
    ["Path of the Violet Protector"] = "La voie du protecteur pourpre",
    ["Path of the Violet Mage"] = "La voie du mage pourpre",
    ["Path of the Violet Assassin"] = "La voie de l'assassin pourpre",
    ["Path of the Violet Restorer"] = "La voie du guérisseur pourpre",

    --AQ Opening Event
    ["Red Scepter Shard"] = "Fragment de sceptre rouge",
    ["Blue Scepter Shard"] = "Fragment de sceptre bleu",
    ["Green Scepter Shard"] = "Fragment de sceptre vert",
    ["Scepter of the Shifting Sands"] = "Le Sceptre des Sables changeants",

    --World PvP
    ["Hellfire Fortifications"] = "Fortifications des flammes infernales",
    ["Twin Spire Ruins"] = "Ruines des flèches jumelles",
    ["Spirit Towers"] = "Tour des esprits",
    --["Halaa"] = true,

    --Karazhan Opera Event Headings
    ["Shared Drops"] = "Objets en commun",
    ["Romulo & Julianne"] = "Romeo & Juliette",
    ["Wizard of Oz"] = "Le Magicien d'Oz",
    ["Red Riding Hood"] = "Petit Chaperon Rouge",

    --Karazhan Animal Boss Types
    ["Spider"] = "Araignée",
    ["Darkhound"] = "Sombredogue",
    ["Bat"] = "Chauve-souris",

    --ZG Tokens
    ["Primal Hakkari Kossack"] = "Casaque primordiale hakkari",
    ["Primal Hakkari Shawl"] = "Châle primordial hakkari",
    ["Primal Hakkari Bindings"] = "Manchettes primordiales hakkari",
    ["Primal Hakkari Sash"] = "Echarpe primordiale hakkari",
    ["Primal Hakkari Stanchion"] = "Etançon primordial hakkari",
    ["Primal Hakkari Aegis"] = "Egide primordiale hakkari",
    ["Primal Hakkari Girdle"] = "Ceinturon primordial hakkari",
    ["Primal Hakkari Armsplint"] = "Brachiales primordiales hakkari",
    ["Primal Hakkari Tabard"] = "Tabard primordial hakkari",

    --AQ20 Tokens
    ["Qiraji Ornate Hilt"] = "Manche orné qiraji",
    ["Qiraji Martial Drape"] = "Drapé martial qiraji",
    ["Qiraji Magisterial Ring"] = "Anneau de magistrat qiraji",
    ["Qiraji Ceremonial Ring"] = "Anneau de cérémonie qiraji",
    ["Qiraji Regal Drape"] = "Drapé royal qiraji",
    ["Qiraji Spiked Hilt"] = "Manche à pointes qiraji",

    --AQ40 Tokens
    ["Qiraji Bindings of Dominance"] = "Manchettes de domination qiraji",
    ["Qiraji Bindings of Command"] = "Diadème de Vek'nilash",
    ["Vek'nilash's Circlet"] = "Peau intacte d'Ouro",
    ["Vek'lor's Diadem"] = "Carcasse du Dieu très ancien",
    ["Ouro's Intact Hide"] = "Manchettes de commandement qiraji",
    ["Skin of the Great Sandworm"] = "Diadème de Vek'lor",
    ["Husk of the Old God"] = "Peau du Grand ver des sables",
    ["Carapace of the Old God"] = "Carapace du Dieu très ancien",

    --Blacksmithing Crafted Sets
    ["Imperial Plate"] = "Armure impériale en plaques",
    ["The Darksoul"] = "La Ténébrâme",
    ["Fel Iron Plate"] = "Plaque de gangrefer",
    ["Adamantite Battlegear"] = "Tenue de combat en adamantite",
    ["Flame Guard"] = "Garde des flammes",
    ["Enchanted Adamantite Armor"] = "Armure d'adamantite enchantée",
    ["Khorium Ward"] = "Gardien de khorium",
    ["Faith in Felsteel"] = "Foi dans le gangracier",
    ["Burning Rage"] = "Rage ardente",
    ["Bloodsoul Embrace"] = "Etreinte d'âmesang",
    ["Fel Iron Chain"] = "Anneaux de gangrefer",

    --Tailoring Crafted Sets
    ["Bloodvine Garb"] = "Atours de vignesang",
    ["Netherweave Vestments"] = "Tisse-néant imprégné",
    ["Imbued Netherweave"] = "Tisse-néant imprégné",
    ["Arcanoweave Vestments"] = "Habit de tisse-arcane",
    ["The Unyielding"] = "L'Inflexible",
    ["Whitemend Wisdom"] = "Sagesse de la blanche guérison",
    ["Spellstrike Infusion"] = "Infusion frappe-sort",
    ["Battlecast Garb"] = "Atours d'escarmouche",
    ["Soulcloth Embrace"] = "Etreinte d'âmétoffe",
    ["Primal Mooncloth"] = "Etoffe lunaire primordiale",
    ["Shadow's Embrace"] = "Etreinte de l'ombre",
    ["Wrath of Spellfire"] = "Habit du feu-sorcier",

    --Leatherworking Crafted Sets
    ["Volcanic Armor"] = "Armure volcanique",
    ["Ironfeather Armor"] = "Armure de plumacier",
    ["Stormshroud Armor"] = "Armure tempétueuse",
    ["Devilsaur Armor"] = "Armure de diablosaure",
    ["Blood Tiger Harness"] = "Harnais du tigre-sang",
    ["Primal Batskin"] = "Peau de chauve-souris primodiale",
    ["Wild Draenish Armor"] = "Armure draenique sauvage",
    ["Thick Draenic Armor"] = "Armure draenique épaisse",
    ["Fel Skin"] = "Gangrepeau",
    ["Strength of the Clefthoof"] = "Force du sabot-fourchu",
    ["Green Dragon Mail"] = "Mailles de dragon vert",
    ["Blue Dragon Mail"] = "Mailles de dragon bleu",
    ["Black Dragon Mail"] = "Mailles de dragon noir",
    ["Scaled Draenic Armor"] = "Armure draenique en écailles",
    ["Felscale Armor"] = "Armure en gangrécaille",
    ["Felstalker Armor"] = "Armure de traqueur gangrené",
    ["Fury of the Nether"] = "Furie du Néant",
    ["Primal Intent"] = "Intention primordiale",
    ["Windhawk Armor"] = "Armure Faucont-du-vent",
    ["Netherscale Armor"] = "Armure en écailles du Néant",
    ["Netherstrike Armor"] = "Armure Coup-de-Néant",

    --Vanilla WoW Sets
    ["Defias Leather"] = "Cuir défias",
    ["Embrace of the Viper"] = "Etreinte de la vipère",
    ["Chain of the Scarlet Crusade"] = "Cotte de mailles de la croisade écarlate",
    ["The Gladiator"] = "Le Gladiateur",
    ["Ironweave Battlesuit"] = "Tenue de bataille Tisse-fer",
    ["Necropile Raiment"] = "Grande tenue nécropile",
    ["Cadaverous Garb"] = "Atours cadavériques",
    ["Bloodmail Regalia"] = "Tenue de parade en mailles sanglantes",
    ["Deathbone Guardian"] = "Gardien des ossements",
    ["The Postmaster"] = "Le Maître de poste",
    ["Scourge Invasion"] = "Invasion du Fléau",
    ["Regalia of Undead Cleansing"] = "Tenue de parade de tueur de mort-vivant",
    ["Undead Slayer's Armor"] = "Armure de tueur de mort-vivant",
    ["Garb of the Undead Slayer"] = "Atours de tueur de mort-vivant",
    ["Battlegear of Undead Slaying"] = "Tenue de combat de tueur de mort-vivant",
    ["Shard of the Gods"] = "Eclat des dieux",
    ["Zul'Gurub Rings"] = "Anneaux Zul'Gurub",
    ["Major Mojo Infusion"] = "Infusion de mojo majeure",
    ["Overlord's Resolution"] = "Résolution du suzerain",
    ["Prayer of the Primal"] = "Prière du Primordial",
    ["Zanzil's Concentration"] = "Concentration de Zanzil",
    ["Spirit of Eskhandar"] = "Esprit d'Eskhandar",
    ["The Twin Blades of Hakkari"] = "Les Lames jumelles des Hakkari",
    ["Primal Blessing"] = "Bénédiction primordiale",
    ["Dal'Rend's Arms"] = "Armes de Dal'Rend",
    ["Spider's Kiss"] = "Baiser de l'araignée",

    --The Burning Crusade Sets
    ["Latro's Flurry"] = "Rafale de Latro",
    ["The Twin Stars"] = "Les Etoiles jumelles",
    ["The Twin Blades of Azzinoth"] = "Les Lames Doubles d'Azzinoth",

    --ZG Sets
    ["Haruspex's Garb"] = "Atours d'haruspice",
    ["Predator's Armor"] = "Armure de prédateur",
    ["Illusionist's Attire"] = "Costume d'illusionniste",
    ["Freethinker's Armor"] = "Armure de libre-penseur",
    ["Confessor's Raiment"] = "Grande tenue de confesseur",
    ["Madcap's Outfit"] = "Tenue d'insensé",
    ["Augur's Regalia"] = "Tenue de parade d'augure",
    ["Demoniac's Threads"] = "Effets de démoniaque",
    ["Vindicator's Battlegear"] = "Tenue de combat de redresseur de torts",

    --AQ20 Sets
    ["Symbols of Unending Life"] = "Symboles de vie interminable",
    ["Trappings of the Unseen Path"] = "Ornements du sentier invisible",
    ["Trappings of Vaulted Secrets"] = "Ornements des secrets scellés",
    ["Battlegear of Eternal Justice"] = "Tenue de combat de justice éternelle",
    ["Finery of Infinite Wisdom"] = "Vêture de sagesse infinie",
    ["Emblems of Veiled Shadows"] = "Emblèmes des ombres voilées",
    ["Gift of the Gathering Storm"] = "Don de la tempête imminente",
    ["Implements of Unspoken Names"] = "Ensemble des noms inexprimés",
    ["Battlegear of Unyielding Strength"] = "Tenue de combat de force inflexible",

    --AQ40 Sets
    ["Genesis Raiment"] = "Grande tenue de la genèse",
    ["Striker's Garb"] = "Atours du Frappeur",
    ["Enigma Vestments"] = "Habits de l'énigme",
    ["Avenger's Battlegear"] = "Tenue de combat du Vengeur",
    ["Garments of the Oracle"] = "Vêtements de l'oracle",
    ["Deathdealer's Embrace"] = "Etreinte du dispensateur de mort",
    ["Stormcaller's Garb"] = "Atours d'implorateur de tempête",
    ["Doomcaller's Attire"] = "Costume d'implorateur funeste",
    ["Conqueror's Battlegear"] = "Tenue de combat du Conquérant",

    --Dungeon 1 Sets
    ["Wildheart Raiment"] = "Grande tenue du Coeur-sauvage",
    ["Beaststalker Armor"] = "Armure du bestiaire",
    ["Magister's Regalia"] = "Tenue de parade de magistère",
    ["Lightforge Armor"] = "Armure de Sancteforge",
    ["Vestments of the Devout"] = "Habits du dévot",
    ["Shadowcraft Armor"] = "Armure Sombreruse",
    ["The Elements"] = "Les Eléments",
    ["Dreadmist Raiment"] = "Grande tenue de Brume-funeste",
    ["Battlegear of Valor"] = "Tenue de combat de vaillance",

    --Dungeon 2 Sets
    ["Feralheart Raiment"] = "Grande tenue Coeur-Farouche",
    ["Beastmaster Armor"] = "Armure de belluaire",
    ["Sorcerer's Regalia"] = "Tenue de parade du sorcier",
    ["Soulforge Armor"] = "Armure d'Âmeforge",
    ["Vestments of the Virtuous"] = "Habits du Vertueux",
    ["Darkmantle Armor"] = "Armure Sombremante",
    ["The Five Thunders"] = "Les Cinq tonnerres",
    ["Deathmist Raiment"] = "Grande tenue Mortebrume",
    ["Battlegear of Heroism"] = "Tenue de combat d'héroïsme",

    --Dungeon 3 Sets
    ["Hallowed Raiment"] = "Grande tenue bénie",
    ["Incanter's Regalia"] = "Tenue de parade d'incantateur",
    ["Mana-Etched Regalia"] = "Tenue de parade gravée au mana",
    ["Oblivion Raiment"] = "Grande tenue de l'oubli",
    ["Assassination Armor"] = "Armure d'assassinat",
    ["Moonglade Raiment"] = "Grande tenue de Reflet-de-lune",
    ["Wastewalker Armor"] = "Armure de marchefriche",
    ["Beast Lord Armor"] = "Armure de seigneur des bêtes",
    ["Desolation Battlegear"] = "Tenue de combat de la désolation",
    ["Tidefury Raiment"] = "Grande tenue de mascaret",
    ["Bold Armor"] = "Armure audacieuse",
    ["Doomplate Battlegear"] = "Tenue de combat de plaques funestes",
    ["Righteous Armor"] = "Armure du vertueux",

    --Tier 1 Sets
    ["Cenarion Raiment"] = "Grande tenue cénarienne",
    ["Giantstalker Armor"] = "Armure de traqueur de géant",
    ["Arcanist Regalia"] = "Tenue de parade d'arcaniste",
    ["Lawbringer Armor"] = "Armure judiciaire",
    ["Vestments of Prophecy"] = "Habits prophétiques",
    ["Nightslayer Armor"] = "Armure du tueur de la nuit",
    ["The Earthfury"] = "Rageterre",
    ["Felheart Raiment"] = "Grande tenue de Gangrecoeur",
    ["Battlegear of Might"] = "Tenue de combat de puissance",

    --Tier 2 Sets
    ["Stormrage Raiment"] = "Grande tenue de Stormrage",
    ["Dragonstalker Armor"] = "Armure de traqueur de dragon",
    ["Netherwind Regalia"] = "Tenue de parade de Vent du néant",
    ["Judgement Armor"] = "Armure du jugement",
    ["Vestments of Transcendence"] = "Habits de transcendance",
    ["Bloodfang Armor"] = "Armure Rougecroc",
    ["The Ten Storms"] = "Les Dix tempêtes",
    ["Nemesis Raiment"] = "Grande tenue de Némésis",
    ["Battlegear of Wrath"] = "Tenue de combat de courroux",

    --Tier 3 Sets
    ["Dreamwalker Raiment"] = "Grande tenue de marcherêve",
    ["Cryptstalker Armor"] = "Armure de traqueur des cryptes",
    ["Frostfire Regalia"] = "Tenue de parade de givrefeu",
    ["Redemption Armor"] = "Armure de rédemption",
    ["Vestments of Faith"] = "Habits de foi",
    ["Bonescythe Armor"] = "Armure de la faucheuse d'os",
    ["The Earthshatterer"] = "Le briseur de terre",
    ["Plagueheart Raiment"] = "Grande tenue de pestecoeur",
    ["Dreadnaught's Battlegear"] = "Tenue de combat de cuirassier",

    --Tier 4 Sets
    ["Malorne Harness"] = "Harnais de Malorne",
    ["Malorne Raiment"] = "Grande tenue de Malorne",
    ["Malorne Regalia"] = "Tenue de parade de Malorne",
    ["Demon Stalker Armor"] = "Armure de traqueur de démon",
    ["Aldor Regalia"] = "Tenue de parade de l'Aldor",
    ["Justicar Armor"] = "Armure de justicier",
    ["Justicar Battlegear"] = "Tenue de combat de justicier",
    ["Justicar Raiment"] = "Grande tenue de justicier",
    ["Incarnate Raiment"] = "Grande tenue des incarnés",
    ["Incarnate Regalia"] = "Tenue de parade des incarnés",
    ["Netherblade Set"] = "Lame-Néant",
    ["Cyclone Harness"] = "Harnais du cyclone",
    ["Cyclone Raiment"] = "Grande tenue du cyclone",
    ["Cyclone Regalia"] = "Tenue de parade du cyclone",
    ["Voidheart Raiment"] = "Grande tenue du Coeur-du-vide",
    ["Warbringer Armor"] = "Armure de porteguerre",
    ["Warbringer Battlegear"] = "Tenue de combat de porteguerre",

    --Tier 5 Sets
    ["Nordrassil Harness"] = "Harnais de Nordrassil",
    ["Nordrassil Raiment"] = "Grande tenue de Nordrassil",
    ["Nordrassil Regalia"] = "Tenue de parade de Nordrassil",
    ["Rift Stalker Armor"] = "Armure de traqueur des failles",
    ["Tirisfal Regalia"] = "Tenue de parade de Tirisfal",
    ["Crystalforge Armor"] = "Armure de Crystalforge",
    ["Crystalforge Battlegear"] = "Tenue de combat de Crystalforge",
    ["Crystalforge Raiment"] = "Grande tenue de Crystalforge",
    ["Avatar Raiment"] = "Grande tenue de l'avatar",
    ["Avatar Regalia"] = "Tenue de parade de l'avatar",
    ["Deathmantle Set"] = "Mantemort",
    ["Cataclysm Harness"] = "Harnais du cataclysme",
    ["Cataclysm Raiment"] = "Grande tenue du cataclysme",
    ["Cataclysm Regalia"] = "Tenue de parade du cyclone",
    ["Corruptor Raiment"] = "Grande tenue de corrupteur",
    ["Destroyer Armor"] = "Armure de destructeur",
    ["Destroyer Battlegear"] = "Tenue de combat de destructeur",

    --Tier 6 Sets
    ["Thunderheart Harness"] = "Harnais Coeur de tonnerre",
    ["Thunderheart Raiment"] = "Grande tenue Coeur de tonnerre",
    ["Thunderheart Regalia"] = "Tenue de parade Coeur de tonnerre",
    ["Gronnstalker's Armor"] = "Armure de traqueur de gronn",
    ["Tempest Regalia"] = "Tenue de parade de la tempête",
    ["Lightbringer Armor"] = "Armure de porteur de lumière",
    ["Lightbringer Battlegear"] = "Tenue de bataille de porteur de lumière",
    ["Lightbringer Raiment"] = "Grande tenue de porteur de lumiêre",
    ["Vestments of Absolution"] = "Habits d'absolution",
    ["Absolution Regalia"] = "Tenue de parade d'absolution",
    ["Slayer's Armor"] = "Armure de tueur",
    ["Skyshatter Harness"] = "Harnais Brise-ciel",
    ["Skyshatter Raiment"] = "Grande tenue Brise-ciel",
    ["Skyshatter Regalia"] = "Tenue de parade Brise-ciel",
    ["Malefic Raiment"] = "Grande tenue du maléfice",
    ["Onslaught Armor"] = "Armure d'assaut",
    ["Onslaught Battlegear"] = "Tenue de combat d'assaut",

    --Arathi Basin Sets - Alliance
    ["The Highlander's Intent"] = "Intention des Hautes-terres",
    ["The Highlander's Purpose"] = "Dessein des Hautes-terres",
    ["The Highlander's Will"] = "Volonté des Hautes-terres",
    ["The Highlander's Determination"] = "Détermination des Hautes-terres",
    ["The Highlander's Fortitude"] = "Force d'âme des Hautes-terres",
    ["The Highlander's Resolution"] = "Résolution des Hautes-terres",
    ["The Highlander's Resolve"] = "Fermeté des Hautes-terres",

    --Arathi Basin Sets - Horde
    ["The Defiler's Intent"] = "Intention du Profanateur",
    ["The Defiler's Purpose"] = "Dessein du Profanateur",
    ["The Defiler's Will"] = "Volonté du Profanateur",
    ["The Defiler's Determination"] = "Détermination du Profanateur",
    ["The Defiler's Fortitude"] = "Force d'âme du Profanateur",
    ["The Defiler's Resolution"] = "Résolution du Profanateur",

    --PvP Level 60 Rare Sets - Alliance
    ["Lieutenant Commander's Refuge"] = "Refuge de lieutenant-commandant",
    ["Lieutenant Commander's Pursuance"] = "Accomplissement de lieutenant-commandant",
    ["Lieutenant Commander's Arcanum"] = "Arcanum de lieutenant-commandant",
    ["Lieutenant Commander's Redoubt"] = "Redoute de lieutenant-commandant",
    ["Lieutenant Commander's Investiture"] = "Investiture de lieutenant-commandant",
    ["Lieutenant Commander's Guard"] = "Garde de lieutenant-commandant",
    ["Lieutenant Commander's Stormcaller"] = "Tornade de lieutenant-commandant",
    ["Lieutenant Commander's Dreadgear"] = "Tenue horrifique de lieutenant-commandant",
    ["Lieutenant Commander's Battlearmor"] = "Armure de bataille de lieutenant-commandant",

    --PvP Level 60 Rare Sets - Horde
    ["Champion's Refuge"] = "Refuge de champion",
    ["Champion's Pursuance"] = "Accomplissement de champion",
    ["Champion's Arcanum"] = "Arcanum de champion",
    ["Champion's Redoubt"] = "Redoute de champion",
    ["Champion's Investiture"] = "Investiture de champion",
    ["Champion's Guard"] = "Habits de champion",
    ["Champion's Stormcaller"] = "Tornade de champion",
    ["Champion's Dreadgear"] = "Tenue horrifique de champion",
    ["Champion's Battlearmor"] = "Armure de bataille de champion",

    --PvP Level 60 Epic Sets - Alliance
    ["Field Marshal's Sanctuary"] = "Sanctuaire de grand maréchal",
    ["Field Marshal's Pursuit"] = "Parure de grand maréchal",
    ["Field Marshal's Regalia"] = "Tenue de parade de grand maréchal",
    ["Field Marshal's Aegis"] = "Egide de grand maréchal",
    ["Field Marshal's Raiment"] = "Grande tenue de grand maréchal",
    ["Field Marshal's Vestments"] = "Habits de grand maréchal",
    ["Field Marshal's Earthshaker"] = "Trembleterre de grand maréchal",
    ["Field Marshal's Threads"] = "Effets de grand maréchal",
    ["Field Marshal's Battlegear"] = "Tenue de combat de grand maréchal",

    --PvP Level 60 Epic Sets - Horde
    ["Warlord's Sanctuary"] = "Sanctuaire de seigneur de guerre",
    ["Warlord's Pursuit"] = "Parure de maréchal de seigneur de guerre",
    ["Warlord's Regalia"] = "Tenue de parade de seigneur de guerre",
    ["Warlord's Aegis"] = "Egide de grand seigneur de guerre",
    ["Warlord's Raiment"] = "Grande tenue de seigneur de guerre",
    ["Warlord's Vestments"] = "Habits de seigneur de guerre",
    ["Warlord's Earthshaker"] = "Trembleterre de seigneur de guerre",
    ["Warlord's Threads"] = "Effets de seigneur de guerre",
    ["Warlord's Battlegear"] = "Tenue de combat de seigneur de guerre",

    --Outland Faction Reputation PvP Sets
    ["Dragonhide Battlegear"] = "Tenue de combat en peau de dragon",
    ["Wyrmhide Battlegear"] = "Tenue de combat en peau de wyrm",
    ["Kodohide Battlegear"] = "Tenue de combat en cuir de kodo",
    ["Stalker's Chain Battlegear"] = "Tenue de combat de traqueur en anneaux",
    ["Evoker's Silk Battlegear"] = "Tenue de combat d'évocateur en soie",
    ["Crusader's Scaled Battledgear"] = "Tenue de combat de croisé en écailles",
    ["Crusader's Ornamented Battledgear"] = "Tenue de combat ornementée de croisé",
    ["Satin Battlegear"] = "Tenue de combat en satin",
    ["Mooncloth Battlegear"] = "Tenue de combat en étoffe lunaire",
    ["Opportunist's Battlegear"] = "Tenue de combat d'opportuniste",
    ["Seer's Linked Battlegear"] = "Tenue de combat de voyant rivetée",
    ["Seer's Mail Battlegear"] = "Tenue de combat de voyant en mailles",
    ["Seer's Ringmail Battlegear"] = "Tenue de combat de voyant en mailles annelées",
    ["Dreadweave Battlegear"] = "Tenue de combat en tisse-effroi",
    ["Savage's Plate Battlegear"] = "Tenue de combat sauvage en plaques",

    --Arena Epic Sets
    ["Gladiator's Sanctuary"] = "Sanctuaire du gladiateur",
    ["Gladiator's Wildhide"] = "Peau de fauve de gladiateur",
    ["Gladiator's Refuge"] = "Refuge de gladiateur",
    ["Gladiator's Pursuit"] = "Parure de gladiateur",
    ["Gladiator's Regalia"] = "Tenue de parade de gladiateur",
    ["Gladiator's Aegis"] = "Egide de gladiateur",
    ["Gladiator's Vindication"] = "Justification de gladiateur",
    ["Gladiator's Redemption"] = "Rédemption de gladiateur",
    ["Gladiator's Raiment"] = "Grande tenue de gladiateur",
    ["Gladiator's Investiture"] = "Investiture de gladiateur",
    ["Gladiator's Vestments"] = "Habits de gladiateur",
    ["Gladiator's Earthshaker"] = "Trembleterre de gladiateur",
    ["Gladiator's Thunderfist"] = "Tonnepoing de gladiateur",
    ["Gladiator's Wartide"] = "Vague guerrière de gladiateur",
    ["Gladiator's Dreadgear"] = "Tenue horrifique de champion de l'arène",
    ["Gladiator's Felshroud"] = "Suaire gangrené de gladiateur",
    ["Gladiator's Battlegear"] = "Tenue de combat de gladiateur",

    --Set Labels
    ["Set: Embrace of the Viper"] = "Set: Etreinte de la vipère",
    ["Set: Defias Leather"] = "Set: Cuir défias",
    ["Set: The Gladiator"] = "Set: Le Gladiateur",
    ["Set: Chain of the Scarlet Crusade"] = "Set: Cotte de mailles de la croisade écarlate",
    ["Set: The Postmaster"] = "Set: Le Maître de poste",
    ["Set: Necropile Raiment"] = "Set: Grande tenue nécropile",
    ["Set: Cadaverous Garb"] = "Set: Atours cadavériques",
    ["Set: Bloodmail Regalia"] = "Set: Tenue de parade en mailles sanglantes",
    ["Set: Deathbone Guardian"] = "Set: Gardien des ossements",
    ["Set: Dal'Rend's Arms"] = "Set: Armes de Dal'Rend",
    ["Set: Spider's Kiss"] = "Baiser de l'araignée",
    ["Temple of Ahn'Qiraj Sets"] = "Sets d'Ahn'Qiraj",
    ["AQ40 Class Sets"] = "Sets de Classe AQ40",
    ["Ruins of Ahn'Qiraj Sets"] = "Sets des Ruines d'Ahn'Qiraj",
    ["AQ20 Class Sets"] = "Sets de Classe AQ20",
    ["AQ Enchants"] = "Enchantements AQ",
    ["AQ Opening Quest Chain"] = "Quêtes d'ouverture d'AQ",
    ["Pre 60 Sets"] = "Sets Pré 60",
    ["Crafted Sets"] = "Sets d'artisanat",
    ["Crafted Epic Weapons"] = "Armes d'artisanat épiques",
    ["Zul'Gurub Sets"] = "Sets Zul'Gurub",
    ["ZG Class Sets"] = "Sets de Classe ZG",
    ["ZG Enchants"] = "Enchantements ZG",
    ["Dungeon 1/2 Sets"] = "Sets Donjon 1/2",
    ["Dungeon Set 1"] = "Sets Donjon 1",
    ["Dungeon Set 2"] = "Sets Donjon 2",
    ["Dungeon 3 Sets"] = "Sets Donjon 3",
    ["Tier 1/2 Sets"] = "Sets T1/2",
    ["Tier 3 Sets"] = "Sets T3",
    ["Tier 4 Sets"] = "Sets T4",
    ["Tier 5 Sets"] = "Sets T5",
    ["Tier 6 Sets"] = "Sets T6",
    ["PvP Sets (Level 60)"] = "Sets JcJ (Niveau 60)",
    ["PvP Sets (Level 70)"] = "Sets JcJ (Niveau 70)",
    ["PvP Rewards (Level 60)"] = "Récompenses JcJ (Niveau 60)",
    ["PvP Rewards (Level 70)"] = "Récompenses JcJ (Niveau 70)",
    ["PvP Accessories (Level 60)"] = "Accessoires JcJ (Niveau 60)",
    ["PvP Accessories - Alliance (Level 60)"] = "Accéssoires JcJ - Alliance (Niveau 60)",
    ["PvP Accessories - Horde (Level 60)"] = "Accéssoires JcJ - Horde (Niveau 60)",
    ["PvP Accessories (Level 70)"] = "Accessoires JcJ (Niveau 70)",
    ["PvP Rewards"] = "Récompenses JcJ",
    ["PvP Armor Sets"] = "Sets Armures JcJ",
    ["PvP Weapons"] = "Armes JcJ",
    ["PvP Weapons (Level 60)"] = "Armes (JcJ Niveau 60)",
    ["PvP Weapons (Level 70)"] = "Armes (JcJ Niveau 70)",
    ["PvP Accessories"] = "Accessoires JcJ",
    ["PvP Non-Set Epics"] = "Epiques Hors Sets JcJ",
    ["PvP Honor System"] = "Système d'honneur JcJ",
    ["PvP Reputation Sets"] = "Sets Réputation JcJ",
    ["Arena PvP Sets"] = "Sets Arène JcJ",
    ["Arena 2 PvP Sets"] = "Sets 2 Arène JcJ",
    ["Arena 3 PvP Sets"] = "Sets 3 Arène JcJ",
    ["Arena 4 PvP Sets"] = "Sets 4 Arène JcJ",
    ["Arena PvP Weapons"] = "Armes Arène JcJ",
    ["Arena 2 PvP Weapons"] = "Armes 2 Arène JcJ",
    ["Arena 3 PvP Weapons"] = "Armes 3 Arène JcJ",
    ["Arena 4 PvP Weapons"] = "Armes 4 Arène JcJ",
    ["Arena PvP System"] = "Système d'arène JcJ",
    ["Arena Season 1 Weapons"] = "Armes Arène - Saison 1",
    ["Arena Season 2 Weapons"] = "Armes Arène - Saison 2",
    ["Arena Season 3 Weapons"] = "Armes Arène - Saison 3",
    ["Arena Season 4 Weapons"] = "Armes Arène - Saison 4",
    ["Season 1"] = "Saison 1",
    ["Season 2"] = "Saison 2",
    ["Season 3"] = "Saison 3",
    ["Season 4"] = "Saison 4",
    ["Arathi Basin Sets"] = "Sets Bassin d'Arathi",
    ["Class Books"] = "Livres de classe",
    ["Tribute Run"] = "Tribut du Roi",
    ["Dire Maul Books"] = "Livres de Hache Tripes",
    ["Random Boss Loot"] = "Objets aléatoires des boss",
    ["Class Set Pieces"] = "Pièces du set de Classe",
    ["Epic Set"] = "Set Épique",
    ["Rare Set"] = "Set Supérieur",
    ["Legendary Items"] = "Objets légendaires",
    ["Accesories and Weapons"] ="Accessoires et Armes",
    ["Badge of Justice Rewards"] = "Récompenses Insigne de justice",
    ["Accessories"] = "Accessoires",
    ["Armor and Weapons"] = "Armures et Armes",
    ["Fire Resistance Gear"] = "Equipements de Résistance au Feu",
    ["Arcane Resistance Gear"] = "Equipements de Résistance aux Arcanes",
    ["Nature Resistance Gear"] = "Equipements de Résistance à la Nature",
    ["Frost Resistance Gear"] = "Equipements de Résistance au Froid",
    ["Shadow Resistance Gear"] = "Equipements de Résistance à l'Ombre",
    ["Rare Mounts"] = "Montures rares",
    ["Tabards"] = "Tabards",
    ["Token Hand-Ins"] = "Insignes de l'Aube / Croisade",
    ["Heroic Mode Keys"] = "Clés Mode Héroïque",
    ["Legendary Items for Kael'thas Fight"] = "Objets légendaires pour le combat contre Kael'thas",
    ["BoE World Epics"] = "LqE World Epics",
    --["World Epics"] = true,
    ["Level 30-39"] = "Niveau 30-39",
    ["Level 40-49"] = "Niveau 40-49",
    ["Level 50-60"] = "Niveau 50-60",
    ["BT Patterns/Plans"] = "Patrons/Plans du Temple Noir",
    ["Hyjal Summit Designs"] = "Dessins du Sommet d'Hyjal",
    ["SP Patterns/Plans"] = "Patrons/Plans du Plateau du Puits de soleil",

    --NPCs missing from BabbleBoss
    --["Trash Mobs"] = true,
    ["Dungeon Set 2 Summonable"] = "Invocation Set Donjon 2",
    ["Highlord Kruul"] = "Généralissime Kruul",
    --["Theldren"] = true,
    ["Sothos and Jarien"] = "Sothos et Jarien",
    ["Druid of the Fang"] = "Druide du Croc",
    ["Defias Strip Miner"] = "Carrier défias",
    ["Defias Overseer/Taskmaster"] = "Sous-chef/Surveillant défias",
    ["Scarlet Defender/Myrmidon"] = "Défenseur/Myrmidon écarlate",
    ["Scarlet Champion"] = "Champion écarlate",
    ["Scarlet Centurion"] = "Centurion écarlate",
    ["Scarlet Trainee"] = "Jeune recrue écarlate",
    --["Herod/Mograine"] = true,
    ["Scarlet Protector/Guardsman"] = "Protecteur/Gardien écarlate",
    ["Shadowforge Flame Keeper"] = "Gardien des flammes Ombreforge",
    --["Olaf"] = true,
    ["Eric 'The Swift'"] = "Eric 'l'Agile'",
    ["Shadow of Doom"] = "Ombre funeste",
    ["Bone Witch"] = "Sorcière des ossements",
    ["Lumbering Horror"] = "Horreur chancelante",
    ["Avatar of the Martyred"] = "Avatar des martyrs",
    --["Yor"] = true,
    ["Nexus Stalker"] = "Traqueur du nexus",
    ["Auchenai Monk"] = "Moine auchenaï",
    ["Cabal Fanatic"] = "Fanatique de la Cabale",
    ["Unchained Doombringer"] = "Porte-destin sans chaîne",
    ["Crimson Sorcerer"] = "Ensorceleur cramoisi",
    ["Thuzadin Shadowcaster"] = "Exhalombre Thuzadin",
    ["Crimson Inquisitor"] = "Inquisiteur cramoisi",
    ["Crimson Battle Mage"] = "Mage de bataille cramoisi",
    ["Ghoul Ravener"] = "Goule vorace",
    ["Spectral Citizen"] = "Citoyen spectral",
    ["Spectral Researcher"] = "Chercheur spectral",
    ["Scholomance Adept"] = "Adepte de la Scholomance",
    ["Scholomance Dark Summoner"] = "Invocateur des ténèbres de la Scholomance",
    ["Blackhand Elite"] = "Elite Main-noire",
    ["Blackhand Assassin"] = "Assassin Main-noire",
    ["Firebrand Pyromancer"] = "Pyromancien de Brandefeu",
    ["Firebrand Invoker"] = "Invocateur de Brandefeu",
    ["Firebrand Grunt"] = "Grunt de Brandefeu",
    ["Firebrand Legionnaire"] = "Légionnaire de Brandefeu",
    ["Spirestone Warlord"] = "Chef de guerre Pierre-du-pic",
    ["Spirestone Mystic"] = "Mystique Pierre-du-pic",
    ["Anvilrage Captain"] = "Capitaine Ragenclume",
    ["Anvilrage Marshal"] = "Maréchal Ragenclume",
    ["Doomforge Arcanasmith"] = "Forgeron des arcanes Forge-ruine",
    ["Weapon Technician"] = "Ingénieur de siège",
    ["Doomforge Craftsman"] = "Artisan Forge-ruine",
    ["Murk Worm"] = "Ver des boues",
    ["Atal'ai Witch Doctor"] = "Sorcier-docteur atal'ai",
    ["Raging Skeleton"] = "Squelette déchaîné",
    ["Ethereal Priest"] = "Prêtre éthérien",
    ["Sethekk Ravenguard"] = "Garde-corbeau Sethekk",
    ["Time-Lost Shadowmage"] = "Ombremage du Temps-perdu",
    ["Coilfang Sorceress"] = "Sorcière de Glissecroc",
    ["Coilfang Oracle"] = "Oracle de Glissecroc",
    ["Shattered Hand Centurion"] = "Centurion de la Main brisée",
    ["Eredar Deathbringer"] = "Porte-mort érédar",
    ["Arcatraz Sentinel"] = "Sentinelle de l'Arcatraz",
    ["Gargantuan Abyssal"] = "Abyssal gargantuesque",
    ["Sunseeker Botanist"] = "Botaniste Cherche-soleil",
    ["Sunseeker Astromage"] = "Astromage Cherche-soleil",
    ["Durnholde Rifleman"] = "Fusilier de Fort-de-Durn",
    ["Rift Keeper/Rift Lord"] = "Gardien des failles/Seigneur des failles",
    ["Crimson Templar"] = "Templier cramoisi",
    ["Azure Templar"] = "Templier d'azur",
    ["Hoary Templar"] = "Templier chenu",
    ["Earthen Templar"] = "Templier terrestre",
    ["The Duke of Cynders"] = "Le duc des Cendres",
    ["The Duke of Fathoms"] = "Le duc des Profondeurs",
    ["The Duke of Zephyrs"] = "Le duc des Zéphyrs",
    ["The Duke of Shards"] = "Le duc des Eclats",
    ["Aether-tech Assistant"] = "Techno-éther assistant",
    ["Aether-tech Adept"] = "Techno-éther adepte",
    ["Aether-tech Master"] = "Techno-éther apprenti",
    ["Trelopades"] = "Trelopades",
    ["King Dorfbruiser"] = "Roi Cognenabot",
    ["Gorgolon the All-seeing"] = "Gorgolon l'Omnivoyant",
    ["Matron Li-sahar"] = "Matrone Li-sahar",
    ["Solus the Eternal"] = "Solus l'Éternel",
    --["Balzaphon"] = true,
    ["Lord Blackwood"] = "Seigneur Noirbois",
    --["Revanchion"] = true,
    --["Scorn"] = true,
    --["Sever"] = true,
    ["Lady Falther'ess"] = "Dame Falther'ess",
    ["Smokywood Pastures Vendor"] = "Vendeurs de Gourmandises Fumebois",
    --["Shartuul"] = true,
    ["Darkscreecher Akkarai"] = "Akkarai le Hurle-sombre",
    --["Karrog"] = true,
    ["Gezzarak the Huntress"] = "Gezzarak la Chasseresse",
    ["Vakkiz the Windrager"] = "Vakkiz le Ragevent",
    --["Terokk"] = true,
    ["Armbreaker Huffaz"] = "Casse-bras Huffaz",
    ["Fel Tinkerer Zortan"] = "Bricoleur gangrené Zortan",
    --["Forgosh"] = true,
    --["Gul'bor"] = true,
    ["Malevus the Mad"] = "Malevus le Fol",
    ["Porfus the Gem Gorger"] = "Porfus le Goinfre-gemmes",
    ["Wrathbringer Laz-tarash"] = "Porte-courroux Laz-tarash",
    ["Bash'ir Landing Stasis Chambers"] = "Chambre de stase alpha du point d'ancrage de Bash'ir",
    ["Templars"] = "Templiers",
    ["Dukes"] = "Ducs",
    ["High Council"] = "Princes",
    ["Headless Horseman"] = "Cavalier sans tête",
    ["Barleybrew Brewery"] = "Apprenti Brasselorge",
    ["Thunderbrew Brewery"] = "Apprenti Tonnebière",
    ["Gordok Brewery"] = "Apprenti de la bière gordok",
    ["Drohn's Distillery"] = "Apprenti de la distillerie Drohn",
    ["T'chali's Voodoo Brewery"] = "Apprenti de la brasserie vaudou de T'chali",
    ["Scarshield Quartermaster"] = "Intendant du Bouclier balafré",
    ["Overmaster Pyron"] = "Grand seigneur Pyron",
    ["Father Flame"] = "Père des flammes",
    --["Thomas Yance"] = true,
    ["Knot Thimblejack"] = "Noué Dédodevie",
    ["Shen'dralar Provisioner"] = "Approvisionneur Shen'dralar",
    ["Namdo Bizzfizzle"] = "Namdo Ventaperte",
    ["The Nameles Prophet"] = "Le Prophète sans nom",
    ["Zelemar the Wrathful"] = "Zelemar le Courroucé",
    --["Henry Stern"] = true,
    ["Aggem Thorncurse"] = "Aggem Malépine",
    --["Roogug"] = true,
    ["Rajaxx's Captains"] = "Les Capitaines de Rajaxx",
    ["Razorfen Spearhide"] = "Lanceur de Tranchebauge",
    ["Rethilgore"] = "Rethiltripe",
    ["Kalldan Felmoon"] = "Kalldan Gangrelune",
    ["Magregan Deepshadow"] = "Magregan Fondombre",
    --["Lord Ahune"] = true,
    ["Coren Direbrew"] = "Coren Navrebière",
    --["Don Carlos"] = true,

    --Zones
    --["World Drop"] = true,
    ["Sunwell Isle"] = "Plateau du Puits de soleil",
	
    --Shortcuts for Bossname files
    --["LBRS"] = true,
    --["UBRS"] = true,
    ["CoT1"] = "GDT1",
    ["CoT2"] = "GDT2",
    --["Scholo"] = true,
    --["Strat"] = true,
    ["Serpentshrine"] = "SCC",

    --Chests, etc
    ["Dark Coffer"] = "Coffre Noir",
    ["The Secret Safe"] = "Coffre à relique",
    ["The Vault"] = "La Chambre forte",
    ["Ogre Tannin Basket"] = "Panier Ogre de tannin",
    ["Fengus's Chest"] = "Coffre de Fengus",
    ["The Prince's Chest"] = "Coffre du Prince",
    ["Doan's Strongbox"] = "Coffre de Doan",
    ["Frostwhisper's Embalming Fluid"] = "Liquide d'embaumement de Murmegivre",
    ["Unforged Rune Covered Breastplate"] = "Plastron couvert de runes inachevé",
    ["Malor's Strongbox"] = "Coffre de Foi",
    ["Unfinished Painting"] = "Toile inachevée",
    ["Felvine Shard"] = "Fragment de la Gangrevigne",
    ["Baelog's Chest"] = "Coffre de Baelog",
    ["Lorgalis Manuscript"] = "Manuscrit de Lorgalis",
    ["Fathom Core"] = "Noyau de la Brasse",
    ["Conspicuous Urn"] = "Urne ostentatoire",
    ["Gift of Adoration"] = "Cadeau d'adoration",
    ["Box of Chocolates"] = "Boîte de chocolats",
    ["Treat Bag"] = "Sac de friandises",
    ["Gaily Wrapped Present"] = "Cadeau à l'emballage multicolore",
    ["Festive Gift"] = "Cadeau de fête",
    ["Ticking Present"] = "Cadeau tic-taquant",
    ["Gently Shaken Gift"] = "Cadeau secoué doucement",
    ["Carefully Wrapped Present"] = "Biscuit du Voile d'hiver",
    ["Winter Veil Gift"] = "Rob-fusée mécanique",
    ["Smokywood Pastures Extra-Special Gift"] = "Cadeau extra-spécial des Gourmandises Fumebois",
    ["Brightly Colored Egg"] = "Oeuf brillamment coloré",
    ["Lunar Festival Fireworks Pack"] = "Sac de feux d'artifice de la fête lunaire",
    ["Lucky Red Envelope"] = "Enveloppe rouge porte-bonheur",
    ["Small Rocket Recipes"] = "Recettes des petites comètes",
    ["Large Rocket Recipes"] = "Recettes de grandes comètes",
    ["Cluster Rocket Recipes"] = "Recettes de chapelet de comètes",
    ["Large Cluster Rocket Recipes"] = "Recettes de chapelet de grandes comètes",
    ["Timed Reward Chest"] = "Coffre du parcours rapide",
    ["Timed Reward Chest 1"] = "Coffre du parcours rapide 1",
    ["Timed Reward Chest 2"] = "Coffre du parcours rapide 2",
    ["Timed Reward Chest 3"] = "Coffre du parcours rapide 3",
    ["Timed Reward Chest 4"] = "Coffre du parcours rapide 4",
    ["The Talon King's Coffer"] = "Le coffre du roi-serre",
    ["Krom Stoutarm's Chest"] = "Coffre de Krom Rudebras",
    ["Garrett Family Chest"] = "Coffre de la famille Garrett",
    ["Reinforced Fel Iron Chest"] = "Coffre en gangrefer renforcé",
    ["DM North Tribute Chest"] = "Coffre du Roi (HT Nord)",
    
    --World Events
    ["Abyssal Council"] = "Conseil abyssal",
    ["Bash'ir Landing Skyguard Raid"] = "Point d'ancrage de Bash'ir",
    ["Brewfest"] = "La fête des Brasseurs",
    ["Children's Week"] = "La Semaine des enfants",
    ["Elemental Invasion"] = "Invasions élémentaires",
    ["Ethereum Prison"] = "Prison de l'Ethereum",
    ["Feast of Winter Veil"] = "La fête du Voile d'hiver",
    ["Gurubashi Arena Booty Run"] = "Le coffre pirate de Gurubashi",
    ["Hallow's End"] = "La Sanssaint",
    ["Harvest Festival"] = "La Fête des moissons",
    ["Love is in the Air"] = "De l'amour dans l'air",
    ["Lunar Festival"] = "La fête lunaire",
    ["Midsummer Fire Festival"] = "Solstice d'été : la fête du Feu",
    ["Noblegarden"] = "Le jardin des nobles",
    --["Skettis"] = true,
    ["Stranglethorn Fishing Extravaganza"] = "Concours de pêche de Strangleronce",

} end)