--[[
rep.lua
This file defines the loot tables for all the rep factions.
]]

--Need to invoke the constants file 
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--All rep loot tables go in this table
AtlasLoot_Data["AtlasLootRepItems"] = {
	EmptyInstance = {};

----------------------
--- WotLK Factions ---
----------------------

-------------------
--- BC Factions ---
-------------------
	Aldor1 = {
		{ 0, "Spell_Holy_SealOfSalvation", "=q6=#r2#", "" },
		{ 23149, "", "=q2=Design: Gleaming Golden Draenite", "=ds=#p12# (305)" },
		{ 23601, "", "=q1=Plans: Flamebane Bracers", "=ds=#p2# (350)" },
		{ 30842, "", "=q1=Pattern: Flameheart Bracers", "=ds=#p8# (350)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Spell_Holy_SealOfSalvation", "=q6=#r3#", "" },
		{ 29129, "", "=q3=Anchorite's Robes", "=ds=#a1#, #s5#" },
		{ 28881, "", "=q2=Inscription of Discipline", "=ds=#s3# #e17#" },
		{ 28878, "", "=q2=Inscription of Faith", "=ds=#s3# #e17#" },
		{ 28885, "", "=q2=Inscription of Vengeance", "=ds=#s3# #e17#" },
		{ 28882, "", "=q2=Inscription of Warding", "=ds=#s3# #e17#" },
		{ 23145, "", "=q2=Design: Royal Shadow Draenite", "=ds=#p12# (305)" },
		{ 23603, "", "=q1=Plans: Flamebane Gloves", "=ds=#p2# (360)" },
		{ 29704, "", "=q1=Pattern: Blastguard Belt", "=ds=#p7# (350)" },
		{ 29693, "", "=q1=Pattern: Flamescale Belt", "=ds=#p7# (350)" },
		{ 30843, "", "=q1=Pattern: Flameheart Gloves", "=ds=#p8# (360)" },
		{ 24293, "", "=q1=Pattern: Silver Spellthread", "=ds=#p8# (335)" },
	};

	Aldor2 = {
		{ 0, "Spell_Holy_SealOfSalvation", "=q6=#r4#", "" },
		{ 29127, "", "=q3=Vindicator's Hauberk", "=ds=#s5#, #a4#" },
		{ 29128, "", "=q3=Lightwarden's Band", "=ds=#s13#" },
		{ 29130, "", "=q3=Auchenai Staff", "=ds=#w9#" },
		{ 24177, "", "=q3=Design: Pendant of Shadow's End", "=ds=#p12# (360)" },
		{ 23604, "", "=q1=Plans: Flamebane Breastplate", "=ds=#p2# (365)" },
		{ 29703, "", "=q1=Pattern: Blastguard Boots", "=ds=#p7# (350)" },
		{ 29691, "", "=q1=Pattern: Flamescale Boots", "=ds=#p7# (350)" },
		{ 25721, "", "=q1=Pattern: Vindicator's Armor Kit", "=ds=#p7# (325)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Spell_Holy_SealOfSalvation", "=q6=#r5#", "" },
		{ 29123, "", "=q4=Medallion of the Lightbearer", "=ds=#s2#" },
		{ 29124, "", "=q4=Vindicator's Brand", "=ds=#h1#, #w10#" },
		{ 28886, "", "=q3=Greater Inscription of Discipline", "=ds=#s3# #e17#" },
		{ 28887, "", "=q3=Greater Inscription of Faith", "=ds=#s3# #e17#" },
		{ 28888, "", "=q3=Greater Inscription of Vengence", "=ds=#s3# #e17#" },
		{ 28889, "", "=q3=Greater Inscription of Warding", "=ds=#s3# #e17#" },
		{ 23602, "", "=q1=Plans: Flamebane Helm", "=ds=#p2# (355)" },
		{ 29702, "", "=q1=Pattern: Blastguard Pants", "=ds=#p7# (350)" },
		{ 29689, "", "=q1=Pattern: Flamescale Leggings", "=ds=#p7# (350)" },
		{ 24295, "", "=q1=Pattern: Golden Spellthread", "=ds=#p8# (375)" },
		{ 30844, "", "=q1=Pattern: Flameheart Vest", "=ds=#p8# (370)" },
		{ 31779, "", "=q1=Aldor Tabard", "=ds=#s7#" },
	};

	Ashtongue1 = {
		{ 0, "INV_Misc_Gem_Pearl_05", "=q6=#r2#", "" },
		{ 32444, "", "=q1=Plans: Shadesteel Girdle", "=ds=#p2# (375)" },
		{ 32442, "", "=q1=Plans: Shadesteel Bracers", "=ds=#p2# (375)" },
		{ 32436, "", "=q1=Pattern: Redeemed Soul Cinch", "=ds=#p7# (375)" },
		{ 32435, "", "=q1=Pattern: Redeemed Soul Legguards", "=ds=#p7# (375)" },
		{ 32430, "", "=q1=Pattern: Bracers of Shackled Souls", "=ds=#p7# (375)" },
		{ 32429, "", "=q1=Pattern: Boots of Shackled Souls", "=ds=#p7# (375)" },
		{ 32440, "", "=q1=Pattern: Soulguard Girdle", "=ds=#p8# (375)" },
		{ 32438, "", "=q1=Pattern: Soulguard Bracers", "=ds=#p8# (375)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Gem_Pearl_05", "=q6=#r3#", "" },
		{ 32443, "", "=q1=Plans: Shadesteel Greaves", "=ds=#p2# (375)" },
		{ 32441, "", "=q1=Plans: Shadesteel Sabots", "=ds=#p2# (375)" },
		{ 32433, "", "=q1=Pattern: Redeemed Soul Mocassins", "=ds=#p7# (375)" },
		{ 32434, "", "=q1=Pattern: Redeemed Soul Wristguards", "=ds=#p7# (375)" },
		{ 32431, "", "=q1=Pattern: Greaves of Shackled Souls", "=ds=#p7# (375)" },
		{ 32432, "", "=q1=Pattern: Waistguard of Shackled Souls", "=ds=#p7# (375)" },
		{ 32447, "", "=q1=Pattern: Night's End", "=ds=#p8# (375)" },
		{ 32439, "", "=q1=Pattern: Soulguard Leggings", "=ds=#p8# (375)" },
		{ 32437, "", "=q1=Pattern: Soulguard Slippers", "=ds=#p8# (375)" },
	};

	Ashtongue2 = {
		{ 0, "INV_Misc_Gem_Pearl_05", "=q6=#r5#", "" },
		{ 32486, "", "=q4=Ashtongue Talisman of Equilibrium", "=ds=#s14#, =q1=#m1# =ds=#c1#" },
		{ 32487, "", "=q4=Ashtongue Talisman of Swiftness", "=ds=#s14#, =q1=#m1# =ds=#c2#" },
		{ 32488, "", "=q4=Ashtongue Talisman of Insight", "=ds=#s14#, =q1=#m1# =ds=#c3#" },
		{ 32489, "", "=q4=Ashtongue Talisman of Zeal", "=ds=#s14#, =q1=#m1# =ds=#c4#" },
		{ 32490, "", "=q4=Ashtongue Talisman of Acumen", "=ds=#s14#, =q1=#m1# =ds=#c5#" },
		{ 32492, "", "=q4=Ashtongue Talisman of Lethality", "=ds=#s14#, =q1=#m1# =ds=#c6#" },
		{ 32491, "", "=q4=Ashtongue Talisman of Vision", "=ds=#s14#, =q1=#m1# =ds=#c7#" },
		{ 32493, "", "=q4=Ashtongue Talisman of Shadows", "=ds=#s14#, =q1=#m1# =ds=#c8#" },
		{ 32485, "", "=q4=Ashtongue Talisman of Valor", "=ds=#s14#, =q1=#m1# =ds=#c9#" },
	};

	CExpedition1 = {
		{ 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r2#", "" },
		{ 25737, "", "=q3=Pattern: Heavy Clefthoof Boots", "=ds=#p7# (355)" },
		{ 24417, "", "=q2=Scout's Arrow", "=ds=#w17#" },
		{ 23814, "", "=q1=Schematic: Green Smoke Flare", "=ds=#p5# (335)" },
		{ 24429, "", "=q1=Expedition Flare", "" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r3#", "" },
		{ 25838, "", "=q3=Warden's Hauberk", "=ds=#s5#, #a2#" },
		{ 25836, "", "=q3=Preserver's Cudgel", "=ds=#h3#, #w6#" },
		{ 25835, "", "=q3=Explorer's Walking Stick", "=ds=#w9#" },
		{ 25735, "", "=q3=Pattern: Heavy Clefthoof Vest", "=ds=#p7# (360)" },
		{ 25736, "", "=q3=Pattern: Heavy Clefthoof Leggings", "=ds=#p7# (355)" },
		{ 29194, "", "=q2=Glyph of Nature Warding", "#s1# #e17#" },
		{ 25869, "", "=q1=Recipe: Transmute Earthstorm Diamond", "=ds=#p1# (350)" },
		{ 32070, "", "=q1=Recipe: Earthen Elixir", "=ds=#p1# (320)" },
		{ 23618, "", "=q1=Plans: Adamantite Sharpening Stone", "=ds=#p2# (350)" },
		{ 28632, "", "=q1=Plans: Adamantite Weightstone", "=ds=#p2# (350)" },
		{ 25526, "", "=q1=Plans: Greater Rune of Warding", "=ds=#p2# (350)" },
		{ 29720, "", "=q1=Pattern: Clefthide Leg Armor", "=ds=#p7# (335)" },
		{ 30623, "", "=q1=Reservoir Key", "=ds=#e9#" },
	};

	CExpedition2 = {
		{ 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r4#", "" },
		{ 31392, "", "=q4=Plans: Wildguard Helm", "=ds=#p2# (375)" },
		{ 31391, "", "=q4=Plans: Wildguard Leggings", "=ds=#p2# (375)" },
		{ 29174, "", "=q3=Watcher's Cowl", "=ds=#s1#, #a1#" },
		{ 29173, "", "=q3=Strength of the Untamed", "=ds=#s2#" },
		{ 31949, "", "=q3=Warden's Arrow", "=ds=#w17#" },
		{ 24183, "", "=q3=Design: Nightseye Panther", "=ds=#p12# (370)" },
		{ 29192, "", "=q2=Glyph of Ferocity", "=ds=#s1# #e17#" },
		{ 22918, "", "=q2=Recipe: Transmute Primal Water to Air", "=ds=#p1# (350)" },
		{ 28271, "", "=q2=Formula: Enchant Gloves - Spell Strike", "=ds=#p4# (360)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r5#", "" },
		{ 33999, "", "=q4=Cenarion War Hippogryph", "=ds=#e12#" },
		{ 29170, "", "=q4=Windcaller's Orb", "=ds=#s15#" },
		{ 29172, "", "=q4=Ashyen's Gift", "=ds=#s13#" },
		{ 29171, "", "=q4=Earthwarden", "=ds=#h2#, #w6#" },
		{ 31390, "", "=q4=Plans: Wildguard Breastplate", "=ds=#p2# (375)" },
		{ 31402, "", "=q4=Design: The Natural Ward", "=ds=#p12# (375)" },
		{ 33149, "", "=q3=Formula: Enchant Cloak - Stealth", "=ds=#p4# (300)" },
		{ 31356, "", "=q2=Recipe: Flask of Distilled Wisdom", "=ds=#p1# (300)" },
		{ 22922, "", "=q1=Recipe: Major Nature Protection Potion", "=ds=#p1# (360)" },
		{ 29721, "", "=q1=Pattern: Nethercleft Leg Armor", "=ds=#p7# (365)" },
		{ 31804, "", "=q1=Cenarion Expedition Tabard", "=ds=#s7#" },
	};

	Consortium1 = {
		{ 0, "INV_Weapon_Shortblade_31", "=q6=#r2#", "" },
		{ 25732, "", "=q3=Pattern: Fel Leather Gloves", "=ds=#p7# (340)" },
		{ 28274, "", "=q2=Formula: Enchant Cloak - Spell Penetration", "=ds=#p4# (325)" },
		{ 23146, "", "=q2=Design: Shifting Shadow Draenite", "=ds=#p12# (315)" },
		{ 23136, "", "=q2=Design: Luminous Flame Spessarite", "=ds=#p12# (305)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Weapon_Shortblade_31", "=q6=#r3#", "" },
		{ 29457, "", "=q3=Nethershard", "=ds=#h3#, #w4#" },
		{ 29456, "", "=q3=Gift of the Ethereal", "=ds=#h1#, #w10#" },
		{ 29118, "", "=q3=Smuggler's Ammo Pouch", "=ds=#m14# #w20# =q1=#m1# =ds=#c2#" },
		{ 25733, "", "=q3=Pattern: Fel Leather Boots", "=ds=#p7# (350)" },
		{ 23134, "", "=q2=Design: Delicate Blood Garnet", "=ds=#p12# (325)" },
		{ 23155, "", "=q2=Design: Lustrous Azure Moonstone", "=ds=#p12# (325)" },
		{ 23150, "", "=q2=Design: Thick Golden Draenite", "=ds=#p12# (315)" },
		{ 22552, "", "=q1=Formula: Enchant Weapon - Major Striking", "=ds=#p4# (340)" },
		{ 25908, "", "=q1=Design: Swift Skyfire Diamond", "=ds=#p12# (365)" },
		{ 25902, "", "=q1=Design: Powerful Earthstorm Diamond", "=ds=#p12# (365) (#z12#)" },
		{ 24314, "", "=q1=Pattern: Bag of Jewels", "=ds=#p8# (340)" },
	};

	Consortium2 = {
		{ 0, "INV_Weapon_Shortblade_31", "=q6=#r4#", "" },
		{ 29117, "", "=q3=Stormspire Vest", "=ds=#s5#, #a1#" },
		{ 29116, "", "=q3=Nomad's Leggings", "=ds=#s11#, #a2#" },
		{ 29115, "", "=q3=Consortium Blaster", "=ds=#w5#" },
		{ 24178, "", "=q3=Design: Pendant of the Null Rune", "=ds=#p12# (360)" },
		{ 25734, "", "=q3=Pattern: Fel Leather Leggings", "=ds=#p7# (350)" },
		{ 22535, "", "=q1=Formula: Enchant Ring - Weapon Might", "=ds=#p4# (360) (#z12#)" },
		{ 23874, "", "=q1=Schematic: Elemental Seaforium Charge", "=ds=#p5# (350)" },
		{ 25903, "", "=q1=Design: Bracing Earthstorm Diamond", "=ds=#p12# (365) (#z12#)" },
		{ 33156, "", "=q1=Design: Crimson Sun", "=ds=#p12# (360)" },
		{ 33305, "", "=q1=Design: Don Julio's Heart", "=ds=#p12# (360)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Weapon_Shortblade_31", "=q6=#r5#", "" },
		{ 29122, "", "=q4=Nether Runner's Cowl", "=ds=#s1#, #a1#" },
		{ 29119, "", "=q4=Haramad's Bargain", "=ds=#s2#" },
		{ 29121, "", "=q4=Guile of Khoraazi", "=ds=#h1#, #w4#" },
		{ 33622, "", "=q3=Design: Relentless Earthstorm Diamond", "=ds=#p12# (365)" },
		{ 31776, "", "=q1=Consortium Tabard", "=ds=#s7#" },
	};

	HonorHold1 = {
		{ 0, "INV_BannerPVP_02", "=q6=#r2#", "" },
		{ 29213, "", "=q3=Pattern: Felstalker Belt", "=ds=#p7# (350)" },
		{ 23142, "", "=q2=Design: Enduring Deep Peridot", "=ds=#p12# (315)" },
		{ 22531, "", "=q1=Formula: Enchant Bracer - Superior Healing", "=ds=#p4# (325)" },
		{ 24007, "", "=q1=Footman's Waterskin", "=ds=#e4#" },
		{ 24008, "", "=q1=Dried Mushroom Rations", "=ds=#e3#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_BannerPVP_02", "=q6=#r3#", "" },
		{ 25826, "", "=q3=Sage's Band", "=ds=#s13#" },
		{ 25825, "", "=q3=Footman's Longsword", "=ds=#h1#, #w10#" },
		{ 29214, "", "=q3=Pattern: Felstalker Bracers", "=ds=#p7# (360)" },
		{ 29215, "", "=q3=Pattern: Felstalker Breastplate", "=ds=#p7# (360)" },
		{ 29196, "", "=q2=Glyph of Fire Warding", "=ds=#s1# #e17#" },
		{ 25870, "", "=q1=Recipe: Transmute Skyfire Diamond", "=ds=#p1# (350)" },
		{ 22905, "", "=q1=Recipe: Elixir of Major Agility", "=ds=#p1# (330)" },
		{ 29719, "", "=q1=Pattern: Cobrahide Leg Armor", "=ds=#p7# (335)" },
		{ 30622, "", "=q1=Flamewrought Key", "=ds=#e9#" },
	};

	HonorHold2 = {
		{ 0, "INV_BannerPVP_02", "=q6=#r4#", "" },
		{ 29169, "", "=q3=Ring of Convalescence", "=ds=#s13#" },
		{ 29166, "", "=q3=Hellforged Halberd", "=ds=#w7#" },
		{ 32883, "", "=q3=Felbane Slugs", "=ds=#w18#" },
		{ 24180, "", "=q3=Design: Dawnstone Crab", "=ds=#p12# (370)" },
		{ 29189, "", "=q2=Glyph of Renewal", "=ds=#s1# #e17#" },
		{ 22547, "", "=q1=Formula: Enchant Chest - Exceptional Stats", "=ds=#p4# (345)" },
		{ 34218, "", "=q1=Pattern: Netherscale Ammo Pouch", "=ds=#p7# (350)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_BannerPVP_02", "=q6=#r5#", "" },
		{ 29153, "", "=q4=Blade of the Archmage", "=ds=#h3#, #w10#" },
		{ 29156, "", "=q4=Honor's Call", "=ds=#h1#, #w10#" },
		{ 29151, "", "=q4=Veteran's Musket", "=ds=#w5#" },
		{ 33150, "", "=q3=Formula: Enchant Cloak - Subtlety", "=ds=#p4# (300)" },
		{ 23619, "", "=q1=Plans: Felsteel Shield Spike", "=ds=#p2# (360)" },
		{ 29722, "", "=q1=Pattern: Nethercobra Leg Armor", "=ds=#p7# (365)" },
		{ 23999, "", "=q1=Honor Hold Tabard", "=ds=#s7#" },
	};

	KeepersofTime1 = {
		{ 0, "Ability_Warrior_VictoryRush", "=q6=#r3#", "" },
		{ 29198, "", "=q2=Glyph of Frost Warding", "=ds=#s1# #e17#" },
		{ 28272, "", "=q2=Formula: Enchant Gloves - Major Spellpower", "=ds=#p4# (360)" },
		{ 22536, "", "=q1=Formula: Enchant Ring - Spellpower", "=ds=#p4# (360)" },
		{ 25910, "", "=q1=Design: Enigmatic Skyfire Diamond", "=ds=#p12# (365)" },
		{ 33160, "", "=q1=Design: Facet of Eternity", "=ds=#p12# (360)" },
		{ 29713, "", "=q1=Pattern: Drums of Panic", "=ds=#p7# (370)" },
		{ 30635, "", "=q1=Key of Time", "=ds=#e9#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Ability_Warrior_VictoryRush", "=q6=#r4#", "" },
		{ 29184, "", "=q3=Timewarden's Leggings", "=ds=#s11#, #a4#" },
		{ 29185, "", "=q3=Continuum Blade", "=ds=#h3#, #w10#" },
		{ 24181, "", "=q3=Design: Living Ruby Serpent", "=ds=#p12# (370)" },		
		{ 24174, "", "=q3=Design: Pendant of Frozen Flame", "=ds=#p12# (360)" },
		{ 29186, "", "=q2=Glyph of the Defender", "=ds=#s1# #e17#" },
		{ 33158, "", "=q1=Design: Stone of Blades", "=ds=#p12# (360)" },
		{ 0,"","","" },
		{ 0, "Ability_Warrior_VictoryRush", "=q6=#r5#", "" },
		{ 29183, "", "=q4=Bindings of the Timewalker", "=ds=#s8#, #a1#" },
		{ 29181, "", "=q4=Timelapse Shard", "=ds=#s14#" },
		{ 29182, "", "=q4=Riftmaker", "=ds=#h1#, #w4#" },
		{ 33152, "", "=q3=Formula: Enchant Gloves - Superior Agility", "=ds=#p4# (300)" },
		{ 31355, "", "=q2=Recipe: Flask of Supreme Power", "=ds=#p1# (300)" },
		{ 31777, "", "=q1=Keepers of Time Tabard", "=ds=#s7#" },
	};

	Kurenai1 = {
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r2#", "" },
		{ 29217, "", "=q3=Pattern: Netherfury Belt", "=ds=#p7# (340)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r3#", "" },
		{ 29144, "", "=q3=Worg Hide Quiver", "=ds=#m14# #w19# =q1=#m1# =ds=#c2#" },
		{ 29219, "", "=q3=Pattern: Netherfury Leggings", "=ds=#p7# (340)" },
		{ 34175, "", "=q1=Pattern: Drums of Restoration", "=ds=#p7# (350)" },
		{ 34173, "", "=q1=Pattern: Drums of Speed", "=ds=#p7# (345)" },
		{ 30444, "", "=q1=Pattern: Reinforced Mining Bag", "=ds=#p7# (325)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r4#", "" },
		{ 29148, "", "=q3=Blackened Leather Spaulders", "=ds=#s3#, #a2#" },
		{ 29142, "", "=q3=Kurenai Kilt", "=ds=#s11#, #a2#" },
		{ 29146, "", "=q3=Band of Elemental Spirits", "=ds=#s13#" },
		{ 29218, "", "=q3=Pattern: Netherfury Boots", "=ds=#p7# (350)" },
		{ 30443, "", "=q2=Recipe: Transmute Primal Fire to Earth", "=ds=#p1# (350)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r5#", "" },
		{ 29227, "", "=q4=Reins of the Cobalt War Talbuk", "=ds=#e12#" },
		{ 29229, "", "=q4=Reins of the Silver War Talbuk", "=ds=#e12#" },
		{ 29230, "", "=q4=Reins of the Tan War Talbuk", "=ds=#e12#" },
		{ 29231, "", "=q4=Reins of the White War Talbuk", "=ds=#e12#" },
		{ 31830, "", "=q4=Reins of the Cobalt Riding Talbuk", "=ds=#e12#" },
		{ 31832, "", "=q4=Reins of the Silver Riding Talbuk", "=ds=#e12#" },
		{ 31834, "", "=q4=Reins of the Tan Riding Talbuk", "=ds=#e12#" },
		{ 31836, "", "=q4=Reins of the White Riding Talbuk", "=ds=#e12#" },
		{ 29140, "", "=q3=Cloak of the Ancient Spirits", "=ds=#s4#" },
		{ 29136, "", "=q3=Far Seer's Helm", "=ds=#s1#, #a3#" },
		{ 29138, "", "=q3=Arechron's Gift", "=ds=#h2#, #w6#" },
		{ 31774, "", "=q1=Kurenai Tabard", "=ds=#s7#" },
	};

	LowerCity1 = {
		{ 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r2#", "" },
		{ 23138, "", "=q2=Design: Potent Flame Spessarite", "=ds=#p12# (325)" },
		{ 0,"","","" },
		{ 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r4#", "" },
		{ 30836, "", "=q3=Leggings of the Skettis Exile", "=ds=#s11#, #a1#" },
		{ 30835, "", "=q3=Salvager's Hauberk", "=ds=#s5#, #a3#" },
		{ 30841, "", "=q3=Lower City Prayerbook", "=ds=#s14#" },
		{ 24179, "", "=q3=Design: Felsteel Boar", "=ds=#p12# (370)" },
		{ 24175, "", "=q3=Design: Pendant of Thawing", "=ds=#p12# (360)" },
		{ 30846, "", "=q2=Glyph of the Outcast", "=ds=#s1# #e17#" },
		{ 22910, "", "=q2=Recipe: Elixir of Major Shadow Power", "=ds=#p1# (350)" },
		{ 33157, "", "=q1=Design: Falling Star", "=ds=#p12# (360)" },
		{ 34200, "", "=q1=Pattern: Quiver of a Thousand Arrows", "=ds=#p7# (350)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r3#", "" },
		{ 29199, "", "=q2=Glyph of Shadow Warding", "=ds=#s1# #e17#" },
		{ 22538, "", "=q1=Formula: Enchant Ring - Stats", "=ds=#p4# (375)" },
		{ 30833, "", "=q1=Pattern: Cloak of Arcane Evasion", "=ds=#p8# (350)" },
		{ 30633, "", "=q1=Auchenai Key", "=ds=#e9#" },
		{ 0,"","","" },
		{ 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r5#", "" },
		{ 30834, "", "=q4=Shapeshifter's Signet", "=ds=#s13#" },
		{ 30832, "", "=q4=Gavel of Unearthed Secrets", "=ds=#h3#, #w6#" },
		{ 30830, "", "=q4=Trident of the Outcast Tribe", "=ds=#w7#" },
		{ 33148, "", "=q3=Formula: Enchant Cloak - Dodge", "=ds=#p4# (300)" },
		{ 31357, "", "=q2=Recipe: Flask of Chromatic Resistance", "=ds=#p1# (300)" },
		{ 31778, "", "=q1=Lower City Tabard", "=ds=#s7#" },
	};

	Maghar1 = {
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r2#", "" },
		{ 25741, "", "=q3=Pattern: Netherfury Belt", "=ds=#p7# (340)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r3#", "" },
		{ 29143, "", "=q3=Clefthoof Hide Quiver", "=ds=#m14# #w19# =q1=#m1# =ds=#c2#" },
		{ 25742, "", "=q3=Pattern: Netherfury Leggings", "=ds=#p7# (340)" },
		{ 34174, "", "=q1=Pattern: Drums of Restoration", "=ds=#p7# (350)" },
		{ 34172, "", "=q1=Pattern: Drums of Speed", "=ds=#p7# (345)" },
		{ 29664, "", "=q1=Pattern: Reinforced Mining Bag", "=ds=#p7# (325)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r4#", "" },
		{ 29147, "", "=q3=Talbuk Hide Spaulders", "=ds=#s3#, #a2#" },
		{ 29141, "", "=q3=Tempest Leggings", "=ds=#s11#, #a2#" },
		{ 29145, "", "=q3=Band of Ancestral Spirits", "=ds=#s13#" },
		{ 25743, "", "=q3=Pattern: Netherfury Boots", "=ds=#p7# (350)" },
		{ 22917, "", "=q2=Recipe: Transmute Primal Fire to Earth", "=ds=#p1# (350)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Foot_Centaur", "=q6=#r5#", "" },
		{ 29102, "", "=q4=Reins of the Cobalt War Talbuk", "=ds=#e12#" },
		{ 29104, "", "=q4=Reins of the Silver War Talbuk", "=ds=#e12#" },
		{ 29105, "", "=q4=Reins of the Tan War Talbuk", "=ds=#e12#" },
		{ 29103, "", "=q4=Reins of the White War Talbuk", "=ds=#e12#" },
		{ 31829, "", "=q4=Reins of the Cobalt Riding Talbuk", "=ds=#e12#" },
		{ 31831, "", "=q4=Reins of the Silver Riding Talbuk", "=ds=#e12#" },
		{ 31833, "", "=q4=Reins of the Tan Riding Talbuk", "=ds=#e12#" },
		{ 31835, "", "=q4=Reins of the White Riding Talbuk", "=ds=#e12#" },
		{ 29139, "", "=q3=Ceremonial Cover", "=ds=#s4#" },
		{ 29135, "", "=q3=Earthcaller's Headdress", "=ds=#s1#, #a3#" },
		{ 29137, "", "=q3=Hellscream's Will", "=ds=#h2#, #w1#" },
		{ 31773, "", "=q1=Mag'har Tabard", "=ds=#s7#" },
	};

	Netherwing1 = {
		{ 0, "Ability_Mount_Netherdrakepurple", "=q6=#r2#", "" },
		{ 32694, "", "=q2=Overseer's Badge", "=ds=#s14#" },
		{ 0,"","","" },
		{ 0, "Ability_Mount_Netherdrakepurple", "=q6=#r3#", "" },
		{ 32695, "", "=q3=Captain's Badge", "=ds=#s14#" },
		{ 32863, "", "=q3=Skybreaker Whip", "=q1=#m4#: =ds=#s14#" },
		{ 0,"","","" },
		{ 0, "Ability_Mount_Netherdrakepurple", "=q6=#r4#", "" },
		{ 32864, "", "=q3=Commander's Badge", "=ds=#s14#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Ability_Mount_Netherdrakepurple", "=q6=#r5#", "" },
		{ 32858, "", "=q4=Reins of the Azure Netherwing Drake", "=ds=#e12#" },
		{ 32859, "", "=q4=Reins of the Cobalt Netherwing Drake", "=ds=#e12#" },
		{ 32857, "", "=q4=Reins of the Onyx Netherwing Drake", "=ds=#e12#" },
		{ 32860, "", "=q4=Reins of the Purple Netherwing Drake", "=ds=#e12#" },
		{ 32861, "", "=q4=Reins of the Veridian Netherwing Drake", "=ds=#e12#" },
		{ 32862, "", "=q4=Reins of the Violet Netherwing Drake", "=ds=#e12#" },
	};

	Ogrila1 = {
		{ 0, "INV_DataCrystal01", "=q6=#r2#", "" },
		{ 32910, "", "=q1=Red Ogre Brew Special", "=q1=#m4#: =ds=#e2#" },
		{ 32909, "", "=q1=Blue Ogre Brew Special", "=q1=#m4#: =ds=#e2#" },
		{ 0,"","","" },
		{ 0, "INV_DataCrystal01", "=q6=#r3#", "" },
		{ 32784, "", "=q1=Red Ogre Brew", "=ds=#e2#", "2 #ogrilashard#" },
		{ 32783, "", "=q1=Blue Ogre Brew", "=ds=#e2#", "3 #ogrilashard#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 32572, "", "=q3=Apexis Crystal", "=ds=#m17#" },
		{ 0,"","","" },
		{ 0, "INV_DataCrystal01", "=q6=#r4#", "" },
		{ 32653, "", "=q3=Apexis Cloak", "=ds=#s4#", "1 #ogrilacrystal# 50 #ogrilashard#" },
		{ 32654, "", "=q3=Crystalforged Trinket", "=ds=#s14#", "1 #ogrilacrystal# 50 #ogrilashard#" },
		{ 32652, "", "=q3=Ogri'la Aegis", "=ds=#w8#", "1 #ogrilacrystal# 50 #ogrilashard#" },
		{ 32650, "", "=q3=Cerulean Crystal Rod", "=ds=#w12#", "1 #ogrilacrystal# 50 #ogrilashard#" },
		{ 0,"","","" },
		{ 0, "INV_DataCrystal01", "=q6=#r5#", "" },
		{ 32647, "", "=q4=Shard-bound Bracers", "=ds=#s8#, #a2#", "4 #ogrilacrystal# 100 #ogrilashard#" },
		{ 32648, "", "=q4=Vortex Walking Boots", "=ds=#s12#, #a4#", "4 #ogrilacrystal# 100 #ogrilashard#" },
		{ 32651, "", "=q4=Crystal Orb of Enlightenment", "=ds=#s15#", "4 #ogrilacrystal# 100 #ogrilashard#" },
		{ 32645, "", "=q4=Crystalline Crossbow", "=ds=#w3#", "4 #ogrilacrystal# 100 #ogrilashard#" },
		{ 32828, "", "=q1=Ogri'la Tabard", "=ds=#s7#", "10 #ogrilashard#" },
		{ 0,"","","" },
		{ 32569, "", "=q1=Apexis Shard", "=ds=#m17#" },
	};

	ScaleSands1 = {
		{ 29298, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
		{ 29299, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
		{ 29300, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
		{ 29301, "", "=q4=Band of the Eternal Champion", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 29294, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
		{ 29295, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
		{ 29296, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
		{ 29297, "", "=q4=Band of the Eternal Defender", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 29302, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
		{ 29303, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
		{ 29304, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
		{ 29305, "", "=q4=Band of the Eternal Sage", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 29307, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
		{ 29306, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
		{ 29308, "", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
		{ 29309, "", "=q4=Band of the Eternal Restorer", "=ds=#s13#, =q1=#r5#" },
	};

	ScaleSands2 = {
		{ 0, "INV_Misc_MonsterScales_13", "=q6=#r2#", "" },
		{ 32274, "", "=q4=Design: Bold Crimson Spinel", "=ds=#p12# (375)" },
		{ 32283, "", "=q4=Design: Bright Crimson Spinel", "=ds=#p12# (375)" },
		{ 32277, "", "=q4=Design: Delicate Crimson Spinel", "=ds=#p12# (375)" },
		{ 32282, "", "=q4=Design: Runed Crimson Spinel", "=ds=#p12# (375)" },
		{ 32284, "", "=q4=Design: Subtle Crimson Spinel", "=ds=#p12# (375)" },
		{ 32281, "", "=q4=Design: Teardrop Crimson Spinel", "=ds=#p12# (375)" },
		{ 32288, "", "=q4=Design: Lustrous Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 32286, "", "=q4=Design: Solid Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 32287, "", "=q4=Design: Sparkling Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 32290, "", "=q4=Design: Brilliant Lionseye", "=ds=#p12# (375)" },
		{ 32293, "", "=q4=Design: Gleaming Lionseye", "=ds=#p12# (375)" },
		{ 32291, "", "=q4=Design: Smooth Lionseye", "=ds=#p12# (375)" },
		{ 32294, "", "=q4=Design: Thick Lionseye", "=ds=#p12# (375)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_MonsterScales_13", "=q6=#r3#", "" },
		{ 35763, "", "=q4=Design: Quick Lionseye", "=ds=#p12# (375)" },
		{ 32306, "", "=q4=Design: Glinting Pyrestone", "=ds=#p12# (375)" },
		{ 32305, "", "=q4=Design: Luminous Pyrestone", "=ds=#p12# (375)" },
		{ 32304, "", "=q4=Design: Potent Pyrestone", "=ds=#p12# (375)" },
		{ 35762, "", "=q4=Design: Reckless Pyrestone", "=ds=#p12# (375)" },
		{ 32299, "", "=q4=Design: Balanced Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 32301, "", "=q4=Design: Glowing Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 32300, "", "=q4=Design: Infused Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 32311, "", "=q4=Design: Dazzling Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35765, "", "=q4=Design: Forceful Seaspray Emerald", "=ds=#p12# (375)" },
		{ 32312, "", "=q4=Design: Jagged Seaspray Emerald", "=ds=#p12# (375)" },
		{ 32310, "", "=q4=Design: Radiant Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35764, "", "=q4=Design: Steady Seaspray Emerald", "=ds=#p12# (375)" },
	};

	ScaleSands3 = {
		{ 0, "INV_Misc_MonsterScales_13", "=q6=#r3#", "" },
		{ 31737, "", "=q4=Timeless Arrow", "=ds=#w17#" },
		{ 31735, "", "=q4=Timeless Shell", "=ds=#w18#" },
		{ 0,"","","" },
		{ 0, "INV_Misc_MonsterScales_13", "=q6=#r4#", "" },
		{ 32292, "", "=q4=Design: Rigid Lionseye", "=ds=#p12# (375)" },
		{ 32308, "", "=q4=Design: Wicked Pyrestone", "=ds=#p12# (375)" },
		{ 32309, "", "=q4=Design: Enduring Seaspray Emerald", "=ds=#p12# (375)" },
		{ 32302, "", "=q4=Design: Royal Shadowsong Amethyst", "=ds=#p12# (375)" },
	};

	Scryer1 = {
		{ 0, "Spell_Holy_ChampionsBond", "=q6=#r2#", "" },
		{ 23133, "", "=q2=Design: Runed Blood Garnet", "=ds=#p12# (315)" },
		{ 23597, "", "=q1=Plans: Enchanted Adamantite Belt", "=ds=#p2# (355)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Spell_Holy_ChampionsBond", "=q6=#r3#", "" },
		{ 28907, "", "=q2=Inscription of the Blade", "=ds=#s3# #e17#" },
		{ 28908, "", "=q2=Inscription of the Knight", "=ds=#s3# #e17#" },
		{ 28904, "", "=q2=Inscription of the Oracle", "=ds=#s3# #e17#" },
		{ 28903, "", "=q2=Inscription of the Orb", "=ds=#s3# #e17#" },
		{ 23143, "", "=q2=Design: Dazzling Deep Peridot", "=ds=#p12# (325)" },
		{ 23598, "", "=q1=Plans: Enchanted Adamantite Boots", "=ds=#p2# (355)" },
		{ 29701, "", "=q1=Pattern: Enchanted Clefthoof Boots", "=ds=#p7# (350)" },
		{ 29682, "", "=q1=Pattern: Enchanted Felscale Gloves", "=ds=#p7# (350)" },
		{ 24292, "", "=q1=Pattern: Mystic Spellthread", "=ds=#p8# (335)" },
	};

	Scryer2 = {
		{ 0, "Spell_Holy_ChampionsBond", "=q6=#r4#", "" },
		{ 29131, "", "=q3=Retainer's Leggings", "=ds=#s11#, #a2# " },
		{ 29134, "", "=q3=Gauntlets of the Chosen", "=ds=#s9#, #a4# " },
		{ 29132, "", "=q3=Scryer's Bloodgem", "=ds=#s14#" },
		{ 29133, "", "=q3=Seer's Cane", "=ds=#w9#" },
		{ 24176, "", "=q3=Design: Pendant of Withering", "=ds=#p12# (360)" },
		{ 22908, "", "=q2=Recipe: Elixir of Major Firepower", "=ds=#p1# (345)" },
		{ 23599, "", "=q1=Plans: Enchanted Adamantite Breastplate", "=ds=#p2# (360)" },
		{ 29700, "", "=q1=Pattern: Enchanted Clefthoof Gloves", "=ds=#p7# (350)" },
		{ 29684, "", "=q1=Pattern: Enchanted Felscale Boots", "=ds=#p7# (350)" },
		{ 25722, "", "=q1=Pattern: Magister's Armor Kit", "=ds=#p7# (325)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Spell_Holy_ChampionsBond", "=q6=#r5#", "" },
		{ 29126, "", "=q4=Seer's Signet", "=ds=#s13#" },
		{ 29125, "", "=q4=Retainer's Blade", "=ds=#h1#, #w4#" },
		{ 28910, "", "=q3=Greater Inscription of the Blade", "=ds=#s3# #e17#" },
		{ 28911, "", "=q3=Greater Inscription of the Knight", "=ds=#s3# #e17#" },
		{ 28912, "", "=q3=Greater Inscription of the Oracle", "=ds=#s3# #e17#" },
		{ 28909, "", "=q3=Greater Inscription of the Orb", "=ds=#s3# #e17#" },
		{ 23600, "", "=q1=Plans: Enchanted Adamantite Leggings", "=ds=#p2# (365)" },
		{ 29698, "", "=q1=Pattern: Enchanted Clefthoof Leggings", "=ds=#p7# (350)" },
		{ 29677, "", "=q1=Pattern: Enchanted Felscale Leggings", "=ds=#p7# (350)" },
		{ 24294, "", "=q1=Pattern: Runic Spellthread", "=ds=#p8# (375)" },
		{ 31780, "", "=q1=Scryers Tabard", "=ds=#s7#" },
	};

	Shatar1 = {
		{ 0, "Spell_Nature_LightningOverload", "=q6=#r2#", "" },
		{ 25904, "", "=q1=Design: Insightful Earthstorm Diamond", "=ds=#p12# (365)" },
		{ 0,"","","" },
		{ 0, "Spell_Nature_LightningOverload", "=q6=#r4#", "" },
		{ 29180, "", "=q3=Blessed Scale Girdle", "=ds=#s10#, #a3#" },
		{ 29179, "", "=q3=Xi'ri's Gift", "=ds=#s14#" },
		{ 24182, "", "=q3=Design: Talasite Owl", "=ds=#p12# (370)" },
		{ 29191, "", "=q2=Glyph of Power", "=ds=#s1# #e17#" },
		{ 22915, "", "=q2=Recipe: Transmute Primal Air to Fire", "=ds=#p1# (350)" },
		{ 28281, "", "=q2=Formula: Enchant Weapon - Major Healing", "=ds=#p4# (350)" },
		{ 13517, "", "=q1=Recipe: Alchemist's Stone", "=ds=#p1# (350)" },
		{ 22537, "", "=q1=Formula: Enchant Ring - Healing Power", "=ds=#p4# (370)" },
		{ 33159, "", "=q1=Design: Blood of Amber", "=ds=#p12# (360)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Spell_Nature_LightningOverload", "=q6=#r3#", "" },
		{ 30826, "", "=q3=Design: Ring of Arcane Shielding", "=ds=#p12# (360)" },
		{ 29195, "", "=q2=Glyph of Arcane Warding", "=ds=#s1# #e17#" },
		{ 28273, "", "=q2=Formula: Enchant Gloves - Major Healing", "=ds=#p4# (350)" },
		{ 33155, "", "=q1=Design: Kailee's Rose", "=ds=#p12# (360)" },
		{ 29717, "", "=q1=Pattern: Drums of Battle", "=ds=#p7# (365)" },
		{ 30634, "", "=q1=Warpforged Key", "=ds=#e9#" },
		{ 0,"","","" },
		{ 0, "Spell_Nature_LightningOverload", "=q6=#r5#", "" },
		{ 29177, "", "=q4=A'dal's Command", "=ds=#s13#" },
		{ 29175, "", "=q4=Gavel of Pure Light", "=ds=#h3#, #w6#" },
		{ 29176, "", "=q4=Crest of the Sha'tar", "=ds=#w8#" },
		{ 33153, "", "=q3=Formula: Enchant Gloves - Threat", "=ds=#p4# (300)" },
		{ 31354, "", "=q2=Recipe: Flask of the Titans", "=ds=#p1# (300)" },
		{ 31781, "", "=q1=Sha'tar Tabard", "=ds=#s7#" },
	};

	ShattrathFlasks1 = {
		{ 32898, "", "=q1=Shattrath Flask of Fortification", "=ds=#e2#" },
		{ 32899, "", "=q1=Shattrath Flask of Mighty", "=ds=#e2#" },
		{ 32901, "", "=q1=Shattrath Flask of Relentless", "=ds=#e2#" },
		{ 32900, "", "=q1=Shattrath Flask of Supreme Power", "=ds=#e2#" },
	};

	Skyguard1 = {
		{ 0, "INV_Misc_Ribbon_01", "=q6=#r2#", "" },
		{ 32722, "", "=q1=Enriched Terocone Juice", "=ds=#e4#" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Ribbon_01", "=q6=#r3#", "" }, 
		{ 32721, "", "=q1=Skyguard Rations", "=ds=#e3#" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Ribbon_01", "=q6=#r4#", "" },
		{ 32539, "", "=q3=Skyguard's Drape", "=ds=#s4#" },
		{ 32538, "", "=q3=Skywitch's Drape", "=ds=#s4#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Ribbon_01", "=q6=#r5#", "" },
		{ 32770, "", "=q4=Skyguard Silver Cross", "=ds=#s14#" },
		{ 32771, "", "=q4=Airman's Ribbon of Gallantry", "=ds=#s14#" },
		{ 32319, "", "=q4=Blue Riding Nether Ray", "=ds=#e12#" },
		{ 32314, "", "=q4=Green Riding Nether Ray", "=ds=#e12#" },
		{ 32317, "", "=q4=Red Riding Nether Ray", "=ds=#e12#" },
		{ 32316, "", "=q4=Purple Riding Nether Ray", "=ds=#e12#" },
		{ 32318, "", "=q4=Silver Riding Nether Ray", "=ds=#e12#" },
		{ 38628, "", "=q3=Nether Ray Fry", "=ds=#e13#" },
		{ 32445, "", "=q1=Skyguard Tabard", "=ds=#s7#" },
	};

	Sporeggar1 = {
		{ 0, "INV_Mushroom_10", "=q6=#r2#", "" },
		{ 27689, "", "=q1=Recipe: Sporeling Snack", "=ds=#p3# (310)", "2 #glowcap#" },
		{ 30156, "", "=q1=Recipe: Clam Bar", "=ds=#p3# (300)", "1 #glowcap#" },
		{ 25548, "", "=q1=Tallstalk Mushroom", "=ds=#e3#", "1 #glowcap#" },
		{ 24539, "", "=q1=Marsh Lichen", "=ds=#e3#", "2 #glowcap#" },
		{ 0,"","","" },
		{ 0, "INV_Mushroom_10", "=q6=#r3#", "" },
		{ 25827, "", "=q3=Muck-Covered Drape", "=ds=#s4#", "25 #glowcap#" },
		{ 25828, "", "=q3=Petrified Lichen Guard", "=ds=#w8#", "15 #glowcap#" },
		{ 25550, "", "=q1=Redcap Toadstool", "=ds=#e3#", "1 #glowcap#" },
		{ 0,"","","" },
		{ 24245, "", "=q1=Glowcap", "=ds=#m17#", "" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Mushroom_10", "=q6=#r4#", "" },
		{ 29150, "", "=q3=Hardened Stone Shard", "=ds=#h1#, #w4#", "45 #glowcap#" },
		{ 29149, "", "=q3=Sporeling's Firestick", "=ds=#w12#", "20 #glowcap#" },
		{ 22916, "", "=q2=Recipe: Transmute Primal Earth to Water", "=ds=#p1# (350)", "25 #glowcap#" },
		{ 38229, "", "=q1=Pattern: Mycah's Botanical Bag", "=ds=#p8# (375)", "25 #glowcap#" },
		{ 0,"","","" },
		{ 0, "INV_Mushroom_10", "=q6=#r5#", "" },
		{ 34478, "", "=q3=Tiny Spore Bat","=ds=#e13#" },
		{ 22906, "", "=q2=Recipe: Shrouding Potion", "=ds=#p1# (335)", "30 #glowcap#" },
		{ 31775, "", "=q1=Sporeggar Tabard", "=ds=#s7#" },
	};

	SunOffensive1 = {
		{ 0, "INV_Misc_Statue_04", "=q6=#r2#", "" },
		{ 35244, "", "=q1=Design: Bold Crimson Spinel", "=ds=#p12# (375)" },
		{ 35254, "", "=q1=Design: Bright Crimson Spinel", "=ds=#p12# (375)" },
		{ 35255, "", "=q1=Design: Brilliant Lionseye", "=ds=#p12# (375)" },
		{ 35246, "", "=q1=Design: Delicate Crimson Spinel", "=ds=#p12# (375)" },
		{ 35256, "", "=q1=Design: Gleaming Lionseye", "=ds=#p12# (375)" },
		{ 35262, "", "=q1=Design: Lustrous Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 35248, "", "=q1=Design: Runed Crimson Spinel", "=ds=#p12# (375)" },
		{ 35260, "", "=q1=Design: Smooth Lionseye", "=ds=#p12# (375)" },
		{ 35263, "", "=q1=Design: Solid Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 35264, "", "=q1=Design: Sparkling Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 35249, "", "=q1=Design: Subtle Crimson Spinel", "=ds=#p12# (375)" },
		{ 35250, "", "=q1=Design: Teardrop Crimson Spinel", "=ds=#p12# (375)" },
		{ 35261, "", "=q1=Design: Thick Lionseye", "=ds=#p12# (375)" },
		{ 34780, "", "=q1=Naaru Ration", "=ds=#e3#" },
		{ 0, "INV_Misc_Statue_04", "=q6=#r3#", "" },
		{ 35238, "", "=q1=Design: Balanced Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35251, "", "=q1=Design: Dazzling Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35266, "", "=q1=Design: Glinting Pyrestone", "=ds=#p12# (375)" },
		{ 35239, "", "=q1=Design: Glowing Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35240, "", "=q1=Design: Infused Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35253, "", "=q1=Design: Jagged Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35268, "", "=q1=Design: Luminous Pyrestone", "=ds=#p12# (375)" },
		{ 35269, "", "=q1=Design: Potent Pyrestone", "=ds=#p12# (375)" },
		{ 35254, "", "=q1=Design: Radiant Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35500, "", "=q1=Formula: Enchant Chest - Defense", "=ds=#p4# (360)" },
		{ 34872, "", "=q1=Formula: Void Shatter", "=ds=#p4# (375)" },
	};
		
	SunOffensive2 = {
		{ 35769, "", "=q4=Design: Forceful Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35768, "", "=q4=Design: Quick Lionseye", "=ds=#p12# (375)" },
		{ 35767, "", "=q4=Design: Reckless Pyrestone", "=ds=#p12# (375)" },
		{ 35766, "", "=q4=Design: Steady Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35252, "", "=q1=Design: Enduring Seaspray Emerald", "=ds=#p12# (375)" },
		{ 35259, "", "=q1=Design: Rigid Lionseye", "=ds=#p12# (375)" },
		{ 35241, "", "=q1=Design: Royal Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35271, "", "=q1=Design: Wicked Pyrestone", "=ds=#p12# (375)" },
		{ 34665, "", "=q3=Bombardier's Blade", "=ds=#h1#, #w4#" },
		{ 34667, "", "=q3=Archmage's Guile", "=ds=#h3#, #w10#" },
		{ 34672, "", "=q3=Inuuro's Blade", "=ds=#h1#, #w10#" },
		{ 34666, "", "=q3=The Sunbreaker", "=ds=#h1#, #w10#" },
		{ 34671, "", "=q3=K'iru's Presage", "=ds=#h3#, #w6#" },
		{ 34670, "", "=q3=Seeker's Gavel", "=ds=#h3#, #w6#" },
		{ 34673, "", "=q3=Legionfoe", "=ds=#h2#, #w1#" },
		{ 34674, "", "=q3=Truestrike Crossbow", "=ds=#w3#" },
		{ 29193, "", "=q2=Glyph of the Gladiator", "=ds=#s1# #e17#" },
		{ 0,"","","" },
		{ 35708, "", "=q1=Design: Regal Nightseye", "=ds=#p12# (350)" },
		{ 35505, "", "=q1=Design: Ember Skyfire Diamond", "=ds=#p12# (370)" },
		{ 35502, "", "=q1=Design: Eternal Earthstorm Diamond", "=ds=#p12# (370)" },
		{ 35697, "", "=q1=Design: Figurine - Crimson Serpent", "=ds=#p12# (375)" },
		{ 35695, "", "=q1=Design: Figurine - Empyrean Tortoise", "=ds=#p12# (375)" },
		{ 35696, "", "=q1=Design: Figurine - Khorium Boar", "=ds=#p12# (375)" },
		{ 35699, "", "=q1=Design: Figurine - Seaspray Albatross", "=ds=#p12# (375)" },
		{ 35698, "", "=q1=Design: Figurine - Shadowsong Panther", "=ds=#p12# (375)" },
	};
		
	SunOffensive3 = {
		{ 35322, "", "=q3=Design: Quick Dawnstone", "=ds=#p12# (350)" },
		{ 35323, "", "=q3=Design: Design: Reckless Noble Topaz", "=ds=#p12# (350)" },
		{ 35325, "", "=q3=Design: Forceful Talasite", "=ds=#p12# (350)" },
		{ 34678, "", "=q4=Shattered Sun Pendant of Acumen", "=ds=#s2#" },
		{ 34679, "", "=q4=Shattered Sun Pendant of Might", "=ds=#s2#" },
		{ 34680, "", "=q4=Shattered Sun Pendant of Resolve", "=ds=#s2#" },
		{ 34677, "", "=q4=Shattered Sun Pendant of Restoration", "=ds=#s2#" },
		{ 34676, "", "=q4=Dawnforged Defender", "=ds=#w8#" },
		{ 34675, "", "=q4=Sunward Crest", "=ds=#w8#" },
		{ 35247, "", "=q1=Design: Flashing Crimson Spinel", "=ds=#p12# (375)" },
		{ 35257, "", "=q1=Design: Great Lionseye", "=ds=#p12# (375)" },
		{ 35267, "", "=q1=Design: Inscribed Pyrestone", "=ds=#p12# (375)" },
		{ 35258, "", "=q1=Design: Mystic Lionseye", "=ds=#p12# (375)" },
		{ 37504, "", "=q1=Design: Purified Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35242, "", "=q1=Design: Shifting Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35243, "", "=q1=Design: Sovereign Shadowsong Amethyst", "=ds=#p12# (375)" },
		{ 35265, "", "=q1=Design: Stormy Empyrean Sapphire", "=ds=#p12# (375)" },
		{ 35270, "", "=q1=Design: Design: Veiled Pyrestone", "=ds=#p12# (375)" },
		{ 35755, "", "=q1=Recipe: Assassin's Alchemist Stone", "=ds=#p1# (375)" },
		{ 35752, "", "=q1=Recipe: Guardian's Alchemist Stone", "=ds=#p1# (375)" },
		{ 35754, "", "=q1=Recipe: Redeemer's Alchemist Stone", "=ds=#p1# (375)" },
		{ 35753, "", "=q1=Recipe: Sorcerer's Alchemist Stone", "=ds=#p1# (375)" },
		{ 35221, "", "=q1=Tabard of the Shattered Sund", "=ds=#s7#" },
	};

	Thrallmar1 = {
		{ 0, "INV_BannerPVP_01", "=q6=#r2#", "" },
		{ 25738, "", "=q3=Pattern: Felstalker Belt", "=ds=#p7# (350)" },
		{ 31359, "", "=q2=Design: Enduring Deep Peridot", "=ds=#p12# (315)" },
		{ 24000, "", "=q1=Formula: Enchant Bracer - Superior Healing", "=ds=#p4# (325)" },
		{ 24006, "", "=q1=Grunt's Waterskin", "=ds=#e4#" },
		{ 24009, "", "=q1=Dried Fruit Rations", "=ds=#e3#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_BannerPVP_01", "=q6=#r3#", "" },
		{ 25824, "", "=q3=Farseer's Band", "=ds=#s13#" },
		{ 25823, "", "=q3=Grunt's Waraxe", "=ds=#h1#, #w1#" },
		{ 25739, "", "=q3=Pattern: Felstalker Bracers", "=ds=#p7# (360)" },
		{ 25740, "", "=q3=Pattern: Felstalker Breastplate", "=ds=#p7# (360)" },
		{ 29197, "", "=q2=Glyph of Fire Warding", "=ds=#s1# #e17#" },
		{ 29232, "", "=q1=Recipe: Transmute Skyfire Diamond", "=ds=#p1# (350)" },
		{ 24001, "", "=q1=Recipe: Elixir of Major Agility", "=ds=#p1# (330)" },
		{ 31361, "", "=q1=Pattern: Cobrahide Leg Armor", "=ds=#p7# (335)" },
		{ 30637, "", "=q1=Flamewrought Key", "=ds=#e9#" },
	};

	Thrallmar2 = {
		{ 0, "INV_BannerPVP_01", "=q6=#r4#", "" },
		{ 29168, "", "=q3=Ancestral Band", "=ds=#s13#" },
		{ 29167, "", "=q3=Blackened Spear", "=ds=#w7#" },
		{ 32882, "", "=q3=Hellfire Shot", "=ds=#w18#" },
		{ 31358, "", "=q3=Design: Dawnstone Crab", "=ds=#p12# (370)" },
		{ 29190, "", "=q2=Glyph of Renewal", "=ds=#s1# #e17#" },
		{ 24003, "", "=q1=Formula: Enchant Chest - Exceptional Stats", "=ds=#p4# (345)" },
		{ 34201, "", "=q1=Pattern: Netherscale Ammo Pouch", "=ds=#p7# (350)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_BannerPVP_01", "=q6=#r5#", "" },
		{ 29155, "", "=q4=Stormcaller", "=ds=#h3#, #w10#" },
		{ 29165, "", "=q4=Warbringer", "=ds=#h1#, #w1#" },
		{ 29152, "", "=q4=Marksman's Bow", "=ds=#w2#" },
		{ 33151, "", "=q3=Formula: Enchant Cloak - Subtlety", "=ds=#p4# (300)" }, 
		{ 24002, "", "=q1=Plans: Felsteel Shield Spike", "=ds=#p2# (360)" },
		{ 31362, "", "=q1=Pattern: Nethercobra Leg Armor", "=ds=#p7# (365)" },
		{ 24004, "", "=q1=Thrallmar Tabard", "=ds=#s7#" },
	};

	Tranquillien1 = {
		{ 0, "INV_Misc_Bandana_03", "=q6=#r2#", "" },
		{ 22991, "", "=q2=Apprentice Boots", "=ds=#s12#, #a1# " },
		{ 22992, "", "=q2=Bogwalker Boots", "=ds=#s12#, #a2# " },
		{ 22993, "", "=q2=Volunteer's Greaves", "=ds=#s12#, #a3# " },
		{ 28164, "", "=q2=Tranquillien Flamberge", "=ds=#h2#, #w10#" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Bandana_03", "=q6=#r3#", "" },
		{ 28155, "", "=q2=Apothecary's Waistband", "=ds=#s10#, #a1# " },
		{ 28158, "", "=q2=Batskin Belt", "=ds=#s10#, #a2# " },
		{ 28162, "", "=q2=Tranquillien Defender's Girdle", "=ds=#s10#, #a3# " },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Bandana_03", "=q6=#r4#", "" },
		{ 22986, "", "=q2=Apothecary's Robe", "=ds=#s5#, #a1# " },
		{ 22987, "", "=q2=Deathstalker's Vest", "=ds=#s5#, #a2# " },
		{ 22985, "", "=q2=Suncrown Hauberk", "=ds=#s5#, #a3# " },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Bandana_03", "=q6=#r5#", "" },
		{ 22990, "", "=q3=Tranquillien Champion's Cloak", "=ds=#s4#" },
	};

	VioletEye1 = {
		{ 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Assassin"], "" },
		{ 29280, "", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
		{ 29281, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
		{ 29282, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
		{ 29283, "", "=q4=Violet Signet of the Master Assassin", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Mage"], "" },
		{ 29284, "", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
		{ 29285, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
		{ 29286, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
		{ 29287, "", "=q4=Violet Signet of the Archmage", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Restorer"], "" },
		{ 29288, "", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
		{ 29289, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
		{ 29291, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
		{ 29290, "", "=q4=Violet Signet of the Grand Restorer", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Protector"], "" },
		{ 29276, "", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
		{ 29277, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
		{ 29278, "", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
		{ 29279, "", "=q4=Violet Signet of the Great Protector", "=ds=#s13#, =q1=#r5#" },
	};

	VioletEye2 = {
		{ 0, "Ability_Warrior_ShieldMastery", "=q6=#r3#", "" },
		{ 31113, "", "=q4=Violet Badge", "=q1=#m4#: =ds=#s14#" },
		{ 31395, "", "=q4=Plans: Iceguard Helm", "=ds=#p2# (375)" },
		{ 31393, "", "=q4=Plans: Iceguard Breastplate", "=ds=#p2# (375)" },
		{ 31401, "", "=q4=Design: The Frozen Eye", "=ds=#p12# (375)" },
		{ 29187, "", "=q2=Inscription of Endurance", "=ds=#s3# #e17#" },
		{ 33209, "", "=q2=Recipe: Flask of Chromatic Wonder", "=ds=#p1# (375)" },
		{ 0,"","","" },
		{ 0, "Ability_Warrior_ShieldMastery", "=q6=#r4#", "" },
		{ 34581, "", "=q4=Mysterious Arrow", "=ds=#w17#" },
		{ 34582, "", "=q4=Mysterious Shell", "=ds=#w18#" },
		{ 31394, "", "=q4=Plans: Iceguard Leggings", "=ds=#p2# (375)" },
		{ 33205, "", "=q4=Pattern: Shadowprowler's Chestguard", "=ds=#p7# (365)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "Ability_Warrior_ShieldMastery", "=q6=#r5#", "" },
		{ 33124, "", "=q3=Pattern: Cloak of Darkness", "=ds=#p7# (360)" },
		{ 33165, "", "=q1=Formula: Enchant Weapon - Greater Agility", "=ds=#p4# (350)" },
	};
	
------------------------
--- Classic Factions ---
------------------------

	AQBroodRings = {
		{ 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Conqueror"], "" },
		{ 21201, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r1#" },
		{ 21202, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r2#" },
		{ 21203, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r3#" },
		{ 21204, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r4#" },
		{ 21205, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Invoker"], "" },
		{ 21206, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r1#" },
		{ 21207, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r2#" },
		{ 21208, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r3#" },
		{ 21209, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r4#" },
		{ 21210, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r5#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Protector"], "" },
		{ 21196, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r1#" },
		{ 21197, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r2#" },
		{ 21198, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r3#" },
		{ 21199, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r4#" },
		{ 21200, "", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r5#" },
	};

	Argent1 = {
		{ 22689, "", "=q3=Sanctified Leather Helm", "=ds=#s1#, #a2#" },
		{ 22690, "", "=q3=Leggings of the Plague Hunter", "=ds=#s11#, #a3#" },
		{ 22681, "", "=q3=Band of Piety", "=ds=#s13#" },
		{ 22680, "", "=q3=Band of Resolution", "=ds=#s13#" },
		{ 22688, "", "=q3=Verimonde's Last Resort", "=ds=#h3#, #w4#" },
		{ 22679, "", "=q3=Supply Bag", "=ds=#m14# #e1#" },
		{ 0,"","","" },
		{ 22638, "", "=q3=Shadow Guard", "=ds=#s1# #e17#" },
		{ 0,"","","" },
		{ 22523, "", "=q2=Insignia of the Dawn", "=ds=#m17#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 22667, "", "=q4=Bracers of Hope", "=ds=#s8#, #a1#" },
		{ 22668, "", "=q4=Bracers of Subterfuge", "=ds=#s8#, #a2#" },
		{ 22657, "", "=q4=Amulet of the Dawn", "=ds=#s2#" },
		{ 22659, "", "=q4=Medallion of the Dawn", "=ds=#s2#" },
		{ 22678, "", "=q4=Talisman of Ascendance", "=ds=#s14#" },
		{ 22656, "", "=q4=The Purifier", "=ds=#w5#" },
		{ 0,"","","" },
		{ 22636, "", "=q3=Ice Guard", "=ds=#s1# #e17#" },
		{ 0,"","","" },
		{ 22524, "", "=q2=Insignia of the Crusade", "=ds=#m17#" },
	};

	Argent2 = {
		{ 0, "INV_Jewelry_Talisman_08", "=q6=#r2#", "" },
		{ 13724, "", "=q1=Enriched Manna Biscuit", "=ds=#e3#" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Talisman_08", "=q6=#r3#", "" },
		{ 13482, "", "=q2=Recipe: Transmute Air to Fire", "=ds=#p1# (275)" },
		{ 19203, "", "=q1=Plans: Girdle of the Dawn", "=ds=#p2# (290)" },
		{ 19446, "", "=q1=Formula: Enchant Bracer - Mana Regeneration", "=ds=#p4# (290)" },
		{ 19442, "", "=q1=Formula: Powerful Anti-Venom", "=ds=#p6# (300)" },
		{ 19328, "", "=q1=Pattern: Dawn Treaders", "=ds=#p7# (290)" },
		{ 19216, "", "=q1=Pattern: Argent Boots", "=ds=#p8# (290)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 12844, "", "=q2=Argent Dawn Valor Token", "=ds=#m17#" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Talisman_08", "=q6=#r4#", "" },
		{ 18171, "", "=q2=Arcane Mantle of the Dawn", "=ds=#s3# #e17#" },
		{ 18169, "", "=q2=Flame Mantle of the Dawn", "=ds=#s3# #e17#" },
		{ 18170, "", "=q2=Frost Mantle of the Dawn", "=ds=#s3# #e17#" },
		{ 18172, "", "=q2=Nature Mantle of the Dawn", "=ds=#s3# #e17#" },
		{ 18173, "", "=q2=Shadow Mantle of the Dawn", "=ds=#s3# #e17#" },
		{ 19205, "", "=q1=Plans: Gloves of the Dawn", "=ds=#p2# (300)" },
		{ 19447, "", "=q1=Formula: Enchant Bracer - Healing", "=ds=#p4# (300)" },
		{ 19329, "", "=q1=Pattern: Golden Mantle of the Dawn", "=ds=#p7# (300)" },
		{ 19217, "", "=q1=Pattern: Argent Shoulders", "=ds=#p8# (300)" },
		{ 13810, "", "=q1=Blessed Sunfruit", "=ds=#e3#" },
		{ 13813, "", "=q1=Blessed Sunfruit Juice", "=ds=#e4#" },
		{ 0,"","","" },
		{ 0, "INV_Jewelry_Talisman_08", "=q6=#r5#", "" },
		{ 18182, "", "=q2=Chromatic Mantle of the Dawn", "=ds=#s3# #e17#" },
	};

	Bloodsail1 = {
		{ 0, "INV_Helmet_66", "=q6=#r1#", "" },
		{ 22742, "", "=q1=Bloodsail Shirt", "=ds=#s5#" },
		{ 22743, "", "=q1=Bloodsail Sash", "=ds=#s10#" },
		{ 22745, "", "=q1=Bloodsail Pants", "=ds=#s11#" },
		{ 22744, "", "=q1=Bloodsail Boots", "=ds=#s12#" },
		{ 0,"","","" },
		{ 0, "INV_Helmet_66", "=q6=#r2#", "" },
		{ 12185, "", "=q2=Bloodsail Admiral's Hat", "=ds=#s1#, #a1#" },
	};

	Cenarion1 = {
		{ 22209, "", "=q1=Plans: Heavy Obsidian Belt", "=ds=#p2# (300)" },
		{ 22768, "", "=q1=Plans: Ironvine Belt", "=ds=#p2# (300)" },
		{ 20732, "", "=q1=Formula: Enchant Cloak - Greater Fire Resistance", "=ds=#p4# (300)" },
		{ 22769, "", "=q1=Pattern: Bramblewood Belt", "=ds=#p7# (300)" },
		{ 20509, "", "=q1=Pattern: Sandstalker Bracers", "=ds=#p7# (300)" },
		{ 20506, "", "=q1=Pattern: Spitfire Bracers", "=ds=#p7# (300)" },
		{ 22772, "", "=q1=Pattern: Sylvan Shoulders", "=ds=#p8# (300)" },
		{ 22310, "", "=q1=Pattern: Cenarion Herb Bag", "=ds=#p8# (275)" },
		{ 0,"","","" },
		{ 20802, "", "=q2=Cenarion Combat Badge", "=ds=#m17#" },
		{ 20800, "", "=q2=Cenarion Logistics Badge", "=ds=#m17#" },
		{ 21515, "", "=q2=Mark of Remulos", "=ds=#m17#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
		{ 21187, "", "=q3=Earthweave Cloak", "5 #ccombat# 3 #clogistics# 7 #ctactical#" },
		{ 21178, "", "=q3=Gloves of Earthen Power", "5 #ccombat# 3 #clogistics# 7 #ctactical#" },
		{ 21179, "", "=q3=Band of Earthen Wrath", "5 #ccombat# 3 #clogistics# 7 #ctactical#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 20801, "", "=q2=Cenarion Tactical Badge", "=ds=#m17#" },
		{ 21508, "", "=q2=Mark of Cenarius", "=ds=#m17#" },
	};

	Cenarion2 = {
		{ 22767, "", "=q1=Plans: Ironvine Gloves", "=ds=#p2# (300)" },
		{ 22214, "", "=q1=Plans: Light Obsidian Belt", "=ds=#p2# (300)" },
		{ 20733, "", "=q1=Formula: Enchant Cloak - Greater Nature Resistance", "=ds=#p4# (300)" },
		{ 22770, "", "=q1=Pattern: Bramblewood Boots", "=ds=#p7# (300)" },
		{ 20510, "", "=q1=Pattern: Sandstalker Gauntlets", "=ds=#p7# (300)" }, 
		{ 20507, "", "=q1=Pattern: Spitfire Gauntlets", "=ds=#p7# (300)" },
		{ 22773, "", "=q1=Pattern: Sylvan Crown", "=ds=#p8# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
		{ 21183, "", "=q3=Earthpower Vest", "7 #ccombat# 4 #clogistics# 4 #ctactical#" },
		{ 21182, "", "=q3=Band of Earthen Might", "7 #ccombat# 4 #clogistics# 4 #ctactical#" },
		{ 21181, "", "=q3=Grace of Earth", "7 #ccombat# 4 #clogistics# 4 #ctactical#" },
	};

	Cenarion3 = {
		{ 22766, "", "=q1=Plans: Ironvine Breastplate", "=ds=#p2# (300)" },
		{ 22219, "", "=q1=Plans: Jagged Obsidian Shield", "=ds=#p2# (300)" },
		{ 22771, "", "=q1=Pattern: Bramblewood Helm", "=ds=#p7# (300)" },
		{ 20511, "", "=q1=Pattern: Sandstalker Breastplate", "=ds=#p7# (300)" },
		{ 20508, "", "=q1=Pattern: Spitfire Breastplate", "=ds=#p7# (300)" },
		{ 22683, "", "=q1=Pattern: Gaea's Embrace", "=ds=#p8# (300)" },
		{ 22312, "", "=q1=Pattern: Satchel of Cenarius", "=ds=#p8# (300)" },
		{ 22774, "", "=q1=Pattern: Sylvan Vest", "=ds=#p8# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
		{ 21186, "", "=q4=Rockfury Bracers", "15 #ccombat# 20 #clogistics# 17 #ctactical# 1 #cremulos#" },
		{ 21184, "", "=q4=Deeprock Bracers", "15 #ccombat# 20 #clogistics# 17 #ctactical# 1 #cremulos#" },
		{ 21189, "", "=q4=Might of Cenarius", "15 #ccombat# 20 #clogistics# 17 #ctactical# 1 #cremulos#" },
		{ 21185, "", "=q4=Earthcalm Orb", "15 #ccombat# 20 #clogistics# 17 #ctactical# 1 #cremulos#" },
	};

	Cenarion4 = {
		{ 22221, "", "=q1=Plans: Obsidian Mail Tunic", "=ds=#p2# (300)" },
		{ 20382, "", "=q1=Pattern: Dreamscale Breastplate", "=ds=#p7# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
		{ 21190, "", "=q4=Wrath of Cenarius", "15 #ccombat# 20 #clogistics# 20 #ctactical# 1 #ccenarius#" },
		{ 21180, "", "=q4=Earthstrike", "15 #ccombat# 20 #clogistics# 20 #ctactical# 1 #ccenarius#" },
		{ 21188, "", "=q4=Fist of Cenarius", "15 #ccombat# 20 #clogistics# 20 #ctactical# 1 #ccenarius#", "" },		
	};

	Darkmoon1 = {
		{ 19491, "", "=q4=Amulet of the Darkmoon", "=ds=#s2#", "1200 #darkmoon#", ""},   
		{ 19426, "", "=q4=Orb of the Darkmoon", "=ds=#s2#", "1200 #darkmoon#" },
		{ 19296, "", "=q2=Greater Darkmoon Prize", "40 #darkmoon#" },
		{ 19297, "", "=q2=Lesser Darkmoon Prize", "12 #darkmoon#" },
		{ 19298, "", "=q2=Minor Darkmoon Prize", "5 #darkmoon#" },
		{ 19291, "", "=q1=Darkmoon Storage Box", "50 #darkmoon#" },
		{ 19293, "", "=q1=Last Year's Mutton", "=ds=#h1#, #w6#", "50 #darkmoon#" },
		{ 22729, "", "=q1=Schematic: Steam Tonk Controller", "=ds=#p5# (275)", "40 #darkmoon#" },
		{ 19292, "", "=q1=Last Month's Mutton", "=ds=#h1#, #w6#", "10 #darkmoon#" },
		{ 19295, "", "=q1=Darkmoon Flower", "=ds=#s15#", "5 #darkmoon#" },
		{ 0,"","","" },
		{ 19182, "", "=q1=Darkmoon Faire Prize Ticket", "=ds=#m17#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 19303, "", "=q3=Darkmoon Necklace", "=ds=#s2#" },
		{ 19302, "", "=q3=Darkmoon Ring", "=ds=#s13#" },
		{ 0,"","","" },
		{ 11026, "", "=q1=Tree Frog Box", "=ds=#e13#" },
		{ 11027, "", "=q1=Wood Frog Box", "=ds=#e13#" },
		{ 19450, "", "=q1=A Jubling's Tiny Home", "=q1=#m4#: =ds=#e13#" }, 
	};

	Darkmoon2 = {
		{ 19228, "", "=q4=Beasts Deck", "=ds=#m2#" },
		{ 19288, "", "=q4=Darkmoon Card: Blue Dragon", "=q1=#m4#: =ds=#s14#"},
		{ 0,"","","" },
		{ 19267, "", "=q4=Elementals Deck", "=ds=#m2#" },
		{ 19289, "", "=q4=Darkmoon Card: Maelstrom", "=q1=#m4#: =ds=#s14#"},
		{ 0,"","","" },
		{ 19257, "", "=q4=Warlords Deck", "=ds=#m2#" },
		{ 19287, "", "=q4=Darkmoon Card: Heroism", "=q1=#m4#: =ds=#s14#"},
		{ 0,"","","" },
		{ 19277, "", "=q4=Portals Deck", "=ds=#m2#" },
		{ 19290, "", "=q4=Darkmoon Card: Twisting Nether", "=q1=#m4#: =ds=#s14#"},
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 31907, "", "=q4=Furies Deck", "=ds=#m2#" },
		{ 31858, "", "=q4=Darkmoon Card: Vengeance", "=q1=#m4#: =ds=#s14#" },
		{ 0,"","","" },
		{ 31891, "", "=q4=Storms Deck", "=ds=#m2#" },
		{ 31857, "", "=q4=Darkmoon Card: Wrath", "=q1=#m4#: =ds=#s14#" },
		{ 0,"","","" },
		{ 31890, "", "=q4=Blessings Deck", "=ds=#m2#" },
		{ 31856, "", "=q4=Darkmoon Card: Crusade", "=q1=#m4#: =ds=#s14#" },
		{ 0,"","","" },
		{ 31914, "", "=q4=Lunacy Deck", "=ds=#m2#" },
		{ 31859, "", "=q4=Darkmoon Card: Madness", "=q1=#m4#: =ds=#s14#" },
	};

	Defilers = {
		{ 0, "INV_Jewelry_Amulet_07", "=q6=#r5#", "" },
		{ 20131, "", "=q1=Battle Tabard of the Defilers", "=q1=#m4#: =ds=#s7#" },
	};

	Frostwolf1 = {
		{ 17909, "", "=q4=Frostwolf Insignia Rank 6", "=ds=#s14#, =q1=#r5#" },
		{ 17908, "", "=q3=Frostwolf Insignia Rank 5", "=ds=#s14#, =q1=#r5#" },
		{ 17907, "", "=q3=Frostwolf Insignia Rank 4", "=ds=#s14#, =q1=#r4#" },
		{ 17906, "", "=q2=Frostwolf Insignia Rank 3", "=ds=#s14#, =q1=#r3#" },
		{ 17905, "", "=q2=Frostwolf Insignia Rank 2", "=ds=#s14#, =q1=#r2#" },
		{ 17690, "", "=q2=Frostwolf Insignia Rank 1", "=ds=#s14#, =q1=#r1#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 20648, "", "=q3=Cold Forged Hammer", "=q1=#m4#: =ds=#h3#, #w6#" },
		{ 19106, "", "=q3=Ice Barbed Spear", "=q1=#m4#: =ds=#w7#" },
		{ 19108, "", "=q3=Wand of Biting Cold", "=q1=#m4#: =ds=#w12#" },
		{ 19107, "", "=q3=Bloodseeker", "=q1=#m4#: =ds=#w3#" },
	};

	GelkisClan1 = {
		{ 0, "INV_Misc_Head_Centaur_01", "=q6=#r2#", "" },
		{ 6773, "", "=q2=Gelkis Marauder Chain", "=q1=#m4#: =ds=#s5#, #a3#" },
		{ 6774, "", "=q2=Uthek's Finger", "=q1=#m4#: =ds=#s15#" },
	};

	LeagueofArathor = {
		{ 0, "INV_Jewelry_Amulet_07", "=q6=#r5#", "" },
		{ 20132, "", "=q1=Arathor Battle Tabard", "=q1=#m4#: =ds=#s7#" },
	};

	MagramClan1 = {
		{ 0, "INV_Misc_Head_Centaur_01", "=q6=#r2#", "" },
		{ 6789, "", "=q2=Ceremonial Centaur Blanket", "=q1=#m4#: =ds=#s4#" },
		{ 6788, "", "=q2=Magram Hunter's Belt", "=q1=#m4#: =ds=#s10#, #a2#" },
	};

	Stormpike1 = {
		{ 17904, "", "=q4=Stormpike Insignia Rank 6", "=ds=#s14#, =q1=#r5#" },
		{ 17903, "", "=q3=Stormpike Insignia Rank 5", "=ds=#s14#, =q1=#r5#" },
		{ 17902, "", "=q3=Stormpike Insignia Rank 4", "=ds=#s14#, =q1=#r4#" },
		{ 17901, "", "=q2=Stormpike Insignia Rank 3", "=ds=#s14#, =q1=#r3#" },
		{ 17900, "", "=q2=Stormpike Insignia Rank 2", "=ds=#s14#, =q1=#r2#" },
		{ 17691, "", "=q2=Stormpike Insignia Rank 1", "=ds=#s14#, =q1=#r1#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 20648, "", "=q3=Cold Forged Hammer", "=q1=#m4#: =ds=#h3#, #w6#" },
		{ 19106, "", "=q3=Ice Barbed Spear", "=q1=#m4#: =ds=#w7#" },
		{ 19108, "", "=q3=Wand of Biting Cold", "=q1=#m4#: =ds=#w12#" },
		{ 19107, "", "=q3=Bloodseeker", "=q1=#m4#: =ds=#w3#" },
	};

	Thorium1 = {
		{ 0, "INV_Ingot_Mithril", "=q6=#r2#", "" },
		{ 17051, "", "=q3=Plans: Dark Iron Bracers", "=ds=#p2# (295)" },
		{ 20761, "", "=q1=Recipe: Transmute Elemental Fire", "=ds=#p1# (300)" },
		{ 19444, "", "=q1=Formula: Enchant Weapon - Strength", "=ds=#p4# (290)" },
		{ 17023, "", "=q1=Pattern: Molten Helm", "=ds=#p7# (300)" },
		{ 17022, "", "=q1=Pattern: Corehound Boots", "=ds=#p7# (295)" },
		{ 17018, "", "=q1=Pattern: Flarecore Gloves", "=ds=#p8# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Ingot_Mithril", "=q6=#r3#", "" },
		{ 17060, "", "=q3=Plans: Dark Iron Destroyer", "=ds=#p2# (300)" },
		{ 17059, "", "=q3=Plans: Dark Iron Reaver", "=ds=#p2# (300)" },
		{ 17049, "", "=q3=Plans: Fiery Chain Girdle", "=ds=#p2# (295)" },
		{ 19206, "", "=q1=Plans: Dark Iron Helm", "=ds=#p2# (300)" },
		{ 19448, "", "=q1=Formula: Enchant Weapon - Mighty Spirit", "=ds=#p4# (300)" },  
		{ 17025, "", "=q1=Pattern: Black Dragonscale Boots", "=ds=#p7# (300)" },
		{ 19330, "", "=q1=Pattern: Lava Belt", "=ds=#p7# (300)" },
		{ 17017, "", "=q1=Pattern: Flarecore Mantle", "=ds=#p8# (300)" },
		{ 19219, "", "=q1=Pattern: Flarecore Robe", "=ds=#p8# (300)" },
	};

	Thorium2 = {
		{ 0, "INV_Ingot_Mithril", "=q6=#r4#", "" },
		{ 18592, "", "=q4=Plans: Sulfuron Hammer", "=ds=#p2# (300), #m4#" },
		{ 17052, "", "=q3=Plans: Dark Iron Leggings", "=ds=#p2# (300)" },
		{ 17053, "", "=q3=Plans: Fiery Chain Shoulders", "=ds=#p2# (300)" },
		{ 19209, "", "=q1=Plans: Blackfury", "=ds=#p2# (300)" },  
		{ 19208, "", "=q1=Plans: Black Amnesty", "=ds=#p2# (300)" },
		{ 19207, "", "=q1=Plans: Dark Iron Gauntlets", "=ds=#p2# (300)" },
		{ 19449, "", "=q1=Formula: Enchant Weapon - Mighty Intellect", "=ds=#p4# (300)" }, 
		{ 19331, "", "=q1=Pattern: Chromatic Gauntlets", "=ds=#p7# (300)" },
		{ 19332, "", "=q1=Pattern: Corehound Belt", "=ds=#p7# (300)" }, 
		{ 19333, "", "=q1=Pattern: Molten Belt", "=ds=#p7# (300)" },
		{ 19220, "", "=q1=Pattern: Flarecore Leggings", "=ds=#p8# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Ingot_Mithril", "=q6=#r5#", "" },
		{ 19211, "", "=q1=Plans: Blackguard", "=ds=#p2# (300)" },
		{ 20040, "", "=q1=Plans: Dark Iron Boots", "=ds=#p2# (300)" },	
		{ 19210, "", "=q1=Plans: Ebon Hand", "=ds=#p2# (300)" },  
		{ 19212, "", "=q1=Plans: Nightfall", "=ds=#p2# (300)" },
	};

	Timbermaw = {
		{ 0, "INV_Misc_Horn_01", "=q6=#r2#", "" },
		{ 13484, "", "=q2=Recipe: Transmute Earth to Water","=ds=#p1# (275)" },
		{ 22392, "", "=q1=Formula: Enchant 2H Weapon - Agility","=ds=#p4# (290)" },
		{ 20254, "", "=q1=Pattern: Warbear Woolies","=ds=#p7# (285)" },
		{ 20253, "", "=q1=Pattern: Warbear Harness","=ds=#p7# (275)" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Horn_01", "=q6=#r3#", "" },
		{ 16768, "", "=q2=Furbolg Medicine Pouch", "=ds=#s15#" },
		{ 16769, "", "=q2=Furbolg Medicine Totem", "=ds=#h3#, #w6#" },
		{ 19202, "", "=q1=Plans: Heavy Timbermaw Belt","=ds=#p2# (290)" },
		{ 19445, "", "=q1=Formula: Enchant Weapon - Agility","=ds=#p4# (290)" },
		{ 19326, "", "=q1=Pattern: Might of the Timbermaw","=ds=#p7# (290)" },
		{ 19215, "", "=q1=Pattern: Wisdom of the Timbermaw","=ds=#p8# (290)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Horn_01", "=q6=#r4#", "" },
		{ 19204, "", "=q1=Plans: Heavy Timbermaw Boots","=ds=#p2# (300)" },
		{ 19327, "", "=q1=Pattern: Timbermaw Brawlers","=ds=#p7# (300)" },  
		{ 19218, "", "=q1=Pattern: Mantle of the Timbermaw","=ds=#p8# (300)" },  
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Horn_01", "=q6=#r5#", "" },		
		{ 21326, "", "=q4=Defender of the Timbermaw", "=q1=#m4#: =ds=#s14#"},
	};

	WaterLords1 = {
		{ 0, "Spell_Frost_SummonWaterElemental_2", "=q6=#r3#", "" },
		{ 18399, "", "=q3=Ocean's Breeze", "=q1=#m4#: =ds=#s13#" },
		{ 18398, "", "=q3=Tidal Loop", "=q1=#m4#: =ds=#s13#" },
		{ 17333, "", "=q1=Aqual Quintessence", "=ds=#m3#" },
		{ 0,"","","" },
		{ 0, "Spell_Frost_SummonWaterElemental_2", "=q6=#r4#", "" },
		{ 22754, "", "=q1=Eternal Quintessence", "=ds=#m3#" },
	};

	Wintersaber1 = {
		{ 0, "Ability_Mount_PinkTiger", "=q6=#r5#", "" },
		{ 13086, "", "=q4=Reins of the Winterspring Frostsaber", "=ds=#e12#" },
	};

	Zandalar1 = {
		{ 0, "INV_Misc_Coin_08", "=q6=#r2#", "" },
		{ 20012, "", "=q1=Recipe: Greater Dreamless Sleep", "=ds=#p1# (275)" },
		{ 19778, "", "=q1=Plans: Bloodsoul Gauntlets", "=ds=#p2# (300)" },
		{ 19781, "", "=q1=Plans: Darksoul Shoulders", "=ds=#p2# (300)" },
		{ 20757, "", "=q1=Formula: Brilliant Mana Oil", "=ds=#p4# (300)" },
		{ 20001, "", "=q1=Schematic: Bloodvine Lens", "=ds=#p5# (300)" },
		{ 19771, "", "=q1=Pattern: Primal Batskin Bracers", "=ds=#p7# (300)" },
		{ 19766, "", "=q1=Pattern: Bloodvine Boots", "=ds=#p8# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 19858, "", "=q2=Zandalar Honor Token", "=ds=#m17#" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Coin_08", "=q6=#r3#", "" },
		{ 20014, "", "=q1=Recipe: Major Troll's Blood Potion", "=ds=#p1# (290)" },
		{ 19777, "", "=q1=Plans: Bloodsoul Shoulders", "=ds=#p2# (300)" },
		{ 19780, "", "=q1=Plans: Darksoul Leggings", "=ds=#p2# (300)" },
		{ 20756, "", "=q1=Formula: Brilliant Wizard Oil", "=ds=#p4# (300)" },
		{ 20000, "", "=q1=Schematic: Bloodvine Goggles", "=ds=#p5# (300)" },
		{ 19773, "", "=q1=Pattern: Blood Tiger Shoulders", "=ds=#p7# (300)" },
		{ 19770, "", "=q1=Pattern: Primal Batskin Gloves", "=ds=#p7# (300)" },
		{ 19765, "", "=q1=Pattern: Bloodvine Leggings", "=ds=#p8# (300)" },
		{ 20031, "", "=q1=Essence Mango", "=ds=#e3#", "1 #zandalar#" },
	};

	Zandalar2 = {
		{ 0, "INV_Misc_Coin_08", "=q6=#r4#", "" },
		{ 20080, "", "=q2=Sheen of Zanza", "=ds=#e2#", "3 #zandalar#" },
		{ 20079, "", "=q2=Spirit of Zanza", "=ds=#e2#", "3 #zandalar#" },
		{ 20081, "", "=q2=Swiftness of Zanza", "=ds=#e2#", "3 #zandalar#" },
		{ 20011, "", "=q1=Recipe: Mageblood Potion", "=ds=#p1# (275)" },
		{ 19776, "", "=q1=Plans: Bloodsoul Breastplate", "=ds=#p2# (300)" },
		{ 19779, "", "=q1=Plans: Darksoul Breastplate", "=ds=#p2# (300)" },
		{ 19772, "", "=q1=Pattern: Blood Tiger Breastplate", "=ds=#p7# (300)" },
		{ 19769, "", "=q1=Pattern: Primal Batskin Jerkin", "=ds=#p7# (300)" },
		{ 19764, "", "=q1=Pattern: Bloodvine Vest", "=ds=#p8# (300)" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0,"","","" },
		{ 0, "INV_Misc_Coin_08", "=q6=#r5#", "" },
		{ 20077, "", "=q3=Zandalar Signet of Might", "=ds=#s3# #e17#", "15 #zandalar#" },
		{ 20076, "", "=q3=Zandalar Signet of Mojo", "=ds=#s3# #e17#", "15 #zandalar#" },
		{ 20078, "", "=q3=Zandalar Signet of Serenity", "=ds=#s3# #e17#", "15 #zandalar#" },
		{ 20013, "", "=q1=Recipe: Living Action Potion", "=ds=#p1# (285)" },
	};

};