﻿--[[
Name: LibBabble-Rare-3.0
Revision: $Rev$
Maintainers: Celellach
Website: http://www.atlasloot.net/phpBB3/index.php
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-Rare-3.0"
local MINOR_VERSION = 90000 + 1--tonumber(("$Rev$"):match("%d+")) -- Add this with new svn ;)

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	Aeonaxx = "Aeonaxx",
	Akkalar = "Akkalar",
	Akkalou = "Akkalou",
	["Akma'hat"] = "Akma'hat",
	Alani = "Alani",
	Ankha = "Ankha",
	Anthriss = "Anthriss",
	Arcturis = "Arcturis",
	Armagedillo = "Armagedillo",
	["Armbreaker Huffaz"] = "Armbreaker Huffaz",
	["Ban'thalos"] = "Ban'thalos",
	["Barrel of Banana Infused Rum"] = "Barrel of Banana Infused Rum",
	Blazewing = "Blazewing",
	Bloodtooth = "Bloodtooth",
	Bristlespine = "Bristlespine",
	["Bro'Gaz the Clanless"] = "Bro'Gaz the Clanless",
	["Burgy Blackheart"] = "Burgy Blackheart",
	["Cache of Pilfered Goods"] = "Cache of Pilfered Goods",
	["Captain Florence"] = "Captain Florence",
	["Captain Foulwind"] = "Captain Foulwind",
	Clamstok = "Clamstok",
	["Clawlord Kril'mandar"] = "Clawlord Kril'mandar",
	["Cyrus the Black"] = "Cyrus the Black",
	["Dalan Nightbreaker"] = "Dalan Nightbreaker",
	Damlak = "Damlak",
	["Darkscreecher Akkarai"] = "Darkscreecher Akkarai",
	["Dart's Nest"] = "Dart's Nest",
	["Deth'tilac"] = "Deth'tilac",
	["Disha Fearwarden"] = "Disha Fearwarden",
	["Dormus the Camel-Hoarder"] = "Dormus the Camel-Hoarder",
	["Equipment Locker"] = "Equipment Locker",
	["Fel Tinkerer Zortan"] = "Fel Tinkerer Zortan",
	["Fixxul Lonelyheart"] = "Fixxul Lonelyheart",
	Forgosh = "Forgosh",
	["Frozen Trail Packer"] = "Frozen Trail Packer",
	["G'nathus"] = "G'nathus",
	Garr = "Garr",
	["Gezzarak the Huntress"] = "Gezzarak the Huntress",
	Ghostcrawler = "Ghostcrawler",
	["Ghostly Pandaren Craftsman"] = "Ghostly Pandaren Craftsman",
	["Ghostly Pandaren Fisherman"] = "Ghostly Pandaren Fisherman",
	Glimmer = "Glimmer",
	["Glinting Rapana Whelk"] = "Glinting Rapana Whelk",
	Golgarok = "Golgarok",
	Gondria = "Gondria",
	["Gorgolon the All-seeing"] = "Gorgolon the All-seeing",
	["Gul'bor"] = "Gul'bor",
	Hexapos = "Hexapos",
	["Huggalon the Heart Watcher"] = "Huggalon the Heart Watcher",
	Jadefang = "Jadefang",
	["Jade Warrior Statue"] = "Jade Warrior Statue",
	["Julak-Doom"] = "Julak-Doom",
	["Kar Warmaker"] = "Kar Warmaker",
	Karkin = "Karkin",
	Karoma = "Karoma",
	Karrog = "Karrog",
	["King Dorfbruiser"] = "King Dorfbruiser",
	Kirix = "Kirix",
	Kishak = "Kishak",
	["Lady La-La"] = "Lady La-La",
	["Lorbu Sadsummon"] = "Lorbu Sadsummon",
	Madexx = "Madexx",
	Magria = "Magria",
	["Malevus the Mad"] = "Malevus the Mad",
	["Martar the Not-So-Smart"] = "Martar the Not-So-Smart",
	["Matron Li-sahar"] = "Matron Li-sahar",
	["Mavis Harms"] = "Mavis Harms",
	Mobus = "Mobus",
	Muerta = "Muerta",
	["Mysterious Camel Figurine"] = "Mysterious Camel Figurine",
	["Odd'nirok"] = "Odd'nirok",
	["Overlord Sunderfury"] = "Overlord Sunderfury",
	Patrannache = "Patrannache",
	Pengsong = "Pengsong",
	["Porfus the Gem Gorger"] = "Porfus the Gem Gorger",
	Portent = "Portent",
	Poseidus = "Poseidus",
	["Ra'sha"] = "Ra'sha",
	["Ravasaur Matriarch's Nest"] = "Ravasaur Matriarch's Nest",
	["Razormaw Matriarch's Nest"] = "Razormaw Matriarch's Nest",
	["Rockhide the Immovable"] = "Rockhide the Immovable",
	Sambas = "Sambas",
	Savage = "Savage",
	Scotty = "Scotty",
	["Shok'sharak"] = "Shok'sharak",
	Skarr = "Skarr",
	Skitterflame = "Skitterflame",
	Skoll = "Skoll",
	Solix = "Solix",
	["Solus the Eternal"] = "Solus the Eternal",
	["Sprite's Cloth Chest"] = "Sprite's Cloth Chest",
	Stompy = "Stompy",
	["Sungraze Behemoth"] = "Sungraze Behemoth",
	["Takk's Nest"] = "Takk's Nest",
	["Tarvus the Vile"] = "Tarvus the Vile",
	Terborus = "Terborus",
	Terokk = "Terokk",
	Terrorpene = "Terrorpene",
	["Thartuk the Exile"] = "Thartuk the Exile",
	["The Behemoth"] = "The Behemoth",
	["Time-Lost Proto Drake"] = "Time-Lost Proto Drake",
	Trelopades = "Trelopades",
	["Ubunti the Shade"] = "Ubunti the Shade",
	["Vakkiz the Windrager"] = "Vakkiz the Windrager",
	["Wild Onyx Serpent"] = "Wild Onyx Serpent",
	["Wrathbringer Laz-tarash"] = "Wrathbringer Laz-tarash",
	Xariona = "Xariona",
	["Zandalari Warbringer"] = "Zandalari Warbringer",
	Zhing = "Zhing",
}

if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)
elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations {
	Aeonaxx = "Aeonaxx",
	Akkalar = "Akkalar",
	Akkalou = "Akkalou",
	["Akma'hat"] = "Akma'hat",
	Alani = "Alani",
	Ankha = "Ankha",
	Anthriss = "Anthriss",
	Arcturis = "Arcturis",
	Armagedillo = "Armagürtlon",
	["Armbreaker Huffaz"] = "Armbrecher Huffaz",
	["Ban'thalos"] = "Ban'thalos",
	["Barrel of Banana Infused Rum"] = "Fass mit Bananenrum",
	Blazewing = "Flammenschwinge",
	Bloodtooth = "Blutreißer",
	Bristlespine = "Grannenkiefer",
	["Bro'Gaz the Clanless"] = "Bro'Gaz der Klanlose",
	["Burgy Blackheart"] = "Bürgi Schwarzherz",
	["Cache of Pilfered Goods"] = "Truhe mit geklauten Waren",
	["Captain Florence"] = "Kapitän Florence",
	["Captain Foulwind"] = "Kapitän Faulwind",
	Clamstok = "Muschelstok",
	["Clawlord Kril'mandar"] = "Scherenfürst Kril'mandar",
	["Cyrus the Black"] = "Cyrus der Schwarze",
	["Dalan Nightbreaker"] = "Dalan Nachtbrecher",
	Damlak = "Damlak",
	["Darkscreecher Akkarai"] = "Dunkelkreischer Akkarai",
	["Dart's Nest"] = "Pfeils Nest",
	["Deth'tilac"] = "Toth'tilac",
	["Disha Fearwarden"] = "Disha Furchtwächter",
	["Dormus the Camel-Hoarder"] = "Dormus der Kameltreiber",
	["Equipment Locker"] = "Ausrüstungsspind",
	["Fel Tinkerer Zortan"] = "Teufelstüftler Zortan",
	["Fixxul Lonelyheart"] = "Heilet Schmachtherz",
	Forgosh = "Forgosh",
	["Frozen Trail Packer"] = "Eingefrorener Packer des Jutepfades",
	["G'nathus"] = "G'nathus",
	Garr = "Garr",
	["Gezzarak the Huntress"] = "Gezzarak die Jägerin",
	Ghostcrawler = "Geisterkrabbler",
	["Ghostly Pandaren Craftsman"] = "Geisterhafter Pandarenhandwerker",
	["Ghostly Pandaren Fisherman"] = "Geisterhafter Pandarenfischer",
	Glimmer = "Glimmer",
	["Glinting Rapana Whelk"] = "Schimmernde Rapanaschnecke",
	Golgarok = "Golgarok",
	Gondria = "Gondria",
	["Gorgolon the All-seeing"] = "Gorgolon der Allsehende",
	["Gul'bor"] = "Gul'bor",
	Hexapos = "Hexapos",
	["Huggalon the Heart Watcher"] = "Knu'dalon der Herzhüter",
	Jadefang = "Jadezahn",
	["Jade Warrior Statue"] = "Jadekriegerstatue",
	["Julak-Doom"] = "Julak-Doom",
	["Kar Warmaker"] = "Kar Kriegstreiber",
	Karkin = "Karkin",
	Karoma = "Karoma",
	Karrog = "Karrog",
	["King Dorfbruiser"] = "König Dorfelberster",
	Kirix = "Kirix",
	Kishak = "Kishak",
	["Lady La-La"] = "Lady La-La",
	["Lorbu Sadsummon"] = "Lorbu Trauerspruch",
	Madexx = "Madexx",
	Magria = "Magria",
	["Malevus the Mad"] = "Malevus die Verrückte",
	["Martar the Not-So-Smart"] = "Martar der Nicht-sehr-Kluge",
	["Matron Li-sahar"] = "Matrone Li-sahar",
	["Mavis Harms"] = "Mavis Harms",
	Mobus = "Mobus",
	Muerta = "Muerta",
	["Mysterious Camel Figurine"] = "Mysteriöse Kamelfigur",
	["Odd'nirok"] = "Ulk'nirok",
	["Overlord Sunderfury"] = "Oberanführer Zornesbeben",
	Patrannache = "Patrannach",
	Pengsong = "Pengsong",
	["Porfus the Gem Gorger"] = "Porfus der Edelsteinschlinger",
	Portent = "Portent",
	Poseidus = "Poseidus",
	["Ra'sha"] = "Ra'sha",
	["Ravasaur Matriarch's Nest"] = "Nest der Ravasaurusmatriarchin",
	["Razormaw Matriarch's Nest"] = "Nest der Scharfzahnmatriarchin",
	["Rockhide the Immovable"] = "Felshaut der Unverrückbare",
	Sambas = "Sambas",
	Savage = "Wilder",
	Scotty = "Scotty",
	["Shok'sharak"] = "Shok'sharak",
	Skarr = "Skarr",
	Skitterflame = "Flickerflamm",
	Skoll = "Skoll",
	Solix = "Solix",
	["Solus the Eternal"] = "Solus der Ewige",
	["Sprite's Cloth Chest"] = "Stoffkiste des Berggeists",
	Stompy = "Trampelchen",
	["Sungraze Behemoth"] = "Sonnenweidenungetüm",
	["Takk's Nest"] = "Takks Nest",
	["Tarvus the Vile"] = "Tarvus der Üble",
	Terborus = "Terborus",
	Terokk = "Terokk",
	Terrorpene = "Terrorpene",
	["Thartuk the Exile"] = "Thartuk der Verbannte",
	["The Behemoth"] = "Das Ungetüm",
	["Time-Lost Proto Drake"] = "Zeitverlorener Protodrache",
	Trelopades = "Trelopades",
	["Ubunti the Shade"] = "Ubunti der Schatten",
	["Vakkiz the Windrager"] = "Vakkiz der Windzürner",
	["Wild Onyx Serpent"] = "Wilde Onyxschlange",
	["Wrathbringer Laz-tarash"] = "Zornschaffer Laz-tarash",
	Xariona = "Xariona",
	["Zandalari Warbringer"] = "Kriegshetzer der Zandalari",
	Zhing = "Zhing",
}

elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations {
	Aeonaxx = "Aeonaxx",
	Akkalar = "Akkalar",
	Akkalou = "Akkalou",
	["Akma'hat"] = "Akma'hat",
	Alani = "Alani",
	Ankha = "Ankha",
	Anthriss = "Anthriss",
	Arcturis = "Arcturis",
	Armagedillo = "Armaglyptodon",
	["Armbreaker Huffaz"] = "Casse-bras Huffaz",
	["Ban'thalos"] = "Ban'thalos",
	["Barrel of Banana Infused Rum"] = "Tonneau de rhum infusé à la banane",
	Blazewing = "Ailembrase",
	Bloodtooth = "Dent-Rouge",
	Bristlespine = "Pin-hirsute",
	["Bro'Gaz the Clanless"] = "Bro'Gaz Sans-Clan",
	["Burgy Blackheart"] = "Burgy Cœur-Noir",
	["Cache of Pilfered Goods"] = "Cache de fournitures chapardées",
	["Captain Florence"] = "Capitaine Florence",
	["Captain Foulwind"] = "Capitaine Souillaile",
	Clamstok = "Palourok",
	["Clawlord Kril'mandar"] = "Seigneur des pinces kril’mandar",
	["Cyrus the Black"] = "Cyrus le Noir",
	["Dalan Nightbreaker"] = "Dalan Brisenuit",
	Damlak = "Damlak",
	["Darkscreecher Akkarai"] = "Akkarai le Hurle-sombre",
	["Dart's Nest"] = "Œuf de Flèche",
	["Deth'tilac"] = "Deth'tilac",
	["Disha Fearwarden"] = "Disha Gardepeur",
	["Dormus the Camel-Hoarder"] = "Dormus le Collectionneur de dromadaires",
	["Equipment Locker"] = "Placard d’équipement",
	["Fel Tinkerer Zortan"] = "Bricoleur gangrené Zortan",
	["Fixxul Lonelyheart"] = "Fixxul Cœur-Solitaire",
	Forgosh = "Forgosh",
	["Frozen Trail Packer"] = "Porteur des pistes gelé",
	["G'nathus"] = "G'nathus",
	Garr = "Garr",
	["Gezzarak the Huntress"] = "Gezzarak la Chasseresse",
	Ghostcrawler = "Clampant fantôme",
	["Ghostly Pandaren Craftsman"] = "Artisan pandaren fantomatique",
	["Ghostly Pandaren Fisherman"] = "Pêcheur pandaren fantomatique",
	Glimmer = "Luison",
	["Glinting Rapana Whelk"] = "Bigorneau rapana luisant",
	Golgarok = "Golgarok",
	Gondria = "Gondria",
	["Gorgolon the All-seeing"] = "Gorgolon l'Omnivoyant",
	["Gul'bor"] = "Gul'bor",
	Hexapos = "Hexapos",
	["Huggalon the Heart Watcher"] = "Cajolin le Gardien des cœurs",
	Jadefang = "Jadecroc",
	["Jade Warrior Statue"] = "Statue de guerrier de jade",
	["Julak-Doom"] = "Julak-Dram",
	["Kar Warmaker"] = "Kar le Va-t-en-Guerre",
	Karkin = "Karkin",
	Karoma = "Karoma",
	Karrog = "Karrog",
	["King Dorfbruiser"] = "Roi Cognenabot",
	Kirix = "Kirix",
	Kishak = "Kishak",
	["Lady La-La"] = "Dame La-La",
	["Lorbu Sadsummon"] = "Lorbu Triste-Supplique",
	Madexx = "Madexx",
	Magria = "Magria",
	["Malevus the Mad"] = "Malevus la Folle",
	["Martar the Not-So-Smart"] = "Martar le Pas Fute-Fute",
	["Matron Li-sahar"] = "Matrone Li-sahar",
	["Mavis Harms"] = "Mavis Laruine",
	Mobus = "Mobus",
	Muerta = "Muerta",
	["Mysterious Camel Figurine"] = "Figurine de dromadaire mystérieuse",
	["Odd'nirok"] = "Zarb’nirok",
	["Overlord Sunderfury"] = "Suzerain Fractefurie",
	Patrannache = "Patrannache",
	Pengsong = "Pengsong",
	["Porfus the Gem Gorger"] = "Porfus le Goinfre-gemmes",
	Portent = "Auspice",
	Poseidus = "Poséidus",
	["Ra'sha"] = "Ra’sha",
	["Ravasaur Matriarch's Nest"] = "Œuf de matriarche ravasaure",
	["Razormaw Matriarch's Nest"] = "Œuf de matriarche tranchegueule",
	["Rockhide the Immovable"] = "Rochecuir l'Inébranlable",
	Sambas = "Samba",
	Savage = "Sauvage",
	Scotty = "Scotty",
	["Shok'sharak"] = "Shok'sharak",
	Skarr = "Bal'afr",
	Skitterflame = "Rampeflamme",
	Skoll = "Skoll",
	Solix = "Solix",
	["Solus the Eternal"] = "Solus l’Eternel",
	["Sprite's Cloth Chest"] = "Coffre de lutin en tissu",
	Stompy = "Gros-pas",
	["Sungraze Behemoth"] = "Béhémoth pâture-du-soleil",
	["Takk's Nest"] = "Œuf de Takk",
	["Tarvus the Vile"] = "Tarvus le Vil",
	Terborus = "Terborus",
	Terokk = "Terokk",
	Terrorpene = "Terrorpene",
	["Thartuk the Exile"] = "Thartuk l'Exilé",
	["The Behemoth"] = "Le Béhémoth",
	["Time-Lost Proto Drake"] = "Proto-drake perdu dans le temps",
	Trelopades = "Trelopades",
	["Ubunti the Shade"] = "Ubunti l’Ombre",
	["Vakkiz the Windrager"] = "Vakkiz le Ragevent",
	["Wild Onyx Serpent"] = "Serpent onyx sauvage",
	["Wrathbringer Laz-tarash"] = "Porte-courroux Laz-tarash",
	Xariona = "Xariona",
	["Zandalari Warbringer"] = "Porteguerre zandalari",
	Zhing = "Zhing",
}

elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations {
	-- ["Entry"] = "Entry",
}

elseif GAME_LOCALE == "esES" then
	lib:SetCurrentTranslations {
	-- ["Entry"] = "Entry",
}

elseif GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations {
	-- ["Entry"] = "Entry",
}

elseif GAME_LOCALE == "ptBR" then
	lib:SetCurrentTranslations {
	-- ["Entry"] = "Entry",
}

elseif GAME_LOCALE == "itIT" then
	lib:SetCurrentTranslations {
	-- ["Entry"] = "Entry",
}

elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations {
	-- ["Entry"] = "Entry",
}

elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations {
	Aeonaxx = "奥伊纳克斯",
	Akkalar = "阿卡拉",
	Akkalou = "阿卡洛",
	["Akma'hat"] = "阿卡玛哈特",
	Alani = "阿拉尼",
	Ankha = "安卡",
	Anthriss = "安塞瑞丝",
	Arcturis = "阿克图瑞斯",
	Armagedillo = "硕铠鼠",
	["Armbreaker Huffaz"] = "断臂者霍法斯",
	["Ban'thalos"] = "班萨罗斯",
	["Barrel of Banana Infused Rum"] = "一桶泡蕉朗姆酒",
	Blazewing = "焰翼",
	Bloodtooth = "血牙",
	Bristlespine = "刺脊",
	["Bro'Gaz the Clanless"] = "独行者布罗加斯",
	["Burgy Blackheart"] = "布尔吉·黑心",
	["Cache of Pilfered Goods"] = "一箱被偷的货物",
	["Captain Florence"] = "弗罗伦斯船长",
	["Captain Foulwind"] = "船长费尔温德",
	Clamstok = "克莱斯托克",
	["Clawlord Kril'mandar"] = "钳爪领主科里曼达",
	["Cyrus the Black"] = "乌黑的赛勒斯",
	["Dalan Nightbreaker"] = "达兰·碎夜",
	Damlak = "达姆拉克",
	["Darkscreecher Akkarai"] = "黑暗尖啸者阿克卡莱",
	["Dart's Nest"] = "达尔特的卵",
	["Deth'tilac"] = "德丝缇拉克",
	["Disha Fearwarden"] = "笛沙·菲尔沃顿",
	["Dormus the Camel-Hoarder"] = "骆驼驭手多尔穆斯",
	["Equipment Locker"] = "装备箱",
	["Fel Tinkerer Zortan"] = "魔能工匠索尔坦",
	["Fixxul Lonelyheart"] = "菲克索尔·孤心",
	Forgosh = "弗尔高什",
	["Frozen Trail Packer"] = "冰封小径运货人",
	["G'nathus"] = "格纳瑟斯",
	Garr = "加尔",
	["Gezzarak the Huntress"] = "猎手吉萨拉克",
	Ghostcrawler = "鬼脚蟹",
	["Ghostly Pandaren Craftsman"] = "幽灵熊猫人木匠",
	["Ghostly Pandaren Fisherman"] = "幽灵熊猫人渔夫",
	Glimmer = "微光之蛾",
	["Glinting Rapana Whelk"] = "拉帕纳微光海螺",
	Golgarok = "格尔加洛克",
	Gondria = "古德利亚",
	["Gorgolon the All-seeing"] = "全视者格苟尔隆",
	["Gul'bor"] = "古尔博",
	Hexapos = "赫克萨波斯",
	["Huggalon the Heart Watcher"] = "观心者胡戈伦",
	Jadefang = "玉牙页岩蛛",
	["Jade Warrior Statue"] = "青玉战士雕像",
	["Julak-Doom"] = "厄运尤拉克",
	["Kar Warmaker"] = "卡尔·好战者",
	Karkin = "卡尔金",
	Karoma = "卡洛玛",
	Karrog = "卡尔洛格",
	["King Dorfbruiser"] = "多弗布鲁瑟国王",
	Kirix = "柯尔利克斯",
	Kishak = "基沙克",
	["Lady La-La"] = "蕾蒂拉拉",
	["Lorbu Sadsummon"] = "罗布·悲鸣",
	Madexx = "梅迪克西斯",
	Magria = "马格瑞亚",
	["Malevus the Mad"] = "疯狂的玛尔弗斯",
	["Martar the Not-So-Smart"] = "马尔泰弱智",
	["Matron Li-sahar"] = "里萨哈",
	["Mavis Harms"] = "梅薇思·哈姆斯",
	Mobus = "魔布斯",
	Muerta = "穆尔塔",
	["Mysterious Camel Figurine"] = "神秘的骆驼雕像",
	["Odd'nirok"] = "奥德尼洛克",
	["Overlord Sunderfury"] = "崩裂之怒主宰",
	Patrannache = "帕特兰纳克",
	Pengsong = "蓬松毛",
	["Porfus the Gem Gorger"] = "掘钻者波弗斯",
	Portent = "噩兆",
	Poseidus = "波塞冬斯",
	["Ra'sha"] = "拉沙",
	["Ravasaur Matriarch's Nest"] = "暴掠龙女王的卵",
	["Razormaw Matriarch's Nest"] = "刺喉雌龙的卵",
	["Rockhide the Immovable"] = true, -- Needs review
	Sambas = "桑巴斯",
	Savage = "萨维奇",
	Scotty = "史考特",
	["Shok'sharak"] = "索克沙拉克",
	Skarr = "刀疤",
	Skitterflame = "掠行之火",
	Skoll = "逐日",
	Solix = "莎利克斯",
	["Solus the Eternal"] = "永恒者索鲁斯",
	["Sprite's Cloth Chest"] = "林精的衣箱",
	Stompy = "重蹄",
	["Sungraze Behemoth"] = "阳痕巨兽",
	["Takk's Nest"] = "塔克的卵",
	["Tarvus the Vile"] = "邪恶的塔乌斯",
	Terborus = "泰博鲁斯",
	Terokk = "泰罗克",
	Terrorpene = "泰罗佩内",
	["Thartuk the Exile"] = "被放逐的萨图科",
	["The Behemoth"] = "贝哈默斯",
	["Time-Lost Proto Drake"] = "迷失的始祖幼龙",
	Trelopades = "特雷洛帕兹",
	["Ubunti the Shade"] = "鬼祟的乌班提",
	["Vakkiz the Windrager"] = "风怒者瓦克奇斯",
	["Wild Onyx Serpent"] = "野生玛瑙翔龙",
	["Wrathbringer Laz-tarash"] = "天罚使者拉塔莱什",
	Xariona = "埃克萨妮奥娜",
	["Zandalari Warbringer"] = "赞达拉战争使者",
	Zhing = "金尼",
}

elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations {
	Aeonaxx = "艾歐納克斯",
	Akkalar = "阿卡拉爾",
	Akkalou = "阿卡露",
	["Akma'hat"] = "阿克瑪哈特",
	Alani = "阿拉尼",
	Ankha = "安卡",
	Anthriss = "安斯銳斯",
	Arcturis = "大角",
	Armagedillo = "末日犰狳",
	["Armbreaker Huffaz"] = "斷臂者霍法茲",
	["Ban'thalos"] = "班薩洛斯",
	["Barrel of Banana Infused Rum"] = "香蕉蘭姆酒桶",
	Blazewing = "燄翼",
	Bloodtooth = "血牙",
	Bristlespine = "刺脊",
	["Bro'Gaz the Clanless"] = "無氏族的伯卡茲",
	["Burgy Blackheart"] = "伯吉·黑心",
	["Cache of Pilfered Goods"] = "失竊貨物的貯藏箱",
	["Captain Florence"] = "佛羅倫斯船長",
	["Captain Foulwind"] = "劣風船長",
	Clamstok = "克蘭斯朵",
	["Clawlord Kril'mandar"] = "『鉗王』克里曼達",
	["Cyrus the Black"] = "黑翼席魯斯",
	["Dalan Nightbreaker"] = "達然·破夜者",
	Damlak = "丹拉克",
	["Darkscreecher Akkarai"] = "黑暗尖叫者阿卡萊",
	["Dart's Nest"] = "達爾特的巢",
	["Deth'tilac"] = "殆死堤拉克",
	["Disha Fearwarden"] = "迪薩·懼衛",
	["Dormus the Camel-Hoarder"] = "『駱駝囤積者』多姆斯",
	["Equipment Locker"] = "裝備藏寶箱",
	["Fel Tinkerer Zortan"] = "惡魔工匠祖坦",
	["Fixxul Lonelyheart"] = "費茲索·寂寞心",
	Forgosh = "弗古斯",
	["Frozen Trail Packer"] = "冰霜小徑腳伕",
	["G'nathus"] = "葛納勒斯",
	Garr = "加爾",
	["Gezzarak the Huntress"] = "女獵人吉札拉",
	Ghostcrawler = "鬼蟹",
	["Ghostly Pandaren Craftsman"] = "鬼影熊貓人工匠",
	["Ghostly Pandaren Fisherman"] = "鬼影熊貓人漁夫",
	Glimmer = "微光",
	["Glinting Rapana Whelk"] = "閃爍的紅螺",
	Golgarok = "戈爾加羅克",
	Gondria = "剛卓亞",
	["Gorgolon the All-seeing"] = "全知者戈爾多隆",
	["Gul'bor"] = "古柏爾",
	Hexapos = "海卡薩波斯",
	["Huggalon the Heart Watcher"] = "『心之看守者』夏佳隆",
	Jadefang = "翡翠牙",
	["Jade Warrior Statue"] = "翠玉戰士雕像",
	["Julak-Doom"] = "毀滅祖拉克",
	["Kar Warmaker"] = "卡爾·開戰者",
	Karkin = "卡爾金",
	Karoma = "卡羅馬",
	Karrog = "凱羅格",
	["King Dorfbruiser"] = "國王多爾福布利薩",
	Kirix = "基利克斯",
	Kishak = "基薩",
	["Lady La-La"] = "女神菈菈",
	["Lorbu Sadsummon"] = "羅布·哀召",
	Madexx = "麥碟司",
	Magria = "瑪格瑞亞",
	["Malevus the Mad"] = "狂怒者馬拉弗斯",
	["Martar the Not-So-Smart"] = "不太聰明的瑪塔",
	["Matron Li-sahar"] = "女侍衛長利薩哈爾",
	["Mavis Harms"] = "梅薇思·重創",
	Mobus = "莫比斯",
	Muerta = "慕兒塔",
	["Mysterious Camel Figurine"] = "神秘駱駝刻像",
	["Odd'nirok"] = "奧尼羅",
	["Overlord Sunderfury"] = "霸主怒斬",
	Patrannache = "派崔娜",
	Pengsong = "鵬宋",
	["Porfus the Gem Gorger"] = "寶石吞噬者波弗斯",
	Portent = "惡兆",
	Poseidus = "波賽達斯",
	["Ra'sha"] = "拉沙",
	["Ravasaur Matriarch's Nest"] = "暴掠龍族母的巢",
	["Razormaw Matriarch's Nest"] = "刺喉龍族母的巢",
	["Rockhide the Immovable"] = "無法撼動的洛克海德",
	Sambas = "森巴斯",
	Savage = "沙維其",
	Scotty = "史考堤",
	["Shok'sharak"] = "肖克·薩菈克",
	Skarr = "斯卡爾",
	Skitterflame = "掠焰",
	Skoll = "史科爾",
	Solix = "索利克斯",
	["Solus the Eternal"] = "智者索勒斯",
	["Sprite's Cloth Chest"] = "妖精的衣櫃",
	Stompy = "暴蹄",
	["Sungraze Behemoth"] = "日牧巨獸",
	["Takk's Nest"] = "塔克的巢",
	["Tarvus the Vile"] = "邪惡的塔維斯",
	Terborus = "特波魯斯",
	Terokk = "泰洛克",
	Terrorpene = "懼龜",
	["Thartuk the Exile"] = "薩爾圖克",
	["The Behemoth"] = "貝希摩斯",
	["Time-Lost Proto Drake"] = "時光流逝元龍",
	Trelopades = "特羅費茲",
	["Ubunti the Shade"] = "『陰影』尤邦提",
	["Vakkiz the Windrager"] = "風怒者瓦奇茲",
	["Wild Onyx Serpent"] = "野生瑪瑙蛟",
	["Wrathbringer Laz-tarash"] = "憤怒使者拉茲泰拉西",
	Xariona = "克薩瑞歐納",
	["Zandalari Warbringer"] = "贊達拉戰爭使者",
	Zhing = "鎮山羊",
}

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
