﻿-- $Id: constants.pt.lua 4212 2013-05-20 12:27:56Z dynaletik $
--[[
constants.pt.lua
This file defines an AceLocale table for all the various text strings needed
by AtlasLoot.  In this implementation, if a translation is missing, it will fall
back to the English translation.

The AL["text"] = true; shortcut can ONLY be used for English (the root translation).
]]

-- Create the library instance
local AceLocale = LibStub:GetLibrary("AceLocale-3.0");

local AL = AceLocale:NewLocale("AtlasLoot", "ptBR", false);

-- Register translations
if AL then
	-- #########
	-- UI things
	-- #########
	-- AtlasLootFu 
	AL["AtlasLootFu is no longer in use.\nDelete it from your AddOns folder"] = true;

	-- Options
	AL["Options"] = "Opcões";
	AL["Load Loot Modules at Startup"] = "Carregar módulos ao iniciar";
	AL["Minimap Button"] = "Botão do minimapa";
	AL["Show itemIDs"] = "Mostra itemIDs";
	AL["Show Droprates"] = "Mostra Taxas de queda";
	AL["Safe Chat Links"] = "Link de bate-papo seguro";
	AL["Comparison TT"] = "Comparação TT";
	AL["Show Comparison Tooltips"] = "Mostrar Comparação de Dicas de ferramenta";
	AL["Opaque"] = "Opaco";
	AL["Make Loot Table Opaque"] = "Tornar Opaca Tabla de Saque";
	AL["Treat Crafted Items:"] = "Tratar Itens Criados";
	AL["As Crafting Spells"] = "Como Feitiços Criados";
	AL["As Items"] = "Como Itens";
	AL["Reset"] = "Reiniciar";
	AL["Reset Frames"] = "Reiniciar Quadros";
	AL["Profiles"] = "Perfis";
	AL["Item Buttons"] = "Botões de Item";
	AL["Loot Table"] = "Tabela de Saque";

	-- Default Frame
	AL["Default Frame"] = "Quadro Padrão";
	AL["Scale:"] = "Escala";
	AL["Alpha:"] = "Transparência";
	AL["Only change alpha on leave frame"] = "Só alterar a transparência do quadro principal";

	-- Bindings
	AL["Toggle AtlasLoot"] = "Mostra/Oculta AtlasLoot";

	--Help
	AL["Help"] = "Ajuda";
	AL["AtlasLoot Help"] = "Ajuda Atlasloot";
	AL["For further help, see our website and forums: "] = "Para mais ajuda, consulte nosso site da web e fóruns: ";
	AL["How to open the standalone Loot Browser:"] = "Como abrir o Navegador de Saque autônomo:";
	AL["If you have AtlasLootFu enabled, click the minimap button, or alternatively a button generated by a mod like Titan or FuBar.  Finally, you can type '/al' in the chat window."] = "Se você tem o AtlasLootFu ativado, clique no botão do minimapa, ou alternativamente em algum botão gerado por outro addon como Titan ou FuBar.  Finalmente, você pode escrever '/al' na janela de bate-papo.";
	AL["How to view an 'unsafe' item:"] = "Como ver um item 'não seguro':";
	AL["Unsafe items have a red border around the icon and are marked because you have not seen the item since the last patch or server restart. Right-click the item, then move your mouse back over the item or click the 'Query Server' button at the bottom of the loot page."] = "Itens não seguros tem uma borda vermelha ao redor de seu ícone e são marcados porque você não tem visto o item desde o último patch ou desde o último reinício de servidor. Clique com o botão direito no item, e depois mova o mouse em cima do ícone ou clique no botão 'Pergunte ao Servidor' na parte de baixo da página de saque.";
	AL["How to view an item in the Dressing Room:"] = "Como ver um item no Provador:";
	AL["Simply Ctrl+Left Click on the item.  Sometimes the dressing room window is hidden behind the Atlas or AtlasLoot windows, so if nothing seems to happen move your Atlas or AtlasLoot windows and see if anything is hidden."] = "Simplismente clique Ctrl+Esquerdo no item. Às vezes a janela de provador está escondida atrás da janela do Atlas ou AtlasLoot, então, se nada parecer acontecer mova a janela do seu Atlas ou AtlasLoot e veja se nada está escondido.";
	AL["How to link an item to someone else:"] = "Como linkar um item a outra pessoa:";
	AL["Shift+Left Click the item like you would for any other in-game item"] = "Clique Shift+Esquerdo no item como você faria por qualquer outro item de dentro do jogo";
	AL["How to add an item to the wishlist:"] = "Como adicionar um itema lista de desejos:";
	AL["Alt+Left Click any item to add it to the wishlist."] = "Clique Alt+Esquerdo em qualquer item para adicioná-lo a lista de desejos.";
	AL["How to delete an item from the wishlist:"] = "Como remover um item da lista de desejos:";
	AL["While on the wishlist screen, just Alt+Left Click on an item to delete it."] = "Enquanto está na tela da lista de desejos, só clique Alt+Esquerdo no item para removê-lo.";
	AL["What else does the wishlist do?"] = "O que mais a lista de desejos faz?";
	AL["If you Left Click any item on the wishlist, you can jump to the loot page the item comes from.  Also, on a loot page any item already in your wishlist is marked with a yellow star."] = "Se você clicar com o botão esquerdo na lista de desejos, você pode ir para a página de saque referente. Também, na página de saque, qualquer item que já esteja na sua lista de desejos está marcada com uma estrela amarela.";
	AL["HELP!! I have broken the mod somehow!"] = "SOCORRO!! De alguma forma eu quebrei o addon!";
	AL["Use the reset buttons available in the options menu, or type '/al reset' in your chat window."] = "Use os botões de reinício disponíveis no menu de opções, ou digite '/al reset' na sua janela de bate-papo.";

	-- LootButtons
	-- Tooltips
	AL["ItemID:"] = "ItemID:";
	AL["Drop Rate: "] = "Taxa de Queda : ";
	--AL["DKP"] = true;
	AL["Priority:"] = "Prioridade:";
	AL["Show price and slot if possible"] = "Mostrar preço e compartimentos se possível";
	AL["Use GameTooltip"] = "Utilizar Dica de Ferramenta do Jogo";
	AL["Use the standard GameTooltip instead of the custom AtlasLoot tooltip"] = "Utilizar a Dica de Ferramenta do Jogo padrão ao invés da customizada do Atlasloot";
	-- Unsafe Item
	AL["Item Unavailable"] = "Item Indisponível";
	AL["|cff0070ddItemID: %d |r\nThis item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world.\n\nYou can right-click to attempt to query the server.  You may be disconnected."] = "|cff0070ddItemID: %d |r\nEste objeto não é seguro. Para visualizar esse item sem o risco de desconexão, você precisa primeiro tê-lo visto no mundo.\n\nVocê pode clicar com o direito para tentar perguntar ao servidor. Você poderá ser desconectado.";
	
	-- Heriloom Config Window
	AL["Heirloom preview"] = "Visualização de Heranças";
	AL["Change level:"] = "Mudança de nível:";
	AL["Shift + Right Click to select character level"] = "Shift + Clique Direito para selecionar o nível do personagem";	

	-- LootTableSort
	AL["Sort by Instance"] = "Ordenar por Masmorra";
	AL["Sort loottable by Instance"] = "Ordenar tabela de saque por Masmorra";
	AL["Sort by Boss"] = "Ordenar por Chefe";
	AL["Sort loottable by Boss"] = "Ordenar tabela de saque por Masmorra";
	AL["Item Name"] = "Nome do Item";
	AL["Item Slot"] = "Compartimento do Item";
	AL["Item Quality"] = "Qualidade do Item";

	-- Wishlist 
	AL["Wishlist"] = "Lista de Desejo";
	AL["Wishlists"] = "Lista de Desejos";
	AL["Own"] = "Próprio";
	AL["Other"] = "Outro";
	AL["Shared"] = "Compartilhado";
	AL["Wishlist name:"] = "Nome da Lista de Desejo:";
	AL["Delete"] = "Apagar";
	AL["Share"] = "Compartilhar";
	AL["Send Wishlist (%s) to"] = "Enviar Lista de Desejo (%s) para";
	AL["Send"] = "Enviar";
	AL[" added to the WishList."] = " adicionado a Lista de Desejos.";
	AL[" already in the WishList!"] = " já está na Lista de Desejo!";
	AL[" deleted from the WishList."] = " apagado da Lista de Desejo.";
	AL["Are you sure you want to delete Wishlist |cff1eff00%s|r?"] = "Tem certeza que quer apagar a Lista de Desejo |cff1eff00%s|r?";
	AL["default"] = "padrão";
	AL["Use as default wishlist"] = "Utilizar como Lista de Desejo padrão";
	AL["Add Wishlist"] = "Adicionar Lista de Desejo";
	AL["Always use default Wishlist"] = "Sempre usar Lista de Desejo padrão";
	AL["Save wishlists at character DB"] = "Salvar Lista de Desejos na DB do personagem";
	AL["Saves the wishlists only for |cff1eff00%s-%s|r.\n Other characters cant view the wishlists, but the memory usage is reduced."] = "Salvar a Lista de Desejos somente para |cff1eff00%s-%s|r.\n Outros personagens não podem visualizar a Lista de Desejos, mas o uso de memória é reduzido.";
	AL["Table Sort"] = "Ordenar Tabela";
	AL["Table Sort:"] = "Ordenar Tabela:";
	AL["Item Sort:"] = "Ordenar Item:";

	-- Filter
	AL["Filter"] = "Filtrar";
	AL["Select All Loot"] = "Selecionar Todos os Saques";
	AL["Apply Filter:"] = "Aplicar filtro";
	AL["Melee weapons"] = "Armas Corpo a corpo";
	AL["Ranged weapons"] = "Armas de Distancia";
	AL["Other"] = "Outro";
	AL["Itemslot"] = "Compartimento de Item";
	AL["Shift + Click on the Filter button opens the config page."] = "Shift + Click no botão de Filtrar abre a página de configuração.";

	-- Panel
	AL["Hide Panel"] = "Ocultar Painel";
	AL["Toggle AL Panel"] = " Ligar/Desligar Painel AtlasLoot";
	AL["Buttons"] = "Botões";

	-- Buttons
	AL["Collections"] = "Coleções";
	AL["Crafting"] = "Criados";
	AL["Factions"] = "Facções";
	AL["Load Modules"] = "Carregar Módulos";
	AL["PvP Rewards"] = "Recompensas JvJ";
	AL["World Events"] = "Eventos Mundiais";

	-- QuickLooks
	AL["QuickLook"] = "Visualização Rápida"
	AL["QuickLooks"] = "Visualizações Rápidas";
	AL["Number of QuickLooks:"] = "Número de Visualizações Rápidas";
	AL["Add to QuickLooks:"] = "Adicionar a Visualizações Rápidas";
	AL["Reset Quicklooks"] = "Reiniciar Visualizações Rápidas";
	AL["Assign this loot table\n to QuickLook"] = "Definir esta tabela\n para Visualização Rápida";
	AL["Show unused QuickLooks in the Panel"] = "Mostrar Visualizações Rápidas não usadas no Painel";
	AL["Shows unused QuickLooks as grey buttons in the AtlasLoot Panel"] = "Mostrar Visualizações Rápidas não usadas como botões cinza no painel do AtlasLoot";
	-- Single options
	AL["unused"] = "não usado";
	AL["QuickLook name:"] = "Nome da Visualização Rápida:";
	AL["Use Boss name"] = "Usar nome do Chefe";
	AL["Use Instance name"] = "Usar nome da Masmorra";
	AL["Delete"] = "Apagar";
	AL["Lock"] = "Travar";
	AL["Enable"] = "Habilitar";

	-- Query Server / Query all
	AL["Query Server"] = "Perguntar ao Servidor";
	AL["Queries the server for all items\non this page. The items will be \nrefreshed when you next mouse \nover them."] = "Pergunta ao servidor por todos os itens\não desta página. Os itens serão \natualizados ao passar o mouse \nsobre eles";

	-- Atlas
	AL["Click boss name to view loot."] = "Clique no nome do chefe para visualizar o saque.";

	-- LootTable
	-- title
	AL["Heroic"] = "Heróico";
	AL["25 Man"] = "25 Pessoas";
	AL["25 Man Heroic"] = "25 Pessoas Heróico";
	-- buttons
	AL["Show 10 Man Loot"] = "Mostrar Saques 10 Pessoas";
	AL["Show 25 Man Loot"] = "Mostrar Saques 25 Pessoas";
	AL["Show Slot"] = "Mostrar Compartimento";
	AL["Show Price"] = "Mostrar Preço";
	AL["Skill"] = "Habilidade";
	AL["Location"] = "Localização";

	-- #######################################
	-- UI things END
	-- #######################################

	--Text strings for UI objects
	--AL["AtlasLoot"] = true;
	AL["Select Loot Table"] = "Selecionar Tabela de Saque";
	AL["Select Sub-Table"] = "Selecinar Sub-Tabela";
	AL["Various Locations"] = "Varias Localizações";
	AL["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "Isso é somente um navegador de saque. Para visualizar o mapa também, instale o Atlas ou Alphamap.";
	AL["Back"] = "Voltar";
	AL["Level 60"] = "Nível 60";
	AL["Level 70"] = "Nível 70";
	AL["Level 80"] = "Nível 80";
	AL["Level 85"] = "Nível 85";
	AL["|cffff0000(unsafe)"] = " |cffff0000(não seguro)";
	AL["Misc"] = "Misc";
	AL["Rewards"] = "Recompensas";
	AL["Choose Table ..."] = "Escolha Tabela...";
	AL["Unknown"] = "Desconhecido";
	AL["Reset Wishlist"] = "Reiniciar Lista de Desejo";
	AL["Select a Loot Table..."] = "Selecionar uma Tabela de Saque...";
	AL["OR"] = "Ou";
	AL["FuBar Options"] = "Opções FuBar";
	AL["Attach to Minimap"] = "Anexar ao Minimapa";
	AL["Hide FuBar Plugin"] = "Esconder Plugin FuBar";
	AL["Show FuBar Plugin"] = "Mostrar Plugin FuBar"; 
	AL["Position:"] = "Posição:";
	AL["Left"] = "Esquerda";
	AL["Center"] = "Centro";
	AL["Right"] = "Direita";
	AL["Hide Text"] = "Esconder Texto";
	AL["Hide Icon"] = "Esconder Ícone";
	AL["Minimap Button Options"] = "Opções do Botão Minimapa";

	--Text for Options Panel
	AL["Atlasloot Options"] = "Opções Atlasloot";
	AL["Default Tooltips"] = "Dica de Ferramenta Padrão";
	AL["Lootlink Tooltips"] = "Link de Saque de Dica de Ferramenta";
	AL["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dLink de Saque de Dica de Ferramenta";
	AL["ItemSync Tooltips"] = "Dica de Ferramenta de Sincronismo de Item";
	AL["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dDica de Ferramenta de Sincronismo de Item";
	AL["Use EquipCompare"] = "Usar EquipCompare";
	AL["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9dUsar EquipCompare";
	AL["Show itemIDs at all times"] = "Mostrar ItemIDs o tempo todo";
	AL["Hide AtlasLoot Panel"] = "Esconder Painel do AtlasLoot";
	AL["Show Basic Minimap Button"] = "Mostrar Botão Básico de Minimapa";
	AL["|cff9d9d9dShow Basic Minimap Button|r"] = "|cff9d9d9dMostrar Botão Básico de Minimapa|r";
	AL["Set Minimap Button Position"] = "Definir Posição do Botão Minimapa";
	AL["Notify on LoD Module Load"] = "Notificar ao Carregar Módulo LoD";
	AL["Loot Browser Scale: "] = "Escala do Navegador de Saque: ";
	AL["Button Position: "] = "Posição do Botão";
	AL["Button Radius: "] = "Botão Alcance";
	AL["Done"] = "Feito";
	AL["FuBar Toggle"] = "Ligar/Desligar FuBar";
	AL["Search Result: %s"] = "Buscar Result: %s";
	AL["Search on"] = "Pesquisar em";
	AL["All modules"] = "Todos os módulos";
	AL["If checked, AtlasLoot will load and search across all the modules."] = "Se marcado, AtlasLoot irá carregar e pesquisar por todos os módulos.";
	AL["Search options"] = "Pesquisar opções";
	AL["Partial matching"] = "Correspondência Parcial";
	AL["If checked, AtlasLoot search item names for a partial match."] = "Se marcado, AtlasLoot pesquisará o nome dos itens para uma correspondência parcial.";
	AL["You don't have any module selected to search on!"] = "Você não tem nenhum módulo selecionado para pesquisar!";
	--AL["Panel"] = true;

	--Slash commands
	AL["reset"] = "Reiniciar";
	AL["options"] = "Opções";
	AL["Reset complete!"] = "Reinicio completo!";

	-- AtlasLoot Panel - Search
	AL["Clear"] = "Limpar";
	AL["Last Result"] = "Último Resultado";
	AL["Search"] = "Pesquisar";

	-- Crafting Menu
	AL["Crafting Daily Quests"] = "Missões Diárias de Criação";
	AL["Cooking Daily"] = "Diária de Culinária";
	AL["Fishing Daily"] = "Diária de Pesca";	
	AL["Jewelcrafting Daily"] = "Diária de Joalheria";
	AL["Crafted Sets"] = "Conjuntos Criados";
	AL["Crafted Epic Weapons"] = "Armas Épicas Criadas";
	AL["Dragon's Eye"] = "Olho de Dragão";
	--AL["Chimera's Eye"] = true;

	-- Sets/Collections Menu
	--AL["Sets"] = true;
	AL["Set"] = "Conjunto";
	AL["Justice Points"] = "Pontos de Justiça";
	AL["Valor Points"] = "Pontos de Bravura";
	AL["BoE World Epics"] = "Épicos do Mundo VqE";
	AL["Legendary Items"] = "Itens Lendários";
	AL["Misc Sets"] = "Conjuntos Misc";
	AL["Tier 1/2 Set"] = "Conjunto T 1/2";
	AL["Tier 1/2/3 Set"] = "Conjunto T 1/2/3";
	AL["Tier 3 Set"] = "Conjunto T 3";
	AL["Tier 4/5/6 Set"] = "Conjunto T 4/5/6";
	AL["Tier 7/8 Set"] = "Conjunto T 7/8";
	AL["Tier 9 Set"] = "Conjunto T 9";
	AL["Tier 10 Set"] = "Conjunto T 10";
	AL["TCG Items"] = "Itens JTC"; -- Trading Card Game Items
	AL["Transformation Items"] = "Itens de Transformação";

	-- PvP Menu
	AL["Arathi Basin Sets"] = "Conjuntos da Bacia Arathi";
	AL["PvP Accessories"] = "Accesórios JxJ";
	AL["PvP Armor Sets"] = "Conjuntos de Armaduras JxJ";
	AL["PvP Weapons"] = "Armas JxJ";
	AL["PvP Non-Set Epics"] = "Épicos Não-Conjunto JxJ ";
	AL["PvP Reputation Sets"] = "Conjuntos de Reputação JxJ "
	AL["PvP Misc"] = "Misc de JxJ";
	AL["PVP Gems/Enchants/Jewelcrafting Designs"] = "Desenhos Gemas/Encantamentos/Joalheria JxJ";

	-- World Events
	AL["Abyssal Council"] = "Conselho Abissal";
	AL["Argent Tournament"] = "Torneio Argênteo";
	AL["Bash'ir Landing Skyguard Raid"] = "Raide Patamar de Bash'ir";
	AL["Brewfest"] = "CervaFest";
	AL["Children's Week"] = "A Semana das Crianças";
	AL["Day of the Dead"] = "Dia dos Mortos";
	AL["Ethereum Prison"] = "Prisão Etéreum";
	AL["Feast of Winter Veil"] = "Véu de Inverno";
	AL["Gurubashi Arena Booty Run"] = "Corrida da Arena Gurubashi";
	AL["Hallow's End"] = "Nortunália";
	AL["Harvest Festival"] = "Festival da Colheita";
	AL["Love is in the Air"] = "Amor está no Ar";
	AL["Lunar Festival"] = "Festival da Lua";
	AL["Midsummer Fire Festival"] = "Solsticio";
	AL["Noblegarden"] = "Jardinova";
	AL["Pilgrim's Bounty"] = "Festa da Fartura";
	AL["Skettis"] = "Skettis";
	AL["Stranglethorn Fishing Extravaganza"] = "Festerê de Pesca da Selva do Espinhaço";

	--Minimap Button
	AL["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00Clique-Esquerdo|r Navegar pelas Tabelas de Saque";
	AL["|cffff0000Right-Click|r View Options"] = "|cffff0000Clique-direito|r Visualizar Opções";
	AL["|cffff0000Shift-Click|r View Options"] = "|cffff0000Shift-Clique|r Visualizar Opções";
	AL["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccClique-Esquerdo + Arrastrar|r Move o Botão Minimapa";
	AL["|cffccccccRight-Click + Drag|r Move Minimap Button"] = "|cffccccccClique-Direito + Arrastrar|r Move o Botão Minimapa";

	-- Default Frame
	AL["Select Module"] = "Seleciona Modulo";
	AL["Select Instance"] = "Seleciona Masmorra";

	-- Wishlist
	AL["Close"] = "Fechar";
	AL["Own Wishlists"] = "Lista de Desejos Própria";
	AL["Other Wishlists"] = "Outras Listas de Desejo";
	AL["Shared Wishlists"] = "Lista de Desejos Compartilhadas";
	AL["Mark items in loot tables"] = "Marcar itens nas tabelas de saque";
	AL["Mark items from own Wishlist"] = "Marcar itens da própria Lista de Desejo";
	AL["Mark items from all Wishlists"] = "Marcar itens de todas as Listas de Desejo";
	AL["Enable Wishlist Sharing"] = "Habilitar Compartilhamento de Lista de Desejo";
	AL["Auto reject in combat"] = "Auto rejeitar em combate";
	AL["Edit Wishlist"] = "Editar Lista de Desejo";
	AL["Show More Icons"] = "Mostrar mais Ícones";
	AL["Edit"] = "Editar";
	AL["Show all Wishlists"] = "Mostrar todas as Listas de Desejo";
	AL["Show own Wishlists"] = "Mostrar Listas de Desejos próprias";
	AL["Show shared Wishlists"] = "Mostrar Listas de Desejo compatilhadas";
	AL["You must wait "] = "Você deve esperar ";
	AL[" seconds before you can send a new Wishlist to "] = " alguns segundos antes de enviar uma nova Lista de Desejos para ";
	AL["Cancel"] = "Cancelar";
	AL["Delete Wishlist %s?"] = "Apagar Lista de Desejo? %s?";
	AL["%s sends you a Wishlist. Accept?"] = "%s está lhe enviando uma Lista de Desejo. Aceitar?";
	AL[" tried to send you a Wishlist. Rejected because you are in combat."] = " tentou lhe enviar uma Lista de Desejo. Rejeitado porque você estava em combate.";
	AL[" rejects your Wishlist."] = " rejeitou sua Lista de Desejo.";
	AL["You can't send Wishlists to yourself"] = "Você não pode enviar Listas de Desejos a você mesmo.";
	AL["Please set a default Wishlist."] = "Por favor, seleciona uma Lista de Desejo padrão.";
	AL["Set as default Wishlist"] = "Definir como Lista de Desejo padrão.";

	--Misc Inventory related words
	AL["Scope"] = "Mira";
	AL["Darkmoon Faire Card"] = "Carta da Feira de Negraluna";
	AL["Banner"] = "Estandarte";
	AL["Set"] = "Conjunto";
	AL["Token"] = "Insígnia";
	AL["Combat Pet"] = "Mascota de Combate"; --Comprobar
	AL["Fireworks"] = "Fogos de Artifício";
	AL["Transformation Item"] = "Item de Transformação";
	AL["Keys"] = "Chaves";

	--Extra inventory stuff
	AL["Cloak"] = "Capa";

	--Alchemy
	AL["Battle Elixirs"] = "Elixir de Batalha";
	AL["Guardian Elixirs"] = "Elixir Guardião";
	AL["Potions"] = "Poções";
	AL["Transmutes"] = "Transmutacões";
	AL["Flasks"] = "Frascos";

	-- Blacksmithing
	AL["Cataclysm Vendor Sold Plans"] = "Vendedor de Instruções do Cataclysm";
	
	--Enchanting
	AL["Enchant Boots"] = "Encantamento Botas";
	AL["Enchant Bracer"] = "Encantamento Braçadeiras";
	AL["Enchant Chest"] = "Encantamento Torso";
	AL["Enchant Cloak"] = "Encantamento Manto";
	AL["Enchant Gloves"] = "Encantamento Luvas";
	AL["Enchant Ring"] = "Encantamento Anel";
	AL["Enchant Shield & Off-Hand"] = "Encantamento Escudo";
	AL["Enchant 2H Weapon"] = "Encantamento Arma 2M";
	AL["Enchant Weapon"] = "Encantamento Arma";
	AL["Cataclysm Vendor Sold Formulas"] = "Vendedor de Fórmulas do Cataclysm";

	--Inscription
	AL["Major Glyph"] = "Glifos Elevados";
	AL["Minor Glyph"] = "Glifos Menores";
	AL["Scrolls"] = "Pergaminhos";
	AL["Off-Hand Items"] = "Itens de Mão Secundária";
	AL["Reagents"] = "Reagentes";
	AL["Book of Glyph Mastery"] = "Livro da Proficiência em Glifos";

	--Leatherworking
	AL["Leather Armor"] = "Armaduras de Couro";
	AL["Mail Armor"] = "Armaduras de Malha";
	AL["Cloaks"] = "Capas";
	AL["Item Enhancements"] = "Aperfeiçoamento de Item";
	AL["Drums, Bags and Misc."] = "Tambores, Bolsas e Misc.";

	--Tailoring
	AL["Shirts"] = "Camisas";
	AL["Bags"] = "Bolsas";

	--Labels for loot descriptions
	AL["Classes:"] = "Clases";
	AL["This Item Begins a Quest"] = "Este Item Inicia uma Missão";
	AL["Quest Item"] = "Item de Missão";
	AL["Old Quest Item"] = "Item de Missão Velho";
	AL["Quest Reward"] = "Recompensa de Missão";
	AL["Old Quest Reward"] = "Recompensas de Missões Velhas";
	AL["Shared"] = "Compartilhado";
	AL["Right Half"] = "Parte Direita";
	AL["Left Half"] = "Parte Esquerda";
	AL["Currency"] = "Moeda";
	AL["Used to summon boss"] = "Utilizados para convocar chefe";
	AL["Tradable for sunmote + item above"] = "Intercambiável";
	AL["Card Game Item"] = "Item de Jogo de Cartas";
	AL["Skill Required:"] = "Habilidade Requerida:";
	AL["Rating:"] = "Ranque:"; -- Shorthand for 'Required Rating' for the personal/team ratings
	--AL["Random Heroic Reward"] = true;
	--AL["Fishing Daily Reward"] = true;
	--AL["Collector's Edition"] = true;
	--AL["Daily Reward"] = true;

	-- Minor Labels for loot table descriptions
	--AL["Classic WoW"] = true;
	--AL["Burning Crusade"] = true;
	--AL["Wrath of the Lich King"] = true;
	--AL["Cataclysm"] = true;
	AL["Entrance"] = "Entrada";
	AL["Dungeon Set 1"] = "Conjunto de Masmorra 1";
	AL["Dungeon Set 2"] = "Conjunto de Masmorra 2";
	AL["Dungeon Set 1/2"] = "Conjunto de Masmorra 1/2";
	AL["Dungeon Set 3"] = "Conjunto de Masmorra 3";	
	AL["Tier 1"] = "Conjunto T1";
	AL["Tier 2"] = "Conjunto T2";
	AL["Tier 3"] = "Conjunto T3";
	AL["Tier 4"] = "Conjunto T4";
	AL["Tier 5"] = "Conjunto T5";
	AL["Tier 6"] = "Conjunto T6";
	AL["Tier 7"] = "Conjunto T7";
	AL["Tier 8"] = "Conjunto T8";
	AL["Tier 9"] = "Conjunto T9";
	AL["Tier 10"] = "Conjunto T10";
	AL["Tier 11"] = "Conjunto T11";
	AL["10 Man"] = "10 Pessoas";
	AL["10/25 Man"] = "10/25 Pessoas";
	AL["Epic Set"] = "Conjunto Épico";
	AL["Rare Set"] = "Conjunto Raro";
	AL["Season 9"] = "Temporada 9";
	AL["Season 10"] = "Temporada 10";
	AL["Season 11"] = "Temporada 11";
	AL["Fire"] = "Fogo";
	AL["Water"] = "Água";
	AL["Wind"] = "Ar";
	AL["Earth"] = "Terra";
	AL["Master Angler"] = "Mestre Pescador";
	AL["Fire Resistance Gear"] = "Equipamentos com resistência a fogo";
	AL["Arcane Resistance Gear"] = "Equipamentos com resistência a Arcano";
	AL["Nature Resistance Gear"] = "Equipamentos com resistência a Natureza";
	AL["Frost Resistance Gear"] = "Equipamentos com resistência a Gelo";
	AL["Shadow Resistance Gear"] = "Equipamentos com resistência a Sombra";

	-- Labels for loot table sections
	AL["Additional Heroic Loot"] = "Saque Heróico Adicional";
	AL["Heroic Mode"] = "Modo Heróico";
	AL["Normal Mode"] = "Modo Normal";
	AL["Raid"] = "Raide";
	AL["Hard Mode"] = "Modo Difícil";
	AL["Bonus Loot"] = "Saque Bônus";
	AL["Arena Reward"] = "Recompensas de Arena";
	AL["Achievement Reward"] = "Recompensa de Conquista";
	AL["Phase 1"] = "Fase 1";
	AL["Phase 2"] = "Fase 2";
	AL["Phase 3"] = "Fase 3";
	AL["First Prize"] = "Primero Prêmio";
	AL["Rare Fish Rewards"] = "Recompensas Raras de Pesca";
	AL["Rare Fish"] = "Peixe Raro";
	AL["Heirloom"] = "Herança";
	AL["Weapons"] = "Armas";
	AL["Accessories"] = "Acessórios";
	AL["Rare"] = "Raros";

	-- Loot Table Names
	AL["Level 30-39"] = "Níveis 30-39";
	AL["Level 40-49"] = "Níveis 40-49";
	AL["Level 50-60"] = "Níveis 50-60";
	AL["Summon"] = "Convocar";
	AL["Random"] = "Aleatório";
	AL["Brew of the Month Club"] = "Clube da Cerveja do Mês";

	-- Cooking descriptions
	AL["Buff"] = "Bônus";
	AL["Agility"] = "Agilidade";
	AL["Intellect"] = "Intelecto";
	AL["Strength"] = "Força";
	AL["Spell Power"] = "Poder Mágico";
	AL["Attack Power"] = "Poder de Ataque";
	AL["Spell/Attack Power"] = "Poder de Ataque/Mágico";
	AL["Hit Rating"] = "Taxa de Acerto";
	AL["Crit Rating"] = "Taxa de Acerto Crítico";
	AL["Haste Rating"] = "Taxa de Aceleração";
	AL["Dodge Rating"] = "Taxa de Esquiva";
	AL["Expertise Rating"] = "Taxa de Aptidão";
	AL["Mastery Rating"] = "Taxa de Maestria";
	AL["Parry Rating"] = "Taxa de Aparo";
	AL["Other Ratings"] = "Outras Taxas";
	AL["Resistance"] = "Resistência";
	AL["Health / Second"] = "Vida / Segundo";
	AL["Mana / Second"] = "Mana / Segundo";
	AL["Tracking"] = "Rastreamento";
	AL["Emotions"] = "Expressão";
	--AL["Alcohol"] = true;
	AL["Health"] = "Vida";
	AL["Mana"] = "Mana";
	AL["Health and Mana"] = "Vida e Mana";
	AL["Other Buffs"] = "Outros Bônus";
	AL["Standard Buffs"] = "Bônus Padrão";
	AL["Food without Buffs"] = "Comida sem Bônus";
	AL["Special"] = "Especial";
	AL["Feasts"] = "Banquete";

	-- Extra Text in Boss lists
	AL["AQ20 Class Sets"] = "Conjuntos por Classe de AQ20";
	AL["AQ Enchants"] = "Encantamentos AQ";
	AL["AQ40 Class Sets"] = "Conjuntos por Clase de AQ40";
	AL["AQ Opening Quest Chain"] = "Abertura da Cadeia de Missões AQ";
	AL["Tribute Run"] = "Corrida de Tributo";
	AL["Dire Maul Books"] = "Livros do Gládio Cruel";
	AL["Random Boss Loot"] = "Saque de Chefe Aleatório";
	AL["Formula/Patterns/Plans"] = "Formulas/Modelos/Planos";
	AL["BRD Blacksmithing Plans"] = "Planos de Ferraria BRD";
	AL["Patterns/Plans"] = "Modelos/Planos";

	-- General titles
	AL["Achievement"] = "Conquista";

	-- Companions
	AL["Achievement"] = "Conquista";
	AL["Card Game Companions"] = "Mascotes por Jogo de Cartas";
	AL["Companion Accessories"] = "Acessórios para Mascotes";
	AL["Crafted Companions"] = "Mascotes Criados";
	AL["Dungeon/Raid"] = "Masmorra/Raide";
	AL["Faction"] = "Facção";
	AL["Merchant Sold Companions"] = "Mascotes Vendidos por Mercadores";
	AL["Pets"] = "Ajudantes";
	AL["Promotional Companions"] = "Mascotes Promocionais";
	AL["Quest Reward Companions"] = "Mascotes por recompensa de Missão";
	AL["Rare Companions"] = "Mascotes Raros";
	AL["Unobtainable Companions"] = "Mascotes Impossíveis de se Obter";

	-- Mounts
	AL["Alliance Mounts"] = "Montarias da Aliança";
	AL["Horde Mounts"] = "Montarias da Horda";
	AL["Card Game Mounts"] = "Montarias por Jogo de Cartas";
	AL["Crafted Mounts"] = "Montarias Criadas";
	AL["Event Mounts"] = "Montarias de Eventos";
	AL["Neutral Faction Mounts"] = "Montarias Facções Neutras";
	AL["PvP Mounts"] = "Montarias JvJ";
	AL["Alliance PvP Mounts"] = "Montarias JvJ Aliança";
	AL["Horde PvP Mounts"] = "Montarias JvJ Horda";
	AL["Halaa PvP Mounts"] = "Montarias JvJ Halaa";
	AL["Promotional Mounts"] = "Montarias Promocionais"
	AL["Rare Mounts"] = "Montarias raras"
	AL["Unobtainable Mounts"] = "Montarias Impossíveis de se Obter";

	-- Tabards
	AL["Achievement & Quest Reward Tabards"] = "Tabardos de Recompensa de Missão e Conquista";
	AL["Alliance Tabards"] = "Tabardos da Aliança";
	AL["Card Game Tabards"] = "Tabardos de Jogo de Cartas";
	AL["Horde Tabards"] = "Tabardos da Horda";
	AL["PvP Tabards"] = "Tabardos JvJ";
	AL["Unobtainable Tabards"] = "Tabardos Impossíveis de se Obter";

	--Darkmoon Faire
	AL["Darkmoon Faire Rewards"] = "Recompensas da Feira de Negraluna";
	AL["Low Level Decks"] = "Baralhos de Nível Baixo";
	AL["Level 60 & 70 Trinkets"] = "Berloques Nível 60 e 70";
	AL["Trinkets"] = "Berloques";

	--Card Game Decks and descriptions
	AL["Loot Card Items"] = "Saques (Jogo de Cartas)";
	AL["UDE Items"] = "Items (pontos UDE)";

	-- First set
	AL["Heroes of Azeroth"] = "Heróis de Azeroth";
	AL["Landro Longshot"] = "Landro Tirolargo";
	AL["Thunderhead Hippogryph"] = "Hipogrifo Cabeça de Trovão";
	AL["Saltwater Snapjaw"] = "Mandíbula Agua Salgada";

	-- Second set
	AL["Through The Dark Portal"] = "Através do Portal Negro";
	AL["King Mukla"] = "Rei Mukla";
	AL["Rest and Relaxation"] = "Descanso e Relaxamento";
	AL["Fortune Telling"] = "Cartomancia"; --Comprobar

	-- Third set
	AL["Fires of Outland"] = "Fogos de Terralém";
	AL["Spectral Tiger"] = "Tigre Espectral";
	AL["Gone Fishin'"] = "Foi Pescar"; --Comprobar
	AL["Goblin Gumbo"] = "Caldeirão Goblin";

	-- Fourth set
	AL["March of the Legion"] = "Marcha da Legião";
	--AL["Kiting"] = true, FALTA
	--AL["Robotic Homing Chicken"] = true, FALTA
	AL["Paper Airplane"] = "Avião de Papel"

	-- Fifth set
	AL["Servants of the Betrayer"] = "Serventes do Traidor";
	AL["X-51 Nether-Rocket"] = "Foguéter X-51";
	AL["Personal Weather Machine"] = "Máquina Meteorológica Pessoal";
	AL["Papa Hummel's Old-fashioned Pet Biscuit"] = "Biscoito de Mascote Antiquado de Papai Hummel"

	-- Sixth set
	AL["Hunt for Illidan"] = "Caça por Illidan"; 
	AL["The Footsteps of Illidan"] = "As Pegadas de Illidan"; 
	--AL["Disco Inferno!"] = true, FALTA
	AL["Ethereal Plunderer"] = "Encanador Etéreo";

	-- Seventh set
	AL["Drums of War"] = "Tambores de Guerra";
	--AL["The Red Bearon"] = "The Red Bearon"; --FALTA
	--AL["Owned!"] = true, --FALTA
	--AL["Slashdance"] = true, --FALTA

	-- Eighth set
	AL["Blood of Gladiators"] = "Sangue de Gladiadores";
	AL["Sandbox Tiger"] = "Tigre de Balanço";
	AL["Center of Attention"] = "Centro de Atenção"; --Check
	AL["Foam Sword Rack"] = "Cavalete para Espada de Espuma";

	-- Ninth set
	--AL["Fields of Honor"] = true;
	--AL["Path of Cenarius"] = true;
	--AL["Pinata"] = true;
	--AL["El Pollo Grande"] = true;

	-- Tenth set
	AL["Scourgewar"] = "Guerra da Praga"; --Check
	AL["Tiny"] = "Minúsculo";
	AL["Tuskarr Kite"] = "Pipa Morsana";
	AL["Spectral Kitten"] = "Cria de Tigre Espectral"; --Check

	-- Eleventh set
	AL["Wrathgate"] = "Portão da Fúria";
	--AL["Statue Generator"] = true;
	AL["Landro's Gift"] = "Presente de Landro";
	AL["Blazing Hippogryph"] = "Hipogrifo Fulgurante";

	-- Twelvth set
	AL["Icecrown"] = "Coroa de Gelo";
	AL["Wooly White Rhino"] = "Rinoceronte Branco Lanoso";
	AL["Ethereal Portal"] = "Portal Etéreo";
	AL["Paint Bomb"] = "Bomba de Tinta";

	-- Thirtheenth set
	AL["Worldbreaker"] = "Rompe-mundo";

	--Battleground Brackets
	AL["Old PvP Rewards"] = "Recompensas JvJ Antigas";
	AL["BG/Open PvP Rewards"] = "Recompensas JvJ Arena/CB";
	AL["Misc. Rewards"] = "Recompensas Misc.";
	AL["Level 10-19 Rewards"] = "Recompensas de Níveis 10-19";
	AL["Level 20-39 Rewards"] = "Recompensas de Níveis 20-39";
	AL["Level 20-29 Rewards"] = "Recompensas de Níveis 20-29";
	AL["Level 30-39 Rewards"] = "Recompensas de Níveis 30-39";
	AL["Level 40-49 Rewards"] = "Recompensas de Níveis 40-49";
	AL["Level 50-59 Rewards"] = "Recompensas de Níveis 50-59";
	AL["Level 60 Rewards"] = "Recompensas de nivel 60";

	--Brood of Nozdormu Paths
	AL["Path of the Conqueror"] = "O Caminho do Conquistador";
	AL["Path of the Invoker"] = "O Caminho do Invocador";
	AL["Path of the Protector"] = "O Caminho do Protetor";

	--Violet Eye Paths
	AL["Path of the Violet Protector"] = "O Caminho do Protector Violeta";
	AL["Path of the Violet Mage"] = "O Caminho do Mago Violeta";
	AL["Path of the Violet Assassin"] = "O Caminho do Assassino Violeta";
	AL["Path of the Violet Restorer"] = "O Caminho do Restaurador Violeta";

	-- Ashen Verdict Paths
	AL["Path of Courage"] = "O Caminho da Coragem";
	AL["Path of Destruction"] = "O Caminho da Destruição";
	AL["Path of Vengeance"] = "O Caminho da Vingança";
	AL["Path of Wisdom"] = "O Caminho da Sabedoria";

	--AQ Opening Event
	AL["Red Scepter Shard"] = "Fragmento de Cetro Vermelho";
	AL["Blue Scepter Shard"] = "Fragmento de Cetro Azul";
	AL["Green Scepter Shard"] = "Fragmento de Cetro verde";
	AL["Scepter of the Shifting Sands"] = "Cetro das Areias Cambiantes";

	--World PvP
	AL["Hellfire Fortifications"] = "Fortificações da Península do Fogo do Inferno";
	AL["Twin Spire Ruins"] = "Ruinas dos Pináculos Gêmeos";
	AL["Spirit Towers"] = "Torres dos Espiritos";
	--AL["Halaa"] = true,
	AL["Venture Bay"] = "Baia Aventura"; --Check

	--Karazhan Opera Event Headings
	AL["Wizard of Oz"] = "O Mágico de Oz";
	AL["Red Riding Hood"] = "Chapeuzinho Vermelho";

	--Karazhan Animal Boss Types
	AL["Spider"] = "Aranha";
	AL["Darkhound"] = "Cão Negro";
	AL["Bat"] = "Morcego";

	-- AQ20 Tokens
	AL["Qiraji Ornate Hilt"] = "Punho Ornamentado Qiraji";
	AL["Qiraji Martial Drape"] = "Clâmide Marcial Qiraji";
	AL["Qiraji Magisterial Ring"] = "Anel Magistral Qiraji";
	AL["Qiraji Ceremonial Ring"] = "Anel Cerimonial Qiraj";
	AL["Qiraji Regal Drape"] = "Clâmide Régia Qiraji";
	AL["Qiraji Spiked Hilt"] = "Punho de Pontas Qiraji";

	--AQ40 Tokens
	AL["Qiraji Bindings of Dominance"] = "Ataduras de Dominância Qiraji";
	AL["Qiraji Bindings of Command"] = "Ataduras de Comando Qiraji";
	AL["Vek'nilash's Circlet"] = "Argolas de Vek'nilash";
	AL["Vek'lor's Diadem"] = "Diadema de Vek'lor";
	AL["Ouro's Intact Hide"] = "Pele Intacta do Ouro";
	AL["Skin of the Great Sandworm"] = "Pele do Grande Verme da Areia ";
	AL["Husk of the Old God"] = "Carapaça do Deus Antigo";
	AL["Carapace of the Old God"] = "Carapaça do Deus Antigo";

	-- Faction related strings
	AL["Neutral"] = "Tolerado";
	AL["Friendly"] = "Respeitado";
	AL["Honored"] = "Honrado";
	AL["Revered"] = "Reverenciado";
	AL["Exalted"] = "Exaltado";
	-- AL["Best Friend"] = true;
	AL["Winterfin Retreat"] = "Retiro da Falésia Invernal";

	--Recipe origin strings
	AL["Trainer"] = "Instrutor";
	AL["Discovery"] = "Descoberta";
	AL["World Drop"] = "Saque do Mundo";
	AL["Drop"] = "Saque"; 
	AL["Vendor"] = "Vendedor";
	AL["Crafted"] = "Criado";

	-- Months
	AL["January"] = "Janeiro";
	AL["February"] = "Fevereiro";
	AL["March"] = "Março";
	AL["April"] = "Abril";
	AL["May"] = "Maio";
	AL["June"] = "Junho";
	AL["July"] = "Julho";
	AL["August"] = "Agosto";
	AL["September"] = "Setembro";
	AL["October"] = "Outubro";
	AL["November"] = "Noveembro";
	AL["December"] = "Dezembro";

	--Specs
	AL["Balance"] = "Equilíbrio";
	AL["Feral"] = "Combate Feral";
	AL["Restoration"] = "Restauração";
	AL["Holy"] = "Sagrado";
	AL["Discipline"] = "Disciplina";
	AL["Protection"] = "Proteção";
	AL["Retribution"] = "Retribuição";
	AL["Shadow"] = "Sombra";
	--AL["Elemental"] = true,
	AL["Enhancement"] = "Aperfeiçoamento";
	AL["Fury"] = "Fúria";
	AL["Demonology"] = "Demonologia";
	AL["Destruction"] = "Destruição";
	AL["Tanking"] = "Tanque";
	--AL["DPS"] = true,

	--Naxx Zones
	AL["Construct Quarter"] = "Distrito dos Constructos";
	AL["Arachnid Quarter"] = "Distrito dos Aracnídeos";
	AL["Military Quarter"] = "Distrito Militar";
	AL["Plague Quarter"] = "Distrito da Peste";
	AL["Frostwyrm Lair"] = "Covil da Serpe Gélida";

	--NPCs missing from BabbleBoss
	AL["Trash Mobs"] = "Multidões de Bichos";
	AL["Dungeon Set 2 Summonable"] = "Conjunto de Masmorra 2 Convocável";
	--AL["Theldren"] = true,
	AL["Sothos and Jarien"] = "Sothos e Jarien";
	AL["Druid of the Fang"] = "Druida da Presa";
	AL["Defias Strip Miner"] = "Tuneleiro Defias";
	AL["Defias Overseer/Taskmaster"] = "Sobrestante/Capataz Defias";
	AL["Scarlet Trainee"] = "Aprendiz Escarlate";
	AL["Shadowforge Flame Keeper"] = "Vigilante da Chama Forjanegra";
	AL["Avatar of the Martyred"] = "Avatar dos Martirizados";
	AL["Nexus Stalker"] = "Perseguidor Nexus";
	AL["Auchenai Monk"] = "Monje Auchenai";
	AL["Cabal Fanatic"] = "Fanático da Cabala";
	AL["Unchained Doombringer"] = "Fatídico Desencadeado";
	AL["Crimson Sorcerer"] = "Feiticeiro Carmesim";
	AL["Thuzadin Shadowcaster"] = "Taumaturgo Sombrio Thuzadin";
	AL["Crimson Inquisitor"] = "Inquisidor Carmesim";
	AL["Crimson Battle Mage"] = "Mago de batalha Carmesim";
	AL["Ghoul Ravener"] = "Necrófago Corvoso";
	AL["Spectral Citizen"] = "Cidadão Espectral";
	AL["Spectral Researcher"] = "Investigador Espectral";
	AL["Scholomance Adept"] = "Adepto de Scholomance";
	AL["Scholomance Dark Summoner"] = "Convocador Sombrio de Scolomântia";
	AL["Blackhand Elite"] = "Elite Punho Negro";
	AL["Firebrand Pyromancer"] = "Piromântico Incendiário";
	AL["Firebrand Invoker"] = "Convocador Incendiário";
	AL["Firebrand Grunt"] = "Bruto Incendiário";
	AL["Firebrand Legionnaire"] = "Legionário Incendiário";
	AL["Spirestone Warlord"] = "Senhor da Guerra Pinapedra";
	AL["Spirestone Mystic"] = "Místico Pinapedra";
	AL["Anvilrage Captain"] = "Capitão da Bigorna Colérica";
	AL["Anvilrage Marshal"] = "Marechal da Bigorna Colérica";
	AL["Doomforge Arcanasmith"] = "Arcanorrero da Forja Maldita";
	AL["Weapon Technician"] = "Técnico de Armas";
	AL["Doomforge Craftsman"] = "Artesão da Forja Maldita";
	AL["Murk Worm"] = "Verme da Trevas";
	AL["Raging Skeleton"] = "Esqueleto Enfurecido";
	AL["Ethereal Priest"] = "Sacerdote Etéreo";
	AL["Sethekk Ravenguard"] = "Guarda Corvo Sethekk";
	AL["Time-Lost Shadowmage"] = "Mago Sombrio do Tempo Perdido";
	AL["Coilfang Sorceress"] = "Feiticeira Presa Torcida";
	AL["Coilfang Oracle"] = "Oráculo Presa Torcida";
	AL["Shattered Hand Centurion"] = "Centurião da Mão Destroçada";
	AL["Eredar Deathbringer"] = "Portador da Morte Eredar";
	AL["Arcatraz Sentinel"] = "Sentinela de Arcatraz";
	AL["Gargantuan Abyssal"] = "Abissal Gigantesco";
	AL["Sunseeker Botanist"] = "Botânica Buscasol";
	AL["Sunseeker Astromage"] = "Astromago Buscasol";
	AL["Durnholde Rifleman"] = "Fuzileiro de Durnholde";
	AL["Rift Keeper/Rift Lord"] = "Vigilante da Falha/Lorde da Falha";
	AL["Crimson Templar"] = "Templário Carmesim";
	AL["Azure Templar"] = "Templário Azul";
	AL["Hoary Templar"] = "Templario Antigo ";
	AL["Earthen Templar"] = "Templário da Terra";
	AL["The Duke of Cynders"] = "Duque das Brasas";
	AL["The Duke of Fathoms"] = "Duque das Profundidades";
	AL["The Duke of Zephyrs"] = "Duque dos Zéfiros";
	AL["The Duke of Shards"] = "Duque dos Cacos";
	AL["Aether-tech Assistant"] = "Aether-técnico Assistente";
	AL["Aether-tech Adept"] = "Adepto Aether-Técnico";
	AL["Aether-tech Master"] = "Aether-Técnico Mestre";
	AL["Smokywood Pastures Vendor"] = "Vendedor de Pastos de Madeira Esfumaçada";
	AL["Bash'ir Landing Stasis Chambers"] = "Desembarque das Câmaras de Estase Bash'ir";
	AL["Templars"] = "Templários";
	AL["Dukes"] = "Duques";
	AL["High Council"] = "Conselheiro Maior";
	AL["Scarshield Quartermaster"] = "Intendente do Escudo da Estigma";
	AL["Father Flame"] = "Padre Chama";
	--AL["Thomas Yance"] = true,
	AL["Knot Thimblejack"] = "Knot Thimblejack";
	AL["Shen'dralar Provisioner"] = "Provedor Shen'dralar";
	AL["The Nameles Prophet"] = "O Profeta Sem Nome";
	AL["Rajaxx's Captains"] = "Capitães de Rajaxx";
	AL["Razorfen Spearhide"] = "Lanceiro Urzal";
	AL["Magregan Deepshadow"] = "Magregan Sombraprofunda";
	--AL["Don Carlos"] = true,
	AL["Aged Dalaran Wizard"] = "Feiticeiro de Dalaran Envelhecido";
	AL["Felsteed"] = "Corcel Vil";
	AL["Shattered Hand Executioner"] = "Carrasco Mão Destroçada";	 
	AL["Deviate Ravager/Deviate Guardian"] = "Devastador Desviado/Guardião Desviado";
	--AL["Servant's Quarter Animal Bosses"] = true; FALTA
	AL["Master Elemental Shaper Krixix"] = "Mestre Modelador de Elementos Krixix";

	-- Zone related strings
	-- AL["Azeroth"] = true;
	AL["Blackrock Mountain"] = "Montanha Rocha Negra";
	AL["Caverns of Time"] = "Cavernas do Tempo";
	AL["Crusader's Square"] = "Praça dos Cruzados";
	AL["Darkmoon Island"] = "Ilha de Negraluna";
	AL["East"] = "Leste";
	AL["North"] = "Norte";
	AL["The Gauntlet"] = "A Manopla"; -- Comprobar
	AL["Trial of the Grand Crusader"] = "Prova do Grande Cruzado";
	AL["West"] = "Oeste";

	--Shortcuts for Bossname files
	--AL["Avatar"] = true,	

	--Chests, etc
	AL["The Grim Guzzler"] = "o Tragapenas";
	AL["The Secret Safe"] = "O Cofre Seguro";
	AL["The Vault"] = "A Câmara";
	AL["Ogre Tannin Basket"] = "Cesta de Ogro Tanino";
	AL["Unfinished Painting"] = "Pintura Interminada"; --Comprobar
	AL["Felvine Shard"] = "Fragmento de Vinhavil";
	AL["Gift of Adoration"] = "Presente de adoração";
	AL["Treat Bag"] = "Bolsa de Prêmios";
	AL["Timed Reward Chest"] = "Baú de Recompensa de Tempo"; --Comprobar
	AL["Timed Reward Chest 1"] = "Baú de Recompensa de Tempo 1";
	AL["Timed Reward Chest 2"] = "Baú de Recompensa de Tempo 2";
	AL["Timed Reward Chest 3"] = "Baú de Recompensa de Tempo 3";
	AL["The Talon King's Coffer"] = "O Baú do Rei Talon";
	AL["Krom Stoutarm's Chest"] = "Baú de Krom Braço-forte";
	AL["Garrett Family Chest"] = "Baú da Familia Garrett";
	AL["Reinforced Fel Iron Chest"] = "Baú Reforçado de Ferro Vil";
	AL["DM North Tribute Chest"] = "Baú de Tributo de LM Norte";
	AL["The Saga of Terokk"] = "A Saga de Terokk";
	AL["First Fragment Guardian"] = "Guardião do Primero Fragmento";
	AL["Second Fragment Guardian"] = "Guardião do Segundo Fragmento";
	AL["Third Fragment Guardian"] = "Guardião do Terceiro Fragmento";
	AL["Overcharged Manacell"] = "Célula de Mana Sobrecarregada";

	--Error Messages and warnings
	AL["AtlasLoot Error!"] = "Erro no AtlasLoot!";
	AL["WishList Full!"] = "Liste de Desejo Cheia!'";
	AL["No match found for"] = "Nenhuma Correspondência Encontrada";
	AL[" is safe."] = " é seguro.";
	AL["Server queried for "] = "Perguntado ao Servidor por ";
	AL[".  Right click on any other item to refresh the loot page."] = ".  Clique com o Direito em qualquer outro item para atualizar a página de saque.";

	--Incomplete Table Registry error message
	AL[" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = " não listado no registro da tabela de saque, por favor reporte esta mensagem no forum do AtlasLoot em http://www.atlasloot.net";

	--LoD Module disabled or missing
	AL[" is unavailable, the following load on demand module is required: "] = " está indisponível, a seguinte carga no módulo de procura é requerida: ";

	--LoD Module load sequence could not be completed
	AL["Status of the following module could not be determined: "] = "Status do seguinte módulo não pode ser determinado: ";

	--LoD Module required has loaded, but loot table is missing
	AL[" could not be accessed, the following module may be out of date: "] = " não pode ser acessado, o seguinte módulo pode estar desatualizado: ";

	--LoD module not defined
	AL["Loot module returned as nil!"] = "Módulo de Saque retornou vazio!";

	--LoD module loaded successfully
	AL["sucessfully loaded."] = "carregado com sucesso.";

	--Need a big dataset for searching
	AL["Loading available tables for searching"] = "Carregando as tabelas disponíveis para pesquisa";

 	--All Available modules loaded
	AL["All Available Modules Loaded"] = "Todos os Módulos Disponíveis Carregados";
		
	--First time user
	AL["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences."] = "Bem vindo ao AtlasLoot Enhanced. Por favor, tire um momento para definir suas preferências.";
	AL["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "Bem vindo ao Atlasloot Enhanced. Por favor tire um momento para definir suas preferências para Dica de Ferramenta e Links na janela de bate-papo.\n\n Essa tela de opções pode ser alcançada novamente a qualquer hora digitando '/atlasloot'.";
	AL["Setup"] = "Configuración";

	--Old Atlas Detected
	AL["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "Foi detectado que sua versão do Atlas não coincide com a versão do AtlasLoot para a qual foi feito (";
	AL[").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = ").  Dependendo das mudanças, podem ocorrer ocasionais erros, então por favor, visite http://www.atlasmod.com/ o mais rápido possível para atualizar.";
	AL["OK"] = "OK";
	AL["Incompatible Atlas Detected"] = "Atlas Incompatível Detectado";

	--Unsafe item tooltip
	AL["Unsafe Item"] = "Item não Seguro";
	AL["This item is not available on your server or your battlegroup yet."] = "Este item não está disponível em seu servidor ou no seu grupo de batalha ainda";
	AL["You can right-click to attempt to query the server.  You may be disconnected."] = "Você pode clicar com o direito para tentar perguntar ao servidor.\nVocê pode ser desconectado.";
end