﻿-- $Id: constants.ru.lua 4212 2013-05-20 12:27:56Z dynaletik $
--[[
constants.ru.lua
This file defines an AceLocale table for all the various text strings needed
by AtlasLoot.  In this implementation, if a translation is missing, it will fall
back to the English translation.

The AL["text"] = true; shortcut can ONLY be used for English (the root translation).
]]

--Table holding all loot tables is initialised here as it loads early
--AtlasLoot_Data = {};

--Create the library instance
local AceLocale = LibStub:GetLibrary("AceLocale-3.0");

local AL = AceLocale:NewLocale("AtlasLoot", "ruRU", false);

--Register translations
if AL then

	-- #########
	-- UI things
	-- #########
	
	-- Loader
	AL["Load AtlasLoot"] = "Загрузить AtlasLoot";
	AL["Module \"%s\" is disabled."] = "Модуль \"%s\" отключен.";
	AL["Module \"%s\" is missing."] = "Модуль \"%s\" отсутствует.";

	-- AtlasLootFu 
	AL["AtlasLootFu is no longer in use.\nDelete it from your AddOns folder"] = "AtlasLootFu больше не используется.\nУдалите его из вашей папик модификаций";

	-- Options
	AL["Options"] = "Настройки";
	AL["Load Loot Modules at Startup"] = "Загружать модули при старте";
	AL["Minimap Button"] = "Кнопка у мини-карты";
	AL["Show itemIDs"] = "ID предмета";
	AL["Show Droprates"] = "Шанс выпада";
	AL["Safe Chat Links"] = "Безопасные ссылки";
	AL["Comparison TT"] = "Сравнительные подсказки";
	AL["Show Comparison Tooltips"] = "Показывать сравнительные подсказки";
	AL["Opaque"] = "Матовое";
	AL["Make Loot Table Opaque"] = "Матовое окно трофеев";
	AL["Treat Crafted Items:"] = "Обзор изготов. предметов:";
	AL["As Crafting Spells"] = "Как заклинание";
	AL["As Items"] = "Как предмет";
	AL["Reset"] = "Сброс";
	AL["Reset Frames"] = "Сброс окон";
	AL["Profiles"] = "Профили";
	AL["Item Buttons"] = "Кнопки предметов";
	AL["Loot Table"] = "Таблица трофеев";

	-- Default Frame
	AL["Default Frame"] = "Стандартное окно";
	AL["Scale:"] = "Масштаб";
	AL["Alpha:"] = "Прозрачность";
	AL["Only change alpha on leave frame"] = "Прозрачность измениться только после закрытия окна";

	-- Bindings
	AL["Toggle AtlasLoot"] = "Переключение AtlasLootа";

	-- Help
	AL["Help"] = "Справка";
	AL["AtlasLoot Help"] = "Справка AtlasLoot";
	AL["For further help, see our website and forums: "] = "Для получения дополнительной справки, см. наш сайт и форумы: ";
	AL["How to open the standalone Loot Browser:"] = "Как открыть отдельный обозреватель трофеев:";
	AL["If you have AtlasLootFu enabled, click the minimap button, or alternatively a button generated by a mod like Titan or FuBar.  Finally, you can type '/al' in the chat window."] = "Если у вас есть AtlasLootFu и он включен, нажмите на кнопку у мини карты, или же используйте панели типа Titan или FuBar. В конце концов, вы можете набрать в чат '/ Al'.";
	AL["How to view an 'unsafe' item:"] = "Как просмотреть 'небезопасный' предмет:";
	AL["Unsafe items have a red border around the icon and are marked because you have not seen the item since the last patch or server restart. Right-click the item, then move your mouse back over the item or click the 'Query Server' button at the bottom of the loot page."] = "Небезопасные предметы выделены красной рамкой вокруг значка, потому что вы не видели этот предмет после последнего патча или перезагрузки сервера. Щелкните правой кнопкой мыши по предмету, а затем нажмите кнопку 'Запрос с серв.', расположенную в нижней части страницы трофеев.";
	AL["How to view an item in the Dressing Room:"] = "Как просмотреть предмет в примерочной:";
	AL["Simply Ctrl+Left Click on the item.  Sometimes the dressing room window is hidden behind the Atlas or AtlasLoot windows, so if nothing seems to happen move your Atlas or AtlasLoot windows and see if anything is hidden."] = "Просто нажмите Ctrl + ЛКМ по претмету. Иногда окно примерочной скрыто за окном Атласа или AtlasLootа, так что если ничего не появилось после нажатия (Ctrl + ЛКМ) на предмет, переместите окно Атласа или AtlasLootа, возможно окно примерочной за ними.";
	AL["How to link an item to someone else:"] = "Как передать ссылку на предмет кому-нибуть:";
	AL["Shift+Left Click the item like you would for any other in-game item"] = "Shift+Левая кнопка мыши по предмету";
	AL["How to add an item to the wishlist:"] = "Как добавить предмет в список нужного:";
	AL["Alt+Left Click any item to add it to the wishlist."] = "Alt+Левый клик по любому предмету добовляет его в список нужного.";
	AL["How to delete an item from the wishlist:"] = "Как удалить предмет из списка нужного:";
	AL["While on the wishlist screen, just Alt+Left Click on an item to delete it."] = "Находять в окне списка, для удаления предмета, просто нажмите Alt+Левый клик по нему.";
	--AL["What else does the wishlist do?"] = true;
	--AL["If you Left Click any item on the wishlist, you can jump to the loot page the item comes from.  Also, on a loot page any item already in your wishlist is marked with a yellow star."] = true;
	AL["HELP!! I have broken the mod somehow!"] = "Помогите! Я как-то сломал мод!";
	AL["Use the reset buttons available in the options menu, or type '/al reset' in your chat window."] = "Используйте кнопку сброса, которая доступна в настройках, или наберите в чат '/ Al reset'.";

	-- LootButtons
	-- Tooltips
	AL["ItemID:"] = "ID предмета:";
	AL["Drop Rate: "] = "Шанс выпада: ";
	AL["DKP"] = "ДКП";
	AL["Priority:"] = "Приоритет:";
	AL["Show price and slot if possible"] = "Показать цену и яцейку если это возможно";
	AL["Use GameTooltip"] = "Использовать игровую подсказку";
	AL["Use the standard GameTooltip instead of the custom AtlasLoot tooltip"] = "использовать стандартную игровую подсказку вместо подсказки AtlasLoot";
	-- Unsafe Item
	AL["Item Unavailable"] = "Предмет недоступен";
	AL["|cff0070ddItemID: %d |r\nThis item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world.\n\nYou can right-click to attempt to query the server.  You may be disconnected."] = "|cff0070ddItemID: %d |r\nЭтот предмет небезопасен. Для того, чтобы посмотреть его без риска отсоединения от сервера, сначала Вы должны его увидеть в игре.\n\nВы можете нажать правый-клик для запроса информации с сервера. Вы можете быть отсоединены от сервера.";
	-- Heriloom Config Window
	AL["Heirloom preview"] = "Предпросмотр фамильных";
	AL["Change level:"] = "Изменить уровень:";
	AL["Shift + Right Click to select character level"] = "Shift + Правый клик - выбор уровня персонажа";	

	-- LootTableSort
	AL["Sort by Instance"] = "Сорт по подземельям";
	AL["Sort loottable by Instance"] = "Сортировка таблици трофеев по подземельям";
	AL["Sort by Boss"] = "Сорт по боссам";
	AL["Sort loottable by Boss"] = "Сортировка таблици трофеев по боссам";
	AL["Item Name"] = "Название";
	AL["Item Slot"] = "Ячейка";
	AL["Item Quality"] = "Качество";

	-- Wishlist 
	AL["Wishlist"] = "Список нужного";
	AL["Wishlists"] = "Списки нужного";
	AL["Own"] = "Ваши";
	AL["Other"] = "Другие";
	AL["Shared"] = "Общие";
	AL["Wishlist name:"] = "Название списка:";
	AL["Delete"] = "Удалить";
	AL["Share"] = "Делиться";
	AL["Send Wishlist (%s) to"] = "Выслать список (%s) -";
	AL["Send"] = "Выслать";
	AL[" added to the WishList."] = " добавлен в список нужного.";
	AL[" already in the WishList!"] = " уже существует в списке нужного.";
	AL[" deleted from the WishList."] = " удалён из списка нужного.";
	AL["Are you sure you want to delete Wishlist |cff1eff00%s|r?"] = "Удалить список нужного |cff1eff00%s|r?";
	AL["default"] = "default";
	AL[" |cff999999<default>"] = " |cff999999<default>";
	AL["Use as default wishlist"] = "Использовать по умолчанию";
	AL["Add Wishlist"] = "Добавить список нужного";
	AL["Always use default Wishlist"] = "Всегда использовать список нужного по умолчению";
	AL["Save wishlists at character DB"] = "Сохр. списки нужного в БД персонажа";
	AL["Saves the wishlists only for |cff1eff00%s-%s|r.\n Other characters cant view the wishlists, but the memory usage is reduced."] = "Сохроняет списки нужного только для |cff1eff00%s-%s|r.\n Другие персонажи не смогут просмотреть списки нужного, но снижается использование памяти.";
	AL["Table Sort"] = "Сорт. таблицы";
	AL["Table Sort:"] = "Сорт. таблицы:";
	AL["Item Sort:"] = "Сорт. предметов:";
	
	-- Filter
	AL["Filter"] = "Фильтр";
	AL["Select All Loot"] = "Выбрать всю добычу";
	AL["Apply Filter:"] = "Исп. Фильтр:";
	AL["Melee weapons"] = "Ближний бой";
	AL["Ranged weapons"] = "Дальний бой";
	AL["Other"] = "Другое";
	AL["Itemslot"] = "Ячейка";
	AL["Shift + Click on the Filter button opens the config page."] = "Shift + Клик по кнопке фильтра открывает окно настроек.";

	-- Panel
	AL["Hide Panel"] = "Скрыть панель";
	AL["Toggle AL Panel"] = "Перек-ние панели AL";
	AL["Buttons"] = "Кнопки";

	-- Buttons
	AL["Collections"] = "Наборы";
	AL["Crafting"] = "Ремесло";
	AL["Factions"] = "Фракции";
	AL["Load Modules"] = "Загр. модулей";
	AL["PvP Rewards"] = "PvP награды";
	AL["World Events"] = "Мировые события";

	-- QuickLooks
	AL["QuickLook"] = "БыстрыйОсмотр";
	AL["QuickLooks"] = "БыстрыеОсмотры";
	AL["Number of QuickLooks:"] = "Число БыстрыхОсмотров:";
	AL["Add to QuickLooks:"] = "Добавить в БыстрыйОсмотр";
	AL["Reset Quicklooks"] = "Сброс БыстрыхОсмотров";
	--AL["Assign this loot table\n to QuickLook"] = true;
	--AL["Show unused QuickLooks in the Panel"] = true;
	--AL["Shows unused QuickLooks as grey buttons in the AtlasLoot Panel"] = true;
	-- Single options
	--AL["unused"] = true;
	AL["QuickLook name:"] = "БыстрыйОсмотр:";
	AL["Use Boss name"] = "Исп. имя Босса";
	AL["Use Instance name"] = "Исп. название подземелья";
	AL["Delete"] = "Удалить";
	AL["Lock"] = "Закрепить";
	AL["Enable"] = "Включить";

	-- Query Server / Query all
	AL["Query Server"] = "Запрос с серв.";
	AL["Queries the server for all items \non this page. The items will be \nrefreshed when you next mouse \nover them."] = "Запрос с сервера всех предметов \nна данной странице. Предметы \nбудут обновлены при следующем \nнаведении курсора мыши.";

	-- Atlas
	AL["Click boss name to view loot."] = "Кликните по имени босса для просмотра трофеев.";

	-- LootTable
	-- title
	AL["Heroic"] = "Героик";
	AL["25 Man"] = "25 чел";
	AL["25 Man Heroic"] = "25 чел героик";
	-- buttons
	AL["Show 10 Man Loot"] = "Добыча 10-чел";
	AL["Show 25 Man Loot"] = "Добыча 25-чел";
	AL["Show Slot"] = "Ячейка";
	AL["Show Price"] = "Цена";
	AL["Skill"] = "Навык";
	AL["Location"] = "Место";

	-- #######################################
	-- UI things END
	-- #######################################

	-- Text strings for UI objects
	AL["AtlasLoot"] = "AtlasLoot";
	AL["Select Loot Table"] = "Таблица трофеев";
	AL["Select Sub-Table"] = "Выбор Под-Таблицы";
	AL["Various Locations"] = "Разное местонахождение";
	AL["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "Это только обозреватель трофеев. Для обзора карт, установите Atlas или Alphamap.";
	AL["Back"] = "Назад";
	AL["Level 60"] = "Уровень 60";
	AL["Level 70"] = "Уровень 70";
	AL["Level 80"] = "Уровень 80";
	AL["Level 85"] = "Уровень 85";
	AL["|cffff0000(unsafe)"] = "|cffff0000(опасный)";
	AL["Misc"] = "Разное";
	AL["Rewards"] = "Награды";
	AL["Choose Table ..."] = "Выбор таблицы";
	AL["Unknown"] = "Неизвестно";
	AL["Reset Wishlist"] = "Сброс списка нужного";
	AL["Select a Loot Table..."] = "Выберите таблицу трофеев";
	AL["OR"] = "или";
	AL["FuBar Options"] = "Опции FuBarа";
	AL["Attach to Minimap"] = "Закрепить у мини-карты";
	AL["Hide FuBar Plugin"] = "Скрыть плагин FuBarа";
	AL["Show FuBar Plugin"] = "Показ плагин FuBarа";
	AL["Position:"] = "Позицыя";
	AL["Left"] = "Слево";
	AL["Center"] = "По центру";
	AL["Right"] = "Справо";
	AL["Hide Text"] = "Скрыть текст";
	AL["Hide Icon"] = "Скрыть иконку";
	AL["Minimap Button Options"] = "Опции кнопки у мини-карты";

	-- Text for Options Panel
	AL["Atlasloot Options"] = "Опции Atlasloot";
	AL["Default Tooltips"] = "Стандартные подсказки";
	AL["Lootlink Tooltips"] = "Подсказки СсылокТрофеев";
	AL["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dПодсказки СсылокТрофеев|r";
	AL["ItemSync Tooltips"] = "Подсказки Синхр.Предметов";
	AL["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dПодсказки Синхр.предм.|r";
	AL["Use EquipCompare"] = "Включить сравнение экипировки";
	AL["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9dИспоьзовать EquipCompare|r";
	AL["Show itemIDs at all times"] = "ID для всех предметов";
	AL["Hide AtlasLoot Panel"] = "Скрыть панель AtlasLoot";
	AL["Show Basic Minimap Button"] = "Показывать кнопку у мини-карты";
	AL["|cff9d9d9dShow Basic Minimap Button|r"] = "|cff9d9d9dПоказывать кнопку у мини-карты|r";
	AL["Set Minimap Button Position"] = "Позиция кнопки у мини-карты";
	AL["Notify on LoD Module Load"] = "Извещать об авто-загрузке модулей";
	AL["Loot Browser Scale: "] = "Масштаб обозревателя трофеев: ";
	AL["Button Position: "] = "Позиция кнопки: ";
	AL["Button Radius: "] = "Радиус кнопки: ";
	AL["Done"] = "Готово";
	AL["FuBar Toggle"] = "Перекл. FuBarа";
	AL["Search Result: %s"] = "Результат Поиска: %s";
	AL["Search on"] = "Искать в";
	AL["All modules"] = "Все модули";
	AL["If checked, AtlasLoot will load and search across all the modules."] = "Если включено, AtlasLoot будет загружать все модули и искать по ним.";
	AL["Search options"] = "Настройки поиска";
	AL["Partial matching"] = "Частичное совпадение";
	AL["If checked, AtlasLoot search item names for a partial match."] = "Если включено, AtlasLoot будет искать названия предметов с частичным совпадением.";
	AL["You don't have any module selected to search on!"] = "Вы не выбрали ни одиного модуля для поиска!";
	AL["Panel"] = "Панель";

	-- Slash commands
	AL["reset"] = "reset";
	AL["options"] = "options";
	AL["Reset complete!"] = "Сброс выполнен!";

	-- AtlasLoot Panel - Search
	AL["Clear"] = "Очистить";
	AL["Last Result"] = "Посл. результат";
	AL["Search"] = "Поиск";

	-- Crafting Menu
	AL["Crafting Daily Quests"] = "Ежедневные задания - ремесло";
	AL["Cooking Daily"] = "Кулинария (Ежедневный)";
	AL["Fishing Daily"] = "Рыбная ловля (Ежедневный)";
	AL["Jewelcrafting Daily"] = "Ювелирное дело (Ежедневный)";
	AL["Crafted Sets"] = "Изготавливаемые комплекты";
	AL["Crafted Epic Weapons"] = "Изготавливаемое превосх. оружие";
	AL["Dragon's Eye"] = "Око Дракона";
	AL["Chimera's Eye"] = "Глаз химеры";

	-- Sets/Collections Menu
	AL["Sets"] = "Комплекты";
	AL["Set"] = "Комплект";
	AL["Justice Points"] = "Очки справедливости";
	AL["Valor Points"] = "Очки доблести";
	AL["BoE World Epics"] = "Мировые превосходные ПпП";
	AL["Legendary Items"] = "Легендарные предметы";
	AL["Misc Sets"] = "Различные комплекты";
	AL["Tier 1/2 Set"] = "Комплекты Тира 1/2";
	AL["Tier 1/2/3 Set"] = "Комплекты Тира 1/2/3";
	AL["Tier 3 Set"] = "Комплект Тира 3";
	AL["Tier 4/5/6 Set"] = "Комплекты Тира 4/5/6";
	AL["Tier 7/8 Set"] = "Комплекты Тира 7/8";
	AL["Tier 9 Set"] = "Комплект Тира 9";
	AL["Tier 10 Set"] = "Комплект Тира 10";
	AL["TCG Items"] = "Предметы TCG";
	AL["Transformation Items"] = "Трансформ. предметы";

	-- PvP Menu
	AL["Arathi Basin Sets"] = "Комплекты Низины Арати";
	AL["PvP Accessories"] = "PvP предметы";
	AL["PvP Armor Sets"] = "PvP комплекты доспехов";
	AL["PvP Weapons"] = "PvP Оружие";
	AL["PvP Non-Set Epics"] = "PvP Превосходные не из комплектов";
	AL["PvP Reputation Sets"] = "PvP комплекты за репутацию";
	AL["PvP Misc"] = "PvP ювелирные эскизы";
	AL["PVP Gems/Enchants/Jewelcrafting Designs"] = "PvP Самоцветы/Чары/Ювелирные эскизы";
	AL["PvP Trinkets"] = "PvP аксессуары";

	-- World Events
	AL["Abyssal Council"] = "Совет Бездны";
	AL["Argent Tournament"] = "Серебряный Турнир";
	AL["Bash'ir Landing Skyguard Raid"] = "Рейд Стражей Небес на Лагерь Баш'ира";
	AL["Brewfest"] = "Хмельной фестиваль";
	AL["Children's Week"] = "Детская неделя";
	AL["Day of the Dead"] = "День мертвых";
	AL["Ethereum Prison"] = "Тюрьма Эфириумов";
	AL["Feast of Winter Veil"] = "Зимний Покров";
	AL["Gurubashi Arena Booty Run"] = "Арена Гурубаши";
	AL["Hallow's End"] = "Тыквовин";
	AL["Harvest Festival"] = "Неделя урожая";
	AL["Love is in the Air"] = "Любовная лихорадка";
	AL["Lunar Festival"] = "Лунный фестиваль";
	AL["Midsummer Fire Festival"] = "Огненный солнцеворот";
	AL["Noblegarden"] = "Сад чудес";
	AL["Pilgrim's Bounty"] = "Пиршество странников";
	AL["Skettis"] = "Скеттис";
	AL["Stranglethorn Fishing Extravaganza"] = "Рыбомания Тернистой долины";
	AL["Kalu'ak Fishing Derby"] = "Калуакское рыбоборье";

	-- Minimap Button
	AL["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00ЛКМ|r Просмотр таблицы трофеев";
	AL["|cffff0000Right-Click|r View Options"] = "|cffff0000ПКЛ|r Просмотр опций";
	AL["|cffff0000Shift-Click|r View Options"] = "|cffff0000Shift-Клик|r Просмотр опций";
	AL["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccЛКМ + Перетаскивание|r Перемещение кнопки у мини-карты";
	AL["|cffccccccRight-Click + Drag|r Move Minimap Button"] = "|cffccccccПКМ + Перетаскивание|r Перемещение кнопки у мини-карты";

	-- Default Frame
	AL["Select Module"] = "Выберите модуль";
	AL["Select Instance"] = "Выберите подземелье";

	-- Wishlist
	AL["Close"] = "Закрыть";
	AL["Own Wishlists"] = "Ваши списки";
	AL["Other Wishlists"] = "Другие списки нужного";
	AL["Shared Wishlists"] = "Общие списки";
	AL["Mark items in loot tables"] = "Отметь предметы в таблице трофеев";
	AL["Mark items from own Wishlist"] = "Отметь предметы из вашего списка";
	AL["Mark items from all Wishlists"] = "Отметь предметы из всех списков";
	AL["Enable Wishlist Sharing"] = "Позволяет делиться списками";
	AL["Auto reject in combat"] = "Авто отклонения в бою";
	AL["Edit Wishlist"] = "Привить список нужного";
	AL["Show More Icons"] = "Больше иконок";
	AL["Edit"] = "Правка";
	AL["Show all Wishlists"] = "Показ всех списков";
	AL["Show own Wishlists"] = "Показать ваши списки";
	AL["Show shared Wishlists"] = "Показ делимых списков";
	AL["You must wait "] = "Вы должны обождать ";
	AL[" seconds before you can send a new Wishlist to "] = " секунд до возможности выслать новый список ";
	AL["Cancel"] = "Отмена";
	AL["Delete Wishlist %s?"] = "Удалить список нужного %s?";
	AL["%s sends you a Wishlist. Accept?"] = "%s шлет вам список. Принять?";
	AL[" tried to send you a Wishlist. Rejected because you are in combat."] = " пытается выслать вам список. Попытка отклонена, так как вы в бою.";
	AL[" rejects your Wishlist."] = " отклонил ваш список.";
	AL["You can't send Wishlists too your self."] = "Вы не можете выслать список самому сибе.";
	AL["Please set a default Wishlist."] = "Установите список по умолчанию.";
	AL["Set as default Wishlist"] = "Установка списка по умолчанию";

	-- Misc Inventory related words
	AL["Scope"] = "Прицелы";
	AL["Darkmoon Faire Card"] = "Карты Ярмарки Темной Луны";
	AL["Banner"] = "Знамя";
	AL["Set"] = "Комплекты";
	AL["Token"] = "Знак";
	AL["Combat Pet"] = "Боевой питомец";
	AL["Fireworks"] = "Феерверк";
	AL["Transformation Item"] = "Трансформ. предмет";
	AL["Keys"] = "Ключи";

	-- Extra inventory stuff
	AL["Cloak"] = "Плащ";

	-- Alchemy
	AL["Battle Elixirs"] = "Боевые эликсиры";
	AL["Cauldron"] = "Котел";
	AL["Cauldrons"] = "Котлы";
	AL["Guardian Elixirs"] = "Оборонительные эликсиры";
	AL["Oils"] = "Масла";
	AL["Other Elixirs"] = "Другие элексиры";
	AL["Potions"] = "Зелья";
	AL["Transmutes"] = "Трансмутация";
	AL["Flasks"] = "Фляги";
	
	-- Blacksmithing
	AL["Cataclysm Vendor Sold Plans"] = "Чертежы Cataclysmа у торговцев";
	AL["Armor Enhancements"] = "Улучшения доспехов";
	AL["Weapon Enhancements"] = "Улучшения оружия";

	-- Enchanting
	AL["Enchant Boots"] = "Чары для обуви";
	AL["Enchant Bracer"] = "Чары для наручей";
	AL["Enchant Chest"] = "Чары для нагрудника";
	AL["Enchant Cloak"] = "Чары для плаща";
	AL["Enchant Gloves"] = "Чары для перчаток";
	AL["Enchant Ring"] = "Чары для кольца";
	AL["Enchant Shield & Off-Hand"] = "Чары для щита";
	AL["Enchant 2H Weapon"] = "Чары для двуручного оружия";
	AL["Enchant Weapon"] = "Чары для оружия";
	AL["Cataclysm Vendor Sold Formulas"] = "Формулы Cataclysmа у торговцев";
	
	-- Engineering
	AL["Tinker"] = "Конструирование";

	-- Inscription
	AL["Major Glyph"] = "Большой символ";
	AL["Minor Glyph"] = "Малый символ";
	AL["Runescrolls"] = "Рунические свитки";
	AL["Recall"] = "Возвраты";
	AL["Scrolls"] = "Свитки";
	AL["Off-Hand Items"] = "Предметы в левую руку";
	AL["Shoulder Enchants"] = "Наложения на плечи";
	AL["Reagents"] = "Реагенты";
	AL["Book of Glyph Mastery"] = "Книга познания символов";

	-- Leatherworking
	AL["Leather Armor"] = "Кожанная броня";
	AL["Mail Armor"] = "Кольчужная броня";
	AL["Cloaks"] = "Плащи";
	AL["Item Enhancements"] = "Улучшения";
	AL["Drums, Bags and Misc."] = "Барабаны, Сумки и Другое";

	-- Tailoring
	AL["Shirts"] = "Рубашки";
	AL["Bags"] = "Сумки";
	AL["Cataclysm Vendor Sold Patterns"] = "Выкройки Cataclysmа у торговцев";

	-- Labels for loot descriptions
	AL["Classes:"] = "Классы:";
	AL["This Item Begins a Quest"] = "Этот предмет начинает задание";
	AL["Quest Item"] = "Предмет для задания";
	AL["Old Quest Item"] = "Прежний предмет для задания";
	AL["Quest Reward"] = "награда за задание";
	AL["Old Quest Reward"] = "Прежняя награда за задание";
	AL["Shared"] = "Разделенные";
	AL["Right Half"] = "Правая половина";
	AL["Left Half"] = "Левая половина";
	AL["Currency"] = "Испол-ся для покупки наград";
	AL["Used to summon boss"] = "Испол-ся для призыва босса";
	AL["Tradable for sunmote + item above"] = "В обмен на Частицу солнца + предметы выше";
	AL["Card Game Item"] = "Предмет игровых карт";
	AL["Skill Required:"] = "Необходим навык:";
	AL["Rating:"] = "Рейтинг"; -- Shorthand for 'Required Rating' for the personal/team ratings
	AL["Random Heroic Reward"] = "Случайные награды с героика";
	AL["Fishing Daily Reward"] = "Награды за рыболовский эжедн.";
	AL["Collector's Edition"] = "Коллекционное издание";
	AL["Daily Reward"] = "Награды за эжедн. задания";
	AL["No Longer Available"] = "Больше не доступно";

	-- Minor Labels for loot table descriptions
	AL["Classic WoW"] = "Classic WoW";
	AL["Burning Crusade"] = "Burning Crusade";
	AL["Wrath of the Lich King"] = "Wrath of the Lich King";
	AL["Cataclysm"] = "Cataclysm";
	AL["Entrance"] = "Вход";
	AL["Dungeon Set 1"] = "Комплект подземелий 1";
	AL["Dungeon Set 2"] = "Комплект подземелий 2";
	AL["Dungeon Set 1/2"] = "Комплект подземелий 1/2";
	AL["Dungeon Set 3"] = "Комплект подземелий 3";
	AL["Tier 1"] = "Тир 1";
	AL["Tier 2"] = "Тир 2";
	AL["Tier 3"] = "Тир 2";
	AL["Tier 4"] = "Тир 4";
	AL["Tier 5"] = "Тир 5";
	AL["Tier 6"] = "Тир 6";
	AL["Tier 7"] = "Тир 7";
	AL["Tier 8"] = "Тир 8";
	AL["Tier 9"] = "Тир 9";
	AL["Tier 10"] = "Тир 10";
	AL["Tier 11"] = "Тир 11";
	AL["10 Man"] = "10-чел";
	AL["10/25 Man"] = "10/25 Чел";
	AL["Epic Set"] = "Превосходные комплекты";
	AL["Rare Set"] = "Редкие комплекты";
	AL["Season 9"] = "Сезон 9";
	AL["Season 10"] = "Сезон 10";
	AL["Season 11"] = "Сезон 11";
	AL["Fire"] = "Огонь";
	AL["Water"] = "Вода";
	AL["Wind"] = "Ветер";
	AL["Earth"] = "Земля";
	AL["Master Angler"] = "Лучший удильщик";
	AL["Fire Resistance Gear"] = "Наборы защиты от огня";
	AL["Arcane Resistance Gear"] = "Наборы защиты от тайной магии";
	AL["Nature Resistance Gear"] = "Наборы защиты от магии природы";
	AL["Frost Resistance Gear"] = "Наборы защиты от льда";
	AL["Shadow Resistance Gear"] = "Наборы защиты от магии тьмы";

	-- Labels for loot table sections
	AL["Additional Heroic Loot"] = "Допол. добыча с героиков";
	AL["Heroic Mode"] = "Героик";
	AL["Normal Mode"] = "Обычный";
	AL["Raid"] = "Рейд";
	AL["Hard Mode"] = "Сложный режим";
	AL["Bonus Loot"] = "Дополнительная добыча";
	AL["Arena Reward"] = "Награды с Арены";
	AL["Achievement Reward"] = "Награда за достижение";
	AL["Phase 1"] = "Фаза 1";
	AL["Phase 2"] = "Фаза 2";
	AL["Phase 3"] = "Фаза 3";
	AL["First Prize"] = "Первый приз";
	AL["Rare Fish Rewards"] = "Редкая рыба - Награды";
	AL["Rare Fish"] = "Редкая Рыба";
	AL["Heirloom"] = "Фамильные";
	AL["Weapons"] = "Оружия";
	AL["Accessories"] = "Аксессуары";
	AL["Rare"] = "Редкий";
	AL["Specializations"] = "Специализации";

	-- Loot Table Names
	AL["Level 30-39"] = "Уровни 30-39";
	AL["Level 40-49"] = "Уровни 40-49";
	AL["Level 50-60"] = "Уровни 50-60";
	AL["Summon"] = "Призыв";
	AL["Random"] = "Случайный";
	AL["Brew of the Month Club"] = "Клуб \"Пиво месяца\"";

	-- Profession descriptions
	AL["Buff"] = "Полож. эффект";
	AL["Agility"] = "Ловкость";
	AL["Intellect"] = "Интеллект";
	AL["Strength"] = "Сила";
	AL["Spirit"] = "Дух";
	AL["Stamina"] = "Выносливость";
	AL["Spell Power"] = "Сила заклинаний";
	AL["Attack Power"] = "Сила атаки";
	AL["Spell/Attack Power"] = "Сила атаки/заклинаний";
	AL["Hit Rating"] = "Меткость";
	AL["Crit Rating"] = "Крит";
	AL["Haste Rating"] = "Скорость";
	AL["Dodge Rating"] = "Уклонение";
	AL["Expertise Rating"] = "Мастерство";
	AL["Mastery Rating"] = "Искусность";
	AL["Parry Rating"] = "Парирование";
	AL["Other Ratings"] = "Другое";
	AL["Ratings"] = "Рейтинги";
	AL["Damage Absorption"] = "Поглощение урона";
	AL["Health / Second"] = "Здоровье / сек.";
	AL["Mana / Second"] = "Мана / сек.";
	AL["Tracking"] = "Отслеживание";
	AL["Emotions"] = "Эмоции";
	AL["Alcohol"] = "Алкоголь";
	AL["Health"] = "Здоровье";
	AL["Mana"] = "Мана";
	AL["Health and Mana"] = "Здоровье и Мана";
	AL["Other Buffs"] = "Другие эффекты";
	AL["Other"] = "Другое";
	AL["Standard Buffs"] = "Стандартные эффекты";
	AL["Food without Buffs"] = "Еда без эффектов";
	AL["Special"] = "Специальное";
	AL["Feasts"] = "Пиры";
	AL["Speed"] = "Скорость";
	AL["Oil"] = "Масло";
	AL["Dwarf"] = "Дворфы";
	AL["Draenei"] = "Дренеи";
	AL["Night Elf"] = "Ночные эльфы";
	AL["Fossil"] = "Окаменелости";
	AL["Nerubian"] = "Нерубы";
	AL["Vrykul"] = "Врайкулы";
	AL["Troll"] = "Тролли";
	AL["Tol'vir"] = "Тол'виры";
	AL["Orc"] = "Орки";
	AL["Stats"] = "Статистика";
	AL["Resilience"] = "Устойчивость";
	AL["Professions"] = "Профессии";
	AL["Damage"] = "Урон";

	-- Extra Text in Boss lists
	AL["AQ20 Class Sets"] = "Классовые комплекты АК20";
	AL["AQ Enchants"] = "Наложения чар из АК";
	AL["AQ40 Class Sets"] = "Классовые комплекты АК40";
	AL["AQ Opening Quest Chain"] = "Цепь заданий открытия АК";
	AL["Tribute Run"] = "Заход почести";
	AL["Dire Maul Books"] = "Книги Забытого Города";
	AL["Random Boss Loot"] = "Трофеи случайных боссов";
	AL["Formula/Patterns/Plans"] = "формулы/выкройки/чертежы";
	AL["BRD Blacksmithing Plans"] = "ГЧГ - Чертежи для кузнецов";
	AL["Patterns/Plans"] = "выкройки/чертежы";

	-- General titles
	AL["Achievement"] = "Достижение";
	
	-- Companions
	AL["Card Game Companions"] = "Спутники с игровых карт";
	AL["Companion Accessories"] = "Аксессуары спутников";
	AL["Crafted Companions"] = "Созданные спутники";
	AL["Dungeon/Raid"] = "Подземелье/Рейд";
	AL["Faction"] = "Фракция";
	AL["Merchant Sold Companions"] = "Продаваемые спутники";
	AL["Pets"] = "Питомцы";
	AL["Promotional Companions"] = "Поощрительные спутники";
	AL["Quest Reward Companions"] = "Спутники за задание";
	AL["Rare Companions"] = "Редкие спутники";
	AL["Unobtainable Companions"] = "Недоступные спутники";

	-- Mounts
	AL["Alliance Mounts"] = "Транспорт Альянса";
	AL["Horde Mounts"] = "Транспорт Орды";
	AL["Card Game Mounts"] = "Транспорт с игральных карт";
	AL["Crafted Mounts"] = "Созданный транспорт";
	AL["Event Mounts"] = "Транспорт с событий";
	AL["Neutral Faction Mounts"] = "Транспорт у равнодушных фракций";
	AL["PvP Mounts"] = "PvP транспорт";
	AL["Alliance PvP Mounts"] = "PvP транспорт Альянса";
	AL["Horde PvP Mounts"] = "PvP транспорт Орды";
	AL["Halaa PvP Mounts"] = "PvP транспорт Халаа";
	AL["Promotional Mounts"] = "Поощрительный транспорт";
	AL["Rare Mounts"] = "Редкий транспорт";
	AL["Unobtainable Mounts"] = "Недоступный транспорт";

	-- Tabards
	AL["Achievement & Quest Reward Tabards"] = "Накидки за достижения и фракции";
	AL["Alliance Tabards"] = "Накидки альянса";
	AL["Card Game Tabards"] = "Накидки с игровых карт";
	AL["Horde Tabards"] = "Накидки орды";
	AL["PvP Tabards"] = "PvP накидки";
	AL["Unobtainable Tabards"] = "Недоступные накидки";

	-- Darkmoon Faire
	AL["Darkmoon Faire Rewards"] = "Награды Ярмарки Новолуния";
	AL["Low Level Decks"] = "Низко уровневые колоды";
	AL["Level 60 & 70 Trinkets"] = "Аксессуары на 60/70 урв";
	AL["Trinkets"] = "Аксессуары";

	-- Card Game Decks and descriptions
	AL["Loot Card Items"] = "Предметы с карт";
	AL["UDE Items"] = "Предметы UDE";

	-- First set
	AL["Heroes of Azeroth"] = "Герои Азерота";
	AL["Landro Longshot"] = "Ландро Дальнострел";
	AL["Thunderhead Hippogryph"] = "Гиппогриф Громовой вершины";
	AL["Saltwater Snapjaw"] = "Морской щелкоклюв";

	-- Second set
	AL["Through The Dark Portal"] = "Через Темный портал";
	AL["King Mukla"] = "Король Мукла";
	AL["Rest and Relaxation"] = "Отдых и покой";
	AL["Fortune Telling"] = "Fortune Telling";

	-- Third set
	AL["Fires of Outland"] = "Огни Запределья";
	AL["Spectral Tiger"] = "Призрачный Тигр";
	AL["Gone Fishin'"] = "Gone Fishin'";
	AL["Goblin Gumbo"] = "Гоблинское хлебово";

	-- Fourth set
	AL["March of the Legion"] = "Граница легиона";
	AL["Kiting"] = "Kiting";
	AL["Robotic Homing Chicken"] = "Robotic Homing Chicken";
	AL["Paper Airplane"] = "Бумажный аэроплан";

	-- Fifth set
	AL["Servants of the Betrayer"] = "Слуги Предателя";
	AL["X-51 Nether-Rocket"] = "Ракета Пустоты X-51";
	AL["Personal Weather Machine"] = "Личная погодная машина";
	AL["Papa Hummel's Old-fashioned Pet Biscuit"] = "Старомодное лакомство для питомцев от Папаши Хюммеля";

	-- Sixth set
	AL["Hunt for Illidan"] = "Охота на Иллидана";
	AL["The Footsteps of Illidan"] = "Путь Иллидана";
	AL["Disco Inferno!"] = "Диско-шар";
	AL["Ethereal Plunderer"] = "Эфириал-призыватель";

	-- Seventh set
	AL["Drums of War"] = "Барабаны войны";
	AL["The Red Bearon"] = "The Red Bearon";
	AL["Owned!"] = "Owned!";
	AL["Slashdance"] = "Slashdance";

	-- Eighth set
	AL["Blood of Gladiators"] = "Кровь гладиаторов";
	AL["Sandbox Tiger"] = "Тигр-качалка";
	AL["Center of Attention"] = "В центре внимания";
	AL["Foam Sword Rack"] = "Подставка для мечя из пенополимера";

	-- Ninth set
	AL["Fields of Honor"] = "Поля чести";
	AL["Path of Cenarius"] = "Путь Кенария";
	AL["Pinata"] = "Пиньята";
	AL["El Pollo Grande"] = "Бройлеро гиганто";

	-- Tenth set
	AL["Scourgewar"] = "Scourgewar";
	AL["Tiny"] = "Tiny";
	AL["Tuskarr Kite"] = "Клыкаррский воздушный змей";
	AL["Spectral Kitten"] = "Призрачный тигренок";

	-- Eleventh set
	AL["Wrathgate"] = "Врата Гнева";
	AL["Statue Generator"] = "генератор статуэтки";
	AL["Landro's Gift"] = "Подарки Ландро";
	AL["Blazing Hippogryph"] = "Пламенеющий гиппогриф";

	-- Twelvth set
	AL["Icecrown"] = "Ледяная Корона";
	AL["Wooly White Rhino"] = "Белый шерстистый носорог";
	AL["Ethereal Portal"] = "Эфириальный портал";
	AL["Paint Bomb"] = "Бомба с краской";

	-- Thirtheenth set
	AL["Worldbreaker"] = "Миродробитель";
	AL["Mottled Drake"] = "Пятнистый верховой дракон";
	AL["Grim Campfire"] = "Мрачный костер";
	AL["Landro's Lil' XT"] = "Разрушитель XXS-002 Ландро";
	
	-- Fourteenth set
	AL["War of the Elements"] = "War of the Elements";

	-- Fifteenth set
	AL["Twilight of the Dragons"] = "Twilight of the Dragons";

	-- Battleground Brackets
	AL["Old PvP Rewards"] = "Старые нарады PvP";
	AL["BG/Open PvP Rewards"] = "награды поля боя/открытого PvP";
	AL["Misc. Rewards"] = "Разные награды";
	AL["Level 10-19 Rewards"] = "Награды 10-19 уровня";
	AL["Level 20-39 Rewards"] = "Награды 20-39 уровня";
	AL["Level 20-29 Rewards"] = "Награды 20-29 уровня";
	AL["Level 30-39 Rewards"] = "Награды 30-39 уровня";
	AL["Level 40-49 Rewards"] = "Награды 40-49 уровня";
	AL["Level 50-59 Rewards"] = "Награды 50-59 уровня";
	AL["Level 60 Rewards"] = "Награды 60 уровня";

	-- Brood of Nozdormu Paths
	AL["Path of the Conqueror"] = "Путь победителя";
	AL["Path of the Invoker"] = "Путь заклинателя";
	AL["Path of the Protector"] = "Путь защитника";

	-- Violet Eye Paths
	AL["Path of the Violet Protector"] = "Защитник из Аметистового Ока";
	AL["Path of the Violet Mage"] = "Маг из Аметистового Ока";
	AL["Path of the Violet Assassin"] = "Убийца из Аметистового Ока";
	AL["Path of the Violet Restorer"] = "Исцелитель из Аметистового Ока";

	-- Ashen Verdict Paths
	AL["Path of Courage"] = "Путь отваги";
	AL["Path of Destruction"] = "Путь разрушения";
	AL["Path of Vengeance"] = "Путь мести";
	AL["Path of Wisdom"] = "Путь мудрости";

	-- AQ Opening Event
	AL["Red Scepter Shard"] = "Осколок красного скипетра";
	AL["Blue Scepter Shard"] = "Осколки синего скипетра";
	AL["Green Scepter Shard"] = "Осколок зеленого скипетра";
	AL["Scepter of the Shifting Sands"] = "Скипетр Зыбучих песков";

	-- World PvP
	AL["Hellfire Fortifications"] = "Штурмовые укрепления";
	AL["Twin Spire Ruins"] = "Руины Двух Башен";
	AL["Spirit Towers"] = "Башни Духов";
	AL["Halaa"] = "Халаа";
	AL["Venture Bay"] = "Бухта торговцев";

	-- Karazhan Opera Event Headings
	AL["Wizard of Oz"] = "Страна Оз";
	AL["Red Riding Hood"] = "Красная Шапочка";

	-- Karazhan Animal Boss Types
	AL["Spider"] = "Паук";
	AL["Darkhound"] = "Пес тьмы";
	AL["Bat"] = "Летучая мышь";

	-- AQ20 Tokens
	AL["Qiraji Ornate Hilt"] = "Киражская изысканная рукоять";
	AL["Qiraji Martial Drape"] = "Киражская воинская пелерина";
	AL["Qiraji Magisterial Ring"] = "Киражское кольцо власти";
	AL["Qiraji Ceremonial Ring"] = "Киражское церемониальное кольцо";
	AL["Qiraji Regal Drape"] = "Киражская царская пелерина";
	AL["Qiraji Spiked Hilt"] = "Киражская шипастая рукоять";

	-- AQ40 Tokens
	AL["Qiraji Bindings of Dominance"] = "Киражские наручники Господства";
	AL["Qiraji Bindings of Command"] = "Киражские наручники Командования";
	AL["Vek'nilash's Circlet"] = "Венец Век'нилаша";
	AL["Vek'lor's Diadem"] = "Диадема Век'лора";
	AL["Ouro's Intact Hide"] = "Целая шкура Оуро";
	AL["Skin of the Great Sandworm"] = "Шкура гигантского песчаного червя";
	AL["Husk of the Old God"] = "Броня Древнего Бога";
	AL["Carapace of the Old God"] = "Панцирь Древнего Бога";

	-- Faction related strings
	AL["Neutral"] = "Равнодушие";
	AL["Friendly"] = "Дружелюбие";
	AL["Honored"] = "Уважение";
	AL["Revered"] = "Почтение";
	AL["Exalted"] = "Превознесение";
	AL["Best Friend"] = "Лучший друг";
	AL["Winterfin Retreat"] = "Холодный Плавник";

	-- Recipe origin strings
	AL["Trainer"] = "Тренер";
	AL["Discovery"] = "Находка";
	AL["World Drop"] = "Мировой выпад";
	AL["Drop"] = "Падает";
	AL["Vendor"] = "Продавец";
	AL["Crafted"] = "Создано";

	-- Months
	AL["January"] = "Январь";
	AL["February"] = "Февраль";
	AL["March"] = "Март";
	AL["April"] = "Апрель";
	AL["May"] = "Май";
	AL["June"] = "Июнь";
	AL["July"] = "Июль";
	AL["August"] = "Август";
	AL["September"] = "Сентябрь";
	AL["October"] = "Октябрь";
	AL["November"] = "Ноябрь";
	AL["December"] = "Декабрь";

	-- Specs
	AL["Balance"] = "Баланс";
	AL["Feral"] = "Сила зверя";
	AL["Restoration"] = "Исцеление";
	AL["Holy"] = "Свет";
	AL["Discipline"] = "Послушание";
	AL["Protection"] = "Защита";
	AL["Retribution"] = "Возмездие";
	AL["Shadow"] = "Темная магия";
	AL["Elemental"] = "Стихии";
	AL["Enhancement"] = "Совершенствование";
	AL["Fury"] = "Неистовство";
	AL["Demonology"] = "Демонология";
	AL["Destruction"] = "Разрушение";
	AL["Tanking"] = "Танкования";
	AL["DPS"] = "ДПС";

	-- NPCs missing from BabbleBoss
	AL["Trash Mobs"] = "Существа";
	AL["Dungeon Set 2 Summonable"] = "Комплект подземелий 2 вызываемый";
	AL["Theldren"] = "Телдрена";
	AL["Sothos and Jarien"] = "Сотос и Джариен";
	AL["Druid of the Fang"] = "Друид Клыка";
	AL["Defias Strip Miner"] = "Горнорабочий из Братства Справедливости";
	AL["Defias Overseer/Taskmaster"] = "Надзиратель из Братства Справедливости/Надсмотрщик";
	AL["Scarlet Trainee"] = "Новобранец из Алого ордена";
	AL["Shadowforge Flame Keeper"] = "Тенегорнский хранитель огня";
	AL["Avatar of the Martyred"] = "Аватара Мученика";
	AL["Nexus Stalker"] = "Ловчий нексуса";
	AL["Auchenai Monk"] = "Аукенайский монах";
	AL["Cabal Fanatic"] = "Кабалист-фанатик";
	AL["Unchained Doombringer"] = "Освободенный Носитель Рока";
	AL["Crimson Sorcerer"] = "Багровый колдун";
	AL["Thuzadin Shadowcaster"] = "Темный чародей из секты Тузадин";
	AL["Crimson Inquisitor"] = "Инквизитор из Багрового Легиона";
	AL["Crimson Battle Mage"] = "Боевой маг из Багрового Легиона";
	AL["Ghoul Ravener"] = "Вурдалак-стервятник";
	AL["Spectral Citizen"] = "Призрачный горожанин";
	AL["Spectral Researcher"] = "Призрачный ученый";
	AL["Scholomance Adept"] = "Адепт Некроситета";
	AL["Scholomance Dark Summoner"] = "Призыватель Тьмы Некроситета";
	AL["Blackhand Elite"] = "Элитный боец легиона Чернорука";
	AL["Firebrand Pyromancer"] = "Пиромант из легиона Огненного Клейма";
	AL["Firebrand Invoker"] = "Призыватель духов из легиона Огненного Клейма";
	AL["Firebrand Grunt"] = "Рубака из легиона Огненного Клейма";
	AL["Firebrand Legionnaire"] = "Легионер из легиона Огненного Клейма";
	AL["Spirestone Warlord"] = "Полководец из клана Черной Вершины";
	AL["Spirestone Mystic"] = "Мистик из клана Черной Вершины";
	AL["Anvilrage Captain"] = "Капитан из клана Ярости Горна";
	AL["Anvilrage Marshal"] = "Маршал из клана Ярости Горна";
	AL["Doomforge Arcanasmith"] = "Кузнец-волшебник из клана Кузни Рока";
	AL["Weapon Technician"] = "Оружейный техник";
	AL["Doomforge Craftsman"] = "Ремесленник из клана Кузни Рока";
	AL["Murk Worm"] = "Мракочервь";
	AL["Raging Skeleton"] = "Свирепый скелет";
	AL["Ethereal Priest"] = "Эфириал-жрец";
	AL["Sethekk Ravenguard"] = "Сетеккский враностраж";
	AL["Time-Lost Shadowmage"] = "Затерянный во времени темный маг";
	AL["Coilfang Sorceress"] = "Колдунья из резервуара Кривого Клыка";
	AL["Coilfang Oracle"] = "Оракул из резервуара Кривого Клыка";
	AL["Shattered Hand Centurion"] = "Центурион клана Изувеченной Длани";
	AL["Eredar Deathbringer"] = "Смертоносный эредар";
	AL["Arcatraz Sentinel"] = "Часовой Аркатраца";
	AL["Gargantuan Abyssal"] = "Чудовищный магматический инфернал";
	AL["Sunseeker Botanist"] = "Солнцелов-ботаник";
	AL["Sunseeker Astromage"] = "Солнцелов-астромаг";
	AL["Durnholde Rifleman"] = "Дарнхольдский ружейник";
	AL["Rift Keeper/Rift Lord"] = "Повелитель/Хранительница временного разлома";
	AL["Crimson Templar"] = "Багровый храмовник";
	AL["Azure Templar"] = "Лазурный храмовник";
	AL["Hoary Templar"] = "Седой храмовник";
	AL["Earthen Templar"] = "Земной храмовник";
	AL["The Duke of Cynders"] = "Герцог Пепла";
	AL["The Duke of Fathoms"] = "Герцог Глубин";
	AL["The Duke of Zephyrs"] = "Герцог Ветров";
	AL["The Duke of Shards"] = "Герцог Осколков";
	AL["Aether-tech Assistant"] = "Помощник эфир-теха";
	AL["Aether-tech Adept"] = "Адепт эфир-теха";
	AL["Aether-tech Master"] = "Мастер эфир-теха";
	AL["Smokywood Pastures Vendor"] = "торговец-Пастбища Дымного Леса";
	AL["Darkscreecher Akkarai"] = "Темный Крикун Аккарай";
	AL["Bash'ir Landing Stasis Chambers"] = "Палаты стазиса Лагеря Баш'ира";
	AL["Templars"] = "Храмовники";
	AL["Dukes"] = "Герцоги";
	AL["High Council"] = "Верховный советник";
	AL["Scarshield Quartermaster"] = "Интендант из легиона Изрубленного Щита";
	AL["Father Flame"] = "Огонь отцов";
	AL["Thomas Yance"] = "Томас Янс";
	AL["Knot Thimblejack"] = "Уззл Наперстяк";
	AL["Shen'dralar Provisioner"] = "Шен'драларский поставщик";
	AL["The Nameles Prophet"] = "Безымянный пророк";
	AL["Rajaxx's Captains"] = "Капитаны Раджакса";
	AL["Razorfen Spearhide"] = "Копьешкур из племени Иглошкурых";
	AL["Magregan Deepshadow"] = "Магреган Чернотень";
	AL["Don Carlos"] = "Дон Карлос";
	AL["Aged Dalaran Wizard"] = "Даларанский старый волшебник";
	AL["Felsteed"] = "Скакун Скверны";
	AL["Shattered Hand Executioner"] = "Палач из клана Изувеченной Длани";
	AL["Deviate Ravager/Deviate Guardian"] = "Загадочный опустошитель/Загадочный страж";
	AL["Servant's Quarter Animal Bosses"] = "Боссы Комнаты Слуг";
	AL["Master Elemental Shaper Krixix"] = "Ваятель стихий Криксикс";

	-- Zone related strings
	AL["Azeroth"] = "Азерот";
	AL["Blackrock Mountain"] = "Черная гора";
	AL["Caverns of Time"] = "Пещеры Времени";
	AL["Crusader's Square"] = "Площадь рыцарей";
	AL["Darkmoon Island"] = "Остров Новолуния";
	AL["East"] = "Восток";
	AL["North"] = "Север";
	AL["The Gauntlet"] = "Улица Испытаний";
	AL["Trial of the Grand Crusader"] = "Испытание великого крестоносца";
	AL["West"] = "Запад";

	-- Shortcuts for Bossname files
	AL["Avatar"] = "Аватара"; -- Avatar of the Martyred

	-- Chests, etc
	AL["The Grim Guzzler"] = "Угрюмый обжора";
	AL["The Secret Safe"] = "Секретность";
	AL["The Vault"] = "Чертог";
	AL["Ogre Tannin Basket"] = "Огрский дубильный чан";
	AL["Unfinished Painting"] = "Незаконченная картина";
	AL["Felvine Shard"] = "Сквернит";
	AL["Gift of Adoration"] = "Дар обожания";
	AL["Treat Bag"] = "Сумка с лакомствами";
	AL["Timed Reward Chest"] = "Сундук, награда за время";
	AL["Timed Reward Chest 1"] = "1-й сундук, награда за время";
	AL["Timed Reward Chest 2"] = "2-й сундук, награда за время";
	AL["Timed Reward Chest 3"] = "3-й сундук, награда за время";
	AL["The Talon King's Coffer"] = "Сундук Короля Когтей";
	AL["Krom Stoutarm's Chest"] = "Сундук Крома Крепкорука";
	AL["Garrett Family Chest"] = "Сундук семейства Гарретт";
	AL["Reinforced Fel Iron Chest"] = "Укрепленный сундук из оскверненного железа";
	AL["DM North Tribute Chest"] = "Северный сундук с наградами в МК";
	AL["The Saga of Terokk"] = "Сказание о Терокке";
	AL["First Fragment Guardian"] = "Страж первого фрагмента";
	AL["Second Fragment Guardian"] = "Страж второго фрагмента";
	AL["Third Fragment Guardian"] = "Страж третьего фрагмента";
	AL["Overcharged Manacell"] = "Избыточно заряженный аккумулятор маны";

	-- Error Messages and warnings
	AL["AtlasLoot Error!"] = "Ошибка AtlasLoot!";
	AL["WishList Full!"] = "Список нужного полон!";
	AL["No match found for"] = "Ничего не найдено для";
	AL[" is safe."] = " безопасный.";
	AL["Server queried for "] = "Запрос с севрера для ";
	AL[".  Right click on any other item to refresh the loot page."] = ".  Правый клик по любому другому предмету для обновления страници трофеев.";

	-- Incomplete Table Registry error message
	AL[" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = " не включен в таблицу списка трофеев, пожалуйста сообщите об этом сообщении на форум http://www.atlasloot.net";

	-- LoD Module disabled or missing
	AL[" is unavailable, the following load on demand module is required: "] = " недоступен, требуется следующий модуль загрузки по требованию: ";

	-- LoD Module load sequence could not be completed
	AL["Status of the following module could not be determined: "] = "Статус следующих модулей не определен: ";

	-- LoD Module required has loaded, but loot table is missing
	AL[" could not be accessed, the following module may be out of date: "] = " не может получить доступ, следующий модуль может быть устаревшим: ";

	-- LoD module not defined
	AL["Loot module returned as nil!"] = "Модуль трофеев возвращен к нолевому значеню!";

	-- LoD module loaded successfully
	AL["sucessfully loaded."] = "успешно загружен.";

	-- Need a big dataset for searching
	AL["Loading available tables for searching"] = "Загружаются доступные для поиска таблицы";

	-- All Available modules loaded
	AL["All Available Modules Loaded"] = "Все доступные модули загружены";

	-- First time user
	AL["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences."] = "Добро пожаловать в Atlasloot Enhanced.  Пожалуйста уделите чуточку времени для установки ваших предпочтений.";
	AL["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "Добро пожаловать в Atlasloot Enhanced.  Пожалуйста уделите чуточку времени для установки ваших предпочтений? подсказок, ссылок в окно чата.\n\n  Это окно настроек может быть вызванно в любоя время вводом в чат команды: '/atlasloot'.";
	AL["Setup"] = "Установки";

	-- Old Atlas Detected
	AL["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "Обнаружено что Ваша версия Атласа не соответствует версии, под которую зделан Atlasloot (";
	AL[").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = ").  В зависимости от изменений может быть случайная ошибка но лучше всего посетите http://www.atlasmod.com и убедитесь что у вас стоит последняя версия донного аддона.";
	AL["OK"] = "OK";
	AL["Incompatible Atlas Detected"] = "Обноружен несовместимый Атлас";

	-- Unsafe item tooltip
	AL["Unsafe Item"] = "Опасный предмет";
	AL["This item is not available on your server or your battlegroup yet."] = "Этот предмет пока что недоступен на вашем сервере или боевой группе.";
	AL["You can right-click to attempt to query the server.  You may be disconnected."] = "Вы можете щелкнуть правой кнопкой, чтобы попытаться запросить информацию о предмете.  Имеется риск отсоединения от сервера.";
end