--[[
	basicRules.lua
		Basic filtering rules for vBagnon
--]]

--all slots
function BagnonRule.All()
	return true
end

--slots with items
function BagnonRule.Items(link)
	return link
end

--slots without items
function BagnonRule.Empty(link)
	return not link
end

--trinkets
function BagnonRule.Trinkets(link)
	local loc = select(8, Bagnon_GetData(link))
	return loc == "INVTYPE_TRINKET"
end

--weapons
function BagnonRule.Weapons(link)
	local type = select(6, Bagnon_GetData(link))
	return type == "Weapon"
end

--armor
function BagnonRule.Armor(link)
	local type = select(6, Bagnon_GetData(link))
	return type == "Armor"
end

--quest items
function BagnonRule.Quest(link)
	local type = select(6, Bagnon_GetData(link))
	return type == "Quest"
end

--trade goods and weapons used for tradeskills
function BagnonRule.Trade(link)
	local type, subType = select(6, Bagnon_GetData(link))
	return (type == "Trade Goods" or (type == "Weapon" and subType == "Miscellaneous"))
end

--all consumables, not named poison or bandage
function BagnonRule.Consumables(link)
	local name, _, _, _, type = select(2, Bagnon_GetData(link))
	return type == "Consumable" and not(name:find('poison') or name:find('bandage'))
end

--all consumables named bandages
function BagnonRule.Bandages(link)
	local name, _, _, _, type = select(2, Bagnon_GetData(link))
	return type == "Consumable" and name:find('bandage')
end

--reagents
function BagnonRule.Reagents(link)
	local type = select(6, Bagnon_GetData(link))
	return type == "Reagent"
end

--ammo
function BagnonRule.Ammo(link)
	local loc = select(8, Bagnon_GetData(link))
	return loc == "INVTYPE_AMMO"
end

--vendor trash
function BagnonRule.Trash(link)
	local quality = select(3, Bagnon_GetData(link))
	return quality == 0
end

--poisons
function BagnonRule.Poisons(link)
	local name, _, _, _, type = select(2, Bagnon_GetData(link))
	return type == "Consumable" and name:find('poison')
end

function BagnonRule.Miscellaneous(link)
	local quality, _, _, type = select(3, Bagnon_GetData(link))
	return quality and quality > 0 and type == "Miscellaneous"
end

function BagnonRule.Bank(_, bag)
	return Bagnon_IsBankBag(bag)
end

function BagnonRule.Inventory(_, bag)
	return Bagnon_IsInventoryBag(bag)
end

function BagnonRule.AmmoBag(_, bag)
	return Bagnon_IsAmmoBag(bag)
end

function BagnonRule.ProfessionBag(_, bag)
	return Bagnon_IsProfessionBag(bag)
end

--Item quality rules
for i = 0, 6 do
	BagnonRule[getglobal("ITEM_QUALITY" .. i .. "_DESC")] = function(link)
		local quality = select(3, Bagnon_GetData(link))
		return quality == i
	end
end