local mod	= DBM:NewMod(2691, "DBM-Raids-WarWithin", 1, 1302)
local L		= mod:GetLocalizedStrings()

mod:SetRevision("20260120005029")
mod:SetCreatureID(233824, 241517, 234478)--Yes, they're all used
mod:SetEncounterID(3135)
mod:SetBossHPInfoToHighest()--Boss Heals
mod:SetHotfixNoticeRev(20250823000000)
mod:SetMinSyncRevision(20250823000000)
mod:SetZone(2810)
mod.respawnTime = 29

mod:RegisterCombat("combat")

--Midnight private aura replacements
--TODO, add Null Binding? spam can't be controlled
mod:AddPrivateAuraSoundOption(1228206, true, 1228206, 1)
mod:AddPrivateAuraSoundOption(1243577, true, 1243577, 1)
mod:AddPrivateAuraSoundOption(1232394, true, 1232394, 1)--P3 gravity Well
mod:AddPrivateAuraSoundOption(1234243, true, 1234243, 1)
mod:AddPrivateAuraSoundOption(1234244, true, 1234244, 1)--P2 Inverse gravity
mod:AddPrivateAuraSoundOption(1249425, true, 1249425, 1)
mod:AddPrivateAuraSoundOption(1237696, true, 1237696, 1)--GTFO

function mod:OnLimitedCombatStart()
	self:EnablePrivateAuraSound(1228206, "targetyou", 2)
	self:EnablePrivateAuraSound(1243577, "scatter", 2)
	self:EnablePrivateAuraSound(1232394, "safenow", 2)
	self:EnablePrivateAuraSound(1234243, "scatter", 2)
	self:EnablePrivateAuraSound(1234244, "scatter", 2)
	self:EnablePrivateAuraSound(1249425, "lineyou", 17)
	self:EnablePrivateAuraSound(1237696, "watchfeet", 8)
end

--[[
mod:RegisterEventsInCombat(
	"SPELL_CAST_START 1230087 1248240 1229038 1230979 1238765 1237319 1237694 1249423 1239262 1237695 1233539 1234263 1232973 1234898 1251619",--1243690 1234044
	"SPELL_CAST_SUCCESS 1231716 1246541",--1237690 1234242
	"SPELL_AURA_APPLIED 1231005 1228206 1230168 1243699 1243577 1243609 1235114 1246930 1234243 1234244 1246145 1245292 1232394 1234266 1250055 1237102 1249425",
	"SPELL_AURA_APPLIED_DOSE 1230168 1246145 1234266",
	"SPELL_AURA_REMOVED 1229038 1243577 1243609 1234243 1234244 1233539 1249425",--1237690
	"SPELL_PERIODIC_DAMAGE 1231002 1237696",
	"SPELL_PERIODIC_MISSED 1231002 1237696",
	"UNIT_DIED",
	"CHAT_MSG_RAID_BOSS_EMOTE",
	"UNIT_SPELLCAST_START boss1 boss2 boss3",
	"UNIT_POWER_UPDATE boss1 boss2 boss3",
	"UNIT_SPELLCAST_SUCCEEDED boss1 boss2 boss3",
	"INSTANCE_ENCOUNTER_ENGAGE_UNIT"
)
--]]

--[[
ability.id = 1234898 and type = "begincast" or ability.id = 1245292 and type = "applydebuff" or ability.id = 1237102 and type = "applybuff"
--]]
--[[
local warnPhase										= mod:NewPhaseChangeAnnounce(2, nil, nil, nil, nil, nil, 2)
--Stage One: Critical Mass
mod:AddTimerLine(DBM:EJ_GetSectionInfo(32292))
local warnExcessMass								= mod:NewTargetNoFilterAnnounce(1228206, 1)
local warnMortalFragility							= mod:NewYouAnnounce(1230168, 4)
local warnDevourP1Over								= mod:NewEndAnnounce(1229038, 1)
local warnSpatialFragment							= mod:NewTargetNoFilterAnnounce(1243699, 1)
local warnAirbornRemoved							= mod:NewFadesAnnounce(1243609, 1)

local specWarnMassiveSmash							= mod:NewSpecialWarningCount(1230087, nil, 212336, nil, 2, 2)
local specWarnExcessMass							= mod:NewSpecialWarningYou(1228206, nil, nil, nil, 1, 2)
local specWarnMortalFragility						= mod:NewSpecialWarningTaunt(1230168, nil, nil, nil, 1, 2)
local specWarnDevourP1								= mod:NewSpecialWarningMoveTo(1229038, nil, nil, nil, 3, 2)
local specWarnDarkMatter							= mod:NewSpecialWarningMoveAwayCount(1230979, nil, nil, nil, 1, 2)
local specWarnShatteredSpace						= mod:NewSpecialWarningDodgeCount(1243690, nil, nil, nil, 2, 2)
local specWarnReverseGravity						= mod:NewSpecialWarningMoveAwayCount(1243577, nil, nil, nil, 1, 2)
local yellReverseGravity							= mod:NewShortYell(1243577)
local yellReverseGravityFades						= mod:NewShortFadesYell(1243577)
local specWarnAirborn								= mod:NewSpecialWarningYou(1243609, nil, nil, nil, 1, 2)
--local specWarnReverseGravityDispel				= mod:NewSpecialWarningDispel(1243577, nil, nil, nil, 1, 2)
local specWarnGTFO									= mod:NewSpecialWarningGTFO(1231002, nil, nil, nil, 1, 8)

local timerMassiveSmashCD							= mod:NewCDCountTimer(97.3, 1230087, 212336, nil, nil, 2)--Shortname "Smash"
local timerInfinitePossibilities					= mod:NewCastNPTimer(8, 1248240, nil, nil, nil, 5)
local timerDevourP1CD								= mod:NewCDCountTimer(97.3, 1229038, nil, nil, nil, 2, nil, DBM_COMMON_L.DEADLY_ICON)
local timerDarkMatterCD								= mod:NewCDCountTimer(97.3, 1230979, nil, nil, nil, 2, nil, DBM_COMMON_L.HEALER_ICON)
local timerShatteredSpaceCD							= mod:NewCDCountTimer(97.3, 1243690, nil, nil, nil, 2, nil, DBM_COMMON_L.HEALER_ICON)
local timerReverseGravityCD							= mod:NewCDCountTimer(97.3, 1243577, nil, nil, nil, 3)

mod:AddSetIconOption("SetIconOnLivingMass", -33474, false, 5, {6, 1, 2, 4, 7})
--mod:AddPrivateAuraSoundOption(433517, true, 433517, 1)
--Intermission: Event Horizon
mod:AddTimerLine(DBM:EJ_GetSectionInfo(32735))
local warnSoaringReshii								= mod:NewYouAnnounce(1235114, 1, nil, nil, 140013)--Short Text "Flight"
local warnStellarCore								= mod:NewYouAnnounce(1246930, 1)
--Stage Two: The Dark Heart
mod:AddTimerLine(DBM:EJ_GetSectionInfo(32477))
local warnCrushingGravityFaded						= mod:NewFadesAnnounce(1234243, 1)
local warnInverseGravityFaded						= mod:NewFadesAnnounce(1234244, 1)
local warnGravitationalDistortion					= mod:NewCountAnnounce(1234242, 2)

local specWarnExtinction							= mod:NewSpecialWarningDodgeCount(1238765, nil, nil, nil, 3, 2)
local specWarnGammaBurst							= mod:NewSpecialWarningCount(1237319, nil, nil, DBM_COMMON_L.PUSHBACK, 2, 13)
local specWarnCrushingGravity						= mod:NewSpecialWarningYou(1234243, nil, nil, nil, 1, 2, 4)
local specWarnInverseGravity						= mod:NewSpecialWarningYou(1234244, nil, nil, nil, 1, 2, 4)

local timerSoaringReshiiCD							= mod:NewNextTimer(35.2, 1235114, 140013, nil, nil, 3, nil, DBM_COMMON_L.DEADLY_ICON)--Short Text "Flight"
local timerExtinctionCD								= mod:NewCDCountTimer(35.2, 1238765, nil, nil, nil, 3, nil, DBM_COMMON_L.DEADLY_ICON)
local timerGammaBurstCD								= mod:NewCDCountTimer(35, 1237319, DBM_COMMON_L.PUSHBACK.." (%s)", nil, nil, 2, nil, DBM_COMMON_L.HEALER_ICON)
local timerGravitationalDistortionCD				= mod:NewCDCountTimer(97.3, 1234242, nil, nil, nil, 2, nil, DBM_COMMON_L.MYTHIC_ICON)
--The Devoured Lords
mod:AddTimerLine(DBM:EJ_GetSectionInfo(32738))
--local warnEclipseCast								= mod:NewCastAnnounce(1237690, 1, 32)
--Artoshion & Pargoth
local warnTouchofOblivion							= mod:NewStackAnnounce(1246145, 2, nil, "Tank|Healer")
local warnMassDestruction							= mod:NewTargetAnnounce(1249423, 3)

local specWarnMassEjection							= mod:NewSpecialWarningDodgeCount(1237694, nil, nil, nil, 2, 15)
local specWarnMassDestruction						= mod:NewSpecialWarningYouCount(1249423, nil, nil, nil, 2, 17, 4)--Mythic version of above
local yellMassDestruction							= mod:NewShortYell(1249423, DBM_COMMON_L.LINE)
local yellMassDestructionFades						= mod:NewShortFadesYell(1249423)
local specWarnConquerorsCross						= mod:NewSpecialWarningSwitchCount(1239262, "-Healer", nil, DBM_COMMON_L.ADDS, 1, 2)
local specWarnStardustNova							= mod:NewSpecialWarningDodgeCount(1237695, nil, 142775, nil, 2, 2)
local specWarnStarshardNova							= mod:NewSpecialWarningDodgeCount(1251619, nil, 142775, nil, 2, 2, 4)--Mythic version of above

local timerMassEjectionCD							= mod:NewCDCountTimer(17.6, 1237694, nil, nil, nil, 3)
local timerMassDestructionCD						= mod:NewCDCountTimer(97.3, 1249423, nil, nil, nil, 3, nil, DBM_COMMON_L.DEADLY_ICON)--Mythic version of above
local timerConquerorsCrossCD						= mod:NewCDCountTimer(35, 1239262, DBM_COMMON_L.ADDS.." (%s)", nil, nil, 1)
local timerStardustNovaCD							= mod:NewCDCountTimer(35.2, 1237695, 142775, nil, nil, 3)--Shortname "Nova"
local timerStarshardNovaCD							= mod:NewCDCountTimer(31.6, 1251619, 142775, nil, nil, 3)--Mythic version of above
local timerEclipseCD								= mod:NewNextTimer(35.2, 1237690, nil, nil, nil, 2, nil, DBM_COMMON_L.DEADLY_ICON)

--Adds they both summon
local specWarnNullBinding							= mod:NewSpecialWarningYou(1246541, nil, nil, nil, 1, 2)

--local timerNullBindingCD							= mod:NewCDNPTimer(97.3, 1246541, nil, nil, nil, 2)
--Stage Three: Singularity
mod:AddTimerLine(DBM:EJ_GetSectionInfo(32479))
local warnDestabalized 								= mod:NewTargetNoFilterAnnounce(1245292, 1)
local warnGravityWell								= mod:NewSpellAnnounce(1232394, 1)--Positive alert during devour
local warnDevourP3Over								= mod:NewEndAnnounce(1233539, 1)

local specWarnExtinguishTheStars					= mod:NewSpecialWarningDodgeCount(1231716, nil, 62134, nil, 2, 2)--shortname "Stars"
local specWarnDevourP3								= mod:NewSpecialWarningMoveTo(1233539, nil, nil, nil, 3, 2)
local specWarnDarkenedSky							= mod:NewSpecialWarningDodgeCount(1234044, nil, nil, DBM_COMMON_L.RINGS, 2, 2)
local specWarnCosmicCollapse						= mod:NewSpecialWarningDefensive(1234263, nil, 298160, nil, 2, 2)
local yellCosmicCollapse							= mod:NewShortYell(1234263, 298160)
local specWarnCosmicFragility						= mod:NewSpecialWarningTaunt(1234266, nil, nil, nil, 2, 2)
local specWarnSuperNova								= mod:NewSpecialWarningRunCount(1232973, nil, nil, nil, 4, 2)
local specWarnVoidgrasp								= mod:NewSpecialWarningYouCount(1250055, nil, nil, nil, 1, 2)

local timerExtinguishTheStarsCD						= mod:NewCDTimer(97.3, 1231716, 62134, nil, nil, 3)--shortname "Stars"
local timerDevourP3CD								= mod:NewCDCountTimer(97.3, 1233539, nil, nil, nil, 2)
local timerDarkenedSkyCD							= mod:NewCDCountTimer(97.3, 1234044, DBM_COMMON_L.RINGS.." (%s)", nil, nil, 3)
local timerCosmicCollapseCD							= mod:NewCDCountTimer(97.3, 1234263, 298160, nil, nil, 5)--Shortname "Collapse"
local timerSuperNovaCD								= mod:NewCDCountTimer(97.3, 1232973, nil, nil, nil, 2)
local timerVoidgraspCD								= mod:NewCDCountTimer(97.3, 1250055, nil, nil, nil, 3)

--BW Compatible Icon Marking
local livingMassMarkerMapTable = {6, 1, 2, 4, 7}

local collectiveGravityName = DBM:GetSpellName(1228207)
local gravityWellName = DBM:GetSpellName(1232394)
local devourCasting = false
local activeBossGUIDS = {}
--Stage 1
mod.vb.massiveSmashCount = 0
mod.vb.massSpawns = 0
mod.vb.devourCount = 0
mod.vb.darkMatterCount = 0
mod.vb.shatteredSpaceCount = 0
mod.vb.reverseGravityCount = 0
--Stage 2
mod.vb.extinctionCount = 0
mod.vb.gammaBurstCount = 0
mod.vb.distortionCount = 0
mod.vb.massEjectionCount = 0--Also used for Mythic variant Mass destruction
mod.vb.conquerorsCrossCount = 0
mod.vb.stardustCount = 0
--Stage 3
mod.vb.extinguishTheStarsCount = 0
mod.vb.darkenedSkyCount = 0
mod.vb.cosmicCollapseCount = 0
mod.vb.superNovaCount = 0
mod.vb.voidgraspCount = 0

local savedDifficulty = "normal"
local allTimers = {
	["mythic"] = {
		[1] = {
			[1230087] = {21.0, 42.1, 42.1, 42.1},--Massive Smash
			[1229038] = {10.5, 84.2, 84.2},--Devour P1
			[1230979] = {31.6, 39.0, 45.2, 39.0},--Dark Matter
			[1243690] = {36.8, 42.1, 42.1, 42.1},--Shattered Space
			[1243577] = {43.1, 42.1, 42.1, 42.1},--Reverse Gravity
		},
		[3] = {
			[1233539] = {47.6, 80, 80},--Devour P3
			[1234044] = {29.5, 43.0, 30.0, 50.0, 30.0},--Darkened Sky
			[1234263] = {57.4, 30.0, 30.0, 30.0, 30.0},--Cosmic Collapse
			[1234242] = {59.5, 26.0, 32.0, 26.0, 32.0},--Gravitational Distortion
		},
	},
	["heroic"] = {
		[1] = {
			[1230087] = {23.5, 47.0, 47.0, 47.0},--Massive Smash
			[1229038] = {11.7, 94.1, 94.1},--Devour P1
			[1230979] = {35.3, 43.5, 50.6, 43.5},--Dark Matter
			[1243690] = {41.2, 47.0, 47.1, 47.0},--Shattered Space
			[1243577] = {52.9, 42.4, 51.7, 42.4},--Reverse Gravity
		},
		[3] = {
			[1233539] = {47.5, 100},--Devour P3
			[1234044] = {29.7, 51.2, 33.1, 66.6, 33.1},--Darkened Sky
			[1234263] = {65, 33.3, 33.3, 33.3, 33.3, 33.3},--Cosmic Collapse
			[1232973] = {56.1, 14.4, 33.3, 33.3, 18.9, 14.5, 33.3, 33.3},--Super Nova
			[1250055] = {60, 33.3, 33.3, 33.3, 33.3, 33.3},--Voidgrasp
		},
	},
	["other"] = {
		[1] = {
			[1230087] = {25, 50, 50, 50},--Massive Smash
			[1229038] = {12.5, 100, 100},--Devour P1
			[1230979] = {37.5, 46.2, 53.7, 46.2},--Dark Matter
			[1243690] = {43.7, 50, 50, 50},--Shattered Space
			[1243577] = {56.2, 45, 55, 45},--Reverse Gravity (normal only, not used in LFR)
		},
		[3] = {
			[1233539] = {47.4, 100},--Devour P3
			[1234044] = {29.7, 51.2, 33.1, 66.6, 33.1},
			[1234263] = {65, 33.3, 33.3, 33.3, 33.3, 33.3, 33.3},--Cosmic Collapse
			[1232973] = {56.1, 14.4, 33.3, 33.3, 18.9, 14.4, 33.3, 33.3},--Super Nova
			[1250055] = {60, 33.3, 33.3, 33.3, 33.3, 33.3},--Voidgrasp
		},
	},
}

--Works around annoying bug where sometimes rings cast and even emote are missing events (but still happen)
local function checkForSkippedRings(self)
	self.vb.darkenedSkyCount = self.vb.darkenedSkyCount + 1
	local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, 1234044, self.vb.darkenedSkyCount+1)
	if timer then
		timerDarkenedSkyCD:Start(timer-10, self.vb.darkenedSkyCount+1)
		self:Unschedule(checkForSkippedRings)
		self:Schedule(timer, checkForSkippedRings, self)
	end
end

function mod:OnCombatStart(delay)
	devourCasting = false
	table.wipe(activeBossGUIDS)
	self:SetStage(1)
	self.vb.massiveSmashCount = 0
	self.vb.massSpawns = 0
	self.vb.devourCount = 0
	self.vb.darkMatterCount = 0
	self.vb.shatteredSpaceCount = 0
	self.vb.reverseGravityCount = 0
	self.vb.extinctionCount = 0
	self.vb.gammaBurstCount = 0
	self.vb.massEjectionCount = 0
	self.vb.conquerorsCrossCount = 0
	self.vb.stardustCount = 0
	self.vb.extinguishTheStarsCount = 0
	self.vb.darkenedSkyCount = 0
	self.vb.cosmicCollapseCount = 0
	self.vb.superNovaCount = 0
	self.vb.voidgraspCount = 0
	--self:EnablePrivateAuraSound(433517, "runout", 2)
	if self:IsMythic() then
		savedDifficulty = "mythic"
	elseif self:IsHeroic() then
		savedDifficulty = "heroic"
	else--Combine LFR and Normal
		savedDifficulty = "other"
	end
	timerMassiveSmashCD:Start(allTimers[savedDifficulty][1][1230087][1]-delay, 1)
	timerDevourP1CD:Start(allTimers[savedDifficulty][1][1229038][1]-delay, 1)
	timerDarkMatterCD:Start(allTimers[savedDifficulty][1][1230979][1]-delay, 1)
	timerShatteredSpaceCD:Start(allTimers[savedDifficulty][1][1243690][1]-delay, 1)
	if not self:IsLFR() then
		timerReverseGravityCD:Start(allTimers[savedDifficulty][1][1243577][1]-delay, 1)
	end
end

function mod:OnTimerRecovery()
	if self:IsMythic() then
		savedDifficulty = "mythic"
	elseif self:IsHeroic() then
		savedDifficulty = "heroic"
	else--Combine LFR and Normal
		savedDifficulty = "other"
	end
end

local function extraWarnDevour(self)
	if not devourCasting then return end
	if self:GetStage(1) then
		if not DBM:UnitDebuff("player", 1228207) then
			specWarnDevourP1:Show(collectiveGravityName)
			specWarnDevourP1:Play("gather")
		end
	else--Stage 3
		if not DBM:UnitDebuff("player", 1232394) then
			specWarnDevourP3:Show(gravityWellName)
			specWarnDevourP3:Play("findshelter")
		end
	end
end

function mod:SPELL_CAST_START(args)
	local spellId = args.spellId
	if spellId == 1230087 then
		self.vb.massSpawns = 0
		self.vb.massiveSmashCount = self.vb.massiveSmashCount + 1
		specWarnMassiveSmash:Show(self.vb.massiveSmashCount)
		specWarnMassiveSmash:Play("carefly")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.massiveSmashCount+1)
		if timer then
			timerMassiveSmashCD:Start(timer, self.vb.massiveSmashCount+1)
		end
	elseif spellId == 1248240 then
		timerInfinitePossibilities:Start(nil, args.sourceGUID)
	elseif spellId == 1229038 then
		devourCasting = true
		self.vb.devourCount = self.vb.devourCount + 1
		specWarnDevourP1:Show(collectiveGravityName)
		specWarnDevourP1:Play("gather")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.devourCount+1)
		if timer then
			timerDevourP1CD:Start(timer, self.vb.devourCount+1)
		end
		self:Schedule(2.5, extraWarnDevour, self)
	elseif spellId == 1230979 then
		self.vb.darkMatterCount = self.vb.darkMatterCount + 1
		specWarnDarkMatter:Show(self.vb.darkMatterCount)
		specWarnDarkMatter:Play("scatter")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.darkMatterCount+1)
		if timer then
			timerDarkMatterCD:Start(timer, self.vb.darkMatterCount+1)
		end
	elseif spellId == 1238765 then
		self.vb.extinctionCount = self.vb.extinctionCount + 1
		specWarnExtinction:Show(self.vb.extinctionCount)
		specWarnExtinction:Play("aesoon")
		timerExtinctionCD:Start(self:IsMythic() and 31.5 or 35.2, self.vb.extinctionCount+1)
	elseif spellId == 1237694 then
		self.vb.massEjectionCount = self.vb.massEjectionCount + 1
		specWarnMassEjection:Show(self.vb.massEjectionCount)
		specWarnMassEjection:Play("frontal")
		timerMassEjectionCD:Start(17.6, self.vb.massEjectionCount+1)
	elseif spellId == 1249423 then
		self.vb.massEjectionCount = self.vb.massEjectionCount + 1
		--timerMassDestructionCD:Start(35.2, self.vb.massEjectionCount+1)
	elseif spellId == 1239262 then
		--More consistent stage 2 setter for MRT and WAs and in sync with BW
		if self:GetStage(2, 1) then
			self:SetStage(2)
		end
		self.vb.conquerorsCrossCount = self.vb.conquerorsCrossCount + 1
		specWarnConquerorsCross:Show(self.vb.conquerorsCrossCount)
		specWarnConquerorsCross:Play("mobsoon")
		timerConquerorsCrossCD:Start(self:IsMythic() and 31.5 or 35, self.vb.conquerorsCrossCount+1)
	elseif spellId == 1237695 then
		self.vb.stardustCount = self.vb.stardustCount + 1
		specWarnStardustNova:Show(self.vb.stardustCount)
		specWarnStardustNova:Play("watchstep")
		timerStardustNovaCD:Start(35.2, self.vb.stardustCount+1)
	elseif spellId == 1251619 then
		self.vb.stardustCount = self.vb.stardustCount + 1
		specWarnStarshardNova:Show(self.vb.stardustCount)
		specWarnStarshardNova:Play("watchstep")
		timerStarshardNovaCD:Start(31.5, self.vb.stardustCount+1)
	elseif spellId == 1233539 then
		devourCasting = true
		self.vb.devourCount = self.vb.devourCount + 1
		specWarnDevourP3:Show(gravityWellName)
		specWarnDevourP3:Play("findshelter")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.devourCount+1)
		if timer then
			timerDevourP3CD:Start(timer, self.vb.devourCount+1)
		end
		self:Schedule(2.5, extraWarnDevour, self)
	--elseif spellId == 1234044 then
	--	self.vb.darkenedSkyCount = self.vb.darkenedSkyCount + 1
	--	specWarnDarkenedSky:Show(self.vb.darkenedSkyCount)
	--	specWarnDarkenedSky:Play("watchstep")
	--	local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.darkenedSkyCount+1)
	--	if timer then
	--		timerDarkenedSkyCD:Start(timer, self.vb.darkenedSkyCount+1)
	--	end
	elseif spellId == 1234263 then
		self.vb.cosmicCollapseCount = self.vb.cosmicCollapseCount + 1
		if self:IsTanking("player", "boss1", nil, true) then
			specWarnCosmicCollapse:Show()
			specWarnCosmicCollapse:Play("defensive")
			yellCosmicCollapse:Yell()
		end
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.cosmicCollapseCount+1)
		if timer then
			timerCosmicCollapseCD:Start(timer, self.vb.cosmicCollapseCount+1)
		end
	elseif spellId == 1232973 then
		self.vb.superNovaCount = self.vb.superNovaCount + 1
		specWarnSuperNova:Show(self.vb.superNovaCount)
		specWarnSuperNova:Play("runout")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.superNovaCount+1)
		if timer then
			timerSuperNovaCD:Start(timer, self.vb.superNovaCount+1)
		end
	elseif spellId == 1234898 then--Event Horizon
		warnPhase:Show(DBM_CORE_L.AUTO_ANNOUNCE_TEXTS.stage:format(1.5))
		warnPhase:Play("phasechange")
		self:SetStage(1.5)
		timerMassiveSmashCD:Stop()
		timerDevourP1CD:Stop()
		timerDarkMatterCD:Stop()
		timerShatteredSpaceCD:Stop()
		timerReverseGravityCD:Stop()
		timerSoaringReshiiCD:Start(13.8)
	end
end

function mod:SPELL_CAST_SUCCESS(args)
	local spellId = args.spellId
	if spellId == 1231716 then
		self.vb.extinguishTheStarsCount = self.vb.extinguishTheStarsCount + 1
		specWarnExtinguishTheStars:Show(self.vb.extinguishTheStarsCount)
		specWarnExtinguishTheStars:Play("watchstep")
	elseif spellId == 1246541 then--Spell is constantly stutter cast so we moved to success to reduce spam
		if self:AntiSpam(5, 1) and args:IsPlayer() then
			specWarnNullBinding:Show()
			specWarnNullBinding:Play("targetyou")
		end
	end
end

function mod:SPELL_AURA_APPLIED(args)
	local spellId = args.spellId
	if spellId == 1231005 and not activeBossGUIDS[args.destGUID] then
		self.vb.massSpawns = self.vb.massSpawns + 1
		if self.Options.SetIconOnLivingMass then
			self:ScanForMobs(args.destGUID, 2, livingMassMarkerMapTable[self.vb.massSpawns], 1, nil, 12, "SetIconOnLivingMass")
		end
	elseif spellId == 1228206 then
		warnExcessMass:CombinedShow(1.5, args.destName)
		if args:IsPlayer() then
			specWarnExcessMass:Show()
			specWarnExcessMass:Play("runout")
		end
	elseif spellId == 1230168 then
		if args:IsPlayer() then
			warnMortalFragility:Show()
		else
			specWarnMortalFragility:Show(args.destName)
			specWarnMortalFragility:Play("tauntboss")
		end
	elseif spellId == 1243699 then
		warnSpatialFragment:CombinedShow(1, args.destName)
	elseif spellId == 1243577 then
		if self:AntiSpam(8, 2) then
			self.vb.reverseGravityCount = self.vb.reverseGravityCount + 1
			local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.reverseGravityCount+1)
			if timer then
				timerReverseGravityCD:Start(timer, self.vb.reverseGravityCount)
			end
		end
		if args:IsPlayer() then
			specWarnReverseGravity:Show(self.vb.reverseGravityCount)
			specWarnReverseGravity:Play("scatter")
			yellReverseGravity:Yell()
			yellReverseGravityFades:Countdown(spellId)
		end
	elseif spellId == 1243609 then
		if args:IsPlayer() then
			specWarnAirborn:Show()
			specWarnAirborn:Play("targetyou")--Record goofy audio later?
		end
	elseif spellId == 1235114 then
		if args:IsPlayer() then
			warnSoaringReshii:Show()
		end
	elseif spellId == 1246930 then
		if args:IsPlayer() then
			warnStellarCore:Show()
		end
	elseif spellId == 1234243 and args:IsPlayer() then
		specWarnCrushingGravity:Show()
		specWarnCrushingGravity:Play("scatter")
	elseif spellId == 1234244 and args:IsPlayer() then
		specWarnInverseGravity:Show()
		specWarnInverseGravity:Play("scatter")
	elseif spellId == 1246145 then
		local amount = args.amount or 1
		if amount >= 4 and amount % 2 == 0 then
			warnTouchofOblivion:Show(args.destName, args.amount)
		end
	elseif spellId == 1245292 then
		warnDestabalized:Show(args.destName)
		if self:GetStage(3, 1) then
			warnPhase:Show(DBM_CORE_L.AUTO_ANNOUNCE_TEXTS.stage:format(3))
			warnPhase:Play("pthree")
			self:SetStage(3)
			self.vb.devourCount = 0
			self.vb.distortionCount = 0
			timerExtinctionCD:Stop()
			timerGammaBurstCD:Stop()
			timerGravitationalDistortionCD:Stop()

			timerExtinguishTheStarsCD:Start(16.5)
			timerDevourP3CD:Start(allTimers[savedDifficulty][3][1233539][1], 1)
			timerDarkenedSkyCD:Start(allTimers[savedDifficulty][3][1234044][1], 1)
			timerCosmicCollapseCD:Start(allTimers[savedDifficulty][3][1234263][1], 1)
			if not self:IsMythic() then
				timerVoidgraspCD:Start(allTimers[savedDifficulty][3][1250055][1], 1)
				timerSuperNovaCD:Start(allTimers[savedDifficulty][3][1232973][1], 1)
			else
				timerGravitationalDistortionCD:Start(allTimers[savedDifficulty][3][1234242][1], 1)
			end
		end
	elseif spellId == 1232394 and args:IsPlayer() then
		if devourCasting then
			warnGravityWell:Show()
		else
			specWarnGTFO:Show(gravityWellName)
			specWarnGTFO:Play("watchfeet")
		end
	elseif spellId == 1234266 and not args:IsPlayer() then
		specWarnCosmicFragility:Show(args.destName)
		specWarnCosmicFragility:Play("tauntboss")
	elseif spellId == 1250055 then
		if self:AntiSpam(8, 3) then
			self.vb.voidgraspCount = self.vb.voidgraspCount + 1
			specWarnVoidgrasp:Show(self.vb.voidgraspCount)
			specWarnVoidgrasp:Play("runout")
			local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.voidgraspCount+1)
			if timer then
				timerVoidgraspCD:Start(timer, self.vb.voidgraspCount+1)
			end
		end
		if args:IsPlayer() then
			specWarnVoidgrasp:Show(self.vb.voidgraspCount)
			specWarnVoidgrasp:Play("runout")
		end
	elseif spellId == 1249425 then
		warnMassDestruction:CombinedShow(1, args.destName)
		if args:IsPlayer() then
			specWarnMassDestruction:Show(self.vb.massEjectionCount)
			specWarnMassDestruction:Play("lineyou")
			yellMassDestruction:Yell()
			yellMassDestructionFades:Countdown(spellId)
		end
	elseif spellId == 1237102 then--Worldsoul Consumption
		self.vb.extinctionCount = 0
		self.vb.gammaBurstCount = 0
		self.vb.distortionCount = 0
		self.vb.massEjectionCount = 0
		self.vb.conquerorsCrossCount = 0
		self.vb.stardustCount = 0
		self:SetStage(2)
		warnPhase:Show(DBM_CORE_L.AUTO_ANNOUNCE_TEXTS.stage:format(2))
		warnPhase:Play("ptwo")
	end
end
mod.SPELL_AURA_APPLIED_DOSE = mod.SPELL_AURA_APPLIED

function mod:SPELL_AURA_REMOVED(args)
	local spellId = args.spellId
	if spellId == 1229038 then
		devourCasting = false
		warnDevourP1Over:Show()
		self:Unschedule(extraWarnDevour)
	elseif spellId == 1243577 then
		if args:IsPlayer() then
			yellReverseGravityFades:Cancel()
		end
	elseif spellId == 1243609 and args:IsPlayer() then
		warnAirbornRemoved:Show()
	elseif spellId == 1234243 and args:IsPlayer() then
		warnCrushingGravityFaded:Show()
	elseif spellId == 1234244 and args:IsPlayer() then
		warnInverseGravityFaded:Show()
	elseif spellId == 1233539 then
		warnDevourP3Over:Show()
	elseif spellId == 1249425 then
		if args:IsPlayer() then
			yellMassDestructionFades:Cancel()
		end
	end
end

function mod:SPELL_PERIODIC_DAMAGE(_, _, _, _, destGUID, _, _, _, spellId, spellName)
	if (spellId == 1237696 or spellId == 1231002) and destGUID == UnitGUID("player") and self:AntiSpam(2, 4) then
		specWarnGTFO:Show(spellName)
		specWarnGTFO:Play("watchfeet")
	end
end
mod.SPELL_PERIODIC_MISSED = mod.SPELL_PERIODIC_DAMAGE

function mod:UNIT_DIED(args)
	local cid = self:GetCIDFromGUID(args.destGUID)
	if cid == 242587 then--Living Mass
		timerInfinitePossibilities:Stop(args.destGUID)
	elseif cid == 245255 then--Artoshion
		timerConquerorsCrossCD:Stop()
		timerGammaBurstCD:Stop()
		timerExtinctionCD:Stop()
		timerMassEjectionCD:Stop()
		timerMassDestructionCD:Stop()
		timerEclipseCD:Stop()
		timerGravitationalDistortionCD:Stop()
	elseif cid == 245222 then--Pargoth
		timerConquerorsCrossCD:Stop()
		timerGammaBurstCD:Stop()
		timerExtinctionCD:Stop()
		timerStardustNovaCD:Stop()
		timerStarshardNovaCD:Stop()
		timerEclipseCD:Stop()
		timerGravitationalDistortionCD:Stop()
	end
end

--First cast is not in combat log (rest are)
--First cast can also be missing emote too though so we also have to do backup scheduling
--Because even emote doesn't COMPLETELY work around blizzard bug.
function mod:CHAT_MSG_RAID_BOSS_EMOTE(msg)
	if msg:find("spell:1234052") then
		self.vb.darkenedSkyCount = self.vb.darkenedSkyCount + 1
		specWarnDarkenedSky:Show(self.vb.darkenedSkyCount)
		specWarnDarkenedSky:Play("watchstep")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, 1234044, self.vb.darkenedSkyCount+1)
		if timer then
			timerDarkenedSkyCD:Start(timer, self.vb.darkenedSkyCount+1)
			self:Unschedule(checkForSkippedRings)
			self:Schedule(timer+10, checkForSkippedRings, self)
		end
	end
end

--"<43.79 11:27:27> [UNIT_SPELLCAST_START] Dimensius(62.0%-24.0%){Target:??} -Shattered Space- 3.25s boss1:Cast-3-4241-2810-1727-1243690-00681C5A7F:1243690",
function mod:UNIT_SPELLCAST_START(_, _, spellId)
	if spellId == 1243690 then
		self.vb.shatteredSpaceCount = self.vb.shatteredSpaceCount + 1
		specWarnShatteredSpace:Show(self.vb.shatteredSpaceCount)
		specWarnShatteredSpace:Play("aesoon")
		specWarnShatteredSpace:ScheduleVoice(4, "helpsoak")
		local timer = self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.shatteredSpaceCount+1)
		if timer then
			timerShatteredSpaceCD:Start(timer, self.vb.shatteredSpaceCount+1)
		end
	elseif spellId == 1237319 then
		self.vb.gammaBurstCount = self.vb.gammaBurstCount + 1
		specWarnGammaBurst:Show(self.vb.gammaBurstCount)
		specWarnGammaBurst:Play("pushbackincoming")
		timerGammaBurstCD:Start(self:IsMythic() and 31.5 or 35, self.vb.gammaBurstCount+1)
	end
end

function mod:UNIT_SPELLCAST_SUCCEEDED(_, _, spellId)
	if spellId == 1248483 and self:AntiSpam(5, 5) then
		self.vb.distortionCount = self.vb.distortionCount + 1
		warnGravitationalDistortion:Show(self.vb.distortionCount)
		local timer = self:GetStage(2) and 31.5 or self:GetFromTimersTable(allTimers, savedDifficulty, self.vb.phase, spellId, self.vb.distortionCount+1)
		if timer then
			timerGravitationalDistortionCD:Start(timer, self.vb.distortionCount+1)
		end
	end
end

function mod:UNIT_POWER_UPDATE(uId)
	local guid = UnitGUID(uId)
	local cid = self:GetCIDFromGUID(guid)
	if cid == 245255 or cid == 245222 then
		local power = UnitPower(uId)
		if power == 1 then
			DBM:Debug("First Power")
			if cid == 245255 then--Artoshion
				if self:IsMythic() then
					--Adds basically come immediately on mythic
					--Could start a fake one sooner then update it at last second like BW does but I don't see point
					--Since it's really just an estimated "engage" timer
					timerConquerorsCrossCD:Start(2.1, 1)
					timerExtinctionCD:Start(12.7, 1)
					timerGammaBurstCD:Start(23.2, 1)
					timerMassDestructionCD:Start(5.3, 1)
					timerGravitationalDistortionCD:Start(14.9, 1)
				else
					timerConquerorsCrossCD:Start(6, 1)
					timerMassEjectionCD:Start(13.1, 1)
					timerExtinctionCD:Start(17.8, 1)
					timerGammaBurstCD:Start(31.9, 1)
				end
			elseif cid == 245222 then--Pargoth
				if self:IsMythic() then
					--Adds basically come immediately on mythic
					--Could start a fake one sooner then update it at last second like BW does but I don't see point
					--Since it's really just an estimated "engage" timer
					timerConquerorsCrossCD:Start(1, 1)
					timerExtinctionCD:Start(11.6, 1)
					timerGammaBurstCD:Start(22.1, 1)
					timerStarshardNovaCD:Start(4.2, 1)
					timerGravitationalDistortionCD:Start(13.8, 1)
				else
					timerConquerorsCrossCD:Start(6, 1)
					timerStardustNovaCD:Start(13, 1)
					timerExtinctionCD:Start(17.8, 1)
					timerGammaBurstCD:Start(31.9, 1)
				end
			end
			timerEclipseCD:Start(self:IsMythic() and 60 or 90)
		end
	end
end

function mod:INSTANCE_ENCOUNTER_ENGAGE_UNIT()
	for i = 1, 8 do
		local unitID = "boss"..i
		local unitGUID = UnitGUID(unitID)
		if unitGUID and UnitExists(unitID) and not activeBossGUIDS[unitGUID] then
			activeBossGUIDS[unitGUID] = true
			local cid = self:GetUnitCreatureId(unitID)
			if cid == 242587 then--Living Mass
				self.vb.massSpawns = self.vb.massSpawns + 1
				if self.Options.SetIconOnLivingMass then
					self:ScanForMobs(unitGUID, 2, livingMassMarkerMapTable[self.vb.massSpawns], 1, nil, 12, "SetIconOnLivingMass")
				end
			end
		end
	end
end
--]]
