﻿-- Pawn by Vger-Azjol-Nerub
-- www.vgermods.com
-- © 2006-2022 Travis Spomer.  This mod is released under the Creative Commons Attribution-NonCommercial-NoDerivs 3.0 license.
-- See Readme.htm for more information.

--
-- German resources
------------------------------------------------------------

local function PawnUseThisLocalization()
PawnLocal = 
{
	["AverageItemLevelIgnoringRarityTooltipLine"] = "Durchschnittliche Gegenstandsstufe",
	["BaseValueWord"] = "Basis",
	["CopyScaleEnterName"] = "Gib einen Namen für deine neue Wertung ein, eine Kopie von %s:",
	["DecimalSeparator"] = ",",
	["DeleteScaleConfirmation"] = "Willst du die Wertung %s wirklich löschen? Dieser Vorgang kann nicht rückgängig gemacht werden. Gib \"%s\" zur Bestätigung ein:",
	["DidntUnderstandMessage"] = "   (?) \"%s\" habe ich nicht verstanden.",
	["EnchantedStatsHeader"] = "(Aktueller Wert)",
	["EngineeringName"] = "Ingenieurskunst",
	["ExportAllScalesMessage"] = "Drücke Strg+C um deine Wertungs-Tags zu kopieren, erstelle eine Datei auf deinem PC um sie zur Sicherung zu speichern und drücke dann Strg+V um sie einzufügen.",
	["ExportScaleMessage"] = "Drücke Strg+C, um das folgende Wertungs-Tag für |cffffffff%s|r zu kopieren und drücke dann Strg+V, um es später einzufügen.",
	["FailedToGetItemLinkMessage"] = "Fehler beim Abrufen der Gegenstandsinformation aus dem Tooltip.  Dies kann an einem Mod-Konflikt liegen.",
	["FailedToGetUnenchantedItemMessage"] = "Fehler beim Abrufen der Basisgegenstandwerte.  Dies kann an einem Mod-Konflikt liegen.",
	["FoundStatMessage"] = "%d %s",
	["GemList2"] = "%s oder %s",
	["GemListMany"] = "(drücke den Pawn-Knopf für Details)",
	["GenericGemLink"] = "|Hitem:%d|h[Edelstein %d]|h",
	["GenericGemName"] = "(Edelstein %d)",
	["HiddenScalesHeader"] = "Andere Wertungen",
	["ImportScaleMessage"] = "Drücke Strg+V um eine Wertung von einer anderen Quelle einzufügen:",
	["ImportScaleTagErrorMessage"] = "Pawn versteht dieses Wertungs-Tag nicht.  Hast du das ganze Tag kopiert?  Versuche es erneut zu kopieren und einzufügen:",
	["ItemIDTooltipLine"] = "Gegenstand-ID",
	["ItemLevelTooltipLine"] = "Gegenstandsstufe",
	["LootUpgradeAdvisorHeader"] = "Klicke, um deine Gegenstände zu vergleichen.|n",
	["LootUpgradeAdvisorHeaderMany"] = "|TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t Dieser Gegenstand verbessert deine Wertung um %d.  Klicke, um deine Gegenstände zu vergleichen.",
	["MissocketWorthwhileMessage"] = "   -- Aber es ist besser nur %s Edelsteine zu verwenden:",
	["NeedNewerVgerCoreMessage"] = "Pawn benötigt eine neuere Version von VgerCore.  Bitte benutze die Version von VgerCore, die mit Pawn heruntergeladen wurde.",
	["NewScaleDuplicateName"] = "Eine Wertung mit diesem Namen existiert bereits. Gib einen gültigen Namen für diene Wertung ein:",
	["NewScaleEnterName"] = "Gib einen gültigen Namen für diene Wertung ein:",
	["NewScaleNoQuotes"] = "Eine Wertung darf keine Anführungszeichen (\") enthalten. Gib einen gültigen Namen für diene Wertung ein:",
	["NormalizationMessage"] = "   ---- Normalisiert durch Teilen durch %g",
	["NoScale"] = "(keine)",
	["NoScalesDescription"] = "Um zu beginnen erstelle oder importiere eine neue Wertung.",
	["NoStatDescription"] = "Wähle ein Attribut aus der Liste um ihm einen Wert zu geben.",
	["Or"] = "oder ",
	["RenameScaleEnterName"] = "Gib einen neuen Namen für %s ein:",
	["SocketBonusValueCalculationMessage"] = "--- Der Sockelbonus wäre wert: %g",
	["StatNameText"] = "1 |cffffffff%s|r ist wert:",
	["ThousandsSeparator"] = ".",
	["TooltipBestAnnotation"] = "%s  |cff8ec3e6(bester)|r",
	["TooltipBestAnnotationSimple"] = "%s (bester)",
	["TooltipBigUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00 Verbesserung%s|r",
	["TooltipDowngradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% Zurückstufung%s|r",
	["TooltipRelicUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%d Gegenstandsstufen%s|r",
	["TooltipSecondBestAnnotation"] = "%s |cff8ec3e6(zweitbester)|r",
	["TooltipSecondBestAnnotationSimple"] = "%s (zweitbester)",
	["TooltipUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% Verbesserung%s|r",
	["TooltipUpgradeFor1H"] = " für Einhand",
	["TooltipUpgradeFor2H"] = " für Zweihand",
	["TooltipUpgradeNeedsEnhancementsAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% Verbesserungspotenzial%s|r",
	["TooltipVersusLine"] = "%s|n  vs. |c%s%s|r",
	["TotalValueMessage"] = "   ---- Gesamt: %g",
	["UnenchantedStatsHeader"] = "(Unverzaubert)",
	["Unusable"] = "(unbenutzbar)",
	["UnusableStatMessage"] = "   -- %s ist unbenutzbar, keine Berechnung.",
	["Usage"] = [=[Pawn by Vger-Azjol-Nerub
www.vgermods.com
 
/pawn -- Pawn anzeigen oder verstecken
/pawn debug [ an | aus ] -- Debug Infos in der Konsole anzeigen
/pawn backup -- alle Bewertungsprofile sichern
 
Weitere Informationen zur Anpassung von Pawn findet ihr in der Hilfedatei (Readme.htm) die mit dieser Installation ausgeliefert wird.]=],
	["ValueCalculationMessage"] = "   %g %s x %g pro = %g",
	["VisibleScalesHeader"] = "%s's Wertungen",
	["Stats"] = {
		["AgilityInfo"] = "Beweglichkeit. Verstärkt Eure Angriffe und Fähigkeiten.",
		["ApInfo"] = "Angriffskraft. Erhöht den Schaden von physischen Angriffen. Beinhaltet keine Angriffskraft, die durch Stärke und Beweglichkeit gewonnen wird.",
		["ArcaneResistInfo"] = "Arkanwiderstand. Reduziert den Schaden durch arkane Angriffe.",
		["ArcaneSpellDamage"] = "Arkanzauberschaden",
		["ArcaneSpellDamageInfo"] = "Arkanzauberschaden. Erhöht den durch deine arkanen Zauber verursachten Schaden.",
		["ArmorInfo"] = "Rüstung.  Körperliche Schadensreduktion.",
		["ArmorPenetrationInfo"] = "Rüstungsdurchdringung. Bewirkt, dass ein Teil Ihres physischen Angriffsschadens Rüstung ignoriert.",
		["ArmorTypes"] = "Rüstungstypen",
		["AvoidanceInfo"] = "Vermeidung. Verringert den Schaden, den Ihr durch Flächenangriffe erleidet.",
		["BlockRatingInfo"] = "Block Chance. Erhöht die Chancen auf einen erfolgreichen Schildblock.",
		["BlockValueInfo"] = "Schildblockwert. Erhöht den Schaden, den ein Schild absorbiert, wenn er erfolgreich blockt.",
		["Cloth"] = "Stoff",
		["ClothInfo"] = "Punkte, die zugewiesen werden sollen, wenn der Gegenstand Stoff ist.",
		["CorruptionInfo"] = "Verderbtheit von N'Zoth. Ein negativer Wert für \"Verderbnis\" entfernt Punkte aus der Punktzahl eines Elements basierend auf der Verderbnisstufe.",
		["Crit"] = "Krit",
		["CritInfo"] = "Kritische Treffer.  Chance, dass Angriffe und Heilungen stärkere Wirkung haben.",
		["DefenseInfo"] = "Verteidigungsfähigkeit. Verringert die Wahrscheinlichkeit, dass du von Boss-Angriffen getroffen wirst.",
		["DodgeInfo"] = "Ausweichen. Erhöht die Wahrscheinlichkeit, dass du Angriffen vollständig ausweichst.",
		["DpsInfo"] = "Waffenschaden pro Sekunde.  (Wenn du den DPS-Wert für verschiedene Waffentypen unterschiedlich bewerten möchtest, scrolle runter zum Bereich \"Spezielle Waffenwertungen\"",
		["ExpertiseInfo"] = "Geschick. Macht die Chancen deines Feindes, auszuweichen und zu parieren,  zunichte.",
		["FeralApInfo"] = "Wilde Angriffskraft. Erhöht den Schaden von Druidenangriffen in wilder Form. Beinhaltet keine Angriffskraft, die durch Stärke und Beweglichkeit gewonnen wird.",
		["FireResistInfo"] = "Feuerwiderstand. Reduziert den Schaden durch feuerbasierte Angriffe.",
		["FireSpellDamage"] = "Feuerzauberschaden",
		["FireSpellDamageInfo"] = "Feuerzauberschaden. Erhöht den durch deine Feuerzauber verursachten Schaden.",
		["FrostResistInfo"] = "Frostwiderstand. Reduziert den Schaden durch frostbasierte Angriffe.",
		["FrostSpellDamage"] = "Frostzauberschaden",
		["FrostSpellDamageInfo"] = "Frostzauberschaden. Erhöht den durch deine Frostzauber verursachten Schaden.",
		["HasteInfo"] = "Tempo.  Erhöht Angriffs- und Zaubertempo.",
		["Healing"] = "Zauberheilung",
		["HealingInfo"] = "Zauberheilung. Erhöht die Kraft deiner Heilzauber.",
		["HitInfo"] = "Trefferwert. Erhöht die Wahrscheinlichkeit, dass deine physischen Angriffe das Ziel treffen, insbesondere Bosse.",
		["HolySpellDamage"] = "Heiligzauberschaden",
		["HolySpellDamageInfo"] = "Heiligzauberschaden. Erhöht den durch deine heiligen Zauber verursachten Schaden.",
		["Hp5Info"] = "Gesundheitsregeneration alle 5 Sekunden. Erhöht die Geschwindigkeit, mit der du deine Gesundheit regenerierst.",
		["IndestructibleInfo"] = "Unzerstörbar.  Verhindert, dass Ihre Ausrüstung dauerhaften Schaden nimmt.",
		["IndestructibleIs"] = "Sein |cffffffffunzerstörbar|r lohnt sich:",
		["IntellectInfo"] = "Intelligenz. Verstärkt eure Zauber",
		["Leather"] = "Leder",
		["LeatherInfo"] = "Punkte, die zugewiesen werden sollen, wenn der Gegenstand Leder ist.",
		["LeechInfo"] = "Lebensraub. Heilt Euch um einen Teil des Schadens oder der Heilung, die Ihr verursacht.",
		["Mail"] = "Kette",
		["MailInfo"] = "Punkte, die zugewiesen werden sollen, wenn der Gegenstand Kette ist.",
		["MasteryInfo"] = "Meisterschaft. Verbessert den einzigartigen Bonus Eurer Klassenspezialisierung.",
		["MetaSocketEffectInfo"] = "Meta-Edelstein-Spezialeffekte. Punkte, die für den nicht-statistischen Teil eines Meta-Edelsteins zugewiesen werden (z. B. \"Geringfügige Erhöhung der Laufgeschwindigkeit\" oder \"1% Zauberreflexion\").",
		["MinorStats"] = "Kleinere Werte",
		["MovementSpeedInfo"] = "Bewegungsgeschwindigkeit. Bewirkt, dass euer Charakter schneller läuft.",
		["Mp5"] = "Mana alle 5",
		["Mp5Info"] = "Manaregeneration pro 5 Sekunden. Beeinflusst deine Manaregeneration auch im Kampf.",
		["NatureResistInfo"] = "Naturwiderstand. Reduziert den Schaden durch naturbasierte Angriffe.",
		["NatureSpellDamage"] = "Naturzauberschaden",
		["NatureSpellDamageInfo"] = "Naturzauberschaden. Erhöht den durch deine Naturzauber verursachten Schaden.",
		["ParryInfo"] = "Parieren. Erhöht die Wahrscheinlichkeit, dass du feindliche Angriffe abwehrst.",
		["Plate"] = "Platte",
		["PlateInfo"] = "Punkte, die zugewiesen werden sollen, wenn der Gegenstand Platte ist.",
		["RapInfo"] = "Distanzangriffskraft. Erhöht den Schaden von physischen Distanzangriffen. Beinhaltet keine Angriffskraft, die durch Beweglichkeit gewonnen wird.",
		["ResilienceInfo"] = "Elastizität. Verringert die Wahrscheinlichkeit, dass du kritisch getroffen wirst, und verringert den Schaden kritischer Treffer, die du erleidest.",
		["ShadowResistInfo"] = "Schattenwiderstand. Reduziert den Schaden durch schattenbasierte Angriffe.",
		["ShadowSpellDamage"] = "Schattenzauberschaden",
		["ShadowSpellDamageInfo"] = "Schattenzauberschaden. Erhöht den durch deine Schattenzauber verursachten Schaden.",
		["Shield"] = "Schild",
		["ShieldInfo"] = "Punkte, die zugewiesen werden sollen, wenn der Gegenstand ein Schild ist.",
		["Sockets"] = "Sockel",
		["SpecialWeaponStats"] = "Spezielle Waffenwertungen",
		["SpeedBaseline"] = "Tempogrundwert",
		["SpeedBaselineInfo"] = "Keine tatsächliche Wertung, die auf den Waffen erscheint. Dieser Wert wird von der Schnelligkeit abgezogen, bevor er mit der Wertung multipliziert wird.",
		["SpeedBaselineIs"] = "|cffffffffTempogrundwert|r is:",
		["SpeedInfo"] = "Waffenschaden pro Sekunde.  (Wenn du schnelle Waffen bevorzugst, dann sollte diese Nummer negativ sein. Siehe auch \"Tempogrundwert\" im Bereich \"Spezielle Waffenwertungen\".)",
		["SpeedIs"] = "1 Sekunde |cffffffffWaffentempo|r entspricht:",
		["SpellCritInfo"] = "Kritische Zaubertreffer. Erhöht die Wahrscheinlichkeit, dass deine Zauber mit erhöhter Potenz getroffen werden.",
		["SpellDamage"] = "Zauberschaden",
		["SpellDamageInfo"] = "Zauberschaden. Erhöht den durch deine Angriffszauber verursachten Schaden.",
		["SpellHitInfo"] = "Zaubertreffer. Erhöht die Wahrscheinlichkeit, dass deine Schadenszauber das Ziel treffen, insbesondere Bosse.",
		["SpellPenetrationInfo"] = "Zauberdurchdringung. Macht die Widerstände eines Feindes gegen deine Zauber zunichte.",
		["SpellPowerInfo"] = "Zaubermacht. Erhöht sowohl Schaden als auch Heilung durch Zauber.",
		["SpiritInfo"] = "Willenskraft. Beeinflusst die Manaregeneration außerhalb des Kampfes.",
		["StaminaInfo"] = "Ausdauer. Erhöht die Gesundheit.",
		["StrengthInfo"] = "Stärke. Verstärkt Eure Angriffe und Fähigkeiten.",
		["VersatilityInfo"] = "Vielseitigkeit. Erhöht verursachten Schaden und Heilung und verringert erlittenen Schaden.",
		["WeaponMainHandDps"] = "Waffenhand: DPS",
		["WeaponMainHandDpsInfo"] = "Waffenschaden pro Sekunde, nur für Waffenhandwaffen.",
		["WeaponMainHandMaxDamage"] = "Waffenhand: max. Schaden",
		["WeaponMainHandMaxDamageInfo"] = "Maximaler Waffenschaden, nur für Waffenhandwaffen.",
		["WeaponMainHandMinDamage"] = "Waffenhand: min. Schaden",
		["WeaponMainHandMinDamageInfo"] = "Minimaler Waffenschaden, nur für Waffenhandwaffen.",
		["WeaponMainHandSpeed"] = "Waffenhand: DPS",
		["WeaponMainHandSpeedInfo"] = "Waffenschaden pro Sekunde, nur für Waffenhandwaffen.",
		["WeaponMaxDamage"] = "Max. Schaden",
		["WeaponMaxDamageInfo"] = "Maximaler Waffenschaden",
		["WeaponMeleeDps"] = "Nahkampf: DPS",
		["WeaponMeleeDpsInfo"] = "Waffenschaden pro Sekunde, nur für Nahkampfwaffen.",
		["WeaponMeleeMaxDamage"] = "Nahkampf: max. Schaden",
		["WeaponMeleeMaxDamageInfo"] = "Maximaler Waffenschaden, nur für Nahkampfwaffen.",
		["WeaponMeleeMinDamage"] = "Nahkampf: min. Schaden",
		["WeaponMeleeMinDamageInfo"] = "Minimaler Waffenschaden, nur für Nahkampfwaffen.",
		["WeaponMeleeSpeed"] = "Nahkampf: Tempo",
		["WeaponMeleeSpeedInfo"] = "Waffentempo, nur für Nahkampfwaffen.",
		["WeaponMinDamage"] = "Min. Schaden",
		["WeaponMinDamageInfo"] = "Minmaler Waffenschaden.",
		["WeaponOffHandDps"] = "Nebenhand: DPS",
		["WeaponOffHandDpsInfo"] = "Waffenschaden pro Sekunde, nur für Nebenhandwaffen.",
		["WeaponOffHandMaxDamage"] = "Nebenhand: max. Schaden",
		["WeaponOffHandMaxDamageInfo"] = "Maximaler Waffenschaden, nur für Nebenhandwaffen.",
		["WeaponOffHandMinDamage"] = "Nebenhand: min. Schaden",
		["WeaponOffHandMinDamageInfo"] = "Minimaler Waffenschaden, nur für Nebenhandwaffen.",
		["WeaponOffHandSpeed"] = "Nebenhand: Tempo",
		["WeaponOffHandSpeedInfo"] = "Waffentempo, nur für Nebenhandwaffen.",
		["WeaponOneHandDps"] = "Einhand: DPS",
		["WeaponOneHandDpsInfo"] = "Waffenschaden pro Sekunde, nur für Einhandwaffen (keine Waffenhand- und Nebenhandwaffen).",
		["WeaponOneHandMaxDamage"] = "Einhand: max. Schaden",
		["WeaponOneHandMaxDamageInfo"] = "Maximaler Waffenschaden, nur für Einhandwaffen (keine Waffenhand- und Nebenhandwaffen).",
		["WeaponOneHandMinDamage"] = "Einhand: min. Schaden",
		["WeaponOneHandMinDamageInfo"] = "Minimaler Waffenschaden, nur für Einhandwaffen (keine Waffenhand- und Nebenhandwaffen).",
		["WeaponOneHandSpeed"] = "Einhand: Tempo",
		["WeaponOneHandSpeedInfo"] = "Waffentempo, nur für Einhandwaffen (keine Waffenhand- und Nebenhandwaffen).",
		["WeaponRangedDps"] = "Fernkampf: DPS",
		["WeaponRangedDpsInfo"] = "Waffenschaden pro Sekunde, nur für Fernkampfwaffen.",
		["WeaponRangedMaxDamage"] = "Fernkampf: max. Schaden",
		["WeaponRangedMaxDamageInfo"] = "Maximaler Waffenschaden, nur für Fernkampfwaffen.",
		["WeaponRangedMinDamage"] = "Fernkampf: min. Schaden",
		["WeaponRangedMinDamageInfo"] = "Minimaler Waffenschaden, nur für Fernkampfwaffen.",
		["WeaponRangedSpeed"] = "Fernkampf: Tempo",
		["WeaponRangedSpeedInfo"] = "Waffentempo, nur für Fernkampfwaffen.",
		["WeaponStats"] = "Waffenwertungen",
		["WeaponTwoHandDps"] = "Zweihand: DPS",
		["WeaponTwoHandDpsInfo"] = "Waffenschaden pro Sekunde, nur für Zweihandwaffen.",
		["WeaponTwoHandMaxDamage"] = "Zweihand: max. Schaden",
		["WeaponTwoHandMaxDamageInfo"] = "Maximaler Waffenschaden, nur für Zweihandwaffen.",
		["WeaponTwoHandMinDamage"] = "Zweihand: min. Schaden",
		["WeaponTwoHandMinDamageInfo"] = "Minimaler Waffenschaden, nur für Zweihandwaffen.",
		["WeaponTwoHandSpeed"] = "Zweihand: Tempo",
		["WeaponTwoHandSpeedInfo"] = "Waffentempo, nur für Zweihandwaffen.",
		["WeaponType1HAxe"] = "Einhandaxt",
		["WeaponType1HAxeInfo"] = "Für eine einhändige Axt zugeteilte Punkte.",
		["WeaponType1HMace"] = "Einhandstreitkolben",
		["WeaponType1HMaceInfo"] = "Für einen einhändigen Streitkolben zugeteilte Punkte.",
		["WeaponType1HSword"] = "Einhandschwert",
		["WeaponType1HSwordInfo"] = "Für ein einhändiges Schwert zugeteilte Punkte.",
		["WeaponType2HAxe"] = "Zweihandaxt",
		["WeaponType2HAxeInfo"] = "Für eine zweihändige Axt zugeteilte Punkte.",
		["WeaponType2HMace"] = "Zweihandstreitkolben",
		["WeaponType2HMaceInfo"] = "Für einen zweihändigen Streitkolben zugeteilte Punkte.",
		["WeaponType2HSword"] = "Zweihandschwert",
		["WeaponType2HSwordInfo"] = "Für ein zweihändiges Schwert zugeteilte Punkte.",
		["WeaponTypeBow"] = "Bogen",
		["WeaponTypeBowInfo"] = "Für einen Bogen zugeteilte Punkte.",
		["WeaponTypeCrossbow"] = "Armbrust",
		["WeaponTypeCrossbowInfo"] = "Für eine Armbrust zugeteilte Punkte.",
		["WeaponTypeDagger"] = "Dolch",
		["WeaponTypeDaggerInfo"] = "Für einen Dolch zugeteilte Punkte.",
		["WeaponTypeFistWeapon"] = "Faustwaffe",
		["WeaponTypeFistWeaponInfo"] = "Für eine Faustwaffe zugeteilte Punkte.",
		["WeaponTypeFrill"] = "Schildhand Zauber",
		["WeaponTypeFrillInfo"] = "Für Zaubergegenstände in der Schildhand zugeteilte Punkte.  Zählt nicht bei Schilden oder Waffen.",
		["WeaponTypeGun"] = "Schusswaffe",
		["WeaponTypeGunInfo"] = "Für eine Schusswaffe zugeteilte Punkte.",
		["WeaponTypeOffHand"] = "Schildhand Waffe",
		["WeaponTypeOffHandInfo"] = "Für eine reine Schildhandwaffe zugeteilte Punkte.  Zählt nicht bei Verzauberungen, Schilden oder Waffen, die in beiden Händen verwendet werden können oder Zaubergegenständen für die Schildhand.",
		["WeaponTypePolearm"] = "Stangenwaffe",
		["WeaponTypePolearmInfo"] = "Für eine Stangenwaffe zugeteilte Punkte.",
		["WeaponTypes"] = "Waffentypen",
		["WeaponTypeStaff"] = "Stab",
		["WeaponTypeStaffInfo"] = "Für einen Stab zugeteilte Punkte.",
		["WeaponTypeThrown"] = "Wurfwaffe",
		["WeaponTypeThrownInfo"] = "Für einen Wurfwaffe zugeteilte Punkte.",
		["WeaponTypeWand"] = "Zauberstab",
		["WeaponTypeWandInfo"] = "Für einen Zauberstab zugeteilte Punkte.",
		["WeaponTypeWarglaive"] = "Kriegsgleve",
		["WeaponTypeWarglaiveInfo"] = "Punkte, die vergeben werden, wenn der Gegenstand eine Kriegsgleve ist.",
	},
	["TooltipParsing"] = {
		["Agility"] = "^%+?# Beweglichkeit$",
		["AllStats"] = "^%+?# [Aa]lle [Ww]erte$",
		["Ap"] = "^%+?# Angriffskraft$",
		["Ap2"] = "^Anlegen: %+# Angriffskraft%.$",
		["Ap3"] = "^Anlegen: Erhöht die Angriffskraft um #%.$",
		["ArcaneResist"] = "^%+?# Arkanwiderstand$",
		["ArcaneSpellDamage"] = "^%+# Arkanzauberschaden$",
		["ArcaneSpellDamage2"] = "^Anlegen: Erhöht durch Arkanzauber und Arkaneffekte zugefügten Schaden um bis zu #%.$",
		["ArcaneSpellDamage3"] = "^%+# Arkanschaden$",
		["Armor"] = "^%+?# Rüstung$",
		["Armor2"] = "^UNUSED$",
		["ArmorPenetration"] = "^Anlegen: Eure Angriffe ignorieren # Rüstung Eures Gegners%.$",
		["ArmorPenetrationRating"] = "^Anlegen: Erhöht die Rüstungsdurchschlagwertung um #%.$",
		["ArmorPenetrationShort"] = "^%+?# Rüstungsdurchschlagwertung$",
		["Avoidance"] = "^%+# Vermeidung$",
		["Axe"] = "^Axt$",
		["BagSlots"] = "^%d+ Platz .+$",
		["Block"] = "^%+?# Blocken$",
		["BlockPercent"] = "^Anlegen: Erhöht Eure Chance, Angriffe mit einem Schild zu blocken, um #%%%.$",
		["BlockRating"] = "^Anlegen: Erhöht Eure Blockwertung um #%.$",
		["BlockRating2"] = "^UNUSED$",
		["BlockValue"] = "^Anlegen: Erhöht den Blockwert Eures Schildes um #%.$",
		["Bow"] = "^Bogen$",
		["ChanceOnHit"] = "Trefferchance:",
		["Charges"] = "^.+ Ladungen?$",
		["Cloth"] = "^Stoff$",
		["CooldownRemaining"] = "^Verbleibende Abklingzeit:",
		["Corruption"] = "^%+?# Verderbnis$",
		["Crit"] = "^%+?# [Kk]ritischer Trefferwert%.?$",
		["Crit2"] = "^UNUSED$",
		["CritPercent"] = "^Anlegen: Erhöht Eure Chance, einen kritischen Treffer zu erzielen, um #%%%.$",
		["CritRating"] = "^Anlegen: Erhöht Eure kritische Trefferwertung um #%.$",
		["CritRating2"] = "^Anlegen: Erhöht die kritische Trefferwertung um #%.$",
		["CritRating3"] = "^UNUSED$",
		["CritRatingShort"] = "^%+?# Kritische Trefferwertung$",
		["Crossbow"] = "^Armbrust$",
		["Dagger"] = "^Dolch$",
		["DefenseRating"] = "^Anlegen: Erhöht Verteidigungswertung um #%.$",
		["DefenseRating2"] = "^Anlegen: Erhöht die Verteidigungswertung um #%.$",
		["DefenseRatingSimple"] = "^%+?# Verteidigungswertung$",
		["DefenseSkill"] = "^Anlegen: Verteidigung %+#%.$",
		["DefenseSkillSimple"] = "^%+?# Verteidigung$",
		["DisenchantingRequires"] = "^Entzaubern benötigt",
		["Dodge"] = "^%+?#%%? Ausweichen$",
		["Dodge2"] = "^UNUSED$",
		["Dodge3"] = "^UNUSED$",
		["DodgePercent"] = "^Anlegen: Erhöht Eure Chance, einem Angriff auszuweichen, um #%%%.$",
		["DodgeRating"] = "^Anlegen: Erhöht Eure Ausweichwertung um #%.$",
		["DodgeRating2"] = "^UNUSED$",
		["DodgeRatingShort"] = "^%+?#%%? Ausweichwertung$",
		["Dps"] = "^%(# Schaden pro Sekunde%)$",
		["DpsAdd"] = "^Erhöht # Schaden pro Sekunde$",
		["Duration"] = "^Dauer:",
		["Elite"] = "^Elite$",
		["EnchantmentArmorKit"] = "^Verstärkt %(%+# Rüstung%)$",
		["EnchantmentCounterweight"] = "^Gegengewicht %(%+# Tempowertung%)",
		["EnchantmentFieryWeapon"] = "^Feurige Waffe$",
		["EnchantmentHealth"] = "^%+# HP$",
		["EnchantmentHealth2"] = "^%+# Gesundheit$",
		["EnchantmentLivingSteelWeaponChain"] = "^Waffenkette aus lebendigem Stahl$",
		["EnchantmentPyriumWeaponChain"] = "^Pyriumwaffenkette$",
		["EnchantmentTitaniumWeaponChain"] = "^Titanwaffenkette$",
		["Equip"] = "Anlegen:",
		["ExpertiseRating"] = "^Anlegen: Erhöht Eure Waffenkundewertung um #%.$",
		["ExpertiseRatingShort"] = "^%+?# Waffenkundewertung$",
		["FeralAp"] = "^Anlegen: %+# Angriffskraft in Katzengestalt, Bärengestalt oder Terrorbärengestalt%.$",
		["FeralApMoonkin"] = "^Anlegen: Erhöht die Angriffskraft in Katzengestalt, Bärengestalt, Terrorbärengestalt oder Mondkingestalt um #%.$",
		["FeralApWrath"] = "^Erhöht die Angriffskraft in Katzengestalt, Bärengestalt, Terrorbärengestalt oder Mondkingestalt um #%.$",
		["FireResist"] = "^%+?# Feuerwiderstand$",
		["FireSpellDamage"] = "^%+# Feuerzauberschaden$",
		["FireSpellDamage2"] = "^Anlegen: Erhöht durch Feuerzauber und Feuereffekte zugefügten Schaden um bis zu #%.$",
		["FireSpellDamage3"] = "^%+# Feuerschaden$",
		["FistWeapon"] = "^Faustwaffe$",
		["Flexible"] = "^Flexibel$",
		["FrostResist"] = "^%+?# Frostwiderstand$",
		["FrostSpellDamage"] = "^%+# Frostzauberschaden$",
		["FrostSpellDamage2"] = "^Anlegen: Erhöht durch Frostzauber und Frosteffekte zugefügten Schaden um bis zu #%.$",
		["FrostSpellDamage3"] = "^%+# Frostschaden$",
		["Gun"] = "^Schusswaffe$",
		["Haste"] = "^%+?# Tempo$",
		["Haste2"] = "^UNUSED$",
		["HasteRating"] = "^Anlegen: Erhöht die Tempowertung um #%.$",
		["HasteRating2"] = "^UNUSED$",
		["HasteRatingShort"] = "^%+?# Tempowertung$",
		["HaventCollectedAppearance"] = "^Ihr habt diese Vorlage noch nicht gesammelt$",
		["Healing"] = "^%+# Heilzauber$",
		["Healing2"] = "^Anlegen: Erhöht durch Zauber und Effekte verursachte Heilung um bis zu #%.$",
		["Healing3"] = "^%+# Heilung$",
		["HeirloomLevelRange"] = "^Benötigt Stufe %d bis #",
		["HeirloomXpBoost"] = "^Anlegen: Erhaltene Erfahrung",
		["HeirloomXpBoost2"] = "^UNUSED$",
		["Heroic"] = "^Heroisch$",
		["HeroicElite"] = "^Heroisch, Elite$",
		["HeroicThunderforged"] = "^Heroisch, Donnergeschmiedet$",
		["HeroicWarforged"] = "^Heroisch, Kriegsgeschmiedet$",
		["Hit"] = "^Anlegen: Verbessert Eure Trefferchance um #%%%.$",
		["Hit2"] = "^UNUSED$",
		["HitRating"] = "^Anlegen: Erhöht die Trefferwertung um #%.$",
		["HitRating2"] = "^Anlegen: Erhöht Eure Trefferwertung um #%.$",
		["HitRating3"] = "^UNUSED$",
		["HitRatingShort"] = "^%+?# Trefferwertung$",
		["HolySpellDamage"] = "^%+# Heiligzauberschaden$",
		["HolySpellDamage2"] = "^Anlegen: Erhöht durch Heiligzauber und Heiligeffekte zugefügten Schaden um bis zu #%.$",
		["HolySpellDamage3"] = "^UNUSED$",
		["Hp5"] = "^Anlegen: Stellt # Gesundheit alle 5 Sek%. wieder her%.?$",
		["Hp52"] = "^Anlegen: Stellt alle 5 Sek%. # Gesundheit wieder her%.?$",
		["Hp53"] = "^%+?# Gesundheit alle 5 [sS]ek%.?$",
		["Hp54"] = "^%+?# Gesundheit pro 5 [sS]ek%.?$",
		["Hp55"] = "^Alle 5 Sek%. # Gesundheit$",
		["Intellect"] = "^%+?# Intelligenz$",
		["Leather"] = "^Leder$",
		["Leech"] = "^%+# Lebensraub$",
		["Mace"] = "^Streitkolben$",
		["Mail"] = "^Kette$",
		["Mastery"] = "^%+?# Meisterschaft$",
		["Mastery2"] = "^UNUSED$",
		["MetaGemRequirements"] = "|cff%x%x%x%x%x%xBenötigt",
		["MovementSpeed"] = "^%+# Bewegungsgeschwindigkeit$",
		["Mp5"] = "^Anlegen: Stellt alle 5 Sek%. # Mana wieder her%.$",
		["Mp52"] = "^%+?# Mana alle 5 Sek%.$",
		["Mp53"] = "^Alle 5 Sek%. # Mana$",
		["Mp54"] = "^Anlegen: Stellt alle 5 Sek%. # Punkt%(e%) Mana wieder her%.$",
		["Mp55"] = "^UNUSED$",
		["MultiStatHeading"] = "^Mehrere Werte$",
		["MultiStatSeparator1"] = "und",
		["Multistrike"] = "^%+# Mehrfachschlag$",
		["NatureResist"] = "^%+?# Naturwiderstand$",
		["NatureSpellDamage"] = "^%+# Naturzauberschaden$",
		["NatureSpellDamage2"] = "^Anlegen: Erhöht durch Naturzauber und Natureffekte zugefügten Schaden um bis zu #%.$",
		["NatureSpellDamage3"] = "^%+# Naturschaden$",
		["NormalizationEnchant"] = "^Verzaubert: (.*)$",
		["Parry"] = "^%+?# Parieren$",
		["Parry2"] = "^UNUSED$",
		["ParryPercent"] = "^Anlegen: Erhöht Eure Chance, einen Angriff zu parieren, um #%%%.$",
		["ParryRating"] = "^Anlegen: Erhöht Eure Parierwertung um #%.$",
		["ParryRatingShort"] = "^%+?# Parierwertung$",
		["Plate"] = "^Platte$",
		["Polearm"] = "^Stangenwaffe$",
		["PvPPower"] = "^%+?# P[vV]P[- ]Macht$",
		["RaidFinder"] = "^Schlachtzugsbrowser$",
		["Rap"] = "^Anlegen: %+# Distanzangriffskraft%.$",
		["Rap2"] = "^Anlegen: Erhöht die Distanzangriffskraft um #%.$",
		["Requires2"] = "^Benötigt",
		["Resilience"] = "^%+?# P[vV]P[- ]Abhärtung$",
		["Resilience2"] = "^UNUSED$",
		["ResilienceRating"] = "^Anlegen: Erhöht Eure Abhärtungswertung um #%.$",
		["ResilienceRatingShort"] = "^%+?# Abhärtungswertung$",
		["Scope"] = "^Zielfernrohr %(%+# Schaden%)$",
		["ScopeCrit"] = "^Zielfernrohr %(%+# kritischer Trefferwert%)$",
		["ScopeRangedCrit"] = "^%+?# kritische Ferntrefferwertung$",
		["ShadowResist"] = "^%+?# Schattenwiderstand$",
		["ShadowSpellDamage"] = "^%+# Schattenzauberschaden$",
		["ShadowSpellDamage2"] = "^Anlegen: Erhöht durch Schattenzauber und Schatteneffekte zugefügten Schaden um bis zu #%.$",
		["ShadowSpellDamage3"] = "^UNUSED$",
		["ShadowSpellDamage4"] = "^%+# Schattenschaden$",
		["Shield"] = "^Schild$",
		["SocketBonusPrefix"] = "Sockelbonus:",
		["Speed"] = "^Geschwindigkeit #$",
		["Speed2"] = "^UNUSED$",
		["SpellCrit"] = "^Anlegen: Erhöht Eure Chance, einen kritischen Treffer durch Zauber zu erzielen, um #%%%.$",
		["SpellCritRating"] = "^Anlegen: Erhöht d?i?e?E?u?r?e? kritische Zaubertrefferwertung um #%.$",
		["SpellCritRating2"] = "^UNUSED$",
		["SpellCritRatingShort"] = "^%+?# Kritische Zaubertrefferwertung$",
		["SpellCritRatingShort2"] = "^UNUSED$",
		["SpellDamage"] = "^%+# Schadenszauber und Heilzauber$",
		["SpellDamage2"] = "^Anlegen: Erhöht durch Zauber und magische Effekte zugefügten Schaden und Heilung um bis zu #%.$",
		["SpellDamage3"] = "^Anlegen: Erhöht durch Zauber und magische Effekte verursachten Schaden und Heilung um bis zu #%.$",
		["SpellDamage4"] = "^UNUSED$",
		["SpellDamage5"] = "^%+?# Zauberschaden und Heilung$",
		["SpellDamage6"] = "^UNUSED$",
		["SpellDamageAndHealing"] = "^Anlegen: Erhöht durch sämtliche Zauber und magische Effekte verursachte Heilung um bis zu # und den verursachten Schaden um bis zu #%.$",
		["SpellDamageAndHealing2"] = "^UNUSED$",
		["SpellDamageAndHealingEnchant"] = "^%+# Heilung %+# Zauberschaden$",
		["SpellDamageAndHealingShort"] = "^%+# Heilzauber und %+# Schadenszauber$",
		["SpellDamageAndHealingShort2"] = "^UNUSED$",
		["SpellHasteRating"] = "^Anlegen: Erhöht d?i?e?E?u?r?e? Zaubertempowertung um #%.$",
		["SpellHasteRatingShort"] = "^%+?# Zaubertempowertung$",
		["SpellHit"] = "^Anlegen: Erhöht Eure Chance mit Zaubern zu treffen um #%%%.$",
		["SpellHitRating"] = "^Anlegen: Erhöht Eure Zaubertrefferwertung um #%.$",
		["SpellHitRating2"] = "^Anlegen: Erhöht die Zaubertrefferwertung um #%.$",
		["SpellHitRatingShort"] = "^%+?# Zaubertrefferwertung$",
		["SpellPenetration"] = "^Anlegen: Erhöht d?i?e?E?u?r?e? Zauberdurchschlagskraft um #%.$",
		["SpellPenetrationClassic"] = "^Anlegen: Reduziert die Magiewiderstände der Ziele Eurer Zauber um #%.$",
		["SpellPenetrationShort"] = "^%+?# Zauberdurchschlagskraft$",
		["SpellPower"] = "^%+?# Zaubermacht$",
		["SpellPower2"] = "^Anlegen: Erhöht die Zaubermacht um #%.$",
		["SpellPower3"] = "^UNUSED$",
		["Spirit"] = "^%+?# Willenskraft$",
		["Staff"] = "^Stab$",
		["Stamina"] = "^%+?# Ausdauer$",
		["Strength"] = "^%+?# Stärke$",
		["Sword"] = "^Schwert$",
		["TemporaryBuffMinutes"] = "^.+%(%d+ Min%)$",
		["TemporaryBuffSeconds"] = "^.+%(%d+ Sek%)$",
		["Thrown"] = "^Geworfen$",
		["Thunderforged"] = "^Donnergeschmiedet$",
		["Timeless"] = "^Zeitlos$",
		["Titanforged"] = "^Titanengeschmiedet$",
		["UpgradeLevel"] = "^Verbesserungsstufe:",
		["Use"] = "Benutzen:",
		["Versatility"] = "^%+# Vielseitigkeit$",
		["Wand"] = "^Zauberstab$",
		["Warforged"] = "^Kriegsgeschmiedet$",
		["Warglaives"] = "^Kriegsgleven$",
		["WeaponDamage"] = "^# %- # Schaden$",
		["WeaponDamageArcane"] = "^# %- # Arkanschaden$",
		["WeaponDamageArcaneExact"] = "^# Arkanschaden$",
		["WeaponDamageEnchantment"] = "^%+?# Waffenschaden$",
		["WeaponDamageEquip"] = "^Anlegen: %+?# Waffenschaden%.$",
		["WeaponDamageExact"] = "^# Schaden$",
		["WeaponDamageFire"] = "^# %- # Feuerschaden$",
		["WeaponDamageFireExact"] = "^# Feuerschaden$",
		["WeaponDamageFrost"] = "^# %- # Frostschaden$",
		["WeaponDamageFrostExact"] = "^# Frostschaden$",
		["WeaponDamageHoly"] = "^# %- # Heiligschaden$",
		["WeaponDamageHolyExact"] = "^# Heiligschaden$",
		["WeaponDamageNature"] = "^# %- # Naturschaden$",
		["WeaponDamageNatureExact"] = "^# Naturschaden$",
		["WeaponDamageShadow"] = "^# %- # Schattenschaden$",
		["WeaponDamageShadowExact"] = "^# Schattenschaden$",
	},
	["UI"] = {
		["AboutHeader"] = "Über Pawn",
		["AboutMrRobot"] = "Standardwerte werden zur Verfügung gestellt durch den großzügigen Mr. Robot. Sie sind ein guter Ausgangspunkt für Charaktere mit typischen Talenten und Artefaktpunkteverteilungen in typischen Kämpfen. Du kannst genauere, benutzerdefinierte Wertegewichtungen erhalten, indem du den Simulator von Ask Mr. Robot auf askmrrobot.com verwendest.",
		["AboutReadme"] = "Neu bei Pawn? Eine grundlegende Einführung findest du auf dem \"Los geht's\" Reiter.",
		["AboutTab"] = "Über",
		["AboutTranslation"] = "Deutsche Übersetzung von SunnySunflow, Sandmahn",
		["AboutVersion"] = "Version %s",
		["AboutWebsite"] = "Für andere Addons von Vger, besuche vgermods.com.",
		["AskMrRobotProvider"] = "Ask Mr. Robot Wertungen",
		["CompareClearItems"] = "Zurücksetzen",
		["CompareClearItemsTooltip"] = "Setzt beide Gegenstandsfelder zurück.",
		["CompareColoredSockets"] = "Farbiger Sockel",
		["CompareEquipped"] = "Angelegt",
		["CompareGemTotalValue"] = "Wertung der Edelsteine",
		["CompareHeader"] = "Vergleiche Gegenstände (Profil %s)",
		["CompareOtherHeader"] = "Anderes",
		["CompareSlotEmpty"] = "(kein Gegenstand)",
		["CompareSocketBonus"] = "Sockelbonus",
		["CompareSocketsHeader"] = "Sockel",
		["CompareSpecialEffects"] = "Weitere Wertungen",
		["CompareSwap"] = "< Tauschen >",
		["CompareSwapTooltip"] = "Tauscht die Position der beiden zu vergleichenden Gegenstände.",
		["CompareTab"] = "Vergleichen",
		["CompareVersus"] = "—vs.—",
		["CompareWelcomeRight"] = [=[Lass dann einen Gegenstand in diese Box fallen.

Du kannst ihn mit existierenden Gegenständen vergleichen, wenn du die Icons in der unteren linken Ecke benutzt.]=],
		["CompareYourBest"] = "Bester im Fach",
		["GemsColorHeader"] = "%s Edelsteine",
		["GemsHeader"] = "Edelsteine für %s",
		["GemsNoneFound"] = "Keine passende Edelsteine gefunden.",
		["GemsQualityLevel"] = "Edelsteinqualität",
		["GemsQualityLevelTooltip"] = [=[Gegenstandsstufe für die Edelsteine vorgeschlagen werden sollen.

Wenn z.B. "463" angegeben, dann wird Pawn Edelsteine für die Gegenstandsstufe 463 angezeigt: Mists of Pandaria Heroische Dungeons Loot.]=],
		["GemsShowBest"] = "Zeige die besten verfügbaren Edelsteine an",
		["GemsShowBestTooltip"] = "Zeigt die definitiv besten Edelsteine die verfügbar sind für das aktuell gewählte Profil. Einige der Edelsteine werden zu mächtig sein, um sie in alten oder niedrigstufigen Gegenständen zu sockeln.",
		["GemsShowForItemLevel"] = "Empfohlenen Edelsteine für Gegenstandsstufe:",
		["GemsShowForItemLevelTooltip"] = "Zeige die von Pawn empfohlenen Edelsteine für das aktuell gewählte Profil und eine bestimmte Gegenstandsstufe.",
		["GemsTab"] = "Edelsteine",
		["GemsWelcome"] = "Wähle ein Profil auf der linken Seite um die Edelsteine zu sehen, die Pawn empfiehlt.",
		["HelpHeader"] = "Willkommen bei Pawn!",
		["HelpTab"] = "Los geht's",
		["HelpText"] = [=[Pawn hilft dir, deine beste Ausrüstung zu finden und Verbesserungen zu identifizieren, die dir begegnen.


Wenn du Quest-Belohnungen oder Dungeon-Beute erwirbst, die besser als deine aktuelle Ausrüstung sein könnten, wird Pawn es dich mit einem grünen Pfeilsymbol wissen lassen.

 |cff8ec3e6Fire:|r |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% Verbesserung|r 


|cff8ec3e6Probiere diese Funktionen aus, sobald du dich an die Grundlagen gewöhnt hast:|r

• Vergleiche die Werte von zwei Gegenstände mit Hilfe des Pawn "Vergleichen" Reiter.
• Wechsle auf den Reiter "Bewertungsprofil" in den manuellen Modus, um Vorschläge für mehr als eine Spezialisierung gleichzeitig anzuzeigen.
• Verwende den Ask Mr. Robot-Simulator und erstelle eine brauchbare Wertung für deinen Charakter, um individuelle Vorschläge zu erhalten.]=],
		["InterfaceOptionsBody"] = "Klicke die Pawn-Schaltfläche, um dorthin zu gelangen.  Du kannst Pawn auch von deiner Charakterübersicht aus öffnen oder ein Tastenkürzel daran binden.",
		["InterfaceOptionsWelcome"] = "Optionen für Pawn findest du in der Pawn-Benutzeroberfläche.",
		["InventoryButtonTooltip"] = "Klicke, um Pawn zu öffnen.",
		["InventoryButtonTotalsHeader"] = "Gesamtwert aller angelegten Gegenstände:",
		["KeyBindingCompareItemLeft"] = "Gegenstand vergleichen (links)",
		["KeyBindingCompareItemRight"] = "Gegenstand vergleichen (rechts)",
		["KeyBindingShowUI"] = "Pawn-Benutzeroberfläche zeigen/verstecken",
		["OptionsAdvisorHeader"] = "Ratgeber Optionen",
		["OptionsAlignRight"] = "Wertungen im Tooltip rechts ausrichten",
		["OptionsAlignRightTooltip"] = "Aktiviere diese Option, um Pawn-Wertungen und Verbesserungsinformationen an der rechten anstatt der linken Seite des Tooltips auszurichten.",
		["OptionsBagUpgradeAdvisor"] = "Zeige Ratgeber für Verbesserungen in den Taschen",
		["OptionsBagUpgradeAdvisorTooltip"] = [=[Aktiviere diese Option, wenn Pawn die Verbesserungs-Pfeile in den Taschen übernehmen soll. 

Wenn aktiviert, findet Pawn Verbesserungen in deinen Taschen und markiert die Gegenstände, die eine Verbesserung für deine aktive Waage sind, mit grünen Pfeilen.

Wenn deaktiviert, markiert WoW Gegenstände mit einem höheren Gegenstandswert als dem, was du gerade trägst und Pawn wird die eingebaute Funktion nicht stören.]=],
		["OptionsBlankLine"] = "Fügt vor den Werten eine leere Zeile ein",
		["OptionsBlankLineTooltip"] = "Halte die Tooltips für Gegenstände besonders ordentlich, indem du diese Option aktivierst, bei der vor den Pawn-Werten eine Leerzeile eingefügt wird.",
		["OptionsButtonHidden"] = "Verstecke ihn",
		["OptionsButtonHiddenTooltip"] = "Zeigt den Pawn-Knopf nicht im Charakterinfofenster an.",
		["OptionsButtonPosition"] = "Zeige den Pawn-Knopf:",
		["OptionsButtonPositionLeft"] = "Auf der linken Seite",
		["OptionsButtonPositionLeftTooltip"] = "Zeigt den Pawn-Knopf in der unteren linken Ecke des Charakterinfofenster.",
		["OptionsButtonPositionRight"] = "Auf der rechten Seite",
		["OptionsButtonPositionRightTooltip"] = "Zeigt den Pawn-Knopf in der unteren rechten Ecke des Charakterinfofenster.",
		["OptionsColorBorder"] = "Tooltip-Rand bei Verbesserungen einfärben",
		["OptionsColorBorderTooltip"] = "Aktiviere diese Option, um den Tooltip-Rand in Grün anzuzeigen, wenn der Gegenstand eine Verbesserung darstellt. Deaktiviere diese Option, wenn Probleme mit anderen Addons auftreten sollten. ",
		["OptionsCurrentValue"] = "Zeige sowohl aktuelle als auch Basiswerte",
		["OptionsCurrentValueTooltip"] = [=[Aktiviere diese Option, wenn Pawn zwei Werte für Gegenstände zeigen soll: der aktuelle Wert, der den aktuellen Zustand mit den tatsächlichen Edelsteinen und Verzauberungen des Gegenstandes im Moment widerspiegelt, mit leeren Sockeln, die keinen Nutzen bringen, und dem Grundwert, Das ist, was Pawn normalerweise anzeigt. Diese Option hat keine Auswirkungen, es sei denn, du aktivierst die Objektwertanzeige in QuickInfos.

Du solltest immer noch den Basiswert verwenden, um zwischen zwei Gegenständen im Endeffekt zu unterscheiden, aber der aktuelle Wert kann beim Leveln hilfreich sein und es leichter machen zu entscheiden, ob es sich lohnt, einen neuen Gegenstand sofort zu besetzen, bevor er Edelsteine oder Verzauberungen hat.]=],
		["OptionsDebug"] = "Zeige Debug-Info",
		["OptionsDebugTooltip"] = [=[Wenn du nicht sicher bist, wie Pawn seine Werte ermittelt aktiviere diese Option, damit Pawn alle Arten von nützlichen Informationen in der Konsole ausgibt sobald du mit der Maus über einem Gegenstand bist. Diese Information enthält die Werte, die der Gegenstand hat, die Wertungen, die Pawn nicht versteht und wie alles bewertet wird.

Diese Option wird dein Chatlog überfluten, schalte sie nur zum Debuggen ein und dann wieder aus.

Shortcuts:
/pawn debug on
/pawn debug off]=],
		["OptionsHeader"] = "Passe die Pawn-Optionen an",
		["OptionsIgnoreGemsWhileLevelingCheck"] = "Ignoriert Sockel auf niedrigstufigen Gegenstände",
		["OptionsIgnoreGemsWhileLevelingCheckTooltip"] = [=[Aktiviere diese Option, damit Pawn bei der Berechnung von Sockeln auf Niedrigstufigen Gegenständen ignoriert, da die meisten Leute nicht den Aufwand oder die Kosten für Edelsteine während des Levelns nutzen. Ein "Niedrigstufiger" Gegenstand ist schwächer als der, der von einem heroischen Dungeon auf dem Höchstlevel erreicht werden kann.

Wenn diese Option aktiviert ist, schlägt Pawn immer noch passende Edelsteine für Gegenstände niedriger Stufe vor. Sockel werden bei der Berechnung ignoriert und gesockelte Gegenstände werden nicht so häufig als Verbesserung angezeigt.

Wenn diese Option deaktiviert ist, berechnet Pawn die Werte für Gegenstände so, als ob sie gesockelt wären, die den Wert des Gegenstandes maximiert, unabhängig von der Stufe des Gegenstandes.]=],
		["OptionsIgnoreItemUpgradesCheck"] = "Ignoriere Tapferkeit und Machtvolle Verbesserungen",
		["OptionsIgnoreItemUpgradesCheckTooltip"] = [=[Aktiviere diese Option, wenn Pawn bei der Berechnung von Gegenstandswerten das Potenzial für Tapferkeits Verbesserungen und Machtvolle Gegenstände ignorieren soll.

Wenn diese Option aktiviert ist, wird Pawn nachrüstbare Gegenstände so behandeln, wie sie sind und nicht davon ausgehen, dass Tapferkeits- und Apexis-Fragmenten verwendet werden um den Gegenstand zu verbessern. Falls festgestellt wird, ob ein Gegenstand besser ist als das, was du gerade hast.

Wenn diese Option nicht aktiviert ist, wird Pawn diese Gegenstände behandeln als ob ihr maximales Potential mit Tapferkeits- und Apexis-Fragmenten aufgewertet wurde. Dies könnte dazu führen, dass ein machtvoller Gegenstand der Stufe 650 eine signifikante Verbesserung gegenüber einem Gegenstand der Stufe 670 aus der Schwarzfels-Gießerei erscheint, da der machtvolle Gegenstand möglicherweise durch Tapferkeit und Apexis auf Stufe 705 verbessert werden könnte.]=],
		["OptionsInventoryIcon"] = "Zeige Symbole neben Tooltips",
		["OptionsInventoryIconTooltip"] = "Aktiviere diese Option, um Inventarsymbole neben dem Gegenstandsfenster anzuzeigen.",
		["OptionsItemIDs"] = "Gegenstands-IDs anzeigen",
		["OptionsItemIDsTooltip"] = [=[Aktiviere diese Option, damit Pawn die Gegenstands-ID jedes Gegenstands, auf den du stößt, sowie die IDs aller Verzauberungen und Edelsteine anzeigt.

Jedem Gegenstand in World of Warcraft ist eine ID-Nummer zugeordnet. Diese Informationen sind im Allgemeinen nur für Mod-Autoren nützlich.]=],
		["OptionsLootAdvisor"] = "Zeige Ratgeber für Verbesserungen beim Plündern",
		["OptionsLootAdvisorTooltip"] = "Wenn Beute in einen Dungeon fällt und es sich um eine Verbesserung für deinen Charakter handelt, zeigt Pawn ein Popup an, das an dem Beute-Fenster angebracht ist und dich über die Verbesserung informiert.",
		["OptionsOtherHeader"] = "Weitere Optionen",
		["OptionsQuestUpgradeAdvisor"] = "Zeige Ratgeber für Verbesserungen bei Quests",
		["OptionsQuestUpgradeAdvisorTooltip"] = [=[Wenn in deinem Questlog oder beim Dialog mit NPCs, eine der Belohnungen eine Verbesserung für deinen Charakter ist, wird Pawn einen grünen Pfeil für diesen Gegenstand anzeigen. Wenn keiner dieser Gegenstände eine Verbesserung ist, zeigt Pawn einen Stapel Münzen auf dem Gegenstand, der am meisten wert ist, wenn er an einen Verkäufer verkauft wird.
]=],
		["OptionsResetUpgrades"] = "Ausrüstung erneut scannen",
		["OptionsResetUpgradesTooltip"] = "Pawn wird vergessen, was es über die besten Gegenstände weiß, die du jemals ausgerüstet hast und deine Ausrüstung erneut scannen, um in Zukunft aktuellere Verbesserungsinformationen bereitzustellen. Verwende diese Funktion, wenn du feststellst, dass Pawn aufgrund von Gegenständen, die du verkauft, zerstört oder auf andere Weise nicht mehr verwendet hast, schlechte Verbesserungsvorschläge macht. Dies wirkt sich auf alle Charaktere aus, die Pawn verwenden.",
		["OptionsShowItemLevelUpgrades"] = "Zeige Verbesserungen auf Gegenstandsstufen",
		["OptionsShowItemLevelUpgradesTooltip"] = "Pawn zeigt dir Gegenstände, die eine höhere Gegenstandsstufe haben als das, was du zuvor in diesem Platz ausgerüstet hast, zusätzlich zu normalen Verbesserungen.",
		["OptionsShowRelicUpgrades"] = "Zeige Verbesserungen für Relikte",
		["OptionsShowRelicUpgradesTooltip"] = "Pawn wird dir zeigen, wenn ein ein Relikt das Itemlevel einer deiner Artefaktwaffen erhöhen würde. (Dies funktioniert anders als die anderen Verbesserungsoptionen, da es auf dem Itemlevel und nicht den auf den Werten basiert.)",
		["OptionsSocketingAdvisor"] = "Zeige den Edelstein-Ratgeber",
		["OptionsSocketingAdvisorTooltip"] = "Wenn du einem Gegenstand Edelsteine zufügst, dann wird Pawn ein Popup anzeigen, dass dir geeignete Edelsteine zur Verbesserung vorschlägt.  (Um eine komplette Liste der Edelsteinvorschläge zu sehen, benutze den Edelsteine Tab um die Qualität anzupassen.)",
		["OptionsTab"] = "Optionen",
		["OptionsTooltipHeader"] = "Tooltip Optionen",
		["OptionsTooltipSpecIcon"] = "Zeige Symbole der Spezialisierungen",
		["OptionsTooltipSpecIconTooltip"] = "Aktiviere diese Option, um die Symbole der Spezialisierungen neben den Skalierungsnamen in Tooltips zu zeigen.",
		["OptionsTooltipUpgradesOnly"] = "Zeige nur Verbesserungen",
		["OptionsTooltipUpgradesOnlyTooltip"] = [=[Das ist die einfachste Option.  Zeige nur Pawn Werte und prozentuale Upgrades für Gegenstände die eine Verbesserung für dein aktuelles Set wären. Zeige keine Pawn Werte für geringerwertige Gegenstände.

|cff8ec3e6Feuer:|r  |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% Verbesserung|r

oder

|cff8ec3e6Feuer:  (Bester im Fach)|r]=],
		["OptionsTooltipValuesAndUpgrades"] = "Zeige Wertungen und Verbesserung %",
		["OptionsTooltipValuesAndUpgradesTooltip"] = [=[Zeigt Pawn Werte für alle sichtbaren Wertungen und alle Gegenstände, ausser denen mit Wert 0.  Zusätzlich alle Gegenstände anzeigen, die dein aktuelles Set verbessern würden.

|cff8ec3e6Frost:  123.4
Feuer:  156.7 |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% Verbesserung|r
]=],
		["OptionsTooltipValuesOnly"] = "Zeige nur Wertungen, keine Verbesserung %",
		["OptionsTooltipValuesOnlyTooltip"] = [=[Zeige Pawn Werte für alle sichtbaren Wertungen aller Gegenstände, ausser denen mit Wert 0. Zeige keine Gegenstände die dein aktuelles Set verbessern würden.  Diese Option simuliert das Verhalten der alten Version von Pawn.

|cff8ec3e6Frost:  123.4
Feuer:  156.7|r]=],
		["OptionsUpgradeHeader"] = "Zeige |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t Verbesserungen an Tooltips:",
		["OptionsUpgradeSettingsHeader"] = "Optionen für Verbesserungen",
		["OptionsUpgradesForBothWeaponTypes"] = "Zeige Verbesserungen für 1Hand und 2Hand",
		["OptionsUpgradesForBothWeaponTypesTooltip"] = "Pawn's Verbesserung-Ratgeber sollten Verbesserungen jeweils nur für die getragene Waffenart (Zweihand oder Einhand) anzeigen. Wenn diese Option aktiviert ist, kannst du eine Zweihandwaffe verwenden und immer noch deutlich schlechtere Einhandwaffen als Verbesserung sehen, wenn sie besser sind als die zuvor beste (oder zweitbeste) Einhandwaffe, die du hattest, da Pawn Verbesserungen getrennt verfolgt für die beiden Waffenarten. Wenn diese Option nicht aktiviert ist, wird beim Ausrüsten einer Zweihandwaffe verhindert , dass Pawn dir Verbesserungen für Einhandgegenstände anzeigt und umgekehrt.",
		["OptionsUpgradeTrackingHeader"] = "Verbesserungsvergleiche:",
		["OptionsUpgradeTrackingOff"] = "Gegen angelegte Rüstung (empfohlen)",
		["OptionsUpgradeTrackingOffTooltip"] = "Pawn wird dir Gegenstände zeigen, die im Vergleich zu den momentan angelegten Gegenständen eine Verbesserung sind.",
		["OptionsUpgradeTrackingOn"] = "Verfolge für jede Skalierung (fortgeschritten)",
		["OptionsUpgradeTrackingOnTooltip"] = "(Für fortgeschrittene Benutzer!)  Pawn wird versuchen, die besten Gegenstände, die du ausgerüstet hast, unabhängig für jede von dir aktivierte Wertung zu überprüfen und dir Gegenstände anzeigen, die im Vergleich zu diesen eine Verbesserung darstellen.",
		["OptionsWelcome"] = "Konfiguriere Pawn wie du es möchtest. Änderungen werden unmittelbar übernommen.",
		["ScaleAutoOff"] = "Manuell",
		["ScaleAutoOff2"] = "Ich verwalte die Wertungen",
		["ScaleAutoOffTooltip"] = "Mit Pawn kannst du manuell auswählen, welche Wertungen für die Berechnungen verwendet werden sollen. Auf diese Weise kannst du mehrere Wertungen gleichzeitig aktivieren, benutzerdefinierte Wertungen hinzufügen und vieles mehr.",
		["ScaleAutoOn"] = "Automatisch",
		["ScaleAutoOn2"] = "Zeigt nur die aktuelle Spezialisierung",
		["ScaleAutoOnTooltip"] = "Pawn wird automatisch deine aktuelle Spezialisierung auf Gegenstand-Tooltips anzeigen und verwendet diese, um Empfehlungen abzugeben und Verbesserungen vorzuschlagen.",
		["ScaleAutoWelcome"] = "Pawn wird Vorschläge für deine aktuelle Spezialisierung zeigen. Wenn Du die Dinge lieber selbst verwalten möchtest, klicke einfach unten auf Manuell.",
		["ScaleChangeColor"] = "Farbe ändern",
		["ScaleChangeColorTooltip"] = "Ändert die Schriftfarbe der Wertungsinformationen im Gegenstand-Tooltip.",
		["ScaleCopy"] = "Kopieren",
		["ScaleCopyTooltip"] = "Erstelle ein neues Bewertungsprofil , indem du eine Kopie davon erstellst.",
		["ScaleDefaults"] = "Vorlage",
		["ScaleDefaultsTooltip"] = "Erstelle ein neues Bewertungsprofil aus einer Vorlage für deine Spezialisierung.",
		["ScaleDeleteTooltip"] = "Aktuelles Bewertungsprofil löschen. Dieser Vorgang kann nicht rückgängig gemacht werden!",
		["ScaleEmpty"] = "Neues",
		["ScaleEmptyTooltip"] = "Erstelle ein neues Bewertungsprofil von Grund auf neu.",
		["ScaleExport"] = "Exportieren",
		["ScaleExportTooltip"] = "Teile deine Bewertungsprofile mit anderen im Internet.",
		["ScaleHeader"] = "Verwalte deine Bewertungsprofile",
		["ScaleImport"] = "Importieren",
		["ScaleImportTooltip"] = "Füge ein neues Bewertungsprofil durch Kopieren und Einfügen eines Wertungs-Tags aus dem Internet.",
		["ScaleNewHeader"] = "Erstelle ein neues Bewertungsprofil",
		["ScaleRename"] = "Umbenennen",
		["ScaleRenameTooltip"] = "Bewertungsprofil umbenennen.",
		["ScaleSelectorHeader"] = "Wähle ein Profil:",
		["ScaleSelectorNoneWarning"] = "Wählen Sie mindestens eine aus.",
		["ScaleSelectorShowingSuggestionsFor"] = "Zeige Vorschläge für",
		["ScaleSelectorShowScale"] = "Zeigt dieses Bewertungsprofil im Gegenstand-Tooltip an.",
		["ScaleSelectorShowScaleTooltip"] = [=[Aktiviere diese Option, um dieses Bewertungsprofil in den Gegenstand-Tooltips anzuzeigen und lass sie von Pawn verwenden, um Verbesserungen vorzuschlagen. Du kannst mehr als ein Bewertungsprofil für jeden Charakter aktivieren. 
Abkürzung: Umschalt+Klick auf ein Bewertungsprofil]=],
		["ScaleShareHeader"] = "Teile deine Bewertungsprofile mit anderen",
		["ScaleTab"] = "Bewertungsprofil",
		["ScaleTypeNormal"] = "Du kannst dieses Bewertungsprofil im Gewichtungs-Tab ändern.",
		["ScaleTypeReadOnly"] = "Wenn du dieses Bewertungsprofil anpassen möchtest, erstelle zuerst eine Kopie.",
		["ScaleWelcome"] = "Bewertungsprofile geben Punktwerte zu Wertungen, damit Pawn dir sagen kann, welcher von zwei Gegenständen für eine bestimmte Spezialisierung oder Situation besser ist.",
		["SocketingAdvisorButtonTooltip"] = "Klicken um Pawn's \"Edelsteine\" Reiter zu öffnen. Dort findest du weitere Informationen zu den von Pawn empfohlenen Edelsteinen.",
		["SocketingAdvisorHeader"] = "Pawn's Edelstein-Ratgeber empfiehlt:",
		["SocketingAdvisorIgnoreThisItem"] = "Füge diesem Gegenstand mit niedrigem Level keine Edelsteine hinzu. Aber wenn du das tust, verwende diese:",
		["StarterProvider"] = "Starter Wertungen",
		["ValuesDoNotShowUpgradesFor1H"] = "Verbesserungen für Einhand Gegenstände ausblenden",
		["ValuesDoNotShowUpgradesFor2H"] = "Verbesserungen für Zweihand Gegenstände ausblenden",
		["ValuesDoNotShowUpgradesTooltip"] = "Aktiviere diese Option, um Verbesserungen für diese Typen von Gegenstände auszublenden. Obwohl Tank-Paladine beispielsweise Zweihandwaffen verwenden können, sind diese niemals eine Verbesserung, so dass Pawn keine Verbesserung anzeigen sollte. Ebenso können Vergelter-Paladine Einhandwaffen verwenden, aber sie sind niemals eine Verbesserung.",
		["ValuesFollowSpecialization"] = "Zeige nur Verbesserungen für meinen besten Rüstungstyp erst nach Stufe %d",
		["ValuesFollowSpecializationTooltip"] = "Aktiviere diese Option, um Verbesserungen für Rüstungen auszublenden, auf die sich deine Klasse nach Stufe %d nicht spezialisiert hat. Auf Stufe %d lernen beispielsweise heilige Paladine die Plattenspezialisierung, die den Intellekt um 5%% erhöht, wenn du nur Plattenrüstung trägst. Wenn diese Option ausgewählt ist, berücksichtigt Pawn niemals Stoff, Leder oder Kette als Verbesserungen für heilige Paladine der Stufe %d+.",
		["ValuesHeader"] = "Werte Gewichtung für %s",
		["ValuesIgnoreItemType"] = "Diese Gegenstände sind unbrauchbar",
		["ValuesIgnoreStat"] = "Gegenstände mit diesem sind unbrauchbar",
		["ValuesIgnoreStatTooltip"] = "Aktiviere diese Option um zu verhindern das unbenutzbare Gegenstände eine Wertung erhalten.  Schamanen können zum Beispiel keine Plattenrüstung tragen. Einen Schamanen-Profil kann Plattenrüstung als unbenutzbar markieren, so dass Plattenrüstung keine Wertung für dieses Profil erhält.",
		["ValuesNormalize"] = "Werte normalisieren (wie Wowhead)",
		["ValuesNormalizeTooltip"] = [=[Aktiviere diese Option, um den endgültig berechneten Wert für einen Gegenstand durch die Summe aller Profilwerte in deiner Wertung zu teilen, wie dies bei Wowhead und Lootzor der Fall ist. Dies hilft, Situationen auszugleichen, in denen eine Wertung Profilwerte um 1 hat und eine andere Werte um 5 hat. Es hilft auch, Zahlen überschaubar klein zu halten.
Weitere Informationen zu dieser Einstellung findest du in der Readme-Datei.]=],
		["ValuesRemove"] = "Entfernen",
		["ValuesRemoveTooltip"] = "Entferne diese Wertung aus dem Bewertungsprofil.",
		["ValuesTab"] = "Gewichtung",
		["ValuesWelcome"] = "Du kannst die Gewichtung anpassen, die jedem Wert für dieses Bewertungsprofil zugewiesen sind. Um deine Bewertungsprofile zu verwalten und neue hinzuzufügen, verwende den manuellen Modus auf dem Bewertungsprofile-Tab.",
		["ValuesWelcomeNoScales"] = "Du hast kein Bewertungsprofil ausgewählt. Wechsel zunächst zum Bewertungsprofile-Tab und starte ein neues Bewertungsprofil oder füge eines aus dem Internet ein.",
		["ValuesWelcomeReadOnly"] = "Das ausgewählte Bewertungsprofil kann nicht geändert werden. Erstelle im Bewertungsprofile-Tab ein neues Profil oder erstelle eine Kopie des gewählten Profils.",
	}
}

-- Special case: weapon speed and Mail use different words on Classic.
-- So, patch things up here.
if VgerCore.IsClassic or VgerCore.IsBurningCrusade or VgerCore.IsWrath then
	PawnLocal.Mail = "Schwere Rüstung"
	PawnLocal.MailInfo = "Punkte, die zugewiesen werden sollen, wenn der Gegenstand Schwere Rüstung ist."
	PawnLocal.TooltipParsing.Mail = "^Schwere Rüstung$"
	PawnLocal.TooltipParsing.Speed = "^Tempo #$"
end

PawnLocal.Specs =
{
	[1] = {
		{ Name="Waffen", Icon=132355, Role="DAMAGER" },
		{ Name="Furor", Icon=132347, Role="DAMAGER" },
		{ Name="Schutz", Icon=132341, Role="TANK" },
	},
	[2] = {
		{ Name="Heilig", Icon=135920, Role="HEALER" },
		{ Name="Schutz", Icon=236264, Role="TANK" },
		{ Name="Vergeltung", Icon=135873, Role="DAMAGER" },
	},
	[3] = {
		{ Name="Tierherrschaft", Icon=461112, Role="DAMAGER" },
		{ Name="Treffsicherheit", Icon=236179, Role="DAMAGER" },
		{ Name="Überleben", Icon=461113, Role="DAMAGER" },
	},
	[4] = {
		{ Name="Meucheln", Icon=236270, Role="DAMAGER" },
		{ Name="Gesetzlosigkeit", Icon=236286, Role="DAMAGER" },
		{ Name="Täuschung", Icon=132320, Role="DAMAGER" },
	},
	[5] = {
		{ Name="Disziplin", Icon=135940, Role="HEALER" },
		{ Name="Heilig", Icon=237542, Role="HEALER" },
		{ Name="Schatten", Icon=136207, Role="DAMAGER" },
	},
	[6] = {
		{ Name="Blut", Icon=135770, Role="TANK" },
		{ Name="Frost", Icon=135773, Role="DAMAGER" },
		{ Name="Unheilig", Icon=135775, Role="DAMAGER" },
	},
	[7] = {
		{ Name="Elementar", Icon=136048, Role="DAMAGER" },
		{ Name="Verstärkung", Icon=237581, Role="DAMAGER" },
		{ Name="Wiederherstellung", Icon=136052, Role="HEALER" },
	},
	[8] = {
		{ Name="Arkan", Icon=135932, Role="DAMAGER" },
		{ Name="Feuer", Icon=135810, Role="DAMAGER" },
		{ Name="Frost", Icon=135846, Role="DAMAGER" },
	},
	[9] = {
		{ Name="Gebrechen", Icon=136145, Role="DAMAGER" },
		{ Name="Dämonologie", Icon=136172, Role="DAMAGER" },
		{ Name="Zerstörung", Icon=136186, Role="DAMAGER" },
	},
	[10] = {
		{ Name="Braumeister", Icon=608951, Role="TANK" },
		{ Name="Nebelwirker", Icon=608952, Role="HEALER" },
		{ Name="Windläufer", Icon=608953, Role="DAMAGER" },
	},
	[11] = {
		{ Name="Gleichgewicht", Icon=136096, Role="DAMAGER" },
		{ Name="Wildheit", Icon=132115, Role="DAMAGER" },
		{ Name="Wächter", Icon=132276, Role="TANK" },
		{ Name="Wiederherstellung", Icon=136041, Role="HEALER" },
	},
	[12] = {
		{ Name="Verwüstung", Icon=1247264, Role="DAMAGER" },
		{ Name="Rachsucht", Icon=1247265, Role="TANK" },
	},
}

end

if GetLocale() == "deDE" then
	PawnUseThisLocalization()
end

-- After using this localization or deciding that we don't need it, remove it from memory.
PawnUseThisLocalization = nil
