﻿-- Pawn by Vger-Azjol-Nerub
-- www.vgermods.com
-- © 2006-2024 Travis Spomer.  This mod is released under the Creative Commons Attribution-NonCommercial-NoDerivs 3.0 license.
-- See Readme.htm for more information.

--
-- French resources
------------------------------------------------------------

local function PawnUseThisLocalization()
PawnLocal =
{
	["AverageItemLevelIgnoringRarityTooltipLine"] = "Niveau moyen de l'objet",
	["BaseValueWord"] = "base",
	["CopyScaleEnterName"] = "Entrez un nom pour votre nouvelle échelle, une copie de %s:",
	["DecimalSeparator"] = ",",
	["DeleteScaleConfirmation"] = "Etes vous sure que vous voulez éffacer %s? Vous ne pourrez pas revenir en arriere. tapez \"%s\" pour confirmer:",
	["DidntUnderstandMessage"] = "   (?) ne comprend pas \"%s\".",
	["EnchantedStatsHeader"] = "(valeur actuelle)",
	["EngineeringName"] = "Ingénierie",
	["ExportAllScalesMessage"] = "Appuyez sur Ctrl+C pour copier vos balises de balance dans le presse papier, puis collez le contenu dans un fichier texte avec les touches Ctrl+V pour les sauvegarder.",
	["ExportScaleMessage"] = "Appuyez sur Ctrl+C pour copier la balise d'échelle sélectionnée dans le presse papier |cffffffffff%s|r, puis pressez les touches Ctrl+V pour la coller plus tard.",
	["FailedToGetItemLinkMessage"] = "   Echec à la reception du lien de l'objet de la part de l'infobulle. Ceci peut etre du a un conflit de mod.",
	["FailedToGetUnenchantedItemMessage"] = "   Echec à la reception des valeurs de base de l'objet. Ceci peut etre du a un conflit de mod.",
	["FoundStatMessage"] = "   %d %s",
	["GemList2"] = "%s ou %s",
	["GemListMany"] = "(clic le bouton Pawn pour avoir des détails)",
	["GenericGemLink"] = "|Hitem:%d|h[Gemme %d]|h",
	["GenericGemName"] = "(Gemme %d)",
	["HiddenScalesHeader"] = "Autre échelles",
	["ImportScaleMessage"] = "Appuyez sur Ctrl+V pour coller ici une balise d'échelle que vous avez copiée d'une autre source :",
	["ImportScaleTagErrorMessage"] = "Pawn ne comprend pas cette étiquette d'échelle. Avez-vous copié toute la balise en entier ? Essayez de faire un nouveau copier-coller :",
	["ItemIDTooltipLine"] = "Objet ID",
	["ItemLevelTooltipLine"] = "Niveau d'objet",
	["LootUpgradeAdvisorHeader"] = "Cliquez pour comparer avec vos objets.|n",
	["LootUpgradeAdvisorHeaderMany"] = "|TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t cet objet est une amélioration de %d . clic pour comparer avec vos objets",
	["MissocketWorthwhileMessage"] = "   -- Il est préférable de n'utiliser que des gemmes %s :",
	["NeedNewerVgerCoreMessage"] = "Pawn a besoin d une version plus récente de VgerCore. utilisez s'il vous plaît la version de VgerCore inclue dans Pawn.",
	["NewScaleDuplicateName"] = "Une échelle portant ce nom existe déjà. Entrez un nom pour votre échelle :",
	["NewScaleEnterName"] = "Entrer un nom pour votre échelle:",
	["NewScaleNoQuotes"] = "une échelle ne peut avoir \" dans son nom. Entrer un nouveau nom pour votre échelle:",
	["NormalizationMessage"] = "   ---- Normalisé en divisant par %g",
	["NoScale"] = "(aucun)",
	["NoScalesDescription"] = "Pour démarrer, importez une échelle existante ou commencez une nouvelle échelle.",
	["NoStatDescription"] = "Choisissez une statistique à partir de la liste à gauche.",
	["Or"] = "ou",
	["RenameScaleEnterName"] = "Entrer un nouveau nom pour %s:",
	["SocketBonusValueCalculationMessage"] = "   -- Le bonus de châsse vaudrait : %g",
	["StatNameText"] = "1 |cffffffff%s|r vaut:",
	["ThousandsSeparator"] = "",
	["TooltipBestAnnotation"] = "%s  |cff8ec3e6(le meilleur)|r",
	["TooltipBestAnnotationSimple"] = "%s  le meilleur",
	["TooltipBigUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00 upgrade%s|r",
	["TooltipDowngradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% déclassements%s|r",
	["TooltipRelicUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%d niveau d'objet%s|r",
	["TooltipSecondBestAnnotation"] = "%s  |cff8ec3e6(second meilleur)|r",
	["TooltipSecondBestAnnotationSimple"] = "%s second meilleur",
	["TooltipUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% amélioration%s|r",
	["TooltipUpgradeFor1H"] = "à une main",
	["TooltipUpgradeFor2H"] = "à deux mains",
	["TooltipUpgradeNeedsEnhancementsAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% potentiel de mise à niveau%s|r",
	["TooltipVersusLine"] = "%s|n  vs. |c%s%s|r",
	["TotalValueMessage"] = "   ---- Total: %g",
	["UnenchantedStatsHeader"] = "(valeur de base)",
	["Unusable"] = "(inutilisable)",
	["UnusableStatMessage"] = "   -- %s est inutilisable, donc l'arrêt.",
	["Usage"] = [=[
Pawn est crée par Vger-Azjol-Nerub
www.vgermods.com
 
/pawn -- affiche ou cache l'interface visuelle de Pawn
/pawn debug [ on | off ] -- affiche les messages de debug sur la console
/pawn backup -- sauvegarde toutes vos échelles dans vos formules
 
Pour plus d'information sur la Personnalisation de Pawn, regarder le fichier d'aide (Readme.htm) inclu dans le mod.]=],
	["ValueCalculationMessage"] = "   %g %s x %g chaque = %g",
	["VisibleScalesHeader"] = "Échelles de %s",
	["Stats"] = {
		["AgilityInfo"] = "L'agilité. Augmente la puissance des capacités de certaines classes.",
		["ApInfo"] = "Attack Power.  Increases the damage of physical attacks.  Does not include attack power gained from strength and agility.",
		["ArcaneResistInfo"] = "Arcane Resistance.  Reduces the damage taken from arcane-based attacks.",
		["ArcaneSpellDamage"] = "Arcane Damage",
		["ArcaneSpellDamageInfo"] = "Arcane damage.  Increases the damage dealt by your arcane spells.",
		["ArmorInfo"] = "Armure. Réduit les dégâts physiques reçus.",
		["ArmorPenetrationInfo"] = "Pénétration d'armure. Une partie de vos dégâts d'attaque physique ignore l'armure.",
		["ArmorTypes"] = "Types d'armure",
		["AvoidanceInfo"] = "Évitement. Réduit les dégâts subis par les attaques à effet de zone.",
		["BlockRatingInfo"] = "Block chance.  Increases the chances of a successful shield block.",
		["BlockValueInfo"] = "Shield block value.  Increases the damage that a shield absorbs when it successfully blocks.",
		["Cloth"] = "Tissu",
		["ClothInfo"] = "Points à attibuer si l'objet est en tissu",
		["CorruptionInfo"] = "Les objets touchés par l'influence de N'Zoth confèrent un grand pouvoir, mais ils exposent le porteur à des dangers croissants. Une valeur négative enlèvera des points au score d'un objet en fonction du niveau de corruption.",
		["Crit"] = "Coup critique",
		["CritInfo"] = "Coup critique. Augmente vos chances d'avoir une efficacité supplémentaire pour les attaques et les soins.",
		["DefenseInfo"] = "Defense skill.  Decreases the chance that you'll be hit by boss attacks.",
		["DodgeInfo"] = "Dodge.  Increases the chance that you'll dodge attacks entirely.",
		["DominationSocketInfo"] = "La valeur d'un socket pour un fragment de domination moyen.",
		["DpsInfo"] = "Valeur de dégats par secondes de l'arme. (si vous désirez différentes estimations pour différents types d'armes, référez-vous à la section \"statistiques spéciale arme\".)",
		--[[Translation missing --]]
		["ExpertiseInfo"] = "Expertise. Negates your enemy's chances to dodge and parry.",
		["FeralApInfo"] = "Feral Attack Power.  Increases the damage of druid attacks when in feral forms.  Does not include attack power gained from strength and agility.",
		["FireResistInfo"] = "Fire Resistance.  Reduces the damage taken from fire-based attacks.",
		["FireSpellDamage"] = "Fire Damage",
		["FireSpellDamageInfo"] = "Fire damage.  Increases the damage dealt by your fire spells.",
		["FrostResistInfo"] = "Frost Resistance.  Reduces the damage taken from frost-based attacks.",
		["FrostSpellDamage"] = "Frost Damage",
		["FrostSpellDamageInfo"] = "Frost damage.  Increases the damage dealt by your frost spells.",
		["HasteInfo"] = "Hâte. Augmente la vitesse d'attaque, la vitesse d'incantation des sorts et la regénération d'énergie.",
		["Healing"] = "Spell Healing",
		["HealingInfo"] = "Spell healing.  Increases the power of your healing spells.",
		["HitInfo"] = "Hit.  Increases the chance that your physical attacks hit the target, especially bosses.",
		["HolySpellDamage"] = "Holy Damage",
		["HolySpellDamageInfo"] = "Holy damage.  Increases the damage dealt by your holy spells.",
		["Hp5Info"] = "Health regeneration per 5 seconds.  Increases the rate at which you regenerate health.",
		["IndestructibleInfo"] = "Indestructible. Empêche votre équipement de subir des dommages au niveau de la durabilité.",
		["IndestructibleIs"] = "Être |cffffffff indestructible|r vaut la peine :",
		["IntellectInfo"] = "L'intelligence. Augmente la puissance des attaques et techniques de certaines classes.",
		["Leather"] = "Cuir",
		["LeatherInfo"] = "Points à attribuer si l'article est en cuir.",
		["LeechInfo"] = "La Ponction : Permet de regagner en points de vie un pourcentage des dégâts infligés, ou des soins prodigués.",
		["Mail"] = "Maille",
		["MailInfo"] = "Points à attribuer si l'objet est en maille",
		["MasteryInfo"] = "Maîtrise. Augmente les dégâts, les soins, les points de vies et les soins reçus en fonction des classes.",
		["MetaSocketEffectInfo"] = "Effets spéciaux de méta gemme. Points à attribuer pour la partie non statistique d'une méta gemme (par exemple, \"Augmentation mineure de la vitesse de course\" ou \"1% Spell Reflect\").",
		["MinorStats"] = "Statistiques secondaires",
		["MovementSpeedInfo"] = "Vitesse de déplacement. Fait que personnage se déplace plus rapidement.",
		["Mp5"] = "Mana per 5",
		["Mp5Info"] = "Mana regeneration per 5 seconds.  Affects your mana regeneration even when in combat.",
		["NatureResistInfo"] = "Nature Resistance.  Reduces the damage taken from nature-based attacks.",
		["NatureSpellDamage"] = "Nature Damage",
		["NatureSpellDamageInfo"] = "Nature damage.  Increases the damage dealt by your nature spells.",
		["ParryInfo"] = "Parry.  Increases the chance that you'll parry enemy attacks.",
		["Plate"] = "Plaque",
		["PlateInfo"] = "points a etre ajouté si l'item est en plaque",
		["RapInfo"] = "Ranged Attack Power.  Increases the damage of ranged physical attacks.  Does not include attack power gained from agility.",
		--[[Translation missing --]]
		["ResilienceInfo"] = "Resilience. Reduces the chance that you'll be critically hit, and decreases the damage of critical hits that you do take.",
		["ShadowResistInfo"] = "Shadow Resistance.  Reduces the damage taken from shadow-based attacks.",
		["ShadowSpellDamage"] = "Shadow Damage",
		["ShadowSpellDamageInfo"] = "Shadow damage.  Increases the damage dealt by your shadow spells.",
		["Shield"] = "Bouclier",
		["ShieldInfo"] = "Points à attribuer si l'objet est un bouclier.",
		["Sockets"] = "Châsse",
		["SpecialWeaponStats"] = "Statistiques des armes spéciales",
		["SpeedBaseline"] = "Vitesse de référence",
		["SpeedBaselineInfo"] = "Il ne s'agit pas d'une statistique réelle qui apparaît sur les armes, ce nombre est soustrait de la statistique de la vitesse avant d'être multiplié par la valeur de l'échelle.",
		["SpeedBaselineIs"] = "|cffffffffVitesse de référence|r est:",
		["SpeedInfo"] = "Vitesse d'attaque, en dégats par secondes. (Si vous préférez les armes rapides, ce chiffre doit être négatif. Voir aussi : base de vitesse dans la section Statistiques des armes spéciales).",
		["SpeedIs"] = "1 seconde |cffffffff de vitesse de rotation|r vaut :",
		["SpellCritInfo"] = "Spell critical strike.  Increases the chance that your spells will hit with increased potency.",
		["SpellDamage"] = "Spell Damage",
		["SpellDamageInfo"] = "Spell damage.  Increases the damage dealt by your offensive spells.",
		["SpellHitInfo"] = "Spell Hit.  Increases the chance that your damaging spells hit the target, especially bosses.",
		--[[Translation missing --]]
		["SpellPenetrationInfo"] = "Spell Penetration. Negates an enemy's resistances to your spells.",
		["SpellPowerInfo"] = "",
		["SpiritInfo"] = "Spirit.  Affects your out-of-combat mana regeneration.",
		["StaminaInfo"] = "L'endurance. Augmente votre santé et vos points de vies.",
		["StrengthInfo"] = "La force. Augmente la puissance d'attaque et les capacités de certaines classes.",
		["VersatilityInfo"] = "La polyvalence. Augmente les dégâts infligés, les soins prodigués, les soins reçus et réduit les dégâts infligés pour les spécialisations de tank.",
		["WeaponMainHandDps"] = "Dégâts par secondes main principale",
		["WeaponMainHandDpsInfo"] = "Dégâts d'arme par seconde, seulement pour les armes en main droite",
		["WeaponMainHandMaxDamage"] = "Dégâts maximum main principale",
		["WeaponMainHandMaxDamageInfo"] = "Dégâts d'arme maximal, seulement pour les armes en main droite",
		["WeaponMainHandMinDamage"] = "Dégâts minimum main principale",
		["WeaponMainHandMinDamageInfo"] = "Dégâts d'arme minimum, seulement pour les armes en main droite",
		["WeaponMainHandSpeed"] = "Vitess main principale",
		["WeaponMainHandSpeedInfo"] = "Vitesse d'arme, seulement pour les armes en main droite",
		["WeaponMaxDamage"] = "Dégâts maximum",
		["WeaponMaxDamageInfo"] = "Dégâts maximum de l'arme",
		["WeaponMeleeDps"] = "Mêlée dégâts par secondes : DPS",
		["WeaponMeleeDpsInfo"] = "Dégâts d'arme par seconde, seulement pour les armes de mélée.",
		["WeaponMeleeMaxDamage"] = "Dégâts de mélée maximum",
		["WeaponMeleeMaxDamageInfo"] = "Dégâts maximum d'arme, seulement pour les armes de mélée.",
		["WeaponMeleeMinDamage"] = "Dégâts de mélée minimum",
		["WeaponMeleeMinDamageInfo"] = "Dégâts minimum d'arme, seulement pour les armes de mélée.",
		["WeaponMeleeSpeed"] = "Vitesse de mélée",
		["WeaponMeleeSpeedInfo"] = "Vitesse d'arme, seulement pour les armes de mélée.",
		["WeaponMinDamage"] = "Dégâts minimum",
		["WeaponMinDamageInfo"] = "Dégâts minimum d'arme",
		["WeaponOffHandDps"] = "Dégâts par secondes en main gauche : DPS",
		["WeaponOffHandDpsInfo"] = "Dégâts d'arme par seconde, seulement pour une arme en main gauche",
		["WeaponOffHandMaxDamage"] = "Dégâts maximum en main gauche",
		["WeaponOffHandMaxDamageInfo"] = "Dégâts d'arme maximum, seulement pour une arme en main gauche",
		["WeaponOffHandMinDamage"] = "Dégâts minimum en main gauche",
		["WeaponOffHandMinDamageInfo"] = "Dégâts d'arme minimum, seulement pour une arme en main gauche",
		["WeaponOffHandSpeed"] = "Vitesse en main gauche",
		["WeaponOffHandSpeedInfo"] = "Vitesse d'arme, seulement pour une arme en main gauche",
		["WeaponOneHandDps"] = "Dégats par secondes arme à une main : DPS",
		["WeaponOneHandDpsInfo"] = "Dégâts d'arme par seconde, seulement pour arme marquées une main, n'incluant pas les armes de main droite ou gauche",
		["WeaponOneHandMaxDamage"] = "Dégâts maximum arme à une main",
		["WeaponOneHandMaxDamageInfo"] = "Dégâts d'arme maximum, seulement pour les armes marquées une main, n'incluant pas les armes de main droite ou gauche.",
		["WeaponOneHandMinDamage"] = "Dégâts minimum d'arme à une main",
		["WeaponOneHandMinDamageInfo"] = "Dégâts d'arme minimum, seulement pour les armes marquées une main, n'incluant pas les armes de main droite ou gauche.",
		["WeaponOneHandSpeed"] = "Vitesse d'arme à une main",
		["WeaponOneHandSpeedInfo"] = "Vitesse d'arme, seulement pour les armes marquées une main, n'incluant pas les armes de main droite ou gauche.",
		["WeaponRangedDps"] = "Dégâts par secondes à distance : DPS",
		["WeaponRangedDpsInfo"] = "Dégâts d'arme par seconde, seulement pour les armes à distance",
		["WeaponRangedMaxDamage"] = "Dégâts maximum à distance",
		["WeaponRangedMaxDamageInfo"] = "Dégâts d'arme maximum, seulement pour les armes à distance",
		["WeaponRangedMinDamage"] = "Dégâts minimum à distance",
		["WeaponRangedMinDamageInfo"] = "Dégâts d'arme minimum, seulement pour les armes à distance",
		["WeaponRangedSpeed"] = "Vitesse à distance",
		["WeaponRangedSpeedInfo"] = "Vitesse d'arme, seulement pour les armes à distance",
		["WeaponStats"] = "Stats d'arme",
		["WeaponTwoHandDps"] = "Dégâts par secondes à deux mains : DPS",
		["WeaponTwoHandDpsInfo"] = "Dégât d'arme par seconde, seulement pour les armes a deux mains",
		["WeaponTwoHandMaxDamage"] = "Dégâts maximum à deux mains",
		["WeaponTwoHandMaxDamageInfo"] = "Dégât d'arme maximum, seulement pour les armes a deux mains",
		["WeaponTwoHandMinDamage"] = "Dégâts minimum à deux mains",
		["WeaponTwoHandMinDamageInfo"] = "Dégât d'arme minimum, seulement pour les armes a deux mains",
		["WeaponTwoHandSpeed"] = "Vitesse à deux mains",
		["WeaponTwoHandSpeedInfo"] = "Vitesse d'arme, seulement pour les armes a deux mains",
		["WeaponType1HAxe"] = "Hache à une main",
		["WeaponType1HAxeInfo"] = "Points à attribuer si l'objet est une hache à une main",
		["WeaponType1HMace"] = "Masse à une main",
		["WeaponType1HMaceInfo"] = "Points à attribuer si l'objet est une masse à une main",
		["WeaponType1HSword"] = "Epée à une main",
		["WeaponType1HSwordInfo"] = "Points à attribuer si l'objet est une épée à une main",
		["WeaponType2HAxe"] = "Hache à deux mains",
		["WeaponType2HAxeInfo"] = "Points à attribuer si l'objet est une hache à deux mains",
		["WeaponType2HMace"] = "Masse à deux mains",
		["WeaponType2HMaceInfo"] = "Points à attribuer si l'objet est une masse à deux mains",
		["WeaponType2HSword"] = "Epée à deux mains",
		["WeaponType2HSwordInfo"] = "Points àà attribuer si l'objet est une épée à deux mains",
		["WeaponTypeBow"] = "Arc",
		["WeaponTypeBowInfo"] = "Points à attribuer si l'objet est un arc",
		["WeaponTypeCrossbow"] = "Arbalète",
		["WeaponTypeCrossbowInfo"] = "Points à attribuer si l'objet est une Arbalète",
		["WeaponTypeDagger"] = "Dague",
		["WeaponTypeDaggerInfo"] = "Points àà attribuer si l'objet est une dague",
		["WeaponTypeFistWeapon"] = "Arme de pugilat",
		["WeaponTypeFistWeaponInfo"] = "Points à attribuer si l'objet est une arme de pugilat",
		["WeaponTypeFrill"] = "Tenu en main gauche",
		["WeaponTypeFrillInfo"] = "Points à attribuer si l'objet est un \"Tenu(e) en main gauche\"  seconde main pour jeteur de sort. Ne s'applique pas aux boucliers ou aux armes",
		["WeaponTypeGun"] = "Fusil",
		["WeaponTypeGunInfo"] = "Points à attribuer si l'objet est un fusil",
		["WeaponTypeOffHand"] = "Arme de main gauche",
		["WeaponTypeOffHandInfo"] = "Points à attribuer si l'objet est n'importe quelle arme qui peut seulement etre équipée en main gauche. Ne s'applique pas aux objets 'Tenu(e) en main gauche\" des jeteurs de sort.",
		["WeaponTypePolearm"] = "Armes d'hast",
		["WeaponTypePolearmInfo"] = "Points à attribuer si l'objet est une arme d'hast",
		["WeaponTypes"] = "Type d'armes",
		["WeaponTypeStaff"] = "Bâton",
		["WeaponTypeStaffInfo"] = "Points à attribuer si l'objet est un bâton",
		["WeaponTypeThrown"] = "Armes de jet",
		["WeaponTypeThrownInfo"] = "Points à attribuer si l'objet est un arme de jet.",
		["WeaponTypeWand"] = "Baguette",
		["WeaponTypeWandInfo"] = "Points à attribuer si l'objet est une baguette",
		["WeaponTypeWarglaive"] = "Glaive de guerre",
		["WeaponTypeWarglaiveInfo"] = "points à attribuer si l'objet est un Glaive de guerre",
	},
	["UI"] = {
		["AboutHeader"] = "À propos de Pawn",
		["AboutMrRobot"] = "Les poids par défaut des statistiques sont fournis par le généreux M. Robot. Ils constituent un excellent point de départ pour les personnages aux talents et aux traits d'artefacts typiques dans les combats typiques. Vous pouvez obtenir des poids par défaut plus précis et personnalisés pour votre personnage en utilisant le simulateur 'Ask Mr. Robot' sur askmrrobot.com.",
		["AboutReadme"] = "Nouveautés dans Pawn ? Regardez la section Débuter (getting started) pour une introduction basique",
		["AboutTab"] = "À propos de",
		["AboutTranslation"] = "Version francaise par Othor, Vernel, et CerealCH",
		["AboutVersion"] = "Version %s",
		["AboutWebsite"] = "Pour d'autres mods par Vger, visitez vgermods.com.",
		["AskMrRobotProvider"] = "Ask Mr. Robot scales",
		["CompareClearItems"] = "Effacer",
		["CompareClearItemsTooltip"] = "Supprimez les deux objets de la comparaison.",
		["CompareColoredSockets"] = "Châsse",
		["CompareEquipped"] = "Equipé",
		["CompareGemTotalValue"] = "Valeur des gemmes",
		["CompareHeader"] = "Comparer les objets en utilisant %s",
		["CompareOtherHeader"] = "Autre",
		["CompareSlotEmpty"] = "(pas d'objet)",
		["CompareSocketBonus"] = "Bonus de sertissage",
		["CompareSocketsHeader"] = "Châsse",
		["CompareSpecialEffects"] = "Effets spéciaux",
		["CompareSwap"] = "‹ Échange ›",
		["CompareSwapTooltip"] = "Échange l'objet de gauche avec celui de droite",
		["CompareTab"] = "Comparer",
		["CompareVersus"] = "—comparé—",
		["CompareWelcomeRight"] = [=[Vous pouvez comparer ici deux objets et laisser Pawn afficher la comparaison. Pour comparer des objets glissez/déplacez les depuis votre inventaire ou vos sacs.

Vous pouvez également comparer deux objets depuis vos objets équipés en utilsant l'icone dans le coin en bas à gauche.]=],
		["CompareYourBest"] = "Meilleur choix",
		["GemsColorHeader"] = "gemmes %s",
		["GemsHeader"] = "Gemmes pour %s",
		["GemsNoneFound"] = "aucune gemme adéquate n'a été trouvée",
		["GemsQualityLevel"] = "Niveau de qualité de la gemme",
		["GemsQualityLevelTooltip"] = [=[Le niveau des objets pour lesquels il faut suggérer des gemmes.

Par exemple, si le niveau est de "175", alors Pawn affichera les gemmes qui sont appropriées pour être utilisées dans les objets de niveau 175. Si vous cliquez sur le bouton Pawn dans la fenêtre de châsse, Pawn le complétera pour vous automatiquement.]=],
		["GemsShowBest"] = "Les meilleures gemmes disponibles",
		["GemsShowBestTooltip"] = "Affiche la meilleur gemme absolue pour l'échelle utilisée en ce moment. Certaines de ces gemmes seront trop puissantes pour être inseré dans des chasses d'objets trop vieux et de moins bonnes qualités.",
		["GemsShowForItemLevel"] = "Les gemmes recommandées pour un objet de niveau :",
		["GemsShowForItemLevelTooltip"] = "Affiche les gemmes que Pawn recommande pour l'échelle à gauche qui est actuellement sélectionnée pour un objet d'un niveau spécifique indiqué dans le champs à droite de ce texte.",
		["GemsTab"] = "Gemmes",
		["GemsWelcome"] = "Sélectionnez une échelle sur la gauche pour afficher les recommandations de Pawn",
		["HelpHeader"] = "Bienvenu sur Pawn!",
		["HelpTab"] = "Pour débuter",
		["HelpText"] = [=[Pawn vous aide à trouver votre meilleur équipement et à identifier les améliorations. Lorsque vous gagnez des récompenses de quête ou un butin de donjon qui peut être meilleur que votre équipement actuel, Pawn vous le fait savoir grâce à une icône de flèche verte.

|cff8ec3e6Fire:|r |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% upgrade|r

Essayez ces fonctionnalités une fois que vous vous serez habitué aux bases:

• Comparez les statistiques de deux objets en utilisant l'onglet Comparaison de Pawn. 
• Cliquez avec le bouton droit de la souris sur un lien vers un objet pour voir comment il se compare à votre objet actuel. 
• Dans l'onglet Échelle, passez en mode manuel pour afficher des suggestions pour plus d'une spécification à la fois. 
• Utilisez le simulateur Demandez à Mr. Robot et construisez une échelle personnalisée pour votre personnage afin d'obtenir des conseils personnalisés.]=],
		["InterfaceOptionsBody"] = "Cliquez sur le bouton Pawn pour pour ouvrir l'interface graphique. vous  pouvez aussi ouvrir Pawn à partir de votre page d'inventaire, ou en y associant une touche.",
		["InterfaceOptionsWelcome"] = "Les options de Pawn se trouve dans le Pawn UI",
		["InventoryButtonTooltip"] = "Clic pour ouvrir Pawn",
		["InventoryButtonTotalsHeader"] = "Totaux de tous les objets équipés :",
		["KeyBindingCompareItemLeft"] = "Compare objet (gauche)",
		["KeyBindingCompareItemRight"] = "Compare objet (droit)",
		["KeyBindingShowUI"] = "Afficher Pawn",
		["OptionsAdvisorHeader"] = "Options conseillées",
		["OptionsAlignRight"] = "Aligne les valeurs sur le bord droit du tooltips",
		["OptionsAlignRightTooltip"] = "Cette option permet d'aligner les valeurs de Pawn et vos informations d'information sur le bord droit du tooltips au lieu de la gauche",
		["OptionsBagUpgradeAdvisor"] = "Montrer les améliorations de sac conseillées.",
		["OptionsBagUpgradeAdvisorTooltip"] = [=[Activez cette option pour que Pawn prenne en charge les flèches de mise à niveau dans le sac.

Si cette option est cochée, Pawn trouvera des objets dans vos sacs et marquera ceux qui sont de meilleurs pour l'une de vos échelle actives avec des flèches vertes.

Si cette option n'est pas cochée, WoW marquera les objets dont le niveau est supérieur à celui de votre tenue actuelle, et Pawn n'interférera pas avec la fonction intégrée.]=],
		["OptionsBlankLine"] = "Ajoute une ligne vide avant les valeurs",
		["OptionsBlankLineTooltip"] = "Cette option permet de séparer les informations de Pawn, en ajoutant une ligne vide",
		["OptionsButtonHidden"] = "Caché",
		["OptionsButtonHiddenTooltip"] = "Ne pas afficher le bouton Pawn sur le panneau d'information du personnage",
		["OptionsButtonPosition"] = "Affiche le bouton Pawn:",
		["OptionsButtonPositionLeft"] = "Sur la gauche",
		["OptionsButtonPositionLeftTooltip"] = "Affiche le bouton Pawn dans le coin inférieur gauche sur le panneau d'information du personnage",
		["OptionsButtonPositionRight"] = "Sur la droite",
		["OptionsButtonPositionRightTooltip"] = "Affiche le bouton Pawn dans le coin inférieur droite sur le panneau d'information du personnage",
		["OptionsColorBorder"] = "Couleur du cadre de l'infobulle des améliorations",
		["OptionsColorBorderTooltip"] = "Cette option permet de changer la couleur du bord des tooltips des objets qui sont amélioré en vert. Empêche cette option si ça interfère avec d'autres mods qui changent le bord des infobulle.",
		["OptionsCurrentValue"] = "Afficher les valeurs actuelles et de bases",
		["OptionsCurrentValueTooltip"] = [=[Cette option permet d'afficher deux valeurs par objets: la valeur courante, qui reflète l'état actuel de l'objet avec les gemmes, les enchantements, les retouches, les châsses vides (qui n'ajoutent aucuns bénéfices) en addition à la valeur de référence que Pawn affiche par défaut. La valeur courante sera affichée avant la valeur de référence. cette option n'a aucun effet à moins que vous permettiez l'affichage des valeurs d'objets dans le tooltip.

Il est conseillé d'utiliser la valeur de référence pour déterminer le meilleur entre deux objets, mais la valeur courante peut être utile pour le gain de niveau et il sera pour vous plus facile de décider s'il vaut mieux équiper immédiatement un nouvel objet avant qu'il soit gémmé et enchanté.]=],
		["OptionsDebug"] = "Affiche les informations de debug",
		["OptionsDebugTooltip"] = [=[Si vous n êtes pas certain de la façon dont Pawn calcule les valeurs pour un objet spécifique, cette option permet d'afficher toutes sortes de données utiles dans la console de discussion lors du survol d'un objet. Ces informations incluent les statistiques de Pawn, les informations de l objet que Pawn ne comprend pas et comment il prend en compte chacune de vos échelles.

Cette option remplira rapidement votre canal de discussion pensez à la dàésactiver une fois les diagnostiques terminés.

Raccourcis:
/pawn debug on
/pawn debug off]=],
		["OptionsHeader"] = "Ajuste les options de Pawn",
		["OptionsIgnoreGemsWhileLevelingCheck"] = "Ignorer les chasses sur les éléments bas niveau",
		["OptionsIgnoreGemsWhileLevelingCheckTooltip"] = [=[Activez cette option pour que Pawn ignore les châsses sur les éléments bas niveau lors du calcul des valeurs de l'élément, étant donné que la plupart des gens ne font pas à l'effort de dépenser de l'argent pour châsser les objets de bas niveaux. Un élément de « bas niveau » est plus faible que ce qui peut être obtenu dans un donjon héroïque au même niveau.

Si cochée, Pawn propose toujours les gemmes appropriées pour les éléments de bas niveau, mais elles seront ignorées dans les calculs et ils n'apparaisseront donc pas aussi souvent comme des mises à jour.

Si non cochée, Pawn calculera les valeurs pour les éléments comme s'ils étaient gémmés avec la meilleure gemme et quel que soit le niveau.]=],
		["OptionsIgnoreItemUpgradesCheck"] = "ignore les améliorations de Vaillance et Torve",
		["OptionsIgnoreItemUpgradesCheckTooltip"] = [=[valide cette option pour que Pawn ignore le montant des améliorations de Vaillance et Torve quand il calcule les valeurs des pièces
Si validé, Pawn traitera les pièces pouvant être amélioré tels qu'ils sont et ne considérera pas que vous pouvez utiliser des Fragments Apexis de Vaillance ou Torve afin d'améliorer la pièce au moment de déterminer si une pièce est meilleur que celle en votre possession.
Si non-validé, Pawn traitera ces pièces en assumant que vous les améliorerez au maximum avec des Fragments Apexis de Vaillance ou Torve. Cela pourrait faire qu'un équipement Torve de niveau 650 apparaisse comme une amélioration significative par rapport à un niveau 670 de la Fonderie de Blackrock, comme la pièce Torve pourrait être amélioré au niveau 705 grave aux Vaillances et Apexis
]=],
		["OptionsInventoryIcon"] = "Afficher les icônes à côté des infobulles",
		["OptionsInventoryIconTooltip"] = "Cette option permet d'afficher l'icône d'inventaire à coté de la fenêtre de lien de l objet",
		["OptionsItemIDs"] = "Affiche les ID des objets",
		["OptionsItemIDsTooltip"] = [=[Cette option permet d'afficher l'id de l'objet ainsi que les ids de tous les enchantements et gemmes.

Chaque objet dans World of Warcraft a un numéro d'ID qui lui est associé. Cette information est généralement seulement utile aux auteurs de mods]=],
		["OptionsLootAdvisor"] = "Affiche les suggestions d'améliorations de butin",
		["OptionsLootAdvisorTooltip"] = "Lorsque le butin est tombé dans un donjon et qu'il s'agit d'une amélioration pour votre personnage, Pawn affichera une fenêtre contextuelle attachée à la boîte de butin vous informant de l'amélioration.",
		["OptionsOtherHeader"] = "Autres options",
		["OptionsQuestUpgradeAdvisor"] = "Affiche les suggestions d'améliorations lors des quêtes",
		["OptionsQuestUpgradeAdvisorTooltip"] = "Affiche les suggestions d'améliorations dans votre journal de quêtes et lorsque vous parlez aux PNJs, si l'un des choix de récompense de quête est une amélioration de votre équipement actuel Pawn affichera une icône de flèche verte sur l'objet. Si aucun des objets n'est une amélioration, Pawn affichera une pile de pièces d'or sur l'objet qui rapporte le plus lors de la vente.",
		["OptionsResetUpgrades"] = "Re-scanner l'équipement",
		["OptionsResetUpgradesTooltip"] = [=[Pawn oubliera ce qu'il connait sur les objets que vous avez jamais équipés et il scannera à nouveau votre équipement afin de vous fournir des informations plus récentes sur les mises à jour.

Utilisez cette option si vous pensez que Pawn fait de mauvaises suggestions de mise à jour à cause d'objets que vous avez vendus, détruits ou que vous n'utilisez plus. Cela affectera tous vos personnages qui utilisent Pawn.]=],
		--[[Translation missing --]]
		["OptionsReforgingAdvisor"] = "Show reforging advisor",
		--[[Translation missing --]]
		["OptionsReforgingAdvisorTooltip"] = "When visiting an arcane reforger, Pawn will show you how to maximize the item's power.",
		["OptionsShowItemLevelUpgrades"] = "Afficher les augmentations de niveaux d'objets",
		["OptionsShowItemLevelUpgradesTooltip"] = "Pawn vous montrera des objets d'un niveau plus élevé que celui que vous avez précédemment équipé dans cet emplacement, en plus des améliorations normales.",
		["OptionsShowRelicUpgrades"] = "Montrer les améliorations apportées aux reliques.",
		["OptionsShowRelicUpgradesTooltip"] = "Pawn vous montrera quand une relique augmentera le niveau d'une de vos armes d'héritages. (Cela fonctionne différemment des autres fonctionnalités d'amélioration, car il est basé sur le niveau de l'objet, et non sur les statistiques).",
		["OptionsSocketingAdvisor"] = "Affiche les suggestions de châsses",
		["OptionsSocketingAdvisorTooltip"] = "Quand vous ajoutez des gemmes à un objet, Pawn affichera les gemmes que vous pouvez ajouter à l'objet qui maximiseront sa puissance. (Pour voir la liste complète des suggestions de gemmes de chaque couleur, voir l'onglet gemmes, ou vous pouvez aussi personnaliser la qualité des gemmes à utiliser.)",
		["OptionsTab"] = "Options",
		["OptionsTooltipHeader"] = "Options des tooltips",
		["OptionsTooltipSpecIcon"] = "Affiche l'icone des spec",
		["OptionsTooltipSpecIconTooltip"] = "Valide cette option pour afficher l'icone des specs à coté des noms d'échelle sur l'infobulle.",
		["OptionsTooltipUpgradesOnly"] = "Affiche uniquement les améliorations",
		["OptionsTooltipUpgradesOnlyTooltip"] = [=[Ceci est l'option la plus simple. Affiche seulement le pourcentage d'amélioration pour les objets qui sont une amélioration de votre tenue actuelle, et indique quels objets sont les meilleurs objets que vous possédez pour chaque échelle (formule). N'affiche rien pour les objets plus faible.

|cff8ec3e6Fire:|r  |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% amélioration|r

...ou...

|cff8ec3e6Fire:  votre meilleur|r]=],
		["OptionsTooltipValuesAndUpgrades"] = "Affiche les valeurs d échelle et le % d'amélioration",
		["OptionsTooltipValuesAndUpgradesTooltip"] = [=[Affiche les valeurs de Pawn pour toutes vos échelles visibles sur tous les objets, excepté ceux qui ont une valeur de zéro. De plus, indique quels objets sont une amélioration de votre tenue actuelle.
|cff8ec3e6Frost:  123.4
Fire:  156.7 |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% amélioration|r]=],
		["OptionsTooltipValuesOnly"] = "Affiche seulement les valeurs d'échelles, pas les % d'amélioration",
		["OptionsTooltipValuesOnlyTooltip"] = [=[Affiche les valeurs de Pawn pour toutes les échelles visible de chaque objets, excepté ceux qui ont une valeur de zéro. N'indique pas quels objets sont une amélioration à votre tenue actuelle. Cette option reflète le fonctionnement par défaut de plus anciennes versions de Pawn.
|cff8ec3e6Frost:  123.4
Fire:  156.7|r]=],
		["OptionsUpgradeHeader"] = "Afficher les mises à jour de |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t sur les infobulles :",
		["OptionsUpgradeSettingsHeader"] = "Options de mise à jour",
		["OptionsUpgradesForBothWeaponTypes"] = "Affiche les améliorations pour une main et deux mains",
		["OptionsUpgradesForBothWeaponTypesTooltip"] = [=[Les conseils de mise à niveau de Pawn doivent suivre et montrer les mises à niveau de vos armes à deux mains et de vos armes équipées dans chaque mains (pour les loteries, la main principale et la main secondaire) séparément.

Si la vérification est faite, vous pourriez utiliser une arme à deux mains et voir des armes à une main nettement inférieures en améliorations si elles sont meilleures que la meilleure (ou la deuxième) arme à une main que vous aviez auparavant, car Pawn suit les améliorations séparément pour les deux jeux d'armes.

Si cela n'est pas vérifié, le fait d'équiper une arme à deux mains empêchera Pawn de vous montrer des améliorations pour les objets à une main et vice-versa.]=],
		["OptionsUpgradeTrackingHeader"] = "Comparaison d'amélioration:",
		["OptionsUpgradeTrackingOff"] = "Comparé à l'équipement équipé (recommandé)",
		["OptionsUpgradeTrackingOffTooltip"] = "Pawn vous affichera vos pièces qui sont des améliorations en comparaison des pièces actuellement équipés",
		["OptionsUpgradeTrackingOn"] = "Recherche le meilleur pour chaque échelle (avancés)",
		["OptionsUpgradeTrackingOnTooltip"] = "(Pour les utilisateurs avancés) Pawn essayera de rechercher les meilleures pièces dont vous êtes équipés, indépendamment de chaque niveau que vous avez validés, et vous affichera les pièces qui vous permettent des améliorations comparées à celles équipées.",
		["OptionsWelcome"] = "Configurez Pawn comme vous le souhaitez. Les changements prendront effet immédiatement.",
		--[[Translation missing --]]
		["ReforgeTitle"] = "Pawn:",
		--[[Translation missing --]]
		["ReforgeInstructionsNoReforge"] = "Do not reforge",
		--[[Translation missing --]]
		["ReforgeInstructions"] = "%s -> %s",
		--[[Translation missing --]]
		["ReforgeCappedStatWarning"] = "Use care when reforging Hit or Expertise, and don't reforge stats you need.",
		["ScaleAutoOff"] = "Manuel",
		["ScaleAutoOff2"] = "Gestion manuelle des échelles",
		["ScaleAutoOffTooltip"] = "Pawn vous laissera choisir manuellement  quelle échelle utiliser pour ses calculs, vous permettant de valider plus d'une échelle à la fois, d'ajouter des échelles personnelles, et plus.",
		["ScaleAutoOn"] = "Automatique",
		["ScaleAutoOn2"] = "Utiliser la spécialisation actuelle",
		["ScaleAutoOnTooltip"] = "Pawn vous affichera automatiquement votre spécialisation actuelle dans l'infobulle des pièces, et l'utilisera afin de faire des recommandation et suggestions d'améliorations.",
		["ScaleAutoWelcome"] = "Pawn affichera des suggestions pour votre spécialisation actuelle",
		["ScaleChangeColor"] = "Change la couleur",
		["ScaleChangeColorTooltip"] = "Change la couleur avec laquelle apparait le nom et la valeur dans le tooltip d'un objet",
		["ScaleCopy"] = "Copier",
		["ScaleCopyTooltip"] = "Crée une nouvelle échelle en faisant une copie de celle ci.",
		["ScaleDefaults"] = "Défauts",
		["ScaleDefaultsTooltip"] = "Crée une nouvelle échelle en faisant une copie de celle par défaut",
		["ScaleDeleteTooltip"] = [=[Efface cette échelle (formule)

Cette commande ne peut etre défaite!]=],
		["ScaleEmpty"] = "Vide",
		["ScaleEmptyTooltip"] = "Créer une nouvelle échelle à partir de zéro.",
		["ScaleExport"] = "Exporter",
		["ScaleExportTooltip"] = "Partage vos formules avec d'autres sur internet",
		["ScaleHeader"] = "Gère vos échelles Pawn",
		["ScaleImport"] = "Importer",
		["ScaleImportTooltip"] = "Ajoute une nouvelle échelle (formule) en collant une Étiquette d'échelle depuis Internet",
		["ScaleNewHeader"] = "Créer une nouvelle échelle",
		["ScaleRename"] = "Renommer",
		["ScaleRenameTooltip"] = "Renomme cette échelle",
		["ScaleSelectorHeader"] = "Sélectionne une échelle:",
		["ScaleSelectorNoneWarning"] = "Sélectionnez au moins un.",
		["ScaleSelectorShowingSuggestionsFor"] = "affiche des sugestions pour",
		["ScaleSelectorShowScale"] = "Affiche l'échelle dans le tooltip",
		["ScaleSelectorShowScaleTooltip"] = "Quand cette option est validée, les valeurs pour cette échelle apparaitront dans le tooltip de ce personnage. Chaque échelles peut apparaitre sur votre personnage, plusieurs personnages, ou aucuns personnages.",
		["ScaleShareHeader"] = "Partagez vos échelles",
		["ScaleTab"] = "Échelle",
		["ScaleTypeNormal"] = "Vous pouvez changer cette échelle dans l'onglet Valeur.",
		["ScaleTypeReadOnly"] = "Si vous souhaitez personnaliser cette échelle, créez d'abord une copie.",
		["ScaleWelcome"] = "Les échelles sont des ensembles de statistiques et de valeurs qui sont utilisées pour assigner une note en points aux objets. Vous pouvez personnaliser votre échelle ou utiliser celles crées par d'autres personnes.",
		["SocketingAdvisorButtonTooltip"] = "Clic pour ouvrir l onglet Gemmes de Pawn, ou vous pouvez trouver plus d'informations sur les gemmes que Pawn recommande.",
		["SocketingAdvisorHeader"] = "Suggestions de Pawn pour les châsses:",
		["SocketingAdvisorIgnoreThisItem"] = "Ne vous embêtez pas a ajouter des gemmes sur cet objet de bas niveau. Mais si vous le faites, utilisez :",
		["StarterProvider"] = "Échelles de départ.",
		["ValuesDoNotShowUpgradesFor1H"] = "Ne pas afficher d'amélioration pour les objets a une main",
		["ValuesDoNotShowUpgradesFor2H"] = "Ne pas afficher d'amélioration pour les objets a deux mains",
		["ValuesDoNotShowUpgradesTooltip"] = "Cette option permet de cacher les améliorations pour ce type d'objet. Par exemple, même si les tanks paladin peuvent utiliser des armes a deux mains, une arme à deux mains n'est jamais une \"amélioration\" pour un ensemble de paladin tank, aussi Pawn ne devrait pas afficher informations d amélioration pour eux. De même, les Paladin Vindicte peuvent utiliser des armes a une main, mais ce n'est jamais une amélioration.",
		["ValuesHeader"] = "Pondérations de statistiques pour %s",
		["ValuesIgnoreItemType"] = "Ces objets sont inutilisables",
		["ValuesIgnoreStat"] = "Les objets avec ceci sont inutilisables",
		["ValuesIgnoreStatTooltip"] = "Cette option fait que chaque objets avec cette stat n'aura pas de valeurs pour cette échelle. Par exemple, les shamans ne peuvent pas porter de la plaque, donc une échelle (formule) conçue pour un shaman peut marquer la plaque comme inutilisable ainsi les armures de plaques ne recevront aucune valeur",
		["ValuesNormalize"] = "Normalise les valeurs (comme Wowhead)",
		["ValuesNormalizeTooltip"] = "Cette option permet de diviser la valeur finale calculée d'un objet par la somme de tous les stats dans votre échelle, comme le font Wowhead et lootzor. Cela aide dans des situations ou des échelle (formule) ont des valeurs de stat autour de 1 et une autre autour de 5. Ca aide aussi a garder des petits nombres",
		["ValuesRemove"] = "Supprimer",
		["ValuesRemoveTooltip"] = "Supprime cette stat de l'échelle (formule)",
		["ValuesTab"] = "Poids",
		["ValuesWelcome"] = "Vous pouvez personnaliser les valeurs attribuées à chaque statistique pour cette balance. Pour gérer vos échelles et en ajouter de nouvelles, utilisez le mode manuel dans l'onglet échelle.",
		["ValuesWelcomeNoScales"] = "Vous n'avez sélectionné aucune échelle. Pour commencer, aller a l onglet échelle et crees-en une nouvelle ou coller une depuis Internet",
		["ValuesWelcomeReadOnly"] = "Cette échelle intégrée ne peut pas être modifiée. Si vous souhaitez personnaliser ces pondérations, allez dans l'onglet échelle, activez le mode manuel et faites une copie de l'échelle actuelle.",
	}
}

PawnLocal.TooltipParsing = {
	["Agility"] = "^%+?# Agilité$",
	["AllStats"] = "^%+?# à toutes les caractéristiques$",
	["Ap"] = "^%+?# à la puissance d'attaque$",
	["Ap2"] = "^E?\195?\137?quipé : %+# à la puissance d'attaque%.$",
	["Ap3"] = "^Équipé : Augmente de # la puissance d'attaque%.$",
	["ArcaneResist"] = "^%+?# à la résistance Arcanes$",
	["ArcaneSpellDamage"] = "^%+# aux dégâts des sorts des Arcanes$",
	["ArcaneSpellDamage2"] = "^E?\195?\137?quipé : Augmente les dégâts infligés par les sorts et effets des Arcanes de # au maximum%.$",
	["ArcaneSpellDamage3"] = "^%+# aux dégâts des Arcanes$",
	["Armor"] = "^Armure..?: #$",
	["Armor2"] = "^UNUSED$",
	["ArmorPenetration"] = "^Équipé : Vos attaques ignorent # points de l'armure de votre adversaire%.$",
	["ArmorPenetrationRating"] = "^Équipé : Augmente de # le score de pénétration d'armure%.$",
	["ArmorPenetrationRating2"] = "^Équipé : Augmente de # la pénétration d'armure%.$",
	["ArmorPenetrationShort"] = "^%+?# au score de pénétration d'armure$",
	["Avoidance"] = "^%+# Évitement$",
	["Axe"] = "^Hache$",
	["BagSlots"] = "^Sac %d+ .+$",
	["Block"] = "^Bloquer : #$",
	["BlockPercent"] = "^E?\195?\137?quipé : Augmente vos chances de bloquer les attaques avec un bouclier de #%%%.$",
	["BlockRating"] = "^Équipé : Augmente votre score de blocage de #%.$",
	["BlockRating2"] = "^Équipé : Augmente de # le score de blocage%.$",
	["BlockValue"] = "^E?\195?\137?quipé : Augmente le score de blocage de votre bouclier de #%.$",
	["Bow"] = "^Arc$",
	["ChanceOnHit"] = "Chances de toucher :",
	["Charges"] = "^.+ Charges?$",
	["Cloth"] = "^Tissu$",
	["CooldownRemaining"] = "^Temps de recharge restant:",
	["Corruption"] = "^%+?# Corruption$",
	["Crit"] = "^%+?# Score de crit%.?$",
	["Crit2"] = "^%+?# au score de critique$",
	["CritPercent"] = "^E?\195?\137?quipé : Augmente vos chances d'infliger un coup critique de #%%%.$",
	["CritPercentCombined"] = "^Equipé : Augmente de # %% vos chances d’infliger un coup critique avec tous les sorts et attaques%.$",
	["CritRating"] = "^Équipé : Augmente votre score de coup critique de #%.$",
	["CritRating2"] = "^UNUSED$",
	["CritRating3"] = "^Équipé : Augmente de # le score de coup critique%.$",
	["CritRatingShort"] = "^%+?# au score de coup critique$",
	["Crossbow"] = "^Arbalète$",
	["Dagger"] = "^Dague$",
	["DefenseRating"] = "^Équipé : Score de défense augmenté de #%.$",
	["DefenseRating2"] = "^Équipé : Augmente de # le score de défense%.?$",
	["DefenseRatingSimple"] = "^%+?# au score de défense$",
	["DefenseSkill"] = "^E?\195?\137?quipé : Défense augmentée de #%.$",
	["DefenseSkillSimple"] = "^%+?# Défense$",
	["DisenchantingRequires"] = "^L'enchantement requiert",
	["Dodge"] = "^%+?#%%? Esquive$",
	["Dodge2"] = "^%+?# à l'esquive$",
	["Dodge3"] = "^UNUSED$",
	["DodgePercent"] = "^E?\195?\137?quipé : Augmente vos chances d'esquiver une attaque de #%%%.$",
	["DodgeRating"] = "^Équipé : Augmente votre score d'esquive de #%.$",
	["DodgeRating2"] = "^Équipé : Augmente de # le score d’esquive%.$",
	["DodgeRatingShort"] = "^%+?#%%? au score d'esquive$",
	["Dps"] = "^%(# dégâts par seconde%)$",
	["DpsAdd"] = "^Ajoute # dégâts par seconde$",
	["Duration"] = "^Durée :",
	["Elite"] = "^Elite$",
	["EnchantmentArmorKit"] = "^Renforcé %(%+(%d+) Armure%)$",
	["EnchantmentCounterweight"] = "^Contrepoids %(%+# à la hâte%)",
	["EnchantmentFieryWeapon"] = "^Arme flamboyante$",
	["EnchantmentHealth"] = "^%+# aux points de vie$",
	["EnchantmentHealth2"] = "^UNUSED$",
	["EnchantmentLivingSteelWeaponChain"] = "^Dragonne en acier vivant$",
	["EnchantmentPyriumWeaponChain"] = "^Dragonne en pyrium$",
	["EnchantmentTitaniumWeaponChain"] = "^Dragonne en titane$",
	["Equip"] = "Équipé :",
	["ExpertiseRating"] = "^Équipé : Augmente de # le score d’expertise%.$",
	["ExpertiseRatingShort"] = "^%+?# au score d'expertise$",
	["FeralAp"] = "^E?\195?\137?quipé : %+# à la puissance d'attaque pour les formes de félin, d'ours et d'ours redoutable uniquement%.$",
	["FeralApMoonkin"] = "^Équipé : Augmente de # la puissance d'attaque pour les formes de félin, d'ours, d'ours redoutable et de sélénien uniquement%.$",
	["FeralApWrath"] = "^Augmente de # la puissance d'attaque pour les formes de félin, d'ours, d'ours redoutable et de sélénien uniquement%.$",
	["FireResist"] = "^%+?# à la résistance Feu$",
	["FireSpellDamage"] = "^%+# aux dégâts des sorts de Feu$",
	["FireSpellDamage2"] = "^E?\195?\137?quipé : Augmente les dégâts infligés par les sorts et effets de Feu de # au maximum%.$",
	["FireSpellDamage3"] = "^%+# aux dégâts de Feu$",
	["FistWeapon"] = "^Arme de pugilat$",
	["Flexible"] = "^Flexible$",
	["FrostResist"] = "^%+?# à la résistance Givre$",
	["FrostSpellDamage"] = "^%+# aux dégâts des sorts de Givre$",
	["FrostSpellDamage2"] = "^E?\195?\137?quipé : Augmente les dégâts infligés par les sorts et effets de Givre de # au maximum%.$",
	["FrostSpellDamage3"] = "^%+# aux dégâts de Givre$",
	["Gun"] = "^Arme à feu$",
	["Haste"] = "^%+?# Hâte$",
	["Haste2"] = "^%+?# à la Hâte",
	["HasteRating"] = "^Équipé : Augmente de # le score de hâte%.$",
	["HasteRating2"] = "^UNUSED$",
	["HasteRatingShort"] = "^%+?# au score de hâte$",
	["HaventCollectedAppearance"] = "^Vous n'avez pas récupéré cette apparence$",
	["Healing"] = "^%+# aux sorts de soins$",
	["Healing2"] = "^E?\195?\137?quipé : Augmente les soins prodigués par les sorts et effets de # au maximum%.$",
	["Healing3"] = "^%+# aux soins$",
	["HeirloomLevelRange"] = "^Requier un niveau de %d+ à (%d+)",
	["HeirloomXpBoost"] = "^E?\195?\137?quipé : L?'?[Ee]xpérience gagnée",
	["HeirloomXpBoost2"] = "^UNUSED$",
	["Heroic"] = "^Héroïque$",
	["HeroicElite"] = "^Héroïque élite$",
	["HeroicThunderforged"] = "^Foudroyant héroïque$",
	["HeroicWarforged"] = "^De guerre héroïque$",
	["Hit"] = "^E?\195?\137?quipé : Augmente vos chances de toucher de #%%%.$",
	["Hit2"] = "^UNUSED$",
	["HitPercentCombined"] = "^Equipé : Augmente de # %% les chances de toucher avec tous les sorts et attaques%.$",
	["HitRating"] = "^Équipé : Augmente de # le score de toucher%.$",
	["HitRating2"] = "^Équipé : Augmente votre score de toucher de #%.$",
	["HitRating3"] = "^UNUSED$",
	["HitRatingShort"] = "^%+?# au score de toucher$",
	["HolySpellDamage"] = "^%+# aux dégâts des sorts du Sacré$",
	["HolySpellDamage2"] = "^E?\195?\137?quipé : Augmente les dégâts infligés par les sorts et effets du Sacré de # au maximum%.$",
	["HolySpellDamage3"] = "^E?\195?\137?quipé : Augmente de # au maximum les dégâts infligés par les sorts et effets du Sacré%.$",
	["Hp5"] = "^%+?# [pP]oints de [vV]ie [tT]outes les 5 [sS]%.?$",
	["Hp52"] = "^E?\195?\137?quipé : Reconstitue # de vie par 5 sec%.$",
	["Hp53"] = "^%+?# [pP]oints de [vV]ie [tT]outes les 5 [sS]ec%.?$",
	["Hp54"] = "^%+?# [vV]ie [pP]ar 5 [sS]ec%.?$",
	["Hp55"] = "^UNUSED$",
	["Intellect"] = "^%+?# Intelligence$",
	["Leather"] = "^Cuir$",
	["Leech"] = "^%+# Ponction$",
	["Mace"] = "^Masse$",
	["Mail"] = "^Mailles$",
	["Mastery"] = "^%+?# Maîtrise$",
	["Mastery2"] = "^%+?# à la maîtrise$",
	["MetaGemRequirements"] = "|cff%x%x%x%x%x%xNécessite",
	["MovementSpeed"] = "^%+# Vitesse$",
	["Mp5"] = "^E?\195?\137?quipé : Rend # points de mana toutes les 5 secondes%.$",
	["Mp52"] = "^%+?# points de mana toutes les 5 sec%.$",
	["Mp53"] = "^%+?# points de mana toutes les 5 secondes$",
	["Mp54"] = "^Équipé : Rend # points de mana toutes les 5 sec%.$",
	["Mp55"] = "^UNUSED$",
	["MultiStatHeading"] = "^Stats Multiple$",
	["MultiStatSeparator1"] = "et",
	["Multistrike"] = "^%+# Frappe multiple$",
	["NatureResist"] = "^%+?# à la résistance Nature$",
	["NatureSpellDamage"] = "^%+# aux dégâts des sorts de Nature$",
	["NatureSpellDamage2"] = "^E?\195?\137?quipé : Augmente les dégâts infligés par les sorts et effets de Nature de # au maximum%.$",
	["NatureSpellDamage3"] = "^%+# aux dégâts de Nature$",
	["NormalizationEnchant"] = "^Enchanté : (.*)$",
	["Parry"] = "^%+?# Parade$",
	["Parry2"] = "^%+?# à la parade$",
	["ParryPercent"] = "^E?\195?\137?quipé : Augmente vos chances de parer une attaque de #%%%.$",
	["ParryRating"] = "^Équipé : Augmente votre score de parade de #%.$",
	["ParryRatingShort"] = "^%+?# au score de parade$",
	["Plate"] = "^Plaques$",
	["Polearm"] = "^Arme d'hast$",
	["PvPPower"] = "^%+?# [Pp]uissance %(JcJ%)$",
	["RaidFinder"] = "^Outil Raids$",
	["Rap"] = "^E?\195?\137?quipé : %+# à la puissance des attaques à distance%.$",
	["Rap2"] = "^E?\195?\137?quipé : Augmente la puissance des attaques à distance de #%.$",
	["Requires2"] = "^Niveau [%d%.,]+ requis$",
	["Resilience"] = "^%+?# Résilience %(JcJ%)$",
	["Resilience2"] = "^%+?# à la résilience %(JcJ%)$",
	["ResilienceRating"] = "^Équipé : Augmente de # le score de résilience%.$",
	["ResilienceRatingShort"] = "^%+?# au score de résilience$",
	["Scope"] = "^Lunette %(%+# points de dégâts%)$",
	["ScopeCrit"] = "^Lunette %(%+# au score de critique%)$",
	["ScopeRangedCrit"] = "^%+?# au score de critique à distance$",
	["ShadowResist"] = "^%+?# à la résistance Ombre$",
	["ShadowSpellDamage"] = "^%+# aux dégâts des sorts d'Ombre$",
	["ShadowSpellDamage2"] = "^E?\195?\137?quipé : Augmente les dégâts infligés par les sorts et effets d'Ombre de # au maximum%.$",
	["ShadowSpellDamage3"] = "^UNUSED$",
	["ShadowSpellDamage4"] = "^%+# aux dégâts d'Ombre$",
	["Shield"] = "^Bouclier$",
	["SocketBonusPrefix"] = "Bonus de sertissage : ",
	["Speed"] = "^Vitesse #$",
	["Speed2"] = "^UNUSED$",
	["SpellCrit"] = "^E?\195?\137?quipé : Augmente vos chances d'infliger un coup critique avec vos sorts de #%%%.$",
	["SpellCritRating"] = "^Équipé : Augmente le score de coup critique des sorts de #%.$",
	["SpellCritRating2"] = "^Équipé : Augmente de # le score de coup critique des sorts%.$",
	["SpellCritRatingShort"] = "^%+?# au score de critique des sorts$",
	["SpellCritRatingShort2"] = "^%+?# au score de coup critique des sorts$",
	["SpellDamage"] = "^%+# aux dégâts et aux sorts de soins$",
	["SpellDamage2"] = "^Équipé : Augmente les dégâts et les soins produits par les sorts et effets magiques de # au maximum%.$",
	["SpellDamage3"] = "^E?\195?\137?quipé : Augmente les soins et dégâts produits par les sorts et effets magiques de # au maximum%.$",
	["SpellDamage4"] = "^UNUSED$",
	["SpellDamage5"] = "^%+# aux dégâts des sorts et aux soins$",
	["SpellDamage6"] = "^UNUSED$",
	["SpellDamageAndHealing"] = "^Équipé : Augmente les soins prodigués d'un maximum de # et les dégâts d'un maximum de # pour tous les sorts et effets magiques%.$",
	["SpellDamageAndHealing2"] = "^UNUSED$",
	["SpellDamageAndHealingEnchant"] = "^%+# aux soins et %+# aux dégâts des sorts$",
	["SpellDamageAndHealingShort"] = "^%+# aux sorts de soins et %+# aux dégâts des sorts$",
	["SpellDamageAndHealingShort2"] = "^UNUSED$",
	["SpellHasteRating"] = "^Équipé : Augmente de # le score de hâte des sorts%.$",
	["SpellHasteRatingShort"] = "^%+?# au score de hâte des sorts$",
	["SpellHit"] = "^E?\195?\137?quipé : Augmente vos chances de toucher avec des sorts de #%%%.$",
	["SpellHitRating"] = "^Équipé : Augmente le score de toucher des sorts de #%.$",
	["SpellHitRating2"] = "^Équipé : Augmente de # le score de toucher des sorts%.$",
	["SpellHitRatingShort"] = "^%+?# au score de toucher des sorts$",
	["SpellPenetration"] = "^Équipé : Augmente la pénétration de vos sorts de #%.$",
	["SpellPenetrationClassic"] = "^E?\195?\137?quipé : Diminue les résistances magiques des cibles de vos sorts de #%.$",
	["SpellPenetrationShort"] = "^%+?# à la pénétration des sorts$",
	["SpellPower"] = "^%+?# à? ?l?a? ?[Pp]uissance des sorts$",
	["SpellPower2"] = "^Équipé : Augmente la puissance des sorts de #%.$",
	["SpellPower3"] = "^Équipé : Augmente de # la puissance des sorts%.$",
	["Spirit"] = "^%+?# Esprit$",
	["Staff"] = "^Bâton$",
	["Stamina"] = "^%+?# Endurance$",
	["Strength"] = "^%+?# Force$",
	["Sword"] = "^Epée$",
	["TemporaryBuffMinutes"] = "^.+%(%d+ min%)$",
	["TemporaryBuffSeconds"] = "^.+%(%d+ sec%)$",
	["Thrown"] = "^Armes de jet$",
	["Thunderforged"] = "^Foudroyant$",
	["Timeless"] = "^du Temps figé$",
	["Titanforged"] = "^forgées par les titans$",
	["UpgradeLevel"] = "^Niveau d’amélioration :",
	["Use"] = "Utiliser :",
	["Versatility"] = "^%+# Polyvalence$",
	["Wand"] = "^Baguette$",
	["Warforged"] = "^De guerre$",
	["Warglaives"] = "^Glaives de guerre$",
	["WeaponDamage"] = "^Dégâts.?.?: # %- #$",
	["WeaponDamageArcane"] = "^# %- # points de dégâts %(Arcanes%)$",
	["WeaponDamageArcaneExact"] = "^# points de dégâts %(Arcanes%)$",
	["WeaponDamageEnchantment"] = "^%+?# aux dégâts de l'arme$",
	["WeaponDamageEquip"] = "^E?\195?\137?quipé : %+?# aux dégâts de l'arme%.$",
	["WeaponDamageExact"] = "^# Dégâts$",
	["WeaponDamageFire"] = "^# %- # points de dégâts %(Feu%)$",
	["WeaponDamageFireExact"] = "^# points de dégâts %(Feu%)$",
	["WeaponDamageFrost"] = "^# %- # points de dégâts %(Givre%)$",
	["WeaponDamageFrostExact"] = "^# points de dégâts %(Givre%)$",
	["WeaponDamageHoly"] = "^# %- # points de dégâts %(Sacré%)$",
	["WeaponDamageHolyExact"] = "^# points de dégâts %(Sacré%)$",
	["WeaponDamageNature"] = "^# %- # points de dégâts %(Nature%)$",
	["WeaponDamageNatureExact"] = "^# points de dégâts %(Nature%)$",
	["WeaponDamageShadow"] = "^# %- # points de dégâts %(Ombre%)$",
	["WeaponDamageShadowExact"] = "^# points de dégâts %(Ombre%)$",
}

-- Special case: wands actually use different text on live versus classic.
-- So, patch things up here.

if VgerCore.IsClassic or VgerCore.IsBurningCrusade then
	PawnLocal.ThousandsSeparator = "NBSP"
	PawnLocal.DecimalSeparator = "."
elseif VgerCore.IsWrath then
	PawnLocal.ThousandsSeparator = ""
	PawnLocal.DecimalSeparator = ","
elseif VgerCore.IsCataclysm then
	PawnLocal.ThousandsSeparator = "-"
	PawnLocal.DecimalSeparator = "."
end

if VgerCore.IsClassic or VgerCore.IsBurningCrusade or VgerCore.IsWrath or VgerCore.IsCataclysm then
	local TooltipParsing_Classic =
	{
		["WeaponDamageArcane"] = "^Dégâts %(Arcanes%) : # %- #$",
		["WeaponDamageArcaneExact"] = "^Dégâts %(Arcanes%) : #$",
		["WeaponDamageFire"] = "^Dégâts %(Feu%) : # %- #$",
		["WeaponDamageFireExact"] = "^Dégâts %(Feu%) : #$",
		["WeaponDamageFrost"] = "^Dégâts %(Givre%) : # %- #$",
		["WeaponDamageFrostExact"] = "^Dégâts %(Givre%) : #$",
		["WeaponDamageHoly"] = "^Dégâts %(Sacré%) : # %- #$",
		["WeaponDamageHolyExact"] = "^Dégâts %(Sacré%) : #$",
		["WeaponDamageNature"] = "^Dégâts %(Nature%) : # %- #$",
		["WeaponDamageNatureExact"] = "^Dégâts %(Nature%) : #$",
		["WeaponDamageShadow"] = "^Dégâts %(Ombre%) : # %- #$",
		["WeaponDamageShadowExact"] = "^Dégâts %(Ombre%) : #$",
	}

	local Key, NewString
	for Key, NewString in pairs(TooltipParsing_Classic) do
		PawnLocal.TooltipParsing[Key] = NewString
	end
end

if VgerCore.IsBurningCrusade or VgerCore.IsWrath or VgerCore.IsCataclysm then

	local TooltipParsing_BurningCrusade =
	{
		["Block"] = "^Bloquer : #$",
		["BlockValue"] = "^Équipé : Augmente la valeur de blocage de votre bouclier de #%.$",
	}

	local Key, NewString
	for Key, NewString in pairs(TooltipParsing_BurningCrusade) do
		PawnLocal.TooltipParsing[Key] = NewString
	end
end

PawnLocal.Specs =
{
	[1] = {
		{ Name="Armes", Icon=132355, Role="DAMAGER" },
		{ Name="Fureur", Icon=132347, Role="DAMAGER" },
		{ Name="Protection", Icon=132341, Role="TANK" },
	},
	[2] = {
		{ Name="Sacré", Icon=135920, Role="HEALER" },
		{ Name="Protection", Icon=236264, Role="TANK" },
		{ Name="Vindicte", Icon=135873, Role="DAMAGER" },
	},
	[3] = {
		{ Name="Maîtrise des bêtes", Icon=461112, Role="DAMAGER" },
		{ Name="Précision", Icon=236179, Role="DAMAGER" },
		{ Name="Survie", Icon=461113, Role="DAMAGER" },
	},
	[4] = {
		{ Name="Assassinat", Icon=236270, Role="DAMAGER" },
		{ Name="Hors-la-loi", Icon=236286, Role="DAMAGER" },
		{ Name="Finesse", Icon=132320, Role="DAMAGER" },
	},
	[5] = {
		{ Name="Discipline", Icon=135940, Role="HEALER" },
		{ Name="Sacré", Icon=237542, Role="HEALER" },
		{ Name="Ombre", Icon=136207, Role="DAMAGER" },
	},
	[6] = {
		{ Name="Sang", Icon=135770, Role="TANK" },
		{ Name="Givre", Icon=135773, Role="DAMAGER" },
		{ Name="Impie", Icon=135775, Role="DAMAGER" },
	},
	[7] = {
		{ Name="Élémentaire", Icon=136048, Role="DAMAGER" },
		{ Name="Amélioration", Icon=237581, Role="DAMAGER" },
		{ Name="Restauration", Icon=136052, Role="HEALER" },
	},
	[8] = {
		{ Name="Arcanes", Icon=135932, Role="DAMAGER" },
		{ Name="Feu", Icon=135810, Role="DAMAGER" },
		{ Name="Givre", Icon=135846, Role="DAMAGER" },
	},
	[9] = {
		{ Name="Affliction", Icon=136145, Role="DAMAGER" },
		{ Name="Démonologie", Icon=136172, Role="DAMAGER" },
		{ Name="Destruction", Icon=136186, Role="DAMAGER" },
	},
	[10] = {
		{ Name="Maître brasseur", Icon=608951, Role="TANK" },
		{ Name="Tisse-brume", Icon=608952, Role="HEALER" },
		{ Name="Marche-vent", Icon=608953, Role="DAMAGER" },
	},
	[11] = {
		{ Name="Équilibre", Icon=136096, Role="DAMAGER" },
		{ Name="Farouche", Icon=132115, Role="DAMAGER" },
		{ Name="Gardien", Icon=132276, Role="TANK" },
		{ Name="Restauration", Icon=136041, Role="HEALER" },
	},
	[12] = {
		{ Name="Dévastation", Icon=1247264, Role="DAMAGER" },
		{ Name="Vengeance", Icon=1247265, Role="TANK" },
	},
}

end

if GetLocale() == "frFR" then
	PawnUseThisLocalization()
end

-- After using this localization or deciding that we don't need it, remove it from memory.
PawnUseThisLocalization = nil
