﻿-- Pawn by Vger-Azjol-Nerub
-- www.vgermods.com
-- © 2006-2024 Travis Spomer.  This mod is released under the Creative Commons Attribution-NonCommercial-NoDerivs 3.0 license.
-- See Readme.htm for more information.

--
-- English resources
------------------------------------------------------------


local function PawnUseThisLocalization()
PawnLocal =
{
	["AverageItemLevelIgnoringRarityTooltipLine"] = "Average item level",
	["BaseValueWord"] = "base",
	["CopyScaleEnterName"] = "Enter a name for your new scale, a copy of %s:",
	["DecimalSeparator"] = ".",
	["DeleteScaleConfirmation"] = "Are you sure you want to delete %s? This can't be undone. Type \"%s\" to confirm:",
	["DidntUnderstandMessage"] = "   (?) Didn't understand \"%s\".",
	["EnchantedStatsHeader"] = "(Current value)",
	["EngineeringName"] = "Engineering",
	["ExportAllScalesMessage"] = "Press Ctrl+C to copy your scale tags, create a file on your computer to save them in for backup, and then press Ctrl+V to paste them.",
	["ExportScaleMessage"] = "Press Ctrl+C to copy the following scale tag for |cffffffff%s|r, and then press Ctrl+V to paste it later.",
	["FailedToGetItemLinkMessage"] = "   Failed to get item link from tooltip.  This may be due to a mod conflict.",
	["FailedToGetUnenchantedItemMessage"] = "   Failed to get base item values.  This may be due to a mod conflict.",
	["FoundStatMessage"] = "   %d %s",
	["GemList2"] = "%s or %s",
	["GemListMany"] = "(click the Pawn button for details)",
	["GenericGemLink"] = "|Hitem:%d|h[Gem %d]|h",
	["GenericGemName"] = "(Gem %d)",
	["HiddenScalesHeader"] = "Other scales",
	["ImportScaleMessage"] = "Press Ctrl+V to paste a scale tag that you've copied from another source here:",
	["ImportScaleTagErrorMessage"] = "Pawn doesn't understand that scale tag.  Did you copy the whole tag?  Try copying and pasting again:",
	["ItemIDTooltipLine"] = "Item ID",
	["ItemLevelTooltipLine"] = "Item Level",
	["LootUpgradeAdvisorHeader"] = "Click to compare with your items.|n",
	["LootUpgradeAdvisorHeaderMany"] = "|TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t This item is an upgrade for %d scales.  Click to compare with your items.",
	["MissocketWorthwhileMessage"] = "   -- But it's better to use only %s gems:",
	["NeedNewerVgerCoreMessage"] = "Pawn needs a newer version of VgerCore.  Please use the version of VgerCore that came with Pawn.",
	["NewScaleDuplicateName"] = "A scale with that name already exists.  Enter a name for your scale:",
	["NewScaleEnterName"] = "Enter a name for your scale:",
	["NewScaleNoQuotes"] = "A scale can't have \" in its name.  Enter a name for your scale:",
	["NormalizationMessage"] = "   -- Normalized by dividing by %g",
	["NoScale"] = "(none)",
	["NoScalesDescription"] = "To begin, import a scale or start a new one.",
	["NoStatDescription"] = "Choose a stat from the list on the left.",
	["Or"] = "or ",
	["RenameScaleEnterName"] = "Enter a new name for %s:",
	["SocketBonusValueCalculationMessage"] = "   -- Socket bonus would be worth: %g",
	["StatNameText"] = "1 |cffffffff%s|r is worth:",
	["ThousandsSeparator"] = ",",
	["TooltipBestAnnotation"] = "%s  |cff8ec3e6(best)|r",
	["TooltipBestAnnotationSimple"] = "%s  your best",
	["TooltipBigUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00 upgrade%s|r",
	["TooltipDowngradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00-%.0f%% downgrade%s|r",
	["TooltipRelicUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%d |4level:levels;%s|r",
	["TooltipSecondBestAnnotation"] = "%s  |cff8ec3e6(second best)|r",
	["TooltipSecondBestAnnotationSimple"] = "%s  your second best",
	["TooltipUpgradeAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% upgrade%s|r",
	["TooltipUpgradeFor1H"] = " for 1H set",
	["TooltipUpgradeFor2H"] = " for 2H",
	["TooltipUpgradeNeedsEnhancementsAnnotation"] = "%s  |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t|cff00ff00+%.0f%% upgrade potential%s|r",
	["TooltipVersusLine"] = "%s|n  vs. |c%s%s|r",
	["TotalValueMessage"] = "   ---- Total: %g",
	["UnenchantedStatsHeader"] = "(Base value)",
	["Unusable"] = "(unusable)",
	["UnusableStatMessage"] = "   -- %s is unusable, so stopping.",
	["Usage"] = [=[
Pawn by Vger-Azjol-Nerub
www.vgermods.com
 
/pawn -- show or hide the Pawn UI
/pawn debug [ on | off ] -- spam debug messages to the console
/pawn backup -- backup all of your scales to scale tags
/pawn compare [ left | right ] ItemID | ItemLink -- compare items
 
For more information on customizing Pawn, please see the help file (Readme.htm) that comes with the mod.
]=],
	["ValueCalculationMessage"] = "   %g %s x %g each = %g",
	["VisibleScalesHeader"] = "%s's scales",
	["Stats"] = {
		["AgilityInfo"] = "Agility.  Increases the power of some classes' abilities.",
		["ApInfo"] = "Attack Power.  Increases the damage of physical attacks.  Does not include attack power gained from strength and agility.",
		["ArcaneResistInfo"] = "Arcane Resistance.  Reduces the damage taken from arcane-based attacks.",
		["ArcaneSpellDamage"] = "Arcane Damage",
		["ArcaneSpellDamageInfo"] = "Arcane damage.  Increases the damage dealt by your arcane spells.",
		["ArmorInfo"] = "Armor.  Reduces incoming physical damage.",
		["ArmorPenetrationInfo"] = "Armor Penetration. Causes some of your physical attack damage to ignore armor.",
		["ArmorTypes"] = "Armor types",
		["AvoidanceInfo"] = "Avoidance.  Reduces the damage you take from area-of-effect attacks.",
		["BlockRatingInfo"] = "Block chance.  Increases the chances of a successful shield block.",
		["BlockValueInfo"] = "Shield block value.  Increases the damage that a shield absorbs when it successfully blocks.",
		["Cloth"] = "Cloth",
		["ClothInfo"] = "Points to be assigned if the item is cloth.",
		["CorruptionInfo"] = "Corruption of N'Zoth.  A negative value for Corruption will remove points from an item's score based on the level of corruption.",
		["Crit"] = "Crit",
		["CritInfo"] = "Critical strike.  Increases the chance that your attacks and healing spells will hit with increased potency.  (In WoW Classic, this only affects physical attacks.)",
		["DefenseInfo"] = "Defense skill.  Decreases the chance that you'll be hit by boss attacks.",
		["DodgeInfo"] = "Dodge.  Increases the chance that you'll dodge attacks entirely.",
		["DominationSocketInfo"] = "The value of a socket for an average Shard of Domination.",
		["DpsInfo"] = "Weapon damage per second.  (If you want to value DPS differently for different types of weapons, see the \"Special weapon stats\" section.)",
		["ExpertiseInfo"] = "Expertise. Negates your enemy's chances to dodge and parry.",
		["FeralApInfo"] = "Feral Attack Power.  Increases the damage of druid attacks when in feral forms.  Does not include attack power gained from strength and agility.",
		["FireResistInfo"] = "Fire Resistance.  Reduces the damage taken from fire-based attacks.",
		["FireSpellDamage"] = "Fire Damage",
		["FireSpellDamageInfo"] = "Fire damage.  Increases the damage dealt by your fire spells.",
		["FrostResistInfo"] = "Frost Resistance.  Reduces the damage taken from frost-based attacks.",
		["FrostSpellDamage"] = "Frost Damage",
		["FrostSpellDamageInfo"] = "Frost damage.  Increases the damage dealt by your frost spells.",
		["HasteInfo"] = "Haste.  Increases the speed at which your spells cast and resources regenerate.",
		["Healing"] = "Spell Healing",
		["HealingInfo"] = "Spell healing.  Increases the power of your healing spells.",
		["HitInfo"] = "Hit.  Increases the chance that your physical attacks hit the target, especially bosses.",
		["HolySpellDamage"] = "Holy Damage",
		["HolySpellDamageInfo"] = "Holy damage.  Increases the damage dealt by your holy spells.",
		["Hp5Info"] = "Health regeneration per 5 seconds.  Increases the rate at which you regenerate health.",
		["IndestructibleInfo"] = "Indestructible.  Prevents your equipment from taking durability damage.",
		["IndestructibleIs"] = "Being |cffffffffindestructible|r is worth:",
		["IntellectInfo"] = "Intellect.  Increases the power of some classes' abilities.",
		["Leather"] = "Leather",
		["LeatherInfo"] = "Points to be assigned if the item is leather.",
		["LeechInfo"] = "Leech.  Causes your attacks and healing spells to restore your health.",
		["Mail"] = "Mail",
		["MailInfo"] = "Points to be assigned if the item is mail.",
		["MasteryInfo"] = "Mastery.  Improves the unique bonus of your class specialization.",
		["MetaSocketEffectInfo"] = "Meta gem special effects. Points to be assigned for the non-stat portion of a meta gem (for example, \"Minor Run Speed Increase\" or \"1% Spell Reflect\").",
		["MinorStats"] = "Minor stats",
		["MovementSpeedInfo"] = "Movement speed.  Causes your character to run faster.",
		["Mp5"] = "Mana per 5",
		["Mp5Info"] = "Mana regeneration per 5 seconds.  Affects your mana regeneration even when in combat.",
		["NatureResistInfo"] = "Nature Resistance.  Reduces the damage taken from nature-based attacks.",
		["NatureSpellDamage"] = "Nature Damage",
		["NatureSpellDamageInfo"] = "Nature damage.  Increases the damage dealt by your nature spells.",
		["ParryInfo"] = "Parry.  Increases the chance that you'll parry enemy attacks.",
		["Plate"] = "Plate",
		["PlateInfo"] = "Points to be assigned if the item is plate.",
		["RapInfo"] = "Ranged Attack Power.  Increases the damage of ranged physical attacks.  Does not include attack power gained from agility.",
		["ResilienceInfo"] = "Resilience. Reduces the chance that you'll be critically hit, and decreases the damage of critical hits that you do take.",
		["ShadowResistInfo"] = "Shadow Resistance.  Reduces the damage taken from shadow-based attacks.",
		["ShadowSpellDamage"] = "Shadow Damage",
		["ShadowSpellDamageInfo"] = "Shadow damage.  Increases the damage dealt by your shadow spells.",
		["Shield"] = "Shield",
		["ShieldInfo"] = "Points to be assigned if the item is a shield.",
		["Sockets"] = "Sockets",
		["SpecialWeaponStats"] = "Special weapon stats",
		["SpeedBaseline"] = "Speed baseline",
		["SpeedBaselineInfo"] = "Not an actual stat that appears on weapons, this number is subtracted from the Speed stat before multiplying it by the scale value.",
		["SpeedBaselineIs"] = "|cffffffffSpeed baseline|r is:",
		["SpeedInfo"] = "Weapon speed, in seconds per swing.  (If you prefer fast weapons, this number should be negative.  See also: \"speed baseline\" in the \"Special weapon stats\" section.)",
		["SpeedIs"] = "1 second |cffffffffswing speed|r is worth:",
		["SpellCritInfo"] = "Spell critical strike.  Increases the chance that your spells will hit with increased potency.",
		["SpellDamage"] = "Spell Damage",
		["SpellDamageInfo"] = "Spell damage.  Increases the damage dealt by your offensive spells.",
		["SpellHitInfo"] = "Spell Hit.  Increases the chance that your damaging spells hit the target, especially bosses.",
		["SpellPenetrationInfo"] = "Spell Penetration. Negates an enemy's resistances to your spells.",
		["SpellPowerInfo"] = "Spell power.  Increases both damage and healing dealt by spells.",
		["SpiritInfo"] = "Spirit.  Affects your out-of-combat mana regeneration.",
		["StaminaInfo"] = "Stamina.  Increases your health.",
		["StrengthInfo"] = "Strength.  Increases the power of some classes' abilities.",
		["VersatilityInfo"] = "Versatility.  Increases damage dealt for damage characters, increases healing done by healing characters, and reduces damage taken for tank characters.",
		["WeaponMainHandDps"] = "MH: DPS",
		["WeaponMainHandDpsInfo"] = "Weapon damage per second, only for main hand weapons.",
		["WeaponMainHandMaxDamage"] = "MH: max damage",
		["WeaponMainHandMaxDamageInfo"] = "Weapon maximum damage, only for main hand weapons.",
		["WeaponMainHandMinDamage"] = "MH: min damage",
		["WeaponMainHandMinDamageInfo"] = "Weapon minimum damage, only for main hand weapons.",
		["WeaponMainHandSpeed"] = "MH: speed",
		["WeaponMainHandSpeedInfo"] = "Weapon speed, only for main hand weapons.",
		["WeaponMaxDamage"] = "Maximum damage",
		["WeaponMaxDamageInfo"] = "Weapon maximum damage.",
		["WeaponMeleeDps"] = "Melee: DPS",
		["WeaponMeleeDpsInfo"] = "Weapon damage per second, only for melee weapons.",
		["WeaponMeleeMaxDamage"] = "Melee: max damage",
		["WeaponMeleeMaxDamageInfo"] = "Weapon maximum damage, only for melee weapons.",
		["WeaponMeleeMinDamage"] = "Melee: min damage",
		["WeaponMeleeMinDamageInfo"] = "Weapon minimum damage, only for melee weapons.",
		["WeaponMeleeSpeed"] = "Melee: speed",
		["WeaponMeleeSpeedInfo"] = "Weapon speed, only for melee weapons.",
		["WeaponMinDamage"] = "Minimum damage",
		["WeaponMinDamageInfo"] = "Weapon minimum damage.",
		["WeaponOffHandDps"] = "OH: DPS",
		["WeaponOffHandDpsInfo"] = "Weapon damage per second, only for off-hand weapons.",
		["WeaponOffHandMaxDamage"] = "OH: max damage",
		["WeaponOffHandMaxDamageInfo"] = "Weapon maximum damage, only for off-hand weapons.",
		["WeaponOffHandMinDamage"] = "OH: min damage",
		["WeaponOffHandMinDamageInfo"] = "Weapon minimum damage, only for off-hand weapons.",
		["WeaponOffHandSpeed"] = "OH: speed",
		["WeaponOffHandSpeedInfo"] = "Weapon speed, only for off-hand weapons.",
		["WeaponOneHandDps"] = "1H: DPS",
		["WeaponOneHandDpsInfo"] = "Weapon damage per second, only for weapons marked One Hand, not including Main Hand or Off Hand weapons.",
		["WeaponOneHandMaxDamage"] = "1H: max damage",
		["WeaponOneHandMaxDamageInfo"] = "Weapon maximum damage, only for weapons marked One Hand, not including Main Hand or Off Hand weapons.",
		["WeaponOneHandMinDamage"] = "1H: min damage",
		["WeaponOneHandMinDamageInfo"] = "Weapon minimum damage, only for weapons marked One Hand, not including Main Hand or Off Hand weapons.",
		["WeaponOneHandSpeed"] = "1H: speed",
		["WeaponOneHandSpeedInfo"] = "Weapon speed, only for weapons marked One Hand, not including Main Hand or Off Hand weapons.",
		["WeaponRangedDps"] = "Ranged: DPS",
		["WeaponRangedDpsInfo"] = "Weapon damage per second, only for ranged weapons.",
		["WeaponRangedMaxDamage"] = "Ranged: max damage",
		["WeaponRangedMaxDamageInfo"] = "Weapon maximum damage, only for ranged weapons.",
		["WeaponRangedMinDamage"] = "Ranged: min damage",
		["WeaponRangedMinDamageInfo"] = "Weapon minimum damage, only for ranged weapons.",
		["WeaponRangedSpeed"] = "Ranged: speed",
		["WeaponRangedSpeedInfo"] = "Weapon speed, only for ranged weapons.",
		["WeaponStats"] = "Weapon stats",
		["WeaponTwoHandDps"] = "2H: DPS",
		["WeaponTwoHandDpsInfo"] = "Weapon damage per second, only for two-handed weapons.",
		["WeaponTwoHandMaxDamage"] = "2H: max damage",
		["WeaponTwoHandMaxDamageInfo"] = "Weapon maximum damage, only for two-handed weapons.",
		["WeaponTwoHandMinDamage"] = "2H: min damage",
		["WeaponTwoHandMinDamageInfo"] = "Weapon minimum damage, only for two-handed weapons.",
		["WeaponTwoHandSpeed"] = "2H: speed",
		["WeaponTwoHandSpeedInfo"] = "Weapon speed, only for two-handed weapons.",
		["WeaponType1HAxe"] = "Axe: 1H",
		["WeaponType1HAxeInfo"] = "Points to be assigned if the item is a one-handed axe.",
		["WeaponType1HMace"] = "Mace: 1H",
		["WeaponType1HMaceInfo"] = "Points to be assigned if the item is a one-handed mace.",
		["WeaponType1HSword"] = "Sword: 1H",
		["WeaponType1HSwordInfo"] = "Points to be assigned if the item is a one-handed sword.",
		["WeaponType2HAxe"] = "Axe: 2H",
		["WeaponType2HAxeInfo"] = "Points to be assigned if the item is a two-handed axe.",
		["WeaponType2HMace"] = "Mace: 2H",
		["WeaponType2HMaceInfo"] = "Points to be assigned if the item is a two-handed mace.",
		["WeaponType2HSword"] = "Sword: 2H",
		["WeaponType2HSwordInfo"] = "Points to be assigned if the item is a two-handed sword.",
		["WeaponTypeBow"] = "Bow",
		["WeaponTypeBowInfo"] = "Points to be assigned if the item is a bow.",
		["WeaponTypeCrossbow"] = "Crossbow",
		["WeaponTypeCrossbowInfo"] = "Points to be assigned if the item is a crossbow.",
		["WeaponTypeDagger"] = "Dagger",
		["WeaponTypeDaggerInfo"] = "Points to be assigned if the item is a dagger.",
		["WeaponTypeFistWeapon"] = "Fist weapon",
		["WeaponTypeFistWeaponInfo"] = "Points to be assigned if the item is a fist weapon.",
		["WeaponTypeFrill"] = "Off-hand frill",
		["WeaponTypeFrillInfo"] = "Points to be assigned if the item is a \"held in off hand\" caster off-hand item.  Does not apply to shields or weapons.",
		["WeaponTypeGun"] = "Gun",
		["WeaponTypeGunInfo"] = "Points to be assigned if the item is a gun.",
		["WeaponTypeOffHand"] = "Off-hand weapon",
		["WeaponTypeOffHandInfo"] = "Points to be assigned if the item is any weapon that can only be held in the off-hand.  Does not apply to off-hand \"frill\" (caster) items, shields, or weapons that can be held in either hand.",
		["WeaponTypePolearm"] = "Polearm",
		["WeaponTypePolearmInfo"] = "Points to be assigned if the item is a polearm.",
		["WeaponTypes"] = "Weapon types",
		["WeaponTypeStaff"] = "Staff",
		["WeaponTypeStaffInfo"] = "Points to be assigned if the item is a staff.",
		["WeaponTypeThrown"] = "Thrown weapon",
		["WeaponTypeThrownInfo"] = "Points to be assigned if the item is a thrown weapon.",
		["WeaponTypeWand"] = "Wand",
		["WeaponTypeWandInfo"] = "Points to be assigned if the item is a wand.",
		["WeaponTypeWarglaive"] = "Warglaive",
		["WeaponTypeWarglaiveInfo"] = "Points to be assigned if the item is a warglaive.",
	},
	["UI"] = {
		["AboutHeader"] = "About Pawn",
		["AboutMrRobot"] = "Default stat weights are provided by the generous Mr. Robot.  They’re a great starting point for characters with typical talents and gear in typical fights.  You can get more accurate, customized stat weights for your character using the Ask Mr. Robot simulator at askmrrobot.com.",
		["AboutReadme"] = "New to Pawn?  See the getting started tab for a basic introduction.",
		["AboutTab"] = "About",
		["AboutTranslation"] = "Official English version",
		["AboutVersion"] = "Version %s",
		["AboutWebsite"] = "For other mods by Vger, visit vgermods.com.",
		["AskMrRobotProvider"] = "Ask Mr. Robot scales",
		["CompareClearItems"] = "Clear",
		["CompareClearItemsTooltip"] = "Remove both comparison items.",
		["CompareColoredSockets"] = "Sockets",
		["CompareEquipped"] = "Equipped",
		["CompareGemTotalValue"] = "Value of gems",
		["CompareHeader"] = "Compare items for %s",
		["CompareOtherHeader"] = "Other",
		["CompareSlotEmpty"] = "(no item)",
		["CompareSocketBonus"] = "Socket bonus",
		["CompareSocketsHeader"] = "Sockets",
		["CompareSpecialEffects"] = "Special effects",
		["CompareSwap"] = "‹ Swap ›",
		["CompareSwapTooltip"] = "Swap the item on the left side with the one on the right.",
		["CompareTab"] = "Compare",
		["CompareVersus"] = "—vs.—",
		["CompareWelcomeRight"] = [=[Drop an item in this box.

You can compare it versus what you already have using the icons in the lower-left corner, or you can drop a different item in the box on the left.]=],
		["CompareYourBest"] = "Your best",
		["GemsColorHeader"] = "%s gems",
		["GemsHeader"] = "Gems for %s",
		["GemsNoneFound"] = "No appropriate gems were found.",
		["GemsQualityLevel"] = "Gem quality level",
		["GemsQualityLevelTooltip"] = [=[The level of items for which to suggest gems.

For example, if it's "175", then Pawn will show gems that are appropriate for use in items of level 175.  If you click the Pawn button in the socketing window, Pawn will fill this in for you automatically.]=],
		["GemsShowBest"] = "Show the best gems available",
		["GemsShowBestTooltip"] = "Shows the absolute best gems that are available for the scale that is currently selected.  Some of these gems will be too powerful to socket into older and lower-quality items.",
		["GemsShowForItemLevel"] = "Show the gems recommended for an item of level:",
		["GemsShowForItemLevelTooltip"] = "Shows the gems that Pawn recommends for the scale that is currently selected and an item of a specific level.",
		["GemsTab"] = "Gems",
		["GemsWelcome"] = "Pawn recommends these gems for your socketed items.",
		["HelpHeader"] = "Welcome to Pawn!",
		["HelpTab"] = "Getting started",
		["HelpText"] = [=[Pawn helps you find your best gear and identify upgrades that you come across.


When you earn quest rewards or dungeon loot that may be better than your current equipment, Pawn will let you know with a green arrow icon.

    |cff8ec3e6Fire:|r  |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% upgrade|r



|cff8ec3e6Try out these features once you get used to the basics:|r

 • Compare the stats of two items by using Pawn's Compare tab.
 • Right-click on an item link popup to see how it compares to your current item.
 • On the Scale tab, switch to Manual mode to show suggestions for more than one spec at a time.
 • Use the Ask Mr. Robot simulator and build a custom scale for your character to get customized advice.]=],
		["InterfaceOptionsBody"] = "Click the Pawn button to go there.  You can also open Pawn from your inventory page, or by binding a key to it.",
		["InterfaceOptionsWelcome"] = "Pawn options are found in the Pawn UI.",
		["InventoryButtonTooltip"] = "Click to open Pawn.",
		["InventoryButtonTotalsHeader"] = "Totals for all equipped items:",
		["KeyBindingCompareItemLeft"] = "Compare item (left)",
		["KeyBindingCompareItemRight"] = "Compare item (right)",
		["KeyBindingShowUI"] = "Toggle Pawn UI",
		["OptionsAdvisorHeader"] = "Advisor options",
		["OptionsAlignRight"] = "Align values to right edge of tooltip",
		["OptionsAlignRightTooltip"] = "Enable this option to align your Pawn values and upgrade information to the right edge of the tooltip instead of the left.",
		["OptionsBagUpgradeAdvisor"] = "Show bag upgrade advisor",
		["OptionsBagUpgradeAdvisorTooltip"] = [=[Enable this option to have Pawn take over the in-bag upgrade arrows.

If checked, Pawn will find upgrades in your bags and mark items that are an upgrade for any of your active scales with green arrows. 

If unchecked, WoW will mark items with a higher item level than what you're currently wearing, and Pawn will not interfere with the built-in feature.]=],
		["OptionsBlankLine"] = "Add a blank line before values",
		["OptionsBlankLineTooltip"] = "Keep your item tooltips extra tidy by enabling this option, which adds a blank line before the Pawn values.",
		["OptionsButtonHidden"] = "Hide it",
		["OptionsButtonHiddenTooltip"] = "Don't show the Pawn button on the Character Info panel.",
		["OptionsButtonPosition"] = "Show the Pawn button:",
		["OptionsButtonPositionLeft"] = "On the left",
		["OptionsButtonPositionLeftTooltip"] = "Show the Pawn button in the lower-left corner of the Character Info panel.",
		["OptionsButtonPositionRight"] = "On the right",
		["OptionsButtonPositionRightTooltip"] = "Show the Pawn button in the lower-right corner of the Character Info panel.",
		["OptionsColorBorder"] = "Color tooltip border of upgrades",
		["OptionsColorBorderTooltip"] = "Enable this option to change the color of the tooltip border of items that are upgrades to green.  Disable this option if it interferes with other mods that change tooltip borders.",
		["OptionsCurrentValue"] = "Show both current and base values",
		["OptionsCurrentValueTooltip"] = [=[Enable this option to have Pawn show two values for items: the current value, which reflects the current state of an item with the actual gems and enchantments that the item has at the moment, with empty sockets providing no benefit, and the base value, which is what Pawn normally displays.  This option has no effect unless you turn on item value display on tooltips.

You should still use the base value for determining between two items at endgame, but the current value can be helpful when leveling and to make it easier to decide whether it's worth immediately equipping a new item before it has gems or enchantments.]=],
		["OptionsDebug"] = "Show debug info",
		["OptionsDebugTooltip"] = [=[If you're not sure how Pawn is calculating the values for a particular item, enable this option to make Pawn spam all sorts of 'useful' data to the chat console whenever you hover over an item.  This information includes which stats Pawn thinks the item has, which parts of the item Pawn doesn't understand, and how it took each one into account for each of your scales.

This option will fill up your chat log quickly, so you'll want to turn it off once you're finished investigating.

Shortcuts:
/pawn debug on
/pawn debug off]=],
		["OptionsHeader"] = "Adjust Pawn options",
		["OptionsIgnoreGemsWhileLevelingCheck"] = "Ignore sockets on low-level items",
		["OptionsIgnoreGemsWhileLevelingCheckTooltip"] = [=[Enable this option to have Pawn ignore sockets on low-level items when calculating item values, since most people do not go to the effort or expense of socketing items while still leveling.  A "low-level" item is one weaker than what can be obtained in a heroic dungeon at the level cap.

If checked, Pawn's socketing advisor will still suggest appropriate gems for low-level items, but sockets will be ignored in calculations and socketed items will not show up as upgrades as often.

If unchecked, Pawn will calculate values for items as if they were socketed in the way that maximizes the item's value, regardless of the item's level.]=],
		["OptionsIgnoreItemUpgradesCheck"] = "Ignore valor and baleful upgrades",
		["OptionsIgnoreItemUpgradesCheckTooltip"] = [=[Enable this option to have Pawn ignore the potential for Valor upgrades and Empowered Baleful items when calculating item values.

If checked, Pawn will treat upgradeable items as they are and will not assume that you would use Valor and Empowered Apexis Fragments to improve the item when determining whether an item is better than what you currently have.

If unchecked, Pawn will treat those items assuming that you would maximize their potential with Valor and Empowered Apexis Fragments.  This could cause a level 650 baleful item to appear as a significant upgrade over a level 670 item from Blackrock Foundry, since the baleful item could potentially be improved to level 705 through valor and Apexis.]=],
		["OptionsInventoryIcon"] = "Show icons next to tooltips",
		["OptionsInventoryIconTooltip"] = "Enable this option to show inventory icons next to item link windows.",
		["OptionsItemIDs"] = "Show item IDs",
		["OptionsItemIDsTooltip"] = [=[Enable this option to have Pawn display the item ID of every item you come across, as well as the IDs of all enchantments and gems.

Every item in World of Warcraft has an ID number associated with it.  This information is generally only useful to mod authors.]=],
		["OptionsLootAdvisor"] = "Show loot upgrade advisor",
		["OptionsLootAdvisorTooltip"] = "When loot drops in a dungeon and it's an upgrade for your character, Pawn will show a popup attached to the loot roll box telling you about the upgrade.",
		["OptionsOtherHeader"] = "Other options",
		["OptionsQuestUpgradeAdvisor"] = "Show quest upgrade advisor",
		["OptionsQuestUpgradeAdvisorTooltip"] = "In your quest log and when talking to NPCs, if one of the quest reward choices is an upgrade for your current gear, Pawn will show a green arrow icon on that item.  If none of the items is an upgrade, Pawn will show a pile of coins on the item that is worth the most when sold to a vendor.",
		["OptionsResetUpgrades"] = "Re-scan gear",
		["OptionsResetUpgradesTooltip"] = [=[Pawn will forget what it knows about the best items you've ever equipped and re-scan your gear in order to provide more up-to-date upgrade information in the future.

Use this feature if you find that Pawn is making poor upgrade suggestions as a result of items that you've vendored, destroyed, or otherwise do not use anymore.  This will affect all of your characters that use Pawn.]=],
		["OptionsReforgingAdvisor"] = "Show reforging advisor",
		["OptionsReforgingAdvisorTooltip"] = "When visiting an arcane reforger, Pawn will show you how to maximize the item's power.",
		["OptionsShowItemLevelUpgrades"] = "Show item level upgrades",
		["OptionsShowItemLevelUpgradesTooltip"] = "Pawn will show you items that are of a higher item level than what you've previously equipped in that slot in addition to normal upgrades.",
		["OptionsShowRelicUpgrades"] = "Show relic upgrades",
		["OptionsShowRelicUpgradesTooltip"] = "Pawn will show you when a relic would increase the item level of one of your artifact weapons.  (This works differently from other upgrade features, since it's based on item level, not stats.)",
		["OptionsSocketingAdvisor"] = "Show socketing advisor",
		["OptionsSocketingAdvisorTooltip"] = "When adding gems to an item, Pawn will show a popup suggesting gems that you can add to the item that will maximize its power.  (To see the full list of gem suggestions for each color, see the Gems tab, where you can also customize the quality of gems to use.)",
		["OptionsTab"] = "Options",
		["OptionsTooltipHeader"] = "Tooltip options",
		["OptionsTooltipSpecIcon"] = "Show spec icons",
		["OptionsTooltipSpecIconTooltip"] = "Enable this option to show spec icons next to scale names on tooltips.",
		["OptionsTooltipUpgradesOnly"] = "Only show upgrades",
		["OptionsTooltipUpgradesOnlyTooltip"] = [=[This is the simplest option.  Only show upgrade percentages for items that are an upgrade to your current gear, and indicate which items are the best items you own for each scale.  Don't show anything at all for lesser items.

|cff8ec3e6Fire:|r  |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% upgrade|r

...or...

|cff8ec3e6Fire:  your best|r]=],
		["OptionsTooltipValuesAndUpgrades"] = "Show scale values and upgrade %",
		["OptionsTooltipValuesAndUpgradesTooltip"] = [=[Show Pawn values for all of your visible scales on all items, except those that have a value of zero.  In addition, indicate which items are an upgrade to your current gear.

|cff8ec3e6Frost:  123.4
Fire:  156.7 |TInterface\AddOns\Pawn\Textures\UpgradeArrow:0|t |cff00ff00+10% upgrade|r]=],
		["OptionsTooltipValuesOnly"] = "Show only scale values, no upgrade %",
		["OptionsTooltipValuesOnlyTooltip"] = [=[Show Pawn values for all of your visible scales on all items, except those that have a value of zero.  Don't indicate which items are an upgrade to your current gear.  This option reflects the default behavior of older versions of Pawn.

|cff8ec3e6Frost:  123.4
Fire:  156.7|r]=],
		["OptionsUpgradeHeader"] = "Show |TInterface\\AddOns\\Pawn\\Textures\\UpgradeArrow:0|t upgrades on tooltips:",
		["OptionsUpgradeSettingsHeader"] = "Upgrade options",
		["OptionsUpgradesForBothWeaponTypes"] = "Show upgrades for both 1H and 2H",
		["OptionsUpgradesForBothWeaponTypesTooltip"] = [=[Pawn's upgrade advisors should track and show upgrades for your two-handed weapons and your dual-wield (or for casters, main hand and off-hand frill) weapon sets separately.

If checked, you could be using a two-handed weapon and still see clearly inferior one-handed weapons as upgrades if they're better than the previous best (or second-best) one-handed weapon you had, because Pawn is tracking upgrades separately for the two weapon sets.

If unchecked, equipping a two-handed weapon will prevent Pawn from showing you upgrades for one-handed items and vice-versa.]=],
		["OptionsUpgradeTrackingHeader"] = "Upgrade comparisons:",
		["OptionsUpgradeTrackingOff"] = "Versus equipped gear (recommended)",
		["OptionsUpgradeTrackingOffTooltip"] = "Pawn will show you items that are an upgrade compared to the items that you currently have equipped.",
		["OptionsUpgradeTrackingOn"] = "Track for each scale (advanced)",
		["OptionsUpgradeTrackingOnTooltip"] = "(For advanced users.)  Pawn will try to track the best items that you've equipped, independently for each scale that you have enabled, and show you items that are an upgrade compared to those.",
		["OptionsWelcome"] = "Configure Pawn the way you like it.  Changes will take effect immediately.",
		["ReforgeTitle"] = "Pawn Reforging Advisor suggests:",
		["ReforgeInstructionsNoReforge"] = "Do not reforge",
		["ReforgeInstructions"] = "Reforge %s into %s",
		["ReforgeCappedStatWarning"] = "Use care when reforging Hit or Expertise, and don't reforge stats you need.",
		["ScaleAutoOff"] = "Manual",
		["ScaleAutoOff2"] = "Let me manage scales.",
		["ScaleAutoOffTooltip"] = "Pawn will let you manually choose which scales to use for its calculations, allowing you to enable more than one scale at a time, add custom scales, and more.",
		["ScaleAutoOn"] = "Automatic",
		["ScaleAutoOn2"] = "Just show my current spec.",
		["ScaleAutoOnTooltip"] = "Pawn will automatically show your current specialization in item tooltips, and use that to make recommendations and suggest upgrades.",
		["ScaleAutoWelcome"] = [=[Pawn will show suggestions for your current specialization.

If you'd rather manage things on your own, just click Manual below.]=],
		["ScaleChangeColor"] = "Change color",
		["ScaleChangeColorTooltip"] = "Change the color that this scale's name and value appear in on item tooltips.",
		["ScaleCopy"] = "Copy",
		["ScaleCopyTooltip"] = "Create a new scale by making a copy of this one.",
		["ScaleDefaults"] = "Template",
		["ScaleDefaultsTooltip"] = "Create a new scale from a template for your class or spec.",
		["ScaleDeleteTooltip"] = [=[Delete this scale.

This command cannot be undone!]=],
		["ScaleEmpty"] = "Empty",
		["ScaleEmptyTooltip"] = "Create a new scale from scratch.",
		["ScaleExport"] = "Export",
		["ScaleExportTooltip"] = "Share your scale with others on the internet.",
		["ScaleHeader"] = "Manage your Pawn scales",
		["ScaleImport"] = "Import",
		["ScaleImportTooltip"] = "Add a new scale by pasting a scale tag from the internet.",
		["ScaleNewHeader"] = "Create a new scale",
		["ScaleRename"] = "Rename",
		["ScaleRenameTooltip"] = "Rename this scale.",
		["ScaleSelectorHeader"] = "Select a scale:",
		["ScaleSelectorNoneWarning"] = "Shift-click at least one for advice.",
		["ScaleSelectorShowingSuggestionsFor"] = "Showing suggestions for",
		["ScaleSelectorShowScale"] = "Show this scale in tooltips",
		["ScaleSelectorShowScaleTooltip"] = [=[Enable this option to show this scale in item tooltips and have Pawn use it to suggest upgrades.  You can have more than one scale enabled on each character.

Shortcut: Shift+click a scale]=],
		["ScaleShareHeader"] = "Share your scales",
		["ScaleTab"] = "Scale",
		["ScaleTypeNormal"] = "You can change this scale on the Values tab.",
		["ScaleTypeReadOnly"] = "If you want to customize this scale, first make a copy.",
		["ScaleWelcome"] = "Scales give point values to stats so Pawn can tell you which of two items is better for a certain spec or situation.",
		["SocketingAdvisorButtonTooltip"] = "Click to open Pawn's Gems tab, where you can see more information about the gems that Pawn recommends.",
		["SocketingAdvisorHeader"] = "Pawn Socketing Advisor suggests:",
		["SocketingAdvisorIgnoreThisItem"] = "Don't bother adding gems to this low-level item.  But if you do, use these:",
		["StarterProvider"] = "Starter scales",
		["ValuesDoNotShowUpgradesFor1H"] = "Don't show upgrades for 1H items",
		["ValuesDoNotShowUpgradesFor2H"] = "Don't show upgrades for 2H items",
		["ValuesDoNotShowUpgradesTooltip"] = "Enable this option to hide upgrades of this type of item.  For example, even though paladin tanks can use two-handed weapons, a two-handed weapon is never an \"upgrade\" for a paladin tanking set, so Pawn should not show upgrade notifications for them.  Similarly, retribution paladins can use one-handed weapons, but they are never upgrades.",
		["ValuesHeader"] = "Stat weights for %s",
		["ValuesIgnoreItemType"] = "These items are unusable",
		["ValuesIgnoreStat"] = "Items with this are unusable",
		["ValuesIgnoreStatTooltip"] = "Enable this option to cause any item of this type or with this stat to be ignored entirely for this scale.  For example, shamans can't wear plate, so a scale designed for a shaman can mark plate as unusable so that plate armor is never considered an upgrade.",
		["ValuesNormalize"] = "Normalize values (like Wowhead)",
		["ValuesNormalizeTooltip"] = [=[Enable this option to divide the final calculated value for an item by the sum of all stat values in your scale, like Wowhead and Lootzor do.  This helps to even out situations like where one scale has stat values around 1 and another has values around 5.  It also helps to keep numbers manageably small.

For more information on this setting, see the readme file.]=],
		["ValuesRemove"] = "Remove",
		["ValuesRemoveTooltip"] = "Remove this stat from the scale.",
		["ValuesTab"] = "Weights",
		["ValuesWelcome"] = "You can customize the weights that are assigned to each stat for this scale.  To manage your scales and add new ones, use Manual mode on the Scale tab.",
		["ValuesWelcomeNoScales"] = "You have no scale selected.  To get started, go to the Scale tab and start a new scale or paste one from the internet.",
		["ValuesWelcomeReadOnly"] = "This built-in scale can't be changed.  If you'd like to customize these weights, go to the Scale tab, enable Manual mode, and make a copy of this scale.",
	}
}

PawnLocal.TooltipParsing = {
	["Agility"] = "^%+?# Agility$",
	["AllStats"] = "^%+?# [Aa]ll [Ss]tats$",
	["Ap"] = "^%+?# Attack Power$",
	["Ap2"] = "^Equip: %+# Attack Power%.$",
	["Ap3"] = "^Equip: Increases attack power by #%.$",
	["ArcaneResist"] = "^%+?# Arcane Resistance$",
	["ArcaneSpellDamage"] = "^%+# Arcane Spell Damage$",
	["ArcaneSpellDamage2"] = "^Equip: Increases damage done by Arcane spells and effects by up to #%.$",
	["ArcaneSpellDamage3"] = "^%+# Arcane Damage$",
	["Armor"] = "^%+?# Armor$",
	["Armor2"] = "^UNUSED$",
	["ArmorPenetration"] = "^Equip: Your attacks ignore # of your opponent's armor%.$",
	["ArmorPenetrationRating"] = "^Equip: Increases armor penetration rating by #%.$",
	["ArmorPenetrationRating2"] = "^Equip: Increases your armor penetration by #%.$",
	["ArmorPenetrationShort"] = "^%+?# Armor Penetration Rating$",
	["Avoidance"] = "^%+# Avoidance$",
	["Axe"] = "^Axe$",
	["BagSlots"] = "^%d+ Slot .+$",
	["Block"] = "^%+?# Block$",
	["BlockPercent"] = "^Equip: Increases your chance to block attacks with a shield by #%%%.$",
	["BlockRating"] = "^Equip: Increases your block rating by #%.$",
	["BlockRating2"] = "^Equip: Increases your shield block rating by #%.$",
	["BlockValue"] = "^Equip: Increases the block value of your shield by #%.$",
	["Bow"] = "^Bow$",
	["ChanceOnHit"] = "Chance on hit:",
	["Charges"] = "^.+ Charges?$",
	["Cloth"] = "^Cloth$",
	["CooldownRemaining"] = "^Cooldown remaining:",
	["Corruption"] = "^%+?# Corruption$",
	["Crit"] = "^%+?# Critical [Ss]trike%.?$",
	["Crit2"] = "^UNUSED$",
	["CritPercent"] = "^Equip: Improves your chance to get a critical strike by #%%%.$",
	["CritPercentCombined"] = "^Equip: Improves your chance to get a critical strike with all spells and attacks by #%%%.$",
	["CritRating"] = "^Equip: Increases your critical strike rating by #%.$",
	["CritRating2"] = "^Equip: Improves critical strike rating by #%.$",
	["CritRating3"] = "^UNUSED$",
	["CritRatingShort"] = "^%+?# Critical Strike Rating$",
	["Crossbow"] = "^Crossbow$",
	["Dagger"] = "^Dagger$",
	["DefenseRating"] = "^Equip: Increases defense rating by #%.$",
	["DefenseRating2"] = "^UNUSED$",
	["DefenseRatingSimple"] = "^%+?# Defense Rating$",
	["DefenseSkill"] = "^Equip: Increased Defense %+#%.$",
	["DefenseSkillSimple"] = "^%+?# Defense$",
	["DisenchantingRequires"] = "^Disenchanting requires",
	["Dodge"] = "^%+?#%%? Dodge$",
	["Dodge2"] = "^UNUSED$",
	["Dodge3"] = "^UNUSED$",
	["DodgePercent"] = "^Equip: Increases your chance to dodge an attack by #%%%.$",
	["DodgeRating"] = "^Equip: Increases your dodge rating by #%.$",
	["DodgeRating2"] = "^UNUSED$",
	["DodgeRatingShort"] = "^%+?#%%? Dodge Rating$",
	["Dps"] = "^%(# damage per second%)$",
	["DpsAdd"] = "^Adds # damage per second$",
	["Duration"] = "^Duration:",
	["Elite"] = "^Elite$",
	["EnchantmentArmorKit"] = "^Reinforced %(%+# Armor%)$",
	["EnchantmentCounterweight"] = "^Counterweight %(%+# Haste%)",
	["EnchantmentFieryWeapon"] = "^Fiery Weapon$",
	["EnchantmentHealth"] = "^%+# HP$",
	["EnchantmentHealth2"] = "^%+# Health$",
	["EnchantmentLivingSteelWeaponChain"] = "^Living Steel Weapon Chain$",
	["EnchantmentPyriumWeaponChain"] = "^Pyrium Weapon Chain$",
	["EnchantmentTitaniumWeaponChain"] = "^Titanium Weapon Chain$",
	["Equip"] = "Equip:",
	["ExpertiseRating"] = "^Equip: Increases your expertise rating by #%.$",
	["ExpertiseRatingShort"] = "^%+?# Expertise Rating$",
	["FeralAp"] = "^Equip: %+# Attack Power in Cat, Bear, and Dire Bear forms only%.$",
	["FeralApMoonkin"] = "^Equip: Increases attack power by # in Cat, Bear, Dire Bear, and Moonkin forms only%.$",
	["FeralApWrath"] = "^Increases attack power by # in Cat, Bear, Dire Bear, and Moonkin forms only%.$",
	["FireResist"] = "^%+?# Fire Resistance$",
	["FireSpellDamage"] = "^%+# Fire Spell Damage$",
	["FireSpellDamage2"] = "^Equip: Increases damage done by Fire spells and effects by up to #%.$",
	["FireSpellDamage3"] = "^%+# Fire Damage$",
	["FistWeapon"] = "^Fist Weapon$",
	["Flexible"] = "^Flexible$",
	["FrostResist"] = "^%+?# Frost Resistance$",
	["FrostSpellDamage"] = "^%+# Frost Spell Damage$",
	["FrostSpellDamage2"] = "^Equip: Increases damage done by Frost spells and effects by up to #%.$",
	["FrostSpellDamage3"] = "^%+# Frost Damage$",
	["Gun"] = "^Gun$",
	["Haste"] = "^%+?# Haste$",
	["Haste2"] = "^UNUSED$",
	["HasteRating"] = "^Equip: Improves haste rating by #%.$",
	["HasteRating2"] = "^UNUSED$",
	["HasteRatingShort"] = "^%+?# Haste Rating$",
	["HaventCollectedAppearance"] = "^You haven't collected this appearance$",
	["Healing"] = "^%+# Healing Spells$",
	["Healing2"] = "^Equip: Increases healing done by spells and effects by up to #%.$",
	["Healing3"] = "^%+# Healing$",
	["HeirloomLevelRange"] = "^Requires level %d+ to (%d+)",
	["HeirloomXpBoost"] = "^Equip: Experience gained",
	["HeirloomXpBoost2"] = "^UNUSED$",
	["Heroic"] = "^Heroic$",
	["HeroicElite"] = "^Heroic Elite$",
	["HeroicThunderforged"] = "^Heroic Thunderforged$",
	["HeroicWarforged"] = "^Heroic Warforged$",
	["Hit"] = "^Equip: Improves your chance to hit by #%%%.$",
	["Hit2"] = "^UNUSED$",
	["HitPercentCombined"] = "^Equip: Improves your chance to hit with all spells and attacks by #%%%.$",
	["HitRating"] = "^Equip: Improves hit rating by #%.$",
	["HitRating2"] = "^Equip: Increases your hit rating by #%.$",
	["HitRating3"] = "^UNUSED$",
	["HitRatingShort"] = "^%+?# Hit Rating$",
	["HolySpellDamage"] = "^%+# Holy Spell Damage$",
	["HolySpellDamage2"] = "^Equip: Increases damage done by Holy spells and effects by up to #%.$",
	["HolySpellDamage3"] = "^Equip: Increases the damage done by Holy spells and effects by up to #%.$",
	["Hp5"] = "^Equip: Restores # health every 5 sec%.$",
	["Hp52"] = "^Equip: Restores # health per 5 sec%.$",
	["Hp53"] = "^Restores %+?# [hH]ealth [pP]er 5 [sS]ec%.?$",
	["Hp54"] = "^UNUSED$",
	["Hp55"] = "^%+?# Health per 5 sec%.$",
	["Intellect"] = "^%+?# Intellect$",
	["Leather"] = "^Leather$",
	["Leech"] = "^%+# Leech$",
	["Mace"] = "^Mace$",
	["Mail"] = "^Mail$",
	["Mastery"] = "^%+?# Mastery$",
	["Mastery2"] = "^UNUSED$",
	["MetaGemRequirements"] = "|cff%x%x%x%x%x%xRequires",
	["MovementSpeed"] = "^%+# Speed$",
	["Mp5"] = "^Equip: Restores # mana per 5 sec%.$",
	["Mp52"] = "^%+?# mana every 5 sec%.$",
	["Mp53"] = "^%+?# [Mm]ana [Pp]er 5 sec%.$",
	["Mp54"] = "^%+?# Mana every 5 seconds$",
	["Mp55"] = "^UNUSED$",
	["MultiStatHeading"] = "^Multiple Stats$",
	["MultiStatSeparator1"] = "and",
	["Multistrike"] = "^%+# Multistrike$",
	["NatureResist"] = "^%+?# Nature Resistance$",
	["NatureSpellDamage"] = "^%+# Nature Spell Damage$",
	["NatureSpellDamage2"] = "^Equip: Increases damage done by Nature spells and effects by up to #%.$",
	["NatureSpellDamage3"] = "^%+# Nature Damage$",
	["NormalizationEnchant"] = "^Enchanted: (.*)$",
	["NormalizationReforge"] = "",
	["Parry"] = "^%+?# Parry$",
	["Parry2"] = "^UNUSED$",
	["ParryPercent"] = "^Equip: Increases your chance to parry an attack by #%%%.$",
	["ParryRating"] = "^Equip: Increases your parry rating by #%.$",
	["ParryRatingShort"] = "^%+?# Parry Rating$",
	["Plate"] = "^Plate$",
	["Polearm"] = "^Polearm$",
	["PvPPower"] = "^%+?# PvP Power$",
	["RaidFinder"] = "^Raid Finder$",
	["Rap"] = "^Equip: %+# ranged Attack Power%.$",
	["Rap2"] = "^Equip: Increases ranged attack power by #%.$",
	["Requires2"] = "^UNUSED$",
	["Resilience"] = "^%+?# PvP Resilience$",
	["Resilience2"] = "^UNUSED$",
	["ResilienceRating"] = "^Equip: Improves your resilience rating by #%.$",
	["ResilienceRatingShort"] = "^%+?# Resilience Rating$",
	["Scope"] = "^Scope %(%+# Damage%)$",
	["ScopeCrit"] = "^Scope %(%+# Critical Strike%)$",
	["ScopeRangedCrit"] = "^%+?# Ranged Critical Strike$",
	["ShadowResist"] = "^%+?# Shadow Resistance$",
	["ShadowSpellDamage"] = "^%+# Shadow Spell Damage$",
	["ShadowSpellDamage2"] = "^Equip: Increases damage done by Shadow spells and effects by up to #%.$",
	["ShadowSpellDamage3"] = "^UNUSED$",
	["ShadowSpellDamage4"] = "^%+# Shadow Damage$",
	["Shield"] = "^Shield$",
	["SocketBonusPrefix"] = "Socket Bonus: ",
	["Speed"] = "^Speed #$",
	["Speed2"] = "^UNUSED$",
	["SpellCrit"] = "^Equip: Improves your chance to get a critical strike with spells by #%%%.$",
	["SpellCritRating"] = "^Equip: Increases your spell critical strike rating by #%.$",
	["SpellCritRating2"] = "^Equip: Improves spell critical strike rating by #%.$",
	["SpellCritRatingShort"] = "^%+?# Spell Critical Rating$",
	["SpellCritRatingShort2"] = "^%+?# Spell Critical Strike Rating$",
	["SpellDamage"] = "^%+# Damage and Healing Spells$",
	["SpellDamage2"] = "^Equip: Increases damage and healing done by magical spells and effects by up to #%.$",
	["SpellDamage3"] = "^%+# Healing and Spell Damage$",
	["SpellDamage4"] = "^%+# Spell Damage$",
	["SpellDamage5"] = "^UNUSED$",
	["SpellDamage6"] = "^UNUSED$",
	["SpellDamageAndHealing"] = "^Equip: Increases healing done by up to # and damage done by up to # for all magical spells and effects%.$",
	["SpellDamageAndHealing2"] = "^UNUSED$",
	["SpellDamageAndHealingEnchant"] = "^%+# Healing and %+# Spell Damage$",
	["SpellDamageAndHealingShort"] = "^%+# Healing Spells and %+# Damage Spells$",
	["SpellDamageAndHealingShort2"] = "^%+# Healing %+# Spell Damage$",
	["SpellHasteRating"] = "^Equip: Improves spell haste rating by #%.$",
	["SpellHasteRatingShort"] = "^%+?# Spell Haste Rating$",
	["SpellHit"] = "^Equip: Improves your chance to hit with spells by #%%%.$",
	["SpellHitRating"] = "^Equip: Increases your spell hit rating by #%.$",
	["SpellHitRating2"] = "^Equip: Improves spell hit rating by #%.$",
	["SpellHitRatingShort"] = "^%+?# Spell Hit Rating$",
	["SpellPenetration"] = "^Equip: Increases your spell penetration by #%.$",
	["SpellPenetrationClassic"] = "^Equip: Decreases the magical resistances of your spell targets by #%.$",
	["SpellPenetrationShort"] = "^%+?# Spell Penetration$",
	["SpellPower"] = "^%+?# Spell Power$",
	["SpellPower2"] = "^Equip: Increases spell power by #%.$",
	["SpellPower3"] = "^UNUSED$",
	["Spirit"] = "^%+?# Spirit$",
	["Staff"] = "^Staff$",
	["Stamina"] = "^%+?# Stamina$",
	["Strength"] = "^%+?# Strength$",
	["Sword"] = "^Sword$",
	["TemporaryBuffMinutes"] = "^.+%(%d+ min%)$",
	["TemporaryBuffSeconds"] = "^.+%(%d+ sec%)$",
	["Thrown"] = "^Thrown$",
	["Thunderforged"] = "^Thunderforged$",
	["Timeless"] = "^Timeless$",
	["Titanforged"] = "^Titanforged$",
	["UpgradeLevel"] = "^Upgrade Level:",
	["Use"] = "Use:",
	["Versatility"] = "^%+# Versatility$",
	["Wand"] = "^Wand$",
	["Warforged"] = "^Warforged$",
	["Warglaives"] = "^Warglaives$",
	["WeaponDamage"] = "^# %- # Damage$",
	["WeaponDamageArcane"] = "^# %- # Arcane Damage$",
	["WeaponDamageArcaneExact"] = "^# Arcane Damage$",
	["WeaponDamageEnchantment"] = "^%+?# Weapon Damage$",
	["WeaponDamageEquip"] = "^Equip: %+?# Weapon Damage%.$",
	["WeaponDamageExact"] = "^# Damage$",
	["WeaponDamageFire"] = "^# %- # Fire Damage$",
	["WeaponDamageFireExact"] = "^# Fire Damage$",
	["WeaponDamageFrost"] = "^# %- # Frost Damage$",
	["WeaponDamageFrostExact"] = "^# Frost Damage$",
	["WeaponDamageHoly"] = "^# %- # Holy Damage$",
	["WeaponDamageHolyExact"] = "^# Holy Damage$",
	["WeaponDamageNature"] = "^# %- # Nature Damage$",
	["WeaponDamageNatureExact"] = "^# Nature Damage$",
	["WeaponDamageShadow"] = "^# %- # Shadow Damage$",
	["WeaponDamageShadowExact"] = "^# Shadow Damage$",
}

PawnLocal.Specs =
{
    [1] = {
        { Name="Arms", Icon=132355, Role="DAMAGER" },
        { Name="Fury", Icon=132347, Role="DAMAGER" },
        { Name="Protection", Icon=132341, Role="TANK" },
    },
    [2] = {
        { Name="Holy", Icon=135920, Role="HEALER" },
        { Name="Protection", Icon=236264, Role="TANK" },
        { Name="Retribution", Icon=135873, Role="DAMAGER" },
    },
    [3] = {
        { Name="Beast Mastery", Icon=461112, Role="DAMAGER" },
        { Name="Marksmanship", Icon=236179, Role="DAMAGER" },
        { Name="Survival", Icon=461113, Role="DAMAGER" },
    },
    [4] = {
        { Name="Assassination", Icon=236270, Role="DAMAGER" },
        { Name="Outlaw", Icon=236286, Role="DAMAGER" },
        { Name="Subtlety", Icon=132320, Role="DAMAGER" },
    },
    [5] = {
        { Name="Discipline", Icon=135940, Role="HEALER" },
        { Name="Holy", Icon=237542, Role="HEALER" },
        { Name="Shadow", Icon=136207, Role="DAMAGER" },
    },
    [6] = {
        { Name="Blood", Icon=135770, Role="TANK" },
        { Name="Frost", Icon=135773, Role="DAMAGER" },
        { Name="Unholy", Icon=135775, Role="DAMAGER" },
    },
    [7] = {
        { Name="Elemental", Icon=136048, Role="DAMAGER" },
        { Name="Enhancement", Icon=237581, Role="DAMAGER" },
        { Name="Restoration", Icon=136052, Role="HEALER" },
    },
    [8] = {
        { Name="Arcane", Icon=135932, Role="DAMAGER" },
        { Name="Fire", Icon=135810, Role="DAMAGER" },
        { Name="Frost", Icon=135846, Role="DAMAGER" },
    },
    [9] = {
        { Name="Affliction", Icon=136145, Role="DAMAGER" },
        { Name="Demonology", Icon=136172, Role="DAMAGER" },
        { Name="Destruction", Icon=136186, Role="DAMAGER" },
    },
    [10] = {
        { Name="Brewmaster", Icon=608951, Role="TANK" },
        { Name="Mistweaver", Icon=608952, Role="HEALER" },
        { Name="Windwalker", Icon=608953, Role="DAMAGER" },
    },
    [11] = {
        { Name="Balance", Icon=136096, Role="DAMAGER" },
        { Name="Feral", Icon=132115, Role="DAMAGER" },
        { Name="Guardian", Icon=132276, Role="TANK" },
        { Name="Restoration", Icon=136041, Role="HEALER" },
    },
    [12] = {
        { Name="Havoc", Icon=1247264, Role="DAMAGER" },
        { Name="Vengeance", Icon=1247265, Role="TANK" },
    },
}

end

local Locale = GetLocale()
if Locale ~= "deDE" and Locale ~= "esES" and Locale ~= "esMX" and Locale ~= "frFR" and Locale ~= "itIT" and Locale ~= "koKR" and Locale ~= "ptBR" and Locale ~= "ruRU" and Locale ~= "zhCN" and Locale ~= "zhTW" then
	PawnUseThisLocalization()
end

-- After using this localization or deciding that we don't need it, remove it from memory.
PawnUseThisLocalization = nil
