QuestieCompat.UiMapData =
{
    [946] =
    {
        [1] = 0,
        [2] = 0,
        [3] = 0,
        [4] = 0,
        ["mapType"] = 0,
        ["parentMapID"] = 0,
        ["mapID"] = -1,
        ["instance"] = -1,
        ["name"] = "Cosmic",
    },
    [947] =
	{
		[1] = -3065.623046875,
		[2] = 39654.2998046875,
		[3] = 8723.9580078125,
		[4] = 14824.525390625,
		["mapType"] = 1,
		["parentMapID"] = 0,
		["mapID"] = 0,
		["instance"] = 1,
		["name"] = "Azeroth",
	},
    [1411] =
	{
		[1] = 5287.4996337891,
		[2] = 3524.9998779297,
		[3] = -1962.4998779297,
		[4] = 1808.3332519531,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 5,
		["instance"] = 1,
		["name"] = "Durotar",
	},
	[1412] =
	{
		[1] = 5137.4998779297,
		[2] = 3424.9998474121,
		[3] = 2047.9166259766,
		[4] = -272.91665649414,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 10,
		["instance"] = 1,
		["name"] = "Mulgore",
	},
	[1413] =
	{
		[1] = 10133.333007812,
		[2] = 6756.2498779297,
		[3] = 2622.9165039062,
		[4] = 1612.4998779297,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 12,
		["instance"] = 1,
		["name"] = "The Barrens",
	},
	[1414] =
	{
		[1] = 36799.810546875,
		[2] = 24533.200195313,
		[3] = 17066.599609375,
		[4] = 12799.900390625,
		["mapType"] = 2,
		["parentMapID"] = 947,
		["mapID"] = 14,
		["instance"] = 1,
		["name"] = "Kalimdor",
	},
    [1415] =
    {
        [1] = 40741.181640625,
        [2] = 27149.6875,
        [3] = 18171.970703125,
        [4] = 11176.34375,
        ["mapType"] = 2,
        ["parentMapID"] = 947,
        ["mapID"] = 15,
        ["instance"] = 0,
        ["name"] = "Eastern Kingdoms",
    },
	[1416] =
	{
		[1] = 2799.9999389649,
		[2] = 1866.6666564941,
		[3] = 783.33331298828,
		[4] = 1500,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 16,
		["instance"] = 0,
		["name"] = "Alterac Mountains",
	},
	[1417] =
	{
		[1] = 3599.9998779296,
		[2] = 2399.999923706,
		[3] = -866.66662597656,
		[4] = -133.33332824707,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 17,
		["instance"] = 0,
		["name"] = "Arathi Highlands",
	},
	[1418] =
	{
		[1] = 2487.5,
		[2] = 1658.3334960937,
		[3] = -2079.1665039062,
		[4] = -5889.5830078125,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 18,
		["instance"] = 0,
		["name"] = "Badlands",
	},
	[1419] =
	{
		[1] = 3349.9998779296,
		[2] = 2233.333984375,
		[3] = -1241.6666259766,
		[4] = -10566.666015625,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 20,
		["instance"] = 0,
		["name"] = "Blasted Lands",
	},
	[1420] =
	{
		[1] = 4518.7498779297,
		[2] = 3012.4998168946,
		[3] = 3033.3332519531,
		[4] = 3837.4997558594,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 21,
		["instance"] = 0,
		["name"] = "Tirisfal Glades",
	},
	[1421] =
	{
		[1] = 4199.9997558594,
		[2] = 2799.9998779297,
		[3] = 3449.9997558594,
		[4] = 1666.6666259766,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 22,
		["instance"] = 0,
		["name"] = "Silverpine Forest",
	},
	[1422] =
	{
		[1] = 4299.9999084472,
		[2] = 2866.6665344238,
		[3] = 416.66665649414,
		[4] = 3366.6665039062,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 23,
		["instance"] = 0,
		["name"] = "Western Plaguelands",
	},
	[1423] =
	{
		[1] = 3870.8334960938,
		[2] = 2581.2497558594,
		[3] = -2185.4165039062,
		[4] = 3799.9997558594,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 24,
		["instance"] = 0,
		["name"] = "Eastern Plaguelands",
	},
	[1424] =
	{
		[1] = 3199.9998779297,
		[2] = 2133.3332519531,
		[3] = 1066.6666259766,
		[4] = 400,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 25,
		["instance"] = 0,
		["name"] = "Hillsbrad Foothills",
	},
	[1425] =
	{
		[1] = 3850,
		[2] = 2566.6666259766,
		[3] = -1575,
		[4] = 1466.6666259766,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 27,
		["instance"] = 0,
		["name"] = "The Hinterlands",
	},
	[1426] =
	{
		[1] = 4924.9997558593,
		[2] = 3283.3332519531,
		[3] = 1802.0832519531,
		[4] = -3877.0832519531,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 28,
		["instance"] = 0,
		["name"] = "Dun Morogh",
	},
	[1427] =
	{
		[1] = 2231.2498474121,
		[2] = 1487.4995117188,
		[3] = -322.91665649414,
		[4] = -6100,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 29,
		["instance"] = 0,
		["name"] = "Searing Gorge",
	},
	[1428] =
	{
		[1] = 2929.166595459,
		[2] = 1952.0834960937,
		[3] = -266.66665649414,
		[4] = -7031.2495117188,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 30,
		["instance"] = 0,
		["name"] = "Burning Steppes",
	},
	[1429] =
	{
		[1] = 3470.8332519532,
		[2] = 2314.5830078125,
		[3] = 1535.4166259766,
		[4] = -7939.5830078125,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 31,
		["instance"] = 0,
		["name"] = "Elwynn Forest",
	},
	[1430] =
	{
		[1] = 2499.9999389648,
		[2] = 1666.666992187,
		[3] = -833.33331298828,
		[4] = -9866.666015625,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 33,
		["instance"] = 0,
		["name"] = "Deadwind Pass",
	},
	[1431] =
	{
		[1] = 2699.9999389649,
		[2] = 1800.0,
		[3] = 833.33331298828,
		[4] = -9716.666015625,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 35,
		["instance"] = 0,
		["name"] = "Duskwood",
	},
	[1432] =
	{
		[1] = 2758.3331298828,
		[2] = 1839.5830078125,
		[3] = -1993.7498779297,
		[4] = -4487.5,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 36,
		["instance"] = 0,
		["name"] = "Loch Modan",
	},
	[1433] =
	{
		[1] = 2170.8332519531,
		[2] = 1447.916015625,
		[3] = -1570.8332519531,
		[4] = -8575,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 37,
		["instance"] = 0,
		["name"] = "Redridge Mountains",
	},
	[1434] =
	{
		[1] = 6381.2497558593,
		[2] = 4254.166015625,
		[3] = 2220.8332519531,
		[4] = -11168.75,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 38,
		["instance"] = 0,
		["name"] = "Stranglethorn Vale",
	},
	[1435] =
	{
		[1] = 2293.75,
		[2] = 1529.1669921875,
		[3] = -2222.9165039062,
		[4] = -9620.8330078125,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 39,
		["instance"] = 0,
		["name"] = "Swamp of Sorrows",
	},
	[1436] =
	{
		[1] = 3499.9998168945,
		[2] = 2333.333007812,
		[3] = 3016.6665039062,
		[4] = -9400,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 40,
		["instance"] = 0,
		["name"] = "Westfall",
	},
	[1437] =
	{
		[1] = 4135.4166870117,
		[2] = 2756.25,
		[3] = -389.58331298828,
		[4] = -2147.9165039062,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 41,
		["instance"] = 0,
		["name"] = "Wetlands",
	},
	[1438] =
	{
		[1] = 5091.6665039062,
		[2] = 3393.75,
		[3] = 3814.5832519531,
		[4] = 11831.25,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 42,
		["instance"] = 1,
		["name"] = "Teldrassil",
	},
	[1439] =
	{
		[1] = 6549.9997558593,
		[2] = 4366.6665039063,
		[3] = 2941.6665039062,
		[4] = 8333.3330078125,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 43,
		["instance"] = 1,
		["name"] = "Darkshore",
	},
	[1440] =
	{
		[1] = 5766.6663818359,
		[2] = 3843.7498779296,
		[3] = 1699.9998779297,
		[4] = 4672.9165039062,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 44,
		["instance"] = 1,
		["name"] = "Ashenvale",
	},
	[1441] =
	{
		[1] = 4399.9996948242,
		[2] = 2933.3330078126,
		[3] = -433.33331298828,
		[4] = -3966.6665039062,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 62,
		["instance"] = 1,
		["name"] = "Thousand Needles",
	},
	[1442] =
	{
		[1] = 4883.3331298828,
		[2] = 3256.2498168945,
		[3] = 3245.8332519531,
		[4] = 2916.6665039062,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 82,
		["instance"] = 1,
		["name"] = "Stonetalon Mountains",
	},
	[1443] =
	{
		[1] = 4495.8330078125,
		[2] = 2997.9165649414,
		[3] = 4233.3330078125,
		[4] = 452.08331298828,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 102,
		["instance"] = 1,
		["name"] = "Desolace",
	},
	[1444] =
	{
		[1] = 6949.9997558593,
		[2] = 4633.3330078126,
		[3] = 5441.6665039062,
		[4] = -2366.6665039062,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 122,
		["instance"] = 1,
		["name"] = "Feralas",
	},
	[1445] =
	{
		[1] = 5250.0000610352,
		[2] = 3499.9997558594,
		[3] = -974.99993896484,
		[4] = -2033.3332519531,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 142,
		["instance"] = 1,
		["name"] = "Dustwallow Marsh",
	},
	[1446] =
	{
		[1] = 6899.9995269776,
		[2] = 4600,
		[3] = -218.74998474121,
		[4] = -5875,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 162,
		["instance"] = 1,
		["name"] = "Tanaris",
	},
	[1447] =
	{
		[1] = 5070.8327636719,
		[2] = 3381.2498779296,
		[3] = -3277.0832519531,
		[4] = 5341.6665039062,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 182,
		["instance"] = 1,
		["name"] = "Azshara",
	},
	[1448] =
	{
		[1] = 5749.9996337891,
		[2] = 3833.3332519531,
		[3] = 1641.6666259766,
		[4] = 7133.3330078125,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 183,
		["instance"] = 1,
		["name"] = "Felwood",
	},
	[1449] =
	{
		[1] = 3699.9998168945,
		[2] = 2466.6665039063,
		[3] = 533.33331298828,
		[4] = -5966.6665039062,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 202,
		["instance"] = 1,
		["name"] = "Un'Goro Crater",
	},
	[1450] =
	{
		[1] = 2308.3332519531,
		[2] = 1539.5830078125,
		[3] = -1381.25,
		[4] = 8491.666015625,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 242,
		["instance"] = 1,
		["name"] = "Moonglade",
	},
	[1451] =
	{
		[1] = 3483.333984375,
		[2] = 2322.916015625,
		[3] = 2537.5,
		[4] = -5958.333984375,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 262,
		["instance"] = 1,
		["name"] = "Silithus",
	},
	[1452] =
	{
		[1] = 7099.9998474121,
		[2] = 4733.3332519531,
		[3] = -316.66665649414,
		[4] = 8533.3330078125,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 282,
		["instance"] = 1,
		["name"] = "Winterspring",
	},
	[1453] =
	{
		[1] = 1344.2708053589,
		[2] = 896.3544921875,
		[3] = 1380.9714355469,
		[4] = -8278.8505859375,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 302,
		["instance"] = 0,
		["name"] = "Stormwind City",
	},
	[1454] =
	{
		[1] = 1402.6044921874,
		[2] = 935.4166259765,
		[3] = -3680.6010742188,
		[4] = 2273.8771972656,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 322,
		["instance"] = 1,
		["name"] = "Orgrimmar",
	},
	[1455] =
	{
		[1] = 790.62506103519,
		[2] = 527.6044921875,
		[3] = -713.59136962891,
		[4] = -4569.2412109375,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 342,
		["instance"] = 0,
		["name"] = "Ironforge",
	},
	[1456] =
	{
		[1] = 1043.7499389648,
		[2] = 695.83331298826,
		[3] = 516.66662597656,
		[4] = -849.99993896484,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 363,
		["instance"] = 1,
		["name"] = "Thunder Bluff",
	},
	[1457] =
	{
		[1] = 1058.3332519532,
		[2] = 705.7294921875,
		[3] = 2938.3627929688,
		[4] = 10238.31640625,
		["mapType"] = 3,
		["parentMapID"] = 1414,
		["mapID"] = 382,
		["instance"] = 1,
		["name"] = "Darnassus",
	},
	[1458] =
	{
		[1] = 959.37503051758,
		[2] = 640.1041259766,
		[3] = 873.19262695313,
		[4] = 1877.9453125,
		["mapType"] = 3,
		["parentMapID"] = 1415,
		["mapID"] = 383,
		["instance"] = 0,
		["name"] = "Undercity",
	},
    [1459] =
	{
		[1] = 4237.4998779297,
		[2] = 2824.9998779297,
		[3] = 1781.2498779297,
		[4] = 1085.4166259766,
		["mapType"] = 3,
		["parentMapID"] = 947,
		["mapID"] = 402,
		["instance"] = 30,
		["name"] = "Alterac Valley",
	},
	[1460] =
	{
		[1] = 1145.8333129883,
		[2] = 764.58331298826,
		[3] = 2041.6666259766,
		[4] = 1627.0832519531,
		["mapType"] = 3,
		["parentMapID"] = 947,
		["mapID"] = 444,
		["instance"] = 489,
		["name"] = "Warsong Gulch",
	},
	[1461] =
	{
		[1] = 1756.249923706,
		[2] = 1170.8332519531,
		[3] = 1858.3332519531,
		[4] = 1508.3332519531,
		["mapType"] = 3,
		["parentMapID"] = 947,
		["mapID"] = 462,
		["instance"] = 529,
		["name"] = "Arathi Basin",
	},
}

QuestieCompat.worldMapData = {
    [0] = { 44688.53, 29795.11, 32601.04,  9894.93 },
    [1] = { 44878.66, 29916.10,  8723.96, 14824.53 },
}


function QuestieCompat.LoadUiMapData(expansionLevel)
    if (expansionLevel or QuestieCompat.WOW_PROJECT_ID) < QuestieCompat.WOW_PROJECT_BURNING_CRUSADE_CLASSIC then return end

    local UiMapData =
    {
        [947] =
        {
            [1] = -31823.46875,
            [2] = 45264.94287109375,
            [3] = -5574.525390625,
            [4] = 19216.29296875,
            ["mapType"] = 1,
            ["parentMapID"] = 946,
            ["mapID"] = 0,
            ["instance"] = 530,
            ["name"] = "Azeroth",
        },
        [1941] =
        {
            [1] = 4925.0,
            [2] = 3283.3330078125,
            [3] = -1824.6765519634,
            [4] = 8641.6630625316,
            ["mapType"] = 3,
            ["parentMapID"] = 1415,
            ["mapID"] = 463,
            ["instance"] = 0,
            ["name"] = "Eversong Woods",
        },
        [1942] =
        {
            [1] = 3300.0,
            [2] = 2199.9995117188,
            [3] = -2620.5095597759,
            [4] = 5866.6630625316,
            ["mapType"] = 3,
            ["parentMapID"] = 1415,
            ["mapID"] = 464,
            ["instance"] = 0,
            ["name"] = "Ghostlands",
        },
        [1943] =
        {
            [1] = 4070.833007812,
            [2] = 2714.5830078125,
            [3] = 7099.9771773203,
            [4] = 7545.9403142564,
            ["mapType"] = 3,
            ["parentMapID"] = 1414,
            ["mapID"] = 465,
            ["instance"] = 1,
            ["name"] = "Azuremyst Isle",
        },
        [1944] =
        {
            [1] = 5164.5830078125,
            [2] = 3443.7498779297,
            [3] = 5539.5830078125,
            [4] = 1481.25,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 466,
            ["instance"] = 530,
            ["name"] = "Hellfire Peninsula",
        },
        [1945] =
        {
            [1] = 17464.078125,
            [2] = 11642.71875,
            [3] = 12996.0390625,
            [4] = 5821.359375,
            ["mapType"] = 2,
            ["parentMapID"] = 946,
            ["mapID"] = 467,
            ["instance"] = 530,
            ["name"] = "Outland",
        },
        [1946] =
        {
            [1] = 5027.0834960938,
            [2] = 3352.0832519532,
            [3] = 9475,
            [4] = 1935.4166259766,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 468,
            ["instance"] = 530,
            ["name"] = "Zangarmarsh",
        },
        [1947] =
        {
            [1] = 1056.770507812,
            [2] = 704.6877441406,
            [3] = 6533.6099898203,
            [4] = 6730.006964647,
            ["mapType"] = 3,
            ["parentMapID"] = 1414,
            ["mapID"] = 472,
            ["instance"] = 1,
            ["name"] = "The Exodar",
        },
        [1948] =
        {
            [1] = 5500,
            [2] = 3666.6663818359,
            [3] = 4225,
            [4] = -1947.9166259766,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 474,
            ["instance"] = 530,
            ["name"] = "Shadowmoon Valley",
        },
        [1949] =
        {
            [1] = 5424.9997558594,
            [2] = 3616.6663818359,
            [3] = 8845.8330078125,
            [4] = 4408.3330078125,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 476,
            ["instance"] = 530,
            ["name"] = "Blade's Edge Mountains",
        },
        [1950] =
        {
            [1] = 3262.499023438,
            [2] = 2174.9999389648,
            [3] = 7524.9771773203,
            [4] = 9581.3570012682,
            ["mapType"] = 3,
            ["parentMapID"] = 1414,
            ["mapID"] = 477,
            ["instance"] = 1,
            ["name"] = "Bloodmyst Isle",
        },
        [1951] =
        {
            [1] = 5524.9999999995,
            [2] = 3683.3331680297,
            [3] = 10295.833007812,
            [4] = 41.66666412354,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 478,
            ["instance"] = 530,
            ["name"] = "Nagrand",
        },
        [1952] =
        {
            [1] = 5399.9997558594,
            [2] = 3600.0000610352,
            [3] = 7083.3330078125,
            [4] = -999.99993896484,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 479,
            ["instance"] = 530,
            ["name"] = "Terokkar Forest",
        },
        [1953] =
        {
            [1] = 5574.999671936,
            [2] = 3716.6667480469,
            [3] = 5483.3330078125,
            [4] = 5456.25,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 480,
            ["instance"] = 530,
            ["name"] = "Netherstorm",
        },
        [1954] =
        {
            [1] = 1211.4584960938,
            [2] = 806.7705078125,
            [3] = -3737.9265519634,
            [4] = 7753.7060312816,
            ["mapType"] = 3,
            ["parentMapID"] = 1415,
            ["mapID"] = 481,
            ["instance"] = 0,
            ["name"] = "Silvermoon City",
        },
        [1955] =
        {
            [1] = 1306.25,
            [2] = 870.8333740235,
            [3] = 6135.2587890625,
            [4] = -1473.9544677734,
            ["mapType"] = 3,
            ["parentMapID"] = 1945,
            ["mapID"] = 482,
            ["instance"] = 530,
            ["name"] = "Shattrath City",
        },
        [1956] =
        {
            [1] = 2270.8331909179,
            [2] = 1514.5833740234,
            [3] = 2660.4165039062,
            [4] = 2918.75,
            ["mapType"] = 3,
            ["parentMapID"] = 1953,
            ["mapID"] = 483,
            ["instance"] = 566,
            ["name"] = "Eye of the Storm",
        },
        [1957] =
        {
            [1] = 3327.0830078125,
            [2] = 2218.749023438,
            [3] = -2639.2595597759,
            [4] = 11168.746070345,
            ["mapType"] = 3,
            ["parentMapID"] = 1415,
            ["mapID"] = 500,
            ["instance"] = 0,
            ["name"] = "Isle of Quel'Danas",
        },
    }

    for id, data in pairs(UiMapData) do
        QuestieCompat.UiMapData[id] = data
    end
    UiMapData = nil

    QuestieCompat.worldMapData[0] = { 44688.53, 29791.24, 32681.47, 11479.44 }
    QuestieCompat.worldMapData[1] = { 44878.66, 29916.10,  8723.96, 14824.53 }

    if (expansionLevel or QuestieCompat.WOW_PROJECT_ID) < QuestieCompat.WOW_PROJECT_WRATH_CLASSIC then return end

    local UiMapData =
    {
        [947] =
        {
            [1] = 31772.185855747,
            [2] = 47662.69843642,
            [3] = 11072.066024293,
            [4] = 25198.534987385,
            ["mapType"] = 1,
            ["parentMapID"] = 946,
            ["mapID"] = 0,
            ["name"] = "Azeroth",
            ["instance"] = 571,
        },
        [1423] =
        {
            [1] = 4031.25,
            [2] = 2687.4998779296,
            [3] = -2287.5,
            [4] = 3704.1665039062,
            ["mapType"] = 3,
            ["parentMapID"] = 1415,
            ["mapID"] = 24,
            ["name"] = "Eastern Plaguelands",
            ["instance"] = 0,
        },
        [1453] =
        {
            [1] = 1737.499958992,
            [2] = 1158.3330078125,
            [3] = 1722.9166259766,
            [4] = -7995.8330078125,
            ["mapType"] = 3,
            ["parentMapID"] = 1415,
            ["mapID"] = 302,
            ["name"] = "Stormwind City",
            ["instance"] = 0,
        },
        [113] =
        {
            [1] = 17763.010742188,
            [2] = 11842.702514648,
            [3] = 9198.58203125,
            [4] = 10619.23046875,
            ["mapType"] = 2,
            ["parentMapID"] = 947,
            ["mapID"] = 486,
            ["name"] = "Northrend",
            ["instance"] = 571,
        },
        [114] =
        {
            [1] = 5764.580078125,
            [2] = 3843.7498779297,
            [3] = 8570.830078125,
            [4] = 4897.919921875,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 487,
            ["name"] = "Borean Tundra",
            ["instance"] = 571,
        },
        [115] =
        {
            [1] = 5608.330078125,
            [2] = 3739.5799560547,
            [3] = 3627.080078125,
            [4] = 5575,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 489,
            ["name"] = "Dragonblight",
            ["instance"] = 571,
        },
        [116] =
        {
            [1] = 5249.9998779297,
            [2] = 3499.9998779297,
            [3] = -1110.4200439453,
            [4] = 5516.669921875,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 491,
            ["name"] = "Grizzly Hills",
            ["instance"] = 571,
        },
        [117] =
        {
            [1] = 6045.8299560547,
            [2] = 4031.2529296875,
            [3] = -1397.9200439453,
            [4] = 3116.669921875,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 492,
            ["name"] = "Howling Fjord",
            ["instance"] = 571,
        },
        [118] =
        {
            [1] = 6270.8330078125,
            [2] = 4181.25,
            [3] = 5443.75,
            [4] = 9427.080078125,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 493,
            ["name"] = "Icecrown",
            ["instance"] = 571,
        },
        [119] =
        {
            [1] = 4356.25,
            [2] = 2904.169921875,
            [3] = 6929.169921875,
            [4] = 7287.5,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 494,
            ["name"] = "Sholazar Basin",
            ["instance"] = 571,
        },
        [120] =
        {
            [1] = 7112.5001220703,
            [2] = 4741.650390625,
            [3] = 1841.6700439453,
            [4] = 10197.900390625,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 496,
            ["name"] = "The Storm Peaks",
            ["instance"] = 571,
        },
        [121] =
        {
            [1] = 4993.75,
            [2] = 3329.169921875,
            [3] = -600,
            [4] = 7668.75,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 497,
            ["name"] = "Zul'Drak",
            ["instance"] = 571,
        },
        [123] =
        {
            [1] = 2974.9998779297,
            [2] = 1983.33984375,
            [3] = 4329.169921875,
            [4] = 5716.669921875,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 502,
            ["name"] = "Wintergrasp",
            ["instance"] = 571,
        },
        [124] =
        {
            [1] = 3162.5,
            [2] = 2108.3333740234,
            [3] = -4047.9165039062,
            [4] = 3087.5,
            ["mapType"] = 6,
            ["parentMapID"] = 1423,
            ["mapID"] = 503,
            ["name"] = "Plaguelands: The Scarlet Enclave",
            ["instance"] = 0,
        },
        [125] =
        {
            [1] = 830.01501464841,
            [2] = 553.33984375,
            [3] = 1052.5100097656,
            [4] = 6066.669921875,
            ["mapType"] = 4,
            ["parentMapID"] = 113,
            ["mapID"] = 505.1,
            ["name"] = "Dalaran",
            ["instance"] = 571,
        },
        [126] =
        {
            [1] = 563.22399902344,
            [2] = 375.4897460938,
            [3] = 915.86999511719,
            [4] = 5975.33984375,
            ["mapType"] = 4,
            ["parentMapID"] = 127,
            ["mapID"] = 505.2,
            ["name"] = "Dalaran",
            ["instance"] = 571,
        },
        [127] =
        {
            [1] = 2722.9200439453,
            [2] = 1814.580078125,
            [3] = 1443.75,
            [4] = 6502.080078125,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 511,
            ["name"] = "Crystalsong Forest",
            ["instance"] = 571,
        },
        [128] =
        {
            [1] = 1743.7499389648,
            [2] = 1162.4999389648,
            [3] = 787.5,
            [4] = 1883.3332519531,
            ["mapType"] = 6,
            ["parentMapID"] = 115,
            ["mapID"] = 513,
            ["name"] = "Strand of the Ancients",
            ["instance"] = 607,
        },
        [129] =
        {
            [1] = 1101.2809753418,
            [2] = 734.1875,
            [3] = 393.21200561523,
            [4] = 798.26300048828,
            ["mapType"] = 4,
            ["parentMapID"] = 114,
            ["mapID"] = 521.1,
            ["name"] = "The Nexus",
            ["instance"] = 576,
        },
        [130] =
        {
            [1] = 1824.9999389648,
            [2] = 1216.6665039062,
            [3] = 2152.0832519531,
            [4] = 2297.9165039062,
            ["mapType"] = 4,
            ["parentMapID"] = 1446,
            ["mapID"] = 522.1,
            ["name"] = "The Culling of Stratholme",
            ["instance"] = 595,
        },
        [131] =
        {
            [1] = 1125.299987793,
            [2] = 750.1999511719,
            [3] = 1856.3599853516,
            [4] = 2641.9599609375,
            ["mapType"] = 4,
            ["parentMapID"] = 130,
            ["mapID"] = 522.2,
            ["name"] = "The Culling of Stratholme",
            ["instance"] = 595,
        },
        [132] =
        {
            [1] = 972.41796874997,
            [2] = 648.27902221679,
            [3] = -233.30200195313,
            [4] = 848.68402099609,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 523.1,
            ["name"] = "Ahn'kahet: The Old Kingdom",
            ["instance"] = 619,
        },
        [133] =
        {
            [1] = 734.58099365235,
            [2] = 489.72150039673,
            [3] = 424.17498779297,
            [4] = 515.38800048828,
            ["mapType"] = 4,
            ["parentMapID"] = 117,
            ["mapID"] = 524.1,
            ["name"] = "Utgarde Keep",
            ["instance"] = 574,
        },
        [134] =
        {
            [1] = 481.08100891114,
            [2] = 320.72029304504,
            [3] = 242.92500305176,
            [4] = 304.3869934082,
            ["mapType"] = 4,
            ["parentMapID"] = 117,
            ["mapID"] = 524.2,
            ["name"] = "Utgarde Keep",
            ["instance"] = 574,
        },
        [135] =
        {
            [1] = 736.58100891114,
            [2] = 491.05451202392,
            [3] = 225.67500305176,
            [4] = 415.72100830078,
            ["mapType"] = 4,
            ["parentMapID"] = 117,
            ["mapID"] = 524.3,
            ["name"] = "Utgarde Keep",
            ["instance"] = 574,
        },
        [136] =
        {
            [1] = 548.93601989746,
            [2] = 365.95701599121,
            [3] = -148.62300109863,
            [4] = 552.87701416016,
            ["mapType"] = 4,
            ["parentMapID"] = 117,
            ["mapID"] = 525.1,
            ["name"] = "Utgarde Pinnacle",
            ["instance"] = 575,
        },
        [137] =
        {
            [1] = 756.17994308472,
            [2] = 504.1190032959,
            [3] = 8.62195968628,
            [4] = 661.9580078125,
            ["mapType"] = 4,
            ["parentMapID"] = 117,
            ["mapID"] = 525.2,
            ["name"] = "Utgarde Pinnacle",
            ["instance"] = 575,
        },
        [138] =
        {
            [1] = 566.23501586914,
            [2] = 377.4899902344,
            [3] = 283.68600463867,
            [4] = 1534.5400390625,
            ["mapType"] = 4,
            ["parentMapID"] = 120,
            ["mapID"] = 526.1,
            ["name"] = "Halls of Lightning",
            ["instance"] = 602,
        },
        [139] =
        {
            [1] = 708.23701477051,
            [2] = 472.16003417967,
            [3] = 169.68800354004,
            [4] = 1431.8800048828,
            ["mapType"] = 4,
            ["parentMapID"] = 120,
            ["mapID"] = 526.2,
            ["name"] = "Halls of Lightning",
            ["instance"] = 602,
        },
        [140] =
        {
            [1] = 920.19601440425,
            [2] = 613.46606445314,
            [3] = 1126.5200195312,
            [4] = 1375.9100341797,
            ["mapType"] = 4,
            ["parentMapID"] = 120,
            ["mapID"] = 527.1,
            ["name"] = "Halls of Stone",
            ["instance"] = 599,
        },
        [141] =
        {
            [1] = 430.0700683594,
            [2] = 286.71301269531,
            [3] = 1466.7800292969,
            [4] = 897.84100341797,
            ["mapType"] = 4,
            ["parentMapID"] = 114,
            ["mapID"] = 528.1,
            ["name"] = "The Eye of Eternity",
            ["instance"] = 616,
        },
        [143] =
        {
            [1] = 514.70697021484,
            [2] = 343.13897705078,
            [3] = 1301.9599609375,
            [4] = 1220.2099609375,
            ["mapType"] = 4,
            ["parentMapID"] = 114,
            ["mapID"] = 529.1,
            ["name"] = "The Oculus",
            ["instance"] = 578,
        },
        [144] =
        {
            [1] = 664.70697021484,
            [2] = 443.13897705078,
            [3] = 1376.9599609375,
            [4] = 1370.2099609375,
            ["mapType"] = 4,
            ["parentMapID"] = 114,
            ["mapID"] = 529.2,
            ["name"] = "The Oculus",
            ["instance"] = 578,
        },
        [145] =
        {
            [1] = 514.70697021484,
            [2] = 343.13897705078,
            [3] = 1301.9599609375,
            [4] = 1270.2099609375,
            ["mapType"] = 4,
            ["parentMapID"] = 114,
            ["mapID"] = 529.3,
            ["name"] = "The Oculus",
            ["instance"] = 578,
        },
        [146] =
        {
            [1] = 294.70098876953,
            [2] = 196.46728515625,
            [3] = 1191.9599609375,
            [4] = 1186.8701171875,
            ["mapType"] = 4,
            ["parentMapID"] = 114,
            ["mapID"] = 529.4,
            ["name"] = "The Oculus",
            ["instance"] = 578,
        },
        [147] =
        {
            [1] = 3287.4998779297,
            [2] = 2191.6666259766,
            [3] = 1583.3332519531,
            [4] = 1168.75,
            ["mapType"] = 4,
            ["parentMapID"] = 120,
            ["mapID"] = 530.1,
            ["name"] = "Ulduar",
            ["instance"] = 603,
        },
        [148] =
        {
            [1] = 669.45098876953,
            [2] = 446.3000488281,
            [3] = 224.21600341797,
            [4] = 1839.0100097656,
            ["mapType"] = 4,
            ["parentMapID"] = 147,
            ["mapID"] = 530.2,
            ["name"] = "Ulduar",
            ["instance"] = 603,
        },
        [149] =
        {
            [1] = 1328.4609985352,
            [2] = 885.6398925781,
            [3] = 653.72100830078,
            [4] = 2564.6799316406,
            ["mapType"] = 4,
            ["parentMapID"] = 147,
            ["mapID"] = 530.3,
            ["name"] = "Ulduar",
            ["instance"] = 603,
        },
        [150] =
        {
            [1] = 910.5,
            [2] = 607,
            [3] = 594.75,
            [4] = 2219,
            ["mapType"] = 4,
            ["parentMapID"] = 147,
            ["mapID"] = 530.4,
            ["name"] = "Ulduar",
            ["instance"] = 603,
        },
        [151] =
        {
            [1] = 1569.4599609375,
            [2] = 1046.3000488281,
            [3] = 3254.4499511719,
            [4] = 3168.830078125,
            ["mapType"] = 4,
            ["parentMapID"] = 147,
            ["mapID"] = 530.5,
            ["name"] = "Ulduar",
            ["instance"] = 603,
        },
        [152] =
        {
            [1] = 619.46899414063,
            [2] = 412.9799804688,
            [3] = 309.45498657227,
            [4] = 2247.75,
            ["mapType"] = 4,
            ["parentMapID"] = 147,
            ["mapID"] = 530.6,
            ["name"] = "Ulduar",
            ["instance"] = 603,
        },
        [154] =
        {
            [1] = 905.0330505371,
            [2] = 603.3500976563,
            [3] = 1164.9200439453,
            [4] = 2068.8701171875,
            ["mapType"] = 4,
            ["parentMapID"] = 121,
            ["mapID"] = 531.1,
            ["name"] = "Gundrak",
            ["instance"] = 604,
        },
        [155] =
        {
            [1] = 1162.499917984,
            [2] = 775.0,
            [3] = 1133.3332519531,
            [4] = 3616.6665039062,
            ["mapType"] = 6,
            ["parentMapID"] = 115,
            ["mapID"] = 532,
            ["name"] = "The Obsidian Sanctum",
            ["instance"] = 615,
        },
        [156] =
        {
            [1] = 1398.2550048828,
            [2] = 932.17001342773,
            [3] = 585.73602294922,
            [4] = 298.08999633789,
            ["mapType"] = 4,
            ["parentMapID"] = 123,
            ["mapID"] = 533.1,
            ["name"] = "Vault of Archavon",
            ["instance"] = 624,
        },
        [157] =
        {
            [1] = 752.97399902344,
            [2] = 501.98300170898,
            [3] = 722.97399902344,
            [4] = 794.125,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 534.1,
            ["name"] = "Azjol-Nerub",
            ["instance"] = 601,
        },
        [158] =
        {
            [1] = 292.97399902344,
            [2] = 195.3159790039,
            [3] = 692.97399902344,
            [4] = 645.78997802734,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 534.2,
            ["name"] = "Azjol-Nerub",
            ["instance"] = 601,
        },
        [159] =
        {
            [1] = 367.5,
            [2] = 245,
            [3] = 829.625,
            [4] = 640,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 534.3,
            ["name"] = "Azjol-Nerub",
            ["instance"] = 601,
        },
        [160] =
        {
            [1] = 619.94100952149,
            [2] = 413.29399108886,
            [3] = -307.06900024414,
            [4] = -182.5659942627,
            ["mapType"] = 4,
            ["parentMapID"] = 121,
            ["mapID"] = 535.1,
            ["name"] = "Drak'Tharon Keep",
            ["instance"] = 600,
        },
        [161] =
        {
            [1] = 619.94100952146,
            [2] = 413.29399108886,
            [3] = -382.06900024414,
            [4] = -182.5659942627,
            ["mapType"] = 4,
            ["parentMapID"] = 121,
            ["mapID"] = 535.2,
            ["name"] = "Drak'Tharon Keep",
            ["instance"] = 600,
        },
        [162] =
        {
            [1] = 1093.830078125,
            [2] = 729.2199707031,
            [3] = -2640.2700195312,
            [4] = 3615.830078125,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 536.1,
            ["name"] = "Naxxramas",
            ["instance"] = 533,
        },
        [163] =
        {
            [1] = 1093.830078125,
            [2] = 729.2199707031,
            [3] = -3140.2700195312,
            [4] = 3615.830078125,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 536.2,
            ["name"] = "Naxxramas",
            ["instance"] = 533,
        },
        [164] =
        {
            [1] = 1200,
            [2] = 800,
            [3] = -2587,
            [4] = 3136,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 536.3,
            ["name"] = "Naxxramas",
            ["instance"] = 533,
        },
        [165] =
        {
            [1] = 1200.330078125,
            [2] = 800.2199707031,
            [3] = -3087.0200195312,
            [4] = 3136.830078125,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 536.4,
            ["name"] = "Naxxramas",
            ["instance"] = 533,
        },
        [166] =
        {
            [1] = 2069.8098144531,
            [2] = 1379.8798828125,
            [3] = -2330.2800292969,
            [4] = 3691.2199707031,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 536.5,
            ["name"] = "Naxxramas",
            ["instance"] = 533,
        },
        [167] =
        {
            [1] = 655.9399414063,
            [2] = 437.2900390625,
            [3] = -4866.3500976562,
            [4] = 3816.5400390625,
            ["mapType"] = 4,
            ["parentMapID"] = 115,
            ["mapID"] = 536.6,
            ["name"] = "Naxxramas",
            ["instance"] = 533,
        },
        [168] =
        {
            [1] = 256.22900390625,
            [2] = 170.8200683594,
            [3] = 921.57598876953,
            [4] = 1984.1700439453,
            ["mapType"] = 4,
            ["parentMapID"] = 125,
            ["mapID"] = 537.1,
            ["name"] = "The Violet Hold",
            ["instance"] = 608,
        },
        [169] =
        {
            [1] = 2650,
            [2] = 1766.6665840149,
            [3] = 525,
            [4] = 1708.3332519531,
            ["mapType"] = 6,
            ["parentMapID"] = 118,
            ["mapID"] = 541,
            ["name"] = "Isle of Conquest",
            ["instance"] = 628,
        },
        [170] =
        {
            [1] = 3677.0869140625,
            [2] = 2452.129882813,
            [3] = 2797.919921875,
            [4] = 10781.299804688,
            ["mapType"] = 3,
            ["parentMapID"] = 113,
            ["mapID"] = 542,
            ["name"] = "Hrothgar's Landing",
            ["instance"] = 571,
        },
        [171] =
        {
            [1] = 369.98596191406,
            [2] = 246.65802001953,
            [3] = 807.40997314453,
            [4] = 876.10601806641,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 543.1,
            ["name"] = "Trial of the Champion",
            ["instance"] = 650,
        },
        [172] =
        {
            [1] = 369.9861869812,
            [2] = 246.65798950195,
            [3] = 328.73098754883,
            [4] = 693.01898193359,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 544.1,
            ["name"] = "Trial of the Crusader",
            ["instance"] = 649,
        },
        [173] =
        {
            [1] = 739.99601745606,
            [2] = 493.33001708984,
            [3] = 528.73602294922,
            [4] = 926.35400390625,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 544.2,
            ["name"] = "Trial of the Crusader",
            ["instance"] = 649,
        },
        [183] =
        {
            [1] = 1448.0998535156,
            [2] = 965.400390625,
            [3] = 3134.1298828125,
            [4] = 5779.9301757812,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 602.1,
            ["name"] = "The Forge of Souls",
            ["instance"] = 632,
        },
        [184] =
        {
            [1] = 1533.3333129883,
            [2] = 1022.9166717529,
            [3] = 839.58331298828,
            [4] = 1256.25,
            ["mapType"] = 6,
            ["parentMapID"] = 118,
            ["mapID"] = 603,
            ["name"] = "Pit of Saron",
            ["instance"] = 658,
        },
        [185] =
        {
            [1] = 879.0200195312,
            [2] = 586.01953125,
            [3] = 2349.0100097656,
            [4] = 5713.009765625,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 604.1,
            ["name"] = "Halls of Reflection",
            ["instance"] = 668,
        },
        [186] =
        {
            [1] = 1355.4700927734,
            [2] = 903.64703369141,
            [3] = 2739.8000488281,
            [4] = 138.80700683594,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.1,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [187] =
        {
            [1] = 1067,
            [2] = 711.33369064331,
            [3] = 2698,
            [4] = -43.33330154419,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.2,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [188] =
        {
            [1] = 195.4699707031,
            [2] = 130.31500244141,
            [3] = 2311.8000488281,
            [4] = -449.99798583984,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.3,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [189] =
        {
            [1] = 773.7100830078,
            [2] = 515.8103027344,
            [3] = 2767.2800292969,
            [4] = 4528.2202148438,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.4,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [190] =
        {
            [1] = 1148.7399902343,
            [2] = 765.8200683594,
            [3] = 3364.8000488281,
            [4] = 4768.2299804688,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.5,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [191] =
        {
            [1] = 373.7099609375,
            [2] = 249.1298828125,
            [3] = 2960.2800292969,
            [4] = 4704.8798828125,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.6,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [192] =
        {
            [1] = 293.2600097656,
            [2] = 195.50701904297,
            [3] = -1978.2900390625,
            [4] = 605.79901123047,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.7,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [193] =
        {
            [1] = 247.9299316406,
            [2] = 165.28799438477,
            [3] = -2400.330078125,
            [4] = 579.39599609375,
            ["mapType"] = 4,
            ["parentMapID"] = 118,
            ["mapID"] = 605.8,
            ["name"] = "Icecrown Citadel",
            ["instance"] = 631,
        },
        [200] =
        {
            [1] = 752.08331298828,
            [2] = 502.0832519531,
            [3] = 902.08331298828,
            [4] = 3429.1665039062,
            ["mapType"] = 6,
            ["parentMapID"] = 115,
            ["mapID"] = 610,
            ["name"] = "The Ruby Sanctum",
            ["instance"] = 724,
        },
    }

    for id, data in pairs(UiMapData) do
        QuestieCompat.UiMapData[id] = data
    end
    UiMapData = nil

    QuestieCompat.worldMapData[0] = { 48033.24, 32020.8, 36867.97, 14848.84 }
    QuestieCompat.worldMapData[1] = { 47908.72, 31935.28, 8552.61, 18467.83 }
    QuestieCompat.worldMapData[571] = { 47662.7, 31772.19, 25198.53, 11072.07 }
end