---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- Load the base NPCs for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit an NPC, do so in sodNPCFixes.lua
function SeasonOfDiscovery:LoadBaseNPCs()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local sortKeys = QuestieDB.sortKeys

    return {
        [162539] = {
            [npcKeys.name] = "World Talent Master",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [169106] = {
            [npcKeys.name] = "Shea Dorrisist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [173338] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176552] = {
            [npcKeys.name] = "Orgrimmar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176553] = {
            [npcKeys.name] = "Stormwind",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176663] = {
            [npcKeys.name] = "Call for Help Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [176721] = {
            [npcKeys.name] = "Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [177063] = {
            [npcKeys.name] = "Spellcaster Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [183709] = {
            [npcKeys.name] = "Season 01 Controller - Era",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [183713] = {
            [npcKeys.name] = "Season 02 Controller - Fresh Start",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [184314] = {
            [npcKeys.name] = "Beta Vendor and Raid Teleporter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [184383] = {
            [npcKeys.name] = "Sulfuron Harbinger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185273] = {
            [npcKeys.name] = "Firemaw Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185320] = {
            [npcKeys.name] = "Unstable Chromatic Drake",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185331] = {
            [npcKeys.name] = "Avelina Lilly Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185332] = {
            [npcKeys.name] = "Isaac Pearson Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185336] = {
            [npcKeys.name] = "Jezelle's Incubus",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{77.4, 13.8},{77.8, 14.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185342] = {
            [npcKeys.name] = "Ruby Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185371] = {
            [npcKeys.name] = "Emerald Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185378] = {
            [npcKeys.name] = "Azure Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185379] = {
            [npcKeys.name] = "Obsidian Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185380] = {
            [npcKeys.name] = "Bronze Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185536] = {
            [npcKeys.name] = "Suppression Device Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185585] = {
            [npcKeys.name] = "Flame Patch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185590] = {
            [npcKeys.name] = "Dream Fog",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185605] = {
            [npcKeys.name] = "Chromatic Drakonid Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185631] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185650] = {
            [npcKeys.name] = "Dream Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185658] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185746] = {
            [npcKeys.name] = "Bouncing Bolt",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185760] = {
            [npcKeys.name] = "Nightmare Brambles",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185859] = {
            [npcKeys.name] = "Wing Buffet Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [185868] = {
            [npcKeys.name] = "[DNT] Electricity Visual Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [186130] = {
            [npcKeys.name] = "[DNT] Ebonroc and Flamegor Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [186348] = {
            [npcKeys.name] = "The Prophet Skeram",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [186506] = {
            [npcKeys.name] = "[DNT] Frost Tomb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187162] = {
            [npcKeys.name] = "Eye of C'Thun",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187237] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187274] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187309] = {
            [npcKeys.name] = "Eye of C'Thun",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187327] = {
            [npcKeys.name] = "Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187345] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187346] = {
            [npcKeys.name] = "Giant Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187383] = {
            [npcKeys.name] = "AQ40 Bonus Difficulty Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187564] = {
            [npcKeys.name] = "AQ40 Bonus Difficulty Indicator",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187664] = {
            [npcKeys.name] = "Fungal Spore Cluster",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187724] = {
            [npcKeys.name] = "Mad Scientist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187725] = {
            [npcKeys.name] = "Deathknight Captain",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187728] = {
            [npcKeys.name] = "Necropolis Acolyte",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187729] = {
            [npcKeys.name] = "Patchwork Golem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187798] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187801] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187832] = {
            [npcKeys.name] = "Skeletal Hitching Post",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187978] = {
            [npcKeys.name] = "Thaddius Mechanic Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [187993] = {
            [npcKeys.name] = "Plagued Ghoul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188018] = {
            [npcKeys.name] = "Dread Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188109] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188110] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188111] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188119] = {
            [npcKeys.name] = "Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188131] = {
            [npcKeys.name] = "Giant Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188134] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188147] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188148] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188170] = {
            [npcKeys.name] = "Giant Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188178] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188182] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [188183] = {
            [npcKeys.name] = "Giant Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [189047] = {
            [npcKeys.name] = "[DNT] Quick Sand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [200571] = {
            [npcKeys.name] = "Artificer Terothordius",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [201722] = {
            [npcKeys.name] = "Ghamoo-ra",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [201854] = {
            [npcKeys.name] = "Cutty",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{50, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [201933] = {
            [npcKeys.name] = "Spellfrost Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202060] = {
            [npcKeys.name] = "Frozen Murloc",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{76.8, 51.4},{77, 51.8},},
                [85] = {{66.2, 40.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202079] = {
            [npcKeys.name] = "Shadowfiend",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202093] = {
            [npcKeys.name] = "Polymorphed Apprentice",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{28.4, 82.4},{28.4, 83},{28.6, 83.2},{28.8, 82.4},{29.4, 84},{29.6, 83.4},{29.6, 84},{29.6, 84.6},{30.4, 90.4},{30.4, 90.6},{30.8, 89.4},{30.8, 90.2},{31, 90.6},{31.2, 68.4},{31.2, 68.8},{31.2, 87},{31.6, 90},{31.8, 90.6},{34.4, 83.2},{34.8, 82.2},{34.8, 83},{34.8, 84},{37.2, 77.6},{37.4, 77.2},{37.8, 77.6},{38, 77},{38.2, 76.4},{38.6, 76},{40.4, 82.8},{40.4, 89.4},{40.4, 89.8},{40.6, 87.6},{40.6, 89.4},{40.6, 90},{44.4, 56.2},{44.4, 56.6},{44.4, 57.6},{44.6, 56.6},{44.6, 57.6},{44.8, 56.2},{46, 86.4},{46, 86.6},{46.2, 70.4},{46.2, 87.6},{46.4, 69.4},{46.4, 70.8},{46.6, 70.4},{46.8, 70.6},{48.4, 52.4},{48.4, 52.8},{48.4, 54.2},{48.4, 54.8},{48.4, 81.4},{48.6, 52.6},{48.6, 53.6},{48.6, 55},{48.8, 55.6},{48.8, 81.2},{48.8, 81.8},{49, 51.2},{49, 51.6},{49.2, 73.4},{49.4, 73.6},{49.8, 73.2},{49.8, 73.6},{51.4, 84},{56.2, 81},{56.2, 81.6},{56.4, 80.2},{56.6, 80.4},{56.6, 81},{58.4, 60},{58.6, 60.2},{59, 59.4},{61.4, 77},{61.6, 77},{61.6, 77.6},{62.4, 63},{62.4, 63.6},{62.6, 78},{62.8, 62.8},{62.8, 63.6},{63.2, 62.2},{63.6, 62.8},{65, 41.2},{65.2, 41.6},{65.6, 42.8},{65.8, 41.2},{65.8, 42.2},{66.8, 81.4},{67, 82.2},{67, 82.6},{68.8, 74.6},{69.4, 76.2},{70, 76.2},{70.2, 63.6},{70.2, 75.4},{70.4, 63.4},{70.6, 63.2},{70.6, 63.6},{71, 76},{73.4, 41.2},{73.8, 40.4},{74, 41},{77.4, 39.4},{77.4, 40},{77.6, 39.4},{77.6, 39.8},{78.4, 75.2},{79, 79.6},{79.4, 64.2},{79.4, 65.6},{79.4, 78.4},{79.4, 78.8},{79.6, 79},{79.6, 80.2},{79.8, 64.6},{80, 64.4},{80, 65.8},{80.4, 49.8},{80.4, 50.6},{80.6, 50.4},{80.6, 50.6},{80.8, 49.4},{82.4, 70},{82.4, 70.8},{82.4, 86},{82.4, 86.8},{82.6, 71.6},{82.8, 70.6},{82.8, 86.2},{83, 70.4},{83.4, 83.4},{83.4, 83.8},{83.4, 86.8},{83.8, 84},{83.8, 84.6},{84, 83.4},{85.4, 65.4},{85.4, 66},{85.8, 65.2},{85.8, 67.2},{86, 66.2},{86.6, 65.6},{87, 81.8},{87.2, 82.6},{87.6, 82.2},{90.2, 77.2},{90.4, 77.6},{90.6, 77},{90.6, 77.8},{90.8, 76.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202116] = {
            [npcKeys.name] = "Cut-throat Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{57.4, 28.8},{61.4, 29.2},{61.8, 29.2},{62.8, 29},{63.2, 29.6},},
                [1537] = {{44, 11},{47.4, 12.6},{49.2, 12.6},{50.4, 11.6},{51.2, 12.6},{51.4, 10.6},{51.4, 11.8},{51.8, 12.4},{51.8, 12.8},{52, 10.6},{52.6, 9.6},{52.8, 9},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202387] = {
            [npcKeys.name] = "Eye of the Void",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202390] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202391] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202392] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202699] = {
            [npcKeys.name] = "Baron Aquanis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202838] = {
            [npcKeys.name] = "Fathom Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202839] = {
            [npcKeys.name] = "Riptide Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [202840] = {
            [npcKeys.name] = "Torrent Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203079] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{50.2, 49},{51.8, 48.8},{52.4, 47.4},{52.6, 45},{52.6, 48.8},{53.4, 47.4},{53.4, 47.8},{53.6, 47.4},{53.6, 47.6},},
                [12] = {{22.2, 73.4},{22.2, 73.6},{22.4, 72.4},{22.6, 73.2},{22.8, 73.6},{23.4, 74.8},{23.6, 74},{24.2, 70.6},{24.2, 74.6},{24.4, 69.4},{24.6, 75.2},{25.2, 70},{25.2, 70.6},{25.4, 69.2},{25.6, 70},{25.6, 74.2},{26.2, 72.2},{28.8, 72.2},{29.8, 74.8},{29.8, 76.4},{30, 73},{30.2, 73.6},{30.6, 73.4},{30.6, 74.2},{35.6, 79.2},{35.6, 83.6},{36, 80.4},{36, 80.6},{36, 84.6},{36.2, 82.4},{36.6, 79.8},{36.8, 83.4},{37, 80.8},{37.4, 74.6},{37.6, 78.6},{38.4, 75.4},{38.4, 75.8},{38.4, 76.8},{38.6, 75.4},{38.6, 75.6},{38.8, 74.4},{39.8, 75.2},{40, 72.6},{40.4, 74.4},{40.8, 74.6},{41, 74.4},{41.2, 73},{41.4, 71},{41.4, 75.8},{41.6, 74.6},{41.6, 76.6},{42.2, 69.2},},
                [14] = {{36, 47.4},{36, 48},{37, 46.8},{40.6, 50.6},{41, 49.4},{41.2, 48.4},{41.2, 49.6},{41.8, 48.8},{54.4, 40.4},{55, 39.4},{55.2, 38.4},{55.8, 27.8},{56, 38.2},{56, 38.6},{56.4, 21.4},{56.4, 21.8},{56.4, 27},{56.6, 21.4},{56.6, 21.6},{56.6, 26.6},{56.6, 37.4},},
                [85] = {{78.2, 63.4},{78.4, 65},{79.4, 64.4},{79.4, 64.8},{79.6, 64.4},{79.6, 65.2},},
                [141] = {{39.6, 37.6},{39.8, 37.4},{39.8, 69.4},{39.8, 69.6},{43.8, 76.8},{54.4, 66},{54.8, 66},{62.4, 71.6},{62.6, 71.8},},
                [215] = {{38, 55},{38.2, 54.2},{40.4, 52.8},{40.6, 53.2},{40.6, 53.8},{45.4, 36.4},{45.4, 37},{45.6, 36.4},{46, 37.2},{52, 39.2},{52.4, 40.4},{60.2, 67.4},{60.2, 67.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203138] = {
            [npcKeys.name] = "Anvilrage Overseer",
            [npcKeys.minLevel] = 48,
            [npcKeys.maxLevel] = 49,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203139] = {
            [npcKeys.name] = "Son of Arugal",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{35.2, 16.2},{35.4, 19.2},{35.6, 18.8},{36, 16.4},{36, 18.2},{36.2, 16.6},{36.2, 19.8},{36.2, 22.2},{36.2, 28.6},{36.4, 15.2},{36.4, 20.6},{36.4, 24.8},{36.6, 15.6},{36.8, 21.2},{36.8, 27.8},{37.4, 15.4},{37.4, 16.8},{37.4, 24},{37.6, 15.8},{37.8, 25.8},{38, 14.2},{38, 24},{38, 28},{38.2, 16.8},{38.4, 14.8},{38.8, 27.2},{39, 17.2},{39.2, 14.2},{39.2, 16.4},{39.2, 26},{39.4, 15.2},{39.8, 15.4},{39.8, 18},{39.8, 27},{40, 16.4},{40, 28.2},{40.2, 30.8},{40.4, 16.6},{40.4, 29.2},{40.6, 18.4},{40.8, 17.2},{41, 19.4},{41, 19.6},{41.2, 29.4},{41.4, 29.6},{41.6, 18.2},{41.6, 21.6},{41.8, 20},{42, 30.6},{42.2, 20.8},{42.4, 30.2},{42.6, 21.4},{42.6, 28.6},{43, 20.4},{43, 22},{43, 29.6},{43.6, 19},{43.6, 21.4},{43.6, 21.8},{43.6, 28},{43.6, 29.6},{44.2, 78.4},{44.4, 18.2},{44.4, 19.8},{44.4, 29.2},{44.6, 29.2},{44.8, 17.8},{44.8, 20.8},{45, 29.8},{45, 81.6},{45.2, 17},{45.2, 81.2},{45.4, 19},{45.4, 28.2},{45.4, 34.2},{45.4, 79.2},{45.4, 83.2},{45.6, 16.8},{45.6, 29.2},{45.6, 82},{45.6, 83.4},{45.6, 84.6},{45.8, 21.4},{46, 17.6},{46, 27.4},{46, 79},{46, 83.6},{46.2, 18.8},{46.2, 33.4},{46.4, 26.2},{46.4, 27.6},{46.4, 32.2},{46.4, 33.6},{46.6, 18},{46.6, 19.4},{46.6, 25.2},{46.6, 81.2},{46.6, 83.6},{47, 20.6},{47, 26.8},{47.2, 19.8},{47.2, 32.2},{47.2, 82.4},{47.2, 83.4},{47.4, 26.2},{47.4, 33},{47.4, 34},{47.4, 34.6},{47.6, 31.8},{47.6, 33.4},{47.6, 33.6},{47.8, 19},{47.8, 31.4},{47.8, 81.6},{48, 19.6},{48, 21.8},{48.2, 26},{48.2, 34.6},{48.2, 38.4},{48.2, 77.2},{48.4, 20.8},{48.4, 25.4},{48.6, 20},{48.6, 31.6},{48.6, 34.8},{48.8, 26.6},{48.8, 31},{48.8, 32.8},{48.8, 72.4},{48.8, 82.6},{49, 18.8},{49, 26.2},{49, 75.6},{49.2, 20.8},{49.2, 22.6},{49.2, 25.4},{49.2, 37},{49.4, 36.4},{49.6, 23.4},{49.6, 33.4},{49.6, 82.4},{49.6, 83.6},{49.8, 17.2},{49.8, 33.6},{49.8, 76.4},{49.8, 83.2},{50, 25},{50.2, 74.8},{50.2, 79},{50.4, 36.6},{50.6, 34.8},{50.6, 35.8},{50.8, 79.2},{51, 78.4},{51.4, 36.8},{51.6, 76.4},{51.6, 77.6},{52, 37.8},{52, 72},{52.2, 75},{52.2, 77.4},{52.6, 76.2},{52.8, 74.2},{53.4, 76.6},{53.6, 75.8},{54, 74.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203147] = {
            [npcKeys.name] = "Whirlpool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203218] = {
            [npcKeys.name] = "Giant Whirlpool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203226] = {
            [npcKeys.name] = "Viktoria Woods",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{69.4, 50},{69.6, 50.6},{69.8, 50},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203279] = {
            [npcKeys.name] = "Riptide Essence",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203475] = {
            [npcKeys.name] = "Liv Bradford",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{22.4, 64.4},{22.4, 64.6},{22.6, 64.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203478] = {
            [npcKeys.name] = "Stuart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{21.4, 59.6},{21.4, 61.8},{21.4, 62.8},{21.6, 62.8},{21.8, 62.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [203694] = {
            [npcKeys.name] = "Riding Lobster (Dead)",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204068] = {
            [npcKeys.name] = "Lady Sarevess",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204070] = {
            [npcKeys.name] = "Soboz",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{42.2, 35.4},{42.2, 35.6},},
                [14] = {{67.4, 87.8},{67.6, 87.8},},
                [1497] = {{24, 41.4},{24, 41.6},},
                [1519] = {{25, 77.6},{25.2, 77.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204091] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204253] = {
            [npcKeys.name] = "Blackfathom Elite Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204256] = {
            [npcKeys.name] = "Damien Kane",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{44, 66.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204346] = {
            [npcKeys.name] = "Treant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204503] = {
            [npcKeys.name] = "Dead Acolyte",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{56.4, 57.4},{56.6, 57.4},{56.6, 57.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204545] = {
            [npcKeys.name] = "Tim's Stalker 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204645] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204675] = {
            [npcKeys.name] = "Rune Scrying Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204758] = {
            [npcKeys.name] = "Exploded Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204827] = {
            [npcKeys.name] = "Adventurer's Remains",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{43, 49.4},{43, 49.6},},
                [12] = {{52.2, 84.4},{52.2, 84.6},},
                [14] = {{48, 79.4},{48, 79.6},},
                [141] = {{33.6, 35.6},},
                [215] = {{60.4, 33.4},{60.4, 33.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204921] = {
            [npcKeys.name] = "Gelihast",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204937] = {
            [npcKeys.name] = "Adventurer's Spirit",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{43, 49.6},},
                [12] = {{52.2, 84.4},{52.2, 84.6},},
                [14] = {{48, 79.4},{48, 79.6},},
                [141] = {{33.4, 35.6},{33.6, 35.6},},
                [215] = {{60.4, 33.4},{60.4, 33.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204940] = {
            [npcKeys.name] = "Puddle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204960] = {
            [npcKeys.name] = "Chomp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204961] = {
            [npcKeys.name] = "Snarly",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204962] = {
            [npcKeys.name] = "Tidelurker Mrrglrlr",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [204989] = {
            [npcKeys.name] = "Wounded Adventurer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{61.8, 47},{61.8, 47.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205153] = {
            [npcKeys.name] = "Ada Gelhardt",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{4.2, 28.6},{4.4, 28.2},{4.6, 28.2},{4.6, 28.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205278] = {
            [npcKeys.name] = "Brother Romulus",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{38.2, 28.2},{38.4, 29},{38.6, 27.4},{38.6, 28.4},{38.6, 28.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205382] = {
            [npcKeys.name] = "Mokwa",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{35.2, 57.2},{35.2, 57.6},{35.6, 57.6},{35.8, 57.2},{36, 56.2},{36.6, 56.6},{37.8, 55.6},{37.8, 56.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205383] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205422] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205423] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205635] = {
            [npcKeys.name] = "Takoda Sunmane",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{46.2, 60.2},{46.2, 60.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205692] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{58.8, 54.2},{59, 54.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205700] = {
            [npcKeys.name] = "Venture Co. Poacher",
            [npcKeys.minLevel] = 6,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{58.2, 54},{58.8, 54.2},{59, 54.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205724] = {
            [npcKeys.name] = "Blackfathom Tendril",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205729] = {
            [npcKeys.name] = "Boarton Shadetotem",
            [npcKeys.minLevel] = 4,
            [npcKeys.maxLevel] = 4,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{39.4, 64.4},{39.4, 65.2},{39.4, 65.6},{39.4, 66.6},{39.6, 64.4},{39.6, 65.4},{39.6, 65.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {76156,76160,76240},
            [npcKeys.questEnds] = {76156,76160,76240},
        },
        [205733] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205765] = {
            [npcKeys.name] = "Murloc Egg",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205767] = {
            [npcKeys.name] = "Void Murloc",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [205805] = {
            [npcKeys.name] = "Water Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206152] = {
            [npcKeys.name] = "SoD Test Dummy 25",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206153] = {
            [npcKeys.name] = "SoD Test Dummy 26",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206154] = {
            [npcKeys.name] = "SoD Test Dummy 27",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206155] = {
            [npcKeys.name] = "SoD Test Dummy 28",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206217] = {
            [npcKeys.name] = "Bubble Beam Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206245] = {
            [npcKeys.name] = "Unleashed Nature Spirit",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{67, 58},{67, 58.6},},
                [215] = {{37.6, 49.6},{37.8, 49.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [206248] = {
            [npcKeys.name] = "Wooden Effigy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{67, 58.2},},
                [215] = {{37.4, 49.4},{37.4, 49.6},{37.8, 49.4},{37.8, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207010] = {
            [npcKeys.name] = "Telemachus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207356] = {
            [npcKeys.name] = "Lorgus Jett",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207358] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207359] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207367] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207397] = {
            [npcKeys.name] = "Corrupted Windfury Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207457] = {
            [npcKeys.name] = "Corrupted Lightning Shield Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207515] = {
            [npcKeys.name] = "Lurkmane",
            [npcKeys.minLevel] = 6,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{30.4, 61.4},{30.4, 61.8},{30.6, 63},{30.8, 61.4},{30.8, 61.6},{31, 60.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207520] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207527] = {
            [npcKeys.name] = "Corrupted Molten Fury",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207576] = {
            [npcKeys.name] = "Corrupted Molten Fury Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207577] = {
            [npcKeys.name] = "Lunar Stone",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{35, 69.4},{35, 69.6},{35.4, 68.2},{35.4, 70.6},{35.6, 70.4},{35.6, 70.6},{35.8, 68},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207588] = {
            [npcKeys.name] = "Mulgore Lunar Stone Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207637] = {
            [npcKeys.name] = "Vateya Timberhoof",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{46.4, 61.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207743] = {
            [npcKeys.name] = "Netali Proudwind",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{28.4, 18.2},{28.4, 19.2},{28.6, 18.2},{28.6, 18.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207754] = {
            [npcKeys.name] = "Mooart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{26.4, 18.4},{26.4, 18.8},{26.4, 19.8},{26.6, 19},{26.6, 19.8},{27, 18.4},{27.2, 14.4},{28, 21.4},{28.2, 22.4},{28.6, 23.2},{29.4, 21.6},{31.6, 27.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [207957] = {
            [npcKeys.name] = "Vahi Bonesplitter",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{53, 43.4},{53, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208023] = {
            [npcKeys.name] = "Gru'ark",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{49.6, 65},{52.6, 57.4},{53.6, 57.4},{54.8, 57},{55.8, 57},{56.4, 58},{57, 44.6},{57, 56},{57.6, 57},{58, 48.4},{58, 48.8},{58, 55.2},{58.2, 51.2},{58.2, 54.4},{58.4, 50.2},{58.4, 52},{58.4, 52.6},{58.4, 56.2},{58.6, 51.4},{58.6, 51.8},{58.8, 53.4},{58.8, 53.6},{61.4, 44.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208036] = {
            [npcKeys.name] = "Ba'so",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{51.8, 58.6},{52, 58.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208071] = {
            [npcKeys.name] = "Back-alley Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{55.8, 44.6},{56, 44},{56.2, 42.8},{56.6, 44.2},{57.4, 45.2},{58.8, 50.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208124] = {
            [npcKeys.name] = "Raluk",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{67.6, 73},{67.8, 68.8},{68.2, 70.4},{68.4, 71.4},{68.4, 71.6},{68.4, 74.2},{68.6, 71.4},{68.6, 71.6},{71, 72},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208127] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208128] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208158] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208179] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{40.4, 52},{40.6, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208180] = {
            [npcKeys.name] = "Razormane Poacher",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8, 49.8},{29, 49.4},},
                [14] = {{40.4, 52},{40.6, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208184] = {
            [npcKeys.name] = "Razzil",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{52.2, 44},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208196] = {
            [npcKeys.name] = "Gillgar",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{25.2, 49},{25.4, 47.4},{25.4, 48.2},{25.6, 48.2},{25.6, 48.6},{26.2, 47.4},{26.4, 46.4},{26.6, 46.8},{27.2, 46.4},{27.6, 46.4},{28.4, 46.8},{29, 46.6},{29.6, 46.6},{29.8, 46},{30.4, 49.4},{31, 48},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208226] = {
            [npcKeys.name] = "Darmak Bloodhowl",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{54.6, 41.4},{54.6, 41.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208275] = {
            [npcKeys.name] = "Frozen Makrura",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{58.6, 45.4},{58.6, 45.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208307] = {
            [npcKeys.name] = "Serpent Loa",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{55.4, 72.4},{55.4, 72.6},},
                [17] = {{51.4, 29.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208309] = {
            [npcKeys.name] = "Loa Altar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{55.2, 72.6},{55.4, 72.4},},
                [17] = {{51.4, 29.4},{51.6, 29.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208518] = {
            [npcKeys.name] = "Gaeriyan",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{54, 23.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208546] = {
            [npcKeys.name] = "Brazier of Embersight",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208565] = {
            [npcKeys.name] = "Altar of the Light",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8, 66.4},{28.8, 66.6},},
                [38] = {{37.4, 46.2},{37.6, 46.2},},
                [40] = {{52.8, 52.8},},
                [1537] = {{31.2, 21.4},{31.4, 21.6},{31.8, 22},{32, 20.4},{32, 20.6},{32.6, 21.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208619] = {
            [npcKeys.name] = "Dorac Graves",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{47.2, 70.4},{47.2, 71.2},{48, 70.6},{48.2, 69.8},{48.2, 71.6},{48.4, 69.4},{48.6, 69.2},{48.6, 69.8},{48.6, 70.6},{48.6, 71.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208638] = {
            [npcKeys.name] = "Fyodi",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{27.8, 38.2},{28.4, 38.6},{28.4, 42.8},{28.4, 43.6},{28.4, 44.8},{28.6, 43.8},{28.8, 39.6},{28.8, 44.8},{29.2, 38.4},{29.2, 38.8},{29.2, 43.4},{29.4, 42.2},{29.6, 38.4},{29.6, 42.2},{29.6, 42.8},{29.6, 45.6},{30, 39},{30.2, 43.6},{30.4, 36.6},{30.4, 40.2},{30.4, 41.2},{30.6, 37.4},{30.6, 42.4},{30.8, 39.6},{31, 39.2},{31.4, 38.4},{31.6, 39},{31.6, 40},{32.2, 36},{32.2, 38},{32.4, 37.2},{32.6, 36.8},{33, 36.4},{33.4, 34},{33.4, 35.2},{33.4, 37.6},{33.6, 34.4},{33.6, 36},{33.8, 35.2},{33.8, 37.2},{35, 33},{35, 34.6},{35.2, 33.8},{35.2, 36.4},{35.2, 36.6},{35.4, 38},{35.6, 33.2},{35.8, 33.8},{35.8, 37},{36, 36.4},{36.6, 36},{36.6, 36.6},{37.6, 35.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208652] = {
            [npcKeys.name] = "Junni Steelpass",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{46.4, 53.2},{46.6, 53.2},{46.6, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208682] = {
            [npcKeys.name] = "Denton Bleakway",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{83.2, 26.6},{83.4, 25.4},{83.4, 25.8},{83.4, 27.6},{83.6, 24.8},{83.6, 26},{83.6, 27.4},{83.6, 27.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208711] = {
            [npcKeys.name] = "Toby",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{63.4, 50.2},{63.6, 50.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208712] = {
            [npcKeys.name] = "Odd Melon",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{30.2, 47.2},{33.4, 49.4},{33.4, 49.8},{33.6, 49.4},{33.6, 49.8},{34.8, 51.2},{35.4, 49},{35.6, 49},{36.4, 50.8},{36.8, 51},{40.2, 42},{44, 38.6},{44.2, 38.4},{44.8, 28.4},{44.8, 28.6},{45.2, 33.4},{47.2, 50.4},{47.2, 50.8},{47.4, 28.4},{47.4, 28.6},{49.4, 46.2},{49.4, 46.8},{49.6, 46.4},{49.6, 46.6},{49.8, 59.4},{50, 50.6},{50, 59.6},{50.2, 50.4},{50.4, 31},{50.4, 61.8},{50.6, 31},{51.4, 57.2},{51.6, 57.2},{51.6, 57.6},{52.2, 30.2},{52.6, 30},{52.8, 57.6},{53.8, 58.6},{53.8, 59.8},{54, 28},{54, 56.4},{54, 56.8},{54, 58.2},{57.4, 40.4},{57.4, 40.6},{57.6, 40.2},{58.4, 35.4},{58.4, 35.6},{58.6, 35.2},{58.8, 58.4},{58.8, 58.6},{59.8, 33},{60, 37},{65.4, 62.8},{65.6, 62.8},{71.4, 34},{72.2, 50.4},{72.2, 50.8},{75, 61.4},{75.2, 61.6},{76, 59.4},{76, 59.6},{76.2, 51.2},{76.2, 51.8},{76.4, 61.4},{76.4, 61.6},{76.6, 61.4},{76.6, 61.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208752] = {
            [npcKeys.name] = "Frozen Trogg",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{69.2, 58.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208758] = {
            [npcKeys.name] = "Junior Apothecary",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208802] = {
            [npcKeys.name] = "Wounded Adventurer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{25.4, 43.4},{25.4, 43.6},{25.6, 43.4},{25.6, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208809] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208810] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208811] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208812] = {
            [npcKeys.name] = "Jorul",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{35.4, 43.6},{35.8, 42.6},{36, 42.4},{36.4, 38.8},{36.4, 40.4},{36.6, 40.4},{37, 41},{37.2, 42.4},{37.4, 42.6},{37.6, 41.4},{37.8, 42.4},{38, 38.6},{38.4, 43.4},{38.4, 43.6},{38.6, 42},{38.6, 43.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208841] = {
            [npcKeys.name] = "Reverent Blacksmith",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208842] = {
            [npcKeys.name] = "The Gardener",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208843] = {
            [npcKeys.name] = "Abominable Snowman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208844] = {
            [npcKeys.name] = "Crimson Emissary",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208845] = {
            [npcKeys.name] = "Par'kourc",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208846] = {
            [npcKeys.name] = "Sun Admirer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208847] = {
            [npcKeys.name] = "The Snatcher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208875] = {
            [npcKeys.name] = "Back-alley Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{55.8, 44.6},{56, 43.8},{56.2, 42.8},{57, 44.2},{57.4, 45.2},{58.4, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208876] = {
            [npcKeys.name] = "Cut-throat Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{59, 27.8},{61.4, 29.4},{61.4, 29.6},{61.8, 29.2},{62.4, 29.6},{62.8, 29.6},{63.2, 29.2},},
                [1537] = {{50.2, 11.6},{50.6, 10.2},{51, 12.2},{51.4, 11},{51.6, 12.4},{52, 12.6},{52.8, 9.2},{52.8, 10.4},{57, 12},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208886] = {
            [npcKeys.name] = "Blackrat",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{57.2, 45.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208919] = {
            [npcKeys.name] = "Blueheart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{61.6, 51.4},{61.6, 52.8},{61.8, 51.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208920] = {
            [npcKeys.name] = "Penny Hawkins",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{61.8, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208927] = {
            [npcKeys.name] = "Dead Acolyte",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{76.4, 44.8},{76.6, 44.8},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208974] = {
            [npcKeys.name] = "Dark Iron Poacher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [208975] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209002] = {
            [npcKeys.name] = "Gaklik Voidtwist",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{47.2, 53.4},{47.2, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209004] = {
            [npcKeys.name] = "Bruart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{59.4, 75.8},{60.8, 70.4},{61.2, 71.6},{63.6, 73},{65, 70.4},{65.2, 74.2},{65.4, 77},{66.2, 70.6},{66.4, 67.2},{66.4, 69.6},{66.6, 71.2},{66.6, 73.4},{66.6, 77},{66.8, 69.2},{66.8, 75.2},{67, 71.6},{67.2, 77.8},{67.6, 73},{67.6, 74.8},{68, 67.4},{68, 69.6},{68.8, 71.8},{69, 71},{69, 73.2},{69, 73.6},{69.2, 69.2},{69.4, 68.4},{69.4, 76.8},{69.8, 72},{70, 74.4},{70.2, 72.8},{70.8, 72.4},{71.2, 73.2},{71.2, 74.8},{71.2, 75.8},{72, 73.4},{72, 75.2},{72, 75.6},{72.2, 74},{72.2, 76.8},{72.6, 73.8},{72.6, 76},{73, 74.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209209] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209213] = {
            [npcKeys.name] = "Murloc Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209214] = {
            [npcKeys.name] = "Blackfathom Murloc",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209511] = {
            [npcKeys.name] = "Oasis Snapjaw Hatchling",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{48.2, 40.2},{55.8, 42.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209524] = {
            [npcKeys.name] = "Patrolling Cheetah",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{43.2, 56.6},{43.4, 56.4},{43.6, 56.6},{43.8, 56},{44.4, 55.4},{44.6, 55.2},{44.6, 55.6},{44.6, 56.8},{50.2, 44.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209548] = {
            [npcKeys.name] = "Secret Agent",
            [npcKeys.minLevel] = 77,
            [npcKeys.maxLevel] = 77,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{95, 84.2},},
                [17] = {{50.4, 79.6},},
                [45] = {{25, 20},},
                [267] = {{88.2, 47.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209607] = {
            [npcKeys.name] = "Lieutenant Stonebrew",
            [npcKeys.minLevel] = 17,
            [npcKeys.maxLevel] = 17,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{61.4, 54.8},{62.4, 56.2},{62.6, 56.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209608] = {
            [npcKeys.name] = "Delwynna",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{63.2, 22.6},{63.4, 21.4},{63.4, 21.8},{63.6, 22},{64, 21.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209678] = {
            [npcKeys.name] = "Twilight Lord Kelris",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209742] = {
            [npcKeys.name] = "Desert Mirage",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{54.4, 36},{54.6, 36.6},{54.8, 35.4},{54.8, 35.8},{55.4, 33.4},{55.4, 33.8},{55.8, 34},{57.4, 35.8},{57.4, 38.4},{57.4, 38.6},{57.6, 35.4},{57.6, 35.8},{57.6, 38.4},{57.6, 38.6},{58.8, 37.4},{58.8, 37.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209758] = {
            [npcKeys.name] = "Invading Nightmare",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209773] = {
            [npcKeys.name] = "Dream Copy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209797] = {
            [npcKeys.name] = "Bruuz",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{63.2, 38.6},{63.6, 38.4},{64.4, 39},{64.4, 39.6},{65, 37.2},{65.2, 39.4},{65.2, 39.6},{66.4, 39.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209806] = {
            [npcKeys.name] = "Waterfall Test",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209811] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.4, 46.2},{46.6, 46.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209812] = {
            [npcKeys.name] = "Fallenroot Poacher",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{43.2, 42.6},{45.2, 46.4},{45.2, 47.2},{45.4, 47.6},{45.4, 49.4},{45.4, 49.6},{46, 47.8},{46, 49.6},{46.2, 45.4},{46.2, 46.6},{46.4, 44.2},{46.4, 46.4},{46.4, 48.8},{46.6, 45.4},{46.6, 46.2},{46.6, 46.6},{46.8, 43.6},{47, 49.6},{47.4, 49.4},{47.6, 44.4},{47.6, 50.2},{48, 50.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209815] = {
            [npcKeys.name] = "Phantasmal Priestess",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209830] = {
            [npcKeys.name] = "Phantasmal Statue",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209872] = {
            [npcKeys.name] = "Syllart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{56.2, 59.4},{56.2, 59.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209889] = {
            [npcKeys.name] = "Barebones",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{56, 60.4},{56, 61.6},{56.2, 60.8},{56.6, 61.2},},
                [1637] = {{51.6, 76.8},{51.8, 75.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209908] = {
            [npcKeys.name] = "Heretic Idol",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{71.4, 27.2},{71.8, 27},{71.8, 27.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209928] = {
            [npcKeys.name] = "Mowgh",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.4, 32.6},{46.4, 33.8},{47.4, 32.4},{47.4, 32.8},{47.4, 33.6},{47.6, 32.6},{48, 31.6},{48.2, 31.4},{48.6, 31.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209939] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209940] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209941] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209948] = {
            [npcKeys.name] = "Relaeron",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.2, 9},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209949] = {
            [npcKeys.name] = "Sickly Deer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.2, 8.4},{39.2, 9},{39.4, 9.8},{39.6, 9.2},{39.6, 9.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209954] = {
            [npcKeys.name] = "Demonic Remains",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{72.4, 68.4},{72.4, 68.6},{72.6, 68.4},{72.6, 68.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [209958] = {
            [npcKeys.name] = "Graix",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{71.2, 68.2},{72.4, 68.4},{72.4, 68.8},{72.6, 67.8},{72.6, 68.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210006] = {
            [npcKeys.name] = "Battle Totem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210107] = {
            [npcKeys.name] = "Kackle",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{49.8, 60.4},{50.2, 53.8},{52.4, 54.4},{52.4, 55.8},{53.2, 54.4},{53.2, 56.6},{53.4, 53.4},{53.4, 55.4},{53.4, 56.2},{54, 55.8},{54.2, 53.2},{54.2, 54},{54.2, 55.2},{54.4, 56.6},{54.6, 52.2},{54.6, 55.6},{54.8, 54.4},{54.8, 54.6},{54.8, 56.6},{55, 52.6},{55.6, 52.2},{55.6, 54.4},{55.6, 55},{55.6, 57},{55.8, 53.2},{55.8, 57.6},{56.4, 55.6},{57.2, 64.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210451] = {
            [npcKeys.name] = "Lady Sedorax",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{54.8, 31.6},{55, 32.6},{55.2, 33.8},{55.2, 35.2},{55.4, 36.4},{55.4, 36.8},{55.6, 35.2},{55.6, 36.4},{55.6, 36.6},{55.8, 34.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210482] = {
            [npcKeys.name] = "Paxnozz",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{46.4, 14.4},{46.4, 17},{46.6, 13.8},{46.6, 17},{47, 15.4},{47, 15.6},{47.8, 15.2},{48, 13.4},{48, 14},{48, 18},{48.4, 16.4},{48.4, 16.6},{48.6, 13.8},{48.6, 16.6},{48.8, 15.6},{49, 11.8},{49, 13.2},{49, 14.8},{49.6, 14.2},{50, 14.6},{50.2, 12.6},{50.4, 11.4},{50.4, 12},{50.8, 12.4},{51, 13.6},{51.2, 13.4},{51.8, 13.2},{51.8, 15.6},{52.4, 17.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210483] = {
            [npcKeys.name] = "Aggressive Squashling",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{36.6, 48.8},{36.6, 52.8},{38.2, 52.2},{39.2, 55.2},{42.2, 35.8},{43.2, 34.2},{43.2, 35.2},{43.6, 33.8},{43.8, 33.4},{43.8, 38},{44.2, 32.4},{44.8, 31.8},{48.2, 22},{48.8, 22},{49, 22.6},{50.2, 24},{50.4, 19.8},{50.6, 18.8},{50.6, 22},{50.8, 21.4},{51, 18.4},{51.4, 24.8},{51.4, 26},{52.4, 30.4},{54.8, 35.6},{62.8, 63},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210487] = {
            [npcKeys.name] = "Horror of the Deep",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{25, 69.4},{25.2, 65.6},{26, 66.8},{26, 69.4},{26, 69.6},{26.2, 68},{26.4, 66},{26.8, 66.2},{26.8, 68},{26.8, 69},{26.8, 69.8},{27.6, 70.4},{28.8, 70.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210501] = {
            [npcKeys.name] = "Harvest Reaper Prototype",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{34.4, 52.6},{35.2, 51.4},{35.4, 51.6},{35.6, 51.4},{35.6, 52.2},{44.4, 39.2},{45.2, 39.6},{45.4, 38.8},{45.4, 40.8},{45.6, 39},{49.6, 36.6},{50, 18.8},{50.2, 17.4},{50.2, 18.4},{50.6, 18.4},{50.6, 19},{50.8, 20.4},{51.4, 33.4},{51.4, 33.6},{51.8, 34},{52.2, 32.4},{52.4, 32.6},{52.8, 33},{52.8, 33.8},{58.8, 54},{60.2, 56.8},{61.2, 57.4},{61.2, 58.2},{61.4, 58.8},{61.6, 58.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210528] = {
            [npcKeys.name] = "Terrified Soul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210533] = {
            [npcKeys.name] = "Silverspur",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 14,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{33.6, 40.8},{34.4, 37.2},{34.8, 38.6},{35, 38.4},{35, 39.6},{35.6, 38.4},{36, 38.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210537] = {
            [npcKeys.name] = "Undying Laborer",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{27.4, 35.6},{28.2, 37.8},{28.8, 49.4},{29, 50.8},{29.2, 41.4},{29.2, 50},{29.4, 46.4},{29.6, 50.6},{29.8, 46},{29.8, 46.6},{29.8, 49.8},{30.2, 49.2},{30.4, 42.6},{30.4, 45.4},{30.4, 47.8},{30.6, 45.8},{30.6, 48.4},{31, 43.2},{31.2, 44.8},{31.4, 44},{31.6, 43.8},{31.6, 44.6},{31.8, 43.4},{32.2, 42.4},{32.6, 43.2},{34.8, 41.6},{35.2, 40.8},{36.2, 44},{36.8, 43.2},{37.8, 45.4},{42.2, 32.4},{43.4, 26.8},{43.8, 25.2},{43.8, 31.6},{44, 23.4},{44.4, 21.2},{44.4, 24},{44.4, 25.6},{44.4, 27},{44.4, 29.4},{44.6, 19.4},{44.6, 20.2},{44.6, 24.2},{44.6, 24.8},{44.8, 26.2},{44.8, 26.6},{44.8, 29},{45, 23},{45.2, 31.2},{45.4, 18.2},{45.4, 21.2},{45.4, 21.6},{45.4, 28},{45.6, 20.4},{45.6, 21.4},{45.6, 21.6},{45.8, 27.4},{45.8, 36.4},{46, 18.4},{46, 26.4},{46.2, 18.6},{46.2, 28.2},{46.6, 19.4},{46.6, 27.4},{46.8, 29.6},{47, 28.6},{47.6, 28},{47.6, 33.6},{50.4, 28.2},{50.6, 28},{50.6, 29.2},{53.4, 27.6},{54.4, 29.6},{55.2, 31.4},{55.8, 47.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210549] = {
            [npcKeys.name] = "Defias Scout",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{49.4, 47.4},{50, 48.6},{50.2, 48.2},{50.4, 47.4},{50.4, 54.4},{50.4, 54.8},{50.4, 56.2},{50.6, 47.6},{50.8, 54.4},{51, 47.2},{51, 54.8},{51.4, 55.6},{51.6, 55.4},{51.6, 55.6},{51.8, 46.6},{53.8, 48.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210697] = {
            [npcKeys.name] = "Captain Namier",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{36.6, 26.6},{37.4, 27.6},{37.4, 28.6},{37.8, 28.4},{38, 28.8},{38, 29.6},{38.4, 30.6},{38.8, 29.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210750] = {
            [npcKeys.name] = "M'grrgl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210802] = {
            [npcKeys.name] = "Webbed Victim",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{34.8, 7.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210845] = {
            [npcKeys.name] = "Jixo Madrocket",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{59.2, 62.4},{59.2, 62.6},{60.6, 62.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78114,78121},
            [npcKeys.questEnds] = {78114,78121},
        },
        [210887] = {
            [npcKeys.name] = "Unsuspecting Pridewing",
            [npcKeys.minLevel] = 19,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{60.4, 62.2},{60.6, 62.2},{60.6, 62.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210901] = {
            [npcKeys.name] = "Stonetalon Wyvern stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [210995] = {
            [npcKeys.name] = "Alonso",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{42, 69.2},{42.4, 70},{43.4, 70.4},{43.4, 70.6},{43.6, 70.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78132,78133,78134,78144},
            [npcKeys.questEnds] = {78132,78133,78134,78144},
        },
        [211022] = {
            [npcKeys.name] = "Owen Thadd",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{73.4, 33},{73.6, 33},{74, 32.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {79094,79095},
            [npcKeys.questEnds] = {78124,78127,78142,78143,78145,78146,78147,78148,78149,78150,79092,79093,79094,79095,79096,79097,79535,79536,79947,79948,79949,79950,79951,79952,79953,81947,81949,81951,81952,81953,81954,81955,81956,82084,82208},
        },
        [211033] = {
            [npcKeys.name] = "Garion Wendell",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{37.6, 80.8},{37.8, 80.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78124,78127,78142,78143,78145,78146,78147,78148,78149,78150,79091,79092,79093,79096,79097,79535,79536,79905,79947,79948,79949,79950,79951,79952,79953,81947,81949,81951,81952,81953,81954,81955,81956,82084,82208},
            [npcKeys.questEnds] = {78124,78127,78142,78143,78145,78146,78147,78148,78149,78150,79091,79092,79093,79096,79097,79535,79536,79905,79947,79948,79949,79950,79951,79952,79953,81947,81949,81951,81952,81953,81954,81955,81956,82084,82208},
        },
        [211042] = {
            [npcKeys.name] = "Green Dragon Whelp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{42, 69.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211043] = {
            [npcKeys.name] = "Alonso",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211146] = {
            [npcKeys.name] = "Lost Adventurer",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{34.2, 9.4},{34.4, 8.4},{35, 7.8},{35.4, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211183] = {
            [npcKeys.name] = "Secret Agent",
            [npcKeys.minLevel] = 77,
            [npcKeys.maxLevel] = 77,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{50.4, 79.6},},
                [45] = {{25, 20},},
                [267] = {{88.4, 47.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211188] = {
            [npcKeys.name] = "Maethra Slagheart",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{37, 88.8},{38, 88},{38, 89},{38, 89.6},{38.6, 89},{38.6, 89.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78192,78193},
            [npcKeys.questEnds] = {78192},
        },
        [211200] = {
            [npcKeys.name] = "Agon",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{60.2, 31.8},{60.2, 33},{60.4, 29.8},{60.4, 30.8},{60.6, 25.8},{60.6, 32.6},{60.8, 29.2},{60.8, 32.4},{61.2, 27.8},{61.2, 30},{61.2, 30.8},{61.6, 28.2},{61.6, 28.8},{61.6, 30.4},{61.6, 31.8},{61.8, 31.2},{62.2, 25.4},{62.6, 25.8},{62.6, 31.8},{62.8, 35.8},{63, 31.2},{63, 34.6},{63.2, 30.4},{63.4, 25},{63.4, 29},{63.6, 31.4},{63.8, 28.4},{64, 32.4},{64, 34},{64.2, 33},{64.2, 35},{64.2, 35.6},{64.2, 37.8},{64.4, 23.8},{64.4, 24.6},{64.4, 26.4},{64.4, 36.8},{64.6, 36.8},{64.8, 25},{64.8, 34.4},{65, 23.8},{65, 32.4},{65, 35.6},{65.2, 21.4},{65.2, 21.6},{65.2, 23.2},{65.2, 27.8},{65.2, 34.8},{65.4, 26},{65.4, 26.8},{65.4, 30},{65.6, 23.2},{65.6, 24},{65.6, 25.2},{65.6, 26.4},{65.6, 32.2},{65.6, 34.4},{65.6, 34.8},{66, 27},{66, 32.6},{66, 36.2},{66.4, 27.8},{66.4, 29.2},{66.4, 29.8},{66.6, 33},{66.8, 23.4},{66.8, 28.4},{66.8, 29.8},{67, 30.6},{67.2, 29.4},{67.4, 27.2},{67.4, 31.8},{67.6, 30.2},{67.6, 32},{67.6, 33.6},{67.8, 31},{68, 33.4},{68.6, 28},{68.8, 32.4},{69.4, 32.6},{69.6, 29.4},{69.6, 30.2},{70.2, 33.4},{70.8, 31.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211225] = {
            [npcKeys.name] = "Baj'ura",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{46, 20},{46.4, 19.4},{46.4, 20.6},{47, 19.6},{47.2, 19.4},{48, 19.2},{48, 19.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78198,78199},
            [npcKeys.questEnds] = {78198},
        },
        [211229] = {
            [npcKeys.name] = "Dietrich Praice",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35.4, 88},{35.6, 88},{35.8, 87.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78196,78197},
            [npcKeys.questEnds] = {78196},
        },
        [211269] = {
            [npcKeys.name] = "Summoned Wisp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.8, 43.4},{86.8, 43.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211274] = {
            [npcKeys.name] = "Ashenvale Wisp Target",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211279] = {
            [npcKeys.name] = "Corrupt Spirit Beast",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.6, 43.6},{86.8, 43.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211298] = {
            [npcKeys.name] = "Syrnoya",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{37.6, 43.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78195},
        },
        [211330] = {
            [npcKeys.name] = "Suspicious Target",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{65.8, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211338] = {
            [npcKeys.name] = "Vile Fin Hunter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{65.8, 11.2},{65.8, 11.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211653] = {
            [npcKeys.name] = "Grizzby",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{61.8, 39.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78265,78266,78267,78287,78288},
            [npcKeys.questEnds] = {78265,78266,78267,78297,78304},
        },
        [211736] = {
            [npcKeys.name] = "Grizzled Protector",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{36.6, 16},{36.6, 17.2},{37.8, 15.6},{39.4, 15.2},{40.4, 16.8},{40.6, 18},{41.6, 19.6},{42, 24},{42.2, 21.8},{42.4, 18.4},{42.4, 18.6},{42.8, 18},{44, 49.2},{44, 51.6},{44.2, 16.6},{44.6, 48.8},{45, 24.6},{47, 18},{47.2, 17},{47.2, 19},{47.2, 20.6},{47.4, 32.8},{48, 22.6},{48.2, 20.8},{48.6, 21.4},{48.6, 33.4},{48.8, 37.8},{49, 14.2},{49, 17.6},{49.2, 15},{49.4, 21.6},{49.6, 25.8},{49.6, 32.2},{49.8, 19},{49.8, 22.4},{50.2, 20},{50.4, 16.2},{50.4, 18.2},{50.4, 23.4},{50.4, 38.2},{50.4, 42.2},{50.4, 44.8},{50.6, 36.6},{50.6, 67},{50.8, 35.4},{51, 15.8},{51, 24.4},{51, 38.2},{51, 38.6},{51.2, 19.2},{51.2, 41.2},{51.2, 45.2},{51.4, 20},{51.6, 17.4},{51.6, 18.2},{51.6, 20.8},{51.6, 37.8},{51.6, 38.8},{51.8, 19.6},{52, 51.2},{52, 57.8},{52.6, 47.4},{52.6, 48.4},{53, 20.8},{53.2, 20.2},{53.4, 44.4},{53.4, 59},{53.8, 45.8},{54, 39.8},{54, 44.2},{54.6, 38.6},{54.6, 40.4},{55, 41.2},{55.8, 43},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211764] = {
            [npcKeys.name] = "Gefell",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = 209,
            [npcKeys.spawns] = {
                [209] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211765] = {
            [npcKeys.name] = "Gemela",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = 209,
            [npcKeys.spawns] = {
                [209] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211839] = {
            [npcKeys.name] = "Test Boss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211875] = {
            [npcKeys.name] = "Decayed Elemental",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{43.2, 20.6},{44.4, 21.4},{44.4, 21.8},{44.4, 42},{45, 21.6},{45, 22.6},{45.2, 21},{45.4, 20},{45.8, 20},{45.8, 21.2},{45.8, 22.6},{46, 22.2},{46.2, 19.4},{47, 19.2},{47.2, 20.4},{47.6, 20},{55.4, 15.6},{67.2, 24.6},},
                [1637] = {{37, 76.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211941] = {
            [npcKeys.name] = "Dream Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211951] = {
            [npcKeys.name] = "Koartul",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{61, 33.2},{61, 33.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211952] = {
            [npcKeys.name] = "Omni Diffusion Armor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211953] = {
            [npcKeys.name] = "Bulky Protective Ironweave",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211954] = {
            [npcKeys.name] = "Electrostatic Discharge Shielding",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211955] = {
            [npcKeys.name] = "Auxiliary Anti-Tamper Mechanism",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211956] = {
            [npcKeys.name] = "Scarimous the Wandering",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211965] = {
            [npcKeys.name] = "Carrodin",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{45.8, 60.2},{46.4, 64.4},{46.4, 65},{46.4, 65.6},{46.8, 63.4},{47, 65.6},{47.2, 64.4},{47.2, 65},{47.6, 63.2},{47.6, 64},{47.6, 64.6},{47.6, 66},{48.4, 60.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [211967] = {
            [npcKeys.name] = "Leech Stalker Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212159] = {
            [npcKeys.name] = "Old Serra'kis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212186] = {
            [npcKeys.name] = "Grugimdern",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{36.8, 15.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212209] = {
            [npcKeys.name] = "Vodyanoi",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{31.2, 18.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212252] = {
            [npcKeys.name] = "Harvest Golem V000-A",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212261] = {
            [npcKeys.name] = "Awakened Lich",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{17.2, 37.6},{18, 38},{18, 38.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212330] = {
            [npcKeys.name] = "Explrgl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212333] = {
            [npcKeys.name] = "Blackfathom Tendril",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212334] = {
            [npcKeys.name] = "Dead Twilight Cultist",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{17.2, 26.4},{17.2, 26.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212443] = {
            [npcKeys.name] = "Nightmare Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212458] = {
            [npcKeys.name] = "Phantasmal Crustacean",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212461] = {
            [npcKeys.name] = "Phantasmal Servant",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212462] = {
            [npcKeys.name] = "Phantasmal Softshell",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212463] = {
            [npcKeys.name] = "Phantasmal Snapjaw",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212468] = {
            [npcKeys.name] = "Invading Nightmare",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212598] = {
            [npcKeys.name] = "Recke Grinnes",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{66.2, 31.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212667] = {
            [npcKeys.name] = "Fettered Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212674] = {
            [npcKeys.name] = "Death's Head Shaman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212678] = {
            [npcKeys.name] = "Earth Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212692] = {
            [npcKeys.name] = "Bound Elemental",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 21,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{41.4, 79.8},{42.2, 80.8},{42.4, 79.4},{43, 78.6},{43, 82.2},{43.2, 78.4},{43.2, 81.4},{43.6, 78.8},{43.6, 79.6},{43.8, 78.4},{43.8, 82.2},{44, 80.6},{44, 91.2},{44.4, 88.8},{44.6, 59},{44.8, 76.8},{44.8, 78.6},{44.8, 85.8},{45, 76.2},{45, 79.6},{45.2, 63.8},{45.2, 74.2},{45.2, 77.8},{45.6, 78.2},{45.8, 80.4},{45.8, 82.8},{46, 69},{46, 69.8},{46, 74},{46, 75.2},{46, 76.4},{46, 76.6},{47.6, 81.6},{47.8, 83.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212694] = {
            [npcKeys.name] = "Hirzek",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{41.8, 79.4},{41.8, 80.8},{42.2, 81.6},{43, 78.4},{43.2, 78.6},{43.6, 78.4},{43.6, 78.8},{44.2, 76.4},{44.2, 80},{44.2, 91},{44.4, 59},{44.4, 90},{44.6, 75.8},{44.8, 78.8},{45, 86},{45.4, 79.6},{45.4, 83.8},{45.8, 76.8},{46, 74.2},{46, 75.4},{46, 81.6},{46.2, 60.4},{46.2, 61.6},{46.2, 76.2},{47, 60.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212699] = {
            [npcKeys.name] = "Silverwing Archer",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.4, 27.6},{28.2, 27.4},{28.2, 28.8},{28.4, 28.2},{28.6, 28.2},{28.6, 28.8},{29, 26.6},{51.2, 55.8},{51.2, 56.6},{51.4, 54.4},{51.4, 54.8},{51.6, 54.4},{51.6, 54.6},{51.6, 55.6},{59, 72.6},{59.2, 73.6},{59.4, 71.2},{59.4, 72.2},{59.8, 71.8},{59.8, 72.6},{60, 70.4},{60, 71.4},{60.6, 71.4},{72.4, 72.2},{72.4, 73.2},{72.6, 72.4},{72.8, 73.2},{73, 74.8},{73.2, 73.6},{73.6, 73.8},{74, 73.2},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212703] = {
            [npcKeys.name] = "Silverwing Dryad",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{28.4, 27},{28.4, 28.2},{28.4, 28.6},{28.6, 28},{28.8, 28.8},{29, 27.4},{51.2, 54.2},{51.2, 55.6},{51.4, 55.4},{51.6, 54.4},{51.6, 54.8},{51.8, 55.6},{59.4, 73},{59.8, 72.4},{60, 70.4},{60, 71.4},{60, 72.6},{60.6, 71.4},{72.8, 72.4},{73, 73},{73.2, 73.6},{74, 73.4},{74, 74},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212706] = {
            [npcKeys.name] = "Silverwing Druid",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.4, 27.8},{28.2, 27},{28.4, 28.4},{28.4, 28.6},{28.6, 28.2},{28.6, 28.6},{51.2, 56},{51.4, 54.4},{51.4, 55.4},{51.4, 56.6},{51.6, 54.4},{51.6, 54.6},{59.4, 72},{60, 70.2},{60, 71},{60, 71.6},{60, 72.6},{72.4, 72.8},{72.8, 72.4},{72.8, 73},{73.2, 73.6},{73.6, 73.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212707] = {
            [npcKeys.name] = "Larodar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{51.2, 56.6},{51.4, 54.4},{51.4, 55},{51.4, 55.6},{51.4, 57.6},{51.6, 54.4},{51.6, 54.8},{51.6, 55.6},{51.6, 57.4},{51.8, 53.4},{51.8, 58},{52.6, 54.2},{52.6, 58.2},{53.2, 54.6},{53.4, 58.6},{53.6, 54.4},{53.6, 54.6},{54.2, 59},{55, 54.8},{56.2, 55.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212727] = {
            [npcKeys.name] = "Warsong Grunt",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{21.2, 36.4},{21.2, 36.6},{21.2, 37.8},{21.2, 38.6},{21.6, 36.4},{21.6, 37.4},{21.6, 38.6},{21.8, 37.6},{38.2, 67.8},{38.4, 67.4},{38.4, 68.6},{38.8, 66.4},{39, 67.8},{39, 69},{39.4, 66.8},{39.6, 65.4},{39.6, 66.4},{39.6, 66.6},{39.6, 67.6},{40, 69.8},{52.4, 54.2},{53, 54.6},{53.4, 54.4},{53.6, 54.6},{54.2, 54},{54.6, 54.4},{54.8, 55},{55.4, 55.6},{55.6, 55.4},{55.8, 55.6},{68.4, 63.8},{68.8, 63.6},{69.4, 63},{69.6, 63},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212728] = {
            [npcKeys.name] = "Warsong Raider",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{21.2, 36.8},{21.2, 37.8},{21.4, 36.4},{21.6, 36.4},{21.6, 38.6},{21.8, 37.4},{21.8, 37.6},{38.2, 68},{38.4, 67.2},{38.8, 69},{39, 67.6},{39.4, 66.2},{39.4, 66.8},{39.6, 65.4},{39.6, 66.4},{39.6, 66.6},{39.6, 67.6},{51.6, 54},{53, 54.4},{53.4, 54.6},{54, 54.6},{54.2, 54.2},{54.6, 54.4},{55, 55},{55.6, 55.2},{68.6, 63.6},{69.4, 63},{69.6, 63},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212729] = {
            [npcKeys.name] = "Warsong Shaman",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20.2, 37},{21.2, 36.6},{21.4, 36.4},{21.4, 37.6},{21.6, 36.4},{21.6, 37},{21.8, 37.6},{38.2, 67.8},{38.4, 67.2},{39, 66.4},{39, 66.8},{39, 67.8},{39.6, 65.4},{39.6, 66.4},{39.6, 67.4},{39.6, 67.6},{48, 56.2},{51.8, 54.4},{52.4, 54.6},{53, 54.4},{53, 54.6},{53.6, 54.2},{54.2, 53.2},{54.2, 54.8},{54.6, 53.8},{54.8, 55},{69, 63.6},{69.4, 62.8},{69.6, 62.4},{69.6, 63.6},{69.8, 63.2},{70.6, 63.2},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212730] = {
            [npcKeys.name] = "Tojara",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{49.8, 56.6},{50.2, 53},{50.2, 55.4},{50.2, 55.8},{50.4, 53.8},{51, 55.6},{51.4, 53.2},{51.4, 54.4},{51.4, 54.6},{51.6, 54.4},{51.6, 54.6},{51.8, 53.4},{53, 54.4},{53.4, 54.6},{54.2, 53.2},{54.2, 54},{54.4, 54.8},{54.6, 53.4},{54.6, 54.4},{54.8, 55},{54.8, 55.6},{55.6, 55.4},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212753] = {
            [npcKeys.name] = "Tortured Soul",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{45, 58.6},{63, 37.6},{63, 56.8},},
                [44] = {{76.4, 84.2},},
                [130] = {{44.2, 40.2},{44.4, 42},{44.4, 44},{44.8, 42.4},{45, 40.6},{46, 39.6},{46.4, 83.8},{47.4, 83.8},{49, 38.2},{52.6, 55},{53.8, 71.6},{56.8, 70.6},{57.6, 71.4},{58.4, 72},{58.6, 72},{59, 70.8},{59.4, 70.2},{59.6, 70},{59.6, 71.6},{59.8, 71},{59.8, 75.4},{60.2, 74},{60.4, 73.4},{60.6, 72.4},{60.6, 72.6},{61, 74.8},{62, 72.6},{62.6, 73.8},{63.6, 75.2},{65.8, 80},},
                [1497] = {{54.6, 72},{62.4, 50},{66.8, 43.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212763] = {
            [npcKeys.name] = "Sadistic Fiend",
            [npcKeys.minLevel] = 19,
            [npcKeys.maxLevel] = 19,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{57, 45.8},{57.4, 44.8},{58.2, 45.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212801] = {
            [npcKeys.name] = "Jubei",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20, 37.6},{20.4, 36.4},{20.4, 37},{21.2, 36.4},{21.2, 37.4},{21.2, 38.6},{21.4, 37.6},{21.6, 36.4},{21.6, 37.4},{21.6, 37.6},{21.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212802] = {
            [npcKeys.name] = "Moogul the Sly",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{68.4, 63.4},{68.4, 63.8},{69.2, 63.6},{69.4, 63},{69.6, 63.2},{69.6, 63.6},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212803] = {
            [npcKeys.name] = "Ceredwyn",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{72.4, 72.2},{72.4, 72.6},{72.8, 72.4},{73, 73.2},{73.2, 73.6},{73.6, 73.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212804] = {
            [npcKeys.name] = "Centrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.4, 27.8},{28, 26.4},{28.2, 27.4},{28.4, 28.4},{28.4, 28.6},{28.4, 29.6},{28.6, 28.2},{28.6, 28.8},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212809] = {
            [npcKeys.name] = "Wailing Spirit",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{57.2, 70.4},{57.4, 71},{57.6, 71.2},{58, 71.8},{58.6, 71.6},{59.2, 70.6},{59.6, 71.4},{60.2, 74.4},{60.4, 72.2},{60.4, 72.8},{60.4, 74.8},{60.6, 72.4},{60.6, 73.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212837] = {
            [npcKeys.name] = "Primordial Anomaly",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{27, 64},{27.2, 64.8},{27.4, 67.2},{27.6, 63},{28, 68.2},{28.2, 71.8},{28.4, 64.4},{28.4, 65.4},{28.4, 65.6},{28.4, 70.8},{28.6, 62},{28.6, 63.2},{28.6, 64.4},{28.6, 65},{28.6, 66},{28.8, 71.4},{29, 72.2},{29, 73.8},{29.4, 72.8},{29.6, 63.6},{29.6, 65.6},{29.6, 70.4},{29.6, 71.4},{29.6, 72},{30.6, 71.6},{31.2, 66.8},{31.6, 74.6},{31.8, 67.4},{32.4, 67.8},{32.6, 67.6},{32.8, 72.4},{33, 69.4},{33.2, 66.6},{33.2, 69.6},{33.2, 71.2},{33.6, 68.8},{33.6, 69.6},{33.8, 68.4},{33.8, 70.8},{35, 72.2},{36.4, 71.4},{36.4, 71.6},{36.4, 72.6},{36.8, 71.4},{36.8, 72},{36.8, 72.6},{37.6, 71.4},{37.6, 72},{37.6, 72.6},{37.8, 67.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212934] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212953] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [212969] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{37.8, 66.4},{38.4, 66.8},{38.4, 67.6},{38.8, 66.4},{39, 67.4},{39, 68.6},{39.2, 67.8},{39.6, 66.4},{39.6, 66.6},{39.6, 67.6},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79098},
        },
        [212970] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{60, 71.4},{60, 71.8},{60, 72.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79090},
        },
        [213077] = {
            [npcKeys.name] = "Elaine Compton",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{54.4, 60.8},{54.6, 61.2},{54.8, 62},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308},
        },
        [213334] = {
            [npcKeys.name] = "Aku'mai",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213444] = {
            [npcKeys.name] = "Mysterious Traveler",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78684},
            [npcKeys.questEnds] = nil,
        },
        [213445] = {
            [npcKeys.name] = "Raszel Ander",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{49.2, 57.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78914,78994},
            [npcKeys.questEnds] = {78994},
        },
        [213450] = {
            [npcKeys.name] = "Felguard",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213451] = {
            [npcKeys.name] = "Cleansing Elemental",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213452] = {
            [npcKeys.name] = "Corrosion Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213540] = {
            [npcKeys.name] = "Mysterious Traveler",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{49.2, 57.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213595] = {
            [npcKeys.name] = "Void Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213659] = {
            [npcKeys.name] = "Dark Ritual Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213708] = {
            [npcKeys.name] = "Legion Hound",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213709] = {
            [npcKeys.name] = "Mannoroc Lasher",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 24,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213710] = {
            [npcKeys.name] = "Felguard",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 24,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213711] = {
            [npcKeys.name] = "Searing Infernal",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213795] = {
            [npcKeys.name] = "Gharrik",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{13.4, 65.6},{20.8, 67.6},{22.4, 67.4},{22.4, 67.6},{22.6, 67.4},{22.6, 67.6},{23.4, 66.2},{23.6, 66.4},{24.4, 65.2},{24.6, 66.4},{25.4, 67},{26, 63.2},{27, 65.8},{28, 59.8},{28.6, 59.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [213994] = {
            [npcKeys.name] = "Corrosive Droplet",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214000] = {
            [npcKeys.name] = "Corrosive Pool Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214063] = {
            [npcKeys.name] = "Temporal Anomaly",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214070] = {
            [npcKeys.name] = "Jornah",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{51.4, 63.8},{51.4, 64.6},{51.6, 63.8},{51.6, 64.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
        },
        [214096] = {
            [npcKeys.name] = "Dokimi",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{39.4, 53.4},{39.4, 53.6},{39.6, 53.4},{39.6, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307},
        },
        [214098] = {
            [npcKeys.name] = "Gishah",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{64.4, 38.4},{64.4, 38.6},{64.6, 38.6},{64.8, 38.2},{65.6, 38.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82308},
        },
        [214099] = {
            [npcKeys.name] = "Tamelyn Aldridge",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{24.4, 67.4},{24.4, 67.6},{24.6, 67.4},{24.6, 67.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
        },
        [214101] = {
            [npcKeys.name] = "Marcy Baker",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{59.2, 56.6},{59.8, 56.4},{59.8, 56.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
            [npcKeys.questEnds] = {78611,78612,78872,79100,79101,79102,79103,80307,80308,80309,82307,82308,82309},
        },
        [214129] = {
            [npcKeys.name] = "Venture Co. Light Shredder",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 21,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{59.4, 54.6},{59.8, 51},{59.8, 51.6},{60, 54.4},{60, 55},{60.2, 50.4},{60.2, 55.6},{61.4, 52.8},{62, 53},{62, 53.6},{62.2, 52.4},{62.6, 52.8},{66.4, 47.4},{66.4, 47.6},{66.6, 47.4},{66.6, 47.6},{67.4, 57.4},{67.4, 57.6},{67.6, 57.4},{67.6, 57.6},{68.2, 47.4},{68.4, 47.8},{68.6, 47.8},{68.8, 47.2},{68.8, 48.6},{70, 55.6},{70.2, 55.2},{70.4, 48.8},{70.6, 41.4},{70.6, 55.4},{70.6, 55.8},{70.8, 42},{70.8, 49.2},{70.8, 49.6},{72.4, 52.4},{72.4, 53.2},{72.4, 53.6},{72.6, 52.4},{72.6, 53},{72.8, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214133] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214190] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214208] = {
            [npcKeys.name] = "N'ora Anyheart",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{62, 39.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {78909},
            [npcKeys.questEnds] = {78909},
        },
        [214212] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{88.4, 73.4},{88.6, 73.4},{88.6, 73.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214254] = {
            [npcKeys.name] = "Pool of Shadow Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214440] = {
            [npcKeys.name] = "Demolition Explosives",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214456] = {
            [npcKeys.name] = "Dro'zem the Blasphemous",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 23,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{32.4, 7},{32.6, 6.8},{33.4, 7.8},{33.6, 7},{34.2, 8.6},{34.4, 7.6},{34.6, 7.4},{34.6, 7.6},{34.8, 10},{35.2, 8.8},{35.6, 8},{35.8, 6.8},{35.8, 9.8},{36, 12},{36.2, 9.2},{36.4, 11.4},{36.6, 7.6},{36.8, 11.2},{36.8, 13.6},{37, 12},{38.6, 13.8},{39.6, 14.4},{57.4, 41.4},{58.8, 46.6},{59.8, 40.4},{59.8, 46.4},{60.4, 42.4},{60.8, 44},{61.2, 41},{61.2, 43.4},{61.2, 46},{61.4, 45.2},{61.4, 48},{62, 45.6},{62.2, 41.4},{62.2, 42.2},{62.4, 43.4},{62.4, 43.6},{62.4, 44.8},{62.6, 42},{62.6, 44},{62.6, 44.8},{63, 43},{63.4, 41.4},{63.8, 42.6},{64, 42},{64, 44.2},{64.2, 45.8},{64.4, 45},{64.6, 46.6},{64.8, 40.2},{65, 48.4},{65.2, 43.4},{65.6, 41.8},{69.8, 82.6},{71.4, 82.8},{71.6, 79.2},{71.8, 80.8},{72, 82},{72.6, 81},{73, 84.2},{73.4, 82.6},{73.6, 79.6},{73.8, 76},{74, 81},{74, 83.4},{74.4, 78.6},{74.4, 82.2},{74.4, 83.6},{74.6, 73.6},{74.6, 76.8},{74.6, 78.6},{75, 71.6},{75, 85},{75.2, 73.2},{75.2, 83.6},{75.4, 77.8},{75.4, 80.4},{75.4, 81.2},{75.4, 82},{75.4, 82.6},{75.6, 84.6},{75.8, 78.2},{75.8, 79.4},{75.8, 79.6},{75.8, 81.2},{75.8, 83.6},{76, 77.4},{76.2, 69.6},{76.2, 72},{76.2, 82},{76.2, 83.4},{76.6, 82},{76.6, 82.8},{77, 70},{77, 73.8},{77, 78.4},{77.2, 68},{77.2, 79.8},{77.2, 81.4},{77.4, 69.4},{77.4, 71.4},{77.4, 71.6},{77.4, 75},{77.6, 70.6},{77.6, 74},{77.8, 67},{78, 72.4},{78.2, 63.6},{78.2, 66.4},{78.2, 68},{78.2, 69.2},{78.2, 69.6},{78.4, 72.8},{78.6, 68},{78.6, 69.2},{78.6, 69.6},{78.6, 70.6},{78.6, 72.2},{78.8, 67.4},{79.4, 66.4},{79.4, 72.6},{79.6, 70.4},{79.8, 72.4},{80.2, 67.6},{80.2, 68.6},{80.4, 71},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214458] = {
            [npcKeys.name] = "Baron Aquanis",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214468] = {
            [npcKeys.name] = "Ghamoo-ra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214469] = {
            [npcKeys.name] = "Lady Sarevess",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214519] = {
            [npcKeys.name] = "Incinerator Gar'im",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 23,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{76.6, 84.2},{77.2, 85.2},{77.4, 85.8},{77.8, 86.2},{77.8, 86.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214523] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214524] = {
            [npcKeys.name] = "Gelihast",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214525] = {
            [npcKeys.name] = "Lorgus Jett",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214526] = {
            [npcKeys.name] = "Twilight Lord Kelris",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214527] = {
            [npcKeys.name] = "Aku'mai",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214528] = {
            [npcKeys.name] = "Boss Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214529] = {
            [npcKeys.name] = "Brave Stonetorch",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{52.2, 51.2},{65.8, 19.6},{66, 19.2},{67.4, 14.2},{67.4, 14.8},{67.6, 14.4},{67.6, 15},{68.6, 13.8},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {81944},
        },
        [214530] = {
            [npcKeys.name] = "Ardelle Dralta",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{51, 58.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214589] = {
            [npcKeys.name] = "Cozy Sleeping Bag",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214603] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214612] = {
            [npcKeys.name] = "Aku'mai Fisher",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214658] = {
            [npcKeys.name] = "Ashenvale Arcane Shard Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214695] = {
            [npcKeys.name] = "Peon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214830] = {
            [npcKeys.name] = "Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214837] = {
            [npcKeys.name] = "Cheddar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214876] = {
            [npcKeys.name] = "Davius Voidstar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{36.8, 43.4},{36.8, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {79099},
            [npcKeys.questEnds] = {79099},
        },
        [214914] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [214954] = {
            [npcKeys.name] = "Rix Xizzix",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{28.4, 75.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215062] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{39.2, 30},{39.4, 28.2},{39.4, 29},{39.6, 28.4},{39.6, 29},{40, 29.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215068] = {
            [npcKeys.name] = "[DNT] Kill Credit - Priest - Meditation Sharing Tutorial",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215072] = {
            [npcKeys.name] = "Loa Altar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{79.8, 67},{80, 67.8},},
                [331] = {{11.8, 35.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215081] = {
            [npcKeys.name] = "Bat Loa",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{79.8, 67.2},},
                [331] = {{11.8, 35.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215095] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.4, 87.4},{39.4, 87.8},{39.8, 86.2},{40, 86.8},{40, 88.6},{40.4, 87.8},{40.6, 88.2},{40.8, 86.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215096] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35.4, 86.4},{35.4, 86.8},{35.4, 87.6},{35.6, 87.6},{35.8, 86.2},{35.8, 87},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215097] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215098] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{48.2, 14.6},{48.4, 14},{49.4, 14.4},{49.4, 15},{49.4, 16},{49.6, 16},{50.2, 14.4},{50.2, 14.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215108] = {
            [npcKeys.name] = "Aku'mai Snapjaw",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215367] = {
            [npcKeys.name] = "Dawnwatcher Selgorm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{55.6, 24},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215369] = {
            [npcKeys.name] = "Bashana Runetotem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{70, 33.4},{70, 33.6},{70.8, 32.4},{70.8, 32.6},{70.8, 33.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215643] = {
            [npcKeys.name] = "Tokal",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{27, 77.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79236,79242},
            [npcKeys.questEnds] = {79235,79236},
        },
        [215655] = {
            [npcKeys.name] = "Illari Duskfeather",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{93.8, 71.4},{93.8, 71.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215688] = {
            [npcKeys.name] = "Unkillable Test Dummy 25 Warrior",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215709] = {
            [npcKeys.name] = "Void Zone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215728] = {
            [npcKeys.name] = "Crowd Pummeler 9-60",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215849] = {
            [npcKeys.name] = "Doan Karhan",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2, 82.4},{51.2, 82.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79298},
        },
        [215850] = {
            [npcKeys.name] = "Raszel Ander",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2, 82.4},{51.2, 82.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79298},
            [npcKeys.questEnds] = {78914},
        },
        [215854] = {
            [npcKeys.name] = "Shadowbinder Acolyte",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2, 82.4},{51.2, 82.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215855] = {
            [npcKeys.name] = "Shadowbinder Acolyte",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2, 82.4},{51.2, 82.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215890] = {
            [npcKeys.name] = "Gear Toss Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [215974] = {
            [npcKeys.name] = "Des'Altek",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{51.2, 82.4},{51.2, 82.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216098] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216126] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216145] = {
            [npcKeys.name] = "Gnomeregan Smash Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216289] = {
            [npcKeys.name] = "Orokai",
            [npcKeys.minLevel] = 62,
            [npcKeys.maxLevel] = 62,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{41.2, 43.4},{41.2, 43.6},{41.6, 43.4},{41.6, 43.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79377},
            [npcKeys.questEnds] = {79348,79377},
        },
        [216310] = {
            [npcKeys.name] = "Rotting Ancient",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 15,
            [npcKeys.spawns] = {
                [15] = {{40, 42.8},{41.2, 37.6},{41.4, 41},{41.4, 42.4},{41.4, 42.8},{41.4, 43.6},{41.6, 34.2},{41.6, 37.8},{41.8, 42.6},{42, 30.8},{42.2, 44.2},{42.4, 40.8},{42.4, 42},{42.6, 41},{42.6, 43.4},{42.6, 43.6},{42.6, 44.8},{43, 42.2},{43.6, 41},{43.6, 43},{44, 42},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216437] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{58, 43.8},{58.2, 43.4},{58.6, 43.4},{58.6, 43.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216445] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{11.2, 38.6},{11.4, 38.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216448] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{32.6, 65},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216451] = {
            [npcKeys.name] = "Ancient Sapling",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{46.8, 71.4},{46.8, 71.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216463] = {
            [npcKeys.name] = "Ailgrha Splittusk",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{55, 42},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216474] = {
            [npcKeys.name] = "Ravaging Tempest",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.4, 40.8},{53.8, 40.4},{53.8, 41},{54.4, 41.8},{54.8, 40.6},{55, 42},{55.8, 43.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216620] = {
            [npcKeys.name] = "Unkillable Test Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216659] = {
            [npcKeys.name] = "Fallenroot Satyr",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.4, 10},{13.4, 12.2},{13.4, 13.2},{13.6, 11.8},{13.6, 13.4},{13.8, 10},{13.8, 11.2},{14.4, 9.4},{14.8, 10.4},{15, 10.6},{15.8, 11.4},{16.2, 11.6},{16.6, 11},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216660] = {
            [npcKeys.name] = "Fallenroot Rogue",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{14.4, 9.4},{14.4, 9.6},{14.8, 10.4},{15.2, 10.8},{15.8, 11.4},{16.4, 11.6},{16.6, 11},{16.6, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216661] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{12.8, 10},{13.4, 9.4},{13.4, 12.2},{13.4, 13.2},{13.6, 11.8},{13.6, 13.4},{13.6, 13.6},{13.8, 10},{13.8, 11.2},{14.2, 9.2},{14.6, 8.6},{14.8, 10.4},{15, 10.6},{15.8, 11.4},{16.4, 11.6},{16.6, 11.6},{17, 11.2},{17.6, 11},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216662] = {
            [npcKeys.name] = "Blackfathom Oracle",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.6, 9.6},{14.4, 9.4},{14.6, 9.8},{15.2, 10.8},{15.6, 11.2},{16.4, 11.6},{16.6, 11},{16.6, 11.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216664] = {
            [npcKeys.name] = "Sprok",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216665] = {
            [npcKeys.name] = "Gnomeregan Evacuee",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{24.4, 39.8},{24.4, 41},{24.6, 39.6},{24.8, 39.2},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216666] = {
            [npcKeys.name] = "Techbot",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216667] = {
            [npcKeys.name] = "Addled Leper",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{24.4, 39.8},{24.4, 40.8},{24.6, 39.4},{24.6, 39.8},{25.8, 39.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216668] = {
            [npcKeys.name] = "Irradiated Invader",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216669] = {
            [npcKeys.name] = "Caverndeep Pillager",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216670] = {
            [npcKeys.name] = "Caverndeep Looter",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216671] = {
            [npcKeys.name] = "Caverndeep Invader",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216672] = {
            [npcKeys.name] = "Namdo Bizzfizzle",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216810] = {
            [npcKeys.name] = "Desiccated Fallout",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216854] = {
            [npcKeys.name] = "Freewind Post Wyvern",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.2, 41},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216902] = {
            [npcKeys.name] = "Wulmort Jinglepocket",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{33.2, 65.4},{33.4, 65.6},{33.4, 67},{33.4, 67.6},{33.6, 66.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {7022,79482,79486,79492},
            [npcKeys.questEnds] = {79484,79492},
        },
        [216915] = {
            [npcKeys.name] = "Strange Snowman",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{35.4, 72.4},{35.4, 72.6},{35.6, 72.4},{35.6, 72.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79484,79485},
            [npcKeys.questEnds] = {79482,79483},
        },
        [216924] = {
            [npcKeys.name] = "Kaymard Copperpinch",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{53.2, 66.4},{53.2, 66.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {6961,79483,79487,79495},
            [npcKeys.questEnds] = {79485,79495},
        },
        [216931] = {
            [npcKeys.name] = "The Abominable Greench",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{28.4, 62.6},{28.6, 51.6},{28.8, 56.2},{28.8, 61.4},{29, 55.4},{29.2, 57},{29.2, 63.6},{29.4, 62.6},{29.6, 59.8},{29.8, 63.4},{30, 51.4},{30, 55.6},{30, 62},{30.4, 46.6},{30.4, 54.6},{30.4, 64.4},{30.4, 70.8},{30.6, 52.8},{30.6, 63.6},{30.8, 47.2},{30.8, 63},{30.8, 65.6},{30.8, 66.8},{31, 65.4},{31, 70.6},{31.4, 48.8},{31.6, 51.4},{31.6, 66.2},{31.6, 71.8},{31.8, 61.4},{31.8, 70.6},{32, 66.8},{32, 70},{32.2, 48.6},{32.2, 52.8},{32.4, 50},{32.4, 67.8},{32.6, 47.8},{32.6, 49},{32.6, 50.6},{32.8, 50},{32.8, 71},{32.8, 71.8},{33, 70.4},{33.6, 72.2},{34, 70.2},{34.2, 69.4},{34.2, 70.8},{34.6, 46.6},{34.6, 71},{35.2, 74.8},{36.8, 70.4},{37, 72.4},{37.6, 69.4},{37.8, 72.2},{38.2, 66.4},{38.2, 74},{38.4, 72.8},{38.6, 72.4},{39, 70.2},{39.2, 66},{39.2, 70.6},{39.4, 68.6},{39.6, 64.4},{39.6, 64.8},{39.8, 81.8},{40.2, 73.8},{40.2, 74.6},{40.4, 71.8},{40.4, 73.4},{40.6, 62.6},{40.6, 69.8},{40.6, 74.8},{40.6, 80},{40.8, 74.2},{41, 72},{41, 77.6},{41, 79.2},{41.4, 69.4},{41.4, 76.6},{41.6, 79.6},{42, 77},{42.4, 68.6},{43, 67.4},{43.8, 62.8},{43.8, 66},{44, 65.2},{44.4, 64},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [216937] = {
            [npcKeys.name] = "Blood Moon Listener Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217049] = {
            [npcKeys.name] = "Mirror Image",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{21.2, 36.4},{21.2, 38.6},{21.4, 36.8},{21.4, 37.6},{21.6, 36.2},{21.6, 37.4},{21.6, 37.6},{21.6, 38.6},{22.6, 38.2},{23, 35},{23.6, 38.2},{42.8, 60.8},{49, 56.8},{50, 52.4},{50, 56.8},{50.2, 54},{50.2, 55},{50.2, 56.2},{50.6, 53.4},{51, 51.8},{51.4, 54.2},{51.4, 54.8},{51.6, 53.2},{51.6, 54},{51.6, 54.6},{53, 54.6},{53.2, 54.4},{53.8, 54.6},{54.2, 53.4},{54.2, 53.8},{54.6, 53.4},{54.8, 54.4},{54.8, 54.8},{55.2, 55.8},{60.8, 70.2},{64, 60},{67.2, 62.2},{68.2, 62.6},{68.2, 64.2},{68.4, 62.4},{69, 63.6},{69.4, 63},{69.6, 63.2},{69.6, 63.6},{70.2, 62.4},},
            },
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217215] = {
            [npcKeys.name] = "Irradiated Cloud",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217216] = {
            [npcKeys.name] = "Grubbis Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217221] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217280] = {
            [npcKeys.name] = "Grubbis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217290] = {
            [npcKeys.name] = "Ogre Lightning Rod",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{33.4, 44.4},{33.4, 44.6},{33.6, 44.4},{33.6, 44.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217300] = {
            [npcKeys.name] = "Skonk",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{57.6, 74.4},{57.6, 74.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79677,79678},
            [npcKeys.questEnds] = {79624,79677,79678},
        },
        [217302] = {
            [npcKeys.name] = "Tam'kar",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{32.2, 45.4},{32.4, 43.4},{33, 46.2},{33.4, 44.4},{33.4, 44.6},{33.6, 44.4},{33.6, 44.6},{33.8, 45.8},{33.8, 47.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217305] = {
            [npcKeys.name] = "Ancient Fire Elemental",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{57.4, 47.4},{57.8, 47.2},{59.2, 48.4},{59.4, 44},{59.4, 45.2},{59.4, 46.4},{59.4, 46.6},{60, 45.4},{60, 45.6},{60, 46.6},{60.4, 48},{60.6, 46.6},{60.8, 47.6},{61.4, 46.4},{62.2, 44},{62.2, 46},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217308] = {
            [npcKeys.name] = "Irradiated Goo",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217387] = {
            [npcKeys.name] = "Brother Atticus",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{27, 57},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217392] = {
            [npcKeys.name] = "Flameseer Dubelen",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{56.2, 23.6},{56.4, 19.8},{56.4, 21.4},{56.4, 21.8},{56.4, 22.8},{56.6, 20.4},{56.6, 21.4},{56.6, 21.8},{57.2, 19},{57.8, 22.2},{58, 22.6},{58.2, 19.6},{58.2, 21.4},{58.6, 20.8},{58.8, 19},{59.2, 16.4},{60.6, 20.6},{62, 18},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217412] = {
            [npcKeys.name] = "Amaryllis Webb",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{25, 54.2},{25.2, 54.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217418] = {
            [npcKeys.name] = "Zai'enki",
            [npcKeys.minLevel] = 28,
            [npcKeys.maxLevel] = 28,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{68.6, 55.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217580] = {
            [npcKeys.name] = "Seductress Ceeyna",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{79.8, 82.8},{80, 82.4},{80.6, 82.6},{81, 79.4},{81.4, 80.2},{81.4, 80.6},{81.4, 82},{81.6, 79.4},{81.8, 80.4},{81.8, 80.6},{82.6, 80.2},{82.6, 80.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217582] = {
            [npcKeys.name] = "Caverndeep Ambusher",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217588] = {
            [npcKeys.name] = "Arbor Tarantula",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{43.8, 18.4},{43.8, 18.6},{44.2, 22},{45.2, 19.4},{45.2, 19.6},{45.4, 22.2},{45.4, 23.2},{45.6, 22.2},{45.6, 23},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217589] = {
            [npcKeys.name] = "Hay Weevil",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{30.4, 28.6},{30.6, 28.4},{30.8, 28.6},{31, 26.2},{32.2, 31},{54, 38.6},{54.2, 38.4},{57, 39.8},{59.6, 57},{61.2, 55.6},{61.4, 55.2},{62.4, 56},{62.6, 56},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217590] = {
            [npcKeys.name] = "Flesh Picker",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{49, 58.4},{50, 55.8},{50, 59.2},{51.2, 58},{51.4, 59.8},{51.6, 57.2},{51.6, 59.8},{52.2, 58.2},{52.4, 56.4},{52.4, 58.6},{52.6, 56.8},{52.6, 58},{52.8, 56.4},{52.8, 59.6},{53, 59},{53.4, 61.8},{54, 62},{54, 62.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217605] = {
            [npcKeys.name] = "Void Seeker",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{29.2, 62.4},{29.2, 63},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217620] = {
            [npcKeys.name] = "Reckless Warlock",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{30.8, 47},},
                [36] = {{54.2, 49.6},{54.4, 49.4},{54.6, 49.4},{54.6, 49.6},},
                [400] = {{10.8, 40.4},{11, 40.6},},
                [405] = {{74.8, 13.4},{74.8, 13.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217669] = {
            [npcKeys.name] = "Scorched Screeching Roguefeather",
            [npcKeys.minLevel] = 29,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{26.2, 46.8},{26.4, 46.4},{26.4, 47.6},{26.6, 47.6},{27, 46.4},{27, 47.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217683] = {
            [npcKeys.name] = "Altar of the Wind Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217689] = {
            [npcKeys.name] = "Ziri \"The Wrench\" Littlesprocket",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79705,81975},
            [npcKeys.questEnds] = {79705,81974,81975},
        },
        [217703] = {
            [npcKeys.name] = "Singed Highperch Consort",
            [npcKeys.minLevel] = 28,
            [npcKeys.maxLevel] = 29,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{10.4, 39.4},{10.4, 40.2},{10.4, 40.6},{10.8, 39.2},{10.8, 40.8},{11.2, 39.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217706] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{74, 60.4},{74, 60.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79098},
        },
        [217707] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{36.8, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {79090},
        },
        [217711] = {
            [npcKeys.name] = "Seared Needles Cougar",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 28,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{23.4, 23.2},{23.4, 23.6},{23.4, 25},{23.6, 24.4},{23.6, 25},{23.8, 23.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217733] = {
            [npcKeys.name] = "Caverndeep Pillager",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217783] = {
            [npcKeys.name] = "Bloodscalp Guerrilla",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 34,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{30.4, 14},{30.4, 15.4},{30.4, 15.8},{31, 14.6},{31, 16.6},{31.2, 16.2},{31.4, 14.2},{31.6, 14.2},{31.8, 15.6},{32.4, 15},{32.6, 13},{32.6, 14.8},{32.8, 16.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217836] = {
            [npcKeys.name] = "Needletooth",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{66.4, 66.8},{67.2, 67.8},{67.4, 64.2},{67.4, 64.6},{67.4, 65.6},{67.4, 66.8},{67.4, 68.6},{67.6, 65},{67.6, 65.6},{67.6, 67},{67.6, 68.4},{67.6, 68.6},{67.8, 69.6},{68, 63.4},{68.4, 64.2},{68.6, 64.6},{68.6, 66.6},{68.6, 68.2},{68.8, 63.8},{69.4, 63.2},{69.6, 63},{69.8, 64.6},{70, 64.4},{70.6, 63.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217862] = {
            [npcKeys.name] = "Reconstructed Staff of Des'Altek",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217907] = {
            [npcKeys.name] = "Chicken TEST",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217908] = {
            [npcKeys.name] = "Willing Sacrifice",
            [npcKeys.minLevel] = 38,
            [npcKeys.maxLevel] = 39,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{82, 80.4},{82, 80.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217942] = {
            [npcKeys.name] = "Trogg Monster Random",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217943] = {
            [npcKeys.name] = "Scarlet Crusade Assassin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217945] = {
            [npcKeys.name] = "Domesticated Attack Chicken",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217956] = {
            [npcKeys.name] = "Chomper",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217957] = {
            [npcKeys.name] = "Slain Scarlet Crusader",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217969] = {
            [npcKeys.name] = "Blastmaster Emi Shortfuse",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217980] = {
            [npcKeys.name] = "Nervous-Looking Mage",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217987] = {
            [npcKeys.name] = "Giga Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [217996] = {
            [npcKeys.name] = "Aeonas",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 796,
            [npcKeys.spawns] = {
                [796] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {79963,79970},
            [npcKeys.questEnds] = {79946,79963},
        },
        [218007] = {
            [npcKeys.name] = "Josh's Kill Credit Creature 1",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218019] = {
            [npcKeys.name] = "Combat Dummy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{68, 89.4},{68, 89.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218020] = {
            [npcKeys.name] = "Combat Dummy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{67.8, 89.4},{68, 89.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218021] = {
            [npcKeys.name] = "Combat Dummy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{67.8, 89.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218029] = {
            [npcKeys.name] = "Witherbark Champion",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{66.6, 79.2},{66.8, 80},{67.2, 81.8},{67.4, 78.2},{67.6, 77.8},{68, 79.4},{68, 82.2},{68.2, 80},{68.4, 80.6},{69, 82.6},{69.4, 80.4},{69.4, 81.4},{69.4, 81.6},{69.6, 81.4},{69.6, 81.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218032] = {
            [npcKeys.name] = "Witherbark Goliath",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 45,
            [npcKeys.spawns] = {
                [45] = {{67.2, 81.8},{67.4, 78.2},{67.4, 79.2},{67.6, 77.2},{67.6, 78.4},{67.8, 79.4},{68.2, 80.2},{68.2, 82.2},{68.2, 82.6},{68.4, 80.6},{69.2, 78.6},{69.2, 80.4},{69.2, 81.4},{69.2, 82.6},{69.4, 81.6},{69.6, 81.4},{69.6, 81.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218057] = {
            [npcKeys.name] = "Crowd Pummeler Bleacher Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218089] = {
            [npcKeys.name] = "Scarlet Squire Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218090] = {
            [npcKeys.name] = "Scarlet Crusader Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218093] = {
            [npcKeys.name] = "Burning Blade Acolyte Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218095] = {
            [npcKeys.name] = "Burning Blade Acolyte Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218115] = {
            [npcKeys.name] = "Mai'zin",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{31.2, 48.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218160] = {
            [npcKeys.name] = "Aeonas the Vindicated",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{37.4, 31.8},{37.6, 31.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81762},
            [npcKeys.questEnds] = {79970},
        },
        [218229] = {
            [npcKeys.name] = "Captain Aransas",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{27.4, 76.6},{27.6, 76.4},{27.6, 76.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218230] = {
            [npcKeys.name] = "Wendel Mathers",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{44.2, 8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218231] = {
            [npcKeys.name] = "Highlands Knight",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218232] = {
            [npcKeys.name] = "Kha'damu",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218233] = {
            [npcKeys.name] = "Forest Troll Shadow Priest",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218234] = {
            [npcKeys.name] = "Ogre Magi",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218235] = {
            [npcKeys.name] = "Gnoll Overseer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218236] = {
            [npcKeys.name] = "Mud Golem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218237] = {
            [npcKeys.name] = "Wirdal Wondergear",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{84.2, 43.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {79982},
            [npcKeys.questEnds] = {79981,79982},
        },
        [218238] = {
            [npcKeys.name] = "Josh's Kill Credit Creature 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218240] = {
            [npcKeys.name] = "Tower Defense Automaton",
            [npcKeys.minLevel] = 57,
            [npcKeys.maxLevel] = 57,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{84.2, 44},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218241] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{7, 90.6},{17, 41.2},{19.2, 42.6},{42.8, 78.2},{48.4, 37.8},{48.4, 41.4},{50, 14.2},{51.2, 54.4},{54.4, 24.6},{55.8, 56.4},{72.2, 65.8},{74.6, 65.2},{83.2, 30.6},},
                [15] = {{33.6, 20.4},{33.8, 46},{35.6, 35.4},{37.2, 22.8},{38, 26.8},{38.4, 34.4},{41.8, 70.4},{43.2, 66.4},{46.2, 22.6},{46.2, 83.8},{48, 80.4},{49.4, 37},{49.6, 69.4},{51.4, 71.2},{53.4, 20.6},{54, 15.8},{56.6, 20.8},{57, 11.4},{61.4, 20.8},{61.8, 17.6},{63, 29.2},{63.2, 36.6},{64.6, 28.2},},
                [33] = {{21.2, 10.4},{23.4, 10},{24, 10.6},{24.2, 50.4},{24.2, 61.4},{24.6, 62.2},{25, 63.6},{25.2, 12.6},{26.2, 13.4},{26.8, 61.8},{26.8, 67.4},{28, 70},{28.8, 71},{30, 19.2},{30, 23.4},{30.8, 71.8},{31.2, 68.4},{31.4, 14.4},{32, 67},{32.6, 13},{32.8, 37},{32.8, 78.6},{33, 74},{33.2, 36},{33.2, 60.4},{33.2, 65},{33.8, 20.2},{33.8, 21.2},{34.2, 60.6},{34.2, 65},{35.6, 42.6},{36, 30},{36, 41},{37.4, 31.4},{38.4, 42.6},{38.8, 26},{39.6, 38.2},{39.8, 30.6},{40.2, 27.2},{40.6, 38.6},{41.4, 43},{42.4, 33.6},{42.6, 18.4},{43.8, 33.8},{44.2, 10.2},{44.4, 40.6},{44.8, 40.2},{45.8, 8},{46, 41.4},{46.2, 7},{46.4, 13.2},{47.8, 6.8},},
                [36] = {{17.4, 84.8},{18, 83.2},{33.4, 83.8},{38, 15},{39.6, 68.6},{40.2, 57.6},{40.4, 74},{41.8, 21},{42, 62.2},{47.2, 47.6},{47.6, 84.4},{48.8, 18.8},{56.8, 46.8},{57.6, 67.4},},
                [357] = {{23, 64.2},{23.6, 64.6},{24, 52.6},{24.4, 63.2},{24.4, 63.6},{25, 55.8},{25, 62.4},{25.2, 55.2},{25.2, 66},{25.4, 49},{25.4, 50.4},{25.4, 51.2},{25.4, 53.4},{25.4, 54.4},{25.4, 63},{25.4, 64.4},{25.4, 65.2},{25.4, 66.8},{25.6, 50.2},{25.6, 51.4},{25.6, 64.6},{25.6, 66.6},{25.8, 62.2},{25.8, 63.6},{25.8, 66},{26, 47.6},{26, 52.6},{26, 54},{26, 56.4},{26, 56.6},{26, 71.4},{26.2, 52},{26.2, 55},{26.2, 63},{26.4, 45.4},{26.4, 46.8},{26.4, 68.2},{26.6, 46.4},{26.6, 50.2},{26.6, 52},{26.6, 54.2},{26.6, 55.8},{26.8, 46.6},{26.8, 54.6},{26.8, 56.8},{26.8, 68.2},{26.8, 69.4},{27, 53.4},{27, 64},{27, 69.6},{27.2, 62.2},{27.2, 62.8},{27.4, 48},{27.6, 48.8},{27.6, 51.8},{27.6, 54},{27.6, 55.2},{27.6, 62.8},{27.6, 68.2},{27.6, 70.2},{27.6, 70.8},{27.8, 47},{28, 56.8},{28, 69},{28.2, 56.4},{28.2, 58},{28.4, 43.8},{28.4, 45.4},{28.4, 45.6},{28.4, 50.2},{28.4, 52.8},{28.6, 52.6},{28.8, 44.8},{28.8, 50.8},{28.8, 52},{28.8, 53.8},{29, 46.8},{29, 50.2},{29.2, 54.6},{29.2, 56.6},{29.4, 47.6},{29.4, 49},{29.4, 56},{29.6, 49.8},{29.6, 53},{29.6, 55.2},{29.8, 48.2},{29.8, 52.2},{29.8, 57.2},{30, 49},{30.2, 54.2},{30.2, 56},{30.6, 48.2},{30.6, 50.4},{30.6, 53.8},{30.8, 51.4},{30.8, 52.6},{30.8, 57.6},{31, 52},{31.2, 49.4},{31.2, 55.8},{31.2, 56.8},{31.4, 55.4},{31.6, 50.2},{31.8, 51},{31.8, 55.8},{31.8, 57.6},{32.4, 55.4},{32.6, 56.8},{32.8, 56.2},{33.2, 49.8},{33.2, 52.4},{33.2, 53.2},{33.2, 54.2},{33.2, 55.2},{33.4, 49},{33.4, 51},{33.8, 49.8},{34, 49.4},{40.8, 35.8},{45.2, 21},{48, 44.8},{52.2, 58},{54.8, 56.2},{55, 73.2},{55.4, 53},{55.4, 57},{55.6, 53},{55.8, 56.6},{56.4, 56},{56.6, 54.8},{57.6, 54},{59.6, 66.2},{60.2, 54.6},{61.2, 64},{61.6, 55.2},{67.4, 55.6},{68.8, 47},{69, 39.4},{69, 50.8},{69.4, 54.2},{69.6, 39.6},{70.8, 56.4},{71, 53.2},{72, 55},{72.2, 35.6},{72.6, 56.4},{73, 35.6},{73.8, 54.4},{74, 37.8},{74.4, 40.2},{74.8, 27.2},{75.4, 53.8},{75.6, 57.2},{75.8, 33.6},{77.6, 41},{78, 38.2},{78.2, 45},{79.6, 41.2},{85.6, 44.2},{85.6, 46},{86, 41.8},{86, 45.2},{86.6, 41.2},{88.8, 39.4},},
                [400] = {{67.4, 86},{69.6, 82.4},{69.8, 88.8},{70.8, 77.4},{71, 86.2},{71.6, 86.2},{77.2, 89.6},{78.4, 90.2},{79.8, 87},{80.6, 60.2},},
                [405] = {{27.4, 8.6},{29, 77.8},{30.2, 58.8},{31, 79.4},{42.2, 70},{43.2, 73.2},{45, 74.4},{48, 75.6},{48.8, 77.4},{49, 78.4},{49.2, 81.4},{49.4, 78.6},{49.6, 78},{49.8, 73},{50, 81.4},{50.2, 74},{50.4, 71.6},{50.4, 76.4},{50.4, 76.8},{50.6, 77.6},{50.6, 82.6},{50.8, 71},{51, 75.2},{51, 76.6},{51.2, 68.8},{51.2, 70.2},{51.2, 72},{51.2, 73.4},{51.2, 75.8},{51.2, 83.6},{51.4, 68},{51.6, 82},{51.8, 74},{51.8, 84.6},{52, 75.2},{52, 83.6},{52.4, 67.2},{52.4, 83.4},{52.4, 85.8},{52.6, 70.8},{52.6, 83.8},{52.8, 71.8},{52.8, 79.2},{53, 72.6},{53.2, 70},{53.2, 77.6},{53.2, 85.2},{53.4, 76},{53.4, 79.6},{53.4, 81.2},{53.4, 81.8},{53.6, 70.2},{53.6, 78},{53.6, 82.2},{53.8, 77.4},{53.8, 79.8},{53.8, 83.6},{54, 76.2},{54.2, 74},{54.4, 71},{54.6, 73.6},{55, 77.2},{55.4, 78.2},{55.6, 78},{55.8, 40.8},{56, 75.8},{56.2, 77.2},{56.4, 71.4},{56.4, 73},{56.6, 72.8},{56.6, 77.8},{57, 74.4},{57.2, 76.2},{57.8, 75.4},{58.2, 77.4},{59.2, 89.8},{60.4, 90.4},{61, 90.6},{63, 52},{64, 87.4},{64.4, 90.6},{65, 22.8},{65.8, 25.4},{69.6, 20.6},{69.8, 31},{70, 81},{72, 19.4},{72.6, 17},{72.8, 73},{74, 22.6},{74.6, 13.2},{77, 18.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218242] = {
            [npcKeys.name] = "STX-04/BD",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218243] = {
            [npcKeys.name] = "STX-13/LL",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218244] = {
            [npcKeys.name] = "STX-25/NB",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218245] = {
            [npcKeys.name] = "STX-37/CN",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218246] = {
            [npcKeys.name] = "Gurgthock",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{33.2, 50.2},{33.2, 50.6},},
                [14] = {{45.4, 13.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218249] = {
            [npcKeys.name] = "Slitherblade Tide Priestess",
            [npcKeys.minLevel] = 33,
            [npcKeys.maxLevel] = 34,
            [npcKeys.zoneID] = 405,
            [npcKeys.spawns] = {
                [405] = {{28.4, 5.8},{29.4, 6},{29.6, 5.4},{29.6, 6},{29.6, 6.6},{30.2, 7.8},{33, 11.2},{33, 11.6},{33.2, 10.4},{33.8, 11.8},{34, 27.8},{34, 30.8},{34.4, 4.4},{34.4, 5.2},{34.4, 20.2},{34.4, 20.6},{34.4, 25.4},{34.4, 26.4},{34.4, 26.8},{34.4, 29.4},{34.4, 30},{34.6, 20},{34.6, 21},{34.6, 26.4},{34.6, 26.8},{34.6, 30},{34.6, 30.6},{35.2, 27.8},{35.2, 29},{35.6, 20.2},{35.6, 31.4},{35.8, 28.6},{36, 29.6},{36.4, 26.4},{36.4, 27},{36.4, 27.6},{36.6, 26.4},{36.6, 26.8},{36.6, 29.8},{37.4, 23.6},{37.4, 25.4},{38.4, 23.4},{38.4, 23.8},{38.4, 24.6},{38.6, 23.4},{38.6, 24},{38.8, 24.6},{39.4, 13.4},{39.4, 13.6},{39.6, 13.4},{39.6, 13.6},{40.6, 15.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218262] = {
            [npcKeys.name] = "Leprous Assistant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218263] = {
            [npcKeys.name] = "Leprous Machinesmith",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218273] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{14.4, 44.8},{15.6, 45.8},{20, 54.6},{20, 57},{21, 49.8},{22, 58.6},{22.6, 58.4},{23, 60},{23.6, 59.4},{23.8, 56.6},{24, 60.2},{24.4, 58.2},{24.4, 61.6},{24.8, 56.4},{24.8, 58.2},{24.8, 58.6},{25.2, 60.2},{25.4, 61.2},{25.8, 59.4},{26.4, 57},{26.4, 71},{26.8, 71.8},{27, 72.8},{27.2, 69.6},{27.4, 67.4},{27.4, 68.4},{27.4, 68.6},{27.6, 66.6},{27.6, 69},{27.8, 66},{27.8, 68.2},{27.8, 72.4},{28, 69.8},{28.8, 64.8},{28.8, 68},{32.4, 69},{32.4, 69.6},{32.6, 70.6},{32.6, 71.6},{33, 66.2},{33.2, 66.8},{33.4, 68.4},{33.4, 68.6},{33.4, 69.6},{33.6, 68.4},{33.6, 69.2},{33.8, 57.2},{33.8, 69.8},{34.6, 69.6},{34.8, 57.2},{34.8, 61},{35.2, 59.8},{35.4, 58.4},{35.4, 59.4},{35.6, 56.8},{35.6, 59.4},{35.6, 59.6},{35.8, 58.4},{36.6, 56.8},{37.2, 59.2},{38, 59.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218343] = {
            [npcKeys.name] = "Leprous Defender",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218344] = {
            [npcKeys.name] = "Explosive Egg",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218345] = {
            [npcKeys.name] = "Gnomeregan Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218349] = {
            [npcKeys.name] = "Walking Bomb",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218386] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218434] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218460] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218461] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218462] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218537] = {
            [npcKeys.name] = "Mekgineer Thermaplugg",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218538] = {
            [npcKeys.name] = "STX-96/FR",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218571] = {
            [npcKeys.name] = "Shade of Eranikus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218606] = {
            [npcKeys.name] = "Lumbering Dreamwalker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218610] = {
            [npcKeys.name] = "Test Creature",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218624] = {
            [npcKeys.name] = "Atal'alarion",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218627] = {
            [npcKeys.name] = "Pillar Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218683] = {
            [npcKeys.name] = "Wendel Mathers",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218690] = {
            [npcKeys.name] = "Kha'damu",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{27.2, 59},{27.4, 62.4},{28.6, 61.2},{29.6, 57.6},{29.8, 56.6},{30, 48.6},{30.2, 49.6},{30.4, 16.4},{30.4, 48},{30.8, 14},{30.8, 46.2},{31.2, 46.8},{31.2, 53.2},{31.4, 17.6},{31.4, 48.4},{31.4, 48.6},{31.4, 58.8},{31.8, 48.4},{32, 14.6},{32, 51.2},{32, 60.2},{32.2, 49.2},{32.2, 52.2},{32.4, 16.4},{32.4, 17.2},{32.4, 49.6},{32.4, 52.8},{32.4, 54},{32.4, 57.4},{32.4, 58.4},{32.4, 58.8},{32.4, 61.2},{32.6, 13.2},{32.6, 60.6},{33, 49.2},{33, 50.2},{33, 59.2},{33, 59.6},{33, 62},{33.2, 15.2},{33.2, 15.6},{33.2, 16.6},{33.2, 17.6},{33.2, 18.8},{33.2, 57},{33.2, 57.6},{33.4, 14},{33.4, 50.6},{33.4, 51.8},{33.4, 52.8},{33.4, 54.2},{33.4, 55.4},{33.4, 55.6},{33.6, 12.2},{33.6, 49.8},{33.6, 50.8},{33.6, 51.6},{33.6, 53.8},{33.6, 55.2},{33.6, 56.8},{33.8, 16.2},{33.8, 17.8},{33.8, 49.4},{33.8, 52.6},{34, 13.2},{34, 14.8},{34, 48.4},{34, 55.6},{34.2, 14.2},{34.2, 19.8},{34.4, 16.8},{34.4, 18.6},{34.4, 58.8},{34.6, 12.4},{34.6, 54.4},{34.8, 13.2},{34.8, 18.4},{34.8, 50},{34.8, 52.6},{34.8, 58.2},{35, 13.8},{35, 54.6},{35.2, 14.8},{35.2, 16.6},{35.2, 19.6},{35.4, 16.4},{35.4, 19},{35.4, 21},{35.4, 49},{35.4, 55.8},{35.6, 19.8},{35.6, 48.8},{35.6, 56.8},{36, 54.4},{36, 54.6},{36, 56.4},{36, 63.6},{36.2, 18.6},{36.4, 15.6},{36.4, 18.2},{36.4, 48.4},{36.6, 16.2},{36.6, 54.8},{36.6, 65.6},{36.8, 18.2},{36.8, 49},{36.8, 64.8},{36.8, 67.6},{37.2, 18.8},{37.2, 56},{37.2, 62},{37.4, 43.8},{37.4, 45.8},{37.4, 47.2},{37.4, 47.8},{37.6, 17.4},{37.6, 47},{37.6, 47.6},{37.6, 56.2},{37.6, 61.4},{37.8, 45.4},{37.8, 46},{38, 19.2},{38, 44.2},{38.2, 42.8},{38.2, 56.8},{38.2, 57.6},{38.2, 60.2},{38.4, 42.4},{38.4, 59},{38.6, 14.4},{38.6, 42},{38.6, 57.4},{38.6, 58.4},{38.6, 61.6},{38.8, 18.6},{38.8, 45},{38.8, 56.4},{38.8, 59.2},{38.8, 60.8},{39, 40.8},{39, 46.2},{39.2, 15},{39.2, 39.6},{39.2, 59.8},{39.4, 17.8},{39.6, 17.8},{39.6, 38.6},{39.6, 59.8},{39.8, 36},{39.8, 59.2},{40.2, 37.8},{40.4, 58.4},{40.6, 13.2},{40.6, 37.2},{40.6, 58.2},{40.8, 38.6},{41, 37.6},{41.2, 12},{41.2, 59.8},{41.4, 35.8},{41.6, 34.2},{41.6, 39.6},{42, 32.4},{42, 38.2},{42, 39.2},{42.2, 35.2},{42.4, 17.4},{42.4, 36.4},{42.4, 36.6},{42.6, 34},{42.6, 36.4},{42.6, 36.6},{42.8, 38.2},{43, 38.8},{43.2, 35.2},{43.6, 36.2},{43.6, 37.4},{43.6, 38.4},{43.8, 35.2},{44, 20.6},{44.2, 31.8},{44.4, 13.8},{44.4, 24},{44.4, 34.2},{44.6, 19.6},{44.6, 35},{44.8, 21.6},{44.8, 34.2},{45, 23.4},{45, 35.6},{45.2, 33},{45.4, 13.8},{45.4, 24},{45.4, 32.4},{45.6, 14.2},{45.6, 31.6},{45.6, 34.8},{45.8, 24},{45.8, 24.8},{45.8, 26.6},{46, 31},{46.2, 35.8},{46.4, 14.8},{46.4, 15.6},{46.4, 17},{46.4, 19.2},{46.4, 28.4},{46.6, 14},{46.6, 15.2},{46.6, 27.2},{46.8, 23.8},{46.8, 30.6},{47, 20.4},{47, 22.6},{47.2, 21.4},{47.2, 28.4},{47.2, 29.8},{47.2, 32.2},{47.4, 13.4},{47.4, 16.4},{47.4, 16.8},{47.4, 18.4},{47.4, 19.4},{47.4, 21.6},{47.6, 16.4},{47.6, 16.8},{47.6, 30.2},{47.6, 32.8},{47.6, 33.8},{47.8, 13.8},{47.8, 21.2},{47.8, 22.8},{47.8, 32},{48, 18.4},{48, 19.6},{48.2, 12.8},{48.2, 15},{48.4, 18.8},{48.6, 14.6},{48.6, 15.6},{48.6, 17.2},{48.6, 29},{48.6, 29.8},{49, 20.2},{49.2, 18.4},{49.2, 18.6},{49.4, 21},{49.6, 18.6},{49.6, 21},{49.8, 18},{50, 21.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218706] = {
            [npcKeys.name] = "Test Visual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218718] = {
            [npcKeys.name] = "Ogom the Wretched",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218721] = {
            [npcKeys.name] = "Jammal'an the Prophet",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218776] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218792] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218813] = {
            [npcKeys.name] = "Swamp of Sorrows Dart Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218819] = {
            [npcKeys.name] = "Festering Rotslime",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218868] = {
            [npcKeys.name] = "Mijan",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218869] = {
            [npcKeys.name] = "Death's Head Geomancer",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{55.8, 41.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218870] = {
            [npcKeys.name] = "Death's Head Necromancer",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.4, 41},{54, 41.2},{54.4, 40.4},{55.4, 42.8},{55.8, 42.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218871] = {
            [npcKeys.name] = "Death's Head Cultist",
            [npcKeys.minLevel] = 37,
            [npcKeys.maxLevel] = 37,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.6, 40.8},{54.8, 40.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218873] = {
            [npcKeys.name] = "Death's Head Warrior",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.4, 40.8},{54.2, 40.8},{54.8, 40.8},{55, 40.4},{55, 41.6},{55.6, 41.6},{55.8, 41.4},{56.8, 43},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218891] = {
            [npcKeys.name] = "Skeletal Servant",
            [npcKeys.minLevel] = 34,
            [npcKeys.maxLevel] = 34,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{53.2, 41.2},{53.8, 40.4},{54.2, 41.2},{54.4, 41.8},{55, 40.8},{55.2, 41.6},{55.6, 42.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218908] = {
            [npcKeys.name] = "Scarlet Crusade Assassin",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218920] = {
            [npcKeys.name] = "Dalaran Agent",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 41,
            [npcKeys.spawns] = {
                [41] = {{52, 34.2},{52, 34.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {80098,80120,80147,80148,80149,80150,80151,80152},
            [npcKeys.questEnds] = {80098,80120,80147,80148,80149,80150,80151,80152},
        },
        [218922] = {
            [npcKeys.name] = "Hukku",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218930] = {
            [npcKeys.name] = "Deadwind Steed",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218931] = {
            [npcKeys.name] = "Dark Rider",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 3,
            [npcKeys.spawns] = {
                [3] = {{57.2, 52.4},{57.4, 53.2},{57.6, 53.4},{57.6, 54.6},{57.8, 54},},
                [8] = {{67.8, 27.8},{68.6, 27.4},{68.8, 27.8},{68.8, 29.6},{69.4, 29},{69.6, 28.8},},
                [10] = {{22, 47.6},{22.2, 46.8},{22.6, 46.4},{22.6, 46.6},{22.6, 49.4},{22.8, 47.6},{24, 48.8},},
                [17] = {{52.2, 36.4},{52.2, 36.6},{52.6, 37},},
                [41] = {{42.4, 27.4},{42.4, 27.8},{42.6, 27.4},{42.6, 27.6},{42.8, 28.6},{43, 26.4},{44.4, 29.2},{44.4, 30.6},{44.6, 29.6},{44.8, 29.4},},
                [45] = {{60.4, 39.8},{60.4, 40.6},{60.6, 39.4},{60.6, 39.6},{61.4, 40.6},},
                [405] = {{64.4, 24.4},{65, 23.4},{65.2, 25},{65.2, 25.6},{65.4, 24.4},{65.6, 24.2},{65.6, 24.8},{66, 22.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218935] = {
            [npcKeys.name] = "Walking Bomb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218969] = {
            [npcKeys.name] = "STX-96/FR",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218970] = {
            [npcKeys.name] = "STX-97/IC",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218971] = {
            [npcKeys.name] = "STX-97/IC",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218972] = {
            [npcKeys.name] = "STX-98/PO",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218973] = {
            [npcKeys.name] = "STX-98/PO",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218974] = {
            [npcKeys.name] = "STX-99/XD",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [218975] = {
            [npcKeys.name] = "STX-99/XD",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219110] = {
            [npcKeys.name] = "Incendiary Bomb",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219111] = {
            [npcKeys.name] = "Frost Bomb",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219112] = {
            [npcKeys.name] = "Radioactive Bomb",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219113] = {
            [npcKeys.name] = "Radiation Leak",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219177] = {
            [npcKeys.name] = "Omen",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{44.4, 34.2},{44.8, 35},{44.8, 36.4},{45, 39.4},{47.4, 39.4},{47.6, 43},{47.8, 69.4},{48.4, 41.8},{50.8, 34},{51.2, 37.2},{51.6, 36},{51.8, 35.2},{55.8, 65.6},{59.2, 58.6},{59.8, 67},{61.2, 66},{61.8, 65.8},{64.2, 62.2},{64.4, 60.4},{65, 61.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219199] = {
            [npcKeys.name] = "Minion of Omen",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{57.8, 66.2},{61, 66},{61, 67.4},{61.4, 44.8},{62.4, 64.8},{62.8, 45.2},{63.2, 63.4},{63.6, 62.6},{63.6, 65.2},{64.4, 60.6},{64.4, 62.2},{64.6, 60.6},{64.6, 62.2},{64.8, 56.2},{65, 46.6},{65, 52.4},{65, 59.6},{65, 63},{66, 51.2},{66, 56.8},{66, 58},{66.2, 53},{66.4, 55.6},{66.8, 56.6},{67.2, 56.4},{67.8, 55},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219624] = {
            [npcKeys.name] = "Test Boss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219659] = {
            [npcKeys.name] = "High Tinker Mekkatorque",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{68, 48.4},{68.2, 48.6},{68.8, 49},{69.2, 47.4},{69.6, 49.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219663] = {
            [npcKeys.name] = "Nogg",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{75.4, 24.8},{76, 24.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219704] = {
            [npcKeys.name] = "Gurgthock",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219762] = {
            [npcKeys.name] = "SoD Test Dummy 40 DNT",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219791] = {
            [npcKeys.name] = "Tim's Stalker 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219822] = {
            [npcKeys.name] = "Chained Spirit",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{22.6, 15.4},{22.6, 15.6},{23.8, 52.6},{30.2, 73.2},{33.6, 62.4},{33.8, 52.6},{37, 68},{37.4, 64},{38.4, 8.8},{39, 45.8},{39.4, 18},{39.6, 18},{44.4, 25},{44.6, 25},{45.4, 13.4},{47.6, 34.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219986] = {
            [npcKeys.name] = "Spirit Wolf",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [219999] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220007] = {
            [npcKeys.name] = "Viscous Fallout",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220064] = {
            [npcKeys.name] = "Frozen Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220072] = {
            [npcKeys.name] = "Electrocutioner 6000",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 721,
            [npcKeys.spawns] = {
                [721] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220075] = {
            [npcKeys.name] = "[DNT] Teleporter Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220076] = {
            [npcKeys.name] = "Witch Doctor Zum'rah",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 1176,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220077] = {
            [npcKeys.name] = "[DNT] Teleporter Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220142] = {
            [npcKeys.name] = "Titanzilla",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220170] = {
            [npcKeys.name] = "King Knuckles",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220174] = {
            [npcKeys.name] = "Gamma-Ra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220178] = {
            [npcKeys.name] = "Pterodan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220179] = {
            [npcKeys.name] = "Mekatron",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220358] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220396] = {
            [npcKeys.name] = "Zul'Farrak Concoction Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220833] = {
            [npcKeys.name] = "Dreamscythe",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220864] = {
            [npcKeys.name] = "Weaver",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220908] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220929] = {
            [npcKeys.name] = "Josh's Kill Credit Creature 2 - Frix Xizzix",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220930] = {
            [npcKeys.name] = "Frix Xizzix",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220931] = {
            [npcKeys.name] = "Nightmare Thorns 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220932] = {
            [npcKeys.name] = "Nightmare Thorns 02",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220933] = {
            [npcKeys.name] = "Nightmare Thorns 03",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220934] = {
            [npcKeys.name] = "Nightmare Thorns 04",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220935] = {
            [npcKeys.name] = "Nightmare Thorns 05",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220936] = {
            [npcKeys.name] = "Nightmare Thorns 06",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220937] = {
            [npcKeys.name] = "Nightmare Thorns 07",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220942] = {
            [npcKeys.name] = "Nightmare",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [220984] = {
            [npcKeys.name] = "Fizbuz Mithril",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.6, 27.4},{51.6, 27.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81682,81877},
            [npcKeys.questEnds] = {81801,81877},
        },
        [221165] = {
            [npcKeys.name] = "Rope Climber",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221168] = {
            [npcKeys.name] = "Dire Wolf Alpha",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{36.4, 65.4},{38.2, 70.6},{41.2, 66.2},{41.4, 65.4},{41.8, 65.6},{44.2, 40.4},{44.2, 63.2},{44.4, 64.6},{44.6, 64.6},{44.8, 40.2},{45, 39},{45, 58.4},{45, 62.2},{45, 62.6},{45, 63.6},{45.2, 52.6},{45.4, 59.2},{45.4, 59.6},{45.6, 53.2},{45.6, 59.4},{45.6, 63.6},{46, 57.6},{46, 61},{46.2, 43.6},{46.2, 45},{46.2, 54.4},{46.2, 54.6},{46.2, 57.4},{46.4, 36},{46.4, 36.8},{46.4, 38.2},{46.4, 39},{46.4, 39.8},{46.4, 41},{46.4, 41.6},{46.4, 43.2},{46.4, 47.4},{46.4, 47.8},{46.4, 59.6},{46.6, 37.2},{46.6, 38.4},{46.6, 39},{46.6, 39.8},{46.6, 41},{46.6, 42},{46.6, 47.8},{46.6, 57.6},{46.6, 60.8},{46.8, 44.4},{46.8, 57.2},{47, 45.2},{47, 45.6},{47, 56.4},{47, 64},{47.2, 43.4},{47.2, 47.4},{47.2, 60},{47.2, 63.2},{47.2, 64.8},{47.4, 62.2},{47.6, 46.6},{47.6, 62},{47.8, 41.2},{47.8, 43.4},{47.8, 61.4},{47.8, 62.8},{47.8, 64},{47.8, 66},{48, 45},{48, 57.2},{48.2, 65},{48.4, 43.8},{48.6, 65.6},{48.8, 63},{48.8, 65.2},{49, 64},{49.2, 40.8},{49.2, 44.6},{49.2, 61.6},{49.8, 38},{50, 61.6},{50, 66.4},{50.4, 60.4},{50.4, 61},{50.6, 62.8},{51, 64},{51.2, 60},{53, 61.6},{53.2, 56.2},{53.2, 56.8},{53.2, 65.6},{54, 59},{54.2, 66.2},{54.4, 56.2},{54.4, 58.2},{54.4, 62.4},{54.4, 62.6},{54.6, 61.4},{54.6, 65.6},{54.8, 62.6},{55, 58.6},{55, 62.4},{55.4, 59.6},{55.6, 63.2},{56.2, 59.8},{56.8, 63.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221169] = {
            [npcKeys.name] = "Black Widow Broodmother",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{40.2, 70.2},{42.6, 38.2},{43.6, 38.8},{44, 62.4},{44.4, 58},{44.4, 62.6},{44.4, 63.6},{44.6, 64.4},{44.8, 58.4},{44.8, 62.4},{44.8, 66},{45, 38.6},{45, 63},{45.2, 52.6},{45.2, 64.6},{45.4, 51},{45.4, 59.2},{45.6, 53},{46, 57.8},{46.2, 43.4},{46.2, 54.2},{46.4, 36.2},{46.4, 37.4},{46.4, 38.4},{46.4, 38.6},{46.4, 41.8},{46.4, 55},{46.4, 55.6},{46.4, 59.4},{46.4, 59.6},{46.6, 36.4},{46.6, 42.4},{46.6, 55.4},{46.8, 39.4},{46.8, 43.4},{46.8, 56},{46.8, 59.4},{47, 44.4},{47, 44.6},{47, 49.8},{47, 56.6},{47.2, 60},{47.2, 60.8},{47.2, 61.6},{47.4, 38.4},{47.4, 39.8},{47.4, 46},{47.4, 46.8},{47.4, 47.6},{47.4, 49.4},{47.6, 38.6},{47.6, 41},{47.6, 44.6},{47.6, 61.2},{47.8, 44.4},{47.8, 48},{47.8, 56.8},{48, 37.8},{48, 46.4},{48, 59.4},{48, 64},{48.2, 37},{48.8, 69.4},{49, 57.4},{49.2, 44},{49.2, 56.4},{49.2, 57.8},{49.4, 34.6},{49.4, 44.8},{49.4, 70.4},{49.6, 58},{49.6, 66.2},{49.8, 42.4},{49.8, 45},{49.8, 45.6},{50, 43.8},{51, 59.6},{51, 71.8},{51.2, 70.8},{51.8, 71.6},{51.8, 73.2},{52, 71.4},{52.6, 70.4},{52.6, 71},{53.4, 60.4},{53.8, 67.4},{53.8, 67.8},{54.2, 68.6},{54.4, 63.8},{54.6, 60.4},{54.8, 60.6},{54.8, 68.8},{55.2, 72.2},{55.4, 61.6},{55.4, 63},{55.6, 63.2},{55.6, 63.8},{55.8, 57.2},{63.6, 60.2},{65.2, 59},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221170] = {
            [npcKeys.name] = "Uprooted Gloomwood",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{43.8, 38.6},{44, 34.2},{44.2, 36.2},{44.2, 36.6},{44.4, 63},{44.8, 36.8},{44.8, 58.4},{45, 36},{45, 51.8},{45, 52.6},{45, 58.8},{45, 64.2},{45.2, 37.6},{45.4, 39.2},{45.6, 53.4},{45.6, 57.8},{45.8, 50.6},{45.8, 64.4},{45.8, 65.6},{46, 41.4},{46, 42.8},{46.2, 45.2},{46.2, 46.6},{46.2, 54.2},{46.2, 59.6},{46.2, 64.6},{46.4, 36.2},{46.4, 37},{46.4, 37.6},{46.4, 38.8},{46.4, 39.8},{46.4, 41.8},{46.4, 44.4},{46.4, 45.6},{46.4, 50.2},{46.4, 55},{46.4, 55.6},{46.4, 57.4},{46.4, 59.4},{46.6, 36.4},{46.6, 37},{46.6, 37.6},{46.6, 38.6},{46.6, 40.4},{46.6, 41.2},{46.6, 42},{46.6, 42.6},{46.6, 55.4},{46.6, 59.4},{46.6, 59.6},{46.8, 50},{46.8, 56},{46.8, 56.8},{46.8, 65.8},{47, 35},{47, 44},{47, 45.2},{47, 60.6},{47.2, 63.6},{47.2, 64.6},{47.4, 46.4},{47.4, 47},{47.4, 47.8},{47.4, 48.6},{47.4, 62.4},{47.4, 62.6},{47.6, 40.2},{47.6, 46},{47.6, 47.2},{47.6, 47.6},{47.6, 49},{47.6, 60.2},{47.6, 61.2},{47.8, 45.2},{48, 43.2},{48, 43.8},{48, 62.4},{48.2, 64.6},{48.4, 62.8},{48.8, 44.4},{49, 64},{49, 65},{49.2, 45.2},{50.2, 41.8},{50.4, 43.4},{50.6, 61.8},{50.8, 66.8},{51.6, 62.4},{51.6, 66.4},{51.6, 67.2},{52, 67.6},{52.6, 62.4},{52.8, 66.8},{52.8, 68.2},{53, 62.8},{53.2, 64.4},{53.2, 68.6},{54.2, 60},{54.2, 69},{54.4, 62.6},{54.6, 60.8},{54.6, 63},{54.6, 64},{54.8, 64.6},{55, 59.8},{55.4, 59.2},{55.8, 63},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221171] = {
            [npcKeys.name] = "Nightmare Runner",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{50, 66.2},{50.6, 66.6},{51, 66.2},{51.4, 75.2},{52.2, 75.4},{54.4, 69},{54.6, 68.8},{54.6, 79},{55, 72.8},{55.2, 72.2},{55.4, 71.4},{55.8, 70.2},{56, 72},{56.2, 67.6},{56.2, 71.2},{56.2, 72.8},{56.4, 67.4},{56.4, 73.6},{56.6, 72.6},{56.8, 71.8},{56.8, 75},{57.2, 70.6},{57.4, 69.4},{57.6, 72},{58, 71.2},{58.2, 68},{58.2, 69.4},{58.2, 69.6},{58.2, 73.8},{58.6, 69},{58.6, 71.2},{58.8, 64.6},{59, 74.6},{59, 76.4},{59.2, 71.8},{59.2, 76.6},{59.4, 70.2},{59.4, 72.6},{59.4, 73.6},{59.6, 69},{59.6, 71},{59.6, 74.6},{59.6, 75.6},{60, 73.2},{60.2, 65.6},{60.2, 73.8},{60.4, 67.8},{60.4, 69.8},{60.4, 71.6},{60.6, 69.4},{60.6, 70},{60.6, 71},{60.6, 74},{60.6, 77},{61, 66.6},{61, 75.8},{61.2, 64.2},{61.2, 75.2},{61.4, 65.8},{61.4, 68.4},{61.4, 71.6},{61.4, 72.6},{61.6, 61.4},{61.6, 68.2},{61.6, 69},{61.6, 70.2},{61.6, 71.4},{61.6, 73.2},{61.6, 74.8},{61.8, 61.6},{61.8, 65},{61.8, 71.8},{62, 63.2},{62, 74.2},{62.2, 64},{62.2, 67.2},{62.4, 66},{62.4, 75.8},{62.8, 63.2},{63, 65.8},{63, 68.8},{63, 71.4},{63, 75.4},{63, 76},{63, 77.2},{63.2, 65.2},{63.2, 67.4},{63.2, 67.6},{63.2, 72.2},{63.2, 74.4},{63.4, 69.6},{63.4, 73},{63.6, 65.6},{63.6, 70},{63.6, 72.4},{63.6, 75.2},{63.6, 75.8},{63.6, 76.8},{64, 60.4},{64, 65.4},{64, 67.4},{64, 67.6},{64, 73},{64.2, 70.8},{64.4, 64.2},{64.4, 68.8},{64.4, 73.6},{64.6, 69.4},{64.6, 71},{64.6, 77.6},{64.8, 66.8},{64.8, 70.4},{65, 72.6},{65.2, 68.4},{65.2, 71.6},{65.2, 77.2},{65.4, 64.2},{65.4, 65.4},{65.4, 65.8},{65.4, 74.4},{65.4, 75.2},{65.4, 76.2},{65.6, 65.2},{65.6, 66},{65.6, 67.2},{65.6, 70},{65.6, 74.2},{65.6, 75.2},{65.6, 77.2},{65.8, 68.2},{65.8, 72.6},{66, 69.2},{66, 71},{66, 71.8},{66.2, 76.4},{66.2, 77.8},{66.6, 64.6},{66.6, 65.8},{66.6, 67.4},{66.6, 68},{66.6, 71},{66.8, 71.8},{66.8, 74.4},{67, 69.6},{67, 75},{67, 77.4},{67.2, 69.4},{67.2, 76.2},{67.2, 77.6},{67.6, 72.2},{67.8, 68.2},{68, 66},{68, 67.2},{68.2, 68.8},{68.4, 70.6},{70.4, 70.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221172] = {
            [npcKeys.name] = "Nightmare Weaver",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{58.4, 75.6},{59.8, 72.2},{60.2, 74.6},{60.4, 75.8},{60.6, 73},{60.6, 74},{60.8, 76},{61, 63},{61, 75.4},{61.8, 70.8},{62, 63.6},{62, 72.6},{62.2, 67},{62.4, 65.8},{62.6, 65.4},{62.6, 71.4},{62.8, 65.6},{62.8, 71.6},{63, 67.2},{63, 67.8},{63, 73.8},{63, 75.2},{63.4, 64},{63.4, 69.8},{63.4, 73.2},{63.8, 67.4},{64, 67.6},{64, 72.4},{64, 72.8},{64.2, 65.4},{64.2, 75.8},{64.4, 65.8},{64.4, 69.2},{64.4, 71.2},{64.4, 74.2},{64.4, 75.4},{64.6, 73.8},{65, 70.2},{65, 72.4},{65.2, 69.4},{65.2, 70.6},{65.2, 72.6},{65.2, 75.2},{65.4, 65.8},{65.4, 67.4},{65.4, 67.6},{65.6, 66},{65.6, 67.2},{65.6, 67.6},{65.6, 72},{65.6, 74.2},{65.8, 69.4},{65.8, 70},{65.8, 72.6},{65.8, 75.4},{66, 70.8},{66.2, 76.2},{66.6, 65.8},{66.6, 68.6},{66.8, 65.4},{67, 71.8},{67.4, 67.2},{67.6, 67.6},{67.8, 66.8},{69.2, 70.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221173] = {
            [npcKeys.name] = "Stitched Patroller",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44, 65.4},{45, 52.2},{45.2, 65.8},{45.6, 57.8},{46.2, 66.2},{46.6, 66.2},{46.8, 64.2},{46.8, 66.8},{47.8, 66},{49, 65},{49.2, 64.2},{49.4, 66.8},{50, 66.2},{52.2, 67.6},{53.4, 70.6},{53.6, 69.6},{54, 69},{54.8, 69.4},{55.4, 68.4},{56, 70.4},{56.6, 66.8},{57.8, 65.2},{58, 66.2},{58.2, 67},{59.2, 64},{60.6, 62.4},{69.8, 59.4},{70.2, 60.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221174] = {
            [npcKeys.name] = "Deranged Ogre",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{29.4, 74.8},{31.8, 74},{32, 70.8},{32.2, 67.4},{32.2, 68},{32.4, 69.2},{32.4, 69.6},{32.8, 69.4},{32.8, 70.6},{33, 70},{33, 72},{33.2, 68},{33.2, 75.8},{33.4, 73.4},{33.4, 74},{33.8, 72.2},{33.8, 73.2},{34, 68.4},{34, 74},{34.2, 68.6},{34.2, 76},{34.2, 77.4},{34.4, 69.8},{34.4, 71.4},{34.4, 75.4},{34.4, 77.8},{34.6, 69.2},{34.6, 70.2},{34.6, 75.6},{34.8, 71.4},{34.8, 71.6},{34.8, 72.6},{34.8, 75.2},{34.8, 78},{35, 74.4},{35.2, 78.8},{35.2, 79.6},{35.6, 67.6},{35.6, 71.4},{35.6, 77.8},{35.6, 79.4},{35.6, 80.4},{35.8, 76},{36, 69.6},{36, 73.6},{36.2, 69},{36.2, 72},{36.4, 77.4},{36.4, 81.2},{36.6, 72.6},{36.6, 80.2},{36.6, 81.4},{36.8, 69.4},{36.8, 77.4},{36.8, 77.8},{36.8, 78.6},{37, 82.4},{37, 82.8},{37.2, 70.4},{37.2, 70.8},{37.2, 71.8},{37.4, 84.2},{37.6, 71.6},{37.6, 72.6},{37.6, 84.4},{37.8, 70.4},{37.8, 76.2},{38.2, 73.8},{38.4, 71},{38.4, 77},{38.8, 75.4},{39, 72.2},{39, 74},{39, 75.6},{39.2, 77.2},{39.2, 77.6},{39.4, 69.2},{39.4, 70.2},{39.4, 71},{39.4, 72.6},{39.6, 73.6},{39.6, 74.6},{39.8, 72.4},{39.8, 72.6},{39.8, 78},{40, 70.6},{40.2, 69.4},{40.4, 69.8},{40.4, 77.2},{40.6, 70.4},{40.6, 73.2},{40.6, 73.8},{40.6, 75},{40.8, 69.4},{40.8, 70.6},{40.8, 76},{41, 68},{41, 77},{41.8, 69.8},{41.8, 77.4},{42, 68.6},{42.4, 68.4},{42.8, 70.4},{43, 67},{43.2, 67.6},{43.6, 68},{44.2, 66.8},{44.6, 65.6},{45.2, 71.4},{45.6, 59.2},{45.6, 65.8},{47, 77.6},{47.4, 71},{47.4, 73},{47.6, 71},{48.6, 73.6},{49, 77.4},{49.6, 66.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221175] = {
            [npcKeys.name] = "Demented Fire Weaver",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{30.6, 64.6},{31, 72},{31.4, 67.6},{31.4, 73.4},{31.6, 67.6},{31.6, 72},{32, 70.2},{32, 70.6},{32.4, 67.4},{32.4, 73.6},{32.8, 72.6},{33, 67.4},{33.2, 67.8},{33.2, 70.2},{33.2, 71},{33.4, 69.4},{33.4, 75.4},{33.8, 70.8},{33.8, 74.4},{33.8, 75.4},{34, 69.8},{34.2, 69.4},{34.2, 73.4},{34.2, 75.8},{34.2, 76.6},{34.4, 77.8},{34.6, 71.4},{34.6, 75.6},{34.6, 77.8},{34.8, 71.6},{34.8, 73.4},{34.8, 73.6},{34.8, 75.2},{35.2, 79.2},{35.4, 79.6},{35.4, 80.6},{35.6, 78},{35.6, 80.2},{35.8, 80.8},{36, 71.2},{36, 74.4},{36.4, 72.2},{36.4, 72.8},{36.4, 77.4},{36.6, 72.4},{36.6, 72.6},{36.6, 77.2},{36.6, 79.8},{36.6, 81.4},{36.6, 84.2},{36.8, 77.8},{36.8, 79.2},{36.8, 82},{36.8, 84.6},{37, 82.6},{37.4, 68.4},{37.6, 68.4},{37.6, 79.4},{37.6, 84.2},{37.8, 79.8},{38.4, 74.2},{38.6, 74},{39, 71.6},{39.4, 70},{39.4, 70.8},{39.6, 70.2},{41, 69.2},{41, 74},{41.2, 73.4},{41.6, 74},{42.8, 74.2},{44, 70},{47.6, 74},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221176] = {
            [npcKeys.name] = "Nightterror Whelp",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{38.4, 71.8},{44.4, 65.4},{45, 71.8},{45.2, 70.6},{45.6, 67.8},{45.6, 72.4},{46, 69.2},{46, 70.8},{46, 73},{46.2, 73.6},{46.4, 70.2},{46.6, 71.4},{47, 72.2},{47.2, 69},{47.2, 73},{47.2, 74},{47.2, 75},{47.4, 67.2},{47.4, 68.4},{47.4, 70.4},{47.6, 67.4},{47.6, 68.2},{47.6, 68.8},{47.6, 70.4},{47.6, 74.2},{47.8, 70.8},{47.8, 71.6},{48, 66.2},{48, 74.6},{48, 76},{48.4, 73.2},{48.4, 76.6},{48.6, 66.4},{48.6, 74.6},{48.8, 69.2},{48.8, 70.2},{48.8, 72},{49, 66.8},{49, 71.4},{49.2, 74.4},{49.4, 68.4},{49.4, 73.2},{49.4, 75.6},{49.4, 77.2},{49.4, 78.2},{49.6, 71},{49.6, 75.2},{49.8, 73},{49.8, 77.6},{50, 70},{50, 74},{50, 76.2},{50, 77.4},{50, 79},{50.2, 66.4},{50.2, 68},{50.2, 69.4},{50.4, 72.4},{50.6, 67.2},{50.6, 70.4},{50.6, 72},{50.6, 72.8},{50.6, 77},{50.8, 71.2},{50.8, 75.4},{50.8, 75.6},{50.8, 77.6},{51, 74.2},{51.4, 69},{51.4, 78.6},{51.6, 71.6},{51.6, 73.4},{51.8, 69.8},{51.8, 74},{51.8, 76.8},{52, 76},{52.4, 75},{52.6, 75.4},{52.6, 75.6},{52.6, 77.2},{52.6, 78.8},{52.8, 73},{53, 73.8},{53.6, 74.4},{54, 75.8},{54.4, 75.4},{54.6, 75.6},{55, 75.4},{55.2, 76.8},{55.6, 70.2},{58.8, 71.2},{60.4, 63},{62.2, 71.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221200] = {
            [npcKeys.name] = "Wyrmkin Terrorwalker",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{38.4, 72},{45.6, 68.2},{46, 69.2},{46.4, 71.4},{47.2, 74},{47.4, 68.6},{47.4, 70},{47.4, 71.4},{47.4, 72.4},{47.4, 72.6},{47.4, 74.8},{47.4, 78},{47.6, 70.8},{47.8, 70.4},{47.8, 72.8},{48.2, 73.6},{48.2, 76.4},{48.2, 76.6},{48.4, 72},{48.4, 75.4},{48.6, 69.4},{48.6, 72.4},{49, 73.2},{49, 74},{49, 75.4},{49, 76.4},{49, 77.4},{49.2, 78.2},{49.4, 70.4},{49.4, 71.2},{49.6, 68.4},{49.6, 75},{50, 70.6},{50, 79},{50.2, 70},{50.2, 73.2},{50.2, 76.4},{50.2, 78},{50.4, 73.8},{50.4, 76.6},{50.6, 71.8},{50.6, 76.2},{50.6, 76.8},{50.6, 78},{50.6, 78.8},{50.8, 70},{50.8, 73.6},{51, 70.8},{51, 73.4},{51.2, 69},{51.4, 74.8},{51.6, 73},{51.8, 72.4},{52, 75.2},{52.4, 74.2},{52.6, 78.8},{52.8, 74},{54.2, 74.2},{54.4, 73},{54.6, 73},{54.8, 71.4},{55, 72},{55.2, 79.6},{55.4, 73.6},{55.6, 72.4},{55.6, 72.8},{56.6, 72},{57.8, 71.2},{58.6, 71.2},{60.2, 72.6},{61.4, 62},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221201] = {
            [npcKeys.name] = "Rope Climber",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221204] = {
            [npcKeys.name] = "Ylanthrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44.2, 71.2},{44.8, 73.4},{46, 73.8},{47.2, 69.4},{47.2, 74},{47.6, 75.8},{47.8, 76.6},{48.4, 73.2},{48.4, 74.4},{48.4, 74.6},{48.6, 75.6},{48.8, 71.2},{48.8, 74.6},{49, 73.2},{49.2, 73.8},{49.6, 72.8},{49.8, 74.4},{50, 69.4},{50.2, 75.4},{50.2, 76.2},{50.4, 72},{50.6, 73.4},{51.2, 73.8},{51.2, 75.4},{56.8, 73.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221206] = {
            [npcKeys.name] = "Vvarc' Zul",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{36.4, 81.6},{36.6, 80.2},{37, 82.4},{37.2, 83},{37.4, 84.2},{37.6, 84.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221207] = {
            [npcKeys.name] = "Amokarok",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{50.2, 66.4},{52.4, 68.4},{61.6, 74.4},{62, 76.6},{63.6, 70.6},{63.6, 71.8},{64.2, 76.8},{64.4, 74},{64.6, 73.6},{65.2, 73.2},{65.2, 76.4},{65.4, 67.6},{65.4, 75.2},{65.8, 73.8},{65.8, 75.4},{66, 76.4},{66, 76.6},{66.6, 76.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221208] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221210] = {
            [npcKeys.name] = "Kroll Mountainshade",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{33.4, 71.6},{33.6, 64.8},{34.8, 71.4},{35, 73},{35.6, 80},{36, 71.4},{36.6, 81.2},{36.8, 83.2},{36.8, 84.4},{40.4, 69.4},{41, 68.8},{45, 58.2},{45.4, 50.8},{45.4, 59.2},{45.8, 53.6},{45.8, 59.8},{46.2, 40.6},{46.2, 59.4},{46.4, 39.4},{46.4, 55.6},{46.6, 39.6},{46.8, 56.8},{47, 49.6},{47, 65.6},{47.2, 61},{47.4, 47},{47.8, 42.8},{49.2, 77.2},{50, 66.4},{50, 78.4},{50.4, 73.8},{50.6, 77},{51, 66.8},{51.8, 67.2},{52, 74},{52.2, 67.8},{52.8, 68.2},{53.2, 69.2},{54.2, 69},{54.2, 75.8},{55, 57},{55.8, 74.2},{56.2, 72.4},{56.4, 67.2},{56.6, 67},{56.8, 63.4},{58, 62.4},{58, 76},{58.2, 68},{59.4, 70.4},{60.8, 65.2},{60.8, 76},{61, 63},{61, 63.8},{61, 75.2},{61.8, 64.8},{62.4, 63.2},{63, 73},{63.2, 71.6},{64, 68.4},{64, 72},{64, 74.2},{64.2, 65},{64.4, 71.2},{64.6, 67.8},{64.8, 73},{65, 69},{65, 70.8},{65.6, 67.4},{65.8, 75.4},{66, 68.4},{66, 69.2},{66.2, 76.2},{66.4, 76.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221215] = {
            [npcKeys.name] = "Alara Grovemender",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{32.6, 69.6},{34.4, 74},{34.4, 77.6},{37.2, 84.2},{40.4, 69.8},{40.8, 69.2},{41.2, 75.4},{42.2, 67.8},{43.6, 73.4},{44.2, 69.4},{44.6, 67.8},{45, 51.6},{45.4, 53},{45.4, 65.8},{45.6, 53.2},{45.6, 79.2},{45.8, 53.6},{45.8, 59.4},{46, 64},{46, 75},{46.2, 42},{46.4, 39},{46.6, 57.6},{46.8, 44},{47, 62.8},{47.2, 60.6},{47.2, 61.6},{47.2, 75.2},{47.4, 47.8},{47.4, 60.2},{47.6, 59.6},{47.8, 43},{47.8, 46.4},{47.8, 74.8},{48, 76},{48, 76.8},{48.4, 71.6},{48.4, 78},{48.6, 70.2},{49, 74},{49, 77.4},{49, 77.6},{49.4, 76.2},{49.6, 75},{49.6, 75.8},{49.6, 80},{49.8, 78},{50.2, 66.4},{50.6, 76.8},{51.8, 67.2},{52, 67.8},{52, 75},{52.4, 78},{52.4, 79.2},{52.4, 80.6},{53.4, 69.2},{54.8, 73.2},{56.8, 66.6},{59.2, 71.8},{59.6, 71.2},{59.8, 67.8},{64, 68},{64.2, 67.4},{65, 69.2},{65.2, 76.4},{65.4, 67.6},{65.6, 69.4},{65.6, 69.6},{65.8, 67.2},{65.8, 73.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221216] = {
            [npcKeys.name] = "Elenora Marshwalker",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{32.4, 69.4},{32.4, 69.6},{32.6, 69.4},{32.6, 69.8},{33.6, 70},{33.8, 73.4},{34, 73.6},{34.2, 63.2},{34.4, 64.2},{34.4, 77.8},{34.6, 65.8},{35, 71.6},{35.2, 64.2},{35.2, 70.2},{35.4, 66.6},{35.6, 80.2},{36.2, 73},{36.6, 81.6},{36.8, 72.8},{37, 72.4},{37, 83.2},{37.4, 66},{38, 71},{39, 71.2},{41.4, 63.4},{42.2, 68},{43.6, 68.2},{44, 64.8},{44.8, 58.6},{45, 52.4},{45.2, 65},{45.6, 59.2},{45.8, 51.2},{46, 64.2},{46.2, 54.4},{46.4, 38.4},{46.4, 38.8},{46.4, 55},{46.4, 59.6},{46.6, 38.6},{46.6, 41.2},{46.8, 44.2},{47, 71.2},{47.2, 49.4},{47.6, 77.6},{48.6, 75.4},{48.6, 77.2},{48.8, 61.2},{48.8, 75.8},{49.2, 66.2},{49.8, 73.4},{50.4, 74.2},{50.6, 77},{50.8, 75.4},{52.4, 68},{59, 66.4},{60.2, 71.8},{60.4, 71.2},{61, 74.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221220] = {
            [npcKeys.name] = "Dreamwarden Amalia",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{50.6, 77},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221221] = {
            [npcKeys.name] = "Dreamwarden Dorilar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{66.2, 76},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221222] = {
            [npcKeys.name] = "Dreamwarden Thalinar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{36.6, 83.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221223] = {
            [npcKeys.name] = "Duskblaze Shadowstalker",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{43.4, 33.6},{43.6, 35.4},{44, 42.6},{44.2, 37.4},{44.2, 39.6},{44.4, 35.6},{44.4, 38.4},{44.4, 39.2},{44.4, 41.4},{44.4, 41.8},{44.4, 43.6},{44.6, 40.8},{44.8, 35.8},{44.8, 44.8},{45, 35.2},{45, 42},{45, 44.4},{45, 52.6},{45.2, 39.2},{45.2, 51.6},{45.4, 36.8},{45.4, 38.4},{45.4, 40},{45.4, 43.2},{45.4, 51.2},{45.6, 51.2},{45.8, 43.6},{45.8, 53.6},{46, 42.4},{46, 43},{46, 44.6},{46, 50.4},{46.4, 36.2},{46.4, 36.6},{46.4, 38.2},{46.4, 39.2},{46.4, 40},{46.4, 40.8},{46.4, 45.8},{46.6, 36.4},{46.6, 36.8},{46.6, 38},{46.6, 38.8},{46.6, 40.2},{46.6, 40.6},{46.6, 42.2},{46.6, 42.8},{46.8, 44},{47, 45.2},{47, 49.6},{47.2, 45.6},{47.2, 47.8},{47.4, 46.8},{47.4, 49.2},{47.6, 37.4},{47.6, 37.6},{47.6, 38.6},{47.6, 41.6},{47.6, 43},{47.6, 43.6},{47.6, 46},{47.6, 47},{47.6, 48.2},{47.6, 48.6},{47.8, 41.2},{48, 40.4},{48.2, 35},{48.2, 36.4},{48.6, 40.6},{48.8, 35.8},{48.8, 40.4},{48.8, 44.8},{49, 38.2},{49, 43.2},{49.2, 34.4},{49.2, 39.2},{49.4, 36.8},{49.6, 38},{49.6, 41.8},{50, 41.4},{50.2, 38.8},{50.2, 39.8},{50.8, 41.6},{52.2, 44.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221226] = {
            [npcKeys.name] = "Firestarter Imp",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{43.4, 35.2},{43.4, 36},{43.6, 35.4},{43.6, 41.6},{43.8, 43},{44, 36.2},{44, 39.2},{44.4, 40},{44.4, 41},{44.6, 34.6},{44.8, 40.4},{44.8, 40.6},{45.2, 39.2},{45.2, 42.4},{45.4, 36.2},{45.4, 37},{45.4, 37.6},{45.4, 50.6},{45.6, 36.4},{45.6, 36.6},{45.6, 39.4},{45.6, 40.6},{45.8, 40},{45.8, 50.4},{46.2, 42},{46.4, 37.8},{46.4, 42.6},{46.4, 47},{46.6, 42.4},{46.6, 50},{46.8, 39},{46.8, 40},{46.8, 43.4},{46.8, 44.6},{46.8, 56.4},{47, 40.6},{47, 44},{47.2, 45.6},{47.2, 49.2},{47.4, 37.4},{47.4, 37.6},{47.4, 46.8},{47.6, 37.6},{47.6, 39.2},{47.6, 40},{48, 37.2},{48.2, 42.4},{48.4, 35.2},{48.4, 36},{48.6, 37.8},{48.8, 31},{48.8, 35.8},{48.8, 36.6},{48.8, 44},{49, 32.8},{49, 40.4},{49, 41.2},{49.4, 31.8},{49.4, 33.8},{49.4, 35.4},{49.4, 41.6},{49.6, 32},{49.6, 41.4},{49.8, 39.6},{49.8, 41.6},{49.8, 42.6},{50.6, 43.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221227] = {
            [npcKeys.name] = "Nightmare Hound",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{44, 41.6},{44.2, 40},{44.4, 39.4},{44.4, 41.4},{44.4, 42.6},{44.6, 38.4},{44.8, 40.8},{45, 39.6},{45, 42.4},{45, 42.8},{45.2, 44.6},{45.2, 51.2},{45.2, 51.6},{45.4, 39.4},{45.4, 53},{45.6, 51.2},{45.8, 43.2},{46, 50.4},{46.2, 42.2},{46.2, 54.2},{46.4, 36},{46.4, 37.2},{46.4, 38.2},{46.4, 39},{46.4, 39.6},{46.4, 41.4},{46.4, 43.6},{46.4, 44.8},{46.6, 37.4},{46.6, 38.2},{46.6, 39},{46.6, 40.2},{46.6, 41},{46.6, 41.8},{46.6, 42.8},{47, 36},{47, 44.6},{47, 45.6},{47, 49.6},{47.2, 44.2},{47.4, 46.6},{47.4, 47.6},{47.4, 49},{47.6, 39.8},{47.6, 42.6},{47.6, 44},{47.6, 45.2},{47.6, 46},{47.6, 47.4},{47.8, 38.4},{47.8, 39},{48, 35.4},{48.2, 37.4},{48.4, 41},{48.4, 42.2},{48.6, 39.8},{48.6, 40.8},{48.8, 38.2},{48.8, 41.6},{48.8, 42.8},{49, 44},{49, 44.6},{49.2, 34.6},{49.8, 41.2},{50, 38},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221230] = {
            [npcKeys.name] = "Nightmare Grizzly",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79.2, 46.4},{79.4, 46.6},{79.6, 46.4},{79.6, 46.6},{80.6, 48.8},{81.6, 48.6},{82.2, 46.8},{82.4, 49.6},{82.8, 48.4},{83, 48.6},{83, 60.6},{83.2, 56.4},{83.2, 56.6},{83.4, 59.8},{83.6, 47.6},{83.6, 56},{83.6, 57.8},{83.6, 60.4},{84, 45.2},{84, 46.4},{84, 59.2},{84.2, 46.6},{84.6, 46.2},{85.2, 59.8},{85.4, 59.4},{85.6, 59.8},{86, 46},{86, 56.4},{86, 56.6},{86.4, 45},{86.4, 48},{86.4, 48.6},{86.6, 47},{86.6, 48.2},{86.6, 48.6},{86.8, 44.8},{86.8, 45.6},{87, 41.8},{87, 44.4},{87, 49.6},{87, 51.4},{87.2, 52},{87.4, 41.4},{87.4, 58},{87.4, 58.6},{87.6, 49.4},{87.6, 58},{87.6, 58.6},{87.8, 41.2},{87.8, 43.2},{88.4, 42.4},{88.6, 57.8},{89, 42.2},{89, 42.8},{89.2, 40.8},{89.2, 44.4},{89.2, 45.8},{89.2, 47.2},{89.2, 47.6},{89.4, 40.4},{89.4, 44.8},{89.6, 40},{89.6, 40.6},{89.6, 44.8},{89.6, 47.2},{89.8, 38.4},{90.4, 39.4},{91, 39.6},{91.2, 39.4},{91.6, 39.6},{92.4, 39.2},{92.8, 39},{93, 40.4},{93.4, 38.2},{93.6, 39.6},{93.8, 38.4},{93.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221257] = {
            [npcKeys.name] = "Deathhorn Stag",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{82.2, 61.6},{84.2, 45.6},{84.4, 45.2},{86.4, 43.8},{86.4, 46.4},{86.4, 46.6},{86.4, 54.2},{86.4, 57.4},{86.4, 57.6},{86.6, 46.4},{86.6, 46.6},{86.6, 54},{86.6, 57.4},{86.6, 57.6},{87, 44},{88.2, 49.4},{88.8, 41},{89.4, 50.2},{89.6, 44.6},{89.8, 44.4},{89.8, 50.6},{90, 48.4},{90.2, 39.8},{90.8, 39.8},{91.4, 39.2},{91.6, 39.2},{92, 38},{93.2, 38},{93.4, 39.8},{93.6, 39.6},{93.8, 38.4},{93.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221258] = {
            [npcKeys.name] = "Dreamthorn Stalker",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.4, 45.8},{80.4, 46.8},{80.6, 46},{80.6, 46.8},{81, 44.8},{81.2, 54.2},{82.4, 53.4},{82.4, 54},{82.6, 54.2},{82.6, 54.6},{83, 55.6},{83.2, 48.6},{83.2, 52},{83.4, 48},{83.6, 51.4},{83.6, 51.6},{83.8, 46.4},{84, 47.4},{84, 47.6},{84.2, 44.8},{85, 51.4},{85, 51.6},{85.4, 45.4},{85.4, 45.6},{85.6, 45.4},{86, 43.8},{86, 46},{86, 50.6},{86.2, 43.4},{86.2, 50.4},{86.4, 41.4},{86.4, 41.6},{86.6, 44.6},{87, 40.4},{87, 41.2},{87, 41.6},{87.4, 43.4},{87.4, 43.6},{87.6, 43.4},{87.6, 43.6},{88, 42.4},{88.4, 64.2},{89, 43},{89, 43.6},{89, 62.8},{89.2, 41.4},{89.2, 42},{90.4, 39.2},{90.4, 39.6},{90.6, 39.2},{90.6, 39.6},{92.4, 35.6},{92.6, 35.2},{92.6, 35.6},{93.4, 36.6},{93.6, 36.6},{93.8, 36.4},{95.2, 39.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221259] = {
            [npcKeys.name] = "Wyrmkin Nightstalker",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.6, 48.8},{83.4, 48.2},{83.6, 48},{83.8, 45.4},{84, 45.6},{84.8, 46},{85.4, 44.4},{85.4, 44.6},{86, 46},{86.2, 44.8},{86.4, 42.4},{86.4, 43},{86.4, 44.4},{86.4, 47.2},{86.6, 44.6},{86.6, 47.6},{86.8, 43},{86.8, 46.4},{86.8, 46.6},{87.4, 43.8},{87.6, 41.2},{87.6, 43.4},{87.6, 43.6},{88.2, 41.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221260] = {
            [npcKeys.name] = "Terror Whelp",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.8, 47.6},{84, 47.2},{84.8, 46.2},{85.4, 45},{85.6, 45},{86, 46},{86.2, 44.4},{86.4, 41.4},{86.4, 41.6},{86.4, 43},{86.4, 48},{86.6, 48},{86.8, 42},{86.8, 43.4},{86.8, 43.8},{86.8, 46.2},{86.8, 46.6},{86.8, 49.2},{87, 40.4},{87, 40.6},{87, 44.6},{87, 50.4},{87, 50.6},{88.2, 41.4},{88.2, 41.6},{88.2, 42.6},{88.2, 43.6},{88.6, 41.6},{88.8, 43},{89.2, 44.2},{89.2, 44.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221261] = {
            [npcKeys.name] = "Dreamfire Betrayer",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{78.2, 44.4},{78.2, 44.6},{78.4, 45.8},{78.6, 45.8},{79, 50.2},{79.2, 46.6},{79.4, 51},{79.8, 47.2},{79.8, 49.4},{80, 47.8},{80.2, 46.4},{80.2, 50.4},{80.4, 50.6},{80.6, 46.8},{80.6, 48.8},{80.8, 49.8},{81.2, 51},{81.4, 48.4},{81.4, 51.6},{81.6, 48.4},{81.6, 48.6},{81.6, 51.4},{81.6, 51.8},{82, 52.6},{82.4, 50},{82.4, 53.6},{82.6, 50},{82.6, 54.4},{82.6, 54.6},{82.8, 52.2},{83, 55.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221262] = {
            [npcKeys.name] = "Dreamfire Hellcaller",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{78.2, 43.2},{78.2, 45.4},{78.2, 46.4},{78.2, 46.6},{79, 45.4},{79, 46.4},{79, 46.6},{80, 50.6},{80.2, 48.8},{80.2, 49.8},{80.4, 46.4},{80.4, 47},{80.4, 48.4},{80.6, 46.4},{80.6, 46.6},{81, 49.2},{81, 49.8},{81, 50.6},{81.4, 48.4},{81.6, 48.4},{81.6, 48.6},{81.6, 51.8},{81.8, 50},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221263] = {
            [npcKeys.name] = "Vengeful Ancient",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.2, 55},{80.6, 54.8},{81.2, 54.2},{82, 52.4},{82.2, 52.8},{82.4, 54},{82.4, 61.4},{82.4, 62.2},{82.4, 62.6},{82.6, 52.4},{82.6, 52.6},{82.6, 54.4},{82.6, 54.6},{82.6, 61},{82.6, 61.6},{82.6, 62.6},{83, 55.8},{83.4, 56.6},{83.4, 58.4},{83.4, 58.6},{83.4, 60.2},{83.6, 55.8},{83.6, 56.6},{83.6, 60.4},{83.6, 60.6},{83.8, 58.4},{83.8, 58.8},{83.8, 65.2},{84, 65.6},{84.2, 62.6},{84.4, 50.8},{84.4, 62.2},{84.6, 61.4},{84.6, 62.2},{84.6, 62.6},{85.2, 50.4},{85.2, 56.2},{85.2, 56.6},{85.4, 50.6},{85.4, 59.4},{85.4, 59.8},{85.4, 64.4},{85.4, 64.6},{85.4, 66},{85.4, 66.6},{85.6, 50.4},{85.6, 50.6},{85.6, 56},{85.6, 59.4},{85.6, 64},{85.6, 64.6},{85.6, 65.6},{85.8, 59.6},{86, 54},{86.2, 53.4},{86.2, 54.6},{86.4, 57.4},{86.4, 57.6},{86.4, 60.6},{86.4, 62.2},{86.4, 62.6},{86.6, 56.4},{86.6, 57.4},{86.6, 59.6},{86.6, 61.4},{86.6, 62.4},{86.6, 62.6},{86.8, 49},{86.8, 57.6},{86.8, 59.2},{87, 52.4},{87, 52.6},{87, 53.6},{87.2, 50.8},{87.4, 50.4},{87.6, 50.4},{87.6, 50.6},{87.6, 53.6},{87.8, 53.4},{88, 58.8},{88, 61.6},{88.2, 58.4},{88.2, 61.4},{88.4, 55.4},{88.4, 56.4},{88.4, 56.6},{88.6, 55.4},{88.6, 56.4},{88.6, 56.6},{88.6, 59.8},{88.6, 61},{88.6, 61.6},{88.8, 58.6},{89, 57.8},{89.2, 49},{89.2, 49.6},{89.4, 48.2},{89.4, 51.4},{89.4, 51.6},{89.4, 53.2},{89.4, 53.6},{89.6, 47.4},{89.6, 48.4},{89.6, 50.6},{89.6, 52.4},{89.6, 52.6},{89.8, 58},{90.2, 49.2},{90.2, 49.6},{90.4, 53.8},{90.6, 50.2},{91, 53.8},{91.8, 54},{92, 53.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221264] = {
            [npcKeys.name] = "Dreamharvester",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.4, 58},{83.6, 58},{84.2, 56},{84.6, 56.4},{85.6, 56.8},{88.4, 55.4},{88.4, 55.6},{88.4, 56.8},{88.4, 57.8},{88.6, 55.6},{89, 57.2},{89.2, 54.4},{89.2, 54.6},{89.4, 53.4},{89.4, 58},{89.8, 57.4},{89.8, 58},{90.6, 57.4},{91, 57.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221265] = {
            [npcKeys.name] = "Larsera",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{85.4, 45.4},{85.4, 45.6},{86, 46},{86.2, 44.4},{86.2, 44.8},{86.6, 44.2},{86.6, 44.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221266] = {
            [npcKeys.name] = "Zalius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.8, 49.4},{80.8, 49.6},{81, 50.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221267] = {
            [npcKeys.name] = "Shredder 9000",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.4, 61.4},{86.4, 61.6},{86.4, 62.8},{86.6, 61.2},{86.8, 62.4},{86.8, 62.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221268] = {
            [npcKeys.name] = "Doran Dreambough",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{87.2, 43.4},{87.2, 43.6},{89.4, 40.6},{89.6, 40.4},{91, 39.6},{93.8, 38.4},{93.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221269] = {
            [npcKeys.name] = "Maseara Autumnmoon",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.6, 49},{81, 50.2},{81.2, 50.6},{81.6, 52},{87.2, 43.8},{88.4, 55.4},{89.4, 40.4},{89.4, 40.6},{89.6, 40.4},{89.6, 40.6},{90.6, 39.8},{91.4, 39.4},{91.8, 39.2},{93.4, 38.8},{93.8, 38.4},{93.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221270] = {
            [npcKeys.name] = "Alyssian Windcaller",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4, 40.8},{89.6, 40.4},{91, 53.8},{92, 54.2},{92.4, 39.2},{93, 39},{93.8, 38.4},{93.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221271] = {
            [npcKeys.name] = "Dreamwarden Ellodar",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{83.6, 45.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221272] = {
            [npcKeys.name] = "Dreamwarden Mandoran",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{81.4, 48.4},{81.4, 48.6},{81.6, 48.4},{81.6, 48.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221273] = {
            [npcKeys.name] = "Dreamwarden Lanaria",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{91.2, 58},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221282] = {
            [npcKeys.name] = "Emberspark Dreamsworn",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{92, 39},{92.4, 38.2},{92.4, 40},{92.8, 36.2},{92.8, 38.6},{93.2, 40.4},{93.2, 40.6},{93.4, 37.2},{93.4, 38.2},{93.8, 37.8},{94, 36.4},{94, 37.2},{94, 39.4},{94.4, 40.4},{94.4, 40.6},{94.6, 39},{94.8, 37},{94.8, 38},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221283] = {
            [npcKeys.name] = "Dreampyre Imp",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4, 40.4},{89.6, 40.6},{90, 40.2},{90.4, 39.4},{90.8, 39.6},{91, 38.4},{91, 39},{91.8, 38.2},{92, 39.4},{92, 39.6},{92.4, 36},{92.4, 36.8},{92.6, 36.2},{92.8, 36.8},{92.8, 38.6},{93, 38.4},{93.4, 39.6},{93.6, 39.8},{93.8, 38.4},{93.8, 38.6},{94, 36.4},{94.4, 36.6},{94.6, 36.4},{94.6, 39.4},{94.8, 37.4},{94.8, 37.6},{94.8, 39.8},{95.6, 37.4},{95.6, 37.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221292] = {
            [npcKeys.name] = "Dreamhunter Hound",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4, 40.4},{89.4, 40.6},{89.6, 40.6},{90.4, 39.4},{90.4, 39.8},{90.6, 39.6},{91.4, 38.4},{91.4, 38.8},{91.6, 38.8},{92.4, 37.4},{92.4, 38.4},{92.4, 39.8},{92.6, 36.4},{92.6, 38.4},{92.6, 39.6},{93.4, 37},{93.4, 38.8},{93.4, 40.6},{93.6, 38.8},{93.6, 40.6},{93.8, 40.2},{94, 37.4},{94, 37.6},{94.2, 35.2},{94.2, 36.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221312] = {
            [npcKeys.name] = "Dreadfeather Hippogryph",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{54.2, 35.6},{54.4, 34},{54.8, 36.2},{55.2, 35.4},{55.6, 36.4},{55.8, 34.8},{57, 38.2},{57.2, 33.8},{57.2, 38.6},{57.4, 35.2},{57.4, 35.6},{57.6, 33.4},{57.6, 43.4},{57.8, 33.6},{58, 35.6},{58.2, 35.4},{58.2, 38.2},{58.6, 34.2},{58.6, 35},{58.6, 39},{59.2, 32},{59.2, 37.8},{59.4, 31.2},{59.4, 32.8},{59.6, 37.2},{59.6, 38},{59.8, 31.4},{59.8, 32.2},{60, 35.4},{60.2, 32.8},{60.2, 34.4},{60.2, 38.8},{60.2, 40},{60.4, 40.6},{60.6, 31.4},{60.6, 38.2},{60.6, 38.6},{60.6, 41.6},{61, 36.6},{61.2, 30},{61.2, 35.6},{61.2, 39.8},{61.2, 41.4},{61.4, 25.8},{61.4, 29.2},{61.4, 32.4},{61.4, 32.6},{61.4, 33.6},{61.4, 34.6},{61.6, 32},{61.6, 34.2},{61.6, 34.6},{61.6, 38.4},{61.8, 25.2},{61.8, 25.6},{61.8, 33},{62, 28.4},{62, 31},{62, 38.8},{62.2, 26.6},{62.4, 23.6},{62.4, 28.8},{62.4, 29.6},{62.4, 39.6},{62.4, 43},{62.6, 24.6},{62.6, 30.8},{62.8, 25.6},{62.8, 29.4},{62.8, 30.2},{62.8, 39.6},{63, 34},{63, 39.4},{63.2, 27.4},{63.2, 27.6},{63.4, 32.6},{63.6, 32.6},{63.8, 30.2},{64, 28.2},{64, 28.6},{64.2, 30.8},{64.2, 41.4},{64.2, 44.8},{64.4, 25.4},{64.4, 26.6},{64.4, 33.8},{64.6, 25.6},{64.8, 29},{64.8, 32.8},{64.8, 34},{64.8, 40.4},{65, 24.8},{65, 41.8},{65.2, 43.4},{65.4, 27.6},{65.4, 44.6},{65.6, 27.4},{65.6, 33},{65.6, 35.2},{65.6, 42},{65.8, 43.2},{65.8, 46},{66, 44.6},{66.2, 31.6},{66.2, 34.4},{66.2, 36.4},{66.2, 44.4},{66.4, 25.8},{66.6, 33},{66.6, 43.6},{66.8, 26.8},{66.8, 39},{66.8, 45.8},{67, 41.8},{67, 45.2},{67.4, 47.2},{67.6, 26.4},{67.8, 42.2},{68.2, 44.2},{68.2, 45.4},{68.2, 46},{68.2, 46.8},{68.4, 24.6},{68.6, 45},{68.8, 28.6},{69, 28.2},{69, 39.6},{69, 47.4},{69.4, 44.4},{69.4, 46.2},{69.4, 47.8},{69.6, 39.6},{69.8, 38.4},{69.8, 44.2},{70.2, 40.6},{70.2, 46.2},{70.4, 47.4},{70.4, 47.6},{70.4, 48.8},{70.6, 47.2},{71, 48.4},{72, 47.4},{72.2, 47.8},{72.6, 48.8},{72.8, 51},{73, 51.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221315] = {
            [npcKeys.name] = "Unstable Wisp",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{52, 40.4},{52.4, 39},{52.8, 37.2},{52.8, 38.8},{53, 39.8},{53, 41.4},{53.4, 37.6},{53.8, 38.4},{53.8, 38.6},{54, 39.6},{54.6, 40.6},{56, 38.2},{57.8, 19.4},{58, 16.6},{58, 33},{58.4, 32.4},{58.4, 38.2},{59, 40.4},{59.2, 27},{59.2, 32.2},{59.4, 32.8},{59.4, 40.6},{59.8, 42.2},{60, 41.4},{60.4, 40.4},{60.6, 31.4},{60.6, 38.2},{60.6, 41},{60.6, 41.6},{60.8, 37.2},{61, 28.2},{61.2, 33.2},{61.2, 35.4},{61.2, 35.8},{61.4, 24},{61.4, 34.2},{61.6, 29.4},{61.6, 33.2},{61.6, 34.6},{61.6, 42.2},{61.8, 34.4},{61.8, 36},{62, 27},{62, 36.8},{62.2, 25.2},{62.2, 28},{62.2, 31.8},{62.4, 23.4},{62.4, 24.2},{62.4, 25.6},{62.4, 29.8},{62.4, 31.4},{62.6, 30.8},{62.6, 32},{62.6, 32.8},{62.6, 33.6},{62.8, 25.4},{62.8, 25.6},{63, 30.2},{63.2, 27},{63.4, 27.6},{63.4, 28.8},{63.6, 30.4},{63.8, 31.8},{64, 30.8},{64.2, 44.8},{64.6, 31},{65.2, 30.2},{65.2, 46},{65.4, 22},{65.4, 23},{65.4, 44.2},{65.4, 44.6},{65.6, 45.4},{65.6, 46.2},{65.8, 31.2},{65.8, 46.6},{66, 44.4},{66.2, 21.4},{67, 16},{67.4, 18.2},{68, 22.8},{68, 30.4},{68, 30.6},{68.2, 23.6},{68.8, 29.8},{69.4, 48.8},{69.6, 48.4},{70.2, 49.8},{70.4, 49.2},{70.6, 48.2},{70.6, 49.2},{71.2, 47.4},{71.8, 48.6},{72, 48.4},{72.8, 51},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221324] = {
            [npcKeys.name] = "Grief-Crazed Gryphon",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{49.8, 40.4},{49.8, 40.6},{50, 39},{50.4, 41.8},{50.4, 44},{51.4, 37.4},{51.4, 38},{51.8, 39.2},{52.4, 38},{53, 36.4},{53, 39},{53.2, 34.8},{53.2, 37.2},{53.4, 38},{53.4, 50.8},{53.6, 36.8},{54.2, 34},{54.2, 38.8},{54.4, 37.8},{54.4, 43.4},{54.4, 45.6},{54.8, 34.2},{54.8, 45},{55, 37.4},{55.2, 37.8},{55.4, 34.6},{55.4, 44.2},{55.4, 45.6},{55.6, 34.6},{55.8, 34.2},{55.8, 46},{56, 35.6},{56, 50.4},{56.2, 38},{56.2, 46.8},{56.8, 38},{56.8, 47.4},{56.8, 49},{57.4, 48.2},{57.6, 37.4},{57.8, 33.8},{57.8, 48.4},{58, 35.8},{58.2, 33},{58.2, 35.4},{58.2, 48.6},{58.6, 35.6},{58.6, 46.4},{58.6, 46.6},{59, 35.4},{59.2, 17.8},{59.2, 41.2},{59.4, 31},{59.4, 33},{59.4, 34.4},{59.6, 33.6},{59.6, 35.4},{59.8, 29.4},{59.8, 30},{59.8, 35.6},{60, 33},{60.4, 32.4},{60.6, 32.2},{60.6, 39.2},{60.6, 47.6},{60.8, 31},{61, 29.8},{61, 33},{61.2, 28.6},{61.2, 36},{61.2, 47},{61.2, 49.2},{61.4, 34.4},{61.4, 41.6},{61.4, 42.6},{61.4, 44},{61.6, 32},{61.6, 41.8},{61.6, 44},{61.6, 45.6},{61.8, 36},{62, 31.2},{62, 32.6},{62.2, 23.6},{62.2, 28.2},{62.2, 34.2},{62.4, 23.4},{62.4, 25},{62.4, 29.2},{62.4, 30.2},{62.4, 35.4},{62.4, 47.2},{62.6, 24.4},{62.6, 25},{62.6, 32.2},{62.8, 29.6},{62.8, 30.8},{62.8, 32.6},{62.8, 34.4},{62.8, 43.4},{63, 26},{63, 35.8},{63, 40},{63, 44.8},{63.2, 27.4},{63.2, 27.8},{63.2, 29},{63.2, 46.2},{63.4, 34.6},{63.4, 44.4},{63.4, 48.6},{63.6, 29},{63.6, 31.8},{63.6, 35.4},{63.8, 28.2},{63.8, 29.8},{63.8, 31},{63.8, 43.4},{63.8, 44.4},{63.8, 44.6},{64, 35.6},{64, 37.2},{64, 46},{64, 48.2},{64.2, 27.2},{64.2, 33},{64.2, 34.2},{64.2, 47},{64.4, 26.4},{64.6, 27.6},{64.6, 33.2},{64.6, 44.8},{64.8, 47},{65, 43},{65, 48.6},{65, 50},{65.2, 38},{65.2, 46},{65.4, 27.2},{65.4, 34},{65.4, 37},{65.4, 42.4},{65.4, 44.4},{65.6, 26.2},{65.6, 33.4},{65.6, 36.8},{65.6, 47},{65.8, 46.4},{66, 24.6},{66, 42.4},{66, 50.2},{66.2, 26.8},{66.2, 28},{66.2, 33.8},{66.2, 38.2},{66.2, 38.6},{66.2, 43},{66.2, 44.6},{66.2, 49},{66.4, 44.4},{66.4, 48.4},{66.6, 17.8},{66.6, 38},{66.6, 39},{66.6, 46},{66.6, 47.6},{66.6, 48.8},{66.8, 43.8},{67, 41.2},{67, 43.4},{67, 45.4},{67.2, 46.8},{67.2, 50},{67.4, 42.4},{67.6, 42.4},{67.6, 43.2},{67.6, 47},{67.8, 44},{67.8, 48},{68, 33},{68, 44.8},{68, 49.4},{68.2, 45.6},{68.2, 49.8},{68.4, 40.8},{68.4, 50.6},{68.6, 28.8},{68.6, 49.6},{68.8, 45.2},{69, 46.8},{69.2, 37.2},{69.2, 39.2},{69.2, 49.4},{69.4, 45.8},{69.4, 48.2},{69.4, 51},{69.6, 40},{69.6, 45.4},{69.6, 46.6},{69.6, 49.6},{69.8, 45.8},{70.2, 51},{70.2, 51.6},{70.2, 52.6},{70.4, 44.4},{70.4, 49.4},{70.6, 50.2},{70.8, 48.4},{70.8, 51},{71, 45.4},{71, 46.4},{71.2, 47.2},{71.2, 54},{71.4, 51.8},{71.4, 53},{71.8, 45.2},{71.8, 52.6},{72, 47.4},{72.2, 47.8},{72.4, 49},{72.4, 50.2},{72.4, 50.8},{72.6, 48.6},{72.6, 50},{72.8, 50.6},{72.8, 51.6},{73, 53.8},{73.2, 53.2},{73.6, 51.2},{73.6, 53.6},{73.8, 49.6},{73.8, 52.2},{74.8, 52.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221325] = {
            [npcKeys.name] = "Wyrmkin Starhunter",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{42.6, 46.6},{43.8, 43.4},{44, 43.6},{45, 42.4},{45, 42.6},{45.2, 40.6},{45.2, 44.4},{45.2, 44.6},{45.4, 38.4},{45.4, 38.8},{45.4, 40.2},{45.6, 38.4},{45.6, 44.2},{45.8, 39.4},{46, 39.6},{46.2, 42.4},{46.2, 42.6},{46.4, 40.6},{46.4, 44.6},{46.6, 40.2},{46.6, 44},{46.8, 42.6},{47, 37},{47, 37.6},{47, 41.4},{47, 41.6},{47.4, 39},{47.8, 38.4},{47.8, 43.2},{48, 41},{48, 43.6},{48, 45.6},{48.2, 39.4},{48.2, 39.6},{48.2, 44.6},{48.4, 41.8},{48.6, 39.6},{48.6, 42.6},{48.8, 39.4},{48.8, 44.2},{49.2, 41.4},{49.2, 41.6},{49.6, 40.6},{49.8, 39.8},{49.8, 43.6},{50, 39.4},{50, 41.8},{50.8, 42.2},{50.8, 43.4},{51.2, 38},{51.2, 39.4},{51.2, 40},{51.4, 37.4},{51.4, 41.4},{51.4, 44.4},{51.6, 40.6},{52, 36.4},{52, 39.4},{52, 44.2},{52.2, 36.6},{52.4, 38},{52.4, 39.6},{52.4, 45.4},{52.6, 36.2},{52.6, 38.2},{52.6, 39.6},{52.8, 36.6},{52.8, 38.8},{52.8, 44.4},{53.4, 45.2},{53.6, 38.4},{53.8, 39.6},{54, 36.8},{54, 39.4},{54, 40.6},{54.4, 45.6},{54.8, 44.6},{55, 38.6},{55, 46.6},{55.8, 41.2},{56.2, 41.6},{58, 38.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221326] = {
            [npcKeys.name] = "Wrath Whelp",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{44.2, 40.8},{44.2, 44},{44.4, 43},{44.4, 45.4},{45, 40.8},{45, 42.2},{45, 42.6},{45.2, 34.4},{45.2, 37.2},{45.2, 44.6},{45.4, 38.8},{45.4, 40.4},{45.4, 44},{45.6, 42.4},{45.8, 39.4},{45.8, 39.6},{45.8, 40.6},{46, 42.6},{46, 44},{46.2, 33.8},{46.2, 37.2},{46.4, 36.2},{46.4, 44.6},{46.6, 38.4},{46.6, 40.4},{46.6, 46},{46.8, 34.4},{46.8, 35},{46.8, 35.8},{46.8, 36.6},{46.8, 39.2},{46.8, 43.6},{47, 32.6},{47, 41.4},{47, 41.8},{47, 42.6},{47.2, 44.6},{47.6, 33.2},{47.6, 41},{47.6, 43.6},{47.6, 44.6},{47.8, 39.4},{47.8, 42.6},{48, 37},{48.4, 34.8},{48.4, 40.2},{48.4, 41.6},{48.6, 40.4},{48.6, 40.6},{48.6, 41.6},{48.6, 42.6},{49, 39.2},{49, 43.8},{49.4, 38},{49.6, 37.4},{49.6, 38.2},{49.6, 39.4},{49.8, 40.4},{50, 41.2},{50.6, 38.8},{50.8, 42},{52, 37.8},{52, 39},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221328] = {
            [npcKeys.name] = "Dreamwater Vicejaw",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{57.2, 38.8},{57.4, 38.4},{57.6, 42.8},{58.2, 37.2},{58.2, 40.6},{58.2, 42.4},{58.4, 38.2},{58.4, 38.6},{58.6, 39},{59, 37.8},{59, 39.6},{59.2, 37.4},{59.8, 37.2},{60, 35.2},{60, 37.8},{60.4, 38.6},{60.4, 40},{60.6, 40.4},{60.8, 38.8},{61, 36.6},{61, 42.8},{61.2, 35.2},{61.2, 38},{61.6, 38.4},{61.8, 37},{62, 36.2},{62, 38.8},{62.2, 39.8},{62.4, 40.6},{62.6, 39.4},{62.8, 38.4},{63, 41.4},{63.2, 39.8},{63.2, 42.6},{63.4, 42.2},{63.6, 39.2},{63.8, 37.2},{64, 38},{64.2, 40.2},{64.2, 45.6},{64.2, 46.8},{64.4, 41.2},{64.4, 42.2},{64.4, 43},{64.4, 43.6},{64.6, 41.8},{64.6, 43},{64.8, 46.8},{65, 37.8},{65, 40.4},{65, 40.6},{65, 44.8},{65, 48},{65.2, 39.4},{65.2, 44},{65.4, 45.8},{65.6, 44.8},{65.6, 46},{65.8, 46.6},{66, 39},{66, 40.4},{66.2, 42.4},{66.2, 43.2},{66.4, 40.6},{66.4, 43.6},{66.6, 40.4},{66.6, 43.8},{66.8, 45.4},{66.8, 46.2},{67, 40.8},{67, 41.6},{67, 43.4},{67.2, 46.6},{67.4, 39.4},{67.4, 47.6},{67.6, 40.4},{67.8, 40.6},{68, 41.8},{68, 44},{68, 44.8},{68, 47},{68, 47.6},{68.2, 42.8},{68.4, 45.6},{68.8, 41},{69, 39.8},{69, 44.4},{69, 45.6},{69.2, 46.6},{69.2, 49.4},{69.4, 45.2},{69.4, 48},{70, 48.4},{70, 49},{70.2, 44.8},{70.2, 46},{70.2, 47.2},{70.2, 50.4},{70.2, 51.6},{70.4, 50.6},{70.6, 48.6},{70.6, 51.4},{70.8, 47.4},{70.8, 48.4},{71, 52.8},{71.2, 49.6},{71.4, 51.6},{71.6, 50.2},{71.6, 50.6},{71.6, 52.4},{71.8, 47.2},{72, 47.8},{72.2, 53.4},{72.2, 54},{72.6, 50.4},{73, 49},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221329] = {
            [npcKeys.name] = "Dreamhunter Hydra",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{62.2, 42.2},{63, 28.8},{63, 39.4},{63.4, 40},{63.6, 39.8},{63.8, 38.6},{64.2, 41.4},{64.2, 46.6},{64.8, 40.6},{65.2, 42.2},{65.2, 44.4},{66.2, 40.6},{66.4, 38.2},{66.4, 39.4},{66.4, 40.4},{66.4, 42.4},{66.4, 42.6},{66.4, 51.2},{66.6, 42.8},{66.8, 40.8},{66.8, 41.8},{67.2, 49.8},{67.6, 41.8},{67.6, 44.2},{67.8, 40.6},{67.8, 46.4},{67.8, 48.2},{68, 44.6},{68, 47},{68, 50.8},{68.2, 42.6},{68.4, 49},{68.6, 41},{68.6, 52.2},{68.8, 45.2},{68.8, 49.4},{68.8, 51.4},{69, 47.4},{69.2, 42},{69.2, 50},{69.4, 46.4},{69.4, 47.8},{69.6, 42.2},{69.8, 40.2},{70, 46.4},{70.2, 45},{70.2, 48.8},{70.2, 49.8},{70.4, 44.4},{70.4, 47.2},{70.4, 48.4},{70.4, 51.8},{70.4, 52.6},{70.6, 47.4},{70.6, 48.6},{70.8, 43.8},{70.8, 48.4},{70.8, 51},{71, 46.4},{71, 49.8},{71.4, 51.8},{71.6, 49},{71.6, 50},{71.6, 52.4},{71.8, 51.2},{71.8, 53},{72, 48.2},{72.2, 54},{72.4, 47},{72.6, 47},{72.8, 51.6},{73, 49.6},{73.2, 51.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221330] = {
            [npcKeys.name] = "Fallen Moonkin",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{47.4, 40.2},{48, 44.8},{48.6, 47.2},{49, 43.6},{49.4, 37.6},{49.4, 39.8},{49.6, 46.8},{49.6, 49.4},{49.8, 40.2},{50, 46.2},{50.2, 44.2},{50.4, 38.8},{51.2, 43.6},{51.8, 41.8},{52, 38},{52.2, 36.8},{52.2, 39.2},{52.2, 43.6},{52.2, 52.8},{52.4, 40},{52.8, 38},{52.8, 42.4},{52.8, 48.4},{53, 38.8},{53, 40.2},{53, 43.2},{53, 43.6},{53.2, 41.2},{53.2, 45.6},{53.4, 36.8},{53.6, 43},{53.8, 38.4},{53.8, 39.8},{53.8, 41.8},{53.8, 48.2},{54.2, 37.4},{54.2, 39.2},{54.2, 40.8},{54.4, 45.4},{54.4, 51.2},{54.6, 38.6},{54.6, 39.6},{54.6, 41.2},{54.6, 46.6},{55, 41.8},{55, 44.6},{55.2, 37.6},{55.2, 47.6},{55.4, 42.8},{55.4, 44},{55.8, 41.2},{55.8, 44},{56, 38.4},{56, 44.6},{56.2, 39},{56.2, 40.2},{56.2, 42.4},{56.2, 42.6},{56.4, 33.2},{56.4, 37.2},{56.4, 46.4},{56.6, 42.2},{56.6, 44.6},{56.8, 41.4},{57, 43.6},{57, 48.4},{57.2, 37},{57.2, 46.2},{57.4, 38.4},{57.4, 38.8},{57.4, 40.2},{57.4, 42.6},{57.4, 46.6},{57.4, 49.4},{57.6, 37},{57.6, 38.4},{57.6, 39.4},{57.6, 40},{57.8, 42.6},{57.8, 45},{57.8, 45.6},{57.8, 47},{58, 36},{58, 42.4},{58, 44},{58, 50},{58.2, 41.2},{58.4, 49.2},{58.6, 38},{58.6, 39},{58.6, 40.2},{58.6, 40.6},{58.6, 41.8},{58.6, 43.6},{59, 35.6},{59, 44.8},{59, 46.8},{59.4, 35.2},{59.4, 37},{59.4, 46},{59.4, 51.4},{59.8, 38.4},{59.8, 45.6},{59.8, 46.8},{59.8, 48.2},{60, 41.2},{60, 41.6},{60, 45},{60.2, 33.8},{60.2, 38.6},{60.2, 40.2},{60.2, 44.2},{60.4, 43},{60.6, 38.2},{60.6, 38.6},{60.6, 43.2},{60.6, 46.8},{60.6, 49.4},{60.8, 41.4},{60.8, 43.8},{61, 36.8},{61.2, 35.4},{61.2, 35.6},{61.2, 41.6},{61.2, 46},{61.4, 45.4},{61.6, 45.8},{61.8, 34.2},{61.8, 43.4},{62, 32.4},{62, 41},{63, 42.4},{63.2, 27.8},{63.6, 28.4},{63.6, 44.4},{64.2, 42.6},{65.2, 42.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221331] = {
            [npcKeys.name] = "Florius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45, 41},{45.2, 37.2},{45.8, 38.4},{46, 36.8},{46, 39.4},{46, 39.6},{46.4, 41.4},{46.6, 38.2},{47.4, 40.2},{47.4, 40.8},{47.6, 39},{47.6, 39.6},{48.6, 41.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221333] = {
            [npcKeys.name] = "Doomkin",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{48.8, 41.8},{49, 41.4},{50, 40},{53.2, 47.4},{55.2, 38.2},{55.8, 44.4},{56.2, 39},{56.2, 42.4},{56.2, 42.6},{56.4, 45},{56.6, 42.2},{56.6, 43.4},{56.6, 43.6},{56.6, 44.6},{57.4, 38.6},{57.4, 39.8},{57.4, 41},{57.6, 39.4},{57.6, 40.4},{57.8, 42.6},{58.2, 41.2},{58.2, 41.6},{58.8, 39.6},{58.8, 42},{60, 38.4},{60, 40.4},{60.6, 38.4},{61.2, 36},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221334] = {
            [npcKeys.name] = "Ghamoo-Raja",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{66, 46.2},{69.8, 49.2},{71.2, 53},{71.2, 53.6},{71.8, 54.6},{72.4, 53.4},{72.4, 53.6},{72.6, 53.2},{72.6, 53.6},{73, 51.4},{73, 52.2},{73.8, 49.8},{73.8, 51},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221335] = {
            [npcKeys.name] = "Elianar Shadowdrinker",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45, 42.2},{45.4, 38.8},{45.6, 39.2},{46.2, 40},{46.2, 40.8},{46.6, 40.2},{47, 37.6},{47.2, 41},{47.6, 39.6},{47.6, 40.8},{48.2, 42.2},{48.6, 45.4},{48.8, 37.8},{48.8, 44.2},{49, 41.4},{50, 39.8},{50, 43.2},{50.2, 39.2},{50.6, 41.6},{50.8, 40},{51.6, 37.6},{52.4, 38.6},{52.8, 39.8},{53.2, 36.8},{53.4, 39},{53.6, 39},{53.8, 38},{53.8, 40},{55.4, 40.4},{55.8, 36.8},{55.8, 39},{56.2, 42.4},{56.2, 44.4},{56.4, 37.8},{56.8, 33.8},{56.8, 43.2},{57, 37},{57, 38.2},{57, 42.2},{57, 45.8},{57.2, 40.6},{57.2, 44.2},{57.4, 34.8},{57.4, 36},{57.4, 39},{57.4, 39.8},{57.6, 36},{57.6, 37.2},{57.6, 39.4},{57.8, 42.4},{57.8, 43.4},{58, 38.4},{58, 48.8},{58.2, 41.2},{58.8, 38.2},{58.8, 38.6},{59, 35.8},{59, 46.6},{59.2, 35.2},{60.2, 38.8},{60.4, 29.8},{60.6, 30},{60.6, 33},{60.6, 38.2},{60.8, 37.2},{61, 36.2},{61.4, 31.8},{61.4, 34.8},{62, 31.2},{62, 31.6},{62, 34.8},{62.2, 30.2},{62.6, 30.6},{62.6, 41.2},{62.8, 29.4},{63, 27.4},{63, 28.2},{63.2, 42.4},{63.4, 34.4},{64.6, 43.8},{65.2, 43.2},{65.6, 43.2},{65.6, 44},{66.2, 45.2},{66.6, 43.4},{69.2, 46},{70.4, 46.8},{71, 48.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221336] = {
            [npcKeys.name] = "Serlina Starbright",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45.8, 39.2},{45.8, 40},{47.4, 40.6},{48.2, 41.2},{52.6, 39},{53.8, 37},{54, 39.2},{55.4, 44},{56, 42.8},{56.2, 42.4},{56.8, 41.4},{57.4, 39.8},{57.4, 43.2},{57.4, 43.6},{57.6, 40},{58.2, 43},{60, 44.2},{60.2, 32.8},{60.8, 37.4},{60.8, 37.6},{60.8, 39.4},{61.2, 36},{61.2, 40},{61.4, 33.8},{61.4, 43.6},{61.6, 31.8},{61.6, 33.6},{61.6, 41.8},{62, 31},{62.6, 24.2},{63.2, 27.4},{63.2, 27.6},{63.2, 41},{63.4, 32},{63.6, 43.2},{63.6, 45.4},{63.8, 43.6},{64.2, 42},{64.6, 43.6},{64.8, 44.6},{65.4, 32.2},{65.6, 42.6},{66.4, 39},{66.4, 46.4},{66.6, 44.2},{67.2, 47.8},{67.4, 41},{67.4, 46.6},{67.8, 44.8},{67.8, 48.2},{67.8, 50},{68.8, 45.6},{68.8, 47.6},{69, 48.6},{69.6, 47.4},{70.4, 48.2},{70.4, 48.8},{70.6, 48.8},{70.8, 51.2},{71, 48},{72, 43.2},{72.2, 53.8},{72.2, 54.8},{72.4, 50.6},{73.2, 50},{73.2, 51.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221337] = {
            [npcKeys.name] = "Veanna Cloudsleeper",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45, 40.6},{46.2, 39.4},{47.4, 39.6},{49.8, 39.8},{50.6, 38.6},{52.2, 39},{52.6, 39},{53.2, 40},{54, 39.2},{54, 42.2},{54.4, 41.4},{55, 42.6},{56.4, 42},{56.4, 42.8},{57.2, 40.4},{57.2, 42.4},{57.4, 38.4},{57.4, 40.6},{57.4, 42.8},{57.6, 38.2},{57.6, 39.6},{57.6, 42.8},{57.8, 41.6},{58.2, 36.2},{58.2, 41.2},{58.8, 37.8},{59, 35},{59, 35.8},{59, 46.6},{59.2, 40.8},{59.4, 40.2},{59.4, 42.8},{59.6, 39.4},{60, 42.6},{60.4, 41.2},{60.6, 39},{60.8, 40.2},{61, 36},{61, 36.8},{61, 42.2},{61.4, 32.6},{61.4, 34.6},{61.6, 33.4},{61.8, 33.8},{62.2, 38},{62.4, 24},{62.6, 30},{62.6, 31.2},{62.6, 34.4},{63, 27.4},{63, 29},{63, 43.6},{63.4, 28.2},{63.8, 43.4},{64, 46.6},{64.4, 44.4},{65, 44.6},{65.8, 33.4},{66.2, 38.4},{69.4, 46},{69.8, 40},{70.2, 49.6},{70.4, 49.2},{72, 53.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221351] = {
            [npcKeys.name] = "Dreamwarden Valori",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{56.4, 43},{56.4, 43.6},{56.6, 43.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221352] = {
            [npcKeys.name] = "Dreamwarden Sanathel",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{73.2, 54},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221353] = {
            [npcKeys.name] = "Dreamwarden Laninar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{46.8, 41.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221356] = {
            [npcKeys.name] = "Doomspark Starsworn",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{57.6, 27.6},{58.4, 28.8},{59, 28.6},{59, 34.8},{59.2, 26.2},{59.2, 27},{59.2, 33.4},{59.4, 28},{59.8, 25.2},{59.8, 34.2},{60, 28.4},{60.2, 26.4},{60.2, 26.8},{60.4, 29.4},{60.4, 29.6},{60.4, 31.2},{60.4, 31.8},{60.6, 26.2},{60.6, 26.8},{60.6, 29.4},{60.6, 29.6},{60.6, 39.2},{60.8, 25},{61, 31.4},{61, 35.6},{61, 36.8},{61.2, 28.2},{61.2, 31.6},{61.4, 32.8},{61.4, 34.4},{61.4, 34.6},{61.6, 33.4},{61.6, 34.2},{61.6, 34.6},{61.8, 31.4},{62.2, 23.2},{62.2, 27.6},{62.2, 29.2},{62.2, 32.4},{62.4, 23.8},{62.4, 24.6},{62.4, 25.6},{62.4, 27.4},{62.4, 29.6},{62.6, 23.4},{62.6, 23.6},{62.6, 32},{62.6, 32.8},{62.6, 36},{62.8, 25.4},{62.8, 26},{63, 27},{63, 30.4},{63, 31.2},{63, 33.8},{63.2, 28.8},{63.4, 27.6},{63.6, 27.2},{63.6, 27.6},{63.8, 26.2},{63.8, 29.4},{63.8, 32.8},{64, 24.2},{64, 29.6},{64, 31.4},{64.2, 25.2},{64.4, 33.8},{64.4, 34.6},{64.6, 33.6},{65, 31},{65.2, 28.8},{65.2, 30.2},{65.2, 33.4},{65.4, 23.4},{65.4, 24.2},{65.4, 25.4},{65.4, 25.6},{65.4, 27.2},{65.4, 28.2},{65.6, 25.6},{65.8, 27.6},{65.8, 31},{66, 27},{66, 30.4},{66.2, 22},{66.2, 24.6},{66.2, 33.6},{66.4, 24.4},{66.6, 23.8},{66.6, 28.2},{66.8, 32.4},{66.8, 33.6},{67, 33.4},{67.2, 34.8},{67.4, 26.2},{68, 28.2},{68.4, 27.4},{68.4, 28.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221357] = {
            [npcKeys.name] = "Stardust Imp",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{55.6, 38.2},{58.8, 28.6},{59.4, 23.8},{59.6, 22.8},{59.6, 33.6},{59.6, 45.2},{59.8, 49.6},{60, 31.8},{60, 32.8},{60.4, 28.4},{60.4, 29.4},{60.4, 29.6},{60.4, 31.4},{60.4, 38.8},{60.4, 41.2},{60.4, 42.6},{60.6, 38},{60.6, 38.6},{60.6, 41},{60.6, 45.2},{60.8, 28.2},{60.8, 29.4},{60.8, 29.8},{60.8, 43},{61, 36.8},{61.2, 25},{61.2, 35.8},{61.4, 31.4},{61.4, 31.8},{61.4, 33.4},{61.4, 34.4},{61.4, 34.8},{61.6, 32},{61.6, 33.2},{61.6, 34.2},{61.6, 34.6},{61.8, 26.6},{61.8, 35.8},{62.2, 25.4},{62.4, 23.4},{62.4, 23.6},{62.4, 25.6},{62.4, 27.6},{62.4, 29.4},{62.4, 30.2},{62.4, 30.6},{62.6, 23.4},{62.6, 23.6},{62.6, 24.8},{62.6, 30.2},{62.6, 30.8},{62.6, 31.6},{62.8, 26.2},{62.8, 28.4},{63.2, 27},{63.4, 29.4},{63.6, 25.4},{63.6, 27.8},{63.8, 24.4},{63.8, 26.6},{63.8, 29.2},{63.8, 29.6},{63.8, 31.4},{64, 26.2},{65.4, 62.8},{66, 20.4},{66.2, 21.4},{66.2, 22.4},{67.4, 26.2},{67.4, 26.6},{67.8, 26.4},{67.8, 26.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221360] = {
            [npcKeys.name] = "Starkiller Hound",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{59.8, 32},{60, 29.4},{60.2, 30.8},{60.4, 24.2},{60.4, 24.8},{60.4, 27},{60.4, 27.8},{60.4, 34.6},{60.6, 24.2},{60.6, 38.6},{60.6, 40},{60.8, 25.2},{60.8, 26.2},{60.8, 28.4},{60.8, 29.8},{60.8, 37.6},{61, 26.8},{61, 36.8},{61.2, 35.8},{61.4, 28.6},{61.4, 31.4},{61.4, 31.6},{61.4, 33.2},{61.4, 34.4},{61.4, 34.6},{61.6, 31.4},{61.6, 31.6},{61.6, 33.2},{61.6, 33.6},{61.6, 34.6},{61.8, 27},{61.8, 29.2},{62.4, 23.4},{62.4, 24.4},{62.4, 24.6},{62.4, 25.6},{62.4, 27.6},{62.4, 29.6},{62.6, 23.4},{62.6, 24.2},{62.6, 24.8},{62.6, 29.4},{62.6, 31.6},{62.8, 25.8},{62.8, 30.6},{63, 27.2},{63, 32.8},{63.2, 28},{63.2, 29.8},{63.2, 33.6},{63.6, 27.4},{63.6, 27.8},{63.6, 31.6},{63.6, 34.2},{63.8, 25.8},{63.8, 29.2},{63.8, 33},{64, 30.4},{64, 30.8},{64.6, 27.2},{64.6, 28},{64.6, 29},{64.6, 31},{64.6, 31.6},{64.8, 26.2},{65.2, 29.6},{65.2, 33.6},{65.4, 33.4},{65.4, 35.2},{65.6, 25.8},{65.6, 27.6},{65.8, 31},{66, 34},{66.2, 31.8},{66.4, 30.2},{66.6, 29.4},{66.6, 33.2},{66.8, 27.6},{66.8, 30.4},{66.8, 31.6},{67.4, 31.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221361] = {
            [npcKeys.name] = "Mad Sprite",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37, 12.6},{37.4, 12.4},{37.4, 16.2},{37.6, 16},{38.4, 16.8},{38.6, 13},{38.6, 16.4},{38.6, 17.2},{38.8, 21.8},{40.2, 20.8},{40.4, 14},{40.4, 18.2},{40.4, 22.8},{40.6, 7.2},{40.8, 15},{40.8, 17.8},{40.8, 20.4},{41, 8.4},{41.2, 10.6},{41.2, 14.4},{41.4, 9},{41.4, 9.6},{41.4, 15.6},{41.4, 24},{41.6, 9},{41.6, 24},{42, 16.6},{42.2, 21.4},{42.8, 9.4},{42.8, 13.2},{43, 23.6},{43.2, 13.6},{43.2, 23.4},{44.2, 8.8},{44.4, 7.6},{44.4, 11.8},{44.6, 11.8},{44.8, 11.4},{44.8, 12.8},{44.8, 13.6},{45.2, 19.4},{45.2, 19.6},{45.4, 21.4},{45.4, 21.6},{45.6, 9},{45.6, 19.4},{45.6, 19.6},{45.6, 21.4},{45.6, 21.6},{46, 15},{46.2, 14},{46.4, 18.4},{46.6, 6.2},{46.6, 8.4},{46.6, 18.6},{46.8, 13.4},{46.8, 14.6},{47, 10.6},{47.2, 9.8},{47.2, 13.8},{47.2, 21.6},{47.6, 7.2},{47.6, 13.4},{47.6, 13.6},{48, 7.8},{48.2, 10.4},{48.2, 10.6},{48.6, 10.4},{50.2, 10.4},{50.2, 12.4},{50.4, 12.6},{50.6, 10.2},{50.6, 12.4},{50.8, 10.6},{51, 12.6},{51.6, 12.6},{51.8, 12.2},{52.4, 9.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221364] = {
            [npcKeys.name] = "Rampaging Chimaera",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{38.4, 15.8},{38.8, 20.2},{39, 7.4},{39, 16.2},{39.2, 13.4},{39.4, 8},{39.4, 14},{39.4, 15},{39.4, 20.8},{39.6, 14.4},{39.8, 15},{40, 15.8},{40.2, 11.8},{40.4, 13.4},{40.6, 14.4},{40.6, 15.4},{40.8, 10.8},{41.2, 20.4},{41.2, 20.8},{41.4, 8},{41.6, 8.2},{41.6, 20.4},{42, 8.8},{42, 22.6},{42.2, 14.8},{42.2, 16},{42.2, 23.8},{42.4, 14.4},{42.6, 14.2},{42.6, 15.2},{42.6, 23.6},{42.8, 9.2},{42.8, 23},{43, 20.2},{43, 22},{43.8, 25.6},{44, 21},{44, 25.4},{44.2, 23},{44.2, 23.6},{44.4, 21.8},{44.8, 24.2},{44.8, 24.8},{45, 21.4},{45, 21.8},{45.4, 17.6},{45.6, 22.4},{45.8, 12.2},{45.8, 16.6},{46, 7.4},{46, 8},{46, 16},{46.4, 21.4},{46.6, 7.6},{47, 17.8},{47.4, 16.8},{47.4, 22},{47.6, 16.4},{47.6, 17.4},{49, 15.4},{49.4, 16.2},{49.4, 16.6},{49.6, 16.6},{49.8, 16.2},{50, 4.8},{50, 6.2},{50, 7.6},{50.2, 6.6},{50.6, 20},{50.8, 5},{52.8, 9.2},{53.2, 10.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221365] = {
            [npcKeys.name] = "Deathpetal Lasher",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37.6, 20.6},{38, 24.2},{38.2, 16},{38.8, 26.8},{39, 16},{39.2, 20},{39.4, 21.4},{39.4, 22.2},{39.6, 20.4},{40.2, 17},{40.2, 18.2},{40.2, 24.4},{40.4, 13.2},{40.4, 14.8},{40.4, 18.8},{40.4, 22.4},{40.6, 18.2},{40.6, 20.6},{40.6, 22.4},{40.6, 22.6},{40.8, 14.2},{40.8, 23.6},{41, 10.6},{41.2, 16.2},{41.2, 19.2},{41.4, 15},{41.4, 16.8},{41.6, 16},{41.6, 17},{41.6, 17.8},{41.8, 14.6},{42, 9.2},{42, 21.8},{42.2, 11.2},{42.2, 12.2},{42.2, 14.2},{42.2, 20.4},{42.2, 21},{42.4, 12.6},{42.4, 23.2},{42.6, 19.8},{42.6, 21.4},{42.8, 9.4},{42.8, 21.6},{43, 10.4},{43, 24.8},{43.2, 12.4},{43.4, 11},{43.4, 13.4},{43.4, 13.6},{43.6, 11.8},{43.6, 21},{43.8, 9},{44, 8.4},{44.2, 20.4},{44.2, 21.8},{44.4, 9.6},{44.4, 10.8},{44.4, 13.2},{44.4, 22.8},{44.6, 8.2},{44.6, 10.4},{44.6, 10.8},{44.8, 22.2},{45, 9.2},{45, 19.8},{45.4, 12.2},{45.4, 12.8},{45.4, 18.4},{45.4, 19},{45.4, 21.4},{45.4, 23.2},{45.6, 10.4},{45.6, 12.2},{45.6, 17.2},{45.6, 19},{45.6, 19.8},{45.8, 8.8},{45.8, 22.4},{46, 13},{46, 22.8},{46, 23.8},{46.2, 10.6},{46.2, 13.6},{46.2, 15.6},{46.2, 20.8},{46.2, 25.4},{46.4, 15.4},{46.4, 18.2},{46.6, 15.6},{46.6, 18},{46.6, 18.8},{46.6, 20.2},{46.6, 22.6},{46.8, 15.4},{46.8, 21.4},{47, 6.6},{47, 9.4},{47, 13.4},{47, 21.6},{47.2, 14},{47.4, 8.4},{47.4, 10.4},{47.4, 11.2},{47.4, 11.8},{47.6, 9.2},{47.6, 10.4},{47.6, 11.4},{47.6, 11.8},{47.6, 14},{47.8, 8.4},{47.8, 13.4},{47.8, 15.4},{47.8, 16},{47.8, 16.6},{48.6, 12.2},{49.2, 16},{49.4, 8.2},{49.4, 15},{50, 8},{50, 14.4},{50, 15.6},{50.2, 7.2},{50.2, 10},{50.2, 15},{50.4, 9.4},{50.4, 11},{50.4, 11.8},{50.4, 12.6},{50.4, 17},{50.6, 9},{50.6, 10.2},{50.6, 17.2},{50.6, 17.8},{50.6, 20.8},{50.8, 7.4},{50.8, 11.8},{50.8, 12.6},{51, 19},{51.2, 10.8},{51.8, 11.6},{52.2, 10.6},{52.4, 8},{52.4, 15.8},{52.6, 8.2},{52.8, 9.2},{53.2, 11},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221367] = {
            [npcKeys.name] = "Wyrmkin Berserker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{47, 17.8},{47.2, 16.8},{47.4, 16.4},{47.6, 16.8},{47.8, 16},{48.4, 10.4},{48.4, 11.4},{48.4, 11.6},{48.4, 15.2},{48.6, 11.6},{48.8, 10.6},{49.2, 14.4},{49.4, 8.4},{49.4, 8.6},{49.4, 15.2},{49.4, 15.8},{49.6, 6.6},{49.6, 8.4},{49.6, 15.6},{50, 6.2},{50, 14.4},{50, 14.6},{50, 24.8},{50.4, 17},{50.4, 17.6},{50.4, 22},{50.6, 5.4},{50.6, 5.6},{50.6, 17.2},{50.6, 17.6},{50.6, 19},{50.6, 19.8},{51, 7.4},{51, 7.6},{51, 15.4},{51.2, 15.8},{51.6, 14.6},{51.8, 5.2},{51.8, 6},{52.2, 16.6},{52.4, 16},{52.6, 15.4},{53, 16.6},{53.2, 8},{53.2, 8.8},{53.2, 12.2},{53.2, 16},{53.6, 12.2},{53.6, 13.4},{53.6, 13.6},{53.6, 15.2},{53.6, 15.6},{54, 10.4},{54.2, 10.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221369] = {
            [npcKeys.name] = "Frenzied Whelp",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{45.4, 14},{46, 14.4},{46, 14.6},{46.4, 13},{46.6, 12.8},{47.2, 14.6},{47.4, 14.2},{48.2, 13.4},{48.2, 13.8},{48.6, 10.4},{48.6, 13.2},{48.8, 10.8},{49, 9},{49, 12.2},{49.4, 8.2},{49.8, 24.8},{50, 15.4},{50.2, 16.2},{50.4, 17},{50.4, 22.2},{50.4, 22.8},{50.6, 17.2},{50.6, 21},{50.6, 22.2},{50.6, 24.8},{50.8, 19.4},{50.8, 19.6},{50.8, 22.6},{51, 11.4},{51, 11.6},{51, 18.4},{51, 23.6},{51.4, 16.2},{51.6, 16},{51.6, 16.6},{51.6, 19.6},{51.8, 15.4},{52.8, 16.4},{53, 16.6},{53.4, 15},{53.6, 15.8},{53.8, 13.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221370] = {
            [npcKeys.name] = "Dreamspring Roguefeather",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37.4, 14.2},{37.8, 11.8},{38, 14.4},{38, 14.6},{38.2, 10.4},{38.2, 11.4},{38.4, 13},{38.4, 15.8},{38.4, 16.6},{38.6, 11.4},{38.6, 15.8},{38.6, 16.6},{38.8, 14.8},{39, 11.8},{39, 13.4},{39.2, 13.6},{39.4, 10},{39.6, 13.8},{39.6, 15.4},{39.8, 10.2},{39.8, 12.6},{40, 9.2},{40, 12.4},{40, 15.6},{40.4, 8.4},{40.4, 10.6},{40.6, 8.2},{40.6, 8.6},{40.6, 15},{41.2, 9.8},{41.2, 12.8},{41.4, 11.4},{41.4, 11.8},{41.4, 14.4},{41.6, 8.4},{41.6, 8.6},{41.6, 11.4},{41.6, 11.6},{41.6, 12.8},{41.6, 14},{41.6, 14.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221371] = {
            [npcKeys.name] = "Dreamspring Stormcaller",
            [npcKeys.minLevel] = 49,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{36.8, 13.8},{37.2, 12.6},{37.2, 15.8},{37.4, 12.4},{37.4, 14.8},{37.8, 11.8},{37.8, 12.6},{37.8, 14.6},{38, 11.4},{38, 14.2},{38.4, 10.4},{38.4, 15.8},{38.4, 16.6},{38.6, 14},{38.6, 15.4},{38.8, 10},{38.8, 16.6},{39, 13.4},{39.2, 16.2},{39.4, 9.2},{39.4, 10.6},{39.4, 12.4},{39.6, 10.8},{39.6, 12.8},{39.6, 14.8},{39.6, 15.6},{39.8, 9.6},{40, 9.4},{40, 12.4},{40, 13.6},{40.4, 8.2},{40.6, 9.6},{40.6, 13.6},{40.8, 8.2},{40.8, 12.2},{41, 10.8},{41.2, 13},{41.2, 15.4},{41.4, 9.4},{41.6, 7.2},{41.6, 14.8},{41.8, 8.4},{42, 9},{42.2, 11.2},{42.2, 12},{42.4, 9.6},{42.8, 9.4},{42.8, 9.6},{43.2, 10.8},{43.2, 12.8},{43.4, 11.6},{43.6, 11},{43.8, 10},{44, 7},{44.4, 8.4},{44.4, 9.4},{44.4, 12.2},{44.8, 9.8},{44.8, 10.8},{45, 9.4},{45.2, 12},{45.4, 8.4},{45.6, 10},{45.8, 8.4},{45.8, 13.2},{47.2, 11.6},{47.8, 7.8},{51, 11.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221373] = {
            [npcKeys.name] = "Enraged Mountain Giant",
            [npcKeys.minLevel] = 49,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{38.2, 15.8},{39.4, 11.8},{40, 16.4},{40, 17},{40.2, 11.6},{40.2, 12.8},{40.2, 13.6},{40.4, 10.4},{40.4, 10.6},{40.4, 15},{40.6, 14.4},{40.8, 15.4},{40.8, 17},{41, 11},{41, 13.2},{41.2, 9.6},{41.2, 17.8},{41.4, 8.8},{41.6, 15.8},{42.2, 9.2},{42.2, 17},{42.2, 17.8},{42.2, 20.2},{42.8, 9.8},{42.8, 12.4},{43.2, 8.6},{43.2, 11},{43.2, 13.4},{43.6, 12.2},{44.2, 11.4},{44.2, 12.8},{44.2, 20.4},{44.4, 8.4},{44.4, 22},{44.6, 8.4},{44.6, 12.6},{44.8, 22.2},{45, 8.6},{45, 14.2},{45, 19.8},{45.2, 22.6},{45.4, 9.6},{45.4, 19},{45.4, 21},{45.6, 18.2},{45.6, 21.6},{45.8, 15.2},{45.8, 16.4},{45.8, 16.8},{45.8, 18.6},{46, 20},{46.6, 8.2},{46.6, 14},{48, 16.8},{49.4, 16.4},{49.6, 15.4},{49.6, 25.4},{50, 16},{50.4, 17},{50.4, 22.2},{50.4, 23},{50.6, 17.2},{50.6, 19.8},{50.6, 22.8},{50.8, 9},{50.8, 17.8},{51, 7.6},{51, 19},{51, 20.6},{51, 22},{51.2, 16.2},{53.2, 14.8},{53.6, 13.6},{54.2, 9.8},{55.6, 12},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221375] = {
            [npcKeys.name] = "Lost Daughter",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{40.4, 21},{40.6, 20.6},{41.4, 15.2},{41.4, 15.8},{41.4, 18.4},{41.6, 15.2},{41.6, 15.8},{41.6, 18.2},{42.2, 21},{42.4, 19.8},{42.6, 19.8},{42.8, 21.4},{43, 13},{43.2, 13.6},{44.2, 21.4},{44.2, 21.6},{44.2, 23},{45, 12.4},{45, 12.6},{45, 22.6},{45, 25},{45.2, 8.2},{45.2, 9},{45.2, 19.6},{45.2, 21.4},{45.2, 21.6},{45.6, 19.8},{45.6, 22.2},{45.6, 22.8},{45.8, 16.6},{46, 16.4},{46, 24.2},{46, 24.8},{46.2, 18.8},{46.4, 14.4},{46.4, 14.8},{46.4, 17.6},{46.4, 21},{46.6, 14.4},{46.6, 14.6},{46.6, 16},{46.8, 21.4},{47, 21.6},{49.4, 15},{49.6, 15.2},{49.8, 15.8},{50.4, 17},{50.6, 17},{50.8, 11.4},{51.2, 15.8},{51.6, 16.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221377] = {
            [npcKeys.name] = "Vengeful Son",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{38.6, 16},{39.8, 14.8},{40.2, 15.6},{40.2, 16.8},{40.4, 18.2},{40.4, 18.8},{40.8, 18.6},{41.2, 14.4},{41.2, 15},{41.2, 16.8},{41.4, 15.6},{41.4, 18},{41.6, 15.2},{41.6, 15.6},{41.6, 17.8},{41.8, 17.2},{42.2, 19.4},{42.4, 12.8},{42.4, 13.8},{42.4, 19.8},{42.6, 19.2},{42.6, 19.8},{42.8, 12.4},{42.8, 12.8},{43.2, 22},{43.2, 24.4},{43.4, 11.2},{43.4, 13.6},{43.4, 25},{43.6, 25.2},{44, 23},{44, 23.6},{44.2, 11.4},{44.2, 21.4},{44.4, 12.4},{44.4, 12.6},{44.4, 22.2},{44.6, 12.4},{44.6, 13},{44.6, 22.6},{44.8, 11.2},{44.8, 13.6},{45, 19.8},{45, 22.4},{45.2, 25.2},{45.2, 25.6},{45.4, 17.4},{45.4, 18.4},{45.4, 19},{45.4, 20.6},{45.6, 12.2},{45.6, 19},{45.6, 19.8},{45.6, 20.8},{45.6, 21.8},{45.8, 15.4},{45.8, 16.6},{45.8, 23.2},{46, 13.4},{46, 16.4},{46, 25.2},{46, 25.6},{46.2, 17.6},{46.2, 24.4},{46.4, 14.4},{46.6, 14.4},{46.6, 16},{46.6, 20.4},{46.6, 21.2},{46.6, 24},{46.6, 24.8},{46.6, 25.6},{46.8, 14.6},{46.8, 18.8},{46.8, 21.6},{47, 17.8},{47.2, 17},{47.4, 9.4},{47.6, 9},{47.6, 10},{47.6, 14},{47.6, 15.6},{47.8, 7.8},{47.8, 11.4},{48.2, 12.8},{48.2, 14.6},{48.4, 12.4},{48.6, 8.4},{48.8, 11.2},{48.8, 12.8},{49.6, 4.8},{50.4, 12},{51, 11.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221389] = {
            [npcKeys.name] = "Alondrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{45.8, 11.6},{45.8, 21.8},{46, 12.8},{46, 16.6},{46.2, 14.2},{46.2, 15.4},{46.2, 16.4},{46.2, 19.8},{46.4, 18.4},{46.4, 19.4},{46.4, 20.8},{46.6, 16.6},{46.6, 18.8},{46.6, 21.4},{46.8, 13.4},{46.8, 14.4},{46.8, 16.2},{46.8, 19.6},{46.8, 21.6},{47, 15.4},{48, 14.8},{48.4, 14.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221391] = {
            [npcKeys.name] = "Slirena",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{38.2, 14.4},{38.4, 11.6},{38.4, 13},{38.4, 15.8},{38.4, 24.6},{38.6, 14.6},{39, 10.4},{39, 13.4},{39.2, 13.6},{39.6, 13.8},{39.8, 13},{40, 12.4},{40.6, 10.6},{40.6, 13},{41, 13.6},{41.2, 9.4},{41.4, 11.8},{41.4, 14.8},{42.8, 9},{46, 11.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221393] = {
            [npcKeys.name] = "Tyrannikus",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{50.2, 16.4},{50.4, 14.2},{50.6, 21},{50.8, 12},{51, 14.6},{51.2, 13.4},{51.2, 15.8},{51.4, 16.6},{51.6, 13.4},{52, 14.2},{52.2, 15},{52.2, 16.8},{52.4, 16.2},{52.6, 15.2},{53, 16.4},{53.2, 14.4},{53.2, 16.6},{53.6, 17},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221394] = {
            [npcKeys.name] = "Avatar of Hakkar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221395] = {
            [npcKeys.name] = "Mellias Earthtender",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{49.4, 15.2},{49.6, 15.4},{49.6, 15.6},{50.4, 12.8},{50.6, 12.6},{50.8, 12},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221396] = {
            [npcKeys.name] = "Hakkari Bloodkeeper",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221398] = {
            [npcKeys.name] = "Nerene Brooksinger",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{45.8, 16.4},{45.8, 16.6},{49.2, 12.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221399] = {
            [npcKeys.name] = "Jamniss Treemender",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{40.4, 8.2},{40.6, 8},{41.2, 8.6},{44, 8.4},{48.6, 11.8},{49.8, 12.2},{51, 11.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221400] = {
            [npcKeys.name] = "Kajind",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{25.4, 66.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81697,81801},
            [npcKeys.questEnds] = {81682,81697},
        },
        [221401] = {
            [npcKeys.name] = "Dreamwarden Sheldryn",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{50.6, 19.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221402] = {
            [npcKeys.name] = "Dreamwarden Gorlas",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{47, 21.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221404] = {
            [npcKeys.name] = "Dreamwarden Anadelle",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{37.6, 12},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221406] = {
            [npcKeys.name] = "Moonwalker Betrayer",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.2, 13.2},{48.4, 12.4},{48.6, 12.4},{48.6, 12.6},{48.8, 11.4},{50, 12},{50.2, 11.2},{50.4, 12.8},{50.6, 12.8},{50.8, 10.4},{50.8, 11.8},{51, 11},{51.6, 11.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221407] = {
            [npcKeys.name] = "Dreamshadow Imp",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{43.4, 13},{46.6, 10.4},{46.6, 13.6},{47.4, 11.2},{48.4, 12.4},{48.4, 12.6},{48.6, 12.4},{48.6, 12.6},{49.2, 13.6},{49.4, 11.4},{49.6, 14},{50.2, 10.4},{50.2, 10.8},{50.2, 12.4},{50.2, 12.6},{50.4, 7.4},{50.4, 7.6},{50.4, 9.2},{50.6, 7.4},{50.6, 7.6},{50.8, 5},{50.8, 10.4},{50.8, 10.6},{50.8, 11.6},{51, 12.6},{51.4, 13.6},{51.6, 7.8},{51.6, 11.2},{51.6, 11.8},{51.6, 13.6},{51.8, 12.8},{52, 6.2},{52.6, 8.4},{52.8, 8.6},{53.2, 10.2},{53.4, 14.2},{53.4, 14.6},{53.8, 12},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221408] = {
            [npcKeys.name] = "Night Hunter",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{50, 11.2},{50, 12.2},{50.2, 12.6},{50.4, 10},{50.6, 10},{50.8, 11.6},{51, 12.8},{51.2, 10.8},{51.6, 12.6},{51.8, 11.8},{52, 11.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221426] = {
            [npcKeys.name] = "Atal'ai Ritualist",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221471] = {
            [npcKeys.name] = "Field Captain Palandar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{45.4, 51.4},{45.6, 51.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81716},
            [npcKeys.questEnds] = {81716,81730,81731,81732,81733,81734,81735,81736,81737,81738,81739,81740,81741,81742,81743,81744,81745,81746,81747},
        },
        [221472] = {
            [npcKeys.name] = "Scout Charla",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{47, 36},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221477] = {
            [npcKeys.name] = "Field Captain Hannalah",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4, 40.6},{89.6, 40.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81727,82017},
            [npcKeys.questEnds] = {81727,81768,81769,81770,81771,81772,81773,81774,81775,81776,81777,81778,81779,81780,81781,81782,81783,81784,81785},
        },
        [221479] = {
            [npcKeys.name] = "Field Captain Korlian",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{61.4, 34.4},{61.4, 34.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81728,82068},
            [npcKeys.questEnds] = {81728,81786,81787,81788,81789,81817,81820,81826,81830,81832,81833,81834,81835,81837,81838,81839,81850,81851,81852,82068},
        },
        [221480] = {
            [npcKeys.name] = "Field Captain Arunnel",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.6, 12.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81729,82068},
            [npcKeys.questEnds] = {81729,81855,81856,81857,81858,81859,81860,81861,81863,81864,81865,81866,81867,81868,81870,81871,81872,81873,81874,82068},
        },
        [221482] = {
            [npcKeys.name] = "Scout Gemeron",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{93.8, 35.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221483] = {
            [npcKeys.name] = "Scout Fallia",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{61.8, 24},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221484] = {
            [npcKeys.name] = "Scout Thandros",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{51, 10.4},{51, 10.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221493] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221575] = {
            [npcKeys.name] = "Elrick",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 15,
            [npcKeys.spawns] = {
                [15] = {{66.4, 45.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81765},
            [npcKeys.questEnds] = {81764},
        },
        [221587] = {
            [npcKeys.name] = "Aeonas the Vindicated",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{45, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81885,82135},
            [npcKeys.questEnds] = {81885},
        },
        [221631] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221636] = {
            [npcKeys.name] = "Gregory",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{44.6, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81790},
            [npcKeys.questEnds] = {81790},
        },
        [221637] = {
            [npcKeys.name] = "Gasher",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221638] = {
            [npcKeys.name] = "Loro",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221639] = {
            [npcKeys.name] = "Zolo",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221640] = {
            [npcKeys.name] = "Zul'Lor",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221651] = {
            [npcKeys.name] = "Ceruleos",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{36, 68.8},{36.2, 70},{36.6, 71.2},{37, 71.6},{37, 72.6},{37.6, 71.2},{38.2, 72.4},{38.4, 73},{38.8, 73},{39.4, 72.4},{40, 71.8},{41.2, 73},{41.4, 72.4},{41.6, 72.2},{41.6, 72.6},{42.6, 71.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221656] = {
            [npcKeys.name] = "Stern-faced Bar Patron",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 15,
            [npcKeys.spawns] = {
                [15] = {{66.4, 45.4},{66.6, 45.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221658] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221732] = {
            [npcKeys.name] = "Atal'ai Defenders Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221740] = {
            [npcKeys.name] = "Calefactus the Unleashed",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{44, 35.4},{44, 38.2},{44, 38.8},{44.4, 36.2},{44.4, 37.2},{44.6, 39},{45, 37.2},{45, 38.2},{45, 39.6},{45, 49.2},{45.2, 31.8},{45.2, 50.6},{45.4, 48.2},{45.4, 53},{45.4, 54.2},{45.6, 40.2},{45.8, 32.2},{45.8, 34},{46, 51.2},{46.2, 37.2},{46.2, 52.8},{46.2, 54},{46.4, 34.6},{46.4, 35.6},{46.4, 37.6},{46.4, 38.6},{46.4, 47.2},{46.4, 52.4},{46.6, 36.8},{46.6, 38},{46.6, 49.2},{46.6, 52},{46.6, 55},{46.8, 34.4},{47, 34.6},{47, 47.4},{47, 47.8},{47, 52.6},{47.6, 48.6},{47.8, 34.4},{48, 51.6},{48.2, 34.6},{48.2, 48.2},{48.6, 51.2},{48.8, 48.2},{49, 37.2},{49.4, 37.6},{49.4, 38.8},{49.8, 52.2},{50, 36.6},{50, 39},{50.2, 36.4},{50.2, 38.2},{50.6, 50.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221759] = {
            [npcKeys.name] = "Gasher",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221761] = {
            [npcKeys.name] = "Hakkar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221762] = {
            [npcKeys.name] = "Hakkar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221827] = {
            [npcKeys.name] = "Magister Falath",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{26.4, 10.2},{26.6, 9.4},{27, 8.4},{27.4, 9.8},{27.4, 10.6},{27.6, 10.2},{27.6, 11.2},{27.6, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221828] = {
            [npcKeys.name] = "Vengeful Spirit",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{28.8, 47.4},{29.2, 47.8},{29.8, 50.2},{30.8, 49.6},{30.8, 50.8},{31.2, 43.8},{31.8, 44},{32, 50.4},{32.4, 44.8},{32.4, 45.8},{32.4, 47.4},{32.4, 48.4},{32.4, 49.2},{32.6, 45},{32.6, 46},{32.6, 46.8},{32.8, 44},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221829] = {
            [npcKeys.name] = "Kajind",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.4, 27.6},{51.6, 27.4},{51.6, 27.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221830] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 48,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.4, 27.6},{51.6, 27.4},{51.6, 27.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221831] = {
            [npcKeys.name] = "Gos Greasebasher",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{51.4, 27.6},{51.6, 27.6},{51.8, 27.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221832] = {
            [npcKeys.name] = "Silver Hand Charger",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{51, 81.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221833] = {
            [npcKeys.name] = "Hukku",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221834] = {
            [npcKeys.name] = "Loro",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221835] = {
            [npcKeys.name] = "Mijan",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221836] = {
            [npcKeys.name] = "Zolo",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221837] = {
            [npcKeys.name] = "Zul'Lor",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221838] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221916] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221924] = {
            [npcKeys.name] = "Kazkaz the Unholy",
            [npcKeys.minLevel] = 48,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221928] = {
            [npcKeys.name] = "Hippogryph Avatar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{33.6, 48},{34.4, 48.8},{34.6, 49},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221933] = {
            [npcKeys.name] = "Moonkin Avatar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{66, 53},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221935] = {
            [npcKeys.name] = "Treant Avatar",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{57.4, 51.4},{58, 52.8},{58.4, 52},{58.6, 52},{59, 51.2},{59, 53.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221942] = {
            [npcKeys.name] = "Morphaz",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221943] = {
            [npcKeys.name] = "Hazzas",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221981] = {
            [npcKeys.name] = "[DNT] Sleeping Copy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [221985] = {
            [npcKeys.name] = "Tyrisius",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{57.2, 69},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81924},
            [npcKeys.questEnds] = {81924},
        },
        [222004] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Water",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{15, 49.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222005] = {
            [npcKeys.name] = "Moderate Manifestation of Water",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{14.8, 49.4},{14.8, 49.6},},
                [357] = {{35.8, 32.4},{35.8, 32.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {82076},
            [npcKeys.questEnds] = {82073,82076},
        },
        [222008] = {
            [npcKeys.name] = "Rope Climber",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222044] = {
            [npcKeys.name] = "Twilight Dark Shaman",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{35, 32.8},{35.2, 32.4},{35.4, 34.8},{35.8, 32.4},{35.8, 32.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222052] = {
            [npcKeys.name] = "Explorer Imp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81967,82301,82302,82303},
            [npcKeys.questEnds] = {81967,82301,82302,82303},
        },
        [222058] = {
            [npcKeys.name] = "Bonfire",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222088] = {
            [npcKeys.name] = "Nightmare Whelpling",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222089] = {
            [npcKeys.name] = "Nightmare Scalebane",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222174] = {
            [npcKeys.name] = "Dual Spec Peon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222188] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 493,
            [npcKeys.spawns] = {
                [493] = {{52, 40.6},{52.2, 40.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81986,82021,82022},
            [npcKeys.questEnds] = {81986,82021,82022},
        },
        [222192] = {
            [npcKeys.name] = "Nightmare Vine",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222198] = {
            [npcKeys.name] = "Nightmare Amalgamation",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{85.4, 62.8},{85.6, 67},{86.8, 62.2},{87.2, 68.6},{87.8, 63.2},{87.8, 68.2},{88.2, 67.4},{88.2, 68.6},{88.4, 64.8},{88.6, 66},{88.6, 67},{88.6, 68.2},{88.6, 68.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222210] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222225] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222228] = {
            [npcKeys.name] = "Fel Sliver",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{39.4, 13.8},{39.6, 13.8},{40, 18.4},{40.8, 14.4},{42, 14.2},{44.4, 50},{45.8, 51.2},{46.4, 52.6},{47.6, 49.4},{51.8, 53.4},{53, 50.8},{54.2, 52.6},{54.4, 48.4},{54.4, 48.6},{55.6, 25.6},{55.8, 51},{56, 24.8},{57.6, 23.4},{57.6, 23.6},{58.2, 49.6},{58.8, 25.8},{59, 29.2},{59, 32},{59.2, 36.4},{59.2, 36.6},{59.8, 27.4},{59.8, 27.6},{60.2, 36},{60.8, 29},{61.8, 32},},
                [40] = {{28.6, 44},{29, 47.8},{29, 58.2},{29, 58.8},{29.6, 69.4},{29.8, 34.4},{31.4, 39.2},{31.4, 39.6},{31.4, 65},{31.4, 65.6},{31.8, 39.4},{32.2, 76},{32.2, 80.2},{32.4, 29.2},{34, 82.2},{37.4, 85},{37.6, 85.6},{37.8, 85.4},{41.4, 15.4},{41.6, 15.2},{46.8, 12},{46.8, 12.6},{46.8, 39.6},{47, 39.4},{47.4, 67.4},{47.4, 79.2},{47.4, 79.6},{47.6, 22},{47.6, 67.2},{47.6, 67.6},{47.6, 79},{47.6, 79.6},{47.8, 13.8},{50.8, 32.2},{51, 32.6},{51.6, 71.4},{57, 10.4},{57, 10.6},{62.4, 26.6},{62.6, 26},{62.6, 26.6},},
                [130] = {{38.8, 18.4},{38.8, 23.4},{44.6, 25.2},{44.6, 25.8},{45.4, 31.8},{45.6, 31.8},{49.8, 13.4},{50.2, 56.8},{50.2, 65.2},{55.6, 24.6},},
                [148] = {{37.6, 63.8},{43.2, 27},{46.2, 46.8},{47.4, 28.8},{49.8, 36.8},{56.4, 24.8},{59.8, 21.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222232] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Air",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 47,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{51, 46.4},{51.2, 47},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222233] = {
            [npcKeys.name] = "Ohk'zi",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{75, 25},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222243] = {
            [npcKeys.name] = "Zopilote",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{38.4, 31.8},{41.2, 32.4},{41.2, 33},{41.2, 33.6},{41.2, 34.6},{42, 33.4},{42, 34.4},{42.2, 31.6},{42.4, 35.2},{42.6, 33.8},{42.8, 32.2},{43, 31},{43, 32.6},{43, 35.2},{43.8, 32},{43.8, 33.6},{44.2, 35.6},{44.2, 36.8},{44.8, 30.4},{44.8, 31.8},{45.4, 30.6},{45.6, 30},{46, 36},{46.6, 35.2},{46.8, 30.4},{47, 33.2},{47.2, 30.8},{47.4, 31.6},{47.6, 35.4},{47.8, 32.2},{48, 31.4},{48.8, 33},{49.6, 32.2},{49.6, 32.6},{49.8, 33.8},{49.8, 36},{50.8, 28.6},{51, 35.4},{51.2, 35.8},{51.4, 37.2},{52, 36.4},{52.2, 37.2},{52.6, 37},{52.8, 36.4},{53.2, 38},{54, 37.6},{54.4, 38.8},{55, 39.8},{55.4, 38.6},{55.8, 40},{55.8, 40.6},{57, 33},{58.2, 36.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222244] = {
            [npcKeys.name] = "[DNT] Spinning Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222249] = {
            [npcKeys.name] = "[DNT] Bell Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222250] = {
            [npcKeys.name] = "[DNT] Dripping Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222251] = {
            [npcKeys.name] = "[DNT] Drooping Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222252] = {
            [npcKeys.name] = "[DNT] Orange Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222253] = {
            [npcKeys.name] = "[DNT] Purple Flower",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222254] = {
            [npcKeys.name] = "[DNT] Bell Flower 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222256] = {
            [npcKeys.name] = "[DNT] Bell Flower 3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222257] = {
            [npcKeys.name] = "[DNT] Purple Flower 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222261] = {
            [npcKeys.name] = "Maximillian \"The Greaser\"",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{79.8, 77.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {81987,82001,82002,82003},
            [npcKeys.questEnds] = {81987,82001,82002,82011,82013},
        },
        [222269] = {
            [npcKeys.name] = "[DNT] Drooping Flower 2",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222286] = {
            [npcKeys.name] = "Namida Grimtotem",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{66.4, 38.4},{66.4, 38.8},{66.6, 38.2},{66.8, 38.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222288] = {
            [npcKeys.name] = "Fel Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222289] = {
            [npcKeys.name] = "Moderate Manifestation of Air",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 47,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{51, 46.4},{51, 46.8},},
                [357] = {{35.8, 32.4},{35.8, 32.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {81968},
            [npcKeys.questEnds] = {81960,81968},
        },
        [222290] = {
            [npcKeys.name] = "Unfortunate Adventurer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222293] = {
            [npcKeys.name] = "Dream Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222316] = {
            [npcKeys.name] = "Fizzbizz Coppercoil",
            [npcKeys.minLevel] = 36,
            [npcKeys.maxLevel] = 36,
            [npcKeys.zoneID] = 400,
            [npcKeys.spawns] = {
                [400] = {{77, 77.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82004,82008,82009,82011},
            [npcKeys.questEnds] = {82003,82004,82008,82009,82010},
        },
        [222367] = {
            [npcKeys.name] = "Groddoc Infant",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{52.6, 60.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222376] = {
            [npcKeys.name] = "Groddoc Infant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{59, 58.4},{59, 58.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222402] = {
            [npcKeys.name] = "ST Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222403] = {
            [npcKeys.name] = "ST Professions",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222404] = {
            [npcKeys.name] = "PvP items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222405] = {
            [npcKeys.name] = "Leyline Conflux",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{18.2, 79.4},{18.2, 79.6},},
                [47] = {{47.8, 59},},
                [51] = {{54.8, 65.4},{54.8, 66.2},{55, 66.6},},
                [357] = {{57.2, 61.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222406] = {
            [npcKeys.name] = "Groddoc Matriarch",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{59, 58.6},{59.2, 58.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222407] = {
            [npcKeys.name] = "Enraged Leywalker",
            [npcKeys.minLevel] = 47,
            [npcKeys.maxLevel] = 47,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{18.2, 79.4},{18.2, 79.6},},
                [47] = {{47.4, 59.2},{47.8, 59},},
                [51] = {{54.4, 66.2},{54.4, 66.6},{54.8, 66},{54.8, 66.8},},
                [357] = {{57.2, 61.4},{57.2, 61.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222408] = {
            [npcKeys.name] = "Shadowtooth Emissary",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 361,
            [npcKeys.spawns] = {
                [361] = {{51.4, 82},{51.6, 82},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82043},
            [npcKeys.questEnds] = {82044},
        },
        [222409] = {
            [npcKeys.name] = "Boss \"Gobb\" Goldnick",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 41,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{88.4, 55.4},{89, 57.8},{89.8, 58},{90.8, 57.2},{90.8, 58.8},{91, 58},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222410] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222411] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222412] = {
            [npcKeys.name] = "Random Worm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222413] = {
            [npcKeys.name] = "Zalgo the Explorer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{15.2, 15.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82016,82093,82094},
            [npcKeys.questEnds] = {82016,82093,82094},
        },
        [222415] = {
            [npcKeys.name] = "Dire Troll Roulette",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222416] = {
            [npcKeys.name] = "Skeletal Wind Serpent",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222418] = {
            [npcKeys.name] = "Riding Bat",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222444] = {
            [npcKeys.name] = "Injured Gnome",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{26.8, 77.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82023},
            [npcKeys.questEnds] = nil,
        },
        [222451] = {
            [npcKeys.name] = "Itty Bitty Murloc",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{40.8, 85.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {82023},
        },
        [222478] = {
            [npcKeys.name] = "Sentinel Keldara Sunblade",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 44,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{20.4, 62},{20.6, 61.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222495] = {
            [npcKeys.name] = "Serpent's Ascension Visual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222513] = {
            [npcKeys.name] = "Wild Growth",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222514] = {
            [npcKeys.name] = "Nightmare Mushroom",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222516] = {
            [npcKeys.name] = "Dream Fog",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222519] = {
            [npcKeys.name] = "Unbalanced Druid",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222521] = {
            [npcKeys.name] = "Dreamstone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222522] = {
            [npcKeys.name] = "Spirit of Agamaggan",
            [npcKeys.minLevel] = 61,
            [npcKeys.maxLevel] = 61,
            [npcKeys.zoneID] = 722,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82044},
            [npcKeys.questEnds] = {82043},
        },
        [222523] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222525] = {
            [npcKeys.name] = "Anvilrage Patrol",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222530] = {
            [npcKeys.name] = "Rugged Traveler",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = {82062},
        },
        [222531] = {
            [npcKeys.name] = "Ragged Traveler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222542] = {
            [npcKeys.name] = "Atal'ai Drum",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222543] = {
            [npcKeys.name] = "Atal'ai Slab",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222544] = {
            [npcKeys.name] = "Atal'ai Mask",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222545] = {
            [npcKeys.name] = "Atal'ai Candle",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222546] = {
            [npcKeys.name] = "Iodax the Obliterator",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{65.4, 45.4},{65.4, 45.6},{65.8, 44.4},{65.8, 45.4},{65.8, 45.8},{66.6, 43.8},{66.6, 45},{66.8, 46.2},{66.8, 46.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222551] = {
            [npcKeys.name] = "Grendag Brightbeard",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{68.2, 23},},
                [1537] = {{44, 10},{44.2, 10.6},{45, 10.2},{45, 10.6},},
                [1637] = {{49, 57.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222553] = {
            [npcKeys.name] = "Atal'ai Mummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222566] = {
            [npcKeys.name] = "Animated Flame",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222573] = {
            [npcKeys.name] = "Delirious Ancient",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1176,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222580] = {
            [npcKeys.name] = "Child of Apa'ro",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{42.4, 33.6},{42.4, 34.6},{42.8, 33.4},{42.8, 34.2},{42.8, 34.6},{43, 32.4},{43.2, 30.6},{43.4, 28.4},{43.4, 29},{43.4, 29.6},{43.6, 28.8},{43.8, 30},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222617] = {
            [npcKeys.name] = "Moderate Manifestation of Fire",
            [npcKeys.minLevel] = 47,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{23.8, 73},},
                [357] = {{35.6, 32.4},{35.6, 32.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {82074},
            [npcKeys.questEnds] = {82071,82074},
        },
        [222620] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Fire",
            [npcKeys.minLevel] = 47,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{23.2, 73.6},{23.4, 72.8},{23.6, 72.6},{24, 72.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222623] = {
            [npcKeys.name] = "Moderate Manifestation of Earth",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{36, 32.4},{36, 32.6},},
                [440] = {{62, 62.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = {82075},
            [npcKeys.questEnds] = {82072,82075},
        },
        [222625] = {
            [npcKeys.name] = "Corrupt Moderate Manifestation of Earth",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{62, 62.4},{62, 62.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222636] = {
            [npcKeys.name] = "Ancient Shrine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222647] = {
            [npcKeys.name] = "Ancient Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222648] = {
            [npcKeys.name] = "Wild Shrine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222649] = {
            [npcKeys.name] = "Wild Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222650] = {
            [npcKeys.name] = "Windswept Shrine",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222651] = {
            [npcKeys.name] = "Windswept Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222656] = {
            [npcKeys.name] = "Defias Night Blade",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{47, 74.4},{47.2, 76.6},{47.6, 70.4},{47.6, 73.6},{48.4, 73.2},{48.4, 75.2},{48.6, 74.4},{48.6, 75.6},{48.8, 74.8},{49.2, 73.4},{49.6, 72.6},{49.8, 74.6},{50, 74.4},{50, 76},{50.8, 71.6},{50.8, 75.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222684] = {
            [npcKeys.name] = "Quartermaster Falinar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{45.6, 51.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222685] = {
            [npcKeys.name] = "Quartermaster Kyleen",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{89.4, 40.6},{89.6, 40.4},{89.6, 40.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222686] = {
            [npcKeys.name] = "Quartermaster Alandra",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{61.4, 34.4},{61.4, 34.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222687] = {
            [npcKeys.name] = "Quartermaster Valdane",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{48.6, 12.4},{48.6, 12.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222689] = {
            [npcKeys.name] = "Blood-crazed Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222694] = {
            [npcKeys.name] = "Furniture",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222695] = {
            [npcKeys.name] = "Vilebranch Mask",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{72.4, 52.8},{72.6, 52.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222696] = {
            [npcKeys.name] = "Fel Crack",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{42.8, 82},{43.2, 80.2},{43.8, 83.8},{46.2, 85.6},{47.8, 83.6},{48.4, 81.2},{48.6, 83},},
                [44] = {{29.8, 30.4},{71.4, 83.6},{79, 33.4},{79, 73},{81.8, 60.8},{83.2, 44.4},{83.2, 45.2},{86.2, 52.6},{86.4, 52.4},},
                [331] = {{24.4, 63.4},{27.6, 62.6},{30.2, 30.2},{33.4, 28.4},{33.6, 28.4},{44.4, 64.2},{44.6, 64.2},{51.2, 47},{52.4, 62.8},{52.6, 62.8},{55.4, 40.4},{55.6, 40.2},{67, 46},{67.2, 51},{77.4, 73.2},{80.4, 70.6},{80.6, 70.8},{84.8, 70.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222697] = {
            [npcKeys.name] = "Fel Tear",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{10.4, 59.4},{10.4, 60.2},{10.6, 60.2},{10.6, 60.6},{12.4, 29.8},{12.6, 29.4},{12.6, 29.6},{16.4, 63},{16.6, 63.6},{16.8, 62.6},{22.8, 64},{22.8, 64.6},{27, 48.8},{27, 49.8},{34, 28.6},{34.4, 28.2},{34.6, 28},{36.2, 50.6},{36.4, 50},{36.6, 50},{49, 38.8},{49.2, 38.2},{49.8, 38.6},{56.4, 65},{56.6, 65},{56.8, 65.6},{60.2, 27.6},{60.6, 28},{60.8, 27.4},{60.8, 44},{61, 43.4},{69.2, 78},{69.6, 78.8},{69.8, 78},{72.2, 10},{72.2, 10.6},{72.8, 10.4},{77, 89.2},{77.4, 89.6},{77.6, 89.2},{77.6, 90},{81.2, 34},{81.4, 34.6},{83.2, 66.6},{83.8, 66.4},{87.2, 26.2},{87.4, 26.8},{87.6, 26},{90.8, 65.2},{91, 65.6},{91.4, 56},{91.4, 57},{91.6, 56.4},},
                [405] = {{47.4, 22.2},{48.8, 82.2},{49.4, 74.4},{49.4, 75},{49.6, 74.4},{49.6, 74.8},{52, 72.6},{52, 85.4},{52, 85.6},{52.2, 72.4},{52.8, 81},{54.4, 19.2},{56, 74.4},{56, 74.8},{71.4, 18.4},{71.4, 18.8},{71.6, 18.4},{71.6, 18.8},{72.4, 22},{72.6, 22},{73.4, 24.4},{73.4, 24.6},{73.6, 24.8},{74.4, 10.2},{74.4, 10.6},{74.6, 10.4},{76.4, 19.2},{76.6, 19.2},{80.4, 17},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222698] = {
            [npcKeys.name] = "Fel Scar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{35, 54.8},{41.2, 33.4},{41.4, 33.6},{43.4, 25},{43.6, 25.6},{43.8, 25},{46.4, 39},{46.8, 39.2},{48.4, 48},{48.8, 48.6},{49, 48.2},{56.2, 36.6},{60.2, 46},{60.2, 46.8},{62, 39.2},},
                [16] = {{16.4, 51},{16.6, 51},{17.4, 59},{17.6, 58.4},{17.6, 58.8},{21.2, 54},{24.8, 47.8},{25, 81.4},{25.2, 81.6},{30.2, 79.8},{33, 81.4},{33, 81.6},},
                [357] = {{68.2, 58.8},{70.6, 62.4},{70.6, 62.6},{72.4, 63.8},{72.6, 63.8},{73.2, 54.4},{74.2, 50.4},{74.2, 50.8},{74.2, 56.8},{74.2, 60},{76.2, 56.4},{76.2, 56.6},{76.6, 63.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222699] = {
            [npcKeys.name] = "Enraged Stormcrow",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 51,
            [npcKeys.spawns] = {
                [51] = {{35.4, 22.8},{52, 57},{52.8, 56.2},{53.2, 58.6},{53.4, 57.4},{53.4, 57.6},{53.8, 57.4},{53.8, 57.6},{54.2, 50.8},{54.6, 56},{54.6, 56.8},{55.2, 51.4},{55.2, 57.6},{55.4, 54.8},{55.6, 57.2},{56, 50.8},{56, 58.4},{56.2, 59.8},{57.2, 60},{57.4, 59.2},{58.2, 57.8},{59.6, 56},{65.4, 54.4},{70.8, 55},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222701] = {
            [npcKeys.name] = "Pile of Bones",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222702] = {
            [npcKeys.name] = "Murderous Lost One",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 4,
            [npcKeys.spawns] = {
                [4] = {{45.2, 16.4},{45.2, 16.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222703] = {
            [npcKeys.name] = "Whisperwing",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{34, 48.2},{34.4, 48.8},{34.6, 48.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222704] = {
            [npcKeys.name] = "Sagefeather",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{66, 53},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222705] = {
            [npcKeys.name] = "Blightbark",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{58.2, 53},{58.4, 52},{58.6, 52},{58.8, 51},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222706] = {
            [npcKeys.name] = "STV PvP P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222707] = {
            [npcKeys.name] = "Nightmare Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222708] = {
            [npcKeys.name] = "Darkmoon Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222709] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222710] = {
            [npcKeys.name] = "Door",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222726] = {
            [npcKeys.name] = "Tyrant of the Hive",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{76.4, 61.2},{77, 61.6},{77.8, 62.2},{78, 62.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222734] = {
            [npcKeys.name] = "[DNT] Dream Fog Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222763] = {
            [npcKeys.name] = "Mixmaster Blix",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{67, 22.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82090},
            [npcKeys.questEnds] = nil,
        },
        [222765] = {
            [npcKeys.name] = "Desirous",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222768] = {
            [npcKeys.name] = "Lisabeth La'monalissier",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222772] = {
            [npcKeys.name] = "Crimeon Lablade",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{67, 22.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82089},
            [npcKeys.questEnds] = {82089},
        },
        [222789] = {
            [npcKeys.name] = "The Giant",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{46.4, 18.2},{46.4, 18.8},{46.4, 19.6},{46.4, 20.6},{46.6, 19.2},{46.6, 21.4},{47, 21.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222799] = {
            [npcKeys.name] = "Simmering Elemental",
            [npcKeys.minLevel] = 41,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{78.4, 48.4},{79, 49.6},{79.2, 49.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222856] = {
            [npcKeys.name] = "Odd Totem",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{43, 41.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222857] = {
            [npcKeys.name] = "Odd Totem",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{45.6, 37.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222897] = {
            [npcKeys.name] = "Enraged Voidwalker",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{58.4, 36.4},{58.4, 36.6},{58.6, 36.4},{58.6, 36.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222919] = {
            [npcKeys.name] = "Whirling Tempest",
            [npcKeys.minLevel] = 44,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{60, 67},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222968] = {
            [npcKeys.name] = "Lethlas",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{51.2, 16},{52.4, 15.8},{53, 16.4},{53.2, 16.6},{53.8, 17},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222970] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222971] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222972] = {
            [npcKeys.name] = "Rift",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222977] = {
            [npcKeys.name] = "Phantim",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 42,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{80.8, 49.6},{81.4, 48.4},{81.4, 48.6},{81.4, 51.2},{81.6, 48.4},{81.6, 48.6},{81.6, 49.8},{82.4, 46.6},{82.6, 48.6},{82.8, 49.6},{83.4, 47.2},{83.4, 48.2},{83.6, 47.6},{83.6, 48.6},{83.8, 45.2},{83.8, 47},{84.2, 46},{84.4, 44.4},{84.6, 46.6},{84.8, 46},{85.4, 43.6},{85.4, 45.2},{85.6, 44.4},{85.8, 44.6},{85.8, 46.6},{86, 46},{86.4, 42.4},{86.4, 43.2},{86.4, 50},{86.6, 42},{86.6, 43.2},{86.6, 44.2},{86.6, 44.6},{86.6, 45.8},{86.8, 46.6},{86.8, 48.4},{86.8, 49.2},{86.8, 50},{86.8, 51.2},{87.2, 40.6},{87.6, 41.4},{87.6, 43.6},{87.8, 43.2},{87.8, 46.8},{88, 40.4},{88.2, 41.8},{88.6, 43.6},{88.8, 40.6},{88.8, 42.8},{89, 41.8},{89.4, 40.4},{89.8, 40},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [222978] = {
            [npcKeys.name] = "Green Sludge",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 47,
            [npcKeys.spawns] = {
                [47] = {{45, 41},{45.4, 37.2},{46, 36.6},{46, 39.4},{46, 39.6},{46.4, 40.8},{46.6, 38.2},{46.6, 39.8},{46.8, 40.8},{47.8, 40.4},{47.8, 40.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223061] = {
            [npcKeys.name] = "Charged Totem",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{60, 66.8},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223068] = {
            [npcKeys.name] = "Thunderhead Hippogryph",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{15.2, 54.8},{15.8, 53.2},{16, 54.4},{16.2, 51.2},{16.2, 51.8},{16.6, 51},{16.6, 51.8},{16.6, 65.8},{16.8, 53},{17.2, 54.4},{17.4, 57.8},{17.4, 59.4},{17.4, 59.6},{17.4, 62.4},{17.4, 62.6},{17.4, 63.6},{17.6, 52.6},{17.6, 55.4},{17.6, 59.4},{17.6, 59.6},{17.8, 53.6},{17.8, 56.4},{17.8, 60.8},{18, 52.4},{18, 57},{18, 62},{18, 62.8},{18.2, 51.2},{18.2, 57.6},{18.2, 65.2},{18.4, 64.4},{18.6, 57},{18.6, 57.8},{18.6, 64},{18.8, 60.4},{18.8, 63},{18.8, 65.2},{18.8, 65.6},{19, 52.6},{19.4, 52},{19.4, 68.2},{19.6, 52.2},{19.8, 51.4},{20, 65.6},{20.2, 54.6},{20.2, 56.6},{20.2, 57.6},{20.2, 64},{20.2, 65.4},{20.4, 56.4},{20.4, 67.6},{20.6, 56.8},{20.6, 57.6},{20.6, 65},{21, 56.2},{21.6, 51},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223123] = {
            [npcKeys.name] = "Diseased Forest Walker",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 44,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{72.4, 50.4},{72.4, 50.8},{72.6, 50.4},{72.6, 50.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223127] = {
            [npcKeys.name] = "Dead Diseased Grimtotem Shaman",
            [npcKeys.minLevel] = 43,
            [npcKeys.maxLevel] = 44,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{69.4, 43.2},{69.6, 43.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223128] = {
            [npcKeys.name] = "Dead Diseased Woodpaw Mystic",
            [npcKeys.minLevel] = 42,
            [npcKeys.maxLevel] = 43,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{66.4, 50.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223130] = {
            [npcKeys.name] = "Uprooted Gloomwood",
            [npcKeys.minLevel] = 46,
            [npcKeys.maxLevel] = 46,
            [npcKeys.zoneID] = 357,
            [npcKeys.spawns] = {
                [357] = {{41, 9.4},{45.8, 21.8},{46, 11.4},{46, 13.2},{46, 16.6},{46.2, 15.4},{46.2, 17.6},{46.4, 14},{46.4, 16.4},{46.4, 19.4},{46.4, 19.8},{46.4, 20.6},{46.6, 14},{46.6, 14.8},{46.6, 15.8},{46.6, 19.4},{46.6, 21.4},{46.8, 21.6},{47, 9.4},{47.4, 22.6},{47.8, 14},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223212] = {
            [npcKeys.name] = "[DNT] Tanaris - Arena Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223264] = {
            [npcKeys.name] = "Delirious Ancient",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 2100,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223265] = {
            [npcKeys.name] = "Delirious Ancient",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223287] = {
            [npcKeys.name] = "Fire Elemental",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{37, 82.2},{37, 83},{37.4, 84.2},{37.6, 84.4},{37.6, 84.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223340] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{40.2, 18.4},{40.8, 14.4},{46.4, 52.6},{47.6, 49.4},{51.6, 53.4},{54.4, 48.6},{55.6, 25.4},{55.6, 25.6},{57.6, 23.4},{58.8, 25.8},{59, 29},{59.2, 36.6},{59.8, 27.4},{59.8, 27.6},{61.8, 32},},
                [40] = {{28.6, 44},{28.8, 58.6},{29, 43.2},{29, 58.2},{29.6, 34},{29.6, 69.4},{30, 69.6},{31.4, 39.2},{31.4, 65},{31.4, 66},{31.6, 39.2},{32.2, 29},{32.2, 76.2},{32.2, 80.2},{34, 82.4},{37.6, 85.4},{41.2, 15.6},{41.4, 15.4},{46.6, 12.4},{47, 39.2},{47.4, 21.8},{47.6, 21.8},{47.6, 67.6},{47.6, 79.4},{51, 32.4},{51.6, 71.4},{62.6, 26.4},{62.6, 26.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223345] = {
            [npcKeys.name] = "Lledra's Vehicle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223359] = {
            [npcKeys.name] = "Lledra's Vehicle Visual",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223413] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223482] = {
            [npcKeys.name] = "Wild Gods Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223483] = {
            [npcKeys.name] = "Merchant Faction Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223485] = {
            [npcKeys.name] = "Fel Portal Items",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223496] = {
            [npcKeys.name] = "Void Zone",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223542] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{81.8, 60.8},{86.4, 52.4},},
                [331] = {{44.6, 64.2},{50.8, 47},{55.6, 40.4},{67, 46},{77.2, 73.2},{84.8, 70.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223543] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 38,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{10.4, 60.2},{12.4, 29.8},{12.6, 29.8},{17, 63},{22.6, 64.6},{23, 64.2},{34.2, 28.4},{36, 50.2},{49.2, 38.8},{49.8, 38.6},{56.6, 65},{57, 65.8},{60.6, 28},{60.8, 43.2},{61.2, 43.6},{69.4, 78.4},{69.6, 78.4},{69.6, 78.8},{72.2, 10.4},{72.2, 10.8},{72.6, 10.4},{72.8, 10.8},{77.2, 89.6},{77.4, 89.4},{77.6, 90},{87.2, 26.4},{90.6, 65.8},{91, 65.4},{91.2, 56.6},{91.4, 56},},
                [405] = {{48.8, 81.4},{48.8, 82},{49.4, 74.8},{49.6, 75},{52, 85.4},{52.2, 72.2},{52.2, 72.6},{52.2, 85.6},{52.8, 81},{54.2, 19.2},{56, 74.8},{71.4, 18.8},{72.2, 22.2},{72.6, 21.8},{74.6, 10.4},{76.2, 19.2},{80.4, 17.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223544] = {
            [npcKeys.name] = "Fel Interloper",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 48,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{16.4, 50.8},{17.6, 58.6},{21.2, 53.8},{24.8, 47.6},{25, 81.4},{25, 81.6},{30.2, 79.8},{33, 81.4},},
                [357] = {{68.2, 58.8},{70.6, 62.4},{70.6, 62.6},{72.4, 63.6},{72.6, 63.8},{73.2, 54.2},{74.2, 50.6},{74.2, 56.8},{74.2, 60},{76.2, 56.4},{76.2, 56.6},{76.6, 63.8},{76.8, 63.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223568] = {
            [npcKeys.name] = "Josh's Kill Credit Creature P3",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223581] = {
            [npcKeys.name] = "Rune Scrying Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223586] = {
            [npcKeys.name] = "Hukku",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223587] = {
            [npcKeys.name] = "Mijan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223588] = {
            [npcKeys.name] = "Gasher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223590] = {
            [npcKeys.name] = "Shrine of the Watcher",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 16,
            [npcKeys.spawns] = {
                [16] = {{89.8, 33.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = {82316},
            [npcKeys.questEnds] = {82316},
        },
        [223591] = {
            [npcKeys.name] = "Echo of a Lost Soul",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 8,
            [npcKeys.spawns] = {
                [8] = {{50, 61.4},{50, 62.6},{50.2, 62},},
                [47] = {{72.4, 68.8},{72.6, 68.4},{72.6, 68.6},},
                [440] = {{53.8, 28.4},{53.8, 29},},
            },
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223720] = {
            [npcKeys.name] = "[DNT] Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [223737] = {
            [npcKeys.name] = "[DNT] Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224242] = {
            [npcKeys.name] = "Saturated Ooze",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224243] = {
            [npcKeys.name] = "Deep Lurker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224244] = {
            [npcKeys.name] = "Slime Maggot",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224245] = {
            [npcKeys.name] = "Oozeling",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224250] = {
            [npcKeys.name] = "Atal'ai Warrior",
            [npcKeys.minLevel] = 52,
            [npcKeys.maxLevel] = 52,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224253] = {
            [npcKeys.name] = "Nightmare Wanderer",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224254] = {
            [npcKeys.name] = "Nightmare Wyrmkin",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224255] = {
            [npcKeys.name] = "Nightmare Scalebane",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224256] = {
            [npcKeys.name] = "Nightmare Whelp",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224257] = {
            [npcKeys.name] = "Atal'ai Slave",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224258] = {
            [npcKeys.name] = "Atal'ai High Priest",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224259] = {
            [npcKeys.name] = "Atal'ai Deathwalker",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224260] = {
            [npcKeys.name] = "Atal'ai Corpse Eater",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224262] = {
            [npcKeys.name] = "Unliving Atal'ai",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224263] = {
            [npcKeys.name] = "Atal'ai Witch Doctor",
            [npcKeys.minLevel] = 51,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224328] = {
            [npcKeys.name] = "Zalgo the Explorer",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1477,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = "AH",
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
        [224386] = {
            [npcKeys.name] = "Fireguard Destroyer",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 51,
            [npcKeys.zoneID] = 1584,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
            [npcKeys.questStarts] = nil,
            [npcKeys.questEnds] = nil,
        },
    }
end
