---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")
---@type QuestieProfessions
local QuestieProfessions = QuestieLoader:ImportModule("QuestieProfessions")

function SeasonOfDiscovery:LoadQuests()
    local questKeys = QuestieDB.questKeys
    local zoneIDs = ZoneDB.zoneIDs
    local raceIDs = QuestieDB.raceKeys
    local classIDs = QuestieDB.classKeys
    local sortKeys = QuestieDB.sortKeys
    local questFlags = QuestieDB.questFlags
    local specialFlags = QuestieDB.specialFlags
    local factionIDs = QuestieDB.factionIDs
    local profKeys = QuestieProfessions.professionKeys
    local specKeys = QuestieProfessions.specializationKeys

    -- TODO: reputation once data is more reliably confirmed
    -- TODO: ZoneIDs, sort keys

    return {
        [76156] = { -- Stalk With The Earthmother
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [76160] = { -- Stalk With The Earthmother
            [questKeys.objectives] = {nil,nil,{{206175}}},
            [questKeys.preQuestSingle] = {76156},
            [questKeys.requiredSourceItems] = {206170},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [76240] = { -- Stalk With The Earthmother
            [questKeys.objectives] = {nil,nil,{{206345}}},
            [questKeys.preQuestSingle] = {76160},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77568] = { -- A Hunter's Strength
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77571] = { -- Relics of the Kaldorei
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410061, nil, 208414}}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [77573] = { -- Second-Story Work
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77574] = { -- Meditation on Elune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [77575] = { -- Amidst the Shadowed Webs
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77582] = { -- A Trial of Fitness
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77583] = { -- Atop the Cliffs
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77584] = { -- Hunt for the Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77585] = { -- Icons of Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77586] = { -- Stolen Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [77587] = { -- Icons of Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77588] = { -- A Trial of Fitness
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77590] = { -- Rugged Terrain
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77592] = { -- Atop the Cliffs
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77616] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.HUMAN,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77617] = { -- Relics of the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410002, nil, 205420}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [77618] = { -- Thrice Stolen
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.HUMAN,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77619] = { -- Meditation on the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [77620] = { -- Spell Research
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [77621] = { -- Stolen Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [77642] = { -- Wisdom of the Loa
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [77643] = { -- Spell Research
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [77648] = { -- Relics of the Tauren
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410061, nil, 208414}}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [77649] = { -- A Hunter's Strength
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77651] = { -- Into the Brambles
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77652] = { -- Icons of Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77655] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.DWARF,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77656] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.GNOME,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77657] = { -- Relics of the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410002, nil, 205420}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [77658] = { -- Thrice Stolen
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.DWARF,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77659] = { -- Thrice Stolen
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.GNOME,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77660] = { -- Trek Through the Caves
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.requiredRaces] = raceIDs.DWARF,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77661] = { -- Meditation on the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [77666] = { -- Stolen Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [77667] = { -- Spell Research
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [77668] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77669] = { -- The Scarlet Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77670] = { -- Meditation on Undeath
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [77671] = { -- Spell Research
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [77672] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [78088] = { -- A Strange Artifact
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78089] = { -- Advice From Stormwind
            [questKeys.preQuestSingle] = {78088},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78090] = { -- A Second Opinion
            [questKeys.preQuestSingle] = {78089},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78091] = { -- Earning Your Salt
            [questKeys.preQuestSingle] = {78090},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78092] = { -- It Must Be Destroyed
            [questKeys.finishedBy] = {nil,{409311}},
            [questKeys.preQuestSingle] = {78091},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78093] = { -- Return to Delgren
            [questKeys.preQuestSingle] = {78092},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78114] = { -- Wild Wyvern Wrangling
            [questKeys.questLevel] = 22,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78121] = { -- Wrangling a Wild Wyvern
            [questKeys.questLevel] = 22,
            [questKeys.preQuestSingle] = {78114},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78124] = { -- Nar'thalas Almanac
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78127] = { -- The Dalaran Digest
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78132] = { -- Dragonslayer's Helm
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [78133] = { -- Dragonslayer's Shield
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [78134] = { -- Dragonslayer's Lance
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [78142] = { -- Bewitchments and Glamours
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78143] = { -- Secrets of the Dreamers
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78144] = { -- Alonso the Dragonslayer
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425444,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.preQuestGroup] = {78132,78133,78134},
        },
        [78145] = { -- Arcanic Systems Manual
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78146] = { -- Goaz Scrolls
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78147] = { -- Crimes Against Anatomy
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78148] = { -- Runes of the Sorceror-Kings
            [questKeys.name] = "Runes of the Sorcerer-Kings",
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78149] = { -- Fury of the Land
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78150] = { -- Friend of the Library
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78192] = { -- Secrets of the Light
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.objectives] = {{{3733},{3732}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
        },
        [78193] = { -- Secrets of the Light
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78192},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
        },
        [78194] = { -- Secrets of Elune
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.DWARF + raceIDs.HUMAN,
        },
        [78195] = { -- Secrets of Elune
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78194},
            [questKeys.requiredRaces] = raceIDs.DWARF + raceIDs.HUMAN,
        },
        [78196] = { -- Secrets of Undeath
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.TROLL,
        },
        [78197] = { -- Secrets of Undeath
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78196},
            [questKeys.requiredRaces] = raceIDs.TROLL,
        },
        [78198] = { -- Secrets of the Loa
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
        },
        [78199] = { -- Secrets of the Loa
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78198},
            [questKeys.finishedBy] = {nil,{410168}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
        },
        [78229] = { -- Trial of The Owls
            [questKeys.preQuestGroup] = {90088,90089,90090},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.objectivesText] = {"Bring symbols of the three owls to Loganaar in Moonglade. NOTE: To accept this quest, you need to bring at least one symbol, but you can also bring all three at once."},
        },
        [78261] = { -- The Horn of Xelthos
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.requiredLevel] = 20,
            [questKeys.childQuests] = {78270},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [78265] = { -- Fish Oil
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78266] = { -- Dark Iron Ordinance
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78267] = { -- Shredder Turbochargers
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78270] = { -- Goblin Lockpicks
            [questKeys.objectivesText] = {"Pickpocket the work order from Venture Co. Operators in Windshear Crag"},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.parentQuest] = 78261,
        },
        [78277] = { -- A Token of Gratitude
            [questKeys.objectivesText] = {"Complete the quest chain starting with Resting in Pieces to receive the Living Bomb rune."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78287] = { -- Let Me Make You An Offer
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78288] = { -- Let Me Make You An Offer
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78297] = { -- You've Got Yourself A Deal
            [questKeys.preQuestSingle] = {78287},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78304] = { -- You've Got Yourself A Deal
            [questKeys.preQuestSingle] = {78288},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78307] = { -- The Horn of Xelthos
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.preQuestSingle] = {78261},
            [questKeys.objectivesText] = {"Head to a major city to receive another letter. Then head back to the Dead Drop to receive the rune."},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [78506] = { -- Elemental Distress
            [questKeys.preQuestSingle] = {78920},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78537] = { -- Elixir of Insight
            [questKeys.preQuestSingle] = {78506},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78561] = { -- Elixir of Insight
            [questKeys.objectives] = {},
            [questKeys.preQuestSingle] = {78537},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78575] = { -- Hirzek
            [questKeys.objectives] = {{{212694}}},
            [questKeys.preQuestSingle] = {78561},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78611] = { -- A Waylaid Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78612] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78676] = { -- The Eye of Bhossca
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.preQuestSingle] = {78261},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 1: Loot the Scarlet Initiate's Uniform from the chest in the stables, outside of Scarlet Monastery. You need Lockpicking 100 to open the chest."), 0, {{"object", 412147}}},
                {{[zoneIDs.SCARLET_MONASTERY]={{-1,-1}}}, Questie.ICON_TYPE_EVENT, l10n("Step 2: put on the Scarlet Initiate's Uniform while inside the Graveyard wing of Scarlet Monastery and not in a group.")},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 3: pick pocket Scarlet Scryer to loot Scryer's Key."), 0, {{"monster", 4293}}},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 4: head to the Library wing and loot the Confidential Message from the Personal Letterbox."), 0, {{"object", 412759}}},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 5: go back to the Graveyard and /sit on the two benches between the pair of statues on either side of the graveyard. Then loot the Reliquary Key from the Stone Coffer in the northern mausoleum."), 0, {{"object", 412198}}},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 6: go back to the Library and loot the Eye of Bhossca from the Padlocked Reliquary."), 0, {{"object", 412261}}},
            },
        },
        [78680] = { -- Rumors Abound
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {1740},
        },
        [78681] = { -- The Conjuring
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78680},
        },
        [78684] = { -- Mysterious Traveler
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78681},
        },
        [78699] = { -- The Eye of Bhossca
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.preQuestSingle] = {78676},
            [questKeys.objectivesText] = {"Head to a major city to receive another letter. Then head back to the Dead Drop to receive the rune."},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [78702] = { -- Raszel Ander
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78684},
        },
        [78823] = { -- Terror of the Desert Skies
            [questKeys.startedBy] = {{2701,2715,2716,2717,2718,2893,2894,2906,2907}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78830] = { -- Terror of the Desert Skies
            [questKeys.preQuestSingle] = {78823},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78872] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78909] = { -- Shifting Scale Talisman
            [questKeys.objectivesText] = {"Tip: You need to loot Handful of Shifting Scales from Old Serra'kis in Blackfathom Deeps before you can start this quest.","","Bring N'ora Anyheart the following materials alongside the Handful of Shifting Scales to complete the talisman: A satchel of Strange Dust, five Greater Magic Essence, 2 Small Glimmering Shards and five gold pieces."},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78914] = { -- Soul Vessel
            [questKeys.preQuestSingle] = {78994},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [78916] = { -- The Heart of the Void (Alliance)
            [questKeys.startedBy] = {nil, nil, {209693}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.sourceItemId] = 209693,
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
        },
        [78917] = { -- The Heart of the Void (Horde)
            [questKeys.startedBy] = {nil, nil, {211452}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.sourceItemId] = 211452,
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
        },
        [78920] = { -- Baron Aquanis (Horde)
            [questKeys.startedBy] = {nil, nil, {211454}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78921] = { -- Blackfathom Villainy (Alliance)
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5881}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78922] = { -- Blackfathom Villainy (Horde)
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {nil,nil,{{5881}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78923] = { -- Knowledge in the Deeps (Alliance)
            [questKeys.startedBy] = {{2786}},
            [questKeys.finishedBy] = {{2786}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5359}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78925] = { -- Twilight Falls (Alliance)
            [questKeys.startedBy] = {{4784}},
            [questKeys.finishedBy] = {{4784}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5879}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78926] = { -- Researching the Corruption (Alliance)
            [questKeys.startedBy] = {{8997}},
            [questKeys.finishedBy] = {{8997}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5952}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78927] = { -- Allegiance to the Old Gods (Horde)
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {{{207356}},nil,nil},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78994] = { -- A Solid Foundation
            [questKeys.preQuestSingle] = {78702},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [79007] = { -- ...and that note you found
            [questKeys.startedBy] = {nil,{415106}},
            [questKeys.finishedBy] = {nil,{415107}},
            [questKeys.zoneOrSort] = zoneIDs.THE_BARRENS,
        },
        [79008] = { -- ...and that note you found
            [questKeys.startedBy] = {nil,{415107}},
            [questKeys.finishedBy] = {nil,{415106}},
            [questKeys.zoneOrSort] = zoneIDs.WESTFALL,
        },
        [79077] = { -- Sharing the Faith (Stormwind)
            [questKeys.objectives] = {{{215062}}},
            [questKeys.requiredRaces] = raceIDs.DWARF + raceIDs.HUMAN,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79078] = { -- Sharing the Faith (Darnassus)
            [questKeys.objectives] = {{{215095}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79079] = { -- Sharing the Faith (Orgrimmar)
            [questKeys.objectives] = {{{215096}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79080] = { -- Sharing the Faith (Undercity)
            [questKeys.objectives] = {{{215098}}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79090] = { -- Repelling Invaders
            [questKeys.startedBy] = {{212727,212728,212729,212730,212801,212802}},
            [questKeys.finishedBy] = {{212970,217707}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [79091] = { -- Archmage Antonidas: The Unabridged Autobiography
            [questKeys.startedBy] = {nil,{386691}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Archmage Antonidas: The Unabridged Autobiography'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79092] = { -- Archmage Theocritus's Research Journal
            [questKeys.startedBy] = {nil,{386759}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Azora Apprentice Notes: Page 1'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79093] = { -- Rumi of Gnomeregan: The Collected Works
            [questKeys.startedBy] = {nil,{408014}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Rumi of Gnomeregan: The Collected Works'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79094] = { -- The Lessons of Ta'zo
            [questKeys.startedBy] = {nil,{450001}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Lessons of Ta'zo'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79095] = { -- The Apothecary's Metaphysical Primer
            [questKeys.startedBy] = {nil,{405879}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Apothecary's Metaphysical Primer'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79096] = { -- Ataeric: On Arcane Curiosities
            [questKeys.startedBy] = {nil,{410299}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Ataeric: On Arcane Curiosities'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79097] = { -- Baxtan: On Destructive Magics
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79098] = { -- Clear the Forest!
            [questKeys.startedBy] = {{212699,212703,212706,212707,212803,212804}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [79099] = { -- Baron Aquanis (Alliance)
            [questKeys.startedBy] = {{214876}},
            [questKeys.finishedBy] = {{214876}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{211818}}},
            [questKeys.zoneOrSort] = zoneIDs.AUBERDINE,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79100] = { -- A Waylaid Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79101] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79102] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79103] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79192] = { -- Stepping Stones
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.startedBy] = {nil,{415106,415107}},
            [questKeys.finishedBy] = {nil,{424005}},
            [questKeys.preQuestSingle] = {79007,79008},
            [questKeys.zoneOrSort] = zoneIDs.THE_BARRENS,
        },
        [79229] = { -- Highway Robbery
            [questKeys.startedBy] = {nil,{417353}},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79235] = { -- On the Lam
            [questKeys.preQuestSingle] = {79229},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79236] = { -- Cherry for Your Thoughts?
            [questKeys.preQuestSingle] = {79235},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79242] = { -- No Honor Among Thieves
            [questKeys.finishedBy] = {nil,{418855}},
            [questKeys.preQuestSingle] = {79236},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_OBJECT, l10n("Use the Rowboat to reach the eastern shore."), 0, {{"object", 420055}}}},
        },
        [79298] = {
            [questKeys.preQuestSingle] = {78914},
            [questKeys.objectives] = {{{215974}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [79348] = { -- The Lost Ancient
            [questKeys.startedBy] = {{216310},nil,{212693}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [79358] = { -- Tattered Note
            [questKeys.startedBy] = {{4421},nil,{212748}},
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [79360] = { -- Elemental Aid
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79358},
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [79361] = { -- Power of da Wind
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79360},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79362] = { -- Power of da Earth
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79360},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79363] = { -- Power of da Water
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79360},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79364] = { -- A Simple Container
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestGroup] = {79361,79362,79363},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79365] = { -- With Wind Beneath Your Wings
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79364},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79366] = { -- Calm Before the Storm
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79365},
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Drink the Squall-breakers Potion and talk to Nyse."), 0, {{"monster", 4317}}}},
        },
        [79377] = { -- The Lost Saplings
            [questKeys.preQuestSingle] = {79348},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.objectives] = {{{216437,216451,216448,216445}},nil,{{213036}}},
        },
        [79442] = { -- Catching Up
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79366},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79482] = { -- Stolen Winter Veil Treats (Alliance)
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216915}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79483] = { -- Stolen Winter Veil Treats (Horde)
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79484] = { -- You're a Mean One... (Alliance)
            [questKeys.preQuestSingle] = {79482},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79485] = { -- You're a Mean One... (Horde)
            [questKeys.preQuestSingle] = {79483},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79486] = { -- A Smokywood Pastures' Thank You! (Alliance)
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79487] = { -- A Smokywood Pastures' Thank You! (Horde)
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79492] = { -- Metzen the Reindeer (Alliance)
            [questKeys.objectives] = {{{15664,"Find Metzen the Reindeer and rescue him"}},nil,{{21211}}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79495] = { -- Metzen the Reindeer (Horde)
            [questKeys.objectives] = {{{15664,"Find Metzen the Reindeer and rescue him"}},nil,{{21211}}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79535] = { -- Basilisks: Should Petrification be Feared?
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79536] = { -- Greater Friend of the Library
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79588] = { -- Small Furry Paws
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79589] = { -- Torn Bear Pelts
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79590] = { -- Heavy Grinding Stone
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 250}},
        },
        [79591] = { -- Whirring Bronze Gizmo
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79592] = { -- Carnival Jerkins
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 250}},
        },
        [79593] = { -- Coarse Weightstone
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79594] = { -- Copper Modulator
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79595] = { -- Carnival Boots
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79624] = { -- Anyone Can Cook
            [questKeys.startedBy] = {{2254,2255,2256,2287,2569,2570,2571}},
            [questKeys.zoneOrSort] = zoneIDs.WARRIOR,
        },
        [79626] = { -- The Salvagematic 9000!
            [questKeys.startedBy] = {nil,{422483}},
            [questKeys.finishedBy] = {nil,{422483}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79677] = { -- A Quick Grocery Run
            [questKeys.preQuestSingle] = {79624},
            [questKeys.zoneOrSort] = zoneIDs.WARRIOR,
        },
        [79678] = { -- Taste Testing
            [questKeys.preQuestSingle] = {79677},
            [questKeys.zoneOrSort] = zoneIDs.WARRIOR,
        },
        [79704] = { -- The Salvagematic 9000!
            [questKeys.startedBy] = {nil,{422483}},
            [questKeys.finishedBy] = {nil,{422483}},
            [questKeys.preQuestSingle] = {79705},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79705] = { -- Salvaging the Salvagematic
            [questKeys.finishedBy] = {{217689}},
            [questKeys.objectives] = {nil,nil,{{3860},{11135},{216634},{213735}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79731] = { -- The Troll Scroll
            [questKeys.startedBy] = {{702}},
            [questKeys.objectivesText] = {
                "Solve the riddle of the scroll. Once you've done that, Hemet Nesingwary might like to hear the tale.",
                "NOTE: Have a Rogue with a Jani's Charm trinket pickpocket a Mysterious Troll Scroll from the Bloodscalp Trolls in Stranglethorn Vale.",
                "Then let that scroll be deciphered by a Mage to receive a Deciphered Troll Scroll starting this quest.",
            },
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSourceItems] = {737},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_OBJECT, l10n("Use the Holy Spring Water next to the Holy Spring, while you have two meditation buffs active. Then loot the rune from the fountain."), 0, {{"object", 759}}}},
        },
        [79939] = { -- The Broken Hammer
            [questKeys.startedBy] = {nil,{423703}},
            [questKeys.preQuestSingle] = {78093},
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79940] = { -- A Lost Brother
            [questKeys.objectives] = {{{5492,"Speak with Katherine and Learn More"}}},
            [questKeys.preQuestSingle] = {79939},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79945] = { -- Orders from the Grand Crusader
            [questKeys.startedBy] = {{218908}},
            [questKeys.preQuestSingle] = {79940},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [79946] = { -- A Brother In Need
            [questKeys.objectives] = {{{5492,"Learn more about Aeonas from Katherine"},{217996,"Find Aeonas in the Scarlet Monastery"}}},
            [questKeys.preQuestSingle] = {79945},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_MONASTERY,
        },
        [79947] = { -- Geomancy: The Stone-Cold Truth
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79948] = { -- Defensive Magics 101
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79949] = { -- A Web of Lies: Debunking Myths and Legends
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79950] = { -- Demons and You
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79951] = { -- Mummies: A Guide to the Unsavory Undead
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79952] = { -- RwlRwlRwlRwl!
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79953] = { -- A Ludite's Guide to Caring for Your Demonic Pet
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79963] = { -- By The Light's Grace
            [questKeys.objectives] = {{{217996,"Heal Aeonas"}}},
            [questKeys.preQuestSingle] = {79946},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_MONASTERY,
        },
        [79970] = { -- Aeonas the Vindicated
            [questKeys.objectives] = {{{218160,"Meet Aeonas at the Cathedral of Light in Stormwind"}}},
            [questKeys.preQuestSingle] = {79963},
            [questKeys.zoneOrSort] = zoneIDs.PALADIN,
        },
        [79974] = { -- Wet Job
            [questKeys.startedBy] = {nil,{424012}},
            [questKeys.finishedBy] = {nil,{424007}},
            [questKeys.preQuestSingle] = {79980},
            [questKeys.zoneOrSort] = zoneIDs.STONETALON_MOUNTAINS,
        },
        [79975] = { -- Eagle's Fist
            [questKeys.startedBy] = {nil,{424007}},
            [questKeys.finishedBy] = {nil,{406918}},
            [questKeys.preQuestSingle] = {79974},
            [questKeys.zoneOrSort] = zoneIDs.STONEWROUGHT_DAM,
        },
        [79976] = { -- This Must Be The Place
            [questKeys.startedBy] = {nil,{406918}},
            [questKeys.finishedBy] = {nil,{424006}},
            [questKeys.preQuestSingle] = {79975},
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
        },
        [79980] = { -- Scramble
            [questKeys.startedBy] = {nil,{424005}},
            [questKeys.finishedBy] = {nil,{424012}},
            [questKeys.preQuestSingle] = {79192},
            [questKeys.zoneOrSort] = zoneIDs.STONETALON_MOUNTAINS,
        },
        [79981] = { -- The Corroded Core
            [questKeys.startedBy] = {{216666}},
            [questKeys.finishedBy] = {{218237}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Talk with Scooty in Booty Bay."), 0, {{"monster", 7853}}}},
        },
        [79982] = { -- Warrany Claim
            [questKeys.preQuestSingle] = {79981},
            [questKeys.requiredSourceItems] = {216635,216645},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{84.5,44.8}}}, Questie.ICON_TYPE_SLAY, l10n("Defeat enough enemies around the world to call forth the Shadowy Figure and talk to her to receive a Mote of Darkness.")}},
        },
        [79984] = { -- Quadrangulation
            [questKeys.objectives] = {nil,{{424074},{424075},{424076},{424077}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79985] = { -- A Fine Mess
            [questKeys.triggerEnd] = {"Kernobee Rescue", {[zoneIDs.GNOMEREGAN]={{-1,-1}}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79986] = { -- Grime-Encrusted Ring
            [questKeys.startedBy] = {nil,nil,{216661}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79987] = { -- Return of the Ring Alliance
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.preQuestSingle] = {79984},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79990] = { -- Stranglethorn Lumber
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
        },
        [79991] = { -- Stranglethorn Lumber
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
        },
        [80001] = { -- Rekindle
            [questKeys.startedBy] = {nil,{424082}},
            [questKeys.finishedBy] = {nil,{424082}},
            [questKeys.preQuestSingle] = {79192},
            [questKeys.exclusiveTo] = {79974},
        },
        [80098] = { -- Curious Dalaran Relic
            [questKeys.startedBy] = {{218931}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80120] = { -- A Service to Dalaran
            [questKeys.preQuestGroup] = {80098,80147,80148,80149,80150,80151,80152},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80131] = { -- Gnome Improvement Alliance
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.preQuestSingle] = {79987},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80132] = { -- Rig Wars
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80133] = { -- Chief Engineer Scooty
            [questKeys.startedBy] = {{3413}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80134] = { -- Gnomer-gooooone!
            [questKeys.triggerEnd] = {"Goblin Transponder", {[zoneIDs.STRANGLETHORN_VALE]={{27.56,77.42}}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.preQuestSingle] = {80133},
        },
        [80135] = { -- Klockmort's Essentials
            [questKeys.exclusiveTo] = {80136},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80136] = { -- Essential Artificials
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80137] = { -- Save Techbot's Brain!
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80138] = { -- Tinkmaster Overspark
            [questKeys.exclusiveTo] = {80137},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80139] = { -- Gnogaine
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80140] = { -- Return of the Ring Horde
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.preQuestSingle] = {79984},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80141] = { -- Nogg's Ring Redo
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.preQuestSingle] = {80140},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80143] = { -- Data Rescue
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 1: obtain the Yellow Punch Card. You need the White Punch Card."), 0, {{"object", 142345}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 2: obtain the Blue Punch Card. You need the Yellow Punch Card."), 0, {{"object", 142475}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 3: obtain the Red Punch Card. You need the Blue Punch Card."), 0, {{"object", 142476}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 4: obtain the Prismatic Punch Card. You need the Red Punch Card."), 0, {{"object", 142696}}},
            },
            [questKeys.requiredSourceItems] = {9279,9280,9281,9282},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80147] = { -- Glittering Dalaran Relic
            [questKeys.startedBy] = {{900000}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80148] = { -- Whirring Dalaran Relic
            [questKeys.startedBy] = {{900001}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80149] = { -- Odd Dalaran Relic
            [questKeys.startedBy] = {{900002}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80150] = { -- Heavy Dalaran Relic
            [questKeys.startedBy] = {{900003}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80151] = { -- Creepy Dalaran Relic
            [questKeys.startedBy] = {{900004}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80152] = { -- Slippery Dalaran Relic
            [questKeys.startedBy] = {{900005}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80153] = { -- The Sparklematic 5200!
            [questKeys.startedBy] = {nil,{175084}},
            [questKeys.finishedBy] = {nil,{175084}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80155] = { -- More Sparklematic Action
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.preQuestSingle] = {80157},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80157] = { -- The Sparklematic 5200!
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.preQuestSingle] = {80158},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80158] = { -- The Sparklematic 5200!
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80160] = { -- More Sparklematic Action
            [questKeys.startedBy] = {nil,{175084}},
            [questKeys.finishedBy] = {nil,{175084}},
            [questKeys.preQuestSingle] = {80161},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80161] = { -- The Sparklematic 5200!
            [questKeys.startedBy] = {nil,{175084}},
            [questKeys.finishedBy] = {nil,{175084}},
            [questKeys.preQuestSingle] = {80153},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80180] = { -- The Grand Betrayal
            [questKeys.finishedBy] = {{7937}},
            [questKeys.objectives] = {{{218537}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80181] = { -- Gyrodrillmatic Excavationators
            [questKeys.finishedBy] = {{6579}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80182] = { -- The Only Cure is More Green Glow
            [questKeys.startedBy] = {{1268}},
            [questKeys.finishedBy] = {{1268}},
            [questKeys.preQuestSingle] = {80139},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80241] = {
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSkill] = {specKeys.BLACKSMITHING,210},
        },
        [80307] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80308] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80309] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80324] = { -- The Mad King
            [questKeys.startedBy] = {{218537}},
            [questKeys.finishedBy] = {{7937}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{217350}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80325] = { -- The Mad King
            [questKeys.startedBy] = {{218537}},
            [questKeys.finishedBy] = {{3412}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {nil,nil,{{217351}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80411] = { -- The Talisman of Kazdor
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80526},
            [questKeys.nextQuestInChain] = 80453,
        },
        [80421] = { -- Green Iron Bracers
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80422] = { -- Green Fireworks
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80423] = { -- The World's Largest Gnome!
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80453] = { -- Best Laid Plans
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80411},
            [questKeys.nextQuestInChain] = 80454,
        },
        [80454] = { -- One Last Drop
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80453},
            [questKeys.nextQuestInChain] = 80455,
        },
        [80455] = { -- Biding Our Time
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80454},
        },
        [80526] = { -- Fool Me Twice
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestGroup] = {6681,78261,78676},
            [questKeys.nextQuestInChain] = 80411,
        },
        [81570] = { -- Jarl Needs a Blade
            [questKeys.finishedBy] = {{4792}},
            [questKeys.preQuestSingle] = {1206},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
        },

        -- P3 Incursion Intro Quests
        [81716] = { -- Recover Incursion Field Report: Duskwood
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219759}},nil,{{{221226},221226},{{221223},221223},{{221227},221227}}},
        },
        [81727] = { -- Recover Incursion Field Report: Ashenvale
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219770}},nil,{{{221283},221283},{{221282},221282},{{221292},221292}}},
        },
        [81728] = { -- Recover Incursion Field Report: Hinterlands
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219772}},nil,{{{221357},221357},{{221356},221356},{{221360},221360}}},
        },
        [81729] = { -- Recover Incursion Field Report: Feralas
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219771}},nil,{{{221407},221407},{{221406},221406},{{221408},221408}}},
        },

        -- Begin Duskwood Incursion
        [81730] = { -- Duskwood Mission I: Defeat Worgen
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221171},{221172}}},
        },
        [81731] = { -- Duskwood Mission II: Defeat Ogres
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221174},{221175}}},
        },
        [81732] = { -- Duskwood Mission III: Defeat Dragonkin
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221200},{221176}}},
        },
        [81733] = { -- Duskwood Mission IV: Ogre Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219776}}},
        },
        [81734] = { -- Duskwood Mission V: Worgen Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219778}}},
        },
        [81735] = { -- Duskwood Mission VI: Dragon Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219803}}},
        },
        [81736] = { -- Duskwood Mission VII: Recover Shadowscythe
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219404}}},
        },
        [81737] = { -- Duskwood Mission VIII: Recover Ogre Magi text
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219405}}},
        },
        [81738] = { -- Duskwood Mission IX: Recover Dragon Egg
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219406}}},
        },
        [81739] = { -- Duskwood Mission X: Nightmare Moss
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219399}}},
        },
        [81740] = { -- Duskwood Mission XI: Cold Iron Ore
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219401}}},
        },
        [81741] = { -- Duskwood Mission XII: Dream-Touched Dragonscale
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219402}}},
        },
        [81742] = { -- Duskwood Mission XIII: Defeat Ylanthrius
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221204}}},
        },
        [81743] = { -- Duskwood Mission XIV: Defeat Vvarc'zul
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221206}}},
        },
        [81744] = { -- Duskwood Mission XV: Defeat Amokarok
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221207}}},
        },
        [81745] = { -- Duskwood Mission XVI: Rescue Kroll Mountainshade
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221210}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.DUSKWOOD]={{46.52,38.69}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Kroll Mountainshade to the Dream Portal"),}},
        },
        [81746] = { -- Duskwood Mission XVII: Rescue Alara Grovemender
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221215}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.DUSKWOOD]={{46.52,38.69}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Alara Grovemender to the Dream Portal"),}},
        },
        [81747] = { -- Duskwood Mission XVIII: Rescue Elenora Marshwalker
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221216}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.DUSKWOOD]={{46.52,38.69}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Elenora Marshwalker to the Dream Portal"),}},
        },
        -- End Duskwood Incursion

        -- Begin Ashenvale Incursion
        [81768] = { -- Ashenvale Mission I: Defeat Satyrs
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221262},{221261}}},
        },
        [81769] = { -- Ashenvale Mission II: Defeat Treants
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221263}}},
        },
        [81770] = { -- Ashenvale Mission III: Defeat Dragonkin
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221259},{221260}}},
        },
        [81771] = { -- Ashenvale Mission IV: Dragon Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219924}}},
        },
        [81772] = { -- Ashenvale Mission V: Satyr Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219925}}},
        },
        [81773] = { -- Ashenvale Mission VI: Treant Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219926}}},
        },
        [81774] = { -- Ashenvale Mission VII: Recover Dreamengine
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219448}}},
        },
        [81775] = { -- Ashenvale Mission VIII: Recover Azsharan Prophecy
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219449}}},
        },
        [81776] = { -- Ashenvale Mission IX: Recover Dream-Touched Dragonegg
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219447}}},
        },
        [81777] = { -- Ashenvale Mission X: Dreamroot
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219444}}},
        },
        [81778] = { -- Ashenvale Mission XI: Fool's Gold Dust
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219445}}},
        },
        [81779] = { -- Ashenvale Mission XII: Dream-Infused Dragonscale
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219446}}},
        },
        [81780] = { -- Ashenvale Mission XIII: Defeat Larsera
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221265}}},
        },
        [81781] = { -- Ashenvale Mission XIV: Defeat Zalius
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221266}}},
        },
        [81782] = { -- Ashenvale Mission XV: Defeat Shredder 9000
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221267}}},
        },
        [81783] = { -- Ashenvale Mission XVI: Rescue Alyssian Windcaller
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221270}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{93.94,38.35}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Alyssian Windcaller to the Dream Portal"),}},
        },
        [81784] = { -- Ashenvale Mission XVII: Rescue Doran Dreambough
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221268}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{93.94,38.35}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Doran Dreambough to the Dream Portal"),}},
        },
        [81785] = { -- Ashenvale Mission XVIII: Rescue Maseara Autumnmoon
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221269}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{93.94,38.35}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Maseara Autumnmoon to the Dream Portal"),}},
        },
        -- End Ashenvale Incursion

        -- Begin Hinterlands Incursion
        [81786] = { -- Hinterlands Mission I: Defeat Moonkin
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221330}}},
        },
        [81787] = { -- Hinterlands Mission II: Defeat Giant Turtles
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221328}}},
        },
        [81788] = { -- Hinterlands Mission III: Defeat Dragonkin
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221326},{221325}}},
        },
        [81789] = { -- Hinterlands Mission IV: Dragon Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219928}}},
        },
        [81817] = { -- Hinterlands Mission V: Turtle Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219937}}},
        },
        [81820] = { -- Hinterlands Mission VI: Moonkin Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219938}}},
        },
        [81826] = { -- Hinterlands Mission VII: Recover Star-Touched Dragonegg
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219488}}},
        },
        [81830] = { -- Hinterlands Mission VIII: Recover Elunar Relic
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219490}}},
        },
        [81832] = { -- Hinterlands Mission IX: Recover Dreampearl
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219491}}},
        },
        [81833] = { -- Hinterlands Mission X: Star Lotus
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219454}}},
        },
        [81834] = { -- Hinterlands Mission XI: Starsilver Ore
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219486}}},
        },
        [81835] = { -- Hinterlands Mission XII: Starshells
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219487}}},
        },
        [81837] = { -- Hinterlands Mission XIII: Defeat Florius
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221331}}},
        },
        [81838] = { -- Hinterlands Mission XIV: Defeat Doomkin
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221333}}},
        },
        [81839] = { -- Hinterlands Mission XV: Defeat Ghamoo-Raja
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221334}}},
        },
        [81850] = { -- Hinterlands Mission XVI: Rescue Elianar Shadowdrinker
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221335}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.THE_HINTERLANDS]={{63.24,27.39}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Elianar Shadowdrinker to the Dream Portal"),}},
        },
        [81851] = { -- Hinterlands Mission XVII: Rescue Serlina Starbright
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221336}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.THE_HINTERLANDS]={{63.24,27.39}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Serlina Starbright to the Dream Portal"),}},
        },
        [81852] = { -- Hinterlands Mission XVIII: Rescue Veanna Cloudsleeper
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221337}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.THE_HINTERLANDS]={{63.24,27.39}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Veanna Cloudsleeper to the Dream Portal"),}},
        },
        -- End Hinterlands Incursion

        -- Begin Feralas Incursion
        [81855] = { -- Feralas Mission I: Defeat Children of Cenarius
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221375},{221377}}},
        },
        [81856] = { -- Feralas Mission II: Defeat Harpies
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221370},{221371}}},
        },
        [81857] = { -- Feralas Mission III: Defeat Dragonkin
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221369},{221367}}},
        },
        [81858] = { -- Feralas Mission IV: Dragon Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219957}}},
        },
        [81859] = { -- Feralas Mission V: Cenarion Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219958}}},
        },
        [81860] = { -- Feralas Mission VI: Harpy Intelligence
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219959}}},
        },
        [81861] = { -- Feralas Mission VII: Recover Moonglow Dragonegg
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219520}}},
        },
        [81863] = { -- Feralas Mission VIII: Recover Keeper's Notes
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219519}}},
        },
        [81864] = { -- Feralas Mission IX: Recover Harpy Screed
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219518}}},
        },
        [81865] = { -- Feralas Mission X: Moonroot
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219514}}},
        },
        [81866] = { -- Feralas Mission XI: Greater Moonstone
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219515}}},
        },
        [81867] = { -- Feralas Mission XII: Greater Moondragon Scales
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219517}}},
        },
        [81868] = { -- Feralas Mission XIII: Defeat Tyrannikus
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221393}}},
        },
        [81870] = { -- Feralas Mission XIV: Defeat Alondrius
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221389}}},
        },
        [81871] = { -- Feralas Mission XV: Defeat Slirena
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221391}}},
        },
        [81872] = { -- Feralas Mission XVI: Rescue Mellias Earthtender
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221395}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{50.97,11.67}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Mellias Earthtender to the Dream Portal"),}},
        },
        [81873] = { -- Feralas Mission XVII: Rescue Nerene Brooksinger
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221398}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{50.97,11.67}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Nerene Brooksinger to the Dream Portal"),}},
        },
        [81874] = { -- Feralas Mission XVIII: Rescue Jamniss Treemender
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221399}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{50.97,11.67}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Jamniss Treemender to the Dream Portal"),}},
        },
        -- End Feralas Incursion

        [81986] = { -- Waking the Nightmare
            [questKeys.preQuestSingle] = {82022},
            [questKeys.objectives] = {{{222198}},nil,{{220570}}},
            [questKeys.zoneOrSort] = sortKeys.NIGHTMARE_INCURSIONS,
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{94.26,35.13}}}, Questie.ICON_TYPE_EVENT, l10n("Enter the Emerald Dream"),}},
        },
        [82017] = { -- An Amalagamation of Nightmares
            [questKeys.nextQuestInChain] = 82018,
            [questKeys.objectives] = {{{12042}}},
        },
        [82018] = { -- Itharius
            [questKeys.nextQuestInChain] = 82019,
            [questKeys.preQuestSingle] = {82017},
            [questKeys.objectives] = {{{5353}}},
        },
        [82019] = { -- Going Under
            [questKeys.nextQuestInChain] = 82020,
            [questKeys.preQuestSingle] = {82018},
            [questKeys.objectives] = {{{223568}}},
        },
        [82020] = { -- Return to Moonglade
            [questKeys.nextQuestInChain] = 82021,
            [questKeys.preQuestSingle] = {82019},
            [questKeys.objectives] = {{{12042}}},
        },
        [82021] = { -- A Fortuitous Turn of Events
            [questKeys.nextQuestInChain] = 82022,
            [questKeys.preQuestSingle] = {82020},
            [questKeys.objectives] = {{{222225}}},
        },
        [82022] = { -- The Bad News...
            [questKeys.nextQuestInChain] = 81986,
            [questKeys.preQuestSingle] = {82021},
            [questKeys.objectives] = {nil,nil,{{220964}}},
            [questKeys.childQuests] = {82023},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Talk to the Injured Gnome"), 0, {{"monster", 222444}}}},
        },
        [82023] = { -- The Lost Vambraces
            [questKeys.parentQuest] = 82022,
            [questKeys.objectives] = {nil,{{441848}}},
        },
        [82068] = { -- Fight the Nightmare Incursions
            [questKeys.startedBy] = {{221479,221480}},
            [questKeys.finishedBy] = {{221479,221480}},
            [questKeys.objectives] = {nil,nil,nil,nil,{{{221479,221480},221479}}},
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82084] = { --A Lesson in Literacy
            [questKeys.startedBy] = {{211022,211033}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [82089] = { -- Master of Transmutation
            [questKeys.zoneOrSort] = sortKeys.ALCHEMY,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY,275},
        },
        [82090] = { -- Mixology For Fun and Profit
            [questKeys.zoneOrSort] = sortKeys.ALCHEMY,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY,275},
        },
        [82095] = { -- The God Hakkar
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {4787},
        },
        [82096] = { -- Into the Depths
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {3444},
        },
        [82097] = { -- Secret of the Circle
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {3444},
        },
        [82098] = { -- Into The Temple of Atal'Hakkar
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {1469},
        },
        [82099] = { -- Haze of Evil
            [questKeys.zoneOrSort] = zoneIDs.UN_GORO_CRATER,
            [questKeys.preQuestSingle] = {4142},
            [questKeys.nextQuestInChain] = 4144,
        },
        [82100] = { -- The Temple of Atal'Hakkar
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {1444},
        },
        [82102] = { -- The Essence of Eranikus
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82104] = { -- Jammal'an the Prophet
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82106] = { -- Forging the Mightstone
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.preQuestSingle] = {8416},
        },
        [82107] = { -- Voodoo Feathers
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.preQuestSingle] = {8424},
        },
        [82108] = { -- The Green Drake
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
            [questKeys.preQuestSingle] = {8231},
        },
        [82110] = { -- The Azure Key
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {8235},
        },
        [82111] = { -- Blood of Morphaz
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {8256},
        },
        [82112] = { -- A Better Ingredient
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.preQuestSingle] = {9051},
        },
        [82113] = { -- Da Voodoo
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
            [questKeys.preQuestSingle] = {8412},
        },
        [82114] = { -- Destroy Morphaz
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.preQuestSingle] = {8252},
        },
        [82115] = { -- Trolls of a Feather
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {8421},
        },
        [82209] = { -- Water Pouch Bounty  (repeatable)
            [questKeys.preQuestSingle] = {1707},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82307] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82308] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82309] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82656] = { -- Wild Leather Vest (Horde)
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
        },
        [82657] = { -- Wild Leather Vest (Alliance)
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
        },
        [82662] = { -- The Way of the Weaponsmith (Alliance)
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,200},
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING,
        },
        [82665] = { -- The Way of the Weaponsmith (Horde)
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,200},
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING,
        },

        --- Fake rune quests
        [90000] = {
            [questKeys.name] = "Arcane Blast",
            [questKeys.startedBy] = {nil,{450000}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Cast Arcane Explosion in the correct order next to the Arcane Shard. South to North."},
            [questKeys.requiredSpell] = -401757,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90001] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{208752}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Trogg with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90002] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90003] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90004] = {
            [questKeys.name] = "Fingers of Frost",
            [questKeys.startedBy] = {{448,1132,1388,1271}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -401765,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90005] = {
            [questKeys.name] = "Fingers of Frost",
            [questKeys.startedBy] = {{3205,208196}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -401765,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90006] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {nil,{407983}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Search the hut for a Pile of Stolen Books."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90007] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {nil,{152608,152618,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Loot the Kolkar's Booty chest."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90008] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {{589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Defias Pillager."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90009] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {{1867}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Dalaran Apprentice."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90010] = {
            [questKeys.name] = "Enlightenment",
            [questKeys.startedBy] = {{202093}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 8,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Polymorph 6 irregular critters like Gazelle, Maggot and Larva to loot Azora Apprentice Notes. You find them all over Elwynn Forest."},
            [questKeys.requiredSpell] = -415942,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90011] = {
            [questKeys.name] = "Enlightenment",
            [questKeys.startedBy] = {{208712}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 8,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Polymorph 6 Odd Melon to loot Apothecary Notes. You find them all over Tirisfal Glades."},
            [questKeys.requiredSpell] = -415942,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90012] = {
            [questKeys.name] = "Arcane Surge",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Arcane Surge rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425171,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90013] = {
            [questKeys.name] = "Arcane Surge",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Arcane Surge rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425171,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90014] = {
            [questKeys.name] = "Mass Regeneration",
            [questKeys.startedBy] = {{212261},{411328,411348}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Loot the Decrepit Phylactery from the Dusty Coffer in the eastern crypt. Then use it on the Slumbering Bones in the western crypt to summon the Awakened Lich and defeat it."},
            [questKeys.requiredSpell] = -415939,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90015] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{476}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Kobold Geomancer."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90016] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{1124,1397}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Frostmane Shadowcaster and Frostmane Seer."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90017] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{3197}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Burning Blade Fanatic."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90018] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{1535}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Scarlet Warrior."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90019] = {
            [questKeys.name] = "Rewind Time",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Buy the Rewind Time rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -401761,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90020] = {
            [questKeys.name] = "Living Bomb",
            [questKeys.startedBy] = {{1166}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 13,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Stonesplinter Seer."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90021] = {
            [questKeys.name] = "Living Bomb",
            [questKeys.startedBy] = {nil,{407505}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Use Blink to reach each green dot."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90022] = {
            [questKeys.name] = "Divine Storm",
            [questKeys.startedBy] = {nil,{409289}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot Althalaxx Orb on top of the tower then go to Maestra’s Post in Ashenvale and speak with Delgren the Purifier."},
            [questKeys.exclusiveTo] = {78089},
            [questKeys.requiredSpell] = -410014,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90023] = {
            [questKeys.name] = "Wild Strikes",
            [questKeys.startedBy] = {{11910,11913,11912,11911}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat Grimtotem Tauren to receive Idol of the Wild and follow its guidance."},
            [questKeys.requiredSpell] = -410021,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90024] = {
            [questKeys.name] = "Survival of the Fittest",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy the Survival of the Fittest rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -416042,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90025] = {
            [questKeys.name] = "Serendipity",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Buy the Serendipity rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -415995,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90026] = {
            [questKeys.name] = "Divine Sacrifice",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Buy the Divine Sacrifice rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -410010,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90027] = {
            [questKeys.name] = "Lone Wolf",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy the Lone Wolf rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -410122,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90028] = {
            [questKeys.name] = "Warbringer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Buy the Warbringer rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -425445,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90029] = {
            [questKeys.name] = "Demonic Pact",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy the Demonic Pact rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -425476,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90030] = {
            [questKeys.name] = "Main Gauche",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Buy the Main Gauche rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -424990,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90031] = {
            [questKeys.name] = "Dual Wield Specialization",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Buy the Dual Wield Specialization rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -410096,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90032] = {
            [questKeys.name] = "Lake of Fire",
            [questKeys.startedBy] = {{3537}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy Demolition Explosives from Zixil for 1 gold."},
            [questKeys.requiredSpell] = -403937,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90033] = {
            [questKeys.name] = "Lake of Fire",
            [questKeys.startedBy] = {nil,{414658}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Demolition Explosives bought from Zixil on the rubble and loot the chest that spawns."},
            [questKeys.requiredSpell] = -403937,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90034] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{3291}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy Malevolent Pie from Greishan Ironstove. Eat it and he will give you the rune."},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90035] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{2336}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Dark Strand Fanatic"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90036] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{114,480,832,210501}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Harvest Watcher or Rusty Harvest Golem for Spare Reaper Parts. Kill Dust Devil for Elemental Core. Combine for Elemental Core. Use on Harvest Reaper Prototype and kill it for the rune"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90037] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{212763}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Curse of Recklessness on Sadistic Fiend and kill it"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90038] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {nil,{407347}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Health Funnel while standing on the Altar of Thorns until you are at 0 health"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90039] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{208752}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Trogg with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90040] = {
            [questKeys.name] = "Beacon of Light",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Beacon of Light rune from the Quartermaster."},
            [questKeys.requiredSpell] = -409999,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90041] = {
            [questKeys.name] = "Healing Rain",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Healing Rain rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416057,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90042] = {
            [questKeys.name] = "Everlasting Affliction",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Everlasting Affliction rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416008,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90043] = {
            [questKeys.name] = "Everlasting Affliction",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Everlasting Affliction rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416008,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90044] = {
            [questKeys.name] = "Serpent Spread",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Serpent Spread rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425760,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90045] = {
            [questKeys.name] = "Serpent Spread",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Serpent Spread rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425760,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90046] = {
            [questKeys.name] = "Single-Minded Fury",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Single-Minded Fury rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416003,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90047] = {
            [questKeys.name] = "Single-Minded Fury",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Single-Minded Fury rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416003,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90048] = {
            [questKeys.name] = "Skull Bash",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Skull Bash rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416046,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90049] = {
            [questKeys.name] = "Skull Bash",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Skull Bash rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416046,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90050] = {
            [questKeys.name] = "Just a Flesh Wound",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Just a Flesh Wound rune from the Quartermaster."},
            [questKeys.requiredSpell] = -400082,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90051] = {
            [questKeys.name] = "Just a Flesh Wound",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Just a Flesh Wound rune from the Quartermaster."},
            [questKeys.requiredSpell] = -400082,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90052] = {
            [questKeys.name] = "Mind Sear",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Mind Sear rune from the Quartermaster."},
            [questKeys.requiredSpell] = -415996,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90053] = {
            [questKeys.name] = "Mind Sear",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Mind Sear rune from the Quartermaster."},
            [questKeys.requiredSpell] = -415996,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90054] = {
            [questKeys.name] = "Living Seed",
            [questKeys.startedBy] = {{206248}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot 3 Glade Flower spread across the zone. Combine them to the Glade Crown, use it on the Wooden Effigy and defeat the Unleashed Nature Spirit Elite mob."},
            [questKeys.requiredSpell] = -416050,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90055] = {
            [questKeys.name] = "Living Seed",
            [questKeys.startedBy] = {{206248}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot 3 Prairie Flower spread across the zone. Combine them to the Prairie Crown, use it on the Wooden Effigy and defeat the Unleashed Nature Spirit Elite mob."},
            [questKeys.requiredSpell] = -416050,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90056] = {
            [questKeys.name] = "Starsurge",
            [questKeys.startedBy] = {{212186,212209}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Accept the offer from Grugimdern to receive a Mushroom. Then eat the Mushroom at the pond and speak with Vodyanoi."},
            [questKeys.requiredSpell] = -424718,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90057] = {
            [questKeys.name] = "Sunfire",
            [questKeys.startedBy] = {{207577},{404433}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Cast Moonfire on all three Lunar Stones to spawn the Lunar Chest."},
            [questKeys.requiredSpell] = -416044,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90058] = {
            [questKeys.name] = "Lifebloom",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -410033,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90059] = {
            [questKeys.name] = "Prayer of Mending",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -402848,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90060] = {
            [questKeys.name] = "Ancestral Guidance",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -410099,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90061] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90062] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90063] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90064] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{209954,209958}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Demonic Remains with a shadow spell. It spawns Graix, who drops the Rune."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90065] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{391}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Old Murk-Eye to receive Soul of the Sea."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90066] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {nil,{450002}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Soul of the Sea on the Medusa Statue."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90067] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{3445}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Supervisor Lugwizzle to receive Soul of Greed."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90068] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {nil,{407312}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Soul of Greed on the Hungry Idol."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90069] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{1974,1973}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Ravenclaw Drudger and Ravenclaw Guardian until they drop Tortured Soul. Once gathered, Life Tap to receive a buff, and then use the item. This will spawn a Ghost mob to kill."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90070] = {
            [questKeys.name] = "Incinerate",
            [questKeys.startedBy] = {{214519}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Incinerator Gar'im"},
            [questKeys.requiredSpell] = -416015,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90071] = {
            [questKeys.name] = "Demonic Tactics",
            [questKeys.startedBy] = {{204503,906,6122}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Dead Acolyte near Jasperlode Mine. Take the artifact to the Warlock Trainer in Goldshire. Use the Powerless Artifact near the Dead Acolyte. Finally go to Gakin the Darkbinder in Stormwind"},
            [questKeys.requiredSpell] = -416009,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90072] = {
            [questKeys.name] = "Demonic Tactics",
            [questKeys.startedBy] = {{208927,2127,5675}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Dead Acolyte near Scarlet Monestary. Take the artifact to the Warlock Trainer in Brill. Use the Powerless Artifact near the Dead Acolyte. Finally go to Carendin Halgar in Undercity"},
            [questKeys.requiredSpell] = -416009,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90073] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{6124,209002}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Captain Beld to obtain Tainted Soul Shard. Trade both Shards to Gaklik Voidtwist in Kharanos"},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90074] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{448,204256}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Hogger to obtain Tainted Soul Shard. Trade both Shards to Damien Kane, found in the basement of the Goldshire Inn."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90075] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{3204,208226}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Gazz'uz to obtain Tainted Soul Shard. Trade both Shards to Darmak Bloodhowl in Razor Hill."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90076] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{1753,208682}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Maggot Eye to obtain Tainted Soul Shard. Trade both Shards to Denton Bleakway in Undercity."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90077] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Frostmane Shadowcaster in Troll cave west of Brewnall Village Loot Wendigo Blood from Wendigo mobs Loot Wolf Jawbone from Wolf mobs. Use the reagents on Shimmer Ridge and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90078] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Kobolds in Jasperlode Mine. Loot Gnoll Blood from any Gnoll. Loot Wolf Jawbone from any Prowler or Wolf. Use the reagents on the summoning circle at The Slaughtered Lamb Inn in the Mage Quarter in Stormwind and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90079] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Voodoo Troll in Echo Isles. Loot Makrura Leg from Makrura mobs. Loot Kul Tiran Skull from Kul Tiran mobs in Tiragarde Keep. Use the reagents on the summoning circle near Zalazane and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90080] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Darkeye Bonecaster. Loot Gnoll Blood from any Gnoll in Garren's Haunt. Loot Wolf Jawbone from any Darkhound in Tirisfal Glades. Use the reagents on the summoning circle in the Sewers location in Undercity - up where the flight path usually flies you over. Kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90081] = {
            [questKeys.name] = "Heart of the Lion",
            [questKeys.startedBy] = {{211965}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Enter the cave to the east and defeat Carrodin."},
            [questKeys.requiredSpell] = -410115,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90082] = {
            [questKeys.name] = "Master Marksman",
            [questKeys.startedBy] = {{205692,208179,208975,209811}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 6,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use Hunter's Mark on the Bush and defeat the Poacher."},
            [questKeys.requiredSpell] = -410113,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90083] = {
            [questKeys.name] = "Cobra Strikes",
            [questKeys.startedBy] = {{3537,211951}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy Freshwater Snapper Bait from Zixil and use them on the boat in the lake to spawn Koartul."},
            [questKeys.requiredSpell] = -425759,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90084] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {nil,{414532}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Defeat Naga in the Cliffspring River cave to receive Cliffspring Key. Use the key to open the chest."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90085] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {{1169}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Dark Iron dwarfs to receive Dark Iron Lockbox and pick it."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90086] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {nil,{408718}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Defias to receive a Discreet Envelope which contains the Equipment Stash Key. Use the key to open the chest."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90087] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {nil,{407454}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Southsea pirates to receive Buccaneer's Matchbox. Use it to blow up some crates and loot the rune from the spawning chest."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90088] = {
            [questKeys.name] = "First Trial of The Owls",
            [questKeys.startedBy] = {nil,{410020}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredSpell] = -410028,
            [questKeys.objectivesText] = {"Click the Owl Statue to start the the first trial. You will need to defeat 3 waves of 2 mobs each. Then you will receive the Symbol of the First Owl."},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90089] = {
            [questKeys.name] = "Second Trial of The Owls",
            [questKeys.startedBy] = {nil,{410089}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredSpell] = -410028,
            [questKeys.objectivesText] = {"Click the Owl Statue to become able to see Agon who is east of the grove, near the worgen camp. Defeat him and collect the Symbol of the Second Owl."},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90090] = {
            [questKeys.name] = "Third Trial of The Owls",
            [questKeys.startedBy] = {nil,{409942,409949}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredSpell] = -410028,
            [questKeys.objectivesText] = {"Click one of the Twin Owl Statues and reach the other in two minutes. You need to use Aquatic Form to make it in time. If you succeed you'll receive the Symbol of the Third Owl."},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90091] = {
            [questKeys.name] = "Flagellation",
            [questKeys.startedBy] = {{212261},{411328,411348}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Loot the Decrepit Phylactery from the Dusty Coffer in the eastern crypt. Then use it on the Slumbering Bones in the western crypt to summon the Awakened Lich."},
            [questKeys.requiredSpell] = -403480,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90092] = {
            [questKeys.name] = "Blood Frenzy",
            [questKeys.startedBy] = {{203079}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -403474,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90093] = {
            [questKeys.name] = "Furious Thunder",
            [questKeys.startedBy] = {{208638,207515,327,448,1271,1388,3204,3281,3205,3058,6113,208196},{407734}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -403476,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90094] = {
            [questKeys.name] = "Consumed By Rage",
            [questKeys.startedBy] = {{211965}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Enter the cave to the east and defeat Carrodin."},
            [questKeys.requiredSpell] = -425446,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90095] = {
            [questKeys.name] = "Explosive Shot",
            [questKeys.startedBy] = {{208638,327,448,1271,1388,3204,3281,3205,3058,6113,208196},{407734}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -410123,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90100] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{208652}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Troll Head, a Severed Wendigo Paw and a Pristine Trogg Heart to Junni Steelpass."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90101] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{203226}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Kobold Head, a Severed Murloc Head and a Severed Gnoll Head to Viktoria Woods."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90102] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{209608}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Tiger Head, a Severed Owl Head and a Severed Spider Head to Delwynna."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90103] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{207957}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Centaur Head, a Severed Harpy Head and a Severed Quilboar Head to Vahi Bonesplitter."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90104] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{207637}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Gnoll Head, a Severed Harpy Head and a Severed Quilboar Head to Vateya Timberhoof."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90105] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{208619}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Bat Head, a Severed Gnoll Head and a Severed Murloc Head to Dorac Graves."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90106] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{5570}},
            [questKeys.finishedBy] = {{5570}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Bruuk Barleybeard and then defeat Bruart outside the Inn. Return to Bruuk afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90107] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{203475}},
            [questKeys.finishedBy] = {{203475}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Liv Bradford and then defeat Stuart outside the Inn. Return to Liv afterwards"},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90108] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{6736}},
            [questKeys.finishedBy] = {{6736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Innkeeper Keldamyr and then defeat Syllart outside the Inn. Return to Keldamyr afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90109] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{3399}},
            [questKeys.finishedBy] = {{3399}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Zamja and then defeat Gru'ark outside the hut. Return to Zamja afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90110] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{207743}},
            [questKeys.finishedBy] = {{207743}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Netali Proudwind and then defeat Mooart outside the hut. Return to Netali afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90111] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{208920}},
            [questKeys.finishedBy] = {{208920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Penny Hawkins and then defeat Blueheart in the basement. Return to Penny afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90112] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{391}},
            [questKeys.finishedBy] = {{391}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90113] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{210451}},
            [questKeys.finishedBy] = {{210451}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat her."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90114] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{2478}},
            [questKeys.finishedBy] = {{2478}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Mo'grosh Orgre in the north-east of Loch Modan until you receive a Battle Totem. Use this totem to challenge Haren Swifthoof."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90115] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{209607},{407289,407291}},
            [questKeys.finishedBy] = {{209607}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 17,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Pickup the Horde Warbanner in the Crossroads and replace it with the Alliance Warbanner  in Northwatch Hold. Then defeat Lieutenant Stonebrew."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90116] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{210802,211146}},
            [questKeys.finishedBy] = {{211146}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Attack the Webbed Victim to free the Lost Adventurer and defeat him."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90117] = {
            [questKeys.name] = "Seal of Martyrdom",
            [questKeys.startedBy] = {{205278,205153},{402215}},
            [questKeys.finishedBy] = {{205153}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"First talk to Brother Romulus in Stormwind Cathedral. Then head to the stairs right next to Brother Romulus and find the Charred Note. At last challenge Ada Gelhardt and defeat her."},
            [questKeys.requiredSpell] = -410015,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90118] = {
            [questKeys.name] = "Horn of Lordaeron",
            [questKeys.startedBy] = {nil,{407844}},
            [questKeys.finishedBy] = {nil,{407844}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Receive the Libram of Blessings in the basement of the tavern, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -425618,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90119] = {
            [questKeys.name] = "Horn of Lordaeron",
            [questKeys.startedBy] = {{210537}},
            [questKeys.finishedBy] = {{210537}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Defeat the Undying Laborer in the mine and finish him with holy damage to receive the Libram of Blessings. Then equip it and follow its guidance."},
            [questKeys.requiredSpell] = -425618,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90120] = {
            [questKeys.name] = "Aegis",
            [questKeys.startedBy] = {{204989,208802}},
            [questKeys.finishedBy] = {{204989,208802}},
            [questKeys.requiredLevel] = 8,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Cast Purify on the Wounded Adventurer and talk to him afterwards."},
            [questKeys.requiredSpell] = -425619,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90121] = {
            [questKeys.name] = "Inspiration Exemplar",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = {{204827}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -410011,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90122] = {
            [questKeys.name] = "Avenger's Shield",
            [questKeys.startedBy] = {{214456}},
            [questKeys.finishedBy] = {{214456}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -410008,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90123] = {
            [questKeys.name] = "Rebuke",
            [questKeys.startedBy] = {{5570}},
            [questKeys.finishedBy] = {{5570}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Bruuk Barleybeard and then defeat Bruart outside the Inn. Return to Bruuk afterwards."},
            [questKeys.requiredSpell] = -425621,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90124] = {
            [questKeys.name] = "Rebuke",
            [questKeys.startedBy] = {{203475}},
            [questKeys.finishedBy] = {{203475}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Liv Bradford and then defeat Stuart outside the Inn. Return to Liv afterwards"},
            [questKeys.requiredSpell] = -425621,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90125] = {
            [questKeys.name] = "Rebuke",
            [questKeys.startedBy] = {{6736}},
            [questKeys.finishedBy] = {{6736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Innkeeper Keldamyr and then defeat Syllart outside the Inn. Return to Keldamyr afterwards."},
            [questKeys.requiredSpell] = -425621,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90126] = {
            [questKeys.name] = "Hand of Reckoning",
            [questKeys.startedBy] = {nil,{407850}},
            [questKeys.finishedBy] = {nil,{407850}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Retrieve the Libram of Justice deep inside the Stonesplitter Valley cave, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410001,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90127] = {
            [questKeys.name] = "Mangle",
            [questKeys.startedBy] = {{7318}},
            [questKeys.finishedBy] = {{7318}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat him to receive the Idol of Ursine Rage drops, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410025,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90128] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {{1684}},
            [questKeys.finishedBy] = {{1224}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy Rainbow Fin Albacore Chum and feed a Young Threshadon in The Loch."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90129] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {nil,{407117,407120}},
            [questKeys.finishedBy] = {{407120}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Pickup the Abandoned Snapjaw Egg in the Forgotten Pools and place it in the Empty Snapjaw Nest in the Lushwater Oasis."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90130] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {{6788}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat the Den Mother, equip the Ferocious Idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90131] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {nil,{152608,152618,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot the Kolkar's Booty chest, equip the Ferocious Idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90132] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {nil,{408004}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot the Tangled Blight Pile, equip the Ferocious Idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90133] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{386675}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Frostmane Trolls, Rockjaw Troggs, Leper Gnomes and Dark Iron Dwarves for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90134] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450005}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Kobolds, Defias, Murlocs and Gnolls for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90135] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450008}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Timberlings, Gnarlpine, Harpies and Sprites for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90136] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450006}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Kul Tiras, Burning Blade, Quilboar and Trolls for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90137] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450007}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Scarlet, Tirisfal Farmers, Murlocs and Gnolls for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
        },
        [90138] = {
            [questKeys.name] = "Slaughter from the Shadows",
            [questKeys.startedBy] = {nil,{387466,407734,404941}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Lockbox for the rune."},
            [questKeys.requiredSpell] = -424992,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90139] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{1161,1162,1163,1164}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Troggs for the Skull-Shaped Geode. Then get hit by a Skullthumper's stun and use the geode to loot the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90140] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{504,95,449,590,589,121,285,46,732,735},{408799}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Defias for Gillsbane, equip it and then kill Murlocs to receive Soul of the Sea. Take it to the Idol of the Deep to summon Horror of the Deep and defeat it."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90141] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{210482},{408802}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Loot the Gnarled Harpoon, and use it on Paxnozz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90142] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{3497,209797}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Purchase a Fishing Harpoon from Kilxx, and use it on Bruuz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90143] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{212598}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the body of Recke Grinnes, loot him to get Rot Bane, equip it and it will give you the Rot Bane buff. Kill Rot Hide Gnolls until one drops the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90144] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {{452,124,117,501,1426,123,453,125,500,1065,98}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Riverpaw Gnolls until one drops the Ferocious Idol, equip the idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90145] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {{2167,2324,2171,2168,2169,2170,2234}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Furlbogs until Crab Treats drop, use them to feed a Young Reef Crawler and receive the rune."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90146] = {
            [questKeys.name] = "Mangle",
            [questKeys.startedBy] = {{3566,2960}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Flatland Prowlers or Prairie Wolf Alphas until the Idol of Ursine Rage drops. Equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410025,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90147] = {
            [questKeys.name] = "Hand of Reckoning",
            [questKeys.startedBy] = {{846,572,7050}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill Ghouls, Defias Drones or the rare Leprithus until the Libram of Justice drops, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410001,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90148] = {
            [questKeys.name] = "Exorcist",
            [questKeys.startedBy] = {{215,909,910}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill Defias until one drops the Libram of Banishment, equip the libram and follow its guidance."},
            [questKeys.requiredSpell] = -416037,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90150] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{210482},{408802}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Loot the Gnarled Harpoon, and use it on Paxnozz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90151] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{210549}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Mark a Defias Scout with Hunter's Mark, and kill them whilst they are marked until the rune drops."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90152] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{210107}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Kackle and loot the rune."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90153] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{3497,209797}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Purchase a Fishing Harpoon from Kilxx, and use it on Bruuz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90154] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {{210483}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Defias for Magic Pumpkin Seeds, Crabs for Fishy Bonemeal and Kobolds for Fertile Soil Sample. Then go to any farmland in Westfall, and use the seeds to spawn Aggressive Squashling. Kill it and loot the rune."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90155] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{1211}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Leper Gnomes and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90156] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{327}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Goldtooth and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90157] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {nil,{407734}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find a Gnarlpine Cache at the bottom of the Ben'ethil Barrow Den and loot it for the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90158] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{3128,2129}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Kul Tiras and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90159] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{208196}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Gillgar and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90161] = {
            [questKeys.name] = "Strength of Soul",
            [questKeys.startedBy] = {nil,{450003}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Thislefur for Primal Insight, then go up in to the tree, and use it whilst near the Thislefur Dreamcatcher with two Meditation buffs active, and receive the rune."},
            [questKeys.requiredSpell] = -415997,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90162] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {nil,{450004}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Kobolds until a Offering Coin drops, then go to the first left turn near the cave entrance and go to the well, use the coin near the well to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90163] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {{210537}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill the Undying Laborer with holy damage to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90164] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {nil,{414663}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Nagas for Shatterspear Offering, then go to the Shatterspear Idol, and use the offering to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90165] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {{3268,3267,3266,3265,3457}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Quillboars until Helping Hand drops. You then need to use Rank 1 Ressurection on someone for the hand to open, then click it to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90166] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {{212809}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Wailing Spirit, and loot the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90167] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{208812}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Boars for Dun Morogh Pig Meat, then use the meat east of the lake near Brewnall Village, to summon Jorul which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90168] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{209928}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Strigid Birds for Teldrassil Bird Meat, then use the meat east of the river near The Oracle Glade, to summon Mowgh which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90169] = {
            [questKeys.name] = "Power Word: Barrier",
            [questKeys.startedBy] = {{436}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Blackrock Shadowcasters and then loot the rune. You will need to have two mediation buffs to use it."},
            [questKeys.requiredSpell] = -425213,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90170] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{208124}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Mottled Boars for Durotar Pig Meat, then use the meat on the most northern island of The Echo Isles, to summon Raluk which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90171] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{205382}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Swoops and Plainstriders for Mulgore Bird Meat, then use the meat west of Bloodhoof Village, to summon Mokwa which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90172] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{210533}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Goretusks for Goretusk Haunch, then use the haunch north of Gold Coast Quarry, to summon Silverspur which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90173] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{2170,2171,2169,2168,2324,2167,2234}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Furbolgs for Crab Treats, then use them on a Young Reef Crawler on the beach to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90174] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {nil,{407918}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Loot the Empty Trophy Display next to Daryl the Youngling to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90175] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{1778,211736}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Ferocious Grizzled Bears until a Grizzled Protector spawns. Kill it to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90176] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{209524}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Patrolling Cheetah. You will need to drop a trap in its path to remove the speed buff, once the buff is removed, kill it to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90177] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{6124}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Captain Beld to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90178] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{40}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Kobold Miners to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90179] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{2038}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Lord Melenas to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90180] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{13157,3204}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 13,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Makasgar or Gazzuz to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90181] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{1934}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Tirisfal Farmers to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90182] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{1124,1397}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Frostmane Seers and Shadowcasters to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90183] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{474}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Defias Rogue Wizards to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90184] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{2002,2003,2004,2005}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Grells to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90185] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{3206}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Voodoo Trolls to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90186] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{1535,1536}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Scarlet Warriors and Missionaries to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90187] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {{572}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 19,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Leprithus to receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90188] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {{209742}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Cast Dispel on Desert Mirage to receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90189] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {{209908}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel at the Heretic Idol and receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90190] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {nil,{411674}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Loot the Prophecy of a King's Demise on the table next to Thule Ravenclaw and receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90191] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {nil,{414646}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Loot the Remnant on the island and receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90192] = {
            [questKeys.name] = "Circle of Healing",
            [questKeys.startedBy] = {{215,909,910},{450009}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 24,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Loot Dark Insight from Defias, then use it on the Secluded Grave north east of Darkshire and receive the rune."},
            [questKeys.requiredSpell] = -402859,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90193] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{405946}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Dusty Chest, two level 10 mobs will spawn, kill them and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90194] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{386777}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Dusty Chest, two level 10 mobs will spawn, kill them and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90195] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{404830}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Dusty Chest and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90196] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{405201}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket the Shipwreck Cache Key from nearby Vile Fin Murlocs, and use it on the Shipwreck Cache next to the ship and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90197] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{407352}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket the Gnarlpine Stash Key from nearby Gnarlpine Furbolgs, and use it on the Gnarlpine stash out on the tree branch and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90198] = {
            [questKeys.name] = "Envenom",
            [questKeys.startedBy] = {{3536},{410847}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Buy a Hot Tip from Kris Legace, and use it on the Rusty Safe under the waterfall in Western Plaguelands to receive the rune."},
            [questKeys.requiredSpell] = -400102,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90199] = {
            [questKeys.name] = "Mutilate",
            [questKeys.startedBy] = {{2038}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Kill Lord Melanas and loot the rune."},
            [questKeys.requiredSpell] = -400094,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90200] = {
            [questKeys.name] = "Mutilate",
            [questKeys.startedBy] = {{6123,208886}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Kill Dark Iron Spies until Blackrats Note drops, then hand it in to Blackrat at Misty Pine Refuge to receive the rune."},
            [questKeys.requiredSpell] = -400094,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90201] = {
            [questKeys.name] = "Shiv",
            [questKeys.startedBy] = {{215,909,910},{450010}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Kill Defias until Engraved Gold Ring drops, then go to the statue in the middle of Raven Hill and /kneel in front of it to receive the rune."},
            [questKeys.requiredSpell] = -424988,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90202] = {
            [questKeys.name] = "Shamanistic Rage",
            [questKeys.startedBy] = {{212837}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill the Primordial Anomaly which can spawn around The Charred Vale. It shifts forms so you must use different schools of magic to kill it. Loot it to receive the rune."},
            [questKeys.requiredSpell] = -425343,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90203] = {
            [questKeys.name] = "Way of Earth",
            [questKeys.startedBy] = {{209742}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 12,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Cast Purge on Desert Mirage to receive the rune."},
            [questKeys.requiredSpell] = -410107,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90204] = {
            [questKeys.name] = "Way of Earth",
            [questKeys.startedBy] = {{1773}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Rot Hide Mystics until a Rot Totem drops, use it to spawn a level 15 elite. Kill it to receive the rune."},
            [questKeys.requiredSpell] = -410107,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90205] = {
            [questKeys.name] = "Lava Burst",
            [questKeys.startedBy] = {{2373}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Mudsnout Shamans until Kajaric Icon drops, equip it and follow its instructions to receieve the rune."},
            [questKeys.requiredSpell] = -410095,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90206] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{1115,1116,1117,1118,208711}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Rockjaw Troggs until Rabbit Musk drops, consume it and use Tame Beast on a Rabbit critter, then speak to Toby at Amberstill Ranch to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90207] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{2009,2010,2011,2012,2013,2014,2152,209948}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Gnarlpine Furbolgs until Deer Musk drops, consume it and use Tame Beast on a Deer critter, then speak to Raelaeron next to the hunter trainer in Darnassus to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90208] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{3111,3114,3113,3112,5824,5826,208184}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Razermane Quillboars until Adder Pheromone drops, consume it and use Tame Beast on an Adder critter, then speak to Razzil in Razor Hill to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90209] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{2949,2950,2951,205635}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Palemane Gnolls until Prairie Dog Musk drops, consume it and use Tame Beast on a Prairie Dog critter, then speak to Takoda Sunmane in Bloodhoof Village to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90210] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{407731}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Stonemason's Toolbox on the platform behind the quest givers at Stonewrough Dam to receive the rune."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90211] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {{210549}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Approach the Defias Scout in Stealth and Pickpocket them to receive the rune."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90212] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{407457}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Take a left from the main gate, go up and around to the right and jump down onto the wall behind the stable and drop on to the roof and open the Stable Hand's Trunk to receive the rune. NOTE: You need 80 Lockpicking to open the trunk."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90213] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{409131}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Use Sprint and jump to the Rusty Chest on the platform and open it to receive the rune. NOTE: You need to have learnt Sprint to make the jump, alternatively you can bring a Swiftness Potion."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90214] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{414624}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Lighthouse Stash between the roots of the tree to receive the rune."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90215] = {
            [questKeys.name] = "Water Shield",
            [questKeys.startedBy] = {{1972}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Grimson the Pale and equip the Icon, follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -410097,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90216] = {
            [questKeys.name] = "Water Shield",
            [questKeys.startedBy] = {nil,{152608,152618,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Kolkar Centaurs until Kolkar Booty Key drops, then use it on Kolkars' Booty and equip the Icon, follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -410097,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90217] = {
            [questKeys.name] = "Shield Mastery",
            [questKeys.startedBy] = {nil,{450011}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ORC + raceIDs.TROLL,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find a Galvanic Icon, loot it and equip the Icon, follow its instructions to kill 10 enemies with Lightning Bolt Rank 1 to receive the rune."},
            [questKeys.requiredSpell] = -410098,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90218] = {
            [questKeys.name] = "Shield Mastery",
            [questKeys.startedBy] = {nil,{450012}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find a Galvanic Icon, loot it and equip the Icon, follow its instructions to kill 10 enemies with Lightning Bolt Rank 1 to receive the rune."},
            [questKeys.requiredSpell] = -410098,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90219] = {
            [questKeys.name] = "Molten Blast",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -425344,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90220] = {
            [questKeys.name] = "Molten Blast",
            [questKeys.startedBy] = {nil,{404352}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Bael'dun Dwarves until Artifact Storage Key drops, use it on the Artifact Storage. Equip the Icon and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -425344,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90221] = {
            [questKeys.name] = "Berserk",
            [questKeys.startedBy] = {nil,{450013}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 28,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Use Challenging Roar on the Beastly Effigy, then Kill Zai'enki. Equip the Icon and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -424760,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90222] = {
            [questKeys.name] = "Dreamstate",
            [questKeys.startedBy] = {nil,{450015}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 32,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Kol'kar Centaur until Desiccated Seed Pod drops, bring it to the lack in the south east of Desolace, and swim until it becomes a Satyrweed Bulb. Then bring it to Sargeron and plant it in Sandy Loam to receive the rune."},
            [questKeys.requiredSpell] = -410060,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90223] = {
            [questKeys.name] = "Dual Wield Specialization",
            [questKeys.startedBy] = {{217783}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 32,
            [questKeys.questLevel] = 32,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use Flare when you have the Danger! buff, it will reveal a Bloodscalp Guerrilla which patrols so you may need to cast it a few times, kill it to receive the rune."},
            [questKeys.requiredSpell] = -410116,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90224] = {
            [questKeys.name] = "Intervene",
            [questKeys.startedBy] = {{218019,218020,218021,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 24,
            [questKeys.questLevel] = 24,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Use Execute while wielding a two-handed weapon on the left Combat Dummy, use Taunt whilst dual wielding on the center Combat Dummy, and use Shield Bash on the right Combat Dummy to receive the rune."},
            [questKeys.requiredSpell] = -403472,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90225] = {
            [questKeys.name] = "Rallying Cry",
            [questKeys.startedBy] = {{218273}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Wandering Swordsman, after his RP he will spawn Swordman's Reward, open it to receive the rune."},
            [questKeys.requiredSpell] = -426491,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90226] = {
            [questKeys.name] = "Spellfrost Bolt",
            [questKeys.startedBy] = {{780}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Skullsplitter Mystics until Spell Notes: PELFRB STOLLOTS drops, decipher it to receive the rune."},
            [questKeys.requiredSpell] = -415948,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90227] = {
            [questKeys.name] = "Frostfire Bolt",
            [questKeys.startedBy] = {{780}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Skullsplitter Mystics until Spell Notes: TROFF IRESTBOL drops, decipher it to receive the rune."},
            [questKeys.requiredSpell] = -401762,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90228] = {
            [questKeys.name] = "Rolling with the Punches",
            [questKeys.startedBy] = {nil,{423930}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Keep opening the chests in the Sizable Stolen Strongbox until you receive the rune."},
            [questKeys.requiredSpell] = -400093,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90229] = {
            [questKeys.name] = "Sacred Shield",
            [questKeys.startedBy] = {nil,{423695}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot the Libram of Deliverance from a book on the bench inside the building. Equip the Libram and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -416028,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90230] = {
            [questKeys.name] = "Focused Rage",
            [questKeys.startedBy] = {nil,{450014}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Witherbark Trolls until Witherbark Mallet drops, use it on the gong inside of the cave to summon an Witherbark Goliath and two adds. Kill the Goliath and loot it to receive the rune."},
            [questKeys.requiredSpell] = -409163,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90231] = {
            [questKeys.name] = "Spirit of the Alpha",
            [questKeys.startedBy] = {nil,{421568}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Starting at Freewind Post, take the northern and then the lower bridge to see a chest on a pillar. Either in Ghost Wolf form or with a different speed boost, jump down and loot the chest."},
            [questKeys.requiredSpell] = -410103,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90232] = {
            [questKeys.name] = "Empowered Renew",
            [questKeys.startedBy] = {{2252,2253,10758,10759,10760,10761}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Defeat Grimtotem Tauren or Crushridge Ogres to receive the rune."},
            [questKeys.requiredSpell] = -425309,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90233] = {
            [questKeys.name] = "Steady Shot",
            [questKeys.startedBy] = {{217836}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Needletooth, then loot him to receive the rune."},
            [questKeys.requiredSpell] = -410109,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90234] = {
            [questKeys.name] = "Hot Streak",
            [questKeys.startedBy] = {{217305},{450016}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 16,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Cast Flamestrike on the two bellows on the outside of the blacksmith in Strahnbrad until they are glowing red, this will spawn an Ancient Fire Elemental, kill it to receive the rune."},
            [questKeys.requiredSpell] = -401749,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90235] = {
            [questKeys.name] = "Renewed Hope",
            [questKeys.startedBy] = {{4713,218249}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 32,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Nagas until they drop Unsettling VIsion, then use Mind Control on a Slitherblade Tide Priestess to acquire her Meditation buff, then use Unsettling Vision to receive the rune."},
            [questKeys.requiredSpell] = -425310,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90236] = {
            [questKeys.name] = "Chronostatic Preservation",
            [questKeys.startedBy] = {{217703}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage friends and defeat the Singed Highperch Consort with frost spells. Combine all three Partial Spell Notes to receive the rune."},
            [questKeys.requiredSpell] = -425189,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90237] = {
            [questKeys.name] = "Chronostatic Preservation",
            [questKeys.startedBy] = {{217669}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage friends and defeat the Scorched Screeching Roguefeather with frost spells. Combine all three Partial Spell Notes to receive the rune."},
            [questKeys.requiredSpell] = -425189,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90238] = {
            [questKeys.name] = "Chronostatic Preservation",
            [questKeys.startedBy] = {{217711}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage friends and attack Galak Centaur to loot a Cougar Cage Key. Open the cage and defeat the Seared Needles Cougar with frost spells. Combine all three Partial Spell Notes to receive the rune."},
            [questKeys.requiredSpell] = -425189,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90239] = {
            [questKeys.name] = "Fire Nova: Step 1",
            [questKeys.startedBy] = {{217392}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Defeat Flameseer Dubelen and loot the Corrupted Fire Totem. Then head to Maraudon."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90240] = {
            [questKeys.name] = "Fire Nova: Step 2",
            [questKeys.startedBy] = {nil,{422895,422896}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Loot both Tears of Theradras. One in the purple wing and the other in the orange wing of the entrance cave, not the dungeon itself. Then head to Orgrimmar."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90241] = {
            [questKeys.name] = "Fire Nova: Step 3",
            [questKeys.startedBy] = {{4047}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Zor Lonetree, who sends you to Arch Druid Hamuul Runetotem in Thunder Bluff."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90242] = {
            [questKeys.name] = "Fire Nova: Step 4",
            [questKeys.startedBy] = {{5769}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Arch Druid Hamuul Runetotem, who sends you to Tal in Thunder Bluff."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90243] = {
            [questKeys.name] = "Fire Nova: Step 5",
            [questKeys.startedBy] = {{2995}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Tal in Thunder Bluff to travel to Moonglade."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90244] = {
            [questKeys.name] = "Fire Nova: Step 6",
            [questKeys.startedBy] = {{11832}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Keeper Remulos in Moonglade to receive Elemental Salve."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90245] = {
            [questKeys.name] = "Fire Nova: Final Step",
            [questKeys.startedBy] = {nil,{450017}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Loot the Elemental Salve and use it to receive the rune."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90246] = {
            [questKeys.name] = "Power Surge",
            [questKeys.startedBy] = {nil,{450018}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Defeat Boulderfist Ogre to receive a Ogre Lightning Rod and place it in the Soft Soil on top of the mountain. Then hit the Lightning Rod with Lightning Bolt ten times to summon Tam'kar. Defeat him to receive the rune."},
            [questKeys.requiredSpell] = -416054,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90247] = {
            [questKeys.name] = "Decoy Totem",
            [questKeys.startedBy] = {{217683}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect either 3 Cloud Serpent Fangs from any Cloud Serpent or 10 Strong Harpy Feather from any Harpy. Bring these together with a Silken Thread (e.g. bought from Jandia in Freewind Post) to the altar and create the Offering to the Wind Spirit. Then jump off the cliff to receive the rune."},
            [questKeys.requiredSpell] = -425882,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90248] = {
            [questKeys.name] = "Enlightened Judgements",
            [questKeys.startedBy] = {{217387}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {
                "Kill Humanoids in Arathi Highlands and collect Tarnished Prayer Bead I, II and III. Purify all three before combining them to the Rosary of the Light, which you bring to Brother Atticus in Stromgarde Keep.",
                "Purify Bead I: Cast Blessing of Might while in combat and defeat an enemy.",
                "Purify Bead II: Cast Divine Shield with less than 10% HP.",
                "Purify Bead III: Unleash Seal of Justice on a fleeing enemy.",
            },
            [questKeys.requiredSpell] = -426175,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90249] = {
            [questKeys.name] = "Guarded by the Light",
            [questKeys.startedBy] = {nil,{423841}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot the Dormant Holy Rune, cast Divine Intervention (anywhere) and be resurrected by another player before releasing your spirit to receive the rune."},
            [questKeys.requiredSpell] = -416035,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90250] = {
            [questKeys.name] = "Aeonas Whereabouts",
            [questKeys.startedBy] = {{3179}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Harold Riggs to find out more about Aeonas whereabouts."},
            [questKeys.preQuestSingle] = {79940},
            [questKeys.exclusiveTo] = {79945},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90251] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217412}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy an Entomology Starter Kit to receive a Bug Catching Net and a Field Guide. Then catch all three bugs listed in the Field Guide and bring them to Amaryllis Webb."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90252] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217588}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Catch a Arbor Tarantula with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90253] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Catch a Hay Weevil with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90254] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217590}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Catch a Flesh Picker with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90255] = {
            [questKeys.name] = "Invocation",
            [questKeys.startedBy] = {{2590}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Defeat Syndicate Conjuror to receive 10 Conjuror's Pendant and use Drain Soul on the Voidwalker Minions to receive a Soul of the Void. Combine both to spawn a Void Seeker and defeat it to receive the rune."},
            [questKeys.requiredSpell] = -426443,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90256] = {
            [questKeys.name] = "Shadowflame",
            [questKeys.startedBy] = {nil,{419741}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Shadow Ward and start the summoning ritual. Defeat Seductress Ceeyna to receive the rune."},
            [questKeys.requiredSpell] = -426467,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90257] = {
            [questKeys.name] = "Dance of the Wicked",
            [questKeys.startedBy] = {{217620}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Talk to the Reckless Warlock to receive Brimstone Carving. Then use Hellfire to damage yourself for a chance to receive the rune."},
            [questKeys.requiredSpell] = -416017,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90258] = {
            [questKeys.name] = "Graveyard Echo",
            [questKeys.startedBy] = {nil,{424266}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Graveyard Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90259] = {
            [questKeys.name] = "Arathi Echo",
            [questKeys.startedBy] = {nil,{424267}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Arathi Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90260] = {
            [questKeys.name] = "Theramore Echo",
            [questKeys.startedBy] = {nil,{424264}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Theramore Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90261] = {
            [questKeys.name] = "Swamp Echo",
            [questKeys.startedBy] = {nil,{424265}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Swamp Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90262] = {
            [questKeys.name] = "Pain Suppression",
            [questKeys.startedBy] = {nil,{425896}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {
                "Bring all four Echoes to the Scarlet Monastery Library. In one of the first hallways you find statues. Activate them in the following order:",
                "Warrior, Mage, Paladin and Priest."
            },
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90263] = {
            [questKeys.name] = "Pain Suppression",
            [questKeys.startedBy] = {nil,{428228}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Disarm the Dart Trap and loot the Conspicuous Cache to receive the rune."},
            [questKeys.requiredSpell] = -400096,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90264] = {
            [questKeys.name] = "Master of Subtlety",
            [questKeys.startedBy] = {{218230,218229}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {
                "Talk to Wendel Mathers and free him with a Compoud Cage Key you can pickpocket from the nearby Kurzen mobs.",
                "Afterwards talk to Captain Aransas in Booty Bay to receive the rune. Hold on to the Jani's Charm, you'll get as a bonus."
            },
            [questKeys.requiredSpell] = -425103,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90265] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217412}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy an Entomology Starter Kit to receive a Bug Catching Net and a Field Guide. Then catch all three bugs listed in the Field Guide and bring them to Amaryllis Webb."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90266] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217588}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Catch a Arbor Tarantula with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90267] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Catch a Hay Weevil with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90268] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217590}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Catch a Flesh Picker with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90269] = {
            [questKeys.name] = "Gale Winds",
            [questKeys.startedBy] = {{222286}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat Namida Grimtotem to receive the rune."},
            [questKeys.requiredSpell] = -431451,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90271] = {
            [questKeys.name] = "Raptor Fury",
            [questKeys.startedBy] = {{222243}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat Zopilote to receive the rune."},
            [questKeys.requiredSpell] = -416093,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90272] = {
            [questKeys.name] = "T.N.T",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with the Emerald Wardens, then buy the T.N.T rune from the Quartermaster."},
            [questKeys.requiredSpell] = -431611,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90273] = {
            [questKeys.name] = "Molten Armor",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with the Emerald Wardens, then buy the Molten Armor rune from the Quartermaster."},
            [questKeys.requiredSpell] = -429308,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90274] = {
            [questKeys.name] = "Improved Hammer of Wrath",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Reach Friendly with the Emerald Wardens, then buy the Improved Hammer of Wrath rune from the Quartermaster."},
            [questKeys.requiredSpell] = -429261,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90275] = {
            [questKeys.name] = "Wrath",
            [questKeys.startedBy] = {{221828,221827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Use Sense Undead, to find a Vengeful Spirit, kill it and go to Ironforge and speak with Magister Falath to receive the rune."},
            [questKeys.requiredSpell] = -429249,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90276] = {
            [questKeys.name] = "Void Zone",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with the Emerald Wardens, then buy the Void Zone rune from the Quartermaster."},
            [questKeys.requiredSpell] = -431705,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90277] = {
            [questKeys.name] = "Cut to the Chase",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with the Emerald Wardens, then buy the Cut to the Chase rune from the Quartermaster."},
            [questKeys.requiredSpell] = -432297,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
    }
end

function SeasonOfDiscovery:LoadFactionQuestFixes()
    local questKeys = QuestieDB.questKeys
    local raceIDs = QuestieDB.raceKeys

    local questFixesHorde = {
        [78124] = { -- Nar'thalas Almanac
            [questKeys.startedBy] = {nil,{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Owen Thadd in Undercity."},
        },
        [78127] = { -- The Dalaran Digest
            [questKeys.startedBy] = {nil,{409501}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Dalaran Digest, Vol. 23' and bring it to Owen Thadd in Undercity."},
        },
        [78142] = { -- Bewitchments and Glamours
            [questKeys.startedBy] = {nil,{409562}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Bewitchments and Glamours' and bring it to Owen Thadd in Undercity."},
        },
        [78143] = { -- Secrets of the Dreamers
            [questKeys.startedBy] = {nil,{409692}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Secrets of the Dreamers' located just outside the Wailing Cavern dungeon and bring it to Owen Thadd in Undercity."},
        },
        [78145] = { -- Arcanic Systems Manual
            [questKeys.startedBy] = {nil,{409700}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Arcanic Systems Manual' and bring it to Owen Thadd in Undercity."},
        },
        [78146] = { -- Goaz Scrolls
            [questKeys.startedBy] = {nil,{409717}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Goaz Scrolls' and bring it to Owen Thadd in Undercity."},
        },
        [78147] = { -- Crimes Against Anatomy
            [questKeys.startedBy] = {nil,{409735}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Crimes Against Anatomy' and bring it to Owen Thadd in Undercity."},
        },
        [78148] = { -- Runes of the Sorceror-Kings
            [questKeys.startedBy] = {nil,{409731}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Runes of the Sorcerer-Kings' and bring it to Owen Thadd in Undercity."},
        },
        [78149] = { -- Fury of the Land
            [questKeys.startedBy] = {nil,{409711}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Fury of the Land' and bring it to Owen Thadd in Undercity."},
        },
        [78150] = { -- Friend of the Library
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"You will need to hand in 10 books to receive the rune, however you can hand 1 in at any time."},
        },
        [78611] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [78612] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [78872] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79097] = { -- Baxtan: On Destructive Magics
            [questKeys.startedBy] = {nil,{407566}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Baxtan: On Destructive Magics' and bring it to Owen Thadd in Undercity."},
        },
        [79100] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79101] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79102] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79103] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79535] = { -- Basilisks: Should Petrification be Feared?
            [questKeys.startedBy] = {nil,{421526}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Basilisks: Should Petrification be Feared?' and bring it to Owen Thadd in Undercity."},
        },
        [79536] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"You will need to hand in 20 books to receive the rune, however you can hand 1 in at any time."},
        },
        [79947] = { -- Geomancy: The Stone-Cold Truth
            [questKeys.startedBy] = {nil,{423895}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Geomancy: The Stone-Cold Truth' and bring it to Owen Thadd in Undercity."},
        },
        [79948] = { -- Defensive Magics 101
            [questKeys.startedBy] = {nil,{423896}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Defensive Magics 101' and bring it to Owen Thadd in Undercity."},
        },
        [79949] = { -- A Web of Lies: Debunking Myths and Legends
            [questKeys.startedBy] = {nil,{423897}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'A Web of Lies: Debunking Myths and Legends' and bring it to Owen Thadd in Undercity."},
        },
        [79950] = { -- Demons and You
            [questKeys.startedBy] = {nil,{423898}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Demons and You' and bring it to Owen Thadd in Undercity."},
        },
        [79951] = { -- Mummies: A Guide to the Unsavory Undead
            [questKeys.startedBy] = {nil,{423899}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Mummies: A Guide to the Unsavory Undead' and bring it to Owen Thadd in Undercity."},
        },
        [79952] = { -- RwlRwlRwlRwl!
            [questKeys.startedBy] = {nil,{423900}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'RwlRwlRwlRwl!' and bring it to Owen Thadd in Undercity."},
        },
        [79953] = { -- A Ludite's Guide to Caring for Your Demonic Pet
            [questKeys.startedBy] = {nil,{423901}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'A Ludite's Guide to Caring for Your Demonic Pet' and bring it to Owen Thadd in Undercity."},
        },
        [80307] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [80308] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [80309] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [82307] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [82308] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [82309] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
    }

    local questFixesAlliance = {
        [78124] = { -- Nar'thalas Almanac
            [questKeys.startedBy] = {nil,{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Garion Wendell in Stormwind."},
        },
        [78127] = { -- The Dalaran Digest
            [questKeys.startedBy] = {nil,{409501}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'The Dalaran Digest, Vol. 23' and bring it to Garion Wendell in Stormwind."},
        },
        [78142] = { -- Bewitchments and Glamours
            [questKeys.startedBy] = {nil,{409562}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Bewitchments and Glamours' and bring it to Garion Wendell in Stormwind."},
        },
        [78143] = { -- Secrets of the Dreamers
            [questKeys.startedBy] = {nil,{409692}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Secrets of the Dreamers' located just outside the Wailing Cavern dungeon and bring it to Garion Wendell in Stormwind."},
        },
        [78145] = { -- Arcanic Systems Manual
            [questKeys.startedBy] = {nil,{409700}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Arcanic Systems Manual' and bring it to Garion Wendell in Stormwind."},
        },
        [78146] = { -- Goaz Scrolls
            [questKeys.startedBy] = {nil,{409717}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Goaz Scrolls' and bring it to Garion Wendell in Stormwind."},
        },
        [78147] = { -- Crimes Against Anatomy
            [questKeys.startedBy] = {nil,{409735}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Crimes Against Anatomy' and bring it to Garion Wendell in Stormwind."},
        },
        [78148] = { -- Runes of the Sorceror-Kings
            [questKeys.startedBy] = {nil,{409731}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Runes of the Sorcerer-Kings' and bring it to Garion Wendell in Stormwind."},
        },
        [78149] = { -- Fury of the Land
            [questKeys.startedBy] = {nil,{409711}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Fury of the Land' and bring it to Garion Wendell in Stormwind."},
        },
        [78150] = { -- Friend of the Library
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"You will need to hand in 10 books to receive the rune, however you can hand 1 in at any time."},
        },
        [78611] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [78612] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [78872] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79097] = { -- Baxtan: On Destructive Magics
            [questKeys.startedBy] = {nil,{407566}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Baxtan: On Destructive Magics' and bring it to Garion Wendell in Stormwind."},
        },
        [79100] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79101] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79102] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79103] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79535] = { -- Basilisks: Should Petrification be Feared?
            [questKeys.startedBy] = {nil,{421526}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Basilisks: Should Petrification be Feared?' and bring it to Garion Wendell in Stormwind."},
        },
        [79536] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"You will need to hand in 20 books to receive the rune, however you can hand 1 in at any time."},
        },
        [79947] = { -- Geomancy: The Stone-Cold Truth
            [questKeys.startedBy] = {nil,{423895}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Geomancy: The Stone-Cold Truth' and bring it to Garion Wendell in Stormwind."},
        },
        [79948] = { -- Defensive Magics 101
            [questKeys.startedBy] = {nil,{423896}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Defensive Magics 101' and bring it to Garion Wendell in Stormwind."},
        },
        [79949] = { -- A Web of Lies: Debunking Myths and Legends
            [questKeys.startedBy] = {nil,{423897}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'A Web of Lies: Debunking Myths and Legends' and bring it to Garion Wendell in Stormwind."},
        },
        [79950] = { -- Demons and You
            [questKeys.startedBy] = {nil,{423898}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Demons and You' and bring it to Garion Wendell in Stormwind."},
        },
        [79951] = { -- Mummies: A Guide to the Unsavory Undead
            [questKeys.startedBy] = {nil,{423899}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Mummies: A Guide to the Unsavory Undead' and bring it to Garion Wendell in Stormwind."},
        },
        [79952] = { -- RwlRwlRwlRwl!
            [questKeys.startedBy] = {nil,{423900}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'RwlRwlRwlRwl!' and bring it to Garion Wendell in Stormwind."},
        },
        [79953] = { -- A Ludite's Guide to Caring for Your Demonic Pet
            [questKeys.startedBy] = {nil,{423901}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'A Ludite's Guide to Caring for Your Demonic Pet' and bring it to Garion Wendell in Stormwind."},
        },
        [80307] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [80308] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [80309] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [82307] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [82308] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [82309] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return questFixesHorde
    else
        return questFixesAlliance
    end
end
