---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local nameplateOptionsLocales = {
    ["Nameplates"] = {
        ["ptBR"] = "Nome da placa",
        ["ruRU"] = "Индикаторы здоровья",
        ["deDE"] = "Namensplaketten",
        ["koKR"] = "이름표",
        ["esMX"] = "Placas de nombre",
        ["enUS"] = true,
        ["zhCN"] = "姓名板",
        ["zhTW"] = "名條",
        ["esES"] = "Placas de nombre",
        ["frFR"] = "Barres de vie",
    },
    ["Nameplate Icon Options"] = {
        ["ptBR"] = "Opções do ícone nomes da placa",
        ["ruRU"] = "Настройки индикаторов здоровья",
        ["deDE"] = "Namensplaketten-Icon-Einstellungen",
        ["koKR"] = "이름표 아이콘 설정",
        ["esMX"] = "Opciones de icono de placas de nombre",
        ["enUS"] = true,
        ["zhCN"] = "姓名板图标选项",
        ["zhTW"] = "名條圖示選項",
        ["esES"] = "Opciones de icono de placas de nombre",
        ["frFR"] = "Options des icônes sur les barres de vie flottantes",
    },
    ["Enable Nameplate Quest Objectives"] = {
        ["ptBR"] = "Ativar objetivos da missão nomes da placa",
        ["ruRU"] = "Значки заданий на индикаторах здоровья",
        ["deDE"] = "Zeige Questziele an Namensplaketten",
        ["koKR"] = "퀘스트 목표 이름표에 아이콘 표시",
        ["esMX"] = "Habilitar objetivos de misión en placas de nombre",
        ["enUS"] = true,
        ["zhCN"] = "启用姓名板标记",
        ["zhTW"] = "啟用任務怪名條圖示",
        ["esES"] = "Habilitar objetivos de misión en placas de nombre",
        ["frFR"] = "Afficher les icônes sur les barres de vie flottantes",
    },
    ["Enable or disable the quest objective icons over creature nameplates."] = {
        ["ptBR"] = "Ativar ou desativar os ícones dos objectivos de missão nas placas de identificação das criaturas.",
        ["ruRU"] = "Показать/скрыть значки целей заданий на индикаторах здоровья",
        ["deDE"] = "Aktiviert/Deaktiviert die Questziele an den Namensplaketten der Kreaturen.",
        ["koKR"] = "퀘스트 목표 이름표에 아이콘을 표시할지 설정합니다.",
        ["esMX"] = "Habilita o deshabilita el icono de objetivo de misión en la placa de nombre de la criatura.",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用姓名板上的任务目标图标",
        ["zhTW"] = "啟用或停用在怪物的名條上顯示任務目標圖示。",
        ["esES"] = "Habilita o deshabilita el icono de objetivo de misión en la placa de nombre de la criatura.",
        ["frFR"] = "Active l'affichage des icônes d'objectif de quête sur les barres de vie flottantes des monstres.",
    },
    ["Icon Position X"] = {
        ["ptBR"] = "Posição do ícone X",
        ["ruRU"] = "Позиция по оси X",
        ["deDE"] = "Icon-Position X",
        ["koKR"] = "아이콘 위치 X",
        ["esMX"] = "Posición del icono X",
        ["enUS"] = true,
        ["zhCN"] = "图标X座标",
        ["zhTW"] = "圖示水平位置",
        ["esES"] = "Posición del icono X",
        ["frFR"] = "Décalage horizontal",
    },
    ["Where on the X axis the nameplate icon should be. ( Default: %s )"] = {
        ["ptBR"] = "O ícone do nome da placa deve aparecer no ícone dos nomes da placa. (Por defeito: %s)",
        ["ruRU"] = "Регулировка позиции значков по оси X (по умолчанию: %s)",
        ["deDE"] = "An welcher Stelle auf der X-Achse des anvisierten Ziels die Icons der Questziele angezeigt werden sollen. ( Standard: %s )",
        ["koKR"] = "대상 프레임에 표시할 아이콘의 X좌표를 설정합니다. ( 기본값: %s )",
        ["esMX"] = "La posicion del eje X del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["enUS"] = true,
        ["zhCN"] = "图标锚点于目标头像的X座标（默认：%s）",
        ["zhTW"] = "名條圖示的水平方向位置。(預設值: %s )",
        ["esES"] = "La posicion del eje X del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["frFR"] = "Définis le décalage horizontal des icônes sur la barre de vie de la cible. (Par défaut : %s)",
    },
    ["Icon Position Y"] = {
        ["ptBR"] = "Posição do ícone Y",
        ["ruRU"] = "Позиция по оси Y",
        ["deDE"] = "Icon-Position Y",
        ["koKR"] = "아이콘 위치 Y",
        ["esMX"] = "Posición del icono Y",
        ["enUS"] = true,
        ["zhCN"] = "图标Y座标",
        ["zhTW"] = "圖示垂直位置",
        ["esES"] = "Posición del icono Y",
        ["frFR"] = "Décalage vertical",
    },
    ["Where on the Y axis the nameplate icon should be. ( Default: %s )"] = {
        ["ptBR"] = "O ícone do nome da placa deve aparecer no ícone de ordenadas. (Por defeito: %s)",
        ["ruRU"] = "Регулировка позиции значков по оси Y (по умолчанию: %s)",
        ["deDE"] = "An welcher Stelle auf der Y-Achse des anvisierten Ziels die Icons der Questziele angezeigt werden sollen. ( Standard: %s )",
        ["koKR"] = "대상 프레임에 표시할 아이콘의 Y좌표를 설정합니다. ( 기본값: %s )",
        ["esMX"] = "La posicion del eje Y del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["enUS"] = true,
        ["zhCN"] = "图标锚点于目标头像的Y座标（默认：%s）",
        ["zhTW"] = "名條圖示的垂直方向位置。(預設值: %s )",
        ["esES"] = "La posicion del eje Y del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["frFR"] = "Définis le décalage vertical des icônes sur la barre de vie de la cible. (Par défaut : %s)",
    },
    ["Nameplate Icon Scale"] = {
        ["ptBR"] = "Escala dos ícones da placa de identificação",
        ["ruRU"] = "Размер значков",
        ["deDE"] = "Skalierung der Namensplaketten-Icons",
        ["koKR"] = "이름표 아이콘 크기",
        ["esMX"] = "Escala del icono de la placa de nombre",
        ["enUS"] = true,
        ["zhCN"] = "图标大小",
        ["zhTW"] = "名條圖示縮放大小",
        ["esES"] = "Escala del icono de la placa de nombre",
        ["frFR"] = "Échelle des icônes sur les barres de vie flottantes",
    },
    ["Scale the size of the quest icons on creature nameplates. ( Default: %s )"] = {
        ["ptBR"] = "Mude o tamanho dos ícones da missão nas placas de identificação das criaturas por defeito.",
        ["ruRU"] = "Регулировка размера значков на индикаторах здоровья (по умолчанию: %s)",
        ["deDE"] = "Skaliert wie groß die Quest-Icons an den Namensplaketten der Gegner sein sollen. ( Standard: %s )",
        ["koKR"] = "퀘스트 목표 이름표에 표시할 아이콘의 크기를 설정합니다. ( 기본값: %s )",
        ["esMX"] = "Escala el tamaño del icono de misión en la placa de nombre de la criatura. (Predeterminado: %s)",
        ["enUS"] = true,
        ["zhCN"] = "调整姓名板图标的缩放（默认：%s）",
        ["zhTW"] = "怪物名條上任務圖示的縮放大小。(預設值: %s )",
        ["esES"] = "Escala el tamaño del icono de misión en la placa de nombre de la criatura. (Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes d'objectif de quête sur les barres de vie flottantes des monstres. (Par défaut : %s)",
    },
    ["Reset Nameplates"] = {
        ["ptBR"] = "Redefinir os nomes das placas",
        ["ruRU"] = "Сброс настроек",
        ["deDE"] = "Namensplaketten zurücksetzen",
        ["koKR"] = "이름표 초기화",
        ["esMX"] = "Restablecer placas de nombre",
        ["enUS"] = true,
        ["zhCN"] = "重设",
        ["zhTW"] = "重置名條",
        ["esES"] = "Restablecer placas de nombre",
        ["frFR"] = "Réinitialisation",
    },
    ["Reset to default nameplate position and scale."] = {
        ["ptBR"] = "Redefinir as posições e a escala da placa de identificação",
        ["ruRU"] = "Сбросить настройки значков целей заданий на индикаторах здоровья к значениям по умолчанию",
        ["deDE"] = "Setzt die Position und Skalierung der Namensplaketten auf die Standardeinstellungen zurück.",
        ["koKR"] = "이름표 아이콘 위치와 크기를 기본값으로 초기화합니다.",
        ["esMX"] = "Restablece a valores predeterminados el tamaño y la posición de la placa de nombre",
        ["enUS"] = true,
        ["zhCN"] = "重设姓名板图标的位置和大小",
        ["zhTW"] = "重置成預設的名條位置和縮放大小。",
        ["esES"] = "Restablece a valores predeterminados el tamaño y la posición de la placa de nombre",
        ["frFR"] = "Réinitialise les positions et l'échelle des icônes sur les barres de vie flottantes à leurs valeurs par défaut.",
    },
    ["Target Frame Icon Options"] = {
        ["ptBR"] = "Opções de ícone do quadro de destino",
        ["ruRU"] = "Настройки рамки цели",
        ["deDE"] = "Ziel-Icon-Einstellungen",
        ["koKR"] = "대상 프레임 아이콘 설정",
        ["esMX"] = "Opciones del marco de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "目标图标选项",
        ["zhTW"] = "目標頭像圖示選項",
        ["esES"] = "Opciones del marco de objetivo",
        ["frFR"] = "Options des icônes de la barre de vie de la cible",
    },
    ["Enable Target Frame Quest Objectives"] = {
        ["ptBR"] = "Ativar os objectivos da missão do quadro de destino",
        ["ruRU"] = "Значки заданий на рамке цели",
        ["deDE"] = "Zeige Questziele am anvisierten Ziel",
        ["koKR"] = "퀘스트 목표 대상 프레임에 아이콘 표시",
        ["esMX"] = "Habilitar objetivo de misión en el marco de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "启用目标标记",
        ["zhTW"] = "啟用任務怪目標頭像圖示",
        ["esES"] = "Habilitar objetivo de misión en el marco de objetivo",
        ["frFR"] = "Activer les icônes d'objectif de quête sur la barre de vie de la cible",
    },
    ["Enable or disable the quest objective icons over creature target frame."] = {
        ["ptBR"] = "Ativar ou desativar os ícones do objectivo da missão no quadro de destino da criatura.",
        ["ruRU"] = "Показать/скрыть значки целей заданий на рамке выбранной цели",
        ["deDE"] = "Aktiviert/Deaktiviert die Anzeige der Questziele am anvisierten Ziel.",
        ["koKR"] = "퀘스트 목표 대상 프레임에 아이콘을 표시할지 설장합니다.",
        ["esMX"] = "Habilita o deshabilita los iconos de objetico de mision en el marco de objetivo.",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用目标头像上的任务目标图标",
        ["zhTW"] = "啟用或停用在目標怪物的頭像框架上顯示任務目標圖示。",
        ["esES"] = "Habilita o deshabilita los iconos de objetico de mision en el marco de objetivo.",
        ["frFR"] = "Active l'affichage des icônes d'objectif de quête sur la barre de vie de la cible.",
    },
    ["Reset Target Frame"] = {
        ["ptBR"] = "Redefinir o quadro de destino",
        ["ruRU"] = "Сброс настроек",
        ["deDE"] = "Zielanzeige zurücksetzen",
        ["koKR"] = "대상 프레임 초기화",
        ["esMX"] = "Restablecer marco de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "重设",
        ["zhTW"] = "重置目標頭像",
        ["esES"] = "Restablecer marco de objetivo",
        ["frFR"] = "Réinitialisation",
    },
    ["Reset to default target frame position and scale."] = {
        ["ptBR"] = "Redefinir as posições e a escala do quadro de destino por defeito",
        ["ruRU"] = "Сбросить настройки значков целей заданий на рамке выбранной цели к значениям по умолчанию",
        ["deDE"] = "Setzt die Position und Skalierung der Icons am anvisierten Ziel zurück.",
        ["koKR"] = "대상 프레임 아이콘 위치와 크기를 기본값으로 초기화합니다.",
        ["esMX"] = "Restablece a valores predeterminados el tamaño y la posición del marco de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "重设目标图标的位置和大小",
        ["zhTW"] = "重置成預設的目標頭像框架位置和縮放大小。",
        ["esES"] = "Restablece a valores predeterminados el tamaño y la posición del marco de objetivo",
        ["frFR"] = "Réinitialise les positions et l'échelle des icônes sur la barre de vie de la cible à leurs valeurs par défaut.",
    },
}

for k, v in pairs(nameplateOptionsLocales) do
    l10n.translations[k] = v
end
