---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local questStateLocales = {
    ["Complete"] = {
        ["ptBR"] = "Sucesso",
        ["ruRU"] = "Выполнено",
        ["deDE"] = "Abgeschlossen",
        ["koKR"] = "성공",
        ["esMX"] = "Completo",
        ["enUS"] = true,
        ["zhCN"] = "完成",
        ["zhTW"] = "完成",
        ["esES"] = "Completo",
        ["frFR"] = "Terminée",
    },
    ["Failed"] = {
        ["ptBR"] = "Fracassada",
        ["ruRU"] = "Провалено",
        ["deDE"] = "Fehlgeschlagen",
        ["koKR"] = "실패",
        ["esMX"] = "Fracasado",
        ["enUS"] = true,
        ["zhCN"] = "失败",
        ["zhTW"] = "失敗",
        ["esES"] = "Fracasado",
        ["frFR"] = "Échouée",
    },
    ["Available"] = {
        ["ptBR"] = "Disponível",
        ["ruRU"] = "Доступно",
        ["deDE"] = "Verfügbar",
        ["koKR"] = "수행가능",
        ["esMX"] = "Disponible",
        ["enUS"] = true,
        ["zhCN"] = "可接",
        ["zhTW"] = "可接",
        ["esES"] = "Disponible",
        ["frFR"] = "Disponible",
    },
    ["Active"] = {
        ["ptBR"] = "Ativo",
        ["ruRU"] = "Активно",
        ["deDE"] = "Aktiv",
        ["koKR"] = "활성화",
        ["esMX"] = "Activo",
        ["enUS"] = true,
        ["zhCN"] = "已有",
        ["zhTW"] = "已有",
        ["esES"] = "Activo",
        ["frFR"] = "Activée",
    },
    ["Event"] = {
        ["ptBR"] = "Evento",
        ["ruRU"] = "Игровое событие",
        ["deDE"] = "Event",
        ["koKR"] = "이벤트",
        ["esMX"] = "Evento",
        ["enUS"] = true,
        ["zhCN"] = "事件",
        ["zhTW"] = "節慶",
        ["esES"] = "Evento",
        ["frFR"] = "Évènement",
    },
    ["Repeatable"] = {
        ["ptBR"] = "Repetível",
        ["ruRU"] = "Повторяемое",
        ["deDE"] = "Wiederholbar",
        ["koKR"] = "반복가능",
        ["esMX"] = "Repetible",
        ["enUS"] = true,
        ["zhCN"] = "可重复",
        ["zhTW"] = "可重覆",
        ["esES"] = "Repetible",
        ["frFR"] = "Répétable",
    },
    ["PvP"] = {
        ["ptBR"] = "JxJ",
        ["ruRU"] = true,
        ["deDE"] = true,
        ["koKR"] = "전쟁",
        ["esMX"] = "JcJ",
        ["enUS"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
        ["esES"] = "JcJ",
        ["frFR"] = "JcJ",
    },
    ["Rune"] = {
        ["ptBR"] = "Runa",
        ["ruRU"] = "Руна",
        ["deDE"] = true,
        ["koKR"] = "룬",
        ["esMX"] = "Runa",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "符文",
        ["esES"] = "Runa",
        ["frFR"] = true,
    },
}

for k, v in pairs(questStateLocales) do
    l10n.translations[k] = v
end
