---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")

--- Load the base quests for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit a quest, do so in sodQuestFixes.lua
function SeasonOfDiscovery:LoadBaseQuests()
    local questKeys = QuestieDB.questKeys
    local raceIDs = QuestieDB.raceKeys
    local classIDs = QuestieDB.classKeys

    return {
        [76156] = {
            [questKeys.name] = "Stalk With The Earthmother",
            [questKeys.startedBy] = {{205729}},
            [questKeys.finishedBy] = {{205729}},
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Sneak into the Venture Company mine southeast of Thunder Bluff and collect 5 Seaforium Mining Charges from carts of blasting supplies, then return them to Boarton Shadetotem in Thunder Bluff."},
            [questKeys.objectives] = {nil,nil,{{206157}}},
        },
        [76160] = {
            [questKeys.name] = "Stalk With The Earthmother",
            [questKeys.startedBy] = {{205729}},
            [questKeys.finishedBy] = {{205729}},
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Gather 8 Windfury Cones north of Thunder Bluff, use them with the Mortar and Pestle, then return to Boarton Shadetotem in Thunder Bluff with the result."},
            [questKeys.objectives] = {nil,nil,{{206175},{206176}}},
        },
        [76240] = {
            [questKeys.name] = "Stalk With The Earthmother",
            [questKeys.startedBy] = {{205729}},
            [questKeys.finishedBy] = {{205729}},
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Buy or catch a Raw Brilliant Smallfish, then use the Knife Set to fillet it in front of Boarton Shadetotem in Thunder Bluff."},
            [questKeys.objectives] = {nil,nil,{{206345},{206344}}},
        },
        [77568] = {
            [questKeys.name] = "A Hunter's Strength",
            [questKeys.startedBy] = {{3596}},
            [questKeys.finishedBy] = {{3596}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat Githyiss the Vile in Shadowthread Cave and recover the lost rune. Learn the rune, then report back to Ayanna Everstride in Shadowglen."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77571] = {
            [questKeys.name] = "Relics of the Kaldorei",
            [questKeys.startedBy] = {{3597}},
            [questKeys.finishedBy] = {{3597}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Recover the relic from the grellkin in Shadowglen. Follow the relic's guidance to learn a new ability, then report back to Mardant Strongoak."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410061}}},
        },
        [77573] = {
            [questKeys.name] = "Second-Story Work",
            [questKeys.startedBy] = {{3594}},
            [questKeys.finishedBy] = {{3594}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Retrieve the rune from the hidden idol, then use it to learn a new ability. Afterwards, return to Frahun Shadewhisper."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77574] = {
            [questKeys.name] = "Meditation on Elune",
            [questKeys.startedBy] = {{3595}},
            [questKeys.finishedBy] = {{3595}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel at the moonwell to meditate on Elune, then use the memory to learn a new ability. Afterwards, return to Shanda in Shadowglen."},
            [questKeys.objectives] = {nil,nil,{{205951}}},
        },
        [77575] = {
            [questKeys.name] = "Amidst the Shadowed Webs",
            [questKeys.startedBy] = {{3593}},
            [questKeys.finishedBy] = {{3593}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Slay webwood spiders in Shadowthread Cave and recover the lost rune. Learn the rune, then report back to Alyissia in Shadowglen."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77582] = {
            [questKeys.name] = "A Trial of Fitness",
            [questKeys.startedBy] = {{3153}},
            [questKeys.finishedBy] = {{3153}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs behind Frang. Learn the rune inside, then report back to Frang in the Valley of Trials."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77583] = {
            [questKeys.name] = "Atop the Cliffs",
            [questKeys.startedBy] = {{3155}},
            [questKeys.finishedBy] = {{3155}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs surrounding the Valley of Trials. Learn the rune inside, then report back to Rwag in The Den."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77584] = {
            [questKeys.name] = "Hunt for the Rune",
            [questKeys.startedBy] = {{3154}},
            [questKeys.finishedBy] = {{3154}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the lost rune by slaying scorpids in the Valley of Trials. Learn the rune's power, then report back to Jen'sahn."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77585] = {
            [questKeys.name] = "Icons of Power",
            [questKeys.startedBy] = {{3157}},
            [questKeys.finishedBy] = {{3157}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the stolen icon by slaying scorpids in the Valley of Trials. Learn its power, then report back to Shikrik."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410094}}},
        },
        [77586] = {
            [questKeys.name] = "Stolen Power",
            [questKeys.startedBy] = {{3156}},
            [questKeys.finishedBy] = {{3156}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Find the stolen rune inside of the Burning Blade Coven. Learn its power, then report back to Nartok in The Den."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403919}}},
        },
        [77587] = {
            [questKeys.name] = "Icons of Power",
            [questKeys.startedBy] = {{3157}},
            [questKeys.finishedBy] = {{3157}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the stolen icon by slaying scorpids in the Valley of Trials. Learn its power, then report back to Shikrik."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410094}}},
        },
        [77588] = {
            [questKeys.name] = "A Trial of Fitness",
            [questKeys.startedBy] = {{3153}},
            [questKeys.finishedBy] = {{3153}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs behind Frang. Learn the rune inside, then report back to Frang in the Valley of Trials."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77590] = {
            [questKeys.name] = "Rugged Terrain",
            [questKeys.startedBy] = {{3154}},
            [questKeys.finishedBy] = {{3154}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the lost rune by slaying scorpids in the Valley of Trials. Learn the rune's power, then report back to Jen'sahn."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77592] = {
            [questKeys.name] = "Atop the Cliffs",
            [questKeys.startedBy] = {{3155}},
            [questKeys.finishedBy] = {{3155}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs surrounding the Valley of Trials. Learn the rune inside, then report back to Rwag in The Den."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77616] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{911}},
            [questKeys.finishedBy] = {{911}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the lost rune within Echo Ridge Mine and use it to learn a new ability, then report back to Llane Beshere in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77617] = {
            [questKeys.name] = "Relics of the Light",
            [questKeys.startedBy] = {{925}},
            [questKeys.finishedBy] = {{925}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Recover the libram and follow its guidance to learn a new ability, then return to Brother Sammuel in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410002}}},
        },
        [77618] = {
            [questKeys.name] = "Thrice Stolen",
            [questKeys.startedBy] = {{915}},
            [questKeys.finishedBy] = {{915}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Recover the lost rune from the Defias camps and use it to learn a new ability, then return to Jorik Kerridan in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77619] = {
            [questKeys.name] = "Meditation on the Light",
            [questKeys.startedBy] = {{375}},
            [questKeys.finishedBy] = {{375}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Slay kobolds in Echo Ridge Mine to receive a memory. Kneel within Northshire Abbey to meditate on the light, then use the memory to learn a new ability. Afterwards, return to Priestess Anetta."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{402862}}},
        },
        [77620] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{198}},
            [questKeys.finishedBy] = {{198}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Recover research notes from the Defias bandits and use them to learn a new spell, then return to Khelden Bremen in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77621] = {
            [questKeys.name] = "Stolen Power",
            [questKeys.startedBy] = {{459}},
            [questKeys.finishedBy] = {{459}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Recover the rune from the Defias camps to the east and use it to learn a new ability, then return to Drusilla La Salle in Northshire."},
            [questKeys.objectives] = nil,
        },
        [77642] = {
            [questKeys.name] = "Wisdom of the Loa",
            [questKeys.startedBy] = {{3707}},
            [questKeys.finishedBy] = {{3707}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel at the Loa Altar in Sen'jin Village. Commune with the Loa spirit, then use the memory to learn a new ability. Afterwards, return to Ken'jai  in the Valley of Trails."},
            [questKeys.objectives] = {nil,nil,{{205951}}},
        },
        [77643] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{5884}},
            [questKeys.finishedBy] = {{5884}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Find the stolen spell notes inside the Burning Blade Coven, then use them to learn a new ability. Afterwards, return to Mai'ah in the Valley of Trails."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77648] = {
            [questKeys.name] = "Relics of the Tauren",
            [questKeys.startedBy] = {{3060}},
            [questKeys.finishedBy] = {{3060}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Recover the stolen relic from Brambleblade Ravine. Follow the relic's guidance to learn a new ability, then report back to Gart Mistrunner in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410061}}},
        },
        [77649] = {
            [questKeys.name] = "A Hunter's Strength",
            [questKeys.startedBy] = {{3061}},
            [questKeys.finishedBy] = {{3061}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the missing rune by slaying Bristleback Battleboars in Brambleblade Ravine. Use the rune to learn a new ability, then report back to Lanka Farshot in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77651] = {
            [questKeys.name] = "Into the Brambles",
            [questKeys.startedBy] = {{3059}},
            [questKeys.finishedBy] = {{3059}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Recover the lost rune from Brambleblade Ravine. Use the rune to learn a new ability, then report back to Harutt Thunderhorn in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77652] = {
            [questKeys.name] = "Icons of Power",
            [questKeys.startedBy] = {{3062}},
            [questKeys.finishedBy] = {{3062}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Recover the lost icon from the Bristleback Shamans in Brambleblade Ravine. Learn its power, then report back to Harutt Thunderhorn in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410094}}},
        },
        [77655] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{912}},
            [questKeys.finishedBy] = {{912}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the lost rune carried by a  Frostmane troll in Coldridge Valley. Use it to learn a new ability, then report back to Thran Khorman in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77656] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{912}},
            [questKeys.finishedBy] = {{912}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the lost rune carried by a Frostmane troll in Coldridge Valley. Use it to learn a new ability, then report back to Thran Khorman in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77657] = {
            [questKeys.name] = "Relics of the Light",
            [questKeys.startedBy] = {{926}},
            [questKeys.finishedBy] = {{926}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Recover the stolen libram carried by a Frostmane troll in Coldridge Valley. Follow its guidance to learn a new ability, then return to Bromos Grummner in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410002}}},
        },
        [77658] = {
            [questKeys.name] = "Thrice Stolen",
            [questKeys.startedBy] = {{916}},
            [questKeys.finishedBy] = {{916}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Recover the stolen rune from the cave of Frostmane trolls in Coldridge Valley. Use it to learn a new ability, then return to Solm Hargrin in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77659] = {
            [questKeys.name] = "Thrice Stolen",
            [questKeys.startedBy] = {{916}},
            [questKeys.finishedBy] = {{916}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Recover the stolen rune from the cave of Frostmane trolls in Coldridge Valley. Use it to learn a new ability, then return to Solm Hargrin in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77660] = {
            [questKeys.name] = "Trek Through the Caves",
            [questKeys.startedBy] = {{895}},
            [questKeys.finishedBy] = {{895}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Recover the stolen rune from the cave of Frostmane trolls in Coldridge Valley. Use the rune to learn a new ability, then report back to Thorgas Grimson in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77661] = {
            [questKeys.name] = "Meditation on the Light",
            [questKeys.startedBy] = {{837}},
            [questKeys.finishedBy] = {{837}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find a memory of the past inside of a chest at the trogg camp near Anvilmar. Then, kneel at the Altar of the Light within Anvilmar to meditate on the light, and use the memory to learn a new ability. Afterwards, speak to Branstock Khalder."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{402862}}},
        },
        [77666] = {
            [questKeys.name] = "Stolen Power",
            [questKeys.startedBy] = {{460}},
            [questKeys.finishedBy] = {{460}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Recover the rune from the group of Troggs, southwest of Anvilmar, and use it to learn a new ability. Then, return to Alamar Grimm in Anvilmar."},
            [questKeys.objectives] = nil,
        },
        [77667] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{944}},
            [questKeys.finishedBy] = {{944}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Find the stolen spell notes at the trogg camp to the southwest of Anvilmar, then use them to learn a new ability. Afterwards, return to Marryk Nurribit in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77668] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{2119}},
            [questKeys.finishedBy] = {{2119}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the rune hidden in Night Web's Hollow and use it to learn a new technique, then report back to Dannal Stern in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77669] = {
            [questKeys.name] = "The Scarlet Rune",
            [questKeys.startedBy] = {{2122}},
            [questKeys.finishedBy] = {{2122}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket or kill Scarlet Converts to find a rune, then use it to learn a new ability. Afterwards, return to David Trias in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77670] = {
            [questKeys.name] = "Meditation on Undeath",
            [questKeys.startedBy] = {{2123}},
            [questKeys.finishedBy] = {{2123}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel in the graveyard to meditate on undeath, then use the rune to learn a new ability. Afterwards, return to Dark Cleric Duesten in the Deathknell chapel."},
            [questKeys.objectives] = {nil,nil,{{205951}}},
        },
        [77671] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{2124}},
            [questKeys.finishedBy] = {{2124}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Scarlet Initiates to find spell notes and use them to learn a new ability, then return to Isabella in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77672] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{2126}},
            [questKeys.finishedBy] = {{2126}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Recover the rune from Night Web's Hollow and use it to learn a new ability, then return to Maximillion in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403919}}},
        },
        [78088] = {
            [questKeys.name] = "A Strange Artifact",
            [questKeys.startedBy] = {{3663}},
            [questKeys.finishedBy] = {{3663}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Did you find something in the tower?"},
            [questKeys.objectives] = {nil,nil,{{209836}}},
        },
        [78089] = {
            [questKeys.name] = "Advice From Stormwind",
            [questKeys.startedBy] = {{3663}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Consult the paladins of Stormwind for advice on the orb."},
            [questKeys.objectives] = nil,
        },
        [78090] = {
            [questKeys.name] = "A Second Opinion",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{5495}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find the warlock sanctum within Stormwind and seek advice on the orb."},
            [questKeys.objectives] = nil,
        },
        [78091] = {
            [questKeys.name] = "Earning Your Salt",
            [questKeys.startedBy] = {{5495}},
            [questKeys.finishedBy] = {{5495}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Collect 14 Summoner's Salt from Blackrock Summoners in Redridge Mountains, then return to Ursula Deline in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{209778}}},
        },
        [78092] = {
            [questKeys.name] = "It Must Be Destroyed",
            [questKeys.startedBy] = {{5495}},
            [questKeys.finishedBy] = {nil,{409311}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find a way to destroy the orb."},
            [questKeys.objectives] = {nil,nil,{{209779}}},
        },
        [78093] = {
            [questKeys.name] = "Return to Delgren",
            [questKeys.startedBy] = {nil,{409315}},
            [questKeys.finishedBy] = {{3663}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Return the Orb Shards to Delgren."},
            [questKeys.objectives] = nil,
        },
        [78114] = {
            [questKeys.name] = "Wild Wyvern Wrangling",
            [questKeys.startedBy] = {{210845}},
            [questKeys.finishedBy] = {{210845}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring a Hypnotic Crystal and a Gnarled Wand of Wild Magic to Jixo Madrocket in the Stonetalon Mountains."},
            [questKeys.objectives] = {nil,nil,{{209838},{209840}}},
        },
        [78121] = {
            [questKeys.name] = "Wrangling a Wild Wyvern",
            [questKeys.startedBy] = {{210845}},
            [questKeys.finishedBy] = {{210845}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Follow Jixo Madrocket, and watch him tame a Wyvern."},
            [questKeys.objectives] = nil,
        },
        [78124] = {
            [questKeys.name] = "Nar'thalas Almanac",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209843}}},
        },
        [78127] = {
            [questKeys.name] = "The Dalaran Digest",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209844}}},
        },
        [78132] = {
            [questKeys.name] = "Dragonslayer's Helm",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The helm of the Dragonslayer once belonged to a great commander who fell in battle. It is said his tormented soul still haunts the site of his passing."},
            [questKeys.objectives] = {nil,nil,{{209872}}},
        },
        [78133] = {
            [questKeys.name] = "Dragonslayer's Shield",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The shield of the Dragonslayer is rumored to be held by an Orcish warlord. He stole it while raiding a human settlement."},
            [questKeys.objectives] = {nil,nil,{{209873}}},
        },
        [78134] = {
            [questKeys.name] = "Dragonslayer's Lance",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The lance of the Dragonslayer has changed hands many times. Every now and then, rumor spreads of it appearing in black market arms deals. Perhaps the lance's current unsavory proprietor would be willing to part with it; for a price."},
            [questKeys.objectives] = {nil,nil,{{209874}}},
        },
        [78142] = {
            [questKeys.name] = "Bewitchments and Glamours",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209845}}},
        },
        [78143] = {
            [questKeys.name] = "Secrets of the Dreamers",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209846}}},
        },
        [78144] = {
            [questKeys.name] = "Alonso the Dragonslayer",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Accompany Alonso to slay the dragon."},
            [questKeys.objectives] = nil,
        },
        [78145] = {
            [questKeys.name] = "Arcanic Systems Manual",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209847}}},
        },
        [78146] = {
            [questKeys.name] = "Goaz Scrolls",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209848}}},
        },
        [78147] = {
            [questKeys.name] = "Crimes Against Anatomy",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209849}}},
        },
        [78148] = {
            [questKeys.name] = "Runes of the Sorceror-Kings",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209850}}},
        },
        [78149] = {
            [questKeys.name] = "Fury of the Land",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209851}}},
        },
        [78150] = {
            [questKeys.name] = "Friend of the Library",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [78192] = {
            [questKeys.name] = "Secrets of the Light",
            [questKeys.startedBy] = {{211188}},
            [questKeys.finishedBy] = {{211188}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill 7 Forsaken Herbalists and 9 Forsaken Seekers in northwest Ashenvale, then return to Maethra Slagheart in Darnassus."},
            [questKeys.objectives] = {{{3733},{3732}}},
        },
        [78193] = {
            [questKeys.name] = "Secrets of the Light",
            [questKeys.startedBy] = {{211188}},
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to Stormwind City and speak to High Priestess Laurena in the Cathedral of Light."},
            [questKeys.objectives] = nil,
        },
        [78194] = {
            [questKeys.name] = "Secrets of Elune",
            [questKeys.startedBy] = {{11397}},
            [questKeys.finishedBy] = {{11397}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect 10 Dire Wolf Paws from wolves in Duskwood."},
            [questKeys.objectives] = {nil,nil,{{210053}}},
        },
        [78195] = {
            [questKeys.name] = "Secrets of Elune",
            [questKeys.startedBy] = {{11397}},
            [questKeys.finishedBy] = {{211298}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Bring the phial to Syrnoya at the Auberdine moonwell."},
            [questKeys.objectives] = nil,
        },
        [78196] = {
            [questKeys.name] = "Secrets of Undeath",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect 12 Shadeleaf from Shadethicket elementals in Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{210045}}},
        },
        [78197] = {
            [questKeys.name] = "Secrets of Undeath",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{6491}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to Brill's graveyard in Tirisfal Glades and use the Tincture of Waking Death."},
            [questKeys.objectives] = nil,
        },
        [78198] = {
            [questKeys.name] = "Secrets of the Loa",
            [questKeys.startedBy] = {{211225}},
            [questKeys.finishedBy] = {{211225}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect 14 Hillsbrad Human Bones from humans in Hillsbrad Foothills, then return to Baj'ura in Undercity."},
            [questKeys.objectives] = {nil,nil,{{210055}}},
        },
        [78199] = {
            [questKeys.name] = "Secrets of the Loa",
            [questKeys.startedBy] = {{211225}},
            [questKeys.finishedBy] = {nil,{410168}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to the Echo Isles and use the offering at Bwonsamdi's shrine."},
            [questKeys.objectives] = nil,
        },
        [78229] = {
            [questKeys.name] = "Trial of The Owls",
            [questKeys.startedBy] = {{12042}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Bring symbols of the three owls to Loganaar in Moonglade."},
            [questKeys.objectives] = {nil,nil,{{210044},{210043},{210026}}},
        },
        [78261] = {
            [questKeys.name] = "The Horn of Xelthos",
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Horn of Xelthos inside of Shadowfang Keep. Then, return it to C's dead drop near Pyrewood Village. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{210183}}},
        },
        [78265] = {
            [questKeys.name] = "Fish Oil",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'm going to need fish oil - and a lot of it!"},
            [questKeys.objectives] = {nil,nil,{{17058}}},
        },
        [78266] = {
            [questKeys.name] = "Dark Iron Ordinance",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'll need some Dark Iron Ordinance. Where are you going to find Dark Iron dwarves? That's your problem!"},
            [questKeys.objectives] = {nil,nil,{{210138}}},
        },
        [78267] = {
            [questKeys.name] = "Shredder Turbochargers",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'll need some of the Venture Company's Shredder Turbochargers. They're tightly coupled to the shredder systems, so you'll need special equipment to salvage them.No, I don't have that equipment."},
            [questKeys.objectives] = {nil,nil,{{210146}}},
        },
        [78270] = {
            [questKeys.name] = "Goblin Lockpicks",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4086}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Horn of Xelthos inside of Shadowfang Keep. Then, return it to C's dead drop near Pyrewood Village."},
            [questKeys.objectives] = {nil,nil,{{210187}}},
        },
        [78277] = {
            [questKeys.name] = "A Token of Gratitude",
            [questKeys.startedBy] = {{1498}},
            [questKeys.finishedBy] = {{1498}},
            [questKeys.requiredLevel] = 12,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"It might have been a silly thing to do, but Thule, Gunthar and I were like family... brothers. We never expected our world to be torn apart, nor for Thule to side with the Lich King leaving Gunthar and myself to fight for our humanity... I can sense the taint of the scourge seeping into Thule's portion of the wand. It will forever be marred, corrupted by his betrayal, but alas I am not ready to let go... maybe with time.Please accept this token of knowledge as my final thanks."},
            [questKeys.objectives] = nil,
        },
        [78287] = {
            [questKeys.name] = "Let Me Make You An Offer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{8383}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Arms Shipment to Master Wood in Stormwind City."},
            [questKeys.objectives] = nil,
        },
        [78288] = {
            [questKeys.name] = "Let Me Make You An Offer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{3408}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Arms Shipment to Zel'mak in Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [78297] = {
            [questKeys.name] = "You've Got Yourself A Deal",
            [questKeys.startedBy] = {{8383}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Signed Procurement Contract to Grizzby in Ratchet."},
            [questKeys.objectives] = nil,
        },
        [78304] = {
            [questKeys.name] = "You've Got Yourself A Deal",
            [questKeys.startedBy] = {{3408}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Signed Procurement Contract to Grizzby in Ratchet."},
            [questKeys.objectives] = nil,
        },
        [78307] = {
            [questKeys.name] = "The Horn of Xelthos",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Log."},
            [questKeys.objectives] = nil,
        },
        [78506] = {
            [questKeys.name] = "Elemental Distress",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect motes of elemental rage, and bring them to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{210668},{210667},{210665}}},
        },
        [78537] = {
            [questKeys.name] = "Elixir of Insight",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Bring an Elixir of Water Breathing and an Elixir of Wisdom to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{5996},{3383}}},
        },
        [78561] = {
            [questKeys.name] = "Elixir of Insight",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Drink the Elixir of Insight near the bonfire at Zoram'gar Outpost, and witness the vision it grants you."},
            [questKeys.objectives] = {nil,nil,{{210712}}},
        },
        [78575] = {
            [questKeys.name] = "Hirzek",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Slay Hirzek at Blackthorn Ridge, Barrens, and bring his staff to Jen'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = {{{212694}}},
        },
        [78611] = {
            [questKeys.name] = "A Waylaid Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The shipment's missing some items, but it will still be of some use. &nbsp;Thank you, &lt;name&gt;."},
            [questKeys.objectives] = nil,
        },
        [78612] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211365}}},
        },
        [78676] = {
            [questKeys.name] = "The Eye of Bhossca",
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Eye of Bhossca inside of the Scarlet Monastery. Then, return it to C's dead drop near Pyrewood Village. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{210953}}},
        },
        [78680] = {
            [questKeys.name] = "Rumors Abound",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {{6247}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Not much is known about the location of these shattered weapon fragments, save that they are both in the possession of once great mages held up in towers of importance. One is said to be located here to the north on Kalimdor, while the other is nestled near the heart of the Eastern Kingdoms.See if the rumors are true... Search for the two missing halves of this weapon and bring them to me."},
            [questKeys.objectives] = {nil,nil,{{210765},{210763}}},
        },
        [78681] = {
            [questKeys.name] = "The Conjuring",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {nil,{412224}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Collect 10 Blood of the Legion and perform the ritual to summon Des'Altek to trap its soul once again."},
            [questKeys.objectives] = {nil,nil,{{210966}}},
        },
        [78684] = {
            [questKeys.name] = "Mysterious Traveler",
            [questKeys.startedBy] = {{213444}},
            [questKeys.finishedBy] = {{6247}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Meet with Doan Karhan and the Mysterious Traveler in the Barrens."},
            [questKeys.objectives] = nil,
        },
        [78699] = {
            [questKeys.name] = "The Eye of Bhossca",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Log."},
            [questKeys.objectives] = nil,
        },
        [78702] = {
            [questKeys.name] = "Raszel Ander",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {{6247}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Raszel was a friend... One I thought I had lost long ago, from a different time... We were young apprentices back then... Much has changed.The result of the ritual might have been a setback, but I believe we can still reform the weapon.Raszel and I have much to discuss, together we will come up with a plan. I'll send word once we know how to move forward.In the meantime, take this. It seems like something you might be interested in."},
            [questKeys.objectives] = nil,
        },
        [78823] = {
            [questKeys.name] = "Terror of the Desert Skies",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{715}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring the Primitive Drawing to Hemet Nesingwary in Stranglethorn Vale."},
            [questKeys.objectives] = nil,
        },
        [78830] = {
            [questKeys.name] = "Terror of the Desert Skies",
            [questKeys.startedBy] = {{715}},
            [questKeys.finishedBy] = {{715}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Get a Crimson Trophy Quill from Gharrik in the Badlands. Then, return to Hemet Nesingwary in Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{211293},{211272}}},
        },
        [78872] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211367}}},
        },
        [78909] = {
            [questKeys.name] = "Shifting Scale Talisman",
            [questKeys.startedBy] = {{214208}},
            [questKeys.finishedBy] = {{214208}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring N'ora Anyheart the following materials alongside the Handful of Shifting Scales to complete the talisman: A satchel of Strange Dust, five Greater Magic Essence, 2 Small Glimmering Shards and five gold pieces."},
            [questKeys.objectives] = {nil,nil,{{10940},{10939},{211419},{10978}}},
        },
        [78914] = {
            [questKeys.name] = "Soul Vessel",
            [questKeys.startedBy] = {{213445}},
            [questKeys.finishedBy] = {{215850}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Now that we have a way to weaken the demon we need a vessel to bind them within. The Burning Blade have overrun ancient elven ruins in southern Desolace, using it as a staging ground to summon demons to Azeroth. Once you have found a Soul Vessel meet us in Desolace, there we will complete the ritual."},
            [questKeys.objectives] = {nil,nil,{{211427}}},
        },
        [78916] = {
            [questKeys.name] = "The Heart of the Void",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Blackfathom Pearl to Dawnwatcher Selgorm in Darnassus."},
            [questKeys.objectives] = nil,
        },
        [78917] = {
            [questKeys.name] = "The Heart of the Void",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Blackfathom Pearl to Bashana Runetotem in Thunder Bluff."},
            [questKeys.objectives] = nil,
        },
        [78920] = {
            [questKeys.name] = "Baron Aquanis",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Strange Water Globe to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [78921] = {
            [questKeys.name] = "Blackfathom Villainy",
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the head of Twilight Lord Kelris to Dawnwatcher Selgorm in Darnassus."},
            [questKeys.objectives] = {nil,nil,{{5881}}},
        },
        [78922] = {
            [questKeys.name] = "Blackfathom Villainy",
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the head of Twilight Lord Kelris to Bashana Runetotem in Thunder Bluff."},
            [questKeys.objectives] = {nil,nil,{{5881}}},
        },
        [78923] = {
            [questKeys.name] = "Knowledge in the Deeps",
            [questKeys.startedBy] = {{2786}},
            [questKeys.finishedBy] = {{2786}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Lorgalis Manuscript to Gerrig Bonegrip in the Forlorn Cavern in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{5359}}},
        },
        [78924] = {
            [questKeys.name] = "In Search of Thaelrid",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Argent Guard Thaelrid in Blackfathom Deeps."},
            [questKeys.objectives] = nil,
        },
        [78925] = {
            [questKeys.name] = "Twilight Falls",
            [questKeys.startedBy] = {{4784}},
            [questKeys.finishedBy] = {{4784}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 10 Twilight Pendants to Argent Guard Manados in Darnassus."},
            [questKeys.objectives] = {nil,nil,{{5879}}},
        },
        [78926] = {
            [questKeys.name] = "Researching the Corruption",
            [questKeys.startedBy] = {{8997}},
            [questKeys.finishedBy] = {{8997}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gershala Nightwhisper in Auberdine wants 8 Corrupt Brain stems."},
            [questKeys.objectives] = {nil,nil,{{5952}}},
        },
        [78927] = {
            [questKeys.name] = "Allegiance to the Old Gods",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill Lorgus Jett in Blackfathom Deeps and then return to Je'neu Sancrea in Ashenvale."},
            [questKeys.objectives] = {{{207356}}},
        },
        [78994] = {
            [questKeys.name] = "A Solid Foundation",
            [questKeys.startedBy] = {{213445}},
            [questKeys.finishedBy] = {{213445}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"The Emerald Dragons protect several portals to the Emerald Dream throughout Azeroth. One of these locations surely has what we need.Once you've found a Bough of Shadows return with haste."},
            [questKeys.objectives] = {nil,nil,{{211426}}},
        },
        [79007] = {
            [questKeys.name] = "...and that note you found",
            [questKeys.startedBy] = {nil,{415106}},
            [questKeys.finishedBy] = {nil,{415107,424010}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Charred remains of the note serve as your only guide."},
            [questKeys.objectives] = nil,
        },
        [79008] = {
            [questKeys.name] = "...and that note you found",
            [questKeys.startedBy] = {nil,{415107}},
            [questKeys.finishedBy] = {nil,{415106,417072}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Charred remains of the note serve as your only guide."},
            [questKeys.objectives] = nil,
        },
        [79077] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{1212}},
            [questKeys.finishedBy] = {{1212}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on the Light, then pray with the kneeling elf to share your meditations."},
            [questKeys.objectives] = {{{215068}}},
        },
        [79078] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{4092}},
            [questKeys.finishedBy] = {{4092}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on Elune, then pray with the kneeling human to share your meditations."},
            [questKeys.objectives] = {{{215068}}},
        },
        [79079] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{6018}},
            [questKeys.finishedBy] = {{6018}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on the Loa, then pray with the kneeling Forsaken to share your meditations."},
            [questKeys.objectives] = {{{215068}}},
        },
        [79080] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{4607}},
            [questKeys.finishedBy] = {{4607}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on undeath, then pray with the kneeling troll to share your meditations."},
            [questKeys.objectives] = {{{215068}}},
        },
        [79090] = {
            [questKeys.name] = "Repelling Invaders",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{212970,217707}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Warsong Outrider Mark to Felore Moonray, Priestess of the Moon, at the Moonwell base in Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [79091] = {
            [questKeys.name] = "Archmage Antonidas: The Unabridged Autobiography",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{203754}}},
        },
        [79092] = {
            [questKeys.name] = "Archmage Theocritus's Research Journal",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{203755}}},
        },
        [79093] = {
            [questKeys.name] = "Rumi of Gnomeregan: The Collected Works",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{208860}}},
        },
        [79094] = {
            [questKeys.name] = "The Lessons of Ta'zo",
            [questKeys.startedBy] = {{211022}},
            [questKeys.finishedBy] = {{211022}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{207972}}},
        },
        [79095] = {
            [questKeys.name] = "The Apothecary's Metaphysical Primer",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{208185}}},
        },
        [79096] = {
            [questKeys.name] = "Ataeric: On Arcane Curiosities",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{210177}}},
        },
        [79097] = {
            [questKeys.name] = "Baxtan: On Destructive Magics",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{208800}}},
        },
        [79098] = {
            [questKeys.name] = "Clear the Forest!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{212969,217706}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Silverwing Sentinel Charm to Kazragore, Far Seer, at the Bonfire base in Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [79099] = {
            [questKeys.name] = "Baron Aquanis",
            [questKeys.startedBy] = {{214876}},
            [questKeys.finishedBy] = {{214876}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Strange Water Globe to Davidus Voidstar in Auberdine, Darkshore."},
            [questKeys.objectives] = {nil,nil,{{211818}}},
        },
        [79100] = {
            [questKeys.name] = "A Waylaid Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The shipment's missing some items, but it will still be of some use. &nbsp;Thank you, &lt;name&gt;."},
            [questKeys.objectives] = nil,
        },
        [79101] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211839}}},
        },
        [79102] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211840}}},
        },
        [79103] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211841}}},
        },
        [79192] = {
            [questKeys.name] = "Stepping Stones",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{424005}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You tear the note from the plank and read the scrawled writing."},
            [questKeys.objectives] = nil,
        },
        [79229] = {
            [questKeys.name] = "Highway Robbery",
            [questKeys.startedBy] = {nil,{417353}},
            [questKeys.finishedBy] = {{11438}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find someone in Desolace who knows about the pillaged campsite."},
            [questKeys.objectives] = nil,
        },
        [79235] = {
            [questKeys.name] = "On the Lam",
            [questKeys.startedBy] = {{11438}},
            [questKeys.finishedBy] = {{215643}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find one of the Desolace marauders."},
            [questKeys.objectives] = nil,
        },
        [79236] = {
            [questKeys.name] = "Cherry for Your Thoughts?",
            [questKeys.startedBy] = {{215643}},
            [questKeys.finishedBy] = {{215643}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Cherry Grog to Tokal, in Booty Bay, to hear the rest of her story."},
            [questKeys.objectives] = {nil,nil,{{4600}}},
        },
        [79242] = {
            [questKeys.name] = "No Honor Among Thieves",
            [questKeys.startedBy] = {{215643}},
            [questKeys.finishedBy] = {nil,{418855}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Illari Duskfeather, near Arathi Highlands, and get access to her cache of stolen loot."},
            [questKeys.objectives] = {{{215655}}},
        },
        [79298] = {
            [questKeys.name] = "Tempting Fate",
            [questKeys.startedBy] = {{215850}},
            [questKeys.finishedBy] = {{215849}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Assist Raszel Ander and Doan Karhan with the summoning ritual and trap Des'Altek inside the staff."},
            [questKeys.objectives] = {{{215974}}},
        },
        [79348] = {
            [questKeys.name] = "The Lost Ancient",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{216289}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Find someone who can tell you more about the rotten ancient seed."},
            [questKeys.objectives] = nil,
        },
        [79358] = {
            [questKeys.name] = "Tattered Note",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4722}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Warn the denizens of Thousand Needles of what you have discovered."},
            [questKeys.objectives] = nil,
        },
        [79360] = {
            [questKeys.name] = "Elemental Aid",
            [questKeys.startedBy] = {{4722}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"While many inhabitants of Thousand Needles are our enemies, we can't stand by and watch them get washed away. The note was clear, they plan to raise an undead army in the aftermath, which potentially threatens us all.We are ill equipped to deal with this, but I've heard of a shaman on the Eastern Kingdoms who's proficient in the elemental imbuement of weapons, they might be capable of helping.Find this shaman and plead for their aid."},
            [questKeys.objectives] = nil,
        },
        [79361] = {
            [questKeys.name] = "Power of da Wind",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 5 Whirling Essence from the whirlwind elementals in Desolace and bring them to Bath'rah the Windwatcher in Alterac Mountains. Rewards ."},
            [questKeys.objectives] = {nil,nil,{{212724}}},
        },
        [79362] = {
            [questKeys.name] = "Power of da Earth",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 38,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 5 Rumbling Essence from the rock elementals in Badlands and bring them to Bath'rah the Windwatcher in Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{212723}}},
        },
        [79363] = {
            [questKeys.name] = "Power of da Water",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 36,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 5 Rushing Essence from the withering elementals in Dustwallow Marsh and bring them to Bath'rah the Windwatcher in Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{212726}}},
        },
        [79364] = {
            [questKeys.name] = "A Simple Container",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"You didn't think I'd be making some crazy weapon for ya did you's? Nah, nah, nah me friend dis be a potion of protection.Fightin' fire with fire not always be the right approach mon.Bring a Crystal Vial to Bath'rah the Windwatcher in Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{8925}}},
        },
        [79365] = {
            [questKeys.name] = "With Wind Beneath Your Wings",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{4722}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Return to Rau Cliffrunner in Thousand Needles at Freewind Post."},
            [questKeys.objectives] = {nil,nil,{{212982}}},
        },
        [79366] = {
            [questKeys.name] = "Calm Before the Storm",
            [questKeys.startedBy] = {{4722}},
            [questKeys.finishedBy] = {{4722}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Venture into the eye of the storm and confront the quilboars."},
            [questKeys.objectives] = {nil,nil,{{212792}}},
        },
        [79377] = {
            [questKeys.name] = "The Lost Saplings",
            [questKeys.startedBy] = {{216289}},
            [questKeys.finishedBy] = {{216289}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Find the four lost saplings in Eastern Kingdoms, and share the Water of Elune'ara with them. Afterwards, return to Orokai, in Moonglade."},
            [questKeys.objectives] = {nil,nil,{{213036}}},
        },
        [79442] = {
            [questKeys.name] = "Catching Up",
            [questKeys.startedBy] = {{4722}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Return to Bath'rah the Windwatcher in Alterac Mountains and see if he can put the Eye of the Tempest to use."},
            [questKeys.objectives] = nil,
        },
        [79482] = {
            [questKeys.name] = "Stolen Winter Veil Treats",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216915}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate the Smokywood Pastures investigator that has gone missing in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = nil,
        },
        [79483] = {
            [questKeys.name] = "Stolen Winter Veil Treats",
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{216915}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate the Smokywood Pastures investigator that has gone missing in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = nil,
        },
        [79484] = {
            [questKeys.name] = "You're a Mean One...",
            [questKeys.startedBy] = {{216915}},
            [questKeys.finishedBy] = {{216902}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate and return the Stolen Treats to Wulmort Jinglepocket in Ironforge.  It was last thought to be in the possession of the Abominable Greench, found somewhere in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{17662}}},
        },
        [79485] = {
            [questKeys.name] = "You're a Mean One...",
            [questKeys.startedBy] = {{216915}},
            [questKeys.finishedBy] = {{216924}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate and return the Stolen Treats to Kaymard Copperpinch in Orgrimmar.  It was last thought to be in the possession of the Abominable Greench, found somewhere in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{17662}}},
        },
        [79486] = {
            [questKeys.name] = "A Smokywood Pastures' Thank You!",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{13444}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Greatfather Winter in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [79487] = {
            [questKeys.name] = "A Smokywood Pastures' Thank You!",
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{13445}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Great-father Winter in Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [79492] = {
            [questKeys.name] = "Metzen the Reindeer",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216902}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Metzen the Reindeer.  Use the notes provided to you for clues as to where he is being held.When you find Metzen, have the Pouch of Reindeer Dust in your possession so you can sprinkle some of the dust on him; this should free Metzen from his bonds of captivity.Return the Pouch of Reindeer Dust to Wulmort Jinglepocket in Ironforge once Metzen is freed."},
            [questKeys.objectives] = {{{15664}}},
        },
        [79495] = {
            [questKeys.name] = "Metzen the Reindeer",
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{216924}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Metzen the Reindeer.  Use the notes provided to you for clues as to where he is being held.When you find Metzen, have the Pouch of Reindeer Dust in your possession so you can sprinkle some of the dust on him; this should free Metzen from his bonds of captivity.Return the Pouch of Reindeer Dust to Kaymard Copperpinch in Orgrimmar once Metzen is freed."},
            [questKeys.objectives] = {{{15664}}},
        },
        [79501] = {
            [questKeys.name] = "The Hero of the Day",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {nil,{180715}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 1 Deeprock Salt and 5 gold coins to any Holly Preserver machine, upon which you will receive 5 Preserved Holly."},
            [questKeys.objectives] = {nil,nil,{{8150}}},
        },
        [79502] = {
            [questKeys.name] = "The Hero of the Day",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{180715}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 1 Deeprock Salt and 5 gold coins to the Holly Preserver machine, upon which you will receive 5 Preserved Holly."},
            [questKeys.objectives] = {nil,nil,{{8150}}},
        },
        [79535] = {
            [questKeys.name] = "Basilisks: Should Petrification be Feared?",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{213165}}},
        },
        [79536] = {
            [questKeys.name] = "Greater Friend of the Library",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [79588] = {
            [questKeys.name] = "Small Furry Paws",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The first lesson in drawing a crowd is: lure them with gadgets and trinkets! &nbsp;Can you help me?I need small furry paws to use for prizes. &nbsp;You can find those on the cats of the Barrens or Darkshore....Bring me some paws and I'll trade you a Darkmoon Faire ticket for them."},
            [questKeys.objectives] = {nil,nil,{{5134}}},
        },
        [79589] = {
            [questKeys.name] = "Torn Bear Pelts",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Children love toys! &nbsp;And no matter what race, I've found that all children love furry, plushy toys made from torn bear pelts!You can get those pelts from the bears of Ashenvale or Hillsbrad. &nbsp;Bring me a heap of them and earn yourself a heap of Darkmoon Faire tickets!"},
            [questKeys.objectives] = {nil,nil,{{11407}}},
        },
        [79590] = {
            [questKeys.name] = "Heavy Grinding Stone",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To help with my workout, I like to fit a staff between heavy grinding stones, then lift the staff over my head. &nbsp;It isn't easy, but being the strongest woman in the world, like I am, can't be earned sitting down!Can you help me? &nbsp;I need more grinding stones - bring me some and I'll trade Darkmoon Faire tickets for them."},
            [questKeys.objectives] = {nil,nil,{{3486}}},
        },
        [79591] = {
            [questKeys.name] = "Whirring Bronze Gizmo",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"My new booth will be a sight to see, yes sir! &nbsp;A sight to see, and... for a lucky few, to touch!I can already hear the whirring bronze gizmos singing their song of mechanical rapture as patrons step to my booth and test their skill!Ah... now I need the gizmos themselves to bring my dream closer to fruition. &nbsp;Please, &lt;name&gt;, bring me whirring bronze gizmos... and Darkmoon Faire tickets will be yours!"},
            [questKeys.objectives] = {nil,nil,{{4375}}},
        },
        [79592] = {
            [questKeys.name] = "Carnival Jerkins",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Our Faire workers do more than sweep trash and hammer spikes! &nbsp;They also help guard the carnival as it travels, and to that end they are always needing good sturdy armor jerkins.If you make some tough leather armor and bring it to me, then I'll make sure it gets to the right people. &nbsp;I'll also get you some Darkmoon Faire tickets as trade."},
            [questKeys.objectives] = {nil,nil,{{2314}}},
        },
        [79593] = {
            [questKeys.name] = "Coarse Weightstone",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"It takes a lot of work to be the strongest woman alive! &nbsp;My weight set is getting too light and if I'm too stay fit then I'll need more weights!Do you think you could bring me some weight stones? &nbsp;If you do, then I'll give you a Darkmoon Faire ticket."},
            [questKeys.objectives] = {nil,nil,{{3240}}},
        },
        [79594] = {
            [questKeys.name] = "Copper Modulator",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Yebb is developing a new attraction for the Zoo Bizarre, one that will drive people crazy with wonder, and delight! &nbsp;But it will take a lot of work, and a lot of materials...That includes copper modulators. &nbsp;We need lots of modulators for the mechanical parts of the attraction. &nbsp;Bring me copper modulators and I'll trade for them with a Darkmoon Faire ticket."},
            [questKeys.objectives] = {nil,nil,{{4363}}},
        },
        [79595] = {
            [questKeys.name] = "Carnival Boots",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"We at the Darkmoon Faire do much walking. &nbsp;We walk from one faire site to another... in fact, you'll never see us sitting down on the job! &nbsp;So it is no surprise that we wear out quite a lot of boots! &nbsp;We need boots that are both durable and stylish, and embossed leather boots fit that bill rather well.You! &nbsp;You're a leatherworker; make me embossed leather boots and I'll give you a Darkmoon Faire ticket for the work."},
            [questKeys.objectives] = {nil,nil,{{2309}}},
        },
        [79624] = {
            [questKeys.name] = "Anyone Can Cook",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{217300}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find an ogre who can read the Illegible Recipe."},
            [questKeys.objectives] = nil,
        },
        [79626] = {
            [questKeys.name] = "The Salvagematic 9000!",
            [questKeys.startedBy] = {nil,{422483}},
            [questKeys.finishedBy] = {nil,{422483}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Salvage into the Salvagematic 9000, and be sure to have thirty silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{213427}}},
        },
        [79637] = {
            [questKeys.name] = "A Ticking Present",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have a joyous Feast of Great-Winter from your friends at Smokeywood Pastures."},
            [questKeys.objectives] = nil,
        },
        [79677] = {
            [questKeys.name] = "A Quick Grocery Run",
            [questKeys.startedBy] = {{217300}},
            [questKeys.finishedBy] = {{217300}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Gather the ingredients for Skonk's dish, then bring them to him in Arathi Highlands."},
            [questKeys.objectives] = {nil,nil,{{213526},{213527},{213528},{213529}}},
        },
        [79678] = {
            [questKeys.name] = "Taste Testing",
            [questKeys.startedBy] = {{217300}},
            [questKeys.finishedBy] = {{217300}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Taste test the recipe with Skonk."},
            [questKeys.objectives] = nil,
        },
        [79704] = {
            [questKeys.name] = "The Salvagematic 9000!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{422483}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Salvage into the Salvagematic 9000, and be sure to have three silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{213427}}},
        },
        [79705] = {
            [questKeys.name] = "Salvaging the Salvagematic",
            [questKeys.startedBy] = {{217689}},
            [questKeys.finishedBy] = {{217689}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Ziri \"The Wrench\" 10 Mithril Bars, 5 Greater Mystic Essence, 3 GG12-082 Cartridge Fuses, and a Pristine G-7 C.O.R.E. Processor and she can get the Salvagematic 9000! working for you. Probably. Maybe."},
            [questKeys.objectives] = {nil,nil,{{3860},{216634},{11135},{213735}}},
        },
        [79731] = {
            [questKeys.name] = "The Troll Scroll",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{715}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Solve the riddle of the scroll. Once you've done that, Hemet Nesingwary might like to hear the tale."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{425314}}},
        },
        [79905] = {
            [questKeys.name] = "A Taste of Knowledge",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211033}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"With the knowledge you've gained in your travels, I believe you're ready to learn to conjure Comprehension Charms on your own. This will help you uncover new texts for the library's collection.Safe travels, &lt;name&gt;."},
            [questKeys.objectives] = nil,
        },
        [79939] = {
            [questKeys.name] = "The Broken Hammer",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Search for clues about what happened at the Mannoroc Coven in Desolace, and find someone who may know more about the broken hammer."},
            [questKeys.objectives] = {{{5492}}},
        },
        [79940] = {
            [questKeys.name] = "A Lost Brother",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Katherine the Pure and learn more about the broken hammer."},
            [questKeys.objectives] = {{{11080}}},
        },
        [79945] = {
            [questKeys.name] = "Orders from the Grand Crusader",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Orders from the Grand Crusader back to Katherine the Pure."},
            [questKeys.objectives] = {{{5492}}},
        },
        [79946] = {
            [questKeys.name] = "A Brother In Need",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{217996}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Katherine to learn more about Aeonas, and then find him in the Scarlet Monastery."},
            [questKeys.objectives] = {{{218238},{217996}}},
        },
        [79947] = {
            [questKeys.name] = "Geomancy: The Stone-Cold Truth",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215683}}},
        },
        [79948] = {
            [questKeys.name] = "Defensive Magics 101",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215815}}},
        },
        [79949] = {
            [questKeys.name] = "A Web of Lies: Debunking Myths and Legends",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215816}}},
        },
        [79950] = {
            [questKeys.name] = "Demons and You",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215817}}},
        },
        [79951] = {
            [questKeys.name] = "Mummies: A Guide to the Unsavory Undead",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215820}}},
        },
        [79952] = {
            [questKeys.name] = "RwlRwlRwlRwl!",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215822}}},
        },
        [79953] = {
            [questKeys.name] = "A Ludite's Guide to Caring for Your Demonic Pet",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215824}}},
        },
        [79963] = {
            [questKeys.name] = "By The Light's Grace",
            [questKeys.startedBy] = {{217996}},
            [questKeys.finishedBy] = {{217996}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Heal Aeonas."},
            [questKeys.objectives] = {{{218007}}},
        },
        [79970] = {
            [questKeys.name] = "Aeonas the Vindicated",
            [questKeys.startedBy] = {{217996}},
            [questKeys.finishedBy] = {{218160}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Meet Aeonas at the Cathedral of Light in Stormwind."},
            [questKeys.objectives] = {{{218160}}},
        },
        [79974] = {
            [questKeys.name] = "Wet Job",
            [questKeys.startedBy] = {nil,{424012}},
            [questKeys.finishedBy] = {nil,{424007}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Dusting off a messenger bag emerging from the soil, you find a parchment nestled among the supplies."},
            [questKeys.objectives] = nil,
        },
        [79975] = {
            [questKeys.name] = "Eagle's Fist",
            [questKeys.startedBy] = {nil,{424007}},
            [questKeys.finishedBy] = {nil,{406918}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Water spray dampens the air, the view is incredible."},
            [questKeys.objectives] = nil,
        },
        [79976] = {
            [questKeys.name] = "This Must Be The Place",
            [questKeys.startedBy] = {nil,{406918}},
            [questKeys.finishedBy] = {nil,{424006}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Whoever was here, you just missed them."},
            [questKeys.objectives] = nil,
        },
        [79980] = {
            [questKeys.name] = "Scramble",
            [questKeys.startedBy] = {nil,{424005}},
            [questKeys.finishedBy] = {nil,{424012}},
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find what awaits you."},
            [questKeys.objectives] = nil,
        },
        [79981] = {
            [questKeys.name] = "The Corroded Core",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{218237}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find someone who can repair the Corroded G-7 C.O.R.E Processor."},
            [questKeys.objectives] = nil,
        },
        [79982] = {
            [questKeys.name] = "Warranty Claim",
            [questKeys.startedBy] = {{218237}},
            [questKeys.finishedBy] = {{218237}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Wirdal Wondergear a Charged Voidcore."},
            [questKeys.objectives] = {nil,nil,{{216636}}},
        },
        [79984] = {
            [questKeys.name] = "Quadrangulation",
            [questKeys.startedBy] = {{7853}},
            [questKeys.finishedBy] = {{7853}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Wirdal Wondergear's Quadrangulation Beacons and attune with them. There are four of them and they are located somewhere in Kalimdor. Rewards ."},
            [questKeys.objectives] = nil,
        },
        [79985] = {
            [questKeys.name] = "A Fine Mess",
            [questKeys.startedBy] = {{7850}},
            [questKeys.finishedBy] = {{7853}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Escort Kernobee to the Clockwerk Run exit and then report to Scooty in Booty Bay."},
            [questKeys.objectives] = nil,
        },
        [79986] = {
            [questKeys.name] = "Grime-Encrusted Ring",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Figure out a way to remove the grime from the Grime-Encrusted Ring."},
            [questKeys.objectives] = nil,
        },
        [79987] = {
            [questKeys.name] = "Return of the Ring",
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {{6826}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You may either keep the ring, or you may find the person responsible for the imprint and engravings on the inside of the band."},
            [questKeys.objectives] = nil,
        },
        [79990] = {
            [questKeys.name] = "Stranglethorn Lumber",
            [questKeys.startedBy] = {{14984}},
            [questKeys.finishedBy] = {{14984}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Sergeant Maclear a Shipment of Stranglethorn Lumber."},
            [questKeys.objectives] = {nil,nil,{{216491}}},
        },
        [79991] = {
            [questKeys.name] = "Stranglethorn Lumber",
            [questKeys.startedBy] = {{15022}},
            [questKeys.finishedBy] = {{15022}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Deathstalker Mortis a Shipment of Stranglethorn Lumber."},
            [questKeys.objectives] = {nil,nil,{{216491}}},
        },
        [80001] = {
            [questKeys.name] = "Rekindle",
            [questKeys.startedBy] = {nil,{424082}},
            [questKeys.finishedBy] = {nil,{424082}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"An extinguished fire pit. The wood is even dry enough to catch a flame."},
            [questKeys.objectives] = {nil,nil,{{4470},{4471}}},
        },
        [80098] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216945}}},
        },
        [80120] = {
            [questKeys.name] = "A Service to Dalaran",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You have done a great service for Dalaran, and for Azeroth.Our laws prohibit me from sharing Dalaran's secrets with outsiders, but I think I can stretch the rules a bit to reward you for your efforts. Please, take this."},
            [questKeys.objectives] = nil,
        },
        [80131] = {
            [questKeys.name] = "Gnome Improvement",
            [questKeys.startedBy] = {{6826}},
            [questKeys.finishedBy] = {{6826}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Brilliant Gold Ring, a Silver Bar, a Moss Agate, and 30 silver coins to Talvash del Kissel in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{2842},{1206}}},
        },
        [80132] = {
            [questKeys.name] = "Rig Wars",
            [questKeys.startedBy] = {{3412}},
            [questKeys.finishedBy] = {{3412}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Retrieve the Rig Blueprints and Thermaplugg's Safe Combination from Gnomeregan and bring them to Nogg in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{9153},{9299}}},
        },
        [80133] = {
            [questKeys.name] = "Chief Engineer Scooty",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{7853}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Scooty in Booty Bay."},
            [questKeys.objectives] = nil,
        },
        [80134] = {
            [questKeys.name] = "Gnomer-gooooone!",
            [questKeys.startedBy] = {{7853}},
            [questKeys.finishedBy] = {{7853}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Wait for Scooty to calibrate the Goblin Transponder."},
            [questKeys.objectives] = nil,
        },
        [80135] = {
            [questKeys.name] = "Klockmort's Essentials",
            [questKeys.startedBy] = {{6142}},
            [questKeys.finishedBy] = {{6169}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Klockmort Spannerspan in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80136] = {
            [questKeys.name] = "Essential Artificials",
            [questKeys.startedBy] = {{6169}},
            [questKeys.finishedBy] = {{6169}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 12 Essential Artificials to Klockmort Spannerspan in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{9278}}},
        },
        [80137] = {
            [questKeys.name] = "Save Techbot's Brain!",
            [questKeys.startedBy] = {{7944}},
            [questKeys.finishedBy] = {{7944}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Techbot's Memory Core to Tinkmaster Overspark in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{9277}}},
        },
        [80138] = {
            [questKeys.name] = "Tinkmaster Overspark",
            [questKeys.startedBy] = {{7917}},
            [questKeys.finishedBy] = {{7944}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Tinkmaster Overspark in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80139] = {
            [questKeys.name] = "Gnogaine",
            [questKeys.startedBy] = {{1268}},
            [questKeys.finishedBy] = {{1268}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the Empty Leaden Collection Phial on Irradiated Invaders or Irradiated Pillagers to collect radioactive fallout. Once it is full, take it back to Ozzie Togglevolt in Kharanos."},
            [questKeys.objectives] = {nil,nil,{{9284},{9283}}},
        },
        [80140] = {
            [questKeys.name] = "Return of the Ring",
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {{3412}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You may either keep the ring, or you may find the person responsible for the imprint and engravings on the inside of the band."},
            [questKeys.objectives] = nil,
        },
        [80141] = {
            [questKeys.name] = "Nogg's Ring Redo",
            [questKeys.startedBy] = {{3412}},
            [questKeys.finishedBy] = {{3412}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Brilliant Gold Ring, a Silver Bar, a Moss Agate, and 30 silver coins to Nogg in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{2842},{1206}}},
        },
        [80142] = {
            [questKeys.name] = "Castpipe's Task",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Master Mechanic Castpipe in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80143] = {
            [questKeys.name] = "Data Rescue",
            [questKeys.startedBy] = {{7950}},
            [questKeys.finishedBy] = {{7950}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Prismatic Punch Card to Master Mechanic Castpipe in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{9316}}},
        },
        [80147] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216946}}},
        },
        [80148] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216947}}},
        },
        [80149] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216948}}},
        },
        [80150] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216949}}},
        },
        [80151] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216950}}},
        },
        [80152] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216951}}},
        },
        [80153] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = {nil,{175084}},
            [questKeys.finishedBy] = {nil,{175084}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Item into the Sparklematic 5200, and be sure to have three silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80155] = {
            [questKeys.name] = "More Sparklematic Action",
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Sparklematic 5200 is empty, awaiting a grime-encrusted object to clean and three silver coins to start!"},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80157] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"As quickly as it started, the Sparklematic 5200 comes to an abrupt halt. &nbsp;A simple \"ding\" is heard from the machine, and the mouth of the machine spirals upward. &nbsp;Inside the Sparklematic 5200 is a small box wrapped in a little bow. &nbsp;The machine would appear to wrap an object up after eliminating its grime-encrusted status. &nbsp;Even if the machine didn't work, at least the item is now wrapped in a pretty box.Well, there is one way to find out if it cleaned the item or not..."},
            [questKeys.objectives] = nil,
        },
        [80158] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = {nil,{142487}},
            [questKeys.finishedBy] = {nil,{142487}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Item into the Sparklematic 5200, and be sure to have three silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80160] = {
            [questKeys.name] = "More Sparklematic Action",
            [questKeys.startedBy] = {nil,{175084}},
            [questKeys.finishedBy] = {nil,{175084}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Sparklematic 5200 is empty, awaiting a grime-encrusted object to clean and three silver coins to start!"},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80161] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = {nil,{175084}},
            [questKeys.finishedBy] = {nil,{175084}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"As quickly as it started, the Sparklematic 5200 comes to an abrupt halt. &nbsp;A simple \"ding\" is heard from the machine, and the mouth of the machine spirals upward. &nbsp;Inside the Sparklematic 5200 is a small box wrapped in a little bow. &nbsp;The machine would appear to wrap an object up after eliminating its grime-encrusted status. &nbsp;Even if the machine didn't work, at least the item is now wrapped in a pretty box.Well, there is one way to find out if it cleaned the item or not..."},
            [questKeys.objectives] = nil,
        },
        [80164] = {
            [questKeys.name] = "Large Cluster Rockets",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Large cluster rockets require vast resources and skill to create, but their brilliance and beauty is worth that effort! &nbsp;Bring me coins of ancestry and I will grant you the knowledge of their crafting."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80165] = {
            [questKeys.name] = "Cluster Rockets",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Cluster rockets are a collection of individual rockets, and their beauty is awesome! &nbsp;Bring me coins of ancestry and I will share the knowledge of their creation to you..."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80166] = {
            [questKeys.name] = "Small Rockets",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I hold the secrets to creating Lunar Festival rockets, and I am happy to share my knowledge with the honored.In exchange for coins of ancestry, I can offer you the recipe to make a small rocket..."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80167] = {
            [questKeys.name] = "Large Rockets",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Large Festival rockets light up the sky brilliantly - only the cluster rockets rival their magnificence!Bring me coins of ancestry, &lt;name&gt;, and I shall share the knowledge of their creation."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80168] = {
            [questKeys.name] = "Firework Launcher",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Although rockets are a wonderful way to celebrate, in order to see their glory... they must be fired from a launcher.Bring me coins of ancestry and I can offer you the knowledge to create rocket launchers like the ones you see in Moonglade."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80169] = {
            [questKeys.name] = "Cluster Launcher",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The most splendid fireworks shows must include cluster rockets, and those cluster rockets must be fired from cluster launchers! &nbsp;Is it not then logical for you to learn the secrets of making cluster launchers? &nbsp;Bring me coins of ancestry and I will give this knowledge to you."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80170] = {
            [questKeys.name] = "Festive Recipes",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The dresses and pant suits you see are traditional clothes from many years past. &nbsp;They are worn in honor of old ways and loved ones gone.If you bring me coins of ancestry, &lt;name&gt;, then I will give you the pattern to create traditional red dresses or suits."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80180] = {
            [questKeys.name] = "The Grand Betrayal",
            [questKeys.startedBy] = {{7937}},
            [questKeys.finishedBy] = {{7937}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Venture to Gnomeregan and kill Mekgineer Thermaplugg. Return to High Tinker Mekkatorque when the task is complete."},
            [questKeys.objectives] = {{{218537}}},
        },
        [80181] = {
            [questKeys.name] = "Gyrodrillmatic Excavationators",
            [questKeys.startedBy] = {{6579}},
            [questKeys.finishedBy] = {{6579}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring twenty-four Robo-mechanical Guts to Shoni in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{9309}}},
        },
        [80182] = {
            [questKeys.name] = "The Only Cure is More Green Glow",
            [questKeys.startedBy] = {{1268}},
            [questKeys.finishedBy] = {{1268}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to Gnomeregan and bring back High Potency Radioactive Fallout. Be warned, the fallout is unstable and will collapse rather quickly.Ozzie will also require your Heavy Leaden Collection Phial when the task is complete."},
            [questKeys.objectives] = {nil,nil,{{9365}}},
        },
        [80241] = {
            [questKeys.name] = "The Origins of Smithing",
            [questKeys.startedBy] = {{7798}},
            [questKeys.finishedBy] = {{7798}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring six Golden Scale Bracers to Hank the Hammer in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{6040}}},
        },
        [80307] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{217337}}},
        },
        [80308] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{217338}}},
        },
        [80309] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{217339}}},
        },
        [80324] = {
            [questKeys.name] = "The Mad King",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{7937}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Thermaplugg's Engineering Notes to High Tinker Mekkatorque at Tinker Town in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80325] = {
            [questKeys.name] = "The Mad King",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{3412}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Thermaplugg's Engineering Notes to Nogg at the Valley of Honor in Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [80411] = {
            [questKeys.name] = "The Talisman of Kazdor",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6707}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Talisman of Kazdor inside of Zul'Farrak. Then, bring it to Fahrad at Ravenholdt Manor. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{217609}}},
        },
        [80417] = {
            [questKeys.name] = "Soft Bushy Tails",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"It's amazing what people value! &nbsp;Take, for instance, a wooden stick with a soft bushy tail attached to it. &nbsp;Now, you and I might think something like that isn't all that valuable... but if you give that piece of junk a neat name like \"Savage Fuzz Tail\" and put it in a pretty box, then people will think it's valuable. &nbsp;Trash becomes treasure!Get me soft bushy tails from the wolves of Desolace and the Badlands, and I'll give you Darkmoon Faire tickets."},
            [questKeys.objectives] = {nil,nil,{{4582}}},
        },
        [80421] = {
            [questKeys.name] = "Green Iron Bracers",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'm working on a new costume, for when I have my own booth as the strongest woman alive! &nbsp;Right now I'm looking for some bracers I can wear. &nbsp;They can't cover much because people want to see my muscles, but I still want to flash a little color, you know?How about green iron bracers, &lt;name&gt;? &nbsp;Can you make me green iron bracers? &nbsp;If you can, then I have a whole bunch of Darkmoon Faire tickets for you."},
            [questKeys.objectives] = {nil,nil,{{3835}}},
        },
        [80422] = {
            [questKeys.name] = "Green Fireworks",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"When I finally get this booth up and running, I'll want to advertise! &nbsp;And what better way is there to advertise then with fireworks?Well, some might think that the smell of a cauldron, churning with the boiling heads of your foes is better for drawing crowds, but... we're in mixed company. &nbsp;So fireworks it will have to be!Bring me green fireworks, &lt;name&gt;, and I have a big fistful of Darkmoon Faire tickets for you."},
            [questKeys.objectives] = {nil,nil,{{9313}}},
        },
        [80423] = {
            [questKeys.name] = "The World's Largest Gnome!",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Yebb Nebblegear is looking to add more talent to his show, and he's searching far and wide for the world's largest gnome. &nbsp;Do you know any gnomes of considerable size?Well before he finds the gnome, he wants to have its costume ready. &nbsp;I think a barbaric harness would be a good foundation for the costume; can you make some harnesses and bring them to me? &nbsp;Do that, and I'll have a stack of Darkmoon Faire tickets for you..."},
            [questKeys.objectives] = {nil,nil,{{5739}}},
        },
        [80453] = {
            [questKeys.name] = "Best Laid Plans",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6777}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Bring the Talisman of Kazdor to Zan Shivsprocket in the basement of Ravenholdt Manor."},
            [questKeys.objectives] = nil,
        },
        [80454] = {
            [questKeys.name] = "One Last Drop",
            [questKeys.startedBy] = {{6777}},
            [questKeys.finishedBy] = {nil,{410369}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Take the Modified Talisman to Caius' dead drop near Pyrewood Village."},
            [questKeys.objectives] = nil,
        },
        [80455] = {
            [questKeys.name] = "Biding Our Time",
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.finishedBy] = {{6707}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Report back to Fahrad at Ravenholdt Manor."},
            [questKeys.objectives] = nil,
        },
        [80526] = {
            [questKeys.name] = "Fool Me Twice",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6707}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Speak to Fahrad when you're ready to hear his plan."},
            [questKeys.objectives] = nil,
        },
        [81570] = {
            [questKeys.name] = "Jarl Needs a Blade",
            [questKeys.startedBy] = {{4792}},
            [questKeys.finishedBy] = {{4792}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Moonsteel Broadsword to Jarl in Dustwallow Marsh."},
            [questKeys.objectives] = {nil,nil,{{217281}}},
        },
        [81682] = {
            [questKeys.name] = "The Old Champ",
            [questKeys.startedBy] = {{220984}},
            [questKeys.finishedBy] = {{221400}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find Kajind somewhere in Azshara."},
            [questKeys.objectives] = nil,
        },
        [81697] = {
            [questKeys.name] = "Defanged",
            [questKeys.startedBy] = {{221400}},
            [questKeys.finishedBy] = {{221400}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Retrieve Kajind's blade from the blue drake roaming south-east of Forlorn Ridge in Azshara."},
            [questKeys.objectives] = {nil,nil,{{219935}}},
        },
        [81716] = {
            [questKeys.name] = "Recover Incursion Field Report: Duskwood",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Palandar."},
            [questKeys.objectives] = {{{221226},{221223},{221227}}},
        },
        [81727] = {
            [questKeys.name] = "Recover Incursion Field Report: Ashenvale",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221283},{221282},{221292}}},
        },
        [81728] = {
            [questKeys.name] = "Recover Incursion Field Report: Hinterlands",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Korlian."},
            [questKeys.objectives] = {{{221357},{221356},{221360}}},
        },
        [81729] = {
            [questKeys.name] = "Recover Incursion Field Report: Feralas",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Arunnel."},
            [questKeys.objectives] = {{{221407},{221406},{221408}}},
        },
        [81730] = {
            [questKeys.name] = "Duskwood Mission I: Defeat Worgen",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Nightmare Runners and 10 Nightmare Weavers in the Duskwood Nightmare Incursion in the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221171},{221172}}},
        },
        [81731] = {
            [questKeys.name] = "Duskwood Mission II: Defeat Ogres",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 3 Deranged Ogres and 3 Demented Fire Weavers in the Duskwood Nightmare Incursion at the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221174},{221175}}},
        },
        [81732] = {
            [questKeys.name] = "Duskwood Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 3 Wyrmkin Terrorwalkers and 10 Nightterror Whelps in the Duskwood Nightmare Incursion at the Yorgen Farmstead and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221200},{221176}}},
        },
        [81733] = {
            [questKeys.name] = "Duskwood Mission IV: Ogre Intelligence",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Thalinar in the Duskwood Nightmare Incursion deep inside the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219776}}},
        },
        [81734] = {
            [questKeys.name] = "Duskwood Mission V: Worgen Intelligence",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Dorilar in the Duskwood Nightmare Incursion in the barn at the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219778}}},
        },
        [81735] = {
            [questKeys.name] = "Duskwood Mission VI: Dragon Intelligence",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Amalia in the Duskwood Nightmare Incursion in the farmhouse at the Yorgen Farmstead and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219803}}},
        },
        [81736] = {
            [questKeys.name] = "Duskwood Mission VII: Recover Shadowscythe",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Shadowscythe in the Duskwood Nightmare Incursion upstairs in the farmhouse at the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219404}}},
        },
        [81737] = {
            [questKeys.name] = "Duskwood Mission VIII: Recover Ogre Magi text",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover an Ogre Magi Text in the Duskwood Nightmare Incursion within the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219405}}},
        },
        [81738] = {
            [questKeys.name] = "Duskwood Mission IX: Recover Dragon Egg",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover an Unhatched Green Dragon Egg in the Duskwood Nightmare Incursion from the Yorgen Farmstead near the large stump in the fields and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219406}}},
        },
        [81739] = {
            [questKeys.name] = "Duskwood Mission X: Nightmare Moss",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Nightmare Moss in the Duskwood Nightmare Incursions and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219399}}},
        },
        [81740] = {
            [questKeys.name] = "Duskwood Mission XI: Cold Iron Ore",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Cold Iron Ore in the Duskwood Nightmare Incursions and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219401}}},
        },
        [81741] = {
            [questKeys.name] = "Duskwood Mission XII: Dream-Touched Dragonscale",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Dream-Touched Dragonscales in the Duskwood Nightmare Incursions and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219402}}},
        },
        [81742] = {
            [questKeys.name] = "Duskwood Mission XIII: Defeat Ylanthrius",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Ylanthrius in the Duskwood Nightmare Incursion at the Yorgen Farmstead field and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221204}}},
        },
        [81743] = {
            [questKeys.name] = "Duskwood Mission XIV: Defeat Vvarc'zul",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Vvarc'zul in the Duskwood Nightmare Incursion deep in the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221206}}},
        },
        [81744] = {
            [questKeys.name] = "Duskwood Mission XV: Defeat Amokarok",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Amokarok in the Duskwood Nightmare Incursion at a campsite near the barn in the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221207}}},
        },
        [81745] = {
            [questKeys.name] = "Duskwood Mission XVI: Rescue Kroll Mountainshade",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Kroll Mountainshade from the Duskwood Nightmare Incursion in the guest house at the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221210}}},
        },
        [81746] = {
            [questKeys.name] = "Duskwood Mission XVII: Rescue Alara Grovemender",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Alara Grovemender in the Duskwood Nightmare Incursion in the stable at the Yorgen Farmstead and return to Field Captain Palandar. A quest."},
            [questKeys.objectives] = {{{221215}}},
        },
        [81747] = {
            [questKeys.name] = "Duskwood Mission XVIII: Rescue Elenora Marshwalker",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Elenora Marshwalker in the Duskwood Nightmare Incursion in the ruins of a farmhouse near the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {{{221216}}},
        },
        [81762] = {
            [questKeys.name] = "Some Good News",
            [questKeys.startedBy] = {{218160}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Katherine the Pure at the Cathedral of Light in Stormwind."},
            [questKeys.objectives] = {{{5492}}},
        },
        [81764] = {
            [questKeys.name] = "The Mysterious Merchant",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{221575}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Travel to Theramore and find the mysterious merchant."},
            [questKeys.objectives] = {{{221575}}},
        },
        [81765] = {
            [questKeys.name] = "Elrick, Paladin of the Silver Hand",
            [questKeys.startedBy] = {{221575}},
            [questKeys.finishedBy] = {{6272}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Elrick to learn more."},
            [questKeys.objectives] = {{{221575}}},
        },
        [81766] = {
            [questKeys.name] = "The Bloody Missive",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bring the missive to Katherine the Pure at the Cathedral of Light in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [81768] = {
            [questKeys.name] = "Ashenvale Mission I: Defeat Satyrs",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Dreamfire Betrayers and 10 Dreamfire Hellcallers in the Ashenvale Nightmare Incursion in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221262},{221261}}},
        },
        [81769] = {
            [questKeys.name] = "Ashenvale Mission II: Defeat Treants",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 7 Vengeful Ancients in the Ashenvale Nightmare Incursion at the Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221263}}},
        },
        [81770] = {
            [questKeys.name] = "Ashenvale Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 3 Wyrmkin Nightstalkers and 10 Terror Whelps in the Ashenvale Nightmare Incursion in Forest Song and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221259},{221260}}},
        },
        [81771] = {
            [questKeys.name] = "Ashenvale Mission IV: Dragon Intelligence",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Ellodar in the Ashenvale Nightmare Incursion in Forest Song on the bridge to the ancient tower and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219924}}},
        },
        [81772] = {
            [questKeys.name] = "Ashenvale Mission V: Satyr Intelligence",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Mandoran in the Ashenvale Nightmare Incursion at the ritual circle in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219925}}},
        },
        [81773] = {
            [questKeys.name] = "Ashenvale Mission VI: Treant Intelligence",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Lanaria in the Ashenvale Nightmare Incursion inside Kargathia Keep at the Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219926}}},
        },
        [81774] = {
            [questKeys.name] = "Ashenvale Mission VII: Recover Dreamengine",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Dreamengine in the Ashenvale Nightmare Incursion from the forge at Warsong Lumber Camp and return to Field Captain Hannalah. A quest."},
            [questKeys.objectives] = {nil,nil,{{219448}}},
        },
        [81775] = {
            [questKeys.name] = "Ashenvale Mission VIII: Recover Azsharan Prophecy",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Azsharan Prophecy in the Ashenvale Nightmare Incursion from the small tent in Satyrnaar and return to Field Captain Hannalah. A quest."},
            [questKeys.objectives] = {nil,nil,{{219449}}},
        },
        [81776] = {
            [questKeys.name] = "Ashenvale Mission IX: Recover Dream-Touched Dragonegg",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Dream-Touched Dragonegg in the Ashenvale Nightmare Incursion from the central ruin in Forest Song and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219447}}},
        },
        [81777] = {
            [questKeys.name] = "Ashenvale Mission X: Dreamroot",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Dreamroot in the Ashenvale Nightmare Incursions and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219444}}},
        },
        [81778] = {
            [questKeys.name] = "Ashenvale Mission XI: Fool's Gold Dust",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Fool's Gold Dust in the Ashenvale Nightmare Incursions and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219445}}},
        },
        [81779] = {
            [questKeys.name] = "Ashenvale Mission XII: Dream-Infused Dragonscale",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Dream-Infused Dragonscale in the Ashenvale Nightmare Incursions and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219446}}},
        },
        [81780] = {
            [questKeys.name] = "Ashenvale Mission XIII: Defeat Larsera",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Larsera in the Ashenvale Nightmare Incursion outside the central ruin in Forest Song and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221265}}},
        },
        [81781] = {
            [questKeys.name] = "Ashenvale Mission XIV: Defeat Zalius",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Zalius in the Ashenvale Nightmare Incursion at the base of the ziggurat in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221266}}},
        },
        [81782] = {
            [questKeys.name] = "Ashenvale Mission XV: Defeat Shredder 9000",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Shredder 9000 in the Ashenvale Nightmare Incursion near the lumber cranes in Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221267}}},
        },
        [81783] = {
            [questKeys.name] = "Ashenvale Mission XVI: Rescue Alyssian Windcaller",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Alyssian Windcaller from the Ashenvale Nightmare Incursion at the base of the watch tower in the Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221270}}},
        },
        [81784] = {
            [questKeys.name] = "Ashenvale Mission XVII: Rescue Doran Dreambough",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Doran Dreambough from the Ashenvale Nightmare Incursion at the moonlit gazebo in Forest Song and return to Field Captain Hannalah. A quest."},
            [questKeys.objectives] = {{{221268}}},
        },
        [81785] = {
            [questKeys.name] = "Ashenvale Mission XVIII: Rescue Maseara Autumnmoon",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Maseara Autumnmoon from the Ashenvale Nightmare Incursion at the southeast tent cluster in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = {{{221269}}},
        },
        [81786] = {
            [questKeys.name] = "Hinterlands Mission I: Defeat Moonkin",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 20 Fallen Moonkin in the Hinterlands Nightmare Incursion at Skulk Rock and return to Field Captain Korlian."},
            [questKeys.objectives] = {{{221330}}},
        },
        [81787] = {
            [questKeys.name] = "Hinterlands Mission II: Defeat Giant Turtles",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 20 Dreamwater Visejaw in the Hinterlands Nightmare Incursion at Shaol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {{{221328}}},
        },
        [81788] = {
            [questKeys.name] = "Hinterlands Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Wrath Whelps and 3 Wyrmkin Starhunters in the Hinterlands Nightmare Incursion at Agol'watha and return to Field Captain Korlian. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221326},{221325}}},
        },
        [81789] = {
            [questKeys.name] = "Hinterlands Mission IV: Dragon Intelligence",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Laninar in the Hinterlands Nightmare Incursion at the archway in Agol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219928}}},
        },
        [81790] = {
            [questKeys.name] = "Materials of Significance",
            [questKeys.startedBy] = {{221636}},
            [questKeys.finishedBy] = {{221636}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Locate the materials listed in Gregory's Note and return them to Gregory at the source of Bloodvenom Falls in Felwood."},
            [questKeys.objectives] = {nil,nil,{{220166},{220167},{220168},{220169},{220170}}},
        },
        [81801] = {
            [questKeys.name] = "Return to the Arena",
            [questKeys.startedBy] = {{221400}},
            [questKeys.finishedBy] = {{220984}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Return to Fizbuz Mithril in Gadgetzan, Tanaris."},
            [questKeys.objectives] = nil,
        },
        [81817] = {
            [questKeys.name] = "Hinterlands Mission V: Turtle Intelligence",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Sanathel in the Hinterlands Nightmare Incursion behind the drum in Shaol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219937}}},
        },
        [81820] = {
            [questKeys.name] = "Hinterlands Mission VI: Moonkin Intelligence",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Valori in the Hinterlands Nightmare Incursion at the underground lake in Skulk Rock and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219938}}},
        },
        [81826] = {
            [questKeys.name] = "Hinterlands Mission VII: Recover Star-Touched Dragonegg",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Star-Touched Dragonegg in the Hinterlands Nightmare Incursion from the central hut at Agol'wath and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219488}}},
        },
        [81830] = {
            [questKeys.name] = "Hinterlands Mission VIII: Recover Elunar Relic",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover an Elunar Relic in the Hinterlands Nightmare Incursion from the high ledge inside Skulk Rock and return to Field Captain Korlian. Rewards Emerald Chip."},
            [questKeys.objectives] = {nil,nil,{{219490}}},
        },
        [81832] = {
            [questKeys.name] = "Hinterlands Mission IX: Recover Dreampearl",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Dreampearl in the Hinterlands Nightmare Incursion from a snake fountain at Shaol'watha and return to Field Captain Korlian. Rewards Emerald Chip."},
            [questKeys.objectives] = {nil,nil,{{219491}}},
        },
        [81833] = {
            [questKeys.name] = "Hinterlands Mission X: Star Lotus",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Star Lotus in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219454}}},
        },
        [81834] = {
            [questKeys.name] = "Hinterlands Mission XI: Starsilver Ore",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Starsilver Ore in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219486}}},
        },
        [81835] = {
            [questKeys.name] = "Hinterlands Mission XII: Starshells",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Sharshells in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219487}}},
        },
        [81837] = {
            [questKeys.name] = "Hinterlands Mission XIII: Defeat Florius",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Florius in the Hinterlands Nightmare Incursion at the main courtyard in Agol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {{{221331}}},
        },
        [81838] = {
            [questKeys.name] = "Hinterlands Mission XIV: Defeat Doomkin",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat the Doomkin in the Hinterlands Nightmare Incursion on the deep ledge inside Skulk Rock and return to Field Captain Korlian. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221333}}},
        },
        [81839] = {
            [questKeys.name] = "Hinterlands Mission XV: Defeat Ghamoo-Raja",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Ghamoo-Raja in the Hinterlands Nightmare Incursion in the courtyard at Shaol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {{{221334}}},
        },
        [81850] = {
            [questKeys.name] = "Hinterlands Mission XVI: Rescue Elianar Shadowdrinker",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Elianar Shadowdrinker from the Hinterlands Nightmare Incursion at the troll fortification near Agol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {{{221335}}},
        },
        [81851] = {
            [questKeys.name] = "Hinterlands Mission XVII: Rescue Serlina Starbright",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Serlina Starbright from the Hinterlands Nightmare Incursion at the troll fortification nearest Shol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {{{221336}}},
        },
        [81852] = {
            [questKeys.name] = "Hinterlands Mission XVIII: Rescue Veanna Cloudsleeper",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Veanna Cloudsleeper from the Hinterlands Nightmare Incursion in the hammock above Skulk Rock and return to Field Captain Korlian. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221337}}},
        },
        [81855] = {
            [questKeys.name] = "Feralas Mission I: Defeat Children of Cenarius",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Lost Daughters and 10 Vengeful Sons in the Feralas Nightmare Incursion at the Twin Colossals and return to Field Captain Arunnel. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221375},{221377}}},
        },
        [81856] = {
            [questKeys.name] = "Feralas Mission II: Defeat Harpies",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Dreamspring Roguefeathers and 10 Dreamspring Stormcallers in the Feralas Nightmare Incursion at the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = {{{221370},{221371}}},
        },
        [81857] = {
            [questKeys.name] = "Feralas Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Frenzied Whelps and 3 Wyrmkin Berserkers in the Feralas Nightmare Incursion at Oneiros and return to Field Captain Arunnel. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221369},{221367}}},
        },
        [81858] = {
            [questKeys.name] = "Feralas Mission IV: Dragon Intelligence",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Sheldryn in the Feralas Nightmare Incursion at the southernmost ruins in Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219957}}},
        },
        [81859] = {
            [questKeys.name] = "Feralas Mission V: Cenarion Intelligence",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Gorlas in the Feralas Nightmare Incursion near the waterfall at the Twin Colossals and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219958}}},
        },
        [81860] = {
            [questKeys.name] = "Feralas Mission VI: Harpy Intelligence",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Anadelle in the Feralas Nightmare Incursion at the broken gazebo in the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219959}}},
        },
        [81861] = {
            [questKeys.name] = "Feralas Mission VII: Recover Moonglow Dragonegg",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Moonglow Dragonegg in the Feralas Nightmare Incursion from the gazebo at Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219520}}},
        },
        [81863] = {
            [questKeys.name] = "Feralas Mission VIII: Recover Keeper's Notes",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Mad Keeper's Notes in the Feralas Nightmare Incursion from the east slope of the west colossal at the Twin Colossals and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219519}}},
        },
        [81864] = {
            [questKeys.name] = "Feralas Mission IX: Recover Harpy Screed",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Harpy Screed in the Feralas Nightmare Incursion from the southwestern gazebo at the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219518}}},
        },
        [81865] = {
            [questKeys.name] = "Feralas Mission X: Moonroot",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Moonroot in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219514}}},
        },
        [81866] = {
            [questKeys.name] = "Feralas Mission XI: Greater Moonstone",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Greater Moonstone in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219515}}},
        },
        [81867] = {
            [questKeys.name] = "Feralas Mission XII: Greater Moondragon Scales",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Moondragon Scales in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219517}}},
        },
        [81868] = {
            [questKeys.name] = "Feralas Mission XIII: Defeat Tyrannikus",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Tyrannikus in the Feralas Nightmare Incursion at the ruined temple in Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = {{{221393}}},
        },
        [81870] = {
            [questKeys.name] = "Feralas Mission XIV: Defeat Alondrius",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Alondrius in the Feralas Nightmare Incursion patrolling the road at the Twin Colossals and return to Field Captain Arunnel. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221389}}},
        },
        [81871] = {
            [questKeys.name] = "Feralas Mission XV: Defeat Slirena",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Slirena in the Feralas Nightmare Incursion near the ziggurat in the Ruins of Ravenwind and return to Field Captain Arunnel. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221391}}},
        },
        [81872] = {
            [questKeys.name] = "Feralas Mission XVI: Rescue Mellias Earthtender",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Mellias Earthtender from the Feralas Nightmare Incursion at the stairs by Jademir Lake in Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = {{{221395}}},
        },
        [81873] = {
            [questKeys.name] = "Feralas Mission XVII: Rescue Nerene Brooksinger",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Nerene Brooksinger from the Feralas Nightmare Incursion at the campfire at the Twin Colossals and return to Field Captain Arunnel. Rewards Emerald Chip."},
            [questKeys.objectives] = {{{221398}}},
        },
        [81874] = {
            [questKeys.name] = "Feralas Mission XVIII: Rescue Jamniss Treemender",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Jamnice Treemender from the Feralas Nightmare Incursion at the northern edge of the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = {{{221399}}},
        },
        [81877] = {
            [questKeys.name] = "Fight Night",
            [questKeys.startedBy] = {{220984}},
            [questKeys.finishedBy] = {{220984}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Claim victory in the Gadgetzan Arena."},
            [questKeys.objectives] = nil,
        },
        [81885] = {
            [questKeys.name] = "The Ritual",
            [questKeys.startedBy] = {{221587}},
            [questKeys.finishedBy] = {{221587}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Gregory to begin the ritual."},
            [questKeys.objectives] = {{{221838}}},
        },
        [81900] = {
            [questKeys.name] = "The Burning Beast",
            [questKeys.startedBy] = {nil,{441061}},
            [questKeys.finishedBy] = {{7506}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find an expert on the beasts of the Blasted Lands."},
            [questKeys.objectives] = nil,
        },
        [81917] = {
            [questKeys.name] = "Chains That Bind",
            [questKeys.startedBy] = {{7506}},
            [questKeys.finishedBy] = {{7506}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring 5 infernal chain links to Bloodmage Lynnore in the Blasted Lands."},
            [questKeys.objectives] = {nil,nil,{{220214}}},
        },
        [81919] = {
            [questKeys.name] = "Brought to Heel",
            [questKeys.startedBy] = {{7506}},
            [questKeys.finishedBy] = {{7506}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring the fel lifeblood of Calefactus the Unleashed to Bloodmage Lynnore in the Blasted Lands."},
            [questKeys.objectives] = {nil,nil,{{220213}}},
        },
        [81924] = {
            [questKeys.name] = "Wisdom of the Guardians",
            [questKeys.startedBy] = {{221985}},
            [questKeys.finishedBy] = {{221985}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Prove yourself to the guardian spirits of Feralas, Azshara, and the Hinterlands, then return to Tyrisius in Feralas."},
            [questKeys.objectives] = {{{221935},{221933},{221928}}},
        },
        [81944] = {
            [questKeys.name] = "A Newly Discovered Purpose...",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{214529}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"I... cannot explain this, &lt;race&gt;, &nbsp;but I think I have something you need. I came to this land to seek knowledge, and that search led me up the mountain over yonder to a giant stone of light, fallen from the sky. In my contemplation at the stone, An'she gifted me with a great many things. One was a sense of new purpose. Another of which was a vision of you and me, here, having this conversation. I think I gave you this.Please, take this totem. Use it well in service of An'she... in service of the light."},
            [questKeys.objectives] = nil,
        },
        [81947] = {
            [questKeys.name] = "Sanguine Sorcery",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220345}}},
        },
        [81949] = {
            [questKeys.name] = "Legends of the Tidesages",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220346}}},
        },
        [81951] = {
            [questKeys.name] = "The Liminal and the Arcane",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220347}}},
        },
        [81952] = {
            [questKeys.name] = "Everyday Etiquette",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220348}}},
        },
        [81953] = {
            [questKeys.name] = "Stonewrought Design",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220349}}},
        },
        [81954] = {
            [questKeys.name] = "Venomous Journeys",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220350}}},
        },
        [81955] = {
            [questKeys.name] = "A Mind of Metal",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220352}}},
        },
        [81956] = {
            [questKeys.name] = "Conjurer's Codex",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220353}}},
        },
        [81960] = {
            [questKeys.name] = "Clarifying Air",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222289}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Air Sapta."},
            [questKeys.objectives] = {{{222232}}},
        },
        [81967] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [81968] = {
            [questKeys.name] = "Answering Air's Call",
            [questKeys.startedBy] = {{222289}},
            [questKeys.finishedBy] = {{222289}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Air to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{220525},{220375}}},
        },
        [81974] = {
            [questKeys.name] = "More Junk for Ziri",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{217689}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk with Ziri \"The Wrench\" Littlesprocket in Gnomeregan."},
            [questKeys.objectives] = {{{217689}}},
        },
        [81975] = {
            [questKeys.name] = "A Troubling Exchange",
            [questKeys.startedBy] = {{217689}},
            [questKeys.finishedBy] = {{217689}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Ziri."},
            [questKeys.objectives] = nil,
        },
        [81986] = {
            [questKeys.name] = "Waking the Nightmare",
            [questKeys.startedBy] = {{222188}},
            [questKeys.finishedBy] = {{222188}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Destroy the Nightmare Amalgamation and bring the Shadowy Figure any loot you find."},
            [questKeys.objectives] = {{{222198}}},
        },
        [81987] = {
            [questKeys.name] = "Goblin Solutions",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 5 Goblin Land Mines to Maximillian \"The Greaser\" in the Shimmering Flat."},
            [questKeys.objectives] = {nil,nil,{{4395}}},
        },
        [82001] = {
            [questKeys.name] = "Require Gnomish Problems",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Horn of a Thunderstomp Stegodon to Maximillian \"The Greaser\"."},
            [questKeys.objectives] = {nil,nil,{{220916}}},
        },
        [82002] = {
            [questKeys.name] = "Whats Red and Smells like Paint?",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Head to Hearthglen and find a Box of Scarlet Dye."},
            [questKeys.objectives] = {nil,nil,{{220917}}},
        },
        [82003] = {
            [questKeys.name] = "Victory Lap For the Goblins!",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222316}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Fizzbizz Coppercoil about getting a pay out."},
            [questKeys.objectives] = nil,
        },
        [82004] = {
            [questKeys.name] = "Hush Money",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Accept the Bribe from Fizzbizz Coppercoil."},
            [questKeys.objectives] = nil,
        },
        [82008] = {
            [questKeys.name] = "Gnomish Solutions",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Fizzbizz Coppercoil 2 Gnomish Harm Prevention Belts."},
            [questKeys.objectives] = {nil,nil,{{10721}}},
        },
        [82009] = {
            [questKeys.name] = "Require Goblin Problems",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Fizzbizz Coppercoil a Thunderstomp Stegodon Horn."},
            [questKeys.objectives] = {nil,nil,{{220916}}},
        },
        [82010] = {
            [questKeys.name] = "Watering Down the Competition",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Go to Hearthglen and find a Box of Scarlet Dye."},
            [questKeys.objectives] = {nil,nil,{{220917}}},
        },
        [82011] = {
            [questKeys.name] = "Victory Lap for the Gnomes!",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222261}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Maximillian \"The Greaser\"."},
            [questKeys.objectives] = nil,
        },
        [82013] = {
            [questKeys.name] = "Hush Money",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Accept the bribe from Maximillian \"The Greaser\"."},
            [questKeys.objectives] = nil,
        },
        [82016] = {
            [questKeys.name] = "Atal'ai Potent Potables",
            [questKeys.startedBy] = {{222413}},
            [questKeys.finishedBy] = {{222413}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I offer quite a deal for you mon! Bring me mojo found only from de Atal'ai people, and I make you a proposition: power beyond your wildest imagination. Be warned, mon, this power can only be used de swamps it is found from. Dey say de Atal'ai practice forbidden hexcraft, and I might know a bit about 'em. Sound good? Do you want to make a trade?"},
            [questKeys.objectives] = {nil,nil,{{221312}}},
        },
        [82017] = {
            [questKeys.name] = "An Amalagamation of Nightmares",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Loganaar in Moonglade."},
            [questKeys.objectives] = {{{12042}}},
        },
        [82018] = {
            [questKeys.name] = "Itharius",
            [questKeys.startedBy] = {{12042}},
            [questKeys.finishedBy] = {{5353}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Itharius somewhere in the Swamp of Sorrows."},
            [questKeys.objectives] = {{{5353}}},
        },
        [82019] = {
            [questKeys.name] = "Going Under",
            [questKeys.startedBy] = {{5353}},
            [questKeys.finishedBy] = {{5353}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find out more about what is happening in the Temple of Atal'Hakkar."},
            [questKeys.objectives] = {{{223568}}},
        },
        [82020] = {
            [questKeys.name] = "Return to Moonglade",
            [questKeys.startedBy] = {{5353}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Loganaar in Moonglade."},
            [questKeys.objectives] = {{{12042}}},
        },
        [82021] = {
            [questKeys.name] = "A Fortuitous Turn of Events",
            [questKeys.startedBy] = {{222188}},
            [questKeys.finishedBy] = {{222188}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Listen to what the Shadowy Figure has to say."},
            [questKeys.objectives] = {{{222225}}},
        },
        [82022] = {
            [questKeys.name] = "The Bad News...",
            [questKeys.startedBy] = {{222188}},
            [questKeys.finishedBy] = {{222188}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the adventurer that the Shadowy Figure described, and recover the Void-Powered Vambraces."},
            [questKeys.objectives] = {nil,nil,{{220964}}},
        },
        [82023] = {
            [questKeys.name] = "The Lost Vambraces",
            [questKeys.startedBy] = {{222444}},
            [questKeys.finishedBy] = {{222451}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the lair of the \"Beast\" that the injured gnome was referring to and recover the Void-Powered Vambraces."},
            [questKeys.objectives] = nil,
        },
        [82043] = {
            [questKeys.name] = "The Wild Gods",
            [questKeys.startedBy] = {{222408}},
            [questKeys.finishedBy] = {{222522}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect a Wildwhisper Draught from Jintha'alor in the Hinterlands, then use it at the top of Razorfen Downs to speak to the Spirit of Agamaggan."},
            [questKeys.objectives] = nil,
        },
        [82044] = {
            [questKeys.name] = "The Wild Gods",
            [questKeys.startedBy] = {{222522}},
            [questKeys.finishedBy] = {{222408}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Deliver Wild Offerings to the Shadowtooth Emissary in Felwood. Use Agamaggan's Roar on a Delirious Ancient and defeat it to earn Wild Offerings."},
            [questKeys.objectives] = {nil,nil,{{221262}}},
        },
        [82055] = {
            [questKeys.name] = "Darkmoon Dunes Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Dunes Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = nil,
        },
        [82056] = {
            [questKeys.name] = "Darkmoon Nightmares Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Nightmares Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Always up to date."},
            [questKeys.objectives] = nil,
        },
        [82057] = {
            [questKeys.name] = "Darkmoon Plagues Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Plagues Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = nil,
        },
        [82058] = {
            [questKeys.name] = "Darkmoon Wilds Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Wilds Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = nil,
        },
        [82062] = {
            [questKeys.name] = "Ever After",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222530}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 56,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;You're handed a small parcel with a shirt neatly folded over it.&gt;."},
            [questKeys.objectives] = nil,
        },
        [82068] = {
            [questKeys.name] = "Fight the Nightmare Incursions",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479,221480}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Complete a Nightmare Incursion mission in Feralas or Hinterlands and then report to Field Captain Korlian or Field Captain Arunnel. Rewards ."},
            [questKeys.objectives] = {{{221479}}},
        },
        [82071] = {
            [questKeys.name] = "Purifying Fire",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222617}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Fire Sapta."},
            [questKeys.objectives] = {{{222620}}},
        },
        [82072] = {
            [questKeys.name] = "Purging Earth",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222623}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Earth Sapta."},
            [questKeys.objectives] = {{{222625}}},
        },
        [82073] = {
            [questKeys.name] = "Cleansing Water",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222005}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Water Sapta."},
            [questKeys.objectives] = {{{222004}}},
        },
        [82074] = {
            [questKeys.name] = "Answering Fire's Call",
            [questKeys.startedBy] = {{222617}},
            [questKeys.finishedBy] = {{222617}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Fire to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{221356},{221353}}},
        },
        [82075] = {
            [questKeys.name] = "Answering Earth's Call",
            [questKeys.startedBy] = {{222623}},
            [questKeys.finishedBy] = {{222623}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Earth to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{221358},{221355}}},
        },
        [82076] = {
            [questKeys.name] = "Answering Water's Call",
            [questKeys.startedBy] = {{222005}},
            [questKeys.finishedBy] = {{222005}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Water to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{221357},{221354}}},
        },
        [82081] = {
            [questKeys.name] = "A Broken Ritual",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14875}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Scapula of the Fallen Avatar to Molthor in Yojamba Isle."},
            [questKeys.objectives] = nil,
        },
        [82083] = {
            [questKeys.name] = "A Broken Ritual",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14875}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Scapula of the Fallen Avatar to Molthor in Yojamba Isle."},
            [questKeys.objectives] = nil,
        },
        [82084] = {
            [questKeys.name] = "A Lesson in Literacy",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 42,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Your progress in the arcane arts has been exemplary, &lt;name&gt;. I think you are ready to author a spellbook of your own.Let's see... a quill from the Owlbeasts of the Hinterlands, and ink derived from silithid resin... yes, that will do. And for the pages, the finest Farraki Papyrus!"},
            [questKeys.objectives] = {nil,nil,{{221359},{221361},{221360}}},
        },
        [82086] = {
            [questKeys.name] = "A Lesson in Literacy",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 42,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{221359},{221361},{221360}}},
        },
        [82089] = {
            [questKeys.name] = "Master of Transmutation",
            [questKeys.startedBy] = {{222772}},
            [questKeys.finishedBy] = {{222772}},
            [questKeys.requiredLevel] = 35,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Crimeon Lablade three Arcanite Bars."},
            [questKeys.objectives] = {nil,nil,{{12360}}},
        },
        [82090] = {
            [questKeys.name] = "Mixology For Fun and Profit",
            [questKeys.startedBy] = {{222763}},
            [questKeys.finishedBy] = {{222763}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Mixmaster Blix 10 Invisibility Potions, 10 Elixir of Demonslaying, and 5 Elixir of Sages."},
            [questKeys.objectives] = {nil,nil,{{9224},{9172},{13447}}},
        },
        [82093] = {
            [questKeys.name] = "Jungle Durian",
            [questKeys.startedBy] = {{222413}},
            [questKeys.finishedBy] = {{222413}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The bold and pungent smelling fruit will keep your spirits high while you traverse through the Swamp of Sorrows and explore the Temple of Atal'Hakkar. Don't let the odor fool you mon, this is a prized fruit of my people! If you bring me back something enticing from your adventures, I'll make it worth your while, mon. A bundle of our finest durian for your troubles! Shall we make a deal?"},
            [questKeys.objectives] = {nil,nil,{{221312}}},
        },
        [82094] = {
            [questKeys.name] = "Signets of the Lost Temple",
            [questKeys.startedBy] = {{222413}},
            [questKeys.finishedBy] = {{222413}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For de most powerful adventurer, I offer de most powerful trades. I have somethin' that enhances your shoulder items, power from de Atal'ai themselves! &lt;name&gt;, if you have mojo found by the strongest of dere Atal'ai in da temple, I will make it worth your while. Let's not be too hasty now, I offer da fairest deals..."},
            [questKeys.objectives] = {nil,nil,{{221313}}},
        },
        [82095] = {
            [questKeys.name] = "The God Hakkar",
            [questKeys.startedBy] = {{8579}},
            [questKeys.finishedBy] = {{8579}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Filled Egg of Hakkar to Yeh'kinya in Tanaris."},
            [questKeys.objectives] = {nil,nil,{{10662},{10663},{10465}}},
        },
        [82096] = {
            [questKeys.name] = "Into the Depths",
            [questKeys.startedBy] = {{7771}},
            [questKeys.finishedBy] = {nil,{148836}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the Altar of Hakkar in the Sunken Temple in Swamp of Sorrows."},
            [questKeys.objectives] = nil,
        },
        [82097] = {
            [questKeys.name] = "Secret of the Circle",
            [questKeys.startedBy] = {{7771}},
            [questKeys.finishedBy] = {nil,{448042}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel into the Sunken Temple and discover the secret hidden in the circle of statues."},
            [questKeys.objectives] = nil,
        },
        [82098] = {
            [questKeys.name] = "Into The Temple of Atal'Hakkar",
            [questKeys.startedBy] = {{5384}},
            [questKeys.finishedBy] = {{5384}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Atal'ai Tablets for Brohann Caskbelly in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{6288}}},
        },
        [82099] = {
            [questKeys.name] = "Haze of Evil",
            [questKeys.startedBy] = {{7775}},
            [questKeys.finishedBy] = {{9119}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect 5 samples of Atal'ai Haze, then return to Muigin in Un'Goro Crater."},
            [questKeys.objectives] = {nil,nil,{{11318}}},
        },
        [82100] = {
            [questKeys.name] = "The Temple of Atal'Hakkar",
            [questKeys.startedBy] = {{1443}},
            [questKeys.finishedBy] = {{1443}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect 20 Fetishes of Hakkar and bring them to Fel'Zerul in Stonard."},
            [questKeys.objectives] = {nil,nil,{{6181}}},
        },
        [82101] = {
            [questKeys.name] = "Zapper Fuel",
            [questKeys.startedBy] = {{8496}},
            [questKeys.finishedBy] = {{9118}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Deliver the Unloaded Zapper and 5 samples of Atal'ai Haze to Larion in Marshal's Refuge."},
            [questKeys.objectives] = {nil,nil,{{11318}}},
        },
        [82102] = {
            [questKeys.name] = "The Essence of Eranikus",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{148512}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Place the Essence of Eranikus in the Essence Font located in this lair in the Sunken Temple."},
            [questKeys.objectives] = nil,
        },
        [82104] = {
            [questKeys.name] = "Jammal'an the Prophet",
            [questKeys.startedBy] = {{5598}},
            [questKeys.finishedBy] = {{5598}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Atal'ai Exile in The Hinterlands wants the Head of Jammal'an."},
            [questKeys.objectives] = {nil,nil,{{6212}}},
        },
        [82106] = {
            [questKeys.name] = "Forging the Mightstone",
            [questKeys.startedBy] = {{10838}},
            [questKeys.finishedBy] = {{10838}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bring the voodoo feathers to Ashlam Valorfist."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82107] = {
            [questKeys.name] = "Voodoo Feathers",
            [questKeys.startedBy] = {{7572}},
            [questKeys.finishedBy] = {{7572}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring the Voodoo Feathers from the trolls in the Sunken Temple to the Fallen Hero of the Horde."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82108] = {
            [questKeys.name] = "The Green Drake",
            [questKeys.startedBy] = {{8405}},
            [questKeys.finishedBy] = {{8405}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring the Tooth of Morphaz to Ogtinc in Azshara.  Ogtinc resides atop the cliffs northeast the Ruins of Eldarath."},
            [questKeys.objectives] = {nil,nil,{{20019}}},
        },
        [82110] = {
            [questKeys.name] = "The Azure Key",
            [questKeys.startedBy] = {{8379}},
            [questKeys.finishedBy] = {{6768}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Return the Azure Key to Lord Jorach Ravenholdt."},
            [questKeys.objectives] = {nil,nil,{{20022}}},
        },
        [82111] = {
            [questKeys.name] = "Blood of Morphaz",
            [questKeys.startedBy] = {{8405}},
            [questKeys.finishedBy] = {{10922}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Morphaz in the sunken temple of Atal'Hakkar, and return his blood to Greta Mosshoof in Felwood.  The entrance to the sunken temple can be found in the Swamp of Sorrows."},
            [questKeys.objectives] = {nil,nil,{{20025}}},
        },
        [82112] = {
            [questKeys.name] = "A Better Ingredient",
            [questKeys.startedBy] = {{9619}},
            [questKeys.finishedBy] = {{9619}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Retrieve a Putrid Vine from the guardian at the bottom of the Sunken Temple and return to Torwa Pathfinder."},
            [questKeys.objectives] = {nil,nil,{{22444}}},
        },
        [82113] = {
            [questKeys.name] = "Da Voodoo",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Bring the voodoo feathers to Bath'rah the Windwatcher."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82114] = {
            [questKeys.name] = "Destroy Morphaz",
            [questKeys.startedBy] = {{8379}},
            [questKeys.finishedBy] = {{8379}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Retrieve the Arcane Shard from Morphaz and return to Archmage Xylem."},
            [questKeys.objectives] = {nil,nil,{{20085}}},
        },
        [82115] = {
            [questKeys.name] = "Trolls of a Feather",
            [questKeys.startedBy] = {{14470}},
            [questKeys.finishedBy] = {{14470}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Bring a total of 6 Voodoo Feathers from the trolls in sunken temple."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82135] = {
            [questKeys.name] = "The Price of Hope",
            [questKeys.startedBy] = {{221587}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bring the Mannoroc Echoing Orb to Katherine the Pure in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [82208] = {
            [questKeys.name] = "Greater Friend of the Library",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [82209] = {
            [questKeys.name] = "Water Pouch Bounty",
            [questKeys.startedBy] = {{7408}},
            [questKeys.finishedBy] = {{7408}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 44,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Back again, &lt;name&gt;? &nbsp;If you have five more Wastewander water pouches, then I have a care package with your name on it!"},
            [questKeys.objectives] = {nil,nil,{{8483}}},
        },
        [82210] = {
            [questKeys.name] = "Troll Necklace Bounty",
            [questKeys.startedBy] = {{7884}},
            [questKeys.finishedBy] = {{7884}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You've done it already, but we will continue to accept any troll tribal necklaces you find and are willing to turn in. &nbsp;By turning them in to me, you'll continue to improve your standing amongst the Wildhammers; if you're willing to fight for us, then we'll be willing to fight for you!I need five troll tribal necklaces for them to count, &lt;name&gt;."},
            [questKeys.objectives] = {nil,nil,{{9259}}},
        },
        [82271] = {
            [questKeys.name] = "More Glowing Scorpid Blood",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"That scorpid blood is working out great, &lt;name&gt;! &nbsp;It's amazing how a little sparkle and shine can create a prized bauble out of an otherwise piece of junk. &nbsp;The patrons love the stuff, and love is what it's all about, don't you think...You've been a big help to me, &lt;name&gt;, and although I don't have a great need for more glowing scorpid blood, if you bring me more then I'll still trade you some tickets."},
            [questKeys.objectives] = {nil,nil,{{19933}}},
        },
        [82272] = {
            [questKeys.name] = "Glowing Scorpid Blood",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"In all my time working the Faire, I've learned a lot of things about customers. &nbsp;Here's one of those nuggets of wisdom: customers love stuff that glows! &nbsp;It doesn't matter what it is - you could take a broken chair leg and make it glow, and every child will come from miles around to get one!So, &lt;name&gt;, I need glowing scorpid blood. &nbsp;You can find it from the scorpids of Sillithus, or the Blasted Lands, or the Burning Steppes."},
            [questKeys.objectives] = {nil,nil,{{19933}}},
        },
        [82273] = {
            [questKeys.name] = "More Bat Eyes",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;name&gt;, the attraction I'm designing will be the scariest event since Gnomeregan was overrun! &nbsp;And it's largely thanks to you and all the baubles you've brought me. &nbsp;Many, many thanks!I don't need much else, but... if you bring me more evil bat eyes from the bats of the Eastern Plaguelands... I might have more Darkmoon Faire tickets for you."},
            [questKeys.objectives] = {nil,nil,{{11404}}},
        },
        [82274] = {
            [questKeys.name] = "Evil Bat Eyes",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you ever find yourself wandering in a cave, late at night, looking for adventure? &nbsp;You do? &nbsp;Really? &nbsp;Well, then you've seen the creepy eyes of bats staring at you from high up, waiting for you to let down your guard so they can suck your blood!Scary thought, don't you think? &nbsp;Of course! &nbsp;It's no doubt that bat eyes are scary!Will you bring me some evil bat eyes, &lt;name&gt;? &nbsp;I want them for... something I'm designing. &nbsp;Something scary.You can get them from the bats of the Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{11404}}},
        },
        [82275] = {
            [questKeys.name] = "Big Black Mace",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For my act as the strongest woman alive, I plan to accept items from the audience and smash them with a big, black mace!Can you make me a big black mace, &lt;name&gt;?"},
            [questKeys.objectives] = {nil,nil,{{7945}}},
        },
        [82276] = {
            [questKeys.name] = "Rituals of Strength",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;name&gt;, in my quest to become the strongest woman alive, I have traveled the world and learned muscle building secrets from distant weight masters, strength gurus, and ancient manuals. &nbsp;I now know forbidden exercises that would kill the weak and cripple the uninitiated!These feats of strength and conditioning require training with the densest of grinding stones. &nbsp;&lt;name&gt;, can you find or make some grinding stones and bring them to me? &nbsp;I'll give you tickets if you do..."},
            [questKeys.objectives] = {nil,nil,{{12644}}},
        },
        [82277] = {
            [questKeys.name] = "More Dense Grinding Stones",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;name&gt;, thank you for all the help you've given me. &nbsp;I really can't thank you enough!Although my need is no longer great... if you bring me more dense grinding stones, I still have more Darkmoon Faire tickets for you."},
            [questKeys.objectives] = {nil,nil,{{12644}}},
        },
        [82278] = {
            [questKeys.name] = "More Thorium Widgets",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;name&gt;, you have been so good to us, bringing me goods without tiring. &nbsp;You have my eternal thanks!Although our need for Thorium widgets is not as great as it was, you may still bring them to me and I will gladly trade them for Darkmoon Faire tickets."},
            [questKeys.objectives] = {nil,nil,{{15994}}},
        },
        [82279] = {
            [questKeys.name] = "Thorium Widget",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Yebb Nebblegear, like me, is working on a future attraction. &nbsp;So amazing is this attraction, says Nebb, that it will draw folks from across the world... and it will make us all very, very rich!He says he needs thorium widgets for its construction, and wants me to collect them for him. &nbsp;So what do you say, &lt;name&gt;? &nbsp;Do you know where to get Thorium widgets? &nbsp;If you're an engineer, can you make them? &nbsp;Do you want to trade them for Darkmoon Faire tickets?"},
            [questKeys.objectives] = {nil,nil,{{15994}}},
        },
        [82280] = {
            [questKeys.name] = "Mechanical Repair Kits",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The biggest reason I can't open up my booth is that... everything's broken! &nbsp;I need mechanical repair kits to fix all this stuff!Can you bring me those kits, &lt;name&gt;? &nbsp;I'll trade you... kits for Darkmoon Faire tickets. &nbsp;What do you say?"},
            [questKeys.objectives] = {nil,nil,{{11590}}},
        },
        [82281] = {
            [questKeys.name] = "More Armor Kits",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;name&gt;, I must thank you for all your help. &nbsp;I have plenty of supplies, through no small efforts on your part, but if you wish to bring me more armor kits, then I will gladly trade them for Darkmoon Faire tickets."},
            [questKeys.objectives] = {nil,nil,{{15564}}},
        },
        [82282] = {
            [questKeys.name] = "Armor Kits",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You might not realize this, but running a traveling carnival is costly! &nbsp;Everything wears down so fast it's a wonder we can turn a profit.Because of all those hidden costs, we're always looking for ways to maintain our equipment as cheaply as possible. &nbsp;Our tents, for instance, tear regularly but I've found that leather armor kits make great patches. &nbsp;Can you find and bring me some armor kits? That'll save us a bundle! &nbsp;Do that, and I have a fistful of Darkmoon Faire tickets for you..."},
            [questKeys.objectives] = {nil,nil,{{15564}}},
        },
        [82283] = {
            [questKeys.name] = "Crocolisk Boy and the Bearded Murloc",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Yebb is working on other attractions for his zoo, including wet, swampy abodes for a boy raised by crocolisks, and perhaps for a murloc. &nbsp;We will need nice, water-tight leggings so we won't get waterlogged during prop-ups and tear-downs. &nbsp;For that job, I think turtlescale leggings will do the trick.&lt;name&gt;, can you make those leggings? &nbsp;If you do, then a fat stack of Darkmoon Faire tickets will be your reward..."},
            [questKeys.objectives] = {nil,nil,{{8185}}},
        },
        [82301] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [82302] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [82303] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [82307] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{221008}}},
        },
        [82308] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{221009}}},
        },
        [82309] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214099,214101}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{221010}}},
        },
        [82316] = {
            [questKeys.name] = "Seven Eyes I Seek...",
            [questKeys.startedBy] = {{223590}},
            [questKeys.finishedBy] = {{223590}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Seven hidden eyes I seek... bring them to me and you too shall see."},
            [questKeys.objectives] = {nil,nil,{{223330},{223332},{223333},{223334},{223335},{223337},{223336}}},
        },
        [82323] = {
            [questKeys.name] = "Vibrant Plumes",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A person's imagination is an incredible thing. &nbsp;It can make the smallest hill seem like the largest mountain. &nbsp;It can make the most innocuous shadow appear cast by a horrible nightmare!We at the Darkmoon Faire let our visitor's imaginations blossom! &nbsp;But to help stretch their imaginations... sometimes we have to get tricky.I need vibrant plumes for one of my attractions. &nbsp;You can get them from the birds of the more dangerous areas of Azeroth. &nbsp;Bring me the plumes and many tickets will be yours!"},
            [questKeys.objectives] = {nil,nil,{{5117}}},
        },
        [82656] = {
            [questKeys.name] = "Wild Leather Vest",
            [questKeys.startedBy] = {{7854}},
            [questKeys.finishedBy] = {{7854}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Turtle Scale Breastplates, 2 Turtle Scale Gloves, and a Wildvine to Jangdor Swiftstrider in Camp Mojache."},
            [questKeys.objectives] = {nil,nil,{{8153},{217268},{217270}}},
        },
        [82657] = {
            [questKeys.name] = "Wild Leather Vest",
            [questKeys.startedBy] = {{7852}},
            [questKeys.finishedBy] = {{7852}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Turtle Scale Breastplates, 2 Turtle Scale Gloves, and a Wildvine to Pratt McGrubben in Feathermoon Stronghold."},
            [questKeys.objectives] = {nil,nil,{{8153},{217268},{217270}}},
        },
        [82662] = {
            [questKeys.name] = "The Way of the Weaponsmith",
            [questKeys.startedBy] = {{11146}},
            [questKeys.finishedBy] = {{11146}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To become a Weaponsmith, you must make the following items and return them to Ironus: 4 Moonsteel Broadswords, 4 Massive Iron Axes, 2 Heavy Mithril Axes, and 2 Big Black Maces."},
            [questKeys.objectives] = {nil,nil,{{217281},{3855},{7941},{7945}}},
        },
        [82665] = {
            [questKeys.name] = "The Way of the Weaponsmith",
            [questKeys.startedBy] = {{11178}},
            [questKeys.finishedBy] = {{11178}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To become a Weaponsmith, you must make the following items and return them to Borgosh: 4 Moonsteel Broadswords, 4 Massive Iron Axes, 2 Heavy Mithril Axes, and 2 Big Black Maces."},
            [questKeys.objectives] = {nil,nil,{{217281},{3855},{7941},{7945}}},
        },
        [82850] = {
            [questKeys.name] = "Fish Oil",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Fish Oil keeps the cogs of war turning! If you've got some for me, pal, I'll make it worth your while."},
            [questKeys.objectives] = {nil,nil,{{17058}}},
        },
        [82851] = {
            [questKeys.name] = "Dark Iron Ordinance",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Did ya know that in Dark Iron tradition, the Senate writes proposed laws on explosive shells? If the Emperor doesn't like the law... kaboom!Why are you lookin' at me like that? Don't you trust your ol' pal Grizzby?"},
            [questKeys.objectives] = {nil,nil,{{210138}}},
        },
        [82853] = {
            [questKeys.name] = "Shredder Turbochargers",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"It's bad luck that shipping lanes back to Kezan are so unreliable these days. Back home you can get Turbochargers by the dozen for a few copper. Fallin' off the shelves at every machine shop. Can't get rid of 'em fast enough.Anyway, if you've got a few Turbochargers you don't know what to do with, I'd be happy to take them off your hands!"},
            [questKeys.objectives] = {nil,nil,{{210146}}},
        },
        [83188] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [83189] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [83190] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [83191] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [83192] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [83808] = {
            [questKeys.name] = "In a Bind",
            [questKeys.startedBy] = {{227672}},
            [questKeys.finishedBy] = {{227672}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Retrieve Squire Cuthbert's sword in the field to the south and return it to him."},
            [questKeys.objectives] = {nil,nil,{{226201}}},
        },
        [83822] = {
            [questKeys.name] = "The Fallen Knight",
            [questKeys.startedBy] = {{227672}},
            [questKeys.finishedBy] = {{227672}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Lead Squire Cuthbert to the body of the Fallen Knight you found earlier and help him burn the corpse. If you lose Squire Cuthbert he will make his way back to his hiding place in the barn at Dalson's Tears and wait for you there."},
            [questKeys.objectives] = {{{227705}}},
        },
        [83823] = {
            [questKeys.name] = "A Lesson in Violence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{227673}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Your squire has grown in skill adventuring alongside you!"},
            [questKeys.objectives] = {nil,nil,{{226122}}},
        },
        [83934] = {
            [questKeys.name] = "Show Me The Money!",
            [questKeys.startedBy] = {{227853}},
            [questKeys.finishedBy] = {{227853}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Tarnished Undermine Real to Pix Xizzix in Booty Bay."},
            [questKeys.objectives] = {nil,nil,{{226404}}},
        },
        [83935] = {
            [questKeys.name] = "Clearing the Path",
            [questKeys.startedBy] = {{227672}},
            [questKeys.finishedBy] = {{227672}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill 5 Blighted Zombies, 10 Skeletal Terrors, and 10 Rotting Cadavers to help clear a path for Squire Cuthbert to escape."},
            [questKeys.objectives] = {{{4475},{1785},{4474}}},
        },
        [83936] = {
            [questKeys.name] = "Dalton's Quest",
            [questKeys.startedBy] = {{227672}},
            [questKeys.finishedBy] = {{227672}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Squire Cuthbert to learn more about Sir Dalton's quest."},
            [questKeys.objectives] = {{{227856}}},
        },
        [84008] = {
            [questKeys.name] = "A Lesson in Grace",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{227464}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Your squire has grown in skill adventuring alongside you!"},
            [questKeys.objectives] = {nil,nil,{{226523}}},
        },
        [84011] = {
            [questKeys.name] = "More Star Lotus",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 53,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Star Lotus in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219454}}},
        },
        [84012] = {
            [questKeys.name] = "More Starsilver Ore",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 53,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Starsilver Ore in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219486}}},
        },
        [84013] = {
            [questKeys.name] = "More Starshells",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 53,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Starshells in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219487}}},
        },
        [84014] = {
            [questKeys.name] = "More Moonroot",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 53,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Moonroot in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219514}}},
        },
        [84015] = {
            [questKeys.name] = "More Greater Moonstones",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 53,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Greater Moonstones in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219515}}},
        },
        [84016] = {
            [questKeys.name] = "More Moondragon Scales",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 53,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Moondragon Scales in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219517}}},
        },
        [84017] = {
            [questKeys.name] = "A Time to Kill",
            [questKeys.startedBy] = {{227674}},
            [questKeys.finishedBy] = {{227674}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find Arkonos and end him."},
            [questKeys.objectives] = nil,
        },
        [84124] = {
            [questKeys.name] = "Legacy of Valor",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{410158}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Return to the Altar of Reverence."},
            [questKeys.objectives] = nil,
        },
        [84125] = {
            [questKeys.name] = "Close Enough To Touch",
            [questKeys.startedBy] = {{227674}},
            [questKeys.finishedBy] = {{227674}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill Shadowmages and Dread Weavers in the Noxious Glade and search their corpses for something that can help you break the shield protecting Arkonos."},
            [questKeys.objectives] = {nil,nil,{{227041}}},
        },
        [84126] = {
            [questKeys.name] = "Finish the Fight",
            [questKeys.startedBy] = {{227674}},
            [questKeys.finishedBy] = {{227674}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill Arkonos the Cursed."},
            [questKeys.objectives] = {{{227985}}},
        },
        [84135] = {
            [questKeys.name] = "Beach Bot",
            [questKeys.startedBy] = {nil,{456682}},
            [questKeys.finishedBy] = {nil,{456685}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Use a rock or something to dislodge parts of the mech."},
            [questKeys.objectives] = nil,
        },
        [84136] = {
            [questKeys.name] = "The Beast Master of Moonglade",
            [questKeys.startedBy] = {{227755}},
            [questKeys.finishedBy] = {{228176}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to the village of Nighthaven in Moonglade, on Kalimdor. Seek out the troll Banteazo, a hunter, and ask her for insight into beast mastery."},
            [questKeys.objectives] = nil,
        },
        [84137] = {
            [questKeys.name] = "Mechanical Romance",
            [questKeys.startedBy] = {nil,{456685}},
            [questKeys.finishedBy] = {{228956}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find a use for the Guided Buoyancy Accelerant."},
            [questKeys.objectives] = {nil,nil,{{226856}}},
        },
        [84138] = {
            [questKeys.name] = "Frosty Favors",
            [questKeys.startedBy] = {{228956}},
            [questKeys.finishedBy] = {{228216}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Explain the book situation to Doctor Jurgens' colleague, Numi, in Winterspring."},
            [questKeys.objectives] = nil,
        },
        [84146] = {
            [questKeys.name] = "Red Bag Blues",
            [questKeys.startedBy] = {{228216}},
            [questKeys.finishedBy] = {{218236}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Locate the Red Bag that Numi in Everlook lost in a zeppelin mishap over Burning Steppes."},
            [questKeys.objectives] = {{{228535}}},
        },
        [84147] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Wildheart Bracers to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226714}}},
        },
        [84148] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Beaststalker's Bindings to Deliana in Ironforge. A quest."},
            [questKeys.objectives] = {nil,nil,{{21928},{226717}}},
        },
        [84149] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Magister's Bindings to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226725}}},
        },
        [84150] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Lightforge Bracers to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226739}}},
        },
        [84151] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with 1 set of Devout Bracers to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226742}}},
        },
        [84152] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Shadowcraft Bracers to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226704}}},
        },
        [84153] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Dreadmist Bracers to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226759}}},
        },
        [84154] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Winterspring Blood Samples and 20 gold and bring them along with a set of Bracers of Valor to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{21928},{226766}}},
        },
        [84155] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Wildheart Bracers to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226714}}},
        },
        [84156] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Beaststalker's Bindings to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226717}}},
        },
        [84157] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Magister's Bindings to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226725}}},
        },
        [84158] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Devout Bracers to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226742}}},
        },
        [84159] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Shadowcraft Bracers to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226704}}},
        },
        [84160] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Bindings of the Elements to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226751}}},
        },
        [84161] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Dreadmist Bracers to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226759}}},
        },
        [84162] = {
            [questKeys.name] = "An Earnest Proposition",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire 15 Silithus Venom Samples and 20 gold and bring them along with a set of Bracers of Valor to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{22381},{226766}}},
        },
        [84163] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Wildheart Belt and a set of Wildheart Gloves Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226712},{226711}}},
        },
        [84164] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Beaststalker's Belt and a set of Beaststalker's Gloves to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226718},{226721}}},
        },
        [84165] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Magister's Belt and a set of Magister's Gloves to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226724},{226731}}},
        },
        [84166] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Lightforge Belt and a set of Lightforge Gauntlets to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226732},{226737}}},
        },
        [84167] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Devout Belt and a set of Devout Gloves to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226744},{226740}}},
        },
        [84168] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Shadowcraft Belt and a set of Shadowcraft Gloves to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226701},{226702}}},
        },
        [84169] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Dreadmist Belt and a set of Dreadmist Wraps to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226761},{226758}}},
        },
        [84170] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Belt of Valor and a set of Gauntlets of Valor to Deliana in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{226765},{226771}}},
        },
        [84171] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Wildheart Belt and a set of Wildheart Gloves to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226712},{226711}}},
        },
        [84172] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Beaststalker's Belt and a set of Beaststalker's Gloves to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226718},{226721}}},
        },
        [84173] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Magister's Belt and a set of Magister's Gloves to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226724},{226731}}},
        },
        [84174] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Devout Belt and a set of Devout Gloves to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226744},{226740}}},
        },
        [84175] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Shadowcraft Belt and a set of Shadowcraft Gloves to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226701},{226702}}},
        },
        [84176] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Cord of the Elements and a set of Gauntlets of the Elements to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226754},{226748}}},
        },
        [84177] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Dreadmist Belt and a set of Dreadmist Wraps to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226761},{226758}}},
        },
        [84178] = {
            [questKeys.name] = "Just Compensation",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Belt of Valor and a set of Gauntlets of Valor to Mokvar in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{226765},{226771}}},
        },
        [84179] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Wildheart Boots, a Wildheart Kilt and Wildheart Spaulders."},
            [questKeys.objectives] = {nil,nil,{{22047},{226713},{226709},{226710}}},
        },
        [84180] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Beaststalker's Boots, Beaststalker's Pants and Beaststalker's Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226722},{226719},{226716}}},
        },
        [84181] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Magister's Boots, Magister's Leggings and Magister's Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226730},{226727},{226726}}},
        },
        [84182] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Lightforge Boots, Lightforge Legplates and Lightforge Spaulders."},
            [questKeys.objectives] = {nil,nil,{{22047},{226738},{226736},{226735}}},
        },
        [84183] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Devout Sandals, Devout Skirt and Devout Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226743},{226747},{226741}}},
        },
        [84184] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Shadowcraft Boots, Shadowcraft Pants and Shadowcraft Spaulders."},
            [questKeys.objectives] = {nil,nil,{{22047},{226703},{226705},{226706}}},
        },
        [84185] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Dreadmist Sandals, Dreadmist Leggings and Dreadmist Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226763},{226760},{226756}}},
        },
        [84186] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Deliana in Ironforge with a set of Boots of Valor, Legplates of Valor and Spaulders of Valor."},
            [questKeys.objectives] = {nil,nil,{{22047},{226764},{226767},{226768}}},
        },
        [84187] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Wildheart Boots, a Wildheart Kilt and Wildheart Spaulders."},
            [questKeys.objectives] = {nil,nil,{{22047},{226713},{226709},{226710}}},
        },
        [84188] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Beaststalker's Boots, Beaststalker's Pants and Beaststalker's Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226722},{226719},{226716}}},
        },
        [84189] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Magister's Boots, Magister's Leggings and Magister's Mantle."},
            [questKeys.objectives] = {nil,nil,{{21986},{226730},{226727},{226726}}},
        },
        [84190] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Devout Sandals, Devout Skirt and Devout Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226743},{226747},{226741}}},
        },
        [84191] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of  Shadowcraft Boots, Shadowcraft Pants and Shadowcraft Spaulders."},
            [questKeys.objectives] = {nil,nil,{{22047},{226703},{226705},{226706}}},
        },
        [84192] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Boots of Elements, Kilt of Elements and Pauldrons of Elements."},
            [questKeys.objectives] = {nil,nil,{{22047},{226752},{226750},{226753}}},
        },
        [84193] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Dreadmist Sandals, Dreadmist Leggings and Dreadmist Mantle."},
            [questKeys.objectives] = {nil,nil,{{22047},{226763},{226760},{226756}}},
        },
        [84194] = {
            [questKeys.name] = "Anthion's Parting Words",
            [questKeys.startedBy] = {{16016}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Mokvar in Orgimmar with a set of Boots of Valor, Legplates of Valor and Spaulders of Valor."},
            [questKeys.objectives] = {nil,nil,{{22047},{226764},{226767},{226768}}},
        },
        [84195] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Wildheart Cowl and Wildheart Vest."},
            [questKeys.objectives] = {nil,nil,{{226708},{226715}}},
        },
        [84196] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Beaststalker's Cap and Beaststalker's Tunic."},
            [questKeys.objectives] = {nil,nil,{{226720},{226723}}},
        },
        [84197] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Magister's Crown and Magister's Robes."},
            [questKeys.objectives] = {nil,nil,{{226728},{226729}}},
        },
        [84198] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Lightforge Helm and Lightforge Breastplate."},
            [questKeys.objectives] = {nil,nil,{{226733},{226734}}},
        },
        [84199] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Devout Crown and Devout Robe."},
            [questKeys.objectives] = {nil,nil,{{226746},{226745}}},
        },
        [84200] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Shadowcraft Cap and Shadowcraft Tunic."},
            [questKeys.objectives] = {nil,nil,{{226707},{226700}}},
        },
        [84201] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Dreadmist Mask and Dreadmist Robe."},
            [questKeys.objectives] = {nil,nil,{{226762},{226757}}},
        },
        [84202] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230319}},
            [questKeys.finishedBy] = {{230319}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Deliana your Helm of Valor and Breastplate of Valor."},
            [questKeys.objectives] = {nil,nil,{{226769},{226770}}},
        },
        [84203] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Wildheart Cowl and Wildheart Vest."},
            [questKeys.objectives] = {nil,nil,{{226708},{226715}}},
        },
        [84204] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Beaststalker's Cap and Beaststalker's Tunic."},
            [questKeys.objectives] = {nil,nil,{{226720},{226723}}},
        },
        [84205] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Magister's Crown and Magister's Robes."},
            [questKeys.objectives] = {nil,nil,{{226728},{226729}}},
        },
        [84206] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Devout Crown and Devout Robe."},
            [questKeys.objectives] = {nil,nil,{{226746},{226745}}},
        },
        [84207] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Shadowcraft Cap and Shadowcraft Tunic."},
            [questKeys.objectives] = {nil,nil,{{226707},{226700}}},
        },
        [84208] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Coif of Elements and Vest of Elements."},
            [questKeys.objectives] = {nil,nil,{{226755},{226749}}},
        },
        [84209] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Dreadmist Mask and Dreadmist Robe."},
            [questKeys.objectives] = {nil,nil,{{226762},{226757}}},
        },
        [84210] = {
            [questKeys.name] = "Saving the Best for Last",
            [questKeys.startedBy] = {{230317}},
            [questKeys.finishedBy] = {{230317}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give Mokvar your Helm of Valor and Breastplate of Valor."},
            [questKeys.objectives] = {nil,nil,{{226769},{226770}}},
        },
        [84211] = {
            [questKeys.name] = "Poacher's Den",
            [questKeys.startedBy] = {{218236}},
            [questKeys.finishedBy] = {{228216}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defend yourself from poachers and recover the rest of Numi's materials."},
            [questKeys.objectives] = {nil,nil,{{226699}}},
        },
        [84212] = {
            [questKeys.name] = "Bookin' it Back",
            [questKeys.startedBy] = {{228216}},
            [questKeys.finishedBy] = {{228956}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Return to the D.E.L.T.A lab with the book Jurgens was looking for."},
            [questKeys.objectives] = nil,
        },
        [84213] = {
            [questKeys.name] = "Rift Away",
            [questKeys.startedBy] = {{228956}},
            [questKeys.finishedBy] = {nil,{459259}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 65,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Assist Doctor Jurgens with rift opening at either Tirisfal Glades or Westfall."},
            [questKeys.objectives] = {{{212252}}},
        },
        [84235] = {
            [questKeys.name] = "Dive! Dive!",
            [questKeys.startedBy] = {{228176}},
            [questKeys.finishedBy] = {{228176}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to the hills on the south side of Moonglade, on Kalimdor. Look for an air vortex east of the hills near the Timbermaw tunnel. Use the Dive skill of an animal companion to pierce the whirlwinds and retrieve a fragment of elemental air."},
            [questKeys.objectives] = {{{229156}}},
        },
        [84317] = {
            [questKeys.name] = "Infinite Midnight",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{224965}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Gain astral insights."},
            [questKeys.objectives] = nil,
        },
        [84318] = {
            [questKeys.name] = "Oi!",
            [questKeys.startedBy] = {{228619}},
            [questKeys.finishedBy] = {{228619}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find Orthas' missing hammer in Corrin's Crossing."},
            [questKeys.objectives] = {nil,nil,{{227686},{227687}}},
        },
        [84319] = {
            [questKeys.name] = "Oh No Ye Don't!",
            [questKeys.startedBy] = {{228619}},
            [questKeys.finishedBy] = {{228619}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Orthas needs you to recover his missing armor from the corpse of an Abomination somewhere in Plaguewood."},
            [questKeys.objectives] = {nil,nil,{{227689}}},
        },
        [84320] = {
            [questKeys.name] = "Lost Heirloom",
            [questKeys.startedBy] = {{376}},
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Retrieve the heirlooms from Sorrow Hill Crypt in Western Plaguelands, then return to High Priestess Laurena in Stormwind Cathedral."},
            [questKeys.objectives] = {nil,nil,{{227745},{227747},{227748}}},
        },
        [84321] = {
            [questKeys.name] = "Relic of Light",
            [questKeys.startedBy] = {{376}},
            [questKeys.finishedBy] = {nil,{457443}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to Hearthglen in Western Plaguelands and search for information on the artifact described in the journal."},
            [questKeys.objectives] = nil,
        },
        [84322] = {
            [questKeys.name] = "Scarlet Research",
            [questKeys.startedBy] = {nil,{457443}},
            [questKeys.finishedBy] = {nil,{459388}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Search for the artifact within the Scarlet Crusade stronghold at Tyr's Hand in Eastern Plaguelands."},
            [questKeys.objectives] = nil,
        },
        [84323] = {
            [questKeys.name] = "The Prize Within",
            [questKeys.startedBy] = {nil,{459388}},
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find a way to open the box and claim the artifact, then deliver it to High Priestess Laurena in Stormwind Cathedral."},
            [questKeys.objectives] = {nil,nil,{{227938},{228912},{227937}}},
        },
        [84324] = {
            [questKeys.name] = "Diplomatic Overtures",
            [questKeys.startedBy] = {{376}},
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Gather the supplies and deliver them to High Priestess Laurena in Stormwind Cathedral."},
            [questKeys.objectives] = {nil,nil,{{14530},{13446},{12207},{13180}}},
        },
        [84325] = {
            [questKeys.name] = "Shrine of Cooperation",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Deliver the crystal to High Priestess Laurena in Stormwind Cathedral."},
            [questKeys.objectives] = {nil,nil,{{228144}}},
        },
        [84326] = {
            [questKeys.name] = "Diplomat Ring",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Bring the requested materials to High Priestess Laurena in Stormwind Cathedral."},
            [questKeys.objectives] = {nil,nil,{{12360},{11382},{12361}}},
        },
        [84327] = {
            [questKeys.name] = "A Diplomatic Mission",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Make contact with a Horde Priest at the gates of Orgrimmar and gain Diplomatic Immunity by using your Diplomat Rings on each other. Then, enter Orgrimmar and speak to Dietrich Praice. You will lose Diplomatic Immunity if you stray too far from your escorting Priest or engage in combat."},
            [questKeys.objectives] = nil,
        },
        [84328] = {
            [questKeys.name] = "Repairing the Shard",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Retrieve the book \"Applied Divinity\" from Dire Maul, then return to Dietrich Praice in Orgrimmar. To enter Orgrimmar, you will need the assistance of a Horde Priest with a Diplomat Ring to gain Diplomatic Immunity. You will lose Diplomatic Immunity if you stray too far from your escorting Priest or engage in combat."},
            [questKeys.objectives] = {nil,nil,{{227912}}},
        },
        [84329] = {
            [questKeys.name] = "The Convocation Assembles",
            [questKeys.startedBy] = {{376}},
            [questKeys.finishedBy] = {{228928}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Speak to Maethra Slagheart in Deadwind Pass."},
            [questKeys.objectives] = {{{228928}}},
        },
        [84330] = {
            [questKeys.name] = "A Wee Bit O' Necromancy",
            [questKeys.startedBy] = {{228619}},
            [questKeys.finishedBy] = {{229018}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Obtain a Necrotic Runestone from Maleki the Pallid in Stratholme, then find the Rotting Dwarf Corpse near the Undercroft in southwestern Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{227690},{227687}}},
        },
        [84331] = {
            [questKeys.name] = "The Miracle",
            [questKeys.startedBy] = {{228928}},
            [questKeys.finishedBy] = {{228928}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Use your Diplomat Ring on the shards."},
            [questKeys.objectives] = nil,
        },
        [84332] = {
            [questKeys.name] = "A Thane's Gratitude",
            [questKeys.startedBy] = {nil,{462236}},
            [questKeys.finishedBy] = {nil,{462236}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"You find a small runestone at the bottom of the chest..."},
            [questKeys.objectives] = nil,
        },
        [84338] = {
            [questKeys.name] = "A Binding Contract",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{12944}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Turn the Thorium Brotherhood Contract in to Lokhtos Darkbargainer if you would like to receive the plans for Sulfuron."},
            [questKeys.objectives] = {nil,nil,{{17203}}},
        },
        [84348] = {
            [questKeys.name] = "Priority Target: Duke Tectonis",
            [questKeys.startedBy] = {{14627}},
            [questKeys.finishedBy] = {{14627}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Hansel Heavyhands at Thorium Point wants you to destroy Duke Tectonis. Duke Tectonis can be found in a small valley just to the west of the Searing Gorge entrance to Blackrock Mountain."},
            [questKeys.objectives] = {{{228729}}},
        },
        [84349] = {
            [questKeys.name] = "Priority Target: Duke Searbrand",
            [questKeys.startedBy] = {{14634}},
            [questKeys.finishedBy] = {{14634}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Lookout Captain Lolo Longstrike wants you to destroy Duke Searbrand. You'll find Duke Searbrand in lowest depths of the Slag Pit caves, directly south of Thorium Point."},
            [questKeys.objectives] = {{{228720}}},
        },
        [84350] = {
            [questKeys.name] = "Grinding Them Down",
            [questKeys.startedBy] = {{14628}},
            [questKeys.finishedBy] = {{14628}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Evonice Sootsmoker wants you to slay 10 Obsidian Reavers in the Searing Gorge. The Obsidian Reavers can be found all along the southern section of Searing Gorge, and near the entrance the Blackrock Mountain."},
            [questKeys.objectives] = {{{228723}}},
        },
        [84351] = {
            [questKeys.name] = "Work Smarter, Not Harder",
            [questKeys.startedBy] = {{14626}},
            [questKeys.finishedBy] = {{14626}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Taskmaster Scrange wants you to slay Obsidian Surgers in the Searing Gorge and bring their Power Cores back him. Obsidian Surgers can be found along the southern portion of the Searing Gorge, near the entrance to Blackrock Mountain."},
            [questKeys.objectives] = {nil,nil,{{227743}}},
        },
        [84355] = {
            [questKeys.name] = "More Like Lame-bringers!",
            [questKeys.startedBy] = {{14626}},
            [questKeys.finishedBy] = {{14626}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Taskmaster Scrange wants you to slay Flamebringer Defenders and Flamebringer Elementalists at Firewatch Ridge to the west of Thorium Point. A quest."},
            [questKeys.objectives] = {{{228727},{228726}}},
        },
        [84356] = {
            [questKeys.name] = "Oh, Shiny!",
            [questKeys.startedBy] = {{14624}},
            [questKeys.finishedBy] = {{14624}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 56,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Master Smith Burninate at Thorium Point wants you to gather 8 Flamestone Clusters from Dark Iron Slavers in The Slag Pit. You can find the entrance to the Slag Pit inside the Cauldron, southeast of Thorium Point."},
            [questKeys.objectives] = {nil,nil,{{227767}}},
        },
        [84359] = {
            [questKeys.name] = "Sleepless Nights",
            [questKeys.startedBy] = {{14628}},
            [questKeys.finishedBy] = {{14628}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Evonice Sootsmoker is asking you to drink the Specially Formulated Dreamjuice and slay 5 Flamebringer Stalkers near Thorium Point in the Searing Gorge."},
            [questKeys.objectives] = {{{228747}}},
        },
        [84360] = {
            [questKeys.name] = "Firefighting",
            [questKeys.startedBy] = {{14625}},
            [questKeys.finishedBy] = {{14625}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Overseer Oilfist wants you to slay 15 Firelands Invaders in The Cauldron, south of Thorium Point."},
            [questKeys.objectives] = {{{228718}}},
        },
        [84369] = {
            [questKeys.name] = "Healing the Healer",
            [questKeys.startedBy] = {{228822}},
            [questKeys.finishedBy] = {{228902}},
            [questKeys.requiredLevel] = 52,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Retrieve the Unusual Flask from the Irontree Stompers and bring it to the Frostfire Hot Springs in Winterspring."},
            [questKeys.objectives] = {{{228902}}},
        },
        [84372] = {
            [questKeys.name] = "Lava Diving",
            [questKeys.startedBy] = {{14627}},
            [questKeys.finishedBy] = {{14627}},
            [questKeys.requiredLevel] = 53,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a chunk of Shimmering Molten Mineral to Hansel Heavyhands. You can find the shimmering molten crag within the Slag Pit lava pools, deep within the Cauldron."},
            [questKeys.objectives] = {nil,nil,{{228191}}},
        },
        [84377] = {
            [questKeys.name] = "End of the Dark Horde",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{332,466}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Head of Rend Blackhand to Master Mathias Shaw in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [84384] = {
            [questKeys.name] = "Demonic Deceptions",
            [questKeys.startedBy] = {{222408}},
            [questKeys.finishedBy] = {{222408}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect 6 Owlbeast Pineal Glands from owlbeasts in Winterspring, then return to the Shadowtooth Emissary in Felwood."},
            [questKeys.objectives] = {nil,nil,{{227914}}},
        },
        [84394] = {
            [questKeys.name] = "Greater Friend of the Library",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [84395] = {
            [questKeys.name] = "Undead Potatoes",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228132}}},
        },
        [84396] = {
            [questKeys.name] = "Magma or Lava?",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228133}}},
        },
        [84397] = {
            [questKeys.name] = "Northern Kalimdor - A Comprehensive Guide",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228134}}},
        },
        [84398] = {
            [questKeys.name] = "A Study of the Light",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228135}}},
        },
        [84399] = {
            [questKeys.name] = "Ka-Boom!",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228136}}},
        },
        [84400] = {
            [questKeys.name] = "The Knight and the Lady",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228138}}},
        },
        [84401] = {
            [questKeys.name] = "Scourge: Undead Menace or Misunderstood?",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228140}}},
        },
        [84402] = {
            [questKeys.name] = "Necromancy 101",
            [questKeys.startedBy] = {{5497}},
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{228141}}},
        },
        [84405] = {
            [questKeys.name] = "Lost Heirloom",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Retrieve the heirlooms from Sorrow Hill Crypt in Western Plaguelands, then return to Dietrich Praice in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{227745},{227747},{227748}}},
        },
        [84406] = {
            [questKeys.name] = "Relic of Light",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {nil,{457443}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to Hearthglen in Western Plaguelands and search for information on the artifact described in the journal."},
            [questKeys.objectives] = nil,
        },
        [84407] = {
            [questKeys.name] = "The Prize Within",
            [questKeys.startedBy] = {nil,{459388}},
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find a way to open the box and claim the artifact, then deliver it to Dietrich Praice in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{227938},{228912},{227937}}},
        },
        [84408] = {
            [questKeys.name] = "Diplomatic Overtures",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Gather the supplies and deliver them to Dietrich Praice in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{14530},{13446},{12207},{13180}}},
        },
        [84410] = {
            [questKeys.name] = "Shrine of Cooperation",
            [questKeys.startedBy] = {{228818}},
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Deliver the crystal to Dietrich Praice in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{228144}}},
        },
        [84411] = {
            [questKeys.name] = "Diplomat Ring",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{211229}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Bring the requested materials to Dietrich Praice in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{12360},{11382},{12361}}},
        },
        [84412] = {
            [questKeys.name] = "A Diplomatic Mission",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Make contact with an Alliance Priest at the gates of Stormwind and gain Diplomatic Immunity by using your Diplomat Rings on each other. Then, enter Stormwind Cathedral and speak to High Priestess Laurena. You will lose Diplomatic Immunity if you stray too far from your escorting Priest or engage in combat."},
            [questKeys.objectives] = nil,
        },
        [84413] = {
            [questKeys.name] = "Repairing the Shard",
            [questKeys.startedBy] = {{376}},
            [questKeys.finishedBy] = {{376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Retrieve the book \"Applied Divinity\" from Dire Maul, then return to High Priestess Laurena in Stormwind Cathedral. To enter Stormwind, you will need the assistance of an Alliance Priest with a Diplomat Ring to gain Diplomatic Immunity. You will lose Diplomatic Immunity if you stray too far from your escorting Priest or engage in combat."},
            [questKeys.objectives] = {nil,nil,{{227912}}},
        },
        [84414] = {
            [questKeys.name] = "Send Me On Me Way!",
            [questKeys.startedBy] = {{229018}},
            [questKeys.finishedBy] = {nil,{462236}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Observe Orthas as he moves on from this world."},
            [questKeys.objectives] = {{{229037}}},
        },
        [84418] = {
            [questKeys.name] = "The Missing Knight",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"A mutual friend of ours recently reached out to ask for aid in locating a missing knight by the name of Dalton. He and his young squire were last seen in the plaguelands and have not been heard from in quite some time. If your travels take you that way, please keep an eye out for them.Not much to go on, but you have a knack for finding yourself in all sorts of interesting situations. If anyone could stumble upon a missing knight and his pup squire in the middle of those hellish plaguelands, it's you."},
            [questKeys.objectives] = nil,
        },
        [84495] = {
            [questKeys.name] = "Fiery Plate Gauntlets",
            [questKeys.startedBy] = {{10637}},
            [questKeys.finishedBy] = {{10637}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Malyfous Darkhammer 6 Enchanted Thorium Bars, 2 Essence of Fire, and 4 Star Rubies. You will also need to turn in your Unfired Plate Gauntlets."},
            [questKeys.objectives] = {nil,nil,{{12655},{7078},{7910},{12812}}},
        },
        [84496] = {
            [questKeys.name] = "Sweet Serenity",
            [questKeys.startedBy] = {{11191}},
            [questKeys.finishedBy] = {{11191}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to Stratholme and kill the Crimson Hammersmith. Recover the Crimson Hammersmith's Apron and return to Lilith."},
            [questKeys.objectives] = {nil,nil,{{13351}}},
        },
        [84525] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [84545] = {
            [questKeys.name] = "A Hero's Reward",
            [questKeys.startedBy] = {{13278}},
            [questKeys.finishedBy] = {nil,{179551}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Claim your reward from Hydraxis' Coffer."},
            [questKeys.objectives] = nil,
        },
        [84546] = {
            [questKeys.name] = "Stave of the Ancients",
            [questKeys.startedBy] = {{14524}},
            [questKeys.finishedBy] = {{14524}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"You must find and destroy these four demonic corrupters:Simone the Seductress.Klinfran the Crazed.Solenor the Slayer.Artorius the Doombringer.Destroy these creatures and return to Vartrus the Ancient in Felwood with their heads.Refer to the Petrified Bark in your inventory for clues as to their whereabouts.You MUST complete this task by yourself."},
            [questKeys.objectives] = {nil,nil,{{18952},{18953},{18954},{18955},{18708}}},
        },
        [84548] = {
            [questKeys.name] = "Garona: A Study on Stealth and Treachery",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14383}},
            [questKeys.requiredLevel] = 54,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the book to its rightful owners."},
            [questKeys.objectives] = nil,
        },
        [84549] = {
            [questKeys.name] = "The Arcanist's Cookbook",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14383}},
            [questKeys.requiredLevel] = 54,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the book to its rightful owners."},
            [questKeys.objectives] = nil,
        },
        [84550] = {
            [questKeys.name] = "Codex of Defense",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14383}},
            [questKeys.requiredLevel] = 54,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the book to its rightful owners."},
            [questKeys.objectives] = nil,
        },
        [84551] = {
            [questKeys.name] = "The Light and How To Swing It",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14382}},
            [questKeys.requiredLevel] = 54,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the book to its rightful owners."},
            [questKeys.objectives] = nil,
        },
        [84555] = {
            [questKeys.name] = "Nostro's Compendium",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14368}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return Nostro's Compendium of Dragon Slaying to the Athenaeum."},
            [questKeys.objectives] = nil,
        },
        [84556] = {
            [questKeys.name] = "The Forging of Quel'Serrar",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14368}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Give the Dull and Flat Elven Blade to Lorekeeper Lydros."},
            [questKeys.objectives] = nil,
        },
        [84557] = {
            [questKeys.name] = "The Forging of Quel'Serrar",
            [questKeys.startedBy] = {{14368}},
            [questKeys.finishedBy] = {{14368}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You must get Onyxia to breathe fire on the Unfired Ancient Blade. Once this is done, pick up the now Heated Ancient Blade. Be warned, a Heated Ancient Blade will not remain heated forever - time is of the essence.The last step before returning to me is to slay the beast and drive the Heated Ancient Blade into her corpse.Do this and Quel'Serrar will be yours."},
            [questKeys.objectives] = {nil,nil,{{18492},{18488},{18489}}},
        },
        [84560] = {
            [questKeys.name] = "Celebrating Good Times",
            [questKeys.startedBy] = {{1748}},
            [questKeys.finishedBy] = {{14394}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Major Mattingly in the Valley of Heroes."},
            [questKeys.objectives] = nil,
        },
        [84561] = {
            [questKeys.name] = "For All To See",
            [questKeys.startedBy] = {{4949}},
            [questKeys.finishedBy] = {{14392}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Overlord Runthak in the Valley of Strength."},
            [questKeys.objectives] = nil,
        },
        [84590] = {
            [questKeys.name] = "The Balance of Light and Shadow",
            [questKeys.startedBy] = {{14494}},
            [questKeys.finishedBy] = {{14494}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Save 50 Peasants before 15 are slain. Speak with Eris Havenfire should you accomplish this task.You may view the Death Post to view how many Peasants have been slain."},
            [questKeys.objectives] = nil,
        },
        [84636] = {
            [questKeys.name] = "Prowler",
            [questKeys.startedBy] = {{228176}},
            [questKeys.finishedBy] = {{228176}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to the barrows on the east side of Moonglade, on Kalimdor. Descend into the southeastern most Stormrage barrow den, and look for an earth elemental fragment in the depths. Use the Prowl skill of an animal companion to bypass the guardians and retrieve a fragment of elemental earth."},
            [questKeys.objectives] = {{{230481}}},
        },
        [84777] = {
            [questKeys.name] = "Feathers for Nafien",
            [questKeys.startedBy] = {{15395}},
            [questKeys.finishedBy] = {{15395}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"While you have proven yourself to me, you may need to continue to work toward proving yourself to the suspicious brethren of my tribe. &nbsp;To that end, I may be able to continue assisting you.Some of the Deadwood furbolgs wear a distinctive headdress that may be used as a means of proof in thinning their numbers. &nbsp;Bring me a feather from any headdresses you acquire; for every set of five you bring me, you will earn recognition amongst the Timbermaw."},
            [questKeys.objectives] = {nil,nil,{{21377}}},
        },
        [84853] = {
            [questKeys.name] = "Tracks in the Snow",
            [questKeys.startedBy] = {{228176}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to the hills in Winterspring in northern Kalimdor, north of Everlook, to meet up with Estelenn and find out what else she needs."},
            [questKeys.objectives] = nil,
        },
        [84870] = {
            [questKeys.name] = "The Dark Hoard",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{231050}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Break into the storeroom of Blackrock Spire, and steal whatever valuables are inside. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{229352}}},
        },
        [84880] = {
            [questKeys.name] = "The Enemy of my Enemy",
            [questKeys.startedBy] = {{231050}},
            [questKeys.finishedBy] = {{6707}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"A terrible threat is brewing within the Syndicate. Someone at Ravenholdt might know what to do."},
            [questKeys.objectives] = nil,
        },
        [84881] = {
            [questKeys.name] = "Into the Hold of Shadows",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{6707}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find Caius inside of Shadow Hold, in Felwood, and stop his ritual. In addition, bring proof of his demise to Fahrad at Ravenholdt Manor. You must go alone, and remain unseen until you find Caius."},
            [questKeys.objectives] = {{{231430}}},
        },
        [84950] = {
            [questKeys.name] = "Out in the Cold",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {nil,{469796}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use your survival supplies to set up a campsite foundation and a crude tent. If you lose your foundation, make a new one with your survival supplies and bring the materials there."},
            [questKeys.objectives] = {{{9659}}},
        },
        [85034] = {
            [questKeys.name] = "The Ruins of Andorhal",
            [questKeys.startedBy] = {{1854}},
            [questKeys.finishedBy] = {{1854}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Take the Blood of the Lightbringer and explore Andorhal."},
            [questKeys.objectives] = {{{232923}}},
        },
        [85061] = {
            [questKeys.name] = "Bug Hunt",
            [questKeys.startedBy] = {{227755}},
            [questKeys.finishedBy] = {{15181}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to the Cenarion Hold in Silithus, on Kalimdor, and speak to the druids there about the evolving silithids. Aid them as requested while practicing your marksmanship skills."},
            [questKeys.objectives] = {{{15181}}},
        },
        [85063] = {
            [questKeys.name] = "Culmination",
            [questKeys.startedBy] = {{232929}},
            [questKeys.finishedBy] = {{232929}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Defend Gregory as he completes the ritual to destroy the Mannoroc Echoing Orb."},
            [questKeys.objectives] = {{{232633}}},
        },
        [85064] = {
            [questKeys.name] = "Worst Case Scenario",
            [questKeys.startedBy] = {{232929}},
            [questKeys.finishedBy] = {{232932}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Travel to Andorhal and locate Gregory to learn what to do next."},
            [questKeys.objectives] = nil,
        },
        [85065] = {
            [questKeys.name] = "A Most Curious Gnome",
            [questKeys.startedBy] = {{232932}},
            [questKeys.finishedBy] = {{10667}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Chromie in Andorhal and convince her to help you."},
            [questKeys.objectives] = nil,
        },
        [85066] = {
            [questKeys.name] = "Making Ready",
            [questKeys.startedBy] = {{10667}},
            [questKeys.finishedBy] = {{232932}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Gregory in Andorhal and ask him to accompany you to the Burning of Andorhal."},
            [questKeys.objectives] = nil,
        },
        [85067] = {
            [questKeys.name] = "A Paladin of the Silver Hand",
            [questKeys.startedBy] = {{232932}},
            [questKeys.finishedBy] = {{232932}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Go to Uther's Tomb and explain the situation to Aeonas."},
            [questKeys.objectives] = {{{232946}}},
        },
        [85068] = {
            [questKeys.name] = "Who Says You Can Never Go Back?",
            [questKeys.startedBy] = {{10667}},
            [questKeys.finishedBy] = {{232960}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Take the portal to the Burning of Andorhal."},
            [questKeys.objectives] = nil,
        },
        [85074] = {
            [questKeys.name] = "The Burning of Andorhal",
            [questKeys.startedBy] = {{232960}},
            [questKeys.finishedBy] = {{232998}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Complete your objective and escape the Burning of Andorhal."},
            [questKeys.objectives] = {nil,nil,{{231903}}},
        },
        [85087] = {
            [questKeys.name] = "A Desperate Escape",
            [questKeys.startedBy] = {{232998}},
            [questKeys.finishedBy] = {{233138}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Fight your way to the Inn and escape back to your own time. If you get separated from Aeonas, blow the Tarnished Horn to call him back to your side."},
            [questKeys.objectives] = {{{233033}}},
        },
        [85090] = {
            [questKeys.name] = "Back to the Future",
            [questKeys.startedBy] = {{233138}},
            [questKeys.finishedBy] = {{232932}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Take the portal back to your time, and deliver Truthbearer to Gregory."},
            [questKeys.objectives] = nil,
        },
        [85091] = {
            [questKeys.name] = "The Cost of Victory",
            [questKeys.startedBy] = {{232932}},
            [questKeys.finishedBy] = {{233776}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Consecrate your weapon with the Blood of the Lightbringer and defeat Azgaloth in Demon Fall Canyon."},
            [questKeys.objectives] = {{{233158}}},
        },
        [85092] = {
            [questKeys.name] = "Truthbearer",
            [questKeys.startedBy] = {{233776}},
            [questKeys.finishedBy] = {{233776}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bid farewell to Gregory."},
            [questKeys.objectives] = nil,
        },
        [85112] = {
            [questKeys.name] = "The Depleted Scythe",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{6247}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Bring the staff to Doan Karhan in The Barrens."},
            [questKeys.objectives] = nil,
        },
        [85150] = {
            [questKeys.name] = "The Only Good Bug is a Dead Bug",
            [questKeys.startedBy] = {{15181}},
            [questKeys.finishedBy] = {{15181}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find and defeat four silithid darters. These are fast-moving, small silithid wasps with a blue exoskeleton."},
            [questKeys.objectives] = {{{231984}}},
        },
        [85248] = {
            [questKeys.name] = "Everyone Knows That Bugs Can't Fly",
            [questKeys.startedBy] = {{15181}},
            [questKeys.finishedBy] = {{15181}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Fight a silithid darter until you weaken it, then use your Concussive Shot skill to slow it. When it frenzies, use a Tranquilizing Shot to knock it unconscious. Tie it up, drag it back to Cenarion Hold, and secure it to the  hitching post across from Commander Mar'alith's war room for further study. Return to Commander Mar'alith in Cenarion Hold when finished. You can learn Tranquilizing Shot from the raid on Molten Core."},
            [questKeys.objectives] = nil,
        },
        [85250] = {
            [questKeys.name] = "Meeting the Menagerie",
            [questKeys.startedBy] = {{15181}},
            [questKeys.finishedBy] = {{233084}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to Un'Goro Crater, in the south of Kalimdor, and find evidence of Van Amburgh."},
            [questKeys.objectives] = nil,
        },
        [85251] = {
            [questKeys.name] = "Showdown at Un'Goro Crater",
            [questKeys.startedBy] = {{233084}},
            [questKeys.finishedBy] = {{233084}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Travel to the camp of Van Amburgh in Un'Goro crater, in the south of Kalimdor, and defeat the dwarf and his menagerie."},
            [questKeys.objectives] = {{{232755}}},
        },
        [85304] = {
            [questKeys.name] = "Essence of Fire",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5497,7825}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Figure out what the unusual scroll is for and report your findings to a librarian in Stormwind or Undercity."},
            [questKeys.objectives] = {{{232429},{232398}}},
        },
        [85385] = {
            [questKeys.name] = "The Librarian's Apprentice",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{232381}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Speak with Valxx Cracklequil in Everlook to learn about the rumors."},
            [questKeys.objectives] = nil,
        },
        [85386] = {
            [questKeys.name] = "Essence of Frost",
            [questKeys.startedBy] = {{232381}},
            [questKeys.finishedBy] = {{232381}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Investigate Frostwhisper Gorge for a mysterious frost power."},
            [questKeys.objectives] = {{{232466},{232399}}},
        },
        [85388] = {
            [questKeys.name] = "A Foul Interference",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{10929}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Stop the corruption of Mazthoril."},
            [questKeys.objectives] = {{{232532}}},
        },
        [85401] = {
            [questKeys.name] = "The Frigid Barrow",
            [questKeys.startedBy] = {{216289}},
            [questKeys.finishedBy] = {{216289}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Find Nandieb in the barrow den near Starfall Village in Winterspring, and recover his stave. This must be done alone."},
            [questKeys.objectives] = {nil,nil,{{231842}}},
        },
        [85441] = {
            [questKeys.name] = "Thunderaan the Windseeker",
            [questKeys.startedBy] = {{232309}},
            [questKeys.finishedBy] = {{232309}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To harness the power of the Windseeker, you must present the right and left halves of the Bindings of the Windseeker, 10 bars of Elementium, and the Essence of the Firelord to Highlord Demitrian in The Crystal Vale."},
            [questKeys.objectives] = {nil,nil,{{17771},{19017},{18564},{18563}}},
        },
        [85442] = {
            [questKeys.name] = "Examine the Vessel",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{232309}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Examine the Vessel of Rebirth and return it to Highlord Demitrian."},
            [questKeys.objectives] = nil,
        },
        [85443] = {
            [questKeys.name] = "Rise, Thunderfury!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{232309}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Present the Dormant Wind Kissed Blade to Highlord Demitrian."},
            [questKeys.objectives] = nil,
        },
        [85445] = {
            [questKeys.name] = "The Golden Disk",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{2888}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find someone who can tell you more about the Shimmering Golden Disk."},
            [questKeys.objectives] = {{{2888}}},
        },
        [85446] = {
            [questKeys.name] = "Scale of the Dragon Lord",
            [questKeys.startedBy] = {{232596}},
            [questKeys.finishedBy] = {{232596}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Speak with Riosus and form a plan for how to dispose of the Simulacrum of the Dragon Soul."},
            [questKeys.objectives] = {nil,nil,{{231386},{232414}}},
        },
        [85447] = {
            [questKeys.name] = "Grim Batol",
            [questKeys.startedBy] = {{2888}},
            [questKeys.finishedBy] = {{232596}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring the Simulacrum of the Dragon Soul to the leader of the dragon host near the entrance to the fortress of Grim Batol."},
            [questKeys.objectives] = nil,
        },
        [85453] = {
            [questKeys.name] = "No Good Deed Goes Unpunished",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{232624}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defend yourself against Riosustrasz!"},
            [questKeys.objectives] = {{{232625},{233383}}},
        },
        [85454] = {
            [questKeys.name] = "A Just Reward",
            [questKeys.startedBy] = {{232624}},
            [questKeys.finishedBy] = {{232624}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Speak with Krasus to destroy the Simulacrum of the Dragon Soul and receive your reward."},
            [questKeys.objectives] = {{{232626}}},
        },
        [85455] = {
            [questKeys.name] = "The Blood of the Lightbringer",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{1854}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find someone who can tell you more about the Blood of the Lightbringer. (Please note that you need to have previously completed the quest \"Plaguelands Rendezvous\" to be able to hand in this quest)"},
            [questKeys.objectives] = nil,
        },
        [85457] = {
            [questKeys.name] = "Just What Was Needed",
            [questKeys.startedBy] = {{231498}},
            [questKeys.finishedBy] = {{231500}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Take the Blood of the Lightbringer to Gregory in Caer Darrow in Western Plaguelands."},
            [questKeys.objectives] = nil,
        },
        [85458] = {
            [questKeys.name] = "Darkwhisper Gorge",
            [questKeys.startedBy] = {{231500}},
            [questKeys.finishedBy] = {{232929}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Meet Gregory at Darkwhisper Gorge, in Winterspring."},
            [questKeys.objectives] = nil,
        },
        [85468] = {
            [questKeys.name] = "Soul of Mischief",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {{232802}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Convince Xirath near Northdale in Eastern Plaguelands to help you gain a Soul of Mischief and use it on the Depleted Scythe of Chaos."},
            [questKeys.objectives] = {{{232731}}},
        },
        [85480] = {
            [questKeys.name] = "Procrastimond's Gratitude",
            [questKeys.startedBy] = {{231485}},
            [questKeys.finishedBy] = {{231485}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"You are a remarkable mortal, little one. The gift of foresight is not common among your kind.I must warn you, though. Such knowledge can influence events, even unintentionally. It is quite possible your future will take a different path than the one written in my library.I found this book which does not appear to belong in my collection. Please accept it, with my thanks."},
            [questKeys.objectives] = nil,
        },
        [85485] = {
            [questKeys.name] = "Soul of the Void",
            [questKeys.startedBy] = {{232802}},
            [questKeys.finishedBy] = {{232802}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Find the Voidwalker near Corin's Crossing in Eastern Plaguelands and add its soul to the scythe."},
            [questKeys.objectives] = nil,
        },
        [85486] = {
            [questKeys.name] = "Soul of Enthralling",
            [questKeys.startedBy] = {{232802}},
            [questKeys.finishedBy] = {{232802}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use a Glowing Scroll of Spatial Mending on a Large Fel Rift to summon a Fel Interloper and obtain its soul."},
            [questKeys.objectives] = {nil,nil,{{231836}}},
        },
        [85501] = {
            [questKeys.name] = "The Heart of Chromaggus",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{216289}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Find someone who can understand the power of the Chromatic Heart."},
            [questKeys.objectives] = {nil,nil,{{231814}}},
        },
        [85505] = {
            [questKeys.name] = "Soul of Devouring",
            [questKeys.startedBy] = {{232802}},
            [questKeys.finishedBy] = {{232802}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Find the mages near Blackwood Lake and have them cast spells on you until the felhound appears."},
            [questKeys.objectives] = {nil,nil,{{231837}}},
        },
        [85506] = {
            [questKeys.name] = "The Final Test",
            [questKeys.startedBy] = {{232802}},
            [questKeys.finishedBy] = {{232924}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain Des'Altek's soul from Demon Fall Canyon and use it to finish restoring the scythe."},
            [questKeys.objectives] = {{{232924},{232886}}},
        },
        [85507] = {
            [questKeys.name] = "Our Wayward Friend",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{231498}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find Aeonas near Sorrow Hill in the Western Plaguelands."},
            [questKeys.objectives] = {{{231498}}},
        },
        [85508] = {
            [questKeys.name] = "Our Wayward Friend",
            [questKeys.startedBy] = {{231498}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Aeonas before heading back to Stormwind to let Katherine know his answer."},
            [questKeys.objectives] = {{{232892}}},
        },
        [85509] = {
            [questKeys.name] = "Grand Theft Echoing Orb",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{5492}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Vault Keeper Faranister in the Canal District of Stormwind and return to Katherine when you've learned what you can."},
            [questKeys.objectives] = {{{231852}}},
        },
        [85510] = {
            [questKeys.name] = "A Solid Lead",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{231499}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Explore some of the more disreputable parts of Stormwind for information on who may have been plotting to rob the vault."},
            [questKeys.objectives] = nil,
        },
        [85511] = {
            [questKeys.name] = "Plaguelands Rendezvous",
            [questKeys.startedBy] = {{231499}},
            [questKeys.finishedBy] = {{231500}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find Ada Darkheardt at Caer Darrow in Western Plaguelands."},
            [questKeys.objectives] = {{{231979}}},
        },
        [85521] = {
            [questKeys.name] = "Tracking the Trapper",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{227755}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the abandoned camp on the west side of the Burning Steppes, south of the road to the Altar of Storms, and investigate the area."},
            [questKeys.objectives] = {{{227755}}},
        },
        [85525] = {
            [questKeys.name] = "One Night in Winterspring",
            [questKeys.startedBy] = {nil,{469796}},
            [questKeys.finishedBy] = {nil,{469796}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Collect bear meat, warm fur, and dry wood. Bring the materials back to your campsite to construct a shelter so that you can survive the storm. If you lose your foundation, make a new one with your survival supplies and bring the materials there."},
            [questKeys.objectives] = {nil,nil,{{12622},{229416},{229415}}},
        },
        [85555] = {
            [questKeys.name] = "Heavy Metal",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{2836}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find someone who can work with exotic metals and is willing to help you crate something special with this chunk of elementium."},
            [questKeys.objectives] = nil,
        },
        [85556] = {
            [questKeys.name] = "A Particular Set of Skills",
            [questKeys.startedBy] = {{2836}},
            [questKeys.finishedBy] = {{14401}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find a way to get into Blackwing Lair and speak with Master Elemental Shaper Krixix without engaging him in combat."},
            [questKeys.objectives] = nil,
        },
        [85557] = {
            [questKeys.name] = "Efficiency Is Priority One",
            [questKeys.startedBy] = {{14401}},
            [questKeys.finishedBy] = {{14401}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find a suitable power source to keep Master Elemental Shaper Krixix's elementium forge run more efficiently."},
            [questKeys.objectives] = {nil,nil,{{228105}}},
        },
        [85558] = {
            [questKeys.name] = "Commit to Quality",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14401}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Watch Master Elemental Shaper Krixix craft your item."},
            [questKeys.objectives] = nil,
        },
        [85559] = {
            [questKeys.name] = "Night Falls",
            [questKeys.startedBy] = {{233084}},
            [questKeys.finishedBy] = {nil,{489943}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Walk with Estelenn and see what she has to show you."},
            [questKeys.objectives] = {{{233249}}},
        },
        [85595] = {
            [questKeys.name] = "Presence of Might",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231517},{231512}}},
        },
        [85596] = {
            [questKeys.name] = "Death's Embrace",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231523},{231512}}},
        },
        [85597] = {
            [questKeys.name] = "Falcon's Call",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231525},{231512}}},
        },
        [85598] = {
            [questKeys.name] = "Prophetic Aura",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231521},{231512}}},
        },
        [85599] = {
            [questKeys.name] = "Hoodoo Hex",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231520},{231512}}},
        },
        [85600] = {
            [questKeys.name] = "Presence of Sight",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231519},{231512}}},
        },
        [85601] = {
            [questKeys.name] = "Syncretist's Sigil",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231524},{231512}}},
        },
        [85602] = {
            [questKeys.name] = "Animist's Caress",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient troll enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231522},{231512}}},
        },
        [85603] = {
            [questKeys.name] = "Vodouisant's Vigilant Embrace",
            [questKeys.startedBy] = {{15042}},
            [questKeys.finishedBy] = {{15042}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Zanza can create the ancient &lt;race&gt; enchantments with the right components.The first is a primal Hakkari idol that must be taken from the most powerful of the Hakkari lieutenants: Jin'do and the Bloodlord.The second is a punctured voodoo doll. These can be found in the piles of refuse that litter this foul place. Look inside the jinxed hoodoo piles.Bring me these things and I will create a powerful enchantment for you!"},
            [questKeys.objectives] = {nil,nil,{{231518},{231512}}},
        },
        [85604] = {
            [questKeys.name] = "The Unmarred Vision of Voodress",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{19608}}},
        },
        [85605] = {
            [questKeys.name] = "Paragons of Power: The Augur's Bracers",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Maywiki of Zuldazar a Primal Hakkari Armsplint.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Maywiki of Zuldazar is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19717}},{270,3000}},
        },
        [85606] = {
            [questKeys.name] = "Paragons of Power: The Augur's Belt",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Maywiki of Zuldazar a Primal Hakkari Girdle.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Maywiki of Zuldazar is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19719}},{270,9000}},
        },
        [85607] = {
            [questKeys.name] = "Paragons of Power: The Augur's Hauberk",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Maywiki of Zuldazar a Primal Hakkari Tabard.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Maywiki of Zuldazar is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19722}},{270,21000}},
        },
        [85608] = {
            [questKeys.name] = "Pristine Enchanted South Seas Kelp",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;name&gt;! It been a long time since I seen you. Did you know that King Rastakhan himself be givin' me the order to add the final bit of mojo and magic to your talisman? It be true, mon! I wouldn't have believed it had I not seen it with me own eyes. Give it here."},
            [questKeys.objectives] = {nil,nil,{{19612}}},
        },
        [85609] = {
            [questKeys.name] = "Paragons of Power: The Haruspex's Bracers",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Maywiki of Zuldazar a Primal Hakkari Stanchion.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Maywiki of Zuldazar is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19718}},{270,3000}},
        },
        [85610] = {
            [questKeys.name] = "Paragons of Power: The Haruspex's Belt",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Maywiki of Zuldazar a Primal Hakkari Sash.  Maywiki of Zuldazar is located on Yojamba Isle, Stranglethorn Vale. You must also be Honored with Zandalar."},
            [questKeys.objectives] = {nil,nil,{{19720}},{270,9000}},
        },
        [85611] = {
            [questKeys.name] = "Paragons of Power: The Haruspex's Tunic",
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Maywiki of Zuldazar a Primal Hakkari Tabard.  Maywiki of Zuldazar is located on Yojamba Isle, Stranglethorn Vale. You must also be Revered with Zandalar."},
            [questKeys.objectives] = {nil,nil,{{19722}},{270,21000}},
        },
        [85612] = {
            [questKeys.name] = "The Rage of Mugamba",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"King Rastakhan sends his regards, Master &lt;name&gt;. Such an honor has never been given to one outside the Zandalar tribe.Give me your talisman so that I may enhance it once more. Know that the Rage of Mugamba is now intrinsically connected to your very soul."},
            [questKeys.objectives] = {nil,nil,{{19576}}},
        },
        [85613] = {
            [questKeys.name] = "Paragons of Power: The Vindicator's Armguards",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Jin'rokh the Breaker a Primal Hakkari Armsplint.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Jin'rokh the Breaker is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19717}},{270,3000}},
        },
        [85614] = {
            [questKeys.name] = "Paragons of Power: The Vindicator's Belt",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Jin'rokh the Breaker a Primal Hakkari Girdle.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Jin'rokh the Breaker is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19719}},{270,9000}},
        },
        [85615] = {
            [questKeys.name] = "Paragons of Power: The Vindicator's Breastplate",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Jin'rokh the Breaker a Primal Hakkari Kossack.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Jin'rokh the Breaker is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19723}},{270,21000}},
        },
        [85616] = {
            [questKeys.name] = "The All-Seeing Eye of Zuldazar",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{19593}}},
        },
        [85617] = {
            [questKeys.name] = "The Hero's Brand",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{19586}}},
        },
        [85618] = {
            [questKeys.name] = "Paragons of Power: The Freethinker's Armguards",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Jin'rokh the Breaker Primal Hakkari Bindings.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Jin'rokh the Breaker is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19716}},{270,3000}},
        },
        [85619] = {
            [questKeys.name] = "Paragons of Power: The Freethinker's Belt",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Jin'rokh the Breaker a Primal Hakkari Shawl.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Jin'rokh the Breaker is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19721}},{270,9000}},
        },
        [85620] = {
            [questKeys.name] = "Paragons of Power: The Freethinker's Breastplate",
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Jin'rokh the Breaker a Primal Hakkari Tabard.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Jin'rokh the Breaker is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19722}},{270,21000}},
        },
        [85622] = {
            [questKeys.name] = "Paragons of Power: The Confessor's Wraps",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Stanchion.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19718}},{270,3000}},
        },
        [85623] = {
            [questKeys.name] = "Paragons of Power: The Confessor's Bindings",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Sash.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19720}},{270,9000}},
        },
        [85624] = {
            [questKeys.name] = "Paragons of Power: The Confessor's Mantle",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Aegis.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19724}},{270,21000}},
        },
        [85625] = {
            [questKeys.name] = "Kezan's Unstoppable Taint",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Call forth your demons, &lt;class&gt;. Let them bask in the energy of Kezan's Taint. Command them on the field of battle! Decimate the enemy!Yes... The time has come to apply the final enhancement to Kezan's Taint. Give me the talisman."},
            [questKeys.objectives] = {nil,nil,{{19604}}},
        },
        [85626] = {
            [questKeys.name] = "Paragons of Power: The Demoniac's Wraps",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Stanchion.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19718}},{270,3000}},
        },
        [85627] = {
            [questKeys.name] = "Paragons of Power: The Demoniac's Mantle",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Sash.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19720}},{270,9000}},
        },
        [85628] = {
            [questKeys.name] = "Paragons of Power: The Demoniac's Robes",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Kossack.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19723}},{270,21000}},
        },
        [85629] = {
            [questKeys.name] = "The Jewel of Kajaro",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{19600}}},
        },
        [85630] = {
            [questKeys.name] = "Paragons of Power: The Illusionist's Wraps",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing Primal Hakkari Bindings.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19716}},{270,3000}},
        },
        [85631] = {
            [questKeys.name] = "Paragons of Power: The Illusionist's Mantle",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Shawl.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19721}},{270,9000}},
        },
        [85632] = {
            [questKeys.name] = "Paragons of Power: The Illusionist's Robes",
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Al'tabim the All-Seeing a Primal Hakkari Kossack.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Al'tabim the All-Seeing is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19723}},{270,21000}},
        },
        [85633] = {
            [questKeys.name] = "Zandalarian Shadow Mastery Talisman",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{19616}}},
        },
        [85634] = {
            [questKeys.name] = "Paragons of Power: The Madcap's Bracers",
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Falthir the Sightless a Primal Hakkari Armsplint.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Falthir the Sightless is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19717}},{270,3000}},
        },
        [85635] = {
            [questKeys.name] = "Paragons of Power: The Madcap's Mantle",
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Falthir the Sightless a Primal Hakkari Girdle.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Falthir the Sightless is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19719}},{270,9000}},
        },
        [85636] = {
            [questKeys.name] = "Paragons of Power: The Madcap's Tunic",
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Falthir the Sightless a Primal Hakkari Aegis.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Falthir the Sightless is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19724}},{270,21000}},
        },
        [85637] = {
            [questKeys.name] = "Maelstrom's Wrath",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{19620}}},
        },
        [85638] = {
            [questKeys.name] = "Paragons of Power: The Predator's Bracers",
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the following Paragons of Power from Zul'Gurub to Falthir the Sightless: A Primal Hakkari Bindings.  You must also have a reputation equal to or greater than Friendly with the Zandalar Tribe.Falthir the Sightless is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19716}},{270,3000}},
        },
        [85639] = {
            [questKeys.name] = "Paragons of Power: The Predator's Belt",
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the following Paragons of Power from Zul'Gurub to Falthir the Sightless: A Primal Hakkari Shawl.  You must also have a reputation equal to or greater than Honored with the Zandalar Tribe.Falthir the Sightless is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19721}},{270,9000}},
        },
        [85640] = {
            [questKeys.name] = "Paragons of Power: The Predator's Mantle",
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the following Paragons of Power from Zul'Gurub to Falthir the Sightless: A Primal Hakkari Aegis.  You must also have a reputation equal to or greater than Revered with the Zandalar Tribe.Falthir the Sightless is located on Yojamba Isle, Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{19724}},{270,21000}},
        },
        [85643] = {
            [questKeys.name] = "The Lord of Blackrock",
            [questKeys.startedBy] = {{1748}},
            [questKeys.finishedBy] = {{14721}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Venture to the Valley of Heroes in Stormwind City and speak with Field Marshal Stonebridge."},
            [questKeys.objectives] = nil,
        },
        [85644] = {
            [questKeys.name] = "The Lord of Blackrock",
            [questKeys.startedBy] = {{4949}},
            [questKeys.finishedBy] = {{14720}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with High Overlord Saurfang in Orgrimmar. He stands waiting for you in the Valley of Strength."},
            [questKeys.objectives] = nil,
        },
        [85658] = {
            [questKeys.name] = "For All To See",
            [questKeys.startedBy] = {{4949}},
            [questKeys.finishedBy] = {{14392}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Overlord Runthak in the Valley of Strength."},
            [questKeys.objectives] = nil,
        },
        [85659] = {
            [questKeys.name] = "Celebrating Good Times",
            [questKeys.startedBy] = {{1748}},
            [questKeys.finishedBy] = {{14394}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Major Mattingly in the Valley of Heroes."},
            [questKeys.objectives] = nil,
        },
        [85660] = {
            [questKeys.name] = "The Heart of Hakkar",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14875}},
            [questKeys.requiredLevel] = 58,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Heart of Hakkar to Molthor on Yojamba Isle."},
            [questKeys.objectives] = nil,
        },
        [85699] = {
            [questKeys.name] = "Snakestone of the Shadow Huntress",
            [questKeys.startedBy] = {{11192}},
            [questKeys.finishedBy] = {{11192}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to Blackrock Spire and slay Shadow Hunter Vosh'gajin. Recover Vosh'gajin's Snakestone and return to Kilram."},
            [questKeys.objectives] = {nil,nil,{{13352}}},
        },
        [85700] = {
            [questKeys.name] = "Corruption",
            [questKeys.startedBy] = {{11193}},
            [questKeys.finishedBy] = {{11193}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the Black Guard Swordsmith in Stratholme and destroy him. Recover the Insignia of the Black Guard and return to Seril Scourgebane. A quest."},
            [questKeys.objectives] = {nil,nil,{{13350}}},
        },
        [85701] = {
            [questKeys.name] = "Dragonscale Leatherworking",
            [questKeys.startedBy] = {{7866}},
            [questKeys.finishedBy] = {{7866}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Tough Scorpid Breastplates, 2 Tough Scorpid Gloves, and 10 Worn Dragonscales to Peter Galen in Azshara.Completing this quest will give you access to the Dragonscale Leatherworking arts.The completion of this quest will prevent you from learning Elemental Leatherworking and Tribal Leatherworking; be sure this is the path you wish to follow before doing so."},
            [questKeys.objectives] = {nil,nil,{{8165},{8203},{8204}}},
        },
        [85702] = {
            [questKeys.name] = "Dragonscale Leatherworking",
            [questKeys.startedBy] = {{7867}},
            [questKeys.finishedBy] = {{7867}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Tough Scorpid Breastplates, 2 Tough Scorpid Gloves, and 10 Worn Dragonscales to Thorkaf Dragoneye in the Badlands.Completing this quest will give you access to the Dragonscale Leatherworking arts.The completion of this quest will prevent you from learning Elemental Leatherworking and Tribal Leatherworking; be sure this is the path you wish to follow before doing so."},
            [questKeys.objectives] = {nil,nil,{{8165},{8203},{8204}}},
        },
        [85703] = {
            [questKeys.name] = "Elemental Leatherworking",
            [questKeys.startedBy] = {{7868}},
            [questKeys.finishedBy] = {{7868}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Heart of Fire, 2 Globe of Water, 2 Core of Earth, and 2 Breath of Wind to Sarah Tanner in Searing Gorge.Completing this quest will give you access to the Elemental Leatherworking arts.The completion of this quest will prevent you from learning Dragonscale Leatherworking and Tribal Leatherworking; be sure this is the path you wish to follow before doing so."},
            [questKeys.objectives] = {nil,nil,{{7077},{7079},{7075},{7081}}},
        },
        [85704] = {
            [questKeys.name] = "Elemental Leatherworking",
            [questKeys.startedBy] = {{7869}},
            [questKeys.finishedBy] = {{7869}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Heart of Fire, 2 Globe of Water, 2 Core of Earth, and 2 Breath of Wind to Brumn Winterhoof in the Arathi Mountains.Completing this quest will give you access to the Elemental Leatherworking arts.The completion of this quest will prevent you from learning Dragonscale Leatherworking and Tribal Leatherworking; be sure this is the path you wish to follow before doing so."},
            [questKeys.objectives] = {nil,nil,{{7077},{7079},{7075},{7081}}},
        },
        [85705] = {
            [questKeys.name] = "Tribal Leatherworking",
            [questKeys.startedBy] = {{7870}},
            [questKeys.finishedBy] = {{7870}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Wild Leather Vest and a Wild Leather Helmet to Caryssia Moonhunter in Feralas.Completing this quest will give you access to the Tribal Leatherworking arts.The completion of this quest will prevent you from learning Dragonscale Leatherworking and Elemental Leatherworking; be sure this is the path you wish to follow before doing so."},
            [questKeys.objectives] = {nil,nil,{{8211},{8214}}},
        },
        [85706] = {
            [questKeys.name] = "Tribal Leatherworking",
            [questKeys.startedBy] = {{7871}},
            [questKeys.finishedBy] = {{7871}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Wild Leather Vest and a Wild Leather Helmet to Se'Jib in Stranglethorn Vale.Completing this quest will give you access to the Tribal Leatherworking arts.The completion of this quest will prevent you from learning Dragonscale Leatherworking and Elemental Leatherworking; be sure this is the path you wish to follow before doing so."},
            [questKeys.objectives] = {nil,nil,{{8211},{8214}}},
        },
        [85712] = {
            [questKeys.name] = "The Art of the Armorsmith",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To become an armorsmith, you must make the following items and return them to Okothos: 4 Ornate Mithril Helms, 2 Ornate Mithril Boots, 1 Ornate Mithril Breastplate."},
            [questKeys.objectives] = {nil,nil,{{7937},{7936},{7935}}},
        },
        [85713] = {
            [questKeys.name] = "The Art of the Armorsmith",
            [questKeys.startedBy] = {{5164}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To become an Armorsmith, you must make the following items and return them to Grumnus: 4 Ornate Mithril Helms, 2 Ornate Mithril Boots, 1 Ornate Mithril Breastplate."},
            [questKeys.objectives] = {nil,nil,{{7937},{7936},{7935}}},
        },
        [85772] = {
            [questKeys.name] = "Elemental Distress",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect motes of elemental rage, and bring them to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [85798] = {
            [questKeys.name] = "Arms for the Field",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{15443}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Moonsteel Broadswords to Janela Stouthammer at the Ironforge Brigade Outpost outside of Hive'Zora.  You must also bring Logistics Task Briefing VI in order to complete this quest."},
            [questKeys.objectives] = {nil,nil,{{217281}}},
        },
        [85882] = {
            [questKeys.name] = "End of the Dark Horde",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{332}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Head of Rend Blackhand to Master Mathias Shaw in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [85883] = {
            [questKeys.name] = "For The Horde!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4949}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to Blackrock Spire and slay Warchief Rend Blackhand. Take his head and return to Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [85963] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{11039}},
            [questKeys.finishedBy] = {{11039}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those adventurers who have but a single commendation signet, I'll exchange it for a small amount of recognition with the Argent Dawn.Please bear in mind that it is better to hand over a stack of ten signets at once; your efforts will receive greater recognition in doing so. &nbsp;We offer a single signet exchange as a service for those who don't have enough for a full stack of ten.With that being said, I stand ready to assist you if you still wish to hand in a single signet."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85964] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{11039}},
            [questKeys.finishedBy] = {{11039}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I'll make sure that you receive a significant acknowledgement of your deeds with the Argent Dawn. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85965] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{11039}},
            [questKeys.finishedBy] = {{11039}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those adventurers who have but a single commendation signet, I'll exchange it for a small amount of recognition with the Argent Dawn.Please bear in mind that it is better to hand over a stack of ten signets at once; your efforts will receive greater recognition in doing so. &nbsp;We offer a single signet exchange as a service for those who don't have enough for a full stack of ten.With that being said, I stand ready to assist you if you still wish to hand in a single signet."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85966] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{11039}},
            [questKeys.finishedBy] = {{11039}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I'll make sure that you receive a significant acknowledgement of your deeds with the Argent Dawn. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85967] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{15282}},
            [questKeys.finishedBy] = {{15282}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I'll make sure that you receive a significant acknowledgement of your deeds with the Cenarion Circle. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85968] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{15282}},
            [questKeys.finishedBy] = {{15282}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those adventurers who have but a single commendation signet, I'll exchange it for a small amount of recognition with the Cenarion Circle.Please bear in mind that it is better to hand over a stack of ten signets at once; your efforts will receive greater recognition in doing so. &nbsp;We offer a single signet exchange as a service for those who don't have enough for a full stack of ten.With that being said, I stand ready to assist you if you still wish to hand in a single signet."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85969] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{15282}},
            [questKeys.finishedBy] = {{15282}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I'll make sure that you receive a significant acknowledgement of your deeds with the Cenarion Circle. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85970] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{15282}},
            [questKeys.finishedBy] = {{15282}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those adventurers who have but a single commendation signet, I'll exchange it for a small amount of recognition with the Cenarion Circle.Please bear in mind that it is better to hand over a stack of ten signets at once; your efforts will receive greater recognition in doing so. &nbsp;We offer a single signet exchange as a service for those who don't have enough for a full stack of ten.With that being said, I stand ready to assist you if you still wish to hand in a single signet."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85971] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85972] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{13278}},
            [questKeys.finishedBy] = {{13278}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those adventurers who have but a single commendation signet, I will exchange it for a small amount of recognition with my forces, the Hydraxian Waterlords.Please bear in mind that it is better to hand over a stack of ten signets at once; your efforts will receive greater recognition in doing so. &nbsp;I offer a single signet exchange as a service for those who do not have enough for a full stack of ten.With that being said, I will accept it if you still wish to hand in a single signet."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85973] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{13278}},
            [questKeys.finishedBy] = {{13278}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, you will receive significant recognition from my forces, the Hydraxian Waterlords. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;I am much more interested in greater feats of duty, though no feat will be ignored.With that said, I will accept your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85974] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{13278}},
            [questKeys.finishedBy] = {{13278}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, you will receive significant recognition from my forces, the Hydraxian Waterlords. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;I am much more interested in greater feats of duty, though no feat will be ignored.With that said, I will accept your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85975] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85976] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85977] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85978] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{14625}},
            [questKeys.finishedBy] = {{14625}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I'll make sure that you receive a significant acknowledgement of your deeds with the Thorium Brotherhood. &nbsp;I also accept single tokens, but at a much reduced rate of recognition. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85979] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85980] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85981] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{2496}},
            [questKeys.finishedBy] = {{2496}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85982] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85983] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85984] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{14910}},
            [questKeys.finishedBy] = {{14910}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those adventurers who have but a single commendation signet, I will exchange it for a minor recognition with the Zandalar Tribe.Bear in mind it is better to hand over a stack of ten signets at once; your efforts will receive the greater recognition in doing so. &nbsp;We also offer a single signet exchange as a boon for those who do not have enough for a full stack of ten.Even so, I stand ready to assist you if you still wish to hand in the single signet."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85985] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{14910}},
            [questKeys.finishedBy] = {{14910}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I will make sure that you receive a great boon recognition with the Zandalar Tribe. &nbsp;I also accept single tokens, but with a much smaller boon. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85986] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{14910}},
            [questKeys.finishedBy] = {{14910}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from adventurers who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, I will make sure that you receive a great boon recognition with the Zandalar Tribe. &nbsp;I also accept single tokens, but with a much smaller boon. &nbsp;We are much more interested in greater feats of duty, though no feat will be ignored.With that said, I'll gladly take your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [85987] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = {{15395}},
            [questKeys.finishedBy] = {{15395}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For those outsiders who come to me with a single commendation signet, I will exchange it for a small amount of favor with the Timbermaw.Bear in mind that I am more impressed by a stack of ten signets at once; your efforts will receive greater favor from doing so. &nbsp;I offer a single signet exchange merely as a convenience to those who don't have a full stack of ten.However, I stand ready to assist you if you still wish to give me a single signet."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [85988] = {
            [questKeys.name] = "One Commendation Signet",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [86160] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{15395}},
            [questKeys.finishedBy] = {{15395}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from outsiders who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, you will receive significant favor with the Timbermaw. &nbsp;I also accept single tokens, but for much less favor. &nbsp;I am much more interested in greater feats of service, though no feat will be ignored.I'll gladly exchange your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21436}}},
        },
        [86161] = {
            [questKeys.name] = "Ten Commendation Signets",
            [questKeys.startedBy] = {{15395}},
            [questKeys.finishedBy] = {{15395}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I accept commendation signets from outsiders who have received them in the line of duty. &nbsp;For each set of ten that you hand to me, you will receive significant favor with the Timbermaw. &nbsp;I also accept single tokens, but for much less favor. &nbsp;I am much more interested in greater feats of service, though no feat will be ignored.I'll gladly exchange your signets if you are ready to hand in a set."},
            [questKeys.objectives] = {nil,nil,{{21438}}},
        },
        [86326] = {
            [questKeys.name] = "Desert Power",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak to Selestrasza to claim your Qiraji Resonating Crystal."},
            [questKeys.objectives] = {{{234539}}},
        },
        [86442] = {
            [questKeys.name] = "Nefarius's Corruption",
            [questKeys.startedBy] = {{13020}},
            [questKeys.finishedBy] = {{15192}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Slay Nefarian and recover the Red Scepter Shard. Return the Red Scepter Shard to Anachronos at the Caverns of Time in Tanaris. You have 5 hours to complete this task."},
            [questKeys.objectives] = {nil,nil,{{21142},{21138}}},
        },
        [86443] = {
            [questKeys.name] = "The Nightmare Manifests",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defend Nighthaven from Eranikus. Do not let Keeper Remulos perish. Do not slay Eranikus. Defend yourself. Await Tyrande."},
            [questKeys.objectives] = nil,
        },
        [86444] = {
            [questKeys.name] = "The Only Prescription",
            [questKeys.startedBy] = {{11811}},
            [questKeys.finishedBy] = {{11811}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the 8 lost chapters of Draconic for Dummies and combine them with the Magical Book Binding and return the completed book of Draconic for Dummies: Volume II to Narain Soothfancy in Tanaris."},
            [questKeys.objectives] = {nil,nil,{{21111},{21112}}},
        },
        [86445] = {
            [questKeys.name] = "The Wrath of Neptulon",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{15192}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the Arcanite Buoy at the Swirling Maelstrom at the Bay of Storms in Azshara."},
            [questKeys.objectives] = {nil,nil,{{21136},{21137}}},
        },
        [86449] = {
            [questKeys.name] = "Treasure of the Timeless One",
            [questKeys.startedBy] = {{15693}},
            [questKeys.finishedBy] = {{15693}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Greetings, champion. I am Jonathan, keeper of the sacred gong and eternal watcher of the Bronze Flight.I have been empowered by the Timeless One himself to grant you an item of your choosing from his timeless treasure trove. May it aid you in your battles against C'Thun."},
            [questKeys.objectives] = nil,
        },
        [86670] = {
            [questKeys.name] = "The Savior of Kalimdor",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Eye of C'Thun to Anachronos at the Caverns of Time."},
            [questKeys.objectives] = nil,
        },
        [86671] = {
            [questKeys.name] = "Imperial Qiraji Regalia",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Merithra of the Dream in the Temple of Ahn'Qiraj will create Elementium Infused Armaments for you should you bring her Imperial Qiraji Regalia and 3 Elementium Ore."},
            [questKeys.objectives] = {nil,nil,{{235045},{18562}}},
        },
        [86672] = {
            [questKeys.name] = "Imperial Qiraji Armaments",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Arygos in the Temple of Ahn'Qiraj will create Elementium Infused Armaments for you should you bring him Imperial Qiraji Armaments and 3 Elementium Ore."},
            [questKeys.objectives] = {nil,nil,{{235046},{18562}}},
        },
        [86673] = {
            [questKeys.name] = "The Fall of Ossirian",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Deliver the Head of Ossirian the Unscarred to Commander Mar'alith at Cenarion Hold in Silithus."},
            [questKeys.objectives] = nil,
        },
        [86674] = {
            [questKeys.name] = "The Perfect Poison",
            [questKeys.startedBy] = {{16091}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Dirk Thunderwood at Cenarion Hold wants you to bring him Venoxis's Venom Sac and Kurinnaxx's Venom Sac."},
            [questKeys.objectives] = {nil,nil,{{22216},{22217}}},
        },
        [86675] = {
            [questKeys.name] = "Volunteer's Battlegear",
            [questKeys.startedBy] = {{15176}},
            [questKeys.finishedBy] = {{15176}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 5 Cenarion Combat Badges, 3 Cenarion Logistics Badges and 7 Cenarion Tactical Badges to Vargus at Cenarion Hold in Silithus.  You must also attain Friendly reputation with Cenarion Circle to be able to complete this quest."},
            [questKeys.objectives] = {nil,nil,{{20802},{20800},{20801}},{609,3000}},
        },
        [86676] = {
            [questKeys.name] = "Veteran's Battlegear",
            [questKeys.startedBy] = {{15176}},
            [questKeys.finishedBy] = {{15176}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 7 Cenarion Combat Badges, 4 Cenarion Logistics Badges and 4 Cenarion Tactical Badges to Vargus at Cenarion Hold in Silithus.  You must also attain Honored reputation with Cenarion Circle to be able to complete this quest."},
            [questKeys.objectives] = {nil,nil,{{20802},{20800},{20801}},{609,9000}},
        },
        [86677] = {
            [questKeys.name] = "Stalwart's Battlegear",
            [questKeys.startedBy] = {{15176}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 15 Cenarion Combat Badges, 20 Cenarion Logistics Badges, 17 Cenarion Tactical Badges and 1 Mark of Remulos to Vargus at Cenarion Hold in Silithus.  You must also attain Revered reputation with Cenarion Circle to be able to complete this quest."},
            [questKeys.objectives] = {nil,nil,{{20802},{20800},{20801},{21515}},{609,21000}},
        },
        [86678] = {
            [questKeys.name] = "Champion's Battlegear",
            [questKeys.startedBy] = {{15176}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 15 Cenarion Combat Badges, 20 Cenarion Logistics Badges, 20 Cenarion Tactical Badges and 1 Mark of Cenarius to Vargus at Cenarion Hold in Silithus.  You must also attain Exalted reputation with Cenarion Circle to be able to complete this quest."},
            [questKeys.objectives] = {nil,nil,{{20802},{20800},{20801},{21508}},{609,42000}},
        },
        [86679] = {
            [questKeys.name] = "Shrouded in Nightmare",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find someone capable of deciphering the meaning behind the Nightmare Engulfed Object.Perhaps a druid of great power could assist you. A quest."},
            [questKeys.objectives] = nil,
        },
        [86680] = {
            [questKeys.name] = "Waking Legends",
            [questKeys.startedBy] = {{11832}},
            [questKeys.finishedBy] = {{11832}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Wait for Keeper Remulos at the Moonglade to cleanse the Nightmare Engulfed Object."},
            [questKeys.objectives] = nil,
        },
        [86724] = {
            [questKeys.name] = "Dust to Dust",
            [questKeys.startedBy] = {{17070}},
            [questKeys.finishedBy] = {{17070}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find and deliver 5 Silithyst to the Silithyst Extractor then speak with Apothecary Quinard at the Horde encampment near Hive'Regal. Rewards ."},
            [questKeys.objectives] = {{{18199}}},
        },
        [86725] = {
            [questKeys.name] = "Dust to Dust",
            [questKeys.startedBy] = {{17068}},
            [questKeys.finishedBy] = {{17068}},
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find and deliver 5 Silithyst to the Silithyst Extractor then speak with Chief Expeditionary Requisitioner Enkles at the Alliance encampment near Hive'Zora."},
            [questKeys.objectives] = {{{17090}}},
        },
        [86760] = {
            [questKeys.name] = "Darkmoon Beast Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Beast Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = {nil,nil,{{19228},{235278}}},
        },
        [86761] = {
            [questKeys.name] = "Darkmoon Warlords Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Warlords Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = {nil,nil,{{19257},{235277}}},
        },
        [86762] = {
            [questKeys.name] = "Darkmoon Elementals Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Elementals Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{19267},{235276}}},
        },
        [86763] = {
            [questKeys.name] = "Darkmoon Portals Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Portals Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = {nil,nil,{{19277},{235275}}},
        },
        [86964] = {
            [questKeys.name] = "For Gold and Glory!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"It appears as if someone was looking to hire adventurers to recover something valuable from the Karazhan Crypts in Deadwind Pass. You can't be sure who posted this flyer or where to find them, but the idea of a considerable reward from a well-established and deep-pocketed organization such as the Kirin Tor, as well as a cache of hidden treasure up for the taking is an admittedly interesting prospect.","","Travel to Deadwind Pass and investigate the Crypts behind Karazhan tower."},
            [questKeys.objectives] = nil,
        },
        [86965] = {
            [questKeys.name] = "No Ordinary Shadows",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The gloom seeping from the entrance of the crypt seems to defy all normal logic and reason. No light enters or deters the darkness, and no light inside seems to escape it. You strongly suspect that venturing into the crypt as you are now could be the end of you.","","You'll need to somehow find a way to get past this darkness if you wish to proceed. You seem to recall that there is an Agent of Dalaran at a camp to the north. Perhaps she knows more about the dead adventurer and this strange darkness?"},
            [questKeys.objectives] = nil,
        },
        [86966] = {
            [questKeys.name] = "Seeking Survivors",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Search for any survivors of the unfortunate adventuring party and try to learn what you can about what happened in the crypt."},
            [questKeys.objectives] = nil,
        },
        [86967] = {
            [questKeys.name] = "To the Rescue",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the key to the cage in the Deadwind ogre cave and free the injured adventurer inside."},
            [questKeys.objectives] = {{{237821}}},
        },
        [86968] = {
            [questKeys.name] = "Are You Afraid of the Dark?",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Listen to Harrison Jones while he tells you what happened in Karazhan Crypts."},
            [questKeys.objectives] = {{{237823}}},
        },
        [86969] = {
            [questKeys.name] = "The Hypothesis",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Consult the list of materials needed and bring Agent Keanna the components requested."},
            [questKeys.objectives] = {nil,nil,{{235789},{235787},{235788},{236002}}},
        },
        [86970] = {
            [questKeys.name] = "Testing Our Hypothesis",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to the entrance to the Karazhan Crypts, use the Faerie Flame Torch, and see what happens."},
            [questKeys.objectives] = {{{238512}}},
        },
        [86971] = {
            [questKeys.name] = "Curious Karazhan Curios!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Karazhan Curio to Harrison Jones in Deadwind Pass."},
            [questKeys.objectives] = {nil,nil,{{235786}}},
        },
        [86972] = {
            [questKeys.name] = "Curious Karazhan Curios!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{237818}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Karazhan Curio to Harrison Jones in Deadwind Pass."},
            [questKeys.objectives] = {nil,nil,{{235786}}},
        },
        [87283] = {
            [questKeys.name] = "The Violet Satchel",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Archmage Tarsis Kir-Moldir and return the The Violet Satchel to him."},
            [questKeys.objectives] = {{{237957}}},
        },
        [87360] = {
            [questKeys.name] = "The Fall of Kel'Thuzad",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Phylactery of Kel'Thuzad to Light's Hope Chapel in the Eastern Plaguelands."},
            [questKeys.objectives] = nil
        },
        [87361] = {
            [questKeys.name] = "Laid to Rest",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"See if anyone can assist you at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = nil
        },
        [87362] = {
            [questKeys.name] = "Hope Begins in the Dark",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Receive the Seal of the Dawn."},
            [questKeys.objectives] = nil
        },
        [87364] = {
            [questKeys.name] = "Seal the Deal",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect Remnants of Valor within Naxxramas."},
            [questKeys.objectives] = {nil,nil,{{236397}}}
        },
        [87365] = {
            [questKeys.name] = "Valor Grows by Daring",
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect Remnants of Valor within Naxxramas."},
            [questKeys.objectives] = {nil,nil,{{236397}}},
        },
        [87366] = {
            [questKeys.name] = "Knight Time",
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect Remnants of Valor within Naxxramas."},
            [questKeys.objectives] = {nil,nil,{{236397}}},
        },
        [87367] = {
            [questKeys.name] = "A New Light",
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Receive the Seal of the Dawn."},
            [questKeys.objectives] = {nil,nil,{{236397}}},
        },
        [87368] = {
            [questKeys.name] = "A Product of Faith",
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Receive the Seal of the Dawn."},
            [questKeys.objectives] = {nil,nil,{{236397}}},
        },
        [87369] = {
            [questKeys.name] = "Cultivating Faith",
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Receive the Seal of the Dawn."},
            [questKeys.objectives] = {nil,nil,{{236397}}},
        },
        [87377] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [87433] = {
            [questKeys.name] = "Argent Dawn Plate Gloves",
            [questKeys.startedBy] = {{16787}},
            [questKeys.finishedBy] = {{16787}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87434] = {
            [questKeys.name] = "Argent Dawn Plate Gloves",
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87435] = {
            [questKeys.name] = "Argent Dawn Mail Gloves",
            [questKeys.startedBy] = {{16787}},
            [questKeys.finishedBy] = {{16787}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87436] = {
            [questKeys.name] = "Argent Dawn Mail Gloves",
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87437] = {
            [questKeys.name] = "Argent Dawn Leather Gloves",
            [questKeys.startedBy] = {{16787}},
            [questKeys.finishedBy] = {{16787}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87438] = {
            [questKeys.name] = "Argent Dawn Leather Gloves",
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87439] = {
            [questKeys.name] = "Argent Dawn Cloth Gloves",
            [questKeys.startedBy] = {{16787}},
            [questKeys.finishedBy] = {{16787}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the &lt;race&gt; Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87440] = {
            [questKeys.name] = "Argent Dawn Cloth Gloves",
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"If you bring me thirty necrotic runes, I will give you your choice of hand protection in return. These should prove valuable in our fight against the undead Scourge."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [87441] = {
            [questKeys.name] = "Atiesh, Greatstaff of the Guardian",
            [questKeys.startedBy] = {{15192}},
            [questKeys.finishedBy] = {{15192}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Anachronos at the Caverns of Time in Tanaris wants you to take Atiesh, Greatstaff of the Guardian to Stratholme and use it on Consecrated Earth. Defeat the entity that is exorcised from the staff and return to him."},
            [questKeys.objectives] = {{{16387}}},
        },
        [87442] = {
            [questKeys.name] = "Atiesh, Greatstaff of the Guardian",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{15192}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Anachronos at the Caverns of Time in Tanaris wants you to take Atiesh, Greatstaff of the Guardian to Stratholme and use it on Consecrated Earth. Defeat the entity that is exorcised from the staff and return to him."},
            [questKeys.objectives] = {{{16387}}},
        },
        [87443] = {
            [questKeys.name] = "Atiesh, Greatstaff of the Guardian",
            [questKeys.startedBy] = {{15192}},
            [questKeys.finishedBy] = {{15192}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Anachronos at the Caverns of Time in Tanaris wants you to take Atiesh, Greatstaff of the Guardian to Stratholme and use it on Consecrated Earth. Defeat the entity that is exorcised from the staff and return to him."},
            [questKeys.objectives] = {{{16387}}},
        },
        [87444] = {
            [questKeys.name] = "Atiesh, Greatstaff of the Guardian",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{15192}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Anachronos at the Caverns of Time in Tanaris wants you to take Atiesh, Greatstaff of the Guardian to Stratholme and use it on Consecrated Earth. Defeat the entity that is exorcised from the staff and return to him."},
            [questKeys.objectives] = {{{16387}}},
        },
        [87459] = {
            [questKeys.name] = "Scarlet Activities",
            [questKeys.startedBy] = {{11036}},
            [questKeys.finishedBy] = {{11036}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to the area near the Crusader Outpost northwest of The Bulwark in Tirisfal Glades and investigate for signs of recent Scarlet Crusade activity. Bring any information you recover back to Leonid Bartholomew the Revered."},
            [questKeys.objectives] = {nil,nil,{{237143}}},
        },
        [87493] = {
            [questKeys.name] = "Unrest at Tyr's Hand",
            [questKeys.startedBy] = {{11036}},
            [questKeys.finishedBy] = {{239032}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Scout out the Scarlet Base Camp west of Tyr's Hand  in Eastern Plaguelands and try to discern what is happening with the Scarlet Crusade forces there."},
            [questKeys.objectives] = nil,
        },
        [87497] = {
            [questKeys.name] = "The Schism",
            [questKeys.startedBy] = {{239032}},
            [questKeys.finishedBy] = {{11036}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Beatrix to learn more about the situation in the Scarlet Enclave at Tyr's Hand and report back to Leonid Barthalomew the Revered at Light's Hope Chapel once you've learned more about what is happening."},
            [questKeys.objectives] = {{{239042}}},
        },
        [87498] = {
            [questKeys.name] = "The Scarlet Reclamation",
            [questKeys.startedBy] = {{11036}},
            [questKeys.finishedBy] = {{239032}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Commander Beatrix at the Scarlet Base Camp west of Tyr's Hand."},
            [questKeys.objectives] = nil,
        },
        [87502] = {
            [questKeys.name] = "Gathering Intelligence",
            [questKeys.startedBy] = {{239031}},
            [questKeys.finishedBy] = {{239031}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Enter Tyr's Hand in Eastern Plaguelands and scout out the central cathedral, as well as the mage tower and keep inside of New Avalon before returning to Caldoran at the Scarlet Base Camp. ","","A direct incursion is possible but may be dangerous. Speak with Inquisitor Jociphine at the Scarlet Base Camp if you'd prefer a more subtle approach."},
            [questKeys.objectives] = {{{239154},{239152},{239153}}},
        },
        [87506] = {
            [questKeys.name] = "Weakening The Defenses",
            [questKeys.startedBy] = {{239031}},
            [questKeys.finishedBy] = {{239032}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Enter Tyr's Hand in Eastern Plaguelands, slay three Scarlet Siege Commanders."},
            [questKeys.objectives] = {{{239047}}},
        },
        [87508] = {
            [questKeys.name] = "Report to Lord Tyrosus",
            [questKeys.startedBy] = {{239054}},
            [questKeys.finishedBy] = {{11034}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Lord Maxwell Tyrosus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = nil,
        },
        [87509] = {
            [questKeys.name] = "The Wrath of the Dawn",
            [questKeys.startedBy] = {{11034}},
            [questKeys.finishedBy] = {{239032}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Report back to Commander Beatrix at the Scarlet Base Camp in Eastern Plaguelands and make ready to retake the Scarlet Enclave."},
            [questKeys.objectives] = {{{239032}}},
        },
        [87516] = {
            [questKeys.name] = "Decapitation Strike",
            [questKeys.startedBy] = {{239032}},
            [questKeys.finishedBy] = {{239337}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Enter the Scarlet Enclave via the mountain path and engage the Tyr's Hand defenders. Ring the bell inside of the abbey to create confusion and signal Beatrix's forces to attack. ","","Once the bell is rung, confront Balnazzar and destroy him."},
            [questKeys.objectives] = nil,
        },
        [87517] = {
            [questKeys.name] = "Red = Dead",
            [questKeys.startedBy] = {{239337}},
            [questKeys.finishedBy] = {{239337}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Join the battle and gain access to the inner portion of the Scarlet Enclave. Engage High Commander Beatrix's forces and defeat her, then slay the dragon, Solistrasza inside of the inner walls to the enclave."},
            [questKeys.objectives] = {{{238954},{240812}}},
        },
        [87518] = {
            [questKeys.name] = "Fall of the Grand Crusader",
            [questKeys.startedBy] = {{239337}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Slay Grand Crusader Baelin Caldoran in the Scarlet Enclave's inner sanctum."},
            [questKeys.objectives] = {{{241006}}},
        },
        [88654] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{237504}}},
        },
        [88713] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [88714] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [88715] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [88716] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [88717] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [88718] = {
            [questKeys.name] = "Never at Rest",
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring another Heart of Doom to Brother Luctus at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{236786}}},
        },
        [88721] = {
            [questKeys.name] = "Superior Armaments of Battle - Friend of the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 30 Insignias of the Dawn and 30 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88722] = {
            [questKeys.name] = "Superior Armaments of Battle - Honored Amongst the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 20 Insignias of the Dawn and 20 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88723] = {
            [questKeys.name] = "Superior Armaments of Battle - Revered Amongst the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 7 Insignias of the Dawn and 7 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88724] = {
            [questKeys.name] = "Superior Armaments of Battle - Exalted Amongst the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 6 Insignias of the Dawn and 6 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88725] = {
            [questKeys.name] = "Epic Armaments of Battle - Friend of the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 110 Insignias of the Dawn and 110 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88726] = {
            [questKeys.name] = "Epic Armaments of Battle - Honored Amongst the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 75 Insignias of the Dawn and 75 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88727] = {
            [questKeys.name] = "Epic Armaments of Battle - Revered Amongst the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 45 Insignias of the Dawn and 45 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88728] = {
            [questKeys.name] = "Epic Armaments of Battle - Exalted Amongst the Dawn",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"For 27 Insignias of the Dawn and 27 Insignias of the Crusade you may choose an item from the Argent Dawn's treasure cache."},
            [questKeys.objectives] = {nil,nil,{{22523},{22524}}},
        },
        [88729] = {
            [questKeys.name] = "Ramaladni's Icy Grasp",
            [questKeys.startedBy] = {{16112}},
            [questKeys.finishedBy] = {{16112}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Korfax at Light's Hope Chapel in the Eastern Plaguelands wants you to bring him 1 Frozen Rune, 1 Blue Sapphire and 1 Arcanite Bar. Rewards Ramaladni's Icy Grasp."},
            [questKeys.objectives] = {nil,nil,{{12361},{12360},{236656}}},
        },
        [88730] = {
            [questKeys.name] = "The Only Song I Know...",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craftsman Wilhelm at Light's Hope Chapel in the Eastern Plaguelands wants you to bring him 2 Frozen Runes, 2 Essence of Water, 2 Blue Sapphires and 30 gold pieces."},
            [questKeys.objectives] = {nil,nil,{{7080},{12361},{236656}}},
        },
        [88744] = {
            [questKeys.name] = "Under the Shadow",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Check your map to find an area under Scourge attack. Go there and damage a necropolis by defeating the Scourge around them. Return 10 of their Necrotic Runes to Commander Thomas Helleran at Light's Hope Chapel in the Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [88745] = {
            [questKeys.name] = "Shadows of Doom",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Go to a summoning circle and kill a Shadow of Doom, then return to Commander Thomas Helleran at Light's Hope Chapel in Eastern Plaguelands."},
            [questKeys.objectives] = {{{16143}}},
        },
        [88746] = {
            [questKeys.name] = "Consecrated Sharpening Stones",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [88747] = {
            [questKeys.name] = "Consecrated Sharpening Stones",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [88748] = {
            [questKeys.name] = "Cracked Necrotic Crystal",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Cracked Necrotic Crystal to Lieutenant Orrin outside the gates of Stormwind."},
            [questKeys.objectives] = nil,
        },
        [88749] = {
            [questKeys.name] = "Faint Necrotic Crystal",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Faint Necrotic Crystal to Lieutenant Rukag in the courtyard of the Undercity."},
            [questKeys.objectives] = nil,
        },
        [88882] = {
            [questKeys.name] = "Blessed Wizard Oil",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [88883] = {
            [questKeys.name] = "Blessed Wizard Oil",
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{22484}}},
        },
        [88968] = {
            [questKeys.name] = "The Lord of Blackrock",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with High Overlord Saurfang in Orgrimmar. He stands waiting for you in the Valley of Strength."},
            [questKeys.objectives] = nil,
        },
        [88969] = {
            [questKeys.name] = "The Lord of Blackrock",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Venture to the Valley of Heroes in Stormwind City and speak with Field Marshal Stonebridge."},
            [questKeys.objectives] = nil,
        },
        [89224] = {
            [questKeys.name] = "Food Shortage",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire Unappetizing Leftovers from across New Avalon and return them to the chef. If you are having trouble finding them scattered around, you may have better luck solving this shortage with violence."},
            [questKeys.objectives] = {nil,nil,{{238794}}},
        },
        [89229] = {
            [questKeys.name] = "The Right Path",
            [questKeys.startedBy] = {{243386}},
            [questKeys.finishedBy] = {{11036}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Leonid Barthalomew the Revered at Light's Hope Chapel to receive your reward."},
            [questKeys.objectives] = nil,
        },
        [89232] = {
            [questKeys.name] = "The First Step",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{241334}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with the Will of the Ashbringer and hear what it has to say."},
            [questKeys.objectives] = {{{241335}}},
        },
        [89234] = {
            [questKeys.name] = "A Personal Matter",
            [questKeys.startedBy] = {{242019}},
            [questKeys.finishedBy] = {{243393}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Meet Leonid Barthalomew the Revered just outside the service entrance gate to the east of the front gates of Stratholme."},
            [questKeys.objectives] = nil,
        },
        [89235] = {
            [questKeys.name] = "The Culling",
            [questKeys.startedBy] = {{243393}},
            [questKeys.finishedBy] = {{243393}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Enter Stratholme and make your way through the gate leading into Slaughter Square and find Leonid Barthalomew the Revered there."},
            [questKeys.objectives] = {{{243385}}},
        },
        [89236] = {
            [questKeys.name] = "Wrangling Apples",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate the apple orchard in the southern section of New Avalon to fetch some apples. Return to Carrie Hearthfire in the New Avalon inn once you have succeeded. If you find the apples to be too expensive, consider looking around for an alternative means to acquire them."},
            [questKeys.objectives] = {nil,nil,{{238811},{238831},{238830}}},
        },
        [89237] = {
            [questKeys.name] = "This Could Get Expensive...",
            [questKeys.startedBy] = {{242125}},
            [questKeys.finishedBy] = {{242125}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Master Craftsman Omarion 20 Arcanite Bars, 20 Obsidian-Infused Thorium Bars, 120 Truesilver Bars, 10 Huge Emeralds, and 20 Righteous Orbs."},
            [questKeys.objectives] = {nil,nil,{{12360},{234003},{6037},{12364},{12811}}},
        },
        [89245] = {
            [questKeys.name] = "Fish in a Barrel",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Investigate the boat docked south of New Avalon for a shipment of fish and return a haul back to Carrie."},
            [questKeys.objectives] = {nil,nil,{{238899}}},
        },
        [89253] = {
            [questKeys.name] = "Main Course",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire meat that is safe for human consumption. If you struggle to locate some in New Avalon, you may (eventually) gather enough from slaying beasts in the Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{238935}}},
        },
        [89255] = {
            [questKeys.name] = "Prove Your Worth: Headgear",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a Scarlet Headgear from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89256] = {
            [questKeys.name] = "Prove Your Worth: Shoulderpads",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a Scarlet Shoulderpads from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89257] = {
            [questKeys.name] = "Prove Your Worth: Chestpiece",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a Scarlet Chestpiece from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89258] = {
            [questKeys.name] = "Prove Your Worth: Wristguards",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a pair of Scarlet Bracers from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89259] = {
            [questKeys.name] = "Prove Your Worth: Gloves",
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a pair of Scarlet Gloves from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89260] = {
            [questKeys.name] = "Prove Your Worth: Belt",
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a Scarlet Belt from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89261] = {
            [questKeys.name] = "Prove Your Worth: Legguards",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a pair of Scarlet Pants from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89262] = {
            [questKeys.name] = "Prove Your Worth: Boots",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft a pair of Scarlet Boots from any armor crafting profession or donate any piece of crafted Scarlet Uniform equipment. ","","If you choose to donate, you can find a crate near the quartermaster inside of the barracks. Deliver the crated item back to Bryon Steelblade to receive credit."},
            [questKeys.objectives] = {{{241154}}},
        },
        [89300] = {
            [questKeys.name] = "The Ashbringer",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{241334}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Equip the Hilt of the Ashbringer and use the blade to commune with the disembodied spirit you hear in your head."},
            [questKeys.objectives] = {nil,nil,{{239010}}},
        },
        [89301] = {
            [questKeys.name] = "A Difficult Path",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{241334}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with the Will of the Ashbringer to learn what is needed to access the peak of Mount Hyjal."},
            [questKeys.objectives] = {{{242170}}},
        },
        [89303] = {
            [questKeys.name] = "On Fate's Path",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{241334}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Omarion inside of the Scarlet Enclave and ask him how the work on his new lightforged alloy is going.","","Speak with the Will of the Ashbringer when you have what you need."},
            [questKeys.objectives] = {nil,nil,{{239197}}},
        },
        [89304] = {
            [questKeys.name] = "The Perfect Metal",
            [questKeys.startedBy] = {{242125}},
            [questKeys.finishedBy] = {{242125}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Omarion about what comes next."},
            [questKeys.objectives] = nil,
        },
        [89310] = {
            [questKeys.name] = "Terrordale",
            [questKeys.startedBy] = {{243393}},
            [questKeys.finishedBy] = {{243386}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to Terrordale and find Leonid Barthalomew the Revered at one of the houses there."},
            [questKeys.objectives] = nil,
        },
        [89328] = {
            [questKeys.name] = "Loss",
            [questKeys.startedBy] = {{243386}},
            [questKeys.finishedBy] = {{243386}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Hear the final part of Leonid's story."},
            [questKeys.objectives] = {{{243387}}},
        },
        [89329] = {
            [questKeys.name] = "Stomping Out The Infestation",
            [questKeys.startedBy] = {{243386}},
            [questKeys.finishedBy] = {{243386}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Slay 5 Crypt Walkers and 8 Crypt Fiends then return to Leonid Barthalomew the Revered at his former home in Terrordale."},
            [questKeys.objectives] = {{{8555},{8556}}},
        },
        [89340] = {
            [questKeys.name] = "Preposterously Prosed Postage",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Finish the delivery."},
            [questKeys.objectives] = {nil,nil,{{239092}}},
        },
        [89341] = {
            [questKeys.name] = "The Great Feast",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Aid Carrie Hearthfire in New Avalon one last time by gathering the following ingredients:."},
            [questKeys.objectives] = {nil,nil,{{6362},{4603},{13888},{3404},{12184},{3712}}},
        },
        [89342] = {
            [questKeys.name] = "VIP Haute Club Membership",
            [questKeys.startedBy] = {{240607}},
            [questKeys.finishedBy] = {{240607}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Personally cook and deliver a Sunrise Omelette and Prowler Steak to Devon Woods  in front of the New Avalon inn."},
            [questKeys.objectives] = {{{241462},{241461}}},
        },
        [89381] = {
            [questKeys.name] = "Pin Cushion",
            [questKeys.startedBy] = {{241613}},
            [questKeys.finishedBy] = {{241613}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Fetch arrows in the archery range south of the New Avalon town square. You may also acquire arrows when fighting rangers."},
            [questKeys.objectives] = {nil,nil,{{239119}}},
        },
        [89421] = {
            [questKeys.name] = "Bullet Heaven",
            [questKeys.startedBy] = {{241613}},
            [questKeys.finishedBy] = {{241613}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Craft or purchase Thorium Shells from a player with the Engineering profession and bring them to Kyndra Swiftarrow near the New Avalon archery range."},
            [questKeys.objectives] = {nil,nil,{{15997}}},
        },
        [89442] = {
            [questKeys.name] = "Emblem of Darkness",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{11034}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Lord Maxwell Tyrosus at Light's Hope Chapel about the Emblem of the Ashbringer."},
            [questKeys.objectives] = {nil,nil,{{239197}}},
        },
        [89443] = {
            [questKeys.name] = "Falling Into Place",
            [questKeys.startedBy] = {{11034}},
            [questKeys.finishedBy] = {{241334}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Combine the Reforged Blade of the Ashbringer, the Emblem of the Ashbringer, and the Hilt of the Ashbringer, and then speak with the Will of the Ashbringer to determine your next steps."},
            [questKeys.objectives] = {nil,nil,{{240936},{239219}}},
        },
        [89445] = {
            [questKeys.name] = "Blades of Light",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find a Blacksmith that can tell you more about the Ruined Lightforged Blade."},
            [questKeys.objectives] = nil,
        },
        [89446] = {
            [questKeys.name] = "The Lost Craftsman",
            [questKeys.startedBy] = {{16376}},
            [questKeys.finishedBy] = {{16365}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Master Craftsman Omarion."},
            [questKeys.objectives] = nil,
        },
        [89447] = {
            [questKeys.name] = "Extravagant Tastes",
            [questKeys.startedBy] = {{16365}},
            [questKeys.finishedBy] = {{16365}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring ten servings of Dirge's Kickin' Chimaerok Chops to Master Craftsman Omarion in Naxxramas."},
            [questKeys.objectives] = {nil,nil,{{21023}}},
        },
        [89448] = {
            [questKeys.name] = "Gathering Light",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 12 ingots of Lightforged Iron to Master Craftsman Omarion in Naxxramas and discover where the Scarlet Crusade is forging these new weapons."},
            [questKeys.objectives] = {nil,nil,{{239216}}},
        },
        [89449] = {
            [questKeys.name] = "The Radiant Forge",
            [questKeys.startedBy] = {{16365}},
            [questKeys.finishedBy] = {{242125}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Enter the Scarlet Enclave and meet Master Craftsman Omarion at the Radiant Forge there."},
            [questKeys.objectives] = nil,
        },
        [89451] = {
            [questKeys.name] = "Journey To Moonglade",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{241834}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find a way to reach the summit of Mount Hyjal."},
            [questKeys.objectives] = {{{241834}}},
        },
        [89462] = {
            [questKeys.name] = "The Druid of the Talon",
            [questKeys.startedBy] = {{241834}},
            [questKeys.finishedBy] = {{242174}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Thisalee Crow near Everlook in Winterspring."},
            [questKeys.objectives] = nil,
        },
        [89463] = {
            [questKeys.name] = "Nondisclosure Arguement",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Fizzlefuse in New Avalon has requested a quill and something to make his hideout more comfortable. A Classy Quill can be found in the New Avalon Town Hall, and a House Prop may be found somewhere near Scholomance or in the Karazhan Crypts."},
            [questKeys.objectives] = {nil,nil,{{239225},{239223}}},
        },
        [89471] = {
            [questKeys.name] = "Goblin Tinkering",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Fizzlefuse in New Avalon has provided a shopping list of Engineering components needed for his inventions. Bring these items back to him."},
            [questKeys.objectives] = {nil,nil,{{16000},{18631},{9061},{4389},{239246}}},
        },
        [89473] = {
            [questKeys.name] = "The Well of Eternity",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{242863}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"There is an abandoned druid camp on the south side of the well of eternity. Gather 12 pieces of Nordrassil Detritus scattered around the base of the world tree and place them inside the Hyjal Bonfire to ignite the flame."},
            [questKeys.objectives] = {nil,nil,{{240848},{240936}}},
        },
        [89474] = {
            [questKeys.name] = "Forgiveness",
            [questKeys.startedBy] = {{241334}},
            [questKeys.finishedBy] = {{242499}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to the Scarlet Monastery in Tirisfal Glades. Enter the monastery's cathedral while wielding the Corrupted Ashbringer and bear witness to what occurs there."},
            [questKeys.objectives] = nil,
        },
        [89475] = {
            [questKeys.name] = "The Lonely Path of the Damned",
            [questKeys.startedBy] = {{242499}},
            [questKeys.finishedBy] = {{11034}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Lord Maxwell Tyrosus at Light's Hope Chapel. ","","You should stow the Corrupted Ashbringer in your bags, or else the members of the Argent Dawn may react with hostility upon seeing the tainted weapon."},
            [questKeys.objectives] = nil,
        },
        [89485] = {
            [questKeys.name] = "Whimsical Horrors",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Sneak behind New Avalon citizens while disguised and give them a Portiporter. Once you have sufficiently proven to yourself that it will not result in an instant death, try the device yourself to identify the problem Fizzlefuse referred to."},
            [questKeys.objectives] = {{{242599},{242600},{242601}}},
        },
        [89486] = {
            [questKeys.name] = "A Pinch of Gunpowder",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Arrive at the following locations in New Avalon within the time limit."},
            [questKeys.objectives] = {{{243200},{243201},{243202},{243203},{243204}}},
        },
        [89487] = {
            [questKeys.name] = "Much Ado About Magnets",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the Prototype Magnet throughout New Avalon to reveal and attract magnetic bits. When you have sufficiently proven Fizzlefuse's theory, return to him."},
            [questKeys.objectives] = {nil,nil,{{240846},{240845}}},
        },
        [89488] = {
            [questKeys.name] = "A Kind of Peace",
            [questKeys.startedBy] = {{242501}},
            [questKeys.finishedBy] = {{242501}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Will of the Ashbringer is using the last of its power to create a connection to Alexandros Mograine inside of Naxxramas. Take the portal and confront the Spirit of Mograine.","","Should you fall in battle, make your way back to the portal within Light's Hope Chapel to re-enter Naxxramas."},
            [questKeys.objectives] = {{{241940}}},
        },
        [89489] = {
            [questKeys.name] = "Increased Drop Rate",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Fizzlefuse in New Avalon has requested lots of belts, for good reason. Soldiers of New Avalon are a likely source of belts."},
            [questKeys.objectives] = {nil,nil,{{239302}}},
        },
        [89491] = {
            [questKeys.name] = "A Complicated Escape Plan",
            [questKeys.startedBy] = {{240654}},
            [questKeys.finishedBy] = {{240654}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the Triangulation Samophlange at three inconvenient locations and then use your Ultrasafe Transporter: Gadgetzan or Dimensional Ripper - Everlook while standing atop the teleportation pad to complete calibration. Then return to Fizzlefuse in New Avalon."},
            [questKeys.objectives] = {{{241962},{241963},{241964},{241965}}},
        },
        [89562] = {
            [questKeys.name] = "My Old Enemy",
            [questKeys.startedBy] = {{11036}},
            [questKeys.finishedBy] = {{11036}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Learn more about Baelin Caldoran from Leonid Barthalomew the Revered."},
            [questKeys.objectives] = {{{243024}}},
        },
        [89563] = {
            [questKeys.name] = "Leonid's Burden",
            [questKeys.startedBy] = {{11034}},
            [questKeys.finishedBy] = {{11034}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Receive instructions from Lord Maxwell Tyrosus."},
            [questKeys.objectives] = nil,
        },
        [89567] = {
            [questKeys.name] = "The Wrecked Caravan",
            [questKeys.startedBy] = {{11036}},
            [questKeys.finishedBy] = {{242019}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Investigate the remnants of the scarlet caravan in Plaguewood, along the road to Stratholme and speak with Leonid Barthalomew the Revered there when you have learned more."},
            [questKeys.objectives] = {nil,nil,{{242257},{242258}}},
        },
        [89568] = {
            [questKeys.name] = "Something New",
            [questKeys.startedBy] = {{242019}},
            [questKeys.finishedBy] = {{242019}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the New Plague Samples on weakened Cannibal Ghouls, Stitched Horrors, Cursed Mages, Scourge Soldiers and Scourge Warders found throughout Plaguewood and observe the effects."},
            [questKeys.objectives] = {{{243629}}},
        },
        [89574] = {
            [questKeys.name] = "Servants of Death",
            [questKeys.startedBy] = {{242019}},
            [questKeys.finishedBy] = {{242019}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the New Plague Samples on the Dark Summoners and Necromancers found throughout Eastern Plaguelands and observe the effects."},
            [questKeys.objectives] = {{{243630}}},
        },
        [90107] = {
            [questKeys.name] = "The Blade Reformed",
            [questKeys.startedBy] = {{242125}},
            [questKeys.finishedBy] = {{242125}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Stand back as Master Craftsman Omarion attempts to craft the Reforged Blade of the Ashbringer."},
            [questKeys.objectives] = {{{241829}}},
        },
        [90116] = {
            [questKeys.name] = "Holy Threads",
            [questKeys.startedBy] = {{240631}},
            [questKeys.finishedBy] = {{240631}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire Dawnwoven Fabrics by weaving cloth into bolts while in close proximity to the Crusader's Loom. Return to Taylor once you have enough."},
            [questKeys.objectives] = {nil,nil,{{239698}}},
        },
        [90120] = {
            [questKeys.name] = "Red is Not Dead",
            [questKeys.startedBy] = {{240631}},
            [questKeys.finishedBy] = {{240631}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire a variety of materials that could be used as a vibrant red dye. Red Dye and Red Rose may be sourced from vendors. Firebloom may be acquired by Herbalists. Blood of Heroes can be found in the Plaguelands. Crimson Bladeleaves to extract dye from can be found near Lake Mennar in Azshara."},
            [questKeys.objectives] = {nil,nil,{{2604},{3419},{4625},{12938},{239764}}},
        },
        [90506] = {
            [questKeys.name] = "Take Their Breath Away",
            [questKeys.startedBy] = {{242174}},
            [questKeys.finishedBy] = {{242174}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Retrieve 10 Nivifacient Glands from blue dragonspawn at Mazthoril just south of Everlook."},
            [questKeys.objectives] = {nil,nil,{{240832}}},
        },
        [90507] = {
            [questKeys.name] = "Logistics Challenges",
            [questKeys.startedBy] = {{242174}},
            [questKeys.finishedBy] = {{242174}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 15 Crates of Moonglade Supplies from the Winterfall Furbolg camps and villages in Winterspring."},
            [questKeys.objectives] = {nil,nil,{{240835}}},
        },
        [90508] = {
            [questKeys.name] = "As The Crow Flies",
            [questKeys.startedBy] = {{242174}},
            [questKeys.finishedBy] = {{242439}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Secure transport to the peak of Mount Hyjal."},
            [questKeys.objectives] = nil,
        },
        [90510] = {
            [questKeys.name] = "New Avalon",
            [questKeys.startedBy] = {{243023}},
            [questKeys.finishedBy] = {{243023}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the Scarlet Insignia once you have acquired enough disguise pieces to fool the Scarlet Crusaders in New Avalon and speak with Inquisitor Jociphine again. Players with armor crafting professions can utilize recipes and plans for scarlet armor pieces obtained from hostile crusaders in Tyr's Hand and New Avalon."},
            [questKeys.objectives] = {{{242450}}},
        },
        [90518] = {
            [questKeys.name] = "An Apple a Day Keeps the Undead at Bay",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate the apple orchard in the southern section of New Avalon to fetch some apples. Return to Carrie Hearthfire in the New Avalon inn once you have succeeded. If you find the apples to be too expensive, consider looking around for an alternative means to acquire them."},
            [questKeys.objectives] = {nil,nil,{{238811},{238831},{238830}}},
        },
        [90519] = {
            [questKeys.name] = "Fish On Demand",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Investigate the boat docked south of New Avalon for a shipment of fish and return a haul back to Carrie."},
            [questKeys.objectives] = {nil,nil,{{238899}}},
        },
        [90520] = {
            [questKeys.name] = "Food Safety",
            [questKeys.startedBy] = {{240604}},
            [questKeys.finishedBy] = {{240604}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Acquire meat that is safe for human consumption. If you struggle to locate some in New Avalon, you may (eventually) gather enough from slaying beasts in the Eastern Plaguelands."},
            [questKeys.objectives] = {nil,nil,{{238935}}},
        },
        [90559] = {
            [questKeys.name] = "The Tempering",
            [questKeys.startedBy] = {{242863}},
            [questKeys.finishedBy] = {{241334}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Heat the Inert Ashbringer at the bonfire at the abandoned druid camp south of the Nordrassil, then quench the Heated Blade into the waters of the Well of Eternity. ","","Speak with The Will of the Ashbringer when you are done."},
            [questKeys.objectives] = {nil,nil,{{241657},{241654}}},
        },
        [90560] = {
            [questKeys.name] = "Familiar Foulness",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{2055}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather Discolored Beast Hearts from creatures in the plaguelands and then bring them and the Mishandled Healing Potion to an interested member of the Royal Apothecary Society in Undercity."},
            [questKeys.objectives] = {nil,nil,{{241652}}},
        },
        [90566] = {
            [questKeys.name] = "Oh, My Bleeding Hearts!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{1937}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Deliver the Basket of Discolored Beast Hearts and some Plaguelands Bleeding Hearts to Apothecary Renferrel in the Sepulcher of Silverpine Forest."},
            [questKeys.objectives] = {nil,nil,{{242018}}},
        },
        [90567] = {
            [questKeys.name] = "Unfamiliar Foulness",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4160}},
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather Discolored Beast Hearts and Bleeding Hearts from the plaguelands. Bring them and the Mishandled Healing Potion to an interested alchemist in Darnassus."},
            [questKeys.objectives] = {nil,nil,{{241652},{242018}}},
        },
        [90625] = {
            [questKeys.name] = "On Dreaded Wings",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Wing of Balnazzar to Light's Hope Chapel in the Eastern Plaguelands."},
            [questKeys.objectives] = nil,
        },
        [90626] = {
            [questKeys.name] = "Sinew of Light",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Solistrasza and obtain a Mature Light Dragon Sinew, then bring it to Grok'lo at Light's Hope Chapel in the Eastern Plaguelands. Rewards ."},
            [questKeys.objectives] = {nil,nil,{{242364},{242365}}},
        },
        [90627] = {
            [questKeys.name] = "Crafty the Crafter",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 60,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Meet with Mizzle the Crafty in Dire Maul North.You'll want to catch him with no distractions, so don't kill any of the important Ogres on your way to him, or else he'll have to spend time replacing them and can't help you. Go alone."},
            [questKeys.objectives] = {nil,nil,{{242365}}},
        },
    }
end
