---@class SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:CreateModule("SeasonOfDiscovery")
-------------------------
--Import modules.
-------------------------
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ContentPhases
local ContentPhases = QuestieLoader:ImportModule("ContentPhases")

local runeQuestsInSoD = {-- List quests here to have them flagged as Rune quests in Season of Discovery
    [1470]  = 1, -- Warlock Metamorphosis Part 1
    [4763]  = 1, -- Warlock Shadow Bolt Volley Darkshore
    [76156] = 1, -- Shaman Lava Lash Part 1
    [76160] = 1, -- Shaman Lava Lash Part 2
    [76240] = 1, -- Shaman Lava Lash Part 3
    [77568] = 1, -- Hunter Chimera Shot
    [77571] = 1, -- Druid Fury of Stormrage Alliance
    [77573] = 1, -- Rogue Shadowstrike Nightelf
    [77574] = 1, -- Priest Penance
    [77575] = 1, -- Warrior Victory Rush
    [77582] = 1, -- Warrior Victory Rush
    [77583] = 1, -- Rogue Shadowstrike Orc
    [77584] = 1, -- Hunter Chimera Shot
    [77585] = 1, -- Shaman Overload
    [77586] = 1, -- Warlock Haunt
    [77587] = 1, -- Shaman Overload
    [77588] = 1, -- Warrior Victory Rush
    [77590] = 1, -- Hunter Chimera Shot
    [77592] = 1, -- Rogue Shadowstrike Troll
    [77616] = 1, -- Warrior Victory Rush
    [77617] = 1, -- Paladin Crusader Strike Elwynn Forest
    [77618] = 1, -- Rogue Shadowstrike Human
    [77619] = 1, -- Priest Penance
    [77620] = 1, -- Mage Ice Lance Elwynn Forest
    [77621] = 1, -- Warlock Haunt
    [77642] = 1, -- Priest Penance
    [77643] = 1, -- Mage Ice Lance Durotar
    [77648] = 1, -- Druid Fury of Stormrage Horde
    [77649] = 1, -- Hunter Chimera Shot
    [77651] = 1, -- Warrior Victory Rush
    [77652] = 1, -- Shaman Overload
    [77655] = 1, -- Warrior Victory Rush
    [77656] = 1, -- Warrior Victory Rush
    [77657] = 1, -- Paladin Crusader Strike Dun Morogh
    [77658] = 1, -- Rogue Shadowstrike Dwarf
    [77659] = 1, -- Rogue Shadowstrike Gnome
    [77660] = 1, -- Hunter Chimera Shot
    [77661] = 1, -- Priest Penance
    [77666] = 1, -- Warlock Haunt
    [77668] = 1, -- Warrior Victory Rush
    [77667] = 1, -- Mage Ice Lance Dun Morogh
    [77669] = 1, -- Rogue Shadowstrike Undead
    [77670] = 1, -- Priest Penance
    [77671] = 1, -- Mage Ice Lance Tirisfal Glades
    [77672] = 1, -- Warlock Haunt
    [78088] = 1, -- Paladin Divine Storm
    [78089] = 1, -- Paladin Divine Storm
    [78090] = 1, -- Paladin Divine Storm
    [78091] = 1, -- Paladin Divine Storm
    [78092] = 1, -- Paladin Divine Storm
    [78093] = 1, -- Paladin Divine Storm
    [78114] = 1, -- Hunter Kill Command Part 1
    [78121] = 1, -- Hunter Kill Command Part 2
    [78124] = 1, -- Mage Icy Veins
    [78127] = 1, -- Mage Icy Veins
    [78132] = 1, -- Warrior Raging Blows Part 1
    [78133] = 1, -- Warrior Raging Blows Part 1
    [78134] = 1, -- Warrior Raging Blows Part 1
    [78142] = 1, -- Mage Icy Veins
    [78143] = 1, -- Mage Icy Veins
    [78144] = 1, -- Warrior Raging Blows Part 2
    [78145] = 1, -- Mage Icy Veins
    [78146] = 1, -- Mage Icy Veins
    [78147] = 1, -- Mage Icy Veins
    [78148] = 1, -- Mage Icy Veins
    [78149] = 1, -- Mage Icy Veins
    [78150] = 1, -- Mage Icy Veins
    [78229] = 1, -- Druid Wild Growth
    [78261] = 1, -- Rogue Deadly Brew Part 1
    [78270] = 1, -- Rogue Deadly Brew Part 3
    [78277] = 1, -- Mage Horde Living Bomb
    [78287] = 1, -- Let Me Make You An Offer Alliance
    [78288] = 1, -- Let Me Make You An Offer Horde
    [78297] = 1, -- You've Got Yourself A Deal Alliance
    [78304] = 1, -- You've Got Yourself A Deal Horde
    [78307] = 1, -- Rogue Deadly Brew Part 3
    [78506] = 1, -- Shaman Earth Shield Part 1
    [78537] = 1, -- Shaman Earth Shield Part 2
    [78561] = 1, -- Shaman Earth Shield Part 3
    [78575] = 1, -- Shaman Earth Shield Part 4
    [78676] = 2, -- Rogue Shadowstep Part 1
    [78680] = 1, -- Warlock Metamorphosis Part 2
    [78681] = 1, -- Warlock Metamorphosis Part 3
    [78684] = 1, -- Warlock Metamorphosis Part 4
    [78699] = 2, -- Rogue Shadowstep Part 2
    [78702] = 1, -- Warlock Metamorphosis Part 5
    [78823] = 2, -- Hunter Exposed Weakness Part 1
    [78830] = 2, -- Hunter Exposed Weakness Part 2
    [78914] = 2, -- Warlock Grimoire of Synergy Part 2
    [78994] = 2, -- Warlock Grimoire of Synergy Part 1
    [79091] = 1, -- Mage Icy Veins
    [79092] = 1, -- Mage Icy Veins
    [79093] = 1, -- Mage Icy Veins
    [79094] = 1, -- Mage Icy Veins
    [79095] = 1, -- Mage Icy Veins
    [79096] = 1, -- Mage Icy Veins
    [79097] = 1, -- Mage Icy Veins
    [79298] = 2, -- Warlock Grimoire of Synergy Part 3
    [79348] = 2, -- Druid Nourish (The Lost Ancient)
    [79377] = 2, -- Druid Nourish (The Lost Saplings)
    [79229] = 2, -- Highway Robbery
    [79235] = 2, -- On the Lam
    [79236] = 2, -- Cherry for Your Thoughts?
    [79242] = 2, -- No Honor Among Thieves
    [79358] = 2, -- Shaman MailStrom Weapon (Tattered Note)
    [79360] = 2, -- Shaman MailStrom Weapon (Elemental Aid)
    [79361] = 2, -- Shaman MailStrom Weapon (Power of da Wind)
    [79362] = 2, -- Shaman MailStrom Weapon (Power of da Earth)
    [79363] = 2, -- Shaman MailStrom Weapon (Power of da Water)
    [79364] = 2, -- Shaman MailStrom Weapon (A Simple Container)
    [79365] = 2, -- Shaman MailStrom Weapon (With Wind Beneath Your Wings)
    [79366] = 2, -- Shaman MailStrom Weapon (Calm Before the Storm)
    [79442] = 2, -- Shaman MailStrom Weapon (Catching Up)
    [79535] = 2, -- Mage Icy Veins/Spell Power
    [79536] = 2, -- Mage Icy Veins/Spell Power
    [79624] = 2, -- Anyone Can Cook
    [79677] = 2, -- A Quick Grocery Run
    [79678] = 2, -- Taste Testing
    [79731] = 2, -- Priest Dispersion
    [79939] = 2, -- Paladin Sheath of Light Part 1
    [79940] = 2, -- Paladin Sheath of Light Part 2
    [79945] = 2, -- Paladin Sheath of Light Part 3
    [79946] = 2, -- Paladin Sheath of Light Part 4
    [79947] = 2, -- Mage Icy Veins/Spell Power
    [79948] = 2, -- Mage Icy Veins/Spell Power
    [79949] = 2, -- Mage Icy Veins/Spell Power
    [79950] = 2, -- Mage Icy Veins/Spell Power
    [79951] = 2, -- Mage Icy Veins/Spell Power
    [79952] = 2, -- Mage Icy Veins/Spell Power
    [79953] = 2, -- Mage Icy Veins/Spell Power
    [79963] = 2, -- Paladin Sheath of Light 5
    [79970] = 2, -- Paladin Sheath of Light 6
    [80098] = 2, -- Curious Dalaran Relic
    [80120] = 2, -- A Service to Dalaran
    [80147] = 2, -- Curious Dalaran Relic
    [80148] = 2, -- Curious Dalaran Relic
    [80149] = 2, -- Curious Dalaran Relic
    [80150] = 2, -- Curious Dalaran Relic
    [80151] = 2, -- Curious Dalaran Relic
    [80152] = 2, -- Curious Dalaran Relic
    [81764] = 3, -- Paladin Fanaticism
    [81765] = 3, -- Paladin Fanaticism
    [81766] = 3, -- Paladin Fanaticism
    [81790] = 3, -- Paladin Hammer of the Righteous
    [81885] = 3, -- Paladin Hammer of the Righteous
    [81924] = 3, -- Druid Efflorescence
    [81947] = 3, -- Mage Book Sanguine Sorcery
    [81949] = 3, -- Mage Book Legends of the Tidesages
    [81951] = 3, -- Mage Book The Liminal and the Arcane
    [81952] = 3, -- Mage Book Everyday Etiquette
    [81953] = 3, -- Mage Book Stonewrought Design
    [81954] = 3, -- Mage Book Venomous Journeys
    [81955] = 3, -- Mage Book A Mind of Metal
    [81956] = 3, -- Mage Book Conjurer's Codex
    [82208] = 3, -- Mage Deep Freeze
    [84135] = 4, -- Warrior Shockwave
    [84137] = 4, -- Warrior Shockwave
    [84138] = 4, -- Warrior Shockwave
    [84146] = 4, -- Warrior Shockwave
    [84211] = 4, -- Warrior Shockwave
    [84212] = 4, -- Warrior Shockwave
    [84213] = 4, -- Warrior Shockwave
    [84317] = 4, -- Warrior Sudden Death
    [84318] = 4, -- Paladin Shield of Righteousness
    [84319] = 4, -- Paladin Shield of Righteousness
    [84330] = 4, -- Paladin Shield of Righteousness
    [84332] = 4, -- Paladin Shield of Righteousness
    [84414] = 4, -- Paladin Shield of Righteousness
    [84418] = 4, -- Paladin Divine Steed

    -- fake IDs
    --- Mage runes
    [90000] = 1, -- Mage Arcane Blast
    [90001] = 1, -- Mage Alliance Burnout
    [90002] = 1, -- Mage Alliance Burnout
    [90003] = 1, -- Mage Burnout
    [90004] = 1, -- Mage Alliance Fingers of Frost
    [90005] = 1, -- Mage Horde Fingers of Frost
    [90006] = 1, -- Mage Alliance Regeneration
    [90007] = 1, -- Mage Horde Regeneration
    [90008] = 1, -- Mage Alliance Regeneration
    [90009] = 1, -- Mage Horde Regeneration
    [90010] = 1, -- Mage Alliance Enlightenment
    [90011] = 1, -- Mage Horde Enlightenment
    [90012] = 1, -- Mage Alliance Arcane Surge
    [90013] = 1, -- Mage Horde Arcane Surge
    [90014] = 1, -- Mage Mass Regeneration
    [90015] = 1, -- Mage Alliance Living Flame
    [90016] = 1, -- Mage Alliance Living Flame
    [90017] = 1, -- Mage Horde Living Flame
    [90018] = 1, -- Mage Horde Living Flame
    [90019] = 1, -- Mage Rewind Time
    [90020] = 1, -- Mage Alliance Living Bomb
    [90021] = 1, -- Mage Horde Living Bomb
    --- Mage runes end

    [90022] = 1, -- Paladin Divine Storm
    [90023] = 1, -- Druid Wild Strikes
    [90024] = 1, -- Druid Survival of the Fittest
    [90025] = 1, -- Priest Serendipity
    [90026] = 1, -- Paladin Divine Sacrifice
    [90027] = 1, -- Hunter Lone Wolf
    [90028] = 1, -- Warrior Warbringer
    [90029] = 1, -- Warlock Demonic Pact
    [90030] = 1, -- Rogue Main Gauche
    [90031] = 1, -- Shaman Dual Wield Specialization
    [90032] = 1, -- Warlock Lake of Fire Start
    [90033] = 1, -- Warlock Lake of Fire End
    [90034] = 1, -- Warlock Master Channeler Alliance
    [90035] = 1, -- Warlock Master Channeler Alliance
    [90036] = 1, -- Warlock Master Channeler Westfall
    [90037] = 1, -- Warlock Master Channeler Horde
    [90038] = 1, -- Warlock Master Channeler Horde
    [90039] = 1, -- Warlock Chaos Bolt Dun Morogh
    [90040] = 1, -- Paladin Beacon of Light Alliance
    [90041] = 1, -- Shaman Healing Rain Horde
    [90042] = 1, -- Warlock Everlasting Affliction Alliance
    [90043] = 1, -- Warlock Everlasting Affliction Horde
    [90044] = 1, -- Hunter Serpent Spread Alliance
    [90045] = 1, -- Hunter Serpent Spread Horde
    [90046] = 1, -- Warrior Single-Minded Fury Alliance
    [90047] = 1, -- Warrior Single-Minded Fury Horde
    [90048] = 1, -- Druid Skull Bash Alliance
    [90049] = 1, -- Druid Skull Bash Horde
    [90050] = 1, -- Rogue Just a Flesh Wound Alliance
    [90051] = 1, -- Rogue Just a Flesh Wound Horde
    [90052] = 1, -- Priest Mind Sear Alliance
    [90053] = 1, -- Priest Mind Sear Horde
    [90054] = 1, -- Druid Living Seed Alliance
    [90055] = 1, -- Druid Living Seed Horde
    [90056] = 1, -- Druid Starsurge
    [90057] = 1, -- Druid Sunfire Alliance
    [90058] = 1, -- Druid Lifebloom
    [90059] = 1, -- Priest Prayer of Mending
    [90060] = 1, -- Shaman Ancestral Guidance
    [90061] = 1, -- Warlock Chaos Bolt Elwynn Forest
    [90062] = 1, -- Warlock Chaos Bolt The Barrens
    [90063] = 1, -- Warlock Chaos Bolt Tirisfal Glades
    [90064] = 1, -- Warlock Shadow Bolt Volley Loch Modan
    [90065] = 1, -- Warlock Shadow Bolt Volley Westfall start
    [90066] = 1, -- Warlock Shadow Bolt Volley Westfall end
    [90067] = 1, -- Warlock Shadow Bolt Volley The Barrens start
    [90068] = 1, -- Warlock Shadow Bolt Volley The Barrens end
    [90069] = 1, -- Warlock Shadow Bolt Volley Silverpine Forest
    [90070] = 1, -- Warlock Incinerate
    [90071] = 1, -- Warlock Demonic Tactics Alliance
    [90072] = 1, -- Warlock Demonic Tactics Horde
    [90073] = 1, -- Warlock Soul Siphon Dun Morogh
    [90074] = 1, -- Warlock Soul Siphon Elwynn Forest
    [90075] = 1, -- Warlock Soul Siphon Durotar
    [90076] = 1, -- Warlock Soul Siphon Tirisfal Galdes
    [90077] = 1, -- Warlock Demonic Grace Dun Morogh
    [90078] = 1, -- Warlock Demonic Grace Elwynn Forest
    [90079] = 1, -- Warlock Demonic Grace Durotar
    [90080] = 1, -- Warlock Demonic Grace Tirisfal Galdes
    [90081] = 1, -- Hunter Heart of the Lion
    [90082] = 1, -- Hunter Master Marksman
    [90083] = 1, -- Hunter Cobra Strikes
    [90084] = 1, -- Rogue Blade Dance Darkshore
    [90085] = 1, -- Rogue Blade Dance Loch Modan
    [90086] = 1, -- Rogue Blade Dance Westfall
    [90087] = 1, -- Rogue Blade Dance The Barrens
    [90088] = 1, -- Druid Wild Growth Ashenvale
    [90089] = 1, -- Druid Wild Growth Duskwood
    [90090] = 1, -- Druid Wild Growth Hillsbrad Foothills
    [90091] = 1, -- Warrior Flagellation
    [90092] = 1, -- Warrior Blood Frenzy
    [90093] = 1, -- Warrior Furious Thunder
    [90094] = 1, -- Warrior Consumed By Rage
    [90095] = 1, -- Hunter Explosive Shot
    [90096] = 1, -- Warrior Raging Blows
    [90097] = 1, -- Warrior Raging Blows
    [90098] = 1, -- Warrior Raging Blows
    [90099] = 1, -- Warrior Raging Blows
    [90100] = 1, -- Warrior Devastate
    [90101] = 1, -- Warrior Devastate
    [90102] = 1, -- Warrior Devastate
    [90103] = 1, -- Warrior Devastate
    [90104] = 1, -- Warrior Devastate
    [90105] = 1, -- Warrior Devastate
    [90106] = 1, -- Warrior Frenzied Assault
    [90355] = 1, -- Warrior Frenzied Assault
    [90108] = 1, -- Warrior Frenzied Assault
    [90109] = 1, -- Warrior Frenzied Assault
    [90110] = 1, -- Warrior Frenzied Assault
    [90111] = 1, -- Warrior Frenzied Assault
    [90112] = 1, -- Warrior Endless Rage Westfall
    [90113] = 1, -- Warrior Endless Rage Darkshore
    [90114] = 1, -- Warrior Endless Rage Loch Modan
    [90115] = 1, -- Warrior Endless Rage The Barrens
    [90117] = 1, -- Paladin Seal of Martyrdom
    [90118] = 1, -- Paladin Horn of Lordaeron
    [90119] = 1, -- Paladin Horn of Lordaeron
    [90121] = 1, -- Paladin Inspiration Exemplar
    [90122] = 1, -- Paladin Avenger's Shield
    [90123] = 1, -- Paladin Rebuke
    [90124] = 1, -- Paladin Rebuke
    [90125] = 1, -- Paladin Rebuke
    [90126] = 1, -- Paladin Hand of Reckoning
    [90127] = 1, -- Druid Mangle Teldrassil
    [90128] = 1, -- Druid Lacerate Loch Modan
    [90129] = 1, -- Druid Lacerate The Barrens
    [90130] = 1, -- Druid Savage Roar Darkshore
    [90131] = 1, -- Druid Savage Roar The Barrens
    [90132] = 1, -- Druid Savage Roar Loch Modan
    [90133] = 1, -- Rogue Quick Draw Dun Morogh
    [90134] = 1, -- Rogue Quick Draw Elwynn Forest
    [90135] = 1, -- Rogue Quick Draw Teldrassil
    [90136] = 1, -- Rogue Quick Draw Durotar
    [90137] = 1, -- Rogue Quick Draw Tirisfal Glades
    [90138] = 1, -- Rogue Slaughter from the Shadows Elwynn Forest, Dun Morogh, Durotar
    [90139] = 1, -- Warrior Quick Strike Loch Modan
    [90140] = 1, -- Warrior Quick Strike Westfall
    [90141] = 1, -- Warrior Quick Strike Darkshore
    [90142] = 1, -- Warrior Quick Strike The Barrens
    [90143] = 1, -- Warrior Quick Strike Silverpine Forest
    [90144] = 1, -- Druid Savage Roar Westfall
    [90145] = 1, -- Druid Lacerate Darkshore
    [90146] = 1, -- Druid Mangle Mulgore
    [90147] = 1, -- Paladin Hand of Reckoning Westfall
    [90148] = 1, -- Paladin Exorcist Duskwood
    [90150] = 1, -- Hunter Sniper Training Darkshore
    [90151] = 1, -- Hunter Sniper Training Westfall
    [90152] = 1, -- Hunter Sniper Training Loch Modan
    [90153] = 1, -- Hunter Sniper Training The Barrens
    [90154] = 1, -- Druid Lacerate Westfall
    [90155] = 1, -- Priest Void Plague Dun Morogh
    [90156] = 1, -- Priest Void Plague Elwynn Forest
    [90157] = 1, -- Priest Void Plague Teldrassil
    [90158] = 1, -- Priest Void Plague Durotar
    [90159] = 1, -- Priest Void Plague Tirisfal Glades
    [90161] = 1, -- Priest Strength of Soul
    [90162] = 1, -- Priest Twisted Faith Loch Modan
    [90163] = 1, -- Priest Twisted Faith Westfall
    [90164] = 1, -- Priest Twisted Faith Darkshore
    [90165] = 1, -- Priest Twisted Faith The Barrens
    [90166] = 1, -- Priest Twisted Faith Silverpine Forest
    [90167] = 1, -- Hunter Flanking Strike Dun Morogh
    [90168] = 1, -- Hunter Flanking Strike Teldrassil
    [90169] = 1, -- Priest Power Word: Barrier Redridge Mountains
    [90170] = 1, -- Hunter Flanking Strike Durotar
    [90171] = 1, -- Hunter Flanking Strike Mulgore
    [90172] = 1, -- Hunter Beast Mastery Westfall
    [90173] = 1, -- Hunter Beast Mastery Darkshore
    [90174] = 1, -- Hunter Beast Mastery Loch Modan
    [90175] = 1, -- Hunter Beast Mastery Silverpine Forest
    [90176] = 1, -- Hunter Beast Mastery The Barrens
    [90177] = 1, -- Priest Shared Pain Dun Morogh
    [90178] = 1, -- Priest Shared Pain Elwynn Forest
    [90179] = 1, -- Priest Shared Pain Teldrassil
    [90180] = 1, -- Priest Shared Pain Durotar
    [90181] = 1, -- Priest Shared Pain Tirisfal Glades
    [90182] = 1, -- Priest Homunculi Dun Morogh
    [90183] = 1, -- Priest Homunculi Elwynn Forest
    [90184] = 1, -- Priest Homunculi Teldrassil
    [90185] = 1, -- Priest Homunculi Durotar
    [90186] = 1, -- Priest Homunculi Tirisfal Glades
    [90187] = 1, -- Priest Shadow Word: Death Westfall
    [90188] = 1, -- Priest Shadow Word: Death The Barrens
    [90189] = 1, -- Priest Shadow Word: Death Loch Modan
    [90190] = 1, -- Priest Shadow Word: Death Silverpine Forest
    [90191] = 1, -- Priest Shadow Word: Death Darkshore
    [90192] = 1, -- Priest Circle of Healing Duskwood
    [90193] = 1, -- Rogue Between the Eyes Ironforge
    [90194] = 1, -- Rogue Between the Eyes Stormwind
    [90195] = 1, -- Rogue Between the Eyes Orgrimmar
    [90196] = 1, -- Rogue Between the Eyes Tirisfal Glades
    [90197] = 1, -- Rogue Between the Eyes Teldrassil
    [90198] = 1, -- Rogue Envenom Hillsbrad Foothills
    [90199] = 1, -- Rogue Mutilate Teldrassil
    [90200] = 1, -- Rogue Mutilate Dun Morogh
    [90201] = 1, -- Rogue Shiv Duskwood
    [90202] = 1, -- Shaman Greater Ghost Wolf Stonetalon Mountains
    [90203] = 1, -- Shaman Way of Earth The Barrens
    [90204] = 1, -- Shaman Way of Earth Silverpine Forest
    [90205] = 1, -- Shaman Lava Burst Hillsbrad Foothills
    [90206] = 1, -- Hunter Carve Dun Morogh
    [90207] = 1, -- Hunter Carve Teldrassil
    [90208] = 1, -- Hunter Carve Durotar
    [90209] = 1, -- Hunter Carve Mulgore
    [90210] = 1, -- Rogue Saber Slash Loch Modan
    [90211] = 1, -- Rogue Saber Slash Westfall
    [90212] = 1, -- Rogue Saber Slash The Barrens
    [90213] = 1, -- Rogue Saber Slash Silverpine Forest
    [90214] = 1, -- Rogue Saber Slash Darkshore
    [90215] = 1, -- Shaman Water Shield Silverpine Forest
    [90216] = 1, -- Shaman Water Shield The Barrens
    [90217] = 1, -- Shaman Shield Mastery Durotar Orc & Troll
    [90218] = 1, -- Shaman Shield Mastery Mulgore Tauren
    [90219] = 1, -- Shaman Molten Blast Durotar
    [90220] = 1, -- Shaman Molten Blast Mulgore

    -- P2 SoD Runes
    [90221] = 2, -- Druid Berserk Thousand Needles
    [90222] = 2, -- Druid Dreamstate Desolace
    [90223] = 2, -- Hunter Dual Wield Specialization Stranglethorn Vale
    [90224] = 2, -- Warrior Intervene Thousand Needles
    [90225] = 2, -- Warrior Rallying Cry Badlands
    [90226] = 2, -- Mage Spellfrost Bolt Stranglethorn Vale
    [90227] = 2, -- Mage Frostfire Bolt Stranglethorn Vale
    [90228] = 2, -- Rogue Rolling with the Punches Thousand Needles
    [90229] = 2, -- Paladin Sacred Shield Desolace
    [90230] = 2, -- Warrior Focused Rage Arathi Highlands
    [90231] = 2, -- Shaman Spirit of the Alpha
    [90232] = 2, -- Priest Empowered Renew
    [90233] = 2, -- Hunter Steady Shot Arathi Highlands
    [90234] = 2, -- Mage Hot Streak Alterac Mountains
    [90235] = 2, -- Priest Renewed Hope Desolace
    [90236] = 2, -- Mage Chronostatic Preservation
    [90237] = 2, -- Mage Chronostatic Preservation
    [90238] = 2, -- Mage Chronostatic Preservation
    [90239] = 2, -- Shaman Fire Nova Step 1
    [90240] = 2, -- Shaman Fire Nova Step 2
    [90241] = 2, -- Shaman Fire Nova Step 3
    [90242] = 2, -- Shaman Fire Nova Step 4
    [90243] = 2, -- Shaman Fire Nova Step 5
    [90244] = 2, -- Shaman Fire Nova Step 6
    [90245] = 2, -- Shaman Fire Nova Final Step
    [90246] = 2, -- Shaman Power Surge
    [90247] = 2, -- Shaman Decoy Totem
    [90248] = 2, -- Paladin Enlightened Judgements
    [90249] = 2, -- Paladin Guarded by the Light
    [90250] = 2, -- Paladin Sheath of Light Part 2.5
    [90251] = 2, -- Hunter Invigoration
    [90252] = 2, -- Hunter Invigoration
    [90253] = 2, -- Hunter Invigoration
    [90254] = 2, -- Hunter Invigoration
    [90255] = 2, -- Warlock Invocation
    [90256] = 2, -- Warlock Shadowflame
    [90257] = 2, -- Warlock Dance of the Wicked
    [90258] = 2, -- Priest Pain Suppression
    [90259] = 2, -- Priest Pain Suppression
    [90260] = 2, -- Priest Pain Suppression
    [90261] = 2, -- Priest Pain Suppression
    [90262] = 2, -- Priest Pain Suppression
    [90263] = 2, -- Rogue Shuriken Toss
    [90264] = 2, -- Rogue Master of Subtlety
    [90265] = 2, -- Druid Survival Instincts
    [90266] = 2, -- Druid Survival Instincts
    [90267] = 2, -- Druid Survival Instincts
    [90268] = 2, -- Druid Survival Instincts
    [90353] = 1, -- Warrior Endless Rage Silverpine Forest
    [90354] = 1, -- Paladin Aegis

    -- P3 SoD Runes
    [80411] = 3, -- Rogue Honor Among Thieves
    [80453] = 3, -- Rogue Honor Among Thieves
    [80454] = 3, -- Rogue Honor Among Thieves
    [80455] = 3, -- Rogue Honor Among Thieves
    [80526] = 3, -- Rogue Honor Among Thieves
    [81682] = 3, -- Warrior Gladiator Stance
    [81697] = 3, -- Warrior Gladiator Stance
    [81801] = 3, -- Warrior Gladiator Stance
    [81877] = 3, -- Warrior Gladiator Stance
    [81900] = 3, -- Hunter Rapid Killing
    [81917] = 3, -- Hunter Rapid Killing
    [81919] = 3, -- Hunter Rapid Killing
    [81960] = 3, -- Shaman Overcharged
    [81968] = 3, -- Shaman Overcharged
    [82043] = 3, -- Mage Advanced Warding
    [82044] = 3, -- Mage Advanced Warding
    [82071] = 3, -- Shaman Overcharged
    [82072] = 3, -- Shaman Overcharged
    [82073] = 3, -- Shaman Overcharged
    [82074] = 3, -- Shaman Overcharged
    [82075] = 3, -- Shaman Overcharged
    [82076] = 3, -- Shaman Overcharged
    [82084] = 3, -- Mage Temporal Anomaly
    [82316] = 3, -- Priest Eye of the Void
    [90269] = 3, -- Druid Gale Winds
    [90270] = 3, -- Druid Gore
    [90271] = 3, -- Hunter Raptor Fury
    [90272] = 3, -- Hunter T.N.T
    [90273] = 3, -- Mage Molten Armor
    [90274] = 3, -- Paladin Improved Hammer of Wrath
    [90275] = 3, -- Paladin Wrath
    [90276] = 3, -- Priest Void Zone
    [90277] = 3, -- Rogue Cut to the Chase
    [90278] = 3, -- Shaman Burn
    [90279] = 3, -- Warlock Unstable Affliction
    [90280] = 3, -- Warrior Shield Mastery
    [90281] = 3, -- Warrior Rampage
    [90282] = 3, -- Warrior Vigilance
    [90283] = 3, -- Warrior Wrecking Crew
    [90284] = 3, -- Warlock Immolation Aura
    [90285] = 3, -- Warlock Summon Felguard
    [90286] = 3, -- Shaman Static Shock
    [90287] = 3, -- Shaman Mental Dexterity
    [90288] = 3, -- Priest Pain and Suffering
    [90289] = 3, -- Warrior Taste for Blood
    [90290] = 3, -- Druid Improved Barkskin
    [90291] = 3, -- Hunter Focus Fire
    [90292] = 3, -- Hunter Catlike Reflexes
    [90293] = 3, -- Mage Balefire Bolt
    [90294] = 3, -- Rogue Unfair Advantage
    [90295] = 3, -- Rogue Carnage
    [90296] = 3, -- Rogue Focused Attacks
    [90297] = 3, -- Shaman Tidal Waves
    [90298] = 3, -- Shaman Rolling Thunder
    [90299] = 3, -- Druid Elune's Fires
    [90300] = 3, -- Mage Displacement
    [90301] = 3, -- Paladin Purifying Power
    [90302] = 3, -- Priest Surge of Light
    [90303] = 3, -- Priest Despair
    [90304] = 3, -- Priest Eye of the Void
    [90305] = 3, -- Warlock Pandemic
    [90306] = 3, -- Warlock Backdraft

    -- P4 SoD Runes
    [83808] = 4, -- Paladin Righteous Vengeance
    [83822] = 4, -- Paladin Righteous Vengeance
    [83823] = 4, -- Paladin Shock and Awe
    [83935] = 4, -- Paladin Righteous Vengeance
    [83936] = 4, -- Paladin Righteous Vengeance
    [84008] = 4, -- Paladin Shock and Awe
    [84017] = 4, -- Paladin Shock and Awe
    [84124] = 4, -- Warrior Fresh Meat
    [84125] = 4, -- Paladin Shock and Awe
    [84126] = 4, -- Paladin Shock and Awe
    [84320] = 4, -- Priest Binding Heal
    [84321] = 4, -- Priest Binding Heal
    [84322] = 4, -- Priest Binding Heal
    [84323] = 4, -- Priest Binding Heal
    [84324] = 4, -- Priest Server-Wide Racials
    [84325] = 4, -- Priest Server-Wide Racials
    [84326] = 4, -- Priest Server-Wide Racials
    [84327] = 4, -- Priest Server-Wide Racials
    [84328] = 4, -- Priest Server-Wide Racials
    [84329] = 4, -- Priest Server-Wide Racials
    [84369] = 4, -- Mage Frozen Orb
    [84394] = 4, -- Mage Arcance Barrage
    [84395] = 4, -- Mage Arcance Barrage
    [84396] = 4, -- Mage Arcance Barrage
    [84397] = 4, -- Mage Arcance Barrage
    [84398] = 4, -- Mage Arcance Barrage
    [84399] = 4, -- Mage Arcance Barrage
    [84400] = 4, -- Mage Arcance Barrage
    [84401] = 4, -- Mage Arcance Barrage
    [84402] = 4, -- Mage Arcance Barrage
    [84405] = 4, -- Priest Binding Heal
    [84406] = 4, -- Priest Binding Heal
    [84407] = 4, -- Priest Binding Heal
    [84408] = 4, -- Priest Server-Wide Racials
    [84410] = 4, -- Priest Server-Wide Racials
    [84411] = 4, -- Priest Server-Wide Racials
    [84412] = 4, -- Priest Server-Wide Racials
    [84413] = 4, -- Priest Server-Wide Racials
    [90307] = 4, -- Druid Improved Swipe
    [90308] = 4, -- Druid Starfall
    [90309] = 4, -- Druid Tree of Life
    [90310] = 4, -- Axe Specialization (Hunter, Paladin, Shaman, Warrior)
    [90311] = 4, -- Mage Frozen Orb
    [90312] = 4, -- Priest Vampiric Touch
    [90313] = 4, -- Arcane Specialization (Druid, Hunter, Mage)
    [90314] = 4, -- Defense Specialization (Druid, Paladin, Rogue, Shaman, Warlock, Warrior)
    [90315] = 4, -- Feral Combat Specialization (Druid)
    [90316] = 4, -- Frost Specialization (Hunter, Mage, Shaman)
    [90317] = 4, -- Holy Specialization (Paladin, Priest)
    [90318] = 4, -- Nature Specialization (Druid, Rogue, Shaman)
    [90319] = 4, -- Ranged Weapon Specialization (Hunter, Rogue, Warrior)
    [90320] = 4, -- Shadow Specialization (Priest, Warlock)
    [90321] = 5, -- Healing Specialization (Paladin, Priest, Shaman, Druid, Mage)
    [90322] = 5, -- Meditation Specialization (Paladin, Priest, Shaman, Druid, Mage)
    [90323] = 3, -- Paladin Light's Grace
    [90324] = 3, -- Shaman Overcharged
    [90325] = 4, -- Dagger Specialization (Druid, Hunter, Mage, Priest, Rogue, Shaman, Warlock, Warrior)
    [90326] = 4, -- Fire Specialization (Mage, Hunter, Shaman, Warlock)
    [90327] = 4, -- Fist Weapon Specialization (Druid, Hunter, Rogue, Shaman, Warrior)
    [90328] = 4, -- Mace Specialization (Druid, Paladin, Priest, Rogue, Shaman, Warrior)
    [90329] = 4, -- Pole Weapon Specialization (Druid, Hunter, Mage, Paladin, Priest, Shaman, Warlock, Warrior)
    [90330] = 4, -- Sword Specialization (Hunter, Mage, Paladin, Rogue, Warlock, Warrior)
    [90331] = 4, -- Hunter Resourcefulness Step 1
    [90332] = 4, -- Hunter Resourcefulness Step 2
    [90333] = 4, -- Hunter Hit and Run
    [90334] = 4, -- Hunter Improved Volley Step 1
    [90335] = 4, -- Hunter Improved Volley Step 2
    [90336] = 4, -- Mage Overheat
    [90337] = 4, -- Rogue Fan of Knives
    [90338] = 4, -- Shaman Storm, Earth, and Fire
    [90339] = 4, -- Shaman Feral Spirit
    [90340] = 4, -- Shaman Coherence
    [90341] = 4, -- Warlock Mark of Chaos (Alliance)
    [90342] = 4, -- Warlock Mark of Chaos (Horde)
    [90343] = 4, -- Warlock Infernal Armor Step 1
    [90344] = 4, -- Warlock Infernal Armor Step 2
    [90345] = 4, -- Rogue Blunderbuss
    [90346] = 4, -- Rogue Crimson Tempest Step 1
    [90347] = 4, -- Rogue Crimson Tempest Step 2
    [90348] = 4, -- Rogue Crimson Tempest Step 3
    [90349] = 4, -- Priest Soul Warding Step 1
    [90350] = 4, -- Priest Soul Warding Step 2
    [90351] = 4, -- Warlock Decimation Step 1
    [90352] = 4, -- Warlock Decimation Step 2
    [91000] = 1, -- Rune Broker (Alliance)
    [91001] = 1, -- Rune Broker (Horde)
}

--- "automatic" phase detection for the first few phases;
--- gets called slightly later into init because if GetMaxPlayerLevel() is called too
--- early after initial login (not reloads), the game returns 60 even in early phases
function SeasonOfDiscovery.Initialize()
    local maxLevel = GetMaxPlayerLevel()
    local phaseDetected = true
    if maxLevel == 25 then
        ContentPhases.activePhases.SoD = 1
    elseif maxLevel == 40 then
        ContentPhases.activePhases.SoD = 2
    elseif maxLevel == 50 then
        ContentPhases.activePhases.SoD = 3
    elseif maxLevel == 60 and ContentPhases.activePhases.SoD <= 4 then
        ContentPhases.activePhases.SoD = 4
    else
        phaseDetected = false
        Questie:Debug(Questie.DEBUG_CRITICAL, "[SeasonOfDiscovery] Automatic phase detection failed, phase remains as " .. tostring(ContentPhases.activePhases.SoD))
    end
    if phaseDetected then
        Questie:Debug(Questie.DEBUG_INFO, "[SeasonOfDiscovery] Phase automatically detected as " .. tostring(ContentPhases.activePhases.SoD))
    end
end

---@param questId number
---@return boolean
function QuestieDB.IsSoDRuneQuest(questId)
    return runeQuestsInSoD[questId] ~= nil
end

---@param questId number
---@return boolean Returns true if the quest should be hidden, false otherwise
function QuestieDB.IsRuneAndShouldBeHidden(questId)
    if (not QuestieDB.IsSoDRuneQuest(questId)) then
        return false
    end

    if (not Questie.db.profile.showSoDRunes) then
        return true
    elseif questId == 91000 or questId == 91001 then
        return false -- Rune Broker quests are always shown
    end

    local showRunesOfPhase = Questie.db.profile.showRunesOfPhase
    local phaseOfRuneQuest = runeQuestsInSoD[questId]

    if showRunesOfPhase["phase" .. phaseOfRuneQuest] ~= nil then
        return not showRunesOfPhase["phase" .. phaseOfRuneQuest]
    end

    return false
end
