---@class QuestieNPCFixes
local QuestieNPCFixes = QuestieLoader:CreateModule("QuestieNPCFixes")
-------------------------
--Import modules.
-------------------------
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@type Phasing
local Phasing = QuestieLoader:ImportModule("Phasing")

-- Further information on how to use this can be found at the wiki
-- https://github.com/Questie/Questie/wiki/Corrections

function QuestieNPCFixes:Load()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local npcFlags = QuestieDB.npcFlags
    local waypointPresets = QuestieDB.waypointPresets
    local phases = Phasing.phases

    return {
        [294] = { -- Marshal Haggard
            [npcKeys.questStarts] = {75,78,109,1667},
        },
        [300] = {
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD]={{35,80},{36.81,83.79},{38,80}}}, -- #1047
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
        },
        [313] = { -- Theocritus
            [npcKeys.questStarts] = {94,249},
        },
        [314] = {
            [npcKeys.zoneID] = zoneIDs.DUSKWOOD,
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{28.82,30.91}}},
        },
        [328] = { -- Zaldimar Wefhellt
            [npcKeys.questStarts] = {1860,1919},
        },
        [331] = {
            [npcKeys.questStarts] = {8250},
        },
        [332] = { -- Master Mathias Shaw
            [npcKeys.questStarts] = {141,350,395,2206,2360,2607,6183,6184,6681},
        },
        [376] = { -- High Priestess Laurena
            [npcKeys.questStarts] = {5634,5645,5673,5676},
            [npcKeys.questEnds] = {5634,5635,5636,5637,5638,5639,5640,5676,5677,5678},
        },
        [377] = { -- Priestess Josetta
            [npcKeys.questStarts] = {5624,5628,5635},
        },
        [384] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [412] = {
            [npcKeys.zoneID] = zoneIDs.DUSKWOOD,
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{74.45,47.86},{44.81,66.02},{74.56,52.05},{64.52,60.65},{73.68,56.09}}},
        },
        [415] = { -- Verner Osgood
            [npcKeys.questStarts] = {118,122,124,126,1097},
        },
        [446] = {
            [npcKeys.waypoints] = {},
        },
        [448] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{25.02,92.9}}},
        },
        [572] = {
            [npcKeys.spawns] = {[zoneIDs.WESTFALL] = {{41.93,29.24},{64.71,66.7}}},
        },
        [580] = {
            [npcKeys.waypoints] = {},
        },
        [583] = {
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{34.06,55.59}}},
        },
        [643] = {
            [npcKeys.zoneID] = zoneIDs.THE_DEADMINES,
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES] = {{-1,-1}}},
        },
        [681] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{31.4,8.4},{31.4,8.6},{31.8,9.8},{33,9.8},{33.4,10.6},{33.6,11},{33.8,12.4},{33.8,13.2},{34.6,13.6},{35.4,12.4},{35.4,12.6},{35.6,12.4},{35.8,13},{36.4,13.6},{37.2,11.4},{37.2,14.2},{37.4,11.6},{37.6,13.2},{37.8,14.4},{38.6,15.2},{39.2,6.4},{39.2,6.6},{39.2,7.8},{40.2,8.4},{40.2,10},{41.2,8.2},{31.6,10.2},{38.7,15.36},{37.35,14.33},{39.21,14.45},{38.84,13.64},{36.11,15.31},{37.29,11.56},{40.19,9.93},{33.91,12.98},{35.07,12.11},{34.73,17.51},{35.98,12.93},{35.13,16.52},{35.65,12.14},{31.43,8.39},{32.41,9.57},{30.64,7.56},{33.06,9.57},{31.54,9.94},{33.36,9.94},{33.57,11.15},{34.07,11.33},{40.41,8.3},{34.54,14.0}}},
        },
        [682] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{27.8,9.6},{28.4,9.2},{28.4,10.6},{28.6,10.6},{29.4,8},{29.4,8.8},{29.4,10.4},{29.4,16},{29.6,11.2},{29.8,7.8},{29.8,15.8},{30.2,10.4},{30.2,13.8},{30.2,15.4},{30.4,9},{30.4,12.4},{30.4,12.8},{30.6,12.2},{30.6,12.8},{30.6,15.8},{30.8,9.4},{30.8,9.8},{30.8,11.2},{30.8,15},{31,14.4},{34.6,17.4},{34.6,17.6},{35,14.2},{35,16.2},{35.4,15},{36.2,13.2},{36.4,13.8},{36.6,14},{37.4,12.8},{37.6,12.6},{37.8,12.2},{40.2,10},{42.8,15},{43.4,14.4},{43.8,15},{44,13.4},{44,13.6},{45,15},{45.4,14.4},{45.8,10},{46,15.4},{46,16.8},{46.4,12.8},{46.4,14.4},{46.4,15.8},{46.4,17.6},{46.6,13},{46.6,14.4},{46.6,16},{46.8,18.6},{47,15.2},{47,16.6},{47,18.2},{47.4,11.2},{47.6,11.4},{47.6,12.8},{48,12},{48,13.6},{29.8,7.8},{30.2,9.0},{47.4,11.43},{46.6,17.51},{47.17,18.47},{30.18,13.58},{29.73,11.29},{30.4,9.02},{42.88,15.25},{47.13,16.81},{28.96,9.54},{30.34,15.24},{29.36,10.41},{30.75,16.05},{46.0,16.89},{46.53,12.93},{48.07,13.69},{46.58,14.4},{47.59,12.85},{48.19,12.18},{46.08,15.32},{46.57,16.09},{47.13,15.25},{44.0,13.68},{45.47,14.54}}},
        },
        [728] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{47.2,28.4},{47.2,28.8},{47.2,29.6},{47.6,28.2},{47.6,28.6},{48.4,19.2},{48.4,20.2},{48.8,19.4},{48.8,20},{49,20.6},{49,23.4},{49.2,24.8},{49.4,24},{49.6,23.4},{49.6,24},{49.8,24.6},{50.6,23.6}}},
        },
        [729] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{32.21,17.39},{31.47,15.5}}},
        },
        [730] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{28.74,44.85},{31.5,41.2},{32.2,42.8}}},
        },
        [736] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{28.2,12.2},{28.2,13.6},{28.2,16.4},{28.2,16.6},{28.4,9.2},{28.4,10.4},{28.4,10.6},{28.4,12.6},{28.4,14.6},{28.6,11.8},{28.6,12.8},{28.6,16.6},{28.8,9.6},{28.8,15.8},{29.2,13.6},{29.2,15},{29.4,8.8},{29.4,10.6},{29.8,7.8},{29.8,11.2},{29.8,15.8},{30,9.8},{30.4,8.8},{30.4,12.4},{30.4,12.8},{30.4,13.8},{30.4,15.2},{30.6,9.2},{30.6,9.6},{30.6,12},{30.6,15},{30.8,11.2},{30.8,14.4},{30.8,15.8},{38.2,35.4},{38.2,35.6},{38.4,34.4},{45.69,10.32},{45.3,9.8},{45.79,10.3},{28.88,15.94},{28.36,13.43},{29.77,16.11},{28.17,16.55},{30.97,14.59},{29.99,9.78},{30.9,11.29},{28.37,10.55},{28.79,14.6},{30.47,10.67},{29.4,9.07},{28.39,12.3},{29.45,13.59}}},
        },
        [738] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{37.98,3.41},{40.34,8.44}}},
            [npcKeys.waypoints] = {[zoneIDs.STRANGLETHORN_VALE]={{{37.98,3.41},{38.06,3.64},{38.31,3.83},{38.14,4.38},{38.20,4.80},{38.40,4.96},{38.80,5.00},{39.29,5.33},{39.36,7.24},{40.01,8.37},{40.34,8.44},{40.31,8.43},{39.87,8.18},{39.34,7.18},{39.29,5.27},{38.83,5.05},{38.31,4.96},{38.13,4.66},{38.10,3.99},{37.98,3.41}}}},
        },
        [756] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{45.61,41.6}}},
        },
        [768] = {
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS]={{61.2,64},{61.4,66.4},{62.6,63.4},{63.2,65},{64.2,69.2},{64.4,66},{64.8,68.6},{65.4,67.4},{65.4,67.6},{65.4,81.2},{65.8,13.2},{65.8,67.4},{65.8,68.2},{65.8,73.6},{66,10.6},{66,78.2},{66,79.2},{66.2,9.8},{66.2,25.6},{66.2,68.6},{66.2,69.8},{66.2,74.8},{66.4,9.4},{66.4,22.6},{66.4,71},{66.4,76.2},{66.6,68.6},{66.8,11.6},{67,8.4},{67,68},{67,76.8},{67.2,9.4},{67.2,10.6},{67.2,66.6},{67.2,70},{67.2,75},{67.2,76.4},{67.4,10.2},{67.4,73.2},{67.4,74.4},{67.6,8.4},{67.6,9.8},{67.6,66.4},{67.6,66.6},{67.8,75.6},{68,9.4},{68,74.4},{68.2,10.6},{68.2,11.6},{68.2,14.4},{68.2,25.8},{68.2,68.2},{68.2,69.8},{68.2,71.2},{68.4,23},{68.4,24},{68.4,25.2},{68.4,26.8},{68.4,69},{68.4,75.4},{68.4,76.6},{68.6,25.2},{68.6,69.6},{68.6,75.2},{68.6,76.2},{68.6,77.2},{68.6,77.6},{68.8,9.4},{68.8,79.2},{69,9.6},{69,11.2},{69,11.8},{69,12.6},{69,23.4},{69,26.6},{69,67.4},{69,69.2},{69,80.2},{69.2,20.6},{69.2,22.2},{69.2,26.4},{69.2,27.6},{69.2,70.6},{69.4,24.2},{69.4,33},{69.4,66.4},{69.4,68.4},{69.6,12.2},{69.6,22.2},{69.6,24.4},{69.6,25},{69.6,26.2},{69.6,68.6},{69.6,75.4},{69.6,81},{69.8,26.6},{69.8,68.4},{69.8,72},{70,76.8},{70.2,10.8},{70.2,15.6},{70.2,76},{70.4,9.2},{70.4,10.2},{70.4,13.8},{70.4,27.8},{70.6,13.8},{70.6,26.6},{70.8,8.4},{70.8,10.4},{70.8,23.4},{71,15.2},{71.2,9.4},{71.2,11},{71.2,12},{71.2,80.6},{71.4,12.8},{71.4,70.2},{71.4,78.2},{71.6,11.6},{71.8,5.8},{71.8,24},{71.8,27.8},{71.8,71.4},{71.8,77.2},{72,11},{72,13},{72,78.4},{72,79.2},{72,80.4},{72.2,6.8},{72.2,9.2},{72.2,10.2},{72.4,80.8},{72.6,11.2},{72.8,81.6},{73,7.4},{73,9.6},{73,79.6},{73,80.6},{73,83},{73.2,25.8},{73.2,77.4},{73.2,78.4},{73.4,8.4},{73.4,9.2},{73.4,21.8},{73.4,24.2},{73.4,25.2},{73.4,78.8},{73.6,7.4},{73.6,80},{73.8,8.4},{73.8,9},{73.8,10.2},{73.8,20.8},{73.8,78.2},{73.8,81},{73.8,83},{74,22.4},{74,25.6},{74.2,23.4},{74.2,23.8},{74.2,24.6},{74.2,79},{74.4,29},{74.4,74},{74.6,9.2},{74.6,21.4},{74.6,23.4},{74.6,24.6},{74.6,79.2},{74.8,24},{75,9.6},{75.2,14},{75.2,28.6},{75.2,80.6},{75.2,86.6},{75.4,26.4},{75.4,27.4},{75.4,27.6},{75.4,29.8},{75.6,22.4},{75.6,26.4},{75.8,20.8},{75.8,25.4},{75.8,26.8},{75.8,27.6},{75.8,81.8},{76,29.6},{76,85.4},{76,89},{76.2,10.4},{76.2,87.4},{76.2,88},{76.4,29.2},{76.4,85.6},{76.6,24.8},{76.6,28.2},{76.6,85.4},{76.6,86.6},{76.6,87.6},{76.6,88.6},{77,26.6},{77.2,10.6},{77.2,14.2},{77.4,85.8},{77.6,85.2},{77.6,87.4},{77.8,86},{78,27.4},{78.6,13},{78.6,85.8},{78.8,12.4},{79.4,10},{79.4,14},{79.4,82.6},{79.8,13.6},{80,13},{80,78.2},{80.2,69.6},{80.2,74.8},{80.4,12.2},{80.4,14.6},{80.4,17.2},{80.4,70.6},{80.4,75.8},{80.6,14.6},{80.6,15.8},{80.6,63.2},{80.6,81.6},{80.8,14.4},{80.8,16.6},{81,10.8},{81,13.2},{81,18.6},{81,64.4},{81,64.8},{81,88.8},{81.2,77.2},{81.2,77.6},{81.4,18},{81.4,58},{81.4,66.4},{81.4,66.6},{81.4,68},{81.4,69.6},{81.4,75},{81.4,75.6},{81.4,80.8},{81.6,70},{81.6,74.4},{81.6,75.2},{81.6,75.6},{81.6,76.8},{81.6,81.8},{81.8,11.4},{81.8,14},{81.8,73.4},{82,15},{82,21.4},{82,81},{82.2,16.8},{82.2,17.6},{82.2,66.4},{82.2,67.8},{82.4,16.4},{82.4,19.2},{82.4,65.4},{82.4,67.2},{82.4,68.6},{82.4,71.6},{82.4,80.2},{82.6,17},{82.6,28},{82.6,65.4},{82.6,67.2},{82.6,67.8},{82.6,68.6},{82.6,81.6},{82.8,15.4},{82.8,16.2},{82.8,18.8},{82.8,75.8},{82.8,78.6},{83,12.8},{83,19.6},{83,66},{83,78},{83.2,18.2},{83.2,69.6},{83.2,82.8},{83.4,58},{83.4,59},{83.4,59.8},{83.4,60.8},{83.4,80.8},{83.6,17.8},{83.6,60.8},{83.6,66.2},{83.6,66.8},{83.6,81},{83.8,17.4},{83.8,59.6},{83.8,68.4},{83.8,68.6},{84,14.4},{84,18.6},{84,21},{84,21.6},{84,24.2},{84,57.2},{84,59},{84,71.4},{84,75.2},{84,80},{84.2,26.4},{84.2,76.4},{84.2,78.6},{84.4,20.4},{84.4,22.8},{84.4,36.2},{84.4,58.4},{84.4,74},{84.4,76.6},{84.4,77.6},{84.4,83},{84.6,22.4},{84.6,27.8},{84.6,59},{84.6,60.4},{84.6,74.6},{84.6,76.2},{84.6,79.4},{84.8,20.2},{84.8,21},{84.8,22.6},{84.8,58.2},{84.8,77.4},{84.8,77.6},{85,74},{85.2,23.6},{85.2,30.2},{85.2,30.8},{85.2,81.2},{85.4,18.2},{85.4,18.8},{85.4,25.2},{85.4,25.8},{85.4,29.2},{85.4,31.6},{85.4,61},{85.6,21},{85.6,21.6},{85.6,23.4},{85.6,25.6},{85.6,37.2},{85.6,77.4},{85.6,78},{85.8,25.4},{85.8,27},{85.8,30.6},{86,20.4},{86,24.2},{86,29.6},{86,78.6},{86.2,29.2},{86.2,32.8},{86.4,28.2},{86.4,31.8},{86.4,60.4},{86.4,61},{86.4,65.6},{86.4,73.4},{86.4,73.8},{86.4,74.8},{86.4,75.8},{86.6,24.2},{86.6,25.8},{86.6,73},{86.6,78},{86.8,31.6},{86.8,75.6},{86.8,76.6},{87,28},{87,75},{87.2,27.4},{87.2,30.2},{87.2,74.4},{87.4,25.2},{87.4,28.8},{87.4,30.8},{87.4,68.6},{87.6,26.4},{87.6,27.2},{87.6,27.8},{87.6,28.6},{87.6,74.6},{87.8,73.2},{87.8,73.8},{88,30.8},{88,31.8},{88,64.2},{88,65.6},{88.2,30.4},{88.2,35.4},{88.2,40.8},{88.2,60.6},{88.4,32.6},{88.4,36.4},{88.4,36.6},{88.4,63.4},{88.4,64.8},{88.6,29.4},{88.6,31.2},{88.6,31.6},{88.6,62.4},{88.6,64.6},{88.6,65.6},{88.8,37.6},{88.8,64.2},{88.8,66.6},{89,27.6},{89,32.8},{89,35.2},{89,36.2},{89,37},{89,39.4},{89,63.2},{89,71.6},{89,72.6},{89.2,30.2},{89.2,70.6},{89.4,55},{89.4,59.4},{89.6,38.4},{89.8,37},{89.8,61.4},{89.8,74.2},{90,35.6},{90,60},{90,65.4},{90.2,39.4},{90.4,39.8},{90.4,40.6},{90.4,48.4},{90.4,49},{90.4,49.8},{90.4,50.6},{90.6,39.6},{90.6,49.2},{90.6,50.6},{90.8,41.4},{90.8,48.4},{90.8,49.6},{90.8,62.4},{90.8,71.8},{91,39.4},{91,43.2},{91.2,38.2},{91.2,42},{91.4,44},{91.4,45},{91.4,45.6},{91.4,46.6},{91.4,51.8},{91.6,42.4},{91.6,49.6},{91.8,39.2},{91.8,40.6},{91.8,46.8},{91.8,48.4},{91.8,48.8},{92,38.2},{92,40.2},{92,43.4},{92.2,44.6},{92.2,45.6},{92.2,52.2},{92.4,44.2},{92.8,44.4},{92.8,44.6},{93.2,42.4},{93.4,39.6},{93.4,42.6},{93.6,43},{93.6,44.2},{93.8,44.6},{94.6,45}}},
        },
        [822] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{22.4,75.6},{22.6,75.4},{22.8,75.6},{24.8,82.4},{25,82.8},{25,83.8},{25.4,90.4},{25.4,91},{25.6,82.4},{25.8,84.4},{25.8,85.2},{26.2,89},{26.2,89.6},{26.2,90.6},{26.6,89.6},{26.6,90.8},{26.8,89},{27.4,81.4},{27.8,81.6},{28,81.4},{28.8,81},{35.6,87.8},{35.8,88.6},{36.6,88.6},{38.4,89.4},{38.4,89.6},{38.6,89},{38.6,89.6},{43.2,80.8},{43.4,80.4},{44.2,77},{44.2,81},{44.4,77.8},{44.6,77.8},{45.4,86.4},{45.6,76},{45.6,77},{45.8,85.4},{46,86.2},{47,80},{47.2,79.4},{47.8,76.6},{48.8,82.6},{49.2,74.6},{49.2,76},{49.4,81.6},{50.2,73.8},{53.2,84},{53.4,83.2},{53.8,83.8},{54,75.2},{54,75.6},{56.4,75},{57.2,76.4},{57.6,75.4},{58.8,68.2},{60.4,75.4},{60.4,79.2},{60.4,79.8},{60.4,80.8},{60.6,75.6},{60.6,79.4},{61,75.2},{61,79.6},{62.8,77.6},{63.4,76.4},{63.4,76.8},{63.4,79.4},{63.4,79.6},{63.6,76.4},{63.6,79.2},{64.4,62.6},{64.8,63.4},{65.4,78},{65.6,78.6},{65.8,77.4},{65.8,78},{68.2,64.4},{68.8,65.4},{69,65.6},{69.2,64.2},{70.4,74.4},{70.4,74.8},{70.8,74.6},{71,74.4},{71.4,61.2},{71.8,60.4},{71.8,61.2},{71.8,61.8},{72.6,60.2},{73.4,80.4},{73.4,81},{73.4,81.6},{73.6,81.4},{74.4,68.2},{74.6,66.4},{75,67},{75,67.6},{75.6,68.2},{76.8,76.6},{77,76.4},{77.2,60.6},{77.8,60.4},{78.2,61.6},{78.2,79.6},{78.4,61.4},{78.4,79.2},{78.6,61.6},{78.8,60.4},{78.8,61},{78.8,84.2},{79.6,82.8},{81.2,77.2},{81.4,58.4},{81.4,58.8},{81.6,58.4},{81.8,59},{82,59.6},{82.6,59},{82.8,84},{86,77.2},{86.4,63.4},{86.4,63.6},{86.4,64.8},{87.2,64.2},{87.4,64.8},{87.4,66},{87.4,69.4},{87.4,69.8},{87.6,64.4},{87.6,64.8},{87.6,65.8},{87.6,69},{88.4,77},{88.8,77.4},{88.8,77.8}}},
        },
        [775] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{40.38,8.35}}},
        },
        [871] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{23.2,25},{23.4,25.6},{23.8,25.6},{24,25.4},{24,28.8},{24.4,23.4},{24.4,24},{24.4,28},{24.6,24.8},{24.6,27.2},{24.8,23},{25,23.6},{25.2,29.6},{25.4,26.2},{25.4,29.4},{26,28.8},{26.4,26.2},{26.4,26.6},{26.6,26.6},{26.8,22.2},{26.8,23.6},{26.8,26.2},{27,23.2},{27,25.4}}},
        },
        [877] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{23.2,25},{23.4,24.4},{23.4,25.6},{23.4,29.2},{24,25.4},{24,25.6},{24,28.8},{24.4,27.4},{24.4,28},{24.6,27.2},{24.6,27.6},{24.8,30.8},{25,25.2},{25.2,29.4},{25.2,29.6},{25.4,26.2},{25.6,29.2},{25.6,29.8},{26.4,22},{26.4,26.2},{26.4,26.6},{26.6,26.6},{26.6,27.6},{26.8,22.2},{26.8,26.4},{27,23},{27,24.2},{27,25.4},{27.6,22.2},{27.6,22.6}}},
        },
        [879] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{23.4,25},{23.4,25.6},{24,25.4},{24.4,23.8},{24.4,28},{24.6,24.8},{24.6,27.2},{24.8,23.2},{25.2,24},{25.4,26.2},{26.2,26.2},{26.4,27},{26.6,26.6},{26.8,22.2},{26.8,26},{27,24.2},{27,25.4},{27.4,22.6}}},
        },
        [895] = { -- Thorgas Grimson
            [npcKeys.questStarts] = {},
        },
        [918] = { -- Osborne the Night Man
            [npcKeys.questStarts] = {6681,8233},
        },
        [928] = { -- Lord Grayson Shadowbreaker
            [npcKeys.questEnds] = {7638,7639,7640,7644,7646,7648,7666,7670},
        },
        [950] = {
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS]={{60.4,84.4},{61.8,80.2},{61.8,84.2},{62.2,87.8},{62.4,81},{62.4,84.6},{62.8,80.8},{62.8,86.2},{62.8,90.6},{63,89.8},{63,91.6},{63.2,87.4},{63.6,86.4},{63.6,91.6},{64,91.2},{64.2,79.4},{64.4,82.4},{64.4,87.2},{64.4,90.2},{64.6,70.2},{64.8,88.4},{64.8,89.8},{65.2,72},{66,77.4},{66.8,76.4},{67.8,71},{70,76.6}}},
        },
        [986] = { -- Haromm
            [npcKeys.questStarts] = {},
        },
        [988] = { -- Kartosh
            [npcKeys.questStarts] = {},
        },
        [1001] = {
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{44.98,66.08},{42.08,64.69}}},
        },
        [1088] = {
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS]={{83.8,93.2},{84.6,12.6},{84.6,94},{85,95.4},{85,97.2},{85.4,95.6},{85.6,96.4},{85.8,3},{85.8,97.2},{86.2,11.8},{86.4,13.6},{86.4,92.2},{86.8,6.6},{86.8,11.8},{86.8,92.2},{87,84.8},{87.2,7.8},{87.4,6.2},{87.4,8.8},{87.4,10.4},{87.4,11.2},{87.4,18},{87.4,92.8},{87.4,93.6},{87.6,11.6},{87.8,6.4},{88,90.8},{88,92.6},{88.2,10.2},{88.2,86.4},{88.4,6.6},{88.4,8.4},{88.4,8.8},{88.4,10.8},{88.4,19.4},{88.4,19.8},{88.4,20.8},{88.4,87.4},{88.4,91.6},{88.4,93.6},{88.4,95.4},{88.6,6.4},{88.6,6.6},{88.6,92.4},{88.6,93},{88.8,8},{88.8,10.4},{88.8,10.6},{88.8,85},{88.8,90.2},{88.8,91.2},{89,9.4},{89,94.2},{89,94.6},{89.2,22.8},{89.2,84.4},{89.2,85.8},{89.4,12.4},{89.4,12.6},{89.4,19},{89.4,20},{89.4,21.6},{89.4,23.8},{89.4,87},{89.6,7.4},{89.6,11.8},{89.6,85.2},{89.6,86.4},{89.6,93.2},{89.8,9.2},{89.8,13},{89.8,94.4},{90,7.8},{90,10.4},{90,19.4},{90,21.6},{90,22.6},{90,24},{90,84.4},{90.2,17.4},{90.2,18.4},{90.2,20.6},{90.2,86.8},{90.2,89.2},{90.2,96},{90.4,11},{90.4,20.4},{90.4,88.4},{90.4,89.8},{90.4,90.8},{90.4,91.8},{90.6,9.4},{90.6,10.6},{90.6,13.8},{90.6,19.8},{90.6,21.2},{90.6,21.6},{90.6,22.8},{90.6,83.8},{90.6,85.4},{90.6,86.2},{90.6,87.8},{90.8,7.4},{90.8,11.8},{90.8,17},{90.8,18.4},{90.8,19.4},{90.8,86.6},{90.8,92.8},{90.8,97.2},{91,70.8},{91,82.8},{91,94.4},{91,94.8},{91,96.4},{91.2,5.4},{91.2,8.4},{91.2,13.4},{91.2,15.4},{91.2,89.8},{91.4,10.2},{91.4,89.4},{91.4,91.4},{91.4,92.4},{91.6,7.4},{91.6,10},{91.6,18.2},{91.6,19.4},{91.6,31.4},{91.6,32.4},{91.6,32.6},{91.6,69.4},{91.6,86.8},{91.6,88.4},{91.6,96.6},{91.8,9.2},{91.8,11.8},{91.8,30.2},{91.8,70.6},{92,20.2},{92,20.6},{92,21.8},{92,72.4},{92,84.8},{92,88.6},{92,90.2},{92,96.4},{92.2,29.4},{92.2,91},{92.2,92.8},{92.4,6.4},{92.6,33},{92.6,34.4},{92.6,34.6},{92.8,89.4},{92.8,89.6},{92.8,92.8},{92.8,97.2},{93,5.6},{93.2,26.6},{93.2,31.2},{93.2,32.4},{93.2,72.6},{93.2,78},{93.2,79.2},{93.2,92.4},{93.4,7},{93.4,8.6},{93.4,20.4},{93.4,38.4},{93.4,38.6},{93.4,70.2},{93.4,71.2},{93.4,71.8},{93.4,80},{93.4,91.2},{93.4,93.8},{93.4,96.4},{93.6,5.6},{93.6,6.6},{93.6,33.6},{93.6,35.4},{93.6,38.4},{93.6,39.4},{93.6,39.6},{93.6,67},{93.6,67.8},{93.6,81.6},{93.6,96},{93.8,30.6},{93.8,31.8},{93.8,32.8},{93.8,66.2},{93.8,93.6},{94,37},{94,59.6},{94,79.6},{94.2,35.6},{94.2,57.8},{94.2,65},{94.2,69.4},{94.2,70.4},{94.2,71},{94.2,71.6},{94.2,73.6},{94.2,78},{94.2,79},{94.2,80.6},{94.4,7.6},{94.4,30.4},{94.4,42.6},{94.4,58.6},{94.4,72.8},{94.4,76.4},{94.4,77.2},{94.4,92.2},{94.4,93.2},{94.6,5.4},{94.6,28.6},{94.6,36.2},{94.6,40.4},{94.6,40.6},{94.6,42.4},{94.6,42.6},{94.6,59},{94.6,60},{94.6,62},{94.6,67.4},{94.6,68.4},{94.6,68.6},{94.6,70.4},{94.6,71.6},{94.6,75.4},{94.6,83.2},{94.8,32.6},{94.8,64.2},{94.8,65},{94.8,70.8},{94.8,90.4},{94.8,95},{95,6},{95,31.6},{95,37},{95,39},{95,55.4},{95,60.8},{95,66.2},{95,73.2},{95,76.4},{95,78.6},{95,80.6},{95,92},{95,93.2},{95,93.6},{95.2,12.6},{95.2,34.4},{95.2,34.6},{95.2,38.2},{95.2,51.2},{95.2,62.8},{95.2,74.2},{95.2,77.4},{95.2,78.4},{95.2,91.4},{95.4,31.2},{95.4,53.2},{95.4,54.4},{95.4,79.6},{95.4,97.2},{95.6,40},{95.6,40.6},{95.6,42},{95.6,56.2},{95.6,60.2},{95.6,64},{95.6,70.4},{95.6,76},{95.6,77.4},{95.6,80},{95.6,87.2},{95.6,91},{95.6,91.8},{95.8,38.2},{95.8,47.2},{95.8,52.4},{95.8,68.4},{95.8,73},{95.8,75.4},{95.8,88},{95.8,97},{96,45.4},{96,46.2},{96,54.4},{96,57.6},{96,58.6},{96,66},{96,71.4},{96.2,31.8},{96.2,36.2},{96.2,37.2},{96.2,43.4},{96.2,53.2},{96.2,56.8},{96.2,61.4},{96.2,64.8},{96.2,69.4},{96.2,72.2},{96.2,78.4},{96.2,78.8},{96.2,93.4},{96.4,8.6},{96.4,10.4},{96.4,10.8},{96.4,35.2},{96.4,39.4},{96.4,44.4},{96.4,55.4},{96.4,62.4},{96.4,62.8},{96.4,80.6},{96.4,81.6},{96.4,89.2},{96.4,90.2},{96.6,34.4},{96.6,51},{96.6,54.2},{96.6,56.8},{96.6,71},{96.6,73.6},{96.8,8.6},{96.8,12.8},{96.8,37.2},{96.8,39},{96.8,41.2},{96.8,46.2},{96.8,55.4},{96.8,55.6},{96.8,59},{96.8,61.2},{96.8,62.2},{96.8,73.4},{96.8,79.4},{96.8,80.2},{96.8,80.6},{97,7.2},{97,12.4},{97,32.4},{97,37.6},{97,40.2},{97,47.8},{97,48.8},{97,53},{97,69.6},{97,77.4},{97,81.6},{97.2,10.2},{97.2,11.2},{97.2,35},{97.2,36.2},{97.2,42.6},{97.2,45.4},{97.2,46.8},{97.2,52.4},{97.2,58.4},{97.2,62.8},{97.2,65},{97.2,67.4},{97.2,72.4},{97.2,89.8},{97.2,97.4},{97.4,41.8},{97.4,44.4},{97.4,60},{97.4,64},{97.4,68.2},{97.4,69.2},{97.4,88.6},{97.4,91.4},{97.6,37.8},{97.6,46.2},{97.6,48.6},{97.6,52.2},{97.6,53.6},{97.6,54.8},{97.6,56.8},{97.6,63},{97.6,70.6},{97.6,72.4},{97.6,73},{97.6,73.8},{97.6,78.8},{97.8,9.8},{97.8,11.6},{97.8,40.4},{97.8,44.2},{97.8,46.8},{97.8,48.4},{97.8,52.6},{97.8,60.6},{97.8,62},{97.8,63.8},{97.8,67.6},{97.8,70.4},{97.8,80.2},{97.8,81.4},{97.8,89},{97.8,91.2},{98,8},{98,9.4},{98,15},{98,37.4},{98,39.2},{98,42.6},{98,45.2},{98,55.8},{98,65.4},{98,75.4},{98,81.6},{98.2,6},{98.2,6.8},{98.2,11.4},{98.2,13.2},{98.2,33.6},{98.2,35.6},{98.2,41.6},{98.2,58},{98.2,58.6},{98.2,66.4},{98.2,75.8},{98.2,78.4},{98.2,83.2},{98.2,84.2},{98.4,14.2},{98.4,33},{98.4,35.4},{98.4,41},{98.4,50.8},{98.4,60},{98.4,67},{98.4,69.2},{98.4,90.4},{98.6,13.2},{98.6,30.4},{98.6,39},{98.6,40.8},{98.6,55.4},{98.6,68.6},{98.6,71.2},{98.8,7},{98.8,7.6},{98.8,36.8},{98.8,41.6},{98.8,47.4},{98.8,56.2},{98.8,61.6},{98.8,77.6},{98.8,83.6},{98.8,85},{98.8,87.2},{99,6.4},{99,31.4},{99,32.2},{99,33.2},{99,45.2},{99,46},{99,53.6},{99,58.2},{99,66.2},{99,68.4},{99,70.4},{99,73},{99,76.4},{99,77.2},{99,79},{99,81.2},{99,85.8},{99,91},{99,94},{99.2,5.4},{99.2,12.2},{99.2,13.8},{99.2,34.2},{99.2,40.4},{99.2,43},{99.2,43.8},{99.2,48.4},{99.2,57.4},{99.2,59.8},{99.2,66.8},{99.2,71.6},{99.2,82.8},{99.2,92.2},{99.2,92.8}}},
        },
        [1226] = { -- Maxan Anvol
            [npcKeys.questStarts] = {5625,5630,5637},
        },
        [1228] = { -- Magis Sparkmantle
            [npcKeys.questStarts] = {1879,1919},
        },
        [1231] = { -- Grif Wildheart
            [npcKeys.questStarts] = {6064,6084,6085,6086,6722},
        },
        [1259] = {
            [npcKeys.spawns] = {[zoneIDs.WETLANDS]={{18.07,39.84},{15.21,41.45}}},
        },
        [1261] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [1340] = {
            [npcKeys.waypoints] = {[zoneIDs.LOCH_MODAN]={{{32.63,49.74},{33.13,49.31},{33.68,48.60},{34.22,47.76},{34.66,47.21},{35.28,46.85},{35.68,46.67},{36.8,46.36},{36.58,46.22},{36.93,46.09},{37.27,45.75},{37.35,45.12},{37.36,44.49},{37.32,43.89},{37.27,43.32},{37.0,42.58},{36.75,42.02}}}},
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN]={{32.63,49.74}}},
        },
        [1364] = {
            [npcKeys.spawns] = {[zoneIDs.WETLANDS]={{47,17},{49,15},{60,26},{61.6,29.8},{61.6,31.6},{62.49,28.42}}},
        },
        [1421] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{38.14,3.89}}},
        },
        [1494] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{32.45,81.57}}},
        },
        [1511] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{35.09,60.75}}},
        },
        [1514] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{35.05,60.88}}},
        },
        [1516] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{35.06,60.85}}},
        },
        [1721] = {
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{73.34,50.7}}},
            [npcKeys.waypoints] = {[zoneIDs.STORMWIND_CITY]={{{70.26,40.3},{70.93,41.1},{71.47,42.0},{72.18,43.06},{72.69,43.74},{73.02,44.76},{73.28,45.54},{73.22,46.21},{73.57,46.53},{73.57,46.53},{72.85,46.81},{72.47,48.95},{72.47,49.72},{73.34,50.7},{72.57,49.9},{71.26,49.69},{68.81,48.66},{66.63,44.9},{65.69,43.28},{66.57,41.67},{68.1,39.87},{68.76,39.44},{69.25,40.16},{69.25,40.16},{69.8,39.55},{70.26,40.3}}}},
        },
        [1755] = {
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{68.22,14.34}}},
        },
        [1853] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [1892] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.73,72.75}}},
        },
        [1893] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{45.35,73.06}}},
        },
        [1896] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{45.93,73.08}}},
        },
        [1939] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{63.7,22.9},{64.1,25},{66.9,23.8},{65.2,27.9},{65.1,32},{67,34.7},{69.1,34.9},{67.6,31}}},
            [npcKeys.waypoints] = {},
        },
        [1946] = {
            [npcKeys.zoneID] = zoneIDs.TIRISFAL_GLADES,
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{66.67,44.97}}},
        },
        [1981] = {
            [npcKeys.zoneID] = zoneIDs.LOCH_MODAN,
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{52.07,69.32}}},
        },
        [1983] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST]={{44,21},{45,20},{45,21}}},
        },
        [2041] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [2044] = {
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            [npcKeys.spawns] = {
                [zoneIDs.WESTFALL] = {{41.49,66.91}},
                [zoneIDs.STORMWIND_CITY] = {{29.87,61.93}},
                [zoneIDs.ELWYNN_FOREST] = {{85.52,69.67}},
            },
        },
        [2060] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.49,74.09}}},
        },
        [2061] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.5,74.05}}},
        },
        [2062] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.51,74.04}}},
        },
        [2063] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.5,74.01}}},
        },
        [2064] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.5,74}}},
        },
        [2065] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.51,74.04}}},
        },
        [2066] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.5,74.03}}},
        },
        [2067] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.5,74.02}}},
        },
        [2068] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.51,74.05}}},
        },
        [2081] = { -- Sentinel Kyra Starsong
            [npcKeys.questStarts] = {489},
        },
        [2092] = { -- Pilot Longbeard
            [npcKeys.questStarts] = {467,1179},
        },
        [2128] = { -- Cain Firesong
            [npcKeys.questStarts] = {1881,1959},
        },
        [2129] = { -- Dark Cleric Beryl
            [npcKeys.questStarts] = {5650},
        },
        [2149] = {
            [npcKeys.zoneID] = zoneIDs.LOCH_MODAN,
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{63.12,65.93}}},
        },
        [2151] = { -- Moon Priestess Amara
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{52.91,57.2}}},
            [npcKeys.waypoints] = {[zoneIDs.TELDRASSIL] = {{{50.2,53.85},{50.47,54.31},{50.48,54.97},{50.43,55.59},{50.56,56.12},{50.87,56.46},{51.11,56.52},{51.45,56.58},{51.95,56.36},{52.51,56.57},{53.07,57.4},{53.39,57.5},{53.74,57.81},{53.98,58.16},{54.5,58.49},{55.5,58.44},{55.81,58.32}}}},
            [npcKeys.questStarts] = {487,489,1684},
        },
        [2155] = { -- Sentinel Shayla Nightbreeze
            [npcKeys.questStarts] = {489},
        },
        [2158] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{35.21,84.83}}},
        },
        [2159] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{36.25,86.35}}},
        },
        [2160] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{36.37,86.28}}},
        },
        [2207] = {
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE]={{31.04,87.67},{30.85,85.57},{31.02,85.72},{31.44,87.19},{30.96,85.28},{55.46,12.62},{55.01,12.52},{31.63,83.91},{31.42,83.89},{31.13,85.22},{31.13,87.89},{31.4,87.52}}},
        },
        [2275] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{32.66,35.55}}},
        },
        [2306] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_MOUNTAINS]={{47.83,17.11},{56.28,26.7},{57.8,29.8},{60.33,43.12},{53.67,20.4}}},
        },
        [2403] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS]={{35,38.6},{35.2,38},{35.2,40.4},{36.4,39.4},{36.4,39.6},{36.6,39.4}}},
        },
        [2431] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_MOUNTAINS]={{60.4,43.8},{60.8,43.6},{61,43.4},{61.8,40.6},{62.4,40.2},{62.6,40.2},{63,43.4},{63.2,43.8}}},
        },
        [2433] = {
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{51.75,53.69}}},
        },
        [2434] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{50.06,57.91}}},
        },
        [2449] = {
            [npcKeys.waypoints] = {[zoneIDs.HILLSBRAD_FOOTHILLS]={{{32.5,35.8},{32.5,37.6},{32.5,38.9},{32.4,40.7},{32.1,41.8},{32.1,43.4},{32.5,44.4},{32.6,45.3},{32,46.5}},{{36.7,38},{35.5,38.9},{34.2,39.3},{32.8,39.9},{32.1,41.8},{32.0,43.1},{31.6,44.6},{30.3,44.4},{29.9,42.6}}}},
        },
        [2450] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{31.8,52.7}}},
            [npcKeys.waypoints] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{{29.5,54.8},{29.5,55.8},{29.5,56.6},{29.8,57.6},{29.9,58.5},{30.3,59.7},{30.7,60.5},{31.4,59.5},{31.6,57.6},{31.6,55.6},{32,53.7}}}},
        },
        [2462] = {
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{24.11,35.34}}},
        },
        [2520] = {
            [npcKeys.zoneID] = zoneIDs.THE_DEADMINES,
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES] = {{-1,-1}}},
        },
        [2611] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{63.9,30.0}}},
            [npcKeys.waypoints] = {[zoneIDs.ARATHI_HIGHLANDS]={{{65.3,28.9},{65.4,34.2},{65.5,37.9},{65.4,41.6},{65.5,45.1},{60.7,48.2},{58.1,50},{56.5,53.1},{54.8,56.2},{52.6,58.7},{48.9,59.9},{45.1,59.5},{42,59.9},{39.2,61.6},{35.9,61.8},{32.4,58.9},{30.9,55.4},{29.1,50.3},{25.2,48},{21.9,45.9},{20.2,41.6},{21.4,37.5},{23,34.6},{25.8,32.3},{27.4,34},{27.6,38.1},{28.1,41.4},{29,44.9},{30.9,47.2},{33.5,48.8},{36.6,50.1},{39.6,50.9},{42.2,51.9},{45.2,52.7},{47.9,54.2},{49.9,50.5},{51.7,47.6},{54.8,44.8},{58.5,43.2},{60.7,39.9},{61.8,35.6},{62.9,30.9},{65.3,28.9}}}},
        },
        [2612] = {
            [npcKeys.waypoints] = {[zoneIDs.ARATHI_HIGHLANDS] = {{{53.0,39.5},{51.9,41.8},{50.7,43.8},{48.8,43.9},{46.8,45.5},{45.6,47.1},{44.8,49.2},{44.2,50.9},{44.2,53.1},{43.4,54.6},{41.6,54.4},{39.6,54.0},{37.4,52.9},{35.0,52.1},{32.1,51.5},{29.5,50.2},{27.1,50.0},{26.2,52.5},{25.8,55.6},{25.9,58.3}}}},
        },
        [2624] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{24.97,23.58}}},
            [npcKeys.waypoints] = {[zoneIDs.STRANGLETHORN_VALE]={{{21.84,23.04},{21.65,23.71},{21.24,24.29},{20.64,24.18},{20.18,23.71},{19.93,23.07},{19.84,22.52},{20.19,21.82},{20.73,21.6},{21.44,21.68},{21.77,22.58},{21.84,23.04}}}},
        },
        [2657] = {
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS]={{9.6,52.8},{10.6,51.8},{11,51.4},{11.2,53.8},{11.4,53.4},{12,53.8},{12.4,50.4},{12.4,50.8},{12.4,52.2},{12.4,52.6},{12.8,50.2},{13.2,49.4},{13.2,52.6},{13.2,55.2},{13.4,51},{13.4,52.4},{13.4,53.6},{13.6,52.4},{13.8,53.6},{14,49.4},{14.2,47.8},{14.2,50.8},{14.2,52.6},{14.4,50.4},{14.6,50},{14.6,52.2},{14.8,48.4},{14.8,54.4},{15,51.4},{15.4,49.2},{15.4,53},{15.4,54.6},{15.6,51.2},{15.6,52.4},{16,49},{16,53},{16,54.8},{16.2,55.8},{16.4,50.4},{16.4,53.6},{16.6,49.4},{16.6,50.6},{16.6,51.6},{16.8,48.4},{17,50.2},{17,53.4},{17,53.6},{17,55.8},{17.2,54.8},{17.6,50.4},{17.6,50.6},{17.8,47.4},{17.8,49},{18,48},{18.2,52.4},{18.2,53.2},{18.2,54.6},{18.4,53.6},{18.4,56},{18.4,56.8},{18.6,50.4},{18.6,50.6},{18.6,53.6},{18.6,56.2},{18.6,57},{18.8,46},{18.8,47.2},{18.8,53},{18.8,55},{19.2,47.6},{19.2,49.2},{19.4,52.2},{19.6,52.6},{19.6,54.2},{19.8,46.6},{19.8,48.8},{19.8,55.2},{19.8,56.4},{20,49.6},{20.4,48.2},{20.4,51.2},{20.4,52.2},{20.6,51.4},{20.6,51.8},{20.6,52.6},{20.6,54.8},{20.6,56.8},{20.8,48},{20.8,49.2},{20.8,50.2},{20.8,53.8},{21,56},{21.6,47.6},{21.6,50.4},{21.6,51.8},{21.6,55.6},{21.8,53},{21.8,54.2},{21.8,56.6},{21.8,57.8},{22.6,47.8},{22.8,53.4},{23.2,53.8},{23.4,57.8},{23.8,47.6},{23.8,52.4},{24.4,47.2},{25,47.6},{26,55},{26.6,48.2}}},
        },
        [2659] = {
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS]={{47.8,43.6},{48.6,57.4},{49,44},{49.8,50.2},{50.2,45.2},{51,46},{51,47},{51,54.2},{51,56.6},{51.4,47.6},{51.4,49},{51.4,50.8},{51.6,58.8},{51.8,54.6},{52,44.4},{52,48.6},{52,49.6},{52,53.2},{52.2,46.4},{52.2,47.4},{52.2,48},{52.2,50.6},{52.2,52},{52.4,44.6},{52.4,54.2},{52.4,55.8},{52.4,56.6},{52.6,40},{52.6,45.4},{52.6,46.8},{52.6,48.2},{52.6,50.6},{52.6,51.6},{52.8,48.6},{53,53.4},{53,53.6},{53,57.2},{53.2,46.2},{53.2,49.6},{53.2,55.6},{53.4,55},{53.6,43.6},{53.6,46.8},{53.6,52.6},{53.6,56.2},{53.8,47.6},{53.8,50.6},{53.8,54.8},{54,46},{54,49.6},{54,54.4},{54.2,48.8},{54.2,51.8},{54.6,48.4},{54.6,49.4},{54.6,49.6},{54.6,52.8},{55,53.6},{55.2,50.8},{55.2,51.6},{55.4,47.4},{55.6,51},{55.8,48.4},{55.8,50.2},{56,47.4},{56.2,49.2},{56.2,52.8},{56.4,51.8},{56.8,49.4},{56.8,50.8},{57.2,49.8},{57.2,52.8},{57.4,51.8},{57.8,52.4},{58,50.4},{58,51.4},{58,53.2},{58.2,53.6},{58.6,51.2},{58.6,52},{58.6,53},{59,53.6},{59.6,53},{59.8,52.2},{60,55},{60.2,54},{60.4,47},{60.4,49.8},{60.4,55.6},{60.6,48.2},{60.6,51.2},{60.6,52.2},{60.8,49.4},{60.8,50},{61,37.8},{61,46.8},{61,53},{61.2,55},{61.2,56.6},{61.2,57.8},{61.4,42.4},{61.4,53.6},{61.4,56},{61.6,43.8},{61.6,53.8},{61.6,57},{61.8,55.6},{62,40.4},{62,42.4},{62,45.4},{62,46.2},{62,49},{62.2,54.6},{62.4,41},{62.4,42.6},{62.4,47},{62.4,47.8},{62.4,49.8},{62.4,50.8},{62.4,52},{62.4,52.6},{62.6,47.6},{62.6,55.2},{62.8,41.4},{62.8,42},{62.8,45.4},{62.8,50.4},{62.8,51},{63,43.8},{63,48.6},{63.2,46.8},{63.2,51.6},{63.4,42.8},{63.4,46.4},{63.4,53},{63.4,56.8},{63.4,58.2},{63.6,41.4},{63.6,42.2},{63.6,43.2},{63.6,46.8},{63.6,47.8},{63.6,50},{63.8,44.4},{63.8,44.6},{63.8,45.6},{63.8,52.2},{63.8,52.6},{63.8,53.6},{63.8,54.8},{64,51.2},{64.4,49},{64.6,43.4},{64.6,44.4},{64.6,45},{64.6,46.4},{64.6,48.2},{64.6,48.6},{64.8,46.6},{65,51.6},{65.2,53},{65.4,41.8},{65.6,45.2},{65.8,42},{65.8,45.6},{65.8,50},{66,57.4},{66.2,43.2},{66.6,68.4},{67.4,48.4},{68.4,47.6},{71.2,49.8}}},
        },
        [2676] = {
            [npcKeys.spawns] = {
                [zoneIDs.STONETALON_MOUNTAINS] = {{63.69,39.98}},
                [zoneIDs.STRANGLETHORN_VALE] = {{41.4,43.44}},
            },
        },
        [2707] = {
            [npcKeys.zoneID] = zoneIDs.THE_HINTERLANDS,
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{33.82,72.97}}},
        },
        [2755] = {
            [npcKeys.zoneID] = zoneIDs.ARATHI_HIGHLANDS,
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{62.62,34.06}}},
        },
        [2757] = {
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{81.88,49.46}}},
        },
        [2759] = {
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{82.03,49.93}}},
        },
        [2763] = {
            [npcKeys.zoneID] = zoneIDs.ARATHI_HIGHLANDS,
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{36.16,57.91}}},
        },
        [2779] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{19.8,88.8},{20.2,82.4},{20.6,83.4},{20.8,84},{21.2,84.6},{21.2,89.2},{21.2,89.6},{21.6,82.8},{21.6,86},{21.6,89},{21.8,83.6},{21.8,84.8},{22.4,89.6},{22.8,84.4},{23,84.8},{23,86.2},{23,88},{23.2,82.2},{23.2,83.2},{23.4,89},{23.6,83.8},{23.6,89.4},{23.6,89.8},{24,88.4}}},
        },
        [2783] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{29.62,62.97},{29.47,64.14}}},
        },
        [2794] = {
            [npcKeys.zoneID] = zoneIDs.ARATHI_HIGHLANDS,
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{18.62,67.99}}},
        },
        [2919] = {
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{26.01,45.78}}},
        },
        [2929] = {
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS]={{51.4,45.6},{51.4,47},{51.4,49.4},{51.4,54.2},{51.4,54.6},{51.4,58.4},{51.4,60.2},{51.6,46.8},{51.6,54.2},{51.6,54.6},{51.6,59.8},{51.6,62.8},{51.8,49.2},{51.8,49.6},{51.8,59.4},{51.8,61},{51.8,62},{52,46.4},{52.2,52.8},{52.4,47.8},{52.4,51.2},{52.4,51.6},{52.4,55.8},{52.4,56.6},{52.4,58},{52.6,46.8},{52.6,57},{52.6,57.6},{52.8,46.4},{52.8,50.8},{52.8,52.8},{53.2,44.8},{53.2,48.4},{53.2,49.6},{53.2,54.2},{53.2,55.4},{53.2,55.8},{53.4,49},{53.4,51.6},{53.6,46.6},{53.6,49.2},{53.6,54.8},{53.6,56},{54,41.2},{54,42.4},{54,53.2},{54.2,42.8},{54.2,43.8},{54.2,45.4},{54.2,45.6},{54.2,50},{54.2,54},{54.4,50.6},{54.4,51.6},{54.6,42.4},{54.6,42.8},{54.6,44},{54.6,46},{54.6,50.4},{54.8,44.8},{55,52.6},{55.2,51.4},{55.2,51.8},{55.4,46.6},{55.4,53.6},{55.6,43.6},{55.6,51.4},{55.6,52},{55.8,42.4},{55.8,43.4},{55.8,53.2},{55.8,54.2},{56,45.4},{56,45.8},{56.2,46.8},{56.4,48},{56.6,46.4},{56.6,46.8},{56.8,51.6},{57,51.4},{57,52.8},{57.4,53.6},{57.6,54.2},{58.2,49.8},{58.4,47.2},{58.4,48.2},{58.4,49},{58.4,50.6},{58.4,52.2},{58.4,52.8},{58.4,54.6},{58.6,46.8},{58.6,48.4},{58.6,49.2},{58.6,49.6},{58.6,52.8},{59,46.2},{59,51.2},{59.2,51.6},{59.4,54.2},{59.4,54.6},{59.6,50.4},{59.6,50.8},{59.6,51.8},{59.6,53.4},{59.6,54.4},{59.8,49.2},{60.2,55.4},{60.4,46.2},{60.4,55.8},{60.6,54.2},{60.8,55.6},{61,42.8},{61,46.4},{61.2,41.4},{61.2,41.6},{61.2,55.4},{61.4,43.8},{61.4,46.8},{61.4,47.8},{61.6,47.2},{61.6,48},{61.8,42},{61.8,45.4},{62,44.2},{62,49.4},{62,55.4},{62.2,45.8},{62.2,50.6},{62.2,55.8},{62.4,40.8},{62.4,43},{62.4,49.8},{62.4,51.6},{62.6,41},{62.6,45.6},{62.6,49.4},{62.6,55.4},{62.8,42},{62.8,42.8},{62.8,45.4},{62.8,51},{62.8,52.4},{62.8,54},{62.8,55.8},{63,43.6},{63,48},{63.4,47.4},{63.4,49.8},{63.4,53.4},{63.6,45.2},{63.6,46.4},{63.8,53.4},{63.8,53.6},{64,48.4},{64,51.4},{64,51.8},{64,54.8},{64,55.6},{64.2,49.4},{64.2,50.4},{64.6,50.2},{64.6,55.4},{64.6,55.6},{64.8,50.6},{64.8,52.4},{65.2,52.8},{65.4,57.4},{65.4,57.6},{65.6,53.2},{65.6,53.8},{65.6,57.8},{65.8,57.4}}},
        },
        [2937] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{59.71,10.06}}},
        },
        [2992] = {
            [npcKeys.zoneID] = zoneIDs.RAZORFEN_KRAUL,
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{-1,-1}}},
        },
        [3030] = { -- Siln Skychaser
            [npcKeys.questStarts] = {},
        },
        [3031] = { -- Tigor Skychaser
            [npcKeys.questStarts] = {},
        },
        [3032] = { -- Beram Skychaser
            [npcKeys.questStarts] = {8410},
        },
        [3033] = { -- Turak Runetotem
            [npcKeys.questStarts] = {27,5922,6002,6126,9063},
        },
        [3034] = { -- Sheal Runetotem
            [npcKeys.questStarts] = {},
        },
        [3038] = { -- Kary Thunderhorn
            [npcKeys.questStarts] = {6065,6070},
        },
        [3039] = {
            [npcKeys.questStarts] = {8151},
        },
        [3041] = { -- Torm Ragetotem
            [npcKeys.questStarts] = {1718,1823,8417},
        },
        [3044] = { -- Miles Welsh
            [npcKeys.questStarts] = {5642,5644,5656,5663},
        },
        [3045] = { -- Malakai Cross
            [npcKeys.questStarts] = {},
        },
        [3046] = { -- Father Cobb
            [npcKeys.questStarts] = {},
        },
        [3047] = { -- Archmage Shymm
            [npcKeys.questStarts] = {8250},
        },
        [3048] = { -- Ursyn Ghull
            [npcKeys.questStarts] = {},
        },
        [3049] = { -- Thurston Xane
            [npcKeys.questStarts] = {1959},
        },
        [3060] = { -- Gart Mistrunner
            [npcKeys.questStarts] = {},
        },
        [3064] = { -- Gennia Runetotem
            [npcKeys.questStarts] = {5928},
        },
        [3111] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{43.2,50.6},{43.4,50.2},{44.2,49.4},{44.4,49.8},{44.6,48.8},{44.6,50.2},{46.4,48.8},{47.2,47.4},{47.4,48},{47.4,48.6},{47.4,49.6},{47.6,48},{47.6,48.6},{47.8,47.4},{49.2,48.4},{49.4,49.2},{49.6,48},{49.6,49.2},{50.2,49.6},{50.2,50.6},{50.8,48.8},{51,48.2}}},
        },
        [3112] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{43.2,50.4},{43.2,50.6},{43.6,50},{44.4,48.8},{44.6,48.8},{44.6,50},{46.4,49},{47,47.8},{47.4,49.4},{47.4,49.6},{47.6,48},{47.6,48.6},{47.6,49.6},{49.2,48.4},{49.4,49.2},{49.6,47.2},{49.6,47.6},{49.6,49.2},{50.2,49.6},{50.2,50.6},{50.8,48.8}}},
        },
        [3113] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{38.2,52.4},{38.2,52.8},{38.2,54.4},{38.2,54.8},{38.6,55},{39,53.6},{39.4,52.4},{39.4,52.6},{39.6,52.4},{39.6,52.6},{41.2,37.8},{41.2,39},{41.4,37.4},{41.6,38.2},{42,39.2},{42,40.4},{42.2,36.2},{42.2,42.2},{42.4,37.2},{42.4,40.6},{42.8,37.4},{42.8,41.6},{42.8,42.8},{43,38},{43,39.4},{43.2,40},{43.2,40.6},{44,37.2},{44,41.4},{44,41.6},{44.2,38.2},{44.2,39.2},{44.4,36},{44.4,39.8},{44.6,37.8},{44.6,39.4},{44.6,39.6},{44.6,40.6},{45,37.4}}},
        },
        [3114] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{38,51.8},{38.4,53.4},{38.4,53.6},{38.4,54.6},{38.6,54.8},{38.8,53.2},{39.2,53.6},{39.4,52.4},{39.6,52.4},{39.6,52.6},{41,51.6},{41.4,37.4},{41.4,37.6},{41.6,38},{41.8,36.4},{41.8,39},{42,40.4},{42.2,37.2},{42.4,40.6},{42.6,41.6},{42.8,37.4},{43,38.2},{43.2,39.4},{43.2,40.4},{43.2,40.6},{43.8,41.2},{44,37.4},{44.2,38.4},{44.2,39},{44.2,41.8},{44.4,39.8},{44.6,39.8},{44.6,40.6},{45,37.4},{45,37.6},{45.2,38.6}}},
        },
        [3140] = {
            [npcKeys.waypoints] = {[zoneIDs.DUROTAR]={{{54.2,73.2},{54.4,74.2},{54.4,75},{54,76.2},{54.4,75},{54.4,74.2},{54.2,73.2}}}},
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{54.4,75}}},
        },
        [3154] = { -- Jen'shan
            [npcKeys.questStarts] = {},
        },
        [3204] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{52.61,8.82}}},
        },
        [3237] = {
            [npcKeys.waypoints] = {},
        },
        [3230] = {
            [npcKeys.questStarts] = {1361},
        },
        [3253] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{42,70}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS]={{{42,70},{44,69},{44,70},{44,73},{46,71},{47,69},{47,71}}}},
        },
        [3257] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{59.8,30.6}}},
        },
        [3297] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [3324] = { -- Grol'dar
            [npcKeys.questStarts] = {},
        },
        [3325] = { -- Mirket
            [npcKeys.questStarts] = {},
        },
        [3327] = { -- Gest
            [npcKeys.questStarts] = {6681},
        },
        [3328] = { -- Ormok
            [npcKeys.questStarts] = {6681,8233},
        },
        [3344] = { -- Kardris Dreamseeker
            [npcKeys.questStarts] = {},
        },
        [3352] = {
            [npcKeys.questStarts] = {8151},
        },
        [3362] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [3363] = { -- Magar
            [npcKeys.questStarts] = {65610},
            [npcKeys.questEnds] = {65601},
        },
        [3395] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{53.06,41.74}}},
        },
        [3401] = { -- Shenthul
            [npcKeys.questStarts] = {2379,2458,2460,2479,6681},
        },
        [3403] = { -- Sian'tsu
            [npcKeys.questStarts] = {},
        },
        [3406] = { -- Xor'juul
            [npcKeys.questStarts] = {},
        },
        [3407] = { -- Sian'dur
            [npcKeys.questStarts] = {6068},
        },
        [3450] = {
            [npcKeys.zoneID] = zoneIDs.THE_DEADMINES,
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES] = {{-1,-1}}},
        },
        [3467] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{64.22,47.13},{63.3,49},{62.6,49.8}}},
        },
        [3473] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{44.2,62},{45.4,62.8},{49.2,61.6},{49.4,59.2}}},
            [npcKeys.waypoints] = {},
        },
        [3474] = {
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS]={{{46,49.4},{44.8,49},{45,52.6},{45.2,52.4},{47.2,51.6},{47.4,51.2},{49.4,53},{49.8,53.4},{49.8,53.6},{47.6,51},{46,49.6}}}},
        },
        [3475] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{55.86,17.19}}},
        },
        [3476] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{63,52.4},{63.4,50.2},{63.4,53.4},{63.4,53.6},{63.6,53.4},{63.6,53.6},{64,52},{64.2,50.6},{64.4,50.4},{64.6,49.6},{64.6,50.8},{65.2,47.6},{65.4,47.2},{65.6,46.8},{65.6,47.8}}},
        },
        [3529] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.48,72.22}}},
        },
        [3531] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.72,72.44}}},
        },
        [3533] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{44.16,73.83}}},
        },
        [3537] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{55.38,34.71}}},
        },
        [3560] = {
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{35.23,10.33}}},
        },
        [3600] = { -- Laurna Morninglight
            [npcKeys.questStarts] = {5621,5629,5636},
        },
        [3602] = { -- Kal
            [npcKeys.questStarts] = {5925},
        },
        [3616] = { -- Onu
            [npcKeys.questStarts] = {944,951,960,961},
            [npcKeys.questEnds] = {948,950,951,952,960,961},
        },
        [3619] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{59.11,22.4},{60.19,16.36},{57.6,18.13}}},
        },
        [3630] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{44.6,35.6},{45.2,35},{46,36.4},{46,36.6},{46.2,34.6},{46.8,36.6},{47,36.2},{47.8,35.2}}},
        },
        [3631] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{47.37,33.68},{48.24,32.22},{49.41,33.17},{49.1,33.8},{48.09,34.61},{48.18,34.37},{47.09,32.87}}},
        },
        [3632] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{46.32,32.54},{46.57,34.22},{45.88,33.05},{46.19,34.26},{45.92,33.55},{46.2,34.8},{46.08,32.52},{46.3,35.06},{45.9,35.6},{46.18,35.27},{46.6,34.78},{45.79,34.09}}},
        },
        [3633] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{47.62,32.38},{47.9,32.62},{47.38,32.78},{48.79,32.56},{48.04,32.14},{47.62,32.83},{49.17,33.31},{49.19,32.72},{48.45,32.29},{48.84,31.98},{48.96,33.97},{48.34,34.25},{47.53,34.14},{47.41,33.39}}},
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
        },
        [3634] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{45.2,36.2},{46,36.4},{46,36.6},{46.6,36.2},{48.2,36.6},{48.8,35.6}}},
        },
        [3654] = {
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS]={{-1,-1}}},
        },
        [3657] = { -- Sentinel Elissa Starbreeze
            [npcKeys.questStarts] = {965,1684},
        },
        [3685] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [3694] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{39.28,43.46}}},
        },
        [3706] = { -- Tai'jin
            [npcKeys.questStarts] = {5648,5654,5660},
        },
        [3707] = { -- Ken'jai
            [npcKeys.questStarts] = {5649},
        },
        [3864] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWFANG_KEEP] = {{-1,-1}}},
        },
        [3865] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWFANG_KEEP] = {{-1,-1}}},
        },
        [3879] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{25.76,30.17}}},
        },
        [3893] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{26.67,23.88}}},
        },
        [3898] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{43.57,94.44}}},
        },
        [3899] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{43.54,94.32}}},
        },
        [3900] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{43.52,94.39}}},
        },
        [3939] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{54.77,25.88},{58.28,25.1}}},
        },
        [3987] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{39.61,36.31}}},
            [npcKeys.waypoints] = {[zoneIDs.ASHENVALE] = {{{39.12,36.25},{38.84,36.22},{38.57,36.03},{38.22,35.77},{37.76,35.15},{37.78,34.6},{37.82,34.44},{37.8,34.27},{37.47,34.03},{36.66,33.21},{36.4,32.74},{36.29,32.54},{35.83,32.14},{35.91,31.85},{35.69,32.73},{36.18,33.31},{36.81,33.95},{37.01,34.71},{36.72,35.6},{36.23,36.13},{36.12,36.34},{35.81,36.56},{35.91,36.79},{36.27,36.7},{37.04,36.15},{37.17,36.03},{37.72,35.86},{38.12,35.76},{38.93,36.4},{39.35,36.22},{39.6,36.29},{39.12,36.25}}}},
        },
        [3998] = {
            [npcKeys.zoneID] = zoneIDs.STONETALON_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{71.76,60.29}}},
        },
        [4001] = {
            [npcKeys.zoneID] = zoneIDs.STONETALON_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{71.75,60.32}}},
        },
        [4002] = {
            [npcKeys.zoneID] = zoneIDs.STONETALON_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{71.76,60.45}}},
        },
        [4073] = {
            [npcKeys.zoneID] = zoneIDs.STONETALON_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{67.2,46.69}}},
            [npcKeys.waypoints] = {[zoneIDs.STONETALON_MOUNTAINS]={{{67.2,46.69},{66.44,46.95},{66.01,45.73},{65.79,45.08},{65.11,44.76},{63.71,45.05},{63.77,45.99},{63.37,46.14},{63.47,46.55},{64.7,46.43},{64.79,47.69},{65.2,48.34},{65.94,48.57},{66.29,49.62},{66.61,49.61},{66.85,48.84},{67.28,49.21},{68.25,49.51},{68.44,49.55},{68.9,48.35},{69.14,47.32},{69.38,46.52},{70.04,47.47},{70.24,48.58},{70.97,48.65},{71.16,48.27},{71.24,47.04},{71.44,45.68},{71.27,44.91},{71.25,43.55}}}},
        },
        [4090] = { -- Astarii Starseeker
            [npcKeys.questStarts] = {5674}, -- Doesn't actually start 5674, but that quest is blacklisted until it can be proven who starts that quest
        },
        [4091] = { -- Jandria
            [npcKeys.questStarts] = {},
        },
        [4092] = { -- Lariia
            [npcKeys.questStarts] = {},
        },
        [4094] = {
            [npcKeys.waypoints] = {},
        },
        [4095] = {
            [npcKeys.waypoints] = {},
        },
        [4096] = {
            [npcKeys.waypoints] = {},
        },
        [4099] = {
            [npcKeys.waypoints] = {},
        },
        [4132] = {
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES]={{70.03,86.22},{68.38,82.32},{67.26,86.1}}},
        },
        [4163] = { -- Syurna
            [npcKeys.questStarts] = {2242,6681,8233},
        },
        [4205] = { -- Dorion
            [npcKeys.questStarts] = {8151},
        },
        [4214] = { -- Erion Shadewhisper
            [npcKeys.questStarts] = {2260,6681},
        },
        [4215] = { -- Anishar
            [npcKeys.questStarts] = {6681},
        },
        [4217] = { -- Mathrengyl Bearwalker
            [npcKeys.questStarts] = {26,3785,3803,5921,6001,6121,6762,9063},
        },
        [4218] = { -- Denatharion
            [npcKeys.questStarts] = {5923},
        },
        [4219] = { -- Fylerian Nightwing
            [npcKeys.questStarts] = {},
        },
        [4263] = {
            [npcKeys.zoneID] = zoneIDs.STONETALON_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{53.33,73.77}}},
        },
        [4264] = {
            [npcKeys.zoneID] = zoneIDs.STONETALON_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{53.34,73.63},{60.92,62.71},{62.79,59.87},{76.66,44.99}}},
        },
        [4323] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{37.2,74.6},{37.4,73.4},{37.4,74.4},{37.6,72.8},{37.6,74},{38,74.8},{38.4,75.8},{38.6,75.8},{39.2,73.4},{39.2,74.2},{39.4,70.4},{39.4,70.6},{39.4,72.4},{39.4,74.6},{39.6,68.4},{39.6,73.2},{39.6,74.6},{39.8,70.6},{40,69.4},{40,70.4},{40.2,73.6},{40.4,71.8},{40.4,75.6},{40.6,71},{40.6,71.6},{40.8,65.8},{40.8,69.4},{41,63.6},{41,73.4},{41,78.6},{41.2,64.8},{41.2,74.6},{41.2,75.8},{41.2,77.6},{41.4,70},{41.4,74},{41.4,77.4},{41.4,79.8},{41.4,80.6},{41.6,70.4},{41.6,73.6},{41.8,64},{41.8,70.8},{41.8,73.4},{41.8,79.8},{42,72.4},{42,80.8},{42.2,65.6},{42.2,67},{42.2,75},{42.2,76.2},{42.2,76.6},{42.4,65.4},{42.4,68.4},{42.4,68.6},{42.4,78},{42.4,79},{42.4,81.8},{42.4,82.8},{42.6,68.2},{42.6,74},{42.6,75.2},{42.6,76},{42.6,77.2},{42.6,78},{42.6,79.4},{42.6,79.6},{42.6,82.6},{42.8,69},{42.8,69.6},{42.8,72.4},{42.8,82.2},{43,80.8},{43.2,65.8},{43.4,64.4},{43.4,65},{43.4,67},{43.6,66.4},{43.6,66.8},{43.6,80.4},{43.8,64.4},{43.8,64.6},{44,81.4},{44.2,71},{44.2,72.4},{44.2,73.2},{44.2,74.2},{44.2,81.8},{44.2,82.6},{44.4,63.4},{44.4,67.6},{44.4,69.2},{44.4,69.6},{44.4,74.6},{44.4,76},{44.4,76.8},{44.4,78.4},{44.4,78.8},{44.6,65.8},{44.6,69.4},{44.6,69.6},{44.6,76.6},{44.6,80.2},{44.6,81.2},{44.8,76},{44.8,78.4},{44.8,81.8},{45,63.4},{45,64.6},{45,67.4},{45,67.8},{45,70.6},{45,75.4},{45,78.8},{45.2,64.4},{45.4,72.4},{45.4,73},{45.4,73.6},{45.4,83.4},{45.4,83.6},{45.6,64.4},{45.6,64.6},{45.6,68.2},{45.6,68.6},{45.6,69.6},{45.6,72.4},{45.6,72.8},{45.6,73.6},{45.6,79},{45.8,65.6},{45.8,75},{45.8,76.2},{45.8,84.4},{46,67.4},{46,80.2},{46,82},{46,84.6},{46.2,81.2},{46.2,83.4},{46.4,71.2},{46.4,77.2},{46.4,77.6},{46.6,64.8},{46.6,68.6},{46.6,72.6},{46.6,77.2},{46.6,77.6},{46.6,80.2},{46.6,81.4},{46.6,84.8},{46.8,66.4},{46.8,71.8},{46.8,76.4},{46.8,84.4},{47,79.4},{47,82.2},{47.2,73.8},{47.2,82.6},{47.4,67.4},{47.4,67.6},{47.4,70.2},{47.4,70.6},{47.6,65.4},{47.6,66.2},{47.6,68},{47.6,70.2},{47.6,70.6},{47.6,73},{47.6,82},{48,80.8},{48.2,80.4},{48.4,66.6},{48.4,69.4},{48.4,76.4},{48.4,77.4},{48.4,78.4},{48.4,78.6},{48.6,66.4},{48.6,77.4},{48.6,78.4},{48.6,78.6},{48.6,80.4},{48.6,81},{48.6,81.6},{48.8,63.4},{48.8,63.6},{49,69.4},{49,69.6},{49,73},{49.2,67.4},{49.2,67.6},{49.2,70.8},{49.4,71.6},{49.6,67},{49.6,68},{49.6,78},{49.6,78.6},{49.8,69.4},{50,69.6},{50.2,71.4},{50.2,72.2},{50.4,72.6},{50.4,74.2},{50.4,74.8},{51.2,70.2},{51.2,71.6},{51.2,73.4},{51.2,74.2},{51.2,74.6},{51.4,67.4},{51.4,68},{51.4,69},{51.4,71.2},{51.6,66.4},{51.6,68.2},{51.6,69},{51.6,70.8},{51.6,74.4},{51.6,74.6},{51.8,67.4},{51.8,71.6},{51.8,75.6},{52,73.2},{52.4,70},{52.6,68.4},{52.6,70},{52.6,70.6},{52.8,69.4},{52.8,75.8},{53.6,72.2},{54,69.2},{54,70.2},{54,73.6},{54.2,70.8},{54.4,73.4},{54.4,83.2},{54.6,68.8},{54.8,72.4},{54.8,73},{55,70.4},{55,73.6},{55.4,70.6},{55.4,82.4},{55.4,83},{55.4,83.6},{55.6,68.6},{55.6,83.4},{55.6,83.6},{56,70.6},{56.2,70.4},{56.2,81.8},{56.8,70.2},{56.8,70.8}}},
        },
        [4324] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{37.4,74.2},{37.6,74},{38,75},{38.4,76},{38.6,76},{39.2,73.4},{39.2,74.2},{39.4,74.6},{39.6,73.2},{39.8,70.6},{40,70.2},{40,73.6},{40.6,70.8},{41,73.2},{41,74.6},{41.2,76},{41.2,77.4},{41.2,77.6},{41.4,73.8},{41.4,79.6},{41.6,73.4},{41.6,73.6},{41.8,70.4},{41.8,70.6},{41.8,79.8},{41.8,80.8},{42.2,65.4},{42.2,75},{42.2,76.4},{42.2,76.6},{42.2,78.2},{42.2,78.8},{42.4,65.6},{42.6,65.8},{42.6,75.4},{42.6,75.6},{42.6,79.4},{42.8,82},{43,69.2},{43.2,80.4},{43.2,80.8},{43.4,65},{43.4,67},{43.6,64.8},{43.6,66.4},{43.6,66.6},{43.8,64.4},{44,81.4},{44.2,74.2},{44.2,81.8},{44.4,74.6},{44.6,76.6},{44.8,69.4},{44.8,69.8},{44.8,76},{44.8,79},{45,64.4},{45,67.4},{45,75.4},{45,78.4},{45.4,64.6},{45.4,68.4},{45.4,72.2},{45.4,73.2},{45.4,73.6},{45.4,83.4},{45.4,83.6},{45.6,64.4},{45.6,64.6},{45.6,68.4},{45.6,68.6},{45.6,72.4},{45.6,73.2},{46,67.4},{46,82},{46,84.6},{46.2,83.4},{46.2,83.6},{46.4,66.2},{46.4,77},{46.4,81.4},{46.6,77.2},{46.6,81.4},{46.8,72.2},{46.8,72.6},{46.8,84.4},{46.8,84.6},{47.2,67},{47.2,70.6},{47.2,82.4},{47.2,82.6},{47.4,66.4},{47.4,67.6},{47.4,70.2},{47.6,67.6},{47.6,70.2},{48,80.8},{48.2,80.4},{48.4,66.4},{48.4,66.8},{48.4,78.4},{48.4,78.6},{48.6,66.4},{48.6,78.4},{48.6,78.6},{48.8,69.4},{48.8,69.6},{49.2,67.6},{49.4,67.4},{49.6,67.4},{49.8,69.4},{50,69.6},{50.2,72.2},{50.4,72.6},{51,71.6},{51,74},{51.2,71.4},{51.6,74},{51.8,67.4},{51.8,67.6},{52.4,70},{52.6,70},{54,70.2},{54.2,70.6},{55,73.2},{55,84.2},{55.4,83.4},{55.6,83.4},{55.6,83.6},{56,70.6},{56.2,70.4}}},
        },
        [4329] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{36.8,69},{37.4,67.4},{37.4,67.8},{38,68.2},{38.2,66.4},{38.2,66.8},{38.4,68.6},{38.6,68},{38.6,74.6},{39,64.6},{39,66},{39.4,64.4},{39.4,66.6},{39.4,74.4},{39.6,65.8},{39.6,74.2},{39.8,65.2},{40.6,66},{41.6,73.2},{42.2,66.2},{42.2,67},{42.2,79.2},{42.4,67.8},{42.4,76},{42.4,80.6},{42.6,66.6},{42.6,68.6},{43,65.8},{43,81},{43.2,65.2},{43.8,64.4},{43.8,66.2},{44.2,65.4},{44.4,67.2},{44.4,74.8},{44.6,65.4},{44.6,65.6},{44.6,81.8},{44.8,64.4},{44.8,67.6},{44.8,69.2},{45,74.8},{45.2,67.2},{45.4,75.8},{45.6,65.4},{45.6,66},{46,67},{47,77.8},{47,82},{47.8,66.6},{48.8,69.8},{49.2,69},{50.4,72},{51,71.6}}},
        },
        [4331] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{36.8,69},{37.4,67.4},{37.4,68.2},{37.8,68.2},{38.2,66.4},{38.2,66.8},{38.6,67.8},{38.8,64.6},{39,64.4},{39.2,66.4},{39.4,66.6},{39.4,74.4},{39.6,65.6},{39.8,65.2},{39.8,73.6},{42,67.2},{42.2,73.2},{42.4,75.2},{42.6,66.6},{42.8,69},{43,65.8},{43.2,81.2},{43.4,65.4},{43.8,66.2},{44.2,64.4},{44.4,65.4},{44.4,67.2},{44.6,65.4},{44.6,65.6},{44.8,64.4},{44.8,67.6},{44.8,69.2},{45,75.2},{45.2,67.2},{45.6,64.8},{45.6,66},{46,67.2},{48,81.8},{49.2,69},{51,71.6}}},
        },
        [4342] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{50.69,26.77},{46.04,22.01},{56.25,35.76},{42.82,38.64},{40.05,27.21}}},
        },
        [4355] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{40.76,41.67},{45.25,53.49}}},
        },
        [4358] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{56.2,20.8},{56.2,21.8},{56.2,23},{56.8,22.6},{57,21.2},{57.2,22.4},{57.4,20.4},{57.6,20},{57.6,21.6},{57.8,19.4},{57.8,22.6},{58,20.6}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4359] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{57.13,15.03},{57.42,14.93},{57.44,15.17},{58.2,16.26},{57.98,15.41},{58.06,15.91},{58.48,16.22},{58.36,15.33},{58.85,14.9},{54.17,15.11},{54.07,14.94},{59.14,15.51},{54.57,15.53},{57.34,15.54},{54.19,15.66},{53.78,15.15},{55.36,16.61},{54.74,16.48},{57.45,16.0},{57.6,15.85},{57.49,16.58},{56.2,22},{56.4,21},{56.4,23},{57,21.2},{57,22.4},{57,22.6},{57.4,20.2},{57.6,20.2},{57.6,21.6},{57.6,22.6},{57.8,19.2},{57.8,20.8}}},
        },
        [4360] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{57,11},{57.4,10.4},{57.8,11.6},{58,11},{58.2,9.2},{58.4,8.4},{58.4,10.2},{58.6,8},{59,10.8},{59.4,9.4},{59.4,9.8},{59.6,7.2},{59.6,9.2},{59.6,9.8},{59.6,10.6},{59.8,7.6},{61.6,18.2},{61.6,19},{61.8,7.4},{62.4,8},{62.4,17.4},{62.6,18.8},{62.6,19.6},{62.8,8},{62.8,9},{63,7.2},{63,28},{63.2,6},{63.2,27},{63.4,18.4},{63.4,26.4},{63.4,29},{63.8,7.2},{63.8,27.8},{64.4,29},{64.6,28.2},{64.6,29.2},{64.8,26.4},{64.8,27}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4377] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{30.2,21.4},{30.4,21.8},{30.8,20.4},{31.2,21.4},{31.4,22.4},{31.4,22.6},{31.6,22.6},{32.2,22.2},{32.6,22.4},{32.6,22.6},{33.6,22.6}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4391] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{41.09,51.04},{45,55.59},{45.8,59.09}}},
        },
        [4396] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{53.6,11.4},{54.2,12.6},{54.4,12.4},{54.4,13.6},{54.6,12.2},{54.6,13.2},{54.6,13.6},{55.2,15.2},{55.4,16.6},{55.6,15.4},{55.8,15.8},{56,16.8},{57.4,8.6},{58.2,7.8},{59.4,7},{59.4,14.4},{59.4,14.6},{59.6,14.4},{59.8,15.8},{60.2,7.6},{60.2,8.6},{60.2,10.8},{60.2,15.2},{60.2,17},{60.2,18.4},{60.4,18.8},{60.6,8.6},{60.6,19},{61.2,20.4},{61.4,21},{61.4,27.4},{61.4,27.6},{61.4,29.2},{61.4,30.4},{61.4,30.6},{61.6,9},{61.6,21.4},{61.6,21.6},{61.6,27.2},{61.6,27.8},{61.6,29.4},{61.6,30.4},{61.8,22.6},{61.8,26.4},{61.8,31.4},{61.8,31.8},{62,24.4},{62,24.8},{62.4,33.4},{62.4,33.6},{62.6,25.4},{62.6,25.6},{62.6,28.6},{62.6,29.8},{62.6,33.4},{62.6,33.6},{62.8,20.4},{63,35.4},{63,36},{63,36.8},{63.4,16.8},{63.4,38},{63.8,38.4},{64,30.2},{64,38.8},{64.2,25.8},{64.4,39.6},{64.6,40},{64.6,42.6},{64.8,40.6},{64.8,41.8},{65,26.6},{65.2,25},{65.2,30.4}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4398] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{45,34},{45.6,32},{45.6,34.6},{45.8,34.2},{46.6,31.2},{46.6,32.4},{46.6,32.6},{46.8,35.8},{47,30.2},{47,33.6},{47,34.6},{47,36.8},{47.6,37},{47.6,37.8},{47.8,34},{48,39},{48,39.8},{48.2,40.6},{48.4,30.6},{48.6,31.2},{48.6,37.6},{48.6,39.6},{48.8,42.2},{49,32.6},{49.2,32.4},{49.2,36.2},{49.2,39},{49.2,41},{49.2,43.2},{49.4,37.4},{49.8,36.2},{50,39.4},{50,39.6},{50,41.4},{50.4,36.8},{50.4,43},{50.8,37},{50.8,39},{50.8,39.6},{50.8,41.2},{50.8,42.4},{51,37.6},{51.2,36.2},{51.4,35.4},{51.6,45.8},{51.8,41.8},{51.8,43.4},{52.2,39.2},{52.2,45.2},{52.4,43.8},{52.6,42.2},{52.6,46.2},{52.8,46.6},{53,40.4},{53,43.6},{53.2,37.6},{53.4,43.4},{53.4,45.2},{53.6,44.4},{54,40.2},{54.4,44.8},{54.4,47.4},{54.4,48},{54.6,45},{54.6,47.4},{54.8,44.2},{55.4,42.4},{55.4,43.4},{55.4,49.2},{56,41.8},{56.2,44.2},{56.2,45.8},{56.4,48.4},{56.4,49.4},{56.4,50.4},{56.6,41.2},{56.8,47.6},{57,42.6},{57,47.2},{57,51.2},{57,51.8},{57.2,45.2},{57.4,49},{57.4,49.6},{57.6,48},{57.6,49.2},{57.6,49.6},{58.4,43.2},{58.4,44.4},{58.4,45},{58.4,51.4},{58.6,51.6},{58.8,51.4},{59.2,42.4},{59.2,44.6},{59.4,49.8},{59.6,48.8},{59.6,49.6},{60.4,48.2},{60.6,47.2},{60.8,46.4},{60.8,47.6}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4399] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{56.4,61.6},{57,52},{57.2,60.2},{57.2,62.4},{57.2,64.2},{57.4,51.2},{57.4,60.6},{57.6,51.2},{57.8,51.6},{58.4,52.8},{58.4,60.2},{58.4,60.6},{58.6,52.4},{58.6,60.6},{58.6,63.8},{58.8,60.4},{59,61.6},{59.2,65.2},{59.4,53.2},{59.4,53.8},{59.4,63.2},{59.8,52.6},{59.8,55},{59.8,56.2},{59.8,58.2},{59.8,62.4},{60,52.2},{60,58.8},{60.2,64.2},{60.4,53.6},{60.4,57.2},{60.4,62.6},{60.6,57.2},{60.6,57.6},{60.6,61.4},{60.6,61.6},{60.8,51.4},{60.8,52},{60.8,52.6},{60.8,65.4},{61,60.2},{61.4,53.8},{61.4,55.2},{61.4,55.6},{61.4,59},{61.4,63.4},{61.6,54.2},{61.6,55.2},{61.6,56.2},{61.6,57.6},{61.6,61.6},{61.6,63.2},{61.6,65},{61.8,60.8}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4400] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{53.4,46.8},{54.6,48.6},{56.8,60.2},{57,60.6},{57.2,51.2},{57.4,51.6},{57.4,62.2},{58,52},{58.2,51.4},{58.2,53},{58.2,60.6},{58.4,60.2},{58.6,60.4},{58.6,64.6},{59,51.4},{59.2,53},{59.2,53.8},{59.2,56.2},{59.2,62.2},{59.2,63},{59.4,52.2},{59.6,51.8},{59.6,56.4},{59.6,58.2},{59.8,54.4},{59.8,62.4},{59.8,62.8},{60,54.6},{60.2,51.4},{60.2,63.8},{60.4,52.6},{60.4,57},{60.4,61},{60.6,53.4},{60.6,57},{60.6,58},{60.6,61.8},{60.6,62.6},{60.8,52.4},{60.8,54.8},{60.8,60.4},{61,60.8},{61,65.6},{61.4,54.2},{61.4,55.8},{61.4,59.4},{61.4,65},{61.6,55.8},{61.6,56.8},{61.6,57.8},{61.6,65.4},{62,55.2},{62,63}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4405] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{53.4,64},{53.4,64.6},{54,64.2},{54.2,63.4},{54.4,62.4},{54.8,62.2},{54.8,62.6},{54.8,64.2},{55.4,61.4},{55.4,64.8},{55.6,61.2},{55.6,61.6},{55.6,64.8},{55.8,63},{55.8,64.2},{56.6,61.4},{56.6,62.4},{56.6,62.6},{56.6,63.6}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4413] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{42.72,13.85},{56.01,23.25}}},
        },
        [4479] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS]={{56.55,38.7},{54.8,38.2}}},
        },
        [4485] = { -- Belgrom Rockmaul
            [npcKeys.questStarts] = {1146,1361,2981,3504},
        },
        [4490] = {
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES]={{26,55.4},{26,55.6},{26.6,55.8},{26.8,55.4}}},
        },
        [4499] = {
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES]={{17.1,38.1},{10.6,23.1}}},
        },
        [4504] = {
            [npcKeys.zoneID] = zoneIDs.ALTERAC_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_MOUNTAINS] = {{37.51,67.2}}},
        },
        [4534] = {
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{-1,-1}}},
        },
        [4535] = {
            [npcKeys.zoneID] = zoneIDs.RAZORFEN_KRAUL,
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{-1,-1}}},
        },
        [4564] = { -- Luther Pickman
            [npcKeys.questStarts] = {},
        },
        [4565] = { -- Richard Kerwin
            [npcKeys.questStarts] = {},
        },
        [4582] = { -- Carolyn Ward
            [npcKeys.questStarts] = {6681},
        },
        [4583] = { -- Miles Dexter
            [npcKeys.questStarts] = {6681,8233},
        },
        [4584] = { -- Gregory Charles
            [npcKeys.questStarts] = {6681},
        },
        [4595] = { -- Baltus Fowler
            [npcKeys.questStarts] = {1718,1818,1823},
        },
        [4606] = { -- Aelthalyste
            [npcKeys.questStarts] = {5643,5657,5658,5679},
        },
        [4607] = { -- Father Lankester
            [npcKeys.questStarts] = {},
        },
        [4608] = { -- Father Lazarus
            [npcKeys.questStarts] = {},
        },
        [4643] = {
            [npcKeys.waypoints] = {},
        },
        [4660] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{39.65,61.37}}},
        },
        [4661] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{34.4,90.2},{34.8,83.2},{34.8,86},{35,84.6},{35.2,87.6},{35.2,88.8},{35.2,91.6},{35.4,82.2},{35.6,82.6},{36,81},{36,91.4},{36.4,80.2},{36.4,87},{36.4,91.6},{36.6,80.4},{36.6,87.2},{36.6,88},{37,84.6},{37.2,84.4},{37.4,81},{37.4,90.2},{37.8,87.6},{37.8,95.6},{38,85.2},{38,95},{38.2,84},{38.4,90.6},{38.4,92.4},{38.4,93.8},{38.4,97},{38.6,84.4},{38.6,91.2},{38.6,92.2},{38.6,96.4},{38.6,96.6},{38.8,85},{39,82.4},{39,86},{39,89.2},{39.2,87.4},{39.2,88},{39.2,93.4},{39.2,94.4},{39.4,82.8},{39.6,89.4},{39.6,95.2},{39.8,83.4},{40.2,84.2},{40.2,89.6},{40.4,84.6},{40.4,93.4},{40.6,86.8},{40.6,93.2},{40.8,88.8},{41,87.8}}},
        },
        [4686] = {
            [npcKeys.waypoints] = {[zoneIDs.DESOLACE]={{{30.1,8.8},{29.9,6.2},{27.9,6.4},{27.5,9.5},{27.9,12.3},{28.9,15.8},{29.9,18.5},{31.4,20},{31.1,22.4},{32,23.7},{33,24.3},{33.6,26.4},{33.8,29},{34.7,31.1},{36.7,32.8},{38,33.2},{40.3,33.4},{41.3,35.6},{42.2,37.5},{42.9,38.3},{43.9,40.2},{45,40.2},{46.5,38.3},{47.5,36.1},{48.6,33.8},{49.4,31.3},{50.1,28.6},{50.9,25.3},{52.1,22.2},{53.6,20},{55.8,19.5},{57.6,19.6},{59.2,20.8},{61.5,22.2},{63.6,22.9},{64.5,24.3},{65.4,25.5},{66.1,27.4},{66.1,29.9},{66.1,33},{65.3,36.3},{65.3,38.3},{65.8,42},{66.5,44.1},{67.1,46.6},{67.1,50.5},{66.6,54},{66.3,56.3},{65.9,59.5},{66.5,61.2},{66.7,62.9}},{{57.9,84.5},{59.3,82.6},{60.5,80.6},{59.9,76.9},{59.3,73.4},{60,70.9},{60.8,68.2},{61.7,65.9},{62.1,63.1},{61.7,59.1},{61.7,56.1},{60.9,53.4},{59.1,50.9},{56,48.6},{53.5,47.2},{51.2,46.2},{49.1,44.5},{48.1,41.8},{47.5,38.7},{47,34},{47.5,31.9},{47.5,29.2},{45.3,28.2},{43.4,28.4},{42,26.6},{41.2,24.1},{39.3,23.1},{37.8,24.5},{36.5,27.2},{36.1,29.4},{35.6,34},{34.7,36.1},{31.9,35.8},{30.4,35.8},{28.5,36.3},{27.1,39.1},{25.4,41.6},{24.5,44.1},{23.8,47},{23.1,49.5},{22.9,51.7},{22.5,54.2},{22.4,56.1}},{{43.3,57.5},{43.7,59.3},{43.9,61},{44,63.8},{43.1,65.7},{42.4,67.8},{42.1,69.8},{42.1,71.5},{43.5,74.6},{44,76.8},{44.4,78.7},{44.7,81.4},{43.9,83.2},{41.8,83.6},{39.6,81.8},{38.7,79.7},{37.3,77},{35.5,76.8},{34.6,78.7},{33.3,80.3},{32,81.4},{30.2,82},{28.1,82.4},{26,82.4},{24.2,83.2},{23.3,85.3},{21.9,88.2},{21.4,90.5}}}},
        },
        [4687] = {
            [npcKeys.waypoints] = {[zoneIDs.DESOLACE]={{{30.1,8.8},{29.9,6.2},{27.9,6.4},{27.5,9.5},{27.9,12.3},{28.9,15.8},{29.9,18.5},{31.4,20},{31.1,22.4},{32,23.7},{33,24.3},{33.6,26.4},{33.8,29},{34.7,31.1},{36.7,32.8},{38,33.2},{40.3,33.4},{41.3,35.6},{42.2,37.5},{42.9,38.3},{43.9,40.2},{45,40.2},{46.5,38.3},{47.5,36.1},{48.6,33.8},{49.4,31.3},{50.1,28.6},{50.9,25.3},{52.1,22.2},{53.6,20},{55.8,19.5},{57.6,19.6},{59.2,20.8},{61.5,22.2},{63.6,22.9},{64.5,24.3},{65.4,25.5},{66.1,27.4},{66.1,29.9},{66.1,33},{65.3,36.3},{65.3,38.3},{65.8,42},{66.5,44.1},{67.1,46.6},{67.1,50.5},{66.6,54},{66.3,56.3},{65.9,59.5},{66.5,61.2},{66.7,62.9}},{{57.9,84.5},{59.3,82.6},{60.5,80.6},{59.9,76.9},{59.3,73.4},{60,70.9},{60.8,68.2},{61.7,65.9},{62.1,63.1},{61.7,59.1},{61.7,56.1},{60.9,53.4},{59.1,50.9},{56,48.6},{53.5,47.2},{51.2,46.2},{49.1,44.5},{48.1,41.8},{47.5,38.7},{47,34},{47.5,31.9},{47.5,29.2},{45.3,28.2},{43.4,28.4},{42,26.6},{41.2,24.1},{39.3,23.1},{37.8,24.5},{36.5,27.2},{36.1,29.4},{35.6,34},{34.7,36.1},{31.9,35.8},{30.4,35.8},{28.5,36.3},{27.1,39.1},{25.4,41.6},{24.5,44.1},{23.8,47},{23.1,49.5},{22.9,51.7},{22.5,54.2},{22.4,56.1}},{{43.3,57.5},{43.7,59.3},{43.9,61},{44,63.8},{43.1,65.7},{42.4,67.8},{42.1,69.8},{42.1,71.5},{43.5,74.6},{44,76.8},{44.4,78.7},{44.7,81.4},{43.9,83.2},{41.8,83.6},{39.6,81.8},{38.7,79.7},{37.3,77},{35.5,76.8},{34.6,78.7},{33.3,80.3},{32,81.4},{30.2,82},{28.1,82.4},{26,82.4},{24.2,83.2},{23.3,85.3},{21.9,88.2},{21.4,90.5}}}},
        },
        [4730] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [4731] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [4802] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{13.55,12.06}}},
        },
        [4841] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{50.2,52.7}}},
            [npcKeys.waypoints] = {[zoneIDs.DUSTWALLOW_MARSH]={{{50.2,52.7},{48,53.3},{46.7,55.1},{46.8,57.4},{47.2,59.8},{48.8,59.4},{50.3,58.4},{51,56.3},{51.4,53.9},{50.2,52.7}}}},
        },
        [4844] = {
            [npcKeys.spawns] = {[zoneIDs.BADLANDS]={{43.8,10.6},{44.2,10},{44.4,9.4},{44.4,12.4},{44.6,9.6},{44.8,11.4},{44.8,12},{45.2,12.6},{45.4,8.4},{45.4,8.6},{45.8,8.6},{45.8,10.2},{46,10.6},{46,12.2},{46.2,13.8},{46.4,8.2},{46.4,12.6},{46.6,8},{46.6,11},{46.6,12.2},{47.2,13},{47.4,9.4},{47.4,9.8},{47.4,13.6},{47.6,7.8},{47.6,9.4},{47.6,12.4},{47.6,13},{47.6,13.6},{47.8,9.6},{48.2,7.2},{48.2,11},{48.6,7.6},{48.6,8.6},{48.6,9.6},{48.6,12},{48.6,13.6},{48.8,13},{49,11.4},{49.2,7.2},{49.6,7.8},{49.6,11},{49.6,11.8},{49.6,13.4},{50,13.8},{50.6,10.6},{50.6,13},{50.6,14.8},{53,16.2},{53.8,16.8}}},
        },
        [4846] = {
            [npcKeys.spawns] = {[zoneIDs.BADLANDS]={{43.8,10.8},{44.4,9.4},{44.4,9.6},{44.4,12.2},{44.6,12.4},{44.8,11.2},{45,12.6},{45.2,8.8},{45.2,10.2},{45.4,8.4},{45.6,8.4},{45.6,9.8},{45.8,8.6},{45.8,10.6},{45.8,13},{46,13.6},{46.4,12.2},{46.6,8.4},{46.6,10.8},{46.6,12.8},{46.8,12.4},{47.4,9.4},{47.4,10},{47.4,13.6},{47.6,12.6},{47.6,13.8},{47.8,7.6},{47.8,10},{47.8,12.2},{48,9},{48.2,7.4},{48.2,11.4},{48.6,9},{48.6,10.8},{48.6,12.6},{48.8,8.2},{48.8,11.6},{48.8,14},{49,7.2},{49.2,9.8},{49.6,7.4},{49.6,9.2},{49.6,11.4},{49.6,13.8},{49.8,8.2},{49.8,9.8},{50.2,11.8},{50.2,13},{50.6,8},{50.6,12.6},{50.8,11.4},{50.8,11.8},{50.8,13.8},{51,15.4},{51.4,26.8},{51.8,14.8},{52,16},{52,27.6},{52.6,19}}},
        },
        [4947] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{65.0,47.0},{67.2,51.0},{68.0,48.0}}},
        },
        [4967] = { -- Archmage Tervosh
            [npcKeys.questStarts] = {1266,7070},
        },
        [4968] = { -- Lady Jaina Proudmoore
            [npcKeys.questStarts] = {1267},
        },
        [4969] = {
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{69.89,44.9}}},
        },
        [4977] = {
            [npcKeys.zoneID] = zoneIDs.BLACKFATHOM_DEEPS,
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [5044] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{42.46,38.03}}},
        },
        [5045] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{42.48,38.06}}},
        },
        [5046] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{42.48,38.05}}},
        },
        [5082] = {
            [npcKeys.spawns] = {[zoneIDs.WETLANDS]={{10.8,60.4}}},
        },
        [5113] = { -- Kelv Sternhammer
            [npcKeys.questStarts] = {1698,1718,8417},
        },
        [5116] = { -- Olmin Burningbeard
            [npcKeys.questStarts] = {6721,8151},
        },
        [5117] = { -- Regnus Thundergranite
            [npcKeys.questStarts] = {},
        },
        [5141] = { -- Theodrus Frostbeard
            [npcKeys.questStarts] = {},
        },
        [5142] = { -- Braenna Flintcrag
            [npcKeys.questStarts] = {5633},
        },
        [5143] = { -- Toldren Deepiron
            [npcKeys.questStarts] = {},
        },
        [5144] = { -- Bink
            [npcKeys.questStarts] = {1880,1939,1953,2861},
        },
        [5145] = { -- Juli Stormkettle
            [npcKeys.questStarts] = {},
        },
        [5149] = {
            [npcKeys.questStarts] = {2999,3681,4486,7670,8415},
        },
        [5165] = { -- Hulfdan Blackbeard
            [npcKeys.questStarts] = {2238,2298,6681,8233},
        },
        [5166] = { -- Ormyr Flinteye
            [npcKeys.questStarts] = {6681},
        },
        [5167] = { -- Fenthwick
            [npcKeys.questStarts] = {6681},
        },
        [5171] = { -- Thistleheart
            [npcKeys.questStarts] = {},
        },
        [5172] = { -- Briarthorn
            [npcKeys.questStarts] = {4487,4736,4965,8419},
        },
        [5173] = { -- Alexander Calder
            [npcKeys.questStarts] = {},
        },
        [5299] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{53,32}}},
        },
        [5402] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{29.55,52}}},
        },
        [5477] = {
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS]={{54.9,34.1}}},
            [npcKeys.waypoints] = {[zoneIDs.SWAMP_OF_SORROWS]={{{54.9,34.1},{55.7,36.1},{55.7,37.7},{54.5,38.7},{52.9,38.7},{51.3,38.5},{49.7,38.5},{48.3,38.5},{47,38.5},{45.3,37.7},{43.9,36},{43.1,34},{42.9,32.1},{41.5,31.9},{40,33},{39.1,35.0},{38.3,36.9},{37.7,38.7},{37.7,40.8},{37.6,42.8},{37.2,44.5},{36.1,45.5},{34.7,45.1},{33.7,43.1},{33.2,40.6},{32.9,38.7},{32.3,36.1}}}},
        },
        [5489] = { -- Brother Joshua
            [npcKeys.questStarts] = {5631,8254},
        },
        [5491] = { -- Arthur the Faithful
            [npcKeys.questStarts] = {},
        },
        [5495] = { -- Ursula Deline
            [npcKeys.questStarts] = {},
        },
        [5496] = { -- Sandahl
            [npcKeys.questStarts] = {},
        },
        [5498] = { -- Elsharin
            [npcKeys.questStarts] = {},
        },
        [5504] = { -- Sheldras Moontree
            [npcKeys.questStarts] = {},
        },
        [5515] = { -- Einris Brightspear
            [npcKeys.questStarts] = {6073,6076},
        },
        [5516] = { -- Ulfir Ironbeard
            [npcKeys.questStarts] = {6074,8151},
        },
        [5543] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF]={{27.2,24.4}}},
            [npcKeys.waypoints] = {[zoneIDs.THUNDER_BLUFF]={{{27.2,24.4},{27.4,24.6},{28,25.2},{28.4,25.6},{28.4,26.8},{28.6,25.8},{28.6,26.6}}}},
        },
        [5600] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{73.2,41.8},{73.4,43},{74,43.6},{74.4,44.8},{73.6,46.6},{73,47.8},{74.6,48.8}}},
        },
        [5675] = { -- Carendin Halgar
            [npcKeys.questStarts] = {1471,1472,1473,1474,3001,65597},
            [npcKeys.questEnds] = {1471,1473,1474,1476,1478,65593,65597},
        },
        [5676] = {
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.spawns] = {
                [zoneIDs.UNDERCITY] = {{86.51,26.94}},
                [zoneIDs.STORMWIND_CITY] = {{25.16,77.49}},
                [zoneIDs.ORGRIMMAR] = {{49.66,50.14}},
            },
        },
        [5677] = {
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.spawns] = {
                [zoneIDs.UNDERCITY] = {{86.36,26.73}},
                [zoneIDs.STORMWIND_CITY] = {{25.2,77.52}},
                [zoneIDs.ORGRIMMAR] = {{49.73,50.14}},
            },
        },
        [5693] = { -- Godrick Farsan
            [npcKeys.questStarts] = {1476,65593},
        },
        [5720] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [5721] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [5762] = {
            [npcKeys.zoneID] = zoneIDs.WAILING_CAVERNS,
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{-1,-1}}},
        },
        [5763] = {
            [npcKeys.zoneID] = zoneIDs.WAILING_CAVERNS,
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{-1,-1}}},
        },
        [5797] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{46,70}}},
        },
        [5875] = { -- Gan'rul Bloodeye
            [npcKeys.questStarts] = {1501,1504,1507,1513,2996,65604},
            [npcKeys.questEnds] = {1501,1504,1506,1512,1513,65604,65610},
        },
        [5880] = { -- Un'Thuwa
            [npcKeys.questStarts] = {1884,1959},
        },
        [5881] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{56.82,74.86}}},
            [npcKeys.waypoints] = {[zoneIDs.FERALAS]={{{56.82,74.86},{55.89,74.64},{55.49,74.13},{54.89,73.44},{54.19,71.57},{54.14,67.96},{54.90,67.20},{55.87,67.93},{54.90,67.20},{54.14,67.96},{54.19,71.57},{54.89,73.44},{55.49,74.13},{55.89,74.64},{56.82,74.86}}}},
        },
        [5883] = { -- Enyo
            [npcKeys.questStarts] = {},
        },
        [5895] = {
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{38.65,44.58}}},
        },
        [5906] = { -- Xanis Flameweaver
            [npcKeys.questStarts] = {1523,1529,1532},
        },
        [5909] = { -- Cazul
            [npcKeys.questStarts] = {1508,65601},
        },
        [5952] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [5955] = {
            [npcKeys.spawns] = {[zoneIDs.TANARIS]={{29.48,60.51},{30,65},{30,70},{31.8,74.15}}}, -- #1462
        },
        [5982] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{46.2,18.4},{46.2,18.8},{46.4,20},{46.6,18.4},{46.8,19.4},{46.8,19.6},{50,18.6},{50.2,17.2},{50.2,17.8},{50.6,18.2},{54.4,36.2},{54.4,44},{54.6,36.2},{54.8,35.2},{54.8,44.4},{54.8,45.8},{55.2,36.6},{55.4,43.4},{55.8,36.6},{56.6,35.4},{56.6,36.2},{56.6,37.2},{57.6,28.4},{60.4,27},{60.4,42.1},{61.8,27.6},{62.4,26.6},{62.6,26.6}}},
        },
        [5988] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{43.4,26.4},{43.4,27},{43.8,26.2},{43.8,26.6},{44.2,19.8},{44.4,19.4},{44.4,22.4},{44.4,22.8},{44.4,24.4},{44.4,25.2},{44.4,28.2},{44.4,28.6},{44.4,29.8},{44.6,22.4},{44.6,22.6},{44.6,25.6},{44.6,27.4},{44.6,28.2},{44.6,28.6},{44.6,29.6},{44.8,24.4},{44.8,24.8},{45.4,18},{45.4,19},{45.4,20.4},{45.4,21},{45.6,19.2},{45.6,21},{45.8,17.4},{45.8,17.8},{46.2,22.6},{46.4,20.4},{46.4,22.4},{46.6,20.4},{46.6,20.6},{47,15.4},{47,16.4},{47,16.6},{47.2,18.6},{47.4,18},{47.4,22.2},{47.4,22.6},{47.4,23.6},{47.6,21.4},{47.6,23.6},{47.8,22.4},{47.8,23.4},{48,18.8},{48.2,17.4},{48.4,18},{48.4,19.6},{48.6,17.8},{48.6,19.4},{48.6,19.6},{48.8,23.8},{49.2,21.4},{49.4,16.4},{49.4,16.6},{49.4,22.2},{49.4,22.6},{49.6,16.4},{49.6,16.6},{49.6,17.8},{49.6,19},{49.6,19.8},{49.6,20.6},{49.6,22.4},{49.6,22.6},{49.6,23.8},{50,15.4},{50.4,28.2},{50.4,29},{50.6,28.2},{50.6,29.4},{50.8,27.4},{50.8,29.6},{51.6,27.8},{52,29},{52,29.6},{58.4,42},{58.4,42.8},{58.6,41.8},{59.2,35.4},{59.2,35.6},{59.2,37},{59.6,37.6},{60.2,35.8},{60.2,43.4},{60.4,35.4},{60.4,44.8}}},
        },
        [5993] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{44.4,32.4},{44.4,33.4},{44.4,34},{44.4,34.6},{44.4,36.4},{44.4,37.2},{44.4,37.6},{44.6,32.4},{44.6,33.4},{44.6,33.6},{44.6,37},{45,36.4},{45.4,35.4},{45.4,38.2},{45.4,38.6},{45.4,40.4},{45.4,41.2},{45.4,49.2},{45.4,52.2},{45.4,52.6},{45.6,35.4},{45.6,35.8},{45.6,37.2},{45.6,38.8},{45.6,48.8},{45.6,52.2},{45.8,34},{45.8,38},{45.8,48.2},{45.8,51.4},{46,40.8},{46.2,40.4},{46.2,50.2},{46.6,35.4},{46.6,35.8},{46.6,40},{46.6,40.6},{46.6,47.4},{46.6,48.2},{47,34.4},{47.2,49.2},{47.2,49.8},{47.4,37.2},{47.4,37.6},{47.4,38.6},{47.6,35.8},{47.6,37.2},{47.6,49.2},{47.8,35.4},{47.8,37.8},{48,34.4},{48,50.2},{48.2,38.6},{49,36.6},{49,38.2},{49.4,35.4},{49.4,35.8},{49.6,35.4},{49.6,35.8},{50.2,38.4},{50.2,38.6},{50.2,53.6},{50.4,36.6},{50.4,53.4},{50.6,36},{50.6,53.4},{50.6,53.6},{50.8,35.2},{51.2,39.6},{51.2,55.2},{51.2,55.6},{51.2,57.6},{51.4,37.4},{51.4,38.4},{51.4,38.6},{51.4,40.6},{51.6,55},{51.8,35.4},{51.8,38.8},{52,37.6},{52,39.6},{52.2,37.4},{52.2,53.4},{52.4,36.4},{52.4,41.2},{52.4,41.6},{52.4,54.4},{52.4,56.2},{52.4,56.6},{52.6,41.4},{52.6,53.4},{52.6,53.8},{52.6,55},{52.6,56},{52.6,56.6},{52.8,41.8},{52.8,52.4},{53,36.4},{53.4,37.2},{53.4,38.4},{53.4,38.8},{53.4,39.6},{53.4,42.6},{53.6,36.2},{53.6,37.4},{53.6,38.4},{53.6,38.6},{53.6,39.6},{54,35},{54.2,41.4},{54.2,41.6},{54.4,43.2},{54.4,43.6},{54.6,36.8},{54.6,39},{54.6,40.4},{54.6,41.4},{54.6,41.6},{54.6,43},{54.6,43.6},{54.8,44.8},{55.6,43.2}}},
        },
        [5994] = { -- Zayus
            [npcKeys.questStarts] = {},
        },
        [5996] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{72.4,4.21},{64.62,7.56},{68.73,9.35},{61.2,7.04},{63.04,8.78},{64.88,5.74},{63.95,4.74},{60.68,6.01},{66.65,11.02},{54.03,13.34},{69.92,6.61},{69.31,8.4},{59.8,4.56},{69.76,8.0},{54.72,5.44},{67.76,4.51},{71.85,5.59},{67.45,3.83},{63.85,10.0},{69.06,10.52},{70.98,5.47},{71.69,3.19},{66.84,2.99},{64.94,3.51},{71.7,9.77},{72.3,7.8},{70.45,12.01},{61.74,7.27},{68.02,9.28},{72.24,8.84},{64.26,5.45},{54.43,4.87},{58.3,14.61},{63.93,9.2},{58.39,14.62},{53.9,13.31},{71.34,6.42},{60.01,8.03},{57.92,10.77},{70.85,7.6},{63.33,9.71},{72.48,5.27},{66.73,9.79},{66.56,4.12},{58.74,3.37},{54.92,3.9},{66.59,8.11},{66.14,11.64},{65.89,10.59},{56.11,4.91},{72.36,9.67},{56.48,10.99},{57.51,12.88},{64.68,9.75},{58.14,3.81},{65.92,7.69},{62.29,8.65},{56.87,2.82},{57.62,4.39},{55.31,4.78},{72.89,8.21},{61.4,9.57},{73.19,4.7},{72.35,10.67},{55.75,11.05},{69.27,4.86},{60.9,4.0},{64.11,4.11},{57.92,11.76},{61.29,5.42},{70.35,8.3},{66.97,9.18},{61.42,8.33},{67.53,5.71},{69.44,2.91},{57.34,10.04},{61.58,4.27},{65.22,8.41},{59.88,6.96},{64.08,8.22},{69.96,4.74},{71.2,9.19},{57.11,11.48},{64.31,3.38},{55.15,11.18},{54.49,11.61},{54.5,10.4},{55.19,8.01},{55.36,9.5},{55.35,6.94},{57.11,6.96},{56.32,6.02},{57.47,6.15},{58.08,5.52},{65.21,5.11},{65.64,5.7},{66.05,4.63},{65.46,4.46},{66.94,2.37}}},
        },
        [5997] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{68.36,8.08},{61.49,3.16},{70.26,3.84},{63.68,3.44},{68.53,5.51},{69.02,6.37},{71.21,2.99},{62.65,4.72},{71.55,7.54},{70.24,9.02},{55.81,9.86},{56.16,7.82},{64.11,6.55}}},
        },
        [5998] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{71.4,5.0},{61.47,5.91},{71.65,8.84},{59.99,3.94},{70.12,10.94},{56.3,3.68},{71.53,6.61},{69.54,10.72},{56.19,3.05},{65.8,8.87},{63.43,6.71},{62.36,7.65},{53.94,11.75},{58.3,3.85}}},
        },
        [6014] = { -- X'yera
            [npcKeys.questStarts] = {},
        },
        [6018] = { -- Ur'kyo
            [npcKeys.questStarts] = {5646,5652,5662,5680,8254},
        },
        [6028] = {
            [npcKeys.npcFlags] = npcFlags.REPAIR
        },
        [6069] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{29.63,52.36}}},
        },
        [6070] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{29.56,52.05}}},
        },
        [6071] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{78.48,81.61}}},
        },
        [6122] = { -- Gakin the Darkbinder
            [npcKeys.questStarts] = {1688,1689,1716,1739,1798,65603},
            [npcKeys.questEnds] = {1685,1688,1689,1715,1717,1738,1739,65602,65603},
        },
        [6179] = { -- Tiza Battleforge
            [npcKeys.questStarts] = {1645,1647,1779,1789,1794,4485},
        },
        [6180] = {
            [npcKeys.zoneID] = zoneIDs.WESTFALL,
            [npcKeys.spawns] = {[zoneIDs.WESTFALL] = {{42.15,88.43}}},
        },
        [6215] = {
            [npcKeys.zoneID] = zoneIDs.GNOMEREGAN,
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [6238] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{68.61,48.72}}},
        },
        [6239] = {
            [npcKeys.zoneID] = zoneIDs.ALTERAC_MOUNTAINS,
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_MOUNTAINS] = {{80.32,62.14}}},
        },
        [6244] = { -- Takar the Seer
            [npcKeys.questStarts] = {1738,65602},
        },
        [6268] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{62.6,35.31}}},
        },
        [6390] = {
            [npcKeys.zoneID] = zoneIDs.TIRISFAL_GLADES,
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{59.47,48.28}}},
        },
        [6549] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{45.79,56.97}}},
        },
        [6550] = {
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{45.83,56.94}}},
        },
        [6575] = {
            [npcKeys.zoneID] = zoneIDs.SCARLET_MONASTERY,
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [6746] = { -- Innkeeper Pala
            [npcKeys.questStarts] = {3762,5926,8360},
        },
        [6866] = {
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{48.23,87.39}}},
        },
        [6911] = {
            [npcKeys.zoneID] = zoneIDs.TELDRASSIL,
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{37.46,23.71}}},
        },
        [6929] = { -- Innkeeper Gryshka
            [npcKeys.questStarts] = {936,5927,6385,8359},
        },
        [7091] = {
            [npcKeys.zoneID] = zoneIDs.ULDAMAN,
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{-1,-1}}},
        },
        [7135] = {
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{41.47,42.16},{43.69,39.06}}},
        },
        [7167] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{64.78,45.5}}},
        },
        [7228] = {
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{-1,-1}}},
        },
        [7273] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [7275] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [7276] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [7286] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [7311] = {
            [npcKeys.questStarts] = {1883,1953,1959,7068,8250},
        },
        [7312] = {
            [npcKeys.questStarts] = {1919,8250},
        },
        [7315] = { -- Darnath Bladesinger
            [npcKeys.questStarts] = {1698,8417},
        },
        [7319] = {
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL]={{39.4,25.4},{39.4,25.6},{39.6,25.4},{39.6,25.6},{41,25.6},{41.4,25.2},{42,25.4},{42,25.6},{46.2,24.4},{47.8,26.6},{48,25.2},{48,25.6},{48.6,24.6}}},
        },
        [7355] = {
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{-1,-1}}},
        },
        [7356] = {
            [npcKeys.zoneID] = zoneIDs.RAZORFEN_DOWNS,
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{-1,-1}}},
        },
        [7360] = {
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{30.85,55.78}}},
        },
        [7361] = {
            [npcKeys.zoneID] = zoneIDs.GNOMEREGAN,
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [7406] = { -- Oglethorpe Obnoticus
            [npcKeys.questStarts] = {3642,3643,3645,3721},
            [npcKeys.questEnds] = {648,836,2767,3635,3637,3642,3643,3645,3721,8857},
        },
        [7664] = {
            [npcKeys.zoneID] = zoneIDs.BLASTED_LANDS,
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{47.64,29.83}}},
        },
        [7729] = {
            [npcKeys.zoneID] = zoneIDs.BLASTED_LANDS,
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{68.8,31.07}}},
        },
        [7734] = {
            [npcKeys.zoneID] = zoneIDs.BLASTED_LANDS,
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{47.61,29.9}}},
        },
        [7735] = {
            [npcKeys.zoneID] = zoneIDs.BLASTED_LANDS,
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{47.63,30}}},
        },
        [7750] = {
            [npcKeys.zoneID] = zoneIDs.SWAMP_OF_SORROWS,
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS] = {{33.49,65.99}}},
        },
        [7767] = {
            [npcKeys.zoneID] = zoneIDs.THE_HINTERLANDS,
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{36.32,72.07},{39.53,66.65},{33.04,75.53}}},
        },
        [7768] = {
            [npcKeys.zoneID] = zoneIDs.THE_HINTERLANDS,
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{33.77,70.84},{35.45,65.62},{25.07,65.8}}},
        },
        [7789] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [7796] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [7805] = {
            [npcKeys.zoneID] = zoneIDs.TANARIS,
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{66.16,34.99}}},
        },
        [7808] = {
            [npcKeys.zoneID] = zoneIDs.THE_HINTERLANDS,
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{58.76,51.05}}},
        },
        [7809] = {
            [npcKeys.zoneID] = zoneIDs.THE_HINTERLANDS,
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{69.33,62.4}}},
        },
        [7848] = {
            [npcKeys.zoneID] = zoneIDs.FERALAS,
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{55.29,53.76}}},
        },
        [7899] = {
            [npcKeys.zoneID] = zoneIDs.TANARIS,
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{54.45,93.47}}},
        },
        [7901] = {
            [npcKeys.zoneID] = zoneIDs.TANARIS,
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{54.4,93.5}}},
        },
        [7902] = {
            [npcKeys.zoneID] = zoneIDs.TANARIS,
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{54.34,93.58}}},
        },
        [7918] = {
            [npcKeys.spawns] = {[zoneIDs.TANARIS]={{37.6,81.4}}},
            [npcKeys.zoneID] = zoneIDs.TANARIS,
        },
        [7937] = {
            [npcKeys.waypoints] = {}, -- the waypoints in the wotlkDB file are valid only during BREWFEST event
        },
        [7944] = { -- Tinkmaster Overspark
            [npcKeys.questStarts] = {2922,3640,3641,3647},
            [npcKeys.questEnds] = {2922,2923,3630,3632,3634,3640,3641,3647},
        },
        [7952] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [7955] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [8075] = {
            [npcKeys.zoneID] = zoneIDs.FERALAS,
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{40.55,8.6}}},
        },
        [8138] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [8142] = { -- Jannos Lighthoof
            [npcKeys.questStarts] = {},
        },
        [8179] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_FARRAK,
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [8257] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8336] = {
            [npcKeys.zoneID] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8337] = {
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{66.02,45.11}}},
        },
        [8391] = {
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{41.32,25.53}}},
        },
        [8392] = {
            [npcKeys.zoneID] = zoneIDs.AZSHARA,
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{77.81,91.4}}},
        },
        [8437] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8438] = {
            [npcKeys.zoneID] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8443] = { -- Avatar of Hakkar
            [npcKeys.zoneID] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8477] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [8497] = {
            [npcKeys.zoneID] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8516] = { -- Belnistrasz
            [npcKeys.questEnds] = {3523},
        },
        [8532] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{33.6,61.4},{33.8,63.6},{34,60.4},{34,62.4},{34,62.6},{34,64.8},{35.4,58},{35.4,59.2},{35.6,58.8},{35.8,57.6},{36,57},{36.2,56},{36.4,55},{36.8,50.8},{37,56.4},{37,56.6},{37.2,52.4},{37.2,53},{37.2,53.6},{37.2,54.6},{37.4,57.6},{37.6,55.2},{37.6,57.6},{37.8,56.6},{38,52},{38,56.4},{39.6,49.6},{39.8,49.2},{40.2,47},{40.6,48.8},{41.4,52},{41.8,52},{64.2,39.2},{64.4,38},{64.4,40.4},{64.4,40.6},{64.6,38.2},{64.8,37},{65,36.2},{65.2,39.4},{65.2,42},{65.4,35.4},{65.4,39.8},{65.4,41.2},{65.6,39.8},{66,36},{66,39.2},{66.2,41},{66.2,41.8},{66.6,38.6},{67,35.4},{67,40},{67,40.8},{67.4,35.8},{67.4,38.2},{67.4,41.6},{67.8,38.2},{67.8,40.4},{67.8,41.8},{68.2,40.8},{68.6,38.4},{68.6,38.6},{69,41},{69.4,39.8},{75.4,50.4},{75.4,50.6},{75.4,52},{75.4,52.8},{75.6,50.2},{75.8,51.8},{76.2,51},{76.4,48.4},{76.4,49},{76.4,52.8},{76.4,53.6},{76.6,48.6},{77.2,49.8},{77.2,52.4},{77.2,52.6},{77.4,47.4},{77.4,47.6},{77.4,50.8},{77.4,53.6},{77.4,54.6},{77.6,47},{77.6,47.6},{77.6,50.8},{77.6,54.4},{78,52.4},{78,52.6},{78.2,46},{78.2,55.6},{78.4,55.2},{78.6,45.6},{79,55.4},{79.2,44.8},{79.2,56},{79.4,44.4},{79.4,56.6},{79.6,44.6},{79.6,56.4},{79.6,56.8},{79.8,44.4},{80.4,43.4},{80.6,43.4},{80.6,43.6},{81.2,41.2},{81.4,41.8},{81.6,42.2},{81.6,43.4},{81.8,41},{81.8,43.6},{82.2,38.6},{82.4,38},{82.6,38},{82.6,40.4},{82.6,40.8},{84.4,37.8},{84.4,39},{84.4,40.2},{84.4,40.8},{84.4,43.2},{84.4,44.2},{84.4,45.2},{84.4,45.6},{84.6,39.4},{84.6,40.4},{84.6,40.6},{84.6,43.2},{84.6,44.4},{84.6,45.2},{84.6,45.6},{85,41.6},{86.4,43.4},{86.6,43.2},{86.8,44.6},{87,44.2}}},
            [npcKeys.waypoints] = {},
        },
        [8578] = {
            [npcKeys.zoneID] = zoneIDs.AZSHARA,
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{59.51,31.37}}},
        },
        [8580] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8888] = {
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{28.96,28.93}}},
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [8917] = {
            -- Quarry Slave (not inside BRD, but at the entrance and this is the best way to show him, since there is no map for inside Blackrock Mountain)
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8925] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8926] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8927] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8928] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8932] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8933] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8996] = {
            [npcKeys.zoneID] = zoneIDs.TANARIS,
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{59.3,37.95}}},
        },
        [9026] = {
            -- Overmaster Pyron (not inside BRD, but at the entrance and this is the best way to show him, since there is no map for inside Blackrock Mountain)
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9027] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9028] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9029] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9030] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9031] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9032] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9046] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_KINGDOMS] = {{49.119,64.098}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_KINGDOMS,
        },
        [9077] = {
            [npcKeys.waypoints] = {},
        },
        [9087] = { -- Bashana Runetotem
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [9136] = {
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{79.95,45.4}}},
        },
        [9166] = {
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER]={{42.8,85.4},{42.8,86},{43,90.8},{43.2,87},{43.4,90.2},{43.4,92.6},{43.6,90.2},{43.6,92.2},{43.6,92.6},{43.8,87.4},{44.2,88.4},{44.2,88.6},{44.4,90.6},{44.6,88.2},{44.6,90.4},{44.6,90.6},{50.4,10.4},{50.4,10.6},{50.4,12},{50.4,12.6},{50.4,87.2},{50.4,87.8},{50.4,89.4},{50.4,89.6},{50.6,10},{50.6,11.4},{50.6,12},{50.6,88},{50.6,89.4},{50.6,89.8},{56,9.8},{56.2,8.2},{56.2,88.2},{56.2,9},{56.4,11.4},{56.4,12.4},{56.4,12.6},{56.4,89.2},{56.4,90.2},{56.4,91.2},{56.4,91.6},{56.6,11.4},{56.6,89.4},{56.6,91.4},{56.8,12.4},{57,92.4},{57,92.6},{57.2,10.2},{57.2,12.6},{57.2,7.2},{57.2,90},{57.4,8.2},{57.4,8.6},{57.4,87.2},{57.4,87.6},{57.6,12.8},{57.6,87},{57.6,9.6},{57.6,90.4},{57.8,8.4},{57.8,90.8},{58,8.8},{58,86.4}}},
        },
        [9167] = {
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER]={{20.2,40},{20.4,60.2},{20.4,60.6},{21,40.2},{21,58.4},{21,58.8},{21,60.4},{21.2,38.8},{21.2,41},{21.4,61},{21.8,61},{22,40.4},{22,60},{22.2,41},{22.2,50.2},{22.4,59.4},{22.8,58.4},{22.8,58.6},{23,50},{23.2,41},{23.4,40.2},{23.4,49.4},{23.4,50.6},{23.4,59.8},{23.6,40.2},{23.6,41.6},{23.6,49.4},{23.6,50},{23.6,58.2},{23.8,59},{23.8,60},{24,39},{24.4,38.2},{24.4,61.4},{24.4,61.6},{24.6,61.4},{24.8,61.6},{25,38.4},{25,38.8},{25,41.6},{25.2,43},{25.4,39.8},{25.6,39},{25.6,43},{26.2,63.4},{26.2,64.2},{26.2,64.6},{26.4,37.2},{26.4,38.4},{26.6,64.4},{26.6,64.6},{26.8,38.2},{27,44.4},{27.2,33.8},{27.2,39.4},{27.2,39.6},{27.4,34.6},{27.4,45.2},{27.4,45.6},{27.4,54.4},{27.6,39.6},{27.6,45.4},{27.6,54.8},{27.8,46},{27.8,54.2},{27.8,56.6},{28.2,30},{28.2,41},{28.4,41.6},{28.8,41.2},{28.8,47.2},{29,47.6},{29.2,36.8},{29.2,42.4},{29.4,31.8},{29.4,32.6},{29.4,42.6},{29.6,31.8},{29.6,42.2},{29.8,31.4},{30.4,44.6},{30.6,28.4},{30.6,44.8},{30.8,29.2},{30.8,46},{31,33.4},{31,34.2},{31.2,70.8},{31.4,44.4},{31.4,71.6},{31.6,44.6},{31.6,71.4},{31.6,71.6},{31.8,44},{32.2,66.8},{32.2,67.6},{32.4,26},{32.4,37.4},{32.4,42},{32.4,43.4},{32.4,78.4},{32.4,78.8},{32.6,26},{32.6,37.6},{32.6,42},{32.6,78.2},{32.6,79},{32.8,37},{32.8,42.6},{33.2,32},{33.8,44.4},{34.2,29.4},{34.4,29.6},{34.4,30.6},{34.4,39.8},{34.6,29.6},{34.6,30.6},{34.6,45.6},{34.6,65},{34.6,65.6},{34.8,29.4},{34.8,39.6},{34.8,44.6},{35,39.4},{35,44.4},{35.4,34.8},{35.8,34.4},{35.8,35.2},{35.8,35.6},{36,31.4},{36,32.8},{36,36.6},{36.2,32.4},{36.2,42.2},{36.4,26.4},{36.4,26.8},{36.4,42.6},{36.4,63.4},{36.4,70.6},{36.4,76.4},{36.4,76.8},{36.4,79.2},{36.4,79.6},{36.6,26.4},{36.6,26.6},{36.6,63},{36.6,76.4},{36.6,79.4},{36.6,79.8},{36.8,76.6},{37.2,41.6},{37.4,40.4},{37.4,40.8},{37.6,40},{37.6,40.6},{37.8,34.4},{37.8,35.2},{37.8,39.2},{38,38.2},{38,45.6},{38.2,29.2},{38.4,37.4},{38.4,50.4},{38.6,50.8},{38.8,29.2},{38.8,29.6},{39,19.4},{39,49.4},{39,50},{39.4,19.8},{39.4,44.4},{39.6,42.2},{39.6,45},{39.6,68.4},{39.8,68.6},{40,65.6},{40,76.6},{40.2,31.4},{40.2,31.6},{40.2,48.2},{40.2,48.8},{40.2,76.2},{40.4,37.8},{40.4,65.4},{40.8,64.4},{41,64.8},{41.2,28.6},{41.2,52.4},{41.2,52.6},{41.4,28.4},{41.4,39},{41.6,28.4},{41.6,28.6},{41.6,39.4},{41.8,39.8},{41.8,53.2},{42.2,36.8},{42.4,30.4},{42.4,30.8},{42.4,36.4},{42.6,30.6},{42.6,36.4}}},
        },
        [9396] = {
            [npcKeys.zoneID] = zoneIDs.TANARIS,
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{50.03,30.57},{56.45,25.44},{56.69,32.35},{48.71,27.81},{44.84,27.89}}},
        },
        [9398] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9438] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9439] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9441] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9442] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9443] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9445] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9453] = {
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{70.4,49.9}}},
        },
        [9456] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{44.53,28.15}}},
        },
        [9461] = {
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES]={{94.4,31.8}}},
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [9465] = { -- Golhine the Hooded
            [npcKeys.questStarts] = {},
        },
        [9476] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9477] = {
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{56.3,63.89},{46.45,25.45},{45.44,66.04},{56.2,18.13},{59.39,60.37}}},
        },
        [9522] = {
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{33.22,51.02},{42.84,41.59}}},
        },
        [9523] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{44.55,27.78}}},
        },
        [9524] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{44.62,27.75}}},
        },
        [9528] = { -- Arathandris Silversky
            [npcKeys.questStarts] = {4101,4103,4104,4105,4106,4107,5882,5883,5884,5885,5886},
            [npcKeys.questEnds] = {4101,4103,4104,4105,4106,4107,5882,5883,5884,5885,5886},
        },
        [9529] = { -- Maybess Riverbreeze
            [npcKeys.questStarts] = {4102,4108,4109,4110,4111,4112,5887,5888,5889,5890,5891},
            [npcKeys.questEnds] = {4102,4108,4109,4110,4111,4112,5887,5888,5889,5890,5891},
        },
        [9537] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9541] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9598] = {
            [npcKeys.spawns] = {[zoneIDs.FELWOOD]={{49.57,29.60}}}, -- #1516
            [npcKeys.zoneID] = zoneIDs.FELWOOD, -- #1516
        },
        [9621] = {
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{46.27,25.21},{56.83,69.68},{56.61,18.16},{56.77,63.03},{51.99,17.82}}},
        },
        [9683] = {
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER]={{58,78},{60,72},{62,65},{62,80},{63,77},{66,62},{66,66},{67,60},{67,73},{67,67},{70,60},{71,59}}},
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
        },
        [9684] = {
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{79.65,49.83}}},
        },
        [9916] = {
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS]={{91.2,65.4},{91.2,68.8},{91.4,67},{91.6,64.4},{91.8,67.6},{92,65.2},{92.4,62},{93,53.2},{93,61.8},{93.4,51.6},{93.6,63.8},{93.8,51.4},{94.2,59.6},{94.4,51.8},{95,52.6},{95.2,51.2}}},
        },
        [10040] = {
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{43.89,81.33}}},
        },
        [10041] = {
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{43.85,81.39}}},
        },
        [10182] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{54,2}}},
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
        },
        [10258] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10263] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10264] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10268] = {
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10296] = { -- Vaelan
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE]={{-1, -1}}},
            [npcKeys.questStarts] = {},
            [npcKeys.questEnds] = {},
        },
        [10299] = { -- Scarshield Infiltrator
            [npcKeys.questStarts] = {4742,4743},
            [npcKeys.questEnds] = {4742,4743},
        },
        [10323] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{36.44,76.51}}},
        },
        [10339] = {
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10373] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{52.48,33.39}}},
        },
        [10383] = {
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [10389] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [10394] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [10429] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10439] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [10441] = {
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [10447] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10506] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [10541] = {
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER]={{49,45}}}, -- #2055
        },
        [10584] = {
            [npcKeys.zoneID] = zoneIDs.LOWER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10665] = {
            [npcKeys.waypoints] = {[zoneIDs.TIRISFAL_GLADES]={{{57.4,48.8},{57.6,49},{57.8,49.6},{58.4,47.8},{58.6,47.6},{59,47.2}}}},
        },
        [10680] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10681] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10682] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [10683] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10717] = {
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS]={{45.15,62.28},{45.21,62.83},{46.38,62.33},{46.69,62.08},{47.03,61.96},{47.21,65.86},{47.76,66.51},{47.83,63.45},{47.92,65.91},{48.23,64.39},{48.26,65.77},{48.45,62.81},{48.57,63.98},{49.02,69.3},{49.1,68.86},{49.4,68.84},{49.95,66.1},{50.15,66.77},{50.2,66.34},{50.31,67.23}}},
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
        },
        [10737] = {
            [npcKeys.zoneID] = zoneIDs.WINTERSPRING,
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{49.81,9.8}}},
        },
        [10740] = {
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
        },
        [10741] = {
            [npcKeys.zoneID] = zoneIDs.WINTERSPRING,
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{49.85,9.8}}},
        },
        [10742] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10776] = {
            [npcKeys.name] = "Pip Quickwit",
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10800] = {
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [10801] = {
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS]={{36.2,56.6},{36.6,57.6},{37,57.2},{37.2,55.4},{37.4,55.6},{37.8,57.6},{38,56.4},{38,56.6},{38.4,55.4},{38.6,55.2},{38.6,56.2}}},
        },
        [10806] = {
            [npcKeys.waypoints] = {[zoneIDs.WINTERSPRING]={{{54.2,34.0},{54.8,35.4},{56.0,32.6},{56.2,29.8},{56.4,36.4},{57.2,31.4},{57.4,33.6},{57.6,27.8},{58.0,35.6},{58.2,30.0},{58.8,36.8},{59.0,38.6},{59.2,23.4},{59.2,32.4},{59.4,34.6},{60.0,21.6},{60.0,36.0},{60.4,33.4},{60.8,28.8},{61.0,24.6},{61.0,31.4},{61.2,27.0},{61.2,38.6},{61.4,23.0},{61.6,34.8},{62.2,21.2},{62.2,29.8},{62.4,33.6},{62.6,36.4},{63.4,24.4},{63.6,26.4},{63.6,31.4},{63.8,28.2},{64.0,20.8},{64.6,22.8},{64.6,33.6},{65.2,25.8},{65.2,29.0},{65.6,27.4},{65.8,32.2},{67.4,26.0}}}},
        },
        [10807] = {
            [npcKeys.waypoints] = {[zoneIDs.WINTERSPRING]={{{58,62.1},{59.9,61.5},{61.6,61.5},{62.1,59},{62.6,57.2},{60.3,55.9},{58.4,54.7},{56.3,52.6},{55,50.2},{54.2,47.3},{54.2,44.8}}}},
        },
        [10808] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [10813] = {
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME]={{-1,-1}}},
        },
        [10836] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{48.23,49.67}}},
        },
        [10837] = { -- High Executor Derrington
            [npcKeys.questStarts] = {105,838,5096,5098,5228,5238,5511},
            [npcKeys.questEnds] = {105,5093,5094,5095,5096,5098,5238,5511},
        },
        [10838] = { -- Commander Ashlam Valorfist
            [npcKeys.questStarts] = {211,5092,5097,5215,5237,5533,8414,8418},
            [npcKeys.questEnds] = {211,5066,5090,5091,5092,5097,5237,8415,8416,8418},
        },
        [10839] = { -- Argent Officer Garush
            [npcKeys.questStarts] = {5406,5407,5408,5503},
        },
        [10877] = { -- Courier Hammerfall
            [npcKeys.questStarts] = {1019,5090,7494},
        },
        [10879] = { -- Harbinger Balthazad
            [npcKeys.questStarts] = {1004,5094,7492},
        },
        [10881] = { -- Bluff Runner Windstrider
            [npcKeys.waypoints] = {[zoneIDs.THUNDER_BLUFF]={{{40.37,52.75},{39.98,52.21},{39.27,51.59},{38.39,50.86},{37.75,51.18},{36.93,51.93},{36.48,52.97},{36.25,54.09},{36.34,54.78},{36.6,55.84},{36.77,56.94},{37.01,58.12},{37.19,59.38},{37.36,60.36},{37.63,61.36},{38.28,62.12},{38.89,62.84},{39.45,63.19},{40.15,62.98},{40.63,62.33},{41.32,61.33},{42.3,59.92},{42.59,59.32},{43.2,60.1},{43.5,64.6},{44.7,68.8},{46,69.4},{48.7,67.2},{49.4,65.4},{49.7,62.4},{52.2,61.6},{56.6,61.6},{57,59.4},{56.1,54.7},{57.8,54.3},{59,52.5},{58.9,50.1},{57.8,48.5},{56.1,47.9},{54.1,48.7},{52.9,50.7},{53.1,52.6},{54.3,54.1},{56.1,54.7},{57,59.4},{56.6,61.6},{52.2,61.6},{49.7,62.4},{49.4,65.4},{48.7,67.2},{46,69.4},{44.7,68.8},{43.5,64.6},{43.2,60.1},{42.59,59.32},{42.74,58.43},{42.98,56.87},{42.56,56.13},{42.18,55.5},{41.56,54.53},{40.96,53.61}}}},
            [npcKeys.questStarts] = {742,1000,5095,7492},
        },
        [10882] = {
            [npcKeys.zoneID] = zoneIDs.THOUSAND_NEEDLES,
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{38.09,35.38}}},
        },
        [10928] = {
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{28.54,82.09}}},
        },
        [10936] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{39.2,91.33}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [10946] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{38.44,89.3}}},
        },
        [10979] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{40.53,52.51},{51.73,44.27},{47.18,51.36},{38.94,55.98},{43.48,67.57}}},
        },
        [10996] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {
                [zoneIDs.WESTERN_PLAGUELANDS] = {{63.32,58.06},{68.93,74.74},{45.07,71.39},{67.97,84.26}},
                [zoneIDs.EASTERN_PLAGUELANDS] = {{58.2,79.97}},
            },
        },
        [11018] = {
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{36.88,54.9}}},
        },
        [11039] = { -- Duke Nicholas Zverenhoff
            [npcKeys.questStarts] = {5251,5263,5264,5405,5508,5509,5510},
        },
        [11058] = {
            [npcKeys.name] = "Ezra Grimm",
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [11064] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{22.44,18.67},{31.11,31.31},{22.31,21.42},{42.07,33.01},{26.39,32.55},{32.6,34.31},{25.62,37.1},{41.25,26.57},{37.3,33.07},{25.17,33.06},{18.55,34.25},{30.97,34.74},{16.7,30.89},{17.82,32.15},{17.51,31.25},{37.96,36.62},{36.25,33.69},{38.58,35.51},{37.08,23.7},{43.38,22.26},{41.19,21.25},{28.2,30.19},{27.31,26.57},{16.65,30.44},{14.21,32.44},{42.03,24.93},{42.68,28.09},{36.42,22.74},{35.18,29.22},{36.9,29.43},{25.74,31.74},{59.31,68.96},{60.41,65.08},{60.14,73.59},{60.92,72.98},{62.2,67.82},{61.21,66.96},{61.92,65.38},{58.41,72.95},{39.81,49.77},{39.57,51.99},{65.41,40.77},{67.13,40.84},{65.54,39.75},{65.48,38.28},{65.97,35.93},{64.39,39.2},{64.67,38.32},{67.16,39.85},{31.8,63.87},{37.27,53.59},{33.97,63.71},{37.51,57.4},{38.18,56.21},{75.59,50.88},{81.76,42.06},{85.17,41.86},{81.89,43.97},{37.04,56.69},{79.2,56.16},{77.51,47.36}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [11075] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{36.93,57.41}}},
        },
        [11076] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{52.88,66.08}}},
        },
        [11077] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{46.11,52.61}}},
        },
        [11078] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{62.18,59.06}}},
        },
        [11120] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [11121] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [11122] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}}, -- #919
        },
        [11136] = {
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [11142] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [11143] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [11190] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [11284] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{69.01,72.8}}},
        },
        [11401] = { -- Priestess Alathea
            [npcKeys.questStarts] = {5627,5640,5647,5672,5678},
        },
        [11406] = { -- High Priest Rohan
            [npcKeys.questStarts] = {5639,5641,5675,5677,7639,8254},
        },
        [11407] = { -- Var'jun
            [npcKeys.questStarts] = {5655,5661},
        },
        [11460] = {
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [11498] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{62.5,30.37}}},
        },
        [11502] = {
            [npcKeys.zoneID] = zoneIDs.MOLTEN_CORE,
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_CORE] = {{-1,-1}}},
        },
        [11560] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{64.18,91.63}}},
        },
        [11583] = {
            [npcKeys.zoneID] = zoneIDs.BLACKWING_LAIR,
            [npcKeys.spawns] = {[zoneIDs.BLACKWING_LAIR] = {{-1,-1}}},
        },
        [11598] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [11602] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.43,4.59},{50.95,5.24},{49.85,5.68},{52.94,6.21},{51.21,6.28},{52.35,6.61},{51.65,7.12},{50.1,7.41},{51.52,7.46},{51.29,7.69},{52.41,8.03},{50.59,8.28},{50.23,8.44},{51.99,8.61},{50.8,8.75},{52.83,9.15},{49.64,9.2},{52.5,7.71},{52.77,4.54},{49.74,4.79},{50.45,5.26},{51.93,5.63},{53.27,6.49},{50.03,6.65},{51.48,7.22},{51.9,7.34},{51.38,8.07},{51.36,8.1},{51.25,8.3},{51.22,8.97},{51.93,9.13},{50.28,9.17},{52.79,9.47},{49.73,9.79}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [11625] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{66.54,37.51}}},
        },
        [11626] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{45.4,75.29}}},
            [npcKeys.waypoints] = {[zoneIDs.DESOLACE]={{{66.77,58.12},{66.9,57.7},{67.03,57.27},{67.37,56.11},{67.33,55.65},{67.29,55.19},{67.3,54.71},{67.56,54.14},{67.64,53.62},{67.68,52.69},{67.71,52.23},{67.78,50.8},{67.84,49.68},{67.96,48.29},{67.9,47.83},{67.87,46.86},{67.86,46.28},{67.86,45.82},{67.83,44.42},{67.82,43.73},{67.91,42.71},{68,41.76},{67.66,40.33},{67.29,39.49},{67.16,39.07},{67.03,38.64},{66.84,38.09},{66.64,37.73},{66.42,37.14},{66.18,36.28},{65.92,35.58},{65.81,35.1},{65.75,34.64},{65.53,33.3},{65.24,33.13},{64.95,32.96},{64.38,32.6},{64,32.39},{63.12,32.32},{62.22,32.39},{61.99,32.61},{61.62,33.21},{61.44,33.68},{61.28,34.58},{61.23,35.04},{61,36.16},{60.84,36.57},{60.17,37.48},{59.34,37.97},{59.3,39.18},{59.44,40.11},{60.04,39.76},{60.26,38.88},{60.33,38.6},{60.38,38.36},{60.44,38.09},{60.66,36.89},{60.76,36.67},{60.99,36.11},{61.17,35.22},{61.32,34.31},{61.44,33.66},{61.58,33.34},{61.91,32.74},{62.27,32.35},{62.89,32.36},{63.52,32.36},{64.12,32.47},{64.7,32.81},{64.98,33.01},{65.6,33.49},{65.72,34.36},{65.76,34.83},{65.89,35.49},{66.05,35.89},{66.36,36.87},{66.48,37.31},{66.76,37.92},{66.9,38.23},{67.03,38.65},{67.29,39.5},{67.36,39.71},{67.61,40.24},{67.75,40.65},{67.98,41.52},{68.01,41.85},{67.94,42.49},{67.87,42.95},{67.81,43.4},{67.8,43.81},{67.84,44.74},{67.86,45.21},{67.87,46.14},{67.87,46.61},{67.87,47.07},{67.85,47.58},{67.96,48.49},{67.97,48.83},{67.86,49.54},{67.77,50.89},{67.75,51.83},{67.69,52.76},{67.64,53.57},{67.6,54},{67.39,54.6},{67.29,55.16},{67.37,55.96},{67.32,56.29},{67.06,57.14},{66.81,58},{66.73,58.67},{66.72,59.49},{66.86,60.11},{67.19,61.42},{67.42,62.31},{67.54,62.59},{67.73,63.42},{67.77,64.27},{67.71,64.84},{67.51,65.21},{67.26,65.52},{66.88,65.79},{66.5,65.87},{66.19,65.81},{65.84,65.73},{65.45,65.65},{65.11,65.61},{64.61,65.5},{64.32,65.31},{63.75,64.93},{63.18,64.64},{62.87,64.63},{62.25,64.7},{61.94,64.76},{61.48,64.77},{61.19,64.57},{60.64,64.16},{60.36,63.95},{59.8,63.52},{58.91,63.21},{58.33,63.54},{57.65,63.92},{57.52,64.28},{57.28,65.14},{56.97,65.84},{56.53,66.49},{56.31,66.82},{55.87,67.5},{55.48,68.22},{55.06,68.89},{54.56,69.46},{54.05,69.98},{53.53,70.51},{52.83,71.17},{52.41,71.33},{51.92,71.52},{51.72,71.77},{51.55,72.35},{51.51,73.05},{51.48,73.69},{51.31,74.21},{51.02,74.85},{50.75,75.21},{50.48,75.45},{50.19,75.63},{49.48,75.71},{48.95,75.89},{48.74,75.85},{48.15,75.56},{47.84,75.47},{47.54,75.35},{47.19,75.19},{47.19,75.19},{46.54,75.17},{46.54,75.17},{46.23,75.2},{45.6,75.22},{45.07,75.4},{44.79,75.88},{44.5,76.35},{44.22,76.57},{43.74,76.61},{43.43,76.67},{43.13,76.79},{42.64,77.28},{42.39,77.55},{41.96,77.96},{41.79,78.03},{41.24,78.25},{40.96,78.46},{40.75,78.59},{40.03,78.25},{39.69,79.27},{40.44,79.89},{40.5,79.68},{40.58,79.39},{40.64,79.15},{41.32,78.19},{41.96,77.97},{42.13,77.83},{42.63,77.27},{43,76.88},{43.27,76.69},{43.8,76.6},{44.27,76.54},{44.39,76.46},{44.64,76.14},{45.02,75.46},{45.36,75.22},{45.67,75.14},{45.98,75.13},{46.36,75.18},{46.68,75.16},{47.23,75.2},{47.53,75.32},{47.83,75.43},{48.13,75.54},{48.43,75.68},{48.96,75.89},{49.07,75.88},{49.6,75.64},{50.05,75.6},{50.41,75.52},{50.75,75.23},{50.97,74.9},{51.3,74.32},{51.48,73.79},{51.52,73.52},{51.52,73.05},{51.57,72.19},{51.65,71.84},{51.81,71.59},{52.2,71.36},{52.51,71.26},{53.12,70.89},{53.64,70.37},{53.89,70.11},{54.41,69.59},{54.67,69.33},{55.22,68.64},{55.42,68.28},{55.81,67.56},{56.25,66.9},{56.48,66.57},{56.9,65.89},{57.24,65.28},{57.41,64.78},{57.81,63.79},{58.1,63.55},{58.61,63.34},{59.17,63.14},{59.6,63.31},{59.88,63.51},{60.15,63.73},{60.7,64.17},{60.98,64.38},{61.54,64.78},{61.79,64.84},{62.41,64.72},{62.72,64.66},{63.28,64.7},{63.58,64.84},{64.15,65.21},{64.43,65.4},{64.64,65.5},{64.93,65.58},{65.24,65.61},{65.55,65.65},{65.86,65.73},{66.47,65.89},{66.7,65.87},{66.99,65.71},{67.29,65.51},{67.55,65.16},{67.72,64.81},{67.79,64.31},{67.74,63.53},{67.61,62.89},{67.39,62.26},{67.17,61.39},{67.07,60.95},{66.88,60.06},{66.75,59.09}}}},
        },
        [11627] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{51.41,58.29},{49.45,59.73},{52.42,62.2},{53.94,60.99},{52.61,57.46},{50.51,56.63},{48.29,60.25},{52.24,60.64},{50.82,61.17},{53.65,56.69},{51.95,56.1},{58.03,34.84},{58.63,34.44},{58.93,34.32},{49.36,41.23},{49.37,40.48},{49.37,40.17},{57.76,71.05},{56.74,82.06},{56.79,82.99},{56.94,82.97},{51.47,59.16},{47.0,58.86},{48.52,56.9},{53.65,58.03},{49.13,55.62},{49.57,58.32},{46.48,60.66},{50.3,58.31},{54.97,58.23},{54.27,63.24},{58.42,34.24},{55.68,62.65},{49.49,40.82},{54.2,61},{60.4,62},{60.6,62}}},
        },
        [11663] = {
            [npcKeys.zoneID] = zoneIDs.MOLTEN_CORE,
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_CORE] = {{-1,-1}}},
        },
        [11664] = {
            [npcKeys.zoneID] = zoneIDs.MOLTEN_CORE,
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_CORE] = {{-1,-1}}},
        },
        [11686] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{28.5,63.06}}},
        },
        [11687] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{28.5,63.05}}},
        },
        [11688] = {
            [npcKeys.waypoints] = {},
        },
        [11714] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{45.84,90.41}}},
        },
        [11744] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS]={{17,25.8},{17,28},{17.4,24.4},{17.4,24.8},{17.4,26.8},{17.4,28.8},{17.4,29.8},{17.6,27},{17.6,28.6},{17.8,24},{17.8,29.6},{18.2,23.2},{18.2,31.2},{18.2,32.4},{18.2,32.6},{18.4,20.4},{18.4,21},{18.4,22.2},{18.4,25.2},{18.4,25.6},{18.4,28.4},{18.6,22.6},{18.6,24.2},{18.6,25.4},{18.6,25.6},{18.6,28.4},{18.6,28.6},{18.8,22.4},{19,19.8},{19,26.6},{19,29.6},{19,32.2},{19.2,19.4},{19.4,18.4},{19.4,21.4},{19.4,32.6},{19.6,19.6},{19.6,21.4},{19.8,18.4},{19.8,18.6},{19.8,22.6},{19.8,26.8},{19.8,32.4},{19.8,32.6},{20,30},{20.2,21.8},{20.2,31.4},{20.4,17.4},{20.4,24},{20.4,24.8},{20.4,26.2},{20.4,28.4},{20.4,28.6},{20.6,17.4},{20.6,17.6},{20.6,18.6},{20.6,22.4},{20.6,28.4},{20.6,29.4},{20.6,31.2},{20.6,31.8},{20.8,24},{20.8,25.6},{20.8,29.6},{21.4,20},{21.4,21.4},{21.4,22.8},{21.4,25.4},{21.4,26.8},{21.6,20.4},{21.6,21.4},{21.6,22.4},{21.6,25.6},{21.6,26.8},{21.6,29.6},{21.6,30.6},{21.8,24},{22,28.8},{22.2,22.8},{22.4,25},{22.4,28.2},{22.6,23.4},{22.6,24},{22.6,25.2},{22.6,26.4},{22.6,28.2},{22.6,28.6},{23.4,27.2},{23.6,27.2},{23.6,27.6},{27.8,18.4},{28.4,15},{28.4,16.4},{28.4,16.8},{28.4,19.2},{28.4,20},{28.4,22},{28.4,22.8},{28.6,17},{28.6,20},{28.6,22.6},{29.2,14.2},{29.2,18},{29.2,18.6},{29.4,13.4},{29.4,15.4},{29.4,15.6},{29.4,21.2},{29.4,21.6},{29.6,13.4},{29.6,21},{29.6,21.6},{29.6,22.6},{29.8,15.4},{30,14.2},{30.2,15.6},{30.2,16.8},{30.2,18.2},{30.2,19.4},{30.2,19.6},{30.6,19.6},{31,15.4},{31,15.8},{31.2,17.2},{31.2,18.2},{31.2,18.6},{31.4,14.4},{31.6,18.6},{31.8,16.8},{31.8,17.8},{32.2,13.4},{32.2,14},{32.2,16.4},{32.4,14.8},{32.6,16.8},{33,14.2},{33,15.4},{33,15.6},{33.2,12.8},{33.4,12.4},{33.6,15},{33.6,15.8},{33.6,16.8},{34,12.4},{34,13},{34,14},{34.6,13.6},{34.8,12.4},{34.8,12.6},{35.6,13}}},
        },
        [11746] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS]={{18.4,16.8},{18.8,17},{19.4,16.4},{19.8,15.4},{19.8,15.6},{20.4,12.2},{20.4,13.4},{20.4,14},{20.4,16.8},{20.4,17.8},{20.6,13.8},{20.6,16.4},{20.6,16.8},{20.8,15.2},{21,11.4},{21,11.6},{21.2,10.4},{21.2,12.8},{21.4,18},{21.4,9.4},{21.8,12.8},{21.8,15.2},{21.8,18.2},{21.8,9.8},{22,20},{22.2,11.4},{22.2,11.6},{22.4,14.2},{22.4,15.6},{22.4,17},{22.4,18.6},{22.4,8.4},{22.4,8.6},{22.6,11.2},{22.6,12.2},{22.6,12.8},{22.6,14.2},{22.6,15.8},{22.6,17},{22.6,19.6},{22.6,8.4},{22.6,8.6},{22.8,19.2},{23.2,17.8},{23.4,10},{23.4,15.2},{23.6,10},{23.6,15},{24.4,11.8},{24.4,11},{24.4,12.6},{24.4,14},{24.6,11},{24.6,13.8},{25.2,10},{25.4,12.4},{25.4,12.6},{25.4,15.2},{25.6,10.4},{25.6,12.4},{25.6,12.6},{25.6,15},{26.4,11.2},{26.4,13.8},{26.6,11.2},{26.6,11.6},{26.6,13.4},{26.6,13.8},{27.2,15.2},{27.6,12},{27.8,14.6},{28,12.6},{28.2,14},{28.6,14.6},{28.6,14}}},
        },
        [11783] = {
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{-1,-1}}},
        },
        [11798] = {
            [npcKeys.npcFlags] = 11,
        },
        [11800] = {
            [npcKeys.npcFlags] = 11,
        },
        [11807] = { -- Tristane Shadowstone
            [npcKeys.questStarts] = {6075},
        },
        [11814] = { -- Kali Remik
            [npcKeys.questStarts] = {6069,8358},
        },
        [11836] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{49.1,29.89},{49.95,34.58},{39,63.09},{38.62,77},{39.28,68.07}}},
        },
        [11876] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{55.00,26.60}}},
        },
        [11886] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{28.34,86.62}}},
        },
        [11887] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{28.32,86.56}}},
        },
        [11920] = {
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS]={{57.4,89.4}}},
        },
        [11921] = {
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS]={{52,73.8},{52.4,71.8},{52.4,74.6},{52.6,71.8},{52.6,74},{52.8,72.6},{53,71.4},{53.6,72.6},{54,71.4},{54.4,71.8},{54.6,72},{54.6,72.8}}},
        },
        [11937] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{49.4,76},{49.6,76},{49.8,77},{50,74.6},{50,77.6},{50.2,74.4},{50.4,70.4},{50.4,70.6},{50.6,70.4},{50.6,70.6},{50.8,81},{51.4,71.6},{52.2,80.2},{52.4,81.2},{52.4,81.6},{52.6,77.4},{52.6,81.6},{52.8,81.4},{53,80},{53,83.4},{53,83.8},{54,79.2},{55,79.2},{55,79.6},{55.2,71.6},{55.4,71.2}}}, -- #1047
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
        },
        [11939] = {
            [npcKeys.spawns] = {[zoneIDs.MOONGLADE]={{44.88,35.6},{47.8,39.6}}},
        },
        [12018] = { -- Majordomo Executus
            [npcKeys.questStarts] = {7632},
        },
        [12048] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{46.82,42.41},{46.59,42.23},{46.98,41.92},{50.3,40.4},{49.21,38.5},{48.86,38.43},{49.55,37.51},{48.65,37.34},{48.18,35.97}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [12126] = {
            [npcKeys.questStarts] = {5542,5543,5544},
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{53.93,24.61,phases.LORD_TIRION_FORDRING_AT_TOWER}}},
        },
        [12128] = {
            [npcKeys.zoneID] = zoneIDs.WESTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{51.93,23.82}}},
        },
        [12138] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {{43.33,45.85}},
                [zoneIDs.THE_BARRENS] = {{41.96,60.79}},
            },
        },
        [12196] = {
            [npcKeys.npcFlags] = 128,
        },
        [12238] = {
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{-1,-1}}},
        },
        [12245] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{60.33,38.12}}},
        },
        [12246] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{40.48,79.27}}},
        },
        [12261] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{70.02,17.32}}},
        },
        [12297] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{48.8,23.8},{42.47,20.49},{51.15,38.53},{48.11,14.51},{42.81,15.28},{59.18,17.75},{42.74,36.02},{41.18,25.68},{54.41,21.93},{54.67,29.98},{51.74,20.44},{57.68,20.79},{50.52,13.04},{52.4,14.28},{46.08,29.96},{53.45,20.8},{45.44,26.66},{56.93,38.97},{44.71,33.76},{50.18,23.26},{60.29,28.13},{58.03,37.06},{53.81,12.23},{57.36,18.14},{41.49,22.7},{54.67,10.57},{44.2,19.76},{56.61,16.61},{52.77,18.57},{56.65,18.12},{48.32,26.34},{44.52,17.61},{40.81,20.67},{59.94,31.01},{43.27,28.12},{48.76,36.48},{52.42,12.74},{43.74,39.33},{49.26,27.23},{54.99,13.34},{47.0,24.16},{58.44,34.68},{45.53,14.75},{60.32,35.27},{51.02,19.46},{50.39,15.37},{57.43,33.98},{54.5,32.09},{53.44,26.84},{50.47,35.75},{50.01,31.15},{48.77,29.55},{55.09,35.44},{54.99,38.7},{53.28,37.96},{58.22,23.88},{49.96,31.05},{50.7,35.92},{48.71,36.9},{54.25,24.17},{54.3,21.78},{57.59,20.49},{58.72,22.12},{60.27,21.63}}},
        },
        [12299] = {
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE]={{44.48,24.36},{35.17,89.26},{46.56,24.97},{34.57,87.25},{38.36,77.52},{36.19,81.94},{44.56,27.62},{43.7,64.03},{46.81,51.18},{46.17,48.28},{41.95,69.65},{45.02,44.31},{39.1,61.87},{46.99,44.1},{43.62,31.44},{46.0,41.38},{41.85,38.14},{43.97,52.89},{40.08,69.85},{42.2,73.37},{43.07,75.47},{43.97,80.14},{47.14,42.21},{47.17,41.27},{45.82,41.49},{38.56,36.07},{43.77,41.38},{48.13,33.97},{46.92,33.91},{45.56,31.68},{43.18,88.41},{39.11,89.9},{40.67,89.83},{41.02,77.81},{49.48,35.21},{49.11,36.08},{41.44,52.68},{41.04,34.8},{51.1,33.53},{51.92,32.75},{41.23,48.31},{38.57,59.21},{40.3,81.84},{38.92,70.36},{51.18,29.79},{49.48,28.58},{41.5,46.08},{38.68,54.53},{40.84,60.16},{47.68,27.5},{43.53,83.42},{43.35,40.79},{42.3,39.6},{40.34,52.3},{43.28,66.94},{37.06,91.2},{39.09,47.85},{43.81,48.22},{48.17,38.98}}},
        },
        [12319] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{48.31,18.89}}},
        },
        [12320] = {
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{48.31,18.92}}},
        },
        [12321] = {
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{54.92,32.99}}},
        },
        [12339] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{72.18,78.85}}},
            [npcKeys.waypoints] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{{59.17,38.49},{59.32,38.7},{59.64,39.13},{59.9,39.5},{60.16,39.87},{60.67,40.65},{60.92,41.14},{61.11,41.61},{61.47,42.55},{61.84,43.48},{62.02,43.95},{62.2,44.42},{62.38,44.89},{62.56,45.36},{62.75,45.82},{62.94,46.28},{63.31,47.21},{63.5,47.68},{63.71,48.2},{63.71,48.2},{63.75,48.74},{63.8,49.27},{63.84,50.14},{63.75,50.58},{63.67,50.74},{63.47,51.19},{63.13,52.07},{63.13,52.07},{62.97,52.56},{62.69,53.49},{62.69,53.49},{62.55,53.99},{62.43,54.74},{62.43,55.28},{62.44,55.82},{62.5,56.99},{62.5,56.99},{62.6,57.51},{62.77,58.47},{62.77,58.47},{63.0,59.5},{63.11,60.01},{63.24,60.52},{63.28,60.68},{63.31,61.21},{63.3,62.05},{63.16,62.77},{63.0,63.25},{62.83,63.74},{62.59,64.39},{62.18,65.2},{61.93,65.58},{61.67,65.96},{61.3,66.53},{61.04,66.91},{60.76,67.25},{60.49,67.61},{60.09,68.22},{60.09,68.22},{60.36,69.01},{60.58,69.45},{60.81,69.87},{61.23,70.58},{61.56,70.82},{61.89,71.04},{62.23,71.23},{62.75,71.48},{62.75,71.48},{63.19,71.77},{63.62,72.15},{63.96,72.59},{63.96,72.59},{64.32,73.39},{64.32,73.39},{64.67,74.34},{64.85,74.81},{65.0,75.16},{65.0,75.16},{65.24,75.55},{65.62,76.04},{65.95,76.31},{65.95,76.31},{66.62,76.7},{66.96,76.89},{67.3,77.06},{67.66,77.18},{68.1,77.34},{68.1,77.34},{68.74,77.7},{69.15,77.86},{69.51,77.97},{69.86,78.07},{70.22,78.18},{70.57,78.27},{71.29,78.45},{71.64,78.57},{72.18,78.85},{72.48,79.16},{73.07,79.78},{73.38,80.06},{73.69,80.33},{74.03,80.51},{74.37,80.7},{75.05,81.07},{75.39,81.25},{75.73,81.44},{76.42,81.77},{76.74,81.81},{77.33,81.81},{77.65,81.7},{78.04,81.63},{78.38,81.63},{78.67,81.63},{79.03,81.65},{79.39,81.66},{80.05,81.68},{80.05,81.68},{80.41,81.78},{81.14,82.33},{81.34,82.8},{81.65,82.73},{81.88,82.51},{82.08,82.29},{82.08,82.29},{82.43,82.43},{82.97,82.71},{83.24,82.85},{83.24,82.85},{83.92,83.22},{84.26,83.4},{84.46,83.52},{84.46,83.52},{85.01,83.82},{85.11,83.89},{85.56,84.19},{85.56,84.19},{84.94,83.77},{84.59,83.58},{84.42,83.49},{84.17,83.35},{83.87,83.18},{83.52,82.99},{83.13,82.79},{83.13,82.79},{82.79,82.62},{82.16,82.27},{82.03,82.07},{81.9,81.68},{81.73,81.44},{81.46,81.49},{80.96,81.93},{80.96,81.93},{80.25,81.78},{79.89,81.68},{79.55,81.65},{79.19,81.66},{78.83,81.64},{78.09,81.63},{77.73,81.68},{77.35,81.78},{77.03,81.81},{76.56,81.77},{76.21,81.63},{75.86,81.48},{75.52,81.31},{75.18,81.15},{74.83,80.97},{74.15,80.6},{73.84,80.42},{73.51,80.17},{73.2,79.9},{72.9,79.6},{72.61,79.27},{72.12,78.74},{72.12,78.74},{71.43,78.41},{71.35,78.39},{70.8,78.35},{70.45,78.25},{70.1,78.13},{69.39,77.88},{69.04,77.75},{68.69,77.6},{68.0,77.28},{67.65,77.15},{66.96,76.83},{66.62,76.65},{66.28,76.47},{65.94,76.28},{65.51,75.95},{65.34,75.73},{65.0,75.13},{64.81,74.67},{64.65,74.18},{64.38,73.45},{64.26,73.14},{63.99,72.64},{63.78,72.4},{63.5,72.11},{63.18,71.82},{62.83,71.55},{62.83,71.55},{62.45,71.32},{62.1,71.16},{61.43,70.81},{61.19,70.53},{61.19,70.53},{60.73,69.69},{60.5,69.27},{60.26,68.82},{60.23,68.37},{60.23,67.94},{60.54,67.55},{60.85,67.15},{61.12,66.78},{61.38,66.42},{61.64,66.04},{61.89,65.64},{62.13,65.24},{62.43,64.7},{62.63,64.25},{62.82,63.81},{62.99,63.33},{63.13,62.83},{63.29,61.85},{63.31,61.24},{63.22,60.72},{63.13,60.19},{63.03,59.67},{62.8,58.54},{62.71,58.02},{62.55,56.96},{62.5,56.42},{62.45,55.09},{62.45,54.75},{62.67,53.53},{62.67,53.53},{62.97,52.55},{63.11,52.13},{63.28,51.78},{63.5,51.34},{63.84,50.59},{63.85,50.28},{63.84,49.74},{63.8,48.88},{63.66,48.13},{63.59,47.85},{63.24,46.9},{63.05,46.44},{62.66,45.53},{62.33,44.71},{61.97,43.77},{61.78,43.3},{61.42,42.36},{61.24,41.89},{60.89,41.04},{60.4,40.25},{60.14,39.86},{59.88,39.49},{59.36,38.74},{59.09,38.37},{58.53,37.63},{58.23,37.34},{57.92,37.05},{57.59,36.74},{56.96,36.19},{56.45,35.78},{56.45,35.78},{55.76,35.45},{55.41,35.34},{54.7,35.16},{54.34,35.07},{53.63,34.91},{53.27,34.85},{52.55,34.72},{52.19,34.64},{51.48,34.46},{51.12,34.36},{50.42,34.13},{50.06,34.01},{49.36,33.78},{48.84,33.59},{48.16,33.24},{47.82,33.04},{46.93,32.52},{46.56,32.28},{46.29,32.12},{45.95,31.93},{45.56,31.69},{45.22,31.58},{44.89,31.51},{44.56,31.38},{44.21,31.24},{43.53,30.88},{42.86,30.6},{42.53,30.4},{42.19,30.2},{41.65,29.87},{41.32,29.66},{40.98,29.47},{40.65,29.27},{39.97,28.87},{39.64,28.67},{39.05,28.43},{38.67,28.63},{38.35,28.88},{38.02,29.13},{37.55,29.46},{37.55,29.46},{36.83,29.42},{36.83,29.42},{36.11,29.42},{35.75,29.41},{35.09,29.29},{34.84,29.23},{34.38,29.1},{33.94,28.88},{33.62,28.64},{33.34,28.41},{33.07,28.14},{32.67,27.62},{32.4,27.27},{32.12,26.91},{31.75,26.39},{31.48,25.92},{31.48,25.92},{31.38,25.0},{31.22,24.6},{31.13,24.22},{31.09,23.68},{31.04,23.14},{30.99,22.61},{30.93,21.62},{30.93,21.62},{30.89,20.71},{30.88,20.05},{30.88,20.05},{30.87,19.04},{30.98,18.69},{30.82,18.46},{30.72,18.72},{30.84,19.02},{30.84,19.43},{30.85,20.06},{30.85,20.06},{30.87,20.6},{30.92,21.68},{30.96,22.22},{31.0,22.76},{31.04,23.3},{31.13,24.27},{31.27,24.78},{31.42,25.27},{31.42,25.27},{31.59,26.14},{31.78,26.48},{32.14,26.95},{32.41,27.31},{32.69,27.66},{32.96,28.02},{33.45,28.61},{33.71,28.78},{33.71,28.78},{34.42,29.13},{34.77,29.22},{35.26,29.31},{35.61,29.37},{36.14,29.42},{36.14,29.42},{36.86,29.43},{37.41,29.43},{37.67,29.38},{37.97,29.22},{37.97,29.22},{38.45,28.82},{38.73,28.62},{38.73,28.62},{39.34,28.53},{39.64,28.68},{39.64,28.68},{40.32,29.07},{40.65,29.26},{41.33,29.66},{41.64,29.84},{41.97,30.05},{42.3,30.27},{42.63,30.48},{42.97,30.66},{43.53,30.94},{43.88,31.1},{44.22,31.26},{44.57,31.4},{44.92,31.55},{45.52,31.69},{45.76,31.82},{46.08,32.05},{46.42,32.25},{46.76,32.45},{47.43,32.83},{47.77,33.02},{48.11,33.21},{48.79,33.59},{49.38,33.88},{49.73,33.99},{50.09,34.1},{50.44,34.2},{51.15,34.41},{51.86,34.6},{52.22,34.67},{52.94,34.81},{53.66,34.96},{54.37,35.12},{54.73,35.17},{55.36,35.29},{56.05,35.6},{56.39,35.79},{56.72,36.01},{57.36,36.52},{57.67,36.8},{58.28,37.38},{58.73,37.84}}}},
        },
        [12369] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE]={{28.24,6.67}}}, -- #901
        },
        [12576] = {
            [npcKeys.spawns] = {
                [zoneIDs.THOUSAND_NEEDLES]={{31.86,21.66}},
                [zoneIDs.THE_BARRENS]={{44.0,92.0}}, -- Add spawn in The Barrens to be shown on the map
            },
        },
        [12580] = {
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{69.56,85.9},{73.52,23.41},{67.82,82.49},{65.66,78.08},{69.67,28.27}}},
        },
        [12759] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE]={{46,70}}},
            [npcKeys.waypoints] = {[zoneIDs.ASHENVALE]={{{46,70},{47,70},{48,69},{48,70},{49,71},{51,70},{51,71},{51,72}}}},
        },
        [12860] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{64.63,75.34}}},
        },
        [12865] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{46.2,90.2},{47.8,90.6},{48,92.4},{48.2,92.6},{48.4,95.4},{48.4,95.6},{48.6,95.4},{48.6,95.6}}},
        },
        [12876] = {
            [npcKeys.zoneID] = zoneIDs.BLACKFATHOM_DEEPS,
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [12900] = {
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS] = {{76,66.6}}},
            [npcKeys.waypoints] = {[zoneIDs.SWAMP_OF_SORROWS]={{{76,66.6},{76.9,68.8},{78.4,70.1},{79.8,70.9},{81.2,71.1},{82.6,71.1},{83.9,70.3},{84.8,67.4},{85.1,65.5},{85.2,62.8},{86.1,60.6},{86.6,57.7},{86.5,54.8},{85.3,52.1},{84.4,49.6},{83.3,46.6},{81.5,45.1},{79.8,46.3},{78.7,48.4},{78.5,50.7},{78.5,52.9},{78.6,55.4},{78.9,57.5},{78.5,59.1},{77.7,60.4},{76.8,62.4},{76,64.3},{76,66.6}}}},
        },
        [12918] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{56.43,63.5}}},
        },
        [12923] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{73.07,36.86}}},
        },
        [12924] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{73.07,36.85}}},
        },
        [12925] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{73.07,36.86}}},
        },
        [12936] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{67.79,49.06}}},
        },
        [12937] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{67.79,49.06}}},
        },
        [12938] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{67.79,49.06}}},
        },
        [12940] = {
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{9.57,27.56}}},
        },
        [12976] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{67.95,43.74},{67.73,52}}},
        },
        [12977] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{67.91,43.72},{67.72,51.99}}},
        },
        [12997] = {
            [npcKeys.spawns] = {[zoneIDs.DEEPRUN_TRAM] = {{-1,-1}}},
        },
        [13016] = {
            [npcKeys.spawns] = {[zoneIDs.DEEPRUN_TRAM] = {{-1,-1}}},
        },
        [13017] = {
            [npcKeys.spawns] = {[zoneIDs.DEEPRUN_TRAM] = {{-1,-1}}},
        },
        [13018] = {
            [npcKeys.spawns] = {[zoneIDs.DEEPRUN_TRAM] = {{-1,-1}}},
        },
        [13081] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.43,4.59},{50.95,5.24},{49.85,5.68},{51.4,5.75},{52.94,6.21},{51.21,6.28},{52.35,6.61},{51.65,7.12},{50.17,7.25},{50.1,7.41},{51.52,7.46},{51.57,7.56},{51.56,7.57},{51.57,7.57},{51.58,7.57},{51.57,7.57},{51.57,7.58},{51.3,7.69},{51.29,7.69},{51.3,7.7},{51.29,7.71},{52.41,8.03},{50.59,8.28},{50.23,8.44},{51.99,8.61},{50.8,8.75},{51.89,9.13},{52.83,9.15},{49.64,9.2},{52.5,7.71},{52.77,4.54},{49.74,4.79},{50.45,5.26},{51.93,5.63},{51.41,5.69},{53.27,6.49},{50.03,6.65},{50.16,7.18},{51.48,7.22},{51.49,7.27},{51.9,7.34},{51.57,7.58},{51.57,7.59},{51.38,8.07},{51.37,8.08},{51.35,8.08},{51.37,8.08},{51.36,8.1},{51.25,8.3},{51.2,8.42},{51.11,8.62},{51.22,8.97},{51.93,9.13},{50.28,9.17},{52.79,9.47},{49.73,9.79}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13098] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.43,4.59},{50.95,5.24},{49.85,5.68},{51.4,5.75},{52.94,6.21},{51.21,6.28},{52.35,6.61},{51.65,7.12},{50.17,7.25},{50.1,7.41},{51.52,7.46},{51.57,7.56},{51.56,7.57},{51.57,7.57},{51.58,7.57},{51.57,7.57},{51.57,7.58},{51.3,7.69},{51.29,7.69},{51.3,7.7},{51.29,7.71},{52.41,8.03},{50.59,8.28},{50.23,8.44},{51.99,8.61},{50.8,8.75},{51.89,9.13},{52.83,9.15},{49.64,9.2},{52.5,7.71},{52.77,4.54},{49.74,4.79},{50.45,5.26},{51.93,5.63},{51.41,5.69},{53.27,6.49},{50.03,6.65},{50.16,7.18},{51.48,7.22},{51.49,7.27},{51.9,7.34},{51.57,7.58},{51.57,7.59},{51.38,8.07},{51.37,8.08},{51.35,8.08},{51.37,8.08},{51.36,8.1},{51.25,8.3},{51.2,8.42},{51.11,8.62},{51.22,8.97},{51.93,9.13},{50.28,9.17},{52.79,9.47},{49.73,9.79}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13136] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{61.73,52.51},{62.79,49.69}}},
        },
        [13179] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{49.85,85.57},{50.6,30.6}}},
        },
        [13180] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{49.87,85.62},{54.23,25.43}}},
        },
        [13181] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.9,14.6},{49.84,85.91}}},
        },
        [13279] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{71.43,34.56},{51.02,48.94}}},
        },
        [13283] = { -- Lord Tony Romano
            [npcKeys.questStarts] = {},
        },
        [13301] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS]={{60.2,52.4},{60.2,52.6}}},
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
        },
        [13324] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13327] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13329] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13330] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13333] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13334] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13335] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13336] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13337] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13417] = { -- Sagorne Creststrider
            [npcKeys.questStarts] = {7061,7667,7668,7669,8258,8410},
            [npcKeys.questEnds] = {6964,7667,7668,7669,8258},
        },
        [13420] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [13424] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.36,13.64},{42.5,13.59},{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13427] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.36,13.64},{42.5,13.59},{42.73,15.94},{42.81,15.68},{42.69,15.68},{42.83,15.91},{49.05,14.73},{48.93,14.56},{48.84,14.81},{48.97,14.91},{51.62,35.53},{51.69,35.66},{51.64,35.82},{51.52,35.65},{44.65,45.76},{44.68,45.43},{44.79,45.6},{44.59,45.57},{51.33,60.21},{51.3,59.96},{51.48,60.01},{51.43,60.23},{50.06,76.57},{49.91,76.75},{50.09,77.03},{50.17,76.71},{49.39,88.3},{49.24,88.23},{49.22,88.0},{49.38,87.99}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13429] = { -- Nardstrum Copperpinch
            [npcKeys.questStarts] = {7024},
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [13431] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF]={{42.46,55.28}}},
            [npcKeys.zoneID] = zoneIDs.THUNDER_BLUFF,
        },
        [13433] = { -- Wulmort Jinglepocket
            [npcKeys.questStarts] = {7022,7042,7045,8762,8763},
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [13435] = { -- Khole Jinglepocket
            [npcKeys.questStarts] = {7023},
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [13437] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.8,18},{48.28,84.35}}},
        },
        [13438] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{43.03,18.25},{50,65}}},
        },
        [13439] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{43.3,18.6},{50.3,81.57}}},
        },
        [13440] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{57.05,82.75}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13444] = { -- Greatfather Winter
            [npcKeys.questEnds] = {7022,7023,7025,7045,8827},
        },
        [13445] = { -- Great-father Winter
            [npcKeys.questEnds] = {6961,6962,6984,7021,7024,8828},
        },
        [13456] = {
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{-1,-1}}},
        },
        [13524] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50.21,80.77},{50.27,80.89}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13526] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50.21,80.77},{50.27,80.89}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13527] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50.21,80.77},{50.27,80.89}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13534] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.09,68.6},{48.21,73.51}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13535] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.09,68.6},{48.21,73.51}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13537] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.15,68.52}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13538] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.15,68.52}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13543] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.61,4.56}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13544] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.61,4.56}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13547] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{48.16,73.42}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13549] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50.38,74.16}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13550] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50.38,74.16}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13552] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.54,7.14},{52.62,7.43}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13553] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.54,7.14},{52.62,7.43}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13555] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.61,7.26}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13556] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.61,7.26}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13576] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.1,17.18}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13602] = { -- The Abominable Greench
            [npcKeys.spawns] = {[36]={{37.26,71.16},{29.92,61.01},{41.44,63.57},{31.62,50.84},{32.18,47.29},{30.05,64.27},{40.83,67.68},{39.61,62.91},{30.85,54.63},{45.11,63.02},{39.67,73.5},{34.34,67.9}}},
            [npcKeys.questEnds] = {},
        },
        [13696] = {
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{-1,-1}}},
        },
        [13697] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{31.9,63.8}}},
        },
        [13716] = {
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{-1,-1}}},
        },
        [13718] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{28.15,62.39},{27.24,63.14},{28.75,62.4},{28.2,64.19}}},
        },
        [13739] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{30.37,54.62}}},
        },
        [13740] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{35.18,60.2}}},
        },
        [13741] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{29.05,57.15}}},
        },
        [13742] = {
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{29.82,60.3}}},
        },
        [13756] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{49.3,88.5},{49.3,76.7},{51.6,57.1},{51.8,36},{49.2,14.8},{42.4,15.6}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [13796] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.3,67.9},{52.5,7.6}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14026] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50.6,30.6}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14027] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{44.9,14.6}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14028] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{54,27}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14029] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{48,84}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14030] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50,65}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14031] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{50,81}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14232] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{47.27,18.38}}},
        },
        [14233] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{37.8,50.29},{49.06,57.33},{44.08,50.17},{42.35,55},{47.26,54.65}}},
        },
        [14304] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14305] = {
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY, -- default zone where you start the chain
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{47.32,38.58}}}, -- only SW for consistency
        },
        [14351] = {
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [14353] = { -- Mizzle the Crafty
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [14373] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{74.4,44}}},
        },
        [14375] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14376] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14377] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14387] = { -- Lothos Riftwaker
            [npcKeys.spawns] = {
                [zoneIDs.BURNING_STEPPES] = {{26.4,24.45},},
                [zoneIDs.SEARING_GORGE] = {{32.13,94.7},},
            },
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [14444] = {
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR, -- default zone where you start the chain
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{70.92,25.62}}}, -- only OG for consistency
        },
        [14500] = {
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE]={{-1, -1}}}, -- #1506
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE, -- #1506
        },
        [14502] = {
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [14504] = {
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [14506] = {
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [14515] = {
            [npcKeys.zoneID] = zoneIDs.ZUL_GURUB,
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{-1,-1}}},
        },
        [14516] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [14518] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [14519] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [14520] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [14521] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [14524] = {
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{47.78,24.08}}},
        },
        [14525] = {
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{48.39,22.29}}},
        },
        [14526] = {
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{46.7,24.06}}},
        },
        [14528] = {
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{50.13,76.59},{31.31,44.93},{51.62,68.79},{45.03,61.14}}},
        },
        [14564] = {
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{13.96,29.34},{15.34,29.29},{14.38,26.46},{19.03,27.43},{15.25,31.1},{14.65,26.3},{14.46,27.27},{16.42,31.75},{14.97,27.85},{15.17,29.91},{18.04,32.68},{18.85,31.22},{11.62,27.37},{14.66,27.74},{14.52,26.2},{13.47,25.62},{14.26,26.42},{18.62,27.22},{14.99,29.43},{18.32,29.66},{13.2,21.86},{14.31,27.63},{18.34,27.91},{13.45,26.07},{10.84,27.36},{11.48,26.2},{11.32,28.17},{12.31,26.94},{12.22,28.61},{11.99,29.29},{13.35,26.19},{16.3,27.37},{14.18,23.53},{14.88,24.34},{17.18,28.38}}},
        },
        [14566] = {
            [npcKeys.zoneID] = zoneIDs.DIRE_MAUL,
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [14568] = {
            [npcKeys.zoneID] = zoneIDs.SCHOLOMANCE,
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [14603] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{34.54,33.98},{42.52,46.88},{38.25,34.95},{36.47,35.75},{36.42,36.53},{45.46,62.32},{44.15,50.09},{45.9,57.9},{46.49,59.58}}},
            [npcKeys.zoneID] = zoneIDs.FERALAS,
        },
        [14604] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{40.93,25.55},{38.07,18.26},{37.99,23.6},{39.61,22.11},{37.76,21.92},{39.16,23.89},{38.52,24.39},{41.15,24.82}}},
            [npcKeys.zoneID] = zoneIDs.FERALAS,
        },
        [14624] = {
            [npcKeys.npcFlags] = npcFlags.REPAIR,
        },
        [14638] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{45.1,61.95},{37.71,34.47},{44.34,46.61},{46.78,57.88}}},
            [npcKeys.zoneID] = zoneIDs.FERALAS,
        },
        [14639] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{36.14,33.44},{43.13,52.95},{40.15,38.65},{44.99,66.44},{44.12,49.08},{45.23,52.9},{46.83,62.22}}},
            [npcKeys.zoneID] = zoneIDs.FERALAS,
        },
        [14640] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{39.9,21.9},{40.44,22.43},{40.32,24.63},{40.72,24.44},{38.69,23.6},{39.67,22.3},{38.78,21.93},{38.23,20.59},{38.17,21.4},{41.05,22.62},{39.62,22.23}}},
            [npcKeys.zoneID] = zoneIDs.FERALAS,
        },
        [14661] = { -- Stinglasher
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{75.58,60.85}}},
            [npcKeys.waypoints] = {[zoneIDs.FERALAS]={{{73.81,63.45},{73.78,63.74},{73.71,63.86},{73.60,63.98},{73.55,64.00},{73.37,63.93},{73.29,63.80},{73.24,63.55},{73.28,63.40},{73.36,63.22},{73.43,63.16},{73.50,63.13},{73.61,63.10},{73.64,63.10},{73.81,63.15},{73.93,63.19},{74.05,63.08},{74.05,63.07},{74.11,62.97},{74.17,62.88},{74.25,62.76},{74.30,62.68},{74.37,62.59},{74.53,62.42},{74.63,62.35},{74.76,62.26},{74.85,62.19},{74.88,62.17},{74.98,62.09},{75.08,61.98},{75.15,61.84},{75.23,61.69},{75.33,61.48},{75.36,61.36},{75.39,61.19},{75.41,61.03},{75.46,60.85},{75.58,60.85},{75.68,60.87},{75.77,60.90},{75.89,60.94},{75.97,60.98},{76.11,61.07},{76.12,61.08},{76.25,61.17},{76.28,61.19},{76.40,61.26},{76.55,61.34},{76.62,61.38},{76.66,61.40},{76.84,61.49},{76.92,61.53},{77.00,61.56},{77.09,61.60},{77.15,61.65},{77.16,61.66},{77.25,61.77},{77.32,61.89},{77.42,62.04},{77.43,62.05},{77.54,62.02},{77.74,62.07},{77.88,62.21},{78.03,62.44},{78.14,62.48},{78.15,62.47},{78.32,62.38},{78.42,62.48},{78.49,62.72},{78.47,62.87},{78.46,62.89},{78.42,62.95},{78.19,63.07},{78.09,63.01},{78.02,62.84},{78.06,62.53},{77.97,62.35}}}},
        },
        [14693] = {
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [14721] = {
            [npcKeys.name] = "Field Marshal Stonebridge",
        },
        [14733] = { -- Sentinel Farsong
            [npcKeys.questStarts] = {7886,7887,7888,7921,8289},
            [npcKeys.questEnds] = {7886,7887,7888,7921,8289},
        },
        [14748] = {
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS]={{84.6,41.2}}},
            [npcKeys.zoneID] = zoneIDs.THE_HINTERLANDS,
        },
        [14766] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.32,13.58}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14767] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.41,13.53}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14768] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.53,13.49}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14769] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{42.15,13.09}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14770] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{47.38,87.21}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14771] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{47.32,87.1}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14774] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{47.24,86.9}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14775] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{47.27,86.7}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [14842] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{29.65,75.25}}},
        },
        [14843] = {
            [npcKeys.waypoints] = {[zoneIDs.ORGRIMMAR] = {{{52.9,66.56},{52.18,65.03},{50.65,63.06},{49.57,61.45},{48.8,59.66},{47.62,59.31},{46.42,59.55},{45.38,60.66},{44.61,61.93},{44.18,62.91},{44.06,64.4},{44.46,66.06},{45.59,68.07},{46.15,69.06},{46.51,70.88},{47.32,72.9},{48.54,74.38},{49.63,75.51},{50.66,76.29},{51.66,76.39},{52.63,76.48},{53.79,74.35},{54.1,72.74},{53.82,71.14},{53.24,68.91}}}},
        },
        [14845] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14846] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14847] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [14862] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS]={{48.77,58.14}}},
        },
        [14887] = {
            [npcKeys.spawns] = {
                [zoneIDs.DUSKWOOD] = {{46.5,39.6}},
                [zoneIDs.THE_HINTERLANDS] = {{63.2,24.4}},
                [zoneIDs.ASHENVALE] = {{93.7,37.8}},
                [zoneIDs.FERALAS] = {{51.6,11.1}},
            },
        },
        [14888] = {
            [npcKeys.spawns] = {
                [zoneIDs.DUSKWOOD] = {{46.5,39.6}},
                [zoneIDs.THE_HINTERLANDS] = {{63.2,24.4}},
                [zoneIDs.ASHENVALE] = {{93.7,37.8}},
                [zoneIDs.FERALAS] = {{51.6,11.1}},
            },
        },
        [14889] = {
            [npcKeys.spawns] = {
                [zoneIDs.DUSKWOOD] = {{46.5,39.6}},
                [zoneIDs.THE_HINTERLANDS] = {{63.2,24.4}},
                [zoneIDs.ASHENVALE] = {{93.7,37.8}},
                [zoneIDs.FERALAS] = {{51.6,11.1}},
            },
        },
        [14890] = {
            [npcKeys.spawns] = {
                [zoneIDs.DUSKWOOD] = {{46.5,39.6}},
                [zoneIDs.THE_HINTERLANDS] = {{63.2,24.4}},
                [zoneIDs.ASHENVALE] = {{93.7,37.8}},
                [zoneIDs.FERALAS] = {{51.6,11.1}},
            },
        },
        [14990] = {
            [npcKeys.spawns] = {},
        },
        [14991] = {
            [npcKeys.spawns] = {},
        },
        [15001] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_BASIN]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ARATHI_BASIN,
        },
        [15002] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_BASIN]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ARATHI_BASIN,
        },
        [15003] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_BASIN]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ARATHI_BASIN,
        },
        [15004] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_BASIN]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ARATHI_BASIN,
        },
        [15005] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_BASIN]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ARATHI_BASIN,
        },
        [15102] = {
            [npcKeys.spawns] = {},
        },
        [15103] = {
            [npcKeys.spawns] = {},
        },
        [15105] = {
            [npcKeys.spawns] = {},
        },
        [15106] = {
            [npcKeys.spawns] = {},
        },
        [15114] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{-1,-1}}},
        },
        [15116] = { -- Grinkle
            [npcKeys.questStarts] = {8228},
            [npcKeys.questEnds] = {8228},
        },
        [15119] = { -- Barrus
            [npcKeys.questStarts] = {8229},
            [npcKeys.questEnds] = {8229},
        },
        [15197] = {
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{55.57,69.9}}},
        },
        [15199] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{50,57.35}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
        },
        [15203] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{39.6,45.08},{25.56,34.04},{18.55,83.52}}},
        },
        [15204] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{39.6,45.08},{25.56,34.04},{18.55,83.52}}},
        },
        [15205] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{39.6,45.08},{25.56,34.04},{18.55,83.52}}},
        },
        [15206] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{37.63,44.8},{24.7,32.65},{17.21,84.81}}},
        },
        [15207] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{37.63,44.8},{24.7,32.65},{17.21,84.81}}},
        },
        [15208] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{37.63,44.8},{24.7,32.65},{17.21,84.81}}},
        },
        [15209] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{20.46,86.16},{18.23,81.12},{38.96,42.44},{38.29,46.46},{27.94,30.62},{24.44,36.0}}},
        },
        [15211] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{20.46,86.16},{18.23,81.12},{38.96,42.44},{38.29,46.46},{27.94,30.62},{24.44,36.0}}},
        },
        [15212] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{20.46,86.16},{18.23,81.12},{38.96,42.44},{38.29,46.46},{27.94,30.62},{24.44,36.0}}},
        },
        [15215] = {
            [npcKeys.spawns] = {[zoneIDs.KALIMDOR]={{44.399,86.11}}},
            [npcKeys.zoneID] = zoneIDs.KALIMDOR,
        },
        [15220] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{37.63,44.8},{24.7,32.65},{17.21,84.81}}},
        },
        [15305] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{39.6,45.08},{25.56,34.04},{18.55,83.52}}},
        },
        [15307] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{20.46,86.16},{18.23,81.12},{38.96,42.44},{38.29,46.46},{27.94,30.62},{24.44,36.0}}},
        },
        [15350] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{80.68,30.51}},
                [zoneIDs.THUNDER_BLUFF]={{57.8,76.4}},
                [zoneIDs.UNDERCITY]={{58.27,97.9}},
                [zoneIDs.ALTERAC_MOUNTAINS]={{63.09,59.87}},
                [zoneIDs.THE_BARRENS]={{46.71,8.68}},
                [zoneIDs.ARATHI_HIGHLANDS]={{73.5,29.13}},
                [zoneIDs.THE_HINTERLANDS]={{50.33,89.57}},
            },
        },
        [15362] = {
            [npcKeys.zoneID] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [15369] = {
            [npcKeys.waypoints] = {},
        },
        [15383] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{64.1,65.5}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15415] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{50.3,57.6}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
        },
        [15449] = {
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{32.74,52.64}}},
        },
        [15431] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{65.5,63.9}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15432] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{63.9,68.2}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15434] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{70.3,74.3}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15437] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{71.9,70.4}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15440] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS]={{32.8,52.6}}},
        },
        [15445] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{71.3,71.4}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15446] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{58.0,75.9}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15448] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{58.7,75.0}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15450] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{57.1,75.0}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15451] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{54.5,77.9}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15452] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{57.6,75.8}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15453] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{55.7,75.9}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15455] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{71.6,69.2}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15456] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{72.1,69.6}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15457] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{73.0,68.5}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [15459] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{31.1,66.1}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15460] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{30.9,65.4}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15469] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{31.5,66.8}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15471] = {
            [npcKeys.spawns] = {[zoneIDs.RUINS_OF_AHN_QIRAJ] = {{-1,-1}}},
        },
        [15477] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{33.3,69.6}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15481] = { -- Spirit of Azuregos
            [npcKeys.questStarts] = {8575},
        },
        [15508] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{32.8,70.4}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15512] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{32.8,68.7}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15515] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{36.0,73.4}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [15517] = {
            [npcKeys.zoneID] = zoneIDs.AHN_QIRAJ,
            [npcKeys.spawns] = {[zoneIDs.AHN_QIRAJ] = {{-1,-1}}},
        },
        [15522] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{34.0,72.7}}},
        },
        [15525] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{35.1,72.6}}},
        },
        [15528] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{31.2,74.1}}},
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [15529] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{31.3,75.1}}},
        },
        [15532] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{32.2,75.3}}},
        },
        [15533] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{29.5,68.8}}},
        },
        [15534] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{29.0,68.5}}},
        },
        [15535] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{28.8,67.8}}},
        },
        [15552] = {
            [npcKeys.waypoints] = {},
        },
        [15554] = {
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING]={{67.2,72.6}}},
        },
        [15557] = {
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES]={{82.21,46.48}}},
        },
        [15558] = {
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN]={{33.33,46.54}}},
        },
        [15563] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{58.75,51.70}}},
        },
        [15565] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{39.79,63.67}}},
        },
        [15570] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS]={{23.08,11.84}}},
        },
        [15573] = {
            [npcKeys.spawns] = {[zoneIDs.TANARIS]={{36.30,80.54}}},
        },
        [15576] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE]={{27.62,74.26}}},
        },
        [15586] = {
            [npcKeys.spawns] = {[zoneIDs.TANARIS]={{51.47,27.85}}},
        },
        [15587] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS]={{62.58,30.96}}},
        },
        [15594] = {
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS]={{69.18,73.45}}},
        },
        [15604] = {
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES]={{79.20,77.05}}},
        },
        [15605] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{35.6,48.8}}},
        },
        [15625] = {
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD]={{48.6,40.0}}},
        },
        [15700] = { -- Warlord Gorchuk
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{30.3,67.6}}},
            [npcKeys.questEnds] = {8792,8793,8794,8851,8852,8853,8854,8855},
        },
        [15701] = { -- Field Marshal Snowfall
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{61.3,74.2}}},
            [npcKeys.questEnds] = {8795,8796,8797,8846,8847,8848,8849,8850},
        },
        [15702] = {
            [npcKeys.zoneID] = zoneIDs.THUNDER_BLUFF,
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF] = {{38.8,52.9}}},
        },
        [15703] = {
            [npcKeys.zoneID] = zoneIDs.UNDERCITY,
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY] = {{62.8,49.2}}},
        },
        [15704] = {
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{50.8,65.5}}},
        },
        [15707] = {
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{27.5,73.3}}},
        },
        [15709] = {
            [npcKeys.zoneID] = zoneIDs.DARNASSUS,
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS] = {{39.1,38.3}}},
        },
        [15712] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{28.09,86.15}}},
        },
        [15797] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{49.47,37.3}}},
        },
        [15798] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{49.45,37.25}}},
        },
        [15891] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{50.98,70.52}},
                [zoneIDs.THUNDER_BLUFF]={{38.37,63.42}},
                [zoneIDs.UNDERCITY]={{66.73,43.37}},
            },
        },
        [15892] = {
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY]={{54.36,66.29}},
                [zoneIDs.IRONFORGE]={{30.93,61.59}},
                [zoneIDs.DARNASSUS]={{42.16,43.97}},
            },
        },
        [15893] = {
            [npcKeys.spawns] = {},
        },
        [15894] = {
            [npcKeys.spawns] = {},
        },
        [15895] = {
            [npcKeys.spawns] = {
                [zoneIDs.UNDERCITY]={{65.62,36.0}},
                [zoneIDs.ORGRIMMAR]={{41.66,31.98}},
                [zoneIDs.THUNDER_BLUFF]={{71.12,28.2}},
                [zoneIDs.IRONFORGE]={{28.85,16.23}},
                [zoneIDs.STORMWIND_CITY]={{23.22,53.24}},
                [zoneIDs.DARNASSUS]={{32.60,12.00}},
            },
        },
        [15974] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [15975] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [15976] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [15978] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [15979] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [15980] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [15981] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16017] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16018] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16020] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16021] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16022] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16025] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16031] = {
            [npcKeys.zoneID] = zoneIDs.STRATHOLME,
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [16033] = { -- Bodley
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_KINGDOMS] = {{48.896,63.93},},
            },
            [npcKeys.zoneID] = zoneIDs.EASTERN_KINGDOMS,
        },
        [16042] = {
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [16059] = {
            [npcKeys.zoneID] = zoneIDs.BLACKROCK_DEPTHS,
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [16067] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16073] = {
            [npcKeys.zoneID] = zoneIDs.UPPER_BLACKROCK_SPIRE,
            [npcKeys.spawns] = {[zoneIDs.UPPER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [16080] = {
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [16097] = {
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL] = {{-1,-1}}},
        },
        [16101] = {
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [16102] = {
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{-1,-1}}},
        },
        [16118] = {
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [16143] = {
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {{73.9,55.2},{77.9,67.8},{67.1,68.3},{24.7,72.5},{15.3,75.3},{20.4,79.8}},
                [zoneIDs.BURNING_STEPPES]={{77.2,30.5},{67.4,34},{71.7,49.2},{36.2,70.6},{23.6,70.6},{23.5,48.7}},
                [zoneIDs.BLASTED_LANDS]={{60.1,43.4},{63,28.3},{56.9,29.2},{47.2,35.6},{51.2,26.5},{45.9,19}},
                [zoneIDs.WINTERSPRING]={{50.9,14.3},{45.3,37.8},{64.1,50.5}},
                [zoneIDs.AZSHARA]={{46.3,56.6},{22.1,60.5},{16.9,68.5},{17.1,52.5}},
                [zoneIDs.TANARIS]={{48.1,29.8},{54.2,29.9},{50.6,34.2},{51.9,50.3},{55.9,52},{53.8,54.4},{35.3,56.8},{33.5,66.6},{29.7,57.5}},
            },
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [16145] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16154] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16156] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16157] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16158] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16163] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16164] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16165] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16167] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16168] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16193] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16194] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16215] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16216] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16226] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{80.3,57.8}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [16244] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16254] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{47.2,42.6}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [16255] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR] = {{52.5,73.7}},
                [zoneIDs.UNDERCITY] = {{66.2,47}},
                [zoneIDs.THUNDER_BLUFF] = {{42.8,58.6}},
            },
        },
        [16281] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{80.91,60.34}}},
        },
        [16361] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{80.91,60.40}}},
        },
        [16368] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16422] = {
            [npcKeys.spawns] = {
                [zoneIDs.ELWYNN_FOREST]={{30.8,54.4},{32,54},{32,54.6},{32.4,52.4},{32.4,53.4},{32.6,52.2},{32.6,53.2},{33,55.2},{33.4,49.2},{33.4,50.4},{33.4,50.8},{33.4,53.8},{33.6,50.4},{33.8,49},{33.8,50.8},{33.8,55.6},{34,54.4},{34,54.8},{34.2,48.4},{34.2,52.8},{34.4,51.6},{34.6,48.2},{34.6,51.8},{34.6,52.8},{34.8,50.6},{34.8,54.4},{34.8,55.6},{35,55},{35,56.6},{35.2,50},{35.4,49},{35.6,49},{35.6,51},{36,55.2},{36.8,55.4},{36.8,55.6},{37,54.4},{37.6,54.4},{37.8,54.6}},
                [zoneIDs.TIRISFAL_GLADES]={{59.4,60.4},{59.4,60.6},{59.4,61.6},{59.6,59.4},{60.2,60.2},{60.2,60.6},{60.2,62.2},{60.4,62.6},{60.6,60.2},{60.6,61.4},{60.6,63},{60.8,61.6}},
            },
        },
        [16423] = {
            [npcKeys.spawns] = {
                [zoneIDs.ELWYNN_FOREST]={{32,54},{32.4,52.4},{32.4,53.4},{32.4,55.4},{32.4,55.6},{32.6,52.4},{32.6,55.4},{32.8,53.2},{33,50.2},{33,50.8},{33.2,49.2},{33.4,54.2},{33.4,55.6},{33.6,53.4},{33.6,55.6},{33.8,48.6},{33.8,51.2},{33.8,54},{34,48.4},{34.2,51.6},{34.4,49.8},{34.4,54.8},{34.6,48.8},{34.6,51.4},{34.8,47.8},{34.8,51.6},{34.8,56.2},{35,56.6},{35.2,50.4},{35.2,54.4},{35.4,55.4},{35.6,54},{35.6,55.4},{35.8,48.4},{36,56.2}},
                [zoneIDs.TIRISFAL_GLADES]={{59.4,59.8},{59.4,61.4},{59.4,62.4},{59.4,62.8},{59.8,60.2},{60,59.4},{60,62.4},{60.2,61.2},{60.2,62.6},{60.6,60.4},{60.6,60.6},{60.8,61.8},{61.6,61.4}},
            },
        },
        [16437] = {
            [npcKeys.spawns] = {
                [zoneIDs.MULGORE]={{37.2,34.4},{37.4,35.6},{37.4,37.6},{38,35.2},{38.2,36},{38.2,37},{38.2,38},{38.6,35.2},{38.8,38.6},{39,36.4},{39,37.2},{39,38.2},{39.6,35.4},{39.6,38.8},{39.8,36},{40,37.6},{40.2,37.2}},
                [zoneIDs.DUROTAR]={{43.6,15.4},{44,17},{44.4,16.4},{44.4,18},{44.4,18.6},{44.6,18.6},{45,17},{45,18.2},{45.4,15.4},{45.4,16.2},{45.6,15.4},{45.6,15.6},{45.8,14.2}},
                [zoneIDs.DUN_MOROGH]={{47.2,40.4},{48.2,40},{48.2,40.6},{48.4,38.2},{48.4,38.8},{48.8,40.8},{49,38},{49,40},{49.4,39.4},{49.6,40},{49.8,39},{50.2,37.8}},
                [zoneIDs.TELDRASSIL]={{36,54.4},{36.4,55.8},{36.8,54},{36.8,55.6},{37,55},{37.6,55.4},{37.8,54.4},{37.8,56.4},{38,56.8},{38,57.6},{38.6,56.2},{38.6,56.8}},
            },
        },
        [16438] = {
            [npcKeys.spawns] = {
                [zoneIDs.MULGORE]={{37.8,41},{38.2,35.4},{38.2,36.2},{38.2,37},{38.2,37.6},{38.4,38.6},{38.8,35.4},{38.8,36},{38.8,37},{38.8,38.6},{39.4,37.6},{39.6,36.4},{39.8,39.2},{40,37.6},{40.2,37}},
                [zoneIDs.DUROTAR]={{43.4,16.4},{44,16.4},{44.4,17},{44.4,18.4},{44.4,18.6},{44.6,17.8},{44.6,18.6},{45,16.6},{45.2,16.4},{45.4,15.4},{45.6,15.4},{45.6,15.6},{45.6,16.8},{45.8,14.2},{46,18.4}},
                [zoneIDs.DUN_MOROGH]={{47.4,40.4},{48.4,38.4},{48.4,38.6},{48.4,39.6},{48.6,38.4},{48.8,40.8},{49.2,38.8},{49.2,40},{49.8,40.8},{50,38.4},{50,38.6},{50,40.2},{50.2,37.4}},
                [zoneIDs.TELDRASSIL]={{36.2,54.4},{36.4,54.8},{36.4,56},{36.6,54.6},{36.6,56.2},{36.8,54.4},{37.6,55.2},{37.8,56.2},{38,56.6},{38.2,54},{38.4,58},{38.6,56},{38.6,56.8}},
            },
        },
        [16446] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16447] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16448] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16449] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16451] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16452] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16453] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [16478] = {
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{63.8,75.6}}},
        },
        [16479] = {
            [npcKeys.zoneID] = zoneIDs.AZSHARA,
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{29.94,53.51},{36.16,54.59}}},
        },
        [16484] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{53,35}}},
        },
        [16490] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF] = {{31.4,70.4}}},
        },
        [16493] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{51.6,82}}},
        },
        [16494] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY] = {{66.8,21.4}}},
        },
        [16495] = {
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS] = {{78.2,41.4}}},
        },
        [185333] = {
            [npcKeys.name] = "Avelina Lilly",
            [npcKeys.minLevel] = 22,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{63.5,65.3}}},
        },
        [185334] = {
            [npcKeys.name] = "Isaac Pearson",
            [npcKeys.minLevel] = 22,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{61.8,38.5}}},
        },
        [185335] = {
            [npcKeys.name] = "Summoned Incubus",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
        },
    }
end

-- some quest items are shared across factions but require different sources for each faction (not sure if there is a better way to implement this)
function QuestieNPCFixes:LoadFactionFixes()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs

    local npcFixesHorde = {
        [13778] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{52.8,44},{50.8,30.8},{45.2,14.6},{44,18.1}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [15898] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{41.27,32.36}},
                [zoneIDs.THUNDER_BLUFF]={{70.56,27.83}},
                [zoneIDs.UNDERCITY]={{66.45,36.02}},
                [zoneIDs.MOONGLADE]={{36.58,58.1},{36.3,58.53}},
            },
        },
        [16788] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{42.61,34.21}},
                [zoneIDs.UNDERCITY]={{65.6,35.99}},
                [zoneIDs.THUNDER_BLUFF]={{21.55,26.18}},
            },
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
    }

    local npcFixesAlliance = {
        [13778] = {
            [npcKeys.spawns] = {[zoneIDs.ALTERAC_VALLEY]={{48.5,58.3},{50.2,65.3},{49.3,84.4},{48.3,84.3}}},
            [npcKeys.zoneID] = zoneIDs.ALTERAC_VALLEY,
        },
        [15898] = {
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY]={{22.78,51.19}},
                [zoneIDs.IRONFORGE]={{29.92,14.21}},
                [zoneIDs.MOONGLADE]={{36.58,58.1},{36.3,58.53}},
                [zoneIDs.DARNASSUS]={{31.56,13.69}},
            },
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
        },
        [16788] = {
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL]={{56.56,91.94}},
                [zoneIDs.STORMWIND_CITY]={{38.4,61.29}},
                [zoneIDs.IRONFORGE]={{63.54,24.67}},
            },
            [npcKeys.zoneID] = zoneIDs.TELDRASSIL,
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return npcFixesHorde
    else
        return npcFixesAlliance
    end
end

---Updates the NPC spawns to be either in Elwynn Forest or Mulgore
---@param isInMulgore boolean
---@return table<number, any>
function QuestieNPCFixes:LoadDarkmoonFixes(isInMulgore)
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs

    if isInMulgore then
        return {
            [14828] = {
                [npcKeys.spawns] = {[zoneIDs.MULGORE]={{37.24,37.67}}},
                [npcKeys.zoneID] = zoneIDs.MULGORE,
            },
            [14829] = {
                [npcKeys.spawns] = {[zoneIDs.MULGORE]={{37.47,39.56}}},
                [npcKeys.zoneID] = zoneIDs.MULGORE,
            },
            [14832] = {
                [npcKeys.spawns] = {[zoneIDs.MULGORE]={{37.82,39.81}}},
                [npcKeys.zoneID] = zoneIDs.MULGORE,
            },
            [14833] = {
                [npcKeys.spawns] = {[zoneIDs.MULGORE]={{36.17,35.15}}}, -- might be 37.2,37.7
                [npcKeys.zoneID] = zoneIDs.MULGORE,
            },
            [14841] = {
                [npcKeys.spawns] = {[zoneIDs.MULGORE]={{37.09,37.17}}},
                [npcKeys.zoneID] = zoneIDs.MULGORE,
            },
            [14871] = {
                [npcKeys.spawns] = {[zoneIDs.MULGORE]={{35.92,35.27}}},
                [npcKeys.zoneID] = zoneIDs.MULGORE,
            },
        }
    else
        return {
            [14828] = {
                [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{41.5,68.87}}},
                [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            },
            [14829] = {
                [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{40.17,69.53}}},
                [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            },
            [14832] = {
                [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{40.49,69.93}}},
                [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            },
            [14833] = {
                [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{43.61,70.84}}}, -- might be 41.5,68.9
                [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            },
            [14841] = {
                [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{41.71,70.72}}},
                [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            },
            [14871] = {
                [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{43.34,70.28}}},
                [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            },
        }
    end
end

return QuestieNPCFixes
