---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local eventsLocales = {
    ["Darkmoon Faire"] = {
        ["enUS"] = true,
        ["deDE"] = "Dunkelmond-Jahrmarkt",
        ["esES"] = "Feria de la Luna Negra",
        ["esMX"] = "Feria de la Luna Negra",
        ["frFR"] = "Foire de Sombrelune",
        ["koKR"] = "다크문 축제",
        ["ptBR"] = "Feira de Negraluna",
        ["ruRU"] = "Ярмарка Новолуния",
        ["zhCN"] = "暗月马戏团",
        ["zhTW"] = "暗月馬戲團",
    },
    ["Lunar Festival"] = {
        ["enUS"] = true,
        ["deDE"] = "Mondfest",
        ["esES"] = "Festival Lunar",
        ["esMX"] = "Festival Lunar",
        ["frFR"] = "Fête lunaire",
        ["koKR"] = "달의 축제",
        ["ptBR"] = "Festival da Lua",
        ["ruRU"] = "Лунный фестиваль",
        ["zhCN"] = "春节",
        ["zhTW"] = "新年慶典",
    },
    ["Love is in the Air"] = {
        ["enUS"] = true,
        ["deDE"] = "Liebe liegt in der Luft",
        ["esES"] = "Amor en el aire",
        ["esMX"] = "Amor en el aire",
        ["frFR"] = "De l'amour dans l'air",
        ["koKR"] = "온누리에 사랑을",
        ["ptBR"] = "O Amor Está No Ar",
        ["ruRU"] = "Любовная лихорадка",
        ["zhCN"] = "情人节",
        ["zhTW"] = "愛就在身邊",
    },
    ["Noblegarden"] = {
        ["enUS"] = true,
        ["deDE"] = "Nobelgarten",
        ["esES"] = "Jardín Noble",
        ["esMX"] = "Jardín Noble",
        ["frFR"] = "Le Jardin des nobles",
        ["koKR"] = "귀족의 정원",
        ["ptBR"] = "Jardinova",
        ["ruRU"] = "Сад чудес",
        ["zhCN"] = "复活节",
        ["zhTW"] = "貴族花園",
    },
    ["Children's Week"] = {
        ["enUS"] = true,
        ["deDE"] = "Kinderwoche",
        ["esES"] = "Semana de los Niños",
        ["esMX"] = "Semana de los Niños",
        ["frFR"] = "Semaine des enfants",
        ["koKR"] = "어린이 주간",
        ["ptBR"] = "Semana das Crianças",
        ["ruRU"] = "Детская неделя",
        ["zhCN"] = "儿童周",
        ["zhTW"] = "兒童週",
    },
    ["Midsummer"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenwendfest",
        ["esES"] = "Verano",
        ["esMX"] = "Verano",
        ["frFR"] = "Solstice d'été",
        ["koKR"] = "한여름 불꽃축제",
        ["ptBR"] = "Solstício",
        ["ruRU"] = "Огненный солнцеворот",
        ["zhCN"] = "仲夏火焰节",
        ["zhTW"] = "仲夏火焰節",
    },
    ["Brewfest"] = {
        ["enUS"] = true,
        ["deDE"] = "Braufest",
        ["esES"] = "Fiesta de la Cerveza",
        ["esMX"] = "Fiesta de la Cerveza",
        ["frFR"] = "Fête des Brasseurs",
        ["koKR"] = "맥주 축제",
        ["ptBR"] = "CervaFest",
        ["ruRU"] = "Хмельной фестиваль",
        ["zhCN"] = "美酒节",
        ["zhTW"] = "啤酒節",
    },
    ["Harvest Festival"] = {
        ["enUS"] = true,
        ["deDE"] = "Erntedankfest",
        ["esES"] = "Festival de la Cosecha",
        ["esMX"] = "Festival de la Cosecha",
        ["frFR"] = "Fête des moissons",
        ["koKR"] = "추수절",
        ["ptBR"] = "Festival da Colheita",
        ["ruRU"] = "Неделя урожая",
        ["zhCN"] = "收获节",
        ["zhTW"] = "收穫節",
    },
    ["Pilgrim's Bounty"] = {
        ["enUS"] = true,
        ["deDE"] = "Pilgerfreudenfest",
        ["esES"] = "Generosidad del Peregrino",
        ["esMX"] = "Generosidad del Peregrino",
        ["frFR"] = "Les Bienfaits du pèlerin",
        ["koKR"] = "순례자의 감사절",
        ["ptBR"] = "Festa da Fartura",
        ["ruRU"] = "Пиршество странников",
        ["zhCN"] = "感恩节",
        ["zhTW"] = "旅人豐年祭",
    },
    ["Hallow's End"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlotternächte",
        ["esES"] = "Halloween",
        ["esMX"] = "Halloween",
        ["frFR"] = "Sanssaint",
        ["koKR"] = "할로윈 축제",
        ["ptBR"] = "Noturnália",
        ["ruRU"] = "Тыквовин",
        ["zhCN"] = "万圣节",
        ["zhTW"] = "萬鬼節",
    },
    ["Winter Veil"] = {
        ["enUS"] = true,
        ["deDE"] = "Winterhauchfest",
        ["esES"] = "Festival de Invierno",
        ["esMX"] = "Festival de Invierno",
        ["frFR"] = "Voile d'hiver",
        ["koKR"] = "겨울맞이 축제",
        ["ptBR"] = "Véu de Inverno",
        ["ruRU"] = "Зимний Покров",
        ["zhCN"] = "冬幕节",
        ["zhTW"] = "冬幕節",
    },
    ["Ahn'Qiraj War"] = {
        ["enUS"] = true,
        ["deDE"] = "Krieg von Ahn'Qiraj",
        ["esES"] = "Guerra de Ahn'Qiraj",
        ["esMX"] = "Guerra de Ahn'Qiraj",
        ["frFR"] = "Guerre d'Ahn'Qiraj",
        ["koKR"] = "안퀴라즈 전쟁",
        ["ptBR"] = "Guerra de Ahn'Qiraj",
        ["ruRU"] = "Ан'киражская война",
        ["zhCN"] = "安其拉战争",
        ["zhTW"] = "安其拉之戰",
    },
    ["Seasonal"] = {
        ["enUS"] = true,
        ["deDE"] = "Saisonbedingt",
        ["esES"] = "Estacional",
        ["esMX"] = "Estacional",
        ["frFR"] = "Saisonnier",
        ["koKR"] = "이벤트",
        ["ptBR"] = "Sazonal",
        ["ruRU"] = "Сезонные",
        ["zhCN"] = "季节性",
        ["zhTW"] = "季節性",
    },
    ["Invasion"] = {
        ["enUS"] = true,
        ["deDE"] = "Invasion der Geißel",
        ["esES"] = "Invasión",
        ["esMX"] = "Invasión",
        ["frFR"] = true,
        ["koKR"] = "침공",
        ["ptBR"] = "Invasão",
        ["ruRU"] = "Вторжение",
        ["zhCN"] = "天灾入侵",
        ["zhTW"] = "入侵",
    },
    ["Firelands Invasion"] = {
        ["enUS"] = true,
        ["deDE"] = "Einmarsch in die Feuerlande",
        ["esES"] = "Invasión de las Tierras de Fuego",
        ["esMX"] = "Invasión de las Tierras de Fuego",
        ["frFR"] = "Invasion des terres de Feu",
        ["koKR"] = "불의 땅 침공",
        ["ptBR"] = "Invasão às Terras do Fogo",
        ["ruRU"] = "Вторжение на Огненные Просторы",
        ["zhCN"] = "进攻火焰之地",
        ["zhTW"] = "火源之界進軍行動",
    },
    ["The Zandalari"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Zandalari",
        ["esES"] = "Los Zandalari",
        ["esMX"] = "Los Zandalari",
        ["frFR"] = "Les Zandalari",
        ["koKR"] = "잔달라 부족",
        ["ptBR"] = "Os Zandalari",
        ["ruRU"] = "Племя Зандалар",
        ["zhCN"] = "赞达拉",
        ["zhTW"] = "贊達拉",
    },
    ["Elemental Bonds"] = {
        ["enUS"] = true,
        ["deDE"] = "Elementare Bande",
        ["esES"] = "Vínculos elementales",
        ["esMX"] = "Vínculos elementales",
        ["frFR"] = "Liens élémentaires",
        ["koKR"] = "정령의 속박",
        ["ptBR"] = "Prisão elemental",
        ["ruRU"] = "Власть стихий",
        ["zhCN"] = "元素誓约",
        ["zhTW"] = "元素桎梏",
    },
    ["Pet Battle"] = {
        ["enUS"] = true,
        ["deDE"] = "Haustierkampf",
        ["esES"] = "Duelo de mascotas",
        ["esMX"] = "Duelo de mascotas",
        ["frFR"] = "Combat de mascottes",
        ["koKR"] = "애완동물 대전",
        ["ptBR"] = "Batalha de Mascotes",
        ["ruRU"] = "Битва питомцев",
        ["zhCN"] = "宠物对战",
        ["zhTW"] = "寵物對戰",
    },
    ["Proving Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Feuerprobe",
        ["esES"] = "Terreno de Pruebas",
        ["esMX"] = "Terreno de Pruebas",
        ["frFR"] = "L’Ordalie",
        ["koKR"] = "수련의 장",
        ["ptBR"] = "Campo de Testes",
        ["ruRU"] = "Арена испытаний",
        ["zhCN"] = "试炼场",
        ["zhTW"] = "試煉場",
    },
    ["Nightmare Incursions"] = {
        ["enUS"] = true,
        ["deDE"] = "Alptraumeinfälle",
        ["esES"] = "Incursiones de la Pesadilla",
        ["esMX"] = "Incursiones de la Pesadilla",
        ["frFR"] = "Incursions de cauchemar",
        ["koKR"] = "악몽 침공지",
        ["ptBR"] = "Incursões Pesadelares",
        ["ruRU"] = "Кошмарные вторжения",
        ["zhCN"] = "梦魇进犯",
        ["zhTW"] = "梦魇进犯",
    },
    ["Blackrock Eruption"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ausbruch des Schwarzfels",
        ["esES"] = "La Erupción de Roca Negra",
        ["esMX"] = "La erupción de Roca Negra",
        ["frFR"] = "L'éruption de Blackrock",
        ["koKR"] = "검은바위 분출",
        ["ptBR"] = "A Erupção da Rocha Negra",
        ["ruRU"] = "Извержение Черной горы",
        ["zhCN"] = "黑石山爆发",
        ["zhTW"] = "黑石山爆发",
    },
    ["Day of the Dead"] = {
        ["enUS"] = true,
        ["deDE"] = "Tag der Toten",
        ["esES"] = "Festividad de los Muertos",
        ["esMX"] = "Festividad de los Muertos",
        ["frFR"] = "Jour des morts",
        ["koKR"] = "망자의 날",
        ["ptBR"] = "Dia dos Mortos",
        ["ruRU"] = "День мертвых",
        ["zhCN"] = "悼念日",
        ["zhTW"] = "亡者節",
    },
    ["Darkmoon Island"] = {
        ["enUS"] = true,
        ["deDE"] = "Dunkelmondinsel",
        ["esES"] = "Isla Luna Negra",
        ["esMX"] = "Isla Luna Negra",
        ["frFR"] = "Île de Sombrelune",
        ["koKR"] = "다크문 섬",
        ["ptBR"] = "Ilha de Negraluna",
        ["ruRU"] = "Остров Новолуния",
        ["zhCN"] = "暗月岛",
        ["zhTW"] = "暗月島",
    },
    ["Riding"] = {
        ["enUS"] = true,
        ["deDE"] = "Reiten",
        ["esES"] = "Equitación",
        ["esMX"] = "Equitación",
        ["frFR"] = "Monte",
        ["koKR"] = "탈것 타기",
        ["ptBR"] = "Montaria",
        ["ruRU"] = "Верховая езда",
        ["zhCN"] = "骑术",
        ["zhTW"] = "騎術",
    },
    ["Brawler's Guild"] = {
        ["enUS"] = true,
        ["deDE"] = "Kampfgilde",
        ["esES"] = "Hermandad de camorristas",
        ["esMX"] = "Gremio de luchadores",
        ["frFR"] = "Les Bastonneurs",
        ["koKR"] = "싸움꾼 조합",
        ["ptBR"] = "Guilda dos Brigões",
        ["ruRU"] = "Бойцовская гильдия",
        ["zhCN"] = "搏击俱乐部",
        ["zhTW"] = "鬥陣俱樂部",
    },
}

for k, v in pairs(eventsLocales) do
    l10n.translations[k] = v
end
