---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local questsByZoneLocales = {
    ["Quests by Zone"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests pro Zone",
        ["esES"] = "Misiones por zona",
        ["esMX"] = "Misiones por zona",
        ["frFR"] = "Quêtes par zone",
        ["koKR"] = "지역별 퀘스트",
        ["ptBR"] = "Missões por zona",
        ["ruRU"] = "Задания по игровым зонам",
        ["zhCN"] = "按地区查寻",
        ["zhTW"] = "依區域查看",
    },
    ["Select Continent and Zone"] = {
        ["enUS"] = true,
        ["deDE"] = "Kontinent und Zone wählen",
        ["esES"] = "Seleccionar continente y zona",
        ["esMX"] = "Seleccionar continente y zona",
        ["frFR"] = "Sélectionner le continent et la zone",
        ["koKR"] = "대륙과 지역을 선택해주세요",
        ["ptBR"] = "Selecionar continente e zona",
        ["ruRU"] = "Выберите континент и игровую зону",
        ["zhCN"] = "选择大陆与区域",
        ["zhTW"] = "選擇大陸和區域",
    },
    ["Select Continent"] = {
        ["enUS"] = true,
        ["deDE"] = "Kontinent wählen",
        ["esES"] = "Seleccionar continente",
        ["esMX"] = "Seleccionar continente",
        ["frFR"] = "Sélectionner le continent",
        ["koKR"] = "대륙 선택",
        ["ptBR"] = "Selecionar continente",
        ["ruRU"] = "Выберите континент",
        ["zhCN"] = "选择大陆",
        ["zhTW"] = "選擇大陸",
    },
    ["Select Zone"] = {
        ["enUS"] = true,
        ["deDE"] = "Zone wählen",
        ["esES"] = "Seleccionar zona",
        ["esMX"] = "Seleccionar zona",
        ["frFR"] = "Sélectionner la zone",
        ["koKR"] = "지역 선택",
        ["ptBR"] = "Selecionar zona",
        ["ruRU"] = "Выберите игровую зону",
        ["zhCN"] = "选择区域",
        ["zhTW"] = "選擇區域",
    },
    ["Select Profession"] = {
        ["enUS"] = true,
        ["deDE"] = "Beruf wählen",
        ["esES"] = "Seleccionar profesión",
        ["esMX"] = "Seleccionar profesión",
        ["frFR"] = "Sélectionner la profession",
        ["koKR"] = "전문 기술 선택",
        ["ptBR"] = "Selecionar profissão",
        ["ruRU"] = "Выберите профессию",
        ["zhCN"] = "选择职业",
        ["zhTW"] = "選擇職業",
    },
    ["This quest is an automatic completion quest and does not contain an objective."] = {
        ["enUS"] = true,
        ["deDE"] = "Diese Quest schließt sich automatisch ab und beinhaltet keinerlei Ziele.",
        ["esES"] = "Esta misión se completa automaticamente y no contiene objetivos.",
        ["esMX"] = "Esta misión se completa automáticamente y no contiene objetivos.",
        ["frFR"] = "Cette quête est une quête d'achèvement automatique et ne contient pas d'objectif.",
        ["koKR"] = "이 퀘스트는 자동으로 완료되는 퀘스트라 표시할 퀘스트 목표가 없습니다.",
        ["ptBR"] = "Essa missão é uma missão de conclusão automática e não contém um objetivo.",
        ["ruRU"] = "Это задание выполняется автоматически и не содержит цели",
        ["zhCN"] = "此任务为自动完成任务，且不包含任何目标。",
        ["zhTW"] = "此任務為自動完成任務，且不包含任何目標。",
    },
    ["Zone Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Zonen-Quests",
        ["esES"] = "Misiones de zona",
        ["esMX"] = "Misiones de zona",
        ["frFR"] = "Quêtes de zone",
        ["koKR"] = "지역 퀘스트",
        ["ptBR"] = "Missões de zona",
        ["ruRU"] = "Задания выбранной игровой зоны",
        ["zhCN"] = "区域任务",
        ["zhTW"] = "區域任務",
    },
    ["Available Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Quests",
        ["esES"] = "Misiones disponibles",
        ["esMX"] = "Misiones disponibles",
        ["frFR"] = "Quêtes disponibles",
        ["koKR"] = "수행 가능한 퀘스트",
        ["ptBR"] = "Missões disponíveis",
        ["ruRU"] = "Доступные задания",
        ["zhCN"] = "可接受",
        ["zhTW"] = "可接的任務",
    },
    ["Completed Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Quests",
        ["esES"] = "Misiones completadas",
        ["esMX"] = "Misiones completadas",
        ["frFR"] = "Quêtes terminées",
        ["koKR"] = "완료한 퀘스트",
        ["ptBR"] = "Missões concluídas",
        ["ruRU"] = "Выполненные задания",
        ["zhCN"] = "已完成",
        ["zhTW"] = "完成的任務",
    },
    ["Completed"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossen",
        ["esES"] = "Completada",
        ["esMX"] = "Completada",
        ["frFR"] = "Terminée",
        ["koKR"] = "완료",
        ["ptBR"] = "Concluída",
        ["ruRU"] = "выполнено",
        ["zhCN"] = "完成",
        ["zhTW"] = "已完成",
    },
    ["Repeatable Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Wiederholbare Quests",
        ["esES"] = "Misiones repetibles",
        ["esMX"] = "Misiones repetibles",
        ["frFR"] = "Quêtes répétables",
        ["koKR"] = "반복 퀘스트",
        ["ptBR"] = "Missões repetíveis",
        ["ruRU"] = "Повторяемые задания",
        ["zhCN"] = "可重复的任务",
        ["zhTW"] = "可重覆的任務",
    },
    ["Missing Pre Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Prequest fehlt",
        ["esES"] = "Falta misión requisita",
        ["esMX"] = "Falta misión requisita",
        ["frFR"] = "Pré-quête manquante",
        ["koKR"] = "선행 퀘스트 미수행",
        ["ptBR"] = "Faltando missão requisita",
        ["ruRU"] = "Необходимо предзадание",
        ["zhCN"] = "需要前置任务",
        ["zhTW"] = "需要前置任務",
    },
    ["Unobtainable Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Nicht abschließbare Quests",
        ["esES"] = "Misiones inobtenibles",
        ["esMX"] = "Misiones inobtenibles",
        ["frFR"] = "Quêtes impossibles à obtenir",
        ["koKR"] = "수행이 불가능한 퀘스트",
        ["ptBR"] = "Missões inalcançáveis",
        ["ruRU"] = "Недоступные задания",
        ["zhCN"] = "未完成的任务",
        ["zhTW"] = "無法取得的任務",
    },
    ["Pre Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Pre-Quests",
        ["esES"] = "Misiones requisitas",
        ["esMX"] = "Misiones requisitas",
        ["frFR"] = "Pré-Quêtes",
        ["koKR"] = "선행 퀘스트",
        ["ptBR"] = "Missões requisitas",
        ["ruRU"] = "Предзадание:",
        ["zhCN"] = "前置任务",
        ["zhTW"] = "前置任務",
    },
}

for k, v in pairs(questsByZoneLocales) do
    l10n.translations[k] = v
end
