---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local keyboardShortcutLocales = {
    ["Right Click"] = {
        ["enUS"] = true,
        ["deDE"] = "Rechtsklick",
        ["esES"] = "Clic derecho",
        ["esMX"] = "Clic derecho",
        ["frFR"] = "Clic Droit ",
        ["koKR"] = "오른쪽 클릭",
        ["ptBR"] = "Clique direito",
        ["ruRU"] = "ПКМ",
        ["zhCN"] = "右键",
        ["zhTW"] = "右鍵",
    },
    ["Left Click"] = {
        ["enUS"] = true,
        ["deDE"] = "Linksklick",
        ["esES"] = "Clic izquierdo",
        ["esMX"] = "Clic izquierdo",
        ["frFR"] = "Clic Gauche ",
        ["koKR"] = "왼쪽 클릭",
        ["ptBR"] = "Clique esquerdo",
        ["ruRU"] = "ЛКМ",
        ["zhCN"] = "左键",
        ["zhTW"] = "左鍵",
    },
    ["Alt"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Control"] = {
        ["enUS"] = true,
        ["deDE"] = "Strg",
        ["esES"] = "Ctrl",
        ["esMX"] = "Ctrl",
        ["frFR"] = "Ctrl",
        ["koKR"] = "Ctrl",
        ["ptBR"] = "Ctrl",
        ["ruRU"] = "Ctrl",
        ["zhCN"] = "Ctrl",
        ["zhTW"] = "Ctrl",
    },
    ["Ctrl + Left Click"] = {
        ["enUS"] = true,
        ["deDE"] = "Strg + Linksklick",
        ["esES"] = "Ctrl + Clic izquierdo",
        ["esMX"] = "Ctrl + Clic izquierdo",
        ["frFR"] = "Ctrl + Clic Gauche ",
        ["koKR"] = "Ctrl + 왼쪽 클릭",
        ["ptBR"] = "Ctrl + Clique esquerdo",
        ["ruRU"] = "Ctrl + ЛКМ",
        ["zhCN"] = "Ctrl + 左键",
        ["zhTW"] = "Ctrl + 左鍵",
    },
    ["Ctrl + Right Click"] = {
        ["enUS"] = true,
        ["deDE"] = "Strg + Rechtsklick",
        ["esES"] = "Ctrl + Clic derecho",
        ["esMX"] = "Ctrl + Clic derecho",
        ["frFR"] = "Ctrl + Clic Droit ",
        ["koKR"] = "Ctrl + 오른쪽 클릭",
        ["ptBR"] = "Ctrl + Clique direito",
        ["ruRU"] = "Ctrl + ПКМ",
        ["zhCN"] = "Ctrl + 右键",
        ["zhTW"] = "Ctrl + 右鍵",
    },
    ["Ctrl + Left Click + Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Strg + Linksklick + Halten",
        ["esES"] = "Ctrl + Clic izquierdo + Mantener",
        ["esMX"] = "Ctrl + Clic izquierdo + Mantener",
        ["frFR"] = "Ctrl + Clic Gauche + Maintenir",
        ["koKR"] = "Ctrl + 왼쪽 클릭 길게누르기",
        ["ptBR"] = "Ctrl + Clique esquerdo + Manter pressionado",
        ["ruRU"] = "Зажать Ctrl + ЛКМ",
        ["zhCN"] = "Ctrl +左键+保持",
        ["zhTW"] = "Ctrl + 長按左鍵",
    },
    ["Ctrl + Shift + Left Click"] = {
        ["enUS"] = true,
        ["deDE"] = "Strg + Shift + Linksklick",
        ["esES"] = "Ctrl + Mayús + Clic izquierdo",
        ["esMX"] = "Ctrl + Mayús + Clic izquierdo",
        ["frFR"] = "Ctrl + Maj + Clic Gauche ",
        ["koKR"] = "Ctrl + Shift + 왼쪽 클릭",
        ["ptBR"] = "Ctrl + Shift + Clique esquerdo",
        ["ruRU"] = "Ctrl + Shift + ЛКМ",
        ["zhCN"] = "Ctrl + Shift + 左键",
        ["zhTW"] = "Ctrl + Shift + 左鍵",
    },
    ["Shift + Left Click"] = {
        ["enUS"] = true,
        ["deDE"] = "Shift + Linksklick",
        ["esES"] = "Mayús + Clic izquierdo",
        ["esMX"] = "Mayús + Clic izquierdo",
        ["frFR"] = "Maj + Clic Gauche ",
        ["koKR"] = "Shift + 왼쪽 클릭",
        ["ptBR"] = "Shift + Clique esquerdo",
        ["ruRU"] = "Shift + ЛКМ",
        ["zhCN"] = "Shift + 左键",
        ["zhTW"] = "Shift + 左鍵",
    },
    ["Shift"] = {
        ["enUS"] = true,
        ["deDE"] = "Umschalt",
        ["esES"] = "Mayús",
        ["esMX"] = "Mayús",
        ["frFR"] = "Maj",
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Hold Shift"] = {
        ["enUS"] = true,
        ["deDE"] = "Shift halten",
        ["esES"] = "Mantener Mayús",
        ["esMX"] = "Mantener Mayús",
        ["frFR"] = "Maintenir Maj",
        ["koKR"] = "Shift 길게누르기",
        ["ptBR"] = "Manter Shift",
        ["ruRU"] = "Зажмите Shift",
        ["zhCN"] = "按住Shift查看更多",
        ["zhTW"] = "按住Shift",
    },
    ["Left Click + Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Linksklick + Halten",
        ["esES"] = "Clic izquierdo + Mantener",
        ["esMX"] = "Clic izquierdo + Mantener",
        ["frFR"] = "Clic Gauche + Maintenir",
        ["koKR"] = "왼쪽 클릭 길게누르기",
        ["ptBR"] = "Clique esquerdo + Manter pressionado",
        ["ruRU"] = "Зажать ЛКМ",
        ["zhCN"] = "左键单击并按住",
        ["zhTW"] = "按住左鍵",
    },
}

for k, v in pairs(keyboardShortcutLocales) do
    l10n.translations[k] = v
end
