---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local nameplateOptionsLocales = {
    ["Nameplates"] = {
        ["enUS"] = true,
        ["deDE"] = "Namensplaketten",
        ["esES"] = "Placas de nombre",
        ["esMX"] = "Placas de nombre",
        ["frFR"] = "Plaques de nom",
        ["koKR"] = "이름표",
        ["ptBR"] = "Placas de nome",
        ["ruRU"] = "Индикаторы здоровья",
        ["zhCN"] = "姓名板",
        ["zhTW"] = "名條",
    },
    ["Nameplate Icon Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Namensplaketten-Icon-Einstellungen",
        ["esES"] = "Opciones de icono de la placa de nombre",
        ["esMX"] = "Opciones de icono de la placa de nombre",
        ["frFR"] = "Options des icônes sur les plaques de nom",
        ["koKR"] = "이름표 아이콘 설정",
        ["ptBR"] = "Opções do ícone da placa de nome",
        ["ruRU"] = "Настройки индикаторов здоровья",
        ["zhCN"] = "姓名板图标选项",
        ["zhTW"] = "名條圖示選項",
    },
    ["Enable Nameplate Quest Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige Questziele an Namensplaketten",
        ["esES"] = "Activar objetivos de misión en placas de nombre",
        ["esMX"] = "Activar objetivos de misión en placas de nombre",
        ["frFR"] = "Afficher les icônes sur les plaques de nom",
        ["koKR"] = "퀘스트 목표 이름표에 아이콘 표시",
        ["ptBR"] = "Ativar objetivos da missão na placa de nome",
        ["ruRU"] = "Значки заданий на индикаторах здоровья",
        ["zhCN"] = "启用任务目标姓名板",
        ["zhTW"] = "啟用任務目標名條",
    },
    ["Enable or disable the quest objective icons over creature nameplates."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Questziele an den Namensplaketten der Kreaturen.",
        ["esES"] = "Activa o desactiva el icono de objetivo de misión en la placa de nombre de la criatura.",
        ["esMX"] = "Activa o desactiva el icono de objetivo de misión en la placa de nombre de la criatura.",
        ["frFR"] = "Active l'affichage des icônes d'objectif de quête sur les plaques de nom des monstres.",
        ["koKR"] = "퀘스트 목표 이름표에 아이콘을 표시할지 설정합니다.",
        ["ptBR"] = "Ativa ou desativa os ícones dos objectivos de missão nas placas de nome das criaturas.",
        ["ruRU"] = "Показать/скрыть значки целей заданий на индикаторах здоровья",
        ["zhCN"] = "启用或停用在生物姓名板上显示的任务目标图标。",
        ["zhTW"] = "啟用或停用在生物名條上顯示的任務目標圖示。",
    },
    ["Icon Position X"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon-Position X",
        ["esES"] = "Posición del icono X",
        ["esMX"] = "Posición del icono X",
        ["frFR"] = "Position de l'icône X",
        ["koKR"] = "아이콘 위치 X",
        ["ptBR"] = "Posição do ícone X",
        ["ruRU"] = "Позиция по оси X",
        ["zhCN"] = "图标X座标",
        ["zhTW"] = "圖示水平位置",
    },
    ["Where on the X axis the nameplate icon should be. ( Default: %s )"] = {
        ["enUS"] = true,
        ["deDE"] = "An welcher Stelle auf der X-Achse des anvisierten Ziels die Icons der Questziele angezeigt werden sollen. (Standard: %s)",
        ["esES"] = "La posicion del eje X del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["esMX"] = "La posicion del eje X del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["frFR"] = "Définis la position X des icônes sur la plaque de nom. (Par défaut : %s)",
        ["koKR"] = "대상 프레임에 표시할 아이콘의 X좌표를 설정합니다. (기본값: %s)",
        ["ptBR"] = "O ícone da placa de nome deve aparecer no ícone dos nomes da placa. (Padrão: %s)",
        ["ruRU"] = "Регулировка позиции значков по оси X (по умолчанию: %s)",
        ["zhCN"] = "图标锚点于目标头像的X座标（默认：%s）",
        ["zhTW"] = "名條圖示的水平方向位置。(預設值: %s)",
    },
    ["Icon Position Y"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon-Position Y",
        ["esES"] = "Posición del icono Y",
        ["esMX"] = "Posición del icono Y",
        ["frFR"] = "Position de l'icône Y",
        ["koKR"] = "아이콘 위치 Y",
        ["ptBR"] = "Posição do ícone Y",
        ["ruRU"] = "Позиция по оси Y",
        ["zhCN"] = "图标Y座标",
        ["zhTW"] = "圖示垂直位置",
    },
    ["Where on the Y axis the nameplate icon should be. ( Default: %s )"] = {
        ["enUS"] = true,
        ["deDE"] = "An welcher Stelle auf der Y-Achse des anvisierten Ziels die Icons der Questziele angezeigt werden sollen. (Standard: %s)",
        ["esES"] = "La posicion del eje Y del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["esMX"] = "La posicion del eje Y del marco de objetivo en la que debería estar el icono. (Predeterminado: %s)",
        ["frFR"] = "Définis la position Y des icônes sur la plaque de nom. (Par défaut : %s)",
        ["koKR"] = "대상 프레임에 표시할 아이콘의 Y좌표를 설정합니다. (기본값: %s)",
        ["ptBR"] = "O ícone da placa de nome deve aparecer no ícone de ordenadas. (Padrão: %s)",
        ["ruRU"] = "Регулировка позиции значков по оси Y (по умолчанию: %s)",
        ["zhCN"] = "图标锚点于目标头像的Y座标（默认：%s）",
        ["zhTW"] = "名條圖示的垂直方向位置。(預設值: %s)",
    },
    ["Nameplate Icon Scale"] = {
        ["enUS"] = true,
        ["deDE"] = "Skalierung der Namensplaketten-Icons",
        ["esES"] = "Escala del icono de la placa de nombre",
        ["esMX"] = "Escala del icono de la placa de nombre",
        ["frFR"] = "Échelle des icônes sur les plaques de nom",
        ["koKR"] = "이름표 아이콘 크기",
        ["ptBR"] = "Escala dos ícones da placa de nome",
        ["ruRU"] = "Размер значков",
        ["zhCN"] = "图标大小",
        ["zhTW"] = "名條圖示縮放大小",
    },
    ["Scale the size of the quest icons on creature nameplates. ( Default: %s )"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Quest-Icons an den Namensplaketten der Gegner sein sollen. (Standard: %s)",
        ["esES"] = "Define el tamaño del icono de misión en la placa de nombre de la criatura. (Predeterminado: %s)",
        ["esMX"] = "Define el tamaño del icono de misión en la placa de nombre de la criatura. (Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes d'objectif de quête sur les plaques de nom des monstres. (Par défaut : %s)",
        ["koKR"] = "퀘스트 목표 이름표에 표시할 아이콘의 크기를 설정합니다. (기본값: %s)",
        ["ptBR"] = "Mude o tamanho dos ícones da missão nas placas de nome das criaturas. (Padrão: %s)",
        ["ruRU"] = "Регулировка размера значков на индикаторах здоровья (по умолчанию: %s)",
        ["zhCN"] = "调整姓名板图标的缩放（默认：%s）",
        ["zhTW"] = "怪物名條上任務圖示的縮放大小。(預設值: %s)",
    },
    ["Reset Nameplates"] = {
        ["enUS"] = true,
        ["deDE"] = "Namensplaketten zurücksetzen",
        ["esES"] = "Restablecer placas de nombre",
        ["esMX"] = "Restablecer placas de nombre",
        ["frFR"] = "Réinit. plaques de nom",
        ["koKR"] = "이름표 초기화",
        ["ptBR"] = "Redefinir placas de nome",
        ["ruRU"] = "Сброс настроек",
        ["zhCN"] = "重设姓名版",
        ["zhTW"] = "重置名條",
    },
    ["Reset to default nameplate position and scale."] = {
        ["enUS"] = true,
        ["deDE"] = "Setzt die Position und Skalierung der Namensplaketten auf die Standardeinstellungen zurück.",
        ["esES"] = "Restablece el tamaño y la posición de la placa de nombre a valores predeterminados",
        ["esMX"] = "Restablece el tamaño y la posición de la placa de nombre a valores predeterminados",
        ["frFR"] = "Réinitialise les positions et l'échelle des icônes sur les plaques de nom à leurs valeurs par défaut.",
        ["koKR"] = "이름표 아이콘 위치와 크기를 기본값으로 초기화합니다.",
        ["ptBR"] = "Redefine as posições e a escala da placa de nome.",
        ["ruRU"] = "Сбросить настройки значков целей заданий на индикаторах здоровья к значениям по умолчанию",
        ["zhCN"] = "重设姓名板图标的位置和大小",
        ["zhTW"] = "重置成預設的名條位置和縮放大小。",
    },
    ["Target Frame Icon Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Ziel-Icon-Einstellungen",
        ["esES"] = "Opciones de icono del marco de objetivo",
        ["esMX"] = "Opciones de icono del marco de objetivo",
        ["frFR"] = "Options des icônes de le cadre de la cible",
        ["koKR"] = "대상 프레임 아이콘 설정",
        ["ptBR"] = "Opções de ícone do quadro de alvo",
        ["ruRU"] = "Настройки рамки цели",
        ["zhCN"] = "目标图标选项",
        ["zhTW"] = "目標頭像圖示選項",
    },
    ["Enable Target Frame Quest Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige Questziele am anvisierten Ziel",
        ["esES"] = "Activar objetivos de misión en el marco de objetivo",
        ["esMX"] = "Activar objetivos de misión en el marco de objetivo",
        ["frFR"] = "Activer les icônes d'objectif de quête sur le cadre de la cible",
        ["koKR"] = "퀘스트 목표 대상 프레임에 아이콘 표시",
        ["ptBR"] = "Ativar objetivos de missão no quadro de alvo",
        ["ruRU"] = "Значки заданий на рамке цели",
        ["zhCN"] = "启用任务目标目标框体",
        ["zhTW"] = "啟用任務目標目標框架",
    },
    ["Enable or disable the quest objective icons over creature target frame."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Anzeige der Questziele am anvisierten Ziel.",
        ["esES"] = "Activa o desactiva el icono de objetivo de mision en el marco de objetivo.",
        ["esMX"] = "Activa o desactiva el icono de objetivo de mision en el marco de objetivo.",
        ["frFR"] = "Active l'affichage des icônes d'objectif de quête sur le cadre de la cible.",
        ["koKR"] = "퀘스트 목표 대상 프레임에 아이콘을 표시할지 설장합니다.",
        ["ptBR"] = "Ativa ou desativa o ícone de objetivo de missão no quadro de alvo da criatura.",
        ["ruRU"] = "Показать/скрыть значки целей заданий на рамке выбранной цели",
        ["zhCN"] = "启用或停用在生物目标框体上显示的任务目标图标。",
        ["zhTW"] = "啟用或停用在生物目標框架上顯示的任務目標圖示。",
    },
    ["Reset Target Frame"] = {
        ["enUS"] = true,
        ["deDE"] = "Zielanzeige zurücksetzen",
        ["esES"] = "Restablecer marco de objetivo",
        ["esMX"] = "Restablecer marco de objetivo",
        ["frFR"] = "Réinit. cadre de cible",
        ["koKR"] = "대상 프레임 초기화",
        ["ptBR"] = "Redefinir quadro de alvo",
        ["ruRU"] = "Сброс настроек",
        ["zhCN"] = "重设目标头像",
        ["zhTW"] = "重置目標頭像",
    },
    ["Reset to default target frame position and scale."] = {
        ["enUS"] = true,
        ["deDE"] = "Setzt die Position und Skalierung der Icons am anvisierten Ziel zurück.",
        ["esES"] = "Restablece el tamaño y la posición del marco de objetivo a los valores predeterminados.",
        ["esMX"] = "Restablece el tamaño y la posición del marco de objetivo a los valores predeterminados.",
        ["frFR"] = "Réinitialise les positions et l'échelle des icônes sur le cadre de la cible à leurs valeurs par défaut.",
        ["koKR"] = "대상 프레임 아이콘 위치와 크기를 기본값으로 초기화합니다.",
        ["ptBR"] = "Redefine as posições e a escala do quadro de destino padrão.",
        ["ruRU"] = "Сбросить настройки значков целей заданий на рамке выбранной цели к значениям по умолчанию",
        ["zhCN"] = "重设目标头像的位置和大小",
        ["zhTW"] = "重置成預設的目標頭像框架位置和縮放大小。",
    },
}

for k, v in pairs(nameplateOptionsLocales) do
    l10n.translations[k] = v
end
