---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local soundsOptionsLocales = {
    ["Sounds"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Sonidos",
        ["esMX"] = "Sonidos",
        ["frFR"] = "Sons",
        ["koKR"] = "사운드",
        ["ptBR"] = "Sons",
        ["ruRU"] = "Звуки",
        ["zhCN"] = "音效",
        ["zhTW"] = "音效",
    },
    ["Load custom sounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Custom Sounds laden",
        ["esES"] = "Cargar sonidos personalizados",
        ["esMX"] = "Cargar sonidos personalizados",
        ["frFR"] = "Charger les sons personnalisés",
        ["koKR"] = "사용자 지정 사운드 불러오기",
        ["ptBR"] = "Carregar sons personalizados",
        ["ruRU"] = "Пользовательские звуки",
        ["zhCN"] = "加载自定义声音",
        ["zhTW"] = "載入自訂音效",
    },
    ["When this is enabled, sounds added through LibSharedMedia are loaded."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist, werden Custom Sounds geladen, die über LibSharedMedia hinzugefügt wurden.",
        ["esES"] = "Si está activado, los sonidos añadidos a través de LibSharedMedia estarán cargados.",
        ["esMX"] = "Si está activado, los sonidos añadidos a través de LibSharedMedia estarán cargados.",
        ["frFR"] = "Si cette option est activée, les sons du LibSharedMedia sont chargés.",
        ["koKR"] = "이 옵션을 활성화하면 LibSharedMedia를 통해 추가된 사운드가 로드됩니다.",
        ["ptBR"] = "Se ativado, os sons adicionados através do LibSharedMedia são carregados.",
        ["ruRU"] = "Когда включено, загружаются звуки, добавленные через LibSharedMedia",
        ["zhCN"] = "启用时，通过 LibSharedMedia 添加的声音将会被加载。",
        ["zhTW"] = "啟用時，會載入透過 LibSharedMedia 加入的音效。",
    },
    ["Play a short sound when completing a quest when it is ready to turn in."] = {
        ["enUS"] = true,
        ["deDE"] = "Spielt einen kurzen Ton, wenn eine Quest fertig ist und abgegeben werden kann.",
        ["esES"] = "Reproduce un sonido corto al completar una misión.",
        ["esMX"] = "Reproduce un sonido corto al completar una misión.",
        ["frFR"] = "Jouer un court son lorsqu'une quête est terminée.",
        ["koKR"] = "퀘스트가 완료되어 제출할 준비가 되었을 때 짧은 사운드를 재생합니다.",
        ["ptBR"] = "Reproduz um som curto ao concluir uma missão.",
        ["ruRU"] = "Воспроизводить короткий звук при выполнении задания, обозначая готовность его сдачи",
        ["zhCN"] = "完成任务可以接回的时候播放音效。",
        ["zhTW"] = "完成任務可以接回的時候播放音效。",
    },
    ["Quest objective completed"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Ziel abgeschlossen",
        ["esES"] = "Objetivo de misión completado",
        ["esMX"] = "Objetivo de misión completado",
        ["frFR"] = "Objectif de quête terminé",
        ["koKR"] = "퀘스트 목표 완료",
        ["ptBR"] = "Objetivo de missão concluído",
        ["ruRU"] = "Цель задания выполнена",
        ["zhCN"] = "任务目标已完成",
        ["zhTW"] = "任務目標已完成",
    },
    ["Play a short sound when completing a quest objective."] = {
        ["enUS"] = true,
        ["deDE"] = "Spielt einen kurzen Ton, wenn ein Quest-Ziel abgeschlossen ist.",
        ["esES"] = "Reproduce un sonido corto al completar un objetivo de misión.",
        ["esMX"] = "Reproduce un sonido corto al completar un objetivo de misión.",
        ["frFR"] = "Jouer un court son lorsqu'un objectif de quête est terminé.",
        ["koKR"] = "퀘스트 목표 완료 시 짧은 사운드를 재생합니다.",
        ["ptBR"] = "Reproduz um som curto ao concluir um objetivo de missão.",
        ["ruRU"] = "Воспроизводить короткий звук при выполнении цели задания",
        ["zhCN"] = "完成任务目标时播放短音效。",
        ["zhTW"] = "完成任務目標時播放短音效。",
    },
    ["Quest Complete Sound Selection"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest abgeschlossen",
        ["esES"] = "Sonido al completar misión",
        ["esMX"] = "Sonido al completar misión",
        ["frFR"] = "Son de terminaison de quête",
        ["koKR"] = "퀘스트 완료 사운드 선택",
        ["ptBR"] = "Som ao concluir missão",
        ["ruRU"] = "Выбор звука",
        ["zhCN"] = "选择任务完成音效",
        ["zhTW"] = "選擇任務完成音效",
    },
    ["The sound you hear when a quest is completed"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ton, der abgespielt wird, wenn eine Quest abgeschlossen ist.",
        ["esES"] = "El sonido cuando se completa una misión.",
        ["esMX"] = "El sonido cuando se completa una misión.",
        ["frFR"] = "Le son que vous entendez lorsque qu'une quête est terminée.",
        ["koKR"] = "퀘스트가 완료되었을 때 재생되는 사운드",
        ["ptBR"] = "O som quando uma missão é concluída.",
        ["ruRU"] = "Звук при выполнении задания",
        ["zhCN"] = "任务完成时听到的音效。",
        ["zhTW"] = "任務完成時聽到的音效。",
    },
    ["Objective Complete Sound Selection"] = {
        ["enUS"] = true,
        ["deDE"] = "Ton für Quest-Ziel abgeschlossen",
        ["esES"] = "Sonido al completar objetivo",
        ["esMX"] = "Sonido al completar objetivo",
        ["frFR"] = "Son de terminaison d'objectif",
        ["koKR"] = "목표 완료 사운드 선택",
        ["ptBR"] = "Som ao concluir objetivo",
        ["ruRU"] = "Выбор звука",
        ["zhCN"] = "目标完成音效选择",
        ["zhTW"] = "目標完成音效選擇",
    },
    ["The sound you hear when an objective is completed"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ton, der abgespielt wird, wenn ein Quest-Ziel abgeschlossen ist.",
        ["esES"] = "El sonido cuando se completa un objetivo.",
        ["esMX"] = "El sonido cuando se completa un objetivo.",
        ["frFR"] = "Le son que vous entendez lorsque qu'un objectif est terminé.",
        ["koKR"] = "목표가 완료되었을 때 재생되는 사운드",
        ["ptBR"] = "O som quando um objetivo é concluído.",
        ["ruRU"] = "Звук при выполнении цели задания",
        ["zhCN"] = "当目标完成时所听到的音效",
        ["zhTW"] = "當目標完成時所聽到的音效",
    },
    ["Quest objective progress"] = {
        ["enUS"] = true,
        ["deDE"] = "Ton für Quest-Ziel-Fortschritte",
        ["esES"] = "Progreso del objetivo",
        ["esMX"] = "Progreso del objetivo",
        ["frFR"] = "Progression de l'objectif",
        ["koKR"] = "퀘스트 목표 진행",
        ["ptBR"] = "Progresso do objetivo",
        ["ruRU"] = "Прогресс цели задания",
        ["zhCN"] = "任务目标进度",
        ["zhTW"] = "任務目標進度",
    },
    ["Play a short sound when making progress on a quest objective."] = {
        ["enUS"] = true,
        ["deDE"] = "Spielt einen kurzen Ton, beim Fortschritt eines Quest-Ziels.",
        ["esES"] = "Reproduce un sonido corto al avanzar en un objetivo de misión.",
        ["esMX"] = "Reproduce un sonido corto al avanzar en un objetivo de misión.",
        ["frFR"] = "Jouer un court son lorsqu'un progrès est réalisé sur un objectif de quête.",
        ["koKR"] = "퀘스트 목표 진행 시 짧은 사운드를 재생합니다.",
        ["ptBR"] = "Reproduz um som curto ao fazer progresso em um objetivo de missão.",
        ["ruRU"] = "Воспроизводить короткий звук при прогрессе цели задания",
        ["zhCN"] = "当任务目标取得进展时播放短音效。",
        ["zhTW"] = "當任務目標取得進展時播放短音效。",
    },
    ["Objective Progress Sound Selection"] = {
        ["enUS"] = true,
        ["deDE"] = "Ton für Quest-Ziel Fortschritt",
        ["esES"] = "Sonido al avanzar en un objetivo",
        ["esMX"] = "Sonido al avanzar en un objetivo",
        ["frFR"] = "Son de progression de l'objectif",
        ["koKR"] = "목표 진행 사운드 선택",
        ["ptBR"] = "Som de progresso do objetivo",
        ["ruRU"] = "Выбор звука",
        ["zhCN"] = "目标进度音效选择",
        ["zhTW"] = "目標進度音效選擇",
    },
    ["The sound you hear when you make progress on a quest objective"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ton, der abgespielt wird, wenn du Fortschritt bei einem Quest-Ziel machst.",
        ["esES"] = "El sonido cuando avanzas en un objetivo de misión.",
        ["esMX"] = "El sonido cuando avanzas en un objetivo de misión.",
        ["frFR"] = "Le son que vous entendez lorsque vous progressez sur un objectif de quête.",
        ["koKR"] = "퀘스트 목표 진행 시 재생되는 사운드",
        ["ptBR"] = "O som quando faz progresso em um objetivo de missão.",
        ["ruRU"] = "Звук при прогрессе цели задания",
        ["zhCN"] = "当你在任务目标上取得进展时所听到的音效",
        ["zhTW"] = "當你在任務目標上取得進展時所聽到的音效",
    },
    ["Progress Sound Delay"] = {
        ["enUS"] = true,
        ["deDE"] = "Fortschritts-Sound-Verzögerung",
        ["esES"] = "Retraso en el sonido de progreso",
        ["esMX"] = "Retraso en el sonido de progreso",
        ["frFR"] = "Délai du son de progression",
        ["koKR"] = "진행음 지연",
        ["ptBR"] = "Atraso no som de progresso",
        ["ruRU"] = "Задержка звука прогресса",
        ["zhCN"] = "延迟播放进度声音",
        ["zhTW"] = "延遲播放進度音效",
    },
    ["Delay (in seconds, default: %s) for playing objective progress and completion sounds. Increase this if you hear double sounds."] = {
        ["enUS"] = true,
        ["deDE"] = "Verzögerung (in Sekunden, Voreinstellung: %s) beim Abspielen von Quest-Ziel-Fortschritts-Sounds. Diesen Wert erhöhen, falls Sounds doppelt abgespielt werden.",
        ["esES"] = "Retraso (en segundos, predeterminado: %s) para reproducir los sonidos de progreso y completación de objetivos. Aumenta este valor si escuchas sonidos duplicados.",
        ["esMX"] = "Retraso (en segundos, predeterminado: %s) para reproducir los sonidos de progreso y completación de objetivos. Aumenta este valor si escuchas sonidos duplicados.",
        ["frFR"] = "Délai (en secondes, par défaut : %s) pour jouer les sons de progression et de terminaison des objectifs. Augmentez ce délai si vous entendez des sons doublés.",
        ["koKR"] = "퀘스트 목표 진행 및 완료 사운드를 재생할 때의 지연(초 단위, 기본값: %s)이 발생합니다. 소리가 두 번 재생되는 경우 이 설정을 늘립니다.",
        ["ptBR"] = "Atraso (em segundos, padrão: %s) para reproduzir os sons de progresso e conclusão dos objetivos. Aumente isso se ouvir sons duplicados.",
        ["ruRU"] = "Задержка (в секундах, по умолчанию: %s) для воспроизведения звуков прогресса и выполнения целей. Увеличьте это значение, если вы слышите двойные звуки",
        ["zhCN"] = "播放任务目标进度和完成音效的延迟（以秒为单位，默认：%s）。如果听到重复音效，请将此数值调高。",
        ["zhTW"] = "播放任務目標進度及完成音效的延遲（以秒為單位，預設：%s）。如果聽到重複音效，請將此數值調高。",
    },
}

for k, v in pairs(soundsOptionsLocales) do
    l10n.translations[k] = v
end
