---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local tooltipsUILocales = {
    ["You are on this quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Diese Quest ist für dich aktiv",
        ["esES"] = "Tienes esta misión",
        ["esMX"] = "Tienes esta misión",
        ["frFR"] = "Vous effectuez cette quête",
        ["koKR"] = "현재 진행중인 퀘스트",
        ["ptBR"] = "Você tem essa missão",
        ["ruRU"] = "У вас есть это задание",
        ["zhCN"] = "你正在进行这项任务",
        ["zhTW"] = "你正在進行這項任務",
    },
    ["You have not done this quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast diese Quest noch nicht abgeschlossen",
        ["esES"] = "No has completado esta misión",
        ["esMX"] = "No has completado esta misión",
        ["frFR"] = "Vous n'avez pas terminé cette quête",
        ["koKR"] = "아직 완료하지 않은 퀘스트",
        ["ptBR"] = "Você não fez esta missão",
        ["ruRU"] = "Вы не выполнили это задание",
        ["zhCN"] = "你并未完成这项任务",
        ["zhTW"] = "你並未完成這項任務",
    },
    ["Nearby"] = {
        ["enUS"] = true,
        ["deDE"] = "In der Nähe",
        ["esES"] = "Cerca de",
        ["esMX"] = "Cerca de",
        ["frFR"] = "Proche",
        ["koKR"] = "근처",
        ["ptBR"] = "Nas proximidades",
        ["ruRU"] = "Недалеко",
        ["zhCN"] = "附近",
        ["zhTW"] = "附近",
    },
    ["Requirements"] = {
        ["enUS"] = true,
        ["deDE"] = "Voraussetzungen",
        ["esES"] = "Requisitos",
        ["esMX"] = "Requisitos",
        ["frFR"] = "Requises",
        ["koKR"] = "요구사항",
        ["ptBR"] = "Requisitos",
        ["ruRU"] = "Требуется",
        ["zhCN"] = "需求",
        ["zhTW"] = "需求",
    },
    ["You are ineligible for this quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Du kannst diese Quest nicht annehmen",
        ["esES"] = "No eres elegible para esta misión",
        ["esMX"] = "No eres elegible para esta misión",
        ["frFR"] = "Vous n'êtes pas éligible pour cette quête",
        ["koKR"] = "이 퀘스트를 받을 자격이 없습니다",
        ["ptBR"] = "Você não é elegível para esta missão",
        ["ruRU"] = "Это задание вам недоступно",
        ["zhCN"] = "你无法进行这项任务",
        ["zhTW"] = "你無法進行這項任務",
    },
    ["This quest is repeatable"] = {
        ["enUS"] = true,
        ["deDE"] = "Diese Quest ist wiederholbar",
        ["esES"] = "Esta misión es repetible.",
        ["esMX"] = "Esta misión es repetible",
        ["frFR"] = "Cette quête est répétable",
        ["koKR"] = "반복 가능한 퀘스트",
        ["ptBR"] = "Essa missão é repetível",
        ["ruRU"] = "Это повторяемое задание",
        ["zhCN"] = "这个任务可以重复完成",
        ["zhTW"] = "這任務可被重複進行",
    },
    ["Your progress"] = {
        ["enUS"] = true,
        ["deDE"] = "Dein Fortschritt",
        ["esES"] = "Progreso",
        ["esMX"] = "Progreso",
        ["frFR"] = "Progression",
        ["koKR"] = "현재 진행상태",
        ["ptBR"] = "Progresso",
        ["ruRU"] = "Ваш прогресс",
        ["zhCN"] = "你的进度",
        ["zhTW"] = "你的進度",
    },
    ["You have completed this quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Du hast diese Quest bereits abgeschlossen",
        ["esES"] = "Ya has completado esta misión",
        ["esMX"] = "Ya has completado esta misión",
        ["frFR"] = "Vous avez terminé cette quête",
        ["koKR"] = "완료된 퀘스트",
        ["ptBR"] = "Você concluiu esta missão",
        ["ruRU"] = "Вы выполнили это задание",
        ["zhCN"] = "你已完成这项任务",
        ["zhTW"] = "你已完成這項任務",
    },
    ["Started by"] = {
        ["enUS"] = true,
        ["deDE"] = "Gestarted von",
        ["esES"] = "Iniciado por",
        ["esMX"] = "Iniciado por",
        ["frFR"] = "Début ",
        ["koKR"] = "시작",
        ["ptBR"] = "Iniciado por",
        ["ruRU"] = "Начинает",
        ["zhCN"] = "任务开始于",
        ["zhTW"] = "任務開始於",
    },
    ["Ended by"] = {
        ["enUS"] = true,
        ["deDE"] = "Beendet von",
        ["esES"] = "Finalizado por",
        ["esMX"] = "Finalizado por",
        ["frFR"] = "Fin ",
        ["koKR"] = "끝",
        ["ptBR"] = "Terminado por",
        ["ruRU"] = "Завершает",
        ["zhCN"] = "任务结束于",
        ["zhTW"] = "任務結束於",
    },
    ["Completed on:"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossen am",
        ["esES"] = "Completado el:",
        ["esMX"] = "Completado el:",
        ["frFR"] = "Terminé le :",
        ["koKR"] = "완료",
        ["ptBR"] = "Concluído em:",
        ["ruRU"] = "Выполнено:",
        ["zhCN"] = "完成于:",
        ["zhTW"] = "已完成:",
    }
}

for k, v in pairs(tooltipsUILocales) do
    l10n.translations[k] = v
end
