---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local dungeonLocales = {
    ["Dire Maul"] = {
        ["enUS"] = true,
        ["deDE"] = "Düsterbruch",
        ["esES"] = "La Masacre",
        ["esMX"] = "La Masacre",
        ["frFR"] = "Hache-tripes",
        ["koKR"] = "혈투의 전장",
        ["ptBR"] = "Gládio Cruel",
        ["ruRU"] = "Забытый Город",
        ["zhCN"] = "厄运之槌",
        ["zhTW"] = "厄運之槌",
    },
    ["Auchenai Crypts"] = {
        ["enUS"] = true,
        ["deDE"] = "Auchenaikrypta",
        ["esES"] = "Criptas Auchenai",
        ["esMX"] = "Criptas Auchenai",
        ["frFR"] = "Cryptes Auchenaï",
        ["koKR"] = "아키나이 납골당",
        ["ptBR"] = "Catacumbas Auchenai",
        ["ruRU"] = "Аукенайские гробницы",
        ["zhCN"] = "奥金尼地穴",
        ["zhTW"] = "奧奇奈地穴",
    },
    ["Blackrock Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Blackrockspitze",
        ["esES"] = "Cumbre de Roca Negra",
        ["esMX"] = "Cumbre de Roca Negra",
        ["frFR"] = "Pic Rochenoire",
        ["koKR"] = "검은바위 첨탑",
        ["ptBR"] = "Pico da Rocha Negra",
        ["ruRU"] = "Вершина Черной Горы",
        ["zhCN"] = "黑石塔",
        ["zhTW"] = "黑石塔",
    },
    ["Upper Blackrock Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Obere Schwarzfelsspitze",
        ["esES"] = "Cumbre de Roca Negra Superior",
        ["esMX"] = "Cumbre de Roca Negra Superior",
        ["frFR"] = "Sommet du pic Rochenoire",
        ["koKR"] = "검은바위 첨탑 상층",
        ["ptBR"] = "Pico da Rocha Negra Superior",
        ["ruRU"] = "Верхняя часть пика Черной горы",
        ["zhCN"] = "黑石塔上层",
        ["zhTW"] = "黑石塔上層",
    },
    ["Lower Blackrock Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Untere Schwarzfelsspitze",
        ["esES"] = "Cumbre de Roca Negra Inferior",
        ["esMX"] = "Cumbre de Roca Negra Inferior",
        ["frFR"] = "Bas du pic Rochenoire",
        ["koKR"] = "검은바위 첨탑 하층",
        ["ptBR"] = "Pico da Rocha Negra Inferior",
        ["ruRU"] = "Нижняя часть пика Черной горы",
        ["zhCN"] = "黑石塔下层",
        ["zhTW"] = "黑石塔下層",
    },
    ["Old Hillsbrad Foothills"] = {
        ["enUS"] = true,
        ["deDE"] = "Vorgebirge des Alten Hügellands",
        ["esES"] = "Antiguas Laderas de Trabalomas",
        ["esMX"] = "Antiguas Laderas de Trabalomas",
        ["frFR"] = "Contreforts de Hautebrande d'antan",
        ["koKR"] = "옛 힐스브래드 구릉지",
        ["ptBR"] = "Antigo Contraforte de Eira dos Montes",
        ["ruRU"] = "Старые предгорья Хилсбрада",
        ["zhCN"] = "旧希尔斯布莱德丘陵",
        ["zhTW"] = "希爾斯布萊德丘陵舊址",
    },
    ["Scarlet Monastery"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Scharlachrote Kloster",
        ["esES"] = "Monasterio Escarlata",
        ["esMX"] = "Monasterio Escarlata",
        ["frFR"] = "Monastère écarlate",
        ["koKR"] = "붉은십자군 수도원",
        ["ptBR"] = "Monastério Escarlate",
        ["ruRU"] = "Монастырь Алого Ордена",
        ["zhCN"] = "血色修道院",
        ["zhTW"] = "血色修道院",
    },
    ["The Underbog"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Tiefensumpf",
        ["esES"] = "La Sotiénaga",
        ["esMX"] = "La Sotiénaga",
        ["frFR"] = "La Basse-tourbière",
        ["koKR"] = "지하수렁",
        ["ptBR"] = "Brejo Oculto",
        ["ruRU"] = "Нижетопь",
        ["zhCN"] = "幽暗沼泽",
        ["zhTW"] = "深幽泥沼",
    },
    ["The Black Morass"] = {
        ["enUS"] = true,
        ["deDE"] = "Der schwarze Morast",
        ["esES"] = "La Ciénaga Negra",
        ["esMX"] = "La Ciénaga Negra",
        ["frFR"] = "Le Noir Marécage",
        ["koKR"] = "검은늪",
        ["ptBR"] = "Lamaçal Negro",
        ["ruRU"] = "Черные топи",
        ["zhCN"] = "黑色沼泽",
        ["zhTW"] = "黑色沼澤",
    },
    ["Maraudon"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "마라우돈",
        ["ptBR"] = true,
        ["ruRU"] = "Марадон",
        ["zhCN"] = "玛拉顿",
        ["zhTW"] = "瑪拉頓",
    },
    ["Hellfire Ramparts"] = {
        ["enUS"] = true,
        ["deDE"] = "Höllenfeuerbollwerk",
        ["esES"] = "Murallas del Fuego Infernal",
        ["esMX"] = "Murallas del Fuego Infernal",
        ["frFR"] = "Remparts des Flammes infernales",
        ["koKR"] = "지옥불 성루",
        ["ptBR"] = "Muralha Fogo do Inferno",
        ["ruRU"] = "Бастионы Адского Пламени",
        ["zhCN"] = "地狱火城墙",
        ["zhTW"] = "地獄火壁壘",
    },
    ["Stratholme"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "스트라솔룸",
        ["ptBR"] = true,
        ["ruRU"] = "Стратхольм",
        ["zhCN"] = "斯坦索姆",
        ["zhTW"] = "斯坦索姆",
    },
    ["Mana-Tombs"] = {
        ["enUS"] = true,
        ["deDE"] = "Managruft",
        ["esES"] = "Tumbas de Maná",
        ["esMX"] = "Tumbas de Maná",
        ["frFR"] = "Tombes-mana",
        ["koKR"] = "마나 무덤",
        ["ptBR"] = "Tumbas de Mana",
        ["ruRU"] = "Гробницы маны",
        ["zhCN"] = "法力陵墓",
        ["zhTW"] = "法力墓地",
    },
    ["Wailing Caverns"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Höhlen des Wehklagens",
        ["esES"] = "Cuevas de los Lamentos",
        ["esMX"] = "Cuevas de los Lamentos",
        ["frFR"] = "Cavernes des lamentations",
        ["koKR"] = "통곡의 동굴",
        ["ptBR"] = "Caverna Ululante",
        ["ruRU"] = "Пещеры Стенаний",
        ["zhCN"] = "哀嚎洞穴",
        ["zhTW"] = "哀嚎洞穴",
    },
    ["Shadow Labyrinth"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenlabyrinth",
        ["esES"] = "Laberinto de las Sombras",
        ["esMX"] = "Laberinto de las Sombras",
        ["frFR"] = "Labyrinthe des ombres",
        ["koKR"] = "어둠의 미궁",
        ["ptBR"] = "Labirinto Soturno",
        ["ruRU"] = "Темный лабиринт",
        ["zhCN"] = "暗影迷宫",
        ["zhTW"] = "暗影迷宮",
    },
    ["Coilfang Reservoir"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Echsenkessel",
        ["esES"] = "Reserva Colmillo Torcido",
        ["esMX"] = "Reserva Colmillo Torcido",
        ["frFR"] = "Réservoir de Glissecroc",
        ["koKR"] = "갈퀴송곳니 저수지",
        ["ptBR"] = "Reservatório Presacurva",
        ["ruRU"] = "Резервуар Кривого Клыка",
        ["zhCN"] = "盘牙水库",
        ["zhTW"] = "盤牙蓄湖",
    },
    ["Uldaman"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "울다만",
        ["ptBR"] = true,
        ["ruRU"] = "Ульдаман",
        ["zhCN"] = "奥达曼",
        ["zhTW"] = "奧達曼",
    },
    ["The Deadmines"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Todesminen",
        ["esES"] = "Las Minas de la Muerte",
        ["esMX"] = "Las Minas de la Muerte",
        ["frFR"] = "Les Mortemines",
        ["koKR"] = "죽음의 폐광",
        ["ptBR"] = "Minas Mortas",
        ["ruRU"] = "Мертвые Копи",
        ["zhCN"] = "死亡矿井",
        ["zhTW"] = "死亡礦坑",
    },
    ["Sethekk Halls"] = {
        ["enUS"] = true,
        ["deDE"] = "Sethekkhallen",
        ["esES"] = "Salas Sethekk",
        ["esMX"] = "Salas Sethekk",
        ["frFR"] = "Les salles des Sethekk",
        ["koKR"] = "세데크 전당",
        ["ptBR"] = "Salões dos Sethekk",
        ["ruRU"] = "Сетеккские залы",
        ["zhCN"] = "塞泰克大厅",
        ["zhTW"] = "塞司克大廳",
    },
    ["Razorfen Downs"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Hügel von Razorfen",
        ["esES"] = "Zahúrda Rajacieno",
        ["esMX"] = "Zahúrda Rajacieno",
        ["frFR"] = "Souilles de Tranchebauge",
        ["koKR"] = "가시덩굴 구릉",
        ["ptBR"] = "Urzal dos Mortos",
        ["ruRU"] = "Курганы Иглошкурых",
        ["zhCN"] = "剃刀高地",
        ["zhTW"] = "剃刀高地",
    },
    ["Scholomance"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "스칼로맨스",
        ["ptBR"] = "Scolomântia",
        ["ruRU"] = "Некроситет",
        ["zhCN"] = "通灵学院",
        ["zhTW"] = "通靈學院",
    },
    ["Ragefire Chasm"] = {
        ["enUS"] = true,
        ["deDE"] = "Flammenschlund",
        ["esES"] = "Sima Ígnea",
        ["esMX"] = "Sima Ígnea",
        ["frFR"] = "Gouffre de Ragefeu",
        ["koKR"] = "성난불길 협곡",
        ["ptBR"] = "Cavernas Ígneas",
        ["ruRU"] = "Огненная пропасть",
        ["zhCN"] = "怒焰裂谷",
        ["zhTW"] = "怒焰裂谷",
    },
    ["The Steamvault"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Dampfkammer",
        ["esES"] = "La Cámara de Vapor",
        ["esMX"] = "La Cámara de Vapor",
        ["frFR"] = "Le Caveau de la vapeur",
        ["koKR"] = "증기 저장고",
        ["ptBR"] = "Câmara dos Vapores",
        ["ruRU"] = "Паровое подземелье",
        ["zhCN"] = "蒸汽地窟",
        ["zhTW"] = "蒸汽洞窟",
    },
    ["Blackfathom Deeps"] = {
        ["enUS"] = true,
        ["deDE"] = "Tiefschwarze Grotte",
        ["esES"] = "Cavernas de Brazanegra",
        ["esMX"] = "Cavernas de Brazanegra",
        ["frFR"] = "Profondeurs de Brassenoire",
        ["koKR"] = "검은심연의 나락",
        ["ptBR"] = "Profundezas Negras",
        ["ruRU"] = "Непроглядная Пучина",
        ["zhCN"] = "黑暗深渊",
        ["zhTW"] = "黑澗深淵",
    },
    ["The Temple of Atal'Hakkar"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Tempel von Atal'Hakkar",
        ["esES"] = "El Templo de Atal'Hakkar",
        ["esMX"] = "El Templo de Atal'Hakkar",
        ["frFR"] = "Le temple d'Atal'Hakkar",
        ["koKR"] = "아탈학카르 신전",
        ["ptBR"] = "Templo de Atal'Hakkar",
        ["ruRU"] = "Храм Атал'Хаккар",
        ["zhCN"] = "阿塔哈卡神庙",
        ["zhTW"] = "阿塔哈卡神廟",
    },
    ["Sunken Temple"] = {
        ["enUS"] = true,
        ["deDE"] = "Versunkener Tempel",
        ["esES"] = "Templo Sumergido",
        ["esMX"] = "Templo Sumergido",
        ["frFR"] = "Temple englouti",
        ["koKR"] = "가라앉은 사원",
        ["ptBR"] = "Templo Submerso",
        ["ruRU"] = "Затонувший храм",
        ["zhCN"] = "沉没的神庙",
        ["zhTW"] = "沉沒的神廟",
    },
    ["Caverns of Time"] = {
        ["enUS"] = true,
        ["deDE"] = "Höhlen der Zeit",
        ["esES"] = "Cavernas del Tiempo",
        ["esMX"] = "Cavernas del Tiempo",
        ["frFR"] = "Grottes du temps",
        ["koKR"] = "시간의 동굴",
        ["ptBR"] = "Cavernas do Tempo",
        ["ruRU"] = "Пещеры Времени",
        ["zhCN"] = "时光之穴",
        ["zhTW"] = "時光之穴",
    },
    ["The Blood Furnace"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Blutkessel",
        ["esES"] = "El Horno de Sangre",
        ["esMX"] = "El Horno de Sangre",
        ["frFR"] = "La Fournaise du sang",
        ["koKR"] = "피의 용광로",
        ["ptBR"] = "Fornalha de Sangue",
        ["ruRU"] = "Кузня Крови",
        ["zhCN"] = "鲜血熔炉",
        ["zhTW"] = "血熔爐",
    },
    ["Shadowfang Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Burg Shadowfang",
        ["esES"] = "Castillo de Colmillo Oscuro",
        ["esMX"] = "Castillo de Colmillo Oscuro",
        ["frFR"] = "Donjon d'Ombrecroc",
        ["koKR"] = "그림자송곳니 성채",
        ["ptBR"] = "Bastilha da Presa Negra",
        ["ruRU"] = "Крепость Темного Клыка",
        ["zhCN"] = "影牙城堡",
        ["zhTW"] = "影牙城堡",
    },
    ["The Stockade"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Verlies",
        ["esES"] = "Las Mazmorras",
        ["esMX"] = "Las Mazmorras",
        ["frFR"] = "La Prison",
        ["koKR"] = "스톰윈드 지하감옥",
        ["ptBR"] = "O Cárcere",
        ["ruRU"] = "Тюрьма",
        ["zhCN"] = "监狱",
        ["zhTW"] = "暴風城監獄",
    },
    ["Razorfen Kraul"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Kral von Razorfen",
        ["esES"] = "Horado Rajacieno",
        ["esMX"] = "Horado Rajacieno",
        ["frFR"] = "Kraal de Tranchebauge",
        ["koKR"] = "가시덩굴 우리",
        ["ptBR"] = "Urzal dos Tuscos",
        ["ruRU"] = "Лабиринты Иглошкурых",
        ["zhCN"] = "剃刀沼泽",
        ["zhTW"] = "剃刀沼澤",
    },
    ["The Slave Pens"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sklavenunterkünfte",
        ["esES"] = "Recinto de los Esclavos",
        ["esMX"] = "Recinto de los Esclavos",
        ["frFR"] = "Les enclos aux esclaves",
        ["koKR"] = "강제 노역소",
        ["ptBR"] = "Pátio dos Escravos",
        ["ruRU"] = "Узилище",
        ["zhCN"] = "奴隶围栏",
        ["zhTW"] = "奴隸監獄",
    },
    ["The Mechanar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Mechanar",
        ["esES"] = "El Mechanar",
        ["esMX"] = "El Mechanar",
        ["frFR"] = "Le Méchanar",
        ["koKR"] = "메카나르",
        ["ptBR"] = "Mecanar",
        ["ruRU"] = "Механар",
        ["zhCN"] = "能源舰",
        ["zhTW"] = "麥克納爾",
    },
    ["Gnomeregan"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "놈리건",
        ["ptBR"] = true,
        ["ruRU"] = "Гномреган",
        ["zhCN"] = "诺莫瑞根",
        ["zhTW"] = "諾姆瑞根",
    },
    ["Zul'Farrak"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "줄파락",
        ["ptBR"] = true,
        ["ruRU"] = "Зул'Фаррак",
        ["zhCN"] = "祖尔法拉克",
        ["zhTW"] = "祖爾法拉克",
    },
    ["Hellfire Citadel"] = {
        ["enUS"] = true,
        ["deDE"] = "Höllenfeuerzitadelle",
        ["esES"] = "Ciudadela del Fuego Infernal",
        ["esMX"] = "Ciudadela del Fuego Infernal",
        ["frFR"] = "Citadelle des Flammes infernales",
        ["koKR"] = "지옥불 성채",
        ["ptBR"] = "Cidadela Fogo do Inferno",
        ["ruRU"] = "Цитадель Адского Пламени",
        ["zhCN"] = "地狱火堡垒",
        ["zhTW"] = "地獄火堡壘",
    },
    ["The Shattered Halls"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Zerschmetterten Hallen",
        ["esES"] = "Las Salas Arrasadas",
        ["esMX"] = "Las Salas Arrasadas",
        ["frFR"] = "Les Salles brisées",
        ["koKR"] = "으스러진 손의 전당",
        ["ptBR"] = "Salões Despedaçados",
        ["ruRU"] = "Разрушенные залы",
        ["zhCN"] = "破碎大厅",
        ["zhTW"] = "地獄火堡壘",
    },
    ["Blackrock Depths"] = {
        ["enUS"] = true,
        ["deDE"] = "Schwarzfelstiefen",
        ["esES"] = "Profundidades de Roca Negra",
        ["esMX"] = "Profundidades de Roca Negra",
        ["frFR"] = "Profondeurs de Rochenoire",
        ["koKR"] = "검은바위 나락",
        ["ptBR"] = "Abismo Rocha Negra",
        ["ruRU"] = "Глубины Черной Горы",
        ["zhCN"] = "黑石深渊",
        ["zhTW"] = "黑石深淵",
    },
    ["The Botanica"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Botanika",
        ["esES"] = "El Invernáculo",
        ["esMX"] = "El Invernáculo",
        ["frFR"] = "La Botanica",
        ["koKR"] = "신록의 정원",
        ["ptBR"] = "Jardim Botânico",
        ["ruRU"] = "Ботаника",
        ["zhCN"] = "生态船",
        ["zhTW"] = "波塔尼卡",
    },
    ["The Arcatraz"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Arkatraz",
        ["esES"] = "El Arcatraz",
        ["esMX"] = "El Arcatraz",
        ["frFR"] = "L'Arcatraz",
        ["koKR"] = "알카트라즈",
        ["ptBR"] = "Arcatraz",
        ["ruRU"] = "Аркатрац",
        ["zhCN"] = "禁魔监狱",
        ["zhTW"] = "亞克崔茲",
    },
    ["Magisters' Terrace"] = {
        ["enUS"] = true,
        ["deDE"] = "Terrasse der Magister",
        ["esES"] = "Bancal del Magister",
        ["esMX"] = "Bancal del Magister",
        ["frFR"] = "Terrasse des Magistères",
        ["koKR"] = "마법학자의 정원",
        ["ptBR"] = "Terraço dos Magísteres",
        ["ruRU"] = "Терраса Магистров",
        ["zhCN"] = "魔导师平台",
        ["zhTW"] = "博學者殿堂",
    },
    ["Utgarde Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Burg Utgarde",
        ["esES"] = "Fortaleza de Utgarde",
        ["esMX"] = "Fortaleza de Utgarde",
        ["frFR"] = "Donjon d'Utgarde",
        ["koKR"] = "우트가드 성채",
        ["ptBR"] = "Bastilha Utgarde",
        ["ruRU"] = "Крепость Утгард",
        ["zhCN"] = "乌特加德城堡",
        ["zhTW"] = "俄特加德要塞",
    },
    ["Azjol-Nerub"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Azjol-Nérub",
        ["koKR"] = "아졸네룹",
        ["ptBR"] = true,
        ["ruRU"] = "Азжол-Неруб",
        ["zhCN"] = "艾卓-尼鲁布",
        ["zhTW"] = "阿茲歐-奈幽",
    },
    ["Drak'Tharon Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Feste Drak'Tharon",
        ["esES"] = "Fortaleza de Drak'Tharon",
        ["esMX"] = "Fortaleza de Drak'Tharon",
        ["frFR"] = "Donjon de Drak'Tharon",
        ["koKR"] = "드락타론 성채",
        ["ptBR"] = "Bastilha Drak'Tharon",
        ["ruRU"] = "Крепость Драк'Тарон",
        ["zhCN"] = "达克萨隆要塞",
        ["zhTW"] = "德拉克薩隆要塞",
    },
    ["Utgarde Pinnacle"] = {
        ["enUS"] = true,
        ["deDE"] = "Turm Utgarde",
        ["esES"] = "Pináculo de Utgarde",
        ["esMX"] = "Pináculo de Utgarde",
        ["frFR"] = "Cime d'Utgarde",
        ["koKR"] = "우트가드 첨탑",
        ["ptBR"] = "Вершина Утгард",
        ["ruRU"] = "Pináculo Utgarde",
        ["zhCN"] = "乌特加德之巅",
        ["zhTW"] = "俄特加德之巔",
    },
    ["Gundrak"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "군드락",
        ["ptBR"] = true,
        ["ruRU"] = "Гундрак",
        ["zhCN"] = "古达克",
        ["zhTW"] = "剛德拉克",
    },
    ["The Nexus"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Nexus",
        ["esES"] = "El Nexo",
        ["esMX"] = "El Nexo",
        ["frFR"] = "Le Nexus",
        ["koKR"] = "마력의 탑",
        ["ptBR"] = "Nexus",
        ["ruRU"] = "Нексус",
        ["zhCN"] = "魔枢",
        ["zhTW"] = "奧核之心",
    },
    ["The Frozen Halls"] = {
        ["enUS"] = true,
        ["deDE"] = "Die gefrorenen Hallen",
        ["esES"] = "Las Cámaras Heladas",
        ["esMX"] = "Las Cámaras Heladas",
        ["frFR"] = "Les salles Gelées",
        ["koKR"] = "얼어붙은 전당",
        ["ptBR"] = "Salões Gelados",
        ["ruRU"] = "Ледяные залы",
        ["zhCN"] = "冰封大殿",
        ["zhTW"] = "冰封大廳",
    },
    ["Throne of the Tides"] = {
        ["enUS"] = true,
        ["deDE"] = "Thron der Gezeiten",
        ["esES"] = "Trono de las Mareas",
        ["esMX"] = "Trono de las Mareas",
        ["frFR"] = "Trône des marées",
        ["koKR"] = "파도의 왕좌",
        ["ptBR"] = "Trono das Marés",
        ["ruRU"] = "Трон Приливов",
        ["zhCN"] = "潮汐王座",
        ["zhTW"] = "海潮王座",
    },
    ["Grim Batol"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "그림 바톨",
        ["ptBR"] = true,
        ["ruRU"] = "Грим Батол",
        ["zhCN"] = "格瑞姆巴托",
        ["zhTW"] = "格瑞姆巴托",
    },
    ["The Lost City of the Tol'vir"] = { -- do we have this string used anywhere? This one with "The "
        ["enUS"] = true,
        ["deDE"] = "Die verlorene Stadt der Tol'vir",
        ["esES"] = "Ciudad Perdida de los Tol'vir",
        ["esMX"] = "Ciudad Perdida de los Tol'vir",
        ["frFR"] = "Cité perdue des Tol'vir",
        ["koKR"] = "톨비르의 잃어버린 도시",
        ["ptBR"] = "Cidade Perdida dos Tol'vir",
        ["ruRU"] = "Затерянный город Тол'вир",
        ["zhCN"] = "托维尔失落之城",
        ["zhTW"] = "托維爾的失落之城",
    },
    ["Lost City of the Tol'vir"] = {
        ["enUS"] = true,
        ["deDE"] = "Die verlorene Stadt der Tol'vir",
        ["esES"] = "Ciudad Perdida de los Tol'vir",
        ["esMX"] = "Ciudad Perdida de los Tol'vir",
        ["frFR"] = "Cité perdue des Tol'vir",
        ["koKR"] = "톨비르의 잃어버린 도시",
        ["ptBR"] = "Cidade Perdida dos Tol'vir",
        ["ruRU"] = "Затерянный город Тол'вир",
        ["zhCN"] = "托维尔失落之城",
        ["zhTW"] = "托維爾的失落之城",
    },
    ["Halls of Origination"] = {
        ["enUS"] = true,
        ["deDE"] = "Hallen des Ursprungs",
        ["esES"] = "Cámaras de los Orígenes",
        ["esMX"] = "Cámaras de los Orígenes",
        ["frFR"] = "Salles de l'Origine",
        ["koKR"] = "시초의 전당",
        ["ptBR"] = "Salões Primordiais",
        ["ruRU"] = "Чертоги Созидания",
        ["zhCN"] = "起源大厅",
        ["zhTW"] = "起源大廳",
    },
    ["The Stonecore"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Steinerne Kern",
        ["esES"] = "El Núcleo Pétreo",
        ["esMX"] = "El Núcleo Pétreo",
        ["frFR"] = "Le Cœur-de-Pierre",
        ["koKR"] = "바위심장부",
        ["ptBR"] = "Litocerne",
        ["ruRU"] = "Каменные Недра",
        ["zhCN"] = "巨石之核",
        ["zhTW"] = "石岩之心",
    },
    ["Blackrock Caverns"] = {
        ["enUS"] = true,
        ["deDE"] = "Schwarzfelshöhlen",
        ["esES"] = "Cavernas Roca Negra",
        ["esMX"] = "Cavernas Roca Negra",
        ["frFR"] = "Cavernes de Rochenoire",
        ["koKR"] = "검은바위 동굴",
        ["ptBR"] = "Cavernas Rocha Negra",
        ["ruRU"] = "Пещеры Черной горы",
        ["zhCN"] = "黑石岩窟",
        ["zhTW"] = "黑石洞穴",
    },
    ["The Vortex Pinnacle"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Vortexgipfel",
        ["esES"] = "La Cumbre del Vórtice",
        ["esMX"] = "La Cumbre del Vórtice",
        ["frFR"] = "La cime du Vortex",
        ["koKR"] = "소용돌이 누각",
        ["ptBR"] = "Pináculo do Vórtice",
        ["ruRU"] = "Вершина Смерча",
        ["zhCN"] = "旋云之巅",
        ["zhTW"] = "漩渦尖塔",
    },
    ["End Time"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Endzeit",
        ["esES"] = "Fin de los Días",
        ["esMX"] = "Fin de los Días",
        ["frFR"] = "La Fin des temps",
        ["koKR"] = "시간의 끝",
        ["ptBR"] = "Fim dos Tempos",
        ["ruRU"] = "Конец Времен",
        ["zhCN"] = "时光之末",
        ["zhTW"] = "終焉之刻",
    },
    ["Hour of Twilight"] = {
        ["enUS"] = true,
        ["deDE"] = "Stunde des Zwielichts",
        ["esES"] = "Hora del Crepúsculo",
        ["esMX"] = "Hora del Crepúsculo",
        ["frFR"] = "L’Heure du Crépuscule",
        ["koKR"] = "황혼의 시간",
        ["ptBR"] = "Hora do Crepúsculo",
        ["ruRU"] = "Время Сумерек",
        ["zhCN"] = "暮光审判",
        ["zhTW"] = "暮光之時",
    },
    ["Well of Eternity"] = {
        ["enUS"] = true,
        ["deDE"] = "Brunnen der Ewigkeit",
        ["esES"] = "Pozo de la Eternidad",
        ["esMX"] = "Pozo de la Eternidad",
        ["frFR"] = "Puits d’éternité",
        ["koKR"] = "영원의 샘",
        ["ptBR"] = "Nascente da Eternidade",
        ["ruRU"] = "Источник Вечности",
        ["zhCN"] = "永恒之井",
        ["zhTW"] = "永恆之井",
    },
    ["Mogu'shan Palace"] = {
        ["enUS"] = true,
        ["deDE"] = "Mogu'shanpalast",
        ["esES"] = "Palacio Mogu'shan",
        ["esMX"] = "Palacio Mogu'shan",
        ["frFR"] = "Palais Mogu’shan",
        ["koKR"] = "모구샨 궁전",
        ["ptBR"] = "Palácio Mogu'shan",
        ["ruRU"] = "Дворец Могу'шан",
        ["zhCN"] = "魔古山宫殿",
        ["zhTW"] = "魔古山宮",
    },
    ["Stormstout Brewery"] = {
        ["enUS"] = true,
        ["deDE"] = "Brauerei Sturmbräu",
        ["esES"] = "Cervecería del Trueno",
        ["esMX"] = "Cervecería del Trueno",
        ["frFR"] = "Brasserie Brune d’Orage",
        ["koKR"] = "스톰스타우트 양조장",
        ["ptBR"] = "Cervejaria Malte do Trovão",
        ["ruRU"] = "Хмелеварня Буйных Портеров",
        ["zhCN"] = "风暴烈酒酿造厂",
        ["zhTW"] = "風暴烈酒酒坊",
    },
    ["Siege of Niuzao Temple"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Belagerung des Niuzaotempels",
        ["esES"] = "Asedio del Templo de Niuzao",
        ["esMX"] = "Asedio del Templo de Niuzao",
        ["frFR"] = "Siège du temple de Niuzao",
        ["koKR"] = "니우짜오 사원 공성전투",
        ["ptBR"] = "Cerco ao Templo Niuzao",
        ["ruRU"] = "Осада храма Нюцзао",
        ["zhCN"] = "围攻砮皂寺",
        ["zhTW"] = "圍攻怒兆寺",
    },
    ["Temple of the Jade Serpent"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel der Jadeschlange",
        ["esES"] = "Templo del Dragón de Jade",
        ["esMX"] = "Templo del Dragón de Jade",
        ["frFR"] = "Temple du Serpent de jade",
        ["koKR"] = "옥룡사",
        ["ptBR"] = "Templo da Serpente de Jade",
        ["ruRU"] = "Храм Нефритовой Змеи",
        ["zhCN"] = "青龙寺",
        ["zhTW"] = "玉蛟寺",
    },
    ["Scarlet Halls"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachrote Hallen",
        ["esES"] = "Cámaras Escarlata",
        ["esMX"] = "Cámaras Escarlata",
        ["frFR"] = "Salles Écarlates",
        ["koKR"] = "붉은십자군 전당",
        ["ptBR"] = "Salões Escarlates",
        ["ruRU"] = "Залы Алого ордена",
        ["zhCN"] = "血色大厅",
        ["zhTW"] = "血色大廳",
    },
    ["Shado-Pan Monastery"] = {
        ["enUS"] = true,
        ["deDE"] = "Shado-Pan-Kloster",
        ["esES"] = "Monasterio del Shadopan",
        ["esMX"] = "Monasterio del Shadopan",
        ["frFR"] = "Monastère des Pandashan",
        ["koKR"] = "음영파 수도원",
        ["ptBR"] = "Monastério Shado-pan",
        ["ruRU"] = "Монастырь Шадо-Пан",
        ["zhCN"] = "影踪禅院",
        ["zhTW"] = "影潘僧院",
    },
    ["Gate of the Setting Sun"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Tor der Untergehenden Sonne",
        ["esES"] = "Puerta del Sol Poniente",
        ["esMX"] = "Puerta del Sol Poniente",
        ["frFR"] = "Porte du Soleil couchant",
        ["koKR"] = "석양문",
        ["ptBR"] = "Portal do Sol Poente",
        ["ruRU"] = "Врата Заходящего Солнца",
        ["zhCN"] = "残阳关",
        ["zhTW"] = "落陽關",
    },
    ["Bizmo's Brawlpub"] = {
        ["enUS"] = true,
        ["deDE"] = "Bizmos Boxbar",
        ["esES"] = "Club de Lucha de Bizmo",
        ["esMX"] = "Club de Lucha de Bizmo",
        ["frFR"] = "Bar-Tabasse de Bizmo",
        ["koKR"] = "비즈모의 싸움굴",
        ["ptBR"] = "Bar Brigalhada do Bizmo",
        ["ruRU"] = "Потасовочная \"У Бизмо\"",
        ["zhCN"] = "比兹莫搏击俱乐部",
        ["zhTW"] = "畢茲摩鬥陣俱樂部",
    },
    ["Brawl'gar Arena"] = {
        ["enUS"] = true,
        ["deDE"] = "Shlae'gararena",
        ["esES"] = "Arena Liza'gar",
        ["esMX"] = "Arena Liza'gar",
        ["frFR"] = "Arène de Castagn’ar",
        ["koKR"] = "싸울가르 투기장",
        ["ptBR"] = "Arena de Brig'ga Fea",
        ["ruRU"] = "Арена \"Морд'Бой\"",
        ["zhCN"] = "搏击竞技场",
        ["zhTW"] = "鬥陣競技場",
    },
}

for k, v in pairs(dungeonLocales) do
    l10n.translations[k] = v
end
