---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local easternKingdomsLocales = {
    ["The Hinterlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Hinterland",
        ["esES"] = "Tierras del Interior",
        ["esMX"] = "Tierras del Interior",
        ["frFR"] = "Les Hinterlands",
        ["koKR"] = "동부 내륙지",
        ["ptBR"] = "Terras Agrestes",
        ["ruRU"] = "Внутренние земли",
        ["zhCN"] = "辛特兰",
        ["zhTW"] = "辛特蘭",
    },
    ["Stranglethorn Vale"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlingendorntal",
        ["esES"] = "Vega de Tuercespina",
        ["esMX"] = "Vega de Tuercespina",
        ["frFR"] = "Vallée de Strangleronce",
        ["koKR"] = "가시덤불 골짜기",
        ["ptBR"] = "Selva do Espinhaço",
        ["ruRU"] = "Тернистая долина",
        ["zhCN"] = "荆棘谷",
        ["zhTW"] = "荊棘谷",
    },
    ["Eastern Plaguelands"] = {
        ["enUS"] = true,
        ["deDE"] = "Östliche Pestländer",
        ["esES"] = "Tierras de la Peste del Este",
        ["esMX"] = "Tierras de la Peste del Este",
        ["frFR"] = "Maleterres de l'est",
        ["koKR"] = "동부 역병지대",
        ["ptBR"] = "Terras Pestilentas Orientais",
        ["ruRU"] = "Восточные Чумные земли",
        ["zhCN"] = "东瘟疫之地",
        ["zhTW"] = "東瘟疫之地",
    },
    ["Duskwood"] = {
        ["enUS"] = true,
        ["deDE"] = "Dämmerwald",
        ["esES"] = "Bosque del Ocaso",
        ["esMX"] = "Bosque del Ocaso",
        ["frFR"] = "Bois de la Pénombre",
        ["koKR"] = "그늘숲",
        ["ptBR"] = "Floresta do Crepúsculo",
        ["ruRU"] = "Сумеречный лес",
        ["zhCN"] = "暮色森林",
        ["zhTW"] = "暮色森林",
    },
    ["Blasted Lands"] = {
        ["enUS"] = true,
        ["deDE"] = "Verwüstete Lande",
        ["esES"] = "Las Tierras Devastadas",
        ["esMX"] = "Las Tierras Devastadas",
        ["frFR"] = "Terres foudroyées",
        ["koKR"] = "저주받은 땅",
        ["ptBR"] = "Barreira do Inferno",
        ["ruRU"] = "Выжженные земли",
        ["zhCN"] = "诅咒之地",
        ["zhTW"] = "詛咒之地",
    },
    ["Blackrock Mountain"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schwarzfels",
        ["esES"] = "Montaña Roca Negra",
        ["esMX"] = "Montaña Roca Negra",
        ["frFR"] = "Mont Rochenoire",
        ["koKR"] = "검은바위 산",
        ["ptBR"] = "Montanha Rocha Negra",
        ["ruRU"] = "Черная гора",
        ["zhCN"] = "黑石山",
        ["zhTW"] = "黑石山",
    },
    ["Redridge Mountains"] = {
        ["enUS"] = true,
        ["deDE"] = "Rotkammgebirge",
        ["esES"] = "Montañas Crestagrana",
        ["esMX"] = "Montañas Crestagrana",
        ["frFR"] = "Les Carmines",
        ["koKR"] = "붉은마루 산맥",
        ["ptBR"] = "Montanhas Cristarrubra",
        ["ruRU"] = "Красногорье",
        ["zhCN"] = "赤脊山",
        ["zhTW"] = "赤脊山",
    },
    ["Arathi Highlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Arathihochland",
        ["esES"] = "Tierras Altas de Arathi",
        ["esMX"] = "Tierras Altas de Arathi",
        ["frFR"] = "Hautes-terres d'Arathi",
        ["koKR"] = "아라시 고원",
        ["ptBR"] = "Planalto Arathi",
        ["ruRU"] = "Нагорье Арати",
        ["zhCN"] = "阿拉希高地",
        ["zhTW"] = "阿拉希高地",
    },
    ["Westfall"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Páramos de Poniente",
        ["esMX"] = "Páramos de Poniente",
        ["frFR"] = "Marche de l'Ouest",
        ["koKR"] = "서부 몰락지대",
        ["ptBR"] = "Cerro Oeste",
        ["ruRU"] = "Западный Край",
        ["zhCN"] = "西部荒野",
        ["zhTW"] = "西部荒野",
    },
    ["Badlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Ödland",
        ["esES"] = "Tierras Inhóspitas",
        ["esMX"] = "Tierras Inhóspitas",
        ["frFR"] = "Terres ingrates",
        ["koKR"] = "황야의 땅",
        ["ptBR"] = "Ermos",
        ["ruRU"] = "Бесплодные земли",
        ["zhCN"] = "荒芜之地",
        ["zhTW"] = "荒蕪之地",
    },
    ["Searing Gorge"] = {
        ["enUS"] = true,
        ["deDE"] = "Sengende Schlucht",
        ["esES"] = "La Garganta de Fuego",
        ["esMX"] = "La Garganta de Fuego",
        ["frFR"] = "Gorge des Vents brûlants",
        ["koKR"] = "이글거리는 협곡",
        ["ptBR"] = "Garganta Abrasadora",
        ["ruRU"] = "Тлеющее ущелье",
        ["zhCN"] = "灼热峡谷",
        ["zhTW"] = "灼熱峽谷",
    },
    ["Loch Modan"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "모단 호수",
        ["ptBR"] = true,
        ["ruRU"] = "Лок Модан",
        ["zhCN"] = "洛克莫丹",
        ["zhTW"] = "洛克莫丹",
    },
    ["Burning Steppes"] = {
        ["enUS"] = true,
        ["deDE"] = "Brennende Steppe",
        ["esES"] = "Las Estepas Ardientes",
        ["esMX"] = "Las Estepas Ardientes",
        ["frFR"] = "Steppes ardentes",
        ["koKR"] = "불타는 평원",
        ["ptBR"] = "Estepes Ardentes",
        ["ruRU"] = "Пылающие степи",
        ["zhCN"] = "燃烧平原",
        ["zhTW"] = "燃燒平原",
    },
    ["Tirisfal Glades"] = {
        ["enUS"] = true,
        ["deDE"] = "Tirisfal",
        ["esES"] = "Claros de Tirisfal",
        ["esMX"] = "Claros de Tirisfal",
        ["frFR"] = "Clairières de Tirisfal",
        ["koKR"] = "티리스팔 숲",
        ["ptBR"] = "Clareiras de Tirisfal",
        ["ruRU"] = "Тирисфальские леса",
        ["zhCN"] = "提瑞斯法林地",
        ["zhTW"] = "提里斯法林地",
    },
    ["Elwynn Forest"] = {
        ["enUS"] = true,
        ["deDE"] = "Wald von Elwynn",
        ["esES"] = "Bosque de Elwynn",
        ["esMX"] = "Bosque de Elwynn",
        ["frFR"] = "Forêt d'Elwynn",
        ["koKR"] = "엘윈 숲",
        ["ptBR"] = "Floresta de Elwynn",
        ["ruRU"] = "Элвиннский лес",
        ["zhCN"] = "艾尔文森林",
        ["zhTW"] = "艾爾文森林",
    },
    ["Wetlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Sumpfland",
        ["esES"] = "Los Humedales",
        ["esMX"] = "Los Humedales",
        ["frFR"] = "Les Paluns",
        ["koKR"] = "저습지",
        ["ptBR"] = "Pantanal",
        ["ruRU"] = "Болотина",
        ["zhCN"] = "湿地",
        ["zhTW"] = "濕地",
    },
    ["Western Plaguelands"] = {
        ["enUS"] = true,
        ["deDE"] = "Westliche Pestländer",
        ["esES"] = "Tierras de la Peste del Oeste",
        ["esMX"] = "Tierras de la Peste del Oeste",
        ["frFR"] = "Maleterres de l'ouest",
        ["koKR"] = "서부 역병지대",
        ["ptBR"] = "Terras Pestilentas Ocidentais",
        ["ruRU"] = "Западные Чумные земли",
        ["zhCN"] = "西瘟疫之地",
        ["zhTW"] = "西瘟疫之地",
    },
    ["Stormwind City"] = {
        ["enUS"] = true,
        ["deDE"] = "Sturmwind",
        ["esES"] = "Ciudad de Ventormenta",
        ["esMX"] = "Ciudad de Ventormenta",
        ["frFR"] = "Hurlevent",
        ["koKR"] = "스톰윈드",
        ["ptBR"] = "Ventobravo",
        ["ruRU"] = "Штормград",
        ["zhCN"] = "暴风城",
        ["zhTW"] = "暴風城",
    },
    ["Silverpine Forest"] = {
        ["enUS"] = true,
        ["deDE"] = "Silberwald",
        ["esES"] = "Bosque de Argénteos",
        ["esMX"] = "Bosque de Argénteos",
        ["frFR"] = "Forêt des Pins argentés",
        ["koKR"] = "은빛소나무 숲",
        ["ptBR"] = "Floresta de Pinhaprata",
        ["ruRU"] = "Серебряный бор",
        ["zhCN"] = "银松森林",
        ["zhTW"] = "銀松森林",
    },
    ["Ironforge"] = {
        ["enUS"] = true,
        ["deDE"] = "Eisenschmiede",
        ["esES"] = "Forjaz",
        ["esMX"] = "Forjaz",
        ["frFR"] = "Forgefer",
        ["koKR"] = "아이언포지",
        ["ptBR"] = "Altaforja",
        ["ruRU"] = "Стальгорн",
        ["zhCN"] = "铁炉堡",
        ["zhTW"] = "鐵爐堡",
    },
    ["Undercity"] = {
        ["enUS"] = true,
        ["deDE"] = "Unterstadt",
        ["esES"] = "Entrañas",
        ["esMX"] = "Entrañas",
        ["frFR"] = "Fossoyeuse",
        ["koKR"] = "언더시티",
        ["ptBR"] = "Cidade Baixa",
        ["ruRU"] = "Подгород",
        ["zhCN"] = "幽暗城",
        ["zhTW"] = "幽暗城",
    },
    ["Deeprun Tram"] = {
        ["enUS"] = true,
        ["deDE"] = "Tiefenbahn",
        ["esES"] = "Tren Subterráneo",
        ["esMX"] = "Tranvía Subterráneo",
        ["frFR"] = "Tram des profondeurs",
        ["koKR"] = "깊은굴 지하철",
        ["ptBR"] = "Metrô Correfundo",
        ["ruRU"] = "Подземный поезд",
        ["zhCN"] = "矿道地铁",
        ["zhTW"] = "礦道地鐵",
    },
    ["Hillsbrad Foothills"] = {
        ["enUS"] = true,
        ["deDE"] = "Vorgebirge von Hillsbrad",
        ["esES"] = "Laderas de Trabalomas",
        ["esMX"] = "Laderas de Trabalomas",
        ["frFR"] = "Contreforts d'Hillsbrad",
        ["koKR"] = "힐스브래드 구릉지",
        ["ptBR"] = "Contraforte de Eira dos Montes",
        ["ruRU"] = "Предгорья Хилсбрада",
        ["zhCN"] = "希尔斯布莱德丘陵",
        ["zhTW"] = "希爾斯布萊德丘陵",
    },
    ["Deadwind Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Gebirgspass der Totenwinde",
        ["esES"] = "Paso de la Muerte",
        ["esMX"] = "Paso de la Muerte",
        ["frFR"] = "Défilé de Deuillevent",
        ["koKR"] = "죽음의 고개",
        ["ptBR"] = "Trilha do Vento Morto",
        ["ruRU"] = "Перевал Мертвого Ветра",
        ["zhCN"] = "逆风小径",
        ["zhTW"] = "逆風小徑",
    },
    ["Swamp of Sorrows"] = {
        ["enUS"] = true,
        ["deDE"] = "Sümpfe des Elends",
        ["esES"] = "Pantano de las Penas",
        ["esMX"] = "Pantano de las Penas",
        ["frFR"] = "Marais des Chagrins",
        ["koKR"] = "슬픔의 늪",
        ["ptBR"] = "Pântano das Mágoas",
        ["ruRU"] = "Болото Печали",
        ["zhCN"] = "悲伤沼泽",
        ["zhTW"] = "悲傷沼澤",
    },
    ["Dun Morogh"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "던 모로",
        ["ptBR"] = true,
        ["ruRU"] = "Дун Морог",
        ["zhCN"] = "丹莫罗",
        ["zhTW"] = "丹莫洛",
    },
    ["Alterac Mountains"] = {
        ["enUS"] = true,
        ["deDE"] = "Alteracgebirge",
        ["esES"] = "Montañas de Alterac",
        ["esMX"] = "Montañas de Alterac",
        ["frFR"] = "Montagnes d'Alterac",
        ["koKR"] = "알터랙 산맥",
        ["ptBR"] = "Montanhas de Alterac",
        ["ruRU"] = "Альтеракские горы",
        ["zhCN"] = "奥特兰克山脉",
        ["zhTW"] = "奧特蘭克山脈",
    },
    ["Dalaran"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "달라란",
        ["ptBR"] = true,
        ["ruRU"] = "Даларан",
        ["zhCN"] = "达拉然",
        ["zhTW"] = "達拉然",
    },
    ["Northern Stranglethorn"] = {
        ["enUS"] = true,
        ["deDE"] = "Nördliches Schlingendorntal",
        ["esES"] = "Norte de la Vega de Tuercespina",
        ["esMX"] = "Norte de la Vega de Tuercespina",
        ["frFR"] = "Strangleronce septentrionale",
        ["koKR"] = "북부 가시덤불",
        ["ptBR"] = "Selva do Espinhaço Setentrional",
        ["ruRU"] = "Северная Тернистая долина",
        ["zhCN"] = "北荆棘谷",
        ["zhTW"] = "北荊棘谷",
    },
    ["The Cape of Stranglethorn"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Schlingendornkap",
        ["esES"] = "El Cabo de Tuercespina",
        ["esMX"] = "El Cabo de Tuercespina",
        ["frFR"] = "Cap Strangleronce",
        ["koKR"] = "가시덤불 곶",
        ["ptBR"] = "Cabo do Espinhaço",
        ["ruRU"] = "Мыс Тернистой долины",
        ["zhCN"] = "荆棘谷海角",
        ["zhTW"] = "荊棘谷海角",
    },
    ["Tol Barad"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "톨 바라드",
        ["ptBR"] = true,
        ["ruRU"] = "Тол Барад",
        ["zhCN"] = "托尔巴拉德",
        ["zhTW"] = "托巴拉德",
    },
    ["Tol Barad Peninsula"] = {
        ["enUS"] = true,
        ["deDE"] = "Halbinsel von Tol Barad",
        ["esES"] = "Península de Tol Barad",
        ["esMX"] = "Península de Tol Barad",
        ["frFR"] = "Péninsule de Tol Barad",
        ["koKR"] = "톨 바라드 반도",
        ["ptBR"] = "Península de Tol Barad",
        ["ruRU"] = "Полуостров Тол Барад",
        ["zhCN"] = "托尔巴拉德半岛",
        ["zhTW"] = "托巴拉德半島",
    },
    ["Kelp'thar Forest"] = {
        ["enUS"] = true,
        ["deDE"] = "Tang'tharwald",
        ["esES"] = "Bosque Kelp'thar",
        ["esMX"] = "Bosque Kelp'thar",
        ["frFR"] = "Forêt de Varech'thar",
        ["koKR"] = "켈프타르 숲",
        ["ptBR"] = "Floresta Kelp'thar",
        ["ruRU"] = "Лес Келп'тар",
        ["zhCN"] = "柯尔普萨之森",
        ["zhTW"] = "凱波薩爾森林",
    },
    ["Shimmering Expanse"] = {
        ["enUS"] = true,
        ["deDE"] = "Schimmernde Weiten",
        ["esES"] = "Extensión Bruñida",
        ["esMX"] = "Extensión Bruñida",
        ["frFR"] = "Étendues Chatoyantes",
        ["koKR"] = "흐린빛 벌판",
        ["ptBR"] = "Vastidão Cintilante",
        ["ruRU"] = "Мерцающий простор",
        ["zhCN"] = "烁光海床",
        ["zhTW"] = "閃光瀚洋",
    },
    ["Abyssal Depths"] = {
        ["enUS"] = true,
        ["deDE"] = "Abyssische Tiefen",
        ["esES"] = "Profundidades Abisales",
        ["esMX"] = "Profundidades Abisales",
        ["frFR"] = "Profondeurs Abyssales",
        ["koKR"] = "심연의 나락",
        ["ptBR"] = "Profundezas Abissais",
        ["ruRU"] = "Бездонные глубины",
        ["zhCN"] = "无底海渊",
        ["zhTW"] = "地獄深淵",
    },
    ["Coldridge Valley"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Eisklammtal",
        ["esES"] = "Valle de Crestanevada",
        ["esMX"] = "Valle de Crestanevada",
        ["frFR"] = "Vallée des Frigères",
        ["koKR"] = "눈마루 골짜기",
        ["ptBR"] = "Vale Cristálgida",
        ["ruRU"] = "Холодная долина",
        ["zhCN"] = "寒脊山谷",
        ["zhTW"] = "寒脊山谷",
    },
    ["Twilight Highlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenhochland",
        ["esES"] = "Tierras Altas Crepusculares",
        ["esMX"] = "Tierras Altas Crepusculares",
        ["frFR"] = "Hautes-terres du Crépuscule",
        ["koKR"] = "황혼의 고원",
        ["ptBR"] = "Planalto do Crepúsculo",
        ["ruRU"] = "Сумеречное нагорье",
        ["zhCN"] = "暮光高地",
        ["zhTW"] = "暮光高地",
    },
    ["Vashj'ir"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "바쉬르",
        ["ptBR"] = true,
        ["ruRU"] = "Вайш'ир",
        ["zhCN"] = "瓦丝琪尔",
        ["zhTW"] = "瓦許伊爾",
    },
    ["Gilneas"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Gilnéas",
        ["koKR"] = "길니아스",
        ["ptBR"] = "Guilnéas",
        ["ruRU"] = "Гилнеас",
        ["zhCN"] = "吉尔尼斯",
        ["zhTW"] = "吉爾尼斯",
    },
    ["Gilneas City"] = {
        ["enUS"] = true,
        ["deDE"] = "Gilneas",
        ["esES"] = "Ciudad de Gilneas",
        ["esMX"] = "Ciudad de Gilneas",
        ["frFR"] = "Gilnéas",
        ["koKR"] = "길니아스 시",
        ["ptBR"] = "Guilnéas",
        ["ruRU"] = "Гилнеас",
        ["zhCN"] = "吉尔尼斯城",
        ["zhTW"] = "吉爾尼斯城",
    },
    ["Ruins of Gilneas"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Gilneas",
        ["esES"] = "Ruinas de Gilneas",
        ["esMX"] = "Ruinas de Gilneas",
        ["frFR"] = "Ruines de Gilnéas",
        ["koKR"] = "길니아스 폐허",
        ["ptBR"] = "Ruínas de Guilnéas",
        ["ruRU"] = "Руины Гилнеаса",
        ["zhCN"] = "吉尔尼斯废墟",
        ["zhTW"] = "吉爾尼斯廢墟",
    },
    ["Deathknell"] = {
        ["enUS"] = true,
        ["deDE"] = "Todesend",
        ["esES"] = "Camposanto",
        ["esMX"] = "Camposanto",
        ["frFR"] = "Le Glas",
        ["koKR"] = "죽음의 종소리 마을",
        ["ptBR"] = "Plangemortis",
        ["ruRU"] = "Похоронный Звон",
        ["zhCN"] = "丧钟镇",
        ["zhTW"] = "喪鐘鎮",
    },
    ["New Tinkertown"] = {
        ["enUS"] = true,
        ["deDE"] = "Neu-Tüftlerstadt",
        ["esES"] = "Nueva Ciudad Manitas",
        ["esMX"] = "Nueva Ciudad Manitas",
        ["frFR"] = "La Nouvelle-Brikabrok",
        ["koKR"] = "신 땜장이 마을",
        ["ptBR"] = "Vila da Gambiarra",
        ["ruRU"] = "Новый Город Механиков",
        ["zhCN"] = "新工匠镇",
        ["zhTW"] = "新地精區",
    },
    ["Hillsbrad"] = {
        ["enUS"] = true,
        ["deDE"] = "Hügellandhof",
        ["esES"] = "Trabalomas",
        ["esMX"] = "Trabalomas",
        ["frFR"] = "Hautebrande",
        ["koKR"] = "언덕마루",
        ["ptBR"] = "Eira dos Montes",
        ["ruRU"] = "Хилсбрад",
        ["zhCN"] = "希尔斯布莱德",
        ["zhTW"] = "希爾斯布萊德",
    },
    ["New Avalon"] = {
        ["enUS"] = true,
        ["deDE"] = "Neues Avalon",
        ["esES"] = "Nuevo Avalón",
        ["esMX"] = "Nuevo Avalón",
        ["frFR"] = "Nouvelle-Avalon",
        ["koKR"] = "신 아발론",
        ["ptBR"] = "Nova Avalonia",
        ["ruRU"] = "Новый Авалон",
        ["zhCN"] = "新阿瓦隆",
        ["zhTW"] = "新阿瓦隆",
    },
    ["Eastern Kingdoms"] = {
        ["enUS"] = true,
        ["deDE"] = "Östliche Königreiche",
        ["esES"] = "Reinos del Este",
        ["esMX"] = "Reinos del Este",
        ["frFR"] = "Royaumes de l'est",
        ["koKR"] = "동부 왕국",
        ["ptBR"] = "Reinos do Leste",
        ["ruRU"] = "Восточные королевства",
        ["zhCN"] = "东部王国",
        ["zhTW"] = "東部王國",
    },
    ["Dalaran Crater"] = {
        ["enUS"] = true,
        ["deDE"] = "Dalarankrater",
        ["esES"] = "Cráter de Dalaran",
        ["esMX"] = "Cráter de Dalaran",
        ["frFR"] = "Cratère de Dalaran",
        ["koKR"] = false,
        ["ptBR"] = "Cratera de Dalaran",
        ["ruRU"] = false,
        ["zhCN"] = "达拉然巨坑",
        ["zhTW"] = "達拉然陷坑",
    },
}

for k, v in pairs(easternKingdomsLocales) do
    l10n.translations[k] = v
end
