---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local kalimdorLocales = {
    ["Moonglade"] = {
        ["enUS"] = true,
        ["deDE"] = "Mondlichtung",
        ["esES"] = "Claro de la Luna",
        ["esMX"] = "Claro de la Luna",
        ["frFR"] = "Reflet-de-Lune",
        ["koKR"] = "달의 숲",
        ["ptBR"] = "Clareira da Lua",
        ["ruRU"] = "Лунная поляна",
        ["zhCN"] = "月光林地",
        ["zhTW"] = "月光林地",
    },
    ["Thousand Needles"] = {
        ["enUS"] = true,
        ["deDE"] = "Tausend Nadeln",
        ["esES"] = "Las Mil Agujas",
        ["esMX"] = "Las Mil Agujas",
        ["frFR"] = "Mille pointes",
        ["koKR"] = "버섯구름 봉우리",
        ["ptBR"] = "Mil Agulhas",
        ["ruRU"] = "Тысяча Игл",
        ["zhCN"] = "千针石林",
        ["zhTW"] = "千針石林",
    },
    ["Timbermaw Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Holzschlundfeste",
        ["esES"] = "Bastión de los Fauces de Madera",
        ["esMX"] = "Bastión de los Fauces de Madera",
        ["frFR"] = "Les Grumegueules",
        ["koKR"] = "나무구렁 요새",
        ["ptBR"] = "Domínio dos Presamatos",
        ["ruRU"] = "Древобрюхи",
        ["zhCN"] = "木喉要塞",
        ["zhTW"] = "木喉要塞",
    },
    ["Winterspring"] = {
        ["enUS"] = true,
        ["deDE"] = "Winterquell",
        ["esES"] = "Cuna del Invierno",
        ["esMX"] = "Cuna del Invierno",
        ["frFR"] = "Berceau-de-l'Hiver",
        ["koKR"] = "여명의 설원",
        ["ptBR"] = "Hibérnia",
        ["ruRU"] = "Зимние Ключи",
        ["zhCN"] = "冬泉谷",
        ["zhTW"] = "冬泉谷",
    },
    ["Ashenvale"] = {
        ["enUS"] = true,
        ["deDE"] = "Eschental",
        ["esES"] = "Vallefresno",
        ["esMX"] = "Vallefresno",
        ["frFR"] = "Orneval",
        ["koKR"] = "잿빛 골짜기",
        ["ptBR"] = "Vale Gris",
        ["ruRU"] = "Ясеневый лес",
        ["zhCN"] = "灰谷",
        ["zhTW"] = "梣谷",
    },
    ["Teldrassil"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "텔드랏실",
        ["ptBR"] = true,
        ["ruRU"] = "Тельдрассил",
        ["zhCN"] = "泰达希尔",
        ["zhTW"] = "泰達希爾",
    },
    ["Un'Goro Crater"] = {
        ["enUS"] = true,
        ["deDE"] = "Krater von Un'Goro",
        ["esES"] = "Cráter de Un'Goro",
        ["esMX"] = "Cráter de Un'Goro",
        ["frFR"] = "Cratère d'Un'Goro",
        ["koKR"] = "운고로 분화구",
        ["ptBR"] = "Cratera Un'Goro",
        ["ruRU"] = "Кратер Ун'Горо",
        ["zhCN"] = "安戈洛环形山",
        ["zhTW"] = "安戈洛環形山",
    },
    ["Mulgore"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "멀고어",
        ["ptBR"] = true,
        ["ruRU"] = "Мулгор",
        ["zhCN"] = "莫高雷",
        ["zhTW"] = "莫高雷",
    },
    ["Dustwallow Marsh"] = {
        ["enUS"] = true,
        ["deDE"] = "Düstermarschen",
        ["esES"] = "Marjal Revolcafango",
        ["esMX"] = "Marjal Revolcafango",
        ["frFR"] = "Marécage d'Âprefange",
        ["koKR"] = "먼지진흙 슾지대",
        ["ptBR"] = "Pântano Vadeoso",
        ["ruRU"] = "Пылевые топи",
        ["zhCN"] = "尘泥沼泽",
        ["zhTW"] = "塵泥沼澤",
    },
    ["Felwood"] = {
        ["enUS"] = true,
        ["deDE"] = "Teufelswald",
        ["esES"] = "Frondavil",
        ["esMX"] = "Frondavil",
        ["frFR"] = "Gangrebois",
        ["koKR"] = "악령의 숲",
        ["ptBR"] = "Selva Maleva",
        ["ruRU"] = "Оскверненный лес",
        ["zhCN"] = "费伍德森林",
        ["zhTW"] = "費伍德森林",
    },
    ["Darkshore"] = {
        ["enUS"] = true,
        ["deDE"] = "Dunkelküste",
        ["esES"] = "Costa Oscura",
        ["esMX"] = "Costa Oscura",
        ["frFR"] = "Sombrivage",
        ["koKR"] = "어둠의 해안",
        ["ptBR"] = "Costa Negra",
        ["ruRU"] = "Темные берега",
        ["zhCN"] = "黑海岸",
        ["zhTW"] = "黑海岸",
    },
    ["Orgrimmar"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "오그리마",
        ["ptBR"] = true,
        ["ruRU"] = "Оргриммар",
        ["zhCN"] = "奥格瑞玛",
        ["zhTW"] = "奧格瑪",
    },
    ["Desolace"] = {
        ["enUS"] = true,
        ["deDE"] = "Desolace",
        ["esES"] = "Desolace",
        ["esMX"] = "Desolace",
        ["frFR"] = "Désolace",
        ["koKR"] = "잊혀진 땅",
        ["ptBR"] = "Desolação",
        ["ruRU"] = "Пустоши",
        ["zhCN"] = "凄凉之地",
        ["zhTW"] = "淒涼之地",
    },
    ["Tanaris"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "타나리스",
        ["ptBR"] = true,
        ["ruRU"] = "Танарис",
        ["zhCN"] = "塔纳利斯",
        ["zhTW"] = "塔納利斯",
    },
    ["Azshara"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "아즈샤라",
        ["ptBR"] = true,
        ["ruRU"] = "Азшара",
        ["zhCN"] = "艾萨拉",
        ["zhTW"] = "艾薩拉",
    },
    ["Feralas"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Féralas",
        ["koKR"] = "페랄라스",
        ["ptBR"] = true,
        ["ruRU"] = "Фералас",
        ["zhCN"] = "菲拉斯",
        ["zhTW"] = "菲拉斯",
    },
    ["The Barrens"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Brachland",
        ["esES"] = "Los Baldíos",
        ["esMX"] = "Los Baldíos",
        ["frFR"] = "Les Tarides",
        ["koKR"] = "불모의 땅",
        ["ptBR"] = "Sertões",
        ["ruRU"] = "Степи",
        ["zhCN"] = "贫瘠之地",
        ["zhTW"] = "貧瘠之地",
    },
    ["Durotar"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "듀로타",
        ["ptBR"] = true,
        ["ruRU"] = "Дуротар",
        ["zhCN"] = "杜隆塔尔",
        ["zhTW"] = "杜洛塔",
    },
    ["Thunder Bluff"] = {
        ["enUS"] = true,
        ["deDE"] = "Donnerfels",
        ["esES"] = "Cima del Trueno",
        ["esMX"] = "Cima del Trueno",
        ["frFR"] = "Les Pitons-du-Tonnerre",
        ["koKR"] = "썬더 블러프",
        ["ptBR"] = "Penhasco do Trovão",
        ["ruRU"] = "Громовой Утес",
        ["zhCN"] = "雷霆崖",
        ["zhTW"] = "雷霆崖",
    },
    ["Silithus"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "실리더스",
        ["ptBR"] = true,
        ["ruRU"] = "Силитус",
        ["zhCN"] = "希利苏斯",
        ["zhTW"] = "希利蘇斯",
    },
    ["Stonetalon Mountains"] = {
        ["enUS"] = true,
        ["deDE"] = "Steinkrallengebirge",
        ["esES"] = "Sierra Espolón",
        ["esMX"] = "Sierra Espolón",
        ["frFR"] = "Les Serres-Rocheuses",
        ["koKR"] = "돌발톱 산맥",
        ["ptBR"] = "Cordilheira das Torres de Pedra",
        ["ruRU"] = "Когтистые горы",
        ["zhCN"] = "石爪山脉",
        ["zhTW"] = "石爪山脈",
    },
    ["Darnassus"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "다르나서스",
        ["ptBR"] = true,
        ["ruRU"] = "Дарнасс",
        ["zhCN"] = "达纳苏斯",
        ["zhTW"] = "達納蘇斯",
    },
    ["Auberdine"] = { -- town in Darkshore, used as zoneOrSort in SoD quest for some reason
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "아우버다인",
        ["ptBR"] = true,
        ["ruRU"] = "Аубердин",
        ["zhCN"] = "奥伯丁",
        ["zhTW"] = "奥伯丁",
    },
    ["Uldum"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "울둠",
        ["ptBR"] = true,
        ["ruRU"] = "Ульдум",
        ["zhCN"] = "奥丹姆",
        ["zhTW"] = "奧丹姆",
    },
    ["Northern Barrens"] = {
        ["enUS"] = true,
        ["deDE"] = "Nördliches Brachland",
        ["esES"] = "Los Baldíos del Norte",
        ["esMX"] = "Los Baldíos del Norte",
        ["frFR"] = "Tarides du Nord",
        ["koKR"] = "북부 불모의 땅",
        ["ptBR"] = "Sertões Setentrionais",
        ["ruRU"] = "Северные Степи",
        ["zhCN"] = "北贫瘠之地",
        ["zhTW"] = "北貧瘠之地",
    },
    ["Southern Barrens"] = {
        ["enUS"] = true,
        ["deDE"] = "Südliches Brachland",
        ["esES"] = "Los Baldíos del Sur",
        ["esMX"] = "Los Baldíos del Sur",
        ["frFR"] = "Tarides du Sud",
        ["koKR"] = "남부 불모의 땅",
        ["ptBR"] = "Sertões Meridionais",
        ["ruRU"] = "Южные Степи",
        ["zhCN"] = "南贫瘠之地",
        ["zhTW"] = "南貧瘠之地",
    },
    ["Mount Hyjal"] = {
        ["enUS"] = true,
        ["deDE"] = "Hyjal",
        ["esES"] = "Monte Hyjal",
        ["esMX"] = "Monte Hyjal",
        ["frFR"] = "Mont Hyjal",
        ["koKR"] = "하이잘 산",
        ["ptBR"] = "Monte Hyjal",
        ["ruRU"] = "Хиджал",
        ["zhCN"] = "海加尔山",
        ["zhTW"] = "海加爾山",
    },
    ["The Steam Pools"] = {
        ["enUS"] = true,
        ["deDE"] = "Dampfteichen",
        ["esES"] = "Las Charcas Vaporosas",
        ["esMX"] = "Las Charcas Vaporosas",
        ["frFR"] = "Bassins de Vapeur",
        ["koKR"] = "증기 웅덩이",
        ["ptBR"] = "Lagos Vaporíferos",
        ["ruRU"] = "Дымящиеся озера",
        ["zhCN"] = "蒸汽之池",
        ["zhTW"] = "蒸汽之池",
    },
    ["Shadowglen"] = {
        ["enUS"] = true,
        ["deDE"] = "Laubschattental",
        ["esES"] = "Cañada Umbría",
        ["esMX"] = "Cañada Umbría",
        ["frFR"] = "Sombrevallon",
        ["koKR"] = "그늘 협곡",
        ["ptBR"] = "Umbravale",
        ["ruRU"] = "Тенистая долина",
        ["zhCN"] = "幽影谷",
        ["zhTW"] = "幽影谷",
    },
    ["Ahn'Qiraj: The Fallen Kingdom"] = {
        ["enUS"] = true,
        ["deDE"] = "Ahn'Qiraj: Das Gefallene Königreich",
        ["esES"] = "Ahn'Qiraj: El Reino Caído",
        ["esMX"] = "Ahn'Qiraj: El Reino Caído",
        ["frFR"] = "Ahn'Qiraj : le royaume Déchu",
        ["koKR"] = "안퀴라즈: 무너진 왕국",
        ["ptBR"] = "Ahn'Qiraj: O Reino Derrotado",
        ["ruRU"] = "Ан'Кираж: Павшее Королевство",
        ["zhCN"] = "安其拉：堕落王国",
        ["zhTW"] = "安其拉: 沒落的王朝",
    },
    ["Valley of Trials"] = {
        ["enUS"] = true,
        ["deDE"] = "Tal der Prüfungen",
        ["esES"] = "Valle de los Retos",
        ["esMX"] = "Valle de los Retos",
        ["frFR"] = "Vallée des Épreuves",
        ["koKR"] = "시험의 골짜기",
        ["ptBR"] = "Vale das Provações",
        ["ruRU"] = "Долина Испытаний",
        ["zhCN"] = "试炼谷",
        ["zhTW"] = "試煉谷",
    },
    ["Echo Isles"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Echoinseln",
        ["esES"] = "Islas del Eco",
        ["esMX"] = "Islas del Eco",
        ["frFR"] = "Îles de l’Écho",
        ["koKR"] = "메아리 섬",
        ["ptBR"] = "Ilhas do Eco",
        ["ruRU"] = "Острова Эха",
        ["zhCN"] = "回音群岛",
        ["zhTW"] = "回音群島",
    },
    ["Ruins of Uldum"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Uldum",
        ["esES"] = "Ruinas de Uldum",
        ["esMX"] = "Ruinas de Uldum",
        ["frFR"] = "Ruines de Uldum",
        ["koKR"] = "울둠 폐허",
        ["ptBR"] = "Ruínas de Uldum",
        ["ruRU"] = "Руины Ульдума",
        ["zhCN"] = "奥丹姆遗迹",
        ["zhTW"] = "奧丹姆廢墟",
    },
}

for k, v in pairs(kalimdorLocales) do
    l10n.translations[k] = v
end
