---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local outlandLocales = {
    ["Wrathscale Lair"] = {
        ["enUS"] = true,
        ["deDE"] = "Hassprankenzuflucht",
        ["esES"] = "Guarida Escama de Cólera",
        ["esMX"] = "Guarida Escama de Cólera",
        ["frFR"] = "Repaire des Irécailles",
        ["koKR"] = "성난비늘 둥지",
        ["ptBR"] = "Covil dos Escamódios",
        ["ruRU"] = "Логово клана Зловещей Чешуи",
        ["zhCN"] = "怒鳞巢穴",
        ["zhTW"] = "怒鱗巢穴",
    },
    ["Wayne's Refuge"] = {
        ["enUS"] = true,
        ["deDE"] = "Waynes Zuflucht",
        ["esES"] = "Refugio de Wayne",
        ["esMX"] = "Refugio de Wayne",
        ["frFR"] = "Refuge de Wayne",
        ["koKR"] = "웨인의 은거처",
        ["ptBR"] = "Refúgio de Wayne",
        ["ruRU"] = "Приют Уэйна",
        ["zhCN"] = "韦恩的避难所",
        ["zhTW"] = "韋恩的避難所",
    },
    ["Tranquil Shore"] = {
        ["enUS"] = true,
        ["deDE"] = "Die stille Küste",
        ["esES"] = "Orilla Tranquila",
        ["esMX"] = "Orilla Tranquila",
        ["frFR"] = "Rivage paisible",
        ["koKR"] = "평온의 해변",
        ["ptBR"] = "Costa Plácida",
        ["ruRU"] = "Безмятежный берег",
        ["zhCN"] = "静谧海岸",
        ["zhTW"] = "寧靜海岸",
    },
    ["Auren Falls"] = {
        ["enUS"] = true,
        ["deDE"] = "Aurenfälle",
        ["esES"] = "Cascadas Auren",
        ["esMX"] = "Cascadas Auren",
        ["frFR"] = "Chutes d'Auren",
        ["koKR"] = "아우렌 폭포",
        ["ptBR"] = "Cachoeira Auren",
        ["ruRU"] = "Водопад Аурен",
        ["zhCN"] = "奥伦瀑布",
        ["zhTW"] = "奧倫瀑布",
    },
    ["Coilskar Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Echsennarbe",
        ["esES"] = "Alto Cicatriz Espiral",
        ["esMX"] = "Alto Cicatriz Espiral",
        ["frFR"] = "Halte de Glissentaille",
        ["koKR"] = "갈퀴흉터 거점",
        ["ptBR"] = "Pontal dos Serpentálios",
        ["ruRU"] = "Лагерь Змеиных Колец",
        ["zhCN"] = "库斯卡岗哨",
        ["zhTW"] = "考斯卡崗哨",
    },
    ["The Sacred Grove"] = {
        ["enUS"] = true,
        ["deDE"] = "Der heilige Hain",
        ["esES"] = "La Arboleda Sagrada",
        ["esMX"] = "La Arboleda Sagrada",
        ["frFR"] = "Le Bosquet sacré",
        ["koKR"] = "신성한 숲",
        ["ptBR"] = "Bosque Sagrado",
        ["ruRU"] = "Священная роща",
        ["zhCN"] = "元素圣谷",
        ["zhTW"] = "神聖樹林",
    },
    ["Sun's Reach Armory"] = {
        ["enUS"] = true,
        ["deDE"] = "Waffenkammer der Sonnenweiten",
        ["esES"] = "Arsenal de Tramo del Sol",
        ["esMX"] = "Arsenal de Tramo del Sol",
        ["frFR"] = "Armurerie des Confins du soleil",
        ["koKR"] = "태양너울 무기고",
        ["ptBR"] = "Armaria de Beirassol",
        ["ruRU"] = "Оружейная Солнечного Края",
        ["zhCN"] = "阳湾军械库",
        ["zhTW"] = "日境軍械庫",
    },
    ["Wizard Row"] = {
        ["enUS"] = true,
        ["deDE"] = "Zaubergasse",
        ["esES"] = "Pasaje del Zahorí",
        ["esMX"] = "Pasaje del Zahorí",
        ["frFR"] = "Allée des sorciers",
        ["koKR"] = "마법사 지구",
        ["ptBR"] = "Estreito do Teurgo",
        ["ruRU"] = "Путь Волшебника",
        ["zhCN"] = "巫师街",
        ["zhTW"] = "巫師街",
    },
    ["Portal Clearing"] = {
        ["enUS"] = true,
        ["deDE"] = "Portalsicherung",
        ["esES"] = "Portal del Claro",
        ["esMX"] = "Portal del Claro",
        ["frFR"] = "Clairière du portail",
        ["koKR"] = "차원문 폐허",
        ["ptBR"] = "Clareira do Portal",
        ["ruRU"] = "Прогалина с порталом",
        ["zhCN"] = "荒弃传送门",
        ["zhTW"] = "暮光之門",
    },
    ["The Bloodoath"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Blutschwur",
        ["esES"] = "El Juramento de Sangre",
        ["esMX"] = "El Juramento de Sangre",
        ["frFR"] = "Le Serment de sang",
        ["koKR"] = "피의 맹세호",
        ["ptBR"] = "O Pacto de Sangue",
        ["ruRU"] = "Кровавая Клятва",
        ["zhCN"] = "血誓号",
        ["zhTW"] = "血之誓約",
    },
    ["Skald"] = {
        ["enUS"] = true,
        ["deDE"] = "Skald",
        ["esES"] = "Skald",
        ["esMX"] = "Skald",
        ["frFR"] = "Skald",
        ["koKR"] = "불타버린 언덕",
        ["ptBR"] = "Skald",
        ["ruRU"] = "Гарь",
        ["zhCN"] = "焦火荒野",
        ["zhTW"] = "斯卡德",
    },
    ["Reaver's Fall"] = {
        ["enUS"] = true,
        ["deDE"] = "Häschersturz",
        ["esES"] = "Caída del Atracador Vil",
        ["esMX"] = "Caída del Atracador Vil",
        ["frFR"] = "Le Trépas du saccageur",
        ["koKR"] = "지옥절단기 함락지",
        ["ptBR"] = "Posto dos Destroços",
        ["ruRU"] = "Гибель Сквернобота",
        ["zhCN"] = "机甲残骸",
        ["zhTW"] = "搶奪者荒野",
    },
    ["Ring of Observance"] = {
        ["enUS"] = true,
        ["deDE"] = "Ring der Beobachtung",
        ["esES"] = "Círculo de la Observancia",
        ["esMX"] = "Círculo de la Observancia",
        ["frFR"] = "Cercle d'observance",
        ["koKR"] = "규율의 광장",
        ["ptBR"] = "Círculo da Obediência",
        ["ruRU"] = "Ритуальный Круг",
        ["zhCN"] = "仪式广场",
        ["zhTW"] = "儀式競技場",
    },
    ["Lake Sunspring"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenwindsee",
        ["esES"] = "Lago Primasol",
        ["esMX"] = "Lago Primasol",
        ["frFR"] = "Lac Berceau-de-l'Eté",
        ["koKR"] = "태양여울 호수",
        ["ptBR"] = "Lago Solavera",
        ["ruRU"] = "Озеро Солнечного Источника",
        ["zhCN"] = "日泉湖",
        ["zhTW"] = "日春湖",
    },
    ["Northmaul Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Nordschlägerturm",
        ["esES"] = "Torre Quiebranorte",
        ["esMX"] = "Torre Quiebranorte",
        ["frFR"] = "Tour Nord-sanglante",
        ["koKR"] = "북녘망치 탑",
        ["ptBR"] = "Torre Martelo do Norte",
        ["ruRU"] = "Башня Северного Молота",
        ["zhCN"] = "北槌哨塔",
        ["zhTW"] = "北槌哨塔",
    },
    ["Town Square"] = {
        ["enUS"] = true,
        ["deDE"] = "Ratsplatz",
        ["esES"] = "Plaza de la Ciudad",
        ["esMX"] = "Plaza de la Ciudad",
        ["frFR"] = "Place centrale",
        ["koKR"] = "마을 광장",
        ["ptBR"] = "Praça da Cidade",
        ["ruRU"] = "Городская площадь",
        ["zhCN"] = "城镇广场",
        ["zhTW"] = "小鎮廣場",
    },
    ["Aldor Rise"] = {
        ["enUS"] = true,
        ["deDE"] = "Aldorhöhe",
        ["esES"] = "Alto Aldor",
        ["esMX"] = "Alto Aldor",
        ["frFR"] = "Éminence de l'Aldor",
        ["koKR"] = "알도르 마루",
        ["ptBR"] = "Terraço dos Aldor",
        ["ruRU"] = "Возвышенность Алдоров",
        ["zhCN"] = "奥尔多高地",
        ["zhTW"] = "奧多爾高地",
    },
    ["Zeth'Gor"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeth'Gor",
        ["esES"] = "Zeth'Gor",
        ["esMX"] = "Zeth'Gor",
        ["frFR"] = "Zeth'Gor",
        ["koKR"] = "제스고르",
        ["ptBR"] = "Zeth'Gor",
        ["ruRU"] = "Зет'Гор",
        ["zhCN"] = "塞斯高",
        ["zhTW"] = "薩斯葛爾",
    },
    ["Vindicator's Rest"] = {
        ["enUS"] = true,
        ["deDE"] = "Verteidigers Ruh'",
        ["esES"] = "El Reposo del Vindicador",
        ["esMX"] = "El Reposo del Vindicador",
        ["frFR"] = "Repos du redresseur de torts",
        ["koKR"] = "구원자의 안식처",
        ["ptBR"] = "Recanto do Vindicante",
        ["ruRU"] = "Привал Защитника",
        ["zhCN"] = "守备官营地",
        ["zhTW"] = "復仇者之陵",
    },
    ["Ruins of Baa'ri"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Baa'ri",
        ["esES"] = "Ruinas de Baa'ri",
        ["esMX"] = "Ruinas de Baa'ri",
        ["frFR"] = "Ruines de Baa'ri",
        ["koKR"] = "바아리 폐허",
        ["ptBR"] = "Ruínas de Baa'ri",
        ["ruRU"] = "Руины Баа'ри",
        ["zhCN"] = "巴尔里废墟",
        ["zhTW"] = "巴瑞廢墟",
    },
    ["Invasion Point: Overlord"] = {
        ["enUS"] = true,
        ["deDE"] = "Invasionspunkt: Oberanführer",
        ["esES"] = "Punto de Invasión: Señor Supremo",
        ["esMX"] = "Punto de Invasión: Señor Supremo",
        ["frFR"] = "Site d'invasion : Suzerain",
        ["koKR"] = "대군주의 침공 거점",
        ["ptBR"] = "Ponto de Invasão: Lorde supremo",
        ["ruRU"] = "Точка вторжения: Властитель",
        ["zhCN"] = "登陆场：霸王",
        ["zhTW"] = "侵略點:主宰者",
    },
    ["Blackwind Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenwindsee",
        ["esES"] = "Lago Vientonegro",
        ["esMX"] = "Lago Vientonegro",
        ["frFR"] = "Lac Noirvent",
        ["koKR"] = "검은바람 호수",
        ["ptBR"] = "Lago Ventonegro",
        ["ruRU"] = "Озеро Черного Ветра",
        ["zhCN"] = "黑风湖",
        ["zhTW"] = "黑風湖",
    },
    ["Ammen Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Am'menfelder",
        ["esES"] = "Campos Ammen",
        ["esMX"] = "Campos Ammen",
        ["frFR"] = "Champs d'Ammen",
        ["koKR"] = "암멘 들판",
        ["ptBR"] = "Campos Ammen",
        ["ruRU"] = "Поля Аммен",
        ["zhCN"] = "埃门平原",
        ["zhTW"] = "安曼牧場",
    },
    ["Windyreed Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Schilftanz",
        ["esES"] = "Aldea Junco Alabeado",
        ["esMX"] = "Aldea Junco Alabeado",
        ["frFR"] = "Ventejonc",
        ["koKR"] = "바람갈대 마을",
        ["ptBR"] = "Aldeia Canavento",
        ["ruRU"] = "Деревня Трепещущего Тростника",
        ["zhCN"] = "风茅村",
        ["zhTW"] = "風蘆村",
    },
    ["Umbrafen Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Umbrafennsee",
        ["esES"] = "Lago Umbropantano",
        ["esMX"] = "Lago Umbropantano",
        ["frFR"] = "Lac Umbretourbe",
        ["koKR"] = "그늘늪 호수",
        ["ptBR"] = "Lago Charco Sombrio",
        ["ruRU"] = "Озеро Тенетопь",
        ["zhCN"] = "暗泽湖",
        ["zhTW"] = "昂布拉凡湖",
    },
    ["An'owyn"] = {
        ["enUS"] = true,
        ["deDE"] = "An'owyn",
        ["esES"] = "An'owyn",
        ["esMX"] = "An'owyn",
        ["frFR"] = "An'owyn",
        ["koKR"] = "안오윈",
        ["ptBR"] = "An'owyn",
        ["ruRU"] = "Ан'овин",
        ["zhCN"] = "安欧维恩",
        ["zhTW"] = "安歐恩",
    },
    ["Axxarien"] = {
        ["enUS"] = true,
        ["deDE"] = "Axxarien",
        ["esES"] = "Axxarien",
        ["esMX"] = "Axxarien",
        ["frFR"] = "Axxarien",
        ["koKR"] = "악사리엔",
        ["ptBR"] = "Axxarien",
        ["ruRU"] = "Аксариен",
        ["zhCN"] = "阿克萨林",
        ["zhTW"] = "艾克薩瑞安",
    },
    ["Ruins of Silvermoon"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Silbermond",
        ["esES"] = "Ruinas de Lunargenta",
        ["esMX"] = "Ruinas de Lunargenta",
        ["frFR"] = "Ruines de Lune-d'argent",
        ["koKR"] = "실버문 폐허",
        ["ptBR"] = "Ruínas de Luaprata",
        ["ruRU"] = "Руины Луносвета",
        ["zhCN"] = "银月城废墟",
        ["zhTW"] = "銀月廢墟",
    },
    ["The Scrap Field"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Trümmerfeld",
        ["esES"] = "El Campo de Sobras",
        ["esMX"] = "El Campo de Sobras",
        ["frFR"] = "La Ferraille",
        ["koKR"] = "고철 지대",
        ["ptBR"] = "Campo dos Refugos",
        ["ruRU"] = "Захламленное поле",
        ["zhCN"] = "废料场",
        ["zhTW"] = "廢棄農場",
    },
    ["Derelict Manor"] = {
        ["enUS"] = true,
        ["deDE"] = "Heruntergekommenes Anwesen",
        ["esES"] = "Masión Derelicta",
        ["esMX"] = "Mansión Derelicta",
        ["frFR"] = "Manoir abandonné",
        ["koKR"] = "버려진 장원",
        ["ptBR"] = "Mansão Arruinada",
        ["ruRU"] = "Заброшенное поместье",
        ["zhCN"] = "荒弃的庄园",
        ["zhTW"] = "遺棄的莊園",
    },
    ["The Stormspire"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sturmsäule",
        ["esES"] = "La Flecha de la Tormenta",
        ["esMX"] = "La Flecha de la Tormenta",
        ["frFR"] = "La Foudreflèche",
        ["koKR"] = "폭풍 첨탑",
        ["ptBR"] = "Pináculo da Tempestade",
        ["ruRU"] = "Штормовая Вершина",
        ["zhCN"] = "风暴尖塔",
        ["zhTW"] = "風暴之尖",
    },
    ["The Cryo-Core"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Kryokern",
        ["esES"] = "El Crionúcleo",
        ["esMX"] = "El Crionúcleo",
        ["frFR"] = "Le cryocœur",
        ["koKR"] = "극저온 핵",
        ["ptBR"] = "Crio-núcleo",
        ["ruRU"] = "Криогенный блок",
        ["zhCN"] = "冷却核心",
        ["zhTW"] = "冬眠核心",
    },
    ["Sanctum of the Moon"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum des Mondes",
        ["esES"] = "Sagrario de la Luna",
        ["esMX"] = "Sagrario de la Luna",
        ["frFR"] = "Sanctum de la Lune",
        ["koKR"] = "달의 성소",
        ["ptBR"] = "Sacrário Lunar",
        ["ruRU"] = "Святилище Луны",
        ["zhCN"] = "月亮圣殿",
        ["zhTW"] = "明月聖所",
    },
    ["Blackwind Valley"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenwindtal",
        ["esES"] = "Valle Vientonegro",
        ["esMX"] = "Valle Vientonegro",
        ["frFR"] = "Vallée de Noirvent",
        ["koKR"] = "검은바람 계곡",
        ["ptBR"] = "Vale Ventonegro",
        ["ruRU"] = "Долина Черного Ветра",
        ["zhCN"] = "黑风谷",
        ["zhTW"] = "黑風谷",
    },
    ["Throne of the Elements"] = {
        ["enUS"] = true,
        ["deDE"] = "Thron der Elemente",
        ["esES"] = "El Trono de los Elementos",
        ["esMX"] = "El Trono de los Elementos",
        ["frFR"] = "Trône des éléments",
        ["koKR"] = "정령의 옥좌",
        ["ptBR"] = "Trono dos Elementos",
        ["ruRU"] = "Трон стихий",
        ["zhCN"] = "元素王座",
        ["zhTW"] = "元素王座",
    },
    ["Forge Camp: Rage"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Zorn",
        ["esES"] = "Campamento Forja: Ira",
        ["esMX"] = "Campamento Forja: Ira",
        ["frFR"] = "Camp de forge : Rage",
        ["koKR"] = "분노의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Raiva",
        ["ruRU"] = "Лагерь Легиона: Ярость",
        ["zhCN"] = "铸魔营地：狂乱",
        ["zhTW"] = "煉冶場:狂怒",
    },
    ["Toryl Estate"] = {
        ["enUS"] = true,
        ["deDE"] = "Toryls Grund",
        ["esES"] = "Los Dominios Toryl",
        ["esMX"] = "Los Dominios Toryl",
        ["frFR"] = "Domaine de Toryl",
        ["koKR"] = "토릴 영지",
        ["ptBR"] = "Propriedade Toryl",
        ["ruRU"] = "Имение Торила",
        ["zhCN"] = "托尔里公馆",
        ["zhTW"] = "托爾莊園",
    },
    ["The Low Path"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Niederpfad",
        ["esES"] = "El Paso Bajo",
        ["esMX"] = "El Paso Bajo",
        ["frFR"] = "Le Bas chemin",
        ["koKR"] = "낮은길",
        ["ptBR"] = "Estrada Baixa",
        ["ruRU"] = "Нижний путь",
        ["zhCN"] = "山谷小径",
        ["zhTW"] = "粗劣之地",
    },
    ["Wyrmskull Tunnel"] = {
        ["enUS"] = true,
        ["deDE"] = "Tunnel des Wyrmschädels",
        ["esES"] = "Túnel Calavermis",
        ["esMX"] = "Túnel Calavermis",
        ["frFR"] = "Tunnel Crâne-du-ver",
        ["koKR"] = "고룡해골 굴",
        ["ptBR"] = "Túnel Caveira de Dragão",
        ["ruRU"] = "Туннель Драконьего Черепа",
        ["zhCN"] = "龙颅小径",
        ["zhTW"] = "龍骨隧道",
    },
    ["Zeb'Watha"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeb'Watha",
        ["esES"] = "Zeb'Watha",
        ["esMX"] = "Zeb'Watha",
        ["frFR"] = "Zeb'Watha",
        ["koKR"] = "제브와타",
        ["ptBR"] = "Zeb'Watha",
        ["ruRU"] = "Зеб'Вата",
        ["zhCN"] = "塞布瓦萨",
        ["zhTW"] = "拉伯瓦薩",
    },
    ["The Bone Wastes"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Knochenwüste",
        ["esES"] = "El Vertedero de Huesos",
        ["esMX"] = "El Vertedero de Huesos",
        ["frFR"] = "Le désert des Ossements",
        ["koKR"] = "해골 무덤",
        ["ptBR"] = "Deserto de Ossos",
        ["ruRU"] = "Костяные пустоши",
        ["zhCN"] = "白骨荒野",
        ["zhTW"] = "白骨荒野",
    },
    ["Obsidia's Perch"] = {
        ["enUS"] = true,
        ["deDE"] = "Obsidias Hort",
        ["esES"] = "Nido de Obsidia",
        ["esMX"] = "Nido de Obsidia",
        ["frFR"] = "Perchoir d'Obsidia",
        ["koKR"] = "옵시디아의 둥지",
        ["ptBR"] = "Ninho de Obsídia",
        ["ruRU"] = "Гнездо Обсидии",
        ["zhCN"] = "欧比斯迪栖木",
        ["zhTW"] = "歐比希迪亞棲所",
    },
    ["Invasion Point: Destroyer"] = {
        ["enUS"] = true,
        ["deDE"] = "Invasionspunkt: Zerstörer",
        ["esES"] = "Punto de Invasión: Destructor",
        ["esMX"] = "Punto de Invasión: Destructor",
        ["frFR"] = "Site d'invasion : Destructeur",
        ["koKR"] = "파괴자의 침공 거점",
        ["ptBR"] = "Ponto de Invasão: Destruidor",
        ["ruRU"] = "Точка вторжения: Разрушитель",
        ["zhCN"] = "登陆场：破坏",
        ["zhTW"] = "侵略點:摧毀者",
    },
    ["The Stadium"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Stadion",
        ["esES"] = "El Estadium",
        ["esMX"] = "El Estadium",
        ["frFR"] = "Le Stade",
        ["koKR"] = "경기장",
        ["ptBR"] = "O Estádio",
        ["ruRU"] = "Ристалище",
        ["zhCN"] = "竞赛场",
        ["zhTW"] = "競技場",
    },
    ["Sha'naari Wastes"] = {
        ["enUS"] = true,
        ["deDE"] = "Weiten von Sha'naari",
        ["esES"] = "Ruinas Sha'naari",
        ["esMX"] = "Ruinas Sha'naari",
        ["frFR"] = "Le désert Sha'naari",
        ["koKR"] = "샤나아리 황무지",
        ["ptBR"] = "Deserto Sha'naari",
        ["ruRU"] = "Пустоши Ша'наари",
        ["zhCN"] = "沙纳尔荒地",
        ["zhTW"] = "夏納瑞荒地",
    },
    ["Kil'sorrow Fortress"] = {
        ["enUS"] = true,
        ["deDE"] = "Festung Kil'sorge",
        ["esES"] = "Fortaleza Mata'penas",
        ["esMX"] = "Fortaleza Mata'penas",
        ["frFR"] = "Forteresse Kil'sorrau",
        ["koKR"] = "킬소로우 요새",
        ["ptBR"] = "Fortaleza Kil'pesar",
        ["ruRU"] = "Бастион Вечной Скорби",
        ["zhCN"] = "基尔索罗堡垒",
        ["zhTW"] = "吉爾索洛堡壘",
    },
    ["Celestial Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Sternensturz",
        ["esES"] = "Cresta Celestial",
        ["esMX"] = "Cresta Celestial",
        ["frFR"] = "Crête céleste",
        ["koKR"] = "하늘 마루",
        ["ptBR"] = "Pico Celestial",
        ["ruRU"] = "Небесная гряда",
        ["zhCN"] = "苍穹之脊",
        ["zhTW"] = "天國山脈",
    },
    ["Test"] = {
        ["enUS"] = true,
        ["deDE"] = "Test",
        ["esES"] = "Test",
        ["esMX"] = "Test",
        ["frFR"] = "Test",
        ["koKR"] = "시험용",
        ["ptBR"] = "Test",
        ["ruRU"] = "Тест",
        ["zhCN"] = "Test",
        ["zhTW"] = "Test",
    },
    ["Ruins of Karabor"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Karabor",
        ["esES"] = "Ruinas de Karabor",
        ["esMX"] = "Ruinas de Karabor",
        ["frFR"] = "Ruines de Karabor",
        ["koKR"] = "카라보르 폐허",
        ["ptBR"] = "Ruínas de Karabor",
        ["ruRU"] = "Руины Карабора",
        ["zhCN"] = "卡拉波废墟",
        ["zhTW"] = "卡拉伯爾廢墟",
    },
    ["Skulking Row"] = {
        ["enUS"] = true,
        ["deDE"] = "Lauergasse",
        ["esES"] = "El Frontal de la Muerte",
        ["esMX"] = "El Frontal de la Muerte",
        ["frFR"] = "Allée de la rôdaille",
        ["koKR"] = "위험한 거리",
        ["ptBR"] = "Passeio Furtivo",
        ["ruRU"] = "Обводной путь",
        ["zhCN"] = "匿影小径",
        ["zhTW"] = "潛隱路",
    },
    ["Shadow Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenkamm",
        ["esES"] = "Cresta de las Sombras",
        ["esMX"] = "Cresta de las Sombras",
        ["frFR"] = "Ombrecrête",
        ["koKR"] = "어둠 마루",
        ["ptBR"] = "Serra das Sombras",
        ["ruRU"] = "Хребет Теней",
        ["zhCN"] = "暗影山",
        ["zhTW"] = "暗影山脊",
    },
    ["Nestlewood Thicket"] = {
        ["enUS"] = true,
        ["deDE"] = "Nisteldickicht",
        ["esES"] = "Matorral Cubrebosque",
        ["esMX"] = "Matorral Cubrebosque",
        ["frFR"] = "Fourré des Nidebois",
        ["koKR"] = "다닥나무 숲",
        ["ptBR"] = "Mata Ninhal",
        ["ruRU"] = "Совиная чаща",
        ["zhCN"] = "木巢林地",
        ["zhTW"] = "奈斯特灌木林",
    },
    ["Nestlewood Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Nistelhügel",
        ["esES"] = "Colinas Cubrebosque",
        ["esMX"] = "Colinas Cubrebosque",
        ["frFR"] = "Collines des Nidebois",
        ["koKR"] = "다닥나무 언덕",
        ["ptBR"] = "Serra do Ninhal",
        ["ruRU"] = "Совиные холмы",
        ["zhCN"] = "木巢山",
        ["zhTW"] = "奈斯特山丘",
    },
    ["Traitor's Cove"] = {
        ["enUS"] = true,
        ["deDE"] = "Verräterbucht",
        ["esES"] = "Cala del Traidor",
        ["esMX"] = "Cala del Traidor",
        ["frFR"] = "Crique du traître",
        ["koKR"] = "배신자의 만",
        ["ptBR"] = "Angra do Traidor",
        ["ruRU"] = "Бухта Изменника",
        ["zhCN"] = "叛徒湾",
        ["zhTW"] = "背叛者海灣",
    },
    ["Auren Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Aurenkamm",
        ["esES"] = "Cresta Auren",
        ["esMX"] = "Cresta Auren",
        ["frFR"] = "Crête d'Auren",
        ["koKR"] = "아우렌 마루",
        ["ptBR"] = "Pico Auren",
        ["ruRU"] = "Гряда Аурен",
        ["zhCN"] = "奥伦山脊",
        ["zhTW"] = "奧倫山脊",
    },
    ["Dustquill Ravine"] = {
        ["enUS"] = true,
        ["deDE"] = "Staubstachelschlucht",
        ["esES"] = "Barranco Pluma Polvorienta",
        ["esMX"] = "Barranco Pluma Polvorienta",
        ["frFR"] = "Ravin de Plumepoussière",
        ["koKR"] = "먼지깃 협곡",
        ["ptBR"] = "Ravina do Pó de Espinheiro",
        ["ruRU"] = "Лощина Пыльного Пера",
        ["zhCN"] = "尘羽峡谷",
        ["zhTW"] = "塵羽峽谷",
    },
    ["Veil Reskk"] = {
        ["enUS"] = true,
        ["deDE"] = "Reskkversteck",
        ["esES"] = "Velo Reskk",
        ["esMX"] = "Velo Reskk",
        ["frFR"] = "Voile Reskk",
        ["koKR"] = "장막의 레스크",
        ["ptBR"] = "Véu Reskk",
        ["ruRU"] = "Гнездовье Ресск",
        ["zhCN"] = "里斯克鸦巢",
        ["zhTW"] = "迷霧瑞斯克",
    },
    ["The Proving Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Versuchsgründe",
        ["esES"] = "Terreno de Pruebas",
        ["esMX"] = "Terreno de Pruebas",
        ["frFR"] = "Le Terrain d'essai",
        ["koKR"] = "발명품 실험장",
        ["ptBR"] = "Campo de Testes",
        ["ruRU"] = "Испытательный полигон",
        ["zhCN"] = "实验场",
        ["zhTW"] = "試煉場",
    },
    ["Darkcrest Shore"] = {
        ["enUS"] = true,
        ["deDE"] = "Küste der Dunkelkämme",
        ["esES"] = "Playa Crestanegra",
        ["esMX"] = "Playa Crestanegra",
        ["frFR"] = "Rivage des Sombrecrêtes",
        ["koKR"] = "암흑갈기 호숫가",
        ["ptBR"] = "Praia da Cristanegra",
        ["ruRU"] = "Побережье Темного Гребня",
        ["zhCN"] = "暗潮湖岸",
        ["zhTW"] = "暗羽陸地",
    },
    ["Menagerie Wreckage"] = {
        ["enUS"] = true,
        ["deDE"] = "Menagerietrümmer",
        ["esES"] = "Restos del Arca",
        ["esMX"] = "Restos del Arca",
        ["frFR"] = "Débris de la ménagerie",
        ["koKR"] = "화물선 잔해",
        ["ptBR"] = "Destroços da Arca",
        ["ruRU"] = "Останки Зверинца",
        ["zhCN"] = "兽笼残骸",
        ["zhTW"] = "獸欄殘骸",
    },
    ["Bloodmyst Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutmythosinsel",
        ["esES"] = "Isla Bruma de Sangre",
        ["esMX"] = "Isla Bruma de Sangre",
        ["frFR"] = "Ile de Brume-sang",
        ["koKR"] = "핏빛안개 섬",
        ["ptBR"] = "Ilha Névoa Rubra",
        ["ruRU"] = "Остров Кровавой Дымки",
        ["zhCN"] = "秘血岛",
        ["zhTW"] = "血謎島",
    },
    ["Bonechewer Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen der Knochenmalmer",
        ["esES"] = "Ruinas Mascahuesos",
        ["esMX"] = "Ruinas Mascahuesos",
        ["frFR"] = "Ruines Mâche-les-os",
        ["koKR"] = "해골이빨 폐허",
        ["ptBR"] = "Ruínas Mascaosso",
        ["ruRU"] = "Руины Костеглодов",
        ["zhCN"] = "噬骨废墟",
        ["zhTW"] = "噬骨者廢墟",
    },
    ["Azuremyst Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Azurmythosinsel",
        ["esES"] = "Isla Bruma Azur",
        ["esMX"] = "Isla Bruma Azur",
        ["frFR"] = "Ile de Brume-azur",
        ["koKR"] = "하늘안개 섬",
        ["ptBR"] = "Ilha Névoa Lazúli",
        ["ruRU"] = "Остров Лазурной Дымки",
        ["zhCN"] = "秘蓝岛",
        ["zhTW"] = "藍謎島",
    },
    ["Moonwing Den"] = {
        ["enUS"] = true,
        ["deDE"] = "Mondschwingenbau",
        ["esES"] = "Túmulo Lunala",
        ["esMX"] = "Túmulo Lunala",
        ["frFR"] = "Tanière Aile-de-lune",
        ["koKR"] = "달날개 소굴",
        ["ptBR"] = "Covil dos Coruscantes",
        ["ruRU"] = "Прибежище Лунных Крыльев",
        ["zhCN"] = "月翼洞穴",
        ["zhTW"] = "月翼獸窟",
    },
    ["The Legion Front"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Front der Legion",
        ["esES"] = "La Avanzadilla de la Legión",
        ["esMX"] = "La Avanzadilla de la Legión",
        ["frFR"] = "Le front de la Légion",
        ["koKR"] = "군단 전초지",
        ["ptBR"] = "O Front da Legião",
        ["ruRU"] = "Передовая Легиона",
        ["zhCN"] = "军团前线",
        ["zhTW"] = "軍團前線",
    },
    ["Elemental Plateau"] = {
        ["enUS"] = true,
        ["deDE"] = "Elementarplateau",
        ["esES"] = "Meseta Elemental",
        ["esMX"] = "Meseta Elemental",
        ["frFR"] = "Plateau élémentaire",
        ["koKR"] = "정령의 고원",
        ["ptBR"] = "Platô Elemental",
        ["ruRU"] = "Плато Стихий",
        ["zhCN"] = "元素高地",
        ["zhTW"] = "元素高原",
    },
    ["Tel'athion's Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Tel'athions Lager",
        ["esES"] = "Campamento de Tel'athion",
        ["esMX"] = "Campamento de Tel'athion",
        ["frFR"] = "Camp de Tel'athion",
        ["koKR"] = "텔아시온의 야영지",
        ["ptBR"] = "Acampamento do Tel'athion",
        ["ruRU"] = "Лагерь Тел'атиона",
        ["zhCN"] = "塔希恩的营地",
        ["zhTW"] = "泰勒希歐營地",
    },
    ["Bristlelimb Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Dorf der Sichelklauen",
        ["esES"] = "Aldea Brazolanudo",
        ["esMX"] = "Aldea Brazolanudo",
        ["frFR"] = "Village des Bras-hirsutes",
        ["koKR"] = "뾰족가지 마을",
        ["ptBR"] = "Aldeia dos Ericerdos",
        ["ruRU"] = "Деревня Косолапов",
        ["zhCN"] = "刺臂村",
        ["zhTW"] = "鬚肢村",
    },
    ["Wildhammer Stronghold"] = {
        ["enUS"] = true,
        ["deDE"] = "Wildhammerfeste",
        ["esES"] = "Bastión Martillo Salvaje",
        ["esMX"] = "Bastión Martillo Salvaje",
        ["frFR"] = "Bastion des Marteaux-hardis",
        ["koKR"] = "와일드해머 성채",
        ["ptBR"] = "Fortaleza Martelo Feroz",
        ["ruRU"] = "Цитадель Громового Молота",
        ["zhCN"] = "蛮锤要塞",
        ["zhTW"] = "蠻錘要塞",
    },
    ["Goldenmist Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Goldnebel",
        ["esES"] = "Aldea de Bruma Dorada",
        ["esMX"] = "Aldea Bruma Dorada",
        ["frFR"] = "Brume-d'or",
        ["koKR"] = "황금안개 마을",
        ["ptBR"] = "Vila de Aurinévoa",
        ["ruRU"] = "Деревня Золотистой Дымки",
        ["zhCN"] = "金雾村",
        ["zhTW"] = "金霧村",
    },
    ["Wrathscale Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Hassprankenterritorium",
        ["esES"] = "Punto Escama de Cólera",
        ["esMX"] = "Punto Escama de Cólera",
        ["frFR"] = "Cap des Irécailles",
        ["koKR"] = "성난비늘 거점",
        ["ptBR"] = "Posto Escamódio",
        ["ruRU"] = "Руины Зловещей Чешуи",
        ["zhCN"] = "怒鳞岗哨",
        ["zhTW"] = "怒鱗崗哨",
    },
    ["Trogma's Claim"] = {
        ["enUS"] = true,
        ["deDE"] = "Trogmas Besitz",
        ["esES"] = "La Llamada de Trogma",
        ["esMX"] = "La Llamada de Trogma",
        ["frFR"] = "La prétention de Trogma",
        ["koKR"] = "트로그마의 점령지",
        ["ptBR"] = "Mina de Trogma",
        ["ruRU"] = "Участок Трогмы",
        ["zhCN"] = "托格玛洞穴",
        ["zhTW"] = "索格瑪領土",
    },
    ["The Barrier Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Hügelwand",
        ["esES"] = "Las Colinas Barrera",
        ["esMX"] = "Las Colinas Barrera",
        ["frFR"] = "La Barrière",
        ["koKR"] = "울타리 언덕",
        ["ptBR"] = "Picos da Barreira",
        ["ruRU"] = "Пограничные холмы",
        ["zhCN"] = "壁垒山",
        ["zhTW"] = "阻礙之丘",
    },
    ["Blade's Edge Mountains"] = {
        ["enUS"] = true,
        ["deDE"] = "Schergrat",
        ["esES"] = "Montañas Filospada",
        ["esMX"] = "Montañas Filospada",
        ["frFR"] = "Les Tranchantes",
        ["koKR"] = "칼날 산맥",
        ["ptBR"] = "Montanhas da Lâmina Afiada",
        ["ruRU"] = "Острогорье",
        ["zhCN"] = "刀锋山",
        ["zhTW"] = "劍刃山脈",
    },
    ["The Crumbling Waste"] = {
        ["enUS"] = true,
        ["deDE"] = "Die schwindende Weite",
        ["esES"] = "Las Ruinas Desmoronadas",
        ["esMX"] = "Las Ruinas Desmoronadas",
        ["frFR"] = "La Désagrégation",
        ["koKR"] = "부서진 잔해",
        ["ptBR"] = "Ermo Esfacelado",
        ["ruRU"] = "Гиблый пустырь",
        ["zhCN"] = "碎裂废土",
        ["zhTW"] = "破碎荒地",
    },
    ["Zangarmarsh"] = {
        ["enUS"] = true,
        ["deDE"] = "Zangarmarschen",
        ["esES"] = "Marisma de Zangar",
        ["esMX"] = "Marisma de Zangar",
        ["frFR"] = "Marécage de Zangar",
        ["koKR"] = "장가르 습지대",
        ["ptBR"] = "Pântano Zíngaro",
        ["ruRU"] = "Зангартопь",
        ["zhCN"] = "赞加沼泽",
        ["zhTW"] = "贊格沼澤",
    },
    ["Tor'Watha"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor'Watha",
        ["esES"] = "Tor'Watha",
        ["esMX"] = "Tor'Watha",
        ["frFR"] = "Tor'Watha",
        ["koKR"] = "토르와타",
        ["ptBR"] = "Tor'Watha",
        ["ruRU"] = "Тор'Вата",
        ["zhCN"] = "托尔瓦萨",
        ["zhTW"] = "托爾瓦薩",
    },
    ["Terokkar Forest"] = {
        ["enUS"] = true,
        ["deDE"] = "Wälder von Terokkar",
        ["esES"] = "Bosque de Terokkar",
        ["esMX"] = "Bosque de Terokkar",
        ["frFR"] = "Forêt de Terokkar",
        ["koKR"] = "테로카르 숲",
        ["ptBR"] = "Mata Terokkar",
        ["ruRU"] = "Лес Тероккар",
        ["zhCN"] = "泰罗卡森林",
        ["zhTW"] = "泰洛卡森林",
    },
    ["The Sin'loren"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sin'loren",
        ["esES"] = "El Sin'loren",
        ["esMX"] = "El Sin'loren",
        ["frFR"] = "Le Sin'loren",
        ["koKR"] = "신로렌호",
        ["ptBR"] = "O Sin'lonren",
        ["ruRU"] = "Син'лорен",
        ["zhCN"] = "辛洛雷号",
        ["zhTW"] = "辛洛倫",
    },
    ["Nagrand"] = {
        ["enUS"] = true,
        ["deDE"] = "Nagrand",
        ["esES"] = "Nagrand",
        ["esMX"] = "Nagrand",
        ["frFR"] = "Nagrand",
        ["koKR"] = "나그란드",
        ["ptBR"] = "Nagrand",
        ["ruRU"] = "Награнд",
        ["zhCN"] = "纳格兰",
        ["zhTW"] = "納葛蘭",
    },
    ["Expedition Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Expeditionsposten",
        ["esES"] = "Punta de Expedición",
        ["esMX"] = "Punta de Expedición",
        ["frFR"] = "Halte de l'expédition",
        ["koKR"] = "원정대 거점",
        ["ptBR"] = "Posto da Expedição",
        ["ruRU"] = "Лагерь экспедиции",
        ["zhCN"] = "远征军岗哨",
        ["zhTW"] = "遠征隊哨塔",
    },
    ["Zeb'Nowa"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeb'Nowa",
        ["esES"] = "Zeb'Nowa",
        ["esMX"] = "Zeb'Nowa",
        ["frFR"] = "Zeb'Nowa",
        ["koKR"] = "제브노와",
        ["ptBR"] = "Zeb'Nowa",
        ["ruRU"] = "Зеб'Нова",
        ["zhCN"] = "塞布努瓦",
        ["zhTW"] = "札布諾瓦",
    },
    ["Farstrider Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Enklave der Weltenwanderer",
        ["esES"] = "Enclave del Errante",
        ["esMX"] = "Enclave del Errante",
        ["frFR"] = "Enclave des Pérégrins",
        ["koKR"] = "원정순찰대 초소",
        ["ptBR"] = "Enclave dos Andarilhos",
        ["ruRU"] = "Анклав Странников",
        ["zhCN"] = "远行者营地",
        ["zhTW"] = "遠行者營地",
    },
    ["Zeb'Tela"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeb'Tela",
        ["esES"] = "Zeb'Tela",
        ["esMX"] = "Zeb'Tela",
        ["frFR"] = "Zeb'Tela",
        ["koKR"] = "제브텔라",
        ["ptBR"] = "Zeb'Tela",
        ["ruRU"] = "Зеб'Тела",
        ["zhCN"] = "塞布提拉",
        ["zhTW"] = "札布泰拉",
    },
    ["Thunderlord Stronghold"] = {
        ["enUS"] = true,
        ["deDE"] = "Donnerfeste",
        ["esES"] = "Bastión Señor del Trueno",
        ["esMX"] = "Bastión Señor del Trueno",
        ["frFR"] = "Bastion des Sire-tonnerre",
        ["koKR"] = "천둥군주 요새",
        ["ptBR"] = "Cidadela do Senhor do Trovão",
        ["ruRU"] = "Оплот Громоборцев",
        ["zhCN"] = "雷神要塞",
        ["zhTW"] = "雷霆王村",
    },
    ["Toshley's Station"] = {
        ["enUS"] = true,
        ["deDE"] = "Toshleys Station",
        ["esES"] = "Estación de Toshley",
        ["esMX"] = "Estación de Toshley",
        ["frFR"] = "Poste de Toshley",
        ["koKR"] = "토쉴리의 연구기지",
        ["ptBR"] = "Estação do Tocha",
        ["ruRU"] = "Станция Тошли",
        ["zhCN"] = "托什雷的基地",
        ["zhTW"] = "托斯利基地",
    },
    ["Elrendar River"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Elrendar",
        ["esES"] = "Río Elrendar",
        ["esMX"] = "Río Elrendar",
        ["frFR"] = "L'Elrendar",
        ["koKR"] = "엘렌다르 강",
        ["ptBR"] = "Rio Elrendar",
        ["ruRU"] = "Река Элрендар",
        ["zhCN"] = "艾尔伦达河",
        ["zhTW"] = "艾蘭達之河",
    },
    ["Forge Base: Gehenna"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionsbasis: Gehenna",
        ["esES"] = "Base Forja: Gehenna",
        ["esMX"] = "Base Forja: Gehenna",
        ["frFR"] = "Base de forge : Géhenne",
        ["koKR"] = "지옥의 괴철로 주둔지",
        ["ptBR"] = "Base-forja: Geena",
        ["ruRU"] = "База Легиона: Геенна",
        ["zhCN"] = "铸魔基地：炼狱",
        ["zhTW"] = "熔爐基地:苦難",
    },
    ["Fallen Sky Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Himmelssturzgrat",
        ["esES"] = "Cresta Cielo Estrellado",
        ["esMX"] = "Cresta Cielo Estrellado",
        ["frFR"] = "Crête Tombeciel",
        ["koKR"] = "무너진 하늘 마루",
        ["ptBR"] = "Serra do Céu Caído",
        ["ruRU"] = "Гряда Упавшего Неба",
        ["zhCN"] = "坠星山",
        ["zhTW"] = "墜天山脈",
    },
    ["Zeb'Sora"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeb'Sora",
        ["esES"] = "Zeb'Sora",
        ["esMX"] = "Zeb'Sora",
        ["frFR"] = "Zeb'Sora",
        ["koKR"] = "제브소라",
        ["ptBR"] = "Zeb'Sora",
        ["ruRU"] = "Зеб'Сора",
        ["zhCN"] = "塞布索雷",
        ["zhTW"] = "札布索拉",
    },
    ["Fairbreeze Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Morgenluft",
        ["esES"] = "Aldea Brisa Pura",
        ["esMX"] = "Aldea Brisa Pura",
        ["frFR"] = "Brise-clémente",
        ["koKR"] = "산들바람 마을",
        ["ptBR"] = "Vila de Brisabela",
        ["ruRU"] = "Деревня Легкий Ветерок",
        ["zhCN"] = "晴风村",
        ["zhTW"] = "晴風村",
    },
    ["Amani Catacombs"] = {
        ["enUS"] = true,
        ["deDE"] = "Amanikatakomben",
        ["esES"] = "Catacumbas Amani",
        ["esMX"] = "Catacumbas Amani",
        ["frFR"] = "Catacombes des Amani",
        ["koKR"] = "아마니 지하묘지",
        ["ptBR"] = "Catacumbas Amani",
        ["ruRU"] = "Катакомбы Амани",
        ["zhCN"] = "阿曼尼墓穴",
        ["zhTW"] = "阿曼尼地下墓穴",
    },
    ["Arklon Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Arklon",
        ["esES"] = "Ruinas Arklon",
        ["esMX"] = "Ruinas Arklon",
        ["frFR"] = "Ruines Arklon",
        ["koKR"] = "알클론 폐허",
        ["ptBR"] = "Ruínas Arklon",
        ["ruRU"] = "Руины Арклона",
        ["zhCN"] = "阿尔科隆废墟",
        ["zhTW"] = "阿克隆廢墟",
    },
    ["Sungraze Peak"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenhügel",
        ["esES"] = "Cima Rasguño de Sol",
        ["esMX"] = "Cima Rasguño de Sol",
        ["frFR"] = "Pic de Frôle-soleil",
        ["koKR"] = "해넘이 봉우리",
        ["ptBR"] = "Monte Triscassol",
        ["ruRU"] = "Пик Солнечного Пастбища",
        ["zhCN"] = "阳痕峰",
        ["zhTW"] = "日傷山峰",
    },
    ["Amani Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Amanipass",
        ["esES"] = "Paso de Amani",
        ["esMX"] = "Paso de Amani",
        ["frFR"] = "Passage des Amani",
        ["koKR"] = "아마니 고개",
        ["ptBR"] = "Desfiladeiro Amani",
        ["ruRU"] = "Перевал Амани",
        ["zhCN"] = "阿曼尼小径",
        ["zhTW"] = "阿曼尼小徑",
    },
    ["Dragonspine Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Drachenwirbelgrat",
        ["esES"] = "Cresta Espinazo de Dragón",
        ["esMX"] = "Cresta Espinazo de Dragón",
        ["frFR"] = "Crête d'Epine-de-dragon",
        ["koKR"] = "용돌기 마루",
        ["ptBR"] = "Serra de Espinodraco",
        ["ruRU"] = "Драконий хребет",
        ["zhCN"] = "龙脊岭",
        ["zhTW"] = "龍脊山脊",
    },
    ["Socrethar's Seat"] = {
        ["enUS"] = true,
        ["deDE"] = "Socrethars Sitz",
        ["esES"] = "Trono de Socrethar",
        ["esMX"] = "Trono de Socrethar",
        ["frFR"] = "Siège de Socrethar",
        ["koKR"] = "소크레타르의 옥좌",
        ["ptBR"] = "Trono de Socrethar",
        ["ruRU"] = "Трон Сокретара",
        ["zhCN"] = "索克雷萨之座",
        ["zhTW"] = "索奎薩爾的領地",
    },
    ["Silmyr Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Silmyrsee",
        ["esES"] = "Lago Silmyr",
        ["esMX"] = "Lago Silmyr",
        ["frFR"] = "Lac Silmyr",
        ["koKR"] = "실미르 호수",
        ["ptBR"] = "Lago Silmyr",
        ["ruRU"] = "Озеро Силмир",
        ["zhCN"] = "希尔米耶湖",
        ["zhTW"] = "泥濘湖",
    },
    ["Hatchet Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Axthügel",
        ["esES"] = "Colinas Hacha",
        ["esMX"] = "Colinas Hacha",
        ["frFR"] = "Collines de la Cognée",
        ["koKR"] = "도끼 언덕",
        ["ptBR"] = "Serra da Machadinha",
        ["ruRU"] = "Холмы Томагавков",
        ["zhCN"] = "战斧岭",
        ["zhTW"] = "戰斧嶺",
    },
    ["Skettis"] = {
        ["enUS"] = true,
        ["deDE"] = "Skettis",
        ["esES"] = "Skettis",
        ["esMX"] = "Skettis",
        ["frFR"] = "Skettis",
        ["koKR"] = "스케티스",
        ["ptBR"] = "Skettis",
        ["ruRU"] = "Скеттис",
        ["zhCN"] = "斯克提斯",
        ["zhTW"] = "司凱堤斯",
    },
    ["Auchenai Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Auchenaigründe",
        ["esES"] = "Tierras Auchenai",
        ["esMX"] = "Tierras Auchenai",
        ["frFR"] = "Terres Auchenaï",
        ["koKR"] = "아키나이 영지",
        ["ptBR"] = "Território Auchenai",
        ["ruRU"] = "Аукенайские земли",
        ["zhCN"] = "奥金尼废墟",
        ["zhTW"] = "奧奇奈營地",
    },
    ["Broken Hill"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Trümmerbastion",
        ["esES"] = "Cerro Tábido",
        ["esMX"] = "Cerro Tábido",
        ["frFR"] = "Colline brisée",
        ["koKR"] = "무너진 언덕",
        ["ptBR"] = "Monte Partido",
        ["ruRU"] = "Изрезанный холм",
        ["zhCN"] = "碎石岭",
        ["zhTW"] = "破碎之丘",
    },
    ["Mag'har Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Posten der Mag'har",
        ["esES"] = "Puesto Mag'har",
        ["esMX"] = "Puesto Mag'har",
        ["frFR"] = "Poste Mag'har",
        ["koKR"] = "마그하르 거점",
        ["ptBR"] = "Posto Mag'har",
        ["ruRU"] = "Застава маг'харов",
        ["zhCN"] = "玛格汉岗哨",
        ["zhTW"] = "瑪格哈崗哨",
    },
    ["Honor Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Ehrenfeste",
        ["esES"] = "Bastión del Honor",
        ["esMX"] = "Bastión del Honor",
        ["frFR"] = "Bastion de l'Honneur",
        ["koKR"] = "명예의 요새",
        ["ptBR"] = "Fortaleza da Honra",
        ["ruRU"] = "Оплот Чести",
        ["zhCN"] = "荣耀堡",
        ["zhTW"] = "榮譽堡",
    },
    ["Netherstone"] = {
        ["enUS"] = true,
        ["deDE"] = "Netherstein",
        ["esES"] = "Piedra Abisal",
        ["esMX"] = "Piedra Abisal",
        ["frFR"] = "Pierre-de-Néant",
        ["koKR"] = "황천의 돌무지",
        ["ptBR"] = "Pedra Etérea",
        ["ruRU"] = "Осколки Пустоты",
        ["zhCN"] = "虚空石",
        ["zhTW"] = "虛空石",
    },
    ["Lake Elrendar"] = {
        ["enUS"] = true,
        ["deDE"] = "Elrendarsee",
        ["esES"] = "Lago Elrendar",
        ["esMX"] = "Lago Elrendar",
        ["frFR"] = "Lac Elrendar",
        ["koKR"] = "엘렌다르 호수",
        ["ptBR"] = "Lago Elrendar",
        ["ruRU"] = "Озеро Элрендар",
        ["zhCN"] = "艾伦达尔湖",
        ["zhTW"] = "艾蘭達之湖",
    },
    ["Scryer's Tier"] = {
        ["enUS"] = true,
        ["deDE"] = "Sehertreppe",
        ["esES"] = "Grada del Arúspice",
        ["esMX"] = "Grada del Arúspice",
        ["frFR"] = "Degré des Clairvoyants",
        ["koKR"] = "점술가 언덕",
        ["ptBR"] = "Terraço dos Áugures",
        ["ruRU"] = "Ярус Провидцев",
        ["zhCN"] = "占星者之台",
        ["zhTW"] = "占卜者階梯",
    },
    ["Saltheril's Haven"] = {
        ["enUS"] = true,
        ["deDE"] = "Saltherils Hafen",
        ["esES"] = "Refugio de Saltheril",
        ["esMX"] = "Refugio de Saltheril",
        ["frFR"] = "Havre de Saltheril",
        ["koKR"] = "살데릴의 안식처",
        ["ptBR"] = "Refúgio de Saltheril",
        ["ruRU"] = "Вилла Салтерила",
        ["zhCN"] = "萨瑟利尔庄园",
        ["zhTW"] = "薩瑟里的避風港",
    },
    ["Arklonis Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Arklonisgrat",
        ["esES"] = "Cresta Arklonis",
        ["esMX"] = "Cresta Arklonis",
        ["frFR"] = "Crête d'Arklonis",
        ["koKR"] = "아클로니스 마루",
        ["ptBR"] = "Pico Arklonis",
        ["ruRU"] = "Гряда Арклонис",
        ["zhCN"] = "阿尔科隆山脉",
        ["zhTW"] = "阿卡隆斯山脊",
    },
    ["Supply Caravan"] = {
        ["enUS"] = true,
        ["deDE"] = "Versorgungskarawane",
        ["esES"] = "Caravana de Provisiones",
        ["esMX"] = "Caravana de Provisiones",
        ["frFR"] = "Caravane de ravitaillement",
        ["koKR"] = "보급 짐마차",
        ["ptBR"] = "Caravana de Suprimentos",
        ["ruRU"] = "Караван",
        ["zhCN"] = "补给车队",
        ["zhTW"] = "補給商隊",
    },
    ["Underlight Mines"] = {
        ["enUS"] = true,
        ["deDE"] = "Grubenlichtminen",
        ["esES"] = "Minas Sondaluz",
        ["esMX"] = "Minas Sondaluz",
        ["frFR"] = "Mines de Terradiance",
        ["koKR"] = "미명 광산",
        ["ptBR"] = "Minas Telúminas",
        ["ruRU"] = "Беспросветные рудники",
        ["zhCN"] = "幽光矿洞",
        ["zhTW"] = "光底礦坑",
    },
    ["Shalandis Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Insel Shalandis",
        ["esES"] = "Isla Shalandis",
        ["esMX"] = "Isla Shalandis",
        ["frFR"] = "Ile de Shalandis",
        ["koKR"] = "샬란디스 섬",
        ["ptBR"] = "Ilha Shalandis",
        ["ruRU"] = "Остров Шаландис",
        ["zhCN"] = "沙兰蒂斯岛",
        ["zhTW"] = "薩藍迪斯小島",
    },
    ["Howling Ziggurat"] = {
        ["enUS"] = true,
        ["deDE"] = "Die heulende Ziggurat",
        ["esES"] = "Zigurat Aullante",
        ["esMX"] = "Zigurat Aullante",
        ["frFR"] = "Ziggourat hurlante",
        ["koKR"] = "울부짖는 지구라트",
        ["ptBR"] = "Zigurate Uivante",
        ["ruRU"] = "Воющий зиккурат",
        ["zhCN"] = "鬼嚎通灵塔",
        ["zhTW"] = "哀嚎通靈塔",
    },
    ["Bleeding Ziggurat"] = {
        ["enUS"] = true,
        ["deDE"] = "Die blutende Ziggurat",
        ["esES"] = "Zigurat Sangrante",
        ["esMX"] = "Zigurat Sangrante",
        ["frFR"] = "Ziggourat sanguinolente",
        ["koKR"] = "피투성이 지구라트",
        ["ptBR"] = "Zigurate Sangrento",
        ["ruRU"] = "Кровоточащий зиккурат",
        ["zhCN"] = "鲜血通灵塔",
        ["zhTW"] = "血色通靈塔",
    },
    ["Singing Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Der singende Bergrücken",
        ["esES"] = "Cresta Canto",
        ["esMX"] = "Cresta Canto",
        ["frFR"] = "Crête chantante",
        ["koKR"] = "노래하는 마루",
        ["ptBR"] = "Platô Harmônico",
        ["ruRU"] = "Звенящий гребень",
        ["zhCN"] = "晶歌山脉",
        ["zhTW"] = "美聲山脊",
    },
    ["The Overlook"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Rundblick",
        ["esES"] = "La Dominancia",
        ["esMX"] = "La Dominancia",
        ["frFR"] = "Le Surplomb",
        ["koKR"] = "전망대",
        ["ptBR"] = "Mirante",
        ["ruRU"] = "Обзорная площадка",
        ["zhCN"] = "瞭望台",
        ["zhTW"] = "望海崖",
    },
    ["Veil Lashh"] = {
        ["enUS"] = true,
        ["deDE"] = "Lashhversteck",
        ["esES"] = "Velo Lashh",
        ["esMX"] = "Velo Lashh",
        ["frFR"] = "Voile Lashh",
        ["koKR"] = "장막의 래쉬",
        ["ptBR"] = "Véu Lashh",
        ["ruRU"] = "Гнездовье Лашш",
        ["zhCN"] = "拉什鸦巢",
        ["zhTW"] = "迷霧拉斯",
    },
    ["Deatholme"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Todesfestung",
        ["esES"] = "Muerthogar",
        ["esMX"] = "Ciudad de la Muerte",
        ["frFR"] = "Mortholme",
        ["koKR"] = "데솔름",
        ["ptBR"] = "Cidadela da Morte",
        ["ruRU"] = "Смертхольм",
        ["zhCN"] = "戴索姆",
        ["zhTW"] = "死亡之域",
    },
    ["Shadowmoon Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenmond",
        ["esES"] = "Aldea Sombraluna",
        ["esMX"] = "Aldea Sombraluna",
        ["frFR"] = "Village d'Ombrelune",
        ["koKR"] = "어둠달 마을",
        ["ptBR"] = "Aldeia Lua Negra",
        ["ruRU"] = "Деревня Призрачной Луны",
        ["zhCN"] = "影月村",
        ["zhTW"] = "影月村",
    },
    ["An'telas"] = {
        ["enUS"] = true,
        ["deDE"] = "An'telas",
        ["esES"] = "An'telas",
        ["esMX"] = "An'telas",
        ["frFR"] = "An'telas",
        ["koKR"] = "안텔라스",
        ["ptBR"] = "An'telas",
        ["ruRU"] = "Ан'телас",
        ["zhCN"] = "安泰拉斯",
        ["zhTW"] = "安泰拉斯",
    },
    ["Duskwither Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Nachtschimmergrund",
        ["esES"] = "Tierras Ocaso Marchito",
        ["esMX"] = "Tierras Ocaso Marchito",
        ["frFR"] = "Terres de Ternesoir",
        ["koKR"] = "더스크위더 정원",
        ["ptBR"] = "Terras do Ocaso",
        ["ruRU"] = "Земли Блеклых Сумерек",
        ["zhCN"] = "达斯维瑟广场",
        ["zhTW"] = "暗木營地",
    },
    ["Dawnstar Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Morgensternturm",
        ["esES"] = "Aguja de la Estrella del Alba",
        ["esMX"] = "Aguja de la Estrella del Alba",
        ["frFR"] = "Flèche d'Aubétoile",
        ["koKR"] = "돈스타 첨탑",
        ["ptBR"] = "Torre Aurestela",
        ["ruRU"] = "Башня Утренней Звезды",
        ["zhCN"] = "晨星之塔",
        ["zhTW"] = "晨星尖塔",
    },
    ["Duskwither Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Nachtschimmerturm",
        ["esES"] = "Aguja Ocaso Marchito",
        ["esMX"] = "Aguja Ocaso Marchito",
        ["frFR"] = "Flèche de Ternesoir",
        ["koKR"] = "더스크위더 첨탑",
        ["ptBR"] = "Torre do Ocaso",
        ["ruRU"] = "Шпиль Блеклых Сумерек",
        ["zhCN"] = "达斯维瑟之塔",
        ["zhTW"] = "暮萎尖塔",
    },
    ["Sanctum of the Sun"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum der Sonne",
        ["esES"] = "Sagrario del Sol",
        ["esMX"] = "Sagrario del Sol",
        ["frFR"] = "Sanctum du Soleil",
        ["koKR"] = "태양의 성소",
        ["ptBR"] = "Sacrário Solar",
        ["ruRU"] = "Святилище Солнца",
        ["zhCN"] = "太阳圣殿",
        ["zhTW"] = "太陽聖所",
    },
    ["Nazzivian"] = {
        ["enUS"] = true,
        ["deDE"] = "Nazzivian",
        ["esES"] = "Nazzivian",
        ["esMX"] = "Nazzivian",
        ["frFR"] = "Nazzivian",
        ["koKR"] = "나지비안",
        ["ptBR"] = "Nazzivian",
        ["ruRU"] = "Наззивиан",
        ["zhCN"] = "纳兹维安",
        ["zhTW"] = "納茲維恩",
    },
    ["Tuurem"] = {
        ["enUS"] = true,
        ["deDE"] = "Tuurem",
        ["esES"] = "Tuurem",
        ["esMX"] = "Tuurem",
        ["frFR"] = "Tuurem",
        ["koKR"] = "투렘",
        ["ptBR"] = "Tuurem",
        ["ruRU"] = "Туурем",
        ["zhCN"] = "图雷姆",
        ["zhTW"] = "杜瑞",
    },
    ["Circle of Blood"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Zirkel des Blutes",
        ["esES"] = "Anillo de Sangre",
        ["esMX"] = "Anillo de Sangre",
        ["frFR"] = "Cercle de sang",
        ["koKR"] = "피의 투기장",
        ["ptBR"] = "Círculo Sangrento",
        ["ruRU"] = "Круг Крови",
        ["zhCN"] = "鲜血之环",
        ["zhTW"] = "血之環",
    },
    ["Windrunner Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Windläuferdorf",
        ["esES"] = "Aldea Brisaveloz",
        ["esMX"] = "Aldea Brisaveloz",
        ["frFR"] = "Coursevent",
        ["koKR"] = "윈드러너 마을",
        ["ptBR"] = "Vila dos Correventos",
        ["ruRU"] = "Деревня Ветрокрылых",
        ["zhCN"] = "风行村",
        ["zhTW"] = "風行者村",
    },
    ["Dawning Lane"] = {
        ["enUS"] = true,
        ["deDE"] = "Dämmerweg",
        ["esES"] = "Calle del Alba",
        ["esMX"] = "Calle del Alba",
        ["frFR"] = "Allée du Point-du-jour",
        ["koKR"] = "새벽길",
        ["ptBR"] = "Alameda Alvorecente",
        ["ruRU"] = "Рассветная улица",
        ["zhCN"] = "黎明之路",
        ["zhTW"] = "黎明小路",
    },
    ["Talon Stand"] = {
        ["enUS"] = true,
        ["deDE"] = "Krallenhoch",
        ["esES"] = "Alto de la Garra",
        ["esMX"] = "Alto de la Garra",
        ["frFR"] = "Le lieu des serres",
        ["koKR"] = "갈퀴발톱 언덕",
        ["ptBR"] = "Planalto da Garra",
        ["ruRU"] = "Холм Когтя",
        ["zhCN"] = "龙爪丘陵",
        ["zhTW"] = "魔爪看臺",
    },
    ["Lake Ere'Noru"] = {
        ["enUS"] = true,
        ["deDE"] = "See von Ere'Noru",
        ["esES"] = "Lago Ere'Noru",
        ["esMX"] = "Lago Ere'Noru",
        ["frFR"] = "Lac Ere'Noru",
        ["koKR"] = "에레노루 호수",
        ["ptBR"] = "Lago Ere'Noru",
        ["ruRU"] = "Озеро Эре'Нору",
        ["zhCN"] = "艾雷诺湖",
        ["zhTW"] = "艾利諾魯湖",
    },
    ["Huntress of the Sun"] = {
        ["enUS"] = true,
        ["deDE"] = "Jägerin der Sonne",
        ["esES"] = "Cazadora del Sol",
        ["esMX"] = "Cazadora del Sol",
        ["frFR"] = "Chasseresse du soleil",
        ["koKR"] = "태양의 여사냥꾼",
        ["ptBR"] = "Caçadora do Sol",
        ["ruRU"] = "Солнечная Охотница",
        ["zhCN"] = "太阳女猎手",
        ["zhTW"] = "太陽女獵師",
    },
    ["Azurebreeze Coast"] = {
        ["enUS"] = true,
        ["deDE"] = "Azurblaue Küste",
        ["esES"] = "Costa Bris Azur",
        ["esMX"] = "Costa Bris Azur",
        ["frFR"] = "Côte de Brise-d'Azur",
        ["koKR"] = "하늘바람 해안",
        ["ptBR"] = "Costa da Brisa Azul",
        ["ruRU"] = "Побережье Лазурного Ветра",
        ["zhCN"] = "碧风海岸",
        ["zhTW"] = "蔚藍海岸",
    },
    ["Silvermoon City"] = {
        ["enUS"] = true,
        ["deDE"] = "Silbermond",
        ["esES"] = "Ciudad de Lunargenta",
        ["esMX"] = "Ciudad de Lunargenta",
        ["frFR"] = "Lune-d'argent",
        ["koKR"] = "실버문",
        ["ptBR"] = "Luaprata",
        ["ruRU"] = "Луносвет",
        ["zhCN"] = "银月城",
        ["zhTW"] = "銀月城",
    },
    ["Void Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Leerengrat",
        ["esES"] = "Cresta del Vacío",
        ["esMX"] = "Cresta del Vacío",
        ["frFR"] = "Crête du Vide",
        ["koKR"] = "공허의 마루",
        ["ptBR"] = "Escarpa do Caos",
        ["ruRU"] = "Пустынный обрыв",
        ["zhCN"] = "虚空山脉",
        ["zhTW"] = "虛無之脊",
    },
    ["Falthrien Academy"] = {
        ["enUS"] = true,
        ["deDE"] = "Akademie von Falthrien",
        ["esES"] = "Academia Falthrien",
        ["esMX"] = "Academia Falthrien",
        ["frFR"] = "Académie de Falthrien",
        ["koKR"] = "팔스리엔 마법학회",
        ["ptBR"] = "Academia Falthrien",
        ["ruRU"] = "Академия Фалтриена",
        ["zhCN"] = "法瑟林学院",
        ["zhTW"] = "法薩瑞安學院",
    },
    ["The Sunspire"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Sonnenturm",
        ["esES"] = "La Aguja del Sol",
        ["esMX"] = "La Aguja del Sol",
        ["frFR"] = "La flèche solaire",
        ["koKR"] = "태양 첨탑",
        ["ptBR"] = "Torre do Sol",
        ["ruRU"] = "Солнечный шпиль",
        ["zhCN"] = "太阳之塔",
        ["zhTW"] = "日尖塔",
    },
    ["Twisting Nether"] = {
        ["enUS"] = true,
        ["deDE"] = "Wirbelnder Nether",
        ["esES"] = "El Vacío Abisal",
        ["esMX"] = "El Vacío Abisal",
        ["frFR"] = "Le Néant distordu",
        ["koKR"] = "뒤틀린 황천",
        ["ptBR"] = "Espiral Etérea",
        ["ruRU"] = "Круговерть Пустоты",
        ["zhCN"] = "扭曲虚空",
        ["zhTW"] = "扭曲虛空",
    },
    ["Hellfire Peninsula"] = {
        ["enUS"] = true,
        ["deDE"] = "Höllenfeuerhalbinsel",
        ["esES"] = "Península del Fuego Infernal",
        ["esMX"] = "Península del Fuego Infernal",
        ["frFR"] = "Péninsule des Flammes infernales",
        ["koKR"] = "지옥불 반도",
        ["ptBR"] = "Península Fogo do Inferno",
        ["ruRU"] = "Полуостров Адского Пламени",
        ["zhCN"] = "地狱火半岛",
        ["zhTW"] = "地獄火半島",
    },
    ["An'daroth"] = {
        ["enUS"] = true,
        ["deDE"] = "An'daroth",
        ["esES"] = "An'daroth",
        ["esMX"] = "An'daroth",
        ["frFR"] = "An'daroth",
        ["koKR"] = "안다로스",
        ["ptBR"] = "An'daroth",
        ["ruRU"] = "Ан'дарот",
        ["zhCN"] = "安达洛斯",
        ["zhTW"] = "安都拉斯",
    },
    ["Invasion Point: Cataclysm"] = {
        ["enUS"] = true,
        ["deDE"] = "Invasionspunkt: Katastrophe",
        ["esES"] = "Punto de Invasión: Cataclismo",
        ["esMX"] = "Punto de Invasión: Cataclismo",
        ["frFR"] = "Site d'invasion : Cataclysme",
        ["koKR"] = "대재앙의 침공 거점",
        ["ptBR"] = "Ponto de Invasão: Cataclismo",
        ["ruRU"] = "Точка вторжения: Катаклизм",
        ["zhCN"] = "登陆场：灾难",
        ["zhTW"] = "侵略點:災難",
    },
    ["The Altar of Shadows"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar der Schatten",
        ["esES"] = "El Altar de las Sombras",
        ["esMX"] = "El Altar de las Sombras",
        ["frFR"] = "L'autel des Ombres",
        ["koKR"] = "어둠의 제단",
        ["ptBR"] = "Altar das Sombras",
        ["ruRU"] = "Алтарь Теней",
        ["zhCN"] = "暗影祭坛",
        ["zhTW"] = "暗影祭壇",
    },
    ["Forge Camp: Fear"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Furcht",
        ["esES"] = "Campamento Forja: Miedo",
        ["esMX"] = "Campamento Forja: Miedo",
        ["frFR"] = "Camp de forge : Peur",
        ["koKR"] = "경악의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Medo",
        ["ruRU"] = "Лагерь Легиона: Страх",
        ["zhCN"] = "铸魔营地：畏惧",
        ["zhTW"] = "煉冶場:恐懼",
    },
    ["Veil Ala'rak"] = {
        ["enUS"] = true,
        ["deDE"] = "Ala'rakversteck",
        ["esES"] = "Velo Ala'rak",
        ["esMX"] = "Velo Ala'rak",
        ["frFR"] = "Voile Ala'rak",
        ["koKR"] = "장막의 알라라크",
        ["ptBR"] = "Véu Ala'rak",
        ["ruRU"] = "Гнездовье Ала'рак",
        ["zhCN"] = "奥拉克鸦巢",
        ["zhTW"] = "迷霧亞拉芮克",
    },
    ["Laughing Skull Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen des Lachenden Schädels",
        ["esES"] = "Ruinas Riecráneos",
        ["esMX"] = "Ruinas Riecráneos",
        ["frFR"] = "Ruines du Crâne ricanant",
        ["koKR"] = "웃는 해골 폐허",
        ["ptBR"] = "Ruínas Gargaveira",
        ["ruRU"] = "Руины Веселого Черепа",
        ["zhCN"] = "嘲颅废墟",
        ["zhTW"] = "獰笑骷髏廢墟",
    },
    ["Shadowmoon Valley"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenmondtal",
        ["esES"] = "Valle Sombraluna",
        ["esMX"] = "Valle Sombraluna",
        ["frFR"] = "Vallée d'Ombrelune",
        ["koKR"] = "어둠달 골짜기",
        ["ptBR"] = "Vale da Lua Negra",
        ["ruRU"] = "Долина Призрачной Луны",
        ["zhCN"] = "影月谷",
        ["zhTW"] = "影月谷",
    },
    ["The Scorched Grove"] = {
        ["enUS"] = true,
        ["deDE"] = "Der versengte Hain",
        ["esES"] = "La Arboleda Agostada",
        ["esMX"] = "La Arboleda Agostada",
        ["frFR"] = "Le bosquet incendié",
        ["koKR"] = "불타버린 숲",
        ["ptBR"] = "Mata Queimada",
        ["ruRU"] = "Выжженная роща",
        ["zhCN"] = "焦痕谷",
        ["zhTW"] = "烈焰邊境",
    },
    ["The Living Wood"] = {
        ["enUS"] = true,
        ["deDE"] = "Der lebende Wald",
        ["esES"] = "El Bosque Viviente",
        ["esMX"] = "El Bosque Viviente",
        ["frFR"] = "Le bois vivant",
        ["koKR"] = "생명의 숲",
        ["ptBR"] = "Floresta Viva",
        ["ruRU"] = "Живой лес",
        ["zhCN"] = "生命森林",
        ["zhTW"] = "活木森林",
    },
    ["Lower Veil Shil'ak"] = {
        ["enUS"] = true,
        ["deDE"] = "Unteres Shil'akversteck",
        ["esES"] = "Velo Shil'ak Bajo",
        ["esMX"] = "Velo Shil'ak Bajo",
        ["frFR"] = "Voile Shil'ak inférieur",
        ["koKR"] = "장막의 쉴라크",
        ["ptBR"] = "Véu Shil'ak Inferior",
        ["ruRU"] = "Нижнее гнездовье Шил'ак",
        ["zhCN"] = "下层夏尔克鸦巢",
        ["zhTW"] = "迷霧希拉克下層",
    },
    ["Invasion Point: Annihilator"] = {
        ["enUS"] = true,
        ["deDE"] = "Invasionspunkt: Vernichter",
        ["esES"] = "Punto de invasión: Aniquilador",
        ["esMX"] = "Punto de invasión: Aniquilador",
        ["frFR"] = "Site d'invasion : Annihilateur",
        ["koKR"] = "파멸자의 침공 거점",
        ["ptBR"] = "Ponto de Invasão: Extirpador",
        ["ruRU"] = "Точка вторжения: Аннигилятор",
        ["zhCN"] = "登陆场：歼灭",
        ["zhTW"] = "侵略點:殲滅者",
    },
    ["Soulgrinder's Barrow"] = {
        ["enUS"] = true,
        ["deDE"] = "Hügel des Seelenschänders",
        ["esES"] = "Túmulo de Moledor de Almas",
        ["esMX"] = "Túmulo de Moledor de Almas",
        ["frFR"] = "Le refuge du Broyeur-d'âme",
        ["koKR"] = "영혼분쇄자의 은신처",
        ["ptBR"] = "Tumba do Trituralma",
        ["ruRU"] = "Холм Разрушителя Душ",
        ["zhCN"] = "磨魂者之穴",
        ["zhTW"] = "靈魂研磨者獸穴",
    },
    ["Auchindoun"] = {
        ["enUS"] = true,
        ["deDE"] = "Auchindoun",
        ["esES"] = "Auchindoun",
        ["esMX"] = "Auchindoun",
        ["frFR"] = "Auchindoun",
        ["koKR"] = "아킨둔",
        ["ptBR"] = "Auchindoun",
        ["ruRU"] = "Аукиндон",
        ["zhCN"] = "奥金顿",
        ["zhTW"] = "奧齊頓",
    },
    ["Thuron's Livery"] = {
        ["enUS"] = true,
        ["deDE"] = "Thurons Aufzucht",
        ["esES"] = "Caballería de Thuron",
        ["esMX"] = "Caballería de Thuron",
        ["frFR"] = "Écurie de Thuron",
        ["koKR"] = "튜론의 매타조 훈련장",
        ["ptBR"] = "Cocheira de Thuron",
        ["ruRU"] = "Стойла Турона",
        ["zhCN"] = "苏伦的养殖场",
        ["zhTW"] = "薩爾倫的出租商行",
    },
    ["Felspark Ravine"] = {
        ["enUS"] = true,
        ["deDE"] = "Teufelsfunkenklamm",
        ["esES"] = "Barranco Burbujas Viles",
        ["esMX"] = "Barranco Llama Infernal",
        ["frFR"] = "Ravin de Gangrétincelle",
        ["koKR"] = "지옥불꽃 협곡",
        ["ptBR"] = "Ravina de Vil Fagulha",
        ["ruRU"] = "Лощина Вспышки Скверны",
        ["zhCN"] = "魔火峡谷",
        ["zhTW"] = "魔焰深谷",
    },
    ["Andilien Estate"] = {
        ["enUS"] = true,
        ["deDE"] = "Andiliens Grund",
        ["esES"] = "Dominios Andilien",
        ["esMX"] = "Dominios Andilien",
        ["frFR"] = "Domaine d'Andilien",
        ["koKR"] = "안딜리엔 영지",
        ["ptBR"] = "Propriedade Andilien",
        ["ruRU"] = "Поместье Андилиен",
        ["zhCN"] = "安迪尔林庄园",
        ["zhTW"] = "安狄里安莊園",
    },
    ["Spirit Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Geisterfelder",
        ["esES"] = "Campos de Espíritus",
        ["esMX"] = "Campos de Espíritus",
        ["frFR"] = "Champs des esprits",
        ["koKR"] = "정기의 들판",
        ["ptBR"] = "Campos dos Espíritos",
        ["ruRU"] = "Поля Духов",
        ["zhCN"] = "灵魂平原",
        ["zhTW"] = "靈魂原野",
    },
    ["Forge Camp: Mageddon"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Mageddon",
        ["esES"] = "Campamento Forja: Mageddon",
        ["esMX"] = "Campamento Forja: Mageddon",
        ["frFR"] = "Camp de forge : Mageddon",
        ["koKR"] = "멸망의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Megido",
        ["ruRU"] = "Лагерь Легиона: Магеддон",
        ["zhCN"] = "铸魔营地：暴虐",
        ["zhTW"] = "煉冶場:黑色祭壇",
    },
    ["Skethyl Mountains"] = {
        ["enUS"] = true,
        ["deDE"] = "Skethylberge",
        ["esES"] = "Montañas Skethyl",
        ["esMX"] = "Montañas Skethyl",
        ["frFR"] = "Monts Skethyl",
        ["koKR"] = "스키실 산맥",
        ["ptBR"] = "Montanhas Skethil",
        ["ruRU"] = "Горы Скетил",
        ["zhCN"] = "鸦羽山",
        ["zhTW"] = "斯其索山脈",
    },
    ["Expedition Armory"] = {
        ["enUS"] = true,
        ["deDE"] = "Expeditionsrüstlager",
        ["esES"] = "Armería de Expedición",
        ["esMX"] = "Armería de Expedición",
        ["frFR"] = "Armurerie de l'expédition",
        ["koKR"] = "원정대 무기고",
        ["ptBR"] = "Arsenal da Expedição",
        ["ruRU"] = "Оружейная экспедиции",
        ["zhCN"] = "远征军物资库",
        ["zhTW"] = "遠征隊軍械庫",
    },
    ["East Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum des Ostens",
        ["esES"] = "Sagrario del Este",
        ["esMX"] = "Sagrario del Este",
        ["frFR"] = "Sanctum oriental",
        ["koKR"] = "동부 성소",
        ["ptBR"] = "Sacrário do Leste",
        ["ruRU"] = "Восточное святилище",
        ["zhCN"] = "东部圣殿",
        ["zhTW"] = "東部聖所",
    },
    ["The Drain"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Abfluss",
        ["esES"] = "El Vaciado",
        ["esMX"] = "El Vaciado",
        ["frFR"] = "La Vidange",
        ["koKR"] = "배수로",
        ["ptBR"] = "O Escoadouro",
        ["ruRU"] = "Стоки",
        ["zhCN"] = "排水泵",
        ["zhTW"] = "排水之地",
    },
    ["Ammen Vale"] = {
        ["enUS"] = true,
        ["deDE"] = "Am'mental",
        ["esES"] = "Valle Ammen",
        ["esMX"] = "Valle Ammen",
        ["frFR"] = "Val d'Ammen",
        ["koKR"] = "암멘 골짜기",
        ["ptBR"] = "Vale Ammen",
        ["ruRU"] = "Долина Аммен",
        ["zhCN"] = "埃门谷",
        ["zhTW"] = "安曼谷",
    },
    ["Shrine of Dath'Remar"] = {
        ["enUS"] = true,
        ["deDE"] = "Schrein von Dath'Remar",
        ["esES"] = "Santuario de Dath'Remar",
        ["esMX"] = "Santuario de Dath'Remar",
        ["frFR"] = "Sanctuaire de Dath'Remar",
        ["koKR"] = "다트리마의 제단",
        ["ptBR"] = "Altar de Dath'Remar",
        ["ruRU"] = "Святилище Дат'Ремара",
        ["zhCN"] = "达斯雷玛的神龛",
        ["zhTW"] = "達斯雷瑪神殿",
    },
    ["Netherweb Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Netherweberkamm",
        ["esES"] = "Cresta Red Abisal",
        ["esMX"] = "Cresta Red Abisal",
        ["frFR"] = "Crête de Toile-néant",
        ["koKR"] = "황천그물 마루",
        ["ptBR"] = "Serra Redetérea",
        ["ruRU"] = "Гряда Пустопутов",
        ["zhCN"] = "灵网山脊",
        ["zhTW"] = "幽網山脊",
    },
    ["Voidwind Plateau"] = {
        ["enUS"] = true,
        ["deDE"] = "Leerenwindplateau",
        ["esES"] = "Meseta del Viento del Vacío",
        ["esMX"] = "Meseta del Viento del Vacío",
        ["frFR"] = "Le plateau Vent-du-Vide",
        ["koKR"] = "공허의 바람 고원",
        ["ptBR"] = "Platô dos Ventos do Caos",
        ["ruRU"] = "Плато Пустынного Ветра",
        ["zhCN"] = "虚风高原",
        ["zhTW"] = "裂風高原",
    },
    ["Ango'rosh Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Grund der Ango'rosh",
        ["esES"] = "Dominios Ango'rosh",
        ["esMX"] = "Dominios Ango'rosh",
        ["frFR"] = "Terres Ango'rosh",
        ["koKR"] = "앙고로쉬 영토",
        ["ptBR"] = "Terras de Ango'rosh",
        ["ruRU"] = "Земли Анго'рош",
        ["zhCN"] = "安葛洛什营地",
        ["zhTW"] = "安格拉斯營地",
    },
    ["Deathforge Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Turm der Todesschmiede",
        ["esES"] = "Torre de la Forja Muerta",
        ["esMX"] = "Torre de la Forja Muerta",
        ["frFR"] = "Tour de la Forgemort",
        ["koKR"] = "죽음의 괴철로 탑",
        ["ptBR"] = "Torre da Forja da Morte",
        ["ruRU"] = "Башня Кузницы Смерти",
        ["zhCN"] = "死亡熔炉哨塔",
        ["zhTW"] = "死亡熔爐哨塔",
    },
    ["Veil Lithic"] = {
        ["enUS"] = true,
        ["deDE"] = "Lithicversteck",
        ["esES"] = "Velo Lítico",
        ["esMX"] = "Velo Lítico",
        ["frFR"] = "Voile Lithic",
        ["koKR"] = "장막의 리디크",
        ["ptBR"] = "Véu Lithic",
        ["ruRU"] = "Гнездовье Литик",
        ["zhCN"] = "雷希鸦巢",
        ["zhTW"] = "迷霧里斯克",
    },
    ["Slag Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlackenwacht",
        ["esES"] = "Vigía de la Escoria",
        ["esMX"] = "Vigía de la Escoria",
        ["frFR"] = "Guet des scories",
        ["koKR"] = "잿가루 감시초소",
        ["ptBR"] = "Mirante da Escória",
        ["ruRU"] = "Вышка на золе",
        ["zhCN"] = "熔渣哨塔",
        ["zhTW"] = "爐熔守望",
    },
    ["Serpent Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlangensee",
        ["esES"] = "Lago Serpiente",
        ["esMX"] = "Lago Serpiente",
        ["frFR"] = "Lac des Serpents",
        ["koKR"] = "물갈퀴 호수",
        ["ptBR"] = "Lago Serpente",
        ["ruRU"] = "Змеиное озеро",
        ["zhCN"] = "毒蛇湖",
        ["zhTW"] = "毒蛇之湖",
    },
    ["North Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum des Nordens",
        ["esES"] = "Sagrario del Norte",
        ["esMX"] = "Sagrario del Norte",
        ["frFR"] = "Sanctum septentrional",
        ["koKR"] = "북부 성소",
        ["ptBR"] = "Sacrário do Norte",
        ["ruRU"] = "Северное святилище",
        ["zhCN"] = "北部圣殿",
        ["zhTW"] = "北部聖所",
    },
    ["Farstrider Retreat"] = {
        ["enUS"] = true,
        ["deDE"] = "Zuflucht der Weltenwanderer",
        ["esES"] = "El Retiro del Errante",
        ["esMX"] = "El Retiro del Errante",
        ["frFR"] = "Retraite des Pérégrins",
        ["koKR"] = "원정순찰대 산장",
        ["ptBR"] = "Retiro dos Andarilhos",
        ["ruRU"] = "Обитель Странников",
        ["zhCN"] = "远行者居所",
        ["zhTW"] = "遠行者居所",
    },
    ["The Dead Mire"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Todesmoor",
        ["esES"] = "El Lodo Muerto",
        ["esMX"] = "El Lodo Muerto",
        ["frFR"] = "La Morte-bourbe",
        ["koKR"] = "죽음의 늪",
        ["ptBR"] = "O Charco Fantasma",
        ["ruRU"] = "Мертвая трясина",
        ["zhCN"] = "死亡泥潭",
        ["zhTW"] = "死亡污泥",
    },
    ["The Spawning Glen"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Pilzgeflecht",
        ["esES"] = "La Cañada Emergente",
        ["esMX"] = "La Cañada Emergente",
        ["frFR"] = "Le vallon des pontes",
        ["koKR"] = "부화의 골짜기",
        ["ptBR"] = "Vale dos Rebentos",
        ["ruRU"] = "Грибная поляна",
        ["zhCN"] = "孢殖林",
        ["zhTW"] = "重生峽谷",
    },
    ["Magisters Gate"] = {
        ["enUS"] = true,
        ["deDE"] = "Magistertor",
        ["esES"] = "Puerta Magister",
        ["esMX"] = "Puerta Magister",
        ["frFR"] = "Porte du Magistère",
        ["koKR"] = "마법학자 관문",
        ["ptBR"] = "Portão dos Magísteres",
        ["ruRU"] = "Врата Магистров",
        ["zhCN"] = "魔导师之门",
        ["zhTW"] = "博學者之門",
    },
    ["Tower of the Damned"] = {
        ["enUS"] = true,
        ["deDE"] = "Turm der Verdammten",
        ["esES"] = "Torre de los Condenados",
        ["esMX"] = "Torre de los Condenados",
        ["frFR"] = "Tour des damnés",
        ["koKR"] = "저주받은 자의 탑",
        ["ptBR"] = "Torre dos Malditos",
        ["ruRU"] = "Башня Проклятых",
        ["zhCN"] = "诅咒之塔",
        ["zhTW"] = "詛咒神教之塔",
    },
    ["Sunsail Anchorage"] = {
        ["enUS"] = true,
        ["deDE"] = "Ankerplatz der Sonnensegel",
        ["esES"] = "Fondeadero Vela del Sol",
        ["esMX"] = "Fondeadero Vela del Sol",
        ["frFR"] = "Mouillage des Voiles du soleil",
        ["koKR"] = "해돋이 부두",
        ["ptBR"] = "Ancoradouro Velaclara",
        ["ruRU"] = "Причал Солнечного Паруса",
        ["zhCN"] = "阳帆港",
        ["zhTW"] = "日帆泊地",
    },
    ["Veil Shalas"] = {
        ["enUS"] = true,
        ["deDE"] = "Shalasversteck",
        ["esES"] = "Velo Shalas",
        ["esMX"] = "Velo Shalas",
        ["frFR"] = "Voile Shalas",
        ["koKR"] = "장막의 샬라스",
        ["ptBR"] = "Véu Shalas",
        ["ruRU"] = "Гнездовье Шалас",
        ["zhCN"] = "沙拉斯鸦巢",
        ["zhTW"] = "迷霧撒拉斯",
    },
    ["Blacksilt Shore"] = {
        ["enUS"] = true,
        ["deDE"] = "Schwarzschlammküste",
        ["esES"] = "Costa Cienonegro",
        ["esMX"] = "Costa Cienonegro",
        ["frFR"] = "Le rivage des Vase-noire",
        ["koKR"] = "검은진흙 해안",
        ["ptBR"] = "Praia Trevareia",
        ["ruRU"] = "Берег Черного Ила",
        ["zhCN"] = "黑沙海岸",
        ["zhTW"] = "黑泥沙海岸",
    },
    ["Isle of Tribulations"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel des Martyriums",
        ["esES"] = "Isla de las Tribulaciones",
        ["esMX"] = "Isla de las Tribulaciones",
        ["frFR"] = "Ile des Tribulations",
        ["koKR"] = "고행의 섬",
        ["ptBR"] = "Ilha das Tribulações",
        ["ruRU"] = "Остров Напастей",
        ["zhCN"] = "苦难岛",
        ["zhTW"] = "磨難之島",
    },
    ["The Ring of Blood"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring des Blutes",
        ["esES"] = "El Círculo de Sangre",
        ["esMX"] = "El Círculo de Sangre",
        ["frFR"] = "L'arène de sang",
        ["koKR"] = "피의 투기장",
        ["ptBR"] = "Ringue de Sangue",
        ["ruRU"] = "Кольцо Крови",
        ["zhCN"] = "鲜血竞技场",
        ["zhTW"] = "血色競技場",
    },
    ["Golden Strand"] = {
        ["enUS"] = true,
        ["deDE"] = "Der goldene Strand",
        ["esES"] = "La Ensenada Dorada",
        ["esMX"] = "La Ensenada Dorada",
        ["frFR"] = "Grève dorée",
        ["koKR"] = "황금 해안",
        ["ptBR"] = "Areal Dourado",
        ["ruRU"] = "Золотистое взморье",
        ["zhCN"] = "金色沙滩",
        ["zhTW"] = "金色湖岸",
    },
    ["Orebor Harborage"] = {
        ["enUS"] = true,
        ["deDE"] = "Oreborzuflucht",
        ["esES"] = "Puerto Orebor",
        ["esMX"] = "Puerto Orebor",
        ["frFR"] = "Havre d'Orebor",
        ["koKR"] = "오레보르 피난처",
        ["ptBR"] = "Porto Orebor",
        ["ruRU"] = "Прибежище Оребор",
        ["zhCN"] = "奥雷柏尔营地",
        ["zhTW"] = "奧雷伯爾港",
    },
    ["Rivendark's Perch"] = {
        ["enUS"] = true,
        ["deDE"] = "Nachtreißers Hort",
        ["esES"] = "Nido de Desgarro Oscuro",
        ["esMX"] = "Nido de Desgarro Oscuro",
        ["frFR"] = "Perchoir de Clivenuit",
        ["koKR"] = "리븐다크의 둥지",
        ["ptBR"] = "Ninho do Rivenegro",
        ["ruRU"] = "Гнездо Чернокрыла",
        ["zhCN"] = "雷文达克栖木",
        ["zhTW"] = "瑞文達科棲所",
    },
    ["Insidion's Perch"] = {
        ["enUS"] = true,
        ["deDE"] = "Insidions Hort",
        ["esES"] = "Nido de Insidion",
        ["esMX"] = "Nido de Insidion",
        ["frFR"] = "Perchoir d'Insidion",
        ["koKR"] = "인시디온의 둥지",
        ["ptBR"] = "Ninho do Insidion",
        ["ruRU"] = "Гнездо Инсидиона",
        ["zhCN"] = "因斯迪安栖木",
        ["zhTW"] = "印希迪恩棲所",
    },
    ["Bash'ir Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Landeplatz von Bash'ir",
        ["esES"] = "Alto Bash'ir",
        ["esMX"] = "Alto Bash'ir",
        ["frFR"] = "Point d'ancrage de Bash'ir",
        ["koKR"] = "바쉬르 영지",
        ["ptBR"] = "Patamar de Bash'ir",
        ["ruRU"] = "Лагерь Баш'ира",
        ["zhCN"] = "巴什伊尔码头",
        ["zhTW"] = "貝許爾平臺",
    },
    ["The North Sea"] = {
        ["enUS"] = true,
        ["deDE"] = "Das nördliche Meer",
        ["esES"] = "El Mar Norte",
        ["esMX"] = "El Mar del Norte",
        ["frFR"] = "La mer Boréale",
        ["koKR"] = "북해",
        ["ptBR"] = "Mar do Norte",
        ["ruRU"] = "Северное море",
        ["zhCN"] = "北海",
        ["zhTW"] = "北方海岸",
    },
    ["Feralfen Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Wildfenn",
        ["esES"] = "Aldea Feropantano",
        ["esMX"] = "Aldea Feropantano",
        ["frFR"] = "Tourbe-farouche",
        ["koKR"] = "야생늪 마을",
        ["ptBR"] = "Vila do Charco das Feras",
        ["ruRU"] = "Деревня Дикотопь",
        ["zhCN"] = "蛮沼村",
        ["zhTW"] = "菲拉芬村",
    },
    ["Terokk's Rest"] = {
        ["enUS"] = true,
        ["deDE"] = "Terokks Ruh",
        ["esES"] = "Sosiego de Terokk",
        ["esMX"] = "Sosiego de Terokk",
        ["frFR"] = "Repos de Terokk",
        ["koKR"] = "테로크의 안식처",
        ["ptBR"] = "Repouso de Terokk",
        ["ruRU"] = "Покой Терокка",
        ["zhCN"] = "泰罗克之墓",
        ["zhTW"] = "泰洛克之墓",
    },
    ["Kirin'Var Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Kirin'Var",
        ["esES"] = "Poblado Kirin'Var",
        ["esMX"] = "Poblado Kirin'Var",
        ["frFR"] = "Kirin'Var",
        ["koKR"] = "키린바르 마을",
        ["ptBR"] = "Vila Kirin'Var",
        ["ruRU"] = "Деревня Кирин'Вар",
        ["zhCN"] = "肯瑞瓦村",
        ["zhTW"] = "肯瑞瓦村莊",
    },
    ["Dragonmaw Fortress"] = {
        ["enUS"] = true,
        ["deDE"] = "Festung des Drachenmals",
        ["esES"] = "Fortaleza Faucedraco",
        ["esMX"] = "Fortaleza Faucedraco",
        ["frFR"] = "Forteresse Gueule-de-dragon",
        ["koKR"] = "용아귀 요새",
        ["ptBR"] = "Fortaleza Presa do Dragão",
        ["ruRU"] = "Крепость Драконьей Пасти",
        ["zhCN"] = "龙喉要塞",
        ["zhTW"] = "龍喉堡壘",
    },
    ["Manaforge Duro"] = {
        ["enUS"] = true,
        ["deDE"] = "Manaschmiede Duro",
        ["esES"] = "Forja de Maná Duro",
        ["esMX"] = "Forja de Maná Duro",
        ["frFR"] = "Manaforge Duro",
        ["koKR"] = "듀로 마나괴철로",
        ["ptBR"] = "Manaforja Dúria",
        ["ruRU"] = "Манагорн Даро",
        ["zhCN"] = "法力熔炉：杜隆",
        ["zhTW"] = "法力熔爐杜羅",
    },
    ["Grangol'var Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Grangol'var",
        ["esES"] = "Poblado Grangol'var",
        ["esMX"] = "Poblado Grangol'var",
        ["frFR"] = "Grangol'var",
        ["koKR"] = "그란골바르 마을",
        ["ptBR"] = "Aldeia Grangol'var",
        ["ruRU"] = "Деревня Грангол'вар",
        ["zhCN"] = "格兰戈瓦村",
        ["zhTW"] = "葛蘭戈瓦村",
    },
    ["Skyguard Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten der Himmelswache",
        ["esES"] = "Avanzada de la Guardia del Cielo",
        ["esMX"] = "Avanzada de la Guardia del Cielo",
        ["frFR"] = "Avant-poste de la Garde-ciel",
        ["koKR"] = "하늘경비대 전초기지",
        ["ptBR"] = "Posto Avançado da Guarda Aérea",
        ["ruRU"] = "Застава Стражи Небес",
        ["zhCN"] = "天空卫队哨站",
        ["zhTW"] = "禦天者崗哨",
    },
    ["Vim'gol's Circle"] = {
        ["enUS"] = true,
        ["deDE"] = "Vim'gols Kreis",
        ["esES"] = "Anillo de Vim'gol",
        ["esMX"] = "Anillo de Vim'gol",
        ["frFR"] = "Le cercle de Vim'gol",
        ["koKR"] = "빔골의 마법진",
        ["ptBR"] = "Círculo de Vim'gol",
        ["ruRU"] = "Круг Вим'гола",
        ["zhCN"] = "维姆高尔的法阵",
        ["zhTW"] = "梵戈之環",
    },
    ["Sorrow Wing Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Stätte der Gramschwingen",
        ["esES"] = "Punta Alapenas",
        ["esMX"] = "Punta Alapenas",
        ["frFR"] = "Halte Aile-du-chargrin",
        ["koKR"] = "슬픔의 날개 거점",
        ["ptBR"] = "Ilha Pesarasa",
        ["ruRU"] = "Вершина Крыльев Скорби",
        ["zhCN"] = "悲翼之地",
        ["zhTW"] = "憂傷之翼哨站",
    },
    ["Vekhaar Stand"] = {
        ["enUS"] = true,
        ["deDE"] = "Vekhaar",
        ["esES"] = "Alto Vekhaar",
        ["esMX"] = "Alto Vekhaar",
        ["frFR"] = "Le séjour de Vekhaar",
        ["koKR"] = "베크하르 고원",
        ["ptBR"] = "Bosque de Vekhaar",
        ["ruRU"] = "Перелесок Векхаар",
        ["zhCN"] = "维克哈营地",
        ["zhTW"] = "維克哈爾看臺",
    },
    ["Furywing's Perch"] = {
        ["enUS"] = true,
        ["deDE"] = "Zornschwinges Hort",
        ["esES"] = "Nido de Alafuria",
        ["esMX"] = "Nido de Alafuria",
        ["frFR"] = "Perchoir d'Aile-furie",
        ["koKR"] = "퓨리윙의 둥지",
        ["ptBR"] = "Ninho do Furialada",
        ["ruRU"] = "Гнездовье Ярокрыла",
        ["zhCN"] = "弗雷文栖木",
        ["zhTW"] = "狂怒之翼棲所",
    },
    ["Sunspring Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenwindposten",
        ["esES"] = "Puesto Primasol",
        ["esMX"] = "Puesto Primasol",
        ["frFR"] = "Poste de Berceau-de-l'Eté",
        ["koKR"] = "태양여울 주둔지",
        ["ptBR"] = "Posto Solavera",
        ["ruRU"] = "Застава Солнечного Источника",
        ["zhCN"] = "日泉岗哨",
        ["zhTW"] = "日春崗哨",
    },
    ["Zeppelin Crash"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeppelinabsturzstelle",
        ["esES"] = "Zepelín Caído",
        ["esMX"] = "Zepelín Caído",
        ["frFR"] = "L'épave du zeppelin",
        ["koKR"] = "비행선 추락지",
        ["ptBR"] = "Zepelim Caído",
        ["ruRU"] = "Место крушения дирижабля",
        ["zhCN"] = "飞艇坠毁点",
        ["zhTW"] = "飛艇失事地",
    },
    ["Thornfang Hill"] = {
        ["enUS"] = true,
        ["deDE"] = "Dornnebelhügel",
        ["esES"] = "Colina Colmillespinado",
        ["esMX"] = "Colina Colmillespinado",
        ["frFR"] = "Colline de Roncecroc",
        ["koKR"] = "가시송곳니 언덕",
        ["ptBR"] = "Monte Presacúleo",
        ["ruRU"] = "Холм Колючего Клыка",
        ["zhCN"] = "棘牙岭",
        ["zhTW"] = "棘牙丘陵",
    },
    ["Razorthorn Rise"] = {
        ["enUS"] = true,
        ["deDE"] = "Messerdornhöhe",
        ["esES"] = "Alto Rajaespina",
        ["esMX"] = "Alto Rajaespina",
        ["frFR"] = "Éminence de Tranchépine",
        ["koKR"] = "서슬가시 언덕",
        ["ptBR"] = "Morro Espinhoso",
        ["ruRU"] = "Уступ Острого Шипа",
        ["zhCN"] = "荆刺高地",
        ["zhTW"] = "刺棘高地",
    },
    ["Netherstorm"] = {
        ["enUS"] = true,
        ["deDE"] = "Nethersturm",
        ["esES"] = "Tormenta Abisal",
        ["esMX"] = "Tormenta Abisal",
        ["frFR"] = "Raz-de-Néant",
        ["koKR"] = "황천의 폭풍",
        ["ptBR"] = "Eternévoa",
        ["ruRU"] = "Пустоверть",
        ["zhCN"] = "虚空风暴",
        ["zhTW"] = "虛空風暴",
    },
    ["Sha'tari Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten der Sha'tari",
        ["esES"] = "Avanzada Sha'tari",
        ["esMX"] = "Avanzada Sha'tari",
        ["frFR"] = "Avant-poste sha'tari",
        ["koKR"] = "샤타리 전초기지",
        ["ptBR"] = "Posto Sha'tari",
        ["ruRU"] = "Застава Ша'тар",
        ["zhCN"] = "沙塔尔前哨站",
        ["zhTW"] = "薩塔前哨",
    },
    ["The Shadow Stair"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schattentreppe",
        ["esES"] = "La Escalera Umbría",
        ["esMX"] = "La Escalera Umbría",
        ["frFR"] = "L'escalier de l'Ombre",
        ["koKR"] = "어둠의 계단",
        ["ptBR"] = "Escada das Sombras",
        ["ruRU"] = "Лестница Теней",
        ["zhCN"] = "暗影阶梯",
        ["zhTW"] = "暗影階梯",
    },
    ["Wyrmscar Island"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel Drachenfels",
        ["esES"] = "Isla Cicatriz de Vermis",
        ["esMX"] = "Isla Cicatriz de Vermis",
        ["frFR"] = "Île Balafre-du-ver",
        ["koKR"] = "고룡흉터 섬",
        ["ptBR"] = "Ilha Mal-da-serpe",
        ["ruRU"] = "Остров Драконьей Скорби",
        ["zhCN"] = "龙痕岛",
        ["zhTW"] = "龍痕島",
    },
    ["Hellfire Basin"] = {
        ["enUS"] = true,
        ["deDE"] = "Höllenfeuerbecken",
        ["esES"] = "Cuenca del Fuego Infernal",
        ["esMX"] = "Cuenca del Fuego Infernal",
        ["frFR"] = "Bassin des Flammes infernales",
        ["koKR"] = "지옥불 분지",
        ["ptBR"] = "Bacia Fogo do Inferno",
        ["ruRU"] = "Яма Адского Пламени",
        ["zhCN"] = "地狱火盆地",
        ["zhTW"] = "地獄火盆地",
    },
    ["Eversong Woods"] = {
        ["enUS"] = true,
        ["deDE"] = "Immersangwald",
        ["esES"] = "Bosque Canción Eterna",
        ["esMX"] = "Bosque Canción Eterna",
        ["frFR"] = "Bois des Chants éternels",
        ["koKR"] = "영원노래 숲",
        ["ptBR"] = "Floresta do Canto Eterno",
        ["ruRU"] = "Леса Вечной Песни",
        ["zhCN"] = "永歌森林",
        ["zhTW"] = "永歌森林",
    },
    ["Umbrafen Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Umbrafenn",
        ["esES"] = "Aldea Umbropantano",
        ["esMX"] = "Aldea Umbropantano",
        ["frFR"] = "Umbretourbe",
        ["koKR"] = "그늘늪 마을",
        ["ptBR"] = "Aldeia do Charco Sombrio",
        ["ruRU"] = "Деревня Тенетопь",
        ["zhCN"] = "暗泽村",
        ["zhTW"] = "昂布拉凡村",
    },
    ["Telaar"] = {
        ["enUS"] = true,
        ["deDE"] = "Telaar",
        ["esES"] = "Telaar",
        ["esMX"] = "Telaar",
        ["frFR"] = "Telaar",
        ["koKR"] = "텔라아르",
        ["ptBR"] = "Telaar",
        ["ruRU"] = "Телаар",
        ["zhCN"] = "塔拉",
        ["zhTW"] = "泰拉",
    },
    ["Northwind Cleft"] = {
        ["enUS"] = true,
        ["deDE"] = "Nordwindkluft",
        ["esES"] = "Grieta del Viento Norte",
        ["esMX"] = "Grieta del Viento Norte",
        ["frFR"] = "Faille de Norsevent",
        ["koKR"] = "북새바람 동굴",
        ["ptBR"] = "Fenda do Vento Norte",
        ["ruRU"] = "Расщелина Северного Ветра",
        ["zhCN"] = "北风裂谷",
        ["zhTW"] = "北風斷崖",
    },
    ["Circle of Blood Arena"] = {
        ["enUS"] = true,
        ["deDE"] = "Arena des Zirkels des Blutes",
        ["esES"] = "Arena del Anillo de Sangre",
        ["esMX"] = "Arena del Anillo de Sangre",
        ["frFR"] = "Arène du Cercle de sang",
        ["koKR"] = "피의 투기장",
        ["ptBR"] = "Arena do Círculo Sangrento",
        ["ruRU"] = "Арена Круга Крови",
        ["zhCN"] = "鲜血之环竞技场",
        ["zhTW"] = "血之環競技場",
    },
    ["Eclipsion Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Felder der Mondfinsternis",
        ["esES"] = "Campos Eclipsianos",
        ["esMX"] = "Campos Eclipsianos",
        ["frFR"] = "Champs éclipsions",
        ["koKR"] = "해그늘 벌판",
        ["ptBR"] = "Campos Eclipsion",
        ["ruRU"] = "Поля Затмения",
        ["zhCN"] = "日蚀平原",
        ["zhTW"] = "伊克利普森農場",
    },
    ["Evergrove"] = {
        ["enUS"] = true,
        ["deDE"] = "Der ewige Hain",
        ["esES"] = "Soto Eterno",
        ["esMX"] = "Soto Eterno",
        ["frFR"] = "Bosquet éternel",
        ["koKR"] = "영원의 숲",
        ["ptBR"] = "Arvoredo Eterno",
        ["ruRU"] = "Вечная роща",
        ["zhCN"] = "常青林",
        ["zhTW"] = "永恆樹林",
    },
    ["Crimson Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Purpurwacht",
        ["esES"] = "Atalaya Carmesí",
        ["esMX"] = "Atalaya Carmesí",
        ["frFR"] = "Guet cramoisi",
        ["koKR"] = "붉은 감시초소",
        ["ptBR"] = "Vigília Carmesim",
        ["ruRU"] = "Кровавый Дозор",
        ["zhCN"] = "火红岗哨",
        ["zhTW"] = "赤紅守望",
    },
    ["The Vortex Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Vortexfelder",
        ["esES"] = "Los Campos del Vórtice",
        ["esMX"] = "Los Campos del Vórtice",
        ["frFR"] = "Les champs du vortex",
        ["koKR"] = "소용돌이 지대",
        ["ptBR"] = "Campos de Vórtice",
        ["ruRU"] = "Вихревые поля",
        ["zhCN"] = "漩涡平原",
        ["zhTW"] = "漩渦農場",
    },
    ["Stonebreaker Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Steinbrecherfeste",
        ["esES"] = "Bastión Rompepedras",
        ["esMX"] = "Bastión Rompepedras",
        ["frFR"] = "Fort des Brise-pierres",
        ["koKR"] = "돌망치 요새",
        ["ptBR"] = "Vila de Quebrapedra",
        ["ruRU"] = "Форт Камнеломов",
        ["zhCN"] = "裂石堡",
        ["zhTW"] = "碎石堡",
    },
    ["Daggerfen Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Dolchfenn",
        ["esES"] = "Aldea Dagapantano",
        ["esMX"] = "Aldea Dagapantano",
        ["frFR"] = "Tourbedague",
        ["koKR"] = "비수늪 마을",
        ["ptBR"] = "Aldeia Lamadaga",
        ["ruRU"] = "Деревня Остротопь",
        ["zhCN"] = "匕潭村",
        ["zhTW"] = "匕首沼地村",
    },
    ["Magma Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Magmafelder",
        ["esES"] = "Campos de Magma",
        ["esMX"] = "Campos de Magma",
        ["frFR"] = "Champs de magma",
        ["koKR"] = "용암 지대",
        ["ptBR"] = "Campos de Magma",
        ["ruRU"] = "Магмовые поля",
        ["zhCN"] = "熔岩平原",
        ["zhTW"] = "熔岩平原",
    },
    ["Blackwind Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenwindlager",
        ["esES"] = "Alto de los Vientonegro",
        ["esMX"] = "Alto de los Vientonegro",
        ["frFR"] = "Le Raie'odrome de Noirvent",
        ["koKR"] = "검은바람 비행기지",
        ["ptBR"] = "Campo de Pouso Ventonegro",
        ["ruRU"] = "Лагерь Черного Ветра",
        ["zhCN"] = "黑风码头",
        ["zhTW"] = "黑風平臺",
    },
    ["Swamprat Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Sumpfrattenposten",
        ["esES"] = "Avanzada Rata del Pantano",
        ["esMX"] = "Avanzada Rata del Pantano",
        ["frFR"] = "Poste du Rat des marais",
        ["koKR"] = "늪쥐 감시초소",
        ["ptBR"] = "Mocó do Rato Lamacento",
        ["ruRU"] = "Застава Болотной Крысы",
        ["zhCN"] = "沼泽鼠岗哨",
        ["zhTW"] = "斯溫派特崗哨",
    },
    ["The Scalding Pools"] = {
        ["enUS"] = true,
        ["deDE"] = "Die siedenden Teiche",
        ["esES"] = "Las Pozas Escaldantes",
        ["esMX"] = "Las Pozas Escaldantes",
        ["frFR"] = "Les bassins Brûlants",
        ["koKR"] = "끓어오르는 웅덩이",
        ["ptBR"] = "Lagos Escaldantes",
        ["ruRU"] = "Жгучие пруды",
        ["zhCN"] = "滚烫熔池",
        ["zhTW"] = "沸水池",
    },
    ["Netherwing Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Netherschwingenpass",
        ["esES"] = "Desfiladero del Ala Abisal",
        ["esMX"] = "Desfiladero del Ala Abisal",
        ["frFR"] = "Défilé de l'Aile-du-Néant",
        ["koKR"] = "황천날개 고개",
        ["ptBR"] = "Trilha da Asa Etérea",
        ["ruRU"] = "Перевал Крыльев Пустоты",
        ["zhCN"] = "灵翼小径",
        ["zhTW"] = "虛空之翼小徑",
    },
    ["Ghostlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Geisterlande",
        ["esES"] = "Tierras Fantasma",
        ["esMX"] = "Tierras Fantasma",
        ["frFR"] = "Les Terres fantômes",
        ["koKR"] = "유령의 땅",
        ["ptBR"] = "Terra Fantasma",
        ["ruRU"] = "Призрачные земли",
        ["zhCN"] = "幽魂之地",
        ["zhTW"] = "鬼魂之地",
    },
    ["Gor'gaz Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten von Gor'gaz",
        ["esES"] = "Avanzada Gor'gaz",
        ["esMX"] = "Avanzada Gor'gaz",
        ["frFR"] = "Avant-poste de Gor'gaz",
        ["koKR"] = "고르가즈 전초기지",
        ["ptBR"] = "Acampamento Gor'gaz",
        ["ruRU"] = "Форт Гор'газ",
        ["zhCN"] = "高加兹前哨",
        ["zhTW"] = "葛卡茲哨站",
    },
    ["Lower City"] = {
        ["enUS"] = true,
        ["deDE"] = "Unteres Viertel",
        ["esES"] = "Bajo Arrabal",
        ["esMX"] = "Bajo Arrabal",
        ["frFR"] = "Ville basse",
        ["koKR"] = "고난의 거리",
        ["ptBR"] = "Bairro Inferior",
        ["ruRU"] = "Нижний город",
        ["zhCN"] = "贫民窟",
        ["zhTW"] = "陰鬱城",
    },
    ["Allerian Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Allerias Posten",
        ["esES"] = "Puesto Allerian",
        ["esMX"] = "Puesto Allerian",
        ["frFR"] = "Poste allérien",
        ["koKR"] = "알레리아 초소",
        ["ptBR"] = "Posto Alleriano",
        ["ruRU"] = "Застава Аллерии",
        ["zhCN"] = "奥蕾莉亚岗哨",
        ["zhTW"] = "艾蘭里哨站",
    },
    ["Scalewing Shelf"] = {
        ["enUS"] = true,
        ["deDE"] = "Schuppenflügelbank",
        ["esES"] = "Plataforma Alaescama",
        ["esMX"] = "Plataforma Alaescama",
        ["frFR"] = "Saillie ailécaille",
        ["koKR"] = "비늘날개 절벽",
        ["ptBR"] = "Planalto Escamasa",
        ["ruRU"] = "Склон Чешуекрылых",
        ["zhCN"] = "鳞翼岩床",
        ["zhTW"] = "鱗翼沙洲",
    },
    ["Silvermyst Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Silbermythosinsel",
        ["esES"] = "Isla Bruma de Plata",
        ["esMX"] = "Isla Bruma de Plata",
        ["frFR"] = "Île de Brume-argent",
        ["koKR"] = "은빛안개 섬",
        ["ptBR"] = "Ilha Nevoaprata",
        ["ruRU"] = "Остров Серебристой Дымки",
        ["zhCN"] = "秘银岛",
        ["zhTW"] = "銀謎小島",
    },
    ["The Fetid Pool"] = {
        ["enUS"] = true,
        ["deDE"] = "Der faulige Teich",
        ["esES"] = "La Poza Fétida",
        ["esMX"] = "La Poza Fétida",
        ["frFR"] = "Le Bassin fétide",
        ["koKR"] = "악취나는 웅덩이",
        ["ptBR"] = "Lago Fétido",
        ["ruRU"] = "Зловонный пруд",
        ["zhCN"] = "恶臭之池",
        ["zhTW"] = "惡臭水池",
    },
    ["Mag'har Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Grund der Mag'har",
        ["esES"] = "Dominios Mag'har",
        ["esMX"] = "Dominios Mag'har",
        ["frFR"] = "Terres Mag'har",
        ["koKR"] = "마그하르 영토",
        ["ptBR"] = "Terras de Mag'har",
        ["ruRU"] = "Земли маг'харов",
        ["zhCN"] = "玛格汉台地",
        ["zhTW"] = "瑪格哈營地",
    },
    ["Haal'eshi Gorge"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlucht der Haal'eshi",
        ["esES"] = "Garganta Haal'eshi",
        ["esMX"] = "Garganta Haal'eshi",
        ["frFR"] = "Gorge Haal'eshi",
        ["koKR"] = "하알레쉬 협곡",
        ["ptBR"] = "Desfiladeiro Haal'eshi",
        ["ruRU"] = "Теснина Хаал'эш",
        ["zhCN"] = "哈尔什峡谷",
        ["zhTW"] = "海艾斯峽谷",
    },
    ["Halaani Basin"] = {
        ["enUS"] = true,
        ["deDE"] = "Halaanibecken",
        ["esES"] = "Cuenca Halaani",
        ["esMX"] = "Cuenca Halaani",
        ["frFR"] = "Bassin halaani",
        ["koKR"] = "할라아니 분지",
        ["ptBR"] = "Bacia Halaani",
        ["ruRU"] = "Котловина Халаани",
        ["zhCN"] = "哈兰盆地",
        ["zhTW"] = "哈剌尼盆地",
    },
    ["Sanctum of the Stars"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum der Sterne",
        ["esES"] = "Sagrario de las Estrellas",
        ["esMX"] = "Sagrario de las Estrellas",
        ["frFR"] = "Sanctum des Étoiles",
        ["koKR"] = "별의 성소",
        ["ptBR"] = "Sacrário Estelar",
        ["ruRU"] = "Святилище Звезд",
        ["zhCN"] = "群星圣殿",
        ["zhTW"] = "星光聖所",
    },
    ["Sketh'lon Wreckage"] = {
        ["enUS"] = true,
        ["deDE"] = "Wrack der Sketh'lon",
        ["esES"] = "Ruinas de Sketh'lon",
        ["esMX"] = "Ruinas de Sketh'lon",
        ["frFR"] = "Débris sketh'lon",
        ["koKR"] = "스케슬론 폐허",
        ["ptBR"] = "Ruínas de Sketh'lon",
        ["ruRU"] = "Развалины Скет'лона",
        ["zhCN"] = "斯克瑟隆废墟",
        ["zhTW"] = "史凱瑟隆殘骸",
    },
    ["Olembas"] = {
        ["enUS"] = true,
        ["deDE"] = "Olembas",
        ["esES"] = "Olembas",
        ["esMX"] = "Olembas",
        ["frFR"] = "Olembas",
        ["koKR"] = "올렘바스",
        ["ptBR"] = "Olembas",
        ["ruRU"] = "Олембас",
        ["zhCN"] = "欧雷巴斯",
        ["zhTW"] = "奧萊姆貝斯",
    },
    ["Veil Skith"] = {
        ["enUS"] = true,
        ["deDE"] = "Skithversteck",
        ["esES"] = "Velo Skith",
        ["esMX"] = "Velo Skith",
        ["frFR"] = "Voile Skith",
        ["koKR"] = "장막의 스키스",
        ["ptBR"] = "Véu Skith",
        ["ruRU"] = "Гнездовье Скит",
        ["zhCN"] = "基斯鸦巢",
        ["zhTW"] = "迷霧斯奇司",
    },
    ["Bladespire Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Grund der Speerspießer",
        ["esES"] = "Dominios Aguja del Filo",
        ["esMX"] = "Dominios Aguja del Filo",
        ["frFR"] = "Terres de la Flèchelame",
        ["koKR"] = "칼날첨탑 영토",
        ["ptBR"] = "Terras dos Giralança",
        ["ruRU"] = "Земли Камнерогов",
        ["zhCN"] = "刀塔平原",
        ["zhTW"] = "劍刃庭園",
    },
    ["Wyrmskull Bridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Brücke des Wyrmschädels",
        ["esES"] = "Puente Calavermis",
        ["esMX"] = "Puente Calavermis",
        ["frFR"] = "Pont Crâne-du-ver",
        ["koKR"] = "고룡해골 다리",
        ["ptBR"] = "Ponte da Caveira de Dragão",
        ["ruRU"] = "Мост Драконьего Черепа",
        ["zhCN"] = "龙颅之桥",
        ["zhTW"] = "龍骨橋",
    },
    ["The Path of Conquest"] = {
        ["enUS"] = true,
        ["deDE"] = "Pfad der Eroberung",
        ["esES"] = "El Sendero de la Conquista",
        ["esMX"] = "El Sendero de la Conquista",
        ["frFR"] = "La voie de la Conquête",
        ["koKR"] = "정복의 길",
        ["ptBR"] = "O Caminho da Conquista",
        ["ruRU"] = "Путь Завоевания",
        ["zhCN"] = "征服之路",
        ["zhTW"] = "征服之路",
    },
    ["The Altar of Damnation"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar der Verdammnis",
        ["esES"] = "El Altar de Condenación",
        ["esMX"] = "El Altar de Condenación",
        ["frFR"] = "L'Autel de la damnation",
        ["koKR"] = "저주의 제단",
        ["ptBR"] = "Altar da Danação",
        ["ruRU"] = "Алтарь Проклятия",
        ["zhCN"] = "诅咒祭坛",
        ["zhTW"] = "詛咒祭壇",
    },
    ["The Tempest Rift"] = {
        ["enUS"] = true,
        ["deDE"] = "Kluft der Stürme",
        ["esES"] = "La Falla de la Tempestad",
        ["esMX"] = "La Falla de la Tempestad",
        ["frFR"] = "La Faille des tempêtes",
        ["koKR"] = "폭풍우 균열",
        ["ptBR"] = "Fenda Tempestuosa",
        ["ruRU"] = "Пояс Бурь",
        ["zhCN"] = "风暴裂隙",
        ["zhTW"] = "風暴裂口",
    },
    ["Forge Camp: Terror"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Terror",
        ["esES"] = "Campamento Forja: Terror",
        ["esMX"] = "Campamento Forja: Terror",
        ["frFR"] = "Camp de forge : Terreur",
        ["koKR"] = "공포의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Terror",
        ["ruRU"] = "Лагерь Легиона: Ужас",
        ["zhCN"] = "铸魔营地：恐怖",
        ["zhTW"] = "煉冶場:驚駭",
    },
    ["Boulder'mok"] = {
        ["enUS"] = true,
        ["deDE"] = "Fels'mok",
        ["esES"] = "Peña'mok",
        ["esMX"] = "Peña'mok",
        ["frFR"] = "Roche'mok",
        ["koKR"] = "바울더모크",
        ["ptBR"] = "Rocha'mok",
        ["ruRU"] = "Камен'мок",
        ["zhCN"] = "砾石营地",
        ["zhTW"] = "圓面之地",
    },
    ["Unused3"] = {
        ["enUS"] = true,
        ["deDE"] = "Unused3",
        ["esES"] = "Unused3",
        ["esMX"] = "Unused3",
        ["frFR"] = "Unused3",
        ["koKR"] = "Unused3",
        ["ptBR"] = "Unused3",
        ["ruRU"] = "Unused3",
        ["zhCN"] = "Unused3",
        ["zhTW"] = "Unused3",
    },
    ["Shattered Plains"] = {
        ["enUS"] = true,
        ["deDE"] = "Zerschlagene Weiten",
        ["esES"] = "Llanuras Devastadas",
        ["esMX"] = "Llanuras Devastadas",
        ["frFR"] = "Les plaines brisées",
        ["koKR"] = "부서진 평원",
        ["ptBR"] = "Platô Despedaçado",
        ["ruRU"] = "Разоренные равнины",
        ["zhCN"] = "破碎平原",
        ["zhTW"] = "破碎平原",
    },
    ["Bleeding Hollow Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen des Blutenden Auges",
        ["esES"] = "Ruinas Foso Sangrante",
        ["esMX"] = "Ruinas Foso Sangrante",
        ["frFR"] = "Ruines de l'Orbite sanglante",
        ["koKR"] = "피투성이굴 폐허",
        ["ptBR"] = "Ruínas dos Olhos Sangrentos",
        ["ruRU"] = "Руины Кровавой Глазницы",
        ["zhCN"] = "血环废墟",
        ["zhTW"] = "血之谷廢墟",
    },
    ["Southmaul Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Südschlägerturm",
        ["esES"] = "Torre Quiebrasur",
        ["esMX"] = "Torre Quiebrasur",
        ["frFR"] = "Tour Sud-sanglante",
        ["koKR"] = "남녘망치 탑",
        ["ptBR"] = "Torre Martelo do Sul",
        ["ruRU"] = "Башня Южного Молота",
        ["zhCN"] = "南槌哨塔",
        ["zhTW"] = "南槌哨塔",
    },
    ["Plain of Shards"] = {
        ["enUS"] = true,
        ["deDE"] = "Splitterebene",
        ["esES"] = "Llanura de los Fragmentos",
        ["esMX"] = "Llanura de los Fragmentos",
        ["frFR"] = "Plaine des éclats",
        ["koKR"] = "수정 들판",
        ["ptBR"] = "Planície dos Fragmentos",
        ["ruRU"] = "Долина Осколков",
        ["zhCN"] = "碎片平原",
        ["zhTW"] = "裂片曠野",
    },
    ["Raastok Glade"] = {
        ["enUS"] = true,
        ["deDE"] = "Raastokgrund",
        ["esES"] = "Claro Raastok",
        ["esMX"] = "Claro Raastok",
        ["frFR"] = "Clairière de Raastok",
        ["koKR"] = "라스토크 숲",
        ["ptBR"] = "Clareira Raastok",
        ["ruRU"] = "Прогалина Раасток",
        ["zhCN"] = "拉斯托克林地",
        ["zhTW"] = "羅史達克林地",
    },
    ["Blade Tooth Canyon"] = {
        ["enUS"] = true,
        ["deDE"] = "Säbelzahnschlucht",
        ["esES"] = "Cañón Dientespada",
        ["esMX"] = "Cañón Dientespada",
        ["frFR"] = "Canyon de Lamecroc",
        ["koKR"] = "칼날이빨 대협곡",
        ["ptBR"] = "Garganta da Presa Cortante",
        ["ruRU"] = "Каньон Острого Зуба",
        ["zhCN"] = "刃齿峡谷",
        ["zhTW"] = "劍齒峽谷",
    },
    ["Shatter Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Trümmerposten",
        ["esES"] = "Puesto Devastación",
        ["esMX"] = "Puesto Devastación",
        ["frFR"] = "Halte du Fracas",
        ["koKR"] = "징검다리 거점",
        ["ptBR"] = "Posto Despedaçado",
        ["ruRU"] = "Парящая застава",
        ["zhCN"] = "破碎岗哨",
        ["zhTW"] = "破碎崗哨",
    },
    ["Altar of Sha'tar"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar der Sha'tar",
        ["esES"] = "Altar de Sha'tar",
        ["esMX"] = "Altar de Sha'tar",
        ["frFR"] = "Autel de Sha'tar",
        ["koKR"] = "샤타르 제단",
        ["ptBR"] = "Altar de Sha'tar",
        ["ruRU"] = "Алтарь Ша'тар",
        ["zhCN"] = "沙塔尔祭坛",
        ["zhTW"] = "薩塔祭壇",
    },
    ["Ruins of Farahlon"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Farahlon",
        ["esES"] = "Ruinas de Farahlon",
        ["esMX"] = "Ruinas de Farahlon",
        ["frFR"] = "Ruines de Farahlon",
        ["koKR"] = "파랄론 폐허",
        ["ptBR"] = "Ruínas de Farahlon",
        ["ruRU"] = "Руины Фаралона",
        ["zhCN"] = "法兰伦废墟",
        ["zhTW"] = "法拉隆廢墟",
    },
    ["Bloodcurse Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel des Blutfluchs",
        ["esES"] = "Isla Sangre Maldita",
        ["esMX"] = "Isla Sangre Maldita",
        ["frFR"] = "Île du sang maudit",
        ["koKR"] = "핏빛저주의 섬",
        ["ptBR"] = "Ilha do Sangue Maldito",
        ["ruRU"] = "Остров Проклятой Крови",
        ["zhCN"] = "血咒岛",
        ["zhTW"] = "血咒島",
    },
    ["Moongraze Woods"] = {
        ["enUS"] = true,
        ["deDE"] = "Mondweidenwald",
        ["esES"] = "Bosque Pasto Lunar",
        ["esMX"] = "Bosque Pasto Lunar",
        ["frFR"] = "Bois frôle-lune",
        ["koKR"] = "달새김 숲",
        ["ptBR"] = "Matas do Pasto Lunar",
        ["ruRU"] = "Леса Лунного Оленя",
        ["zhCN"] = "月痕林地",
        ["zhTW"] = "牧月森林",
    },
    ["Sporewind Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Sporenwindsee",
        ["esES"] = "Lago Espora Volante",
        ["esMX"] = "Lago Espora Volante",
        ["frFR"] = "Lac Ventespore",
        ["koKR"] = "포자바람 호수",
        ["ptBR"] = "Lago dos Esporos",
        ["ruRU"] = "Озеро Спороветра",
        ["zhCN"] = "孢子湖",
        ["zhTW"] = "孢子風之湖",
    },
    ["The Shepherd's Gate"] = {
        ["enUS"] = true,
        ["deDE"] = "Hirtentor",
        ["esES"] = "La Puerta del Pastor",
        ["esMX"] = "La Puerta del Pastor",
        ["frFR"] = "Porte du Berger",
        ["koKR"] = "수호자의 관문",
        ["ptBR"] = "Portão do Pastor",
        ["ruRU"] = "Ворота Пастыря",
        ["zhCN"] = "牧羊人之门",
        ["zhTW"] = "牧羊人之門",
    },
    ["Fairbridge Strand"] = {
        ["enUS"] = true,
        ["deDE"] = "Morgentaustrand",
        ["esES"] = "Playa Puentegrato",
        ["esMX"] = "Playa Puentegrato",
        ["frFR"] = "Rivage de Pontgallant",
        ["koKR"] = "구름다리 해변",
        ["ptBR"] = "Praia Pontebela",
        ["ruRU"] = "Берег у Крепкого моста",
        ["zhCN"] = "玉桥海滩",
        ["zhTW"] = "美橋海岸",
    },
    ["Runestone Shan'dor"] = {
        ["enUS"] = true,
        ["deDE"] = "Runenstein Shan'dor",
        ["esES"] = "Piedra Rúnica Shan'dor",
        ["esMX"] = "Piedra Rúnica Shan'dor",
        ["frFR"] = "Pierre runique Shan'dor",
        ["koKR"] = "샨도르 마법석",
        ["ptBR"] = "Pedra Rúnica Shan'dor",
        ["ruRU"] = "Рунический камень Шан'дор",
        ["zhCN"] = "杉多尔符文石",
        ["zhTW"] = "符石夏納多爾",
    },
    ["Runestone Falithas"] = {
        ["enUS"] = true,
        ["deDE"] = "Runenstein Falithas",
        ["esES"] = "Piedra Rúnica Falithas",
        ["esMX"] = "Piedra Rúnica Falithas",
        ["frFR"] = "Pierre runique Falithas",
        ["koKR"] = "팔리타스 마법석",
        ["ptBR"] = "Pedra Rúnica Falithas",
        ["ruRU"] = "Рунический камень Фалитас",
        ["zhCN"] = "法利萨斯符文石",
        ["zhTW"] = "符石菲薩斯",
    },
    ["Den of Haal'esh"] = {
        ["enUS"] = true,
        ["deDE"] = "Haal'eshbau",
        ["esES"] = "Cubil de Haal'esh",
        ["esMX"] = "Cubil de Haal'esh",
        ["frFR"] = "Tanière des Haal'esh",
        ["koKR"] = "하알레쉬 소굴",
        ["ptBR"] = "Antro de Haal'esh",
        ["ruRU"] = "Логово Хаал'эш",
        ["zhCN"] = "哈尔什巢穴",
        ["zhTW"] = "海艾斯洞穴",
    },
    ["Telaari Basin"] = {
        ["enUS"] = true,
        ["deDE"] = "Telaaribecken",
        ["esES"] = "Cuenca Telaari",
        ["esMX"] = "Cuenca Telaari",
        ["frFR"] = "Bassin telaari",
        ["koKR"] = "텔라아리 분지",
        ["ptBR"] = "Bacia Telaari",
        ["ruRU"] = "Телаарская котловина",
        ["zhCN"] = "塔拉盆地",
        ["zhTW"] = "泰拉蕊盆地",
    },
    ["Netherwing Mines"] = {
        ["enUS"] = true,
        ["deDE"] = "Netherschwingenminen",
        ["esES"] = "Minas del Ala Abisal",
        ["esMX"] = "Minas del Ala Abisal",
        ["frFR"] = "Mines de l'Aile-du-Néant",
        ["koKR"] = "황천날개 광산",
        ["ptBR"] = "Minas da Asa Etérea",
        ["ruRU"] = "Копи Крыльев Пустоты",
        ["zhCN"] = "灵翼矿洞",
        ["zhTW"] = "虛空之翼礦坑",
    },
    ["The Living Grove"] = {
        ["enUS"] = true,
        ["deDE"] = "Der lebende Hain",
        ["esES"] = "La Arboleda Viviente",
        ["esMX"] = "La Arboleda Viviente",
        ["frFR"] = "Le Bosquet vivant",
        ["koKR"] = "생명의 숲",
        ["ptBR"] = "Bosque Vicejante",
        ["ruRU"] = "Живая роща",
        ["zhCN"] = "活木林",
        ["zhTW"] = "生命之林",
    },
    ["Ruins of Enkaat"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Enkaat",
        ["esES"] = "Ruinas de Enkaat",
        ["esMX"] = "Ruinas de Enkaat",
        ["frFR"] = "Ruines d'Enkaat",
        ["koKR"] = "엔카트 폐허",
        ["ptBR"] = "Ruínas de Enkaat",
        ["ruRU"] = "Руины Энкаата",
        ["zhCN"] = "恩卡特废墟",
        ["zhTW"] = "安卡特廢墟",
    },
    ["Halaa"] = {
        ["enUS"] = true,
        ["deDE"] = "Halaa",
        ["esES"] = "Halaa",
        ["esMX"] = "Halaa",
        ["frFR"] = "Halaa",
        ["koKR"] = "할라아",
        ["ptBR"] = "Halaa",
        ["ruRU"] = "Халаа",
        ["zhCN"] = "哈兰",
        ["zhTW"] = "哈剌",
    },
    ["Temple of Telhamat"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel von Telhamat",
        ["esES"] = "Templo de Telhamat",
        ["esMX"] = "Templo de Telhamat",
        ["frFR"] = "Temple de Telhamat",
        ["koKR"] = "텔하마트 사원",
        ["ptBR"] = "Templo de Telhamat",
        ["ruRU"] = "Храм Телхамат",
        ["zhCN"] = "塔哈玛特神殿",
        ["zhTW"] = "特爾哈曼神廟",
    },
    ["Stonewall Canyon"] = {
        ["enUS"] = true,
        ["deDE"] = "Steinwallschlucht",
        ["esES"] = "Cañón de la Muralla",
        ["esMX"] = "Cañón de la Muralla",
        ["frFR"] = "Canyon de la Muraille",
        ["koKR"] = "돌담 협곡",
        ["ptBR"] = "Garganta de Pedra",
        ["ruRU"] = "Каньон Каменной Стены",
        ["zhCN"] = "石墙峡谷",
        ["zhTW"] = "石鐮峽谷",
    },
    ["Mystwood"] = {
        ["enUS"] = true,
        ["deDE"] = "Mythoswald",
        ["esES"] = "Bosque Bruma",
        ["esMX"] = "Bosque Bruma",
        ["frFR"] = "Bois brumeux",
        ["koKR"] = "안개숲",
        ["ptBR"] = "Bosque das Névoas",
        ["ruRU"] = "Таинственная роща",
        ["zhCN"] = "神木林",
        ["zhTW"] = "神秘森林",
    },
    ["The Lost Fold"] = {
        ["enUS"] = true,
        ["deDE"] = "Die verlorene Furt",
        ["esES"] = "El Aprisco Perdido",
        ["esMX"] = "El Aprisco Perdido",
        ["frFR"] = "Le Repli perdu",
        ["koKR"] = "잃어버린 언덕",
        ["ptBR"] = "Recôncavo Perdido",
        ["ruRU"] = "Затерянная Падь",
        ["zhCN"] = "损坏的兽笼",
        ["zhTW"] = "遺忘農場",
    },
    ["Aeris Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Aerissteg",
        ["esES"] = "Desembarco Aeris",
        ["esMX"] = "Desembarco Aeris",
        ["frFR"] = "Point d'ancrage Aeris",
        ["koKR"] = "에어리스 착륙지",
        ["ptBR"] = "Posto Aeris",
        ["ruRU"] = "Небесный лагерь",
        ["zhCN"] = "埃瑞斯码头",
        ["zhTW"] = "艾瑞斯平臺",
    },
    ["Chapel Yard"] = {
        ["enUS"] = true,
        ["deDE"] = "Kapellenhof",
        ["esES"] = "Patio de la Capilla",
        ["esMX"] = "Patio de la Capilla",
        ["frFR"] = "Cour de la chapelle",
        ["koKR"] = "예배당 지구",
        ["ptBR"] = "Pátio da Capela",
        ["ruRU"] = "Церковный двор",
        ["zhCN"] = "礼拜堂广场",
        ["zhTW"] = "教堂庭院",
    },
    ["The High Path"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Hochpfad",
        ["esES"] = "El Paso Elevado",
        ["esMX"] = "El Paso Elevado",
        ["frFR"] = "Le Haut chemin",
        ["koKR"] = "높은길",
        ["ptBR"] = "Caminho Alto",
        ["ruRU"] = "Верхний путь",
        ["zhCN"] = "高原小径",
        ["zhTW"] = "險惡之地",
    },
    ["Bristlelimb Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Enklave der Sichelklauen",
        ["esES"] = "Enclave Brazolanudo",
        ["esMX"] = "Enclave Brazolanudo",
        ["frFR"] = "L'enclave des Bras-hirsutes",
        ["koKR"] = "뾰족가지 군락",
        ["ptBR"] = "Enclave dos Ericerdos",
        ["ruRU"] = "Анклав Косолапов",
        ["zhCN"] = "刺臂领地",
        ["zhTW"] = "鬚肢營地",
    },
    ["Sun's Reach Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum der Sonnenweiten",
        ["esES"] = "Sagrario de Tramo del Sol",
        ["esMX"] = "Sagrario de Tramo del Sol",
        ["frFR"] = "Sanctum des Confins du soleil",
        ["koKR"] = "태양너울 성소",
        ["ptBR"] = "Sacrário Beirassol",
        ["ruRU"] = "Святилище Солнечного Края",
        ["zhCN"] = "阳湾圣殿",
        ["zhTW"] = "日境聖所",
    },
    ["Veridian Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Viridiangrund",
        ["esES"] = "Punta Veridiana",
        ["esMX"] = "Punta Veridiana",
        ["frFR"] = "Cap viridien",
        ["koKR"] = "청록 해안",
        ["ptBR"] = "Ponta Viridiana",
        ["ruRU"] = "Вершина Веридиан",
        ["zhCN"] = "绿龙尖岬",
        ["zhTW"] = "翠綠崗哨",
    },
    ["The Bloodwash"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutbrandung",
        ["esES"] = "La Playa de Sangre",
        ["esMX"] = "La Playa de Sangre",
        ["frFR"] = "Le Reflux sanglant",
        ["koKR"] = "핏빛 여울",
        ["ptBR"] = "Maré Sangrenta",
        ["ruRU"] = "Кровавый Прибой",
        ["zhCN"] = "血浪海滩",
        ["zhTW"] = "血浴之地",
    },
    ["The Warp Piston"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Warpgondel",
        ["esES"] = "El Pistón de Distorsión",
        ["esMX"] = "El Pistón de Distorsión",
        ["frFR"] = "Le piston de distorsion",
        ["koKR"] = "초공간 추진기",
        ["ptBR"] = "Pistão Dimensional",
        ["ruRU"] = "Сверхускоритель",
        ["zhCN"] = "跳跃引擎",
        ["zhTW"] = "星移活塞",
    },
    ["Windyreed Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Schilftanzpass",
        ["esES"] = "Paso Junco Alabeado",
        ["esMX"] = "Paso Junco Alabeado",
        ["frFR"] = "Passe de Ventejonc",
        ["koKR"] = "바람갈대 고개",
        ["ptBR"] = "Desfiladeiro Canavento",
        ["ruRU"] = "Перевал Трепещущего Тростника",
        ["zhCN"] = "风茅小径",
        ["zhTW"] = "風蘆小徑",
    },
    ["The Dead Scar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Todesschneise",
        ["esES"] = "La Cicatriz Muerta",
        ["esMX"] = "La Cicatriz Muerta",
        ["frFR"] = "La Malebrèche",
        ["koKR"] = "죽음의 흉터",
        ["ptBR"] = "A Trilha da Morte",
        ["ruRU"] = "Тропа Мертвых",
        ["zhCN"] = "死亡之痕",
        ["zhTW"] = "死亡之痕",
    },
    ["Forge Camp: Anger"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Groll",
        ["esES"] = "Campamento Forja: Inquina",
        ["esMX"] = "Campamento Forja: Inquina",
        ["frFR"] = "Camp de forge : Colère",
        ["koKR"] = "고통의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Fúria",
        ["ruRU"] = "Лагерь Легиона: Злоба",
        ["zhCN"] = "铸魔营地：怒火",
        ["zhTW"] = "煉冶場:怒氣",
    },
    ["Oronok's Farm"] = {
        ["enUS"] = true,
        ["deDE"] = "Oronoks Hof",
        ["esES"] = "Granja de Oronok",
        ["esMX"] = "Granja de Oronok",
        ["frFR"] = "Ferme d'Oronok",
        ["koKR"] = "오로노크의 농장",
        ["ptBR"] = "Fazenda de Oronok",
        ["ruRU"] = "Ферма Оронока",
        ["zhCN"] = "欧鲁诺克农场",
        ["zhTW"] = "歐朗諾克的農場",
    },
    ["The Lagoon"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lagune",
        ["esES"] = "La Laguna",
        ["esMX"] = "La Laguna",
        ["frFR"] = "Le Lagon",
        ["koKR"] = "바다자리 호수",
        ["ptBR"] = "A Lagoa",
        ["ruRU"] = "Лагуна",
        ["zhCN"] = "环礁湖",
        ["zhTW"] = "瀉湖",
    },
    ["The Stair of Destiny"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Stufen des Schicksals",
        ["esES"] = "Los Peldaños del Destino",
        ["esMX"] = "Los Peldaños del Destino",
        ["frFR"] = "L'escalier du Destin",
        ["koKR"] = "운명의 계단",
        ["ptBR"] = "Degraus do Destino",
        ["ruRU"] = "Ступени Судьбы",
        ["zhCN"] = "命运阶梯",
        ["zhTW"] = "命運階梯",
    },
    ["Stonebreaker Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Steinbrecherlager",
        ["esES"] = "Campamento Rompepedras",
        ["esMX"] = "Campamento Rompepedras",
        ["frFR"] = "Camp des Brise-pierres",
        ["koKR"] = "돌망치 야영지",
        ["ptBR"] = "Acampamento Quebrapedra",
        ["ruRU"] = "Лагерь Камнеломов",
        ["zhCN"] = "裂石营地",
        ["zhTW"] = "碎石營地",
    },
    ["Firewing Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Posten der Feuerschwingen",
        ["esES"] = "Alto Ala de Fuego",
        ["esMX"] = "Alto Ala de Fuego",
        ["frFR"] = "Halte Aile-de-feu",
        ["koKR"] = "불꽃날개 거점",
        ["ptBR"] = "Pontal Asardente",
        ["ruRU"] = "Лагерь Огнекрылых",
        ["zhCN"] = "火翼岗哨",
        ["zhTW"] = "火翼崗哨",
    },
    ["Upper Veil Shil'ak"] = {
        ["enUS"] = true,
        ["deDE"] = "Oberes Shil'akversteck",
        ["esES"] = "Velo Shil'ak Alto",
        ["esMX"] = "Velo Shil'ak Alto",
        ["frFR"] = "Voile Shil'ak supérieur",
        ["koKR"] = "장막의 쉴라크 언덕",
        ["ptBR"] = "Véu Shil'ak Superior",
        ["ruRU"] = "Верхнее гнездовье Шил'ак",
        ["zhCN"] = "上层夏尔克鸦巢",
        ["zhTW"] = "迷霧希拉克上層",
    },
    ["Terrace of Light"] = {
        ["enUS"] = true,
        ["deDE"] = "Terrasse des Lichts",
        ["esES"] = "Bancal de la Luz",
        ["esMX"] = "Bancal de la Luz",
        ["frFR"] = "Terrasse de la Lumière",
        ["koKR"] = "빛의 정원",
        ["ptBR"] = "Terraço da Luz",
        ["ruRU"] = "Терраса Света",
        ["zhCN"] = "圣光广场",
        ["zhTW"] = "聖光露臺",
    },
    ["Midrealm Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Mittelreichposten",
        ["esES"] = "Puesto de la Tierra Media",
        ["esMX"] = "Puesto de la Tierra Media",
        ["frFR"] = "Comptoir des Terres-médianes",
        ["koKR"] = "중앙 생태지구 주둔지",
        ["ptBR"] = "Posto Terramédia",
        ["ruRU"] = "Застава срединных земель",
        ["zhCN"] = "中央圆顶哨站",
        ["zhTW"] = "領地崗哨",
    },
    ["Cenarion Watchpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Wachposten des Cenarius",
        ["esES"] = "Puesto de Vigilancia Cenarion",
        ["esMX"] = "Puesto de Vigilancia Cenarion",
        ["frFR"] = "Poste de garde cénarien",
        ["koKR"] = "세나리온 감시초소",
        ["ptBR"] = "Guarita Cenariana",
        ["ruRU"] = "Кенарийский караульный пост",
        ["zhCN"] = "塞纳里奥岗哨",
        ["zhTW"] = "塞納里奧看守站",
    },
    ["Oshu'gun"] = {
        ["enUS"] = true,
        ["deDE"] = "Oshu'gun",
        ["esES"] = "Oshu'gun",
        ["esMX"] = "Oshu'gun",
        ["frFR"] = "Oshu'gun",
        ["koKR"] = "오슈군",
        ["ptBR"] = "Oshu'gun",
        ["ruRU"] = "Ошу'гун",
        ["zhCN"] = "沃舒古",
        ["zhTW"] = "歐夏剛",
    },
    ["Writhing Mound"] = {
        ["enUS"] = true,
        ["deDE"] = "Der gequälte Hügel",
        ["esES"] = "Alcor Tortuoso",
        ["esMX"] = "Alcor Tortuoso",
        ["frFR"] = "Monticule grouillant",
        ["koKR"] = "고뇌의 언덕",
        ["ptBR"] = "Morro Retorcido",
        ["ruRU"] = "Перекопанный курган",
        ["zhCN"] = "痛苦之丘",
        ["zhTW"] = "苦痛山丘",
    },
    ["Arena Floor"] = {
        ["enUS"] = true,
        ["deDE"] = "Arenagrund",
        ["esES"] = "El Suelo de la Arena",
        ["esMX"] = "El Suelo de la Arena",
        ["frFR"] = "Sol de l'arène",
        ["koKR"] = "투기장",
        ["ptBR"] = "Pátio da Arena",
        ["ruRU"] = "Нижний уровень поля боя",
        ["zhCN"] = "竞技场",
        ["zhTW"] = "競技場地面",
    },
    ["Carrion Hill"] = {
        ["enUS"] = true,
        ["deDE"] = "Aashügel",
        ["esES"] = "Colina Carroña",
        ["esMX"] = "Colina Carroña",
        ["frFR"] = "Colline des charognes",
        ["koKR"] = "부패의 언덕",
        ["ptBR"] = "Monte Carniçal",
        ["ruRU"] = "Холм Падальщика",
        ["zhCN"] = "腐臭山",
        ["zhTW"] = "腐蝕嶺",
    },
    ["Tomb of Lights"] = {
        ["enUS"] = true,
        ["deDE"] = "Grab des Lichts",
        ["esES"] = "Tumba de las Luces",
        ["esMX"] = "Tumba de las Luces",
        ["frFR"] = "Tombeau des lumières",
        ["koKR"] = "빛의 무덤",
        ["ptBR"] = "Tumba das Luzes",
        ["ruRU"] = "Гробница Света",
        ["zhCN"] = "圣光之墓",
        ["zhTW"] = "聖光之墓",
    },
    ["The Hidden Reef"] = {
        ["enUS"] = true,
        ["deDE"] = "Das versteckte Riff",
        ["esES"] = "El Arrecife Oculto",
        ["esMX"] = "El Arrecife Oculto",
        ["frFR"] = "Le récif caché",
        ["koKR"] = "숨은 산호초",
        ["ptBR"] = "Recife Oculto",
        ["ruRU"] = "Подводный риф",
        ["zhCN"] = "藏帆暗礁",
        ["zhTW"] = "隱秘沙洲",
    },
    ["The Path of Glory"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Pfad des Ruhms",
        ["esES"] = "El Camino a la Gloria",
        ["esMX"] = "El Camino a la Gloria",
        ["frFR"] = "Le sentier de la Gloire",
        ["koKR"] = "영광의 길",
        ["ptBR"] = "Caminho da Glória",
        ["ruRU"] = "Путь Славы",
        ["zhCN"] = "荣耀之路",
        ["zhTW"] = "光榮之路",
    },
    ["Darkcrest Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Enklave der Dunkelkämme",
        ["esES"] = "Enclave de la Cumbre Oscura",
        ["esMX"] = "Enclave Cresta Oscura",
        ["frFR"] = "Enclave des sombrecrêtes",
        ["koKR"] = "암흑갈기 군락",
        ["ptBR"] = "Enclave Cristanegra",
        ["ruRU"] = "Анклав Темного Гребня",
        ["zhCN"] = "暗潮营地",
        ["zhTW"] = "暗羽飛行地",
    },
    ["Veil Rhaze"] = {
        ["enUS"] = true,
        ["deDE"] = "Rhazeversteck",
        ["esES"] = "Velo Rhaze",
        ["esMX"] = "Velo Rhaze",
        ["frFR"] = "Voile Rhaze",
        ["koKR"] = "장막의 라제",
        ["ptBR"] = "Véu Rhaze",
        ["ruRU"] = "Гнездовье Рейз",
        ["zhCN"] = "哈兹鸦巢",
        ["zhTW"] = "迷霧瑞漢茲",
    },
    ["Sunfire Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenfeuergrund",
        ["esES"] = "Punta del Fuego Solar",
        ["esMX"] = "Punta del Fuego Solar",
        ["frFR"] = "Halte du Feu solaire",
        ["koKR"] = "태양불꽃 거점",
        ["ptBR"] = "Pontal do Fogo Solar",
        ["ruRU"] = "Пик Солнечного Пламени",
        ["zhCN"] = "阳炎岗哨",
        ["zhTW"] = "烈日火焰崗哨",
    },
    ["Geezle's Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Geezles Lager",
        ["esES"] = "Campamento de Geezle",
        ["esMX"] = "Campamento de Geezle",
        ["frFR"] = "Camp de Geezle",
        ["koKR"] = "기즐의 야영지",
        ["ptBR"] = "Acampamento do Zé Ruela",
        ["ruRU"] = "Лагерь Гизла",
        ["zhCN"] = "吉兹尔的营地",
        ["zhTW"] = "吉索的營地",
    },
    ["Dragonmaw Skyway"] = {
        ["enUS"] = true,
        ["deDE"] = "Himmelspfad des Drachenmals",
        ["esES"] = "Ruta Aérea Faucedraco",
        ["esMX"] = "Ruta Aérea Faucedraco",
        ["frFR"] = "Couloir aérien des Gueules-de-dragon",
        ["koKR"] = "용아귀 하늘길",
        ["ptBR"] = "Ponte Aérea Presa do Dragão",
        ["ruRU"] = "Заоблачная тропа Драконьей Пасти",
        ["zhCN"] = "龙喉空港",
        ["zhTW"] = "龍喉航線",
    },
    ["Refugee Caravan"] = {
        ["enUS"] = true,
        ["deDE"] = "Flüchtlingskarawane",
        ["esES"] = "Caravana de Refugiados",
        ["esMX"] = "Caravana de Refugiados",
        ["frFR"] = "Caravane de réfugiés",
        ["koKR"] = "피난민 행렬",
        ["ptBR"] = "Caravana dos Refugiados",
        ["ruRU"] = "Караван беженцев",
        ["zhCN"] = "难民车队",
        ["zhTW"] = "難民商隊",
    },
    ["Eco-Dome Midrealm"] = {
        ["enUS"] = true,
        ["deDE"] = "Biokuppel Mittelreich",
        ["esES"] = "Ecodomo de la Tierra Media",
        ["esMX"] = "Ecodomo de la Tierra Media",
        ["frFR"] = "Écodôme Terres-médianes",
        ["koKR"] = "중앙 생태지구",
        ["ptBR"] = "Eco-domo Terramédia",
        ["ruRU"] = "Заповедник \"Срединные земли\"",
        ["zhCN"] = "中央生态圆顶",
        ["zhTW"] = "秘境領地",
    },
    ["Derelict Caravan"] = {
        ["enUS"] = true,
        ["deDE"] = "Die herrenlose Karawane",
        ["esES"] = "Caravana Derelicta",
        ["esMX"] = "Caravana Derelicta",
        ["frFR"] = "Caravane abandonnée",
        ["koKR"] = "버려진 짐마차",
        ["ptBR"] = "Caravana Abandonada",
        ["ruRU"] = "Брошенный Караван",
        ["zhCN"] = "被遗弃的篷车",
        ["zhTW"] = "被遺棄的商隊",
    },
    ["Spinebreaker Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Rückenbrecherposten",
        ["esES"] = "Avanzada Rompeloma",
        ["esMX"] = "Avanzada Rompeloma",
        ["frFR"] = "Poste de Brise-échine",
        ["koKR"] = "해골망치 초소",
        ["ptBR"] = "Acampamento Quebra-espinha",
        ["ruRU"] = "Застава Хребтолома",
        ["zhCN"] = "断背岗哨",
        ["zhTW"] = "斷脊氏族崗哨",
    },
    ["Camp of Boom"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager von Dr. Bumm",
        ["esES"] = "Campamento de Bum",
        ["esMX"] = "Campamento de Bum",
        ["frFR"] = "Camp de Boum",
        ["koKR"] = "붐의 야영지",
        ["ptBR"] = "Acampamento do Dr. Cabum",
        ["ruRU"] = "Лагерь Бума",
        ["zhCN"] = "砰砰博士的营地",
        ["zhTW"] = "布姆營地",
    },
    ["Wildwind Path"] = {
        ["enUS"] = true,
        ["deDE"] = "Wildwindpfad",
        ["esES"] = "Senda Ventosalvaje",
        ["esMX"] = "Senda Ventosalvaje",
        ["frFR"] = "Sentier du Vent-sauvage",
        ["koKR"] = "갈기바람 길",
        ["ptBR"] = "Trilha Vento Selvagem",
        ["ruRU"] = "Штормовой путь",
        ["zhCN"] = "狂风小径",
        ["zhTW"] = "狂風小徑",
    },
    ["Access Shaft Zeon"] = {
        ["enUS"] = true,
        ["deDE"] = "Zugangsschacht Zeon",
        ["esES"] = "Eje de Acceso Zeon",
        ["esMX"] = "Eje de Acceso Zeon",
        ["frFR"] = "Puits d'accès Zéon",
        ["koKR"] = "지온 작업 갱도",
        ["ptBR"] = "Poço de Acesso Zeon",
        ["ruRU"] = "Вход в шахту Зеон",
        ["zhCN"] = "瑟安竖井",
        ["zhTW"] = "礦井之路通道",
    },
    ["Middenvale"] = {
        ["enUS"] = true,
        ["deDE"] = "Trümmerfall",
        ["esES"] = "Mediavega",
        ["esMX"] = "Mediavega",
        ["frFR"] = "Ordeval",
        ["koKR"] = "무지렁이 골짜기",
        ["ptBR"] = "Vale da Podridão",
        ["ruRU"] = "Прелая долина",
        ["zhCN"] = "废墟谷",
        ["zhTW"] = "廢棄谷",
    },
    ["Odesyus' Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Odesyus' Ankerplatz",
        ["esES"] = "Desembarco de Odesyus",
        ["esMX"] = "Desembarco de Odesyus",
        ["frFR"] = "Point d'accostage d'Odesyus",
        ["koKR"] = "오디시우스의 정박지",
        ["ptBR"] = "Assentamento de Odisseu",
        ["ruRU"] = "Лагерь Одиссия",
        ["zhCN"] = "奥德修斯营地",
        ["zhTW"] = "奧迪席斯平臺",
    },
    ["Ethereum Staging Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Stützpunkt des Astraleums",
        ["esES"] = "Punto de Escala Etereum",
        ["esMX"] = "Punto de Escala de El Etereum",
        ["frFR"] = "Lieu de rassemblement de l'Ethereum",
        ["koKR"] = "에테리움 작전 지역",
        ["ptBR"] = "Bivaques do Eteréum",
        ["ruRU"] = "Испытательный полигон Эфириума",
        ["zhCN"] = "复仇军前沿基地",
        ["zhTW"] = "伊斯利恩軍事要塞",
    },
    ["Eco-Dome Sutheron"] = {
        ["enUS"] = true,
        ["deDE"] = "Biokuppel Sutheron",
        ["esES"] = "Ecodomo Sutheron",
        ["esMX"] = "Ecodomo Sutheron",
        ["frFR"] = "Écodôme Sudron",
        ["koKR"] = "수데론 생태지구",
        ["ptBR"] = "Eco-domo Sutheron",
        ["ruRU"] = "Заповедник \"Сатерон\"",
        ["zhCN"] = "苏瑟伦生态圆顶",
        ["zhTW"] = "桑什倫秘境",
    },
    ["The Black Temple"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schwarze Tempel",
        ["esES"] = "El Templo Oscuro",
        ["esMX"] = "El Templo Oscuro",
        ["frFR"] = "Le Temple noir",
        ["koKR"] = "검은 사원",
        ["ptBR"] = "Templo Negro",
        ["ruRU"] = "Черный храм",
        ["zhCN"] = "黑暗神殿",
        ["zhTW"] = "黑暗神廟",
    },
    ["Eco-Dome Farfield"] = {
        ["enUS"] = true,
        ["deDE"] = "Biokuppel Fernfeld",
        ["esES"] = "Ecodomo Campolejano",
        ["esMX"] = "Ecodomo Campolejano",
        ["frFR"] = "Écodôme Champlointain",
        ["koKR"] = "외곽 생태지구",
        ["ptBR"] = "Eco-domo Campolonge",
        ["ruRU"] = "Заповедник \"Дальнее поле\"",
        ["zhCN"] = "边缘生态圆顶",
        ["zhTW"] = "秘境原野",
    },
    ["Stillwhisper Pond"] = {
        ["enUS"] = true,
        ["deDE"] = "Stillwispertümpel",
        ["esES"] = "Charca Plácido Susurro",
        ["esMX"] = "Charca Plácido Susurro",
        ["frFR"] = "Étang des Murmures-sereins",
        ["koKR"] = "잔잔한 속삭임 연못",
        ["ptBR"] = "Lagoa do Eterno Sussurro",
        ["ruRU"] = "Пруд Тихого Шелеста",
        ["zhCN"] = "萦语水池",
        ["zhTW"] = "靜語池",
    },
    ["Gyro-Plank Bridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Gyroplankenbrücke",
        ["esES"] = "Puente Girolámina",
        ["esMX"] = "Puente Girolámina",
        ["frFR"] = "Pont de gyro-passerelles",
        ["koKR"] = "자이로 교각",
        ["ptBR"] = "Ponte Giroprancha",
        ["ruRU"] = "Гиро-балочный мост",
        ["zhCN"] = "机械桥",
        ["zhTW"] = "環木橋",
    },
    ["Bladed Gulch"] = {
        ["enUS"] = true,
        ["deDE"] = "Messerschlucht",
        ["esES"] = "Barranco del Filo",
        ["esMX"] = "Barranco del Filo",
        ["frFR"] = "Goulet des Lames",
        ["koKR"] = "칼날 협곡",
        ["ptBR"] = "Ravina das Lâminas",
        ["ruRU"] = "Лощина Клинков",
        ["zhCN"] = "刀刃峡谷",
        ["zhTW"] = "刀刃峽谷",
    },
    ["Azure Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Azurwacht",
        ["esES"] = "Avanzada Azur",
        ["esMX"] = "Avanzada Azur",
        ["frFR"] = "Guet d'azur",
        ["koKR"] = "하늘 감시초소",
        ["ptBR"] = "Entreposto Lazúli",
        ["ruRU"] = "Лазурная застава",
        ["zhCN"] = "碧蓝岗哨",
        ["zhTW"] = "藍色守望",
    },
    ["Crystal Spine"] = {
        ["enUS"] = true,
        ["deDE"] = "Kristallrücken",
        ["esES"] = "Espina de Cristal",
        ["esMX"] = "Espina de Cristal",
        ["frFR"] = "Éperon de cristal",
        ["koKR"] = "수정 돌기",
        ["ptBR"] = "Serra dos Cristais",
        ["ruRU"] = "Хрустальное поле",
        ["zhCN"] = "水晶之脊",
        ["zhTW"] = "水晶背脊",
    },
    ["Elrendar Falls"] = {
        ["enUS"] = true,
        ["deDE"] = "Elrendarfälle",
        ["esES"] = "Cascadas Elrendar",
        ["esMX"] = "Cascadas Elrendar",
        ["frFR"] = "Chutes de l'Elrendar",
        ["koKR"] = "엘렌다르 폭포",
        ["ptBR"] = "Cachoeira Elrendar",
        ["ruRU"] = "Водопад Элрендар",
        ["zhCN"] = "艾伦达尔瀑布",
        ["zhTW"] = "艾蘭達瀑布",
    },
    ["Shadow Tomb"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattengrab",
        ["esES"] = "Tumba Umbría",
        ["esMX"] = "Tumba Umbría",
        ["frFR"] = "Tombe des ombres",
        ["koKR"] = "어둠의 무덤",
        ["ptBR"] = "Tumba Sombria",
        ["ruRU"] = "Гробница Тени",
        ["zhCN"] = "暗影墓穴",
        ["zhTW"] = "暗影之墓",
    },
    ["Southwind Cleft"] = {
        ["enUS"] = true,
        ["deDE"] = "Südwindkluft",
        ["esES"] = "Grieta del Viento Sur",
        ["esMX"] = "Grieta del Viento Sur",
        ["frFR"] = "Faille de Sudevent",
        ["koKR"] = "마파람 동굴",
        ["ptBR"] = "Fenda do Vento Sul",
        ["ruRU"] = "Расщелина Южного Ветра",
        ["zhCN"] = "南风裂谷",
        ["zhTW"] = "南風斷崖",
    },
    ["Broken Wilds"] = {
        ["enUS"] = true,
        ["deDE"] = "Zerschlagene Wildnis",
        ["esES"] = "Landas Tábidas",
        ["esMX"] = "Landas Tábidas",
        ["frFR"] = "Landes brisées",
        ["koKR"] = "파괴된 벌판",
        ["ptBR"] = "Espinhaço Inóspito",
        ["ruRU"] = "Скалистые пустоши",
        ["zhCN"] = "破碎荒野",
        ["zhTW"] = "破碎荒野",
    },
    ["Falconwing Square"] = {
        ["enUS"] = true,
        ["deDE"] = "Falkenplatz",
        ["esES"] = "Plaza Alalcón",
        ["esMX"] = "Plaza Alalcón",
        ["frFR"] = "Place de l'épervier",
        ["koKR"] = "매날개 광장",
        ["ptBR"] = "Praça Asa do Falcão",
        ["ruRU"] = "Площадь Соколиных Крыльев",
        ["zhCN"] = "鹰翼广场",
        ["zhTW"] = "獵鷹之翼廣場",
    },
    ["Ammen Ford"] = {
        ["enUS"] = true,
        ["deDE"] = "Am'menfluss",
        ["esES"] = "Vado Ammen",
        ["esMX"] = "Vado Ammen",
        ["frFR"] = "Gué d'Ammen",
        ["koKR"] = "암멘 여울",
        ["ptBR"] = "Vau Ammen",
        ["ruRU"] = "Переправа Аммен",
        ["zhCN"] = "埃门海滩",
        ["zhTW"] = "安曼淺灘",
    },
    ["Thalassian Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Thalassischer Pass",
        ["esES"] = "Desfiladero Thalassiano",
        ["esMX"] = "Desfiladero Thalassiano",
        ["frFR"] = "Passe thalassienne",
        ["koKR"] = "탈라시안 고개",
        ["ptBR"] = "Caminho Thalassiano",
        ["ruRU"] = "Талассийский перевал",
        ["zhCN"] = "萨拉斯小径",
        ["zhTW"] = "薩拉斯小徑",
    },
    ["Bladespire Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten der Speerspießer",
        ["esES"] = "Avanzada Aguja del Filo",
        ["esMX"] = "Avanzada Aguja del Filo",
        ["frFR"] = "Avant-poste Flèchelame",
        ["koKR"] = "칼날첨탑 전초기지",
        ["ptBR"] = "Acampamento Giralança",
        ["ruRU"] = "Застава Камнерогов",
        ["zhCN"] = "刀塔哨站",
        ["zhTW"] = "劍刃崗哨",
    },
    ["Allerian Stronghold"] = {
        ["enUS"] = true,
        ["deDE"] = "Allerias Feste",
        ["esES"] = "Bastión Allerian",
        ["esMX"] = "Bastión Allerian",
        ["frFR"] = "Bastion allérien",
        ["koKR"] = "알레리아 성채",
        ["ptBR"] = "Fortaleza Alleriana",
        ["ruRU"] = "Бастион Аллерии",
        ["zhCN"] = "奥蕾莉亚要塞",
        ["zhTW"] = "艾蘭里堡壘",
    },
    ["Silting Shore"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlickerküste",
        ["esES"] = "La Costa de Cieno",
        ["esMX"] = "La Costa de Cieno",
        ["frFR"] = "Rivage envasé",
        ["koKR"] = "개펄 해안",
        ["ptBR"] = "Baía do Limo",
        ["ruRU"] = "Илистый Берег",
        ["zhCN"] = "淤泥海岸",
        ["zhTW"] = "淤塞海岸",
    },
    ["Commons Hall"] = {
        ["enUS"] = true,
        ["deDE"] = "Versammlungshalle",
        ["esES"] = "Cámara del Pueblo",
        ["esMX"] = "Cámara del Pueblo",
        ["frFR"] = "Communs",
        ["koKR"] = "대강당",
        ["ptBR"] = "Câmara dos Comuns",
        ["ruRU"] = "Общий зал",
        ["zhCN"] = "平民大厅",
        ["zhTW"] = "平民大廳",
    },
    ["Churning Gulch"] = {
        ["enUS"] = true,
        ["deDE"] = "Grabenschlucht",
        ["esES"] = "Garganta Bulliciosa",
        ["esMX"] = "Garganta Bulliciosa",
        ["frFR"] = "Goulet bouillonnant",
        ["koKR"] = "휘몰이 협곡",
        ["ptBR"] = "Ravina Trêmula",
        ["ruRU"] = "Беспокойная лощина",
        ["zhCN"] = "沸土峡谷",
        ["zhTW"] = "翻騰峽谷",
    },
    ["The Violet Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Der violette Turm",
        ["esES"] = "Torre Violeta",
        ["esMX"] = "Torre Violeta",
        ["frFR"] = "La Tour pourpre",
        ["koKR"] = "자줏빛 탑",
        ["ptBR"] = "Torre Violeta",
        ["ruRU"] = "Аметистовая башня",
        ["zhCN"] = "紫罗兰之塔",
        ["zhTW"] = "紫蘿蘭之塔",
    },
    ["REUSE"] = {
        ["enUS"] = true,
        ["deDE"] = "REUSE",
        ["esES"] = "REUSE",
        ["esMX"] = "REUSE",
        ["frFR"] = "REUSE",
        ["koKR"] = "REUSE",
        ["ptBR"] = "REUSE",
        ["ruRU"] = "REUSE",
        ["zhCN"] = "REUSE",
        ["zhTW"] = "REUSE",
    },
    ["Draenethyst Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Draenethystmine",
        ["esES"] = "Mina Draenetista",
        ["esMX"] = "Mina Draenetista",
        ["frFR"] = "Mine de draenéthyste",
        ["koKR"] = "드레니시스트 광산",
        ["ptBR"] = "Mina de Draenetista",
        ["ruRU"] = "Дренетистовые копи",
        ["zhCN"] = "德拉诺晶矿",
        ["zhTW"] = "德萊尼礦坑",
    },
    ["Borune Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Borune",
        ["esES"] = "Ruinas Borune",
        ["esMX"] = "Ruinas Borune",
        ["frFR"] = "Ruines de Borune",
        ["koKR"] = "보룬 폐허",
        ["ptBR"] = "Ruínas de Borune",
        ["ruRU"] = "Руины Боруна",
        ["zhCN"] = "博鲁恩废墟",
        ["zhTW"] = "伯盧恩廢墟",
    },
    ["Elrendar Crossing"] = {
        ["enUS"] = true,
        ["deDE"] = "Elrendarkreuzung",
        ["esES"] = "Cruce Elrendar",
        ["esMX"] = "Cruce Elrendar",
        ["frFR"] = "Passage de l'Elrendar",
        ["koKR"] = "엘렌다르 건널목",
        ["ptBR"] = "Passagem de Elrendar",
        ["ruRU"] = "Мост Элрендар",
        ["zhCN"] = "艾伦达尔桥",
        ["zhTW"] = "艾蘭達路口",
    },
    ["Sunfury Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenzornposten",
        ["esES"] = "Bastión Furia del Sol",
        ["esMX"] = "Bastión Furia del Sol",
        ["frFR"] = "Bastion des Solfurie",
        ["koKR"] = "성난태양 주둔지",
        ["ptBR"] = "Acampamento Solfúria",
        ["ruRU"] = "Форт Ярости Солнца",
        ["zhCN"] = "日怒堡",
        ["zhTW"] = "日怒要塞",
    },
    ["Clan Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Klanwacht",
        ["esES"] = "Avanzada del Clan",
        ["esMX"] = "Avanzada del Clan",
        ["frFR"] = "Guet des clans",
        ["koKR"] = "부족 초소",
        ["ptBR"] = "Vila dos Clãs",
        ["ruRU"] = "Клановая Стража",
        ["zhCN"] = "氏族岗哨",
        ["zhTW"] = "氏族守望",
    },
    ["Pod Wreckage"] = {
        ["enUS"] = true,
        ["deDE"] = "Kapselwrack",
        ["esES"] = "El Cementerio de Cápsulas",
        ["esMX"] = "El Cementerio de Cápsulas",
        ["frFR"] = "Débris de capsule",
        ["koKR"] = "탈출선 잔해",
        ["ptBR"] = "Destroços do Módulo Espacial",
        ["ruRU"] = "Обломки Капсулы",
        ["zhCN"] = "残破的逃生舱",
        ["zhTW"] = "卵囊殘骸",
    },
    ["The Path of Anguish"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Pfad der Pein",
        ["esES"] = "El Camino del Tormento",
        ["esMX"] = "El Camino del Tormento",
        ["frFR"] = "Le Chemin de l'angoisse",
        ["koKR"] = "고통의 길",
        ["ptBR"] = "O Caminho da Angústia",
        ["ruRU"] = "Путь Страданий",
        ["zhCN"] = "苦痛之路",
        ["zhTW"] = "苦痛之路",
    },
    ["Razorthorn Trail"] = {
        ["enUS"] = true,
        ["deDE"] = "Messerdornpfad",
        ["esES"] = "Senda Rajaespina",
        ["esMX"] = "Senda Rajaespina",
        ["frFR"] = "Piste de Tranchépine",
        ["koKR"] = "서슬가시 고개",
        ["ptBR"] = "Trilha Espinhosa",
        ["ruRU"] = "Дорога Острого Шипа",
        ["zhCN"] = "荆刺小径",
        ["zhTW"] = "刺棘蔓",
    },
    ["Bloodscale Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Enklave der Blutschuppen",
        ["esES"] = "Enclave Escamas de Sangre",
        ["esMX"] = "Enclave Escamas de Sangre",
        ["frFR"] = "Enclave des écailles-sanglantes",
        ["koKR"] = "피비늘 군락",
        ["ptBR"] = "Enclave Sangrescama",
        ["ruRU"] = "Анклав Кровавой Чешуи",
        ["zhCN"] = "血鳞领地",
        ["zhTW"] = "血鱗營地",
    },
    ["The Heap"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Hügel",
        ["esES"] = "La Pila",
        ["esMX"] = "La Pila",
        ["frFR"] = "Le Monceau",
        ["koKR"] = "고철더미",
        ["ptBR"] = "Os Destroços",
        ["ruRU"] = "Груда",
        ["zhCN"] = "机甲废场",
        ["zhTW"] = "聚集之地",
    },
    ["Shartuul's Transporter"] = {
        ["enUS"] = true,
        ["deDE"] = "Shartuuls Transporter",
        ["esES"] = "Transportador de Shartuul",
        ["esMX"] = "Transportador de Shartuul",
        ["frFR"] = "Transporteur de Shartuul",
        ["koKR"] = "샤툴의 순간이동기",
        ["ptBR"] = "Transporte de Shartuul",
        ["ruRU"] = "Транспортер Шартуула",
        ["zhCN"] = "沙图尔的传送器",
        ["zhTW"] = "夏圖歐的傳送門",
    },
    ["Tuluman's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Tulumans Landeplatz",
        ["esES"] = "Alto de Tuluman",
        ["esMX"] = "Alto de Tuluman",
        ["frFR"] = "Point d'ancrage de Tuluman",
        ["koKR"] = "툴루맨의 정박지",
        ["ptBR"] = "Acampamento do Tuluman",
        ["ruRU"] = "Лагерь Тулумана",
        ["zhCN"] = "图鲁曼的营地",
        ["zhTW"] = "吐魯曼平臺",
    },
    ["Emberglade"] = {
        ["enUS"] = true,
        ["deDE"] = "Glutgrund",
        ["esES"] = "El Claro de Ascuas",
        ["esMX"] = "El Claro de Ascuas",
        ["frFR"] = "Clairière de braise",
        ["koKR"] = "잿불숲",
        ["ptBR"] = "Campo das Cinzas",
        ["ruRU"] = "Тлеющая поляна",
        ["zhCN"] = "灰烬林地",
        ["zhTW"] = "餘燼林地",
    },
    ["Forge Base: Oblivion"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionsbasis: Vergessenheit",
        ["esES"] = "Base Forja: Olvido",
        ["esMX"] = "Base Forja: Olvido",
        ["frFR"] = "Base de forge : Oubli",
        ["koKR"] = "망각의 괴철로 주둔지",
        ["ptBR"] = "Base-forja: Oblívio",
        ["ruRU"] = "База Легиона: Забвение",
        ["zhCN"] = "铸魔基地：湮灭",
        ["zhTW"] = "熔爐基地:遺忘",
    },
    ["Isle of Quel'Danas"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel von Quel'Danas",
        ["esES"] = "Isla de Quel'Danas",
        ["esMX"] = "Isla de Quel'Danas",
        ["frFR"] = "Île de Quel'Danas",
        ["koKR"] = "쿠엘다나스 섬",
        ["ptBR"] = "Ilha de Quel'Danas",
        ["ruRU"] = "Остров Кель'Данас",
        ["zhCN"] = "奎尔丹纳斯岛",
        ["zhTW"] = "奎爾達納斯之島",
    },
    ["Veil Harr'ik"] = {
        ["enUS"] = true,
        ["deDE"] = "Harr'ikversteck",
        ["esES"] = "Velo Harr'ik",
        ["esMX"] = "Velo Harr'ik",
        ["frFR"] = "Voile Harr'ik",
        ["koKR"] = "장막의 하리크",
        ["ptBR"] = "Véu Harr'ik",
        ["ruRU"] = "Гнездовье Харр'ик",
        ["zhCN"] = "哈雷克鸦巢",
        ["zhTW"] = "迷霧哈瑞克",
    },
    ["Manaforge Ara"] = {
        ["enUS"] = true,
        ["deDE"] = "Manaschmiede Ara",
        ["esES"] = "Forja de Maná Ara",
        ["esMX"] = "Forja de Maná Ara",
        ["frFR"] = "Manaforge Ara",
        ["koKR"] = "아라 마나괴철로",
        ["ptBR"] = "Manaforja Ara",
        ["ruRU"] = "Манагорн Ара",
        ["zhCN"] = "法力熔炉：艾拉",
        ["zhTW"] = "法力熔爐艾拉",
    },
    ["The Abyssal Shelf"] = {
        ["enUS"] = true,
        ["deDE"] = "Die abyssische Untiefe",
        ["esES"] = "La Plataforma Abisal",
        ["esMX"] = "La Plataforma Abisal",
        ["frFR"] = "La Saillie abyssale",
        ["koKR"] = "심연의 절벽",
        ["ptBR"] = "Prateleira Abissal",
        ["ruRU"] = "Косогор Бездны",
        ["zhCN"] = "地狱岩床",
        ["zhTW"] = "深淵沙洲",
    },
    ["West Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum des Westens",
        ["esES"] = "Sagrario del Oeste",
        ["esMX"] = "Sagrario del Oeste",
        ["frFR"] = "Sanctum occidental",
        ["koKR"] = "서부 성소",
        ["ptBR"] = "Sacrário do Oeste",
        ["ruRU"] = "Западное святилище",
        ["zhCN"] = "西部圣殿",
        ["zhTW"] = "西部聖所",
    },
    ["Mok'Nathal Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Dorf der Mok'Nathal",
        ["esES"] = "Aldea Mok'Nathal",
        ["esMX"] = "Aldea Mok'Nathal",
        ["frFR"] = "Mok'Nathal",
        ["koKR"] = "모크나탈 마을",
        ["ptBR"] = "Vila de Mok'nathal",
        ["ruRU"] = "Деревня Мок'Натал",
        ["zhCN"] = "莫克纳萨村",
        ["zhTW"] = "摩克納薩爾村",
    },
    ["Raven's Wood"] = {
        ["enUS"] = true,
        ["deDE"] = "Rabenwald",
        ["esES"] = "Bosque del Cuervo",
        ["esMX"] = "Bosque del Cuervo",
        ["frFR"] = "Bois aux corbeaux",
        ["koKR"] = "까마귀 숲",
        ["ptBR"] = "Mata do Corvo",
        ["ruRU"] = "Лес Ворона",
        ["zhCN"] = "乌鸦林",
        ["zhTW"] = "烏鴉林",
    },
    ["Crash Site"] = {
        ["enUS"] = true,
        ["deDE"] = "Absturzstelle",
        ["esES"] = "Lugar del Accidente",
        ["esMX"] = "Lugar del Accidente",
        ["frFR"] = "Point d'impact",
        ["koKR"] = "추락 지점",
        ["ptBR"] = "Ponto de Impacto",
        ["ruRU"] = "Место крушения",
        ["zhCN"] = "坠毁点",
        ["zhTW"] = "失事地點",
    },
    ["Eco-Dome Skyperch"] = {
        ["enUS"] = true,
        ["deDE"] = "Biokuppel Himmelssitz",
        ["esES"] = "Ecodomo Altocielo",
        ["esMX"] = "Ecodomo Altocielo",
        ["frFR"] = "Écodôme Percheciel",
        ["koKR"] = "하늘마루 생태지구",
        ["ptBR"] = "Eco-domo Pouso do Céu",
        ["ruRU"] = "Заповедник \"Высь\"",
        ["zhCN"] = "高空生态圆顶",
        ["zhTW"] = "秘境棲木",
    },
    ["Bloodmaul Ravine"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutschlägerklamm",
        ["esES"] = "Barranco Machacasangre",
        ["esMX"] = "Barranco Machacasangre",
        ["frFR"] = "Ravin de la Masse-sanglante",
        ["koKR"] = "피망치 협곡",
        ["ptBR"] = "Barranco Malho Sangrento",
        ["ruRU"] = "Лощина Кровавого Молота",
        ["zhCN"] = "血槌峡谷",
        ["zhTW"] = "血槌深谷",
    },
    ["Spinebreaker Mountains"] = {
        ["enUS"] = true,
        ["deDE"] = "Rückenbrecherberge",
        ["esES"] = "Montañas Rompeloma",
        ["esMX"] = "Montañas Rompeloma",
        ["frFR"] = "Montagnes Brise-échine",
        ["koKR"] = "해골망치 산맥",
        ["ptBR"] = "Montanhas Quebra-espinha",
        ["ruRU"] = "Горы Хребтолома",
        ["zhCN"] = "断背山",
        ["zhTW"] = "斷脊氏族山脈",
    },
    ["Blood Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutwacht",
        ["esES"] = "Avanzada de Sangre",
        ["esMX"] = "Avanzada de Sangre",
        ["frFR"] = "Guet du sang",
        ["koKR"] = "핏빛 감시초소",
        ["ptBR"] = "Entreposto Rubro",
        ["ruRU"] = "Кровавая застава",
        ["zhCN"] = "秘血岗哨",
        ["zhTW"] = "血色守望",
    },
    ["Bladespire Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Wehr der Speerspießer",
        ["esES"] = "Bastión Aguja del Filo",
        ["esMX"] = "Bastión Aguja del Filo",
        ["frFR"] = "Bastion de Flèchelame",
        ["koKR"] = "칼날첨탑 요새",
        ["ptBR"] = "Bastião Giralança",
        ["ruRU"] = "Форт Камнерогов",
        ["zhCN"] = "刀塔要塞",
        ["zhTW"] = "劍刃要塞",
    },
    ["Protectorate Watch Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Wachposten des Protektorats",
        ["esES"] = "Avanzada del Protectorado",
        ["esMX"] = "Avanzada del Protectorado",
        ["frFR"] = "Poste de garde du Protectorat",
        ["koKR"] = "자유연합 경비초소",
        ["ptBR"] = "Posto de Guarda do Protetorado",
        ["ruRU"] = "Застава Стражей Протектората",
        ["zhCN"] = "维序派哨站",
        ["zhTW"] = "護國者哨站",
    },
    ["Ridge of Madness"] = {
        ["enUS"] = true,
        ["deDE"] = "Grat des Wahnsinns",
        ["esES"] = "Cresta de la Locura",
        ["esMX"] = "Cresta de la Locura",
        ["frFR"] = "Crête de la folie",
        ["koKR"] = "광기의 마루",
        ["ptBR"] = "Pico da Loucura",
        ["ruRU"] = "Гряда Безумия",
        ["zhCN"] = "疯狂之脊",
        ["zhTW"] = "瘋狂山脊",
    },
    ["Boha'mu Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Boha'mu",
        ["esES"] = "Ruinas Boha'mu",
        ["esMX"] = "Ruinas Boha'mu",
        ["frFR"] = "Ruines de Boha'mu",
        ["koKR"] = "보하무 폐허",
        ["ptBR"] = "Ruínas de Boha'mu",
        ["ruRU"] = "Руины Боха'му",
        ["zhCN"] = "博哈姆废墟",
        ["zhTW"] = "波哈姆廢墟",
    },
    ["Bloodmaul Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten der Blutschläger",
        ["esES"] = "Avanzada Machacasangre",
        ["esMX"] = "Avanzada Machacasangre",
        ["frFR"] = "Avant-poste de la Masse-sanglante",
        ["koKR"] = "피망치 전초기지",
        ["ptBR"] = "Posto Avançado Malho Sangrento",
        ["ruRU"] = "Застава Кровавого Молота",
        ["zhCN"] = "血槌哨站",
        ["zhTW"] = "血槌前哨站",
    },
    ["Razor Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Messergrat",
        ["esES"] = "Loma Tajo",
        ["esMX"] = "Loma Tajo",
        ["frFR"] = "Tranchecrête",
        ["koKR"] = "칼날 마루",
        ["ptBR"] = "Espinhaço Cortante",
        ["ruRU"] = "Островерхий гребень",
        ["zhCN"] = "剃刀山",
        ["zhTW"] = "剃刀山脊",
    },
    ["Quagg Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Quaggkamm",
        ["esES"] = "Cresta Quagg",
        ["esMX"] = "Cresta Quagg",
        ["frFR"] = "Crête des boues",
        ["koKR"] = "쿠아그 마루",
        ["ptBR"] = "Serra Quagg",
        ["ruRU"] = "Гряда Квагг",
        ["zhCN"] = "泥泞山",
        ["zhTW"] = "跨格山脊",
    },
    ["Cosmowrench"] = {
        ["enUS"] = true,
        ["deDE"] = "Kosmozang",
        ["esES"] = "Cosmotirón",
        ["esMX"] = "Cosmotirón",
        ["frFR"] = "Cosmovrille",
        ["koKR"] = "코스모렌치",
        ["ptBR"] = "Chave do Cosmos",
        ["ruRU"] = "Космоворот",
        ["zhCN"] = "扳钳镇",
        ["zhTW"] = "扭曲太空",
    },
    ["Vortex Pinnacle"] = {
        ["enUS"] = true,
        ["deDE"] = "Vortexgipfel",
        ["esES"] = "Cumbre del Vórtice",
        ["esMX"] = "Cumbre del Vórtice",
        ["frFR"] = "Cime du vortex",
        ["koKR"] = "소용돌이 고원",
        ["ptBR"] = "Pináculo do Vórtice",
        ["ruRU"] = "Вершина Смерча",
        ["zhCN"] = "漩涡峰",
        ["zhTW"] = "漩渦尖塔",
    },
    ["Death's Door"] = {
        ["enUS"] = true,
        ["deDE"] = "Schwelle des Todes",
        ["esES"] = "Puerta de la Muerte",
        ["esMX"] = "Puerta de la Muerte",
        ["frFR"] = "Porte de la mort",
        ["koKR"] = "죽음의 문",
        ["ptBR"] = "Porta da Morte",
        ["ruRU"] = "Врата Смерти",
        ["zhCN"] = "死亡之门",
        ["zhTW"] = "死亡之門",
    },
    ["Silvermoon's Pride"] = {
        ["enUS"] = true,
        ["deDE"] = "Silbermonds Stolz",
        ["esES"] = "Orgullo de Lunargenta",
        ["esMX"] = "Orgullo de Lunargenta",
        ["frFR"] = "La Fierté de Lune-d'argent",
        ["koKR"] = "실버문의 긍지호",
        ["ptBR"] = "Orgulho de Luaprata",
        ["ruRU"] = "Гордость Луносвета",
        ["zhCN"] = "银月之傲",
        ["zhTW"] = "銀月之驕",
    },
    ["The Fel Pits"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Teufelsgruben",
        ["esES"] = "Las Fosas Viles",
        ["esMX"] = "Las Fosas Viles",
        ["frFR"] = "Les Gangrefosses",
        ["koKR"] = "지옥의 구덩이",
        ["ptBR"] = "Poços Fétidos",
        ["ruRU"] = "Ямы Скверны",
        ["zhCN"] = "魔能熔池",
        ["zhTW"] = "惡魔深淵",
    },
    ["Laughing Skull Courtyard"] = {
        ["enUS"] = true,
        ["deDE"] = "Hof des Lachenden Schädels",
        ["esES"] = "Patio Riecráneos",
        ["esMX"] = "Patio Riecráneos",
        ["frFR"] = "Cour du Crâne ricanant",
        ["koKR"] = "웃는 해골 광장",
        ["ptBR"] = "Pátio Gargaveira",
        ["ruRU"] = "Внутренний двор Веселого Черепа",
        ["zhCN"] = "嘲颅营地",
        ["zhTW"] = "獰笑骷髏庭院",
    },
    ["Veil Ruuan"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruuanversteck",
        ["esES"] = "Velo Ruuan",
        ["esMX"] = "Velo Ruuan",
        ["frFR"] = "Voile Ruuan",
        ["koKR"] = "장막의 루안",
        ["ptBR"] = "Véu Ruuan",
        ["ruRU"] = "Гнездовье Рууан",
        ["zhCN"] = "卢安鸦巢",
        ["zhTW"] = "迷霧魯安",
    },
    ["Misty Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Nebelpass",
        ["esES"] = "Cresta Brumosa",
        ["esMX"] = "Cresta Brumosa",
        ["frFR"] = "Crête brumeuse",
        ["koKR"] = "안개 마루",
        ["ptBR"] = "Pico da Neblina",
        ["ruRU"] = "Туманная гряда",
        ["zhCN"] = "薄雾山",
        ["zhTW"] = "多霧山脊",
    },
    ["The Crimson Reach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Purpurbrandung",
        ["esES"] = "El Tramo Carmesí",
        ["esMX"] = "El Tramo Carmesí",
        ["frFR"] = "Les confins cramoisis",
        ["koKR"] = "진홍 해안",
        ["ptBR"] = "Rincão Rubro",
        ["ruRU"] = "Кровавый берег",
        ["zhCN"] = "红砂海滩",
        ["zhTW"] = "赤紅地帶",
    },
    ["Ruuan Weald"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruuanwald",
        ["esES"] = "Foresta de Ruuan",
        ["esMX"] = "Foresta Ruuan",
        ["frFR"] = "Sylve Ruuan",
        ["koKR"] = "루안 숲",
        ["ptBR"] = "Bosque Ruuan",
        ["ruRU"] = "Чащоба Рууан",
        ["zhCN"] = "卢安荒野",
        ["zhTW"] = "魯安曠野",
    },
    ["Daggermaw Canyon"] = {
        ["enUS"] = true,
        ["deDE"] = "Dolchrachenklamm",
        ["esES"] = "Cañón Faucedaga",
        ["esMX"] = "Cañón Faucedaga",
        ["frFR"] = "Canyon des Crocs-lames",
        ["koKR"] = "비수아귀 협곡",
        ["ptBR"] = "Garganta Gorjadaga",
        ["ruRU"] = "Каньон Кинжальной Пасти",
        ["zhCN"] = "刃喉谷",
        ["zhTW"] = "匕爪峽谷",
    },
    ["Telredor"] = {
        ["enUS"] = true,
        ["deDE"] = "Telredor",
        ["esES"] = "Telredor",
        ["esMX"] = "Telredor",
        ["frFR"] = "Telredor",
        ["koKR"] = "텔레도르",
        ["ptBR"] = "Telredor",
        ["ruRU"] = "Телредор",
        ["zhCN"] = "泰雷多尔",
        ["zhTW"] = "泰倫多爾",
    },
    ["Abandoned Armory"] = {
        ["enUS"] = true,
        ["deDE"] = "Verlassenes Rüstlager",
        ["esES"] = "Armería Abandonada",
        ["esMX"] = "Armería Abandonada",
        ["frFR"] = "Armurerie abandonnée",
        ["koKR"] = "버려진 무기고",
        ["ptBR"] = "Armaria Abandonada",
        ["ruRU"] = "Заброшенная оружейная",
        ["zhCN"] = "废弃的军械库",
        ["zhTW"] = "被遺棄的軍械庫",
    },
    ["Shamanar"] = {
        ["enUS"] = true,
        ["deDE"] = "Shamanar",
        ["esES"] = "Shamanar",
        ["esMX"] = "Shamanar",
        ["frFR"] = "Shamanar",
        ["koKR"] = "샤마나르",
        ["ptBR"] = "Shamanar",
        ["ruRU"] = "Шаманар",
        ["zhCN"] = "萨满纳尔",
        ["zhTW"] = "夏瑪那",
    },
    ["Eclipse Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Stätte der Mondfinsternis",
        ["esES"] = "Punta Eclipse",
        ["esMX"] = "Punta Eclipse",
        ["frFR"] = "Halte de l'éclipse",
        ["koKR"] = "해그늘 주둔지",
        ["ptBR"] = "Ponta do Eclipse",
        ["ruRU"] = "Лагерь Затмения",
        ["zhCN"] = "日蚀岗哨",
        ["zhTW"] = "日蝕崗哨",
    },
    ["Warden's Cage"] = {
        ["enUS"] = true,
        ["deDE"] = "Kerker des Wächters",
        ["esES"] = "Jaula de la Guardiana",
        ["esMX"] = "Jaula de la Guardiana",
        ["frFR"] = "La Cage de la gardienne",
        ["koKR"] = "감시자의 수용소",
        ["ptBR"] = "Jaula do Carcereiro",
        ["ruRU"] = "Клеть Стражницы",
        ["zhCN"] = "守望者牢笼",
        ["zhTW"] = "典獄官監牢",
    },
    ["Shattered Sun Staging Area"] = {
        ["enUS"] = true,
        ["deDE"] = "Sammelpunkt der Zerschmetterten Sonne",
        ["esES"] = "Zona de escala de Sol Devastado",
        ["esMX"] = "Zona de Escala de Sol Devastado",
        ["frFR"] = "Zone de rassemblement du Soleil brisé",
        ["koKR"] = "무너진 태양 집결지",
        ["ptBR"] = "Bivaque Sol Partido",
        ["ruRU"] = "Подготовительный плацдарм Расколотого Солнца",
        ["zhCN"] = "破碎残阳基地",
        ["zhTW"] = "破碎之日會所",
    },
    ["Bloodscale Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutschuppengrund",
        ["esES"] = "Tierras Escamas de Sangre",
        ["esMX"] = "Tierras Escamas de Sangre",
        ["frFR"] = "Terres des écailles-sanglantes",
        ["koKR"] = "피비늘 영토",
        ["ptBR"] = "Terras dos Sangrescamas",
        ["ruRU"] = "Земли Кровавой Чешуи",
        ["zhCN"] = "血鳞浅滩",
        ["zhTW"] = "血鱗營地",
    },
    ["East Supply Caravan"] = {
        ["enUS"] = true,
        ["deDE"] = "Östliche Versorgungskarawane",
        ["esES"] = "Caravana de Provisiones del Este",
        ["esMX"] = "Caravana de Provisiones del Este",
        ["frFR"] = "Caravane de ravitaillement de l'est",
        ["koKR"] = "동쪽 보급 짐마차",
        ["ptBR"] = "Caravana Oriental de Suprimentos",
        ["ruRU"] = "Восточный караван",
        ["zhCN"] = "东补给车队",
        ["zhTW"] = "東部補給營地",
    },
    ["The Warp Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sphärenfelder",
        ["esES"] = "Los Campos Alabeados",
        ["esMX"] = "Los Campos Alabeados",
        ["frFR"] = "Les champs de distorsion",
        ["koKR"] = "일그러진 벌판",
        ["ptBR"] = "Campos Dimensionais",
        ["ruRU"] = "Искривленные поля",
        ["zhCN"] = "迁跃平原",
        ["zhTW"] = "扭曲原野",
    },
    ["Bladewood"] = {
        ["enUS"] = true,
        ["deDE"] = "Messerwinkel",
        ["esES"] = "Bosquespada",
        ["esMX"] = "Bosquespada",
        ["frFR"] = "Bois des Lames",
        ["koKR"] = "칼날숲",
        ["ptBR"] = "Mata Cortante",
        ["ruRU"] = "Лес Клинков",
        ["zhCN"] = "刀林",
        ["zhTW"] = "劍木林",
    },
    ["Spinebreaker Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Rückenbrecherpass",
        ["esES"] = "Desfiladero Rompeloma",
        ["esMX"] = "Desfiladero Rompeloma",
        ["frFR"] = "Passage des Brise-échine",
        ["koKR"] = "해골망치 고개",
        ["ptBR"] = "Desfiladeiro Quebra-espinha",
        ["ruRU"] = "Перевал Хребтолома",
        ["zhCN"] = "断背小径",
        ["zhTW"] = "斷脊氏族小徑",
    },
    ["Veil Shienor"] = {
        ["enUS"] = true,
        ["deDE"] = "Shienorversteck",
        ["esES"] = "Velo Shienor",
        ["esMX"] = "Velo Shienor",
        ["frFR"] = "Voile Shienor",
        ["koKR"] = "장막의 쉬에노르",
        ["ptBR"] = "Véu Shienor",
        ["ruRU"] = "Гнездовье Шиенор",
        ["zhCN"] = "西诺鸦巢",
        ["zhTW"] = "迷霧辛諾",
    },
    ["Sunstrider Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel der Sonnenwanderer",
        ["esES"] = "Isla del Caminante del Sol",
        ["esMX"] = "Isla del Caminante del Sol",
        ["frFR"] = "Ile de Haut-soleil",
        ["koKR"] = "선스트라이더 섬",
        ["ptBR"] = "Ilha Andassol",
        ["ruRU"] = "Остров Солнечного Скитальца",
        ["zhCN"] = "逐日岛",
        ["zhTW"] = "逐日者之島",
    },
    ["Twin Spire Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen der Zwillingsspitze",
        ["esES"] = "Ruinas de las Agujas Gemelas",
        ["esMX"] = "Ruinas de las Agujas Gemelas",
        ["frFR"] = "Ruines des flèches jumelles",
        ["koKR"] = "쌍둥이 첨탑 폐허",
        ["ptBR"] = "Ruínas das Agulhas Gêmeas",
        ["ruRU"] = "Руины Двух Башен",
        ["zhCN"] = "双塔废墟",
        ["zhTW"] = "雙塔廢墟",
    },
    ["Northern Rampart"] = {
        ["enUS"] = true,
        ["deDE"] = "Nördliches Bollwerk",
        ["esES"] = "Muralla Norte",
        ["esMX"] = "Muralla Norte",
        ["frFR"] = "Rempart du nord",
        ["koKR"] = "북쪽 성루",
        ["ptBR"] = "Muralha do Norte",
        ["ruRU"] = "Северный бастион",
        ["zhCN"] = "北部城墙",
        ["zhTW"] = "北方堡壘",
    },
    ["Southern Rampart"] = {
        ["enUS"] = true,
        ["deDE"] = "Südliches Bollwerk",
        ["esES"] = "Muralla Sur",
        ["esMX"] = "Muralla Sur",
        ["frFR"] = "Rempart du sud",
        ["koKR"] = "남쪽 성루",
        ["ptBR"] = "Muralha do Sul",
        ["ruRU"] = "Южный бастион",
        ["zhCN"] = "南部城墙",
        ["zhTW"] = "南方堡壘",
    },
    ["Forge Camp: Hate"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Hass",
        ["esES"] = "Campamento Forja: Odio",
        ["esMX"] = "Campamento Forja: Odio",
        ["frFR"] = "Camp de forge : Haine",
        ["koKR"] = "증오의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Ódio",
        ["ruRU"] = "Лагерь Легиона: Ненависть",
        ["zhCN"] = "铸魔营地：仇恨",
        ["zhTW"] = "煉冶場:仇恨",
    },
    ["Cenarion Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Posten des Cenarius",
        ["esES"] = "Puesto Cenarion",
        ["esMX"] = "Puesto Cenarion",
        ["frFR"] = "Poste cénarien",
        ["koKR"] = "세나리온 초소",
        ["ptBR"] = "Posto Cenariano",
        ["ruRU"] = "Кенарийская застава",
        ["zhCN"] = "塞纳里奥哨站",
        ["zhTW"] = "塞納里奧前哨",
    },
    ["Ango'rosh Stronghold"] = {
        ["enUS"] = true,
        ["deDE"] = "Festung der Ango'rosh",
        ["esES"] = "Bastión Ango'rosh",
        ["esMX"] = "Bastión Ango'rosh",
        ["frFR"] = "Bastion Ango'rosh",
        ["koKR"] = "앙고로쉬 소굴",
        ["ptBR"] = "Fortaleza Ango'rosh",
        ["ruRU"] = "Крепость Анго'рош",
        ["zhCN"] = "安葛洛什要塞",
        ["zhTW"] = "安格拉斯要塞",
    },
    ["Pools of Aggonar"] = {
        ["enUS"] = true,
        ["deDE"] = "Teiche von Aggonar",
        ["esES"] = "Pozas de Aggonar",
        ["esMX"] = "Pozas de Aggonar",
        ["frFR"] = "Bassins d'Aggonar",
        ["koKR"] = "아고나르의 웅덩이",
        ["ptBR"] = "Poços de Aggonar",
        ["ruRU"] = "Пруды Аггонара",
        ["zhCN"] = "阿苟纳之池",
        ["zhTW"] = "阿葛納爾之池",
    },
    ["Jagged Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Zackengrat",
        ["esES"] = "Cresta Dentada",
        ["esMX"] = "Cresta Dentada",
        ["frFR"] = "La crête dentelée",
        ["koKR"] = "뾰족 마루",
        ["ptBR"] = "Serra dos Espigões",
        ["ruRU"] = "Зазубренная гряда",
        ["zhCN"] = "锯齿山",
        ["zhTW"] = "鋸齒山脊",
    },
    ["Ancestral Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Ahnengrund",
        ["esES"] = "Tierras Ancestrales",
        ["esMX"] = "Tierras Ancestrales",
        ["frFR"] = "Terres ancestrales",
        ["koKR"] = "선조의 터",
        ["ptBR"] = "Terras Ancestrais",
        ["ruRU"] = "Земли Предков",
        ["zhCN"] = "先祖之地",
        ["zhTW"] = "先祖之地",
    },
    ["The Stair of Doom"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Stufen der Verdammnis",
        ["esES"] = "La Escalera Maldita",
        ["esMX"] = "La Escalera Maldita",
        ["frFR"] = "L'escalier de la Fatalité",
        ["koKR"] = "파멸의 계단",
        ["ptBR"] = "Degraus da Perdição",
        ["ruRU"] = "Ступени Фатума",
        ["zhCN"] = "末日阶梯",
        ["zhTW"] = "厄運階梯",
    },
    ["The Hand of Gul'dan"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Hand von Gul'dan",
        ["esES"] = "La Mano de Gul'dan",
        ["esMX"] = "La Mano de Gul'dan",
        ["frFR"] = "La main de Gul'dan",
        ["koKR"] = "굴단의 손아귀",
        ["ptBR"] = "A Mão de Gul'dan",
        ["ruRU"] = "Рука Гул'дана",
        ["zhCN"] = "古尔丹之手",
        ["zhTW"] = "古爾丹火山",
    },
    ["Sun's Reach Harbor"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen der Sonnenweiten",
        ["esES"] = "Puerto de Tramo del Sol",
        ["esMX"] = "Puerto de Tramo del Sol",
        ["frFR"] = "Port des Confins du soleil",
        ["koKR"] = "태양너울 항구",
        ["ptBR"] = "Porto de Beirassol",
        ["ruRU"] = "Гавань Солнечного Края",
        ["zhCN"] = "阳湾港口",
        ["zhTW"] = "日境港",
    },
    ["Sha'tari Base Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Basislager der Sha'tari",
        ["esES"] = "Campamento Sha'tari",
        ["esMX"] = "Campamento Sha'tari",
        ["frFR"] = "Camp de base sha'tari",
        ["koKR"] = "샤타리 주둔지",
        ["ptBR"] = "Acampamento Sha'tari",
        ["ruRU"] = "Лагерь Ша'тар",
        ["zhCN"] = "沙塔尔营地",
        ["zhTW"] = "薩塔營地",
    },
    ["Suncrown Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenkuppe",
        ["esES"] = "Aldea Corona del Sol",
        ["esMX"] = "Aldea Corona del Sol",
        ["frFR"] = "Solcouronne",
        ["koKR"] = "태양왕관 마을",
        ["ptBR"] = "Vila Corona Solar",
        ["ruRU"] = "Деревня Солнечной Короны",
        ["zhCN"] = "日冕村",
        ["zhTW"] = "日冠村",
    },
    ["The Exodar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Exodar",
        ["esES"] = "El Exodar",
        ["esMX"] = "El Exodar",
        ["frFR"] = "L'Exodar",
        ["koKR"] = "엑소다르",
        ["ptBR"] = "Exodar",
        ["ruRU"] = "Экзодар",
        ["zhCN"] = "埃索达",
        ["zhTW"] = "艾克索達",
    },
    ["Razaan's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Razaans Landeplatz",
        ["esES"] = "Zona de Aterrizaje Razaan",
        ["esMX"] = "Zona de Aterrizaje Razaan",
        ["frFR"] = "Point d'ancrage de Razaan",
        ["koKR"] = "라잔의 영지",
        ["ptBR"] = "Campo de Razaan",
        ["ruRU"] = "Лагерь Разаана",
        ["zhCN"] = "拉扎安码头",
        ["zhTW"] = "雷森平台",
    },
    ["Cenarion Refuge"] = {
        ["enUS"] = true,
        ["deDE"] = "Zuflucht des Cenarius",
        ["esES"] = "Refugio Cenarion",
        ["esMX"] = "Refugio Cenarion",
        ["frFR"] = "Refuge cénarien",
        ["koKR"] = "세나리온 야영지",
        ["ptBR"] = "Refúgio Cenariano",
        ["ruRU"] = "Кенарийский приют",
        ["zhCN"] = "塞纳里奥庇护所",
        ["zhTW"] = "塞納里奧避難所",
    },
    ["Silverline Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Silberwellensee",
        ["esES"] = "Lago Lineargenta",
        ["esMX"] = "Lago Lineargenta",
        ["frFR"] = "Lac Rivargent",
        ["koKR"] = "희망의 호수",
        ["ptBR"] = "Lago da Linha Prateada",
        ["ruRU"] = "Серебристое озеро",
        ["zhCN"] = "银链湖",
        ["zhTW"] = "銀線湖",
    },
    ["The Foul Pool"] = {
        ["enUS"] = true,
        ["deDE"] = "Der besudelte Teich",
        ["esES"] = "La Poza del Hediondo",
        ["esMX"] = "La Poza del Hediondo",
        ["frFR"] = "Le bassin souillé",
        ["koKR"] = "타락의 웅덩이",
        ["ptBR"] = "O Lago Pútrido",
        ["ruRU"] = "Смрадный пруд",
        ["zhCN"] = "污淤之池",
        ["zhTW"] = "邪惡池塘",
    },
    ["Ata'mal Terrace"] = {
        ["enUS"] = true,
        ["deDE"] = "Terrasse von Ata'mal",
        ["esES"] = "Bancal de Ata'mal",
        ["esMX"] = "Bancal de Ata'mal",
        ["frFR"] = "Terrasse Ata'mal",
        ["koKR"] = "아타말 언덕",
        ["ptBR"] = "Terraço de Ata'mal",
        ["ruRU"] = "Терраса Ата'мала",
        ["zhCN"] = "阿塔玛平台",
        ["zhTW"] = "阿塔莫露臺",
    },
    ["Marshlight Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Sumpflichtsee",
        ["esES"] = "Lago Luz Pantanosa",
        ["esMX"] = "Lago Luz Pantanosa",
        ["frFR"] = "Lac des furoles",
        ["koKR"] = "수렁등불 호수",
        ["ptBR"] = "Lago Pantanoso",
        ["ruRU"] = "Озеро Болотных Огоньков",
        ["zhCN"] = "沼光湖",
        ["zhTW"] = "沼澤光之湖",
    },
    ["Tranquillien"] = {
        ["enUS"] = true,
        ["deDE"] = "Tristessa",
        ["esES"] = "Tranquillien",
        ["esMX"] = "Tranquillien",
        ["frFR"] = "Tranquillien",
        ["koKR"] = "트랜퀼리엔",
        ["ptBR"] = "Tranquillien",
        ["ruRU"] = "Транквиллион",
        ["zhCN"] = "塔奎林",
        ["zhTW"] = "安寧地",
    },
    ["Thrallmar"] = {
        ["enUS"] = true,
        ["deDE"] = "Thrallmar",
        ["esES"] = "Thrallmar",
        ["esMX"] = "Thrallmar",
        ["frFR"] = "Thrallmar",
        ["koKR"] = "스랄마",
        ["ptBR"] = "Thrallmar",
        ["ruRU"] = "Траллмар",
        ["zhCN"] = "萨尔玛",
        ["zhTW"] = "索爾瑪",
    },
    ["Throne of Kil'jaeden"] = {
        ["enUS"] = true,
        ["deDE"] = "Kil'jaedens Thron",
        ["esES"] = "Trono de Kil'Jaeden",
        ["esMX"] = "Trono de Kil'jaeden",
        ["frFR"] = "Trône de Kil'jaeden",
        ["koKR"] = "킬제덴의 옥좌",
        ["ptBR"] = "Trono de Kil'jaeden",
        ["ruRU"] = "Трон Кил'джедена",
        ["zhCN"] = "基尔加丹王座",
        ["zhTW"] = "基爾加丹王座",
    },
    ["Trelleum Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Trelleummine",
        ["esES"] = "Mina Trelleum",
        ["esMX"] = "Mina Trelleum",
        ["frFR"] = "Mine de Trelleum",
        ["koKR"] = "트렐리움 광산",
        ["ptBR"] = "Mina Trelleum",
        ["ruRU"] = "Рудник Треллеума",
        ["zhCN"] = "特雷卢姆矿井",
        ["zhTW"] = "崔爾曼礦坑",
    },
    ["Valley of Bones"] = {
        ["enUS"] = true,
        ["deDE"] = "Tal der Knochen",
        ["esES"] = "Valle de los Huesos",
        ["esMX"] = "Valle de los Huesos",
        ["frFR"] = "Vallée des ossements",
        ["koKR"] = "뼈의 골짜기",
        ["ptBR"] = "Vale dos Ossos",
        ["ruRU"] = "Долина Костей",
        ["zhCN"] = "白骨之谷",
        ["zhTW"] = "白骨之谷",
    },
    ["Shattrath City"] = {
        ["enUS"] = true,
        ["deDE"] = "Shattrath",
        ["esES"] = "Ciudad de Shattrath",
        ["esMX"] = "Ciudad de Shattrath",
        ["frFR"] = "Shattrath",
        ["koKR"] = "샤트라스",
        ["ptBR"] = "Shattrath",
        ["ruRU"] = "Шаттрат",
        ["zhCN"] = "沙塔斯城",
        ["zhTW"] = "撒塔斯城",
    },
    ["The Ring of Trials"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Prüfung",
        ["esES"] = "El Círculo de los Retos",
        ["esMX"] = "El Círculo de los Retos",
        ["frFR"] = "L'arène des épreuves",
        ["koKR"] = "시험의 투기장",
        ["ptBR"] = "Ringue da Provação",
        ["ruRU"] = "Круг Испытаний",
        ["zhCN"] = "试炼竞技场",
        ["zhTW"] = "試煉競技場",
    },
    ["The Vector Coil"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Vektorspule",
        ["esES"] = "La Espiral Vectorial",
        ["esMX"] = "La Espiral Vectorial",
        ["frFR"] = "La bobine vectorielle",
        ["koKR"] = "벡터 코일",
        ["ptBR"] = "Espiral Vetorial",
        ["ruRU"] = "Энергоблок",
        ["zhCN"] = "矢量感应器",
        ["zhTW"] = "旋繞導航器",
    },
    ["Funggor Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Funggorhöhle",
        ["esES"] = "Caverna Funggor",
        ["esMX"] = "Caverna Funggor",
        ["frFR"] = "Caverne de Funggor",
        ["koKR"] = "버섯 동굴",
        ["ptBR"] = "Caverna Fungor",
        ["ruRU"] = "Пещера Грибгор",
        ["zhCN"] = "蘑菇洞",
        ["zhTW"] = "方格洞穴",
    },
    ["Unused2"] = {
        ["enUS"] = true,
        ["deDE"] = "Unused2",
        ["esES"] = "Unused2",
        ["esMX"] = "Unused2",
        ["frFR"] = "Unused2",
        ["koKR"] = "Unused2",
        ["ptBR"] = "Unused2",
        ["ruRU"] = "Unused2",
        ["zhCN"] = "Unused2",
        ["zhTW"] = "Unused2",
    },
    ["Nesingwary Safari"] = {
        ["enUS"] = true,
        ["deDE"] = "Nesingwarys Safari",
        ["esES"] = "Safari Nesingwary",
        ["esMX"] = "Safari Nesingwary",
        ["frFR"] = "Safari de Nesingwary",
        ["koKR"] = "네싱워리 탐험대",
        ["ptBR"] = "Safári Rosarães",
        ["ruRU"] = "Охотничий лагерь Эрнестуэя",
        ["zhCN"] = "奈辛瓦里狩猎队营地",
        ["zhTW"] = "奈辛瓦里狩獵隊",
    },
    ["Legion Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Feste der Legion",
        ["esES"] = "Bastión de la Legión",
        ["esMX"] = "Bastión de la Legión",
        ["frFR"] = "Bastion de la Légion",
        ["koKR"] = "불타는 군단 요새",
        ["ptBR"] = "Cidadela da Legião",
        ["ruRU"] = "Форт Легиона",
        ["zhCN"] = "军团要塞",
        ["zhTW"] = "軍團要塞",
    },
    ["Dragonmaw Base Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Basislager des Drachenmals",
        ["esES"] = "Campamento Faucedraco",
        ["esMX"] = "Campamento Faucedraco",
        ["frFR"] = "Campement des Gueules-de-dragon",
        ["koKR"] = "용아귀 주둔지",
        ["ptBR"] = "Campo-base Presa do Dragão",
        ["ruRU"] = "Лагерь Драконьей Пасти",
        ["zhCN"] = "龙喉营地",
        ["zhTW"] = "龍喉營地",
    },
    ["Illidari Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Stätte der Illidari",
        ["esES"] = "Alto Illidari",
        ["esMX"] = "Alto Illidari",
        ["frFR"] = "Halte Illidari",
        ["koKR"] = "일리다리 거점",
        ["ptBR"] = "Pontal Illidari",
        ["ruRU"] = "Аванпост иллидари",
        ["zhCN"] = "伊利达雷岗哨",
        ["zhTW"] = "伊利達瑞崗哨",
    },
    ["Cenarion Thicket"] = {
        ["enUS"] = true,
        ["deDE"] = "Cenariusdickicht",
        ["esES"] = "Matorral Cenarion",
        ["esMX"] = "Matorral Cenarion",
        ["frFR"] = "Fourré cénarien",
        ["koKR"] = "세나리온 수풀",
        ["ptBR"] = "Mata Cenariana",
        ["ruRU"] = "Перелесок Кенария",
        ["zhCN"] = "塞纳里奥树林",
        ["zhTW"] = "塞納里奧灌木林",
    },
    ["The Dawning Square"] = {
        ["enUS"] = true,
        ["deDE"] = "Platz der Morgenröte",
        ["esES"] = "La Plaza Crepuscular",
        ["esMX"] = "La Plaza Crepuscular",
        ["frFR"] = "Place du Point-du-jour",
        ["koKR"] = "새벽 광장",
        ["ptBR"] = "Praça da Aurora",
        ["ruRU"] = "Рассветная площадь",
        ["zhCN"] = "黎明广场",
        ["zhTW"] = "曙光廣場",
    },
    ["Cursed Hollow"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfluchtes Dunkel",
        ["esES"] = "Hoya Maldita",
        ["esMX"] = "Hoya Maldita",
        ["frFR"] = "Creux maudit",
        ["koKR"] = "저주받은 골짜기",
        ["ptBR"] = "Clareira Maldita",
        ["ruRU"] = "Окаянная лощина",
        ["zhCN"] = "诅咒洞窟",
        ["zhTW"] = "詛咒之谷",
    },
    ["Greengill Coast"] = {
        ["enUS"] = true,
        ["deDE"] = "Küste der Grünkiemen",
        ["esES"] = "Costa Branquia Verde",
        ["esMX"] = "Costa Branquia Verde",
        ["frFR"] = "Côte de Verte-branchie",
        ["koKR"] = "초록아가미 해안",
        ["ptBR"] = "Costa Guelraverde",
        ["ruRU"] = "Берег Зеленожабрых",
        ["zhCN"] = "绿鳃海岸",
        ["zhTW"] = "綠鰓海岸",
    },
    ["Warmaul Hill"] = {
        ["enUS"] = true,
        ["deDE"] = "Totschlägerhügel",
        ["esES"] = "Colina Mazo de Guerra",
        ["esMX"] = "Colina Mazo de Guerra",
        ["frFR"] = "Colline des Cogneguerre",
        ["koKR"] = "전쟁망치 언덕",
        ["ptBR"] = "Morro Guerramalho",
        ["ruRU"] = "Холм Боевого Молота",
        ["zhCN"] = "战槌山",
        ["zhTW"] = "戰槌山丘",
    },
    ["Ogri'la"] = {
        ["enUS"] = true,
        ["deDE"] = "Ogri'la",
        ["esES"] = "Ogri'la",
        ["esMX"] = "Ogri'la",
        ["frFR"] = "Ogri'la",
        ["koKR"] = "오그릴라",
        ["ptBR"] = "Ogri'la",
        ["ruRU"] = "Огри'ла",
        ["zhCN"] = "奥格瑞拉",
        ["zhTW"] = "歐格利拉",
    },
    ["Sporeggar"] = {
        ["enUS"] = true,
        ["deDE"] = "Sporeggar",
        ["esES"] = "Esporaggar",
        ["esMX"] = "Esporaggar",
        ["frFR"] = "Sporeggar",
        ["koKR"] = "스포어가르",
        ["ptBR"] = "Sporeggar",
        ["ruRU"] = "Спореггар",
        ["zhCN"] = "孢子村",
        ["zhTW"] = "斯博格爾",
    },
    ["Dawnstar Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Morgenstern",
        ["esES"] = "Poblado Estrella del Alba",
        ["esMX"] = "Poblado Estrella del Alba",
        ["frFR"] = "Étoile-de-l'aube",
        ["koKR"] = "돈스타 마을",
        ["ptBR"] = "Vila Aurestela",
        ["ruRU"] = "Деревня Утренней Звезды",
        ["zhCN"] = "晨星村",
        ["zhTW"] = "晨星村",
    },
    ["Skysong Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Himmelsweisensee",
        ["esES"] = "Lago Son Celeste",
        ["esMX"] = "Lago Son Celeste",
        ["frFR"] = "Lac Chanteciel",
        ["koKR"] = "하늘노래 호수",
        ["ptBR"] = "Lago Celicanto",
        ["ruRU"] = "Озеро Небесной Песни",
        ["zhCN"] = "天歌湖",
        ["zhTW"] = "天歌湖",
    },
    ["Forge Camp: Wrath"] = {
        ["enUS"] = true,
        ["deDE"] = "Konstruktionslager: Wut",
        ["esES"] = "Campamento Forja: Cólera",
        ["esMX"] = "Campamento Forja: Cólera",
        ["frFR"] = "Camp de forge : Courroux",
        ["koKR"] = "격노의 괴철로 기지",
        ["ptBR"] = "Campo-forja: Ira",
        ["ruRU"] = "Лагерь Легиона: Гнев",
        ["zhCN"] = "铸魔营地：天罚",
        ["zhTW"] = "煉冶場:憤怒",
    },
    ["The Bloodcursed Reef"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Riff des Blutfluchs",
        ["esES"] = "El Arrecife Sangre Maldita",
        ["esMX"] = "El Arrecife Sangre Maldita",
        ["frFR"] = "Le récit du sang maudit",
        ["koKR"] = "핏빛저주의 산호초",
        ["ptBR"] = "Recife do Sangue Maldito",
        ["ruRU"] = "Риф Проклятой Крови",
        ["zhCN"] = "血咒暗礁",
        ["zhTW"] = "血咒沙洲",
    },
    ["Hewn Bog"] = {
        ["enUS"] = true,
        ["deDE"] = "Prügelsumpf",
        ["esES"] = "Ciénaga Talada",
        ["esMX"] = "Ciénaga Talada",
        ["frFR"] = "Tourbière taillée",
        ["koKR"] = "벌거벗은 수렁",
        ["ptBR"] = "Brejo Ceifado",
        ["ruRU"] = "Болотные вырубки",
        ["zhCN"] = "菌杆沼泽",
        ["zhTW"] = "開闢泥沼",
    },
    ["Ragefeather Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Rachfederkamm",
        ["esES"] = "Loma Plumira",
        ["esMX"] = "Loma Plumira",
        ["frFR"] = "Crête des Rageplumes",
        ["koKR"] = "성난깃털 마루",
        ["ptBR"] = "Crista Penabrava",
        ["ruRU"] = "Хребет Яростного Пера",
        ["zhCN"] = "怒羽山",
        ["zhTW"] = "怒羽山脊",
    },
    ["Grishnath"] = {
        ["enUS"] = true,
        ["deDE"] = "Grishnath",
        ["esES"] = "Grishnath",
        ["esMX"] = "Grishnath",
        ["frFR"] = "Grishnath",
        ["koKR"] = "그리쉬나스",
        ["ptBR"] = "Grishnath",
        ["ruRU"] = "Гришнат",
        ["zhCN"] = "格里施纳",
        ["zhTW"] = "葛瑞許納什",
    },
    ["Blackwing Coven"] = {
        ["enUS"] = true,
        ["deDE"] = "Pechschwingenkoven",
        ["esES"] = "Aquelarre Alanegra",
        ["esMX"] = "Aquelarre Alanegra",
        ["frFR"] = "Convent de l'Aile noire",
        ["koKR"] = "검은날개 소굴",
        ["ptBR"] = "Conciliábulo do Asa Negra",
        ["ruRU"] = "Пещера Крыла Тьмы",
        ["zhCN"] = "黑翼集会所",
        ["zhTW"] = "黑翼集會所",
    },
    ["Stillpine Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Tannenruhfeste",
        ["esES"] = "Bastión Semprepino",
        ["esMX"] = "Bastión Semprepino",
        ["frFR"] = "Repaire des Calmepins",
        ["koKR"] = "너울소나무 요새",
        ["ptBR"] = "Aldeia de Pinhoquieto",
        ["ruRU"] = "Логово племени Тихвой",
        ["zhCN"] = "止松要塞",
        ["zhTW"] = "靜松要塞",
    },
    ["Valaar's Berth"] = {
        ["enUS"] = true,
        ["deDE"] = "Valaars Steg",
        ["esES"] = "Atracadero de Valaar",
        ["esMX"] = "Atracadero de Valaar",
        ["frFR"] = "Amarrage de Valaar",
        ["koKR"] = "발라르의 나루",
        ["ptBR"] = "Atracadouro de Valaar",
        ["ruRU"] = "Причал Валаара",
        ["zhCN"] = "瓦拉尔港口",
        ["zhTW"] = "瓦拉船台",
    },
    ["Zangar Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Zangarkamm",
        ["esES"] = "Loma de Zangar",
        ["esMX"] = "Loma de Zangar",
        ["frFR"] = "Crête de Zangar",
        ["koKR"] = "장가르 마루",
        ["ptBR"] = "Crista Zíngara",
        ["ruRU"] = "Гряда Зангара",
        ["zhCN"] = "赞加山",
        ["zhTW"] = "贊格山脊",
    },
    ["Windrunner Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Windläuferturm",
        ["esES"] = "Aguja Brisaveloz",
        ["esMX"] = "Aguja Brisaveloz",
        ["frFR"] = "Flèche de Coursevent",
        ["koKR"] = "윈드러너 첨탑",
        ["ptBR"] = "Pico dos Correventos",
        ["ruRU"] = "Шпили Ветрокрылых",
        ["zhCN"] = "风行者之塔",
        ["zhTW"] = "風行者塔",
    },
    ["Tides' Hollow"] = {
        ["enUS"] = true,
        ["deDE"] = "Gezeitenhöhle",
        ["esES"] = "Hoya de la Marea",
        ["esMX"] = "Hoya Mareanorte",
        ["frFR"] = "Creux des marées",
        ["koKR"] = "파도 동굴",
        ["ptBR"] = "Gruta das Marés",
        ["ruRU"] = "Пещера Приливов",
        ["zhCN"] = "海潮洞窟",
        ["zhTW"] = "海潮窪地",
    },
    ["Manaforge Ultris"] = {
        ["enUS"] = true,
        ["deDE"] = "Manaschmiede Ultris",
        ["esES"] = "Forja de Maná Ultris",
        ["esMX"] = "Forja de Maná Ultris",
        ["frFR"] = "Manaforge Ultris",
        ["koKR"] = "울트리스 마나괴철로",
        ["ptBR"] = "Manaforja Ultris",
        ["ruRU"] = "Манагорн Ультрис",
        ["zhCN"] = "法力熔炉：乌提斯",
        ["zhTW"] = "法力熔爐奧崔斯",
    },
    ["Netherwing Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Netherschwingenfelder",
        ["esES"] = "Campos del Ala Abisal",
        ["esMX"] = "Campos del Ala Abisal",
        ["frFR"] = "Champs de l'Aile-du-Néant",
        ["koKR"] = "황천날개 벌판",
        ["ptBR"] = "Campos da Asa Etérea",
        ["ruRU"] = "Поля Крыльев Пустоты",
        ["zhCN"] = "灵翼平原",
        ["zhTW"] = "虛空之翼農場",
    },
    ["Veil Vekh"] = {
        ["enUS"] = true,
        ["deDE"] = "Vekhversteck",
        ["esES"] = "Velo Vekh",
        ["esMX"] = "Velo Vekh",
        ["frFR"] = "Voile Vekh",
        ["koKR"] = "장막의 베크",
        ["ptBR"] = "Véu Vekh",
        ["ruRU"] = "Гнездовье Векх",
        ["zhCN"] = "维克鸦巢",
        ["zhTW"] = "迷霧維克",
    },
    ["Coilskar Cistern"] = {
        ["enUS"] = true,
        ["deDE"] = "Zisterne der Echsennarbe",
        ["esES"] = "Cisterna Cicatriz Espiral",
        ["esMX"] = "Cisterna Cicatriz Espiral",
        ["frFR"] = "Citerne de Glissentaille",
        ["koKR"] = "갈퀴흉터 저수지",
        ["ptBR"] = "Cisterna Serpentálios",
        ["ruRU"] = "Водохранилище Змеиных Колец",
        ["zhCN"] = "库斯卡水池",
        ["zhTW"] = "考斯卡水池",
    },
    ["The Twilight Ridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Zwielichthöhe",
        ["esES"] = "La Cresta del Crepúsculo",
        ["esMX"] = "La Cresta del Crepúsculo",
        ["frFR"] = "La crête du Crépuscule",
        ["koKR"] = "황혼의 마루",
        ["ptBR"] = "Cordilheira do Crepúsculo",
        ["ruRU"] = "Сумеречная гряда",
        ["zhCN"] = "暮光岭",
        ["zhTW"] = "暮光山脊",
    },
    ["Garadar"] = {
        ["enUS"] = true,
        ["deDE"] = "Garadar",
        ["esES"] = "Garadar",
        ["esMX"] = "Garadar",
        ["frFR"] = "Garadar",
        ["koKR"] = "가라다르",
        ["ptBR"] = "Garadar",
        ["ruRU"] = "Гарадар",
        ["zhCN"] = "加拉达尔",
        ["zhTW"] = "卡拉達爾",
    },
    ["The Deathforge"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Todesschmiede",
        ["esES"] = "La Forja Muerta",
        ["esMX"] = "La Forja Muerta",
        ["frFR"] = "La Forgemort",
        ["koKR"] = "죽음의 괴철로",
        ["ptBR"] = "Forja da Morte",
        ["ruRU"] = "Кузница Смерти",
        ["zhCN"] = "死亡熔炉",
        ["zhTW"] = "死亡熔爐",
    },
    ["Netherwing Ledge"] = {
        ["enUS"] = true,
        ["deDE"] = "Netherschwingenscherbe",
        ["esES"] = "Arrecife del Ala Abisal",
        ["esMX"] = "Arrecife del Ala Abisal",
        ["frFR"] = "Escarpement de l'Aile-du-Néant",
        ["koKR"] = "황천날개 마루",
        ["ptBR"] = "Plataforma da Asa Etérea",
        ["ruRU"] = "Кряж Крыльев Пустоты",
        ["zhCN"] = "灵翼浮岛",
        ["zhTW"] = "虛空之翼岩架",
    },
    ["Burning Blade Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen der Brennenden Klinge",
        ["esES"] = "Ruinas Filo Ardiente",
        ["esMX"] = "Ruinas Filo Ardiente",
        ["frFR"] = "Ruines de la Lame ardente",
        ["koKR"] = "불타는 칼날 폐허",
        ["ptBR"] = "Ruínas da Lâmina Ardente",
        ["ruRU"] = "Руины Пылающего Клинка",
        ["zhCN"] = "火刃废墟",
        ["zhTW"] = "燃燒之劍廢墟",
    },
    ["Wildwind Peak"] = {
        ["enUS"] = true,
        ["deDE"] = "Wildwindgipfel",
        ["esES"] = "Cima Ventosalvaje",
        ["esMX"] = "Cima Ventosalvaje",
        ["frFR"] = "Pic Vent-sauvage",
        ["koKR"] = "갈기바람 봉우리",
        ["ptBR"] = "Morro Vento Selvagem",
        ["ruRU"] = "Штормовой Пик",
        ["zhCN"] = "狂风山",
        ["zhTW"] = "狂風山尖",
    },
    ["Feth's Way"] = {
        ["enUS"] = true,
        ["deDE"] = "Feths Pfad",
        ["esES"] = "Camino de Feth",
        ["esMX"] = "Camino de Feth",
        ["frFR"] = "Voie de Feth",
        ["koKR"] = "페스의 길",
        ["ptBR"] = "Trilha de Feth",
        ["ruRU"] = "Путь Фета",
        ["zhCN"] = "菲斯小径",
        ["zhTW"] = "費司之路",
    },
    ["Razorthorn Shelf"] = {
        ["enUS"] = true,
        ["deDE"] = "Messerdornbank",
        ["esES"] = "Saliente Rajaespina",
        ["esMX"] = "Saliente Rajaespina",
        ["frFR"] = "Saillie de Tranchépine",
        ["koKR"] = "서슬가시 벼랑",
        ["ptBR"] = "Passagem Espinhosa",
        ["ruRU"] = "Обрыв Острого Шипа",
        ["zhCN"] = "荆刺岩地",
        ["zhTW"] = "刺棘沙洲",
    },
    ["Dragons' End"] = {
        ["enUS"] = true,
        ["deDE"] = "Drachenend",
        ["esES"] = "Cabo del Dragón",
        ["esMX"] = "Cabo del Dragón",
        ["frFR"] = "Fin des dragons",
        ["koKR"] = "용의 무덤",
        ["ptBR"] = "Findragões",
        ["ruRU"] = "Драконья Пагуба",
        ["zhCN"] = "巨龙之末",
        ["zhTW"] = "飛龍之末",
    },
    ["Ruins of Loreth'Aran"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Loreth'Aran",
        ["esES"] = "Ruinas de Loreth'Aran",
        ["esMX"] = "Ruinas de Loreth'Aran",
        ["frFR"] = "Ruines de Loreth'Aran",
        ["koKR"] = "로레스아란 폐허",
        ["ptBR"] = "Ruínas de Loreth'Aran",
        ["ruRU"] = "Развалины Лорет'Арана",
        ["zhCN"] = "洛雷萨兰废墟",
        ["zhTW"] = "羅薩倫廢墟",
    },
    ["The Dawnchaser"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Morgensturm",
        ["esES"] = "El Cazador del Albor",
        ["esMX"] = "El Cazador del Albor",
        ["frFR"] = "Le Chasselaube",
        ["koKR"] = "새벽추적자호",
        ["ptBR"] = "Conquistador da Aurora",
        ["ruRU"] = "Рассветный охотник",
        ["zhCN"] = "曙光追寻者号",
        ["zhTW"] = "晨逐者",
    },
    ["Blades' Run"] = {
        ["enUS"] = true,
        ["deDE"] = "Säbelflucht",
        ["esES"] = "Camino de las Espadas",
        ["esMX"] = "Camino de las Espadas",
        ["frFR"] = "Le défilé des lames",
        ["koKR"] = "칼날 고개",
        ["ptBR"] = "Ladeira Afiada",
        ["ruRU"] = "Скалистая тропа",
        ["zhCN"] = "刀锋之路",
        ["zhTW"] = "劍之小道",
    },
    ["Beryl Coast"] = {
        ["enUS"] = true,
        ["deDE"] = "Beryllküste",
        ["esES"] = "Costa Beryl",
        ["esMX"] = "Costa de Berilo",
        ["frFR"] = "La côte de Béryl",
        ["koKR"] = "녹주석 해안",
        ["ptBR"] = "Costa Berília",
        ["ruRU"] = "Берилловое побережье",
        ["zhCN"] = "贝里尔海湾",
        ["zhTW"] = "貝瑞歐海岸",
    },
    ["Manaforge Coruu"] = {
        ["enUS"] = true,
        ["deDE"] = "Manaschmiede Coruu",
        ["esES"] = "Forja de Maná Coruu",
        ["esMX"] = "Forja de Maná Coruu",
        ["frFR"] = "Manaforge Coruu",
        ["koKR"] = "코루 마나괴철로",
        ["ptBR"] = "Manaforja Coruu",
        ["ruRU"] = "Манагорн Коруу",
        ["zhCN"] = "法力熔炉：库鲁恩",
        ["zhTW"] = "法力熔爐寇魯",
    },
    ["Falcon Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Falkenwacht",
        ["esES"] = "Avanzada del Halcón",
        ["esMX"] = "Avanzada del Halcón",
        ["frFR"] = "Guet de l'épervier",
        ["koKR"] = "매의 감시탑",
        ["ptBR"] = "Vigília do Falcão",
        ["ruRU"] = "Соколиный дозор",
        ["zhCN"] = "猎鹰岗哨",
        ["zhTW"] = "獵鷹哨站",
    },
    ["Goldenbough Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Goldblattpass",
        ["esES"] = "Desfiladero Ramadorada",
        ["esMX"] = "Desfiladero Ramadorada",
        ["frFR"] = "Passe du Rameau d'or",
        ["koKR"] = "황금가지 고개",
        ["ptBR"] = "Caminho Ramadouro",
        ["ruRU"] = "Тропа Золотой Ветви",
        ["zhCN"] = "金枝小径",
        ["zhTW"] = "金枝小徑",
    },
    ["The Sun Forge"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sonnenschmiede",
        ["esES"] = "La Forja del Sol",
        ["esMX"] = "La Forja del Sol",
        ["frFR"] = "La forge du Soleil",
        ["koKR"] = "태양 괴철로",
        ["ptBR"] = "Forja do Sol",
        ["ruRU"] = "Кузня Солнца",
        ["zhCN"] = "太阳熔炉",
        ["zhTW"] = "太陽熔爐",
    },
    ["Ruins of Sha'naar"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Sha'naar",
        ["esES"] = "Ruinas de Sha'naar",
        ["esMX"] = "Ruinas de Sha'naar",
        ["frFR"] = "Ruines de Sha'naar",
        ["koKR"] = "샤나르 폐허",
        ["ptBR"] = "Ruínas de Sha'naar",
        ["ruRU"] = "Руины Ша'наара",
        ["zhCN"] = "沙纳尔废墟",
        ["zhTW"] = "夏納廢墟",
    },
    ["Area 52"] = {
        ["enUS"] = true,
        ["deDE"] = "Area 52",
        ["esES"] = "Área 52",
        ["esMX"] = "Área 52",
        ["frFR"] = "Zone 52",
        ["koKR"] = "52번 구역",
        ["ptBR"] = "Área 52",
        ["ruRU"] = "Зона 52",
        ["zhCN"] = "52区",
        ["zhTW"] = "52區",
    },
    ["Sylvanaar"] = {
        ["enUS"] = true,
        ["deDE"] = "Sylvanaar",
        ["esES"] = "Sylvanaar",
        ["esMX"] = "Sylvanaar",
        ["frFR"] = "Sylvanaar",
        ["koKR"] = "실바나르",
        ["ptBR"] = "Sylvanaar",
        ["ruRU"] = "Сильванаар",
        ["zhCN"] = "希尔瓦纳",
        ["zhTW"] = "希爾瓦納",
    },
    ["The Broken Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Die zerklüfteten Hügel",
        ["esES"] = "Las Colinas Quebradas",
        ["esMX"] = "Las Colinas Quebradas",
        ["frFR"] = "Les Collines brisées",
        ["koKR"] = "뒤틀린 언덕",
        ["ptBR"] = "Montes Partidos",
        ["ruRU"] = "Изрезанные холмы",
        ["zhCN"] = "碎石岭",
        ["zhTW"] = "破碎之丘",
    },
    ["Zabra'jin"] = {
        ["enUS"] = true,
        ["deDE"] = "Zabra'jin",
        ["esES"] = "Zabra'jin",
        ["esMX"] = "Zabra'jin",
        ["frFR"] = "Zabra'jin",
        ["koKR"] = "자브라진",
        ["ptBR"] = "Zabra'jin",
        ["ruRU"] = "Забра'джин",
        ["zhCN"] = "萨布拉金",
        ["zhTW"] = "薩布拉金",
    },
    ["Pod Cluster"] = {
        ["enUS"] = true,
        ["deDE"] = "Kapselteil",
        ["esES"] = "La Maraña de Cápsulas",
        ["esMX"] = "La Maraña de Cápsulas",
        ["frFR"] = "Grappe de capsules",
        ["koKR"] = "탈출선 착륙지",
        ["ptBR"] = "Módulos Espaciais",
        ["ruRU"] = "Отсек Капсулы",
        ["zhCN"] = "完整的逃生舱",
        ["zhTW"] = "卵囊串",
    },
    ["The Great Fissure"] = {
        ["enUS"] = true,
        ["deDE"] = "Die große Kluft",
        ["esES"] = "La Gran Fisura",
        ["esMX"] = "La Gran Fisura",
        ["frFR"] = "La Grande fissure",
        ["koKR"] = "거대한 균열",
        ["ptBR"] = "A Grande Fenda",
        ["ruRU"] = "Глубокий Разлом",
        ["zhCN"] = "大裂隙",
        ["zhTW"] = "大裂縫",
    },
    ["Amberweb Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Goldweberpass",
        ["esES"] = "Paso de Redámbar",
        ["esMX"] = "Paso de Redámbar",
        ["frFR"] = "Passe d'Ambretoile",
        ["koKR"] = "호박그물 고개",
        ["ptBR"] = "Desfiladeiro da Teia Âmbar",
        ["ruRU"] = "Перевал Янтарной Паутины",
        ["zhCN"] = "琥珀蛛网小径",
        ["zhTW"] = "琥珀網小徑",
    },
    ["Manaforge B'naar"] = {
        ["enUS"] = true,
        ["deDE"] = "Manaschmiede B'naar",
        ["esES"] = "Forja de Maná B'naar",
        ["esMX"] = "Forja de Maná B'naar",
        ["frFR"] = "Manaforge B'naar",
        ["koKR"] = "브나르 마나괴철로",
        ["ptBR"] = "Manaforja B'naar",
        ["ruRU"] = "Манагорн Б'наар",
        ["zhCN"] = "法力熔炉：布纳尔",
        ["zhTW"] = "法力熔爐巴納爾",
    },
    ["Bloodmaul Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der Blutschläger",
        ["esES"] = "Campamento Machacasangre",
        ["esMX"] = "Campamento Machacasangre",
        ["frFR"] = "Camp de la Masse-sanglante",
        ["koKR"] = "피망치 야영지",
        ["ptBR"] = "Base dos Malho Sangrento",
        ["ruRU"] = "Лагерь Кровавого Молота",
        ["zhCN"] = "血槌营地",
        ["zhTW"] = "血槌營地",
    },
    ["Lake Jorune"] = {
        ["enUS"] = true,
        ["deDE"] = "Jorunesee",
        ["esES"] = "Lago Jorune",
        ["esMX"] = "Lago Jorune",
        ["frFR"] = "Lac Jorune",
        ["koKR"] = "조룬 호수",
        ["ptBR"] = "Lago Dorune",
        ["ruRU"] = "Озеро Иорун",
        ["zhCN"] = "尤鲁恩湖",
        ["zhTW"] = "佐魯湖",
    },
    ["Sketh'lon Base Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Basislager der Sketh'lon",
        ["esES"] = "Campamento Sketh'lon",
        ["esMX"] = "Campamento Sketh'lon",
        ["frFR"] = "Campement Sketh'lon",
        ["koKR"] = "스케슬론 주둔지",
        ["ptBR"] = "Base Sketh'lon",
        ["ruRU"] = "Лагерь Скет'лона",
        ["zhCN"] = "斯克瑟隆营地",
        ["zhTW"] = "史凱瑟隆營地",
    },
    ["Mag'hari Procession"] = {
        ["enUS"] = true,
        ["deDE"] = "Mag'harische Prozession",
        ["esES"] = "Procesión Mag'hari",
        ["esMX"] = "Procesión Mag'hari",
        ["frFR"] = "Procession Mag'hari",
        ["koKR"] = "마그하리 행렬",
        ["ptBR"] = "Cortejo Fúnebre Mag'hari",
        ["ruRU"] = "Похоронная процессия маг'харов",
        ["zhCN"] = "玛格汉车队",
        ["zhTW"] = "瑪格哈利隊伍",
    },
    ["Kessel's Crossing"] = {
        ["enUS"] = true,
        ["deDE"] = "Kessels Wegelager",
        ["esES"] = "Encrucijada de Kessel",
        ["esMX"] = "Encrucijada de Kessel",
        ["frFR"] = "La croisée de Kessel",
        ["koKR"] = "케셀의 길목",
        ["ptBR"] = "Travessia de Kessel",
        ["ruRU"] = "Лагерь Кессела",
        ["zhCN"] = "凯希尔路口",
        ["zhTW"] = "凱索十字路",
    },
}

for k, v in pairs(outlandLocales) do
    l10n.translations[k] = v
end
