---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local zoneSectionLocales = {
    ["Eastern Kingdoms"] = {
        ["enUS"] = true,
        ["deDE"] = "Östliche Königreiche",
        ["esES"] = "Reinos del Este",
        ["esMX"] = "Reinos del Este",
        ["frFR"] = "Royaumes de l'est",
        ["koKR"] = "동부 왕국",
        ["ptBR"] = "Reinos do Leste",
        ["ruRU"] = "Восточные Королевства",
        ["zhCN"] = "东部王国",
        ["zhTW"] = "東部王國",
    },
    ["Battlegrounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlachtfelder",
        ["esES"] = "Campos de batalla",
        ["esMX"] = "Campos de batalla",
        ["frFR"] = "Champs de bataille",
        ["koKR"] = "전장",
        ["ptBR"] = "Campos de batalha",
        ["ruRU"] = "Поля Битвы",
        ["zhCN"] = "战场",
        ["zhTW"] = "戰場",
    },
    ["Events"] = {
        ["enUS"] = true,
        ["deDE"] = "Events",
        ["esES"] = "Eventos",
        ["esMX"] = "Eventos",
        ["frFR"] = "Événements",
        ["koKR"] = "이벤트들",
        ["ptBR"] = "Eventos",
        ["ruRU"] = "События",
        ["zhCN"] = "事件",
        ["zhTW"] = "節慶",
    },
    ["Outland"] = {
        ["enUS"] = true,
        ["deDE"] = "Scherbenwelt",
        ["esES"] = "Terrallende",
        ["esMX"] = "Terrallende",
        ["frFR"] = "Outreterre",
        ["koKR"] = "아웃랜드",
        ["ptBR"] = "Terralém",
        ["ruRU"] = "Запределье",
        ["zhCN"] = "外域",
        ["zhTW"] = "外域",
    },
    ["Northrend"] = {
        ["enUS"] = true,
        ["deDE"] = "Nordend",
        ["esES"] = "Rasganorte",
        ["esMX"] = "Rasganorte",
        ["frFR"] = "Norfendre",
        ["koKR"] = "노스렌드",
        ["ptBR"] = "Nortúndria",
        ["ruRU"] = "Нордскол",
        ["zhCN"] = "诺森德",
        ["zhTW"] = "北裂境",
    },
    ["Cataclysm"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "대격변",
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = "大地的裂变",
        ["zhTW"] = "浩劫與重生",
    },
    ["The Maelstrom"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Mahlstrom",
        ["esES"] = "La Vorágine",
        ["esMX"] = "La Vorágine",
        ["frFR"] = "Le Maelström",
        ["koKR"] = "혼돈의 소용돌이",
        ["ptBR"] = "Voragem",
        ["ruRU"] = "Водоворот",
        ["zhCN"] = "大漩涡",
        ["zhTW"] = "大漩渦",
    },
    ["Pandaria"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "판다리아",
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = "潘达利亚",
        ["zhTW"] = "潘達利亞",
    },
    ["Professions"] = {
        ["enUS"] = true,
        ["deDE"] = "Berufe",
        ["esES"] = "Profesiones",
        ["esMX"] = "Profesiones",
        ["frFR"] = true,
        ["koKR"] = "전문 기술들",
        ["ptBR"] = "Profissões",
        ["ruRU"] = "Профессии",
        ["zhCN"] = "专业",
        ["zhTW"] = "專業技能",
    },
    ["Class"] = {
        ["enUS"] = true,
        ["deDE"] = "Klasse",
        ["esES"] = "Clase",
        ["esMX"] = "Clase",
        ["frFR"] = "Classe",
        ["koKR"] = "직업",
        ["ptBR"] = "Classe",
        ["ruRU"] = "Класс",
        ["zhCN"] = "职业",
        ["zhTW"] = "職業",
    },
    ["Kalimdor"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "칼림도어",
        ["ptBR"] = true,
        ["ruRU"] = "Калимдор",
        ["zhCN"] = "卡利姆多",
        ["zhTW"] = "卡林多",
    },
    ["Dungeons"] = {
        ["enUS"] = true,
        ["deDE"] = "Instanzen",
        ["esES"] = "Mazmorras",
        ["esMX"] = "Calabozos",
        ["frFR"] = "Donjons",
        ["koKR"] = "던전",
        ["ptBR"] = "Masmorras",
        ["ruRU"] = "Подземелья",
        ["zhCN"] = "地下城",
        ["zhTW"] = "地下城",
    },
    ["Scenarios"] = {
        ["enUS"] = true,
        ["deDE"] = "Szenarien",
        ["esES"] = "Gestas",
        ["esMX"] = "Gestas",
        ["frFR"] = "Scénarios",
        ["koKR"] = "시나리오",
        ["ptBR"] = "Cenários",
        ["ruRU"] = "Сценарии",
        ["zhCN"] = "场景",
        ["zhTW"] = "事件",
    },
    ["Unknown Zone"] = {
        ["enUS"] = true,
        ["deDE"] = "Unbekannte Zone",
        ["esES"] = "Zona desconocida",
        ["esMX"] = "Zona desconocida",
        ["frFR"] = "Zone inconnue",
        ["koKR"] = "알 수 없는 지역",
        ["ptBR"] = "Zona desconhecida",
        ["ruRU"] = "Неизвестная зона",
        ["zhCN"] = "未知区域",
        ["zhTW"] = "未知區域",
    },
    ["Battle Pets"] = {
        ["enUS"] = true,
        ["deDE"] = "Kampfhaustiere",
        ["esES"] = "Mascotas de duelo",
        ["esMX"] = "Mascotas de duelo",
        ["frFR"] = "Mascottes de combat",
        ["koKR"] = "전투 애완동물",
        ["ptBR"] = "Mascotes de Batalha",
        ["ruRU"] = "Боевые питомцы",
        ["zhCN"] = "战斗宠物",
        ["zhTW"] = "戰寵",
    },
}

for k, v in pairs(zoneSectionLocales) do
    l10n.translations[k] = v
end
