---@type Townsfolk
local Townsfolk = QuestieLoader:ImportModule("Townsfolk")

-- SELECT entry FROM creature_template WHERE trainertype=0 AND trainerclass=X
-- 1: Warrior, 2: Paladin, 3: Hunter, 4: Rogue, 5: Priest, 6: Death Knight, 7: Shaman, 8: Mage, 9: Warlock, 11: Druid
---@type table<Classes, NpcId[]>
local classTrainers

if Questie.IsMoP then
    classTrainers = {
        ["WARRIOR"]={911,912,913,914,985,1229,1403,1901,2119,2131,3041,3042,3043,3059,3063,3153,3169,3353,3354,3408,3593,3598,4087,4089,4593,4594,4595,4992,5113,5114,5479,5480,5959,5966,5967,7315,8141,10291,16503,16771,17120,17480,17504,26332,34697,35807,35839,36525,36651,36699,36857,38037,38518,38793,42324,43009,43010,43012,44128,44129,44455,44723,45019,45709,46667,48616,49720,49736,49781,49902,49923,49955,49961,50006,50018,50025,50033,50149,50155,50500},
        ["PALADIN"]={925,926,927,928,1232,4988,5147,5148,5149,5491,5492,8140,8664,15280,16275,16501,16679,16680,16681,16761,17121,17483,17509,17844,20406,23128,26327,35281,36702,37737,43001,43013,43795,44725,49741,49793,49916,49954,49957,50012,50023,50035,50150,50160},
        ["HUNTER"]={895,897,987,1231,1404,2218,3038,3039,3040,3061,3065,3154,3171,3352,3406,3407,3596,3601,4138,4146,4205,4986,5115,5116,5117,5501,5515,5516,5517,8308,10930,15513,16270,16499,16672,16673,16674,16738,17110,17122,17505,26325,34600,34673,35758,35874,36518,36629,36664,36705,38122,38247,38467,38798,38911,39100,39116,39214,43008,43011,43277,43278,43909,44247,44249,44250,44461,44743,45023,45713,46983,47767,47788,48618,49713,49806,49894,49927,49946,49958,49966,50004,50007,50020,50032,50144,50157,50497,50609},
        ["ROGUE"]={915,916,917,918,1234,1411,2122,2130,3155,3170,3327,3328,3401,3594,3599,4163,4214,4215,4582,4583,4584,4990,5165,5166,5167,5960,5968,6707,13283,15285,16684,16685,16686,16759,23566,26329,34693,35806,35871,36524,36630,38244,38517,38796,42366,44464,45095,45717,47233,48615,49730,49745,49782,49870,49909,49939,49949,50015,50016,50027,50127,50147,50158,50498,51998},
        ["PRIEST"]={375,376,377,837,1226,2123,2129,3044,3045,3046,3595,3600,3706,3707,4090,4091,4092,4606,4607,4608,4989,5141,5142,5143,5484,5489,5964,5973,5994,6014,6018,11397,11401,11406,15284,16276,16502,16658,16659,16660,16756,17482,17510,17511,19247,26328,34692,35805,35870,36523,36632,36704,37724,38245,38466,38516,38795,42323,43004,43015,43796,43870,44468,44735,45137,45306,45337,45339,45347,48614,49715,49749,49784,49901,49940,49950,49962,50001,50013,50024,50031,50148,50163,50501,53403},
        ["DEATHKNIGHT"]={27916,28471,28472,28474,29194,29195,29196,31084},
        ["SHAMAN"]={354,373,986,1406,2219,3030,3031,3032,3062,3066,3157,3173,3344,3403,4991,5965,5971,13417,16661,17089,17204,17212,17219,17519,17520,18270,20407,23127,26330,34695,35786,36521,36700,37115,38242,38515,43464,44393,44394,44740,45029,45718,49808,49900,49964,50011,50019,50022,50130,50153,50174,51637,51638,51639,51640,52290,52292,52299,52317,53405},
        ["MAGE"]={198,313,328,331,944,1228,2124,2128,2485,2489,2492,3047,3048,3049,4165,4566,4567,4568,4987,5144,5145,5146,5497,5498,5880,5882,5883,5884,5885,5957,5958,5961,5969,7311,7312,7488,15279,16269,16500,16651,16652,16653,16654,16749,16755,17481,17513,17514,19340,20791,23103,26326,27703,27704,27705,28956,28958,29156,34689,35780,35872,36520,36631,37121,38246,38465,38514,38794,39206,42331,43005,43006,44465,45714,47246,47247,47248,48613,49716,49760,49786,49896,49952,49959,49968,50002,50010,50021,50029,50151,50166,50499,50690,50714,50715,50716,50717,50720},
        ["WARLOCK"]={459,460,461,906,988,1408,2126,2127,3156,3172,3324,3325,3326,4563,4564,4565,4993,5039,5171,5172,5173,5495,5496,5612,5749,5750,5753,5815,5962,5970,6027,6328,6373,6374,6376,6382,12776,12807,15283,15494,16266,16267,16646,16647,16648,16649,16770,23534,23535,26331,34696,35778,35869,36519,36652,38513,38797,42618,43455,43881,43883,43892,44469,45138,45720,48612,49718,49769,49791,49895,49945,49963,49998,50017,50028,50128,50142,50156,50502,50723,50729,50732,53404},
        ["DRUID"]={542,1409,2217,3033,3034,3036,3060,3064,3597,3602,4217,4218,4219,4985,5504,5505,5506,5963,5972,8142,9465,12042,13476,16655,16721,26324,35873,36628,36703,38243,38799,44380,44395,44396,44459,44726,44978,49915,49942,49997,50034,50136,50137,50152,50171,50492,50505,50506,50507,52318,52319,52335},
        ["MONK"]={64978,62445,62419,64679,63335,63258,62393,64980,61553,63332,62450,62463,63272,63310,63285,62321,64975,62425,64974,63327,62464,62462,63296,63331,63238},
    }
elseif Questie.IsCata then
    classTrainers = {
        ["WARRIOR"]={911,912,913,914,985,1229,1403,1901,2119,2131,3041,3042,3043,3059,3063,3153,3169,3353,3354,3408,3593,3598,4087,4089,4593,4594,4595,4992,5113,5114,5479,5480,5959,5966,5967,7315,8141,10291,16503,16771,17120,17480,17504,26332,34697,35807,35839,36525,36651,36699,36857,38037,38518,38793,42324,43009,43010,43012,44128,44129,44455,44723,45019,45709,46667,48616,49720,49736,49781,49902,49923,49955,49961,50006,50018,50025,50033,50149,50155,50500},
        ["PALADIN"]={925,926,927,928,1232,4988,5147,5148,5149,5491,5492,8140,8664,15280,16275,16501,16679,16680,16681,16761,17121,17483,17509,17844,20406,23128,26327,35281,36702,37737,43001,43013,43795,44725,49741,49793,49916,49954,49957,50012,50023,50035,50150,50160},
        ["HUNTER"]={895,897,987,1231,1404,2218,3038,3039,3040,3061,3065,3154,3171,3352,3406,3407,3596,3601,4138,4146,4205,4986,5115,5116,5117,5501,5515,5516,5517,8308,10930,15513,16270,16499,16672,16673,16674,16738,17110,17122,17505,26325,34600,34673,35758,35874,36518,36629,36664,36705,38122,38247,38467,38798,38911,39100,39116,39214,43008,43011,43277,43278,43909,44247,44249,44250,44461,44743,45023,45713,46983,47767,47788,48618,49713,49806,49894,49927,49946,49958,49966,50004,50007,50020,50032,50144,50157,50497,50609},
        ["ROGUE"]={915,916,917,918,1234,1411,2122,2130,3155,3170,3327,3328,3401,3594,3599,4163,4214,4215,4582,4583,4584,4990,5165,5166,5167,5960,5968,6707,13283,15285,16684,16685,16686,16759,23566,26329,34693,35806,35871,36524,36630,38244,38517,38796,42366,44464,45095,45717,47233,48615,49730,49745,49782,49870,49909,49939,49949,50015,50016,50027,50127,50147,50158,50498,51998},
        ["PRIEST"]={375,376,377,837,1226,2123,2129,3044,3045,3046,3595,3600,3706,3707,4090,4091,4092,4606,4607,4608,4989,5141,5142,5143,5484,5489,5964,5973,5994,6014,6018,11397,11401,11406,15284,16276,16502,16658,16659,16660,16756,17482,17510,17511,19247,26328,34692,35805,35870,36523,36632,36704,37724,38245,38466,38516,38795,42323,43004,43015,43796,43870,44468,44735,45137,45306,45337,45339,45347,48614,49715,49749,49784,49901,49940,49950,49962,50001,50013,50024,50031,50148,50163,50501,53403},
        ["DEATHKNIGHT"]={27916,28471,28472,28474,29194,29195,29196,31084},
        ["SHAMAN"]={354,373,986,1406,2219,3030,3031,3032,3062,3066,3157,3173,3344,3403,4991,5965,5971,13417,16661,17089,17204,17212,17219,17519,17520,18270,20407,23127,26330,34695,35786,36521,36700,37115,38242,38515,43464,44393,44394,44740,45029,45718,49808,49900,49964,50011,50019,50022,50130,50153,50174,51637,51638,51639,51640,52290,52292,52299,52317,53405},
        ["MAGE"]={198,313,328,331,944,1228,2124,2128,2485,2489,2492,3047,3048,3049,4165,4566,4567,4568,4987,5144,5145,5146,5497,5498,5880,5882,5883,5884,5885,5957,5958,5961,5969,7311,7312,7488,15279,16269,16500,16651,16652,16653,16654,16749,16755,17481,17513,17514,19340,20791,23103,26326,27703,27704,27705,28956,28958,29156,34689,35780,35872,36520,36631,37121,38246,38465,38514,38794,39206,42331,43005,43006,44465,45714,47246,47247,47248,48613,49716,49760,49786,49896,49952,49959,49968,50002,50010,50021,50029,50151,50166,50499,50690,50714,50715,50716,50717,50720},
        ["WARLOCK"]={459,460,461,906,988,1408,2126,2127,3156,3172,3324,3325,3326,4563,4564,4565,4993,5039,5171,5172,5173,5495,5496,5612,5749,5750,5753,5815,5962,5970,6027,6328,6373,6374,6376,6382,12776,12807,15283,15494,16266,16267,16646,16647,16648,16649,16770,23534,23535,26331,34696,35778,35869,36519,36652,38513,38797,42618,43455,43881,43883,43892,44469,45138,45720,48612,49718,49769,49791,49895,49945,49963,49998,50017,50028,50128,50142,50156,50502,50723,50729,50732,53404},
        ["DRUID"]={542,1409,2217,3033,3034,3036,3060,3064,3597,3602,4217,4218,4219,4985,5504,5505,5506,5963,5972,8142,9465,12042,13476,16655,16721,26324,35873,36628,36703,38243,38799,44380,44395,44396,44459,44726,44978,49915,49942,49997,50034,50136,50137,50152,50171,50492,50505,50506,50507,52318,52319,52335},
    }
elseif Questie.IsWotlk then
    classTrainers = {
        ["WARRIOR"]={911,912,913,914,985,1229,1901,2119,2131,3041,3042,3043,3059,3063,3153,3169,3353,3354,3408,3593,3598,4087,4089,4593,4594,4595,5113,5114,5479,5480,7315,8141,16503,16771,17120,17480,17504,26332},
        ["PALADIN"]={925,926,927,928,1232,5147,5148,5149,5491,5492,8140,15280,16275,16501,16679,16680,16681,16761,17121,17483,17509,17844,20406,23128,26327,35281},
        ["HUNTER"]={895,987,1231,1404,3038,3039,3040,3061,3065,3154,3171,3352,3406,3407,3596,3601,3963,4138,4146,4205,5115,5116,5117,5501,5515,5516,5517,8308,10930,15513,16270,16499,16672,16673,16674,16738,17110,17122,17505,26325},
        ["ROGUE"]={915,916,917,918,1234,1411,2122,2130,3155,3170,3327,3328,3401,3594,3599,4163,4214,4215,4582,4583,4584,5165,5166,5167,6707,13283,15285,16279,16684,16685,16686,26329},
        ["PRIEST"]={375,376,377,837,1226,2123,2129,3044,3045,3046,3595,3600,3706,3707,4090,4091,4092,4606,4607,4608,5141,5142,5143,5484,5489,5994,6014,6018,11397,11401,11406,15284,16276,16502,16658,16659,16660,16756,17482,17510,17511,26328},
        ["DEATHKNIGHT"]={28471,28472,28474,29194,29195,29196,31084},
        ["SHAMAN"]={986,3030,3031,3032,3062,3066,3157,3173,3344,3403,13417,17089,17204,17212,17219,17519,17520,20407,23127,26330},
        ["MAGE"]={198,328,331,944,1228,2124,2128,2485,2489,2492,3047,3048,3049,4165,4566,4567,4568,5144,5145,5146,5497,5498,5880,5882,5883,5884,5885,5957,5958,7311,7312,15279,16269,16500,16651,16652,16653,16654,16749,16755,17105,17481,17513,17514,19340,20791,23103,26326,27703,27704,27705,28956,28958,29156},
        ["WARLOCK"]={459,460,461,906,988,2126,2127,3156,3172,3324,3325,3326,4563,4564,4565,5171,5172,5173,5495,5496,5612,6251,15283,16266,16646,16647,16648,23534,26331},
        ["DRUID"]={3033,3034,3036,3060,3064,3597,3602,4217,4218,4219,5504,5505,5506,8142,9465,12042,16655,16721,26324},
    }
elseif Questie.IsTBC then
    classTrainers = {
        ["WARRIOR"] = {911,912,913,914,985,1229,1901,2119,2131,3041,3042,3043,3059,3063,3153,3169,3353,3354,3408,3593,3598,4087,4089,4593,4594,4595,4992,5113,5114,5479,5480,7315,8141,16387,16503,16771,17120,17480,17504,26332},
        ["PALADIN"] = {925,926,927,928,1232,4988,5147,5148,5149,5491,5492,8140,15280,16275,16501,16679,16680,16681,16761,17121,17483,17509,17844,20406,23128,26327},
        ["HUNTER"] = {895,987,1231,1404,3038,3039,3040,3061,3065,3154,3171,3352,3406,3407,3596,3601,3963,4138,4146,4205,4986,5115,5116,5117,5501,5515,5516,5517,8308,10930,15513,16270,16499,16672,16673,16674,16738,17110,17122,17505,26325},
        ["ROGUE"] = {915,916,917,918,1234,1411,2122,2130,3155,3170,3327,3328,3401,3594,3599,4163,4214,4215,4582,4583,4584,4990,5165,5166,5167,13283,15285,16279,16684,16685,16686,22005,26329},
        ["PRIEST"] = {375,376,377,837,1226,2123,2129,3044,3045,3046,3595,3600,3706,3707,4090,4091,4092,4606,4607,4608,4989,5141,5142,5143,5484,5489,5994,6014,6018,11397,11401,11406,15284,16276,16502,16658,16659,16660,16756,17482,17510,17511,26328},
        ["SHAMAN"] = {986,3030,3031,3032,3062,3066,3157,3173,3344,3403,4991,13417,17089,17204,17212,17219,17519,17520,20407,23127,26330},
        ["MAGE"] = {198,313,328,331,944,1228,2124,2128,3047,3048,3049,4566,4567,4568,4987,5144,5145,5146,5497,5498,5880,5882,5883,5884,5885,7311,7312,15279,16269,16500,16651,16652,16653,16749,17481,17513,17514,26326,27704},
        ["WARLOCK"] = {459,460,461,906,988,2126,2127,3156,3172,3324,3325,3326,4563,4564,4565,4993,5171,5172,5173,5495,5496,5612,6251,15283,16266,16646,16647,16648,26331},
        ["DRUID"] = {3033,3034,3036,3060,3064,3597,3602,4217,4218,4219,4985,5504,5505,5506,8142,9465,12042,16655,16721,26324}
    }
else
    classTrainers = {
        ["WARRIOR"] = {911,912,913,914,985,1229,1901,2119,2131,3041,3042,3043,3059,3063,3153,3169,3353,3354,3408,3593,3598,4087,4089,4593,4594,4595,5113,5114,5479,5480,7315,8141,16387},
        ["PALADIN"] = {925,926,927,928,1232,5147,5148,5149,5491,5492,8140},
        ["HUNTER"] = {895,987,1231,1404,3038,3039,3040,3061,3065,3154,3171,3352,3406,3407,3596,3601,3963,4138,4146,4205,5115,5116,5117,5501,5515,5516,5517,8308,10930},
        ["ROGUE"] = {915,916,917,918,1234,1411,2122,2130,3155,3170,3327,3328,3401,3594,3599,4163,4214,4215,4582,4583,4584,5165,5166,5167,13283},
        ["PRIEST"] = {375,376,377,837,1226,2123,2129,3044,3045,3046,3595,3600,3706,3707,4090,4091,4092,4606,4607,4608,5141,5142,5143,5484,5489,5994,6014,6018,11397,11401,11406},
        ["SHAMAN"] = {986,3030,3031,3032,3062,3066,3157,3173,3344,3403,13417},
        ["MAGE"] = {198,313,328,331,944,1228,2124,2128,3047,3048,3049,4566,4567,4568,5144,5145,5146,5497,5498,5880,5882,5883,5884,5885,7311,7312},
        ["WARLOCK"] = {459,460,461,906,988,2126,2127,3156,3172,3324,3325,3326,4563,4564,4565,5171,5172,5173,5495,5496,5612},
        ["DRUID"] = {3033,3034,3036,3060,3064,3597,3602,4217,4218,4219,5504,5505,5506,8142,9465,12042}
    }
end

function Townsfolk.GetClassTrainers()
    return classTrainers
end
