-- AUTO GENERATED FILE! DO NOT EDIT!

---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB");

QuestieDB.npcKeys = {
    ['name'] = 1, -- string
    ['minLevelHealth'] = 2, -- int
    ['maxLevelHealth'] = 3, -- int
    ['minLevel'] = 4, -- int
    ['maxLevel'] = 5, -- int
    ['rank'] = 6, -- int, see https://github.com/cmangos/issues/wiki/creature_template#rank
    ['spawns'] = 7, -- table {[zoneID(int)] = {coordPair(floatVector2D),...},...}
    ['waypoints'] = 8, -- table {[zoneID(int)] = {coordPair(floatVector2D),...},...}
    ['zoneID'] = 9, -- guess as to where this NPC is most common
    ['questStarts'] = 10, -- table {questID(int),...}
    ['questEnds'] = 11, -- table {questID(int),...}
    ['factionID'] = 12, -- int, see https://github.com/cmangos/issues/wiki/FactionTemplate.dbc
    ['friendlyToFaction'] = 13, -- string, Contains "A" and/or "H" depending on NPC being friendly towards those factions. nil if hostile to both.
    ['subName'] = 14, -- string, The title or function of the NPC, e.g. "Weapon Vendor"
    ['npcFlags'] = 15, -- int, Bitmask containing various flags about the NPCs function (Vendor, Trainer, Flight Master, etc.).
                       -- For flag values see https://github.com/cmangos/mangos-classic/blob/172c005b0a69e342e908f4589b24a6f18246c95e/src/game/Entities/Unit.h#L536
}

QuestieDB.npcData = [[return {
[1] = {'Waypoint (Only GM can see it)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH","Visual",0},
[2] = {'Spawn Point (Only GM can see it)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3] = {'Flesh Eater',664,713,24,25,0,{[10]={{25.06,38.2},{25.37,36.04},{25.69,34.45},{23.81,39.21},{22.81,39.09},{22.04,32.62},{21.7,38.3},{22.2,36.96},{25.37,39.03}}},nil,10,nil,nil,21,nil,nil,0},
[6] = {'Kobold Vermin',42,55,1,2,0,{[12]={{48.89,36.44},{49.55,36.06},{49.27,37.05},{48.1,36.96},{48.37,36.59},{49.32,35.81},{48.87,35.14},{49.87,36.3},{48.52,36.13},{46.93,35.67},{47.58,35.94},{47.65,36.91},{47.86,36.26},{47.57,36.37},{47.62,35.75},{47.67,34.92},{47.22,36.0},{47.95,35.4},{49.79,35.17},{49.44,35.34},{50.76,37.47},{50.04,35.46},{51.3,36.5},{51.61,35.68},{50.49,37.61},{50.98,37.58},{51.29,37.43},{51.36,37.02},{51.81,36.94},{49.73,35.8},{49.17,36.55}}},nil,12,nil,nil,25,nil,nil,0},
[19] = {'Benny Questgiver',484,484,20,20,0,nil,nil,0,nil,nil,35,"AH","NPC",0},
[29] = {'Dragon Spawn',43,43,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[30] = {'Forest Spider',102,120,5,6,0,{[12]={{36.43,55.89},{31.43,57.03},{35.98,62.7},{38.47,62.4},{28.46,66.71},{31.95,68.46},{35.76,69.07},{37.96,69.98},{38.2,72.85},{33.54,73.76},{39.54,78.66},{43.87,76.69},{40.76,75.13},{41.86,72.16},{38.79,73.3},{44.59,71.23}}},nil,12,nil,nil,22,nil,nil,0},
[31] = {'Furbolg',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[36] = {'Harvest Golem',222,247,11,12,0,{[40]={{47.11,67.64},{35.81,45.9},{34.46,46.05},{32.51,36.36},{48.98,33.82},{32.92,37.29},{56.84,35.72},{36.13,46.93},{47.88,33.47},{46.54,69.08},{50.32,33.96},{34.33,47.79},{35.35,47.2},{33.42,36.19},{48.74,32.34},{47.46,66.53},{46.7,65.92},{46.87,67.03},{56.85,34.26},{33.56,46.66},{32.93,35.52},{57.29,35.37},{57.16,33.97},{56.52,35.1},{56.34,35.94},{56.97,36.27},{49.67,32.97},{48.67,32.19}}},nil,40,nil,nil,14,nil,nil,0},
[38] = {'Defias Thug',71,86,3,4,0,{[12]={{53.24,45.58},{54.05,44.86},{53.87,44.27},{54.59,42.87},{53.01,47.18},{52.93,47.28},{52.45,47.4},{51.95,48.53},{52.8,47.03},{51.82,47.4},{51.06,49.25},{52.29,49.58},{52.55,48.77},{52.25,50.09},{52.01,51.01},{51.38,49.26},{51.37,50.86},{53.22,50.57},{53.56,51.48},{52.36,51.66},{52.62,51.93},{52.92,49.41},{52.87,49.34},{53.28,49.61},{53.77,49.73},{53.86,49.17},{53.81,49.07},{53.78,49.19},{53.99,50.58},{53.11,48.18},{53.62,48.33},{53.59,47.76},{51.83,51.44},{54.47,51.35},{55.11,49.16},{55.1,49.0},{54.07,52.2},{54.86,52.08},{55.45,51.21},{55.69,49.73},{54.47,48.92},{54.44,49.82},{54.55,50.25},{55.17,47.8},{54.61,47.02},{53.96,47.03},{54.88,48.46},{54.14,47.84},{56.38,49.75},{56.07,48.13},{55.48,45.76},{54.71,45.96},{55.7,47.29},{55.3,47.02},{56.1,44.99},{56.63,43.72},{56.41,43.92},{56.66,44.02},{55.47,43.95},{55.22,42.27},{54.91,44.22},{55.01,40.17},{55.54,40.92},{57.07,40.9},{57.07,42.54},{56.08,40.56},{54.98,40.19},{55.86,42.22},{54.98,43.14},{54.65,42.05},{55.46,42.07},{57.44,48.07}}},nil,12,nil,nil,17,nil,nil,0},
[40] = {'Kobold Miner',120,137,6,7,0,{[12]={{40.45,80.26},{40.87,80.68},{40.71,81.4},{40.84,80.42},{41.09,80.96},{39.85,81.06},{39.95,78.62},{40.22,79.6},{39.77,79.09},{39.97,80.12},{41.43,79.87},{41.27,79.26},{41.64,80.09},{41.87,81.35},{41.04,78.16},{41.02,79.92},{41.6,80.04},{40.32,77.69},{40.35,78.16},{41.48,77.93},{41.7,78.65},{40.84,77.46},{64.78,59.93},{63.69,61.13},{64.5,57.42},{64.3,56.83},{64.79,56.41},{64.63,56.88},{63.58,55.35},{63.8,58.17},{63.12,56.56},{62.9,59.97},{61.97,58.32},{62.04,55.31},{62.82,53.82},{60.07,57.4},{61.12,56.36},{60.71,52.8},{61.5,51.92},{61.41,51.51},{61.51,53.26},{61.01,49.23},{61.16,50.88},{60.84,49.5},{60.27,49.55},{61.22,49.61},{61.48,50.2},{60.64,50.83},{61.14,49.89},{60.91,59.71},{58.02,59.83}}},nil,12,nil,nil,26,nil,nil,0},
[43] = {'Mine Spider',156,176,8,9,0,{[12]={{62.0,47.91},{60.03,48.68},{61.11,47.28},{61.78,47.49},{60.2,47.56},{61.92,47.11},{61.58,46.91},{60.5,46.88}}},nil,12,nil,nil,22,nil,nil,0},
[46] = {'Murloc Forager',176,198,9,10,0,{[12]={{68.64,85.46},{68.62,85.39},{65.78,84.42},{64.73,83.0},{61.87,80.56},{56.36,85.21},{52.34,86.73},{57.0,84.24},{59.3,82.43},{61.17,82.38},{63.36,82.8},{67.93,83.69},{69.98,84.08},{76.72,82.77},{76.79,85.94},{76.6,85.57},{77.25,85.18},{77.56,85.95},{76.16,84.87},{77.78,86.13},{79.34,57.2},{79.26,56.87},{79.65,55.22},{79.43,56.36},{78.8,55.73},{78.44,56.65},{78.45,56.16},{78.93,55.01},{79.34,54.08},{79.24,54.22},{79.46,50.74},{79.42,47.96},{79.46,48.2},{79.16,47.39},{79.36,47.7},{80.31,45.24},{79.19,45.21},{79.12,45.99},{79.48,45.36},{79.34,45.25},{79.54,47.18},{79.51,46.31},{79.96,46.28},{78.83,44.53},{77.95,45.11},{78.6,44.91},{78.23,44.87},{79.47,43.52},{78.57,43.17},{77.9,44.36},{77.74,44.28},{77.31,44.1},{78.56,42.09},{79.39,58.05},{75.56,86.58},{76.27,86.46},{75.86,85.94},{74.74,85.27}}},nil,12,nil,nil,18,nil,nil,0},
[48] = {'Skeletal Warrior',531,573,21,22,0,{[10]={{77.41,73.76},{76.91,72.2},{78.96,69.68},{80.34,72.03},{77.68,71.76},{76.88,70.25},{78.63,70.85},{80.57,70.2},{79.78,68.75},{82.14,68.7},{80.84,73.82},{79.75,73.0},{80.61,66.66},{81.03,69.32},{78.03,67.01}}},nil,10,nil,nil,21,nil,nil,0},
[49] = {'Lesser Succubus',484,484,20,20,0,nil,nil,0,nil,nil,90,nil,nil,0},
[54] = {'Corina Steele',198,198,10,10,0,{[12]={{41.53,65.9}}},{[12]={{{41.32,65.7},{41.53,65.88},{41.53,65.88},{41.53,65.88}}}},12,nil,nil,12,"A","Weaponsmith",16388},
[55] = {'Mean Ed the Blacksmith',484,484,20,20,0,nil,nil,0,nil,nil,12,"A",nil,0},
[60] = {'Ruklar the Trapper',148,148,8,8,0,{[12]={{64.64,56.65}}},nil,12,nil,nil,26,nil,nil,0},
[61] = {'Thuros Lightfingers',222,222,11,11,4,{[12]={{52.66,58.91},{28.58,59.92},{29.23,58.0},{30.81,57.12},{50.51,82.93},{50.94,83.1},{89.94,79.45},{89.3,79.28}}},nil,12,nil,nil,17,nil,nil,0},
[62] = {'Gug Fatcandle',81,81,4,4,0,nil,nil,0,nil,nil,26,nil,nil,0},
[65] = {'Peasant Woman',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[66] = {'Tharynn Bouden',198,198,10,10,0,{[12]={{41.82,67.16}}},nil,12,nil,nil,12,"A","Trade Supplies",4},
[68] = {'Stormwind City Guard',5228,5228,55,55,0,{[1519]={{51.47,27.87},{42.55,40.68},{32.96,64.5},{42.55,60.07},{38.55,58.53},{38.36,58.15},{62.46,64.18},{57.06,60.93},{60.61,67.98},{64.18,73.56},{59.93,68.81},{62.76,74.91},{55.43,67.88},{62.4,61.82},{55.1,68.14},{55.22,44.3},{59.93,45.25},{55.42,44.69},{59.69,45.56},{42.96,59.66},{48.95,62.23},{63.55,76.54},{64.85,74.89},{69.96,89.21},{71.48,87.39}},[12]={{32.08,49.95},{32.47,49.51}}},nil,1519,nil,nil,11,"A",nil,1},
[69] = {'Timber Wolf',55,55,2,2,0,{[12]={{45.91,40.31},{46.66,39.39},{49.41,37.75},{47.77,37.63},{48.15,34.91},{46.15,35.53},{46.25,36.73},{48.51,33.67},{46.34,34.42},{45.2,35.15},{45.69,34.96},{46.96,34.46},{50.59,36.03},{52.74,35.14},{51.24,40.45},{52.51,39.15},{53.07,38.74},{52.53,42.19},{51.53,43.7},{50.89,44.37},{51.61,42.38},{49.9,46.59},{49.48,49.26},{49.34,47.49},{51.45,45.58},{50.38,44.94}}},nil,12,nil,nil,32,"AH",nil,0},
[71] = {'Rankist',102,137,5,7,0,nil,nil,0,nil,nil,14,nil,nil,0},
[73] = {'Veraina the Apothecary',1753,1753,40,40,0,nil,nil,0,nil,nil,35,"AH","Questgiver",0},
[74] = {'Kurran Steele',198,198,10,10,0,{[12]={{41.37,65.59}}},nil,12,nil,nil,12,"A","Cloth & Leather Armor Merchant",16388},
[78] = {'Janos Hammerknuckle',102,102,5,5,0,{[12]={{47.24,41.9}}},nil,12,nil,nil,12,"A","Weaponsmith",16388},
[79] = {'Narg the Taskmaster',257,257,10,10,4,{[12]={{40.91,77.52}}},nil,12,nil,nil,26,nil,nil,0},
[80] = {'Kobold Laborer',71,86,3,4,0,{[12]={{47.79,31.64},{48.35,29.87},{48.37,29.25},{48.37,30.27},{47.5,30.29},{47.42,30.06},{48.04,30.28},{48.64,29.13},{49.19,29.02},{49.26,28.34},{50.03,25.52},{48.21,28.59},{48.47,28.05},{48.92,26.37},{49.15,27.75},{48.59,27.34},{48.5,26.62},{50.3,26.71},{49.5,25.84},{50.16,26.34},{50.48,26.87},{50.13,27.03},{47.81,31.09},{49.0,28.35},{49.49,27.98}}},nil,12,nil,nil,26,nil,nil,0},
[82] = {'Crazy Leonetti',137,137,7,7,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[87] = {'Forest Troll Berserker',55,86,2,4,0,nil,nil,0,nil,nil,14,nil,nil,0},
[89] = {'Infernal',3544,3544,50,50,0,nil,nil,0,nil,nil,954,nil,nil,0},
[90] = {'Sea Giant',1524,1524,40,40,0,nil,nil,0,nil,nil,14,nil,nil,0},
[92] = {'Rock Elemental',1678,1753,39,40,0,{[3]={{45.45,81.39},{44.34,83.94},{42.79,88.19},{44.23,85.82},{43.02,86.27},{44.51,82.25},{43.32,84.2},{42.92,82.01},{46.1,77.64},{44.43,80.59},{42.62,78.39},{36.64,74.08},{36.11,75.73},{35.08,75.42},{39.04,77.75},{41.8,77.06},{40.44,75.76},{38.46,73.51},{40.51,78.29},{40.97,79.29},{41.8,83.65},{41.3,82.19},{37.42,75.92},{15.04,35.29},{13.86,36.28},{11.98,34.27},{14.8,33.85},{13.44,33.43},{15.52,32.21},{16.56,36.15}}},nil,3,nil,nil,91,nil,nil,0},
[93] = {'Centaur',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[94] = {'Defias Cutpurse',102,120,5,6,0,{[12]={{40.83,56.62},{37.55,55.21},{39.09,53.89},{41.85,53.78},{41.8,52.83},{41.7,52.67},{41.51,52.84},{40.92,53.76},{39.94,55.22},{42.81,56.55},{42.61,51.94},{42.83,53.58},{41.93,55.07},{44.63,56.65},{43.8,55.08},{42.93,51.14},{43.77,50.84},{38.38,57.87},{37.29,55.25},{36.13,58.22},{36.9,66.21},{36.25,66.84},{36.29,65.9},{35.25,66.97},{30.4,65.89},{29.46,65.4},{31.07,67.23},{30.68,66.54},{31.96,65.68},{29.99,68.19}}},nil,12,nil,nil,17,nil,nil,0},
[95] = {'Defias Smuggler',222,247,11,12,0,{[40]={{46.59,19.56},{44.18,25.77},{44.73,25.64},{44.92,25.16},{44.01,25.93},{48.36,20.29},{48.42,19.86},{46.34,39.69},{41.42,40.59},{46.49,37.63},{46.58,37.82},{41.14,41.77},{46.6,53.36},{48.23,47.04},{48.23,46.61},{45.49,21.72},{46.0,19.42},{45.35,21.2},{44.53,21.54},{44.72,26.27},{45.28,26.9},{45.82,39.63},{40.8,40.87},{41.84,40.47},{46.19,39.06},{45.74,20.5},{43.92,26.84},{45.52,20.99},{45.03,18.77},{46.0,18.88},{44.55,24.81},{45.53,18.06},{44.08,23.34},{45.8,26.58},{45.85,25.62},{50.09,18.43},{49.41,19.19},{50.58,47.31},{51.56,46.64},{49.71,42.06},{50.77,40.08},{51.24,40.44},{49.52,46.43},{48.54,45.12}}},nil,40,nil,nil,17,nil,nil,0},
[97] = {'Riverpaw Runt',156,176,8,9,0,{[12]={{26.46,86.65},{25.07,88.88},{27.73,86.64},{27.7,86.13},{25.27,89.35},{26.2,91.7},{26.07,91.71},{27.66,88.32},{28.34,87.38},{24.34,93.62},{30.85,89.13},{30.76,82.85},{31.6,80.64},{68.59,46.46},{67.83,46.44},{68.37,45.35},{68.41,44.9},{68.09,39.41},{68.82,39.53},{65.94,39.3},{66.63,39.45},{66.4,41.32},{66.33,40.62},{70.81,39.2},{69.24,38.98},{68.68,38.24}}},nil,12,nil,nil,20,nil,nil,0},
[98] = {'Riverpaw Taskmaster',386,417,17,18,0,{[40]={{56.51,70.11},{56.32,74.38},{56.45,74.05},{56.39,74.48},{59.98,69.15},{60.42,70.85},{59.43,74.1},{60.94,74.47},{61.02,74.22},{60.9,74.07},{60.8,74.49},{61.84,77.83},{60.9,77.47},{60.8,77.59},{61.03,77.81},{62.78,77.03},{61.62,76.45},{62.67,75.93},{61.94,77.11},{62.26,76.2},{64.07,76.59},{63.34,77.45},{63.56,77.45},{63.37,77.17},{62.84,77.36},{63.67,70.19},{63.82,72.99},{63.48,72.81},{63.68,72.71},{66.7,75.44},{65.34,75.18},{65.3,75.28},{65.27,75.45},{65.08,75.36},{64.59,76.61},{63.88,74.96},{63.54,75.81},{64.69,69.04},{62.56,67.77},{61.21,70.38},{61.82,73.04},{61.7,72.2},{62.87,72.08},{60.5,72.99},{59.39,72.84},{60.9,76.62}}},nil,40,nil,nil,20,nil,nil,0},
[99] = {'Morgaine the Sly',198,198,10,10,4,{[12]={{30.81,64.73}}},nil,12,nil,nil,17,nil,nil,0},
[100] = {'Gruff Swiftbite',247,247,12,12,4,{[12]={{25.39,89.75},{26.09,91.92},{27.93,88.21},{26.35,86.68},{27.72,86.03}}},nil,12,nil,nil,20,nil,nil,0},
[102] = {'Bronze Dragonspawn',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[103] = {'Garrick Padfoot',102,102,5,5,0,{[12]={{57.52,48.25}}},nil,12,nil,nil,17,nil,nil,0},
[105] = {'Tall Strider',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[106] = {'Kodo Beast',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[107] = {'Raptor',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[108] = {'Green Dragonspawn',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[109] = {'White Dragonspawn',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[111] = {'Priest',71,86,3,4,0,nil,nil,0,nil,nil,12,"A",nil,0},
[112] = {'Priestess',71,86,3,4,0,nil,nil,0,nil,nil,12,"A",nil,0},
[113] = {'Stonetusk Boar',102,120,5,6,0,{[12]={{44.11,69.38},{40.92,69.51},{39.87,69.69},{38.85,68.7},{37.62,70.78},{38.09,75.42},{30.94,84.12},{31.68,80.07},{32.35,81.45},{31.14,81.0},{31.32,82.62},{31.46,85.96},{32.19,83.91},{32.03,86.65},{31.92,85.85},{33.4,86.63},{33.37,85.14},{33.31,89.71},{33.78,89.39},{35.2,89.81},{35.34,87.78},{33.98,81.31},{33.03,80.16},{38.75,78.61},{37.07,76.83},{40.95,85.03},{41.55,85.84},{38.56,86.16},{41.7,77.71},{39.05,76.8},{41.77,75.27},{38.11,89.25},{36.97,88.58},{37.37,89.93},{38.78,90.08},{37.81,90.69},{36.23,91.34},{39.59,90.76},{40.95,91.92},{40.84,89.92},{40.95,88.34},{39.74,88.46},{41.76,86.51},{40.99,86.78},{41.76,88.12},{42.9,86.56},{42.56,73.22},{40.97,75.3},{43.72,72.28},{42.66,71.46},{40.65,70.75}}},nil,12,nil,nil,189,"AH",nil,0},
[114] = {'Harvest Watcher',300,328,14,15,0,{[40]={{38.0,47.84},{38.99,54.81},{49.88,21.29},{39.01,49.31},{50.09,22.56},{52.99,23.11},{40.76,52.19},{51.48,24.89},{38.14,50.79},{37.44,49.32},{50.98,23.16},{38.05,53.51},{36.14,50.85},{40.01,50.99},{39.14,52.09},{39.89,53.5},{52.01,23.44},{37.15,52.26},{51.7,21.73},{51.09,20.12},{43.65,35.13},{45.04,33.28},{45.61,33.21},{46.91,35.12},{45.9,36.14},{43.8,36.52},{53.9,35.16},{52.23,32.39},{54.01,30.98},{43.04,36.02},{54.35,32.19},{53.15,30.63},{53.29,33.63},{44.66,37.98},{55.29,33.7}}},nil,40,nil,nil,14,nil,nil,0},
[115] = {'Harvest Reaper',386,417,17,18,0,{[40]={{65.74,61.1},{65.64,62.08},{64.61,61.86},{65.23,61.27},{60.92,60.91},{62.97,57.68},{62.29,59.2},{65.03,60.33},{63.64,61.35},{61.58,62.0}}},nil,40,nil,nil,14,nil,nil,0},
[116] = {'Defias Bandit',156,176,8,9,0,{[12]={{31.02,57.51},{29.19,58.33},{29.54,57.91},{29.09,58.94},{29.88,58.22},{30.7,64.89},{30.59,65.04},{30.23,64.73},{30.34,64.53},{30.92,65.16},{31.34,64.88},{31.23,65.08},{44.37,74.93},{45.95,73.8},{46.35,75.41},{45.56,76.24},{47.48,74.13},{47.52,81.24},{46.79,82.98},{48.73,83.26},{46.6,85.53},{47.8,83.12},{49.69,83.85},{49.67,80.93},{50.6,82.99},{50.54,83.13},{68.28,77.72},{67.75,77.99},{68.12,80.49},{68.44,81.96},{71.31,76.71},{70.67,78.95},{68.46,77.36},{68.63,76.67},{70.71,81.53},{55.27,59.94},{52.51,59.06},{52.08,59.17},{52.21,59.39},{88.84,78.2},{89.19,79.2},{88.81,80.02},{89.6,79.35},{89.4,80.17},{89.94,78.21},{89.96,79.99},{90.2,79.09},{26.22,58.72},{25.7,58.49},{25.33,58.4},{25.16,57.79},{25.03,58.27},{24.71,58.39},{24.65,58.71},{24.37,58.35},{23.86,58.93},{23.68,59.04}}},nil,12,nil,nil,17,nil,nil,0},
[117] = {'Riverpaw Gnoll',222,247,11,12,0,{[40]={{57.87,13.24},{56.32,12.73},{56.56,12.95},{56.92,12.96},{56.29,13.38},{56.48,13.48},{52.33,14.06},{51.95,15.11},{52.11,14.79},{52.16,14.11},{44.74,13.95},{44.9,13.62},{44.63,16.24},{44.58,14.84},{44.98,14.35},{41.0,20.69},{41.93,20.52},{40.83,22.04},{45.61,16.6},{42.32,19.93},{41.7,19.38},{45.32,13.06},{56.65,14.31},{57.17,14.21}}},nil,40,nil,nil,20,nil,nil,0},
[118] = {'Prowler',176,198,9,10,0,{[12]={{75.49,76.54},{75.46,74.18},{76.63,63.67},{72.28,65.76},{72.39,65.15},{71.83,65.29},{72.26,64.82},{66.65,45.18},{64.61,43.33},{69.9,40.85},{70.53,41.86},{70.71,39.24},{71.43,37.45},{72.13,41.06},{77.45,74.47},{76.17,77.89},{76.16,75.97},{77.26,76.48},{77.76,78.09},{80.19,83.25},{80.28,81.12},{82.06,83.82},{80.72,81.38},{80.51,80.74},{80.81,81.16},{80.56,80.23},{81.29,82.53},{83.63,84.12},{83.01,85.51},{85.02,82.92},{80.58,78.82},{80.29,78.2},{81.48,77.9},{81.81,77.18},{79.03,76.18},{79.18,61.81},{78.38,62.72},{81.93,60.72},{79.99,60.74},{77.7,61.68},{78.58,60.85},{78.92,41.52},{77.46,40.88},{75.22,40.41},{76.58,40.56},{75.16,39.68},{73.67,40.46},{73.61,39.99},{75.41,37.33},{73.62,38.11},{74.06,37.59},{83.2,59.68},{80.32,78.12},{79.26,79.7},{79.17,82.75},{85.82,85.21},{85.66,83.94},{87.11,79.37},{87.14,77.41},{85.92,72.31},{83.83,71.99},{88.02,72.11},{87.36,68.46},{86.87,66.06},{88.67,68.58},{88.72,70.87},{87.76,63.75},{85.06,61.96},{85.02,61.97},{86.36,64.18},{86.35,63.78},{84.56,61.23},{85.9,61.25},{87.29,68.79},{87.86,78.32},{88.78,77.4},{89.63,75.0},{87.4,81.83},{87.6,81.27},{89.98,82.38},{91.14,78.83},{90.51,77.71},{87.05,69.21}}},nil,12,nil,nil,38,nil,nil,0},
[119] = {'Longsnout',198,222,10,11,0,{[12]={{25.48,82.24},{25.7,79.76},{25.01,84.77},{24.65,86.95},{24.33,83.75},{26.42,82.31},{24.28,82.66},{24.56,88.49},{24.97,85.8}}},nil,12,nil,nil,189,"AH",nil,0},
[120] = {'Forest Stalker',176,198,9,10,0,nil,nil,0,nil,nil,22,nil,nil,0},
[121] = {'Defias Pathstalker',328,356,15,16,0,{[40]={{38.73,69.91},{38.98,69.39},{36.99,75.22},{37.41,75.38},{37.36,75.7},{49.33,77.33},{52.75,73.48},{51.2,75.18},{50.36,78.45},{46.18,79.2},{36.02,76.93}}},nil,40,nil,nil,17,nil,nil,0},
[122] = {'Defias Highwayman',386,417,17,18,0,{[40]={{46.38,78.29},{52.15,75.26},{52.55,73.76},{52.06,72.87},{52.66,78.42},{53.27,78.97},{53.05,78.75},{53.13,79.1},{50.84,75.21},{49.36,76.58},{46.91,81.1},{43.3,79.74},{39.02,79.31},{42.05,80.53},{41.01,79.47},{36.82,82.39},{37.1,82.52},{37.06,82.02},{37.08,80.48},{38.02,81.27},{38.09,80.64},{37.37,80.41},{48.14,77.25},{51.66,77.21},{60.76,58.23},{60.61,58.2}}},nil,40,nil,nil,17,nil,nil,0},
[123] = {'Riverpaw Mongrel',273,300,13,14,0,{[40]={{34.08,25.71},{32.8,29.37},{34.41,26.77},{34.31,26.6},{34.16,26.88},{34.04,27.64},{33.94,26.4},{37.49,34.1},{35.58,31.31},{36.61,31.59},{36.62,32.14},{39.13,31.74},{38.15,28.55},{30.13,49.41},{30.22,49.34},{30.09,49.8},{30.18,49.86},{30.46,50.74},{29.77,48.06},{30.42,47.99},{31.29,52.59},{30.39,52.4},{30.41,52.01},{30.68,51.85},{29.97,56.58},{30.26,57.93},{30.41,57.91},{30.32,58.1},{30.41,57.74},{28.93,64.71},{28.63,65.43},{29.19,66.08},{29.39,65.43},{29.46,65.31},{29.75,63.79},{29.93,66.25},{31.5,72.37},{31.32,72.09},{31.49,72.07},{35.51,61.52},{35.94,61.59},{36.79,31.7},{36.8,32.01},{29.91,59.6},{29.48,49.67}}},nil,40,nil,nil,20,nil,nil,0},
[124] = {'Riverpaw Brute',328,356,15,16,0,{[40]={{30.72,69.83},{32.15,69.03},{31.35,67.68},{31.02,69.34},{31.2,69.4},{32.63,68.52},{32.65,68.16},{32.52,68.52},{32.53,68.29},{32.83,69.14},{31.51,71.32},{31.23,72.94},{31.28,72.39},{48.17,61.92},{48.24,60.9},{48.35,60.83},{48.64,62.36},{53.32,60.79},{52.96,62.27},{52.9,62.79},{28.99,49.11},{64.93,73.16},{57.31,70.52},{30.37,67.77},{49.54,61.95},{52.14,63.12}}},nil,40,nil,nil,20,nil,nil,0},
[125] = {'Riverpaw Overseer',449,449,19,19,0,{[40]={{60.89,77.79},{63.48,77.56}}},nil,40,nil,nil,20,nil,nil,0},
[126] = {'Murloc Coastrunner',247,273,12,13,0,{[40]={{43.92,7.93},{44.9,8.18},{53.24,11.12},{53.13,8.86},{54.11,9.58},{45.37,8.21},{55.91,7.58},{44.47,8.75},{42.0,12.12},{47.41,9.38},{47.38,9.94},{44.69,7.87},{42.48,12.34},{42.7,12.33},{56.47,8.81},{41.97,9.71},{43.23,8.14},{42.78,8.99},{53.42,11.2},{45.02,8.89},{42.54,11.38},{55.72,8.95},{56.28,9.59},{55.78,8.15},{51.99,9.26}}},nil,40,nil,nil,18,nil,nil,0},
[127] = {'Murloc Tidehunter',377,404,18,19,0,{[40]={{28.44,70.33},{26.85,73.17},{25.9,73.72},{27.93,74.54},{26.63,73.84},{26.22,71.7},{26.46,74.78},{27.99,69.19},{28.19,69.29},{34.14,86.33},{34.58,84.31},{34.85,84.49},{34.77,84.22},{25.51,74.04},{26.77,72.12},{27.06,71.73},{26.59,71.99},{27.99,75.67},{35.35,84.24},{35.05,85.29},{35.04,85.41},{34.58,86.19}}},nil,40,nil,nil,18,nil,nil,0},
[128] = {'Angry Programmer Tweedle Dee',2961,2961,59,59,0,nil,nil,0,nil,nil,18,nil,"Testing",0},
[129] = {'Angry Programmer Tweedle Dum',2215,3331,50,63,0,nil,nil,0,nil,nil,14,nil,nil,0},
[130] = {'Programmer Vendor',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[151] = {'Brog Hamfist',198,198,10,10,0,{[12]={{43.96,65.92}}},nil,12,nil,nil,12,"A","General Supplies",4},
[152] = {'Brother Danil',102,102,5,5,0,{[12]={{47.49,41.56}}},nil,12,nil,nil,12,"A","General Supplies",4},
[153] = {'Bethina',1220,1220,35,35,0,nil,nil,0,nil,nil,12,"A","iCoke Redemption Vendor",0},
[154] = {'Greater Fleshripper',356,386,16,17,0,{[40]={{27.08,42.4},{26.58,44.1},{26.41,42.57},{61.93,49.25},{62.69,50.6},{59.4,52.32},{61.14,54.85},{63.86,55.1},{58.66,60.42},{59.41,62.69},{58.84,64.2},{62.56,60.65},{59.07,59.33}}},nil,40,nil,nil,73,nil,nil,0},
[157] = {'Goretusk',300,328,14,15,0,{[40]={{33.74,31.0},{39.13,27.87},{37.83,41.02},{41.18,33.18},{35.37,36.62},{33.63,37.86},{61.28,44.95},{60.91,47.67},{60.09,45.48},{59.75,42.52},{59.08,43.65},{45.11,50.54},{44.37,45.09},{38.1,42.55},{41.92,38.77},{43.87,52.16},{44.71,56.93},{48.3,52.61},{45.58,55.42},{43.97,39.63},{42.95,48.95},{57.12,59.2},{47.19,62.19},{46.43,55.97},{45.35,62.1},{51.2,59.03},{54.13,59.03},{53.88,64.89},{45.58,57.42},{41.28,57.62},{37.25,71.95},{39.44,60.89},{31.71,75.85},{37.18,63.65},{35.68,80.79},{35.21,69.35},{37.17,60.18},{43.71,62.16},{38.11,66.32},{46.33,51.78},{44.76,49.21},{42.86,43.57},{40.91,44.82},{31.68,78.15},{42.35,64.14},{34.73,79.4},{34.26,77.81},{40.79,39.81},{59.7,44.57},{56.09,63.73},{49.52,57.45},{44.59,59.08},{35.37,57.95},{51.4,60.62}}},nil,40,nil,nil,189,"AH",nil,0},
[167] = {'Morhan Coppertongue',328,328,15,15,0,{[38]={{34.02,46.54}}},nil,38,nil,nil,55,"A","Metalsmith",16388},
[171] = {'Murloc Warrior',328,356,15,16,0,{[40]={{29.26,32.94},{31.76,26.12},{26.52,40.58},{27.69,39.08},{28.8,35.47},{28.98,35.57},{28.42,33.41},{28.44,32.85},{28.36,32.99},{29.37,27.27},{30.42,26.66},{29.39,28.62},{28.99,27.64},{25.34,48.01},{24.62,48.33},{24.72,48.89},{25.24,49.79},{26.01,47.4},{32.18,26.65},{29.02,34.03},{26.69,38.13},{27.72,33.68},{28.2,33.18},{28.33,29.42},{28.26,28.19},{24.99,48.88},{25.91,50.07},{25.79,47.95},{26.15,49.53},{35.37,21.8},{29.16,31.86},{35.65,20.76},{34.9,20.92}}},nil,40,nil,nil,18,nil,nil,0},
[190] = {'Dermot Johns',102,102,5,5,0,{[12]={{47.56,41.4}}},nil,12,nil,nil,12,"A","Cloth & Leather Armor Merchant",16388},
[192] = {'Ice Troll',4370,4370,62,62,0,nil,nil,0,nil,nil,37,nil,nil,0},
[193] = {'Blue Dragonspawn',6645,6876,50,51,1,{[16]={{39.5,76.38},{36.88,78.69},{36.88,75.82},{37.54,73.74},{36.36,72.88},{36.39,73.71},{36.37,74.64}}},nil,16,nil,nil,60,nil,nil,0},
[196] = {'Eagan Peltskinner',71,71,3,3,0,{[12]={{48.94,40.16}}},nil,12,{33},{33,5261},12,"A",nil,2},
[197] = {'Marshal McBride',484,484,20,20,0,{[12]={{48.92,41.61}}},nil,12,{7,15,21,54,3100,3101,3102,3103,3104,3105},{7,15,21,783},12,"A",nil,3},
[198] = {'Khelden Bremen',102,102,5,5,0,{[12]={{49.66,39.4}}},nil,12,nil,{3104},12,"A","Mage Trainer",19},
[199] = {'Young Fleshripper',198,222,10,11,0,{[40]={{52.43,18.72},{55.21,17.64},{49.53,24.7},{56.21,24.6},{58.83,13.86},{44.64,20.09},{47.82,18.22},{48.4,27.78},{59.85,32.32},{60.04,39.8},{61.29,40.17},{60.93,27.97},{61.0,29.33},{61.84,35.31},{62.83,27.84},{60.12,24.21},{48.93,35.86},{51.87,27.69},{52.73,35.7},{45.99,29.02},{49.41,37.23},{51.36,42.23},{43.58,18.8},{38.16,19.92},{38.08,32.12},{42.94,25.12},{54.17,39.78},{53.68,43.89},{50.58,16.31},{42.97,33.75},{36.26,26.47},{41.95,16.46},{48.45,39.97},{57.15,39.72},{48.41,30.19}}},nil,40,nil,nil,73,nil,nil,0},
[200] = {'Shambling Skeleton UNUSED',494,531,20,21,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[201] = {'Brittlebones Skeleton UNUSED',42,42,1,1,0,nil,nil,0,nil,nil,21,nil,nil,0},
[202] = {'Skeletal Horror',617,664,23,24,0,{[10]={{79.67,61.87},{81.71,60.52},{81.09,56.2},{81.99,57.14},{81.01,61.74},{17.79,47.89},{21.55,48.3},{22.29,47.59},{23.06,47.11},{14.53,47.91},{16.35,48.33},{14.06,42.2},{17.65,47.14},{24.19,43.29},{24.58,41.87},{14.38,46.23},{79.4,59.15},{16.29,45.54},{80.14,60.49},{21.26,42.93},{80.64,59.42},{79.23,57.54},{81.15,58.01},{20.58,47.5},{20.56,47.92}}},nil,10,nil,nil,21,nil,nil,0},
[203] = {'Skeletal Mage',472,504,22,23,0,{[10]={{78.15,75.64},{82.02,70.24},{82.04,71.97},{79.54,71.24},{79.71,69.33},{78.85,71.84},{79.58,74.45},{78.59,73.01},{79.77,66.05},{80.93,72.73},{76.92,68.16},{78.25,68.18}}},nil,10,nil,nil,21,nil,nil,0},
[205] = {'Nightbane Dark Runner',896,950,28,29,0,{[10]={{65.44,67.81},{65.64,66.97},{66.42,76.4},{66.0,69.14},{66.07,76.5},{65.6,67.23},{66.35,76.9},{65.44,67.71},{65.93,69.41},{65.45,75.72},{66.23,73.96},{66.09,75.06},{65.13,67.39},{65.56,77.48},{67.25,77.5},{63.69,73.44},{64.39,73.12},{63.95,73.72},{62.23,74.27},{60.55,75.31},{62.78,75.67},{61.61,75.49},{61.22,76.11},{60.92,75.19},{64.06,72.65},{60.38,74.47},{63.7,75.48},{61.1,73.35},{64.82,65.99},{65.58,65.92},{66.31,67.88},{64.59,69.21},{67.3,69.24},{65.15,70.01},{66.31,44.84},{67.59,45.86},{67.13,49.61},{66.24,47.75},{63.85,40.9},{62.14,42.74},{60.75,41.01},{60.09,40.91},{60.44,42.24},{60.03,39.6},{64.14,51.65},{62.19,38.8},{61.17,41.26},{60.75,41.5},{60.57,39.92},{60.0,45.24},{63.98,49.83},{64.28,50.85},{64.66,51.87},{63.24,50.77},{60.92,39.76},{60.89,41.69},{63.61,51.67}}},nil,10,nil,nil,24,nil,nil,0},
[206] = {'Nightbane Vile Fang',950,1003,29,30,0,{[10]={{62.64,79.82},{61.62,82.22},{62.69,79.23},{61.82,80.97},{61.9,81.86},{73.5,68.54},{72.41,67.38},{71.57,71.66},{71.94,72.31},{71.06,71.49},{71.76,72.84},{72.93,72.09},{72.04,74.71},{73.73,69.9},{72.45,69.58},{73.31,70.68},{72.32,70.19},{72.3,68.41},{73.01,72.72},{72.55,73.61},{73.38,72.59}}},nil,10,nil,nil,24,nil,nil,0},
[210] = {'Bone Chewer',788,840,26,27,0,{[10]={{25.54,28.1},{19.3,26.44},{17.86,28.45},{22.41,35.66},{25.8,32.88},{22.9,34.22},{24.34,37.54},{23.22,32.79},{24.76,34.69},{25.1,35.94}}},nil,10,nil,nil,21,nil,nil,0},
[211] = {'Ogre',950,1003,29,30,0,nil,nil,0,nil,nil,45,nil,nil,0},
[212] = {'Splinter Fist Warrior',950,1003,29,30,0,{[10]={{35.3,79.35},{36.76,78.82},{36.57,80.01},{36.64,77.41},{33.08,75.21},{33.67,76.02},{34.68,75.65},{32.89,71.11},{32.37,70.27},{32.24,69.06},{32.88,69.56}}},nil,10,nil,nil,45,nil,nil,0},
[213] = {'Starving Dire Wolf',449,484,19,20,0,{[10]={{12.55,66.75},{86.21,16.15},{38.95,19.64},{36.72,21.57},{35.63,24.52},{35.82,20.94},{35.29,21.55},{37.72,19.21},{29.12,28.34},{40.03,19.12},{30.49,25.57},{31.57,27.15},{31.55,24.37},{43.93,20.35},{42.46,18.66},{41.26,20.49},{33.64,24.48},{45.01,18.51},{32.41,22.62},{33.56,26.75},{16.48,22.94},{10.82,29.53},{12.63,28.3},{22.0,28.96},{23.38,27.99},{22.58,25.95},{19.28,24.01},{17.36,23.26},{28.16,26.08},{25.38,25.99},{27.33,26.35},{77.09,19.09},{80.4,18.72},{57.81,15.58},{58.77,16.9},{63.93,17.11},{10.69,47.85},{46.55,16.77}}},nil,10,nil,nil,38,nil,nil,0},
[215] = {'Defias Night Runner',664,713,24,25,0,{[10]={{21.19,65.52},{21.3,65.47},{24.78,69.29},{22.86,68.35},{22.0,70.69},{20.12,67.97},{23.92,64.33},{50.73,71.37},{50.04,74.02},{49.0,72.2},{48.54,70.15},{48.98,74.3},{56.38,72.56},{53.08,74.66},{50.85,74.97},{52.09,76.84}}},nil,10,nil,nil,17,nil,nil,0},
[217] = {'Venom Web Spider',449,484,19,20,0,{[10]={{73.77,20.04},{56.25,14.55},{15.66,66.84},{17.25,67.56},{15.0,68.09},{70.81,21.59},{14.48,67.5},{78.0,24.25},{68.62,20.24},{15.7,72.62},{15.25,71.3},{66.7,20.77},{54.15,16.65},{60.21,18.62},{13.11,47.46},{10.47,44.65},{41.79,20.83},{47.62,17.9},{31.89,26.58},{18.85,27.31},{10.72,37.97},{9.25,40.01},{12.1,46.0},{62.49,18.47},{52.24,16.93},{22.09,28.19},{16.91,25.82},{57.47,18.56},{76.03,19.94},{49.81,18.31},{10.76,46.63},{11.2,54.81},{66.61,18.78},{66.2,18.1}}},nil,10,nil,nil,22,nil,nil,0},
[218] = {'Grave Robber',664,713,24,25,0,{[10]={{14.78,44.39},{14.54,44.4},{14.6,44.53}}},nil,10,nil,nil,17,nil,nil,0},
[221] = {'Dannus',386,386,17,17,0,nil,nil,0,nil,nil,12,"A","Merchant",0},
[222] = {'Nillen Andemar',449,449,19,19,0,{[38]={{42.87,9.89}}},nil,38,nil,nil,55,"A","Macecrafter",16388},
[223] = {'Dan Golthas',617,617,23,23,0,{[1497]={{70.93,58.41}}},nil,1497,nil,nil,68,"H","Journeyman Leatherworker",19},
[224] = {'Zek Marston',328,328,15,15,0,nil,nil,0,nil,nil,12,"A","Weapon Peddler",0},
[225] = {'Gavin Gnarltree',1003,1003,30,30,0,{[10]={{73.6,50.04}}},{[10]={{{73.48,50.0},{73.64,49.6},{73.73,49.37},{73.81,49.09},{73.69,48.86},{73.61,48.9},{73.79,49.17},{73.71,49.41},{73.65,49.61},{73.6,50.04}}}},10,nil,nil,12,"A","Weaponsmith",16388},
[226] = {'Morg Gnarltree',895,895,28,28,0,{[10]={{73.97,48.89}}},{[10]={{{73.98,48.87},{73.71,48.55},{73.68,48.55},{73.68,48.53},{73.97,48.89}}}},10,nil,nil,12,"A","Armorer",16388},
[227] = {'Mabel Solaj',788,788,26,26,0,{[10]={{74.21,44.81}}},nil,10,nil,nil,12,"A","General Goods Vendor",4},
[228] = {'Avette Fellwood',664,664,24,24,0,{[10]={{73.03,44.42}}},{[10]={{{73.27,44.76},{73.27,44.81},{73.03,44.47}}}},10,nil,nil,12,"A","Bowyer",16388},
[229] = {'Vaious',57,57,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[230] = {'Thornton Fellwood',44,44,1,1,0,nil,nil,0,nil,nil,35,"AH","Woodcrafter",0},
[232] = {'Farmer Ray',617,617,23,23,0,{[267]={{33.22,34.76}}},nil,267,nil,nil,88,"A",nil,0},
[233] = {'Farmer Saldean',484,484,20,20,0,{[40]={{56.04,31.23}}},nil,40,{9,109},{9},12,"A",nil,7},
[234] = {'Gryan Stoutmantle',2440,2440,35,35,1,{[40]={{56.33,47.52}}},nil,40,{12,13,14,65,135,142,144,166},{12,13,14,109,132,141,142,143,155,166},11,"A","The People's Militia",2},
[235] = {'Salma Saldean',484,484,20,20,0,{[40]={{56.42,30.52}}},nil,40,{22,38},{22,36,38},12,"A",nil,2},
[237] = {'Farmer Furlbrow',484,484,20,20,0,{[40]={{59.95,19.36}}},nil,40,{64,109},{64,184},12,"A",nil,2},
[238] = {'Verna Furlbrow',484,484,20,20,0,{[40]={{59.92,19.42}}},nil,40,{36,151},{151},12,"A",nil,2},
[239] = {'Grimbooze Thunderbrew',484,484,20,20,0,{[40]={{44.62,80.25}}},nil,40,{48,49,50,51,53,117},{48,49,50,51,53,117},55,"A",nil,3},
[240] = {'Marshal Dughan',712,712,25,25,0,{[12]={{42.11,65.93}}},nil,12,{35,59,62,76,109,147,239},{39,40,54,62,76,123,147,176},12,"A",nil,3},
[241] = {'Remy "Two Times"',102,102,5,5,0,{[12]={{42.14,67.26}}},nil,12,{40,47},{47},12,"A",nil,2},
[242] = {'Horras Brackwell',198,198,10,10,0,nil,nil,0,nil,nil,12,"A",nil,0},
[244] = {'Ma Stonefield',71,71,3,3,0,{[12]={{34.66,84.48}}},nil,12,{88},{88},12,"A",nil,2},
[246] = {'"Auntie" Bernice Stonefield',120,120,6,6,0,{[12]={{34.49,84.25}}},nil,12,{84,85},{86,87},12,"A",nil,2},
[247] = {'Billy Maclure',42,42,1,1,0,{[12]={{43.13,85.72}}},nil,12,{86,87},{84,85},12,"A",nil,2},
[248] = {'Gramma Stonefield',71,71,3,3,0,{[12]={{34.94,83.86}}},nil,12,{107},{111},12,"A",nil,2},
[250] = {'Pa Maclure',120,120,6,6,0,{[12]={{42.72,89.24}}},nil,12,nil,nil,12,"A",nil,2},
[251] = {'Maybell Maclure',55,55,2,2,0,{[12]={{43.15,89.62}}},nil,12,{106},{114},12,"A",nil,2},
[252] = {'Tommy Joe Stonefield',55,55,2,2,0,{[12]={{29.84,86.0}}},nil,12,{111},{106},12,"A",nil,2},
[253] = {'William Pestle',120,120,6,6,0,{[12]={{43.32,65.7}}},nil,12,{60,61,112,114},{60,107,112},12,"A",nil,2},
[255] = {'Gerard Tiller',120,120,6,6,0,{[12]={{43.1,85.5}}},nil,12,{16},{16},12,"A",nil,2},
[257] = {'Kobold Worker',70,70,3,3,0,{[12]={{51.52,38.02},{49.18,35.29},{48.22,35.87},{47.25,36.78},{47.45,35.78},{47.17,35.12},{51.06,38.19},{48.73,33.79},{48.9,32.8},{48.09,34.03},{47.98,33.12},{47.53,32.64},{46.84,33.43},{47.36,33.18},{46.55,32.47},{46.3,32.2},{47.35,32.27},{47.4,33.97},{47.61,31.46},{51.27,37.75},{52.09,35.84},{49.82,34.64},{50.23,33.83},{51.57,36.23},{51.02,35.55},{52.15,36.37},{50.83,37.92},{51.51,36.61},{51.66,37.66},{50.17,34.24},{49.93,34.27},{47.91,31.63},{47.7,32.02},{46.27,32.79},{47.22,32.64},{47.07,33.66},{47.64,32.91},{49.31,34.68},{48.4,33.61},{47.63,35.88},{47.5,35.82},{48.83,35.59},{50.05,33.1},{49.65,35.16},{50.12,34.99}}},nil,12,nil,nil,25,nil,nil,0},
[258] = {'Joshua Maclure',102,102,5,5,0,{[12]={{42.36,89.38}}},nil,12,nil,nil,12,"A","Vintner",4},
[261] = {'Guard Thomas',1002,1002,30,30,0,{[12]={{73.97,72.18}}},nil,12,{37,39,46,52,109},{35,46,52,71},12,"A",nil,2},
[262] = {'Half-eaten body',57,57,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[263] = {'Lord Ello Ebonlocke',1002,1002,30,30,0,{[10]={{71.93,46.42}}},nil,10,{146,251,253},{145,160,252,253},12,"A","Mayor of Darkshire",2},
[264] = {'Commander Althea Ebonlocke',5544,5544,45,45,0,{[10]={{73.54,46.82}}},nil,10,{56,57,58,80,98,228,229},{56,57,58,79,97,227,228},53,"A","Leader of The Night Watch",2},
[265] = {'Madame Eva',712,712,25,25,0,{[10]={{75.79,45.32}}},nil,10,{66,101,149,157,265},{98,101,148,154,262},12,"A",nil,2},
[266] = {'Wiley the Black',787,787,26,26,0,{[44]={{26.48,45.35}}},nil,44,{132},{65},12,"A",nil,2},
[267] = {'Clerk Daltry',1106,1106,31,31,0,{[10]={{72.54,46.87}}},nil,10,{67,69,97,266,1042},{66,68,80,265,1041},12,"A",nil,2},
[268] = {'Sirra Von\'Indi',664,664,24,24,0,{[10]={{72.62,47.62}}},nil,10,{227,252,401},{225,251,401},12,"A","Historian of Darkshire",2},
[269] = {'Role Dreuger',1752,1752,40,40,0,{[10]={{71.98,46.7}}},nil,10,nil,nil,12,"A","Deputy Mayor of Darkshire",0},
[270] = {'Councilman Millstipe',895,895,28,28,0,{[10]={{71.92,47.79}}},nil,10,{377},{377},12,"A","Council of Darkshire",2},
[271] = {'Ambassador Berrybuck',1002,1002,30,30,0,{[10]={{72.14,47.31}}},nil,10,nil,nil,12,"A","Council of Darkshire",2},
[272] = {'Chef Grual',1002,1002,30,30,0,{[10]={{73.75,43.48}}},{[10]={{{73.83,43.19},{73.84,43.44},{73.89,43.45},{73.87,43.45},{73.9,43.95},{73.83,44.06},{73.85,44.05},{73.89,43.92},{73.8,43.48},{73.75,43.48}}}},10,{90,93,240},{5,90,93},12,"A",nil,2},
[273] = {'Tavernkeep Smitts',573,573,22,22,0,{[10]={{73.78,44.49}}},nil,10,{79,156,159,453},{78,156,158,266},12,"A",nil,2},
[274] = {'Barkeep Hann',787,787,26,26,0,{[10]={{73.66,44.05}}},nil,10,nil,nil,12,"A","Bartender",4},
[275] = {'Whit Wantmal',840,840,27,27,0,{[10]={{78.99,44.35}}},nil,10,nil,nil,12,"A",nil,2},
[276] = {'Viktori Prism\'Antras',895,895,28,28,0,{[10]={{79.8,48.02}}},nil,10,{174,175,181},{174,177,181},12,"A",nil,2},
[277] = {'Roberto Pupellyverbos',1002,1002,30,30,0,{[1519]={{52.15,67.75}}},nil,1519,nil,nil,12,"A","Merlot Connoisseur",5},
[278] = {'Sara Timberlain',102,102,5,5,0,{[12]={{79.46,68.79}}},nil,12,{83},{59,83},12,"A",nil,2},
[279] = {'Morgan Pestle',1002,1002,30,30,0,{[1519]={{56.2,64.58}}},nil,1519,{9025},{61,9024},12,"A",nil,2},
[280] = {'Placeholder - Jasperlode Mine',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Area Trigger",0},
[281] = {'Kobold Tank',137,156,7,8,0,nil,nil,0,nil,nil,14,nil,nil,0},
[282] = {'Kobold Spellcaster',137,156,7,8,0,nil,nil,0,nil,nil,14,nil,nil,0},
[283] = {'Kobold Healer',131,148,7,8,0,nil,nil,0,nil,nil,16,nil,nil,0},
[284] = {'Riding Horse (Brown)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[285] = {'Murloc',120,137,6,7,0,{[12]={{56.67,66.28},{56.65,66.54},{56.47,66.69},{56.75,67.45},{56.04,66.79},{56.85,66.86},{53.7,66.76},{53.8,65.53},{49.83,66.41},{50.55,66.24},{56.97,67.25},{56.69,65.91},{55.85,67.64},{55.3,66.16},{55.64,66.73},{55.43,66.8},{54.9,66.75},{55.37,66.33},{54.95,66.44},{55.17,66.14},{54.53,66.67},{54.58,66.87},{54.44,66.79},{54.33,66.81},{54.41,66.33},{54.82,65.31},{53.97,66.36},{52.0,68.73},{51.16,67.09},{50.7,67.13},{50.29,67.63},{50.38,66.2},{50.18,66.83}}},nil,12,nil,nil,18,nil,nil,0},
[286] = {'Old Rotten Gill',222,222,11,11,0,nil,nil,0,nil,nil,18,nil,nil,0},
[287] = {'Placeholder - Darkhollow Mine',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A",nil,0},
[288] = {'Jitters',712,712,25,25,0,{[10]={{18.38,56.37}}},{[10]={{{18.38,56.37},{18.31,56.26},{18.21,56.24},{18.14,56.36},{18.16,56.53},{18.25,56.59},{18.34,56.51}}}},10,{5,268},{163,240,453},12,"A",nil,2},
[289] = {'Abercrombie',1342,1342,35,35,0,{[10]={{28.11,31.46}}},nil,10,{133,134,148,158,160},{133,134,157,159,165},12,"A","The Hermit",2},
[290] = {'Placeholder - Fargodeep Mine',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Area Trigger",0},
[291] = {'Placeholder Chest of Drawers',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Placeholder!",0},
[294] = {'Marshal Haggard',484,484,20,20,0,{[12]={{84.61,69.38}}},nil,12,{75,78,1667},{74,75,1666,1667},12,"A",nil,2},
[295] = {'Innkeeper Farley',1002,1002,30,30,0,{[12]={{43.77,65.8}}},nil,12,{70},{69,2158},12,"A","Innkeeper",135},
[297] = {'Caretaker Folsom',1002,1002,30,30,0,{[1519]={{29.53,61.93}}},nil,1519,{72},{70},12,"A",nil,2},
[299] = {'Young Wolf',42,42,1,1,0,{[12]={{42.72,62.81},{41.55,58.29},{42.9,55.38},{45.38,55.41},{44.53,58.34},{45.64,43.81},{45.76,44.57},{46.45,44.85},{46.66,43.74},{47.98,45.92},{45.34,42.61},{48.67,45.55},{48.32,46.81},{46.37,42.3},{46.7,40.93},{47.55,40.46},{48.83,38.33},{45.53,39.09},{46.78,37.84},{45.34,41.11},{46.24,38.42},{48.03,39.61},{48.36,37.44},{45.23,37.64},{52.07,41.64},{49.39,45.26},{44.83,57.55},{42.81,62.26},{42.61,60.99}}},nil,12,nil,nil,32,"AH",nil,0},
[300] = {'Zzarc\' Vul',1221,1221,33,33,0,{[10]={{36.83,83.88},{36.09,80.64},{38.0,79.95}}},nil,10,nil,nil,45,nil,nil,0},
[302] = {'Blind Mary',1752,1752,40,40,0,{[10]={{81.99,59.09}}},{[10]={{{81.77,59.37},{81.99,59.09},{82.01,59.41}}}},10,{154,177},{149,175},12,"A",nil,2},
[303] = {'Placeholder Interactive Doodad - jk',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Use Your Imagination",0},
[304] = {'Riding Horse (Felsteed)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[305] = {'Riding Horse (White Stallion)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[306] = {'Riding Horse (Palomino)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[307] = {'Riding Horse (Pinto)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[308] = {'Riding Horse (Black Stallion)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[309] = {'Rolf\'s corpse',57,57,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[311] = {'Sven Yorgen',484,484,20,20,0,{[10]={{7.78,34.07}}},nil,10,{55,95,262,269,323},{55,164,230,268,323,325},12,"A",nil,2},
[313] = {'Theocritus',664,664,24,24,0,{[12]={{65.22,69.71}}},nil,12,{94},{178,249},12,"A","Mage of Tower Azora",2},
[314] = {'Eliza',2310,2310,31,31,1,nil,nil,0,nil,nil,14,nil,"Bride of the Embalmer",0},
[315] = {'Stalvan Mistmantle',1586,1586,32,32,0,{[10]={{77.35,36.19}}},nil,10,nil,nil,14,nil,nil,0},
[325] = {'Hogan Ference',484,484,20,20,0,{[10]={{72.26,48.16}}},nil,10,nil,nil,12,"A",nil,0},
[327] = {'Goldtooth',156,156,8,8,0,{[12]={{41.71,78.03}}},nil,12,nil,nil,26,nil,nil,0},
[328] = {'Zaldimar Wefhellt',273,273,13,13,0,{[12]={{43.25,66.19}}},nil,12,{1860},nil,12,"A","Mage Trainer",19},
[329] = {'Earth Elemental',2659,2744,54,55,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[330] = {'Princess',228,228,9,9,0,{[12]={{69.66,79.25}}},{[12]={{{69.68,79.9},{69.77,79.47},{69.82,78.84},{69.7,78.48},{69.24,78.4},{68.96,78.87},{68.9,79.52},{69.06,79.88},{69.39,80.13}}}},12,nil,nil,7,"AH",nil,0},
[331] = {'Maginor Dumas',4120,4120,60,60,0,{[1519]={{38.22,81.85}}},nil,1519,nil,nil,12,"A","Master Mage",19},
[332] = {'Master Mathias Shaw',4369,4369,62,62,0,{[1519]={{75.78,59.84}}},nil,1519,{141,350,395,2206,2360,2607,6183,6184},{135,393,394,2205,2206,2359,6182,6183},12,"A","Leader of SI:7",3},
[334] = {'Gath\'Ilzogg',2250,2250,26,26,1,{[44]={{69.61,55.79}}},nil,44,nil,nil,40,nil,"Warlord of the Blackrock Clan",0},
[335] = {'Singe',1584,1584,24,24,1,{[44]={{69.75,56.07}}},nil,44,nil,nil,40,nil,nil,0},
[338] = {'Mazen Mac\'Nadir',2138,2138,44,44,0,{[1519]={{41.52,64.36}}},nil,1519,{1363},nil,12,"A","Academy of Arcane Arts and Sciences",2},
[340] = {'Kendor Kabonka',2768,2768,50,50,0,{[1519]={{74.69,36.51}}},nil,1519,nil,nil,12,"A","Master of Cooking Recipes",4},
[341] = {'Foreman Oslow',484,484,20,20,0,{[44]={{32.14,48.64}}},nil,44,{89,125,347},{89,125,345},12,"A",nil,2},
[342] = {'Martie Jainrose',484,484,20,20,0,{[44]={{21.86,46.33}}},nil,44,{34,131},{34,130},12,"A",nil,2},
[343] = {'Chef Breanna',449,449,19,19,0,{[44]={{22.68,43.84}}},nil,44,{92},{92},12,"A",nil,2},
[344] = {'Magistrate Solomon',1468,1468,36,36,0,{[44]={{29.99,44.45}}},nil,44,{120,143,145,4184,4223},{121,144,146,169,180,4183,4186},12,"A",nil,2},
[345] = {'Bellygrub',1139,1139,24,24,0,{[44]={{15.68,49.31}}},nil,44,nil,nil,14,nil,nil,0},
[346] = {'Barkeep Daniels',531,531,21,21,0,{[44]={{26.48,43.96}}},nil,44,{116},{116},12,"A",nil,2},
[347] = {'Grizzle Halfmane',157200,157200,61,61,1,{[1497]={{56.13,85.3}}},nil,1497,nil,nil,1214,"H","Alterac Valley Battlemaster",2049},
[348] = {'Zem Leeward',712,712,25,25,0,{[44]={{26.25,50.81}}},nil,44,nil,nil,12,"A",nil,2},
[349] = {'Corporal Keeshan',1398,1398,25,25,1,{[44]={{28.39,12.55}}},nil,44,{219},nil,12,"A",nil,2},
[351] = {'Peasant',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[352] = {'Dungar Longdrink',7842,7842,55,55,1,{[1519]={{66.27,62.13}}},nil,1519,{6285},{6261},12,"A","Gryphon Master",11},
[353] = {'Antonia Dart',1220,1220,35,35,0,nil,nil,0,nil,nil,12,"A","iCoke Redemption Vendor",0},
[356] = {'Riding Wolf (Black)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[358] = {'Riding Wolf (Brown)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[359] = {'Riding Wolf (Winter)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[361] = {'Saytr',42,42,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[364] = {'Slime',42,42,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[365] = {'Scott\'s Flying Mount',42,42,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[370] = {'Boy',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[371] = {'Girl',42,42,1,1,0,nil,nil,0,nil,nil,12,"A",nil,0},
[372] = {'Karm Ironquill',356,356,16,16,0,{[38]={{37.13,47.16}}},nil,38,nil,nil,12,"A","Mining Supplies",6},
[373] = {'Murak Winterborn',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Shaman Trainer",0},
[374] = {'Cog Glitzspinner',1002,1002,30,30,0,{[10]={{77.3,48.7}}},nil,10,nil,nil,875,"A",nil,2},
[375] = {'Priestess Anetta',102,102,5,5,0,{[12]={{49.81,39.49}}},nil,12,{5623},{3103},12,"A","Priest Trainer",19},
[376] = {'High Priestess Laurena',4120,4120,60,60,0,{[1519]={{38.58,26.06}}},nil,1519,{5641,5673,8254},{5634,5635,5636,5637,5638,5639,5676,5677},12,"A","Priest Trainer",19},
[377] = {'Priestess Josetta',273,273,13,13,0,{[12]={{43.28,65.72}}},nil,12,{5624,5628,5637},{5623,5624},12,"A","Priest Trainer",19},
[379] = {'Darcy',328,328,15,15,0,{[44]={{26.62,44.3}}},{[44]={{{26.89,44.39},{26.91,44.82},{26.9,45.37},{27.09,45.65},{26.91,45.43},{26.59,45.44},{26.53,45.44},{26.91,45.44},{26.9,45.1},{27.03,45.0},{27.12,45.03},{27.15,45.05},{26.93,44.79},{26.9,44.46},{26.73,44.27},{26.62,44.3}}}},44,{129},{131},12,"A","Waitress",2},
[381] = {'Dockmaster Baren',484,484,20,20,0,{[44]={{27.72,47.38}}},nil,44,{127,150},{127,150},12,"A",nil,2},
[382] = {'Marshal Marris',1342,1342,35,35,0,{[44]={{33.5,48.97}}},nil,44,{19,20,115},{19,20,115,219},12,"A",nil,2},
[383] = {'Jason Mathers',137,137,7,7,0,{[12]={{47.46,62.18}}},nil,12,nil,nil,12,"A","Fishmonger",2},
[384] = {'Katie Hunter',198,198,10,10,0,{[12]={{84.15,65.49}}},nil,12,{7677,7678},{7677,7678},12,"A","Horse Breeder",135},
[385] = {'Horse',102,102,5,5,0,{[44]={{88.36,70.92},{88.2,70.07}},[12]={{83.48,63.78}}},nil,44,nil,nil,35,"AH",nil,0},
[387] = {'Lord Sammuel',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Master Paladin",0},
[388] = {'Bromos Murphy',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Master Paladin",0},
[389] = {'Lord Lantinga',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Master Paladin",0},
[390] = {'Porcine Entourage',137,137,7,7,0,{[12]={{69.61,79.15},{69.73,79.18}}},nil,12,nil,nil,7,"AH",nil,0},
[391] = {'Old Murk-Eye',581,581,20,20,0,{[40]={{29.27,75.95}}},{[40]={{{29.27,75.95},{29.41,76.95},{29.42,77.81},{29.61,79.15},{29.68,79.66},{29.81,80.14},{30.05,80.73},{30.46,81.31},{30.74,81.62},{31.36,82.09},{31.79,82.32},{32.47,82.56},{32.68,82.67},{33.21,83.03},{33.39,83.23},{34.08,84.15},{34.47,84.79},{34.67,85.2},{34.96,85.47},{35.18,85.5},{35.34,85.29},{35.38,85.13},{35.36,84.61},{35.06,84.15},{34.74,84.0},{34.51,83.95},{34.24,83.65},{33.74,83.23},{33.1,82.87},{32.54,82.71},{32.1,82.51},{31.65,82.0},{30.93,81.48},{30.46,80.97},{30.16,80.46},{29.87,79.72},{29.37,78.32},{29.28,77.31},{29.22,76.62},{29.04,75.09},{28.95,74.24},{28.88,73.56},{28.83,72.7},{28.37,71.96},{27.93,71.41},{27.66,70.86},{27.49,70.41},{27.38,69.92},{27.16,68.95},{27.08,68.1},{27.1,67.41},{27.04,66.92},{26.76,66.17},{26.49,65.88},{26.24,66.05},{26.49,67.15},{26.69,67.56},{27.02,68.02},{27.54,68.37},{27.98,68.51},{28.38,68.77},{28.55,69.2},{28.56,69.7},{28.55,70.38},{28.74,71.54},{28.84,72.22},{28.76,72.7},{28.75,73.89},{28.86,74.57},{28.97,75.24},{29.2,75.81}}}},40,nil,nil,18,nil,nil,0},
[392] = {'Captain Grayson',1002,1002,30,30,0,{[40]={{30.01,86.02}}},nil,40,{103,104,152},{103,104,152},35,"AH",nil,2},
[393] = {'Tame Wolf',198,198,10,10,0,nil,nil,0,nil,nil,12,"A",nil,0},
[395] = {'Markus',42,42,1,1,0,{[12]={{34.28,57.8}}},nil,12,nil,nil,12,"A",nil,0},
[397] = {'Morganth',1794,1794,26,26,1,{[44]={{80.11,49.49}}},nil,44,nil,nil,39,nil,nil,0},
[399] = {'Boy - placeholder 05',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[400] = {'Boy - placeholder 06',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[401] = {'Boy - placeholder 07',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[402] = {'Boy - placeholder 08',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[403] = {'Boy - placeholder 09',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[404] = {'Girl - placeholder 01',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[405] = {'Girl - placeholder 02',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[406] = {'Girl - placeholder 03',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[407] = {'Girl - placeholder 04',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[408] = {'Girl - placeholder 05',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[409] = {'Girl - placeholder 06',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[410] = {'Girl - placeholder 07',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[411] = {'Girl - placeholder 08',42,55,1,2,0,nil,nil,0,nil,nil,12,"A",nil,0},
[412] = {'Stitches',12200,12200,35,35,1,nil,nil,0,nil,nil,7,"AH","Gift from the Embalmer",0},
[415] = {'Verner Osgood',712,712,25,25,0,{[44]={{30.97,47.27}}},nil,44,{118,122,124,126},{119,122,124,126,1618},12,"A",nil,2},
[416] = {'Imp',34,34,5,5,0,nil,nil,0,nil,nil,14,nil,nil,0},
[417] = {'Felhunter',2319,2319,60,60,0,nil,nil,0,nil,nil,115,"A",nil,0},
[418] = {'Lesser Voidwalker',484,484,20,20,0,nil,nil,0,nil,nil,90,nil,nil,0},
[421] = {'Murphestos',42,42,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[422] = {'Murloc Flesheater',417,449,18,19,0,{[44]={{60.93,61.57},{59.87,61.46},{59.39,61.07},{60.24,62.36},{60.21,62.09},{59.99,62.75},{46.58,51.48},{57.72,62.06},{57.46,61.79},{58.51,59.45},{60.0,62.36},{57.91,60.57},{58.08,60.37},{55.29,61.74},{43.87,54.24},{55.95,60.3},{55.93,60.06},{58.61,60.32},{57.53,61.97},{57.87,60.83},{50.35,70.88},{48.83,72.2},{48.5,72.2},{47.7,71.22},{47.31,70.65},{50.22,68.54},{48.71,69.44},{48.26,67.38},{40.13,48.2},{40.17,45.03},{41.88,49.43},{42.54,50.47},{40.76,55.64},{39.14,47.09},{57.72,65.35}}},nil,44,nil,nil,18,nil,nil,0},
[423] = {'Redridge Mongrel',328,356,15,16,0,{[44]={{43.62,71.07},{15.63,59.53},{29.41,84.35},{34.46,82.9},{15.06,60.98},{14.84,61.47},{15.57,66.59},{44.4,72.3},{14.51,65.82},{32.44,82.82},{31.05,84.02},{29.86,84.12},{16.74,63.0},{32.05,82.49},{40.13,73.01},{30.35,81.2},{15.3,63.92},{16.74,62.18}}},nil,44,nil,nil,19,nil,nil,0},
[424] = {'Redridge Poacher',356,386,16,17,0,{[44]={{43.17,70.63},{43.34,71.27},{29.27,83.65},{29.07,84.38},{35.34,83.82},{34.69,83.09},{34.69,82.84},{32.28,82.28},{32.01,82.73},{32.1,82.9},{30.91,84.22},{42.99,71.19},{41.44,72.35},{31.3,81.14},{32.39,79.49},{30.97,79.5},{28.34,79.41}}},nil,44,nil,nil,19,nil,nil,0},
[426] = {'Redridge Brute',386,417,17,18,0,{[44]={{24.0,34.91},{21.49,36.22},{21.24,36.09},{21.21,36.41},{20.14,33.25},{24.12,32.62},{24.05,37.29},{29.52,37.88},{22.59,38.32},{20.84,40.03},{38.89,31.77},{38.54,31.75},{38.81,31.58},{40.65,32.02},{39.54,31.44},{40.34,35.01}}},nil,44,nil,nil,19,nil,nil,0},
[428] = {'Dire Condor',417,449,18,19,0,{[44]={{59.79,76.07},{55.26,76.78},{57.06,76.24},{60.79,78.28},{61.51,76.42},{64.12,76.42},{54.34,40.28},{55.18,46.11},{52.41,38.79},{57.28,44.92},{35.46,70.23},{45.96,77.49},{55.26,73.4},{42.16,32.38},{45.77,35.81},{50.08,33.94},{47.28,32.49},{48.61,34.95},{50.67,74.67},{57.1,41.58}}},nil,44,nil,nil,14,nil,nil,0},
[429] = {'Shadowhide Darkweaver',640,684,25,26,0,{[44]={{80.02,49.78},{80.29,49.48},{79.05,48.69},{75.76,30.32},{80.28,54.3},{81.29,56.46},{80.44,55.16},{83.41,57.92},{82.42,53.35},{79.81,54.29},{84.8,52.67},{81.06,54.83},{78.98,49.42},{74.01,35.88},{85.47,48.07},{80.22,52.75},{79.81,46.35},{79.68,45.17},{79.52,48.83},{79.09,47.63},{76.24,34.67},{79.95,38.63},{79.96,44.25}}},nil,44,nil,nil,39,nil,nil,0},
[430] = {'Redridge Mystic',354,379,18,19,0,{[44]={{32.07,29.43},{33.56,22.56},{28.58,28.25},{24.76,31.74},{28.06,28.89},{22.67,26.51},{20.24,32.95},{26.83,35.66},{24.01,37.28},{26.98,37.23},{16.9,17.73},{36.09,37.38},{28.47,27.93},{34.46,25.44},{34.49,25.15},{37.29,36.0},{27.05,23.0},{31.11,23.51},{27.69,21.98},{25.63,22.95},{21.66,35.28},{23.35,27.36},{23.91,29.81},{41.81,33.98},{39.21,30.81},{39.73,35.01},{29.38,21.99},{33.12,25.53}}},nil,44,nil,nil,19,nil,nil,0},
[431] = {'Shadowhide Slayer',734,788,25,26,0,{[44]={{83.88,57.98},{83.61,57.52},{82.8,59.27},{81.81,55.94},{81.68,54.91},{84.69,56.36},{84.64,57.4},{74.27,36.16},{75.9,30.05},{74.21,35.54},{82.18,47.78},{81.01,48.61},{80.98,49.05},{79.72,49.5},{80.26,48.56},{77.12,53.86},{77.53,55.46},{78.59,52.95},{80.18,37.06}}},nil,44,nil,nil,39,nil,nil,0},
[432] = {'Shadowhide Brute',617,664,23,24,0,{[44]={{73.48,54.93},{80.31,40.59},{76.56,37.38},{79.0,41.01},{75.14,46.32},{77.06,45.46},{80.28,35.11},{78.96,40.45},{79.21,40.91},{78.87,37.01},{79.94,37.88},{81.38,44.2},{81.22,36.3}}},nil,44,nil,nil,39,nil,nil,0},
[433] = {'Shadowhide Gnoll',573,617,22,23,0,{[44]={{73.29,54.82},{73.38,55.71},{73.54,55.36},{75.67,47.17},{75.82,47.53},{77.37,54.54},{75.23,49.82},{75.92,51.06},{74.91,52.17},{72.28,51.47},{71.51,58.9},{72.54,58.95},{76.57,45.29},{74.25,49.17},{68.72,45.71},{76.84,45.67},{74.13,40.75},{74.69,44.13},{71.94,43.86}}},nil,44,nil,nil,39,nil,nil,0},
[434] = {'Rabid Shadowhide Gnoll',531,573,21,22,0,{[44]={{75.48,47.66},{73.41,53.94},{75.9,46.84},{75.64,46.87},{75.02,49.97},{75.01,49.65},{73.01,58.41},{71.35,54.24},{72.74,54.84},{72.27,40.37}}},nil,44,nil,nil,39,nil,nil,0},
[435] = {'Blackrock Champion',664,713,24,25,0,{[44]={{27.25,16.42},{27.48,16.27},{29.62,14.14},{27.24,9.96},{26.95,9.73},{26.58,8.19},{35.7,7.65},{34.44,7.85},{34.43,6.72},{30.36,9.93},{30.95,7.22},{31.45,5.66},{30.46,8.81},{29.52,8.53},{29.34,12.05},{28.58,11.69},{29.6,11.22},{31.44,12.83},{28.56,15.4},{28.6,17.25},{28.16,16.83},{28.69,13.88},{30.59,15.45},{31.68,13.12}}},nil,44,nil,nil,40,nil,nil,0},
[436] = {'Blackrock Shadowcaster',1389,1482,22,23,1,{[44]={{69.5,54.04},{69.59,54.38},{69.73,54.1},{35.53,9.92},{35.7,7.65},{35.56,8.02},{35.94,7.87},{68.03,52.82},{69.34,55.5},{66.82,57.45},{68.59,55.6},{67.06,56.43},{66.26,57.31},{66.14,56.93},{67.52,53.29},{67.12,54.01},{67.08,54.1},{69.64,54.35},{70.02,57.48},{68.17,54.64},{67.66,55.8},{68.97,55.54},{69.75,53.98},{68.58,56.45},{69.34,54.73},{69.05,56.81},{69.06,55.39},{65.44,54.76},{69.54,58.36},{66.39,53.34},{63.44,49.42},{69.64,55.16},{69.21,59.75},{68.56,58.47},{68.16,59.01}}},nil,44,nil,nil,40,nil,nil,0},
[437] = {'Blackrock Renegade',531,573,21,22,0,{[44]={{77.7,69.43},{75.65,63.64},{77.69,67.33},{77.84,66.98},{78.03,67.43},{77.86,67.73},{76.99,67.24},{78.79,69.16},{75.35,72.57},{76.09,69.11},{77.88,73.25},{62.4,45.33},{62.55,45.65},{62.7,45.54},{44.38,12.42},{44.12,12.67},{42.97,12.27},{44.53,19.42},{42.53,17.95},{47.41,17.48},{41.53,10.86},{43.54,18.4},{43.49,18.19},{39.19,14.85},{38.99,14.36},{60.17,65.59},{68.56,58.47}}},nil,44,nil,nil,40,nil,nil,0},
[440] = {'Blackrock Grunt',449,484,19,20,0,{[44]={{75.1,74.3},{76.71,74.32},{70.72,78.65},{72.39,80.07},{72.3,81.67},{73.85,78.31},{73.23,80.15},{74.38,78.76},{76.54,80.59},{77.39,85.68},{77.57,86.11},{77.79,85.69},{60.99,42.82},{61.14,43.4},{60.64,43.04},{60.94,43.67},{75.11,84.09},{75.88,83.58},{76.39,82.95},{74.88,81.61},{62.4,45.33},{62.55,45.65},{62.7,45.54},{59.02,43.7},{59.43,44.33},{59.78,41.95},{59.6,42.21},{62.11,44.49},{62.45,41.4},{62.65,41.45},{40.59,41.45},{37.06,45.23},{37.09,45.58},{37.21,45.75},{38.24,41.16},{38.31,41.25},{43.43,40.17},{40.17,40.68}}},nil,44,nil,nil,40,nil,nil,0},
[441] = {'Black Dragon Whelp',330,354,17,18,0,{[44]={{66.91,76.61},{43.51,77.96},{51.78,74.68},{53.83,76.22},{54.61,73.69},{58.64,74.77},{57.65,78.38},{57.89,77.32},{60.55,75.18},{61.36,78.62},{23.88,63.18},{65.94,76.3},{62.24,75.13},{48.34,77.37},{27.74,63.28},{50.08,78.09},{30.75,75.67},{23.8,35.21},{36.39,72.7},{42.4,33.02},{31.98,74.76},{34.25,73.37},{42.65,29.58},{43.65,40.86},{46.27,35.37},{34.85,68.44},{33.26,66.97},{37.0,63.0},{33.13,63.27},{33.92,76.45},{37.75,72.77},{35.97,73.87},{27.41,74.53},{35.84,63.34}}},nil,44,nil,nil,14,nil,nil,0},
[442] = {'Tarantula',328,356,15,16,0,{[44]={{11.42,93.26},{13.33,93.07},{12.85,85.19},{10.73,80.6},{11.16,79.63},{9.83,76.68},{13.76,82.14},{8.95,85.07},{10.03,86.4},{12.62,78.16},{12.41,76.98},{20.15,65.41},{22.43,66.36},{14.11,75.69},{11.66,72.67},{8.78,77.02},{35.02,75.08},{22.8,76.34},{19.51,71.69},{18.15,71.73},{26.57,75.84},{22.22,67.25}}},nil,44,nil,nil,22,nil,nil,0},
[445] = {'Redridge Alpha',531,573,21,22,0,{[44]={{17.24,17.83},{27.55,21.36},{27.97,21.6},{27.24,23.11},{26.46,21.25},{27.43,21.75},{25.72,23.41}}},nil,44,nil,nil,19,nil,nil,0},
[446] = {'Redridge Basher',449,484,19,20,0,{[44]={{32.44,29.17},{32.29,29.38},{28.32,30.49},{28.89,30.16},{27.49,27.37},{27.38,29.43},{29.87,31.19},{28.55,31.48},{19.53,21.68},{23.73,29.13},{19.51,23.92},{21.94,15.29},{17.57,19.85},{18.63,18.15},{19.38,25.88},{23.11,18.3},{18.35,23.13},{16.7,21.92},{20.47,29.91},{17.9,19.45},{28.26,28.43},{28.31,27.8},{28.7,25.63},{34.09,25.26},{34.3,25.0},{35.22,25.76},{31.91,24.02},{23.56,25.24},{23.38,25.38},{23.51,26.23},{23.3,26.75},{23.46,24.15},{35.33,27.98},{30.98,22.78},{34.04,24.8}}},nil,44,nil,nil,19,nil,nil,0},
[448] = {'Hogger',666,666,11,11,1,{[12]={{25.02,92.9},{26.83,86.69},{26.43,93.65},{27.36,92.71},{25.78,89.82}}},nil,12,nil,nil,20,nil,nil,0},
[449] = {'Defias Knuckleduster',328,386,15,17,0,{[40]={{36.94,75.84},{37.23,75.33},{38.72,73.44},{35.2,71.83},{49.54,78.92},{49.26,78.89},{51.59,78.18},{46.63,81.43},{36.25,80.28},{37.66,75.15},{50.87,78.62},{50.48,78.75},{36.41,74.57},{60.66,58.78},{60.5,59.25}}},nil,40,nil,nil,17,nil,nil,0},
[450] = {'Defias Renegade Mage',354,379,18,19,0,{[40]={{37.36,75.23},{36.93,82.64}}},nil,40,nil,nil,17,nil,nil,0},
[452] = {'Riverpaw Bandit',356,386,16,17,0,{[40]={{47.71,62.43},{48.17,61.22},{48.4,61.28},{53.44,63.35},{53.1,62.69},{52.81,62.37},{54.32,62.28},{57.22,70.68},{56.52,69.27},{55.81,69.73},{56.23,71.0},{56.35,70.17},{56.3,70.02},{56.37,69.76},{56.52,69.78},{56.25,73.49},{57.22,73.03},{56.27,74.19},{56.55,74.31},{60.56,70.5},{60.66,70.68},{59.98,69.93},{59.39,74.4},{59.51,74.3},{59.3,74.06},{59.27,74.3},{63.97,70.09},{63.8,70.41},{63.92,70.34},{63.8,70.03},{64.6,70.53},{63.01,69.58},{60.79,69.14},{62.6,70.77},{61.1,71.17},{58.71,73.87},{56.32,75.3},{49.65,60.81},{50.12,60.34}}},nil,40,nil,nil,20,nil,nil,0},
[453] = {'Riverpaw Mystic',377,404,18,19,0,{[40]={{60.76,74.11},{61.46,77.07},{61.05,77.57},{62.74,77.68},{61.77,75.73},{63.06,76.51},{63.58,77.22},{63.53,73.16},{65.81,76.68},{65.08,75.08},{60.84,72.59},{60.58,75.45}}},nil,40,nil,nil,20,nil,nil,0},
[454] = {'Young Goretusk',247,273,12,13,0,{[40]={{49.75,23.52},{54.15,26.72},{52.39,17.55},{55.27,19.55},{46.62,19.34},{48.71,19.14},{56.09,20.77},{58.36,12.38},{58.86,13.66},{56.92,16.1},{59.99,33.57},{63.17,38.22},{61.92,27.84},{60.6,30.0},{62.91,23.58},{61.17,36.45},{60.26,32.3},{53.88,40.91},{57.07,39.22},{54.18,42.2},{44.32,30.45},{52.7,39.86},{56.22,42.48},{42.77,28.23},{42.18,23.68},{39.41,33.77},{40.94,30.05},{37.35,30.68},{37.77,25.94},{34.31,34.79},{36.16,34.96},{33.54,34.46},{51.35,23.27},{52.11,20.52},{51.19,20.25},{49.17,41.61},{55.22,43.72},{49.88,36.76},{50.42,29.35},{49.51,42.21},{52.96,46.17},{53.71,45.05},{52.09,41.17},{52.3,44.9},{43.85,32.24}}},nil,40,nil,nil,189,"AH",nil,0},
[456] = {'Murloc Minor Oracle',230,276,12,14,0,{[40]={{34.12,17.17},{34.24,15.86},{33.94,16.12},{34.41,16.13},{42.95,11.67},{42.23,11.47},{38.5,14.29},{38.87,14.7},{33.89,16.72},{33.54,17.08},{33.99,16.78},{33.45,15.14},{34.38,15.71},{33.9,16.37},{33.52,17.65},{34.67,18.42},{34.28,15.91},{34.01,17.41},{44.79,7.65},{44.97,8.06},{43.02,8.18},{41.24,10.19},{43.53,9.24}}},nil,40,nil,nil,18,nil,nil,0},
[458] = {'Murloc Hunter',356,386,16,17,0,{[40]={{30.8,35.11},{29.08,27.4},{28.73,27.18},{30.34,28.6},{30.2,27.52},{30.26,25.39},{26.58,60.33},{25.22,56.56},{25.25,56.23},{26.57,48.26},{24.83,48.27},{25.53,46.98},{27.59,35.11},{27.78,37.98},{29.62,27.75},{29.26,26.43},{27.48,59.94},{27.75,59.91},{27.71,58.61},{27.4,57.94},{25.8,49.06},{25.19,48.64},{25.66,46.85},{25.43,48.9},{27.58,40.66},{26.6,36.51},{26.69,39.0},{25.19,55.33},{25.21,55.03},{23.69,57.32},{27.83,53.98},{27.83,54.24},{27.3,54.78}}},nil,40,nil,nil,18,nil,nil,0},
[459] = {'Drusilla La Salle',102,102,5,5,0,{[12]={{49.87,42.65}}},nil,12,{1598},{1598,3105},12,"A","Warlock Trainer",19},
[460] = {'Alamar Grimm',102,102,5,5,0,{[1]={{28.65,66.14}}},nil,1,{1599},{1599,3115},875,"A","Warlock Trainer",19},
[461] = {'Demisette Cloyce',4120,4120,60,60,0,{[1519]={{25.28,78.22}}},nil,1519,{4488,4738,4968,8419},nil,12,"A","Warlock Trainer",19},
[462] = {'Vultros',788,788,26,26,4,{[40]={{50.64,43.55},{40.62,60.52},{36.77,62.52},{46.12,57.69},{45.66,60.08},{44.15,46.17},{45.44,43.95},{46.81,44.19},{51.08,23.81},{54.8,23.2},{63.25,57.03},{63.93,58.17},{65.52,58.72},{62.05,75.5},{61.53,73.9},{62.59,74.19}}},nil,40,nil,nil,73,nil,nil,0},
[464] = {'Guard Parker',1910,1910,30,30,0,{[44]={{15.27,71.46}}},{[44]={{{15.27,71.46},{15.26,71.78},{15.45,72.52},{15.61,72.32},{16.52,70.67},{17.14,69.96},{17.36,69.55},{16.44,69.52},{15.14,70.07},{14.21,70.58}}}},44,{130,244},{129},11,"A",nil,2},
[465] = {'Barkeep Dobbins',198,198,10,10,0,{[12]={{44.0,65.69}}},nil,12,nil,nil,12,"A","Bartender",4},
[466] = {'General Marcus Jonathan',30520,30520,60,60,1,{[1519]={{63.97,75.32}}},nil,1519,{121},{120},12,"A","High Commander of Stormwind Defense",2},
[467] = {'The Defias Traitor',329,329,15,15,0,{[40]={{55.68,47.5}}},nil,40,{155},nil,10,"A",nil,2},
[468] = {'Town Crier',1342,1342,35,35,0,{[10]={{74.96,46.77}}},{[10]={{{74.93,46.78},{74.94,45.58},{75.42,45.4},{74.94,45.5},{74.6,46.58},{73.85,46.37},{73.81,45.58},{73.84,46.14},{73.71,46.66},{73.33,46.72},{73.14,46.76},{72.56,46.87},{73.14,46.76},{73.33,46.72},{73.59,46.72},{74.12,47.84},{74.97,47.32},{75.13,47.57},{75.2,48.1},{75.14,47.02}},{{74.93,46.78},{74.94,45.58},{75.42,45.4},{74.94,45.5},{74.6,46.58},{73.85,46.37},{73.81,45.58},{73.84,46.14},{73.71,46.66},{73.33,46.72},{73.14,46.76},{72.56,46.87},{73.14,46.76},{73.33,46.72},{73.59,46.72},{74.12,47.84},{74.97,47.32},{75.13,47.57},{75.2,48.1},{75.14,47.02}}}},10,nil,nil,12,"A",nil,0},
[469] = {'Lieutenant Doren',61040,61040,60,60,1,{[33]={{38.04,3.01}}},nil,33,{200,202,330},{202,215,329,331,574},12,"A",nil,2},
[471] = {'Mother Fang',198,198,10,10,4,{[12]={{62.14,48.05}}},nil,12,nil,nil,22,nil,nil,0},
[472] = {'Fedfennel',247,247,12,12,4,{[12]={{68.13,44.87},{66.48,40.89},{67.94,39.57},{69.12,38.86}}},nil,12,nil,nil,20,nil,nil,0},
[473] = {'Morgan the Collector',198,198,10,10,0,{[12]={{71.09,80.65}}},nil,12,nil,nil,17,nil,nil,0},
[474] = {'Defias Rogue Wizard',160,178,9,10,0,{[12]={{29.13,60.88},{28.89,62.18},{28.99,62.65},{28.33,59.69},{29.72,61.03},{50.65,83.23},{52.72,59.04},{72.57,46.36},{71.66,49.74},{74.44,46.97},{73.37,49.76},{71.74,52.03},{74.46,49.3},{73.63,51.16},{73.38,52.48},{74.16,50.94},{74.07,51.78},{72.5,56.41},{72.33,55.03},{73.12,54.16},{74.52,53.95},{74.56,52.39},{74.89,52.09},{73.95,55.64},{77.17,51.68},{76.59,53.38},{76.83,48.63},{76.04,47.44}}},nil,12,nil,nil,17,nil,nil,0},
[475] = {'Kobold Tunneler',102,120,5,6,0,{[12]={{36.03,82.7},{36.19,79.12},{38.81,81.85},{37.3,80.58},{38.51,82.26},{39.01,80.66},{39.02,81.19},{38.02,81.63},{38.5,81.47},{37.57,79.01},{38.71,78.57},{38.87,81.5},{38.1,82.6},{37.7,84.86},{37.4,83.45},{37.98,83.81},{38.74,83.81},{36.73,84.02},{38.58,84.05},{39.06,82.63},{39.04,81.36},{39.33,83.2},{40.77,81.09},{40.51,81.22},{40.65,81.56},{39.08,85.03},{39.81,84.19},{39.42,80.36},{39.6,82.13},{40.34,82.53},{39.7,82.86},{40.72,78.29},{41.07,78.24},{41.25,80.41},{41.08,80.29},{41.79,79.67},{40.77,78.35},{40.23,77.54},{37.82,87.05}}},nil,12,nil,nil,26,nil,nil,0},
[476] = {'Kobold Geomancer',126,142,7,8,0,{[12]={{64.75,56.89},{63.53,58.32},{64.49,56.55},{64.5,56.72},{62.2,55.74},{60.97,56.51},{61.26,51.66},{61.15,49.26}}},nil,12,nil,nil,26,nil,nil,0},
[478] = {'Riverpaw Outrunner',176,198,9,10,0,{[12]={{27.45,79.89},{26.28,84.99},{27.3,82.43},{26.35,81.43},{26.5,86.84},{26.32,86.84},{25.4,88.62},{27.42,86.25},{27.56,86.06},{25.13,87.04},{25.63,90.48},{25.31,89.11},{25.14,89.24},{26.69,90.19},{27.49,89.48},{26.11,92.1},{25.99,92.09},{28.03,88.22},{27.76,88.45},{28.45,88.2},{28.55,87.28},{25.41,94.21},{25.97,92.69},{23.75,94.09},{24.28,93.78},{24.46,94.11},{24.82,92.9},{26.48,95.37},{27.71,94.51},{28.6,92.99},{28.04,81.29},{68.64,54.77},{68.17,50.88},{68.19,48.88},{67.8,45.66},{68.1,45.13},{67.83,44.94},{68.87,45.19},{68.82,43.22},{67.7,42.3},{66.73,43.79},{69.07,40.38},{67.85,40.19},{68.19,38.75},{67.62,39.24},{67.99,39.75},{66.02,41.0},{65.73,42.13},{66.9,40.61},{66.61,40.35},{66.67,40.95},{66.66,41.32},{68.85,38.82},{69.66,39.28},{69.61,38.66},{69.23,38.37},{76.8,40.2},{72.92,38.3}}},nil,12,nil,nil,20,nil,nil,0},
[480] = {'Rusty Harvest Golem',176,198,9,10,0,{[40]={{53.9,25.11},{57.13,21.18},{55.32,24.57},{54.39,25.59},{57.41,19.83},{57.09,20.08},{54.37,24.37},{56.58,20.99},{54.98,25.08},{53.38,25.56},{53.42,24.99},{58.25,16.64},{59.06,18.25},{57.47,18.15},{58.19,19.01},{57.46,20.78}}},nil,40,nil,nil,14,nil,nil,0},
[481] = {'Defias Footpad',198,222,10,11,0,{[40]={{56.1,19.17},{56.57,19.28},{56.66,18.91},{56.83,19.16},{56.74,19.76}}},nil,40,nil,nil,17,nil,nil,0},
[482] = {'Elling Trias',1002,1002,30,30,0,{[1519]={{59.91,64.18}}},nil,1519,{394,1243,1246,1248,2745},{350,434,1242,1245,1247},12,"A","Master of Cheese",2},
[483] = {'Elaine Trias',1002,1002,30,30,0,{[1519]={{60.59,63.24}}},nil,1519,nil,nil,12,"A","Mistress of Cheese",5},
[485] = {'Blackrock Outrunner',494,531,20,21,0,{[44]={{77.7,69.43},{75.65,63.64},{77.69,67.33},{77.84,66.98},{78.03,67.43},{77.86,67.73},{76.99,67.24},{78.79,69.16},{68.94,78.36},{71.49,74.83},{70.08,75.9},{75.1,74.3},{75.35,72.57},{76.71,74.32},{72.87,74.64},{76.09,69.11},{77.88,73.25},{72.39,80.07},{72.3,81.67},{73.23,80.15},{74.38,78.76},{74.04,79.3},{76.54,80.59},{77.39,85.68},{77.57,86.11},{77.79,85.69},{77.01,83.37},{60.99,42.82},{61.14,43.4},{60.64,43.04},{60.94,43.67},{76.01,84.63},{75.11,84.09},{74.88,81.61},{62.4,45.33},{62.55,45.65},{62.7,45.54},{59.02,43.7},{59.43,44.33},{59.78,41.95},{59.6,42.21},{62.11,44.49},{62.45,41.4},{62.65,41.45},{44.53,19.42},{42.53,17.95},{47.41,17.48},{43.49,18.19},{64.37,61.61},{64.55,62.05},{40.59,41.45},{37.06,45.23},{37.09,45.58},{37.21,45.75},{65.22,61.64},{68.56,58.47},{38.24,41.16},{38.31,41.25},{43.43,40.17},{40.17,40.68}}},nil,44,nil,nil,40,nil,nil,0},
[486] = {'Tharil\'zun',1713,1713,24,24,1,{[44]={{69.45,59.41}}},nil,44,nil,nil,40,nil,nil,0},
[487] = {'Protector Bialon',1910,1910,30,30,0,{[40]={{55.71,47.41}}},nil,40,nil,nil,11,"A","The People's Militia",0},
[488] = {'Protector Weaver',1910,1910,30,30,0,{[40]={{57.0,47.44}}},{[40]={{{57.0,47.44},{56.84,47.49},{56.69,47.31},{56.68,47.06},{56.8,46.89},{56.96,46.87},{57.07,47.03},{57.09,47.28}}}},40,nil,nil,11,"A","The People's Militia",0},
[489] = {'Protector Dutfield',1910,1910,30,30,0,{[40]={{56.62,47.91}}},{[40]={{{56.62,47.95},{56.88,48.0},{57.27,47.87},{57.47,47.28},{57.35,46.63},{56.83,46.31},{56.37,46.8},{56.32,47.33},{56.56,47.88}},{{56.62,47.95},{56.88,48.0},{57.27,47.87},{57.47,47.28},{57.35,46.63},{56.83,46.31},{56.37,46.8},{56.32,47.33},{56.56,47.88}}}},40,nil,nil,11,"A","The People's Militia",0},
[490] = {'Protector Gariel',1910,1910,30,30,0,{[40]={{55.96,48.2}}},nil,40,nil,nil,11,"A","The People's Militia",0},
[491] = {'Quartermaster Lewis',484,484,20,20,0,{[40]={{57.0,47.17}}},nil,40,{6181},{6285},12,"A","Quartermaster",7},
[494] = {'Watcher Bukouris',1403,1403,35,35,0,{[10]={{73.21,45.87}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[495] = {'Watcher Keefer',1604,1604,38,38,0,{[10]={{74.64,46.39}}},{[10]={{{74.64,46.46},{73.91,46.54},{73.72,47.0},{73.9,47.56},{74.34,47.78},{74.64,47.06}}}},10,nil,nil,11,"A","The Night Watch",0},
[499] = {'Watcher Paige',896,896,28,28,0,{[10]={{45.01,67.66}}},nil,10,nil,nil,56,"A","The Night Watch",0},
[500] = {'Riverpaw Scout',247,273,12,13,0,{[40]={{56.5,12.59},{56.3,13.59},{52.14,15.2},{52.21,14.87},{44.95,14.04},{45.02,13.69},{43.87,16.57},{44.72,14.16},{46.41,15.11},{42.18,20.58},{41.76,20.69},{41.95,20.9},{41.82,20.45},{36.46,31.7},{36.61,31.89},{38.99,31.95},{40.09,32.21},{38.38,28.26},{38.1,28.32},{34.0,29.19},{33.72,28.25},{42.91,14.89},{45.05,12.62}}},nil,40,nil,nil,20,nil,nil,0},
[501] = {'Riverpaw Herbalist',300,328,14,15,0,{[40]={{30.35,49.58},{31.3,48.96},{29.57,50.82},{31.49,50.85},{30.51,51.75},{30.66,52.1},{31.63,52.32},{30.56,58.04},{30.25,57.51},{29.12,65.28},{29.16,65.53},{31.27,70.63},{32.75,68.42},{32.8,67.98},{32.47,73.72},{31.55,72.27},{32.3,72.23},{35.75,61.14},{31.75,73.38},{31.04,69.63},{29.64,52.27},{30.39,53.69}}},nil,40,nil,nil,20,nil,nil,0},
[502] = {'Benny Blaanco',328,328,15,15,0,{[40]={{49.47,18.99}}},nil,40,nil,nil,17,nil,nil,0},
[503] = {'Lord Malathrom',935,935,31,31,4,{[10]={{21.14,27.19},{20.31,28.83},{22.07,28.35},{22.77,28.87},{24.67,29.37},{24.51,31.24},{25.92,30.9}}},nil,10,nil,nil,21,nil,nil,0},
[504] = {'Defias Trapper',247,273,12,13,0,{[40]={{43.94,25.19},{44.52,24.59},{48.8,20.36},{49.56,19.97},{48.72,20.86},{48.83,20.68},{31.71,32.93},{31.41,33.82},{31.33,33.72},{31.32,33.62},{30.95,34.12},{30.93,33.09},{32.03,33.89},{41.55,41.05},{46.5,37.39},{45.99,38.19},{46.4,36.92},{47.39,36.32},{50.64,39.32},{48.17,46.72},{44.79,22.04},{46.64,27.33},{44.82,22.4},{46.11,39.06},{46.7,52.51},{44.68,24.0},{49.83,19.76},{48.56,47.7},{47.15,46.18},{40.77,39.55},{32.24,34.62},{31.67,34.58},{32.54,33.4},{47.73,43.36},{51.07,39.42},{51.4,46.79},{50.67,47.22},{47.76,45.85},{48.53,45.24}}},nil,40,nil,nil,17,nil,nil,0},
[505] = {'Greater Tarantula',449,484,19,20,0,{[44]={{67.21,76.56},{53.71,36.38},{52.9,38.98},{53.8,38.16},{53.88,43.18},{53.81,43.6},{55.13,43.15},{55.92,43.36},{52.63,38.4},{51.86,41.23},{50.59,40.6},{57.13,46.63},{47.83,38.46},{52.4,42.09}}},nil,44,nil,nil,22,nil,nil,0},
[506] = {'Sergeant Brashclaw',417,417,18,18,4,{[40]={{36.88,31.85}}},nil,40,nil,nil,20,nil,nil,0},
[507] = {'Fenros',1404,1404,32,32,4,{[10]={{61.72,36.85},{61.52,38.99},{60.68,40.7},{60.78,43.71},{62.19,45.92},{61.21,49.87},{63.88,51.77},{63.75,47.13}}},nil,10,nil,nil,24,nil,nil,0},
[510] = {'Water Elemental',3052,3052,60,60,0,nil,nil,0,nil,nil,115,"A",nil,0},
[511] = {'Insane Ghoul',788,788,26,26,0,{[10]={{80.9,71.96}}},{[10]={{{80.9,71.96},{80.85,71.75},{80.8,71.53},{80.77,71.41},{80.77,71.41},{80.78,71.72},{80.74,71.49},{80.84,71.59},{80.88,71.56},{80.79,71.32},{80.8,71.32},{80.92,71.46},{80.85,71.37},{80.8,71.32},{80.88,71.21},{80.93,71.47},{80.78,71.49},{80.82,71.46},{80.84,71.57},{80.86,71.59},{80.97,71.77},{80.84,71.92},{80.77,71.75},{80.76,71.29},{80.79,71.3},{80.82,71.35},{80.88,71.42},{81.07,71.71},{80.86,71.75},{80.49,71.25},{79.95,70.8},{79.74,69.89},{79.16,69.5},{78.82,68.61},{78.2,69.95},{78.22,71.07},{78.7,71.47},{78.57,71.95},{79.11,72.86},{79.75,73.03},{80.03,72.59},{79.65,72.0},{80.01,70.88},{80.57,71.29}}}},10,nil,nil,21,nil,nil,0},
[513] = {'Murloc Netter',300,328,14,15,0,{[40]={{34.3,16.71},{33.73,16.72},{34.1,16.67},{34.56,15.89},{33.54,17.93},{38.06,16.31},{37.19,15.79},{39.02,15.41},{37.7,15.25},{38.79,16.19},{38.33,15.29},{37.39,16.46},{34.58,21.99},{36.12,22.05},{34.55,22.66},{32.92,17.54},{35.03,16.94},{33.93,18.72},{32.42,26.63},{32.5,26.25},{34.83,20.43},{33.65,17.45},{33.49,17.08},{34.11,16.18},{34.52,15.65},{33.44,17.24},{35.54,22.1},{35.8,21.57},{32.25,25.4},{33.71,16.45}}},nil,40,nil,nil,18,nil,nil,0},
[514] = {'Smith Argus',664,664,24,24,0,{[12]={{41.71,65.54}}},nil,12,{119,1097},{118},12,"A","Journeyman Blacksmith",19},
[515] = {'Murloc Raider',222,247,11,12,0,{[40]={{52.17,10.26},{52.97,11.3},{53.16,10.61},{55.6,8.02},{55.71,7.31},{55.72,8.63},{52.69,9.59},{55.3,9.53},{53.89,9.63},{55.27,10.1}}},nil,40,nil,nil,18,nil,nil,0},
[517] = {'Murloc Oracle',325,377,16,18,0,{[40]={{27.72,68.77},{26.97,55.34},{26.92,54.21},{33.75,83.18},{27.69,70.02},{26.76,70.21},{27.39,52.47},{26.12,74.44},{28.03,73.06},{27.11,72.74},{26.0,72.25},{27.93,59.99},{28.17,69.0},{26.81,59.46},{26.09,58.99},{26.92,53.44},{27.26,58.75},{27.28,75.54},{26.08,73.65},{27.18,74.38},{23.66,57.09},{33.93,84.84},{26.69,58.18},{27.53,53.64},{34.6,85.32},{27.74,52.89},{33.66,84.36},{34.54,85.94}}},nil,40,nil,nil,18,nil,nil,0},
[518] = {'Yowler',712,712,25,25,0,{[44]={{27.65,21.38}}},nil,44,nil,nil,19,nil,nil,0},
[519] = {'Slark',328,328,15,15,4,{[40]={{47.01,10.94}}},{[40]={{{47.01,10.94},{46.37,10.56},{45.4,10.07},{44.31,10.0},{43.6,10.11},{42.59,10.73},{42.27,11.0},{42.33,11.92},{41.98,11.96},{41.26,12.16},{40.16,12.4},{39.6,12.98},{39.16,14.43},{39.02,15.51},{38.32,16.6},{37.66,17.06},{36.94,18.24},{36.03,19.1},{35.7,19.3},{35.17,19.9},{34.69,21.97},{33.86,22.94},{32.82,23.38},{32.08,24.36},{31.63,25.86},{31.06,27.26},{30.73,28.22},{30.57,29.24},{30.27,30.69},{29.77,31.5},{29.33,32.92},{29.21,34.0},{29.14,34.55},{28.57,35.9},{28.06,37.36},{27.69,38.91},{27.55,39.99},{27.37,41.61},{27.06,43.75},{26.92,44.81},{26.91,45.9},{26.92,46.99},{26.76,48.62},{27.18,49.8},{27.46,50.13},{27.72,51.11},{27.76,52.2},{27.81,52.74},{27.8,53.69},{27.89,53.72},{27.54,53.56},{27.29,53.74},{27.04,55.35},{26.99,56.43},{27.32,57.39},{27.24,58.87},{26.67,60.26},{26.43,61.24},{26.44,62.31},{26.43,62.81},{26.19,64.24},{26.57,65.58},{27.0,66.45},{27.35,67.93},{27.38,68.47},{27.42,69.45},{28.27,70.46},{28.76,71.23},{29.03,72.77},{29.07,74.44},{29.13,76.09},{29.22,77.73},{29.39,78.79},{29.73,79.77},{30.19,80.61},{30.98,81.76},{31.59,82.14},{32.3,82.2},{32.99,82.56},{33.33,82.7},{33.96,83.21},{34.28,83.41},{34.63,83.5},{34.93,83.8},{35.19,84.19},{35.44,85.18},{35.2,85.65},{34.97,85.37},{34.24,85.24},{33.92,85.2},{32.99,84.32},{32.69,84.04},{32.1,83.42},{31.27,82.43},{30.78,81.59},{30.0,80.55},{29.08,79.67},{28.59,78.91},{28.52,77.96},{28.69,77.57},{28.5,76.52},{28.13,75.57},{27.73,74.65},{27.48,73.64},{27.51,72.56},{27.66,71.48},{27.45,69.99},{27.02,68.48},{26.39,67.16},{26.21,66.16},{26.21,65.61},{26.22,63.69},{26.26,62.66},{26.48,61.04},{26.73,60.03},{27.08,59.05},{27.58,57.6},{27.9,56.6},{27.91,55.67},{27.36,54.26},{27.0,52.7},{26.89,51.6},{26.64,49.44},{26.58,48.35},{26.74,46.74},{26.68,45.1},{26.8,44.66},{27.07,44.28},{27.27,43.26},{27.27,42.72},{27.58,41.14},{27.59,40.61},{27.31,39.6},{27.14,38.53},{27.11,37.46},{27.29,36.38},{27.36,35.85},{27.26,34.91},{27.41,34.41},{28.3,33.9},{28.78,33.29},{28.96,32.81},{29.4,31.32},{30.0,29.94},{30.12,28.92},{30.14,28.39},{30.19,27.86},{30.64,27.06},{31.24,26.47},{31.92,25.2},{32.24,24.24},{32.64,23.37},{33.22,22.69},{33.88,22.43},{34.74,21.66},{35.2,20.82},{35.34,20.34},{35.47,19.27},{35.84,18.35},{36.12,17.99},{36.8,16.8},{37.29,16.0},{37.8,15.23},{38.42,14.74},{39.22,13.79},{39.66,12.89},{40.57,12.16},{41.24,11.77},{42.23,11.08},{42.58,10.9},{43.3,10.7},{43.93,10.2},{44.98,10.04},{45.33,10.12},{46.2,11.0},{47.18,11.4},{47.83,11.03},{48.84,11.04},{49.16,11.26},{49.78,11.7},{50.78,11.16},{51.72,10.27},{52.41,10.09},{53.12,10.27},{53.75,10.8},{54.09,11.7},{54.22,12.19},{54.48,12.58},{55.11,12.16},{55.38,11.79},{55.67,11.45},{56.02,11.33},{56.12,10.81},{55.95,10.46},{55.24,10.76},{54.52,10.94},{54.15,10.95},{53.79,10.87},{53.09,10.6},{52.36,10.56},{51.27,10.77},{50.56,11.07},{49.84,11.2},{48.78,10.81},{48.09,10.79},{47.01,10.94},{47.74,10.97}}}},40,nil,nil,18,nil,nil,0},
[520] = {'Brack',449,449,19,19,4,{[40]={{27.27,44.54}}},{[40]={{{27.28,44.53},{27.03,45.15},{26.91,46.19},{26.85,46.81},{26.98,47.44},{26.93,47.82},{26.85,48.42},{26.83,48.93},{26.89,49.33},{27.0,49.78},{27.08,50.21},{27.22,50.7},{27.4,51.63},{27.41,52.07},{27.36,52.53},{27.31,53.03},{27.28,54.5},{27.27,54.85},{27.2,55.38},{27.11,55.8},{27.05,56.2},{27.01,56.78},{26.94,57.62},{26.92,57.93},{26.89,58.48},{26.61,58.61},{26.2,58.79},{26.34,58.23},{26.39,57.79},{26.4,57.12},{26.36,55.87},{26.68,55.24},{27.03,54.55},{27.09,54.24},{27.05,53.78},{26.95,53.23},{26.94,52.54},{26.87,52.27},{26.77,51.92},{26.82,51.57},{26.89,51.14},{26.95,50.83},{26.98,50.5},{26.99,50.24},{26.98,49.88},{26.96,49.5},{26.92,49.28},{26.81,48.9},{26.8,48.48},{26.8,47.79},{26.84,47.46},{27.05,46.91},{27.15,46.45},{27.24,45.83},{27.32,45.24},{27.35,44.88},{27.36,44.39},{27.33,43.8},{27.3,43.2},{27.32,42.78},{27.4,42.03},{27.54,41.32},{27.73,40.74},{27.71,40.13},{28.0,39.22},{28.1,38.83},{28.22,38.44},{28.22,37.79},{28.27,36.85},{27.9,36.9},{27.51,37.15},{27.35,37.62},{27.17,39.12},{27.19,39.98},{27.38,40.86},{27.34,41.37},{27.29,41.99},{27.27,42.44},{27.22,43.25},{27.21,43.55},{27.11,44.42}}}},40,nil,nil,18,nil,nil,0},
[521] = {'Lupos',617,617,23,23,4,{[10]={{32.63,25.84},{70.63,26.64},{67.26,26.85},{64.5,26.75},{61.98,24.9},{61.18,22.82},{38.27,25.29},{36.31,24.37},{34.23,29.59},{31.64,29.12},{29.6,29.75},{27.13,27.2},{24.86,28.39},{23.59,26.96},{19.99,26.39},{21.52,26.54}}},nil,10,nil,nil,38,nil,nil,0},
[522] = {'Mor\'Ladim',3660,3660,35,35,1,{[10]={{16.67,37.35}}},{[10]={{{16.57,36.95},{16.17,36.76},{15.81,37.07},{15.47,37.56},{15.13,38.11},{14.91,39.19},{14.96,40.0},{14.82,40.92},{14.58,41.87},{14.59,42.14},{14.82,42.6},{15.1,42.84},{15.45,43.04},{16.29,43.36},{17.3,43.32},{17.98,42.86},{18.73,42.09},{19.32,41.67},{19.68,40.72},{19.82,39.96},{19.59,38.89},{19.3,38.45},{18.96,38.29},{18.47,38.25},{18.05,38.24},{17.52,37.92},{17.29,37.96},{17.07,38.26},{16.95,38.54},{16.8,38.65},{16.67,38.58},{16.62,38.45},{16.73,37.94},{16.69,37.51}}}},10,nil,nil,21,nil,nil,0},
[523] = {'Thor',7842,7842,55,55,1,{[40]={{56.55,52.64}}},nil,40,{6281},{6181},12,"A","Gryphon Master",11},
[524] = {'Rockhide Boar',137,156,7,8,0,{[12]={{61.64,78.29},{62.93,79.83},{60.54,81.37},{60.21,78.15},{60.61,79.74},{60.09,75.39},{59.3,74.54},{58.55,74.76},{58.38,72.76},{42.95,82.01},{44.01,80.95},{44.1,79.3},{43.32,77.87},{44.5,83.76},{44.49,79.23},{46.59,78.58},{47.27,75.77},{47.98,75.99},{47.19,79.43},{46.41,80.22},{47.85,78.61},{48.34,80.92},{46.63,81.01},{45.88,82.86},{46.55,85.12},{44.56,87.24},{45.59,87.99},{44.97,89.58},{50.14,79.68},{50.09,78.75},{52.13,77.99},{52.52,75.79},{49.5,75.68},{48.97,76.07},{51.86,74.69},{53.06,73.99},{54.18,77.94},{54.58,75.25},{53.41,76.45},{54.85,79.86},{54.67,80.9},{52.65,81.46},{53.21,82.37},{53.41,79.89},{55.52,76.64},{53.57,85.37},{52.66,84.37},{54.37,83.67},{56.45,83.92},{54.93,85.86},{57.16,82.43},{57.17,76.38},{56.43,75.24},{55.58,73.78},{58.52,74.71},{59.1,76.53},{59.12,74.32},{58.34,72.45},{57.14,73.76},{57.99,80.76},{60.32,78.2},{61.69,78.31},{60.97,79.67},{60.99,77.16},{64.06,78.38},{64.61,79.64},{63.95,80.61},{62.91,76.25},{65.78,77.74},{65.55,75.61},{64.95,76.74},{63.89,75.79},{62.06,75.43},{65.66,81.26},{66.93,79.86},{67.27,76.91},{66.93,82.47},{70.74,82.61},{72.67,79.61},{73.0,76.52},{71.78,75.24},{70.78,73.67},{73.79,78.49},{71.37,83.61},{72.86,82.66},{73.54,80.83},{69.53,75.51},{74.43,80.13},{69.72,72.59},{74.44,81.92}}},nil,12,nil,nil,189,"AH",nil,0},
[525] = {'Mangy Wolf',102,120,5,6,0,{[12]={{57.09,69.72},{52.06,63.68},{47.53,68.15},{41.56,57.99},{32.18,55.5},{42.81,54.97},{44.56,57.82},{45.79,55.44},{33.37,58.17},{34.17,59.33},{36.78,60.83},{35.87,62.59},{35.4,61.21},{38.45,63.81},{38.3,62.19},{36.91,63.15},{35.29,63.35},{37.52,64.88},{42.52,62.51},{43.09,61.05},{45.9,68.54},{34.96,66.74},{34.41,65.2},{34.7,62.39},{32.1,56.18},{30.64,69.09},{30.58,68.1},{32.54,67.71},{28.26,67.43},{34.89,67.54},{36.1,69.25},{35.03,70.01},{35.41,70.69},{35.64,73.61},{35.12,72.39},{33.86,73.61},{33.61,73.38},{34.72,75.48},{33.47,76.13},{33.07,75.67},{30.36,71.93},{31.09,71.29},{30.28,72.14},{29.65,72.85},{29.23,72.87},{29.56,72.24},{29.3,72.2},{29.15,74.29},{29.11,69.63},{28.76,72.22},{27.71,71.29},{27.61,74.25},{26.36,75.31},{28.7,75.53},{28.48,74.82},{23.55,77.02},{22.49,75.53},{22.22,75.49},{21.71,76.39},{21.41,74.3},{32.39,76.75},{52.29,71.08},{51.38,69.69},{53.13,69.71},{56.08,71.12},{57.28,69.81},{55.25,69.98},{54.25,71.18},{56.49,61.47},{56.8,60.36},{58.37,60.57},{56.45,58.98},{57.14,59.78},{55.24,61.49},{55.04,59.38},{52.05,63.76},{50.88,70.54},{49.71,69.36},{52.37,71.17},{47.56,68.02},{49.61,60.96},{50.43,61.71},{50.35,61.68},{49.5,58.3},{52.37,62.67},{52.36,62.02},{52.09,62.96},{53.77,60.39}}},nil,12,nil,nil,38,nil,nil,0},
[531] = {'Skeletal Fiend',664,713,24,25,0,{[10]={{16.24,42.81},{21.81,47.42},{22.65,40.49},{23.78,44.0},{22.39,43.04},{22.93,43.46},{23.34,42.65},{15.28,46.38},{15.98,47.14},{16.81,47.1},{15.04,42.0},{20.65,46.4},{22.24,42.32}}},nil,10,nil,nil,21,nil,nil,0},
[533] = {'Nightbane Shadow Weaver',724,769,27,28,0,{[10]={{65.48,69.13},{67.22,75.57},{66.22,71.06},{65.0,74.99},{67.33,70.77},{66.4,66.44},{64.32,66.16},{65.08,66.37},{60.68,70.91},{62.49,72.4},{63.3,70.26},{64.24,67.74},{60.09,72.17},{63.39,44.21},{64.95,45.75},{64.7,42.86},{59.74,52.8},{62.0,47.77},{61.43,45.87},{63.46,37.17},{58.28,29.32},{62.56,35.0},{65.11,38.64},{57.32,30.42},{61.07,37.3},{61.94,52.05},{62.03,30.22}}},nil,10,nil,nil,24,nil,nil,0},
[534] = {'Nefaru',1279,1279,34,34,4,{[10]={{63.48,83.67},{74.33,77.9},{61.85,81.38}}},nil,10,nil,nil,24,nil,nil,0},
[539] = {'Pygmy Venom Web Spider',417,449,18,19,0,{[10]={{46.53,16.7},{74.76,17.52},{84.69,18.36},{69.61,18.63},{10.14,66.12},{68.25,15.94},{66.26,17.05},{11.94,68.91},{13.18,70.34},{9.23,60.82},{60.82,16.61},{66.69,17.92},{53.87,13.31},{54.53,14.24},{47.65,15.87},{40.14,21.76},{33.96,24.6},{28.79,27.62},{72.08,19.0},{37.15,21.27},{10.75,55.39},{11.63,62.66},{10.4,59.06},{10.79,53.0},{7.91,44.81},{7.86,40.81},{11.97,59.19},{9.53,53.77},{9.42,57.19},{12.0,51.24},{23.85,27.8},{12.45,28.79},{9.53,49.65},{8.99,46.18},{9.36,42.83},{66.38,17.96}}},nil,10,nil,nil,22,nil,nil,0},
[541] = {'Riding Gryphon',1040,1040,29,29,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[542] = {'Califex of the Deep Wood',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Druid Trainer",0},
[543] = {'Nalesette Wildbringer',1752,1752,40,40,0,{[361]={{62.2,24.37}}},nil,361,nil,nil,80,"A","Pet Trainer",19},
[544] = {'Murloc Nightcrawler',531,573,21,22,0,{[44]={{80.8,58.54},{81.21,59.61},{81.1,59.7},{81.74,60.09}}},nil,44,nil,nil,18,nil,nil,0},
[545] = {'Murloc Tidecaller',404,433,19,20,0,{[44]={{58.21,51.83},{55.64,53.91},{56.91,52.81},{58.06,57.38},{58.27,52.37},{57.96,52.03},{57.91,51.68},{58.26,53.42},{56.26,55.39},{57.13,54.6},{56.68,53.9},{54.4,55.67},{57.17,50.92},{80.8,61.53},{81.23,60.42},{81.13,59.33},{81.29,61.2},{81.95,61.16},{57.02,50.92},{57.13,51.15},{45.37,50.95},{38.95,53.91},{40.13,48.22},{40.42,44.68},{40.86,46.38},{41.03,46.19},{42.33,47.01},{43.42,48.54},{54.09,52.76},{56.94,51.1},{39.22,49.13},{39.11,51.62},{40.55,49.1}}},nil,44,nil,nil,18,nil,nil,0},
[547] = {'Great Goretusk',356,386,16,17,0,{[44]={{15.02,49.55},{17.22,46.93},{46.22,17.11},{46.85,14.27},{46.37,10.43},{48.54,25.27},{18.51,43.63},{19.83,39.97},{45.18,20.49},{24.73,78.45},{31.39,72.22},{29.01,73.33},{42.27,16.33},{27.73,75.36},{26.83,79.36},{33.32,65.78},{33.94,61.07},{33.89,71.26},{30.27,78.31},{38.39,73.29},{28.32,79.34},{25.42,60.53},{17.68,55.26},{15.59,53.98},{18.32,53.98},{16.81,52.3},{32.08,71.09},{19.44,72.77},{17.91,71.07},{31.16,67.88}},[40]={{54.59,68.3},{67.54,70.91},{58.78,58.98},{62.43,51.51},{49.66,68.72},{58.11,62.34},{57.06,67.67},{58.59,68.01},{60.83,67.56},{51.69,67.59},{60.25,50.49},{58.95,49.09},{64.26,66.67},{66.7,68.11},{63.94,55.07},{58.96,56.92}}},nil,44,nil,nil,189,"AH",nil,0},
[548] = {'Murloc Minor Tidecaller',350,377,17,18,0,{[44]={{60.93,61.57},{59.87,61.46},{59.39,61.07},{60.24,62.36},{60.21,62.09},{59.99,62.75},{46.58,51.48},{57.72,62.06},{57.46,61.79},{58.51,59.45},{60.0,62.36},{57.91,60.57},{58.08,60.37},{55.29,61.74},{43.87,54.24},{55.95,60.3},{55.93,60.06},{58.61,60.32},{57.53,61.97},{57.87,60.83},{50.35,70.88},{48.83,72.2},{48.5,72.2},{47.7,71.22},{47.31,70.65},{50.22,68.54},{48.71,69.44},{48.26,67.38},{40.13,48.2},{40.17,45.03},{41.88,49.43},{42.54,50.47},{40.76,55.64},{39.14,47.09},{57.72,65.35}}},nil,44,nil,nil,18,nil,nil,0},
[550] = {'Defias Messenger',300,328,14,15,0,{[40]={{45.1,69.33}}},{[40]={{{45.1,69.33},{45.59,68.72},{45.82,68.16},{45.86,67.68},{45.5,66.54},{45.48,65.86},{45.6,64.98},{44.81,64.29},{44.43,63.5},{44.02,61.83},{43.71,60.33},{43.47,59.15},{43.31,57.58},{43.23,56.35},{43.19,54.62},{42.99,54.02},{42.34,53.21},{42.07,52.61},{41.84,51.89},{41.72,51.27},{41.67,50.35},{41.11,49.3},{40.79,48.46},{40.06,47.56},{38.97,46.27},{38.71,45.64},{38.48,45.34},{37.82,45.59},{37.29,44.79},{36.59,44.37},{35.7,44.04},{34.83,43.49},{33.98,43.11},{33.03,42.96},{32.09,43.34},{31.68,43.86},{31.24,44.87},{30.76,45.87},{30.47,45.81},{30.32,45.62},{29.68,46.18},{29.85,46.74},{29.87,47.3},{30.12,47.65},{30.54,47.88},{30.69,48.33},{30.54,49.03},{30.16,49.68},{29.71,50.26},{29.65,50.08},{30.22,49.53},{30.54,48.96},{30.69,48.21},{30.51,47.85},{29.82,47.28},{29.76,46.1},{30.25,45.6},{30.81,45.93},{30.98,45.34},{31.44,44.43},{31.78,43.65},{32.25,43.28},{32.54,43.15},{32.94,42.88},{33.85,43.06},{34.57,43.42},{35.56,43.89},{36.26,43.94},{36.61,43.34},{36.88,42.34},{36.91,40.81},{37.08,39.59},{37.44,38.56},{37.83,37.11},{38.33,36.3},{39.27,35.29},{40.33,34.5},{40.87,33.67},{41.27,32.75},{41.75,31.01},{42.14,30.36},{42.87,29.36},{43.73,28.62},{44.26,27.98},{44.49,26.34},{44.52,25.35},{44.56,24.69},{44.63,23.49},{45.0,22.85},{44.95,22.45},{44.53,21.44},{44.76,20.65},{44.75,20.37},{44.53,19.7},{44.65,19.28},{44.88,19.01},{45.52,18.16},{45.83,18.08},{46.0,18.28},{46.13,18.68},{46.3,18.95},{45.86,18.13},{45.6,18.1},{45.17,18.63},{44.59,19.42},{44.61,20.15},{44.8,20.67},{44.57,21.37},{44.63,21.71},{45.01,22.83},{44.59,23.61},{44.59,24.3},{44.52,25.34},{44.29,26.24},{44.17,27.89},{43.62,28.71},{42.8,29.55},{41.81,30.92},{41.34,32.51},{40.92,33.66},{40.32,34.46},{39.53,35.09},{38.49,36.1},{37.92,36.95},{37.61,37.82},{37.29,39.05},{36.99,40.11},{36.85,42.07},{36.96,43.24},{37.39,43.94},{37.94,44.61},{38.66,45.55},{39.09,46.39},{39.94,47.42},{40.67,48.25},{40.99,49.0},{41.19,49.46},{41.7,50.43},{41.75,51.49},{42.02,52.51},{42.38,53.27},{43.04,54.15},{43.19,54.7},{43.22,55.98},{42.84,56.38},{42.43,56.36},{42.1,55.87},{41.78,54.16},{41.8,53.34},{41.94,52.98},{42.23,53.0},{42.85,53.82},{43.15,54.48},{43.25,55.31},{43.23,56.54},{43.3,57.5},{43.46,59.1},{43.77,60.62},{44.09,62.03},{44.4,63.23},{44.63,63.92},{44.97,64.48},{45.34,64.81},{45.62,64.98},{45.48,66.11},{45.56,66.76},{45.86,67.7},{45.83,68.24},{45.43,69.06},{44.98,69.49},{44.48,69.61}}}},40,nil,nil,34,nil,nil,0},
[564] = {'Kobold Slave',198,222,10,11,0,nil,nil,0,nil,nil,26,nil,nil,0},
[565] = {'Rabid Dire Wolf',494,531,20,21,0,{[10]={{12.94,69.16},{11.57,33.56},{9.65,40.52},{11.02,32.27},{16.14,29.69},{20.25,28.95},{40.1,22.06},{37.63,25.71},{35.08,26.01},{33.14,29.35},{22.63,25.61},{38.98,23.82},{34.04,28.12},{18.92,25.29},{20.45,25.36},{19.32,28.05},{21.52,30.46},{20.39,28.09},{15.57,26.06},{54.83,18.42},{56.2,19.62},{66.04,18.04},{61.48,19.46},{10.71,51.57},{10.61,60.96},{11.55,57.26},{14.27,27.24},{13.16,30.51},{16.34,27.24},{13.84,27.61},{10.04,46.42},{67.32,20.1},{67.05,22.61}}},nil,10,nil,nil,38,nil,nil,0},
[566] = {'V\'rex',449,449,19,19,0,nil,nil,0,nil,nil,20,nil,nil,0},
[567] = {'Blacknails',328,328,15,15,0,nil,nil,0,nil,nil,17,nil,nil,0},
[568] = {'Shadowhide Warrior',664,713,24,25,0,{[44]={{75.5,30.27},{75.64,29.99},{82.38,55.47},{84.32,54.4},{85.77,58.62},{78.86,47.37},{75.92,36.75},{79.91,45.29},{79.81,44.99},{81.6,46.63},{81.42,48.42},{76.25,37.77},{76.65,37.82},{76.38,38.15},{76.6,35.37},{77.73,44.96},{75.73,31.34},{77.72,34.76},{74.87,38.9},{76.44,41.65},{76.87,41.01},{79.18,40.46},{78.16,39.23},{81.78,40.39},{80.89,36.63},{80.84,35.53}}},nil,44,nil,nil,39,nil,nil,0},
[569] = {'Green Recluse',531,573,21,22,0,{[10]={{13.35,69.24},{68.09,22.69},{54.18,20.37},{69.04,22.56},{71.33,23.72},{72.84,21.53},{13.88,64.76},{64.85,22.38},{62.55,20.44},{13.22,58.41},{66.8,22.5},{10.26,41.5},{11.04,41.94},{50.82,20.34},{51.35,19.28},{75.47,22.73},{56.1,20.44},{59.93,21.9},{58.09,21.04},{57.3,22.33},{54.91,22.04},{61.85,23.21},{12.37,55.07},{13.02,50.98},{68.64,21.95}}},nil,10,nil,nil,22,nil,nil,0},
[570] = {'Brain Eater',896,950,28,29,0,{[10]={{24.48,30.44},{24.79,27.95},{22.31,29.66},{25.44,27.27},{20.7,28.79},{21.38,29.83},{21.67,28.31},{22.08,26.98},{20.56,30.05},{20.21,27.31},{25.67,29.09},{25.92,36.04},{26.87,34.28},{24.43,29.07},{24.93,29.8},{25.01,34.67}}},nil,10,nil,nil,21,nil,nil,0},
[572] = {'Leprithus',404,404,19,19,4,{[40]={{43.04,27.0},{41.93,29.24},{42.15,30.13},{64.71,66.7},{64.93,67.92}}},nil,40,nil,nil,21,nil,nil,0},
[573] = {'Foe Reaper 4000',484,484,20,20,4,{[40]={{44.82,35.38},{51.38,68.38},{50.52,69.26},{50.09,67.11},{47.67,68.93},{47.29,67.04},{46.4,66.04},{46.21,63.24},{53.94,63.06},{50.76,65.24},{40.61,49.56},{40.09,51.93},{38.39,54.29},{37.9,52.0},{36.03,51.34},{38.03,49.4},{33.24,52.89},{34.33,51.3},{44.47,45.52},{44.68,38.92},{43.92,36.71},{42.57,35.49},{44.7,32.66},{46.34,33.36},{46.94,35.53},{48.59,30.1},{49.24,27.43},{50.46,26.61},{51.39,25.42},{52.46,22.89},{51.09,22.2},{49.42,21.94},{50.66,19.3},{53.52,27.56},{54.3,25.78},{62.41,58.04},{63.78,59.55},{64.95,61.32},{63.38,62.02},{62.12,62.38},{61.25,60.14}}},nil,40,nil,nil,14,nil,nil,0},
[574] = {'Naraxis',840,840,27,27,4,{[10]={{86.36,47.57}}},nil,10,nil,nil,22,nil,nil,0},
[575] = {'Fire Elemental',1403,1468,35,36,0,nil,nil,0,nil,nil,67,nil,nil,0},
[576] = {'Watcher Ladimore',895,895,28,28,0,{[10]={{74.02,47.82}}},{[10]={{{74.3,48.05},{74.59,48.19},{74.78,47.61},{75.0,47.41},{75.28,47.36},{75.52,46.37},{75.05,46.26},{75.05,45.47},{74.54,46.09},{74.12,46.18},{73.58,46.53},{73.61,47.18},{74.02,47.82}}}},10,{231},{229},12,"A","The Night Watch",2},
[578] = {'Murloc Scout',449,484,19,20,0,{[44]={{58.21,51.83},{55.64,53.91},{56.91,52.81},{58.06,57.38},{58.27,52.37},{57.96,52.03},{57.91,51.68},{58.26,53.42},{56.26,55.39},{57.13,54.6},{56.68,53.9},{54.4,55.67},{57.17,50.92},{80.8,61.53},{81.23,60.42},{81.13,59.33},{81.29,61.2},{81.95,61.16},{57.02,50.92},{57.13,51.15},{45.37,50.95},{38.95,53.91},{40.13,48.22},{40.42,44.68},{40.86,46.38},{41.03,46.19},{42.33,47.01},{43.42,48.54},{54.09,52.76},{56.94,51.1},{39.22,49.13},{39.11,51.62},{40.55,49.1}}},nil,44,nil,nil,18,nil,nil,0},
[579] = {'Shadowhide Assassin',617,664,23,24,0,{[44]={{79.0,54.34},{80.18,49.06}}},nil,44,nil,nil,39,nil,nil,0},
[580] = {'Redridge Drudger',494,531,20,21,0,{[44]={{16.07,17.13},{20.29,21.05},{15.89,21.17},{15.96,18.87},{19.96,27.48},{21.63,23.63},{21.28,17.37},{22.35,20.55},{20.2,13.23},{18.73,15.3},{22.26,16.55},{18.82,24.3},{17.04,17.92},{18.54,15.22}}},nil,44,nil,nil,19,nil,nil,0},
[582] = {'Old Blanchy',55,55,2,2,0,{[40]={{59.77,19.42}}},nil,40,nil,nil,35,"AH",nil,0},
[583] = {'Defias Ambusher',156,176,8,9,0,nil,nil,0,nil,nil,27,nil,nil,0},
[584] = {'Kazon',840,840,27,27,4,{[44]={{34.9,8.27},{36.87,11.98},{36.4,9.38},{35.01,6.72}}},nil,44,nil,nil,40,nil,nil,0},
[587] = {'Bloodscalp Warrior',1221,1279,33,34,0,{[33]={{29.82,19.1},{33.43,13.77},{29.76,21.62},{34.26,14.57},{34.04,16.78}}},nil,33,nil,nil,28,nil,nil,0},
[588] = {'Bloodscalp Scout',1279,1342,34,35,0,{[33]={{22.26,13.08},{25.94,12.21},{25.29,10.55},{25.55,9.33},{24.7,12.3},{24.8,12.32},{24.65,12.68},{25.46,13.43},{24.45,12.59},{24.8,12.56},{24.79,10.98},{26.14,9.31},{26.13,10.11},{25.9,9.0},{25.5,8.99},{25.6,10.59},{27.6,11.65},{25.66,12.14},{25.14,11.32},{24.07,13.3},{25.09,13.41},{25.33,12.93},{24.4,11.18},{23.13,12.26},{23.05,12.57},{23.43,12.37},{23.08,11.99},{23.0,12.09}}},nil,33,nil,nil,28,nil,nil,0},
[589] = {'Defias Pillager',263,285,14,15,0,{[40]={{29.24,51.04},{28.83,49.53},{29.76,49.81},{38.76,69.61},{45.4,70.35},{44.43,67.35},{44.3,68.62},{44.84,68.73},{43.6,68.1},{43.74,66.41},{43.58,68.25},{43.9,68.36},{41.98,69.56},{43.31,69.58},{43.46,70.8},{43.0,70.82},{41.85,69.5},{42.27,69.47},{31.74,43.9},{32.09,43.98},{30.91,43.04},{31.59,44.87},{33.23,58.59},{33.71,56.86},{33.16,56.64},{32.78,56.66},{32.08,57.71},{38.79,56.85},{38.81,57.75},{37.11,55.94},{36.68,53.79},{35.87,53.15},{36.04,53.09},{35.11,53.78},{35.0,53.77},{29.64,47.25},{30.4,45.99},{46.26,67.35},{42.98,68.13},{43.39,68.83},{44.17,68.2},{43.1,70.12},{41.51,71.24},{42.58,69.17},{45.62,69.39}}},nil,40,nil,nil,17,nil,nil,0},
[590] = {'Defias Looter',273,300,13,14,0,{[40]={{29.69,47.08},{29.86,46.14},{30.76,48.44},{29.62,50.19},{28.93,50.14},{46.0,70.65},{46.01,71.12},{45.5,70.37},{44.04,69.24},{44.37,67.71},{44.98,67.44},{43.81,67.75},{43.67,67.54},{43.48,66.89},{43.43,68.07},{43.93,68.07},{42.12,69.46},{42.24,70.52},{41.51,69.84},{41.95,69.63},{31.73,43.03},{31.22,44.64},{37.95,57.36},{38.65,56.86},{38.53,57.63},{38.81,57.98},{38.65,58.11},{37.09,58.02},{37.21,54.53},{36.04,54.71},{35.98,54.63},{36.34,55.46},{36.54,54.07},{36.73,54.0},{35.75,53.72},{29.94,45.87},{30.1,49.7},{45.8,69.29},{43.7,69.26},{44.46,65.73}}},nil,40,nil,nil,17,nil,nil,0},
[594] = {'Defias Henchman',984,1068,15,16,1,{[40]={{42.88,72.6},{41.84,78.44},{43.94,73.51},{43.82,77.02},{42.2,74.49}}},nil,40,nil,nil,17,nil,nil,0},
[595] = {'Bloodscalp Hunter',1279,1342,34,35,0,{[33]={{22.69,11.96},{22.35,12.8},{25.99,9.82},{26.0,9.41},{25.91,12.67},{26.09,12.39},{25.56,13.21},{26.13,12.69},{25.93,8.4},{25.72,9.32},{26.02,9.18},{25.05,9.45},{25.08,9.9},{22.94,11.02},{24.46,12.32},{26.31,11.32},{23.85,13.16},{23.34,12.05}}},nil,33,nil,nil,28,nil,nil,0},
[596] = {'Brainwashed Noble',1061,1061,18,18,2,{[40]={{43.98,78.33}}},nil,40,nil,nil,17,nil,nil,0},
[597] = {'Bloodscalp Berserker',1469,1536,36,37,0,{[33]={{20.26,12.2},{19.89,11.87},{19.98,12.07},{23.09,11.25},{24.72,9.39},{20.7,11.15},{19.37,12.84},{19.52,11.95},{24.42,9.11},{24.31,9.47},{23.92,9.92},{23.77,9.4},{22.99,8.81},{22.71,9.18},{23.14,10.7},{23.66,9.89},{23.56,9.7},{24.08,10.7},{23.3,9.15}}},nil,33,nil,nil,28,nil,nil,0},
[598] = {'Defias Miner',417,417,18,18,0,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[599] = {'Marisa du\'Paige',1062,1062,18,18,2,{[40]={{42.23,79.91},{43.86,79.1},{44.23,76.83}}},nil,40,nil,nil,17,nil,nil,0},
[601] = {'Capo the Mean',1068,1068,16,16,2,nil,nil,0,nil,nil,17,nil,nil,0},
[603] = {'Grimtooth',3997,3997,59,59,0,{[2597]={{51.71,94.86}}},nil,2597,nil,nil,14,nil,nil,0},
[604] = {'Plague Spreader',840,896,27,28,0,{[10]={{22.91,28.22},{24.11,27.52},{22.48,28.24},{20.12,28.38},{17.86,34.21},{23.71,34.07},{24.06,35.05},{15.78,34.64},{16.83,32.66},{16.44,34.12},{25.59,32.74},{24.45,34.75},{25.89,35.23},{25.45,30.65},{24.14,36.05},{23.61,36.73},{23.41,35.02},{23.36,35.71},{24.47,34.72},{25.78,34.35},{25.67,33.66},{26.31,34.2}}},nil,10,nil,nil,21,nil,nil,0},
[615] = {'Blackrock Tracker',617,664,23,24,0,{[44]={{26.14,12.87},{37.02,10.43},{27.24,9.96},{39.19,14.85},{38.99,14.36},{36.7,12.64},{35.53,9.92},{35.9,10.8},{37.32,12.76},{34.93,9.12},{27.44,8.47},{35.94,7.87},{32.18,7.05},{29.65,8.78},{31.11,10.62}}},nil,44,nil,nil,40,nil,nil,0},
[616] = {'Chatter',617,617,23,23,4,{[44]={{52.13,45.24},{52.13,32.58},{50.57,34.63},{51.42,38.66},{52.47,36.15},{55.21,37.74},{54.8,41.76},{58.3,48.29},{56.49,47.08},{53.37,49.12},{52.49,43.11},{48.21,41.11},{50.3,36.88},{53.35,46.07}}},nil,44,nil,nil,22,nil,nil,0},
[619] = {'Defias Conjurer',855,921,15,16,1,{[40]={{43.7,74.32},{40.49,78.25},{41.69,76.08}}},{[40]={{{43.7,74.32},{43.85,74.18},{43.91,73.96},{43.9,73.73},{43.9,73.63},{43.91,73.81},{43.9,73.98},{43.84,74.19},{43.69,74.31},{43.51,74.28},{43.44,74.22},{43.17,73.99},{43.09,73.89},{42.94,73.53},{42.82,73.28},{42.73,73.12},{42.65,72.91},{42.75,73.13},{42.85,73.34},{42.96,73.58},{43.05,73.81},{43.1,73.95},{43.19,74.01},{43.42,74.23},{43.47,74.28},{43.54,74.33}},{{40.49,78.25},{40.67,78.49},{40.71,78.72},{40.72,78.94},{40.78,79.24},{40.95,79.47},{41.14,79.59},{41.28,79.64},{41.51,79.66},{41.65,79.54},{41.69,79.32},{41.73,79.13},{41.79,78.87},{41.86,78.65},{41.93,78.47},{42.01,78.3},{42.17,78.15},{42.29,78.23},{42.4,78.32},{42.29,78.24},{42.14,78.18},{41.99,78.3},{41.9,78.5},{41.84,78.71},{41.8,78.9},{41.75,79.21},{41.68,79.54},{41.49,79.67},{41.27,79.62},{41.1,79.56},{40.93,79.47},{40.8,79.24},{40.75,79.01},{40.74,78.9},{40.72,78.68},{40.64,78.43},{40.49,78.27},{40.37,78.21},{40.21,78.21},{39.94,78.22},{40.2,78.22}},{{41.69,76.08},{41.85,76.15},{42.09,76.29},{42.15,76.11},{42.23,75.91},{42.53,75.94},{42.61,76.06},{42.69,76.25},{42.73,76.42},{42.75,76.62},{42.87,76.96},{42.75,76.64},{42.71,76.37},{42.7,76.25},{42.65,75.99},{42.48,75.91},{42.2,75.92},{42.09,76.28},{41.95,76.21},{41.83,76.15},{41.67,76.06},{41.54,76.0},{41.42,76.02},{41.58,76.03}}}},40,nil,nil,17,nil,nil,0},
[620] = {'Chicken',1,1,1,1,0,{[11]={{20.97,70.13},{17.24,72.18},{17.21,71.45},{16.98,71.78},{21.24,69.89},{21.52,70.53},{25.56,68.64},{25.63,68.0},{25.9,67.84},{27.49,65.9}},[10]={{78.01,48.04},{72.73,54.34},{77.16,55.54},{79.77,46.94},{75.73,56.33},{76.54,53.72},{77.87,44.25},{73.57,53.09}},[44]={{20.31,47.08},{22.31,45.84},{20.24,46.36}},[17]={{61.63,23.74},{61.78,23.91},{62.56,56.77},{61.76,53.64},{61.77,23.89},{61.63,24.27},{60.76,55.49},{62.7,56.72},{61.73,23.75},{62.25,54.05},{62.04,24.2},{61.29,53.53},{61.69,53.32},{61.97,23.89}},[267]={{78.93,42.47},{52.6,56.95},{52.24,55.79},{79.39,44.44},{63.31,61.35},{64.56,61.11},{33.18,41.23},{29.87,40.46},{32.77,43.41},{36.04,40.48},{51.25,54.09},{34.98,47.13},{50.12,57.02}},[15]={{66.42,48.52},{63.93,50.06},{66.81,46.11},{65.34,50.66},{64.41,47.47},{65.52,49.47},{67.63,50.77}},[85]={{38.04,48.91},{52.17,56.23},{52.95,56.31},{38.08,51.71},{60.26,51.27},{60.87,53.59},{37.21,50.15}},[12]={{36.02,60.55},{36.46,59.87},{36.31,59.79},{36.39,60.17},{36.01,60.13},{40.52,64.27},{40.52,64.38},{42.87,66.23},{42.68,66.13},{48.49,86.53},{48.57,86.63},{48.39,86.73},{79.08,67.74},{79.33,67.62},{77.72,66.36},{78.22,66.24},{77.65,66.56},{77.6,66.19},{77.84,66.49},{77.68,65.54}},[40]={{48.73,21.32},{55.64,30.85},{55.92,31.95},{51.71,31.23},{38.23,57.08},{38.84,57.0},{45.34,69.59},{38.94,56.69},{45.68,39.19},{45.77,38.72},{49.75,19.49},{45.14,69.93},{51.52,31.28},{49.19,20.47},{48.96,20.8},{49.31,19.76},{44.73,68.08},{38.48,56.67},{49.91,18.97},{45.42,69.6},{45.64,39.6},{44.73,68.46},{56.24,31.82},{55.66,31.46},{56.1,29.71},{56.21,29.61},{56.1,30.05},{51.51,31.6}},[1]={{67.1,3.78}}},nil,40,{3861},{3861},31,"AH",nil,2},
[622] = {'Goblin Engineer',1251,1347,18,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[623] = {'Skeletal Miner',1158,1251,17,18,1,{[40]={{40.71,81.81},{41.52,81.35},{41.61,81.67},{42.15,81.36},{41.37,83.19},{40.69,82.29},{40.86,80.81},{41.22,83.21},{40.74,81.2}}},nil,40,nil,nil,21,nil,nil,0},
[624] = {'Undead Excavator',1158,1251,17,18,1,{[40]={{42.14,82.98},{40.56,80.91},{40.8,82.58},{42.04,82.48},{40.87,81.47}}},nil,40,nil,nil,21,nil,nil,0},
[625] = {'Undead Dynamiter',1158,1251,17,18,1,{[40]={{41.08,80.96},{41.0,82.74},{41.74,83.26},{41.85,81.44},{42.44,83.31},{41.55,82.54}}},nil,40,nil,nil,21,nil,nil,0},
[626] = {'Foreman Thistlenettle',1452,1452,20,20,1,{[40]={{42.22,82.61}}},nil,40,nil,nil,21,nil,nil,0},
[628] = {'Black Ravager',664,713,24,25,0,{[10]={{48.55,61.55},{69.98,35.41},{66.1,28.73},{63.74,27.8},{52.74,63.16},{64.13,25.65},{67.34,31.79},{68.37,33.3},{59.72,57.79},{59.33,58.84}}},nil,10,nil,nil,38,nil,nil,0},
[631] = {'pnagle\'s test dude',42,55,1,2,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[633] = {'Elaine Carevin',417,417,18,18,0,{[10]={{75.34,48.75}}},nil,10,{163,164,165},nil,12,"A",nil,2},
[634] = {'Defias Overseer',1158,1251,17,18,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[636] = {'Defias Blackguard',1347,1452,19,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[638] = {'Goblin Mercenary',984,1068,15,16,1,nil,nil,0,nil,nil,17,nil,nil,0},
[639] = {'Edwin VanCleef',4168,4168,21,21,2,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"Defias Kingpin",0},
[641] = {'Goblin Woodcarver',1251,1347,18,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[642] = {'Sneed\'s Shredder',3872,3872,20,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"Lumbermaster",0},
[643] = {'Sneed',2420,2420,20,20,1,nil,nil,0,nil,nil,17,nil,"Lumbermaster",0},
[644] = {'Rhahk\'Zor',4490,4490,19,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"The Foreman",0},
[645] = {'Cookie',2904,2904,20,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"The Ship's Cook",0},
[646] = {'Mr. Smite',3872,3872,20,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,27,nil,"The Ship's First Mate",0},
[647] = {'Captain Greenskin',2904,2904,20,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[648] = {'Bridge Worker Trent',102,102,5,5,0,nil,nil,0,nil,nil,12,"A",nil,0},
[649] = {'Bridge Worker Dmitri',198,198,10,10,0,nil,nil,0,nil,nil,12,"A",nil,0},
[650] = {'Bridge Worker Jess',120,120,6,6,0,nil,nil,0,nil,nil,12,"A",nil,0},
[651] = {'Bridge Worker Daniel',120,120,6,6,0,nil,nil,0,nil,nil,12,"A",nil,0},
[652] = {'Bridge Worker Matthew',120,120,6,6,0,nil,nil,0,nil,nil,12,"A",nil,0},
[653] = {'Bridge Worker Alex',120,120,6,6,0,nil,nil,0,nil,nil,12,"A",nil,0},
[656] = {'Wilder Thistlenettle',484,484,20,20,0,{[1519]={{65.44,21.17}}},nil,1519,{167,168},{167,168},55,"A",nil,2},
[657] = {'Defias Pirate',1347,1452,19,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[658] = {'Sten Stoutarm',102,102,5,5,0,{[1]={{29.93,71.2}}},nil,1,{179,233,3106,3107,3108,3109,3110,3112,3113,3114,3115},{179},55,"A",nil,3},
[659] = {'El Pollo Grande',2768,2768,50,50,0,nil,nil,0,nil,nil,128,nil,"The Black Chicken of Death",0},
[660] = {'Bloodscalp Witch Doctor',1257,1257,37,37,0,{[33]={{20.26,11.79},{20.09,11.94},{19.87,12.13},{20.87,15.38},{20.87,12.96},{21.01,13.54},{20.89,12.12},{20.5,14.3},{19.38,11.39},{20.42,12.94},{24.16,9.81},{24.03,9.98},{24.24,8.85},{23.57,8.19},{24.05,9.45},{23.37,8.41},{24.57,10.65},{24.69,10.31}}},nil,33,nil,nil,28,nil,nil,0},
[661] = {'Jonathan Carevin',712,712,25,25,0,{[10]={{75.32,49.02}}},nil,10,{1043,1044},{223,1042,1043},12,"A",nil,2},
[663] = {'Calor',484,484,20,20,0,{[10]={{75.75,47.57}}},{[10]={{{75.31,48.07},{75.3,48.05},{75.75,47.57}}}},10,{173,221,222,223},{173,221,222},12,"A",nil,2},
[664] = {'Benjamin Carevin',55,55,2,2,0,{[10]={{74.99,48.59}}},nil,10,nil,nil,12,"A",nil,2},
[667] = {'Skullsplitter Warrior',1678,1753,39,40,0,{[33]={{47.19,38.55},{47.23,38.59},{47.17,38.63},{45.92,38.0},{46.45,38.82},{46.48,39.09},{46.58,38.86},{48.37,41.73},{48.52,40.87},{47.55,39.33},{47.33,39.9},{47.46,39.77},{47.05,41.81},{45.98,40.36},{45.0,38.06},{47.1,39.46},{46.94,39.71},{46.57,40.44},{46.53,31.42},{46.48,31.42},{46.52,31.51},{48.76,37.45},{48.73,37.52},{44.08,40.07},{44.29,39.68},{44.17,39.45},{45.04,40.22},{43.75,39.42},{43.41,39.5},{43.79,40.17},{47.58,38.83},{48.71,40.1},{48.16,39.57},{47.64,41.02},{46.51,30.01},{47.05,32.49},{47.54,33.3},{47.1,34.09},{45.99,32.34},{46.05,32.0},{46.24,32.45},{46.22,32.0},{46.41,32.0},{45.19,32.34},{45.06,34.07},{45.55,31.7},{42.78,35.14},{42.73,35.19},{42.81,35.21},{48.8,37.51},{42.41,35.05},{41.93,36.28},{42.18,35.79},{42.3,36.11},{41.91,35.96},{42.12,36.29},{44.0,37.16},{43.34,36.39},{44.08,34.0},{43.96,35.43},{42.45,33.27},{43.51,33.01},{43.45,34.74},{42.44,35.29},{47.18,30.71},{43.49,37.91},{47.77,40.11}}},nil,33,nil,nil,30,nil,nil,0},
[669] = {'Skullsplitter Hunter',1902,1981,41,42,0,{[33]={{46.16,42.97},{45.04,39.56},{45.98,43.06},{45.04,44.09},{47.41,39.01},{44.92,41.72},{45.56,38.64},{45.79,43.54},{45.93,42.4}}},nil,33,nil,nil,30,nil,nil,0},
[670] = {'Skullsplitter Witch Doctor',1522,1585,41,42,0,{[33]={{45.6,42.78},{44.3,41.7},{44.32,42.21},{45.8,41.79},{45.55,42.22},{44.98,41.84}}},nil,33,nil,nil,30,nil,nil,0},
[671] = {'Bloodscalp Headhunter',1469,1536,36,37,0,{[33]={{20.04,11.67},{20.06,13.52},{23.69,8.83},{24.69,10.51},{21.33,10.2},{21.45,10.29},{22.74,8.62},{22.72,9.65},{23.37,10.92},{23.21,10.85},{22.7,10.79},{22.94,10.16},{24.46,9.9},{23.4,9.54},{23.44,8.78},{23.54,8.44},{23.68,10.88},{24.22,10.42},{24.39,10.57},{23.31,8.16}}},nil,33,nil,nil,28,nil,nil,0},
[672] = {'Skullsplitter Spiritchaser',1711,1711,44,44,0,{[33]={{48.01,42.58},{47.68,43.19},{48.05,43.24},{47.66,42.18},{44.32,44.85},{47.52,43.69}}},nil,33,nil,nil,30,nil,nil,0},
[674] = {'Venture Co. Strip Miner',1829,1902,40,41,0,{[33]={{41.67,43.91},{41.81,44.53},{42.29,45.09},{41.58,44.62},{42.17,46.22},{42.29,44.33},{42.06,46.11},{41.77,45.17},{42.02,46.3},{41.94,43.11},{42.05,42.57},{42.11,41.8},{42.38,41.41},{41.58,41.41},{41.43,43.83},{41.18,41.92},{40.35,43.27},{40.78,43.12},{40.35,43.79},{41.63,42.31},{41.21,43.01},{41.65,42.88},{41.32,42.43},{41.55,43.48},{41.3,43.62}}},nil,33,nil,nil,47,nil,nil,0},
[675] = {'Venture Co. Foreman',1981,1981,42,42,0,{[33]={{41.87,42.61}}},nil,33,nil,nil,47,nil,nil,0},
[676] = {'Venture Co. Surveyor',1522,1585,41,42,0,{[33]={{42.06,44.54},{42.09,46.2},{41.0,43.61}}},nil,33,nil,nil,47,nil,nil,0},
[677] = {'Venture Co. Tinkerer',1292,1332,40,41,0,{[33]={{41.97,44.64},{42.2,44.77},{41.82,41.6},{41.2,43.87}}},nil,33,nil,nil,47,nil,nil,0},
[678] = {'Mosh\'Ogg Mauler',5148,5346,43,44,1,{[33]={{51.5,28.54},{51.48,27.13},{50.77,27.72},{50.63,27.84},{50.19,27.73},{51.57,26.64},{52.52,28.18}}},nil,33,nil,nil,45,nil,nil,0},
[679] = {'Mosh\'Ogg Shaman',4119,4278,43,44,1,{[33]={{50.31,30.45},{50.26,30.58},{50.42,30.55},{50.4,30.4},{52.17,27.63},{51.23,27.87},{50.85,27.12},{51.0,26.61},{50.14,27.94}}},nil,33,nil,nil,45,nil,nil,0},
[680] = {'Mosh\'Ogg Lord',5544,5544,45,45,1,{[33]={{52.79,27.68},{52.88,27.85},{52.12,26.66},{50.57,31.28}}},nil,33,nil,nil,45,nil,nil,0},
[681] = {'Young Stranglethorn Tiger',1050,1107,30,31,0,{[33]={{38.7,15.36},{37.35,14.33},{39.21,14.45},{38.84,13.64},{36.11,15.31},{37.29,11.56},{40.19,9.93},{33.91,12.98},{35.07,12.11},{34.73,17.51},{35.98,12.93},{35.13,16.52},{35.65,12.14},{31.43,8.39},{32.41,9.57},{30.64,7.56},{33.06,9.57},{31.54,9.94},{33.36,9.94},{33.57,11.15},{34.07,11.33},{40.41,8.3},{34.54,14.0}}},nil,33,nil,nil,16,nil,nil,0},
[682] = {'Stranglethorn Tiger',1163,1221,32,33,0,{[33]={{47.4,11.43},{46.6,17.51},{47.17,18.47},{30.18,13.58},{29.73,11.29},{30.4,9.02},{42.88,15.25},{47.13,16.81},{28.96,9.54},{30.34,15.24},{29.36,10.41},{30.75,16.05},{46.0,16.89},{46.53,12.93},{48.07,13.69},{46.58,14.4},{47.59,12.85},{48.19,12.18},{46.08,15.32},{46.57,16.09},{47.13,15.25},{44.0,13.68},{45.47,14.54}}},nil,33,nil,nil,16,nil,nil,0},
[683] = {'Young Panther',1050,1107,30,31,0,{[33]={{37.33,8.25},{36.08,7.24},{35.08,15.12},{41.27,8.08},{36.62,13.76},{39.13,6.59},{39.22,8.06},{35.03,14.16},{38.29,13.45},{37.75,12.77},{42.91,10.5},{42.07,10.14},{41.39,10.46},{42.47,9.56},{43.06,12.31},{42.31,13.2},{41.78,12.75},{41.27,13.44},{40.54,11.4},{40.65,11.19},{41.77,12.98},{41.35,12.82},{42.36,13.22},{42.86,13.63}}},nil,33,nil,nil,16,nil,nil,0},
[684] = {'Shadowmaw Panther',1536,1604,37,38,0,{[33]={{41.3,34.76},{36.19,35.67},{37.28,45.25},{39.29,45.54},{40.34,40.99},{39.55,44.17},{46.09,26.19},{46.44,26.92},{39.49,41.75},{49.26,23.21},{50.21,23.04},{49.26,20.39},{50.28,21.79},{46.45,22.54},{47.23,23.07},{48.16,21.6},{48.07,23.01},{49.68,24.06},{48.03,27.81},{49.71,25.47},{48.88,23.86},{47.67,22.32},{46.52,28.44},{49.27,24.51},{50.25,24.68},{46.97,29.57},{47.02,27.74},{36.55,39.1},{48.66,20.75},{35.62,36.22},{49.23,21.6},{45.47,25.29},{41.23,36.34},{48.69,22.22},{35.49,38.01},{38.67,38.61},{39.86,37.6},{40.29,39.62},{40.73,40.21},{41.95,38.89},{42.25,38.15},{41.38,38.22},{37.15,38.86},{38.07,39.32},{50.66,20.61},{49.74,20.77},{48.09,20.2},{36.5,36.11},{37.22,35.55},{36.03,33.95},{39.37,33.31},{38.7,32.86},{39.59,35.55},{41.33,39.76},{41.19,40.88},{35.15,36.96},{40.52,37.73},{39.14,39.9},{39.22,34.84},{39.7,40.72},{36.16,37.17},{39.22,37.91},{36.59,37.8},{38.73,37.12},{38.18,36.91},{37.61,36.4},{37.63,33.03},{47.58,27.41},{45.46,26.77},{45.94,27.72},{46.53,26.89},{38.61,35.69},{38.33,34.67},{39.57,42.56},{36.59,34.82},{40.33,31.7},{39.2,41.03}}},nil,33,nil,nil,16,nil,nil,0},
[685] = {'Stranglethorn Raptor',1221,1279,33,34,0,{[33]={{24.17,16.16},{23.72,15.41},{24.53,15.69},{24.06,15.67},{24.51,16.19},{24.76,16.07},{27.29,16.65},{26.75,17.61},{26.01,17.09},{25.72,15.81},{26.55,16.03},{27.39,15.45},{27.55,17.67},{27.79,14.32}}},nil,33,nil,nil,48,nil,nil,0},
[686] = {'Lashtail Raptor',1403,1469,35,36,0,{[33]={{39.34,19.1},{38.55,19.79},{39.07,22.09},{38.87,21.64},{38.24,20.49},{35.95,27.15},{38.28,19.16},{35.62,26.33},{38.88,24.59},{37.57,27.9},{37.82,19.75},{37.73,21.48},{38.44,25.24},{38.77,26.17},{38.1,27.02},{30.6,24.0},{30.69,23.72},{30.27,24.66},{30.66,23.5},{30.55,22.47},{30.8,23.22},{32.5,21.42},{31.97,20.68},{32.4,23.17},{32.4,24.59},{32.06,23.79},{32.97,23.89},{33.96,25.47},{33.4,24.55}}},nil,33,nil,nil,48,nil,nil,0},
[687] = {'Jungle Stalker',1829,1902,40,41,0,{[33]={{23.35,48.24},{28.28,46.47},{27.31,43.38},{32.56,37.21},{34.65,38.92},{34.63,40.15},{32.44,41.72},{32.0,42.36},{31.21,44.64},{32.11,43.06},{31.35,41.96},{30.64,44.1},{31.88,40.79},{33.43,37.21},{31.55,40.7},{30.45,41.83},{32.95,36.54},{31.48,43.36},{30.14,43.56},{28.91,44.16},{28.88,42.63},{29.95,44.07},{28.83,45.6},{28.33,43.49},{30.92,42.54},{27.45,48.11},{27.95,47.22},{29.33,43.56},{28.22,44.96},{27.3,49.72},{27.8,48.93},{27.6,50.28},{24.9,51.2},{23.68,48.93},{26.14,51.36},{26.92,48.69},{23.43,50.3},{26.05,49.89},{26.63,50.53},{23.0,49.68},{24.11,49.64},{23.15,51.5},{32.7,39.17}}},nil,33,nil,nil,48,nil,nil,0},
[688] = {'Stone Maw Basilisk',1107,1163,31,32,0,{[33]={{34.68,6.74},{35.69,6.75},{33.67,6.36},{36.6,8.27},{30.83,2.44}}},nil,33,nil,nil,49,nil,nil,0},
[689] = {'Crystal Spine Basilisk',1279,1342,34,35,0,{[33]={{49.23,9.64},{47.99,6.46},{48.73,10.44},{47.4,5.88},{46.57,5.84},{48.2,8.15},{23.71,16.98},{23.06,17.65},{24.19,17.72},{24.52,16.84},{24.64,18.16},{24.66,16.99},{27.09,18.55},{25.11,17.68},{26.25,18.09},{48.68,8.96}}},nil,33,nil,nil,49,nil,nil,0},
[690] = {'Cold Eye Basilisk',1678,1753,39,40,0,{[33]={{28.73,40.88},{31.36,37.3},{30.87,37.14},{29.93,37.61},{28.77,38.8},{29.27,38.05},{28.3,39.63},{27.69,42.68},{27.7,41.0},{28.22,41.83},{36.99,41.74},{36.21,42.03},{38.15,40.36},{37.18,40.21},{36.56,42.59},{36.18,43.57},{35.66,42.62},{35.53,39.42},{36.46,41.15}}},nil,33,nil,nil,49,nil,nil,0},
[691] = {'Lesser Water Elemental',1469,1536,36,37,0,{[33]={{19.9,24.49},{19.83,23.84},{21.88,23.9},{21.87,24.36},{21.43,23.19},{21.53,24.67},{21.39,23.77},{20.95,23.68},{21.01,23.12},{20.39,23.9},{20.4,23.17},{20.97,24.59},{21.01,23.32},{20.36,24.58},{20.48,22.26},{22.53,23.13},{22.16,23.14},{21.44,22.41},{22.04,22.41},{21.02,22.13},{20.31,21.57},{19.94,21.61},{19.43,22.31},{20.0,22.8}}},nil,33,nil,nil,91,nil,nil,0},
[693] = {'Secondary Skill Trainer',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Trainer",0},
[694] = {'Bloodscalp Axe Thrower',1221,1279,33,34,0,{[33]={{29.69,19.62},{28.98,19.12},{28.81,19.95},{29.34,20.0},{33.73,15.64},{33.48,17.02},{33.93,15.88},{33.56,15.61},{34.56,16.0},{33.95,15.43}}},nil,33,nil,nil,28,nil,nil,0},
[696] = {'Skullsplitter Axe Thrower',1678,1753,39,40,0,{[33]={{47.19,38.55},{47.23,38.59},{47.17,38.63},{45.92,38.0},{46.45,38.82},{46.48,39.09},{46.58,38.86},{48.37,41.73},{48.52,40.87},{47.55,39.33},{47.33,39.9},{47.46,39.77},{47.05,41.81},{45.98,40.36},{45.0,38.06},{47.1,39.46},{46.94,39.71},{46.57,40.44},{46.53,31.42},{46.48,31.42},{46.52,31.51},{48.76,37.45},{48.73,37.52},{44.08,40.07},{44.29,39.68},{44.17,39.45},{45.04,40.22},{43.75,39.42},{43.41,39.5},{43.79,40.17},{47.58,38.83},{48.71,40.1},{48.16,39.57},{47.64,41.02},{46.51,30.01},{47.05,32.49},{47.54,33.3},{47.1,34.09},{45.99,32.34},{46.05,32.0},{46.24,32.45},{46.22,32.0},{46.41,32.0},{45.19,32.34},{45.06,34.07},{45.55,31.7},{42.78,35.14},{42.73,35.19},{42.81,35.21},{48.8,37.51},{42.41,35.05},{41.93,36.28},{42.18,35.79},{42.3,36.11},{41.91,35.96},{42.12,36.29},{44.0,37.16},{43.34,36.39},{44.08,34.0},{43.96,35.43},{42.45,33.27},{43.51,33.01},{43.45,34.74},{42.44,35.29},{47.18,30.71},{43.49,37.91},{47.77,40.11}}},nil,33,nil,nil,30,nil,nil,0},
[697] = {'Bloodscalp Shaman',1021,1064,33,34,0,{[33]={{29.82,19.46},{29.89,19.72},{29.66,19.12},{29.57,19.25},{30.71,19.35},{30.31,20.73},{30.57,18.09},{30.45,16.77},{29.52,19.43},{29.5,19.65}}},nil,33,nil,nil,28,nil,nil,0},
[698] = {'Bloodscalp Tiger',1279,1342,34,35,0,nil,nil,0,nil,nil,28,nil,nil,0},
[699] = {'Bloodscalp Beastmaster',1279,1342,34,35,0,{[33]={{26.27,13.39},{25.27,9.05},{25.1,10.62},{22.92,11.32},{22.55,8.37},{27.54,11.32}}},nil,33,nil,nil,28,nil,nil,0},
[700] = {'Bloodscalp Panther',769,825,25,26,0,nil,nil,0,nil,nil,28,nil,nil,0},
[701] = {'Bloodscalp Mystic',1064,1110,34,35,0,{[33]={{22.54,13.37},{24.23,13.24},{26.28,12.16},{26.27,12.41},{26.11,13.42},{24.79,12.18},{26.35,13.24},{23.89,12.2},{26.11,12.17},{25.43,9.2},{26.11,8.95},{26.17,8.33},{25.68,9.11},{25.39,9.96},{25.12,9.3},{25.05,9.72},{25.45,9.59},{25.72,10.03},{27.21,11.26},{26.46,11.42},{27.58,11.0},{25.88,11.03},{26.0,11.5},{25.35,12.24},{24.7,11.5},{25.18,11.27},{23.9,13.22},{23.13,13.15},{23.38,12.61},{22.93,12.23}}},nil,33,nil,nil,28,nil,nil,0},
[702] = {'Bloodscalp Scavenger',1221,1279,33,34,0,{[33]={{31.16,12.42},{31.29,12.89},{31.41,11.43},{31.57,12.08},{31.46,14.36},{32.99,13.67},{31.95,13.65},{32.64,12.93}}},nil,33,nil,nil,28,nil,nil,0},
[703] = {'Lieutenant Fangore',788,788,26,26,0,{[44]={{80.18,37.06}}},nil,44,nil,nil,39,nil,nil,0},
[704] = {'Ragged Timber Wolf',55,55,2,2,0,{[1]={{23.26,78.74},{23.22,77.69},{24.01,79.74},{24.84,78.22},{25.5,79.51},{26.89,78.02},{25.96,75.3},{26.88,76.22},{28.1,78.07},{27.66,77.03},{27.96,76.08},{27.41,75.39},{26.8,75.08},{29.66,74.8},{28.76,76.92},{29.8,74.74}}},nil,1,nil,nil,32,"AH",nil,0},
[705] = {'Ragged Young Wolf',42,42,1,1,0,{[1]={{32.28,70.8},{31.42,70.05},{31.3,73.97},{29.93,73.41},{30.31,74.18},{30.91,73.17},{30.76,74.59},{31.14,69.04},{28.73,72.36},{28.56,72.15},{26.68,69.85},{27.6,72.36},{27.35,71.1},{27.97,73.25},{25.97,70.9},{26.48,70.81},{26.05,69.19},{22.57,78.23},{23.87,77.86},{25.58,78.07},{27.61,74.19},{26.39,74.74},{28.05,74.97},{28.22,75.5},{28.54,75.85},{28.84,73.81},{28.48,75.06},{28.68,72.67},{28.41,73.89},{27.85,73.22},{28.41,74.35},{28.31,71.75},{28.98,74.51},{30.32,75.04},{29.23,75.89},{29.66,74.27},{29.32,74.7},{29.23,77.98},{29.49,77.15},{29.77,75.91},{29.25,73.41},{28.81,73.63},{29.03,74.65},{29.24,73.92},{29.87,74.49},{30.46,73.74},{30.02,73.7},{30.79,72.95},{31.37,73.87},{30.9,75.82},{28.79,74.16}}},nil,1,nil,nil,32,"AH",nil,0},
[706] = {'Frostmane Troll Whelp',71,86,3,4,0,{[1]={{20.78,75.93},{21.29,76.03},{21.0,75.33},{20.84,76.26},{21.03,76.44},{20.21,75.89},{21.42,76.97},{21.39,77.96},{20.39,77.17},{20.83,76.63},{22.31,78.12},{22.09,78.84},{22.61,78.94},{22.32,79.32},{23.34,79.96},{23.77,80.33},{22.99,79.35},{22.76,80.8},{22.66,79.97},{22.85,79.96},{22.85,80.13},{22.67,80.19},{25.86,78.26},{25.77,79.27},{26.42,79.37},{26.84,79.92},{26.14,79.97},{27.13,80.46},{27.16,78.44},{27.7,78.82},{26.39,78.34},{26.83,78.96},{28.47,80.76},{28.68,79.19},{28.46,79.61},{26.98,81.08},{27.98,81.06},{28.08,80.25},{28.01,80.56},{27.63,80.87},{28.44,80.77},{28.68,82.98},{29.16,81.96},{28.73,83.02},{28.68,81.04},{28.96,80.9},{28.8,80.58},{28.76,80.09},{28.29,82.15},{29.57,80.37},{29.49,79.99},{29.32,79.05},{29.57,79.12},{29.79,79.86},{29.85,80.43},{29.26,80.71},{30.59,81.9},{30.53,81.29},{30.1,79.32},{30.59,80.02},{30.08,79.82},{30.46,80.71},{30.17,79.36}}},nil,1,nil,nil,107,nil,nil,0},
[707] = {'Rockjaw Trogg',42,55,1,2,0,{[1]={{32.35,74.47},{31.13,74.74},{31.05,73.95},{30.62,74.56},{24.31,71.0},{23.83,73.48},{21.82,72.42},{20.12,73.23},{19.42,74.44},{21.8,73.37},{22.75,76.27},{23.21,78.39},{24.12,77.29},{23.04,73.71},{29.26,75.5},{28.84,76.47},{30.07,74.49},{29.92,75.01},{28.96,77.11},{28.86,77.64},{29.64,76.26},{29.9,77.96},{30.35,77.57},{29.78,77.66},{30.72,77.02},{30.04,76.63},{30.47,74.91},{30.75,74.46},{30.68,75.71},{31.81,75.75},{31.56,76.17},{31.81,74.62},{32.11,75.11},{31.25,75.97},{31.11,74.78},{31.33,76.61},{31.98,76.38},{31.67,77.59},{32.84,75.21},{32.25,75.86},{33.34,75.43}}},nil,1,nil,nil,36,"AH",nil,0},
[708] = {'Small Crag Boar',71,71,3,3,0,{[1]={{32.28,71.68},{31.22,69.24},{28.21,73.04},{26.58,69.66},{27.43,71.62},{25.99,69.17},{26.18,71.19},{26.59,68.57},{25.41,70.23},{24.67,70.9},{24.62,69.16},{25.5,68.37},{24.39,68.11},{23.41,69.15},{24.03,72.5},{23.58,68.55},{22.7,70.19},{22.71,69.56},{22.2,69.45},{22.35,71.61},{22.82,72.48},{21.3,69.13},{20.38,74.24},{20.76,73.4},{20.71,69.12},{19.86,73.42},{20.09,71.08},{19.9,72.29},{20.14,71.37},{20.21,74.51},{19.47,75.15},{21.39,70.23},{20.7,70.28},{21.81,71.44},{21.43,71.27},{21.34,72.22},{22.02,72.32},{20.73,74.12},{20.66,73.3},{20.06,73.32},{21.25,69.14},{20.69,69.18},{21.92,70.12},{21.95,71.26},{22.11,72.2},{21.98,69.3},{22.6,69.33},{22.61,70.15},{22.74,72.42},{20.75,75.28},{21.46,78.02},{19.75,76.42},{23.46,78.77},{24.02,78.82},{23.98,76.46},{24.69,79.28},{28.01,73.07}}},nil,1,nil,nil,1094,"AH",nil,0},
[709] = {'Mosh\'Ogg Warmonger',4755,4953,41,42,1,{[33]={{50.24,31.0},{47.13,24.77},{49.21,26.95},{48.14,30.93},{48.76,31.47},{49.24,30.8},{49.71,29.95},{49.91,28.21},{48.85,30.08},{49.99,27.81},{46.4,25.34},{48.04,29.62},{47.91,29.73},{48.77,28.63},{50.07,27.56}}},nil,33,nil,nil,45,nil,nil,0},
[710] = {'Mosh\'Ogg Spellcrafter',3603,3741,43,44,1,{[33]={{51.76,27.38},{51.21,26.78},{51.89,26.57},{51.57,28.25},{51.37,27.89},{50.34,31.03},{51.96,27.67}}},nil,33,nil,nil,45,nil,nil,0},
[711] = {'Ardo Dirtpaw',582,582,24,24,0,{[44]={{17.06,17.43}}},nil,44,nil,nil,19,nil,nil,0},
[712] = {'Redridge Thrasher',300,328,14,15,0,{[44]={{28.86,81.22},{13.6,67.77},{15.13,61.33},{15.07,67.19},{15.46,66.29},{16.88,65.7},{16.5,63.54},{16.71,63.53},{27.26,80.56},{14.95,61.73},{15.04,61.82},{15.95,67.44}}},nil,44,nil,nil,19,nil,nil,0},
[713] = {'Balir Frosthammer',102,102,5,5,0,{[1]={{29.71,71.25}}},nil,1,{170},{170},55,"A",nil,2},
[714] = {'Talin Keeneye',102,102,5,5,0,{[1]={{22.6,71.43}}},nil,1,{183,234},{183,233},55,"A",nil,2},
[715] = {'Hemet Nesingwary',1752,1752,40,40,0,{[33]={{35.66,10.81}}},nil,33,{194,195,196,197,208},{194,195,196,197,208,583,5762,5763},35,"AH",nil,3},
[716] = {'Barnil Stonepot',1752,1752,40,40,0,{[33]={{35.66,10.53}}},nil,33,{338,339,340,341,342,583},{338,339,340,341,342},35,"AH",nil,3},
[717] = {'Ajeck Rouack',1752,1752,40,40,0,{[33]={{35.62,10.62}}},nil,33,{185,186,187,188},{185,186,187,188},35,"AH",nil,2},
[718] = {'Sir S. J. Erlgadin',1752,1752,40,40,0,{[33]={{35.55,10.55}}},nil,33,{190,191,192,193},{190,191,192,193},35,"AH",nil,2},
[721] = {'Rabbit',1,1,1,1,0,{[1]={{50.15,38.79},{47.54,39.81},{47.24,44.59},{46.98,47.62},{47.52,55.37},{48.03,57.91},{48.1,59.35},{45.17,60.33},{43.36,66.81},{40.86,65.59},{38.67,61.58},{36.87,60.94},{34.83,59.97},{31.06,74.35},{30.41,71.83},{30.35,72.21},{29.23,71.64},{29.17,72.87},{28.55,70.13},{28.25,70.71},{27.86,70.09},{27.84,72.86},{25.58,70.95},{23.64,72.6},{21.54,71.53},{22.49,72.18},{25.19,73.63},{25.01,76.51},{24.61,76.49},{26.24,74.03},{27.72,75.27},{28.34,75.81},{29.06,71.14},{30.1,73.57},{29.44,74.2},{30.69,72.03},{30.34,75.49},{38.8,61.96},{48.18,57.71},{48.92,45.7},{47.27,44.31},{47.58,39.41},{50.15,39.09},{52.05,42.01},{48.16,63.16},{43.85,37.94},{44.07,33.81},{44.36,31.51},{41.3,30.74},{39.39,32.83},{36.91,32.42},{34.46,30.64},{32.96,31.76},{30.64,35.54},{28.24,36.29},{27.58,45.11},{26.64,48.09},{27.15,51.65},{28.37,54.4},{27.88,52.61},{27.92,41.09},{30.16,45.22},{29.78,48.97},{32.21,52.85},{30.31,52.69},{31.11,54.68},{31.45,58.5},{32.07,56.19},{34.27,55.64},{37.54,52.13},{38.72,46.86},{40.94,47.21},{37.07,45.31},{37.45,43.86},{34.43,46.65},{32.29,49.07},{35.72,36.52},{40.2,42.43},{40.35,40.86},{38.63,38.08},{86.99,50.31},{41.97,46.88},{43.89,52.48},{66.1,13.2},{41.16,56.17},{44.5,57.01},{40.29,58.91},{38.91,61.03},{40.68,65.26},{49.4,54.22},{46.58,47.4},{49.04,46.0},{50.34,47.62},{50.92,49.21},{47.93,59.85},{50.63,59.07},{56.27,56.65},{56.88,51.57},{57.96,46.06},{61.68,53.56},{56.84,60.65},{60.68,58.5},{67.13,56.01},{65.78,53.72},{67.42,51.31},{69.83,52.35},{70.96,52.84},{69.82,50.75},{73.71,49.72},{75.47,49.82},{80.36,55.64},{81.56,54.97},{81.48,52.92},{80.12,51.75},{84.55,50.39},{85.12,47.33},{78.87,49.74},{80.24,47.15},{80.0,42.99},{81.22,43.66},{65.73,12.79},{67.48,16.11},{68.2,16.93},{70.01,19.31},{70.28,25.14},{71.15,29.37}},[12]={{54.93,52.4},{53.77,47.47},{51.46,38.94},{54.16,49.02},{52.96,51.6},{52.76,50.95},{51.62,49.53},{50.73,50.53},{52.48,50.38},{46.74,47.02},{53.97,46.43},{59.93,79.26},{62.97,78.37},{45.08,65.47},{40.73,60.86},{33.28,49.11},{32.2,52.12},{30.71,53.26},{34.0,51.83},{34.31,55.08},{36.35,55.06},{38.68,55.13},{41.16,55.36},{43.88,39.91},{51.4,38.74},{44.16,35.18},{44.55,38.7},{50.45,35.15},{52.68,32.56},{44.1,37.71},{50.14,33.16},{49.69,31.72},{47.48,33.63},{46.65,32.0},{49.94,35.11},{55.32,46.06},{55.39,47.05},{56.05,42.99},{50.39,38.46},{50.41,41.06},{48.43,42.74},{52.79,36.98},{51.32,48.33},{48.88,43.85},{37.65,58.71},{34.92,59.11},{36.46,59.64},{40.58,60.85},{45.01,64.79},{41.65,68.94},{42.38,70.16},{39.04,69.01},{26.66,74.67},{26.76,77.41},{24.13,75.57},{22.04,79.15},{26.44,82.63},{26.78,86.24},{26.52,91.23},{26.78,93.11},{31.73,81.35},{32.07,84.3},{32.53,87.23},{36.02,86.03},{39.9,90.31},{41.4,87.68},{42.32,86.02},{43.7,70.92},{47.98,84.45},{51.66,71.28},{54.24,73.21},{53.92,78.26},{54.52,79.46},{56.82,75.15},{55.56,75.09},{60.07,78.96},{67.7,77.2},{68.5,81.87},{69.7,78.47},{72.46,80.18},{57.35,48.57},{51.42,71.9},{82.81,69.64},{85.13,71.5},{84.21,67.8},{87.87,79.84},{56.25,49.12},{57.08,48.53},{55.53,43.15},{56.3,41.98},{55.4,41.23},{55.47,40.44},{57.21,40.86},{44.13,46.0}},[44]={{78.56,65.38},{72.49,46.96},{76.79,73.28},{59.41,67.07},{81.23,36.06},{65.17,76.44},{86.03,55.37},{46.2,78.82},{84.17,46.11},{82.69,45.25},{81.49,52.81},{55.57,78.11},{40.65,35.96},{73.46,48.2},{48.1,78.27},{32.97,80.09},{25.5,45.97},{19.54,61.36},{12.77,83.07},{33.7,42.45},{11.54,73.97},{38.61,75.24},{24.83,67.48},{14.87,50.25},{73.39,73.42},{76.83,79.79},{76.73,82.07},{26.84,79.5},{50.81,74.94},{61.98,72.54},{62.42,73.71},{22.42,45.44},{72.59,45.64},{70.32,45.57},{42.8,78.85},{43.46,77.38},{66.08,41.38},{71.91,40.73},{48.35,75.53},{14.87,67.66},{25.59,63.84},{53.61,36.93},{31.39,71.69},{61.96,73.25},{68.15,45.19},{23.77,75.15},{31.74,46.14},{34.13,62.45},{34.29,60.12},{30.5,60.41},{19.22,56.94},{27.37,65.82},{10.81,80.22},{24.27,41.97},{48.48,33.11},{32.67,43.3},{36.94,74.95},{26.3,71.7},{18.4,47.39}},[267]={{52.48,60.27},{42.13,59.46},{44.6,48.34},{47.26,54.18},{53.86,56.81},{52.86,54.46},{36.15,57.71},{37.27,45.49},{42.02,63.41}},[130]={{47.4,31.99},{54.61,55.01},{51.63,76.83}},[85]={{61.58,38.68},{61.05,32.51},{30.83,64.28},{30.8,49.82},{68.86,34.55},{51.25,53.93},{56.88,36.69},{58.98,36.16},{64.5,33.86},{45.98,58.06},{36.93,63.8},{62.13,58.24},{56.71,58.33},{46.17,57.98},{69.85,54.83}},[406]={{83.05,84.61},{83.38,87.71},{76.79,54.02},{60.42,48.75},{83.06,84.37},{74.99,85.42},{74.14,44.92},{79.07,85.67},{63.19,59.44},{57.54,66.5},{46.84,43.29},{49.55,46.25},{48.34,36.0},{67.43,37.54},{63.11,83.88},{52.35,53.0}},[2557]={{-1,-1}},[148]={{40.33,53.45},{43.89,86.52},{40.45,88.66},{43.36,72.96},{38.3,63.68},{42.3,77.96},{42.42,39.02},{40.81,78.62},{39.97,91.0},{41.08,46.63},{45.74,35.14},{38.2,45.71},{40.84,60.61},{58.12,26.23},{41.81,44.19},{46.5,27.17}},[493]={{36.58,57.39},{57.07,72.45},{49.8,65.86},{67.54,55.39},{33.83,59.95},{62.11,47.85},{63.97,50.03},{37.85,51.62},{61.21,67.79},{44.73,70.4},{37.29,30.56},{32.72,46.57},{59.4,65.8},{64.11,60.89},{35.83,40.52},{37.98,40.42},{41.49,44.54},{45.18,43.21},{55.39,32.34},{40.79,68.43},{65.38,70.23},{50.93,31.23},{53.87,31.17},{35.84,30.05},{41.2,53.04},{66.13,62.78},{49.07,70.85},{39.03,62.05},{63.53,64.36},{65.29,44.18},{69.05,53.97},{58.7,71.61},{50.87,39.29},{48.53,31.17}},[141]={{63.89,52.38},{62.85,66.54},{63.23,54.62},{60.9,35.94},{55.19,76.23},{49.66,77.74},{65.15,51.01},{55.24,45.74},{53.88,77.39},{44.21,47.64},{48.51,62.46},{47.39,63.88},{62.34,44.11},{43.28,47.93},{40.02,61.22},{61.77,69.9},{38.51,43.23},{42.9,45.44},{68.11,52.95},{50.83,75.61},{38.21,35.22},{48.28,64.96},{44.91,75.6},{41.74,70.23},{55.28,43.8},{46.55,78.08},{52.4,78.16},{66.91,63.45},{40.99,53.89},{48.11,63.93},{41.51,29.75},{63.55,37.39},{64.38,70.64},{54.68,41.85},{61.41,33.74},{64.69,41.58},{40.87,68.35},{65.71,67.1},{58.29,63.89},{59.56,32.54},{68.12,60.85},{59.61,38.82},{49.16,59.62},{60.97,43.82},{50.99,61.55},{56.41,38.81},{55.31,63.88},{59.39,46.17},{55.66,62.15},{55.24,60.9},{67.1,50.72},{37.88,56.98},{58.84,41.88},{57.43,32.99},{50.95,61.59},{51.97,60.37},{61.3,39.9},{58.25,46.06},{55.66,62.21},{58.77,43.71},{58.29,63.94},{57.62,61.4},{55.2,60.86},{66.38,53.36},{51.98,60.44},{50.96,61.6},{58.43,59.89},{60.46,55.64},{61.29,39.92}},[357]={{50.34,27.53},{46.15,25.19},{67.48,45.38},{61.95,69.54},{75.73,61.63},{61.53,55.67}},[796]={{-1,-1}},[11]={{26.71,66.18},{23.87,66.99},{21.31,68.14},{16.89,70.69},{14.73,73.22}}},nil,1,nil,nil,31,"AH",nil,0},
[723] = {'Mosh\'Ogg Butcher',5346,5346,44,44,2,{[33]={{49.83,30.87}}},{[33]={{{49.54,30.82},{50.23,30.8},{49.83,30.87}}}},33,nil,nil,45,nil,nil,0},
[724] = {'Burly Rockjaw Trogg',55,55,2,2,0,{[1]={{31.63,73.69},{27.22,72.14},{27.21,73.02},{26.87,73.14},{27.42,73.41},{26.3,73.16},{26.92,72.95},{26.16,72.22},{26.56,72.57},{26.19,71.9},{26.19,72.14},{26.1,72.68},{26.59,71.91},{27.02,72.63},{25.65,72.46},{25.37,73.1},{24.8,72.38},{23.91,72.56},{22.7,73.16},{22.98,73.56},{20.78,72.12},{21.19,71.78},{21.44,74.68},{20.81,74.3},{20.61,70.45},{20.24,71.51},{19.99,75.41},{19.42,72.24},{21.45,73.32},{21.84,72.66},{21.36,75.37},{21.32,77.31},{21.9,76.25},{20.01,77.52},{21.96,78.23},{22.86,77.55},{23.96,79.6},{23.33,76.68},{22.92,75.39},{23.91,75.21},{24.19,74.24},{23.89,73.04},{23.14,74.16},{22.9,74.45},{25.99,74.23},{26.64,73.4},{24.83,74.18},{27.69,76.51},{30.32,74.52},{29.25,75.0},{29.22,77.74},{28.57,78.02},{30.11,75.63},{29.96,77.42},{30.29,76.27},{30.69,75.13},{31.67,75.98},{31.25,75.35},{30.89,76.23},{31.72,76.76},{32.38,75.86}}},nil,1,nil,nil,36,"AH",nil,0},
[727] = {'Ironforge Mountaineer',1910,1910,30,30,0,{[1]={{46.94,41.9},{46.98,42.25},{47.01,42.36},{47.65,45.58},{46.93,47.89},{46.39,55.01},{46.54,52.8},{46.16,51.42},{45.98,50.98},{46.01,52.12},{46.54,52.22},{48.07,55.29},{47.53,57.54},{36.03,61.85},{43.35,65.16},{37.97,61.9},{35.12,32.92},{35.12,32.86},{75.84,49.2},{75.81,49.25},{75.83,49.13},{49.58,46.61},{50.14,49.16},{57.95,52.56},{69.86,40.93},{69.72,40.73},{71.74,31.34},{71.44,23.99},{71.66,24.38},{71.46,24.12},{70.12,25.76},{71.65,23.28},{70.11,20.77},{70.99,22.22},{68.77,18.87},{69.6,40.63},{70.07,41.66},{70.02,41.85},{72.01,32.27},{70.81,29.86},{71.79,31.28},{69.68,30.27},{70.0,26.64},{71.11,22.33},{70.14,20.71},{68.74,18.69},{68.88,18.55},{54.8,20.57}},[11]={{27.06,66.66},{27.17,66.21}}},nil,1,nil,nil,57,"A",nil,1},
[728] = {'Bhag\'thera',4800,4800,40,40,1,{[33]={{49.61,24.03}}},nil,33,nil,nil,16,nil,nil,0},
[729] = {'Sin\'Dall',1536,1536,37,37,0,{[33]={{32.21,17.39}}},nil,33,nil,nil,16,nil,nil,0},
[730] = {'Tethis',5320,5320,43,43,1,{[33]={{28.74,44.85},{28.35,42.54},{31.78,43.45}}},nil,33,nil,nil,48,nil,nil,0},
[731] = {'King Bangalash',5577,5577,43,43,1,{[33]={{38.21,35.58}}},nil,33,nil,nil,16,nil,nil,0},
[732] = {'Murloc Lurker',176,198,9,10,0,{[12]={{76.53,79.69},{75.85,83.67},{76.91,82.66},{76.46,81.97},{77.55,80.95},{78.48,83.99},{77.11,85.84},{77.03,84.21},{77.22,85.01},{77.75,85.92},{76.3,84.39},{78.55,82.08},{79.49,85.3},{79.96,85.48},{76.91,86.43},{81.08,86.88},{82.92,87.24},{84.79,86.63},{78.52,60.2},{79.16,56.36},{79.39,55.28},{79.76,56.82},{77.81,58.04},{78.24,57.86},{78.07,57.66},{79.66,54.98},{80.42,53.31},{77.69,56.28},{78.47,55.8},{77.7,56.87},{76.56,58.95},{79.35,46.25},{78.68,45.9},{78.71,44.51},{78.08,45.34},{78.73,45.07},{77.65,44.1},{78.27,57.48},{75.95,86.04},{88.54,84.16},{89.92,82.42},{91.64,82.32}}},nil,12,nil,nil,18,nil,nil,0},
[733] = {'Sergeant Yohwa',1752,1752,40,40,0,{[33]={{38.02,3.33}}},nil,33,{203,204,574},{203,204},12,"A",nil,2},
[734] = {'Corporal Bluth',1752,1752,40,40,0,{[33]={{37.96,2.99}}},nil,33,nil,nil,12,"A","Camp Trader",4},
[735] = {'Murloc Streamrunner',120,137,6,7,0,{[12]={{57.19,69.45},{51.98,66.25},{51.45,69.45},{53.14,70.04},{58.27,67.92},{58.32,65.25},{51.98,66.25},{55.22,69.39},{57.26,63.69},{57.14,62.29},{55.5,63.25},{52.96,67.93},{53.26,63.53},{50.52,66.31},{54.18,62.73},{52.96,67.93},{51.97,64.45},{51.55,65.11},{51.98,68.67},{50.45,62.32}}},nil,12,nil,nil,18,nil,nil,0},
[736] = {'Panther',1163,1221,32,33,0,{[33]={{45.69,10.32},{45.79,10.3},{28.88,15.94},{28.36,13.43},{29.77,16.11},{28.17,16.55},{30.97,14.59},{29.99,9.78},{30.9,11.29},{28.37,10.55},{28.79,14.6},{30.47,10.67},{29.4,9.07},{28.39,12.3},{29.45,13.59}}},nil,33,nil,nil,16,nil,nil,0},
[737] = {'Kebok',1342,1342,35,35,0,{[33]={{27.0,77.13}}},nil,33,{189,209,213},{189,209,213},120,"AH",nil,2},
[738] = {'Private Thorsen',1002,1002,30,30,0,{[33]={{37.98,3.41}}},{[33]={{{37.98,3.41},{37.98,3.41},{38.03,3.6},{38.2,3.71},{38.3,3.81},{38.29,3.99},{38.14,4.29},{38.13,4.54},{38.21,4.83},{38.36,4.94},{38.56,4.95},{38.75,5.02},{38.99,5.08},{39.09,5.19},{39.31,5.94},{39.3,6.4},{39.3,6.75},{39.32,7.14},{39.5,7.58},{39.78,8.04},{39.88,8.29},{40.07,8.45},{40.34,8.44},{40.34,8.44},{40.34,8.44},{39.95,8.29},{39.6,7.73},{39.33,7.17},{39.31,6.54},{39.31,5.8},{39.28,5.3},{38.84,5.08},{38.66,5.03},{38.53,5.02},{38.42,5.01},{38.33,4.97},{38.26,4.89},{38.16,4.78},{38.11,4.61},{38.1,4.46},{38.11,4.32},{38.11,4.14},{38.1,3.99},{38.06,3.85},{38.02,3.68},{37.96,3.47},{37.98,3.41}}}},33,{215},{198},123,"A",nil,1},
[739] = {'Brother Nimetz',1752,1752,40,40,0,{[33]={{37.83,3.56}}},nil,33,{205,206,207},{205,206,207},12,"A",nil,2},
[740] = {'Adolescent Whelp',953,992,34,35,0,{[8]={{16.24,64.54},{15.29,66.57},{14.31,61.27},{17.25,59.81},{13.91,59.36},{11.12,62.67},{12.86,66.81}}},nil,8,nil,nil,50,nil,nil,0},
[741] = {'Dreaming Whelp',1037,1075,35,36,0,{[8]={{14.52,64.18},{12.6,58.98},{12.71,64.75},{12.57,59.3},{11.41,57.32},{16.7,56.23}}},nil,8,nil,nil,50,nil,nil,0},
[742] = {'Green Wyrmkin',1902,1981,41,42,0,{[8]={{72.44,69.51},{60.01,52.35},{66.33,64.22},{89.15,65.75}}},nil,8,nil,nil,50,nil,nil,0},
[743] = {'Wyrmkin Dreamwalker',1585,1647,42,43,0,{[8]={{60.25,57.21},{64.1,63.59},{62.04,59.96},{71.32,66.72},{60.52,53.15},{90.41,56.93},{89.67,61.51}}},nil,8,nil,nil,50,nil,nil,0},
[744] = {'Green Scalebane',1981,2059,42,43,0,{[8]={{76.59,68.8},{77.55,70.66},{60.59,39.33},{64.51,42.03},{63.69,39.22},{61.82,37.46},{62.2,41.72},{60.71,43.26},{79.73,58.76}}},nil,8,nil,nil,50,nil,nil,0},
[745] = {'Scalebane Captain',2059,2138,43,44,0,{[8]={{77.97,68.2},{77.07,65.29},{76.57,46.86},{75.57,67.0},{62.08,44.55},{59.47,40.86},{75.33,41.11},{73.53,38.84},{80.95,42.36},{82.12,40.97},{87.76,45.33},{81.27,51.83},{83.94,51.89}}},nil,8,nil,nil,50,nil,nil,0},
[746] = {'Elder Dragonkin',2217,2217,45,45,0,{[8]={{86.05,45.85},{83.01,46.0},{80.15,45.46},{87.0,44.05},{86.95,47.83},{85.4,49.79},{78.45,54.96}}},nil,8,nil,nil,50,nil,nil,0},
[747] = {'Marsh Murloc',1902,1981,41,42,0,{[8]={{82.64,94.14},{86.47,84.51},{86.88,85.02},{83.69,88.54},{86.5,87.25},{85.93,84.97},{83.56,93.7},{87.1,80.66},{84.28,85.38}}},nil,8,nil,nil,18,nil,nil,0},
[749] = {'Marsh Murkdweller',1902,1981,41,42,0,nil,nil,0,nil,nil,18,nil,nil,0},
[750] = {'Marsh Inkspewer',1981,2059,42,43,0,{[8]={{62.32,81.0},{95.93,58.23},{68.88,96.89},{92.71,69.28},{92.73,68.68},{88.53,81.96},{90.12,75.52},{95.53,61.15},{95.59,62.98},{90.2,80.12},{86.73,83.41},{85.6,87.2},{87.12,82.72},{85.15,88.73},{90.99,71.2},{95.36,54.73},{95.95,52.63},{95.64,49.99},{93.16,66.79},{94.14,63.31},{91.5,67.39},{91.46,69.74},{67.09,75.84},{66.25,86.21},{63.95,88.18},{64.7,87.09},{64.3,80.62},{66.01,80.95},{64.09,80.32},{64.48,81.6},{84.41,87.23},{82.95,90.54},{81.15,91.2},{82.78,93.53},{81.2,94.14},{82.78,93.81},{83.53,90.92},{85.33,82.92},{83.94,90.0},{88.47,76.39},{89.43,77.75},{82.79,89.65},{94.74,58.51},{94.35,60.0},{92.44,65.72},{94.28,49.95},{94.34,54.14},{88.19,80.18}}},nil,8,nil,nil,18,nil,nil,0},
[751] = {'Marsh Flesheater',2059,2138,43,44,0,{[8]={{62.09,81.2},{72.55,97.58},{70.98,97.59},{60.6,84.65},{95.05,51.28},{66.44,83.11},{64.73,88.96},{63.15,91.26},{63.32,88.49},{62.87,89.71},{62.0,82.56},{63.22,84.91},{62.32,81.12},{66.06,77.62},{94.41,52.52},{88.11,78.24}}},nil,8,nil,nil,18,nil,nil,0},
[752] = {'Marsh Oracle',1711,1773,44,45,0,{[8]={{63.15,80.42},{61.41,84.34},{60.9,83.58},{94.18,30.52},{95.05,51.06},{94.89,60.05},{94.86,61.0},{62.37,88.13},{61.99,87.28},{60.48,86.56},{62.76,87.05},{63.59,86.78},{89.05,78.45}}},nil,8,nil,nil,18,nil,nil,0},
[754] = {'Rebel Watchman',1106,1162,31,32,0,{[33]={{38.15,3.65}}},{[33]={{{38.15,3.65},{38.13,3.72},{38.09,3.9},{38.11,4.09},{38.11,4.19},{38.1,4.37},{38.14,4.66},{38.16,4.74},{38.24,4.88},{38.35,4.96},{38.52,5.0},{38.7,5.03},{38.58,5.01},{38.41,4.96},{38.35,4.94},{38.24,4.86},{38.19,4.8},{38.14,4.63},{38.12,4.35},{38.12,4.16},{38.11,3.97},{38.1,3.87}}}},33,nil,nil,11,"A",nil,0},
[755] = {'Lost One Mudlurker',1279,1342,34,35,0,{[8]={{50.16,34.18},{43.46,34.52},{46.05,27.6},{49.0,31.9},{51.78,33.53},{45.92,31.14},{51.72,28.83},{49.59,27.36}}},nil,8,nil,nil,51,nil,nil,0},
[756] = {'Skullsplitter Panther',1902,1981,41,42,0,nil,nil,0,nil,nil,30,nil,nil,0},
[757] = {'Lost One Fisherman',1403,1469,35,36,0,{[8]={{44.03,31.34},{50.59,32.33},{59.95,28.19},{56.58,30.73},{48.66,30.44},{43.36,38.54},{53.73,30.65},{54.81,29.97},{56.75,27.33}}},nil,8,nil,nil,51,nil,nil,0},
[758] = {'Skullsplitter Tiger',1024,1024,28,28,0,nil,nil,0,nil,nil,30,nil,nil,0},
[759] = {'Lost One Hunter',1469,1536,36,37,0,{[8]={{64.75,23.02},{55.15,25.15},{55.13,30.32},{57.63,23.97},{55.78,29.12},{57.79,24.74},{56.81,25.23},{57.27,24.65},{62.0,23.53},{61.93,22.74},{62.62,24.07},{58.08,26.76}}},nil,8,nil,nil,51,nil,nil,0},
[760] = {'Lost One Muckdweller',1469,1536,36,37,0,{[8]={{58.41,28.46},{60.87,28.44},{56.06,31.86},{57.7,29.92},{63.45,21.88},{64.66,26.17},{62.34,26.7},{63.45,17.41},{62.25,19.42},{59.02,23.56},{61.17,25.27},{55.75,34.07},{55.89,34.37}}},nil,8,nil,nil,51,nil,nil,0},
[761] = {'Lost One Seer',1257,1305,37,38,0,{[8]={{60.41,22.43},{65.06,20.41}}},nil,8,nil,nil,51,nil,nil,0},
[762] = {'Lost One Riftseeker',1115,1154,37,38,0,{[8]={{64.18,22.65},{64.08,23.16},{61.91,20.9},{60.94,23.86}}},nil,8,nil,nil,51,nil,nil,0},
[763] = {'Lost One Chieftain',1678,1678,39,39,4,{[8]={{61.96,21.16},{60.54,22.93},{60.06,20.31},{61.59,22.78},{63.81,20.85}}},nil,8,nil,nil,51,nil,nil,0},
[764] = {'Swampwalker',1305,1357,38,39,0,{[8]={{46.88,37.1},{49.28,35.27},{51.17,36.76},{54.74,32.1},{14.92,38.73},{15.81,36.55},{16.87,38.78},{14.37,34.71},{11.43,38.66},{13.0,37.04},{15.77,40.78}}},nil,8,nil,nil,14,nil,nil,0},
[765] = {'Swampwalker Elder',1357,1409,39,40,0,{[8]={{12.92,32.51},{10.07,32.31}}},nil,8,nil,nil,14,nil,nil,0},
[766] = {'Tangled Horror',1471,1521,40,41,0,{[8]={{74.06,71.51},{78.82,71.91},{71.28,23.54},{68.05,32.09},{58.99,45.42},{73.62,31.62},{76.77,30.88},{62.75,33.74},{58.28,55.48},{60.47,36.19},{73.85,27.14},{57.96,35.95},{67.5,24.54},{57.33,50.29},{57.26,41.49},{85.06,67.28},{83.83,72.9},{11.21,30.74},{8.56,30.45},{8.43,34.34},{11.49,34.74},{10.11,36.59},{76.78,73.14},{77.54,77.62},{77.2,81.09},{72.41,73.65}}},nil,8,nil,nil,14,nil,nil,0},
[767] = {'Swamp Jaguar',1469,1536,36,37,0,{[8]={{37.48,37.62},{14.59,46.08},{33.39,35.54},{28.66,43.62},{36.89,39.88},{36.3,39.58},{26.43,47.42},{25.28,41.28},{43.54,41.24},{40.44,37.32},{39.92,31.23},{37.42,30.95},{41.03,38.82},{35.88,53.94},{23.52,38.67},{20.23,42.84},{33.16,43.18},{23.06,42.36},{34.69,30.28},{39.19,39.25},{39.86,41.0},{31.66,29.4},{26.98,39.57},{26.44,34.3},{22.42,57.9},{23.48,60.08},{33.58,54.37},{27.16,63.96},{53.79,41.56},{55.54,45.24},{56.86,43.81},{47.71,40.75},{26.33,60.73},{16.74,60.14},{12.04,59.42},{30.02,52.49},{32.03,49.96},{36.51,48.45},{37.24,45.15},{39.14,47.32},{41.9,43.38},{40.35,45.26},{43.31,45.13},{44.73,43.4},{53.2,38.43},{29.06,34.26}}},nil,8,nil,nil,14,nil,nil,0},
[768] = {'Shadow Panther',1678,1753,39,40,0,{[8]={{83.81,59.0},{69.33,11.65},{69.89,26.33},{71.02,10.48},{74.12,25.29},{65.4,67.87},{87.28,28.61},{88.65,36.33},{92.96,44.63},{87.79,31.41},{70.64,11.03},{90.65,48.95}}},nil,8,nil,nil,14,nil,nil,0},
[769] = {'Deathstrike Tarantula',1829,1902,40,41,0,{[8]={{60.62,68.9},{61.87,65.31},{60.65,62.1},{56.91,64.42},{59.4,60.17},{59.61,65.9},{58.03,62.47},{56.43,61.82},{63.73,66.4},{65.34,69.9},{55.37,62.33},{56.36,60.99},{76.9,86.67},{56.88,62.14},{76.19,88.86},{76.5,77.43},{81.09,89.13},{55.86,62.12},{65.98,69.56},{67.43,78.85},{60.94,68.66},{77.44,86.04},{80.24,83.89},{70.22,79.93},{59.27,63.56},{56.52,65.65},{69.37,67.32},{67.77,68.41},{71.32,68.79},{65.54,65.13},{62.87,67.6},{60.54,60.28},{62.09,65.48},{60.45,61.88},{75.05,82.85},{72.75,82.81},{72.81,79.92},{73.18,80.17}}},nil,8,nil,nil,22,nil,nil,0},
[770] = {'Corporal Kaleb',1752,1752,40,40,0,{[33]={{37.74,3.3}}},nil,33,{210},{622},12,"A",nil,2},
[771] = {'Commander Felstrom',1163,1163,32,32,4,{[10]={{18.01,37.9},{13.18,36.19},{14.79,36.54},{16.3,37.36},{18.55,35.73},{16.51,35.68},{16.77,34.32},{14.85,33.31},{14.38,32.7},{14.04,34.61}}},nil,10,nil,nil,21,nil,nil,2},
[772] = {'Stranglethorn Tigress',1536,1604,37,38,0,{[33]={{41.3,34.76},{36.19,35.67},{37.28,45.25},{39.29,45.54},{40.34,40.99},{39.55,44.17},{46.09,26.19},{46.44,26.92},{39.49,41.75},{49.26,23.21},{50.21,23.04},{49.26,20.39},{50.28,21.79},{46.45,22.54},{47.23,23.07},{48.16,21.6},{48.07,23.01},{49.68,24.06},{48.03,27.81},{49.71,25.47},{48.88,23.86},{47.67,22.32},{46.52,28.44},{49.27,24.51},{50.25,24.68},{46.97,29.57},{47.02,27.74},{36.55,39.1},{48.66,20.75},{35.62,36.22},{49.23,21.6},{45.47,25.29},{41.23,36.34},{48.69,22.22},{35.49,38.01},{38.67,38.61},{39.86,37.6},{40.29,39.62},{40.73,40.21},{41.95,38.89},{42.25,38.15},{41.38,38.22},{37.15,38.86},{38.07,39.32},{50.66,20.61},{49.74,20.77},{48.09,20.2},{36.5,36.11},{37.22,35.55},{36.03,33.95},{39.37,33.31},{38.7,32.86},{39.59,35.55},{41.33,39.76},{41.19,40.88},{35.15,36.96},{40.52,37.73},{39.14,39.9},{39.22,34.84},{39.7,40.72},{36.16,37.17},{39.22,37.91},{36.59,37.8},{38.73,37.12},{38.18,36.91},{37.61,36.4},{37.63,33.03},{47.58,27.41},{45.46,26.77},{45.94,27.72},{46.53,26.89},{38.61,35.69},{38.33,34.67},{39.57,42.56},{36.59,34.82},{40.33,31.7},{39.2,41.03}}},nil,33,nil,nil,16,nil,nil,0},
[773] = {'Krazek',1342,1342,35,35,0,{[33]={{26.94,77.21}}},nil,33,{198,201,616,622,627,1116,1117,2864},{201,210,627,1115,1116},120,"AH",nil,2},
[775] = {'Kurzen\'s Agent',1163,1221,32,33,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[777] = {'Amy Davenport',484,484,20,20,0,{[44]={{29.13,47.32}}},{[44]={{{29.13,47.34},{28.96,47.43},{29.17,47.46}}}},44,nil,nil,12,"A","Tradeswoman",4},
[780] = {'Skullsplitter Mystic',1357,1410,39,40,0,{[33]={{47.19,38.55},{47.23,38.59},{47.17,38.63},{45.92,38.0},{46.45,38.82},{46.48,39.09},{46.58,38.86},{48.37,41.73},{48.52,40.87},{47.55,39.33},{47.33,39.9},{47.46,39.77},{47.05,41.81},{45.98,40.36},{45.0,38.06},{47.1,39.46},{46.94,39.71},{46.57,40.44},{46.53,31.42},{46.48,31.42},{46.52,31.51},{48.76,37.45},{48.73,37.52},{44.08,40.07},{44.29,39.68},{44.17,39.45},{45.04,40.22},{43.75,39.42},{43.41,39.5},{43.79,40.17},{47.58,38.83},{48.71,40.1},{48.16,39.57},{47.64,41.02},{46.51,30.01},{47.05,32.49},{47.54,33.3},{47.1,34.09},{45.99,32.34},{46.05,32.0},{46.24,32.45},{46.22,32.0},{46.41,32.0},{45.19,32.34},{45.06,34.07},{45.55,31.7},{42.78,35.14},{42.73,35.19},{42.81,35.21},{48.8,37.51},{42.41,35.05},{41.93,36.28},{42.18,35.79},{42.3,36.11},{41.91,35.96},{42.12,36.29},{44.0,37.16},{43.34,36.39},{44.08,34.0},{43.96,35.43},{42.45,33.27},{43.51,33.01},{43.45,34.74},{42.44,35.29},{47.18,30.71},{43.49,37.91},{47.77,40.11}}},nil,33,nil,nil,30,nil,nil,0},
[781] = {'Skullsplitter Headhunter',2059,2138,43,44,0,{[33]={{43.59,45.56},{47.92,43.06},{47.88,43.69},{46.1,44.67},{47.58,42.9},{47.68,42.53}}},nil,33,nil,nil,30,nil,nil,0},
[782] = {'Skullsplitter Scout',1902,1981,41,42,0,{[33]={{46.25,42.61},{46.06,42.09},{44.57,43.69},{45.8,43.02},{46.01,42.63},{44.98,41.58},{44.47,41.95},{44.65,41.96},{48.28,41.08}}},nil,33,nil,nil,30,nil,nil,0},
[783] = {'Skullsplitter Berserker',2059,2138,43,44,0,{[33]={{43.22,44.34},{47.66,44.31},{48.02,44.33},{46.92,45.07},{47.85,42.96},{46.55,44.74},{44.25,44.84},{47.21,44.03},{47.48,44.32},{47.78,43.69}}},nil,33,nil,nil,30,nil,nil,0},
[784] = {'Skullsplitter Beastmaster',1902,1981,41,42,0,{[33]={{44.35,42.67},{44.49,40.9},{44.55,41.61},{47.42,41.35}}},nil,33,nil,nil,30,nil,nil,0},
[785] = {'Skeletal Warder',768,811,28,29,0,{[10]={{18.27,35.66},{17.41,35.5},{13.84,34.46},{13.46,33.39},{14.05,32.57},{15.92,38.75},{17.17,28.09},{17.3,37.39},{16.83,28.59},{16.12,31.37},{16.28,32.7},{16.8,30.12},{15.96,34.65},{13.73,36.16},{17.81,35.47},{16.05,37.28},{16.84,37.56}}},nil,10,nil,nil,21,nil,nil,0},
[786] = {'Grelin Whitebeard',102,102,5,5,0,{[1]={{25.08,75.71}}},nil,1,{182,218,282},{182,218,234},55,"A",nil,3},
[787] = {'Skeletal Healer',684,724,26,27,0,{[10]={{17.33,37.43},{16.9,35.0},{19.84,26.71},{16.84,28.99},{14.9,34.17},{16.28,32.15},{13.96,36.42},{13.51,36.3},{16.66,37.75},{17.01,39.19},{14.95,40.47},{15.87,41.04},{16.86,40.42}}},nil,10,nil,nil,21,nil,nil,0},
[789] = {'Kimberly Hiett',484,484,20,20,0,{[44]={{27.08,45.55}}},nil,44,nil,nil,12,"A","Fletcher",16388},
[790] = {'Karen Taylor',573,573,22,22,0,{[44]={{29.9,47.36}}},nil,44,nil,nil,12,"A","Mining and Smithing Supplies",4},
[791] = {'Lindsay Ashlock',484,484,20,20,0,{[44]={{28.77,47.33}}},nil,44,nil,nil,12,"A","General Supplies",4},
[793] = {'Kara Adams',712,712,25,25,0,{[44]={{30.57,46.46}}},nil,44,nil,nil,12,"A","Shield Crafter",16388},
[794] = {'Matt',42,42,1,1,0,{[12]={{47.62,62.55}}},{[12]={{{47.62,62.55},{47.6,62.49},{47.55,62.44},{47.55,62.35},{47.41,62.23},{47.07,62.33},{46.85,62.62},{46.79,62.9},{46.75,63.49},{46.7,63.82},{46.62,64.0},{46.43,64.12},{46.07,64.15},{45.41,64.04},{44.54,64.05},{44.01,64.31},{43.74,64.49},{43.35,64.55},{42.7,64.5},{42.39,64.61},{42.05,64.5},{41.54,64.09},{41.29,64.0},{40.98,63.65},{40.49,63.55},{40.1,63.65},{40.0,64.08},{39.9,64.47},{40.12,63.95},{40.35,63.57},{40.82,63.46},{41.21,63.89},{41.65,64.16},{41.87,64.64},{42.37,64.61},{42.58,64.49},{43.43,64.55},{43.73,64.5},{44.91,63.98},{45.82,64.13},{46.32,64.32},{46.69,64.0},{46.76,63.6},{46.75,62.98},{46.81,62.7},{47.08,62.32},{47.38,62.23},{47.56,62.34},{47.56,62.43},{47.64,62.5},{47.62,62.55}}}},12,nil,nil,12,"A",nil,0},
[795] = {'Mark',42,42,1,1,0,{[12]={{40.52,64.16}}},nil,12,nil,nil,12,"A",nil,0},
[796] = {'Joshua',42,42,1,1,0,{[12]={{40.52,64.06}}},nil,12,nil,nil,12,"A",nil,0},
[797] = {'Bo',42,42,1,1,0,{[12]={{40.5,64.23}}},{[12]={{{40.32,65.02},{40.79,65.9},{40.96,65.92},{41.41,65.84},{41.56,65.66},{41.47,65.65},{41.45,65.77},{41.52,65.62},{41.51,65.77},{41.41,65.79},{41.43,65.67},{41.53,65.68},{41.42,65.68},{41.48,65.79},{41.4,65.91},{41.36,65.73},{41.4,65.64},{41.51,65.74},{41.54,65.63},{41.42,65.73},{41.32,65.86},{40.73,65.91},{40.4,65.09},{40.52,64.07},{40.46,63.74},{40.54,63.8},{40.55,63.97},{40.35,64.04},{40.31,63.84},{40.45,63.91},{40.64,63.98}},{{40.32,65.02},{40.79,65.9},{40.96,65.92},{41.41,65.84},{41.56,65.66},{41.47,65.65},{41.45,65.77},{41.52,65.62},{41.51,65.77},{41.41,65.79},{41.43,65.67},{41.53,65.68},{41.42,65.68},{41.48,65.79},{41.4,65.91},{41.36,65.73},{41.4,65.64},{41.51,65.74},{41.54,65.63},{41.42,65.73},{41.32,65.86},{40.73,65.91},{40.4,65.09},{40.52,64.07},{40.46,63.74},{40.54,63.8},{40.55,63.97},{40.35,64.04},{40.31,63.84},{40.45,63.91},{40.64,63.98}}}},12,nil,nil,12,"A",nil,0},
[798] = {'Solomon',42,42,1,1,0,{[12]={{80.94,67.29}}},nil,12,nil,nil,12,"A",nil,0},
[799] = {'Kevin',42,42,1,1,0,{[12]={{80.37,66.86}}},nil,12,nil,nil,12,"A",nil,0},
[800] = {'Kyle',42,42,1,1,0,{[12]={{81.29,67.59}}},nil,12,nil,nil,12,"A",nil,0},
[801] = {'Eric',42,42,1,1,0,{[12]={{80.9,67.93}}},nil,12,nil,nil,12,"A",nil,0},
[802] = {'Jay',42,42,1,1,0,{[12]={{81.0,67.72}}},nil,12,nil,nil,12,"A",nil,0},
[804] = {'Dana',42,42,1,1,0,{[12]={{46.08,61.87}}},nil,12,nil,nil,12,"A",nil,0},
[805] = {'Cameron',42,42,1,1,0,{[12]={{46.15,61.93}}},nil,12,nil,nil,12,"A",nil,0},
[806] = {'John',42,42,1,1,0,{[12]={{46.09,62.02}}},nil,12,nil,nil,12,"A",nil,0},
[807] = {'Lisa',42,42,1,1,0,{[12]={{46.19,62.05}}},nil,12,nil,nil,12,"A",nil,0},
[808] = {'Grik\'nir the Cold',98,98,5,5,0,{[1]={{30.48,80.15}}},nil,1,nil,nil,37,nil,nil,0},
[810] = {'Aaron',42,42,1,1,0,{[12]={{46.24,61.92}}},nil,12,nil,nil,12,"A",nil,0},
[811] = {'Jose',42,42,1,1,0,{[12]={{46.17,61.8}}},nil,12,nil,nil,12,"A",nil,0},
[812] = {'Alma Jainrose',484,484,20,20,0,{[44]={{21.69,45.77}}},{[44]={{{21.69,45.77},{21.32,45.53}}}},44,nil,nil,12,"A","Herbalism Trainer",16},
[813] = {'Colonel Kurzen',4377,4572,39,40,1,{[33]={{49.94,3.95}}},nil,33,nil,nil,46,nil,nil,0},
[814] = {'Sergeant Malthus',1305,1305,38,38,0,{[33]={{47.27,5.66}}},nil,33,nil,nil,46,nil,nil,0},
[815] = {'Bookie Herod',992,992,35,35,0,{[33]={{45.0,8.45},{44.26,7.87},{44.66,11.01}}},nil,33,nil,nil,46,nil,nil,0},
[818] = {'Mai\'Zoth',4776,4776,47,47,1,{[33]={{52.93,27.6}}},nil,33,nil,nil,45,nil,nil,0},
[819] = {'Servant of Ilgalar',582,622,24,25,0,{[44]={{79.01,49.64},{78.83,49.33},{79.56,48.18},{79.06,48.41},{80.18,48.71},{80.16,48.89},{79.74,47.89},{79.56,47.82},{80.1,48.26},{79.16,47.43},{78.93,47.72}}},nil,44,nil,nil,39,nil,nil,0},
[820] = {'Scout Riell',1002,1002,30,30,0,{[40]={{56.67,47.35}}},nil,40,{214},{214},12,"A","The People's Militia",2},
[821] = {'Captain Danuvin',1221,1221,33,33,0,{[40]={{56.42,47.62}}},nil,40,{102},{102},12,"A","The People's Militia",2},
[822] = {'Young Forest Bear',195,220,8,9,0,{[12]={{60.18,79.54},{63.2,79.18},{22.43,75.77},{24.51,83.38},{25.52,90.7},{28.76,81.61},{43.4,81.24},{38.27,89.37},{36.34,89.15},{44.97,78.13},{46.32,75.83},{48.28,76.75},{47.02,79.67},{45.93,85.05},{49.22,82.79},{49.22,75.92},{53.95,75.54},{53.46,84.74},{56.89,75.92},{60.83,79.1},{63.27,77.05},{66.1,78.8},{70.64,74.9},{72.86,80.89},{75.79,67.54},{71.3,61.31},{68.86,63.86},{68.58,66.31},{62.92,65.88},{64.71,63.04},{59.11,66.91},{74.6,66.78},{77.2,76.69},{78.07,79.17},{83.55,84.72},{79.77,83.27},{81.13,77.25},{82.18,59.22},{77.93,61.68},{78.75,61.41},{86.38,78.45},{86.72,65.13},{86.61,65.16},{88.32,65.67},{86.21,63.21},{87.21,69.34},{88.86,77.54},{87.81,81.11}}},nil,12,nil,nil,44,nil,nil,0},
[823] = {'Deputy Willem',417,417,18,18,0,{[12]={{48.17,42.94}}},nil,12,{6,18,783,3903,5261},{6,18},12,"A",nil,2},
[824] = {'Defias Digger',328,356,15,16,0,{[40]={{43.36,74.64},{42.43,72.41},{42.27,75.56},{43.69,73.48},{42.68,78.32},{43.41,77.46},{42.15,74.43},{42.69,75.73},{43.73,76.53},{41.51,75.33},{42.8,77.1},{43.2,77.08},{41.5,76.2},{42.96,73.74},{43.64,74.22},{41.95,74.97},{41.43,74.73},{41.82,77.81},{41.23,75.69},{40.96,77.28},{42.24,77.99},{43.99,74.01},{42.77,72.12},{41.0,76.53},{42.46,74.89},{43.53,76.96},{41.5,76.76},{42.98,74.76},{42.19,76.83},{41.93,76.57},{42.93,74.23},{43.72,78.04},{43.83,77.49},{41.64,78.86},{42.46,76.86},{42.82,76.47},{41.81,75.81},{44.17,77.08},{43.0,72.42},{41.2,77.79}}},nil,40,nil,nil,17,nil,nil,0},
[826] = {'Watcher Jan',1536,1536,37,37,0,{[10]={{76.96,47.13}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[827] = {'Watcher Mocarski',1468,1468,36,36,0,{[10]={{73.67,50.74}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[828] = {'Watcher Petras',2790,2790,38,38,0,{[10]={{81.94,45.72}}},{[10]={{{81.94,45.72},{80.29,46.11},{79.29,45.4},{78.46,45.39},{77.62,46.24},{77.17,46.5},{76.38,46.54},{77.17,46.5},{77.62,46.24},{78.46,45.39},{79.29,45.4},{80.29,46.11}}}},10,nil,nil,56,"A","The Night Watch",0},
[829] = {'Adlin Pridedrift',102,102,5,5,0,{[1]={{30.09,71.52}}},nil,1,nil,nil,55,"A","General Supplies",6},
[830] = {'Sand Crawler',273,300,13,14,0,{[40]={{47.53,10.63},{47.94,10.27},{50.29,11.01},{46.09,9.58},{50.52,10.25},{50.74,11.03},{49.86,10.41},{46.68,10.63},{49.84,11.79},{46.44,10.22},{39.58,12.94},{39.62,12.34},{41.0,12.17},{40.77,11.54},{40.05,12.18},{41.08,11.17},{40.09,11.73}}},nil,40,nil,nil,7,"AH",nil,0},
[831] = {'Sea Crawler',328,356,15,16,0,{[40]={{32.56,22.01},{35.95,16.68},{31.68,22.65},{31.13,24.21},{34.94,18.47},{31.81,23.46},{36.57,16.2},{31.4,23.35},{31.61,24.13},{32.97,21.79},{32.47,21.41},{32.34,22.65}}},nil,40,nil,nil,7,"AH",nil,0},
[832] = {'Dust Devil',417,449,18,19,0,{[40]={{68.55,73.5},{38.18,62.31},{62.8,52.16},{35.38,34.9},{40.13,22.14},{42.75,41.95},{33.27,49.27},{60.8,34.97},{54.33,40.75},{34.31,67.98},{45.61,49.32},{41.75,59.4}}},nil,40,nil,nil,14,nil,nil,0},
[833] = {'Coyote Packleader',222,247,11,12,0,{[40]={{46.42,20.47},{47.47,14.81},{61.84,23.41},{62.27,41.99},{41.72,26.7},{39.74,26.53},{41.13,18.08},{41.11,26.23},{35.9,29.82},{30.5,38.19},{33.04,30.27},{36.55,36.47},{36.0,33.6},{34.97,39.11},{33.27,31.62},{32.59,40.17},{30.47,36.4},{62.06,32.45},{51.96,35.11},{60.08,36.42},{35.22,42.73},{37.27,25.11}}},nil,40,nil,nil,38,nil,nil,0},
[834] = {'Coyote',198,222,10,11,0,{[40]={{47.5,26.48},{59.63,12.28},{59.03,10.83},{56.03,22.37},{47.39,15.34},{58.42,14.68},{61.14,39.67},{59.35,30.45},{60.17,37.68},{61.55,26.32},{62.68,42.34},{58.83,28.09},{61.71,29.1},{58.76,22.45},{55.03,40.7},{41.45,34.99},{53.31,38.22},{50.74,29.17},{54.57,27.69},{46.23,31.14},{40.87,27.74},{36.42,26.04},{39.93,29.31},{39.56,20.84},{36.87,27.13},{38.19,23.8},{41.63,18.97},{41.2,26.39},{35.97,28.89},{30.81,39.28},{53.32,22.48},{43.39,29.15},{41.87,31.98},{62.68,36.39},{59.79,15.27},{56.98,18.22},{58.02,16.66},{35.36,42.15},{56.24,26.76},{50.52,45.08},{51.29,46.14},{55.09,29.49},{61.85,20.76}}},nil,40,nil,nil,38,nil,nil,0},
[836] = {'Durnan Furcutter',102,102,5,5,0,{[1]={{28.77,66.37}}},nil,1,{3365},{3364},55,"A","Cloth & Leather Armor Merchant",16391},
[837] = {'Branstock Khalder',102,102,5,5,0,{[1]={{28.6,66.39}}},nil,1,{5626},{3110},55,"A","Priest Trainer",19},
[840] = {'Watcher Backus',3302,3302,42,42,0,{[10]={{74.83,44.22}}},{[10]={{{72.44,34.12},{73.35,32.51},{73.23,32.67},{72.26,34.97},{72.18,37.22},{72.56,38.36},{73.84,39.56},{74.25,40.44},{74.53,41.33},{74.81,44.29},{74.63,41.75},{74.1,39.95},{73.68,39.43},{72.51,38.31},{72.22,37.31},{71.96,35.71},{72.03,35.67},{71.89,35.7}},{{74.83,44.22},{74.63,42.1},{74.54,41.1},{74.09,39.88},{73.33,39.16},{72.98,38.79},{72.56,38.36},{72.27,37.49},{72.27,37.25},{72.24,35.61},{72.23,35.51},{72.23,35.29},{72.53,33.67},{73.32,32.53},{73.32,32.53},{72.53,33.67},{72.23,35.29},{72.23,35.51},{72.24,35.61},{72.27,37.25},{72.27,37.49},{72.51,38.31},{72.98,38.79},{73.33,39.16},{74.09,39.88},{74.54,41.1},{74.63,42.1},{74.83,44.22}}}},10,{1244,1245},{1243,1244},56,"A","The Night Watch",2},
[841] = {'Harl Cutter',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH","Woodcrafting Supplier",0},
[842] = {'Lumberjack',102,102,5,5,0,{[40]={{52.45,51.95},{53.58,53.37},{54.54,52.47},{53.5,50.78}}},nil,40,nil,nil,12,"A",nil,0},
[843] = {'Gina MacGregor',328,328,15,15,0,{[40]={{57.64,54.05}}},nil,40,nil,nil,12,"A","Trade Supplies",4},
[844] = {'Antonio Perelli',1342,1342,35,35,0,{[12]={{78.12,72.96}}},{[12]={{{75.43,72.31},{73.05,72.7},{70.32,70.94},{69.33,71.31},{66.65,74.11},{63.98,73.72},{61.62,72.76},{58.03,71.46},{54.25,72.77},{50.24,71.5},{48.12,69.92},{45.09,68.97},{42.59,67.23}},{{78.12,72.96},{77.74,72.69},{76.81,72.41},{75.5,72.34},{74.77,72.44},{74.61,72.46},{74.33,72.5},{73.94,72.56},{73.21,72.66},{72.63,72.64},{72.1,72.3},{70.94,71.1},{69.88,70.89},{69.14,71.28},{68.01,72.79},{67.15,73.8},{66.81,73.93},{65.6,74.1},{65.12,74.06},{63.69,73.6},{63.16,73.35},{62.73,72.97},{62.21,72.7},{61.09,72.63},{60.01,72.41},{59.05,71.71},{58.39,71.29},{57.81,71.31},{56.61,72.18},{55.87,72.48},{54.33,72.64},{53.02,72.56},{52.59,72.43},{51.94,72.21},{50.98,71.78},{50.3,71.46},{48.93,70.57},{48.27,69.84},{47.69,69.6},{46.31,69.48},{45.29,69.12},{44.01,68.14},{42.97,67.43},{42.58,66.99},{42.42,66.47},{42.48,65.84},{42.71,65.63},{43.19,65.71},{43.18,66.0},{43.36,66.01},{43.5,66.02},{43.68,66.06},{43.79,65.97},{43.7,66.07},{43.55,66.03},{43.37,66.01},{43.2,66.04},{43.19,65.71},{42.77,65.62},{42.5,65.74},{42.25,66.75},{41.94,66.87},{40.88,66.63},{39.68,66.63},{38.97,66.76},{38.11,67.54},{37.45,68.45},{37.11,69.26},{37.02,71.75},{36.86,73.91},{36.44,74.95},{35.87,75.82},{34.98,76.79},{33.95,77.64},{32.61,78.34},{31.53,78.51},{30.28,78.19},{29.42,78.02},{28.71,77.92},{28.26,77.85},{26.85,77.76},{25.17,78.48},{24.65,78.63},{23.84,78.52},{23.27,78.31},{22.46,78.39},{21.4,79.01},{20.79,79.7}},{{93.51,72.14},{92.08,72.68},{91.25,73.5},{90.77,73.72},{89.65,73.68},{88.87,73.74},{87.58,73.92},{86.86,74.06},{85.73,73.89},{84.64,74.29},{83.64,74.46},{82.64,74.25},{81.64,73.88},{80.77,73.85},{79.74,73.95},{79.13,73.88},{78.69,73.58}}},[40]={{{62.31,17.29},{61.55,18.25},{60.85,18.85},{60.31,19.24},{59.63,20.16},{59.19,20.27},{58.67,20.31},{58.09,21.01},{58.0,21.53},{57.99,22.11},{57.69,23.25},{57.54,23.59},{57.49,24.27},{57.64,25.03},{58.01,26.25},{58.15,27.09},{57.86,27.79},{57.5,28.53},{57.39,29.05},{57.5,29.64},{57.7,30.11},{57.9,30.64},{57.91,31.66},{58.01,33.13},{58.01,34.0},{57.79,35.09},{57.8,36.41},{57.94,36.9},{58.39,37.48},{58.64,38.0},{58.54,38.94},{58.23,39.93},{58.16,41.85},{57.81,42.94},{57.82,43.5},{58.09,44.22},{58.94,45.95},{58.92,47.55},{58.51,49.25},{58.19,50.24},{57.54,52.37},{57.43,53.04},{57.61,53.65},{57.59,53.85},{57.33,53.96},{56.86,54.04},{56.51,53.74},{55.75,52.9},{55.0,52.79},{54.68,52.43},{53.49,52.87},{53.08,53.22},{53.0,53.36},{52.9,53.53},{53.0,53.36},{53.05,53.27},{53.51,52.87},{54.63,52.44},{55.02,52.81},{55.72,52.92},{56.74,54.04},{56.61,56.06},{56.93,57.3},{57.12,57.96},{57.13,60.31},{57.37,61.3},{57.45,62.73},{57.49,63.67},{57.67,64.41},{57.81,65.1},{58.46,65.98},{59.1,66.36},{59.43,66.37},{59.78,65.9},{60.29,64.99},{60.81,64.84},{61.43,65.04},{61.89,65.42},{62.45,65.51},{62.92,65.37},{63.51,64.91},{64.27,63.96},{64.87,63.37},{67.08,62.85}}},[10]={{{7.58,63.81},{8.97,63.76},{10.43,63.3},{12.32,62.45},{13.79,61.68},{15.64,61.25},{17.55,61.03},{19.04,60.9},{19.98,60.54},{21.29,60.25},{23.1,59.64},{23.81,59.24},{24.7,58.62},{25.76,57.77},{26.33,57.6},{27.56,57.61},{28.1,57.7},{29.29,58.3},{30.75,59.22},{31.98,59.75},{33.39,60.38},{35.16,61.37},{35.72,61.64},{36.43,61.99},{36.89,62.19},{37.62,62.5},{38.85,62.96},{40.15,63.32},{41.27,63.74},{42.29,64.32},{43.13,64.85},{43.51,65.08},{44.59,65.91},{45.87,65.99},{46.87,66.02},{47.89,66.27},{49.46,66.36},{50.21,66.52},{51.13,66.86},{52.03,67.5},{52.94,68.52},{54.01,69.03},{54.86,68.91},{56.01,67.74},{57.31,66.63},{58.29,65.66},{59.96,63.2},{61.06,62.14},{62.06,61.41},{63.19,60.73},{64.71,60.07},{65.64,60.09},{66.72,60.6},{67.66,60.61},{68.99,60.53},{69.8,60.18},{70.58,59.57},{72.18,59.1},{73.05,58.21},{74.0,56.41},{74.79,54.36},{75.06,53.01},{75.03,51.89},{74.6,49.24},{74.48,48.2},{74.16,47.64},{73.79,47.01},{73.83,46.12},{73.82,45.56},{74.1,45.46},{74.02,45.14},{74.01,44.87},{73.98,44.5},{73.99,44.74},{74.02,45.13},{74.1,45.47},{73.81,45.53},{73.84,46.2},{74.46,46.71},{74.87,46.43},{74.81,44.55},{74.62,41.72},{74.16,40.05},{73.72,39.47},{72.85,38.8},{72.45,38.11},{72.22,37.3},{72.2,35.42},{72.52,33.95},{73.29,32.47},{73.6,31.21},{73.65,29.15},{73.58,28.21},{73.33,26.72},{73.39,25.07},{73.78,23.81},{74.39,22.91},{74.99,22.64},{75.87,21.84},{77.77,20.66},{78.57,20.46},{79.63,20.34},{81.62,19.99},{82.41,20.35},{83.38,20.41},{85.32,20.31},{85.97,19.86},{86.66,19.39},{87.64,18.05},{88.22,16.99},{89.45,16.02},{90.83,14.91},{92.62,13.04},{93.69,11.62}}},[44]={{{6.45,91.31},{7.13,89.38},{8.36,88.2},{9.73,86.45},{10.67,83.94},{11.99,81.53},{13.32,80.11},{14.2,79.05},{14.78,77.43},{15.14,75.0},{15.49,72.45},{16.65,70.55},{17.81,69.21},{18.9,69.37},{20.14,70.12},{22.41,69.9},{22.77,70.33},{23.12,72.11},{23.71,72.86},{24.48,72.39},{26.19,69.78},{27.21,68.91},{28.69,68.02},{29.19,67.58},{29.73,67.01},{31.14,64.97},{31.7,63.55},{32.38,59.53},{32.45,57.32},{32.59,54.72},{32.71,51.66},{32.8,49.44},{32.6,48.38},{31.44,48.11},{30.97,48.1},{29.37,48.02},{29.12,47.63},{28.58,47.62},{27.8,46.98},{26.83,46.97},{26.62,46.42},{26.62,45.8},{27.0,45.75},{26.93,45.34},{26.92,44.99},{26.91,44.55},{26.85,44.27},{26.91,44.53},{26.92,44.92},{26.92,45.32},{26.99,45.74},{26.62,45.8},{26.61,46.56},{27.01,47.15},{27.97,47.21},{28.58,47.64},{30.92,48.13},{31.96,48.21},{32.57,48.32},{32.84,49.4},{32.71,51.66},{32.56,54.49},{32.41,57.24},{32.24,59.48},{31.85,62.22},{31.13,64.68},{29.52,67.02},{29.23,67.33},{28.75,67.73},{26.65,69.11},{25.76,70.19},{24.21,72.49},{23.73,72.59},{23.39,72.21},{22.85,70.28},{22.39,69.73},{20.17,69.91},{18.57,69.12},{17.65,69.09},{15.7,69.67},{13.14,71.06},{11.98,71.79},{10.34,71.95},{8.61,71.62},{7.88,71.55}}}},12,nil,nil,12,"A","Traveling Salesman",4},
[846] = {'Ghoul',300,328,14,15,0,{[40]={{40.47,68.07},{40.37,66.81},{40.18,67.56},{39.82,68.15},{39.74,66.96}}},nil,40,nil,nil,21,nil,nil,0},
[847] = {'Nathan',102,102,5,5,0,{[44]={{29.19,47.47}}},nil,44,nil,nil,35,"AH",nil,0},
[848] = {'Madison',102,102,5,5,0,{[44]={{29.08,51.98}}},{[44]={{{29.08,51.98},{29.34,49.28},{27.86,48.9},{25.74,47.46},{25.3,46.7},{24.67,46.35},{22.49,46.04},{21.87,46.47},{20.41,46.42},{21.29,46.5},{22.41,46.02},{24.14,46.05},{26.14,46.95},{28.12,46.97},{28.59,47.96},{29.47,48.71},{29.37,51.05}}}},44,nil,nil,35,"AH",nil,0},
[849] = {'Rachel',71,71,3,3,0,{[44]={{29.19,47.44}}},{[44]={{{29.19,47.44},{29.19,47.44},{29.44,48.89},{29.59,50.16},{29.6,50.83},{29.6,51.15},{29.48,52.16},{29.31,52.89},{28.86,53.04},{28.41,53.1},{28.37,52.63},{29.0,52.83},{29.45,52.42},{29.48,52.18},{29.5,51.56},{29.46,50.23},{29.42,49.84},{29.19,49.28},{28.44,49.07},{28.25,49.03},{27.65,48.58},{26.43,47.87},{25.93,47.59},{25.84,47.2},{25.73,45.87},{25.66,45.07},{25.83,44.45},{25.97,43.95},{26.05,43.3},{26.04,43.13},{26.0,42.63},{26.07,42.54},{26.76,42.03},{26.86,42.01},{27.65,41.85},{27.74,41.84},{28.86,42.33},{28.94,42.41},{28.61,42.73},{28.53,42.75},{27.94,43.41},{27.9,43.51},{27.79,44.01},{27.79,44.12},{27.79,44.64},{27.8,45.35},{27.8,45.46},{27.82,46.12},{28.32,47.05},{28.36,47.12},{28.75,47.45},{29.16,47.64}}}},44,nil,nil,35,"AH",nil,0},
[850] = {'Erin',102,102,5,5,0,{[44]={{24.82,41.39}}},{[44]={{{24.82,41.39},{24.32,42.65},{23.94,43.73},{23.9,44.61},{23.71,45.58},{24.2,46.1},{25.4,46.6},{26.21,47.04},{26.58,46.92},{26.63,45.85},{26.8,45.76},{26.93,44.47},{26.77,44.3},{26.57,44.29},{26.57,44.29},{26.9,44.44},{26.92,45.37},{27.04,45.72},{26.66,45.78},{26.61,46.53},{26.15,47.06},{25.37,46.69},{24.95,46.84},{24.7,47.38},{25.0,46.74},{25.65,46.37},{26.03,46.52},{26.6,46.92},{27.09,48.08},{27.04,48.55},{26.61,50.76},{26.75,50.11},{27.05,48.57},{27.02,47.41},{26.21,46.79},{25.3,46.25},{24.17,46.07},{23.7,45.49},{23.92,44.53},{23.93,43.66},{24.02,43.08},{24.82,41.39}}}},44,nil,nil,12,"A",nil,0},
[851] = {'Hannah',102,102,5,5,0,{[44]={{21.38,45.87}}},nil,44,nil,nil,12,"A",nil,2},
[852] = {'Feral Spirit',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[853] = {'Coldridge Mountaineer',5228,5228,55,55,0,{[1]={{34.01,71.54},{34.14,71.66},{34.2,71.78},{33.89,71.53},{34.04,72.11},{30.1,72.0},{29.82,71.15},{30.06,71.31},{29.57,71.6},{28.95,70.23},{29.72,71.94},{28.6,69.85},{29.03,68.16},{28.65,67.29},{28.53,68.1},{29.18,70.04},{71.03,37.97}}},nil,1,nil,nil,57,"A",nil,0},
[854] = {'Young Jungle Stalker',1469,1536,36,37,0,{[33]={{31.99,42.48},{31.31,44.65},{32.1,43.14},{30.72,43.97}}},nil,33,nil,nil,48,nil,nil,0},
[855] = {'Young Stranglethorn Raptor',1051,1107,30,31,0,{[33]={{24.16,16.26},{24.01,15.73},{24.75,16.04}}},nil,33,nil,nil,48,nil,nil,0},
[856] = {'Young Lashtail Raptor',1221,1279,33,34,0,{[33]={{30.58,23.48}}},nil,33,nil,nil,48,nil,nil,0},
[857] = {'Donal Osgood',157200,157200,61,61,1,{[1537]={{69.92,88.95}}},nil,1537,nil,nil,1577,"A","Arathi Basin Battlemaster",2049},
[858] = {'Sorrow Spinner',1469,1536,36,37,0,{[8]={{25.97,49.55},{47.77,33.77},{27.67,43.37},{36.55,30.86},{43.24,29.04},{28.34,62.04},{39.5,30.81},{40.84,29.78},{37.14,28.61},{33.21,28.93},{37.47,32.08},{71.44,29.97},{31.6,50.54},{34.48,55.15},{22.54,37.72},{38.84,37.48},{26.75,48.64},{26.45,45.89},{29.34,53.26},{22.31,58.98},{19.79,52.86},{22.67,62.2},{24.86,64.01},{25.38,59.33},{26.13,61.95},{17.62,53.42},{21.26,42.52}}},nil,8,nil,nil,22,nil,nil,0},
[859] = {'Guard Berton',2220,2220,33,33,0,{[44]={{26.26,46.58}}},nil,44,{386},{386},11,"A",nil,2},
[860] = {'Pet Wolf',198,198,10,10,0,nil,nil,0,nil,nil,11,"A",nil,0},
[861] = {'Stonard Scout',1468,1536,36,37,0,{[8]={{17.33,50.42},{38.14,56.41},{20.53,50.33},{35.06,58.85},{14.84,52.22}}},nil,8,nil,nil,29,"H",nil,0},
[862] = {'Stonard Explorer',1536,1604,37,38,0,{[8]={{79.95,74.42},{76.59,8.92},{60.22,56.12},{55.48,24.82},{50.99,30.37},{67.43,14.84}}},nil,8,nil,nil,125,"H",nil,0},
[863] = {'Stonard Hunter',3398,3398,55,55,0,{[8]={{82.19,81.04},{80.88,80.2},{81.68,79.6},{81.02,81.08},{82.47,79.89}}},nil,8,nil,nil,125,"H",nil,0},
[864] = {'Stonard Orc',2577,2577,48,48,0,{[8]={{44.42,54.9},{48.35,57.72},{43.04,53.41}}},{[8]={{{44.42,54.9},{44.37,54.75},{44.2,54.94},{44.23,55.13},{44.32,55.27},{44.42,55.32},{44.42,55.42},{43.24,55.11},{43.05,55.53},{42.97,55.71},{42.98,55.64},{43.18,55.56},{43.55,54.98},{44.32,54.65}},{{48.35,57.72},{48.32,57.51},{49.3,55.58},{49.32,53.99},{48.73,53.36},{47.24,53.09},{47.16,52.46},{46.44,52.01},{46.42,51.42},{46.91,51.44},{47.3,51.44},{46.92,51.39},{46.84,51.52},{46.7,51.37},{46.46,51.4},{46.51,52.03},{46.57,52.44},{46.49,52.69},{46.38,52.79},{46.56,53.01},{46.29,53.86},{46.45,54.2},{46.41,54.48},{46.47,54.71},{46.55,55.06},{46.72,54.9},{46.7,54.78},{46.73,54.82},{46.69,54.96},{46.55,55.03},{46.48,54.88},{46.54,54.84},{46.49,55.19},{47.42,57.53},{47.8,57.96},{47.92,57.69},{48.21,57.51},{48.46,57.51}},{{43.04,53.41},{43.28,53.47},{43.16,55.01},{44.03,54.88},{45.23,53.73},{45.56,53.01},{45.15,51.84},{45.23,52.0},{45.84,51.37},{46.78,51.54},{46.24,51.62},{46.31,52.59},{46.51,53.11},{43.63,55.0},{43.09,54.95},{43.09,54.3},{43.19,54.16},{43.25,53.96},{43.25,53.46}}}},8,nil,nil,125,"H",nil,0},
[865] = {'Stonard Wayfinder',2879,2979,50,51,0,{[8]={{49.96,48.28},{50.19,49.91}}},nil,8,nil,nil,125,"H",nil,0},
[866] = {'Stonard Grunt',3508,3508,56,56,0,{[8]={{44.41,49.49},{47.32,49.72},{41.49,52.62},{47.59,58.42},{48.94,51.47},{41.4,56.46},{44.89,49.04},{48.02,58.11},{43.37,55.51},{43.3,54.44}}},nil,8,nil,nil,85,"H",nil,0},
[867] = {'Stonard Cartographer',3082,3082,52,52,0,{[8]={{49.55,49.0}}},nil,8,nil,nil,125,"H",nil,0},
[868] = {'Stonard Shaman',2550,2550,53,53,0,{[8]={{81.68,80.85}}},nil,8,nil,nil,125,"H",nil,0},
[869] = {'Protector Dorana',1910,1910,30,30,0,{[40]={{57.31,53.88}}},{[40]={{{57.14,53.26},{57.59,52.29},{57.96,51.17},{58.31,49.91},{58.71,48.55},{58.97,47.15},{58.94,45.72},{58.13,44.28},{57.77,43.31},{57.83,42.87},{58.07,42.29},{58.17,41.46},{58.23,40.01},{58.6,38.58},{58.65,37.95},{58.46,37.45},{58.09,37.18},{57.91,36.9},{57.73,35.74},{57.78,34.97},{57.92,34.29},{58.05,33.86},{58.0,32.86},{57.89,31.44},{57.9,30.72},{57.64,30.01},{57.9,30.72},{57.89,31.44},{58.0,32.86},{58.05,33.86},{57.92,34.29},{57.78,34.97},{57.73,35.74},{57.91,36.9},{58.09,37.18},{58.46,37.45},{58.65,37.95},{58.6,38.58},{58.23,40.01},{58.17,41.46},{58.07,42.29},{57.83,42.87},{57.77,43.31},{58.13,44.28},{58.94,45.72},{58.97,47.15},{58.71,48.55},{58.31,49.91},{57.96,51.17},{57.59,52.29},{57.14,53.26},{57.27,53.46}}}},40,nil,nil,11,"A","The People's Militia",0},
[870] = {'Protector Deni',1910,1910,30,30,0,{[40]={{55.03,53.89}}},nil,40,nil,nil,11,"A","The People's Militia",0},
[871] = {'Saltscale Warrior',3660,3831,35,36,1,{[33]={{24.41,24.76},{24.94,23.25},{24.71,24.51},{27.01,24.25},{26.96,22.41}}},nil,33,nil,nil,18,nil,nil,0},
[873] = {'Saltscale Oracle',3150,3279,36,37,1,{[33]={{24.56,23.99},{24.29,24.28},{24.8,23.42},{24.52,25.01},{25.1,23.79}}},nil,33,nil,nil,18,nil,nil,0},
[874] = {'Protector Korelor',1910,1910,30,30,0,{[40]={{55.11,52.84}}},{[40]={{{55.56,52.89},{56.0,53.18},{56.51,53.79},{56.79,54.15},{56.66,55.71},{56.69,56.56},{56.85,57.11},{57.09,57.72},{57.13,58.66},{57.09,59.73},{57.34,61.43},{57.43,62.76},{57.63,64.23},{57.81,65.13},{58.54,66.11},{59.31,66.39},{59.5,66.29},{60.43,64.91},{61.37,64.98},{61.84,65.41},{62.4,65.54},{63.33,65.13},{63.97,64.32},{64.78,63.44},{65.25,63.3},{66.2,63.07},{67.18,62.87},{66.2,63.07},{65.25,63.3},{64.78,63.44},{63.97,64.32},{63.33,65.13},{62.4,65.54},{61.84,65.41},{61.37,64.98},{60.43,64.91},{59.5,66.29},{59.31,66.39},{58.54,66.11},{57.81,65.13},{57.63,64.23},{57.43,62.76},{57.34,61.43},{57.09,59.74},{57.13,58.66},{57.09,57.72},{56.85,57.11},{56.69,56.56},{56.66,55.71},{56.79,54.15},{56.51,53.79},{56.0,53.18},{55.56,52.89},{55.17,52.89}}}},40,nil,nil,11,"A","The People's Militia",0},
[875] = {'Saltscale Tide Lord',3279,3279,37,37,1,{[33]={{25.02,24.06},{24.91,24.77}}},nil,33,nil,nil,18,nil,nil,0},
[876] = {'Protector Leick',1910,1910,30,30,0,{[40]={{54.95,53.22}}},nil,40,nil,nil,11,"A","The People's Militia",0},
[877] = {'Saltscale Forager',3660,3831,35,36,1,{[33]={{24.04,25.35},{24.23,25.28}}},nil,33,nil,nil,18,nil,nil,0},
[878] = {'Scout Galiaan',1002,1002,30,30,0,{[40]={{53.98,52.98}}},nil,40,{153},{153},12,"A","The People's Militia",2},
[879] = {'Saltscale Hunter',3660,3831,35,36,1,{[33]={{23.58,24.94},{23.17,25.02},{23.44,25.51},{24.23,23.83},{25.27,24.17}}},nil,33,nil,nil,18,nil,nil,0},
[880] = {'Erlan Drudgemoor',156,156,8,8,0,{[12]={{70.95,80.63}}},nil,12,nil,nil,17,nil,nil,0},
[881] = {'Surena Caledon',160,160,9,9,0,{[12]={{71.01,80.77}}},nil,12,nil,nil,17,nil,nil,0},
[882] = {'Bone Caster',2924,3110,57,59,0,nil,nil,0,nil,nil,21,nil,nil,0},
[883] = {'Deer',1,1,1,1,0,{[12]={{51.24,49.8},{54.7,50.64},{40.55,56.85},{32.12,53.95},{34.43,54.67},{36.92,55.94},{44.66,50.01},{43.81,40.53},{47.07,31.99},{44.46,38.08},{49.92,32.28},{55.07,46.33},{40.22,57.28},{32.28,53.64},{32.95,58.78},{44.98,66.14},{36.74,66.42},{25.24,82.97},{36.14,81.31},{35.47,78.0},{41.2,79.91},{43.35,78.33},{40.17,91.41},{38.47,74.16},{46.21,78.61},{48.29,83.42},{45.81,86.99},{45.06,87.34},{51.52,77.71},{49.32,75.82},{54.01,79.49},{56.87,74.13},{73.36,80.49},{69.65,72.13},{56.85,70.75},{45.21,67.01},{81.05,84.24},{80.83,64.29},{80.37,64.7},{76.81,39.49},{86.95,83.73},{86.94,72.06},{88.65,80.62},{55.78,45.27},{56.8,42.68}},[36]={{79.59,51.51},{63.71,53.04},{77.58,45.18},{82.3,63.38},{57.75,60.13},{80.47,38.28}},[130]={{55.28,24.8},{47.18,19.11}},[406]={{40.91,16.34},{37.76,14.64}},[331]={{27.13,21.82},{47.11,62.24},{62.48,49.95},{38.27,36.59},{30.04,16.29},{55.73,53.3},{26.17,30.5},{42.85,55.37},{50.43,45.54},{48.73,66.71},{31.27,46.18},{30.4,32.35},{31.44,57.73},{26.86,42.06},{17.86,32.02},{61.02,64.68},{22.04,40.75},{33.98,34.68},{76.15,52.35},{57.85,64.48},{76.0,65.73},{73.55,61.17}},[2557]={{-1,-1}},[148]={{55.51,26.68},{39.98,70.07},{44.17,52.55},{43.15,74.9},{56.11,22.41},{42.85,83.19}},[493]={{35.17,62.83},{35.23,58.41},{42.46,60.16},{38.33,34.34},{65.24,46.59},{68.05,63.77},{45.72,63.79},{40.84,60.11},{42.2,46.26},{34.14,43.25},{37.2,53.81},{66.9,56.02},{37.06,34.89},{37.02,43.69},{65.4,69.27},{69.06,55.76},{39.86,28.83},{45.4,60.77},{31.23,48.45},{57.56,75.53},{52.18,38.39},{66.33,68.22},{39.44,47.69},{58.09,68.84},{43.51,58.23},{34.19,61.3},{33.21,35.47},{61.1,47.81},{70.37,51.79},{63.71,44.34},{56.96,31.24},{65.8,60.81},{35.86,50.9},{43.5,51.27},{65.03,64.62},{55.27,33.18},{66.73,48.25},{51.01,71.53},{69.29,52.47},{62.36,67.03},{64.33,54.37},{43.21,47.15},{39.63,67.31},{37.11,27.0},{49.72,63.69},{52.86,74.01},{31.5,55.12},{32.01,39.6},{65.58,52.04},{64.22,67.34},{65.22,66.98},{67.52,53.42},{33.84,51.4},{41.46,67.41},{38.88,46.84},{60.78,72.12},{58.11,65.71},{65.53,48.08},{34.33,40.31},{63.9,49.23},{38.13,65.66},{47.12,68.15},{33.18,32.72},{65.15,71.66},{40.65,55.1},{41.54,42.23},{63.83,69.68},{31.93,60.51},{46.6,68.55},{48.92,71.67},{34.92,56.03},{39.38,42.17},{47.52,32.95}},[28]={{44.6,83.25}},[141]={{42.5,72.04},{47.91,74.32},{46.64,33.32},{65.02,53.6},{41.21,28.7},{45.2,36.79},{53.89,76.62},{55.84,45.17},{54.18,58.8},{38.39,44.77},{41.03,38.59},{64.64,61.53},{55.51,66.97},{55.63,38.59},{60.59,74.55},{63.33,64.12},{43.26,74.01},{53.04,62.7},{40.08,69.73},{40.38,60.29},{61.68,42.12},{63.38,71.21},{61.78,36.12},{60.37,34.06},{62.23,60.4},{68.0,53.7},{53.61,59.8}},[1657]={{76.48,55.13},{54.94,8.53},{40.64,18.79},{48.47,92.69},{52.32,0.21},{55.43,16.47},{68.37,55.63},{66.76,35.71},{54.19,85.35},{49.71,5.74},{36.64,18.32},{28.65,36.9},{45.84,4.21},{26.02,85.02},{58.38,66.87},{66.64,23.44}},[357]={{42.73,22.35},{75.56,51.26},{40.03,8.55}},[40]={{59.25,19.7},{59.8,20.27}}},nil,493,nil,nil,31,"AH",nil,0},
[885] = {'Watcher Keller',1536,1536,37,37,0,{[10]={{78.23,44.74}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[886] = {'Watcher Hartin',1468,1468,36,36,0,{[10]={{75.21,44.82}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[887] = {'Watcher Jordan',2918,2918,39,39,0,{[10]={{74.77,50.44}}},{[10]={{{74.74,50.42},{74.56,49.29},{74.45,48.27},{74.64,47.15},{75.71,46.74},{74.88,46.32},{74.8,44.57},{74.78,46.25},{73.69,46.62},{74.26,47.87},{74.58,49.08}},{{74.77,50.44},{74.99,51.63},{75.01,51.77},{75.04,53.07},{75.06,53.59},{75.06,53.62},{74.51,54.97},{74.48,55.05},{74.43,55.16},{74.37,55.31},{73.76,56.73},{73.35,57.51},{73.12,57.89},{72.79,58.33},{72.7,58.45},{72.57,58.56},{72.13,58.95},{72.05,59.02},{71.99,59.07},{71.87,59.15},{71.68,59.26},{70.86,59.47},{71.68,59.26},{71.87,59.15},{71.99,59.07},{72.05,59.02},{72.13,58.95},{72.57,58.56},{72.7,58.45},{72.79,58.33},{73.12,57.89},{73.35,57.51},{73.76,56.73},{74.37,55.31},{74.43,55.16},{74.48,55.05},{74.51,54.97},{75.06,53.62},{75.06,53.59},{75.04,53.07},{75.01,51.77},{74.99,51.63}}}},10,nil,nil,56,"A","The Night Watch",0},
[888] = {'Watcher Dodds',950,950,29,29,0,{[10]={{45.12,67.03}}},nil,10,{245},{245},53,"A","The Night Watch",2},
[889] = {'Splinter Fist Ogre',734,788,25,26,0,{[10]={{38.72,70.5},{40.37,71.98},{40.45,70.49},{37.51,72.0},{38.48,72.57},{38.68,74.86},{39.33,75.97}}},nil,10,nil,nil,45,nil,nil,0},
[890] = {'Fawn',8,8,1,1,0,{[12]={{32.29,53.64},{36.94,55.81},{43.84,40.53},{43.81,40.53},{51.31,49.65},{55.85,45.08},{32.3,53.7},{45.01,66.25},{25.32,83.05},{35.55,77.95},{45.18,67.09},{80.4,64.64},{86.98,71.99},{88.64,80.72}}},nil,12,nil,nil,31,"AH",nil,0},
[891] = {'Splinter Fist Fire Weaver',628,665,26,27,0,{[10]={{36.26,75.22},{35.03,70.65},{36.27,70.91},{39.98,74.01},{39.3,74.51},{40.39,75.17},{34.86,72.06}}},nil,10,nil,nil,45,nil,nil,0},
[892] = {'Splinter Fist Taskmaster',840,896,27,28,0,{[10]={{33.75,68.21},{39.51,74.99},{36.57,72.44},{33.84,70.49}}},nil,10,nil,nil,45,nil,nil,0},
[893] = {'Lars',417,417,18,18,0,{[10]={{7.71,33.2}}},nil,10,{226},{226},12,"A",nil,2},
[894] = {'Homer Stonefield',102,102,5,5,0,{[12]={{33.69,82.9}}},nil,12,nil,nil,12,"A","Fruit Seller",4},
[895] = {'Thorgas Grimson',102,102,5,5,0,{[1]={{29.18,67.45}}},nil,1,{6074},{3108},55,"A","Hunter Trainer",19},
[896] = {'Veldan Lightfoot',198,198,10,10,0,{[12]={{25.18,73.89}}},nil,12,nil,nil,12,"A","Leather Armor Merchant",16388},
[898] = {'Nightbane Worgen',787,840,26,27,0,{[10]={{60.89,32.79},{59.93,68.89},{62.64,31.05},{62.56,54.97},{61.18,66.41},{62.78,68.57},{58.5,25.61},{59.46,27.49},{61.25,30.27},{66.08,40.62},{58.83,50.27},{66.9,42.85},{59.07,53.7},{57.38,51.88},{61.2,53.21},{57.41,27.57},{58.51,29.94},{59.96,31.76},{62.59,42.27},{67.28,38.69},{62.08,27.86},{66.31,37.47},{63.74,33.57},{64.88,34.4},{57.82,29.86},{58.07,30.54},{61.44,50.29},{60.31,47.96}}},nil,10,nil,nil,24,nil,nil,0},
[900] = {'Bailiff Conacher',1002,1002,30,30,0,{[44]={{29.72,44.26}}},nil,44,{91},{91},11,"A",nil,2},
[903] = {'Guard Howe',1910,1910,30,30,0,{[44]={{31.54,57.85}}},nil,44,{128},{128},11,"A",nil,2},
[905] = {'Sharptooth Frenzy',1107,1163,31,32,0,{[33]={{40.92,16.84},{41.91,20.04},{40.89,18.39},{41.33,17.48},{39.4,29.61},{39.82,25.64},{40.43,21.51},{35.59,33.25},{40.22,22.14},{42.33,18.41},{39.03,30.57},{36.05,33.11},{40.81,16.03},{37.65,10.22},{37.43,32.1},{39.29,11.9},{40.55,14.38},{32.9,8.27}}},nil,33,nil,nil,16,nil,nil,0},
[906] = {'Maximillian Crowe',198,198,10,10,0,{[12]={{44.39,66.24}}},nil,12,nil,nil,12,"A","Warlock Trainer",17},
[907] = {'Keras Wolfheart',157200,157200,61,61,1,{[1657]={{58.02,37.29}}},nil,1657,nil,nil,1577,"A","Arathi Basin Battlemaster",2049},
[908] = {'Flora Silverwind',2138,2138,44,44,0,{[33]={{27.72,77.86}}},nil,33,nil,nil,120,"AH","Superior Herbalist",16},
[909] = {'Defias Night Blade',734,788,25,26,0,{[10]={{22.57,71.59},{21.63,73.32},{21.62,73.0},{20.51,72.66},{23.37,73.31},{47.79,76.85},{48.12,75.49},{48.81,77.48},{21.81,71.94},{19.93,70.78},{23.01,73.84},{49.92,77.27},{50.51,77.05},{50.73,76.99},{23.9,71.38},{24.04,72.1}}},nil,10,nil,nil,17,nil,nil,0},
[910] = {'Defias Enchanter',628,665,26,27,0,{[10]={{48.81,77.5},{21.35,73.36},{21.47,73.02},{21.27,71.96},{50.43,77.36},{23.65,71.95}}},nil,10,nil,nil,17,nil,nil,0},
[911] = {'Llane Beshere',102,102,5,5,0,{[12]={{50.24,42.29}}},nil,12,nil,{3100},12,"A","Warrior Trainer",19},
[912] = {'Thran Khorman',102,102,5,5,0,{[1]={{28.83,67.24}}},nil,1,nil,{3106,3112},55,"A","Warrior Trainer",19},
[913] = {'Lyria Du Lac',247,247,12,12,0,{[12]={{41.09,65.77}}},nil,12,{1638},nil,12,"A","Warrior Trainer",19},
[914] = {'Ander Germaine',4120,4120,60,60,0,{[1519]={{78.21,47.59}}},nil,1519,nil,nil,12,"A","Warrior Trainer",17},
[915] = {'Jorik Kerridan',102,102,5,5,0,{[12]={{50.31,39.92}}},nil,12,nil,{3102},12,"A","Rogue Trainer",19},
[916] = {'Solm Hargrin',102,102,5,5,0,{[1]={{28.37,67.51}}},nil,1,nil,{3109,3113},55,"A","Rogue Trainer",19},
[917] = {'Keryn Sylvius',222,222,11,11,0,{[12]={{43.87,65.94}}},nil,12,{2205,2300},nil,12,"A","Rogue Trainer",19},
[918] = {'Osborne the Night Man',4120,4120,60,60,0,{[1519]={{74.64,52.82}}},nil,1519,nil,nil,12,"A","Rogue Trainer",19},
[920] = {'Nightbane Tainted One',892,935,30,31,0,{[10]={{63.14,80.34},{61.24,81.67},{60.91,80.91},{63.57,83.62},{62.37,81.1},{62.33,82.2},{63.6,84.2},{63.48,83.67},{73.61,78.95},{73.5,76.99},{74.06,79.59},{74.11,78.7},{73.9,77.22},{73.13,75.52}}},nil,10,nil,nil,24,nil,nil,0},
[921] = {'Venture Co. Lumberjack',1279,1342,34,35,0,{[33]={{43.32,19.09}}},nil,33,nil,nil,47,nil,nil,0},
[922] = {'Silt Crawler',1829,1902,40,41,0,{[8]={{78.91,5.28},{80.36,7.38},{84.71,13.88},{75.99,5.19},{81.85,9.57},{89.1,18.29},{77.49,5.22},{80.47,93.89},{76.04,3.02},{78.68,8.0},{84.37,11.85},{73.66,5.34},{81.16,9.25},{82.68,12.63},{86.5,86.38},{85.63,82.53},{84.51,83.07},{88.05,78.3},{84.39,14.77},{83.03,15.49},{90.21,23.77},{88.02,20.5},{86.98,18.18},{83.23,84.65},{89.82,80.37}}},nil,8,nil,nil,7,"AH",nil,0},
[923] = {'Young Black Ravager',617,664,23,24,0,{[10]={{26.27,70.96},{27.63,74.34},{24.41,78.04},{28.33,62.84},{20.11,77.7},{43.5,77.37},{46.85,63.32},{24.85,64.01},{17.76,65.05},{47.82,73.9},{52.31,76.16},{18.23,71.99},{25.71,74.82},{28.44,65.44},{30.66,62.57},{26.72,67.59},{53.42,73.11},{49.97,69.14},{21.97,78.31},{37.47,65.45},{52.07,72.85},{47.75,70.27},{40.41,64.95},{54.06,74.12},{48.99,65.24},{32.47,62.42},{22.07,68.76},{42.93,70.82},{69.47,30.81},{55.5,65.75},{66.11,23.99},{69.34,30.09},{54.58,63.75},{67.2,28.05},{55.95,64.34},{56.45,62.1},{53.51,65.06},{51.19,64.09},{59.78,60.8},{60.98,59.26}}},nil,10,nil,nil,38,nil,nil,0},
[925] = {'Brother Sammuel',102,102,5,5,0,{[12]={{50.43,42.12}}},nil,12,nil,{3101},12,"A","Paladin Trainer",19},
[926] = {'Bromos Grummner',102,102,5,5,0,{[1]={{28.83,68.33}}},nil,1,nil,{3107},55,"A","Paladin Trainer",19},
[927] = {'Brother Wilhelm',222,222,11,11,0,{[12]={{41.1,66.04}}},nil,12,{2998},nil,12,"A","Paladin Trainer",19},
[928] = {'Lord Grayson Shadowbreaker',4120,4120,60,60,0,{[1519]={{37.16,33.32}}},nil,1519,{3000,7637,7640,7641,7643,7646,7647,7666,8415},{7638,7639,7640,7644,7646,7648,7666},12,"A","Paladin Trainer",19},
[929] = {'Dreadlord Malganis',4497,4497,63,63,3,nil,nil,0,nil,nil,14,nil,"Overfiend",0},
[930] = {'Black Widow Hatchling',664,713,24,25,0,{[10]={{26.39,47.0},{87.08,52.11},{27.42,47.28},{28.11,44.69},{85.49,51.73},{83.79,57.6},{35.02,32.35},{81.64,52.09},{82.15,53.35},{86.92,53.06},{85.96,52.09},{86.27,50.29},{80.69,62.77},{30.1,48.37},{29.63,46.6},{30.11,51.19},{29.6,49.39},{26.23,52.29},{26.73,52.04},{26.86,50.25},{29.48,53.49},{34.35,54.14},{37.3,59.5},{37.24,57.47},{30.81,36.04},{31.98,34.06},{32.82,36.01},{33.57,34.14},{30.86,32.5},{32.94,39.52},{31.56,42.44},{31.83,46.6},{33.82,49.71},{31.32,49.46},{32.57,48.22},{30.39,55.17},{35.59,54.7},{31.27,56.51},{32.42,54.75},{31.21,54.92},{32.82,51.72},{31.36,57.11},{34.91,45.96},{33.44,45.91},{31.93,34.27},{79.29,51.43},{80.39,54.13},{77.81,58.35},{27.69,40.79},{34.65,59.1},{35.14,58.2},{32.31,39.35},{35.72,55.84},{30.14,55.19},{30.11,51.41}}},nil,10,nil,nil,22,nil,nil,0},
[931] = {'Ariena Stormfeather',7842,7842,55,55,1,{[44]={{30.59,59.41}}},nil,44,nil,nil,12,"A","Gryphon Master",11},
[932] = {'Guard Ashlock',2440,2440,35,35,0,{[44]={{31.9,57.77}}},{[44]={{{31.9,57.77},{32.43,57.86},{32.52,56.49},{32.6,55.39},{32.68,53.92},{32.79,51.92},{32.87,50.39},{32.95,48.91},{33.07,48.16},{32.96,48.75},{32.87,50.28},{32.79,51.81},{32.69,53.79},{32.6,55.3},{32.11,56.9},{31.95,57.27}}}},44,nil,nil,11,"A",nil,0},
[933] = {'Guard Hiett',2440,2440,35,35,0,{[44]={{33.36,58.42}}},nil,44,nil,nil,11,"A",nil,0},
[934] = {'Guard Clarke',2554,2554,36,36,0,{[44]={{28.15,47.75}}},{[44]={{{28.98,47.88},{30.02,47.98},{31.09,48.04},{32.02,48.07},{32.37,48.37},{31.77,48.77},{31.0,48.94},{30.22,48.97},{29.72,49.05},{29.57,49.82},{29.47,50.86},{29.44,51.62},{29.35,52.49},{29.28,53.14},{29.35,52.49},{29.44,51.62},{29.47,50.86},{29.57,49.88},{29.72,49.05},{30.22,48.97},{31.0,48.94},{31.77,48.77},{32.37,48.37},{32.02,48.07},{31.09,48.04},{30.02,47.98},{28.98,47.88},{28.16,47.75}}}},44,nil,nil,11,"A",nil,0},
[935] = {'Guard Pearce',2440,2440,35,35,0,{[44]={{33.12,58.12}}},nil,44,nil,nil,11,"A",nil,0},
[936] = {'Guard Adams',2440,2440,35,35,0,{[44]={{27.49,46.33}}},{[44]={{{27.47,46.87},{26.03,46.9},{25.08,46.38},{24.33,46.17},{23.25,45.92},{23.13,45.54},{23.62,45.52},{23.87,44.59},{23.87,43.62},{24.12,42.41},{23.78,45.59},{24.33,46.33},{25.24,46.38},{25.79,45.39},{26.01,44.01},{26.15,42.3},{27.17,42.28},{27.79,44.04},{27.66,46.29},{27.48,46.32}}}},44,nil,nil,11,"A",nil,0},
[937] = {'Kurzen Jungle Fighter',1163,1221,32,33,0,{[33]={{44.51,10.0},{43.92,9.71},{43.7,9.55},{44.95,8.29},{45.03,8.36},{44.64,9.98},{44.85,8.61},{44.13,9.66},{43.57,9.73},{44.55,11.49},{46.16,12.6},{44.67,11.0},{45.3,11.27},{46.98,10.45},{46.07,11.27},{45.96,12.05}}},nil,33,nil,nil,46,nil,nil,0},
[938] = {'Kurzen Commando',1221,1342,33,35,0,{[33]={{44.15,7.91},{48.35,7.13},{44.37,7.97},{44.2,8.01},{45.96,8.66},{45.46,8.42},{44.56,8.5},{47.28,7.61},{46.7,7.06},{46.45,6.93},{45.93,7.9},{46.25,7.8},{46.34,7.43},{45.99,8.09},{45.73,8.1}}},nil,33,nil,nil,46,nil,nil,0},
[939] = {'Kurzen Elite',1469,1536,36,37,0,{[33]={{46.81,6.52},{47.88,6.4},{47.35,6.58},{47.68,6.87},{46.69,6.21},{47.88,6.86},{46.77,6.57},{49.27,7.51},{49.35,8.37},{49.33,7.86},{48.87,8.56},{49.57,7.73},{49.14,8.03},{48.4,8.65}}},nil,33,nil,nil,46,nil,nil,0},
[940] = {'Kurzen Medicine Man',977,1021,32,33,0,{[33]={{43.89,7.13},{44.72,11.43},{43.96,9.41},{44.51,9.92},{43.89,9.79},{43.7,9.53},{43.89,9.53},{44.45,9.79},{43.88,9.42},{44.86,11.39},{44.9,9.46},{46.58,9.52},{44.11,9.37},{44.07,8.74},{43.97,12.02},{44.0,11.31},{43.96,10.56},{44.76,11.16},{45.17,11.06},{45.15,10.98},{45.24,11.35},{46.51,11.28},{47.13,7.43}}},nil,33,nil,nil,46,nil,nil,0},
[941] = {'Kurzen Headshrinker',1064,1110,34,35,0,{[33]={{48.12,7.21},{48.41,7.33},{47.74,7.78},{48.11,8.39},{46.94,7.29},{46.33,6.96},{46.39,6.69},{46.43,7.87}}},nil,33,nil,nil,46,nil,nil,0},
[942] = {'Kurzen Witch Doctor',1208,1257,36,37,0,{[33]={{47.9,6.09},{47.64,6.63},{47.52,5.95},{47.54,5.55},{47.4,5.7},{46.88,5.92},{47.92,7.24},{49.35,7.15},{48.68,8.73},{49.53,8.32},{49.73,7.47},{47.85,7.02},{49.38,7.16}}},nil,33,nil,nil,46,nil,nil,0},
[943] = {'Kurzen Wrangler',1064,1064,34,34,0,{[33]={{45.75,10.38},{45.82,9.44},{45.81,9.68},{45.84,9.93}}},nil,33,nil,nil,46,nil,nil,0},
[944] = {'Marryk Nurribit',102,102,5,5,0,{[1]={{28.71,66.37}}},nil,1,nil,{3114},875,"A","Mage Trainer",19},
[945] = {'Rybrad Coldbank',102,102,5,5,0,{[1]={{28.66,67.74}}},nil,1,nil,nil,55,"A","Weaponsmith",16388},
[946] = {'Frostmane Novice',69,83,3,4,0,{[1]={{28.99,82.57},{28.69,83.14},{29.05,81.17},{29.38,81.06},{30.1,82.38},{30.41,80.87},{30.23,80.27},{30.48,79.54},{66.49,40.88},{66.49,40.88}}},nil,1,nil,nil,107,nil,nil,0},
[947] = {'Rohh the Silent',788,788,26,26,4,{[44]={{75.47,39.59},{83.93,59.33},{83.85,57.52},{82.45,56.21},{81.29,55.68},{82.68,53.91},{84.25,51.01},{78.81,40.75},{78.69,35.54},{76.45,37.75},{73.89,35.5},{75.8,29.71},{76.07,47.29}}},nil,44,nil,nil,39,nil,nil,0},
[948] = {'Rotted One',734,788,25,26,0,{[10]={{21.53,35.95},{25.64,33.53},{21.85,34.09},{24.03,37.96},{21.6,37.54},{24.78,34.36},{25.43,37.86}}},nil,10,nil,nil,21,nil,nil,0},
[949] = {'Carrion Recluse',734,788,25,26,0,{[10]={{21.47,46.26},{21.04,39.11},{18.92,42.11},{16.96,39.6},{18.14,43.68},{23.42,36.7}}},nil,10,nil,nil,22,nil,nil,0},
[950] = {'Swamp Talker',2880,2880,50,50,0,{[8]={{62.6,88.07}}},nil,8,nil,nil,18,nil,nil,0},
[951] = {'Brother Paxton',840,840,27,27,0,{[12]={{49.61,40.41}}},nil,12,{345,346},{344,347},12,"A","Librarian",2},
[952] = {'Brother Neals',2768,2768,50,50,0,{[12]={{49.47,41.59}}},nil,12,nil,{3905},12,"A",nil,2},
[953] = {'Spawn Test One',328,328,15,15,0,nil,nil,0,nil,nil,58,nil,"TEST MOB",0},
[954] = {'Kat Sampson',386,386,17,17,0,{[38]={{82.65,64.11}}},nil,38,nil,nil,55,"A","Leather Armor Merchant",16388},
[955] = {'Sergeant De Vries',198,198,10,10,0,{[12]={{24.08,73.2}}},nil,12,nil,nil,12,"A","Morale Officer",4},
[956] = {'Dorin Songblade',573,573,22,22,0,{[44]={{30.88,46.44}}},nil,44,nil,nil,12,"A","Armorer",16388},
[957] = {'Dane Lindgren',1002,1002,30,30,0,{[1519]={{57.44,16.27}}},nil,1519,nil,nil,12,"A","Journeyman Blacksmith",17},
[958] = {'Dawn Brightstar',1342,1342,35,35,0,{[12]={{64.88,69.19}}},nil,12,nil,nil,12,"A","Arcane Goods",4},
[959] = {'Morley Eberlein',156,156,8,8,0,{[12]={{64.69,69.51}}},nil,12,nil,nil,12,"A","Clothier",16388},
[960] = {'Gunder Thornbush',1002,1002,30,30,0,{[10]={{73.8,45.1}}},nil,10,nil,nil,12,"A","Tradesman",4},
[963] = {'Deputy Rainer',198,198,10,10,0,{[12]={{24.23,74.45}}},nil,12,{11,109},{11,239},12,"A",nil,3},
[976] = {'Kurzen War Tiger',1163,1221,32,33,0,{[33]={{45.86,9.58},{45.88,9.97}}},nil,33,nil,nil,46,nil,nil,0},
[977] = {'Kurzen War Panther',1163,1221,32,33,0,{[33]={{45.75,9.66},{45.75,9.43}}},nil,33,nil,nil,46,nil,nil,0},
[978] = {'Kurzen Subchief',1160,1207,35,36,0,{[33]={{49.66,6.02},{49.28,3.94},{49.3,4.1},{48.8,4.55},{49.65,3.84},{49.56,4.09},{49.91,4.04},{48.95,5.87},{48.71,5.37},{49.13,5.73},{48.72,5.81},{49.17,6.34},{49.43,6.16},{49.35,6.77}}},nil,33,nil,nil,46,nil,nil,0},
[979] = {'Kurzen Shadow Hunter',1468,1604,36,38,0,{[33]={{49.65,5.76},{49.95,3.68},{49.26,4.05},{48.58,5.55},{48.74,4.95}}},nil,33,nil,nil,46,nil,nil,0},
[980] = {'Grimnal',2217,2217,45,45,0,{[8]={{45.08,50.43}}},nil,8,nil,nil,29,"H","Mail & Plate Merchant",16388},
[981] = {'Hartash',2217,2217,45,45,0,{[8]={{45.67,50.92}}},nil,8,nil,nil,29,"H","Weapon Merchant",16388},
[982] = {'Thultash',2217,2217,45,45,0,{[8]={{46.53,54.29}}},nil,8,nil,nil,29,"H","Food & Drink Vendor",4},
[983] = {'Thultazor',2217,2217,45,45,0,{[8]={{45.78,52.82}}},nil,8,nil,nil,29,"H","Arcane Goods Vendor",4},
[984] = {'Thralosh',2217,2217,45,45,0,{[8]={{45.06,51.4}}},nil,8,nil,nil,29,"H","Cloth & Leather Armor Merchant",16388},
[985] = {'Malosh',2768,2768,50,50,0,{[8]={{44.89,57.62}}},nil,8,nil,nil,29,"H","Warrior Trainer",17},
[986] = {'Haromm',2768,2768,50,50,0,{[8]={{48.19,57.94}}},nil,8,{8410},nil,29,"H","Shaman Trainer",19},
[987] = {'Ogromm',2768,2768,50,50,0,{[8]={{47.26,53.43}}},nil,8,nil,nil,29,"H","Hunter Trainer",17},
[988] = {'Kartosh',2768,2768,50,50,0,{[8]={{48.65,55.64}}},nil,8,{8419},nil,29,"H","Warlock Trainer",19},
[989] = {'Banalash',2768,2768,50,50,0,{[8]={{44.77,56.63}}},nil,8,nil,nil,29,"H","Trade Goods",4},
[994] = {'Nahr\'ek da Howler',102,102,5,5,0,nil,nil,0,nil,nil,37,nil,nil,0},
[995] = {'Nahr\'ek\'s Pack',71,86,3,4,0,nil,nil,0,nil,nil,37,nil,nil,0},
[996] = {'Master Tailor',4370,4370,62,62,0,nil,nil,0,nil,nil,12,"A","Cheesy Test Tailor",0},
[999] = {'Watcher Royce',1403,1403,35,35,0,{[10]={{79.47,46.16}}},nil,10,nil,nil,11,"A","The Night Watch",0},
[1000] = {'Watcher Blomberg',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1001] = {'Watcher Hutchins',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1007] = {'Mosshide Gnoll',494,531,20,21,0,{[11]={{60.33,73.77},{62.63,74.97},{60.51,63.71},{63.91,63.8},{61.21,73.1},{61.78,73.08},{62.58,72.74},{62.13,72.0},{61.89,71.88},{55.55,75.18},{55.69,75.37},{56.06,74.6},{55.93,75.93},{55.48,75.0},{56.73,75.04},{55.91,75.23},{63.17,69.09},{55.17,75.39},{55.43,74.09},{61.23,72.24},{62.7,69.1},{62.55,69.85},{62.38,68.99},{62.9,69.81},{61.56,66.77},{60.29,71.44},{54.37,73.73},{66.67,70.09},{64.22,64.06},{64.25,63.4},{64.12,62.47},{63.78,62.42}}},nil,11,nil,nil,61,nil,nil,0},
[1008] = {'Mosshide Mongrel',531,573,21,22,0,{[11]={{59.53,72.67},{60.95,75.13},{64.05,63.68},{63.81,63.64},{61.68,72.15},{61.64,72.34},{61.84,72.23},{61.54,72.67},{61.77,72.53},{61.85,72.44},{55.74,74.78},{62.78,69.33},{62.54,69.49},{62.8,68.39},{62.82,69.61},{62.12,69.82},{62.6,69.63},{61.27,67.88},{61.53,59.13},{60.74,64.31},{61.72,61.45},{60.49,59.36},{61.28,57.88},{60.62,58.55},{61.08,57.08},{63.93,63.17},{63.79,63.21},{63.96,63.38},{63.54,59.88},{61.86,57.98},{63.64,60.52},{61.2,55.57},{65.43,64.85},{64.99,60.64}}},nil,11,nil,nil,61,nil,nil,0},
[1009] = {'Mosshide Mistweaver',472,504,22,23,0,{[11]={{61.27,58.42},{61.13,58.65},{62.68,69.3},{61.2,58.26},{45.16,31.89},{45.59,34.45},{38.98,34.05}}},nil,11,nil,nil,61,nil,nil,0},
[1010] = {'Mosshide Fenrunner',573,617,22,23,0,{[11]={{61.13,58.23},{34.56,34.42},{51.23,30.82},{35.43,31.55},{52.77,27.67},{51.5,30.79},{61.03,58.64},{43.68,34.73},{45.7,35.38},{45.65,31.71},{45.28,34.15},{39.41,33.96},{45.91,34.7},{43.74,34.07},{44.01,34.93},{38.7,34.39},{52.47,28.2},{53.2,27.16},{39.66,34.7},{44.67,31.67},{45.34,32.49},{43.63,35.28},{26.47,37.18},{53.12,28.0},{52.18,27.19},{45.57,34.8},{43.24,34.17},{45.23,35.02},{43.18,34.7},{38.83,34.04},{61.35,58.59},{61.04,58.44},{65.13,55.11},{40.04,32.04},{32.34,35.77},{64.9,56.45},{63.47,58.41},{64.5,56.87},{64.46,55.48},{59.62,58.18},{60.67,54.3},{59.62,55.59},{62.74,57.05}}},nil,11,nil,nil,61,nil,nil,0},
[1011] = {'Mosshide Trapper',617,664,23,24,0,{[11]={{26.68,35.44},{32.49,31.16},{33.33,33.1},{31.82,32.58},{31.62,33.27},{31.01,32.29},{32.2,33.64},{28.02,34.91},{51.09,30.88},{32.8,28.85},{52.85,27.41},{51.54,30.95},{28.55,37.52},{43.56,34.58},{42.83,32.34},{33.12,35.07},{43.06,32.88},{42.57,31.85},{40.97,30.76},{36.16,34.66},{42.72,32.64},{40.92,34.03},{44.0,34.55},{39.37,34.39},{45.05,31.78},{42.99,32.0},{29.51,35.16},{29.91,37.24}}},nil,11,nil,nil,61,nil,nil,0},
[1012] = {'Mosshide Brute',664,713,24,25,0,{[11]={{35.4,27.55},{35.23,27.09},{34.81,27.57},{39.46,27.41},{40.1,26.49},{40.51,27.81},{40.75,27.01},{39.91,27.49},{31.01,29.13},{30.81,33.12},{31.35,28.75},{31.11,30.23},{31.91,30.08},{31.55,29.85},{32.03,29.46},{28.3,29.52},{37.01,30.2},{28.59,29.8},{38.68,30.4},{38.73,29.59},{38.28,28.6},{38.33,30.54},{35.01,29.85},{37.13,29.22},{42.95,32.37},{42.55,32.1},{29.31,32.35}}},nil,11,nil,nil,61,nil,nil,0},
[1013] = {'Mosshide Mystic',640,684,25,26,0,{[11]={{35.09,27.56},{37.66,29.8},{37.89,29.86},{40.19,27.46},{31.36,32.75},{31.31,33.02},{31.36,29.67}}},nil,11,nil,nil,61,nil,nil,0},
[1014] = {'Mosshide Alpha',840,840,27,27,0,{[11]={{35.03,27.36},{37.75,29.47},{40.06,27.29},{31.28,32.72},{31.44,29.54}}},nil,11,nil,nil,61,nil,nil,0},
[1015] = {'Highland Raptor',617,664,23,24,0,{[11]={{56.18,28.74},{55.72,29.99},{57.03,37.06},{53.11,30.38},{55.58,26.13},{56.79,28.7},{39.96,24.53},{49.92,27.58},{57.48,33.49},{52.41,25.45},{52.46,23.36},{55.52,24.69},{54.38,23.24},{51.41,28.94},{41.63,24.13},{54.82,27.7},{54.7,25.7},{38.54,24.11},{40.08,21.89},{41.66,21.81},{40.96,23.16},{57.85,37.65}}},nil,11,nil,nil,48,nil,nil,0},
[1016] = {'Highland Lashtail',664,713,24,25,0,{[11]={{61.36,22.14},{61.73,23.14},{56.31,27.28},{39.0,23.59},{38.53,23.15},{57.81,35.44},{57.33,25.38},{56.24,22.55},{57.4,23.44},{39.62,20.98},{30.16,21.64},{30.59,20.73},{35.58,25.0},{30.27,21.15},{30.66,20.35},{30.12,20.77},{32.19,19.53},{59.53,30.33}}},nil,11,nil,nil,48,nil,nil,0},
[1017] = {'Highland Scytheclaw',734,788,25,26,0,{[11]={{58.74,21.52},{58.94,21.18},{59.58,21.33},{56.88,27.62},{31.22,16.16},{37.56,23.45},{37.33,22.79},{37.87,22.83},{37.69,22.4},{58.18,26.79},{57.48,27.66},{56.36,31.43},{38.22,19.57},{36.58,22.54},{37.44,20.16},{37.58,19.37},{30.38,16.8},{33.01,18.14},{35.37,21.9},{34.53,20.66}}},nil,11,nil,nil,48,nil,nil,0},
[1018] = {'Highland Razormaw',840,896,27,28,0,{[11]={{70.65,29.21},{67.29,36.28},{67.17,37.98},{68.1,32.93},{69.35,32.07},{67.33,29.53},{67.07,30.88},{67.35,28.62},{69.06,28.83},{68.74,27.81},{69.68,30.37},{68.41,33.13},{70.3,29.99},{67.84,30.74},{32.15,14.62},{65.79,31.3},{66.37,32.79},{68.0,35.8},{65.32,30.15},{70.17,37.86},{66.83,32.87},{66.53,31.9},{65.93,28.61},{65.13,28.68},{71.75,39.08},{72.02,39.88},{69.77,37.36},{68.02,36.3},{69.3,35.07},{69.61,33.49},{69.47,34.36},{69.98,38.72},{32.68,15.31},{35.17,20.42},{33.63,17.02},{35.4,18.75},{35.5,19.55}}},nil,11,nil,nil,48,nil,nil,0},
[1019] = {'Elder Razormaw',950,950,29,29,0,{[11]={{69.06,31.62},{40.1,18.36},{67.58,31.59},{67.94,27.54},{69.67,29.12},{69.3,29.79},{69.09,28.25},{70.2,28.37},{68.68,31.29},{69.89,32.03},{70.7,30.82},{67.88,32.39},{39.69,17.08},{38.55,16.94},{38.06,15.69},{33.69,14.94},{69.89,32.76},{70.22,31.83},{69.3,32.9},{38.17,15.9},{33.03,13.01},{33.95,12.44}}},nil,11,nil,nil,48,nil,nil,0},
[1020] = {'Mottled Raptor',573,617,22,23,0,{[11]={{23.02,59.84},{22.51,58.96},{24.31,46.31},{23.89,47.15},{24.16,48.27},{23.35,51.17},{22.96,50.09},{24.11,50.43},{22.19,53.49},{21.37,51.91},{25.22,49.77},{23.06,59.56},{23.24,54.11},{29.48,46.49},{19.77,52.47},{31.51,42.1},{27.21,46.76},{26.38,46.34},{28.85,42.41},{26.0,47.47},{29.67,46.16},{20.72,48.8},{27.18,43.48},{29.46,42.39},{37.07,42.24},{28.06,42.81},{24.57,46.77}}},nil,11,nil,nil,48,nil,nil,0},
[1021] = {'Mottled Screecher',664,713,24,25,0,{[11]={{24.11,53.03},{23.92,52.37},{24.22,52.53},{22.77,50.71},{23.45,56.02},{30.2,44.06},{23.04,55.55},{22.97,56.49},{29.87,44.44},{29.76,45.21},{23.65,60.45},{25.8,48.85},{26.19,49.15},{26.13,48.57},{29.38,45.37},{22.62,55.86}}},nil,11,nil,nil,48,nil,nil,0},
[1022] = {'Mottled Scytheclaw',734,788,25,26,0,{[11]={{31.84,46.9},{30.58,48.73},{32.82,51.02},{35.7,44.07},{33.61,44.62},{31.32,48.49},{35.9,49.44},{34.43,43.67},{35.14,50.84},{35.3,49.49},{34.45,45.76},{35.62,51.85},{34.44,50.91},{36.05,48.37}}},nil,11,nil,nil,48,nil,nil,0},
[1023] = {'Mottled Razormaw',788,840,26,27,0,{[11]={{33.85,48.27},{35.18,46.26},{34.68,47.09},{33.31,46.95},{34.33,49.55},{33.62,46.19},{32.87,48.26},{33.71,49.84},{32.21,48.69}}},nil,11,nil,nil,48,nil,nil,0},
[1024] = {'Bluegill Murloc',494,531,20,21,0,{[11]={{12.21,39.06},{10.94,39.86},{19.06,38.64},{11.87,41.21},{12.7,42.32},{12.51,39.78},{17.78,40.85},{13.99,40.73},{13.51,42.05},{13.24,41.15},{13.49,39.91},{18.48,38.3},{16.94,39.92},{18.62,40.27},{14.21,41.25},{15.26,39.83},{14.89,39.57},{15.31,38.95},{15.06,38.72},{15.43,38.63},{15.61,38.93},{15.75,40.79},{20.69,41.15},{18.95,41.1},{19.82,40.05}}},nil,11,nil,nil,18,nil,nil,0},
[1025] = {'Bluegill Puddlejumper',531,573,21,22,0,{[11]={{12.1,36.22},{10.29,38.63},{10.12,36.25},{11.17,37.56},{11.04,35.2},{13.62,41.18},{13.51,34.06},{18.55,39.09},{18.02,39.77},{18.41,39.5},{13.28,38.18},{15.2,38.45},{13.53,37.93},{13.73,38.37},{15.18,33.94},{13.58,36.61},{14.38,35.29},{12.84,34.96},{12.68,37.02}}},nil,11,nil,nil,18,nil,nil,0},
[1026] = {'Bluegill Forager',573,617,22,23,0,{[11]={{25.03,38.46},{25.49,40.01},{22.29,41.03},{13.51,38.34},{14.54,35.45}}},nil,11,nil,nil,18,nil,nil,0},
[1027] = {'Bluegill Warrior',664,713,24,25,0,{[11]={{14.26,20.91},{16.99,21.69},{15.6,20.82},{12.81,22.98},{13.76,22.29},{12.45,25.36},{11.65,28.59},{17.67,20.71},{21.52,36.52},{12.58,27.55},{13.58,26.95},{16.53,30.35},{16.35,30.03},{16.2,30.76},{13.49,34.49},{19.15,32.82},{13.9,35.09},{14.01,32.8}}},nil,11,nil,nil,18,nil,nil,0},
[1028] = {'Bluegill Muckdweller',504,539,23,24,0,{[11]={{13.1,32.77},{11.07,32.69},{11.25,30.5},{11.96,31.55},{10.43,33.65},{11.89,33.75},{21.9,37.72},{20.13,36.27},{24.85,37.32},{23.3,39.79},{22.31,38.98},{16.61,31.56},{20.82,35.36},{16.25,35.95},{16.45,36.18},{22.56,35.54},{23.06,37.35},{24.37,36.37},{21.55,33.79},{15.18,31.56},{16.0,36.34},{16.25,36.42},{20.81,37.85}}},nil,11,nil,nil,18,nil,nil,0},
[1029] = {'Bluegill Oracle',640,684,25,26,0,{[11]={{16.55,30.73},{16.07,30.45}}},nil,11,nil,nil,18,nil,nil,0},
[1030] = {'Black Slime',494,531,20,21,0,{[11]={{61.76,78.98},{61.8,78.53},{66.42,61.25},{53.34,50.36},{54.94,54.67},{55.26,72.96},{56.71,79.08},{61.57,65.39},{60.61,77.47},{54.04,72.43},{57.71,73.89},{57.21,65.88},{54.64,66.57},{59.12,70.84},{59.79,65.62},{66.22,61.4},{56.27,66.69},{56.72,73.36},{59.44,69.2},{59.12,73.22},{65.4,58.5},{55.36,63.09},{65.37,61.57},{54.37,78.57}}},nil,11,nil,nil,14,nil,nil,0},
[1031] = {'Crimson Ooze',664,713,24,25,0,{[11]={{44.31,24.7},{44.58,24.19},{44.23,25.43},{44.63,24.76},{44.75,24.26},{44.0,24.18},{44.73,25.38},{43.81,25.23}}},nil,11,nil,nil,14,nil,nil,0},
[1032] = {'Black Ooze',617,664,23,24,0,{[11]={{58.89,28.89},{65.55,51.6},{64.19,49.65},{22.93,59.48},{56.01,25.13},{56.79,29.48},{56.78,33.74},{56.98,31.17},{47.45,25.44},{46.42,24.78},{44.05,27.79},{61.88,37.46},{59.55,40.13},{57.08,44.49},{63.66,44.57},{64.96,46.1},{44.82,25.48},{44.15,25.63},{43.2,29.18},{43.33,27.95},{58.77,44.85},{61.74,44.27},{48.14,24.6},{44.93,24.37},{23.92,48.4},{43.53,24.6},{42.87,26.35},{43.7,26.71},{44.42,24.36},{43.51,25.53},{21.31,52.16},{28.25,45.7},{47.44,27.67},{44.97,26.51},{46.67,26.61},{44.21,26.53}}},nil,11,nil,nil,14,nil,nil,0},
[1033] = {'Monstrous Ooze',734,788,25,26,0,{[11]={{69.01,52.58},{70.17,51.14},{44.78,24.8},{44.5,24.91},{44.58,24.52},{62.55,35.13},{69.86,47.25},{67.08,42.93},{66.67,46.28},{67.87,46.66},{69.91,43.52},{64.87,36.91},{65.24,42.08},{43.86,25.48},{43.85,24.27},{44.03,24.68},{43.8,24.14},{43.98,25.25}}},nil,11,nil,nil,14,nil,nil,0},
[1034] = {'Dragonmaw Raider',787,840,26,27,0,{[11]={{45.83,45.42},{46.16,45.96},{46.1,45.61},{45.34,42.53},{46.61,46.55},{46.55,46.35},{46.32,46.44},{45.42,43.0},{45.11,42.6},{46.06,42.01},{47.02,48.35},{47.67,48.1},{47.37,47.33},{46.28,45.19},{47.42,47.26},{47.35,46.96},{46.26,43.26},{52.14,44.84},{50.49,48.24},{52.28,45.98},{51.17,46.24},{49.86,48.41},{51.12,47.34},{48.9,48.55},{46.79,45.31},{48.43,47.6},{39.47,46.97},{40.21,46.72},{45.34,43.49},{45.17,46.51},{44.63,46.37},{45.5,47.49},{41.0,39.96},{41.87,40.63},{42.37,43.47},{41.57,45.58},{40.99,45.47},{42.16,44.58},{41.01,46.43},{44.91,42.96},{42.42,42.65},{44.84,42.04},{42.53,39.93},{43.69,42.85},{44.12,43.1},{43.23,40.92},{44.1,43.58},{44.61,43.78},{43.7,43.46},{44.29,44.68},{44.8,45.35},{45.77,45.14},{44.93,44.7},{46.2,44.22},{47.68,44.94},{47.76,46.29},{47.14,46.14}}},nil,11,nil,nil,62,nil,nil,0},
[1035] = {'Dragonmaw Swamprunner',840,895,27,28,0,{[11]={{45.81,45.77},{50.11,46.72},{45.87,46.94},{45.39,42.87},{53.52,54.19},{47.91,48.62},{38.23,45.85},{38.52,46.27},{49.84,44.73},{50.38,44.47},{50.71,49.55}}},nil,11,nil,nil,62,nil,nil,0},
[1036] = {'Dragonmaw Centurion',896,950,28,29,0,{[11]={{49.5,46.13},{49.41,46.21},{53.43,54.12},{53.72,54.61},{52.52,53.61},{53.25,54.08}}},nil,11,nil,nil,62,nil,nil,0},
[1037] = {'Dragonmaw Battlemaster',1002,1002,30,30,4,{[11]={{45.34,44.41}}},nil,11,nil,nil,62,nil,nil,0},
[1038] = {'Dragonmaw Shadowwarder',702,739,28,29,0,{[11]={{49.63,46.43},{53.7,54.36},{53.95,54.41},{53.09,53.2},{52.54,53.88},{52.95,55.33}}},nil,11,nil,nil,62,nil,nil,0},
[1039] = {'Fen Dweller',494,531,20,21,0,{[11]={{62.37,59.48},{63.76,65.38},{60.17,50.76},{60.88,70.0},{17.15,41.98},{21.07,45.26},{29.45,28.1},{19.72,48.37},{22.75,45.11},{20.48,42.08},{60.1,61.81},{17.94,46.72},{32.02,27.33},{31.34,22.23},{16.61,41.36},{60.02,56.78},{16.07,47.69}}},nil,11,nil,nil,14,nil,nil,0},
[1040] = {'Fen Creeper',664,713,24,25,0,{[11]={{27.38,37.12},{33.01,25.67},{25.33,35.52},{46.41,29.19},{18.52,27.74},{23.58,32.0},{22.47,30.0},{25.85,31.87},{47.59,32.79},{27.15,39.15},{53.19,36.5},{54.98,37.16},{55.03,46.43},{54.0,41.37},{35.56,33.45},{40.64,32.92},{37.41,33.39},{20.79,28.35},{28.88,20.45}}},nil,11,nil,nil,14,nil,nil,0},
[1041] = {'Fen Lord',734,788,25,26,0,{[11]={{29.63,28.19},{32.25,26.74},{31.22,22.27}}},nil,11,nil,nil,14,nil,nil,0},
[1042] = {'Red Whelp',617,664,23,24,0,{[11]={{63.43,48.8},{63.65,50.85},{59.51,39.19},{64.31,52.0},{65.83,53.36},{62.72,51.64},{63.47,48.74},{66.74,54.24},{61.96,46.65},{60.37,40.47},{59.6,44.11},{59.76,40.89},{59.65,45.84}}},nil,11,nil,nil,60,nil,nil,0},
[1043] = {'Lost Whelp',582,622,24,25,0,{[11]={{66.5,48.51},{67.09,51.91},{64.21,47.56},{69.06,51.38},{68.08,50.69},{64.75,48.7},{65.12,49.49},{66.91,49.26},{65.91,51.16},{63.75,47.53},{67.45,52.47},{61.03,40.5},{61.79,40.1},{61.94,41.62},{62.4,44.22},{62.56,37.35},{59.54,32.7},{61.27,38.26},{62.23,45.79},{61.03,36.79},{60.87,44.31}}},nil,11,nil,nil,60,nil,nil,0},
[1044] = {'Flamesnorting Whelp',684,724,26,27,0,{[11]={{70.81,48.54},{70.36,45.01},{63.43,36.52},{64.16,37.9},{66.55,41.5},{71.6,47.43},{67.61,43.13},{66.57,42.86},{64.15,31.75},{64.26,39.68}}},nil,11,nil,nil,60,nil,nil,0},
[1045] = {'Red Dragonspawn',8352,8613,57,58,1,{[11]={{79.54,48.35},{78.75,47.32}}},nil,11,nil,nil,60,nil,nil,0},
[1046] = {'Red Wyrmkin',6891,7107,58,59,1,{[11]={{78.95,44.43},{77.93,46.27},{82.14,49.49}}},nil,11,nil,nil,60,nil,nil,0},
[1047] = {'Red Scalebane',8883,9156,59,60,1,{[11]={{85.5,49.98},{85.19,51.63},{85.89,50.65},{81.96,47.06},{81.14,48.48},{84.73,51.1},{83.69,49.53},{82.96,48.48}}},nil,11,nil,nil,60,nil,nil,0},
[1048] = {'Scalebane Lieutenant',9156,9432,60,61,1,{[11]={{88.52,62.93},{89.36,64.29},{86.94,52.51},{87.66,61.53},{86.22,53.09},{87.06,51.34},{87.65,64.04}}},nil,11,nil,nil,60,nil,nil,0},
[1049] = {'Wyrmkin Firebrand',7545,7770,61,62,1,{[11]={{86.96,53.5},{87.67,52.07},{89.18,56.76},{87.2,58.0},{88.41,60.44},{87.66,59.31},{88.77,58.23},{87.16,55.57},{88.33,56.21},{89.42,59.49},{87.6,56.56}}},nil,11,nil,nil,60,nil,nil,0},
[1050] = {'Scalebane Royal Guard',9432,9711,61,62,1,{[11]={{86.63,69.51},{82.82,71.36},{85.41,67.82},{86.34,66.3},{87.65,66.32},{84.36,69.06},{86.07,70.5},{83.64,71.39},{82.02,69.25},{82.84,69.2},{87.12,65.43},{83.52,69.39},{86.98,66.95},{87.44,65.74},{84.57,71.11},{84.98,69.07},{82.01,71.38}}},nil,11,nil,nil,60,nil,nil,0},
[1051] = {'Dark Iron Dwarf',2400,2559,27,28,1,{[11]={{59.93,23.02},{48.05,17.3},{48.17,17.67},{48.87,17.44},{47.59,16.97},{47.19,15.69},{48.01,16.61},{48.47,16.19},{62.35,29.56},{63.02,29.57},{62.01,28.66},{49.03,17.11},{60.45,24.86},{59.81,25.32},{60.27,23.61},{59.49,23.77}}},nil,11,nil,nil,54,nil,nil,0},
[1052] = {'Dark Iron Saboteur',2559,2715,28,29,1,{[11]={{59.93,24.46},{61.88,25.98},{61.96,26.58},{62.05,27.57},{62.93,27.43},{63.27,28.78},{48.1,18.09},{48.12,18.62},{48.11,15.66},{47.06,17.1},{48.1,15.17},{47.67,16.13},{46.44,16.18},{46.74,17.21},{46.81,16.44},{50.85,8.24},{50.93,8.0}}},nil,11,nil,nil,54,nil,nil,0},
[1053] = {'Dark Iron Tunneler',2715,2865,29,30,1,{[11]={{60.27,24.3},{59.98,24.14},{60.11,24.64},{62.48,25.83},{61.53,26.17},{59.84,24.62},{61.95,25.44},{61.56,27.25},{47.98,18.85},{46.79,17.89},{47.03,18.45},{48.2,14.97},{47.55,15.46},{47.46,15.13},{46.08,16.6},{45.95,16.85},{45.65,16.85},{45.94,16.29},{46.26,16.59},{47.08,17.48},{47.11,17.92},{45.68,16.19},{46.88,18.1}}},nil,11,nil,nil,54,nil,nil,0},
[1054] = {'Dark Iron Demolitionist',2865,3018,30,31,1,{[11]={{60.1,24.36},{62.0,26.08},{62.11,26.31},{61.83,26.57},{62.51,28.99},{62.18,28.01},{46.69,18.63},{46.57,18.63},{46.5,18.74},{47.39,14.99},{47.57,14.73}}},nil,11,nil,nil,54,nil,nil,0},
[1055] = {'Dreamhunter',1990,1990,47,47,0,nil,nil,0,nil,nil,50,nil,nil,0},
[1056] = {'Emerald Sentinel',2218,2218,45,45,0,nil,nil,0,nil,nil,50,nil,nil,0},
[1057] = {'Dragonmaw Bonewarder',664,664,27,27,0,{[11]={{45.48,45.39},{45.99,45.81},{46.17,47.05},{46.57,47.17},{45.66,43.32},{45.62,42.48},{49.44,46.88},{47.78,47.43},{47.6,46.95},{49.85,45.68},{51.55,48.4},{49.87,47.83},{50.52,50.83},{51.4,50.81},{51.83,49.5},{48.92,46.83},{49.8,50.99},{48.64,46.04},{49.28,47.47},{49.12,45.19}}},nil,11,nil,nil,62,nil,nil,0},
[1059] = {'Ana\'thek the Cruel',2218,2218,45,45,0,{[33]={{44.3,45.0}}},nil,33,nil,nil,30,nil,"Skullsplitter Chief",0},
[1060] = {'Mogh the Undying',4278,4278,44,44,1,{[33]={{47.74,44.25}}},nil,33,nil,nil,30,nil,"Skullsplitter Clan Witchdoctor",0},
[1061] = {'Gan\'zulah',1902,1902,41,41,0,{[33]={{23.44,8.12}}},nil,33,nil,nil,28,nil,"Bloodscalp Chief",0},
[1062] = {'Nezzliok the Dire',1410,1410,40,40,0,{[33]={{23.52,9.53}}},nil,33,nil,nil,28,nil,"Bloodscalp Clan Witchdoctor",0},
[1063] = {'Jade',6467,6467,47,47,2,nil,nil,0,nil,nil,50,nil,nil,0},
[1064] = {'Grom\'gol Grunt',5228,5228,55,55,0,{[33]={{32.75,28.36},{32.74,28.83},{32.03,27.4},{31.75,27.76},{32.73,28.69},{32.12,27.39},{31.24,28.56},{31.13,28.35},{31.81,27.36},{32.5,28.58},{31.29,28.17},{31.13,28.54},{32.09,28.58},{31.99,28.3},{31.91,28.33}}},nil,33,nil,nil,85,"H",nil,0},
[1065] = {'Riverpaw Shaman',253,253,13,13,0,{[40]={{41.65,20.79}}},nil,40,nil,nil,20,nil,nil,0},
[1066] = {'Mottled Riptooth',896,896,28,28,0,nil,nil,0,nil,nil,48,nil,"UNUSED",0},
[1067] = {'Riverpaw Scavenger',156,156,8,8,0,nil,nil,0,nil,nil,20,nil,nil,0},
[1068] = {'Gorn',1752,1752,40,40,0,{[3]={{2.91,45.6}}},nil,3,{782,793},{782,793},29,"H",nil,2},
[1069] = {'Crimson Whelp',640,683,25,26,0,{[11]={{63.67,35.32},{67.85,48.26},{67.7,45.03},{69.9,49.98},{63.64,42.06},{69.87,45.82},{62.96,37.39},{68.47,48.82},{68.84,51.0},{62.07,41.14},{63.69,40.2},{61.3,33.87},{61.99,33.13},{66.57,44.44},{65.99,45.94},{64.2,41.47},{65.95,44.51},{64.62,44.24},{62.04,34.76},{65.15,43.48},{62.89,36.48},{62.8,34.07},{68.09,46.28},{64.29,43.12},{64.61,42.2},{69.1,48.4}}},nil,11,nil,nil,60,nil,nil,0},
[1070] = {'Deputy Feldon',1221,1221,33,33,0,{[44]={{30.73,60.0}}},nil,44,{246},{244,246},11,"A",nil,2},
[1071] = {'Longbraid the Grim',1342,1342,35,35,0,{[11]={{49.8,18.26}}},nil,11,{304},{304,472},55,"A",nil,2},
[1072] = {'Roggo Harlbarrow',1002,1002,30,30,0,{[11]={{49.85,18.09}}},nil,11,nil,nil,55,"A",nil,2},
[1073] = {'Ashlan Stonesmirk',840,840,27,27,0,{[11]={{50.05,18.17}}},nil,11,{274},{161},55,"A",nil,2},
[1074] = {'Motley Garmason',1002,1002,30,30,0,{[11]={{49.67,18.23}}},nil,11,{303,378},{303,378},55,"A",nil,2},
[1075] = {'Rhag Garmason',712,712,25,25,0,{[11]={{49.9,18.24}}},nil,11,{631,633,634},{632,633},55,"A",nil,2},
[1076] = {'Merrin Rockweaver',1002,1002,30,30,0,{[11]={{38.91,52.34}}},nil,11,{306},{305},55,"A","Explorers' League",2},
[1077] = {'Prospector Whelgar',1002,1002,30,30,0,{[11]={{38.81,52.39}}},nil,11,{299},{299},55,"A","Explorers' League",2},
[1078] = {'Ormer Ironbraid',712,712,25,25,0,{[11]={{38.18,50.89}}},nil,11,{294,295,296},{294,295,296},55,"A",nil,2},
[1081] = {'Mire Lord',2476,2476,42,42,0,{[8]={{5.5,31.38}}},nil,8,nil,nil,14,nil,nil,0},
[1082] = {'Sawtooth Crocolisk',1604,1678,38,39,0,{[8]={{53.6,55.99},{56.07,56.47},{71.96,19.83},{69.84,18.63},{69.63,15.22},{72.15,15.27},{53.64,55.65},{56.12,56.77},{63.34,31.95},{62.29,30.27},{59.58,35.06},{60.49,32.19},{55.05,49.57},{56.56,48.02},{57.69,46.09},{56.53,52.28},{53.41,47.29},{53.5,42.39},{55.17,41.34},{48.41,39.12},{54.47,36.39},{56.54,34.56},{56.89,39.01},{47.55,43.03},{52.19,41.5}}},nil,8,nil,nil,16,nil,nil,0},
[1083] = {'Murloc Shorestriker',356,386,16,17,0,{[44]={{49.78,65.84},{48.33,71.55},{47.74,68.32},{48.82,70.1},{50.17,70.33},{50.95,69.33},{46.21,69.1},{47.29,66.22},{49.86,72.06}}},nil,44,nil,nil,18,nil,nil,0},
[1084] = {'Young Sawtooth Crocolisk',1403,1469,35,36,0,{[8]={{30.44,38.94},{35.72,36.86},{29.32,36.4},{31.09,33.79},{32.72,38.9},{25.53,35.95},{42.13,34.43},{38.61,35.27},{24.61,42.55},{32.0,47.18},{24.57,39.23},{34.09,33.01},{27.1,55.13},{37.61,51.23},{34.41,51.77},{25.88,52.18},{24.1,50.33},{30.32,54.77},{28.6,55.96},{23.26,44.94}}},nil,8,nil,nil,16,nil,nil,0},
[1085] = {'Elder Stranglethorn Tiger',1279,1342,34,35,0,{[33]={{33.97,19.43},{36.04,18.86},{35.52,18.47},{35.02,19.2},{35.46,19.73},{32.43,18.44},{31.31,18.21},{33.53,18.31},{34.02,17.57},{32.09,18.99},{32.91,19.02},{31.51,20.14},{31.29,16.62},{31.94,16.08}}},nil,33,nil,nil,16,nil,nil,0},
[1087] = {'Sawtooth Snapper',1902,1981,41,42,0,{[8]={{76.75,5.84},{72.57,99.97},{83.8,95.42},{76.42,0.4},{79.68,7.38},{83.36,36.28},{77.97,14.56},{77.03,13.18},{75.53,19.4},{78.03,19.92},{75.11,14.55},{78.01,23.26},{86.55,34.09},{82.66,30.88},{80.99,19.79},{86.23,19.98},{84.25,15.29},{79.44,26.73},{77.98,28.41},{81.22,23.68},{79.74,30.56},{81.26,32.72},{84.07,33.3},{87.32,38.59},{76.27,97.38},{80.59,96.77},{82.58,99.54},{78.14,99.99},{82.79,12.33},{82.48,26.06},{86.67,56.18},{83.97,64.79},{85.38,63.35}}},nil,8,nil,nil,16,nil,nil,0},
[1088] = {'Monstrous Crawler',1716,1782,43,44,0,{[8]={{73.8,98.46},{91.38,19.73},{93.67,62.3},{93.13,69.93},{92.77,30.05},{94.09,32.69},{95.96,46.26},{78.94,98.14},{94.98,56.08},{93.57,35.53},{79.33,2.37}}},nil,8,nil,nil,7,"AH",nil,0},
[1089] = {'Mountaineer Cobbleflint',1910,1910,30,30,0,{[38]={{22.07,73.13}}},nil,38,{224},{224},55,"A",nil,2},
[1090] = {'Mountaineer Wallbang',1910,1910,30,30,0,{[38]={{23.47,74.51}}},nil,38,{263},{263},55,"A",nil,2},
[1091] = {'Mountaineer Gravelgaw',1910,1910,30,30,0,{[38]={{23.54,76.4}}},nil,38,{237},{237},55,"A",nil,2},
[1092] = {'Captain Rugelfuss',1752,1752,40,40,0,{[38]={{23.23,73.68}}},nil,38,{217,267},{217,267},55,"A",nil,2},
[1093] = {'Chief Engineer Hinderweir VII',1752,1752,40,40,0,{[38]={{46.05,13.61}}},nil,38,{161,250,278,280},{199,274,278,283},55,"A",nil,2},
[1094] = {'Venture Co. Miner',1279,1342,34,35,0,{[33]={{28.76,6.85},{27.81,7.76},{28.88,6.79},{28.93,7.65},{28.66,7.93},{28.94,7.37},{29.34,7.4},{29.14,7.22},{27.12,7.97},{27.22,7.45},{28.22,8.04},{28.32,8.15}}},nil,33,nil,nil,47,nil,nil,0},
[1095] = {'Venture Co. Workboss',1469,1469,36,36,0,{[33]={{43.11,19.01}}},nil,33,nil,nil,47,nil,nil,0},
[1096] = {'Venture Co. Geologist',1112,1207,34,36,0,{[33]={{28.86,6.9},{28.75,7.62},{28.67,7.69},{47.72,18.96},{46.75,19.21},{44.67,22.17},{42.66,18.34},{44.23,20.09},{43.08,19.51},{43.16,19.32},{43.04,19.06},{45.98,18.43},{44.0,21.05},{44.91,23.58},{45.13,23.67},{44.81,22.69},{46.35,22.81},{46.49,23.89},{43.79,23.15},{44.49,20.6},{45.17,20.36},{46.92,19.85},{43.17,20.91},{43.57,22.4},{42.38,18.55},{45.42,20.79},{44.24,18.63},{43.49,23.48},{42.69,23.09},{42.35,22.22},{27.62,8.09},{42.62,18.57},{42.46,19.1},{46.3,21.43},{46.43,20.66},{45.89,19.61},{44.47,17.58},{44.76,16.42},{43.96,17.44},{44.82,16.32}}},nil,33,nil,nil,47,nil,nil,0},
[1097] = {'Venture Co. Mechanic',1279,1342,34,35,0,{[33]={{28.63,7.6},{43.04,19.31},{43.13,19.23},{42.64,18.55},{42.17,18.7},{42.05,18.29},{42.49,18.51}}},nil,33,nil,nil,47,nil,nil,0},
[1098] = {'Watcher Merant',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1099] = {'Watcher Gelwin',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1100] = {'Watcher Selkin',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1101] = {'Watcher Thayer',484,484,20,20,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1103] = {'Eldrin',573,573,22,22,0,{[12]={{79.22,69.03}}},nil,12,nil,nil,12,"A","Journeyman Tailor",17},
[1104] = {'Grundel Harkin',102,102,5,5,0,{[1]={{28.79,67.84}}},nil,1,nil,nil,55,"A","Armorer",16388},
[1105] = {'Jern Hornhelm',328,328,15,15,0,{[38]={{37.24,47.38}}},nil,38,{273,301,436},{298,302},55,"A","Explorers' League",2},
[1106] = {'Lost One Cook',1257,1257,37,37,4,{[8]={{65.23,22.8},{63.98,22.8},{62.5,23.31},{61.82,21.85},{60.93,24.28},{62.39,20.9}}},nil,8,nil,nil,51,nil,nil,0},
[1108] = {'Mistvale Gorilla',1427,1498,32,33,0,{[33]={{36.58,16.75},{39.22,17.66},{38.75,18.27},{38.28,15.74},{38.74,16.83},{37.5,16.8},{36.66,18.33},{37.66,18.3},{37.29,16.18},{37.23,17.76},{38.04,17.59}}},nil,33,nil,nil,72,nil,nil,0},
[1109] = {'Fleshripper',273,300,13,14,0,{[40]={{51.15,24.91},{40.47,68.07},{40.37,66.81},{40.18,67.56},{38.22,34.54},{39.06,25.04},{39.85,24.03},{29.93,38.28},{36.16,38.04},{33.09,36.84},{39.19,29.28},{35.48,41.2},{61.13,46.17},{60.68,43.63},{59.81,46.68},{39.66,39.82},{41.86,39.18},{39.47,38.49},{39.31,42.04},{46.89,51.27},{48.74,50.79},{44.72,53.71},{48.43,54.83},{50.22,61.85},{52.32,59.1},{55.71,60.94},{36.95,69.07},{39.02,62.32},{40.13,59.2},{35.17,65.0},{37.54,65.96},{39.64,62.08},{40.93,59.67},{39.93,42.9},{43.22,49.08},{42.75,50.78},{43.56,46.37},{45.88,45.42},{43.59,43.8},{43.94,42.04},{39.82,68.15},{39.74,66.96},{33.32,39.22},{49.43,56.35},{50.46,59.17},{45.83,63.51}}},nil,40,nil,nil,73,nil,nil,0},
[1110] = {'Skeletal Raider',840,895,27,28,0,{[10]={{16.89,31.34},{13.67,33.39},{17.16,34.94},{17.22,33.56},{17.38,33.36},{16.37,38.55},{15.15,36.85},{17.45,34.22},{14.37,36.21},{15.37,39.2},{16.13,39.47},{15.2,38.31},{15.78,38.02},{17.72,32.66},{17.56,37.0},{18.14,39.42}}},nil,10,nil,nil,21,nil,nil,0},
[1111] = {'Leech Stalker',531,573,21,22,0,{[11]={{50.03,58.81},{55.31,63.74},{53.79,65.22},{53.01,65.36},{50.28,60.95},{56.98,62.81},{57.32,66.53},{54.72,64.72},{54.78,66.66},{54.82,66.56},{56.69,61.69},{57.27,65.34},{56.13,67.94},{56.26,65.43},{55.54,62.97},{56.18,60.94},{54.79,62.79},{54.04,63.31},{55.96,61.6},{52.4,62.81},{52.66,63.02},{51.71,63.02},{51.15,61.84},{51.56,62.13},{49.01,62.72},{50.36,62.9},{49.01,61.42},{50.26,59.57},{47.92,59.84},{46.2,59.39},{46.46,62.04},{46.76,63.57},{46.92,62.9},{46.09,62.26},{46.82,61.97}}},nil,11,nil,nil,22,nil,nil,0},
[1112] = {'Leech Widow',664,664,24,24,4,{[11]={{47.27,59.22}}},nil,11,nil,nil,22,nil,nil,0},
[1114] = {'Jungle Thunderer',1804,1883,37,38,0,{[33]={{49.14,35.39},{48.62,37.93},{41.76,24.44},{42.33,28.46},{46.48,36.5},{43.92,30.9},{46.6,34.72},{44.47,27.21},{43.46,31.72},{46.09,34.18},{44.07,32.27},{44.65,36.39},{47.08,37.22},{48.09,37.16},{48.6,36.22},{49.25,34.04},{42.8,30.98},{42.26,31.87},{46.09,29.57},{43.41,28.71},{43.04,26.2},{43.0,27.68},{42.34,27.05},{41.79,26.01},{40.75,26.01},{48.17,32.72},{49.22,32.42},{44.98,29.34},{44.96,27.81},{45.48,28.63},{40.79,28.13},{44.53,28.66},{41.22,28.53},{48.1,34.02},{41.87,27.6},{41.9,32.59},{41.89,30.94},{44.37,37.84},{45.53,36.55},{48.2,35.71},{47.68,38.04},{45.57,34.86}}},nil,33,nil,nil,72,nil,nil,0},
[1115] = {'Rockjaw Skullthumper',156,176,8,9,0,{[1]={{67.09,59.71},{67.18,58.58},{67.55,59.51},{67.55,60.18},{69.65,57.08},{70.81,53.95},{70.05,52.73},{70.32,53.27},{70.3,57.14},{69.96,57.85},{69.81,58.25},{69.4,58.32},{69.55,58.81},{70.49,57.12},{70.95,55.98},{68.63,58.08},{67.93,60.54},{68.69,59.72},{68.95,59.35},{68.88,59.8},{67.35,59.67},{68.0,59.35},{67.94,60.74},{70.51,58.88},{70.34,59.29},{70.51,58.37},{70.5,58.49},{71.18,55.29},{70.99,55.24},{71.14,53.9},{70.71,52.56},{72.49,53.47},{72.16,52.25},{71.59,51.82},{71.39,51.61},{72.63,52.41},{71.18,50.58},{71.54,51.56},{72.25,50.99},{71.49,50.29},{72.9,52.69},{72.44,51.0},{72.65,51.86},{73.23,52.02},{73.23,53.32}}},nil,1,nil,nil,59,nil,nil,0},
[1116] = {'Rockjaw Ambusher',176,198,9,10,0,{[1]={{70.79,53.08},{70.35,52.31},{72.1,55.02},{71.33,54.29},{70.95,53.29},{72.58,53.85},{73.52,52.8},{73.41,51.31},{73.93,51.52},{72.61,55.85},{73.41,55.08},{75.75,58.76},{77.25,59.8},{77.21,58.29},{75.65,57.72},{74.94,56.64},{74.74,56.43},{74.46,56.18}}},nil,1,nil,nil,59,nil,nil,0},
[1117] = {'Rockjaw Bonesnapper',176,198,9,10,0,{[1]={{70.6,55.3},{70.63,54.61},{70.41,53.27},{70.22,52.69},{70.73,53.3},{70.97,54.61},{70.67,56.64},{71.18,55.62},{71.15,52.71},{70.59,52.6},{70.95,53.3},{70.45,52.32},{70.36,52.2},{70.77,52.37},{72.41,52.9},{71.99,52.16},{71.8,52.36},{71.73,52.16},{71.69,51.27},{71.94,50.54},{71.59,50.33},{72.9,52.16},{72.16,50.71},{72.55,51.44},{72.03,49.94},{71.92,50.28},{72.45,51.53},{72.94,54.14},{75.7,61.81},{76.17,60.3},{77.04,60.85},{78.0,58.96},{78.14,59.58},{74.69,56.29},{74.98,56.16},{74.66,55.93},{79.63,55.1},{79.64,54.56},{79.65,53.99},{79.76,58.05},{78.83,58.77},{78.44,60.13},{77.33,59.54}}},nil,1,nil,nil,59,nil,nil,0},
[1118] = {'Rockjaw Backbreaker',222,247,11,12,0,{[1]={{79.38,54.11},{79.5,55.67},{79.35,54.7},{79.64,54.4},{80.52,57.1},{79.39,57.77}}},nil,1,nil,nil,59,nil,nil,0},
[1119] = {'Hammerspine',321,321,12,12,4,{[1]={{71.45,51.29}}},nil,1,nil,nil,59,nil,nil,0},
[1120] = {'Frostmane Troll',137,156,7,8,0,{[1]={{26.17,49.91},{26.06,51.29},{26.08,51.5},{25.36,51.08},{25.85,52.85},{26.69,51.43},{26.7,52.13},{66.53,41.06},{66.53,41.06},{70.61,39.31},{71.05,37.86}}},nil,1,nil,nil,37,nil,nil,0},
[1121] = {'Frostmane Snowstrider',148,166,8,9,0,{[1]={{25.38,50.07},{26.17,51.35},{26.09,50.61},{25.37,52.05},{23.65,51.43},{23.14,52.01},{22.62,50.46},{21.59,50.83},{22.87,54.49},{41.27,44.19},{41.56,36.64},{41.9,35.82},{40.75,35.12},{38.99,35.19},{66.38,41.06},{66.38,41.06},{70.52,39.3},{70.96,38.09}}},nil,1,nil,nil,37,nil,nil,0},
[1122] = {'Frostmane Hideskinner',176,198,9,10,0,{[1]={{23.91,52.23},{23.81,53.57},{22.78,52.03},{21.98,51.29},{21.61,50.64},{21.39,53.07},{21.71,52.95},{21.63,54.76},{21.93,54.97},{23.22,54.81},{23.46,53.86},{23.1,50.89}}},nil,1,nil,nil,37,nil,nil,0},
[1123] = {'Frostmane Headhunter',156,176,8,9,0,{[1]={{25.99,51.49},{26.15,51.45},{23.42,51.4},{25.5,50.86},{23.17,50.88},{23.57,50.93},{24.29,50.88},{24.6,50.94},{26.03,52.2},{23.9,53.25},{22.03,50.13},{22.37,51.78},{21.17,50.95},{21.07,51.63},{21.25,54.48},{22.63,54.62},{40.94,43.84},{39.34,35.87}}},nil,1,nil,nil,37,nil,nil,0},
[1124] = {'Frostmane Shadowcaster',160,178,9,10,0,{[1]={{26.0,51.14},{23.26,52.55},{22.38,50.24},{21.63,52.17},{22.11,52.35},{21.09,53.57},{22.83,53.84},{66.46,41.14},{66.46,41.14},{70.58,39.2},{70.9,37.84}}},nil,1,nil,nil,37,nil,nil,0},
[1125] = {'Crag Boar',102,120,5,6,0,{[1]={{48.1,49.07},{45.71,50.24},{48.47,50.51},{45.77,57.02},{46.05,59.05},{48.57,58.65},{48.5,60.13},{47.38,61.23},{44.91,62.06},{45.91,61.73},{47.66,64.05},{45.39,64.15},{46.21,63.83},{44.28,63.19},{45.68,65.96},{45.07,65.35},{44.36,67.14},{43.31,66.31},{42.4,66.8},{42.16,67.58},{39.34,64.32},{38.62,64.58},{36.5,63.04},{36.16,62.15},{36.63,59.96},{34.99,59.6},{36.48,62.95},{37.85,59.76},{39.36,63.38},{39.92,67.84},{49.05,54.75},{45.48,50.59},{30.99,53.67},{30.05,54.35},{32.67,57.11},{31.35,57.91},{34.42,57.17},{34.72,58.43},{33.66,59.49},{45.45,49.98},{44.24,52.89},{42.35,56.82},{43.94,55.83},{43.39,55.89},{43.07,56.43},{44.0,55.6},{44.76,57.58},{41.18,58.3},{39.49,57.78},{41.88,60.37},{40.46,60.5},{39.18,59.52},{42.36,65.43},{43.31,65.82},{44.76,65.61},{46.11,64.48},{45.35,64.04},{44.24,59.37},{42.31,59.92},{46.2,61.95},{46.58,59.35},{47.11,61.47},{48.67,62.87},{46.24,65.39},{49.71,61.8},{49.19,59.3},{49.44,50.48},{49.31,50.33},{50.11,51.88},{51.45,53.33},{51.27,51.12},{50.99,52.29},{51.81,58.52},{40.67,68.3}}},nil,1,nil,nil,189,"AH",nil,0},
[1126] = {'Large Crag Boar',120,137,6,7,0,{[1]={{45.23,45.32},{45.36,41.69},{48.1,47.25},{48.03,56.69},{47.26,63.92},{48.08,47.01},{50.38,43.24},{45.06,41.59},{43.51,38.02},{43.5,34.3},{43.91,29.7},{41.22,30.54},{34.33,55.63},{36.39,54.22},{35.64,54.71},{37.28,52.73},{36.33,52.17},{36.98,51.05},{38.12,51.13},{38.14,50.98},{38.66,48.64},{39.57,46.9},{39.15,48.12},{38.56,46.73},{41.65,39.53},{45.19,45.33},{41.22,47.18},{49.44,62.61},{49.5,58.45},{48.42,56.76},{49.25,54.76},{48.48,47.33},{50.49,52.07},{50.53,60.0},{56.82,52.67},{56.16,47.74},{55.9,47.8},{58.72,54.08},{65.35,50.23},{64.16,53.9},{62.39,55.14},{59.77,55.26},{66.97,50.31}}},nil,1,nil,nil,189,"AH",nil,0},
[1127] = {'Elder Crag Boar',137,156,7,8,0,{[1]={{45.2,42.16},{45.32,42.57},{44.18,32.04},{43.58,29.62},{42.07,30.0},{40.06,30.54},{39.48,33.99},{36.99,34.34},{37.37,35.63},{36.79,31.17},{35.47,34.95},{34.63,31.47},{33.86,31.09},{34.11,35.23},{32.39,34.4},{33.14,37.54},{31.71,38.72},{31.02,35.7},{30.13,38.39},{29.2,39.98},{27.55,39.31},{26.72,42.94},{26.25,44.74},{25.95,46.41},{27.49,45.74},{26.62,55.08},{27.53,53.94},{28.31,53.34},{27.73,47.37},{28.03,42.69},{28.36,44.29},{29.59,42.45},{32.23,47.09},{29.59,49.68},{32.11,48.83},{32.0,49.8},{30.14,51.94},{37.72,51.88},{40.46,47.22},{37.83,45.95},{33.52,48.02},{35.57,36.8},{37.52,37.36},{42.36,38.9},{53.36,58.16},{55.56,57.37},{55.51,57.38},{55.77,58.99},{56.56,60.04},{55.66,55.76},{56.68,54.3},{55.31,54.33},{57.92,50.43},{58.23,51.29},{59.21,50.06},{60.81,53.9},{61.3,56.71},{59.02,57.88},{57.32,56.67},{58.48,59.72},{59.57,60.06},{58.72,58.88},{59.94,58.56},{61.44,58.37},{60.93,60.25},{63.08,59.19},{62.78,56.15},{63.87,60.45},{66.14,53.3},{66.17,52.72},{67.43,51.66},{68.68,51.72},{66.8,49.35},{71.54,55.61},{70.82,51.57},{70.52,51.98},{69.72,50.17},{73.5,52.1},{72.43,60.98},{70.7,61.62},{74.66,61.34},{73.39,48.69},{75.76,48.21},{79.21,57.25},{80.21,46.26},{79.82,43.27},{81.48,35.63}}},nil,1,nil,nil,189,"AH",nil,0},
[1128] = {'Young Black Bear',122,144,5,6,0,{[1]={{45.39,49.35},{44.89,50.16},{44.75,55.26},{45.56,58.22},{41.9,66.79},{38.85,61.96},{38.67,61.09},{35.54,60.0},{34.44,59.5},{39.05,60.52},{45.28,58.12},{48.1,49.92},{30.37,55.63},{32.34,56.05},{30.76,57.22},{32.47,57.87},{43.73,44.88},{43.07,45.9},{44.27,47.81},{44.23,50.95},{43.74,51.9},{45.04,55.2},{43.52,58.95},{39.86,60.86},{40.47,60.81},{41.56,59.9},{39.62,59.06},{41.7,60.9},{48.12,49.88},{49.17,51.0},{50.55,51.77},{65.48,12.7},{65.56,12.72}}},nil,1,nil,nil,44,nil,nil,0},
[1129] = {'Black Bear',144,144,6,6,0,{[1]={{65.43,12.89}}},nil,1,nil,nil,44,nil,nil,0},
[1130] = {'Bjarn',247,247,12,12,4,{[1]={{55.64,58.51},{62.57,58.45},{59.45,58.43},{52.83,58.52}}},nil,1,nil,nil,44,nil,nil,0},
[1131] = {'Winter Wolf',137,156,7,8,0,{[1]={{45.69,42.3},{45.08,43.31},{45.99,47.19},{48.92,44.61},{45.09,41.82},{44.88,42.36},{33.47,43.61},{33.83,43.65},{33.97,41.29},{33.96,42.23},{34.58,42.24},{33.99,42.8},{33.95,41.02},{34.51,41.32},{44.93,41.41},{43.25,47.06},{49.01,44.62},{50.96,44.95},{51.61,46.41},{52.06,48.65},{51.54,49.62},{50.68,52.54}}},nil,1,nil,nil,38,nil,nil,0},
[1132] = {'Timber',198,198,10,10,4,{[1]={{34.21,41.79},{33.5,43.75},{34.11,42.56}}},nil,1,nil,nil,38,nil,nil,0},
[1133] = {'Starving Winter Wolf',156,176,8,9,0,{[1]={{34.2,41.86},{34.16,41.76}}},nil,1,nil,nil,38,nil,nil,0},
[1134] = {'Young Wendigo',102,120,5,6,0,{[1]={{39.18,49.31},{40.25,46.16},{43.03,54.87},{42.89,55.25},{42.78,55.19},{42.59,55.53},{42.12,55.48},{42.94,54.63},{42.57,55.42},{42.49,54.97},{42.12,54.81},{41.92,55.17},{41.8,54.59},{41.96,55.35}}},nil,1,nil,nil,24,nil,nil,0},
[1135] = {'Wendigo',120,137,6,7,0,{[1]={{39.69,48.69},{39.42,48.12},{39.7,47.71},{39.32,47.36},{39.05,48.8},{38.88,48.39},{40.26,47.78},{39.93,47.24},{40.5,46.63},{40.52,46.89},{39.19,46.44},{42.07,46.28},{41.12,47.17},{41.28,45.37},{42.71,46.84},{42.24,46.08},{43.57,49.61},{43.17,48.88},{43.29,49.2},{42.33,49.24},{42.68,49.19},{42.75,49.93},{43.04,50.01},{42.22,48.55},{42.03,46.97},{42.14,47.69},{42.19,46.51},{41.57,48.98},{41.9,46.0},{41.95,45.97},{41.99,48.39},{40.99,45.63},{41.86,45.21},{42.24,53.48},{42.2,52.56},{42.71,51.88},{42.4,55.2},{41.93,54.04},{41.98,51.47},{42.61,50.41},{40.21,53.25},{41.39,51.09},{41.18,50.63},{41.1,49.52},{41.25,49.36},{40.96,49.23},{41.6,48.35},{41.15,50.55},{41.16,49.29},{41.89,51.5},{42.3,52.01},{42.19,53.36},{42.18,52.6},{42.68,51.82},{41.92,52.74},{42.46,53.68},{41.09,49.82},{42.46,54.52}}},nil,1,nil,nil,24,nil,nil,0},
[1137] = {'Edan the Howler',176,176,9,9,4,{[1]={{38.98,47.48},{42.21,49.43}}},{[1]={{{38.98,47.47},{39.15,47.46},{39.49,47.43},{39.75,47.41},{40.01,47.34},{40.24,47.12},{40.34,46.76},{40.41,46.53},{40.5,46.24},{40.64,46.01},{40.77,45.84},{40.9,45.68},{41.03,45.52},{40.9,45.83},{40.75,45.96},{40.7,46.04},{40.56,46.24},{40.51,46.62},{40.46,46.93},{40.41,47.17},{40.34,47.5},{40.32,47.73},{40.3,47.95},{40.19,48.05},{40.06,48.18},{39.88,48.38},{39.63,48.53},{39.4,48.66},{39.14,48.81},{38.98,48.9},{38.82,48.8},{38.69,48.52},{38.67,48.18},{38.75,47.89},{38.87,47.67}},{{42.2,49.42},{42.35,49.43},{42.56,49.46},{42.62,49.76},{42.63,50.1},{42.6,50.29},{42.81,50.22},{42.93,50.11},{43.04,50.07},{43.21,49.99},{43.3,49.81},{43.38,49.56},{43.44,49.32},{43.47,49.04},{43.4,48.94},{43.28,48.79},{43.15,48.75},{43.13,48.83},{43.07,49.03},{42.98,49.1},{42.82,49.22},{42.74,49.21},{42.62,49.13},{42.56,48.98},{42.51,48.8},{42.44,48.85},{42.39,48.93},{42.38,49.13},{42.36,49.33},{42.28,49.37}}}},1,nil,nil,24,nil,nil,0},
[1138] = {'Snow Tracker Wolf',120,137,6,7,0,{[1]={{44.36,45.26},{45.69,46.66},{43.26,46.5},{44.61,47.07},{45.95,46.16},{49.73,44.51},{51.33,45.35},{51.3,45.72}}},nil,1,nil,nil,38,nil,nil,0},
[1139] = {'Magistrate Bluntnose',484,484,20,20,0,{[38]={{34.6,44.47}}},nil,38,{255},{255,256},55,"A",nil,2},
[1140] = {'Razormaw Matriarch',1106,1106,31,31,4,{[11]={{69.93,29.22}}},{[11]={{{69.93,29.21},{69.73,28.98},{69.32,28.78},{69.08,28.77},{68.76,28.75},{68.59,28.43},{68.62,28.1},{68.67,27.66},{68.41,27.54},{68.08,27.65},{67.95,27.69},{67.79,27.83},{67.63,28.13},{67.45,28.47},{67.35,28.85},{67.18,29.36},{67.29,29.8},{67.4,30.28},{67.41,30.62},{67.18,30.74},{67.1,31.06},{67.21,31.36},{67.35,31.53},{67.52,31.8},{67.7,32.19},{67.75,32.26},{67.74,32.06},{67.72,31.79},{67.83,31.49},{67.87,31.15},{67.91,30.85},{67.9,30.41},{67.89,30.07},{67.85,29.92},{67.78,29.82},{67.64,29.61},{67.44,29.2},{67.41,29.03},{67.45,28.67},{67.47,28.57},{67.57,28.34},{67.85,27.73},{68.08,27.6},{68.3,27.68},{68.58,27.82},{68.64,28.04},{68.6,28.31},{68.72,28.82},{69.03,28.88},{69.32,28.94},{69.55,29.08},{69.76,29.21},{69.95,29.33}}}},11,nil,nil,48,nil,nil,0},
[1141] = {'Angus Stern',4120,4120,60,60,0,{[1519]={{41.5,89.43}}},nil,1519,{212,1260,1271},{212,1271},12,"A","Head Chef",2},
[1142] = {'Mosh\'Ogg Brute',1469,1536,36,37,0,{[33]={{35.55,30.92},{37.17,30.63},{37.89,30.24},{37.49,30.89},{37.34,31.33},{36.73,31.9}}},nil,33,nil,nil,45,nil,nil,0},
[1144] = {'Mosh\'Ogg Witch Doctor',1208,1257,36,37,0,{[33]={{37.01,28.69},{38.16,30.05},{37.17,30.81},{37.49,31.04},{36.12,31.69},{37.07,31.06}}},nil,33,nil,nil,45,nil,nil,0},
[1146] = {'Vharr',1752,1752,40,40,0,{[33]={{32.36,27.95}}},nil,33,nil,nil,29,"H","Superior Weaponsmith",16388},
[1147] = {'Hragran',1752,1752,40,40,0,{[33]={{31.61,29.18}}},nil,33,nil,nil,29,"H","Cloth & Leather Armor Merchant",16388},
[1148] = {'Nerrist',1752,1752,40,40,0,{[33]={{32.7,29.23}}},nil,33,nil,nil,29,"H","Trade Goods",4},
[1149] = {'Uthok',1752,1752,40,40,0,{[33]={{31.55,27.95}}},nil,33,nil,nil,29,"H","General Supplies",4},
[1150] = {'River Crocolisk',1050,1107,30,31,0,{[33]={{35.64,8.1},{34.56,8.1},{39.88,14.44},{41.18,14.13},{36.85,10.51},{39.9,11.47},{38.72,11.32},{40.39,12.26},{34.04,9.62},{34.58,10.46},{32.46,8.92},{41.01,13.72},{35.7,8.2}}},nil,33,nil,nil,14,nil,nil,0},
[1151] = {'Saltwater Crocolisk',1403,1469,35,36,0,{[33]={{14.97,10.02},{17.8,12.08},{21.6,17.74},{22.02,18.46},{21.91,16.59},{21.59,15.98},{34.04,31.75},{26.12,19.03},{22.68,17.65},{22.48,19.26},{28.35,20.57},{27.41,20.72},{29.82,23.12}}},nil,33,nil,nil,14,nil,nil,0},
[1152] = {'Snapjaw Crocolisk',1403,1469,35,36,0,{[33]={{41.42,20.72},{41.35,19.11},{39.72,21.51},{40.15,22.88},{40.87,17.66},{39.74,17.5},{41.77,17.46},{39.42,24.98},{39.15,31.89},{38.42,31.36},{40.39,19.41},{39.84,15.97},{37.86,32.63},{38.81,28.54},{39.94,30.66},{40.14,28.39},{40.2,27.22},{40.11,29.51},{40.77,24.66},{40.74,22.18},{41.32,21.52},{42.17,21.2},{39.45,28.72},{38.64,29.79},{42.46,16.67},{41.93,15.91},{41.32,15.34}}},nil,33,nil,nil,14,nil,nil,0},
[1153] = {'Torren Squarejaw',328,328,15,15,0,{[38]={{37.27,47.77}}},nil,38,nil,nil,55,"A","Explorers' League",2},
[1154] = {'Marek Ironheart',328,328,15,15,0,{[38]={{81.76,61.66}}},nil,38,{385},{385},55,"A",nil,3},
[1155] = {'Kelt Thomasin',328,328,15,15,0,{[38]={{81.93,64.61}}},nil,38,nil,nil,55,"A",nil,0},
[1156] = {'Vyrin Swiftwind',328,328,15,15,0,{[38]={{81.73,64.14}}},nil,38,{271},{531},84,"A",nil,3},
[1157] = {'Cursed Sailor',787,840,26,27,0,{[11]={{15.03,23.74},{14.13,30.6},{13.51,30.32},{13.84,30.75},{13.56,30.54},{13.74,29.75},{13.93,30.47},{14.03,28.9},{13.99,30.18},{13.18,30.72},{13.89,29.26},{14.11,29.32},{13.61,29.81},{14.03,30.28}}},nil,11,nil,nil,21,nil,nil,0},
[1158] = {'Cursed Marine',840,895,27,28,0,{[11]={{15.42,23.37},{15.33,23.44},{15.11,23.63},{15.5,24.07},{15.07,23.96},{15.16,23.53},{14.07,24.9},{14.33,24.46},{15.0,23.45},{14.61,24.36},{14.83,24.27},{14.48,23.81},{14.59,23.68},{14.25,23.96},{13.9,28.66},{13.32,29.63},{14.81,24.64},{14.4,23.31},{13.7,24.11},{14.25,23.98},{14.55,24.11},{13.52,30.95},{14.52,29.04},{14.11,28.99},{13.95,29.96}}},nil,11,nil,nil,21,nil,nil,0},
[1159] = {'First Mate Snellig',950,950,29,29,0,{[11]={{13.79,30.18}}},nil,11,nil,nil,21,nil,nil,0},
[1160] = {'Captain Halyndor',1003,1003,30,30,0,{[11]={{15.45,23.61}}},nil,11,nil,nil,21,nil,nil,0},
[1161] = {'Stonesplinter Trogg',222,247,11,12,0,{[38]={{27.19,57.08},{26.98,56.54},{27.32,50.19},{26.57,50.17},{26.15,49.04},{26.58,49.02},{27.15,46.69},{26.28,48.41},{26.07,51.8},{27.13,54.2},{28.33,48.89},{32.11,79.59},{30.17,72.66},{32.78,79.34},{33.47,70.36},{31.55,80.75},{31.25,79.95},{33.36,70.26},{29.63,72.54},{32.05,79.15},{30.06,71.91},{33.07,70.0},{31.65,75.35},{31.44,76.49},{30.94,75.16},{30.81,74.34},{32.07,77.88},{31.56,77.17},{30.84,74.03},{31.54,75.71},{30.7,75.49},{34.93,72.48},{32.12,70.49},{35.24,71.92},{33.36,77.84},{34.71,73.95},{33.8,71.16},{32.37,72.36},{34.74,71.32},{33.14,70.92}}},nil,38,nil,nil,59,nil,nil,0},
[1162] = {'Stonesplinter Scout',222,247,11,12,0,{[38]={{26.11,49.37},{25.92,49.04},{25.83,48.62},{26.37,57.33},{26.54,56.74},{27.58,57.78},{26.71,57.42},{27.39,55.94},{27.76,48.55},{34.5,76.19},{35.12,76.54},{34.7,76.78},{34.96,76.29},{29.57,72.89},{30.78,80.83},{32.72,80.04},{31.86,74.4},{31.29,74.43},{32.0,74.93},{33.85,70.8},{31.37,80.9},{32.57,79.89},{30.55,75.23},{31.01,71.74},{31.69,76.66},{28.43,59.36},{33.3,75.89},{35.41,71.04},{33.45,74.21},{33.73,71.84},{35.26,70.99}}},nil,38,nil,nil,59,nil,nil,0},
[1163] = {'Stonesplinter Skullthumper',273,300,13,14,0,{[38]={{27.98,81.18},{51.25,23.66},{27.51,85.89},{50.52,23.98},{48.25,20.65},{48.12,20.93},{48.31,21.18},{48.13,29.1},{28.19,86.9},{28.31,87.03},{28.71,86.22},{31.31,85.37},{36.18,86.53},{35.47,87.48},{35.98,84.66},{35.91,84.2},{37.12,85.35},{36.3,83.63},{36.11,83.55},{29.02,81.22},{28.93,84.93},{47.79,28.49},{36.5,81.42},{35.64,80.86},{35.34,82.93},{35.15,84.03},{34.15,85.91},{32.76,89.86},{34.9,88.73},{34.38,87.63},{36.35,88.36}}},nil,38,nil,nil,59,nil,nil,0},
[1164] = {'Stonesplinter Bonesnapper',328,356,15,16,0,{[38]={{37.27,93.22},{37.33,92.38},{52.23,24.09},{53.12,22.83},{52.17,21.79},{54.41,26.71},{54.54,26.99},{52.69,24.94},{52.81,26.77},{52.16,24.74},{35.87,93.93},{35.47,94.08},{35.85,92.09},{37.88,87.01},{34.56,91.52},{33.34,90.99},{32.99,91.27}}},nil,38,nil,nil,59,nil,nil,0},
[1165] = {'Stonesplinter Geomancer',330,354,17,18,0,{[38]={{72.69,61.99},{69.97,66.48},{69.23,66.04},{69.05,59.73},{70.84,63.54},{70.03,62.68},{72.28,68.25},{72.59,64.71},{69.01,63.3},{69.11,63.29},{67.02,59.41}}},nil,38,nil,nil,59,nil,nil,0},
[1166] = {'Stonesplinter Seer',253,276,13,14,0,{[38]={{27.88,81.45},{34.98,90.9},{34.57,89.78},{51.04,23.32},{27.97,86.05},{27.45,85.55},{50.87,24.05},{48.83,29.46},{48.9,29.92},{50.59,25.05},{48.61,29.93},{47.69,21.08},{49.03,21.96},{49.59,29.96},{48.66,20.99},{46.5,21.2},{47.84,23.08},{49.96,23.57},{48.04,19.11},{29.22,87.61},{29.01,87.71},{28.08,83.46},{27.93,83.39},{36.36,85.99},{33.74,87.41},{29.42,86.72},{30.09,83.99},{33.55,88.46},{36.75,77.75},{36.65,84.19},{36.33,82.98},{29.58,81.46},{28.49,83.71},{29.05,80.89},{50.11,27.24},{48.67,28.88},{34.75,82.41},{34.37,81.78},{35.3,82.56},{35.45,80.1},{36.61,79.71},{34.63,84.87},{34.01,85.01},{35.23,87.46},{33.75,89.06},{35.64,89.5},{34.87,90.05}}},nil,38,nil,nil,59,nil,nil,0},
[1167] = {'Stonesplinter Digger',417,449,18,19,0,{[38]={{67.99,66.05},{69.06,66.06},{70.1,66.09},{68.27,62.62},{67.87,59.1},{70.61,59.97},{69.62,59.33},{70.63,64.78},{69.39,67.19},{70.94,66.0},{71.2,68.53},{72.62,66.79},{72.48,64.21},{70.14,67.38},{71.65,68.55}}},nil,38,nil,nil,59,nil,nil,0},
[1169] = {'Dark Iron Insurgent',417,449,18,19,0,{[38]={{57.57,16.56},{57.55,19.28},{58.72,18.66},{60.27,15.77},{59.03,13.35},{58.95,13.51},{59.22,13.68}},[11]={{63.36,77.57},{63.22,77.29},{63.64,77.94},{63.82,78.24},{63.76,78.42}}},nil,38,nil,nil,54,nil,nil,0},
[1171] = {'Dark Iron Guerrilla',386,417,17,18,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1172] = {'Tunnel Rat Vermin',198,222,10,11,0,{[38]={{36.02,14.65},{40.0,18.04},{39.26,20.94},{40.68,19.45},{38.44,14.3},{38.33,19.68},{27.69,43.61},{36.88,18.11},{38.64,22.93},{27.4,44.59},{27.33,41.7},{26.74,41.48},{37.01,29.51},{28.3,44.83},{39.81,25.1},{40.38,23.34},{38.43,25.73},{38.01,27.4},{36.93,26.88},{23.94,34.35},{34.55,17.08},{33.47,12.67},{36.61,11.87},{35.5,15.46},{35.84,26.76},{34.58,10.45},{38.35,16.0},{38.93,10.56},{40.47,10.0},{38.02,12.56},{25.91,34.66},{37.33,10.97},{22.44,28.54},{38.2,17.8},{26.19,31.47},{26.24,31.84},{23.68,26.08},{23.86,30.19},{25.07,32.73},{24.68,30.42},{24.69,30.01},{25.01,28.6},{34.55,17.44}}},nil,38,nil,nil,26,nil,nil,0},
[1173] = {'Tunnel Rat Scout',198,222,10,11,0,{[38]={{37.43,25.89},{36.56,18.3},{36.41,25.03},{23.34,28.53},{26.45,26.85},{24.49,29.49},{27.64,32.14},{24.89,29.64},{25.41,29.83},{26.05,31.9}}},nil,38,nil,nil,26,nil,nil,0},
[1174] = {'Tunnel Rat Geomancer',219,241,12,13,0,{[38]={{36.64,25.14},{35.55,27.92},{36.59,25.65},{35.58,21.07},{35.55,22.63},{35.8,22.33},{36.18,24.31},{35.41,21.57},{35.32,23.04},{35.15,23.93}}},nil,38,nil,nil,26,nil,nil,0},
[1175] = {'Tunnel Rat Digger',247,273,12,13,0,{[38]={{35.99,27.07},{36.41,26.13},{35.56,19.52},{36.42,20.53},{35.03,23.46},{35.53,23.93},{36.27,23.41},{35.15,24.31},{35.91,22.31},{35.61,24.7},{35.16,24.89},{35.56,22.03},{35.37,24.61}}},nil,38,nil,nil,26,nil,nil,0},
[1176] = {'Tunnel Rat Forager',222,247,11,12,0,{[38]={{37.0,24.87},{37.15,24.82},{37.31,24.5},{25.73,43.83},{26.28,43.21},{26.45,44.04},{35.27,16.31},{35.59,16.0},{36.33,23.46},{37.53,16.19},{37.35,16.42}}},nil,38,nil,nil,26,nil,nil,0},
[1177] = {'Tunnel Rat Surveyor',300,300,14,14,0,{[38]={{35.02,27.21},{34.91,26.28},{34.43,26.81}}},nil,38,nil,nil,26,nil,nil,0},
[1178] = {'Mo\'grosh Ogre',1251,1347,18,19,1,{[38]={{68.57,31.82},{68.75,28.37},{67.13,33.89},{69.67,25.54},{70.8,25.59},{69.62,26.85},{75.67,32.33},{73.57,25.9},{72.23,23.25},{63.58,21.38},{69.33,21.05},{63.62,25.06},{69.48,22.55},{65.98,21.59},{68.54,21.33}}},nil,38,nil,nil,45,nil,nil,0},
[1179] = {'Mo\'grosh Enforcer',1131,1212,18,19,1,{[38]={{66.41,32.21},{67.37,30.23},{70.83,23.85},{73.43,28.77},{72.06,25.23},{73.93,24.7},{68.27,30.34},{67.37,23.21},{69.32,22.34},{64.85,19.88},{72.03,19.78},{73.72,33.4},{68.93,24.54},{70.72,22.79},{70.47,20.58},{76.87,16.17},{78.35,15.68},{75.96,15.3},{75.89,15.08},{76.87,13.83}}},nil,38,nil,nil,45,nil,nil,0},
[1180] = {'Mo\'grosh Brute',1347,1452,19,20,1,{[38]={{74.73,25.18},{75.09,15.98},{75.84,17.51},{77.29,13.78},{77.47,13.91},{79.51,14.95},{79.79,15.2},{68.84,20.25},{75.63,18.42}}},nil,38,nil,nil,45,nil,nil,0},
[1181] = {'Mo\'grosh Shaman',1131,1212,18,19,1,{[38]={{70.29,17.82},{74.56,30.56},{68.56,22.21},{67.26,21.61},{73.36,19.75},{75.31,29.93},{73.5,25.09},{72.08,21.01},{65.08,20.3},{74.0,19.71},{76.54,18.07},{77.48,17.59},{75.13,16.72},{79.19,15.41}}},nil,38,nil,nil,45,nil,nil,0},
[1182] = {'Brother Anton',2217,2217,45,45,0,{[405]={{66.52,7.91}}},nil,405,{261,1052},{261,6141},12,"A","Scarlet Crusade Emissary",2},
[1183] = {'Mo\'grosh Mystic',1212,1299,19,20,1,{[38]={{75.2,25.15},{75.45,24.84},{76.77,14.3},{68.34,18.68},{68.61,18.89}}},nil,38,nil,nil,45,nil,nil,0},
[1184] = {'Cliff Lurker',417,417,18,18,0,{[38]={{49.05,72.99},{71.18,50.86},{69.74,51.63},{55.25,78.3},{58.12,77.27},{60.23,77.5},{48.71,72.4},{62.64,54.41},{65.63,50.95},{62.62,64.13},{64.66,53.34},{50.54,73.76},{62.5,55.68},{57.07,65.18},{46.34,72.4},{56.6,65.86},{67.46,52.41}}},nil,38,nil,nil,22,nil,nil,0},
[1185] = {'Wood Lurker',386,417,17,18,0,{[38]={{75.79,38.0},{80.76,40.03},{80.36,40.31},{77.49,34.26},{77.83,36.4},{76.15,37.98},{74.31,34.68},{78.91,40.91},{75.63,35.93},{74.32,37.81},{59.31,23.32}}},nil,38,nil,nil,22,nil,nil,0},
[1186] = {'Elder Black Bear',266,296,11,12,0,{[38]={{30.55,10.38},{29.08,13.4},{27.19,10.52},{27.42,14.19},{40.82,52.53},{40.44,71.73},{39.72,33.25},{23.78,25.37},{35.98,32.11},{30.13,24.67},{18.94,75.46},{26.32,40.27},{30.57,53.86},{39.45,74.48},{33.44,30.06},{20.74,77.43},{24.76,36.45},{34.14,29.77},{38.11,55.97},{37.21,52.83},{29.39,40.28},{32.46,29.75},{37.2,32.83},{27.53,28.69}}},nil,38,nil,nil,44,nil,nil,0},
[1187] = {'Daryl the Youngling',328,328,15,15,0,{[38]={{83.47,65.46}}},nil,38,{257,258,531},{257,258,271},55,"A",nil,2},
[1188] = {'Grizzled Black Bear',328,360,13,14,0,{[38]={{67.9,49.29},{63.19,80.21},{68.42,72.63},{74.61,50.65},{78.05,68.74},{75.82,54.93},{76.13,51.74},{73.93,55.33},{58.61,75.04},{65.9,74.21},{66.2,76.04},{67.91,73.28},{64.4,73.49},{65.48,69.75},{58.44,69.06},{62.54,43.27},{66.34,45.47},{65.79,47.34},{66.19,42.74},{43.13,63.73},{43.86,61.3},{64.98,45.29},{40.89,62.26},{40.78,66.71}}},nil,38,nil,nil,44,nil,nil,0},
[1189] = {'Black Bear Patriarch',427,463,16,17,0,{[38]={{68.29,42.79},{71.72,40.28},{73.2,35.54},{71.81,40.47},{72.85,44.73},{68.51,36.41},{76.42,41.79},{78.03,41.6},{75.75,44.32},{74.18,44.73},{64.89,34.47},{62.11,33.05},{64.44,29.45},{71.89,36.68},{68.63,41.46},{63.62,33.64},{72.24,37.73},{58.82,32.33},{60.04,26.93},{59.0,25.23},{58.95,28.75}}},nil,38,nil,nil,44,nil,nil,0},
[1190] = {'Mountain Boar',198,222,10,11,0,{[38]={{30.6,16.56},{30.53,15.36},{35.49,33.96},{31.82,24.1},{25.27,13.89},{29.91,46.84},{38.5,36.13},{37.19,39.9},{36.96,34.52},{33.85,31.8},{37.44,38.42},{33.34,33.45},{24.27,21.43},{27.25,39.1},{27.74,26.64},{29.13,32.8},{39.52,29.22},{29.91,36.48},{34.81,36.43},{37.23,36.18},{37.2,34.39},{32.92,35.1},{28.62,23.23},{38.16,37.94},{34.35,30.52},{38.18,34.24}}},nil,38,nil,nil,1094,"AH",nil,0},
[1191] = {'Mangy Mountain Boar',300,328,14,15,0,{[38]={{52.16,73.45},{59.94,59.48},{52.5,74.69},{61.59,57.35},{62.98,57.51},{77.89,73.65},{74.51,52.44},{74.67,72.54},{63.78,65.71},{60.08,61.82},{66.41,68.89},{65.0,63.36},{58.48,61.26},{62.67,59.95},{65.64,58.02},{64.16,59.3},{62.58,60.28},{63.42,50.66},{65.23,48.43},{63.52,47.05},{50.79,71.56},{38.99,51.25},{58.72,65.85},{44.22,62.81},{59.8,63.75},{64.33,56.92},{34.16,62.62},{56.51,63.61},{45.59,66.43},{41.8,55.27},{49.07,68.57},{60.24,65.58}}},nil,38,nil,nil,189,"AH",nil,0},
[1192] = {'Elder Mountain Boar',356,386,16,17,0,{[38]={{70.12,37.77},{61.18,39.62},{64.94,38.83},{67.37,41.3},{67.08,39.42},{66.14,38.31},{66.33,40.12},{65.37,41.94},{62.38,38.38},{63.2,35.1},{61.33,41.4},{62.98,39.95},{60.0,37.89},{77.29,47.08},{60.21,33.91},{74.77,42.14},{75.72,46.64},{74.78,50.69},{60.35,36.22}}},nil,38,nil,nil,1094,"AH",nil,0},
[1193] = {'Loch Frenzy',247,273,12,13,0,{[38]={{49.07,17.44},{44.38,17.36},{48.01,16.92},{54.04,14.19},{51.39,17.78},{43.54,14.85},{51.59,14.26},{53.92,19.88},{53.87,14.29},{50.37,16.92},{52.78,14.3},{45.59,26.95},{44.43,16.13},{44.3,21.6},{54.07,15.92},{43.0,24.05},{46.86,17.63},{43.4,26.54},{43.14,17.9},{43.25,19.85},{44.72,22.16},{56.95,27.99},{45.62,23.46},{56.61,25.2},{52.98,18.13},{54.68,21.57}}},nil,38,nil,nil,16,nil,nil,0},
[1194] = {'Mountain Buzzard',328,356,15,16,0,{[38]={{71.08,74.81},{70.56,74.11},{71.08,72.42},{70.86,52.61},{68.38,50.52},{76.77,63.67},{76.27,74.78},{79.2,63.69},{77.09,58.32},{76.86,55.59},{78.52,57.96},{77.18,57.33},{78.87,59.18},{76.97,74.0},{75.89,72.33},{75.79,70.46},{74.73,67.67},{74.45,72.53},{79.33,66.86},{78.55,76.86},{78.16,76.03},{77.32,75.27},{68.47,75.83},{78.04,72.44},{74.48,64.27}}},nil,38,nil,nil,14,nil,nil,0},
[1195] = {'Forest Lurker',198,222,10,11,0,{[38]={{28.71,16.83},{27.37,18.34},{39.48,72.96},{36.63,30.8},{38.53,31.57},{25.34,37.75},{28.57,57.0},{29.58,46.82},{28.58,49.1},{19.29,83.47},{30.01,44.65},{27.75,41.89},{32.13,17.08},{39.45,74.69},{28.81,51.94},{29.89,50.69},{31.1,30.61},{34.31,54.19},{36.91,73.91},{21.15,71.59},{31.08,41.56},{29.9,22.63},{29.73,18.47},{27.73,21.25},{30.01,19.82},{31.13,52.19},{33.92,40.86},{28.71,30.77},{32.81,30.61},{33.56,40.53},{32.39,32.6},{36.56,31.13},{35.95,34.44},{35.64,52.82},{30.5,45.07}}},nil,38,nil,nil,22,nil,nil,0},
[1196] = {'Ice Claw Bear',164,187,7,8,0,{[1]={{46.35,63.35},{43.84,28.78},{41.24,29.17},{37.77,33.92},{36.18,30.46},{34.57,30.3},{34.22,32.05},{33.35,36.8},{31.79,38.64},{30.6,35.08},{25.5,46.37},{26.88,46.91},{25.32,55.76},{25.98,55.19},{26.7,56.19},{28.05,54.51},{28.1,52.24},{28.34,47.54},{27.62,47.63},{28.05,43.1},{29.06,42.68},{29.3,41.51},{30.19,42.26},{30.95,40.81},{32.37,47.18},{29.72,51.71},{32.27,49.9},{30.48,59.6},{37.14,43.93},{35.9,46.93},{35.2,35.91},{38.12,42.91},{38.52,43.45},{37.73,41.59},{38.91,40.29},{46.71,63.3},{49.28,62.28},{51.16,43.14},{50.34,53.8},{50.24,59.37},{56.26,43.27},{59.27,51.98},{60.97,56.87},{58.71,61.27},{64.93,59.95},{66.5,50.47},{74.78,48.09},{80.07,48.61}}},nil,1,nil,nil,44,nil,nil,0},
[1197] = {'Stonesplinter Shaman',301,325,15,16,0,{[38]={{35.07,91.42},{36.77,93.89},{36.44,93.54},{52.55,23.89},{51.92,23.54},{54.15,25.98},{53.68,25.08},{54.51,26.43},{54.03,27.17},{51.78,24.63},{55.17,26.96},{34.49,94.57},{34.76,94.35},{34.67,94.81},{36.15,94.15},{36.1,92.53},{37.52,90.07},{36.25,91.02},{37.47,86.23},{38.23,87.7},{38.1,87.73},{33.8,93.87},{34.27,91.62}}},nil,38,nil,nil,59,nil,nil,0},
[1198] = {'Rallic Finn',417,417,18,18,0,{[12]={{83.28,66.09}}},nil,12,nil,nil,12,"A","Bowyer",16388},
[1199] = {'Juvenile Snow Leopard',102,120,5,6,0,{[1]={{45.25,58.46},{40.53,62.04},{38.65,60.68},{38.83,60.98},{36.68,60.47},{35.54,60.59},{38.31,60.87},{43.02,56.46},{42.43,57.92},{40.22,58.87},{39.81,60.07},{41.51,60.05},{43.26,60.27},{43.64,59.65},{45.37,58.75}}},nil,1,nil,nil,66,nil,nil,0},
[1200] = {'Morbent Fel',3609,3609,32,32,1,{[10]={{16.9,33.4}}},nil,10,nil,nil,21,nil,nil,0},
[1201] = {'Snow Leopard',137,156,7,8,0,{[1]={{48.52,59.13},{47.29,63.32},{47.94,63.16},{42.73,30.96},{43.97,30.25},{40.11,30.76},{38.3,33.53},{37.58,30.89},{36.67,31.87},{35.2,35.01},{34.08,35.27},{34.91,35.73},{33.15,37.82},{31.2,39.56},{31.2,39.38},{29.33,39.59},{30.13,40.08},{27.6,42.51},{25.7,46.92},{26.76,47.83},{27.55,54.76},{29.1,54.19},{28.64,53.56},{28.29,53.58},{29.09,49.7},{28.17,48.92},{28.15,44.98},{28.23,39.97},{29.49,50.82},{34.39,47.66},{32.59,48.46},{35.36,36.37},{37.56,36.76},{36.74,37.57},{38.39,38.39},{48.45,61.94},{49.55,61.8},{49.94,60.21},{48.29,56.53},{49.31,60.56},{53.81,57.75},{54.66,57.2},{53.91,56.54},{55.23,58.96},{56.47,57.98},{55.85,60.42},{56.48,54.94},{57.07,56.26},{56.08,52.66},{56.34,52.21},{59.46,55.87},{57.81,55.81},{58.49,59.65},{59.54,61.02},{59.44,60.81},{59.09,58.64},{60.06,58.83},{60.35,60.02},{61.24,59.62},{59.96,58.02},{61.84,57.01},{62.66,59.16},{62.34,56.58},{62.95,57.33},{63.58,60.22},{82.22,37.6},{80.36,35.94},{78.96,36.29},{79.23,35.36},{79.05,37.2}}},nil,1,nil,nil,66,nil,nil,0},
[1202] = {'Tunnel Rat Kobold',222,222,11,11,0,{[38]={{37.0,24.66},{25.48,43.71},{25.53,43.36},{26.21,43.96},{25.71,42.8},{26.46,43.81},{26.21,44.13},{35.77,16.62},{35.45,17.21},{35.19,17.08},{39.44,12.96},{37.69,16.99},{39.77,12.36},{39.29,12.07}}},nil,38,nil,nil,26,nil,nil,0},
[1203] = {'Watcher Sarys',3660,3660,35,35,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1204] = {'Watcher Corwin',4185,4185,38,38,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1205] = {'Grawmug',386,386,17,17,0,{[38]={{34.77,90.45}}},nil,38,nil,nil,59,nil,nil,0},
[1206] = {'Gnasher',356,356,16,16,0,{[38]={{34.71,90.82}}},nil,38,nil,nil,59,nil,nil,0},
[1207] = {'Brawler',356,356,16,16,0,{[38]={{34.64,90.55}}},nil,38,nil,nil,59,nil,nil,0},
[1210] = {'Chok\'sul',1686,1686,22,22,1,{[38]={{79.59,14.7}}},nil,38,nil,nil,14,nil,nil,0},
[1211] = {'Leper Gnome',156,198,8,10,0,{[1]={{27.62,36.41},{28.05,36.68},{27.19,36.84},{27.25,36.39},{27.65,36.43},{27.68,36.95},{27.25,37.31},{27.39,35.81},{28.1,35.94},{26.84,36.34},{26.13,37.01},{26.65,36.6},{25.94,37.86},{26.87,35.69},{26.31,35.65},{24.71,39.38},{25.31,39.78},{26.7,41.85},{24.89,40.07},{26.04,40.76},{24.25,39.63},{24.24,39.91},{24.7,41.69},{26.13,42.71},{24.79,42.89},{25.69,42.98},{24.7,42.98},{27.25,42.99},{26.77,43.79},{26.7,42.78},{26.02,43.69},{24.44,43.08},{24.75,43.82},{24.43,43.63},{25.5,43.71},{24.78,42.81},{25.18,44.38},{25.56,45.29},{25.46,44.83},{24.71,44.65},{23.98,43.41}}},nil,1,nil,nil,63,nil,nil,0},
[1212] = {'Bishop Farthing',1752,1752,40,40,0,{[1519]={{39.1,27.86}}},nil,1519,{270},{269},12,"A",nil,2},
[1213] = {'Godric Rothgar',102,102,5,5,0,{[12]={{47.69,41.42}}},nil,12,nil,nil,12,"A","Armorer & Shieldcrafter",16388},
[1214] = {'Aldren Cordon',417,417,18,18,0,{[38]={{64.82,66.05}}},nil,38,nil,nil,55,"A","Clothier",16388},
[1215] = {'Alchemist Mallory',787,787,26,26,0,{[12]={{39.84,48.23}}},nil,12,nil,nil,12,"A","Journeyman Alchemist",19},
[1216] = {'Shore Crawler',386,417,17,18,0,{[40]={{25.56,64.67},{25.78,63.68},{25.72,67.26},{25.32,63.91},{25.75,65.5},{25.27,64.73},{25.69,66.77},{26.3,66.96},{25.93,66.19},{25.41,65.71},{30.71,81.88},{32.03,82.69},{29.93,81.51},{29.46,79.28},{35.85,87.9},{30.64,83.0},{30.05,80.51},{29.5,78.42},{29.16,80.52},{28.77,77.79},{28.96,78.66},{36.73,88.41}}},nil,40,nil,nil,7,"AH",nil,0},
[1217] = {'Glorin Steelbrow',712,712,25,25,0,{[11]={{10.58,60.59}}},nil,11,{293,321,322,526},{270,292,324,526},55,"A",nil,2},
[1218] = {'Herbalist Pomeroy',198,198,10,10,0,{[12]={{39.96,48.41}}},nil,12,nil,nil,12,"A","Herbalism Trainer",16},
[1222] = {'Dark Iron Sapper',386,386,17,17,0,{[38]={{56.25,12.89},{56.4,13.15}}},nil,38,nil,nil,54,nil,nil,0},
[1224] = {'Young Threshadon',449,484,19,20,0,{[38]={{53.67,46.91},{51.62,61.54},{54.24,60.96},{59.83,50.22},{49.17,46.93},{48.73,61.96},{58.57,54.72},{58.92,46.93},{51.53,47.19},{57.9,50.35},{56.63,46.84},{48.79,33.75},{57.56,43.85},{50.66,50.44},{48.29,38.35},{48.11,50.69},{50.24,57.89},{44.81,39.84},{45.56,50.52},{45.13,41.02},{48.07,39.84}}},nil,38,nil,nil,16,nil,nil,0},
[1225] = {'Ol\' Sooty',1452,1452,20,20,1,{[38]={{37.92,63.38}}},{[38]={{{42.47,64.67},{41.82,65.0},{40.5,66.79},{39.85,66.79},{39.75,66.58},{39.83,66.21},{40.49,64.92},{40.91,63.71},{41.0,62.63},{40.5,61.46},{39.97,61.64},{39.33,62.23},{38.51,62.1},{37.82,62.77},{36.73,60.99},{37.8,62.85},{38.55,62.12},{38.85,62.1},{39.32,62.37},{40.14,61.59},{40.72,61.81},{41.01,62.92},{40.89,63.78},{40.53,64.62},{40.21,65.47},{39.69,66.55},{40.07,66.87},{41.28,66.19},{41.82,65.0},{42.47,64.67},{43.19,64.77}}}},38,nil,nil,44,nil,nil,0},
[1226] = {'Maxan Anvol',198,198,10,10,0,{[1]={{47.34,52.19}}},nil,1,{5625,5630,5635},{5625,5626},55,"A","Priest Trainer",19},
[1227] = {'Rygal Rocknell',1220,1220,35,35,0,nil,nil,0,nil,nil,29,"H","iCoke Redemption Vendor",0},
[1228] = {'Magis Sparkmantle',198,198,10,10,0,{[1]={{47.5,52.08}}},nil,1,{1879},nil,875,"A","Mage Trainer",19},
[1229] = {'Granis Swiftaxe',198,198,10,10,0,{[1]={{47.36,52.65}}},nil,1,{1679},nil,55,"A","Warrior Trainer",19},
[1231] = {'Grif Wildheart',247,247,12,12,0,{[1]={{45.81,53.04}}},nil,1,{6064,6084,6085,6086},{6064,6074,6075,6076,6084,6085},55,"A","Hunter Trainer",19},
[1232] = {'Azar Stronghammer',247,247,12,12,0,{[1]={{47.6,52.07}}},nil,1,{2997},nil,55,"A","Paladin Trainer",19},
[1234] = {'Hogral Bakkan',247,247,12,12,0,{[1]={{47.56,52.61}}},nil,1,{2218,2299},nil,55,"A","Rogue Trainer",19},
[1236] = {'Kobold Digger',247,273,12,13,0,{[40]={{44.8,23.12},{45.33,18.46},{44.76,20.61},{44.62,19.99},{45.32,20.46},{46.15,19.4},{46.07,18.29}}},nil,40,nil,nil,26,nil,nil,0},
[1237] = {'Kazan Mogosh',156,156,8,8,0,{[1]={{68.61,54.64}}},nil,1,nil,nil,55,"A","Food & Drink Merchant",6},
[1238] = {'Gamili Frosthide',176,176,9,9,0,{[1]={{45.18,51.93}}},nil,1,nil,nil,55,"A","Cloth & Leather Armor Merchant",16388},
[1239] = {'First Mate Fitzsimmons',1002,1002,30,30,0,{[11]={{10.9,59.64}}},nil,11,{288,289,290,463},{288,289},12,"A",nil,2},
[1240] = {'Boran Ironclink',176,176,9,9,0,{[1]={{45.16,51.75}}},nil,1,nil,nil,55,"A","Armorer",16388},
[1241] = {'Tognus Flintfire',1002,1002,30,30,0,{[1]={{45.34,51.94}}},{[1]={{{45.34,51.94},{45.32,51.92}}}},1,nil,nil,55,"A","Journeyman Blacksmith",19},
[1242] = {'Karl Boran',1002,1002,30,30,0,{[11]={{8.32,58.57}}},nil,11,{279,281},{279,286},12,"A",nil,2},
[1243] = {'Hegnar Rumbleshot',176,176,9,9,0,{[1]={{40.68,65.13}}},nil,1,nil,{5541},55,"A","Gunsmith",7},
[1244] = {'Rethiel the Greenwarden',1002,1002,30,30,0,{[11]={{56.37,40.4}}},nil,11,{275,276,277},{275,276,277,463},12,"A",nil,2},
[1245] = {'Kogan Forgestone',198,198,10,10,0,{[1]={{45.32,51.75}}},{[1]={{{45.35,51.73},{45.32,51.75}}}},1,nil,nil,57,"A",nil,2},
[1246] = {'Vosur Brakthel',1002,1002,30,30,0,{[1537]={{66.33,55.69}}},nil,1537,nil,nil,55,"A","Journeyman Alchemist",17},
[1247] = {'Innkeeper Belm',1002,1002,30,30,0,{[1]={{47.38,52.52}}},nil,1,nil,nil,55,"A","Innkeeper",135},
[1249] = {'Quartermaster Hudson',156,156,8,8,0,{[12]={{25.23,74.07}}},nil,12,nil,nil,12,"A","Armorer & Shieldcrafter",16388},
[1250] = {'Drake Lindgren',198,198,10,10,0,{[12]={{83.31,66.69}}},nil,12,nil,nil,12,"A","General & Trade Supplies",4},
[1251] = {'Splinter Fist Firemonger',702,739,28,29,0,{[10]={{36.5,77.37},{37.78,79.69},{37.06,82.4},{37.34,84.15},{33.93,71.92},{33.96,73.94}}},nil,10,nil,nil,45,nil,nil,0},
[1252] = {'Senir Whitebeard',156,156,8,8,0,{[1]={{46.73,53.83}}},nil,1,{287,291},{287,420},55,"A",nil,2},
[1253] = {'Father Gavin',328,328,15,15,0,{[1]={{57.73,44.88}}},nil,1,nil,nil,794,"AH","The Argent Dawn",0},
[1254] = {'Foreman Stonebrow',247,247,12,12,0,{[1]={{69.08,56.33}}},nil,1,{432},{432},55,"A","Miners' League",2},
[1255] = {'Prospector Gehn',247,247,12,12,0,{[1]={{68.96,54.61}}},nil,1,nil,nil,55,"A","Explorers' League",0},
[1256] = {'Quarrymaster Thesten',198,198,10,10,0,{[1]={{69.16,54.8}}},nil,1,nil,nil,55,"A","Miners' League",2},
[1257] = {'Keldric Boucher',1002,1002,30,30,0,{[1519]={{55.73,65.39}}},nil,1519,nil,nil,12,"A","Arcane Goods Vendor",5},
[1258] = {'Black Ravager Mastiff',734,788,25,26,0,{[10]={{69.5,38.23},{67.24,35.11},{65.98,32.83},{65.5,31.25},{63.33,27.72},{50.81,60.54}}},nil,10,nil,nil,38,nil,nil,0},
[1259] = {'Gobbler',573,573,22,22,0,{[11]={{18.07,39.84}}},nil,11,nil,nil,18,nil,nil,0},
[1260] = {'Great Father Arctikus',208,208,11,11,4,{[1]={{22.78,52.08},{21.59,51.79},{22.49,54.24},{23.81,51.02},{24.15,52.56},{23.45,54.63}}},nil,1,nil,nil,37,nil,nil,0},
[1261] = {'Veron Amberstill',198,198,10,10,0,{[1]={{63.47,50.56}}},{[1]={{{63.47,50.56},{63.46,50.63}}}},1,{7673,7674},{7673,7674},55,"A","Ram Breeder",135},
[1262] = {'White Ram',191,191,30,30,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1263] = {'Yarlyn Amberstill',42,42,1,1,0,{[1]={{63.12,50.88}}},nil,1,nil,nil,55,"A",nil,6},
[1265] = {'Rudra Amberstill',197,197,10,10,0,{[1]={{63.08,49.85}}},nil,1,{314},{314},55,"A",nil,2},
[1266] = {'Tundra MacGrann',484,484,20,20,0,{[1]={{34.57,51.65}}},nil,1,{312},{312},57,"A",nil,2},
[1267] = {'Ragnar Thunderbrew',1002,1002,30,30,0,{[1]={{46.83,52.36}}},nil,1,{384,4126},{384,4126,4128},55,"A",nil,2},
[1268] = {'Ozzie Togglevolt',198,198,10,10,0,{[1]={{45.89,49.39}}},nil,1,{2926,2962},{2926,2927,2962},875,"A",nil,2},
[1269] = {'Razzle Sprysprocket',484,484,20,20,0,{[1]={{45.85,49.37}}},nil,1,{412},{412},875,"A",nil,2},
[1270] = {'Fetid Corpse',950,1003,29,30,0,{[10]={{78.92,33.65},{76.34,37.15},{78.18,34.92},{78.72,36.07},{75.54,35.72},{75.23,36.79},{77.86,33.54},{75.82,33.96},{77.37,35.1},{76.94,32.71},{76.69,30.47},{79.19,31.25},{81.38,32.51},{79.85,32.94}}},nil,10,nil,nil,21,nil,nil,0},
[1271] = {'Old Icebeard',666,666,11,11,1,{[1]={{38.54,54.18}}},{[1]={{{38.25,53.98},{37.78,53.69},{37.3,53.28},{37.14,53.23},{37.2,52.91},{37.22,52.51},{37.32,51.92},{37.55,51.61},{37.81,51.16},{37.97,50.82},{37.68,51.36},{37.4,51.75},{37.32,52.18},{37.29,52.57},{37.37,52.94},{37.48,53.44},{37.59,53.54},{37.8,53.68},{38.05,53.84},{38.47,54.12},{38.59,54.23},{38.52,54.17},{38.45,54.13},{38.52,54.16}}}},1,nil,nil,16,nil,nil,0},
[1273] = {'Grawn Thromwyn',198,198,10,10,0,{[1]={{45.29,52.19}}},nil,1,nil,nil,55,"A","Weaponsmith",16388},
[1274] = {'Senator Barin Redstone',2768,2768,50,50,0,{[1537]={{39.55,57.49}}},nil,1537,nil,{291},55,"A",nil,2},
[1275] = {'Kyra Boucher',1002,1002,30,30,0,{[1519]={{56.13,65.27}}},nil,1519,nil,nil,12,"A","Reagent Vendor",5},
[1276] = {'Mountaineer Brokk',1910,1910,30,30,0,{[38]={{25.89,10.62}}},{[38]={{{25.89,10.62},{25.66,10.65},{25.56,11.31},{25.56,11.65},{25.58,12.26},{25.57,12.96},{25.64,13.4},{25.73,14.0},{25.88,14.71},{25.95,15.11},{25.99,16.01},{26.0,16.95},{26.0,17.84},{26.02,18.76},{26.05,19.38},{26.16,20.12},{26.32,21.08},{26.45,21.7},{26.6,22.38},{26.81,23.13},{26.63,22.39},{26.49,21.72},{26.36,21.13},{26.19,20.17},{26.09,19.39},{26.05,18.77},{26.03,17.87},{26.02,16.97},{26.03,16.05},{25.97,15.22},{25.86,14.53},{25.72,13.92},{25.65,13.28},{25.64,12.95},{25.59,12.31},{25.56,11.44},{25.66,11.02}}}},38,nil,nil,57,"A",nil,2},
[1277] = {'Mountaineer Ganin',1910,1910,30,30,0,{[38]={{24.16,20.27}}},{[38]={{{24.27,20.35},{24.81,20.92},{25.48,21.66},{25.97,22.33},{26.65,23.16},{26.03,22.44},{25.38,21.67},{24.89,21.1},{24.3,20.38},{23.65,19.82},{22.83,19.18},{22.18,18.59},{21.35,17.96},{20.48,17.27},{20.03,17.08},{19.46,17.08},{20.04,17.03},{20.92,17.66},{21.56,18.18},{22.66,19.02},{23.48,19.69},{24.07,20.16}}}},38,nil,nil,57,"A",nil,2},
[1278] = {'Mountaineer Stenn',1706,1706,28,28,0,{[38]={{31.95,48.81}}},{[38]={{{31.95,48.81},{32.28,49.27},{32.46,49.42},{32.52,49.61},{32.28,49.74},{32.19,49.44},{31.94,48.82},{31.68,48.31},{31.46,47.83},{31.37,47.33},{31.33,46.71},{31.44,45.39},{31.56,44.77},{31.78,44.02},{32.04,43.39},{32.22,42.82},{32.27,42.15},{32.28,41.32},{32.16,40.91},{31.63,39.88},{31.24,39.04},{31.05,38.28},{30.85,36.92},{31.05,38.29},{31.22,38.91},{31.46,39.53},{31.81,40.25},{32.2,40.97},{32.26,41.28},{32.31,41.83},{32.24,42.64},{32.17,43.08},{31.96,43.57},{31.74,44.11},{31.4,45.69},{31.34,46.66},{31.4,47.43},{31.44,47.77},{31.58,48.1}}}},38,nil,nil,57,"A",nil,2},
[1279] = {'Mountaineer Flint',1910,1910,30,30,0,{[38]={{29.57,30.2}}},{[38]={{{29.59,30.25},{29.81,30.83},{30.0,31.54},{30.37,33.41},{30.49,34.59},{30.66,35.78},{30.85,37.03},{31.07,38.38},{31.34,39.27},{31.51,39.63},{31.16,38.99},{31.0,38.05},{30.89,37.31},{30.57,35.08},{30.39,33.48},{30.25,32.74},{29.96,31.3},{29.72,30.63},{29.07,29.0},{28.69,27.67},{28.54,26.95},{28.09,25.44},{27.78,24.84},{27.22,23.84},{26.89,23.25},{26.68,22.75},{26.5,22.67},{26.54,23.03},{26.85,23.64},{27.37,24.42},{27.86,25.39},{28.18,26.25},{28.54,27.48},{28.89,28.73},{29.37,29.7}}}},38,nil,nil,57,"A",nil,2},
[1280] = {'Mountaineer Droken',1706,1706,28,28,0,{[38]={{32.28,51.43}}},{[38]={{{32.11,52.65},{31.99,53.28},{31.93,53.77},{31.88,54.36},{31.79,54.99},{31.69,55.57},{31.62,56.13},{31.53,56.53},{31.45,56.88},{31.21,57.28},{30.99,57.54},{30.76,57.84},{30.41,58.31},{30.08,58.77},{29.9,59.07},{29.75,59.4},{29.53,60.0},{30.01,58.89},{30.5,58.21},{31.07,57.53},{31.43,57.01},{31.54,56.65},{31.77,55.03},{31.89,53.98},{32.09,52.75},{32.28,51.43},{32.29,50.58},{32.37,50.36},{32.48,50.26},{32.37,50.36},{32.29,50.58},{32.28,51.43}}}},38,nil,nil,57,"A",nil,2},
[1281] = {'Mountaineer Zaren',1706,1706,28,28,0,{[38]={{22.78,70.76}}},{[38]={{{22.91,70.62},{23.26,70.4},{23.63,69.87},{24.08,69.18},{24.58,68.43},{24.31,68.83},{23.82,69.58},{23.45,70.12},{23.13,70.57},{22.66,70.4},{22.39,70.13},{22.51,70.71},{22.38,71.46},{21.96,72.12},{21.55,72.82},{21.17,73.59},{20.52,75.04},{20.89,74.28},{21.33,73.27},{21.76,72.49},{22.24,71.83},{22.93,70.85}}}},38,nil,nil,57,"A",nil,2},
[1282] = {'Mountaineer Veek',1910,1910,30,30,0,{[38]={{21.4,67.33}}},{[38]={{{21.46,67.04},{21.54,66.52},{21.5,65.92},{21.23,65.03},{20.93,64.4},{20.73,64.11},{20.3,63.49},{20.03,63.1},{19.82,62.9},{20.26,63.39},{20.56,63.85},{20.93,64.33},{21.21,64.83},{21.41,65.66},{21.53,66.25},{21.51,66.77},{21.35,67.59},{21.33,68.22},{21.52,68.73},{21.95,69.21},{22.24,69.94},{22.06,69.45},{21.64,68.81},{21.32,68.11},{21.36,67.55}}}},38,nil,nil,57,"A",nil,2},
[1283] = {'Mountaineer Kalmir',1910,1910,30,30,0,{[38]={{21.31,73.29}}},{[38]={{{21.6,72.77},{21.96,72.2},{22.45,71.52},{21.86,72.34},{21.41,73.12},{21.16,73.54},{20.72,74.63},{20.46,75.17},{20.13,75.75},{19.88,76.28},{19.73,76.71},{19.64,77.1},{19.55,77.79},{19.52,78.51},{19.46,79.13},{19.36,79.94},{19.23,80.69},{19.09,81.42},{18.87,82.22},{18.62,82.78},{18.41,83.22},{18.04,83.47},{18.38,83.31},{18.73,82.57},{18.91,82.05},{19.07,81.47},{19.24,80.55},{19.42,79.41},{19.52,78.59},{19.55,77.63},{19.64,77.06},{19.76,76.62},{19.9,76.19},{20.46,75.18},{20.75,74.58},{21.02,73.89},{21.31,73.29}}}},38,nil,nil,57,"A",nil,2},
[1284] = {'Archbishop Benedictus',466400,466400,63,63,3,{[1519]={{39.59,27.19}}},nil,1519,{3636},{293,3636},12,"A",nil,2},
[1285] = {'Thurman Mullby',1002,1002,30,30,0,{[1519]={{58.37,61.68}}},nil,1519,nil,nil,12,"A","General Goods Vendor",5},
[1286] = {'Edna Mullby',1002,1002,30,30,0,{[1519]={{58.23,60.51}}},nil,1519,nil,nil,12,"A","Trade Supplier",5},
[1287] = {'Marda Weller',1002,1002,30,30,0,{[1519]={{57.38,56.77}}},nil,1519,nil,nil,12,"A","Weapons Merchant",16389},
[1289] = {'Gunther Weller',1002,1002,30,30,0,{[1519]={{57.55,57.07}}},nil,1519,nil,nil,12,"A","Weapons Merchant",16389},
[1291] = {'Carla Granger',1002,1002,30,30,0,{[1519]={{54.73,56.03}}},nil,1519,nil,nil,12,"A","Cloth Armor Merchant",16388},
[1292] = {'Maris Granger',1342,1342,35,35,0,{[1519]={{67.81,48.82}}},nil,1519,nil,nil,12,"A","Skinning Trainer",17},
[1294] = {'Aldric Moore',1002,1002,30,30,0,{[1519]={{54.58,55.24}}},nil,1519,nil,nil,12,"A","Mail Armor Merchant",16389},
[1295] = {'Lara Moore',1002,1002,30,30,0,{[1519]={{54.66,55.62}}},nil,1519,nil,nil,12,"A","Leather Armor Merchant",16389},
[1296] = {'Felder Stover',3082,3082,52,52,0,{[46]={{85.21,68.39}}},nil,46,nil,nil,12,"A","Weaponsmith",16388},
[1297] = {'Lina Stover',1002,1002,30,30,0,{[1519]={{50.46,57.23}}},nil,1519,nil,nil,12,"A","Bow & Gun Merchant",16389},
[1298] = {'Frederick Stover',1002,1002,30,30,0,{[1519]={{49.98,57.64}}},nil,1519,nil,nil,12,"A","Bow & Arrow Merchant",16389},
[1299] = {'Lisbeth Schneider',1002,1002,30,30,0,{[1519]={{49.92,55.2}}},nil,1519,nil,nil,12,"A","Clothier",16389},
[1300] = {'Lawrence Schneider',712,712,25,25,0,{[1519]={{43.69,73.71}}},nil,1519,nil,nil,12,"A","Journeyman Tailor",17},
[1301] = {'Julia Gallina',1002,1002,30,30,0,{[1519]={{52.02,68.83}}},nil,1519,nil,nil,12,"A","Wine Vendor",5},
[1302] = {'Bernard Gump',1002,1002,30,30,0,{[1519]={{64.06,61.26}}},nil,1519,nil,nil,12,"A","Florist",5},
[1303] = {'Felicia Gump',1002,1002,30,30,0,{[1519]={{64.19,60.6}}},nil,1519,nil,nil,12,"A","Herbalism Supplier",5},
[1304] = {'Darian Singh',1002,1002,30,30,0,{[1519]={{29.42,67.83}}},nil,1519,nil,nil,12,"A","Fireworks Vendor",5},
[1305] = {'Jarel Moor',1002,1002,30,30,0,{[1519]={{28.81,75.32}}},nil,1519,nil,nil,12,"A","Bartender",5},
[1307] = {'Charys Yserian',2768,2768,50,50,0,{[1519]={{32.19,79.9}}},nil,1519,nil,nil,12,"A","Arcane Trinkets Vendor",5},
[1308] = {'Owen Vaughn',1002,1002,30,30,0,{[1519]={{35.88,74.99}}},nil,1519,nil,nil,12,"A","Reagent Vendor",5},
[1309] = {'Wynne Larson',1002,1002,30,30,0,{[1519]={{41.57,76.35}}},nil,1519,{1941,1942},{1921,1940,1941,1942},12,"A","Robe Merchant",16391},
[1310] = {'Evan Larson',1002,1002,30,30,0,{[1519]={{42.62,76.57}}},nil,1519,nil,nil,12,"A","Hatter",16389},
[1311] = {'Joachim Brenlow',1002,1002,30,30,0,{[1519]={{41.06,90.03}}},nil,1519,nil,nil,12,"A","Bartender",5},
[1312] = {'Ardwyn Cailen',1002,1002,30,30,0,{[1519]={{42.88,65.11}}},nil,1519,nil,nil,12,"A","Wand Merchant",16389},
[1313] = {'Maria Lumere',1002,1002,30,30,0,{[1519]={{46.81,79.09}}},nil,1519,nil,nil,12,"A","Alchemy Supplies",5},
[1314] = {'Duncan Cullen',1002,1002,30,30,0,{[1519]={{43.3,74.45}}},nil,1519,nil,nil,12,"A","Light Armor Merchant",16389},
[1315] = {'Allan Hafgan',1002,1002,30,30,0,{[1519]={{43.08,65.22}}},nil,1519,nil,nil,12,"A","Staves Merchant",16389},
[1316] = {'Adair Gilroy',4120,4120,60,60,0,{[1519]={{41.56,65.45}}},nil,1519,nil,nil,12,"A","Librarian",4},
[1317] = {'Lucan Cordell',1342,1342,35,35,0,{[1519]={{42.94,64.65}}},nil,1519,nil,nil,12,"A","Expert Enchanter",17},
[1318] = {'Jessara Cordell',1002,1002,30,30,0,{[1519]={{42.81,64.39}}},nil,1519,nil,nil,12,"A","Enchanting Supplies",5},
[1319] = {'Bryan Cross',1002,1002,30,30,0,{[1519]={{63.99,42.91}}},nil,1519,nil,nil,12,"A","Shield Merchant",16389},
[1320] = {'Seoman Griffith',1002,1002,30,30,0,{[1519]={{67.45,48.53}}},nil,1519,nil,nil,12,"A","Leather Armor Merchant",16389},
[1321] = {'Alyssa Griffith',1002,1002,30,30,0,{[1519]={{67.22,48.81}}},nil,1519,nil,nil,12,"A","Bag Vendor",5},
[1322] = {'Maxton Strang',1752,1752,40,40,0,{[405]={{67.93,8.31}}},nil,405,nil,nil,12,"A","Mail Armor Merchant",16388},
[1323] = {'Osric Strang',1002,1002,30,30,0,{[1519]={{74.31,47.24}}},nil,1519,{6261},{6281},12,"A","Heavy Armor Merchant",16391},
[1324] = {'Heinrich Stone',1002,1002,30,30,0,{[1519]={{74.37,42.56}}},nil,1519,nil,nil,12,"A","Blade Merchant",16389},
[1325] = {'Jasper Fel',1002,1002,30,30,0,{[1519]={{78.32,58.98}}},nil,1519,nil,nil,12,"A","Shady Dealer",5},
[1326] = {'Sloan McCoy',712,712,25,25,0,{[1519]={{76.19,59.99}}},nil,1519,nil,nil,12,"A","Poison Supplier",5},
[1327] = {'Reese Langston',1002,1002,30,30,0,{[1519]={{74.14,36.53}}},nil,1519,nil,nil,12,"A","Tavernkeeper",1},
[1328] = {'Elly Langston',4120,4120,60,60,0,{[1519]={{73.41,38.6}}},{[1519]={{{73.87,36.93},{74.16,37.5},{74.01,37.99},{73.37,38.59},{73.41,38.9},{73.71,38.93},{74.18,38.35},{74.68,37.76},{74.84,37.57},{74.79,37.09},{73.93,35.83},{73.76,35.79},{73.31,36.33},{72.76,37.06},{72.71,37.54},{72.93,37.58},{73.58,36.83}}}},1519,nil,nil,12,"A","Barmaid",4},
[1329] = {'Mountaineer Naarh',1910,1910,30,30,0,{[38]={{23.24,76.04}}},{[38]={{{23.24,76.04},{23.17,76.49},{22.82,77.12},{22.29,77.31},{21.96,77.07},{21.58,76.58},{21.19,76.07},{20.69,75.46},{21.22,76.13},{21.55,76.54},{22.06,77.2},{22.44,77.32},{22.76,77.15},{23.24,76.49}}}},38,nil,nil,57,"A",nil,2},
[1330] = {'Mountaineer Tyraw',1910,1910,30,30,0,{[38]={{22.85,74.06}}},{[38]={{{22.85,74.06},{22.8,74.36},{22.86,74.55},{23.0,74.57},{23.31,74.25},{23.37,74.03},{23.23,73.7},{23.08,73.63},{22.98,73.71},{23.0,73.94},{23.3,74.54},{23.84,75.75},{23.31,74.55},{23.01,73.94},{22.99,73.75},{23.11,73.63},{23.24,73.72},{23.37,74.0},{23.31,74.24},{23.0,74.57},{22.85,74.54},{22.8,74.33}}}},38,nil,nil,57,"A",nil,2},
[1331] = {'Mountaineer Luxst',1910,1910,30,30,0,{[38]={{24.17,17.57}}},nil,38,nil,nil,57,"A",nil,2},
[1332] = {'Mountaineer Morran',1910,1910,30,30,0,{[38]={{23.28,17.14}}},{[38]={{{23.35,17.03},{23.49,16.83},{23.67,16.67},{24.01,16.43},{24.4,16.34},{24.79,16.42},{25.05,16.56},{25.29,16.76},{25.52,16.99},{25.72,17.16},{25.52,16.99},{25.29,16.76},{25.08,16.58},{24.79,16.43},{24.42,16.34},{24.03,16.42},{23.7,16.65},{23.51,16.81},{23.36,16.99},{23.29,17.12},{23.28,17.29},{23.29,17.76},{23.5,17.88},{23.64,17.91},{24.0,17.94},{24.24,17.95},{24.46,17.96},{24.74,18.0},{24.76,18.0},{24.82,17.92},{24.8,17.75},{24.74,17.58},{24.67,17.49},{24.74,17.58},{24.8,17.75},{24.83,17.9},{24.77,18.0},{24.57,17.99},{24.25,17.95},{24.0,17.93},{23.72,17.91},{23.43,17.93},{23.3,17.8},{23.27,17.6},{23.28,17.3},{23.28,17.15}}}},38,nil,nil,57,"A",nil,2},
[1333] = {'Gerik Koen',1002,1002,30,30,0,{[1519]={{68.92,42.67}}},nil,1519,nil,nil,12,"A","Two Handed Weapon Merchant",16389},
[1334] = {'Mountaineer Hammerfall',1910,1910,30,30,0,{[38]={{24.49,18.5}}},nil,38,nil,nil,57,"A",nil,2},
[1335] = {'Mountaineer Yuttha',1910,1910,30,30,0,{[38]={{24.74,17.71}}},nil,38,nil,nil,57,"A",nil,2},
[1336] = {'Mountaineer Zwarn',1910,1910,30,30,0,{[38]={{25.62,18.11}}},nil,38,nil,nil,57,"A",nil,2},
[1337] = {'Mountaineer Gwarth',1706,1706,28,28,0,{[38]={{35.93,44.49}}},nil,38,nil,nil,57,"A",nil,2},
[1338] = {'Mountaineer Dalk',1706,1706,28,28,0,{[38]={{36.46,41.22}}},nil,38,nil,nil,57,"A",nil,2},
[1339] = {'Mayda Thane',2165,2165,48,48,0,{[1519]={{67.22,43.62}}},nil,1519,nil,nil,12,"A","Cobbler",16389},
[1340] = {'Mountaineer Kadrell',1910,1910,30,30,0,{[38]={{34.17,47.84}}},{[38]={{{34.17,47.84},{33.61,48.68},{33.19,49.21},{32.93,49.47},{32.67,49.72},{32.97,49.5},{33.33,49.12},{33.79,48.49},{34.25,47.72},{34.67,47.22},{35.1,46.96},{35.62,46.73},{36.06,46.39},{36.45,46.25},{36.83,46.18},{37.17,45.97},{37.29,45.73},{37.34,45.27},{37.37,44.54},{37.31,43.42},{36.98,42.5},{36.73,41.98},{37.06,42.69},{37.25,43.18},{37.31,43.77},{37.35,44.52},{37.39,45.07},{37.36,45.55},{37.22,45.89},{36.96,46.16},{36.54,46.25},{36.09,46.33},{35.84,46.54},{35.51,46.79},{35.06,46.92},{34.55,47.29}}}},38,{416,467,468,1339},{414,416},55,"A",nil,3},
[1341] = {'Wilhelm Strang',1002,1002,30,30,0,{[1519]={{74.75,47.64}}},nil,1519,nil,nil,12,"A","Mail Armor Merchant",16389},
[1342] = {'Mountaineer Rockgar',1910,1910,30,30,0,{[38]={{25.44,10.38}}},nil,38,{455},{468},55,"A",nil,2},
[1343] = {'Mountaineer Stormpike',1910,1910,30,30,0,{[38]={{24.76,18.4}}},nil,38,{307,1338},{307,353,1339},55,"A",nil,2},
[1344] = {'Prospector Ironband',328,328,15,15,0,{[38]={{65.93,65.62}}},nil,38,{298,704,738},{309,704,707,739},55,"A",nil,2},
[1345] = {'Magmar Fellhew',328,328,15,15,0,{[38]={{64.9,66.66}}},nil,38,{297},{297,436},55,"A",nil,2},
[1346] = {'Georgio Bolero',2398,2398,46,46,0,{[1519]={{43.17,73.55}}},nil,1519,nil,nil,12,"A","Artisan Tailor",17},
[1347] = {'Alexandra Bolero',1002,1002,30,30,0,{[1519]={{43.25,74.08}}},nil,1519,nil,nil,12,"A","Tailoring Supplies",5},
[1348] = {'Gregory Ardus',1002,1002,30,30,0,{[1519]={{36.77,39.65}}},nil,1519,nil,nil,12,"A","Staff & Mace Merchant",16389},
[1349] = {'Agustus Moulaine',1002,1002,30,30,0,{[1519]={{43.73,42.81}}},nil,1519,nil,nil,12,"A","Mail Armor Merchant",16389},
[1350] = {'Theresa Moulaine',1002,1002,30,30,0,{[1519]={{43.34,43.29}}},nil,1519,nil,nil,12,"A","Robe Vendor",16389},
[1351] = {'Brother Cassius',1002,1002,30,30,0,{[1519]={{43.5,26.97}}},nil,1519,nil,nil,12,"A","Reagent Vendor",5},
[1352] = {'Fluffy',8,8,1,1,0,{[1]={{63.02,50.83}}},{[1]={{{62.9,50.92},{62.72,51.11},{62.61,51.37},{62.66,51.61},{62.83,51.69},{63.32,50.97},{63.38,50.63},{63.3,50.27},{63.19,49.75},{63.14,49.32},{63.33,49.0},{63.57,48.91},{64.02,49.34},{64.24,49.62},{64.63,49.81},{64.78,50.15},{64.85,50.41},{65.02,50.54},{65.17,50.47},{65.22,50.23},{65.13,49.93},{64.62,49.8},{64.24,49.6},{64.02,49.34},{63.57,48.91},{63.33,49.0},{63.15,49.31},{63.19,49.76},{63.3,50.27},{63.3,50.56},{63.17,50.75}}}},1,nil,nil,55,"A",nil,0},
[1353] = {'Sarltooth',950,950,29,29,0,{[11]={{33.26,51.51}}},nil,11,nil,nil,48,nil,nil,0},
[1354] = {'Apprentice Soren',71,71,3,3,0,{[1]={{25.18,75.89}}},nil,1,nil,nil,55,"A",nil,0},
[1355] = {'Cook Ghilm',176,176,9,9,0,{[1]={{68.38,54.49}}},{[1]={{{68.4,54.45},{68.38,54.49}}}},1,nil,nil,55,"A","Cooking Trainer",19},
[1356] = {'Prospector Stormpike',1002,1002,30,30,0,{[1537]={{74.64,11.74}}},nil,1537,{302,525,707,2398},{301,514,554,2240},55,"A",nil,2},
[1358] = {'Miner Grothor',156,156,8,8,0,{[1]={{69.15,55.2}}},nil,1,nil,nil,57,"A",nil,2},
[1360] = {'Miner Grumnal',176,176,9,9,0,{[1]={{69.01,55.08}}},nil,1,nil,nil,57,"A",nil,2},
[1362] = {'Gothor Brumn',417,417,18,18,0,{[38]={{24.13,18.21}}},nil,38,nil,nil,55,"A","Armorer",16388},
[1364] = {'Balgaras the Foul',4835,4835,34,34,1,{[11]={{60.0,24.93},{62.14,28.3},{60.0,24.93},{47.42,15.18},{62.38,28.97},{61.71,26.18},{46.69,18.58}}},nil,11,nil,nil,54,nil,nil,0},
[1365] = {'Goli Krumn',198,198,10,10,0,{[1537]={{30.26,59.38}}},nil,1537,{7062},nil,55,"A",nil,3},
[1366] = {'Adam',42,42,1,1,0,{[1519]={{62.9,52.26}}},nil,1519,nil,nil,12,"A",nil,0},
[1367] = {'Billy',42,42,1,1,0,{[1519]={{62.95,52.11}}},nil,1519,nil,nil,12,"A",nil,0},
[1368] = {'Justin',42,42,1,1,0,{[1519]={{35.09,44.25}}},nil,1519,nil,nil,12,"A",nil,0},
[1370] = {'Brandon',42,42,1,1,0,{[1519]={{34.98,44.16}}},nil,1519,nil,nil,12,"A",nil,0},
[1371] = {'Roman',42,42,1,1,0,{[1519]={{34.9,44.01}}},nil,1519,nil,nil,12,"A",nil,0},
[1373] = {'Jarven Thunderbrew',328,328,15,15,0,{[1]={{47.65,52.66}}},{[1]={{{47.58,52.52},{47.6,52.41},{47.73,52.41},{47.74,52.64},{47.69,52.7},{47.53,52.4},{47.36,52.4},{47.35,52.59},{47.35,52.59},{47.36,52.4},{47.53,52.4},{47.69,52.7},{47.74,52.64},{47.73,52.41},{47.6,52.41},{47.58,52.52},{47.65,52.66},{47.65,52.66}}}},1,{308},{308},55,"A",nil,2},
[1374] = {'Rejold Barleybrew',198,198,10,10,0,{[1]={{30.19,45.73}}},nil,1,{315,319,320,413},{315,318,319,415},55,"A",nil,2},
[1375] = {'Marleth Barleybrew',247,247,12,12,0,{[1]={{30.19,45.53}}},nil,1,{310},{311},55,"A",nil,2},
[1376] = {'Beldin Steelgrill',247,247,12,12,0,{[1]={{50.44,49.09}}},nil,1,nil,{400},55,"A",nil,2},
[1377] = {'Pilot Stonegear',484,484,20,20,0,{[1]={{49.62,48.61}}},nil,1,{313,466},{313,466,467},55,"A",nil,2},
[1378] = {'Pilot Bellowfiz',417,417,18,18,0,{[1]={{49.43,48.41}}},nil,1,{317,318,415},{317,320},55,"A",nil,2},
[1379] = {'Miran',656,656,15,15,0,{[38]={{52.21,69.43}}},nil,38,{309},{454},1618,"A",nil,2},
[1380] = {'Saean',198,198,10,10,0,{[38]={{52.35,69.21}}},nil,38,nil,nil,55,"A",nil,0},
[1381] = {'Krakk',1604,1604,38,38,0,{[33]={{32.57,27.95}}},nil,33,nil,nil,29,"H","Superior Armorer",16388},
[1382] = {'Mudduk',1752,1752,40,40,0,{[33]={{31.34,27.97}}},nil,33,nil,nil,29,"H","Superior Cook",17},
[1383] = {'Snarl',1106,1106,31,31,0,{[1637]={{79.6,23.31}}},nil,1637,nil,nil,29,"H","Expert Blacksmith",17},
[1384] = {'Z\'tark',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Superior Miner",0},
[1385] = {'Brawn',1342,1342,35,35,0,{[33]={{31.74,28.9}}},nil,33,nil,nil,29,"H","Expert Leatherworker",17},
[1386] = {'Rogvar',3188,3188,53,53,0,{[8]={{48.53,55.85}}},nil,8,nil,nil,29,"H","Master Alchemist",17},
[1387] = {'Thysta',7842,7842,55,55,1,{[33]={{32.54,29.35}}},nil,33,nil,nil,29,"H","Wind Rider Master",11},
[1388] = {'Vagash',666,666,11,11,1,{[1]={{62.62,46.05}}},{[1]={{{62.59,46.09},{62.43,46.41},{62.28,46.73},{62.18,47.06},{62.11,47.28},{62.39,48.45},{62.32,48.89},{62.4,48.23},{62.22,47.6},{62.16,47.4},{61.89,47.17},{61.59,47.11},{62.05,47.13},{62.22,46.89},{62.44,46.4},{62.53,46.19},{62.65,45.99}}}},1,nil,nil,24,nil,nil,0},
[1392] = {'Xon',664,664,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1393] = {'Berserk Trogg',449,484,19,20,0,{[38]={{68.0,65.78},{68.69,62.41},{68.23,62.55},{70.87,64.28},{72.62,63.3}}},nil,38,nil,nil,59,nil,nil,0},
[1395] = {'Ol\' Beasley',198,198,10,10,0,{[1519]={{69.68,46.08}}},nil,1519,nil,nil,12,"A",nil,0},
[1397] = {'Frostmane Seer',148,166,8,9,0,{[1]={{43.06,35.86},{40.34,42.86},{41.09,44.87},{41.48,45.01},{41.39,44.38},{41.16,44.47},{41.62,43.82},{42.1,45.52},{42.11,44.59},{41.14,45.54},{40.75,34.91},{40.67,34.98},{41.28,34.34},{41.85,35.84},{41.81,35.62},{41.54,35.32},{42.25,36.6},{42.82,36.59},{42.07,34.35},{42.31,34.93},{42.46,35.79},{41.76,35.23},{42.55,33.75}}},nil,1,nil,nil,37,nil,nil,0},
[1398] = {'Boss Galgosh',573,573,22,22,4,{[38]={{68.07,65.93}}},nil,38,nil,nil,59,nil,"Stonesplinter Chieftain",0},
[1399] = {'Magosh',473,473,21,21,4,{[38]={{70.12,66.39}}},nil,38,nil,nil,59,nil,"Stonesplinter Tribal Shaman",0},
[1400] = {'Wetlands Crocolisk',617,664,23,24,0,{[11]={{20.55,56.72},{19.27,58.23},{21.27,58.11},{18.18,51.4},{38.58,27.66},{44.97,30.45},{18.98,55.63},{33.68,26.78},{17.48,55.77},{34.31,31.33},{19.11,56.66},{36.46,29.33},{43.82,32.95},{37.0,28.0},{36.15,27.51},{41.0,28.39},{21.72,25.63},{32.62,31.58},{48.57,34.65},{46.57,33.5},{17.16,54.38},{39.32,29.53},{33.62,27.98},{47.46,31.27},{33.52,29.51},{18.41,53.66},{24.81,26.88},{34.68,26.89},{34.59,28.95},{35.25,30.22},{37.86,26.64},{28.65,27.49},{17.76,53.43},{25.39,44.57},{42.19,35.82},{46.22,36.83},{44.55,35.87},{38.81,33.23},{41.66,32.78},{29.52,32.56},{36.18,31.57},{39.74,31.27},{37.49,31.53},{40.49,30.84},{23.99,30.2},{24.79,29.26},{41.0,34.59},{32.02,25.32},{28.06,25.35},{41.78,36.63},{29.84,26.1},{20.12,27.21}}},nil,11,nil,nil,14,nil,nil,0},
[1401] = {'Test Squirrel',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1402] = {'Topper McNabb',42,42,1,1,0,{[1519]={{52.5,57.61}}},nil,1519,nil,nil,12,"A",nil,0},
[1403] = {'Mogwah',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Warrior Trainer",0},
[1404] = {'Kragg',1752,1752,40,40,0,{[33]={{31.23,28.68}}},nil,33,nil,nil,29,"H","Hunter Trainer",17},
[1405] = {'Morris Lawry',42,42,1,1,0,{[1519]={{43.13,48.51}}},nil,1519,nil,nil,12,"A",nil,0},
[1406] = {'Ghok',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Shaman Trainer",0},
[1407] = {'Sranda',1752,1752,40,40,0,{[3]={{2.91,47.25}}},nil,3,nil,nil,29,"H","Light Armor & Weapons Merchant",16388},
[1408] = {'Thragg',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Warlock Trainer",0},
[1409] = {'Moorah Stormhoof',1753,1753,40,40,0,nil,nil,0,nil,nil,29,"H","Druid Trainer",0},
[1410] = {'Loranna Dawnfyre UNUSED (Reuse me)',4164,4164,63,63,0,nil,nil,0,nil,nil,16,nil,"Priest Trainer",0},
[1411] = {'Ian Strom',2487,2487,47,47,0,{[33]={{26.82,77.15}}},nil,33,nil,nil,120,"AH","Rogue Trainer",19},
[1412] = {'Squirrel',8,8,1,1,0,{[38]={{60.27,17.7},{21.1,70.99},{39.85,46.84},{39.84,45.66},{33.48,51.81},{33.58,45.85},{30.2,10.85},{66.31,37.62},{58.75,15.86},{66.01,41.38},{21.09,72.76},{58.95,77.87},{57.73,70.01},{47.97,72.32},{38.85,42.45},{29.08,39.41},{28.17,29.04},{31.23,32.0},{39.3,35.34},{39.34,48.59},{62.44,36.19},{61.17,23.62},{62.48,28.94},{28.43,17.46},{43.23,65.06},{21.07,17.44},{20.68,71.68},{39.38,48.99},{28.41,58.65},{19.44,76.07},{40.21,29.53},{29.92,41.07},{35.82,36.18},{28.36,43.48},{64.82,43.27},{35.52,50.86},{26.25,33.11},{24.82,26.7},{22.17,75.55},{34.61,46.49},{20.0,77.82},{36.02,44.8},{30.93,50.75},{36.25,47.07},{32.45,55.97},{36.46,45.26}},[130]={{53.12,43.82},{35.26,16.04},{51.57,62.29}},[15]={{65.3,52.23},{63.69,49.87},{65.85,52.46},{66.45,52.23},{66.94,45.61},{68.36,49.56},{64.18,47.51},{65.9,44.6},{68.01,47.01},{67.09,49.23},{66.99,50.84},{65.82,50.47},{64.71,46.95},{64.95,50.55}},[406]={{39.73,7.78},{71.11,45.55},{68.09,48.0},{80.06,95.39},{76.81,90.12},{59.36,70.66},{30.88,11.34},{74.94,84.15},{51.97,45.77},{65.43,37.85},{34.14,9.87},{34.39,17.91},{75.81,50.33},{51.44,42.77},{62.01,59.91},{77.76,86.12},{82.01,88.24},{81.24,84.81},{52.68,59.34},{81.89,91.04},{78.02,43.08},{51.38,36.4},{69.56,40.97},{78.7,94.83},{66.87,85.8},{53.7,61.93},{68.62,89.17},{72.34,94.53},{59.51,76.95},{47.35,32.97},{43.45,16.87},{60.51,81.69},{77.06,90.69}},[331]={{40.68,61.76},{27.74,47.85},{52.0,66.17},{44.45,42.02},{66.75,50.82},{20.82,59.46},{65.34,44.31},{43.84,45.32},{55.32,33.68},{81.74,52.48},{32.76,39.03},{69.1,66.16},{19.01,22.25}},[2557]={{-1,-1}},[148]={{61.17,11.34},{45.91,55.48},{43.37,56.46},{48.38,37.25},{41.0,38.16},{41.25,50.09}},[493]={{37.02,69.62},{35.82,56.23},{36.14,59.57},{34.8,58.41},{33.04,62.18},{38.8,31.91},{65.63,56.56},{35.61,54.3},{57.85,27.98},{54.69,75.11},{48.01,63.0},{65.22,50.51},{62.04,49.92},{33.42,44.65},{36.99,53.95},{34.53,59.89},{68.08,53.73},{39.41,56.31},{52.14,71.55},{30.62,53.42},{42.32,34.87},{37.67,62.61},{48.51,31.93},{70.61,50.39},{56.27,66.14},{38.99,44.23},{64.56,69.05},{32.02,58.13},{41.35,32.76},{41.0,62.89},{49.14,42.92},{37.18,43.6},{70.67,56.55},{37.13,45.19},{31.5,48.71},{33.69,58.11},{39.19,34.39},{37.14,36.58},{39.69,60.78},{40.68,57.17},{35.57,64.71},{52.6,31.08},{32.05,56.3},{51.88,64.14},{63.59,46.29},{32.42,32.24},{42.35,53.47},{62.82,64.57},{32.31,52.96},{36.05,65.4},{51.46,66.89},{50.57,36.15},{52.11,39.19},{41.63,58.55},{44.77,60.26},{40.05,44.64},{36.4,51.78},{47.69,64.59},{32.7,40.21},{62.3,69.74},{33.42,54.8},{35.66,47.97},{35.18,39.4},{71.45,60.28},{64.52,62.94},{39.17,68.13},{47.87,34.1},{60.96,65.82},{51.81,46.31},{50.49,32.58},{40.74,40.28},{55.23,30.3},{45.96,44.62},{38.69,65.89},{43.95,58.72},{66.24,50.11},{31.0,54.52},{59.21,33.42},{34.93,33.01},{37.13,69.63},{38.67,47.53},{47.77,65.85},{35.11,43.94},{48.66,31.72}},[1657]={{68.78,51.78},{34.41,60.01},{65.19,65.04},{72.82,49.86},{30.75,40.46},{38.13,45.18},{52.61,16.26},{66.04,30.41},{41.95,15.93},{65.89,74.88},{49.0,76.57},{35.3,52.38},{61.79,74.95},{69.86,57.71},{56.42,48.09},{59.03,74.05},{53.98,30.72},{59.59,51.38},{54.21,9.48},{52.57,88.68},{60.39,6.15},{68.49,55.82},{52.34,87.44},{47.43,68.37},{49.49,31.12},{37.99,18.0},{64.12,73.62},{74.15,31.33},{54.31,72.39},{53.43,21.07},{67.84,57.95},{58.47,10.93},{61.69,25.45},{35.33,12.76},{59.46,29.96},{47.36,29.46},{58.3,72.0},{53.48,71.5},{62.25,11.35},{44.94,21.91},{39.29,9.4},{59.34,56.05},{39.05,37.76},{51.67,82.34},{50.44,19.53},{50.65,75.56},{49.7,10.2},{58.56,64.52},{41.54,42.75},{40.35,36.91},{49.54,10.28}},[357]={{54.5,67.36},{54.28,69.75},{54.79,46.05},{46.92,9.01},{73.26,39.22},{56.79,56.34},{55.65,53.82},{73.7,56.21},{71.16,53.24},{56.1,61.75}},[1519]={{39.29,80.57},{38.85,77.33},{37.24,75.88},{31.54,73.98},{31.35,69.52},{36.63,68.74}}},nil,493,nil,nil,31,"AH",nil,0},
[1413] = {'Janey Anship',712,712,25,25,0,{[1519]={{38.82,79.61}}},{[1519]={{{38.57,75.31},{38.91,72.88},{39.48,70.31},{38.32,68.91},{37.13,68.2},{36.25,67.98},{35.05,68.65},{34.05,65.98},{33.46,64.38},{33.29,63.04},{31.8,60.0},{36.11,54.52},{36.37,52.95},{36.26,51.48},{37.47,49.96},{38.8,48.3},{39.37,48.57},{40.61,49.73},{41.72,50.06},{42.62,49.59},{43.54,48.97},{44.39,49.31},{45.46,50.38},{46.07,50.33},{46.64,49.89},{47.83,48.59},{48.79,50.19},{49.5,51.24},{49.95,51.75},{50.61,51.14},{52.86,55.49},{54.6,53.73},{56.03,53.58},{56.89,54.04},{57.92,55.91},{58.81,57.4},{56.94,59.9},{53.67,63.7},{52.71,61.98},{52.36,60.99},{49.99,62.41},{47.92,63.87},{46.2,66.02},{46.42,67.17},{43.95,70.38},{44.37,71.32},{45.22,72.68},{45.39,76.12},{44.47,78.33},{43.16,79.39},{41.49,79.89},{39.52,79.39},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61},{38.82,79.61}}}},1519,nil,nil,12,"A",nil,0},
[1414] = {'Lisan Pierce',712,712,25,25,0,{[1519]={{38.89,79.29}}},nil,1519,nil,nil,12,"A",nil,0},
[1415] = {'Suzanne',712,712,25,25,0,{[1519]={{39.04,79.63}}},nil,1519,nil,nil,12,"A",nil,0},
[1416] = {'Grimand Elmore',2768,2768,50,50,0,{[1519]={{51.76,12.08}}},{[1519]={{{51.59,12.74},{52.01,13.57},{54.61,12.26},{56.75,16.0},{56.76,15.97},{54.61,12.26},{52.01,13.57},{51.59,12.74},{51.76,12.07},{51.76,12.07}}}},1519,{325,353,1705,1706,7642,7648},{322,1097,1700,1705,1706,7641,7642},55,"A",nil,3},
[1417] = {'Young Wetlands Crocolisk',531,573,21,22,0,{[11]={{65.39,71.01},{63.98,73.57},{13.35,54.72},{63.95,72.57},{65.9,72.1},{65.51,68.91},{64.69,68.88},{62.18,74.89},{14.43,59.86},{54.74,31.16},{57.01,48.31},{63.45,66.44},{53.79,32.55},{64.04,72.22},{63.6,65.58},{53.06,33.31},{50.29,31.97},{53.16,32.72},{53.14,37.43},{50.5,33.84},{64.13,75.3},{66.0,72.49},{63.44,75.33},{66.33,72.72},{58.91,51.06},{58.48,50.8},{61.02,54.69},{61.35,53.08},{60.96,61.66},{61.86,61.79},{60.46,63.57},{27.96,32.61},{40.33,36.07},{19.15,47.12},{21.38,44.62},{62.6,59.39},{20.19,47.18},{28.0,34.37},{28.66,36.22},{62.09,61.38},{59.66,53.3},{61.83,56.78},{60.63,54.74},{18.59,47.18},{53.12,42.35},{57.31,47.1},{51.91,35.4},{59.41,49.44},{52.2,36.23},{52.42,32.67},{55.11,45.65},{37.31,34.62},{51.5,38.43},{52.41,39.56},{38.63,35.88},{30.42,38.96},{35.06,35.92},{27.85,39.57},{29.03,38.75},{37.31,37.11},{26.47,41.15},{18.66,49.31},{18.55,51.65},{14.58,53.22},{15.37,52.24},{19.76,45.07},{50.9,37.08},{28.75,33.8},{26.67,32.46},{34.46,37.64},{14.39,51.59},{33.68,35.42},{53.21,41.26},{15.77,46.39},{15.13,47.74},{16.85,52.05},{53.84,42.49}}},nil,11,nil,nil,14,nil,nil,0},
[1418] = {'Bluegill Raider',896,950,28,29,0,{[11]={{25.67,16.95},{28.94,14.56},{24.14,16.87},{28.0,13.59},{27.02,16.89},{26.13,16.3},{29.8,13.16},{28.17,16.12},{24.82,18.19},{23.28,18.53},{21.83,17.82},{19.97,17.97},{29.15,12.26},{19.17,19.51},{20.65,16.97},{31.41,12.24},{26.38,18.47},{12.37,65.21},{12.62,64.32},{12.72,65.3},{10.22,66.31},{11.31,65.55},{11.82,65.45},{11.76,64.38},{9.52,66.71},{12.92,63.63},{10.26,71.29},{11.04,71.58},{8.73,67.94},{12.38,66.55},{9.59,69.02},{13.66,64.01},{9.55,72.52},{11.98,63.55},{9.52,71.5},{9.44,70.13},{8.73,70.31},{9.52,67.86},{8.68,71.35},{11.87,66.42},{8.64,69.0},{10.18,70.4}},[45]={{23.02,94.66},{21.6,96.88}}},nil,11,nil,nil,18,nil,nil,0},
[1419] = {'Fizzles',8,8,1,1,0,{[1519]={{32.28,79.81}}},nil,1519,nil,nil,12,"A",nil,0},
[1420] = {'Toad',8,8,1,1,0,{[8]={{62.95,65.24},{46.84,45.12},{53.35,49.48},{22.59,48.78},{76.6,80.11},{83.89,27.43},{50.98,57.01},{67.1,67.38},{89.69,46.16},{10.68,35.42},{14.9,59.38}},[11]={{22.1,26.77},{67.31,71.83},{35.06,28.51},{42.03,31.46},{61.56,67.91},{58.68,49.57},{13.16,53.9},{21.32,32.68},{48.14,33.7},{25.02,25.03},{24.65,33.6},{51.95,38.87},{56.04,47.48},{59.59,59.56},{31.19,36.6},{10.87,53.0},{38.35,36.34},{49.87,37.89},{33.87,37.21},{15.49,46.95},{9.7,61.76},{60.54,69.64},{18.59,46.26},{26.29,40.83},{33.19,39.83},{7.22,57.66},{11.7,56.04},{9.89,54.33},{10.0,58.58},{32.0,38.22}},[45]={{31.16,82.56},{33.77,81.37}},[130]={{59.51,18.11},{65.02,12.79},{65.57,19.02},{56.51,21.64},{59.13,36.63},{64.02,31.34},{66.73,44.42},{67.88,37.8}},[15]={{43.55,62.69},{42.06,65.36},{44.58,40.55},{42.31,46.16},{33.85,42.31},{34.75,49.14},{40.96,51.51},{44.32,41.59},{36.66,60.02},{47.4,52.87},{45.57,62.07},{53.09,28.3},{36.89,12.93},{43.07,68.49},{52.73,72.2},{51.07,21.21},{39.0,69.59},{34.17,70.69},{54.25,24.35},{41.52,41.25},{39.03,45.95},{37.7,50.48},{37.32,18.39},{35.06,50.34},{47.26,72.73},{40.65,32.28},{51.08,73.11},{54.8,32.79},{44.45,69.61},{40.95,38.32},{38.01,30.84},{51.18,68.91},{52.45,73.02},{56.72,69.01},{46.34,70.1},{50.23,77.14},{49.91,57.83},{56.45,35.8},{37.38,21.79},{43.31,73.12},{47.26,75.11},{40.84,46.28},{45.29,49.15},{55.19,74.82},{47.85,76.59},{38.26,19.63},{36.34,40.27},{48.17,60.09},{56.29,22.29},{49.17,22.91},{38.65,52.79},{51.08,18.86},{43.17,70.6},{35.53,71.03},{41.42,67.64},{42.5,47.68},{39.0,28.06},{43.22,23.16},{35.91,67.92},{44.24,47.72},{41.59,24.44},{46.0,73.87},{43.04,60.4},{36.48,42.51},{41.65,18.5},{45.65,73.71},{39.33,65.13},{47.66,53.76},{40.11,34.95},{43.75,25.18},{38.12,25.46},{47.27,17.85},{46.98,20.91},{40.95,61.84},{38.98,41.58}},[490]={{75.36,55.56},{44.49,40.65},{69.14,42.65},{73.76,60.75},{35.67,22.49},{61.78,68.0},{43.6,31.91},{59.37,43.03},{71.87,64.65},{64.37,72.86},{69.22,73.01},{71.38,48.41},{65.29,58.89},{56.93,41.72},{69.14,46.01},{30.88,24.87},{43.99,37.41},{73.15,48.6},{72.62,55.59},{61.5,43.22},{66.77,55.11},{49.24,39.56},{65.4,74.38},{69.98,70.41},{45.13,42.38},{70.97,55.9},{63.56,56.42},{69.21,65.44},{64.76,43.92},{53.8,37.35},{66.5,69.89},{68.77,52.37},{64.18,68.44},{64.71,40.66},{66.81,74.68},{35.73,26.63},{41.51,29.51}},[141]={{42.95,28.2},{57.4,38.77},{42.3,42.21},{55.32,69.46},{39.7,65.92},{57.92,66.34},{56.1,68.33},{40.49,65.32},{59.5,69.08},{44.36,27.47},{57.86,38.22},{50.16,71.9},{57.18,67.78},{40.46,63.86},{43.71,40.79},{52.84,70.71},{43.03,39.42},{42.96,35.21},{59.63,66.62},{44.28,26.32},{51.29,70.54},{43.44,31.67},{41.29,67.84},{43.47,26.67},{50.58,73.59},{40.65,67.32},{52.39,72.7},{42.66,31.8},{42.18,38.78},{58.58,36.51},{57.05,37.4}},[1657]={{54.44,58.2},{37.44,36.47},{47.33,48.51},{47.23,50.58},{48.34,39.57},{42.13,23.86},{45.37,23.42},{54.16,34.78},{49.95,43.69},{52.07,69.9},{40.06,49.94},{53.58,46.22},{34.55,43.51},{46.85,29.69},{52.31,30.74},{46.98,54.8},{27.08,45.78},{46.63,30.35},{44.2,22.56},{29.93,25.03},{44.56,48.03},{31.93,44.82},{56.33,26.9},{45.75,55.83},{54.72,49.25},{52.28,31.67},{29.87,23.71},{59.76,31.3},{30.7,34.82},{25.94,29.62},{46.19,56.72},{36.79,37.02}},[1977]={{-1,-1}}},nil,15,nil,nil,188,"AH",nil,0},
[1421] = {'Private Merle',1107,1107,31,31,0,{[33]={{38.51,3.77}}},{[33]={{{38.69,3.81},{38.63,3.77},{38.57,3.76},{38.45,3.72},{38.39,3.74},{38.34,3.79},{38.28,3.79},{38.23,3.75},{38.11,3.78},{38.05,3.8},{37.96,3.79},{38.07,3.9},{38.12,3.95},{38.18,3.98},{38.36,3.97},{38.34,3.89},{38.39,3.82},{38.44,3.78},{38.51,3.77},{38.57,3.8}}}},33,nil,nil,11,"A","Rebel Soldier",0},
[1422] = {'Corporal Sethman',1752,1752,40,40,0,{[33]={{37.66,3.39}}},nil,33,{331},{330},11,"A",nil,2},
[1423] = {'Stormwind Guard',1210,1210,23,23,0,{[12]={{20.74,79.48},{35.29,53.66},{45.56,49.1},{42.09,66.61},{42.11,65.49},{24.93,72.01},{24.35,72.9},{24.81,73.19},{25.86,72.22},{25.14,72.71},{25.89,72.23},{25.75,72.33},{25.68,72.41},{28.17,77.69},{28.14,77.98},{24.47,80.56},{24.2,80.31},{23.79,80.18},{23.63,80.49},{23.89,80.4},{24.35,81.03},{75.12,72.21},{75.04,72.54},{74.17,72.66},{74.17,72.41},{83.68,78.95},{83.92,78.44},{84.1,79.36},{84.5,79.72},{84.75,79.59},{84.42,79.37},{20.91,79.84},{24.73,72.92},{25.01,72.31},{25.02,71.76},{24.57,71.59},{25.59,72.88},{24.65,71.5},{24.49,71.46},{25.88,72.22},{56.56,72.21}},[1519]={{70.95,88.63}}},nil,12,nil,nil,11,"A",nil,1},
[1424] = {'Master Digger',328,328,15,15,4,{[40]={{46.42,19.06}}},nil,40,nil,nil,26,nil,nil,0},
[1425] = {'Grizlak',301,301,15,15,4,{[38]={{34.58,27.07}}},nil,38,nil,nil,26,nil,nil,0},
[1426] = {'Riverpaw Miner',300,328,14,15,0,{[40]={{28.94,48.71},{30.35,45.38},{29.31,46.07},{28.94,50.64},{29.65,50.58},{30.26,47.55},{30.77,46.19},{30.27,49.65}}},nil,40,nil,nil,20,nil,nil,0},
[1427] = {'Harlan Bagley',247,247,12,12,0,{[1519]={{55.11,56.23}}},nil,1519,{333},nil,12,"A",nil,2},
[1428] = {'Rema Schneider',1342,1342,35,35,0,{[1519]={{49.65,55.64}}},nil,1519,{334},{333},12,"A",nil,2},
[1429] = {'Thurman Schneider',55,55,2,2,0,{[1519]={{42.53,76.2}}},nil,1519,nil,{334},12,"A",nil,2},
[1430] = {'Tomas',198,198,10,10,0,{[12]={{44.37,65.99}}},nil,12,nil,nil,12,"A","Cook",17},
[1431] = {'Suzetta Gallina',1002,1002,30,30,0,{[1519]={{52.48,67.61}}},nil,1519,nil,{332},12,"A",nil,2},
[1432] = {'Renato Gallina',2217,2217,45,45,0,{[1519]={{56.98,63.53}}},nil,1519,{332},nil,12,"A",nil,3},
[1433] = {'Corbett Schneider',102,102,5,5,0,nil,nil,0,nil,nil,12,"A",nil,0},
[1434] = {'Menethil Sentry',3170,3302,41,42,0,{[11]={{4.47,57.47},{10.29,58.08},{11.18,62.03},{9.77,56.35},{11.22,57.28},{11.96,55.12},{5.21,63.71},{10.78,54.39},{9.77,55.99},{11.15,54.68},{9.93,57.08},{4.85,57.8},{9.13,60.74},{12.28,49.97},{9.89,57.17},{9.36,57.34},{4.83,57.04},{12.27,50.59},{10.2,58.3},{10.54,59.05},{9.3,55.94},{10.11,57.41},{4.98,63.07},{4.96,62.31},{12.7,50.15},{8.94,57.91},{7.77,52.79},{8.37,56.78},{9.71,60.49}}},nil,11,nil,nil,57,"A",nil,0},
[1435] = {'Zardeth of the Black Claw',4120,4120,60,60,0,{[1519]={{26.44,78.67}}},nil,1519,{335,336,397},{335},12,"A",nil,2},
[1436] = {'Watcher Cutford',1469,1469,36,36,0,nil,nil,0,nil,nil,56,"A","The Night Watch",0},
[1437] = {'Thomas Booker',484,484,20,20,0,{[11]={{8.84,54.31}}},{[11]={{{8.83,54.31},{8.85,54.54},{8.76,54.67},{8.62,54.7},{8.42,54.56},{8.33,54.45},{8.46,54.08}}}},11,nil,nil,11,"A",nil,2},
[1439] = {'Lord Baurles K. Wishock',198,198,10,10,0,{[1519]={{75.23,31.68}}},nil,1519,nil,{336},12,"A","House of Nobles",2},
[1440] = {'Milton Sheaf',328,328,15,15,0,{[1519]={{74.18,7.46}}},nil,1519,{344,538},{337,343,542},12,"A","Librarian",2},
[1441] = {'Brak Durnad',712,712,25,25,0,{[11]={{11.44,59.69}}},{[11]={{{11.44,59.69},{11.58,59.54}}}},11,nil,nil,55,"A","Weaponsmith",16388},
[1442] = {'Helgrum the Swift',4120,4120,60,60,0,{[8]={{47.74,55.2}}},nil,8,{1418},{1420},29,"H",nil,2},
[1443] = {'Fel\'zerul',4120,4120,60,60,0,{[8]={{47.93,54.78}}},nil,8,{1424,1429,1445},{1424,1444,1445},29,"H",nil,2},
[1444] = {'Brother Kristoff',1752,1752,40,40,0,{[1519]={{45.7,38.42}}},nil,1519,{343},{346},12,"A",nil,2},
[1445] = {'Jesse Halloran',55,55,2,2,0,{[11]={{8.32,55.13}}},nil,11,nil,nil,12,"A",nil,0},
[1446] = {'Regina Halloran',55,55,2,2,0,{[11]={{8.26,55.33}}},nil,11,nil,nil,12,"A",nil,0},
[1447] = {'Gimlok Rumdnul',55,55,2,2,0,{[11]={{12.07,57.81}}},nil,11,nil,nil,55,"A",nil,0},
[1448] = {'Neal Allen',484,484,20,20,0,{[11]={{10.75,56.75}}},nil,11,nil,nil,11,"A","Engineering & General Goods Supplier",6},
[1449] = {'Witch Doctor Unbagwa',1981,1981,42,42,0,{[33]={{35.27,60.41}}},nil,33,{349},{349},35,"AH",nil,2},
[1450] = {'Brahnmar',712,712,25,25,0,{[11]={{11.54,59.86}}},{[11]={{{11.54,59.86},{11.47,59.77}}}},11,nil,nil,55,"A","Armorer",16388},
[1451] = {'Camerick Jongleur',712,712,25,25,0,{[11]={{9.87,59.09}}},{[11]={{{9.87,59.09},{9.95,59.17},{10.1,59.16},{10.12,59.07},{10.08,59.04},{10.11,58.96},{10.05,58.87},{9.91,58.8},{9.85,58.93},{9.79,58.86},{9.74,58.94},{9.73,59.03},{9.76,59.09},{9.88,59.05}}}},11,nil,nil,12,"A","Wandering Minstrel",2},
[1452] = {'Gruham Rumdnul',712,712,25,25,0,{[11]={{12.07,57.98}}},nil,11,nil,nil,55,"A","General Supplies",6},
[1453] = {'Dewin Shimmerdawn',712,712,25,25,0,{[11]={{7.96,56.34}}},nil,11,nil,nil,55,"A","Alchemy Supplies",6},
[1454] = {'Jennabink Powerseam',712,712,25,25,0,{[11]={{8.12,55.84}}},nil,11,nil,nil,875,"A","Tailoring Supplies & Specialty Goods",16390},
[1456] = {'Kersok Prond',712,712,25,25,0,{[11]={{10.38,60.62}}},nil,11,nil,nil,55,"A","Tradesman",6},
[1457] = {'Samor Festivus',712,712,25,25,0,{[11]={{10.5,60.2}}},nil,11,nil,nil,12,"A","Shady Dealer",4},
[1458] = {'Telurinon Moonshadow',712,712,25,25,0,{[11]={{7.99,55.84}}},{[11]={{{7.99,55.84},{7.86,55.8},{7.96,55.95}}}},11,nil,nil,55,"A","Herbalism Trainer",16},
[1459] = {'Naela Trance',712,712,25,25,0,{[11]={{11.27,58.43}}},{[11]={{{11.27,58.43},{11.26,58.41},{11.32,58.31},{11.24,58.16},{11.22,58.18},{11.31,58.27},{11.26,58.41}}}},11,nil,nil,12,"A","Bowyer",16388},
[1460] = {'Unger Statforth',712,712,25,25,0,{[11]={{8.57,54.34}}},nil,11,nil,nil,12,"A","Horse Breeder",5},
[1461] = {'Murndan Derth',1750,1750,43,43,0,{[11]={{11.33,59.59}}},nil,11,nil,nil,55,"A","Gunsmith",16388},
[1462] = {'Edwina Monzor',712,712,25,25,0,{[11]={{11.12,58.32}}},nil,11,nil,nil,12,"A","Fletcher",16388},
[1463] = {'Falkan Armonis',712,712,25,25,0,{[11]={{8.35,56.47}}},nil,11,nil,nil,12,"A","Reagent Vendor",4},
[1464] = {'Innkeeper Helbrek',1002,1002,30,30,0,{[11]={{10.7,60.95}}},nil,11,nil,nil,55,"A","Innkeeper",135},
[1465] = {'Drac Roughcut',328,328,15,15,0,{[38]={{35.57,49.15}}},nil,38,nil,nil,55,"A","Tradesman",6},
[1466] = {'Gretta Finespindle',664,664,24,24,0,{[1537]={{38.81,32.88}}},nil,1537,nil,nil,55,"A","Journeyman Leatherworker",19},
[1468] = {'Kargh Steelspine',328,328,15,15,0,nil,nil,0,nil,nil,55,"A","Armorer",0},
[1469] = {'Vrok Blunderblast',328,328,15,15,0,{[38]={{35.83,43.46}}},nil,38,nil,nil,55,"A","Gunsmith",16388},
[1470] = {'Ghak Healtouch',712,712,25,25,0,{[38]={{37.07,49.38}}},nil,38,{17,2500,2501},{17,2500,2501},55,"A","Journeyman Alchemist",19},
[1471] = {'Jannos Ironwill',2398,2398,46,46,0,{[45]={{45.98,47.72}}},nil,45,nil,nil,55,"A","Superior Macecrafter",16388},
[1472] = {'Morgg Stormshot',3188,3188,53,53,0,{[1519]={{59.37,21.25}}},nil,1519,nil,nil,55,"A",nil,0},
[1473] = {'Kali Healtouch',300,300,14,14,0,{[38]={{36.47,48.54}}},nil,38,nil,nil,55,"A","Herbalist",16},
[1474] = {'Rann Flamespinner',328,328,15,15,0,{[38]={{35.95,45.87}}},nil,38,nil,nil,55,"A","Tailoring Supplies",6},
[1475] = {'Menethil Guard',3980,3980,47,47,0,nil,nil,0,nil,nil,57,"A",nil,1},
[1476] = {'Hargin Mundar',484,484,20,20,0,{[11]={{10.68,60.52}}},{[11]={{{10.63,60.52},{10.63,60.75},{10.74,60.92},{10.63,60.75},{10.63,60.52},{10.68,60.52},{10.67,60.53},{10.42,60.47},{10.45,60.48},{10.63,60.56},{10.63,60.33},{10.62,60.1},{10.78,60.09},{10.79,59.76},{10.78,60.09},{10.62,60.1},{10.63,60.33}}}},11,nil,nil,57,"A",nil,2},
[1477] = {'Christoph Faral',1002,1002,30,30,0,{[1519]={{73.92,36.66}}},nil,1519,nil,nil,12,"A",nil,0},
[1478] = {'Aedis Brom',1002,1002,30,30,0,{[1519]={{73.84,36.49}}},nil,1519,nil,nil,12,"A",nil,0},
[1479] = {'Timothy Clark',484,484,20,20,0,{[11]={{10.21,56.82}}},nil,11,nil,nil,11,"A",nil,2},
[1480] = {'Caitlin Grassman',484,484,20,20,0,{[11]={{11.88,58.82}}},nil,11,nil,nil,12,"A",nil,2},
[1481] = {'Bart Tidewater',484,484,20,20,0,{[11]={{9.41,58.76}}},{[11]={{{9.05,59.35},{9.0,59.19},{9.17,58.92},{8.37,58.52},{8.02,57.75},{7.92,57.51},{7.92,57.64}}}},11,nil,nil,12,"A","Captain of the Maiden's Virtue",2},
[1482] = {'Andrea Halloran',484,484,20,20,0,{[11]={{8.33,55.38}}},nil,11,nil,nil,11,"A",nil,2},
[1483] = {'Murphy West',484,484,20,20,0,{[11]={{9.87,57.88}}},{[11]={{{9.73,57.75},{9.61,57.69},{9.76,57.26},{9.81,57.15},{10.08,57.33},{9.61,57.69},{9.73,57.75},{9.9,57.69}}}},11,nil,nil,11,"A",nil,2},
[1484] = {'Derina Rumdnul',484,484,20,20,0,{[11]={{12.03,57.89}}},nil,11,nil,nil,55,"A",nil,2},
[1487] = {'Splinter Fist Enslaver',1050,1107,30,31,0,{[10]={{38.14,80.82},{35.04,81.27},{37.78,84.32}}},nil,10,nil,nil,45,nil,nil,0},
[1488] = {'Zanzil Zombie',2059,2138,43,44,0,{[33]={{41.32,57.01},{39.55,58.29},{34.72,51.91},{38.89,57.62},{38.62,58.54},{34.46,50.98},{40.83,59.12},{34.84,51.44},{34.65,51.78},{39.1,58.25}}},nil,33,nil,nil,16,nil,nil,0},
[1489] = {'Zanzil Hunter',2059,2138,43,44,0,{[33]={{39.33,58.77},{34.39,52.21}}},nil,33,nil,nil,16,nil,nil,0},
[1490] = {'Zanzil Witch Doctor',1711,1711,44,44,0,{[33]={{34.88,51.68},{38.68,56.61},{39.63,57.87},{39.78,57.71},{39.19,59.25},{40.07,58.01}}},nil,33,nil,nil,16,nil,nil,0},
[1491] = {'Zanzil Naga',2138,2138,44,44,0,{[33]={{41.75,56.5},{40.74,58.04},{35.01,52.11},{35.19,51.84},{40.21,59.07},{35.13,51.14},{38.66,59.78},{39.68,59.25},{39.55,59.01},{34.97,50.57},{39.9,57.26}}},nil,33,nil,nil,16,nil,nil,0},
[1492] = {'Gorlash',7960,7960,47,47,1,{[33]={{36.95,69.73}}},nil,33,nil,nil,778,nil,nil,0},
[1493] = {'Mok\'rash',8860,8860,50,50,1,{[33]={{23.25,72.1}}},nil,33,nil,nil,778,nil,nil,0},
[1494] = {'Negolash',9484,9484,52,52,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1495] = {'Deathguard Linnea',1124,1124,22,22,0,{[85]={{65.49,60.25}}},nil,85,{356,360},{356,359},68,"H",nil,2},
[1496] = {'Deathguard Dillinger',1124,1124,22,22,0,{[85]={{58.2,51.45}}},nil,85,{404,426,1819,1820},{404,426,1818,1819},68,"H",nil,3},
[1497] = {'Gunther Arcanus',3188,3188,53,53,0,{[85]={{68.2,41.92}}},nil,85,{409,411},{366,409},68,"H",nil,2},
[1498] = {'Bethor Iceshard',4120,4120,60,60,0,{[1497]={{84.07,17.45}}},nil,1497,{357,366,446},{357,405,411,444,491},68,"H",nil,2},
[1499] = {'Magistrate Sevren',300,300,14,14,0,{[85]={{61.26,50.84}}},nil,85,{358,359,405,408,441},{355,358,360,408,440},68,"H",nil,2},
[1500] = {'Coleman Farthing',328,328,15,15,0,{[85]={{61.72,52.29}}},nil,85,{354,355,362,1821,1822},{354,362,1820,1821,1822},68,"H",nil,2},
[1501] = {'Mindless Zombie',42,42,1,1,0,{[85]={{34.59,62.77},{31.47,62.02},{34.92,62.8},{34.92,64.75},{34.77,64.15},{31.58,62.2},{31.49,62.16},{34.12,64.24},{34.07,64.39},{33.56,63.88},{30.7,64.17},{33.86,65.24},{30.67,61.75},{32.54,62.96},{31.86,63.56},{33.19,63.84},{33.38,64.27},{33.04,64.53},{33.48,64.71},{31.69,64.14},{31.07,62.98},{31.2,63.67},{30.9,62.12},{30.8,61.55},{32.33,64.27},{32.8,64.31},{32.36,63.01},{32.28,63.63}}},nil,85,nil,nil,7,"AH",nil,0},
[1502] = {'Wretched Zombie',42,55,1,2,0,{[85]={{34.2,65.85},{33.6,61.78},{31.75,62.15},{31.52,62.58},{31.78,61.87},{34.16,64.18},{33.89,63.88},{33.84,64.19},{34.21,63.62},{31.64,62.27},{33.78,62.82},{32.76,62.45},{31.39,61.4},{33.77,65.89},{32.12,60.54},{32.45,60.7},{31.92,62.8},{33.96,63.29},{32.87,63.55},{30.33,63.31},{33.34,64.94},{33.83,64.36},{33.31,65.49},{33.31,65.7},{33.52,63.18},{31.64,63.36},{32.83,61.31},{32.56,64.12},{33.21,61.16},{33.44,63.43},{34.42,60.71},{32.18,63.18},{32.81,62.17},{32.61,62.23},{32.58,62.76}}},nil,85,nil,nil,7,"AH",nil,0},
[1504] = {'Young Night Web Spider',55,71,2,3,0,{[85]={{27.76,56.98},{30.57,56.47},{28.32,57.43},{27.89,55.17},{28.2,57.09},{29.66,58.45},{28.51,56.53},{29.84,56.96},{29.94,57.43},{27.94,60.46},{28.21,55.62},{27.39,57.95},{28.16,59.83},{27.41,55.93},{26.83,56.16},{27.05,56.63},{27.71,59.6},{29.12,56.13},{29.35,55.6},{29.79,55.88},{27.1,59.18},{27.53,58.86},{29.4,59.42},{28.86,59.45},{29.15,58.13},{29.18,57.66},{29.03,57.07},{28.36,58.29},{28.5,59.08},{28.1,59.16}}},nil,85,nil,nil,7,"AH",nil,0},
[1505] = {'Night Web Spider',71,86,3,4,0,{[85]={{23.97,60.61},{23.26,59.94},{23.41,58.93},{23.56,58.3},{24.48,59.71},{23.48,60.25},{23.48,59.11},{23.74,58.43},{23.16,59.64},{23.97,58.43},{26.23,60.2},{26.13,60.42},{24.79,59.4},{24.8,59.69},{24.18,60.73},{26.25,59.66},{26.21,59.69},{25.62,59.44},{25.41,59.83},{25.16,59.53},{25.16,60.36},{24.97,59.22},{24.84,60.33},{24.48,60.64},{24.64,60.05},{25.91,59.54},{26.6,59.5}}},nil,85,nil,nil,22,nil,nil,0},
[1506] = {'Scarlet Convert',71,71,3,3,0,{[85]={{38.27,65.12},{38.49,70.3},{37.75,65.56},{37.62,67.49},{37.68,71.66},{37.36,67.95},{37.47,66.44},{38.28,68.46},{36.96,70.87},{38.51,68.26},{38.67,65.06},{38.37,67.7},{37.41,67.77},{38.69,67.15},{38.56,66.15},{37.75,66.65},{38.74,69.38},{37.58,67.98},{36.59,65.58},{37.0,65.2},{36.92,66.42},{37.01,67.28},{36.88,63.01},{36.86,69.95},{37.41,69.58},{37.81,69.2},{37.76,70.01},{37.55,68.67},{36.66,68.63},{36.47,68.37},{36.25,67.16},{35.94,68.59},{36.47,69.43}}},nil,85,nil,nil,67,nil,nil,0},
[1507] = {'Scarlet Initiate',67,81,3,4,0,{[85]={{38.27,65.12},{38.49,70.3},{37.75,65.56},{37.62,67.49},{37.68,71.66},{37.36,67.95},{37.47,66.44},{38.28,68.46},{36.96,70.87},{38.51,68.26},{38.67,65.06},{38.37,67.7},{37.41,67.77},{38.69,67.15},{38.56,66.15},{37.75,66.65},{38.74,69.38},{37.58,67.98},{36.59,65.58},{37.0,65.2},{36.92,66.42},{37.01,67.28},{36.88,63.01},{36.86,69.95},{37.41,69.58},{37.81,69.2},{37.76,70.01},{37.55,68.67},{36.66,68.63},{36.47,68.37},{36.25,67.16},{35.94,68.59},{36.47,69.43}}},nil,85,nil,nil,67,nil,nil,0},
[1508] = {'Young Scavenger',42,42,1,1,0,{[85]={{33.01,67.36},{33.55,68.62},{31.04,55.61},{34.26,67.15},{30.15,63.98},{34.88,57.89},{34.21,56.95},{32.0,57.53},{31.44,58.43},{30.91,62.15},{29.47,61.88},{28.93,68.22},{29.42,67.23},{29.4,65.67},{28.85,64.68},{30.09,62.92},{30.77,60.78},{31.9,59.63}}},nil,85,nil,nil,32,"AH",nil,0},
[1509] = {'Ragged Scavenger',55,71,2,3,0,{[85]={{36.88,63.46},{37.39,58.74},{37.79,62.96},{38.23,63.89},{36.63,60.8},{37.68,60.64},{35.9,55.99},{37.6,55.98},{36.86,56.9},{35.68,59.48},{35.66,57.25},{34.56,65.18},{35.6,65.78},{34.56,62.55},{35.7,62.32},{36.5,63.58},{34.57,58.86},{35.07,57.41},{34.47,56.83}}},nil,85,nil,nil,32,"AH",nil,0},
[1511] = {'Enraged Silverback Gorilla',1902,1981,41,42,0,nil,nil,0,nil,nil,41,nil,nil,0},
[1512] = {'Duskbat',42,55,1,2,0,{[85]={{32.39,69.47},{34.31,70.69},{35.66,69.26},{35.69,71.43},{28.37,62.56},{31.46,72.55},{28.3,63.63},{28.61,69.07},{35.14,70.37},{35.81,70.75},{34.33,69.45},{28.32,63.92},{34.95,69.55},{35.08,71.4},{27.9,64.82},{27.78,63.56},{27.85,67.42},{32.02,71.62},{29.37,72.48},{31.54,56.23},{34.2,68.22},{33.41,66.75},{30.19,65.53},{34.03,58.23},{33.77,57.27},{32.48,56.2},{32.78,58.07},{31.11,57.96},{30.92,59.73},{29.59,62.2},{29.79,63.6},{29.7,64.07},{30.08,61.51},{29.46,61.04},{29.94,70.33},{29.3,69.17},{29.03,67.83},{29.14,66.71},{29.94,66.22},{30.68,69.29}}},nil,85,nil,nil,7,"AH",nil,0},
[1513] = {'Mangy Duskbat',71,86,3,4,0,{[85]={{36.77,56.51},{37.07,61.96},{37.7,57.99},{37.22,59.77},{36.92,64.38},{37.85,61.98},{35.13,58.97},{34.93,61.38},{37.63,59.44},{35.63,61.76},{36.46,58.59},{35.62,58.26},{35.18,56.74},{33.91,61.73},{34.08,65.37},{35.23,64.69},{35.1,66.2},{34.89,66.77},{35.41,62.98},{34.43,59.56},{34.05,57.34}}},nil,85,nil,nil,7,"AH",nil,0},
[1514] = {'Mokk the Savage',2138,2138,44,44,0,nil,nil,0,nil,nil,41,nil,nil,0},
[1515] = {'Executor Zygand',300,300,14,14,0,{[85]={{60.59,51.76}}},nil,85,{370,371,372,427},{370,371,372,383,398,427},68,"H",nil,2},
[1516] = {'Konda',2059,2059,43,43,0,nil,nil,0,nil,nil,41,nil,nil,0},
[1518] = {'Apothecary Johaan',484,484,20,20,0,{[85]={{59.45,52.4}}},nil,85,{367,368,369,407,445,492},{365,367,368,369},68,"H","Royal Apothecary Society",2},
[1519] = {'Deathguard Simmer',1210,1210,23,23,0,{[85]={{40.91,54.17}}},nil,85,{365},nil,68,"H",nil,3},
[1520] = {'Rattlecage Soldier',120,137,6,7,0,{[85]={{48.74,44.24},{46.11,34.26},{48.67,44.1},{45.95,43.34},{43.89,39.83},{44.56,41.29},{47.66,37.06},{45.84,40.43},{46.06,39.07},{46.06,38.8},{45.41,38.33},{49.28,42.32},{50.08,43.19},{49.31,42.81},{50.72,43.96},{49.37,43.41},{49.03,38.12},{49.52,36.83},{46.82,43.92},{46.15,36.1},{49.26,35.94}}},nil,85,nil,nil,21,nil,nil,0},
[1521] = {'Gretchen Dedmar',156,156,8,8,0,{[85]={{61.89,52.73}}},nil,85,{375},{375},68,"H",nil,2},
[1522] = {'Darkeye Bonecaster',126,143,7,8,0,{[85]={{42.39,33.63},{47.74,29.22},{47.88,34.06},{51.01,34.0},{43.32,32.55},{46.17,29.41},{46.6,31.97},{48.27,37.54},{44.88,35.97},{47.72,30.75},{48.21,30.36},{47.11,32.3},{50.45,31.51},{42.83,34.22},{47.33,30.18},{49.16,27.88},{43.59,28.6},{42.68,35.15},{43.87,30.53},{43.93,34.96},{45.63,30.43},{46.99,42.0},{45.27,42.87},{45.39,41.47},{47.44,38.28},{46.75,37.54},{44.39,38.28},{45.36,39.61},{48.33,39.46},{47.41,40.68},{46.77,39.86},{45.42,40.52},{45.15,37.54},{44.42,37.6},{45.26,32.42},{46.19,31.68},{45.27,34.88},{44.59,40.5},{48.91,42.83},{50.22,42.99},{49.88,36.82},{48.3,41.65},{47.58,42.83},{49.59,36.02},{49.22,33.88},{48.73,34.09},{49.02,34.13},{47.67,31.24},{49.02,35.26},{49.21,33.54},{46.87,33.38},{46.91,34.88},{49.24,36.25},{47.48,36.08},{42.69,32.27},{49.82,36.21},{47.75,37.51}}},nil,85,nil,nil,21,nil,nil,0},
[1523] = {'Cracked Skull Soldier',148,166,8,9,0,{[85]={{49.08,31.62},{48.8,29.11},{46.04,30.2},{45.43,28.48},{51.31,33.19},{48.29,27.9},{47.09,28.02},{46.13,33.54},{49.47,32.91},{44.85,29.29},{43.79,35.37},{44.85,31.49},{43.83,32.63},{47.64,34.36},{45.05,34.62},{44.68,33.89},{46.96,30.16},{48.23,32.94},{48.91,33.72},{49.15,33.28},{48.45,32.85},{48.36,34.99},{43.33,31.32},{49.62,34.94}}},nil,85,nil,nil,21,nil,nil,0},
[1525] = {'Rotting Dead',102,120,5,6,0,{[85]={{56.35,46.37},{51.28,53.81},{56.05,47.63},{51.27,51.61},{54.53,54.3},{52.89,54.0},{55.21,48.11},{53.54,46.32},{55.37,51.36},{54.63,49.63},{54.41,50.06},{52.15,46.36},{53.35,50.23},{51.91,47.45},{52.1,50.39},{53.57,47.36},{52.76,49.34},{54.98,57.29},{49.78,56.03},{51.86,58.05},{49.82,53.77},{54.05,55.98},{53.63,55.87},{54.38,56.91},{52.72,57.1},{54.38,59.65},{53.57,58.27},{52.8,59.37},{53.0,53.51},{56.11,49.92},{54.93,50.51},{54.28,55.87},{53.16,54.23},{52.01,58.3},{53.05,56.42},{53.36,56.23}}},nil,85,nil,nil,21,nil,nil,0},
[1526] = {'Ravaged Corpse',120,137,6,7,0,{[85]={{54.82,59.18},{50.64,54.16},{51.36,52.78},{51.9,53.79},{52.25,52.31},{53.94,45.04},{53.57,54.11},{54.7,54.15},{55.51,48.8},{54.2,51.54},{52.1,48.68},{52.62,50.47},{52.0,45.41},{52.73,45.92},{52.74,47.25},{54.17,48.52},{53.55,48.59},{52.67,48.11},{55.82,57.12},{51.96,59.54},{49.24,55.57},{53.38,57.0},{53.74,57.6},{52.2,56.53},{52.15,59.68},{53.62,60.6},{52.95,51.68},{53.32,54.14},{54.07,51.25},{54.52,50.33},{52.24,52.22},{49.3,55.15},{51.62,57.69}}},nil,85,nil,nil,21,nil,nil,0},
[1527] = {'Hungering Dead',137,156,7,8,0,{[85]={{68.1,43.54},{68.15,42.53},{67.54,43.75},{67.76,42.17},{67.62,42.49},{69.55,41.75},{69.67,41.12},{67.3,42.27},{67.51,43.05},{68.45,41.47}}},nil,85,nil,nil,21,nil,nil,0},
[1528] = {'Shambling Horror',156,176,8,9,0,{[85]={{66.7,45.11},{66.71,44.79},{67.96,43.97},{68.74,43.56}}},nil,85,nil,nil,21,nil,nil,0},
[1529] = {'Bleeding Horror',176,198,9,10,0,{[85]={{77.83,59.47},{76.51,59.59},{75.59,59.55},{76.74,60.11},{76.84,62.78},{76.2,62.66},{74.58,59.51},{74.16,62.79},{76.14,61.08},{74.87,61.64},{78.54,60.25},{77.12,61.22}}},nil,85,nil,nil,21,nil,nil,0},
[1530] = {'Rotting Ancestor',198,222,10,11,0,{[85]={{51.31,28.1},{54.72,31.34},{53.41,30.39},{52.1,32.85},{49.76,30.26},{53.26,31.03},{49.73,28.59},{54.36,29.2},{52.67,26.02},{51.58,33.43},{50.58,29.08},{48.6,31.98},{52.31,26.87},{52.4,26.48},{51.28,31.46},{52.69,26.13},{52.6,26.67},{52.02,30.57},{52.24,26.36},{51.99,26.9},{52.66,26.42},{51.73,27.04},{51.81,25.72}}},nil,85,nil,nil,21,nil,nil,0},
[1531] = {'Lost Soul',120,137,6,7,4,{[85]={{53.18,48.37},{53.34,45.6},{44.6,40.51}}},{[85]={{{44.6,40.51},{44.61,40.42},{44.67,40.45},{45.0,41.08},{44.74,40.54},{44.65,40.52},{44.47,40.82},{44.55,40.58},{44.02,40.97},{43.77,41.31},{43.79,42.04},{44.05,42.37},{44.81,42.71},{45.33,42.85},{45.76,42.79},{46.29,42.7},{46.93,42.59},{47.16,42.27},{47.27,41.94},{47.37,41.3},{47.23,40.71},{47.05,40.42},{46.88,40.1},{46.76,39.61},{46.68,38.95},{46.31,38.23},{45.94,37.86},{45.53,37.61},{45.1,37.38},{44.69,37.19},{44.25,36.73},{44.5,37.27},{44.77,37.22},{44.83,37.16},{44.74,37.15},{44.42,36.69},{44.87,36.65},{44.79,37.03},{44.79,37.03},{44.73,37.13},{45.43,37.5},{46.11,37.81},{46.58,38.4},{46.78,39.29},{46.85,40.03},{47.23,40.78},{46.53,40.54},{46.47,40.02},{46.79,40.26},{46.82,40.13},{46.55,40.49},{46.55,40.49},{46.8,40.11},{46.21,40.24},{45.78,40.44},{45.34,40.43}}}},85,nil,nil,21,nil,nil,0},
[1532] = {'Wandering Spirit',198,222,10,11,0,{[85]={{75.81,60.48},{76.48,60.74},{78.46,59.38},{77.37,58.65},{76.5,58.73},{75.23,58.2},{75.08,59.13},{75.58,61.39},{74.22,61.47},{75.01,60.48},{77.94,61.29},{76.84,61.55}}},nil,85,nil,nil,21,nil,nil,0},
[1533] = {'Tormented Spirit',156,176,8,9,4,{[85]={{45.59,31.62}}},{[85]={{{44.16,31.71},{44.37,31.39},{44.78,31.21},{45.55,31.18},{45.93,31.16},{46.15,31.09},{46.5,30.85},{46.61,30.84},{46.74,30.97},{46.87,31.19},{46.94,31.39},{47.48,32.3},{47.8,32.91},{47.99,33.69},{48.07,34.27},{48.02,34.68},{47.95,34.91},{47.56,35.64},{47.21,36.03},{46.92,36.26},{46.27,36.57},{46.05,36.63},{45.78,36.63},{45.61,36.56},{45.43,36.16},{45.25,35.77},{45.05,35.53},{44.87,35.43},{44.62,35.34},{44.39,35.31},{44.06,34.76},{44.15,34.11},{44.17,33.63},{44.16,33.13},{44.07,32.67},{44.04,32.4},{44.16,31.71}}}},85,nil,nil,21,nil,nil,0},
[1534] = {'Wailing Ancestor',176,198,9,10,0,{[85]={{52.68,29.32},{55.16,29.96},{52.87,27.04},{54.74,29.53},{53.96,29.82},{51.87,31.48},{53.52,28.0},{51.97,26.58},{52.11,26.33},{50.98,30.53},{51.42,29.26},{52.23,27.45},{51.87,28.76},{52.59,25.78},{51.99,26.15},{52.03,25.63}}},nil,85,nil,nil,21,nil,nil,0},
[1535] = {'Scarlet Warrior',120,137,6,7,0,{[85]={{31.83,51.09},{30.87,46.57},{30.39,49.13},{33.62,45.29},{30.64,47.61},{29.95,49.97},{29.72,49.47},{31.39,50.4},{30.46,51.27},{32.15,45.0},{34.14,51.4},{32.22,49.25},{31.28,48.43},{32.62,51.2},{32.12,49.34},{33.64,49.24},{37.4,47.71},{36.93,48.18},{33.53,47.36},{36.17,47.41},{32.95,46.63},{30.75,46.19},{34.25,47.84},{34.47,49.43},{32.77,48.22},{32.21,46.72},{33.6,48.4},{31.73,46.42},{31.68,46.3},{32.08,47.4},{31.81,46.45},{31.88,46.04},{31.68,45.88},{31.68,46.24},{31.98,45.91}}},nil,85,nil,nil,67,nil,nil,0},
[1536] = {'Scarlet Missionary',137,156,7,8,0,{[85]={{43.23,65.17},{46.13,65.07},{48.85,66.77},{44.46,64.99},{46.68,64.05},{48.19,66.38},{50.15,68.82},{50.54,67.75},{53.37,68.11},{52.78,67.42},{51.05,69.71},{50.23,66.93},{51.65,66.7}}},nil,85,nil,nil,67,nil,nil,0},
[1537] = {'Scarlet Zealot',156,176,8,9,0,{[85]={{88.22,42.58},{87.44,42.91},{87.12,43.24},{87.45,43.43},{86.98,44.71},{86.83,42.25},{79.91,56.36},{80.29,57.09},{86.83,43.39},{86.99,41.51},{86.06,41.84},{85.8,43.46},{87.84,43.93},{87.35,41.71},{80.65,55.12},{81.04,55.39},{48.82,66.18},{80.98,56.86},{53.66,66.0},{50.6,67.96},{81.68,54.83},{51.96,69.55},{54.34,69.28},{53.81,66.82},{52.66,67.36},{51.19,67.6},{50.46,64.71},{79.59,55.17},{77.13,55.12},{76.62,54.76},{76.25,55.21},{76.88,56.2},{77.18,56.77},{78.38,56.03},{85.34,42.75},{52.91,69.04},{52.18,68.55},{51.75,66.09},{52.15,67.13},{51.15,65.71},{51.52,67.59},{52.05,68.13}}},nil,85,nil,nil,67,nil,nil,0},
[1538] = {'Scarlet Friar',166,186,9,10,0,{[85]={{86.94,42.29},{86.76,43.06},{87.02,43.81},{87.15,43.46},{81.6,53.1},{86.58,44.92},{87.16,42.73},{79.35,24.58},{79.32,26.08},{80.96,57.25},{80.65,55.12},{81.11,56.9},{77.1,54.88},{79.49,25.98},{78.32,56.26},{76.11,57.23},{78.86,56.23},{78.65,55.38},{79.02,31.23},{79.45,55.51},{79.4,56.24},{78.49,56.04},{78.88,36.1}}},nil,85,nil,nil,67,nil,nil,0},
[1539] = {'Scarlet Neophyte',186,208,10,11,0,{[85]={{79.12,27.09},{79.72,24.67},{79.02,28.53},{79.05,25.6},{78.46,32.49}}},nil,85,nil,nil,67,nil,nil,0},
[1540] = {'Scarlet Vanguard',198,222,10,11,0,{[85]={{77.65,32.79},{79.26,24.44},{78.13,32.1},{79.39,29.67},{78.45,32.82},{79.64,26.07},{77.87,35.44},{78.67,36.09},{77.61,34.71}}},nil,85,nil,nil,67,nil,nil,0},
[1541] = {'Vile Fin Murloc',156,176,8,9,0,nil,nil,0,nil,nil,18,nil,nil,0},
[1543] = {'Vile Fin Puddlejumper',137,156,7,8,0,{[85]={{34.31,44.17},{30.12,43.61},{34.91,44.7},{30.7,44.6},{36.14,43.03},{29.65,44.95},{63.12,27.52},{35.92,43.02},{30.34,45.59},{30.45,43.29},{35.61,42.16},{60.71,27.18},{61.84,26.94},{34.59,41.28},{30.13,44.64},{63.21,27.91},{34.66,40.92},{30.65,45.02},{29.44,45.08},{36.18,39.21},{61.66,27.86},{58.51,28.79},{58.57,28.83},{37.0,41.93},{57.7,28.3},{61.57,29.4},{62.63,30.69},{57.69,26.06},{58.58,26.86},{58.11,26.5},{58.91,27.1},{58.56,28.13},{60.77,28.36},{59.71,28.85}}},nil,85,nil,nil,18,nil,nil,0},
[1544] = {'Vile Fin Minor Oracle',148,166,8,9,0,{[85]={{75.13,26.54},{34.73,40.81},{63.4,27.82},{34.45,41.6},{29.83,44.78},{36.36,44.57},{35.97,42.89},{29.16,45.85},{30.81,44.94},{62.94,28.8},{63.09,29.49},{60.93,27.21},{26.24,46.34},{35.6,43.33},{35.79,39.49},{75.15,26.93},{67.42,24.47},{67.34,24.85},{31.07,43.17},{37.01,40.78},{30.65,43.62},{34.96,40.76},{35.83,43.5},{62.26,28.28},{62.76,28.28},{33.66,42.8},{31.37,43.75},{70.54,25.74},{67.48,25.78},{35.56,44.27},{34.62,43.51},{30.47,43.37},{36.83,45.09},{30.69,43.22},{64.03,28.69},{26.07,47.28},{64.54,29.79},{64.86,29.74},{67.9,25.4},{70.45,25.27},{58.34,28.13},{36.53,35.95},{36.43,40.6},{36.7,42.02},{64.04,30.62},{61.3,29.99},{61.73,28.2},{57.89,26.3},{58.45,27.59},{58.85,27.08},{60.15,27.28},{59.43,29.07},{59.75,28.88},{59.39,28.35},{60.86,27.58},{60.07,28.38}}},nil,85,nil,nil,18,nil,nil,0},
[1545] = {'Vile Fin Muckdweller',176,198,9,10,0,{[85]={{70.06,24.97},{68.7,25.42},{73.46,24.98},{67.7,28.47},{64.54,29.07},{67.57,27.31},{66.88,26.26},{74.56,26.4},{72.69,26.41},{34.81,44.96},{38.08,29.5},{72.01,27.25},{74.08,26.17},{66.72,28.12},{65.21,30.43},{66.16,29.79},{67.54,29.5},{65.31,28.61},{65.96,27.37},{72.34,25.62},{74.8,27.09},{34.84,42.43},{29.85,41.5},{25.3,47.35},{26.0,48.35},{75.45,26.39},{74.97,27.63},{68.01,28.64},{75.66,26.13},{72.54,26.1},{73.31,27.16},{69.61,26.01},{30.51,42.77},{34.29,43.59},{75.09,26.76},{75.57,26.38},{64.56,29.62},{64.66,30.38},{64.72,30.36},{75.17,27.39},{69.06,25.45},{70.17,25.63},{35.76,41.45},{26.81,46.77},{25.48,48.47},{75.39,26.91},{64.44,29.68},{70.42,27.12},{71.23,26.17},{66.99,26.17},{72.01,25.22},{68.22,26.06},{67.8,25.84},{38.58,30.57},{39.55,34.75},{38.01,35.1},{40.88,34.96},{36.53,38.39},{36.53,40.63},{36.44,42.63}}},nil,85,nil,nil,18,nil,nil,0},
[1547] = {'Decrepit Darkhound',102,120,5,6,0,{[85]={{38.64,40.26},{40.67,42.86},{41.33,49.62},{40.69,52.67},{50.0,47.35},{64.41,48.26},{40.75,44.96},{38.71,43.68},{51.09,50.53},{60.52,40.44},{64.54,53.54},{37.49,45.14},{49.96,49.76},{62.84,38.09},{66.09,50.33},{38.97,40.74},{41.51,48.8},{44.46,57.02},{38.78,44.65},{39.91,46.25},{38.47,47.3},{65.15,49.15},{61.01,44.43},{38.6,41.76},{48.97,58.95},{61.62,40.44},{67.54,52.64},{37.96,41.45},{38.74,45.46},{41.87,42.43},{62.83,40.52},{39.98,43.74},{61.48,43.88},{39.36,51.99},{39.1,42.58},{62.57,39.4},{40.44,41.24},{40.27,39.69},{41.8,56.22},{48.62,53.68},{44.37,53.33},{45.01,54.17},{67.46,55.03},{61.82,45.6},{64.58,43.12},{63.7,43.46},{69.6,63.78},{64.37,40.14},{70.62,65.06},{62.91,47.94},{63.53,46.33},{42.62,40.64},{40.18,56.35},{55.31,53.39},{63.64,41.67},{68.59,54.4},{68.4,57.8},{65.13,37.39},{66.47,56.88},{66.13,55.62},{42.66,50.05},{41.02,55.73},{46.12,57.35},{47.98,58.58},{59.49,56.9},{59.89,55.65},{61.08,55.61},{64.84,61.79},{65.88,40.01},{67.21,63.51},{64.13,58.88},{62.37,46.95},{63.05,54.02},{57.81,52.71},{56.56,53.64},{62.58,54.92},{66.16,57.86},{49.29,54.31},{63.33,50.83},{64.14,56.57}}},nil,85,nil,nil,38,nil,nil,0},
[1548] = {'Cursed Darkhound',137,156,7,8,0,{[85]={{68.27,30.71},{68.22,36.18},{45.3,68.49},{41.98,67.46},{47.72,63.34},{40.58,58.42},{40.99,61.61},{42.77,62.4},{46.87,50.13},{74.55,37.64},{72.84,61.52},{77.19,73.85},{81.36,64.7},{75.82,54.27},{65.03,32.77},{75.57,33.04},{73.27,31.66},{72.07,29.47},{69.68,28.53},{74.44,35.97},{66.73,34.78},{48.48,63.9},{49.7,65.81},{50.12,60.92},{45.81,64.22},{53.43,63.3},{47.97,48.4},{47.39,49.09},{74.56,54.33},{81.35,72.07},{71.78,37.99},{68.94,31.68},{70.37,36.06},{72.76,28.47},{66.1,34.96},{42.82,58.13},{41.54,64.48},{45.08,60.83},{50.89,63.4},{49.95,49.88},{47.0,45.44},{80.05,67.21},{72.58,49.24},{75.44,64.58},{71.48,36.14},{71.11,32.65},{69.02,29.64},{67.6,31.61},{76.74,34.8},{43.73,42.92},{42.29,46.98},{42.19,42.79},{46.36,67.73},{48.34,59.02},{44.18,61.89},{52.4,71.35},{43.86,60.57},{46.26,46.11},{45.14,47.69},{74.82,69.88},{72.99,41.41},{69.06,35.61},{76.46,31.02},{68.93,33.94},{74.04,28.66},{44.67,66.98},{46.74,60.64},{43.81,62.01},{71.93,61.83},{79.89,69.31},{70.36,29.51},{68.05,34.65},{44.96,43.88},{44.59,40.39},{43.34,45.23},{40.56,60.87},{50.62,62.26},{49.18,62.89},{43.21,68.06},{41.47,65.51},{44.52,45.21},{78.55,66.53},{73.2,38.06},{74.88,46.04},{77.85,72.55},{72.61,47.61},{79.21,61.57},{75.78,73.55},{71.14,59.5},{77.53,71.35},{79.02,63.99},{72.86,56.89},{79.7,66.08},{76.52,70.21},{76.94,68.05},{71.84,47.24},{80.86,63.99},{76.92,64.87},{77.52,68.54},{72.68,46.47},{74.64,44.25},{41.25,44.38},{75.64,45.37},{75.01,68.77},{45.07,47.84},{45.94,46.91},{40.26,42.53},{80.5,72.54},{80.23,58.62},{54.34,63.68},{52.47,74.61},{46.08,50.86},{47.33,50.98},{44.78,54.38},{48.25,50.0},{54.06,66.91},{56.62,64.36},{68.06,36.98},{72.63,32.62},{78.03,32.68},{74.14,35.26},{70.52,31.53},{53.99,65.72},{72.61,43.66},{72.01,52.09},{80.59,60.6},{74.95,72.64},{78.89,59.09},{57.47,63.0},{51.19,70.22},{52.01,72.34},{55.6,66.1},{44.26,58.24},{54.91,71.44},{53.01,65.15},{52.84,72.48},{58.3,58.28},{63.38,33.72},{51.45,60.03},{57.94,60.62},{76.19,52.4},{69.03,59.87},{41.87,45.03},{57.35,62.38},{60.21,62.17},{58.42,62.67},{58.42,59.95},{57.06,59.58},{72.21,40.24},{77.75,63.4},{76.44,29.6},{59.43,60.73},{48.61,56.67},{55.69,65.66},{55.26,69.82},{55.69,73.58}}},nil,85,nil,nil,38,nil,nil,0},
[1549] = {'Ravenous Darkhound',176,198,9,10,0,{[85]={{88.25,41.72},{86.79,39.09},{84.43,41.47},{85.85,39.47},{83.2,47.36},{81.96,47.03},{82.99,50.38},{88.87,44.94},{83.28,41.74},{87.4,46.03},{89.79,41.8},{90.3,47.12},{89.51,43.89},{90.35,40.61},{86.08,37.85},{82.98,48.81},{88.21,43.81},{88.16,46.39},{89.42,47.86},{79.59,49.52},{86.97,45.34},{88.93,46.73},{88.16,48.5},{82.23,48.32},{83.89,44.2},{83.63,46.04},{83.9,41.45},{85.13,44.04},{85.07,45.99},{85.97,45.06},{81.48,45.15},{80.17,42.44},{82.11,43.56}}},nil,85,nil,nil,38,nil,nil,0},
[1550] = {'Thrashtail Basilisk',1902,1981,41,42,0,{[33]={{39.1,49.48},{40.43,52.14},{39.08,50.42},{39.08,52.02},{38.26,50.5},{37.85,49.87},{39.28,47.1},{40.41,48.69},{40.38,50.63},{40.78,49.95},{40.91,51.33},{41.35,50.57},{38.8,44.94}}},nil,33,nil,nil,49,nil,nil,0},
[1551] = {'Ironjaw Basilisk',2059,2138,43,44,0,{[33]={{42.67,47.82},{42.4,48.41},{43.39,47.9},{42.67,48.27},{43.69,48.33},{43.84,47.8},{42.6,49.37},{43.01,49.16},{43.48,49.14},{44.01,48.36},{43.9,49.11},{44.19,47.83},{43.63,46.21},{43.46,47.04},{43.63,46.73},{42.71,45.84},{43.5,45.92},{42.77,48.94},{41.87,46.96},{42.27,47.25},{42.08,47.01}}},nil,33,nil,nil,49,nil,nil,0},
[1552] = {'Scale Belly',2218,2218,45,45,4,{[33]={{43.44,45.71},{42.61,46.49},{41.79,48.36},{43.74,47.5}}},nil,33,nil,nil,49,nil,nil,0},
[1553] = {'Greater Duskbat',120,137,6,7,0,{[85]={{41.71,57.42},{41.77,40.32},{44.6,49.41},{49.98,48.54},{65.88,53.24},{67.04,56.56},{62.48,41.77},{62.49,43.54},{65.42,38.58},{50.89,59.33},{49.21,59.63},{41.13,47.43},{41.45,56.92},{51.36,49.55},{46.81,50.28},{46.75,50.84},{65.18,41.74},{67.08,51.8},{65.49,56.61},{63.28,47.06},{40.06,52.66},{36.49,47.27},{37.93,43.91},{37.31,43.48},{44.46,50.13},{45.23,51.2},{62.9,35.81},{64.29,46.01},{64.17,44.13},{46.67,60.16},{49.49,49.69},{62.3,43.91},{62.97,45.96},{64.77,50.15},{60.45,43.15},{64.04,54.89},{64.73,40.44},{41.08,42.21},{42.32,44.19},{63.16,38.69},{63.28,41.72},{61.77,41.38},{43.28,56.19},{37.44,46.4},{62.21,36.85},{60.91,38.49},{64.33,36.57},{37.5,38.75},{64.88,38.2},{62.87,44.02},{64.09,37.77},{66.67,62.26},{41.9,53.66},{40.13,55.64},{38.48,38.57},{40.31,48.65},{42.47,42.37},{59.98,41.84},{65.07,54.57},{45.54,58.9},{39.14,47.79},{66.53,53.61},{39.31,42.22},{53.63,64.97},{63.67,49.22},{66.83,55.91},{55.75,61.0},{56.59,62.94},{51.87,48.39},{46.8,52.52},{55.05,64.03},{55.5,63.43},{47.25,46.41},{54.22,65.86},{47.93,45.09},{45.69,52.54},{42.98,57.33},{61.65,38.76},{43.26,41.51},{66.28,54.51},{63.27,47.58},{71.01,63.81},{64.46,57.33},{68.26,62.85},{45.42,57.32},{46.58,58.0},{69.05,53.87},{42.75,47.67},{48.81,57.69},{53.38,64.14},{45.84,54.41},{45.86,56.37},{54.08,61.72},{54.99,62.57},{52.49,63.5},{43.1,46.2},{61.1,56.3},{67.99,54.12},{43.77,55.87},{58.55,56.18},{57.98,55.23},{58.01,57.08},{58.82,58.43},{62.22,56.57},{60.34,60.85},{58.44,57.0},{56.86,55.74},{47.36,55.25},{45.33,54.6},{57.43,59.72},{56.33,57.46},{59.32,61.61},{57.09,54.21},{63.19,49.72},{45.79,54.81},{48.86,55.02},{47.41,56.25},{59.26,56.08},{63.79,61.45},{64.72,58.45}}},nil,85,nil,nil,15,"AH",nil,0},
[1554] = {'Vampiric Duskbat',156,176,8,9,0,{[85]={{71.91,33.74},{65.79,34.95},{66.16,31.68},{73.69,33.91},{76.39,30.31},{72.81,30.56},{49.12,59.82},{44.43,62.56},{43.12,67.06},{71.24,46.76},{80.08,62.34},{78.58,73.42},{81.94,74.25},{74.75,44.22},{83.58,48.38},{67.49,34.01},{69.66,34.79},{41.63,63.35},{47.52,62.19},{48.62,63.57},{44.72,60.3},{78.7,69.73},{75.65,55.78},{82.23,66.0},{71.15,36.91},{73.44,36.09},{72.68,65.31},{83.74,51.59},{71.06,34.61},{70.44,33.73},{68.55,28.26},{76.8,31.63},{43.95,68.04},{44.93,63.15},{48.38,63.21},{45.34,66.28},{45.55,62.82},{72.77,58.29},{78.19,70.24},{80.68,66.42},{70.96,58.38},{90.39,44.81},{74.16,32.65},{71.84,31.55},{69.7,30.47},{45.88,67.28},{42.07,59.36},{44.88,69.1},{80.18,64.27},{74.19,71.5},{72.64,37.19},{74.58,58.68},{78.61,71.69},{88.7,42.83},{71.24,30.5},{68.19,32.83},{69.71,32.85},{65.48,33.81},{64.49,36.56},{41.63,60.87},{46.27,61.55},{43.24,63.05},{76.14,63.72},{75.78,51.26},{79.34,70.72},{69.79,60.66},{74.99,52.96},{78.84,62.44},{82.82,46.29},{87.29,38.45},{84.85,39.1},{73.27,29.22},{40.62,60.04},{47.95,67.82},{73.04,39.29},{82.03,64.61},{76.41,66.18},{71.18,48.21},{79.58,69.23},{70.52,61.23},{80.5,59.27},{81.28,66.52},{72.69,47.08},{75.45,47.13},{83.06,44.32},{73.97,67.34},{75.72,47.92},{83.65,66.33},{80.7,70.51},{72.08,59.83},{75.47,72.43},{72.77,62.58},{80.08,72.81},{87.28,40.63},{90.37,42.78},{84.63,40.78},{71.7,49.04},{74.55,47.25},{76.95,71.27},{80.36,67.74},{71.26,50.06},{73.37,59.35},{78.73,64.6},{73.26,40.59},{46.85,66.39},{48.71,61.97},{72.86,42.64},{75.38,35.09},{50.71,61.71},{79.25,58.98},{80.66,46.27},{73.2,44.29},{76.61,72.33},{73.67,57.12},{42.17,58.58},{51.39,61.76},{52.88,63.65},{51.92,63.37},{70.18,53.68},{75.44,46.14},{84.13,43.06},{79.28,48.69},{82.9,42.61},{82.52,42.77},{84.37,44.89},{78.98,45.89},{82.22,52.76},{78.64,44.93},{81.14,48.19},{80.04,44.52},{74.89,64.03},{77.67,46.19},{76.79,48.29},{74.88,33.72}}},nil,85,nil,nil,16,nil,nil,0},
[1555] = {'Vicious Night Web Spider',176,198,9,10,0,{[85]={{85.97,52.54},{83.68,52.4},{87.51,53.85},{87.31,51.21},{89.51,52.54},{91.75,49.54},{85.67,52.55},{83.41,55.56},{90.32,49.28},{84.49,50.11},{87.44,56.06},{86.76,57.01},{88.89,53.73},{85.88,57.29},{85.95,53.68},{83.77,55.38},{89.69,51.7},{87.98,53.67},{91.05,50.53},{86.62,53.76},{84.68,52.83},{85.42,55.1},{89.06,49.81},{86.74,53.2},{89.8,50.44},{85.11,50.97},{88.18,54.95},{84.47,51.01},{85.18,48.34},{84.54,47.17},{87.38,49.29},{85.91,49.26},{86.72,48.38},{86.73,50.53},{88.13,50.41},{82.43,54.77}}},nil,85,nil,nil,22,nil,nil,0},
[1557] = {'Elder Mistvale Gorilla',1829,1902,40,41,0,{[33]={{34.4,62.52},{31.35,60.7},{34.99,64.44},{34.46,66.73},{34.62,65.42},{34.13,66.37},{33.54,67.02},{33.86,67.52},{33.05,67.58},{32.33,68.43},{32.11,66.14},{31.43,65.37},{32.57,66.64},{31.9,67.57},{30.88,66.73},{31.15,67.93},{32.42,57.97},{30.85,60.03},{33.6,62.23},{33.17,63.43},{33.51,63.62},{33.03,66.12},{33.05,64.84},{32.59,65.45},{34.01,64.54},{33.48,65.45},{32.01,59.82},{32.45,59.13}}},nil,33,nil,nil,72,nil,nil,0},
[1558] = {'Silverback Patriarch',1981,2059,42,43,0,{[33]={{35.51,62.7},{35.15,63.43},{37.85,60.84},{37.14,62.25},{37.76,62.16},{36.41,62.4},{35.48,63.33},{36.28,63.87},{37.89,59.95}}},nil,33,nil,nil,72,nil,nil,0},
[1559] = {'King Mukla',11460,11460,51,51,1,{[33]={{40.95,83.9}}},nil,33,nil,nil,16,nil,nil,0},
[1560] = {'Yvette Farthing',328,328,15,15,0,{[85]={{61.58,52.6}}},nil,85,nil,{361},68,"H",nil,2},
[1561] = {'Bloodsail Raider',1750,1902,39,41,0,{[33]={{32.34,71.67},{33.07,73.96},{33.46,73.28},{32.44,73.12},{28.06,70.35},{27.6,69.44},{27.52,69.63},{27.29,69.97}}},nil,33,nil,nil,119,nil,nil,0},
[1562] = {'Bloodsail Mage',1248,1332,39,41,0,{[33]={{32.05,72.53},{27.94,69.91},{27.52,69.26},{27.39,69.72},{26.04,67.18},{26.84,67.52},{25.76,66.03},{28.89,70.72}}},nil,33,nil,nil,119,nil,nil,0},
[1563] = {'Bloodsail Swashbuckler',1902,2059,41,43,0,{[33]={{24.49,53.96},{24.38,54.06},{24.44,53.82},{23.16,52.79},{23.86,53.8},{33.85,86.16},{28.23,82.4},{27.02,83.01},{26.86,83.85},{26.91,82.98},{26.53,83.51},{27.2,83.37},{26.67,82.84},{32.98,77.25},{31.95,79.47},{30.96,81.07},{30.1,87.5},{24.08,55.96}}},nil,33,nil,nil,119,nil,nil,0},
[1564] = {'Bloodsail Warlock',1332,1441,41,43,0,{[33]={{22.77,53.91},{24.51,54.06},{24.48,52.78},{22.86,53.39},{23.48,53.58},{33.53,86.52},{26.84,82.6},{29.88,81.21},{29.67,81.54},{29.62,80.93},{29.65,80.81},{29.39,81.33},{27.65,82.52},{27.32,82.48},{27.18,82.74},{29.99,80.57},{29.73,87.47},{29.97,87.95},{23.09,54.66},{24.24,54.55}}},nil,33,nil,nil,119,nil,nil,0},
[1565] = {'Bloodsail Sea Dog',2059,2217,43,45,0,{[33]={{31.89,53.88},{32.07,54.62},{32.01,54.29},{31.79,54.58},{31.94,54.41},{31.51,54.26},{31.98,54.43},{29.38,88.62},{29.44,89.02},{29.25,89.07},{31.8,54.2},{30.69,90.34},{32.75,56.35},{30.71,89.95},{29.22,88.35},{29.42,88.91},{30.7,90.25},{30.7,90.02},{30.65,89.57},{32.76,56.52},{32.02,55.93},{31.99,56.08},{32.03,55.85}}},nil,33,nil,nil,119,nil,nil,0},
[1568] = {'Undertaker Mordo',102,102,5,5,0,{[85]={{30.22,71.65}}},nil,85,{363},nil,68,"H",nil,2},
[1569] = {'Shadow Priest Sarvis',102,102,5,5,0,{[85]={{30.84,66.2}}},nil,85,{364,3095,3096,3097,3098,3099,3901},{363,364,3901},68,"H",nil,3},
[1570] = {'Executor Arren',102,102,5,5,0,{[85]={{32.15,66.01}}},nil,85,{380,381,382,383},{380,381,382},68,"H",nil,2},
[1571] = {'Shellei Brondir',7842,7842,55,55,1,{[11]={{9.49,59.69}}},nil,11,nil,nil,12,"A","Gryphon Master",11},
[1572] = {'Thorgrum Borrelson',7842,7842,55,55,1,{[38]={{33.94,50.95}}},nil,38,{6391},{6387},55,"A","Gryphon Master",11},
[1573] = {'Gryth Thurden',7842,7842,55,55,1,{[1537]={{55.5,47.74}}},nil,1537,{6392},{6388},55,"A","Gryphon Master",11},
[1574] = {'Mage 1',40,40,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1575] = {'Mage 5',95,95,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1576] = {'Mage 10',178,178,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1577] = {'Mage 15',285,285,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1578] = {'Mage 20',405,405,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1579] = {'Mage 30',774,774,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1580] = {'Mage 40',1239,1239,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1581] = {'Warlock 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1582] = {'Warlock 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1583] = {'Warlock 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1584] = {'Warlock 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1585] = {'Warlock 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1586] = {'Warlock 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1587] = {'Warlock 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1588] = {'Shaman 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1589] = {'Shaman 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1590] = {'Shaman 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1591] = {'Shaman 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1592] = {'Shaman 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1593] = {'Shaman 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1594] = {'Shaman 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1595] = {'Rogue 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1596] = {'Rogue 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1597] = {'Rogue 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1598] = {'Rogue 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1599] = {'Rogue 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1600] = {'Rogue 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1601] = {'Rogue 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1602] = {'Paladin 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1603] = {'Paladin 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1604] = {'Druid 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1605] = {'Paladin 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1606] = {'Paladin 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1607] = {'Druid 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1608] = {'Druid 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1609] = {'Druid 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1613] = {'Paladin 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1614] = {'Paladin 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1615] = {'Paladin 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1616] = {'Druid 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1617] = {'Druid 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1618] = {'Hunter 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1619] = {'Druid 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1620] = {'Hunter 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1621] = {'Hunter 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1622] = {'Priest 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1623] = {'Hunter 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1624] = {'Priest 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1625] = {'Hunter 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1626] = {'Priest 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1627] = {'Priest 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1628] = {'Hunter 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1629] = {'Priest 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1631] = {'Hunter 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1632] = {'Adele Fielder',573,573,22,22,0,{[12]={{46.38,62.05}}},nil,12,nil,nil,12,"A","Journeyman Leatherworker",17},
[1633] = {'Priest 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1634] = {'Priest 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1635] = {'Warrior 1',42,42,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1636] = {'Warrior 5',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1637] = {'Warrior 10',198,198,10,10,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1638] = {'Warrior 15',328,328,15,15,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1639] = {'Warrior 20',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1640] = {'Warrior 30',1003,1003,30,30,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1641] = {'Warrior 40',1753,1753,40,40,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1642] = {'Northshire Guard',5228,5228,55,55,0,{[12]={{47.15,47.87},{46.12,47.88},{45.59,48.46},{45.37,48.43},{44.03,47.31},{44.16,46.8},{48.11,42.12}}},nil,12,nil,nil,11,"A",nil,0},
[1645] = {'Quartermaster Hicks',198,198,10,10,0,{[12]={{25.37,74.0}}},nil,12,nil,nil,12,"A","Master Weaponsmith",16388},
[1646] = {'Baros Alexston',1002,1002,30,30,0,{[1519]={{49.19,30.28}}},nil,1519,{389,393,396,399},{373,392,395,399},12,"A","City Architect",2},
[1649] = {'UNUSED Jordan Croft',55,55,1,1,0,nil,nil,0,nil,nil,875,"A","Reuse Me",0},
[1650] = {'Terry Palin',222,222,11,11,0,{[12]={{82.95,63.31}}},nil,12,nil,nil,12,"A","Lumberjack",4},
[1651] = {'Lee Brown',156,156,8,8,0,{[12]={{47.61,62.32}}},nil,12,nil,nil,12,"A","Fisherman",17},
[1652] = {'Deathguard Burgess',1302,1302,24,24,0,{[85]={{60.93,52.01}}},nil,85,{374},{374},68,"H",nil,3},
[1653] = {'Bloodsail Elder Magus',1496,1552,44,45,0,{[33]={{31.89,53.88},{32.07,54.62},{32.01,54.29},{31.79,54.58},{31.94,54.41},{31.51,54.26},{31.98,54.43},{29.4,88.79},{31.8,54.2},{33.6,88.12},{32.9,88.32},{33.63,88.11},{32.75,56.35},{30.57,89.69},{29.28,88.57},{30.71,89.45},{29.27,89.03},{32.76,56.52},{32.02,55.93},{31.99,56.08},{32.03,55.85}}},nil,33,nil,nil,119,nil,nil,0},
[1654] = {'Gregor Agamand',198,198,10,10,0,{[85]={{46.74,29.31}}},nil,85,nil,nil,21,nil,nil,0},
[1655] = {'Nissa Agamand',198,198,10,10,0,{[85]={{49.74,36.34}}},{[85]={{{49.74,36.34},{49.65,36.18},{49.48,36.1},{49.45,35.97},{49.45,35.88},{49.51,35.64},{49.55,35.62},{49.61,35.68},{49.63,35.81},{49.59,36.03},{49.42,36.06},{49.35,36.03},{49.64,36.15},{49.79,36.22},{49.64,36.15},{49.42,36.06},{49.35,36.03},{49.59,36.03},{49.63,35.81},{49.61,35.68},{49.55,35.62},{49.51,35.64},{49.45,35.88},{49.45,35.97},{49.48,36.1},{49.65,36.18},{49.74,36.34}}}},85,nil,nil,21,nil,nil,0},
[1656] = {'Thurman Agamand',197,197,10,10,0,{[85]={{44.0,33.64}}},nil,85,nil,nil,21,nil,nil,0},
[1657] = {'Devlin Agamand',176,176,9,9,0,{[85]={{47.34,40.78}}},nil,85,nil,nil,21,nil,nil,0},
[1658] = {'Captain Dargol',273,273,13,13,0,{[85]={{52.81,26.35}}},nil,85,nil,nil,21,nil,nil,0},
[1660] = {'Scarlet Bodyguard',156,156,8,8,0,{[85]={{79.44,25.12},{79.46,25.25}}},nil,85,nil,nil,67,nil,nil,0},
[1661] = {'Novice Elreth',71,71,3,3,0,{[85]={{30.86,66.05}}},nil,85,{376,6395},{376,6395},68,"H",nil,2},
[1662] = {'Captain Perrine',176,176,9,9,0,{[85]={{51.14,67.8}}},nil,85,nil,nil,67,nil,nil,0},
[1663] = {'Dextren Ward',2250,2250,26,26,1,{[717]={{-1,-1}}},nil,717,nil,nil,41,nil,nil,0},
[1664] = {'Captain Vachon',222,222,11,11,0,{[85]={{78.82,56.13}}},nil,85,nil,nil,67,nil,nil,0},
[1665] = {'Captain Melrache',247,247,12,12,0,{[85]={{79.52,25.15}}},nil,85,nil,nil,67,nil,nil,0},
[1666] = {'Kam Deepfury',2400,2400,27,27,1,{[717]={{-1,-1}}},nil,717,nil,nil,41,nil,nil,0},
[1667] = {'Meven Korgal',103,103,5,5,0,{[85]={{36.57,68.54}}},{[85]={{{36.57,68.54},{36.48,68.85}}}},85,nil,nil,67,nil,nil,0},
[1668] = {'William MacGregor',328,328,15,15,0,{[40]={{57.71,53.94}}},nil,40,nil,nil,12,"A","Bowyer",16388},
[1669] = {'Defias Profiteer',484,484,20,20,0,{[40]={{43.47,66.76}}},nil,40,nil,nil,35,"AH","Free Wheeling Merchant",16388},
[1670] = {'Mike Miller',484,484,20,20,0,{[40]={{57.75,53.71}}},nil,40,nil,nil,12,"A","Bread Merchant",4},
[1671] = {'Lamar Veisilli',712,712,25,25,0,{[44]={{21.07,46.25}}},nil,44,nil,nil,12,"A","Fruit Seller",6},
[1672] = {'Lohgan Eva',102,102,5,5,0,{[10]={{75.71,44.56}}},nil,10,nil,nil,12,"A","Tailoring Supplies",4},
[1673] = {'Alyssa Eva',137,137,7,7,0,{[10]={{76.28,45.27}}},nil,10,nil,nil,12,"A","Reagent Vendor",4},
[1674] = {'Rot Hide Gnoll',120,137,6,7,0,{[85]={{58.8,33.74},{57.12,33.84},{58.77,42.73},{57.59,39.38},{59.41,44.22},{58.5,44.0},{56.94,38.22},{56.71,35.4},{57.89,37.2},{57.35,36.15},{60.0,34.02},{59.47,35.01},{58.69,41.96},{59.22,39.27},{58.78,38.53},{58.5,40.59},{59.35,44.21}}},nil,85,nil,nil,70,nil,nil,0},
[1675] = {'Rot Hide Mongrel',137,156,7,8,0,{[85]={{57.97,35.17},{59.92,36.09},{56.34,33.71},{57.84,31.54},{57.91,32.51},{59.53,32.68},{58.61,36.11},{59.4,37.09},{59.35,33.69},{58.59,37.5},{60.89,32.48},{60.94,37.35},{60.47,38.82},{60.18,38.37},{60.79,33.68},{57.47,35.15},{58.73,31.02},{59.51,31.94},{58.4,31.0},{58.16,32.48},{58.6,31.67}}},nil,85,nil,nil,70,nil,nil,0},
[1676] = {'Finbus Geargrind',1106,1106,31,31,0,{[10]={{77.38,48.82}}},nil,10,nil,nil,875,"A","Expert Engineer",17},
[1678] = {'Vernon Hale',198,198,10,10,0,{[44]={{27.49,47.83}}},nil,44,nil,nil,12,"A","Bait and Tackle Supplier",4},
[1679] = {'Avarus Kharag',543,543,23,23,0,{[1]={{68.14,56.12}}},nil,1,nil,nil,57,"A",nil,2},
[1680] = {'Matthew Hooper',198,198,10,10,0,{[44]={{26.99,51.13}}},{[44]={{{26.99,51.13},{26.26,50.65},{26.54,51.26}}}},44,nil,nil,12,"A","Fishing Trainer",17},
[1681] = {'Brock Stoneseeker',328,328,15,15,0,{[38]={{37.02,47.81}}},nil,38,{6387},{6392},55,"A","Mining Trainer",19},
[1682] = {'Yanni Stoutheart',328,328,15,15,0,{[38]={{34.76,48.62}}},nil,38,nil,nil,55,"A","General Supplies",6},
[1683] = {'Warg Deepwater',328,328,15,15,0,{[38]={{40.55,39.7}}},nil,38,nil,nil,55,"A","Fisherman",19},
[1684] = {'Khara Deepwater',328,328,15,15,0,{[38]={{40.28,39.28}}},nil,38,nil,nil,55,"A","Fishing Supplies",6},
[1685] = {'Xandar Goodbeard',328,328,15,15,0,{[38]={{82.47,63.35}}},nil,38,nil,nil,55,"A","General Supplies",6},
[1686] = {'Irene Sureshot',328,328,15,15,0,{[38]={{83.15,63.42}}},nil,38,nil,nil,55,"A","Gunsmith",16388},
[1687] = {'Cliff Hadin',328,328,15,15,0,{[38]={{83.02,62.96}}},nil,38,nil,nil,55,"A","Bowyer",16388},
[1688] = {'Night Web Matriarch',102,102,5,5,0,{[85]={{23.97,58.19}}},nil,85,nil,nil,22,nil,nil,0},
[1689] = {'Scarred Crag Boar',176,198,9,10,0,{[1]={{71.17,54.04},{73.48,50.64},{73.99,52.99},{73.49,55.17},{72.96,59.89},{70.87,61.35},{74.93,60.83},{75.67,57.8},{75.7,49.85},{74.94,48.9},{74.14,49.0},{79.61,51.88},{79.38,55.81},{78.73,59.32},{79.71,57.59},{81.59,55.43},{81.35,53.09},{84.89,50.67},{84.7,48.26},{86.67,50.24},{86.27,47.51},{78.88,49.51},{80.16,47.54},{79.79,46.36},{81.04,43.92},{80.07,43.86},{83.21,38.13},{82.45,37.78},{82.7,35.5},{80.83,35.26},{80.16,34.7},{83.12,33.14}}},nil,1,nil,nil,1094,"AH",nil,0},
[1690] = {'Thrawn Boltar',950,950,29,29,0,{[1]={{45.3,51.53}}},nil,1,nil,nil,55,"A","Blacksmithing Supplies",16390},
[1691] = {'Kreg Bilmn',198,198,10,10,0,{[1]={{47.19,52.4}}},nil,1,nil,nil,55,"A","General Supplies",6},
[1692] = {'Golorn Frostbeard',198,198,10,10,0,{[1]={{46.67,53.49}}},{[1]={{{46.66,53.57},{46.72,53.74},{46.77,53.72},{46.72,53.74},{46.68,53.7},{46.66,53.57},{46.67,53.49},{46.67,53.49}}}},1,nil,nil,55,"A","Tradesman",6},
[1693] = {'Loch Crocolisk',300,328,14,15,0,{[38]={{51.19,34.87},{54.24,56.22},{56.1,37.8},{58.76,36.85},{54.54,41.69},{56.87,39.12},{54.03,39.3},{62.44,51.52},{56.55,36.4},{53.57,37.42},{53.15,39.24},{53.76,40.41},{55.51,33.84},{55.68,35.96},{56.29,37.56},{58.76,57.55},{59.98,41.76},{57.43,31.63},{56.45,52.59},{55.34,52.72},{55.08,52.89},{55.47,53.48},{61.31,43.67},{53.99,55.2},{61.86,45.41},{57.32,21.74},{58.33,23.97}}},nil,38,nil,nil,14,nil,nil,0},
[1694] = {'Loslor Rudge',198,198,10,10,0,{[1]={{50.08,49.42}}},nil,1,{5541},nil,55,"A","Engineering Supplies",7},
[1695] = {'Rendow',1848,1848,45,45,0,{[357]={{89.35,45.86}}},nil,357,nil,nil,80,"A","Leather Armor Merchant",16388},
[1696] = {'Targorr the Dread',1953,1953,24,24,1,{[717]={{-1,-1}}},nil,717,nil,nil,41,nil,nil,0},
[1697] = {'Keeg Gibn',198,198,10,10,0,{[1]={{30.45,46.01}}},nil,1,nil,nil,55,"A","Ale and Wine",6},
[1698] = {'Frast Dokner',156,156,8,8,0,{[1]={{69.0,55.89}}},{[1]={{{69.0,55.89},{68.95,55.84},{68.88,55.86},{68.86,55.95},{68.88,55.87},{68.95,55.85}}}},1,nil,nil,55,"A","Apprentice Weaponsmith",16388},
[1699] = {'Gremlock Pilsnor',198,198,10,10,0,{[1]={{47.67,52.31}}},nil,1,nil,nil,55,"A","Cooking Trainer",19},
[1700] = {'Paxton Ganter',198,198,10,10,0,{[1]={{35.48,40.22}}},nil,1,nil,nil,55,"A","Fisherman",19},
[1701] = {'Dank Drizzlecut',198,198,10,10,0,{[1]={{69.32,55.46}}},nil,1,nil,nil,55,"A","Mining Trainer",19},
[1702] = {'Bronk Guzzlegear',664,664,24,24,0,{[1]={{50.18,50.38}}},nil,1,nil,nil,55,"A","Journeyman Engineer",19},
[1703] = {'Uthrar Threx',664,664,24,24,0,{[1537]={{43.82,27.86}}},nil,1537,nil,nil,55,"A","Journeyman Tailor",19},
[1706] = {'Defias Prisoner',1815,1953,23,24,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1707] = {'Defias Captive',1815,1815,23,23,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1708] = {'Defias Inmate',1953,2097,24,25,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1711] = {'Defias Convict',1953,2097,24,25,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1713] = {'Elder Shadowmaw Panther',1981,2059,42,43,0,{[33]={{35.43,55.67},{36.21,56.74},{36.07,58.39},{35.65,57.77},{31.16,58.55},{36.72,55.93},{36.63,55.25},{36.28,55.26},{29.76,58.01}}},nil,33,nil,nil,16,nil,nil,0},
[1714] = {'SAVE Defias Lifer',787,787,26,26,0,nil,nil,0,nil,nil,17,nil,nil,0},
[1715] = {'Defias Insurgent',2097,2250,25,26,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1716] = {'Bazil Thredd',2715,2715,29,29,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1717] = {'Hamhock',2196,2196,28,28,1,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1718] = {'Rockjaw Raider',71,86,3,4,0,{[1]={{35.56,69.24},{35.0,68.41},{34.09,68.88},{34.87,69.4},{33.86,69.82},{34.56,70.92},{35.62,69.32},{35.62,68.05},{35.69,65.9},{35.77,66.9}}},nil,1,nil,nil,59,nil,nil,0},
[1719] = {'Warden Thelwater',1002,1002,30,30,0,{[1519]={{41.11,58.09}}},nil,1519,{387,391,392},{387,389,391},12,"A",nil,2},
[1720] = {'Bruegal Ironknuckle',2250,2250,26,26,2,{[717]={{-1,-1}}},nil,717,nil,nil,17,nil,nil,0},
[1721] = {'Nikova Raskol',102,102,5,5,0,{[1519]={{69.93,39.05}}},{[1519]={{{70.26,40.3},{70.93,41.1},{71.47,42.0},{72.18,43.06},{72.69,43.74},{73.02,44.76},{73.28,45.54},{73.22,46.21},{73.57,46.53},{73.57,46.53},{72.85,46.81},{72.47,48.95},{72.47,49.72},{73.34,50.7},{73.34,50.7},{73.34,50.7},{72.57,49.9},{71.26,49.69},{68.81,48.66},{66.63,44.9},{65.69,43.28},{66.57,41.67},{68.1,39.87},{68.76,39.44},{69.25,40.16},{69.25,40.16},{69.8,39.55}}}},1519,{388},{388},12,"A",nil,2},
[1723] = {'Stormwind Citizen',42,42,1,1,0,nil,nil,0,nil,nil,12,"A","Placeholder",0},
[1724] = {'Stormwind Citizen Masculine',42,42,1,1,0,nil,nil,0,nil,nil,12,"A","Placeholder",0},
[1725] = {'Defias Watchman',1068,1158,16,17,1,{[40]={{42.36,79.69},{39.19,79.01},{39.6,77.55},{39.97,77.95},{39.95,78.48},{42.49,80.4},{42.29,79.9}},[1581]={{-1,-1}}},nil,40,nil,nil,17,nil,nil,0},
[1726] = {'Defias Magician',921,990,16,17,1,{[40]={{42.36,79.69},{39.19,79.01},{39.6,77.55},{39.97,77.95},{39.95,78.48},{42.49,80.4},{42.29,79.9}}},nil,40,nil,nil,17,nil,nil,0},
[1727] = {'Defias Worker',356,386,16,17,0,{[40]={{40.53,78.54},{42.22,78.77},{39.84,76.12},{42.11,80.19},{39.22,79.79},{39.43,76.02},{40.8,78.87},{39.79,77.53},{41.64,79.87},{44.01,79.28},{42.91,78.56},{43.17,80.46},{41.26,79.77},{43.21,78.37},{40.26,78.06},{39.09,77.51},{39.31,77.91},{39.7,78.55},{38.58,78.93},{40.67,79.41},{38.92,79.65},{42.37,80.0},{43.08,78.86},{43.56,79.08},{39.6,76.92},{42.8,79.51},{39.47,78.94},{43.27,79.61}}},nil,40,nil,nil,17,nil,nil,0},
[1729] = {'Defias Evoker',990,1062,17,18,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[1730] = {'Goblin Buzzcutter',1068,1068,16,16,1,nil,nil,0,nil,nil,17,nil,nil,0},
[1731] = {'Goblin Craftsman',1251,1347,18,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[1732] = {'Defias Squallshaper',1137,1215,19,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[1733] = {'Zggi',102,102,5,5,0,{[1519]={{26.54,78.67}}},nil,1519,nil,{397},12,"A","Zardeth's Minion",2},
[1735] = {'Deathguard Abraham',1124,1124,22,22,0,{[85]={{53.63,53.02}}},nil,85,nil,nil,71,"H",nil,1},
[1736] = {'Deathguard Randolph',5228,5228,55,55,0,{[85]={{31.92,64.88}}},nil,85,nil,nil,71,"H",nil,0},
[1737] = {'Deathguard Oliver',5228,5228,55,55,0,{[85]={{31.51,66.72}}},{[85]={{{31.93,66.99},{31.82,67.67},{31.7,67.71},{31.63,67.49},{31.69,67.73},{31.83,67.69},{31.92,66.94},{31.47,66.69},{30.74,66.76},{31.77,66.72}}}},85,nil,nil,71,"H",nil,0},
[1738] = {'Deathguard Terrence',1042,1042,21,21,0,{[85]={{63.47,56.55}}},{[85]={{{63.47,56.55},{63.57,56.87},{63.66,57.27},{63.7,57.49},{63.72,57.75},{63.73,58.1},{63.73,58.33},{63.72,58.63},{63.68,58.88},{63.58,59.28},{63.68,58.86},{63.72,58.64},{63.74,58.14},{63.71,57.56},{63.66,57.25},{63.57,56.86},{63.49,56.58},{63.36,56.21},{63.26,55.95},{63.15,55.72},{62.98,55.63},{62.75,55.63},{62.59,55.62},{62.38,55.59},{62.25,55.46},{62.03,55.08},{61.86,54.69},{61.75,54.38},{61.65,54.03},{61.58,53.83},{61.52,53.5},{61.49,53.62},{61.58,53.84},{61.66,54.11},{61.72,54.32},{61.88,54.72},{62.07,55.15},{62.21,55.41},{62.34,55.55},{62.5,55.6},{62.76,55.63},{62.9,55.63},{63.05,55.66},{63.22,55.84},{63.35,56.16}}}},85,nil,nil,71,"H",nil,1},
[1739] = {'Deathguard Phillip',5228,5228,55,55,0,{[85]={{32.34,66.07}}},{[85]={{{32.56,66.06},{32.57,65.95},{32.15,65.87},{31.97,65.55},{31.98,65.0},{31.92,65.17},{31.88,66.61},{32.09,67.07},{32.1,67.03},{32.34,67.05},{32.42,66.95},{32.5,66.7},{32.22,66.64},{32.06,66.44},{32.08,66.11},{32.35,66.07}}}},85,nil,nil,71,"H",nil,0},
[1740] = {'Deathguard Saltain',274,274,7,7,0,{[85]={{31.61,65.6}}},nil,85,{3902},{3902},83,"H",nil,2},
[1741] = {'Deathguard Bartrand',5228,5228,55,55,0,{[85]={{32.11,65.11}}},nil,85,nil,nil,71,"H",nil,0},
[1742] = {'Deathguard Bartholomew',968,968,20,20,0,{[85]={{58.47,51.39}}},{[85]={{{58.47,51.39},{58.47,51.39},{58.36,51.19},{58.32,50.52},{58.34,49.81},{58.52,49.61},{58.79,49.33},{58.94,49.27},{59.15,49.29},{59.41,49.34},{59.59,49.37},{59.76,49.41},{59.86,49.43},{59.98,49.26},{60.1,49.07},{60.21,48.85},{60.29,48.62},{60.33,48.46},{60.26,48.1},{60.2,47.84},{60.07,47.48},{59.9,47.28},{59.75,47.18},{59.6,47.05},{59.44,46.94},{59.25,46.79},{59.1,47.07},{59.01,47.22},{58.81,47.45},{58.57,47.67},{58.37,47.83},{58.14,47.97},{57.99,48.05},{57.8,48.2},{57.66,48.47},{57.59,48.76},{57.47,48.84},{57.37,48.96},{57.3,49.14},{57.43,49.32},{57.63,49.32},{57.78,49.53},{57.92,49.68},{58.11,49.75},{58.26,49.81},{58.3,50.03},{58.31,50.44},{58.33,50.89},{58.36,51.19}}}},85,nil,nil,71,"H",nil,1},
[1743] = {'Deathguard Lawrence',1124,1124,22,22,0,{[85]={{58.54,51.42}}},nil,85,nil,nil,71,"H",nil,1},
[1744] = {'Deathguard Mort',1302,1302,24,24,0,{[85]={{61.43,53.05}}},{[85]={{{61.43,53.05},{61.49,53.24},{61.75,53.3},{61.96,53.3},{62.33,53.17},{62.48,53.03},{62.57,52.6},{62.57,52.1},{62.45,51.51},{62.28,50.97},{62.1,50.46},{61.93,49.94},{61.79,49.51},{61.7,49.01},{61.62,48.55},{61.55,47.9},{61.34,47.34},{61.07,46.73},{60.85,46.28},{60.72,45.98},{60.93,46.46},{61.21,47.04},{61.38,47.43},{61.52,47.98},{61.64,48.7},{61.73,49.22},{61.88,49.76},{62.16,50.59},{62.37,51.21},{62.52,51.83},{62.56,52.43},{62.51,52.94},{62.32,53.19},{62.02,53.32},{61.77,53.35},{61.45,53.25}}}},85,nil,nil,71,"H",nil,1},
[1745] = {'Deathguard Morris',1124,1124,22,22,0,{[85]={{60.21,52.38}}},nil,85,nil,nil,71,"H",nil,268435459},
[1746] = {'Deathguard Cyrus',1042,1042,21,21,0,{[85]={{60.7,51.93}}},nil,85,nil,nil,71,"H",nil,1},
[1747] = {'Anduin Wrynn',102,102,5,5,0,{[1519]={{78.11,17.95}}},nil,1519,nil,nil,12,"A","King of Stormwind",2},
[1748] = {'Highlord Bolvar Fordragon',799500,799500,63,63,3,{[1519]={{78.23,17.98}}},nil,1519,{4185,4186,6182,6187,6501,7496,7782},{4184,4185,6186,6187,6403,7495,7781},12,"A",nil,2},
[1749] = {'Lady Katrana Prestor',4369,4369,62,62,0,{[1519]={{78.1,17.75}}},nil,1519,nil,{396},12,"A",nil,3},
[1750] = {'Grand Admiral Jes-Tereth',4369,4369,62,62,0,{[1519]={{81.78,12.94}}},nil,1519,nil,nil,12,"A",nil,0},
[1751] = {'Mithras Ironhill',4369,4369,62,62,0,{[1519]={{82.15,13.64}}},nil,1519,nil,nil,12,"A",nil,0},
[1752] = {'Caledra Dawnbreeze',4120,4120,60,60,0,{[1519]={{75.42,28.42}}},nil,1519,nil,nil,1576,"A",nil,0},
[1753] = {'Maggot Eye',222,222,11,11,0,{[85]={{58.66,30.77}}},nil,85,nil,nil,70,nil,nil,0},
[1754] = {'Lord Gregor Lescovar',1106,1106,31,31,0,{[1519]={{73.36,6.04}}},{[1519]={{{73.1,6.42},{72.71,6.48},{71.86,7.53},{72.26,8.82},{69.57,12.08},{69.09,12.67},{68.26,13.61},{69.56,12.06},{72.19,8.85},{71.92,7.42},{72.81,6.38},{73.37,6.15}}}},1519,nil,nil,12,"A",nil,0},
[1755] = {'Marzon the Silent Blade',1002,1002,30,30,0,nil,nil,0,nil,nil,12,"A",nil,0},
[1756] = {'Stormwind Royal Guard',6104,6104,60,60,0,{[1519]={{68.76,28.39},{73.72,28.33},{70.07,28.16},{74.09,27.89},{69.66,27.38},{75.86,21.32},{75.4,20.47},{78.47,19.76},{77.51,19.58},{79.23,18.86},{76.92,18.45},{79.34,17.4},{77.03,17.03},{78.73,16.27},{77.73,15.86},{80.68,15.52},{80.24,14.74},{69.3,12.86},{69.03,12.27},{72.39,9.42},{71.9,8.58},{69.87,27.77},{73.99,28.26},{77.77,16.13},{69.24,29.27}}},nil,1519,nil,nil,11,"A",nil,0},
[1757] = {'Mega Rabbit',8,8,1,1,0,nil,nil,0,nil,nil,31,"AH",nil,0},
[1758] = {'Warlock (TEST)',810,810,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1759] = {'Mage (TEST)',810,810,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1760] = {'Warrior (TEST)',968,968,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1761] = {'Priest (TEST)',866,866,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1762] = {'Rogue (TEST)',968,968,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1763] = {'Gilnid',2904,2904,20,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,"The Smelter",0},
[1764] = {'Greater Feral Spirit',44,44,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1765] = {'Worg',198,222,10,11,0,{[130]={{64.8,5.89},{44.22,47.87},{45.76,50.18},{65.01,11.2},{68.93,5.49},{65.97,10.37},{43.19,52.38},{68.31,6.3},{69.09,7.8},{63.7,7.43},{63.83,11.1},{65.69,5.53},{66.37,8.98},{67.58,8.4},{64.41,7.96},{66.57,6.32},{57.96,8.3},{47.91,48.1},{64.85,7.28},{66.06,8.77},{70.2,7.1},{46.45,45.86},{69.31,7.42},{65.76,5.35},{68.81,4.9},{64.8,5.48},{68.26,6.61},{69.84,6.88}},[85]={{55.83,76.39},{53.19,74.74},{55.78,76.08}}},nil,130,nil,nil,38,nil,nil,0},
[1766] = {'Mottled Worg',222,247,11,12,0,{[130]={{59.24,13.59},{46.71,23.35},{47.55,25.71},{46.4,25.62},{49.37,15.38},{44.54,25.39},{61.01,9.04},{61.25,11.94},{48.95,20.05},{50.54,17.89},{50.05,13.6},{52.27,17.46},{55.52,17.32},{58.91,10.53},{57.41,15.81},{57.92,14.09},{59.75,10.38},{63.13,10.94},{62.13,8.51},{57.86,9.86},{44.52,26.8},{57.09,10.79},{49.16,22.46},{47.67,24.73},{47.49,21.82},{59.53,8.94},{61.79,8.8},{56.41,7.99},{58.47,6.8},{57.03,10.09},{57.68,8.77},{56.43,16.21},{54.49,12.79},{50.86,19.5},{50.85,21.78},{59.53,16.04},{56.16,10.23},{56.18,12.48},{54.88,13.61},{55.32,12.65}}},nil,130,nil,nil,38,nil,nil,0},
[1767] = {'Vile Fin Shredder',247,273,12,13,0,{[130]={{58.94,18.02},{63.56,12.85},{61.11,14.49},{62.99,12.57},{63.84,12.58},{64.16,12.92},{57.73,21.2},{57.85,24.64},{62.21,12.57},{63.76,12.1},{65.13,13.4},{66.57,12.99},{61.29,15.94},{56.48,25.95},{62.34,13.89},{57.36,21.2},{57.59,22.47},{56.92,19.32},{58.46,18.35},{64.24,11.21},{66.59,12.51},{67.03,11.72},{65.58,12.92},{55.67,28.18},{60.07,14.88},{65.82,12.54},{57.43,25.83},{57.02,23.8},{64.63,12.42},{65.1,11.77},{61.65,13.52},{60.75,13.47},{58.57,17.37},{60.15,16.55},{59.91,17.45},{60.46,15.55},{59.36,17.46},{56.09,27.72},{56.1,28.41},{56.76,25.31},{56.08,28.01},{57.13,22.03},{57.74,23.49}}},nil,130,nil,nil,18,nil,nil,0},
[1768] = {'Vile Fin Tidehunter',253,276,13,14,0,{[130]={{60.51,17.51},{59.09,18.11},{59.62,18.61},{59.1,17.78},{67.04,12.58},{62.93,13.01},{61.71,14.22},{57.34,18.99},{57.81,19.98},{66.63,12.66},{66.53,13.17},{57.57,18.41},{58.03,17.9},{66.22,13.18},{66.31,12.67},{66.15,12.97},{65.2,13.03},{60.89,16.4},{60.67,16.73},{59.91,17.67},{59.62,17.82},{55.98,27.17},{56.26,27.66},{56.21,27.5}}},nil,130,nil,nil,18,nil,nil,0},
[1769] = {'Moonrage Whitescalp',186,208,10,11,0,{[130]={{54.53,23.78},{55.67,19.75},{55.56,20.41},{55.8,19.87},{55.06,19.97},{55.46,19.97},{56.69,19.48},{56.25,18.63},{55.8,19.16},{54.93,21.71},{52.68,26.22},{53.63,22.53},{54.76,20.83},{55.41,23.11},{55.88,25.39},{53.0,26.69},{55.55,20.83},{52.2,24.8},{53.45,24.4},{55.87,20.66},{54.52,26.71},{54.11,41.38},{52.28,26.93},{48.52,31.77},{53.86,43.24},{52.04,26.26},{52.41,28.02},{51.92,28.17},{52.8,28.53},{51.36,26.47},{54.23,24.58},{52.86,37.98},{55.26,40.33},{51.49,43.09},{51.78,46.56},{52.2,41.75},{48.13,40.62},{49.78,40.49},{50.21,39.2},{47.79,34.1},{48.87,36.7},{49.14,39.61},{49.33,34.17},{49.44,34.93},{48.45,35.19},{50.74,47.78},{51.79,44.93}}},nil,130,nil,nil,24,nil,nil,0},
[1770] = {'Moonrage Darkrunner',222,247,11,12,0,{[130]={{52.73,26.04},{52.84,24.28},{53.62,24.48},{53.86,27.16},{53.2,25.09},{48.84,24.02},{48.86,24.91},{48.33,24.52},{48.68,23.18},{47.72,25.25},{48.48,24.51},{52.88,28.38},{52.89,27.65},{52.68,27.99}}},nil,130,nil,nil,24,nil,nil,0},
[1772] = {'Rot Hide Gladerunner',222,247,11,12,0,{[130]={{44.2,23.55},{43.93,19.98},{44.73,22.59},{44.42,23.01},{44.93,23.75},{46.17,23.48},{46.47,21.8},{45.66,18.99},{45.67,23.43},{44.71,20.36},{45.43,19.76}}},nil,130,nil,nil,70,nil,nil,0},
[1773] = {'Rot Hide Mystic',230,253,12,13,0,{[130]={{44.37,19.59},{44.09,21.71},{44.12,22.38},{44.3,21.68},{45.7,22.74},{45.09,23.64},{44.99,22.89},{45.57,19.31}}},nil,130,nil,nil,70,nil,nil,0},
[1775] = {'Zun\'dartha',4120,4120,60,60,0,{[8]={{45.02,54.83}}},nil,8,nil,nil,29,"H",nil,2},
[1776] = {'Magtoor',1981,1981,42,42,0,{[8]={{25.98,31.4}}},nil,8,{1389},{1389,1392},35,"AH",nil,2},
[1777] = {'Dakk Blunderblast',328,328,15,15,0,{[38]={{35.43,42.82}}},nil,38,nil,nil,57,"A",nil,2},
[1778] = {'Ferocious Grizzled Bear',266,296,11,12,0,{[130]={{46.33,49.63},{44.6,50.39},{49.05,14.22},{51.03,14.94},{45.04,51.87},{44.09,52.0},{44.9,47.26},{44.24,48.15},{50.41,18.5},{49.37,17.4},{51.33,16.65},{44.5,24.65},{49.97,19.93},{46.01,26.03},{51.91,21.56},{52.16,19.59},{48.79,26.26},{47.95,23.26},{48.31,19.29},{48.2,20.32},{47.46,19.71},{51.28,38.75},{49.71,22.7},{51.22,18.6},{51.02,38.39},{50.58,40.84},{50.78,44.9},{54.54,43.89},{50.22,43.39},{51.07,42.46},{51.29,45.37},{50.12,36.18},{48.75,32.91},{47.32,32.99},{54.27,38.18},{53.52,39.5},{46.91,33.46},{55.18,44.15},{46.97,46.47}}},nil,130,nil,nil,44,nil,nil,0},
[1779] = {'Moonrage Glutton',247,273,12,13,0,{[130]={{42.93,32.67},{40.74,24.41},{41.13,25.54},{41.37,23.07},{39.57,27.8},{38.7,21.97},{37.89,23.22},{38.84,29.36},{39.63,25.84},{39.19,26.96},{49.57,17.02},{46.63,28.36},{43.55,29.08},{42.99,28.93},{42.15,29.4},{41.27,28.39},{39.65,23.41},{41.18,30.21},{40.53,28.97},{40.79,29.68},{49.8,18.76},{50.03,20.33},{51.03,16.9},{44.66,32.0},{44.18,31.61},{43.54,31.69},{43.5,31.32},{48.04,18.01},{50.7,14.54},{46.54,27.46},{45.29,27.26},{44.12,27.95},{55.6,46.64},{55.86,45.92},{56.5,46.45},{56.27,45.48},{56.21,45.88},{55.99,47.23},{51.46,19.76},{58.16,44.65},{56.93,45.91},{58.31,45.28},{48.8,24.59},{48.34,24.26},{56.42,47.69},{52.76,17.48},{55.53,49.31},{54.81,49.3},{54.62,48.3}}},nil,130,nil,nil,24,nil,nil,0},
[1780] = {'Moss Stalker',247,273,12,13,0,{[130]={{34.8,12.72},{34.89,12.64},{35.05,14.52},{34.17,15.22},{37.2,15.91},{35.69,15.03},{36.44,14.95},{36.12,14.09},{35.9,13.71},{35.63,14.14},{35.55,13.08},{35.4,12.48},{34.16,17.33},{35.69,16.06},{35.02,16.16}}},nil,130,nil,nil,22,nil,nil,0},
[1781] = {'Mist Creeper',273,300,13,14,0,{[130]={{35.89,8.62},{35.43,8.86},{35.29,8.32},{34.76,7.85},{34.48,8.34},{35.85,8.16},{36.01,8.96},{34.33,9.18},{34.25,9.72},{34.52,9.94},{35.09,9.86},{34.7,10.22},{35.24,9.63},{35.34,10.38},{35.39,10.82},{35.53,10.52},{35.08,10.31},{35.28,10.05},{35.5,11.61},{35.11,11.47}}},nil,130,nil,nil,22,nil,nil,0},
[1782] = {'Moonrage Darksoul',273,300,13,14,0,{[130]={{58.61,42.27},{60.42,41.23},{60.4,41.4},{43.24,31.99},{58.7,41.09},{59.43,42.4},{43.73,30.84},{38.32,27.13},{40.18,26.93},{38.75,24.59},{36.78,21.9},{38.36,25.49},{37.6,24.51},{43.14,31.11},{43.53,32.14},{43.26,31.68},{39.69,30.3},{45.52,29.17},{57.19,45.71},{58.21,44.96},{57.26,45.71},{57.83,44.67},{57.52,44.97},{58.02,45.08},{56.03,48.59}}},nil,130,nil,nil,24,nil,nil,0},
[1783] = {'Skeletal Flayer',2880,2980,50,51,0,{[28]={{38.29,56.44},{38.12,53.81},{49.27,81.3},{49.61,76.62},{48.12,82.81},{49.4,77.07},{50.79,76.1},{54.54,80.88},{54.63,79.67},{53.93,80.12},{53.99,79.94},{38.11,55.11},{37.83,55.15},{47.37,81.79},{49.47,77.79},{54.66,81.03},{53.98,80.28},{53.95,80.99},{38.82,56.75},{37.07,58.36},{36.85,54.54},{37.61,58.49},{36.58,55.66},{48.06,80.72},{48.93,81.79},{48.15,78.6},{50.77,80.55},{50.43,75.35},{38.6,57.11},{39.05,55.9},{37.28,59.38},{36.79,56.77},{47.37,84.3},{47.3,80.5},{38.99,54.47},{36.05,58.49},{37.4,55.12},{37.56,56.55},{38.35,54.13},{38.88,54.93},{37.65,58.05},{36.64,57.74},{36.52,54.8},{35.95,55.87},{35.63,57.01}}},nil,28,nil,nil,21,nil,nil,0},
[1784] = {'Skeletal Sorcerer',2384,2466,51,52,0,{[28]={{35.74,56.2},{35.57,56.52},{39.28,54.91},{38.54,53.96},{37.52,54.08},{54.23,79.87},{54.14,79.4},{53.97,80.34},{36.91,57.14},{37.38,57.25},{36.22,57.38},{54.7,80.17},{53.92,79.92},{54.72,79.92},{53.95,79.97},{37.15,54.48},{54.78,79.75},{54.78,79.93},{53.91,80.92},{54.8,80.87},{54.63,79.92},{38.76,55.96},{37.36,56.33},{37.99,54.17},{37.57,59.56},{38.68,55.03},{38.52,57.47},{37.75,54.56},{36.59,54.31}}},nil,28,nil,nil,21,nil,nil,0},
[1785] = {'Skeletal Terror',3082,3292,52,54,0,{[28]={{45.04,52.0},{48.1,51.2},{47.74,49.94},{47.26,50.1},{45.82,51.67},{45.89,50.53},{47.54,51.36},{47.11,50.51},{47.91,50.59},{46.56,51.53},{47.37,49.82},{46.11,49.47},{45.17,51.17},{47.67,51.06},{47.25,49.42}}},nil,28,nil,nil,21,nil,nil,0},
[1787] = {'Skeletal Executioner',3188,3398,53,55,0,{[28]={{45.75,67.23},{39.38,72.27},{44.48,68.65},{44.6,68.54},{44.52,68.87},{45.86,69.43},{45.88,69.13},{44.7,69.88},{44.54,69.82},{45.67,75.03},{50.4,67.93},{46.63,69.32},{48.8,69.07},{40.22,65.64},{46.65,70.95},{49.65,66.82},{48.76,70.24},{41.5,72.87},{38.72,68.27},{42.68,69.99},{43.95,62.37},{45.8,62.63},{48.64,69.65},{44.1,64.59},{43.17,63.59},{41.84,61.99},{45.74,72.48},{44.5,71.18},{47.26,69.12},{41.82,68.36},{39.69,67.57},{48.08,63.19},{48.01,69.26},{42.64,74.93},{41.12,69.22},{44.99,66.93},{38.85,71.15},{44.44,64.98},{48.05,71.25},{38.69,70.07}}},nil,28,nil,nil,21,nil,nil,0},
[1788] = {'Skeletal Warlord',8097,8352,56,57,1,{[28]={{45.12,68.75},{45.15,69.56},{43.83,63.07},{42.67,65.75},{46.68,71.66},{40.44,71.85}}},nil,28,nil,nil,21,nil,nil,0},
[1789] = {'Skeletal Acolyte',2823,2915,55,56,0,{[28]={{49.54,63.52},{39.87,67.93},{47.12,71.68},{45.94,69.28},{44.51,69.62},{42.61,71.34},{46.74,74.23},{43.46,64.5},{39.89,71.4},{48.99,64.84},{42.17,66.47},{48.76,63.44},{48.2,65.44},{43.4,74.87},{41.89,68.2},{41.74,73.18},{41.8,74.9},{47.16,61.19},{40.22,69.12},{46.21,71.8},{41.83,69.35},{47.24,72.48},{41.11,74.9},{44.65,72.59},{44.33,67.1},{43.77,63.74},{42.68,67.08},{41.82,64.57},{42.85,65.16},{47.37,63.47},{42.67,62.72},{49.51,68.09},{41.49,65.86},{45.91,70.31},{39.56,67.92},{49.54,65.78},{39.5,70.43},{46.82,66.39},{45.07,65.54},{44.34,65.73},{47.46,62.44},{42.6,69.21},{45.79,73.39},{45.68,61.02},{45.55,61.81},{44.27,74.91},{46.58,64.56},{48.05,66.78}}},nil,28,nil,nil,21,nil,nil,0},
[1791] = {'Slavering Ghoul',2880,3082,50,52,0,{[28]={{38.86,55.24},{37.08,56.19},{36.75,54.9},{50.35,80.48},{49.91,76.25},{50.28,76.87},{49.61,82.77},{50.06,77.68},{54.8,81.03},{53.79,80.45},{54.68,80.96},{38.92,57.32},{37.59,56.92},{38.47,55.65},{39.11,55.45},{38.49,54.61},{51.22,76.39},{49.54,76.04},{48.7,80.4},{50.27,74.97},{49.98,80.05},{48.44,80.05},{51.07,76.69},{49.79,77.61},{54.03,80.88},{54.09,80.17},{53.9,80.12},{38.16,54.56},{37.08,57.55},{37.13,54.1},{37.78,53.96},{48.8,79.49},{49.9,77.09},{50.36,80.05},{49.93,76.67},{50.92,75.65},{53.99,80.64},{37.61,59.15},{35.99,56.46},{48.87,80.16},{49.9,80.59},{49.89,78.04},{50.13,81.15},{36.95,53.97},{38.15,54.56}}},nil,28,nil,nil,21,nil,nil,0},
[1793] = {'Rotting Ghoul',3293,3398,54,55,0,{[28]={{54.61,66.07},{53.76,65.31},{53.96,65.81},{52.7,64.29},{53.15,64.63},{52.34,64.69},{54.12,67.05},{53.82,67.9},{51.94,65.44},{53.34,66.16},{51.98,66.73},{53.63,67.53},{52.75,67.9},{53.31,63.55},{54.28,64.8}}},nil,28,nil,nil,21,nil,nil,0},
[1794] = {'Soulless Ghoul',2634,2718,54,55,0,{[28]={{39.46,69.38},{37.97,68.0},{44.6,68.73},{45.07,68.19},{42.58,72.81},{40.81,72.38},{45.1,69.93},{44.92,74.96},{42.64,73.92},{41.87,71.3},{48.74,65.63},{43.28,61.14},{45.79,63.52},{37.92,70.55},{48.03,70.29},{48.05,68.05},{42.95,66.15},{46.58,63.44},{44.84,73.83},{40.39,70.26},{45.82,65.77},{38.69,69.38},{48.64,62.54},{39.56,66.81},{42.12,72.4},{50.26,65.82},{48.3,62.03},{42.58,67.91},{46.52,65.75},{44.51,63.45},{44.12,73.69},{44.12,68.28},{40.27,73.96},{40.12,72.49},{40.24,67.02},{43.49,73.95},{45.0,64.6},{49.61,69.07},{41.07,67.59}}},nil,28,nil,nil,21,nil,nil,0},
[1795] = {'Searing Ghoul',2823,2915,55,56,0,{[28]={{42.73,68.57},{46.37,74.81},{50.49,66.74},{45.39,68.82},{44.64,69.68},{38.71,66.88},{42.07,69.03},{46.22,73.28},{49.47,64.75},{47.89,64.52},{45.83,69.28},{41.01,70.57},{40.78,71.54},{46.49,62.1},{42.52,70.56},{46.74,72.33},{40.94,66.39},{46.05,68.25},{48.96,68.1},{42.93,72.07},{40.68,66.43},{43.37,72.48},{45.09,67.84},{44.89,62.02},{41.84,70.35},{47.38,67.95},{41.81,74.06},{48.82,65.15},{42.19,65.44},{41.47,69.86},{44.85,70.95},{47.27,64.5},{44.02,72.37},{45.78,61.87},{41.03,73.74},{40.6,68.35},{45.63,71.65},{43.4,62.98},{43.44,71.69},{47.44,70.42}}},nil,28,nil,nil,21,nil,nil,0},
[1796] = {'Freezing Ghoul',3529,3644,55,56,0,{[28]={{53.05,67.24},{52.63,66.89},{53.98,62.97},{53.34,67.98},{55.32,66.49},{53.23,65.18},{54.65,65.59},{53.41,67.05},{52.73,65.94},{52.95,63.73},{52.15,63.99}}},nil,28,nil,nil,21,nil,nil,0},
[1797] = {'Giant Grizzled Bear',296,328,12,13,0,{[130]={{36.68,21.51},{35.18,19.55},{39.02,13.54},{43.59,18.79},{35.44,17.23},{37.09,17.67},{44.39,17.03},{45.28,16.14},{39.71,14.91},{39.11,15.94},{37.36,17.23},{37.68,16.62},{37.91,15.55},{39.85,16.48},{47.02,18.07},{34.46,15.27},{45.97,18.26},{42.51,19.49},{41.6,17.99},{42.48,18.14},{42.09,21.73},{41.16,18.24},{50.93,67.88},{55.61,51.68},{56.1,67.09},{54.68,69.48},{55.37,65.03},{55.54,70.98},{52.47,61.27},{52.92,51.77},{54.24,56.22},{51.54,53.92},{53.16,53.98},{51.6,59.05},{52.88,67.06},{51.34,55.28},{51.77,58.12},{51.47,52.82},{49.38,70.31},{51.57,62.48},{50.53,67.2},{51.62,66.73},{50.18,69.37},{53.44,64.98},{53.1,60.59}}},nil,130,nil,nil,44,nil,nil,0},
[1798] = {'Tortured Soul',2823,2915,55,56,0,nil,nil,0,nil,nil,21,nil,nil,0},
[1800] = {'Cold Wraith',2986,2986,58,58,0,nil,nil,0,nil,nil,21,nil,nil,0},
[1801] = {'Blood Wraith',3528,3528,55,55,0,nil,nil,0,nil,nil,67,nil,nil,0},
[1802] = {'Hungering Wraith',3644,3876,56,58,0,{[28]={{62.49,60.25},{63.55,55.87},{60.68,58.28},{64.87,59.33},{64.37,59.18},{64.04,57.58},{62.69,58.03},{63.45,57.75},{65.14,59.07},{64.36,57.47},{64.4,58.61},{63.88,55.71},{62.2,60.19},{64.71,59.04},{64.67,57.69},{62.38,58.9},{62.24,59.61},{62.76,57.03},{61.84,59.12},{64.71,59.19},{64.22,55.88}}},nil,28,nil,nil,21,nil,nil,0},
[1804] = {'Wailing Death',3643,3758,56,57,0,{[28]={{64.03,56.22},{62.42,60.86},{64.31,57.91},{64.84,59.98},{63.42,56.62},{62.47,57.9},{63.0,60.59},{63.1,59.69},{61.76,57.72},{63.31,60.82},{65.1,59.65},{61.68,58.24},{62.77,60.12},{64.37,56.68},{64.58,57.34},{64.77,58.55},{60.75,57.88},{63.26,56.01},{64.6,59.39},{62.97,55.83},{64.66,59.26}}},nil,28,nil,nil,21,nil,nil,0},
[1805] = {'Flesh Golem',8097,8352,56,57,1,{[28]={{47.58,69.3},{41.78,68.47}}},{[28]={{{47.61,69.2},{47.6,68.99},{47.6,68.7},{47.7,68.52},{47.83,68.35},{48.03,68.31},{48.24,68.33},{48.36,68.55},{48.29,68.37},{48.35,68.18},{48.49,68.0},{48.39,68.13},{48.24,68.33},{48.05,68.26},{47.87,68.28},{47.75,68.41},{47.63,68.6},{47.59,68.8},{47.59,69.04},{47.57,69.3},{47.5,69.46},{47.37,69.53},{47.21,69.63},{47.02,69.77},{47.08,69.97},{47.18,70.14},{47.31,70.31},{47.47,70.53},{47.61,70.8},{47.71,70.97},{47.86,71.07},{48.01,71.24},{48.11,71.37},{48.34,71.69},{48.17,71.41},{47.94,71.14},{47.76,71.05},{47.62,70.82},{47.51,70.56},{47.3,70.29},{47.03,70.05},{46.91,69.64},{46.73,69.53},{46.47,69.68},{46.48,70.3},{46.49,69.61},{46.3,69.21},{46.48,69.05},{46.68,68.83},{46.74,68.48},{46.74,68.11},{46.68,67.73},{46.6,67.43},{46.43,67.15},{46.24,66.87},{46.09,66.65},{45.96,66.27},{46.12,66.09},{45.96,66.23},{45.98,66.48},{46.09,66.66},{46.24,66.89},{46.41,67.17},{46.61,67.49},{46.68,67.72},{46.71,68.05},{46.73,68.38},{46.71,68.69},{46.55,68.93},{46.36,69.23},{46.48,69.54},{46.67,69.52},{46.86,69.57},{47.13,69.61},{47.35,69.61},{47.51,69.5}},{{41.74,68.47},{41.87,68.31},{42.01,68.14},{42.06,68.07},{42.01,67.81},{41.95,67.58},{41.89,67.41},{41.8,67.2},{41.66,66.98},{41.82,67.08},{41.87,67.24},{41.93,67.49},{42.0,67.79},{42.09,68.11},{42.3,68.06},{42.52,67.9},{42.73,67.76},{42.97,67.63},{43.17,67.64},{43.37,67.66},{43.53,67.52},{43.68,67.24},{43.71,66.91},{43.72,66.57},{43.73,66.25},{43.73,65.88},{43.72,65.62},{43.66,65.23},{43.59,64.93},{43.47,64.57},{43.28,64.02},{43.41,64.27},{43.5,64.62},{43.59,65.03},{43.66,65.47},{43.67,65.96},{43.68,66.51},{43.68,66.98},{43.73,67.29},{43.5,67.44},{43.36,67.66},{43.16,67.62},{42.9,67.64},{42.69,67.73},{42.41,67.97},{42.06,68.21}}}},28,nil,nil,21,nil,nil,0},
[1806] = {'Vile Slime',3293,3398,54,55,0,{[28]={{63.19,37.53},{66.06,42.18},{65.36,39.59},{65.93,40.3},{64.9,38.73},{65.03,41.25},{63.54,36.34},{66.64,41.04},{63.82,37.82},{63.55,37.18},{65.78,38.01},{64.31,38.36}}},nil,28,nil,nil,14,nil,nil,0},
[1808] = {'Devouring Ooze',3529,3644,55,56,0,{[28]={{63.85,35.87},{61.95,34.93},{63.39,35.78},{62.46,35.92},{64.46,33.4},{64.6,34.18},{61.31,34.95},{63.89,36.04},{61.47,36.72},{61.8,37.42}}},nil,28,nil,nil,14,nil,nil,0},
[1809] = {'Carrion Vulture',2880,3082,50,52,0,{[28]={{29.89,54.68},{32.26,62.39}}},nil,28,nil,nil,73,nil,nil,0},
[1810] = {'Rotting Condor',3189,3398,53,55,0,nil,nil,0,nil,nil,73,nil,nil,0},
[1811] = {'Plaguewing Vulture',3644,3876,56,58,0,nil,nil,0,nil,nil,73,nil,nil,0},
[1812] = {'Rotting Behemoth',3529,3644,55,56,0,{[28]={{64.03,34.38},{61.77,35.52},{64.49,36.66},{66.56,39.09},{63.59,32.55},{61.45,36.88},{61.2,35.64},{61.99,33.21},{63.81,33.18},{62.11,37.56},{62.34,32.35},{62.51,34.97},{62.4,35.45},{61.2,36.24},{62.48,37.52}}},nil,28,nil,nil,14,nil,nil,0},
[1813] = {'Decaying Horror',3643,3758,56,57,0,{[28]={{61.98,33.84},{61.63,36.21}}},nil,28,nil,nil,14,nil,nil,0},
[1815] = {'Diseased Black Bear',3438,3556,51,52,0,{[28]={{37.24,62.33},{37.92,65.52},{36.46,63.59},{32.67,55.22},{34.22,62.1},{36.35,65.62},{37.07,66.92},{31.86,61.68},{31.81,56.64},{33.91,52.76},{37.92,63.22},{29.33,61.59},{36.33,67.98},{33.43,56.21},{34.78,54.2},{31.28,60.13},{30.18,54.44},{28.68,58.91},{31.66,54.08},{33.43,65.75},{38.97,62.34},{33.43,63.6},{31.04,55.18},{34.87,63.52},{34.82,58.78},{39.37,62.69},{32.64,57.55}}},nil,28,nil,nil,44,nil,nil,0},
[1816] = {'Diseased Grizzly',3921,4048,55,56,0,{[28]={{67.2,48.19},{63.3,46.42},{54.98,50.7},{67.55,46.1},{66.25,47.78},{55.8,63.56},{60.85,51.04},{65.72,53.62},{53.37,50.55},{55.65,54.0},{68.11,48.47},{59.11,59.56},{52.68,51.68},{54.93,62.23},{62.21,48.48},{55.8,58.59},{57.85,52.95},{52.86,49.52},{58.05,60.12},{60.47,51.95},{56.73,62.08},{58.88,53.91},{58.82,50.54},{63.55,45.17},{60.44,54.11},{54.96,45.82},{65.5,55.13},{66.57,56.44},{63.73,49.75},{57.14,51.0},{66.68,47.79},{54.39,51.88},{61.88,47.03},{52.24,54.3},{56.56,59.99},{55.99,53.44},{62.71,50.32},{65.12,46.43},{57.12,53.45},{66.74,53.38},{64.45,47.71},{59.01,51.61},{61.89,51.83},{60.79,53.54},{55.81,49.58},{62.86,49.89},{67.44,55.32},{65.02,53.03},{66.8,49.94},{57.71,58.44},{54.27,47.12},{54.33,49.41},{56.04,51.39},{58.16,62.14},{64.39,47.01},{56.59,50.71},{55.93,60.97},{64.38,49.72},{65.97,57.43},{53.4,60.05},{52.53,58.41},{54.16,61.15},{53.36,62.03},{56.63,57.52},{58.99,61.01},{66.41,54.55},{60.53,49.43},{55.37,53.0},{55.16,64.54},{66.11,45.81},{65.3,50.29},{65.87,44.02},{68.05,45.53},{53.41,48.3},{60.17,50.52}}},nil,28,nil,nil,44,nil,nil,0},
[1817] = {'Diseased Wolf',3189,3293,53,54,0,{[28]={{52.53,70.45},{44.95,40.28},{46.41,59.88},{51.14,53.08},{48.95,36.7},{43.46,55.16},{48.03,47.27},{45.79,46.0},{51.09,64.35},{47.42,43.73},{51.84,46.96},{44.97,32.12},{44.95,59.83},{51.51,60.52},{42.59,56.29},{46.47,42.65},{45.68,43.87},{44.39,45.87},{45.88,36.71},{47.23,46.01},{48.58,60.24},{43.14,46.77},{44.91,42.5},{48.78,39.0},{44.78,47.03},{44.95,37.63},{49.38,59.55},{47.36,39.04},{49.81,35.61},{51.23,50.64},{51.02,32.93},{46.62,37.81},{48.57,58.47},{41.13,48.4},{45.7,48.29},{47.28,28.28},{44.82,44.78},{42.53,54.11},{48.92,28.33},{43.5,40.18},{46.57,47.1},{49.65,37.78},{47.35,41.27},{48.12,27.24},{47.25,48.33},{46.58,29.67},{50.33,46.94},{49.64,27.25},{48.76,26.11},{48.05,40.12},{50.31,63.45},{48.89,61.92},{50.38,36.44},{52.03,34.21},{50.34,34.49},{46.6,40.22},{44.88,49.51},{51.18,30.95},{46.52,44.91},{39.64,48.46},{51.95,61.01},{44.14,56.51},{45.74,41.42}}},nil,28,nil,nil,38,nil,nil,0},
[1819] = {'Foulmaw Hydra',3082,3293,52,54,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1820] = {'Elder Foulmaw Hydra',3529,3758,55,57,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1821] = {'Carrion Lurker',3082,3189,52,53,0,{[28]={{52.53,70.45},{44.95,40.28},{46.41,59.88},{51.14,53.08},{48.95,36.7},{43.46,55.16},{48.03,47.27},{45.79,46.0},{51.09,64.35},{47.42,43.73},{51.84,46.96},{44.97,32.12},{44.95,59.83},{51.51,60.52},{42.59,56.29},{46.47,42.65},{45.68,43.87},{44.39,45.87},{45.88,36.71},{47.23,46.01},{48.58,60.24},{43.14,46.77},{44.91,42.5},{48.78,39.0},{44.78,47.03},{44.95,37.63},{49.38,59.55},{47.36,39.04},{49.81,35.61},{51.23,50.64},{51.02,32.93},{46.62,37.81},{48.57,58.47},{41.13,48.4},{45.7,48.29},{47.28,28.28},{44.82,44.78},{42.53,54.11},{48.92,28.33},{43.5,40.18},{46.57,47.1},{49.65,37.78},{47.35,41.27},{48.12,27.24},{47.25,48.33},{46.58,29.67},{50.33,46.94},{49.64,27.25},{48.76,26.11},{48.05,40.12},{50.31,63.45},{48.89,61.92},{50.38,36.44},{52.03,34.21},{50.34,34.49},{46.6,40.22},{44.88,49.51},{51.18,30.95},{46.52,44.91},{39.64,48.46},{51.95,61.01},{44.14,56.51},{45.74,41.42}}},nil,28,nil,nil,22,nil,nil,0},
[1822] = {'Venom Mist Lurker',2880,2980,50,51,0,{[28]={{33.42,61.43},{35.77,62.25},{33.19,54.07},{37.93,61.3},{35.55,66.85},{29.99,60.96},{28.94,56.0},{37.14,64.7},{32.43,62.26},{34.24,64.47},{39.88,62.07},{34.24,66.77},{38.64,64.49},{35.56,64.65},{33.43,59.0},{32.57,64.64},{32.14,63.51},{29.13,59.24},{31.14,62.42},{34.28,57.56},{29.78,56.68},{34.05,55.36}}},nil,28,nil,nil,22,nil,nil,0},
[1824] = {'Plague Lurker',3293,3398,54,55,0,{[28]={{67.2,48.19},{63.3,46.42},{54.98,50.7},{67.55,46.1},{66.25,47.78},{55.8,63.56},{60.85,51.04},{65.72,53.62},{53.37,50.55},{55.65,54.0},{68.11,48.47},{59.11,59.56},{52.68,51.68},{54.93,62.23},{62.21,48.48},{55.8,58.59},{57.85,52.95},{52.86,49.52},{58.05,60.12},{60.47,51.95},{56.73,62.08},{58.88,53.91},{58.82,50.54},{63.55,45.17},{60.44,54.11},{54.96,45.82},{65.5,55.13},{66.57,56.44},{63.73,49.75},{57.14,51.0},{66.68,47.79},{54.39,51.88},{61.88,47.03},{52.24,54.3},{56.56,59.99},{55.99,53.44},{62.71,50.32},{65.12,46.43},{57.12,53.45},{66.74,53.38},{64.45,47.71},{59.01,51.61},{61.89,51.83},{60.79,53.54},{55.81,49.58},{62.86,49.89},{67.44,55.32},{65.02,53.03},{66.8,49.94},{57.71,58.44},{54.27,47.12},{54.33,49.41},{56.04,51.39},{58.16,62.14},{64.39,47.01},{56.59,50.71},{55.93,60.97},{64.38,49.72},{65.97,57.43},{53.4,60.05},{52.53,58.41},{54.16,61.15},{53.36,62.03},{56.63,57.52},{58.99,61.01},{66.41,54.55},{60.53,49.43},{55.37,53.0},{55.16,64.54},{66.11,45.81},{65.3,50.29},{65.87,44.02},{68.05,45.53},{53.41,48.3},{60.17,50.52}}},nil,28,nil,nil,312,nil,nil,0},
[1826] = {'Scarlet Mage',2470,2550,55,56,0,{[28]={{57.57,35.65},{51.3,40.48},{52.83,36.65},{51.03,40.21},{52.77,37.56},{53.6,37.67},{57.41,36.09}}},nil,28,nil,nil,67,nil,nil,0},
[1827] = {'Scarlet Sentinel',7842,8097,55,56,1,{[28]={{46.91,20.42},{42.15,13.8},{43.54,19.86},{43.17,16.28},{47.16,15.92},{42.03,13.7},{42.19,15.91},{48.94,21.38},{42.11,15.85},{48.23,20.46},{48.37,21.58},{41.57,15.54},{43.12,16.5},{42.72,14.34},{47.35,21.89},{48.09,22.03},{48.01,22.75},{47.68,14.9},{44.99,16.4},{41.89,14.92},{41.98,14.87},{47.11,20.07},{41.43,15.43},{42.65,14.29}}},nil,28,nil,nil,67,nil,nil,0},
[1831] = {'Scarlet Hunter',3082,3188,52,53,0,{[28]={{41.01,52.43},{40.73,52.62},{38.64,55.97},{47.33,51.38},{40.69,52.18},{51.45,44.14},{51.7,44.03},{51.63,44.53},{52.24,44.6},{52.2,43.96},{43.67,67.8}}},nil,28,nil,nil,89,nil,nil,0},
[1832] = {'Scarlet Magus',5667,5847,56,57,1,{[28]={{44.99,15.71},{45.21,15.4},{46.34,13.78},{46.62,14.08},{46.82,13.1},{45.02,15.55},{45.16,15.31},{47.31,13.81},{44.84,15.25}}},nil,28,nil,nil,67,nil,nil,0},
[1833] = {'Scarlet Knight',3293,3398,54,55,0,{[28]={{50.43,41.06},{53.26,37.43},{49.61,33.19},{45.77,34.44},{48.77,34.46},{50.33,40.45},{50.72,41.26},{49.83,41.61},{53.18,36.97},{50.76,40.47},{57.7,36.41},{50.23,42.22},{47.05,34.4},{47.35,31.89},{53.19,36.28}}},nil,28,nil,nil,67,nil,nil,0},
[1834] = {'Scarlet Paladin',6273,6477,55,56,1,{[28]={{42.5,16.06},{42.7,18.21},{46.07,19.09},{43.26,20.69},{43.01,18.36},{46.16,18.2},{46.93,13.59},{43.16,19.63},{47.0,13.89},{43.01,16.36},{42.75,13.42},{43.47,13.24},{46.55,13.68},{45.38,17.94},{45.23,18.27},{42.61,17.65},{44.86,16.16},{43.56,13.75},{46.64,13.74},{42.84,16.1},{42.69,18.57},{42.77,16.34},{45.37,18.97},{46.57,13.47},{42.99,16.14},{42.53,18.2},{42.43,19.14},{47.09,13.53},{41.56,15.35},{42.06,13.94},{43.49,13.56},{44.89,16.37},{43.37,13.44},{42.92,14.56},{43.49,13.89},{46.81,14.06},{42.6,19.02}}},nil,28,nil,nil,67,nil,nil,0},
[1835] = {'Scarlet Invoker',2551,2634,53,54,0,{[28]={{40.42,52.57},{38.65,55.99},{47.36,51.33},{40.34,51.74},{51.89,43.79},{52.17,44.2},{43.67,67.8},{40.87,51.47}}},nil,28,nil,nil,89,nil,nil,0},
[1836] = {'Scarlet Cavalier',8097,8613,56,58,1,{[28]={{41.67,15.43},{41.88,14.96},{42.01,14.47},{41.91,15.41},{42.15,15.01},{42.22,14.83}}},nil,28,nil,nil,67,nil,nil,0},
[1837] = {'Scarlet Judge',7326,7326,60,60,4,{[28]={{42.21,18.5}}},nil,28,nil,nil,16,nil,nil,0},
[1838] = {'Scarlet Interrogator',9432,9432,61,61,2,{[28]={{45.15,15.27}}},nil,28,nil,nil,16,nil,nil,0},
[1839] = {'Scarlet High Clerist',7995,7995,63,63,2,{[28]={{56.94,34.81},{44.5,19.3},{42.34,18.9}}},{[28]={{{44.83,19.78},{44.39,19.14},{43.91,18.55},{43.28,17.63},{43.68,18.2},{44.07,18.75},{44.48,19.28},{44.83,19.74},{44.72,20.02},{44.41,20.04},{44.03,19.91},{44.29,20.0},{44.75,20.04}}}},28,nil,nil,16,nil,nil,0},
[1840] = {'Grand Inquisitor Isillien',66625,66625,63,63,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1841] = {'Scarlet Executioner',9156,9156,60,60,2,{[28]={{45.71,18.78}}},nil,28,nil,nil,67,nil,nil,0},
[1842] = {'Highlord Taelan Fordring',26650,26650,63,63,1,{[28]={{42.02,14.79}}},nil,28,{5944},{5862},67,nil,"Highlord of the Scarlet Crusade",2},
[1843] = {'Foreman Jerris',9711,9711,62,62,2,{[28]={{45.56,9.21}}},nil,28,nil,nil,16,nil,nil,0},
[1844] = {'Foreman Marcrid',3876,3876,58,58,4,{[28]={{49.04,32.73}}},nil,28,nil,nil,14,nil,nil,0},
[1845] = {'High Protector Tarsen',3198,3198,59,59,0,{[28]={{48.79,33.59}}},{[28]={{{48.83,33.71},{48.67,33.75},{48.46,33.61},{48.19,33.44},{48.03,33.17},{47.81,32.96},{47.6,32.76},{47.33,32.65},{47.09,32.68},{46.84,32.71},{46.58,32.82},{46.31,32.97},{46.09,33.22},{45.95,33.52},{45.93,33.99},{45.96,34.33},{46.02,34.79},{46.17,35.11},{46.43,35.19},{46.76,35.35},{47.04,35.39},{47.22,35.36},{47.51,35.37},{47.75,35.52},{47.91,35.78},{48.11,35.99},{48.33,36.25},{48.55,36.37},{48.84,36.49},{49.0,36.22},{49.15,35.71},{49.23,35.43},{49.32,34.86},{49.16,34.5},{48.96,34.42},{48.89,34.07}}}},28,nil,nil,67,nil,nil,0},
[1846] = {'High Protector Lorik',7545,7545,61,61,1,{[28]={{44.93,17.76}}},{[28]={{{44.91,17.72},{44.77,17.62},{44.56,17.51},{44.43,17.79},{44.3,18.09},{44.27,18.41},{44.34,18.98},{44.14,18.9},{43.98,18.7},{43.86,18.48},{43.69,18.23},{43.55,18.02},{43.39,17.78},{43.31,17.51},{43.28,17.21},{43.31,16.87},{43.34,16.51},{43.38,16.25},{43.41,15.99},{43.31,15.78},{43.17,15.68},{43.28,15.78},{43.47,15.98},{43.61,15.92},{43.79,15.84},{44.05,15.73},{44.22,16.0},{44.39,16.24},{44.57,16.43},{44.6,16.74},{44.59,17.06},{44.6,17.37},{44.74,17.55},{45.01,17.8},{45.14,17.93},{45.28,18.07},{45.42,18.22},{45.29,18.07},{45.02,17.76}}}},28,nil,nil,67,nil,nil,0},
[1847] = {'Foulmane',3082,3082,52,52,4,{[28]={{46.27,52.43}}},nil,28,nil,nil,21,nil,nil,0},
[1848] = {'Lord Maldazzar',2915,2915,56,56,4,{[28]={{54.16,80.43}}},nil,28,nil,nil,16,nil,nil,0},
[1849] = {'Dreadwhisper',3876,3876,58,58,4,nil,nil,0,nil,nil,21,nil,nil,0},
[1850] = {'Putridius',3589,3589,58,58,2,{[28]={{48.05,67.39}}},nil,28,nil,nil,14,nil,nil,0},
[1851] = {'The Husk',4370,4370,62,62,4,{[28]={{62.15,36.31}}},nil,28,nil,nil,91,nil,nil,0},
[1852] = {'Araj the Summoner',8300,8300,61,61,1,{[28]={{45.27,69.21}}},nil,28,nil,nil,21,nil,nil,0},
[1853] = {'Darkmaster Gandling',50300,50300,61,61,1,nil,nil,0,nil,nil,14,nil,nil,0},
[1854] = {'High Priest Thel\'danis',4370,4370,62,62,0,{[28]={{52.05,83.27}}},{[28]={{{52.01,83.34},{51.92,83.52},{51.91,83.76},{52.01,83.94},{52.15,84.04},{52.29,83.95},{52.4,83.76},{52.4,83.52},{52.31,83.34},{52.16,83.31},{52.03,83.36}}}},28,{8416},{8414},12,"A",nil,2},
[1855] = {'Tirion Fordring',25150,25150,61,61,1,{[139]={{7.57,43.7}}},nil,139,{5542,5543,5544,5742,5781,5845,5846,5861},{5542,5543,5544,5742,5781,5845,5848,5944},250,"AH",nil,3},
[1857] = {'Pissed Vendor',102,102,5,5,0,nil,nil,0,nil,nil,41,nil,"Pissed Vendor",0},
[1858] = {'Pissed not a Vendor',102,102,5,5,0,nil,nil,0,nil,nil,41,nil,"Pissed Vendor",0},
[1860] = {'Voidwalker',490,490,17,17,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1861] = {'Greater Voidwalker',787,787,26,26,0,nil,nil,0,nil,nil,90,nil,nil,0},
[1862] = {'Lesser Netherwalker',967,967,34,34,0,nil,nil,0,nil,nil,90,nil,nil,0},
[1863] = {'Succubus',303,303,20,20,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1864] = {'Greater Succubus',1341,1341,36,36,0,nil,nil,0,nil,nil,90,nil,nil,0},
[1865] = {'Ravenclaw Raider',247,273,12,13,0,{[130]={{46.68,54.2},{46.22,54.13},{46.04,54.15},{47.48,55.83},{45.59,56.39},{45.83,55.04},{46.14,55.66},{46.93,55.54},{46.56,53.23},{47.53,54.58},{47.98,52.91}}},nil,130,nil,nil,21,nil,nil,0},
[1866] = {'Ravenclaw Slave',222,247,11,12,0,{[130]={{46.24,54.63},{45.68,54.45},{45.83,54.42},{46.96,54.1},{53.02,16.19},{52.91,15.3},{53.41,14.99},{53.99,15.44},{52.22,14.49},{53.7,14.67},{47.15,53.61},{46.95,52.97},{53.0,14.14},{52.32,13.55},{51.68,13.7},{51.73,14.08},{52.04,13.92},{51.94,13.71},{52.06,15.23},{47.46,54.18},{53.65,14.04},{52.72,14.58},{48.06,51.27},{47.64,53.0},{48.02,52.6},{48.24,50.19}}},nil,130,nil,nil,21,nil,nil,0},
[1867] = {'Dalaran Apprentice',241,263,13,14,0,{[130]={{51.77,65.83},{52.16,66.4},{51.58,64.26},{56.69,65.85},{56.44,62.84},{49.31,67.14},{50.9,63.45},{50.57,60.92},{55.19,62.89},{49.47,69.09},{51.45,69.28},{50.29,69.8},{52.57,70.87},{53.12,68.72},{51.42,71.04},{53.15,70.43},{52.52,68.14},{53.01,65.69},{50.58,61.6},{51.98,57.9},{52.33,56.73},{50.91,59.56},{50.25,58.7},{50.21,59.78},{49.97,59.75},{50.16,60.28},{49.82,60.24},{52.4,63.79},{49.54,60.75},{53.11,62.86},{55.57,68.36},{49.37,69.54},{51.51,61.5},{50.59,66.34},{54.65,67.45}}},nil,130,nil,nil,76,"AH",nil,0},
[1868] = {'Ravenclaw Servant',253,276,13,14,0,{[130]={{55.05,35.58},{53.11,35.97},{52.47,35.83},{52.93,34.09},{52.46,34.99},{51.68,34.11},{53.92,32.65},{52.52,30.62},{52.4,32.9}}},nil,130,nil,nil,21,nil,nil,0},
[1869] = {'Ravenclaw Champion',300,328,14,15,0,{[130]={{56.59,32.14},{57.27,32.59},{56.1,33.26},{55.54,31.88},{53.09,31.73},{54.07,35.56},{54.84,32.43},{53.72,33.7}}},nil,130,nil,nil,21,nil,nil,0},
[1870] = {'Hand of Ravenclaw',328,356,15,16,0,{[130]={{58.55,36.48},{56.64,34.65},{57.75,34.91},{56.99,33.88},{56.13,35.21}}},nil,130,nil,nil,21,nil,nil,0},
[1871] = {'Eliza\'s Guard',896,950,28,29,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1872] = {'Tharek Blackstone',247,247,12,12,0,{[1]={{46.02,51.68}}},nil,1,{400,415},nil,55,"A",nil,2},
[1879] = {'Noma Bluntnose',328,328,15,15,0,nil,nil,0,nil,nil,57,"A",nil,0},
[1880] = {'Berte',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1881] = {'Evalyn',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[1883] = {'Scarlet Worker',3529,3758,55,57,0,{[28]={{46.12,12.36},{45.45,12.65},{45.77,10.84},{45.82,11.65},{45.96,16.16},{45.67,10.61},{45.92,17.26},{45.55,8.87},{45.51,12.7},{45.29,9.37},{45.86,10.97},{45.62,16.27},{43.63,17.19},{45.65,9.73},{45.31,9.28},{44.05,16.98},{44.88,12.04},{45.87,17.2},{45.5,9.51},{45.6,10.77},{44.13,17.36},{44.87,12.84},{45.91,16.58},{44.2,13.53},{43.87,17.32},{44.9,13.84},{44.49,12.57},{46.11,16.96},{46.04,12.38},{44.05,17.77},{43.88,16.76},{45.66,9.45},{44.91,11.97},{44.93,12.76},{45.62,16.39},{46.18,16.97},{45.7,9.72},{44.44,13.38},{46.02,16.18},{46.2,17.47},{45.35,9.97},{45.28,10.54},{45.16,9.95},{46.38,16.55},{44.42,12.56},{44.44,13.65},{44.91,12.72},{45.19,10.44},{45.23,10.3},{45.87,11.11},{45.68,16.65},{46.11,12.42},{45.52,8.76},{45.03,13.97},{45.79,15.96},{44.28,13.4}}},nil,28,nil,nil,67,nil,nil,0},
[1884] = {'Scarlet Lumberjack',3420,3644,54,56,0,{[28]={{46.53,32.18},{44.6,33.4},{47.66,32.57},{47.59,30.84},{44.11,33.93},{48.5,32.0},{46.27,33.44},{44.22,35.39},{45.28,35.02},{49.41,31.36},{48.27,31.8},{48.59,33.04},{45.09,34.18},{44.31,34.25},{45.03,34.29},{46.58,33.49},{44.84,33.84},{45.4,33.21},{48.23,32.2},{46.34,35.49},{49.39,34.27},{44.37,34.36},{44.83,33.73},{48.52,35.78},{47.99,32.97}}},nil,28,nil,nil,67,nil,nil,0},
[1885] = {'Scarlet Smith',8883,8883,59,59,4,{[28]={{44.36,13.54}}},nil,28,nil,nil,67,nil,nil,0},
[1888] = {'Dalaran Watcher',354,379,18,19,0,{[130]={{64.66,61.87},{64.6,63.65},{63.75,57.07},{63.45,58.24},{63.34,59.33},{64.45,57.95},{66.3,59.08},{65.17,56.32},{65.11,58.78},{63.02,60.96},{64.17,59.56},{65.78,57.68},{63.88,57.3},{64.42,56.36},{62.66,75.43},{62.88,76.46},{58.9,80.57},{63.63,77.22},{63.24,76.41},{62.63,73.4},{57.77,78.71},{61.2,75.87},{59.83,79.76},{61.18,79.74},{61.92,77.05},{62.49,76.72},{63.07,77.29},{62.33,77.19},{62.14,80.08},{60.06,76.04},{59.44,76.28},{55.96,78.03},{57.76,77.61},{62.39,74.36},{60.44,74.81}}},nil,130,nil,nil,76,"AH",nil,0},
[1889] = {'Dalaran Wizard',379,405,19,20,0,{[130]={{66.1,49.62},{65.8,50.67},{64.85,49.82},{65.15,52.32},{64.03,56.82},{63.4,57.11},{63.43,58.81},{63.4,58.87},{63.22,58.23},{63.77,58.93},{63.87,58.74},{65.01,58.49},{63.81,58.78},{65.37,56.44},{64.24,59.67},{62.86,76.16},{62.94,76.26},{63.41,65.29},{63.39,65.58},{63.15,65.5},{65.91,75.7},{64.12,73.94},{64.56,75.45},{65.04,74.04},{64.81,76.34},{62.47,76.62},{62.31,76.44},{57.61,77.46},{63.0,72.74},{65.19,77.98},{66.31,78.2},{63.51,58.13}}},nil,130,nil,nil,76,"AH",nil,0},
[1890] = {'Rattlecage Skeleton',55,71,2,3,0,{[85]={{34.65,64.38},{34.19,64.67},{34.36,65.06},{32.21,59.25},{32.98,63.0},{33.55,62.5},{34.27,62.88},{31.92,61.66},{31.02,60.8},{31.49,60.3},{32.05,60.09},{31.98,61.04},{32.74,60.47},{33.06,59.64},{33.24,60.14},{33.85,60.78},{32.2,61.74},{32.91,61.62},{33.29,61.66},{33.94,61.85}}},nil,85,nil,nil,7,"AH",nil,0},
[1891] = {'Pyrewood Watcher',819,900,13,14,1,{[130]={{47.41,73.99},{47.65,72.04},{44.61,72.77},{46.62,73.01},{42.78,73.14},{48.29,72.18},{45.68,74.97},{43.88,72.05},{44.6,74.39},{46.0,75.22},{45.76,72.31},{44.9,75.0},{45.35,72.52},{44.0,71.85}}},nil,130,nil,nil,123,"A",nil,0},
[1892] = {'Moonrage Watcher',819,900,13,14,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1893] = {'Moonrage Sentry',900,984,14,15,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1894] = {'Pyrewood Sentry',900,984,14,15,1,{[130]={{47.54,74.2},{47.36,73.95},{45.28,71.42},{45.29,71.63},{45.16,71.73},{47.97,73.12},{42.71,73.03},{46.21,74.23},{47.22,73.47},{44.01,73.51},{44.52,72.21},{45.49,75.32},{43.23,73.44},{43.61,73.29},{43.26,73.3},{44.98,73.25},{45.37,74.54},{43.78,72.82}}},nil,130,nil,nil,123,"A",nil,0},
[1895] = {'Pyrewood Elder',828,903,14,15,1,{[130]={{45.23,71.11},{47.59,74.09},{48.04,73.52},{46.33,71.81},{45.34,71.29},{44.5,74.31},{44.53,74.3},{44.56,74.63},{46.01,74.24},{45.38,74.67},{45.39,73.72},{43.44,73.04}}},nil,130,nil,nil,123,"A",nil,0},
[1896] = {'Moonrage Elder',828,903,14,15,1,nil,nil,0,nil,nil,16,nil,nil,0},
[1901] = {'Kelstrum Stonebreaker',2217,2217,45,45,0,{[1537]={{66.97,90.15}}},nil,1537,nil,nil,55,"A","Warrior Trainer",19},
[1907] = {'Naga Explorer',2059,2138,43,44,0,{[33]={{27.92,61.59},{27.9,64.57},{28.21,64.41},{28.04,63.4},{27.99,63.11},{27.84,62.32},{27.26,62.98},{27.05,62.46},{26.94,63.7},{26.99,61.39},{27.0,60.62},{26.2,62.42},{26.32,60.65},{25.07,63.69},{24.69,62.95},{25.67,61.32},{25.66,63.19},{24.48,64.39},{23.97,63.62},{25.04,60.48},{24.12,62.29},{26.4,59.99},{27.06,59.69},{25.14,58.77},{24.88,59.52},{25.8,59.63},{24.69,61.46}}},nil,33,nil,nil,74,nil,nil,0},
[1908] = {'Vile Fin Oracle',404,433,19,20,0,{[130]={{64.9,42.22},{69.88,18.23},{68.28,20.61},{72.77,17.41},{72.92,18.58},{64.16,41.86},{73.1,16.25},{73.21,16.9},{72.03,18.28},{71.32,18.41},{73.61,18.34},{71.11,17.29},{65.09,41.11},{65.29,43.46},{67.38,45.26},{66.94,48.62},{67.43,19.53},{73.12,16.71}}},nil,130,nil,nil,18,nil,nil,0},
[1909] = {'Vile Fin Lakestalker',377,404,18,19,0,{[130]={{65.91,45.98},{67.61,49.39},{65.74,47.05},{75.6,17.54},{67.35,17.45},{73.03,16.07},{75.32,15.87},{69.76,17.41},{70.61,17.5},{72.26,21.95},{70.56,22.25},{69.94,22.19},{71.37,21.83},{73.33,16.03},{64.44,19.72},{66.42,18.53},{65.27,18.63},{65.89,42.2},{65.17,42.65},{69.72,21.04},{65.48,21.69},{65.96,19.88},{64.56,21.3},{66.79,21.24},{65.08,20.89},{70.59,19.41},{68.87,17.14},{68.25,17.62},{68.05,18.78},{69.12,19.76},{72.55,16.59},{73.59,19.5},{73.71,17.52},{64.49,43.23},{73.05,16.6},{74.21,18.94},{65.92,43.39},{66.68,43.43},{65.57,44.92},{66.7,45.8},{66.91,45.62},{66.92,46.23},{67.3,44.53},{67.01,44.91},{66.78,47.24},{64.56,41.27},{73.82,16.06},{74.58,17.6},{74.96,18.66},{74.67,16.26},{75.39,17.04},{73.01,15.92},{74.68,16.31},{73.89,15.91},{73.86,17.43},{74.52,17.71}}},nil,130,nil,nil,18,nil,nil,0},
[1910] = {'Muad',186,186,10,10,4,{[85]={{36.49,42.39}}},{[85]={{{36.51,42.38},{36.08,42.07},{35.5,41.76},{35.04,41.28},{35.11,41.03},{35.29,40.63},{35.3,40.26},{34.73,40.23},{34.34,40.46},{34.5,41.0},{34.74,40.99},{34.49,41.41},{33.78,42.25},{33.57,43.01},{33.67,43.59},{34.34,44.27},{34.64,44.3},{34.67,44.66},{34.95,44.79},{35.48,44.58},{36.3,44.49},{35.73,43.53},{35.83,43.26},{35.97,43.13},{36.05,42.97},{36.08,43.07},{36.0,43.04},{36.08,42.87},{36.22,42.81},{36.41,42.54},{36.41,42.25},{36.32,42.67},{36.47,42.75},{36.54,42.44}}}},85,nil,nil,18,nil,nil,0},
[1911] = {'Deeb',230,230,12,12,4,{[85]={{63.29,27.48}}},nil,85,nil,nil,18,nil,nil,0},
[1912] = {'Dalaran Protector',300,328,14,15,0,{[130]={{56.68,54.37},{60.14,66.46},{62.08,61.42},{61.96,62.8},{60.11,65.95},{60.93,63.25},{60.18,65.9},{58.53,66.46},{57.56,67.49},{58.82,65.18},{58.04,65.63},{59.65,65.23},{60.88,65.01},{62.79,68.49},{54.95,60.41},{55.46,61.16},{57.27,63.54},{58.03,62.59},{58.65,63.2},{58.04,61.86},{59.11,61.87},{59.86,62.27},{60.75,62.5},{56.46,58.75},{55.47,56.31},{54.85,54.4},{61.68,66.9},{57.99,64.37},{55.17,67.8}}},nil,130,nil,nil,76,"AH",nil,0},
[1913] = {'Dalaran Warder',356,386,16,17,0,{[130]={{62.99,62.32},{63.5,63.1},{63.58,64.04},{63.55,65.44},{62.73,62.38},{62.73,63.39},{62.5,63.92},{62.97,62.24},{64.01,63.91}}},nil,130,nil,nil,76,"AH",nil,0},
[1914] = {'Dalaran Mage',285,307,15,16,0,{[130]={{62.15,71.8},{61.62,69.05},{60.41,66.54},{60.41,66.67},{62.69,67.63},{62.61,67.45},{61.3,62.56},{59.04,67.09},{58.04,66.32},{59.24,65.64},{60.18,65.25},{59.74,66.55},{62.81,69.62},{58.95,62.4},{59.05,61.85},{59.4,61.89},{59.87,62.39},{59.6,63.25},{59.8,62.35},{60.81,62.5},{57.64,64.3}}},nil,130,nil,nil,76,"AH",nil,0},
[1915] = {'Dalaran Conjuror',330,354,17,18,0,{[130]={{62.96,62.09},{63.44,63.75},{63.34,63.4},{63.54,65.3},{62.75,63.46},{63.23,62.54},{63.83,65.81},{62.7,64.63},{63.16,65.31}}},nil,130,nil,nil,76,"AH",nil,0},
[1916] = {'Stephen Bhartec',55,71,2,3,0,{[85]={{36.44,61.93}}},nil,85,nil,nil,7,"AH",nil,0},
[1917] = {'Daniel Ulfman',55,71,2,3,0,{[85]={{36.71,62.06}}},nil,85,nil,nil,7,"AH",nil,0},
[1918] = {'Karrel Grayves',55,71,2,3,0,{[85]={{36.78,61.91}}},nil,85,nil,nil,7,"AH",nil,0},
[1919] = {'Samuel Fipps',102,102,5,5,0,{[85]={{36.68,61.56}}},nil,85,nil,nil,7,"AH",nil,0},
[1920] = {'Dalaran Spellscribe',441,441,21,21,4,{[130]={{63.54,63.35}}},nil,130,nil,nil,76,"AH",nil,0},
[1921] = {'Combat Dummy',42,42,1,1,0,nil,nil,0,nil,nil,914,"AH",nil,0},
[1922] = {'Gray Forest Wolf',137,156,7,8,0,{[12]={{74.01,68.91},{73.78,66.15},{72.81,67.57},{74.19,64.95},{71.59,66.46},{71.83,63.21},{72.77,63.23},{73.77,63.62},{71.39,61.07},{70.52,61.83},{70.4,63.58},{69.79,61.85},{69.78,61.14},{68.99,62.94},{69.01,57.41},{68.15,57.88},{68.39,59.51},{69.31,64.13},{67.59,62.24},{68.64,65.13},{67.56,64.09},{68.17,65.85},{66.87,62.81},{69.87,69.54},{66.19,67.77},{66.15,65.65},{62.23,70.94},{63.12,68.96},{61.37,66.37},{61.3,66.81},{65.11,64.36},{65.55,63.62},{63.19,63.69},{64.59,60.31},{66.39,58.25},{61.83,61.13},{60.41,59.7},{60.91,64.3},{60.86,63.56},{60.58,63.7},{61.03,63.37},{60.55,63.99},{60.87,61.5},{60.2,66.73},{60.07,64.3},{59.7,65.41},{59.77,65.88},{60.13,65.8},{58.44,62.13},{58.68,63.94},{59.07,64.74},{61.08,70.14},{59.87,68.59},{59.25,69.43},{59.37,66.85},{60.44,71.34}}},nil,12,nil,nil,38,nil,nil,0},
[1923] = {'Bloodsnout Worg',356,386,16,17,0,{[130]={{45.92,79.34},{48.91,81.96},{49.43,82.56},{44.59,80.7},{51.57,76.42},{51.47,77.91},{51.8,76.69},{49.83,73.97},{50.23,84.85},{51.67,79.47},{49.78,77.69},{49.67,84.2},{52.47,81.85},{47.48,80.8},{46.69,77.11},{48.28,77.33},{48.41,80.33},{52.16,78.18},{50.02,76.44},{48.73,80.8},{49.67,75.36},{55.03,80.31}}},nil,130,nil,nil,38,nil,nil,0},
[1924] = {'Moonrage Bloodhowler',328,356,15,16,0,{[130]={{54.74,78.25},{58.71,42.3},{58.49,42.33},{59.58,40.99},{60.49,41.35},{50.77,76.96},{48.06,78.28},{57.9,41.38},{60.27,41.38},{48.32,82.26},{44.49,79.16},{45.18,80.49},{49.08,76.32},{48.11,75.69},{46.89,82.47},{51.74,78.86},{50.8,79.61},{49.85,80.55},{53.1,82.47},{46.64,78.2},{47.29,77.53},{46.78,79.48},{49.11,79.0},{51.57,85.38},{52.49,86.38},{53.49,84.73},{54.12,76.98},{53.12,75.36},{52.25,74.51},{51.09,74.26},{49.74,73.78},{50.95,75.18},{55.01,81.35}}},nil,130,nil,nil,24,nil,nil,0},
[1925] = {'Heat Miser',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH","Immune to Fire",0},
[1926] = {'Snow Miser',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH","Immune to Frost",0},
[1927] = {'Good Miser',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH","Immune to Holy",0},
[1928] = {'Bad Miser',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH","Immune to Shadow",0},
[1929] = {'Earth Miser',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH","Immune to Nature",0},
[1930] = {'Steel Miser',484,484,20,20,0,nil,nil,0,nil,nil,7,"AH","Immune to Physical",0},
[1931] = {'Captured Scarlet Zealot',176,176,9,9,0,{[85]={{61.97,51.29}}},nil,85,nil,{407},68,"H",nil,2},
[1932] = {'Black Sheep',0,0,1,1,0,nil,nil,0,nil,nil,31,"AH",nil,0},
[1933] = {'Sheep',14,14,3,3,0,{[38]={{63.87,31.29},{39.25,26.72},{19.32,82.38},{62.58,61.7},{31.4,58.25}},[44]={{19.13,47.13},{34.31,42.26},{29.9,62.92},{34.28,60.13}},[267]={{37.41,64.08},{47.03,60.41}},[36]={{56.59,65.47}},[12]={{34.58,54.79},{30.97,58.04},{40.0,61.7},{41.87,69.78},{44.17,70.62},{39.2,68.08},{31.2,81.05},{35.34,87.27},{47.31,80.71},{52.71,84.5},{56.69,75.04},{65.5,79.05},{64.18,75.76},{78.09,70.66},{77.96,81.99},{80.56,52.37},{89.37,73.33}}},nil,12,nil,nil,31,"AH",nil,0},
[1934] = {'Tirisfal Farmer',120,137,6,7,0,{[85]={{37.89,50.65},{37.97,49.93},{38.1,50.35},{37.97,51.86},{38.24,51.78},{35.78,50.68},{36.54,51.8},{37.49,51.63},{34.63,50.67}}},nil,85,nil,nil,67,nil,nil,0},
[1935] = {'Tirisfal Farmhand',101,120,5,6,0,{[85]={{38.12,51.73},{35.13,51.57},{37.16,50.48},{35.33,49.34},{36.57,49.48},{38.77,50.58},{37.9,48.96},{38.61,49.23}}},nil,85,nil,nil,67,nil,nil,0},
[1936] = {'Farmer Solliden',156,156,8,8,4,{[85]={{38.04,49.61},{34.07,52.11},{37.09,49.46},{38.03,52.21}}},nil,85,nil,nil,67,nil,nil,0},
[1937] = {'Apothecary Renferrel',300,300,14,14,0,{[130]={{42.8,40.86}}},nil,130,{430,444,447,448,451,493,1359},{429,443,445,446,450,3221},68,"H","Royal Apothecary Society",2},
[1938] = {'Dalar Dawnweaver',531,531,21,21,0,{[130]={{44.2,39.81}}},nil,130,{99,421,422,423,424,482,1014},{99,421,422,423,424,481,1014},68,"H",nil,2},
[1939] = {'Rot Hide Brute',356,386,16,17,0,{[130]={{69.44,34.93},{64.59,23.26},{67.7,25.45},{67.11,23.73},{67.56,25.48},{68.21,31.5},{66.72,30.28},{66.67,33.01},{66.42,34.03},{68.41,35.72},{67.9,33.54},{67.43,34.0},{69.04,36.19},{67.01,25.97},{66.86,26.48},{66.93,24.5},{66.25,25.8},{65.43,27.61},{64.73,25.07},{64.66,24.03},{65.63,29.1},{65.05,30.84},{65.79,30.42},{65.67,28.39},{65.97,27.11},{66.31,30.59},{66.31,26.76},{65.8,31.16},{67.77,35.71}}},nil,130,nil,nil,70,nil,nil,0},
[1940] = {'Rot Hide Plague Weaver',350,377,17,18,0,{[130]={{69.77,37.09},{64.44,23.59},{64.67,23.15},{68.23,25.73},{67.52,25.55},{66.97,23.31},{67.67,25.37},{68.3,33.13},{69.01,33.92},{67.6,31.44},{65.02,26.4},{66.45,34.98},{67.38,36.31},{66.84,26.38},{67.67,24.46},{67.89,24.98},{65.28,27.1},{66.2,27.97},{65.45,25.61},{65.9,34.01},{68.23,35.02}}},nil,130,nil,nil,70,nil,nil,0},
[1941] = {'Rot Hide Graverobber',120,137,6,7,0,{[85]={{56.5,46.09},{55.21,43.88},{56.82,44.99},{57.72,41.91},{54.89,42.39},{56.25,43.56},{58.26,42.92},{53.29,41.5},{55.19,42.2},{55.22,42.56},{55.52,42.81},{54.98,41.38},{57.14,40.32},{55.77,40.54},{55.44,41.9},{55.65,39.19},{56.62,39.74},{53.8,43.93},{55.42,41.03},{56.38,41.14},{54.31,42.77},{57.18,44.69},{56.3,43.7},{56.09,43.97},{56.62,46.15},{55.78,42.27}}},nil,85,nil,nil,70,nil,nil,0},
[1942] = {'Rot Hide Savage',417,449,18,19,0,{[130]={{66.36,23.5},{66.26,24.7},{66.23,23.14},{66.42,25.07},{65.3,24.97},{65.08,25.13},{66.32,24.35},{65.56,23.98},{65.71,24.03},{65.32,23.52},{65.27,23.42},{65.25,24.83},{65.85,25.04},{65.64,25.07},{66.25,24.75},{65.57,23.32},{65.9,23.31}}},nil,130,nil,nil,70,nil,nil,0},
[1943] = {'Raging Rot Hide',417,449,18,19,0,{[130]={{65.75,23.39},{65.71,23.78},{65.49,23.61},{66.33,23.33},{66.25,25.06},{66.18,24.78},{66.37,23.24},{65.31,23.46},{66.34,25.03},{65.21,24.92},{65.58,23.55},{65.89,23.86},{65.15,23.2},{66.2,24.61},{65.25,24.67},{65.2,23.87},{66.05,23.93},{66.11,23.81}}},nil,130,nil,nil,70,nil,nil,0},
[1944] = {'Rot Hide Bruiser',573,573,22,22,4,{[130]={{64.67,23.05}}},nil,130,nil,nil,70,nil,nil,0},
[1945] = {'Tree Form 0.33',955,1057,30,32,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1946] = {'Lillith Nefara',247,247,12,12,0,nil,nil,0,nil,nil,14,nil,nil,0},
[1947] = {'Thule Ravenclaw',1584,1584,24,24,1,{[130]={{65.71,23.67}}},nil,130,nil,nil,70,nil,nil,0},
[1948] = {'Snarlmane',726,726,23,23,4,{[130]={{65.1,25.1}}},nil,130,nil,nil,70,nil,nil,0},
[1949] = {'Servant of Azora',198,198,10,10,0,{[12]={{65.07,70.11},{65.42,70.11},{64.79,70.62},{64.6,69.78},{64.0,69.59},{64.78,69.93},{64.41,69.94},{65.12,69.48},{64.74,69.61},{64.44,68.4}}},nil,12,nil,nil,12,"A",nil,2},
[1950] = {'Rane Yorick',328,328,15,15,0,{[130]={{53.46,13.43}}},nil,130,{425,429,449},{425,428,435},68,"H","Deathstalker",2},
[1951] = {'Quinn Yorick',300,300,14,14,0,{[130]={{53.43,12.59}}},nil,130,nil,{430},68,"H","Deathstalker",2},
[1952] = {'High Executor Hadrec',1002,1002,30,30,0,{[130]={{43.42,40.86}}},nil,130,{428,437,438,440,442,443,1098,3221},{437,439,442,448,449},68,"H",nil,2},
[1953] = {'Lake Skulker',328,356,15,16,0,{[130]={{70.0,33.56},{72.77,38.01},{71.53,36.0},{70.57,37.32},{68.62,37.41},{69.74,38.3},{72.13,37.5},{73.16,36.09},{72.23,34.71},{71.24,34.15},{70.56,35.27},{73.15,34.47}}},nil,130,nil,nil,14,nil,nil,0},
[1954] = {'Elder Lake Skulker',325,325,16,16,0,{[130]={{73.76,35.26},{74.29,34.86},{75.1,32.86},{73.96,35.13},{75.0,34.5},{72.0,36.8}}},nil,130,nil,nil,14,nil,nil,0},
[1955] = {'Lake Creeper',386,417,17,18,0,{[130]={{77.57,29.13},{76.54,26.1},{76.55,27.65},{76.63,28.72},{77.42,27.71},{78.32,25.19},{77.03,26.58},{77.29,28.73},{78.02,27.02},{78.26,26.11},{77.54,25.23}}},nil,130,nil,nil,14,nil,nil,0},
[1956] = {'Elder Lake Creeper',417,449,18,19,0,{[130]={{75.19,20.67},{73.8,20.96},{75.48,19.74},{74.06,20.36},{78.52,22.41},{76.95,20.75},{76.4,19.36},{79.02,23.89},{76.96,24.73},{77.25,22.98},{74.63,21.76},{76.23,22.54},{75.43,23.13},{77.95,23.15},{76.7,23.41}}},nil,130,nil,nil,14,nil,nil,0},
[1957] = {'Vile Fin Shorecreeper',356,386,16,17,0,{[130]={{78.15,31.12},{77.75,31.49},{77.57,30.75},{78.5,31.08},{77.57,31.09},{76.06,32.72},{76.84,34.29},{77.31,33.91},{77.27,34.26},{76.56,30.2},{76.22,34.99}}},nil,130,nil,nil,18,nil,nil,0},
[1958] = {'Vile Fin Tidecaller',350,377,17,18,0,{[130]={{81.3,31.47},{79.98,32.41},{80.88,28.06},{78.42,32.56},{77.55,32.55},{78.06,32.03},{77.56,33.52},{78.28,31.43},{77.9,31.14},{78.07,30.56},{78.46,30.49},{78.32,30.85},{80.89,31.77},{80.24,28.62},{80.47,28.69},{80.14,28.3},{80.83,29.6},{77.74,30.03},{78.5,29.24},{79.13,28.23},{80.34,28.25},{79.86,28.12},{80.49,28.36},{78.83,31.91},{80.14,31.53},{80.48,29.52},{79.31,30.28},{80.26,27.7},{80.07,29.3},{77.24,32.06},{77.14,33.79},{76.23,33.85},{80.45,32.45},{80.18,26.97},{76.82,32.94},{75.26,31.39},{75.78,30.11},{75.27,32.84}},[36]={{27.25,34.92},{27.19,34.9}}},nil,130,nil,nil,18,nil,nil,0},
[1959] = {'Mountaineer Barleybrew',726,726,20,20,0,{[1]={{86.28,48.81}}},nil,1,{414},{413},57,"A",nil,2},
[1960] = {'Pilot Hammerfoot',386,386,17,17,0,{[1]={{83.89,39.19}}},nil,1,{419},{417},55,"A",nil,2},
[1961] = {'Mangeclaw',222,222,11,11,0,{[1]={{78.31,37.76}}},nil,1,nil,nil,44,nil,nil,0},
[1963] = {'Vidra Hearthstove',198,198,10,10,0,{[38]={{34.83,49.28}}},nil,38,{418},{418},55,"A",nil,2},
[1964] = {'Treant',3052,3052,60,60,0,nil,nil,0,nil,nil,91,nil,nil,0},
[1965] = {'Mountaineer Thalos',328,328,15,15,0,{[1]={{33.48,71.84}}},nil,1,{420},{282},55,"A",nil,2},
[1971] = {'Ivar the Foul',273,273,13,13,0,{[130]={{51.52,13.9}}},nil,130,nil,nil,21,nil,nil,0},
[1972] = {'Grimson the Pale',328,328,15,15,0,{[130]={{58.58,44.86}}},nil,130,nil,nil,24,nil,nil,0},
[1973] = {'Ravenclaw Guardian',494,531,20,21,0,{[130]={{57.12,71.02},{57.58,71.53},{57.4,70.88},{57.76,69.82},{57.28,69.89},{58.76,71.75},{58.68,71.61},{58.96,70.86},{58.66,71.29},{60.03,71.11},{59.66,69.88},{59.58,71.76}}},nil,130,nil,nil,21,nil,nil,0},
[1974] = {'Ravenclaw Drudger',449,484,19,20,0,{[130]={{60.34,74.01},{57.44,70.81},{57.73,69.81},{56.75,70.43},{58.06,69.89},{58.3,72.01},{59.64,70.76},{59.14,70.5},{60.58,72.37},{60.01,72.09},{60.66,72.6}}},nil,130,nil,nil,21,nil,nil,0},
[1975] = {'Eastvale Lumberjack',156,156,8,8,0,{[12]={{82.59,63.26},{83.05,63.58},{82.57,63.85}}},{[12]={{{82.69,63.66},{82.78,63.48},{82.77,63.33},{82.76,63.13},{82.77,63.32},{82.78,63.47},{82.69,63.64},{82.58,63.84},{82.46,64.01},{82.38,64.22}}}},12,nil,nil,11,"A",nil,0},
[1976] = {'Stormwind City Patroller',5228,5228,55,55,0,{[1519]={{50.99,28.06},{38.54,36.48},{64.96,70.28},{60.32,75.31},{60.18,51.3},{60.11,67.9},{50.12,37.49},{46.83,31.81},{33.24,64.1}}},nil,1519,nil,nil,11,"A",nil,1},
[1977] = {'Senator Mehr Stonehallow',2768,2768,50,50,0,{[1]={{68.67,55.97}}},nil,1,{433},{433},55,"A",nil,2},
[1978] = {'Deathstalker Erland',222,222,11,11,0,{[130]={{56.18,9.18}}},nil,130,{435},nil,98,"H",nil,2},
[1979] = {'TEST WOLF (ALPHA FIRST)',55,55,2,2,0,nil,nil,0,nil,nil,32,"AH",nil,0},
[1980] = {'TEST WOLF (ALPHA SECOND)',55,55,2,2,0,nil,nil,0,nil,nil,32,"AH",nil,0},
[1981] = {'Dark Iron Ambusher',198,198,10,10,0,nil,nil,0,nil,nil,54,nil,nil,0},
[1983] = {'Nightlash',300,300,14,14,0,nil,nil,0,nil,nil,70,nil,nil,0},
[1984] = {'Young Thistle Boar',42,55,1,2,0,{[141]={{56.72,42.19},{55.6,41.92},{57.77,42.42},{55.49,42.26},{55.07,43.42},{63.23,42.23},{63.3,42.44},{55.54,43.44},{55.87,41.25},{62.08,41.23},{60.61,46.26},{56.57,42.22},{57.63,39.54},{57.44,45.02},{56.68,44.25},{57.05,45.62},{61.29,43.71},{61.53,42.94},{61.17,45.66},{62.03,42.45},{59.1,43.34},{59.5,45.26},{58.51,45.66},{59.0,44.37}}},nil,141,nil,nil,189,"AH",nil,0},
[1985] = {'Thistle Boar',55,71,2,3,0,{[141]={{55.34,37.07},{56.35,37.88},{55.5,39.44},{56.36,36.94},{56.33,38.36},{57.19,35.71},{61.83,38.65},{60.15,39.09},{59.81,37.6},{60.21,34.85},{58.24,34.84},{60.04,31.59},{59.43,34.61},{60.28,34.15},{60.34,34.04},{59.64,36.91},{61.37,36.04},{61.37,35.3},{61.8,34.25},{62.2,35.87}}},nil,141,nil,nil,189,"AH",nil,0},
[1986] = {'Webwood Spider',71,86,3,4,0,{[141]={{57.68,27.4},{57.92,26.95},{57.35,26.01},{57.86,26.06},{57.91,26.42},{58.0,27.26},{56.89,28.2},{57.25,27.49},{57.77,28.01},{57.95,28.36},{58.02,28.6},{57.55,29.13},{57.23,29.38},{57.23,29.65},{56.04,26.41},{55.73,25.22},{56.07,24.86},{56.26,24.92},{56.44,25.87},{56.88,26.28},{58.76,33.43},{57.79,32.63},{57.55,32.7},{56.77,31.37},{56.76,31.3},{56.55,30.55},{56.37,30.25},{56.48,29.51},{55.94,29.02},{55.72,28.44},{55.81,27.22},{55.85,27.25},{55.52,27.59},{56.08,26.92},{56.28,26.51},{55.95,26.2},{55.71,25.14},{56.42,24.84},{57.19,32.28},{56.57,34.34},{56.5,25.29},{56.8,25.57},{56.46,26.79},{57.59,33.87},{56.37,33.2},{56.9,27.75},{56.9,28.42},{56.56,29.4},{56.37,30.31},{56.58,30.73},{56.73,31.29},{57.24,33.93},{56.21,32.54},{56.77,31.82},{56.12,29.11},{55.69,28.47},{57.8,32.5},{57.75,33.1},{55.54,27.65},{55.77,27.5},{56.11,26.96},{55.88,27.09}}},nil,141,nil,nil,22,nil,nil,0},
[1987] = {'Webwood Creeper UNUSED',71,86,3,4,0,nil,nil,0,nil,nil,22,nil,nil,0},
[1988] = {'Grell',55,71,2,3,0,{[141]={{55.92,45.15},{56.16,45.81},{55.71,46.45},{56.13,45.36},{55.81,45.51},{56.03,45.56},{55.69,46.0},{55.86,45.95},{55.97,45.97},{56.2,46.25},{56.4,46.13},{55.77,41.55}}},nil,141,nil,nil,189,"AH",nil,0},
[1989] = {'Grellkin',71,86,3,4,0,{[141]={{54.0,39.74},{62.3,35.66},{64.16,42.24},{54.02,39.0},{54.18,39.19},{56.16,38.54},{54.02,38.38},{54.13,39.32},{54.23,39.22},{54.25,39.33},{54.9,39.78},{54.4,39.43},{54.68,38.47},{54.28,38.86},{56.32,34.61},{59.64,35.03},{54.53,44.06},{54.75,44.34},{54.54,44.77},{54.68,44.17},{54.63,44.05},{54.9,38.8},{54.56,43.83},{54.67,43.45},{54.41,43.57},{54.23,44.19},{54.87,43.51},{54.91,44.13}}},nil,141,nil,nil,189,"AH",nil,0},
[1990] = {'Gremlin',71,86,3,4,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[1991] = {'Jaxil Rye',102,102,5,5,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[1992] = {'Tarindrella',137,137,7,7,0,{[141]={{57.83,45.21}}},nil,141,{459},{458,459},80,"A",nil,2},
[1993] = {'Greenpaw',186,186,10,10,0,{[141]={{44.56,62.54}}},nil,141,nil,nil,82,nil,nil,0},
[1994] = {'Githyiss the Vile',102,102,5,5,0,{[141]={{56.65,26.31}}},nil,141,nil,nil,22,nil,nil,0},
[1995] = {'Strigid Owl',102,120,5,6,0,{[141]={{52.05,56.36},{64.75,51.47},{68.71,62.4},{53.47,59.37},{64.2,54.37},{65.37,52.65},{67.2,61.41},{45.85,47.5},{53.03,54.48},{67.48,53.56},{68.13,62.15},{65.69,54.48},{46.31,48.63},{54.07,60.12},{50.02,58.69},{52.21,59.33},{49.78,58.08},{52.39,62.72},{54.81,63.96},{55.42,65.99},{64.0,64.1},{57.94,60.77},{64.88,61.47},{63.03,64.17},{62.66,63.06},{57.6,56.33},{58.86,60.29},{62.0,51.42},{61.21,50.61},{63.36,53.59},{63.41,51.73},{58.72,56.19},{52.75,56.88},{54.23,57.0},{54.11,60.38},{53.71,59.35}}},nil,141,nil,nil,15,"AH",nil,0},
[1996] = {'Strigid Screecher',137,156,7,8,0,{[141]={{58.06,76.21},{64.25,69.24},{39.55,54.54},{39.1,51.36},{39.73,53.71},{43.77,77.43},{41.86,71.53},{42.35,72.25},{41.25,49.65},{51.91,77.36},{53.06,77.89},{42.79,48.93},{65.55,66.45},{65.88,67.03},{57.61,75.01},{53.71,77.07},{38.43,62.47},{48.16,74.19},{38.82,51.46},{37.6,51.29},{53.29,76.63},{64.2,67.23},{52.46,77.78},{38.75,63.36},{46.2,75.54},{58.88,76.96},{58.47,75.0},{38.2,55.58},{45.58,76.52},{41.05,68.39},{42.17,75.34},{42.91,77.12},{39.28,65.31},{39.48,53.03},{43.9,50.57},{42.67,52.08}}},nil,141,nil,nil,15,"AH",nil,0},
[1997] = {'Strigid Hunter',156,176,8,9,0,{[141]={{40.82,44.97},{46.25,31.44},{45.57,40.55},{37.56,29.3},{39.28,46.07},{46.12,39.67},{38.07,39.51},{38.48,46.22},{37.69,37.93},{37.97,38.31},{39.04,30.72},{38.54,47.81},{44.39,39.85}}},nil,141,nil,nil,15,"AH",nil,0},
[1998] = {'Webwood Lurker',102,120,5,6,0,{[141]={{68.04,64.07},{67.22,62.04},{69.51,60.35},{45.86,46.71},{69.52,57.15},{51.02,53.85},{70.06,60.25},{67.05,66.29},{68.47,63.57},{60.86,54.53},{53.52,61.89},{47.05,46.96},{54.23,62.51},{51.61,59.39},{51.01,65.25},{54.27,64.24},{52.92,64.28},{52.58,67.4},{51.67,66.3},{53.33,66.71},{60.93,55.2},{61.43,54.6},{60.77,54.58},{60.77,57.13},{60.08,58.24},{63.34,63.16},{63.91,60.84},{59.55,59.7},{64.05,61.77},{61.13,61.25},{60.23,59.51},{58.17,55.84},{52.25,55.58},{53.61,61.35},{51.76,58.49},{60.14,60.26},{52.24,55.71}}},nil,141,nil,nil,22,nil,nil,0},
[1999] = {'Webwood Venomfang',137,156,7,8,0,{[141]={{44.81,77.47},{38.86,61.67},{61.0,73.45},{41.83,75.01},{40.74,48.78},{54.35,74.2},{65.2,69.14},{45.76,78.9},{59.61,76.11},{55.03,73.22},{38.73,47.9},{37.17,47.36},{54.48,77.37},{41.17,76.03},{44.68,74.47},{45.07,77.91},{48.51,75.11},{49.01,76.05},{38.85,59.6},{54.3,76.13},{60.18,75.04},{61.54,75.04},{45.35,70.18},{45.29,73.07},{39.78,59.96},{40.39,48.62},{46.51,71.6},{42.86,74.69},{43.75,54.32},{42.77,52.56}}},nil,141,nil,nil,22,nil,nil,0},
[2000] = {'Webwood Silkspinner',156,176,8,9,0,{[141]={{43.69,47.28},{43.24,45.49},{47.95,32.09},{34.61,32.65},{45.09,35.14},{43.85,44.48},{33.31,31.02},{45.81,43.41},{47.36,34.09},{39.93,31.42},{36.31,32.26},{48.57,44.94},{42.44,46.28},{33.58,32.3},{47.82,44.5},{43.09,43.54}}},nil,141,nil,nil,22,nil,nil,0},
[2001] = {'Giant Webwood Spider',198,222,10,11,0,{[141]={{45.71,27.47},{41.2,28.93},{40.15,25.4},{38.03,27.91}}},nil,141,nil,nil,22,nil,nil,0},
[2002] = {'Rascal Sprite',98,115,5,6,0,{[141]={{53.68,51.46},{52.95,51.28},{52.91,52.06},{53.17,48.8},{53.59,48.81},{53.6,49.05},{53.82,50.8},{53.58,50.0}}},nil,141,nil,nil,90,nil,nil,0},
[2003] = {'Shadow Sprite',98,115,5,6,0,{[141]={{53.54,51.15},{52.97,50.88},{53.0,50.31},{52.94,51.48},{53.41,51.75},{53.28,50.77},{54.04,51.17},{54.71,51.39},{54.6,52.62},{54.48,51.88}}},nil,141,nil,nil,90,nil,nil,0},
[2004] = {'Dark Sprite',120,137,6,7,0,{[141]={{52.38,50.2},{51.22,51.04},{53.03,49.31},{52.6,49.81},{51.74,48.92},{51.65,50.03},{51.4,49.99},{52.76,50.03}}},nil,141,nil,nil,90,nil,nil,0},
[2005] = {'Vicious Grell',137,137,7,7,0,{[141]={{51.78,50.47},{51.64,51.64},{52.22,51.08},{52.01,50.59},{52.2,50.71},{51.47,51.47},{52.1,52.12},{51.3,50.56},{52.06,48.53},{51.55,48.85},{52.66,49.46}}},nil,141,nil,nil,90,nil,nil,0},
[2006] = {'Gnarlpine Ursa',102,120,5,6,0,{[141]={{66.7,63.34},{65.8,63.83},{65.38,64.09},{64.99,63.87},{66.67,60.36},{68.08,58.43},{68.84,58.18},{65.44,57.62},{64.73,57.5},{66.67,64.41}}},nil,141,nil,nil,82,nil,nil,0},
[2007] = {'Gnarlpine Gardener',102,120,5,6,0,{[141]={{65.26,65.56},{65.92,63.77},{64.68,64.07},{66.07,60.4},{67.4,55.41},{65.47,63.22},{65.35,61.63},{67.37,60.52},{65.5,59.11},{65.82,64.26},{65.3,58.29},{66.82,56.42},{67.26,59.12}}},nil,141,nil,nil,82,nil,nil,0},
[2008] = {'Gnarlpine Warrior',120,137,6,7,0,{[141]={{70.48,52.37},{69.3,52.8},{70.17,52.68},{70.27,53.09},{69.73,53.92},{65.65,64.87},{65.86,63.66},{65.6,64.71},{66.97,59.71},{49.69,66.37},{49.74,68.12},{49.98,65.63},{50.31,66.17},{50.06,66.77},{50.93,62.04},{50.29,62.11},{65.73,64.75},{65.96,59.62},{49.78,61.37},{50.37,61.24},{68.64,53.16},{67.84,60.15},{67.96,52.59},{68.31,52.49},{65.89,57.37},{66.47,57.24},{66.3,58.62},{66.34,58.99},{67.05,57.59},{67.41,57.0},{65.8,58.24},{66.42,59.33},{66.61,58.2},{68.0,59.4}}},nil,141,nil,nil,82,nil,nil,0},
[2009] = {'Gnarlpine Shaman',131,148,7,8,0,{[141]={{37.4,66.99},{37.92,66.19},{49.55,66.79},{49.39,66.63},{49.26,67.37},{56.83,76.48},{57.2,75.97},{56.87,75.01},{56.54,77.24},{49.03,78.05},{47.88,77.63},{46.83,77.95},{48.63,78.76},{46.37,77.34},{38.34,65.6},{47.29,76.92},{47.94,77.92},{47.55,78.49},{47.35,77.39},{45.23,57.79},{44.39,57.07},{50.55,62.92},{49.96,62.69},{44.53,57.43},{44.22,58.25},{44.63,57.63},{44.49,60.47},{44.27,58.49},{44.19,60.31},{44.41,61.24},{45.56,59.06},{45.47,59.9},{45.09,60.09},{45.31,58.79},{45.02,58.34},{43.69,60.46},{43.79,61.74},{44.01,61.1},{43.26,60.74},{43.6,59.98},{44.18,59.38},{44.07,59.55},{44.36,58.54},{42.88,61.24},{44.88,57.33},{45.23,58.68},{45.57,59.0}}},nil,141,nil,nil,82,nil,nil,0},
[2010] = {'Gnarlpine Defender',137,156,7,8,0,{[141]={{41.43,71.94},{39.3,66.24},{37.83,67.13},{38.23,66.79},{38.54,66.22},{39.08,67.05},{38.52,67.19},{38.36,67.86},{37.45,66.28},{44.04,56.6},{44.75,58.72},{45.11,57.55},{49.35,66.82},{49.36,66.08},{54.94,75.2},{56.23,76.57},{55.63,75.76},{48.56,78.06},{48.18,77.68},{47.13,77.71},{48.01,77.81},{45.79,78.05},{49.04,76.92},{43.8,61.31},{44.45,57.12},{43.87,57.69},{43.9,61.14},{49.99,62.47},{49.56,62.65},{49.98,63.16},{44.78,56.08},{43.13,59.64},{43.34,58.78},{43.72,58.55},{44.44,60.35},{44.63,56.7},{44.33,57.46},{43.0,59.07},{43.93,61.41},{44.49,60.0},{44.3,61.74},{44.33,60.58},{43.33,61.92},{43.86,59.96},{43.95,60.23},{43.88,57.37},{44.08,57.06},{46.19,58.39},{43.87,57.97},{45.36,58.06},{45.63,57.74}}},nil,141,nil,nil,82,nil,nil,0},
[2011] = {'Gnarlpine Augur',148,166,8,9,0,{[141]={{41.75,72.5},{41.37,73.88},{41.3,72.33},{41.31,72.68},{40.82,72.79},{56.3,75.29},{56.43,75.61},{56.56,75.5},{47.47,77.89},{46.22,58.38},{41.47,73.18},{45.03,61.3},{44.61,61.34},{44.94,61.48},{44.47,62.33},{44.53,62.71},{44.84,58.68},{44.88,58.64},{45.78,57.11},{45.86,57.02},{46.06,58.33},{46.22,58.19},{45.17,57.68},{44.68,59.0},{45.64,58.38}}},nil,141,nil,nil,82,nil,nil,0},
[2012] = {'Gnarlpine Pathfinder',166,186,9,10,0,{[141]={{42.13,79.99},{42.4,79.89},{42.4,79.15},{38.79,78.39},{38.15,81.3},{38.16,80.38},{41.96,79.7},{42.01,80.16},{41.85,80.05},{38.62,80.25},{39.87,80.34},{40.27,80.1},{38.58,80.07},{41.36,77.94}}},nil,141,nil,nil,82,nil,nil,0},
[2013] = {'Gnarlpine Avenger',176,198,9,10,0,{[141]={{43.31,78.98},{38.7,79.52},{38.79,79.04},{41.28,79.03},{41.3,77.01},{41.51,79.44},{40.62,79.59},{40.63,79.1},{40.26,79.36},{40.05,79.68},{39.97,79.84}}},nil,141,nil,nil,82,nil,nil,0},
[2014] = {'Gnarlpine Totemic',186,208,10,11,0,{[141]={{37.87,81.19},{38.4,80.78},{38.77,78.91},{39.37,80.2},{39.06,79.87}}},nil,141,nil,nil,82,nil,nil,0},
[2015] = {'Bloodfeather Harpy',156,176,8,9,0,{[141]={{37.87,43.67},{37.73,41.07},{37.21,42.97},{37.48,41.25},{38.56,40.54},{35.95,38.85},{36.75,38.86},{34.35,35.14},{37.32,43.68},{34.07,35.45},{35.03,34.9}}},nil,141,nil,nil,514,nil,nil,0},
[2017] = {'Bloodfeather Rogue',156,176,8,9,0,{[141]={{37.31,43.32},{37.8,44.69},{37.2,40.44},{36.57,41.75},{37.32,37.79},{35.99,37.82},{35.59,38.55},{35.47,36.98},{36.41,39.9},{35.44,37.75},{34.42,35.53},{35.18,35.08},{34.75,35.02},{34.33,34.08},{33.77,35.41},{35.47,34.95},{34.19,34.76},{37.34,41.67},{36.43,38.1},{36.75,37.67}}},nil,141,nil,nil,514,nil,nil,0},
[2018] = {'Bloodfeather Sorceress',160,160,9,9,0,{[141]={{37.88,43.01},{35.75,37.28},{34.37,34.42},{38.73,42.86},{35.23,38.9}}},nil,141,nil,nil,514,nil,nil,0},
[2019] = {'Bloodfeather Fury',176,198,9,10,0,{[141]={{32.67,29.58},{36.4,25.87},{33.37,29.33},{34.77,27.02},{34.31,28.34}}},nil,141,nil,nil,514,nil,nil,0},
[2020] = {'Bloodfeather Wind Witch',176,198,9,10,0,{[141]={{33.51,29.87},{33.11,30.01},{34.05,27.66},{37.31,28.03},{36.39,27.28},{36.75,27.9},{31.77,32.3},{33.1,29.25},{34.28,28.0},{32.58,32.61}}},nil,141,nil,nil,514,nil,nil,0},
[2021] = {'Bloodfeather Matriarch',208,208,11,11,0,{[141]={{32.82,30.49},{32.19,32.9},{32.86,29.99},{32.72,31.97},{31.44,31.59},{32.89,28.8},{36.24,28.3},{35.23,26.29},{34.18,27.25},{34.57,28.07},{34.14,29.86},{34.26,28.86},{32.21,32.37}}},nil,141,nil,nil,514,nil,nil,0},
[2022] = {'Timberling',102,120,5,6,0,{[141]={{60.02,72.16},{60.7,71.31},{60.08,70.0},{59.55,72.21},{61.53,69.35},{60.95,70.26},{62.21,68.64},{58.93,72.22},{59.67,64.32},{60.27,66.39},{60.16,65.29},{58.45,64.29},{60.77,65.94},{57.61,66.02},{61.04,65.26},{61.36,67.23},{61.76,66.06},{57.62,65.12},{56.77,65.54},{60.06,64.47},{55.52,68.13},{57.03,64.67},{55.87,67.18},{55.25,66.48},{54.95,67.16},{54.26,66.18},{57.21,64.18}}},nil,141,nil,nil,14,nil,nil,0},
[2025] = {'Timberling Bark Ripper',137,156,7,8,0,{[141]={{54.47,69.84},{52.39,74.32},{52.51,69.26},{50.1,72.08},{52.61,72.23},{53.44,70.69},{51.17,73.56},{51.6,70.06},{52.53,73.41},{52.94,68.38},{48.71,72.52},{47.69,72.58}}},nil,141,nil,nil,14,nil,nil,0},
[2027] = {'Timberling Trampler',156,176,8,9,0,{[141]={{41.77,37.85},{42.48,38.68},{42.47,42.71},{53.71,75.32},{53.17,74.65},{41.85,41.79},{43.91,42.69},{43.76,40.71},{42.45,40.71},{43.91,39.19},{52.97,74.14},{52.84,74.66}}},nil,141,nil,nil,14,nil,nil,0},
[2029] = {'Timberling Mire Beast',176,198,9,10,0,{[141]={{41.87,33.92},{43.87,34.89},{42.48,36.78},{42.97,33.65},{43.19,30.12},{42.49,32.96},{43.39,35.83},{43.17,31.91},{42.49,34.52}}},nil,141,nil,nil,14,nil,nil,0},
[2030] = {'Elder Timberling',186,208,10,11,0,{[141]={{45.02,26.56},{43.87,26.99},{44.49,26.01},{44.43,27.86},{42.53,28.86},{43.19,26.01},{43.89,25.94},{43.21,27.89},{43.86,28.94}}},nil,141,nil,nil,14,nil,nil,0},
[2031] = {'Young Nightsaber',42,42,1,1,0,{[141]={{63.35,42.14},{64.37,40.47},{61.48,39.3},{64.32,42.03},{61.99,42.93},{62.64,42.31},{58.39,46.73},{56.62,44.52},{62.02,42.89},{61.58,44.19},{61.61,40.94},{62.56,41.7},{62.18,45.44},{62.3,44.3},{61.97,42.82},{58.81,45.95},{58.43,45.56},{60.3,45.99},{60.61,45.03},{61.09,45.13},{61.38,44.51},{57.86,38.95},{61.86,44.22},{57.87,44.69},{61.48,41.62}}},nil,141,nil,nil,7,"AH",nil,0},
[2032] = {'Mangy Nightsaber',55,55,2,2,0,{[141]={{60.0,36.04},{63.44,38.79},{62.36,39.03},{62.3,37.99},{62.16,39.01},{62.04,36.87},{62.73,37.86},{62.38,37.04},{63.01,37.01},{61.25,39.08},{59.52,35.79},{58.93,35.87},{59.18,31.46},{59.84,34.21},{60.69,35.54},{60.98,34.68},{62.56,34.43},{61.73,35.17},{62.86,36.47},{60.55,34.34},{60.31,36.12},{60.82,35.68},{62.47,38.25}}},nil,141,nil,nil,7,"AH",nil,0},
[2033] = {'Elder Nightsaber',156,176,8,9,0,{[141]={{45.16,42.64},{39.79,44.49},{45.72,40.97},{45.13,36.66},{39.65,35.41},{45.8,37.85},{35.29,29.79},{45.8,33.76},{44.57,37.67},{35.87,29.2},{46.34,44.53},{39.51,35.16},{46.9,45.56},{34.72,30.96},{46.02,40.95}}},nil,141,nil,nil,66,nil,nil,0},
[2034] = {'Feral Nightsaber',198,222,10,11,0,{[141]={{40.65,27.37},{38.03,29.32},{41.34,25.13},{39.91,28.69},{38.34,26.77},{37.37,24.78}}},nil,141,nil,nil,66,nil,nil,0},
[2038] = {'Lord Melenas',148,148,8,8,0,{[141]={{51.23,50.8},{51.31,50.19},{52.82,50.21}}},nil,141,nil,nil,90,nil,nil,0},
[2039] = {'Ursal the Mauler',247,247,12,12,0,{[141]={{38.83,79.81}}},{[141]={{{38.82,79.69},{38.8,79.58},{38.79,79.48},{38.81,79.56},{38.85,79.8},{38.92,79.91},{39.11,80.03},{39.24,80.1},{39.24,80.14},{39.04,80.18},{38.92,80.32},{38.77,80.45},{38.71,80.32},{38.76,80.2},{38.85,79.89}}}},141,nil,nil,82,nil,nil,0},
[2040] = {'Haggatha the Crone',219,219,12,12,0,nil,nil,0,nil,nil,514,nil,nil,0},
[2041] = {'Ancient Protector',6104,6104,60,60,0,{[141]={{57.24,57.41},{36.83,55.27}},[1657]={{84.66,40.4}}},{[141]={{{57.16,57.31},{56.9,57.42},{56.74,57.53},{56.52,57.73},{56.3,57.96},{56.08,58.18},{55.75,58.38},{55.41,58.48},{55.14,58.51},{54.88,58.52},{54.66,58.5},{54.4,58.42},{54.15,58.3},{54.25,58.34},{54.51,58.44},{54.81,58.89},{54.9,59.17},{54.96,59.55},{54.98,59.81},{55.0,59.93},{55.13,60.26},{55.47,60.66},{55.83,61.04},{56.13,61.3},{56.37,61.48},{56.53,61.56},{56.73,61.43},{56.88,61.1},{57.03,60.63},{57.08,60.11},{57.09,59.59},{57.05,59.07},{57.06,58.68},{57.12,58.44},{57.19,58.22},{57.28,57.74},{57.37,57.57},{57.72,57.54},{58.25,57.6},{57.97,57.53},{57.8,57.47},{57.46,57.31},{57.29,57.29}}},[1657]={{{84.66,40.4},{84.31,36.17},{81.8,38.88},{80.64,38.81},{78.96,38.58},{77.27,38.68},{73.96,38.23},{73.73,41.96},{76.7,42.23},{78.82,42.15},{81.32,42.76}}}},141,nil,nil,80,"A",nil,268435456},
[2042] = {'Nightsaber',102,120,5,6,0,{[141]={{67.25,51.25},{66.2,51.18},{65.6,53.46},{49.73,52.44},{68.76,55.38},{64.14,56.04},{48.49,49.96},{49.71,55.3},{51.5,62.28},{50.83,57.26},{51.49,60.22},{48.69,50.41},{49.32,51.11},{52.86,58.53},{50.97,59.17},{54.27,63.29},{52.8,62.3},{54.8,65.15},{50.96,61.37},{62.79,61.04},{66.97,54.31},{68.0,53.98},{61.53,59.02},{62.16,61.69},{62.11,60.1},{59.55,62.99},{59.37,61.72},{53.63,55.61},{49.84,55.82},{62.77,60.29},{50.98,57.43},{52.95,62.61},{50.87,61.49},{51.66,59.27},{53.68,63.21},{51.77,62.32},{51.64,60.23},{58.69,58.28},{59.61,63.33},{59.54,61.4},{57.64,54.67}}},nil,141,nil,nil,66,nil,nil,0},
[2043] = {'Nightsaber Stalker',137,156,7,8,0,{[141]={{38.89,58.14},{63.42,72.17},{46.59,71.34},{62.19,72.1},{63.53,71.26},{53.9,72.51},{50.94,77.15},{56.93,73.92},{38.24,58.56},{44.96,74.6},{43.15,74.32},{40.44,69.86},{61.46,73.32},{47.09,70.9},{40.42,69.13},{39.89,69.3},{62.57,72.75},{50.63,79.0},{45.81,75.68},{55.79,72.27},{50.31,76.14},{50.0,79.15},{46.97,75.11},{38.49,56.22},{49.71,77.11},{40.13,55.84},{45.19,72.09},{41.17,70.15},{40.79,57.03},{40.5,55.57},{40.66,59.46},{63.42,70.18}}},nil,141,nil,nil,66,nil,nil,0},
[2044] = {'Forlorn Spirit',590,627,25,26,0,nil,nil,0,nil,nil,77,nil,nil,0},
[2045] = {'Gunther\'s Minion',137,156,7,8,0,nil,nil,0,nil,nil,78,nil,nil,0},
[2046] = {'Andrew Krighton',156,156,8,8,0,{[12]={{41.7,65.86}}},{[12]={{{41.7,65.86},{41.67,65.87},{41.67,65.87}}}},12,nil,nil,12,"A","Armorer & Shieldcrafter",16388},
[2050] = {'Raleigh Andrean',300,300,14,14,0,{[1497]={{62.01,42.75}}},nil,1497,{530},{441,530},68,"H","Ex-Chef",2},
[2051] = {'Twain The Tester FOO',3644,3644,56,56,0,nil,nil,0,nil,nil,21,nil,"Model and Texture",0},
[2052] = {'Nag',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2053] = {'Haggard Refugee',417,449,18,19,0,{[130]={{44.4,84.48},{44.33,84.41},{46.08,85.63},{45.54,85.99},{45.63,86.03},{46.39,86.63},{47.18,86.32},{46.32,86.49},{45.3,84.76},{46.81,85.59},{47.63,86.09},{46.75,85.7},{46.52,85.49},{45.94,84.05}}},nil,130,nil,nil,123,"A",nil,0},
[2054] = {'Sickly Refugee',404,433,19,20,0,{[130]={{44.45,84.36},{44.2,83.52},{45.57,86.14},{45.58,86.06},{46.37,86.54},{46.35,85.96},{44.98,82.79},{47.12,86.31},{46.47,85.57},{45.24,84.75},{46.73,85.59},{45.96,85.77},{46.93,85.21}}},nil,130,nil,nil,123,"A",nil,0},
[2055] = {'Master Apothecary Faranell',2215,2215,50,50,0,{[1497]={{48.82,69.28}}},nil,1497,{450,515,1109,1113},{447,451,513,1109,1113,2938},68,"H","Royal Apothecary Society",2},
[2056] = {'Ravenclaw Apparition',664,664,24,24,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2057] = {'Huldar',328,328,15,15,0,{[38]={{52.19,69.32}}},nil,38,{454},{273},57,"A",nil,3},
[2058] = {'Deathstalker Faerleia',1251,1251,18,18,0,{[130]={{46.5,74.39}}},nil,130,{452},{452},68,"H",nil,2},
[2060] = {'Councilman Smithers',741,741,12,12,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2061] = {'Councilman Thatcher',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2062] = {'Councilman Hendricks',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2063] = {'Councilman Wilhelm',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2064] = {'Councilman Hartin',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2065] = {'Councilman Cooper',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2066] = {'Councilman Higarth',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2067] = {'Councilman Brunswick',819,819,13,13,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council",0},
[2068] = {'Lord Mayor Morrison',984,984,15,15,1,nil,nil,0,nil,nil,16,nil,"Pyrewood Council Leader",0},
[2069] = {'Moonstalker',300,328,14,15,0,{[148]={{55.12,21.43},{55.42,20.85},{55.51,21.55},{54.67,21.93},{44.35,67.39},{43.59,69.93},{44.55,68.7},{40.15,67.45},{42.66,72.09},{40.58,70.03},{40.02,69.35},{39.02,72.43},{39.7,69.32},{39.93,70.62},{52.74,29.42},{43.53,67.77},{37.47,63.38},{41.0,67.37},{39.19,69.23},{40.04,65.98},{37.47,78.99},{39.44,67.76},{44.64,24.76},{38.98,66.76},{38.6,64.52},{41.87,67.67},{37.97,59.74},{43.14,67.5},{44.08,66.05},{55.5,23.29},{50.55,27.04},{38.05,77.46},{39.02,70.64},{48.98,27.75},{49.36,26.65},{41.77,71.48},{39.38,63.84},{37.54,77.25},{42.36,64.22},{53.26,27.2},{53.79,27.85},{54.94,30.1},{50.78,28.56},{43.81,65.65},{48.87,25.47},{42.2,67.37},{38.55,77.51},{49.2,32.46},{51.74,25.63}}},nil,148,nil,nil,14,nil,nil,0},
[2070] = {'Moonstalker Runt',356,386,16,17,0,{[148]={{47.21,40.85},{61.04,13.04},{47.25,44.52},{44.13,43.82},{44.82,42.65},{43.57,28.95},{45.17,28.01},{42.9,90.32},{39.41,39.07},{41.0,43.04},{37.47,92.99},{47.92,40.12},{44.31,27.66},{44.75,41.21},{48.66,24.26},{40.49,41.22},{46.5,54.2},{48.26,38.8},{40.26,41.08},{46.41,52.43},{42.64,43.19},{39.62,33.44},{42.01,48.18},{46.38,42.13},{43.96,55.73},{45.25,58.79},{40.07,33.21},{35.17,89.68},{44.59,55.68},{45.02,57.24},{42.04,54.49},{39.73,40.42},{39.4,39.69},{40.08,50.06},{45.26,57.61},{44.53,58.19},{42.99,26.12},{46.17,23.72},{42.66,25.9},{39.18,34.29},{43.15,54.65},{39.58,37.76},{44.66,24.31},{45.49,33.28},{39.76,91.77},{39.55,90.54},{42.06,45.27},{45.1,24.77},{45.69,31.72},{44.86,29.28},{46.26,23.99},{45.16,56.13},{38.77,50.73},{38.06,36.86},{43.55,24.25},{38.87,48.78},{38.04,50.06},{61.0,11.86},{59.61,11.75},{62.61,6.99}}},nil,148,nil,nil,14,nil,nil,0},
[2071] = {'Moonstalker Matriarch',449,484,19,20,0,{[148]={{60.92,13.41},{43.03,90.77},{37.21,93.4},{34.99,88.84},{36.47,90.45},{36.89,89.68},{39.41,91.8},{39.85,90.34},{59.9,11.78},{60.96,11.87},{62.92,7.31},{62.5,6.67}}},nil,148,nil,nil,14,nil,nil,0},
[2077] = {'Melithar Staghelm',102,102,5,5,0,{[141]={{59.92,42.47}}},nil,141,{458},nil,80,"A",nil,2},
[2078] = {'Athridas Bearmantle',222,222,11,11,0,{[141]={{55.96,57.27}}},nil,141,{475,483,486},{476,483,486},80,"A",nil,2},
[2079] = {'Conservator Ilthalaine',86,86,4,4,0,{[141]={{58.69,44.27}}},nil,141,{456,457,3116,3117,3118,3119,3120},{456,457},80,"A",nil,3},
[2080] = {'Denalan',222,222,11,11,0,{[141]={{60.9,68.49}}},nil,141,{918,919,922,941,2499},{918,919,927,930,931,997,2498,2499},80,"A",nil,2},
[2081] = {'Sentinel Kyra Starsong',247,247,12,12,0,{[141]={{56.0,59.52}}},nil,141,nil,nil,80,"A",nil,2},
[2082] = {'Gilshalan Windwalker',176,176,9,9,0,{[141]={{57.81,41.65}}},nil,141,{916,917,920},{916,917},80,"A",nil,2},
[2083] = {'Syral Bladeleaf',247,247,12,12,0,{[141]={{56.08,57.72}}},nil,141,{489,997,1581},{1581},80,"A",nil,2},
[2084] = {'Natheril Raincaller',3758,3758,57,57,0,{[618]={{51.45,30.83}}},nil,618,nil,nil,80,"A","General Goods",6},
[2086] = {'Valstag Ironjaw',712,712,25,25,0,{[11]={{10.1,56.9}}},nil,11,{473},{455},55,"A",nil,2},
[2089] = {'Giant Wetlands Crocolisk',734,787,25,26,0,{[11]={{18.37,27.04},{17.61,29.11},{19.22,22.95},{22.42,20.87},{21.73,20.02},{19.03,24.79},{16.98,26.86},{16.19,26.23},{17.49,23.54},{15.25,29.22},{26.13,22.57},{20.58,24.17},{27.01,19.36}}},nil,11,nil,nil,14,nil,nil,0},
[2090] = {'Ma\'ruk Wyrmscale',617,617,23,23,4,{[11]={{48.06,74.7}}},nil,11,nil,nil,62,nil,"Dragonmaw Warlord",0},
[2091] = {'Chieftain Nek\'rosh',3171,3171,32,32,1,{[11]={{53.51,54.67}}},nil,11,nil,nil,62,nil,nil,0},
[2092] = {'Pilot Longbeard',617,617,23,23,0,{[1537]={{72.73,94.01}}},nil,1537,{1179},{708},55,"A","Ironforge Siege Brigade",2},
[2093] = {'Einar Stonegrip',484,484,20,20,0,{[11]={{49.92,39.37}}},nil,11,{469},nil,55,"A",nil,2},
[2094] = {'James Halloran',712,712,25,25,0,{[11]={{8.55,55.74}}},nil,11,{471,484},{469,471,484},12,"A",nil,2},
[2095] = {'Billy the Street Urchin',42,42,1,1,0,nil,nil,0,nil,nil,12,"A","Don't trust me! I'm named Billy!",0},
[2096] = {'Tarrel Rockweaver',712,712,25,25,0,{[11]={{11.5,52.17}}},nil,11,{305},{306},55,"A",nil,2},
[2097] = {'Harlo Barnaby',712,712,25,25,0,{[11]={{10.85,55.9}}},nil,11,{472},nil,55,"A",nil,2},
[2098] = {'Ram',102,102,5,5,0,{[11]={{16.28,71.97},{16.06,72.38},{50.3,73.2},{52.42,68.67},{48.28,65.63},{50.61,74.84},{49.01,72.35},{56.39,84.19},{49.97,68.03},{48.28,70.72},{47.86,67.69},{16.19,72.45}},[38]={{52.57,71.9},{31.78,15.93},{27.25,12.18},{30.26,12.36},{38.36,32.48},{28.63,57.76},{58.94,63.8}},[36]={{72.35,42.96},{67.66,42.7},{48.03,29.26},{40.08,35.01},{66.43,53.66},{36.82,44.73},{61.94,29.09}},[45]={{91.35,70.01},{91.01,70.2}}},nil,11,nil,nil,190,"AH",nil,0},
[2099] = {'Maiden\'s Virtue Crewman',484,484,20,20,0,{[11]={{4.89,57.44},{5.57,64.08},{9.78,61.33},{8.25,61.76},{10.23,62.06},{5.76,64.12},{8.42,61.49},{5.05,62.45},{5.57,63.73},{8.74,59.4},{7.49,57.43},{6.56,63.28},{5.84,58.34}}},nil,11,nil,nil,57,"A",nil,2},
[2102] = {'Dragonmaw Grunt',494,531,20,21,0,{[11]={{48.52,65.97},{47.61,66.49},{49.27,82.64},{48.06,75.52},{47.17,77.07},{49.99,77.01},{48.72,77.26},{51.5,78.47},{47.81,74.71},{47.84,74.35},{49.16,80.12},{48.21,75.77},{47.61,75.58},{47.42,75.74},{47.47,75.12},{47.25,76.05},{49.86,69.58}}},nil,11,nil,nil,62,nil,nil,0},
[2103] = {'Dragonmaw Scout',449,484,19,20,0,{[11]={{49.93,76.12},{50.7,76.92},{51.2,79.52},{49.3,76.95},{47.47,76.46},{47.67,76.82},{48.23,74.72},{48.19,74.03},{47.77,74.24},{50.08,79.55},{49.64,79.02},{48.92,78.94},{48.24,78.24},{49.34,79.75},{47.89,77.19},{47.96,76.24},{47.88,75.88}}},nil,11,nil,nil,62,nil,nil,0},
[2104] = {'Captain Stoutfist',1342,1342,35,35,0,{[11]={{9.86,57.49}}},nil,11,{464,465},{464,473,474},55,"A",nil,2},
[2105] = {'Mountaineer Dokkin',1910,1910,30,30,0,{[38]={{25.28,0.17}}},{[38]={{{25.29,0.12},{25.3,0.61},{25.32,1.32},{25.35,2.33},{25.37,3.33},{25.39,4.16},{25.43,5.13},{25.46,6.13},{25.48,7.08},{25.5,8.01},{25.53,8.91},{25.55,9.64},{25.56,10.2},{25.55,9.61},{25.53,8.97},{25.51,8.11},{25.48,7.14},{25.45,6.11},{25.42,5.17},{25.4,4.26},{25.37,3.21},{25.34,2.23},{25.32,1.28}}}},38,nil,nil,57,"A",nil,2},
[2106] = {'Apothecary Berard',1068,1068,16,16,1,{[130]={{42.89,73.36}}},nil,130,nil,nil,14,nil,nil,0},
[2107] = {'Gaerolas Talvethren',137,137,7,7,0,{[141]={{66.26,58.52}}},nil,141,{476},{475},80,"A",nil,2},
[2108] = {'Garneg Charskull',812,812,29,29,4,{[11]={{38.42,46.06}}},nil,11,nil,nil,62,nil,nil,0},
[2109] = {'Steam Tank',1163,1163,32,32,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2110] = {'Black Rat',1,1,1,1,0,{[10]={{24.46,59.89},{58.81,69.22},{57.22,78.87},{66.57,54.77},{21.81,54.42},{15.41,63.73},{73.99,30.91},{75.56,57.84},{65.07,59.18},{77.27,54.03},{70.16,61.14},{73.69,54.32},{19.35,60.46},{68.66,52.29},{43.79,71.82},{51.17,67.34},{36.05,64.97},{41.62,64.37},{41.67,64.34},{43.97,71.98},{71.69,37.61},{30.66,61.32}},[28]={{45.73,69.62},{42.08,61.15},{37.69,55.68},{63.89,58.34},{50.0,75.47},{49.4,66.74},{49.7,78.2},{53.78,44.76},{43.7,66.35},{46.19,53.32},{52.71,78.63},{61.68,58.45},{47.54,64.33},{47.28,69.82},{49.76,45.46},{38.24,72.13},{53.24,66.57},{41.12,70.54},{41.21,72.8},{49.84,45.63}},[2057]={{-1,-1}},[1583]={{-1,-1}},[722]={{-1,-1}},[11]={{16.43,71.22},{20.26,68.95}},[209]={{-1,-1}}},nil,10,nil,nil,31,"AH",nil,0},
[2111] = {'Sida',484,484,20,20,0,{[11]={{11.8,57.99}}},nil,11,{470},{470},55,"A",nil,2},
[2112] = {'Farrin Daris',417,417,18,18,0,{[10]={{73.63,43.46}}},{[10]={{{73.69,44.34},{73.63,43.46},{73.69,44.34},{73.63,43.46}}}},10,nil,nil,12,"A",nil,0},
[2113] = {'Archibald Kava',102,102,5,5,0,{[85]={{32.41,65.66}}},nil,85,nil,nil,68,"H","Cloth & Leather Armor Merchant",16388},
[2114] = {'Faruza',102,102,5,5,0,{[85]={{59.79,52.12}}},nil,85,nil,nil,68,"H","Apprentice Herbalist",19},
[2115] = {'Joshua Kien',102,102,5,5,0,{[85]={{32.29,65.44}}},nil,85,nil,nil,68,"H","General Supplies",6},
[2116] = {'Blacksmith Rand',102,102,5,5,0,{[85]={{32.38,66.23}}},nil,85,nil,nil,68,"H","Apprentice Armorer",16388},
[2117] = {'Harold Raims',102,102,5,5,0,{[85]={{32.4,66.43}}},nil,85,nil,nil,68,"H","Apprentice Weaponsmith",16388},
[2118] = {'Abigail Shiel',176,176,9,9,0,{[85]={{61.03,52.37}}},nil,85,nil,nil,68,"H","Trade Supplies",6},
[2119] = {'Dannal Stern',102,102,5,5,0,{[85]={{32.69,65.56}}},nil,85,nil,{3095},68,"H","Warrior Trainer",19},
[2120] = {'Archmage Ataeric',472,472,22,22,0,{[130]={{63.4,64.27}}},nil,130,nil,nil,76,"AH",nil,0},
[2121] = {'Shadow Priest Allister',484,484,20,20,0,{[130]={{43.98,40.93}}},nil,130,{477,479,480,481,516},{478,479,480,482,516},68,"H",nil,2},
[2122] = {'David Trias',102,102,5,5,0,{[85]={{32.53,65.65}}},nil,85,nil,{3096},68,"H","Rogue Trainer",19},
[2123] = {'Dark Cleric Duesten',102,102,5,5,0,{[85]={{31.11,66.03}}},nil,85,{5651},{3097},68,"H","Priest Trainer",19},
[2124] = {'Isabella',102,102,5,5,0,{[85]={{30.93,66.06}}},nil,85,nil,{3098},68,"H","Mage Trainer",19},
[2126] = {'Maximillion',102,102,5,5,0,{[85]={{30.91,66.34}}},nil,85,nil,{3099},68,"H","Warlock Trainer",19},
[2127] = {'Rupert Boch',328,328,15,15,0,{[85]={{61.59,52.4}}},nil,85,nil,nil,68,"H","Warlock Trainer",19},
[2128] = {'Cain Firesong',300,300,14,14,0,{[85]={{61.97,52.47}}},nil,85,{1881},nil,68,"H","Mage Trainer",19},
[2129] = {'Dark Cleric Beryl',386,386,17,17,0,{[85]={{61.57,52.19}}},nil,85,{5650,5663},{5650,5651},68,"H","Priest Trainer",19},
[2130] = {'Marion Call',273,273,13,13,0,{[85]={{61.75,52.0}}},nil,85,{1885},nil,68,"H","Rogue Trainer",19},
[2131] = {'Austil de Mon',356,356,16,16,0,{[85]={{61.85,52.54}}},nil,85,{1818},nil,68,"H","Warrior Trainer",19},
[2132] = {'Carolai Anise',712,712,25,25,0,{[85]={{59.43,52.19}}},nil,85,nil,nil,68,"H","Journeyman Alchemist",19},
[2134] = {'Mrs. Winters',198,198,10,10,0,{[85]={{61.16,52.59}}},nil,85,nil,nil,68,"H","General Supplies",6},
[2135] = {'Abe Winters',247,247,12,12,0,{[85]={{60.22,53.1}}},nil,85,nil,nil,68,"H","Apprentice Armorer",16388},
[2136] = {'Oliver Dwor',273,273,13,13,0,{[85]={{60.12,53.39}}},nil,85,nil,nil,68,"H","Apprentice Weaponsmith",16388},
[2137] = {'Eliza Callen',247,247,12,12,0,{[85]={{60.31,52.82}}},nil,85,nil,nil,68,"H","Leather Armor Merchant",16388},
[2138] = {'Warrior 25',713,713,25,25,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2140] = {'Edwin Harly',449,449,19,19,0,{[130]={{43.98,39.9}}},nil,130,nil,nil,68,"H","General Supplies",6},
[2142] = {'Watcher Callahan',1162,1162,32,32,0,{[10]={{81.92,19.69}}},nil,10,nil,nil,12,"A","The Night Watch",2},
[2149] = {'Dark Iron Raider',300,300,14,14,0,nil,nil,0,nil,nil,54,nil,nil,0},
[2150] = {'Zenn Foulhoof',137,137,7,7,0,{[141]={{60.46,56.3}}},nil,141,{488},{488,489},80,"A",nil,2},
[2151] = {'Moon Priestess Amara',712,712,25,25,0,{[141]={{54.63,58.46}}},nil,141,{487},{487},79,"A",nil,2},
[2152] = {'Gnarlpine Ambusher',120,137,6,7,0,{[141]={{46.15,51.14},{46.3,52.16},{45.9,52.46},{45.86,54.52},{47.86,53.26},{45.21,54.63},{45.51,52.91},{46.7,52.47},{46.33,52.75},{45.75,53.59},{48.46,54.1},{46.27,54.22},{48.29,53.55},{46.47,53.42},{46.8,54.39}}},nil,141,nil,nil,82,nil,nil,0},
[2153] = {'Terl Arakor',712,712,25,25,0,{[11]={{27.43,41.2}}},nil,11,nil,nil,123,"A",nil,3},
[2154] = {'Jesse The Tester',3644,3644,56,56,0,nil,nil,0,nil,nil,21,nil,"Model and Texture",0},
[2155] = {'Sentinel Shayla Nightbreeze',156,156,8,8,0,{[141]={{42.22,51.27}}},{[141]={{{42.29,51.38},{42.1,51.33},{41.81,51.17},{41.43,50.96},{41.0,50.8},{40.55,50.76},{40.15,50.85},{39.85,51.24},{39.58,51.67},{39.39,52.24},{39.19,52.82},{38.96,53.3},{38.6,53.94},{38.18,54.42},{37.84,54.51},{37.33,54.45},{36.77,54.47},{36.49,54.5},{36.48,54.41},{36.93,54.38},{37.46,54.4},{37.9,54.43},{38.36,54.24},{38.73,53.67},{39.08,53.12},{39.32,52.4},{39.43,51.93},{39.66,51.46},{39.95,51.05},{40.17,50.77},{40.44,50.74},{40.84,50.75},{41.32,50.89},{41.73,51.1},{42.02,51.26}}}},141,nil,nil,80,"A",nil,2},
[2156] = {'Cracked Golem',354,382,18,19,0,{[148]={{35.99,85.97},{36.0,85.5},{35.09,84.93},{35.57,84.08},{35.34,84.5},{35.68,85.67}}},nil,148,nil,nil,14,nil,nil,0},
[2157] = {'Stone Behemoth',382,411,19,20,0,{[148]={{36.18,86.39},{36.23,85.9},{35.49,85.03}}},{[148]={{{36.25,85.92},{36.23,86.09},{36.13,86.22},{36.02,86.19},{36.02,86.19},{35.89,85.93},{35.68,85.5},{35.68,85.5},{35.82,85.75},{36.04,86.17},{36.15,86.23},{36.21,86.09},{36.22,85.9},{36.2,85.64},{36.23,85.71}}}},148,nil,nil,14,nil,nil,0},
[2158] = {'Gravelflint Scout',417,449,18,19,0,nil,nil,0,nil,nil,59,nil,nil,0},
[2159] = {'Gravelflint Bonesnapper',449,484,19,20,0,nil,nil,0,nil,nil,22,nil,nil,0},
[2160] = {'Gravelflint Geomancer',441,441,21,21,0,nil,nil,0,nil,nil,22,nil,nil,0},
[2162] = {'Agal',155,155,8,8,0,{[141]={{46.26,51.02}}},nil,141,nil,nil,82,nil,nil,0},
[2163] = {'Thistle Bear',278,309,11,12,0,{[148]={{44.44,31.62},{44.85,27.16},{45.84,41.74},{43.19,44.2},{45.07,32.29},{45.68,28.86},{44.08,29.03},{47.26,23.73},{44.6,43.21},{44.55,33.37},{42.56,55.8},{47.64,23.77},{41.09,34.13},{45.68,41.52},{45.68,55.29},{48.68,22.19},{43.2,56.42},{40.16,36.5},{40.2,36.84},{41.56,33.88},{39.91,39.49},{38.4,38.59},{40.5,38.41},{38.65,38.26},{43.68,29.42},{43.42,34.66},{40.35,40.32},{44.14,32.45},{49.04,38.33},{43.75,42.7},{41.61,34.8},{46.31,54.79},{45.58,43.55},{47.05,41.85},{43.18,42.62},{44.4,25.94},{45.06,43.77},{43.71,42.74},{43.52,41.89},{38.35,38.77},{41.12,41.88},{45.54,29.86},{43.75,32.36},{44.65,60.2},{45.98,26.56},{44.27,31.05},{43.37,33.37},{43.5,29.97},{45.82,22.97},{41.96,47.07},{42.93,24.93},{43.51,25.79},{42.64,47.9},{43.39,26.92},{44.58,29.85},{44.82,30.82},{45.93,26.4},{43.08,22.92},{45.64,23.85},{46.78,22.6},{45.18,23.64},{41.57,47.97},{43.47,22.59},{42.93,54.81},{38.03,48.63},{45.25,26.37},{44.95,33.93},{44.45,24.67},{39.16,37.16},{39.5,36.34},{40.48,38.02},{43.56,54.94},{45.58,26.0},{46.75,25.43},{40.37,35.0},{48.16,40.78},{47.96,23.44},{46.17,24.88},{41.64,56.94},{41.02,48.47},{38.09,47.02}}},nil,148,nil,nil,44,nil,nil,0},
[2164] = {'Rabid Thistle Bear',341,375,13,14,0,{[148]={{44.73,32.97},{44.99,66.82},{39.79,75.81},{51.23,35.52},{46.73,33.51},{48.44,35.61},{44.7,29.35},{43.74,25.43},{40.61,75.84},{48.6,35.21},{49.38,33.44},{45.53,31.14},{46.75,34.42},{38.08,67.73},{50.87,31.09},{44.64,63.0},{47.5,34.09},{47.69,24.52},{38.88,66.05},{38.51,68.24},{44.04,31.09},{38.66,72.84},{52.8,25.58},{46.56,24.93},{49.21,35.44},{52.84,27.68},{38.58,65.76},{51.18,34.45},{53.8,25.64},{38.98,61.5},{39.21,59.71},{40.09,58.31},{47.9,34.57},{50.07,30.98},{38.08,56.59},{38.27,61.66},{52.58,28.78},{50.82,30.16},{38.47,60.73},{39.58,61.81},{38.33,58.37},{37.69,73.97},{49.23,29.28},{39.05,76.7},{38.06,69.5},{53.36,28.97},{39.59,68.31},{38.16,70.61},{39.22,65.34},{40.52,76.43},{39.48,60.81},{39.48,59.49},{47.46,28.51},{43.01,22.76},{39.31,63.3},{50.37,27.82},{47.59,33.05},{48.43,33.43},{48.38,26.26},{47.14,31.22},{47.14,32.38},{45.94,24.41},{48.95,31.07},{38.54,79.01},{50.19,25.67},{44.38,23.57},{51.84,32.5},{37.61,73.19},{48.61,27.11},{38.72,58.88},{38.62,70.19},{45.14,26.48},{41.03,66.24},{44.1,70.56},{42.99,64.7},{37.85,72.3},{44.12,69.19},{42.41,68.3},{49.65,27.4},{39.54,71.01},{49.71,25.61},{42.33,65.5},{38.42,74.42},{47.25,28.2},{38.21,52.59},{38.41,74.97},{38.21,65.52},{48.37,30.96},{43.1,70.68},{38.37,71.79},{39.03,64.27},{40.49,71.05},{43.14,69.05},{38.55,57.72},{41.67,65.21},{41.41,63.24},{38.57,54.62},{54.38,29.47},{51.78,31.77},{42.11,66.07},{53.22,26.31}}},nil,148,nil,nil,44,nil,nil,0},
[2165] = {'Grizzled Thistle Bear',445,482,16,17,0,{[148]={{45.05,81.41},{40.29,75.88},{38.04,82.05},{37.54,82.03},{40.47,81.77},{40.08,79.78},{40.43,81.13},{38.61,82.44},{38.23,71.1},{39.07,69.96},{39.8,80.77},{39.72,82.05},{39.3,81.36},{39.14,76.33},{37.83,78.61},{38.6,80.49},{41.06,81.28},{37.67,79.82},{42.96,82.45}}},nil,148,nil,nil,44,nil,nil,0},
[2166] = {'Oakenscowl',528,528,9,9,1,{[141]={{53.76,75.12}}},nil,141,nil,nil,14,nil,nil,0},
[2167] = {'Blackwood Pathfinder',230,253,12,13,0,{[148]={{39.58,56.3},{40.23,56.31},{39.16,56.38},{39.34,52.24},{39.63,53.1},{39.89,56.37},{39.21,53.01},{39.33,53.67},{39.81,53.4},{39.08,53.41},{39.66,54.35},{39.84,53.94}}},nil,148,nil,nil,82,nil,nil,0},
[2168] = {'Blackwood Warrior',356,386,16,17,0,{[148]={{42.84,84.46},{42.52,86.36},{42.67,85.48},{50.8,34.5},{50.56,34.3},{50.36,34.56},{51.23,35.19},{51.11,34.54},{50.98,35.0},{39.89,79.11},{39.88,77.6},{40.21,78.85},{52.78,34.09},{52.43,34.21},{52.03,33.9},{53.08,33.49},{52.52,33.53},{52.12,33.1},{52.76,32.98},{51.78,33.25},{39.54,77.97},{39.36,78.51},{40.19,77.91},{39.71,78.76},{40.69,77.76},{52.37,32.71},{50.7,35.2}}},nil,148,nil,nil,82,nil,nil,0},
[2169] = {'Blackwood Totemic',350,377,17,18,0,{[148]={{42.54,85.56},{42.67,86.57},{45.05,89.09},{44.52,89.01},{44.88,88.42},{51.16,34.87},{52.51,33.1},{52.21,33.32},{52.81,33.62},{52.3,33.9},{51.93,33.57},{40.64,77.99},{39.72,78.4},{50.57,34.76}}},nil,148,nil,nil,82,nil,nil,0},
[2170] = {'Blackwood Ursa',377,404,18,19,0,{[148]={{42.39,86.41},{42.79,86.58},{44.82,87.39},{44.06,83.62},{44.3,84.09},{44.73,87.88},{44.6,86.98},{43.93,85.14},{43.65,84.53},{44.23,85.56},{44.24,84.86},{44.49,84.82}}},nil,148,nil,nil,82,nil,nil,0},
[2171] = {'Blackwood Shaman',404,433,19,20,0,{[148]={{44.82,87.08},{44.68,87.3},{42.68,86.15},{42.61,86.81},{43.98,84.8},{44.25,84.42}}},nil,148,nil,nil,82,nil,nil,0},
[2172] = {'Strider Clutchmother',484,484,20,20,4,{[148]={{34.82,87.31}}},{[148]={{{35.63,87.4},{36.19,87.35},{36.59,87.65},{36.9,88.15},{37.33,88.35},{37.48,88.65},{37.52,88.98},{37.6,89.73},{37.82,90.64},{38.18,91.18},{38.5,91.31},{38.74,91.46},{38.84,91.85},{38.74,92.37},{38.6,92.74},{38.32,92.91},{38.07,92.87},{37.55,92.38},{36.66,90.77},{36.29,89.98},{35.96,89.49},{35.65,89.38},{35.37,89.22},{35.14,88.81},{34.73,88.36},{34.31,87.79},{34.13,87.47},{34.16,87.14},{34.37,86.98},{34.83,87.32}}}},148,nil,nil,7,"AH",nil,0},
[2173] = {'Reef Frenzy',300,328,14,15,0,{[130]={{34.57,36.0},{38.87,75.65},{34.53,37.34},{34.88,36.15},{35.45,49.84},{34.15,47.78},{35.07,50.6},{37.08,82.63},{34.88,48.78},{37.42,76.72},{38.03,77.41},{34.17,23.52},{33.38,24.7},{34.84,29.83},{36.64,32.94},{34.84,44.8}}},nil,130,nil,nil,16,nil,nil,0},
[2174] = {'Coastal Frenzy',300,328,14,15,0,{[148]={{31.96,62.98},{33.02,70.46},{33.97,76.36},{34.99,73.72},{32.51,71.6},{39.57,21.76},{32.16,75.14},{31.43,70.6},{40.04,25.07},{31.98,61.35},{32.94,67.63},{41.01,18.89},{31.44,63.1},{35.07,67.84},{35.1,70.25},{31.83,64.43},{44.21,15.48},{33.53,69.25},{32.3,66.26},{41.11,24.77},{31.44,79.46},{37.35,25.4},{38.6,22.52},{46.14,15.61},{37.69,24.83},{41.56,16.89},{33.6,64.56},{32.96,63.9},{33.08,65.66},{33.05,61.04},{31.86,73.63},{42.84,15.6},{33.81,61.14},{31.28,72.54},{40.95,16.74},{34.12,73.58},{38.88,24.73},{38.85,20.25},{45.17,15.66},{31.94,76.24},{44.27,17.03},{30.91,64.55},{40.59,19.66},{34.58,65.61},{39.45,23.88},{42.07,18.72}}},nil,148,nil,nil,16,nil,nil,0},
[2175] = {'Shadowclaw',205,205,13,13,4,{[148]={{40.29,40.52}}},nil,148,nil,nil,14,nil,nil,0},
[2176] = {'Cursed Highborne',198,222,10,11,0,{[148]={{41.68,59.19},{41.62,59.63},{43.22,57.6},{41.48,58.64},{41.69,57.76},{42.05,58.42},{42.23,57.86},{42.54,57.35},{41.91,57.32},{42.71,57.76},{43.17,58.43},{43.69,58.23},{43.72,59.02}}},nil,148,nil,nil,14,nil,nil,0},
[2177] = {'Writhing Highborne',222,247,11,12,0,{[148]={{42.59,58.82},{42.22,59.28},{41.78,60.25},{42.46,63.44},{42.79,63.44},{43.38,61.98},{43.28,63.37},{43.61,62.74},{42.31,62.86},{42.78,62.79},{41.69,62.06},{41.94,62.53},{41.29,61.71},{41.7,60.84},{41.62,61.34},{42.96,58.92},{43.43,59.65},{42.56,58.42},{42.68,59.63},{41.08,62.83},{43.57,60.44}}},nil,148,nil,nil,14,nil,nil,0},
[2178] = {'Wailing Highborne',247,273,12,13,0,{[148]={{42.81,60.18},{44.03,61.4},{44.03,62.0},{42.39,60.62},{42.22,61.2},{42.71,60.93},{43.18,58.71},{43.74,59.98},{44.08,60.53},{43.32,60.91},{43.91,60.96},{42.17,61.98},{43.14,61.78},{42.7,61.7},{42.51,61.75}}},nil,148,nil,nil,14,nil,nil,0},
[2179] = {'Stormscale Wave Rider',328,356,15,16,0,{[148]={{56.25,34.61},{54.68,36.77},{55.57,35.83},{55.02,35.2},{55.5,34.75},{57.0,34.44},{56.65,33.71},{55.59,34.07},{55.2,35.0},{55.12,34.26},{55.32,35.37},{54.87,35.69},{55.42,36.61},{55.9,34.8},{55.02,33.46},{55.65,35.91},{54.99,32.94}}},nil,148,nil,nil,74,nil,nil,0},
[2180] = {'Stormscale Siren',325,350,16,17,0,{[148]={{55.23,34.84},{54.73,36.21},{54.98,37.0},{55.42,36.03},{55.23,35.67},{55.63,36.2},{56.51,35.01},{56.79,34.75},{56.49,34.18},{55.32,34.45},{56.58,34.79},{55.84,34.7},{57.01,33.91},{55.82,34.28},{55.72,35.23},{54.68,33.36},{55.02,34.65},{55.22,33.81}}},nil,148,nil,nil,74,nil,nil,0},
[2181] = {'Stormscale Myrmidon',417,449,18,19,0,{[148]={{58.99,24.79},{60.34,23.56},{60.61,23.01},{58.24,22.65},{59.76,16.47},{57.99,20.48},{58.21,18.77},{59.49,24.86},{59.33,23.56},{58.82,24.15},{59.36,21.67},{59.91,21.88},{58.93,20.9},{58.45,21.35},{58.64,19.61},{57.91,19.26},{57.67,21.33},{57.19,19.64},{57.33,20.88},{57.31,21.76},{60.12,15.43},{59.51,14.56},{60.68,16.81},{60.22,16.72},{60.4,15.59},{61.14,16.98},{56.85,22.46},{57.67,24.38},{57.35,22.76},{58.24,23.82},{58.5,23.58},{58.56,25.03},{58.07,24.59},{57.34,23.6},{58.0,17.89},{57.48,18.45},{58.89,15.85},{58.26,17.03},{58.96,16.95},{57.61,17.22}}},nil,148,nil,nil,74,nil,nil,0},
[2182] = {'Stormscale Sorceress',379,405,19,20,0,{[148]={{59.83,23.54},{60.96,22.34},{60.15,22.85},{61.6,21.16},{59.53,15.42},{59.89,22.51},{59.98,18.94},{58.02,20.05},{59.93,19.86},{59.42,24.16},{58.5,22.98},{58.68,22.1},{61.99,20.98},{58.73,20.39},{57.45,19.4},{57.76,21.9},{60.22,16.14},{61.42,17.3},{61.85,19.49},{61.57,22.36},{57.02,21.67},{58.35,24.4},{58.46,24.7},{58.5,18.26}}},nil,148,nil,nil,74,nil,nil,0},
[2183] = {'Stormscale Warrior',494,531,20,21,0,{[148]={{61.27,22.06},{62.02,22.04},{61.28,20.81},{60.29,22.34},{60.1,18.78},{60.47,19.59},{60.46,18.94},{60.28,20.21},{61.02,21.5},{60.62,21.84},{61.96,21.43},{62.18,20.46},{61.35,18.07},{61.41,19.2},{61.02,17.73},{61.25,19.78},{61.19,18.61},{61.66,19.99},{61.09,23.12}}},nil,148,nil,nil,74,nil,nil,0},
[2184] = {'Lady Moongazer',386,386,17,17,4,{[148]={{42.98,61.11}}},nil,148,nil,nil,14,nil,nil,0},
[2185] = {'Darkshore Thresher',247,300,12,14,0,{[148]={{30.82,59.25},{34.52,35.36},{35.81,38.24},{29.51,46.34},{31.91,59.99},{33.61,35.62},{33.4,59.97},{31.82,38.46},{33.77,38.38},{35.47,57.55},{34.85,37.09},{33.54,32.6},{32.42,56.97},{30.88,55.37},{32.51,33.89},{31.49,60.29},{32.67,35.93},{33.64,35.74},{34.88,52.68},{34.94,31.06},{33.57,28.69},{34.64,58.77},{32.51,36.0},{34.4,37.04},{34.58,36.05},{34.35,56.49},{31.45,56.84},{32.06,58.31},{32.7,58.47},{34.0,58.95},{32.2,38.49},{33.22,40.16},{31.96,39.39},{35.9,24.24},{34.56,53.69},{33.93,34.16},{36.44,29.24},{36.8,27.65},{34.96,34.0},{36.05,30.86},{34.39,29.63},{33.85,31.08},{35.92,28.07},{33.9,39.97},{32.25,43.24},{32.57,41.25},{33.59,41.55},{35.44,29.47},{35.97,36.49},{39.66,29.76},{33.94,59.3}}},nil,148,nil,nil,16,nil,nil,0},
[2186] = {'Carnivous the Breaker',356,356,16,16,4,{[148]={{39.37,53.46},{39.91,78.57},{42.83,84.69},{39.89,78.52},{40.16,56.57}}},nil,148,nil,nil,82,nil,nil,0},
[2187] = {'Elder Darkshore Thresher',356,417,16,18,0,{[148]={{30.94,82.66},{29.96,88.72},{55.91,10.45},{57.69,9.57},{30.41,85.14},{51.63,18.83},{30.86,81.25},{30.44,79.03},{30.76,80.41},{53.85,17.09},{31.01,72.91},{31.49,81.96},{30.49,76.54},{30.6,88.22},{30.84,79.23},{30.16,74.45},{33.01,86.0},{30.72,84.77},{49.23,10.49},{48.39,12.52},{48.76,12.79},{49.4,11.27},{48.27,11.7},{48.58,10.9},{47.67,18.62},{49.3,12.13},{49.43,9.39}}},nil,148,nil,nil,16,nil,nil,0},
[2188] = {'Deep Sea Threshadon',712,712,25,25,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2189] = {'Vile Sprite',198,222,10,11,0,{[148]={{44.46,37.54},{44.49,39.07},{44.69,38.61},{44.87,38.98},{44.87,39.71},{45.14,37.9},{44.75,37.69},{44.41,38.11},{44.04,38.44},{44.82,36.21},{44.69,37.17},{46.91,36.17},{47.51,36.12},{47.01,37.08},{44.56,36.59},{46.09,36.52},{45.22,36.32}}},nil,148,nil,nil,81,nil,nil,0},
[2190] = {'Wild Grell',222,247,11,12,0,{[148]={{45.39,40.13},{45.76,40.17},{46.31,39.62},{45.94,39.62},{45.59,38.76},{45.29,39.4},{46.91,38.61},{46.92,39.21},{47.16,38.21},{45.27,38.71},{46.46,38.7},{46.0,39.05},{46.54,38.12},{46.21,37.9},{46.0,38.32},{46.67,36.88},{48.24,36.62},{47.45,37.08},{47.48,37.75},{47.91,36.65},{47.81,37.45},{47.15,37.59},{45.58,36.15}}},nil,148,nil,nil,81,nil,nil,0},
[2191] = {'Licillin',263,263,14,14,4,{[148]={{45.66,36.38}}},nil,148,nil,nil,81,nil,nil,0},
[2192] = {'Firecaller Radison',379,379,19,19,4,{[148]={{38.69,87.64}}},{[148]={{{38.7,87.72},{38.54,87.68},{38.42,87.57},{38.24,87.4},{37.95,87.08},{37.96,86.76},{37.92,87.07},{37.92,87.07},{38.2,87.41},{38.38,87.53},{38.63,87.77},{38.91,87.94},{39.19,87.9},{39.19,87.9},{38.83,87.85}}}},148,nil,nil,16,nil,nil,0},
[2198] = {'Crier Goodman',71,71,3,3,0,{[1519]={{47.45,64.17}}},{[1519]={{{47.31,64.25},{46.11,66.05},{46.63,67.06},{43.91,70.3},{45.25,73.15},{45.35,74.22},{45.17,76.61},{44.41,77.99},{43.87,78.83},{42.54,79.51},{40.69,80.32},{39.85,78.39},{38.85,77.83},{37.54,77.75},{35.72,80.91},{33.98,82.11},{32.78,81.73},{31.69,80.95},{31.29,79.19},{31.33,77.82},{31.57,74.45},{31.61,73.19},{31.68,72.24},{33.22,70.4},{34.64,69.09},{34.52,67.6},{33.42,64.51},{33.01,62.54},{31.7,60.0},{33.35,58.0},{35.14,55.75},{36.4,54.01},{36.36,51.38},{37.44,49.75},{38.78,48.09},{37.45,45.13},{40.32,41.66},{40.83,41.1},{44.04,39.6},{45.9,42.98},{48.11,40.47},{46.16,36.94},{46.33,34.77},{47.84,33.52},{49.39,35.4},{52.62,31.55},{51.47,28.94},{52.76,27.41},{54.37,25.78},{55.73,28.72},{56.94,31.26},{58.24,33.67},{60.42,34.5},{62.13,33.17},{62.13,33.17},{63.38,31.85},{64.65,30.58},{66.47,28.51},{67.79,30.03},{68.08,31.96},{66.92,33.87},{64.98,36.62},{67.23,41.06},{68.44,39.63},{69.68,39.55},{71.26,41.59},{73.06,44.71},{73.1,46.25},{71.9,47.78},{70.58,49.54},{68.71,48.23},{67.42,46.36},{64.65,49.47},{63.91,48.71},{62.78,50.13},{61.04,52.33},{59.95,51.22},{57.41,54.92},{58.94,57.69},{56.15,61.39},{53.73,64.03},{52.67,61.9},{52.28,61.05},{50.83,61.98},{48.95,63.24}}}},1519,{1015,5066,7494},nil,12,"A",nil,3},
[2201] = {'Greymist Raider',222,247,11,12,0,{[148]={{36.12,50.61}}},nil,148,nil,nil,18,nil,nil,0},
[2202] = {'Greymist Coastrunner',247,273,12,13,0,{[148]={{38.67,21.84},{40.94,26.9},{38.6,28.94},{39.86,27.34},{42.02,31.07},{42.12,31.7},{42.15,32.18},{35.97,50.78},{40.33,27.19},{40.12,27.28},{38.71,29.19},{38.48,28.99},{38.49,28.96},{38.31,28.9},{38.69,29.63},{38.09,28.49},{41.72,31.17},{40.16,27.39},{38.26,29.85},{36.43,50.69},{36.61,51.0},{36.16,50.99},{36.4,51.08},{36.92,61.66},{36.75,61.66},{36.92,62.24},{37.26,62.28}}},nil,148,nil,nil,18,nil,nil,0},
[2203] = {'Greymist Seer',253,276,13,14,0,{[148]={{39.72,27.22},{39.99,26.51},{40.04,28.09},{39.77,27.5},{40.12,27.39},{40.31,27.36},{35.85,71.09},{41.86,30.86},{39.81,27.51},{38.75,29.8},{38.24,28.85},{38.68,29.18},{38.84,29.6},{38.67,29.52},{39.27,27.79},{41.78,31.59},{41.89,31.96},{38.87,30.33},{37.12,61.82},{36.79,61.96},{36.15,70.74},{35.89,71.43},{35.72,71.59}}},nil,148,nil,nil,18,nil,nil,0},
[2204] = {'Greymist Netter',300,328,14,15,0,{[148]={{44.19,20.35},{43.83,20.34},{36.24,71.04},{35.98,70.49},{35.81,71.27}}},nil,148,nil,nil,18,nil,nil,0},
[2205] = {'Greymist Warrior',328,356,15,16,0,{[148]={{32.49,80.21},{44.25,20.75},{43.88,20.07},{44.08,20.18},{43.85,20.72},{36.49,76.21},{33.2,81.45},{44.08,21.03},{36.73,76.63},{36.75,76.34},{36.68,76.86}}},nil,148,nil,nil,18,nil,nil,0},
[2206] = {'Greymist Hunter',356,386,16,17,0,{[148]={{32.59,80.89},{32.63,80.38},{36.65,76.6},{36.54,76.68},{32.86,80.76},{32.96,81.17},{36.52,76.48},{36.35,76.51}}},nil,148,nil,nil,18,nil,nil,0},
[2207] = {'Greymist Oracle',377,404,18,19,0,{[148]={{54.66,11.79},{54.88,11.59},{31.04,87.67},{30.85,85.57},{31.02,85.72},{31.44,87.19},{30.96,85.28},{55.46,12.62},{55.01,12.52},{31.63,83.91},{31.42,83.89},{31.13,85.22},{31.13,87.89},{31.4,87.52}}},nil,148,nil,nil,18,nil,nil,0},
[2208] = {'Greymist Tidehunter',404,433,19,20,0,{[148]={{54.88,11.87},{54.83,12.19},{31.39,83.17},{31.35,83.48},{31.08,87.19},{31.61,83.29},{55.28,12.58},{55.2,12.88},{55.16,12.18},{54.99,12.09},{31.72,83.48},{31.82,83.76},{31.25,85.75},{31.32,85.51},{31.46,87.95},{31.26,87.93}}},nil,148,nil,nil,18,nil,nil,0},
[2209] = {'Deathguard Gavin',1302,1302,24,24,0,{[85]={{61.74,51.41}}},nil,85,nil,nil,71,"H",nil,1},
[2210] = {'Deathguard Royann',1302,1302,24,24,0,{[85]={{61.67,51.18}}},nil,85,nil,nil,71,"H",nil,1},
[2211] = {'Captured Mountaineer',176,176,9,9,0,{[85]={{61.94,51.4}}},nil,85,nil,{492},68,"H",nil,2},
[2212] = {'Deth\'ryll Satyr',247,273,12,13,0,{[148]={{45.4,39.73},{46.64,39.19},{47.48,36.66},{47.95,37.08},{47.28,37.68},{45.46,36.5}}},nil,148,nil,nil,90,nil,nil,0},
[2213] = {'Deth\'ryll Shadowstalker',273,300,13,14,0,nil,nil,0,nil,nil,90,nil,nil,0},
[2214] = {'Deathstalker Lesh',712,712,25,25,0,{[267]={{20.79,47.4}}},nil,267,{494},nil,68,"H",nil,2},
[2215] = {'High Executor Darthalia',44300,44300,50,50,1,{[267]={{62.33,20.45}}},nil,267,{527,528,529,532,539,541,550},{494,527,528,529,532,539,541,549,566,567},68,"H",nil,2},
[2216] = {'Apothecary Lydon',1342,1342,35,35,0,{[267]={{61.44,19.06}}},nil,267,{496,499,501,502,509,513,517,524,1066,1067,2934,2935,2938},{493,496,501,509,515,517,1065,1066,2933,2934,2937},68,"H","Royal Apothecary Society",2},
[2217] = {'Undead Druid Trainer',42,42,1,1,0,nil,nil,0,nil,nil,68,"H","Druid Trainer",0},
[2218] = {'Undead Hunter Trainer',42,42,1,1,0,nil,nil,0,nil,nil,68,"H","Hunter Trainer",0},
[2219] = {'Undead Shaman Trainer',42,42,1,1,0,nil,nil,0,nil,nil,68,"H","Shaman Trainer",0},
[2221] = {'Undead Tailor Trainer',42,42,1,1,0,nil,nil,0,nil,nil,68,"H","Tailor Trainer",0},
[2222] = {'Undead Mining Trainer',42,42,1,1,0,nil,nil,0,nil,nil,68,"H","Mining Trainer",0},
[2224] = {'Wind Rider',1040,1040,29,29,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2225] = {'Zora Guthrek',26140,26140,55,55,0,{[2597]={{50.08,82.15}}},nil,2597,nil,nil,1215,"H","Trade Goods",6},
[2226] = {'Karos Razok',7842,7842,55,55,1,{[130]={{45.62,42.6}}},nil,130,{6323},{6321},68,"H","Bat Handler",11},
[2227] = {'Sharlindra',712,712,25,25,0,{[1497]={{57.63,93.8}}},nil,1497,{495},{521},68,"H",nil,2},
[2228] = {'Lieutenant Farren Orinelle',712,712,25,25,0,{[267]={{51.46,58.39}}},nil,267,{536,559,560,562,563},{536,559,561,562},12,"A",nil,2},
[2229] = {'Krusk',712,712,25,25,0,{[267]={{63.24,20.66}}},nil,267,{498,503,507,533,1361},{498,506,508,533},29,"H",nil,2},
[2230] = {'Umpi',42,42,1,1,0,{[267]={{61.55,19.14}}},nil,267,nil,{499},68,"H",nil,2},
[2231] = {'Pygmy Tide Crawler',176,198,9,10,0,{[148]={{37.42,40.32},{35.44,51.16},{36.85,41.8},{37.22,40.63},{36.7,36.34},{36.84,35.88},{36.88,40.51},{36.53,39.38},{35.5,41.17},{36.43,37.66},{36.49,37.53},{35.16,43.02},{36.31,40.39},{35.91,41.34},{36.08,39.8},{35.09,49.38},{35.69,49.96},{34.99,44.4},{35.44,44.64},{35.56,50.73},{36.0,50.09},{35.42,49.43},{35.06,48.46},{35.64,47.12},{35.0,46.72},{35.64,48.08},{35.29,46.19},{35.86,48.31},{36.68,48.4},{36.38,49.11},{35.39,47.51},{37.0,36.61},{36.44,38.84},{37.0,35.53},{34.69,47.98},{36.62,36.84},{36.48,49.14},{37.74,35.77},{36.56,49.79},{36.2,44.48},{37.37,39.69},{35.96,46.96},{35.93,45.92},{36.73,36.27},{36.43,47.76},{37.19,38.66},{37.11,37.06}}},nil,148,nil,nil,7,"AH",nil,0},
[2232] = {'Tide Crawler',273,300,13,14,0,{[148]={{35.53,65.23},{41.48,26.88},{43.1,19.77},{42.21,21.01},{41.61,25.35},{35.48,68.94},{41.19,28.59},{42.13,24.79},{41.58,24.18},{41.88,26.75},{42.57,23.25},{42.26,22.58},{41.65,23.05},{42.78,20.56},{42.33,28.3},{41.6,30.08},{35.98,62.72},{42.14,29.39},{36.26,63.2},{36.89,66.63},{36.61,69.83},{35.59,65.76},{36.69,68.16},{36.72,65.81},{37.15,67.24},{35.77,64.65},{36.41,65.86}}},nil,148,nil,nil,7,"AH",nil,0},
[2233] = {'Encrusted Tide Crawler',417,484,18,20,0,{[148]={{32.95,82.88},{32.33,83.71},{52.84,17.76},{54.03,18.94},{52.23,18.56},{53.33,18.56},{52.24,20.89},{51.72,20.97},{51.3,23.21},{51.73,22.54},{52.81,19.52},{32.7,81.41},{31.73,81.91},{32.04,80.71},{52.3,23.31}}},nil,148,nil,nil,7,"AH",nil,0},
[2234] = {'Young Reef Crawler',198,222,10,11,0,{[148]={{38.88,30.72},{36.97,34.32},{37.44,32.95},{40.15,31.42},{34.86,54.4},{40.85,31.14},{39.53,31.55},{35.24,52.65},{35.06,56.09},{35.22,54.41},{35.88,53.66},{40.59,31.83},{34.51,53.71},{37.81,33.92},{38.07,32.41},{38.53,31.54},{37.03,52.02},{35.69,60.19},{36.77,60.27},{36.72,57.01},{36.99,55.45},{35.74,54.62},{35.75,55.48},{35.89,58.18},{36.69,58.0},{36.09,59.13},{37.11,61.06},{36.45,52.8},{36.99,53.92},{36.48,54.52}}},nil,148,nil,nil,7,"AH",nil,0},
[2235] = {'Reef Crawler',328,386,15,17,0,{[148]={{34.89,72.28},{45.37,20.02},{44.76,21.8},{50.67,22.52},{48.27,20.69},{50.56,22.44},{46.52,21.04},{48.9,20.08},{48.19,20.95},{47.57,21.52},{46.78,20.34},{46.14,20.6},{45.54,20.71},{35.18,72.36},{35.82,72.84},{35.65,73.56},{35.47,77.54},{36.01,75.19}}},nil,148,nil,nil,7,"AH",nil,0},
[2236] = {'Raging Reef Crawler',494,531,20,21,0,{[148]={{29.56,90.35},{31.42,89.55},{29.69,91.08},{30.59,90.49},{30.99,88.96},{30.59,89.66},{29.53,90.83},{29.65,89.62},{28.62,90.81},{29.77,91.13},{56.57,11.4},{57.48,14.53},{56.39,12.51},{56.37,16.26},{56.9,13.05},{55.8,16.63},{56.01,17.45},{55.95,14.89},{56.41,17.0},{55.35,17.08},{56.3,14.51},{54.76,18.28},{55.54,19.23},{32.9,88.97}}},nil,148,nil,nil,7,"AH",nil,0},
[2237] = {'Moonstalker Sire',386,417,17,18,0,{[148]={{43.75,81.85},{36.17,82.11},{39.32,94.5},{44.65,92.03},{60.07,13.37},{36.59,91.5},{39.8,70.69},{37.6,83.9},{39.89,81.36},{40.14,82.87},{44.08,81.33},{41.67,83.34},{43.82,83.12},{43.98,79.96},{38.53,90.5},{40.39,90.82},{42.55,88.09},{37.53,91.93},{61.4,11.16},{43.24,81.99},{43.2,82.85},{38.32,77.17}}},nil,148,nil,nil,14,nil,nil,0},
[2238] = {'Tog\'thar',617,617,23,23,0,{[267]={{79.75,39.64}}},nil,267,nil,nil,29,"H",nil,3},
[2239] = {'Drull',617,617,23,23,0,{[267]={{75.36,41.55}}},nil,267,nil,nil,29,"H",nil,3},
[2240] = {'Syndicate Footpad',1163,1221,32,33,0,{[36]={{57.71,67.64},{56.48,66.05},{59.49,68.04},{58.35,66.7},{58.68,68.42},{59.0,67.22},{57.77,66.16},{47.68,81.86},{47.78,81.18},{48.34,79.29},{47.75,82.9}}},nil,36,nil,nil,87,nil,nil,0},
[2241] = {'Syndicate Thief',1221,1279,33,34,0,{[36]={{59.02,69.33},{58.17,68.44},{57.6,68.54},{58.35,67.71},{58.89,69.46},{58.44,70.0},{47.81,82.37},{48.03,81.88},{47.29,81.87},{46.56,81.49},{48.32,80.78},{48.74,82.99}}},nil,36,nil,nil,87,nil,nil,0},
[2242] = {'Syndicate Spy',1403,1469,35,36,0,{[36]={{64.2,41.62},{57.91,48.79},{58.69,42.91},{64.07,45.8},{64.01,44.28},{57.56,44.21},{58.76,41.16},{57.83,41.61},{62.87,42.08},{59.99,46.21},{56.61,46.96},{56.79,45.3},{62.33,47.0},{60.17,41.82},{61.03,43.49},{60.63,43.86},{61.38,43.36},{61.41,43.11},{60.76,43.88},{63.41,45.07},{63.51,43.72},{63.49,43.77},{62.38,45.26}}},nil,36,nil,nil,87,nil,nil,0},
[2243] = {'Syndicate Sentry',1469,1536,36,37,0,{[36]={{51.88,30.63},{51.14,29.58},{60.12,32.39},{56.03,34.37},{58.33,36.14},{56.12,26.08},{55.48,26.39},{58.42,29.29},{57.29,30.97},{58.28,30.68},{57.55,29.37},{58.85,29.27},{59.1,29.94},{57.9,28.83},{52.95,25.43},{55.56,27.46},{55.39,30.52},{52.75,23.17},{56.17,27.8},{47.68,18.19},{47.36,17.42},{48.18,16.79},{46.88,18.03},{46.07,19.77},{47.35,16.86},{48.43,17.76},{47.78,16.0},{53.27,20.25},{53.34,21.22},{53.9,21.6},{46.32,20.4}}},nil,36,nil,nil,87,nil,nil,0},
[2244] = {'Syndicate Shadow Mage',441,472,21,22,0,{[267]={{67.92,47.23},{83.44,40.59},{78.23,38.54},{64.85,47.08},{66.65,46.0},{65.37,48.68},{66.73,50.05},{81.9,39.61},{79.77,43.42},{77.68,39.22},{79.77,46.87},{75.8,40.74},{78.99,41.2},{81.55,44.37},{80.1,39.73},{75.3,40.3},{79.61,41.71},{76.75,41.87},{76.01,42.03},{75.62,42.73},{78.73,43.51},{80.48,42.66},{81.04,45.0},{81.66,45.49},{80.92,45.7},{80.85,46.94}}},nil,267,nil,nil,87,nil,nil,0},
[2245] = {'Syndicate Saboteur',1536,1604,37,38,0,{[36]={{56.96,26.02},{57.76,30.23},{54.4,20.94},{56.9,26.9},{55.59,27.99},{55.71,27.04},{48.13,18.13},{53.81,19.91}}},nil,36,nil,nil,87,nil,nil,0},
[2246] = {'Syndicate Assassin',1604,1678,38,39,0,{[36]={{38.44,14.58},{42.34,20.29},{41.18,21.04},{40.64,22.54},{40.73,19.92},{39.53,15.06},{38.91,15.43},{39.2,19.22},{39.94,15.39},{39.74,20.05},{39.62,15.8},{39.37,15.09},{40.51,16.8},{37.4,15.51},{38.51,15.43},{38.03,13.74}}},nil,36,nil,nil,87,nil,nil,0},
[2247] = {'Syndicate Enforcer',1678,1753,39,40,0,{[36]={{38.94,13.1},{39.36,21.07},{38.32,22.46},{41.63,19.49},{39.39,15.1},{40.32,18.56},{39.24,14.69},{41.26,17.92},{43.02,18.32},{38.32,16.53},{37.05,13.11}}},nil,36,nil,nil,87,nil,nil,0},
[2248] = {'Cave Yeti',1050,1107,30,31,0,{[267]={{46.45,30.59},{44.92,25.09},{43.96,27.36},{46.37,34.01},{45.42,33.96},{47.4,30.88},{46.27,31.92},{42.78,32.65},{42.06,33.18},{42.84,31.77},{42.24,31.95},{44.55,29.36},{44.55,31.21},{45.28,31.24},{44.86,28.33},{45.25,33.57},{47.36,32.09}}},nil,267,nil,nil,16,nil,nil,0},
[2249] = {'Ferocious Yeti',1107,1163,31,32,0,{[267]={{43.4,27.52},{45.14,27.18},{44.38,25.03},{43.64,26.85},{43.45,25.66},{42.88,33.47},{42.27,30.53},{43.46,30.59},{44.83,29.98},{43.97,30.2},{45.01,26.06},{43.58,29.78},{43.38,27.79},{43.91,28.73},{43.97,31.01},{45.27,29.61},{44.15,27.71}}},nil,267,nil,nil,16,nil,nil,0},
[2250] = {'Mountain Yeti',1163,1221,32,33,0,{[36]={{30.57,64.52},{31.3,65.67},{32.51,67.17},{39.15,67.27},{40.19,70.1},{40.58,73.74},{39.32,72.6},{39.36,68.25},{37.01,72.45},{38.68,74.01},{34.65,68.64},{34.6,72.11},{33.22,67.08},{33.22,70.25},{36.81,70.49},{29.75,63.35},{30.97,61.79},{30.9,58.08}}},nil,36,nil,nil,16,nil,nil,0},
[2251] = {'Giant Yeti',1221,1279,33,34,0,{[36]={{32.29,49.16},{32.17,45.43},{32.88,43.01},{41.86,63.29},{33.8,39.75},{35.83,37.76},{29.8,54.04},{37.33,66.21},{36.78,36.41},{37.52,67.25},{35.88,35.5},{37.67,65.99},{30.87,50.92},{29.64,49.21},{30.92,47.5},{30.94,54.51},{39.06,64.98},{40.51,63.26},{41.92,65.27},{42.75,62.55},{41.5,61.68},{43.96,64.95},{42.91,66.73},{41.35,69.21},{40.35,67.02},{39.46,65.3},{35.55,73.81},{35.8,70.46},{35.42,67.08},{36.85,69.0},{29.71,59.95},{29.81,56.07},{29.73,52.87},{32.01,53.03}}},nil,36,nil,nil,16,nil,nil,0},
[2252] = {'Crushridge Ogre',1279,1342,34,35,0,{[36]={{53.64,36.04},{51.74,45.41},{52.6,42.07},{52.47,38.16},{46.33,32.8},{45.18,29.41},{53.02,45.47},{54.84,54.53},{41.53,30.59},{55.75,54.32},{53.72,54.38},{49.15,39.08},{51.04,34.95},{49.98,31.5},{49.95,34.53},{49.91,32.81},{51.1,40.31},{45.33,37.86},{46.35,39.85},{55.5,40.57},{52.38,40.2},{53.59,41.89},{54.49,43.33},{51.21,46.76},{53.2,45.08},{54.53,52.75},{50.15,52.74},{52.49,52.61},{51.43,36.55},{48.61,54.25},{47.42,60.37},{43.92,32.81},{43.93,36.52},{44.92,60.2},{45.39,61.33},{46.47,35.21},{48.93,36.94},{49.93,42.09},{49.88,38.16},{48.9,43.25},{49.05,61.32},{50.26,59.28},{53.3,47.95},{47.54,63.59},{46.18,63.06},{51.75,45.23},{53.06,45.63},{51.0,56.38},{48.75,54.9}}},nil,36,nil,nil,45,nil,nil,0},
[2253] = {'Crushridge Brute',1403,1468,35,36,0,{[36]={{42.81,31.15},{47.68,38.64},{48.49,57.3},{47.34,36.39},{47.61,40.41},{52.37,47.46},{52.89,47.63},{47.46,44.51},{52.43,45.57},{46.48,58.37},{50.23,56.22},{51.4,52.67},{51.55,54.59},{51.21,38.28},{48.89,42.05},{51.28,58.03},{44.17,34.88},{45.67,34.93},{45.19,31.42},{47.83,33.39},{47.69,33.04},{48.09,43.55},{52.14,43.96},{50.69,45.28},{51.1,45.59},{53.61,45.58},{48.81,59.86},{46.55,60.9},{51.45,47.5},{49.64,54.2}}},nil,36,nil,nil,45,nil,nil,0},
[2254] = {'Crushridge Mauler',3831,4008,36,37,1,{[36]={{39.33,40.12},{38.29,41.97},{39.46,38.78},{41.75,43.49},{41.7,44.87},{43.83,51.25},{40.38,45.67},{46.42,46.87},{43.94,46.65},{45.83,47.74},{43.11,46.89},{43.88,49.01},{43.25,50.17},{42.47,47.71},{41.41,48.67},{45.93,45.84}}},nil,36,nil,nil,45,nil,nil,0},
[2255] = {'Crushridge Mage',2910,3012,37,38,1,{[36]={{41.28,39.9},{38.44,40.18},{38.93,49.55},{40.3,47.53},{40.39,43.69},{42.82,45.8},{45.61,46.63},{43.33,48.01}}},nil,36,nil,nil,45,nil,nil,0},
[2256] = {'Crushridge Enforcer',4185,4377,38,39,1,{[36]={{40.5,51.05},{39.9,49.15},{38.19,51.28},{38.18,52.52},{36.85,51.01},{35.67,49.08},{37.89,49.21},{40.35,54.44},{39.5,56.18},{38.12,59.9},{38.18,54.54},{36.85,56.41},{39.24,54.7}}},nil,36,nil,nil,45,nil,nil,0},
[2257] = {'Mug\'thol',5148,5148,43,43,1,{[36]={{35.68,54.25}}},nil,36,nil,nil,45,nil,nil,0},
[2258] = {'Stone Fury',1536,1536,37,37,4,{[36]={{64.68,44.77}}},{[36]={{{64.68,44.77},{64.85,45.32},{65.17,46.36},{65.67,47.02},{67.79,47.13},{68.39,46.76},{69.02,46.5},{70.56,46.61},{71.87,46.39},{73.38,46.35},{75.18,46.75},{77.1,46.64},{78.29,45.86},{79.32,44.55},{79.97,42.39},{80.11,40.41},{79.97,42.39},{79.31,44.58},{78.28,45.87},{77.09,46.65},{75.18,46.75},{73.38,46.35},{71.85,46.39},{70.54,46.61},{69.01,46.5},{68.37,46.76},{67.79,47.14},{65.65,47.02},{65.16,46.35},{64.85,45.33}}}},36,nil,nil,91,nil,nil,0},
[2260] = {'Syndicate Rogue',531,573,21,22,0,{[267]={{65.36,46.57},{66.08,45.6},{66.04,48.13},{66.08,48.73},{81.01,46.61},{79.28,46.37},{75.02,40.67},{67.1,50.91},{81.04,44.59},{78.71,41.78},{77.76,44.18},{75.52,42.28},{80.41,44.84},{81.84,45.21},{82.24,42.36},{80.53,46.89}}},nil,267,nil,nil,87,nil,nil,0},
[2261] = {'Syndicate Watchman',494,531,20,21,0,{[267]={{82.9,44.42},{78.8,47.58},{81.74,47.53},{81.76,44.62},{83.82,40.9},{82.88,40.33},{75.73,44.05},{74.37,40.5},{75.15,37.95},{74.77,39.11},{65.78,48.49},{67.05,46.24},{67.07,47.7},{67.2,50.21},{67.6,47.59},{77.25,39.01},{81.65,39.8},{82.07,39.63},{79.37,46.8},{79.21,40.19},{77.84,40.37},{77.91,41.35},{78.31,41.36},{79.61,39.37},{79.55,40.06},{79.83,40.76},{75.36,39.7},{80.41,40.72},{79.75,44.57},{78.75,45.24},{79.54,45.55},{78.19,44.45},{75.97,41.48},{76.39,41.16},{76.23,40.83},{76.67,42.74},{75.23,42.07},{76.74,44.19},{76.66,46.77},{76.36,46.41},{77.16,45.25},{78.18,43.19},{78.14,46.5},{79.71,43.17},{81.16,41.95},{81.68,41.27},{80.75,43.81},{80.6,46.02},{81.92,44.6},{82.68,41.52},{82.01,43.22},{80.11,45.43}}},nil,267,nil,nil,87,nil,nil,0},
[2263] = {'Marshal Redpath',1902,1902,41,41,0,{[267]={{49.47,58.73}}},nil,267,{500,504,561},{500,504,560},12,"A",nil,2},
[2264] = {'Hillsbrad Tailor',664,713,24,25,0,{[267]={{36.82,44.26},{36.76,44.48}}},nil,267,nil,nil,123,"A",nil,21},
[2265] = {'Hillsbrad Apprentice Blacksmith',664,712,24,25,0,{[267]={{32.62,45.14},{31.15,46.72},{31.89,46.72},{31.96,45.83},{31.17,43.9},{31.61,44.48}}},nil,267,nil,nil,123,"A",nil,6},
[2266] = {'Hillsbrad Farmer',617,664,23,24,0,{[267]={{33.8,46.52},{33.88,42.42},{34.9,44.62},{35.8,45.18},{35.17,47.36},{35.59,41.35},{35.85,41.24},{34.79,38.52},{36.38,39.77},{35.46,40.35},{33.17,34.63},{35.13,37.43},{34.02,35.69},{30.74,34.99},{33.42,35.97},{30.53,35.26},{31.7,34.93},{32.78,34.59},{31.72,38.62},{31.4,38.59},{30.31,38.99},{29.68,37.49},{31.86,39.23}}},nil,267,nil,nil,123,"A",nil,0},
[2267] = {'Hillsbrad Peasant',664,713,24,25,0,{[267]={{29.77,43.77},{30.27,40.31},{29.85,41.07},{30.81,41.51},{33.66,47.35},{34.06,45.69},{35.41,42.01},{30.84,45.44},{36.44,45.43},{34.69,44.58},{34.76,46.11},{35.09,47.05},{34.78,47.16},{35.59,44.31},{35.48,46.2}}},nil,267,nil,nil,123,"A",nil,0},
[2268] = {'Hillsbrad Footman',734,788,25,26,0,{[267]={{29.98,44.2},{29.96,46.41},{33.07,45.72},{32.39,39.67},{31.36,42.22},{30.89,42.42},{32.2,42.93},{29.15,40.12},{34.3,44.23},{34.48,47.98},{36.48,46.92},{37.03,46.85},{32.83,36.69},{33.73,43.09},{29.15,45.72},{33.25,38.06},{32.81,48.53}}},nil,267,nil,nil,123,"A",nil,0},
[2269] = {'Hillsbrad Miner',788,840,26,27,0,{[267]={{28.9,57.45},{28.45,57.23},{31.49,52.39},{32.4,52.05},{31.77,51.77},{32.01,53.17},{29.7,56.54},{28.14,51.16},{31.99,54.64},{31.23,53.1},{32.21,55.51},{28.45,51.94},{28.18,57.12},{26.99,58.02},{27.69,57.74},{28.72,55.96},{30.2,58.41},{31.28,57.85},{31.4,59.5},{30.85,58.15},{30.84,59.09},{31.6,58.53},{30.44,55.62},{30.14,56.47},{28.95,57.32},{31.36,54.08},{30.45,53.93},{30.77,55.08},{30.36,53.12},{29.67,54.99},{29.19,53.47},{30.01,53.96},{27.79,54.14},{28.2,56.32},{28.3,54.8},{27.59,56.65},{27.51,57.66}}},nil,267,nil,nil,123,"A",nil,0},
[2270] = {'Hillsbrad Sentry',840,896,27,28,0,{[267]={{26.47,61.81},{26.58,60.3},{25.81,59.45},{27.64,61.65},{27.45,60.37},{28.52,60.27},{27.09,58.91}}},nil,267,nil,nil,123,"A",nil,0},
[2271] = {'Dalaran Shield Guard',1106,1162,31,32,0,{[36]={{22.1,60.33},{15.03,78.56},{15.15,78.68},{20.91,87.47},{21.63,87.41},{20.81,87.81},{20.96,83.89},{18.42,87.99},{21.22,84.06},{20.44,82.25},{17.66,83.59},{18.0,84.23},{18.11,83.78},{18.4,83.43},{18.77,86.19},{19.0,84.35}}},nil,36,nil,nil,76,"AH",nil,0},
[2272] = {'Dalaran Theurgist',882,919,32,33,0,{[36]={{22.2,60.36},{18.93,77.81},{20.42,87.43},{19.93,83.76},{17.87,83.11},{17.16,83.26},{18.25,84.28},{22.57,60.91}}},nil,36,nil,nil,76,"AH",nil,0},
[2274] = {'Stanley',664,664,24,24,0,{[267]={{32.66,35.32}}},nil,267,nil,{502},35,"AH",nil,2},
[2275] = {'Enraged Stanley',664,664,24,24,0,nil,nil,0,nil,nil,32,"AH",nil,0},
[2276] = {'Magistrate Henry Maleb',16220,16220,30,30,1,{[267]={{48.14,59.11}}},nil,267,{505,512,523,537},{505,510,512,522,523,525,537},96,"A",nil,2},
[2277] = {'Loremaster Dibbs',1002,1002,30,30,0,{[267]={{50.57,57.09}}},nil,267,{514,540,542,554},{511,538,540,551},12,"A",nil,2},
[2278] = {'Melisara',712,712,25,25,0,{[267]={{62.63,20.65}}},nil,267,{518,519,520,521},{495,518,519,520},68,"H",nil,2},
[2279] = {'Alliance Battleguard',6474,6474,62,62,0,nil,nil,0,nil,nil,84,"A",nil,0},
[2280] = {'Horde Battleguard',6474,6474,62,62,0,nil,nil,0,nil,nil,83,"H",nil,0},
[2281] = {'Baelish Frostbane',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2282] = {'[PH] Orgrun Iceflow',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2283] = {'Ravenclaw Regent',508,508,22,22,4,{[130]={{56.83,70.18}}},nil,130,nil,nil,21,nil,nil,0},
[2284] = {'Captured Farmer',86,86,4,4,0,{[267]={{62.9,18.73},{62.81,19.11},{62.67,18.79}}},nil,267,nil,nil,35,"AH",nil,0},
[2285] = {'Count Remington Ridgewell',1752,1752,40,40,0,{[1519]={{74.01,30.24}}},nil,1519,{543,4766},{543,4765},12,"A","House of Nobles",2},
[2286] = {'Bow Guy',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2287] = {'Crushridge Warmonger',4377,4572,39,40,1,{[36]={{34.94,53.45},{35.56,53.19},{40.53,52.96},{36.25,53.62},{36.37,53.93},{35.69,55.52},{36.3,53.79},{36.37,52.31},{35.91,52.76},{35.57,53.23},{36.16,54.95},{36.32,52.51},{35.07,53.29},{35.88,55.57},{37.04,54.46},{35.77,53.86},{36.26,54.99},{35.83,54.31},{36.83,49.08},{35.71,51.04},{37.03,53.15},{39.16,54.5},{39.24,59.55},{38.36,57.8},{38.08,55.98},{36.75,58.02}}},nil,36,nil,nil,45,nil,nil,0},
[2288] = {'Skracher Mudmuzzle',1910,1910,30,30,0,nil,nil,0,nil,nil,70,nil,nil,0},
[2289] = {'Connor McCoy',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2290] = {'Bertran Keldrake',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2291] = {'Corbin Halman',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2292] = {'Reginald Berry',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2294] = {'Jaynice Sillestan',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2298] = {'Dolthar Stonefoot',4370,4370,62,62,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[2299] = {'Borgus Stoutarm',7842,7842,55,55,1,{[46]={{84.33,68.33}}},nil,46,nil,nil,55,"A","Gryphon Master",11},
[2302] = {'Aethalas',157200,157200,61,61,1,{[1657]={{59.04,36.94}}},nil,1657,nil,nil,1514,"A","Warsong Gulch Battlemaster",2049},
[2303] = {'Lyranne Feathersong',3643,3643,56,56,0,{[618]={{51.96,29.29}}},nil,618,nil,nil,80,"A","Food & Drink",6},
[2304] = {'Captain Ironhill',3171,3171,32,32,1,{[267]={{71.47,79.78},{72.58,80.03},{72.53,79.65}}},nil,267,nil,nil,88,"A",nil,0},
[2305] = {'Foreman Bonds',852,852,30,30,0,{[267]={{31.21,56.01}}},nil,267,nil,nil,88,"A",nil,0},
[2306] = {'Baron Vardus',1239,1239,40,40,0,{[36]={{47.83,17.11}}},nil,36,nil,nil,16,nil,nil,0},
[2307] = {'Caretaker Caice',102,102,5,5,0,{[85]={{32.71,71.13}}},nil,85,nil,nil,68,"H",nil,0},
[2308] = {'Andrew Brownell',1752,1752,40,40,0,{[1497]={{74.05,33.31}}},nil,1497,{3341},{3341},68,"H",nil,2},
[2309] = {'Thomas Arlento',102,102,5,5,0,{[85]={{59.93,52.37}}},nil,85,nil,nil,68,"H",nil,0},
[2310] = {'Jamie Nore',102,102,5,5,0,{[85]={{60.75,50.48}}},nil,85,nil,nil,68,"H",nil,0},
[2311] = {'Doreen Beltis',102,102,5,5,0,{[85]={{60.32,52.53}}},nil,85,nil,nil,68,"H",nil,0},
[2314] = {'Sahvan Bloodshadow',102,102,5,5,0,{[85]={{58.37,51.45}}},{[85]={{{59.62,51.68},{59.89,51.86},{60.3,52.16},{60.43,52.4},{60.41,52.93},{60.33,53.07},{60.22,53.26},{60.35,53.04},{60.43,52.92},{60.73,52.94},{61.04,52.88},{61.02,52.49},{60.75,52.14},{60.23,51.78},{59.8,51.67},{59.51,51.7},{58.56,51.54},{58.4,51.47},{58.29,50.71},{58.31,49.9},{58.34,49.37},{58.33,48.84},{58.34,48.69},{58.32,50.02},{58.37,51.36},{58.37,51.45},{58.45,51.52},{59.32,51.58},{60.32,52.14},{61.08,52.86},{61.34,52.83},{61.27,52.91},{61.13,52.88},{61.04,52.63},{60.79,52.46},{60.28,52.2},{59.97,52.34},{59.85,52.15}}}},85,nil,nil,68,"H",nil,0},
[2315] = {'Maquell Ebonwood',102,102,5,5,0,{[85]={{32.27,65.73}}},{[85]={{{32.27,65.73},{32.05,65.6},{31.71,66.19},{30.97,66.21},{31.71,66.19},{31.97,65.63},{32.06,65.62},{32.26,65.62}}}},85,nil,nil,68,"H",nil,0},
[2316] = {'Gol\'dir',712,712,25,25,0,{[36]={{59.96,43.74}}},nil,36,{506},{503},29,"H",nil,2},
[2317] = {'Elysa',712,712,25,25,0,{[36]={{39.3,14.31}}},nil,36,{508},{507},35,"AH",nil,2},
[2318] = {'Argus Shadow Mage',1037,1075,35,36,0,{[36]={{58.7,30.52},{56.11,27.3},{47.79,17.45},{53.28,20.73},{57.43,46.21},{60.26,43.98},{61.25,45.83},{63.63,43.7},{62.34,40.58}}},nil,36,nil,nil,16,nil,nil,0},
[2319] = {'Syndicate Wizard',954,992,34,35,0,{[36]={{58.15,67.29},{60.17,43.58},{59.91,43.47},{61.33,43.96},{63.15,43.96},{61.48,45.5},{63.23,44.02},{61.85,41.17},{62.34,41.19},{61.61,40.15},{62.25,44.02}}},nil,36,nil,nil,87,nil,nil,0},
[2320] = {'Nagaz',1753,1753,40,40,0,{[36]={{39.22,14.31}}},nil,36,nil,nil,16,nil,nil,0},
[2321] = {'Foreststrider Fledgling',222,273,11,13,0,{[148]={{45.38,27.44},{47.88,41.05},{44.27,55.8},{47.29,41.32},{39.01,68.82},{39.32,65.6},{43.82,70.67},{47.24,42.61},{47.16,44.79},{38.16,62.65},{44.55,28.84},{44.63,25.72},{44.58,44.35},{43.1,70.54},{48.92,22.78},{43.3,44.52},{39.87,39.77},{45.71,54.75},{46.1,53.02},{39.87,67.13},{45.56,42.9},{44.3,68.86},{47.64,40.14},{40.53,36.68},{43.91,67.28},{43.21,68.06},{45.38,22.93},{38.07,63.93},{43.42,40.68},{40.4,35.0},{40.35,41.27},{39.67,36.6},{41.32,41.46},{39.25,38.49},{41.54,34.66},{45.83,24.93},{39.52,62.52},{41.88,33.75},{44.74,42.58},{45.41,32.17},{42.35,35.1},{44.55,33.42},{42.82,42.64},{39.61,59.71},{42.64,39.71},{38.81,67.01},{42.21,70.12},{39.13,60.67},{41.65,65.77},{45.38,41.11},{43.91,43.24},{39.76,57.38},{41.67,67.5},{38.54,58.2},{44.17,26.34},{40.53,38.44},{44.36,41.4},{41.08,43.17},{39.28,34.83},{41.93,45.96},{43.35,53.45},{42.93,55.28},{43.99,31.55},{45.85,22.17},{44.55,29.9},{34.81,87.3},{42.8,33.47},{42.4,47.46},{38.2,56.62},{38.22,59.45},{41.4,68.56},{43.87,29.3},{38.41,68.13},{43.56,55.05},{45.18,58.04},{39.57,33.93},{38.49,64.66},{47.08,22.51},{46.8,25.76},{43.3,66.13},{38.51,65.39},{38.52,33.5},{44.55,24.5},{42.85,26.37},{45.61,23.43},{43.83,33.45},{43.75,25.75},{42.78,67.31},{41.96,65.5},{38.82,36.42},{42.3,68.46},{43.74,28.07},{46.89,24.48},{44.21,23.41},{38.95,48.68},{38.22,47.49},{47.94,23.62},{34.8,87.34}}},nil,148,nil,nil,189,"AH",nil,0},
[2322] = {'Foreststrider',300,356,14,16,0,{[148]={{48.88,27.32},{49.63,27.72},{49.6,28.42},{48.54,32.16},{48.32,30.63},{48.58,34.69},{43.69,70.51},{39.33,70.21},{53.45,28.86},{46.89,33.64},{48.95,31.15},{49.88,32.22},{47.99,33.67},{49.82,30.53},{54.07,30.51},{48.96,33.55},{46.89,31.07},{53.92,26.1},{52.61,35.36},{51.8,34.71},{51.12,33.78},{50.45,31.91},{47.38,28.47},{49.86,33.88},{47.21,31.91},{49.68,26.0},{48.79,29.1},{48.04,26.79},{37.61,78.84},{39.06,75.03},{39.89,76.39},{42.24,70.81},{38.38,76.6},{40.45,70.76},{42.45,69.04},{40.71,77.3},{52.71,27.89},{51.12,32.51},{50.43,30.27},{49.49,36.53},{50.57,29.27},{49.14,36.59},{49.4,34.95},{43.82,69.7},{52.66,26.15},{37.93,72.38},{38.21,73.73},{38.67,70.51}}},nil,148,nil,nil,189,"AH",nil,0},
[2323] = {'Giant Foreststrider',386,449,17,19,0,{[148]={{38.13,81.22},{43.34,82.21},{36.34,91.55},{34.78,88.05},{36.54,91.59},{44.91,91.78},{38.14,83.04},{36.48,94.28},{34.4,86.79},{37.05,88.17},{36.0,89.64},{37.75,89.11},{36.69,93.63},{44.61,91.56},{37.62,90.01},{37.0,94.59},{38.85,90.08},{35.83,80.03},{40.5,89.5},{43.2,80.19},{37.23,80.6},{37.86,89.83},{37.14,95.6},{35.93,89.1},{39.01,80.42},{38.53,92.29},{42.3,89.66},{45.97,91.36},{38.17,95.59},{40.07,91.89},{39.48,81.94},{36.88,92.79},{37.98,91.38},{40.46,93.56},{39.59,93.56},{37.01,83.59},{40.87,92.56},{37.05,81.59},{40.55,81.06},{39.57,94.62},{35.96,82.42},{37.56,92.93},{34.99,82.31},{40.6,92.01},{38.84,94.81},{39.1,91.29},{61.22,14.87},{61.64,14.21},{62.62,9.25},{61.82,11.95},{61.62,12.25},{42.26,80.47},{40.94,82.27},{60.87,10.31},{42.26,89.26},{41.2,83.31},{41.52,88.05},{61.62,8.89},{58.9,13.31},{58.41,14.21},{59.49,12.61}}},nil,148,nil,nil,7,"AH",nil,0},
[2324] = {'Blackwood Windtalker',273,300,13,14,0,{[148]={{39.36,56.68},{40.13,56.05},{39.92,54.37},{40.23,54.37},{39.94,55.51},{40.12,52.79},{39.75,56.14},{39.62,54.04},{39.06,52.63},{39.37,53.27},{39.53,53.59},{39.0,53.77},{40.12,53.84},{39.94,54.61}}},nil,148,nil,nil,82,nil,nil,0},
[2325] = {'Undead First Aid Trainer',42,42,1,1,0,nil,nil,0,nil,nil,68,"H","First Aid Trainer",0},
[2326] = {'Thamner Pol',156,156,8,8,0,{[1]={{47.18,52.61}}},nil,1,nil,nil,55,"A","Physician",19},
[2327] = {'Shaina Fuller',1342,1342,35,35,0,{[1519]={{43.06,26.16}}},nil,1519,nil,nil,12,"A","First Aid Trainer",17},
[2329] = {'Michelle Belle',222,222,11,11,0,{[12]={{43.39,65.55}}},nil,12,nil,nil,12,"A","Physician",17},
[2330] = {'Karlee Chaddis',712,712,25,25,0,{[1519]={{47.54,64.42}}},{[1519]={{{47.54,64.42},{47.09,64.86},{46.47,65.52},{46.17,66.01},{46.48,67.01},{46.33,67.45},{44.09,70.13},{43.63,70.0},{43.13,69.2},{42.1,69.28},{41.23,69.2},{40.14,69.93},{39.81,69.89},{38.46,69.09},{37.78,68.56},{36.58,68.02},{35.96,68.05},{34.79,68.89},{33.82,69.78},{32.17,71.46},{31.76,76.71},{30.84,78.49},{30.94,80.39},{31.79,81.83},{32.41,81.39},{32.74,80.55},{32.81,80.27},{32.42,80.05},{32.76,80.35},{32.68,80.75},{32.24,81.83},{31.93,81.84},{31.17,80.99},{30.88,80.3},{30.84,78.66},{30.92,78.22},{31.81,75.75},{32.24,71.6},{34.25,69.4},{34.93,68.69},{34.23,66.79},{33.3,64.27},{33.49,63.59},{32.73,62.0},{31.82,60.18},{31.86,59.83},{32.64,58.59},{33.03,58.41},{35.09,55.6},{36.23,54.43},{36.32,51.12},{36.8,50.55},{37.64,49.57},{38.63,48.36},{39.23,48.35},{40.65,49.87},{42.21,49.95},{43.53,48.9},{44.51,49.42},{45.74,50.58},{46.83,49.77},{48.24,48.47},{49.49,46.88},{47.33,42.7},{45.76,42.55},{44.16,39.66},{44.16,39.45},{46.11,36.52},{46.43,34.94},{47.85,33.56},{49.34,35.22},{50.83,33.78},{52.6,31.49},{51.4,28.75},{52.21,27.84},{53.42,26.64},{54.26,25.83},{54.86,26.53},{56.96,31.06},{56.95,31.77},{59.12,34.02},{61.02,34.09},{62.3,33.4},{63.23,35.09},{64.38,36.93},{64.22,37.71},{61.59,42.24},{61.6,44.04},{64.06,48.51},{63.68,48.91},{61.29,52.05},{60.62,52.01},{59.84,51.24},{57.49,54.79},{58.87,57.64},{55.83,61.78},{53.55,63.89},{52.25,60.9},{48.66,63.42}}}},1519,nil,nil,12,"A",nil,0},
[2331] = {'Paige Chaddis',42,42,1,1,0,{[1519]={{47.66,64.4}}},nil,1519,nil,nil,12,"A",nil,0},
[2332] = {'Valdred Moray',531,531,21,21,0,{[130]={{44.65,84.7}}},nil,130,nil,nil,123,"A",nil,0},
[2333] = {'Henchman Valik',1002,1002,30,30,0,{[36]={{57.17,69.51}}},nil,36,{535},{535},83,"H",nil,2},
[2334] = {'Event Generator 001',20,20,5,5,0,{[1519]={{61.65,61.95},{56.17,14.41},{56.15,14.57},{37.15,74.93}}},nil,1519,nil,nil,12,"A",nil,0},
[2335] = {'Magistrate Burnside',773,774,30,30,0,{[267]={{29.67,41.64}}},nil,267,nil,nil,88,"A",nil,0},
[2336] = {'Dark Strand Fanatic',356,386,16,17,0,{[148]={{55.78,26.16},{56.5,25.76},{55.75,25.91},{57.07,27.3},{56.14,25.41},{57.3,26.33},{56.84,27.56},{57.82,25.8},{57.87,25.61},{57.08,26.63},{57.02,26.2},{56.57,27.28},{55.8,26.97},{56.04,26.56},{56.19,27.04},{55.76,26.66},{56.78,26.86},{56.52,26.87},{56.94,26.46},{56.07,27.37},{56.55,26.52},{55.1,27.94},{54.98,27.72},{55.4,27.02},{55.2,26.55},{55.35,26.6}}},nil,148,nil,nil,16,nil,nil,0},
[2337] = {'Dark Strand Voidcaller',702,739,28,29,0,{[148]={{56.09,26.03},{56.23,25.82},{56.45,26.03},{56.27,25.92},{56.21,26.37},{56.13,25.66},{56.27,26.3}}},nil,148,nil,nil,16,nil,nil,0},
[2338] = {'Twilight Disciple',325,350,16,17,0,{[148]={{38.21,87.21},{38.24,86.33},{38.17,85.7},{39.5,88.05},{39.08,87.99},{38.74,85.35}}},nil,148,nil,nil,74,nil,nil,0},
[2339] = {'Twilight Thug',386,417,17,18,0,{[148]={{38.08,86.86},{38.03,86.23},{55.4,35.89},{55.49,35.96},{38.85,87.75},{39.34,87.65},{38.53,87.49},{39.43,85.65},{39.63,85.98},{39.28,85.2},{39.05,86.19},{39.14,86.57},{38.55,86.28},{38.47,86.09},{56.41,35.06},{56.55,35.13}}},nil,148,nil,nil,74,nil,nil,0},
[2344] = {'Dun Garok Mountaineer',2196,2319,28,29,1,{[267]={{69.04,78.17},{69.53,77.94},{68.87,79.54},{72.67,81.89},{71.07,80.4},{72.53,81.7},{72.79,81.32},{71.83,79.36},{70.52,79.73},{71.6,81.33},{71.58,79.57},{71.98,79.8},{71.16,80.64},{72.1,80.5},{72.39,81.09},{72.15,79.03},{72.66,79.92},{72.14,81.14},{72.55,79.62},{71.05,78.14},{71.54,78.68},{70.22,77.89},{70.37,77.22},{70.0,75.04},{70.14,72.61}}},nil,267,nil,nil,88,"A",nil,0},
[2345] = {'Dun Garok Rifleman',2715,2865,29,30,1,{[267]={{70.02,79.39},{71.54,75.08},{71.58,81.36},{70.12,78.45},{71.48,80.19},{72.62,80.23},{72.19,79.73},{71.49,78.59},{70.68,78.6},{69.97,76.53},{69.34,76.58},{71.3,74.23}}},nil,267,nil,nil,88,"A",nil,0},
[2346] = {'Dun Garok Priest',2319,2433,29,30,1,{[267]={{70.7,75.78},{71.78,80.45},{72.09,80.05},{72.66,80.67},{72.46,80.7},{71.09,78.97}}},nil,267,nil,nil,88,"A",nil,0},
[2347] = {'Wild Gryphon',1753,1753,40,40,0,{[267]={{78.7,34.86},{87.3,41.7}}},nil,267,nil,nil,15,"AH",nil,0},
[2348] = {'Elder Moss Creeper',788,840,26,27,0,{[267]={{66.36,77.6},{65.71,71.17},{63.37,70.84},{63.89,66.37},{62.78,72.24},{66.05,72.6},{63.94,73.57},{66.45,67.8},{69.19,60.47},{61.19,55.39},{73.24,67.92},{74.16,70.39},{60.72,68.59},{74.98,67.8},{59.38,55.5},{56.74,52.38},{60.16,52.72},{58.64,61.78},{60.41,57.93},{61.1,63.21},{72.52,69.49},{68.93,69.89},{66.6,72.8},{68.26,67.93},{61.96,53.96},{67.3,65.9}}},nil,267,nil,nil,22,nil,nil,0},
[2349] = {'Giant Moss Creeper',664,713,24,25,0,{[267]={{90.16,41.38},{23.49,53.98},{23.93,57.14},{24.7,58.57},{24.52,57.03},{29.12,32.27},{31.77,63.58},{32.03,64.67},{27.57,67.79},{26.56,33.34},{29.64,66.44},{33.04,66.01},{84.03,45.53},{73.49,63.11},{40.33,51.73},{38.44,55.51},{83.09,49.0},{80.58,52.12},{77.61,51.25},{84.53,50.39},{84.52,48.97},{79.01,31.74},{82.47,53.15},{86.86,45.61},{84.04,35.42},{88.1,41.3},{89.64,40.19},{40.17,49.62},{41.27,52.18},{85.56,36.13},{78.12,62.54},{32.91,52.72},{34.1,57.42},{60.87,47.84},{77.38,64.47},{33.8,63.19},{36.11,59.0},{66.09,57.04},{71.43,61.87},{23.51,50.98},{27.77,65.06},{76.45,59.9},{76.74,55.75},{71.26,20.7},{74.77,24.56},{32.15,62.68},{69.01,52.51},{70.25,52.05},{74.99,29.61},{73.49,53.8},{75.68,61.9},{66.7,58.79},{69.83,27.64},{69.47,32.14},{73.29,55.81},{75.33,33.96},{70.31,60.34},{62.95,55.62},{61.86,46.51},{63.71,44.76},{65.01,51.83},{73.02,50.46},{71.4,50.27},{28.51,28.69},{26.18,36.87},{26.07,35.27},{27.68,50.73},{26.63,49.03},{41.25,65.24},{78.4,60.62},{36.84,55.92},{68.72,48.87},{36.89,54.23},{38.07,51.58},{27.54,54.06},{35.71,56.66},{64.07,49.14},{81.47,31.98},{68.33,36.66},{30.97,61.27},{34.8,54.08},{72.06,21.05},{28.96,63.26},{33.32,64.95},{29.71,54.25},{29.2,56.49},{44.63,61.57},{32.73,55.8},{36.38,63.45},{40.28,58.31},{38.61,65.47},{39.56,59.86},{31.71,58.85},{42.67,61.13},{40.89,64.41},{34.59,29.59},{36.91,29.04},{67.21,55.62},{75.75,54.06},{64.92,57.84},{67.31,38.16},{28.7,54.15},{42.45,59.35},{37.04,33.17},{27.51,31.21}},[36]={{14.57,81.68},{18.39,91.81},{25.56,66.01},{23.7,56.58},{25.89,74.3},{14.56,86.27},{26.23,76.22},{26.55,83.61},{24.19,79.15},{24.15,87.98},{24.91,79.59},{23.35,77.73},{22.37,73.39},{28.84,79.46},{30.09,78.2},{22.57,82.03},{27.67,69.87},{28.46,73.52},{25.02,63.32},{15.79,88.77}}},nil,267,nil,nil,22,nil,nil,0},
[2350] = {'Forest Moss Creeper',494,531,20,21,0,{[267]={{18.12,52.92},{78.55,50.59},{19.66,53.43},{22.99,53.54},{71.77,41.16},{21.2,51.84},{20.52,43.43},{26.57,38.88},{27.83,38.88},{70.78,38.15},{71.41,36.62},{25.65,39.28},{23.55,43.07},{63.88,10.68},{68.34,13.33},{67.54,10.22},{70.06,8.98},{67.22,9.59},{62.62,13.7},{63.69,14.34},{59.38,13.68},{60.85,14.84},{56.51,9.96},{53.76,13.59},{56.65,16.86},{63.24,39.34},{65.68,27.23},{65.17,25.58},{57.11,13.53},{71.87,34.17},{63.3,36.3},{64.5,32.03},{61.04,38.16},{62.16,39.81},{61.79,31.45},{70.42,44.61},{59.56,35.19},{66.13,21.41},{57.81,24.2},{19.08,47.76},{58.06,28.91},{56.55,30.06},{59.0,35.34},{53.84,14.42}}},nil,267,nil,nil,22,nil,nil,0},
[2351] = {'Gray Bear',677,731,21,22,0,{[267]={{64.05,8.55},{19.95,52.23},{22.0,56.46},{20.19,53.57},{21.53,42.77},{23.35,43.9},{26.39,41.84},{24.41,40.07},{26.68,41.61},{26.29,38.24},{18.87,43.59},{19.01,49.85},{63.21,11.45},{68.77,9.48},{68.25,11.99},{66.8,15.73},{57.62,15.07},{56.16,8.61},{54.78,13.35},{55.4,15.99},{66.9,28.87},{67.01,23.0},{66.12,23.07},{67.18,26.01},{17.28,44.78},{64.4,37.79},{30.7,48.07},{66.47,34.25},{64.35,28.75},{57.63,23.63},{56.88,28.13},{59.07,32.75},{57.79,28.29},{61.51,35.96},{59.51,36.55},{64.35,33.97},{63.09,30.15},{65.39,35.93},{59.8,30.93},{67.08,19.47},{62.04,36.32},{58.08,34.06},{23.37,48.2},{57.03,28.98},{63.18,6.36}},[36]={{51.85,69.12}}},nil,267,nil,nil,14,nil,nil,0},
[2352] = {'Innkeeper Anderson',1002,1002,30,30,0,{[267]={{51.17,58.93}}},nil,267,nil,nil,12,"A","Innkeeper",135},
[2354] = {'Vicious Gray Bear',742,799,22,23,0,{[267]={{53.11,47.87},{54.85,46.43},{54.85,52.45},{76.5,49.11},{71.06,34.91},{74.05,34.47},{70.5,33.53},{52.31,46.04},{54.86,39.54},{56.87,40.32},{56.28,43.17},{45.71,46.78},{46.55,47.22},{53.32,42.47},{40.4,44.75},{40.89,39.49},{38.5,37.74},{40.58,42.61},{44.53,50.71},{49.94,33.49},{70.14,35.49},{48.58,46.24},{51.45,37.78},{49.08,36.97},{45.37,40.34},{46.53,38.76},{44.25,41.37},{49.85,44.68},{66.48,39.51},{49.24,43.03},{51.99,33.16},{40.11,36.77},{41.09,37.15},{56.62,39.55},{54.43,42.15},{41.04,34.46},{48.13,47.16},{38.79,41.83},{47.78,36.41},{45.35,34.88},{51.47,31.53},{52.94,30.87},{44.58,38.57},{44.68,37.09},{45.52,43.62}}},nil,267,nil,nil,44,nil,nil,0},
[2356] = {'Elder Gray Bear',944,1013,25,26,0,{[267]={{89.65,42.72},{78.5,50.5},{28.62,29.6},{85.62,47.55},{28.86,66.11},{27.0,34.26},{77.05,66.49},{29.57,65.58},{83.47,46.82},{82.93,36.63},{81.52,35.59},{79.33,36.07},{80.19,35.74},{81.84,52.43},{82.22,51.98},{77.84,55.13},{39.81,56.68},{29.45,32.23},{78.65,52.34},{35.29,61.55},{37.6,58.37},{35.03,64.37},{85.79,39.15},{87.79,39.8},{84.73,33.35},{34.49,56.61},{63.14,50.31},{85.04,35.2},{83.47,53.98},{89.99,43.19},{25.74,54.16},{30.58,65.18},{40.1,57.13},{71.93,66.88},{24.56,52.12},{72.24,65.58},{88.42,41.53},{69.36,28.97},{26.54,52.38},{25.19,51.32},{33.12,64.47},{72.14,52.66},{70.99,62.42},{87.69,40.94},{72.98,61.94},{73.42,22.62},{63.03,46.09},{74.77,52.4},{74.85,66.67},{26.7,36.29},{76.62,31.78},{70.26,21.97},{79.26,58.84},{70.68,22.39},{38.14,49.43},{38.96,50.64},{87.07,35.89},{34.88,54.3},{24.23,57.72},{36.14,50.9},{68.06,61.45},{62.38,48.94},{65.27,47.61},{78.58,32.85},{70.45,25.75},{37.71,65.69},{30.48,56.5},{29.35,55.4},{38.98,53.24},{74.79,27.46},{30.63,52.62},{29.42,62.92},{42.99,63.46},{42.96,52.38},{44.99,57.64},{87.04,37.93},{32.41,55.33},{37.2,30.83},{74.52,33.49},{41.58,58.34},{45.19,60.06},{73.78,29.55},{77.34,30.67},{63.42,48.26},{73.66,59.87},{75.05,57.47},{35.91,33.54},{70.25,50.67},{38.25,62.83},{46.74,56.41},{40.15,61.01},{34.91,60.2},{28.77,52.34},{41.2,47.72},{42.35,47.48},{28.21,30.83}},[36]={{23.33,75.98},{25.04,64.68},{23.76,82.8},{24.81,77.1},{28.28,69.09},{26.35,78.01},{26.91,81.93},{24.79,59.44},{21.63,72.99},{24.69,81.09},{21.31,75.7},{15.43,83.24},{21.24,69.14}}},nil,267,nil,nil,44,nil,nil,0},
[2357] = {'Merideth Carlson',1162,1162,32,32,0,{[267]={{52.19,55.48}}},nil,267,{7645},{7645},12,"A","Horse Breeder",7},
[2358] = {'Dalaran Summoner',954,992,34,35,0,{[36]={{22.37,60.41},{18.79,77.12},{21.98,57.94},{19.63,57.82},{18.38,74.09},{18.88,74.92},{11.51,75.88},{10.95,78.67},{15.92,75.52},{15.12,76.41},{12.9,76.31},{17.88,76.16},{19.66,75.39},{21.33,63.78},{21.74,61.21},{20.72,54.27},{21.4,56.39},{19.4,54.98},{20.21,59.27},{14.98,78.56}}},nil,36,nil,nil,76,"AH",nil,0},
[2359] = {'Elemental Slave',1221,1279,33,34,0,{[36]={{22.91,59.49},{22.41,58.63},{19.01,57.74},{10.12,78.2},{12.41,76.99},{16.2,78.51},{11.79,74.53},{19.03,76.96},{15.14,77.23},{16.78,76.14},{19.91,76.17},{19.26,73.5},{21.78,64.34},{20.77,60.51},{23.07,60.36},{21.91,55.82},{19.95,54.05},{20.32,56.47},{18.38,55.92},{19.96,56.55},{21.61,61.88},{10.77,80.58}}},nil,36,nil,nil,76,"AH",nil,0},
[2360] = {'Hillsbrad Farmhand',573,617,22,23,0,{[267]={{36.82,39.58},{36.78,41.34},{35.85,40.9},{34.84,40.57},{35.06,40.09},{35.2,41.32},{33.84,40.98},{33.83,40.09},{33.77,41.56},{35.6,39.69},{35.26,38.34},{34.36,41.26},{35.16,37.7},{33.36,35.55},{31.83,35.11},{30.79,36.51},{31.66,38.15},{32.21,36.17},{29.86,37.31},{30.47,37.69},{31.39,39.55},{30.19,38.08},{30.41,36.93}}},nil,267,nil,nil,123,"A",nil,0},
[2361] = {'Tamara Armstrong',328,328,15,15,0,{[267]={{50.92,58.43}}},nil,267,nil,nil,11,"A",nil,2},
[2362] = {'Hemmit Armstrong',328,328,15,15,0,{[267]={{50.87,58.56}}},nil,267,nil,nil,11,"A",nil,2},
[2363] = {'Apprentice Honeywell',950,950,29,29,0,{[267]={{50.84,56.91}}},nil,267,nil,nil,11,"A",nil,2},
[2364] = {'Neema',1221,1221,33,33,0,{[267]={{51.13,59.24}}},nil,267,nil,nil,12,"A","Waitress",6},
[2365] = {'Bront Coldcleave',1677,1677,39,39,0,{[267]={{48.75,57.2}}},nil,267,nil,nil,12,"A","Butcher",6},
[2366] = {'Barkeep Kelly',1752,1752,40,40,0,{[267]={{51.57,58.57}}},nil,267,nil,nil,12,"A","Bartender",6},
[2367] = {'Donald Rabonne',1106,1106,31,31,0,{[267]={{50.78,61.03}}},nil,267,nil,nil,12,"A","Fisherman",19},
[2368] = {'Daggerspine Shorestalker',896,950,28,29,0,{[267]={{63.99,82.12},{67.03,86.55},{61.03,77.49},{61.66,78.64},{67.22,87.08},{66.05,85.29},{66.53,86.35},{65.03,80.34},{66.93,80.07},{66.0,82.23},{66.29,79.56},{66.44,83.28},{64.04,78.53},{61.53,76.37},{65.85,83.56},{60.09,75.65},{61.88,76.2},{64.43,77.45}}},nil,267,nil,nil,74,nil,nil,0},
[2369] = {'Daggerspine Shorehunter',1050,1107,30,31,0,{[267]={{58.9,77.56},{55.89,72.28},{57.8,75.95},{59.79,71.97},{58.73,74.01},{58.3,72.63},{60.57,74.73},{51.7,66.15},{52.73,65.51},{57.74,66.3},{54.48,64.37},{58.16,70.01},{57.84,69.11},{54.68,68.44},{53.7,66.75},{55.87,66.59},{53.7,63.47}}},nil,267,nil,nil,74,nil,nil,0},
[2370] = {'Daggerspine Screamer',812,852,29,30,0,{[267]={{60.77,80.9},{65.43,86.28},{66.82,86.12},{60.01,78.89},{62.94,84.11},{63.85,85.22},{66.72,80.44},{65.4,80.1},{66.51,82.88},{62.79,77.29},{64.12,76.71},{63.77,76.94}}},nil,267,nil,nil,74,nil,nil,0},
[2371] = {'Daggerspine Siren',935,977,31,32,0,{[267]={{57.03,77.33},{61.66,81.82},{56.91,73.77},{60.14,73.28},{55.95,69.87},{56.89,71.11},{57.24,68.35},{58.89,70.22},{58.37,68.61},{59.03,71.54},{54.39,61.98},{56.3,65.0},{55.2,61.43},{55.32,63.84},{56.53,66.2},{57.91,65.05},{58.69,66.03},{58.59,66.53},{53.21,64.23}}},nil,267,nil,nil,74,nil,nil,0},
[2372] = {'Mudsnout Gnoll',788,840,26,27,0,{[267]={{63.57,65.06},{64.65,65.64},{62.47,62.67},{65.0,63.12},{63.33,62.7},{62.54,61.84},{63.96,63.2},{61.95,62.92},{63.31,59.35},{62.17,61.55},{64.11,60.33},{64.95,61.83}}},nil,267,nil,nil,95,nil,nil,0},
[2373] = {'Mudsnout Shaman',665,702,27,28,0,{[267]={{62.96,63.71},{62.55,63.55},{63.25,61.63},{64.13,61.92},{63.72,59.22},{65.42,60.35},{62.93,62.22},{66.27,61.1}}},nil,267,nil,nil,95,nil,nil,0},
[2374] = {'Torn Fin Muckdweller',895,950,28,29,0,{[267]={{26.52,74.12},{25.6,76.43},{25.32,72.79},{33.86,72.8},{21.23,66.7},{23.44,72.69},{20.44,64.62},{24.54,64.95},{23.17,64.21},{24.63,66.18},{23.47,64.78},{32.98,72.54},{32.13,72.38},{25.06,70.48},{32.46,72.81},{25.34,71.2},{26.13,71.68},{30.12,73.9},{29.78,73.6},{27.9,72.49},{33.06,70.01}}},nil,267,nil,nil,18,nil,nil,0},
[2375] = {'Torn Fin Coastrunner',950,1002,29,30,0,{[267]={{35.05,73.98},{34.56,70.72},{29.81,76.01},{30.87,74.21},{31.93,76.28},{22.11,68.46},{22.38,70.85},{24.22,69.43},{24.02,74.55},{28.51,74.18},{26.9,75.88},{23.11,64.36},{22.11,64.01},{23.74,66.34},{24.44,64.78},{32.67,72.29},{32.9,71.37},{25.14,69.49},{25.59,70.7},{32.67,74.36},{24.39,70.86},{24.83,67.23},{30.31,73.3},{24.58,70.41},{31.75,72.9},{27.57,72.43},{28.05,72.85},{26.98,71.79},{29.8,72.77},{33.29,69.74},{33.86,69.62}}},nil,267,nil,nil,18,nil,nil,0},
[2376] = {'Torn Fin Oracle',892,935,30,31,0,{[267]={{38.02,72.83},{40.4,71.23},{36.53,69.41},{48.29,66.37},{43.95,68.65},{44.15,71.11},{47.15,68.34},{36.06,68.74},{46.14,69.13},{35.68,66.4},{37.39,66.18},{37.24,69.14},{44.37,66.47},{45.98,66.75},{45.05,67.38},{44.34,67.87},{42.73,69.21},{40.88,68.81},{40.68,69.22},{46.25,63.04}}},nil,267,nil,nil,18,nil,nil,0},
[2377] = {'Torn Fin Tidehunter',935,976,31,32,0,{[267]={{42.69,70.71},{42.49,72.62},{38.58,71.12},{36.18,70.22},{49.4,67.63},{37.33,70.27},{39.95,72.82},{36.37,69.61},{40.33,68.82},{48.62,64.41},{46.42,66.47},{43.93,67.15},{44.62,66.99},{43.36,68.2},{41.11,67.95},{45.01,68.56},{40.67,69.86},{41.02,69.49},{47.4,64.7},{46.03,63.96}}},nil,267,nil,nil,18,nil,nil,0},
[2378] = {'Kundric Zanden',1279,1279,34,34,0,{[267]={{48.64,59.01}}},nil,267,nil,nil,11,"A","Town Historian",2},
[2379] = {'Caretaker Smithers',1342,1342,35,35,0,{[267]={{51.28,51.86}}},nil,267,nil,nil,12,"A",nil,2},
[2380] = {'Nandar Branson',1279,1279,34,34,0,{[267]={{50.93,57.1}}},nil,267,nil,nil,12,"A","Alchemy Supplies",6},
[2381] = {'Micha Yance',1752,1752,40,40,0,{[267]={{48.94,55.03}}},nil,267,nil,nil,12,"A","Trade Goods",6},
[2382] = {'Darren Malvew',1002,1002,30,30,0,{[267]={{52.42,55.96}}},nil,267,{564},{564},12,"A","Stablehand",2},
[2383] = {'Lindea Rabonne',950,950,29,29,0,{[267]={{50.63,60.95}}},nil,267,nil,nil,12,"A","Tackle and Bait",6},
[2384] = {'Starving Mountain Lion',617,664,23,24,0,{[267]={{55.96,50.43},{50.01,41.23},{58.9,40.41},{47.61,26.09},{37.8,36.21},{49.75,30.89},{39.59,34.85},{53.42,39.28},{52.89,48.87},{53.6,36.42},{52.45,35.86},{54.68,31.22},{52.65,31.86},{39.04,38.21},{54.97,26.31},{51.87,44.7},{51.61,41.7},{54.31,42.94},{54.33,39.65},{55.67,42.06},{53.55,39.87},{55.62,44.43},{39.3,37.83},{57.78,41.59},{54.57,29.0},{53.87,44.31},{53.29,36.72},{54.5,32.17},{39.76,40.56},{44.54,48.85},{39.04,46.73},{50.21,31.76},{48.63,34.49},{42.52,40.36},{52.82,32.21},{44.62,45.85},{42.94,35.42},{37.95,44.46},{53.36,36.07},{38.99,45.64},{55.97,25.75},{50.99,35.46}}},nil,267,nil,nil,14,nil,nil,0},
[2385] = {'Feral Mountain Lion',840,896,27,28,0,{[267]={{65.09,72.99},{62.62,71.43},{64.87,69.26},{64.98,66.4},{66.33,75.32},{61.79,69.02},{67.97,80.87},{57.68,59.31},{58.98,56.53},{56.7,60.08},{60.16,58.47},{66.26,74.09},{57.56,49.97},{61.14,66.86},{70.35,67.98},{60.98,50.92},{58.52,55.59},{63.59,67.96}}},nil,267,nil,nil,14,nil,nil,0},
[2386] = {'Southshore Guard',3267,3267,55,55,0,{[267]={{47.52,60.18},{51.88,57.39},{47.49,56.58},{48.41,56.31},{46.85,50.16},{49.39,59.49},{53.24,58.23},{51.48,60.44},{49.54,62.17},{49.01,58.14},{48.73,59.85},{49.61,49.0},{52.05,56.17},{48.63,52.8},{46.58,50.54},{46.79,51.49},{47.2,49.9},{46.76,52.22},{52.26,51.17},{49.91,55.04},{49.75,52.51},{50.22,60.52},{51.88,50.5},{49.32,56.14},{50.13,58.32},{50.37,50.97},{53.92,54.19},{54.89,56.91},{51.56,55.37},{54.73,53.79}},[36]={{39.42,81.45},{40.54,79.58}}},nil,267,nil,nil,11,"A",nil,0},
[2387] = {'Hillsbrad Councilman',590,628,25,26,0,{[267]={{29.59,39.72},{30.15,41.12},{32.38,46.42},{30.24,43.55},{29.47,43.14},{30.13,42.89},{30.19,42.16},{32.06,42.43},{29.3,40.88}}},nil,267,nil,nil,123,"A",nil,0},
[2388] = {'Innkeeper Shay',1002,1002,30,30,0,{[267]={{62.78,19.03}}},nil,267,nil,nil,68,"H","Innkeeper",135},
[2389] = {'Zarise',7842,7842,55,55,1,{[267]={{60.14,18.62}}},nil,267,nil,nil,68,"H","Bat Handler",11},
[2390] = {'Aranae Venomblood',950,950,29,29,0,{[267]={{61.71,19.52}}},nil,267,nil,nil,68,"H","Herbalist",19},
[2391] = {'Serge Hinott',1162,1162,32,32,0,{[267]={{61.63,19.19}}},nil,267,{2480},{2479,2480},68,"H","Expert Alchemist",19},
[2392] = {'Delia Verana',1162,1162,32,32,0,{[267]={{62.6,19.43}}},nil,267,nil,nil,71,"H",nil,0},
[2393] = {'Christoph Jeffcoat',1162,1162,32,32,0,{[267]={{62.29,19.04}}},nil,267,{7321},{7321},68,"H","Tradesman",7},
[2394] = {'Mallen Swain',1162,1162,32,32,0,{[267]={{61.9,20.98}}},nil,267,nil,nil,68,"H","Tailoring Supplies",6},
[2395] = {'Vinna Wayne',1162,1162,32,32,0,{[267]={{63.33,19.87}}},nil,267,nil,nil,68,"H",nil,0},
[2396] = {'Hans Zandin',1162,1162,32,32,0,{[267]={{61.33,24.41}}},{[267]={{{61.31,24.17},{61.18,24.94},{61.65,25.29},{61.72,24.39},{61.58,23.82},{61.3,23.21},{60.77,23.04},{60.67,23.31},{61.09,23.62}}}},267,nil,nil,71,"H",nil,0},
[2397] = {'Derak Nightfall',1162,1162,32,32,0,{[267]={{63.09,19.41}}},nil,267,nil,nil,68,"H","Cook",5},
[2398] = {'Tara Coldgaze',1162,1162,32,32,0,{[267]={{61.62,26.58}}},nil,267,nil,nil,71,"H",nil,0},
[2399] = {'Daryl Stack',3643,3643,56,56,0,{[267]={{63.75,20.79}}},nil,267,nil,nil,68,"H","Master Tailor",19},
[2400] = {'Craig Hewitt',1162,1162,32,32,0,{[267]={{61.26,26.36}}},nil,267,nil,nil,71,"H",nil,0},
[2401] = {'Kayren Soothallow',1002,1002,30,30,0,{[267]={{62.56,19.91}}},nil,267,nil,nil,68,"H","General Goods",6},
[2402] = {'Shara Blazen',1162,1162,32,32,0,{[267]={{63.66,21.16}}},nil,267,nil,nil,68,"H",nil,0},
[2403] = {'Farmer Getz',664,664,24,24,0,{[267]={{36.73,39.44}}},nil,267,nil,nil,88,"A",nil,0},
[2404] = {'Blacksmith Verringtan',788,788,26,26,0,{[267]={{32.11,44.42}}},nil,267,nil,nil,88,"A",nil,16388},
[2405] = {'Tarren Mill Deathguard',4430,4430,50,50,0,{[267]={{61.69,27.6},{61.53,27.29},{62.71,19.27},{62.58,19.17},{59.55,24.34},{62.81,22.31},{64.03,22.34},{65.35,20.66},{63.57,21.66},{65.55,18.36},{63.99,17.52},{60.8,17.75},{60.36,26.08},{62.25,26.24},{62.03,22.7},{62.11,21.68},{61.81,20.76},{61.32,19.74},{61.21,21.66},{61.38,17.88},{59.74,18.48},{61.36,20.31},{62.11,18.69},{59.87,18.85},{58.41,21.87},{61.45,19.9},{61.46,19.98},{58.89,19.36}},[36]={{62.45,58.91},{63.76,60.96},{61.88,58.83},{63.72,60.69}}},nil,267,nil,nil,71,"H",nil,1},
[2406] = {'Mountain Lion',1163,1221,32,33,0,{[36]={{64.71,48.64},{76.69,51.29},{78.7,50.09},{74.1,59.79},{83.12,58.17},{30.55,88.32},{29.71,86.56},{32.54,79.55},{33.02,80.06},{29.67,74.55},{29.43,70.37},{31.14,72.23},{29.68,84.71},{29.94,77.13},{31.74,81.14},{30.58,78.93},{33.64,83.9},{35.29,84.17},{49.05,75.2},{37.51,88.68},{39.35,88.11},{37.02,86.37},{38.2,91.93},{42.78,78.54},{40.34,91.87},{32.15,82.81},{35.93,84.76},{34.36,82.92}},[267]={{38.8,24.62}}},nil,36,nil,nil,14,nil,nil,0},
[2407] = {'Hulking Mountain Lion',1221,1279,33,34,0,{[36]={{52.76,30.65},{66.75,51.11},{51.75,23.72},{82.57,58.55},{75.55,51.67},{45.28,23.72},{74.4,54.72},{81.41,48.83},{78.39,52.91},{83.14,61.07},{83.2,64.86},{38.13,24.84},{39.6,25.77},{52.5,24.66},{56.19,32.72},{50.43,22.73},{48.88,83.09},{53.61,31.57},{53.51,30.56},{45.53,19.39},{44.21,76.66},{45.7,77.72},{43.7,80.72},{39.57,92.34},{30.92,84.74},{37.12,90.07},{39.82,84.69}}},nil,36,nil,nil,14,nil,nil,0},
[2408] = {'Snapjaw',1050,1107,30,31,0,{[36]={{72.49,68.57},{31.67,13.22},{29.7,7.89},{14.22,53.03},{19.88,46.77},{17.63,50.49},{35.93,21.73},{35.79,23.28},{33.38,11.92},{34.34,25.93},{90.81,45.88},{17.67,49.66},{36.63,20.12},{26.33,40.48},{21.19,45.85},{35.79,13.47},{10.57,54.52},{16.69,50.7},{35.45,25.75},{33.37,26.9},{29.13,38.45},{25.16,42.27},{27.91,40.29},{16.49,52.16},{15.3,52.61},{14.01,55.02},{12.38,54.7},{12.9,54.63},{31.9,30.03},{34.24,27.53},{32.91,29.26},{29.69,34.79},{31.13,35.44},{30.81,36.37},{30.67,31.99},{31.23,33.7},{29.71,37.05},{89.25,47.02},{82.93,52.43},{80.91,55.86},{82.68,53.91},{80.28,57.89},{80.28,58.69},{84.83,51.28},{86.95,48.83},{79.59,59.32},{77.21,63.18},{76.41,64.12},{28.77,39.67},{29.7,37.98},{36.82,19.04},{17.7,52.78},{19.31,49.64},{18.96,50.58},{20.23,49.05},{23.56,45.37},{24.16,43.79},{21.25,47.32},{22.86,45.81},{24.84,43.7},{31.9,31.35},{26.74,42.57},{72.77,68.04},{73.6,66.16},{74.98,65.04},{78.76,62.56},{29.41,8.05}},[267]={{68.11,28.94},{67.75,35.34},{67.75,32.01},{68.08,19.23},{68.29,16.93},{69.11,13.59},{68.41,25.66},{67.95,22.95},{66.06,38.25},{55.91,57.08},{56.39,50.59},{55.94,53.95},{61.69,42.82},{59.22,45.06},{56.83,47.22},{63.93,39.68}}},nil,36,nil,nil,7,"AH",nil,0},
[2409] = {'Felicia Maline',7842,7842,55,55,1,{[10]={{77.49,44.29}}},nil,10,nil,nil,12,"A","Gryphon Master",11},
[2410] = {'Magus Wordeen Voidglare',1981,1981,42,42,0,{[267]={{61.6,20.85}}},nil,267,{544,545},{544,545},68,"H",nil,2},
[2411] = {'Ricter',1221,1221,33,33,0,{[36]={{20.16,84.28}}},nil,36,nil,nil,7,"AH",nil,0},
[2412] = {'Alina',1221,1221,33,33,0,{[36]={{20.34,86.4}}},nil,36,nil,nil,7,"AH",nil,0},
[2413] = {'Dermot',1279,1279,34,34,0,{[36]={{19.91,85.97}}},nil,36,nil,nil,7,"AH",nil,0},
[2414] = {'Kegan Darkmar',1342,1342,35,35,0,{[36]={{17.8,83.2}}},nil,36,nil,nil,7,"AH",nil,0},
[2415] = {'Warden Belamoore',1075,1075,36,36,0,{[36]={{17.75,82.98}}},nil,36,nil,nil,76,"AH",nil,0},
[2416] = {'Crushridge Plunderer',3831,4008,36,37,1,{[36]={{37.16,54.61},{37.15,54.2}}},nil,36,nil,nil,45,nil,nil,0},
[2417] = {'Grel\'borg the Miser',3540,3540,39,39,1,{[36]={{35.58,54.42}}},{[36]={{{35.21,54.18},{35.71,53.79},{35.92,54.19},{36.25,55.08},{36.67,54.81},{36.27,53.73},{37.47,52.78},{38.27,52.85},{38.96,51.42},{39.31,50.96},{39.35,50.4},{39.76,48.85},{40.14,47.24},{40.91,46.29},{40.25,46.14},{40.13,47.74},{39.24,51.14},{38.71,51.72},{38.11,52.73},{37.47,52.75},{36.29,53.74},{35.91,52.73},{35.51,52.99},{35.78,53.74},{35.23,54.18},{35.31,54.37},{35.59,54.42}}}},36,nil,nil,45,nil,nil,0},
[2418] = {'Deathguard Samsa',2114,2114,32,32,0,{[267]={{62.11,19.7}}},nil,267,{546},{546},68,"H",nil,2},
[2419] = {'Deathguard Humbert',2114,2114,32,32,0,{[267]={{62.76,20.21}}},nil,267,{547},{547},68,"H",nil,2},
[2420] = {'Targ',7925,7925,41,41,1,{[36]={{39.57,52.89}}},nil,36,nil,nil,45,nil,nil,0},
[2421] = {'Muckrake',4572,4572,40,40,1,{[36]={{38.65,46.75}}},nil,36,nil,nil,45,nil,nil,0},
[2422] = {'Glommus',4377,4377,39,39,1,{[36]={{39.5,41.82}}},nil,36,nil,nil,45,nil,nil,0},
[2423] = {'Lord Aliden Perenolde',1522,1522,41,41,0,{[36]={{39.32,14.58}}},nil,36,nil,nil,16,nil,nil,0},
[2424] = {'Test Banker',4370,4370,62,62,0,nil,nil,0,nil,nil,55,"A",nil,0},
[2425] = {'Varimathras',518000,518000,62,62,3,{[1497]={{56.25,92.2}}},nil,1497,{1048,5725,6145,6521},{550,1048,1978,5725,6144,6521,6522},68,"H",nil,3},
[2427] = {'Jailor Eston',664,664,24,24,0,{[267]={{79.6,41.83}}},nil,267,nil,nil,16,nil,nil,0},
[2428] = {'Jailor Marlgen',664,664,24,24,0,{[267]={{79.49,40.57}}},nil,267,nil,nil,16,nil,nil,0},
[2429] = {'Novice Thaivand',1002,1002,30,30,0,{[267]={{63.88,19.66}}},nil,267,{552,553},{552},68,"H",nil,2},
[2430] = {'Chef Jessen',1342,1342,35,35,0,{[267]={{51.89,58.68}}},nil,267,{555},{555},12,"A",nil,2},
[2431] = {'Jailor Borhuin',1536,1536,37,37,0,{[36]={{63.14,43.42}}},nil,36,nil,nil,16,nil,nil,0},
[2432] = {'Darla Harris',7842,7842,55,55,1,{[267]={{49.34,52.27}}},nil,267,nil,nil,12,"A","Gryphon Master",11},
[2433] = {'Helcular\'s Remains',4278,4278,44,44,1,nil,nil,0,nil,nil,83,"H",nil,2},
[2434] = {'Shadowy Assassin',1536,1604,37,38,0,nil,nil,0,nil,nil,108,"AH",nil,2},
[2435] = {'Southshore Crier',1162,1162,32,32,0,nil,nil,0,nil,nil,96,"A",nil,0},
[2436] = {'Farmer Kent',712,712,25,25,0,{[267]={{53.5,58.21}}},{[267]={{{53.5,58.21},{53.19,57.74},{52.84,57.17},{52.53,56.86},{52.24,56.81},{52.04,56.97},{51.84,57.18},{51.73,57.16},{51.65,56.93},{51.56,56.4},{51.37,56.24},{50.97,56.33},{50.59,56.51},{50.5,56.74},{50.45,57.14},{50.16,57.71},{49.86,57.99},{49.76,57.93},{49.73,57.63},{49.75,57.17},{50.0,56.54},{50.26,55.8},{50.42,55.24},{50.44,54.61},{50.28,54.37},{49.98,54.4},{49.76,54.51},{49.94,54.41},{50.25,54.36},{50.36,54.62},{50.27,55.19},{50.13,55.7},{49.85,56.39},{49.61,57.12},{49.61,57.46},{49.41,57.68},{49.25,57.82},{49.09,57.95},{49.37,57.7},{49.59,57.77},{49.66,58.04},{49.92,58.79},{50.2,59.69},{50.2,60.54},{50.13,61.59},{50.2,60.58},{50.2,59.74},{49.95,58.84},{49.8,58.28},{49.93,58.09},{50.19,57.75},{50.43,57.19},{50.51,56.66},{50.98,56.43},{51.36,56.31},{51.5,56.51},{51.59,56.94},{51.7,57.11},{51.98,57.0},{52.18,56.84},{52.48,56.83},{52.81,57.12},{53.15,57.68}}}},267,nil,nil,96,"A",nil,0},
[2437] = {'Keeper Bel\'varil',1279,1279,34,34,0,{[267]={{61.5,20.93}}},nil,267,{556,557},{556,557},68,"H",nil,2},
[2438] = {'Bartolo Ginsetti',1162,1162,32,32,0,{[267]={{49.43,55.53}}},nil,267,{565},{565},12,"A",nil,2},
[2439] = {'Major Samuelson',2768,2768,50,50,0,{[1519]={{72.57,15.88}}},nil,1519,nil,{563},12,"A","Stormwind City Guard",3},
[2440] = {'Drunken Footpad',1162,1221,32,33,0,{[36]={{59.3,69.76},{58.66,67.21}}},nil,36,nil,nil,16,nil,nil,0},
[2442] = {'Cow',1,1,1,1,0,{[45]={{32.65,28.39},{32.05,29.51},{32.68,29.49},{32.22,28.57},{32.31,28.02},{32.56,28.66}},[267]={{53.61,56.86},{54.15,56.48},{53.72,55.74},{54.09,55.8},{36.81,40.09},{35.0,37.88},{32.99,36.26},{36.88,45.39},{31.6,34.63},{34.98,37.51}},[44]={{24.73,58.84}},[12]={{62.77,78.27},{31.83,54.02},{36.77,55.55},{43.85,53.07},{43.84,52.62},{45.95,55.6},{32.14,54.92},{34.95,60.25},{37.71,63.68},{35.64,63.51},{29.06,69.47},{33.58,75.02},{28.54,73.62},{26.62,75.53},{22.59,76.6},{30.75,88.41},{31.38,77.25},{38.04,88.56},{46.47,76.15},{53.61,74.64},{53.17,70.97},{54.49,76.86},{54.4,79.28},{56.48,74.21},{56.92,71.19},{65.23,78.75},{70.93,82.91},{74.4,67.46},{71.8,66.69},{71.22,61.91},{69.16,60.8},{66.56,66.84},{61.92,70.98},{61.74,71.13},{61.16,57.6},{59.93,69.39},{47.24,58.6},{67.13,43.99},{70.5,40.35},{77.11,71.19},{80.0,77.15},{79.98,58.67},{77.68,61.3},{86.8,70.94},{86.88,65.84},{86.33,65.17}},[40]={{59.61,23.69},{59.65,14.89}},[11]={{19.3,69.14},{20.34,68.7},{20.74,69.22}}},nil,12,nil,nil,190,"AH",nil,0},
[2447] = {'Narillasanz',12121,12121,44,44,2,{[36]={{73.71,65.35}}},{[36]={{{73.66,65.44},{73.24,65.89},{72.78,66.38},{72.18,66.87},{71.63,67.65}},{{64.43,62.45},{64.03,62.12},{63.46,62.29},{62.98,62.29},{62.4,62.18},{61.73,62.0},{61.1,61.73},{60.57,61.3},{59.94,60.85},{59.42,60.67},{58.68,60.39},{58.06,60.61},{57.56,61.07},{57.25,62.33},{57.09,63.31},{56.66,64.43},{55.98,64.87},{55.36,65.3},{54.72,65.23},{54.0,65.01},{53.31,64.89},{52.51,64.49},{51.67,64.22},{51.31,64.21},{51.02,64.71},{50.77,65.09},{50.29,65.16},{49.71,65.38},{49.43,65.99},{49.28,66.99},{49.36,67.33},{49.6,67.73},{49.48,68.67},{49.37,69.4},{49.18,70.29},{49.06,71.17},{48.91,72.07},{48.77,72.95},{48.64,73.76},{48.36,75.34},{47.84,76.29},{47.27,77.04},{46.41,77.45},{45.39,77.26},{44.52,77.7},{43.73,77.81},{42.87,78.07},{42.3,77.78},{41.87,77.04},{41.39,76.17},{40.93,75.33},{40.37,74.28},{39.95,73.4},{39.48,72.5},{39.02,71.88},{38.26,71.35},{37.35,70.36},{36.48,69.51},{36.03,68.82},{35.71,68.59},{35.09,68.34},{34.45,68.27},{33.77,68.22},{33.07,67.51},{32.72,67.11},{32.31,66.64},{31.85,66.16},{31.26,66.53},{30.98,66.44},{30.77,65.97},{30.59,65.43},{30.12,64.3},{29.75,63.75},{29.37,62.76},{28.78,61.51},{28.92,60.45},{28.88,59.31},{28.91,58.66},{28.97,57.58},{28.84,56.67},{28.69,56.15},{28.47,55.03},{28.7,53.85},{29.17,52.39},{29.65,50.46},{29.89,48.86},{29.36,49.0},{29.03,48.84},{28.86,48.5},{28.63,48.09},{28.33,48.1},{28.03,48.17},{27.75,48.53},{27.33,48.63},{27.16,48.14},{26.95,48.04},{26.54,48.08},{26.21,48.09},{26.0,47.79},{25.81,47.5},{25.66,47.22},{25.53,46.53},{25.65,46.22},{26.32,45.11},{26.98,43.99},{27.66,42.89},{28.31,41.74},{28.97,40.63},{29.66,39.54},{30.34,38.43},{30.91,37.19},{31.23,35.98},{31.42,34.53},{31.63,32.87},{31.8,32.33},{32.49,30.98},{33.21,29.94},{33.97,28.97},{34.77,28.05},{35.19,27.2},{35.71,25.92},{36.13,25.12},{36.93,24.4},{37.73,24.12},{39.21,23.83},{39.7,23.66},{41.04,22.76},{41.42,22.26},{42.33,21.11},{42.89,20.63},{43.27,20.14},{44.18,19.25},{44.66,19.07},{45.97,18.78},{46.41,19.14},{47.22,20.02},{48.01,20.94},{48.79,21.87},{49.17,22.36},{49.93,23.34},{50.31,23.83},{51.05,24.83},{51.74,25.87},{52.07,26.44},{53.04,28.15},{53.69,29.29},{54.37,30.39},{55.09,31.42},{55.7,32.29},{56.26,33.18},{56.62,33.63},{57.46,34.43},{58.25,35.34},{58.0,33.89},{58.31,34.47},{58.75,36.01},{59.02,36.77},{59.5,37.67},{60.19,38.54},{60.87,38.6},{61.19,38.28},{61.52,37.84},{61.91,37.37},{62.4,37.58},{62.89,37.93},{63.15,38.53},{63.56,38.97},{63.97,39.4},{64.41,40.2},{64.58,41.64},{64.77,43.14},{64.75,44.13},{64.72,44.65},{64.35,45.16},{63.85,46.03},{64.41,46.77},{65.08,46.84},{65.59,46.76},{66.72,47.14},{67.3,47.23},{68.23,46.97},{68.78,46.55},{69.28,46.53},{70.28,46.57},{71.07,46.56},{71.92,46.46},{72.42,46.43},{73.3,46.35},{73.79,46.53},{74.78,46.76},{75.46,46.78},{76.17,46.77},{76.78,46.77},{77.66,46.45},{78.21,46.35},{78.71,46.64},{79.91,47.06},{80.57,47.06},{81.04,47.94},{81.86,48.76},{82.34,49.56},{82.85,50.2},{82.59,51.47},{81.95,52.15},{81.13,52.86},{80.56,53.94},{80.11,55.11},{79.72,56.0},{79.29,57.17},{78.9,58.42},{78.48,59.89},{77.87,61.29},{77.08,61.83},{76.24,62.34},{75.48,62.91},{74.85,63.58},{74.26,64.45}}},[267]={{{71.11,8.37},{70.7,9.05},{70.08,9.88},{69.55,10.52},{69.04,10.92},{68.52,10.92},{67.96,10.17},{67.75,9.81},{67.48,9.37},{67.25,9.05},{67.14,8.86},{66.87,8.39},{66.51,7.86},{66.39,6.94},{66.26,6.04},{66.07,4.73},{65.93,4.28},{65.58,3.7}}}},36,nil,nil,60,nil,nil,0},
[2448] = {'Clerk Horrace Whitesteed',787,787,26,26,0,{[267]={{29.51,42.41}}},nil,267,nil,nil,88,"A",nil,0},
[2449] = {'Citizen Wilkes',713,713,25,25,0,{[267]={{32.62,39.79}}},{[267]={{{32.53,39.81},{32.54,39.32},{32.54,39.32},{32.56,38.34},{32.65,37.7},{32.68,37.05},{32.68,36.52},{32.56,35.76},{32.56,35.76},{32.67,36.37},{32.69,37.05},{32.59,37.98},{32.56,38.63},{32.54,38.97},{32.55,39.85},{32.85,39.7},{32.91,39.65},{33.56,39.0},{34.13,38.65},{34.13,38.65},{35.0,38.68},{35.44,38.71},{35.9,38.89},{36.15,39.17},{36.42,39.45},{36.19,39.2},{35.83,38.85},{35.45,38.71},{35.01,38.67},{34.36,38.66},{33.93,38.69},{33.56,39.08},{33.09,39.51},{32.69,39.99}}}},267,nil,nil,88,"A",nil,0},
[2450] = {'Miner Hackett',950,950,29,29,0,{[267]={{31.12,58.63}}},nil,267,nil,nil,88,"A",nil,0},
[2451] = {'Farmer Kalaba',713,713,25,25,0,{[267]={{35.88,46.57}}},{[267]={{{35.9,46.58},{35.95,46.27},{35.98,46.0},{36.02,45.51},{35.9,45.21},{35.62,44.76},{35.47,44.7},{35.23,45.23},{34.98,45.58},{34.69,45.88},{34.47,46.23},{34.24,46.59},{34.05,46.94},{34.1,47.14},{34.33,47.07},{34.58,47.54},{34.85,47.55},{35.05,47.71},{35.33,47.54},{35.57,47.43},{35.82,46.97},{36.04,46.74}}}},267,nil,nil,88,"A",nil,0},
[2452] = {'Skhowl',1469,1469,36,36,4,{[36]={{31.43,51.51}}},{[36]={{{31.44,51.65},{31.87,51.17},{31.94,50.39},{31.95,49.62},{31.88,49.29},{31.61,48.9},{31.13,49.07},{30.29,49.48},{29.99,50.09},{29.6,51.0},{29.28,51.86},{29.28,51.86},{28.88,53.03},{28.44,54.95},{28.7,55.85},{28.92,56.63},{29.12,57.17},{29.02,58.36},{28.95,59.08},{28.93,59.92},{28.87,60.69},{28.93,61.77},{29.45,62.63},{29.7,63.3},{30.18,64.05},{30.3,64.47},{30.65,64.98},{30.14,64.58},{30.14,63.95},{29.86,63.58},{29.39,63.17},{29.22,62.12},{29.05,61.06},{28.97,60.24},{28.98,59.47},{29.0,58.49},{29.0,57.23},{28.76,56.56},{28.69,56.11},{28.54,54.94},{28.67,53.84},{29.24,53.34},{29.45,52.49},{29.94,52.28},{30.79,51.93},{31.14,52.06}}}},36,nil,nil,16,nil,nil,0},
[2453] = {'Lo\'Grosh',1196,1196,39,39,4,{[36]={{52.09,46.94},{47.52,32.31}}},{[36]={{{52.1,47.32},{52.39,47.56},{52.82,47.66},{53.13,47.85},{53.36,48.21},{53.55,48.87},{53.9,49.47},{53.6,48.95},{53.42,48.44},{53.33,48.16},{52.99,47.75},{52.85,47.46},{52.76,46.85},{52.51,46.42},{52.23,46.53},{52.09,46.93}}}},36,nil,nil,45,nil,nil,0},
[2454] = {'Skeletal Fiend (Enraged Form)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2455] = {'Olivia Burnside',5544,5544,45,45,0,{[1519]={{57.66,72.78}}},nil,1519,nil,nil,12,"A","Banker",257},
[2456] = {'Newton Burnside',5544,5544,45,45,0,{[1519]={{57.12,73.23}}},nil,1519,nil,nil,12,"A","Banker",257},
[2457] = {'John Burnside',5544,5544,45,45,0,{[1519]={{56.57,73.68}}},nil,1519,nil,nil,12,"A","Banker",257},
[2458] = {'Randolph Montague',5544,5544,45,45,0,{[1497]={{65.93,43.43}}},nil,1497,nil,nil,68,"H","Banker",256},
[2459] = {'Mortimer Montague',5544,5544,45,45,0,{[1497]={{66.41,44.06}}},nil,1497,nil,nil,68,"H","Banker",256},
[2460] = {'Barnum Stonemantle',5544,5544,45,45,0,{[1537]={{34.97,58.41}}},nil,1537,nil,nil,55,"A","Banker",256},
[2461] = {'Bailey Stonemantle',5544,5544,45,45,0,{[1537]={{35.92,60.14}}},nil,1537,nil,nil,55,"A","Banker",256},
[2462] = {'Flesh Eating Worm',0,0,25,25,0,nil,nil,0,nil,nil,21,nil,nil,0},
[2464] = {'Commander Aggro\'gosh',61040,61040,60,60,1,{[33]={{32.17,28.9}}},nil,33,{568,569},{568,569},29,"H",nil,3},
[2465] = {'Far Seer Mok\'thardin',2217,2217,45,45,0,{[33]={{32.12,29.24}}},nil,33,{570,571,572,573},{570,571,572,573},29,"H",nil,3},
[2466] = {'Mountaineer Grugelm',1910,1910,30,30,0,{[11]={{52.64,83.0}}},{[11]={{{52.64,82.99},{52.48,82.96},{52.01,82.87},{51.62,82.79},{51.2,82.7},{50.66,82.58},{51.23,82.71},{51.62,82.78},{52.05,82.87},{52.45,82.96},{52.9,83.05},{53.3,83.14},{53.71,83.22},{54.14,83.31},{54.55,83.4},{54.85,83.47},{55.12,83.53},{54.76,83.46},{54.18,83.33},{53.77,83.24},{53.31,83.14},{52.89,83.04}}}},11,nil,nil,57,"A",nil,2},
[2468] = {'Mountaineer Thar',1910,1910,30,30,0,{[11]={{55.72,84.73}}},nil,11,nil,nil,57,"A",nil,2},
[2469] = {'Mountaineer Rharen',1910,1910,30,30,0,{[11]={{55.31,83.41}}},nil,11,nil,nil,57,"A",nil,2},
[2470] = {'Watcher Fraizer',2440,2440,35,35,0,{[10]={{74.76,48.07}}},nil,10,nil,nil,56,"A","The Night Watch",0},
[2472] = {'Flamescale Drake',7295,7295,39,39,1,nil,nil,0,nil,nil,60,nil,nil,0},
[2473] = {'Granistad',1753,1753,40,40,0,{[267]={{84.25,32.82}}},nil,267,nil,nil,122,"A",nil,0},
[2474] = {'Kurdros',1752,1752,40,40,0,{[267]={{83.89,32.2}}},nil,267,nil,nil,122,"A",nil,0},
[2475] = {'Sloth',1,1,31,31,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2476] = {'Large Loch Crocolisk',573,573,22,22,4,{[38]={{58.9,31.07},{60.3,39.59}}},nil,38,nil,nil,14,nil,nil,0},
[2477] = {'Gradok',1347,1563,19,21,1,{[38]={{55.45,66.87}}},{[38]={{{55.79,66.73},{56.05,66.39},{56.39,65.71},{56.89,65.7},{57.47,65.02},{58.17,64.46},{58.91,64.21},{59.36,63.57},{59.96,62.52},{60.16,62.02},{60.53,61.1},{60.95,60.44},{61.23,60.11},{61.59,59.58},{62.54,58.21},{62.94,57.6},{63.19,56.8},{63.42,56.06},{63.59,55.46},{63.6,54.82},{63.74,54.27},{63.87,53.38},{64.16,51.78},{64.25,50.98},{64.3,50.52},{64.37,49.88},{64.35,48.58},{64.51,47.68},{64.49,46.1},{64.56,44.89},{64.56,43.86},{64.52,43.27},{64.43,42.54},{64.19,41.58},{64.21,40.34},{64.03,39.27},{63.96,38.51},{64.31,37.71},{64.57,37.2},{64.44,36.58},{64.19,35.86},{64.1,35.5},{63.98,34.99},{63.7,34.22},{63.44,33.67},{63.39,32.8},{63.21,32.12},{63.11,31.65},{62.76,31.01},{62.38,30.44},{61.84,29.77},{61.66,29.49},{61.41,28.89},{61.11,28.16},{60.8,27.48},{60.57,26.95},{60.38,26.48},{60.16,25.97},{59.89,25.31},{59.3,24.41},{58.8,23.43},{58.52,22.94},{58.29,22.39},{57.95,21.54},{57.75,21.05},{57.49,20.19},{57.27,19.36},{56.97,18.16},{57.13,17.47},{57.64,17.39},{58.26,17.65},{58.7,18.06},{59.37,18.88},{59.5,19.73},{59.66,20.77},{59.79,21.54},{60.21,22.39},{60.4,23.02},{61.07,24.29},{61.17,25.19},{61.6,26.08},{61.98,26.81},{62.25,27.51},{62.39,28.56},{62.59,29.04},{63.11,30.19},{63.44,30.93},{63.82,31.89},{64.01,32.56},{64.4,34.46},{64.63,35.35},{64.99,36.36},{65.36,37.2},{65.76,38.32},{65.63,39.02},{66.08,39.96},{65.66,40.96},{65.64,41.75},{65.71,42.55},{65.69,43.34},{65.51,44.34},{65.61,45.28},{65.78,45.9},{66.09,47.09},{66.38,48.09},{66.36,49.22},{66.66,50.26},{66.55,50.97},{66.38,51.86},{65.58,52.24},{65.14,52.42},{64.66,53.02},{64.03,54.05},{63.9,54.52},{63.65,55.15},{63.44,55.77},{63.3,56.56},{63.02,57.79},{62.54,58.44},{61.64,59.62},{61.16,59.72},{60.39,59.76},{59.78,60.41},{59.13,61.19},{58.53,62.01},{58.17,62.75},{57.89,63.49},{57.17,64.26},{56.56,65.01},{56.15,65.8},{55.49,66.69}}}},38,nil,nil,83,"H","Horde Runner",2},
[2478] = {'Haren Swifthoof',1452,1563,20,21,1,{[38]={{55.45,67.06}}},{[38]={{{55.79,66.73},{56.05,66.39},{56.39,65.71},{56.89,65.7},{57.47,65.02},{58.17,64.46},{58.91,64.21},{59.36,63.57},{59.96,62.52},{60.16,62.02},{60.53,61.1},{60.95,60.44},{61.23,60.11},{61.59,59.58},{62.54,58.21},{62.94,57.6},{63.19,56.8},{63.42,56.06},{63.59,55.46},{63.6,54.82},{63.74,54.27},{63.87,53.38},{64.16,51.78},{64.25,50.98},{64.3,50.52},{64.37,49.88},{64.35,48.58},{64.51,47.68},{64.49,46.1},{64.56,44.89},{64.56,43.86},{64.52,43.27},{64.43,42.54},{64.19,41.58},{64.21,40.34},{64.03,39.27},{63.96,38.51},{64.31,37.71},{64.57,37.2},{64.44,36.58},{64.19,35.86},{64.1,35.5},{63.98,34.99},{63.7,34.22},{63.44,33.67},{63.39,32.8},{63.21,32.12},{63.11,31.65},{62.76,31.01},{62.38,30.44},{61.84,29.77},{61.66,29.49},{61.41,28.89},{61.11,28.16},{60.8,27.48},{60.57,26.95},{60.38,26.48},{60.16,25.97},{59.89,25.31},{59.3,24.41},{58.8,23.43},{58.52,22.94},{58.29,22.39},{57.95,21.54},{57.75,21.05},{57.49,20.19},{57.27,19.36},{56.97,18.16},{57.13,17.47},{57.64,17.39},{58.26,17.65},{58.7,18.06},{59.37,18.88},{59.5,19.73},{59.66,20.77},{59.79,21.54},{60.21,22.39},{60.4,23.02},{61.07,24.29},{61.17,25.19},{61.6,26.08},{61.98,26.81},{62.25,27.51},{62.39,28.56},{62.59,29.04},{63.11,30.19},{63.44,30.93},{63.82,31.89},{64.01,32.56},{64.4,34.46},{64.63,35.35},{64.99,36.36},{65.36,37.2},{65.76,38.32},{65.63,39.02},{66.08,39.96},{65.66,40.96},{65.64,41.75},{65.71,42.55},{65.69,43.34},{65.51,44.34},{65.61,45.28},{65.78,45.9},{66.09,47.09},{66.38,48.09},{66.36,49.22},{66.66,50.26},{66.55,50.97},{66.38,51.86},{65.58,52.24},{65.14,52.42},{64.66,53.02},{64.03,54.05},{63.9,54.52},{63.65,55.15},{63.44,55.77},{63.3,56.56},{63.02,57.79},{62.54,58.44},{61.64,59.62},{61.16,59.72},{60.39,59.76},{59.78,60.41},{59.13,61.19},{58.53,62.01},{58.17,62.75},{57.89,63.49},{57.17,64.26},{56.56,65.01},{56.15,65.8},{55.49,66.69}}}},38,nil,nil,83,"H","Horde Runner",2},
[2479] = {'Sludge',1,1,31,31,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2480] = {'Bro\'kin',2672,2672,49,49,0,{[36]={{38.24,38.87}}},nil,36,nil,nil,120,"AH","Alchemy Supplies",6},
[2481] = {'Bliztik',1468,1468,36,36,0,{[10]={{18.04,54.36}}},nil,10,nil,nil,120,"AH","Alchemy Supplies",6},
[2482] = {'Zarena Cromwind',2059,2059,43,43,0,{[33]={{28.34,75.46}}},nil,33,nil,nil,120,"AH","Superior Weaponsmith",16388},
[2483] = {'Jaquilina Dramet',1677,1677,39,39,0,{[33]={{35.75,10.66}}},nil,33,nil,nil,35,"AH","Superior Axecrafter",16388},
[2485] = {'Larimaine Purdue',2768,2768,50,50,0,{[1519]={{39.69,79.55}}},nil,1519,nil,nil,12,"A","Portal Trainer",17},
[2486] = {'Fin Fizracket',1981,1981,42,42,0,{[33]={{27.61,76.74}}},nil,33,{348},{348},120,"AH","Blackwater Raiders",2},
[2487] = {'Fleet Master Seahorn',4120,4120,60,60,0,{[33]={{27.17,77.01}}},nil,33,{604,608,670},{599,604,608,669},120,"AH","Blackwater Raiders",3},
[2488] = {'Deeg',1279,1279,34,34,0,{[33]={{26.92,77.35}}},nil,33,{587},{587},120,"AH","Blackwater Raiders",2},
[2489] = {'Milstaff Stormeye',2217,2217,45,45,0,{[1537]={{25.5,7.07}}},nil,1537,nil,nil,55,"A","Portal Trainer",19},
[2490] = {'First Mate Crazz',2138,2138,44,44,0,{[33]={{28.1,76.22}}},nil,33,{595,599},{597},120,"AH","Blackwater Raiders",2},
[2491] = {'Whiskey Slim',1604,1604,38,38,0,{[33]={{27.14,77.45}}},nil,33,{580},{580},120,"AH","Blackwater Raiders",3},
[2492] = {'Lexington Mortaim',1342,1342,35,35,0,{[1497]={{84.19,15.58}}},nil,1497,nil,nil,68,"H","Portal Trainer",19},
[2493] = {'Dizzy One-Eye',1902,1902,41,41,0,{[33]={{28.59,75.9}}},nil,33,{576},{576},120,"AH","Blackwater Raiders",2},
[2494] = {'Privateer Bloads',1752,1752,40,40,0,{[33]={{26.76,76.38}}},nil,33,{617,623},{617},120,"AH",nil,2},
[2495] = {'Drizzlik',2217,2217,45,45,0,{[33]={{28.29,77.59}}},nil,33,{575,577,628},{575,577,628},120,"AH",nil,2},
[2496] = {'Baron Revilgaz',4120,4120,60,60,0,{[33]={{27.23,76.87}}},nil,33,{578,601,602,1182,1183},{578,601,611,616,1181,1182},120,"AH",nil,3},
[2497] = {'Nimboya',1902,1902,41,41,0,{[33]={{32.16,27.72}}},nil,33,{581,582,584,638,2932},{581,582,592,2932},126,"H",nil,2},
[2498] = {'Crank Fizzlebub',1279,1279,34,34,0,{[33]={{27.12,77.21}}},nil,33,{600,605,621,1119,1127},{600,605,621,1118,1122,1127},120,"AH",nil,2},
[2499] = {'Markel Smythe',1604,1604,38,38,0,{[33]={{28.01,74.92}}},nil,33,nil,nil,120,"AH",nil,2},
[2500] = {'Captain Hecklebury Smotts',1536,1536,37,37,0,{[33]={{26.69,73.61}}},nil,33,{8551,8553},{8551,8552,8554},120,"AH",nil,2},
[2501] = {'"Sea Wolf" MacKinley',2138,2138,44,44,0,{[33]={{27.78,77.07}}},nil,33,{606,609,613,2872},{607,609,613,2874},120,"AH",nil,2},
[2502] = {'"Shaky" Phillipe',2138,2138,44,44,0,{[33]={{26.9,73.59}}},nil,33,{607},{606},120,"AH",nil,2},
[2503] = {'Hillsbrad Foreman',840,896,27,28,0,{[267]={{31.89,52.4},{28.65,56.66},{30.9,56.26},{28.85,57.55},{31.13,54.43},{29.35,56.83},{29.56,52.99},{29.34,52.54},{29.63,55.33},{27.5,59.32}}},nil,267,nil,nil,123,"A",nil,0},
[2504] = {'Donyal Tovald',328,328,15,15,0,{[1519]={{71.57,7.35}}},nil,1519,{579},{579},12,"A","Librarian",2},
[2505] = {'Saltwater Snapjaw',2672,2769,49,50,0,{[47]={{84.93,45.37},{85.31,41.85},{80.26,71.95},{85.15,57.75},{80.68,69.35},{80.56,77.29},{85.96,61.8},{77.37,86.47},{80.51,74.83},{85.12,55.02},{84.05,64.59},{82.75,41.34},{82.38,37.99},{83.52,39.89},{80.68,61.84},{83.05,50.4},{81.66,39.05},{84.4,61.93},{85.98,64.76},{83.17,44.84},{79.75,65.75},{82.57,46.11},{82.4,48.79},{83.08,47.61},{82.71,53.78},{82.99,52.89},{81.81,42.05},{82.14,43.14},{81.39,50.29},{83.48,55.32},{81.35,44.83},{82.61,59.19},{76.17,83.97},{83.36,42.12},{75.75,71.4},{81.54,55.12},{78.63,69.69},{81.87,52.95},{79.9,73.58},{82.33,51.34},{78.27,70.57},{76.74,68.34},{76.12,65.21},{78.17,68.48},{79.19,59.3},{78.19,60.65},{79.7,60.4},{83.61,57.81},{77.39,67.0},{84.2,59.09},{79.07,61.87},{81.48,60.46},{77.31,61.74},{77.31,64.19},{79.97,57.95},{78.52,65.2},{75.39,69.89},{74.74,70.98},{77.32,69.59},{74.63,68.29},{81.49,53.02},{81.66,54.61},{78.04,63.04}}},nil,47,nil,nil,7,"AH",nil,0},
[2506] = {'Mountaineer Harn',1910,1910,30,30,0,{[38]={{36.35,50.47}}},nil,38,nil,nil,57,"A",nil,2},
[2507] = {'Mountaineer Uthan',1706,1706,28,28,0,{[38]={{38.0,41.61}}},nil,38,nil,nil,57,"A",nil,2},
[2508] = {'Mountaineer Wuar',1910,1910,30,30,0,{[38]={{35.53,42.09}}},nil,38,nil,nil,57,"A",nil,2},
[2509] = {'Mountaineer Cragg',1910,1910,30,30,0,{[38]={{33.91,42.63}}},nil,38,nil,nil,57,"A",nil,2},
[2510] = {'Mountaineer Ozmok',1910,1910,30,30,0,{[38]={{35.1,46.79}}},nil,38,nil,nil,57,"A",nil,2},
[2511] = {'Mountaineer Bludd',1910,1910,30,30,0,{[38]={{38.96,43.83}}},nil,38,nil,nil,57,"A",nil,2},
[2512] = {'Mountaineer Roghan',1706,1706,28,28,0,{[38]={{34.74,51.42}}},nil,38,nil,nil,57,"A",nil,2},
[2513] = {'Mountaineer Janha',1910,1910,30,30,0,{[38]={{35.41,44.48}}},{[38]={{{35.41,44.48},{35.27,43.75}}}},38,nil,nil,57,"A",nil,2},
[2514] = {'Mountaineer Modax',1910,1910,30,30,0,{[38]={{37.61,44.56}}},nil,38,nil,nil,57,"A",nil,2},
[2515] = {'Mountaineer Fazgard',1910,1910,30,30,0,{[38]={{38.79,47.07}}},nil,38,nil,nil,57,"A",nil,2},
[2516] = {'Mountaineer Kamdar',1706,1706,28,28,0,{[38]={{33.31,44.76}}},nil,38,nil,nil,57,"A",nil,2},
[2517] = {'Mountaineer Langarr',1910,1910,30,30,0,{[38]={{35.8,46.89}}},nil,38,nil,nil,57,"A",nil,2},
[2518] = {'Mountaineer Swarth',1910,1910,30,30,0,{[38]={{37.49,49.01}}},nil,38,nil,nil,57,"A",nil,2},
[2519] = {'Kin\'weelay',1677,1677,39,39,0,{[33]={{32.27,27.71}}},nil,33,{589,591,592,596,598,629},{588,589,591,596,598,629,1240},126,"H",nil,2},
[2520] = {'Remote-Controlled Golem',1251,1251,18,18,1,nil,nil,0,nil,nil,17,nil,nil,0},
[2521] = {'Skymane Gorilla',2768,2768,50,50,0,{[33]={{40.44,77.28},{41.87,77.92},{41.34,77.82},{40.3,79.45},{40.24,80.47},{40.73,79.14},{41.88,79.46},{39.13,86.56},{40.86,81.89},{39.24,78.71},{40.29,82.04},{41.87,81.11},{40.87,80.54},{40.36,83.86},{41.86,82.54},{40.26,86.52},{41.89,84.15},{41.31,85.02},{38.75,85.9}}},nil,33,nil,nil,72,nil,nil,0},
[2522] = {'Jaguero Stalker',2768,2768,50,50,0,{[33]={{36.49,80.89},{37.14,80.36},{38.65,86.58},{36.5,84.05},{36.6,85.69},{38.89,77.76},{37.09,83.3},{37.64,86.14},{37.53,82.85},{37.75,81.57},{37.64,83.55},{37.8,79.98},{37.28,78.58},{38.05,81.31}}},nil,33,nil,nil,16,nil,nil,0},
[2523] = {'Searing Totem',449,449,19,19,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2524] = {'Mountaineer Haggis',1910,1910,30,30,0,{[38]={{42.67,10.57}}},nil,38,nil,nil,57,"A",nil,2},
[2525] = {'Mountaineer Barn',1910,1910,30,30,0,{[38]={{43.44,11.3}}},{[38]={{{43.33,11.21},{42.81,10.33},{42.42,10.82},{40.99,12.64},{41.37,12.14},{42.81,10.43},{43.18,10.94},{43.94,11.95},{44.73,12.9},{45.56,13.74},{46.31,14.23},{46.82,14.29},{47.99,14.39},{48.96,14.29},{49.66,13.98},{50.5,13.39},{51.37,12.6},{52.2,11.74},{53.2,10.56},{53.51,11.16},{54.64,12.63},{55.26,13.89},{55.01,13.23},{54.44,12.32},{53.69,11.29},{53.1,10.54},{52.36,11.59},{51.56,12.52},{50.68,13.27},{48.85,14.27},{47.72,14.38},{46.71,14.28},{45.66,13.96},{44.86,13.02},{44.08,12.04},{43.31,11.05},{42.71,10.29}}}},38,nil,nil,57,"A",nil,2},
[2526] = {'Mountaineer Morlic',1910,1910,30,30,0,{[38]={{46.24,14.16}}},nil,38,nil,nil,57,"A",nil,2},
[2527] = {'Mountaineer Angst',1706,1706,28,28,0,{[38]={{48.56,14.44}}},nil,38,nil,nil,57,"A",nil,2},
[2528] = {'Mountaineer Haggil',1910,1910,30,30,0,{[38]={{53.12,10.74}}},nil,38,nil,nil,57,"A",nil,2},
[2529] = {'Son of Arugal',1953,2097,24,25,1,{[130]={{44.96,79.59},{38.14,15.17},{47.34,34.02}},[209]={{-1,-1}}},nil,130,nil,nil,24,nil,nil,0},
[2530] = {'Yenniku',1902,1902,41,41,0,{[33]={{39.02,58.35}}},nil,33,{593},{593},28,nil,"Darkspear Hostage",2},
[2531] = {'Minion of Morganth',1432,1432,30,30,0,nil,nil,0,nil,nil,68,"H",nil,0},
[2532] = {'Donna',42,42,1,1,0,{[1519]={{61.36,51.97}}},nil,1519,nil,nil,12,"A",nil,0},
[2533] = {'William',42,42,1,1,0,{[1519]={{61.82,51.34}}},{[1519]={{{62.28,50.71},{62.94,49.81},{63.94,48.57},{63.74,47.79},{63.24,46.68},{62.35,45.63},{61.69,44.22},{61.59,42.29},{61.98,41.19},{63.85,38.6},{64.5,37.05},{64.02,36.37},{63.55,35.96},{63.2,34.8},{62.56,33.74},{62.06,33.5},{61.13,33.63},{59.95,34.6},{58.91,33.9},{57.26,32.13},{55.45,28.42},{54.82,26.23},{53.93,25.83},{53.18,26.59},{52.68,27.1},{52.46,27.4},{51.74,28.16},{51.56,29.34},{51.95,30.55},{53.52,33.27},{54.02,36.74},{54.11,39.08},{53.62,41.92},{52.85,43.16},{51.76,43.95},{49.62,46.8},{48.55,47.91},{48.1,49.07},{48.9,50.4},{48.98,50.96},{49.71,51.76},{50.62,51.27},{52.79,55.15},{53.29,55.11},{54.24,53.91},{55.45,53.51},{56.55,53.68},{57.51,54.63},{58.9,58.0},{57.69,59.16},{56.22,61.6},{55.12,61.57},{54.79,60.58},{55.09,59.62},{55.7,59.32},{56.38,60.01},{56.14,61.52},{54.68,63.33},{53.59,63.76},{52.65,61.7},{52.08,60.87},{49.1,63.15},{48.34,61.29},{47.29,58.25},{47.49,55.55},{48.27,53.94},{50.22,51.51},{51.27,50.4},{52.35,49.88},{53.23,48.43},{56.01,47.71},{57.2,47.36},{58.45,48.16},{59.01,49.77},{60.97,52.49},{61.37,52.3},{61.77,51.36}}}},1519,nil,nil,12,"A",nil,0},
[2534] = {'Zanzil the Outcast',1919,1919,46,46,0,{[33]={{39.59,58.57}}},nil,33,nil,nil,16,nil,nil,0},
[2535] = {'Maury "Club Foot" Wilkins',2059,2138,43,44,0,{[33]={{35.26,51.27}}},nil,33,nil,nil,16,nil,nil,0},
[2536] = {'Jon-Jon the Crow',2059,2138,43,44,0,{[33]={{34.92,51.84}}},nil,33,nil,nil,16,nil,nil,0},
[2537] = {'Chucky "Ten Thumbs"',2059,2138,43,44,0,{[33]={{40.0,58.24}}},nil,33,nil,nil,16,nil,nil,0},
[2540] = {'Dalaran Serpent',0,0,15,15,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2541] = {'Lord Sakrasis',1848,1848,45,45,4,{[33]={{28.33,62.56},{28.85,62.04}}},nil,33,nil,nil,14,nil,nil,0},
[2542] = {'Catelyn the Blade',2768,2768,50,50,0,{[33]={{27.28,77.53}}},nil,33,{610,611},{603,610},120,"AH","Blackwater Raiders",2},
[2543] = {'Archmage Ansirem Runeweaver',1238,1238,40,40,0,{[36]={{18.84,78.49}}},nil,36,{603},{602},76,"AH","Kirin Tor",2},
[2544] = {'Southern Sand Crawler',1829,1902,40,41,0,{[33]={{27.75,85.63},{30.75,81.73},{29.91,85.66},{32.24,82.53},{35.27,87.91},{33.8,76.48},{27.54,85.87},{28.81,87.53},{33.94,85.92},{35.12,87.79},{30.85,85.29},{26.92,84.36},{31.67,87.04},{29.26,82.28},{29.94,87.72},{28.73,87.56},{31.32,81.92},{29.93,87.31},{30.09,85.78},{31.35,85.93},{26.73,86.96},{31.24,88.09},{25.78,85.89},{26.3,84.11}}},nil,33,nil,nil,7,"AH",nil,0},
[2545] = {'"Pretty Boy" Duncan',1677,1677,39,39,0,{[33]={{27.39,69.42}}},nil,33,{1036},nil,119,nil,nil,2},
[2546] = {'Fleet Master Firallon',2577,2577,48,48,0,{[33]={{30.58,90.63}}},nil,33,{4621,9272},{1036,4621,9272},119,nil,nil,2},
[2547] = {'Ironpatch',1981,2059,42,43,0,{[33]={{30.57,90.44}}},nil,33,nil,nil,119,nil,nil,0},
[2548] = {'Captain Keelhaul',2398,2487,46,47,0,{[33]={{29.32,88.29}}},nil,33,nil,nil,119,nil,nil,0},
[2549] = {'Garr Salthoof',1902,2059,41,43,0,{[33]={{29.2,88.79}}},nil,33,nil,nil,119,nil,nil,0},
[2550] = {'Captain Stillwater',1847,1918,45,46,0,{[33]={{32.87,88.2}}},nil,33,nil,nil,119,nil,nil,0},
[2551] = {'Brutus',2746,2746,43,43,0,{[33]={{32.92,88.27}}},nil,33,nil,nil,119,nil,nil,0},
[2552] = {'Witherbark Troll',1050,1107,30,31,0,{[45]={{35.1,46.16},{37.5,40.95},{35.61,49.41},{32.04,46.29},{74.15,45.78},{74.08,45.73},{74.12,45.69}}},nil,45,nil,nil,654,nil,nil,0},
[2553] = {'Witherbark Shadowcaster',847,882,31,32,0,{[45]={{34.6,39.5},{31.03,42.37},{74.08,45.83}}},{[45]={{{74.08,45.83},{74.08,45.83},{74.08,45.83},{74.9,42.9},{74.55,37.48}}}},45,nil,nil,654,nil,nil,0},
[2554] = {'Witherbark Axe Thrower',1163,1221,32,33,0,{[45]={{66.02,62.87},{65.56,64.49},{74.05,65.4},{70.87,61.66},{72.04,59.15},{73.71,63.76},{70.71,58.83},{73.2,60.33},{73.19,65.85},{73.03,64.75},{71.61,60.58},{70.77,60.51},{68.2,60.7},{66.78,63.69},{66.32,64.74},{66.88,61.7},{65.25,67.59},{62.79,67.63},{63.47,67.06},{63.96,68.19},{59.82,74.08},{64.13,73.57},{64.51,72.84},{65.08,74.0},{65.09,73.03},{62.92,68.52},{61.61,72.84},{61.68,71.48},{61.62,72.1},{60.46,72.52},{61.19,71.68},{63.5,72.83}}},nil,45,nil,nil,654,nil,nil,0},
[2555] = {'Witherbark Witch Doctor',1021,1064,33,34,0,{[45]={{64.73,71.64},{67.34,80.48},{30.52,43.56},{69.28,81.49},{73.74,64.62},{31.53,45.8},{69.61,66.59},{69.86,77.92},{72.85,65.83},{73.25,65.34},{71.6,61.84},{66.38,63.8},{65.25,68.93},{66.27,71.79},{63.11,67.77},{69.93,61.62},{71.75,64.56},{69.14,79.72},{68.12,79.36},{65.02,73.39},{64.5,73.04},{67.15,73.52},{70.55,70.47},{71.05,69.17},{71.56,67.11},{69.34,68.69},{68.04,78.63},{67.94,76.88},{32.62,44.43},{61.08,72.16},{64.42,71.74}}},nil,45,nil,nil,654,nil,nil,0},
[2556] = {'Witherbark Headhunter',1279,1342,34,35,0,{[45]={{69.75,78.01},{70.45,78.2},{68.99,78.68},{70.04,77.34},{67.18,80.83},{67.75,81.95},{68.17,79.5},{69.19,82.41},{69.17,81.66},{68.29,80.06},{69.55,81.58},{69.88,81.13},{66.28,82.24},{67.55,81.59},{66.03,81.88},{68.74,73.43},{64.28,68.95},{71.88,63.02},{72.68,64.43},{69.13,79.46},{69.03,71.98},{70.02,71.75},{70.64,69.64},{70.91,67.35},{71.25,69.92},{71.2,65.91},{69.97,68.65},{68.55,76.41},{67.93,76.49},{67.74,77.06},{67.65,77.23},{67.98,78.74},{62.55,73.17},{59.93,71.64},{67.08,70.15},{63.51,71.64},{74.16,45.89}}},nil,45,nil,nil,654,nil,nil,0},
[2557] = {'Witherbark Shadow Hunter',1160,1208,35,36,0,{[45]={{69.41,80.66},{69.87,78.79},{69.7,79.4},{70.24,79.01},{67.53,80.51},{68.58,80.89},{69.01,81.54},{68.61,82.26},{66.29,80.48},{66.99,82.33},{67.62,81.03},{66.77,81.28},{67.28,81.76},{66.73,80.5},{67.38,78.7},{66.95,79.12}}},nil,45,nil,nil,654,nil,nil,0},
[2558] = {'Witherbark Berserker',3831,4008,36,37,1,{[45]={{22.93,65.09},{24.27,66.25},{24.04,65.18}}},nil,45,nil,nil,654,nil,nil,0},
[2559] = {'Highland Strider',1050,1107,30,31,0,{[45]={{27.21,20.73},{28.3,17.27},{30.26,21.12},{39.99,61.87},{49.3,49.35},{44.91,65.49},{69.07,52.0},{42.84,79.6},{26.89,36.99},{25.19,40.13},{40.27,43.67},{42.17,46.94},{39.83,46.37},{41.03,44.8},{42.47,43.84},{70.58,51.04},{48.16,33.66},{74.0,48.29},{20.49,38.23},{41.09,74.24},{24.48,40.65},{32.7,36.13},{68.7,49.14},{29.94,19.89},{46.57,64.32},{20.62,45.01},{19.03,41.0},{19.62,42.21},{18.06,40.18},{18.89,38.15},{17.13,42.08},{19.51,34.2},{19.97,38.0},{43.08,39.21},{41.3,41.4},{43.24,41.2},{41.84,41.92},{44.12,41.0},{46.69,39.45},{26.44,34.97},{21.43,36.43},{21.92,39.19},{43.17,77.78},{49.55,52.11},{26.66,24.03},{40.1,58.92},{67.24,34.06},{54.12,47.64},{54.26,46.7},{53.28,45.93},{53.79,45.62},{60.34,37.25},{53.1,43.97},{69.79,27.0},{65.89,35.11},{67.58,36.92},{67.1,56.28},{63.97,50.49},{38.37,48.66},{38.42,51.66},{39.64,50.62},{41.75,49.44},{41.26,49.77},{42.05,50.81},{69.77,31.63},{37.31,50.34},{64.35,36.77},{70.02,30.35},{30.83,20.36},{41.42,53.39},{33.61,35.06},{51.39,39.65},{52.29,32.43},{51.33,40.55},{52.06,44.89},{51.09,47.39},{44.83,54.97},{46.75,50.51},{46.77,53.0},{39.57,47.77},{40.5,49.25},{69.0,36.61},{68.01,36.86},{69.84,35.81},{66.9,39.1},{65.28,45.22},{65.64,38.0},{66.11,43.66},{49.53,40.7},{46.76,41.11},{47.75,56.2},{69.06,38.58},{65.93,40.52},{67.56,42.26},{65.23,39.72},{61.59,42.25},{65.42,42.44},{23.68,39.65},{64.39,40.92},{63.42,42.22},{60.67,41.01},{76.3,31.12},{60.81,42.25},{58.73,41.12},{60.6,43.59},{58.73,43.67},{59.62,45.15},{62.51,46.49},{61.58,45.24},{63.28,45.12},{64.26,46.39},{56.88,46.63},{55.13,49.13},{56.03,48.03},{24.94,36.81},{23.66,35.37},{68.53,41.17},{17.18,42.71}}},nil,45,nil,nil,48,nil,nil,0},
[2560] = {'Highland Thrasher',1221,1279,33,34,0,{[45]={{21.11,54.86},{18.95,55.17},{34.1,61.82},{20.08,55.99},{31.29,65.2},{20.83,47.69},{41.02,64.79},{39.17,64.98},{20.1,48.21},{19.06,48.73},{22.03,47.68},{21.64,49.41},{21.86,53.57},{39.72,68.86},{18.53,46.34},{37.41,64.86},{36.91,66.65},{38.41,67.21},{36.17,65.11},{36.51,64.03},{39.49,65.88},{55.97,68.78},{40.09,67.05},{34.88,64.27},{40.99,69.92},{38.67,69.07},{36.96,38.15},{39.51,69.87},{36.52,36.72},{18.04,47.22},{23.15,49.7},{39.86,29.86},{43.94,34.03},{37.76,33.32},{36.32,33.07},{35.44,65.83},{32.51,56.89},{31.37,55.86},{62.44,65.27},{32.59,56.59},{20.05,45.01},{38.02,33.48},{38.07,38.68},{39.39,38.36},{36.73,35.22},{40.2,41.13},{41.74,39.62},{43.02,36.41},{30.5,56.37},{32.14,58.96},{32.37,63.99},{32.07,60.26},{37.37,67.89},{37.88,36.94},{41.19,35.32},{40.18,36.79},{43.85,38.43},{40.17,35.33},{37.07,29.87},{41.04,29.98},{54.5,59.61},{46.53,35.06},{39.87,34.2},{54.07,57.65},{58.82,67.31},{31.09,57.65},{30.07,56.1}}},nil,45,nil,nil,48,nil,nil,0},
[2561] = {'Highland Fleshstalker',1469,1536,36,37,0,{[45]={{47.49,80.66},{48.01,82.44},{45.66,76.65},{46.84,78.73},{45.59,79.5},{46.5,76.0},{47.6,75.21},{50.54,64.59},{49.61,69.12},{50.38,67.5},{53.09,68.78},{51.08,68.75},{55.11,67.46},{53.74,67.8},{52.28,68.14},{52.3,64.58},{54.03,64.64},{50.05,70.42},{50.16,63.87}}},nil,45,nil,nil,48,nil,nil,0},
[2562] = {'Boulderfist Ogre',1163,1221,32,33,0,{[45]={{32.87,50.28},{36.22,46.7},{36.21,47.62},{35.66,43.85},{35.7,45.27},{34.55,47.65},{32.88,47.83},{30.99,45.29},{34.01,49.49},{31.85,41.02},{31.16,48.05},{33.15,40.79},{35.61,41.29},{32.91,39.52},{37.18,43.6},{36.79,42.56},{37.64,46.19},{34.69,42.97}}},nil,45,nil,nil,45,nil,nil,0},
[2563] = {'Plains Creeper',1163,1221,32,33,0,{[45]={{19.92,54.65},{34.95,66.18},{33.97,64.88},{19.87,50.53},{22.4,54.58},{39.74,70.93},{38.6,62.86},{32.72,60.91},{23.81,48.25},{62.83,30.08},{19.41,43.59},{18.05,52.29},{28.26,20.86},{20.81,53.06},{61.42,50.58},{45.14,64.83},{41.09,62.55},{42.59,61.51},{17.24,45.34},{18.07,50.71},{65.61,50.69},{48.27,37.99},{44.18,70.52},{45.31,67.44},{40.78,67.76},{66.98,52.57},{73.72,46.89},{42.0,75.58},{37.69,31.09},{44.67,39.24},{42.12,37.18},{41.21,38.17},{69.88,37.11},{61.63,50.59},{54.3,32.51},{63.38,38.26},{69.94,50.23},{20.74,36.27},{17.32,49.75},{41.73,61.72},{22.73,51.98},{45.84,40.88},{23.6,38.21},{69.91,49.3},{43.53,62.66},{71.09,54.25},{71.79,50.51},{69.74,55.14},{69.84,56.17},{68.04,53.15},{66.59,49.26},{69.0,50.63},{70.0,48.32},{68.99,47.92},{52.27,35.49},{64.25,43.69},{32.83,54.42},{43.09,57.42},{18.06,44.68},{22.6,45.19},{50.55,37.98},{19.95,40.99},{68.08,55.97},{18.19,35.47},{47.58,36.42},{39.12,35.41},{39.38,45.4},{26.36,37.96},{68.9,35.39},{20.85,42.17},{42.01,72.73},{70.52,46.72},{73.04,47.18},{68.37,46.49},{48.69,50.83},{26.55,25.74},{29.08,34.64},{41.24,58.83},{41.04,60.24},{42.97,58.96},{55.96,45.35},{71.83,48.46},{68.95,56.28},{58.68,50.69},{59.84,49.69},{61.58,49.24},{49.48,36.7},{47.93,35.03},{40.05,51.93},{41.44,48.66},{60.81,39.69},{49.94,35.58},{51.23,36.58},{17.18,42.3},{16.91,43.71},{56.43,33.23},{57.9,33.85},{55.32,33.67},{53.29,33.3},{50.56,41.84},{47.92,57.57},{47.88,61.16},{50.19,61.5},{36.1,33.87},{69.14,33.8},{62.24,42.63},{60.61,46.57},{57.83,45.16},{48.08,60.64},{45.65,64.47},{43.11,64.53},{71.08,46.97},{19.38,35.88}}},nil,45,nil,nil,22,nil,nil,0},
[2564] = {'Boulderfist Enforcer',1221,1279,33,34,0,{[45]={{33.01,46.61},{31.08,43.06},{31.05,43.67},{32.38,46.04},{33.58,44.59},{32.54,43.88},{33.3,43.88},{33.92,44.56},{34.52,44.2},{32.82,43.14},{32.39,44.74},{31.64,44.2},{32.8,45.44},{33.62,45.98},{33.09,46.08},{31.9,46.05}}},nil,45,nil,nil,45,nil,nil,0},
[2565] = {'Giant Plains Creeper',1403,1469,35,36,0,{[45]={{42.94,32.55},{42.68,29.49},{37.31,24.57},{38.37,25.36},{39.27,27.77},{42.48,32.35},{57.55,65.83},{45.71,34.81},{40.33,31.69},{56.87,67.51},{47.79,77.23},{41.0,31.9},{60.39,64.35},{59.91,68.46},{57.04,69.0},{40.23,29.13},{61.74,69.01},{44.09,31.06},{44.56,31.64},{37.91,26.91},{41.97,34.13},{44.91,36.82},{38.44,29.26},{54.5,56.31},{56.47,57.85},{56.75,60.52},{46.56,36.74},{57.36,65.02},{51.2,66.57},{46.05,74.48},{55.84,54.59},{52.59,61.03},{53.19,58.88},{56.01,59.08},{53.41,56.45},{54.38,54.9},{53.52,65.96},{56.93,61.97},{58.79,64.58},{59.77,65.84},{60.68,67.19},{61.45,65.87},{60.48,64.53}}},nil,45,nil,nil,22,nil,nil,0},
[2566] = {'Boulderfist Brute',1403,1469,35,36,0,{[45]={{54.71,80.42},{54.31,81.0},{54.68,78.33},{51.99,76.85},{53.83,74.58},{52.86,74.0},{54.21,75.63},{53.58,76.15},{53.08,74.48},{53.1,75.93},{54.52,78.63},{55.15,72.74},{54.54,73.8},{53.45,72.89},{52.26,71.48},{51.91,73.98},{51.55,72.67},{50.61,79.81},{49.53,78.56},{50.83,76.56},{49.61,75.51}}},nil,45,nil,nil,45,nil,nil,0},
[2567] = {'Boulderfist Magus',1075,1116,36,37,0,{[45]={{54.61,81.32},{54.24,77.74},{53.32,74.39},{52.96,77.02},{53.66,80.0},{54.05,71.76},{52.4,75.6},{51.39,77.82},{50.43,74.26}}},nil,45,nil,nil,45,nil,nil,0},
[2569] = {'Boulderfist Mauler',4008,4185,37,38,1,{[45]={{17.51,68.38},{21.9,65.39},{22.2,67.68},{20.77,69.07},{20.02,66.75},{23.0,66.84},{21.59,66.7},{23.74,65.78},{24.38,62.24}}},nil,45,nil,nil,45,nil,nil,0},
[2570] = {'Boulderfist Shaman',3405,3540,38,39,1,{[45]={{18.68,66.54},{17.82,69.12},{18.1,68.38},{20.87,65.68},{20.49,66.67},{19.49,64.62},{20.92,67.44},{21.57,66.96},{19.97,67.51},{20.23,69.14},{19.88,68.5},{21.55,68.36}}},nil,45,nil,nil,45,nil,nil,0},
[2571] = {'Boulderfist Lord',4377,4572,39,40,1,{[45]={{18.63,69.24},{17.85,68.01},{18.02,69.04},{19.93,65.72},{18.94,65.93},{20.63,68.28},{18.23,67.39},{19.51,69.06},{19.22,67.66}}},nil,45,nil,nil,45,nil,nil,0},
[2572] = {'Drywhisker Kobold',1403,1469,35,36,0,{[45]={{81.91,37.18},{81.82,35.85},{76.02,44.39},{76.91,44.34},{79.08,41.51},{77.22,43.53},{77.49,34.88},{78.45,41.15},{78.48,34.46},{79.16,34.92},{82.49,38.85},{80.04,39.97},{82.6,37.95},{78.02,39.89},{76.23,42.48},{78.28,36.86},{78.55,37.77},{78.87,34.38},{77.52,35.64},{79.47,33.08},{79.21,35.62}}},nil,45,nil,nil,26,nil,nil,0},
[2573] = {'Drywhisker Surveyor',1116,1155,37,38,0,{[45]={{84.39,30.8},{84.35,30.75},{83.07,33.03},{83.71,33.68},{85.57,32.55},{86.37,31.5},{86.54,30.23},{84.35,29.85}}},nil,45,nil,nil,26,nil,nil,0},
[2574] = {'Drywhisker Digger',1469,1536,36,37,0,{[45]={{83.42,32.06},{82.1,36.12},{82.78,35.97},{83.9,34.14},{85.64,33.13},{85.04,34.33},{85.69,31.24},{85.21,31.22},{86.04,30.24},{85.47,30.05},{87.03,31.63},{84.24,28.91},{83.4,35.42},{84.58,31.43}}},nil,45,nil,nil,26,nil,nil,0},
[2575] = {'Dark Iron Supplier',935,977,31,32,0,{[45]={{48.41,87.46}}},nil,45,nil,nil,54,nil,nil,0},
[2577] = {'Dark Iron Shadowcaster',847,882,31,32,0,{[45]={{48.02,87.25},{48.82,87.69},{48.2,88.07}}},{[45]={{{48.24,88.09},{48.15,88.09},{47.97,88.1},{47.5,88.13},{47.13,88.14},{46.76,88.15},{46.43,88.15},{46.12,88.13},{46.44,88.15},{46.77,88.16},{47.19,88.15},{47.52,88.14},{47.85,88.13},{48.13,88.12}}}},45,nil,nil,54,nil,nil,0},
[2578] = {'Young Mesa Buzzard',1106,1162,31,32,0,{[45]={{28.06,34.37},{29.15,19.8},{43.4,61.24},{17.91,43.6},{20.17,47.05},{66.51,40.79},{68.8,49.58},{73.94,46.6},{68.37,53.22},{69.27,52.43},{60.03,41.55},{25.31,35.12},{27.11,38.01},{19.84,37.45},{26.73,24.84},{69.32,37.2},{42.37,56.62},{50.25,41.97}}},nil,45,nil,nil,7,"AH",nil,0},
[2579] = {'Mesa Buzzard',1279,1342,34,35,0,{[45]={{19.81,52.09},{33.94,66.08},{34.09,61.86},{37.71,26.69},{39.21,30.53},{36.51,66.29},{61.37,69.82},{40.36,66.94},{54.29,65.36},{50.31,70.91},{45.18,35.43},{43.28,38.75},{56.71,68.69},{55.96,55.73}}},nil,45,nil,nil,7,"AH",nil,0},
[2580] = {'Elder Mesa Buzzard',1536,1604,37,38,0,{[45]={{23.8,71.17},{24.32,68.88},{21.54,72.62},{46.93,81.68},{27.39,67.91},{15.98,64.53},{15.26,69.74},{16.42,66.82}}},nil,45,nil,nil,7,"AH",nil,0},
[2581] = {'Dabyrie Militia',1106,1162,31,32,0,{[45]={{53.41,38.05},{55.78,42.13},{55.54,38.56},{54.65,41.12},{57.23,40.32},{53.54,37.63},{57.02,36.36},{55.43,37.66},{57.13,36.14}}},nil,45,nil,nil,123,"A",nil,0},
[2582] = {'Dabyrie Laborer',1050,1106,30,31,0,{[45]={{55.2,38.93},{57.11,39.58},{57.28,39.65},{57.03,39.93},{54.48,38.47},{55.05,39.21},{55.73,39.98},{55.79,40.58},{55.3,41.08},{55.04,40.66},{55.05,39.91},{55.39,40.53},{55.44,39.86},{55.38,39.43},{56.18,35.66},{56.45,36.54},{53.95,39.03},{54.62,39.84},{54.72,39.34},{54.01,38.36},{56.51,40.04},{56.39,39.35},{56.17,36.4},{56.85,39.59},{54.41,37.82},{54.95,37.62}}},nil,45,nil,nil,123,"A",nil,0},
[2583] = {'Stromgarde Troll Hunter',3279,3405,37,38,1,{[45]={{22.11,59.61},{23.89,60.57},{22.06,62.99},{23.33,63.15},{21.79,61.48},{21.15,63.28},{23.56,59.57},{23.78,57.11},{24.82,57.89},{24.39,58.82},{25.18,58.7},{22.97,60.34}}},nil,45,nil,nil,123,"A",nil,0},
[2584] = {'Stromgarde Defender',4185,4377,38,39,1,{[45]={{23.39,57.75},{23.39,62.49},{27.92,58.99},{23.72,60.3},{23.71,60.73},{21.31,62.34},{25.21,58.1},{25.4,57.95},{25.38,58.36},{26.79,58.32},{26.79,57.95},{22.31,59.24}}},nil,45,nil,nil,123,"A",nil,0},
[2585] = {'Stromgarde Vindicator',4377,4572,39,40,1,{[45]={{22.06,58.78},{28.9,58.89},{28.04,57.99},{27.51,57.66},{27.33,58.86},{28.22,58.3},{21.17,60.53},{22.86,58.12},{24.87,57.15},{27.68,58.75}}},nil,45,nil,nil,123,"A",nil,0},
[2586] = {'Syndicate Highwayman',1050,1107,30,31,0,{[45]={{32.21,31.87},{29.32,26.85},{31.59,31.21},{32.11,24.79},{30.37,28.87},{30.63,25.68},{29.05,28.38},{30.3,24.33},{30.3,27.97},{34.19,26.96},{31.22,25.48},{30.97,29.79},{33.51,31.47},{33.79,30.77},{31.78,32.98},{34.67,28.35},{34.0,29.55},{34.69,29.88},{32.94,32.38},{33.92,32.94},{34.66,31.69},{34.7,27.0},{33.91,26.51}}},nil,45,nil,nil,87,nil,nil,0},
[2587] = {'Syndicate Pathstalker',1163,1221,32,33,0,{[45]={{31.3,26.15},{31.08,26.28},{30.67,28.36},{32.27,28.3},{32.62,31.23},{32.11,31.2},{33.46,30.84},{31.47,28.26},{33.4,27.62},{32.06,26.82}}},nil,45,nil,nil,87,nil,nil,0},
[2588] = {'Syndicate Prowler',3831,4008,36,37,1,{[45]={{25.39,63.4},{29.43,65.04},{28.33,63.36},{27.53,62.0},{28.15,66.16},{25.78,62.51},{29.17,62.27},{28.59,65.75},{25.39,64.52},{25.82,64.22},{26.75,65.62},{26.49,63.55},{29.54,64.39},{29.23,61.34},{29.22,62.75}}},nil,45,nil,nil,87,nil,nil,0},
[2589] = {'Syndicate Mercenary',1107,1163,31,32,0,{[45]={{30.9,26.16},{33.75,27.34},{32.11,25.35},{31.02,28.75},{32.11,30.91},{32.28,31.22},{31.86,25.64},{33.02,31.04},{33.66,29.8},{30.96,27.91},{33.6,29.25},{31.54,30.03},{32.47,26.75},{32.35,25.93}}},nil,45,nil,nil,87,nil,nil,0},
[2590] = {'Syndicate Conjuror',2706,2805,35,36,1,{[45]={{25.21,62.55},{27.44,65.56},{26.8,62.16},{29.44,65.15},{28.99,65.05},{28.54,62.65},{28.95,65.92},{25.38,65.86},{25.85,65.14},{26.02,63.76},{27.59,60.31},{26.78,60.86}}},nil,45,nil,nil,87,nil,nil,0},
[2591] = {'Syndicate Magus',2910,3012,37,38,1,{[45]={{29.25,63.02},{26.5,64.48},{26.45,65.2},{26.11,65.26},{25.97,65.43},{28.2,60.57},{29.24,62.29}}},nil,45,nil,nil,87,nil,nil,0},
[2592] = {'Rumbling Exile',1604,1678,38,39,0,{[45]={{36.6,60.79},{37.65,60.51},{35.59,60.54},{34.79,60.47},{34.91,55.92},{34.61,59.12},{37.49,59.25},{35.69,58.83},{36.55,58.94},{35.79,55.61},{37.7,56.43},{36.45,56.13},{34.9,57.39},{35.67,57.51},{37.44,57.63},{36.56,57.64}}},nil,45,nil,nil,91,nil,nil,0},
[2593] = {'Rough Stone Elemental',1536,1604,37,38,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[2594] = {'Sprogger',1536,1536,37,37,0,{[33]={{26.66,73.64}}},nil,33,{8554},{8553},120,"AH",nil,2},
[2595] = {'Daggerspine Raider',1604,1678,38,39,0,{[45]={{23.37,86.44},{19.13,86.8},{17.01,88.38},{21.86,86.45},{18.18,90.21},{25.52,91.39},{21.11,86.9},{20.2,87.05},{25.13,89.43},{22.39,90.09},{21.13,89.87},{22.57,86.91},{24.65,85.28},{20.7,86.74},{25.5,87.43},{25.42,85.23},{21.2,84.3},{22.61,86.76},{22.99,90.34},{23.49,84.95},{23.02,84.34},{23.26,84.78},{23.43,84.88},{23.31,86.52},{21.81,85.55},{23.24,88.1},{21.85,86.84},{21.19,84.31},{20.62,85.36},{20.07,86.93},{20.97,89.77},{21.05,90.04},{22.4,89.93},{24.14,88.51},{24.49,86.66},{18.98,86.8},{18.89,85.03},{19.07,83.86},{20.04,84.0},{21.93,83.92},{25.05,89.66},{25.51,91.22}}},nil,45,nil,nil,74,nil,nil,0},
[2596] = {'Daggerspine Sorceress',1196,1239,39,40,0,{[45]={{18.16,87.01},{21.87,89.93},{22.45,84.35},{23.75,84.84},{22.74,84.63},{20.55,84.8},{20.65,85.0},{21.27,84.08},{21.83,89.82},{23.78,89.85}}},nil,45,nil,nil,74,nil,nil,0},
[2597] = {'Lord Falconcrest',10668,10668,40,40,1,{[45]={{26.03,65.68}}},nil,45,nil,nil,87,nil,"Syndicate Leader",0},
[2598] = {'Darbel Montrose',5900,5900,39,39,2,{[45]={{26.51,60.74},{28.01,60.51},{29.78,60.67},{29.27,63.03},{26.06,62.29},{25.23,62.19},{27.08,62.22},{28.03,62.38},{28.28,63.16},{29.71,64.61},{28.66,65.85},{27.71,65.7},{27.39,64.91},{25.27,63.16}}},nil,45,nil,nil,16,nil,"Shadow Council Warlock",0},
[2599] = {'Otto',4185,4185,38,38,1,{[45]={{26.22,65.55}}},nil,45,nil,nil,87,nil,"Bodyguard",0},
[2600] = {'Singer',1064,1064,34,34,4,{[45]={{32.31,30.99}}},nil,45,nil,nil,16,nil,nil,0},
[2601] = {'Foulbelly',6605,6605,42,42,2,{[45]={{20.41,66.87},{20.79,65.98},{19.44,68.63},{17.9,68.6}}},nil,45,nil,nil,45,nil,nil,0},
[2602] = {'Ruul Onestone',3540,3540,39,39,2,{[45]={{18.07,68.78},{17.96,68.56}}},nil,45,nil,nil,45,nil,nil,2},
[2603] = {'Kovork',1468,1468,36,36,4,{[45]={{30.37,43.77},{33.0,44.04},{31.76,46.21}}},nil,45,nil,nil,45,nil,nil,0},
[2604] = {'Molok the Crusher',1678,1678,39,39,4,{[45]={{54.62,79.71},{53.23,80.18},{54.88,81.51}}},nil,45,nil,nil,45,nil,nil,0},
[2605] = {'Zalas Witherbark',1410,1410,40,40,4,{[45]={{64.83,73.45},{61.09,72.35},{67.89,78.47},{70.23,77.85},{69.27,79.62},{66.37,81.78},{67.43,80.66},{66.77,81.73},{69.09,81.4},{68.33,79.4}}},nil,45,nil,nil,654,nil,"Warband Leader",0},
[2606] = {'Nimar the Slayer',1536,1536,37,37,4,{[45]={{64.64,73.25},{64.36,74.68},{61.33,72.54},{60.2,72.26},{63.86,68.58},{63.23,67.67},{66.41,63.95},{65.64,63.48},{69.59,61.33},{73.5,64.91},{72.45,65.8},{69.65,66.18},{70.67,69.27},{70.28,70.24},{68.86,73.72}}},nil,45,nil,nil,654,nil,"Warband Leader",0},
[2607] = {'Prince Galen Trollbane',4278,4278,44,44,1,{[45]={{28.36,58.11}}},nil,45,nil,nil,123,"A",nil,2},
[2608] = {'Commander Amaren',2217,2217,45,45,0,{[45]={{45.97,46.75}}},nil,45,nil,nil,123,"A",nil,2},
[2609] = {'Geomancer Flintdagger',1239,1239,40,40,4,{[45]={{82.8,32.23}}},nil,45,nil,nil,26,nil,nil,0},
[2610] = {'Shakes O\'Breen',1753,1753,40,40,0,{[45]={{32.28,81.38}}},nil,45,{667,669},{663,667,668,670},390,"AH","Blackwater Raiders",2},
[2611] = {'Fozruk',4953,4953,42,42,1,{[45]={{67.73,37.65}}},{[45]={{{67.8,37.66},{67.28,38.15},{66.29,39.16},{65.44,40.06},{65.06,41.04},{64.69,41.25},{63.55,43.23},{63.66,41.81},{63.07,42.32},{62.21,42.87},{61.51,43.39},{60.49,44.35},{59.67,45.28},{58.86,46.0},{58.3,47.66},{57.13,47.69},{55.8,47.39},{54.74,47.76},{53.7,48.61},{52.76,49.96},{52.48,51.49},{52.42,52.68},{52.29,53.93},{51.82,55.0},{51.6,56.3},{51.45,57.5},{50.89,58.5},{50.16,59.57},{48.9,60.41},{48.28,61.82},{46.87,61.76},{45.97,61.44},{45.12,60.56},{44.2,59.76},{42.84,59.19},{41.91,58.86},{40.81,58.52},{40.23,58.18},{39.58,56.3},{38.78,56.06},{37.78,56.11},{36.12,55.69},{34.79,55.55},{33.57,55.63},{32.14,55.76},{31.14,55.53},{30.34,54.64},{30.21,53.89},{29.99,52.1},{29.91,51.07},{27.06,49.57},{25.99,48.1},{25.03,45.68},{23.65,43.11},{23.86,43.3},{23.6,42.17},{23.34,40.97},{23.13,39.69},{22.97,38.53},{22.93,36.92},{23.2,35.78},{23.36,35.26},{23.56,34.73},{23.93,33.59},{24.22,32.92},{24.6,31.7},{24.47,30.74},{25.06,30.54},{25.6,30.23},{25.56,29.97},{26.64,29.87},{26.86,29.42},{27.64,28.55},{28.11,28.97},{28.8,29.62},{29.67,30.93},{29.8,31.94},{31.77,33.37},{32.65,33.5},{33.67,33.39},{34.26,32.49},{34.93,30.97},{35.55,29.95},{35.98,29.05},{36.5,28.72},{37.2,28.35},{38.04,28.12},{38.82,28.36},{39.29,28.87},{39.91,29.2},{40.64,29.63},{41.18,29.99},{41.9,30.4},{42.41,31.18},{42.93,32.02},{43.78,32.66},{44.36,33.42},{44.94,33.93},{45.49,34.16},{45.91,34.29},{46.61,34.46},{47.59,34.89},{48.49,35.25},{48.93,35.64},{49.31,36.43},{49.85,37.07},{50.35,37.14},{51.23,37.24},{52.03,37.21},{53.18,36.17},{53.77,35.24},{54.5,34.52},{55.16,34.34},{55.95,34.26},{56.51,34.17},{57.24,33.96},{57.63,34.3},{58.19,34.93},{59.31,36.12},{60.25,36.07},{60.76,35.12},{61.0,34.73},{61.4,34.17},{62.14,33.7},{62.59,34.41},{63.39,35.36},{63.92,35.92},{64.83,36.44},{65.71,36.94},{66.51,37.41},{67.05,37.77},{67.46,38.3}}}},45,nil,nil,15,"AH",nil,0},
[2612] = {'Lieutenant Valorcall',3405,3405,38,38,1,{[45]={{33.47,52.08}}},{[45]={{{33.45,52.12},{34.15,52.21},{34.62,52.26},{35.29,52.4},{35.84,52.55},{36.55,52.76},{37.33,53.06},{38.18,53.44},{38.79,54.09},{39.24,54.53},{39.71,54.85},{40.38,54.88},{40.79,54.91},{41.18,54.9},{41.72,54.9},{42.16,54.92},{42.94,54.96},{43.48,55.68},{43.64,55.08},{43.89,54.25},{44.01,53.86},{44.32,53.36},{44.34,53.01},{44.3,52.62},{44.26,52.38},{44.19,51.98},{44.03,51.63},{44.0,51.22},{43.95,50.76},{43.92,50.35},{44.11,49.64},{44.22,49.25},{44.33,48.83},{44.46,48.38},{44.69,48.09},{44.91,47.75},{45.12,47.44},{45.5,47.0},{45.89,46.67},{46.14,46.44},{46.48,46.17},{46.98,45.94},{47.18,45.81},{47.4,45.63},{47.77,45.3},{48.06,45.04},{48.38,44.77},{48.73,44.28},{49.08,43.97},{49.38,44.12},{49.73,44.31},{50.27,44.63},{50.47,44.71},{50.77,44.56},{51.07,44.42},{51.37,44.35},{51.59,44.12},{51.8,43.49},{52.02,42.76},{52.18,42.31},{52.29,41.85},{52.4,41.48},{52.49,41.18},{52.6,40.94},{52.74,40.66},{52.99,40.6},{53.32,40.79},{53.71,40.88},{54.04,40.7},{53.76,40.92},{53.49,40.82},{53.12,40.61},{52.8,40.57},{52.56,40.93},{52.43,41.35},{52.29,41.88},{52.14,42.48},{51.92,42.97},{51.79,43.44},{51.54,44.13},{51.16,44.32},{50.8,44.49},{50.39,44.6},{49.94,44.35},{49.39,44.07},{48.93,43.98},{48.65,44.4},{48.36,44.72},{48.14,44.92},{47.85,45.18},{47.59,45.49},{47.28,45.72},{46.9,45.94},{46.53,46.18},{45.67,46.82},{45.32,47.17},{45.02,47.52},{44.64,48.11},{44.32,48.91},{44.14,49.43},{43.94,50.11},{43.92,50.61},{44.01,51.36},{44.21,52.04},{44.31,52.54},{44.38,53.15},{44.07,53.75},{43.82,54.3},{43.64,55.14},{43.35,55.37},{42.81,55.0},{42.23,54.9},{41.58,54.88},{40.78,54.86},{39.97,54.84},{39.24,54.51},{38.65,53.89},{37.91,53.28},{37.36,53.03},{36.78,52.77},{35.92,52.52},{35.36,52.38},{34.84,52.26},{34.24,52.19},{33.56,52.11},{33.01,52.07},{32.48,52.02},{31.63,51.88},{31.03,51.84},{30.51,51.52},{29.74,51.04},{29.05,50.65},{28.05,50.09},{27.18,49.89},{26.98,50.49},{26.74,51.29},{26.41,52.35},{26.15,53.41},{25.98,54.24},{25.94,54.75},{25.98,55.24},{26.07,55.81},{26.07,56.83},{26.06,57.56},{26.07,58.53},{26.08,59.12},{26.09,59.7},{25.59,60.05},{24.86,60.3},{24.22,60.53},{23.73,60.56},{22.95,60.48},{22.59,61.13},{22.26,61.94},{22.06,62.13},{20.99,62.29},{20.99,62.31},{22.01,62.21},{22.26,61.76},{22.82,60.47},{23.36,60.5},{23.96,60.52},{23.96,60.52},{24.4,60.48},{24.65,60.38},{25.13,60.27},{26.0,59.83},{26.08,59.04},{26.08,58.17},{26.08,57.57},{26.08,56.96},{26.05,55.59},{26.03,55.3},{25.94,54.58},{25.95,54.25},{26.2,53.15},{26.43,52.22},{26.71,51.29},{26.97,50.34},{27.18,49.75},{27.56,49.89},{28.11,50.17},{28.66,50.47},{29.21,50.76},{29.75,51.08},{30.2,51.35},{30.93,51.75},{31.6,51.91},{32.09,51.99},{32.57,52.06},{32.87,52.08}}}},45,nil,nil,123,"A",nil,2},
[2616] = {'Privateer Groy',1981,1981,42,42,0,{[15]={{68.84,53.22}}},nil,15,nil,{623},120,"AH",nil,2},
[2618] = {'Hammerfall Peon',1221,1279,33,34,0,{[45]={{61.22,57.4},{61.34,56.87},{61.88,57.33},{61.82,58.4},{61.19,58.24},{61.54,57.91},{59.66,58.51},{61.88,55.65},{59.42,57.17},{63.42,58.06},{62.74,58.03},{63.54,57.53},{63.12,58.79},{62.27,56.11},{62.69,59.43},{62.58,56.1},{62.52,55.71},{63.12,57.46},{63.29,59.31},{63.65,58.67},{61.49,55.48},{59.77,56.17},{60.73,57.15},{60.68,57.91},{59.85,57.2},{60.65,59.17},{60.3,55.99}}},nil,45,nil,nil,83,"H",nil,0},
[2619] = {'Hammerfall Grunt',1279,1342,34,35,0,{[45]={{64.41,60.75},{60.96,56.13},{59.67,57.14},{62.78,55.75},{62.29,58.29},{64.0,58.29},{61.52,60.15},{62.68,52.93},{62.83,60.52},{58.59,54.14},{64.58,56.25},{62.43,54.32},{59.45,56.01},{61.06,60.14},{58.53,55.6},{60.92,56.12}}},nil,45,nil,nil,83,"H",nil,0},
[2620] = {'Prairie Dog',8,8,1,1,0,{[45]={{63.85,30.54},{27.31,21.31},{30.71,41.45},{22.13,50.13},{39.26,67.53},{72.13,46.8},{53.99,33.43},{45.7,37.22},{33.5,62.51},{48.36,77.65},{37.63,25.69},{57.61,65.27},{37.26,37.25},{46.12,52.35},{40.52,47.63},{56.62,47.67},{49.89,67.19},{68.26,34.25},{28.31,44.36},{68.82,50.15},{77.81,35.45},{17.46,48.69},{63.81,41.63}},[17]={{54.97,34.6},{51.63,33.13},{52.84,53.75},{48.82,57.38},{41.98,15.44},{48.95,29.84},{48.05,13.2},{47.34,42.52},{41.44,79.92},{42.67,49.21},{41.94,45.28},{58.56,35.01},{43.31,41.32},{53.36,38.89},{55.31,38.29},{60.94,48.9},{41.0,18.89},{44.8,43.36},{43.17,81.58},{41.81,24.86},{39.05,13.98},{52.78,46.93},{53.3,12.8},{59.28,52.61},{44.31,20.4},{53.35,16.71},{46.03,60.47}},[215]={{56.4,88.87},{48.0,64.22},{54.57,49.54},{35.38,79.47},{50.15,57.53},{39.41,35.11},{39.71,44.22},{57.54,61.26},{49.99,90.11},{52.2,79.01},{39.34,16.89},{51.76,59.41},{45.38,45.13},{45.23,50.82},{59.62,23.27},{51.35,41.16},{51.41,9.81},{53.6,34.01},{46.95,34.96},{43.68,92.34},{55.61,28.09},{41.7,82.74},{46.08,80.16},{35.59,51.76},{33.03,41.95},{36.23,46.3},{57.43,61.15},{51.59,19.05},{34.07,29.84}},[40]={{51.14,76.14},{38.77,71.89},{61.52,49.02},{49.0,25.38},{51.51,63.94},{36.76,49.2},{49.62,30.73},{49.6,43.83},{60.84,40.61}}},nil,215,nil,nil,31,"AH",nil,0},
[2621] = {'Hammerfall Guardian',2768,2768,50,50,0,{[45]={{73.62,30.32},{72.5,35.23},{74.31,29.06},{74.49,34.74},{74.21,28.98},{73.31,30.3},{73.18,29.65},{73.19,30.38},{74.72,30.3},{74.24,30.3},{73.49,33.07},{72.96,33.47},{73.68,32.1},{73.68,31.71},{74.41,37.41},{75.19,36.58},{73.26,36.43},{74.33,38.21},{74.65,37.73},{74.73,38.38}}},nil,45,nil,nil,85,"H",nil,1},
[2622] = {'Sly Garrett',2398,2398,46,46,0,{[33]={{28.41,76.83}}},nil,33,nil,nil,120,"AH","Shady Goods",4},
[2623] = {'Spirit of Old',1,1,33,33,0,nil,nil,0,nil,nil,76,"AH",nil,0},
[2624] = {'Gazban',1238,1238,40,40,0,{[33]={{22.74,24.1}}},{[33]={{{22.74,24.12},{22.57,24.13},{22.31,24.19},{21.97,24.34},{21.66,24.65},{21.38,24.82},{21.02,24.52},{20.57,23.87},{20.18,23.28},{19.94,23.0},{19.69,22.62},{19.69,22.62},{19.96,23.05},{20.21,23.35},{20.59,23.87},{21.03,24.53},{21.4,24.79},{21.7,24.62},{22.04,24.3},{22.36,24.17},{22.57,24.15},{22.74,24.09}}}},33,nil,nil,35,"AH",nil,0},
[2625] = {'Viznik Goldgrubber',7842,7842,55,55,0,{[33]={{26.54,76.57}}},nil,33,nil,nil,120,"AH","Banker",256},
[2626] = {'Old Man Heming',2059,2059,43,43,0,{[33]={{27.42,77.16}}},nil,33,nil,nil,120,"AH","Fisherman",4},
[2627] = {'Grarnik Goodstitch',1279,1279,34,34,0,{[33]={{28.77,76.84}}},nil,33,nil,nil,120,"AH","Expert Tailor",17},
[2628] = {'Dalaran Worker',1221,1279,33,34,0,{[36]={{16.9,56.43},{12.51,74.87},{10.42,73.97},{14.72,75.58},{11.55,77.5},{13.86,77.62},{14.56,75.79},{16.48,74.88},{19.99,71.76},{20.44,58.15}}},nil,36,nil,nil,76,"AH",nil,0},
[2630] = {'Earthbind Totem',2,2,13,13,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2634] = {'Princess Poobah',1981,1981,42,42,0,{[33]={{38.53,80.58}}},nil,33,{630},{594,630},35,"AH",nil,2},
[2635] = {'Elder Saltwater Crocolisk',4185,4185,38,38,1,{[33]={{33.43,32.53},{25.35,19.22},{29.83,25.48},{29.32,22.28}}},nil,33,nil,nil,14,nil,nil,0},
[2636] = {'Blackwater Deckhand',1604,1604,38,38,0,{[45]={{33.2,81.47},{32.8,81.99},{31.41,80.71}}},nil,45,nil,nil,121,"AH",nil,0},
[2637] = {'Syndicate Bomb',1336,1336,37,37,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2638] = {'Syndicate Spectre',1037,1037,35,35,0,nil,nil,0,nil,nil,87,nil,nil,0},
[2639] = {'Vilebranch Axe Thrower',2310,2399,45,46,0,{[47]={{43.49,68.29},{46.28,66.93},{50.5,64.36},{45.31,69.52},{47.93,63.34},{43.52,66.96},{43.35,65.38},{48.7,63.16},{46.8,61.86}}},nil,47,nil,nil,795,nil,nil,0},
[2640] = {'Vilebranch Witch Doctor',1919,1990,46,47,0,{[47]={{47.56,69.49},{63.27,60.03},{63.75,59.94},{67.7,66.01},{67.33,66.35},{67.35,68.72},{68.52,70.25},{65.86,68.58},{68.94,69.37}}},nil,47,nil,nil,795,nil,nil,0},
[2641] = {'Vilebranch Headhunter',5757,5970,46,47,1,{[47]={{66.06,70.19},{66.06,70.19},{65.26,69.0},{67.71,70.81},{68.74,70.64},{68.33,70.88}}},nil,47,nil,nil,795,nil,nil,0},
[2642] = {'Vilebranch Shadowcaster',4179,4329,47,48,1,{[47]={{65.78,71.99},{68.03,73.17},{64.27,65.73},{63.48,65.79},{64.97,71.3},{63.7,71.36},{64.21,72.17},{65.27,73.4}}},nil,47,nil,nil,795,nil,nil,0},
[2643] = {'Vilebranch Berserker',5970,6186,47,48,1,{[47]={{66.52,71.81},{67.1,71.87},{63.26,66.57},{68.15,71.82},{68.2,72.6},{64.34,66.61},{63.56,69.97},{64.0,70.56},{64.56,70.54},{64.27,69.87},{64.59,72.72},{64.22,71.67},{66.07,73.49},{66.54,72.92},{64.33,67.54}}},nil,47,nil,nil,795,nil,nil,0},
[2644] = {'Vilebranch Hideskinner',6186,6414,48,49,1,{[47]={{67.48,76.24},{65.02,77.08},{59.16,66.11},{66.84,80.31},{64.05,78.62},{64.42,74.08},{66.03,74.53},{65.39,75.61},{63.55,73.13},{68.31,75.28},{57.61,66.63},{61.29,67.93},{62.07,66.43},{62.73,70.81},{62.09,69.19}}},nil,47,nil,nil,795,nil,nil,0},
[2645] = {'Vilebranch Shadow Hunter',4950,5130,48,49,1,{[47]={{62.49,65.34},{68.0,75.79},{68.0,74.69},{66.57,74.45},{66.57,77.33},{64.96,74.39},{63.18,73.02},{65.99,75.54},{65.02,75.84},{63.67,73.68},{62.48,72.16},{60.05,73.12},{59.1,71.32},{59.99,65.14},{62.14,70.2},{62.37,71.54},{62.56,65.97},{62.04,68.3},{62.69,68.68}}},nil,47,nil,nil,795,nil,nil,0},
[2646] = {'Vilebranch Blood Drinker',6414,6645,49,50,1,{[47]={{65.17,82.12},{64.6,82.16},{67.05,78.07},{67.82,77.46},{67.25,77.5},{65.98,82.36},{63.5,79.72},{66.61,81.29},{65.89,80.4},{66.8,79.96},{67.05,80.86},{62.86,78.16},{58.41,68.07},{62.93,77.78},{58.79,68.3},{61.28,72.21},{58.41,67.11},{63.13,83.36},{63.55,84.07},{63.54,82.16},{64.12,83.18},{61.61,72.46},{60.75,68.68},{60.42,73.98},{60.8,67.81},{60.47,68.22},{58.27,72.79},{60.48,64.57}}},nil,47,nil,nil,795,nil,nil,0},
[2647] = {'Vilebranch Soul Eater',6414,6645,49,50,1,{[47]={{67.69,78.0},{63.28,80.23},{65.65,82.49},{66.12,79.93},{67.35,80.25},{58.72,67.15},{61.4,72.85},{63.3,82.66},{59.98,71.48},{59.93,74.14},{60.55,67.59},{57.98,71.7},{57.98,72.81},{60.75,64.52},{60.79,65.61}}},nil,47,nil,nil,795,nil,nil,0},
[2648] = {'Vilebranch Aman\'zasi Guard',6645,6876,50,51,1,{[47]={{58.88,77.71},{55.99,82.03},{57.62,81.15},{58.29,82.41},{57.87,79.64},{57.87,83.16},{57.6,80.71},{54.48,83.98},{57.66,81.51},{56.15,83.71},{57.25,84.61},{56.36,84.9},{56.87,83.45},{60.06,80.37},{57.29,84.13},{57.95,76.64},{55.72,84.76},{57.24,85.89},{64.89,81.76},{57.35,86.55},{57.31,86.57},{61.75,81.53},{61.39,81.66},{56.44,80.93},{58.66,79.16},{57.06,68.76},{57.15,68.01},{59.65,78.97}}},nil,47,nil,nil,795,nil,nil,0},
[2649] = {'Witherbark Scalper',1829,1902,40,41,0,{[47]={{22.43,57.72},{21.75,57.54},{23.02,57.88},{23.12,58.47},{23.69,56.62},{21.95,55.22},{24.29,55.32},{22.85,55.16},{25.47,56.08},{25.18,57.96},{25.14,60.3},{24.58,59.05},{24.07,58.82}}},nil,47,nil,nil,654,nil,nil,0},
[2650] = {'Witherbark Zealot',1902,1981,41,42,0,{[47]={{21.79,56.7},{23.68,57.29},{22.82,58.34},{23.67,58.5},{22.76,56.24},{24.58,56.75},{23.55,55.37},{25.31,58.96},{24.52,60.19}}},nil,47,nil,nil,654,nil,nil,0},
[2651] = {'Witherbark Hideskinner',1981,2059,42,43,0,{[47]={{27.97,57.96},{28.01,58.94},{31.13,58.54},{31.61,56.52},{32.99,58.27},{31.9,57.58},{32.81,58.9},{31.69,58.23},{32.24,58.64},{32.68,57.34},{31.54,59.89},{29.83,61.28},{29.7,60.32},{30.48,60.08},{29.58,58.04},{28.74,56.55},{30.57,56.73},{30.59,57.69}}},nil,47,nil,nil,654,nil,nil,0},
[2652] = {'Witherbark Venomblood',2059,2059,43,43,0,{[47]={{31.15,57.4},{32.35,57.9},{31.67,57.95},{31.99,58.42},{32.59,59.77},{30.34,61.55},{29.69,58.91},{29.89,56.63}}},nil,47,nil,nil,654,nil,nil,0},
[2653] = {'Witherbark Sadist',2138,2218,44,45,0,{[47]={{30.61,71.36},{32.05,75.77},{32.58,67.03},{31.71,67.86},{36.68,66.13},{39.7,66.36},{40.27,66.04},{32.35,67.88},{25.4,66.43},{25.6,65.95},{34.96,72.82},{36.62,71.46},{36.86,72.17},{36.95,70.77},{32.95,75.7},{32.7,75.32},{36.53,63.01},{35.33,63.5},{35.67,65.91},{31.97,70.24}}},nil,47,nil,nil,654,nil,nil,0},
[2654] = {'Witherbark Caller',1618,1679,45,46,0,{[47]={{32.5,76.33},{32.05,67.05},{39.99,65.78},{36.02,72.85},{37.01,71.59}}},nil,47,nil,nil,654,nil,nil,0},
[2655] = {'Green Sludge',2399,2488,46,47,0,{[47]={{56.65,40.79},{59.78,42.99},{55.55,44.01},{55.7,44.61},{56.94,44.3},{56.87,43.63},{48.86,55.37},{57.19,44.09},{56.71,42.18},{60.2,42.83},{58.12,40.73},{57.52,41.87},{50.2,47.75},{49.02,48.69},{50.27,54.76},{47.72,53.8},{49.32,51.49},{57.83,43.75},{57.53,42.78},{48.43,51.8},{48.72,53.07},{48.19,49.98},{48.87,47.09},{49.47,46.47},{49.65,47.49},{45.72,44.19},{44.87,41.15},{43.8,43.8},{44.93,42.0},{45.77,43.04},{45.15,42.61},{46.85,43.68},{57.45,38.77},{55.81,44.49},{57.42,40.99},{59.47,41.98},{59.12,42.16},{59.87,41.3},{48.58,40.95},{47.98,42.25},{47.72,40.73},{47.02,41.47},{47.22,42.39},{46.37,39.91},{46.32,42.65},{46.24,40.9}}},nil,47,nil,nil,14,nil,nil,0},
[2656] = {'Jade Ooze',2488,2578,47,48,0,{[47]={{56.57,42.56},{58.95,40.85},{60.32,42.47},{57.15,43.38},{59.21,43.27},{58.36,42.59},{58.25,39.72},{55.99,42.72},{56.5,45.01},{56.52,43.42},{57.35,44.58},{55.62,41.01},{58.97,42.35},{56.19,39.01},{56.98,41.02},{56.9,42.99},{57.83,42.72},{58.47,42.17},{58.35,41.57},{58.19,40.89},{57.9,41.74},{49.51,48.57},{51.17,52.87},{50.09,51.07},{58.43,43.54},{59.36,43.42},{47.57,51.6},{58.27,44.73},{57.5,45.89},{49.41,53.08},{58.08,45.66},{48.21,48.05},{59.22,39.24},{56.63,44.73},{44.66,42.92},{58.34,38.55},{57.58,39.93},{56.3,42.35},{57.43,43.58},{47.54,41.64},{45.47,40.35},{45.62,39.32},{45.52,38.33},{46.06,39.56},{46.81,40.1}}},nil,47,nil,nil,14,nil,nil,0},
[2657] = {'Trained Razorbeak',1829,1981,40,42,0,{[47]={{17.94,53.17},{16.74,50.26},{16.24,50.75},{15.21,49.21},{15.55,49.28},{20.4,48.19},{18.27,53.0}}},nil,47,nil,nil,84,"A",nil,0},
[2658] = {'Razorbeak Gryphon',2059,2218,43,45,0,{[47]={{45.08,51.75}}},nil,47,nil,nil,1055,"A",nil,0},
[2659] = {'Razorbeak Skylord',2399,2578,46,48,0,{[47]={{63.83,51.95},{54.23,49.34}}},{[47]={{{54.24,49.46},{54.08,49.68},{54.09,50.11},{54.16,50.65},{54.12,51.08},{54.1,51.67},{54.3,51.92},{54.52,52.32},{54.8,52.84},{54.47,53.07},{54.22,53.16},{53.91,52.97},{53.52,52.87},{53.3,52.64},{52.99,52.34},{52.54,52.04},{52.5,51.59},{52.41,51.08},{52.21,50.63},{52.09,50.35},{51.97,50.01},{51.76,49.34},{51.73,48.96},{51.71,48.38},{51.7,47.94},{51.56,47.6},{51.27,46.85},{51.09,46.35},{51.13,45.83},{51.22,45.74},{51.67,45.52},{51.93,45.43},{52.3,45.46},{52.88,45.6},{53.23,45.91},{53.54,46.33},{53.67,46.71},{53.82,47.15},{53.94,47.61},{54.08,48.17},{54.22,48.96}}}},47,nil,nil,1055,"A",nil,0},
[2662] = {'Port Master Szik',1981,1981,42,42,0,nil,nil,0,nil,nil,1080,"AH","Boat Vendor",0},
[2663] = {'Narkk',1981,1981,42,42,0,{[33]={{28.13,74.42}}},nil,33,nil,nil,120,"AH","Pirate Supplies",5},
[2664] = {'Kelsey Yance',2059,2059,43,43,0,{[33]={{28.23,74.34}}},nil,33,nil,nil,120,"AH","Cook",4},
[2665] = {'Proximity Bomb',42,42,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2667] = {'Ward of Laze',13,13,37,37,0,nil,nil,0,nil,nil,45,nil,nil,0},
[2668] = {'Danielle Zipstitch',840,840,27,27,0,{[10]={{75.87,45.56}}},nil,10,nil,nil,12,"A","Tailoring Supplies",4},
[2669] = {'Sheri Zipstitch',1106,1106,31,31,0,{[10]={{75.68,45.57}}},nil,10,nil,nil,12,"A","Tailoring Supplies",4},
[2670] = {'Xizk Goodstitch',2059,2059,43,43,0,{[33]={{28.71,76.89}}},nil,33,{4782,4785},{4781,4785},120,"AH","Tailoring Supplies",7},
[2671] = {'Mechanical Squirrel',65,65,15,15,0,nil,nil,0,nil,nil,4,"A",nil,0},
[2672] = {'Cowardly Crosby',1752,1752,40,40,0,{[33]={{27.0,82.48}}},nil,33,nil,nil,35,"AH","Tailoring Supplies",4},
[2673] = {'Target Dummy',84,84,1,1,0,nil,nil,0,nil,nil,5,"H",nil,0},
[2674] = {'Advanced Target Dummy',84,84,1,1,0,nil,nil,0,nil,nil,3,"A",nil,0},
[2675] = {'Explosive Sheep',1002,1002,30,30,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2676] = {'Compact Harvest Reaper',1676,1743,40,41,0,nil,nil,0,nil,nil,47,nil,nil,0},
[2678] = {'Mechanical Dragonling',0,0,47,47,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2679] = {'Wenna Silkbeard',895,895,28,28,0,{[11]={{25.61,25.8}}},nil,11,nil,nil,55,"A","Special Goods Dealer",16388},
[2680] = {'Vilebranch Wolf Pup',2399,2488,46,47,0,{[47]={{44.65,65.4},{46.43,65.07},{46.54,69.71},{48.36,64.0},{47.26,66.04},{43.57,67.82},{67.98,70.64},{65.81,70.26},{63.54,65.24},{63.54,68.9},{66.73,72.36},{65.15,70.27},{68.25,68.69},{68.37,70.57}}},nil,47,nil,nil,38,nil,nil,0},
[2681] = {'Vilebranch Raiding Wolf',6645,6876,50,51,1,{[47]={{61.98,83.06},{60.63,78.86},{61.78,79.93},{60.79,77.38},{58.58,64.52},{58.76,64.9},{58.43,75.96},{60.76,79.81},{60.07,77.34},{58.91,75.54},{59.98,76.0}}},nil,47,nil,nil,38,nil,nil,0},
[2682] = {'Fradd Swiftgear',664,664,24,24,0,{[11]={{26.4,25.76}}},nil,11,nil,nil,875,"A","Engineering Supplies",6},
[2683] = {'Namdo Bizzfizzle',664,664,24,24,0,{[1]={{21.86,31.86}}},nil,1,nil,nil,875,"A","Engineering Supplies",6},
[2684] = {'Rizz Loosebolt',1106,1106,31,31,0,{[36]={{47.3,35.16}}},nil,36,nil,nil,35,"AH","Engineering Supplies",6},
[2685] = {'Mazk Snipeshot',1468,1468,36,36,0,{[33]={{28.5,75.12}}},nil,33,nil,nil,120,"AH","Engineering Supplies",4},
[2686] = {'Witherbark Broodguard',2138,2218,44,45,0,{[47]={{30.66,69.72},{29.48,70.66},{32.0,71.39},{34.36,66.8},{30.95,70.64},{35.46,74.41},{30.99,72.51},{32.07,73.29},{31.32,74.13},{30.63,73.64},{37.72,67.65},{35.1,73.7},{36.52,68.34},{35.35,71.35},{33.26,69.27},{33.35,73.61},{34.81,63.24},{34.76,68.27},{36.96,63.83},{35.84,64.69}}},nil,47,nil,nil,312,nil,nil,0},
[2687] = {'Gnaz Blunderflame',1981,1981,42,42,0,{[33]={{50.98,35.21}}},nil,33,nil,nil,35,"AH","Engineering Supplies",4},
[2688] = {'Ruppo Zipcoil',3082,3082,52,52,0,{[47]={{34.33,37.76}}},nil,47,nil,nil,35,"AH","Engineering Supplies",6},
[2689] = {'Hill Giant',2488,2578,47,48,0,nil,nil,0,nil,nil,778,nil,nil,0},
[2690] = {'Hill Giant Warden',2578,2672,48,49,0,nil,nil,0,nil,nil,778,nil,nil,0},
[2691] = {'Highvale Outrunner',2059,2138,43,44,0,{[47]={{33.14,42.2},{34.08,48.79},{33.04,51.52},{32.32,51.46},{33.33,47.34},{33.89,50.05},{31.2,51.67},{33.93,43.23},{34.04,44.6},{30.45,51.41},{28.72,51.23},{29.6,51.41}}},nil,47,nil,nil,1576,"A",nil,0},
[2692] = {'Highvale Scout',2138,2217,44,45,0,{[47]={{33.18,44.57},{33.2,45.98},{33.32,48.23},{31.83,48.34},{33.43,48.22},{32.18,50.27},{33.0,50.07},{33.16,43.52},{31.92,49.51},{30.4,50.14},{30.65,48.98},{29.66,50.05},{31.49,48.91}}},nil,47,nil,nil,1576,"A",nil,0},
[2693] = {'Highvale Marksman',2310,2398,45,46,0,{[47]={{32.25,42.7},{31.41,43.38},{32.32,47.43},{32.14,43.34},{32.01,46.2},{29.78,48.45},{29.28,49.58},{29.24,48.47},{28.33,46.26},{28.65,46.5},{31.53,47.46},{31.08,47.87},{31.27,48.33}}},nil,47,nil,nil,1576,"A",nil,0},
[2694] = {'Highvale Ranger',1918,1990,46,47,0,{[47]={{30.55,43.42},{29.79,43.28},{30.97,47.46},{28.47,45.43},{28.76,45.98},{30.62,48.39},{30.25,48.75},{30.8,47.61},{31.81,47.08}}},nil,47,nil,nil,1576,"A",nil,0},
[2695] = {'Sara Balloo',328,328,15,15,0,{[1537]={{63.5,67.3}}},nil,1537,{683},{637},55,"A",nil,2},
[2696] = {'Foggy MacKreel',1002,1002,30,30,0,{[45]={{43.24,92.64}}},nil,45,{647},nil,55,"A",nil,2},
[2697] = {'Clyde Ranthal',1106,1106,31,31,0,{[44]={{89.02,70.87}}},nil,44,nil,nil,12,"A","Leatherworking Supplies",6},
[2698] = {'George Candarte',1106,1106,31,31,0,{[267]={{92.02,38.23}}},nil,267,nil,nil,68,"H","Leatherworking Supplies",6},
[2699] = {'Rikqiz',2059,2059,43,43,0,{[33]={{28.49,76.05}}},nil,33,nil,nil,120,"AH","Leatherworking Supplies",4},
[2700] = {'Captain Nials',1902,1902,41,41,0,{[45]={{45.83,47.56}}},nil,45,{681,682},{634,681,682,684,685},12,"A",nil,3},
[2701] = {'Dustbelcher Ogre',1604,1678,38,39,0,{[3]={{62.52,68.44},{61.95,70.18},{29.39,56.79},{29.85,56.44}}},nil,3,nil,nil,45,nil,nil,0},
[2702] = {'Felhunter Trainer',198,198,10,10,0,nil,nil,0,nil,nil,55,"A","UNUSED",0},
[2703] = {'Zengu',1752,1752,40,40,0,{[45]={{73.8,33.96}}},nil,45,{639,640,643,644,645},{638,639,641,643,644,646},126,"H",nil,2},
[2704] = {'Hanashi',15505,15505,50,50,0,{[1637]={{81.53,19.63}}},nil,1637,nil,nil,876,"H","Weapon Master",19},
[2705] = {'Brewmeister Bilger',1221,1221,33,33,0,{[267]={{52.13,58.74}}},nil,267,nil,{647},55,"A",nil,2},
[2706] = {'Tor\'gan',1752,1752,40,40,0,{[45]={{74.72,36.29}}},nil,45,{641,671,672,673,674,701,702},{640,655,671,672,673,675,701,847},126,"H",nil,2},
[2707] = {'Shadra',18298,18298,55,55,1,nil,nil,0,nil,nil,32,"AH","The Venom Queen",0},
[2708] = {'Archmage Malin',1752,1752,40,40,0,{[1519]={{39.84,81.46}}},nil,1519,{690},{697},12,"A",nil,3},
[2709] = {'Imp Trainer',198,198,10,10,0,nil,nil,0,nil,nil,55,"A","UNUSED",0},
[2710] = {'Voidwalker Trainer',198,198,10,10,0,nil,nil,0,nil,nil,55,"A","UNUSED",0},
[2711] = {'Phin Odelic',1468,1468,36,36,0,{[267]={{50.35,59.05}}},nil,267,{659},{661},12,"A",nil,2},
[2712] = {'Quae',1604,1604,38,38,0,{[45]={{60.18,53.85}}},nil,45,{657,658,661},{658,659,660},123,"A",nil,2},
[2713] = {'Kinelory',1305,1305,38,38,0,{[45]={{60.24,53.92}}},nil,45,{660},{657},231,"A",nil,2},
[2714] = {'Forsaken Courier',1342,1342,35,35,0,{[45]={{52.47,61.53}}},{[45]={{{52.47,61.53},{52.01,61.26},{51.36,60.59},{50.99,59.85},{50.59,59.7},{50.09,59.38},{49.69,59.28},{49.06,59.24},{48.38,59.35},{47.82,59.55},{47.25,59.75},{46.63,59.72},{46.34,59.57},{45.72,59.15},{45.19,58.78},{44.64,57.76},{44.08,56.76},{43.42,55.63},{43.01,55.08},{42.5,54.92},{41.34,54.87},{40.66,54.87},{39.88,54.81},{39.49,54.78},{38.93,54.22},{38.25,53.48},{37.42,53.06},{36.26,52.63},{35.59,52.45},{34.91,52.29},{34.04,52.17},{33.17,52.07},{32.3,52.02},{31.12,51.8},{30.65,51.6},{29.84,51.12},{29.15,50.7},{28.33,50.24},{27.63,49.84},{27.16,49.68},{26.51,49.11},{26.16,48.41},{25.84,47.68},{25.3,46.29},{25.08,45.83},{24.43,44.74},{24.04,44.1},{23.62,42.98},{23.33,41.74},{23.14,40.87},{22.97,39.88},{22.81,38.81},{22.77,38.08},{22.75,37.03},{22.73,36.01},{22.63,34.65},{22.51,33.62},{22.29,33.14},{22.71,36.29},{22.63,34.37},{22.54,33.65},{22.25,33.0},{21.87,32.24},{21.39,31.36},{21.09,30.89},{20.93,30.64},{20.16,29.56}},{{20.01,29.36},{20.63,30.17},{21.05,30.9},{21.58,31.71},{22.09,32.76},{22.51,33.85},{22.59,34.61},{22.69,35.44},{22.75,36.1},{22.71,37.62},{22.75,38.4},{22.85,39.39},{22.99,40.16},{23.17,41.13},{23.36,41.96},{23.52,42.75},{23.72,43.38},{23.94,43.95},{24.41,44.68},{24.74,45.22},{25.05,45.76},{25.26,46.21},{25.46,46.65},{25.58,46.96},{25.8,47.59},{26.04,48.19},{26.29,48.76},{26.55,49.24},{27.25,49.79},{27.83,49.99},{28.59,50.41},{29.68,51.07},{30.82,51.76},{31.42,51.86},{31.94,51.97},{32.72,52.07},{33.95,52.18},{34.84,52.32},{36.31,52.67},{37.22,53.03},{37.9,53.37},{38.35,53.57},{38.98,54.28},{39.41,54.71},{40.97,54.91},{42.08,54.95},{43.02,55.08},{43.97,56.59},{44.85,58.1},{45.3,58.95},{45.8,59.2},{46.66,59.85},{47.6,59.72},{48.44,59.3},{49.14,59.28},{49.61,59.3},{50.43,59.5},{50.94,60.22},{51.31,60.7},{52.01,61.4},{52.79,61.58},{53.71,61.87},{54.53,62.1},{55.12,62.28},{55.49,62.46},{55.94,62.72},{56.51,63.01},{57.25,62.77},{57.64,62.81},{58.12,62.94},{58.72,63.09},{59.12,63.0},{59.55,62.66},{60.02,61.98},{60.59,61.19},{61.0,60.26},{61.06,59.84},{60.91,59.52},{60.92,59.56},{60.78,60.29},{60.69,60.86},{60.42,61.36},{60.29,61.56},{59.95,62.08},{59.74,62.38},{59.49,62.71},{59.22,62.9},{58.87,63.05},{58.68,63.04},{58.29,62.98},{57.92,62.83},{57.29,62.68},{56.56,63.0},{55.83,62.62},{55.17,62.27},{54.66,62.04},{54.03,61.87},{53.06,61.62}}},[267]={{{82.59,57.61},{82.11,57.07},{81.64,56.58},{81.25,56.13},{80.87,55.75},{80.16,55.16},{79.48,54.86},{78.88,54.44},{78.24,53.98},{77.68,53.6},{77.3,53.32},{76.7,52.63},{76.4,52.26},{76.09,51.87},{75.32,50.98},{74.6,50.15},{73.56,49.12},{72.47,48.18},{71.0,47.18},{70.04,46.57},{68.96,46.05},{68.01,45.41},{67.48,44.83},{67.08,44.29},{66.73,43.76},{66.54,43.51},{66.11,42.97},{65.5,42.34},{64.64,42.08},{64.0,41.94},{63.27,41.76},{62.82,41.58},{62.32,41.39},{61.68,40.96},{61.16,40.48},{60.89,40.15},{60.52,39.71},{60.23,39.35},{59.75,38.77},{58.71,37.61},{57.72,36.61},{57.41,35.65},{57.27,35.15},{57.0,34.18},{56.76,33.11},{56.53,32.03},{56.34,30.99},{56.1,29.92},{55.97,28.94},{55.84,27.87},{55.76,26.65},{55.74,25.48},{55.69,24.43},{55.66,23.59},{55.72,22.68},{55.77,21.36},{55.75,20.52},{55.7,19.73},{56.37,19.66},{56.91,19.85},{57.53,19.71},{58.27,19.49},{58.71,20.02},{59.04,20.69},{59.28,21.06},{59.88,21.28},{60.41,21.13},{60.82,20.54},{61.37,20.02},{62.26,20.35},{61.58,20.14},{61.41,20.01},{61.01,20.24},{60.77,20.63},{60.45,21.07},{60.04,21.26},{59.64,21.18},{59.33,21.03},{59.05,20.68},{58.82,20.17},{58.54,19.81},{58.16,19.52},{57.64,19.67},{57.29,19.76},{57.02,19.79},{56.77,19.81},{56.32,19.59},{56.0,19.6},{55.75,20.73},{55.76,21.5},{55.74,22.72},{55.64,23.57},{55.69,24.9},{55.7,25.89},{55.76,27.22},{55.85,28.02},{56.07,29.88},{56.24,30.5},{56.42,31.53},{56.58,32.4},{56.82,33.49},{57.01,34.19},{57.18,34.78},{57.36,35.45},{57.57,36.11},{57.75,36.71},{58.13,37.09},{59.03,37.98},{59.43,38.4},{60.02,39.17},{60.77,40.07},{61.13,40.49},{61.52,40.87},{62.05,41.26},{62.42,41.45},{62.85,41.62},{63.28,41.78},{63.68,41.89},{64.73,42.09},{65.75,42.6},{66.52,43.48},{66.79,43.94},{67.26,44.6},{67.81,45.24},{68.82,45.93},{69.77,46.41},{70.3,46.7},{71.5,47.55},{72.42,48.14},{73.05,48.68},{73.83,49.38},{74.46,49.93},{75.05,50.64},{75.49,51.18},{75.94,51.68},{76.38,52.15},{76.98,52.92},{77.45,53.42},{78.22,53.98},{78.71,54.34},{79.44,54.83},{79.34,55.12},{80.26,55.3},{80.86,55.74},{81.39,56.29},{82.1,57.05}}}},45,nil,nil,83,"H",nil,0},
[2715] = {'Dustbelcher Brute',1678,1753,39,40,0,{[3]={{29.65,57.42},{62.91,69.57}}},nil,3,nil,nil,45,nil,nil,0},
[2716] = {'Dustbelcher Wyrmhunter',1829,1902,40,41,0,{[3]={{12.53,74.36},{12.8,73.66},{12.2,76.05},{8.02,72.29},{8.15,78.21},{10.59,77.63},{10.61,73.94}}},nil,3,nil,nil,45,nil,nil,0},
[2717] = {'Dustbelcher Mauler',1902,1981,41,42,0,{[3]={{9.43,75.66},{12.99,73.69},{10.74,75.86},{13.69,74.08},{13.95,75.97},{13.5,75.48},{9.63,83.86},{9.94,81.96},{9.43,80.5},{8.0,82.04},{7.99,73.84}}},nil,3,nil,nil,45,nil,nil,0},
[2718] = {'Dustbelcher Shaman',1585,1648,42,43,0,{[3]={{8.35,76.18},{12.28,74.85},{13.65,74.97},{9.41,86.29},{10.98,80.13},{9.53,77.84},{8.14,83.9}}},nil,3,nil,nil,45,nil,nil,0},
[2719] = {'Dustbelcher Lord',2138,2218,44,45,0,{[3]={{6.53,90.64},{7.59,90.4},{9.7,93.03},{9.93,92.33},{7.59,95.56},{7.09,94.53},{7.85,94.25}}},nil,3,nil,nil,45,nil,nil,0},
[2720] = {'Dustbelcher Ogre Mage',1441,1496,43,44,0,{[3]={{7.1,90.78},{7.66,89.53},{8.0,92.38},{8.55,88.25},{8.06,90.89},{7.57,85.7},{8.64,91.0},{7.85,88.13},{9.62,89.29},{9.68,88.25}}},nil,3,nil,nil,45,nil,nil,0},
[2721] = {'Forsaken Bodyguard',1342,1342,35,35,0,{[45]={{52.56,61.54},{52.63,61.68},{52.72,61.57},{52.65,61.43}}},nil,45,nil,nil,83,"H",nil,0},
[2723] = {'Stone Golem',1674,1751,38,39,0,{[3]={{40.17,27.34},{40.7,26.45},{39.73,27.62},{41.71,26.67},{41.57,28.23},{42.03,29.23},{42.31,28.71}}},nil,3,nil,nil,54,nil,nil,0},
[2725] = {'Scalding Whelp',1522,1648,41,43,0,{[3]={{81.4,30.71},{84.54,28.6},{81.39,30.09},{85.73,28.55},{85.7,27.81},{84.77,29.81},{83.71,30.51},{80.66,37.38},{81.44,32.66},{82.1,39.05},{83.22,32.67},{84.12,39.65},{82.42,34.56},{76.32,32.66},{77.94,34.38},{79.36,35.57},{82.74,42.87},{72.16,64.64},{83.25,33.67},{79.86,56.72},{72.34,57.38},{69.67,53.81},{72.82,52.44},{71.08,51.7},{73.22,62.94},{74.23,67.63},{77.22,63.4},{75.23,65.95}}},nil,3,nil,nil,16,nil,nil,0},
[2726] = {'Scorched Guardian',5148,5544,43,45,1,{[3]={{84.68,55.85},{81.83,47.93},{82.08,51.75},{83.19,53.5},{79.69,47.86},{80.42,53.59},{79.23,52.29},{81.03,45.47},{82.21,55.77},{80.34,50.02},{77.44,53.8},{83.27,57.7}}},nil,3,nil,nil,16,nil,nil,0},
[2727] = {'Crag Coyote',1403,1469,35,36,0,{[3]={{49.77,46.24},{48.39,49.79},{48.49,34.5},{49.79,41.5},{49.65,46.13},{51.22,50.9},{52.75,39.24},{58.09,46.49},{46.87,48.33},{48.85,42.42},{53.71,47.99},{48.31,37.98},{47.83,39.77},{46.68,44.14},{50.26,40.01},{50.97,38.08},{46.86,35.96},{50.16,35.24},{49.87,41.92},{55.04,49.94},{52.87,14.63},{52.38,24.69},{55.04,48.1},{54.88,24.81},{52.33,20.55},{53.79,17.5},{53.74,22.18},{53.18,52.03}}},nil,3,nil,nil,38,nil,nil,0},
[2728] = {'Feral Crag Coyote',1536,1604,37,38,0,{[3]={{56.35,67.97},{52.41,60.64},{55.51,67.23},{60.4,71.69},{59.23,70.81},{63.1,51.32},{61.68,49.73},{57.82,68.24},{60.71,63.29},{59.46,67.83},{55.3,68.51},{45.9,73.47},{60.77,48.07},{59.07,51.86},{57.85,59.85},{60.15,60.51},{58.0,63.92},{53.0,56.65},{57.98,56.52},{58.78,54.32},{58.88,55.51},{59.33,60.49},{53.48,58.17},{55.56,53.83},{60.58,55.66},{55.19,58.29},{56.2,59.03},{61.62,65.68},{55.52,56.68},{60.87,50.21},{56.66,60.97},{53.42,51.92},{53.51,61.33},{55.0,63.76},{54.23,74.7},{58.83,50.45},{48.65,76.25},{44.41,71.99},{55.02,52.02}}},nil,3,nil,nil,38,nil,nil,0},
[2729] = {'Elder Crag Coyote',1604,1752,38,40,0,{[3]={{41.58,71.37},{32.57,59.6},{40.06,68.58},{37.35,57.76},{35.89,61.08},{38.72,69.85},{37.86,69.13},{31.81,73.64},{37.58,62.99},{37.93,66.78},{35.74,73.51},{39.19,67.41},{18.78,53.9},{34.64,61.63},{33.44,54.48},{29.42,68.01},{31.09,60.15},{28.28,72.13},{29.72,64.11},{11.18,63.12},{32.5,57.84},{34.34,70.24},{10.37,67.05},{35.0,64.29},{26.36,53.02},{10.5,63.7},{33.61,71.12},{13.51,63.77},{12.88,67.37},{16.86,65.69},{27.48,60.4},{22.78,58.17},{20.91,56.85},{28.25,47.6},{24.31,58.57},{14.12,68.11},{12.91,65.83},{25.49,56.03},{30.67,62.31},{30.66,74.21},{30.09,63.84},{21.41,56.33},{30.99,70.91},{32.4,66.18},{27.35,62.23},{23.32,51.59}}},nil,3,nil,nil,38,nil,nil,0},
[2730] = {'Rabid Crag Coyote',1981,2059,42,43,0,{[3]={{70.3,33.65},{69.04,30.76},{69.36,36.22},{71.48,34.79},{70.28,32.76},{72.68,33.39}}},nil,3,nil,nil,38,nil,nil,0},
[2731] = {'Ridge Stalker',1469,1536,36,37,0,{[3]={{60.61,30.48},{61.77,39.34},{38.11,46.45},{65.33,37.05},{65.77,37.51},{33.48,43.29},{45.21,40.52},{33.59,40.94},{61.99,29.93},{60.64,43.75},{62.64,46.34},{36.12,43.29},{44.78,35.68},{63.08,29.62},{61.78,40.19},{57.11,28.28},{34.74,41.75},{46.17,37.58},{59.09,25.58},{42.86,40.23},{43.65,38.33},{53.82,15.46},{40.11,37.71},{35.13,40.37},{55.18,15.09}}},nil,3,nil,nil,16,nil,nil,0},
[2732] = {'Ridge Huntress',1604,1678,38,39,0,{[3]={{49.64,60.11},{41.37,50.97},{36.56,48.29},{56.66,74.95},{56.69,46.6},{65.01,68.4},{48.26,52.53},{59.31,44.64},{45.86,46.6},{40.26,61.51},{43.64,74.2},{40.37,64.11},{40.5,58.28},{32.19,49.93},{41.09,63.25},{60.68,62.25},{34.13,49.14},{53.6,39.48},{44.47,47.64},{47.56,51.85},{41.51,67.01},{63.07,73.73},{50.19,57.13},{63.12,64.36},{51.75,58.1},{44.39,72.85},{30.12,49.9},{43.2,69.51},{46.68,49.74},{30.04,45.54},{31.49,51.62},{31.78,46.86},{30.62,47.87},{35.51,55.99},{39.43,60.0},{46.89,76.73},{39.87,73.14},{53.81,45.94},{34.79,51.21},{49.48,58.37},{41.65,59.93},{36.92,49.86}}},nil,3,nil,nil,16,nil,nil,0},
[2733] = {'Apothecary Jorell',1469,1469,36,36,0,{[45]={{60.09,59.32}}},nil,45,nil,nil,83,"H",nil,0},
[2734] = {'Ridge Stalker Patriarch',1829,1902,40,41,0,{[3]={{15.21,51.77},{16.15,53.76},{8.38,57.82},{12.71,55.4},{19.86,72.5},{28.28,66.51},{19.46,70.43},{21.28,68.93},{25.88,64.01},{16.54,49.94},{10.35,58.82},{14.88,56.01},{25.68,71.45},{17.95,67.18},{26.08,74.72},{14.63,57.07},{20.32,62.03},{18.51,65.93},{25.36,79.32},{20.39,60.07},{22.86,60.22},{10.79,70.1}}},nil,3,nil,nil,16,nil,nil,0},
[2735] = {'Lesser Rock Elemental',1536,1678,37,39,0,{[3]={{15.07,37.57},{13.32,37.97},{13.14,39.2},{16.41,37.56},{21.33,44.1},{18.81,42.99},{21.2,45.88},{20.11,43.19},{17.69,41.3},{16.8,42.74},{14.74,41.8},{19.26,41.21},{21.6,47.86},{19.09,45.75},{23.1,47.75},{23.53,45.47},{20.15,47.94},{22.42,43.66}}},nil,3,nil,nil,91,nil,nil,0},
[2736] = {'Greater Rock Elemental',1981,2138,42,44,0,{[3]={{5.48,76.95},{6.94,80.15},{5.67,79.94},{2.77,78.22},{3.0,79.81},{4.13,77.33},{1.44,82.1},{4.11,79.91},{1.44,80.18},{2.88,82.18},{1.57,84.51},{3.74,82.18},{5.48,82.27},{0.93,78.67},{4.93,83.72},{6.65,73.85},{6.57,76.28},{15.97,90.15},{16.21,88.1},{16.16,85.47},{17.03,84.3},{14.65,86.34},{13.27,87.76},{15.02,88.01},{13.75,90.23},{13.37,86.12},{13.32,84.08},{14.74,90.46}}},nil,3,nil,nil,91,nil,nil,0},
[2737] = {'Durtham Greldon',1752,1752,40,40,0,{[1537]={{51.26,14.97}}},nil,1537,nil,nil,55,"A",nil,16},
[2738] = {'Stromgarde Cavalryman',3831,4008,36,37,1,{[45]={{33.4,51.95},{33.31,52.06}}},nil,45,nil,nil,123,"A",nil,2},
[2739] = {'Shadowforge Tunneler',1403,1469,35,36,0,{[3]={{52.43,31.19},{52.56,32.02},{54.06,33.44},{52.32,32.71},{53.33,32.7},{54.09,34.11},{53.43,33.44},{54.52,33.89},{51.89,31.79},{54.52,31.42},{53.71,30.65}}},nil,3,nil,nil,54,nil,nil,0},
[2740] = {'Shadowforge Darkweaver',1075,1116,36,37,0,{[3]={{53.76,32.31},{51.47,34.3},{53.58,31.08},{52.59,33.69},{53.29,34.31},{52.85,34.43}}},nil,3,nil,nil,54,nil,nil,0},
[2741] = {'Shadowforge Excavator',1536,1604,37,38,0,nil,nil,0,nil,nil,54,nil,nil,0},
[2742] = {'Shadowforge Chanter',1256,1357,37,39,0,{[3]={{40.43,25.86},{39.65,27.76},{39.78,27.34},{43.93,31.28},{41.35,29.62},{40.62,28.87},{42.08,30.78},{42.54,27.51},{43.35,28.48},{41.86,26.96},{41.78,27.1},{42.03,27.0},{41.23,28.68},{40.88,28.92}}},nil,3,nil,nil,54,nil,nil,0},
[2743] = {'Shadowforge Warrior',1604,1678,38,39,0,{[3]={{41.54,33.72},{45.32,30.59},{44.22,29.46},{40.65,25.76},{40.63,25.91},{40.15,26.51},{42.62,33.11},{43.82,30.86},{43.74,31.01},{41.31,34.53},{40.82,29.48},{42.32,30.12},{40.99,29.18},{45.66,33.79},{43.1,30.53},{43.35,30.08},{42.68,29.62},{44.39,33.54},{44.46,31.63},{42.92,29.0},{42.21,26.95},{41.82,27.71},{40.79,29.18}}},nil,3,nil,nil,54,nil,nil,0},
[2744] = {'Shadowforge Commander',1752,1752,40,40,4,{[3]={{41.49,29.75}}},{[3]={{{40.93,29.1},{40.47,28.48},{39.76,27.65},{40.04,26.96},{40.49,26.15},{40.79,25.72},{41.5,26.58},{42.0,27.19},{42.48,27.79},{42.0,27.19},{41.5,26.58},{40.79,25.72},{40.49,26.15},{40.04,26.96},{39.76,27.65},{40.47,28.48},{40.93,29.1},{41.47,29.71}}}},3,nil,nil,54,nil,nil,0},
[2745] = {'Ambassador Infernus',3963,3963,42,42,1,{[3]={{42.1,28.88}}},nil,3,nil,nil,54,nil,nil,0},
[2746] = {'Stonevault Warden',4377,4377,39,39,1,nil,nil,0,nil,nil,415,nil,nil,0},
[2748] = {'Archaedas',29850,29850,47,47,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,415,nil,"Ancient Stone Watcher",0},
[2749] = {'Siege Golem',5334,5334,40,40,2,{[3]={{19.86,56.58},{15.9,59.23},{11.58,59.14},{8.6,61.81},{5.49,59.53},{15.82,65.31},{19.07,60.63},{24.61,55.58},{24.53,50.11},{29.18,47.41},{31.47,50.02},{35.66,47.63},{36.25,41.73},{40.03,39.82}}},nil,3,nil,nil,91,nil,nil,0},
[2751] = {'War Golem',1469,1469,36,36,4,{[3]={{52.41,19.48},{49.38,12.06},{45.36,33.53}}},nil,3,nil,nil,91,nil,nil,0},
[2752] = {'Rumbler',2218,2218,45,45,4,{[3]={{14.73,89.33},{13.86,86.11},{4.77,81.78},{1.98,80.52}}},nil,3,nil,nil,91,nil,nil,0},
[2753] = {'Barnabus',1046,1046,38,38,0,{[3]={{46.25,74.33},{38.88,67.98},{55.84,67.75}}},nil,3,nil,nil,38,nil,nil,0},
[2754] = {'Anathemus',8316,8316,45,45,2,{[3]={{23.7,74.16}}},{[3]={{{25.72,72.72},{27.21,71.02},{28.6,69.22},{30.4,68.08},{31.77,66.03},{32.6,63.24},{34.15,61.29},{36.4,58.2},{37.2,57.1},{40.13,55.38},{42.23,54.14},{44.09,52.73},{45.54,51.63},{47.04,49.39},{49.35,48.5},{51.65,50.09},{52.89,53.33},{53.17,57.73},{53.39,61.29},{53.01,64.63},{52.75,66.92},{52.98,69.35},{53.13,70.83},{52.1,73.64},{49.97,73.8},{48.46,72.89},{46.91,72.73},{45.17,72.13},{42.83,71.32},{41.0,70.69},{38.64,67.92},{36.26,65.18},{33.24,63.0},{31.46,61.72},{30.01,59.41},{28.02,58.51},{25.68,57.44},{23.66,57.7},{21.24,58.0},{19.6,58.04},{18.95,59.77},{17.41,62.18},{15.3,64.37},{14.35,65.08},{13.99,66.07},{13.06,68.91},{13.15,71.2},{12.69,74.93},{12.83,76.91},{13.96,78.32},{15.93,78.66},{17.86,78.85},{19.16,78.17},{20.7,78.5},{22.54,77.53},{23.16,76.9},{23.51,75.63},{23.64,74.24}}}},3,nil,nil,778,nil,nil,0},
[2755] = {'Myzrael',11408,11408,44,44,1,nil,nil,0,nil,nil,7,"AH",nil,0},
[2756] = {'UNUSED Grund Drokda',55,55,1,1,0,nil,nil,0,nil,nil,35,"AH","Reuse Me",0},
[2757] = {'Blacklash',11075,11075,50,50,1,nil,nil,0,nil,nil,103,nil,nil,0},
[2759] = {'Hematus',13290,13290,50,50,1,nil,nil,0,nil,nil,103,nil,nil,0},
[2760] = {'Burning Exile',1604,1678,38,39,0,{[45]={{25.64,28.53},{26.33,28.34},{27.43,31.39},{24.37,29.48},{24.78,28.52},{26.48,30.99},{26.51,32.61},{26.43,29.69},{25.21,30.51},{25.64,29.82},{25.81,30.65},{24.59,32.75},{24.99,31.87},{24.38,30.52}}},nil,45,nil,nil,16,nil,nil,0},
[2761] = {'Cresting Exile',1305,1357,38,39,0,{[45]={{67.38,28.52},{65.36,31.01},{66.2,28.24},{65.3,28.82},{67.94,31.15},{66.79,30.83},{66.01,31.14},{67.04,31.13},{67.76,29.75},{67.07,29.85},{66.76,29.24},{66.56,29.9},{65.02,29.8},{67.98,28.04}}},nil,45,nil,nil,16,nil,nil,0},
[2762] = {'Thundering Exile',1305,1357,38,39,0,{[45]={{52.11,49.4},{51.99,50.39},{51.81,50.97},{52.24,50.77},{51.38,51.93},{52.53,52.09},{53.3,49.32},{50.39,50.83},{51.1,49.86},{52.15,47.73},{53.17,50.82},{50.51,53.32}}},nil,45,nil,nil,16,nil,nil,0},
[2763] = {'Thenan',4953,4953,42,42,1,nil,nil,0,nil,nil,14,nil,nil,0},
[2764] = {'Sleeby',1409,1409,40,40,0,{[45]={{67.68,37.57}}},nil,45,nil,nil,15,"AH",nil,0},
[2765] = {'Znort',1677,1677,39,39,0,{[45]={{67.79,37.74}}},nil,45,nil,nil,15,"AH",nil,0},
[2766] = {'Lolo the Lookout',1677,1677,39,39,0,{[45]={{31.78,82.68}}},nil,45,{663},nil,390,"AH","Blackwater Raiders",2},
[2767] = {'First Mate Nilzlix',1678,1678,39,39,0,{[45]={{32.8,81.48}}},nil,45,{662},{662},120,"AH","Blackwater Raiders",2},
[2768] = {'Professor Phizzlethorpe',1604,1604,38,38,0,{[45]={{33.87,80.55}}},nil,45,{665},nil,35,"AH","Blackwater Raiders",2},
[2769] = {'Captain Steelgut',1677,1677,39,39,0,{[45]={{34.0,80.8}}},nil,45,{664},{664},120,"AH","Blackwater Raiders",2},
[2770] = {'Tallow',840,840,27,27,0,{[267]={{61.87,19.57}}},nil,267,{676},nil,68,"H",nil,2},
[2771] = {'Drum Fel',1002,1002,30,30,0,{[45]={{74.24,33.92}}},nil,45,{677,678,679},{676,677,678,679},125,"H",nil,3},
[2772] = {'Korin Fel',1342,1342,35,35,0,{[45]={{74.04,33.07}}},nil,45,{680},{680},125,"H",nil,2},
[2773] = {'Or\'Kalar',4953,4953,40,40,1,{[45]={{18.56,66.24},{18.59,66.41},{20.71,65.41},{19.53,68.3},{18.63,65.96},{19.36,68.68},{20.79,65.13}}},nil,45,nil,nil,45,nil,nil,0},
[2774] = {'Doctor Draxlegauge',1604,1604,38,38,0,{[45]={{33.86,80.45}}},nil,45,{666,668},{665,666},120,"AH","Blackwater Raiders",2},
[2775] = {'Daggerspine Marauder',1829,1902,40,41,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2776] = {'Vengeful Surge',1752,1752,40,40,0,nil,nil,0,nil,nil,91,nil,nil,0},
[2778] = {'Deckhand Moishe',1536,1536,37,37,0,{[45]={{32.61,80.06}}},nil,45,nil,nil,120,"AH","Blackwater Raiders",0},
[2779] = {'Prince Nazjak',1902,1902,41,41,4,{[45]={{19.37,90.15}}},nil,45,nil,nil,74,nil,nil,0},
[2780] = {'Caretaker Nevlin',4755,4755,41,41,1,{[45]={{29.22,59.48}}},nil,45,nil,nil,123,"A",nil,2},
[2781] = {'Caretaker Weston',4755,4755,41,41,1,{[45]={{29.07,60.23}}},nil,45,nil,nil,123,"A",nil,2},
[2782] = {'Caretaker Alaric',4755,4755,41,41,1,{[45]={{28.98,59.68}}},nil,45,nil,nil,123,"A",nil,2},
[2783] = {'Marez Cowl',4572,4572,40,40,1,{[45]={{29.62,62.97}}},nil,45,nil,nil,16,nil,nil,0},
[2784] = {'King Magni Bronzebeard',999300,999300,63,63,3,{[1537]={{39.09,56.2}}},nil,1537,{686,4341,4362},{683,700,4361,4363,7063,8484},55,"A","Lord of Ironforge",2},
[2785] = {'Theldurin the Lost',1002,1002,30,30,0,{[3]={{51.39,76.87}}},nil,3,{656,692,709,727,728},{687,692,709,737},35,"AH",nil,3},
[2786] = {'Gerrig Bonegrip',1002,1002,30,30,0,{[1537]={{50.83,5.62}}},nil,1537,{687,735,737,971},{653,727,735,968,971},55,"A",nil,2},
[2787] = {'Zaruk',4120,4120,60,60,0,{[45]={{74.54,35.64}}},nil,45,{687},{688},83,"H",nil,2},
[2788] = {'Apprentice Kryten',1002,1002,30,30,0,{[45]={{46.2,47.75}}},nil,45,{691,695},{691,694},1078,"A",nil,3},
[2789] = {'Skuerto',1468,1468,36,36,0,{[45]={{46.65,47.01}}},nil,45,{693,694,696,697},{690,693,695,696},55,"A",nil,3},
[2790] = {'Grand Mason Marblesten',2138,2138,44,44,0,{[1537]={{39.04,88.05}}},{[1537]={{{38.09,87.72},{37.4,87.4},{37.19,87.08},{37.37,86.16},{37.49,85.94},{38.6,86.82},{37.49,85.94},{37.37,86.16},{37.19,87.08},{37.4,87.4},{38.09,87.72}}}},1537,{689,700},{686,689},55,"A","Royal Stonecutters Union",2},
[2791] = {'Enraged Rock Elemental',1981,2059,42,43,0,{[3]={{53.7,82.4},{53.8,81.79},{53.83,82.55},{55.29,85.61},{56.05,82.76},{54.22,85.57},{55.57,87.21},{53.87,83.91},{52.59,85.55},{56.55,83.64},{54.52,81.95},{56.05,84.03}}},nil,3,nil,nil,91,nil,nil,0},
[2792] = {'Gor\'mul',1752,1752,40,40,0,{[45]={{72.64,33.93}}},{[45]={{{72.77,33.66},{72.54,34.01},{72.61,34.16},{72.82,34.22},{72.8,34.14},{72.8,34.14}}}},45,{655,675,847},{674,702},29,"H",nil,2},
[2793] = {'Kor\'gresh Coldrage',1357,1357,39,39,0,{[45]={{54.75,81.87}}},nil,45,nil,nil,45,nil,nil,0},
[2794] = {'Summoned Guardian',4185,4185,38,38,1,nil,nil,0,nil,nil,10,"A",nil,0},
[2795] = {'Lenny "Fingers" McCoy',1342,1342,35,35,0,{[1519]={{68.65,44.55}}},nil,1519,nil,nil,12,"A",nil,0},
[2796] = {'Faelyssa',1342,1342,35,35,0,{[1657]={{32.51,21.3}}},nil,1657,nil,nil,80,"A",nil,16},
[2797] = {'Hovrak Gutrender',1220,1220,35,35,0,nil,nil,0,nil,nil,29,"H","iCoke Redemption Vendor",0},
[2798] = {'Pand Stonebinder',1342,1342,35,35,0,{[1638]={{29.69,21.18}}},nil,1638,nil,nil,104,"H","First Aid Trainer",19},
[2799] = {'Lucian Fenner',1342,1342,35,35,0,{[1497]={{76.78,75.18}}},nil,1497,nil,nil,68,"H",nil,0},
[2801] = {'Tresa MacGregor',1848,1848,45,45,0,nil,nil,0,nil,nil,55,"A","iCoke Redemption Vendor",0},
[2802] = {'Susan Tillinghast',3398,3398,55,55,0,{[1497]={{87.35,76.2}}},{[1497]={{{85.18,78.0},{82.33,77.29},{80.89,74.7},{76.32,71.86},{75.39,69.36},{76.72,67.22},{78.41,65.0},{79.42,64.52},{80.79,62.24},{81.15,61.41},{82.54,58.98},{86.04,61.9},{87.24,68.02},{88.8,72.1},{88.54,73.78},{87.19,76.67}}}},1497,nil,nil,68,"H",nil,0},
[2803] = {'Malygen',3398,3398,55,55,0,{[361]={{62.32,25.64}}},nil,361,nil,nil,80,"A","General Goods",6},
[2804] = {'Kurden Bloodclaw',157200,157200,61,61,1,{[1497]={{54.18,96.07}}},nil,1497,nil,nil,1515,"H","Warsong Gulch Battlemaster",2049},
[2805] = {'Deneb Walker',2217,2217,45,45,0,{[45]={{26.97,58.83}}},nil,45,nil,nil,12,"A","Scrolls & Potions",4},
[2806] = {'Bale',3398,3398,55,55,0,{[361]={{34.75,53.23}}},nil,361,nil,nil,104,"H","General Goods",6},
[2807] = {'Daggerspine Wavecaller',1024,1024,28,28,0,nil,nil,0,nil,nil,74,nil,nil,0},
[2808] = {'Vikki Lonsav',1468,1468,36,36,0,{[45]={{46.45,47.6}}},nil,45,nil,nil,12,"A","General Goods",7},
[2809] = {'Boar',42,42,1,1,0,nil,nil,0,nil,nil,14,nil,nil,0},
[2810] = {'Hammon Karwn',1342,1342,35,35,0,{[45]={{46.49,47.41}}},nil,45,nil,nil,12,"A","Superior Tradesman",6},
[2812] = {'Drovnar Strongbrew',1752,1752,40,40,0,{[45]={{46.32,47.04}}},nil,45,nil,nil,55,"A","Alchemy Supplies",6},
[2814] = {'Narj Deepslice',1677,1677,39,39,0,{[45]={{45.54,47.61}}},nil,45,nil,nil,55,"A","Butcher",6},
[2816] = {'Androd Fadran',1536,1536,37,37,0,{[45]={{45.08,46.83}}},nil,45,nil,nil,12,"A","Leatherworking Supplies",6},
[2817] = {'Rigglefuzz',1536,1536,37,37,0,{[3]={{42.39,52.93}}},nil,3,{703,705,1559,2418},{703,705,1559,2418},120,"AH",nil,2},
[2818] = {'Slagg',1604,1604,38,38,0,{[45]={{74.08,33.82}}},nil,45,nil,nil,29,"H","Superior Butcher",19},
[2819] = {'Tunkk',1279,1279,34,34,0,{[45]={{74.84,34.59}}},nil,45,nil,nil,29,"H","Leatherworking Supplies",6},
[2820] = {'Graud',1106,1106,31,31,0,{[45]={{74.12,32.37}}},nil,45,nil,nil,29,"H","General Goods",6},
[2821] = {'Keena',1221,1221,33,33,0,{[45]={{74.09,32.73}}},nil,45,nil,nil,29,"H","Trade Goods",6},
[2829] = {'Starving Buzzard',1403,1536,35,37,0,{[3]={{60.21,30.1},{60.75,39.65},{48.91,27.41},{58.76,24.33},{54.96,13.79},{57.46,28.59}}},nil,3,nil,nil,73,nil,nil,0},
[2830] = {'Buzzard',1536,1678,37,39,0,{[3]={{48.63,55.45},{61.82,55.62},{57.96,73.76},{50.28,59.96},{49.54,63.79},{50.13,77.87},{63.27,54.12}}},nil,3,nil,nil,73,nil,nil,0},
[2831] = {'Giant Buzzard',1751,1902,39,41,0,{[3]={{28.81,72.04},{15.03,60.1},{17.17,61.34},{15.04,61.82},{16.17,61.7},{15.5,58.52},{16.02,58.67},{12.28,70.96},{17.18,60.02},{17.1,58.35},{12.21,67.91},{33.42,59.81},{25.77,61.89},{17.54,49.15},{24.36,76.19},{18.85,77.61},{25.31,73.87}}},nil,3,nil,nil,73,nil,nil,0},
[2832] = {'Nixxrax Fillamug',1604,1604,38,38,0,{[33]={{27.04,77.17}}},nil,33,nil,nil,120,"AH","Food and Drink",4},
[2833] = {'DEBUG - Gossip Gryphon Master',7842,7842,55,55,1,nil,nil,0,nil,nil,994,"AH","Gryphon Master",0},
[2834] = {'Myizz Luckycatch',2059,2059,43,43,0,{[33]={{27.46,77.11}}},nil,33,nil,nil,120,"AH","Superior Fisherman",21},
[2835] = {'Cedrik Prose',7842,7842,55,55,1,{[45]={{45.73,46.1}}},nil,45,nil,nil,12,"A","Gryphon Master",11},
[2836] = {'Brikk Keencraft',3292,3292,54,54,0,{[33]={{28.99,75.56}}},nil,33,nil,nil,120,"AH","Master Blacksmith",17},
[2837] = {'Jaxin Chong',2398,2398,46,46,0,{[33]={{28.04,77.99}}},nil,33,nil,nil,120,"AH","Expert Alchemist",17},
[2838] = {'Crazk Sparks',2398,2398,46,46,0,{[33]={{28.36,76.66}}},nil,33,nil,nil,120,"AH","Fireworks Merchant",4},
[2839] = {'Haren Kanmae',1902,1902,41,41,0,{[33]={{28.31,74.56}}},nil,33,nil,nil,120,"AH","Superior Bowyer",16388},
[2840] = {'Kizz Bluntstrike',1828,1828,40,40,0,{[33]={{28.27,75.22}}},nil,33,nil,nil,120,"AH","Macecrafter",16388},
[2842] = {'Wigcik',2059,2059,43,43,0,{[33]={{28.0,76.99}}},nil,33,nil,nil,120,"AH","Superior Fisherman",4},
[2843] = {'Jutak',2059,2059,43,43,0,{[33]={{27.46,77.55}}},nil,33,nil,nil,120,"AH","Blade Trader",16388},
[2844] = {'Hurklor',2398,2398,46,46,0,{[33]={{28.97,75.06}}},nil,33,nil,nil,120,"AH","Blacksmithing Supplies",16390},
[2845] = {'Fargon Mortalak',1828,1828,40,40,0,{[33]={{29.04,74.99}}},nil,33,nil,nil,120,"AH","Superior Armorer",16388},
[2846] = {'Blixrez Goodstitch',2059,2059,43,43,0,{[33]={{28.25,77.54}}},nil,33,nil,nil,120,"AH","Leatherworking Supplies",4},
[2847] = {'Jansen Underwood',2672,2672,49,49,0,{[33]={{29.07,75.48}}},nil,33,nil,nil,120,"AH","Blacksmithing Supplies",16390},
[2848] = {'Glyx Brewright',2217,2217,45,45,0,{[33]={{28.14,78.11}}},nil,33,nil,nil,120,"AH","Alchemy Supplies",4},
[2849] = {'Qixdi Goodstitch',2138,2138,44,44,0,{[33]={{28.15,77.56}}},nil,33,nil,nil,120,"AH","Cloth Armor and Accessories",16388},
[2850] = {'Broken Tooth',1603,1603,37,37,4,{[3]={{59.69,29.37},{59.68,26.92},{53.65,15.53},{45.8,36.5}}},nil,3,nil,nil,66,nil,nil,0},
[2851] = {'Urda',7842,7842,55,55,1,{[45]={{73.02,32.7}}},nil,45,nil,nil,29,"H","Wind Rider Master",11},
[2852] = {'Enslaved Druid of the Talon',198,198,10,10,0,{[141]={{38.7,80.65},{38.67,80.6},{38.8,80.62},{38.76,80.66}}},nil,141,nil,nil,35,"AH",nil,0},
[2853] = {'Freed Druid of the Talon',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2855] = {'Snang',664,664,24,24,0,{[1637]={{62.93,49.24}}},nil,1637,nil,nil,29,"H","Journeyman Tailor",19},
[2856] = {'Angrun',1752,1752,40,40,0,{[33]={{32.25,27.43}}},nil,33,nil,nil,29,"H","Superior Herbalist",16},
[2857] = {'Thund',617,617,23,23,0,{[1637]={{75.96,24.15}}},nil,1637,nil,nil,29,"H","Journeyman Engineer",19},
[2858] = {'Gringer',7842,7842,55,55,1,{[33]={{26.87,77.1}}},nil,33,nil,nil,29,"H","Wind Rider Master",11},
[2859] = {'Gyll',7842,7842,55,55,1,{[33]={{27.53,77.79}}},nil,33,nil,nil,55,"A","Gryphon Master",11},
[2860] = {'Sigrun Ironhew',1752,1752,40,40,0,{[3]={{53.8,43.3}}},nil,3,{706,718,733},{706,718,733},55,"A",nil,2},
[2861] = {'Gorrik',7842,7842,55,55,1,{[3]={{3.99,44.78}}},nil,3,nil,nil,29,"H","Wind Rider Master",11},
[2862] = {'Warrior 21',531,531,21,21,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2863] = {'Warrior 22',573,573,22,22,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2864] = {'Warrior 23',617,617,23,23,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2865] = {'Warrior 24',664,664,24,24,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2866] = {'Warrior 26',787,787,26,26,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2867] = {'Warrior 27',840,840,27,27,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2868] = {'Warrior 28',896,896,28,28,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2869] = {'Warrior 29',950,950,29,29,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[2871] = {'[PH] Tallstrider Trainer',2769,2769,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2873] = {'[PH] Raptor Trainer',2769,2769,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2874] = {'[PH] Horse Trainer',2769,2769,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2875] = {'[PH] Gorilla Trainer',2769,2769,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2876] = {'Grunenstur Balindom',2768,2768,50,50,0,nil,nil,0,nil,nil,84,"A",nil,0},
[2877] = {'[PH] Crawler Trainer',2769,2769,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2878] = {'Peria Lamenur',1752,1752,40,40,0,{[1]={{46.68,54.0},{71.04,38.03}}},nil,1,nil,nil,55,"A","Pet Trainer",19},
[2879] = {'Karrina Mekenda',1752,1752,40,40,0,{[1519]={{61.58,15.99}}},nil,1519,nil,nil,55,"A","Pet Trainer",19},
[2886] = {'Ranged Skills Trainer',156,247,8,12,0,nil,nil,0,nil,nil,55,"A","Ranged Skills Trainer",0},
[2887] = {'Prismatic Exile',1585,1647,42,43,0,nil,nil,0,nil,nil,91,nil,nil,0},
[2888] = {'Garek',2768,2768,50,50,0,{[3]={{61.94,54.26}}},nil,3,{717,732},{717,732},35,"AH",nil,2},
[2889] = {'Stonevault Trogg',3660,3831,35,36,1,nil,nil,0,nil,nil,59,nil,nil,0},
[2890] = {'Stonevault Scout',3831,4008,36,37,1,nil,nil,0,nil,nil,59,nil,nil,0},
[2891] = {'Stonevault Skullthumper',1536,1604,37,38,0,nil,nil,0,nil,nil,59,nil,nil,0},
[2892] = {'Stonevault Seer',3540,3678,39,40,1,{[3]={{64.0,41.21},{64.82,41.09},{65.88,44.03},{64.71,43.51}}},nil,3,nil,nil,59,nil,nil,0},
[2893] = {'Stonevault Bonesnapper',1678,1753,39,40,0,{[3]={{49.66,64.31},{48.72,71.93},{48.27,69.95},{51.35,69.72},{47.3,69.89},{50.93,67.7},{52.48,69.61},{51.01,66.09},{52.46,65.96},{52.31,68.06},{50.17,67.12},{51.18,71.65},{49.7,71.7},{50.92,64.36}}},nil,3,nil,nil,59,nil,nil,0},
[2894] = {'Stonevault Shaman',1471,1522,40,41,0,{[3]={{49.66,66.49},{48.27,68.28},{49.53,69.8},{49.89,68.38},{50.94,67.25}}},nil,3,nil,nil,59,nil,nil,0},
[2896] = {'[PH] Alliance Magic Skills Trainer',2218,2218,45,45,0,nil,nil,0,nil,nil,84,"A","Magic Skill Trainer *Temp*",0},
[2899] = {'[PH] Alliance Toughness/Resist Trainer',2218,2218,45,45,0,nil,nil,0,nil,nil,84,"A","Toughness/Resist Trainer *Temp*",0},
[2906] = {'Dustbelcher Warrior',1468,1536,36,37,0,{[3]={{68.08,25.08},{64.36,23.75},{65.52,22.05},{65.66,23.49},{67.13,22.09}}},nil,3,nil,nil,45,nil,nil,0},
[2907] = {'Dustbelcher Mystic',1208,1257,36,37,0,{[3]={{66.67,23.29},{64.69,25.55},{12.87,73.34},{66.33,22.05}}},nil,3,nil,nil,45,nil,nil,0},
[2908] = {'Grawl',2138,2138,44,44,0,{[3]={{3.12,45.93}}},nil,3,nil,nil,29,"H","General Goods",6},
[2909] = {'Hammertoe Grez',1752,1752,40,40,0,{[38]={{37.28,85.78}}},nil,38,{722,723},{721,722},55,"A",nil,2},
[2910] = {'Prospector Ryedol',1342,1342,35,35,0,{[3]={{53.42,43.39}}},nil,3,{719,721,724},{719,720,723},55,"A","Explorers' League",6},
[2911] = {'Archaeologist Flagongut',2138,2138,44,44,0,{[11]={{10.84,60.43}}},nil,11,{943},{942,943},55,"A","Explorers' League",2},
[2912] = {'Chief Archaeologist Greywhisker',1752,1752,40,40,0,{[1657]={{31.24,84.51}}},nil,1657,{730,942},{741},55,"A","Explorers' League",2},
[2913] = {'Archaeologist Hollee',247,247,12,12,0,{[148]={{37.44,41.84}}},nil,148,{729,741},{730,731},55,"A","Explorers' League",2},
[2914] = {'Snake',8,8,1,1,0,{[15]={{55.45,70.13},{56.35,30.7},{53.01,75.88},{39.07,49.15},{58.47,30.69},{39.71,71.56},{40.89,21.45},{39.71,25.06},{35.64,56.55},{59.65,35.8},{38.75,16.32},{38.2,71.9},{42.62,43.25},{52.3,56.45},{37.07,70.43},{46.47,77.49},{43.58,76.55},{47.27,63.67},{52.94,20.29},{48.97,52.7},{50.14,52.96},{41.97,21.66},{38.76,60.4},{42.04,28.66},{43.64,19.07},{55.48,73.46},{50.95,27.45},{45.96,78.22},{49.14,70.02},{40.93,58.66},{43.47,50.93},{40.92,70.78},{44.41,74.49},{50.8,65.67},{52.44,69.69},{38.2,53.99},{50.81,23.73},{34.51,59.37},{38.18,35.78},{48.59,66.27},{46.27,25.04},{34.33,47.07},{39.02,74.29},{42.95,38.35},{44.27,51.02},{36.19,25.0},{40.95,13.6},{57.69,28.98},{47.93,66.7},{42.21,74.86},{52.63,52.9},{34.42,38.77},{51.36,61.53},{50.64,56.11},{46.08,45.6},{44.85,19.7},{48.71,75.76},{33.96,63.65},{45.33,22.32},{48.26,49.84},{43.75,57.03},{45.62,53.53},{34.67,43.92},{33.32,44.65},{36.42,28.1},{55.86,27.83}},[130]={{46.49,78.99},{66.43,48.94},{45.94,26.01},{59.32,9.17},{49.92,18.97},{50.95,43.52},{49.67,15.75}},[490]={{44.61,62.88},{47.19,73.91},{54.29,72.48},{52.35,33.14},{37.75,42.65},{28.33,43.83},{66.93,28.43},{47.37,85.89},{31.1,28.95},{46.24,25.67},{75.83,44.33},{60.5,19.59},{55.76,30.45},{50.86,18.16},{74.96,62.53},{68.97,32.1},{40.99,22.3},{35.07,38.56}},[405]={{79.42,16.88},{71.32,60.14},{71.61,22.75},{50.9,68.99},{73.58,64.95},{28.76,80.11},{42.19,63.59},{56.32,22.98},{31.32,78.03},{42.4,69.98},{31.09,70.77},{71.66,32.46},{76.2,24.58},{44.42,86.33},{41.9,52.39},{63.48,72.43},{39.9,38.3},{35.3,84.45},{68.51,62.1},{62.24,77.92},{46.29,48.65},{54.44,32.37},{57.37,8.13},{70.05,41.73},{67.43,69.0},{41.62,28.12},{59.75,62.11},{34.28,76.45},{64.13,33.46}},[2557]={{-1,-1}},[40]={{53.69,39.33},{63.41,73.51},{62.27,60.22},{46.51,53.43},{46.05,71.75},{58.55,14.7},{32.13,52.39},{37.2,27.05},{40.94,62.05},{46.24,79.07},{49.22,47.93},{43.64,33.73},{35.03,33.92},{54.33,20.63},{49.99,31.14}},[2100]={{-1,-1}},[357]={{58.68,54.63},{43.86,12.61},{82.73,45.12},{68.86,60.35},{40.55,24.1},{80.88,39.64},{54.06,53.76},{84.41,38.3},{56.56,69.37},{54.86,73.69},{52.82,49.02},{71.57,61.27},{52.4,47.66},{57.23,47.44},{79.5,45.2},{69.86,39.85},{49.89,31.54},{55.09,49.3}},[1977]={{-1,-1}},[718]={{-1,-1}}},nil,15,nil,nil,190,"AH",nil,0},
[2915] = {'Hammertoe\'s Spirit',1752,1752,40,40,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2916] = {'Historian Karnik',484,484,20,20,0,{[1537]={{77.54,11.82}}},nil,1537,{725,762,2946,2964,3448,7063},{724,726,2963,2977,7062},55,"A",nil,3},
[2917] = {'Prospector Remtravel',356,356,16,16,0,{[148]={{35.73,83.7}}},nil,148,{731},{729},55,"A","Explorers' League",2},
[2918] = {'Advisor Belgrum',1752,1752,40,40,0,{[1537]={{77.34,9.71}}},nil,1537,{726,1139},{725,762,1139},55,"A",nil,2},
[2919] = {'Fam\'retor Guardian',2217,2217,45,45,0,nil,nil,0,nil,nil,91,nil,nil,0},
[2920] = {'Lucien Tosselwrench',1106,1106,31,31,0,{[3]={{25.82,44.24}}},nil,3,{715,716,777},{715,716,734},35,"AH",nil,3},
[2921] = {'Lotwil Veriatus',1468,1468,36,36,0,{[3]={{25.95,44.87}}},nil,3,{710,711,712,713,714,734,778,4063},{710,711,712,713,714,777,778,4062,4063},35,"AH",nil,2},
[2922] = {'Servo',102,102,5,5,0,{[3]={{26.04,44.73}}},{[3]={{{26.04,44.73},{25.69,44.84},{25.36,45.55},{25.42,46.23},{25.8,46.92},{26.23,46.99},{26.59,46.57},{26.76,45.9},{26.73,45.37},{26.47,45.11},{26.17,44.78},{26.24,44.64},{26.24,44.46},{26.12,44.4},{26.03,44.67},{26.15,44.97},{26.34,45.18},{26.6,45.77},{26.99,46.19},{26.99,46.19},{26.68,45.83},{26.4,45.91},{26.4,46.43},{26.23,46.99},{26.02,47.1},{25.56,46.29},{25.5,45.73},{25.62,45.14},{25.87,44.94},{25.87,44.94},{25.87,44.76},{25.89,44.59},{26.09,44.45},{26.43,44.26},{26.7,44.36},{27.15,44.98},{27.12,45.82},{27.0,46.12},{26.55,45.87},{26.03,46.16},{25.59,46.01},{25.69,45.58},{25.55,44.94},{25.5,44.59},{25.52,44.41},{25.74,44.62}}}},3,nil,nil,42,"AH",nil,0},
[2923] = {'Mangy Silvermane',1902,1981,41,42,0,{[47]={{21.67,47.57},{15.1,54.17},{15.15,55.62},{16.37,54.7},{22.52,51.16},{21.77,53.0},{23.59,51.74},{18.3,48.91},{20.88,50.34},{18.76,49.08},{20.04,50.2},{20.13,56.61},{19.02,47.58},{20.96,55.44},{20.26,57.22},{21.78,54.98},{17.59,48.16},{19.68,51.47},{19.31,54.31},{17.18,49.49},{19.55,52.34},{18.2,52.54}}},nil,47,nil,nil,38,nil,nil,0},
[2924] = {'Silvermane Wolf',2059,2138,43,44,0,{[47]={{35.83,44.99},{36.06,44.01},{37.3,49.73},{34.97,44.05},{34.08,46.12},{37.61,55.01},{38.14,53.07},{27.89,69.45},{35.79,48.99},{35.5,47.74},{34.96,61.57},{34.2,61.08},{32.09,63.42},{35.72,52.97},{31.0,64.61},{36.71,52.63},{36.22,49.13},{36.78,51.66},{24.7,51.08},{27.82,53.43},{33.71,53.65},{37.55,52.12},{35.16,52.64},{29.58,54.17},{32.74,63.55},{32.13,55.28},{34.41,58.78},{31.77,60.66},{26.64,55.26},{26.88,58.06},{28.85,63.22},{27.91,61.56}}},nil,47,nil,nil,38,nil,nil,0},
[2925] = {'Silvermane Howler',2310,2399,45,46,0,{[47]={{41.32,67.14},{51.83,59.96},{49.81,57.56},{50.48,58.85},{41.5,46.18},{51.06,40.58},{42.53,46.28},{40.95,55.09},{43.05,53.66},{37.39,61.02},{40.57,64.19},{43.97,61.76},{42.72,62.74},{39.86,50.59},{39.39,62.94},{39.27,45.99},{47.81,59.04},{48.03,61.5},{46.83,59.47},{46.75,47.81}}},nil,47,nil,nil,38,nil,nil,0},
[2926] = {'Silvermane Stalker',2488,2578,47,48,0,{[47]={{68.62,52.76},{74.66,48.64},{67.39,51.48},{69.22,53.89},{63.64,49.3},{60.21,55.27},{53.5,56.04},{58.84,47.54},{63.13,52.37},{72.38,56.37},{69.59,54.85},{51.1,60.99},{68.0,52.86},{64.19,48.89},{76.43,53.46},{62.47,50.28},{69.37,44.96},{58.33,54.7},{59.68,54.15},{67.04,50.36},{70.54,58.03},{64.0,55.07},{54.19,42.76},{66.64,60.59},{58.42,51.9},{53.51,56.0},{63.03,42.86},{69.32,49.77},{65.36,53.27},{73.97,55.89},{73.37,57.91},{63.2,49.08},{73.52,56.1},{51.46,54.34},{61.95,46.34},{61.2,48.0},{54.33,43.83},{73.09,51.98},{66.75,48.61},{71.45,54.83},{62.74,56.56},{55.81,43.79},{70.11,57.07},{71.29,61.53},{59.64,50.77},{56.4,46.2},{75.48,55.18},{78.05,52.22},{72.88,57.84},{71.6,59.53},{61.24,55.77},{52.21,49.11},{71.98,59.27},{59.45,48.99},{76.56,48.79},{67.58,48.65},{72.05,63.05},{60.74,54.01},{68.68,60.27},{69.78,56.37},{66.78,57.8}}},nil,47,nil,nil,38,nil,nil,0},
[2927] = {'Vicious Owlbeast',1981,2059,42,43,0,{[47]={{33.88,63.21},{26.37,68.69},{37.17,44.22},{36.54,45.73},{36.1,55.3},{36.6,47.83},{34.1,61.57},{26.19,63.94},{29.72,55.26},{31.14,62.95},{34.14,52.0},{34.2,50.98},{25.6,62.85},{35.79,50.82},{23.69,49.4},{26.56,53.16},{26.22,67.13},{31.02,52.79},{34.38,55.47},{25.95,68.38},{26.79,59.62},{26.28,54.29},{33.8,58.92},{26.5,61.32},{27.13,63.4},{27.91,65.93},{25.32,53.25}}},nil,47,nil,nil,14,nil,nil,0},
[2928] = {'Primitive Owlbeast',2138,2218,44,45,0,{[47]={{51.29,50.05},{41.43,42.49},{38.58,43.28},{40.33,56.43},{44.35,59.73},{42.78,45.23},{39.55,43.42},{38.71,45.63},{38.38,49.45},{38.22,63.62},{41.01,61.58},{39.14,44.96},{38.61,57.52},{41.6,56.78},{44.09,54.66},{42.85,55.05},{43.28,44.47},{40.11,46.28},{41.23,45.97},{42.58,44.99},{38.13,58.97},{40.69,63.81},{39.09,52.64},{45.99,54.0},{42.11,64.64},{40.95,52.25},{43.4,58.04},{38.62,52.36},{38.05,61.31},{42.27,47.27},{39.59,48.36},{47.14,56.71},{45.81,54.05},{40.47,47.69},{43.54,56.43},{44.64,53.55},{50.94,57.81},{36.99,57.66},{45.69,51.53},{51.83,63.5},{46.22,56.99},{36.13,59.48},{49.47,59.84},{51.36,42.24}}},nil,47,nil,nil,14,nil,nil,0},
[2929] = {'Savage Owlbeast',2398,2487,46,47,0,{[47]={{61.63,44.33},{61.49,41.92},{60.91,46.54},{53.81,48.86},{60.44,53.76},{62.58,40.85},{55.87,51.67},{52.21,46.36},{52.86,49.83},{65.57,57.83},{56.09,46.06}}},nil,47,nil,nil,14,nil,nil,0},
[2930] = {'Sentinel Glynda Nal\'Shea',2217,2217,45,45,0,{[148]={{37.7,43.41}}},nil,148,{4811,4812},{4740,4811,4813},80,"A",nil,2},
[2931] = {'Zaricotl',7842,7842,55,55,2,{[3]={{56.11,61.73},{35.38,66.49},{34.49,53.74}}},nil,3,nil,nil,14,nil,nil,0},
[2932] = {'Magregan Deepshadow',4185,4185,38,38,1,{[38]={{38.37,93.97}}},{[38]={{{38.22,93.98},{38.12,93.76},{38.09,93.5},{38.09,93.27},{38.02,92.92},{38.02,92.6},{38.01,92.26},{38.09,91.97},{38.13,91.7},{38.12,91.4},{38.16,91.14},{38.3,91.02},{38.45,91.0},{38.57,90.94},{38.78,90.63},{38.94,90.48},{39.12,90.28},{39.29,90.15},{39.44,90.14},{39.5,90.22},{39.5,90.37},{39.4,90.43},{39.26,90.42},{39.07,90.46},{38.76,90.59},{38.6,90.66},{38.39,90.63},{38.22,90.63},{38.08,90.53},{37.95,90.3},{37.85,90.1},{37.78,89.89},{37.52,89.56},{37.74,89.87},{37.9,90.2},{38.02,90.44},{38.12,90.55},{38.27,90.62},{38.44,90.63},{38.57,90.68},{38.63,90.83},{38.56,91.0},{38.42,91.04},{38.26,91.07},{38.14,91.14},{38.06,91.35},{38.11,91.52},{38.24,91.57},{38.4,91.68},{38.56,91.84},{38.67,92.11},{38.92,92.25},{39.05,92.4},{39.07,92.74},{39.04,93.0}},{{38.87,93.37},{38.77,93.59},{38.63,93.79},{38.52,93.92},{38.37,93.98}}},[3]={{{39.75,18.87}}}},38,nil,nil,54,nil,nil,0},
[2934] = {'Keeper Bel\'dugur',1981,1981,42,42,0,{[1497]={{53.74,54.46}}},nil,1497,{736,737,1013},{728,736,1013},68,"H",nil,2},
[2935] = {'[PH] Demon Master',1939,1939,50,50,0,nil,nil,0,nil,nil,35,"AH","Demon Trainer",0},
[2937] = {'Dagun the Ravenous',5148,5148,43,43,1,nil,nil,0,nil,nil,18,nil,nil,0},
[2938] = {'Aldric Hunter',2769,2769,50,50,0,nil,nil,0,nil,nil,12,"A","Bear Trainer",0},
[2939] = {'Jackson Bayne',52,52,1,1,0,nil,nil,0,nil,nil,35,"AH","Boar Trainer",0},
[2941] = {'Lanie Reed',7842,7842,55,55,1,{[51]={{37.94,30.86}}},nil,51,nil,nil,55,"A","Gryphon Master",11},
[2942] = {'Dylan Bissel',2769,2769,50,50,0,nil,nil,0,nil,nil,12,"A","Wolf Trainer",0},
[2943] = {'Ransin Donner',1220,1220,35,35,0,{[1537]={{50.14,12.69}}},nil,1537,nil,nil,55,"A",nil,1},
[2944] = {'Boss Tho\'grun',1902,1981,41,42,0,{[3]={{12.62,75.49}}},{[3]={{{12.72,75.48},{13.32,76.41},{13.93,77.28},{14.68,78.03},{16.11,78.29},{16.95,78.41},{18.21,78.5},{19.37,78.3},{20.12,78.49},{21.58,77.97},{22.23,77.17},{23.51,75.51},{24.77,73.83},{26.07,72.85},{27.1,72.89},{28.32,73.45},{30.15,73.53},{31.41,73.34},{33.08,72.99},{34.34,72.72},{35.33,72.52},{37.01,72.17},{38.27,72.11},{39.96,72.13},{41.65,72.17},{43.33,72.26},{44.46,72.58},{45.91,72.71},{46.8,71.75},{48.15,72.73},{49.22,73.74},{50.39,73.71},{51.21,73.4},{53.28,72.8},{54.95,72.53},{56.63,72.31},{58.31,72.06},{59.15,71.91},{60.75,70.77},{61.54,69.91},{61.45,69.3},{61.14,67.46},{60.14,65.45},{59.13,64.3},{57.78,62.79},{56.77,61.64},{55.75,60.51},{54.74,59.37},{54.05,58.64},{52.72,57.35},{52.24,54.92},{52.56,53.09},{52.49,51.29},{51.81,50.2},{50.76,49.14},{49.68,48.82},{48.84,48.67},{47.5,49.11},{46.55,50.22},{45.61,51.5},{44.09,52.75},{42.92,53.48},{41.75,54.22},{40.59,54.96},{38.78,56.1},{37.31,57.34},{36.61,58.07},{35.42,59.31},{34.59,60.09},{33.8,59.64},{33.01,59.19},{32.62,58.97},{31.51,58.66},{31.0,58.69},{30.33,58.49},{29.04,57.78},{28.22,57.47},{26.99,57.02},{26.21,56.84},{25.37,56.74},{24.72,56.74},{23.95,56.89},{23.12,57.11},{21.68,58.19},{20.84,58.1},{19.38,57.97},{19.19,58.54},{18.76,59.89},{18.16,60.77},{17.46,62.09},{16.1,63.49},{16.1,63.49},{15.4,64.21},{14.22,65.19},{13.29,65.17},{13.17,65.53},{12.5,67.46},{11.53,69.16},{11.66,70.97},{11.58,73.38},{11.78,73.83},{12.05,74.36}}}},3,nil,nil,45,nil,nil,0},
[2945] = {'Murdaloc',1981,1981,42,42,0,{[3]={{49.63,66.31}}},nil,3,nil,nil,59,nil,nil,0},
[2946] = {'Puppet of Helcular',165,165,42,42,0,nil,nil,0,nil,nil,83,"H",nil,0},
[2947] = {'Harken Windtotem',531,531,21,21,0,{[215]={{48.71,59.32}}},nil,215,{761},{761},83,"H",nil,2},
[2948] = {'Mull Thunderhorn',712,712,25,25,0,{[215]={{48.53,60.39}}},nil,215,{748,754,756,758,759,760},{748,754,756,758,759,760},104,"H",nil,2},
[2949] = {'Palemane Tanner',98,115,5,6,0,{[215]={{47.35,71.4},{48.35,71.76},{48.35,72.4},{34.98,62.69},{35.64,63.44},{33.01,61.19},{35.47,62.03},{33.42,61.18},{32.04,59.78},{32.78,61.83},{33.1,62.17},{32.72,60.96},{35.71,61.56},{31.61,60.36},{35.56,62.44},{35.39,62.32},{55.02,72.06},{54.5,73.4},{52.59,72.14},{53.8,72.4},{53.7,74.1},{53.45,73.55},{49.22,71.39},{48.68,71.2},{49.33,72.19}}},nil,215,nil,nil,39,nil,nil,0},
[2950] = {'Palemane Skinner',115,131,6,7,0,{[215]={{47.33,72.32},{48.03,73.28},{47.99,71.2},{48.24,72.09},{48.71,73.33},{48.56,71.81},{35.06,63.45},{30.34,59.67},{33.01,61.66},{31.67,60.68},{31.64,60.05},{29.59,60.29},{35.08,61.76},{32.41,61.12},{30.21,60.69},{30.68,60.96},{32.25,60.48},{30.56,60.52},{55.73,71.82},{54.45,71.64},{53.23,74.13},{52.59,73.16},{53.3,73.02}}},nil,215,nil,nil,39,nil,nil,0},
[2951] = {'Palemane Poacher',137,156,7,8,0,{[215]={{30.99,60.43},{31.17,61.19},{31.34,61.68},{30.92,61.51},{30.21,61.55},{30.74,62.43},{30.74,60.45},{30.21,60.53},{30.29,61.13},{31.24,62.16},{30.41,61.82},{30.74,60.49},{55.24,73.06},{54.04,71.77},{54.91,72.94},{54.36,71.88},{53.6,72.42},{52.91,73.42},{53.12,72.54}}},nil,215,nil,nil,39,nil,nil,0},
[2952] = {'Bristleback Quilboar',71,86,3,4,0,{[215]={{57.79,81.7},{58.39,81.75},{59.21,84.75},{65.8,78.25},{60.75,75.3},{61.58,78.42},{61.51,77.09},{60.66,74.84},{61.57,78.76},{65.74,77.92},{62.95,77.28},{64.74,79.46},{60.74,76.78},{63.8,76.69},{63.68,76.96},{59.31,78.27},{59.34,78.53},{58.79,78.12},{58.4,78.34},{59.65,76.99},{60.09,78.13},{61.56,81.12},{62.33,79.66},{63.13,78.3},{64.33,79.04},{64.32,78.29},{64.16,77.79},{64.06,77.32},{58.52,79.78},{59.5,79.49},{60.43,84.2},{60.99,82.0},{62.21,82.12},{61.94,83.59},{62.33,81.53},{65.1,77.95},{59.29,84.03},{60.31,82.88},{60.14,82.28},{60.18,80.89},{64.0,78.31},{61.85,81.35},{59.94,80.0},{60.87,84.8},{64.47,77.65},{63.86,79.68},{59.7,79.17},{59.71,82.08}}},nil,215,nil,nil,111,nil,nil,0},
[2953] = {'Bristleback Shaman',69,83,3,4,0,{[215]={{66.08,77.81},{65.95,77.09},{65.01,78.57},{63.65,76.25},{61.58,76.05},{61.74,75.82},{60.09,76.04},{59.96,75.27},{59.53,75.44},{63.27,82.85},{63.88,81.08},{63.81,79.82},{59.42,78.02},{64.74,77.86}}},nil,215,nil,nil,111,nil,nil,0},
[2954] = {'Bristleback Battleboar',86,102,4,5,0,{[215]={{65.64,77.93},{61.47,75.71},{60.97,86.47},{62.87,76.13},{63.73,81.71},{62.25,79.22},{58.99,77.21},{59.78,78.32},{61.09,80.65},{64.27,78.59},{63.95,77.59},{61.02,85.26},{63.72,78.42},{63.58,79.12}}},nil,215,nil,nil,111,nil,nil,0},
[2955] = {'Plainstrider',42,55,1,2,0,{[215]={{50.73,86.95},{53.3,86.27},{52.37,85.49},{53.93,84.27},{51.44,85.68},{50.11,86.97},{43.3,75.51},{42.1,77.28},{42.87,76.53},{52.78,82.69},{50.58,85.86},{46.72,87.57},{47.24,86.45},{47.85,88.16},{44.05,86.22},{45.24,87.88},{53.16,81.97},{51.99,81.85},{49.57,85.98},{48.6,87.68},{44.28,73.99},{46.51,73.65},{45.83,73.26},{44.93,74.22},{43.45,85.03},{52.23,74.84},{52.02,77.23},{46.63,85.2},{44.2,83.94},{49.44,83.4},{51.21,76.22},{43.31,81.7},{50.62,79.14},{47.91,86.59},{51.94,75.08},{51.53,74.93},{44.1,79.83},{50.63,77.02},{50.89,78.12},{46.52,75.0},{47.03,75.65},{47.7,75.25},{48.53,76.27},{47.51,79.14},{53.89,82.77},{48.01,77.12},{47.92,76.43},{48.91,76.93},{49.2,75.65},{49.94,75.27},{50.1,74.18},{50.96,76.16},{48.69,82.95},{48.3,80.4},{45.3,85.51},{46.22,86.88},{44.23,87.68},{50.53,88.71},{51.61,87.96},{52.56,87.51},{53.05,88.85},{53.92,86.94},{54.44,85.56},{53.4,84.07},{51.86,83.06},{51.18,83.11},{50.88,83.81},{49.9,83.43},{49.61,81.74},{49.31,80.36},{47.9,77.42},{49.6,77.84},{49.73,78.59},{51.44,79.02},{51.9,79.82},{52.23,81.33},{47.82,84.1},{48.6,79.6},{50.67,81.23},{43.63,79.11},{42.3,81.43},{42.29,82.29},{45.75,80.31},{45.42,84.15},{46.65,84.95},{44.63,83.75},{47.13,83.72},{46.03,80.6},{45.32,81.95},{46.66,80.97},{46.13,83.46},{46.61,82.23},{46.02,85.21},{48.15,81.81},{44.11,84.98},{45.44,79.15},{46.68,78.22}}},nil,215,nil,nil,189,"AH",nil,0},
[2956] = {'Adult Plainstrider',120,156,6,8,0,{[215]={{46.49,31.52},{58.38,46.83},{57.39,36.93},{59.47,57.06},{34.16,69.92},{35.06,66.43},{44.84,36.29},{34.88,79.88},{43.48,38.91},{34.98,74.37},{34.79,76.95},{45.83,37.22},{48.98,40.09},{52.47,45.07},{42.2,43.28},{55.11,36.86},{42.24,72.34},{40.88,73.19},{54.49,39.22},{36.99,51.04},{39.41,70.17},{36.63,49.99},{35.78,52.32},{37.58,61.35},{35.64,55.26},{36.8,57.99},{36.31,61.59},{35.88,56.69},{39.19,52.96},{57.35,42.97},{48.84,45.83},{36.84,65.82},{55.97,40.86},{38.83,54.3},{33.67,30.66},{41.11,68.97},{39.34,56.13},{54.65,41.95},{33.27,31.11},{36.44,53.89},{35.73,44.24},{46.03,71.18},{39.14,66.6},{45.14,71.11},{55.68,46.09},{44.85,40.81},{38.04,67.06},{39.63,66.32},{34.35,34.07},{37.59,35.29},{41.97,66.44},{62.58,54.76},{41.58,63.42},{42.8,67.43},{40.44,62.64},{40.82,68.26},{42.96,55.01},{61.66,59.65},{35.7,79.07},{39.97,56.88},{40.47,51.37},{38.21,63.46},{35.56,38.08},{43.69,51.4},{36.67,41.2},{43.73,43.92},{39.47,61.87},{37.77,75.17},{40.19,70.17},{52.51,60.64},{43.46,67.53},{39.46,52.16},{50.2,66.96},{47.89,68.31},{54.63,68.57},{53.88,61.63},{35.31,48.3},{58.43,72.27},{35.06,39.19},{56.55,57.68},{46.65,68.38},{49.12,66.41},{36.92,77.18},{36.9,73.2},{55.09,57.75},{36.98,69.38},{35.63,71.43},{36.35,68.43},{40.79,59.7},{57.76,67.36},{58.08,66.64},{45.4,45.08},{42.07,59.62}}},nil,215,nil,nil,189,"AH",nil,0},
[2957] = {'Elder Plainstrider',156,176,8,9,0,{[215]={{49.68,13.52},{55.72,25.58},{53.71,19.7},{49.62,38.14},{42.21,11.18},{50.05,33.47},{55.05,19.56},{57.04,27.94},{46.31,32.15},{55.75,33.73},{52.03,22.12},{56.78,32.54},{47.34,27.04},{52.01,39.41},{52.5,24.86},{53.2,14.06},{54.83,20.96},{53.06,18.37},{43.97,8.61},{39.74,8.76},{58.17,21.89},{52.49,34.37},{52.49,35.24},{50.62,8.09},{57.02,17.92},{47.66,25.25},{62.02,26.26},{49.81,29.32},{44.61,31.52},{47.32,18.63},{44.16,17.87},{46.81,14.0},{51.21,26.62},{43.75,10.2},{50.96,23.63},{52.57,32.48},{47.59,13.66},{49.22,29.63},{49.26,25.58},{51.26,10.07},{38.52,12.55},{37.38,14.79},{47.15,7.59},{38.35,17.09},{51.48,27.88},{53.94,12.64},{60.49,53.62},{51.23,18.59},{57.91,20.64},{60.68,25.6},{44.58,28.44},{53.95,31.31},{53.61,34.1},{56.04,29.5},{59.19,22.95},{57.79,30.31},{57.82,26.96},{51.22,42.18},{52.49,39.73},{41.58,11.49},{60.25,26.63},{54.46,24.62},{54.27,22.98},{54.03,28.94},{51.12,17.74},{57.7,53.89},{60.31,24.66},{40.8,50.07},{46.09,10.73},{50.48,14.0},{48.09,9.97},{45.82,18.53},{48.59,16.1},{41.13,13.22},{48.63,14.74},{47.33,10.15},{50.64,46.14},{46.02,17.02},{56.81,44.75},{37.11,43.04},{38.23,39.8},{46.1,44.26},{64.19,61.68},{55.66,50.63},{38.23,18.91},{43.29,47.0},{39.55,18.77},{42.72,18.57},{38.1,46.97},{53.9,44.09},{62.16,64.38},{60.97,64.55},{62.43,62.83},{64.17,63.52},{66.23,60.7},{68.22,59.65},{33.26,26.51},{47.87,36.54},{47.43,41.89},{55.9,56.42}},[1638]={{22.35,6.34},{64.21,23.02}}},nil,215,nil,nil,189,"AH",nil,0},
[2958] = {'Prairie Wolf',102,120,5,6,0,{[215]={{34.28,73.46},{36.49,71.5},{34.97,68.39},{33.92,77.48},{38.05,70.35},{33.66,76.27},{34.05,79.31},{34.91,71.26},{35.05,53.7},{39.87,52.61},{34.35,76.09},{38.25,71.16},{41.91,73.66},{43.08,71.33},{36.46,51.86},{37.46,64.41},{38.18,53.54},{34.94,52.59},{36.32,52.19},{38.23,55.66},{38.17,58.11},{37.83,56.59},{35.75,55.97},{36.05,57.66},{36.44,59.67},{41.57,51.79},{36.84,59.35},{40.03,58.73},{36.24,64.68},{35.73,65.43},{43.64,70.36},{42.05,63.82},{37.19,63.59},{36.38,60.97},{40.2,73.45},{44.85,67.29},{39.56,57.3},{45.9,69.29},{48.3,69.78},{47.63,69.08},{46.16,70.41},{42.16,54.98},{45.58,70.45},{36.9,56.43},{41.59,70.27},{39.75,63.66},{38.97,64.22},{39.51,67.48},{36.28,67.39},{37.78,69.48},{39.89,69.39},{38.09,61.82},{38.66,62.95},{40.85,66.13},{40.77,61.97},{40.71,66.44},{38.25,65.72},{36.57,65.24},{35.6,59.32},{37.65,66.4},{39.26,68.38},{40.8,53.98},{39.03,49.87},{39.98,68.63},{41.51,65.56},{41.62,68.19},{38.05,52.16},{42.95,66.65},{41.41,63.95},{39.15,50.87},{40.21,54.68},{55.02,65.83},{37.31,62.46},{40.79,60.74},{40.76,51.83},{37.77,75.59},{40.23,57.67},{39.02,74.04},{39.48,71.23},{49.82,65.3},{56.67,66.32},{53.43,69.81},{53.37,68.37},{39.6,55.65},{50.67,64.6},{55.35,70.39},{56.61,69.3},{51.88,66.71},{56.38,63.67},{48.63,67.45},{53.86,57.7},{55.78,62.69},{40.92,71.18},{35.03,77.94},{39.29,53.56},{56.3,65.79},{38.95,72.45},{34.95,76.15},{55.13,67.42},{36.31,72.37},{36.87,75.21},{37.83,58.59},{42.2,61.71},{35.61,73.36},{54.44,70.4},{36.3,70.38},{47.48,65.44},{51.27,67.45},{35.05,72.37},{54.31,59.29},{51.2,69.53},{50.58,68.37},{41.49,60.56},{35.69,69.4},{37.56,54.82},{35.69,75.25},{36.98,67.47},{42.21,55.71}}},nil,215,nil,nil,38,nil,nil,0},
[2959] = {'Prairie Stalker',137,156,7,8,0,{[215]={{59.12,71.1},{62.99,53.24},{45.23,35.5},{51.22,34.11},{57.74,70.44},{57.8,73.04},{35.51,50.97},{59.66,65.94},{58.02,44.62},{58.77,55.02},{57.13,44.45},{50.85,45.05},{58.13,42.84},{55.05,44.32},{57.63,46.44},{57.11,46.13},{52.62,43.22},{51.48,38.88},{57.87,68.23},{53.8,40.53},{38.34,40.02},{38.93,39.59},{58.17,50.76},{34.72,35.81},{60.46,63.33},{37.53,35.39},{59.35,45.46},{54.49,37.26},{55.43,48.15},{57.36,47.55},{61.12,67.74},{36.28,45.01},{35.42,49.98},{55.95,45.2},{57.56,47.22},{41.4,37.91},{55.81,44.02},{58.82,52.74},{42.84,52.95},{41.7,52.04},{34.2,31.05},{60.94,56.05},{48.68,31.08},{35.36,51.67},{35.01,43.0},{53.51,45.02},{47.41,32.6},{60.91,66.45},{54.13,41.31},{54.38,42.58},{58.92,64.6},{33.74,28.73},{50.21,36.87},{41.99,41.25},{60.26,55.44},{41.08,43.98},{39.52,42.36},{56.52,71.28},{46.97,37.84},{49.92,43.22},{49.94,48.02},{51.39,47.98},{51.9,46.3},{41.6,39.8},{52.45,45.0},{49.47,39.88},{48.01,42.15},{60.88,58.76},{51.88,40.04},{52.61,44.42},{49.01,43.13},{42.14,41.72},{57.2,65.57},{50.51,39.95},{49.34,36.21},{45.36,33.25},{58.99,67.19},{50.96,46.59},{48.6,37.78},{58.82,52.12},{46.66,35.37},{57.59,58.02},{45.56,34.23},{60.24,59.37},{54.47,44.21},{43.23,47.89},{60.34,61.71},{49.26,48.99},{45.0,49.07},{53.81,45.08},{42.78,41.49},{40.13,49.69},{60.64,60.71},{46.54,47.91},{43.36,46.59},{57.54,51.61},{44.55,47.74},{51.83,43.2},{42.19,43.19},{58.59,62.51},{42.15,46.03},{55.18,50.23},{41.84,51.01},{42.81,50.39},{46.13,33.57},{56.38,59.55},{51.17,44.18},{34.35,27.72},{61.8,69.31},{41.72,40.19},{40.93,42.19},{47.91,47.85},{57.19,55.95},{55.99,55.82},{46.76,47.03},{56.86,58.58},{46.61,48.93},{42.74,47.27},{49.31,47.11},{47.76,46.92},{45.35,39.97},{39.52,40.31},{55.78,57.85},{44.78,38.33},{41.46,49.19},{46.68,45.06},{48.03,39.18},{43.44,42.12},{44.8,40.11},{47.36,49.97},{41.44,45.17},{44.07,41.1},{57.0,62.49},{35.87,33.37},{36.97,34.34},{35.71,36.31},{37.14,35.86}},[1638]={{26.07,41.13},{26.36,39.58},{28.6,77.22}}},nil,215,nil,nil,38,nil,nil,0},
[2960] = {'Prairie Wolf Alpha',176,198,9,10,0,{[215]={{61.01,27.76},{46.18,26.64},{56.78,28.43},{45.91,27.98},{54.09,33.92},{50.46,29.63},{45.43,29.14},{49.27,14.08},{52.33,15.26},{45.49,27.28},{49.42,15.83},{46.53,28.81},{44.08,30.24},{53.08,13.02},{53.3,29.43},{66.75,66.52},{61.53,67.75},{61.68,68.32},{56.04,31.33},{51.13,14.18},{37.16,15.52},{62.22,66.35},{62.88,68.09},{64.66,67.78},{57.26,28.71},{57.44,31.3},{66.09,65.83},{50.92,16.6},{32.32,20.11},{64.76,67.17},{56.27,24.61},{59.02,28.99},{48.04,28.52},{58.21,27.9},{65.15,67.73},{52.02,19.92},{57.08,25.59},{45.41,26.59},{52.55,17.37},{52.75,20.66},{49.2,12.28},{50.63,12.93},{50.95,21.93},{36.31,15.84},{62.33,65.62},{45.35,17.74},{45.28,18.79},{54.57,21.54},{56.25,20.88},{62.26,58.42},{61.54,61.58},{62.07,56.24},{63.42,56.23},{66.18,58.81},{48.81,23.69},{57.08,20.77},{57.56,22.39},{53.86,24.09},{49.96,14.2},{42.73,10.08},{42.87,14.74},{45.3,15.91},{52.16,23.21},{57.44,24.85},{66.24,56.65},{63.52,69.21},{65.58,57.26},{64.01,59.7},{62.84,59.66},{63.2,58.7},{61.48,57.61},{66.87,58.14},{64.53,59.04},{62.26,57.71},{65.9,59.73},{66.86,60.37},{64.64,60.99},{66.98,64.83},{66.15,64.71},{66.72,58.78},{62.9,65.54},{63.67,60.66},{49.22,7.74},{51.26,9.09},{49.93,11.84},{40.82,11.1},{50.49,19.72},{49.09,27.18},{43.4,9.04},{44.38,30.32},{40.2,10.07},{49.06,30.69},{50.5,32.22},{40.74,18.58},{53.11,32.49},{62.83,61.72},{65.31,63.18},{65.52,65.42},{64.21,65.42},{66.77,63.58},{38.9,17.78},{41.52,8.05}},[1638]={{67.55,38.78}}},nil,215,nil,nil,38,nil,nil,0},
[2961] = {'Mountain Cougar',71,71,3,3,0,{[215]={{55.81,94.04},{56.43,92.71},{56.46,93.84},{56.09,94.67},{57.75,93.82},{57.86,92.34},{57.6,90.68},{41.61,90.67},{54.84,89.25},{42.8,83.63},{42.13,84.97},{42.45,85.94},{41.52,84.21},{55.07,90.5},{54.6,91.62},{55.91,90.41},{55.76,91.8},{56.52,91.06},{53.88,89.14},{41.64,87.35},{53.39,89.34},{42.04,87.94},{53.73,89.9},{47.87,91.77},{48.47,92.11},{49.19,91.57},{49.4,91.1},{48.75,89.0},{51.17,91.18},{52.03,92.37},{51.8,89.86},{52.27,90.84},{53.12,91.25},{53.15,92.52},{53.62,90.95},{53.86,90.73},{53.28,89.76},{49.98,90.43},{49.09,90.07},{50.54,89.82},{51.06,88.96},{52.54,89.24},{47.86,90.59},{48.63,91.4},{48.52,89.78},{46.79,92.06},{47.42,92.72},{40.13,83.29},{40.85,82.06},{51.86,89.85},{45.41,88.78},{44.2,94.45},{44.99,94.15},{44.83,92.83},{45.96,90.37},{46.03,89.84},{47.35,89.83},{49.81,87.74},{45.14,91.88},{45.75,89.62},{42.07,88.82},{42.74,87.66},{41.6,88.67},{40.79,88.87},{43.4,89.88},{43.33,88.51},{44.78,88.26},{43.64,89.97},{44.8,91.51},{43.23,91.26},{43.75,90.52},{43.71,92.12},{44.89,91.81}}},nil,215,nil,nil,7,"AH",nil,0},
[2962] = {'Windfury Harpy',137,156,7,8,0,{[215]={{34.27,42.14},{33.7,43.16},{67.51,69.52},{67.54,72.21},{66.74,68.39},{64.91,70.99},{32.43,41.1},{33.64,41.08},{32.32,42.08},{32.37,43.04},{31.15,42.21},{31.73,40.32},{31.73,42.24},{31.07,41.09},{61.62,71.4},{62.34,71.29},{63.56,70.42},{62.51,71.49},{62.94,70.51},{64.77,69.34},{64.14,70.41},{63.68,72.35},{65.58,68.44},{66.21,69.53},{66.07,70.21},{66.98,71.06},{66.81,70.25}}},nil,215,nil,nil,514,nil,nil,0},
[2963] = {'Windfury Wind Witch',148,166,8,9,0,{[215]={{34.4,44.05},{68.05,69.52},{34.31,41.19},{61.7,72.41},{66.11,68.36},{67.45,70.45},{66.88,69.59},{67.59,71.39},{67.98,71.22},{65.55,70.46},{33.65,42.02},{31.79,41.34},{34.23,43.14},{33.08,42.19},{33.05,43.02},{31.86,43.01},{33.78,40.3},{63.57,71.3},{65.35,69.06}}},nil,215,nil,nil,514,nil,nil,0},
[2964] = {'Windfury Sorceress',160,178,9,10,0,{[215]={{36.91,10.96},{35.0,13.67},{35.76,11.95},{36.26,9.86},{38.14,8.98},{39.5,8.01},{38.78,9.01},{28.41,21.31},{40.1,5.28},{39.55,6.1},{40.16,7.1},{37.93,8.06},{38.17,5.93},{53.41,6.02},{51.78,7.18},{51.8,5.28},{54.54,12.13},{54.35,10.71},{55.22,11.72},{56.35,15.79},{56.45,13.76},{55.82,17.06},{56.37,14.97},{29.19,21.02},{29.73,27.48},{31.09,19.64},{55.04,16.07},{29.17,22.78},{29.75,21.58},{30.5,20.71},{31.78,23.62},{29.7,26.39},{31.07,28.35},{29.65,24.68},{31.07,25.5},{29.76,23.8},{29.19,25.73},{30.38,25.74},{30.48,26.54},{30.38,22.83},{31.1,23.63},{31.78,20.84},{31.05,21.62},{31.59,22.85},{32.46,24.69},{36.89,12.03},{51.11,7.17}}},nil,215,nil,nil,514,nil,nil,0},
[2965] = {'Windfury Matriarch',186,208,10,11,0,{[215]={{36.28,10.94},{36.33,11.95},{35.19,12.82},{36.76,9.27},{39.4,5.13},{39.35,7.06},{40.79,5.22},{40.18,6.23},{40.07,8.15},{38.84,5.5},{37.93,7.03},{37.57,10.12},{38.18,7.93},{52.75,5.58},{51.96,6.06},{51.17,5.27},{55.66,12.26},{55.12,11.06},{55.15,9.87},{55.04,9.22},{56.31,12.92},{55.83,15.99},{51.23,6.04},{50.62,5.22},{32.43,23.59},{30.33,21.69},{28.99,21.72},{30.34,19.66},{29.72,19.61},{29.91,20.76},{30.34,27.62},{31.66,28.34},{32.41,27.56},{31.8,24.63},{31.07,27.66},{31.57,26.58},{31.12,26.51},{29.74,25.66},{29.84,22.56},{30.51,24.77},{30.93,24.53},{30.38,23.59},{31.76,21.74},{31.1,22.81},{32.49,25.41},{33.08,24.69}},[1638]={{13.17,23.17}}},nil,215,nil,nil,514,nil,nil,0},
[2966] = {'Battleboar',71,86,3,4,0,{[215]={{58.67,90.06},{59.46,90.55},{60.24,88.8},{59.57,90.45},{56.91,90.06},{59.38,88.59},{58.35,88.85},{55.86,87.91},{57.61,90.06},{52.38,75.04},{51.86,77.18},{53.97,76.94},{53.17,76.25},{54.4,76.31},{55.06,75.23},{55.01,77.15},{55.78,76.16},{58.15,88.05},{56.84,88.02},{57.61,86.71},{56.94,88.87},{52.62,79.26},{55.05,86.75},{56.5,87.48},{56.15,84.23},{56.26,85.22},{56.97,84.91},{56.45,84.06},{55.68,86.2},{55.11,85.7},{54.56,84.03},{52.61,80.16},{53.07,77.66},{53.28,79.29},{55.08,79.38},{55.16,78.05},{56.54,81.96},{56.06,81.95},{55.5,82.09},{54.99,81.85},{53.82,81.98},{54.97,80.84},{54.55,80.07},{54.26,81.85},{55.69,80.17},{56.46,85.89}}},nil,215,nil,nil,14,nil,nil,0},
[2967] = {'Galak Centaur',156,176,8,9,0,{[215]={{66.98,57.07},{68.78,62.3},{68.33,58.12},{66.84,57.0},{68.68,62.54},{68.25,58.0}}},nil,215,nil,nil,131,nil,nil,0},
[2968] = {'Galak Outrunner',176,198,9,10,0,{[215]={{66.98,57.07},{68.78,62.3},{68.33,58.12},{66.84,57.0},{68.68,62.54},{68.25,58.0}}},nil,215,nil,nil,131,nil,nil,0},
[2969] = {'Wiry Swoop',102,137,5,7,0,{[215]={{34.18,78.27},{44.68,70.43},{40.99,66.28},{35.11,66.52},{37.57,62.59},{37.95,66.41},{40.68,63.43},{40.56,54.27},{53.88,58.66},{55.15,70.36},{36.92,70.41},{39.5,70.35},{38.96,57.84},{49.91,68.59},{40.86,58.71},{37.06,59.05},{38.95,53.67}}},nil,215,nil,nil,73,nil,nil,0},
[2970] = {'Swoop',137,176,7,9,0,{[215]={{54.79,37.39},{51.72,34.79},{60.24,54.91},{52.08,37.19},{47.37,36.53},{44.72,34.89},{35.22,49.46},{56.74,46.1},{51.76,40.34},{55.34,42.3},{34.82,42.76},{36.18,44.93},{42.81,51.88},{52.1,44.12},{53.81,45.04},{53.82,40.74},{49.23,38.39},{37.62,41.16},{49.82,44.36},{58.28,51.96},{58.87,64.52},{46.15,49.65},{46.76,34.84},{42.25,43.54},{49.57,40.68},{57.43,48.62},{59.77,59.74},{42.77,39.85},{42.73,45.16},{49.01,48.01},{48.61,44.11},{57.73,68.36},{41.5,48.56},{43.32,49.21}}},nil,215,nil,nil,73,nil,nil,0},
[2971] = {'Taloned Swoop',156,198,8,10,0,{[215]={{48.91,9.2},{52.6,13.77},{50.82,28.93},{53.87,26.51},{55.51,32.43},{57.99,28.8},{51.68,20.05},{53.75,32.01},{57.76,22.4},{51.85,16.45},{46.69,10.06},{66.81,57.7},{46.59,13.42},{53.35,18.87},{64.91,59.57},{37.6,17.31},{42.17,9.97},{53.18,23.69},{52.24,30.27}}},nil,215,nil,nil,73,nil,nil,0},
[2972] = {'Kodo Calf',137,156,7,8,0,{[215]={{59.09,20.73},{43.59,18.11},{43.24,18.2},{36.11,71.65},{35.72,71.96},{35.73,40.72},{35.83,40.07},{32.29,27.19},{32.57,27.22},{32.72,26.52},{32.73,26.83},{59.71,21.6},{43.16,17.45},{36.03,40.67},{59.3,21.45},{59.71,20.98},{59.55,20.64},{43.38,17.72},{35.82,71.47},{36.09,72.11},{35.88,41.04},{32.48,26.83},{43.6,17.49}}},nil,215,nil,nil,15,"AH",nil,0},
[2973] = {'Kodo Bull',198,222,10,11,0,{[215]={{59.09,20.73},{43.59,18.11},{43.24,18.2},{36.11,71.65},{35.72,71.96},{35.73,40.72},{35.83,40.07},{32.29,27.19},{32.57,27.22},{32.72,26.52},{32.73,26.83},{59.71,21.6},{43.16,17.45},{36.03,40.67},{59.3,21.45},{59.71,20.98},{59.55,20.64},{43.38,17.72},{35.82,71.47},{36.09,72.11},{35.88,41.04},{32.48,26.83},{43.6,17.49}}},nil,215,nil,nil,15,"AH",nil,0},
[2974] = {'Kodo Matriarch',222,247,11,12,0,{[215]={{59.09,20.73},{43.59,18.11},{43.24,18.2},{36.11,71.65},{35.72,71.96},{35.73,40.72},{35.83,40.07},{32.29,27.19},{32.57,27.22},{32.72,26.52},{32.73,26.83},{59.71,21.6},{43.16,17.45},{36.03,40.67},{59.3,21.45},{59.71,20.98},{59.55,20.64},{43.38,17.72},{35.82,71.47},{36.09,72.11},{35.88,41.04},{32.48,26.83},{43.6,17.49}}},nil,215,nil,nil,15,"AH",nil,0},
[2975] = {'Venture Co. Hireling',102,120,5,6,0,{[215]={{54.18,67.04},{53.93,67.24},{54.3,66.49},{53.54,66.92},{53.3,66.79},{53.69,65.78},{54.33,65.82},{53.97,66.12},{53.34,65.67},{53.21,66.21},{53.55,66.31}}},nil,215,nil,nil,47,nil,nil,0},
[2976] = {'Venture Co. Laborer',120,137,6,7,0,{[215]={{53.8,47.19},{53.38,47.37},{53.22,48.87},{44.36,46.04},{44.16,44.88},{44.09,45.64},{53.91,66.58},{53.51,48.4},{53.74,48.88},{54.39,48.74},{54.41,48.05},{53.68,47.69},{44.81,45.44},{44.52,44.63}}},nil,215,nil,nil,47,nil,nil,0},
[2977] = {'Venture Co. Taskmaster',137,156,7,8,0,{[215]={{52.99,47.92},{53.78,48.38},{54.02,47.82},{44.84,44.87},{44.72,45.97},{44.52,44.87},{44.37,45.39}}},nil,215,nil,nil,47,nil,nil,0},
[2978] = {'Venture Co. Worker',156,176,8,9,0,{[215]={{65.68,40.34},{62.12,35.24},{66.11,39.2},{61.06,39.79},{61.96,36.83},{66.79,39.29},{66.41,39.61},{61.69,35.6},{67.02,38.9},{66.9,38.79},{66.01,39.13},{64.86,38.81},{66.28,39.61},{62.08,35.67},{66.52,39.08},{61.23,35.36},{64.74,38.86},{61.21,39.86},{64.26,38.9},{65.21,37.41},{65.14,37.66},{65.24,38.33},{65.45,38.11},{65.3,37.54},{65.69,38.92},{65.4,37.92},{65.49,43.36},{65.76,43.41},{65.78,43.2},{62.36,38.83},{62.39,38.66},{63.17,41.22},{62.53,39.83},{61.42,36.95},{61.21,37.29},{61.01,37.51},{64.86,44.63},{64.98,42.99},{65.11,43.44},{64.45,42.55},{64.23,42.3},{64.58,42.78},{64.23,42.69},{62.95,43.55},{63.2,43.38},{63.31,41.74},{63.23,42.29},{63.07,42.67},{65.65,40.65},{65.35,40.7},{65.14,39.9},{65.44,41.2},{65.58,41.11},{59.99,42.91},{60.15,43.17},{40.28,16.93},{39.51,16.0},{39.56,14.97},{42.49,13.48},{42.47,14.38},{43.04,13.53},{40.76,16.01},{40.12,14.83},{40.22,15.9},{40.92,16.76},{62.73,37.34},{62.79,37.58},{60.25,36.35},{59.56,47.93},{59.96,48.02},{60.03,47.77},{59.66,48.71},{59.69,48.44},{59.96,48.54},{60.24,48.69},{60.06,49.12},{60.48,48.39},{60.43,49.18},{62.01,48.69},{60.69,48.96},{60.59,48.68},{61.94,47.84},{61.32,48.66},{62.11,48.17},{61.09,47.58},{61.0,47.21},{62.17,46.09},{61.88,46.36},{62.74,45.87},{62.06,45.57},{63.12,45.46},{62.54,44.43},{62.72,43.81},{63.5,44.86},{61.56,43.1},{62.31,44.06},{62.93,44.05},{61.11,42.64},{61.55,42.66},{61.98,43.22},{60.65,41.97},{63.39,41.28},{62.95,40.85},{62.98,42.2},{62.3,40.85},{62.46,41.46},{62.34,41.85},{62.63,42.25},{62.31,42.36},{61.88,42.31},{61.87,41.98},{61.59,41.58},{61.04,40.59},{62.93,39.99},{62.83,39.72},{63.34,40.12},{64.17,40.1},{64.03,40.4},{64.56,39.87},{62.95,37.96},{62.92,38.75},{62.85,38.6},{61.24,36.71},{62.73,38.14},{42.67,13.61},{43.09,14.37},{42.85,14.24}}},nil,215,nil,nil,47,nil,nil,0},
[2979] = {'Venture Co. Supervisor',176,198,9,10,0,{[215]={{65.61,39.88},{65.49,38.81},{59.07,35.01},{63.97,39.04},{58.92,35.01},{59.11,35.98},{60.17,34.19},{59.03,35.19},{65.2,38.93},{65.92,39.62},{59.07,36.64},{60.67,34.81},{62.19,38.48},{60.85,39.28},{60.69,38.2},{60.77,38.48},{60.86,38.03},{62.44,38.06},{61.03,38.0},{64.58,44.54},{64.44,39.08},{65.32,39.65},{64.8,44.1},{64.81,43.73},{42.65,14.15},{42.88,13.82},{40.02,15.62},{40.44,16.35},{63.68,38.96},{60.67,36.98},{60.97,37.22},{60.71,36.53},{60.44,36.6},{59.39,34.65},{64.38,43.11},{60.41,48.59},{60.22,48.29},{61.68,46.73},{61.4,47.46},{61.51,46.91},{62.33,45.9},{61.79,46.1},{62.34,45.63},{63.18,44.99},{63.25,44.88},{60.48,42.3},{62.88,41.32},{60.86,42.51},{60.86,41.94},{61.25,42.1},{62.2,39.58},{62.19,42.06},{62.65,40.7},{61.34,41.32},{62.77,42.03},{61.06,41.58},{61.1,41.13},{61.4,40.81},{61.87,41.24},{61.98,40.86},{61.62,41.04},{63.05,39.47},{63.53,40.94},{63.5,40.25},{64.9,39.63},{63.15,38.37},{60.97,36.77}}},nil,215,nil,nil,47,nil,nil,0},
[2980] = {'Grull Hawkwind',86,86,4,4,0,{[215]={{44.88,77.07}}},nil,215,{747,750,780,3091,3092,3093,3094},{747,750,780},104,"H",nil,3},
[2981] = {'Chief Hawkwind',1468,1468,36,36,0,{[215]={{44.18,76.06}}},nil,215,{752,755,763},{753,757,781},104,"H",nil,3},
[2982] = {'Seer Graytongue',156,156,8,8,0,{[215]={{42.57,92.19}}},nil,215,{757},{755},104,"H",nil,2},
[2983] = {'The Plains Vision',137,137,7,7,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[2984] = {'Seer Wiserunner',222,222,11,11,0,{[215]={{32.71,36.09}}},nil,215,{773},{772},104,"H",nil,2},
[2985] = {'Ruul Eagletalon',176,176,9,9,0,{[215]={{47.35,62.02}}},nil,215,{743},{743},104,"H",nil,2},
[2986] = {'Dorn Plainstalker',950,950,29,29,0,{[400]={{53.95,41.49}}},nil,400,{1149,1150,1151,1152},{1149,1150,1151,1394},104,"H",nil,2},
[2987] = {'Eyahn Eagletalon',247,247,12,12,0,{[1638]={{37.75,59.57}}},nil,1638,{744},{744},83,"H",nil,2},
[2988] = {'Morin Cloudstalker',198,198,10,10,0,{[215]={{57.2,61.22}}},{[215]={{{57.2,61.22},{57.55,61.32},{57.99,61.54},{58.31,61.72},{58.64,61.89},{58.96,62.06},{59.28,62.24},{59.6,62.41},{59.92,62.59},{60.24,62.76},{60.56,62.93},{60.99,63.17},{61.42,63.34},{61.84,63.43},{62.62,63.39},{62.82,63.37},{63.22,63.3},{63.97,63.0},{64.61,62.68},{64.81,62.59},{65.46,62.31},{65.79,62.16},{66.12,62.02},{66.4,61.9},{66.77,61.69},{67.08,61.47},{67.39,61.25},{67.68,61.04},{68.04,60.85},{68.58,60.64},{69.08,60.52},{69.42,60.51},{68.89,60.5},{68.45,60.64},{68.22,60.72},{67.52,61.09},{67.11,61.4},{66.93,61.54},{66.47,61.83},{66.08,62.0},{65.75,62.14},{65.43,62.28},{65.1,62.43},{64.77,62.57},{64.44,62.71},{64.12,62.85},{63.79,63.0},{63.46,63.14},{63.02,63.33},{62.59,63.44},{62.16,63.46},{61.82,63.41},{61.37,63.33},{61.01,63.2},{60.69,63.0},{60.37,62.81},{60.06,62.62},{59.74,62.43},{59.43,62.24},{58.6,61.79},{58.39,61.67},{58.07,61.52},{57.59,61.29},{57.26,61.2},{56.89,61.1},{56.55,61.06},{56.18,61.02},{55.79,60.91},{55.37,60.69},{54.94,60.54},{54.51,60.45},{53.97,60.45},{53.53,60.4},{53.09,60.28},{52.45,59.94},{52.03,59.72},{51.82,59.51},{52.25,59.83},{52.63,60.09},{53.0,60.25},{53.2,60.33},{53.63,60.44},{53.97,60.47},{54.31,60.51},{54.65,60.55},{55.02,60.6},{55.43,60.73},{55.88,60.97},{56.32,61.09},{56.94,61.13}}}},215,{749,764,765},{751,764,765},104,"H",nil,2},
[2989] = {'Bael\'dun Digger',137,156,7,8,0,{[215]={{31.98,47.35},{31.39,47.64},{33.81,49.7},{32.72,49.14},{31.47,48.83},{32.3,49.18},{32.13,49.65},{31.07,50.17},{31.86,50.45},{32.06,49.99},{34.27,47.91},{33.68,49.05},{34.38,47.14},{33.76,48.05},{30.87,48.5},{31.64,47.61},{30.85,48.84},{30.86,49.22},{31.02,47.93},{30.92,49.86},{31.66,48.89}}},nil,215,nil,nil,57,"A",nil,0},
[2990] = {'Bael\'dun Appraiser',143,160,8,9,0,{[215]={{31.31,48.28},{31.89,47.86},{33.22,47.5},{33.03,47.54},{31.6,48.43},{31.25,48.77},{31.47,49.43},{31.47,48.77},{32.74,48.31},{31.82,49.73},{32.03,49.65},{31.37,49.86},{31.3,48.74}}},nil,215,nil,nil,57,"A",nil,0},
[2991] = {'Greatmother Hawkwind',176,176,9,9,0,{[215]={{50.03,81.16}}},nil,215,{753},{752},104,"H",nil,2},
[2992] = {'Healing Ward V',853,853,28,28,0,nil,nil,0,nil,nil,152,nil,nil,0},
[2993] = {'Baine Bloodhoof',198,198,10,10,0,{[215]={{47.51,60.16}}},nil,215,{745,746,767},{745,746,763},104,"H",nil,2},
[2994] = {'Ancestral Spirit',176,176,9,9,0,{[215]={{61.45,21.02}}},nil,215,{775},{773},104,"H",nil,2},
[2995] = {'Tal',7842,7842,55,55,1,{[1638]={{47.0,49.83}}},nil,1638,{6364},{6363},104,"H","Wind Rider Master",11},
[2996] = {'Torn',5544,5544,45,45,0,{[1638]={{47.63,58.58}}},nil,1638,nil,nil,104,"H","Banker",256},
[2997] = {'Jyn Stonehoof',1002,1002,30,30,0,{[1638]={{41.42,62.36}}},nil,1638,nil,nil,104,"H","Weapons Merchant",16388},
[2998] = {'Karn Stonehoof',1342,1342,35,35,0,{[1638]={{39.38,55.09}}},nil,1638,nil,nil,104,"H","Expert Blacksmith",19},
[2999] = {'Taur Stonehoof',1002,1002,30,30,0,{[1638]={{39.82,55.65}}},nil,1638,nil,nil,104,"H","Blacksmithing Supplies",16390},
[3000] = {'Gibbert',2217,2217,45,45,0,{[490]={{44.1,7.19}}},nil,490,nil,nil,35,"AH","Weapon Merchant",16388},
[3001] = {'Brek Stonehoof',1342,1342,35,35,0,{[1638]={{34.37,57.9}}},nil,1638,nil,nil,104,"H","Mining Trainer",19},
[3002] = {'Kurm Stonehoof',1752,1752,40,40,0,{[1638]={{34.35,56.56}}},nil,1638,nil,nil,104,"H","Mining Supplier",6},
[3003] = {'Fyr Mistrunner',1002,1002,30,30,0,{[1638]={{41.44,53.19}}},nil,1638,nil,nil,104,"H","Bread Vendor",6},
[3004] = {'Tepa',1342,1342,35,35,0,{[1638]={{44.52,45.35}}},nil,1638,nil,nil,104,"H","Expert Tailor",17},
[3005] = {'Mahu',1002,1002,30,30,0,{[1638]={{43.8,45.12}}},nil,1638,nil,nil,104,"H","Leatherworking & Tailoring Supplies",6},
[3007] = {'Una',2398,2398,46,46,0,{[1638]={{41.5,42.57}}},nil,1638,nil,{2860},104,"H","Artisan Leatherworker",19},
[3008] = {'Mak',664,664,24,24,0,{[1638]={{42.06,43.45}}},nil,1638,nil,nil,104,"H","Journeyman Leatherworker",19},
[3009] = {'Bena Winterhoof',1342,1342,35,35,0,{[1638]={{46.62,33.17}}},nil,1638,nil,{2440},104,"H","Expert Alchemist",19},
[3010] = {'Mani Winterhoof',1002,1002,30,30,0,{[1638]={{47.41,33.74}}},nil,1638,nil,nil,104,"H","Alchemy Supplies",6},
[3011] = {'Teg Dawnstrider',1342,1342,35,35,0,{[1638]={{44.91,37.49}}},nil,1638,nil,nil,104,"H","Expert Enchanter",17},
[3012] = {'Nata Dawnstrider',1002,1002,30,30,0,{[1638]={{44.99,38.75}}},nil,1638,nil,nil,104,"H","Enchanting Supplies",6},
[3013] = {'Komin Winterhoof',1342,1342,35,35,0,{[1638]={{49.95,40.41}}},nil,1638,nil,nil,104,"H","Herbalism Trainer",16},
[3014] = {'Nida Winterhoof',1002,1002,30,30,0,{[1638]={{49.57,39.57}}},nil,1638,nil,nil,104,"H","Herbalism Supplier",6},
[3015] = {'Kuna Thunderhorn',1002,1002,30,30,0,{[1638]={{47.0,45.7}}},nil,1638,nil,nil,104,"H","Bowyer & Fletching Goods",16388},
[3016] = {'Tand',1002,1002,30,30,0,{[1638]={{49.05,34.24}}},nil,1638,nil,nil,104,"H","Basket Weaver",6},
[3017] = {'Nan Mistrunner',1002,1002,30,30,0,{[1638]={{47.34,42.49}}},nil,1638,nil,nil,104,"H","Fruit Vendor",6},
[3018] = {'Hogor Thunderhoof',1002,1002,30,30,0,{[1638]={{55.55,57.07}}},nil,1638,nil,nil,104,"H","Guns Merchant",16388},
[3019] = {'Delgo Ragetotem',1002,1002,30,30,0,{[1638]={{54.07,57.23}}},nil,1638,nil,nil,104,"H","Axe Merchant",16388},
[3020] = {'Etu Ragetotem',1002,1002,30,30,0,{[1638]={{53.19,58.29}}},nil,1638,nil,nil,104,"H","Mace & Staff Merchant",16388},
[3021] = {'Kard Ragetotem',1002,1002,30,30,0,{[1638]={{52.98,56.63}}},nil,1638,nil,nil,104,"H","Sword and Dagger Merchant",16388},
[3022] = {'Sunn Ragetotem',1002,1002,30,30,0,{[1638]={{49.63,48.71}}},nil,1638,nil,nil,104,"H","Staff Merchant",16388},
[3023] = {'Sura Wildmane',1002,1002,30,30,0,{[1638]={{51.59,55.02}}},nil,1638,nil,nil,104,"H","War Harness Vendor",16388},
[3024] = {'Tah Winterhoof',1002,1002,30,30,0,{[1638]={{54.14,47.05}}},nil,1638,nil,nil,104,"H",nil,0},
[3025] = {'Kaga Mistrunner',1002,1002,30,30,0,{[1638]={{52.3,47.79}}},nil,1638,nil,nil,104,"H","Meat Vendor",6},
[3026] = {'Aska Mistrunner',2217,2217,45,45,0,{[1638]={{50.72,53.11}}},nil,1638,nil,nil,104,"H","Cooking Trainer",19},
[3027] = {'Naal Mistrunner',1752,1752,40,40,0,{[1638]={{50.99,52.45}}},nil,1638,nil,nil,104,"H","Cooking Supplier",6},
[3028] = {'Kah Mistrunner',2217,2217,45,45,0,{[1638]={{56.13,46.38}}},nil,1638,nil,nil,104,"H","Fishing Trainer",19},
[3029] = {'Sewa Mistrunner',1752,1752,40,40,0,{[1638]={{55.79,47.02}}},nil,1638,nil,nil,104,"H","Fishing Supplier",6},
[3030] = {'Siln Skychaser',2768,2768,50,50,0,{[1638]={{22.82,21.11}}},nil,1638,{8410},nil,104,"H","Shaman Trainer",19},
[3031] = {'Tigor Skychaser',1752,1752,40,40,0,{[1638]={{23.64,18.79}}},nil,1638,{8410},nil,104,"H","Shaman Trainer",19},
[3032] = {'Beram Skychaser',4120,4120,60,60,0,{[1638]={{21.99,18.8}}},nil,1638,{1523,8410},nil,104,"H","Shaman Trainer",19},
[3033] = {'Turak Runetotem',2768,2768,50,50,0,{[1638]={{76.48,27.22}}},nil,1638,{26,5922,6002,6126,9063},{31,5926,5927,5928,5932,6002,6130},104,"H","Druid Trainer",19},
[3034] = {'Sheal Runetotem',4120,4120,60,60,0,{[1638]={{77.14,27.02}}},nil,1638,{9063},nil,104,"H","Druid Trainer",19},
[3035] = {'Flatland Cougar',137,156,7,8,0,{[215]={{44.66,31.57},{45.97,30.55},{53.19,34.91},{52.05,37.28},{47.3,35.0},{54.51,35.33},{52.77,38.04},{56.81,36.28},{52.85,37.25},{55.74,35.64},{53.98,38.25},{53.91,35.94},{56.18,38.06},{52.1,35.54},{49.78,36.76},{59.44,53.49},{55.82,37.17},{55.88,39.45},{34.96,51.88},{55.51,43.12},{54.63,40.44},{49.39,37.59},{56.07,41.94},{34.44,42.65},{56.54,48.19},{53.4,40.7},{59.7,64.77},{53.14,40.17},{35.03,33.48},{48.05,43.12},{36.61,42.96},{34.46,32.72},{36.45,48.65},{62.69,51.58},{36.88,44.0},{40.85,38.15},{35.72,42.2},{57.1,62.8},{42.13,37.29},{57.61,49.45},{36.88,48.62},{45.61,38.14},{38.35,45.73},{59.65,54.59},{48.07,32.39},{54.1,41.89},{55.15,38.4},{52.09,33.16},{45.39,36.38},{43.91,52.2},{51.12,36.35},{48.16,35.22},{48.62,44.48},{50.42,34.05},{50.42,43.29},{37.42,39.3},{51.66,41.49},{59.44,58.4},{49.27,45.22},{58.99,58.07},{54.92,45.91},{47.3,36.41},{48.63,41.42},{46.67,36.4},{49.78,41.14},{58.66,52.65},{38.95,46.88},{57.28,63.83},{50.61,40.61},{57.29,49.08},{56.24,51.45},{41.97,49.95},{57.75,71.93},{39.62,46.01},{50.61,42.01},{57.03,72.23},{39.02,41.23},{45.18,47.37},{44.21,48.76},{33.65,25.6},{46.29,42.35},{54.43,47.04},{43.32,45.36},{47.33,40.25},{34.15,26.43},{50.5,39.34},{42.78,43.19},{38.07,39.87},{38.77,39.29}},[1638]={{24.67,71.26}}},nil,215,nil,nil,14,nil,nil,0},
[3036] = {'Kym Wildmane',1752,1752,40,40,0,{[1638]={{77.15,29.82}}},nil,1638,nil,nil,104,"H","Druid Trainer",19},
[3037] = {'Sheza Wildmane',1002,1002,30,30,0,{[1638]={{69.72,26.74}}},nil,1638,nil,nil,104,"H",nil,0},
[3038] = {'Kary Thunderhorn',2768,2768,50,50,0,{[1638]={{58.49,88.33}}},nil,1638,{6065,8151},nil,104,"H","Hunter Trainer",19},
[3039] = {'Holt Thunderhorn',4120,4120,60,60,0,{[1638]={{57.3,89.79}}},nil,1638,nil,{6089},104,"H","Hunter Trainer",19},
[3040] = {'Urek Thunderhorn',1752,1752,40,40,0,{[1638]={{59.13,86.87}}},nil,1638,nil,nil,104,"H","Hunter Trainer",19},
[3041] = {'Torm Ragetotem',2768,2768,50,50,0,{[1638]={{57.24,87.37}}},nil,1638,{1718,8417},nil,104,"H","Warrior Trainer",19},
[3042] = {'Sark Ragetotem',4120,4120,60,60,0,{[1638]={{56.99,89.51}}},nil,1638,nil,nil,104,"H","Warrior Trainer",19},
[3043] = {'Ker Ragetotem',1752,1752,40,40,0,{[1638]={{57.58,85.5}}},nil,1638,nil,nil,104,"H","Warrior Trainer",19},
[3044] = {'Miles Welsh',1752,1752,40,40,0,{[1638]={{25.32,15.27}}},nil,1638,{5642,5661},nil,68,"H","Priest Trainer",19},
[3045] = {'Malakai Cross',2768,2768,50,50,0,{[1638]={{24.56,22.57}}},nil,1638,{8254},nil,68,"H","Priest Trainer",19},
[3046] = {'Father Cobb',4120,4120,60,60,0,{[1638]={{25.64,20.7}}},nil,1638,{5646,8254},nil,68,"H","Priest Trainer",19},
[3047] = {'Archmage Shymm',4120,4120,60,60,0,{[1638]={{22.76,14.53}}},nil,1638,nil,nil,68,"H","Mage Trainer",19},
[3048] = {'Ursyn Ghull',1752,1752,40,40,0,{[1638]={{25.7,14.19}}},nil,1638,{2861},nil,68,"H","Mage Trainer",19},
[3049] = {'Thurston Xane',2768,2768,50,50,0,{[1638]={{25.18,20.96}}},nil,1638,{8250},nil,68,"H","Mage Trainer",19},
[3050] = {'Veren Tallstrider',531,531,21,21,0,{[1638]={{44.39,44.7}}},nil,1638,{768,769},{768,769},104,"H",nil,2},
[3051] = {'Supervisor Fizsprocket',247,247,12,12,0,{[215]={{64.9,43.31}}},nil,215,nil,nil,47,nil,nil,0},
[3052] = {'Skorn Whitecloud',531,531,21,21,0,{[215]={{46.75,60.23}}},nil,215,{861},{770},104,"H",nil,3},
[3053] = {'Synge',1002,1002,30,30,0,{[400]={{80.4,77.01}}},nil,400,nil,nil,35,"AH","Gun Merchant",16388},
[3054] = {'Zarlman Two-Moons',137,137,7,7,0,{[215]={{47.76,57.53}}},nil,215,{771,772},{767,771},104,"H",nil,2},
[3055] = {'Maur Raincaller',198,198,10,10,0,{[215]={{46.98,57.07}}},nil,215,{766},{766},104,"H",nil,2},
[3056] = {'Ghost Howl',247,247,12,12,4,{[215]={{33.17,25.24},{48.04,41.44},{47.55,14.76}}},{[215]={{{33.17,25.23},{33.15,24.93},{33.1,24.46},{33.06,24.17}},{{32.06,21.95},{31.91,21.62},{31.83,21.28},{31.84,20.94},{31.87,20.7},{31.92,20.42},{32.01,20.13},{32.2,19.79},{32.37,19.52},{32.56,19.28},{32.79,19.1},{32.98,18.95},{33.19,18.78}},{{37.24,17.24},{37.57,16.74},{37.8,16.13},{37.99,15.62},{38.14,15.2},{38.23,14.82},{38.26,14.67},{38.32,14.14},{38.46,13.39},{38.55,13.06},{38.67,12.69},{38.79,12.33},{38.81,11.95},{38.79,11.68},{38.72,11.25},{38.63,10.94},{38.47,10.48},{38.36,10.22},{38.21,9.89},{38.39,10.28},{38.56,10.78},{38.66,11.11},{38.77,11.58},{38.87,12.08},{38.91,12.47},{38.9,12.62},{38.83,13.13},{38.74,13.48},{38.6,13.77},{38.39,14.1},{38.18,14.41},{38.06,14.62},{37.86,15.3},{37.73,15.69},{37.54,16.13},{37.35,16.54},{37.18,16.81},{36.94,17.07},{36.69,17.24},{36.37,17.29},{36.18,17.3}},{{33.31,18.56},{33.14,18.7},{32.83,19.0},{32.68,19.17},{32.43,19.43},{32.26,19.64},{32.06,19.91},{31.87,20.21},{31.76,20.57},{31.75,20.84},{31.78,21.19},{31.86,21.52},{31.97,21.74},{32.07,22.0}},{{32.71,23.44}},{{33.13,24.28},{33.15,24.62},{33.16,25.11},{33.15,25.71},{33.08,26.11},{32.96,26.53},{32.82,26.92},{32.72,27.2},{32.61,27.51},{32.82,26.97},{32.93,26.62},{33.01,26.35},{33.12,25.88},{33.15,25.67}},{{47.21,41.04},{46.53,41.33},{45.85,41.73},{45.06,41.72},{44.57,41.55},{43.63,41.38},{42.84,41.64},{42.14,41.44},{41.42,41.89},{40.94,42.21},{40.42,42.37},{40.06,42.2},{39.45,41.87},{38.97,41.33},{38.23,41.35},{37.65,42.14},{36.83,42.07},{36.54,41.47},{36.2,40.3},{36.54,41.47},{36.83,42.07},{37.65,42.14},{38.23,41.35},{38.97,41.33},{39.45,41.87},{40.06,42.2},{40.42,42.37},{40.94,42.21},{41.42,41.89},{42.14,41.44},{42.84,41.64},{43.63,41.38},{44.57,41.55},{45.06,41.72},{45.85,41.73},{46.53,41.33},{47.2,41.04},{48.04,41.44}},{{47.55,14.76},{47.77,15.6},{47.96,15.95},{48.28,16.31},{48.64,16.44},{48.9,16.36},{49.37,16.21},{49.83,16.03},{50.1,15.84},{50.43,15.47},{50.61,15.15},{50.84,14.59},{50.94,14.12},{50.92,13.64},{50.68,12.94},{50.42,12.49},{50.09,12.05},{49.8,11.46},{49.45,10.93},{49.08,10.82},{48.67,11.21},{48.4,11.61},{48.17,12.03},{47.87,12.64},{47.7,13.14},{47.58,13.76},{47.51,14.31}}},[1638]={{{15.4,33.72},{14.85,32.26},{13.5,29.6},{12.88,28.42},{12.0,26.79}},{{17.57,8.82},{18.19,8.28},{19.44,7.0},{20.25,6.44},{21.71,5.6},{22.63,5.28},{24.0,4.34},{25.12,3.55},{25.85,3.15},{26.62,3.0},{28.07,2.99},{29.24,2.98},{29.86,2.97},{31.54,2.96},{32.99,2.94},{34.16,2.93},{35.32,2.67}},{{30.26,2.48},{29.05,2.8},{28.05,2.88},{26.49,3.01},{25.6,3.14},{24.81,3.56},{23.81,4.3},{23.02,4.94},{22.39,5.29},{20.63,6.09},{19.69,6.64},{18.72,7.3},{17.87,7.91}},{{11.99,27.56},{12.61,29.24},{12.91,30.05}},{{15.21,33.91},{15.89,35.26}}}},215,nil,nil,38,nil,nil,0},
[3057] = {'Cairne Bloodhoof',999300,999300,63,63,3,{[1638]={{60.3,51.68}}},nil,1638,{776},{775,776,7061},104,"H","High Chieftain",3},
[3058] = {'Arra\'chea',444,444,11,11,0,{[215]={{53.0,13.97}}},{[215]={{{53.12,14.24},{53.23,14.62},{53.23,14.62},{53.36,14.98},{53.48,15.34},{53.6,15.71},{53.72,16.07},{53.84,16.44},{53.84,16.44},{53.97,16.8},{54.09,17.17},{54.22,17.53},{54.31,17.89},{54.39,18.28},{54.49,18.84},{54.51,18.95},{54.53,19.25},{54.52,19.43},{54.49,19.83},{54.43,20.23},{54.39,20.64},{54.34,21.04},{54.29,21.44},{54.25,21.85},{54.21,22.25},{54.21,22.25},{54.17,22.65},{54.12,23.05},{54.07,23.46},{54.02,23.86},{53.97,24.26},{53.91,24.66},{53.79,25.46},{53.71,25.85},{53.63,26.24},{53.55,26.74},{53.6,27.12},{53.7,27.5},{53.83,27.86},{53.97,28.21},{54.28,28.88},{54.44,29.21},{54.67,29.72},{54.82,30.23},{54.89,30.6},{54.96,31.28},{54.95,31.57},{54.82,31.96},{54.55,32.38},{54.33,32.61},{54.15,32.73},{53.65,32.73},{53.41,32.55},{53.16,32.37},{52.93,32.16},{52.61,31.83},{52.39,31.41},{52.26,30.9},{52.27,30.44},{52.27,30.44},{52.31,29.62},{52.32,29.21},{52.32,28.53},{52.32,28.17},{52.26,27.38},{52.21,26.98},{52.16,26.58},{52.08,26.18},{51.94,25.4},{51.87,25.0},{51.8,24.6},{51.74,24.21},{51.61,23.41},{51.55,23.01},{51.51,22.61},{51.46,22.21},{51.34,21.49},{51.25,21.1},{51.15,20.72},{50.95,20.01},{50.74,19.76},{50.37,19.18},{50.31,19.05},{50.18,18.69},{49.94,17.96},{49.88,17.7},{49.72,17.36},{49.56,17.03},{49.43,16.4},{49.52,16.07},{49.79,15.51},{49.92,15.33},{50.14,15.08},{50.57,14.59},{50.79,14.34},{51.05,14.04},{51.17,13.57},{51.31,13.22},{51.68,12.5},{52.04,12.44},{52.34,12.68},{52.53,13.13},{52.72,13.42}}}},215,nil,nil,15,"AH",nil,0},
[3059] = {'Harutt Thunderhorn',198,198,10,10,0,{[215]={{44.01,76.13}}},nil,215,nil,{3091},104,"H","Warrior Trainer",19},
[3060] = {'Gart Mistrunner',176,176,9,9,0,{[215]={{45.09,75.93}}},nil,215,{5927},{3094},104,"H","Druid Trainer",19},
[3061] = {'Lanka Farshot',222,222,11,11,0,{[215]={{44.26,75.69}}},nil,215,{6066},{3092},104,"H","Hunter Trainer",19},
[3062] = {'Meela Dawnstrider',198,198,10,10,0,{[215]={{45.01,75.94}}},nil,215,nil,{3093},104,"H","Shaman Trainer",19},
[3063] = {'Krang Stonehoof',300,300,14,14,0,{[215]={{49.52,60.59}}},nil,215,{1505},nil,104,"H","Warrior Trainer",19},
[3064] = {'Gennia Runetotem',247,247,12,12,0,{[215]={{48.48,59.64}}},nil,215,{5926},nil,104,"H","Druid Trainer",19},
[3065] = {'Yaw Sharpmane',222,222,11,11,0,{[215]={{47.82,55.69}}},nil,215,{6061,6087,6088,6089},{6061,6065,6066,6067,6087,6088},104,"H","Hunter Trainer",19},
[3066] = {'Narm Skychaser',273,273,13,13,0,{[215]={{48.38,59.15}}},nil,215,{2984,2986},nil,104,"H","Shaman Trainer",19},
[3067] = {'Pyall Silentstride',247,247,12,12,0,{[215]={{45.41,58.11}}},nil,215,nil,nil,104,"H","Cook",19},
[3068] = {'Mazzranache',176,176,9,9,4,{[215]={{50.39,42.58}}},{[215]={{{50.58,42.31},{50.94,41.83},{51.38,41.14},{51.62,40.58},{51.68,39.91},{51.8,39.22},{51.9,38.63},{51.87,38.01},{51.66,37.31},{51.47,36.92},{51.27,36.79},{50.89,36.77},{50.36,36.89},{50.04,36.79},{49.72,36.49},{49.36,36.4},{48.96,36.53},{48.12,36.61},{47.62,36.74},{47.16,36.96},{46.76,37.15},{46.4,37.37},{45.95,37.77},{45.63,38.29},{45.28,38.67},{44.88,39.06},{44.47,39.36},{43.88,39.82},{43.33,40.15},{42.84,40.39},{42.33,40.44},{41.77,40.75},{41.35,41.14},{40.98,41.68},{40.79,42.24},{40.76,43.06},{40.84,43.79},{41.0,44.54},{41.23,44.93},{41.69,45.19},{42.05,45.23},{42.26,45.59},{42.39,46.08},{42.53,46.57},{42.8,46.87},{43.23,47.14},{43.69,47.2},{44.1,47.04},{44.62,46.82},{45.04,46.47},{45.4,46.08},{45.77,45.48},{46.06,45.03},{46.41,44.61},{46.79,44.08},{47.22,43.33},{47.69,42.99},{48.11,42.86},{48.67,42.36},{48.85,41.86},{49.21,41.71},{49.75,41.95},{50.15,42.53},{50.42,42.59}}}},215,nil,nil,14,nil,nil,0},
[3069] = {'Chaw Stronghide',617,617,23,23,0,{[215]={{45.44,57.86}}},nil,215,nil,nil,104,"H","Journeyman Leatherworker",19},
[3072] = {'Kawnie Softbreeze',156,156,8,8,0,{[215]={{45.3,76.52}}},nil,215,nil,nil,104,"H","General Goods",6},
[3073] = {'Marjak Keenblade',176,176,9,9,0,{[215]={{44.06,77.47}}},nil,215,nil,nil,104,"H","Weaponsmith",16388},
[3074] = {'Varia Hardhide',137,137,7,7,0,{[215]={{44.14,77.25}}},nil,215,nil,nil,104,"H","Leather Armor Merchant",16388},
[3075] = {'Bronk Steelrage',198,198,10,10,0,{[215]={{44.21,77.5}}},nil,215,nil,nil,104,"H","Armorer and Shieldcrafter",16388},
[3076] = {'Moorat Longstride',247,247,12,12,0,{[215]={{45.86,57.66}}},nil,215,nil,nil,104,"H","General Goods",6},
[3077] = {'Mahnott Roughwound',222,222,11,11,0,{[215]={{45.66,58.6}}},nil,215,nil,nil,104,"H","Weaponsmith",16388},
[3078] = {'Kennah Hawkseye',273,273,13,13,0,{[215]={{45.49,58.47}}},nil,215,nil,nil,104,"H","Gunsmith",16388},
[3079] = {'Varg Windwhisper',300,300,14,14,0,{[215]={{45.82,58.7}}},nil,215,nil,nil,104,"H","Leather Armor Merchant",16389},
[3080] = {'Harant Ironbrace',222,222,11,11,0,{[215]={{45.9,58.73}}},nil,215,nil,nil,104,"H","Armorer and Shieldcrafter",16388},
[3081] = {'Wunna Darkmane',198,198,10,10,0,{[215]={{46.18,58.18}}},nil,215,nil,nil,104,"H","Trade Goods",6},
[3083] = {'Honor Guard',6104,6104,60,60,0,{[1638]={{59.76,52.26},{61.69,50.78},{59.83,51.08},{51.36,51.31},{61.6,52.82},{61.14,55.05}}},nil,1638,nil,nil,105,"H",nil,2},
[3084] = {'Bluffwatcher',5228,5228,55,55,0,{[1638]={{50.62,37.78},{72.05,30.17},{58.59,55.33},{45.12,61.32},{37.39,60.95},{59.1,78.55},{31.01,29.46},{58.05,47.12},{36.97,50.58},{43.3,38.63},{27.98,18.9},{43.12,40.01},{44.37,61.71},{30.53,31.05},{35.66,63.09},{44.32,39.61},{57.74,55.94},{40.18,62.7},{51.18,31.51},{58.81,47.89},{50.44,36.45},{36.28,51.51}}},nil,1638,nil,nil,105,"H",nil,1},
[3085] = {'Gloria Femmel',484,484,20,20,0,{[44]={{26.64,43.48}}},nil,44,nil,nil,12,"A","Cooking Supplies",4},
[3086] = {'Gretchen Vogel',484,484,20,20,0,{[44]={{22.84,44.26}}},nil,44,nil,nil,12,"A","Waitress",4},
[3087] = {'Crystal Boughman',573,573,22,22,0,{[44]={{22.78,43.47}}},nil,44,nil,nil,12,"A","Cooking Trainer",17},
[3088] = {'Henry Chapal',712,712,25,25,0,{[44]={{23.84,41.32}}},nil,44,nil,nil,12,"A","Gunsmith",16388},
[3089] = {'Sherman Femmel',531,531,21,21,0,{[44]={{26.73,43.24}}},nil,44,nil,nil,12,"A","Butcher",4},
[3090] = {'Gerald Crawley',712,712,25,25,0,{[44]={{25.09,41.14}}},nil,44,nil,nil,12,"A","Poison Supplier",4},
[3091] = {'Franklin Hamar',787,787,26,26,0,{[44]={{27.18,45.54}}},nil,44,nil,nil,12,"A","Tailoring Supplies",4},
[3092] = {'Tagain',1002,1002,30,30,0,{[1638]={{43.44,44.34}}},nil,1638,nil,nil,104,"H","Cloth Armor Merchant",16388},
[3093] = {'Grod',1002,1002,30,30,0,{[1638]={{42.66,43.51}}},nil,1638,nil,nil,104,"H","Leather Armor Merchant",16388},
[3094] = {'Unseen',2138,2292,49,51,0,{[10]={{18.06,54.34},{17.53,54.79},{19.23,55.04},{66.44,76.67},{55.14,60.21},{54.39,59.23},{53.69,60.55},{52.11,62.25},{51.79,61.46},{14.34,67.07},{21.34,57.25},{18.13,57.94},{17.38,56.38},{17.98,54.71},{18.12,54.34},{21.12,55.5},{66.2,76.4},{65.53,67.84},{66.02,69.3},{65.26,67.68},{65.56,67.39},{54.41,60.1},{53.7,61.86},{19.22,53.39},{19.21,53.76},{77.47,36.22},{78.54,35.04},{78.64,36.22}}},nil,10,nil,nil,15,"AH",nil,0},
[3095] = {'Fela',1002,1002,30,30,0,{[1638]={{42.75,44.8}}},nil,1638,nil,nil,104,"H","Heavy Armor Merchant",16388},
[3096] = {'Captured Servant of Azora',573,573,22,22,0,{[44]={{74.46,79.51}}},nil,44,nil,nil,35,"AH","Specialist Tailoring Supplies",6},
[3097] = {'Bernard Brubaker',484,484,20,20,0,{[44]={{88.25,71.02}}},nil,44,nil,nil,12,"A","Leather Armor Merchant",16388},
[3098] = {'Mottled Boar',42,55,1,2,0,{[14]={{45.16,70.47},{46.5,66.88},{45.75,65.07},{43.92,70.62},{41.97,72.5},{46.52,64.15},{44.49,61.94},{47.12,65.09},{41.27,65.1},{44.44,61.54},{43.36,72.42},{43.46,61.07},{42.55,61.19},{41.99,64.86},{42.72,71.58},{43.89,62.4},{41.39,71.64},{44.54,70.61},{42.69,72.72},{46.32,62.96},{41.98,64.17},{42.09,71.91},{43.95,71.58},{43.86,60.31},{45.81,67.06},{47.01,68.68},{46.37,65.9},{46.43,68.78},{43.38,62.12},{45.22,69.66},{44.03,61.12},{44.59,71.61},{43.87,72.57},{45.77,68.87},{45.18,66.93},{43.14,60.32},{44.53,60.36},{43.36,64.81},{44.64,59.27},{45.81,61.28},{45.23,60.39},{45.0,63.07},{45.63,62.36},{43.07,64.02},{44.57,63.23},{43.2,63.23},{45.67,65.76},{43.84,64.91},{43.85,64.25},{45.27,63.99},{45.2,65.16},{45.06,65.89},{42.58,65.12},{43.96,65.96},{44.49,65.1},{44.47,64.07},{45.19,62.23},{45.77,63.0},{43.78,63.06},{42.65,60.06},{42.1,63.09},{41.98,62.14},{44.49,66.03},{42.02,61.21}}},nil,14,nil,nil,189,"AH",nil,0},
[3099] = {'Dire Mottled Boar',120,137,6,7,0,{[14]={{52.03,49.96},{54.2,30.65},{53.82,49.83},{51.52,63.73},{58.36,41.55},{38.96,37.84},{47.6,44.5},{42.61,32.91},{54.42,37.99},{51.21,49.42},{41.99,31.52},{47.66,43.4},{48.3,45.89},{52.01,61.69},{51.68,53.58},{51.64,72.46},{39.96,47.75},{52.59,57.07},{57.93,46.8},{43.72,46.42},{54.58,67.44},{44.42,34.63},{40.0,47.37},{56.16,39.64},{52.23,62.96},{57.36,44.38},{47.0,42.76},{42.93,50.12},{53.17,36.8},{47.24,38.32},{43.95,43.3},{42.72,46.02},{53.36,32.77},{45.98,34.91},{56.02,38.99},{46.7,44.68},{53.52,34.98},{40.67,40.66},{55.36,32.76},{53.53,68.1},{54.53,57.38},{42.88,43.25},{56.22,41.31},{50.74,55.9},{40.21,48.99},{41.07,36.82},{51.52,34.13},{45.02,43.46},{55.83,35.36},{50.9,34.69},{52.72,65.0},{53.92,31.63},{43.11,43.96},{55.24,40.32},{52.38,56.59},{44.56,37.08},{40.69,50.77},{53.85,59.12},{49.5,34.84},{38.93,47.06},{51.1,33.11},{41.1,44.92},{52.23,60.72},{43.79,33.98},{54.58,34.67},{42.09,44.25},{53.16,58.62},{45.38,48.59},{45.97,48.27},{51.71,46.04},{50.67,36.66},{40.77,44.86},{53.07,31.31},{56.54,36.71},{51.72,59.03},{55.37,39.58},{51.89,66.94},{39.4,36.54},{55.65,58.74},{40.45,32.76},{51.38,37.64},{46.18,44.38},{38.62,44.95},{45.22,41.27},{45.74,44.59},{51.54,62.09},{54.53,38.74},{48.22,40.19},{50.77,53.86},{55.72,56.23},{42.03,47.14},{46.21,39.14},{51.6,65.4},{54.39,35.86},{51.71,65.87},{53.9,56.22},{48.3,36.66},{46.94,46.29},{55.38,43.96},{42.81,47.68},{54.08,70.77},{38.11,35.87},{51.04,51.81},{45.65,38.32},{50.46,71.78},{51.22,56.73},{54.21,53.06},{41.65,50.35},{53.3,48.79},{55.25,56.98},{53.43,46.16},{52.21,47.86},{51.75,78.12},{53.91,62.59},{50.46,75.0},{49.57,73.7}}},nil,14,nil,nil,189,"AH",nil,0},
[3100] = {'Elder Mottled Boar',156,176,8,9,0,{[14]={{50.92,15.57},{44.59,25.24},{38.04,48.47},{37.51,54.6},{36.91,44.89},{57.75,24.52},{55.1,10.99},{36.25,49.22},{36.42,55.46},{53.65,16.8},{43.98,15.26},{45.98,19.42},{43.32,18.09},{45.86,15.53},{44.92,16.2},{37.65,45.18},{35.55,45.56},{55.15,18.64},{43.92,26.26},{57.05,17.77},{37.2,26.37},{44.64,27.04},{36.87,48.25},{55.45,16.11},{36.16,24.25},{39.55,44.31},{58.39,27.29},{35.56,39.36},{38.26,42.11},{37.03,31.73},{35.03,46.47},{55.25,20.45},{47.91,20.44},{36.34,38.85},{35.7,47.04},{51.56,13.21},{44.64,21.17},{50.15,14.79},{38.57,44.32},{39.42,17.64},{55.96,21.7},{37.55,55.64},{53.9,9.28},{52.51,15.86},{35.93,34.94},{52.93,14.18},{47.11,20.17},{42.37,18.49},{52.93,17.52},{43.15,27.92},{56.49,13.19},{41.9,16.72},{37.21,19.0},{48.28,15.83},{37.13,41.35},{48.56,20.69},{40.14,33.78},{39.55,18.73},{55.16,28.12},{39.57,49.49},{54.6,28.78},{44.46,23.3},{37.78,55.77},{40.68,42.48},{36.18,31.92},{54.77,19.37},{42.6,22.33},{51.63,16.66},{56.89,28.36},{37.67,29.98},{36.05,26.01},{42.65,21.47},{54.52,11.02},{52.21,14.79},{40.18,21.79},{35.14,49.34},{42.05,22.77},{43.94,21.54},{57.03,29.76},{39.33,19.62},{35.45,55.66},{37.0,28.07},{55.19,14.02},{40.13,17.05},{40.48,21.57},{57.68,20.25},{45.99,22.22},{56.88,24.6},{36.89,46.12},{45.36,27.33},{51.81,11.83},{59.05,24.24},{38.73,21.21},{37.13,52.39},{54.26,17.42},{55.58,12.93},{42.76,28.28},{53.4,13.05},{45.41,25.07},{57.51,18.55},{56.96,23.38},{57.14,19.33},{38.26,28.87},{35.66,30.98},{47.7,12.7},{54.02,18.93},{38.52,48.86},{56.15,17.04},{43.23,21.45},{55.8,9.98},{39.43,51.67},{42.69,17.58},{47.83,18.43},{44.78,22.31},{36.45,38.54},{38.61,33.71},{50.2,12.9},{57.68,22.48},{46.34,17.91},{43.93,22.39},{36.3,35.73},{44.69,17.76},{45.14,18.58},{45.49,16.63},{44.54,19.55},{34.99,43.25},{54.63,15.76},{44.95,17.67},{44.15,17.32},{43.19,16.93},{45.23,16.73},{45.74,15.74},{43.81,15.55}}},nil,14,nil,nil,189,"AH",nil,0},
[3101] = {'Vile Familiar',69,83,3,4,0,{[14]={{46.16,56.07},{42.76,52.71},{42.65,54.63},{43.71,55.47},{43.91,53.55},{43.8,55.6},{42.99,53.56},{44.45,52.66},{44.24,55.26},{42.81,52.53},{43.45,55.54},{43.22,54.32},{43.94,54.27},{43.57,53.47},{43.89,55.29},{43.72,52.54},{44.11,53.95},{46.16,56.79},{46.47,57.28},{47.01,57.28},{43.92,53.81},{43.82,58.29},{44.51,58.49},{45.02,58.24},{44.39,57.2},{42.75,52.7},{44.13,57.0},{44.74,53.76},{45.33,55.86},{45.66,56.84},{45.15,55.07},{45.36,56.32},{44.59,56.02},{45.19,57.3},{44.85,56.92},{45.76,57.35},{45.75,58.48}}},nil,14,nil,nil,14,nil,nil,0},
[3102] = {'Felstalker',72,86,3,4,0,{[14]={{42.97,52.1},{43.83,54.86},{44.82,52.48},{44.12,52.87},{43.01,55.34},{43.26,53.85},{44.49,54.93},{42.43,54.18},{42.52,53.5},{44.29,54.19},{44.85,53.11},{44.83,52.55},{43.55,52.14},{44.75,54.54},{45.54,55.34},{45.3,55.7}}},nil,14,nil,nil,14,nil,nil,0},
[3103] = {'Makrura Clacker',120,137,6,7,0,{[14]={{65.22,49.82},{62.2,92.51},{70.35,85.92},{69.69,77.26},{70.49,82.28},{61.77,80.37},{64.01,55.43},{70.75,75.24},{69.92,88.75},{60.92,96.33},{63.5,60.12},{62.96,56.37},{59.15,91.5},{59.06,87.64},{59.69,72.41},{58.96,82.14},{68.69,77.17},{61.04,77.34},{64.65,48.77},{65.25,51.53},{63.51,50.79},{61.06,72.51},{62.1,68.87},{63.41,58.48},{67.3,77.22},{61.56,42.98},{64.67,54.85},{62.83,43.03},{71.68,72.62},{65.51,53.96},{62.13,40.54},{64.63,77.16},{62.84,45.05},{62.79,61.11},{62.19,67.05},{59.54,86.96},{52.68,84.9},{61.59,50.89},{51.41,84.88},{57.34,80.02},{62.74,47.01}}},nil,14,nil,nil,129,nil,nil,0},
[3104] = {'Makrura Shellhide',120,137,6,7,0,{[14]={{53.89,84.83},{60.28,73.5},{61.44,44.81},{61.07,42.55},{62.14,49.73},{65.89,73.62},{61.47,54.35},{64.78,50.89},{63.97,57.62},{66.64,78.12},{63.44,73.81},{58.2,85.15},{63.45,55.76},{60.91,40.44},{61.48,48.76},{65.74,71.74},{61.45,69.7},{61.02,84.65},{60.22,75.74},{55.08,82.85},{60.31,71.58}}},nil,14,nil,nil,129,nil,nil,0},
[3105] = {'Makrura Snapclaw',156,176,8,9,0,{[14]={{60.36,26.41},{60.35,17.25},{59.84,28.91},{57.53,9.39},{58.48,10.21},{58.82,15.11},{60.23,29.95},{60.44,18.49},{60.28,20.69}}},nil,14,nil,nil,129,nil,nil,0},
[3106] = {'Pygmy Surf Crawler',102,120,5,6,0,{[14]={{63.77,54.64},{63.37,61.03},{62.47,43.99},{66.02,53.46},{63.45,45.33},{63.1,47.99},{62.91,54.95},{62.67,58.23},{59.77,73.58},{61.7,53.46},{58.19,78.81},{54.5,82.97},{60.96,50.13},{63.19,44.24},{61.18,48.02},{61.32,61.76},{65.9,50.9},{63.23,54.72},{64.86,54.99},{62.78,51.59},{60.31,45.12},{60.96,52.3},{60.95,69.94},{65.45,49.32},{61.48,39.51},{64.06,47.16},{60.34,43.27},{62.73,62.55},{63.94,57.16},{53.43,82.95},{52.7,83.04},{52.13,83.97},{60.94,43.83},{53.92,83.01},{52.22,83.11},{51.53,84.03},{55.37,79.94},{55.84,80.27},{54.67,83.95},{55.21,81.75},{56.52,79.12},{57.21,79.25},{57.18,78.05},{62.82,48.95},{64.12,48.79},{56.44,80.11},{60.33,49.02},{54.63,82.0},{55.94,79.3},{60.34,47.05},{54.04,82.18}}},nil,14,nil,nil,7,"AH",nil,0},
[3107] = {'Surf Crawler',137,156,7,8,0,{[14]={{66.06,79.39},{58.85,28.34},{63.15,74.03},{63.4,92.82},{66.35,72.89},{63.15,93.2},{67.04,76.41},{62.85,81.35},{62.72,76.07},{66.19,70.78},{61.89,94.94},{67.97,78.58},{60.18,22.79},{70.47,75.93},{69.72,78.79},{59.96,25.28},{71.12,71.47},{64.57,94.18},{66.99,90.78},{60.27,24.69},{60.2,85.79},{70.98,73.95},{60.91,17.71},{65.17,93.35},{64.15,78.85},{63.9,89.03},{63.64,76.99},{58.89,86.2},{62.1,79.33},{59.89,27.17},{63.65,93.2},{64.64,96.5},{60.29,92.26},{68.99,76.25},{65.07,89.87},{67.26,75.49},{64.11,72.16},{58.28,83.54},{62.1,76.63},{65.94,91.47},{66.09,69.96},{63.3,97.99},{70.45,80.1},{60.99,86.75},{61.54,87.39},{61.44,82.12},{69.55,87.53},{62.07,90.54},{67.89,68.73},{60.81,25.39},{70.52,68.99},{65.49,74.64},{69.27,78.26},{64.6,98.24},{59.78,23.62},{62.08,80.94},{65.93,75.63},{59.63,81.31},{65.13,72.59}}},nil,14,nil,nil,7,"AH",nil,0},
[3108] = {'Encrusted Surf Crawler',176,198,9,10,0,{[14]={{57.87,15.22},{56.94,10.16},{58.44,15.68},{56.3,11.08},{58.29,13.76},{57.18,12.31},{57.9,8.42},{56.54,9.11},{59.13,16.62},{57.75,13.15},{57.81,11.4},{58.12,12.04}}},nil,14,nil,nil,7,"AH",nil,0},
[3110] = {'Dreadmaw Crocolisk',176,222,9,11,0,{[14]={{34.98,26.13},{35.24,30.11},{34.83,54.32},{34.52,53.77},{35.24,24.62},{35.08,39.22},{35.62,57.26},{35.29,28.31},{35.27,56.23},{36.48,22.22},{35.7,25.31},{34.33,48.13},{36.82,22.1},{34.48,44.27},{34.64,52.09},{34.14,46.04},{36.42,61.19},{37.44,66.05},{36.48,61.09},{36.78,17.21},{37.06,15.81},{37.65,68.12},{36.86,62.22},{34.38,44.17},{35.76,57.39}},[17]={{63.16,15.2},{63.26,13.95},{63.04,23.09},{63.36,11.25},{62.78,20.7},{62.93,21.73},{62.84,23.81},{63.88,27.93},{63.29,12.22},{62.87,24.49},{64.2,8.02},{63.88,9.32},{63.18,16.48},{63.21,13.94},{63.29,11.28},{63.07,15.29},{64.98,33.53},{63.18,10.53},{63.78,8.34},{62.69,15.48},{62.88,20.89},{65.33,34.42},{63.2,26.03},{62.72,23.68}}},nil,14,nil,nil,14,nil,nil,0},
[3111] = {'Razormane Quilboar',120,137,6,7,0,{[14]={{50.21,50.78},{46.22,49.02},{46.98,48.14},{47.39,49.33},{49.08,48.67},{49.57,47.65},{47.59,49.65},{47.54,48.6},{47.21,48.67},{48.98,48.26},{50.7,48.95},{50.33,49.07},{48.91,48.75},{48.82,48.88},{49.37,48.16}}},nil,14,nil,nil,109,nil,nil,0},
[3112] = {'Razormane Scout',137,156,7,8,0,{[14]={{44.05,49.65},{47.22,47.96},{47.13,49.54},{47.39,49.85},{44.03,50.33},{44.44,50.04},{43.29,50.76},{44.87,50.42},{44.18,49.6},{44.49,50.67},{43.65,50.24},{49.84,49.3},{50.06,49.33},{49.37,48.68},{49.18,49.09},{49.55,47.77},{47.56,47.85},{50.15,49.81}}},nil,14,nil,nil,109,nil,nil,0},
[3113] = {'Razormane Dustrunner',148,166,8,9,0,{[14]={{38.86,52.79},{39.02,53.74},{38.15,52.94},{39.3,52.92},{39.53,53.24},{43.38,37.29},{44.18,38.22},{44.09,37.54},{43.29,39.05},{41.73,38.55},{42.87,38.82},{41.76,37.24},{41.33,37.58},{44.0,39.76},{43.88,40.5},{43.14,39.58},{42.86,39.26}}},nil,14,nil,nil,109,nil,nil,0},
[3114] = {'Razormane Battleguard',176,198,9,10,0,{[14]={{38.77,53.52},{38.26,54.66},{39.4,53.78},{38.25,53.96},{38.72,55.19},{42.74,37.37},{43.7,38.15},{41.93,38.87},{41.74,38.2},{39.1,52.96},{44.12,39.23},{44.65,37.34},{44.48,39.64},{42.54,38.9},{42.27,39.37},{43.06,38.89},{41.86,40.31},{42.97,38.17},{45.13,37.55},{42.24,37.24},{42.89,41.58},{42.72,40.35},{42.61,39.18},{43.88,41.42},{43.24,40.5}}},nil,14,nil,nil,109,nil,nil,0},
[3115] = {'Dustwind Harpy',137,156,7,8,0,{[14]={{45.85,33.84},{50.57,26.02},{44.99,29.02},{47.72,33.1},{49.14,22.17},{45.03,32.77},{48.16,33.01},{45.86,30.07},{48.19,32.05},{45.22,30.97},{48.67,32.32},{48.09,31.52},{47.74,31.12},{49.96,27.56},{49.88,32.52},{50.15,25.11}}},nil,14,nil,nil,514,nil,nil,0},
[3116] = {'Dustwind Pillager',137,156,7,8,0,{[14]={{47.21,29.64},{49.05,21.29},{48.92,20.61},{48.42,20.74},{48.34,31.65},{47.72,30.23},{47.12,30.13},{46.5,30.2},{46.77,30.4},{47.44,30.58},{51.35,27.29},{48.83,19.5},{50.51,26.71}}},nil,14,nil,nil,514,nil,nil,0},
[3117] = {'Dustwind Savage',176,198,9,10,0,{[14]={{51.82,23.82},{52.39,23.92},{52.81,24.29},{54.06,24.47},{52.75,21.35},{54.03,23.56},{52.12,20.77},{53.87,25.04},{54.07,27.33},{53.91,22.7},{53.92,27.84},{53.69,21.89},{53.96,26.32},{53.32,24.76},{51.43,20.86}}},nil,14,nil,nil,514,nil,nil,0},
[3118] = {'Dustwind Storm Witch',186,208,10,11,0,{[14]={{51.56,21.65},{51.36,23.07},{52.02,20.07},{51.87,23.53},{51.53,23.39},{50.97,19.56},{51.34,23.63},{53.01,23.86},{53.35,23.75},{51.22,23.25},{54.11,22.35},{53.26,21.63},{52.01,21.41},{51.74,19.99},{51.27,19.19},{51.57,19.03},{51.34,20.19},{53.13,24.25}}},nil,14,nil,nil,514,nil,nil,0},
[3119] = {'Kolkar Drudge',120,137,6,7,0,{[14]={{51.33,79.31},{52.26,80.21},{48.11,80.49},{48.1,77.65},{49.89,80.03},{46.71,80.54},{48.21,79.99},{50.04,78.52},{46.44,79.52},{52.03,76.48},{49.67,80.45},{53.04,79.83},{52.63,81.21},{49.02,79.65},{48.06,79.24},{50.15,79.23},{47.64,78.65},{52.08,82.03},{52.7,77.29}}},nil,14,nil,nil,130,nil,nil,0},
[3120] = {'Kolkar Outrunner',131,148,7,8,0,{[14]={{47.77,77.68},{49.83,81.36},{46.59,79.19},{50.07,80.53},{46.29,79.3},{47.64,78.1},{48.07,78.44}}},nil,14,nil,nil,130,nil,nil,0},
[3121] = {'Durotar Tiger',137,156,7,8,0,{[14]={{64.08,95.36},{63.25,96.25},{69.02,72.42},{62.89,97.1},{69.15,69.69},{69.08,80.32},{64.7,81.0},{64.63,88.53},{70.31,73.44},{69.76,72.79},{67.21,70.71},{63.99,97.29},{59.0,90.55},{65.27,80.24},{69.23,73.68},{62.41,95.17},{69.14,84.83},{67.67,73.8},{64.64,84.97},{65.89,81.27},{65.31,87.79},{60.18,80.02},{60.68,82.3},{59.62,84.72},{59.83,83.29},{60.85,88.75},{61.52,89.61},{60.96,90.57},{61.43,91.33},{60.33,91.39}}},nil,14,nil,nil,14,nil,nil,0},
[3122] = {'Bloodtalon Taillasher',120,156,6,8,0,{[14]={{45.78,36.57},{46.3,37.64},{42.26,49.09},{54.38,32.46},{49.36,19.23},{56.55,24.0},{40.26,47.73},{42.34,34.4},{56.09,29.25},{39.49,51.86},{66.72,88.98},{67.22,80.52},{59.89,88.04},{62.03,96.29},{69.8,74.67},{70.23,70.92},{68.43,83.87},{57.02,24.45},{39.21,47.05},{40.5,46.56},{48.9,36.88},{43.3,46.53},{50.44,35.36},{55.3,30.51},{57.62,28.52},{44.22,45.38},{58.22,26.34},{68.51,87.08},{63.87,83.76},{68.89,71.09},{68.64,74.7},{57.98,23.13},{47.61,36.79},{54.9,34.47},{41.18,50.33},{40.51,38.2},{40.73,34.77},{55.31,37.29},{49.8,37.0},{56.87,26.77},{44.45,33.97},{69.79,70.42},{64.89,82.32},{69.22,82.07},{68.29,71.78},{63.98,86.81},{64.59,73.33},{67.16,71.23},{44.18,33.61},{63.09,94.42},{68.07,80.52},{63.49,74.51},{67.74,69.83},{68.18,88.51},{60.26,82.64},{41.6,47.01},{61.42,78.12},{59.39,83.88},{59.85,89.59},{60.93,78.81}}},nil,14,nil,nil,48,nil,nil,0},
[3123] = {'Bloodtalon Scythemaw',156,198,8,10,0,{[14]={{38.46,37.37},{35.85,48.92},{36.29,27.66},{54.87,19.28},{36.06,53.24},{55.22,13.14},{55.77,12.0},{52.97,12.44},{37.01,46.39},{38.35,48.89},{37.52,32.42},{37.19,54.92},{40.44,16.07},{54.44,17.98},{39.2,19.07},{37.49,36.13},{37.09,47.28},{54.05,11.74},{56.95,15.0},{52.11,10.62},{37.94,40.0},{42.85,18.53},{36.75,34.26},{53.22,16.03},{39.27,17.09},{36.01,31.77},{36.75,27.15},{55.86,15.85},{36.89,29.65},{51.83,14.52},{36.76,25.43},{42.08,21.33},{53.93,13.46},{36.03,37.04},{36.63,39.1},{39.18,19.51}}},nil,14,nil,nil,48,nil,nil,0},
[3124] = {'Scorpid Worker',71,71,3,3,0,{[14]={{40.91,62.03},{43.14,56.43},{46.81,59.95},{41.5,65.86},{41.96,58.36},{47.73,64.01},{45.21,72.75},{47.04,62.1},{40.1,67.84},{43.2,59.53},{43.31,58.35},{40.12,68.62},{47.14,63.05},{46.41,59.32},{46.38,60.11},{43.95,73.67},{47.22,64.02},{39.99,66.02},{40.74,66.75},{46.5,61.35},{39.39,61.13},{40.7,70.5},{41.29,70.6},{40.7,67.74},{40.75,65.76},{45.09,71.37},{47.1,61.32},{41.77,57.33},{43.2,73.64},{41.4,67.91},{42.83,58.45},{41.34,66.8},{41.83,65.81},{40.06,66.87},{40.67,68.52},{45.6,58.71},{41.44,60.39},{40.67,61.23},{40.05,63.42},{39.59,63.08},{40.1,64.01},{40.82,62.94},{42.59,59.23},{39.97,61.39},{39.51,62.27},{40.22,62.07},{43.96,59.47},{41.49,64.27},{40.78,64.04},{41.37,63.37},{41.37,62.06},{41.42,61.36},{45.84,59.36},{45.21,59.35},{45.79,60.14}}},nil,14,nil,nil,7,"AH",nil,0},
[3125] = {'Clattering Scorpid',102,120,5,6,0,{[14]={{56.87,45.7},{57.82,45.95},{57.21,70.82},{54.75,59.36},{50.23,75.36},{54.53,61.06},{55.63,70.11},{57.2,42.66},{57.81,42.94},{59.05,44.7},{56.64,70.92},{52.62,72.47},{54.12,65.1},{58.31,70.84},{53.84,68.09},{52.05,73.61},{50.93,70.61},{58.54,44.58},{51.88,73.46},{57.76,41.49},{56.93,45.33},{50.97,54.22},{59.69,42.03},{58.84,50.51},{59.75,48.06},{52.24,73.67},{55.97,49.09},{57.02,48.33},{59.76,44.36},{58.18,72.05},{54.42,67.01},{49.55,72.9},{54.76,69.98},{54.11,68.97},{58.26,42.26},{57.66,46.8},{55.47,68.0},{50.61,74.91},{54.69,63.57},{54.51,56.65},{49.46,74.67},{52.11,62.82},{54.4,64.87},{50.14,71.89},{54.37,68.96},{59.56,45.92},{59.01,43.23},{56.09,69.64},{51.95,54.74},{57.77,49.45},{53.92,50.75},{57.71,71.34},{56.46,43.17},{57.11,44.18},{50.82,72.5},{50.09,73.47},{54.03,55.23},{53.43,53.54},{53.95,49.03},{56.13,70.53},{53.25,67.03},{55.91,47.53},{53.09,51.81},{55.84,44.23},{54.73,50.13},{53.32,74.44},{54.05,64.11},{54.77,80.27},{55.22,45.38},{52.91,60.6},{53.32,76.44}}},nil,14,nil,nil,413,nil,nil,0},
[3126] = {'Armored Scorpid',137,156,7,8,0,{[14]={{43.37,32.43},{35.73,37.91},{55.72,31.68},{41.11,51.69},{36.99,37.25},{48.92,36.82},{37.07,34.4},{41.93,28.75},{44.45,33.61},{43.69,45.5},{56.1,22.8},{42.5,34.41},{38.97,35.72},{41.08,48.38},{52.84,19.35},{46.84,35.53},{54.93,23.07},{38.25,40.76},{37.93,46.49},{56.47,21.36},{38.3,33.89},{57.56,30.9},{50.65,21.56},{44.57,45.72},{48.57,30.56},{49.3,36.65},{56.55,29.04},{36.23,36.86},{47.55,36.87},{41.04,46.56},{51.1,17.81},{55.04,22.07},{57.19,27.37},{47.57,35.62},{54.41,33.83},{40.23,39.44},{36.31,41.19},{41.4,41.42},{57.41,29.52},{57.16,24.58},{45.63,46.74},{35.74,36.87},{37.26,33.85},{58.49,29.18},{42.52,48.65},{58.44,23.26},{50.99,37.7},{40.67,38.82},{41.4,50.69},{37.67,42.46},{54.76,36.64},{45.28,26.55},{50.49,19.5},{44.56,44.54},{43.34,48.1},{39.22,42.14},{42.58,45.86},{45.52,31.35},{45.23,28.21},{58.36,25.17},{40.07,45.27},{39.62,47.8},{48.34,38.62}}},nil,14,nil,nil,413,nil,nil,0},
[3127] = {'Venomtail Scorpid',176,198,9,10,0,{[14]={{56.89,14.59},{42.55,21.11},{36.22,28.43},{38.95,17.74},{35.3,53.6},{36.33,47.24},{36.83,27.03},{55.66,14.8},{42.11,18.77},{35.02,50.77},{35.7,47.05},{42.01,16.99},{37.55,50.64},{42.0,20.62},{37.11,30.96},{38.79,22.56},{44.9,20.48},{53.34,11.85},{36.78,55.7},{37.93,49.89},{43.58,18.23},{44.08,16.74},{56.0,18.33},{39.82,18.39},{54.39,11.75},{36.61,25.14},{50.36,17.65},{36.67,50.49},{36.32,52.59},{36.8,53.84},{53.62,12.69},{35.48,33.09},{41.43,20.07},{36.97,48.89},{36.51,30.24},{35.81,49.82},{38.15,20.21},{41.02,16.92},{39.43,22.05},{35.94,56.6},{53.54,15.65},{55.88,15.25},{38.85,17.67},{49.72,17.51},{55.89,12.09},{43.87,18.68},{43.94,18.38},{43.89,16.97}}},nil,14,nil,nil,413,nil,nil,0},
[3128] = {'Kul Tiras Sailor',102,120,5,6,0,{[14]={{61.01,58.75},{55.92,59.05},{60.22,59.18},{57.11,53.12},{56.72,52.76},{55.72,57.54},{58.77,60.16},{56.72,53.14},{56.36,56.47},{56.61,52.97},{56.41,58.48},{56.66,54.94},{57.11,57.24},{57.65,58.54},{55.95,53.78},{57.8,58.66},{57.22,54.7},{57.39,56.76},{57.38,58.22},{57.92,57.21},{57.12,51.52},{55.88,51.84},{58.98,52.66},{58.19,56.79},{57.82,52.64},{58.45,53.74},{59.84,58.95},{58.51,57.5},{59.38,58.94},{59.77,58.06}}},nil,14,nil,nil,123,"A",nil,0},
[3129] = {'Kul Tiras Marine',120,137,6,7,0,{[14]={{60.21,60.17},{60.75,59.37},{59.54,53.51},{59.93,54.71},{59.45,55.47},{59.5,56.35},{59.59,56.75},{58.11,55.53},{57.51,55.31},{59.09,55.59},{57.79,53.79},{59.69,58.46},{59.42,58.48},{56.53,50.8},{59.57,58.18},{58.44,58.49},{59.79,57.85},{59.2,56.74},{58.95,58.31},{59.34,58.3}}},nil,14,nil,nil,123,"A",nil,0},
[3130] = {'Thunder Lizard',176,198,9,10,0,{[14]={{40.46,29.75},{40.65,30.11},{40.5,28.96},{40.2,28.07},{39.24,26.6},{39.15,29.29},{39.63,28.11},{39.1,30.14},{39.1,31.31},{39.1,30.78},{39.21,28.51}}},nil,14,nil,nil,14,nil,nil,0},
[3131] = {'Lightning Hide',198,222,10,11,0,{[14]={{41.99,24.39},{42.44,24.43},{40.67,24.47},{43.26,24.41},{42.87,23.73},{43.63,24.14},{41.39,24.34},{40.17,24.19},{38.88,25.27},{39.52,23.54},{39.36,24.9}}},nil,14,nil,nil,14,nil,nil,0},
[3133] = {'Herble Baubbletump',1002,1002,30,30,0,{[10]={{77.99,48.33}}},nil,10,nil,nil,875,"A","Engineering and Mining Supplies",4},
[3134] = {'Kzixx',712,712,25,25,0,{[10]={{81.82,19.77}}},nil,10,nil,nil,120,"AH","Rare Goods",6},
[3135] = {'Malissa',664,664,24,24,0,{[10]={{79.44,44.33}}},nil,10,nil,nil,12,"A","Poison Supplier",4},
[3136] = {'Clarise Gnarltree',1106,1106,31,31,0,{[10]={{74.0,48.55}}},nil,10,nil,nil,12,"A","Expert Blacksmith",17},
[3137] = {'Matt Johnson',484,484,20,20,0,{[10]={{74.05,49.62}}},nil,10,nil,nil,12,"A","Mining Trainer",17},
[3138] = {'Scott Carevin',712,712,25,25,0,{[10]={{75.83,48.7}}},nil,10,nil,nil,12,"A","Mushroom Seller",4},
[3139] = {'Gar\'Thok',198,198,10,10,0,{[14]={{51.95,43.5}}},nil,14,{784,825,831,837},{784,825,830,837},29,"H",nil,3},
[3140] = {'Lar Prowltusk',137,137,7,7,0,{[14]={{54.24,73.28}}},{[14]={{{54.45,74.33},{54.6,74.66},{54.5,74.96},{54.59,74.58},{54.45,74.33},{54.22,73.31}}}},14,{786},{786},126,"H",nil,2},
[3141] = {'Makrura Elder',156,156,8,8,0,{[14]={{59.02,13.03},{59.8,16.14},{61.08,23.37},{60.98,38.66}}},nil,14,nil,nil,129,nil,nil,0},
[3142] = {'Orgnil Soulscar',417,417,18,18,0,{[14]={{52.24,43.15}}},nil,14,{806,828},{806,823},29,"H",nil,2},
[3143] = {'Gornek',102,102,5,5,0,{[14]={{42.06,68.33}}},nil,14,{788,789,2383,3065,3082,3083,3084,3085,3086,3087,3088,3089,3090},{787,788,789,804,4641},29,"H",nil,3},
[3144] = {'Eitrigg',484,484,20,20,0,{[1637]={{34.28,39.35}}},nil,1637,{787},nil,29,"H",nil,3},
[3145] = {'Zureetha Fargaze',247,247,12,12,0,{[14]={{42.85,69.15}}},nil,14,{792,794,805},{792,794,1499},29,"H",nil,2},
[3146] = {'Gurek',2218,2218,45,45,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[3147] = {'Furl Scornbrow',120,120,6,6,0,{[14]={{49.88,40.39}}},nil,14,{791},{791},29,"H",nil,2},
[3149] = {'Nez\'raz',2217,2217,45,45,0,{[33]={{31.43,29.91}}},nil,33,nil,nil,29,"H","Zeppelin Master",1},
[3150] = {'Hin Denburg',2217,2217,45,45,0,{[85]={{61.78,59.18}}},nil,85,nil,nil,29,"H","Zeppelin Master",1},
[3151] = {'Captain Obvious',57,57,1,1,0,nil,nil,0,nil,nil,35,"AH","Boat Operator",0},
[3152] = {'Cap\'n Copyright',48,48,1,1,0,nil,nil,0,nil,nil,35,"AH","Boat Operator",0},
[3153] = {'Frang',222,222,11,11,0,{[14]={{42.89,69.44}}},nil,14,nil,{2383,3065},29,"H","Warrior Trainer",19},
[3154] = {'Jen\'shan',156,156,8,8,0,{[14]={{42.84,69.33}}},nil,14,{6068},{3082,3087},126,"H","Hunter Trainer",19},
[3155] = {'Rwag',156,156,8,8,0,{[14]={{41.28,68.0}}},nil,14,nil,{3083,3088},29,"H","Rogue Trainer",19},
[3156] = {'Nartok',176,176,9,9,0,{[14]={{40.65,68.52}}},nil,14,nil,{3090},29,"H","Warlock Trainer",19},
[3157] = {'Shikrik',198,198,10,10,0,{[14]={{42.39,69.0}}},nil,14,nil,{3084,3089},29,"H","Shaman Trainer",19},
[3158] = {'Duokna',198,198,10,10,0,{[14]={{42.59,67.34}}},nil,14,nil,nil,29,"H","General Goods",6},
[3159] = {'Kzan Thornslash',1279,1279,34,34,0,{[14]={{40.47,68.0}}},nil,14,nil,nil,29,"H","Weaponsmith",16388},
[3160] = {'Huklah',222,222,11,11,0,{[14]={{40.61,67.8}}},nil,14,nil,nil,29,"H","Cloth & Leather Armor Merchant",16388},
[3161] = {'Rarc',198,198,10,10,0,{[14]={{40.48,67.82}}},nil,14,nil,nil,29,"H","Armorer & Shieldcrafter",16388},
[3162] = {'Burdrak Harglhelm',247,247,12,12,0,{[1]={{30.11,45.28}}},nil,1,nil,nil,55,"A","Leather Armor Merchant",16388},
[3163] = {'Uhgar',328,328,15,15,0,{[14]={{52.02,40.45}}},nil,14,nil,nil,29,"H","Weaponsmith",16388},
[3164] = {'Jark',300,300,14,14,0,{[14]={{54.39,42.18}}},nil,14,nil,nil,29,"H","General Goods",6},
[3165] = {'Ghrawt',273,273,13,13,0,{[14]={{52.98,41.03}}},nil,14,nil,nil,29,"H","Bowyer",16388},
[3166] = {'Cutac',300,300,14,14,0,{[14]={{53.11,40.86}}},nil,14,nil,nil,29,"H","Cloth & Leather Armor Merchant",16388},
[3167] = {'Wuark',300,300,14,14,0,{[14]={{51.9,41.14}}},nil,14,nil,nil,29,"H","Armorer & Shieldcrafter",16388},
[3168] = {'Flakk',328,328,15,15,0,{[14]={{52.98,41.97}}},nil,14,nil,nil,29,"H","Trade Supplies",6},
[3169] = {'Tarshaw Jaggedscar',2059,2059,43,43,0,{[14]={{54.19,42.47}}},nil,14,{1505},nil,29,"H","Warrior Trainer",19},
[3170] = {'Kaplak',300,300,14,14,0,{[14]={{51.98,43.69}}},nil,14,{1859,2380},nil,29,"H","Rogue Trainer",19},
[3171] = {'Thotar',356,356,16,16,0,{[14]={{51.85,43.49}}},nil,14,{6062,6067,6081,6082,6083},{6062,6068,6069,6070,6082,6083},29,"H","Hunter Trainer",19},
[3172] = {'Dhugru Gorelust',1536,1536,37,37,0,{[14]={{54.38,41.2}}},nil,14,nil,nil,29,"H","Warlock Trainer",19},
[3173] = {'Swart',328,328,15,15,0,{[14]={{54.42,42.59}}},nil,14,{2983,2985},nil,29,"H","Shaman Trainer",19},
[3174] = {'Dwukk',840,840,27,27,0,{[14]={{52.03,40.72}}},nil,14,nil,nil,29,"H","Journeyman Blacksmith",19},
[3175] = {'Krunn',356,356,16,16,0,{[14]={{51.81,40.88}}},nil,14,nil,nil,29,"H","Miner",19},
[3177] = {'Turuk Amberstill',198,198,10,10,0,{[1]={{62.9,49.89}}},nil,1,nil,nil,55,"A","Dwarven Weaponsmith",16388},
[3178] = {'Stuart Fleming',712,712,25,25,0,{[11]={{8.02,58.35}}},nil,11,nil,nil,12,"A","Fisherman",4},
[3179] = {'Harold Riggs',712,712,25,25,0,{[11]={{8.08,58.59}}},nil,11,nil,nil,12,"A","Fishing Trainer",19},
[3180] = {'Dark Iron Entrepreneur',1106,1106,31,31,0,{[11]={{46.55,18.37}}},nil,11,nil,nil,35,"AH","Speciality Goods",6},
[3181] = {'Fremal Doohickey',1002,1002,30,30,0,{[11]={{10.83,61.4}}},nil,11,nil,nil,875,"A","First Aid Trainer",19},
[3182] = {'Junder Brokk',484,484,20,20,0,{[11]={{10.83,60.23}}},nil,11,nil,nil,55,"A",nil,16},
[3183] = {'Yarrog Baneshadow',98,98,5,5,0,{[14]={{42.71,52.95}}},nil,14,nil,nil,16,nil,nil,0},
[3184] = {'Miao\'zan',712,712,25,25,0,{[14]={{55.41,73.95}}},nil,14,nil,nil,126,"H","Journeyman Alchemist",19},
[3185] = {'Mishiki',300,300,14,14,0,{[14]={{55.44,75.08}}},nil,14,nil,nil,126,"H","Herbalist",19},
[3186] = {'K\'waii',222,222,11,11,0,{[14]={{56.29,73.4}}},nil,14,nil,nil,126,"H","General Goods",6},
[3187] = {'Tai\'tasi',247,247,12,12,0,{[14]={{56.41,73.79}}},nil,14,nil,nil,126,"H","Trade Supplies",6},
[3188] = {'Master Gadrin',247,247,12,12,0,{[14]={{55.95,74.72}}},nil,14,{808,823,826,2936,2937},{805,808,826,2935,2936},126,"H",nil,2},
[3189] = {'Kor\'ghan',137,137,7,7,0,{[1637]={{47.24,53.58}}},nil,1637,{813},{813},126,"H",nil,2},
[3190] = {'Rhinag',156,156,8,8,0,{[14]={{41.54,18.6}}},nil,14,{812},{812},126,"H",nil,2},
[3191] = {'Cook Torka',120,120,6,6,0,{[14]={{51.11,42.45}}},{[14]={{{51.11,42.45},{51.08,42.51},{51.06,42.44}}}},14,{815},{815},29,"H",nil,2},
[3192] = {'Lieutenant Benedict',156,156,8,8,0,{[14]={{59.72,58.27}}},nil,14,nil,nil,123,"A",nil,0},
[3193] = {'Misha Tor\'kren',102,102,5,5,0,{[14]={{43.1,30.24}}},nil,14,{816},{816},29,"H",nil,2},
[3194] = {'Vel\'rin Fang',137,137,7,7,0,{[14]={{55.96,73.93}}},nil,14,{817},{817},126,"H",nil,2},
[3195] = {'Burning Blade Thug',156,176,8,9,0,{[14]={{53.15,29.14},{52.85,29.28},{52.67,27.93},{53.4,26.93},{53.04,27.81},{52.5,29.19}}},nil,14,nil,nil,554,nil,nil,0},
[3196] = {'Burning Blade Neophyte',166,186,9,10,0,{[14]={{51.92,25.09},{52.78,28.48},{52.82,26.84},{51.88,26.31},{53.12,27.24},{52.07,26.87}}},nil,14,nil,nil,554,nil,nil,0},
[3197] = {'Burning Blade Fanatic',166,186,9,10,0,{[14]={{51.61,10.15},{53.39,10.54},{52.5,10.17},{53.74,9.92},{53.28,9.22},{52.45,8.61},{42.01,26.57},{42.29,26.9},{42.25,26.31},{42.32,27.29},{55.01,9.79},{52.08,8.23},{54.32,8.87},{53.76,8.85},{51.46,9.18},{51.87,10.85},{52.47,9.23},{54.71,9.36},{52.7,11.04},{53.35,8.19},{51.38,8.67},{52.95,8.95},{52.71,7.92}}},nil,14,nil,nil,554,nil,nil,0},
[3198] = {'Burning Blade Apprentice',178,199,10,11,0,{[14]={{54.71,8.77},{53.08,9.4},{53.36,7.74},{52.3,11.01},{41.89,26.85},{42.88,26.43},{53.12,11.06},{53.82,9.4},{51.62,8.1},{52.09,9.84},{53.55,8.55},{51.62,10.56},{53.25,10.02},{52.9,7.6},{52.6,8.22}}},nil,14,nil,nil,554,nil,nil,0},
[3199] = {'Burning Blade Cultist',178,199,10,11,0,{[14]={{52.67,25.36},{52.23,24.54},{52.14,24.93},{52.63,24.98},{52.41,26.8},{52.64,26.39},{51.89,25.71}}},nil,14,nil,nil,554,nil,nil,0},
[3200] = {'Eric\'s AAA Special Vendor',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3201] = {'SM Test Mob',3237,3237,62,62,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3203] = {'Fizzle Darkstorm',219,219,12,12,0,{[14]={{42.12,26.66}}},{[14]={{{42.12,26.66},{42.31,26.63},{42.45,26.56},{42.53,26.52},{42.61,26.48},{42.52,26.54},{42.44,26.57},{42.26,26.63}}}},14,nil,nil,554,nil,nil,0},
[3204] = {'Gazz\'uz',341,341,14,14,0,{[14]={{51.81,10.05},{52.61,8.82},{51.89,9.58},{51.47,9.72}}},nil,14,nil,nil,14,nil,nil,0},
[3205] = {'Zalazane',186,186,10,10,0,{[14]={{67.55,87.81}}},{[14]={{{67.56,87.75},{67.54,87.59},{67.56,87.15},{67.4,87.03},{67.13,87.03},{67.15,86.88},{67.29,86.72},{67.42,86.61},{67.59,86.29},{67.75,86.15},{67.72,86.34},{67.4,86.69},{67.36,87.02},{67.54,87.21},{67.54,87.56}}}},14,nil,nil,16,nil,nil,0},
[3206] = {'Voodoo Troll',148,166,8,9,0,{[14]={{68.58,84.36},{67.07,87.76},{67.16,86.59},{67.56,86.86},{67.22,87.34},{68.52,83.53},{65.92,82.8},{67.4,82.58},{68.4,82.36},{67.82,82.06},{65.92,86.7},{66.88,87.18},{67.07,86.82}}},nil,14,nil,nil,16,nil,nil,0},
[3207] = {'Hexed Troll',148,166,8,9,0,{[14]={{67.75,83.49},{67.7,83.67},{68.29,83.23},{68.16,83.77},{68.11,83.53},{67.29,88.68},{68.46,86.79},{67.9,85.92},{67.13,85.94},{67.14,84.99},{65.89,84.01},{68.75,83.59},{66.53,86.73},{66.55,87.82},{66.63,83.04}}},nil,14,nil,nil,16,nil,nil,0},
[3208] = {'Margoz',417,417,18,18,0,{[14]={{56.41,20.04}}},nil,14,{827,829},{827,828},29,"H",nil,2},
[3209] = {'Brave Windfeather',546,546,13,13,0,{[215]={{44.53,76.5}}},{[215]={{{44.57,76.55},{44.4,76.29},{44.55,76.54},{44.55,76.74},{44.62,77.09},{44.51,77.17},{44.62,77.04},{44.56,76.8},{44.58,76.57},{44.42,76.33},{44.57,76.55},{44.72,76.53},{44.94,76.51},{45.02,76.28},{45.1,76.45},{45.17,76.48},{45.12,76.59},{45.04,76.76},{44.97,76.97},{44.89,77.23},{44.86,77.51},{44.63,77.81},{44.85,77.48},{44.82,77.27},{44.95,77.05},{44.98,76.86},{45.08,76.64},{45.19,76.5},{45.07,76.44},{45.05,76.22},{44.95,76.43},{44.87,76.5},{44.56,76.54},{44.42,76.36},{44.56,76.59},{44.64,77.01},{44.51,77.17},{44.62,77.01}}}},215,{3376},{3376},105,"H",nil,2},
[3210] = {'Brave Proudsnout',5227,5227,55,55,0,{[215]={{45.47,78.27}}},nil,215,nil,nil,105,"H",nil,1},
[3211] = {'Brave Lightninghorn',5228,5228,55,55,0,{[215]={{45.97,77.15}}},nil,215,nil,nil,105,"H",nil,1},
[3212] = {'Brave Ironhorn',600,600,14,14,0,{[215]={{46.84,59.31}}},{[215]={{{46.7,59.13},{46.55,58.94},{46.3,58.67},{45.91,58.26},{46.29,58.65},{46.54,58.94},{46.84,59.31}}}},215,nil,nil,105,"H",nil,1},
[3213] = {'Brave Running Wolf',5228,5228,55,55,0,{[215]={{43.48,77.0}}},nil,215,nil,nil,105,"H",nil,1},
[3214] = {'Brave Greathoof',5228,5228,55,55,0,{[215]={{44.19,78.86}}},nil,215,nil,nil,105,"H",nil,1},
[3215] = {'Brave Strongbash',600,600,14,14,0,{[215]={{48.43,57.18}}},nil,215,nil,nil,105,"H",nil,1},
[3216] = {'Neeru Fireblade',1536,1536,37,37,0,{[1637]={{49.47,50.59}}},nil,1637,{809,3122,5730,5761},{829,832,3121,5729,5761},29,"H",nil,3},
[3217] = {'Brave Dawneagle',546,546,13,13,0,{[215]={{50.94,60.56}}},nil,215,nil,nil,105,"H",nil,1},
[3218] = {'Brave Swiftwind',546,546,13,13,0,{[215]={{49.47,57.15}}},nil,215,nil,nil,105,"H",nil,1},
[3219] = {'Brave Leaping Deer',546,546,13,13,0,{[215]={{51.09,58.59}}},{[215]={{{50.93,58.39},{50.75,58.0},{50.53,57.45},{50.33,57.03},{50.13,56.62},{49.98,56.28},{49.82,55.95},{49.66,55.62},{49.38,55.17},{49.14,54.77},{48.9,54.43},{48.71,54.14},{48.63,53.74},{48.7,54.11},{48.88,54.4},{49.13,54.75},{49.37,55.14},{49.64,55.59},{49.81,55.91},{49.96,56.25},{50.11,56.58},{50.3,56.97},{50.51,57.4},{50.74,57.97},{50.92,58.36},{51.09,58.6},{51.25,58.81},{51.09,58.59}}}},215,nil,nil,105,"H",nil,1},
[3220] = {'Brave Darksky',494,494,12,12,0,{[215]={{48.03,54.84}}},{[215]={{{48.11,54.67},{48.25,54.46},{48.32,54.05},{48.29,53.71},{48.15,53.46},{48.07,53.36},{47.83,53.13},{47.55,52.82},{47.25,52.49},{46.98,52.19},{46.78,51.95},{46.61,51.8},{46.31,51.51},{46.59,51.78},{46.77,51.94},{46.97,52.17},{47.24,52.48},{47.53,52.8},{47.82,53.11},{48.06,53.35},{48.13,53.43},{48.27,53.67},{48.32,54.02},{48.26,54.43},{48.13,54.65},{47.97,54.76}}}},215,nil,nil,105,"H",nil,1},
[3221] = {'Brave Rockhorn',494,494,12,12,0,{[215]={{50.28,62.7}}},nil,215,nil,nil,105,"H",nil,1},
[3222] = {'Brave Wildrunner',600,600,14,14,0,{[215]={{47.52,60.69}}},{[215]={{{47.46,61.0},{47.42,61.39},{47.45,61.02},{47.67,60.55},{47.87,60.76},{48.09,61.15},{48.33,61.6},{48.11,61.17},{47.88,60.79},{47.68,60.55},{47.52,60.85},{47.46,60.99},{47.43,61.37},{47.46,61.0},{47.54,60.55},{47.58,59.9},{47.53,59.64},{47.39,59.49},{47.21,59.33},{47.17,59.03},{47.17,58.79},{47.32,58.42},{47.44,58.16},{47.41,57.74},{47.37,57.35},{47.38,56.87},{47.42,56.44},{47.47,56.16},{47.49,55.65},{47.57,56.16},{47.65,56.59},{48.03,57.04},{48.35,57.45},{48.55,57.74},{48.72,58.01},{48.79,58.15},{48.78,58.32},{48.72,58.57},{48.64,58.82},{48.55,59.12},{48.47,59.39},{48.25,59.53},{48.06,59.61},{47.84,59.7},{47.67,59.78},{47.34,59.7},{46.89,59.59},{46.67,59.73},{46.49,59.95},{46.25,60.11},{46.04,60.26},{46.24,60.13},{46.47,59.97},{46.66,59.75},{46.87,59.6},{47.33,59.69},{47.67,59.79},{47.83,59.71},{48.05,59.62},{48.22,59.54},{48.46,59.41},{48.54,59.16},{48.64,58.82},{48.72,58.58},{48.78,58.35},{48.79,58.17},{48.73,58.03},{48.57,57.77},{48.37,57.47},{48.05,57.06},{47.67,56.6},{47.57,56.18},{47.5,55.65},{47.48,56.11},{47.38,56.82},{47.37,57.33},{47.41,57.67},{47.44,58.15},{47.33,58.41},{47.17,58.77},{47.16,59.01},{47.19,59.31},{47.4,59.49},{47.53,59.64},{47.58,59.87},{47.58,60.05},{47.52,60.69}}}},215,nil,nil,105,"H",nil,1},
[3223] = {'Brave Rainchaser',494,494,12,12,0,{[215]={{48.16,62.93}}},nil,215,nil,nil,105,"H",nil,1},
[3224] = {'Brave Cloudmane',600,600,14,14,0,{[215]={{45.62,57.98}}},{[215]={{{45.69,58.02},{45.76,58.05},{45.82,58.03},{45.95,57.95},{45.94,58.17},{46.01,58.39},{45.87,58.33},{45.72,58.45},{45.73,58.34},{45.75,58.23},{45.71,58.12},{45.63,58.0}}}},215,nil,nil,105,"H",nil,1},
[3225] = {'Corrupted Mottled Boar',198,222,10,11,0,{[14]={{36.87,40.07},{43.68,15.47}}},nil,14,nil,nil,14,nil,nil,0},
[3226] = {'Corrupted Scorpid',198,222,10,11,0,{[14]={{36.56,29.27},{36.4,48.41},{51.38,14.12}}},nil,14,nil,nil,413,nil,nil,0},
[3227] = {'Corrupted Bloodtalon Scythemaw',198,222,10,11,0,{[14]={{37.61,56.12},{43.73,31.67},{39.77,19.87},{38.84,18.55},{44.04,17.61}}},nil,14,nil,nil,48,nil,nil,0},
[3228] = {'Corrupted Surf Crawler',198,222,10,11,0,{[14]={{56.88,10.69},{60.36,21.78}}},nil,14,nil,nil,14,nil,nil,0},
[3229] = {'"Squealer" Thornmantle',102,102,5,5,0,{[215]={{63.28,82.58}}},nil,215,nil,nil,14,nil,nil,0},
[3230] = {'Nazgrel',647400,647400,62,62,0,{[1637]={{32.3,35.75}}},nil,1637,nil,{831},1074,"H","Advisor to Thrall",2},
[3231] = {'Corrupted Dreadmaw Crocolisk',222,247,11,12,0,{[14]={{34.26,52.7}},[17]={{63.26,10.63}}},nil,14,nil,nil,14,nil,nil,0},
[3232] = {'Bristleback Interloper',176,198,9,10,0,{[215]={{60.41,21.96},{62.12,20.56},{60.84,22.41},{60.82,21.09},{61.03,21.28},{62.35,20.96},{62.22,21.54},{60.18,21.63},{60.44,19.5},{61.68,19.45},{61.85,20.16},{62.04,22.51},{62.22,22.13},{60.81,20.02},{60.12,20.9},{60.13,20.02},{60.94,19.54},{60.41,20.38},{61.0,20.83},{61.34,20.49},{61.47,22.85},{61.33,21.85},{61.83,22.58},{61.16,22.82},{61.64,21.66},{61.34,20.82},{61.71,21.34},{61.79,22.03}}},nil,215,nil,nil,111,nil,nil,0},
[3233] = {'Lorekeeper Raintotem',156,156,8,8,0,{[215]={{59.86,25.62}}},nil,215,{833},{833},104,"H",nil,3},
[3234] = {'Lost Barrens Kodo',300,328,14,15,0,{[17]={{40.14,24.25},{42.39,37.69},{45.77,43.34},{57.08,15.85},{54.06,41.46},{54.64,10.53},{41.16,25.55},{41.53,21.45},{42.11,30.11},{42.1,20.67},{43.84,19.69},{52.71,13.27},{53.59,12.0},{57.11,17.72},{54.82,40.13},{53.5,45.82},{55.26,45.83},{54.41,44.72},{43.72,41.81},{47.21,43.3},{52.65,43.44},{60.12,41.31},{56.17,40.12},{44.78,40.79},{51.45,42.94},{51.95,44.72},{61.65,41.66}}},nil,17,nil,nil,15,"AH",nil,0},
[3235] = {'Greater Barrens Kodo',664,712,24,25,0,{[17]={{47.21,66.47}}},nil,17,nil,nil,15,"AH",nil,0},
[3236] = {'Barrens Kodo',449,484,19,20,0,{[17]={{45.8,67.81},{45.72,68.05},{45.79,67.97},{45.8,68.12},{46.91,67.13},{47.14,66.58}}},nil,17,nil,nil,15,"AH",nil,0},
[3237] = {'Wooly Kodo',733,787,25,26,0,{[17]={{47.1,66.66}}},{[17]={{{47.1,66.66},{46.97,66.85},{46.73,67.11},{46.32,67.2},{46.12,67.22},{46.03,67.19},{45.96,67.14},{45.89,67.02},{45.83,66.87},{45.79,66.73},{45.73,66.52},{45.71,66.39},{45.72,66.2},{45.69,66.06},{45.64,65.87},{45.36,65.28},{45.18,64.95},{45.17,64.87},{45.18,64.38},{45.22,63.99},{45.36,63.36},{45.45,63.08},{45.51,62.94},{45.67,62.55},{46.03,61.68},{46.26,61.25},{46.37,61.17},{46.53,61.14},{46.8,61.18},{46.93,61.22},{47.18,61.22},{47.49,61.07},{47.62,61.04},{47.67,61.04},{47.8,61.06},{47.95,61.12},{48.14,61.26},{48.27,61.35},{48.36,61.49},{48.47,61.83},{48.57,62.32},{48.53,62.7},{48.4,63.13},{48.17,63.94},{48.12,64.02},{48.08,64.12},{48.06,64.17},{48.03,64.24},{47.87,64.46},{47.66,64.61},{47.44,65.11},{47.36,65.7},{47.34,65.8},{47.32,65.9},{47.3,66.05},{47.23,66.41}}}},17,nil,nil,15,"AH",nil,0},
[3238] = {'Stormhide',573,617,22,23,0,{[17]={{44.06,75.84},{48.95,74.93},{44.83,73.96},{47.96,73.86},{48.55,73.71},{43.8,73.88},{44.49,74.19},{48.41,74.62},{49.17,76.21},{50.11,80.39},{43.63,75.77},{48.44,75.43},{50.39,76.96},{50.37,76.11},{46.79,72.5},{46.8,72.98},{48.95,76.99},{48.68,76.47},{44.7,75.64},{45.46,74.89},{44.17,76.49},{44.48,78.55},{44.74,76.93},{43.19,78.39},{44.6,79.24},{45.16,76.76},{49.37,79.32},{49.55,80.1},{48.41,75.95},{48.06,76.4},{47.42,75.36},{46.83,74.46},{47.11,74.74},{47.83,75.91},{46.53,79.79},{47.98,81.34},{46.85,77.46},{46.45,79.15},{46.26,77.23},{47.14,82.32},{47.76,80.42},{49.08,78.57}}},nil,17,nil,nil,14,nil,nil,0},
[3239] = {'Thunderhead',493,531,20,21,0,{[17]={{46.05,66.59},{43.04,60.5},{45.37,67.82},{47.13,65.15},{46.67,68.52},{50.15,59.77},{47.44,66.66},{42.78,61.14},{50.35,60.26},{42.54,60.21},{47.81,64.12},{50.0,61.1},{49.53,59.51},{48.45,61.02},{43.82,62.26},{43.53,62.17},{48.21,64.06},{47.07,63.04},{48.44,62.42},{47.98,63.19},{48.94,61.24},{49.36,62.58},{48.78,60.54},{46.17,63.87},{48.48,59.48},{45.74,63.56},{43.81,60.64},{44.14,61.21},{49.07,61.74},{46.46,63.59},{49.28,61.98},{48.28,59.9},{48.95,59.0},{46.45,61.88},{48.95,59.71},{48.54,57.88},{48.13,60.85},{48.08,58.43},{46.53,69.05},{45.43,63.2},{47.49,60.86},{45.81,66.39},{44.39,63.97},{45.2,66.64},{45.67,67.01},{45.79,69.01},{47.05,62.03},{48.1,57.75},{45.23,64.94},{47.09,67.0},{44.46,63.13}}},nil,17,nil,nil,16,nil,nil,0},
[3240] = {'Stormsnout',417,449,18,19,0,{[17]={{48.92,51.37},{48.71,55.64},{46.95,51.1},{42.89,46.9},{46.81,47.83},{52.83,56.64},{47.09,48.26},{44.52,46.8},{52.35,56.52},{42.19,45.77},{52.31,57.12},{49.42,53.65},{48.77,55.2},{47.5,49.16},{46.44,48.48},{47.36,46.76},{42.15,48.75},{47.72,51.79},{44.69,49.36},{52.34,54.18},{52.58,55.22},{49.07,56.21},{45.12,48.19},{48.87,51.72},{48.79,56.72},{46.15,44.78},{50.51,52.81},{53.08,55.11},{43.65,44.39},{49.59,54.36},{43.72,46.49},{44.49,47.51},{50.02,53.4},{45.17,45.34},{48.86,50.77},{43.46,49.25},{50.99,52.98},{42.61,46.33},{45.28,47.88},{45.37,45.73},{43.17,46.33},{49.72,55.95},{42.21,57.71},{45.74,47.75},{47.27,47.08},{46.44,46.34},{46.14,49.84},{42.24,57.52},{50.13,52.71},{44.52,47.85},{52.76,55.76},{50.09,54.32},{44.48,44.93},{50.12,59.11},{45.32,56.28},{45.78,57.08},{45.51,55.7},{44.74,47.8},{46.77,55.84},{49.75,58.12},{43.49,49.8},{46.43,50.81},{44.17,53.37},{46.29,56.11},{45.45,52.25},{47.32,50.26},{48.08,56.61},{49.75,59.16},{48.3,56.96},{46.75,56.25}}},nil,17,nil,nil,14,nil,nil,0},
[3241] = {'Savannah Patriarch',328,356,15,16,0,{[17]={{43.92,16.66},{44.5,14.06},{46.96,13.7},{45.51,16.59},{43.1,15.03},{44.42,15.78},{61.63,32.73}}},nil,17,nil,nil,16,nil,nil,0},
[3242] = {'Zhevra Runner',273,300,13,14,0,{[17]={{45.2,31.24},{43.46,29.05},{46.39,27.47},{42.81,26.83},{47.62,37.64},{47.3,36.47},{59.28,20.3},{52.78,20.31},{56.17,21.19},{50.71,12.7},{64.43,32.95},{64.46,34.6},{64.97,34.32},{64.69,34.01},{63.6,31.47},{43.94,26.16},{43.49,32.18},{45.85,30.42},{49.38,37.93},{55.65,38.81},{52.38,16.26},{60.32,22.1},{61.68,22.09},{52.98,19.55},{58.56,20.37},{43.29,27.42},{42.24,25.85},{47.01,27.42},{42.78,24.28},{45.82,26.63},{45.68,29.67},{44.53,26.62},{49.73,36.44},{55.01,38.23},{52.22,17.62},{53.81,16.72},{49.45,13.27},{52.02,17.14},{58.21,20.08},{43.77,28.51},{44.39,32.83},{45.5,30.18},{43.22,25.74},{44.02,28.84},{56.64,34.61},{53.34,39.04},{54.38,38.26},{61.52,18.66},{59.02,21.54},{54.81,21.67},{56.71,23.13},{46.26,29.61},{44.27,28.01},{56.69,33.92},{49.39,37.33},{51.36,14.67},{62.23,21.64},{52.74,17.63},{44.37,33.47},{43.07,28.94},{52.67,39.37},{56.28,32.64},{55.68,21.73},{62.3,18.53},{61.36,21.85},{52.55,18.21},{60.05,22.46},{57.99,21.17},{52.31,15.5},{43.4,31.03},{47.41,26.05},{45.64,27.57},{46.39,26.82},{47.09,28.58},{48.82,38.28},{50.24,36.34},{48.64,38.42},{57.12,20.19},{52.25,16.07},{53.3,17.2},{46.78,25.15},{46.74,27.03},{44.58,35.34},{46.4,25.64},{46.12,30.98},{56.7,34.93},{55.27,35.47},{55.93,35.08},{58.03,19.84},{57.95,20.77},{61.33,23.49},{53.07,17.02},{51.72,13.07},{44.77,25.32},{48.96,37.55},{56.87,19.85},{56.32,21.65},{52.74,17.7},{52.37,14.5},{61.86,23.05},{52.49,35.22},{47.95,38.62},{57.05,19.09},{51.15,12.58},{61.49,17.83},{49.99,37.95},{48.57,37.68},{43.15,28.06},{49.52,37.42},{49.33,36.41},{48.71,35.93},{42.47,23.65},{42.78,26.09},{42.21,23.47},{45.15,25.56},{44.66,33.06},{52.1,34.86},{48.4,36.85},{51.71,37.76},{51.95,36.77},{52.89,38.62},{50.85,37.85},{51.82,35.57},{52.4,36.39},{55.75,34.43},{52.82,37.59},{50.68,35.77},{53.03,37.41},{54.73,34.11},{43.81,33.47},{59.62,21.75},{51.39,37.0},{54.31,35.1},{53.35,36.78},{53.37,35.5},{53.99,33.04},{54.02,37.51},{51.23,37.92},{50.79,34.14},{55.99,33.55},{53.27,36.04},{56.96,21.66},{62.44,22.47},{54.65,37.91},{60.91,21.59},{52.05,37.91},{52.69,34.84}}},nil,17,nil,nil,189,"AH",nil,0},
[3243] = {'Savannah Highmane',247,273,12,13,0,{[17]={{49.64,16.05},{55.34,30.34},{54.94,30.49},{50.12,15.82},{50.7,20.65},{51.75,26.22}}},nil,17,nil,nil,16,nil,nil,0},
[3244] = {'Greater Plainstrider',222,247,11,12,0,{[17]={{49.37,24.3},{53.3,22.23},{52.92,22.71},{50.68,14.17},{52.12,20.28},{53.88,28.96},{48.02,14.34},{48.55,13.75},{51.82,19.66},{48.84,23.62},{53.26,29.11},{48.67,24.69},{52.2,21.02},{48.73,25.04},{48.1,15.25},{47.58,13.75},{54.57,32.12},{55.54,25.12},{50.88,19.49},{51.4,22.07},{53.05,33.03},{49.32,22.77},{51.63,21.6},{50.98,15.57},{55.89,23.99},{48.72,23.04},{54.01,23.06},{52.83,21.74},{51.33,23.04},{51.18,16.86},{51.31,18.12},{51.08,17.69},{51.42,19.41},{51.22,17.28},{51.71,18.65},{51.02,18.65},{50.73,15.29},{47.26,14.88},{51.86,22.41},{54.72,23.44},{51.73,23.09},{52.7,25.61},{49.82,13.78},{49.28,14.31},{47.75,14.57},{48.96,24.04},{49.07,22.75},{47.33,14.05},{48.51,23.47},{54.08,22.02},{50.41,13.85},{53.01,32.32},{53.01,23.66},{50.35,33.38},{52.36,21.75},{52.76,28.2},{47.75,25.58},{48.46,25.6},{53.6,30.51},{53.12,30.42},{53.01,26.6},{53.31,30.59},{52.64,27.03},{52.03,27.09},{54.01,27.99},{51.38,28.01},{53.93,28.53},{51.71,27.56},{50.34,31.02},{50.7,27.82},{51.02,27.58},{50.35,30.62},{53.05,31.47},{48.59,26.46},{48.09,27.11},{49.07,29.51},{50.76,33.31},{48.21,28.64},{49.06,30.63},{48.59,29.12},{49.41,29.83},{51.15,32.88},{51.02,31.83},{49.63,30.31},{47.75,27.62},{53.35,32.41},{53.35,32.58},{53.64,29.53},{52.94,33.58},{53.7,32.87},{52.72,26.12},{55.44,24.31},{54.0,23.56}}},nil,17,nil,nil,189,"AH",nil,0},
[3245] = {'Ornery Plainstrider',356,386,16,17,0,{[17]={{42.12,16.03},{45.01,13.59},{42.09,15.3},{46.79,13.17},{45.68,14.6},{60.71,31.98},{60.52,33.88},{61.36,13.22},{38.3,26.06},{38.83,24.97},{61.97,49.24},{61.02,48.87},{52.77,47.72},{45.45,17.12},{43.28,14.75},{45.33,15.4},{61.17,30.72},{57.28,6.42},{59.1,6.74},{56.01,5.34},{58.29,7.92},{60.79,9.77},{59.96,8.54},{37.26,28.4},{38.02,27.85},{39.91,24.72},{37.97,26.63},{54.42,51.37},{55.4,50.85},{45.24,13.39},{48.04,13.23},{45.37,15.85},{46.74,12.34},{60.9,34.47},{61.09,33.01},{59.56,7.84},{60.91,10.96},{50.15,49.69},{56.16,49.41},{55.59,47.34},{44.08,17.23},{44.48,15.52},{44.63,14.76},{44.2,15.29},{59.28,49.33},{47.64,44.1},{49.74,47.37},{44.56,13.73},{58.95,50.14},{49.73,50.11},{45.79,43.33},{48.76,49.83},{61.28,47.83},{59.57,53.35},{47.1,44.95},{49.09,47.35},{48.97,48.37},{50.46,47.19},{52.63,47.06},{53.69,51.75},{56.04,48.34},{53.77,48.45},{49.69,48.38},{54.62,50.35},{53.59,48.91},{49.38,48.81},{58.35,51.82},{55.54,51.2},{49.82,46.27},{55.87,48.25},{53.36,48.76},{54.71,49.71},{59.88,33.15},{59.62,31.61},{54.26,50.65},{59.46,33.54},{59.35,32.53},{55.99,6.23},{53.46,47.82},{57.15,52.19},{55.34,47.76},{58.01,51.79},{54.99,52.64},{54.33,48.0},{51.73,47.37},{55.06,49.41},{59.51,52.31},{56.0,52.33},{54.21,52.38}}},nil,17,nil,nil,14,nil,nil,0},
[3246] = {'Fleeting Plainstrider',247,273,12,13,0,{[17]={{46.72,24.43},{45.98,30.89},{44.16,25.46},{44.86,31.85},{57.24,27.03},{49.8,38.1},{46.72,20.82},{48.37,17.25},{60.2,22.98},{57.35,21.06},{49.48,18.18},{63.85,31.9},{63.54,31.08},{63.57,29.57},{63.92,30.09},{63.94,32.13},{47.51,31.6},{45.81,32.81},{46.17,27.28},{44.56,35.09},{56.43,30.24},{49.44,20.72},{48.71,20.6},{47.95,21.56},{46.24,19.43},{63.55,28.57},{63.97,35.57},{63.92,35.87},{43.11,31.44},{43.93,34.6},{42.63,29.94},{48.17,38.54},{52.32,15.23},{49.77,20.35},{50.13,21.77},{48.15,19.64},{47.61,32.53},{46.77,26.06},{44.86,32.5},{47.46,29.79},{54.69,38.5},{56.83,29.54},{57.59,30.53},{55.7,29.58},{57.67,31.32},{59.18,20.65},{56.65,21.15},{48.09,20.56},{52.67,21.13},{43.81,31.89},{49.12,32.84},{46.2,30.11},{57.34,29.84},{56.33,28.59},{57.28,31.09},{49.09,20.15},{47.6,21.28},{51.9,14.81},{58.28,20.78},{56.83,22.69},{49.13,17.63},{43.6,24.81},{46.72,33.36},{48.0,31.15},{46.32,30.83},{46.4,28.64},{49.19,38.88},{57.57,28.58},{47.04,37.66},{47.66,37.95},{48.36,18.22},{48.42,19.21},{49.58,21.15},{42.57,25.09},{47.74,33.03},{48.75,31.73},{48.81,32.03},{47.59,34.61},{57.58,27.69},{52.99,18.85},{46.66,19.34},{43.21,33.01},{46.73,32.65},{44.79,25.09},{56.65,27.97},{54.16,34.78},{58.32,31.94},{48.76,21.49},{44.68,33.97},{45.14,26.73},{44.89,35.91},{47.05,26.62},{44.89,34.46},{56.8,34.51},{50.07,35.86},{57.27,29.14},{57.02,27.6},{47.78,20.18},{50.72,12.63},{56.59,31.06},{57.72,29.91},{53.35,37.44},{56.86,26.7},{49.4,35.89},{49.47,19.26},{48.76,19.71},{52.57,16.23},{51.19,13.28},{46.99,21.66},{48.78,37.04},{48.06,37.89},{57.1,28.56},{56.02,31.95},{58.02,28.85},{48.31,37.15},{52.0,35.53},{56.65,29.08},{56.95,30.47},{57.96,30.99},{54.38,36.44},{58.0,26.12},{50.04,36.65},{48.61,15.8},{48.39,20.14},{50.31,13.24},{49.94,17.5},{57.12,20.82},{60.92,22.37},{47.75,34.15},{46.72,34.16},{54.28,33.46},{51.05,34.97},{52.36,36.95},{56.07,33.05},{56.96,31.5},{51.06,35.56},{54.35,34.97},{50.91,34.69},{52.97,35.19},{55.76,22.67},{61.5,22.51},{52.98,34.31},{57.57,23.37},{54.32,35.46},{54.67,35.46}}},nil,17,nil,nil,189,"AH",nil,0},
[3247] = {'Thunderhawk Hatchling',302,346,18,20,0,{[17]={{46.76,50.95},{42.81,46.04},{48.54,56.69},{47.61,50.85},{44.45,47.21},{45.82,46.63},{44.03,45.41},{46.71,49.14},{45.75,48.8},{49.41,55.0},{50.8,53.21},{44.13,53.15},{45.49,52.76},{49.79,54.03}}},nil,17,nil,nil,14,nil,nil,0},
[3248] = {'Barrens Giraffe',328,356,15,16,0,{[17]={{52.28,13.08},{60.39,15.84},{55.36,13.62},{55.4,46.15},{59.49,33.93},{44.04,39.85},{62.87,7.77},{62.75,28.55},{61.46,8.11},{40.55,25.27},{42.78,32.08},{52.37,42.83},{56.99,42.33},{62.85,29.47},{43.47,38.91},{54.46,9.92},{54.9,40.55},{39.54,31.43},{55.91,37.89},{58.17,34.07},{43.78,38.92},{44.14,17.77},{51.73,12.86},{56.41,16.25},{54.03,10.79},{55.65,40.54},{62.97,26.59},{63.17,6.63},{40.08,30.06},{42.19,36.45},{55.03,8.75},{56.65,17.77},{43.83,42.03},{61.57,8.66},{42.12,30.54},{60.82,14.59},{56.55,39.03},{46.76,42.66},{47.45,42.67},{43.34,33.86},{42.16,22.36},{42.88,20.05},{57.93,18.18},{59.35,35.88},{58.95,30.67},{60.59,41.13},{43.84,40.08},{41.77,21.81},{42.87,35.51},{54.07,41.59},{60.33,41.76},{58.7,33.95},{44.84,18.75},{51.85,44.67},{56.36,40.32},{60.01,27.41},{44.71,40.75},{54.96,44.38},{59.62,36.62},{56.93,39.63},{53.05,45.85},{48.68,40.38},{55.32,47.09},{59.91,33.9},{43.2,41.71},{51.38,42.65},{49.36,42.73},{48.17,41.83},{51.53,13.31},{63.63,5.43},{61.64,26.98},{44.13,19.2},{59.62,29.52},{49.24,40.87},{62.91,26.08}}},nil,17,nil,nil,189,"AH",nil,0},
[3249] = {'Greater Thunderhawk',544,582,23,24,0,{[17]={{49.08,76.26},{44.91,73.86},{43.84,76.94},{43.77,78.55},{48.61,76.25},{44.55,75.87},{47.03,73.66},{43.66,75.05},{44.75,78.16},{43.81,78.79},{44.75,75.42},{47.11,74.4},{47.5,75.24},{46.87,76.19},{45.45,81.19},{46.73,79.16}}},nil,17,nil,nil,14,nil,nil,0},
[3250] = {'Silithid Creeper',494,531,20,21,0,{[17]={{44.9,72.55},{42.51,72.07},{47.29,70.45},{49.13,69.1},{48.7,70.21},{48.15,70.38},{49.43,69.34},{42.87,71.41},{43.75,72.02},{48.08,69.46},{42.51,69.91},{42.11,69.38},{43.77,72.96},{43.74,71.06},{43.92,69.99},{42.45,71.06},{44.18,69.52},{43.16,69.15},{47.1,70.0},{47.33,71.33},{45.44,69.54},{44.73,71.59},{45.19,72.0},{45.23,70.16},{45.39,69.41}}},nil,17,nil,nil,413,nil,nil,0},
[3251] = {'Silithid Grub',485,485,20,20,0,{[17]={{48.04,70.81},{42.53,69.58},{47.45,70.02},{45.11,72.45},{42.88,71.3},{44.07,71.4},{48.04,71.13},{45.25,72.25},{44.23,71.32},{47.34,70.24},{48.65,70.03},{48.46,69.9},{44.17,72.44},{43.04,71.2},{44.0,72.35},{42.82,69.95},{42.93,69.81},{43.47,70.03},{43.29,70.1},{43.12,71.47},{44.43,72.66},{44.17,71.5},{45.06,69.73},{45.06,69.48}}},nil,17,nil,nil,413,nil,nil,0},
[3252] = {'Silithid Swarmer',531,573,21,22,0,{[17]={{44.58,71.88},{48.79,69.49},{48.47,70.93},{48.5,70.85},{42.09,71.69},{43.51,69.41},{48.19,71.63},{41.88,69.02},{49.23,69.95},{42.69,72.56},{45.59,72.59},{48.43,70.04},{47.68,70.13},{49.1,69.98},{47.6,70.91},{42.79,71.13},{43.06,71.94},{43.54,70.52},{43.13,70.94},{42.59,70.13},{42.83,70.64},{42.2,70.47},{42.81,69.37},{44.03,69.28},{44.85,69.68},{43.82,72.74},{45.39,72.55},{45.11,68.95}}},nil,17,nil,nil,413,nil,nil,0},
[3253] = {'Silithid Harvester',664,664,24,24,4,{[17]={{43.07,70.08}}},nil,17,nil,nil,310,nil,nil,0},
[3254] = {'Sunscale Lashtail',178,218,11,13,0,{[17]={{48.85,23.82},{51.79,18.7},{47.71,14.48},{51.29,22.62},{54.6,23.16},{48.35,25.11},{47.87,26.03},{52.93,33.04},{54.73,23.13}}},nil,17,nil,nil,48,nil,nil,0},
[3255] = {'Sunscale Screecher',273,328,13,15,0,{[17]={{42.86,25.63},{39.81,31.54},{41.87,20.58},{60.46,22.1},{56.62,15.4},{52.63,13.12},{58.88,17.67},{58.25,45.89},{55.75,44.37},{57.61,14.82},{62.3,25.91},{60.17,14.12},{43.8,19.79},{60.8,23.25},{59.91,17.42},{54.6,8.44},{54.27,16.24},{59.45,17.66},{57.22,10.23},{57.99,13.75},{58.25,13.32},{40.15,24.1},{54.58,35.85},{54.15,10.13},{61.53,41.31},{58.84,43.42},{54.0,40.88},{61.7,46.88},{59.37,13.71},{59.71,14.08},{41.88,25.55},{55.37,21.24},{53.35,14.74},{54.99,7.85},{59.96,44.39},{60.38,44.82},{44.43,41.2},{43.83,40.95},{56.92,11.91},{57.97,11.52},{57.29,12.73},{58.89,10.68},{60.21,11.85},{43.32,33.54},{44.75,33.41},{43.46,19.67},{43.83,18.69},{56.41,35.0},{60.92,46.51},{53.03,46.8},{58.01,12.83},{57.72,12.26},{59.52,10.59},{59.48,15.05},{44.33,26.11},{40.74,20.17},{41.81,32.88},{57.63,17.41},{60.41,14.9},{60.26,47.08},{53.5,46.2},{59.17,15.99},{59.16,12.92},{58.39,14.32},{56.3,11.31},{58.59,13.75},{40.28,24.99},{41.39,25.1},{44.12,19.77},{41.76,29.57},{41.2,23.62},{53.25,17.04},{54.69,9.24},{55.01,13.9},{53.02,13.27},{52.94,43.37},{45.62,30.31},{41.15,22.64},{55.25,9.38},{56.3,16.77},{54.97,10.34},{56.41,9.88},{54.89,15.53},{57.35,36.17},{44.17,34.64},{42.46,30.46},{42.23,33.99},{42.55,38.49},{50.33,13.07},{58.0,20.53},{60.19,17.88},{60.58,16.71},{54.37,12.81},{53.33,11.88},{52.78,42.98},{53.57,44.35},{58.75,39.93},{42.82,38.09},{44.2,18.33},{53.08,19.37},{43.54,40.72},{59.02,42.71},{41.49,20.15},{41.86,34.23},{44.44,18.77},{40.5,29.01},{57.62,38.44},{58.48,34.4},{43.27,34.11},{59.96,46.35},{54.19,40.78},{58.94,45.93},{59.91,45.34},{44.17,41.55},{59.27,44.3},{59.81,43.92},{58.66,46.34},{59.25,45.36},{58.93,46.79},{57.17,35.68},{59.64,46.81},{57.67,36.9},{54.43,41.03},{58.64,45.37},{59.62,44.9},{55.0,44.35},{60.0,42.91},{60.71,29.64},{57.35,39.91},{60.51,43.73},{51.11,43.27},{44.49,40.68},{50.0,39.01},{52.15,35.9},{63.59,6.04},{58.88,14.22},{58.32,12.31},{58.35,44.12},{52.06,43.88},{51.88,46.45},{50.06,45.32},{60.12,29.57},{55.92,40.14},{48.85,41.65},{59.61,45.8},{55.88,14.07},{54.68,11.27},{53.02,12.83},{54.68,16.21},{55.99,33.56},{54.82,39.61},{57.1,36.38},{58.8,34.48},{58.63,33.48},{49.68,39.36},{60.34,28.47},{59.3,46.38},{51.74,44.21},{55.96,38.83},{50.76,39.97},{54.69,46.14},{57.95,37.06},{56.21,39.22},{57.35,40.48},{53.35,34.4},{53.72,35.94},{61.93,23.07},{59.98,35.57},{57.57,42.32}}},nil,17,nil,nil,48,nil,nil,0},
[3256] = {'Sunscale Scytheclaw',356,417,16,18,0,{[17]={{57.04,53.01},{56.98,54.49},{48.16,11.26},{46.44,15.03},{60.25,32.21},{60.84,12.72},{59.33,6.22},{60.41,8.85},{59.91,8.85},{59.87,7.47},{57.73,6.22},{39.27,25.65},{36.19,28.79},{37.56,27.46},{37.25,26.78},{60.34,50.4},{57.65,54.12},{57.7,54.1},{57.06,52.87},{43.48,14.97},{43.85,16.19},{44.14,16.62},{42.55,15.65},{47.74,12.92},{60.02,32.03},{55.73,5.75},{58.99,6.33},{57.86,8.22},{36.66,26.43},{51.92,48.0},{44.39,44.25},{52.15,46.62},{44.72,14.26},{46.08,15.3},{61.23,34.04},{60.97,32.05},{58.25,7.37},{51.82,49.36},{50.36,46.14},{47.75,45.8},{60.91,49.85},{44.12,14.4},{45.53,14.68},{60.75,33.37},{51.76,50.7},{55.65,50.79},{48.16,46.81},{50.09,45.68},{43.88,43.44},{50.68,51.8},{47.07,43.38},{46.0,43.85},{46.34,44.13},{51.49,50.78},{48.31,47.37},{49.34,49.62},{47.78,43.21},{50.19,46.68},{52.98,51.23},{45.14,44.39},{48.83,48.66},{56.69,47.39},{60.29,30.47},{61.28,31.02},{60.89,50.02},{56.65,48.96},{48.09,50.27},{59.16,7.39},{56.64,4.35},{44.51,42.99},{57.28,53.67},{57.43,53.76},{57.11,53.38},{57.1,54.41},{58.04,53.89},{58.01,53.99},{57.9,53.93},{52.58,45.99},{44.45,43.83},{52.69,46.05},{49.45,51.16},{57.12,52.01},{57.07,51.88},{54.29,49.44},{52.41,46.62},{58.31,50.03},{52.62,46.27},{55.82,51.88},{53.02,48.28}}},nil,17,nil,nil,48,nil,nil,0},
[3257] = {'Ishamuhale',449,449,19,19,0,nil,nil,0,nil,nil,48,nil,nil,0},
[3258] = {'Bristleback Hunter',386,417,17,18,0,{[17]={{43.22,47.67},{41.45,44.43},{43.27,48.48},{40.83,45.91},{43.46,52.6},{45.39,51.22},{43.34,52.16},{44.95,51.42},{43.6,51.82},{44.75,51.73},{45.27,53.94},{46.77,54.29},{44.89,53.71},{45.08,54.18},{47.07,53.26},{43.41,48.77},{40.99,44.93},{41.31,44.91},{42.86,48.38},{43.22,47.32},{40.6,45.37},{43.16,48.93},{43.05,47.93},{44.47,52.32},{43.12,51.88},{44.47,51.82},{44.69,51.32},{44.6,51.6},{43.16,52.4},{47.09,53.59},{51.07,54.24},{43.55,48.26},{40.79,45.35},{41.2,45.85},{43.66,47.86},{43.54,47.28},{40.6,45.83},{42.8,51.59},{46.9,53.14},{51.2,54.87},{41.49,46.4},{45.38,54.35},{52.0,54.5},{50.69,55.18},{51.63,54.73},{45.73,54.15},{44.1,51.68},{43.48,52.15},{51.3,55.75},{52.07,53.86},{42.86,55.69},{42.92,54.92},{43.57,54.98},{43.16,55.23},{46.72,54.29},{46.56,53.94},{45.06,54.72},{47.36,52.62},{51.3,57.48},{51.15,55.56}}},nil,17,nil,nil,111,nil,nil,0},
[3259] = {'Bristleback Defender',494,531,20,21,0,nil,nil,0,nil,nil,111,nil,nil,0},
[3260] = {'Bristleback Water Seeker',325,350,16,17,0,{[17]={{47.24,53.75},{52.59,52.66},{45.09,55.26},{45.51,53.76},{47.1,52.67},{45.39,54.0},{46.42,53.27},{51.13,55.11},{51.08,54.71},{53.4,53.55},{53.73,53.98},{45.27,54.16},{45.13,53.73},{47.33,53.21},{46.82,53.77},{46.46,54.17},{46.51,53.69},{46.86,53.37},{52.63,52.15},{51.36,54.76},{45.5,54.82},{45.66,54.72},{43.51,55.2},{43.51,54.73},{42.87,55.25},{43.17,55.7},{43.09,54.88},{44.8,54.2},{47.72,52.79},{51.24,57.85},{51.44,57.57},{51.05,57.37}}},nil,17,nil,nil,111,nil,nil,0},
[3261] = {'Bristleback Thornweaver',377,404,18,19,0,{[17]={{43.41,51.6},{45.03,51.33},{43.27,52.5},{44.87,51.59},{50.73,54.73},{51.33,55.16},{53.1,54.76},{53.01,53.23},{52.36,53.69},{44.78,51.51},{43.03,52.26},{45.17,51.67},{52.95,51.7},{53.08,52.81},{53.03,53.72},{53.37,54.19},{51.66,55.16},{52.63,53.83},{44.02,51.32},{51.04,55.8},{51.32,54.16},{53.4,52.8},{45.48,51.62},{50.37,57.1},{50.43,57.75},{51.68,57.2},{51.73,57.69},{51.41,56.61},{50.73,56.83}}},nil,17,nil,nil,111,nil,nil,0},
[3262] = {'Bristleback Mystic',473,508,21,22,0,nil,nil,0,nil,nil,111,nil,nil,0},
[3263] = {'Bristleback Geomancer',379,405,19,20,0,{[17]={{41.56,44.9},{40.37,45.41},{41.09,46.21},{40.75,45.51},{43.27,48.0},{53.64,53.52},{53.42,53.92},{52.56,52.43},{52.79,52.12},{40.94,45.16},{41.13,45.25},{40.89,44.81},{43.81,48.17},{43.45,48.07},{43.1,46.87},{52.43,53.03},{41.39,45.77},{43.42,47.75},{52.72,53.24},{53.32,53.19},{53.03,52.27},{53.44,54.53},{53.65,54.26},{53.03,54.17},{42.81,47.76},{42.79,48.74},{42.46,46.68},{51.36,57.21},{51.18,57.58},{50.84,57.47},{51.52,57.93},{51.97,57.69},{51.05,56.64},{50.76,57.13}}},nil,17,nil,nil,111,nil,nil,0},
[3265] = {'Razormane Hunter',222,247,11,12,0,{[17]={{57.81,24.44},{59.44,23.85},{54.92,25.24},{55.57,26.46},{55.1,25.59},{57.83,23.62},{58.12,24.21},{53.76,25.29},{59.2,26.45}}},nil,17,nil,nil,109,nil,nil,0},
[3266] = {'Razormane Defender',247,273,12,13,0,{[17]={{59.25,27.6},{58.88,27.35},{59.31,25.31},{59.32,27.04},{58.02,24.69},{59.14,24.48},{59.37,24.55},{59.56,24.26},{59.25,23.96},{59.62,24.5},{58.9,25.0},{58.95,26.57},{58.79,27.04},{56.7,24.57},{57.27,25.06},{57.57,25.13},{57.24,25.53},{57.2,25.39},{57.07,25.21},{58.3,26.62},{58.7,26.23},{59.26,25.58}}},nil,17,nil,nil,109,nil,nil,0},
[3267] = {'Razormane Water Seeker',198,222,10,11,0,{[17]={{54.37,25.01},{53.05,25.05},{54.03,25.19},{55.42,26.65},{55.54,25.75},{54.38,25.9},{54.33,25.56},{54.94,26.74},{55.03,26.97},{55.85,27.18},{55.49,26.91},{55.39,26.99},{55.67,27.27},{55.76,26.66},{55.82,26.67},{53.72,25.65},{53.97,26.06},{53.65,24.51}}},nil,17,nil,nil,109,nil,nil,0},
[3268] = {'Razormane Thornweaver',186,208,10,11,0,{[17]={{54.44,24.59},{54.16,25.09},{55.43,26.94},{55.86,26.31},{55.61,26.17},{55.02,25.34},{54.74,25.6},{54.59,25.24},{54.72,27.1},{55.11,26.59},{55.79,26.94},{55.71,26.63},{54.06,25.52}}},nil,17,nil,nil,109,nil,nil,0},
[3269] = {'Razormane Geomancer',219,241,12,13,0,{[17]={{59.14,25.06},{56.76,25.08},{59.12,23.96},{58.92,24.51},{59.06,24.21},{58.71,24.1},{59.44,24.56},{59.29,24.66},{59.46,24.02},{57.47,25.57},{56.96,24.13},{57.0,24.54},{57.32,24.6},{56.91,25.45},{56.78,25.39},{56.91,25.08},{56.95,25.36}}},nil,17,nil,nil,109,nil,nil,0},
[3270] = {'Elder Mystic Razorsnout',903,903,15,15,2,{[17]={{59.25,24.38}}},nil,17,nil,nil,109,nil,nil,0},
[3271] = {'Razormane Mystic',253,276,13,14,0,{[17]={{58.51,27.22},{58.75,27.34},{58.36,26.11},{58.34,26.93},{58.61,26.9},{58.6,26.57}}},nil,17,nil,nil,109,nil,nil,0},
[3272] = {'Kolkar Wrangler',248,273,12,13,0,{[17]={{46.79,41.93},{47.36,41.91},{53.4,36.94},{44.26,21.62},{43.69,21.14},{43.38,21.02},{44.44,22.53},{48.81,39.44},{44.76,20.35},{47.54,24.55},{47.7,24.46},{41.98,24.77},{45.46,23.46},{53.66,37.08},{54.92,37.36},{48.72,39.19},{42.77,23.71},{44.97,20.34},{43.57,23.4},{43.77,21.48},{42.29,27.35},{45.63,22.85},{42.42,24.72},{45.14,20.0},{42.45,24.05},{42.61,24.13},{42.29,26.62},{42.29,27.03},{43.27,26.41},{43.5,26.31},{43.6,26.47},{43.54,26.81},{45.72,25.82},{45.7,25.99},{45.69,25.5},{45.51,25.36},{46.16,22.71},{45.88,25.4},{47.23,23.43},{46.6,23.14},{45.54,22.08},{46.59,22.75},{44.68,24.3},{45.64,41.43},{44.74,39.72},{44.73,39.55},{48.02,24.79},{44.41,23.68},{48.31,24.5},{47.95,24.53},{52.99,36.62},{48.39,40.01},{45.8,38.36},{45.75,37.53},{46.71,37.9},{46.79,38.52},{47.74,39.39},{47.47,38.83},{48.46,40.45},{47.04,40.56},{48.05,40.85},{47.42,40.89},{46.05,40.88},{45.44,39.38},{45.51,40.42},{44.47,38.52},{44.49,37.95},{44.63,37.78},{46.65,37.51},{53.42,36.84}}},nil,17,nil,nil,130,nil,nil,0},
[3273] = {'Kolkar Stormer',253,276,13,14,0,{[17]={{43.34,23.4},{44.43,23.09},{43.47,23.56},{43.0,23.48},{53.41,40.24},{48.72,40.86},{47.46,41.7},{42.08,24.62},{44.5,22.15},{48.88,38.82},{45.79,41.55},{47.12,37.45},{44.76,19.63},{45.12,20.72},{44.36,20.09},{44.77,22.04},{56.94,40.58},{53.57,40.04},{47.74,37.51},{45.48,24.17},{44.97,19.96},{43.71,21.29},{54.76,37.13},{43.95,21.54},{42.23,25.19},{42.08,26.55},{43.25,23.84},{42.16,26.85},{43.63,26.17},{47.21,23.44},{46.59,22.87},{45.76,22.68},{44.67,24.32},{44.82,39.83},{44.85,24.28},{57.02,41.23},{52.81,36.64},{53.05,36.85},{45.81,38.02},{44.13,38.45},{45.51,37.88},{47.18,38.84},{48.07,38.46},{46.75,40.96},{47.81,40.86},{45.8,40.39},{45.08,38.84},{45.44,39.93},{44.76,38.42},{46.05,36.94},{44.32,37.75},{45.39,36.84},{46.49,36.99},{46.77,36.45}}},nil,17,nil,nil,130,nil,nil,0},
[3274] = {'Kolkar Pack Runner',300,327,14,15,0,{[17]={{52.69,44.82},{53.67,41.93},{57.0,42.86},{48.53,42.45},{47.76,37.37},{55.62,45.76},{54.04,42.77},{52.36,44.93},{55.26,46.57},{53.32,40.95},{56.8,40.64},{52.72,38.92}}},nil,17,nil,nil,130,nil,nil,0},
[3275] = {'Kolkar Marauder',328,356,15,16,0,{[17]={{54.98,41.02},{53.09,44.61},{46.46,42.19},{53.29,41.93},{56.58,43.73},{53.72,42.93},{56.01,43.88},{54.55,46.72},{55.81,45.8},{52.99,42.32},{54.31,46.81},{53.93,42.97},{56.33,42.9},{56.44,41.61}}},nil,17,nil,nil,130,nil,nil,0},
[3276] = {'Witchwing Harpy',300,328,14,15,0,{[17]={{40.6,16.51},{41.42,18.59},{41.85,19.32},{41.12,14.29},{41.04,14.8},{39.9,18.86},{40.38,18.17},{40.23,18.86},{41.89,14.73},{40.23,16.61},{40.29,19.36},{40.84,16.17},{41.41,14.58},{41.89,18.96},{41.47,19.12},{41.5,15.19},{40.58,16.25},{41.19,15.75},{40.87,18.18},{40.9,17.16},{40.13,19.49},{40.87,15.25},{41.2,16.76},{40.57,14.75},{40.7,16.8}}},nil,17,nil,nil,514,nil,nil,0},
[3277] = {'Witchwing Roguefeather',328,356,15,16,0,{[17]={{40.35,17.87},{40.46,19.7},{41.13,19.69},{40.47,16.68},{40.95,14.58},{40.52,17.71},{40.6,17.01},{40.12,15.53},{41.24,14.7},{40.12,18.7},{40.24,15.27},{40.01,19.2},{40.53,15.67},{40.5,18.62},{40.37,16.26},{41.82,18.57},{41.2,18.71},{41.63,18.9},{40.95,16.78},{40.21,19.17}}},nil,17,nil,nil,514,nil,nil,0},
[3278] = {'Witchwing Slayer',356,386,16,17,0,{[17]={{37.78,16.05},{39.5,13.23},{39.82,16.76},{37.25,15.72},{40.17,15.97},{39.48,14.67},{39.64,11.71},{39.48,15.25},{38.8,10.67},{38.49,17.52},{40.3,15.45},{38.74,11.72},{38.18,12.58},{38.25,15.74},{38.19,15.21},{38.91,14.31},{38.46,15.11},{39.03,12.02},{38.18,14.67},{40.06,15.29},{37.25,16.2},{39.75,15.6},{38.2,13.45},{38.0,14.75},{39.27,13.23},{39.59,16.27},{39.92,11.89},{38.19,16.03},{38.79,15.11},{37.93,16.41},{38.61,17.1},{39.19,17.18},{38.96,13.29},{38.58,16.22},{38.4,13.21},{37.91,13.56},{39.02,12.31},{39.2,14.68},{39.51,16.83},{38.64,13.99},{39.27,10.97},{38.63,13.18},{38.68,12.76},{39.23,10.56},{38.82,17.64},{39.18,15.68},{38.33,12.74},{39.78,16.0}}},nil,17,nil,nil,514,nil,nil,0},
[3279] = {'Witchwing Ambusher',386,417,17,18,0,{[17]={{37.57,15.61},{38.24,16.54}}},nil,17,nil,nil,514,nil,nil,0},
[3280] = {'Witchwing Windcaller',350,377,17,18,0,{[17]={{38.86,12.42},{38.4,17.12},{38.24,13.1},{38.86,11.98},{39.06,14.1},{38.15,14.83},{38.66,17.75},{38.76,17.31},{38.84,13.93},{38.16,16.37},{38.52,13.05},{37.77,16.28},{39.58,11.97},{38.82,12.92},{39.31,13.46},{39.25,11.94},{40.76,15.83},{40.49,15.07},{39.18,10.94},{38.79,10.47},{38.34,11.7},{38.52,13.4},{37.97,16.09}}},nil,17,nil,nil,514,nil,nil,0},
[3281] = {'Sarkoth',86,86,4,4,0,{[14]={{40.5,66.83}}},nil,14,nil,nil,14,nil,nil,0},
[3282] = {'Venture Co. Mercenary',328,356,15,16,0,{[17]={{55.99,8.54},{57.41,8.31},{56.45,8.39},{56.3,7.12},{56.31,8.14},{56.18,8.32},{57.0,8.71},{55.79,7.12},{55.86,8.45},{56.22,8.56},{56.35,9.27},{57.09,7.49},{56.26,8.64},{56.54,7.54},{56.1,7.63}}},nil,17,nil,nil,47,nil,nil,0},
[3283] = {'Venture Co. Enforcer',300,386,14,17,0,{[17]={{60.21,3.46},{62.16,3.52},{62.23,5.56},{60.43,4.03},{61.81,3.77},{59.87,3.73},{61.06,3.95},{61.93,3.88},{59.96,3.98},{61.38,3.99},{60.81,3.79},{60.52,3.81},{59.8,2.94},{61.93,4.52},{61.62,3.59},{60.26,3.81},{61.88,5.58},{60.14,3.24},{59.62,2.85},{62.2,4.91},{61.14,5.06},{59.81,3.49},{60.28,4.03},{60.28,3.63},{61.41,5.57},{59.74,3.83},{59.84,3.31},{61.47,4.49},{61.05,3.61}}},nil,17,nil,nil,47,nil,nil,0},
[3284] = {'Venture Co. Drudger',300,328,14,15,0,{[17]={{52.72,10.97},{52.56,11.72},{55.87,8.93},{57.43,7.14},{55.83,7.78},{57.22,8.66},{56.19,7.46},{57.04,9.01},{55.53,8.87},{57.58,7.85},{52.99,10.47},{52.96,10.27},{52.48,11.63},{52.48,10.7},{55.8,6.93},{56.41,8.21},{55.91,6.73},{57.51,8.76},{57.33,7.76},{56.51,9.4},{56.18,6.86},{56.28,7.55},{55.74,7.7},{57.2,7.15},{56.65,7.16},{56.03,8.32},{56.6,8.89},{56.34,8.77},{56.25,9.47},{56.96,7.14},{56.09,9.79},{55.94,8.76},{56.2,8.36},{56.14,7.25},{55.79,8.07},{56.09,9.16},{55.68,9.46},{55.69,8.4},{56.79,9.15},{57.62,8.23},{56.39,7.39},{57.33,7.39},{56.73,8.82},{57.27,9.16},{56.55,9.12},{56.38,8.21},{57.29,8.93},{55.68,7.24},{56.35,8.54},{56.09,8.58},{55.9,7.39}}},nil,17,nil,nil,47,nil,nil,0},
[3285] = {'Venture Co. Peon',273,300,13,14,0,{[17]={{52.65,11.74},{52.19,11.23},{52.61,10.36},{52.13,11.67},{53.18,10.34},{52.98,11.22},{53.4,12.22},{52.37,11.83},{51.99,11.47},{51.99,11.87},{52.19,11.49},{53.24,10.4},{53.07,10.87},{52.67,10.81},{53.09,10.34}}},nil,17,nil,nil,47,nil,nil,0},
[3286] = {'Venture Co. Overseer',328,417,15,18,0,{[17]={{60.4,3.58},{60.33,4.13},{61.42,5.3},{59.65,2.88},{61.87,3.97},{59.96,3.78},{59.84,3.92},{60.66,3.79},{59.92,3.71},{61.74,3.33},{59.62,2.77},{59.63,3.78},{61.95,3.58},{61.91,4.25},{59.54,3.06},{61.86,4.89},{60.55,3.77},{59.95,3.14},{61.86,5.41},{61.19,5.5},{61.62,4.95},{62.3,3.81}}},nil,17,nil,nil,47,nil,nil,0},
[3287] = {'Hana\'zua',55,55,2,2,0,{[14]={{40.6,62.58}}},nil,14,{790,804},{790},126,"H",nil,2},
[3289] = {'Spirit of Minshina',222,222,11,11,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3290] = {'Deek Fizzlebizz',840,840,27,27,0,{[38]={{45.91,13.44}}},nil,38,nil,nil,875,"A","Journeyman Engineer",19},
[3291] = {'Greishan Ironstove',664,664,24,24,0,{[38]={{25.55,11.83}}},{[38]={{{25.56,10.49},{25.6,12.71},{25.69,13.73},{25.88,14.71},{25.9,15.33},{25.97,16.04},{25.99,18.7},{26.13,20.53},{26.68,22.96},{26.96,23.68},{28.05,25.67},{28.44,27.16},{28.95,28.85},{29.64,30.47},{30.22,32.73},{30.39,33.87},{30.43,34.62},{30.83,37.18},{31.07,38.76},{31.26,39.28},{31.85,40.32},{32.16,41.03},{32.21,41.35},{32.17,42.61},{32.01,43.31},{31.67,44.06},{31.38,45.3},{31.29,46.77},{31.39,47.77},{31.65,48.32},{32.0,48.97},{32.19,49.7},{32.38,49.85},{32.61,49.79},{33.12,49.33},{33.96,48.13},{34.82,47.08},{35.53,46.77},{36.0,46.42},{36.27,46.3},{36.91,46.18},{37.32,45.68},{37.4,44.56},{37.23,42.93},{36.76,41.95},{37.15,42.94},{37.35,44.53},{37.26,45.6},{36.89,46.11},{36.14,46.31},{35.46,46.71},{35.01,46.85},{34.51,47.3},{33.18,49.22},{32.34,50.21},{32.27,51.4},{31.87,53.56},{31.5,56.13},{31.31,57.02},{30.6,58.02},{29.9,58.99},{29.39,60.31},{29.18,60.85},{28.73,62.37},{28.15,64.72},{28.0,65.4},{27.65,65.84},{26.95,66.15},{25.61,67.42},{25.09,67.7},{24.72,68.13},{23.66,69.68},{22.89,70.76},{21.82,72.41},{21.4,72.95},{20.61,74.75},{20.48,75.04},{21.0,75.84},{21.76,76.77},{22.33,77.26},{22.79,77.12},{23.17,76.68},{23.4,76.25},{22.99,76.93},{22.36,77.31},{22.05,77.15},{21.34,76.2},{20.62,75.25},{20.68,74.66},{21.4,73.14},{22.15,72.1},{23.0,70.87},{24.01,69.42},{24.85,68.14},{25.44,67.55},{25.85,67.35},{26.72,66.46},{27.47,65.99},{27.88,65.74},{28.14,65.35},{28.48,63.79},{28.83,62.45},{29.36,60.76},{29.9,59.03},{30.91,57.8},{31.39,57.09},{31.56,56.74},{31.89,54.41},{32.15,52.67},{32.29,50.88},{32.28,49.7},{32.15,49.19},{31.87,48.55},{31.5,47.72},{31.36,46.73},{31.45,45.49},{31.63,44.67},{31.91,43.78},{32.17,43.17},{32.32,42.24},{32.34,41.06},{31.93,40.34},{31.48,39.49},{31.15,38.59},{30.97,37.55},{30.74,35.81},{30.46,33.67},{30.07,31.46},{29.4,29.65},{28.93,28.4},{28.28,26.15},{28.03,25.37},{27.22,23.91},{26.9,23.33},{26.43,21.6},{26.18,19.78},{26.16,18.06},{26.14,15.83},{26.05,15.01},{25.76,13.72},{25.62,11.67}}}},38,nil,nil,55,"A","Traveling Merchant",6},
[3292] = {'Brewmaster Drohn',176,176,9,9,0,{[17]={{62.26,38.39}}},nil,17,{821,822},{819,821,822},29,"H",nil,3},
[3293] = {'Rezlak',102,102,5,5,0,{[14]={{46.37,22.94}}},nil,14,{834,835},{834,835},69,"AH","Tinkers' Union",3},
[3294] = {'Ophek',198,198,10,10,0,{[14]={{54.37,41.29}}},nil,14,{1506},nil,29,"H",nil,2},
[3295] = {'Sludge Beast',449,449,19,19,4,{[17]={{56.72,8.17}}},nil,17,nil,nil,14,nil,nil,0},
[3296] = {'Orgrimmar Grunt',5228,5228,55,55,0,{[1637]={{29.9,63.26},{67.64,24.01},{17.12,60.13},{49.92,78.73},{50.83,35.52},{53.27,84.68},{67.6,39.69},{45.58,53.32},{51.74,84.93},{41.5,62.36},{74.88,33.23},{51.0,45.8},{49.05,34.35},{40.6,64.21},{51.37,58.16},{42.71,69.57},{49.56,37.65},{49.86,94.78},{57.36,41.09},{50.89,74.58},{42.36,68.95},{17.76,61.72},{53.03,36.94},{63.0,39.3},{48.74,76.56},{67.94,38.92},{52.42,41.42},{76.58,38.83},{51.84,36.04},{44.3,55.04},{45.85,64.71},{44.67,54.02},{74.09,28.83},{45.93,77.13},{56.61,62.58},{29.67,61.74},{42.39,39.74},{49.49,34.53},{54.7,37.41},{37.66,55.85},{62.65,38.5},{53.1,80.79},{48.96,93.19},{48.47,76.13},{58.94,47.53},{56.51,64.31},{75.39,15.76},{16.47,62.96},{40.8,69.85},{35.39,74.24},{49.59,70.37},{54.85,71.67},{48.34,95.07},{41.32,56.16},{74.81,15.26},{53.39,80.17},{61.75,41.44},{36.61,75.65},{53.51,34.3},{50.48,72.4},{48.42,59.5},{67.25,38.87},{15.85,61.47},{62.7,39.09},{49.9,59.85},{35.55,75.63},{42.72,62.42},{48.86,37.76},{57.28,41.88},{48.23,48.83},{41.7,42.44},{55.83,61.78},{31.27,68.94},{31.16,68.59}},[14]={{50.51,13.49},{50.48,13.27}}},nil,1637,nil,nil,85,"H",nil,1},
[3297] = {'Sen\'jin Watcher',1398,1910,25,30,0,{[14]={{56.02,75.25},{55.21,74.78},{56.33,74.59},{56.26,72.62},{56.24,74.92},{55.38,73.45},{56.39,73.7}}},nil,14,nil,nil,877,"H",nil,268435456},
[3298] = {'Gabrielle Chase',3066,3066,53,53,0,{[46]={{84.24,67.78}}},nil,46,nil,nil,12,"A","Food & Drink",6},
[3300] = {'Adder',1,1,1,1,0,{[14]={{44.39,19.94},{45.48,25.59},{56.27,43.9},{54.19,77.84},{53.83,54.85},{38.04,23.22},{48.79,15.38},{38.41,36.53},{52.2,71.51},{39.79,34.27},{37.1,55.1},{54.22,15.16},{36.1,53.1},{53.06,53.0},{57.6,49.43},{41.82,36.17},{53.3,53.82},{56.72,45.85},{42.04,29.15},{44.15,29.66},{45.32,62.34},{53.21,19.52},{53.01,12.48},{42.29,32.51},{36.56,32.56},{39.98,47.59},{44.12,33.49},{50.16,45.07},{41.48,46.05},{57.31,28.35},{40.53,18.89},{57.79,72.15},{46.65,64.14},{40.5,21.6},{39.43,22.1},{39.2,45.83},{57.35,25.67},{42.97,63.58},{43.98,59.72},{51.1,48.41},{43.62,42.85},{54.11,62.92},{44.97,17.08},{42.36,17.31},{45.28,17.8}},[17]={{37.21,27.68},{54.89,51.52},{45.03,84.65},{44.84,74.23},{61.72,33.34},{47.82,37.43},{51.5,17.93},{49.96,46.74},{38.59,15.79},{50.02,50.13},{57.32,34.46},{46.06,42.48},{47.74,64.13},{57.76,43.7},{56.38,48.23},{60.29,30.8},{48.47,52.17},{50.01,59.99},{53.64,30.11},{40.16,29.28},{53.8,49.47},{57.04,22.11},{43.79,56.72},{45.34,29.66},{50.54,53.51},{43.99,33.25},{56.03,15.83},{42.5,59.72},{59.69,17.78},{51.99,56.79},{43.59,36.11},{54.55,44.97},{50.6,14.61},{43.88,53.67},{46.34,24.46},{47.84,45.66},{45.74,49.22},{61.4,20.84},{60.08,35.7},{47.97,49.82},{48.02,60.2},{44.41,46.73},{44.37,38.3},{41.98,28.27},{41.33,32.52},{47.44,77.4},{44.17,80.02},{47.77,80.34},{46.09,47.24},{46.13,51.77},{47.97,74.44},{53.85,27.45},{48.76,77.06},{41.65,21.35},{50.82,37.29},{59.69,27.22},{51.17,43.27},{45.04,76.85},{54.26,41.04},{45.97,66.71},{44.85,64.12}}},nil,17,nil,nil,7,"AH",nil,0},
[3301] = {'Morgan Ladimore',46,46,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3304] = {'Master Vornal',222,222,11,11,0,{[14]={{55.94,74.39}}},nil,14,{818},{818},126,"H",nil,2},
[3305] = {'Grisha',7842,7842,55,55,1,{[51]={{34.84,30.87}}},nil,51,nil,nil,29,"H","Wind Rider Master",11},
[3306] = {'Keldas',1752,1752,40,40,0,{[141]={{56.79,59.78}}},nil,141,nil,nil,80,"A","Pet Trainer",19},
[3309] = {'Karus',5544,5544,45,45,0,{[1637]={{49.58,69.12}}},nil,1637,nil,{4511},29,"H","Banker",259},
[3310] = {'Doras',7842,7842,55,55,1,{[1637]={{45.12,63.89}}},nil,1637,{6386},{6385},29,"H","Wind Rider Master",11},
[3312] = {'Olvia',2768,2768,50,50,0,{[1637]={{44.68,70.01}}},nil,1637,nil,nil,29,"H","Meat Vendor",6},
[3313] = {'Trak\'gen',1002,1002,30,30,0,{[1637]={{48.12,80.53}}},nil,1637,nil,nil,29,"H","General Goods Merchant",6},
[3314] = {'Urtharo',1002,1002,30,30,0,{[1637]={{47.56,68.38}}},nil,1637,nil,nil,29,"H","Weapon Merchant",16389},
[3315] = {'Tor\'phan',1002,1002,30,30,0,{[1637]={{62.81,50.44}}},nil,1637,nil,nil,29,"H","Cloth & Leather Armor Merchant",16388},
[3316] = {'Handor',1002,1002,30,30,0,{[1637]={{62.88,44.69}}},nil,1637,nil,nil,29,"H","Cloth & Leather Armor Merchant",16388},
[3317] = {'Ollanus',1002,1002,30,30,0,{[1637]={{56.52,73.77}}},nil,1637,nil,nil,29,"H","Light Armor Merchant",16388},
[3318] = {'Koma',5544,5544,45,45,0,{[1637]={{50.0,68.58}}},nil,1637,nil,nil,29,"H","Banker",257},
[3319] = {'Sana',1002,1002,30,30,0,{[1637]={{55.97,72.73}}},nil,1637,nil,nil,29,"H","Mail Armor Merchant",16388},
[3320] = {'Soran',5544,5544,45,45,0,{[1637]={{49.08,69.59}}},nil,1637,nil,nil,29,"H","Banker",257},
[3321] = {'Morgum',1002,1002,30,30,0,{[1637]={{56.24,73.21}}},nil,1637,nil,nil,29,"H","Leather Armor Merchant",16388},
[3322] = {'Kaja',1002,1002,30,30,0,{[1637]={{52.15,62.13}}},nil,1637,nil,nil,29,"H","Guns and Ammo Merchant",16388},
[3323] = {'Horthus',1002,1002,30,30,0,{[1637]={{45.43,56.55}}},nil,1637,nil,nil,29,"H","Reagents Vendor",4},
[3324] = {'Grol\'dar',2768,2768,50,50,0,{[1637]={{47.98,45.93}}},nil,1637,{8419},nil,29,"H","Warlock Trainer",19},
[3325] = {'Mirket',2768,2768,50,50,0,{[1637]={{48.62,46.95}}},nil,1637,{8419},nil,29,"H","Warlock Trainer",19},
[3326] = {'Zevrost',2768,2768,50,50,0,{[1637]={{48.47,45.43}}},nil,1637,{3631,4737,4967,8419},nil,29,"H","Warlock Trainer",19},
[3327] = {'Gest',1752,1752,40,40,0,{[1637]={{42.69,51.48}}},nil,1637,nil,nil,29,"H","Rogue Trainer",19},
[3328] = {'Ormok',2768,2768,50,50,0,{[1637]={{43.9,54.63}}},nil,1637,{8233},nil,29,"H","Rogue Trainer",19},
[3329] = {'Kor\'jus',1002,1002,30,30,0,{[1637]={{48.96,54.22}}},nil,1637,nil,nil,29,"H","Mushroom Vendor",4},
[3330] = {'Muragus',1002,1002,30,30,0,{[1637]={{44.35,48.11}}},nil,1637,nil,nil,29,"H","Staff Merchant",16388},
[3331] = {'Kareth',1002,1002,30,30,0,{[1637]={{45.65,55.96}}},nil,1637,nil,nil,29,"H","Blade Merchant",16388},
[3332] = {'Lumak',1342,1342,35,35,0,{[1637]={{69.8,29.21}}},nil,1637,{6608},nil,29,"H","Fishing Trainer",19},
[3333] = {'Shankys',1002,1002,30,30,0,{[1637]={{69.99,29.77}}},nil,1637,nil,nil,29,"H","Fishing Supplies",6},
[3334] = {'Rekkul',1002,1002,30,30,0,{[1637]={{42.09,49.48}}},nil,1637,nil,nil,29,"H","Poison Vendor",4},
[3335] = {'Hagrus',1002,1002,30,30,0,{[1637]={{45.99,45.68}}},nil,1637,nil,nil,29,"H","Reagents Vendor",4},
[3336] = {'Takrin Pathseeker',1002,1002,30,30,0,{[14]={{50.84,43.59}}},nil,14,{840},nil,29,"H",nil,2},
[3337] = {'Kargal Battlescar',328,328,15,15,0,{[17]={{62.26,19.38}}},nil,17,{842},{840},29,"H",nil,2},
[3338] = {'Sergra Darkthorn',61040,61040,60,60,1,{[17]={{52.23,31.01}}},nil,17,{844,845,881,903,905,3261},{842,844,845,860,881,903,905},125,"H",nil,2},
[3339] = {'Captain Thalo\'thas Brightsun',712,712,25,25,0,{[17]={{62.29,39.03}}},nil,17,{891},{891,898},69,"AH",nil,2},
[3341] = {'Gann Stonespire',417,417,18,18,0,{[17]={{45.89,77.0}}},{[17]={{{45.89,77.03},{45.89,77.03},{45.94,76.84},{46.05,76.52},{46.07,76.43},{46.08,76.01},{46.09,75.81},{46.11,75.62},{46.14,75.37},{46.14,75.37},{46.1,75.69},{46.1,75.89},{46.09,76.1},{46.07,76.39},{46.03,76.62},{45.9,76.95},{45.84,77.24},{45.8,77.81},{45.8,78.22},{45.82,78.51},{45.86,78.76},{45.97,78.99},{46.05,79.16},{46.13,79.37},{46.15,79.57},{46.13,79.96},{46.11,80.17},{46.1,80.37},{46.12,80.79},{46.12,80.99},{46.12,81.2},{46.11,81.41},{46.12,81.62},{46.11,82.03},{46.09,82.38},{46.1,82.59},{46.11,82.8},{46.12,83.21},{46.12,83.42},{46.12,83.62},{46.07,84.19},{45.98,84.38},{45.9,84.54},{45.74,84.88},{45.68,84.98},{45.75,84.8},{45.93,84.48},{46.04,84.24},{46.1,84.0},{46.12,83.61},{46.12,83.29},{46.12,83.09},{46.1,82.67},{46.1,82.48},{46.11,82.27},{46.13,81.88},{46.13,81.67},{46.12,81.46},{46.12,81.05},{46.12,81.05},{46.11,80.54},{46.11,80.33},{46.12,80.13},{46.14,79.69},{46.14,79.48},{46.08,79.19},{46.0,79.02},{45.92,78.85},{45.82,78.61},{45.79,78.16},{45.79,77.95},{45.8,77.46},{45.83,77.22}}}},17,{843,846,849},{843,846,849},104,"H",nil,3},
[3342] = {'Shan\'ti',1342,1342,35,35,0,{[1637]={{37.41,52.32}}},nil,1637,nil,nil,29,"H","Fruit Vendor",4},
[3343] = {'Grelkor',26140,26140,55,55,0,{[2597]={{49.68,82.46}}},nil,2597,nil,nil,1215,"H","Blacksmithing Supplies",16390},
[3344] = {'Kardris Dreamseeker',4120,4120,60,60,0,{[1637]={{38.8,36.37}}},nil,1637,{8410},nil,29,"H","Shaman Trainer",19},
[3345] = {'Godan',1342,1342,35,35,0,{[1637]={{53.9,38.67}}},nil,1637,nil,nil,29,"H","Expert Enchanter",17},
[3346] = {'Kithas',1342,1342,35,35,0,{[1637]={{53.88,38.02}}},nil,1637,nil,nil,29,"H","Enchanting Supplies",6},
[3347] = {'Yelmak',1342,1342,35,35,0,{[1637]={{56.84,33.03}}},nil,1637,nil,nil,29,"H","Expert Alchemist",17},
[3348] = {'Kor\'geld',1002,1002,30,30,0,{[1637]={{56.05,34.12}}},nil,1637,nil,nil,29,"H","Alchemy Supplies",4},
[3349] = {'Ukra\'nor',1002,1002,30,30,0,{[1637]={{29.74,74.17}}},nil,1637,nil,nil,29,"H","Staff Merchant",16388},
[3350] = {'Asoran',1002,1002,30,30,0,{[1637]={{46.07,40.87}}},nil,1637,nil,nil,29,"H","General Goods Vendor",6},
[3351] = {'Magenius',1002,1002,30,30,0,{[1637]={{45.74,40.94}}},nil,1637,nil,nil,29,"H","Reagents Vendor",4},
[3352] = {'Ormak Grimshot',4120,4120,60,60,0,{[1637]={{66.05,18.53}}},nil,1637,nil,{6081},29,"H","Hunter Trainer",19},
[3353] = {'Grezz Ragefist',4120,4120,60,60,0,{[1637]={{79.79,31.42}}},nil,1637,nil,nil,29,"H","Warrior Trainer",19},
[3354] = {'Sorek',2768,2768,50,50,0,{[1637]={{80.39,32.38}}},nil,1637,{1505,1718,1823,8417},nil,29,"H","Warrior Trainer",19},
[3355] = {'Saru Steelfury',2217,2217,45,45,0,{[1637]={{82.35,22.97}}},nil,1637,nil,nil,29,"H","Artisan Blacksmith",19},
[3356] = {'Sumi',1002,1002,30,30,0,{[1637]={{82.6,23.96}}},nil,1637,nil,nil,29,"H","Blacksmithing Supplier",16390},
[3357] = {'Makaru',1342,1342,35,35,0,{[1637]={{73.12,26.08}}},nil,1637,nil,nil,29,"H","Mining Trainer",19},
[3358] = {'Gorina',1002,1002,30,30,0,{[1637]={{73.31,26.6}}},nil,1637,nil,nil,29,"H","Mining Supplier",4},
[3359] = {'Kiro',1002,1002,30,30,0,{[1637]={{73.26,42.25}}},nil,1637,nil,nil,29,"H","War Harness Maker",16388},
[3360] = {'Koru',1002,1002,30,30,0,{[1637]={{81.48,18.74}}},nil,1637,nil,nil,29,"H","Mace & Staves Vendor",16388},
[3361] = {'Shoma',1002,1002,30,30,0,{[1637]={{81.59,18.86}}},nil,1637,nil,nil,29,"H","Weapon Vendor",16388},
[3362] = {'Ogunaro Wolfrunner',2217,2217,45,45,0,{[1637]={{69.38,12.24}}},nil,1637,{7660,7661},{7660,7661},29,"H","Kennel Master",135},
[3363] = {'Magar',1342,1342,35,35,0,{[1637]={{63.65,49.93}}},nil,1637,nil,nil,29,"H","Expert Tailor",19},
[3364] = {'Borya',1002,1002,30,30,0,{[1637]={{63.08,51.45}}},nil,1637,nil,nil,29,"H","Tailoring Supplies",6},
[3365] = {'Karolek',1342,1342,35,35,0,{[1637]={{62.81,44.15}}},nil,1637,nil,nil,29,"H","Expert Leatherworker",19},
[3366] = {'Tamar',1002,1002,30,30,0,{[1637]={{63.05,45.53}}},nil,1637,nil,nil,29,"H","Leatherworking Supplies",6},
[3367] = {'Felika',1002,1002,30,30,0,{[1637]={{60.6,48.93}}},{[1637]={{{60.62,50.34},{60.71,52.34},{60.4,54.34},{59.38,56.14},{58.02,58.23},{56.89,58.3},{55.16,57.51},{54.01,57.03},{52.88,57.19},{52.06,57.98},{51.44,58.53},{50.83,58.73},{51.33,57.82},{51.9,57.4},{52.62,57.05},{53.71,56.81},{55.2,57.56},{56.5,58.54},{57.98,57.71},{59.31,56.34},{60.39,54.16},{60.51,51.35},{60.35,48.34},{61.09,45.98},{60.62,43.4},{60.36,41.01},{60.03,40.58},{59.14,39.42},{57.52,37.83},{55.53,36.27},{53.95,35.4},{52.04,35.63},{49.82,36.13},{49.08,36.26},{48.34,36.39},{46.51,36.62},{48.22,36.38},{48.96,36.23},{49.7,36.09},{50.52,35.94},{51.26,35.8},{53.33,35.55},{55.45,36.17},{57.24,38.16},{57.4,39.71},{56.75,41.34},{57.11,42.79},{57.42,43.81},{58.63,45.69},{59.29,47.25},{60.63,48.28}}}},1637,nil,nil,29,"H","General Trade Goods Merchant",6},
[3368] = {'Borstan',1002,1002,30,30,0,{[1637]={{57.2,53.32}}},nil,1637,nil,nil,29,"H","Meat Vendor",6},
[3369] = {'Gotri',1002,1002,30,30,0,{[1637]={{58.81,52.73}}},nil,1637,nil,nil,29,"H","Bag Vendor",6},
[3370] = {'Urtrun Clanbringer',2217,2217,45,45,0,{[1637]={{43.64,74.63}}},nil,1637,nil,nil,29,"H","Guild Master",1537},
[3371] = {'Tamaro',1002,1002,30,30,0,{[1637]={{56.18,46.05}}},nil,1637,nil,nil,29,"H",nil,0},
[3372] = {'Sarlek',1002,1002,30,30,0,{[1637]={{55.68,46.73}}},nil,1637,nil,nil,29,"H",nil,0},
[3373] = {'Arnok',1342,1342,35,35,0,{[1637]={{34.18,84.58}}},nil,1637,{6623},nil,29,"H","First Aid Trainer",19},
[3374] = {'Bael\'dun Excavator',531,573,21,22,0,{[17]={{48.42,86.01},{47.55,84.26},{47.49,84.05},{48.4,86.29},{47.27,85.74},{47.99,86.05},{47.75,85.9},{48.19,86.37},{47.06,83.87},{47.61,85.33},{47.38,84.14},{47.96,84.88},{47.62,84.51},{48.02,85.19},{48.06,85.48},{48.21,85.81},{46.92,85.89},{46.86,85.57},{47.07,85.85},{47.04,84.07},{46.89,84.28},{47.35,83.94},{47.22,84.95},{47.58,85.71},{47.82,85.47},{47.46,84.77},{47.21,85.24},{47.4,85.32},{47.71,84.63},{47.76,85.11}}},nil,17,nil,nil,122,"A",nil,0},
[3375] = {'Bael\'dun Foreman',573,617,22,23,0,{[17]={{48.1,85.94},{47.41,84.32},{47.72,84.91},{47.51,85.38},{47.44,85.51}}},nil,17,nil,nil,122,"A",nil,0},
[3376] = {'Bael\'dun Soldier',617,664,23,24,0,{[17]={{49.43,83.94},{49.15,84.13},{49.71,83.95},{49.35,84.09},{49.42,84.43},{49.74,83.93},{49.67,83.81},{48.69,84.83},{48.86,84.55},{48.8,84.35},{49.1,84.66},{49.18,84.13},{49.3,84.54},{49.23,84.26},{48.34,84.16},{48.45,83.77},{49.55,83.6}}},nil,17,nil,nil,122,"A",nil,0},
[3377] = {'Bael\'dun Rifleman',664,713,24,25,0,{[17]={{48.86,84.55},{48.8,84.35},{49.34,84.44},{49.45,84.33},{49.27,84.23},{49.55,84.32},{49.38,83.89},{49.5,84.17},{48.54,84.63},{48.93,84.31},{48.9,84.91},{49.03,84.32},{48.89,84.02},{49.12,83.86},{48.65,83.89},{48.58,84.1},{49.39,83.71}}},nil,17,nil,nil,122,"A",nil,0},
[3378] = {'Bael\'dun Officer',788,788,26,26,0,{[17]={{49.24,83.81},{49.22,84.08},{49.76,84.11},{49.21,84.31},{49.51,84.34},{49.14,83.91},{49.61,83.59},{49.49,83.96},{48.64,84.24},{49.39,84.13}}},nil,17,nil,nil,122,"A",nil,0},
[3379] = {'Burning Blade Bruiser',198,222,10,11,0,{[17]={{48.35,18.76},{47.17,19.1},{47.78,18.1},{47.87,15.84},{47.64,17.89},{47.85,19.15},{47.71,19.18},{48.07,18.86},{46.29,18.13},{47.21,18.66},{48.23,15.14},{47.39,19.45},{48.48,18.96},{47.91,14.92},{47.95,18.04},{47.0,15.83},{46.68,18.04},{47.38,18.68},{46.5,17.94},{47.38,19.08},{47.54,19.22},{47.58,15.02},{47.79,17.89},{46.33,18.03},{46.47,18.23},{46.66,18.23}}},nil,17,nil,nil,554,nil,nil,0},
[3380] = {'Burning Blade Acolyte',199,219,11,12,0,{[17]={{48.37,18.65},{47.49,19.45},{47.52,19.02},{48.04,19.03},{48.26,15.45},{47.92,15.4},{47.66,18.02},{47.21,18.32},{47.87,17.91},{48.06,19.2},{46.54,18.11},{47.69,19.47},{47.83,18.06},{47.56,15.41},{47.63,18.78},{46.91,15.82},{47.34,19.27},{48.46,19.03},{48.14,19.34}}},nil,17,nil,nil,554,nil,nil,0},
[3381] = {'Southsea Brigand',247,273,12,13,0,{[17]={{64.43,46.71},{64.4,44.07},{64.46,43.91},{63.58,46.24},{63.67,46.13},{64.28,47.18},{63.61,48.94},{64.22,43.45},{64.08,43.94},{64.16,44.28},{63.9,45.32},{63.9,44.89},{63.62,45.7},{63.83,45.85},{63.82,46.9},{64.01,47.33},{63.92,49.18},{63.83,48.33},{63.54,49.18},{62.69,49.66},{63.61,49.31},{62.85,50.2},{63.58,43.35},{63.59,44.4}}},nil,17,nil,nil,230,nil,nil,0},
[3382] = {'Southsea Cannoneer',273,300,13,14,0,{[17]={{62.92,44.04},{63.58,46.07},{64.16,46.83},{64.59,44.06},{64.31,47.32},{64.19,47.77},{64.44,47.02},{63.51,45.9},{63.58,46.69},{63.89,46.35},{63.78,49.46},{63.87,48.82},{63.66,49.26},{63.13,49.25},{62.72,49.79},{62.94,49.7},{62.55,49.5},{62.64,50.19},{63.86,43.83}}},nil,17,nil,nil,230,nil,nil,0},
[3383] = {'Southsea Cutthroat',222,295,12,15,0,{[17]={{62.28,44.34},{62.2,43.4},{62.2,45.72},{61.4,44.3},{62.18,45.39},{61.95,43.76},{61.62,44.26},{61.96,45.11},{61.53,48.03},{61.94,45.56},{61.49,48.87},{61.5,43.92},{61.28,49.29},{62.24,46.13},{61.26,48.24},{61.98,45.96},{62.18,43.97},{62.48,44.86},{62.55,46.25},{62.28,47.63},{62.44,47.27},{61.96,47.76}}},nil,17,nil,nil,230,nil,nil,0},
[3384] = {'Southsea Privateer',247,328,12,15,0,{[17]={{61.38,44.18},{62.21,46.77},{61.6,47.97},{62.2,47.41},{61.45,48.95},{61.78,45.53},{61.89,44.42},{61.58,48.97},{62.08,44.08},{62.01,45.6},{62.21,46.05},{61.25,48.72},{61.51,49.22},{62.21,44.82},{62.49,45.8},{62.53,46.69},{61.89,48.21}}},nil,17,nil,nil,230,nil,nil,0},
[3385] = {'Theramore Marine',328,356,15,16,0,{[17]={{60.12,54.17},{60.89,54.99},{61.27,55.69},{62.38,56.31},{62.53,52.56},{61.46,53.41},{62.07,55.14},{61.94,55.28},{63.13,56.64},{61.53,53.46},{61.79,53.54},{61.86,54.42},{61.59,53.95},{62.28,52.17},{60.77,55.62},{62.01,55.07},{60.49,54.36},{61.69,53.78},{62.76,56.48},{61.35,53.11},{60.43,54.93},{62.0,54.75},{62.27,56.45},{61.63,53.67},{60.98,55.63},{62.24,54.06},{63.05,56.6},{61.24,53.45},{61.6,55.07},{60.86,54.88},{61.48,53.94},{61.94,54.9},{60.69,55.58},{61.8,54.84},{60.57,55.3},{62.52,56.85},{61.62,56.05},{60.67,55.22},{61.37,55.48},{62.69,56.89},{61.06,53.64},{62.18,56.32},{62.33,54.16},{60.38,54.09},{62.01,51.66},{60.24,52.07},{60.8,52.59},{61.19,52.08},{60.57,52.34},{61.57,52.1},{62.15,53.14},{61.94,52.41},{62.16,53.63},{62.07,53.54},{62.35,53.33},{61.85,54.87},{62.19,54.02},{61.81,55.05},{61.77,55.11},{61.76,54.95},{61.9,55.11},{61.92,54.94},{61.72,54.79},{62.01,55.05},{61.8,54.84},{62.46,56.41},{61.56,54.84}}},nil,17,nil,nil,1077,"A",nil,0},
[3386] = {'Theramore Preserver',325,350,16,17,0,{[17]={{61.43,53.64},{61.37,55.7},{61.99,55.21},{60.48,55.46},{62.21,54.14},{60.52,54.86},{60.45,54.83},{62.19,56.45},{61.31,53.43},{61.04,53.73},{61.8,54.93},{63.09,56.74},{61.75,53.44},{61.83,54.67},{63.09,56.75}}},nil,17,nil,nil,1077,"A",nil,0},
[3387] = {'Jorn Skyseer',1162,1162,32,32,0,{[17]={{44.86,59.14}}},nil,17,{874,882,907,913,1130,6382},{882,883,884,885,897,907,913,3261},83,"H",nil,3},
[3388] = {'Mahren Skyseer',1162,1162,32,32,0,{[17]={{65.84,43.86}}},nil,17,{873},{873,874},35,"AH",nil,2},
[3389] = {'Regthar Deathgate',895,895,28,28,0,{[17]={{45.34,28.41}}},nil,17,{850,851,852,855,1362,4021},{850,851,852,855,1361,4021},125,"H",nil,3},
[3390] = {'Apothecary Helbrim',573,573,22,22,0,{[17]={{51.44,30.15}}},nil,17,{848,853,1492},{848,1358},68,"H",nil,2},
[3391] = {'Gazlowe',4120,4120,60,60,0,{[17]={{62.68,36.23}}},nil,17,{887,888,890,1180},{887,888,892,895,1178},69,"AH",nil,2},
[3392] = {'Prospector Khazgorm',683,683,26,26,0,{[17]={{47.44,85.75},{47.5,85.06},{48.33,86.16},{47.94,85.68}}},nil,17,nil,nil,122,"A","Explorers' League",0},
[3393] = {'Captain Fairmount',484,484,20,20,0,{[17]={{61.85,54.65}}},nil,17,nil,nil,1077,"A",nil,0},
[3394] = {'Barak Kodobane',356,356,16,16,0,{[17]={{42.8,23.52}}},{[17]={{{42.81,23.52},{42.86,23.49},{42.96,23.48},{42.87,23.48},{42.82,23.5},{42.75,23.59},{42.66,23.73},{42.5,24.05},{42.59,23.9},{42.65,23.76},{42.73,23.61},{42.8,23.5}}}},17,nil,nil,16,nil,nil,0},
[3395] = {'Verog the Dervish',417,417,18,18,0,nil,nil,0,nil,nil,90,nil,nil,0},
[3396] = {'Hezrul Bloodmark',449,449,19,19,0,{[17]={{46.04,41.14}}},{[17]={{{45.88,40.83},{45.62,40.29},{45.25,39.68},{45.09,39.42},{44.99,39.08},{45.1,38.68},{45.28,38.51},{45.52,38.3},{45.8,37.88},{45.85,37.39},{45.97,37.14},{46.15,37.01},{46.28,36.91},{46.47,37.13},{46.63,37.48},{46.65,37.76},{46.74,38.33},{46.9,38.61},{47.27,39.08},{47.82,39.44},{48.24,39.58},{48.51,39.84},{48.56,40.41},{48.36,40.71},{47.97,40.97},{47.38,41.5},{47.01,41.88},{46.75,42.06},{46.48,41.91},{46.24,41.66},{46.04,41.14}}}},17,nil,nil,16,nil,nil,0},
[3397] = {'Kolkar Bloodcharger',234,255,14,15,0,{[17]={{46.02,41.16},{46.05,41.17},{52.78,41.78},{52.87,44.51},{53.49,40.55},{53.49,40.85},{52.92,44.86},{55.36,43.87},{56.3,41.91},{54.66,42.88},{55.34,41.33},{57.15,41.04},{55.91,45.97},{56.75,43.41},{56.82,43.62},{54.38,40.9},{56.38,42.38},{56.49,41.61}}},nil,17,nil,nil,130,nil,nil,0},
[3398] = {'Gesharahan',1452,1452,20,20,2,{[17]={{46.52,39.46}}},nil,17,nil,nil,16,nil,nil,0},
[3399] = {'Zamja',1342,1342,35,35,0,{[1637]={{57.4,53.96}}},nil,1637,{6611},nil,126,"H","Cooking Trainer",19},
[3400] = {'Xen\'to',1002,1002,30,30,0,{[1637]={{57.57,52.9}}},nil,1637,nil,nil,126,"H","Cooking Supplier",6},
[3401] = {'Shenthul',4120,4120,60,60,0,{[1637]={{43.05,53.74}}},nil,1637,{2379,2458,2460,2479},{2378,2380,2460,2478},126,"H","Rogue Trainer",19},
[3402] = {'Zando\'zan',1342,1342,35,35,0,{[1637]={{42.73,52.95}}},nil,1637,{2382},{2379},126,"H",nil,3},
[3403] = {'Sian\'tsu',1752,1752,40,40,0,{[1637]={{37.84,36.45}}},nil,1637,{8410},nil,29,"H","Shaman Trainer",19},
[3404] = {'Jandi',1342,1342,35,35,0,{[1637]={{55.62,39.46}}},nil,1637,nil,nil,126,"H","Herbalism Trainer",16},
[3405] = {'Zeal\'aya',1002,1002,30,30,0,{[1637]={{54.97,39.45}}},nil,1637,nil,nil,126,"H","Herbalism Supplier",6},
[3406] = {'Xor\'juul',2768,2768,50,50,0,{[1637]={{67.24,20.2}}},nil,1637,{8151},nil,29,"H","Hunter Trainer",19},
[3407] = {'Sian\'dur',1752,1752,40,40,0,{[1637]={{67.96,17.8}}},nil,1637,{6069,6070},nil,29,"H","Hunter Trainer",19},
[3408] = {'Zel\'mak',1752,1752,40,40,0,{[1637]={{80.38,29.5}}},nil,1637,nil,nil,29,"H","Warrior Trainer",19},
[3409] = {'Zendo\'jian',1002,1002,30,30,0,{[1637]={{81.15,18.67}}},nil,1637,nil,nil,29,"H","Weapon Vendor",4},
[3410] = {'Jin\'sora',1002,1002,30,30,0,{[1637]={{78.09,38.46}}},nil,1637,nil,nil,29,"H","Bow Merchant",4},
[3411] = {'Denni\'ka',712,712,25,25,0,{[406]={{73.59,95.36}}},nil,406,nil,nil,126,"H","Butcher",7},
[3412] = {'Nogg',1342,1342,35,35,0,{[1637]={{75.99,25.41}}},nil,1637,{2841,2950},{2841,2949,2950},29,"H","Expert Engineer",19},
[3413] = {'Sovik',1002,1002,30,30,0,{[1637]={{75.49,25.36}}},nil,1637,{2842},nil,29,"H","Engineering Supplies",7},
[3414] = {'General Twinbraid',1002,1002,30,30,0,{[17]={{49.19,84.21}}},nil,17,nil,nil,122,"A",nil,0},
[3415] = {'Savannah Huntress',222,247,11,12,0,{[17]={{50.24,23.42},{54.76,30.5},{50.18,16.29},{54.88,31.05},{51.5,20.17},{50.35,23.54},{50.41,15.64},{51.15,21.07},{51.01,20.37},{49.99,15.42},{49.72,15.14},{54.96,29.01},{51.17,20.75},{49.77,15.29},{54.67,30.8},{50.23,23.0},{49.64,15.58},{51.63,20.74},{55.21,30.75},{51.13,21.28},{55.02,30.14},{55.6,30.45},{49.97,23.54},{51.21,23.99},{50.81,23.2},{54.87,29.57},{54.76,30.0},{50.39,15.2},{56.0,16.73},{55.76,16.63},{51.74,25.71},{51.28,27.11},{50.72,31.45},{53.88,31.06},{51.75,25.99},{54.53,30.39},{52.01,26.11},{54.32,29.99},{51.35,26.2},{49.35,26.92},{54.34,31.39},{49.5,27.59},{49.1,27.6},{53.56,27.54},{50.01,31.79},{54.32,29.38},{53.43,27.19}}},nil,17,nil,nil,16,nil,nil,0},
[3416] = {'Savannah Matriarch',386,417,17,18,0,{[17]={{61.37,34.59},{59.54,32.02},{60.49,33.39},{62.09,32.46},{61.92,32.31},{61.71,32.42},{61.86,33.39},{62.84,33.51},{62.17,33.0},{61.72,33.07}}},nil,17,nil,nil,16,nil,nil,0},
[3417] = {'Living Flame',71,77,16,17,0,nil,nil,0,nil,nil,17,nil,nil,0},
[3418] = {'Kirge Sternhorn',573,573,22,22,0,{[17]={{44.88,58.61}}},nil,17,{854},nil,104,"H",nil,3},
[3419] = {'Apothecary Zamah',573,573,22,22,0,{[1638]={{22.81,20.89}}},nil,1638,{962,1065,1086},{853,962,1064,1067,1086},68,"H","Royal Apothecary Society",2},
[3421] = {'Feegly the Exiled',457,457,19,19,0,{[17]={{48.97,86.31}}},nil,17,{857},{857},29,"H",nil,2},
[3424] = {'Thunderhawk Cloudscraper',442,508,20,22,0,{[17]={{50.05,60.51},{45.53,66.97},{48.81,62.31},{46.69,61.49},{48.13,60.05},{44.77,63.05}}},nil,17,nil,nil,14,nil,nil,0},
[3425] = {'Savannah Prowler',300,328,14,15,0,{[17]={{43.03,33.09},{54.0,15.24},{53.76,15.28},{55.8,14.76},{62.62,27.47},{60.24,7.86},{42.93,33.39},{43.6,39.08},{42.44,34.62},{41.0,26.77},{53.74,13.54},{53.86,14.09},{54.2,15.08},{60.62,7.89},{62.81,28.73},{63.21,29.52},{43.4,35.32},{40.89,20.83},{40.94,26.62},{43.77,35.4},{54.74,15.11},{54.65,14.61},{54.84,14.8},{63.16,28.07},{43.84,32.59},{40.95,21.48},{43.73,37.94},{41.45,24.18},{41.2,27.02},{40.97,27.17},{40.4,20.16},{43.93,32.92},{55.6,16.53},{53.84,15.0},{54.54,14.51},{55.69,15.93},{53.16,15.51},{63.26,7.29},{43.56,35.14},{41.31,24.32},{42.0,23.51},{53.69,15.7},{54.0,15.54},{55.83,16.14},{63.53,5.34},{63.12,27.5},{63.48,5.92},{41.03,21.03},{42.65,32.7},{55.65,14.58},{54.0,13.48},{55.47,16.01},{40.77,22.86},{42.7,34.63},{43.56,35.5},{53.7,13.93},{40.3,20.7},{41.4,28.7},{55.65,15.06},{54.99,15.16},{42.25,32.43},{42.6,28.85},{42.36,32.77},{55.6,16.32},{55.49,14.85},{53.3,16.08},{40.99,21.23},{41.13,20.79},{44.18,32.8},{41.72,23.26},{43.58,39.42},{42.62,33.03},{44.23,31.21},{55.01,14.86},{42.89,33.75},{41.29,28.39},{42.8,33.37},{43.23,33.31},{42.77,35.02},{40.66,20.98},{44.16,31.63},{43.47,39.34},{42.51,35.12},{40.6,22.5},{41.56,28.73},{43.22,33.71},{40.29,20.5},{53.55,15.93},{59.68,34.41},{53.28,15.15},{63.69,6.29},{42.72,33.22},{40.85,26.28},{40.92,21.81},{53.47,15.4},{44.54,31.85},{43.84,37.59},{59.01,36.48},{57.74,39.3},{58.59,40.78},{59.34,40.82},{59.55,40.9},{59.23,41.0}}},nil,17,nil,nil,16,nil,nil,0},
[3426] = {'Zhevra Charger',386,417,17,18,0,{[17]={{46.78,14.37},{60.16,31.56},{60.34,11.18},{58.24,6.68},{39.5,25.06},{37.55,26.17},{37.66,27.0},{39.3,28.92},{46.42,43.64},{55.06,50.08},{52.17,46.71},{43.47,15.92},{43.73,14.47},{61.68,34.4},{36.3,28.05},{36.99,28.07},{52.64,48.92},{56.93,47.06},{44.21,42.74},{48.52,48.85},{47.91,11.67},{45.13,14.7},{43.87,13.47},{61.25,31.99},{48.01,49.88},{59.01,53.0},{45.29,16.08},{60.58,33.6},{54.01,47.89},{52.45,50.36},{48.31,48.51},{44.81,15.42},{42.39,14.65},{44.86,13.19},{48.16,12.26},{47.87,45.36},{59.87,49.76},{54.69,48.35},{44.61,43.68},{49.06,50.31},{49.8,49.18},{57.21,50.56},{56.28,48.83},{53.47,47.29},{56.02,49.29},{53.63,52.26},{56.64,47.51},{48.86,46.81},{47.44,44.35},{53.37,50.57},{60.55,32.71},{56.39,50.67},{61.33,50.14},{59.25,32.26},{62.55,33.0},{58.19,50.68},{49.47,46.4},{55.13,51.26}}},nil,17,nil,nil,189,"AH",nil,0},
[3428] = {'Korran',247,247,12,12,0,{[17]={{51.07,29.63}}},nil,17,{868,1145,1184},{868,1148},126,"H",nil,2},
[3429] = {'Thork',1981,1981,42,42,0,{[17]={{51.5,30.87}}},nil,17,{871,872,5041,6541},{854,871,872,906,5041},29,"H",nil,3},
[3430] = {'Mangletooth',386,386,17,17,0,{[17]={{44.55,59.26}}},nil,17,{878,879,889,906,5042,5043,5044,5045,5046,5052},{878,879,889,5042,5043,5044,5045,5046,5052},29,"H",nil,3},
[3431] = {'Grenthar',198,198,10,10,0,{[17]={{51.63,29.82}}},nil,17,nil,nil,126,"H",nil,2},
[3432] = {'Mankrik',328,328,15,15,0,{[17]={{51.95,31.58}}},nil,17,{899,4921},{899,4921},29,"H",nil,3},
[3433] = {'Tatternack Steelforge',300,300,14,14,0,{[17]={{45.1,57.68}}},nil,17,{893,1153},{893,1153},29,"H",nil,3},
[3434] = {'Nak',544,544,23,23,0,{[17]={{43.75,83.26}}},{[17]={{{43.75,83.26},{43.73,83.45},{43.74,83.61},{43.81,83.8},{43.92,83.98},{44.05,84.18},{44.13,84.27},{44.33,84.42},{44.52,84.39},{44.64,84.25},{44.63,83.99},{44.53,83.76},{44.43,83.56},{44.31,83.33},{44.17,83.12},{44.06,83.04},{43.9,83.02},{43.79,83.13}}}},17,nil,nil,16,nil,nil,0},
[3435] = {'Lok Orcbane',713,713,25,25,0,{[17]={{40.15,80.54}}},nil,17,nil,nil,16,nil,nil,0},
[3436] = {'Kuz',864,864,21,21,0,{[17]={{45.12,80.07}}},{[17]={{{45.12,80.07},{45.06,79.73},{44.84,79.46},{44.64,79.36},{44.42,79.29},{44.21,79.2},{44.07,79.15},{43.86,79.08},{43.64,79.01},{43.48,79.09},{43.36,79.38},{43.31,79.6},{43.29,79.87},{43.3,80.15},{43.34,80.36},{43.38,80.61},{43.43,80.83},{43.5,81.06},{43.62,81.36},{43.8,81.53},{43.99,81.53},{44.13,81.46},{44.21,81.4},{44.3,81.34},{44.45,81.2},{44.61,81.05},{44.81,80.99},{45.06,80.89},{45.24,80.83},{45.3,80.62},{45.24,80.34},{45.18,80.18}}}},17,nil,nil,16,nil,nil,0},
[3437] = {'Crekori Mudwater',328,328,15,15,0,nil,nil,0,nil,nil,16,nil,nil,0},
[3438] = {'Kreenig Snarlsnout',328,328,15,15,0,{[17]={{58.52,27.04}}},nil,17,nil,nil,109,nil,nil,0},
[3439] = {'Wizzlecrank\'s Shredder',417,417,18,18,0,{[17]={{56.52,7.45}}},nil,17,{858,863},{858},69,"AH",nil,2},
[3441] = {'Melor Stonehoof',4369,4369,62,62,0,{[1638]={{61.54,80.92}}},nil,1638,{860,1131,1136,1205},{861,1130,1131,1136,1205},83,"H",nil,2},
[3442] = {'Sputtervalve',328,328,15,15,0,{[17]={{62.98,37.22}}},nil,17,{894,1095,1483,3921},{863,902,1094},69,"AH","Tinkers' Union",3},
[3443] = {'Grub',273,273,13,13,0,{[17]={{55.31,31.79}}},nil,17,{862},{862},29,"H",nil,7},
[3444] = {'Dig Rat',42,42,1,1,0,{[17]={{49.35,83.92},{48.73,83.85},{49.77,84.13},{49.45,84.35},{47.67,85.28},{48.05,85.97},{49.6,83.76},{49.27,83.75},{48.33,86.25},{48.7,85.47},{49.46,84.47},{49.33,84.17},{47.34,84.99},{48.76,84.83}}},nil,17,nil,nil,7,"AH",nil,0},
[3445] = {'Supervisor Lugwizzle',417,417,18,18,0,{[17]={{56.27,8.58}}},{[17]={{{56.26,8.59},{56.36,8.53},{56.44,8.44},{56.45,8.33},{56.41,8.19},{56.34,8.16},{56.21,8.21},{56.19,8.36},{56.23,8.48}}}},17,nil,nil,47,nil,nil,0},
[3446] = {'Mebok Mizzyrix',386,386,17,17,0,{[17]={{62.37,37.62}}},nil,17,{865,866,1069,1221,1491},{865,866,1069,1221,1270,1491},69,"AH",nil,2},
[3447] = {'Pawe Mistrunner',664,664,24,24,0,{[1638]={{25.69,27.14}}},nil,1638,nil,nil,104,"H",nil,2},
[3448] = {'Tonga Runetotem',573,573,22,22,0,{[17]={{52.26,31.93}}},nil,17,{870,877,880,1489,3301,6128,6129},{870,877,880,886,6127,6128},104,"H",nil,3},
[3449] = {'Darsok Swiftdagger',300,300,14,14,0,{[17]={{51.62,30.9}}},nil,17,{867,875,876,1060},{867,875,876},29,"H",nil,2},
[3450] = {'Defias Companion',300,328,14,15,0,nil,nil,0,nil,nil,17,nil,nil,0},
[3451] = {'Pilot Wizzlecrank',328,328,15,15,0,nil,nil,0,nil,nil,69,"AH",nil,2},
[3452] = {'Serena Bloodfeather',629,629,20,20,0,{[17]={{39.16,12.17}}},nil,17,nil,nil,514,nil,nil,0},
[3453] = {'Wharfmaster Dizzywig',328,328,15,15,0,{[17]={{63.35,38.45}}},nil,17,{892,896,1040,1112},{890,896,1039,1111,1492},69,"AH",nil,2},
[3454] = {'Cannoneer Smythe',449,449,19,19,0,{[17]={{63.18,56.64}}},nil,17,nil,nil,1077,"A",nil,0},
[3455] = {'Cannoneer Whessan',449,449,19,19,0,{[17]={{60.43,54.77}}},nil,17,nil,nil,1077,"A",nil,0},
[3456] = {'Razormane Pathfinder',494,531,20,21,0,{[17]={{44.34,79.96},{43.97,80.51},{43.75,80.78},{44.29,80.21},{43.79,80.13},{44.18,80.75},{43.82,84.12},{43.19,81.23},{45.42,79.9},{44.66,81.17},{45.46,80.3},{42.56,80.45},{45.34,84.22}}},nil,17,nil,nil,109,nil,nil,0},
[3457] = {'Razormane Stalker',506,544,22,23,0,{[17]={{44.1,82.38},{44.14,83.78},{43.19,83.02},{42.67,82.88},{43.5,82.82},{43.8,82.33},{43.81,83.31},{43.38,83.3},{44.13,83.31},{42.92,82.54},{44.13,81.8},{42.53,81.81},{43.48,83.36},{42.5,81.32},{41.84,79.22},{41.93,78.74},{44.12,82.59},{42.6,82.65},{42.81,82.9},{43.56,83.67},{44.77,83.81},{44.23,82.64},{44.4,83.04}}},nil,17,nil,nil,109,nil,nil,0},
[3458] = {'Razormane Seer',544,582,23,24,0,{[17]={{42.99,83.28},{42.17,78.34},{42.5,82.33},{42.12,82.03},{41.49,78.67},{41.79,82.17},{44.47,83.34},{41.58,81.59},{43.82,82.81},{41.64,78.44},{41.74,78.7},{42.65,83.08},{41.47,82.32},{41.16,79.14},{42.6,78.97},{40.85,80.39},{40.5,80.82},{41.19,80.35},{42.05,81.25},{41.53,80.84},{42.05,81.53},{43.15,82.31}}},nil,17,nil,nil,109,nil,nil,0},
[3459] = {'Razormane Warfrenzy',664,713,24,25,0,{[17]={{41.29,78.8},{42.03,82.18},{41.38,79.28},{42.18,78.89},{41.51,78.32},{41.64,81.82},{41.62,78.93},{40.77,81.46},{42.22,81.65},{42.03,78.71},{41.16,79.86},{41.14,80.85},{40.85,80.78},{42.07,80.46},{42.12,81.06},{41.83,80.8},{41.75,81.3}}},nil,17,nil,nil,109,nil,nil,0},
[3460] = {'Mud Crawler',328,356,15,16,0,nil,nil,0,nil,nil,16,nil,nil,0},
[3461] = {'Oasis Snapjaw',328,356,15,16,0,{[17]={{46.1,38.85},{46.86,40.32},{46.47,40.48},{46.48,38.87},{56.03,42.84},{46.19,39.81},{47.11,39.89},{48.11,40.6},{47.98,40.05},{46.78,39.94},{46.56,39.78},{46.98,39.59},{47.74,40.22},{46.16,39.31},{55.97,41.98},{47.44,40.02},{46.23,38.34},{45.73,39.03},{48.07,39.92},{55.62,41.49},{46.77,39.46},{46.42,40.0},{55.67,42.88},{47.63,39.45},{45.85,39.41},{46.42,39.35},{55.6,42.43},{45.93,40.41},{56.09,42.4},{55.0,42.23},{55.09,42.98},{55.32,42.39},{55.34,41.93},{55.28,42.84},{55.63,43.61},{55.92,43.35},{55.66,43.27}}},nil,17,nil,nil,14,nil,nil,0},
[3462] = {'Elder Barrens Giraffe',573,617,22,23,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[3463] = {'Wandering Barrens Giraffe',417,449,18,19,0,{[17]={{49.94,55.22},{45.86,53.24},{46.04,47.87},{46.82,56.66},{48.1,51.23},{50.64,60.01},{46.1,45.85},{43.51,50.88},{46.66,50.84},{47.79,47.23},{52.65,54.62},{49.37,56.09},{45.32,48.78},{42.82,46.08},{48.5,56.02},{50.04,56.37},{46.11,56.68},{48.72,54.76},{52.13,56.88},{44.16,49.93},{43.93,45.82},{45.17,47.42},{44.47,57.21},{47.4,50.68},{46.55,45.24},{43.7,53.39},{46.7,49.23},{53.34,55.68},{45.76,46.33},{42.4,45.2},{44.11,46.77},{43.23,50.38},{45.79,49.25},{50.71,53.14},{45.4,56.2},{50.38,54.5},{52.04,53.49},{43.92,52.72},{44.61,56.45},{51.89,55.64},{49.46,58.56}}},nil,17,nil,nil,189,"AH",nil,0},
[3464] = {'Gazrog',712,712,25,25,0,{[17]={{51.93,30.32}}},nil,17,{869,1510,3281},{869,1509,3281},29,"H",nil,2},
[3465] = {'Gilthares Firebough',386,386,17,17,0,{[17]={{61.96,54.96}}},nil,17,{898},nil,35,"AH",nil,2},
[3466] = {'Zhevra Courser',494,531,20,21,0,{[17]={{45.03,67.1},{46.89,64.61},{46.55,65.56},{45.85,68.0},{46.69,69.29},{47.65,65.04},{44.74,64.61},{46.77,70.46},{49.98,60.94},{43.47,60.66},{47.14,64.05},{46.5,67.53},{47.95,64.76},{49.9,60.08},{48.15,61.41},{48.71,57.66},{44.84,62.66},{45.07,63.22},{46.79,62.67},{46.62,63.55},{48.67,61.7},{48.32,62.84},{48.83,62.32},{49.06,58.22},{47.79,60.99},{48.81,60.16},{46.24,62.54},{48.47,59.13},{44.51,61.34},{46.04,61.44},{48.16,59.27},{44.46,61.59},{46.48,62.04}}},nil,17,nil,nil,189,"AH",nil,0},
[3467] = {'Baron Longshore',356,356,16,16,0,{[17]={{64.21,47.13},{63.56,49.14},{62.61,49.74}}},nil,17,nil,nil,230,nil,"Southsea Freebooters",1},
[3468] = {'Ancient of Lore',6474,6474,62,62,0,{[1657]={{49.04,6.92}}},nil,1657,nil,nil,79,"A",nil,2},
[3469] = {'Ancient of War',6474,6474,62,62,0,{[1657]={{67.25,45.59}}},nil,1657,nil,nil,79,"A",nil,1},
[3470] = {'Rathorian',328,328,15,15,4,{[17]={{47.95,19.17}}},nil,17,nil,nil,16,nil,nil,0},
[3471] = {'Tinkerer Sniggles',356,356,16,16,0,{[17]={{52.84,10.39}}},nil,17,nil,nil,16,nil,nil,0},
[3472] = {'Washte Pawne',713,713,25,25,0,{[17]={{43.15,80.85},{44.81,78.88},{44.81,74.93},{47.44,79.87}}},nil,17,nil,nil,14,nil,nil,0},
[3473] = {'Owatanka',664,664,24,24,0,{[17]={{49.41,61.1},{49.4,59.09},{45.79,62.6},{44.14,62.13}}},nil,17,nil,nil,14,nil,nil,0},
[3474] = {'Lakota\'mani',573,573,22,22,0,{[17]={{47.41,51.29},{45.13,52.74},{50.09,53.2},{46.13,49.28}}},nil,17,nil,nil,15,"AH",nil,0},
[3475] = {'Echeyakee',356,356,16,16,0,nil,nil,0,nil,nil,66,nil,nil,0},
[3476] = {'Isha Awak',840,840,27,27,0,{[17]={{63.53,53.85}}},{[17]={{{63.55,52.72},{63.87,51.63},{64.12,50.63},{64.55,50.04},{64.96,49.44},{64.99,48.78},{64.96,49.44},{64.55,50.04},{64.12,50.63},{63.87,51.63},{63.55,52.72},{63.53,53.85}},{{63.55,52.72},{63.87,51.63},{64.12,50.63},{64.55,50.04},{64.96,49.44},{64.99,48.78},{64.96,49.44},{64.55,50.04},{64.12,50.63},{63.87,51.63},{63.55,52.72},{63.53,53.85}}}},17,nil,nil,16,nil,nil,0},
[3477] = {'Hraq',417,417,18,18,0,{[17]={{51.13,28.96}}},nil,17,nil,nil,29,"H","Blacksmithing Supplier",16390},
[3478] = {'Traugh',1106,1106,31,31,0,{[17]={{51.3,28.91}}},nil,17,nil,nil,29,"H","Expert Blacksmith",19},
[3479] = {'Nargal Deatheye',1342,1342,35,35,0,{[17]={{51.23,29.15}}},nil,17,nil,nil,29,"H","Weaponsmith",16388},
[3480] = {'Moorane Hearthgrain',417,417,18,18,0,{[17]={{52.37,30.54}}},nil,17,nil,nil,29,"H","Baker",6},
[3481] = {'Barg',300,300,14,14,0,{[17]={{51.67,29.95}}},nil,17,nil,nil,29,"H","General Supplies",6},
[3482] = {'Tari\'qa',300,300,14,14,0,{[17]={{51.68,30.04}}},nil,17,nil,nil,126,"H","Trade Supplies",6},
[3483] = {'Jahan Hawkwing',531,531,21,21,0,{[17]={{51.21,29.05}}},nil,17,{6361},{6364},29,"H","Leather & Mail Armor Merchant",16391},
[3484] = {'Kil\'hala',712,712,25,25,0,{[17]={{52.2,31.7}}},nil,17,{1946},{1945,1946},126,"H","Journeyman Tailor",19},
[3485] = {'Wrahk',417,417,18,18,0,{[17]={{52.25,31.69}}},nil,17,nil,nil,29,"H","Tailoring Supplies",6},
[3486] = {'Halija Whitestrider',449,449,19,19,0,{[17]={{52.25,31.86}}},nil,17,nil,nil,29,"H","Clothier",16388},
[3487] = {'Kalyimah Stormcloud',617,617,23,23,0,{[17]={{52.26,32.02}}},nil,17,nil,nil,126,"H","Bags & Sacks",6},
[3488] = {'Uthrok',356,356,16,16,0,{[17]={{51.11,29.06}}},nil,17,nil,nil,29,"H","Bowyer & Gunsmith",16388},
[3489] = {'Zargh',356,356,16,16,0,{[17]={{52.62,29.84}}},nil,17,{6365},{6386},29,"H","Butcher",7},
[3490] = {'Hula\'mahi',1002,1002,30,30,0,{[17]={{51.39,30.2}}},nil,17,nil,nil,126,"H","Reagents and Herbs",4},
[3491] = {'Ironzar',617,617,23,23,0,{[17]={{62.24,37.48}}},nil,17,nil,nil,69,"AH","Weaponsmith",16388},
[3492] = {'Vexspindle',664,664,24,24,0,{[17]={{62.16,38.45}}},nil,17,nil,nil,69,"AH","Cloth & Leather Armor Merchant",16388},
[3493] = {'Grazlix',617,617,23,23,0,{[17]={{62.21,38.41}}},nil,17,nil,nil,69,"AH","Armorer & Shieldcrafter",16388},
[3494] = {'Tinkerwiz',712,712,25,25,0,{[17]={{62.67,36.31}}},nil,17,{3633,3634,3637},nil,69,"AH","Journeyman Engineer",19},
[3495] = {'Gagsprocket',484,484,20,20,0,{[17]={{62.64,36.27}}},nil,17,nil,nil,69,"AH","Engineering Goods",6},
[3496] = {'Fuzruckle',5544,5544,45,45,0,{[17]={{62.64,37.42}}},nil,17,nil,nil,69,"AH","Banker",256},
[3497] = {'Kilxx',664,664,24,24,0,{[17]={{62.77,38.24}}},nil,17,nil,nil,69,"AH","Fisherman",4},
[3498] = {'Jazzik',573,573,22,22,0,{[17]={{61.92,38.8}}},nil,17,nil,nil,69,"AH","General Supplies",6},
[3499] = {'Ranik',573,573,22,22,0,{[17]={{61.93,38.7}}},nil,17,nil,nil,69,"AH","Trade Supplies",6},
[3500] = {'Tarhus',2845,2845,52,52,0,{[357]={{74.64,44.92}}},nil,357,nil,nil,104,"H","Reagent Vendor",4},
[3501] = {'Horde Guard',3048,3048,40,40,0,{[17]={{52.16,32.31},{51.75,24.4},{62.29,20.75},{62.05,19.48},{61.56,19.62},{62.41,19.65},{61.88,20.29},{62.17,20.01},{44.73,59.14},{45.66,58.18},{45.42,58.57},{44.96,59.11},{50.67,28.88},{51.67,24.44},{52.07,32.07},{45.35,57.89},{46.25,60.1},{44.45,58.47},{45.45,59.12},{46.07,58.58},{44.88,57.25},{45.18,58.72},{50.62,40.7},{50.64,40.69},{44.92,58.35},{45.08,58.25},{44.45,59.03},{51.68,24.41},{57.91,33.32},{57.12,32.94},{52.49,23.05},{52.27,29.23},{52.34,29.3},{52.41,29.32},{52.6,30.82},{56.98,31.57},{51.88,30.68},{51.52,31.14},{51.59,31.56},{57.88,33.32},{51.34,30.87},{52.5,31.11},{50.66,29.21},{51.96,32.2},{52.37,23.31},{57.15,33.3}}},nil,17,nil,nil,85,"H",nil,0},
[3502] = {'Ratchet Bruiser',5568,5568,57,57,0,{[17]={{63.65,38.46},{61.68,36.92},{63.62,38.72},{62.43,39.48},{61.08,37.43},{62.94,35.96},{61.24,38.41},{63.27,36.4},{63.71,38.53}}},nil,17,nil,nil,637,"AH",nil,1},
[3503] = {'Silithid Protector',417,449,18,19,0,{[17]={{45.48,72.46}}},nil,17,nil,nil,16,nil,nil,0},
[3504] = {'Gil',42,42,1,1,0,{[1519]={{47.61,64.26}}},nil,1519,nil,nil,12,"A",nil,0},
[3505] = {'Pat',42,42,1,1,0,{[1519]={{53.11,62.44}}},{[1519]={{{52.45,60.71},{52.05,60.7},{49.12,62.66},{48.98,62.15},{47.73,57.93},{48.05,54.79},{49.53,52.17},{49.6,50.88},{48.37,48.67},{49.82,46.86},{47.56,42.56},{45.84,42.13},{44.37,39.38},{41.77,42.14},{41.71,42.26},{41.68,42.18},{41.41,41.62},{38.94,36.73},{39.57,36.23},{40.33,37.93},{41.7,40.23},{44.68,39.37},{45.35,38.2},{45.21,38.18},{45.21,38.18},{45.21,38.18},{45.21,38.18},{46.67,35.23},{47.86,33.94},{49.12,35.52},{52.65,31.93},{51.54,28.63},{52.91,27.42},{54.42,25.93},{56.81,31.15},{57.02,32.28},{58.44,33.92},{60.68,34.62},{62.67,33.06},{66.39,28.98},{66.95,29.33},{68.11,30.27},{68.23,30.01},{68.23,30.01},{68.23,30.01},{68.23,30.01},{67.89,31.85},{66.88,33.67},{65.05,36.26},{62.9,39.32},{61.51,41.79},{61.43,43.99},{63.86,48.43},{62.46,50.05},{60.95,52.23},{60.11,50.99},{57.32,54.64},{58.77,57.77},{56.17,60.94},{62.22,72.6},{64.97,70.63},{66.19,73.16},{66.19,73.16},{66.19,73.16},{65.4,70.44},{62.51,72.03},{56.69,61.75},{53.59,63.89},{53.11,62.44}}}},1519,nil,nil,12,"A",nil,0},
[3507] = {'Andi',42,42,1,1,0,{[1519]={{53.12,62.65}}},{[1519]={{{52.36,60.66},{49.3,62.75},{48.88,62.26},{47.73,58.46},{47.67,57.68},{47.96,54.75},{49.5,52.39},{49.55,50.91},{48.23,48.71},{49.64,46.96},{47.49,42.64},{45.81,42.31},{44.43,39.57},{41.84,42.26},{41.63,42.19},{41.39,41.76},{38.9,36.87},{39.48,36.14},{40.34,37.68},{41.7,40.05},{44.57,39.38},{45.27,38.35},{45.23,38.34},{45.23,38.34},{45.23,38.34},{45.23,38.34},{46.46,35.33},{47.8,33.86},{49.13,35.38},{52.58,31.87},{51.53,28.75},{52.84,27.38},{54.35,25.92},{56.84,31.06},{57.04,32.17},{58.44,33.86},{60.6,34.56},{62.56,33.04},{66.32,28.9},{66.89,29.18},{67.96,30.31},{68.15,29.99},{68.15,29.99},{68.15,29.99},{68.15,29.99},{67.99,31.72},{66.99,33.54},{65.15,36.26},{63.03,39.27},{61.56,41.73},{61.42,43.67},{63.89,48.34},{62.57,50.07},{61.04,52.3},{60.12,51.14},{57.41,54.65},{58.79,57.61},{56.28,60.94},{62.22,72.43},{64.84,70.54},{66.2,72.94},{66.2,72.94},{66.2,72.94},{65.39,70.63},{62.52,72.22},{56.73,61.94},{53.65,63.92},{53.12,62.65}}}},1519,nil,nil,12,"A",nil,0},
[3508] = {'Mikey',42,42,1,1,0,{[1519]={{52.86,62.8}}},{[1519]={{{52.22,61.17},{49.35,63.12},{48.77,62.57},{47.13,57.71},{47.74,54.51},{49.64,52.08},{49.26,51.26},{47.86,48.65},{49.34,46.88},{47.29,42.91},{45.64,42.66},{44.26,39.89},{41.98,42.54},{41.67,42.71},{41.18,42.13},{38.58,37.15},{39.23,35.72},{40.52,37.39},{41.93,39.65},{44.43,39.16},{44.98,38.67},{44.98,38.66},{44.98,38.66},{44.98,38.66},{44.98,38.66},{46.26,35.01},{47.68,33.6},{49.29,35.19},{52.48,31.6},{51.36,28.84},{52.76,27.18},{54.23,25.71},{56.96,30.95},{57.14,32.02},{58.49,33.58},{60.55,34.22},{62.38,32.78},{66.25,28.63},{67.0,28.85},{67.82,29.95},{67.97,29.74},{67.97,29.74},{67.97,29.74},{67.97,29.74},{68.25,31.68},{67.13,33.76},{65.34,36.42},{63.15,39.47},{61.73,41.6},{61.56,43.53},{64.07,48.16},{62.64,50.35},{61.22,52.58},{60.0,51.34},{57.59,54.83},{58.98,57.43},{56.44,61.17},{62.46,72.2},{64.61,70.15},{66.41,72.66},{66.41,72.66},{66.41,72.66},{65.22,70.95},{62.38,72.47},{56.62,62.29},{53.81,64.19},{52.86,62.8}}}},1519,nil,nil,12,"A",nil,0},
[3509] = {'Geoff',42,42,1,1,0,{[1519]={{53.15,62.56}}},nil,1519,nil,nil,12,"A",nil,0},
[3510] = {'Twain',40,40,1,1,0,{[1519]={{53.06,62.75}}},{[1519]={{{52.32,60.83},{49.25,62.83},{48.91,62.34},{47.59,58.33},{47.51,57.67},{47.89,54.71},{49.7,52.17},{49.48,51.0},{48.11,48.72},{49.56,46.93},{47.4,42.76},{45.79,42.48},{44.32,39.57},{41.89,42.36},{41.71,42.4},{41.39,42.03},{38.86,37.1},{39.37,36.09},{40.36,37.49},{41.71,39.78},{44.45,39.41},{45.2,38.53},{45.19,38.48},{45.23,38.55},{45.23,38.55},{45.23,38.55},{46.34,35.32},{47.68,33.86},{49.15,35.24},{52.52,31.83},{51.49,28.82},{52.79,27.34},{54.29,25.91},{56.87,30.98},{57.03,32.04},{58.38,33.7},{60.51,34.45},{62.45,33.0},{66.26,28.88},{66.86,29.05},{67.82,30.29},{68.04,29.95},{68.04,29.95},{68.04,29.95},{68.04,29.95},{68.08,31.65},{67.08,33.52},{65.26,36.24},{63.13,39.23},{61.62,41.54},{61.47,43.49},{63.93,48.2},{62.65,50.1},{61.13,52.35},{60.13,51.26},{57.5,54.64},{58.79,57.47},{56.41,60.94},{62.28,72.23},{64.68,70.48},{66.19,72.73},{66.19,72.73},{66.19,72.73},{65.37,70.83},{62.54,72.37},{56.74,62.12},{53.74,63.94},{53.06,62.75}}}},1519,nil,nil,12,"A",nil,0},
[3511] = {'Steven',42,42,1,1,0,{[1519]={{52.95,62.78}}},{[1519]={{{52.3,61.05},{49.32,63.02},{48.85,62.47},{47.3,57.67},{47.85,54.62},{49.6,52.3},{49.36,51.13},{48.0,48.71},{49.46,46.92},{47.34,42.83},{45.74,42.55},{44.29,39.71},{41.94,42.45},{41.68,42.56},{41.31,42.13},{38.75,37.21},{39.29,35.94},{40.42,37.41},{41.8,39.66},{44.4,39.31},{45.09,38.66},{45.09,38.6},{45.09,38.6},{45.09,38.6},{45.09,38.6},{46.28,35.26},{47.66,33.81},{49.2,35.18},{52.49,31.76},{51.42,28.87},{52.76,27.27},{54.24,25.8},{56.92,30.91},{57.08,32.0},{58.41,33.61},{60.5,34.33},{62.41,32.91},{66.19,28.75},{66.91,28.92},{67.76,30.14},{67.98,29.84},{67.98,29.84},{67.98,29.84},{67.98,29.84},{68.19,31.65},{67.13,33.61},{65.31,36.31},{63.2,39.3},{61.69,41.51},{61.54,43.45},{64.01,48.14},{62.68,50.14},{61.19,52.45},{60.08,51.33},{57.57,54.74},{58.86,57.38},{56.46,61.02},{62.35,72.14},{64.61,70.32},{66.3,72.63},{66.3,72.63},{66.3,72.63},{65.29,70.91},{62.48,72.46},{56.69,62.23},{53.79,64.04},{52.95,62.78}}}},1519,nil,nil,12,"A",nil,0},
[3512] = {'Jimmy',42,42,1,1,0,{[1519]={{52.78,62.79}}},{[1519]={{{52.24,61.33},{49.29,63.3},{48.61,62.51},{46.97,57.74},{47.67,54.38},{49.51,52.02},{49.17,51.35},{47.75,48.65},{49.25,46.88},{47.21,42.98},{45.55,42.78},{44.15,39.98},{42.06,42.68},{41.62,42.88},{41.03,42.12},{38.42,37.15},{39.28,35.45},{40.62,37.39},{42.07,39.69},{44.52,39.01},{44.88,38.68},{44.89,38.6},{44.89,38.6},{44.89,38.6},{44.89,38.6},{44.89,38.6},{46.22,34.87},{47.74,33.36},{49.39,35.23},{52.51,31.49},{51.3,28.85},{52.77,27.06},{54.26,25.6},{57.01,31.0},{57.19,32.13},{58.59,33.59},{60.62,34.0},{62.42,32.64},{66.29,28.49},{67.1,28.76},{67.87,29.82},{68.0,29.63},{68.0,29.63},{68.0,29.63},{68.0,29.63},{68.26,31.82},{67.14,33.95},{65.31,36.66},{63.0,39.72},{61.77,41.74},{61.61,43.72},{64.17,48.23},{62.65,50.46},{61.19,52.71},{59.91,51.32},{57.57,54.99},{59.13,57.46},{56.45,61.36},{62.56,72.2},{64.65,69.97},{66.54,72.71},{66.54,72.71},{66.54,72.71},{65.1,70.95},{62.21,72.29},{56.51,62.26},{53.8,64.35},{52.78,62.79}}}},1519,nil,nil,12,"A",nil,0},
[3513] = {'Miss Danna',712,712,25,25,0,{[1519]={{52.87,62.44}}},{[1519]={{{52.34,60.89},{49.07,63.06},{47.25,57.55},{47.88,54.32},{49.78,51.9},{49.35,51.02},{48.0,48.56},{49.57,46.85},{47.08,42.25},{45.61,42.37},{44.15,39.68},{41.64,42.76},{41.23,41.8},{38.62,36.79},{39.49,35.86},{40.4,37.63},{41.96,40.01},{44.56,39.13},{45.08,38.49},{45.04,38.43},{45.04,38.43},{45.04,38.43},{45.04,38.43},{45.04,38.43},{46.37,35.17},{47.83,33.47},{49.36,35.47},{52.64,31.62},{51.37,28.75},{52.84,27.15},{54.37,25.65},{56.98,31.11},{57.1,32.27},{58.61,33.73},{60.86,34.22},{62.5,32.87},{66.42,28.65},{67.07,28.99},{67.95,30.06},{68.2,29.69},{68.2,29.69},{68.2,29.69},{68.2,29.69},{68.06,31.83},{66.95,33.96},{65.17,36.51},{62.95,39.53},{61.61,42.07},{61.51,43.81},{64.06,48.49},{62.41,50.46},{60.94,52.56},{59.99,51.1},{57.4,54.85},{58.99,57.68},{56.26,61.24},{62.52,72.53},{64.86,70.15},{66.42,73.0},{66.42,73.0},{66.42,73.0},{65.12,70.6},{62.31,72.11},{56.55,61.86},{53.63,64.24},{52.87,62.44}}}},1519,nil,nil,12,"A","School Mistress",0},
[3514] = {'Tenaron Stormgrip',198,198,10,10,0,{[141]={{59.06,39.45}}},nil,141,{921,928},{920,921},80,"A",nil,2},
[3515] = {'Corithras Moonrage',198,198,10,10,0,{[141]={{56.14,61.71}}},nil,141,{929,933,935,7383},{928,929,933,7383},80,"A",nil,2},
[3516] = {'Arch Druid Fandral Staghelm',799500,799500,63,63,3,{[1657]={{34.81,9.26}}},nil,1657,{952,3764,3781,6761},{935,940,1015,1019,1047,3763,3789,3790,4902,5253},80,"A",nil,3},
[3517] = {'Rellian Greenspyre',386,386,17,17,0,{[1657]={{38.18,21.64}}},nil,1657,{923,2498},{922,923},80,"A",nil,2},
[3518] = {'Thomas Miller',328,328,15,15,0,{[1519]={{62.34,61.65}}},{[1519]={{{61.54,60.93},{60.87,59.99},{59.94,59.55},{59.02,57.98},{58.59,56.89},{57.8,55.51},{56.81,53.98},{56.05,53.49},{54.98,53.61},{53.53,54.86},{52.7,55.81},{52.11,56.73},{51.87,58.62},{52.09,59.84},{52.56,61.63},{53.15,63.12},{53.78,64.07},{54.6,63.58},{55.27,62.88},{55.55,62.01},{55.17,60.77},{55.04,60.19},{55.53,59.42},{56.21,59.69},{56.58,61.2},{57.09,62.27},{57.95,63.26},{58.73,64.22},{59.4,65.25},{60.19,66.55},{60.19,67.45},{59.72,68.0},{59.19,68.12},{58.68,67.1},{58.25,65.64},{57.5,63.66},{56.73,62.09},{56.6,61.3},{57.11,60.36},{57.83,59.22},{58.61,58.91},{59.47,59.91},{60.24,60.5},{61.14,61.58},{61.84,61.98},{62.33,61.68}}}},1519,nil,nil,12,"A","Baker",5},
[3519] = {'Sentinel Arynia Cloudsbreak',198,198,10,10,0,{[141]={{38.32,34.36}}},nil,141,{937,940},{937,938},80,"A",nil,2},
[3520] = {'Ol\' Emma',55,55,2,2,0,{[1519]={{52.37,42.13}}},{[1519]={{{52.39,42.1},{52.9,41.4},{52.43,40.44},{52.27,40.56},{52.49,41.97},{52.86,42.89},{48.37,48.17},{48.28,49.07},{49.6,51.64},{50.74,51.53},{52.85,55.17},{54.65,53.9},{56.49,53.63},{60.62,60.33},{57.71,55.38},{57.69,54.42},{59.71,51.5},{59.73,50.73},{58.2,48.05},{56.85,47.45},{54.21,48.21},{50.29,51.52},{49.63,51.53},{48.35,49.22},{48.42,48.22},{52.78,43.02},{52.83,42.66},{52.29,41.59},{52.28,40.46},{52.48,40.46},{52.9,41.27},{52.86,41.51},{52.39,42.1}}}},1519,{5050},{5048},12,"A",nil,2},
[3521] = {'Ak\'Zeloth',573,573,22,22,0,{[17]={{62.34,20.07}}},nil,17,{924},{809,924},29,"H",nil,2},
[3522] = {'Constance Brisboise',198,198,10,10,0,{[85]={{52.6,55.77}}},nil,85,nil,nil,68,"H","Apprentice Clothier",16388},
[3523] = {'Bowen Brisboise',664,664,24,24,0,{[85]={{52.59,55.52}}},nil,85,nil,nil,68,"H","Journeyman Tailor",19},
[3524] = {'Spirit Wolf',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3527] = {'Healing Stream Totem',26,26,21,21,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3528] = {'Pyrewood Armorer',900,984,14,15,1,{[130]={{46.4,71.88}}},nil,130,nil,nil,123,"A",nil,16388},
[3529] = {'Moonrage Armorer',900,984,14,15,1,nil,nil,0,nil,nil,16,nil,nil,0},
[3530] = {'Pyrewood Tailor',900,984,14,15,1,{[130]={{46.55,72.39}}},nil,130,nil,nil,123,"A",nil,16404},
[3531] = {'Moonrage Tailor',900,984,14,15,1,nil,nil,0,nil,nil,16,nil,nil,16},
[3532] = {'Pyrewood Leatherworker',900,984,14,15,1,{[130]={{43.95,74.1}}},nil,130,nil,nil,123,"A",nil,16388},
[3533] = {'Moonrage Leatherworker',900,984,14,15,1,nil,nil,0,nil,nil,16,nil,nil,0},
[3534] = {'Wallace the Blind',449,449,19,19,0,{[130]={{46.5,86.49}}},nil,130,nil,nil,35,"AH","Weaponsmith",16388},
[3535] = {'Blackmoss the Fetid',273,273,13,13,4,{[141]={{43.97,30.22}}},nil,141,nil,nil,14,nil,nil,0},
[3536] = {'Kris Legace',1050,1050,30,30,0,{[267]={{80.14,38.89}}},nil,267,nil,nil,35,"AH","Freewheeling Tradeswoman",16388},
[3537] = {'Zixil',1162,1162,32,32,0,{[267]={{61.97,20.45}}},{[267]={{{61.97,20.45},{61.53,20.09},{61.36,19.98},{59.48,21.16},{58.42,19.55},{55.8,19.73},{55.61,25.75},{55.92,29.34},{56.9,34.01},{57.6,36.46},{54.61,37.65},{54.31,34.29},{55.62,34.75},{55.58,34.72},{54.51,34.0},{54.37,34.68},{54.75,36.83},{53.86,38.14},{51.64,39.41},{50.8,43.17},{51.07,45.43},{51.33,46.62},{50.85,49.25},{51.1,51.17},{50.91,51.9},{50.5,52.72},{50.28,56.77},{49.99,57.07},{50.28,56.77},{50.5,52.72},{50.91,51.9},{51.1,51.17},{50.85,49.25},{51.33,46.62},{51.07,45.43},{50.8,43.17},{51.64,39.41},{53.86,38.14},{54.75,36.83},{54.37,34.68},{54.51,34.0},{55.58,34.72},{55.62,34.75},{54.31,34.29},{54.61,37.65},{57.6,36.46},{56.9,34.01},{55.92,29.34},{55.61,25.75},{55.8,19.73},{58.42,19.55},{59.48,21.16},{61.36,19.98},{61.53,20.09},{61.99,20.58}}}},267,nil,nil,120,"AH","Merchant Supreme",16388},
[3538] = {'Overwatch Mark I',1162,1162,32,32,0,{[267]={{61.91,20.5}}},nil,267,nil,nil,120,"AH","Protector",0},
[3539] = {'Ott',1162,1162,32,32,0,{[267]={{60.43,26.18}}},nil,267,nil,nil,29,"H","Weaponsmith",16388},
[3540] = {'Hal McAllister',1752,1752,40,40,0,{[267]={{49.85,62.41}}},nil,267,nil,nil,12,"A","Fish Merchant",6},
[3541] = {'Sarah Raycroft',1752,1752,40,40,0,{[267]={{49.14,55.06}}},nil,267,nil,nil,12,"A","General Goods",6},
[3542] = {'Jaysin Lanyda',1752,1752,40,40,0,{[267]={{50.82,59.02}}},nil,267,nil,nil,12,"A","Poisons & Reagents",4},
[3543] = {'Robert Aebischer',1604,1604,38,38,0,{[267]={{51.21,56.98}}},nil,267,nil,nil,12,"A","Superior Armorsmith",16388},
[3544] = {'Jason Lemieux',1752,1752,40,40,0,{[267]={{60.51,19.53}}},{[267]={{{60.51,19.53},{60.64,19.89},{60.76,20.55},{60.82,20.97},{60.87,21.38},{60.96,21.78},{61.04,22.18},{61.1,22.6},{61.13,22.74},{61.32,23.22},{61.39,23.29},{61.58,23.28},{61.64,23.27},{61.89,23.01},{61.94,22.95},{61.94,22.66},{61.93,22.38},{62.03,21.69},{62.22,21.2},{62.27,20.8},{62.04,20.42},{61.69,20.23},{61.52,20.11},{61.43,20.05},{61.04,20.35},{60.67,20.8},{60.35,21.1},{59.89,21.21},{59.7,21.2},{59.34,21.02},{59.13,20.75},{59.01,20.52},{59.03,20.15},{59.16,19.78},{59.34,19.45},{59.54,19.17},{59.81,19.08},{60.15,19.23}}}},267,nil,nil,68,"H","Mushroom Seller",6},
[3545] = {'Claude Erksine',1752,1752,40,40,0,{[38]={{82.22,62.84}}},nil,38,nil,nil,55,"A","Pet Trainer",19},
[3546] = {'Bernie Heisten',2217,2217,45,45,0,{[4]={{63.51,17.01}}},nil,4,nil,nil,12,"A","Food & Drink",4},
[3547] = {'Hamlin Atkins',198,198,10,10,0,{[85]={{58.34,50.7}}},{[85]={{{58.34,50.7},{58.33,50.3},{58.33,50.03},{58.38,49.78},{58.51,49.61},{58.72,49.39},{58.85,49.21},{59.0,49.1},{59.18,49.07},{59.35,49.03},{59.44,49.0},{59.52,48.93},{59.34,48.94},{59.09,49.07},{58.93,49.17},{58.72,49.41},{58.57,49.55},{58.43,49.71},{58.37,49.81},{58.33,50.2},{58.31,50.6},{58.34,51.0},{58.36,51.26},{58.33,51.52},{58.28,51.62},{57.85,51.79},{56.76,52.23},{56.96,52.16},{57.48,51.96},{57.83,51.85},{58.18,51.74},{58.36,51.68},{58.53,51.63},{58.71,51.6},{58.98,51.58},{59.25,51.57},{59.51,51.62},{59.84,51.81},{60.25,52.08},{60.66,52.36},{60.82,52.49},{61.01,52.76},{61.2,53.06},{61.36,53.38},{61.62,53.93},{61.79,54.4},{61.67,54.14},{61.42,53.59},{61.31,53.37},{61.2,53.16},{61.02,52.86},{60.96,52.76},{60.82,52.59},{60.67,52.45},{60.59,52.39},{60.18,52.1},{59.87,51.85},{59.54,51.64},{59.27,51.58},{59.0,51.58},{58.74,51.58},{58.56,51.61},{58.48,51.59},{58.41,51.5},{58.36,51.25},{58.34,50.85}}}},85,nil,nil,68,"H","Mushroom Farmer",6},
[3548] = {'Selina Weston',247,247,12,12,0,{[85]={{61.76,50.03}}},nil,85,nil,nil,68,"H","Alchemy & Herbalism Supplies",6},
[3549] = {'Shelene Rhobart',712,712,25,25,0,{[85]={{65.43,60.12}}},nil,85,nil,nil,68,"H","Journeyman Leatherworker",17},
[3550] = {'Martine Tramblay',328,328,15,15,0,{[85]={{65.86,59.64}}},nil,85,nil,nil,68,"H","Fishing Supplies",4},
[3551] = {'Patrice Dwyer',484,484,20,20,0,{[130]={{42.91,41.81}}},nil,130,nil,nil,68,"H","Poison Supplies",4},
[3552] = {'Alexandre Lefevre',417,417,18,18,0,{[130]={{44.6,39.11}}},nil,130,nil,nil,68,"H","Leather Armor Merchant",16388},
[3553] = {'Sebastian Meloche',356,356,16,16,0,{[130]={{43.33,41.35}}},nil,130,nil,nil,68,"H","Armorer",16388},
[3554] = {'Andrea Boynton',417,417,18,18,0,{[130]={{44.8,39.24}}},nil,130,nil,nil,68,"H","Clothier",16388},
[3555] = {'Johan Focht',449,449,19,19,0,{[130]={{43.41,40.45}}},nil,130,nil,nil,68,"H","Miner",19},
[3556] = {'Andrew Hilbert',417,417,18,18,0,{[130]={{43.22,40.66}}},nil,130,nil,nil,68,"H","Trade Goods",6},
[3557] = {'Guillaume Sorouy',895,895,28,28,0,{[130]={{43.2,41.08}}},nil,130,nil,nil,68,"H","Journeyman Blacksmith",19},
[3559] = {'Temp Poisoning Vendor Dwarf',484,484,20,20,0,nil,nil,0,nil,nil,55,"A","Poison Vendor",0},
[3560] = {'Healing Ward',1336,1336,37,37,0,nil,nil,0,nil,nil,82,nil,nil,0},
[3561] = {'Kyrai',1002,1002,30,30,0,{[1657]={{32.54,19.73}}},nil,1657,nil,nil,80,"A","Poison Vendor",4},
[3562] = {'Alaindia',1002,1002,30,30,0,{[1657]={{38.99,74.25}}},{[1657]={{{38.99,74.25},{40.29,74.37},{41.13,74.65},{41.75,74.94},{42.36,75.36},{43.75,77.11},{48.74,67.87},{43.87,77.04},{43.0,76.09},{41.77,74.96},{41.04,74.52},{39.01,74.26},{37.98,74.42},{37.2,74.68},{36.31,75.1},{35.72,75.57},{34.75,76.86},{34.37,77.4},{29.3,69.0},{34.29,77.36},{35.05,76.45},{35.66,75.77},{36.22,75.15},{37.41,74.53},{38.99,74.29},{38.43,43.95}}}},1657,nil,nil,80,"A","Reagent Vendor",4},
[3564] = {'Temp Reagent Vendor Dwarf',484,484,20,20,0,nil,nil,0,nil,nil,55,"A","Reagent Vendor",0},
[3566] = {'Flatland Prowler',176,176,9,9,0,{[215]={{53.67,11.25},{52.81,8.7},{52.76,11.02},{53.41,12.41},{53.41,9.17},{51.24,28.41},{52.51,12.0},{52.5,25.75},{44.99,33.42},{51.87,25.18},{55.32,34.19},{58.56,29.8},{46.1,27.5},{46.32,27.77},{55.27,23.12},{55.69,24.66},{55.76,21.3},{55.0,22.36},{56.31,21.9},{59.89,28.55},{56.31,22.97},{59.67,23.6},{55.0,32.48},{54.49,24.77},{57.19,29.61},{56.35,34.37},{43.43,17.42},{51.6,20.38},{38.1,15.63},{50.64,15.77},{44.15,10.98},{47.33,25.14},{53.36,15.96},{46.27,17.49},{62.06,24.37},{57.77,18.89},{57.1,19.15},{56.42,18.74},{43.3,18.4},{44.73,15.85},{50.31,12.95},{62.32,23.54},{56.42,26.28},{51.02,24.35},{44.66,13.89},{47.57,12.99},{51.11,12.06},{32.29,18.97},{48.47,13.75},{48.86,12.84},{48.32,25.67},{43.79,11.29},{37.69,18.03},{45.03,16.76},{38.8,9.25},{47.43,8.56},{49.11,10.11},{48.91,11.47},{46.47,11.84},{54.4,16.85},{43.29,18.59},{48.8,8.89},{35.36,16.2},{44.62,15.07},{42.01,17.29},{42.48,7.32},{39.76,11.1},{49.77,18.05},{45.15,13.74},{54.33,19.52},{56.86,17.86},{41.62,9.84},{50.72,22.53},{48.46,20.26},{45.43,12.0},{44.06,15.69},{47.92,15.28},{61.57,24.76},{53.87,19.01},{53.73,20.56},{62.8,58.44},{37.39,16.93},{44.25,18.96},{55.29,18.41},{52.79,23.93},{47.79,28.82},{53.33,25.48},{44.31,11.2},{53.8,21.68},{52.52,22.33},{51.98,17.56},{44.53,8.66},{57.04,24.73},{42.66,19.23},{37.55,11.98},{42.18,19.76},{55.87,23.84},{48.75,18.58},{42.61,11.14},{47.98,16.91},{44.42,12.44},{53.44,21.72},{51.91,11.98}},[1638]={{64.2,36.97},{70.92,45.5},{83.25,15.21}}},nil,215,nil,nil,16,nil,nil,0},
[3567] = {'Tallonkai Swiftroot',222,222,11,11,0,{[141]={{55.57,56.95}}},nil,141,{932,2438,2459},{932,2438,2459},80,"A",nil,2},
[3568] = {'Mist',198,198,10,10,0,{[141]={{31.54,31.61}}},nil,141,{938},nil,80,"A",nil,2},
[3569] = {'Bogling',48,48,5,5,0,nil,nil,0,nil,nil,91,nil,nil,0},
[3570] = {'Cleansed Timberling',137,137,7,7,0,nil,nil,0,nil,nil,4,"A",nil,0},
[3571] = {'Teldrassil Sentinel',5228,5228,55,55,0,{[141]={{55.5,57.16},{55.61,56.75},{56.63,60.82},{55.8,58.67},{56.25,61.96},{56.07,58.56},{55.84,57.47}}},nil,141,nil,nil,79,"A",nil,1},
[3572] = {'Zizzek',573,573,22,22,0,{[17]={{61.99,39.14}}},nil,17,nil,nil,69,"AH","Fisherman",4},
[3573] = {'Mana Spring Totem',37,37,26,26,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3574] = {'Riding Bat',1040,1040,29,29,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3575] = {'Praenus Raxxeus',126,126,1,1,1,nil,nil,0,nil,nil,29,"H","Bat Handler",0},
[3577] = {'Dalaran Brewmaster',328,356,15,16,0,{[130]={{62.61,65.05}}},nil,130,nil,nil,76,"AH",nil,4},
[3578] = {'Dalaran Miner',328,328,15,15,0,{[130]={{62.52,62.65}}},nil,130,nil,nil,76,"AH",nil,4},
[3579] = {'Stoneclaw Totem',40,40,8,8,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3580] = {'Invisibility Totem',153,153,60,60,0,nil,nil,0,nil,nil,210,"A",nil,0},
[3581] = {'Sewer Beast',17720,17720,50,50,4,{[1519]={{66.53,31.44},{66.47,56.31}}},nil,1519,nil,nil,14,nil,nil,0},
[3582] = {'Aman',2768,2768,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3583] = {'Barithras Moonshade',300,300,14,14,0,{[148]={{37.32,43.64}}},nil,148,{947,948},{947},1076,"A",nil,2},
[3584] = {'Therylune',386,386,17,17,0,{[148]={{38.64,87.33}}},nil,148,{945},nil,124,"A",nil,2},
[3585] = {'Therysil',386,386,17,17,0,{[331]={{22.64,51.92}}},nil,331,nil,{945},124,"A",nil,2},
[3586] = {'Miner Johnson',1347,1347,19,19,2,{[1581]={{-1,-1}}},nil,1581,nil,nil,14,nil,nil,0},
[3587] = {'Lyrai',176,176,9,9,0,{[141]={{59.52,40.91}}},nil,141,nil,nil,80,"A","General Supplies",6},
[3588] = {'Khardan Proudblade',156,156,8,8,0,{[141]={{58.72,39.67}}},nil,141,nil,nil,80,"A","Weaponsmith",16388},
[3589] = {'Keina',198,198,10,10,0,{[141]={{59.31,41.09}}},nil,141,nil,nil,80,"A","Bowyer",16388},
[3590] = {'Janna Brightmoon',176,176,9,9,0,{[141]={{59.46,41.05}}},nil,141,nil,nil,80,"A","Clothier",16388},
[3591] = {'Freja Nightwing',176,176,9,9,0,{[141]={{58.99,39.64}}},nil,141,nil,nil,80,"A","Leather Armor Merchant",16388},
[3592] = {'Andiss',198,198,10,10,0,{[141]={{58.68,39.84}}},nil,141,nil,nil,80,"A","Armorer & Shieldcrafter",16388},
[3593] = {'Alyissia',222,222,11,11,0,{[141]={{59.64,38.44}}},nil,141,nil,{3116},80,"A","Warrior Trainer",19},
[3594] = {'Frahun Shadewhisper',222,222,11,11,0,{[141]={{59.64,38.66}}},nil,141,nil,{3118},80,"A","Rogue Trainer",19},
[3595] = {'Shanda',198,198,10,10,0,{[141]={{59.17,40.44}}},nil,141,{5622},{3119},80,"A","Priest Trainer",19},
[3596] = {'Ayanna Everstride',198,198,10,10,0,{[141]={{58.66,40.45}}},nil,141,{6072},{3117},80,"A","Hunter Trainer",19},
[3597] = {'Mardant Strongoak',222,222,11,11,0,{[141]={{58.63,40.29}}},nil,141,nil,{3120},80,"A","Druid Trainer",19},
[3598] = {'Kyra Windblade',449,449,19,19,0,{[141]={{56.22,59.2}}},nil,141,{1684},nil,80,"A","Warrior Trainer",19},
[3599] = {'Jannok Breezesong',484,484,20,20,0,{[141]={{56.38,60.14}}},nil,141,{2241,2259},nil,80,"A","Rogue Trainer",19},
[3600] = {'Laurna Morninglight',531,531,21,21,0,{[141]={{55.56,56.75}}},nil,141,{5621,5629,5636,5672},{5621,5622},80,"A","Priest Trainer",19},
[3601] = {'Dazalar',484,484,20,20,0,{[141]={{56.68,59.49}}},nil,141,{6063,6101,6102,6103},{6063,6071,6072,6073,6101,6102,6721,6722},80,"A","Hunter Trainer",19},
[3602] = {'Kal',573,573,22,22,0,{[141]={{55.95,61.56}}},nil,141,{5923},nil,80,"A","Druid Trainer",19},
[3603] = {'Cyndra Kindwhisper',895,895,28,28,0,{[141]={{57.64,60.8}}},nil,141,nil,nil,80,"A","Journeyman Alchemist",19},
[3604] = {'Malorne Bladeleaf',386,386,17,17,0,{[141]={{57.72,60.64}}},nil,141,nil,nil,80,"A","Herbalist",19},
[3605] = {'Nadyia Maneweaver',1002,1002,30,30,0,{[141]={{41.88,49.44}}},nil,141,nil,nil,80,"A","Journeyman Leatherworker",19},
[3606] = {'Alanna Raveneye',950,950,29,29,0,{[141]={{36.71,34.16}}},nil,141,nil,nil,80,"A","Journeyman Enchanter",19},
[3607] = {'Androl Oakhand',1536,1536,37,37,0,{[141]={{55.88,93.51}}},nil,141,nil,nil,80,"A","Fisherman",19},
[3608] = {'Aldia',386,386,17,17,0,{[141]={{55.51,57.15}}},nil,141,nil,nil,80,"A","General Supplies",6},
[3609] = {'Shalomon',416,416,18,18,0,{[141]={{56.31,59.49}}},nil,141,nil,nil,80,"A","Weaponsmith",16388},
[3610] = {'Jeena Featherbow',449,449,19,19,0,{[141]={{55.89,59.21}}},nil,141,nil,nil,80,"A","Bowyer",16388},
[3611] = {'Brannol Eaglemoon',356,356,16,16,0,{[141]={{56.12,60.25}}},nil,141,nil,nil,80,"A","Clothier",4},
[3612] = {'Sinda',484,484,20,20,0,{[141]={{56.33,59.59}}},nil,141,nil,nil,80,"A","Leather Armor Merchant",4},
[3613] = {'Meri Ironweave',449,449,19,19,0,{[141]={{56.29,59.38}}},nil,141,nil,nil,80,"A","Armorer & Shieldcrafter",16388},
[3614] = {'Narret Shadowgrove',356,356,16,16,0,{[141]={{55.27,57.15}}},nil,141,nil,nil,80,"A","Trade Supplies",6},
[3615] = {'Devrak',7842,7842,55,55,1,{[17]={{51.5,30.34}}},nil,17,{6362,6384},{6361,6365},29,"H","Wind Rider Master",11},
[3616] = {'Onu',3398,3398,55,55,0,{[148]={{43.55,76.29}}},nil,148,{944,951,961},{948,950,951,952},124,"A","Ancient of Lore",2},
[3617] = {'Lordaeron Citizen',328,328,15,15,0,{[1497]={{66.18,6.25},{66.05,8.86},{66.16,14.57},{66.2,16.21},{69.27,15.34},{62.7,4.96},{60.62,11.36},{64.9,9.03},{67.54,9.45},{68.75,7.44},{67.11,6.5},{70.87,17.13},{70.86,14.04},{70.49,5.73},{70.86,9.15},{70.92,11.69},{69.04,11.28},{69.07,14.51},{67.39,14.89},{64.85,14.68},{63.09,14.88},{64.54,11.24},{61.29,16.88},{61.39,13.1},{61.99,5.37},{61.61,7.29},{61.72,9.52},{63.31,11.18},{63.48,9.13},{64.0,7.58},{64.66,8.44},{65.06,6.83}},[85]={{59.66,67.42},{59.91,67.42},{59.94,67.03},{59.61,67.1},{59.67,67.78},{60.01,67.72}}},nil,1497,nil,nil,7,"AH",nil,0},
[3619] = {'Ghost Saber',449,484,19,20,0,nil,nil,0,nil,nil,66,nil,nil,0},
[3620] = {'Harruk',1752,1752,40,40,0,{[14]={{52.03,43.55}}},nil,14,nil,nil,29,"H","Pet Trainer",19},
[3621] = {'Kurll',2768,2768,50,50,0,{[16]={{21.82,52.1}}},nil,16,nil,nil,29,"H","Food & Drink",6},
[3622] = {'Grokor',1752,1752,40,40,0,{[8]={{47.35,52.89}}},nil,8,nil,nil,29,"H","Pet Trainer",17},
[3624] = {'Zudd',1752,1752,40,40,0,{[33]={{31.11,28.94}}},nil,33,nil,nil,29,"H","Pet Trainer",17},
[3625] = {'Rarck',26140,26140,55,55,0,{[2597]={{49.88,82.14}}},nil,2597,nil,nil,1215,"H","General Goods",6},
[3626] = {'Jenn Langston',102,102,5,5,0,{[1519]={{70.92,40.87}}},{[1519]={{{72.26,43.09},{72.99,44.8},{73.22,46.18},{72.53,47.36},{72.54,48.38},{72.49,49.7},{71.81,49.89},{71.15,49.57},{70.31,49.34},{69.49,48.88},{68.83,48.55},{68.22,47.57},{66.75,45.05},{66.04,44.19},{65.76,43.22},{65.92,42.49},{66.59,41.62},{67.99,40.02},{68.6,39.48},{69.49,39.44},{70.09,40.19},{70.92,40.86},{71.62,41.59}}}},1519,nil,nil,12,"A",nil,0},
[3627] = {'Erich Lohan',102,102,5,5,0,{[1519]={{36.58,83.66}}},{[1519]={{{37.48,84.27},{38.7,84.46},{39.63,84.24},{40.81,83.08},{41.29,82.28},{41.44,81.89},{40.97,81.04},{40.56,79.87},{40.46,79.33},{39.97,78.54},{39.54,78.08},{39.15,77.8},{38.61,75.42},{38.62,74.19},{39.02,71.8},{39.59,70.72},{40.67,69.51},{41.21,69.19},{42.68,69.16},{43.23,69.52},{44.75,71.76},{45.05,72.51},{45.32,73.98},{45.39,75.75},{45.09,76.96},{44.26,78.52},{43.47,79.2},{42.88,79.49},{41.24,79.88},{40.58,79.37},{39.82,78.34},{39.09,77.85},{38.28,77.71},{37.33,77.93},{36.42,79.14},{35.73,80.72},{34.03,82.17},{32.79,81.77},{31.78,81.08},{31.34,79.28},{31.35,77.76},{31.95,75.14},{32.12,73.69},{32.08,72.12},{32.66,71.09},{34.24,69.41},{36.09,68.05},{36.68,68.07},{38.68,69.3},{39.41,70.04},{39.49,70.45},{38.81,72.95},{38.57,74.91},{39.11,77.62},{39.86,78.32},{40.44,79.33},{40.56,80.1},{40.89,80.92},{41.37,81.87},{41.17,82.6},{40.46,83.7},{38.96,84.33},{38.08,84.41},{36.96,83.79}}}},1519,nil,nil,12,"A",nil,0},
[3628] = {'Steven Lohan',102,102,5,5,0,{[1519]={{41.44,89.82}}},nil,1519,nil,nil,12,"A",nil,1},
[3629] = {'David Langston',102,102,5,5,0,{[1519]={{74.45,37.03}}},nil,1519,nil,nil,12,"A",nil,0},
[3630] = {'Deviate Coiler',984,1068,15,16,1,{[17]={{45.95,33.61},{46.49,34.19},{46.16,34.73},{46.14,35.26}}},nil,17,nil,nil,14,nil,nil,0},
[3631] = {'Deviate Stinglash',1068,1158,16,17,1,{[17]={{47.37,33.68},{48.24,32.22},{49.41,33.17},{49.1,33.8},{48.09,34.61},{48.18,34.37},{47.09,32.87}}},nil,17,nil,nil,14,nil,nil,0},
[3632] = {'Deviate Creeper',984,1068,15,16,1,{[17]={{46.32,32.54},{46.57,34.22},{45.88,33.05},{46.19,34.26},{45.92,33.55},{46.2,34.8},{46.08,32.52},{46.3,35.06},{45.9,35.6},{46.18,35.27},{46.6,34.78},{45.79,34.09}}},nil,17,nil,nil,270,nil,nil,0},
[3633] = {'Deviate Slayer',1068,1158,16,17,1,{[17]={{47.62,32.38},{47.9,32.62},{47.38,32.78},{48.79,32.56},{48.04,32.14},{47.62,32.83},{49.17,33.31},{49.19,32.72},{48.45,32.29},{48.84,31.98},{48.96,33.98},{48.34,34.25},{47.53,34.14},{47.41,33.39}}},nil,17,nil,nil,270,nil,nil,0},
[3634] = {'Deviate Stalker',984,1068,15,16,1,{[17]={{47.87,32.08},{48.08,34.02},{45.59,33.78},{46.48,35.0}}},nil,17,nil,nil,270,nil,nil,0},
[3636] = {'Deviate Ravager',1251,1347,18,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3637] = {'Deviate Guardian',1251,1347,18,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3638] = {'Devouring Ectoplasm',1068,1158,16,17,1,{[17]={{47.59,32.58},{48.74,32.1},{48.25,32.24},{49.11,33.38},{49.29,33.85},{47.91,33.97},{47.55,34.28},{47.58,33.05},{46.05,33.86},{45.86,33.36}}},nil,17,nil,nil,14,nil,nil,0},
[3639] = {'Sentinel Tysha Moonblade',198,198,10,10,0,{[148]={{40.3,59.73}}},nil,148,{953},{953},80,"A",nil,2},
[3640] = {'Evolving Ectoplasm',1158,1251,17,18,1,{[718]={{-1,-1}}},nil,718,nil,nil,14,nil,nil,0},
[3641] = {'Deviate Lurker',1068,1158,16,17,1,{[17]={{46.74,32.39},{48.03,33.62},{48.28,33.49},{48.09,33.13},{47.93,33.42},{48.36,33.14},{48.54,33.43},{46.74,32.53}}},nil,17,nil,nil,14,nil,nil,0},
[3642] = {'Deviate Horror',1251,1347,18,19,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3644] = {'Cerellean Whiteclaw',328,328,15,15,0,{[148]={{35.74,43.71}}},nil,148,{963},{963},80,"A",nil,2},
[3649] = {'Thundris Windweaver',328,328,15,15,0,{[148]={{37.4,40.13}}},nil,148,{954,958,1442,4762,4763},{958,1442,4761,4762,4763},80,"A",nil,2},
[3650] = {'Asterion',328,328,15,15,0,{[148]={{44.17,36.29}}},nil,148,{955,956,957},{954,955,956,957},80,"A",nil,2},
[3652] = {'Trigore the Lasher',1347,1347,19,19,2,{[17]={{48.29,33.07}}},nil,17,nil,nil,14,nil,nil,0},
[3653] = {'Kresh',1452,1452,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,7,"AH",nil,0},
[3654] = {'Mutanus the Devourer',4496,4496,22,22,1,nil,nil,0,nil,nil,14,nil,nil,0},
[3655] = {'Mad Magglish',1251,1251,18,18,1,{[17]={{45.69,33.62}}},nil,17,nil,nil,14,nil,nil,0},
[3657] = {'Sentinel Elissa Starbreeze',484,484,20,20,0,{[148]={{39.05,43.55}}},nil,148,{965},nil,80,"A",nil,2},
[3658] = {'Lizzarik',449,449,19,19,0,{[17]={{61.76,38.29}}},{[17]={{{61.78,38.24},{61.57,37.89},{61.43,37.9},{61.18,37.94},{61.01,38.08},{60.81,38.34},{60.47,38.4},{60.32,38.52},{60.19,38.8},{59.89,38.84},{59.62,38.9},{59.42,38.87},{59.02,38.75},{58.84,38.59},{58.46,38.33},{58.06,38.03},{57.77,37.82},{57.54,37.4},{57.21,37.05},{56.84,36.91},{56.43,36.89},{56.29,36.62},{56.21,36.1},{55.98,35.62},{55.81,35.42},{55.46,34.97},{55.27,34.49},{55.06,34.31},{54.91,33.65},{54.68,33.31},{54.38,32.89},{54.15,32.53},{53.73,31.83},{53.4,31.31},{53.21,31.08},{52.87,31.01},{52.5,30.92},{52.48,30.65},{52.46,30.68},{52.4,30.87},{52.57,30.99},{52.96,31.03},{53.29,31.19},{53.79,31.9},{54.09,32.42},{54.32,32.82},{54.93,33.7},{55.05,34.3},{55.26,34.46},{55.42,34.94},{55.73,35.35},{56.0,35.68},{56.21,36.09},{56.33,36.75},{56.49,36.91},{56.95,36.96},{57.46,37.31},{57.63,37.52},{57.74,37.79},{58.03,38.01},{58.4,38.29},{58.71,38.47},{59.0,38.74},{59.33,38.86},{59.69,38.92},{60.0,38.84},{60.12,38.86},{60.36,38.48},{60.61,38.36},{60.83,38.31},{61.12,37.96},{61.53,37.88},{61.7,38.11},{61.8,38.26},{61.74,38.33},{61.75,38.28}}}},17,nil,nil,69,"AH","Weapon Dealer",16388},
[3659] = {'Jorb',1536,1536,37,37,0,{[17]={{61.74,38.25}}},nil,17,nil,nil,474,"AH","Lizzarik's Bodyguard",0},
[3660] = {'Athrikus Narassin',1107,1107,31,31,0,{[148]={{56.02,26.33}}},nil,148,nil,nil,16,nil,"Cult of the Dark Strand",0},
[3661] = {'Balthule Shadowstrike',328,328,15,15,0,{[148]={{54.97,24.89}}},nil,148,{966,967,981,1143},{965,966,1143,1167},80,"A",nil,2},
[3662] = {'Delmanis the Hated',330,330,17,17,0,{[148]={{56.84,27.51}}},{[148]={{{56.84,27.51},{56.83,27.5},{56.83,27.55},{56.94,27.53},{57.11,27.5},{57.27,27.48},{57.51,27.5},{57.67,27.42},{57.67,27.2},{57.6,27.0},{57.64,26.46},{57.69,26.21},{57.61,26.06},{57.44,25.99},{57.28,26.06},{57.09,26.09},{57.04,26.22},{57.03,26.49},{56.94,26.62},{56.73,26.69},{56.65,26.78},{56.47,26.85},{56.39,27.0},{56.42,27.19},{56.55,27.16},{56.74,26.72},{56.96,26.64},{57.05,26.42},{57.05,26.13},{57.2,26.02},{57.57,26.06},{57.7,26.26},{57.83,26.52},{57.88,26.73},{57.75,26.9},{57.63,27.04},{57.56,27.39},{57.32,27.36},{56.93,27.34},{56.81,27.52},{56.84,27.5},{56.81,27.51},{56.83,27.52},{56.82,27.52},{56.84,27.5},{56.82,27.51},{56.84,27.5},{56.84,27.51},{56.81,27.51},{56.83,27.52}}}},148,nil,nil,90,nil,nil,0},
[3663] = {'Delgren the Purifier',449,449,19,19,0,{[331]={{26.2,38.7}}},nil,331,{970,973,1140,1167},{967,970,973,976,981,1140},123,"A",nil,2},
[3664] = {'Ilkrud Magthrull',792,792,24,24,0,{[331]={{25.28,60.69}}},nil,331,nil,nil,90,nil,nil,0},
[3665] = {'Crane Operator Bigglefuzz',417,417,18,18,0,{[17]={{63.09,37.61}}},nil,17,{959},{959},69,"AH",nil,2},
[3666] = {'Wizbang Cranktoggle',328,328,15,15,0,{[148]={{36.97,44.13}}},nil,148,{983,1579,1580},{1579,1580},64,"A",nil,2},
[3667] = {'Anaya Dawnrunner',356,356,16,16,0,{[148]={{41.81,60.73}}},{[148]={{{41.8,60.74},{41.83,60.46},{42.0,60.52},{42.23,60.63},{42.44,60.73},{42.66,60.85},{42.79,61.07},{42.87,61.44},{42.91,61.78},{43.0,61.91},{43.16,62.15},{43.06,62.48},{42.9,62.64},{42.7,62.75},{42.5,62.78},{42.28,62.8},{42.13,62.6},{41.98,62.39},{41.83,62.11},{41.66,61.93},{41.36,61.81},{41.83,61.96},{41.87,61.69},{41.85,61.39},{41.82,61.01}}}},148,nil,nil,7,"AH",nil,0},
[3668] = {'Tortured Highborne Soul',484,484,20,20,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3669] = {'Lord Cobrahn',2165,2165,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3670] = {'Lord Pythas',2320,2320,21,21,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3671] = {'Lady Anacondra',2165,2165,20,20,1,nil,nil,0,nil,nil,270,nil,"Fanglord",0},
[3672] = {'Boahn',1299,1299,20,20,2,{[17]={{49.06,33.9}}},nil,17,nil,nil,270,nil,"Druid of the Fang",0},
[3673] = {'Lord Serpentis',2784,2784,21,21,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,"Fanglord",0},
[3674] = {'Skum',3908,3908,21,21,1,{[718]={{-1,-1}}},nil,718,nil,nil,14,nil,nil,0},
[3678] = {'Disciple of Naralex',1299,1299,20,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,35,"AH",nil,1},
[3679] = {'Naralex',712,712,25,25,0,{[718]={{-1,-1}}},nil,718,nil,nil,35,"AH",nil,1},
[3680] = {'Serpentbloom Snake',8,8,1,1,0,nil,nil,0,nil,nil,7,"AH",nil,0},
[3681] = {'Wisp',42,42,1,1,0,{[1657]={{68.44,36.17},{46.66,50.07},{66.65,73.39},{31.12,38.43},{28.36,89.6},{34.02,53.17},{57.54,68.32},{28.82,1.35},{68.75,48.85},{72.32,14.99},{52.93,15.32},{39.05,90.89},{53.09,7.46},{60.31,54.99},{28.42,16.51},{75.63,55.22},{27.82,19.39},{25.33,28.17},{34.98,59.4},{68.17,35.64},{43.51,82.62},{73.85,45.95},{59.2,21.44},{75.41,36.09},{82.53,43.84},{65.49,13.25},{46.02,19.13},{40.64,42.7},{52.56,87.07},{37.07,84.75},{42.09,18.37},{39.79,36.68},{57.98,83.7},{45.09,3.97}}},nil,1657,nil,nil,80,"A",nil,0},
[3682] = {'Vrang Wildgore',2577,2577,48,48,0,{[17]={{43.8,12.21}}},nil,17,nil,nil,29,"H","Weaponsmith & Armorcrafter",16388},
[3683] = {'Kiknikle',1162,1162,32,32,0,{[17]={{41.79,38.69}}},nil,17,nil,nil,69,"AH","Stylish Clothier",16388},
[3684] = {'Pizznukle',1221,1221,33,33,0,{[17]={{41.77,38.62}}},nil,17,nil,nil,69,"AH","Leather Armor Merchant",16388},
[3685] = {'Harb Clawhoof',2217,2217,45,45,0,{[215]={{47.49,58.6}}},nil,215,{7662,7663},{7662,7663},104,"H","Kodo Mounts",135},
[3688] = {'Reban Freerunner',1752,1752,40,40,0,{[215]={{47.71,55.73}}},nil,215,nil,nil,104,"H","Pet Trainer",19},
[3689] = {'Laer Stepperunner',1981,1981,42,42,0,{[400]={{21.06,31.87}}},nil,400,nil,nil,104,"H","Food & Drink",6},
[3690] = {'Kar Stormsinger',2138,2138,44,44,0,{[215]={{47.65,58.47}}},nil,215,nil,nil,104,"H","Kodo Riding Instructor",17},
[3691] = {'Raene Wolfrunner',61040,61040,60,60,1,{[331]={{36.62,49.58}}},nil,331,{991,1024,1025,1030,1054},{990,1023,1025,1029,1046,1054},124,"A",nil,3},
[3692] = {'Volcor',449,449,19,19,0,{[148]={{45.01,85.3}}},nil,148,{994,995},{993},10,"A",nil,3},
[3693] = {'Terenthis',328,328,15,15,0,{[148]={{39.37,43.48}}},nil,148,{984,985,986,993,4761},{984,985,986,994,995},80,"A",nil,3},
[3694] = {'Sentinel Selarin',484,484,20,20,0,nil,nil,0,{990},nil,80,"A",nil,2},
[3695] = {'Grimclaw',273,273,13,13,0,{[148]={{41.74,81.53}}},nil,148,nil,nil,80,"A",nil,0},
[3696] = {'Ran Bloodtooth',1003,1003,30,30,0,{[331]={{54.75,79.62}}},nil,331,nil,nil,82,nil,nil,0},
[3697] = {'Kyln Longclaw',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH","Boar Trainer",0},
[3698] = {'Bolyun',1752,1752,40,40,0,{[331]={{17.98,60.04}}},nil,331,nil,nil,80,"A","Pet Trainer",19},
[3699] = {'Nerra',247,247,12,12,0,nil,nil,0,nil,nil,80,"A","Cat Trainer",0},
[3700] = {'Jadenvis Seawatcher',2750,2750,51,51,0,{[357]={{30.92,42.09}}},nil,357,nil,nil,80,"A","Reagent Vendor",4},
[3701] = {'Tharnariun Treetender',417,417,18,18,0,{[148]={{38.84,43.42}}},nil,148,{2118,2138,2139},{2118,2138,2139},80,"A",nil,3},
[3702] = {'Alanndarian Nightsong',449,449,19,19,0,{[148]={{37.69,40.66}}},nil,148,{2178,6123,6124},{2178,6122,6123},80,"A",nil,3},
[3703] = {'Krulmoo Fullmoon',1981,1981,42,42,0,{[17]={{44.84,59.46}}},nil,17,nil,nil,104,"H","Expert Leatherworker",19},
[3704] = {'Mahani',1106,1106,31,31,0,{[17]={{44.93,59.39}}},nil,17,nil,nil,104,"H","Expert Tailor",19},
[3705] = {'Gahroot',712,712,25,25,0,{[17]={{44.74,59.42}}},nil,17,nil,nil,104,"H","Butcher",6},
[3706] = {'Tai\'jin',417,417,18,18,0,{[14]={{54.26,42.93}}},nil,14,{5648,5655,5660},{5648,5649},126,"H","Priest Trainer",19},
[3707] = {'Ken\'jai',198,198,10,10,0,{[14]={{42.36,68.81}}},nil,14,{5649,5657},{3085},126,"H","Priest Trainer",19},
[3708] = {'Gruna',2963,2963,52,52,0,{[46]={{65.71,23.91}}},nil,46,nil,nil,29,"H","Food & Drink",6},
[3711] = {'Wrathtail Myrmidon',494,531,20,21,0,{[331]={{6.62,16.17},{6.02,11.0},{7.84,12.61},{6.46,11.84},{4.95,14.49},{7.18,13.74},{7.2,12.93},{6.09,12.7},{7.97,15.18},{7.06,15.46},{8.34,15.18},{7.21,14.28},{7.83,16.06},{11.25,31.02}}},nil,331,nil,nil,74,nil,nil,0},
[3712] = {'Wrathtail Razortail',404,433,19,20,0,{[331]={{13.66,30.9},{8.85,29.93},{8.45,30.0},{8.27,29.16},{10.21,24.71},{8.93,29.1},{10.44,25.61},{9.91,29.64},{10.73,13.56},{11.18,29.25},{11.19,25.75},{11.34,27.99},{10.48,29.74}}},nil,331,nil,nil,74,nil,nil,0},
[3713] = {'Wrathtail Wave Rider',417,449,18,19,0,{[331]={{11.77,24.77},{15.87,16.13},{14.13,20.51},{14.66,17.8},{14.67,16.27},{15.19,20.42},{15.28,22.47},{12.4,29.24},{15.29,26.5}}},nil,331,nil,nil,74,nil,nil,0},
[3715] = {'Wrathtail Sea Witch',404,433,19,20,0,{[331]={{9.5,25.69},{7.19,13.01},{9.48,30.06},{8.4,28.27},{8.91,25.68},{10.71,24.18},{9.46,24.71},{12.07,29.97},{11.84,31.86},{10.86,28.59},{10.79,27.13},{11.29,26.52},{11.84,26.54}}},nil,331,nil,nil,74,nil,nil,0},
[3717] = {'Wrathtail Sorceress',354,379,18,19,0,{[331]={{11.89,23.89},{12.82,29.97},{14.06,15.23},{13.61,14.55},{15.87,15.41},{13.51,29.25},{14.29,19.17},{15.37,17.07},{14.83,20.75},{14.08,20.86},{14.7,19.53},{12.81,15.41},{14.26,23.08},{12.34,27.48},{15.21,24.94},{12.93,28.24},{14.2,25.83}}},nil,331,nil,nil,74,nil,nil,0},
[3721] = {'Mystlash Hydra',448,484,19,20,0,{[331]={{11.7,17.78},{9.56,17.02},{9.33,13.5},{10.41,16.2},{8.93,31.22},{12.65,18.66},{13.66,17.11},{11.54,27.66},{12.68,22.65}}},nil,331,nil,nil,74,nil,nil,0},
[3722] = {'Mystlash Flayer',617,617,23,23,0,{[331]={{6.94,24.44},{8.29,19.56},{6.66,17.91},{3.84,14.37},{6.76,21.75},{6.77,27.22},{6.73,30.88},{7.52,33.02},{4.87,19.97}}},nil,331,nil,nil,74,nil,nil,0},
[3725] = {'Dark Strand Cultist',354,379,18,19,0,{[331]={{30.8,31.61},{30.99,30.89},{30.39,30.99},{30.38,31.76},{31.11,30.25},{32.59,29.31},{31.47,29.3}}},nil,331,nil,nil,21,nil,nil,0},
[3727] = {'Dark Strand Enforcer',494,531,20,21,0,{[331]={{31.62,30.68}}},nil,331,nil,nil,21,nil,nil,0},
[3728] = {'Dark Strand Adept',354,379,18,19,0,{[331]={{31.85,29.4},{32.11,30.03},{31.46,30.14}}},nil,331,nil,nil,21,nil,nil,0},
[3730] = {'Dark Strand Excavator',449,484,19,20,0,{[331]={{31.84,31.52},{31.27,31.49},{31.6,31.18},{31.32,30.98},{31.77,31.06}}},nil,331,nil,nil,21,nil,nil,0},
[3732] = {'Forsaken Seeker',377,404,18,19,0,{[331]={{30.44,25.0},{31.65,23.27},{32.89,22.73},{32.94,21.95},{32.69,21.56},{31.72,23.9},{32.59,22.31},{32.42,20.79},{32.98,21.07},{29.67,24.21},{30.43,24.05},{32.17,23.88}}},nil,331,nil,nil,118,"H",nil,0},
[3733] = {'Forsaken Herbalist',417,449,18,19,0,{[331]={{30.14,24.56},{33.33,21.13},{33.37,21.67},{32.51,22.56},{30.99,24.22},{31.26,22.87},{30.97,22.22},{31.48,20.57}}},nil,331,nil,nil,118,"H",nil,0},
[3734] = {'Forsaken Thug',484,484,20,20,0,{[331]={{32.26,23.44},{32.13,22.98},{32.56,21.56},{32.13,23.33},{32.81,21.07},{32.83,21.09}}},nil,331,nil,nil,118,"H",nil,0},
[3735] = {'Apothecary Falthis',472,472,22,22,4,{[331]={{33.2,21.1},{32.64,21.98},{33.17,21.91}}},nil,331,nil,nil,118,"H",nil,0},
[3736] = {'Darkslayer Mordenthal',617,617,23,23,0,{[331]={{75.57,74.05}}},nil,331,nil,nil,118,"H",nil,0},
[3737] = {'Saltspittle Puddlejumper',449,484,19,20,0,{[331]={{19.99,45.07},{18.99,40.29},{20.09,44.17},{19.3,43.14},{19.35,42.2},{21.82,42.45},{21.08,43.11}}},nil,331,nil,nil,18,nil,nil,0},
[3739] = {'Saltspittle Warrior',449,484,19,20,0,{[331]={{20.47,44.76},{21.28,43.58},{19.41,41.53},{18.9,41.28},{21.82,41.2},{21.12,43.09},{21.01,40.48}}},nil,331,nil,nil,18,nil,nil,0},
[3740] = {'Saltspittle Muckdweller',494,531,20,21,0,{[331]={{19.22,43.93},{21.12,42.23}}},nil,331,nil,nil,18,nil,nil,0},
[3742] = {'Saltspittle Oracle',442,473,20,21,0,{[331]={{20.48,44.0},{21.1,43.99},{20.59,42.2},{20.48,43.25},{20.57,40.7}}},nil,331,nil,nil,18,nil,nil,0},
[3743] = {'Foulweald Warrior',786,846,23,24,0,{[331]={{56.96,64.73},{56.43,64.9},{52.92,63.76},{49.96,61.29},{50.1,61.9},{49.33,60.46},{56.27,62.03},{55.7,62.19},{54.58,63.0},{54.12,62.98},{54.13,63.92},{53.44,63.75},{51.12,60.51},{51.65,60.49},{53.49,60.92}}},nil,331,nil,nil,82,nil,nil,0},
[3745] = {'Foulweald Pathfinder',617,664,23,24,0,{[331]={{50.79,61.19},{54.31,62.21},{53.81,61.16}}},{[331]={{{53.84,61.29},{54.04,61.45},{54.15,61.57},{54.29,61.84},{54.13,61.96},{53.97,61.62},{53.77,61.2},{53.61,60.97},{53.41,60.77},{53.23,60.63},{53.17,60.26},{53.27,60.64},{53.52,60.84},{53.66,61.03}}}},331,nil,nil,82,nil,nil,0},
[3746] = {'Foulweald Den Watcher',664,713,24,25,0,{[331]={{54.69,61.91},{50.21,60.4},{49.97,59.9},{54.19,61.39}}},nil,331,nil,nil,82,nil,nil,0},
[3748] = {'Foulweald Shaman',582,622,24,25,0,{[331]={{54.39,62.41},{49.73,59.98},{50.06,59.65},{54.35,61.6}}},nil,331,nil,nil,82,nil,nil,0},
[3749] = {'Foulweald Ursa',664,713,24,25,0,{[331]={{54.65,61.5},{50.24,60.07},{50.19,59.63},{53.79,62.04}}},nil,331,nil,nil,82,nil,nil,0},
[3750] = {'Foulweald Totemic',543,582,23,24,0,{[331]={{56.0,64.9},{49.39,61.45},{50.65,60.67},{53.98,64.19},{53.96,64.83},{53.53,63.0},{52.99,62.99},{57.59,63.99},{55.68,62.98},{55.26,62.32},{55.24,62.93},{50.55,61.34}}},nil,331,nil,nil,82,nil,nil,0},
[3752] = {'Xavian Rogue',950,1003,29,30,0,{[331]={{78.34,43.69},{77.58,46.17},{78.08,45.31},{78.83,46.66},{78.4,45.12},{78.51,44.76}}},nil,331,nil,nil,90,nil,nil,0},
[3754] = {'Xavian Betrayer',896,950,28,29,0,{[331]={{78.27,46.4},{78.26,45.63}}},nil,331,nil,nil,90,nil,nil,0},
[3755] = {'Xavian Felsworn',769,812,28,29,0,{[331]={{78.42,47.48},{78.39,42.96},{78.35,42.21},{77.31,44.89},{79.61,46.86},{77.83,46.69},{77.83,45.78},{79.29,47.35},{78.92,45.78}}},nil,331,nil,nil,90,nil,nil,0},
[3757] = {'Xavian Hellcaller',812,852,29,30,0,{[331]={{77.8,42.52},{77.73,44.78},{77.85,44.43},{79.06,45.55},{78.67,45.35},{78.23,44.8}}},nil,331,nil,nil,90,nil,nil,0},
[3758] = {'Felmusk Satyr',734,788,25,26,0,{[331]={{68.95,53.36},{68.61,52.79},{66.8,52.57},{66.32,52.56},{66.25,51.67},{66.79,56.09}}},nil,331,nil,nil,90,nil,nil,0},
[3759] = {'Felmusk Rogue',788,840,26,27,0,{[331]={{66.14,53.42},{67.31,54.63},{66.87,54.45},{66.57,56.82}}},nil,331,nil,nil,90,nil,nil,0},
[3762] = {'Felmusk Felsworn',640,684,25,26,0,{[331]={{68.61,53.57},{66.14,55.18},{66.74,55.27},{67.35,55.38},{66.8,51.8},{66.13,54.29},{67.89,54.37}}},nil,331,nil,nil,90,nil,nil,0},
[3763] = {'Felmusk Shadowstalker',788,840,26,27,0,{[331]={{68.37,54.46},{68.21,53.9},{66.85,56.99},{67.12,56.41},{66.19,56.39},{66.43,53.96},{66.73,57.17},{67.33,55.59}}},nil,331,nil,nil,90,nil,nil,0},
[3765] = {'Bleakheart Satyr',788,840,26,27,0,{[331]={{80.03,50.22},{81.12,50.79},{81.74,48.19}}},nil,331,nil,nil,90,nil,nil,0},
[3767] = {'Bleakheart Trickster',840,896,27,28,0,{[331]={{80.5,49.78},{80.68,48.98},{80.83,49.31},{81.52,49.96},{81.3,50.4},{81.9,48.98},{81.87,52.14}}},nil,331,nil,nil,90,nil,nil,0},
[3770] = {'Bleakheart Shadowstalker',840,896,27,28,0,{[331]={{81.0,48.97},{81.71,49.22},{81.83,49.28},{81.45,49.55},{81.32,49.27},{80.69,49.69},{81.15,50.33},{81.23,51.57},{81.12,48.45},{80.51,48.64}}},nil,331,nil,nil,90,nil,nil,0},
[3771] = {'Bleakheart Hellcaller',684,724,26,27,0,{[331]={{82.4,51.7},{82.97,49.89},{82.39,49.96},{79.97,49.01},{80.63,50.88},{79.64,49.29},{79.93,50.78},{79.54,50.12}}},nil,331,nil,nil,90,nil,nil,0},
[3772] = {'Lesser Felguard',544,582,23,24,0,{[331]={{28.38,60.88},{25.27,63.4},{22.21,58.6},{21.76,59.82},{22.88,62.29},{23.79,63.42},{28.05,59.52},{29.07,59.46},{28.84,62.18},{28.05,63.09},{26.88,63.15},{26.09,62.56},{25.65,61.41}}},nil,331,nil,nil,90,nil,nil,0},
[3773] = {'Akkrilus',684,684,26,26,4,{[331]={{25.62,63.54}}},{[331]={{{25.62,63.54},{25.94,63.69},{26.25,63.7},{26.61,63.69},{26.97,63.59},{27.24,63.44},{27.68,63.11},{28.0,62.8},{28.2,62.46},{28.35,62.01},{28.38,61.63},{28.4,61.09},{28.41,61.34},{28.36,61.88},{28.2,62.39},{27.99,62.71},{27.82,63.01},{27.57,63.39},{27.32,63.62},{26.99,63.74},{26.63,63.82},{26.28,63.86},{26.04,63.84},{25.67,63.81},{25.24,63.76},{24.95,63.7},{24.6,63.56},{24.25,63.39},{24.02,63.27},{23.67,63.11},{23.45,62.98},{23.12,62.73},{22.8,62.49},{22.55,62.25},{22.33,61.9},{22.18,61.62},{21.97,61.18},{21.83,60.79},{21.67,60.29},{21.59,60.03},{21.69,60.35},{21.78,60.69},{21.88,61.02},{22.05,61.47},{22.21,61.76},{22.37,62.03},{22.64,62.39},{22.84,62.59},{23.16,62.84},{23.38,62.99},{23.72,63.17},{23.95,63.28},{24.19,63.38},{24.54,63.51},{24.78,63.54},{25.1,63.56},{25.35,63.6}}}},331,nil,nil,90,nil,nil,0},
[3774] = {'Felslayer',573,617,22,23,0,{[331]={{23.37,63.2},{27.66,64.24},{21.74,62.03},{24.66,63.83},{21.19,58.73},{21.66,60.49},{21.67,61.26},{22.16,62.15},{25.22,60.88},{25.48,60.56},{28.8,58.81},{28.18,64.16},{28.5,62.96},{28.42,61.16},{28.57,61.51},{26.6,64.06},{26.34,63.94}}},nil,331,nil,nil,90,nil,nil,0},
[3777] = {'Aelyssa',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[3778] = {'Myielea Starwhisper',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[3779] = {'Syurana',3398,3398,55,55,0,{[618]={{51.56,29.81}}},nil,618,nil,nil,80,"A","Trade Goods Supplies",6},
[3780] = {'Shadethicket Moss Eater',531,617,21,23,0,{[331]={{47.0,48.51},{47.27,46.44},{47.57,47.48},{46.46,44.12},{47.07,44.25},{46.79,47.84},{47.65,44.65},{46.97,44.81},{45.88,48.06},{46.05,44.86},{45.58,44.03},{45.82,43.25},{44.96,45.07},{46.28,45.79},{45.41,45.84},{45.86,46.93},{46.12,48.33}}},nil,331,nil,nil,16,nil,nil,0},
[3781] = {'Shadethicket Wood Shaper',544,582,23,24,0,{[331]={{32.69,70.2},{33.94,69.26},{33.25,69.74},{35.35,67.4},{32.02,67.42},{30.96,68.49},{34.08,65.73},{32.4,66.17},{34.6,67.54},{31.77,65.68}}},nil,331,nil,nil,16,nil,nil,0},
[3782] = {'Shadethicket Stone Mover',734,788,25,26,0,{[331]={{65.24,80.1},{66.22,82.06},{78.96,57.89},{85.17,69.03},{64.52,67.45},{65.56,65.53},{60.88,76.75},{66.58,84.03},{85.78,68.06},{59.03,78.93},{71.1,55.55},{59.78,77.94},{66.64,64.42},{59.72,78.59},{81.36,63.67},{70.75,56.04},{69.7,60.34},{78.46,59.65},{78.35,61.2},{78.42,62.95},{67.44,80.85},{82.37,64.1},{79.35,70.09},{79.29,66.39},{66.87,81.12},{65.55,79.68},{78.71,53.54},{66.74,80.52},{68.64,62.89}}},nil,331,nil,nil,16,nil,nil,0},
[3783] = {'Shadethicket Raincaller',508,544,22,23,0,{[331]={{31.36,71.58},{34.01,70.06},{32.09,69.03},{32.7,72.41},{31.61,67.54},{32.71,70.64},{34.49,68.35},{34.91,67.3},{34.36,66.45},{34.31,67.44},{33.7,65.68},{31.53,68.37},{30.77,69.23},{32.74,68.5},{32.88,72.04},{33.21,67.33},{33.29,68.18},{33.64,66.23},{33.72,67.27},{32.45,67.48},{33.11,64.46},{34.19,64.7}}},nil,331,nil,nil,16,nil,nil,0},
[3784] = {'Shadethicket Bark Ripper',788,840,26,27,0,{[331]={{65.8,81.75},{58.9,79.19},{85.28,67.53},{84.07,64.85},{62.01,74.92},{65.88,80.3},{66.93,83.96},{86.01,68.77},{59.84,79.63},{66.99,82.06},{67.05,81.47},{63.0,71.62},{80.57,62.5},{69.86,57.89},{79.06,64.88},{74.65,46.48},{78.97,72.54},{71.9,54.26},{80.56,73.39},{66.65,79.72},{79.39,73.57}}},nil,331,nil,nil,16,nil,nil,0},
[3789] = {'Terrowulf Fleshripper',895,950,28,29,0,{[331]={{49.82,39.6},{49.7,39.23},{50.05,39.63},{52.71,33.54},{53.32,32.78},{53.38,37.73},{53.16,37.57},{53.2,37.36},{52.84,35.52},{50.96,38.0},{50.16,38.3},{49.9,38.55},{50.3,39.47}}},nil,331,nil,nil,16,nil,nil,0},
[3791] = {'Terrowulf Shadow Weaver',950,1002,29,30,0,{[331]={{52.03,37.79},{50.01,39.04},{50.05,39.05},{49.91,39.27},{50.34,39.2}}},nil,331,nil,nil,16,nil,nil,0},
[3792] = {'Terrowulf Packlord',1162,1162,32,32,4,{[331]={{49.77,39.61}}},{[331]={{{49.77,39.61},{49.89,39.61},{50.02,39.58},{50.21,39.52},{50.3,39.43},{50.35,39.29},{50.33,39.17},{50.29,39.1},{50.14,38.99},{50.01,38.94},{49.87,38.95},{49.78,39.08},{49.71,39.22},{49.66,39.44}}}},331,nil,nil,14,nil,nil,0},
[3793] = {'Initiate Druid',42,42,1,1,0,nil,nil,0,nil,nil,79,"A",nil,0},
[3794] = {'Druid of the Talon',3052,3052,60,60,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3795] = {'Druid of the Claw',3052,3052,60,60,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3796] = {'Druid of the Wild',42,42,1,1,0,nil,nil,0,nil,nil,79,"A",nil,0},
[3797] = {'Cenarion Protector',640,683,25,26,0,{[331]={{62.24,50.84},{61.94,50.94},{61.93,51.73},{62.17,51.15},{62.12,50.75},{62.14,51.23},{61.97,50.85},{62.4,50.88}}},nil,331,nil,nil,124,"A",nil,0},
[3799] = {'Severed Druid',769,812,28,29,0,{[331]={{74.76,76.49},{76.99,76.2},{76.27,75.63},{77.38,74.69},{78.38,75.03},{76.23,75.0},{75.47,74.3},{76.11,73.2},{74.89,73.41}}},nil,331,nil,nil,16,nil,nil,0},
[3801] = {'Severed Sleeper',768,811,28,29,0,{[331]={{75.26,73.13},{74.72,74.17},{75.74,76.22}}},nil,331,nil,nil,16,nil,nil,0},
[3802] = {'Severed Dreamer',739,773,29,30,0,{[331]={{77.79,74.27}}},nil,331,nil,nil,16,nil,nil,0},
[3803] = {'Severed Keeper',811,851,29,30,0,{[331]={{77.34,75.27},{76.22,75.39},{75.43,75.13}}},nil,331,nil,nil,16,nil,nil,0},
[3804] = {'Forsaken Intruder',896,950,28,29,0,{[331]={{76.74,76.02},{76.89,74.88},{75.06,71.5},{75.12,72.25}}},nil,331,nil,nil,118,"H",nil,0},
[3806] = {'Forsaken Infiltrator',950,1003,29,30,0,{[331]={{77.89,75.23},{77.91,73.37},{77.31,73.92},{77.37,75.91},{77.15,74.33},{75.78,74.47},{75.46,71.86},{75.07,71.95},{78.28,75.26},{75.83,76.14}}},nil,331,nil,nil,118,"H",nil,0},
[3807] = {'Forsaken Assassin',950,1003,29,30,0,{[331]={{75.45,74.64},{77.96,73.95},{76.7,74.12},{75.25,73.97},{76.34,75.19},{78.44,74.63},{76.29,74.51},{75.23,72.42},{74.79,74.01}}},nil,331,nil,nil,118,"H",nil,0},
[3808] = {'Forsaken Dark Stalker',896,950,28,29,0,{[331]={{75.91,74.71},{77.27,72.97},{76.63,73.49},{77.2,76.22},{75.68,75.73},{75.63,75.04},{76.15,75.47},{75.28,71.32},{75.48,72.3}}},nil,331,nil,nil,118,"H",nil,0},
[3809] = {'Ashenvale Bear',662,714,21,22,0,{[331]={{67.87,85.51},{39.8,67.19},{45.14,61.34},{44.95,57.97},{56.25,54.56},{45.92,59.59},{51.61,44.0},{39.54,62.23},{41.27,61.95},{46.78,61.85},{36.68,68.29},{37.44,71.52},{55.25,55.1},{54.77,51.33},{43.22,58.6},{48.26,65.08},{45.91,60.38},{37.88,62.21},{38.85,64.14},{42.46,61.26},{47.34,53.27},{39.65,63.31},{66.76,83.87},{38.28,62.77},{45.0,53.44},{43.09,62.91},{45.9,60.75},{41.89,61.36},{40.57,66.65},{44.3,65.86},{42.85,59.83},{37.79,39.36},{44.68,62.52},{42.04,70.04},{44.13,63.83},{41.06,71.13},{40.64,66.15},{51.43,55.27},{49.35,51.05},{47.71,53.62},{47.22,52.76},{67.17,78.19},{36.5,70.02},{44.63,66.73},{38.52,70.3},{45.82,63.31},{48.36,53.46},{50.13,45.09},{32.52,42.45},{50.42,55.09},{51.48,50.26},{41.44,66.93},{39.29,40.81},{38.45,37.53},{40.37,42.6},{37.61,60.23},{55.47,53.31},{45.94,42.61},{39.62,65.21},{63.73,77.22},{42.92,44.06},{31.55,40.68},{41.98,43.13},{43.46,45.96},{42.42,44.27},{39.53,40.52},{41.32,43.87},{41.01,66.6},{45.81,64.96},{39.31,70.43},{39.39,69.33},{50.77,53.4},{48.71,63.33},{44.39,51.3},{52.27,54.4},{41.37,69.73},{56.97,55.84},{50.64,47.54},{50.45,44.96},{51.28,56.21},{55.03,53.82},{50.06,51.82},{52.67,53.9},{33.69,35.82},{45.52,54.58},{66.47,78.7},{50.36,56.15},{42.13,64.49},{67.93,85.53},{66.13,86.51},{66.98,76.78}},[17]={{47.14,4.57}}},nil,331,nil,nil,44,nil,nil,0},
[3810] = {'Elder Ashenvale Bear',909,975,25,26,0,{[331]={{61.07,63.5},{62.12,64.54},{73.04,47.38},{73.22,46.61},{62.57,64.07},{62.69,61.98},{62.08,63.5},{71.22,49.76},{67.4,50.15},{68.69,50.24},{69.71,50.89},{68.84,50.84},{64.49,55.5},{64.33,56.78},{64.16,58.51},{64.69,58.67},{61.69,62.1},{70.49,50.04},{70.96,49.71},{71.73,49.11},{72.21,48.24},{69.95,51.14},{73.63,47.81},{62.3,61.74},{72.48,51.82},{73.16,50.9},{62.22,66.91},{65.13,60.28},{68.46,61.49},{66.12,62.68},{64.7,59.15},{71.91,52.15},{65.85,60.6},{65.64,63.13},{63.81,55.18},{63.88,53.65},{70.75,54.55},{66.03,63.54},{67.41,62.0},{63.22,68.32},{69.04,59.49},{69.57,56.63}}},nil,331,nil,nil,44,nil,nil,0},
[3811] = {'Giant Ashenvale Bear',1176,1242,29,30,0,{[331]={{88.94,46.61},{82.93,48.44},{82.59,47.05}}},nil,331,nil,nil,44,nil,nil,0},
[3812] = {'Clattering Crawler',449,484,19,20,0,{[331]={{12.6,15.96},{11.81,29.1},{12.94,22.19},{10.18,14.55},{11.11,28.56},{12.45,22.93},{13.48,21.14},{10.62,32.05},{10.77,15.52},{9.0,17.63},{6.7,12.99},{11.96,27.32},{12.71,18.8},{8.83,31.12},{9.14,14.61},{12.39,28.38},{9.96,35.42},{12.49,14.51},{15.39,27.35},{14.61,21.39},{10.07,33.4},{12.58,30.31},{13.46,28.54},{13.99,29.42},{9.55,13.67},{12.85,26.63},{11.76,32.7},{10.03,29.74},{11.95,13.84},{12.87,30.66},{9.03,16.11},{8.38,17.04}}},nil,331,nil,nil,7,"AH",nil,0},
[3814] = {'Spined Crawler',494,531,20,21,0,{[331]={{8.31,15.6},{7.81,10.99},{9.72,31.02},{10.84,30.68},{7.29,17.04},{14.25,22.07},{8.96,26.73},{9.9,16.28},{11.31,24.79},{6.23,13.57},{11.13,16.28},{9.01,28.55},{10.62,25.89},{9.5,34.56},{9.75,32.6},{8.31,13.27},{10.14,31.95},{8.96,33.53},{13.59,19.82},{11.81,15.62},{8.9,12.99},{13.61,23.07},{9.51,15.41},{10.72,17.07},{9.45,11.74},{5.86,15.23},{8.56,12.09},{11.81,16.98},{12.46,21.44},{14.96,18.03},{10.73,32.54},{11.45,31.69},{12.92,15.24},{13.54,30.17},{14.06,18.95},{11.25,14.55}}},nil,331,nil,nil,7,"AH",nil,0},
[3815] = {'Blink Dragon',788,840,26,27,0,{[331]={{62.15,50.82},{61.95,51.19},{50.34,46.3}}},nil,331,nil,nil,7,"AH",nil,0},
[3816] = {'Wild Buck',417,449,18,19,0,{[331]={{21.12,32.95},{17.61,37.36},{23.83,26.77},{16.35,35.89},{21.85,33.17},{19.4,35.45},{19.77,35.85},{17.1,36.79},{22.42,33.8},{31.45,27.26},{18.13,38.84},{20.51,32.98},{29.23,26.41},{20.24,31.65},{18.73,34.44},{22.24,29.78},{28.76,26.42},{16.72,17.46},{22.73,29.93},{19.99,38.09},{17.03,38.33},{32.08,25.8},{24.77,25.95},{25.3,23.56},{16.51,22.51},{21.67,37.7},{28.29,30.46},{21.64,38.44},{18.05,38.06},{19.63,27.74},{22.38,35.79},{32.6,27.58},{22.95,28.71},{18.99,38.24},{19.6,38.82},{21.83,37.58},{22.32,34.29},{33.39,28.05},{28.83,31.86},{28.61,28.86},{26.6,27.63},{28.58,22.64},{29.02,21.96},{29.07,28.88},{22.28,39.9},{28.0,34.45},{27.67,31.89},{16.96,20.91},{26.9,15.58},{26.18,17.77},{25.36,15.67},{26.08,15.83},{26.77,17.07},{22.18,30.73},{27.5,17.88},{26.78,20.62},{26.19,19.65},{29.48,27.47},{28.78,17.97},{23.06,38.86},{27.36,33.79},{15.91,24.78},{17.64,30.35},{16.89,29.42},{19.07,28.95},{28.25,17.19},{29.11,31.92},{17.99,29.95},{23.53,35.88},{16.51,28.41},{24.06,36.67},{15.96,23.85},{15.94,30.03},{26.32,35.36},{17.93,25.03},{29.8,26.57},{22.77,34.53},{30.5,19.15},{27.99,18.59},{15.33,30.89},{28.72,15.13}}},nil,331,nil,nil,189,"AH",nil,0},
[3817] = {'Shadowhorn Stag',573,617,22,23,0,{[331]={{52.57,54.52},{39.52,70.3},{38.61,67.57},{54.16,53.07},{41.53,59.34},{51.07,45.2},{51.03,49.95},{45.77,62.09},{45.38,64.49},{50.22,50.4},{37.83,71.49},{46.29,63.64},{56.0,51.82},{51.14,54.34},{40.01,69.23},{38.66,66.44},{49.47,62.95},{47.34,60.93},{46.5,61.25},{48.17,63.07},{54.87,55.67},{39.23,62.94},{39.07,63.76},{37.03,67.49},{38.45,60.29},{44.75,59.36},{50.23,51.2},{49.79,48.7},{50.11,46.58},{48.77,62.31},{49.91,46.73},{36.82,71.59},{45.4,60.42},{42.03,65.77},{56.3,56.42},{54.26,51.74},{50.31,52.78},{55.47,52.69},{41.25,68.11},{39.95,63.48},{40.59,72.88},{51.81,53.31},{41.36,61.91},{55.56,55.18},{42.89,68.5},{46.09,66.29},{39.43,65.66},{52.27,56.57},{57.96,57.73},{38.37,68.09},{52.05,45.36},{43.01,58.75},{42.5,60.96},{41.1,64.42},{43.13,62.83},{35.86,69.29},{43.0,64.19},{37.58,61.82},{43.57,63.4},{47.49,52.29},{44.43,62.64},{42.11,70.04},{51.52,48.64},{54.22,54.17},{37.57,61.08},{47.0,53.5},{41.51,71.08},{48.64,55.94},{52.2,64.06},{56.3,57.9}}},nil,331,nil,nil,189,"AH",nil,0},
[3818] = {'Elder Shadowhorn Stag',788,840,26,27,0,{[331]={{65.79,67.34},{65.79,66.52},{53.6,35.19},{52.54,35.34},{60.31,44.86},{58.22,43.73},{58.12,34.49},{55.37,35.3},{57.01,34.53},{56.28,33.29},{53.56,32.67},{56.99,30.98},{55.02,30.2},{54.94,32.9},{56.94,29.5},{54.5,34.91},{58.05,31.01},{58.7,35.49},{58.36,33.51},{59.14,35.85},{61.85,39.61},{63.88,44.05},{67.0,64.97},{69.22,69.16},{67.96,66.99},{67.93,69.97},{62.89,44.74},{64.42,50.95},{62.22,47.51},{61.97,44.03},{60.99,42.22},{61.38,46.5},{59.37,43.76},{61.54,42.78},{60.65,47.0},{58.14,42.21},{62.08,41.72},{59.35,43.03},{58.67,41.14},{58.3,41.69},{56.47,41.1},{55.82,41.25},{57.18,42.13},{68.55,68.99},{69.12,67.23},{66.85,68.3},{69.01,67.98},{66.28,68.98},{68.39,64.43},{59.32,38.18},{55.76,39.72},{57.13,37.94},{54.06,40.82},{54.54,39.51},{60.61,38.02},{69.52,65.6},{69.12,69.87},{69.65,63.87},{72.78,56.5},{54.14,31.56},{61.18,45.77},{58.67,37.03},{55.18,33.89},{56.28,29.97},{57.87,38.86},{57.52,32.36},{72.08,57.26},{73.18,56.17},{75.95,52.18},{76.39,53.35},{71.86,56.88},{75.79,53.87},{72.73,54.4},{71.28,57.12},{76.63,54.82},{75.85,55.85},{76.23,57.73},{73.64,56.04}}},nil,331,nil,nil,189,"AH",nil,0},
[3819] = {'Wildthorn Stalker',494,531,20,21,0,{[331]={{70.45,86.08},{19.06,52.05},{22.7,55.49},{22.75,48.95},{19.08,49.61},{30.88,56.45},{21.62,49.29},{20.18,57.69},{18.86,56.41},{21.21,56.66},{17.67,46.7},{16.8,45.27},{17.02,47.38},{27.14,52.89},{32.06,37.1},{23.81,47.07},{21.4,57.92},{26.95,51.33},{20.89,48.19},{15.45,45.48},{29.54,52.89},{35.67,59.49},{26.05,51.58},{22.94,46.68},{18.35,54.1},{24.61,55.35},{28.57,56.11},{23.28,46.81},{29.31,50.6},{18.74,48.0},{22.28,57.75},{18.72,58.75},{24.64,53.62},{22.94,48.47},{26.97,51.47},{20.9,50.07},{19.17,55.61},{28.95,57.11},{15.27,44.93},{19.2,57.56},{20.69,49.53},{39.76,39.79},{43.52,47.66},{18.97,54.83},{34.77,57.62},{20.58,58.15},{23.15,57.45},{18.29,51.88},{17.67,51.63},{19.38,50.0},{22.42,48.76},{28.95,54.65},{77.14,73.54},{70.52,85.78},{39.28,41.28},{37.36,39.16},{32.74,37.67},{38.17,38.9},{68.58,72.82},{73.03,79.2},{33.35,40.34},{61.46,79.44},{41.57,39.43},{33.04,42.0},{40.67,41.47},{37.71,31.81},{34.35,33.62},{38.8,38.66},{78.34,66.3},{38.25,40.1},{40.67,43.47},{41.02,40.76},{32.02,49.2},{30.96,53.77},{63.87,85.56},{64.31,84.76},{64.17,86.59},{63.37,79.55},{64.51,85.46},{63.54,77.79},{64.97,84.59},{73.72,70.83},{62.17,78.76},{41.76,44.5},{42.01,43.92},{35.49,45.2},{44.24,50.16},{42.53,47.46},{43.04,46.47},{30.39,49.8},{33.31,37.05},{25.74,43.33},{33.25,53.44},{35.67,56.06},{31.08,52.65},{26.04,49.39},{35.0,55.17},{34.95,58.77},{30.9,48.92},{30.96,59.23},{30.26,49.33},{35.51,40.56},{30.61,51.96},{70.38,84.7},{64.92,83.65},{62.76,78.87},{65.57,85.48},{73.74,78.68},{70.56,76.28}}},nil,331,nil,nil,22,nil,nil,0},
[3820] = {'Wildthorn Venomspitter',664,713,24,25,0,{[331]={{64.32,54.63},{55.82,73.73},{56.28,71.58},{58.16,70.59},{72.39,46.93},{62.2,62.19},{74.03,47.56},{57.21,78.47},{66.91,48.92},{66.74,48.58},{67.39,49.85},{73.43,50.75},{72.61,48.13},{72.46,49.01},{68.59,49.09},{56.97,77.84},{57.62,66.51},{57.64,72.82},{57.19,73.51},{66.74,63.07},{55.36,76.85},{55.71,75.91},{56.89,69.49},{70.89,54.08},{65.79,62.88},{57.57,70.35},{54.09,71.17},{64.03,55.3}}},nil,331,nil,nil,22,nil,nil,0},
[3821] = {'Wildthorn Lurker',896,950,28,29,0,{[331]={{92.88,55.59},{91.23,50.78},{92.06,51.51},{93.33,53.5},{90.77,47.74},{90.92,63.84},{90.99,55.35},{82.02,62.26},{92.78,51.34},{89.3,44.91},{88.94,47.18},{89.93,45.99},{81.04,45.92},{83.76,48.71},{88.74,68.32},{88.51,66.25},{91.78,45.9},{89.8,68.27},{90.89,61.34},{90.69,65.71},{83.84,44.65},{82.86,55.05},{82.91,49.16},{83.47,47.8},{81.11,46.39},{90.14,67.46}}},nil,331,nil,nil,22,nil,nil,0},
[3823] = {'Ghostpaw Runner',449,484,19,20,0,{[331]={{18.38,47.38},{30.09,54.95},{27.54,54.47},{19.04,56.44},{19.32,54.1},{27.01,52.9},{17.82,51.27},{25.49,52.51},{33.65,60.46},{17.7,46.32},{23.2,55.96},{21.83,60.37},{16.81,45.39},{24.67,54.01},{25.4,53.78},{26.33,52.64},{63.62,85.71},{23.02,47.58},{19.3,58.26},{30.06,56.7},{22.6,62.04},{22.92,47.57},{19.53,21.11},{21.89,46.59},{26.92,26.12},{20.09,49.03},{15.67,45.74},{28.3,55.13},{29.56,13.8},{25.99,22.12},{27.09,18.59},{25.85,15.86},{24.5,49.12},{26.49,14.71},{17.91,35.7},{16.51,36.36},{31.34,49.77},{23.48,28.48},{21.9,30.18},{60.89,80.41},{31.32,50.85},{18.79,33.56},{30.54,51.9},{32.31,50.55},{35.21,58.31},{17.69,50.28},{30.14,48.02},{23.23,29.31},{25.72,21.1},{63.85,85.25},{16.51,21.33},{76.02,66.81},{29.8,19.75},{22.86,32.97},{19.99,29.78},{28.1,27.49},{19.2,27.39},{23.81,35.99},{62.74,77.6},{27.42,31.44},{30.67,51.66},{33.24,59.62},{66.26,84.7},{67.24,85.94},{65.58,87.25},{66.81,85.56},{72.24,81.66},{66.13,86.02},{73.31,78.52}}},nil,331,nil,nil,38,nil,nil,0},
[3824] = {'Ghostpaw Howler',617,664,23,24,0,{[331]={{54.49,71.97},{53.52,70.72},{57.75,68.85},{55.84,70.04},{56.79,70.8},{57.69,73.55},{57.65,75.16},{57.47,78.55},{57.28,77.76},{56.72,74.09},{56.61,75.65},{58.76,66.47},{57.37,77.37},{56.44,71.85},{60.44,71.52},{59.13,68.91},{57.62,65.41},{60.93,71.33},{58.03,72.06},{55.17,76.89},{59.94,71.25},{58.7,67.58},{56.11,74.44},{58.38,67.57},{55.02,75.12},{59.46,73.66},{57.73,68.48},{56.81,70.12},{54.46,70.99},{53.62,70.35},{58.97,68.21},{54.67,69.5},{54.77,69.69},{62.19,70.08}}},nil,331,nil,nil,38,nil,nil,0},
[3825] = {'Ghostpaw Alpha',840,896,27,28,0,{[331]={{68.2,69.16},{64.37,49.36},{60.96,43.18},{63.09,45.27},{65.68,69.14},{66.57,70.07},{68.59,63.98},{69.2,67.68},{70.37,64.27},{68.47,65.34},{69.95,65.07},{65.7,68.32},{71.91,58.02},{65.26,69.26},{58.92,41.63},{60.55,45.91},{57.26,34.16},{77.84,55.43},{67.61,69.6},{75.94,57.22},{73.7,55.38},{73.37,54.82},{71.99,55.61},{74.58,55.92},{76.29,55.49}}},nil,331,nil,nil,38,nil,nil,0},
[3826] = {'Rabid Ghostpaw',42,42,1,1,0,nil,nil,0,nil,nil,38,nil,nil,0},
[3832] = {'Cenarion Steward',42,42,1,1,0,nil,nil,0,nil,nil,79,"A",nil,0},
[3833] = {'Cenarion Vindicator',683,724,26,27,0,{[331]={{62.22,51.23},{61.96,51.1}}},nil,331,nil,nil,124,"A",nil,0},
[3834] = {'Crazed Ancient',840,896,27,28,0,{[331]={{61.52,43.3},{57.26,31.42},{58.75,36.07},{60.06,38.79},{61.97,44.54},{57.78,39.09},{58.17,41.38}}},nil,331,nil,nil,91,nil,nil,0},
[3835] = {'Biletoad',8,8,1,1,0,{[17]={{49.17,32.66},{48.55,31.84},{48.27,34.39},{48.14,32.25},{48.93,33.77},{47.87,34.1},{47.64,32.2},{46.03,33.81},{46.54,32.27},{46.1,34.41},{46.25,34.15}},[718]={{-1,-1}}},nil,17,nil,nil,7,"AH",nil,0},
[3836] = {'Mountaineer Pebblebitty',2138,2138,44,44,0,{[38]={{18.18,84.01}}},nil,38,{3182},{3181,3201},55,"A",nil,3},
[3837] = {'Riding Hippogryph',1040,1040,29,29,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3838] = {'Vesprystus',7842,7842,55,55,1,{[141]={{58.4,94.02}}},nil,141,{6342},{6341},80,"A","Hippogryph Master",11},
[3839] = {'Voidlasher',1347,1452,19,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[3840] = {'Druid of the Fang',1212,1299,19,20,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[3841] = {'Caylais Moonfeather',7842,7842,55,55,1,{[148]={{36.34,45.58}}},nil,148,nil,nil,80,"A","Hippogryph Master",11},
[3842] = {'Brombar Higgleby',1752,1752,40,40,0,{[1537]={{52.57,37.26}}},nil,1537,nil,nil,55,"A","The Keymaster",2},
[3843] = {'Anaya',356,356,16,16,0,nil,nil,0,nil,nil,84,"A",nil,0},
[3844] = {'Healing Ward IV',562,562,22,22,0,nil,nil,0,nil,nil,109,nil,nil,0},
[3845] = {'Shindrell Swiftfire',712,712,25,25,0,{[331]={{34.67,48.84}}},nil,331,{1008,1134,4581},{1008,1133,1134},80,"A",nil,3},
[3846] = {'Talen',385,385,17,17,0,{[331]={{14.79,31.29}}},nil,331,{1007,1009},{1007,1009},80,"A",nil,3},
[3847] = {'Orendil Broadleaf',840,840,27,27,0,{[331]={{26.44,38.59}}},nil,331,{1010,1020},{1010},80,"A",nil,2},
[3848] = {'Kayneth Stillwind',1106,1106,31,31,0,{[331]={{85.24,44.71}}},{[331]={{{85.24,44.71},{85.25,44.44},{85.21,44.4},{85.23,44.57},{85.24,44.71}}}},331,{1011,1012},{1011,1012,4261,4581},80,"A",nil,3},
[3849] = {'Deathstalker Adamant',1251,1251,18,18,1,{[209]={{-1,-1}}},nil,209,nil,nil,68,"H",nil,1},
[3850] = {'Sorcerer Ashcrombe',1062,1062,18,18,1,{[209]={{-1,-1}}},nil,209,nil,nil,12,"A",nil,1},
[3851] = {'Shadowfang Whitescalp',1131,1212,18,19,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3852] = {'Shadowfang Bloodhowler',1347,1347,19,19,1,nil,nil,0,nil,nil,24,nil,nil,0},
[3853] = {'Shadowfang Moonwalker',1299,1299,20,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3854] = {'Shadowfang Wolfguard',1452,1452,20,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3855] = {'Shadowfang Darksoul',1392,1392,21,21,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3857] = {'Shadowfang Glutton',1563,1563,21,21,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3859] = {'Shadowfang Ragetooth',1953,1953,24,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3860] = {'Shadowfang Tainted One',1215,1215,20,20,1,nil,nil,0,nil,nil,24,nil,nil,0},
[3861] = {'Bleak Worg',1251,1347,18,19,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3862] = {'Slavering Worg',1251,1251,18,18,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3863] = {'Lupine Horror',1953,1953,24,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3864] = {'Fel Steed',1347,1452,19,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,15,"AH",nil,0},
[3865] = {'Shadow Charger',1452,1563,20,21,1,{[209]={{-1,-1}}},nil,209,nil,nil,32,"AH",nil,0},
[3866] = {'Vile Bat',1686,1815,22,23,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3868] = {'Blood Seeker',1815,1953,23,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3869] = {'Lesser Gargoyle',1452,1452,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[3870] = {'Stone Sleeper',1452,1452,20,20,1,nil,nil,0,nil,nil,16,nil,nil,0},
[3872] = {'Deathsworn Captain',2097,2097,25,25,2,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3873] = {'Tormented Officer',1815,1953,23,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3875] = {'Haunted Servitor',1452,1563,20,21,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3876] = {'Traumatized Spirit',1452,1452,20,20,1,nil,nil,0,nil,nil,24,nil,nil,0},
[3877] = {'Wailing Guardsman',1563,1686,21,22,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3878] = {'Magthrull\'s Doomguard',484,484,20,20,0,nil,nil,0,nil,nil,90,nil,nil,0},
[3879] = {'Dark Strand Assassin',531,531,21,21,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3880] = {'Sentinel Melyria Frostshadow',712,712,25,25,0,{[331]={{22.23,52.98}}},nil,331,{1022,1037},{1022},80,"A",nil,2},
[3881] = {'Grimtak',300,300,14,14,0,{[14]={{51.13,42.63}}},nil,14,nil,nil,29,"H","Butcher",7},
[3882] = {'Zlagk',176,176,9,9,0,{[14]={{42.64,67.19}}},nil,14,nil,nil,29,"H","Butcher",6},
[3883] = {'Moodan Sungrain',222,222,11,11,0,{[215]={{44.65,77.9}}},nil,215,nil,nil,104,"H","Baker",6},
[3884] = {'Jhawna Oatwind',273,273,13,13,0,{[215]={{47.63,61.49}}},nil,215,nil,nil,104,"H","Baker",6},
[3885] = {'Sentinel Velene Starstrike',712,712,25,25,0,{[331]={{49.8,67.21}}},nil,331,{1016,1017},{1016,1017},80,"A",nil,3},
[3886] = {'Razorclaw the Butcher',2248,2248,22,22,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3887] = {'Baron Silverlaine',3255,3255,24,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[3888] = {'Korra',484,484,20,20,0,{[331]={{36.61,49.55}}},{[331]={{{36.61,49.55},{36.61,49.55},{36.54,49.59},{36.46,49.69},{36.4,49.68},{36.36,49.69},{36.75,49.86},{36.86,49.92},{37.03,50.07},{36.97,50.37},{36.97,50.37},{37.0,50.19},{36.92,49.98},{36.69,49.79},{36.68,49.56}}}},331,nil,nil,80,"A",nil,0},
[3890] = {'Brakgul Deathbringer',157200,157200,61,61,1,{[1637]={{79.39,30.3}}},nil,1637,nil,nil,1515,"H","Warsong Gulch Battlemaster",2049},
[3891] = {'Teronis\' Corpse',484,484,20,20,0,{[331]={{20.31,42.33}}},nil,331,{1023},{991},80,"A",nil,2},
[3892] = {'Relara Whitemoon',42,42,1,1,0,{[331]={{37.4,51.71}}},nil,331,nil,nil,80,"A",nil,2},
[3893] = {'Forsaken Scout',617,617,23,23,0,nil,nil,0,nil,nil,68,"H",nil,0},
[3894] = {'Pelturas Whitemoon',531,531,21,21,0,{[331]={{37.37,51.79}}},nil,331,{1033,1034,1035},{1020,1033,1034,1035},124,"A",nil,2},
[3895] = {'Captain Noteo',57,57,1,1,0,nil,nil,0,nil,nil,35,"AH","Boat Operator",0},
[3896] = {'Captain Hart',48,48,1,1,0,nil,nil,0,nil,nil,35,"AH","Boat Operator",0},
[3897] = {'Krolg',176,176,9,9,0,{[331]={{50.84,75.08}}},nil,331,{1045,1046},{1030,1045},934,nil,nil,2},
[3898] = {'Aligar the Tormentor',664,664,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3899] = {'Balizar the Umbrage',539,539,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3900] = {'Caedakar the Vicious',582,582,24,24,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3901] = {'Illiyana',787,787,26,26,0,{[331]={{21.73,53.34}}},nil,331,{1021,1032},{1031,1032},80,"A",nil,2},
[3902] = {'Searing Totem II',484,484,20,20,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3903] = {'Searing Totem III',1402,1402,37,37,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3904] = {'Searing Totem IV',2125,2125,45,45,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3906] = {'Healing Stream Totem II',61,61,35,35,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3907] = {'Healing Stream Totem III',92,92,45,45,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3908] = {'Healing Stream Totem IV',110,110,50,50,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3909] = {'Healing Stream Totem V',152,152,60,60,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3911] = {'Stoneclaw Totem II',294,294,29,29,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3912] = {'Stoneclaw Totem III',594,594,40,40,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3913] = {'Stoneclaw Totem IV',634,634,38,38,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3914] = {'Rethilgore',1936,1936,20,20,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,"The Cell Keeper",0},
[3915] = {'Dagri',617,617,23,23,0,{[331]={{36.68,49.7}}},nil,331,nil,nil,80,"A","Raene's Pet",0},
[3916] = {'Shael\'dryn',664,664,24,24,0,{[331]={{53.54,46.22}}},nil,331,{1026,1027,1028,1029},{1024,1026,1027,1055},80,"A",nil,2},
[3917] = {'Befouled Water Elemental',544,622,23,25,0,{[331]={{45.08,69.3},{46.09,69.92},{46.26,70.66},{51.22,73.36},{48.35,72.76},{52.13,72.25},{51.86,70.48},{51.52,70.15},{51.6,69.49},{48.32,70.95},{47.94,71.88},{49.18,71.85},{50.89,72.04},{50.32,70.29},{50.22,72.2},{50.71,71.63},{51.02,71.35},{46.4,67.43},{46.14,68.66},{50.92,67.42},{48.05,69.69},{49.36,69.85},{47.69,69.6},{47.66,70.71},{46.97,70.61},{47.56,69.05},{47.13,67.44},{48.0,68.14},{49.47,69.55},{49.8,71.1},{50.55,69.52},{52.14,72.75},{46.59,71.75}}},nil,331,nil,nil,91,nil,nil,0},
[3919] = {'Withered Ancient',788,840,26,27,0,{[331]={{59.33,42.06},{58.18,33.71},{55.07,33.12},{57.7,41.76},{54.48,34.07},{54.69,34.44},{54.76,34.99}}},nil,331,nil,nil,91,nil,nil,0},
[3920] = {'Anilia',712,712,25,25,0,{[331]={{78.33,44.82}}},nil,331,{1031},{1021},1076,"A",nil,2},
[3921] = {'Thistlefur Ursa',617,664,23,24,0,{[331]={{40.41,32.15},{41.21,33.99},{40.86,32.09},{38.21,30.77},{39.2,30.6},{39.59,31.46},{40.34,33.52},{40.08,34.19},{39.92,33.42},{41.69,32.87},{42.56,34.13}}},nil,331,nil,nil,82,nil,nil,0},
[3922] = {'Thistlefur Totemic',543,582,23,24,0,{[331]={{42.28,35.12},{42.32,34.32},{41.06,34.78},{40.41,31.39},{41.33,32.0},{39.86,31.89},{40.17,32.61},{37.99,30.24},{39.68,33.27},{39.82,32.47},{40.73,31.89},{40.88,32.83},{41.04,33.16},{42.28,33.71},{42.81,34.48},{42.84,33.77}}},nil,331,nil,nil,82,nil,nil,0},
[3923] = {'Thistlefur Den Watcher',617,664,23,24,0,{[331]={{41.41,35.49},{40.71,34.24},{40.96,31.73},{41.64,33.65},{41.51,32.42}}},nil,331,nil,nil,82,nil,nil,0},
[3924] = {'Thistlefur Shaman',543,582,23,24,0,{[331]={{36.14,36.98},{35.9,36.64},{39.64,36.84},{39.54,36.42},{39.76,36.35},{35.7,36.94},{38.52,35.4},{37.81,34.88},{37.91,34.21},{35.83,31.74},{36.09,31.96},{32.58,42.75},{32.1,38.93},{31.58,39.52},{34.99,32.76},{37.89,35.44},{36.06,32.7},{33.56,38.71},{33.89,38.85},{34.08,38.44},{34.19,38.87},{33.75,39.73},{30.93,45.0},{30.98,44.41},{30.98,44.0},{30.98,43.27},{30.28,42.26},{31.04,40.39},{31.59,43.92}}},nil,331,nil,nil,82,nil,nil,0},
[3925] = {'Thistlefur Avenger',617,664,23,24,0,{[331]={{39.56,37.73},{39.06,36.85},{37.93,34.52},{39.96,37.87},{39.26,36.28},{37.74,33.92},{35.78,32.01},{32.63,42.16},{31.74,38.0},{37.42,34.27},{35.64,32.83},{36.71,36.96},{36.64,36.06},{31.86,39.24},{32.05,43.15},{33.48,36.6},{36.69,32.71},{33.4,37.53},{36.77,35.24},{31.55,45.66},{31.38,45.24},{32.62,39.57}}},nil,331,nil,nil,82,nil,nil,0},
[3926] = {'Thistlefur Pathfinder',617,664,23,24,0,{[331]={{39.44,36.82},{38.68,39.21},{36.21,32.08},{38.06,30.75},{39.09,36.11}}},nil,331,nil,nil,82,nil,nil,0},
[3927] = {'Wolf Master Nandos',4194,4194,25,25,1,{[209]={{-1,-1}}},nil,209,nil,nil,14,nil,nil,0},
[3928] = {'Rotting Slime',494,573,20,22,0,{[331]={{69.04,84.77},{77.03,73.8},{79.08,74.48},{70.53,73.58},{70.68,85.06},{69.29,82.67},{71.29,83.83},{77.97,65.82},{77.38,69.77},{77.06,68.3},{69.87,74.11},{78.3,73.6},{76.22,67.48},{76.62,70.67},{76.77,72.19},{78.31,69.73},{68.24,77.68},{77.68,72.63},{74.77,69.6},{78.26,64.58},{70.72,75.24},{74.23,69.47},{74.36,70.21},{75.88,73.52},{75.87,69.99},{69.89,85.32},{74.34,77.92},{70.1,76.08},{74.58,77.19},{74.67,75.39},{76.67,68.46},{68.94,84.86},{74.41,73.38},{74.46,75.56},{73.09,73.23},{71.04,73.8},{71.45,76.97},{73.68,76.95},{72.63,76.86},{70.77,75.99},{72.51,75.12}}},nil,331,nil,nil,14,nil,nil,0},
[3931] = {'Shadethicket Oracle',1003,1003,30,30,0,{[331]={{66.66,82.17}}},nil,331,nil,nil,16,nil,nil,0},
[3932] = {'Bloodtooth Guard',840,895,27,28,0,{[331]={{55.94,76.21},{54.93,75.96},{55.52,75.2},{54.67,79.72},{54.75,79.07},{55.85,75.42},{54.98,79.33},{54.76,77.69},{54.4,79.58},{55.37,76.0},{54.86,78.82}}},nil,331,nil,nil,82,nil,nil,0},
[3933] = {'Hai\'zan',300,300,14,14,0,{[14]={{55.63,73.61}}},nil,14,nil,nil,126,"H","Butcher",6},
[3934] = {'Innkeeper Boorand Plainswind',1002,1002,30,30,0,{[17]={{51.99,29.89}}},nil,17,nil,nil,29,"H","Innkeeper",135},
[3935] = {'Toddrick',198,198,10,10,0,{[12]={{44.24,65.97}}},nil,12,nil,nil,12,"A","Butcher",4},
[3936] = {'Shandris Feathermoon',4369,4369,62,62,0,{[357]={{30.28,46.17}}},nil,357,{2866,3130,4267},{2867,4266},80,"A","General of the Sentinel Army",3},
[3937] = {'Kira Songshine',247,247,12,12,0,{[12]={{42.46,66.05}}},{[12]={{{42.32,65.45},{41.74,63.77},{41.53,63.21},{41.21,62.39},{41.02,61.48},{40.65,60.39},{40.32,59.49},{40.11,58.7},{39.88,57.61},{39.65,56.91},{39.22,56.31},{38.87,55.85},{38.37,55.22},{37.9,54.52},{37.41,53.95},{36.87,53.72},{36.31,53.69},{35.56,53.63},{34.93,53.51},{34.56,53.33},{34.24,53.1},{33.76,52.56},{33.41,51.97},{33.0,51.23},{33.39,52.04},{33.56,52.31},{33.9,52.72},{34.23,53.15},{34.55,53.44},{34.9,53.55},{35.29,53.66},{35.62,53.69},{36.0,53.75},{36.76,53.77},{37.33,53.91},{37.66,54.19},{38.35,55.19},{38.72,55.75},{39.01,56.15},{39.61,56.74},{39.84,57.5},{39.9,58.0},{40.12,58.93},{40.39,59.92},{40.6,60.43},{40.93,61.24},{41.19,62.06},{41.36,62.94},{41.64,63.78},{41.95,64.39},{42.25,64.91},{42.45,65.65},{42.4,66.2},{42.54,67.11},{43.06,67.51},{43.78,68.01},{44.13,68.28},{44.48,68.57},{45.04,68.95},{45.78,69.36},{46.67,69.6},{47.52,69.61},{46.57,69.54},{45.76,69.32},{45.12,69.02},{44.67,68.68},{44.37,68.39},{43.98,68.17},{43.42,67.76},{42.79,67.25},{42.3,67.14},{41.65,66.85},{41.29,66.72},{40.6,66.56},{40.05,66.68},{39.41,66.79},{39.05,66.76},{38.56,67.12},{37.95,67.78},{37.26,68.85},{37.54,68.25},{37.68,68.09},{38.0,67.58},{38.41,67.33},{38.95,66.81},{39.45,66.71},{39.9,66.62},{40.25,66.63},{40.81,66.71},{41.35,66.83},{41.88,66.88},{42.17,66.78},{42.3,66.54},{42.47,66.03}}}},12,nil,nil,12,"A","Traveling Baker",4},
[3938] = {'Roth Bluntblade',328,328,15,15,0,nil,nil,0,nil,nil,11,"A","Kira's Guard",0},
[3939] = {'Razormane Wolf',137,156,7,8,0,nil,nil,0,nil,nil,109,nil,nil,0},
[3940] = {'Taneel Darkwood',976,976,32,32,0,{[331]={{77.18,73.99}}},nil,331,nil,nil,15,"AH",nil,0},
[3941] = {'Uthil Mooncall',976,976,32,32,0,{[331]={{77.96,72.74}}},nil,331,nil,nil,15,"AH",nil,0},
[3942] = {'Mavoris Cloudsbreak',976,976,32,32,0,{[331]={{75.05,74.2}}},nil,331,nil,nil,15,"AH",nil,0},
[3943] = {'Ruuzel',731,731,22,22,0,{[331]={{7.22,13.06}}},nil,331,nil,nil,74,nil,nil,0},
[3944] = {'Wrathtail Priestess',442,473,20,21,0,{[331]={{6.58,15.5},{6.38,14.53},{5.53,15.18},{5.99,11.74},{5.37,13.69},{7.4,12.52},{5.62,14.47},{7.82,14.42},{6.67,11.18},{7.84,13.36},{8.44,14.58},{7.25,16.19},{7.75,16.95},{7.18,11.79},{8.35,16.13}}},nil,331,nil,nil,74,nil,nil,0},
[3945] = {'Caravaneer Ruzzgot',1110,1110,33,33,0,{[33]={{27.37,74.08}}},nil,33,{1041},{1040},120,"AH",nil,2},
[3946] = {'Velinde Starsong',48,48,1,1,0,nil,nil,0,nil,nil,84,"A",nil,0},
[3947] = {'Goblin Shipbuilder',1347,1452,19,20,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[3948] = {'Honni Goldenoat',198,198,10,10,0,{[38]={{35.32,49.73}}},nil,38,nil,nil,55,"A","Baker",6},
[3950] = {'Minor Water Guardian',16,16,1,1,0,nil,nil,0,nil,nil,91,nil,nil,0},
[3951] = {'Bhaldaran Ravenshade',1279,1279,34,34,0,{[331]={{50.27,67.27}}},nil,331,nil,nil,80,"A","Bowyer",16388},
[3952] = {'Aeolynn',573,573,22,22,0,{[331]={{34.47,49.52}}},nil,331,nil,nil,80,"A","Clothier",16388},
[3953] = {'Tandaan Lightmane',617,617,23,23,0,{[331]={{34.55,49.9}}},nil,331,nil,nil,80,"A","Leather Armor Merchant",16388},
[3954] = {'Dalria',664,664,24,24,0,{[331]={{35.12,52.12}}},nil,331,nil,nil,80,"A","Trade Goods",6},
[3955] = {'Shandrina',664,664,24,24,0,{[331]={{49.48,67.09}}},nil,331,nil,nil,80,"A","Trade Goods",6},
[3956] = {'Harklan Moongrove',664,664,24,24,0,{[331]={{50.84,67.0}}},nil,331,nil,nil,80,"A","Alchemy Supplies",6},
[3957] = {'Jainay Featherbreeze',896,896,28,28,0,nil,nil,0,nil,nil,80,"A","Cooking Supplies",0},
[3958] = {'Lardan',712,712,25,25,0,{[331]={{34.79,49.84}}},nil,331,nil,nil,80,"A","Leatherworking Supplies",6},
[3959] = {'Nantar',531,531,21,21,0,{[331]={{37.14,49.9}}},nil,331,nil,nil,80,"A","Baker",6},
[3960] = {'Ulthaan',787,787,26,26,0,{[331]={{50.01,66.64}}},nil,331,nil,nil,80,"A","Butcher",6},
[3961] = {'Maliynn',449,449,19,19,0,{[331]={{36.62,49.98}}},nil,331,nil,nil,80,"A","Food & Drink Vendor",6},
[3962] = {'Haljan Oakheart',787,787,26,26,0,{[331]={{34.85,50.87}}},nil,331,nil,nil,80,"A","General Goods",6},
[3963] = {'Danlaar Nightstride',1342,1342,35,35,0,{[331]={{50.14,67.95}}},nil,331,nil,nil,80,"A","Hunter Trainer",19},
[3964] = {'Kylanna',1106,1106,31,31,0,{[331]={{50.85,67.11}}},nil,331,nil,nil,80,"A","Expert Alchemist",19},
[3965] = {'Cylania Rootstalker',664,664,24,24,0,{[331]={{50.69,67.17}}},nil,331,nil,nil,80,"A","Herbalist",19},
[3966] = {'Kaleem',664,664,24,24,0,nil,nil,0,nil,nil,80,"A","Cook",0},
[3967] = {'Aayndia Floralwind',1536,1536,37,37,0,{[331]={{35.98,52.1}}},nil,331,nil,nil,80,"A","Expert Leatherworker",19},
[3968] = {'Sentry Totem',15,15,40,40,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[3969] = {'Fahran Silentblade',895,895,28,28,0,{[331]={{36.49,49.46}}},nil,331,nil,nil,80,"A","Tools & Supplies",4},
[3970] = {'Llana',712,712,25,25,0,{[331]={{34.98,48.46}}},nil,331,nil,nil,80,"A","Reagent Supplies",4},
[3971] = {'Agro 5',4120,4120,60,60,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3972] = {'Agro 7',4120,4120,60,60,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3973] = {'Agro 10',4120,4120,60,60,0,nil,nil,0,nil,nil,14,nil,nil,0},
[3974] = {'Houndmaster Loksey',7736,7736,34,34,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3975] = {'Herod',12192,12192,40,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,"The Scarlet Champion",0},
[3976] = {'Scarlet Commander Mograine',5945,5945,42,42,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3977] = {'High Inquisitor Whitemane',5284,5284,42,42,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3978] = {'Sage Truthseeker',1002,1002,30,30,0,{[1638]={{34.4,46.87}}},nil,1638,{1049,2440,2965},{1049,2280,2968},104,"H",nil,2},
[3979] = {'Librarian Mae Paledust',1002,1002,30,30,0,{[1537]={{74.97,12.48}}},nil,1537,{1050},{1050},55,"A","Explorers' League",2},
[3980] = {'Raleigh the Devout',1002,1002,30,30,0,{[267]={{51.47,58.35}}},nil,267,{1053},{1052,1053},12,"A",nil,2},
[3981] = {'Vorrel Sengutz',155,155,8,8,0,{[796]={{-1,-1}}},nil,796,{1051},nil,68,"H",nil,2},
[3982] = {'Monika Sengutz',137,137,7,7,0,{[267]={{62.67,18.88}}},nil,267,nil,{1051},68,"H",nil,2},
[3983] = {'Interrogator Vishas',5328,5328,32,32,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[3984] = {'Nancy Vishas',3330,3330,33,33,1,{[36]={{32.33,32.78}}},{[36]={{{32.33,32.78},{32.1,32.61},{31.99,32.49},{31.78,32.27},{31.57,32.01},{31.35,31.78},{31.21,31.64},{31.21,31.64},{31.47,31.9},{31.69,32.14},{31.91,32.41},{32.06,32.58},{32.33,32.78}}}},36,nil,nil,16,nil,nil,0},
[3985] = {'Grandpa Vishas',3489,3489,34,34,1,{[36]={{32.33,32.98}}},nil,36,nil,nil,16,nil,nil,0},
[3986] = {'Sarilus Foulborne',573,573,25,25,0,{[17]={{48.22,19.15}}},nil,17,nil,nil,118,"H",nil,0},
[3987] = {'Dal Bloodclaw',713,713,25,25,0,{[331]={{37.74,34.73}}},nil,331,nil,nil,82,nil,nil,0},
[3988] = {'Venture Co. Operator',449,484,19,20,0,{[406]={{69.99,55.86},{67.09,52.41},{71.8,50.03},{70.8,43.15},{75.74,56.57},{74.22,54.15},{71.54,49.72},{71.08,42.5},{74.29,54.88},{75.16,56.2},{62.79,53.46},{62.73,53.48},{62.63,53.85},{61.47,51.36},{62.51,53.84},{73.42,48.7},{65.58,51.65},{66.25,51.66},{62.14,52.05},{66.43,45.5},{67.05,45.51},{66.44,45.73},{72.79,49.3},{73.27,56.67}}},nil,406,nil,nil,47,nil,nil,0},
[3989] = {'Venture Co. Logger',417,449,18,19,0,{[406]={{74.31,59.06},{74.81,58.92},{65.63,47.37},{67.99,57.16},{70.22,50.34},{63.11,46.13},{71.62,43.18},{71.02,44.07},{66.3,51.12},{66.84,51.26},{71.58,44.09},{65.4,57.28},{70.14,56.41},{74.36,59.68},{70.34,53.5},{65.57,49.2},{68.07,48.99},{66.76,49.49},{68.67,50.18},{68.32,50.6},{65.99,52.06},{66.01,51.73},{65.77,51.64},{66.4,52.49},{67.25,55.22},{66.72,55.15},{69.47,54.21},{69.6,53.13},{72.44,51.46},{71.5,56.6},{65.36,50.5},{75.12,55.17},{66.4,51.32},{66.32,51.83},{65.45,54.1},{64.8,52.63},{66.32,56.51},{60.66,54.91},{60.54,53.51},{62.7,55.31},{64.95,56.56},{61.48,55.34},{60.65,54.11},{59.44,52.26},{59.97,53.32},{66.08,46.37},{65.48,45.22},{67.66,49.92},{66.08,49.39},{64.85,44.9},{64.19,45.52},{64.29,47.98},{65.39,46.16},{66.68,45.9},{67.04,45.12},{72.23,49.21},{72.94,51.2},{72.09,55.36},{73.11,54.01},{70.94,55.17},{69.55,55.19},{68.89,54.18},{64.17,57.46},{63.61,54.36},{63.45,55.24},{64.02,55.31},{64.82,48.13}}},nil,406,nil,nil,47,nil,nil,0},
[3990] = {'Venture Co. Cutter',356,386,16,17,0,nil,nil,0,nil,nil,47,nil,nil,0},
[3991] = {'Venture Co. Deforester',379,405,19,20,0,{[406]={{74.56,58.65},{75.11,59.22},{74.51,58.99},{64.22,46.03},{67.22,51.5},{66.53,50.89},{66.66,51.32},{64.91,50.94},{66.89,57.66},{74.54,59.3},{74.43,59.41},{60.52,51.48},{67.58,48.16},{68.83,56.43},{66.43,52.32},{65.76,55.41},{70.32,54.58},{65.98,58.18},{70.93,57.12},{65.84,50.57},{66.18,49.97},{65.24,53.45},{61.85,54.33},{61.45,54.0},{60.58,52.1},{63.35,56.75},{64.89,45.75},{64.15,47.23},{71.03,48.35},{71.58,47.69},{73.68,53.2},{73.73,55.25},{71.55,54.63},{68.11,55.31},{67.47,56.32},{64.08,49.03}}},nil,406,nil,nil,47,nil,nil,0},
[3992] = {'Venture Co. Engineer',494,531,20,21,0,{[406]={{62.85,40.81},{64.35,38.89},{64.17,39.03},{64.06,38.79}}},nil,406,nil,nil,47,nil,nil,0},
[3993] = {'Venture Co. Machine Smith',531,573,21,22,0,{[406]={{62.76,40.32},{63.43,39.92},{64.51,39.97}}},nil,406,nil,nil,47,nil,nil,0},
[3994] = {'Keeper Albagorm',1002,1002,30,30,0,{[406]={{37.1,8.1}}},nil,406,{1057,1059},{1056,1057},80,"A",nil,2},
[3995] = {'Witch Doctor Jin\'Zil',712,712,25,25,0,{[406]={{74.54,97.94}}},{[406]={{{74.54,97.83},{74.62,97.8},{74.68,97.94},{74.66,98.03},{74.64,98.09},{74.61,98.15},{74.58,98.15},{74.52,98.06},{74.51,97.96},{74.54,97.94}}}},406,{1058},{1058,1060},29,"H",nil,2},
[3996] = {'Faldreas Goeth\'Shael',449,449,19,19,0,{[331]={{35.77,49.1}}},nil,331,{1056},nil,80,"A",nil,2},
[3997] = {'Venture Co. Overboss',531,573,21,22,0,nil,nil,0,nil,nil,47,nil,nil,0},
[3998] = {'Windshear Vermin',494,531,20,21,0,nil,nil,0,nil,nil,22,nil,nil,0},
[3999] = {'Windshear Digger',531,573,21,22,0,{[406]={{74.96,59.35},{74.98,58.5},{74.34,58.96},{72.35,59.77},{74.12,60.03},{74.45,59.69},{72.63,61.22},{71.89,60.84},{72.67,60.83},{73.71,60.17},{72.85,60.5},{73.28,59.66},{72.94,60.61},{73.2,59.83},{72.26,61.73},{72.53,62.55},{72.69,63.01},{73.45,59.98},{72.32,62.32},{72.34,60.71},{71.95,61.38},{72.38,61.09},{72.23,60.4},{72.84,59.4},{73.11,59.1},{71.79,62.19},{72.34,61.04},{72.55,61.42},{73.07,59.93},{73.04,58.31},{73.88,60.65},{73.02,62.66},{73.51,60.71},{71.96,62.85},{72.42,62.24},{72.24,62.76},{71.7,60.02},{72.05,61.13},{71.66,60.46},{72.09,61.56},{73.01,61.57},{71.66,60.76},{73.21,61.97},{72.93,62.28},{73.34,61.35},{73.3,60.53}}},nil,406,nil,nil,26,nil,nil,0},
[4001] = {'Windshear Tunnel Rat',449,484,19,20,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4002] = {'Windshear Stonecutter',617,617,23,23,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4003] = {'Windshear Geomancer',413,441,20,21,0,{[406]={{74.43,58.39},{75.67,59.2},{73.53,58.74},{73.13,61.06},{73.92,59.62},{73.8,59.26},{74.11,59.48}}},nil,406,nil,nil,26,nil,nil,0},
[4004] = {'Windshear Overlord',531,573,21,22,0,{[406]={{74.21,59.53},{72.57,60.2},{72.42,62.41},{72.69,59.57},{73.84,59.66},{72.45,61.17},{73.02,62.31},{72.96,61.16},{73.82,60.12}}},nil,406,nil,nil,26,nil,nil,0},
[4005] = {'Deepmoss Creeper',356,386,16,17,0,{[406]={{58.98,73.79},{64.93,83.45},{59.09,72.72},{60.83,71.93},{65.36,92.28},{64.27,93.44},{53.79,75.9},{54.67,74.77},{54.58,75.18},{53.39,75.81},{53.59,76.16},{55.94,76.24},{54.93,75.9},{56.25,76.37},{57.59,76.3},{61.43,81.58},{61.61,81.8},{58.94,75.66},{59.17,78.08},{60.54,76.46},{60.12,75.12},{67.32,87.74},{68.78,88.63}}},nil,406,nil,nil,22,nil,nil,0},
[4006] = {'Deepmoss Webspinner',449,484,19,20,0,{[406]={{79.34,51.49},{77.08,44.3},{74.62,45.99},{75.13,43.22},{77.48,53.38},{77.26,50.34},{76.81,54.15},{76.9,52.48},{76.38,50.87},{78.64,52.87},{74.32,45.93},{75.54,44.52},{60.12,48.45},{74.2,43.7},{75.74,52.18},{76.12,50.56},{73.6,42.65},{59.43,49.3},{59.81,49.98},{61.7,48.53},{60.79,48.74},{77.63,50.92},{74.15,42.68},{74.14,44.53},{74.83,51.44},{74.91,46.86},{75.72,47.7},{73.03,45.3},{61.29,46.01},{76.1,53.12},{76.24,43.13},{76.47,45.08},{77.37,44.98},{76.54,46.04},{75.71,45.99},{54.47,71.94},{54.12,71.34},{53.56,71.17},{52.97,71.72},{53.44,71.72},{69.18,40.99},{68.08,45.14},{69.64,45.05},{70.17,46.1},{60.74,47.14}}},nil,406,nil,nil,22,nil,nil,0},
[4007] = {'Deepmoss Venomspitter',290,313,17,18,0,{[406]={{48.85,45.38},{49.06,47.31},{46.84,46.16},{53.17,43.03},{47.16,47.36},{52.44,41.83},{48.55,48.56},{54.04,73.91},{53.76,72.7},{51.83,56.6},{51.77,47.27},{60.56,59.73},{62.22,59.38},{61.11,59.38},{61.11,60.44},{61.82,61.02},{52.29,58.43},{60.48,62.96},{60.89,63.77},{52.66,62.2},{54.73,72.79},{48.32,44.11},{54.78,73.62},{52.71,73.54},{52.75,75.58},{52.95,74.42},{53.42,74.94},{52.16,75.57},{52.48,74.84},{52.53,73.95},{53.7,74.14},{52.87,72.33},{52.87,72.91},{53.2,73.09},{58.98,60.68},{61.18,57.25},{61.66,58.13},{53.43,44.92},{53.97,61.45},{53.24,55.43},{51.24,42.37},{50.89,39.61},{52.03,54.16},{60.99,66.39},{61.47,64.93},{61.64,66.37},{62.14,63.77},{61.56,63.74},{62.1,62.82},{62.44,63.44},{63.13,61.39},{64.85,60.93},{62.73,60.34},{52.48,61.13},{60.0,61.58}}},nil,406,nil,nil,22,nil,nil,0},
[4008] = {'Cliff Stormer',328,386,15,17,0,{[406]={{83.33,90.37},{72.75,88.09},{73.8,88.43},{77.16,87.48},{76.19,83.33},{82.32,91.65},{76.58,83.59},{65.02,94.52},{61.44,72.5},{75.97,94.03},{74.64,88.94},{57.64,72.59},{80.24,84.9},{72.82,88.25},{77.06,95.85},{78.51,94.93},{76.81,95.59}}},nil,406,nil,nil,14,nil,nil,0},
[4009] = {'Raging Cliff Stormer',417,449,18,19,0,{[406]={{77.86,55.66},{70.46,58.57},{60.2,44.85},{78.45,49.97},{69.68,42.25},{51.13,34.87},{72.18,40.19},{58.73,48.43},{76.0,42.46},{79.71,51.66},{63.04,64.23},{63.77,62.98},{66.57,59.2},{62.44,65.73},{50.57,33.13},{49.64,33.4},{65.69,61.01},{51.03,34.6},{47.72,34.86},{47.3,33.63},{50.27,35.35},{50.93,38.59},{49.15,36.94},{48.64,36.45},{48.69,34.9},{47.58,36.58},{61.8,69.35},{58.57,54.53},{59.07,59.83}}},nil,406,nil,nil,14,nil,nil,0},
[4011] = {'Young Pridewing',449,484,19,20,0,{[406]={{77.67,54.09},{60.54,48.72},{77.47,43.85},{62.01,64.28},{63.51,59.21}}},nil,406,nil,nil,16,nil,nil,0},
[4012] = {'Pridewing Wyvern',531,573,21,22,0,{[406]={{46.16,46.87},{46.22,45.35},{44.77,44.76},{46.08,47.41},{54.06,43.46},{55.34,41.82},{51.8,45.67},{52.04,43.4},{52.35,44.58},{54.22,42.61},{54.99,43.34},{50.51,43.22},{50.41,45.39},{51.83,43.16}}},nil,406,nil,nil,16,nil,nil,0},
[4013] = {'Pridewing Skyhunter',617,664,23,24,0,{[406]={{55.37,37.97},{54.61,37.25},{53.88,35.92},{53.03,39.69},{53.7,41.29},{53.08,36.98},{54.16,37.77},{52.69,37.42},{53.36,36.11},{53.38,35.66}}},nil,406,nil,nil,16,nil,nil,0},
[4014] = {'Pridewing Consort',573,617,22,23,0,{[406]={{45.4,45.98},{45.46,46.43},{48.29,41.45},{42.88,38.49},{45.57,46.7},{50.78,44.07},{51.33,44.71},{55.59,43.15},{55.39,42.35},{53.85,35.01},{52.51,39.07},{54.8,40.41},{52.66,38.86},{49.02,40.22}}},nil,406,nil,nil,16,nil,nil,0},
[4015] = {'Pridewing Patriarch',713,713,25,25,4,{[406]={{53.79,36.31},{47.75,46.75}}},nil,406,nil,nil,16,nil,nil,0},
[4016] = {'Fey Dragon',582,622,24,25,0,{[406]={{39.77,13.76},{37.41,20.93}}},nil,406,nil,nil,93,nil,nil,0},
[4017] = {'Wily Fey Dragon',683,724,26,27,0,{[406]={{33.13,13.21}}},nil,406,nil,nil,93,nil,nil,0},
[4018] = {'Antlered Courser',573,617,22,23,0,{[406]={{39.46,7.36},{40.12,8.33},{38.81,8.04},{40.71,6.0},{40.07,11.0},{39.6,9.39},{46.15,21.42},{41.08,11.35},{44.39,23.34},{44.36,25.42},{47.09,31.61},{45.29,23.85},{46.6,27.13},{46.77,27.6},{45.2,23.37},{51.76,35.17},{37.46,16.74},{44.86,22.56},{45.44,20.12},{45.0,21.32},{46.76,38.18},{50.44,36.58},{40.14,15.29}}},nil,406,nil,nil,189,"AH",nil,0},
[4019] = {'Great Courser',664,713,24,25,0,{[406]={{39.21,5.9},{40.05,12.24},{36.27,16.35},{39.86,9.93}}},nil,406,nil,nil,189,"AH",nil,0},
[4020] = {'Sap Beast',573,617,22,23,0,{[406]={{38.76,10.28},{37.15,19.86},{37.41,20.37},{35.66,20.09},{38.13,18.88},{35.71,18.34},{34.78,17.41},{34.74,18.99},{34.14,19.6},{33.41,17.3},{33.67,17.74},{33.17,17.23},{31.96,16.57},{33.71,16.45},{34.8,16.2},{37.38,10.02},{40.03,12.52},{46.79,29.51},{38.22,15.42}}},nil,406,nil,nil,16,nil,nil,0},
[4021] = {'Corrosive Sap Beast',664,713,24,25,0,{[406]={{34.08,11.33},{38.16,17.52},{38.98,19.35},{34.05,20.17},{34.13,13.22},{33.45,18.16}}},nil,406,nil,nil,16,nil,nil,0},
[4022] = {'Bloodfury Harpy',617,664,23,24,0,{[406]={{30.93,59.23},{31.83,58.76},{32.57,60.66},{34.51,60.8},{35.25,63.21},{37.79,44.11},{37.36,49.09},{32.75,64.45},{33.36,64.99},{30.18,64.33},{31.95,66.51},{32.84,64.18},{31.34,60.42}}},nil,406,nil,nil,514,nil,nil,0},
[4023] = {'Bloodfury Roguefeather',734,788,25,26,0,{[406]={{29.3,70.31},{29.72,69.34},{29.49,68.63},{30.8,68.91},{35.53,69.92},{36.75,67.66},{34.86,69.12},{34.69,68.03},{35.46,66.56},{35.33,67.64},{34.71,70.77}}},nil,406,nil,nil,514,nil,nil,0},
[4024] = {'Bloodfury Slayer',640,684,25,26,0,{[406]={{26.79,69.53},{27.37,69.71},{29.2,71.14},{30.24,69.58},{30.12,69.67},{30.06,67.49},{36.98,69.78},{36.98,69.0},{37.28,65.74},{34.89,70.26},{36.21,67.36}}},nil,406,nil,nil,514,nil,nil,0},
[4025] = {'Bloodfury Ambusher',426,457,23,24,0,{[406]={{29.64,62.62},{29.98,61.88},{31.11,58.55},{30.8,61.32},{30.79,65.29},{32.07,60.43}}},nil,406,nil,nil,514,nil,nil,0},
[4026] = {'Bloodfury Windcaller',582,622,24,25,0,{[406]={{30.92,63.09},{32.89,60.74},{31.28,61.37},{29.71,63.62},{30.0,62.64},{30.57,62.52},{34.42,61.99},{34.57,61.45},{34.67,61.31},{33.11,60.09},{32.04,58.93},{31.08,57.76},{35.43,64.27},{35.33,63.41},{29.85,63.98},{32.84,59.09},{31.22,63.85},{31.04,62.11},{35.28,63.23},{32.78,66.31},{32.58,65.62},{32.91,63.32},{32.45,64.59},{32.24,64.91},{32.41,63.74}}},nil,406,nil,nil,514,nil,nil,0},
[4027] = {'Bloodfury Storm Witch',684,724,26,27,0,{[406]={{26.78,68.72},{26.58,70.05},{27.74,67.37},{27.01,69.46},{26.24,68.26},{28.33,67.43},{27.36,69.12},{28.85,68.5},{28.31,70.22},{30.0,68.96},{26.84,70.93},{28.0,69.8},{35.35,68.64},{36.69,69.33},{36.51,68.19}}},nil,406,nil,nil,514,nil,nil,0},
[4028] = {'Charred Ancient',640,683,25,26,0,{[406]={{32.8,63.45},{32.73,72.79},{34.15,67.58}}},nil,406,nil,nil,91,nil,nil,0},
[4029] = {'Blackened Ancient',840,895,27,28,0,{[406]={{30.89,64.73},{32.89,63.2}}},nil,406,nil,nil,91,nil,nil,0},
[4030] = {'Vengeful Ancient',1002,1002,30,30,4,{[406]={{30.45,68.08}}},nil,406,nil,nil,91,nil,nil,0},
[4031] = {'Fledgling Chimaera',734,840,25,27,0,{[406]={{32.84,72.68},{31.44,72.62},{34.69,70.9}}},nil,406,nil,nil,16,nil,nil,0},
[4032] = {'Young Chimaera',544,622,23,25,0,{[406]={{36.27,65.48},{28.98,65.5}}},nil,406,nil,nil,16,nil,nil,0},
[4033] = {'Charred Stone Spirit',573,617,22,23,0,nil,nil,0,nil,nil,91,nil,nil,0},
[4034] = {'Enraged Stone Spirit',664,712,24,25,0,{[406]={{30.38,66.02},{34.05,65.44}}},nil,406,nil,nil,91,nil,nil,0},
[4035] = {'Furious Stone Spirit',788,840,26,27,0,{[406]={{32.04,73.28}}},nil,406,nil,nil,91,nil,nil,0},
[4036] = {'Rogue Flame Spirit',544,582,23,24,0,{[406]={{37.34,60.45},{43.98,41.02},{37.4,49.33},{36.55,51.37},{35.13,53.06},{34.5,59.88},{37.14,48.65},{34.14,63.66}}},nil,406,nil,nil,16,nil,nil,0},
[4037] = {'Burning Ravager',664,713,24,25,0,{[406]={{28.53,63.32},{31.08,67.04},{35.42,66.27},{27.97,66.45},{29.98,65.44}}},nil,406,nil,nil,16,nil,nil,0},
[4038] = {'Burning Destroyer',684,724,26,27,0,{[406]={{33.24,74.88},{32.64,73.51},{31.12,73.82},{29.91,73.63},{31.64,70.82},{36.39,72.16},{35.34,73.68}}},nil,406,nil,nil,16,nil,nil,0},
[4039] = {'Dinnis',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4040] = {'Cave Stalker',531,573,21,22,0,{[11]={{49.52,58.93},{51.44,60.98},{50.78,62.06},{49.82,63.06},{48.59,62.01},{48.64,62.76},{49.26,60.37},{48.41,60.71},{49.76,60.29},{50.35,59.24},{47.02,59.41},{46.9,59.27},{47.48,59.59},{45.92,60.59},{47.46,63.26},{45.68,61.24},{46.68,63.83}}},nil,11,nil,nil,312,nil,nil,0},
[4041] = {'Scorched Basilisk',840,896,27,28,0,{[406]={{37.24,73.47},{32.65,72.18},{31.04,72.14},{33.27,72.71},{32.04,68.66},{30.95,69.81},{30.31,72.12},{35.88,70.54},{35.53,71.36},{34.1,73.81},{34.64,72.55}}},nil,406,nil,nil,49,nil,nil,0},
[4042] = {'Singed Basilisk',734,788,25,26,0,{[406]={{27.83,64.4},{35.96,64.09},{36.01,66.09},{32.66,67.44},{29.27,66.59}}},nil,406,nil,nil,49,nil,nil,0},
[4043] = {'Galthuk',156,156,8,8,0,{[1637]={{82.29,18.86}}},nil,1637,nil,nil,29,"H","Two-Handed Weapons Merchant",16388},
[4044] = {'Blackened Basilisk',617,664,23,24,0,{[406]={{35.55,47.67},{45.81,44.24},{45.07,43.46},{37.03,46.43},{37.44,51.27},{33.48,62.04},{34.96,59.01},{44.14,39.36},{36.12,49.24}}},nil,406,nil,nil,49,nil,nil,0},
[4046] = {'Magatha Grimtotem',4369,4369,62,62,0,{[1638]={{69.85,30.91}}},nil,1638,{1064,3562,5088},{1063,3518,5062},104,"H","Elder Crone",2},
[4047] = {'Zor Lonetree',4369,4369,62,62,0,{[1637]={{38.93,38.4}}},nil,1637,{1061,7541},{1262,7541},29,"H","Elder Far Seer",2},
[4048] = {'Falfindel Waywarder',895,895,28,28,0,{[357]={{89.64,46.57}}},{[357]={{{89.63,46.56},{89.63,46.56},{89.63,46.56},{89.56,46.57},{89.45,46.49},{89.39,46.36},{89.43,46.12},{89.35,45.79},{89.35,45.79},{89.42,46.03},{89.39,46.35},{89.45,46.49},{89.56,46.56},{89.64,46.56}}}},357,{1101},{1059,1100,1101,4281},80,"A",nil,2},
[4049] = {'Seereth Stonebreak',787,787,26,26,0,{[17]={{35.26,27.88}}},nil,17,{1062,1063,1068},{1061,1062,1068},29,"H",nil,2},
[4050] = {'Cenarion Caretaker',1830,1953,25,26,1,{[406]={{29.78,15.6},{29.0,15.5},{29.39,15.84},{29.19,15.99},{29.42,15.69},{28.84,17.59},{29.68,16.9},{29.79,15.24}}},nil,406,nil,nil,124,"A",nil,2},
[4051] = {'Cenarion Botanist',543,582,23,24,0,{[406]={{34.68,12.43},{35.96,14.57},{36.36,11.85},{36.97,14.98}}},nil,406,nil,nil,124,"A",nil,0},
[4052] = {'Cenarion Druid',1953,2070,26,27,1,{[406]={{28.32,12.08},{29.64,16.05},{29.49,16.16},{29.5,14.71},{28.64,14.49},{28.49,13.65},{30.35,15.25},{30.35,15.58},{28.26,13.51},{28.86,15.22},{28.55,14.2},{28.47,13.67},{30.35,15.45},{27.88,13.18},{28.06,13.54},{28.39,13.0}}},nil,406,nil,nil,124,"A",nil,2},
[4053] = {'Daughter of Cenarius',544,622,23,25,0,{[406]={{35.35,12.1},{35.28,11.04},{38.31,13.29},{36.71,15.59},{36.45,13.09}}},nil,406,nil,nil,124,"A",nil,0},
[4054] = {'Laughing Sister',664,712,24,25,0,{[331]={{58.05,58.43},{58.66,56.87},{59.05,57.01},{58.43,57.97},{59.17,56.25},{61.54,51.43},{61.51,50.08},{62.34,49.69},{60.99,49.22},{60.74,51.83},{60.94,50.84},{60.74,52.99},{60.96,51.84},{61.53,52.23},{58.71,59.7},{60.55,55.89},{59.79,55.37},{59.87,56.17},{59.83,54.69},{59.86,53.44},{58.56,54.31},{59.25,54.42},{58.68,55.06},{60.35,55.3},{58.91,56.09},{58.07,56.01}}},nil,331,nil,nil,79,"A",nil,0},
[4055] = {'Mirkfallon Glade Strider',42,42,1,1,0,nil,nil,0,nil,nil,79,"A",nil,0},
[4056] = {'Mirkfallon Keeper',2250,2400,26,27,1,{[406]={{27.15,14.16},{25.59,12.56},{25.86,13.47},{25.66,13.98},{26.24,12.52},{25.64,11.53},{27.02,14.13},{25.69,11.58},{26.05,13.04},{25.39,13.03}}},nil,406,nil,nil,79,"A",nil,2},
[4057] = {'Son of Cenarius',664,713,24,25,0,{[406]={{35.44,15.28},{38.22,11.42},{35.9,10.51},{35.82,12.59},{37.19,12.38},{35.29,13.11},{37.45,13.14}}},nil,406,nil,nil,124,"A",nil,0},
[4059] = {'Forest Spirit',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4061] = {'Mirkfallon Dryad',2097,2250,25,26,1,{[406]={{26.65,12.46},{27.09,11.83},{27.6,12.8},{27.36,12.15},{26.81,10.69},{26.91,13.94},{27.39,12.78},{27.18,12.84},{27.13,12.72},{26.99,10.69},{29.65,14.13},{28.27,12.55},{26.7,10.95},{26.82,11.84},{27.74,13.86},{28.18,12.12},{29.5,13.58},{26.94,13.33}}},nil,406,nil,nil,79,"A",nil,2},
[4062] = {'Dark Iron Bombardier',1050,1107,30,31,0,{[45]={{49.63,88.99},{48.56,88.76}}},nil,45,nil,nil,54,nil,nil,0},
[4063] = {'Feeboz',1196,1196,39,39,0,{[45]={{67.84,37.82}}},nil,45,nil,nil,15,"AH",nil,0},
[4064] = {'Blackrock Scout',1452,1563,20,21,1,{[44]={{65.39,48.77},{61.22,63.57},{62.28,64.51},{64.37,61.61},{62.16,66.27},{68.03,52.82},{62.07,63.92},{63.25,49.6},{65.75,49.28},{63.48,48.19},{63.67,49.9},{63.15,49.4},{62.86,49.04},{63.53,49.19},{63.1,49.95},{63.04,48.88},{63.44,49.42},{65.22,61.64},{65.51,60.16},{66.04,59.64},{66.77,60.38}}},nil,44,nil,nil,40,nil,nil,0},
[4065] = {'Blackrock Sentry',1563,1686,21,22,1,{[44]={{69.5,54.04},{69.59,54.38},{61.22,63.57},{64.37,61.61},{64.55,62.05},{62.16,66.27},{68.03,52.82},{69.54,59.68},{67.06,56.43},{65.61,49.75},{66.26,57.31},{66.14,56.93},{67.52,53.29},{67.12,54.01},{69.64,54.35},{70.02,57.48},{68.17,54.64},{67.66,55.8},{67.67,56.33},{69.75,53.98},{68.23,56.03},{69.34,54.73},{69.1,56.3},{63.25,49.6},{69.26,56.71},{69.05,56.81},{69.06,55.39},{65.85,54.06},{65.44,54.76},{69.36,58.03},{65.75,49.28},{63.48,48.19},{63.67,49.9},{66.39,53.34},{63.15,49.4},{62.86,49.04},{63.11,48.7},{63.1,49.95},{63.04,48.88},{63.44,49.42},{65.51,60.16},{66.04,59.64},{68.56,58.47},{66.77,60.38},{68.27,58.42},{68.16,59.01}}},nil,44,nil,nil,40,nil,nil,0},
[4066] = {'Nal\'taszar',2433,2433,30,30,2,{[406]={{25.57,11.48}}},nil,406,nil,nil,79,"A",nil,0},
[4067] = {'Twilight Runner',617,664,23,24,0,{[406]={{30.91,9.62},{38.97,12.11},{39.57,17.74},{32.17,10.36},{31.63,12.68},{33.05,8.02},{31.03,11.49},{33.28,9.93},{32.21,8.89},{34.47,9.14},{34.32,7.96},{34.53,10.12},{33.3,12.27},{32.71,11.11},{32.11,11.51}}},nil,406,nil,nil,16,nil,nil,0},
[4068] = {'Serpent Messenger',39,39,10,10,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4069] = {'Venture Co. Planner',377,404,18,19,0,nil,nil,0,nil,nil,47,nil,nil,0},
[4070] = {'Venture Co. Builder',494,531,20,21,0,{[406]={{63.4,40.66},{64.17,39.68},{64.09,39.46}}},{[406]={{{63.39,40.71},{63.14,40.77},{62.85,40.82},{62.85,40.78},{62.81,40.43},{62.8,40.23},{62.81,40.44},{62.85,40.76},{62.86,40.83},{63.03,40.76},{63.26,40.72},{63.41,40.69},{63.43,40.63},{63.4,40.31},{63.46,39.94},{63.54,39.71},{63.64,39.7},{63.81,39.79},{63.95,39.9},{63.82,39.78},{63.64,39.69},{63.52,39.73},{63.49,39.85},{63.41,40.31},{63.42,40.63},{63.42,40.72}}}},406,nil,nil,47,nil,nil,0},
[4071] = {'Venture Co. Grinder',386,417,17,18,0,nil,nil,0,nil,nil,47,nil,nil,0},
[4072] = {'Prisoner of Jin\'Zil',484,484,20,20,0,{[406]={{74.69,98.11},{74.73,97.77},{74.64,97.72}}},nil,406,nil,nil,80,"A",nil,0},
[4073] = {'XT:4',617,617,23,23,0,{[406]={{64.14,46.38}}},{[406]={{{64.12,46.3},{64.08,45.87},{64.13,45.3},{64.32,45.02},{64.58,44.85},{64.82,44.89},{65.1,45.0},{65.1,45.62},{65.02,46.11},{65.25,46.52},{65.41,47.08},{65.46,47.74},{65.37,48.04},{65.16,48.12},{65.0,47.94},{64.91,47.7},{64.7,47.58},{64.52,47.82},{64.27,48.28},{64.08,48.2},{63.84,47.9},{63.89,47.43},{63.75,46.98},{63.51,46.65},{63.37,46.33},{63.37,45.99},{63.49,45.73},{63.69,45.57},{63.97,45.79},{64.07,46.01}}}},406,nil,nil,16,nil,nil,0},
[4074] = {'XT:9',617,617,23,23,0,{[406]={{64.09,56.62}}},{[406]={{{64.22,56.54},{64.43,56.41},{64.53,56.09},{64.7,55.84},{64.99,55.77},{65.4,56.04},{65.61,56.05},{65.89,56.26},{66.18,56.29},{66.36,56.22},{66.67,56.37},{66.97,56.14},{67.28,56.19},{67.48,56.13},{67.75,56.01},{68.02,55.93},{68.33,56.15},{68.75,56.2},{69.25,56.53},{69.74,56.54},{70.09,56.65},{70.59,56.6},{70.8,56.68},{71.2,56.52},{71.47,55.79},{71.43,55.12},{71.3,54.73},{70.89,54.48},{70.59,54.55},{70.24,54.76},{69.97,54.39},{69.68,54.14},{69.39,54.42},{69.2,55.09},{68.73,55.01},{68.39,55.1},{67.99,54.87},{67.73,54.73},{67.46,54.64},{67.26,54.91},{67.03,55.11},{66.8,55.15},{66.51,54.97},{66.25,55.29},{66.13,55.66},{65.78,55.75},{65.56,55.17},{65.22,54.79},{64.89,54.74},{64.61,54.59},{64.18,54.73},{63.76,55.01},{63.25,54.93},{62.88,55.14},{62.52,55.06},{61.97,54.5},{61.53,54.17},{61.13,54.04},{60.83,54.08},{60.54,54.07},{60.38,54.35},{60.51,54.79},{60.9,54.93},{61.38,55.1},{61.7,55.46},{61.81,56.08},{62.02,56.44},{62.45,56.38},{62.72,56.34},{63.09,56.46},{63.46,56.57},{63.84,56.75},{64.06,56.69}}}},406,nil,nil,16,nil,nil,0},
[4075] = {'Rat',8,8,1,1,0,{[33]={{26.54,73.61},{27.49,76.86}},[45]={{25.4,63.02},{29.14,65.71},{27.04,64.81},{27.39,62.8},{27.58,60.46},{20.91,68.51},{19.66,67.15},{19.04,65.11},{23.61,65.68},{21.31,61.08},{23.26,57.06},{25.99,59.41},{29.43,61.11},{26.06,56.99},{24.52,60.61},{26.23,59.09},{91.19,70.22},{91.19,71.69},{93.47,70.82},{93.37,67.99},{92.61,64.67},{92.32,66.13},{89.27,75.85},{89.34,76.99},{90.34,75.82},{90.01,75.02},{91.36,73.56},{92.55,68.36},{92.75,67.3},{94.06,65.39},{94.8,66.45}},[267]={{60.49,22.86},{61.6,24.84},{62.09,20.89},{75.57,41.24}},[36]={{21.95,60.1},{19.61,55.89},{59.67,43.59},{61.94,44.48},{11.7,78.3},{18.27,75.54},{60.93,47.18}},[130]={{55.34,69.99},{59.43,80.57},{48.35,41.27},{53.46,33.89},{43.1,20.52},{49.93,67.31}},[405]={{49.24,57.61},{39.93,47.69},{56.78,39.18},{60.28,65.72},{57.36,12.55},{74.53,21.73},{47.75,57.64},{59.27,31.27},{30.69,78.99},{65.3,18.11},{48.93,49.14},{50.64,60.1},{63.7,58.58},{52.81,61.46},{44.1,45.83},{51.96,46.91},{53.41,32.89},{61.15,18.32},{41.3,78.75},{67.38,65.36},{62.91,48.05},{54.73,38.08},{53.85,7.43},{57.56,47.54},{69.68,20.31},{46.23,40.52},{41.28,41.55},{75.11,34.23},{73.13,35.7},{61.14,18.35},{51.56,71.6},{38.63,75.97}},[85]={{58.72,48.19},{89.01,44.08},{31.77,71.3},{56.66,49.05},{75.53,59.38},{57.85,47.41},{32.37,70.83},{83.41,65.98},{37.46,38.12},{76.69,58.6},{30.97,71.88},{57.92,32.17},{33.53,60.4},{53.76,57.9},{84.66,33.76},{54.5,41.14},{57.64,38.33},{53.15,53.64},{61.12,49.1},{72.84,39.22},{39.89,53.74},{58.74,34.08},{42.47,66.89},{77.76,59.98},{53.59,55.8},{29.75,69.52},{78.06,61.5},{54.96,56.31},{71.13,33.72},{90.72,48.72},{64.87,50.13},{56.15,43.08},{35.25,68.25},{50.39,56.37},{56.92,48.64},{73.75,60.83},{31.34,67.18},{52.09,70.54},{59.6,46.9},{29.75,70.67},{72.94,30.52},{39.49,48.09},{32.13,69.25},{32.66,55.92},{59.8,49.71},{47.88,67.79},{42.62,59.37},{67.06,58.5},{46.17,52.73},{73.92,60.1},{55.96,41.21},{58.35,52.45},{78.67,67.85},{65.48,33.86},{76.59,61.09},{32.05,62.8},{65.56,35.6},{87.1,38.6},{29.47,61.91},{86.93,44.94},{33.32,64.9},{32.03,61.14},{30.0,71.46},{30.77,69.64},{31.79,68.93},{61.93,40.55},{74.85,65.41},{37.14,56.8},{29.91,65.68},{82.81,51.29},{39.24,44.02},{34.37,63.15},{34.38,62.4},{29.02,60.23},{61.07,54.06},{48.66,49.63},{53.92,61.15},{50.67,60.26},{50.37,64.58},{56.24,63.63},{74.45,45.07},{61.05,54.77},{53.01,53.93},{84.28,40.76},{72.52,52.93},{80.3,47.7},{62.02,46.51},{58.36,52.88},{65.15,58.81}},[406]={{29.38,65.21},{36.7,50.66},{28.1,68.69},{38.0,42.28},{36.18,72.71},{35.27,65.31}},[2557]={{-1,-1}},[1977]={{-1,-1}},[2057]={{-1,-1}},[1519]={{65.91,59.43},{68.32,55.83},{69.11,44.13},{69.75,45.56},{75.65,36.63},{75.37,37.15},{54.24,58.13},{52.47,57.38},{26.04,79.23},{26.6,78.56},{25.73,77.0},{29.59,62.83},{32.74,43.41}},[796]={{-1,-1}},[1497]={{47.48,72.77},{48.65,70.29},{49.14,66.54},{52.4,73.47}},[1581]={{-1,-1}},[3456]={{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1}}},nil,3456,nil,nil,31,"AH",nil,0},
[4076] = {'Roach',8,8,1,1,0,{[405]={{74.01,30.74},{64.05,33.14},{56.5,84.65},{77.07,52.31},{49.56,6.81},{77.8,43.63},{61.53,73.65},{38.03,75.25},{70.57,54.45},{67.95,81.93},{43.48,73.69},{50.6,27.03},{53.33,85.01},{45.09,36.34},{49.77,47.75},{41.45,85.11},{67.08,53.35},{64.06,23.28},{53.61,9.2},{68.35,49.33},{53.97,67.86}},[406]={{34.16,71.52},{30.51,74.54},{31.28,72.32},{31.82,59.91},{34.88,59.85}},[2557]={{-1,-1}},[28]={{49.94,57.65},{45.49,21.05},{36.45,78.43},{50.31,60.09},{43.84,11.46},{54.35,34.13},{51.83,82.05},{48.94,45.56},{54.72,26.32},{51.69,39.66},{50.77,23.47},{49.57,50.1},{53.81,25.12},{42.2,19.96},{40.4,57.36},{48.59,42.98}},[2100]={{-1,-1}},[1583]={{-1,-1}},[722]={{-1,-1}}},nil,405,nil,nil,188,"AH",nil,0},
[4077] = {'Gaxim Rustfizzle',1002,1002,30,30,0,{[406]={{59.52,67.15}}},nil,406,{1071,1072,1075,1079,1080,1091,2931},{1071,1074,1077,1079,1080,1085},64,"A",nil,2},
[4078] = {'Collin Mauren',1162,1162,32,32,0,{[1519]={{43.09,80.39}}},nil,1519,{1076,1077,1078},{1075,1076,1078},12,"A",nil,2},
[4079] = {'Sentinel Thenysil',617,617,23,23,0,{[331]={{34.89,49.79}}},nil,331,{1070,1081},{1082},80,"A",nil,2},
[4080] = {'Kaela Shadowspear',617,617,23,23,0,{[406]={{59.9,66.85}}},nil,406,{1082,1083,1084,1085},{1070,1083,1084,1091},124,"A",nil,2},
[4081] = {'Lomac Gearstrip',950,950,29,29,0,{[1537]={{72.08,51.88}}},nil,1537,{1073,1074},{1072,1073},875,"A",nil,2},
[4082] = {'Grawnal',1162,1162,32,32,0,{[406]={{45.88,58.66}}},nil,406,nil,nil,29,"H","General Goods",6},
[4083] = {'Jeeda',664,664,24,24,0,{[406]={{47.61,61.59}}},nil,406,nil,nil,29,"H","Apprentice Witch Doctor",4},
[4084] = {'Chylina',664,664,24,24,0,{[406]={{35.49,6.17}}},nil,406,nil,nil,80,"A","General Supplies",6},
[4085] = {'Nizzik',664,664,24,24,0,{[406]={{62.7,40.18}}},nil,406,nil,nil,35,"AH","Venture Armor Salesman",16388},
[4086] = {'Veenix',664,664,24,24,0,{[406]={{58.22,51.74}}},nil,406,nil,nil,35,"AH","Venture Co. Merchant",16388},
[4087] = {'Arias\'ta Bladesinger',4120,4120,60,60,0,{[1657]={{58.71,34.9}}},nil,1657,nil,nil,80,"A","Warrior Trainer",19},
[4088] = {'Elanaria',4369,4369,62,62,0,{[1657]={{57.3,34.61}}},nil,1657,{1683,1686,1692},{1683,1684,1686},80,"A",nil,2},
[4089] = {'Sildanair',1752,1752,40,40,0,{[1657]={{61.78,42.22}}},nil,1657,nil,nil,80,"A","Warrior Trainer",19},
[4090] = {'Astarii Starseeker',2883,2883,60,60,0,{[1657]={{38.33,80.95}}},nil,1657,{5674,8254},{3378},80,"A","Priest Trainer",19},
[4091] = {'Jandria',1938,1938,50,50,0,{[1657]={{37.89,82.74}}},nil,1657,{8254},nil,80,"A","Priest Trainer",19},
[4092] = {'Lariia',1238,1238,40,40,0,{[1657]={{40.35,88.68}}},nil,1657,{5634,5647},nil,80,"A","Priest Trainer",19},
[4093] = {'Galak Wrangler',734,788,25,26,0,{[400]={{44.53,39.6},{48.69,41.14},{42.77,40.5},{39.91,37.95},{40.42,37.99},{40.63,37.4},{41.44,38.21},{39.06,32.49},{40.27,36.54},{46.13,41.88},{42.38,37.48},{41.39,37.12},{46.57,40.18},{45.93,41.32},{47.76,40.64},{47.17,40.32},{45.21,39.42},{43.65,39.34},{48.55,43.61},{45.05,40.7},{44.1,40.66},{38.95,38.06},{39.88,37.86}}},nil,400,nil,nil,131,nil,nil,0},
[4094] = {'Galak Scout',664,713,24,25,0,{[400]={{49.55,41.48},{40.63,36.82},{41.14,36.89},{39.31,36.92},{41.18,34.93},{39.82,34.61},{40.44,34.48},{39.72,35.63},{45.53,43.54},{40.61,35.06},{41.14,36.01},{45.42,39.82},{43.15,36.82},{43.29,37.97},{47.68,41.38},{43.57,37.97},{45.93,40.29},{47.24,41.89},{45.58,43.8},{45.92,42.86},{43.57,40.46}}},nil,400,nil,nil,131,nil,nil,0},
[4095] = {'Galak Mauler',840,896,27,28,0,{[400]={{44.35,32.63},{42.56,32.56},{41.66,32.42},{17.02,22.2},{17.83,21.65},{17.18,18.83},{20.75,22.0},{18.68,22.17},{16.6,22.61},{43.63,31.18},{43.93,32.77},{43.12,33.33},{44.44,33.82},{44.28,34.47},{44.93,32.8},{42.55,32.52},{42.95,30.87},{41.94,34.33},{43.27,33.62},{43.23,30.98},{42.74,33.19},{42.99,34.58}}},nil,400,nil,nil,131,nil,nil,0},
[4096] = {'Galak Windchaser',582,622,24,25,0,{[400]={{48.79,41.74},{44.31,35.8},{44.7,36.2},{44.44,38.41},{44.69,36.4},{42.77,35.85},{41.07,41.43},{42.27,40.58},{41.92,38.42},{41.36,40.53},{39.05,37.93},{41.71,39.24},{41.01,38.99},{39.88,33.24},{42.75,38.2},{40.81,35.73},{42.06,37.89},{46.57,41.16},{48.18,40.43},{42.73,37.12},{45.37,40.5},{44.23,36.83},{48.23,42.94},{44.36,40.25},{45.13,42.01},{44.45,41.4},{44.96,40.88},{42.85,39.14}}},nil,400,nil,nil,131,nil,nil,0},
[4097] = {'Galak Stormer',586,621,26,27,0,{[400]={{43.21,30.98},{42.28,31.49},{17.89,20.85},{17.75,22.42},{18.51,21.21},{19.04,21.37},{20.04,22.1},{18.54,24.22},{18.77,23.06},{23.32,25.1},{23.06,24.35},{41.96,34.03},{44.34,32.66},{43.32,31.03},{42.53,33.48},{42.45,31.77},{43.6,34.0},{44.15,35.44}}},nil,400,nil,nil,131,nil,nil,0},
[4098] = {'Galak Pack Runner',488,521,25,26,0,nil,nil,0,nil,nil,131,nil,nil,0},
[4099] = {'Galak Marauder',788,840,26,27,0,{[400]={{42.43,31.73},{42.96,30.94},{43.63,31.18},{43.97,32.72},{41.61,32.27},{17.85,19.8},{19.23,21.53},{19.31,22.98},{18.45,23.6},{19.38,22.5},{22.55,25.46},{22.58,24.41},{41.72,33.04},{41.68,32.43},{43.57,33.02},{44.74,33.07},{44.27,34.49},{43.68,34.43},{42.36,31.52},{43.6,35.38},{42.7,34.94}},[17]={{49.13,96.24}}},nil,400,nil,nil,131,nil,nil,0},
[4100] = {'Screeching Harpy',768,814,28,29,0,{[400]={{26.01,54.97},{26.73,55.61},{26.49,52.26},{28.41,48.69},{28.19,47.63},{27.59,48.92}}},nil,400,nil,nil,514,nil,nil,0},
[4101] = {'Screeching Roguefeather',950,1003,29,30,0,{[400]={{26.58,53.4},{27.17,52.24},{27.06,55.19},{27.84,50.23},{26.72,56.01},{26.27,52.64},{27.35,51.0},{27.4,47.38},{26.67,47.49},{27.86,48.17},{28.46,50.24}}},nil,400,nil,nil,514,nil,nil,0},
[4104] = {'Screeching Windcaller',1003,1003,30,30,0,{[400]={{26.16,56.21},{27.3,54.34},{26.72,52.1},{26.49,55.79},{26.31,53.67},{26.0,52.76}}},nil,400,nil,nil,514,nil,nil,0},
[4107] = {'Highperch Wyvern',896,950,28,29,0,{[400]={{17.88,42.88},{14.13,37.61},{10.89,39.21},{16.95,41.71},{13.28,37.76},{11.15,34.55},{17.91,41.48},{15.43,40.62},{11.93,33.24},{10.56,31.41},{10.22,33.8},{11.8,37.8},{13.71,39.48},{10.38,40.26},{9.29,35.61},{10.34,35.67},{9.21,34.4}}},nil,400,nil,nil,16,nil,nil,0},
[4109] = {'Highperch Consort',896,950,28,29,0,{[400]={{11.87,35.79},{16.21,41.61},{11.8,31.87},{11.04,37.14},{12.28,37.07}}},nil,400,nil,nil,16,nil,nil,0},
[4110] = {'Highperch Patriarch',1146,1207,30,31,0,{[400]={{11.53,33.94},{10.01,33.96}}},{[400]={{{10.04,33.88},{10.04,33.88},{9.74,34.01},{9.28,34.39},{9.13,35.09},{9.32,35.57},{9.6,35.68},{10.16,35.6},{10.46,35.34},{10.53,34.71},{10.43,34.32},{10.37,34.22}}}},400,nil,nil,16,nil,nil,0},
[4111] = {'Gravelsnout Kobold',788,840,26,27,0,{[400]={{31.82,47.73},{37.91,54.66},{34.53,51.28},{23.84,22.34},{25.1,28.29},{38.52,51.87},{27.47,39.66},{22.05,38.01}}},nil,400,nil,nil,26,nil,nil,0},
[4112] = {'Gravelsnout Vermin',734,788,25,26,0,{[400]={{34.4,26.59},{45.95,59.22},{33.6,32.03},{38.25,55.16}}},nil,400,nil,nil,26,nil,nil,0},
[4113] = {'Gravelsnout Digger',896,950,28,29,0,{[400]={{11.85,21.31},{12.41,14.01},{60.27,57.73}}},nil,400,nil,nil,26,nil,nil,0},
[4114] = {'Gravelsnout Forager',840,896,27,28,0,{[400]={{58.87,58.69},{30.86,51.57},{28.96,29.23},{36.28,45.79},{24.8,46.62}}},nil,400,nil,nil,26,nil,nil,0},
[4116] = {'Gravelsnout Surveyor',739,774,29,30,0,{[400]={{64.05,46.9},{66.27,49.56},{11.66,22.79},{12.88,14.74},{67.49,60.12}}},nil,400,nil,nil,26,nil,nil,0},
[4117] = {'Cloud Serpent',640,684,25,26,0,{[400]={{37.35,55.06},{37.08,41.91},{35.19,27.59},{40.86,58.27},{40.5,50.21}}},nil,400,nil,nil,14,nil,nil,0},
[4118] = {'Venomous Cloud Serpent',788,896,26,28,0,{[400]={{28.02,42.24},{36.75,55.35},{37.5,53.79},{26.4,25.6},{29.33,28.07},{34.92,54.44},{37.79,54.01},{33.17,52.91},{21.32,38.12},{22.66,23.73},{51.15,56.32},{52.63,55.08}}},nil,400,nil,nil,14,nil,nil,0},
[4119] = {'Elder Cloud Serpent',724,812,27,29,0,{[400]={{59.62,46.42},{55.37,49.62},{51.62,43.95},{55.52,51.93},{54.94,47.57},{56.05,51.23},{56.3,49.68},{59.11,51.59},{55.97,49.31},{54.22,48.11},{56.22,48.83},{56.27,49.83},{57.24,49.95},{54.58,48.68},{14.99,31.75},{19.41,39.2},{18.74,32.97},{17.54,36.68},{55.62,45.85},{56.25,46.9}}},nil,400,nil,nil,14,nil,nil,0},
[4120] = {'Thundering Boulderkin',896,950,28,29,0,{[400]={{64.37,48.54},{13.3,14.12},{65.78,50.85},{10.31,16.29},{13.24,25.6},{11.0,22.4},{60.52,59.19},{63.42,60.13},{65.23,62.0},{13.45,26.99},{12.38,13.57},{67.61,61.14},{11.93,17.5},{8.83,14.17}}},nil,400,nil,nil,91,nil,nil,0},
[4121] = {'Wandering Boulderkin',787,840,26,27,0,nil,nil,0,nil,nil,91,nil,nil,0},
[4124] = {'Needles Cougar',840,896,27,28,0,{[400]={{59.68,48.47},{12.19,13.34},{64.03,47.33},{61.56,46.57},{60.33,46.33},{63.96,48.48},{57.84,55.36},{10.84,8.74},{64.79,55.61},{36.43,46.87},{36.26,47.75},{14.94,19.55},{15.76,16.64},{64.07,49.5},{67.56,59.85},{34.06,54.12},{27.94,42.85},{11.16,16.36},{25.86,28.41},{25.02,29.77},{38.86,50.47},{14.78,26.6},{31.01,47.34},{48.69,55.8},{59.01,51.91},{14.09,26.7},{61.63,60.11},{50.96,44.18},{58.8,51.0},{66.69,62.28},{59.63,58.78},{64.88,61.4},{15.94,35.15},{22.36,37.99},{63.63,59.83},{20.05,39.21},{15.14,32.58},{21.9,36.73},{54.14,46.95},{24.77,42.8},{21.51,41.87}}},nil,400,nil,nil,14,nil,nil,0},
[4126] = {'Crag Stalker',734,788,25,26,0,{[400]={{36.16,31.98},{51.37,49.89},{45.27,60.12},{46.5,59.64},{47.78,59.24},{40.11,56.15},{34.75,28.13},{50.32,47.06},{49.33,46.79},{51.09,48.5},{33.76,30.21},{33.08,31.36},{33.04,34.15},{35.08,26.45},{40.39,51.67},{36.84,40.97},{45.72,58.68},{44.17,59.23},{41.42,58.73},{41.7,52.38},{33.56,24.93}}},nil,400,nil,nil,14,nil,nil,2},
[4127] = {'Hecklefang Hyena',328,356,15,16,0,{[17]={{42.16,31.04},{44.87,18.68},{62.3,8.69},{43.92,36.48},{53.69,12.27},{58.28,18.26},{46.58,42.04},{54.2,44.95},{63.46,7.62},{42.53,19.74},{43.92,20.73},{59.24,18.11},{54.72,12.24},{43.3,40.47},{61.55,8.42},{62.8,27.1},{56.23,17.54},{54.71,10.16},{62.67,28.08},{42.47,20.71},{41.53,26.38},{52.4,13.87},{55.7,9.76},{56.64,17.42},{54.24,45.39},{59.54,41.8},{42.25,21.55},{52.08,13.12},{53.97,11.1},{57.31,18.3},{48.06,42.4},{60.36,35.46},{62.54,28.89},{64.05,4.62},{54.69,12.74},{56.32,15.5},{54.43,11.77},{45.84,42.74},{61.13,41.89},{61.9,41.71},{40.47,22.65},{40.86,32.02},{44.64,18.25},{43.09,35.75},{55.07,11.92},{57.33,16.21},{45.12,42.57},{49.28,39.83},{41.48,21.11},{44.13,36.17},{42.01,28.28},{41.48,22.26},{57.51,17.19},{57.61,40.91},{48.18,42.33},{41.19,24.69},{43.36,41.72},{44.48,40.97},{43.04,36.36},{41.18,25.16},{53.87,44.86},{41.14,32.42},{40.5,28.56},{42.19,37.82},{50.04,44.93},{55.93,40.58},{40.56,29.23},{43.01,36.96},{47.09,41.36},{57.65,41.46},{55.8,44.66},{44.46,42.21},{43.77,39.7},{54.1,39.77},{55.92,39.21},{54.16,40.23},{53.28,44.01},{45.83,42.83},{46.74,41.86},{53.93,45.06},{42.39,35.6},{60.33,41.75},{59.3,37.81},{56.0,46.88},{46.04,42.05},{42.15,21.17},{60.82,30.1},{59.24,29.07},{44.79,39.98},{60.13,27.19},{54.69,13.31},{52.03,14.22},{51.39,44.18},{58.25,37.51},{49.46,41.82},{49.01,40.5},{49.0,41.57},{55.53,39.74},{56.34,41.47},{51.05,44.21},{56.49,39.95},{55.25,38.71},{51.03,42.82},{53.97,45.99},{55.22,44.95},{59.47,30.52},{57.86,34.7},{57.22,42.0}}},nil,17,nil,nil,38,nil,nil,0},
[4128] = {'Hecklefang Stalker',573,617,22,23,0,{[17]={{48.31,74.49},{44.26,74.49},{47.84,73.66},{44.12,79.43},{49.63,75.95},{47.46,73.55},{49.47,75.6},{43.98,74.92},{44.6,75.0},{50.01,79.01},{47.53,72.98},{49.75,76.98},{45.42,75.98},{47.15,73.94},{44.93,74.93},{45.5,74.67},{43.89,76.55},{47.78,74.72},{45.44,77.23},{44.6,76.73},{45.15,77.98},{45.52,76.68},{45.08,77.44},{45.28,78.97},{48.1,75.53},{47.18,80.88},{46.77,81.31},{46.41,81.8},{46.72,79.93},{47.36,81.51},{46.39,80.95},{47.11,77.38},{48.33,80.95},{48.43,79.58},{48.94,79.25},{50.11,79.17},{49.18,79.02}}},nil,17,nil,nil,38,nil,nil,0},
[4129] = {'Hecklefang Snarler',417,449,18,19,0,{[17]={{46.5,55.24},{47.43,48.34},{43.24,56.84},{44.69,46.23},{44.4,53.1},{49.38,54.67},{44.91,46.18},{43.88,45.88},{43.47,53.54},{46.81,46.75},{43.37,46.78},{43.2,45.12},{50.4,59.13},{47.45,47.79},{46.55,47.24},{43.48,45.81},{49.8,55.17},{45.46,49.28},{47.43,45.79},{45.42,44.7},{42.87,57.57},{45.86,48.45},{46.33,49.33},{44.75,45.38},{50.33,56.15},{44.71,52.82},{45.45,52.46},{46.86,55.6}}},nil,17,nil,nil,38,nil,nil,0},
[4130] = {'Silithid Searcher',1163,1221,32,33,0,{[400]={{71.75,86.01},{67.72,83.51},{67.74,81.38},{69.91,82.48},{71.74,83.32}}},nil,400,nil,nil,310,nil,nil,0},
[4131] = {'Silithid Invader',1279,1342,34,35,0,{[400]={{65.31,86.73},{65.73,86.23},{64.11,85.88},{65.14,85.12},{63.81,86.25},{63.87,85.42},{63.51,85.8},{66.94,86.17}}},nil,400,nil,nil,310,nil,nil,0},
[4132] = {'Silithid Ravager',1536,1536,37,37,4,{[400]={{68.38,82.32}}},nil,400,nil,nil,310,nil,nil,0},
[4133] = {'Silithid Hive Drone',1221,1279,33,34,0,{[400]={{67.86,88.31},{69.36,84.46},{69.52,89.47},{69.12,89.08},{69.37,85.35},{68.88,85.88},{70.03,84.42},{68.9,87.29},{69.93,85.98},{69.41,86.63},{69.03,83.14},{70.02,87.08},{70.21,88.33},{68.64,81.39},{70.87,87.06},{70.98,84.72},{70.64,84.05},{70.03,86.22},{71.0,85.98},{68.69,85.77},{68.07,85.98},{67.06,82.47},{70.79,82.49},{69.49,81.46},{65.31,86.73},{65.49,86.49},{64.48,85.83},{65.73,86.23},{64.11,85.88},{65.14,85.12},{63.81,86.25},{63.87,85.42},{63.51,85.8},{66.94,86.17}}},nil,400,nil,nil,311,nil,nil,0},
[4138] = {'Jeen\'ra Nightrunner',2883,2883,60,60,0,{[1657]={{39.72,5.39}}},nil,1657,nil,nil,80,"A","Hunter Trainer",19},
[4139] = {'Scorpid Terror',1221,1279,33,34,0,{[400]={{86.57,68.57},{81.4,86.83},{82.51,87.8},{87.05,69.91},{73.49,89.77},{88.21,69.02},{85.17,80.2},{70.81,76.75},{82.76,79.73},{70.88,73.34},{70.0,79.13},{71.83,72.95},{71.48,74.67},{83.08,73.27},{83.75,72.21},{73.06,81.13}}},nil,400,nil,nil,413,nil,nil,0},
[4140] = {'Scorpid Reaver',1107,1163,31,32,0,{[400]={{82.68,69.09},{84.5,61.43},{82.86,66.37},{83.66,63.0},{82.89,59.29},{76.07,51.66},{78.44,55.08},{78.34,52.79},{78.05,56.74},{77.59,51.75},{86.57,57.75},{76.14,55.08},{78.29,68.0},{86.4,61.29},{78.39,66.91},{79.91,68.69},{75.47,67.77},{71.3,72.85},{75.17,59.51},{75.42,58.42},{76.96,67.7},{71.57,55.38},{69.31,65.33},{72.32,59.67},{71.25,57.18},{73.89,55.23},{70.13,63.06},{73.69,70.12},{73.92,61.02},{70.35,68.88},{72.08,73.24},{72.36,57.46},{71.84,73.66}}},nil,400,nil,nil,413,nil,nil,0},
[4142] = {'Sparkleshell Tortoise',1050,1107,30,31,0,{[400]={{81.33,52.68},{82.67,54.37},{75.09,53.14},{77.57,53.92},{76.72,54.33},{81.47,54.88},{83.64,53.97},{83.13,54.77},{83.83,56.27},{82.26,55.2},{76.2,58.61},{75.38,63.11},{72.7,58.35},{74.69,56.36},{70.91,64.12},{73.05,55.79},{74.5,63.08},{69.2,65.62},{72.66,68.65},{74.67,60.87},{69.29,67.14},{70.83,55.13}}},nil,400,nil,nil,7,"AH",nil,0},
[4143] = {'Sparkleshell Snapper',1279,1342,34,35,0,{[400]={{78.24,72.13},{83.77,60.74},{84.78,64.37},{88.26,79.14},{78.91,53.82},{82.06,54.8},{82.87,54.07},{82.27,54.17},{84.41,66.59},{79.91,66.26},{85.96,61.01},{81.6,53.48},{81.42,56.51},{87.35,61.07},{83.93,67.41},{82.71,55.06},{82.94,70.0},{83.65,58.51},{79.03,51.65},{86.0,58.17},{76.94,68.41},{77.19,70.87},{70.49,76.8},{87.48,70.97},{87.25,74.37},{70.22,77.98},{72.1,78.8},{87.5,73.32},{83.7,74.56}}},nil,400,nil,nil,7,"AH",nil,0},
[4144] = {'Sparkleshell Borer',1163,1221,32,33,0,{[400]={{79.89,85.72},{82.17,85.06},{81.7,89.22},{84.25,84.48},{84.84,81.82},{72.42,88.83}}},nil,400,nil,nil,7,"AH",nil,0},
[4146] = {'Jocaste',1238,1238,40,40,0,{[1657]={{40.38,8.55}}},nil,1657,{6071},{6103},80,"A","Hunter Trainer",19},
[4147] = {'Saltstone Basilisk',1050,1107,30,31,0,{[400]={{76.92,57.58},{76.25,52.86},{76.4,53.73},{76.89,60.94},{74.32,53.96},{77.37,59.58},{78.49,59.0},{75.35,61.47},{68.71,61.92},{73.64,59.44},{75.49,57.37},{76.06,56.4},{77.6,64.88},{73.79,57.42},{72.52,55.46},{71.25,67.69},{70.74,67.71},{70.61,66.5},{80.59,64.18},{71.72,65.51}}},nil,400,nil,nil,49,nil,nil,0},
[4149] = {'Kesteryth',1342,1342,35,35,0,nil,nil,0,nil,nil,80,"A","Foraging Trainer",0},
[4150] = {'Saltstone Gazer',1279,1342,34,35,0,{[400]={{71.19,90.71},{72.89,87.87},{76.85,88.96},{76.86,89.41},{77.08,90.73},{77.81,87.77},{75.96,90.43},{78.55,90.28},{79.91,89.36},{77.95,89.18},{83.09,85.64},{79.0,88.61},{83.48,78.77},{79.4,87.17},{78.97,88.14},{77.74,83.56},{76.8,86.74},{76.13,85.89}}},nil,400,nil,nil,49,nil,nil,0},
[4151] = {'Saltstone Crystalhide',977,1021,32,33,0,{[400]={{83.53,65.15},{82.92,64.3},{83.67,69.36},{77.46,89.64},{78.3,86.54},{80.04,51.72},{83.23,62.09},{77.53,87.98},{79.87,87.15},{80.01,70.49},{79.73,88.19},{86.69,63.07},{78.52,89.58},{78.52,89.0},{87.01,79.59},{77.87,90.23},{79.42,89.61},{80.57,55.27},{86.38,60.07},{79.49,88.87},{79.35,85.68},{79.35,55.96},{85.93,58.46},{69.0,77.68},{76.92,64.67},{77.84,67.3},{79.06,70.11},{79.26,67.57},{76.06,69.68},{76.94,84.68},{72.46,80.06},{78.85,86.91},{72.38,77.17},{76.45,87.87},{75.4,66.28},{73.81,76.19},{77.67,85.95},{86.68,72.03},{88.3,74.38}}},nil,400,nil,nil,49,nil,nil,0},
[4153] = {'Kysandia',1342,1342,35,35,0,nil,nil,0,nil,nil,80,"A","Cat Trainer",0},
[4154] = {'Salt Flats Scavenger',1050,1163,30,32,0,{[400]={{80.71,59.47},{88.23,66.08},{87.4,64.92},{87.95,65.32},{73.72,58.86},{70.44,69.01}}},nil,400,nil,nil,73,nil,nil,0},
[4155] = {'Idriana',5544,5544,45,45,0,{[1657]={{39.39,42.44}}},nil,1657,nil,{4510},80,"A","Banker",259},
[4156] = {'Astaia',1342,1342,35,35,0,{[1657]={{47.89,56.65}}},nil,1657,nil,nil,80,"A","Fishing Trainer",19},
[4157] = {'Kitari Farseeker',1342,1342,35,35,0,nil,nil,0,nil,nil,80,"A","Cartography Trainer",0},
[4158] = {'Salt Flats Vulture',1163,1279,32,34,0,{[400]={{82.99,70.69},{78.01,89.85},{70.99,75.35},{84.2,70.73},{71.16,79.22},{79.32,89.16}}},nil,400,nil,nil,73,nil,nil,0},
[4159] = {'Me\'lynn',1342,1342,35,35,0,{[1657]={{63.41,22.38}}},nil,1657,nil,nil,80,"A","Expert Tailor",19},
[4160] = {'Ainethil',2398,2398,46,46,0,{[1657]={{54.88,24.02}}},nil,1657,nil,nil,80,"A","Artisan Alchemist",19},
[4161] = {'Lysheana',4120,4120,60,60,0,{[1657]={{69.79,23.01}}},nil,1657,nil,nil,80,"A","Guild Master",1537},
[4163] = {'Syurna',1752,1752,40,40,0,{[1657]={{36.99,21.91}}},nil,1657,{2242},{2241,2242},80,"A","Rogue Trainer",19},
[4164] = {'Cylania',1002,1002,30,30,0,{[1657]={{59.24,46.36}}},nil,1657,nil,nil,80,"A","Night Elf Armorer",16388},
[4165] = {'Elissa Dumas',992,992,35,35,0,{[1657]={{40.6,82.13}}},nil,1657,nil,nil,80,"A","Portal Trainer",19},
[4166] = {'Gazelle',14,14,3,3,0,{[17]={{51.07,32.23},{44.48,46.82},{44.5,47.13},{44.55,47.24},{44.5,47.04},{44.58,47.05},{44.56,47.12},{44.58,47.13},{44.56,47.16},{45.41,14.28},{45.54,14.21},{45.6,14.22},{45.51,14.16},{45.54,14.31},{51.11,32.32},{51.09,32.2},{51.07,32.35},{51.03,32.31},{48.39,57.89},{47.88,57.07},{48.0,57.22},{48.07,57.26},{47.92,57.25},{50.95,32.12},{47.3,43.19},{47.23,42.95},{47.22,43.04},{47.38,43.33},{47.27,43.1},{47.3,43.02},{47.33,43.08},{47.23,43.1},{45.59,31.31},{45.72,31.08},{45.73,31.15},{45.77,31.09},{45.68,31.13},{45.77,30.97},{52.43,37.94},{44.47,62.71},{44.63,62.89},{44.68,62.81},{44.69,62.87},{44.63,62.87},{44.62,62.95}}},nil,17,nil,nil,188,"AH",nil,0},
[4167] = {'Dendrythis',1002,1002,30,30,0,{[1657]={{33.62,15.91}}},{[1657]={{{33.62,15.91},{34.46,14.99},{35.24,14.07},{36.54,13.52},{37.07,15.12},{37.57,16.85},{37.78,19.46},{38.6,21.24},{39.85,20.36},{41.58,19.02},{42.92,18.45},{44.2,18.89},{45.12,19.83},{45.72,21.46},{46.26,23.2},{45.53,20.89},{44.88,19.32},{43.27,18.42},{42.04,18.72},{38.67,21.3},{37.93,19.85},{37.46,16.94},{36.65,13.72},{35.32,14.0}}}},1657,nil,nil,80,"A","Food & Drink Vendor",6},
[4168] = {'Elynna',1002,1002,30,30,0,{[1657]={{64.58,21.58}}},nil,1657,nil,nil,80,"A","Tailoring Supplies",6},
[4169] = {'Jaeana',1002,1002,30,30,0,{[1657]={{64.55,71.66}}},{[1657]={{{64.55,71.66},{65.15,69.08},{65.71,67.0},{66.59,64.89},{67.33,63.24},{67.83,61.59},{68.02,59.82},{67.8,57.5},{66.73,56.29},{65.29,55.51},{63.99,55.09},{62.54,55.13},{62.38,56.78},{62.35,58.23},{62.1,59.87},{61.82,61.54},{61.48,63.4},{60.77,65.5},{60.98,66.79},{61.65,68.1},{62.5,69.32},{63.54,70.57}}}},1657,nil,nil,80,"A","Meat Vendor",6},
[4170] = {'Ellandrieth',1002,1002,30,30,0,{[1657]={{64.73,52.97}}},nil,1657,nil,nil,80,"A","General Goods Vendor",6},
[4171] = {'Merelyssa',1002,1002,30,30,0,{[1657]={{65.36,59.74}}},nil,1657,nil,nil,80,"A","Blade Merchant",4},
[4172] = {'Anadyia',1002,1002,30,30,0,{[1657]={{55.68,89.97}}},nil,1657,nil,nil,80,"A","Robe Vendor",4},
[4173] = {'Landria',1002,1002,30,30,0,{[1657]={{63.26,66.27}}},nil,1657,nil,nil,80,"A","Bow Merchant",16388},
[4174] = {'Siannai',44,44,1,1,0,nil,nil,0,nil,nil,35,"AH","Arrow Merchant",0},
[4175] = {'Vinasia',1002,1002,30,30,0,{[1657]={{60.67,72.48}}},nil,1657,nil,nil,80,"A","Cloth Armor Merchant",4},
[4176] = {'Ki\'rasia',1003,1003,30,30,0,nil,nil,0,nil,nil,80,"A","Cloth Armor Merchant",0},
[4177] = {'Melea',1002,1002,30,30,0,{[1657]={{57.13,76.99}}},nil,1657,nil,nil,80,"A","Mail Armor Merchant",4},
[4178] = {'Shaia',1003,1003,30,30,0,nil,nil,0,nil,nil,80,"A","Mail Armor Merchant",0},
[4179] = {'Freillania',1003,1003,30,30,0,nil,nil,0,nil,nil,80,"A","Shield Merchant",0},
[4180] = {'Ealyshia Dewwhisper',2768,2768,50,50,0,{[1657]={{60.6,72.09}}},nil,1657,nil,nil,80,"A","Two Handed Weapon Merchant",4},
[4181] = {'Fyrenna',1002,1002,30,30,0,{[1657]={{69.35,45.02}}},nil,1657,nil,nil,80,"A","Food & Drink Vendor",6},
[4182] = {'Dalmond',386,386,17,17,0,{[148]={{37.45,40.5}}},nil,148,nil,nil,80,"A","General Goods",6},
[4183] = {'Naram Longclaw',484,484,20,20,0,{[148]={{37.57,40.35}}},nil,148,nil,nil,80,"A","Weaponsmith",16388},
[4184] = {'Geenia Sunshadow',2979,2979,51,51,0,{[493]={{52.0,32.89}}},nil,493,nil,nil,994,"AH","Speciality Dress Maker",16388},
[4185] = {'Shaldyn',417,417,18,18,0,{[148]={{38.2,40.42}}},nil,148,nil,nil,80,"A","Clothier",4},
[4186] = {'Mavralyn',417,417,18,18,0,{[148]={{37.0,41.2}}},nil,148,nil,nil,80,"A","Leather Armor & Leatherworking Supplies",16390},
[4187] = {'Harlon Thornguard',617,617,23,23,0,{[148]={{37.05,41.34}}},nil,148,nil,nil,80,"A","Armorer & Shieldsmith",16388},
[4188] = {'Illyanie',712,712,25,25,0,{[406]={{35.59,7.35}}},nil,406,nil,nil,80,"A","Cloth Armor Merchant",16388},
[4189] = {'Valdaron',300,300,14,14,0,{[148]={{38.15,40.6}}},nil,148,nil,nil,80,"A","Tailoring Supplies",4},
[4190] = {'Kyndri',273,273,13,13,0,{[148]={{36.9,44.6}}},nil,148,nil,nil,80,"A","Baker",6},
[4191] = {'Allyndia',328,328,15,15,0,{[148]={{37.12,43.62}}},nil,148,nil,nil,80,"A","Food & Drink Vendor",6},
[4192] = {'Taldan',356,356,16,16,0,{[148]={{36.83,43.91}}},nil,148,nil,nil,80,"A","Drink Vendor",6},
[4193] = {'Grondal Moonbreeze',950,950,29,29,0,{[148]={{38.24,40.53}}},nil,148,nil,nil,80,"A","Journeyman Tailor",17},
[4194] = {'Ullanna',328,328,15,15,0,{[148]={{43.8,76.36}}},nil,148,nil,nil,80,"A","Trade Supplies",6},
[4195] = {'Tiyani',328,328,15,15,0,{[148]={{43.69,76.63}}},nil,148,nil,nil,80,"A","Food & Drink Vendor",6},
[4196] = {'Silithid Swarm',0,0,1,1,0,nil,nil,0,nil,nil,310,nil,nil,0},
[4197] = {'Ken\'zigla',484,484,20,20,0,{[406]={{73.25,95.13}}},nil,406,{1511},{1510},126,"H",nil,2},
[4198] = {'Braelyn Firehand',773,773,30,30,0,{[406]={{45.94,60.42}}},nil,406,{1087,1088,1089},{1087,1088},83,"H",nil,2},
[4200] = {'Laird',300,300,14,14,0,{[148]={{36.77,44.28}}},nil,148,{6343},{6342},80,"A","Fish Vendor",7},
[4201] = {'Ziz Fizziks',484,484,20,20,0,{[406]={{58.99,62.6}}},nil,406,{1093,1094,1096},{1092,1093,1095,1096,1483},35,"AH",nil,2},
[4202] = {'Gerenzo Wrenchwhistle',840,840,27,27,0,{[406]={{64.49,40.25}}},nil,406,nil,nil,47,nil,nil,0},
[4203] = {'Ariyell Skyshadow',1002,1002,30,30,0,{[1657]={{58.76,44.5}}},nil,1657,nil,nil,80,"A","Weapon Merchant",16388},
[4204] = {'Firodren Mooncaller',1342,1342,35,35,0,{[1657]={{47.95,68.03}}},nil,1657,nil,nil,80,"A","Herbalism Trainer",19},
[4205] = {'Dorion',1938,1938,50,50,0,{[1657]={{42.21,7.27}}},nil,1657,{6073,8151},nil,80,"A","Hunter Trainer",19},
[4206] = {'Talar',1342,1342,35,35,0,nil,nil,0,nil,nil,80,"A","Bear Trainer",0},
[4207] = {'Valyen Wolfsong',1342,1342,35,35,0,nil,nil,0,nil,nil,80,"A","Wolf Trainer",0},
[4208] = {'Lairn',5544,5544,45,45,0,{[1657]={{39.68,41.54}}},nil,1657,nil,nil,80,"A","Banker",256},
[4209] = {'Garryeth',5544,5544,45,45,0,{[1657]={{39.6,41.98}}},nil,1657,nil,nil,80,"A","Banker",256},
[4210] = {'Alegorn',1342,1342,35,35,0,{[1657]={{49.03,21.24}}},nil,1657,nil,nil,80,"A","Cooking Trainer",19},
[4211] = {'Dannelor',1342,1342,35,35,0,{[1657]={{51.71,12.22}}},nil,1657,nil,nil,80,"A","First Aid Trainer",19},
[4212] = {'Telonis',2398,2398,46,46,0,{[1657]={{64.43,21.54}}},nil,1657,nil,{2853},80,"A","Artisan Leatherworker",19},
[4213] = {'Taladan',1342,1342,35,35,0,{[1657]={{58.4,13.12}}},nil,1657,nil,nil,80,"A","Expert Enchanter",17},
[4214] = {'Erion Shadewhisper',4120,4120,60,60,0,{[1657]={{34.52,25.93}}},nil,1657,{2260},{2259},80,"A","Rogue Trainer",19},
[4215] = {'Anishar',2768,2768,50,50,0,{[1657]={{37.92,20.92}}},nil,1657,{8233},nil,80,"A","Rogue Trainer",19},
[4216] = {'Chardryn',1002,1002,30,30,0,{[1657]={{48.52,68.99}}},nil,1657,nil,nil,80,"A","Herbalism Supplier",6},
[4217] = {'Mathrengyl Bearwalker',2883,2883,60,60,0,{[1657]={{35.37,8.4}}},nil,1657,{27,3785,3803,5921,6001,6121,6762,9063},{3370,3781,3785,3803,4986,5061,5923,5924,5925,5931,6001,6125,6761},80,"A","Druid Trainer",23},
[4218] = {'Denatharion',1938,1938,50,50,0,{[1657]={{34.77,7.37}}},nil,1657,{5925,9063},nil,80,"A","Druid Trainer",19},
[4219] = {'Fylerian Nightwing',1238,1238,40,40,0,{[1657]={{33.51,8.35}}},nil,1657,{5924},nil,80,"A","Druid Trainer",19},
[4220] = {'Cyroen',1002,1002,30,30,0,{[1657]={{33.85,9.51}}},nil,1657,nil,nil,80,"A","Reagent Vendor",4},
[4221] = {'Talaelar',1002,1002,30,30,0,{[1657]={{47.47,57.45}}},nil,1657,nil,nil,80,"A","Fish Vendor",6},
[4222] = {'Voloren',1002,1002,30,30,0,{[1657]={{46.94,57.0}}},nil,1657,nil,nil,80,"A","Fishing Supplier",6},
[4223] = {'Fyldan',1002,1002,30,30,0,{[1657]={{48.53,21.6}}},nil,1657,nil,nil,80,"A","Cooking Supplier",6},
[4224] = {'Talegon',44,44,1,1,0,nil,nil,0,nil,nil,35,"AH","Cartography Supplier",0},
[4225] = {'Saenorion',1002,1002,30,30,0,{[1657]={{63.69,22.28}}},nil,1657,nil,nil,80,"A","Leatherworking Supplies",6},
[4226] = {'Ulthir',1002,1002,30,30,0,{[1657]={{55.84,24.47}}},nil,1657,nil,nil,80,"A","Alchemy Supplies",6},
[4228] = {'Vaean',1002,1002,30,30,0,{[1657]={{58.57,14.72}}},nil,1657,nil,nil,80,"A","Enchanting Supplies",6},
[4229] = {'Mythrin\'dir',1002,1002,30,30,0,{[1657]={{60.96,17.67}}},nil,1657,nil,nil,80,"A","General Trade Supplier",6},
[4230] = {'Yldan',1002,1002,30,30,0,{[1657]={{65.27,53.03}}},nil,1657,nil,nil,80,"A","Bag Merchant",6},
[4231] = {'Kieran',1002,1002,30,30,0,{[1657]={{64.99,60.22}}},nil,1657,nil,nil,80,"A","Weapon Merchant",16388},
[4232] = {'Glorandiir',1002,1002,30,30,0,{[1657]={{64.2,59.08}}},nil,1657,nil,nil,80,"A","Axe Merchant",4},
[4233] = {'Mythidan',1002,1002,30,30,0,{[1657]={{65.19,60.72}}},nil,1657,nil,nil,80,"A","Mace & Staff Merchant",4},
[4234] = {'Andrus',1002,1002,30,30,0,{[1657]={{56.13,88.91}}},nil,1657,nil,nil,80,"A","Staff Merchant",4},
[4235] = {'Turian',1002,1002,30,30,0,{[1657]={{62.67,65.59}}},nil,1657,nil,nil,80,"A","Thrown Weapons Merchant",4},
[4236] = {'Cyridan',1002,1002,30,30,0,{[1657]={{52.9,80.5}}},nil,1657,nil,nil,80,"A","Leather Armor Merchant",4},
[4237] = {'Urthoniir',1003,1003,30,30,0,nil,nil,0,nil,nil,80,"A","Leather Armor Merchant",0},
[4239] = {'Lewin Starfeather',1003,1003,30,30,0,nil,nil,0,nil,nil,80,"A","Leather Armor Merchant",0},
[4240] = {'Caynrus',1002,1002,30,30,0,{[1657]={{56.93,76.33}}},nil,1657,nil,nil,80,"A","Shield Merchant",16388},
[4241] = {'Mydrannul',1002,1002,30,30,0,{[1657]={{70.68,45.38}}},nil,1657,{6344},nil,80,"A","General Goods Vendor",7},
[4242] = {'Frostsaber Companion',2768,2768,50,50,0,{[1657]={{27.07,0.95}}},nil,1657,nil,nil,80,"A",nil,0},
[4243] = {'Nightshade',2769,2769,50,50,0,{[1657]={{39.9,5.36}}},nil,1657,nil,nil,80,"A","Jeen'ra's Pet",0},
[4244] = {'Shadow',1002,1002,30,30,0,{[1657]={{42.49,7.31}}},nil,1657,nil,nil,80,"A","Dorion's Pet",0},
[4245] = {'Mistrunner',699,699,25,25,0,nil,nil,0,nil,nil,80,"A","Valyen's Pet",0},
[4246] = {'Moonprowler',699,699,25,25,0,nil,nil,0,nil,nil,80,"A","Kysandia's Pet",0},
[4247] = {'Stonepaw',699,699,25,25,0,nil,nil,0,nil,nil,80,"A","Talar's Pet",0},
[4248] = {'Pesterhide Hyena',787,840,26,27,0,{[400]={{31.61,47.08},{24.11,26.05},{25.27,32.45},{27.82,44.72},{38.26,33.74},{36.37,29.99},{35.75,54.93},{37.97,52.73},{28.16,41.77},{34.96,29.57},{36.98,46.88},{28.1,30.29},{33.84,52.76},{31.84,52.23},{34.85,51.71},{31.94,49.39},{32.86,51.61},{29.76,51.39},{32.17,50.7},{27.58,27.27},{24.33,27.33},{26.6,27.7},{36.45,29.12},{27.79,28.59},{41.11,57.69},{40.0,55.78},{25.34,29.05},{26.41,27.02},{36.08,49.53},{47.51,54.58},{35.47,50.67},{25.21,46.86},{35.3,46.17},{37.19,51.01},{24.52,44.92},{22.94,37.83},{22.25,38.19},{27.17,39.96},{37.23,50.13},{21.43,40.65},{25.22,37.37},{28.75,40.04},{22.77,42.55},{24.43,43.73},{49.15,57.57},{48.69,53.99}}},nil,400,nil,nil,38,nil,nil,0},
[4249] = {'Pesterhide Snarler',896,950,28,29,0,{[400]={{12.16,16.0},{9.62,9.29},{58.71,49.17},{64.92,48.71},{62.98,45.85},{65.8,49.93},{12.25,15.3},{63.82,56.47},{13.3,13.15},{14.04,14.43},{12.94,11.04},{53.16,46.69},{10.1,15.67},{66.61,50.78},{67.52,51.08},{65.26,51.3},{63.98,50.54},{53.88,54.6},{64.82,52.82},{17.92,20.02},{17.7,19.88},{67.85,57.5},{21.72,34.21},{64.24,60.58},{60.22,57.39},{66.31,62.09},{62.19,60.31},{59.65,53.73},{60.41,55.49},{15.66,30.84},{20.15,33.29},{18.78,33.94},{68.32,61.86},{58.78,57.76},{12.18,25.81}}},nil,400,nil,nil,38,nil,nil,0},
[4250] = {'Galak Packhound',664,664,24,24,0,{[400]={{22.78,37.39},{22.79,37.51},{22.7,37.37}}},nil,400,nil,nil,131,nil,nil,0},
[4251] = {'Goblin Racer',1162,1162,32,32,0,{[400]={{79.72,77.01}}},nil,400,nil,nil,35,"AH",nil,0},
[4252] = {'Gnome Racer',1162,1162,32,32,0,{[400]={{77.65,76.58}}},nil,400,nil,nil,35,"AH",nil,0},
[4253] = {'Bear Form (Night Elf Druid)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4254] = {'Geofram Bouldertoe',1342,1342,35,35,0,{[1537]={{50.0,26.29}}},nil,1537,nil,nil,55,"A","Mining Trainer",19},
[4255] = {'Brogus Thunderbrew',13070,13070,55,55,0,{[2597]={{43.05,17.63}}},nil,2597,nil,nil,1217,"A","Food and Drink",6},
[4256] = {'Golnir Bouldertoe',1002,1002,30,30,0,{[1537]={{51.52,26.31}}},nil,1537,{6388},{6391},55,"A","Mining Supplier",6},
[4257] = {'Lana Thunderbrew',26140,26140,55,55,0,{[2597]={{43.41,15.64}}},nil,2597,nil,nil,1217,"A","Blacksmithing Supplies",16390},
[4258] = {'Bengus Deepforge',2217,2217,45,45,0,{[1537]={{52.55,41.46}}},nil,1537,nil,nil,55,"A","Artisan Blacksmith",17},
[4259] = {'Thurgrum Deepforge',1002,1002,30,30,0,{[1537]={{51.74,42.78}}},nil,1537,nil,nil,55,"A","Blacksmithing Supplies",16390},
[4260] = {'Venture Co. Shredder',1536,1536,37,37,0,{[33]={{46.43,19.87},{43.9,23.17}}},{[33]={{{46.42,20.1},{46.43,20.32},{46.44,20.54},{46.45,20.79},{46.41,21.02},{46.37,21.19},{46.24,21.39},{46.14,21.55},{45.96,21.69},{45.74,21.81},{45.43,21.92},{45.32,22.15},{45.16,22.42},{45.04,22.57},{44.94,22.7},{44.84,22.6},{44.74,22.36},{44.54,22.21},{44.47,22.06},{44.34,21.84},{44.31,21.45},{44.17,21.2},{44.08,21.05},{44.01,20.86},{43.95,20.6},{43.91,20.39},{43.98,20.23},{44.18,19.95},{44.22,19.71},{44.28,19.41},{44.13,19.04},{44.08,18.69},{44.16,18.47},{44.27,18.2},{44.36,18.02},{44.52,18.03},{44.66,18.06},{44.86,17.79},{45.01,17.62},{45.15,17.68},{45.28,17.86},{45.44,18.05},{45.54,18.08},{45.71,18.13},{45.9,17.96},{46.01,17.95},{46.16,18.0},{46.38,18.18},{46.47,18.39},{46.51,18.65},{46.52,18.85},{46.48,19.21},{46.44,19.57},{46.43,19.87}},{{44.13,23.39},{44.39,23.37},{44.62,23.46},{44.72,23.24},{44.84,23.04},{44.99,22.72},{45.1,22.61},{45.24,22.57},{45.38,22.71},{45.64,22.89},{45.72,23.06},{45.86,23.16},{46.02,23.17},{46.18,23.17},{46.34,22.91},{46.44,22.67},{46.54,22.39},{46.6,22.13},{46.6,21.99},{46.53,21.62},{46.35,21.52},{46.13,21.49},{46.01,21.48},{45.8,21.35},{45.73,21.13},{45.67,20.89},{45.5,20.82},{45.4,20.79},{45.29,20.75},{44.97,20.65},{44.91,20.85},{44.85,21.02},{44.78,21.23},{44.79,21.41},{44.82,21.67},{44.79,21.9},{44.76,22.08},{44.58,22.42},{44.39,22.53},{44.23,22.64},{44.02,22.76},{43.91,22.98},{43.89,23.18}}}},33,nil,nil,47,nil,nil,0},
[4261] = {'Bear Form (Tauren Druid)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4262] = {'Darnassus Sentinel',5228,5228,55,55,0,{[141]={{56.03,89.66},{58.23,93.75},{55.65,89.1},{55.34,92.6},{56.19,92.18},{58.16,93.91},{55.76,89.77},{36.07,54.55},{56.18,89.28},{55.96,89.86},{36.07,54.2},{58.23,94.06}},[1657]={{61.32,33.61},{39.88,91.84},{30.51,42.04},{62.48,47.58},{43.15,83.78},{30.5,40.74},{39.97,81.24},{32.68,83.02},{40.74,91.86},{35.32,87.87},{41.08,43.53},{45.7,82.47},{35.2,84.15},{40.2,80.0},{43.2,87.43},{38.37,76.19},{40.34,91.21},{62.87,39.89},{62.9,41.23},{61.59,47.55},{38.24,81.31},{39.66,76.09},{62.26,33.64},{40.53,91.59},{41.24,42.55},{37.87,80.06}}},nil,1657,nil,nil,79,"A",nil,1},
[4263] = {'Deepmoss Hatchling',300,300,14,14,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4264] = {'Deepmoss Matriarch',573,573,22,22,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4265] = {'Nyoma',484,484,20,20,0,{[141]={{57.19,61.26}}},nil,141,nil,nil,80,"A","Cooking Supplies",7},
[4266] = {'Danlyia',386,386,17,17,0,{[141]={{55.38,57.2}}},nil,141,nil,nil,80,"A","Food & Drink Vendor",6},
[4267] = {'Daelyshia',7842,7842,55,55,1,{[331]={{34.41,47.99}}},nil,331,nil,nil,80,"A","Hippogryph Master",11},
[4268] = {'Riding Wolf (Gray)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4269] = {'Riding Horse (Chestnut)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4270] = {'Riding Wolf (Red)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4271] = {'Riding Wolf (DarkGray)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4272] = {'Riding Wolf (DarkBrown)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4273] = {'Keeper Ordanus',811,811,29,29,0,{[331]={{62.05,51.37}}},nil,331,nil,nil,79,"A",nil,0},
[4274] = {'Fenrus the Devourer',3495,3495,25,25,1,{[209]={{-1,-1}}},nil,209,nil,nil,16,nil,nil,0},
[4275] = {'Archmage Arugal',6510,6510,26,26,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[4276] = {'Piznik',484,484,20,20,0,{[406]={{71.87,60.0}}},nil,406,{1090,1092},{1090},35,"AH","Venture Co.",2},
[4277] = {'Eye of Kilrogg',56,56,22,22,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4278] = {'Commander Springvale',2855,2855,24,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[4279] = {'Odo the Blindwatcher',3255,3255,24,24,1,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[4280] = {'Scarlet Preserver',2319,2433,29,30,1,{[85]={{82.89,30.86},{83.73,29.43},{81.54,30.34},{83.07,29.34},{83.97,30.22},{83.89,30.54},{81.6,32.4},{81.36,33.72},{82.24,33.91},{82.91,33.5},{82.27,35.11}}},nil,85,nil,nil,67,nil,nil,0},
[4281] = {'Scarlet Scout',2715,2865,29,30,1,{[85]={{82.89,30.86},{83.73,29.43},{82.18,29.53},{81.54,30.34},{83.07,29.34},{83.94,30.71},{85.66,34.81},{86.85,35.61},{83.68,28.69},{83.77,35.71},{81.6,32.4},{81.36,33.72},{81.06,29.53},{83.59,34.94},{84.51,34.05},{84.78,35.98},{83.68,33.82},{82.24,33.91},{82.91,33.5},{84.48,36.88},{84.36,34.61},{83.36,37.82},{84.33,35.09},{82.27,35.11},{83.02,37.28},{82.33,37.13}}},nil,85,nil,nil,67,nil,nil,0},
[4282] = {'Scarlet Magician',2112,2211,29,30,1,{[85]={{82.89,30.86},{83.73,29.43},{82.18,29.53},{81.54,30.34},{83.07,29.34},{83.94,30.71},{83.68,28.69},{81.5,29.53},{82.88,28.53},{83.77,35.71},{81.6,32.4},{81.06,29.53},{83.59,34.94},{84.51,34.05},{84.78,35.98},{83.68,33.82},{80.89,29.4},{82.24,33.91},{82.91,33.5},{84.36,34.61},{84.33,35.09},{82.27,35.11},{82.21,36.07}}},nil,85,nil,nil,67,nil,nil,0},
[4283] = {'Scarlet Sentry',2865,3018,30,31,1,{[85]={{83.88,31.28},{84.28,32.69},{84.04,32.49},{84.83,32.36},{83.77,31.76},{84.47,30.93}},[796]={{-1,-1}}},nil,85,nil,nil,67,nil,nil,0},
[4284] = {'Scarlet Augur',2433,2550,30,31,1,{[85]={{83.59,31.8},{83.63,31.93},{83.81,32.53},{83.85,32.67},{85.04,31.31},{85.07,31.43},{84.61,31.74},{84.58,31.63}}},nil,85,nil,nil,67,nil,nil,0},
[4285] = {'Scarlet Disciple',2433,2550,30,31,1,{[85]={{83.59,31.8},{83.63,31.93},{83.81,32.53},{83.85,32.67},{85.04,31.31},{85.07,31.43},{84.61,31.74},{84.58,31.63}}},nil,85,nil,nil,67,nil,nil,0},
[4286] = {'Scarlet Soldier',3660,3831,35,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4287] = {'Scarlet Gallant',2784,2901,33,34,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4288] = {'Scarlet Beastmaster',3489,3660,34,35,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4289] = {'Scarlet Evoker',2805,2910,36,37,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4290] = {'Scarlet Guardsman',3831,4008,36,37,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4291] = {'Scarlet Diviner',2901,3027,34,35,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4292] = {'Scarlet Protector',3150,3279,36,37,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4293] = {'Scarlet Scryer',2433,2550,30,31,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4294] = {'Scarlet Sorcerer',2910,3012,37,38,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4295] = {'Scarlet Myrmidon',4008,4185,37,38,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4296] = {'Scarlet Adept',2784,2901,33,34,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4297] = {'Scarlet Conjuror',2706,2805,35,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4298] = {'Scarlet Defender',4008,4185,37,38,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4299] = {'Scarlet Chaplain',2901,3027,34,35,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4300] = {'Scarlet Wizard',3514,3640,38,39,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4301] = {'Scarlet Centurion',4185,4377,38,39,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4302] = {'Scarlet Champion',3540,3678,39,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4303] = {'Scarlet Abbot',3540,3678,39,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4304] = {'Scarlet Tracking Hound',3330,3330,33,33,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4305] = {'Kriggon Talsone',712,712,25,25,0,{[40]={{36.23,90.18}}},nil,40,nil,nil,12,"A","Fisherman",4},
[4306] = {'Scarlet Torturer',2865,3018,30,31,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4307] = {'Heldan Galesong',712,712,25,25,0,{[148]={{36.97,56.35}}},nil,148,nil,nil,80,"A","Fisherman",4},
[4308] = {'Unfettered Spirit',1006,1057,31,32,0,{[796]={{-1,-1}}},nil,796,nil,nil,21,nil,nil,0},
[4309] = {'Gorm Grimtotem',6474,6474,62,62,0,{[1638]={{70.51,30.28}}},nil,1638,nil,nil,105,"H",nil,2},
[4310] = {'Cor Grimtotem',6474,6474,62,62,0,{[1638]={{70.62,30.97}}},nil,1638,nil,nil,105,"H",nil,2},
[4311] = {'Holgar Stormaxe',1002,1002,30,30,0,{[14]={{46.02,12.93}}},nil,14,nil,nil,29,"H",nil,0},
[4312] = {'Tharm',7842,7842,55,55,1,{[406]={{45.12,59.84}}},nil,406,nil,nil,104,"H","Wind Rider Master",11},
[4314] = {'Gorkas',7842,7842,55,55,1,{[47]={{81.7,81.76}}},nil,47,nil,nil,29,"H","Wind Rider Master",11},
[4316] = {'Kolkar Packhound',273,273,13,13,0,{[17]={{52.66,44.84},{53.63,42.02},{56.97,42.86},{48.51,42.49},{47.73,37.41},{46.46,42.19},{55.65,45.78},{54.07,42.75},{52.35,44.71},{56.77,40.61},{55.33,46.45},{53.34,40.92},{52.8,38.88}}},nil,17,nil,nil,130,nil,nil,0},
[4317] = {'Nyse',7842,7842,55,55,1,{[400]={{45.14,49.11}}},nil,400,nil,nil,104,"H","Wind Rider Master",11},
[4319] = {'Thyssiana',7842,7842,55,55,1,{[357]={{89.5,45.85}}},nil,357,nil,nil,80,"A","Hippogryph Master",11},
[4320] = {'Caelyb',1752,1752,40,40,0,{[331]={{49.72,66.97}}},nil,331,nil,nil,80,"A","Pet Trainer",19},
[4321] = {'Baldruc',7842,7842,55,55,1,{[15]={{67.48,51.3}}},nil,15,nil,nil,894,"A","Gryphon Master",11},
[4322] = {'Corthryn',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4323] = {'Searing Hatchling',1902,1981,41,42,0,{[15]={{54.38,70.54},{45.06,78.74},{44.76,73.97},{47.74,70.1},{51.74,67.65},{51.06,74.15},{55.1,73.11},{45.68,84.1},{44.81,76.61},{42.14,76.6},{43.25,81.46},{42.77,81.06},{41.38,77.81},{41.87,80.76},{46.67,82.35},{47.27,82.46},{46.55,84.9},{44.6,81.58},{43.57,70.0},{45.76,72.13},{45.51,73.14},{46.82,71.51},{50.51,71.97},{48.94,70.24},{50.01,69.05},{46.2,65.05},{48.18,80.52},{44.11,66.44},{44.93,64.48},{46.71,65.42},{47.21,67.19},{43.08,69.23},{43.71,64.4},{45.79,65.18},{45.95,67.21}}},nil,15,nil,nil,103,nil,nil,0},
[4324] = {'Searing Whelp',1585,1647,42,43,0,{[15]={{43.03,82.1},{56.37,70.08},{48.46,78.55},{52.72,70.07},{47.18,77.95},{45.07,69.71},{45.56,68.91},{44.83,75.86},{49.11,68.06},{51.41,71.02},{55.02,84.13},{55.46,83.41},{45.77,84.33},{42.19,78.86},{42.8,79.17},{41.5,79.51},{45.78,82.35},{46.45,83.4},{45.21,67.98},{46.48,67.42},{42.48,65.63},{47.74,66.3},{48.45,67.02}}},nil,15,nil,nil,103,nil,nil,0},
[4328] = {'Firemane Scalebane',1647,1711,43,44,0,{[15]={{57.79,79.4},{56.71,77.71},{56.02,81.37},{52.49,84.21},{48.65,76.4},{53.35,72.1},{53.32,72.97},{53.87,72.05},{54.75,83.44},{53.97,72.74},{56.48,75.07},{51.66,74.73},{48.69,73.93},{37.21,67.26},{37.83,67.3},{37.86,69.51},{37.81,68.23},{36.6,69.61}}},nil,15,nil,nil,103,nil,nil,0},
[4329] = {'Firemane Scout',1902,1981,41,42,0,{[15]={{44.96,82.09},{44.61,67.28},{42.44,67.78},{50.41,71.46},{45.27,65.3},{46.84,77.65},{45.8,65.8},{45.16,66.21},{42.25,65.5},{49.68,67.8},{39.46,65.27},{39.47,64.18},{40.05,65.21},{39.49,66.1},{36.95,69.0},{38.74,65.73},{38.13,69.11},{38.86,65.47},{43.27,65.85},{42.75,66.33},{43.9,66.05},{44.66,65.48}}},nil,15,nil,nil,103,nil,nil,0},
[4331] = {'Firemane Ash Tail',1585,1647,42,43,0,{[15]={{45.12,82.2},{42.52,67.65},{50.43,71.59},{45.58,66.97},{46.92,77.76},{44.7,66.31},{42.27,65.65},{49.78,67.87},{38.85,64.59},{44.09,65.33},{38.92,67.09},{38.58,68.07},{37.43,68.51},{37.48,67.99},{36.75,69.19},{38.29,67.14},{39.0,66.05},{42.25,68.04},{44.56,64.7},{42.22,67.18},{43.29,65.19},{45.68,65.86},{45.34,67.18},{45.17,66.17},{43.21,65.86}}},nil,15,nil,nil,103,nil,nil,0},
[4333] = {'Firemane Devourer',1674,1751,38,39,0,nil,nil,0,nil,nil,103,nil,nil,0},
[4334] = {'Firemane Flamecaller',1647,1711,43,44,0,{[15]={{54.12,84.2},{56.67,73.46},{53.46,83.43},{57.85,77.54},{56.97,75.15},{57.29,78.69},{56.6,79.6},{50.85,82.33},{50.35,81.37},{54.71,74.77},{55.71,81.71},{55.99,82.44},{56.27,82.18},{52.49,83.4},{51.98,83.4},{54.18,82.27},{52.16,84.58},{51.53,81.56},{50.24,83.34},{50.4,79.59},{48.86,75.56},{50.36,77.65},{48.16,75.54},{48.16,76.29},{56.92,75.74},{56.5,75.7},{57.41,76.84},{52.84,75.46},{52.25,74.87},{50.89,76.6},{48.14,73.68},{48.59,74.62},{48.54,73.17},{51.0,78.53},{51.59,75.7},{50.84,75.65}}},nil,15,nil,nil,103,nil,nil,0},
[4339] = {'Brimgore',5544,5544,45,45,2,{[15]={{42.12,75.94}}},{[15]={{{42.15,76.44},{42.19,77.01},{42.11,77.42},{42.03,78.14},{42.18,78.59},{42.12,79.09},{42.17,79.68},{42.2,80.4},{42.52,80.56},{42.88,80.65},{43.23,80.63},{43.8,80.3},{44.23,80.74},{44.59,81.17},{45.11,81.42},{45.61,81.52},{46.18,81.08},{46.63,81.25},{47.24,81.37},{47.94,81.89},{47.34,82.18},{47.16,82.19},{46.88,82.05},{46.63,81.94},{46.21,80.92},{45.66,81.38},{45.19,81.53},{44.72,81.16},{44.25,80.77},{43.81,80.33},{43.6,80.08},{43.09,79.66},{42.54,79.46},{42.11,79.4},{42.12,78.57},{42.18,77.87},{42.13,77.28},{42.21,76.52}}}},15,nil,nil,103,nil,nil,0},
[4340] = {'Mirallia',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Spirit Healer",0},
[4341] = {'Drywallow Crocolisk',1403,1469,35,36,0,{[15]={{50.36,20.44},{44.59,18.3},{36.98,26.35},{59.41,34.59},{45.99,20.55},{44.87,20.46},{59.53,35.12},{51.67,19.86},{52.05,20.29},{45.02,19.12},{46.25,21.74},{41.22,26.86},{48.44,22.17},{38.09,28.35},{49.44,21.99},{38.02,29.48},{40.58,26.42},{40.04,27.18},{36.41,27.24},{37.41,25.22},{36.96,28.18},{35.93,25.9},{40.61,26.34},{40.16,26.96}}},nil,15,nil,nil,16,nil,nil,0},
[4342] = {'Drywallow Vicejaw',1469,1536,36,37,0,nil,nil,0,nil,nil,16,nil,nil,0},
[4343] = {'Drywallow Snapper',1536,1604,37,38,0,{[15]={{41.93,45.29},{44.47,39.32},{34.76,45.05},{34.11,42.3},{43.16,39.82},{33.37,42.64},{41.84,41.48},{37.05,41.6},{40.32,42.13},{40.46,41.44},{39.29,41.22},{38.94,42.05},{38.02,42.02},{40.45,44.21},{39.26,44.94},{44.51,43.45},{34.1,40.74},{43.72,44.17},{41.02,44.79},{38.79,34.43},{43.27,45.51},{44.5,45.19},{44.84,42.03},{34.51,33.82},{35.15,34.64},{35.6,35.77},{35.98,34.84},{37.54,34.99},{41.13,30.86},{43.07,36.69},{40.27,33.02},{40.97,33.85},{41.07,33.04},{40.07,38.34},{36.6,42.73},{41.34,28.97},{38.0,45.09},{40.22,34.62},{41.04,38.01},{41.17,38.62},{42.4,39.2},{41.83,37.2},{34.74,41.12},{35.77,43.42},{36.1,44.2},{42.33,28.24},{40.66,31.96},{35.2,44.11}}},nil,15,nil,nil,16,nil,nil,0},
[4344] = {'Mottled Drywallow Crocolisk',1604,1678,38,39,0,{[15]={{35.69,60.96},{36.43,58.8},{34.8,58.35},{35.27,57.45},{34.86,60.96},{35.96,58.07},{34.36,47.17},{35.0,55.36},{42.72,48.93},{43.28,50.81},{37.98,47.19},{36.43,48.21},{37.63,50.09},{37.64,46.31},{38.52,49.11},{39.53,48.85},{45.8,49.45},{39.97,52.06},{44.61,49.55},{43.44,47.46},{42.58,48.03},{36.2,59.46},{36.84,60.75},{38.4,54.6},{39.57,53.1},{37.72,53.84},{38.99,53.54},{40.81,54.82},{43.68,49.6},{42.42,49.82},{39.55,58.7},{38.75,59.96},{41.4,57.76},{40.53,58.45},{41.99,54.87},{41.71,56.03},{42.64,53.76},{44.65,51.24},{45.12,51.71},{38.84,47.82},{45.2,47.89},{44.54,46.95},{38.61,57.52},{37.57,57.78},{37.93,59.61},{43.01,56.32},{41.12,60.63},{35.47,47.36},{36.93,47.13},{35.95,48.56},{34.43,49.51},{35.22,49.25},{40.24,50.34},{37.25,51.51},{39.28,50.19},{39.67,51.18},{43.92,58.14},{43.37,56.63},{43.34,58.49},{45.99,52.95}}},nil,15,nil,nil,16,nil,nil,0},
[4345] = {'Drywallow Daggermaw',1828,1902,40,41,0,{[15]={{49.85,79.94},{50.55,80.92},{54.24,69.13},{55.51,71.87},{56.11,68.83},{50.76,76.53},{48.31,63.91},{55.21,69.78},{51.05,74.84},{56.83,70.16},{56.47,71.59},{56.31,72.97},{50.65,62.18},{50.98,70.58},{41.94,63.91},{51.22,72.75},{50.88,60.85},{53.59,70.74},{41.31,66.28},{48.45,49.14},{52.14,72.88},{54.94,71.01},{46.55,50.66},{47.69,75.83},{55.29,73.77},{43.23,78.69},{41.34,63.26},{45.37,77.56},{47.15,74.61},{46.65,73.82},{53.0,71.64},{44.12,79.74},{45.09,79.24},{49.25,79.2},{46.46,75.91},{47.15,64.32},{38.91,69.79},{50.14,60.2},{47.28,51.49},{50.33,63.36},{49.46,64.71},{48.91,78.17},{45.77,75.0},{46.04,76.5},{48.39,68.67},{50.34,70.03},{50.53,69.23},{43.19,63.5},{48.43,70.68},{52.62,70.83},{52.23,69.46},{50.35,68.64},{44.9,69.82},{44.39,72.48},{45.89,60.57},{48.9,64.72},{46.97,68.95},{43.92,68.51},{47.72,77.64},{46.38,78.85},{47.04,78.76},{38.44,71.21},{47.67,71.72},{47.21,71.0},{46.42,70.13},{45.41,61.72},{42.07,69.16},{43.44,77.01},{43.79,75.94},{54.24,72.1},{47.29,72.74},{43.91,61.81},{50.43,53.63},{47.87,79.51},{46.59,61.31},{46.07,63.16},{44.51,62.42},{45.84,62.41},{48.06,55.09},{47.95,53.53},{49.44,53.04},{50.68,52.58},{48.59,56.78},{43.23,60.94},{42.65,61.39},{41.41,69.08},{39.71,72.0},{37.51,71.65},{38.37,72.51},{44.55,70.79},{49.17,58.28},{49.68,58.56},{46.44,59.17},{47.08,54.82},{50.38,55.82},{49.74,56.76},{50.95,54.69},{46.07,53.75}}},nil,15,nil,nil,16,nil,nil,0},
[4346] = {'Noxious Flayer',1403,1469,35,36,0,{[15]={{52.82,17.14},{52.6,12.82},{60.29,27.83},{51.45,13.05},{52.61,13.98},{50.49,31.94},{57.29,37.75},{54.64,35.52},{60.03,21.65},{54.13,35.15},{59.42,31.78},{56.35,38.36},{55.6,18.98},{47.95,25.9},{63.62,40.21},{60.47,35.42},{46.96,27.25},{57.72,38.59},{40.97,25.53},{38.07,23.66},{37.79,26.1},{38.32,25.23}}},nil,15,nil,nil,14,nil,nil,0},
[4347] = {'Noxious Reaver',1536,1604,37,38,0,{[15]={{42.17,43.09},{43.1,43.15},{43.61,35.53},{38.25,40.95},{40.13,40.29},{41.24,39.89},{40.7,43.51},{45.25,27.5},{44.01,30.34},{45.56,43.67},{34.68,41.76},{36.79,45.24},{45.31,42.28}}},nil,15,nil,nil,14,nil,nil,0},
[4348] = {'Noxious Shredder',1674,1751,38,39,0,{[15]={{38.89,51.04},{38.63,52.69},{35.63,59.47},{42.11,57.84},{33.18,57.83},{42.02,46.87},{41.06,49.09},{40.16,47.53},{41.37,47.24},{43.46,48.45},{44.1,48.54},{37.71,48.69},{36.26,50.9},{49.61,61.8},{36.42,56.67},{38.24,55.7},{36.87,54.09},{36.95,51.98},{49.43,63.32},{48.79,60.48},{47.72,60.2},{46.93,61.94},{43.53,62.02},{35.16,48.73},{43.86,52.79},{44.46,53.62},{40.89,51.78},{40.74,53.67},{40.21,56.68},{41.35,50.99}}},nil,15,nil,nil,14,nil,nil,0},
[4351] = {'Bloodfen Raptor',1403,1468,35,36,0,{[15]={{49.12,15.79},{52.28,16.99},{49.45,18.41},{48.57,15.18},{50.24,19.47},{49.03,17.76},{50.84,21.53},{49.51,20.41},{46.67,15.48},{48.35,18.75},{51.6,20.62},{51.99,21.36},{47.81,19.87},{45.1,20.85},{48.17,17.99},{45.84,16.61},{47.45,17.61}}},nil,15,nil,nil,48,nil,nil,0},
[4352] = {'Bloodfen Screecher',1469,1536,36,37,0,{[15]={{49.8,16.7},{50.52,15.7},{50.91,15.98},{52.2,15.2},{50.47,17.48},{52.39,19.29},{48.64,20.73},{48.86,19.58},{51.55,21.95},{48.24,16.46},{47.76,15.81},{47.26,16.47},{45.94,19.66},{47.23,18.46},{46.72,18.4},{47.72,17.41}}},nil,15,nil,nil,48,nil,nil,0},
[4355] = {'Bloodfen Scytheclaw',1536,1604,37,38,0,nil,nil,0,nil,nil,48,nil,nil,0},
[4356] = {'Bloodfen Razormaw',1677,1752,39,40,0,{[15]={{32.21,64.09},{32.08,64.45},{34.85,71.53},{33.57,69.88},{34.38,73.3},{34.16,69.01},{37.87,70.0},{36.15,69.63},{31.73,65.71},{32.58,65.28},{32.51,64.85},{34.83,66.62},{33.14,65.21},{31.96,66.81}}},nil,15,nil,nil,48,nil,nil,0},
[4357] = {'Bloodfen Lashtail',1828,1902,40,41,0,{[15]={{38.21,68.95},{31.55,64.12},{33.53,72.05},{34.31,71.35},{33.33,70.98},{36.93,69.05},{37.54,67.84},{36.31,66.1},{31.36,65.78},{31.26,66.01},{32.71,64.41},{33.07,64.46},{33.67,64.47},{33.11,65.74},{33.96,65.13},{32.73,66.21}}},nil,15,nil,nil,48,nil,nil,0},
[4358] = {'Mirefin Puddlejumper',1403,1469,35,36,0,nil,nil,0,nil,nil,18,nil,nil,0},
[4359] = {'Mirefin Murloc',1403,1468,35,36,0,{[15]={{57.13,15.03},{57.42,14.93},{57.44,15.17},{58.2,16.26},{57.98,15.41},{58.06,15.91},{58.48,16.22},{58.36,15.33},{58.85,14.9},{54.17,15.11},{54.07,14.94},{59.14,15.51},{54.57,15.53},{57.34,15.54},{54.19,15.66},{53.78,15.15},{55.36,16.61},{54.74,16.48},{57.45,16.0},{57.61,15.9},{57.49,16.58}}},nil,15,nil,nil,18,nil,nil,0},
[4360] = {'Mirefin Warrior',1536,1604,37,38,0,nil,nil,0,nil,nil,18,nil,nil,0},
[4361] = {'Mirefin Muckdweller',1469,1536,36,37,0,{[15]={{57.96,11.2},{62.98,6.23},{62.47,7.97},{63.09,8.94},{63.72,8.28},{63.53,6.54},{62.9,8.11},{63.07,7.07},{59.24,10.78},{59.91,7.28},{57.13,11.32},{58.48,10.1},{58.65,8.32},{58.22,8.69},{59.6,9.75},{59.2,9.66},{59.11,9.11}}},nil,15,nil,nil,18,nil,nil,0},
[4362] = {'Mirefin Coastrunner',1469,1536,36,37,0,{[15]={{58.32,16.07},{57.32,15.09},{57.6,14.86},{58.49,15.66},{58.36,15.41},{54.36,13.95},{54.33,14.82},{54.68,14.92},{56.18,16.65},{57.52,15.68},{58.7,16.27},{57.5,14.7},{53.96,15.18},{56.88,16.48},{57.07,16.29},{54.98,16.33},{58.44,16.82}}},nil,15,nil,nil,18,nil,nil,0},
[4363] = {'Mirefin Oracle',1256,1305,37,38,0,{[15]={{63.08,7.28},{63.83,6.97},{63.44,7.03},{62.42,7.24},{62.92,7.04},{59.89,9.98},{57.2,10.71},{57.54,10.35},{58.33,9.6},{59.6,9.48},{59.13,9.94},{59.81,8.67}}},nil,15,nil,nil,18,nil,nil,0},
[4364] = {'Strashaz Warrior',8883,9156,59,60,1,{[15]={{74.79,15.12},{75.05,14.84},{75.47,21.5},{76.96,18.43},{77.35,20.14}}},nil,15,nil,nil,74,nil,nil,0},
[4366] = {'Strashaz Serpent Guard',8883,9432,59,61,1,{[15]={{75.62,22.01},{76.3,19.47},{75.25,14.46},{75.11,14.17},{75.67,18.51},{74.34,16.73},{75.12,17.72}}},nil,15,nil,nil,74,nil,nil,0},
[4368] = {'Strashaz Myrmidon',9156,9432,60,61,1,{[15]={{77.07,19.54},{77.37,19.03},{77.21,18.85},{76.41,18.43},{76.49,17.72},{76.62,17.62},{76.86,17.07}}},nil,15,nil,nil,74,nil,nil,0},
[4370] = {'Strashaz Sorceress',7326,7545,60,61,1,{[15]={{76.53,22.19},{75.44,14.57},{77.41,19.03}}},nil,15,nil,nil,74,nil,nil,0},
[4371] = {'Strashaz Siren',7107,7326,59,60,1,{[15]={{74.29,18.43},{77.25,19.28},{75.33,21.82},{73.16,18.53},{76.5,17.4},{76.69,20.36}}},nil,15,nil,nil,74,nil,nil,0},
[4374] = {'Strashaz Hydra',8883,9432,59,61,1,{[15]={{69.35,18.58},{69.32,20.45},{70.68,18.38},{69.85,19.19},{70.14,21.29},{70.09,17.82},{70.47,16.86},{70.5,22.56},{70.57,20.48},{71.78,18.87},{74.4,17.71},{76.62,21.06}}},nil,15,nil,nil,74,nil,nil,0},
[4376] = {'Darkmist Spider',1403,1468,35,36,0,{[15]={{32.46,23.27},{31.51,21.95},{30.23,21.27},{30.34,21.78},{31.31,21.9},{30.82,20.28},{32.32,22.29},{34.36,25.59},{33.86,22.45},{35.12,24.32},{34.49,21.41},{35.04,21.51},{35.02,20.35}}},nil,15,nil,nil,22,nil,nil,0},
[4377] = {'Darkmist Lurker',1536,1604,37,38,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4378] = {'Darkmist Recluse',1468,1536,36,37,0,{[15]={{30.59,20.33},{32.56,22.57},{30.68,22.35},{31.29,22.03},{34.27,24.12},{35.05,22.51}}},nil,15,nil,nil,22,nil,nil,0},
[4379] = {'Darkmist Silkspinner',1604,1677,38,39,0,{[15]={{30.82,22.45},{31.22,21.48},{31.08,22.51},{30.59,20.84},{33.0,22.78},{31.94,22.29},{31.47,22.57},{32.01,22.48},{31.81,21.54},{33.55,20.57},{32.79,21.27},{34.77,24.27},{34.85,23.11},{34.32,23.13},{34.81,22.83},{34.4,22.32},{35.73,21.05},{33.8,21.34},{34.47,20.87}}},nil,15,nil,nil,22,nil,nil,0},
[4380] = {'Darkmist Widow',1752,1752,40,40,4,{[15]={{31.15,20.4}}},nil,15,nil,nil,22,nil,nil,0},
[4382] = {'Withervine Creeper',1403,1468,35,36,0,{[15]={{38.26,15.33},{38.74,17.82},{43.61,17.54},{36.64,16.77},{37.5,13.42},{41.86,13.89},{42.11,14.75},{42.92,17.62},{43.09,16.84},{42.82,19.42},{39.97,19.82},{41.98,24.33},{38.98,13.91},{40.13,13.65},{42.27,20.73},{42.53,15.91},{38.63,23.64},{37.78,22.63},{36.86,18.48},{37.74,21.51},{37.47,22.45},{37.64,23.36},{40.15,25.27},{41.39,23.41},{41.38,21.41},{40.14,21.39}}},nil,15,nil,nil,14,nil,nil,0},
[4385] = {'Withervine Rager',1604,1677,38,39,0,{[15]={{41.29,17.67},{40.93,18.37},{41.46,19.67},{38.27,18.21},{42.75,22.53},{36.9,14.87},{43.6,20.42},{39.39,22.97},{43.39,23.25},{38.92,21.32}}},nil,15,nil,nil,14,nil,nil,0},
[4386] = {'Withervine Bark Ripper',1468,1468,36,36,0,{[15]={{45.62,80.76},{41.14,71.68},{50.51,68.42},{50.34,66.3},{42.65,62.45},{45.64,60.99},{50.19,59.62},{38.63,53.9},{39.79,51.96},{38.63,50.16},{44.5,49.7},{34.67,48.7},{35.98,48.19},{43.77,47.36},{38.29,47.33},{45.22,46.45},{34.7,45.56},{40.02,44.22},{44.0,44.02},{39.12,43.59},{36.65,43.1},{40.08,42.68},{40.06,42.05},{37.62,41.79},{41.33,41.59},{35.85,37.64},{36.97,37.33},{42.53,36.79},{35.79,36.25},{54.82,32.88},{54.11,30.68},{52.82,29.62},{56.32,28.13},{56.67,26.76},{54.29,25.19},{39.22,24.82},{53.98,23.9},{37.37,23.59},{50.88,23.13},{52.32,22.65},{53.7,22.48},{50.08,22.42},{47.7,22.05},{44.82,21.73},{49.96,21.22},{45.79,20.42},{42.57,20.3},{51.16,18.85},{42.65,16.3}}},nil,15,nil,nil,14,nil,nil,0},
[4387] = {'Withervine Mire Beast',1536,1604,37,38,0,{[15]={{42.04,18.17},{38.93,19.57},{44.01,22.44},{43.31,21.4},{39.63,14.25},{40.75,20.3},{40.06,19.7},{41.81,28.13},{37.88,19.01},{37.31,18.8}}},nil,15,nil,nil,14,nil,nil,0},
[4388] = {'Young Murk Thresher',1828,1902,40,41,0,{[15]={{69.25,58.57},{67.47,58.57},{68.11,59.61},{70.01,58.16},{68.18,58.54},{68.71,59.32},{69.93,57.72},{70.82,56.73},{71.21,57.39},{72.64,55.44},{66.82,56.51},{67.44,56.59},{68.85,57.58},{67.02,57.8},{70.75,46.51},{71.79,56.73},{70.7,53.72},{71.32,53.68},{69.5,54.83},{69.22,55.77},{70.52,55.0},{70.65,52.87},{71.45,52.95},{69.26,57.63},{69.24,56.5},{70.09,55.78},{71.18,55.05},{72.48,54.6},{69.98,56.66},{71.48,56.17},{71.65,55.49},{72.06,54.78},{70.78,57.34},{70.54,55.83},{73.22,48.4},{73.79,46.92},{74.44,46.34},{73.81,45.51},{71.34,51.0},{71.95,53.65},{71.88,52.69},{71.3,52.09},{72.5,52.0},{72.05,51.07},{71.33,50.19},{71.13,49.0},{71.92,49.8},{72.73,50.9}}},nil,15,nil,nil,7,"AH",nil,0},
[4389] = {'Murk Thresher',1902,2059,41,43,0,{[15]={{53.08,39.31},{48.81,41.44},{49.79,40.23},{51.64,41.85},{54.95,44.99},{52.42,40.69},{58.09,43.11},{52.63,42.57},{56.43,44.84},{53.22,42.66},{50.65,37.43},{47.96,37.79},{46.78,34.29},{57.3,46.9}}},nil,15,nil,nil,16,nil,nil,0},
[4390] = {'Elder Murk Thresher',2059,2217,43,45,0,{[15]={{54.79,43.76},{55.56,48.03}}},nil,15,nil,nil,16,nil,nil,0},
[4391] = {'Swamp Ooze',1536,1678,37,39,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4392] = {'Corrosive Swamp Ooze',1604,1753,38,40,0,{[15]={{45.16,58.39},{44.25,58.62},{54.13,57.73},{49.26,55.73},{44.93,54.9},{54.48,54.65},{51.81,54.62},{53.3,52.96},{47.62,51.7},{50.97,50.28}}},nil,15,nil,nil,14,nil,nil,0},
[4393] = {'Acidic Swamp Ooze',1751,1902,39,41,0,{[15]={{50.13,50.08},{51.03,51.38},{55.41,53.71},{54.68,52.88},{54.16,53.73},{52.31,52.92},{51.02,56.75},{52.14,58.54},{51.65,55.64},{49.22,49.86},{51.38,52.07},{53.01,54.94},{53.39,58.18},{53.25,54.78},{54.48,56.77},{54.59,55.04},{52.95,58.68},{54.7,53.97},{52.77,54.3},{52.46,56.93},{53.54,58.44},{50.99,58.46}}},nil,15,nil,nil,14,nil,nil,0},
[4394] = {'Bubbling Swamp Ooze',4377,4572,39,40,1,{[15]={{49.4,55.54},{49.13,51.93},{53.34,52.61},{53.2,52.09},{50.56,57.12},{51.57,59.51},{54.21,58.21},{52.0,54.62},{49.32,51.26},{48.45,54.82},{51.74,57.56},{52.53,57.19},{52.99,55.89},{54.64,54.52},{48.76,53.65}}},nil,15,nil,nil,16,nil,nil,0},
[4395] = {'Blistering Swamp Ooze',1902,2059,41,43,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4396] = {'Mudrock Tortoise',1469,1536,36,37,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4397] = {'Mudrock Spikeshell',1536,1604,37,38,0,{[15]={{62.38,15.72},{62.53,5.59},{56.07,9.07},{64.33,8.99},{63.0,5.31},{57.9,6.37},{64.59,7.19},{66.11,28.09},{65.85,30.58},{64.21,30.16},{64.32,20.07},{60.23,8.67},{63.13,29.97},{62.4,28.64},{57.49,7.79},{59.13,6.77},{61.87,7.65},{61.84,28.21},{64.38,18.75},{55.8,15.9},{55.21,14.55},{55.03,13.21},{56.74,9.22},{54.26,11.37},{63.29,16.65},{62.21,10.08},{61.09,11.06},{62.14,9.12},{61.12,7.62},{60.93,7.58},{54.68,12.54},{54.32,12.92},{63.6,20.24},{61.5,22.65},{62.19,20.77},{60.37,16.53},{60.21,18.64},{59.65,14.73},{59.68,15.45},{64.73,39.66},{65.03,42.19},{64.79,40.84},{63.54,38.18},{63.06,35.72},{63.22,37.52},{61.71,30.12}}},nil,15,nil,nil,15,"AH",nil,0},
[4398] = {'Mudrock Burrower',1678,1753,39,40,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4399] = {'Mudrock Borer',1981,2059,42,43,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4400] = {'Mudrock Snapjaw',1902,1981,41,42,0,nil,nil,0,nil,nil,15,"AH",nil,0},
[4401] = {'Muckshell Clacker',1677,1752,39,40,0,{[15]={{49.28,37.26},{54.62,63.23},{59.19,44.41},{50.53,38.72},{55.87,43.73},{51.82,39.67},{59.15,63.24},{60.45,61.55},{51.99,43.46},{54.25,63.25},{59.27,46.15},{56.68,61.38},{54.23,46.08},{57.96,49.46},{56.66,63.41},{55.95,61.57},{61.07,46.01},{58.44,45.18},{58.68,44.47},{59.13,58.52}}},nil,15,nil,nil,129,nil,nil,0},
[4402] = {'Muckshell Snapclaw',1829,1902,40,41,0,{[15]={{60.1,48.84},{58.73,47.41},{59.63,51.82},{58.77,51.28},{59.88,49.56},{61.65,52.36},{61.93,53.43},{60.37,55.89},{60.94,56.74},{60.97,59.15},{59.82,60.4},{59.49,50.4},{58.99,52.75},{61.25,53.73},{60.65,55.37},{60.69,50.18},{58.34,49.68},{58.87,48.8},{61.42,45.16},{61.06,47.74},{57.02,50.54}}},nil,15,nil,nil,129,nil,nil,0},
[4403] = {'Muckshell Pincer',1902,1981,41,42,0,{[15]={{61.41,68.93},{61.39,64.94},{61.03,67.18},{59.66,61.14},{65.17,66.17},{62.48,65.84},{59.27,68.81},{62.38,69.98},{63.22,66.84},{61.1,66.16},{62.27,68.32},{59.9,66.35},{60.55,66.96},{60.18,63.02},{54.89,62.51},{55.32,62.54},{55.39,64.24},{55.43,63.26},{59.14,67.32},{59.77,68.03},{59.96,69.23},{60.61,68.03},{60.52,59.16},{55.47,61.51},{57.6,63.14}}},nil,15,nil,nil,129,nil,nil,0},
[4404] = {'Muckshell Scrabbler',1585,1647,42,43,0,{[15]={{56.21,65.02},{60.66,65.08},{64.08,67.31},{59.85,67.15},{57.7,43.2},{61.03,68.21},{61.38,63.21},{49.14,39.3},{50.57,41.78},{61.11,60.66},{61.63,67.2},{53.98,44.04},{53.25,41.26},{53.44,64.23},{57.33,60.19},{55.67,63.62},{54.65,64.21},{59.84,57.62},{55.85,62.77},{55.61,62.95},{55.97,64.2},{56.28,62.2},{54.88,46.38},{59.25,68.04},{60.4,68.86},{56.59,62.43},{56.46,46.78},{59.44,45.07}}},nil,15,nil,nil,129,nil,nil,0},
[4405] = {'Muckshell Razorclaw',2059,2138,43,44,0,nil,nil,0,nil,nil,129,nil,nil,0},
[4407] = {'Teloren',7842,7842,55,55,1,{[406]={{36.44,7.18}}},nil,406,nil,nil,80,"A","Hippogryph Master",11},
[4408] = {'Aquatic Form (Night Elf Druid)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4409] = {'Gatekeeper Kordurus',2097,2097,25,25,1,{[406]={{29.35,16.03}}},nil,406,nil,nil,79,"A",nil,2},
[4410] = {'Aquatic Form (Tauren Druid)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4411] = {'Darkfang Lurker',1469,1536,36,37,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4412] = {'Darkfang Creeper',1604,1677,38,39,0,{[15]={{43.93,34.55},{36.87,55.75},{35.78,55.55},{38.52,51.22},{40.37,53.11},{42.6,44.47},{41.71,43.02},{43.31,41.49},{42.75,42.43},{41.65,43.7},{44.12,45.92},{44.84,48.69},{40.82,48.32},{38.96,46.58},{35.42,45.2},{36.57,49.11},{35.86,51.81},{48.49,62.02},{40.09,60.02},{39.63,55.58},{39.54,57.55},{49.54,59.61},{39.14,39.68},{47.81,62.18},{48.39,63.19},{48.9,62.08},{37.37,38.24},{38.24,36.43},{37.57,54.82},{35.45,40.91},{43.6,54.24},{38.11,43.36},{44.96,28.6},{44.39,37.81},{44.31,30.23},{48.3,59.5},{46.92,45.49},{46.52,44.59},{45.97,41.29},{46.85,42.39},{45.94,40.19},{45.48,38.35},{44.71,36.88},{37.14,57.57},{37.54,44.24},{43.79,54.4},{33.89,54.78},{44.11,32.61},{41.4,34.54},{34.02,45.95},{42.08,51.84},{48.01,57.21},{46.85,55.31},{41.76,50.13},{40.11,54.73},{41.49,52.84},{42.18,63.12}}},nil,15,nil,nil,22,nil,nil,0},
[4413] = {'Darkfang Spider',1403,1469,35,36,0,nil,nil,0,nil,nil,22,nil,nil,0},
[4414] = {'Darkfang Venomspitter',1536,1604,37,38,0,{[15]={{52.71,15.41},{51.01,15.3},{50.06,30.57},{50.93,33.77},{35.69,14.8},{37.01,12.35},{56.37,19.4},{61.51,36.76},{62.1,37.92},{60.24,29.81},{51.97,32.68},{52.3,34.88},{56.79,39.42},{58.65,21.04},{60.02,23.01},{49.55,26.71},{62.88,39.26},{41.34,26.09},{58.48,37.91},{38.72,26.02},{49.61,23.45},{34.34,27.99},{37.73,27.68}}},nil,15,nil,nil,22,nil,nil,0},
[4415] = {'Giant Darkfang Spider',1828,1902,40,41,0,{[15]={{56.05,66.76},{51.51,64.47},{52.18,66.81},{53.43,66.44},{55.05,60.09},{53.86,60.72},{51.39,63.25},{53.99,67.82},{54.94,66.59},{52.26,48.44},{55.72,52.46},{56.02,54.01},{56.07,56.03},{49.21,45.15},{49.74,48.95},{50.75,47.95},{53.2,61.64},{48.38,46.72},{49.58,46.39},{52.47,60.45},{51.96,49.93},{50.36,47.68},{54.29,50.99},{52.02,61.84}}},nil,15,nil,nil,22,nil,nil,0},
[4416] = {'Defias Strip Miner',417,449,18,19,0,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[4417] = {'Defias Taskmaster',1251,1347,18,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[4418] = {'Defias Wizard',1062,1137,18,19,1,{[1581]={{-1,-1}}},nil,1581,nil,nil,17,nil,nil,0},
[4419] = {'Race Master Kronkrider',1342,1342,35,35,0,{[400]={{79.17,75.95}}},nil,400,nil,nil,35,"AH",nil,1},
[4420] = {'Overlord Ramtusk',7399,7399,32,32,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4421] = {'Charlga Razorflank',9280,9280,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,"The Crone",0},
[4422] = {'Agathelos the Raging',8880,8880,33,33,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4423] = {'Darnassian Protector',5228,5228,55,55,0,{[1657]={{46.57,22.7},{39.6,21.27},{34.89,12.32},{37.03,13.15},{46.34,21.33}}},nil,1657,nil,nil,79,"A",nil,0},
[4424] = {'Aggem Thorncurse',4055,4055,30,30,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,"Death's Head Prophet",0},
[4425] = {'Blind Hunter',5285,5285,32,32,2,{[491]={{-1,-1}}},nil,491,nil,nil,411,nil,nil,2},
[4427] = {'Ward Guardian',2550,2550,31,31,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4428] = {'Death Speaker Jargba',4055,4055,30,30,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,"Death's Head Captain",0},
[4429] = {'Goblin Pit Crewman',1002,1002,30,30,0,{[400]={{79.75,76.38},{79.83,76.95},{80.23,75.92},{80.18,76.58},{79.85,76.86}}},nil,400,nil,nil,35,"AH",nil,1},
[4430] = {'Gnome Pit Crewman',1002,1002,30,30,0,{[400]={{77.69,76.84},{77.54,77.25},{77.58,76.78},{77.86,77.46}}},nil,400,nil,nil,35,"AH",nil,1},
[4435] = {'Razorfen Warrior',1953,2097,24,25,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4436] = {'Razorfen Quilguard',2097,2250,25,26,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4437] = {'Razorfen Warden',2097,2250,25,26,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4438] = {'Razorfen Spearhide',1358,1433,29,30,2,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4440] = {'Razorfen Totemic',2319,2319,29,29,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4442] = {'Razorfen Defender',2400,2559,27,28,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4443] = {'Wazza',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH","Totem Merchent",0},
[4444] = {'Deathstalker Vincent',531,531,21,21,0,{[209]={{-1,-1}}},nil,209,nil,{1098},714,"H",nil,2},
[4445] = {'Griznak',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Race Vendor",0},
[4446] = {'Mazzer Stripscrew',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Race Vendor",0},
[4449] = {'Crazzle Sprysprocket',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Gnome Ticket Redeemer",0},
[4450] = {'Rugfizzle',1342,1342,35,35,0,nil,nil,0,nil,nil,35,"AH","Goblin Ticket Redeemer",0},
[4451] = {'Auld Stonespire',895,895,28,28,0,{[1638]={{35.97,59.92}}},nil,1638,{1102},{1102},104,"H",nil,2},
[4452] = {'Kravel Koalbeard',950,950,29,29,0,{[400]={{77.79,77.27}}},nil,400,{1110,1111,1114,1115,1118,1120,1121,1122,5762},{1110,1112,1117,1119},35,"AH",nil,2},
[4453] = {'Wizzle Brassbolts',1106,1106,31,31,0,{[400]={{78.14,77.12}}},nil,400,{1105,1107,2770},{1105,1107,1179,2769,2770},35,"AH",nil,6},
[4454] = {'Fizzle Brassbolts',1002,1002,30,30,0,{[400]={{78.06,77.13}}},nil,400,{1104,1106},{1104,1114,1137},35,"AH",nil,2},
[4455] = {'Red Jack Flint',573,573,22,22,0,{[11]={{9.96,57.96}}},nil,11,{1132},nil,12,"A",nil,2},
[4456] = {'Fiora Longears',787,787,26,26,0,{[15]={{66.46,45.15}}},nil,15,{1133,1135},{1132,1135},371,"A",nil,2},
[4457] = {'Murkgill Forager',1403,1469,35,36,0,{[33]={{33.97,23.27},{36.09,23.42}}},{[33]={{{36.18,23.54},{36.09,23.42},{35.88,23.24},{35.99,23.31},{36.08,23.42},{36.18,23.54},{36.42,23.63},{36.58,23.5},{36.77,23.25},{36.8,23.11},{36.85,22.96},{37.13,22.58},{36.94,22.83},{36.85,22.95},{36.79,23.18},{36.69,23.38},{36.48,23.6},{36.3,23.6}}}},33,nil,nil,18,nil,nil,0},
[4458] = {'Murkgill Hunter',1403,1469,35,36,0,{[33]={{34.33,24.24},{35.15,23.97},{33.7,21.62},{35.21,23.14},{35.36,20.72}}},nil,33,nil,nil,18,nil,nil,0},
[4459] = {'Murkgill Oracle',1208,1257,36,37,0,{[33]={{34.92,23.13},{35.36,22.72}}},nil,33,nil,nil,18,nil,nil,0},
[4460] = {'Murkgill Lord',1116,1116,37,37,0,{[33]={{35.62,24.24},{35.59,23.24}}},nil,33,nil,nil,18,nil,nil,0},
[4461] = {'Murkgill Warrior',1403,1469,35,36,0,{[33]={{33.92,21.48},{33.29,22.23},{33.89,22.24},{34.21,22.49},{34.0,20.64},{34.39,21.68},{35.08,23.3},{34.64,23.43},{35.2,23.55},{35.64,22.51},{35.32,23.34},{35.39,23.8}}},nil,33,nil,nil,18,nil,nil,0},
[4462] = {'Blackrock Hunter',1815,1953,23,24,1,{[44]={{69.5,54.04},{68.59,55.6},{67.06,56.43},{69.64,54.35},{69.8,57.69},{70.02,57.48},{67.66,55.8},{69.32,55.97},{69.32,55.34},{69.75,53.98},{68.58,56.45},{69.34,54.73},{69.1,56.3},{69.05,56.81},{69.24,55.43},{69.41,59.85}}},nil,44,nil,nil,40,nil,nil,0},
[4463] = {'Blackrock Summoner',472,504,22,23,0,{[44]={{73.85,78.31},{74.04,79.3},{60.99,42.82},{61.14,43.4},{60.64,43.04},{60.94,43.67},{25.88,14.85},{27.52,15.8},{27.45,10.82},{44.12,12.67},{28.43,11.83},{27.24,9.96},{42.97,12.27},{41.53,10.86},{39.19,14.85},{38.99,14.36},{43.86,19.63},{35.78,10.31},{35.9,10.8},{35.56,8.02},{34.44,7.85},{34.43,6.72},{32.02,6.41},{31.17,9.44},{28.91,12.76},{29.88,16.51},{28.42,14.74},{30.68,12.32}}},nil,44,nil,nil,40,nil,nil,0},
[4464] = {'Blackrock Gladiator',1953,2097,24,25,1,{[44]={{69.39,56.27},{67.06,56.43},{70.02,57.08},{68.15,55.0},{68.28,54.7}}},nil,44,nil,nil,40,nil,nil,0},
[4465] = {'Vilebranch Warrior',5544,5757,45,46,1,{[47]={{67.93,68.87},{66.06,63.86},{64.25,62.94},{63.03,60.82},{65.1,61.82},{66.89,64.16},{67.56,66.81},{67.84,66.49},{67.93,68.45},{66.44,65.46},{68.48,67.95},{68.59,64.38},{66.81,65.44},{66.8,64.15},{67.68,64.13},{66.16,67.8},{66.5,69.24},{68.6,68.9},{66.69,67.34}}},nil,47,nil,nil,795,nil,nil,0},
[4466] = {'Vilebranch Scalper',2399,2488,46,47,0,{[47]={{50.58,65.89},{49.45,65.46},{50.27,63.22},{46.13,64.37},{45.29,62.74},{45.48,68.24},{44.27,67.04},{46.96,69.81},{53.91,38.57},{52.18,39.72},{53.11,40.14},{53.82,39.73},{71.9,47.17},{72.16,48.58},{66.84,44.07},{66.03,42.98},{66.96,44.5},{69.91,49.37},{69.76,49.18},{70.45,47.49},{65.29,44.8},{71.92,48.45},{71.59,46.82}}},nil,47,nil,nil,795,nil,nil,0},
[4467] = {'Vilebranch Soothsayer',1679,1741,46,47,0,{[47]={{45.34,66.67},{44.57,65.48},{47.05,67.61},{45.91,68.15},{46.92,63.05},{48.04,65.62},{47.56,66.49},{47.04,65.46},{49.57,62.92},{48.83,64.4},{47.86,67.02},{48.15,67.39},{49.23,68.32},{48.55,67.99},{48.77,68.97},{53.07,39.22},{53.37,38.8},{71.0,48.57},{71.3,48.29},{66.16,44.28},{66.22,44.76},{70.6,48.54}}},nil,47,nil,nil,795,nil,nil,0},
[4468] = {'Jade Sludge',5970,6186,47,48,1,{[47]={{62.26,76.82},{61.09,75.15},{61.39,74.2},{61.93,73.74},{61.63,76.21},{60.98,73.6},{62.51,74.47},{63.13,75.35},{62.46,75.64},{63.08,76.59},{61.9,74.85}}},nil,47,nil,nil,14,nil,nil,0},
[4469] = {'Emerald Ooze',4605,4776,46,47,1,{[47]={{65.01,65.96},{65.08,66.03},{65.33,66.64},{65.02,65.02},{65.31,65.46}}},nil,47,nil,nil,14,nil,nil,0},
[4472] = {'Haunting Vision',3006,3101,57,58,0,{[28]={{64.45,57.97},{63.64,58.57},{63.06,61.18},{63.2,56.29},{63.88,56.4},{64.13,56.84},{62.76,60.43},{62.12,60.59},{63.34,58.97},{64.56,59.48},{65.07,58.62},{64.96,58.96},{62.9,58.33},{64.17,56.42},{63.22,55.59},{63.77,57.15},{62.76,61.23},{62.14,58.34},{62.66,58.89},{64.83,59.66}}},nil,28,nil,nil,21,nil,nil,0},
[4474] = {'Rotting Cadaver',3189,3293,53,54,0,{[28]={{45.71,53.93},{46.07,52.42},{46.57,52.02},{47.52,50.23},{47.8,50.92},{46.29,49.97},{47.83,51.46},{45.7,50.39},{47.06,49.78},{46.68,53.41},{44.95,54.61},{44.97,53.08},{47.28,50.99},{47.21,53.78},{47.49,49.7},{45.04,54.03},{44.78,51.76},{44.79,54.83},{46.11,51.35},{45.69,55.1},{48.22,50.8},{47.56,49.75},{46.63,50.81},{44.24,53.35}}},nil,28,nil,nil,21,nil,nil,0},
[4475] = {'Blighted Zombie',3082,3189,52,53,0,{[28]={{45.8,52.11},{46.46,52.4},{46.53,54.76},{45.5,51.19},{48.31,53.48},{47.57,52.78},{46.27,51.47},{47.69,49.49},{47.49,51.02},{48.03,51.51},{45.61,53.06},{47.74,50.7},{46.05,50.17},{47.39,49.74},{45.77,49.9},{46.07,56.31},{45.23,54.95},{46.78,49.9},{47.1,52.48},{48.13,50.35},{45.0,51.48},{47.24,50.21},{46.9,50.37}}},nil,28,nil,nil,21,nil,nil,0},
[4476] = {'Screaming Haunt',3292,3398,54,55,0,nil,nil,0,nil,nil,67,nil,nil,0},
[4479] = {'Fardel Dabyrie',1221,1221,33,33,0,{[45]={{56.55,38.7}}},nil,45,nil,nil,123,"A",nil,0},
[4480] = {'Kenata Dabyrie',1342,1342,35,35,0,{[45]={{56.38,36.09}}},nil,45,nil,nil,123,"A",nil,0},
[4481] = {'Marcel Dabyrie',1279,1279,34,34,0,{[45]={{54.18,38.09}}},nil,45,nil,nil,123,"A",nil,0},
[4482] = {'Vilebranch Wolf',5757,5970,46,47,1,nil,nil,0,nil,nil,38,nil,nil,0},
[4483] = {'Moktar Krin',1342,1342,35,35,0,{[400]={{67.58,63.94}}},nil,400,{1147},{1146,1147},29,"H",nil,2},
[4484] = {'Feero Ironhand',484,484,20,20,0,{[331]={{26.21,38.88}}},nil,331,{976},nil,123,"A",nil,2},
[4485] = {'Belgrom Rockmaul',1109,1109,35,35,0,{[1637]={{75.23,34.24}}},nil,1637,{1146,2981,3504},{1145,1184,2976,3507},29,"H",nil,2},
[4486] = {'Genavie Callow',1162,1162,32,32,0,{[1497]={{63.83,49.45}}},nil,1497,{1164},{1164},118,"H",nil,2},
[4487] = {'Kodiak',1003,1003,30,30,0,nil,nil,0,nil,nil,104,"H",nil,0},
[4488] = {'Parqual Fintallas',1342,1342,35,35,0,{[1497]={{57.8,65.42}}},nil,1497,{1160,1394,6628},{1159,1160,6628},68,"H",nil,3},
[4489] = {'Braug Dimspirit',1109,1109,35,35,0,{[406]={{78.8,45.69}}},nil,406,{1154,1159,6627},{1152,1154,6627},104,"H",nil,3},
[4490] = {'Grenka Bloodscreech',1106,1106,31,31,0,nil,nil,0,nil,nil,80,"A",nil,0},
[4491] = {'Woof',42,42,1,1,0,nil,nil,0,nil,nil,84,"A",nil,0},
[4493] = {'Scarlet Avenger',3644,3758,56,57,0,{[28]={{54.3,23.69},{53.14,36.64},{51.13,40.65},{52.64,38.39},{54.5,24.12},{54.89,34.04}}},nil,28,nil,nil,67,nil,nil,0},
[4494] = {'Scarlet Spellbinder',2631,2714,57,58,0,{[28]={{54.31,35.51},{54.93,23.54},{54.82,23.45},{54.94,23.25},{55.4,34.34},{55.06,23.61},{55.21,23.4},{55.31,22.78},{54.91,23.14}}},nil,28,nil,nil,67,nil,nil,0},
[4495] = {'Gnome Pit Boss',1342,1342,35,35,0,{[400]={{77.56,76.94}}},nil,400,nil,{1120},35,"AH",nil,2},
[4496] = {'Goblin Pit Boss',1002,1002,30,30,0,{[400]={{79.9,76.74}}},nil,400,nil,{1121},35,"AH",nil,2},
[4497] = {'Captain Quirk',57,57,1,1,0,nil,nil,0,nil,nil,35,"AH","Boat Operator",0},
[4498] = {'Maurin Bonesplitter',1342,1342,35,35,0,{[405]={{52.25,53.44}}},nil,405,{1435,1481,1482,1484},{1433,1435,1480,1481,1482},68,"H",nil,2},
[4499] = {'Rok\'Alim the Pounder',2865,2865,30,30,1,{[400]={{25.81,42.11}}},{[400]={{{25.74,42.21},{25.51,42.54},{25.3,43.09},{25.17,43.46},{25.02,44.0},{24.92,44.43},{24.83,44.85},{24.76,45.06},{24.33,45.01},{23.83,44.44},{23.36,43.9},{22.94,43.45},{22.33,42.78},{21.87,42.01},{21.39,41.42},{20.82,41.01},{20.34,40.48},{19.92,39.77},{19.82,39.62},{19.25,39.21},{18.57,38.73},{18.06,38.37},{17.36,37.6},{17.08,37.37},{16.65,36.59},{16.49,35.79},{16.05,35.44},{15.73,34.95},{15.22,33.89},{14.98,33.41},{14.88,32.78},{14.9,32.21},{14.81,31.57},{14.45,30.54},{14.2,29.83},{14.13,29.53},{13.79,28.76},{13.35,27.76},{13.13,27.17},{12.96,26.56},{12.63,26.08},{12.19,25.62},{11.8,25.08},{11.59,24.57},{11.48,24.19},{11.28,23.78},{10.98,22.91},{10.66,22.48},{10.2,22.17},{9.48,21.5},{9.6,20.91},{9.88,21.25},{10.37,21.65},{10.64,21.77},{11.02,21.95},{11.33,21.82},{11.63,21.49},{11.87,20.97},{12.12,20.64},{12.59,20.24},{12.95,19.6},{13.14,19.98},{13.24,20.02},{13.63,19.95},{14.04,20.05},{14.3,20.79},{14.52,21.45},{14.79,22.07},{15.07,22.79},{15.52,23.47},{15.41,23.98},{15.12,24.89},{15.09,25.31},{15.42,25.93},{15.96,26.03},{16.21,26.16},{16.38,26.45},{16.6,26.65},{17.02,26.81},{17.7,26.87},{18.54,26.57},{18.92,26.6},{19.47,26.86},{19.8,27.19},{20.32,27.36},{20.63,27.56},{21.28,27.67},{21.46,27.94},{21.31,28.56},{21.42,29.43},{22.25,30.59},{22.51,31.01},{23.18,31.27},{24.01,30.97},{24.25,30.76},{24.71,30.59},{25.16,29.79},{25.68,28.86},{26.2,28.35},{26.77,28.32},{27.37,28.5},{28.0,28.79},{28.16,29.43},{28.27,30.12},{28.37,30.73},{28.47,31.34},{28.6,32.09},{28.9,32.6},{29.39,33.1},{29.92,34.18},{30.23,35.05},{30.26,36.21},{30.14,37.48},{30.39,38.42},{30.5,38.83},{30.9,39.45},{31.2,40.33},{31.78,41.14},{32.67,41.57},{33.46,41.95},{34.01,42.45},{34.77,42.65},{35.5,42.51},{36.19,42.9},{36.69,44.35},{36.85,45.4},{36.54,46.65},{36.57,47.87},{36.6,49.0},{36.48,49.82},{36.11,50.36},{35.48,50.91},{35.14,51.53},{34.47,52.33},{34.19,53.12},{33.74,53.43},{33.12,53.33},{32.56,52.96},{32.17,52.84},{31.75,52.5},{31.76,51.99},{31.97,51.25},{31.73,50.81},{31.45,51.03},{31.2,51.64},{30.86,51.7},{30.37,51.61},{30.14,51.43},{29.88,51.29},{29.73,51.22},{29.44,51.11},{29.07,50.67},{28.67,50.18},{28.0,49.38},{27.66,49.01},{26.97,48.25},{26.1,47.47},{25.42,46.65},{24.85,45.71},{24.02,44.68},{23.5,43.9},{22.78,43.23},{22.16,42.35},{21.44,41.6},{20.63,40.75},{20.96,39.03},{21.54,38.45},{21.91,37.75},{22.59,37.43},{23.46,37.02},{24.08,36.38},{24.79,36.75},{25.17,37.48},{25.49,38.12},{25.72,38.81},{25.87,39.65},{26.02,40.51},{25.97,41.4}}}},400,nil,nil,91,nil,nil,0},
[4500] = {'Overlord Mok\'Morokk',14784,14784,45,45,1,{[15]={{36.29,31.41}}},nil,15,{1166,1171,1173},{1166,1170},29,"H",nil,2},
[4501] = {'Draz\'Zilb',1752,1752,40,40,0,{[15]={{37.15,33.09}}},nil,15,{1169,1170,1172},{1169,1171,1172,1173},29,"H",nil,3},
[4502] = {'Tharg',2138,2138,44,44,0,{[15]={{37.37,31.39}}},nil,15,{1168},{1168},29,"H",nil,2},
[4503] = {'Mudcrush Durtfeet',1981,1981,42,42,0,{[15]={{35.15,38.26}}},nil,15,{1177},{1177},35,"AH",nil,2},
[4504] = {'Frostmaw',1536,1536,37,37,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4505] = {'Bloodsail Deckhand',2059,2138,43,44,0,{[33]={{29.35,89.31},{30.5,90.08},{33.36,88.35},{33.53,88.17},{33.06,88.38},{33.31,88.11},{33.55,88.15},{33.04,88.23},{33.21,88.35},{29.45,89.46},{30.59,89.93},{30.64,90.43},{30.6,90.4},{30.69,90.65},{29.44,89.12},{29.21,88.72}}},nil,33,nil,nil,119,nil,nil,0},
[4506] = {'Bloodsail Swabby',1981,2138,42,44,0,{[33]={{33.24,88.11},{33.16,88.27},{33.03,88.1},{33.02,88.34},{33.4,88.36},{29.43,89.42},{30.52,89.5}}},nil,33,nil,nil,119,nil,nil,0},
[4507] = {'Daisy',328,328,15,15,0,{[400]={{79.48,76.86}}},nil,400,nil,nil,35,"AH","Race Starter Girl",0},
[4508] = {'Willix the Importer',2400,2400,27,27,1,{[491]={{-1,-1}}},nil,491,{1144},{1144},69,"AH",nil,2},
[4509] = {'Sargath',484,484,20,20,0,nil,nil,0,nil,nil,84,"A",nil,0},
[4510] = {'Heralath Fallowbrook',712,712,25,25,0,{[491]={{-1,-1}}},nil,491,{1142},nil,80,"A",nil,2},
[4511] = {'Agam\'ar',1953,2097,24,25,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4512] = {'Rotting Agam\'ar',2559,2559,28,28,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4514] = {'Raging Agam\'ar',2097,2250,25,26,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4515] = {'Death\'s Head Acolyte',2196,2319,28,29,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4516] = {'Death\'s Head Adept',2532,2676,27,28,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4517] = {'Death\'s Head Priest',1953,2070,26,27,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4518] = {'Death\'s Head Sage',2319,2433,29,30,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4519] = {'Death\'s Head Seer',2196,2319,28,29,1,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4520] = {'Razorfen Geomancer',1830,1830,25,25,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4521] = {'Treshala Fallowbrook',484,484,20,20,0,{[1657]={{69.54,67.75}}},nil,1657,nil,{1142},80,"A",nil,2},
[4522] = {'Razorfen Dustweaver',2196,2319,28,29,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4523] = {'Razorfen Groundshaker',2070,2196,27,28,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4525] = {'Razorfen Earthbreaker',2433,2550,30,31,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4526] = {'Wind Howler',559,600,25,26,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4528] = {'Stone Rumbler',521,521,21,21,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4530] = {'Razorfen Handler',2097,2250,25,26,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4531] = {'Razorfen Beast Trainer',2559,2715,28,29,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4532] = {'Razorfen Beastmaster',2865,3018,30,31,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4534] = {'Tamed Hyena',640,682,27,28,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4535] = {'Tamed Battleboar',699,750,25,26,1,nil,nil,0,nil,nil,152,nil,nil,0},
[4538] = {'Kraul Bat',2865,3018,30,31,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4539] = {'Greater Kraul Bat',3171,3171,32,32,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4540] = {'Scarlet Monk',3660,3831,35,36,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,0},
[4541] = {'Blood of Agamaggan',2400,2400,27,27,1,{[491]={{-1,-1}}},nil,491,nil,nil,16,nil,nil,0},
[4542] = {'High Inquisitor Fairbanks',6130,6130,40,40,1,{[796]={{-1,-1}}},nil,796,nil,nil,67,nil,nil,1},
[4543] = {'Bloodmage Thalnos',7736,7736,34,34,1,{[796]={{-1,-1}}},nil,796,nil,nil,21,nil,nil,0},
[4544] = {'Krueg Skullsplitter',1536,1536,37,37,0,{[357]={{75.94,42.74}}},nil,357,{2973,2974,2976},{2973,2974},29,"H",nil,2},
[4545] = {'Nag\'zehn',1342,1342,35,35,0,{[400]={{67.84,64.34}}},nil,400,nil,nil,83,"H",nil,0},
[4546] = {'Bor\'zehn',1342,1342,35,35,0,{[400]={{67.8,63.83}}},nil,400,nil,nil,83,"H",nil,0},
[4547] = {'Tarkreu Shadowstalker',1342,1342,35,35,0,{[400]={{67.69,64.09}}},nil,400,nil,nil,83,"H",nil,0},
[4548] = {'Steelsnap',1002,1002,30,30,0,{[400]={{17.79,19.79}}},{[400]={{{17.68,19.63},{17.53,19.38},{17.39,19.15},{17.22,18.95},{17.04,18.76},{16.8,18.64},{16.48,18.59},{16.17,18.5},{15.85,18.51},{15.65,18.57},{15.48,18.89},{15.33,19.09},{15.15,19.24},{14.95,19.41},{14.79,19.65},{14.64,19.75},{14.45,19.8},{14.26,19.72},{14.1,19.73},{14.04,19.82},{13.93,19.92},{13.72,19.91},{13.43,19.79},{13.29,19.69},{13.08,19.43},{12.88,19.32},{12.59,19.4},{12.55,19.65},{12.57,20.05},{12.52,20.34},{12.38,20.54},{12.17,20.67},{12.0,20.86},{11.87,21.07},{11.73,21.31},{11.59,21.56},{11.46,21.76},{11.29,22.02},{11.14,22.35},{11.1,22.72},{11.17,23.19},{11.26,23.57},{11.39,23.87},{11.48,24.08},{11.51,24.41},{11.64,24.63},{11.9,25.0},{12.17,25.34},{12.36,25.57},{12.36,25.57},{12.86,26.16},{12.93,26.23},{13.12,26.54},{13.29,26.94},{13.44,27.34},{13.58,27.77},{13.7,28.21},{13.97,29.08},{14.11,29.5},{14.19,29.75},{14.36,30.16},{14.53,30.55},{14.82,31.27},{15.02,31.62},{15.21,31.68},{15.32,31.71},{15.37,31.74},{15.43,31.73},{15.58,31.62},{15.58,31.62},{16.08,31.02},{16.33,30.72},{16.57,30.41},{16.87,29.94},{17.12,29.64},{17.42,29.07},{17.45,28.69},{17.48,28.21},{17.52,27.77},{17.76,27.22},{17.93,26.82},{18.11,26.44},{18.4,25.81},{18.55,25.38},{18.72,24.72},{18.74,24.53},{18.68,23.95},{18.52,23.54},{18.39,23.1},{18.16,22.37},{18.09,21.86},{18.09,21.46},{18.02,20.5},{17.92,20.11}}}},400,nil,nil,38,nil,nil,0},
[4549] = {'William Montague',5544,5544,45,45,0,{[1497]={{65.97,44.75}}},nil,1497,nil,nil,68,"H","Banker",256},
[4550] = {'Ophelia Montague',5544,5544,45,45,0,{[1497]={{65.56,44.07}}},nil,1497,nil,nil,68,"H","Banker",256},
[4551] = {'Michael Garrett',7842,7842,55,55,1,{[1497]={{63.25,48.56}}},nil,1497,{6324},{6322},68,"H","Bat Handler",11},
[4552] = {'Eunice Burch',1342,1342,35,35,0,{[1497]={{62.14,44.91}}},nil,1497,nil,nil,68,"H","Cooking Trainer",19},
[4553] = {'Ronald Burch',1002,1002,30,30,0,{[1497]={{62.31,43.09}}},nil,1497,nil,nil,68,"H","Cooking Supplier",6},
[4554] = {'Tawny Grisette',1002,1002,30,30,0,{[1497]={{65.19,49.84}}},{[1497]={{{66.86,49.85},{68.16,48.89},{69.2,47.29},{69.82,45.64},{69.86,42.5},{69.29,41.06},{67.5,38.46},{65.91,38.18},{64.36,38.78},{62.78,41.0},{62.14,42.71},{62.15,45.72},{63.14,47.82},{64.1,49.3},{65.03,49.84}}}},1497,nil,nil,68,"H","Mushroom Vendor",6},
[4555] = {'Eleanor Rusk',1002,1002,30,30,0,{[1497]={{69.17,48.93}}},nil,1497,nil,nil,68,"H","General Goods Vendor",6},
[4556] = {'Gordon Wendham',1002,1002,30,30,0,{[1497]={{61.49,41.79}}},nil,1497,{6322},{6323},68,"H","Weapons Merchant",16391},
[4557] = {'Louis Warren',1002,1002,30,30,0,{[1497]={{61.15,40.88}}},nil,1497,nil,nil,68,"H","Weapons Merchant",16388},
[4558] = {'Lauren Newcomb',1002,1002,30,30,0,{[1497]={{63.83,37.97}}},nil,1497,nil,nil,68,"H","Light Armor Merchant",16388},
[4559] = {'Timothy Weldon',1002,1002,30,30,0,{[1497]={{62.62,39.71}}},nil,1497,nil,nil,68,"H","Heavy Armor Merchant",16388},
[4560] = {'Walter Ellingson',1002,1002,30,30,0,{[1497]={{62.34,38.67}}},nil,1497,nil,nil,68,"H","Heavy Armor Merchant",16388},
[4561] = {'Daniel Bartlett',1002,1002,30,30,0,{[1497]={{64.05,37.37}}},nil,1497,nil,nil,68,"H","General Trade Supplier",6},
[4562] = {'Thomas Mordan',1002,1002,30,30,0,{[1497]={{69.69,39.05}}},nil,1497,nil,nil,68,"H","Reagent Vendor",4},
[4563] = {'Kaal Soulreaper',4120,4120,60,60,0,{[1497]={{86.21,15.93}}},nil,1497,{4489,4739,4969,8419},nil,68,"H","Warlock Trainer",19},
[4564] = {'Luther Pickman',2768,2768,50,50,0,{[1497]={{86.43,15.25}}},nil,1497,{8419},nil,68,"H","Warlock Trainer",19},
[4565] = {'Richard Kerwin',1752,1752,40,40,0,{[1497]={{88.91,15.86}}},nil,1497,{8419},nil,68,"H","Warlock Trainer",19},
[4566] = {'Kaelystia Hatebringer',4120,4120,60,60,0,{[1497]={{85.02,14.02}}},nil,1497,nil,nil,68,"H","Mage Trainer",19},
[4567] = {'Pierce Shackleton',2768,2768,50,50,0,{[1497]={{85.45,13.51}}},nil,1497,{8250},nil,68,"H","Mage Trainer",19},
[4568] = {'Anastasia Hartwell',1752,1752,40,40,0,{[1497]={{85.14,10.03}}},nil,1497,{1882,1943,1953,1960,1961,2861},{1881,1882,1959,1960},68,"H","Mage Trainer",19},
[4569] = {'Charles Seaton',1002,1002,30,30,0,{[1497]={{77.08,49.4}}},nil,1497,nil,nil,68,"H","Blade Merchant",16388},
[4570] = {'Sydney Upton',1002,1002,30,30,0,{[1497]={{69.46,27.44}}},nil,1497,nil,nil,68,"H","Staff Merchant",16388},
[4571] = {'Morley Bates',1002,1002,30,30,0,{[1497]={{72.93,26.73}}},{[1497]={{{72.51,29.46},{72.92,30.59},{73.25,31.08},{74.85,33.41},{75.25,34.0},{76.18,34.57}},{{77.69,31.53},{77.3,30.35},{76.52,29.15},{76.53,28.65},{77.72,26.91},{78.92,25.19},{79.31,25.35},{80.0,26.27},{81.29,28.19},{82.62,28.61},{83.34,27.77},{84.07,25.64},{82.94,22.64},{81.44,20.89},{80.28,18.87},{78.42,17.74},{77.34,18.48},{76.69,20.3},{77.07,21.4},{77.59,22.49},{78.08,23.4},{78.77,24.49},{78.93,25.13},{77.71,26.82},{76.5,28.72},{76.09,28.43},{75.38,27.54},{74.71,27.68},{72.92,26.75},{72.33,27.61}}},[85]={{{64.25,72.22}}}},1497,nil,nil,68,"H","Fungus Vendor",6},
[4572] = {'Silas Zimmer',1002,1002,30,30,0,{[1497]={{84.96,19.21}}},nil,1497,nil,nil,68,"H",nil,0},
[4573] = {'Armand Cromwell',1342,1342,35,35,0,{[1497]={{80.7,31.26}}},nil,1497,nil,nil,68,"H","Fishing Trainer",19},
[4574] = {'Lizbeth Cromwell',1002,1002,30,30,0,{[1497]={{81.04,30.75}}},nil,1497,nil,nil,68,"H","Fishing Supplier",6},
[4575] = {'Hannah Akeley',1002,1002,30,30,0,{[1497]={{82.78,15.83}}},nil,1497,nil,nil,68,"H","Reagent Supplier",4},
[4576] = {'Josef Gregorian',2217,2217,45,45,0,{[1497]={{70.76,30.69}}},nil,1497,{1962},{1961,1962},68,"H","Artisan Tailor",19},
[4577] = {'Millie Gregorian',1002,1002,30,30,0,{[1497]={{70.59,30.14}}},nil,1497,nil,nil,68,"H","Tailoring Supplies",6},
[4578] = {'Josephine Lister',2217,2217,45,45,0,{[1497]={{86.65,22.08}}},nil,1497,nil,nil,68,"H","Master Shadoweave Tailor",19},
[4580] = {'Lucille Castleton',1002,1002,30,30,0,{[1497]={{71.18,29.59}}},nil,1497,nil,nil,68,"H","Robe Vendor",16388},
[4581] = {'Salazar Bloch',1002,1002,30,30,0,{[1497]={{77.42,39.26}}},nil,1497,nil,nil,68,"H","Book Dealer",6},
[4582] = {'Carolyn Ward',1752,1752,40,40,0,{[1497]={{83.86,72.07}}},nil,1497,nil,nil,68,"H","Rogue Trainer",19},
[4583] = {'Miles Dexter',2768,2768,50,50,0,{[1497]={{85.21,71.57}}},nil,1497,{8233},nil,68,"H","Rogue Trainer",19},
[4584] = {'Gregory Charles',4120,4120,60,60,0,{[1497]={{84.88,73.53}}},nil,1497,nil,nil,68,"H","Rogue Trainer",19},
[4585] = {'Ezekiel Graves',1002,1002,30,30,0,{[1497]={{75.2,51.18}}},nil,1497,nil,nil,68,"H","Poison Vendor",4},
[4586] = {'Graham Van Talen',1002,1002,30,30,0,{[1497]={{75.34,73.13}}},nil,1497,{3526,3635},nil,68,"H","Journeyman Engineer",19},
[4587] = {'Elizabeth Van Talen',1002,1002,30,30,0,{[1497]={{75.48,74.34}}},nil,1497,nil,nil,68,"H","Engineering Supplier",6},
[4588] = {'Arthur Moore',1342,1342,35,35,0,{[1497]={{70.18,57.42}}},nil,1497,nil,nil,68,"H","Expert Leatherworker",19},
[4589] = {'Joseph Moore',1002,1002,30,30,0,{[1497]={{70.07,58.44}}},nil,1497,nil,nil,68,"H","Leatherworking Supplies",6},
[4590] = {'Jonathan Chambers',1002,1002,30,30,0,{[1497]={{69.24,61.21}}},nil,1497,nil,nil,68,"H","Bag Vendor",6},
[4591] = {'Mary Edras',1342,1342,35,35,0,{[1497]={{73.16,55.15}}},nil,1497,nil,nil,68,"H","First Aid Trainer",19},
[4592] = {'Nathaniel Steenwick',1002,1002,30,30,0,{[1497]={{77.49,49.63}}},nil,1497,nil,nil,68,"H","Thrown Weapons Merchant",16388},
[4593] = {'Christoph Walker',4120,4120,60,60,0,{[1497]={{46.93,15.23}}},nil,1497,{8417},nil,68,"H","Warrior Trainer",19},
[4594] = {'Angela Curthas',2768,2768,50,50,0,{[1497]={{48.32,15.96}}},nil,1497,nil,nil,68,"H","Warrior Trainer",19},
[4595] = {'Baltus Fowler',1752,1752,40,40,0,{[1497]={{47.4,17.29}}},nil,1497,{1718,1818},nil,68,"H","Warrior Trainer",19},
[4596] = {'James Van Brunt',1342,1342,35,35,0,{[1497]={{61.26,30.63}}},nil,1497,nil,nil,68,"H","Expert Blacksmith",19},
[4597] = {'Samuel Van Brunt',1002,1002,30,30,0,{[1497]={{61.41,30.08}}},nil,1497,nil,nil,68,"H","Blacksmithing Supplier",16390},
[4598] = {'Brom Killian',1342,1342,35,35,0,{[1497]={{56.03,37.45}}},nil,1497,nil,nil,68,"H","Mining Trainer",19},
[4599] = {'Sarah Killian',1002,1002,30,30,0,{[1497]={{56.72,36.94}}},nil,1497,nil,nil,68,"H","Mining Supplier",6},
[4600] = {'Geoffrey Hartwell',1002,1002,30,30,0,{[1497]={{58.67,33.06}}},nil,1497,nil,nil,68,"H","Weapon Merchant",16388},
[4601] = {'Francis Eliot',1002,1002,30,30,0,{[1497]={{59.0,32.58}}},nil,1497,nil,nil,68,"H","Weapon Merchant",16388},
[4602] = {'Benijah Fenner',1002,1002,30,30,0,{[1497]={{58.82,32.82}}},nil,1497,nil,nil,68,"H","Weapon Merchant",16388},
[4603] = {'Nicholas Atwood',1002,1002,30,30,0,{[1497]={{62.72,26.76}}},nil,1497,nil,nil,68,"H","Gun Merchant",16388},
[4604] = {'Abigail Sawyer',1002,1002,30,30,0,{[1497]={{54.7,38.76}}},nil,1497,nil,nil,68,"H","Bow Merchant",16388},
[4605] = {'Basil Frye',787,787,26,26,0,{[1497]={{60.17,29.09}}},nil,1497,nil,nil,68,"H","Journeyman Blacksmith",19},
[4606] = {'Aelthalyste',4120,4120,60,60,0,{[1497]={{49.26,17.12}}},nil,1497,{8254},{5644,5646,5658,5660,5661,5662,5663,5679},68,"H","Priest Trainer",19},
[4607] = {'Father Lankester',1752,1752,40,40,0,{[1497]={{49.14,14.61}}},nil,1497,{5643,5656,5658,5679},nil,68,"H","Priest Trainer",19},
[4608] = {'Father Lazarus',2768,2768,50,50,0,{[1497]={{47.57,18.9}}},nil,1497,{8254},nil,68,"H","Priest Trainer",19},
[4609] = {'Doctor Marsh',1342,1342,35,35,0,{[1497]={{50.93,74.56}}},nil,1497,nil,nil,68,"H","Expert Alchemist",19},
[4610] = {'Algernon',1002,1002,30,30,0,{[1497]={{51.71,74.67}}},nil,1497,nil,nil,68,"H","Alchemy Supplies",6},
[4611] = {'Doctor Herbert Halsey',2768,2768,50,50,0,{[1497]={{47.77,73.34}}},nil,1497,nil,nil,68,"H","Artisan Alchemist",19},
[4612] = {'Boyle',1002,1002,30,30,0,{[1497]={{55.5,64.1}}},nil,1497,nil,nil,68,"H",nil,0},
[4613] = {'Christopher Drakul',2768,2768,50,50,0,{[1497]={{69.7,44.79}}},nil,1497,nil,nil,68,"H","Guild Master",1537},
[4614] = {'Martha Alliestar',1342,1342,35,35,0,{[1497]={{54.0,49.55}}},nil,1497,nil,nil,68,"H","Herbalism Trainer",16},
[4615] = {'Katrina Alliestar',1002,1002,30,30,0,{[1497]={{54.73,48.92}}},nil,1497,nil,nil,68,"H","Herbalism Supplier",6},
[4616] = {'Lavinia Crowe',1342,1342,35,35,0,{[1497]={{62.47,61.8}}},nil,1497,nil,nil,68,"H","Expert Enchanter",17},
[4617] = {'Thaddeus Webb',1002,1002,30,30,0,{[1497]={{62.38,60.98}}},nil,1497,nil,nil,68,"H","Enchanting Supplies",6},
[4618] = {'Martek the Exiled',1981,1981,42,42,0,{[3]={{42.22,52.69}}},nil,3,{1108,1137},{1106,1108},35,"AH",nil,3},
[4619] = {'Geltharis',1163,1163,32,32,0,{[331]={{77.99,42.42}}},nil,331,nil,nil,90,nil,nil,0},
[4620] = {'Fobeed',1342,1342,35,35,0,{[400]={{79.26,75.92}}},nil,400,nil,nil,35,"AH","Race Announcer",0},
[4621] = {'Rebald Yorglun',2769,2769,50,50,0,nil,nil,0,nil,nil,55,"A","Raptor Trainer",0},
[4623] = {'Quilguard Champion',2865,3018,30,31,1,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4624] = {'Booty Bay Bruiser',5568,5568,57,57,0,{[33]={{27.96,76.87},{26.13,73.09},{26.33,73.29},{27.59,78.04},{28.38,77.09},{27.31,77.41},{27.68,76.96},{27.78,77.52},{28.55,76.83},{28.01,73.72},{28.55,75.63},{27.36,77.49},{27.17,77.69},{27.86,73.68},{26.79,73.66},{26.91,73.6},{28.11,75.16},{27.68,77.15},{26.78,76.7},{28.27,76.77},{27.55,76.84},{26.67,77.03},{27.56,77.15},{28.64,77.0},{27.85,77.14},{27.8,74.0},{26.06,73.44},{28.33,75.97},{27.97,73.57},{28.75,75.4},{27.73,77.37},{27.75,74.63},{27.22,77.65},{28.87,74.85},{29.49,72.59},{27.26,76.94},{27.97,77.11},{26.92,77.39},{26.64,76.34},{27.95,77.87},{27.15,77.32},{27.73,77.11},{27.05,77.3},{28.37,76.08},{26.62,76.59},{27.65,76.59},{26.93,77.44},{28.15,76.51},{27.46,77.63},{28.07,77.1},{27.68,77.17},{28.3,75.74},{29.42,72.25},{29.68,72.63}}},nil,33,nil,nil,121,"AH",nil,0},
[4625] = {'Death\'s Head Ward Keeper',328,328,15,15,0,{[491]={{-1,-1}}},nil,491,nil,nil,154,nil,nil,0},
[4626] = {'CHOW Guard',6474,6474,62,62,0,nil,nil,0,nil,nil,11,"A",nil,0},
[4627] = {'Arugal\'s Voidwalker',651,699,24,25,0,nil,nil,0,nil,nil,24,nil,nil,0},
[4629] = {'Trackmaster Zherin',1002,1002,30,30,0,{[400]={{81.63,77.95}}},nil,400,{1175},{1175},35,"AH",nil,2},
[4630] = {'Pozzik',1002,1002,30,30,0,{[400]={{80.18,75.88}}},nil,400,{1176,1178,1186,1190,1192},{1176,1183,1192,1194},35,"AH",nil,2},
[4631] = {'Wharfmaster Lozgil',1342,1342,35,35,0,{[33]={{26.35,73.56}}},nil,33,{1181},{1180},120,"AH",nil,3},
[4632] = {'Kolkar Centaur',1050,1106,30,31,0,{[405]={{69.35,42.54},{70.11,41.16},{68.63,43.57},{69.35,46.87},{68.67,47.94},{68.55,52.17},{69.23,51.0}}},nil,405,nil,nil,130,nil,nil,0},
[4633] = {'Kolkar Scout',1050,1106,30,31,0,{[405]={{68.7,50.0},{68.58,41.22},{69.3,40.13},{68.47,38.82},{68.62,45.66},{69.39,44.42},{69.3,48.95},{70.06,45.53},{70.12,49.94}}},nil,405,nil,nil,130,nil,nil,0},
[4634] = {'Kolkar Mauler',1106,1162,31,32,0,{[405]={{70.75,43.6},{73.05,45.74},{72.25,40.17},{72.26,44.71},{71.54,45.46},{74.44,47.43},{70.92,46.71},{70.9,50.62},{71.44,43.76},{72.15,42.39},{73.71,43.1}}},nil,405,nil,nil,130,nil,nil,0},
[4635] = {'Kolkar Windchaser',935,976,31,32,0,{[405]={{70.86,49.05},{74.55,51.05},{72.36,46.56},{70.06,39.31},{70.86,40.2},{72.9,40.23},{71.65,41.91},{70.14,47.92},{69.6,40.62},{73.02,47.9},{73.48,48.47},{73.8,46.95},{72.72,42.37}}},nil,405,nil,nil,130,nil,nil,0},
[4636] = {'Kolkar Battle Lord',1162,1221,32,33,0,{[405]={{71.7,50.58},{70.42,43.18},{73.07,43.09},{73.85,50.54},{74.12,49.66},{74.26,49.99},{74.18,49.1},{72.93,46.68},{71.54,41.3},{70.94,42.03},{74.54,46.79},{74.4,46.11},{71.52,47.97},{73.81,44.71}}},nil,405,nil,nil,130,nil,nil,0},
[4637] = {'Kolkar Destroyer',976,1020,32,33,0,{[405]={{71.64,49.99},{73.58,52.11},{73.13,50.26},{74.7,48.77},{70.86,44.29},{73.26,42.36}}},nil,405,nil,nil,130,nil,nil,0},
[4638] = {'Magram Scout',1163,1221,32,33,0,{[405]={{73.8,65.69},{65.59,70.3},{72.14,68.92},{66.22,75.55},{70.13,69.1},{67.09,74.5}}},nil,405,nil,nil,133,nil,nil,0},
[4639] = {'Magram Outrunner',1163,1221,32,33,0,{[405]={{66.52,69.07},{67.08,69.98},{71.51,66.95},{65.7,74.58},{67.86,70.21}}},nil,405,nil,nil,133,nil,nil,0},
[4640] = {'Magram Wrangler',1221,1279,33,34,0,{[405]={{66.07,79.65},{69.26,82.21},{76.22,73.38},{72.91,66.77},{73.68,67.63},{65.84,72.29},{70.05,81.19},{68.53,81.34},{67.16,83.43},{72.84,77.77},{68.65,71.08},{75.99,71.24},{75.39,69.96},{72.86,73.59},{70.64,73.76},{69.44,73.56},{69.51,75.82},{67.74,73.29},{67.22,72.22}}},nil,405,nil,nil,133,nil,nil,0},
[4641] = {'Magram Windchaser',1021,1064,33,34,0,{[405]={{75.13,68.12},{75.95,75.88},{66.45,71.34},{66.23,78.95},{71.42,79.02},{70.73,80.08},{67.19,81.21},{67.89,82.34},{70.71,67.97},{64.93,77.95},{65.14,75.93},{69.29,69.97},{68.59,72.39},{74.48,69.07},{72.88,72.14},{68.63,76.66},{67.84,75.71},{66.53,73.72}}},nil,405,nil,nil,133,nil,nil,0},
[4642] = {'Magram Stormer',1064,1110,34,35,0,{[405]={{67.8,80.04},{68.53,83.16},{65.64,78.98},{69.99,77.8},{72.5,78.75},{70.72,75.81},{70.02,74.41},{68.45,74.62},{70.02,72.28},{69.95,76.97}}},nil,405,nil,nil,133,nil,nil,0},
[4643] = {'Magram Pack Runner',1279,1342,34,35,0,{[405]={{70.4,73.25},{65.41,77.33},{72.36,78.18}}},{[405]={{{70.4,73.25},{70.09,73.01},{69.8,72.84},{69.37,72.52},{69.12,72.09},{69.07,71.76},{69.01,71.24},{69.16,70.7},{69.33,70.35},{69.54,70.0},{69.84,69.49},{70.07,69.18},{70.38,68.83},{70.65,68.59},{71.16,68.27},{71.43,68.3},{71.79,68.59},{72.08,68.95},{72.36,69.52},{72.53,70.02},{72.7,70.67},{72.82,71.1},{72.97,71.76},{73.06,72.36},{73.02,73.09},{72.85,73.77},{72.63,74.1},{72.29,74.58},{72.04,74.87},{71.67,75.13},{71.3,74.89},{70.88,74.2}},{{65.41,77.33},{65.49,78.0},{65.67,78.21},{66.18,78.73},{66.44,79.06},{66.79,79.52},{67.08,79.98},{67.34,80.23},{67.8,80.28},{68.31,80.48},{68.75,80.75},{69.18,80.98},{69.42,81.02},{69.88,81.08},{70.19,81.16},{69.83,81.17},{69.37,81.14},{68.9,81.05},{68.52,81.02},{68.17,80.89},{67.89,80.7},{67.48,80.35},{67.11,79.94},{66.87,79.63},{66.57,79.1},{66.34,78.8},{65.93,78.54},{65.49,77.88}},{{72.36,78.18},{72.88,78.17},{73.11,78.18},{73.32,78.41},{73.51,78.33},{73.56,78.32},{73.84,78.4},{74.0,78.56},{74.12,78.48},{74.29,78.32},{74.52,78.23},{74.64,78.06},{74.67,77.83},{74.68,77.59},{74.76,77.24},{74.9,76.91},{75.0,76.76},{75.04,76.42},{75.09,76.19},{75.21,75.92},{75.36,75.79},{75.53,75.79},{75.72,75.82},{75.89,75.86},{76.01,75.58},{76.15,74.99},{76.18,74.29},{76.1,73.3},{76.03,72.84},{75.9,71.93},{75.75,71.27},{75.52,70.4},{75.31,69.77},{74.98,69.29},{74.6,69.2},{74.05,69.17},{73.93,68.69},{74.16,69.07},{74.53,69.16},{74.89,69.29},{75.33,69.85},{75.44,70.35},{75.61,71.01},{75.75,71.67},{75.89,72.34},{76.06,73.24},{76.13,73.87},{76.16,74.56},{76.09,75.18},{75.88,75.86},{75.53,75.77},{75.37,75.8},{75.15,76.0},{75.0,76.32},{74.94,76.75},{74.79,77.48},{74.66,77.79},{74.65,77.97},{74.59,78.24},{74.38,78.34},{74.18,78.38},{74.05,78.48},{73.96,78.57},{73.82,78.47},{73.53,78.27},{73.31,78.36},{73.13,78.2},{72.8,78.0}}}},405,nil,nil,133,nil,nil,0},
[4644] = {'Magram Marauder',1403,1469,35,36,0,{[405]={{65.96,80.55},{66.59,80.61},{71.27,71.45},{70.56,75.16},{73.42,73.42},{73.15,74.55}}},nil,405,nil,nil,133,nil,nil,0},
[4645] = {'Magram Mauler',1403,1469,35,36,0,{[405]={{66.39,80.06},{69.32,77.73},{69.69,78.34},{72.2,78.46},{73.64,72.7},{70.97,75.12}}},nil,405,nil,nil,133,nil,nil,0},
[4646] = {'Gelkis Outrunner',1163,1221,32,33,0,{[405]={{37.43,84.29},{35.35,88.07},{39.78,83.31},{34.54,84.5},{35.07,85.51},{35.91,85.62},{40.53,89.79}}},nil,405,nil,nil,132,nil,nil,0},
[4647] = {'Gelkis Scout',1163,1221,32,33,0,{[405]={{39.02,84.7},{39.75,89.55},{34.39,80.25},{38.99,82.56},{34.39,81.38},{34.57,82.26},{35.08,84.43},{35.17,83.5}}},nil,405,nil,nil,132,nil,nil,0},
[4648] = {'Gelkis Stamper',1221,1279,33,34,0,{[405]={{37.0,85.7},{34.42,88.86},{38.3,94.52},{38.07,96.94},{36.16,91.55},{39.03,85.86},{38.68,93.36},{35.18,88.86},{40.64,92.24},{40.47,93.54},{39.78,95.23},{35.14,91.6},{39.04,89.38},{38.27,84.15},{38.49,90.84},{40.48,86.6},{35.6,82.16},{36.1,80.3},{37.36,80.21},{35.11,82.27},{38.11,82.21},{34.33,83.46}}},nil,405,nil,nil,132,nil,nil,0},
[4649] = {'Gelkis Windchaser',1021,1064,33,34,0,{[405]={{38.44,97.09},{36.49,87.07},{39.32,93.57},{35.23,89.93},{34.6,90.4},{39.23,94.33},{36.97,84.64},{39.15,95.97},{35.83,90.27},{40.39,93.05},{36.98,89.44},{38.42,95.61},{37.92,85.34},{38.69,91.98},{40.39,85.48},{40.45,84.48},{35.88,83.4},{36.06,82.21},{35.13,80.3},{36.86,80.13},{36.66,79.2},{37.4,81.38},{37.41,82.17},{34.4,85.49},{40.55,87.69},{40.28,83.51}}},nil,405,nil,nil,132,nil,nil,0},
[4651] = {'Gelkis Earthcaller',954,992,34,35,0,{[405]={{38.46,92.53},{37.55,90.32},{38.63,91.44},{40.96,87.51},{38.71,96.47},{36.6,88.54},{38.53,93.87},{39.13,87.44},{39.67,96.33},{40.11,92.58},{37.9,95.68},{37.42,80.95},{36.08,80.98},{36.43,82.38}}},nil,405,nil,nil,132,nil,nil,0},
[4652] = {'Gelkis Mauler',1403,1469,35,36,0,{[405]={{40.19,94.12},{40.07,95.81},{40.14,95.1},{40.54,95.62},{40.26,91.92},{38.78,95.67},{36.29,90.65}}},nil,405,nil,nil,132,nil,nil,0},
[4653] = {'Gelkis Marauder',1403,1469,35,36,0,{[405]={{34.8,91.09},{35.57,92.28},{38.94,93.83},{39.04,95.45},{40.55,95.35},{39.91,94.03}}},nil,405,nil,nil,132,nil,nil,0},
[4654] = {'Maraudine Scout',1536,1604,37,38,0,{[405]={{35.81,61.25},{31.25,66.18},{33.73,55.75},{31.48,54.56},{30.76,55.71},{30.69,53.4},{30.67,61.13},{35.95,59.05},{35.11,58.06},{32.98,65.87},{30.1,66.27}}},nil,405,nil,nil,134,nil,nil,0},
[4655] = {'Maraudine Wrangler',1468,1604,36,38,0,{[405]={{36.77,60.64},{35.28,61.41},{34.5,56.74},{34.52,55.61},{35.33,53.57},{33.61,54.43},{34.25,54.44},{31.65,60.16},{29.95,61.3},{39.71,61.41},{37.39,60.95},{30.02,68.93},{29.97,67.83},{30.78,65.42},{30.02,62.38}}},nil,405,nil,nil,134,nil,nil,0},
[4656] = {'Maraudine Mauler',1325,1386,38,39,0,{[405]={{31.42,51.16},{32.8,53.48},{34.2,53.16},{32.55,54.99},{32.17,55.5},{33.03,54.84},{29.35,52.07},{30.53,54.65},{30.23,57.83},{29.95,58.34},{29.8,57.68},{32.6,59.76},{31.46,58.91}}},nil,405,nil,nil,134,nil,nil,0},
[4657] = {'Maraudine Windchaser',1305,1357,38,39,0,{[405]={{29.51,60.62},{32.17,53.59},{33.35,54.94},{29.99,54.61},{29.05,53.66},{29.36,54.47},{30.71,56.84},{30.55,51.99},{29.69,58.11},{32.46,60.98},{30.77,58.84},{32.03,59.81},{31.29,61.01},{32.01,60.9}}},nil,405,nil,nil,134,nil,nil,0},
[4658] = {'Maraudine Stormer',1196,1239,39,40,0,{[405]={{30.53,50.62},{29.32,55.48},{29.07,50.68},{29.3,50.56}}},nil,405,nil,nil,134,nil,nil,0},
[4659] = {'Maraudine Marauder',1678,1753,39,40,0,{[405]={{28.77,60.84},{28.88,58.04}}},nil,405,nil,nil,134,nil,nil,0},
[4660] = {'Maraudine Bonepaw',1536,1604,37,38,0,nil,nil,0,nil,nil,134,nil,nil,0},
[4661] = {'Gelkis Rumbler',996,1051,29,30,0,nil,nil,0,nil,nil,132,nil,nil,0},
[4662] = {'Magram Bonepaw',1536,1604,37,38,0,{[405]={{70.4,73.25},{70.4,73.25},{65.41,77.33},{65.41,77.33},{72.36,78.18},{72.36,78.18}}},nil,405,nil,nil,133,nil,nil,0},
[4663] = {'Burning Blade Augur',811,847,30,31,0,{[405]={{52.54,29.98},{56.76,22.67},{55.28,22.4},{54.66,24.64},{56.69,22.08},{52.08,28.86},{56.88,24.57},{56.65,23.5},{56.99,22.93},{54.76,23.48},{56.11,22.27},{57.19,28.0},{55.95,27.4},{57.4,26.27},{53.26,29.86},{54.23,28.03},{54.04,27.86},{52.9,32.33},{53.09,32.23},{57.28,22.43},{55.28,29.88},{55.18,30.05},{56.77,30.0}}},nil,405,nil,nil,554,nil,nil,0},
[4664] = {'Burning Blade Reaver',1050,1107,30,31,0,{[405]={{52.29,28.22},{56.4,21.55},{56.86,25.66},{57.49,26.0},{57.7,26.3},{54.03,30.39},{52.36,32.5},{52.67,32.5},{52.76,32.26},{55.98,29.87},{56.09,29.16},{56.3,29.53},{55.14,28.62},{57.61,26.32}}},nil,405,nil,nil,554,nil,nil,0},
[4665] = {'Burning Blade Adept',847,882,31,32,0,{[405]={{52.26,29.7},{53.57,26.28},{52.91,27.21},{56.46,21.43},{52.8,28.19},{52.48,29.34},{52.34,28.87},{53.17,27.35},{57.49,28.69},{54.65,26.57},{55.46,26.15},{55.24,26.89},{54.99,27.13},{54.99,26.19},{56.05,31.14},{54.47,29.98},{56.14,31.45}}},nil,405,nil,nil,554,nil,nil,0},
[4666] = {'Burning Blade Felsworn',1107,1163,31,32,0,{[405]={{53.25,28.6},{55.35,21.32},{56.14,25.87},{55.81,25.17},{52.47,28.41},{54.2,26.46},{55.11,25.55},{53.01,29.61},{54.8,27.79},{53.88,29.36},{53.81,29.61},{53.29,28.52},{54.5,27.47},{55.31,27.63},{55.41,27.52},{55.7,26.86},{55.6,24.79},{55.98,28.26},{55.61,28.64},{55.41,30.04},{55.14,30.38},{55.38,30.12},{54.44,33.21}}},nil,405,nil,nil,554,nil,nil,0},
[4667] = {'Burning Blade Shadowmage',882,919,32,33,0,{[405]={{52.76,28.91},{55.24,26.72}}},{[405]={{{55.23,26.7},{55.09,27.0},{55.0,26.99},{54.79,26.87},{54.76,26.71},{54.79,26.39},{54.92,26.32},{55.12,26.44}}}},405,nil,nil,554,nil,nil,0},
[4668] = {'Burning Blade Summoner',1155,1196,38,39,0,{[405]={{80.3,76.98},{80.47,77.84},{80.68,76.34},{79.47,81.28},{82.12,80.66},{80.81,76.31},{81.91,80.42},{54.92,71.68},{51.5,81.89},{53.49,78.35},{53.14,80.22},{50.29,72.34},{49.59,77.24}}},nil,405,nil,nil,554,nil,nil,0},
[4669] = {'Burning Blade Conjuror',1469,1469,36,36,0,nil,nil,0,nil,nil,16,nil,nil,0},
[4670] = {'Hatefury Rogue',1107,1163,31,32,0,{[405]={{73.1,11.04},{73.53,9.04},{74.45,11.16},{76.7,14.89},{79.93,18.85},{73.6,25.46},{73.55,19.11},{74.55,22.27},{75.29,23.66},{75.96,22.45},{70.92,16.65},{72.26,16.98},{73.81,16.77},{78.19,21.21}}},nil,405,nil,nil,90,nil,nil,0},
[4671] = {'Hatefury Trickster',1107,1163,31,32,0,{[405]={{77.34,20.35},{78.18,16.91},{79.06,15.75},{73.69,12.16},{78.89,20.22},{78.21,18.9},{73.12,24.39},{73.67,23.61},{73.04,22.33},{76.63,18.87},{77.39,26.9},{71.54,17.92},{76.7,30.06},{78.94,24.57},{78.94,22.42}}},nil,405,nil,nil,90,nil,nil,0},
[4672] = {'Hatefury Felsworn',1107,1163,31,32,0,{[405]={{78.42,14.07},{74.49,13.4},{73.66,10.25},{77.64,15.49},{80.56,16.3},{73.14,20.28},{74.54,26.79},{74.73,19.86},{74.44,24.35},{71.52,20.12},{72.31,21.34},{76.76,16.79},{76.03,17.93},{75.29,19.28},{76.01,28.89},{75.11,28.03}}},nil,405,nil,nil,90,nil,nil,0},
[4673] = {'Hatefury Betrayer',1163,1221,32,33,0,{[405]={{77.63,17.94},{73.77,14.43},{74.8,11.66},{79.43,14.63},{71.12,14.99},{72.22,14.7},{80.53,17.75},{77.57,22.22},{76.86,21.06},{72.25,18.88},{73.53,21.56},{75.85,24.49},{72.83,16.81},{75.15,25.9},{78.13,25.77},{79.39,20.95}}},nil,405,nil,nil,90,nil,nil,0},
[4674] = {'Hatefury Shadowstalker',1163,1221,32,33,0,{[405]={{72.65,13.23},{79.37,16.22},{70.11,15.58},{79.27,15.85},{75.33,21.26},{77.0,18.05},{76.49,23.87},{76.47,23.63},{76.04,15.73},{76.68,27.91},{76.1,26.66},{77.58,24.69},{75.65,26.62},{79.26,21.25}}},nil,405,nil,nil,90,nil,nil,0},
[4675] = {'Hatefury Hellcaller',977,1021,32,33,0,{[405]={{78.93,17.97},{75.22,10.7},{75.0,12.21},{74.15,12.97},{75.13,16.35},{77.27,23.71},{79.67,16.64},{76.02,19.85},{72.28,19.19},{74.21,23.59},{74.39,23.61},{72.94,17.84},{74.53,21.79},{72.7,16.85},{74.57,15.73},{76.79,25.57},{78.11,23.03},{78.71,23.16}}},nil,405,nil,nil,90,nil,nil,0},
[4676] = {'Lesser Infernal',1469,1536,36,37,0,{[405]={{54.22,80.89},{53.77,82.28},{57.59,77.08},{49.36,77.96},{54.43,83.62},{53.59,79.84},{53.03,86.05},{54.58,73.57},{52.73,72.21},{50.46,73.68},{54.31,71.14},{56.8,71.13},{55.17,79.52},{51.45,75.61},{48.89,77.0},{50.83,70.2}}},nil,405,nil,nil,90,nil,nil,0},
[4677] = {'Doomwarder',1536,1536,37,37,0,{[405]={{54.93,77.69},{54.02,75.33},{50.96,77.58},{51.76,68.76}}},nil,405,nil,nil,90,nil,nil,0},
[4678] = {'Mana Eater',1257,1305,37,38,0,{[405]={{51.4,67.98},{52.91,68.14}}},nil,405,nil,nil,90,nil,nil,0},
[4679] = {'Nether Maiden',1257,1305,37,38,0,{[405]={{50.36,71.45},{48.66,77.88},{54.2,70.77},{49.97,73.2},{48.61,79.28},{50.58,76.89},{50.59,71.7},{50.35,77.12},{51.2,70.1}}},nil,405,nil,nil,90,nil,nil,0},
[4680] = {'Doomwarder Captain',1604,1604,38,38,0,{[405]={{51.61,84.32},{52.53,83.9},{50.93,83.24},{51.79,83.52},{51.44,81.84}}},nil,405,nil,nil,90,nil,nil,0},
[4681] = {'Mage Hunter',1305,1357,38,39,0,{[405]={{56.88,75.49},{56.49,72.97},{56.66,77.7},{58.26,75.54},{53.58,76.87},{55.74,77.7},{55.87,72.78},{53.3,79.18}}},nil,405,nil,nil,90,nil,nil,0},
[4682] = {'Nether Sister',1305,1357,38,39,0,{[405]={{52.59,85.14},{54.36,78.56},{54.15,78.22},{54.59,76.79}}},nil,405,nil,nil,90,nil,nil,0},
[4683] = {'Doomwarder Lord',1357,1410,39,40,0,nil,nil,0,nil,nil,90,nil,nil,0},
[4684] = {'Nether Sorceress',1196,1239,39,40,0,{[405]={{50.64,82.57},{52.36,83.36},{51.74,82.53},{51.85,84.68},{52.02,83.96}}},nil,405,nil,nil,90,nil,nil,0},
[4685] = {'Ley Hunter',1357,1409,39,40,0,{[405]={{79.16,81.51},{79.39,80.72},{81.65,76.08},{80.1,77.13},{79.44,76.92},{53.87,84.61},{51.56,85.71},{49.78,81.36}}},nil,405,nil,nil,90,nil,nil,0},
[4686] = {'Deepstrider Giant',4185,4377,38,39,1,{[405]={{66.26,32.79}}},{[405]={{{66.26,32.86},{66.17,33.07},{65.89,33.6},{65.79,34.05},{65.61,34.94},{65.52,35.39},{65.52,35.39},{65.38,36.3},{65.31,36.75},{65.25,37.21},{65.21,37.74},{65.23,38.21},{65.27,38.67},{65.27,38.67},{65.35,39.33},{65.53,39.71},{65.81,40.42},{65.92,40.86},{65.92,40.86},{66.02,41.3},{66.12,41.74},{66.27,42.29},{66.46,42.57},{66.73,42.72},{66.94,42.93},{66.94,42.93},{67.24,43.3},{67.45,43.65},{67.45,43.65},{67.71,44.13},{67.79,44.48},{67.84,45.41},{67.86,45.86},{67.99,46.6},{68.04,46.74},{68.15,47.01},{68.22,47.29},{68.34,47.96},{68.47,48.25},{68.53,48.52},{68.55,48.78},{68.63,49.42},{68.74,49.71},{68.89,49.91},{69.01,49.94},{69.19,49.84},{69.65,49.36},{69.85,49.0},{69.8,48.75},{69.38,48.28},{69.09,47.61},{69.22,46.95},{69.56,46.69},{69.81,45.97},{69.8,45.41},{69.81,44.43},{69.78,44.01},{69.76,43.79},{69.76,43.79},{69.71,43.33},{69.5,42.31},{69.42,42.16},{69.01,41.68},{68.73,41.48},{68.61,41.37},{68.22,40.81},{68.22,40.81},{67.99,40.51},{67.59,39.86},{67.31,39.15},{67.23,38.74},{67.2,38.28},{67.2,38.28},{67.18,37.81},{67.12,36.88},{67.06,36.34},{66.9,35.74},{66.72,35.36},{66.39,34.6},{66.27,34.07},{66.28,33.88},{66.5,33.56},{66.89,32.93},{66.89,32.93},{67.02,32.5},{67.2,31.89},{67.22,31.26},{67.1,30.82},{66.89,30.48},{66.81,30.38},{66.69,30.23},{66.41,30.02},{65.85,29.62},{65.34,29.28},{65.41,29.43},{65.63,29.76},{65.83,30.11},{66.05,30.56},{66.13,30.94},{66.18,31.4},{66.19,32.13},{66.25,32.52}}}},405,nil,nil,778,nil,nil,0},
[4687] = {'Deepstrider Searcher',4377,4572,39,40,1,{[405]={{32.07,24.66}}},{[405]={{{32.06,24.65},{32.25,24.72},{32.56,24.91},{32.71,24.98},{32.89,25.01},{33.25,25.11},{33.47,25.22},{33.73,25.52},{33.82,25.83},{33.87,26.07},{33.94,26.33},{34.13,26.71},{34.35,27.0},{34.55,27.13},{34.83,27.23},{35.03,27.27},{35.3,27.26},{35.5,27.1},{35.61,26.87},{35.82,26.36},{35.92,26.0},{35.97,25.48},{36.02,25.06},{36.1,24.81},{36.23,24.57},{36.49,24.1},{36.65,23.78},{36.74,23.42},{36.67,23.11},{36.59,22.93},{36.52,22.65},{36.56,22.42},{36.58,22.0},{36.39,21.78},{36.32,21.76},{36.0,21.8},{35.74,21.9},{35.6,21.99},{35.34,22.19},{35.21,22.34},{35.07,22.53},{34.78,22.95},{34.64,23.17},{34.51,23.38},{34.29,23.7},{34.16,23.85},{33.84,24.17},{33.6,24.38},{33.46,24.42},{33.21,24.44},{33.05,24.36},{32.78,24.41},{32.56,24.37},{32.18,24.22},{31.81,24.02},{31.46,23.71},{31.19,23.33},{31.11,22.96},{31.18,22.43},{31.22,22.17},{31.26,21.64},{31.25,21.39},{31.22,20.87},{31.21,20.33},{31.17,20.05},{31.13,19.62},{31.07,19.08},{30.73,18.76},{30.37,18.59},{30.05,18.46},{29.65,18.41},{29.5,18.43},{29.06,18.58},{28.92,18.69},{28.69,19.13},{28.79,19.4},{28.94,19.45},{29.28,19.43},{29.59,19.5},{29.75,19.53},{30.17,19.6},{30.42,19.71},{30.73,19.88},{30.95,20.18},{31.02,20.34},{31.14,20.7},{31.21,21.02},{31.27,21.41},{31.32,21.75},{31.33,22.16},{31.35,22.49},{31.35,22.86},{31.37,23.09},{31.48,23.64},{31.76,24.2},{31.9,24.4}}}},405,nil,nil,778,nil,nil,0},
[4688] = {'Bonepaw Hyena',444,488,33,35,0,{[405]={{36.83,72.12},{36.94,72.31},{36.85,72.25},{36.92,72.25},{36.9,72.17},{46.09,29.1},{47.04,29.72},{47.04,29.77},{47.09,29.84},{47.09,29.86},{53.84,38.97},{54.53,39.53},{54.51,39.4},{54.47,39.48},{54.46,39.36}}},nil,405,nil,nil,38,nil,nil,0},
[4689] = {'Starving Bonepaw',286,317,30,32,0,{[405]={{70.19,27.66},{70.11,27.22},{70.08,27.2},{70.11,27.04},{70.05,27.07},{56.22,15.63},{56.31,16.78},{56.23,16.73},{56.18,16.75},{56.23,16.8}}},nil,405,nil,nil,38,nil,nil,0},
[4690] = {'Rabid Bonepaw',511,558,36,38,0,{[405]={{53.84,45.38},{53.74,45.29},{53.7,45.31},{53.75,45.43},{39.96,41.92},{39.92,41.74},{39.86,41.64},{39.89,41.57},{39.86,41.53},{53.63,45.47}}},nil,405,nil,nil,38,nil,nil,0},
[4691] = {'Murderous Bonepaw',1163,1221,32,33,0,nil,nil,0,nil,nil,38,nil,nil,0},
[4692] = {'Dread Swoop',1163,1221,32,33,0,{[405]={{69.69,20.54},{38.24,33.52},{48.99,29.98},{45.58,38.95},{74.0,55.59},{74.53,57.97},{59.93,13.37},{50.29,26.41},{65.48,54.37},{36.74,73.49},{70.36,63.42},{73.28,35.88},{44.28,18.63},{51.29,23.3},{46.97,38.83},{35.67,74.52},{69.41,54.48},{72.17,55.06},{44.23,22.89},{46.64,27.81},{47.01,30.65},{48.33,66.38},{59.77,24.32},{47.02,32.98},{71.82,56.76},{69.24,54.08},{50.04,37.82},{44.61,24.97},{53.7,23.44},{48.76,39.94},{44.13,73.44},{69.37,66.15},{43.39,69.76},{68.46,60.36},{67.1,62.75},{61.29,34.6},{48.19,31.27},{52.78,21.98},{44.88,16.87},{42.96,71.08},{68.13,60.86},{69.15,58.11},{48.71,27.86},{44.26,37.81},{49.61,34.08},{48.39,27.84},{69.08,62.22},{70.14,56.42},{74.02,64.69},{68.11,59.55},{80.6,35.72},{70.27,35.75},{51.42,35.39},{45.95,34.27},{47.8,41.05},{71.67,59.36},{73.88,60.18},{47.64,29.24},{38.52,75.67},{58.92,28.95},{65.38,27.75},{71.53,27.87},{76.15,33.4},{69.5,20.37},{47.25,32.29},{46.65,14.68},{55.72,18.45},{50.01,7.76},{56.73,18.82},{66.75,60.17},{68.83,68.15},{65.66,58.46},{65.64,20.17},{52.09,24.35},{50.14,32.2},{44.88,31.28},{57.41,34.61},{71.85,58.24},{71.2,62.17},{71.52,65.35},{72.85,62.1},{70.22,41.23},{61.09,18.48},{67.13,53.29},{57.37,12.36},{54.48,66.78},{74.62,56.83},{41.91,65.4},{67.11,53.71},{56.04,64.79},{64.79,65.55},{75.04,34.44},{61.95,16.78},{45.5,31.24},{43.36,29.6},{56.51,41.12},{71.02,64.11},{67.93,71.61}}},nil,405,nil,nil,73,nil,nil,0},
[4693] = {'Dread Flyer',1469,1536,36,37,0,{[405]={{40.22,50.97},{43.86,52.41},{44.11,55.86},{41.66,48.48},{41.87,42.04},{40.48,43.16},{62.7,51.98},{43.49,46.8},{62.84,48.53},{45.01,46.91},{61.92,44.57},{41.7,45.83},{42.75,40.94},{63.96,45.64},{44.06,54.5},{39.17,39.21},{45.41,48.08},{35.78,38.78},{41.7,50.32},{73.76,11.2},{42.45,56.94},{61.26,54.35},{59.72,49.64},{63.92,46.96},{42.31,53.61},{41.27,38.88},{42.8,47.69},{51.26,45.17},{55.38,46.59},{63.42,60.35},{42.17,44.69},{55.43,49.14},{58.46,50.95},{58.38,47.34},{59.74,45.58},{61.07,51.21},{44.06,59.2},{53.57,49.29},{60.15,51.28},{63.07,57.35},{40.5,37.41},{61.0,47.92},{57.47,51.09},{57.88,53.11},{62.61,55.14},{61.93,58.88},{58.86,48.23},{58.22,50.16},{60.49,56.37}}},nil,405,nil,nil,73,nil,nil,0},
[4694] = {'Dread Ripper',1678,1753,39,40,0,{[405]={{62.31,79.77},{59.62,79.12},{62.72,71.01},{59.55,75.6},{61.18,77.88},{55.16,85.67},{61.17,74.45},{62.5,75.93},{29.81,81.17},{57.39,85.66}}},nil,405,nil,nil,73,nil,nil,0},
[4695] = {'Carrion Horror',1403,1536,35,37,0,{[405]={{50.24,56.57},{51.5,59.35},{50.8,60.23},{51.66,60.52},{49.25,57.37},{49.05,59.43},{53.41,60.28},{53.01,60.46},{47.96,57.68},{53.63,63.65},{50.67,58.4},{51.46,57.67},{50.03,58.9},{53.31,58.78},{49.21,59.99}}},nil,405,nil,nil,73,nil,nil,0},
[4696] = {'Scorpashi Snapper',1050,1107,30,31,0,{[405]={{70.38,21.32},{65.68,26.83},{66.33,25.65},{70.82,29.2},{79.76,36.11},{72.83,32.53},{54.32,22.04},{75.28,33.5},{70.51,26.7},{66.32,22.25},{65.46,27.9},{72.43,26.62},{64.14,24.9},{54.24,18.76},{67.15,19.12},{57.34,11.6},{73.91,31.35},{67.84,25.63},{63.01,31.15},{73.48,33.2},{71.12,33.22},{71.87,29.89},{71.55,33.18},{71.84,28.06},{78.31,32.89},{70.83,23.93},{68.63,33.48},{71.13,34.37},{55.75,14.86},{59.86,33.48},{64.07,20.09},{63.6,37.61},{65.48,29.19},{63.5,34.98},{76.8,35.76},{52.32,8.13},{74.38,30.19},{61.22,26.76},{78.21,35.56},{52.21,11.26},{54.41,13.85},{72.65,30.01},{68.83,31.83},{80.45,36.67},{65.5,35.65},{58.43,11.67},{68.61,34.79},{50.25,6.15},{76.01,34.68},{66.88,25.82},{64.41,22.36},{62.51,14.73},{63.28,33.18},{59.45,64.24},{61.04,29.73},{54.62,6.85},{69.94,25.69},{50.81,7.77},{68.73,22.21},{71.14,36.6},{58.36,8.93},{57.66,19.4},{64.05,63.8},{56.0,64.65},{53.15,68.88},{63.46,17.85},{62.64,16.88},{69.38,17.95},{58.88,26.9}}},nil,405,nil,nil,413,nil,nil,0},
[4697] = {'Scorpashi Lasher',1279,1342,34,35,0,{[405]={{64.12,57.68},{71.41,59.26},{60.83,54.52},{44.12,45.51},{38.05,74.54},{70.51,58.25},{42.91,72.25},{65.94,56.56},{71.64,55.87},{45.46,73.65},{68.84,59.09},{41.8,57.33},{62.72,48.33},{45.24,47.94},{40.39,40.83},{70.25,61.86},{77.59,44.04},{42.68,50.14},{71.62,64.62},{57.1,48.48},{55.48,45.7},{58.94,54.69},{58.51,54.37},{36.91,73.11},{73.27,58.77},{67.8,68.02}}},nil,405,nil,nil,413,nil,nil,0},
[4699] = {'Scorpashi Venomlash',1604,1678,38,39,0,{[405]={{58.93,72.12},{45.67,86.93},{61.14,79.28},{28.56,81.89},{55.28,83.25},{50.69,92.39},{63.93,71.54},{55.29,86.33},{48.45,91.28},{62.12,75.61},{62.69,69.81},{47.42,86.84},{56.95,86.73},{61.13,73.25},{29.27,82.72}}},nil,405,nil,nil,413,nil,nil,0},
[4700] = {'Aged Kodo',1570,1647,34,35,0,{[405]={{52.61,57.46},{50.51,56.63},{48.29,60.25},{52.24,60.64},{50.82,61.17},{53.65,56.69},{51.95,56.1},{58.03,34.84},{58.63,34.44},{58.93,34.32},{44.87,18.84},{44.92,19.65},{44.82,19.81},{49.36,41.23},{49.37,40.48},{49.37,40.17},{57.76,71.05},{56.74,82.06},{56.79,82.99},{56.94,82.97}}},nil,405,nil,nil,15,"AH",nil,0},
[4701] = {'Dying Kodo',1647,1723,35,36,0,{[405]={{51.47,59.16},{47.0,58.86},{48.52,56.9},{53.65,58.03},{49.13,55.62},{49.57,58.32},{46.48,60.66},{50.3,58.31},{54.97,58.23},{54.27,63.24},{58.42,34.24},{55.68,62.65},{45.14,18.46},{49.49,40.82},{56.75,83.18}}},nil,405,nil,nil,15,"AH",nil,0},
[4702] = {'Ancient Kodo',1723,1803,36,37,0,{[405]={{51.41,58.29},{49.45,59.73},{52.42,62.2},{53.94,60.99}}},nil,405,nil,nil,15,"AH",nil,0},
[4703] = {'Raging Kodo',1670,1824,37,39,0,nil,nil,0,nil,nil,14,nil,nil,0},
[4704] = {'Maraudine Pack Runner',1337,1337,34,34,0,nil,nil,0,nil,nil,134,nil,nil,0},
[4705] = {'Burning Blade Invoker',1196,1239,39,40,0,{[405]={{82.47,80.99},{80.01,77.87},{81.02,76.67},{79.61,78.81},{79.97,78.96},{81.03,76.63}}},nil,405,nil,nil,554,nil,nil,0},
[4706] = {'Razzeric',1002,1002,30,30,0,{[400]={{80.33,76.09}}},nil,400,{1187,1188},{1186,1187,1189},35,"AH",nil,2},
[4707] = {'Zuzubee',1342,1342,35,35,0,{[400]={{80.95,77.94}}},nil,400,nil,nil,35,"AH","Race Announcer",0},
[4708] = {'Shreev',1677,1677,39,39,0,{[440]={{50.96,27.24}}},nil,440,{1189},{1188},474,"AH",nil,2},
[4709] = {'Zamek',1002,1002,30,30,0,{[400]={{79.81,77.03}}},{[400]={{{79.05,77.4},{78.32,78.09},{77.67,78.44},{77.57,78.39},{77.67,78.44},{78.32,78.09},{79.05,77.4},{79.81,77.03}}}},400,{1191},{1191},35,"AH",nil,2},
[4710] = {'Riding Ram (Gray)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4711] = {'Slitherblade Naga',1163,1221,32,33,0,{[405]={{32.74,23.92},{37.0,21.91},{35.4,22.01},{41.61,18.78},{41.78,20.03},{36.25,23.14},{36.69,24.24},{38.88,21.4},{36.85,24.4},{36.48,20.4},{38.46,23.68},{35.97,27.06},{35.29,26.63},{35.79,23.8},{35.16,27.79},{38.13,21.25},{36.72,21.31}}},nil,405,nil,nil,74,nil,nil,0},
[4712] = {'Slitherblade Sorceress',882,919,32,33,0,{[405]={{31.57,17.02},{36.05,24.78},{35.91,28.84},{32.94,23.32},{31.42,22.13},{27.77,6.7},{38.97,20.12}}},nil,405,nil,nil,74,nil,nil,0},
[4713] = {'Slitherblade Warrior',1221,1279,33,34,0,{[405]={{33.04,15.03},{33.85,13.62},{32.26,24.37},{32.22,19.85},{32.12,21.47},{34.55,23.24},{34.59,22.4},{34.48,25.64},{34.48,21.38},{36.93,26.25},{27.86,5.75}}},nil,405,nil,nil,74,nil,nil,0},
[4714] = {'Slitherblade Myrmidon',1279,1342,34,35,0,{[405]={{32.74,14.68},{33.89,7.72},{32.9,5.99},{34.58,17.63},{33.03,9.44},{31.97,18.97},{34.43,14.81},{29.2,13.31},{29.93,16.55},{32.2,6.6},{28.51,7.77},{30.87,19.2},{27.03,10.25},{31.41,17.67},{32.53,22.47},{32.18,23.38},{31.74,23.07},{33.75,22.38},{29.96,12.2},{30.01,6.77}}},nil,405,nil,nil,74,nil,nil,0},
[4715] = {'Slitherblade Razortail',1403,1469,35,36,0,{[405]={{30.65,15.78},{29.2,7.94},{30.75,8.93},{30.24,8.83},{28.55,10.16}}},nil,405,nil,nil,74,nil,nil,0},
[4716] = {'Slitherblade Tidehunter',1208,1257,36,37,0,{[405]={{33.99,8.72},{33.23,10.51},{29.94,15.94},{29.99,7.8},{28.58,11.06},{28.52,9.01}}},nil,405,nil,nil,74,nil,nil,0},
[4717] = {'Slitherblade Tide Priestess',1021,1064,33,34,0,nil,nil,0,nil,nil,74,nil,nil,0},
[4718] = {'Slitherblade Oracle',1064,1110,34,35,0,{[405]={{33.89,10.15},{32.97,22.12},{31.57,15.6},{28.58,6.61},{27.69,7.92}}},nil,405,nil,nil,74,nil,nil,0},
[4719] = {'Slitherblade Sea Witch',1160,1208,35,36,0,{[405]={{34.36,8.07},{34.97,16.77},{34.53,9.92},{28.66,12.5},{30.54,16.4},{29.16,11.34},{30.93,9.77},{29.15,9.03},{27.66,12.58},{30.7,10.98},{29.96,11.15},{27.73,9.09},{27.79,10.14},{30.8,7.92}}},nil,405,nil,nil,74,nil,nil,0},
[4720] = {'Rizzle Brassbolts',1002,1002,30,30,0,{[400]={{77.22,77.4}}},{[400]={{{77.56,77.62},{77.59,77.86},{77.73,78.01},{77.69,78.26},{77.57,78.39},{77.69,78.26},{77.73,78.01},{77.59,77.86},{77.56,77.62},{77.22,77.4}}}},400,nil,nil,35,"AH",nil,0},
[4721] = {'Zangen Stonehoof',712,712,25,25,0,{[1638]={{54.97,51.41}}},nil,1638,{1195,1196},{1195},104,"H",nil,2},
[4722] = {'Rau Cliffrunner',1002,1002,30,30,0,{[400]={{46.14,51.71}}},nil,400,{1197},{1196,1197},104,"H",nil,2},
[4723] = {'Foreman Cozzle',1305,1305,38,38,0,{[33]={{42.64,18.35}}},nil,33,nil,nil,47,nil,nil,0},
[4724] = {'Sandstrider',1051,1107,30,31,0,nil,nil,0,nil,nil,189,"AH",nil,0},
[4725] = {'Crazed Sandstrider',1536,1678,37,39,0,nil,nil,0,nil,nil,16,nil,nil,0},
[4726] = {'Raging Thunder Lizard',1221,1279,33,34,0,{[405]={{44.77,29.39},{39.21,33.53},{38.9,77.08},{41.23,67.92},{45.09,28.4},{45.75,22.66},{47.84,34.41},{74.36,54.74},{68.16,57.6},{37.24,74.63},{46.33,39.68},{71.12,55.79},{70.66,57.88},{48.31,35.37},{49.25,41.52},{71.38,60.35},{52.83,24.39},{49.73,30.96},{41.4,24.59},{71.94,54.83},{43.29,73.53},{72.46,65.06},{46.78,35.58},{45.33,28.97},{51.26,25.63},{69.25,59.67},{74.67,59.02},{46.28,15.77},{44.66,36.71},{48.63,27.69},{42.52,68.62},{66.24,54.92},{69.27,65.64},{49.93,29.49},{38.16,35.51},{47.05,28.37},{61.68,41.33},{44.6,17.63},{68.09,56.85},{50.66,40.16},{47.19,21.86},{66.19,61.33},{42.58,34.94},{49.3,38.95},{48.97,32.92},{70.28,59.04},{75.59,56.62},{65.6,52.81},{49.98,32.58},{55.95,39.97},{68.5,54.23},{66.02,70.64},{43.37,71.38},{58.17,41.14},{57.69,40.24},{37.42,34.98},{50.74,39.68},{44.85,23.48},{55.3,38.27},{43.42,31.19},{70.22,60.3},{66.19,57.92},{72.63,54.95},{72.1,62.48},{71.66,62.74},{73.88,63.27},{65.43,60.64},{69.87,68.72},{59.17,34.82},{55.89,32.86},{41.31,25.62},{66.92,69.8},{42.3,75.74},{42.44,31.79},{43.69,28.08},{49.16,25.92},{38.94,80.12}}},nil,405,nil,nil,14,nil,nil,0},
[4727] = {'Elder Thunder Lizard',1536,1604,37,38,0,{[405]={{51.78,93.28},{43.52,85.51},{41.7,48.68},{60.27,75.56},{55.27,87.96},{51.11,87.79},{54.12,85.87},{44.56,87.99},{61.74,73.66},{58.95,52.1},{62.59,71.81},{77.54,52.83},{43.34,45.77},{62.44,76.37},{50.8,90.18},{53.3,86.89},{60.46,80.61},{60.76,78.02},{52.34,92.24},{63.38,73.75},{73.73,11.08},{43.32,60.15},{41.97,43.36},{43.39,54.5},{61.17,73.51},{56.44,85.7},{62.85,52.34},{50.76,48.11},{52.15,49.78},{43.62,83.41},{57.38,83.66},{62.64,75.48},{31.55,79.18},{30.48,72.61},{28.42,83.88},{61.82,45.51},{61.22,58.69},{31.62,77.85},{57.94,45.63},{59.89,47.77}}},nil,405,nil,nil,14,nil,nil,0},
[4728] = {'Gritjaw Basilisk',1107,1163,31,32,0,{[405]={{69.35,18.69},{62.11,35.19},{52.28,37.79},{65.64,29.45},{50.83,6.62},{61.66,25.27},{72.32,28.87},{79.17,33.96},{58.12,10.1},{48.27,38.34},{44.6,22.21},{55.17,14.57},{71.25,22.74},{61.86,15.77},{67.05,40.15},{62.2,36.71},{67.72,23.28},{61.86,24.9},{64.04,33.5},{72.44,35.81},{49.19,26.17},{62.69,34.47},{80.91,35.58},{70.82,32.31},{67.31,29.67},{66.25,31.49},{77.37,35.52},{61.14,23.46},{45.36,30.97},{38.68,33.89},{76.08,32.95},{65.67,42.6},{69.04,35.93},{49.37,32.85},{72.38,34.42},{68.77,23.14},{69.1,21.89},{60.48,31.06},{74.5,29.04},{73.79,34.42},{71.15,31.44},{77.54,36.85},{77.37,33.34},{68.61,20.23},{52.06,10.69},{72.3,31.09},{71.85,25.64},{72.83,35.36},{49.22,7.84},{58.27,20.37},{65.63,26.85},{79.04,36.88},{67.03,27.3},{64.21,18.93},{50.87,40.68},{75.28,36.19},{69.96,31.25},{70.61,36.89},{69.76,29.98},{53.51,20.54},{61.84,21.84},{64.64,42.39},{56.9,17.29},{70.01,27.03},{65.88,18.41},{58.14,8.54},{69.36,26.81},{57.35,9.3},{65.84,20.2},{67.15,21.92},{56.96,9.83},{63.37,39.07},{60.89,13.01},{58.33,63.31},{58.12,40.09},{53.02,8.85},{43.3,29.14}}},nil,405,nil,nil,49,nil,nil,0},
[4729] = {'Hulking Gritjaw Basilisk',1464,1532,35,36,0,{[405]={{42.73,49.29},{42.51,51.37},{61.92,45.47},{42.26,55.11},{43.09,57.47},{42.93,55.55},{42.53,44.75},{41.64,43.43},{40.33,46.37},{62.19,47.16},{44.26,47.84},{45.93,63.57},{63.15,48.1},{41.73,64.18},{37.55,39.27},{45.47,45.89},{40.3,39.56},{40.4,45.61},{41.37,51.22},{76.38,54.66},{77.65,43.34},{43.17,63.59},{76.94,52.16},{76.7,44.49},{42.02,58.04},{41.76,39.96},{46.53,45.37},{78.01,52.09},{62.5,44.43},{44.47,48.48},{62.07,47.81},{47.42,44.76},{41.06,48.33},{42.43,44.38},{52.93,44.54},{51.96,47.96},{50.46,46.55},{51.73,49.07},{52.62,49.12},{54.63,48.86},{57.98,52.35},{54.66,45.57},{55.98,47.86},{55.78,49.82},{60.45,52.17},{63.33,50.1},{62.77,59.9},{58.21,48.82},{47.06,50.58},{57.32,48.94},{58.4,47.01},{61.07,55.55},{42.92,59.7},{43.39,53.42},{44.84,51.43},{55.88,45.7},{56.79,46.85}}},nil,405,nil,nil,49,nil,nil,0},
[4730] = {'Lelanai',1342,1342,35,35,0,{[1657]={{38.28,15.36}}},nil,1657,{7671,7672},{7671,7672},80,"A","Saber Handler",135},
[4731] = {'Zachariah Post',1002,1002,30,30,0,{[85]={{59.87,52.68}}},nil,85,nil,nil,68,"H","Undead Horse Merchant",133},
[4732] = {'Randal Hunter',198,198,10,10,0,{[12]={{84.32,64.87}}},nil,12,nil,nil,12,"A","Horse Riding Instructor",17},
[4752] = {'Kildar',2768,2768,50,50,0,{[1637]={{69.41,13.1}}},nil,1637,nil,nil,29,"H","Wolf Riding Instructor",17},
[4753] = {'Jartsam',2217,2217,45,45,0,{[1657]={{38.69,15.84}}},nil,1657,nil,nil,80,"A","Nightsaber Riding Instructor",17},
[4772] = {'Ultham Ironhorn',198,198,10,10,0,{[1]={{63.94,50.1},{63.67,50.14}}},nil,1,nil,nil,55,"A","Ram Riding Instructor",17},
[4773] = {'Velma Warnam',1002,1002,30,30,0,{[85]={{60.08,52.57}}},nil,85,nil,nil,68,"H","Undead Horse Riding Instructor",17},
[4775] = {'Felicia Doan',1002,1002,30,30,0,{[1497]={{64.13,50.56}}},nil,1497,nil,nil,68,"H","General Trade Goods Vendor",6},
[4777] = {'Riding Ram (White)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4778] = {'Riding Ram (Blue)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4779] = {'Riding Ram (Brown)',42,55,1,2,0,{[618]={{60.45,37.85}}},nil,618,nil,nil,35,"AH",nil,0},
[4780] = {'Riding Ram (Black)',42,42,1,1,0,nil,nil,0,nil,nil,35,"AH",nil,0},
[4781] = {'Snufflenose Gopher',42,42,1,1,0,nil,nil,0,nil,nil,32,"AH",nil,0},
[4782] = {'Truk Wildbeard',2768,2768,50,50,0,{[47]={{14.36,42.31}}},nil,47,nil,nil,694,"A","Bartender",6},
[4783] = {'Dawnwatcher Selgorm',712,712,25,25,0,{[1657]={{56.16,24.39}}},nil,1657,nil,{1200},814,"AH","The Argent Dawn",2},
[4784] = {'Argent Guard Manados',617,617,23,23,0,{[1657]={{55.24,23.99}}},nil,1657,{1199},{1199},814,"AH","The Argent Dawn",2},
[4785] = {'Illusionary Nightmare',950,1002,29,30,0,nil,nil,0,nil,nil,32,"AH",nil,0},
[4786] = {'Dawnwatcher Shaedlass',573,573,22,22,0,{[1657]={{55.36,25.03}}},nil,1657,{1198},nil,814,"AH","The Argent Dawn",2},
[4787] = {'Argent Guard Thaelrid',417,417,18,18,0,{[719]={{-1,-1}}},nil,719,{1200,6561},{1198},794,"AH","The Argent Dawn",2},
[4788] = {'Fallenroot Satyr',1452,1563,20,21,1,{[331]={{13.52,12.22},{13.28,12.62},{13.87,10.61},{13.78,11.67}},[148]={{30.86,92.72},{31.19,92.59},{31.17,93.56}}},nil,331,nil,nil,128,nil,nil,0},
[4789] = {'Fallenroot Rogue',1563,1686,21,22,1,{[148]={{33.96,94.43},{33.16,94.07},{32.07,93.08},{32.41,93.26},{30.94,91.83},{31.92,92.8}}},nil,148,nil,nil,128,nil,nil,0},
[4791] = {'Nazeer Bloodpike',2577,2577,48,48,0,{[15]={{35.21,30.66}}},nil,15,{1201,1202,1240,1262},{1201,1202,1238,1239,1261},125,"H",nil,2},
[4792] = {'"Swamp Eye" Jarl',1981,1981,42,42,0,{[15]={{55.44,26.27}}},nil,15,{1203,1206,1218},{1203,1206,1218},35,"AH",nil,2},
[4794] = {'Morgan Stern',1468,1468,36,36,0,{[15]={{66.34,45.47}}},nil,15,{1204,1258},{1204,1222,1258,1260},894,"A",nil,2},
[4795] = {'Force of Nature',356,386,16,17,0,nil,nil,0,nil,nil,84,"A",nil,0},
[4798] = {'Fallenroot Shadowstalker',1599,1713,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4799] = {'Fallenroot Hellcaller',1713,1830,24,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4802] = {'Blackfathom Tide Priestess',1299,1392,20,21,1,{[148]={{30.45,92.07},{31.49,91.59},{32.76,93.79},{31.31,93.58},{30.99,92.15},{31.38,91.38},{31.47,91.56}},[331]={{13.04,13.12},{13.37,12.07},{13.55,12.06},{13.25,13.21}}},nil,148,nil,nil,128,nil,nil,0},
[4803] = {'Blackfathom Oracle',1392,1494,21,22,1,{[148]={{30.2,92.72},{30.0,92.63},{30.6,92.11},{31.37,91.37},{31.72,91.65},{31.85,91.44},{34.75,93.38},{33.55,94.39},{33.88,93.68},{33.72,93.32},{33.55,94.19},{33.78,94.35},{32.82,93.87},{31.72,92.14},{32.35,93.65},{31.21,91.93},{31.31,91.88},{31.8,92.44},{34.74,93.4},{34.52,93.58},{31.86,91.48},{30.92,91.87}}},nil,148,nil,nil,128,nil,nil,0},
[4805] = {'Blackfathom Sea Witch',1599,1713,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4807] = {'Blackfathom Myrmidon',2529,2723,22,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4809] = {'Twilight Acolyte',1713,1830,24,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4810] = {'Twilight Reaver',2097,2250,25,26,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4811] = {'Twilight Aquamancer',1830,1953,25,26,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4812] = {'Twilight Loreseeker',1713,1830,24,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4813] = {'Twilight Shadowmage',1794,1899,26,27,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4814] = {'Twilight Elementalist',1794,1899,26,27,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4815] = {'Murkshallow Snapclaw',1686,1815,22,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,129,nil,nil,0},
[4816] = {'Murkshallow Shellhide',1815,1953,23,24,1,nil,nil,0,nil,nil,129,nil,nil,0},
[4818] = {'Blindlight Murloc',1686,1815,22,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,18,nil,nil,0},
[4819] = {'Blindlight Muckdweller',2097,2097,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,18,nil,nil,0},
[4820] = {'Blindlight Oracle',1830,1830,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,18,nil,nil,0},
[4821] = {'Skittering Crustacean',1686,1815,22,23,1,{[719]={{-1,-1}}},nil,719,nil,nil,350,nil,nil,0},
[4822] = {'Snapping Crustacean',1815,1953,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,350,nil,nil,0},
[4823] = {'Barbed Crustacean',1608,1725,25,26,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4824] = {'Aku\'mai Fisher',1815,1953,23,24,1,{[719]={{-1,-1}}},nil,719,nil,nil,350,nil,nil,0},
[4825] = {'Aku\'mai Snapjaw',2250,2400,26,27,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4827] = {'Deep Pool Threshfin',1953,2097,24,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,16,nil,nil,0},
[4829] = {'Aku\'mai',8530,8530,28,28,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4830] = {'Old Serra\'kis',3750,3750,26,26,1,{[719]={{-1,-1}}},nil,719,nil,nil,16,nil,nil,0},
[4831] = {'Lady Sarevess',4880,4880,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4832] = {'Twilight Lord Kelris',5520,5520,27,27,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4834] = {'Theramore Infiltrator',1403,1468,35,36,0,{[15]={{40.94,25.52},{38.95,26.4},{40.65,35.32},{38.04,37.41},{38.05,33.94},{42.12,26.03},{41.65,25.21},{41.73,26.62},{40.58,33.4},{44.04,27.29},{38.05,23.59},{38.05,25.56},{38.94,22.42},{39.62,23.88},{37.56,27.02},{38.97,21.67}}},nil,15,nil,nil,149,"A",nil,0},
[4841] = {'Deadmire',2217,2217,45,45,0,{[15]={{48.81,56.75}}},nil,15,nil,nil,16,nil,nil,0},
[4842] = {'Earthcaller Halmgar',3108,3108,32,32,2,{[491]={{-1,-1}}},nil,491,nil,nil,152,nil,nil,0},
[4844] = {'Shadowforge Surveyor',2706,2805,35,36,1,{[38]={{38.74,92.39},{38.39,91.7},{38.78,93.92},{35.42,88.59},{34.24,89.57},{39.1,90.39},{39.64,90.77},{37.92,87.53},{38.32,86.62},{38.01,86.73},{38.86,86.24},{34.82,90.67},{38.83,88.35},{34.33,88.11},{35.53,87.13}},[3]={{44.38,9.91},{43.86,10.74},{45.6,8.62},{46.36,8.07},{43.94,10.37},{46.67,11.17},{47.54,9.59},{47.09,13.13},{45.76,11.78},{46.4,12.68},{45.97,10.06},{44.79,11.48},{44.97,12.44},{45.03,10.6},{46.26,8.43}}},nil,38,nil,nil,54,nil,nil,0},
[4845] = {'Shadowforge Ruffian',3831,4008,36,37,1,{[38]={{40.09,90.33},{38.02,93.74},{37.97,93.03},{38.62,94.29},{35.55,87.99},{39.65,89.93},{34.32,88.8},{37.87,87.76},{39.47,86.03},{35.02,89.41},{35.41,90.99},{35.01,90.65},{39.21,86.75},{36.78,86.24},{36.52,88.68},{35.91,87.58},{34.26,87.64}},[3]={{39.77,18.85},{42.4,10.44},{42.26,11.25}}},nil,38,nil,nil,54,nil,nil,0},
[4846] = {'Shadowforge Digger',3660,3831,35,36,1,{[38]={{39.86,89.84},{39.08,92.26},{38.81,92.09},{38.11,94.24},{38.24,94.44},{38.02,91.52},{38.34,92.94},{38.31,93.31},{37.81,90.27},{38.08,90.26},{38.67,90.44},{38.03,91.12},{38.38,88.59},{38.07,88.23},{36.24,88.67},{35.68,89.3},{36.83,88.96},{37.1,88.37},{37.21,88.61},{37.57,88.79},{37.69,89.08},{36.14,90.59},{39.45,88.33},{40.08,87.83},{39.61,87.29},{38.85,87.38},{38.48,86.55},{38.09,86.44},{37.37,87.28}},[3]={{41.06,15.34},{44.8,8.94},{44.24,9.55},{44.69,9.07},{45.29,8.43},{45.29,9.93},{47.03,10.93},{48.23,11.01},{46.51,11.61},{47.94,10.1},{46.75,10.34},{42.98,10.37},{43.62,11.53},{43.49,12.18},{42.21,12.07},{41.06,11.38}}},nil,38,nil,nil,54,nil,nil,0},
[4847] = {'Shadowforge Relic Hunter',3540,3678,39,40,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,54,nil,nil,0},
[4848] = {'Shadowforge Darkcaster',4119,4278,43,44,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,54,nil,nil,0},
[4849] = {'Shadowforge Archaeologist',5148,5346,43,44,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,54,nil,nil,0},
[4850] = {'Stonevault Cave Lurker',4008,4377,37,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4851] = {'Stonevault Rockchewer',3831,4008,36,37,1,{[38]={{32.36,90.47},{33.35,92.32},{33.45,92.63},{34.05,91.79},{37.22,90.9},{37.3,91.78},{37.46,91.96},{36.71,92.07},{36.62,91.28},{34.97,93.95},{35.02,96.47},{34.81,95.46},{34.15,95.75},{34.15,96.54},{36.47,92.36}},[3]={{35.43,23.13}},[1337]={{-1,-1}}},nil,38,nil,nil,59,nil,nil,0},
[4852] = {'Stonevault Oracle',3279,3405,37,38,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4853] = {'Stonevault Geomancer',4119,4278,43,44,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4854] = {'Grimlok',7390,7390,45,45,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,"Stonevault Chieftain",0},
[4855] = {'Stonevault Brawler',5148,5346,43,44,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,59,nil,nil,0},
[4856] = {'Stonevault Cave Hunter',3831,4008,36,37,1,{[38]={{33.29,89.46},{33.0,88.93},{32.57,89.49},{33.32,91.41},{36.89,92.82},{36.26,92.66},{36.18,91.51},{35.18,93.01},{35.27,95.87},{34.57,96.61},{33.67,95.98},{32.2,90.21},{33.15,91.69},{33.8,91.71},{34.79,93.32},{37.06,92.56}},[3]={{35.96,23.06}}},nil,38,nil,nil,59,nil,nil,0},
[4857] = {'Stone Keeper',5757,5757,46,46,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,470,nil,nil,0},
[4860] = {'Stone Steward',5148,5346,43,44,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,415,nil,nil,0},
[4861] = {'Shrike Bat',4185,4377,38,39,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,411,nil,nil,0},
[4862] = {'Rabid Shrike Bat',4185,4377,38,39,1,nil,nil,0,nil,nil,411,nil,nil,0},
[4863] = {'Jadespine Basilisk',4377,4572,39,40,1,{[1337]={{-1,-1}}},nil,1337,nil,nil,49,nil,nil,0},
[4872] = {'Obsidian Golem',4185,4185,38,38,1,{[38]={{38.84,94.25},{37.88,93.26},{39.76,90.64}}},nil,38,nil,nil,54,nil,nil,0},
[4875] = {'Turhaw',1752,1752,40,40,0,{[400]={{45.44,51.17}}},nil,400,nil,nil,29,"H","Butcher",6},
[4876] = {'Jawn Highmesa',1342,1342,35,35,0,{[400]={{45.91,51.48}}},nil,400,nil,nil,104,"H","General Goods",6},
[4877] = {'Jandia',1536,1536,37,37,0,{[400]={{46.21,51.51}}},nil,400,nil,nil,104,"H","Trade Supplies",6},
[4878] = {'Montarr',1468,1468,36,36,0,{[400]={{45.15,50.79}}},nil,400,nil,nil,104,"H","Lorekeeper",4},
[4879] = {'Ogg\'marr',1752,1752,40,40,0,{[15]={{36.7,30.97}}},nil,15,nil,nil,29,"H","Butcher",6},
[4880] = {'"Stinky" Ignatz',1342,1342,35,35,0,{[15]={{46.88,17.52}}},nil,15,{1222,1270},nil,113,"AH",nil,2},
[4881] = {'Varng',1678,1678,39,39,0,nil,nil,0,nil,nil,29,"H","Turtle Trainer",0},
[4883] = {'Krak',1902,1902,41,41,0,{[15]={{36.4,30.85}}},nil,15,nil,nil,29,"H","Armorer",16388},
[4884] = {'Zulrg',2059,2059,43,43,0,{[15]={{36.17,31.8}}},nil,15,nil,nil,29,"H","Weaponsmith",16388},
[4885] = {'Gregor MacVince',1342,1342,35,35,0,{[15]={{65.19,51.5}}},nil,15,nil,nil,894,"A","Horse Breeder",5},
[4886] = {'Hans Weston',1403,1403,35,35,0,{[15]={{64.63,50.42}}},nil,15,nil,nil,894,"A","Armorer & Shieldsmith",16388},
[4887] = {'Ghamoo-ra',4194,4194,25,25,1,{[719]={{-1,-1}}},nil,719,nil,nil,128,nil,nil,0},
[4888] = {'Marie Holdston',1536,1536,37,37,0,{[15]={{64.61,50.07}}},nil,15,nil,nil,894,"A","Weaponsmith",16388},
[4889] = {'Torq Ironblast',1973,1973,43,43,0,{[15]={{67.51,47.98}}},nil,15,nil,nil,55,"A","Gunsmith",16388},
[4890] = {'Piter Verance',1902,1902,41,41,0,{[15]={{67.39,47.86}}},nil,15,nil,nil,894,"A","Weaponsmith & Armorer",16388},
[4891] = {'Dwane Wertle',895,895,28,28,0,{[15]={{68.17,47.35}}},nil,15,nil,nil,894,"A","Chef",6},
[4892] = {'Jensen Farran',1536,1536,37,37,0,{[15]={{67.95,49.89}}},nil,15,nil,nil,894,"A","Bowyer",16388},
[4893] = {'Bartender Lillian',2217,2217,45,45,0,{[15]={{66.67,45.21}}},nil,15,nil,nil,894,"A","Bartender",6},
[4894] = {'Craig Nollward',1162,1162,32,32,0,{[15]={{66.9,45.25}}},nil,15,nil,nil,894,"A","Cook",4},
[4895] = {'Smiling Jim',1342,1342,35,35,0,{[15]={{66.17,45.8}}},nil,15,nil,nil,1075,"A",nil,3},
[4896] = {'Charity Mipsy',1342,1342,35,35,0,{[15]={{67.45,51.72}}},nil,15,nil,nil,894,"A","General Goods",6},
[4897] = {'Helenia Olden',1279,1279,34,34,0,{[15]={{66.44,51.46}}},nil,15,nil,nil,894,"A","Trade Supplies",6},
[4898] = {'Brant Jasperbloom',1536,1536,37,37,0,{[15]={{64.01,47.53}}},nil,15,nil,nil,894,"A","Herbalist",19},
[4899] = {'Uma Bartulm',1536,1536,37,37,0,{[15]={{64.07,47.67}}},nil,15,nil,nil,894,"A","Herbalism & Alchemy Supplies",6},
[4900] = {'Alchemist Narett',1536,1536,37,37,0,{[15]={{63.94,47.64}}},nil,15,nil,nil,894,"A","Expert Alchemist",19},
[4901] = {'Sara Pierce',57,57,2,2,0,{[15]={{66.6,45.13}}},nil,15,nil,nil,894,"A",nil,0},
[4902] = {'Mikal Pierce',1604,1604,38,38,0,{[15]={{66.85,45.22}}},nil,15,nil,nil,894,"A",nil,0},
[4921] = {'Guard Byron',1752,1752,40,40,0,{[15]={{66.15,46.07}}},nil,15,{1282},nil,150,"A",nil,3},
[4922] = {'Guard Edward',2768,2768,50,50,0,{[15]={{67.15,46.04}}},nil,15,nil,nil,151,"A",nil,0},
[4923] = {'Guard Jarad',2768,2768,50,50,0,{[15]={{67.53,46.28}}},nil,15,nil,nil,1622,"A",nil,0},
[4924] = {'Combat Master Criton',3398,3398,55,55,0,{[15]={{67.39,46.07}}},nil,15,nil,nil,894,"A",nil,0},
[4926] = {'Krog',1752,1752,40,40,0,{[15]={{36.42,31.88}}},nil,15,{1276,1321},{1251,1268,1269,1273,1323},83,"H",nil,3},
[4941] = {'Caz Twosprocket',1342,1342,35,35,0,{[15]={{64.75,50.43}}},nil,15,{1320},{1319},64,"A",nil,3},
[4942] = {'Test Petition Giver',247,247,12,12,0,nil,nil,0,nil,nil,80,"A","Test",0},
[4943] = {'Mosarn',1002,1002,30,30,0,{[1638]={{54.01,80.77}}},nil,1638,nil,{1276},83,"H",nil,2},
[4944] = {'Captain Garran Vimes',2768,2768,50,50,0,{[15]={{68.21,48.62}}},nil,15,{1259,1286,1319},{1220,1252,1253,1282,1284,1285,1287,1320},1077,"A",nil,3},
[4945] = {'Goblin Drag Car',1162,1162,32,32,0,{[400]={{80.21,75.72}}},nil,400,nil,nil,35,"AH",nil,0},
[4946] = {'Gnome Drag Car',1162,1162,32,32,0,{[400]={{77.8,78.17}}},nil,400,nil,nil,35,"AH",nil,0},
[4947] = {'Theramore Lieutenant',3082,3082,52,52,0,{[15]={{67.07,53.22},{69.22,49.85},{68.13,48.19},{65.14,47.19},{67.19,51.04}}},nil,15,{1220},{1219},11,"A",nil,2},
[4948] = {'Adjutant Tesoran',1342,1342,35,35,0,{[15]={{68.05,48.11}}},nil,15,{1285},{1259},1075,"A",nil,2},
[4949] = {'Thrall',799500,799500,63,63,3,{[1637]={{31.73,37.82}}},nil,1637,{4002,4003,4974,5726,5727,5728,5729,6566,6567,7491,7784},{4001,4002,4004,4941,4974,5726,5727,5728,5730,6566,7490,7783,8485},125,"H","Warchief",3},
[4950] = {'Spot',532,532,20,20,0,{[15]={{67.96,46.76}}},nil,15,nil,nil,150,"A",nil,0},
[4951] = {'Theramore Practicing Guard',2215,2215,50,50,0,{[15]={{67.18,47.39},{67.33,47.24}}},nil,15,nil,nil,1096,"A",nil,0},
[4952] = {'Theramore Combat Dummy',42,42,1,1,0,{[15]={{67.34,47.45},{67.26,47.44},{67.33,47.19},{67.19,47.44},{67.19,47.19},{67.26,47.19}}},nil,15,nil,nil,1095,"AH",nil,0},
[4953] = {'Moccasin',8,8,1,1,0,{[8]={{46.24,60.15},{29.04,60.46},{70.61,74.35},{47.64,32.85},{43.26,34.96},{52.48,46.02},{72.07,26.39},{85.05,53.5},{67.91,18.86},{29.94,35.55},{57.25,56.53},{83.82,42.96},{62.54,63.44},{81.25,80.96},{48.53,47.07},{60.68,29.24},{57.24,26.87},{25.17,57.27}}},nil,8,nil,nil,7,"AH",nil,0},
[4954] = {'Uttnar',1468,1468,36,36,0,{[45]={{74.18,33.96}}},nil,45,nil,nil,29,"H","Butcher",6},
[4955] = {'Theramore Archery Target 1',42,42,1,1,0,nil,nil,0,nil,nil,151,"A",nil,0},
[4957] = {'Theramore Combat Dummy 4',42,42,1,1,0,nil,nil,0,nil,nil,1095,"AH",nil,0},
[4958] = {'Haunting Spirit',10,11,21,22,0,nil,nil,0,nil,nil,92,nil,nil,0},
[4959] = {'Jorgen',328,328,15,15,0,{[1519]={{73.17,78.42}}},nil,1519,{1242},{1241},12,"A",nil,2},
[4960] = {'Bishop DeLavey',1162,1162,32,32,0,{[1519]={{78.28,25.38}}},nil,1519,{1241},{1274},12,"A",nil,2},
[4961] = {'Dashel Stonefist',787,787,26,26,0,{[1519]={{70.55,44.89}}},nil,1519,{1247,1447},{1246,1447},84,"A",nil,2},
[4962] = {'Tapoke "Slim" Jahn',1279,1279,34,34,0,{[11]={{10.54,60.26}}},nil,11,{1250},nil,123,"A",nil,2},
[4963] = {'Mikhail',1002,1002,30,30,0,{[11]={{10.6,60.77}}},nil,11,{1249,1264},{1248,1249,1250},12,"A","Bartender",7},
[4964] = {'Commander Samaul',1752,1752,40,40,0,{[15]={{68.02,48.71}}},nil,15,{1265},{1264},894,"A",nil,2},
[4965] = {'Pained',2217,2217,45,45,0,{[15]={{66.15,49.05}}},nil,15,nil,nil,1077,"A",nil,2},
[4966] = {'Private Hendel',1342,1342,35,35,0,{[15]={{45.24,24.65}}},nil,15,{1324},{1266},1077,"A",nil,2},
[4967] = {'Archmage Tervosh',1604,1604,38,38,0,{[15]={{66.42,49.26}}},{[15]={{{45.17,24.23}}}},15,{1266,1267,7070},{1265,1324,7070},1077,"A",nil,3},
[4968] = {'Lady Jaina Proudmoore',466400,466400,63,63,3,{[15]={{66.27,49.04}}},nil,15,nil,{1267},1096,"A","Ruler of Theramore",3},
[4969] = {'Old Town Thug',733,787,25,26,0,nil,nil,0,nil,nil,17,nil,nil,0},
[4970] = {'Defias Agent',664,713,24,25,0,nil,nil,0,nil,nil,17,nil,nil,0},
[4971] = {'Slim\'s Friend',1015,1015,34,34,0,nil,nil,0,nil,nil,34,nil,nil,0},
[4972] = {'Kagoro',1752,1752,40,40,0,nil,nil,0,nil,nil,83,"H",nil,0},
[4973] = {'Guard Lasiter',2768,2768,50,50,0,{[15]={{67.78,49.69}}},{[15]={{{67.78,49.69},{67.75,49.62}}}},15,nil,nil,1077,"A",nil,2},
[4974] = {'Aldwin Laughlin',2768,2768,50,50,0,{[1519]={{57.03,67.65}}},nil,1519,nil,nil,12,"A","Guild Master",1537},
[4975] = {'Theramore Archery Target 2',42,42,1,1,0,nil,nil,0,nil,nil,151,"A",nil,0},
[4976] = {'Elise Laughlin',713,713,25,25,0,nil,nil,0,nil,nil,12,"A","Guild Tabard Designer",0},
[4977] = {'Murkshallow Softshell',210,210,25,25,0,nil,nil,0,nil,nil,129,nil,nil,0},
[4978] = {'Aku\'mai Servant',1953,1953,26,26,1,nil,nil,0,nil,nil,128,nil,nil,0},
[4979] = {'Theramore Guard',4906,5568,53,57,0,{[15]={{69.6,49.79},{65.88,52.04},{64.87,48.57},{65.66,50.49},{71.05,56.04},{71.64,56.15},{69.29,50.16},{70.56,57.17},{71.39,56.55},{68.51,51.56},{71.28,55.65},{66.82,50.1},{71.64,54.26},{64.24,49.55},{69.65,50.06},{68.04,52.56},{64.53,45.61},{64.77,46.95},{65.0,46.98},{65.0,46.91},{65.02,46.59},{70.99,56.58},{68.32,51.9},{68.3,51.87},{65.73,48.46},{65.49,48.21},{65.46,48.25},{65.63,48.61},{68.5,52.5},{63.79,44.98},{63.97,44.76},{64.21,45.98}}},nil,15,nil,nil,150,"A",nil,0},
[4980] = {'Paval Reethe',1342,1342,35,35,0,{[15]={{42.65,38.07}}},nil,15,nil,nil,35,"AH",nil,2},
[4981] = {'Ben Trias',712,712,25,25,0,{[1519]={{60.33,63.42}}},nil,1519,nil,nil,12,"A","Apprentice of Cheese",5},
[4982] = {'Thomas',42,42,1,1,0,{[1519]={{38.72,25.9}}},{[1519]={{{38.96,26.08},{38.91,26.52},{39.37,27.39},{41.68,31.83},{42.43,31.69},{43.07,33.08},{42.09,34.16},{41.33,32.75},{41.65,31.96},{38.92,26.5},{38.92,26.09},{38.73,25.9},{38.76,25.95}}}},1519,{1274},nil,12,"A","Altar Boy",2},
[4983] = {'Ogron',1342,1342,35,35,0,{[15]={{40.96,36.69}}},nil,15,{1273},nil,232,"H",nil,2},
[4984] = {'Argos Nightwhisper',484,484,20,20,0,{[1519]={{21.4,55.8}}},nil,1519,{3765},nil,80,"A",nil,2},
[4985] = {'World Druid Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Druid Trainer",0},
[4986] = {'World Hunter Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Hunter Trainer",0},
[4987] = {'World Mage Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Mage Trainer",0},
[4988] = {'World Paladin Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Paladin Trainer",0},
[4989] = {'World Priest Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Priest Trainer",0},
[4990] = {'World Rogue Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Rogue Trainer",0},
[4991] = {'World Shaman Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Shaman Trainer",0},
[4992] = {'World Warrior Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Warrior Trainer",0},
[4993] = {'World Warlock Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Warlock Trainer",0},
[4994] = {'World Wolf Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Wolf Pet Trainer",0},
[4995] = {'Stockade Guard',3696,3696,45,45,0,{[1519]={{40.88,57.36},{41.1,57.03},{41.48,56.69},{41.74,56.47}}},nil,1519,nil,nil,11,"A",nil,0},
[4996] = {'Injured Stockade Guard',3696,3696,45,45,0,{[1519]={{42.29,53.93},{42.07,54.2},{42.27,53.44},{42.19,54.06},{42.18,53.27}}},nil,1519,nil,nil,12,"A",nil,0},
[4997] = {'World Fishing Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Fishing Trainer",0},
[4998] = {'World Herbalism Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Herbalism Trainer",0},
[4999] = {'World Mining Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Mining Trainer",0},
[5000] = {'World Hunter Beast Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Hunter Beast Trainer",0},
[5001] = {'World Bird Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Bird Pet Trainer",0},
[5002] = {'World Boar Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Boar Pet Trainer",0},
[5003] = {'World Cat Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Cat Pet Trainer",0},
[5004] = {'World Crawler Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Crawler Pet Trainer",0},
[5005] = {'World Crocodile Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Crocodile Pet Trainer",0},
[5006] = {'World Demon Trainer',178,178,10,10,0,nil,nil,0,nil,nil,35,"AH","Demon Trainer",0},
[5007] = {'World Felhunter Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5008] = {'World Gorilla Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Gorilla Pet Trainer",0},
[5009] = {'World Horse Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Horse Pet Trainer",0},
[5010] = {'World Imp Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5011] = {'World Raptor Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Raptor Pet Trainer",0},
[5012] = {'World Scorpid Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Scorpid Pet Trainer",0},
[5013] = {'World Spider Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Spider Pet Trainer",0},
[5014] = {'World Succubus Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5015] = {'World Tallstrider Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Tallstrider Pet Trainer",0},
[5016] = {'World Voidwalker Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","UNUSED",0},
[5017] = {'World Turtle Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Turtle Pet Trainer",0},
[5018] = {'World Portal: Darnassus Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Portal: Darnassus Trainer",0},
[5019] = {'World Portal: Ironforge Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Portal: Ironforge Trainer",0},
[5020] = {'World Portal: Orgrimmar Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Portal: Orgrimmar Trainer",0},
[5021] = {'World Portal: Stormwind Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Portal: Stormwind Trainer",0},
[5022] = {'World Portal: Thunder Bluff Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Portal: Thunder Bluff Trainer",0},
[5023] = {'World Portal: Undercity Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Portal: Undercity Trainer",0},
[5024] = {'World First Aid Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","First Aid Trainer",0},
[5026] = {'World Horse Riding Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Horse Riding Trainer",0},
[5027] = {'World Lockpicking Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Lockpicking Trainer",0},
[5028] = {'World Ram Riding Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Ram Riding Trainer",0},
[5029] = {'World Survival Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Survival Trainer",0},
[5030] = {'World Tiger Riding Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Tiger Riding Trainer",0},
[5031] = {'World Wolf Riding Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Wolf Riding Trainer",0},
[5032] = {'World Alchemy Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Alchemy Trainer",16},
[5033] = {'World Blacksmith Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Blacksmith Trainer",0},
[5034] = {'World Brewing Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Brewing Trainer",0},
[5035] = {'World Cartography Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Cartography Trainer",0},
[5036] = {'World Cooking Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Cooking Trainer",0},
[5037] = {'World Engineering Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Engineering Trainer",16},
[5038] = {'World Enchanting Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Enchanting Trainer",16},
[5039] = {'World Tracking Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Tracking Trainer",0},
[5040] = {'World Leatherworking Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Leatherworking Trainer",16},
[5041] = {'World Tailoring Trainer',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Tailoring Trainer",16},
[5042] = {'Nurse Lillian',1002,1002,30,30,0,{[1519]={{42.11,53.68}}},{[1519]={{{42.3,53.64},{42.43,53.86},{42.38,53.91},{42.52,54.25},{42.18,54.66},{41.98,54.3},{42.02,54.29},{42.05,54.36},{41.85,54.0},{41.95,53.37},{42.08,53.18},{42.09,53.19},{42.06,53.19},{41.72,54.36},{41.73,54.39}}}},1519,nil,nil,12,"A",nil,0},
[5043] = {'Defias Rioter',484,484,20,20,0,{[1519]={{39.71,54.22},{39.73,54.14},{39.78,54.14},{39.82,54.03}}},nil,1519,nil,nil,17,nil,nil,0},
[5044] = {'Theramore Skirmisher',1468,1468,36,36,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5045] = {'Private Hallan',1337,1337,34,34,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5046] = {'Lieutenant Caldwell',1536,1536,37,37,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5047] = {'Ellaercia',1002,1002,30,30,0,{[1657]={{70.22,21.87}}},nil,1657,nil,nil,80,"A","Tabard Designer",524288},
[5048] = {'Deviate Adder',1251,1347,18,19,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[5049] = {'Lyesa Steelbrow',712,712,25,25,0,{[1537]={{36.31,85.47}}},nil,1537,nil,nil,55,"A","Guild Tabard Vendor",1029},
[5052] = {'Edward Remington',712,712,25,25,0,{[1497]={{69.81,44.28}}},nil,1497,nil,nil,68,"H","Guild Tabard Designer",1029},
[5053] = {'Deviate Crocolisk',417,449,18,19,0,{[718]={{-1,-1}}},nil,718,nil,nil,16,nil,nil,0},
[5054] = {'Krumn',2768,2768,50,50,0,{[1638]={{37.31,63.49}}},nil,1638,nil,nil,104,"H","Guild Master",1537},
[5055] = {'Deviate Lasher',134,145,19,20,0,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[5056] = {'Deviate Dreadfang',1452,1563,20,21,1,{[718]={{-1,-1}}},nil,718,nil,nil,270,nil,nil,0},
[5057] = {'Theramore Deserter',1536,1536,37,37,0,{[15]={{36.33,53.71},{36.42,54.02},{36.32,54.45},{36.55,54.36},{36.28,54.88},{36.21,53.58},{36.36,53.43},{36.53,53.68},{35.93,53.22},{35.64,53.25},{75.82,54.82},{76.33,55.14},{35.89,54.72},{36.09,54.65},{76.97,56.18},{76.73,56.33},{76.53,56.85},{76.72,56.45},{76.88,56.32},{77.0,56.09},{76.66,56.37},{35.6,54.62},{35.13,52.91},{35.25,52.75},{35.25,53.12},{35.43,54.34},{34.78,54.76},{35.76,53.65},{35.86,53.85},{35.87,54.18},{36.05,53.85},{35.16,54.17},{35.28,53.52},{35.6,53.87},{35.64,54.35},{34.52,53.7},{34.42,54.75}}},nil,15,nil,nil,1077,"A",nil,0},
[5058] = {'Wolfguard Worg',493,531,20,21,0,{[209]={{-1,-1}}},nil,209,nil,nil,24,nil,nil,0},
[5059] = {'Galthogran the Callous',4572,4572,40,40,0,nil,nil,0,nil,nil,134,nil,nil,0},
[5060] = {'World Banker',5544,5544,45,45,0,nil,nil,0,nil,nil,35,"AH","Banker",0},
[5061] = {'World Guild Tabbard Vendor',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Guild Tabard Vendor",0},
[5062] = {'World Reagent Vendor',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Reagents/Totems Vendor",0},
[5063] = {'Pat\'s Test Kobold',3052,3052,60,60,0,nil,nil,0,nil,nil,14,nil,nil,0},
[5064] = {'World Trade Supplies',198,198,10,10,0,nil,nil,0,nil,nil,35,"AH","Trade Supplies",0},
[5081] = {'Connor Rivers',712,712,25,25,0,{[1519]={{40.63,91.87}}},nil,1519,{1301},nil,12,"A","Apprentice Chef",2},
[5082] = {'Vincent Hyal',1002,1002,30,30,0,{[11]={{8.39,61.75}}},nil,11,{1302},{1301},12,"A",nil,2},
[5083] = {'Clerk Lendry',484,484,20,20,0,{[15]={{67.88,48.24}}},nil,15,nil,{1302},894,"A",nil,2},
[5084] = {'Ironforge Zinn',1981,1981,42,42,0,nil,nil,0,nil,nil,55,"A",nil,0},
[5085] = {'Sentry Point Guard',1534,1534,38,38,0,{[15]={{59.69,41.5},{59.76,41.01},{59.59,41.22},{59.82,41.21},{59.9,40.81},{59.84,40.76},{60.26,40.19},{60.43,40.7},{60.09,40.87},{59.55,41.42},{59.84,41.11},{59.66,40.93},{59.84,41.33},{60.02,40.9}}},nil,15,nil,nil,150,"A",nil,0},
[5086] = {'Sentry Point Captain',1221,1221,33,33,0,{[15]={{59.67,41.08}}},nil,15,nil,nil,11,"A",nil,0},
[5087] = {'Do\'gol',1002,1002,30,30,0,{[15]={{36.53,30.79}}},nil,15,{1322,1323},{1321,1322},83,"H",nil,2},
[5088] = {'Falgran Hastil',1604,1604,38,38,0,nil,nil,0,nil,nil,151,"A",nil,0},
[5089] = {'Balos Jacken',1604,1604,38,38,0,{[15]={{36.09,54.31}}},nil,15,{1287},{1286},14,nil,nil,2},
[5090] = {'Combat Master Szigeti',3398,3398,55,55,0,{[15]={{67.21,46.35}}},nil,15,nil,nil,894,"A",nil,0},
[5091] = {'Guard Kahil',2768,2768,50,50,0,{[15]={{67.15,46.08}}},nil,15,nil,nil,151,"A",nil,2},
[5092] = {'Guard Lana',2768,2768,50,50,0,{[15]={{67.53,46.23}}},nil,15,nil,nil,151,"A",nil,0},
[5093] = {'Guard Narrisha',2768,2768,50,50,0,{[15]={{67.15,46.13}}},nil,15,nil,nil,151,"A",nil,0},
[5094] = {'Guard Tark',2768,2768,50,50,0,{[15]={{67.53,46.19}}},nil,15,nil,nil,151,"A",nil,0},
[5095] = {'Captain Andrews',3188,3188,53,53,0,{[15]={{67.5,46.32}}},nil,15,nil,nil,894,"A","Red Team Captain",0},
[5096] = {'Captain Thomas',3188,3188,53,53,0,{[15]={{67.17,45.99}}},nil,15,nil,nil,894,"A","Blue Team Captain",0},
[5097] = {'Lupine Delusion',651,699,24,25,0,nil,nil,0,nil,nil,24,nil,nil,0},
[5099] = {'Soleil Stonemantle',5544,5544,45,45,0,{[1537]={{36.82,61.86}}},nil,1537,nil,nil,55,"A","Banker",256},
[5100] = {'Fillius Fizzlespinner',1002,1002,30,30,0,{[1537]={{38.14,73.7}}},nil,1537,nil,nil,875,"A","Trade Supplier",4},
[5101] = {'Bryllia Ironbrand',1002,1002,30,30,0,{[1537]={{39.23,74.46}}},nil,1537,nil,nil,55,"A","General Goods Vendor",4},
[5102] = {'Dolman Steelfury',1002,1002,30,30,0,{[1537]={{35.8,65.72}}},nil,1537,nil,nil,55,"A","Weapon Merchant",16388},
[5103] = {'Grenil Steelfury',1002,1002,30,30,0,{[1537]={{35.98,65.37}}},nil,1537,nil,nil,55,"A","Weapon Merchant",16388},
[5104] = {'Laene Thundershot',1753,1753,40,40,0,nil,nil,0,nil,nil,55,"A","Gun Trainer",0},
[5105] = {'Gilbin',1003,1003,30,30,0,nil,nil,0,nil,nil,875,"A","Light Armor Merchant",0},
[5106] = {'Bromiir Ormsen',1002,1002,30,30,0,{[1537]={{31.72,58.27}}},nil,1537,nil,nil,55,"A","Heavy Armor Merchant",16388},
[5107] = {'Mangorn Flinthammer',1002,1002,30,30,0,{[1537]={{31.95,57.93}}},nil,1537,nil,nil,55,"A","Heavy Armor Merchant",16388},
[5108] = {'Raena Flinthammer',1002,1002,30,30,0,{[1537]={{32.62,57.39}}},nil,1537,nil,nil,55,"A","Light Armor Merchant",16388},
[5109] = {'Myra Tyrngaarde',1002,1002,30,30,0,{[1537]={{29.61,67.45}}},{[1537]={{{32.0,70.29},{33.55,73.42},{33.05,75.32},{32.05,77.42},{30.8,77.64},{29.49,75.3},{27.36,71.48},{25.3,67.4},{23.38,63.52},{23.88,62.39},{25.71,61.16},{27.83,63.08},{29.62,67.53}}}},1537,nil,nil,55,"A","Bread Vendor",4},
[5110] = {'Barim Jurgenstaad',1002,1002,30,30,0,{[1537]={{19.19,56.1}}},nil,1537,nil,nil,55,"A","Reagent Vendor",4},
[5111] = {'Innkeeper Firebrew',1002,1002,30,30,0,{[1537]={{18.15,51.45}}},nil,1537,{3790,8353},{8353},55,"A","Innkeeper",135},
[5112] = {'Gwenna Firebrew',1002,1002,30,30,0,{[1537]={{18.64,51.76}}},nil,1537,nil,nil,55,"A","Barmaid",6},
[5113] = {'Kelv Sternhammer',2217,2217,45,45,0,{[1537]={{70.34,90.65}}},nil,1537,{1718,8417},nil,55,"A","Warrior Trainer",19},
[5114] = {'Bilban Tosslespanner',2217,2217,45,45,0,{[1537]={{65.9,88.41}}},nil,1537,nil,nil,875,"A","Warrior Trainer",19},
[5115] = {'Daera Brightspear',4120,4120,60,60,0,{[1537]={{70.97,89.8}}},nil,1537,nil,nil,55,"A","Hunter Trainer",19},
[5116] = {'Olmin Burningbeard',2768,2768,50,50,0,{[1537]={{70.89,83.61}}},nil,1537,{8151},nil,55,"A","Hunter Trainer",19},
[5117] = {'Regnus Thundergranite',1752,1752,40,40,0,{[1537]={{69.87,82.9}}},nil,1537,{6075,6721},nil,55,"A","Hunter Trainer",19},
[5118] = {'Brogun Stoneshield',157200,157200,61,61,1,{[1657]={{58.07,44.57}}},nil,1657,nil,nil,1216,"A","Alterac Valley Battlemaster",2049},
[5119] = {'Hegnar Swiftaxe',1002,1002,30,30,0,{[1537]={{62.19,88.16}}},nil,1537,nil,nil,55,"A","Axe Merchant",16388},
[5120] = {'Brenwyn Wintersteel',1002,1002,30,30,0,{[1537]={{62.37,88.68}}},nil,1537,nil,nil,55,"A","Blade Merchant",16388},
[5121] = {'Kelomir Ironhand',1002,1002,30,30,0,{[1537]={{62.55,88.71}}},nil,1537,nil,nil,55,"A","Maces & Staves",16388},
[5122] = {'Skolmin Goldfury',1002,1002,30,30,0,{[1537]={{71.76,66.7}}},nil,1537,nil,nil,55,"A","Bow Merchant",16388},
[5123] = {'Bretta Goldfury',1002,1002,30,30,0,{[1537]={{72.21,65.24}}},nil,1537,nil,nil,55,"A","Gun Merchant",16388},
[5124] = {'Sognar Cliffbeard',1002,1002,30,30,0,{[1537]={{56.56,82.19}}},{[1537]={{{57.01,84.48},{58.71,84.94},{61.0,82.91},{63.42,79.94},{65.75,77.19},{67.79,74.66},{69.26,72.34},{68.9,68.93},{67.26,67.48},{65.88,67.79},{64.1,70.63},{62.2,71.72},{60.66,73.63},{59.49,76.9},{57.61,78.5},{56.56,82.16}}}},1537,nil,nil,55,"A","Meat Vendor",4},
[5125] = {'Dolkin Craghelm',1002,1002,30,30,0,{[1537]={{53.85,87.89}}},nil,1537,nil,nil,55,"A","Mail Armor Merchant",16388},
[5126] = {'Olthran Craghelm',1002,1002,30,30,0,{[1537]={{54.86,87.41}}},nil,1537,nil,nil,55,"A","Heavy Armor Merchant",16388},
[5127] = {'Fimble Finespindle',1342,1342,35,35,0,{[1537]={{40.24,33.68}}},nil,1537,nil,nil,875,"A","Expert Leatherworker",17},
[5128] = {'Bombus Finespindle',1002,1002,30,30,0,{[1537]={{39.62,34.49}}},nil,1537,nil,nil,55,"A","Leatherworking Supplies",4},
[5129] = {'Lissyphus Finespindle',1002,1002,30,30,0,{[1537]={{54.7,87.97}}},nil,1537,nil,nil,55,"A","Light Armor Merchant",16388},
[5130] = {'Jondor Steelbrow',4120,4120,60,60,0,{[1537]={{35.9,84.71}}},nil,1537,nil,nil,55,"A","Guild Master",1537},
[5132] = {'Pithwick',1002,1002,30,30,0,{[1537]={{38.02,74.74}}},nil,1537,nil,nil,875,"A","Bag Vendor",4},
[5133] = {'Harick Boulderdrum',1002,1002,30,30,0,{[1537]={{23.13,15.94}}},nil,1537,nil,nil,55,"A","Wands Merchant",16388},
[5134] = {'Jonivera Farmountain',26140,26140,55,55,0,{[2597]={{43.08,17.49}}},nil,2597,nil,nil,1217,"A","General Goods",6},
[5135] = {'Svalbrad Farmountain',26140,26140,55,55,0,{[2597]={{42.82,16.88}}},nil,2597,nil,nil,1217,"A","Trade Goods",6},
[5137] = {'Reyna Stonebranch',1342,1342,35,35,0,{[1537]={{55.9,59.13}}},nil,1537,nil,nil,55,"A","Herbalism Trainer",16},
[5138] = {'Gwina Stonebranch',1002,1002,30,30,0,{[1537]={{55.08,59.51}}},nil,1537,nil,nil,55,"A","Herbalism Supplier",4},
[5139] = {'Kurdrum Barleybeard',26140,26140,55,55,0,{[2597]={{42.79,16.56}}},nil,2597,nil,nil,1217,"A","Reagents & Poisons",6},
[5140] = {'Edris Barleybeard',1002,1002,30,30,0,{[1537]={{72.25,75.79}}},nil,1537,nil,nil,55,"A","Barmaid",6},
[5141] = {'Theodrus Frostbeard',4120,4120,60,60,0,{[1537]={{24.08,8.41}}},nil,1537,{8254},nil,55,"A","Priest Trainer",19},
[5142] = {'Braenna Flintcrag',2768,2768,50,50,0,{[1537]={{24.42,9.17}}},nil,1537,{5633,8254},nil,55,"A","Priest Trainer",19},
[5143] = {'Toldren Deepiron',1752,1752,40,40,0,{[1537]={{25.21,10.76}}},nil,1537,{5645},nil,55,"A","Priest Trainer",19},
[5144] = {'Bink',1752,1752,40,40,0,{[1537]={{27.25,8.3}}},nil,1537,{1880,1953,2861},{1879,1880},875,"A","Mage Trainer",19},
[5145] = {'Juli Stormkettle',2768,2768,50,50,0,{[1537]={{26.3,6.77}}},nil,1537,{8250},nil,875,"A","Mage Trainer",19},
[5146] = {'Nittlebur Sparkfizzle',4120,4120,60,60,0,{[1537]={{25.93,6.17}}},nil,1537,nil,nil,55,"A","Mage Trainer",19},
[5147] = {'Valgar Highforge',4120,4120,60,60,0,{[1537]={{23.7,5.1}}},nil,1537,nil,nil,55,"A","Paladin Trainer",19},
[5148] = {'Beldruk Doombrow',2768,2768,50,50,0,{[1537]={{24.55,4.47}}},nil,1537,nil,nil,55,"A","Paladin Trainer",19},
[5149] = {'Brandur Ironhammer',2768,2768,50,50,0,{[1537]={{23.13,6.14}}},nil,1537,{1794,2999,3681,4486},{1794},55,"A","Paladin Trainer",19},
[5150] = {'Nissa Firestone',1342,1342,35,35,0,{[1537]={{55.09,58.26}}},nil,1537,{6625},nil,55,"A","First Aid Trainer",19},
[5151] = {'Ginny Long