---@type ContentPhases
local ContentPhases = QuestieLoader:ImportModule("ContentPhases")

-- This function blacklists any quests in phases LATER than the currentPhase value
-- so in Phase 1, quests in phases 2+ are blacklisted, in phase 2, phases 3+ are blacklisted, etc
-- Phase 1 is omitted, because everything not in this list is supposed to be available in Phase 1
local questsToBlacklistByPhase = {
    [1] = {}, -- Phase 1 - T4 (Kara, Gruul, Mag) (this is required for counting, but should stay empty)
    [2] = { -- Phase 2 - T5 (SSC, TK, Hyjal)
        [11007] = true,

        -- Druid Swift Flight Form
        [10955] = true,
        [10961] = true,
        [10964] = true,
        [10965] = true,
        [10978] = true,
        [10979] = true,
        [10980] = true,
        [10986] = true,
        [10987] = true,
        [10988] = true,
        [10990] = true,
        [10991] = true,
        [10992] = true,
        [10993] = true,
        [10994] = true,
        [11001] = true,
        [11011] = true,

        -- Ogri'la & Sha'tari Skyguard
        [10984] = true,
        [11004] = true,
        [11005] = true,
        [11006] = true,
        [11008] = true,
        [11009] = true,
        [11010] = true,
        [11021] = true,
        [11023] = true,
        [11024] = true,
        [11025] = true,
        [11026] = true,
        [11027] = true,
        [11028] = true,
        [11029] = true,
        [11030] = true,
        [11051] = true,
        [11056] = true,
        [11057] = true,
        [11058] = true,
        [11059] = true,
        [11060] = true,
        [11061] = true,
        [11062] = true,
        [11065] = true,
        [11066] = true,
        [11072] = true,
        [11073] = true,
        [11074] = true,
        [11078] = true,
        [11079] = true,
        [11080] = true,
        [11085] = true,
        [11091] = true,
        [11093] = true,
        [11096] = true,
        [11098] = true,
        [11102] = true,
        [11119] = true,
        [11885] = true,
    },
    [3] = { -- Phase 3 - T6 (Hyjal, BT)
        [10445] = true,
        [10460] = true,
        [10461] = true,
        [10462] = true,
        [10463] = true,
        [10464] = true,
        [10465] = true,
        [10466] = true,
        [10467] = true,
        [10468] = true,
        [10469] = true,
        [10470] = true,
        [10471] = true,
        [10472] = true,
        [10473] = true,
        [10474] = true,
        [10475] = true,
        [10622] = true,
        [10628] = true,
        [10705] = true,
        [10706] = true,
        [10707] = true,
        [10708] = true,
        [10944] = true,
        [10946] = true,
        [10947] = true,
        [10948] = true,
        [10949] = true,
        [10957] = true,
        [10958] = true,
        [11103] = true,
        [11104] = true,
        [11105] = true,
        [11106] = true,
    },
    [4] = { -- Phase 3.5 - Zul'Aman
        [9524] = true,
        [9525] = true,
        [11130] = true,
        [11132] = true,
        [11164] = true,
        [11165] = true,
        [11166] = true,
        [11171] = true,
        [11178] = true,
        [11195] = true,
    },
    [5] = { -- Phase 4 - Sunwell, Isle of Quel'Danas
        [11481] = true,
        [11482] = true,
        [11488] = true,
        [11490] = true,
        [11492] = true,
        [11496] = true,
        [11499] = true,
        [11500] = true,
        [11513] = true,
        [11514] = true,
        [11515] = true,
        [11516] = true,
        [11517] = true,
        [11520] = true,
        [11521] = true,
        [11523] = true,
        [11524] = true,
        [11525] = true,
        [11526] = true,
        [11532] = true,
        [11533] = true,
        [11534] = true,
        [11535] = true,
        [11536] = true,
        [11537] = true,
        [11538] = true,
        [11539] = true,
        [11540] = true,
        [11541] = true,
        [11542] = true,
        [11543] = true,
        [11544] = true,
        [11545] = true,
        [11546] = true,
        [11547] = true,
        [11548] = true,
        [11549] = true,
        [11550] = true,
        [11554] = true,
        [11555] = true,
        [11556] = true,
        [11557] = true,
        [11877] = true,
        [11880] = true,
        [64997] = true,
        [64998] = true,
        [64999] = true,
    }
}

---@param questsToBlacklist table<QuestId, boolean>
---@param contentPhase number
---@return table<QuestId, boolean>
function ContentPhases.BlacklistTbcQuestsByPhase(questsToBlacklist, contentPhase)
    for phase = contentPhase + 1, #questsToBlacklistByPhase do
        for questId in pairs(questsToBlacklistByPhase[phase]) do
            questsToBlacklist[questId] = true
        end
    end

    return questsToBlacklist
end
