---@class CataNpcFixes
local CataNpcFixes = QuestieLoader:CreateModule("CataNpcFixes")

---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@type Phasing
local Phasing = QuestieLoader:ImportModule("Phasing")

function CataNpcFixes.Load()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local waypointPresets = QuestieDB.waypointPresets
    local phases = Phasing.phases
    local npcFlags = QuestieDB.npcFlags

    return {
        [19] = { -- Benny Questgiver
            [npcKeys.questEnds] = {5053,5101,11578,11579},
        },
        [197] = { -- Marshal McBride
            [npcKeys.questStarts] = {54,3100,3101,3102,3103,3104,3105,26389,26390,26910,28757,28759,28762,28763,28764,28765,28766,28767,28769,28770,28771,28772,28773,28774,28780,28784,28785,28786,28787,28788,28789,29078,29079,29080},
            [npcKeys.questEnds] = {14032,26389,26390,28757,28759,28762,28763,28764,28765,28766,28767,28769,28770,28771,28772,28773,28774,28817,28818,28819,28820,28821,28822,28823,29078,29079,29083},
        },
        [198] = { -- Khelden Bremen
            [npcKeys.questStarts] = {26916},
            [npcKeys.questEnds] = {3104,26916},
        },
        [233] = { -- Farmer Saldean
            [npcKeys.questStarts] = {109,26237,26257,26270},
        },
        [234] = { -- Marshal Gryan Stoutmantle
            [npcKeys.spawns] = {
                [zoneIDs.WESTFALL] = {
                    {56.33,47.52,phases.GRYAN_TOWER},
                    {56.37,49.64,phases.GRYAN_FP},
                },
            },
        },
        [237] = { -- Farmer Furlbrow
            [npcKeys.questStarts] = {109},
        },
        [240] = { -- Marshal Dughan
            [npcKeys.questStarts] = {35,62,76,109,239,26378},
        },
        [261] = { -- Guard Thomas
            [npcKeys.questStarts] = {37,52,59,109,26378},
        },
        [272] = { -- Chef Grual
            [npcKeys.waypoints] = {},
        },
        [294] = { -- Marshal Haggard
            [npcKeys.questStarts] = {109,26378},
        },
        [295] = { -- Innkeeper Farley
            [npcKeys.questEnds] = {69,2158},
        },
        [300] = { -- Zzarc' Vul
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{37.87,84.35}}},
        },
        [302] = { -- Blind Mary
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{82.02,59.32}}},
        },
        [330] = { -- Princess
            [npcKeys.waypoints] = {[zoneIDs.ELWYNN_FOREST] = {{{32.47,86.71},{32.54,86.67},{32.61,86.64},{32.67,86.60},{32.74,86.56},{32.81,86.52},{32.87,86.48},{32.94,86.44},{33.01,86.41},{33.08,86.37},{33.15,86.33},{33.21,86.30},{33.28,86.26},{33.35,86.22},{33.38,86.14},{33.38,86.03},{33.38,85.92},{33.38,85.81},{33.37,85.70},{33.37,85.60},{33.36,85.49},{33.35,85.38},{33.35,85.27},{33.34,85.17},{33.34,85.06},{33.31,84.96},{33.27,84.88},{33.21,84.82},{33.14,84.76},{33.08,84.70},{33.02,84.65},{32.96,84.59},{32.90,84.53},{32.84,84.48},{32.78,84.42},{32.71,84.36},{32.65,84.31},{32.59,84.27},{32.53,84.33},{32.48,84.41},{32.43,84.50},{32.39,84.58},{32.34,84.66},{32.29,84.74},{32.24,84.82},{32.20,84.90},{32.15,84.99},{32.10,85.07},{32.07,85.16},{32.07,85.27},{32.10,85.37},{32.12,85.47},{32.15,85.57},{32.18,85.67},{32.21,85.77},{32.24,85.87},{32.26,85.97},{32.29,86.07},{32.32,86.17},{32.34,86.27},{32.37,86.37},{32.40,86.47},{32.43,86.57},{32.47,86.71}}}},
        },
        [331] = { -- Maginor Dumas
            [npcKeys.questStarts] = {8250,27354,28398,64038},
        },
        [332] = { -- Master Mathias Shaw
            [npcKeys.questStarts] = {2206,6681,27072},
        },
        [334] = { -- Gath'Ilzogg
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{57.76,56.3}}},
        },
        [379] = { -- Darcy Parker
            [npcKeys.waypoints] = {},
        },
        [375] = { -- Priestess Anetta
            [npcKeys.questStarts] = {26919},
            [npcKeys.questEnds] = {3103,26919},
        },
        [376] = { -- High Priestess Laurena
            [npcKeys.questStarts] = {5631,5634,5645,5673,27361,28328,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {5634,5635,5636,5637,5638,5639,5640,5669,5670,5671,5676,5677,5678,5686,5687,5699,5700,27268,28285,28328,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [382] = { -- Marshal Marris
            [npcKeys.spawns] = {
                [zoneIDs.REDRIDGE_MOUNTAINS] = {
                    {31.86,44.89,phases.MARRIS_BRIDGE},
                    {29.73,44.52,phases.MARRIS_STABLES},
                },
            },
        },
        [384] = { -- Katie Hunter
            [npcKeys.questStarts] = {7677,7678},
            [npcKeys.questEnds] = {7677,7678},
        },
        [397] = { -- Grand Magus Doane
            [npcKeys.questStarts] = {},
        },
        [459] = { -- Drusilla La Salle
            [npcKeys.questStarts] = {26914},
            [npcKeys.questEnds] = {1598,3105,26914},
        },
        [461] = { -- Demisette Cloyce
            [npcKeys.questStarts] = {4488,8419,27355,28399},
        },
        [464] = { -- Watch Captain Parker
            [npcKeys.waypoints] = {},
        },
        [486] = { -- Tharil'zun
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{60.31,47.4}}},
        },
        [511] = { -- Insane Ghoul
            [npcKeys.waypoints] = {},
        },
        [518] = { -- Yowler
            [npcKeys.questStarts] = {},
        },
        [522] = { -- Mor'ladim
            [npcKeys.waypoints] = {[zoneIDs.DUSKWOOD] = {{{17.61,29.49},{17.52,29.80},{17.45,30.20},{17.41,30.61},{17.40,31.03},{17.41,31.44},{17.43,31.86},{17.46,32.27},{17.60,32.62},{17.82,32.87},{17.97,33.22},{18.17,33.49},{18.40,33.74},{18.53,34.10},{18.48,34.51},{18.46,34.60},{18.33,34.96},{18.20,35.33},{18.06,35.69},{17.93,36.06},{17.81,36.43},{17.68,36.80},{17.55,37.17},{17.53,37.58},{17.40,37.91},{17.17,38.15},{17.01,38.35},{17.00,38.37},{16.80,38.65},{16.55,38.82},{16.43,39.17},{16.54,39.22},{16.71,38.90},{16.90,38.60},{17.11,38.31},{17.32,38.04},{17.48,37.72},{17.55,37.31},{17.65,36.95},{17.74,36.68},{17.87,36.31},{18.01,35.95},{18.14,35.58},{18.28,35.22},{18.42,34.86},{18.51,34.47},{18.51,34.06},{18.34,33.75},{18.21,33.46},{18.25,33.28},{18.31,33.03},{18.37,32.76},{18.44,32.45},{18.42,32.05},{18.41,32.01},{18.26,31.85},{18.00,31.75},{17.78,31.51},{17.68,31.12},{17.61,30.72},{17.64,30.30},{17.67,29.89},{17.70,29.47},{17.72,29.21},{17.61,29.49}}}},
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{17.61,29.49}}},
        },
        [543] = { -- Nalesette Wildbringer
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [658] = { -- Sten Stoutarm
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{36.55,70.41}}},
        },
        [681] = { -- Young Stranglethorn Tiger
            [npcKeys.spawns] = {[33] = {{36.20,17.38},{37.25,18.89},{37.77,20.11},{38.08,20.81},{39.80,20.95},{39.18,21.82},{39.68,23.29},{40.40,21.96},{40.70,24.32},{41.35,23.20},{42.14,24.37},{42.92,25.24},{42.16,27.17},{44.15,25.98},{44.36,24.44},{45.50,24.40},{46.45,23.08},{46.75,25.28},{45.33,26.86},{46.21,30.11},{46.78,31.76},{47.81,33.05},{46.88,34.36},{48.95,34.15},{49.51,32.69},{49.04,30.71}}},
        },
        [682] = { -- Stranglethorn Tiger
            [npcKeys.spawns] = {[33] = {{55.72,27.51},{55.69,27.97},{56.32,28.45},{58.13,29.80},{58.58,27.82},{57.61,26.64},{58.83,27.17},{60.30,27.71},{60.29,28.32},{61.03,29.64},{61.30,29.47},{61.39,30.60},{61.52,25.68},{61.28,31.16},{61.94,35.27},{61.29,34.65},{60.83,33.66},{59.67,32.77}}},
            [npcKeys.questStarts] = {},
        },
        [684] = { -- Shadowmaw Panther
            [npcKeys.spawns] = {[33] = {{45.21,60.19},{50.37,55.96},{50.83,64.56},{52.64,59.71},{44.4,58.82},{46.73,56.8},{48.96,56.37},{49.98,59.92},{52.78,54.81},{51.27,54.87},{63.26,48.16},{59.23,47.44},{67.29,37.56},{63.08,36.89},{65.9,38.21},{66.31,41.28},{65.51,45.24},{66.6,44.1},{62.77,43.07},{61.52,50.81},{62.53,47.85},{60.7,47.04},{61.29,48.59},{60.72,49.89},{61.7,41.38},{66.58,44.06}}},
            [npcKeys.questStarts] = {},
        },
        [686] = { -- Lashtail Raptor
            [npcKeys.questStarts] = {},
        },
        [687] = { -- Jungle Stalker
            [npcKeys.questStarts] = {},
        },
        [728] = { -- Bhag'thera
            [npcKeys.spawns] = {[33] = {{66.70,43.37},{63.11,48.16},{62.18,51.55},{61.38,49.75},{61.89,51.35},{66.83,38.58}}},
        },
        [729] = { -- Sin'Dall
            [npcKeys.spawns] = {[33] = {{38.52,32.54}}},
        },
        [730] = { -- Tethis
            [npcKeys.spawns] = {[33] = {{65.64,58.52},{63.71,62.76},{59.79,59.32},{60.19,62.71},{62.84,61.32},{64.84,64.91}}},
        },
        [731] = { -- King Bangalash
            [npcKeys.spawns] = {[33] = {{47.77,59.54}}},
        },
        [736] = { -- Panther
            [npcKeys.spawns] = {[33] = {{35.51,19.86},{35.64,18.93},{35.47,20.26},{34.97,18.84},{34.52,19.13},{33.76,20.08},{33.38,20.35},{33.31,20.52},{33.40,20.79},{33.87,21.11},{34.98,22.08},{34.98,22.08},{36.57,23.31},{34.34,21.95},{32.79,23.87},{32.51,25.43},{32.66,26.37},{32.66,26.37},{32.70,27.43},{32.85,27.75},{32.86,29.12},{32.60,30.31}}},
            [npcKeys.questStarts] = {},
        },
        [821] = { -- Captain Danuvin
            [npcKeys.spawns] = {
                [zoneIDs.WESTFALL] = {
                    {56.46,47.57,phases.GRYAN_TOWER},
                    {56.42,49.52,phases.GRYAN_FP},
                },
            },
        },
        [823] = { -- Sergeant Willem
            [npcKeys.questStarts] = {28791,28792,28793,28794,28795,28796,28797,28817,28818,28819,28820,28821,28822,28823,29081,29083},
            [npcKeys.questEnds] = {6,18,27723,28780,28784,28785,28786,28787,28788,28789,28791,28792,28793,28794,28795,28796,28797,29080,29081},
        },
        [878] = { -- Scout Galiaan
            [npcKeys.spawns] = {
                [zoneIDs.WESTFALL] = {
                    {56.39,47.34,phases.GRYAN_TOWER},
                    {56.3,49.52,phases.GRYAN_FP},
                },
            },
        },
        [881] = { -- Echeyakee
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{44.9,47.8}}},
        },
        [895] = { -- Thorgas Grimson
            [npcKeys.questStarts] = {24530},
        },
        [911] = { -- Llane Beshere
            [npcKeys.questStarts] = {26913},
            [npcKeys.questEnds] = {3100,26913},
        },
        [914] = { -- Ander Germaine
            [npcKeys.questStarts] = {27337,28393,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {27225,28258,28393,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [915] = { -- Jorik Kerridan
            [npcKeys.questStarts] = {26915},
            [npcKeys.questEnds] = {3102,26915},
        },
        [925] = { -- Brother Sammuel
            [npcKeys.questStarts] = {26918},
            [npcKeys.questEnds] = {3101,26918},
        },
        [928] = { -- Lord Grayson Shadowbreaker
            [npcKeys.questStarts] = {8415,27343,28405,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {7638,7639,7640,7644,7646,7648,7666,7670,27265,28268,28405,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [963] = { -- Deputy Rainer
            [npcKeys.questStarts] = {11,109,26378},
        },
        [1073] = { -- Ashlan Stonesmirk
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{64.13,26.61}}},
        },
        [1085] = { -- Elder Stranglethorn Tiger
            [npcKeys.questStarts] = {},
        },
        [1105] = { -- Jern Hornhelm
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{37.24,47.38}}},
        },
        [1139] = { -- Magistrate Bluntnose
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{34.6,44.47}}},
        },
        [1153] = { -- Torren Squarejaw
            [npcKeys.questStarts] = {13661},
        },
        [1225] = { -- Ol' Sooty
            [npcKeys.waypoints] = {},
        },
        [1252] = { -- Senir Whitebeard
            [npcKeys.questStarts] = {287,291},
        },
        [1261] = { -- Veron Amberstill
            [npcKeys.questStarts] = {7673,7674,25905},
            [npcKeys.questEnds] = {7673,7674,25905},
        },
        [1266] = { -- Tundra MacGrann
            [npcKeys.questStarts] = {312},
        },
        [1340] = { -- Mountaineer Kadrell
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{35.06,46.58}}},
            [npcKeys.questStarts] = {467,13636,26842,26927,26932},
        },
        [1380] = { -- Saean
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN] = {{56.51,65.94}}},
            [npcKeys.zoneID] = zoneIDs.LOCH_MODAN,
        },
        [1373] = { -- Jarven Thunderbrew
            [npcKeys.questStarts] = {308},
        },
        [1374] = { -- Rejold Barleybrew
            [npcKeys.questStarts] = {315,319,320,413},
        },
        [1375] = { -- Marleth Barleybrew
            [npcKeys.questStarts] = {310},
        },
        [1377] = { -- Pilot Stonegear
            [npcKeys.questStarts] = {},
        },
        [1388] = { -- Vagash
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{69.79,44.37}}},
        },
        [1416] = { -- Grimand Elmore
            [npcKeys.waypoints] = {},
        },
        [1422] = { -- Corporal Sethman
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{46.98,10.84,phases.SETHMAN_VISIBLE}}},
        },
        [1435] = { -- Zardeth of the Black Claw
            [npcKeys.questStarts] = {335,336,397},
        },
        [1449] = { -- Witch Doctor Unbagwa
            [npcKeys.questStarts] = {349,26598},
        },
        [1490] = { -- Zanzil Witch Doctor
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{61.8,40.9},{62.14,41.76},{59.46,48.72},{60.38,43.09}}},
        },
        [1494] = { -- Negolash
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{50.75,79.65}}},
        },
        [1514] = { -- Mokk the Savage
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{52.99,50.22}}},
        },
        [1515] = { -- Executor Zygand
            [npcKeys.questStarts] = {24981,24992,24993,26964},
        },
        [1543] = { -- Vile Fin Puddlejumper
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{34.31,44.17},{30.12,43.61},{34.91,44.7},{30.7,44.6},{36.14,43.03},{29.65,44.95},{63.12,27.52},{35.92,43.02},{30.34,45.59},{30.45,43.29},{35.61,42.16},{60.71,27.18},{61.84,26.94},{34.59,41.28},{30.13,44.64},{63.21,27.91},{34.66,40.92},{30.65,45.02},{29.44,45.08},{36.18,39.21},{61.66,27.86},{58.51,28.79},{58.57,28.83},{37.0,41.93},{57.7,28.3},{61.57,29.4},{62.63,30.69},{57.69,26.06},{58.58,26.86},{58.11,26.5},{58.91,27.1},{58.56,28.13},{60.77,28.36},{59.71,28.85}}},
        },
        [1544] = { -- Vile Fin Minor Oracle
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{75.13,26.54},{34.73,40.81},{63.4,27.82},{34.45,41.6},{29.83,44.78},{36.36,44.57},{35.97,42.89},{29.16,45.85},{30.81,44.94},{62.94,28.8},{63.09,29.49},{60.93,27.21},{26.24,46.34},{35.6,43.33},{35.79,39.49},{75.15,26.93},{67.42,24.47},{67.34,24.85},{31.07,43.17},{37.01,40.78},{30.65,43.62},{34.96,40.76},{35.83,43.5},{62.26,28.28},{62.76,28.28},{33.66,42.8},{31.37,43.75},{70.54,25.74},{67.48,25.78},{35.56,44.27},{34.62,43.51},{30.47,43.37},{36.83,45.09},{30.69,43.22},{64.03,28.69},{26.07,47.28},{64.54,29.79},{64.86,29.74},{67.9,25.4},{70.45,25.27},{58.34,28.13},{36.53,35.95},{36.43,40.6},{36.7,42.02},{64.04,30.62},{61.3,29.99},{61.73,28.2},{57.89,26.3},{58.45,27.59},{58.85,27.08},{60.15,27.28},{59.43,29.07},{59.75,28.88},{59.39,28.35},{60.86,27.58},{60.07,28.38}}},
        },
        [1545] = { -- Vile Fin Muckdweller
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{70.06,24.97},{68.7,25.42},{73.46,24.98},{67.7,28.47},{64.54,29.07},{67.57,27.31},{66.88,26.26},{74.56,26.4},{72.69,26.41},{34.81,44.96},{38.08,29.5},{72.01,27.25},{74.08,26.17},{66.72,28.12},{65.21,30.43},{66.16,29.79},{67.54,29.5},{65.31,28.61},{65.96,27.37},{72.34,25.62},{74.8,27.09},{34.84,42.43},{29.85,41.5},{25.3,47.35},{26.0,48.35},{75.45,26.39},{74.97,27.63},{68.01,28.64},{75.66,26.13},{72.54,26.1},{73.31,27.16},{69.61,26.01},{30.51,42.77},{34.29,43.59},{75.09,26.76},{75.57,26.38},{64.56,29.62},{64.66,30.38},{64.72,30.36},{75.17,27.39},{69.06,25.45},{70.17,25.63},{35.76,41.45},{26.81,46.77},{25.48,48.47},{75.39,26.91},{64.44,29.68},{70.42,27.12},{71.23,26.17},{66.99,26.17},{72.01,25.22},{68.22,26.06},{67.8,25.84},{38.58,30.57},{39.55,34.75},{38.01,35.1},{40.88,34.96},{36.53,38.39},{36.53,40.63},{36.44,42.63}}},
        },
        [1553] = { -- Greater Duskbat
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{41.71,57.42},{41.77,40.32},{44.6,49.41},{49.98,48.54},{65.88,53.24},{67.04,56.56},{62.48,41.77},{62.49,43.54},{65.42,38.58},{50.89,59.33},{49.21,59.63},{41.13,47.43},{41.45,56.92},{51.36,49.55},{46.81,50.28},{46.75,50.84},{65.18,41.74},{67.08,51.8},{65.49,56.61},{63.28,47.06},{40.06,52.66},{36.49,47.27},{37.93,43.91},{37.31,43.48},{44.46,50.13},{45.23,51.2},{62.9,35.81},{64.29,46.01},{64.17,44.13},{46.67,60.16},{49.49,49.69},{62.3,43.91},{62.97,45.96},{64.77,50.15},{60.45,43.15},{64.04,54.89},{64.73,40.44},{41.08,42.21},{42.32,44.19},{63.16,38.69},{63.28,41.72},{61.77,41.38},{43.28,56.19},{37.44,46.4},{62.21,36.85},{60.91,38.49},{64.33,36.57},{37.5,38.75},{64.88,38.2},{62.87,44.02},{64.09,37.77},{66.67,62.26},{41.9,53.66},{40.13,55.64},{38.48,38.57},{40.31,48.65},{42.47,42.37},{59.98,41.84},{65.07,54.57},{45.54,58.9},{39.14,47.79},{66.53,53.61},{39.31,42.22},{53.63,64.97},{63.67,49.22},{66.83,55.91},{55.75,61.0},{56.59,62.94},{51.87,48.39},{46.8,52.52},{55.05,64.03},{55.5,63.43},{47.25,46.41},{54.22,65.86},{47.93,45.09},{45.69,52.54},{42.98,57.33},{61.65,38.76},{43.26,41.51},{66.28,54.51},{63.27,47.58},{71.01,63.81},{64.46,57.33},{68.26,62.85},{45.42,57.32},{46.58,58.0},{69.05,53.87},{42.75,47.67},{48.81,57.69},{53.38,64.14},{45.84,54.41},{45.86,56.37},{54.08,61.72},{54.99,62.57},{52.49,63.5},{43.1,46.2},{61.1,56.3},{67.99,54.12},{43.77,55.87},{58.55,56.18},{57.98,55.23},{58.01,57.08},{58.82,58.43},{62.22,56.57},{60.34,60.85},{58.44,57.0},{56.86,55.74},{47.36,55.25},{45.33,54.6},{57.43,59.72},{56.33,57.46},{59.32,61.61},{57.09,54.21},{63.19,49.72},{45.79,54.81},{48.86,55.02},{47.41,56.25},{59.26,56.08},{63.79,61.45},{64.72,58.45}}},
        },
        [1554] = { -- Vampiric Duskbat
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{71.91,33.74},{65.79,34.95},{66.16,31.68},{73.69,33.91},{76.39,30.31},{72.81,30.56},{49.12,59.82},{44.43,62.56},{43.12,67.06},{71.24,46.76},{80.08,62.34},{78.58,73.42},{81.94,74.25},{74.75,44.22},{83.58,48.38},{67.49,34.01},{69.66,34.79},{41.63,63.35},{47.52,62.19},{48.62,63.57},{44.72,60.3},{78.7,69.73},{75.65,55.78},{82.23,66.0},{71.15,36.91},{73.44,36.09},{72.68,65.31},{83.74,51.59},{71.06,34.61},{70.44,33.73},{68.55,28.26},{76.8,31.63},{43.95,68.04},{44.93,63.15},{48.38,63.21},{45.34,66.28},{45.55,62.82},{72.77,58.29},{78.19,70.24},{80.68,66.42},{70.96,58.38},{90.39,44.81},{74.16,32.65},{71.84,31.55},{69.7,30.47},{45.88,67.28},{42.07,59.36},{44.88,69.1},{80.18,64.27},{74.19,71.5},{72.64,37.19},{74.58,58.68},{78.61,71.69},{88.7,42.83},{71.24,30.5},{68.19,32.83},{69.71,32.85},{65.48,33.81},{64.49,36.56},{41.63,60.87},{46.27,61.55},{43.24,63.05},{76.14,63.72},{75.78,51.26},{79.34,70.72},{69.79,60.66},{74.99,52.96},{78.84,62.44},{82.82,46.29},{87.29,38.45},{84.85,39.1},{73.27,29.22},{40.62,60.04},{47.95,67.82},{73.04,39.29},{82.03,64.61},{76.41,66.18},{71.18,48.21},{79.58,69.23},{70.52,61.23},{80.5,59.27},{81.28,66.52},{72.69,47.08},{75.45,47.13},{83.06,44.32},{73.97,67.34},{75.72,47.92},{83.65,66.33},{80.7,70.51},{72.08,59.83},{75.47,72.43},{72.77,62.58},{80.08,72.81},{87.28,40.63},{90.37,42.78},{84.63,40.78},{71.7,49.04},{74.55,47.25},{76.95,71.27},{80.36,67.74},{71.26,50.06},{73.37,59.35},{78.73,64.6},{73.26,40.59},{46.85,66.39},{48.71,61.97},{72.86,42.64},{75.38,35.09},{50.71,61.71},{79.25,58.98},{80.66,46.27},{73.2,44.29},{76.61,72.33},{73.67,57.12},{42.17,58.58},{51.39,61.76},{52.88,63.65},{51.92,63.37},{70.18,53.68},{75.44,46.14},{84.13,43.06},{79.28,48.69},{82.9,42.61},{82.52,42.77},{84.37,44.89},{78.98,45.89},{82.22,52.76},{78.64,44.93},{81.14,48.19},{80.04,44.52},{74.89,64.03},{77.67,46.19},{76.79,48.29},{74.88,33.72}}},
        },
        [1569] = { -- Shadow Priest Sarvis
            [npcKeys.questStarts] = {3095,3096,3097,3098,3099,24962,24972,26801},
        },
        [1654] = { -- Gregor Agamand
            [npcKeys.waypoints] = {},
        },
        [1656] = { -- Thurman Agamand
            [npcKeys.waypoints] = {},
        },
        [1661] = { -- Novice Elreth
            [npcKeys.questEnds] = {376,6395,24961,28651},
        },
        [1694] = { -- Loslor Rudge
            [npcKeys.questStarts] = {5541},
        },
        [1748] = { -- Highlord Bolvar Fordragon
            [npcKeys.questStarts] = {},
        },
        [1750] = { -- Grand Admiral Jes-Tereth
            [npcKeys.questStarts] = {26370},
            [npcKeys.questEnds] = {},
        },
        [1853] = { -- Darkmaster Gandling
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_HEADMASTERS_STUDY] = {{68.52,30.14}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [1872] = { -- Tharek Blackstone
            [npcKeys.questStarts] = {400,415},
        },
        [1959] = { -- Mountaineer Barleybrew
            [npcKeys.questStarts] = {414,26131},
        },
        [2038] = { -- Lord Melenas
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{52.95,43.95}}},
        },
        [2039] = { -- Ursal the Mauler
            [npcKeys.waypoints] = {},
        },
        [2055] = { -- Master Apothecary Faranell
            [npcKeys.questStarts] = {515},
        },
        [2070] = { -- Moonstalker Runt
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{45.27,61.66},{41.75,63.49},{43.12,63.94},{41.47,65.86},{39.22,69.96},{39.94,70.13},{41.28,88.16},{45.73,89.78},{38.47,90.28}}},
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
        },
        [2077] = { -- Melithar Staghelm
            [npcKeys.questStarts] = {3116,3117,3118,3119,3120,26841,28715},
        },
        [2079] = { -- Ilthalaine
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL] = {
                    {57.97,39.2,phases.ILTHALAINE_AT_BENCH},
                    {58.13,38.94,phases.ILTHALAINE_AT_ROAD},
                },
            },
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {3116,3117,3118,3119,3120,26841,28713,28714,28734},
        },
        [2081] = { -- Sentinel Kyra Starsong
            [npcKeys.questStarts] = {13945},
        },
        [2119] = { -- Dannal Stern
            [npcKeys.questStarts] = {24969,28651},
            [npcKeys.questEnds] = {3095,24969},
        },
        [2122] = { -- David Trias
            [npcKeys.questStarts] = {3096,24967,28651},
            [npcKeys.questEnds] = {3096,24967},
        },
        [2123] = { -- Dark Cleric Duesten
            [npcKeys.questStarts] = {24966,28651},
            [npcKeys.questEnds] = {3097,24966},
        },
        [2124] = { -- Isabella
            [npcKeys.questStarts] = {24965,28651},
            [npcKeys.questEnds] = {3098,24965},
        },
        [2126] = { -- Maximillion
            [npcKeys.questStarts] = {24968,28651},
            [npcKeys.questEnds] = {3099,24968},
        },
        [2151] = { -- Moon Priestess Amara
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{49.35,44.67}}},
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {487,1684},
        },
        [2155] = { -- Sentinel Shayla Nightbreeze
            [npcKeys.questStarts] = {},
        },
        [2198] = { -- Crier Goodman
            [npcKeys.questStarts] = {7494},
        },
        [2229] = { -- Krusk
            [npcKeys.questStarts] = {1361,28620},
        },
        [2249] = { -- Ferocious Yeti
            [npcKeys.name] = "Ferocious Yeti",
        },
        [2373] = { -- Mudsnout Shaman
            [npcKeys.questStarts] = {28355},
        },
        [2425] = { -- Varimathras
            [npcKeys.questEnds] = {1048,1978,5725},
        },
        [2487] = { -- Fleet Master Seahorn
            [npcKeys.spawns] = {
                [zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {
                    {41.09,73.27,phases.BOOTY_BAY_REGULAR},
                    {41.53,72.95,phases.BOOTY_BAY_ATTACK},
                },
            },
        },
        [2500] = { -- Captain Hecklebury Smotts
            [npcKeys.spawns] = {
                [zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {
                    {40.32,67.79,phases.BOOTY_BAY_REGULAR},
                    {39.97,67.32,phases.BOOTY_BAY_ATTACK},
                },
            },
        },
        [2504] = { -- Donyal Tovald
            [npcKeys.questStarts] = {579},
        },
        [2542] = { -- Catelyn the Blade
            [npcKeys.questEnds] = {603,610,612},
        },
        [2545] = { -- "Pretty Boy" Duncan
            [npcKeys.questStarts] = {26635},
        },
        [2546] = { -- Fleet Master Firallon
            [npcKeys.spawns] = {
                [zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {
                    {46.7,95.34,phases.BOOTY_BAY_REGULAR},
                    {35.66,66.74,phases.BOOTY_BAY_ATTACK},
                },
            },
        },
        [2594] = { -- Sprogger
            [npcKeys.spawns] = {
                [zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {
                    {40.26,67.84,phases.BOOTY_BAY_REGULAR},
                    {39.93,67.3,phases.BOOTY_BAY_ATTACK},
                },
            },
        },
        [2611] = { -- Fozruk
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{43.67,67.08}}},
            [npcKeys.waypoints] = {},
        },
        [2612] = { -- Lieutenant Valorcall
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{37.95,55.71}}},
            [npcKeys.waypoints] = {[zoneIDs.ARATHI_HIGHLANDS] = {{{37.95,55.71},{37.75,56.48},{37.57,56.98},{37.24,56.82},{36.99,56.63},{36.59,56.50},{36.25,56.50},{36.19,56.50},{35.67,56.50},{35.10,56.51}}}},
        },
        [2635] = { -- Elder Snapjaw Crocolisk
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{47.34,56.16},{49.29,55.17},{50.4,53.29},{48.74,50.01},{48.5,52.19},{50.83,50.83},{50.82,49.58},{50.9,48.22},{49.79,44.5}}},
        },
        [2670] = { -- Xizk Goodstitch
            [npcKeys.questStarts] = {4785},
        },
        [2696] = { -- Foggy MacKreel
            [npcKeys.questStarts] = {647},
        },
        [2714] = { -- Forsaken Courier
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{51.03,64.80}}},
            [npcKeys.waypoints] = {[zoneIDs.ARATHI_HIGHLANDS] = {{{51.03,64.80},{51.17,64.82},{51.32,64.77},{51.45,64.70},{51.66,64.61},{52.06,64.53},{52.22,64.58},{52.38,64.64},{52.70,64.76},{53.06,64.85}}}},
        },
        [2748] = { -- Archaedas
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN_KHAZ_GOROTHS_SEAT] = {{55.29,50.56}},[zoneIDs.ULDAMAN] = {{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [2755] = { -- Myzrael
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{57.3,34.58}}},
        },
        [2783] = { -- Marez Cowl
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{23.11,64.82}}},
        },
        [2964] = { -- Windfury Sorceress
            [npcKeys.spawns] = {
                [zoneIDs.MULGORE] = {{34.12,28.06},{33.51,30.48},{34.68,26.31},{32.96,26.33},{31.81,28.09},{31.01,28.9},{31.13,28.04},{30.34,27.01},{29.58,22.98},{30.3,24.52},{31.94,26.01},{30.62,26.01},{31.23,25.43},{31.44,24.26},{30.96,23.84},{30.5,22.24},{31.68,22.15},{32.15,21.59},{33,21.67},{54.87,17.8},{55.82,18.38},{55.76,17.33},{56.03,16.44},{55,14.13},{54.2,13.45},{53.9,14.45},{53.78,12.46},{52.57,11.4},{53.22,8.87},{51.9,9.8},{51.17,9.68},{51.65,7.98},{41.06,10.04},{40.09,10.83},{39.96,8.73},{38.6,8.65},{38.64,10.73},{39.4,11.43},{55.44,19.75},{32.74,23.61}},
                [zoneIDs.THUNDER_BLUFF] = {{12.66,28.9}},
            },
        },
        [2965] = { -- Windfury Matriarch
            [npcKeys.spawns] = {
                [zoneIDs.MULGORE] = {{32.29,27.02},{33.67,25.74},{32.8,25.28},{33.16,27.58},{33.89,26.71},{34.98,27.34},{34.77,28.72},{34.26,29.79},{33.35,29.03},{32.68,29.9},{32.5,28.84},{31.73,29.16},{31.36,26.77},{30.77,24.76},{30.37,23.36},{30.85,21.47},{31.53,21.18},{31.09,22.54},{31.52,23.36},{32.18,23.45},{32.49,22.48},{40.76,10.77},{40.36,9.71},{40.72,8.89},{41.41,7.81},{40.43,7.95},{39.43,8.09},{38.67,9.84},{38.56,12.08},{55.3,18.71},{55.89,15.44},{55.59,14.57},{54.85,12.95},{55.07,12.39},{54.68,11.54},{53.32,13.21},{52.39,12.33},{51.77,11.21},{53.37,10.66},{53.45,9.77},{52.56,8.07},{52.07,8.8},{51.13,8.58},{50.53,7.76}},
                [zoneIDs.THUNDER_BLUFF] = {{17.31,33.02},{15.11,24.27}},
            },
        },
        [2988] = { -- Morin Cloudstalker
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {749,764,765,26179,26180},
            [npcKeys.questEnds] = {751,764,765,24459,26179,26180},
        },
        [2993] = { -- Baine Bloodhoof
            [npcKeys.questStarts] = {746},
        },
        [3032] = { -- Beram Skychaser
            [npcKeys.questStarts] = {8410},
        },
        [3034] = { -- Sheal Runetotem
            [npcKeys.questStarts] = {27283,28289},
        },
        [3036] = { -- Kym Wildmane
            [npcKeys.questStarts] = {64049,64051,64053,64128,64217,70761,70764,70765,70865,78151,78158,78167,78168,82989,88782,88785,88793,88801},
            [npcKeys.questEnds] = {64047,64049,64051,64053,70761,70762,70764,70765,78138,78151,78158,78167,88779,88782,88785,88793},
        },
        [3039] = { -- Holt Thunderhorn
            [npcKeys.questStarts] = {8151,27278,28297},
        },
        [3045] = { -- Malakai Cross
            [npcKeys.questStarts] = {27331,27332,27334,27335,28164,28304,28307,28308,28309,28323},
        },
        [3047] = { -- Archmage Shymm
            [npcKeys.questStarts] = {8250,27277,28300},
        },
        [3056] = { -- Ghost Howl
            [npcKeys.waypoints] = {},
        },
        [3060] = { -- Gart Mistrunner
            [npcKeys.questStarts] = {27067},
        },
        [3140] = { -- Lar Prowltusk
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{55.42,75.1}}},
            [npcKeys.waypoints] = {},
        },
        [3143] = { -- Gornek
            [npcKeys.questStarts] = {2383,3087,3088,3089,3090,25126,25127,25138,25172},
        },
        [3145] = { -- Zureetha Fargaze
            [npcKeys.questEnds] = {1499,25131,25132},
        },
        [3153] = { -- Frang
            [npcKeys.questStarts] = {25147},
            [npcKeys.questEnds] = {2383,25147},
        },
        [3154] = { -- Jen'shan
            [npcKeys.questEnds] = {3087},
        },
        [3155] = { -- Rwag
            [npcKeys.questStarts] = {25141},
            [npcKeys.questEnds] = {3088,25141},
        },
        [3156] = { -- Nartok
            [npcKeys.questStarts] = {25145},
            [npcKeys.questEnds] = {3090,25145},
        },
        [3157] = { -- Shikrik
            [npcKeys.questStarts] = {25143},
            [npcKeys.questEnds] = {3089,25143},
        },
        [3203] = { -- Fizzle Darkclaw
            [npcKeys.waypoints] = {},
        },
        [3230] = { -- Nazgrel
            [npcKeys.questStarts] = {9400,9405,9495,10121,10136,10390,10391,10392,10756,10876},
            [npcKeys.questEnds] = {9401,9406,9495,9588,9608,10046,10135,10136,10291,10388,10390,10391,10392,10401,10559,10755,10875,10876,11003},
        },
        [3233] = { -- Lorekeeper Raintotem
            [npcKeys.questStarts] = {773,833},
        },
        [3256] = { -- Sunscale Scytheclaw
            [npcKeys.questStarts] = {},
        },
        [3324] = { -- Grol'dar
            [npcKeys.questStarts] = {64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167,88778,88782,88785,88789},
        },
        [3326] = { -- Zevrost
            [npcKeys.questStarts] = {3631,8419,27402,28459},
            [npcKeys.questEnds] = {27282,28299,28459},
        },
        [3328] = { -- Ormok
            [npcKeys.questStarts] = {6681,8233,64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167,88778,88782,88785,88789},
        },
        [3338] = { -- Sergra Darkthorn
            [npcKeys.questStarts] = {845,881,903,905,13991},
        },
        [3344] = { -- Kardris Dreamseeker
            [npcKeys.questStarts] = {27397,28465,64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {27280,28301,28465,64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167,88778,88782,88785,88789},
        },
        [3352] = { -- Ormak Grimshot
            [npcKeys.questStarts] = {8151,27395,28461},
        },
        [3353] = { -- Grezz Ragefist
            [npcKeys.questStarts] = {27365,28457,64048,64050,64052,64063,64064,70734,70735,70736,70737,70869,78167,78168,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {27281,28290,28457,64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167,88778,88782,88785,88789},
        },
        [3354] = { -- Sorek
            [npcKeys.questStarts] = {1718,1823,8417},
        },
        [3362] = { -- Ogunaro Wolfrunner
            [npcKeys.questStarts] = {7660,7661},
            [npcKeys.questEnds] = {7660,7661},
        },
        [3266] = { -- Razormane Defender
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{65.28,56.26},{65.19,54.06},{65.12,53.88},{64.28,54.68},{64.24,55.58},{63.77,54.4},{66.12,52.2},{66.04,52.19},{64.94,52.21},{63.87,55.36},{66.05,52.43},{64.36,54.28},{65.23,54.48},{63.95,53.95},{66.08,52.52},{65,53.19},{65.02,52.77},{63.75,54.38},{64.51,54.48},{66.15,52.31},{64.91,53.95},{64.15,55.48},{65.4,54.7},{65.25,54.28},{64.97,52.63}}},
        },
        [3341] = { -- Gann Stonespire
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{49.22,82.38}}},
            [npcKeys.waypoints] = {},
        },
        [3383] = { -- Southsea Cutthroat
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{79.73,91},{79.77,91.37},{76.89,91.24},{76.88,91.38},{76.61,90.62},{77.11,90.4},{78.02,88.61},{77.61,90.1},{77.85,90.62},{77.48,89.28},{76.04,89.33},{77.76,89.49},{77.71,89.52},{77.14,90.11},{75.6,89.58},{75.65,89.65},{76.45,90.16},{77.77,88.19},{75.25,89.75},{75.65,89.67},{76.25,90.15},{76.9,91.22},{76.87,91.27}}},
        },
        [3389] = { -- Regthar Deathgate
            [npcKeys.questStarts] = {851,852,855,4021},
        },
        [3391] = { -- Gazlowe
            [npcKeys.questStarts] = {14034,14038,14042,14045,14050,26701,26702,26769},
        },
        [3394] = { -- Barak Kodobane
            [npcKeys.waypoints] = {},
        },
        [3395] = { -- Verog the Dervish
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{51.0,78.8}}},
        },
        [3396] = { -- Hezrul Bloodmark
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{39.24,70.23}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS] = {{{39.24,70.23},{39.29,70.23},{39.38,70.22},{39.47,70.23},{39.55,70.28},{39.60,70.38},{39.66,70.48},{39.72,70.57},{39.73,70.58},{39.75,70.61},{39.82,70.70},{39.88,70.79},{39.89,70.81},{39.91,70.83},{39.97,70.92},{40.02,70.99},{40.04,71.03},{40.08,71.14},{40.12,71.26},{40.16,71.37},{40.18,71.45},{40.17,71.54},{40.15,71.67},{40.13,71.79},{40.11,71.92},{40.09,72.03},{40.10,72.06},{40.14,72.18},{40.14,72.18},{40.16,72.25},{40.20,72.37},{40.23,72.50},{40.25,72.58},{40.28,72.68},{40.31,72.80},{40.34,72.88},{40.39,72.96},{40.46,73.04},{40.52,73.13},{40.59,73.21},{40.62,73.24},{40.65,73.28},{40.71,73.36},{40.75,73.41},{40.79,73.45},{40.83,73.49},{40.85,73.51},{40.92,73.59},{40.98,73.66},{41.05,73.73},{41.12,73.81},{41.19,73.89},{41.26,73.97},{41.29,74.02},{41.35,74.11},{41.38,74.15},{41.40,74.17},{41.46,74.26},{41.51,74.33},{41.58,74.42},{41.63,74.44},{41.70,74.46},{41.75,74.47},{41.80,74.49},{41.89,74.52},{41.91,74.53},{41.96,74.55},{42.05,74.58},{42.13,74.62},{42.21,74.66},{42.30,74.70},{42.38,74.75},{42.45,74.78},{42.50,74.81},{42.58,74.86},{42.66,74.90},{42.74,74.93},{42.83,74.94},{42.87,74.94},{42.90,74.94},{42.98,74.95},{43.05,74.95},{43.10,74.96},{43.19,74.96},{43.27,74.96},{43.36,74.93},{43.39,74.91},{43.47,74.88},{43.55,74.85},{43.55,74.73},{43.55,74.60},{43.55,74.51},{43.55,74.38},{43.55,74.25},{43.51,74.22},{43.44,74.20},{43.40,74.19},{43.32,74.16},{43.24,74.11},{43.19,74.04},{43.15,73.98},{43.09,73.89},{43.02,73.80},{43.01,73.77},{42.99,73.72},{42.94,73.61},{42.90,73.49},{42.89,73.47},{42.87,73.43},{42.83,73.31},{42.81,73.26},{42.79,73.20},{42.74,73.09},{42.70,72.97},{42.67,72.85},{42.64,72.73},{42.61,72.60},{42.58,72.48},{42.56,72.38},{42.54,72.29},{42.51,72.17},{42.48,72.05},{42.41,71.97},{42.34,71.90},{42.29,71.87},{42.23,71.81},{42.16,71.75},{42.08,71.69},{42.00,71.63},{41.92,71.58},{41.84,71.53},{41.83,71.52},{41.82,71.51},{41.74,71.46},{41.66,71.41},{41.60,71.37},{41.58,71.37},{41.50,71.32},{41.42,71.28},{41.33,71.24},{41.25,71.20},{41.25,71.20},{41.22,71.19},{41.19,71.18},{41.12,71.15},{41.04,71.11},{40.95,71.07},{40.87,71.02},{40.81,70.99},{40.78,70.98},{40.70,70.93},{40.62,70.90},{40.56,71.00},{40.52,71.10},{40.49,71.21},{40.47,71.24},{40.46,71.27},{40.42,71.39},{40.39,71.51},{40.34,71.54},{40.25,71.56},{40.19,71.62},{40.17,71.68},{40.16,71.78},{40.16,71.79},{40.12,71.90},{40.09,71.99},{40.02,72.06},{39.96,72.14},{39.88,72.19},{39.79,72.21},{39.70,72.21},{39.64,72.22},{39.64,72.22},{39.56,72.23},{39.54,72.23},{39.49,72.25},{39.40,72.27},{39.32,72.29},{39.23,72.31},{39.21,72.31},{39.16,72.32},{39.11,72.32},{39.03,72.32},{38.97,72.29},{38.93,72.20},{38.89,72.08},{38.85,72.04},{38.80,72.04},{38.78,72.04},{38.70,72.07},{38.62,72.10},{38.54,72.14},{38.46,72.19},{38.39,72.27},{38.39,72.39},{38.43,72.51},{38.46,72.56},{38.49,72.60},{38.55,72.68},{38.62,72.76},{38.69,72.81},{38.76,72.76},{38.83,72.69},{38.90,72.61},{38.95,72.50},{38.97,72.44},{38.97,72.43},{39.04,72.34},{39.07,72.30},{39.06,72.28},{38.99,72.19},{38.92,72.13},{38.88,72.01},{38.87,71.88},{38.83,71.76},{38.80,71.71},{38.75,71.65},{38.71,71.60},{38.65,71.52},{38.63,71.46},{38.63,71.45},{38.64,71.32},{38.66,71.19},{38.69,71.07},{38.74,70.96},{38.80,70.87},{38.80,70.86},{38.82,70.82},{38.89,70.73},{38.95,70.65},{39.02,70.57},{39.09,70.49},{39.11,70.46},{39.15,70.42},{39.22,70.34},{39.23,70.32},{39.24,70.23}}}},
        },
        [3412] = { -- Nogg
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{56.28,56.36}}},
            [npcKeys.waypoints] = {[zoneIDs.ORGRIMMAR] = {{{56.28,56.36},{56.74,57.02}}}},
        },
        [3438] = { -- Kreenig Snarlsnout
            [npcKeys.waypoints] = {},
        },
        [3448] = { -- Tonga Runetotem
            [npcKeys.questStarts] = {870,13988,26878},
        },
        [3467] = { -- Baron Longshore
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS]={{69.91,85.2}}},
        },
        [3475] = { -- Echeyakee
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{44.82,47.71}}},
        },
        [3489] = { -- Zargh
            [npcKeys.questStarts] = {},
        },
        [3494] = { -- Tinkerwiz
            [npcKeys.questStarts] = {3635},
        },
        [3515] = { -- Corithras Moonrage
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL] = {
                    {41.07,45.66,phases.CORITHRAS_AT_CROSSROAD},
                    {55.82,53.9,phases.CORITHRAS_AT_DOLANAAR},
                },
            },
        },
        [3535] = { -- Blackmoss the Fetid
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{52.04,63.66}}},
        },
        [3568] = { -- Mist
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{34.49,27.82}}},
        },
        [3593] = { -- Alyissia
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{58.85,33.74}}},
            [npcKeys.questStarts] = {26945,28723},
            [npcKeys.questEnds] = {3116,26945},
        },
        [3594] = { -- Frahun Shadewhisper
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{58.85,33.92}}},
            [npcKeys.questStarts] = {26946,28723},
            [npcKeys.questEnds] = {3118,26946},
        },
        [3595] = { -- Shanda
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{58.45,35.47}}},
            [npcKeys.questStarts] = {26949,28723},
            [npcKeys.questEnds] = {3119,26949},
        },
        [3596] = { -- Ayanna Everstride
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{58.85,35.74}}},
            [npcKeys.questStarts] = {26947,28723},
            [npcKeys.questEnds] = {3117,26947},
        },
        [3597] = { -- Mardant Strongoak
            [npcKeys.questStarts] = {26948,28723},
            [npcKeys.questEnds] = {3120,26948},
        },
        [3598] = { -- Kyra Windblade
            [npcKeys.questStarts] = {1684},
        },
        [3600] = { -- Laurna Morninglight
            [npcKeys.questStarts] = {5629},
        },
        [3615] = { -- Devrak
            [npcKeys.questStarts] = {},
        },
        [3630] = { -- Deviate Coiler
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{38.91,64.37},{39.23,65.56},{38.96,67.35},{39.2,66.28}}},
        },
        [3631] = { -- Deviate Stinglash
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{44.38,61.89}}},
        },
        [3632] = { -- Deviate Creeper
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{39.5,62.33},{39.32,66.6},{38.85,67.96},{38.81,64.32},{38.72,63.5},{39.07,62.56},{40.01,65.52},{39.37,65.58},{39.98,66.49},{38.58,65.32}}},
        },
        [3633] = { -- Deviate Slayer
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{43.35,61.96},{43.96,61.59},{43.84,62.5},{44.62,62.8},{44.56,63.89},{44.2,65.11},{43.1,65.62},{42.64,61.83},{42.36,62.68},{41.9,63.04},{41.9,62.23},{41.4,62.88}}},
        },
        [3634] = { -- Deviate Stalker
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{39.94,66.58},{41.01,62.85},{43.95,62.28},{40.19,65.74},{38.65,65.32}}},
        },
        [3636] = { -- Deviate Ravager
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{48.39,45.64},{46,45.54},{50.79,38.64},{49.59,38.37},{42.86,32.87},{40.26,27.45},{37.69,25.77},{27.1,33.14},{26.72,35.88},{38.41,39.62},{36.99,39.74},{39.99,50.5},{-1,-1}}},
        },
        [3637] = { -- Deviate Guardian
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{41.95,39.96},{47.02,42.99},{36.67,32.34},{41.42,28.63},{33.92,27.65},{30.51,30.14},{28.72,32.69},{32.63,41.75},{38.4,46.09},{36.99,45.76},{35,51.77},{33.92,51.32},{-1,-1}}},
        },
        [3649] = { -- Thundris Windweaver
            [npcKeys.questStarts] = {1442},
        },
        [3653] = { -- Kresh
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{37.81,35.43},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.WAILING_CAVERNS] = {{{14.2,43.5},{15.69,46.26},{17.65,46.19},{19.84,45.63},{21.57,45.68},{23.06,46.14},{24.37,46.62},{25.11,46.24},{25.72,44.99},{26.7,42.51},{27.81,40.42},{29.42,38.71},{30.94,37.3},{32.37,36.57},{33.97,35.84},{36.16,35.49},{37.81,35.43},{40.09,35.65},{42.47,36.31},{44.26,37.3},{45.87,38.63},{47.53,40.3},{49.31,42.15},{50.64,43},{51.43,43.3},{52,44.52},{52.24,47.12},{52.85,48.7},{52.75,49.85},{52.39,51.58},{52.16,53.91},{52.27,56.27},{52.79,57.56},{53.97,58.66},{55.13,59.21},{56.19,59.09},{56.77,59.09},{58.43,59.18},{59.4,59.68},{59.79,60.95},{60.4,63.08},{60.96,65.24}}}},
        },
        [3654] = { -- Mutanus the Devourer
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{31.77,10.1},{-1,-1}}},
        },
        [3664] = { -- Ilkrud Magthrull
            [npcKeys.name] = "Ilkrud Magthrull",
        },
        [3665] = { -- Crane Operator Bigglefuzz
            [npcKeys.questStarts] = {959},
        },
        [3669] = { -- Lord Cobrahn
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{15.57,58.42},{-1,-1}}},
        },
        [3670] = { -- Lord Pythas
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{20.09,41.54},{-1,-1}}},
        },
        [3671] = { -- Lady Anacondra
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{30.49,43.14},{-1,-1}}},
        },
        [3673] = { -- Lord Serpentis
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{62.46,53.26},{-1,-1}}},
        },
        [3674] = { -- Skum
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{61.09,71.6},{-1,-1}}},
        },
        [3685] = { -- Harb Clawhoof
            [npcKeys.questStarts] = {7662,7663},
            [npcKeys.questEnds] = {7662,7663},
        },
        [3690] = { -- Kar Stormsinger
            [npcKeys.questEnds] = {14087},
        },
        [3694] = { -- Sentinel Selarin
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{42.51,45.15}}},
        },
        [3743] = { -- Foulweald Warrior
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{57.95,64.51},{57.41,65.48},{55.55,62.03},{54.4,61.56},{54.56,63.04},{56.44,64.89},{56.87,64.78},{53.97,62.46},{53.72,61.15},{53.58,63.74},{55.9,62.87}}},
        },
        [3745] = { -- Foulweald Pathfinder
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{55.29,62.32},{56.84,65.52},{53.93,61.52}}},
            [npcKeys.waypoints] = {},
        },
        [3750] = { -- Foulweald Totemic
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{52.9,63.05},{56.71,65.74},{56.27,62.05},{54.07,63.26},{54.17,64.09},{53.91,64.36},{54.87,62.01},{56.19,65.05},{56.93,62.49},{57.35,64.18},{54.2,61.33},{53.39,62.97},{55.22,63.14}}},
        },
        [3887] = { -- Baron Silverlaine
            [npcKeys.spawns] = {
                [zoneIDs.SHADOWFANG_KEEP] = {{-1,-1}},
                [zoneIDs.SHADOWFANG_KEEP_DINING_HALL] = {{31.14,74.22}},
            },
        },
        [3894] = { -- Pelturas Whitemoon
            [npcKeys.questStarts] = {13919,14018,26475},
        },
        [3901] = { -- Illiyana
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{87.1,43.49}}},
        },
        [3943] = { -- Ruuzel
            [npcKeys.waypoints] = {},
        },
        [3974] = { -- Interrogator Vishas
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_LIBRARY] = {{30.9,87.6}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [3975] = { -- Herod
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{78.6,10.7}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [3976] = { -- Scarlet Commander Mograine
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_CATHEDRAL] = {{49.1,27}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [3977] = { -- High Inquisitor Whitemane
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_CATHEDRAL] = {{49.1,16.9}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [3983] = { -- Interrogator Vishas
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{71.5,58.9},{-1,-1}}},
        },
        [3987] = { -- Dal Bloodclaw
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{41.66,35.7}}},
            [npcKeys.waypoints] = {},
        },
        [4090] = { -- Astarii Starseeker
            [npcKeys.questStarts] = {28285},
        },
        [4202] = { -- Gerenzo Wrenchwhistle
            [npcKeys.questStarts] = {},
        },
        [4205] = { -- Dorion
            [npcKeys.questStarts] = {8151},
        },
        [4214] = { -- Erion Shadewhisper
            [npcKeys.questStarts] = {6681,27267,28262},
        },
        [4217] = { -- Mathrengyl Bearwalker
            [npcKeys.questStarts] = {26,3803,9063,27273,28289},
        },
        [4260] = { -- Venture Co. Shredder
            [npcKeys.waypoints] = {},
        },
        [4278] = { -- Commander Springvale
            [npcKeys.spawns] = {
                [zoneIDs.SHADOWFANG_KEEP] = {{27.6,58.59},{-1,-1}}},
        },
        [4289] = { -- Scarlet Evoker
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{69.25,63.05},{71.08,26.12},{78.1,47.6},{78.1,41.5}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{{78.36,20.34},{67.72,20.46},{67.48,26.37},{74.45,26.56}},{{67.37,72.56},{67.57,63.23},{67.67,63.09},{74.58,62.86}},{{78.1,47.6},{77.32,49.88},{74.68,50.85},{74.38,56.6},{71.1,56.67}},{{78.1,41.5},{77.54,39.24},{71.07,38.78},{71.09,33.01},{74.08,32.5}}}},
        },
        [4290] = { -- Scarlet Guardsman
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{75.27,33.31},{74.91,64.31},{79.55,19.9},{77.03,21.53},{67.47,18.92},{67.36,27.63},{67.3,26.58},{67.85,27.05},{75.45,62.94},{71.15,63.5},{71.43,64.13},{70.88,64.13},{75.39,57.69},{75.32,56.36},{73.67,50.63},{74.29,49.57},{67.74,61.7},{67.24,62.52},{70.48,55.6},{70.28,56.99},{74.83,56.96},{74.75,25.52},{75.22,31.92},{70.55,32.96},{73.81,39.18},{79.68,20.76},{80.06,20.05},{72.03,18.99},{74.8,39.3},{74.2,37.6},{71.5,31.6},{70.74,31.48},{75.53,26.79}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [4292] = { -- Scarlet Protector
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{75.27,33.31},{74.91,64.31},{79.55,19.9},{77.03,21.53},{67.47,18.92},{67.36,27.63},{67.3,26.58},{67.85,27.05},{75.45,62.94},{71.15,63.5},{71.43,64.13},{70.88,64.13},{75.39,57.69},{75.32,56.36},{73.67,50.63},{74.29,49.57},{67.74,61.7},{67.24,62.52},{70.48,55.6},{70.28,56.99},{74.83,56.96},{74.75,25.52},{75.22,31.92},{70.55,32.96},{73.81,39.18},{79.68,20.76},{80.06,20.05},{72.03,18.99},{74.8,39.3},{74.2,37.6},{71.5,31.6},{70.74,31.48},{75.53,26.79}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [4295] = { -- Scarlet Myrmidon
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{75.27,33.31},{79.55,19.9},{77.03,21.53},{67.47,18.92},{67.36,27.63},{67.3,26.58},{67.85,27.05},{74.75,25.52},{75.22,31.92},{70.55,32.96},{73.81,39.18},{79.68,20.76},{80.06,20.05},{72.03,18.99},{74.8,39.3},{74.2,37.6},{71.5,31.6},{70.74,31.48},{75.53,26.79}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [4311] = { -- Holgar Stormaxe
            [npcKeys.questEnds] = {},
        },
        [4329] = { -- Firemane Scout
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{48.02,77.44},{44.62,67.29},{48.96,67.34},{45.36,67.2},{38.95,64.54},{38.96,67.08},{38.76,65.81},{38.81,65.85},{37.95,68.24},{44.03,65.3},{51.94,70.68},{43.24,65.08},{42.82,66.37},{44.55,64.76},{45.67,65.85},{45.21,65.28},{49.49,68.38}}},
        },
        [4331] = { -- Firemane Ash Tail
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{48.04,77.19},{48.88,67.29},{36.66,69.42},{39.36,65.32},{39.42,64.46},{40.02,65.31},{42.17,67.18},{39.49,66.15},{38.75,65.71},{38.83,65.65},{38.99,65.82},{44.61,66.35},{45.15,66.21},{43.91,66.08},{44.7,65.45},{51.93,70.63},{43.13,65.89},{49.72,67.98},{37.84,68.22}}},
        },
        [4420] = { -- Overlord Ramtusk
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{56.9,29.8},{-1,-1}}},
        },
        [4421] = { -- Charlga Razorflank
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{26.41,32.39},{-1,-1}}},
        },
        [4422] = { -- Agathelos the Raging
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{11.39,72.5},{-1,-1}}},
        },
        [4424] = { -- Aggem Thorncurse
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{80.84,54.39},{-1,-1}}},
        },
        [4428] = { -- Death Speaker Jargba
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{87.91,41.34},{-1,-1}}},
        },
        [4457] = { -- Murkgill Forager
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{41.28,41.47},{40.52,38.15},{40.94,35.09},{42.05,34.79}}},
        },
        [4461] = { -- Murkgill Warrior
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{42.14,39.23},{44.27,41.8},{41.89,42.57},{40.32,40.08},{40.47,38.96},{41.23,39.03},{40.75,38.24},{39.79,35.82},{40.19,33.98},{41.49,33.99},{43.53,37.75}}},
        },
        [4479] = { -- Fardel Dabyrie
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{51.08,39.78},{51.14,41.5},{48.94,39.5}}},
        },
        [4484] = { -- Feero Ironhand
            [npcKeys.questStarts] = {976},
        },
        [4508] = { -- Willix the Importer
            [npcKeys.spawns] = {
                [zoneIDs.RAZORFEN_KRAUL] = {
                    {-1,-1},
                    {36.26,31.56,phases.WILLIX_IN_TENT},
                    {65.2,81.21,phases.WILLIX_AT_EXIT},
                },
            },
        },
        [4538] = { -- Kraul Bat
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{13.4,34.6},{11.16,32.48},{12.46,39.97},{11.39,43.7},{10.09,49.16},{6.78,44.9},{10.12,53.2},{12.81,55.77},{12.2,52.2},{15.36,55.58},{19.46,55.57},{18.7,58.62},{-1,-1}}},
        },
        [4539] = { -- Greater Kraul Bat
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{11.01,30.3},{8.74,38.25},{11.18,48.84},{16.84,58.93},{-1,-1}}},
        },
        [4542] = { -- High Inquisitor Fairbanks
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_CATHEDRAL] = {{55.4,26.1}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [4543] = { -- Bloodmage Thalnos
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{24.4,50.8},{-1,-1}}},
        },
        [4563] = { -- Kaal Soulreaper
            [npcKeys.questEnds] = {},
            [npcKeys.questStarts] = {4489,8419,27282,28299},
        },
        [4567] = { -- Pierce Shackleton
            [npcKeys.questStarts] = {8250},
        },
        [4568] = { -- Anastasia Hartwell
            [npcKeys.questStarts] = {2861},
        },
        [4584] = { -- Gregory Charles
            [npcKeys.questStarts] = {6681,27279,28298},
        },
        [4586] = { -- Graham Van Talen
            [npcKeys.questStarts] = {3637},
        },
        [4593] = { -- Christoph Walker
            [npcKeys.questStarts] = {8417,27281,28290},
        },
        [4606] = { -- Aelthalyste
            [npcKeys.questStarts] = {27331,27332,27334,27335,28164,28304,28307,28308,28309,28323},
        },
        [4730] = { -- Lelanai
            [npcKeys.questStarts] = {7671,7672},
            [npcKeys.questEnds] = {7671,7672},
        },
        [4732] = { -- Randal Hunter
            [npcKeys.questEnds] = {14079},
        },
        [4752] = { -- Kildar
            [npcKeys.questEnds] = {14086},
        },
        [4753] = { -- Jartsam
            [npcKeys.questEnds] = {14085},
        },
        [4772] = { -- Ultham Ironhorn
            [npcKeys.questEnds] = {14083},
        },
        [4773] = { -- Velma Warnam
            [npcKeys.questEnds] = {14089},
        },
        [4787] = { -- Scout Thaelrid
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{20.81,75.24},{-1,-1}}},
            [npcKeys.questEnds] = {1198,26460,26881},
        },
        [4798] = { -- Fallenroot Shadowstalker
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{38.09,48.3},{38.47,40.96},{38.99,35.33},{38.91,30.84}},[zoneIDs.BLACKFATHOM_DEEPS] = {{54.71,71.17},{56.97,82.12},{51.18,85.22},{46.9,92.22},{30.89,88.02},{29.3,90.52},{-1,-1}}},
        },
        [4799] = { -- Fallenroot Hellcaller
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{39.33,40.02},{39.33,33.52},{40.86,29.14},{38.68,24.28}},[zoneIDs.BLACKFATHOM_DEEPS] = {{37.85,88.66},{35.7,89.99},{-1,-1}}},
        },
        [4805] = { -- Blackfathom Sea Witch
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{29.71,63.13},{33.82,55.69},{38.99,48.39},{40.24,28.4},{38.03,29.23}},[zoneIDs.BLACKFATHOM_DEEPS] = {{53.4,72.22},{57.38,76},{57.26,80.6},{54.25,87.41},{53.05,88.76},{40.49,93.66},{40.56,92.07},{29.31,86.33},{41.79,67.75},{40.55,67.75},{34.84,75.47},{32.69,68.46},{24.87,65.12},{16.28,44},{18.35,41.15},{18.08,37.11},{29.41,46.91},{26.23,49.67},{30.7,47.66},{-1,-1}}},
        },
        [4807] = { -- Blackfathom Myrmidon
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{29.4,62.16},{33.59,56.7},{39.86,35.35},{38.79,21.91}},[zoneIDs.BLACKFATHOM_DEEPS] = {{51.69,84.29},{35.94,88.39},{28.76,89.35},{40.84,62.99},{39.43,68.06},{38.7,71.25},{30.9,78.72},{32.21,74.12},{24.44,59.09},{22.95,44.35},{29.59,49.08},{33.64,40.05},{32.74,43.03},{35.43,49.23},{-1,-1}}},
        },
        [4809] = { -- Twilight Acolyte
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{40.99,78.75},{41.12,77.18},{41.11,72.18},{46.17,68.55},{39.42,60.2}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4810] = { -- Twilight Reaver
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{43.22,82.34},{40.44,78.18},{37.54,62.82},{38.82,60.46},{37.61,60.53}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4811] = { -- Twilight Aquamancer
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{42.66,81.42},{40.41,72.14},{40.78,70.32},{37.34,65}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4812] = { -- Twilight Loreseeker
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{42.63,82.2},{46.18,65.21},{37.64,64.63},{33.42,70.83},{33.62,71.47}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4813] = { -- Twilight Shadowmage
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{48.69,79.8},{46.52,78.28}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4814] = { -- Twilight Elementalist
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{50.45,77.88},{48.7,76.67},{51.79,87.5},{48.72,86.35},{49.22,84},{46.49,84.83},{45.59,80.67}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4829] = { -- Aku'mai
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{85.55,86.59}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4830] = { -- Old Serra'kis
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_THE_FORGOTTEN_POOL] = {{59.95,52.02}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.BLACKFATHOM_DEEPS_THE_FORGOTTEN_POOL] = {{{59.95,52.02},{58.11,47.1},{57.71,41.35},{57.66,36.28},{56.22,30.91},{57.46,27.41},{59.3,26.43},{61.34,28.38},{63.13,33.6},{64.68,39.56},{65.22,45.23},{63.13,50.23},{59.95,52.02}}}},
        },
        [4831] = { -- Lady Sarevess
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{11.38,40.25},{-1,-1}}},
        },
        [4832] = { -- Twilight Lord Kelris
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{51.83,81.58}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [4887] = { -- Ghamoo-ra
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{32.88,59.94},{-1,-1}}},
        },
        [4949] = { -- Thrall
            [npcKeys.questStarts] = {},
        },
        [4968] = { -- Lady Jaina Proudmoore
            [npcKeys.questStarts] = {1267,27239,27240},
        },
        [5048] = { -- Deviate Adder
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{16.32,54.48},{9.34,47.05},{8.09,37.88},{4.18,29.95},{13.2,24.1},{-1,-1}}},
        },
        [5053] = { -- Deviate Crocolisk
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{59.87,78.71},{51.6,42.52},{54.52,60.24},{57.29,58.81},{59.89,61.39},{59.92,64.02},{15.54,46.11},{26.87,41.49},{43.32,36.45},{37.02,35.2},{-1,-1}}},
        },
        [5056] = { -- Deviate Dreadfang
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{53.77,66.55},{55.33,66.13},{73.01,72.46},{-1,-1}}},
        },
        [5113] = { -- Kelv Sternhammer
            [npcKeys.questStarts] = {1718,8417},
        },
        [5142] = { -- Braenna Flintcrag
            [npcKeys.questStarts] = {},
        },
        [5165] = { -- Hulfdan Blackbeard
            [npcKeys.questStarts] = {6681,8233,27267,28262},
        },
        [5173] = { -- Alexander Calder
            [npcKeys.questStarts] = {27272,28259},
            [npcKeys.questEnds] = {},
        },
        [5174] = { -- Springspindle Fizzlegear
            [npcKeys.questStarts] = {3632},
        },
        [5479] = { -- Wu Shen
            [npcKeys.questStarts] = {1718,8417},
        },
        [5489] = { -- Brother Joshua
            [npcKeys.questStarts] = {8254},
        },
        [5495] = { -- Ursula Deline
            [npcKeys.questStarts] = {64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [5496] = { -- Sandahl
            [npcKeys.questEnds] = {},
        },
        [5497] = { -- Jennea Cannon
            [npcKeys.questStarts] = {1939,2861,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {1860,1861,1919,1920,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [5504] = { -- Sheldras Moontree
            [npcKeys.questStarts] = {27273},
        },
        [5515] = { -- Einris Brightspear
            [npcKeys.questStarts] = {6073,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [5638] = { -- Kreldig Ungor
            [npcKeys.questStarts] = {1454,1456,1467},
        },
        [5639] = { -- Craven Drok
            [npcKeys.questStarts] = {1431},
        },
        [5640] = { -- Keldran
            [npcKeys.questStarts] = {1432},
        },
        [5641] = { -- Takata Steelblade
            [npcKeys.questStarts] = {1433,1434,1436},
        },
        [5709] = { -- Shade of Eranikus
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{68.56,87.31},{-1,-1}}},
        },
        [5710] = { -- Jammal'an the Prophet
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{76.01,36.94},{-1,-1}}},
        },
        [5755] = { -- Deviate Viper
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{11.24,52.72},{10.72,49.88},{6.77,36.05},{16.11,39.32},{11.43,33.48},{13.1,31.58},{11.02,29.63},{-1,-1}}},
        },
        [5756] = { -- Deviate Venomwing
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{61.41,52.81},{59.26,58.01},{-1,-1}}},
        },
        [5760] = { -- Lord Azrethoc
            [npcKeys.waypoints] = {},
        },
        [5761] = { -- Deviate Shambler
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{72.1,77.34},{68.54,62.2},{54.61,70.14},{55.78,76.88},{54.62,82.57},{54.44,87.93},{57.45,89.57},{-1,-1}}},
        },
        [5762] = { -- Deviate Moccasin
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{36.43,8.14},{36.57,8.1},{29.6,12.89},{-1,-1}}},
        },
        [5767] = { -- Nalpak
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{46.62,58.35},{-1,-1}}},
        },
        [5768] = { -- Ebru
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{46.63,59.19},{-1,-1}}},
        },
        [5775] = { -- Verdan the Everliving
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{56.48,47.47},{-1,-1}}},
        },
        [5833] = { -- Margol the Rager
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{73.49,82.39}}},
            [npcKeys.waypoints] = {[zoneIDs.SEARING_GORGE] = {{{73.49,82.39},{73.45,82.23},{73.41,82.08},{73.37,81.92},{73.33,81.76},{73.27,81.49},{73.14,81.02},{73.01,80.54},{72.90,80.07},{72.78,79.59},{72.68,79.11},{72.73,78.61},{72.80,78.27},{72.83,78.13},{72.87,77.97},{72.92,77.81},{72.96,77.65},{73.00,77.50},{73.04,77.34},{73.08,77.19},{73.12,77.03},{73.16,76.87},{73.20,76.71},{73.23,76.55},{73.25,76.39},{73.26,76.22},{73.27,76.05},{73.28,75.89},{73.28,75.72},{73.28,75.55},{73.28,75.38},{73.28,75.21},{73.27,75.04},{73.28,74.87},{73.28,74.78},{73.28,74.69},{73.29,74.52},{73.29,74.35},{73.28,74.19},{73.26,74.02},{73.19,73.90},{73.09,73.83},{72.98,73.79},{72.83,73.74},{72.49,73.64},{72.32,73.60},{72.21,73.56},{72.10,73.53},{71.99,73.50},{71.88,73.46},{71.77,73.42},{71.66,73.39},{71.55,73.35},{71.44,73.31},{71.33,73.28},{71.22,73.24},{71.11,73.21},{71.00,73.17},{70.89,73.14},{70.78,73.08},{70.68,73.02},{70.57,72.96},{70.47,72.89},{70.37,72.82},{70.27,72.75},{70.16,72.68},{70.06,72.61},{69.96,72.54},{69.86,72.47},{69.75,72.40},{69.65,72.33},{69.55,72.26},{69.45,72.19},{69.35,72.12},{69.25,72.04},{69.15,71.96},{69.11,71.94}}}},
        },
        [5887] = { -- Canaga Earthcaller
            [npcKeys.questEnds] = {1516,1518},
        },
        [5912] = { -- Deviate Faerie Dragon
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{72.67,74.57},{-1,-1}}},
        },
        [5992] = { -- Ashmane Boar
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{55.86,71.38},{69.24,56.82},{72.99,54.57},{67.72,58.18},{70.5,55.62},{41.52,19.73},{70.02,51.59},{48.02,12.71},{46.26,15.89},{45.59,19.35},{46.48,20.72},{61.36,39.82},{50.69,38.36},{49.37,37.17},{57.98,24.52},{56.56,25.64},{55.45,23.36},{57.13,35.6},{48.63,24.94},{48.85,26.73},{51.41,36.53},{51.28,27.56},{51.81,25.52},{54.1,25.43},{51.46,30.04},{53.54,29.24},{57.55,33.02},{53.17,32.63},{49.29,32.46},{49.36,31.28},{44.05,33.5},{45.02,33.3},{46.83,21.04},{45.1,18.83},{48.04,12.99},{43.73,19.99},{46.09,15.85},{48.9,25.02},{48.89,27.18},{50.66,27.32},{53.37,32.84},{51.31,33.33},{48.75,32.99},{47.51,33.62},{49.23,31.43},{53.22,29.4},{51.71,25.3},{55.01,31.66},{57.07,32.91},{56.95,35.66},{57.2,39.6},{55.36,37.89},{51.8,25.43},{51.51,29.44},{57.09,35.61},{56.98,38.3},{46.54,33.71},{49.21,37.12},{51.42,36.53},{51.46,29.61},{50.77,33.55},{49.2,31.19},{53.36,32.87},{48.98,33.04},{53.26,29.31}}},
        },
        [6018] = { -- Ur'kyo
            [npcKeys.questStarts] = {5680,8254},
        },
        [6072] = { -- Diathorus the Seeker
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{78.47,83.9}}},
        },
        [6235] = { -- Electrocutioner 6000
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN_THE_DORMITORY] = {{24.58,67.92}},[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [6243] = { -- Gelihast
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{52.25,55.1},{-1,-1}}},
        },
        [6294] = { -- Krom Stoutarm
            [npcKeys.questEnds] = {1360,1758,1802},
        },
        [6487] = { -- Arcanist Doan
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_LIBRARY] = {{83.4,74.4}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [6522] = { -- Andron Gant
            [npcKeys.questStarts] = {3564},
        },
        [6546] = { -- Tabetha
            [npcKeys.questStarts] = {4976,11211,27296,27297,27429,27430},
        },
        [6566] = { -- Estelle Gendry
            [npcKeys.questEnds] = {},
        },
        [6577] = { -- Bingles Blastenheimer
            [npcKeys.waypoints] = {},
        },
        [6735] = { -- Innkeeper Saelienne
            [npcKeys.questStarts] = {3763,8357},
        },
        [6766] = { -- Ravenholdt Guard
            [npcKeys.questStarts] = {6701},
        },
        [6768] = { -- Lord Jorach Ravenholdt
            [npcKeys.questEnds] = {8233,8236,8237},
        },
        [6826] = { -- Talvash del Kissel
            [npcKeys.questStarts] = {2199,2948,3375,8355},
        },
        [7010] = { -- Zilzibin Drumlore
            [npcKeys.questStarts] = {4494,4511},
        },
        [7023] = { -- Obsidian Sentinel
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{28.74,61.66},{-1,-1}}},
        },
        [7079] = { -- Viscous Fallout
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN_THE_DORMITORY] = {{76.87,44.41}},[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [7139] = { -- Irontree Stomper
            [npcKeys.questStarts] = {},
        },
        [7149] = { -- Withered Protector
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {},
        },
        [7172] = { -- Lore Keeper of Norgannon
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN_KHAZ_GOROTHS_SEAT] = {{47.74,37.08}},[zoneIDs.ULDAMAN] = {{-1,-1}}},
        },
        [7206] = { -- Ancient Stone Keeper
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{47.46,43.51},{-1,-1}}},
        },
        [7228] = { -- Ironaya
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{37.92,73.66},{-1,-1}}},
        },
        [7267] = { -- Chief Ukorz Sandscalp
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{43.84,35.26},{-1,-1}}},
        },
        [7271] = { -- Witch Doctor Zum'rah
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{44.02,15.08},{-1,-1}}},
        },
        [7272] = { -- Theka the Martyr
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{54.94,25.12},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.ZUL_FARRAK] = {{{55.32,25.2},{55.86,25.46},{56.25,26.61},{56.1,27.85},{55.32,29.64},{53.92,28.91},{53.3,28.32},{52.8,27.71},{52.87,26.65},{53.04,25.91},{53.46,25.15},{54.38,24.77},{55.32,25.2}}}},
        },
        [7273] = { -- Gahz'rilla
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{29.38,38.55},{-1,-1}}},
        },
        [7275] = { -- Shadowpriest Sezz'ziz
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{30.58,18.2},{-1,-1}}},
        },
        [7291] = { -- Galgann Firehammer
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{25.76,35.92},{-1,-1}}},
        },
        [7315] = { -- Darnath Bladesinger
            [npcKeys.questStarts] = {8417},
        },
        [7318] = { -- Rageclaw
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{45.75,52.82}}},
            [npcKeys.waypoints] = {},
        },
        [7319] = { -- Lady Sathrah
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{40.66,22.16}}},
        },
        [7327] = { -- Withered Warrior
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{43.64,23.77},{34.8,20.33},{32.27,17.89},{29.52,18.85},{-1,-1}}},
        },
        [7328] = { -- Withered Reaver
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{72.7,44.4},{76.94,26.78},{68.47,33.26},{59.55,36.82},{59.69,28.93},{56.14,29.47},{48.51,39.27},{47.93,33.35},{-1,-1}}},
        },
        [7329] = { -- Withered Quilguard
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{73.66,44.99},{71.94,42.58},{76.03,28.59},{67.65,32.39},{59.87,38.6},{58.77,37.68},{60.26,31.04},{60.64,29.03},{56.58,29.8},{49.02,39.06},{49.5,39.36},{47.07,34.11},{-1,-1}}},
        },
        [7332] = { -- Withered Spearhide
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{47.32,22.06},{44.03,24.87},{37.65,25.81},{-1,-1}}},
        },
        [7333] = { -- Withered Battle Boar
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{46.66,23.14},{47.04,23.72},{47.11,23.01},{47.83,23.02},{37.82,24.49},{38.55,25.1},{38.96,24.94},{38.62,26.02},{-1,-1}}},
        },
        [7334] = { -- Battle Boar Horror
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{45.79,32.69},{46.08,31.96},{67.45,41},{41,19.19},{-1,-1}}},
        },
        [7335] = { -- Death's Head Geomancer
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{44.27,26.16},{32.83,18.08},{-1,-1}}},
        },
        [7337] = { -- Death's Head Necromancer
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{72.88,43.21},{75.67,26.83},{68.42,30.96},{60.96,37.52},{60.71,29.75},{55.85,28.67},{47.76,38.62},{48.48,33.87},{-1,-1}}},
        },
        [7355] = { -- Tuten'kash
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{58.05,33.09},{-1,-1}}},
        },
        [7357] = { -- Mordresh Fire Eye
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{85.82,45.68},{-1,-1}}},
        },
        [7358] = { -- Amnennar the Coldbringer
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{44.86,59.16},{-1,-1}}},
        },
        [7363] = { -- Kum'isha the Collector
            [npcKeys.waypoints] = {},
        },
        [7406] = { -- Oglethorpe Obnoticus
            [npcKeys.questStarts] = {3642,3721},
        },
        [7407] = { -- Chief Engineer Bilgewhizzle
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{58.18,89.1},{-1,-1}}},
        },
        [7428] = { -- Frostmaul Giant
            [npcKeys.questStarts] = {28656},
        },
        [7429] = { -- Frostmaul Preserver
            [npcKeys.questStarts] = {28656},
        },
        [7430] = { -- Young Frostsaber
            [npcKeys.questStarts] = {28656},
        },
        [7431] = { -- Frostsaber
            [npcKeys.questStarts] = {28656},
        },
        [7432] = { -- Frostsaber Stalker
            [npcKeys.questStarts] = {28656},
        },
        [7433] = { -- Frostsaber Huntress
            [npcKeys.questStarts] = {28656},
        },
        [7434] = { -- Frostsaber Pride Watcher
            [npcKeys.questStarts] = {28656},
        },
        [7438] = { -- Winterfall Ursa
            [npcKeys.questStarts] = {28656},
        },
        [7439] = { -- Winterfall Shaman
            [npcKeys.questStarts] = {28656},
        },
        [7440] = { -- Winterfall Den Watcher
            [npcKeys.questStarts] = {28656},
        },
        [7441] = { -- Winterfall Totemic
            [npcKeys.questStarts] = {28656},
        },
        [7442] = { -- Winterfall Pathfinder
            [npcKeys.questStarts] = {28656},
        },
        [7443] = { -- Shardtooth Mauler
            [npcKeys.questStarts] = {28656},
        },
        [7444] = { -- Shardtooth Bear
            [npcKeys.questStarts] = {28656},
        },
        [7446] = { -- Rabid Shardtooth
            [npcKeys.questStarts] = {28656},
        },
        [7448] = { -- Chillwind Chimaera
            [npcKeys.questStarts] = {28656},
        },
        [7450] = { -- Ragged Owlbeast
            [npcKeys.questStarts] = {28656},
        },
        [7451] = { -- Raging Owlbeast
            [npcKeys.questStarts] = {28656},
        },
        [7452] = { -- Crazed Owlbeast
            [npcKeys.questStarts] = {28656},
        },
        [7453] = { -- Moontouched Owlbeast
            [npcKeys.questStarts] = {28656},
        },
        [7454] = { -- Berserk Owlbeast
            [npcKeys.questStarts] = {28656},
        },
        [7456] = { -- Winterspring Screecher
            [npcKeys.questStarts] = {},
        },
        [7458] = { -- Ice Thistle Yeti
            [npcKeys.questStarts] = {28656},
        },
        [7459] = { -- Ice Thistle Matriarch
            [npcKeys.questStarts] = {28656},
        },
        [7460] = { -- Ice Thistle Patriarch
            [npcKeys.questStarts] = {28656},
        },
        [7505] = { -- Bloodmage Drazial
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{39.2,36.2}}},
        },
        [7740] = { -- Gracina Spiritmight
            [npcKeys.questStarts] = {4493,4510},
        },
        [7795] = { -- Hydromancer Velratha
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{32.33,40.32},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.ZUL_FARRAK] = {{{30.39,42.55},{28.62,40.15},{29.69,38.88},{30.67,37.5},{32.33,40.32}}}},
        },
        [7796] = { -- Nekrum Gutchewer
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{30.61,18.32},{-1,-1}}},
        },
        [7797] = { -- Ruuzlu
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{44.07,34.78},{-1,-1}}},
        },
        [7800] = { -- Mekgineer Thermaplugg
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN_TINKERS_COURT] = {{31.35,29.74}},[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [7937] = { -- High Tinker Mekkatorque
            [npcKeys.questStarts] = {25229},
        },
        [7952] = { -- Zjolnir
            [npcKeys.questStarts] = {7664,7665},
            [npcKeys.questEnds] = {7664,7665},
        },
        [7953] = { -- Xar'Ti
            [npcKeys.questEnds] = {14088},
        },
        [7954] = { -- Binjy Featherwhistle
            [npcKeys.questEnds] = {14084},
        },
        [7955] = { -- Milli Featherwhistle
            [npcKeys.questStarts] = {7675,7676},
            [npcKeys.questEnds] = {7675,7676},
        },
        [8125] = { -- Dirge Quikcleave
            [npcKeys.questStarts] = {13825},
            [npcKeys.questEnds] = {6611,6612,8584,8585,8586,13825},
        },
        [8127] = { -- Antu'sul
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{69.02,25.55},{-1,-1}}},
        },
        [8379] = { -- Archmage Xylem
            [npcKeys.questStarts] = {3565,9362,9364},
        },
        [8380] = { -- Captain Vanessa Beltis
            [npcKeys.questStarts] = {3382},
        },
        [8395] = { -- Sanath Lim-yo
            [npcKeys.questStarts] = {3503},
        },
        [8399] = { -- Nyrill
            [npcKeys.questStarts] = {3421},
        },
        [8420] = { -- Kim'jael
            [npcKeys.questStarts] = {3601,5534},
        },
        [8440] = { -- Shade of Hakkar
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{24.35,45.71},{-1,-1}}},
        },
        [8516] = { -- Belnistrasz
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{77.46,15.14},{-1,-1}}},
            [npcKeys.questEnds] = {3523,27019},
        },
        [8567] = { -- Glutton
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{33.93,52.14},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.RAZORFEN_DOWNS] = {{{33.93,52.14},{33.13,54.44},{33.40,59.02},{34.06,64.21},{35.39,68.79},{37.65,71.78},{40.38,74.88},{43.70,76.07}}}},
        },
        [8576] = { -- Ag'tor Bloodfist
            [npcKeys.spawns] = {
                [zoneIDs.AZSHARA] = {
                    {26.82,76.95,phases.AGTOR_GRABBIT_OUTSIDE_ATTACK},
                },
            },
        },
        [8582] = { -- Kadrak
            [npcKeys.spawns] = {
                [zoneIDs.THE_BARRENS] = {
                    {42.35,15.17,phases.THE_BARRENS_KADRAK_MORSHAN},
                },
            },
        },
        [8587] = { -- Jediga
            [npcKeys.questStarts] = {3517,3518,3541,3542,3561},
        },
        [8659] = { -- Jes'rimon
            [npcKeys.questStarts] = {3563},
        },
        [8886] = { -- Deviate Python
            [npcKeys.spawns] = {[zoneIDs.WAILING_CAVERNS] = {{9.36,42.38},{13.53,51.55},{13.28,52.14},{13.67,52.14},{9.27,42.19},{9.25,42.49},{8.46,27.72},{8.93,27.58},{8.64,27.25},{17.03,25.62},{17.32,26.33},{-1,-1}}},
        },
        [8906] = { -- Ragereaver Golem
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{34.5,68.91},{37.01,64.49}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8907] = { -- Wrath Hammer Construct
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{40.63,70.54},{38.54,71.48},{38.48,70.08},{34.99,71.48},{36.7,63.73}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [8983] = { -- Golem Lord Argelmach
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{36.86,64.97}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9016] = { -- Bael'Gar
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{24,51.58},{-1,-1}}},
        },
        [9018] = { -- High Interrogator Gerstahn
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{47.55,93.18},{-1,-1}}},
        },
        [9019] = { -- Emperor Dagran Thaurissan
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{93.14,11.89}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9024] = { -- Pyromancer Loregrain
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{54.14,96.49}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9033] = { -- General Angerforge
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{36.51,83.84}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9039] = { -- Doom'rel
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{56.68,21.71}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9046] = { -- Scarshield Quartermaster
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{43.34,99.17}}},
        },
        [9119] = { -- Muigin
            [npcKeys.questStarts] = {4141},
        },
        [9156] = { -- Ambassador Flamelash
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{53.8,48.79}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9166] = { -- Pterrordax
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{57,48.27},{59.98,46.53},{48.14,58.88},{61.55,54.05},{57.48,45.7},{49.4,72.14},{48.61,64.75},{55.17,30.36},{46.25,21.17}}},
        },
        [9167] = { -- Frenzied Pterrordax
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{31.06,30.05},{42.03,23.37},{40.27,17.86},{39.1,19.45},{35.47,27.85},{38.56,28.03},{36.78,28.34},{41.52,19.52},{35.69,46.45},{24.51,54.21},{42.75,49.44},{41.73,46.41},{32.77,63.36},{33.64,28.08},{39.91,48.07},{31.74,38.66},{33.91,46.51},{31.61,41.02},{42.66,46.74},{40.18,21.02},{32.86,40.14},{39.04,49.97},{34.91,40.88},{38.19,22.81},{34.7,45.52},{34.88,31.41},{28.7,43.74},{35.23,78.27},{28.01,41.49},{29.37,42.4},{30.89,34.3},{27.65,44.84},{32.18,43.52},{27.23,36.66},{29.65,39.59},{36.15,21.75},{32.94,42.7},{29.56,32.56},{39.91,45.01},{30.46,38.2},{35.23,32.2},{27.36,40.07},{28.63,46.58},{38.76,43.49},{37.28,43.78},{38.29,78.8},{28.13,30.85},{27.35,34.34},{26.28,38.75},{25.18,42.67},{26.41,35.92},{38.41,45.15},{39.16,43.89},{41.66,70.74},{36.5,42.96},{31.07,37.23},{40.95,41.32},{36.82,64.55},{37.63,41.48},{36.7,36.7},{41.6,39.57},{30.97,45.19},{34.93,29.1},{38.63,37},{40.25,42.7},{39.43,42.02},{40.63,35.27},{30.95,28.95},{37.43,35.91},{32.94,36.57},{38.06,34.66},{35.74,35.35},{40.97,29.98},{40.18,29.18},{41.35,20.04},{42.19,32.12},{41.27,27.27}}},
        },
        [9176] = { -- Gorlop
            [npcKeys.waypoints] = {[zoneIDs.BURNING_STEPPES] = {{{39.95,60.48},{40.24,60.42},{40.52,60.36},{40.81,60.31},{41.10,60.27},{41.38,60.18},{41.67,60.07},{41.95,59.95},{42.01,59.92},{42.02,59.92},{42.30,59.85},{42.59,59.84},{42.88,59.88},{43.16,59.97},{43.45,60.05},{43.74,60.11},{43.89,60.13},{43.91,60.14}}}},
        },
        [9196] = { -- Highlord Omokk
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_SPIRE_HORDEMAR_CITY] = {{35,55.24}},[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [9237] = { -- War Master Voone
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_SPIRE_TAZZ_ALOR] = {{52.85,53.19}},[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [9456] = { -- Warlord Krom'zar
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{35.86,54.67}}},
        },
        [9476] = { -- Watchman Doomgrip
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{60.4,67.47}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9499] = { -- Plugger Spazzring
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{49.73,61.41}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9503] = { -- Private Rocknot
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{51.11,60.56}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9523] = { -- Kolkar Stormseer
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{43.73,77.33},{44.06,73.65},{42.14,77.38},{37.17,70.05},{37.84,70.45},{39.87,70.4},{40.73,70.35},{41,71.12},{38.54,72.14},{42.64,73.02},{40.98,73.65},{42.16,71.22},{38.05,71.97},{38.58,72.17},{43.74,77.33}}},
        },
        [9524] = { -- Kolkar Invader
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{36.24,54.52},{36.53,53.95},{36.6,54.5},{36.48,54.15},{37.03,53.05},{36.19,54.68},{36.57,53.97},{36.05,54.77},{36.09,56.1},{36.29,54.4},{36.19,54.69},{37.14,52.99}}},
        },
        [9529] = { -- Maybess Riverbreeze
            [npcKeys.questStarts] = {4107,4108,4109,4110,4111,4112,5887,5888,5889,5890,5891},
        },
        [9537] = { -- Hurley Blackbreath
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{47.71,59.93}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9543] = { -- Ribbly Screwspigot
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{49.08,61.82}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [9563] = { -- Ragged John
            [npcKeys.questStarts] = {27469},
            [npcKeys.questEnds] = {4866},
        },
        [9568] = { -- Overlord Wyrmthalak
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_SPIRE_CHAMBER_OF_BATTLE] = {{56.02,55.36}},[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
        },
        [9684] = { -- Lar'korwi
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{69.98,40.96}}},
        },
        [9836] = { -- Mathredis Firestar
            [npcKeys.questStarts] = {4463,4481,4482,4483,4484},
        },
        [9976] = { -- Tharlidun
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [9981] = { -- Sikwa
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [9982] = { -- Penny
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [9989] = { -- Lina Hearthstove
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [10047] = { -- Michael
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [10051] = { -- Seriadne
            [npcKeys.questEnds] = {},
        },
        [10057] = { -- Theodore Mont Claire
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [10058] = { -- Greth
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [10063] = { -- Reggifuz
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [10181] = { -- Lady Sylvanas Windrunner
            [npcKeys.questEnds] = {9177,9180,9621,9812,10592,14349,24613,24987},
        },
        [10299] = { -- Acride
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{30.48,39.73},{-1,-1}}},
            [npcKeys.questStarts] = {4742,4743,27440,27444,27445},
            [npcKeys.questEnds] = {4742,4743,27440,27444,27445,27469,27470,27471,28070,28071},
        },
        [10307] = { -- Witch Doctor Mau'ari
            [npcKeys.questEnds] = {969,975,4801,4802,4803,4804,4805,4806,4807,6606,28540,28541,28546,28547,28656},
        },
        [10363] = { -- General Drakkisath
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{32.6,45.4},{-1,-1}}}, -- the actual map is missing in cataclysm, using this one instead
        },
        [10429] = { -- Warchief Rend Blackhand
            [npcKeys.spawns] = {[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{48.6,19.1},{-1,-1}}}, -- the actual map is missing in cataclysm, using this one instead
        },
        [10432] = { -- Vectus
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_CHAMBER_OF_SUMMONING] = {{48.25,66.2}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [10433] = { -- Marduk Blackpool
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_CHAMBER_OF_SUMMONING] = {{44.34,63.82}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [10439] = { -- Ramstein the Gorger
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME_THE_GAUNTLET] = {{41.5,20.33},{-1,-1}}},
        },
        [10445] = { -- Selina Dourman
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{55.56,55.01},{-1,-1}}},
        },
        [10463] = { -- Shrieking Banshee
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME_THE_GAUNTLET] = {{60.7,24.98},{59.93,29.82},{64.2,24.91},{66.86,28.73},{70.79,49.08},{68.25,50.16},{64.66,49.3},{62,46.13},{59.03,43.43},{-1,-1}}},
        },
        [10464] = { -- Wailing Banshee
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME_THE_GAUNTLET] = {{57.77,23.67},{75.35,42.16},{71.34,44.09},{74.27,49.93},{-1,-1}}},
        },
        [10506] = { -- Kirtonos the Herald
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_CHAMBER_OF_SUMMONING] = {{49.71,12.97}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [10508] = { -- Ras Frostwhisper
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_HEADMASTERS_STUDY] = {{40.56,88.47}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.SCHOLOMANCE_HEADMASTERS_STUDY] = {{{40.56,88.14},{41.61,88.09},{41.72,92.7},{39.52,92.74},{39.42,88.14},{40.56,88.14},{40.56,88.47}}}},
        },
        [10516] = { -- The Unforgiven
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{72.84,18.9},{-1,-1}}},
        },
        [10541] = { -- Krakle's Thermometer
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{48.32,43.47}}},
        },
        [10618] = { -- Rivern Frostwind
            [npcKeys.questStarts] = {4970,5201,5981,29032,29034},
        },
        [10665] = { -- Junior Apothecary Holland
            [npcKeys.waypoints] = {},
        },
        [10666] = { -- Gordo
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{44.95,53.17}}},
            [npcKeys.waypoints] = {[zoneIDs.TIRISFAL_GLADES] = {{{44.12,53.92},{44.23,53.97},{44.24,53.77},{44.25,53.52},{44.32,53.30},{44.42,53.10},{44.56,52.98},{44.73,52.95},{44.88,53.02},{45.01,53.18},{45.10,53.38},{45.11,53.39}}}},
        },
        [10678] = { -- Plagued Hatchling
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_CHAMBER_OF_SUMMONING] = {{29.23,64.22},{31.3,60.7},{33.59,62.03},{31.89,67.38},{29.26,70.78},{36.14,61.64},{35.88,65.7},{33.17,69.69},{33,74.78},{30.78,78.03},{34.15,78},{37.63,70.24},{37.74,75.85}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [10737] = { -- Shy-Rotam
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{46.1,17.6}}},
            [npcKeys.questStarts] = {28656},
        },
        [10738] = { -- High Chief Winterfall
            [npcKeys.questStarts] = {28656},
        },
        [10741] = { -- Sian-Rotam
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{45.7,17.63}}},
        },
        [10806] = { -- Ursius
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{59.68,40.81}}},
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {28656},
        },
        [10807] = { -- Brumeran
            [npcKeys.waypoints] = {[zoneIDs.WINTERSPRING] = {{{51.89,58.59},{52.09,59.01},{52.27,59.44},{52.37,59.71},{52.38,59.74},{52.46,60.05},{52.50,60.21},{52.57,60.69},{52.58,61.18},{52.58,61.63},{52.58,61.87},{52.65,62.08},{52.73,62.26},{52.83,62.42},{52.90,62.51},{53.16,62.83},{53.34,62.91},{53.45,62.91},{53.76,63.06},{53.82,63.30},{53.85,63.41},{53.86,63.46},{53.94,63.93},{53.99,64.44},{54.05,64.83},{54.11,65.19},{54.20,65.69},{54.24,65.91},{54.26,66.05},{54.38,66.42},{54.58,66.67},{54.72,66.87},{54.80,67.00},{55.04,67.35},{55.06,67.37},{55.07,67.38},{55.35,67.67},{55.65,67.89},{55.94,68.17},{56.14,68.42},{56.29,68.56},{56.59,68.81},{56.91,68.98},{56.96,69.00},{57.21,69.11},{57.54,69.25},{57.62,69.29},{57.91,69.47},{58.15,69.65},{58.41,69.88},{58.71,70.13},{58.77,70.18},{59.03,70.41},{59.29,70.68},{59.41,70.84},{59.61,71.09},{59.79,71.27},{59.93,71.37},{60.23,71.59},{60.46,71.72},{60.66,71.79},{60.91,72.11},{60.99,72.34},{61.08,72.60},{61.18,72.91},{61.15,73.25},{61.14,73.27},{61.01,73.65},{60.91,73.96},{60.74,74.41},{60.72,74.48},{60.63,74.68},{60.45,75.04},{60.32,75.23},{60.21,75.40},{60.12,75.54},{59.82,75.79},{59.78,75.81},{59.56,75.93},{59.30,76.22},{59.30,76.22},{59.07,76.60},{58.80,76.92},{58.67,77.03},{58.59,77.08},{58.26,77.24},{57.93,77.37},{57.62,77.56},{57.53,77.63},{57.49,77.67},{57.35,77.80},{57.26,77.92},{57.01,78.28},{56.96,78.78},{56.96,78.89}}}},
            [npcKeys.questStarts] = {28656},
        },
        [10808] = { -- Timmy the Cruel
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{48.98,16.08},{-1,-1}}},
        },
        [10813] = { -- Balnazzar
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{18.83,83.59},{-1,-1}}},
        },
        [10837] = { -- High Executor Derrington
            [npcKeys.questStarts] = {5238,25009,25010,25011,26920,26930,26936,26979,27083},
            [npcKeys.questEnds] = {105,356,5093,5094,5095,5096,5098,5238,10374,25007,25009,25046,26926,26930,26936},
        },
        [10838] = { -- Commander Ashlam Valorfist
            [npcKeys.questStarts] = {5237,27158,27166,27169,27172},
            [npcKeys.questEnds] = {211,5066,5090,5091,5092,5097,5237,8415,8416,8418,10373,27165,27166,27171,27206},
        },
        [10839] = { -- Argent Officer Garush
            [npcKeys.questStarts] = {5503,26952},
        },
        [10877] = { -- Courier Hammerfall
            [npcKeys.questStarts] = {7494},
        },
        [10878] = { -- Herald Moonstalker
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {7494},
        },
        [10880] = { -- Warcaller Gorlach
            [npcKeys.questStarts] = {7492},
        },
        [10916] = { -- Winterfall Runner
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{21.24,46.13}},[zoneIDs.FELWOOD] = {{59.73,8.06}}},
            [npcKeys.waypoints] = {[zoneIDs.WINTERSPRING] = {{{21.24,46.13},{21.29,46.27},{21.38,46.62},{21.42,46.99},{21.41,47.36},{21.41,47.74},{21.40,48.12},{21.43,48.49},{21.52,48.84},{21.61,49.19},{21.71,49.56},{21.79,49.90},{21.85,50.26},{21.89,50.64},{21.93,51.01},{21.96,51.38},{21.96,51.70},{22.10,52.01},{22.24,52.32},{22.38,52.63},{22.54,52.92},{22.69,53.20},{22.97,53.75},{23.27,54.36},{23.58,54.98},{23.96,55.48},{24.47,55.49},{24.98,55.40},{25.49,55.30},{26.00,55.22},{26.51,55.14},{27.03,55.06},{27.54,54.98},{28.05,54.90},{28.56,54.82},{29.07,54.74},{29.58,54.66},{29.81,54.63},{30.10,54.95},{30.61,55.03},{30.75,55.05},{31.10,55.10},{31.16,55.10},{31.20,55.10},{31.65,55.08},{31.99,55.10},{32.49,54.94},{32.98,54.75},{33.47,54.50},{33.95,54.24},{34.44,53.99},{34.92,53.74},{35.41,53.51},{35.85,53.23},{36.23,53.11},{36.68,52.96},{37.16,52.84},{37.67,52.76},{38.18,52.68},{38.69,52.60},{39.20,52.53},{39.70,52.48},{40.20,52.42},{40.70,52.37},{41.20,52.31},{41.70,52.26},{42.20,52.20},{42.71,52.14},{43.22,52.09},{43.70,51.90},{44.17,51.60},{44.64,51.30},{45.11,51.00},{45.57,50.66},{45.99,50.23},{46.42,49.80},{46.84,49.37},{47.27,48.94},{47.76,48.72},{48.23,48.43},{48.70,48.11},{49.16,47.76},{49.60,47.38},{50.04,46.98},{50.42,46.47},{50.73,45.85},{50.99,45.27},{51.02,45.10},{51.11,44.46},{51.21,43.71},{51.31,42.96},{51.41,42.21},{51.48,41.45},{51.47,40.69},{51.46,39.92},{51.31,39.24},{51.32,38.95},{51.33,38.31},{51.32,37.55},{51.30,36.79},{51.52,36.41},{51.63,35.68},{51.73,34.94},{51.87,34.21},{52.08,33.55},{52.49,33.31},{52.70,33.36},{52.75,33.37},{53.26,33.43},{53.77,33.47},{54.28,33.54},{54.73,33.72},{55.21,33.92},{55.24,33.96},{55.14,34.51},{55.50,34.92},{55.95,35.12},{56.29,35.21},{56.33,35.22},{56.67,35.21},{57.07,34.92},{57.22,34.79},{57.29,34.76},{57.76,34.66},{58.26,34.68},{58.73,34.91},{59.22,34.80},{59.63,34.60},{60.02,34.16},{60.40,33.88},{60.80,33.96},{60.91,34.62},{61.00,35.33},{61.14,36.00},{61.47,36.53},{61.82,37.09},{62.13,37.70},{62.45,38.30},{62.76,38.82},{63.06,39.34},{63.45,39.85},{63.84,40.34},{64.21,40.80},{64.53,41.31},{64.88,41.86},{65.24,42.41},{65.55,42.99},{65.57,43.67},{65.47,44.38},{65.64,45.08},{65.89,45.74},{66.14,46.42},{66.33,47.03},{66.45,47.35}}}},
            [npcKeys.questStarts] = {28656},
        },
        [10920] = { -- Kelek Skykeeper
            [npcKeys.questStarts] = {28479,28537,28848},
            [npcKeys.questEnds] = {5128,7741,28472,28536,28537},
        },
        [10923] = { -- Tenell Leafrunner
            [npcKeys.waypoints] = {},
        },
        [11034] = { -- Lord Maxwell Tyrosus
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{75.87,51.96}}},
        },
        [11036] = { -- Leonid Barthalomew the Revered
            [npcKeys.questEnds] = {5243,5462,5464,5522,27620,64037,64064,64128},
        },
        [11058] = { -- Ezra Grimm
            [npcKeys.name] = "Ezra Grimm",
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{55.41,67.79},{-1,-1}}},
        },
        [11119] = { -- Azzleby
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [11120] = { -- Risen Hammersmith
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{12.95,51.11},{-1,-1}}},
        },
        [11121] = { -- Black Guard Swordsmith
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME_THE_GAUNTLET] = {{73.98,51.95},{-1,-1}}},
        },
        [11261] = { -- Doctor Theolen Krastinov
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_THE_UPPER_STUDY] = {{95.52,45.85}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [11321] = { -- Molten Elemental
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{47.22,30.39},{52.99,48.14},{53.54,50.23},{51.2,41.58},{53.44,31.88},{53.24,27.48},{60.05,58.74},{66.66,18.9},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.RAGEFIRE_CHASM] = {{{50.98,37.59},{51.23,41.26},{50.36,46.34}},{{49.66,22.26},{48.02,24.79},{47.17,29.94},{48.32,34.49},{50.25,34.79},{51.1,32.48},{54.33,28.67},{57.22,29.49}}}},
        },
        [11322] = { -- Searing Blade Cultist
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{26.47,84.98},{27.75,84.49},{32.7,54.05},{33.21,54.5},{40.69,46.94},{47.19,61.82},{48.11,62.16},{41.95,67.56},{32.87,68.37},{31.85,66.99},{37.69,82.41},{37.04,81.26},{32.33,76.82},{32.58,82.62},{34.01,83.96},{34.88,91.08},{27.13,71.12},{39.99,86.73},{40.86,88.56},{48.72,47.17},{49.99,49.79},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.RAGEFIRE_CHASM] = {{{30.31,56.09},{28.04,60.93},{27.33,63.73},{27.13,71.12}},{{26.86,75.03},{26.47,77.92},{26.38,80.85},{25.91,83.52},{26.18,85.75},{27.58,87.26},{29.35,87.14},{32.35,89.93},{34.88,91.08}}}},
        },
        [11323] = { -- Searing Blade Enforcer
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{42.89,70.13},{39.68,44.36},{46.13,60.75},{48.5,52.54},{49.47,53.34},{46.53,47.62},{46.74,49.24},{32.34,75.24},{31.22,76.21},{27.75,73.37},{26.51,72.73},{37.25,91.69},{36.73,90.19},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.RAGEFIRE_CHASM] = {{{46.13,60.75},{42.3,57.99},{40.56,54.78},{39.91,48}},{{32.09,64.51},{33.89,66.75},{36.4,67.55},{39.01,68.46},{41.41,69.3},{42.89,70.13},{45.54,69.37},{47.02,67.68},{48.3,64.71},{48.96,59.94},{48.86,54.41},{48.81,51.73},{47.96,49.64},{46.27,48.58},{43.35,47.25},{41.71,46.13},{39.68,44.36},{37.59,44.37},{35.44,45.05},{32.95,47.91},{31.8,52.99},{31.76,55.41},{32.54,57},{32.88,60.52},{32.09,64.51}}}},
        },
        [11324] = { -- Searing Blade Warlock
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{27.67,86.01},{32.91,55},{39.94,46.03},{47.34,60.78},{40.94,67.11},{32.16,68.09},{36.91,82.67},{-1,-1}}},
        },
        [11378] = { -- Foreman Thazz'ril
            [npcKeys.questStarts] = {25134,25135},
            [npcKeys.questEnds] = {25134,25135},
        },
        [11397] = { -- Nara Meideros
            [npcKeys.questStarts] = {5632,5674},
        },
        [11401] = { -- Priestess Alathea
            [npcKeys.questStarts] = {5627,5640,5647,5672,5678,27268,27269,27274,28285},
        },
        [11406] = { -- High Priest Rohan
            [npcKeys.questStarts] = {5633,5641,5675,8254,27268,27269,27274,28285},
        },
        [11486] = { -- Prince Tortheldrin
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_PRISON_OF_IMMOLTHAR] = {{59.83,23.43},{-1,-1}}},
        },
        [11487] = { -- Tendris Warpwood
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_COURT_OF_THE_HIGHBORNE] = {{30.24,45.47},{-1,-1}}},
        },
        [11488] = { -- Illyanna Ravenoak
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_CAPITAL_GARDENS] = {{31.99,78.42},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.DIRE_MAUL_CAPITAL_GARDENS] = {{{21.86,65.58},{18.99,72.97},{22.09,75.92},{20.19,81.31},{23.71,85.69},{28.19,84.91},{31.99,78.42}}}},
        },
        [11489] = { -- Tendris Warpwood
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_CAPITAL_GARDENS] = {{33.39,53.61},{-1,-1}}},
        },
        [11490] = { -- Zevrim Thornhoof
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_THE_SHRINE_OF_ELDRETHARR] = {{57.49,74.59},{-1,-1}}},
        },
        [11492] = { -- Alzzin the Wildshaper
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_THE_SHRINE_OF_ELDRETHARR] = {{57.18,28.76},{-1,-1}}},
        },
        [11496] = { -- Immol'thar
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_PRISON_OF_IMMOLTHAR] = {{34.97,57.68},{-1,-1}}},
        },
        [11501] = { -- King Gordok
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{31.83,25.93},{-1,-1}}},
        },
        [11502] = { -- Ragnaros
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_CORE] = {{55.36,55.02},{-1,-1}}},
        },
        [11517] = { -- Oggleflint
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{70.1,64.2},{-1,-1}}},
        },
        [11518] = { -- Jergosh the Invoker
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{32.9,84.4},{-1,-1}}},
        },
        [11519] = { -- Bazzalan
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{41.4,86.1},{-1,-1}}},
        },
        [11520] = { -- Taragaman the Hungerer
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{40.7,57.4},{-1,-1}}},
        },
        [11548] = { -- Loh'atu
            [npcKeys.questStarts] = {5535,5536},
        },
        [11622] = { -- Rattlegore
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE_THE_UPPER_STUDY] = {{30.39,62.84}},[zoneIDs.SCHOLOMANCE] = {{-1,-1}}},
        },
        [11682] = { -- Warsong Grunt
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{88.29,55.41},{88.62,50.76},{85.15,64.91},{85.4,64.95},{88.95,51.39},{89.46,62.52},{88.22,67.32},{89.8,59.45},{89.18,49.78},{92.14,54.32},{89.52,49.51},{90.04,62.89},{91.84,53.9},{91.9,54.05},{89.89,54.13},{89.9,51.91},{88.71,67.37},{88.37,55.89},{89.28,61.71},{90.62,54.13},{89.38,56.49},{89.22,65.45},{88.59,55.21},{88.12,61.92},{89.02,62.59},{87.07,60.55},{88.51,58.11},{89.57,57.69},{88.6,57.66},{89.44,62.61},{88.86,52.44},{87.79,64.62},{87.22,64.51},{89.8,57.75},{88.93,60.08},{90.73,58.92},{91.1,57.87},{89.55,58.67},{90.78,58.36},{89.78,58.34},{90.53,58.74},{88.65,59.23},{87.54,59.42},{88.01,59.31},{88.54,58.67},{88.2,53.14},{85.91,60.85}}},
        },
        [11711] = { -- Sentinel Aynasha
            [npcKeys.waypoints] = {},
        },
        [11724] = { -- Hive'Ashi Swarmer
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{50.57,27.67},{45.04,25.31},{44.48,23.75},{51.31,20.02},{51.71,22.99},{50,32.44},{48.41,22.61},{48.81,25.99},{45.18,14.08},{45.97,27.41},{45.98,27.28},{51.42,28.56},{53.65,47.6},{59.14,40.98},{58.01,39.82},{52.3,43.44},{47.62,31.47},{49.7,14.88},{58.88,45.95},{51.29,22.58},{44.57,13.6},{44.11,17.33},{45.77,16.15},{44.51,13.53},{54.03,39.3},{58.32,44.59},{54.93,39.48},{50.01,12.86},{48.65,17.39},{57.32,46.16},{58.15,41.94},{57.51,41.14},{53.51,22.55},{54.83,25.72},{54.72,26.7},{52.02,25.35},{53.33,23.3},{57.03,37.26},{53.69,44.56},{52.54,41.07},{51.62,44.74},{53.36,39.67},{51.44,42.47}}},
        },
        [11725] = { -- Hive'Zora Waywatcher
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{33.81,54.1},{30.55,62.16},{29.38,56.12},{32.09,57.85},{31.47,54.75},{30.63,56.45},{30.41,44.84},{31.34,46.75},{41.11,58.89},{36.17,45.99},{37.76,53.35},{31.05,64.78},{32.33,62.68},{31.88,65.07},{30.73,58.37},{29.79,64.45},{37.05,61.76},{31.68,56.05},{39.7,58.82},{33.18,55.99},{32.31,50.82},{33.61,50.51},{34,58.92},{38.95,57.7},{40.36,57.78},{34,58.92},{34.44,59.43},{33.69,50.5}}},
        },
        [11727] = { -- Hive'Zora Wasp
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{35.09,50.81},{34,62.67},{32.76,46.25},{32.72,46.25},{32.77,46.27},{32.77,46.3},{26.31,62.56},{26.54,61.96},{26.74,62.19},{27.94,56.13},{27.88,56.06},{27.92,56.24},{28,56.09},{25.46,61.74},{25.85,60.65},{25.56,61.47},{25.6,60.99},{25.55,61.69},{34.41,62.95},{34.34,62.97},{34.42,63.06},{34.48,62.93},{34.4,62.84},{33,43.82},{32.98,43.79},{33.04,43.89},{34.83,55.41},{35.33,55.8},{35.1,55.54},{34.9,53.46},{34.88,53.48},{34.85,53.38},{34.82,53.52},{34.85,53.57},{36.09,50.97},{36.15,51.06},{36.02,50.99},{36.12,50.87},{28.75,57.46},{29.36,57.02},{29.22,57.53},{29.15,57.16},{28.81,56.72},{27.89,54.18},{28.14,53.95},{27.77,54.06},{30.5,64.2},{30.24,63.98},{30.32,64.72},{29.01,47.54},{29.06,47.54},{28.95,47.64},{28.95,47.46},{43.32,56.28},{43.51,56.62},{43.65,56.89},{43.58,56.33},{43.47,56.03},{27.11,60.31},{26.72,60.23},{27.63,60.68},{26.85,60.53},{27.29,60.25},{37.63,48.46},{37.63,48.57},{37.7,48.45},{37.63,48.35},{37.56,48.47},{35.37,50.75},{35.16,51.44},{39.16,61.89},{39.27,61.35},{39.73,62.17},{39.39,62.31},{28.37,52.83},{27.87,52.4},{28.24,52.6},{28.39,52.31},{29.23,47.15},{29.31,47.55},{29.84,47.57},{42.31,55.96},{42.53,55.73},{42.03,56.04},{42.06,55.52},{33.82,53.91},{33.72,53.9},{33.67,53.99},{33.74,54.15},{33.67,54.03},{34.2,62.41},{34.28,62.08},{34.56,62.84},{34.58,62.28},{33.74,53.9},{33.69,53.96},{33.72,54.13},{37.87,55.9},{37.94,55.85},{37.84,55.79},{37.65,55.98},{37.55,55.99},{37.72,58.84},{37.69,58.94},{37.8,58.82},{37.68,58.74},{30.85,55.95},{30.92,55.96},{31.1,55.53},{31.07,55.48},{31.06,55.6},{31.16,55.58},{31.15,55.46},{33.64,53.61},{33.64,54.03},{33.97,53.97},{33.43,53.89},{33.2,53.73},{33,52.64},{33.81,52.46},{33.91,52.74},{39.7,61.42},{39.38,62.27},{39.2,61.48},{39.14,61.98},{42.71,57.54},{42.56,57.31},{42.3,57.57},{31.25,55.54},{31.24,55.93}}},
        },
        [11729] = { -- Hive'Zora Hive Sister
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{31.08,50.91},{35.07,44.61},{28.91,58.42},{31.86,57.17},{29.49,43.31},{31.61,47.16},{39.62,56.65},{39.33,55.9},{41.27,56.49},{32.34,55.28},{37.65,50.85},{38.73,51.99},{28.24,59.35},{30.9,62.79},{32.3,65.66},{31.07,60.61},{37.76,60.77},{39.48,59.39},{41.04,56.92},{27.78,50.43},{31.56,58},{32.42,55.2},{33.75,57.91},{35.51,60.81},{36.97,61.9},{36.97,61.88},{32.05,57},{31.9,65.05}}},
        },
        [11731] = { -- Hive'Regal Burrower
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{63.32,70.77},{66.68,64.4},{63.04,84.94},{61.66,89.55},{56.96,77.12},{67.12,67.52},{58.01,64.07},{66.27,72.64},{57.66,84.61},{55.46,72.82},{56.97,76.21},{56.21,91.09}}},
        },
        [11801] = { -- Rabine Saturna
            [npcKeys.questStarts] = {29302,29303,29331},
        },
        [11804] = { -- Twilight Keeper Havunth
            [npcKeys.waypoints] = {},
        },
        [11814] = { -- Kali Remik
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{32.84,65.34}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.waypoints] = {[zoneIDs.ORGRIMMAR] = {{{32.84,65.34},{33.09,66.27},{33.11,66.34},{33.29,66.59},{33.56,66.69},{33.81,66.50},{33.89,66.11},{33.82,65.69},{33.69,65.31},{33.50,64.99},{33.51,64.62},{33.51,64.60}}}},
        },
        [11832] = { -- Keeper Remulos
            [npcKeys.questEnds] = {7066,8446,8447,8734,8735,8736,13073,13074},
        },
        [11858] = { -- Grundig Darkcloud
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{72.23,83.74}}},
        },
        [11863] = { -- Azore Aldamort
            [npcKeys.questStarts] = {5741},
        },
        [11897] = { -- Duskwing
            [npcKeys.waypoints] = {},
        },
        [11937] = { -- Demon Portal Guardian
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{53.14,79.95},{53.93,79.2},{50.91,81.31},{52.65,81.86},{53.13,84.06},{55.07,79.4},{55.28,71.9},{50.65,70.78},{50.21,74.28},{49.89,77.3}}},
            [npcKeys.zoneID] = zoneIDs.DESOLACE,
        },
        [12031] = { -- Mai'Lahii
            [npcKeys.questStarts] = {6142,14334},
        },
        [12042] = { -- Loganaar
            [npcKeys.questStarts] = {9063,27356,27404,28343},
        },
        [12056] = { -- Baron Geddon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_CORE] = {{66.97,65.83},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.MOLTEN_CORE] = {{{57.14,73.74},{53.94,75.85},{52.15,75.77},{51.39,78.21},{51.83,81.94},{53.51,83.94},{54.88,82.65},{55.35,79.23},{56.38,74.98},{57.14,73.74},{64.53,67.01},{66.14,66.16},{66.97,65.83}}}},
        },
        [12057] = { -- Garr
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_CORE] = {{29.58,73.08},{-1,-1}}},
        },
        [12201] = { -- Princess Theradras
            [npcKeys.spawns] = {[zoneIDs.MARAUDON_ZAETARS_GRAVE] = {{24.34,78.34}},[zoneIDs.MARAUDON] = {{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.MARAUDON_ZAETARS_GRAVE] = {{{24.3,78.57},{24.59,79.74},{25.11,80.59},{25.97,81.29},{26.71,81.22},{27.35,80.35},{27.6,79.44},{27.64,78.26},{27.1,76.74},{26.45,76.18},{25.44,75.96},{24.66,76.9},{24.3,78.57}}}},
            [npcKeys.questStarts] = {},
        },
        [12236] = { -- Lord Vyletongue
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{37.62,69.37},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [12238] = { -- Zaetar's Spirit
            [npcKeys.spawns] = {[zoneIDs.MARAUDON_ZAETARS_GRAVE] = {{25.37,78.3}},[zoneIDs.MARAUDON] = {{-1,-1}}},
        },
        [12258] = { -- Razorlash
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{16.2,33.98},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [12480] = { -- Melris Malagan
            [npcKeys.questEnds] = {82948,82983,88796,88797},
        },
        [12676] = { -- Sharptalon
            [npcKeys.waypoints] = {[zoneIDs.ASHENVALE] = {{{71.14,74.56},{71.03,74.88},{71.05,75.10},{71.19,75.35},{71.32,75.54},{71.44,75.61},{71.66,75.72},{71.74,75.76},{71.93,75.84},{72.10,75.93},{72.30,76.13},{72.41,76.26},{72.54,76.42},{72.66,76.60},{72.71,76.69},{72.87,76.97},{73.02,77.26},{73.13,77.49},{73.16,77.55},{73.26,77.71},{73.38,77.65},{73.61,77.50},{73.75,77.34},{73.80,77.17},{73.89,76.83},{73.89,76.65},{73.88,76.48},{73.87,76.12},{73.85,75.81},{73.87,75.69},{73.90,75.51},{73.97,75.16},{74.02,74.95},{74.07,74.67},{74.07,74.62},{74.00,74.44},{73.87,74.13},{73.75,73.89},{73.62,73.71},{73.44,73.52},{73.29,73.36},{73.23,73.30},{73.01,73.12},{72.85,72.99},{72.70,72.91},{72.54,72.93},{72.36,72.97},{72.25,73.01},{72.07,73.10},{71.92,73.20},{71.72,73.40},{71.61,73.57},{71.49,73.76},{71.41,73.88},{71.28,74.13},{71.14,74.56}}}},
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{71.14,74.56}}},
        },
        [12677] = { -- Shadumbra
            [npcKeys.waypoints] = {[zoneIDs.ASHENVALE] = {{{61.96,52.33},{61.84,52.31},{61.70,52.28},{61.67,52.27},{61.61,52.26},{61.46,52.23},{61.39,52.20},{61.32,52.13},{61.28,52.06},{61.23,52.00},{61.19,51.88},{61.17,51.73},{61.15,51.57},{61.15,51.48},{61.15,51.33},{61.15,51.10},{61.15,51.04},{61.16,50.88},{61.19,50.75},{61.23,50.64},{61.25,50.58},{61.31,50.43},{61.36,50.29},{61.42,50.23},{61.49,50.17},{61.56,50.12},{61.62,50.06},{61.70,50.00},{61.76,49.91},{61.82,49.81},{61.87,49.74},{61.95,49.70},{62.01,49.69},{62.13,49.66},{62.21,49.67},{62.29,49.71},{62.35,49.74},{62.44,49.80}}}},
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{61.16,51.56}}},
        },
        [12678] = { -- Ursangous
            [npcKeys.waypoints] = {[zoneIDs.ASHENVALE] = {{{39.78,65.44},{40.18,66.17},{40.78,66.36},{41.33,65.81},{40.78,66.36},{40.32,66.27},{39.84,65.56},{39.72,64.65},{39.67,63.92},{39.8,63},{39.67,63.71},{39.69,64.44},{39.76,65.27},{40.19,66.2},{40.73,66.35},{41.34,66.53},{41.46,67.37},{41.75,68.2},{42.03,68.54},{41.83,68.36},{41.5,67.56},{41.43,66.64},{40.93,66.4},{40.3,66.26},{39.83,65.53},{39.71,64.62},{39.66,63.89},{39.8,62.98},{39.67,63.74},{39.7,64.47}}}},
        },
        [12736] = { -- Je'neu Sancrea
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{48.48,11.74},{-1,-1}}},
            [npcKeys.questStarts] = {6563,26888,26891},
            [npcKeys.questEnds] = {824,908,909,6562,6563,6564,6565,6921,6922,26888,26891,26893,26894,28010},
        },
        [12759] = { -- Tideress
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{48.22,69.74}}},
        },
        [12818] = { -- Ruul Snowhoof
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{41.53,34.48}}},
        },
        [12876] = { -- Baron Aquanis
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{43.09,75.3}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [12918] = { -- Chief Murgut
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{56.38,63.51}}},
        },
        [12919] = { -- Nat Pagle
            [npcKeys.questStarts] = {6607,13826,27220,27221},
            [npcKeys.questEnds] = {6607,6608,6609,8227,11194,11209,13826,27219,27220},
        },
        [12944] = { -- Lokhtos Darkbargainer
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{50.33,58.47}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [13136] = { -- Hive'Ashi Drone
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{64.05,49.7},{61.54,51.11},{66.47,49.72},{63.25,53.18},{63.36,50.91},{62.51,51},{64.96,46.81},{66.76,43.72},{65.78,53.26},{62.64,48.47},{62.64,48.24},{65.41,49.46},{67.78,46.05},{62.77,46.41},{64.81,51.09},{65.46,49.48},{62.53,51.94},{64.84,45.92},{66.39,48.33},{65.44,49.48},{64.93,48.34},{64.12,50.78},{65.65,48.82},{65.63,45.91},{65.59,47.45},{64.03,44.63},{64.86,44.55},{62.38,50.06},{65.49,49.93},{64.84,53.41},{64.78,46.78},{64.87,46.89},{63.91,53.52},{67.43,44.54},{65.49,49.46},{64.76,49.37},{64.75,46.84},{65.02,46.2},{66.43,52.93},{64.78,46.75},{65.78,44.7},{65.75,43.63},{64.11,48.63},{61.53,48.18},{63.26,49.75},{63.16,46.1}}},
        },
        [13153] = { -- Commander Mulfort
            [npcKeys.questStarts] = {7302},
        },
        [13154] = { -- Commander Louis Philips
            [npcKeys.questStarts] = {7281},
        },
        [13158] = { -- Lieutenant Sanders
            [npcKeys.waypoints] = {},
        },
        [13280] = { -- Hydrospawn
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_THE_SHRINE_OF_ELDRETHARR] = {{55.39,71.14},{-1,-1}}},
        },
        [13282] = { -- Noxxion
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{34.74,10.67},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [13283] = { -- Lord Tony Romano
            [npcKeys.questStarts] = {6681,27351,28406,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {28262,28406,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [13319] = { -- Commander Duffy
            [npcKeys.questStarts] = {7301},
        },
        [13320] = { -- Commander Karl Philips
            [npcKeys.questStarts] = {7282},
        },
        [13377] = { -- Master Engineer Zinfizzlex
            [npcKeys.questStarts] = {6861,6862},
        },
        [13417] = { -- Sagorne Creststrider
            [npcKeys.questEnds] = {6964,7667,7668,7669,8258,8259},
        },
        [13418] = { -- Kaymard Copperpinch
            [npcKeys.questStarts] = {6961,6963,6983,6984,8799},
        },
        [13429] = { -- Nardstrum Copperpinch
            [npcKeys.questStarts] = {7024},
        },
        [13431] = { -- Whulwert Copperpinch
            [npcKeys.questStarts] = {7021},
        },
        [13433] = { -- Wulmort Jinglepocket
            [npcKeys.questStarts] = {7022,7042,7043,7045,8763},
        },
        [13446] = { -- Field Marshal Teravaine
            [npcKeys.questStarts] = {6846},
        },
        [13449] = { -- Warmaster Garrick
            [npcKeys.questStarts] = {6901},
        },
        [13597] = { -- Frostwolf Explosives Expert
            [npcKeys.questStarts] = {7368},
        },
        [13598] = { -- Stormpike Explosives Expert
            [npcKeys.questStarts] = {7367},
        },
        [13636] = { -- Strange Snowman
            [npcKeys.questStarts] = {6983,7043},
        },
        [14733] = { -- Sentinel Farsong
            [npcKeys.questEnds] = {7788,7871,7872,7873,7886,7887,7888,7921,8001,8266,8267,8289,8290,8291,8292,9521,26456},
        },
        [13841] = { -- Lieutenant Haggerdin
            [npcKeys.questStarts] = {7162,7168,7169,7170,7171,7172,7202,7382},
        },
        [14305] = { -- Human Orphan
            [npcKeys.questStarts] = {171,29093,29106,29107,29117,29119},
        },
        [14321] = { -- Guard Fengus
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{49.11,78.94},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{{49.11,78.94},{49.28,84.42},{49.1,89.61},{43.84,88.13},{45.19,89.28},{49.09,89.52},{49.34,84.42},{49.43,78.86},{49.59,71.22},{49.39,75.34},{49.18,78.06},{45.02,77.95},{43.05,77.53},{43.14,70.16},{42.83,78.47},{42.91,82.81},{42.92,84},{42.93,86.3},{42.92,84},{42.91,82.81},{42.83,78.47},{44.59,78.24},{47.68,78.38},{49.11,78.94}}}},
        },
        [14322] = { -- Stomper Kreeg
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{61.93,65.73},{-1,-1}}},
            [npcKeys.questStarts] = {27114},
        },
        [14323] = { -- Guard Slip'kik
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{24.55,63.94},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{{24.55,63.94},{24.09,67.2},{23.08,67.15},{22.18,66.24},{22.03,64.06},{23.49,61.76},{23.57,56.25},{25.29,56.07},{26.67,57.96},{28.17,58.64}}}},
        },
        [14324] = { -- Cho'Rush the Observer
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{31.19,25.35},{-1,-1}}},
        },
        [14325] = { -- Captain Kromcrush
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{31.8,50.01},{-1,-1}}},
        },
        [14326] = { -- Guard Mol'dar
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{69.88,75.37},{-1,-1}}},
        },
        [14327] = { -- Lethtendris
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_WARPWOOD_QUARTER] = {{43.96,49.88},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.DIRE_MAUL_WARPWOOD_QUARTER] = {{{43.96,49.88},{44.51,49.81},{45.18,48.57},{44.74,46.48},{43.59,46.48},{42.84,47.73},{43.09,49.3},{43.96,49.88}}}},
        },
        [14338] = { -- Knot Thimblejack
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{28.54,55.14},{-1,-1}}},
        },
        [14347] = { -- Highlord Demitrian
            [npcKeys.questEnds] = {7521,7522,7561,7785,7786,7787,28895},
        },
        [14354] = { -- Pusillin
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_WARPWOOD_QUARTER] = {{12.2,30.87},{21.84,75.5},{32.19,26.4},{65.98,38.27},{75.4,45.23},{-1,-1}}},
        },
        [14358] = { -- Shen'dralar Ancient
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_CAPITAL_GARDENS] = {{48.35,53.7},{-1,-1}}},
        },
        [14387] = { -- Lothos Riftwaker
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{32.12,94.7}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
        },
        [14392] = { -- Overlord Runthak
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{52.61,82.38}}},
        },
        [14431] = { -- Fury Shelda
            [npcKeys.waypoints] = {},
        },
        [14435] = { -- Prince Thunderaan
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{31.19,13.66}}},
            [npcKeys.zoneID] = zoneIDs.SILITHUS,
        },
        [14444] = { -- Orcish Orphan
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{58.18,57.5}}},
            [npcKeys.questStarts] = {5502,29146,29167,29176,29190,29191},
        },
        [14451] = { -- Orphan Matron Battlewail
            [npcKeys.questEnds] = {},
        },
        [14479] = { -- Twilight Lord Everun
            [npcKeys.waypoints] = {},
        },
        [14508] = { -- Short John Mithril
            [npcKeys.spawns] = {[5287] = {{45,25.38}}},
            [npcKeys.waypoints] = {},
        },
        [14625] = { -- Overseer Oilfist
            [npcKeys.spawns] = {
                [zoneIDs.SEARING_GORGE] = {
                    {38.12,26.97,phases.SEARING_GORGE_NPCS_TOWERS},
                    {50.01,39.05,phases.SEARING_GORGE_CAVE_ASSAULT},
                },
            },
            [npcKeys.questStarts] = {27470,28052,28061,28062,28064,28099,28514,28515},
        },
        [14626] = { -- Taskmaster Scrange
            [npcKeys.spawns] = {
                [zoneIDs.SEARING_GORGE] = {
                    {36.81,28.24,phases.SEARING_GORGE_NPCS_TOWERS},
                    {42.24,34.49,phases.SEARING_GORGE_CAVE_ASSAULT},
                },
            },
        },
        [14627] = { -- Hansel Heavyhands
            [npcKeys.spawns] = {
                [zoneIDs.SEARING_GORGE] = {
                    {38.47,27.86,phases.SEARING_GORGE_NPCS_TOWERS},
                    {42.25,34.63,phases.SEARING_GORGE_CAVE_ASSAULT},
                },
            },
        },
        [14628] = { -- Evonice Sootsmoker
            [npcKeys.spawns] = {
                [zoneIDs.SEARING_GORGE] = {
                    {38.93,27.96,phases.SEARING_GORGE_NPCS_TOWERS},
                    {43.77,28.71,phases.SEARING_GORGE_CAVE_ASSAULT},
                },
            },
        },
        [14661] = { -- Stinglasher
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{75.58,60.85}}},
            [npcKeys.waypoints] = {[zoneIDs.FERALAS] = {{{73.81,63.45},{73.78,63.74},{73.71,63.86},{73.60,63.98},{73.55,64.00},{73.37,63.93},{73.29,63.80},{73.24,63.55},{73.28,63.40},{73.36,63.22},{73.43,63.16},{73.50,63.13},{73.61,63.10},{73.64,63.10},{73.81,63.15},{73.93,63.19},{74.05,63.08},{74.05,63.07},{74.11,62.97},{74.17,62.88},{74.25,62.76},{74.30,62.68},{74.37,62.59},{74.53,62.42},{74.63,62.35},{74.76,62.26},{74.85,62.19},{74.88,62.17},{74.98,62.09},{75.08,61.98},{75.15,61.84},{75.23,61.69},{75.33,61.48},{75.36,61.36},{75.39,61.19},{75.41,61.03},{75.46,60.85},{75.58,60.85},{75.68,60.87},{75.77,60.90},{75.89,60.94},{75.97,60.98},{76.11,61.07},{76.12,61.08},{76.25,61.17},{76.28,61.19},{76.40,61.26},{76.55,61.34},{76.62,61.38},{76.66,61.40},{76.84,61.49},{76.92,61.53},{77.00,61.56},{77.09,61.60},{77.15,61.65},{77.16,61.66},{77.25,61.77},{77.32,61.89},{77.42,62.04},{77.43,62.05},{77.54,62.02},{77.74,62.07},{77.88,62.21},{78.03,62.44},{78.14,62.48},{78.15,62.47},{78.32,62.38},{78.42,62.48},{78.49,62.72},{78.47,62.87},{78.46,62.89},{78.42,62.95},{78.19,63.07},{78.09,63.01},{78.02,62.84},{78.06,62.53},{77.97,62.35}}}},
        },
        [14720] = { -- High Overlord Saurfang
            [npcKeys.questEnds] = {},
        },
        [14722] = { -- Clavicus Knavingham
            [npcKeys.questStarts] = {7791,7793,7794,7795,7796},
        },
        [14723] = { -- Mistina Steelshield
            [npcKeys.questStarts] = {7802,7803,7804,7805,7806},
        },
        [14724] = { -- Bubulo Acerbus
            [npcKeys.questStarts] = {7807,7808,7809,7811,7812},
        },
        [14726] = { -- Rashona Straglash
            [npcKeys.questStarts] = {7824,7826,7827,7831,7832},
        },
        [14727] = { -- Vehena
            [npcKeys.questStarts] = {7833,7834,7835,7836,7837},
        },
        [14728] = { -- Rumstag Proudstrider
            [npcKeys.questStarts] = {7820,7821,7822,7823,7825},
        },
        [14729] = { -- Ralston Farnsley
            [npcKeys.questStarts] = {7813,7814,7817,7818,7819},
        },
        [14822] = { -- Sayge
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{53.24,75.84},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [14823] = { -- Silas Darkmoon
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{49.49,71.01},{-1,-1}}},
        },
        [14827] = { -- Burth
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{49.52,71.35},{-1,-1}}},
        },
        [14828] = { -- Gelvas Grimegate
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{47.77,64.78},{-1,-1}}},
            [npcKeys.questStarts] = {7940},
        },
        [14829] = { -- Yebb Neblegear
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{51.1,82.05},{-1,-1}}},
            [npcKeys.questStarts] = {7899,7900,7901,7902,7903,8222,29508},
            [npcKeys.questEnds] = {7899,7900,7901,7902,7903,7943,8222,8223,29444,29448,29468,29508},
        },
        [14832] = { -- Kerri Hicks
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{47.9,67.12},{-1,-1}}},
            [npcKeys.questStarts] = {7889,7890,7891,7892,7893,29433},
        },
        [14833] = { -- Chronos
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{55,70.77},{-1,-1}}},
            [npcKeys.questStarts] = {7881,7882,7883,7884,29512,29514,29516,29519},
        },
        [14841] = { -- Rinling
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{49.17,60.71},{-1,-1}}},
            [npcKeys.questStarts] = {7894,7895,7896,7897,7898,29438,29511,29517,29518},
        },
        [14842] = { -- Melnan Darkstone
            [npcKeys.questStarts] = {},
        },
        [14843] = { -- Kruban Darkblade
            [npcKeys.questStarts] = {},
        },
        [14844] = { -- Sylannia
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{50.54,69.56},{-1,-1}}},
        },
        [14845] = { -- Stamp Thunderhorn
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{52.9,67.94},{-1,-1}}},
        },
        [14846] = { -- Lhara
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{48.09,69.55},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [14847] = { -- Professor Thaddeus Paleo
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{51.89,60.93},{-1,-1}}},
            [npcKeys.waypoints] = {},
            [npcKeys.questEnds] = {7907,7927,7928,7929,10938,10939,10940,10941,13324,13325,13326,13327,27664,27665,27666,27667,29443,29446,29447,29449,29450,29451,29454,29456,29457,29458,29459,29460,29461,29464,29465,29485,29507},
        },
        [14849] = { -- Darkmoon Faire Carnie
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{44.79,88.94},{44.65,87.63},{48.75,69.37},{46.68,65.47},{44.88,87.5},{44.88,89.13},{43.65,87.1},{43.51,87.66},{51.59,68.07},{56.28,87.47},{51.97,55.09},{56.28,88.91},{53.47,84.33},{48.04,78.48},{56.38,87.15},{55.78,55.78},{-1,-1}}},
        },
        [14860] = { -- Flik
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{56.34,63.38},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [14864] = { -- Khaz Modan Ram
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{58.16,82.88},{56.22,82.64},{57.76,81.98},{-1,-1}}},
        },
        [14865] = { -- Felinni
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{55.23,82.77},{-1,-1}}},
        },
        [14866] = { -- Flik's Frog
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{56.3,63.33},{-1,-1}}},
        },
        [14867] = { -- Jubjub
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{59.53,65.77},{57.38,64.09},{-1,-1}}},
        },
        [14868] = { -- Hornsley
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{53.71,82.42},{-1,-1}}},
        },
        [14871] = { -- Morja
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{55.93,70.73},{-1,-1}}},
        },
        [14902] = { -- Jin'rokh the Breaker
            [npcKeys.questStarts] = {8041,8042,8043,8044,8045,8046,8047,8048,8053,8054,8055,8058,8078,8079},
        },
        [14903] = { -- Al'tabim the All-Seeing
            [npcKeys.questStarts] = {8049,8050,8051,8052,8059,8060,8061,8068,8069,8070,8071,8076,8077,8101,8102,8103,8104,8106,8107,8108,8109},
        },
        [14904] = { -- Maywiki of Zuldazar
            [npcKeys.questStarts] = {8056,8057,8064,8065,8074,8075,8110,8111,8112,8113,8116,8117,8118,8119},
        },
        [14905] = { -- Falthir the Sightless
            [npcKeys.questStarts] = {8062,8063,8066,8067,8072,8073,8141,8142,8143,8144,8145,8146,8147,8148},
        },
        [14910] = { -- Exzhal
            [npcKeys.questStarts] = {8201},
        },
        [14921] = { -- Rin'wosho the Trader
            [npcKeys.questStarts] = {8196,8243,8246},
        },
        [14983] = { -- Field Marshal Oslight
            [npcKeys.questStarts] = {8105,8114,8115,8166,8167,8168},
        },
        [15011] = { -- Wagner Hammerstrike
            [npcKeys.questStarts] = {8149},
        },
        [15012] = { -- Javnir Nashak
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{46.25,15.1}}},
            [npcKeys.questStarts] = {8150},
        },
        [15021] = { -- Deathmaster Dwire
            [npcKeys.questStarts] = {8120,8121,8122,8169,8170,8171},
        },
        [15042] = { -- Zanza the Restless
            [npcKeys.questStarts] = {8184,8185,8186,8187,8188,8189,8190,8191,8192,9208,9209,9210},
        },
        [15070] = { -- Vinchaxa
            [npcKeys.questStarts] = {8195,8238,8239,8240},
        },
        [15077] = { -- Riggle Bassbait
            [npcKeys.questEnds] = {8193},
        },
        [15131] = { -- Qeeju
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [15170] = { -- Rutgar Glyphshaper
            [npcKeys.questStarts] = {8309,8314,8381},
        },
        [15183] = { -- Geologist Larksbane
            [npcKeys.questStarts] = {8284,8285,8316,8376,8377,8378,8379,8380,8381,8382},
        },
        [15192] = { -- Anachronos
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{58.1,56.16}}},
            [npcKeys.questStarts] = {8747,8748,8749,8750,8751,8752,8753,8754,8755,8756,8757,8758,8759,8760,8761,8764,8765,8766,9251,9257,9269,9270,9271,29134,29135,29193},
        },
        [15197] = { -- Darkcaller Yanka
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.12,67.83}}},
        },
        [15215] = { -- Mistress Natalia Mar'alith
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{55.58,90.63}}},
        },
        [15270] = { -- Huum Wildmane
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{53.19,35.2}}},
        },
        [15273] = { -- Arcane Wraith
            [npcKeys.questStarts] = {},
        },
        [15278] = { -- Magistrix Erona
            [npcKeys.questStarts] = {8325,8326,8327,8328,8329,8563,8564,9392,9393,9676},
        },
        [15279] = { -- Julia Sunstriker
            [npcKeys.questEnds] = {8328,10068},
        },
        [15280] = { -- Jesthenis Sunstriker
            [npcKeys.questEnds] = {9676,10069},
        },
        [15283] = { -- Summoner Teli'Larien
            [npcKeys.questStarts] = {10073},
            [npcKeys.questEnds] = {8344,8563,10073},
        },
        [15284] = { -- Matron Arena
            [npcKeys.questEnds] = {8564,10072},
        },
        [15285] = { -- Pathstalker Kariel
            [npcKeys.questStarts] = {10071},
            [npcKeys.questEnds] = {9392,10071},
        },
        [15294] = { -- Feral Tender
            [npcKeys.questStarts] = {},
        },
        [15295] = { -- Well Watcher Solanian
            [npcKeys.spawns] = {[zoneIDs.EVERSONG_WOODS] = {{38.97,20.26}}},
            [npcKeys.questStarts] = {8330,8345},
            [npcKeys.questEnds] = {8330,8345},
        },
        [15296] = { -- Arcanist Ithanas
            [npcKeys.questStarts] = {8336},
            [npcKeys.questEnds] = {8336},
        },
        [15297] = { -- Arcanist Helion
            [npcKeys.questStarts] = {8346},
            [npcKeys.questEnds] = {8338,8346},
        },
        [15298] = { -- Tainted Arcane Wraith
            [npcKeys.questStarts] = {},
        },
        [15303] = { -- Maxima Blastenheimer
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{52.5,56.14},{-1,-1}}},
        },
        [15306] = { -- Bor Wildmane
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{53.15,35.13}}},
        },
        [15308] = { -- Twilight Prophet
            [npcKeys.waypoints] = {},
        },
        [15309] = { -- Spoops
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.12,66.45}}},
            [npcKeys.zoneID] = zoneIDs.TIRISFAL_GLADES,
        },
        [15310] = { -- Jesper
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{32.03,50.39}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [15378] = { -- Merithra of the Dream
            [npcKeys.spawns] = {[zoneIDs.AQ40_VAULT_OF_CTHUN] = {{51.01,82.33}},[zoneIDs.AHN_QIRAJ] = {{-1,-1}}},
        },
        [15379] = { -- Caelestrasz
            [npcKeys.spawns] = {[zoneIDs.AQ40_VAULT_OF_CTHUN] = {{50.76,84.5}},[zoneIDs.AHN_QIRAJ] = {{-1,-1}}},
        },
        [15380] = { -- Arygos
            [npcKeys.spawns] = {[zoneIDs.AQ40_VAULT_OF_CTHUN] = {{49.45,85.2}},[zoneIDs.AHN_QIRAJ] = {{-1,-1}}},
        },
        [15401] = { -- Ley-Keeper Velania
            [npcKeys.spawns] = {[zoneIDs.EVERSONG_WOODS] = {{36.7,57.44}}},
        },
        [15403] = { -- Aeldon Sunbrand
            [npcKeys.questEnds] = {8463,8482,8483,8896,9357},
        },
        [15502] = { -- Andorgos
            [npcKeys.spawns] = {[zoneIDs.AHN_QIRAJ] = {{59.59,68.12},{-1,-1}}},
        },
        [15503] = { -- Kandrostrasz
            [npcKeys.spawns] = {[zoneIDs.AHN_QIRAJ] = {{59.13,68.78},{-1,-1}}},
        },
        [15504] = { -- Vethsera
            [npcKeys.spawns] = {[zoneIDs.AHN_QIRAJ] = {{59.5,68.69},{-1,-1}}},
        },
        [15513] = { -- Ranger Sallina
            [npcKeys.questEnds] = {9393,10070},
        },
        [15541] = { -- Twilight Marauder Morna
            [npcKeys.waypoints] = {},
        },
        [15549] = { -- Elder Morndeep
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{50.5,62.7},{-1,-1}}},
            [npcKeys.questStarts] = {8619},
        },
        [15556] = { -- Elder Splitrock
            [npcKeys.spawns] = {[zoneIDs.MARAUDON_ZAETARS_GRAVE] = {{51.4,93.7}},[zoneIDs.MARAUDON] = {{-1,-1}}},
            [npcKeys.questStarts] = {8635},
        },
        [15557] = { -- Elder Rumblerock
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{70.11,45.39}}},
            [npcKeys.questStarts] = {8636},
        },
        [15558] = { -- Elder Silvervein
            [npcKeys.questStarts] = {8642},
        },
        [15559] = { -- Elder Highpeak
            [npcKeys.questStarts] = {8643},
        },
        [15560] = { -- Elder Stonefort
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_SPIRE_TAZZ_ALOR] = {{61.7,39.9}},[zoneIDs.LOWER_BLACKROCK_SPIRE] = {{-1,-1}}},
            [npcKeys.questStarts] = {8644},
        },
        [15561] = { -- Elder Obsidian
            [npcKeys.questStarts] = {8645},
        },
        [15562] = { -- Elder Hammershout
            [npcKeys.questStarts] = {8646},
        },
        [15563] = { -- Elder Bellowrage
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{54.28,49.49}}},
            [npcKeys.questStarts] = {8647},
        },
        [15564] = { -- Elder Darkcore
            [npcKeys.questStarts] = {8648},
        },
        [15565] = { -- Elder Stormbrow
            [npcKeys.questStarts] = {8649},
        },
        [15566] = { -- Elder Snowcrown
            [npcKeys.questStarts] = {8650},
        },
        [15567] = { -- Elder Ironband
            [npcKeys.questStarts] = {8651},
        },
        [15568] = { -- Elder Graveborn
            [npcKeys.questStarts] = {8652},
        },
        [15569] = { -- Elder Goldwell
            [npcKeys.questStarts] = {8653},
        },
        [15570] = { -- Elder Primestone
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{30.8,13.32}}},
            [npcKeys.questStarts] = {8654},
        },
        [15572] = { -- Elder Runetotem
            [npcKeys.questStarts] = {8670},
        },
        [15573] = { -- Elder Ragetotem
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{37.24,79.06}}},
            [npcKeys.questStarts] = {8671},
        },
        [15574] = { -- Elder Stonespire
            [npcKeys.questStarts] = {8672},
        },
        [15575] = { -- Elder Bloodhoof
            [npcKeys.questStarts] = {8673},
        },
        [15576] = { -- Elder Winterhoof
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{39.96,72.51}}},
            [npcKeys.questStarts] = {8674},
        },
        [15577] = { -- Elder Skychaser
            [npcKeys.questStarts] = {8675},
        },
        [15578] = { -- Elder Wildmane
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{34.5,39.2},{-1,-1}}},
            [npcKeys.questStarts] = {8676},
        },
        [15579] = { -- Elder Darkhorn
            [npcKeys.questStarts] = {8677},
        },
        [15580] = { -- Elder Ezra Wheathoof
            [npcKeys.questStarts] = {8678},
        },
        [15581] = { -- Elder Grimtotem
            [npcKeys.questStarts] = {8679},
        },
        [15582] = { -- Elder Windtotem
            [npcKeys.questStarts] = {8680},
        },
        [15583] = { -- Elder Thunderhorn
            [npcKeys.questStarts] = {8681},
        },
        [15584] = { -- Elder Skyseer
            [npcKeys.questStarts] = {8682},
        },
        [15585] = { -- Elder Dawnstrider
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{52.38,23.93}}},
            [npcKeys.questStarts] = {8683},
        },
        [15586] = { -- Elder Dreamseer
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{51.4,28.81}}},
            [npcKeys.questStarts] = {8684},
        },
        [15587] = { -- Elder Mistwalker
            [npcKeys.questStarts] = {8685},
        },
        [15588] = { -- Elder High Mountain
            [npcKeys.questStarts] = {8686},
        },
        [15592] = { -- Elder Windrun
            [npcKeys.questStarts] = {8688},
        },
        [15593] = { -- Elder Starsong
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{62.8,34.2},{-1,-1}}},
            [npcKeys.questStarts] = {8713},
        },
        [15594] = { -- Elder Moonstrike
            [npcKeys.questStarts] = {8714},
        },
        [15595] = { -- Elder Bladeleaf
            [npcKeys.questStarts] = {8715},
        },
        [15596] = { -- Elder Starglade
            [npcKeys.questStarts] = {8716},
        },
        [15597] = { -- Elder Moonwarden
            [npcKeys.questStarts] = {8717},
        },
        [15598] = { -- Elder Bladeswift
            [npcKeys.questStarts] = {8718},
        },
        [15599] = { -- Elder Bladesing
            [npcKeys.questStarts] = {8719},
        },
        [15600] = { -- Elder Skygleam
            [npcKeys.questStarts] = {8720},
        },
        [15601] = { -- Elder Starweave
            [npcKeys.questStarts] = {8721},
        },
        [15602] = { -- Elder Meadowrun
            [npcKeys.questStarts] = {8722},
        },
        [15603] = { -- Elder Nightwind
            [npcKeys.questStarts] = {8723},
        },
        [15604] = { -- Elder Morningdew
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{77.09,75.61}}},
            [npcKeys.questStarts] = {8724},
        },
        [15605] = { -- Elder Riversong
            [npcKeys.questStarts] = {8725},
        },
        [15606] = { -- Elder Brightspear
            [npcKeys.questStarts] = {8726},
        },
        [15607] = { -- Elder Farwhisper
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME] = {{78.5,22},{-1,-1}}},
            [npcKeys.questStarts] = {8727},
        },
        [15608] = { -- Medivh
            [npcKeys.spawns] = {[zoneIDs.THE_BLACK_MORASS] = {{48.75,72.42},{-1,-1}}},
        },
        [15623] = { -- Xandivious
            [npcKeys.spawns] = {},
        },
        [15664] = { -- Metzen the Reindeer
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{44.12,38.58}}},
            [npcKeys.waypoints] = {},
        },
        [15690] = { -- Prince Malchezaar
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_NETHERSPACE] = {{51.54,30.97}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [15700] = { -- Warlord Gorchuk
            [npcKeys.questStarts] = {8851,8852,8853,8854,8855},
        },
        [15701] = { -- Field Marshal Snowfall
            [npcKeys.questStarts] = {8847,8848,8849,8850},
            [npcKeys.questEnds] = {8795,8796,8797,8846,8847,8848,8849,8850,10501},
        },
        [15732] = { -- Wonderform Operator
            [npcKeys.spawns] = {
                -- [zoneIDs.THE_EXODAR] = {{79.28,55.14}}, -- correct coords, but commented out because it's not offering the quest here
                [zoneIDs.STORMWIND_CITY] = {{67.85,71.45}}, --
                [zoneIDs.DALARAN] = {{49.35,44.82}},
                [zoneIDs.DUN_MOROGH] = {{60.31,33.84}},
                [zoneIDs.EVERSONG_WOODS] = {{56.45,51.79}},
                [zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{40.27,67.63}},
                [zoneIDs.ORGRIMMAR] = {{50.21,61.83}},
                [zoneIDs.TIRISFAL_GLADES] = {{61.03,59.36}},
                [zoneIDs.WETLANDS] = {{9.17,60.72}},
                [zoneIDs.TANARIS] = {{52.57,28.06}},
                -- [zoneIDs.SHATTRATH_CITY] = {{79.83,58.97}}, -- correct coords, but commented out because it's not offering the quest here
            },
            [npcKeys.questStarts] = {8827,8828,8860,8861},
        },
        [15864] = { -- Valadar Starsong
            [npcKeys.questStarts] = {8868,8883},
        },
        [15871] = { -- Elder Bronzebeard
            [npcKeys.questStarts] = {8866},
        },
        [15891] = { -- Lunar Festival Herald
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR] = {{49.88,81.2}},
                [zoneIDs.UNDERCITY] = {{66.74,43.39}},
                [zoneIDs.THUNDER_BLUFF] = {{38.37,63.42}},
            },
            [npcKeys.questStarts] = {8873},
        },
        [15892] = { -- Lunar Festival Emissary
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY] = {{61.73,75.73}},
                [zoneIDs.IRONFORGE] = {{30.92,61.59}},
                [zoneIDs.DARNASSUS] = {{45.16,52.24}},
            },
            [npcKeys.questStarts] = {8870},
        },
        [15895] = { -- Lunar Festival Harbinger
            [npcKeys.spawns] = {
                [zoneIDs.DARNASSUS] = {{38.59,30.28}},
                [zoneIDs.UNDERCITY] = {{65.62,36.0}},
                [zoneIDs.ORGRIMMAR] = {{52.39,58.49}},
                [zoneIDs.THUNDER_BLUFF] = {{71.12,28.2}},
                [zoneIDs.IRONFORGE] = {{28.85,16.23}},
                [zoneIDs.ELWYNN_FOREST] = {{34.24,50.56}},
                [zoneIDs.THE_EXODAR] = {{74.02,57.47}},
                [zoneIDs.SILVERMOON_CITY] = {{73.1,82.6}},
                [zoneIDs.SHATTRATH_CITY] = {{53.29,33.1},{48.14,36.87}},
                [zoneIDs.DALARAN] = {{47.65,43.76}},
            },
            [npcKeys.questStarts] = {8867,8883},
        },
        [16089] = { -- Omar the Test Dragon
            [npcKeys.questEnds] = {9583},
        },
        [16112] = { -- Crusade Commander Korfax
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {
                {72.53,74.78,phases.SCARLET_ENCLAVE_ENTRACE},
                {75.35,76.18,phases.SCARLET_ENCLAVE},
            }},
        },
        [16115] = { -- Crusade Commander Eligor Dawnbringer
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {
                {72.54,74.91,phases.SCARLET_ENCLAVE_ENTRACE},
                {76.71,73.1,phases.SCARLET_ENCLAVE},
            }},
        },
        [16116] = { -- Archmage Angela Dosantos
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {
                {72.65,74.84,phases.SCARLET_ENCLAVE_ENTRACE},
                {76.08,75.35,phases.SCARLET_ENCLAVE},
            }},
        },
        [16128] = { -- Rhonin
            [npcKeys.zoneID] = zoneIDs.DALARAN,
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {13158,26012,29829},
        },
        [16280] = { -- Perascamin
            [npcKeys.questEnds] = {14081},
        },
        [16307] = { -- Deathcage Scryer
            [npcKeys.waypoints] = {},
        },
        [16333] = { -- Sentinel Infiltrator
            [npcKeys.waypoints] = {},
        },
        [16388] = { -- Koren
            [npcKeys.questEnds] = {9840},
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_SERVANTS_QUARTERS] = {{42.4,72.94}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [16402] = { -- Zombified Grimscale
            [npcKeys.spawns] = {[zoneIDs.GHOSTLANDS] = {{22.08,33.44},{20.4,32.3},{21.37,31.4},{18.37,7.8},{18.62,5.58},{18.12,6.57},{18.26,10.52},{18.93,9.79},{17.78,9.87},{18.32,8.97},{18.02,12.31},{18.39,14.41},{19.17,14.19},{20.34,19.03},{19.09,19.96},{19.13,19.08},{20.05,20.46},{19.61,21.02},{18.96,21.54},{18.21,20.57},{19.91,23.94},{19.06,23.75},{19.01,24.91},{18.03,24.87},{18.14,29.39},{17.38,28.27},{17.15,31.16},{16.23,31.1},{16.52,31.98},{15.16,31.27},{12.98,31.26},{15.95,32.29},{13.03,37.28},{14.24,39.77},{14.95,40.03},{12.84,40.09},{12.11,38.57},{13.01,43.11},{18.38,33.99},{19.25,34.29},{18.57,32.82},{20.5,34.48}}},
        },
        [16403] = { -- Withered Grimscale
            [npcKeys.spawns] = {[zoneIDs.GHOSTLANDS] = {{21.7,34.15},{22.32,33.5},{22.15,33.1},{18.64,8.29},{18.54,6.19},{19.31,6.95},{17.88,10.47},{18.3,8.59},{18.07,7.42},{19.01,11.24},{18.14,11.12},{19.16,13.01},{19.05,13.94},{19.04,17.3},{18.18,17.73},{18.85,18.4},{19.48,20.04},{21.06,23.64},{19.35,21.66},{18.4,18.71},{20.16,23.03},{18.15,21.96},{19.96,23.7},{18.13,26.11},{18.06,26.59},{16.93,29.2},{18.47,31.45},{19.08,31.37},{16.18,31.98},{13.72,31.36},{13.85,32.6},{12.04,33.85},{13.15,32.47},{14.83,32.35},{12.89,35.45},{14.12,38.43},{12.91,38.49},{13.02,34.0},{14.54,40.2},{13.19,41.47},{14.01,42.99},{14.22,44.48},{14.2,46.49},{14.23,47.65},{18.33,32.64},{17.11,32.71},{20.14,35.92},{21.0,34.78},{21.16,34.36},{20.99,34.93},{23.41,34.52}}},
        },
        [16483] = { -- Draenei Survivor
            [npcKeys.questStarts] = {},
        },
        [16499] = { -- Keilnei
            [npcKeys.questStarts] = {9288,26963},
        },
        [16500] = { -- Valaatu
            [npcKeys.questStarts] = {9290,26968},
            [npcKeys.questEnds] = {9290,26968},
        },
        [16501] = { -- Aurelon
            [npcKeys.questStarts] = {9287,26966},
        },
        [16502] = { -- Zalduun
            [npcKeys.questStarts] = {9283,9291,26970},
            [npcKeys.questEnds] = {9283,9291,9409,26970},
        },
        [16503] = { -- Kore
            [npcKeys.questStarts] = {9289,26958},
        },
        [16524] = { -- Shade of Aran
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_GUARDIANS_LIBRARY] = {{71.61,26.32}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [16534] = { -- Inoculated Nestlewood Owlkin
            [npcKeys.questStarts] = {},
        },
        [16535] = { -- Vindicator Aldar
            [npcKeys.questEnds] = {9303,9306,9307,9308,9311,9798,10304},
        },
        [16574] = { -- Far Seer Regulkut
            [npcKeys.questStarts] = {9344,9410},
        },
        [16575] = { -- Shadow Hunter Ty'jin
            [npcKeys.questStarts] = {9496,29688},
        },
        [16576] = { -- Overlord Hun Maimfist
            [npcKeys.questStarts] = {},
        },
        [16583] = { -- Rohok
            [npcKeys.questStarts] = {10757,10758},
        },
        [16647] = { -- Talionia
            [npcKeys.questStarts] = {9529},
        },
        [16648] = { -- Zanien
            [npcKeys.questStarts] = {27282,28299},
        },
        [16658] = { -- Aldrae
            [npcKeys.questStarts] = {27331,27332,27334,27335,28164,28304,28307,28308,28309,28323},
        },
        [16673] = { -- Oninath
            [npcKeys.questStarts] = {},
        },
        [16681] = { -- Champion Bachi
            [npcKeys.questStarts] = {9601,27298,27304,28302,28303},
        },
        [16684] = { -- Zelanis
            [npcKeys.questStarts] = {6681,10372,27279,28298},
        },
        [16700] = { -- Shattered Hand Legionnaire
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{44.28,14.01},{37.96,13.22},{34.5,77.17},{40.95,77.22},{43.04,77.21},{46.54,77.19},{52.4,75.73},{59.05,79.2},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_SHATTERED_HALLS] = {{{34.5,77.17},{33.91,78.13},{33.19,78.11},{32.99,77.05},{33.46,75.67},{34.24,74.5},{34.9,75.02},{35.05,76.16},{34.5,77.17}},{{59.05,79.2},{59.13,85.69}},{{52.39,75.73},{51.86,76.64},{51.86,78.15},{52.39,79.06}}}},
        },
        [16721] = { -- Shalannius
            [npcKeys.questStarts] = {27273},
        },
        [16756] = { -- Caedmos
            [npcKeys.questStarts] = {27268,27269,27274,28285},
        },
        [16802] = { -- Lor'themar Theron
            [npcKeys.questEnds] = {9328,9627,9811,24615},
        },
        [16807] = { -- Grand Warlock Nethekurse
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{32.21,61.93},{-1,-1}}},
        },
        [16808] = { -- Warchief Kargath Bladefist
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{67.17,54.37},{-1,-1}}},
        },
        [16809] = { -- Warbringer O'mrogg
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{53.89,34.1},{-1,-1}}},
        },
        [16813] = { -- Wravien
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_THE_MENAGERIE] = {{38.2,45.19}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [16814] = { -- Gradav
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_THE_MENAGERIE] = {{28.89,46.28}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [16815] = { -- Kamsis
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_THE_MENAGERIE] = {{27.8,60.13}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [16817] = { -- Festival Loremaster
            [npcKeys.spawns] = {
                [zoneIDs.DARNASSUS] = {{62.17,48.67}},
                [zoneIDs.STORMWIND_CITY] = {{49.53,72.27}},
                [zoneIDs.IRONFORGE] = {{63.81,25.31}},
                [zoneIDs.SHATTRATH_CITY] = {{61.39,31.91}},
                [zoneIDs.THE_EXODAR] = {{41.62,25.28}},
            },
            [npcKeys.questStarts] = {9365,11964},
        },
        [16818] = { -- Festival Talespinner
            [npcKeys.spawns] = {
                [zoneIDs.TIRISFAL_GLADES] = {{62.16,66.8}},
                [zoneIDs.THUNDER_BLUFF] = {{21.63,27.72}},
                [zoneIDs.ORGRIMMAR] = {{47.73,38.19}},
                [zoneIDs.SHATTRATH_CITY] = {{62.16,32.04}},
                [zoneIDs.SILVERMOON_CITY] = {{69.84,42.97}},
            },
            [npcKeys.questStarts] = {9339,11966},
        },
        [16819] = { -- Force Commander Danath Trollbane
            [npcKeys.questStarts] = {9492,10141,10160,10400,10558,10762,10937,29689},
        },
        [16841] = { -- Watch Commander Relthorn Netherwane
            [npcKeys.questEnds] = {26173,26174,64038},
        },
        [16915] = { -- Foreman Razelcraz
            [npcKeys.waypoints] = {},
        },
        [17071] = { -- Technician Zhanaa
            [npcKeys.questEnds] = {9305,9312},
        },
        [17076] = { -- Lady Liadrin
            [npcKeys.questEnds] = {9745,10960,64139,64140,64141,64142,64143,64144,64145},
        },
        [17082] = { -- Rifleman Torrig
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{54.48,32.94}}},
        },
        [17105] = { -- Emissary Valustraa
            [npcKeys.subName] = nil,
        },
        [17120] = { -- Behomat
            [npcKeys.questStarts] = {27225,28258},
        },
        [17225] = { -- Nightbane
            [npcKeys.spawns] = {[zoneIDs.KARAZHAN_MASTERS_TERRACE] = {{45.66,87.32}},[zoneIDs.KARAZHAN] = {{-1,-1}}},
        },
        [17240] = { -- Admiral Odesyus
            [npcKeys.questStarts] = {9506,9530,9531,9537,9602,9751},
        },
        [17257] = { -- Magtheridon
            [npcKeys.spawns] = {[zoneIDs.MAGTHERIDONS_LAIR] = {{69.06,74.12},{-1,-1}}},
        },
        [17288] = { -- Randy Whizzlesprocket
            [npcKeys.questStarts] = {9524},
        },
        [17294] = { -- Drisella
            [npcKeys.questStarts] = {9525},
        },
        [17306] = { -- Watchkeeper Gargolmar
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{77.23,33.3},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{{77.23,33.3},{74,29.97},{67.98,30.77},{64.93,35.84}}}},
        },
        [17307] = { -- Nazan
            [npcKeys.name] = "Nazan",
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{34.64,86.17},{-1,-1}}},
        },
        [17308] = { -- Omor the Unscarred
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{38.98,20.01},{-1,-1}}},
        },
        [17310] = { -- Gnarl
            [npcKeys.waypoints] = {},
        },
        [17377] = { -- Keli'dan the Breaker
            [npcKeys.spawns] = {[zoneIDs.THE_BLOOD_FURNACE] = {{58.29,41.29},{-1,-1}}},
        },
        [17381] = { -- The Maker
            [npcKeys.spawns] = {[zoneIDs.THE_BLOOD_FURNACE] = {{36.89,41.19},{-1,-1}}},
        },
        [17465] = { -- Shattered Hand Centurion
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{45.65,18.22},{45.42,9.73},{37.37,9.21},{37.37,18.87},{-1,-1}}},
        },
        [17479] = { -- Gunny
            [npcKeys.questStarts] = {9589,9607},
        },
        [17481] = { -- Semid
            [npcKeys.questStarts] = {9595},
        },
        [17493] = { -- Stone Guard Stok'ton
            [npcKeys.questStarts] = {9572},
        },
        [17519] = { -- Hobahken
            [npcKeys.questStarts] = {27270,28287},
        },
        [17537] = { -- Vazruden
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{36.06,82.36},{-1,-1}}},
        },
        [17538] = { -- O'ros
            [npcKeys.questStarts] = {10968},
        },
        [17555] = { -- Stephanos
            [npcKeys.spawns] = {[zoneIDs.THE_EXODAR] = {{54.49,36.27}}},
        },
        [17557] = { -- Lieutenant Chadwick
            [npcKeys.questStarts] = {9575},
        },
        [17558] = { -- Caza'rez
            [npcKeys.questStarts] = {9590,9608},
        },
        [17666] = { -- Astur
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [17671] = { -- Shattered Hand Champion
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{67.73,47.09},{66.82,47.09},{60.02,33.58},{60.02,34.83},{53.45,23.8},{54.25,23.8},{51.17,13.2},{51.17,14.49},{-1,-1}}},
        },
        [17717] = { -- Knight-Lord Bloodvalor
            [npcKeys.questEnds] = {9677,9678,9679,9684,9685,9691,9692,9712,63866},
        },
        [17770] = { -- Hungarfen
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{70.27,91.11},{-1,-1}}},
        },
        [17796] = { -- Mekgineer Steamrigger
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{32.12,83.49},{-1,-1}}},
        },
        [17797] = { -- Hydromancer Thespia
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{54.27,12.06},{-1,-1}}},
        },
        [17798] = { -- Warlord Kalithresh
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{81.11,43.4},{-1,-1}}},
        },
        [17827] = { -- Claw
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{41.39,22.52},{-1,-1}}},
        },
        [17839] = { -- Rift Lord
            [npcKeys.spawns] = {[zoneIDs.THE_BLACK_MORASS] = {{42.85,59.39},{49.93,53.45},{57.05,63.59},{57.45,73.21},{-1,-1}}},
        },
        [17841] = { -- Ysiel Windsinger
            [npcKeys.questStarts] = {9716,9718,9720,9724,9764,9765,9766,9778,9876,10459,29566,29616},
            [npcKeys.questEnds] = {9716,9718,9720,9731,9732,9734,9752,9764,9765,9766,9912,10459},
        },
        [17856] = { -- Gzhun'tt
            [npcKeys.questStarts] = {9714,9715,9726,9727},
        },
        [17857] = { -- T'shu
            [npcKeys.questStarts] = {9717},
        },
        [17866] = { -- Khn'nix
            [npcKeys.questStarts] = {9719},
        },
        [17876] = { -- Thrall
            [npcKeys.spawns] = {[zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {{74.41,57.6},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.OLD_HILLSBRAD_FOOTHILLS,
            [npcKeys.questStarts] = {10283,10284,29599},
        },
        [17881] = { -- Aeonus
            [npcKeys.spawns] = {[zoneIDs.THE_BLACK_MORASS] = {{42.85,59.39},{49.93,53.45},{57.05,63.59},{57.45,73.21},{-1,-1}}},
        },
        [17882] = { -- The Black Stalker
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{25.32,43.99},{-1,-1}}},
        },
        [17884] = { -- Watcher Jhang
            [npcKeys.questStarts] = {9738,9763},
        },
        [17885] = { -- Earthbinder Rayge
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{67.4,21.23},{-1,-1}}},
        },
        [17890] = { -- Weeder Greenthumb
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{48.8,83.57},{-1,-1}}},
        },
        [17893] = { -- Naturalist Bite
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{95.79,66.26},{-1,-1}}},
        },
        [17894] = { -- Windcaller Claw
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{41.39,22.52},{-1,-1}}},
        },
        [17896] = { -- Kameel Longstride
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [17941] = { -- Mennu the Betrayer
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{48.79,25.51},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_SLAVE_PENS] = {{{48.79,25.51},{48.77,13.43}}}},
        },
        [17942] = { -- Quagmirran
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{81.2,80.52},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_SLAVE_PENS] = {{{85.29,67.61},{81.2,80.52}}}},
        },
        [17975] = { -- High Botanist Freywinn
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{25.69,26},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_BOTANICA] = {{{26.27,25.25},{25.69,26}}}},
            [npcKeys.questStarts] = {},
        },
        [17976] = { -- Commander Sarannis
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{43.46,24},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_BOTANICA] = {{{46.66,19.19},{43.46,24}}}},
            [npcKeys.questStarts] = {},
        },
        [17977] = { -- Warp Splinter
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{33.99,36.55},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [17978] = { -- Thorngrin the Tender
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{7,48.1},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [17980] = { -- Laj
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{34.12,89.38},{-1,-1}}},
        },
        [17991] = { -- Rokmar the Crackler
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{57.1,36.58},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_SLAVE_PENS] = {{{57.13,44.34},{57.58,39.93},{57.1,36.58},{56.47,31.21}}}},
        },
        [18090] = { -- Captain Kroghan
            [npcKeys.questEnds] = {9797},
        },
        [18096] = { -- Epoch Hunter
            [npcKeys.spawns] = {[zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {{50.44,31.55},{-1,-1}}},
        },
        [18098] = { -- Kialon Nightblade
            [npcKeys.questEnds] = {9794},
        },
        [18020] = { -- Defender Adrielle
            [npcKeys.questStarts] = {},
        },
        [18105] = { -- Ghaz'an
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{78.36,28.44},{-1,-1}}},
        },
        [18244] = { -- Khalan
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [18248] = { -- Nekthar
            [npcKeys.questEnds] = {9795},
        },
        [18250] = { -- Joraal
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [18311] = { -- Ethereal Crypt Raider
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{38.89,83.59},{38.74,84.97},{56.95,28.92},{54.43,27.73},{44.35,31.27},{44.36,23.46},{44.9,35.45},{40.71,32.33},{40.99,29.67},{40.99,27.92},{38.61,29.41},{38.63,27.84},{37.32,28.4},{33.19,26.27},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.MANA_TOMBS] = {{{44.35,31.27},{43.58,29.1},{44.35,25.83},{45.06,25.06},{45.87,24.52},{46.29,25.5},{46.98,28.48},{46.52,30.85},{46.27,32.54},{44.35,31.27}},{{33.48,23.45},{33.85,25.91},{35.23,28.02},{37.32,28.4}}}},
        }, 
        [18312] = { -- Ethereal Spellbinder
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{32.07,62.08},{32.94,62.47},{32.64,74.71},{33.28,74.6},{34.37,68.43},{35.23,67.38},{38.19,84.85},{38.12,83.84},{41.2,81.43},{41.14,87.2},{41.96,88.59},{47.2,83.92},{47.2,85.04},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.MANA_TOMBS] = {{{32.1,64.27},{32.64,74.71}},{{32.68,64.06},{33.28,74.6}}}},
        },
        [18313] = { -- Ethereal Sorcerer
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{54.86,80.87},{55.99,63.01},{60.74,55.62},{60.21,50.9},{60.72,44.94},{57.77,37.36},{62.65,33.8},{61.79,23.33},{59.94,22.75},{57.32,22.84},{56.48,29.3},{54.43,29.53},{44.35,31.27},{45.42,23.56},{46.43,33.38},{41.56,33.41},{41.82,28.71},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.MANA_TOMBS] = {{{44.35,31.27},{43.58,29.1},{44.35,25.83},{45.06,25.06},{45.87,24.52},{46.29,25.5},{46.98,28.48},{46.52,30.85},{46.27,32.54},{44.35,31.27}}}},
        },
        [18314] = { -- Nexus Stalker
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{42.12,81.64},{42.79,80.82},{42.54,87.32},{49.21,84.32},{49.79,84.97},{49.79,83.87},{53.61,82.09},{53.58,82.62},{54.52,87.77},{57.08,84.97},{57.08,83.93},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.MANA_TOMBS] = {{{53.61,82.09},{54.71,82.7},{55.05,84.43},{54.45,86.15},{53.76,86.28},{52.99,86.03},{52.47,84.93},{52.41,83.28},{53.61,82.09}},{{53.58,82.62},{54.46,83.24},{54.71,84.58},{54.44,85.46},{53.72,85.87},{52.95,85.46},{52.64,84.79},{52.73,83.56},{53.58,82.62}},{{57.08,83.93},{62,83.93}},{{57.08,84.97},{62,84.97}}}},
        },
        [18341] = { -- Pandemonius
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{47.76,28.69},{-1,-1}}},
        }, 
        [18343] = { -- Tavarok
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{60.62,75.04},{-1,-1}}},
        }, 
        [18344] = { -- Nexus-Prince Shaffar
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{32.48,49.93},{-1,-1}}},
        }, 
        [18371] = { -- Shirrak the Dead Watcher
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{46.2,66.13}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{{46.2,66.13},{46.18,73.02}}}},
        },
        [18373] = { -- Exarch Maladaar
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{73.78,49.15}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
        },
        [18408] = { -- Warden Moi'bff Jill
            [npcKeys.questEnds] = {9792,9936,9938,9940,10476,10477},
        },
        [18446] = { -- Earthbinder Tavgren
            [npcKeys.questEnds] = {9957,9960,9961,9968,9971,9990,10005,10006},
        },
        [18472] = { -- Darkweaver Syth
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{48.63,67.84},{-1,-1}}},
        },
        [18473] = { -- Talon King Ikiss
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS_HALLS_OF_MOURNING] = {{32.48,27.48}},[zoneIDs.SETHEKK_HALLS] = {{-1,-1}}},
        },
        [18481] = { -- A'dal
            [npcKeys.questStarts] = {10167,10560,10704,10882,10884,10885,10886,10888,10949,13082,13430},
            [npcKeys.questEnds] = {10102,10210,10280,10560,10704,10708,10781,10882,10883,10884,10885,10886,10888,10948,11007,11052,11116,13081,13430,29657,29658,29659,29660,29667,29669,29674,29675,29681},
        },
        [18521] = { -- Raging Skeleton
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{64.35,85.57},{63.99,87.22},{60.1,90.57},{58.91,89.96},{57.14,87.87},{57.22,84.61}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
        },
        [18524] = { -- Angered Skeleton
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{62.64,87.12},{63.32,85.08},{62.11,84.35},{60.1,92.61},{61.77,90.5},{61.08,88.64},{58.68,85.85},{56.19,86.32}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
        },
        [18667] = { -- Blackheart the Inciter
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{26.6,69.63},{-1,-1}}},
        },
        [18702] = { -- Auchenai Necromancer
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{71.06,65},{76.41,59.27},{76.46,65.73},{71.63,71.03}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
        },
        [18708] = { -- Murmur
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{81.07,39.3},{-1,-1}}},
        },
        [18723] = { -- Erozion
            [npcKeys.spawns] = {
                [zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {
                    {28.95,48.34,phases.OHF_THRALL_PRISON},
                    {50.24,30.8,phases.OHF_THRALL_DESTINY},
                    {-1,-1},
                },
            },
            [npcKeys.questStarts] = {10283,10285,29598},
        },
        [18725] = { -- Brazen
            [npcKeys.spawns] = {[zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {{29.24,47.93},{-1,-1}}},
        },
        [18731] = { -- Ambassador Hellmaw
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{21.43,39.05},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.SHADOW_LABYRINTH] = {{{15.82,24.09},{15.18,25.5},{14.75,27.03},{14.55,28.41},{14.47,30.61},{14.52,32.56},{14.8,34.6},{15.38,36.28},{16.1,37.52},{17.06,38.39},{18.07,38.95},{18.9,39.07},{21.43,39.05},{21.7,39.06},{23.41,36.95},{28.47,36.77},{30.3,38.13},{30.28,40.17},{28.91,41.61},{23.55,41.53},{21.7,39.06}}}},
        },
        [18732] = { -- Grandmaster Vorpil
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{53.3,56.38},{-1,-1}}},
        },
        [18794] = { -- Cabal Ritualist
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{21.18,42.28},{21.92,43.27},{22.64,42.26},{21.91,41.18},{21.2,35.87},{21.96,34.73},{22.7,35.83},{21.95,36.89},{25.04,39.16},{24.28,38.08},{23.55,39.21},{24.27,40.26},{28.91,40.27},{28.15,39.19},{28.89,38.07},{29.65,39.15},{30.49,35.86},{31.22,34.74},{31.99,35.86},{31.22,36.97},{31.18,41.16},{31.94,42.24},{31.21,43.37},{30.4,42.29},{-1,-1}}},
        },
        [18848] = { -- Malicious Instructor
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{36.39,86.43},{32.3,58.84},{21.77,63.27},{26.65,54.18},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.SHADOW_LABYRINTH] = {{{36.39,86.43},{37.21,85.83},{38.63,86.28},{40.03,87.52},{41.57,87.64},{43.24,86.63},{44.09,87.26},{44.63,88.27},{44.27,89.51},{43.57,89.42},{42.57,88},{37.41,88.07},{36.33,87.68},{36.39,86.43}},{{32.3,58.84},{32.65,55.79},{31.39,55.72},{29.85,61.7},{31.1,62.74},{31.32,61.56},{32.3,58.84}},{{21.77,63.27},{22.1,61.19},{23,60.42},{21.73,55.82},{20.67,56.31},{20.83,58.54},{18.6,58.98},{20.85,58.94},{21.57,60.42}},{{26.65,54.18},{28.35,54.21},{28.37,60.09},{26.7,60.23},{24.93,59.86},{24.68,54.32},{26.65,54.18}}}},
        },
        [18891] = { -- Spy To'gun
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{17.11,22.1},{-1,-1}}},
            [npcKeys.questStarts] = {10091,29641},
        },
        [18893] = { -- Spymistress Mehlisah Highcrown
            [npcKeys.questStarts] = {10177,29642},
        },
        [18927] = { -- Human Commoner
            [npcKeys.questStarts] = {11441,11970,12753,12772,12775,12777,12808,14022},
        },
        [18956] = { -- Lakka
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{50.98,71.42},{-1,-1}}},
        },
        [18933] = { -- Isfar
            [npcKeys.questStarts] = {10097,10098},
        },
        [18940] = { -- Nutral
            [npcKeys.questStarts] = {11497,11498},
        },
        [18984] = { -- Trag
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [19018] = { -- Wilda Bearmane
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [19148] = { -- Dwarf Commoner
            [npcKeys.questStarts] = {11441,11970,12753,12772,12775,12777,12808,14022},
        },
        [19169] = { -- Blood Elf Commoner
            [npcKeys.questStarts] = {11446,11971,12752,12782,12783,12784,12811,13483,14036},
        },
        [19171] = { -- Draenei Commoner
            [npcKeys.questStarts] = {11441,11970,12753,12772,12775,12777,12808,14022},
        },
        [19172] = { -- Gnome Commoner
            [npcKeys.questStarts] = {11441,11970,12753,12772,12775,12777,12808,14022},
        },
        [19173] = { -- Night Elf Commoner
            [npcKeys.questStarts] = {11441,11970,12753,12772,12775,12777,12808,14022},
        },
        [19175] = { -- Orc Commoner
            [npcKeys.questStarts] = {11446,11971,12752,12782,12783,12784,12811,13483,14036},
        },
        [19176] = { -- Tauren Commoner
            [npcKeys.questStarts] = {11446,11971,12752,12782,12783,12784,12811,13483,14036},
        },
        [19177] = { -- Troll Commoner
            [npcKeys.questStarts] = {11446,11971,12752,12782,12783,12784,12811,13483,14036},
        },
        [19178] = { -- Forsaken Commoner
            [npcKeys.questStarts] = {11446,11971,12752,12782,12783,12784,12811,13483,14036},
        },
        [19218] = { -- Gatewatcher Gyro-Kill
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR] = {{46.44,58.62},{-1,-1}}},
            [npcKeys.questStarts] = {29659},
        },
        [19219] = { -- Mechano-Lord Capacitus
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR] = {{51.22,31.39},{-1,-1}}},
            [npcKeys.questStarts] = {29658},
        },
        [19220] = { -- Pathaleon the Calculator
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR_CALCULATION_CHAMBER] = {{27.39,60.62}},[zoneIDs.THE_MECHANAR] = {{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [19254] = { -- Warlord Dar'toon
            [npcKeys.questEnds] = {25694,25695,64063,64217},
        },
        [19255] = { -- General Krakork
            [npcKeys.waypoints] = {},
        },
        [19256] = { -- Sergeant Shatterskull
            [npcKeys.waypoints] = {},
        },
        [19310] = { -- Forward Commander Kingston
            [npcKeys.questStarts] = {10144,10146,10187,10340},
        },
        [19412] = { -- D'ore
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{73.71,55.41}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
        },
        [19428] = { -- Cobalt Serpent
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS_HALLS_OF_MOURNING] = {{32.46,67.08}},[zoneIDs.SETHEKK_HALLS] = {{48.97,94.83},{52.1,85.87},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.SETHEKK_HALLS_HALLS_OF_MOURNING] = {{{30.54,88.73},{28.54,86.74},{25.94,83.42},{25.94,81.48},{31.01,74.91},{31.56,72.68},{32.46,67.08}},{{44.09,96.18},{44.13,84.84},{44.86,82.77},{49.21,82.28},{51.94,82.87},{53.05,84.3},{53.14,92.67},{51.85,94.9},{51.4,94.9}}},[zoneIDs.SETHEKK_HALLS] = {{{51.4,94.9},{48.97,94.83}},{{52.1,85.87},{49.43,85.31},{48.85,88.04},{47.57,90.98},{45,89.08}}}},
        },
        [19496] = { -- Spy Grik'tha
            [npcKeys.questStarts] = {10178},
        },
        [19505] = { -- Sunseeker Channeler
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{8.12,45.09},{8.09,51.08},{19.09,53.12},{19.03,52.21},{19.06,50},{19.04,48.81},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_BOTANICA] = {{{8.09,51.08},{10.12,50.09}},{{8.12,45.09},{9.92,45.47}}}},
        },
        [19513] = { -- Mutate Fear-Shrieker
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{36.6,83.1},{36.01,80.37},{31.75,80.44},{32.52,79.53},{31.86,82.76},{31.12,84.36},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [19542] = { -- Field Commander Mahfuun
            [npcKeys.questStarts] = {10094},
        },
        [19570] = { -- Rocket-Chief Fuselage
            [npcKeys.questEnds] = {10183,10186,10237,10249,10701,11036,11037,11040,11042},
        },
        [19598] = { -- Mutate Fleshlasher
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{19.88,78.61},{18.71,80.56},{15.68,78.45},{16.59,77.74},{18.02,75.63},{18.42,74.65},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [19622] = { -- Kael'thas Sunstrider
            [npcKeys.spawns] = {[zoneIDs.TEMPEST_KEEP] = {{50.04,14.67},{-1,-1}}},
        },
        [19670] = { -- Artificer Morphalius
            [npcKeys.questStarts] = {10216},
        },
        [19671] = { -- Cryo-Engineer Sha'heen
            [npcKeys.questStarts] = {10218},
        },
        [19674] = { -- Nexus-Prince Haramad
            [npcKeys.questStarts] = {10165},
        },
        [19698] = { -- Greatfather Aldrimus
            [npcKeys.questStarts] = {10164,29595},
        },
        [19710] = { -- Gatewatcher Iron-Hand
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR] = {{60.27,50.79},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_MECHANAR] = {{{60.27,50.79},{60.89,37.26}}}},
            [npcKeys.questStarts] = {29659},
        },
        [19865] = { -- Mutate Horror
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{35.19,82.6},{36.92,81.62},{31.04,79.11},{33.38,80.3},{30.43,83.45},{32.77,83.59},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [19932] = { -- Andormu
            [npcKeys.questStarts] = {10561},
        },
        [19935] = { -- Soridormi
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{58.61,54.05}}},
            [npcKeys.waypoints] = {[zoneIDs.TANARIS] = {{{58.61,54.05},{58.60,54.06},{58.53,54.09},{58.47,54.13},{58.40,54.17},{58.34,54.21},{58.27,54.25},{58.21,54.30},{58.15,54.35},{58.07,54.45},{57.98,54.57},{57.92,54.64},{57.87,54.70},{57.82,54.77},{57.76,54.84},{57.72,54.89},{57.68,55.08},{57.66,55.21},{57.64,55.31},{57.62,55.41},{57.60,55.51},{57.58,55.61},{57.57,55.71},{57.56,55.81},{57.55,55.92},{57.54,56.02},{57.53,56.12},{57.51,56.23},{57.50,56.33},{57.50,56.37},{57.51,56.45},{57.53,56.66},{57.54,56.76},{57.55,56.87},{57.56,56.97},{57.57,57.07},{57.58,57.17},{57.59,57.28},{57.60,57.38},{57.62,57.48},{57.63,57.58},{57.64,57.69},{57.66,57.79},{57.67,57.89},{57.69,57.99},{57.70,58.09},{57.72,58.16},{57.80,58.28},{57.88,58.40},{57.93,58.48},{57.98,58.54},{58.01,58.58},{58.05,58.66},{58.11,58.73},{58.14,58.77},{58.20,58.81},{58.30,58.86},{58.37,58.90},{58.43,58.93},{58.50,58.97},{58.56,59.00},{58.63,58.99},{58.70,58.98},{58.77,58.97},{58.83,58.96},{58.90,58.95},{58.95,58.94},{59.00,58.91},{59.17,58.81},{59.23,58.78},{59.30,58.74},{59.36,58.70},{59.43,58.66},{59.49,58.62},{59.54,58.59},{59.57,58.56},{59.68,58.42},{59.73,58.35},{59.78,58.28},{59.83,58.21},{59.89,58.15},{59.94,58.08},{59.99,58.01},{60.04,57.94},{60.08,57.90},{60.16,57.72},{60.20,57.64},{60.25,57.56},{60.29,57.48},{60.33,57.40},{60.38,57.31},{60.42,57.23},{60.45,57.14},{60.47,57.04},{60.49,56.94},{60.52,56.85},{60.54,56.75},{60.57,56.65},{60.59,56.55},{60.61,56.45},{60.64,56.35},{60.66,56.26},{60.68,56.16},{60.67,56.06},{60.67,55.95},{60.66,55.85},{60.66,55.75},{60.65,55.64},{60.64,55.54},{60.64,55.43},{60.63,55.33},{60.61,55.23},{60.61,55.23},{60.51,55.05},{60.47,54.97},{60.42,54.89},{60.38,54.81},{60.35,54.76},{60.31,54.72},{60.25,54.66},{60.20,54.59},{60.14,54.53},{60.05,54.42},{59.99,54.36},{59.94,54.30},{59.88,54.24},{59.86,54.21},{59.82,54.18},{59.71,54.11},{59.61,54.06},{59.55,54.02},{59.50,53.98},{59.44,53.95},{59.37,53.94},{59.24,53.93},{59.17,53.92},{59.10,53.92},{59.03,53.91},{58.96,53.93},{58.90,53.95},{58.83,53.97},{58.76,53.99},{58.69,54.01},{58.64,54.03},{58.61,54.05}}}},
            [npcKeys.questStarts] = {10460,10461,10462,10463,10464,10465,10466,10467,10468,10469,10470,10471,10472,10473,10474,10475,11103,11104,11105,11106,13432},
        },
        [19936] = { -- Arazmodu
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{58.61,54.05}}},
            [npcKeys.waypoints] = {[zoneIDs.TANARIS] = {{{58.61,54.05},{58.60,54.06},{58.53,54.09},{58.47,54.13},{58.40,54.17},{58.34,54.21},{58.27,54.25},{58.21,54.30},{58.15,54.35},{58.07,54.45},{57.98,54.57},{57.92,54.64},{57.87,54.70},{57.82,54.77},{57.76,54.84},{57.72,54.89},{57.68,55.08},{57.66,55.21},{57.64,55.31},{57.62,55.41},{57.60,55.51},{57.58,55.61},{57.57,55.71},{57.56,55.81},{57.55,55.92},{57.54,56.02},{57.53,56.12},{57.51,56.23},{57.50,56.33},{57.50,56.37},{57.51,56.45},{57.53,56.66},{57.54,56.76},{57.55,56.87},{57.56,56.97},{57.57,57.07},{57.58,57.17},{57.59,57.28},{57.60,57.38},{57.62,57.48},{57.63,57.58},{57.64,57.69},{57.66,57.79},{57.67,57.89},{57.69,57.99},{57.70,58.09},{57.72,58.16},{57.80,58.28},{57.88,58.40},{57.93,58.48},{57.98,58.54},{58.01,58.58},{58.05,58.66},{58.11,58.73},{58.14,58.77},{58.20,58.81},{58.30,58.86},{58.37,58.90},{58.43,58.93},{58.50,58.97},{58.56,59.00},{58.63,58.99},{58.70,58.98},{58.77,58.97},{58.83,58.96},{58.90,58.95},{58.95,58.94},{59.00,58.91},{59.17,58.81},{59.23,58.78},{59.30,58.74},{59.36,58.70},{59.43,58.66},{59.49,58.62},{59.54,58.59},{59.57,58.56},{59.68,58.42},{59.73,58.35},{59.78,58.28},{59.83,58.21},{59.89,58.15},{59.94,58.08},{59.99,58.01},{60.04,57.94},{60.08,57.90},{60.16,57.72},{60.20,57.64},{60.25,57.56},{60.29,57.48},{60.33,57.40},{60.38,57.31},{60.42,57.23},{60.45,57.14},{60.47,57.04},{60.49,56.94},{60.52,56.85},{60.54,56.75},{60.57,56.65},{60.59,56.55},{60.61,56.45},{60.64,56.35},{60.66,56.26},{60.68,56.16},{60.67,56.06},{60.67,55.95},{60.66,55.85},{60.66,55.75},{60.65,55.64},{60.64,55.54},{60.64,55.43},{60.63,55.33},{60.61,55.23},{60.61,55.23},{60.51,55.05},{60.47,54.97},{60.42,54.89},{60.38,54.81},{60.35,54.76},{60.31,54.72},{60.25,54.66},{60.20,54.59},{60.14,54.53},{60.05,54.42},{59.99,54.36},{59.94,54.30},{59.88,54.24},{59.86,54.21},{59.82,54.18},{59.71,54.11},{59.61,54.06},{59.55,54.02},{59.50,53.98},{59.44,53.95},{59.37,53.94},{59.24,53.93},{59.17,53.92},{59.10,53.92},{59.03,53.91},{58.96,53.93},{58.90,53.95},{58.83,53.97},{58.76,53.99},{58.69,54.01},{58.64,54.03},{58.61,54.05}}}},
            [npcKeys.questStarts] = {},
            [npcKeys.questEnds] = {},
        },
        [20102] = { -- Goblin Commoner
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{40.77,84.45}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
            [npcKeys.questStarts] = {11356,11357,11441,11446,11970,11971,12752,12753,12772,12775,12777,12782,12783,12784,12808,12811,13483,13484,14022,14036,29074,29400},
        },
        [20201] = { -- Sa'at
            [npcKeys.spawns] = {[zoneIDs.THE_BLACK_MORASS] = {{49.29,6.47},{-1,-1}}},
            [npcKeys.questStarts] = {10297,10298},
        },
        [20406] = { -- Champion Cyssa Dawnrose
            [npcKeys.questStarts] = {9601,27298,27304,28302,28303},
        },
        [20407] = { -- Farseer Umbrua
            [npcKeys.questStarts] = {8410,27353,28401,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {27270,28287,28401,70395,70397,70398,70401,70870,78136,78140,78157,78164,88776,88780,88783,88786,88790},
        },
        [20448] = { -- Commander Ameer
            [npcKeys.questStarts] = {10339,10970,10971,10972,10973,10974},
        },
        [20612] = { -- Sorim Lightsong
            [npcKeys.questStarts] = {10359,10360,10361,10362,10363},
        },
        [20735] = { -- Archmage Lan'dalock
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },
        [20797] = { -- Deviate Coiler Hatchling
            [npcKeys.waypoints] = {},
        },
        [20869] = { -- Arcatraz Sentinel
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_CONTAINMENT_CORE] = {{30.75,42.28},{29.22,56.11}},[zoneIDs.THE_ARCATRAZ_STASIS_BLOCK_MAXIMUS] = {{26.04,41.77},{30.97,42.43},{66.27,39.53}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
        },
        [20870] = { -- Zereketh the Unbound
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{59.11,24.47},{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [20885] = { -- Dalliah the Doomsayer
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_STASIS_BLOCK_MAXIMUS] = {{37.34,79.46}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [20886] = { -- Wrath-Scryer Soccothrates
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_STASIS_BLOCK_MAXIMUS] = {{19.64,78.54}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [20912] = { -- Harbinger Skyriss
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_CONTAINMENT_CORE] = {{62.17,30.5}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.questStarts] = {},
        },
        [20914] = { -- Aalun
            [npcKeys.questEnds] = {14082},
        },
        [20977] = { -- Millhouse Manastorm
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_CONTAINMENT_CORE] = {{57.13,37.16}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
        },
        [21183] = { -- Oronok Torn-heart
            [npcKeys.questEnds] = {10513,10514,10515,10519,10523,10541,10579},
        },
        [21209] = { -- Dumphry
            [npcKeys.questStarts] = {10055,10078,10763,10764},
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{51.29,60.31}}},
            [npcKeys.waypoints] = {},
        },
        [21212] = { -- Lady Vashj
            [npcKeys.spawns] = {[zoneIDs.SERPENTSHRINE_CAVERN] = {{72.08,58.97},{-1,-1}}},
        },
        [21336] = { -- Gedrah
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [21338] = { -- Coilfang Leper
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{30.31,79.67},{31.48,78.9},{31.01,78.19},{31.05,76.64},{32.11,77.47},{33.1,77.77},{32.66,79.15},{31.69,80.37},{35.29,76.39},{36.33,76.41},{35.84,77.2},{36.25,77.93},{35.77,78.87},{35.35,77.93},{34.77,77.14},{34.71,78.29},{-1,-1}}},
        },
        [21517] = { -- Ilthuril
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [21694] = { -- Bog Overlord
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{29.62,17.23},{35.4,15.22},{40.88,17.61},{35.01,37.76},{30.59,34.45},{-1,-1}}},
        },
        [21700] = { -- Akama
            [npcKeys.questStarts] = {10705,10707,10708,10946,10947,10948,11052},
        },
        [21962] = { -- Udalo
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_CONTAINMENT_CORE] = {{31.67,25.08}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
        },
        [22112] = { -- Karynaku
            [npcKeys.questStarts] = {10866,10870,10872},
        },
        [22421] = { -- Skar'this the Heretic
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{57.57,83.85},{-1,-1}}},
            [npcKeys.questStarts] = {10900,10901,13431},
        },
        [22433] = { -- Ja'y Nosliw
            [npcKeys.questStarts] = {11063},
        },
        [22469] = { -- Liza Cutlerflix
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [22818] = { -- Draenei Orphan
            [npcKeys.questStarts] = {10950,10952,10954,10956,10962,10966},
        },
        [22819] = { -- Orphan Matron Mercy
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY] = {{75.07,47.88}}},
            [npcKeys.questStarts] = {10942,10943},
        },
        [22820] = { -- Seer Olum
            [npcKeys.spawns] = {[zoneIDs.SERPENTSHRINE_CAVERN] = {{48.02,18.42},{-1,-1}}},
        },
        [22890] = { -- First Fragment Guardian
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{82.62,30.44},{-1,-1}}},
        },
        [22891] = { -- Second Fragment Guardian
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{52.97,23.71},{-1,-1}}},
        },
        [22892] = { -- Third Fragment Guardian
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_STASIS_BLOCK_MAXIMUS] = {{59.05,24.12}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
        },
        [23010] = { -- Wolgren Jinglepocket
            [npcKeys.questStarts] = {7023},
        },
        [23042] = { -- Severin
            [npcKeys.waypoints] = {},
        },
        [23127] = { -- Farseer Javad
            [npcKeys.questStarts] = {8410,27270,28287},
        },
        [23128] = { -- Master Pyreanor
            [npcKeys.questStarts] = {27434,28473,70734,70735,70736,70737,70865,70869,78167,78168,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {27298,28303,28473,70396,70734,70735,70736,70869,78137,78167,88778,88782,88785,88789},
        },
        [23306] = { -- Hazzik
            [npcKeys.questStarts] = {11029,11056,11074,11885},
        },
        [23392] = { -- Skyguard Stable Master
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [23558] = { -- Neill Ramstein
            [npcKeys.questStarts] = {11122,11318,29394},
        },
        [23616] = { -- Kyle the Frenzied
            [npcKeys.spawns] = {[zoneIDs.MULGORE] = {{48.48,61.57}}},
        },
        [23627] = { -- Becan Barleybrew
            [npcKeys.questStarts] = {11293},
        },
        [23628] = { -- Daran Thunderbrew
            [npcKeys.questStarts] = {11294},
        },
        [23679] = { -- Garn Mathers
            [npcKeys.waypoints] = {[zoneIDs.DUSTWALLOW_MARSH] = {{{63.9,29.05},{63.73,28.66},{63.88,28.28},{64,27.85},{64.19,27.53},{64.35,27.1},{64.45,26.77},{64.64,26.83},{64.88,27.15},{64.93,27.65},{64.74,27.96},{64.44,28.78},{64.17,28.99},{63.9,29.05}}}},
        },
        [23843] = { -- Mordant Grimsby
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{55.58,26.14}}},
        },
        [23951] = { -- Lieutenant Aden
            [npcKeys.questStarts] = {1220,27214,27247,27248},
        },
        [23973] = { -- Masked Orphan Matron
            [npcKeys.spawns] = {
                [zoneIDs.TIRISFAL_GLADES] = {{60.92,53.58}},
                [zoneIDs.DUROTAR] = {{52.57,41.2}},
                [zoneIDs.EVERSONG_WOODS] = {{47.25,46.48}},
            },
        },
        [24032] = { -- Celea Frozenmane
            [npcKeys.questStarts] = {11266,11267},
        },
        [24067] = { -- Mahana Frosthoof
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [24111] = { -- Defender Mordun
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_KEEP] = {{67.56,70.9},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.UTGARDE_KEEP,
            [npcKeys.questStarts] = {11252,13205,29763,29764,29803},
        },
        [24125] = { -- Cormath the Courier
            [npcKeys.questStarts] = {11411},
        },
        [24135] = { -- Greatmother Ankha
            [npcKeys.questStarts] = {11260,11265,11268,11287},
        },
        [24364] = { -- Flynn Firebrew
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{53.01,51.1}}},
        },
        [24369] = { -- Wind Trader Zhareem
            [npcKeys.questStarts] = {11369,11370,11373,11374,11375,11378,11384,11386,11388,11499},
        },
        [24468] = { -- Pol Amberstill
            [npcKeys.questStarts] = {11321,12193,13932,29397},
        },
        [24470] = { -- [PH] Maldonado's Test Creature
            [npcKeys.questEnds] = {},
        },
        [24495] = { -- Blix Fixwidget
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{40.32,17.89}}},
        },
        [24497] = { -- Ram Master Ray
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{42.62,17.84}}},
            [npcKeys.questStarts] = {11409,11412,29393},
        },
        [24498] = { -- Cort Gorestein
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{40.56,18.19}}},
            [npcKeys.questStarts] = {11407},
        },
        [24499] = { -- Ja'ron
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{40.2,17.08}}},
            [npcKeys.questStarts] = {11408},
        },
        [24510] = { -- Driz Tumblequick
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{42.69,17.71}}},
            [npcKeys.questStarts] = {11413,12194,13931,29396},
        },
        [24519] = { -- Costumed Orphan Matron
            [npcKeys.spawns] = {
                [zoneIDs.ELWYNN_FOREST] = {{42.62,64.39}},
                [zoneIDs.DUN_MOROGH] = {{53.29,51.47}},
                [zoneIDs.AZUREMYST_ISLE] = {{49.16,51.33}},
            },
            [npcKeys.questEnds] = {11131,11242,11356,11360,11435,11439,11440,12133,12135},
        },
        [24527] = { -- Bok Dropcertain
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{50.61,13.48}}},
        },
        [24560] = { -- Priestess Delrissa
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE_GRAND_MAGISTERS_ASYLUM] = {{38.86,56.24}},[zoneIDs.MAGISTERS_TERRACE] = {{-1,-1}}},
        },
        [24657] = { -- Glodrak Huntsniper
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{41.23,18.53}}},
        },
        [24664] = { -- Kael'thas Sunstrider
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE_GRAND_MAGISTERS_ASYLUM] = {{7.3,50.04}},[zoneIDs.MAGISTERS_TERRACE] = {{-1,-1}}},
        },
        [24697] = { -- Sister of Torment
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE_GRAND_MAGISTERS_ASYLUM] = {{15.1,50.22},{72.66,58.52},{64.13,52.66},{64.15,60.9},{47.81,60.16},{39.42,45.77}},[zoneIDs.MAGISTERS_TERRACE] = {{-1,-1}}},
        },
        [24710] = { -- Ipfelkofer Ironkeg
            [npcKeys.questEnds] = {11437,11438,11441,11442,11486,12491},
        },
        [24711] = { -- Tapper Swindlekeg
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{41.58,18.45}}},
            [npcKeys.questEnds] = {11444,11445,11446,11447,11487,12492},
        },
        [24723] = { -- Selin Fireheart
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE] = {{42.53,23.6},{-1,-1}}},
        },
        [24727] = { -- Caylee Dak
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY] = {{31.29,27.89}}},
        },
        [24744] = { -- Vexallus
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE] = {{82.65,26.47},{-1,-1}}},
        },
        [24813] = { -- Exarch Larethor
            [npcKeys.questStarts] = {11488},
        },
        [24822] = { -- Tyrith
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE] = {{60.91,24.01},{-1,-1}}},
        },
        [24848] = { -- Kalecgos
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE] = {{94.05,36.13},{-1,-1}}},
            [npcKeys.questStarts] = {11492,29685},
        },
        [24905] = { -- Leassian
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [24974] = { -- Liza Cutlerflix
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [25034] = { -- Tradesman Portanuus
            [npcKeys.questStarts] = {11517,11534},
        },
        [25061] = { -- Harbinger Inuuro
            [npcKeys.questStarts] = {11537,11538},
        },
        [25167] = { -- General Tiras'alan
            [npcKeys.questStarts] = {11550},
        },
        [25273] = { -- Warsong Recruitment Officer
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{41.62,53.99},{43.01,55.64}}},
        },
        [25314] = { -- Archmage Berinand
            [npcKeys.questStarts] = {11900,11910},
        },
        [25324] = { -- Earthen Ring Guide
            [npcKeys.spawns] = {
                [zoneIDs.ASHENVALE] = {
                    {15.5,19.0,phases.EARTHEN_GUIDE_BFD},
                    {9.36,12.99,phases.EARTHEN_GUIDE_SHORE},
                },
            },
            [npcKeys.questStarts] = {11891,12012,29092},
        },
        [25450] = { -- Veehja
            [npcKeys.questStarts] = {11625,11626,12490},
        },
        [25462] = { -- The Lich King
            [npcKeys.questStarts] = {12593,12641,12657},
        },
        [25636] = { -- Captured Tuskarr Prisoner
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{44.10,77.90}}},
        },
        [25697] = { -- Luma Skymother
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{18.48,49.53},{-1,-1}}},
            [npcKeys.questStarts] = {11976},
        },
        [25740] = { -- Ahune
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{32.56,50.45},{-1,-1}}},
        },
        [25809] = { -- Arch Druid Lathorius
            [npcKeys.questStarts] = {11864,11866,11867,11876,11878,11892},
        },
        [25883] = { -- Ashenvale Flame Warden
            [npcKeys.questStarts] = {11805},
        },
        [25887] = { -- Arathi Flame Warden
            [npcKeys.questStarts] = {11804},
        },
        [25888] = { -- Azuremyst Isle Flame Warden
            [npcKeys.questStarts] = {11806},
        },
        [25889] = { -- Blade's Edge Flame Warden
            [npcKeys.questStarts] = {11807},
        },
        [25890] = { -- Blasted Lands Flame Warden
            [npcKeys.questStarts] = {11808},
        },
        [25891] = { -- Bloodmyst Isle Flame Warden
            [npcKeys.questStarts] = {11809},
        },
        [25892] = { -- Burning Steppes Flame Warden
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{68.34,60.64}}},
            [npcKeys.questStarts] = {11810},
        },
        [25893] = { -- Darkshore Flame Warden
            [npcKeys.questStarts] = {11811},
        },
        [25894] = { -- Desolace Flame Warden
            [npcKeys.questStarts] = {11812},
        },
        [25895] = { -- Dun Morogh Flame Warden
            [npcKeys.questStarts] = {11813},
        },
        [25896] = { -- Duskwood Flame Warden
            [npcKeys.questStarts] = {11814},
        },
        [25897] = { -- Dustwallow Marsh Flame Warden
            [npcKeys.questStarts] = {11815},
        },
        [25898] = { -- Elwynn Forest Flame Warden
            [npcKeys.questStarts] = {11816},
        },
        [25899] = { -- Feralas Flame Warden
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{46.82,43.7}}},
            [npcKeys.questStarts] = {11817},
        },
        [25936] = { -- Mulgore Flame Keeper
            [npcKeys.spawns] = {[zoneIDs.MULGORE] = {{51.81,59.26}}},
        },
        [25900] = { -- Hellfire Peninsula Flame Warden
            [npcKeys.questStarts] = {11818},
        },
        [25901] = { -- Hillsbrad Flame Warden
            [npcKeys.questStarts] = {11819},
        },
        [25902] = { -- Loch Modan Flame Warden
            [npcKeys.questStarts] = {11820},
        },
        [25903] = { -- Nagrand Flame Warden
            [npcKeys.questStarts] = {11821},
        },
        [25904] = { -- Redridge Flame Warden
            [npcKeys.questStarts] = {11822},
        },
        [25905] = { -- Shadowmoon Valley Flame Warden
            [npcKeys.questStarts] = {11823},
        },
        [25906] = { -- Teldrassil Flame Warden
            [npcKeys.questStarts] = {11824},
        },
        [25907] = { -- Terokkar Forest Flame Warden
            [npcKeys.questStarts] = {11825},
        },
        [25908] = { -- The Hinterlands Flame Warden
            [npcKeys.questStarts] = {11826},
        },
        [25909] = { -- Western Plaguelands Flame Warden
            [npcKeys.questStarts] = {11827},
        },
        [25910] = { -- Westfall Flame Warden
            [npcKeys.questStarts] = {11583},
        },
        [25911] = { -- Wetlands Flame Warden
            [npcKeys.questStarts] = {11828},
        },
        [25912] = { -- Zangarmarsh Flame Warden
            [npcKeys.questStarts] = {11829},
        },
        [25913] = { -- Netherstorm Flame Warden
            [npcKeys.questStarts] = {11830},
        },
        [25914] = { -- Silithus Flame Warden
            [npcKeys.questStarts] = {11831},
        },
        [25915] = { -- Stranglethorn Vale Flame Warden
            [npcKeys.questStarts] = {11832},
        },
        [25916] = { -- Tanaris Flame Warden
            [npcKeys.questStarts] = {11833},
        },
        [25917] = { -- Winterspring Flame Warden
            [npcKeys.questStarts] = {11834},
        },
        [25975] = { -- Master Fire Eater
            [npcKeys.spawns] = {
                [zoneIDs.DARNASSUS] = {{63.19,47.48}},
                [zoneIDs.IRONFORGE] = {{65.36,25.06}},
                [zoneIDs.STORMWIND_CITY] = {{50.13,72.56}},
                [zoneIDs.THE_EXODAR] = {{40.90,25.59}},
            },
            [npcKeys.questStarts] = {11657,11731,11921,11924},
        },
        [26110] = { -- Librarian Serrah
            [npcKeys.questStarts] = {11912,11914,13094,13412},
        },
        [26113] = { -- Frostwave Lieutenant
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.43,66.85}},[1637] = {{46.59,37.25}},[1638] = {{21,26.44}},[3487] = {{69.48,42.44}}},
            [npcKeys.questStarts] = {11922,11923,11925,11926},
        },
        [26116] = { -- Frostwave Lieutenant
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{9.64,12.18},{9.26,11.46},{9.67,11.14}}},
        },
        [26117] = { -- Raelorasz
            [npcKeys.questStarts] = {11918,11919,11931,11936,11940,11943,11969},
        },
        [26123] = { -- Midsummer Supplier
            [npcKeys.spawns] = {
                [zoneIDs.IRONFORGE] = {{64.82,26.28}},
                [zoneIDs.DARNASSUS] = {{61.9,48.3}},
                [zoneIDs.THE_EXODAR] = {{42.51,25.97}},
                [zoneIDs.STORMWIND_CITY] = {{49.02,71.95}},
            },
        },
        [26178] = { -- Hailstone Lieutenant
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{40.23,31.37},{40.33,30.23},{39.24,30.39}}},
        },
        [26204] = { -- Chillwind Lieutenant
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{21.44,43.34},{21.33,41.01},{21.51,41.88}}},
        },
        [26214] = { -- Frigid Lieutenant
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{14.73,34.39},{16.1,36.92},{13.54,37.12}}},
        },
        [26215] = { -- Glacial Lieutenant
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{68.12,20.82},{68.91,20.48},{68.53,19.17}}},
        },
        [26216] = { -- Glacial Templar
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{85.59,47.14},{84.19,47.1},{85.62,53.26},{84.13,53.4}}},
        },
        [26221] = { -- Earthen Ring Elder
            [npcKeys.questStarts] = {11886,11917,11947,11948,11952,11953,11954,11955},
            [npcKeys.questEnds] = {9319,11917,11947,11948,11952,11953,11954,12012,29092},
        },
        [26401] = { -- Summer Scorchling
            [npcKeys.spawns] = {[1] = {{53.8,45.14}},[3] = {{18.97,56.32}},[4] = {{55.55,14.76}},[8] = {{70.13,15.73}},[10] = {{73.77,54.5}},[11] = {{13.5,46.97}},[12] = {{43.48,62.5}},[15] = {{61.87,40.5}},[28] = {{43.43,82.24}},[38] = {{32.59,41.1}},[40] = {{44.8,62.18}},[44] = {{25.64,53.48}},[45] = {{44.22,46}},[46] = {{68.32,60.78}},[47] = {{14.93,50.5}},[65] = {{75.24,43.78}},[66] = {{40.38,61.39}},[67] = {{41.42,86.74}},[141] = {{54.83,52.77}},[148] = {{48.69,22.7}},[331] = {{86.89,41.85}},[357] = {{46.78,43.67}},[394] = {{33.94,60.51}},[405] = {{66.19,17.1}},[406] = {{49.35,51.34}},[440] = {{52.67,30.22}},[490] = {{59.78,63.26}},[495] = {{57.84,16.17}},[618] = {{61.36,47.31}},[1377] = {{60.38,33.5}},[2817] = {{78.07,74.91}},[3483] = {{62.45,57.99}},[3518] = {{49.57,69.4}},[3519] = {{54.01,55.57}},[3520] = {{39.63,54.56}},[3521] = {{68.73,51.95}},[3522] = {{41.52,65.87}},[3523] = {{31.16,62.65}},[3524] = {{44.41,52.47}},[3525] = {{55.82,67.75}},[3537] = {{55.15,19.91}},[3711] = {{48.37,65.53}},[4709] = {{48.34,72.29}},[4922] = {{47.32,28.94}},[5034] = {{53.6,31.92}},[5287] = {{52.03,67.71}},[33] = {{51.44,40.96}}},
        },
        [26471] = { -- Image of Archmage Aethas Sunreaver
            [npcKeys.questEnds] = {11996,11999,12005,12059,12061,12066,12084,12110,12173},
            [npcKeys.questEnds] = {11996,11999,12005,12059,12061,12066,12084,12110,12173,78168,78225},
        },
        [26520] = { -- Festival Scorchling
            [npcKeys.spawns] = {[3] = {{23.19,37.42}},[4] = {{46.3,13.74}},[8] = {{76.29,13.59}},[14] = {{52.15,47.25}},[15] = {{33.49,30.92}},[16] = {{60.8,53.55}},[17] = {{49.96,54.54}},[28] = {{29.23,57.34}},[33] = {{40.51,50.96}},[45] = {{69.41,42.46}},[46] = {{51.2,29.24}},[47] = {{76.66,75.07}},[65] = {{38.31,48.45}},[66] = {{43.42,71.81}},[67] = {{40.27,85.41}},[85] = {{57.29,51.75}},[130] = {{49.59,38.31}},[215] = {{51.77,59.21}},[267] = {{54.71,50.15}},[331] = {{51.35,66.23}},[357] = {{72.41,47.75}},[394] = {{19.26,61.17}},[405] = {{26.13,77.01}},[406] = {{52.95,62.4}},[440] = {{49.8,27.93}},[490] = {{56.24,66.33}},[495] = {{48.64,13.08}},[618] = {{58.16,47.43}},[1377] = {{50.82,41.4}},[2817] = {{80.08,53.21}},[3430] = {{46.41,50.51}},[3433] = {{46.89,26.48}},[3483] = {{57.16,42}},[3518] = {{50.97,34.13}},[3519] = {{51.97,42.96}},[3520] = {{33.65,30.78}},[3521] = {{35.47,51.69}},[3522] = {{49.92,58.75}},[3523] = {{32.16,68.33}},[3537] = {{51.16,11.47}},[3711] = {{47.4,61.75}},[4709] = {{40.85,67.73}},[4922] = {{52.96,45.93}},[5034] = {{53.1,34.54}},[5287] = {{50.34,70.33}}},
        },
        [26653] = { -- Kilix the Unraveler
            [npcKeys.questStarts] = {12040,12041,13167,13182,13187,13190},
        },
        [26673] = { -- Image of Archmage Modera
            [npcKeys.questEnds] = {11995,12000,12004,12055,12060,12065,12083,12107,12172,12440},
            [npcKeys.questEnds] = {11995,12000,12004,12055,12060,12065,12083,12107,12172,12440,78166,78223},
        },
        [26860] = { -- Conqueror Krenna
            [npcKeys.questEnds] = {12178,12412,12413,12423,12487},
        },
        [26875] = { -- Lieutenant Dumont
            [npcKeys.questEnds] = {12105,12156,12292,12294,12308,12310,12511,13524},
        },
        [27215] = { -- Boxey Boltspinner
            [npcKeys.questStarts] = {12022},
        },
        [27216] = { -- Bizzle Quicklift
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{41.53,17.6}}},
            [npcKeys.questStarts] = {12191},
        },
        [27584] = { -- Darna Honeybock
            [npcKeys.questStarts] = {12318},
        },
        [27987] = { -- Monte Muzzleshot
            [npcKeys.questEnds] = {12521},
        },
        [28039] = { -- Commander Kunz
            [npcKeys.questStarts] = {12501,12505,12596,12604,12792},
        },
        [28048] = { -- Dread Captain DeMeza
            [npcKeys.questEnds] = {},
        },
        [28057] = { -- Garmin Herzog
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [28070] = { -- Brann Bronzebeard
            [npcKeys.questStarts] = {13207,13417},
        },
        [28092] = { -- The Etymidian
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{47.38,9.21}}},
        },
        [28132] = { -- Don Carlos
            [npcKeys.spawns] = {[zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {{36.2,57.83},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {{{36.2,57.83},{36.84,57.55},{37.65,57.29},{38.71,56.75},{40,56.05},{41.24,55.37},{42.08,54.87},{42.96,54.61},{43.74,54.47},{44.45,54.67},{44.57,54.8},{45.45,55.65},{46.36,56.52},{46.88,57.2},{48.49,59.15},{48.98,59.73},{50.21,60.74}}}},
        },
        [28329] = { -- Slurpo Fizzykeg
            [npcKeys.questStarts] = {12318},
        },
        [28377] = { -- Prince Valanar
            [npcKeys.questStarts] = {12678,12697,12701,12706},
        },
        [28401] = { -- Har'koa
            [npcKeys.questStarts] = {12632,12642,12665,12666,12667,12684,12685,12712,12721,12730,13097,29833},
        },
        [28518] = { -- Stefan Vadu
            [npcKeys.questEnds] = {12629,12630,12631,12633,12637,12638,12643,12648,12649,12661,12669,12676,12677,12713,12780,12884},
        },
        [28527] = { -- Chronicler To'kini
            [npcKeys.questStarts] = {12635,12650,12709,13099,13549,29836},
        },
        [28658] = { -- Gothik the Harvester
            [npcKeys.questStarts] = {12698,12700},
        },
        [29110] = { -- The Lich King
            [npcKeys.questStarts] = {12779,12800},
        },
        [29156] = { -- Archmage Celindra
            [npcKeys.questEnds] = {12790,12791,12794,12796},
        },
        [29194] = { -- Amal'thazad
            [npcKeys.questStarts] = {82983,82985},
        },
        [29195] = { -- Lady Alistra
            [npcKeys.questStarts] = {82983,82985},
        },
        [29196] = { -- Lord Thorval
            [npcKeys.questStarts] = {82983,82985,88781,88784,88787,88788,88797,88798},
            [npcKeys.questEnds] = {88777,88781,88784,88787,88788},
        },
        [29250] = { -- Tim Street
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [29308] = { -- Prince Taldaram
            [npcKeys.questStarts] = {},
        },
        [29611] = { -- King Varian Wrynn
            [npcKeys.questStarts] = {7496,7782,26365,26370,26960,26975,26977,27241,28238},
            [npcKeys.questEnds] = {396,4184,6186,6187,7495,7781,11222,12774,13188,13347,13370,13377,24597,25425,26322,26960,27106,27240,28716},
        },
        [30007] = { -- Gurgthock
            [npcKeys.questStarts] = {12932,12933,12934,12935,12936,12948,12954},
        },
        [30105] = { -- King Jokkum
            [npcKeys.questStarts] = {12966,12975,12976,13011,13108,13109,29863},
        },
        [30284] = { -- Bonegrinder
            [npcKeys.questStarts] = {},
        },
        [30285] = { -- Eye of Taldaram
            [npcKeys.questStarts] = {},
        },
        [30481] = { -- Darkmoon Fortune Teller
            [npcKeys.questStarts] = {},
        },
        [30490] = { -- Rin Duoctane
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBELLY] = {{31.27,49.62}}},
            [npcKeys.zoneID] = zoneIDs.THE_UNDERBELLY,
        },
        [30671] = { -- Tol'mar
            [npcKeys.questStarts] = {13096},
        },
        [30676] = { -- Chronicler Bah'Kini
            [npcKeys.questStarts] = {13098,13111},
            [npcKeys.questEnds] = {13098,13099,13111},
        },
        [31080] = { -- Warden Alturas
            [npcKeys.questStarts] = {13159},
        },
        [31108] = { -- Siege Master Stouthandle
            [npcKeys.questStarts] = {236,13197},
        },
        [32725] = { -- Warmage Silva
            [npcKeys.questEnds] = {},
        },
        [32863] = { -- Shatterspear Overseer
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{63.39,14.62},{60.02,17.02},{62.15,16.81},{60.8,13.96},{60.68,22.81},{63.87,18.99},{61.15,19.47},{62.59,19.9},{60.51,18.83},{60.01,16.44},{62.34,14.47},{60.71,14.33}}},
        },
        [32937] = { -- Tranquil Tidal Spirit
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{44.19,26.64},{43.5,27.26},{42.25,27.54},{43.09,28.12},{44.69,28.13},{43.66,28.55},{42.37,28.57},{44.33,28.99},{40.89,29.28},{44.82,29.52},{41.75,29.57},{42.4,29.59},{43.12,29.63},{43.49,29.94},{44.51,30.03},{42.71,30.46},{43.74,30.47},{44.01,31.01},{43.35,31.05}}},
        },
        [32959] = { -- Cerellean Whiteclaw
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {
                    {50.82,17.88,phases.CERELLEAN_NEAR_EDGE},
                    {50.13,19.46,phases.CERELLEAN_NEAR_TREE},
                },
            },
        },
        [32964] = { -- Sentinel Aynasha
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{64.48,5.49}}},
        },
        [32971] = { -- Ranger Glynda Nal'Shea
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {
                    {50.22,19.79,phases.CERELLEAN_NEAR_EDGE},
                    {50.69,19.73,phases.CERELLEAN_NEAR_TREE},
                },
            },
        },
        [32972] = { -- Serendia Oakwhisper
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {
                    {51.8,18.07,phases.SERENDIA_FP},
                    {50.92,18.08,phases.SERENDIA_INN},
                },
            },
        },
        [32973] = { -- Dentaria Silverglade
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {
                    {51.72,17.92,phases.CERELLEAN_NEAR_EDGE},
                    {50.65,19.72,phases.CERELLEAN_NEAR_TREE},
                },
            },
        },
        [32979] = { -- Gorbold Steelhand
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{51.01,19.19}}},
        },
        [33000] = { -- Spirit of Corruption
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{45.46,86.94},{44.52,86.88},{44.27,86.8},{45.75,86.43},{45.21,86.26},{44.75,86.25},{44.27,86},{43.61,84.91},{45.34,84.75},{44.97,84.64},{45.92,83.96},{45.29,83.64},{44.41,83.36},{46.32,83.35},{45.41,83.01},{44.36,82.9},{45.72,82.62},{45.1,82.56},{44.13,82.34},{45.71,82.13},{44.26,81.79},{43.58,81.66},{45.83,81.37},{44.8,81.33},{43.92,81.3},{43.89,80.82},{44.87,87.34},{46.56,87.07},{45.31,86.88},{44.8,86.75},{44.14,86.08},{46.51,85.71},{43.61,85.53},{44.28,85.49},{44.52,85},{45.65,84.98},{44.29,84.73},{45.34,84.2},{44.43,84.07},{45.06,84.01},{43.82,83.81},{45.88,83},{45.1,82.98},{43.97,82.92},{44.84,82.91},{46.14,82.76},{45.48,82.66},{44.55,82.5},{44.81,82.17}}},
            [npcKeys.zoneID] = zoneIDs.DARKSHORE,
        },
        [33053] = { -- Grimclaw
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {
                    {42.91,39.04,phases.GRIMCLAW_THICKET},
                    {50.14,19.42,phases.GRIMCLAW_INN},
                },
            },
        },
        [33112] = { -- Selenn
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{44.44,56.76}}},
        },
        [33117] = { -- Elder Brownpaw
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{40.94,56.48}}},
        },
        [33119] = { -- Aroom
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{45.59,48.47}}},
        },
        [33131] = { -- Great Moonstalker Spirit
            [npcKeys.questStarts] = {13568},
        },
        [33132] = { -- Great Thistle Bear Spirit
            [npcKeys.questStarts] = {13597},
        },
        [33133] = { -- Great Stag Spirit
            [npcKeys.questStarts] = {13567},
        },
        [33232] = { -- Archaeologist Hollee
            [npcKeys.spawns] = {
                [zoneIDs.DARKSHORE] = {
                    {38.58,42.45,phases.HOLLEE_RUINS},
                    {42.57,45.25,phases.HOLLEE_CAMP},
                },
            },
        },
        [33256] = { -- Ashelan Northwood
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{47.9,13.43},{-1,-1}}},
        },
        [33258] = { -- Relwyn Shadestar
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{47.9,13.06},{-1,-1}}},
        },
        [33260] = { -- Sentinel Aluwyn
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{48.47,12},{-1,-1}}},
            [npcKeys.questEnds] = {1199,26458,26883,26897,26898,28011},
        },
        [33261] = { -- Sentinel-trainee Issara
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{48.48,11.58},{-1,-1}}},
        },
        [33302] = { -- Captain Elendilad
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{65.78,82.18}}},
        },
        [33435] = { -- Bozzle Blastbolt
            [npcKeys.questEnds] = {},
        },
        [33532] = { -- Wolvar Orphan
            [npcKeys.questStarts] = {13930,13934,13938,13951,13955,13957,13960,28880},
        },
        [33533] = { -- Oracle Orphan
            [npcKeys.questStarts] = {13929,13933,13937,13950,13954,13956,13959,28879},
        },
        [33444] = { -- Harbinger Aphotic
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{20.34,42.47}}},
        },
        [33889] = { -- Krokk
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{82.54,53.8}}},
        },
        [34009] = { -- Withered Ent
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{48.23,44.64},{48.01,43.58},{48.55,43.19},{48.19,43},{47.34,42.59},{47.94,42.46},{46.88,42.33},{47.3,42.24},{48.71,42.11},{48.24,41.84},{47.45,41.65},{46.98,41.56},{47.89,41.45},{48.85,40.95},{47.71,40.82},{47.21,40.45},{47.99,40.22},{48.43,40.11},{49.01,39.94},{46.87,39.79},{47.82,39.65},{47.3,39.51},{47.87,38.86},{49.05,38.86},{48.38,38.73},{49.24,38.19}}},
        },
        [34295] = { -- Lord Magmathar
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{48.14,39.22}}},
        },
        [34365] = { -- Orphan Matron Aria
            [npcKeys.questStarts] = {13926,13927,13959},
        },
        [34398] = { -- Nightmare Guardian
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{49.33,55.7}}},
            [npcKeys.waypoints] = {[zoneIDs.DARKSHORE] = {{{50.02,55.25},{49.91,55.19},{49.79,55.18},{49.69,55.25},{49.60,55.36},{49.51,55.47},{49.42,55.58},{49.33,55.70},{49.23,55.84},{49.13,55.92},{49.02,55.99},{48.92,56.04}}}},
        },
        [34422] = { -- Malfurion Stormrage
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{32.79,84.29}}},
        },
        [34430] = { -- Lead Caravan Kodo
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{67.54,38.95}}},
        },
        [34435] = { -- Cheerful Human Spirit
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{47.8,26.69}}},
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
        },
        [34476] = { -- Cheerful Forsaken Spirit
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.3,68.35}}},
        },
        [34477] = { -- Cheerful Orc Spirit
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{47.47,17.63}}},
        },
        [34478] = { -- Cheerful Dwarf Spirit
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{61.66,37.34}}},
        },
        [34479] = { -- Cheerful Night Elf Spirit
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS] = {{68.47,39.86}}},
        },
        [34480] = { -- Cheerful Tauren Spirit
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF] = {{57.07,17.38}}},
        },
        [34481] = { -- Cheerful Gnome Spirit
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{61.63,37.5}}},
        },
        [34482] = { -- Cheerful Troll Spirit
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{47.46,17.85}}},
        },
        [34483] = { -- Cheerful Blood Elf Spirit
            [npcKeys.spawns] = {[zoneIDs.EVERSONG_WOODS] = {{47.99,49.47}}},
        },
        [34484] = { -- Cheerful Draenei Spirit
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{47.6,55.74}}},
        },
        [34571] = { -- Gwen Armstead
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {37.41,63.35,phases.GILNEAS_CHAPTER_5},
                    {37.41,63.35,phases.GILNEAS_CHAPTER_6},
                },
            },
        },
        [34577] = { -- Head Caravan Kodo
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{54.59,41.77}}},
        },
        [34604] = { -- Big Baobob
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{22.22,52.88}}},
        },
        [34609] = { -- Demonic Invader
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{22.38,53.06},{22.4,52.89},{22.31,52.63},{22.18,52.61},{22.03,52.75},{22.07,53.04},{22.25,53.1},{22.36,52.96}}},
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
        },
        [34668] = { -- Sassy Hardwrench
            [npcKeys.spawns] = {
                [zoneIDs.KEZAN] = {
                    {56.44,76.95,phases.KEZAN_SASSY_IN_HQ},
                    {59.67,77.06,phases.KEZAN_SASSY_OUTSIDE_HQ},
                },
            },
        },
        [34673] = { -- Bamm Megabomb
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{60.47,77.58}}},
        },
        [34689] = { -- Fizz Lighter
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{59.43,73.71}}},
        },
        [34692] = { -- Sister Goldskimmer
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{57.78,77.13}}},
        },
        [34693] = { -- Slinky Sharpshiv
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{58.86,75.44}}},
            [npcKeys.waypoints] = {[zoneIDs.KEZAN] = {{{59.46,77.71},{59.42,77.61},{59.31,77.38},{59.21,77.16},{59.11,76.92},{59.05,76.66},{58.99,76.39},{58.95,76.12},{58.91,75.85},{58.88,75.58},{58.85,75.30},{58.84,75.03},{58.83,74.75},{58.81,74.47},{58.76,74.21},{58.67,73.96},{58.58,73.72},{58.48,73.49},{58.38,73.25},{58.28,73.02},{58.26,72.98}}}},
        },
        [34695] = { -- Maxx Avalanche
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{59.74,76.03}}},
        },
        [34696] = { -- Evol Fingers
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{57.89,74.26}}},
        },
        [34697] = { -- Warrior-Matic NX-01
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{60.33,77.83}}},
        },
        [34707] = { -- Theramore Deck Hand
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{70.92,83.3},{70.53,81.64},{71.82,81.75},{70.96,81.49},{70.7,82.24},{71.35,82.71},{70.14,82.31},{71.4,82.63},{71.3,84.67},{71.34,84.56},{70.42,88.55},{71.14,87.51},{71.7,86.96},{70.53,83.36},{70.57,82.11},{71.81,81.64},{70.73,82.17},{71.74,84.32},{70.95,86.41},{70.33,82.88}}},
        },
        [34748] = { -- Goblin Survivor
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{24.63,85.12},{24.06,83.2},{22.07,79.62},{24.94,82.21},{21.57,76.16},{22.99,79},{23.76,81.33},{26.07,85.45},{25.74,76.1},{25.47,83.54},{24.12,76.61},{23.61,75.57},{21.62,78.42},{20.99,77.28},{22.23,74.69},{25.7,81.28},{27.14,80.52},{24.56,80.6},{23.39,79.86},{24.82,75.05},{26.22,75.13},{25.65,74.69},{26.61,77.4},{25.76,78.69},{27.48,81.81},{23.39,77.48},{23.04,76.44},{24.41,78.74},{22.18,77},{25.31,79.58},{26.18,79.56},{25.15,77.41},{26.52,81.34},{26.61,84.11},{28.5,83.5},{27.35,83.42},{26.22,82.92}}},
        },
        [34753] = { -- Lieutenant Buckland
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS] = {{{71.55,86.54},{71.50,86.50},{71.43,86.44},{71.35,86.38},{71.27,86.34},{71.21,86.32},{71.13,86.26},{71.06,86.18},{70.99,86.09},{70.95,85.98},{70.91,85.86},{70.89,85.74},{70.88,85.71},{70.87,85.64},{70.85,85.51},{70.83,85.38},{70.80,85.26},{70.79,85.13},{70.80,85.04},{70.80,84.98},{70.81,84.96},{70.83,84.84},{70.89,84.74},{70.90,84.72}}}},
        },
        [34829] = { -- King Reaperclaw
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS] = {{{64.17,55.87},{64.24,56.02},{64.32,56.18},{64.40,56.33},{64.48,56.49},{64.56,56.64},{64.64,56.80},{64.72,56.96},{64.72,56.96},{64.79,57.11},{64.87,57.26},{64.97,57.38},{65.06,57.45},{65.12,57.51},{65.24,57.61},{65.27,57.79},{65.29,57.99},{65.30,58.18},{65.30,58.23},{65.30,58.27},{65.32,58.47},{65.24,58.62},{65.20,58.68},{65.19,58.71},{65.10,58.86},{65.02,59.01},{64.96,59.18},{64.97,59.33},{64.97,59.38},{64.98,59.58},{64.99,59.77},{65.00,59.97},{65.04,60.15},{65.09,60.33},{65.12,60.40},{65.17,60.56},{65.20,60.64},{65.22,60.73},{65.25,60.92},{65.20,61.10},{65.14,61.27},{65.12,61.30},{65.07,61.44},{65.03,61.53},{64.97,61.70},{64.97,61.88},{65.02,62.06},{65.02,62.06},{65.07,62.24},{65.13,62.41},{65.13,62.60},{65.08,62.71},{65.04,62.79},{65.01,62.86},{65.00,62.89},{64.93,63.05},{64.88,63.15},{64.81,63.14},{64.68,63.11},{64.55,63.10},{64.46,63.10},{64.39,63.09},{64.26,63.08},{64.13,63.06},{64.05,62.96},{64.04,62.76},{64.04,62.57},{64.04,62.37},{64.04,62.34},{64.03,62.18},{64.06,62.01},{64.18,61.92},{64.29,61.82},{64.37,61.76},{64.44,61.71},{64.56,61.64},{64.69,61.62},{64.70,61.61},{64.79,61.60},{64.93,61.60},{65.05,61.62},{65.18,61.65},{65.31,61.69},{65.41,61.72},{65.47,61.74},{65.60,61.78},{65.68,61.73},{65.76,61.65},{65.85,61.57},{65.94,61.48},{66.05,61.37},{66.08,61.21},{66.06,61.02},{66.06,61.00},{66.04,60.83},{66.01,60.64},{65.99,60.44},{65.93,60.28},{65.84,60.13},{65.83,60.11},{65.78,60.03},{65.70,59.88},{65.61,59.73},{65.58,59.68},{65.52,59.55},{65.43,59.40},{65.36,59.27},{65.31,59.18},{65.26,59.09},{65.26,59.09},{65.17,58.94},{65.13,58.84},{65.06,58.68},{64.99,58.51},{64.94,58.35},{64.93,58.32},{64.87,58.14},{64.84,58.05},{64.79,57.92},{64.71,57.78},{64.63,57.66},{64.56,57.50},{64.56,57.48},{64.53,57.30},{64.49,57.11},{64.48,57.03},{64.44,56.84},{64.40,56.65},{64.36,56.47},{64.35,56.42},{64.31,56.24},{64.28,56.15},{64.22,56.02},{64.21,55.97},{64.12,55.77},{64.17,55.87}}}},
        },
        [34865] = { -- Tunneling Worm
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{80,89.2},{78.68,88.84},{78.78,86.59},{78.31,85.11},{66.38,96.49},{64.98,96.39},{60.61,98.65},{62.71,99.58},{62.17,96.47},{63.46,92.54},{63.6,95.1},{64.06,89.79},{63.66,97.38},{63.69,92.39},{63.94,89.59},{72.11,75.04},{72.65,72.79},{72.37,70.27},{74.73,68.82},{74.85,70.76},{73.46,69.69},{75.62,84.55},{63.82,90.39},{64.07,95.3},{63.31,92.99},{72.42,72.59},{72.18,74.31},{74.92,70.81},{73.45,69.93},{66.74,96.39},{76.99,85.47},{74.77,69.05},{72.42,70.54},{65.54,96.42},{75.47,84.64}}},
        },
        [34872] = { -- Foreman Dampwick
            [npcKeys.spawns] = {
                [zoneIDs.KEZAN] = {
                    {60.22,74.56,phases.KEZAN_CHAPTER_1},
                    {63.03,77.81,phases.KEZAN_CHAPTER_5},
                    {63.03,77.81,phases.KEZAN_CHAPTER_6},
                    {21.63,13.47,phases.KEZAN_CHAPTER_7},
                },
            },
        },
        [34874] = { -- Megs Dreadshredder
            [npcKeys.spawns] = {
                [zoneIDs.KEZAN] = {
                    {58.23,76.45,phases.KEZAN_CHAPTER_1},
                    {60.08,78.23,phases.KEZAN_CHAPTER_5},
                    {60.08,78.23,phases.KEZAN_CHAPTER_6},
                    {21.62,12.91,phases.KEZAN_CHAPTER_7},
                },
            },
            [npcKeys.questStarts] = {14071,14121,24567,28606,28607},
        },
        [34957] = { -- Ace
            [npcKeys.questStarts] = {},
        },
        [34958] = { -- Gobber
            [npcKeys.questStarts] = {},
        },
        [34959] = { -- Izzy
            [npcKeys.questStarts] = {},
        },
        [34996] = { -- Highlord Tirion Fordring
            [npcKeys.questEnds] = {},
        },
        [35053] = { -- Candy Cane
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{56.31,77.11}}},
        },
        [35054] = { -- Chip Endale
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{56.32,76.77}}},
        },
        [35086] = { -- Labor Captain Grabbit
            [npcKeys.spawns] = {
                [zoneIDs.AZSHARA] = {
                    {27,77.08,phases.AGTOR_GRABBIT_OUTSIDE_ATTACK},
                },
            },
            [npcKeys.questEnds] = {14129,14134,14135,14155,25275,28496},
        },
        [35118] = { -- Bloodfang Worgen
            [npcKeys.questStarts] = {},
        },
        [35120] = { -- FBoK Bank Teller
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{31.11,71.91},{29.66,71.91}}},
        },
        [35149] = { -- Talrendis Sniper
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{27.78,68.66},{28.73,69.61},{30.43,70.06},{31.44,69.46},{31.04,70.52},{35.43,80.8},{35.01,81.43},{35.02,79.8},{34.44,80.1},{34.26,79.18},{34.1,80.88},{32.4,77.91},{34.12,78.53},{33.52,78.09},{30.97,80.39},{32.89,79.42},{33.03,78.76},{32.23,78.92},{32.54,76.81},{31.6,79.23},{31.63,77.21},{31.11,72.15},{31.72,76.06},{31.14,78.24},{30.45,79.46},{29.73,70.75},{31.24,73.84},{30.12,71.35},{31.31,74.9},{30.55,76},{29.63,72.43},{30.17,73.63},{30.32,74.73},{23.15,73.3},{23.4,74.39},{22.67,74.05},{30.08,78.83},{29.73,77.96},{24.45,74.58}}},
        },
        [35177] = { -- Talrendis Raider
            [npcKeys.questStarts] = {},
        },
        [35195] = { -- Labor Captain Grabbit
            [npcKeys.spawns] = {
                [zoneIDs.AZSHARA] = {
                    {27,77.08,phases.AGTOR_GRABBIT_DURING_ATTACK},
                },
            },
        },
        [35198] = { -- Talrendis Ancient
            [npcKeys.questStarts] = {},
        },
        [35222] = { -- Trade Prince Gallywix
            [npcKeys.spawns] = {
                [zoneIDs.KEZAN] = {
                    {56.73,76.93,phases.KEZAN_GALLYWIX_AT_HQ},
                    {20.84,13.69,phases.KEZAN_GALLYWIX_ON_BOAT},
                },
            },
        },
        [35229] = { -- Bloodfang Stalker
            [npcKeys.questStarts] = {},
        },
        [35234] = { -- Hired Looter
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{60.02,48.83},{40.28,69.42},{46.99,61.92},{44.68,65.36},{46.23,68.82},{48.58,54.99},{43.68,59.39},{43.76,63.09},{51.09,60.24},{45.4,56.19},{48.27,68.03},{50.83,57.92},{33.58,74.09},{36.82,70.97},{41.21,75.55},{39.4,69.65},{44.2,75.67},{34.35,62.07},{39.68,48.85},{42.51,51.15},{24.87,49.82},{33.21,63.28},{40.91,43.68},{40.93,45.78},{33.02,60.82},{28.88,43.07},{29.62,58.46},{30.98,56.36},{27.49,59.11},{36.34,43.2},{35.46,49.38},{35.51,45.41},{36.75,51.32},{36.64,45.34},{33.38,65.87},{40.01,54.87},{37.64,54.39},{50.81,59.51},{48.27,67.72},{50.37,57.57},{29.89,65.61},{48.27,67.36},{41.78,43.1},{39.83,34.92},{35.6,42.95},{63.74,48.36},{42.37,51.04},{46.07,36.04},{48.53,37.43}}},
        },
        [35256] = { -- Cheerful Dalaran Spirit
            [npcKeys.spawns] = {[zoneIDs.DALARAN] = {{34.45,38.13}}},
        },
        [35257] = { -- Mountainfoot Miner
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{24.6,72.1},{24.28,72.01},{24.26,73.04},{25.01,71.7},{25.21,71.29},{25.1,69.9},{24.89,71.13},{24.88,71.47},{25.02,69.62},{23.28,69.89},{21.97,70.5},{22.44,69.44},{23.33,71.57},{24.57,70.39},{23.54,71.11},{24.92,68.02},{25.92,68.76},{26.63,70.12},{25.53,69.05},{23.73,69.29},{22.8,67.84},{23.46,67.15},{24.74,69.94},{23.02,68.02},{23.73,67.58},{23.73,67.06},{22.94,69.34},{23.61,66.73},{21.07,70.81},{21.16,71.18},{25,66.9},{26.57,69.8},{21.05,70.91},{24.84,71.2},{25.15,71.29}}},
        },
        [35260] = { -- Cheerful Aldor Spirit
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{39.79,21.8}}},
        },
        [35261] = { -- Cheerful Scryer Spirit
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{40.17,22.25}}},
        },
        [35281] = { -- Rukua
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS] = {{43.79,78.57}}},
        },
        [35290] = { -- Steen Horngrass
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [35463] = { -- Bloodfang Lurker
            [npcKeys.questStarts] = {},
        },
        [35486] = { -- First Bank of Kezan Vault
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{29.89,71.33}}},
            [npcKeys.questStarts] = {},
        },
        [35487] = { -- North Survey Marker Kill Credit
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{34.7,71.57}}},
        },
        [35488] = { -- West Survey Marker Kill Credit
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{34.28,76.64}}},
        },
        [35489] = { -- East Survey Marker Kill Credit
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{37.37,74.63}}},
        },
        [35557] = { -- The Black Knight
            [npcKeys.questStarts] = {29853},
        },
        [35566] = { -- Lord Darius Crowley
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS_CITY] = {
                    {48.9,52.8,phases.LOST_ISLES_CHAPTER_3},
                    {48.9,52.8,phases.LOST_ISLES_CHAPTER_4},
                },
            },
        },
        [35591] = { -- Lesser Infernal
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{54.22,80.89},{53.77,82.28},{57.59,77.08},{49.36,77.96},{54.43,83.62},{53.59,79.84},{53.03,86.05},{54.58,73.57},{52.73,72.21},{50.46,73.68},{54.31,71.14},{56.8,71.13},{55.17,79.52},{51.45,75.61},{48.89,77.0},{50.83,70.2}}},
        },
        [35627] = { -- Frenzied Stalker
            [npcKeys.questStarts] = {},
        },
        [35628] = { -- Polymorphed Cockroach
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{59.93,24.16},{58.49,26.36},{59.62,22.84},{52.14,16.86},{60.79,23.68},{58.3,24.55},{54.46,24.57},{54.84,24.31},{54.98,24.4},{54.84,25.9},{55.07,26.7},{56.71,21.85},{57.16,24.07},{61.38,25.12},{61.28,26.71},{59,21.73},{53.4,24.95},{59.2,24.45},{57.73,26.11},{53.59,24.05},{53.04,19.64},{56.25,22.02},{53.83,22.37},{52.24,22.5},{56.29,25},{56.72,23.62},{55.68,26.47},{51.98,17.32},{56.22,24.93},{53.56,24.07},{52.67,22.33},{53.09,21.94},{56.09,24.81},{59.64,24.77},{58.93,26.59},{60.43,28.08},{51.72,16.48},{53.85,19.88},{55.31,25.12},{55.08,22.57},{55.37,23.4},{54.23,23.83},{54.86,20.68},{54.84,23.72},{54.43,23.11},{60.63,27.21},{55.25,25.15},{54.69,20.83},{55.12,22.29},{54.85,23.72},{55.04,22.34},{60.65,26.66}}},
        },
        [35759] = { -- Balboa
            [npcKeys.waypoints] = {[zoneIDs.AZSHARA] = {{{54.15,21.49},{53.94,21.34},{53.41,21.08},{53.14,20.91},{52.94,20.74},{52.75,20.56},{52.48,20.39},{52.12,20.23},{51.89,20.20},{51.67,20.17},{51.33,20.05},{51.10,20.01},{50.88,19.96},{50.51,19.85},{50.28,19.79},{50.06,19.76},{49.72,19.71},{49.52,19.56},{49.29,19.33},{49.02,18.96},{48.86,18.72},{48.66,18.40},{48.43,18.10},{48.24,17.91},{48.06,17.71},{47.88,17.50},{47.56,17.15},{47.38,16.95},{47.20,16.74},{47.02,16.54},{46.86,16.30},{46.65,15.78}}}},
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{46.8,16.16}}},
        },
        [35830] = { -- Gilneas Evacuation Facing Marker (First)
            [npcKeys.questStarts] = {},
        },
        [35839] = { -- Sergeant Cleese
            [npcKeys.spawns] = {[zoneIDs.GILNEAS_CITY] = {{67.55,64.26}}},
        },
        [35867] = { -- Kalec
            [npcKeys.spawns] = {
                [zoneIDs.AZSHARA] = {
                    {55.49,52.13},
                    {66.55,20.36,phases.KALEC_TERMINUS},
                },
            },
        },
        [35875] = { -- Aggra
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {37.63,78.03,phases.LOST_ISLES_CHAPTER_1},
                    {37.63,78.03,phases.LOST_ISLES_CHAPTER_2},
                },
            },
        },
        [35906] = { -- Lord Godfrey
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS_CITY] = {
                    {55.6,80.6,phases.LOST_ISLES_CHAPTER_2},
                    {55.6,80.6,phases.LOST_ISLES_CHAPTER_3},
                },
            },
        },
        [36059] = { -- Blood-filled Leech
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{47.74,43.86},{54.74,40.83},{57.72,41.87},{58.42,35.86},{50.68,39.18},{57.39,39.86},{60.12,39.6},{55.86,52.54},{49.89,51.46},{49.36,43.14},{54.96,35.79},{57.43,36.65},{59.41,34.32},{47.41,46.57},{53.73,39.21},{55.08,38.66},{50.92,50.95},{58.67,40.27},{49.98,40.89},{50.46,49.7},{55.92,39.97},{56.24,36.34},{52.34,44.48},{54.14,46.28},{52.53,48.92},{51.96,50.77},{59.71,36.06},{59.66,36.31},{53.51,43.85},{53.54,48.75},{52.87,46.65},{51.39,44.36},{49.06,45.58},{47.22,48.69},{47.83,49.86},{48.63,47.84},{47.91,51.93},{52.9,51.02},{54.24,50.31},{51.29,46.54},{51.64,49.46}}},
        },
        [36163] = { -- Khan Kammah
            [npcKeys.spawns] = {
                [zoneIDs.DESOLACE] = {
                    {71.73,45.57,phases.KAMMAH_STONE},
                    {73.34,41.63,phases.KAMMAH_TENT},
                },
            },
        },
        [36196] = { -- Kherrah
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{27.29,62.96}}},
        },
        [36206] = { -- Blubbergut
            [npcKeys.waypoints] = {[zoneIDs.DESOLACE] = {{{21.25,75.62},{21.10,74.37},{20.67,73.59},{19.57,72.75},{18.35,72.66},{17.02,73.47},{17.00,75.76},{16.80,78.40},{16.13,80.43},{15.65,82.68},{16.63,84.07},{17.47,85.22},{19.47,84.87},{20.63,84.80},{21.78,84.21},{22.73,83.39},{23.16,81.92},{23.56,80.82},{24.08,79.56},{24.23,78.16},{23.55,77.20},{22.96,77.42},{22.38,77.71},{21.62,76.75},{21.37,76.60},{21.02,75.95},{20.19,75.06},{20.07,75.08},{18.86,74.07},{18.12,73.55},{18.12,73.55}}}},
        },
        [36210] = { -- Sorata Firespinner
            [npcKeys.spawns] = {
                [zoneIDs.AZSHARA] = {
                    {42.71,25.11,phases.SORATA_AT_EXCHANGE},
                    {53.26,49.96,phases.SORATA_AT_HARBOR},
                },
            },
        },
        [36410] = { -- Officer Jankie
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{54.24,9.27}}},
        },
        [36416] = { -- Jankie's Mount
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{54.27,9.37}}},
        },
        [36444] = { -- Khan Leh'Prah
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{82.34,80.85}}},
        },
        [36452] = { -- Gwen Armstead
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {37.63,65.23,phases.GILNEAS_CHAPTER_7},
                    {37.63,65.23,phases.GILNEAS_CHAPTER_8},
                },
            },
        },
        [36458] = { -- Grandma Wahl
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {32.52,75.48,phases.GILNEAS_CHAPTER_7},
                },
            },
        },
        [36471] = { -- Foreman Dampwick
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {45.36,64.75,phases.LOST_ISLES_CHAPTER_4},
                    {45.36,64.75,phases.LOST_ISLES_CHAPTER_5},
                    {51.85,47.2,phases.LOST_ISLES_CHAPTER_7},
                },
            },
        },
        [36527] = { -- The Velocistar
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{42.28,75.76}}},
        },
        [36600] = { -- Geargrinder Gizmo
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{24.65,77.95}}},
        },
        [36608] = { -- Doc Zapnozzle
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{24.62,77.86}}},
            [npcKeys.questStarts] = {14239},
        },
        [36642] = { -- Myralion Sunblaze
            [npcKeys.questStarts] = {24555,24559,24560,24561,24562,24798,24799,24800,24801},
        },
        [36644] = { -- Ahmo Thunderhorn
            [npcKeys.questStarts] = {24459,14438,14491},
            [npcKeys.questEnds] = {14436,14437,14438,14491,24215},
        },
        [36676] = { -- Azuregos
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{67.07,20.57}}},
        },
        [36682] = { -- The Hammer
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{41.93,65.96}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_LOST_ISLES] = {{{41.93,65.96},{41.47,66.06},{41.54,66.09},{40.64,66.37}}}},
        },
        [36743] = { -- King Genn Greymane
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {26.44,46.91,phases.GILNEAS_CHAPTER_8},
                },
            },
        },
        [36749] = { -- Commander Molotov
            [npcKeys.spawns] = {
                [zoneIDs.AZSHARA] = {
                    {29.46,57.67,phases.MOLOTOV_AT_RUINS},
                    {60.64,50.59,phases.MOLOTOV_AT_HARBOR},
                },
            },
        },
        [36845] = { -- Agitated Earth Spirit
            [npcKeys.spawns] = {[zoneIDs.MULGORE] = {{34.11,47.71},{33.59,49.07},{33.41,48.97},{33.42,48.45},{33.26,47.86},{33.11,47.9},{33,47.71},{33.24,49.35},{32.93,49.22},{32.86,48.98},{33.06,48.77},{32.84,48.31},{32.7,48.47},{32.55,48.64},{32.46,48.57},{32.72,47.8},{32.26,48.28},{32.07,49.08},{32.53,49.15},{32.65,49.35},{32.87,49.63},{32.9,50.21},{32.78,50.18},{32.61,50.18},{32.43,50.22},{32.19,49.7},{32.27,49.44}}},
        },
        [36901] = { -- Submerge Bunny
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{45.79,33.96}}},
            [npcKeys.zoneID] = zoneIDs.KELP_THAR_FOREST,
        },
        [36906] = { -- Talrendis Command Center Kill Credit
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{9.29,72.55}}},
            [npcKeys.zoneID] = zoneIDs.AZSHARA,
        },
        [37106] = { -- Coach Crosscheck
            [npcKeys.questStarts] = {24488,24502,24503,24520,28414},
        },
        [37114] = { -- Steamwheedle Shark
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{47.7,60.29},{47.1,62.41},{47.63,62.37},{48.33,62.33},{47.95,61.64},{47.55,61.67},{47.27,61.13},{48.11,61.07}}},
            [npcKeys.questStarts] = {},
        },
        [37115] = { -- Teo Hammerstorm
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{35.82,64.59}}},
        },
        [37165] = { -- Henry Zykes
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{38.88,13.35}}},
            [npcKeys.waypoints] = {[zoneIDs.SOUTHERN_BARRENS] = {{{40.93,15.55},{40.77,15.53},{40.57,15.45},{40.44,15.38},{40.26,15.25},{40.15,15.14},{40.00,14.95},{39.93,14.81},{39.83,14.68},{39.60,14.61},{39.44,14.56},{39.27,14.48},{39.13,14.41},{38.99,14.31},{38.88,14.14},{38.80,13.97},{38.72,13.71},{38.68,13.57},{38.68,13.55},{38.69,13.32},{38.83,13.62},{38.82,14.02},{38.89,14.19},{39.04,14.34},{39.19,14.30},{39.37,14.22},{39.52,14.24},{39.64,14.29},{39.76,14.37},{39.90,14.51},{40.08,14.71},{40.13,14.90},{40.19,15.03},{40.39,15.25},{40.55,15.38},{40.61,15.40},{40.68,15.38},{40.88,15.31},{40.79,15.51},{40.69,15.75},{40.67,16.20},{40.68,16.36},{40.72,16.64},{40.78,16.95},{40.87,17.17},{40.97,17.41},{41.02,17.57},{41.04,17.62},{41.07,17.79},{41.07,17.91},{41.22,18.10},{41.38,18.34},{41.47,18.46},{41.59,18.63},{41.71,18.80},{41.83,18.99},{41.89,19.22},{41.86,19.46},{41.88,19.71},{41.97,19.92},{42.09,20.10},{42.15,20.17},{42.16,20.19},{42.31,20.33},{42.16,20.48},{42.00,20.82},{41.99,21.08},{42.00,21.20},{42.09,21.57},{42.15,21.70},{42.26,21.95},{42.32,22.12},{42.41,22.45},{42.44,22.58},{42.49,22.96},{42.51,23.17},{42.56,23.44},{42.57,23.62},{42.57,23.92},{42.56,24.18},{42.53,24.40},{42.52,24.46},{42.44,24.89},{42.41,25.08},{42.40,25.26},{42.39,25.35},{42.38,25.57},{42.57,25.68},{42.71,25.84},{42.84,26.04},{42.94,26.33},{42.99,26.48},{43.02,26.61},{43.10,26.97},{43.18,27.18},{43.24,27.27},{43.38,27.48},{43.23,27.23},{43.04,26.94},{42.95,26.80},{42.87,26.58},{42.82,26.36},{42.77,26.03},{42.78,25.80},{42.80,25.61},{42.80,25.27},{42.70,24.97},{42.62,24.87},{42.52,24.72},{42.42,24.48},{42.42,24.34},{42.42,24.00},{42.42,23.82},{42.41,23.41},{42.40,23.17},{42.40,22.89},{42.42,22.66},{42.51,22.41},{42.61,22.31},{42.42,22.10},{42.34,21.98},{42.26,21.81},{42.17,21.54},{42.09,21.27},{42.07,21.21},{41.95,20.77},{41.90,20.59},{41.83,20.33},{41.78,20.11},{41.76,19.98},{41.70,19.74},{41.64,19.51},{41.52,19.16},{41.44,18.93},{41.37,18.80},{41.22,18.59},{41.07,18.35},{41.04,18.23},{40.94,18.00},{40.79,17.83},{40.77,17.57},{40.76,17.34},{40.74,17.08},{40.75,16.88},{40.79,16.61},{40.86,16.37},{40.95,16.11},{40.97,16.05},{41.02,15.84},{41.06,15.53},{41.14,15.34},{40.93,15.55}}}},
        },
        [37172] = { -- Detective Snap Snagglebolt
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{50.8,75.24}}},
            [npcKeys.questStarts] = {24536,24541,24638,24645,24647,24648,24649,24650,24651,24652,24850,28935},
            [npcKeys.questEnds] = {14483,24536,24541,24576,24638,24645,24647,24648,24649,24650,24651,24652,24805,28935},
        },
        [37487] = { -- Taurajo Refugee
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{38.59,33.2},{39.07,33.27},{38.7,33.65},{41.54,37.33},{42.04,36.65},{41.97,37.14},{42.12,37.62},{42.02,37.77},{41.11,36.21},{39.51,32.62},{39.16,34.77}}},
        },
        [37513] = { -- Sabersnout
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{42.99,41.6}}},
        },
        [37514] = { -- Grik'nir's Servant
            [npcKeys.questStarts] = {},
        },
        [37527] = { -- Halduron Brightwing
            [npcKeys.questStarts] = {24535,24553,24563,24564,24594,24595,24596,24598},
        },
        [37598] = { -- Gasbot
            [npcKeys.questStarts] = {},
        },
        [37602] = { -- Claims Adjuster
            [npcKeys.spawns] = {
                [zoneIDs.KEZAN] = {
                    {59.6,76.48,phases.KEZAN_CHAPTER_6},
                },
            },
        },
        [37675] = { -- Public Relations Agent
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS] = {{45.02,57.73}},[zoneIDs.IRONFORGE] = {{34.15,66.42}},[zoneIDs.STORMWIND_CITY] = {{62.41,75.38}},[zoneIDs.THE_EXODAR] = {{73.73,56.06}}, -- original data
                               [zoneIDs.THUNDER_BLUFF] = {{43.6,52.9}},[zoneIDs.ORGRIMMAR] = {{53.05,77.15}},[zoneIDs.UNDERCITY] = {{65.9,38.7}},[zoneIDs.SILVERMOON_CITY] = {{64.6,67.3}}}, -- corrections
            [npcKeys.questStarts] = {24629,24635,24636},
        },
        [37733] = { -- Lord Walden
            [npcKeys.spawns] = {[zoneIDs.GILNEAS] = {{78.11,66.11}}},
            [npcKeys.waypoints] = {[zoneIDs.GILNEAS] = {{{79.33,64.84},{79.16,65.02},{78.90,65.31},{78.84,65.34},{78.77,65.38},{78.69,65.42},{78.60,65.48},{78.44,65.63},{78.37,65.70},{78.31,65.78},{78.25,65.85},{78.19,65.93},{78.13,66.01},{78.10,66.11},{78.14,66.21},{78.17,66.32},{78.13,66.42},{78.07,66.50},{78.00,66.47},{77.95,66.38},{77.90,66.30},{77.90,66.30},{77.87,66.27},{77.82,66.18},{77.84,66.08},{77.90,65.99},{77.97,66.02},{77.97,66.02},{78.01,66.06},{78.08,66.12},{78.08,66.13}}}},
        },
        [37759] = { -- Omusa's Spirit
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{43.69,52.34}}},
        },
        [37780] = { -- Dark Ranger Vorel
            [npcKeys.spawns] = {[zoneIDs.DALARAN] = {{50.78,18.46}}},
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },
        [37783] = { -- Lorna Crowley
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {70.88,39.84,phases.GILNEAS_CHAPTER_9},
                    {70.88,39.84,phases.GILNEAS_CHAPTER_10},
                },
            },
        },
        [37843] = { -- Gar'dul Top of Tower Quest Credit
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{40.72,69.24}}},
            [npcKeys.zoneID] = zoneIDs.SOUTHERN_BARRENS,
        },
        [37847] = { -- Mankrik
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{44.51,88.09}}},
        },
        [37921] = { -- Orcish War Machine
            [npcKeys.spawns] = {[zoneIDs.GILNEAS] = {{32.19,42.12},{28.55,39.05},{29.19,40.94},{30.57,32.27},{26.57,31.45},{26.37,32.83},{27.07,35.13},{30.9,20.19},{29.26,21.2},{27.79,25.67},{27.67,27.29}}},
        },
        [37951] = { -- Jin'thala
            [npcKeys.questStarts] = {24607,24750,24758,24764,24770,24776,24782,26272},
        },
        [37953] = { -- Dark Scout
            [npcKeys.waypoints] = {[zoneIDs.GILNEAS] = {{{66.10,81.01},{65.89,81.14},{65.68,81.26},{65.46,81.31},{65.24,81.31},{65.02,81.31},{64.80,81.31},{64.57,81.31},{64.35,81.31},{64.13,81.31},{63.90,81.30},{63.68,81.30},{63.46,81.30},{63.24,81.31},{63.01,81.34},{62.81,81.46},{62.61,81.62},{62.51,81.74}}}},
        },
        [37989] = { -- Swiftclaw
            [npcKeys.waypoints] = {[zoneIDs.DUROTAR] = {{{62.56,94.34},{62.29,94.41},{62.16,94.80},{62.10,95.00},{61.96,95.38},{61.80,95.74},{61.75,95.96},{61.75,96.23},{61.89,96.45},{62.12,96.41},{62.29,96.30},{62.37,96.11},{62.50,95.72},{62.59,95.51},{62.79,95.33},{63.08,95.33},{63.24,95.44},{63.41,95.60},{63.53,95.79},{63.58,96.06},{63.47,96.31},{63.24,96.36},{62.95,96.37},{62.77,96.42},{62.73,96.84},{62.65,97.15},{62.61,97.28},{62.72,97.61},{62.99,97.58},{63.14,97.22},{63.32,96.89},{63.48,96.84},{63.63,96.92},{63.70,97.33},{63.76,97.63},{63.82,97.93},{63.96,98.07},{64.13,97.94},{64.13,97.54},{64.12,97.10},{64.13,96.83},{64.13,96.65},{64.21,96.40},{64.43,96.36},{64.44,96.37},{64.42,96.79},{64.31,97.02},{64.19,96.89},{64.09,96.61},{64.07,96.23},{64.02,95.90},{63.87,95.68},{63.67,95.41},{63.64,95.13},{63.72,94.94},{63.90,94.82},{64.12,94.98},{64.28,94.92},{64.31,94.54},{64.20,94.39},{63.94,94.20},{63.77,94.13},{63.66,94.24},{63.48,94.59},{63.30,94.93},{63.23,95.07},{63.07,95.42},{62.98,95.68},{62.82,96.05},{62.74,96.13},{62.55,96.14},{62.49,95.79},{62.48,95.63},{62.59,95.28},{62.70,95.10},{62.90,94.78},{62.94,94.62},{62.72,94.41},{62.44,94.28}}}},
            [npcKeys.questStarts] = {},
        },
        [38002] = { -- Swiftclaw
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{66.04,88.08}}},
            [npcKeys.questStarts] = {},
        },
        [38006] = { -- Crown Hoodlum
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{61.57,37.9},{61.27,38.12},{60.99,38.46},{61.38,38.75},{61.68,39.43},{61.28,39.69},{60.94,39.22},{60.79,38.35},{60.22,37.13},{60.09,37.68},{59.98,38.06},{60.43,38.39},{60.62,38.78},{60.84,38}}},
        },
        [38016] = { -- Crown Agent
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{23.05,54.37},{22.46,54.33},{22.73,53.71},{22.83,52.76},{23.52,52.51},{24.25,52.46},{23.88,53.29},{23.49,53.49},{23.43,53.91},{23.77,54.5},{24.2,53.79},{24.36,54.82}}},
        },
        [38023] = { -- Crown Sprinkler
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{62.57,49.42},{62.92,48.28},{63.27,48.6},{63.5,48.94},{63.32,49.09},{63.1,50.57},{63.09,50.16},{63.2,49.85},{63.4,50.05},{63.54,50.31},{63.82,50.27},{64.2,49.67},{63.62,49.26},{63.62,49.61},{63.81,49.59}}},
        },
        [38042] = { -- Kwee Q. Peddlefeet
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{53,76.83}},},
        },
        [38066] = { -- Inspector Snip Snagglebolt
            [npcKeys.questStarts] = {24655,24656,24658,24659,24660,24662,24663,24664,24665,24666,24848,28934},
            [npcKeys.questEnds] = {24655,24656,24657,24658,24659,24660,24662,24663,24664,24665,24666,24745,24804,28934},
        },
        [38120] = { -- Hobart Grapplehammer
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {45.34,65.21,phases.LOST_ISLES_CHAPTER_5},
                    {68.93,46.44,phases.LOST_ISLES_CHAPTER_7},
                    {43.85,25.3,phases.LOST_ISLES_CHAPTER_9},
                },
            },
        },
        [38122] = { -- Bamm Megabomb
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{45.25,64.85}}},
        },
        [38124] = { -- Assistant Greely
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {45.27,65.57,phases.LOST_ISLES_CHAPTER_5},
                    {51.72,47.38,phases.LOST_ISLES_CHAPTER_7},
                    {53.16,36.55,phases.LOST_ISLES_CHAPTER_8},
                    {54.39,16.93,phases.LOST_ISLES_CHAPTER_9},
                },
            },
        },
        [38142] = { -- Captive Spitescale Scout
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{67.27,83.93},{65.28,83.52}}},
        },
        [38144] = { -- Krennan Aranas
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {49.84,56.92,phases.GILNEAS_CHAPTER_11},
                    {49.84,56.92,phases.GILNEAS_CHAPTER_12},
                },
            },
        },
        [38150] = { -- Glaive Thrower
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {42.91,37.24,phases.GILNEAS_CHAPTER_12},
                    {42.45,37.83,phases.GILNEAS_CHAPTER_12},
                },
            },
        },
        [38224] = { -- Mechachicken
            [npcKeys.waypoints] = {[zoneIDs.THE_LOST_ISLES] = {{{43.76,56.00},{43.70,55.84},{43.63,55.63},{43.52,55.25},{43.56,54.83},{43.62,54.27},{43.63,54.23},{43.78,54.01},{43.91,53.84},{44.32,53.66},{44.42,53.78},{44.89,54.45},{45.02,54.65},{45.18,54.91},{45.20,54.97},{45.35,55.30},{45.48,55.61},{45.64,56.11},{45.57,56.39},{45.55,56.45},{45.27,56.86},{45.07,56.93},{44.81,56.98},{44.70,56.98},{44.46,56.92},{44.21,56.74},{44.07,56.54},{43.76,56.00}}}},
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{43.78,56.02}}},
        },
        [38238] = { -- Dweller by the Shore
            [npcKeys.name] = "Dweller by the Shore"
        },
        [38239] = { -- Dweller in the Cliffs
            [npcKeys.name] = "Dweller in the Cliffs"
        },
        [38240] = { -- Dweller of the North
            [npcKeys.name] = "Dweller of the North"
        },
        [38245] = { -- Tunari
            [npcKeys.questStarts] = {24783,24784,24785,24786,24787},
        },
        [38251] = { -- Bael'dun Escape Quest Credit
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{49.84,86.84}}},
            [npcKeys.zoneID] = zoneIDs.SOUTHERN_BARRENS,
        },
        [38255] = { -- Maximillian of Northshire
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{30.62,51.14}}},
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
        },
        [38307] = { -- Gormashh
            [npcKeys.waypoints] = {[zoneIDs.UN_GORO_CRATER] = {{{59.97,29.88},{59.73,29.41},{59.47,29.25},{59.21,29.64},{58.97,30.41},{59.10,30.58},{59.32,31.02},{59.68,31.29},{59.99,31.45},{60.32,31.65},{60.62,31.90},{60.86,32.16},{60.82,32.31},{60.76,32.63},{60.89,32.87},{60.81,33.11},{60.72,33.33},{60.60,33.70},{60.70,33.88}}}},
        },
        [38316] = { -- Ormus the Penitent
            [npcKeys.questEnds] = {24815,24818,24819,24820,24821,24822,24823,24825,24826,24827,24828,24829,24830,24831,24832,24833,24834,24835,24836,24837,24838,24839,24840,24841,24842,24843,24844,24845,24846,24847,25239,25240,25242},
        },
        [38328] = { -- Roka
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{57.59,60.81}}},
        },
        [38329] = { -- Durrin Direshovel
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{37.81,82.81}}},
            [npcKeys.waypoints] = {[zoneIDs.UN_GORO_CRATER] = {{{38.36,82.99},{38.34,81.55},{38.63,80.45},{38.58,79.01},{38.60,78.27},{38.32,77.50},{37.63,76.69},{36.73,76.25},{36.33,76.73},{36.19,77.75},{36.56,79.01},{37.02,80.16},{37.36,81.31},{37.57,82.47},{38.35,82.70},{38.36,82.99}}}},
        },
        [38381] = { -- Brett "Coins" McQuid
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{52.2,73.22}}},
        },
        [38387] = { -- Sassy Hardwrench
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {45.18,64.9,phases.LOST_ISLES_CHAPTER_5},
                    {45.18,64.9,phases.LOST_ISLES_CHAPTER_6},
                    {45.18,64.9,phases.LOST_ISLES_CHAPTER_7},
                    {37.3,41.9,phases.LOST_ISLES_CHAPTER_8},
                    {43.63,25.32,phases.LOST_ISLES_CHAPTER_9},
                    {43.63,25.32,phases.LOST_ISLES_CHAPTER_10},
                },
            },
        },
        [38409] = { -- Goblin Survivor
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {54.81,34.49,phases.LOST_ISLES_CHAPTER_8},
                    {53.03,36.86,phases.LOST_ISLES_CHAPTER_8},
                    {54.03,34.47,phases.LOST_ISLES_CHAPTER_8},
                    {53.93,37.43,phases.LOST_ISLES_CHAPTER_8},
                    {56.85,35.68,phases.LOST_ISLES_CHAPTER_8},
                    {54.26,37.19,phases.LOST_ISLES_CHAPTER_8},
                    {53.66,36.65,phases.LOST_ISLES_CHAPTER_8},
                    {55.26,36.65,phases.LOST_ISLES_CHAPTER_8},
                    {55.94,35.57,phases.LOST_ISLES_CHAPTER_8},
                    {53.62,37.39,phases.LOST_ISLES_CHAPTER_8},
                    {56.85,35.68,phases.LOST_ISLES_CHAPTER_8},
                    {55.69,32.97,phases.LOST_ISLES_CHAPTER_8},
                },
            },
        },
        [38432] = { -- Megs Dreadshredder
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{52.2,73.15}}},
        },
        [38437] = { -- Vanira
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{68.43,71.57}}},
        },
        [38440] = { -- Tortunga
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{67.97,89.03}}},
        },
        [38441] = { -- Ace
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {56.99,37.14,phases.LOST_ISLES_CHAPTER_8},
                    {54.16,17.2,phases.LOST_ISLES_CHAPTER_9},
                },
            },
        },
        [38442] = { -- Morakki
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{67.96,74.08}}},
        },
        [38517] = { -- Slinky Sharpshiv
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{53.72,34.93}}},
        },
        [38553] = { -- Krennan Aranas
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {70.05,40.89,phases.GILNEAS_CHAPTER_9},
                    {70.05,40.89,phases.GILNEAS_CHAPTER_10},
                },
            },
        },
        [38539] = { -- King Genn Greymane
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {57.03,52.98,phases.GILNEAS_CHAPTER_10},
                    {57.03,52.98,phases.GILNEAS_CHAPTER_11},
                },
            },
        },
        [38611] = { -- Lorna Crowley
            [npcKeys.spawns] = {
                [zoneIDs.GILNEAS] = {
                    {58.8,53.89,phases.GILNEAS_CHAPTER_10},
                    {58.8,53.89,phases.GILNEAS_CHAPTER_11},
                },
            },
        },
        [38647] = { -- Izzy
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {56.56,71.95,phases.LOST_ISLES_CHAPTER_6},
                    {56.56,71.95,phases.LOST_ISLES_CHAPTER_7},
                    {57.01,35.03,phases.LOST_ISLES_CHAPTER_8},
                    {54.01,16.98,phases.LOST_ISLES_CHAPTER_9},
                },
            },
        },
        [38661] = { -- Rageroar Sea Dog
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{72.6,47.2},{72.9,47.3},{73.1,47.4},{73.3,47.5},{73,47.6},{73.2,47.75},{73.1,47.7}}},
        },
        [38696] = { -- Yngwie
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{62.91,68.56}}},
        },
        [38704] = { -- Kelsey Steelspark
            [npcKeys.spawns] = {
                [zoneIDs.TANARIS] = {
                    {72.2,45.22,phases.KELSEY_AT_COVE},
                },
            },
        },
        [38738] = { -- Coach Crosscheck
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {51.8,47.1,phases.LOST_ISLES_CHAPTER_7},
                    {54.44,16.93,phases.LOST_ISLES_CHAPTER_9},
                },
            },
        },
        [38745] = { -- Kezan Citizen
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {54.36,35.1,phases.LOST_ISLES_CHAPTER_8},
                    {54.09,36.2,phases.LOST_ISLES_CHAPTER_8},
                    {56.81,33.02,phases.LOST_ISLES_CHAPTER_8},
                    {56.49,31.61,phases.LOST_ISLES_CHAPTER_8},
                    {56.77,32.11,phases.LOST_ISLES_CHAPTER_8},
                    {56.77,32.11,phases.LOST_ISLES_CHAPTER_8},
                    {56.79,34.77,phases.LOST_ISLES_CHAPTER_8},
                    {55.42,31.06,phases.LOST_ISLES_CHAPTER_8},
                    {55.8,31.92,phases.LOST_ISLES_CHAPTER_8},
                    {56.61,33.43,phases.LOST_ISLES_CHAPTER_8},
                    {56.54,33.86,phases.LOST_ISLES_CHAPTER_8},
                    {56.15,32.55,phases.LOST_ISLES_CHAPTER_8},
                    {54.95,32.16,phases.LOST_ISLES_CHAPTER_8},
                    {56.32,37.03,phases.LOST_ISLES_CHAPTER_8},
                    {56.48,35.33,phases.LOST_ISLES_CHAPTER_8},
                    {56.63,37.02,phases.LOST_ISLES_CHAPTER_8},
                },
            },
        },
        [38746] = { -- Gobber
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {57.05,32.15,phases.LOST_ISLES_CHAPTER_8},
                },
            },
        },
        [38805] = { -- Wounded Defender
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{67.66,44.68},{68.02,45.41},{68.02,45.67},{67.77,45.32},{67.07,44.72},{67.06,44.44},{67.07,45.35},{66.5,44.67},{66.32,45.17},{67.37,45.21},{66.34,44.96},{66.61,45.34}}},
        },
        [38842] = { -- Rocket Boot Boost Kill Credit
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{51.8,47.1}}},
        },
        [38872] = { -- Ambassador Gaines
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{53.12,46.67}}},
        },
        [38895] = { -- Lilian Voss
            [npcKeys.questStarts] = {},
        },
        [38911] = { -- Xavier the Huntsman
            [npcKeys.questStarts] = {24964,28651},
            [npcKeys.questEnds] = {24962,24964},
        },
        [38935] = { -- Thrall
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {36.79,43.13,phases.LOST_ISLES_CHAPTER_5},
                    {36.79,43.13,phases.LOST_ISLES_CHAPTER_8},
                    {42.16,17.37,phases.LOST_ISLES_CHAPTER_10},
                },
            },
        },
        [38937] = { -- Vile Fin Tadpole
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{74.39,25.9},{74.44,26.04},{74.31,26.11},{74.32,26.02},{74.29,25.98},{72.22,25.35},{72.32,25.28},{72.29,25.17},{71.08,25.73},{70.89,25.59},{70.95,25.69},{70.88,25.81},{70.99,25.85},{69.62,25.19},{69.62,25.28},{69.55,25.27},{68.49,25.71},{68.51,25.82},{68.4,25.85},{68.41,25.92},{68.35,25.93},{66.88,27.06},{66.88,27.09},{66.89,26.91},{66.95,27.06},{64.06,28.96},{64.26,28.99},{64.05,29.1},{64.14,29.17},{65.02,28.58},{65.02,28.54},{65.13,28.6},{66.44,28.45},{66.25,28.43},{66.31,28.61},{66.25,28.61},{66.31,28.41},{59.77,27.36},{59.78,27.45},{59.69,27.42},{59.64,27.33},{59.72,27.98},{59.8,27.98},{59.99,27.64},{61.94,28.74},{61.98,28.54},{62.07,28.55},{61.93,28.55},{61.9,28.44},{61.99,28.72},{62.07,28.55},{61.94,28.56},{61.89,28.58},{61.9,28.45}}},
        },
        [38966] = { -- Vol'jin
            [npcKeys.questEnds] = {24643,24755,24763,24769,24775,24781,24787,24814,26277},
        },
        [38996] = { -- Hazzali Hive Credit Bunny
            [npcKeys.spawns] = {[zoneIDs.TANARIS] = {{54.67,72.11}}},
        },
        [39034] = { -- Dr. Dealwell
            [npcKeys.questStarts] = {25067,25094,25095,25513,25591},
        },
        [39065] = { -- Aggra
            [npcKeys.spawns] = {
                [zoneIDs.THE_LOST_ISLES] = {
                    {36.26,43.37,phases.LOST_ISLES_CHAPTER_5},
                    {36.26,43.37,phases.LOST_ISLES_CHAPTER_8},
                    {42.55,18.22,phases.LOST_ISLES_CHAPTER_9},
                    {42.19,17.4,phases.LOST_ISLES_CHAPTER_10},
                },
            },
        },
        [39066] = { -- Kilag Gorefang
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{33.79,38.78}}},
        },
        [39096] = { -- Painmaster Thundrak
            [npcKeys.waypoints] = {[zoneIDs.ASHENVALE] = {{{45.09,65.07},{44.87,65.16},{44.71,65.23},{44.62,65.15},{44.42,64.94},{44.32,64.84},{44.21,64.72},{44.18,64.68},{44.07,64.58},{43.88,64.38},{43.77,64.23},{43.66,64.08},{43.48,63.85},{43.46,63.82},{43.35,63.67},{43.33,63.65},{43.21,63.46},{43.12,63.36},{43.06,63.33},{42.92,63.45},{42.92,63.64},{42.93,63.75},{43.08,63.94},{43.19,63.94},{43.34,63.95},{43.44,63.98},{43.53,64.08},{43.61,64.16},{43.72,64.27},{43.91,64.47},{44.03,64.58},{44.18,64.75},{44.36,64.93},{44.39,64.96},{44.51,65.06},{44.58,65.14},{44.70,65.27},{44.86,65.30},{44.93,65.31},{45.13,65.28},{45.20,65.25},{45.34,65.19},{45.50,65.13},{45.57,65.11},{45.76,65.09},{45.90,65.07},{45.96,64.88},{45.97,64.67},{45.87,64.49},{45.77,64.52},{45.56,64.67},{45.46,64.85},{45.28,65.03},{45.22,65.05},{44.99,65.10}}}},
        },
        [39141] = { -- Commander Arrington
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{32.3,42.88}}},
        },
        [39142] = { -- Darkblade Cyn
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{33.44,27.88}}},
        },
        [39143] = { -- Alexi Silenthowl
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{30.81,33.93}}},
        },
        [39199] = { -- Assistant Greely
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{53.16,36.55}}},
        },
        [39206] = { -- Acrypha
            [npcKeys.questStarts] = {25149},
            [npcKeys.questEnds] = {25138,25149},
        },
        [39214] = { -- Karranisha
            [npcKeys.questStarts] = {3087,25139},
            [npcKeys.questEnds] = {3087,25139},
        },
        [39218] = { -- Bael'dun Survivor
            [npcKeys.spawns] = {[zoneIDs.SOUTHERN_BARRENS] = {{49.42,86.88}}},
        },
        [39270] = { -- Injured Razor Hill Grunt
            [npcKeys.questStarts] = {25179},
        },
        [39271] = { -- High Tinker Mekkatorque
            [npcKeys.questStarts] = {25393},
        },
        [39283] = { -- Earthmender Norsala
            [npcKeys.questStarts] = {25181,27570,27572},
        },
        [39325] = { -- Grandmatron Tekla
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{40.49,35.36}}},
        },
        [39335] = { -- Wild Mine Cart Ride Kill Credit
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{54.28,17.15}}},
        },
        [39357] = { -- Durotar Telescope Quest KC 1
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{49.53,40.33}}},
        },
        [39358] = { -- Durotar Telescope Quest KC 2
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{49.53,40.33}}},
        },
        [39359] = { -- Durotar Telescope Quest KC 3
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{49.53,40.33}}},
        },
        [39360] = { -- Durotar Telescope Quest KC 4
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{49.53,40.33}}},
        },
        [39341] = { -- Mine Cart
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{56.29,27.33}}},
        },
        [39363] = { -- Chip Endale
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{49.86,13.89}}},
        },
        [39365] = { -- The Kodo
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{52.38,16.48},{52.5,16.48},{54.12,15.2},{54.17,15.03},{53.1,13.81},{53.15,13.63},{56.6,15.31},{56.77,15.23},{55.72,17.68},{55.87,17.69}}},
        },
        [39385] = { -- Screamslash
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{35.83,29.09}}},
            [npcKeys.waypoints] = {[zoneIDs.DUROTAR] = {{{35.50,33.06},{35.63,33.11},{35.76,33.15},{35.89,33.19},{36.02,33.20},{36.08,33.06},{36.09,32.86},{36.10,32.66},{36.12,32.46},{36.13,32.26},{36.14,32.07},{36.14,31.87},{36.11,31.67},{36.07,31.49},{36.00,31.31},{35.98,31.25},{35.95,31.19},{35.89,31.02},{35.82,30.85},{35.75,30.68},{35.75,30.67},{35.72,30.59},{35.69,30.53},{35.67,30.49},{35.61,30.34},{35.54,30.17},{35.47,30.00},{35.45,29.96},{35.46,29.84},{35.50,29.65},{35.54,29.46},{35.61,29.30},{35.72,29.19},{35.83,29.09}}}},
        },
        [39386] = { -- Pilot Muzzlesprock
            [npcKeys.questStarts] = {25212},
        },
        [39407] = { -- Ysondre
            [npcKeys.spawns] = {[357] = {{81.54,42.44}}},
        },
        [39426] = { -- Candy Cane
            [npcKeys.spawns] = {[zoneIDs.THE_LOST_ISLES] = {{39.69,27.17}}},
        },
        [39432] = { -- Takrik Ragehowl
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {30.16,31.73,phases.HYJAL_CHAPTER_2},
                {28.45,29.88,phases.HYJAL_IAN_AND_TARIK_NOT_IN_CAGE},
            }},
        },
        [39433] = { -- Ian Duran
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {30.12,31.3,phases.HYJAL_CHAPTER_2},
                {28.22,29.75,phases.HYJAL_IAN_AND_TARIK_NOT_IN_CAGE},
            }},
        },
        [39434] = { -- Rio Duran
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {30.25,31.54,phases.HYJAL_CHAPTER_2},
                {28.17,29.88,phases.HYJAL_IAN_AND_TARIK_NOT_IN_CAGE},
            }},
        },
        [39435] = { -- Royce Duskwhisper
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {30.29,31.6,phases.HYJAL_CHAPTER_2},
                {28.3,29.98,phases.HYJAL_IAN_AND_TARIK_NOT_IN_CAGE},
            }},
        },
        [39601] = { -- Orb of Ascension
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{89.39,58.83}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [39605] = { -- Garrosh Hellscream
            [npcKeys.questStarts] = {7491,7784,9627,13842,25275,26293,26324,26830,26840,26865,28909},
            [npcKeys.questEnds] = {7490,7783,9626,9813,13189,13841,13842,24612,25267,26294,26397,26398,26798,26830,28717},
        },
        [39609] = { -- Kor'kron Loyalist
            [npcKeys.questEnds] = {25266},
        },
        [39622] = { -- Spirit of Lo'gosh
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {32.33,37.11,phases.HYJAL_CHAPTER_2},
                {29.64,29.28,phases.HYJAL_IAN_AND_TARIK_NOT_IN_CAGE},
            }},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
            [npcKeys.questEnds] = {25272,25355},
        },
        [39627] = { -- Spirit of Goldrinn
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {32.33,37.11,phases.HYJAL_CHAPTER_2},
                {29.64,29.28,phases.HYJAL_IAN_AND_TARIK_NOT_IN_CAGE},
            }},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [39640] = { -- Kristoff Manheim
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{27.23,40.9}}},
        },
        [39654] = { -- Vol'jin
            [npcKeys.questStarts] = {25445},
        },
        [39659] = { -- Spawn of Smolderos
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{89.72,56.35}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [39663] = { -- Drowning Soldier
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{49.47,29.22},{48.3,27.13},{48.65,26.11},{44.24,27.65},{43.27,28.89},{44.26,27.63},{50.93,25.13},{51.59,23.83},{50.56,20.42},{42.27,22.29},{40.76,25.18},{41.99,24.38},{43.09,25.16},{47.41,29.97},{44.56,30.15},{44.33,29.07},{45.5,31.99},{46.24,32.36},{47.96,28.89},{47.26,28.82},{46.16,27.68},{45.51,28.36},{41.71,27.72},{42.38,27.69},{42.93,26.68},{43.5,25.65},{43.58,23.35},{43.1,21.97},{50.45,27.19},{50.44,26.02},{49.77,24.87},{50.48,24.54},{49.72,19.78},{48.95,20.68},{49.44,22.02},{47.96,22.59},{47.84,19.75},{46.02,18.93},{44.83,19.7},{43.88,20.03},{46.91,24.12},{47.82,25.01},{47.82,23.86},{46.85,22.82},{40.07,26.71},{41.71,27.75},{42.38,27.7},{42.42,31.79}}},
        },
        [39664] = { -- Glimmerdeep Tidehunter
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{46.53,49.49},{45.63,48.12},{45.12,48.43},{45.48,48.94},{45.91,47.45},{43.48,46.69},{45.37,47.18},{44.53,47.94},{43.84,47.55},{44.16,46.96},{44.61,45.91},{43.65,46},{43.48,45.6},{42.86,45.83},{40.93,44.39},{41.36,45.34},{42.05,45.91},{42.3,47.49},{41.96,46.97},{41.28,46},{40.95,47.16},{41.44,47.14},{41.76,47.94},{43.33,48.1},{42.41,48.77},{42.87,48.39},{43.41,49.2},{44.42,50.26},{44.93,49.8},{45.2,51.86},{44.86,50.9},{45.42,50.39},{46,51.04},{46.17,51.79},{46.68,52.48},{45.46,47.1},{42.76,44.57},{42.26,45.19},{42.02,44.28},{49.81,48.45}}},
        },
        [39675] = { -- Captain Tread Sparknozzle
            [npcKeys.questEnds] = {25199,25229,25285,25286,25289,25295,25306,25500},
        },
        [39678] = { -- Toby Zeigear
            [npcKeys.questStarts] = {25283,25286,25500},
        },
        [39853] = { -- Taerar
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{81.37,42.53}}},
        },
        [39858] = { -- Arch Druid Hamuul Runetotem
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {27.12,62.64,phases.HYJAL_HAMUUL_RUNETOTEM_AT_SANCTUARY},
                {19.53,37.81,phases.HYJAL_HAMUUL_RUNETOTEM_AT_GROVE},
            }},
            [npcKeys.questStarts] = {25491,25493,25507,25510},
        },
        [39876] = { -- Felora Firewreath
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{49.58,42.13}}},
        },
        [39877] = { -- Toshe Chaosrender
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{55.54,12.52},{53.28,33.08}}},
        },
        [39881] = { -- Wavespeaker Valoren
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {49.54,57.5,phases.VASHJIR_LEGIONS_REST},
                {40.6,75.1,phases.WAVESPEAKER_AT_RUINS},
                {39.22,78.63,phases.VASHJIR_NAR_SHOLA_TERRACE},
                {29.6,78.9,phases.VASHJIR_NAR_SHOLA_TERRACE_WEST},
            }},
        },
        [39926] = { -- Twilight Inciter
            [npcKeys.spawns] = {},
        },
        [39933] = { -- Tyrus Blackhorn
            [npcKeys.questStarts] = {25408,25411,25428,25443},
        },
        [39950] = { -- Harrison Jones
            [npcKeys.questEnds] = {25413,25666},
        },
        [39964] = { -- Akasha
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{57.06,35.31}}},
            [npcKeys.waypoints] = {[zoneIDs.KELP_THAR_FOREST] = {{{57.06,35.31},{57.45,35.64},{57.79,36.06},{58.11,36.54},{58.39,37.05},{58.54,37.67},{58.46,38.32},{58.20,38.86},{57.86,39.28},{57.45,39.57},{57.03,39.76},{56.60,39.66},{56.37,39.10},{56.25,38.45},{56.12,37.81},{56.10,37.15},{56.29,36.56},{56.57,36.03},{56.87,35.54},{57.13,35.45}}}},
        },
        [39996] = { -- Abyssal Seahorse
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{45.06,47}}},
        },
        [40065] = { -- Unbound Flame Spirit
            [npcKeys.spawns] = {},
        },
        [40131] = { -- Sensiria
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{65.95,62.84}}},
        },
        [40178] = { -- Alysra
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{52.12,17.42}}},
        },
        [40184] = { -- Vanira
            [npcKeys.questStarts] = {25444,25446},
        },
        [40220] = { -- Mysterious Device
            [npcKeys.questStarts] = {25571,25773},
        },
        [40253] = { -- Champion Uru'zin
            [npcKeys.questStarts] = {25461,25495},
        },
        [40282] = { -- Kliklak
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{46.59,32.37}}},
            [npcKeys.waypoints] = {[zoneIDs.KELP_THAR_FOREST] = {{{46.59,32.37},{46.46,33.51},{46.44,33.67},{46.33,34.55},{45.82,35.89},{45.47,36.41},{44.80,37.46},{44.73,37.56},{44.54,37.86},{44.04,38.65},{43.93,38.97},{43.92,39.75},{44.27,40.86},{44.72,41.45},{45.23,41.78},{45.43,41.91},{45.72,42.11},{46.46,42.93},{47.28,44.00},{47.77,45.07},{47.91,45.72},{47.96,46.03},{48.29,47.47},{48.56,47.84},{48.73,48.02},{49.54,48.82},{49.74,48.95},{49.97,49.11},{50.73,49.62},{51.00,49.72},{51.47,49.85},{51.80,49.89},{52.23,49.82},{52.77,49.25},{53.54,47.16},{52.90,45.69},{52.49,44.78},{52.07,43.83},{52.00,43.64},{51.67,41.86},{51.72,41.28},{52.16,40.01},{52.39,39.21},{52.38,38.19},{51.89,37.47},{51.11,36.74},{50.56,36.69},{49.99,36.69},{49.83,36.66},{48.56,36.24},{48.44,36.15},{47.55,35.45},{47.17,35.14},{47.01,35.10},{46.39,35.07},{46.06,35.22}}}},
        },
        [40340] = { -- Nemesis
            [npcKeys.waypoints] = {[zoneIDs.MOUNT_HYJAL] = {{{35.60,53.39},{35.93,52.85},{36.09,52.71},{36.25,52.62},{36.38,52.56},{36.75,52.39},{37.01,52.22},{37.39,52.10},{37.74,51.99},{38.40,52.01},{38.58,52.12},{38.86,52.31},{39.07,52.65},{39.16,52.79},{39.32,53.00},{39.55,53.33},{39.70,53.54},{39.81,53.71},{39.89,53.82},{40.14,54.19},{40.28,54.43},{40.30,54.60},{40.32,54.81},{40.23,55.19},{40.20,55.21},{40.10,55.29},{39.87,55.53},{39.81,55.60},{39.61,55.90},{39.53,56.23},{39.35,56.45},{39.17,56.57},{38.87,56.56},{38.50,56.39},{38.43,56.38},{38.08,56.28},{37.63,56.22},{37.56,56.26},{37.41,56.38},{37.36,56.43},{37.29,56.50},{37.15,56.72},{36.94,57.22},{36.92,57.29},{36.83,57.72},{36.65,58.27},{36.63,58.45},{36.76,59.02},{36.79,59.10},{36.80,59.38},{36.81,59.58},{36.97,59.96},{37.06,60.10},{37.26,60.19},{37.59,60.19},{37.83,60.19}}}},
        },
        [40391] = { -- Vol'jin
            [npcKeys.questStarts] = {25480},
        },
        [40434] = { -- Blazing Trainer
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{89.54,58.46}}},
        },
        [40460] = { -- Activated Flameward
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{34.78,52.74},{33.04,64.58},{38.31,63.93},{41.83,56.12},{40.51,53.14}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [40461] = { -- Flameward Activated
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{33.1,64.5},{41.6,56.2},{40.5,53.2},{38.4,63.9}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [40462] = { -- Flameward Defended
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{33.1,64.5},{41.6,56.2},{40.5,53.2},{38.4,63.9}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [40466] = { -- Blackfin
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{54.65,62.95}}},
            [npcKeys.waypoints] = {[zoneIDs.KELP_THAR_FOREST] = {{{54.65,62.95},{54.96,60.99},{55.41,59.08},{55.92,57.20},{56.30,55.69},{56.46,54.82},{56.18,52.90},{55.70,52.02},{55.41,50.99},{55.65,49.00},{55.74,48.54},{56.51,46.90},{56.84,46.54},{58.02,45.76},{58.91,45.40},{59.85,45.29},{60.82,45.29},{61.68,45.56},{62.23,46.06},{62.86,47.68},{62.95,48.35},{63.00,49.91},{62.94,51.93},{62.84,53.21},{62.75,53.87},{62.37,55.71},{61.93,57.31},{61.75,57.92},{61.35,59.17},{60.75,60.99},{60.38,62.06},{60.08,62.85},{59.40,64.60},{58.81,65.78},{58.45,66.29},{57.27,67.24},{56.77,67.26},{55.80,66.79},{55.12,65.89},{54.91,65.22},{54.62,63.13},{54.65,62.95}}}},
        },
        [40544] = { -- Rod of Subjugation 01
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{23.9,55.9}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [40545] = { -- Rod of Subjugation 02
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{25.25,54.8}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [40562] = { -- Twilight Initiate
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{79.17,55.91},{79.2,57.08},{78.91,57.04},{78.75,57.01},{78.82,57.44},{78.74,57.57},{78.81,58.04},{78.57,57.91},{78.59,58.3},{78.83,58.28},{78.93,58.34},{84.54,55.98},{84.37,55.85},{84.34,56.24},{84.26,56.19},{84.18,56.13},{84.18,56.03},{84.26,55.86},{84.1,55.85},{83.97,55.77},{84.15,55.46},{76.54,62.78},{76.03,61.98},{76.11,62.29},{76.28,62.11},{76.17,61.96},{76.02,62.88},{76.59,62.37},{76.35,61.56},{76.67,62.14},{76.35,62.53},{76.03,62.58}}},
        },
        [40564] = { -- Fiery Instructor
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{84.29,59.03},{84.77,59.15},{84.51,58.66},{84.94,58.02},{85.14,59},{85.61,57.82},{84.41,59.75},{85.04,63.81},{84.34,63.58},{81.39,65.28},{78.49,64.28},{80.6,63.09},{83.12,64.84},{81.95,64.75},{81.57,64.15},{78.98,63.44},{82.05,64.1},{83.18,63.84},{83.77,63.28},{83.68,63.83},{80.89,65.51},{82.7,62.54},{85.05,60.51},{84.55,63.17},{81,63.32},{82.91,63.91},{81.3,63.78},{84.55,62.92},{81.23,65.49},{81.17,65.44},{81.89,64.42},{77.77,63.8},{84.27,63.05},{81.28,63.62},{83.26,63.04},{79.34,62.82},{84.33,62.99},{83.08,62.65},{80.23,62.6},{80.97,62.9},{84.34,60.78},{79.33,62.77},{83.8,62.75},{84.23,61.27},{78.24,63.83},{79.97,62.27},{79.6,64.56},{79.98,62.73},{79.26,62.58},{80.98,63.36},{80.56,63.13},{81.24,63.03},{79.94,62.35},{81.31,64.43},{81.51,64.73},{81.21,64.9},{81.14,63.53},{81.21,65.71},{82.05,64.44},{80.86,66.76},{81.87,65.37},{80.9,66.75},{80.49,65.63},{82.71,64.25},{78.81,64.13},{81.02,63.2},{83.74,63.84},{82.91,63.96},{83.18,63.84},{83.08,64.97}}},
        },
        [40589] = { -- Dirge Quikcleave
            [npcKeys.questStarts] = {6610},
            [npcKeys.questEnds] = {6610,6611,6612},
        },
        [40591] = { -- Drag Master Miglen
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{78.07,73.09}}},
        },
        [40639] = { -- Engineer Hexascrub
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {48.99,49.2,phases.VASHJIR_LEGIONS_REST},
                {32.91,69.24,phases.VASHJIR_NORTHERN_GARDEN},
            }},
        },
        [40642] = { -- Captain Taylor
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {49.16,56.98,phases.VASHJIR_LEGIONS_REST},
                {33.23,68.36,phases.VASHJIR_NORTHERN_GARDEN},
                {39.07,78.53,phases.VASHJIR_NAR_SHOLA_TERRACE},
            }},
        },
        [40643] = { -- Admiral Dvorek
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {49.17,56.95,phases.VASHJIR_LEGIONS_REST},
                {33.0,67.8,phases.VASHJIR_NORTHERN_GARDEN},
                {39.11,78.71,phases.VASHJIR_NAR_SHOLA_TERRACE},
            }},
        },
        [40644] = { -- Levia Dreamwaker
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {49.69,57.15,phases.VASHJIR_LEGIONS_REST},
                {33.0,67.2,phases.VASHJIR_NORTHERN_GARDEN},
            }},
        },
        [40645] = { -- Jorlan Trueblade
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{56.99,80.55}}},
        },
        [40690] = { -- Captain Taylor
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{45.05,23.58}}},
        },
        [40707] = { -- Southsea Rowboat
            [npcKeys.questStarts] = {},
        },
        [40712] = { -- Mazoga's Spirit
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{56.74,89.11},{-1,-1}}},
        },
        [40714] = { -- All or Nothing Kill Credit
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{46.27,46.56}}},
        },
        [40726] = { -- Mazzer Stripscrew
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {
                {78.12,73.08,phases.BARGE_AT_PEACE},
                {78.94,75.73,phases.BARGE_UNDER_ATTACK},
            }},
        },
        [40727] = { -- Griznak
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {
                {78.26,73.6,phases.BARGE_AT_PEACE},
                {78.72,76.03,phases.BARGE_UNDER_ATTACK},
            }},
        },
        [40772] = { -- Commander Jarod Shadowsong
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {72.22,74.69,phases.JAROD_NEAR_PORTAL},
                {72.08,74.02,phases.JAROD_MIDDLE_ISLAND},
            }},
        },
        [40793] = { -- Ragnaros
            [npcKeys.questStarts] = {},
        },
        [40833] = { -- Tiala Whitemane
            [npcKeys.questStarts] = {25985},
        },
        [40855] = { -- Slitherfin Eel
            [npcKeys.questStarts] = {25474,27729},
        },
        [40916] = { -- Captain Vilethorn
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {51.19,62.99,phases.VASHJIR_LEGIONS_REST},
                {39.8,54.0,phases.VASHJIR_NORTHERN_GARDEN},
                {39.1,78.7,phases.VASHJIR_NAR_SHOLA_TERRACE},
            }},
        },
        [40917] = { -- Legionnaire Nazgrim
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {51.24,63.02,phases.VASHJIR_LEGIONS_REST},
                {39.5,54.0,phases.VASHJIR_NORTHERN_GARDEN},
                {39.1,78.5,phases.VASHJIR_NAR_SHOLA_TERRACE},
            }},
        },
        [40918] = { -- Fiasco Sizzlegrin
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {51.75,62.5,phases.VASHJIR_LEGIONS_REST},
                {39.4,54.6,phases.VASHJIR_NORTHERN_GARDEN},
            }},
        },
        [40919] = { -- Wavespeaker Tulra
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {51.62,62.75,phases.VASHJIR_LEGIONS_REST},
                {40.6,75.1,phases.WAVESPEAKER_AT_RUINS},
                {39.2,78.6,phases.VASHJIR_NAR_SHOLA_TERRACE},
                {29.6,78.9,phases.VASHJIR_NAR_SHOLA_TERRACE_WEST},
            }},
        },
        [40920] = { -- Elendri Goldenbrow
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {51.27,62.42,phases.VASHJIR_LEGIONS_REST},
                {39.6,53.7,phases.VASHJIR_NORTHERN_GARDEN},
            }},
        },
        [40921] = { -- Bloodguard Toldrek
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{50.4,79.0}}},
        },
        [40922] = { -- Okrog
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{78.74,56.97}}},
            [npcKeys.waypoints] = {[zoneIDs.MOUNT_HYJAL] = {{{78.90,52.56},{78.90,52.82},{78.92,53.09},{78.95,53.35},{79.00,53.60},{79.05,53.86},{79.07,54.12},{79.09,54.38},{79.09,54.65},{79.10,54.91},{79.09,55.18},{79.06,55.44},{79.04,55.70},{79.01,55.96},{78.96,56.22},{78.90,56.46},{78.83,56.71},{78.76,56.95},{78.73,57.21},{78.72,57.48},{78.72,57.66}}}},
        },
        [40934] = { -- Emerald Drake
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{71.86,75.1},{72.55,75.07}}},
        },
        [40957] = { -- Warsong Stockpile
            [npcKeys.questStarts] = {},
        },
        [40963] = { -- Vashj'ir Gardens Credit
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{39.1,57.5}}},
            [npcKeys.zoneID] = zoneIDs.SHIMMERING_EXPANSE,
        },
        [40964] = { -- Vashj'ir Underpass Credit
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{36.2,63}}},
            [npcKeys.zoneID] = zoneIDs.SHIMMERING_EXPANSE,
        },
        [40965] = { -- Vashj'ir Southern Structures Credit
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{40.5,74.4}}},
            [npcKeys.zoneID] = zoneIDs.SHIMMERING_EXPANSE,
        },
        [40987] = { -- Gnash
            [npcKeys.waypoints] = {[zoneIDs.KELP_THAR_FOREST] = {{{51.1,42.3},{52.8,45.7},{54.9,50.3},{56.0,53.9},{56.0,56.5}}}},
        },
        [41005] = { -- Choluna
            [npcKeys.questStarts] = {25663,25664,25807},
        },
        [41006] = { -- Thisalee Crow
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {
                {42.18,45.46,phases.HYJAL_THISALEE_AT_SHRINE},
                {32.79,70.75,phases.HYJAL_THISALEE_AT_SETHRIAS_ROOST},
            }},
        },
        [41050] = { -- Sira'kess Tide Priestess
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {
                {38.98,58.59,phases.SIRA_KESS_AT_GARDEN},
                {37.21,77.53,phases.SIRA_KESS_AT_NAR_SHOLA_TERRACE},
            }},
        },
        [41068] = { -- Mysterious Winged Spirit
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{40.35,44.32}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [41081] = { -- Seadog Fajardo
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{88.48,72.85}}},
        },
        [41084] = { -- Blaithe
            [npcKeys.spawns] = {[616] = {{36.72,33.68},{39.22,37.15},{35.67,42.33},{40.24,37.24},{44.54,38.16},{47.13,40.08},{49.55,41.54}}},
        },
        [41098] = { -- Gnaws
            [npcKeys.spawns] = {},
        },
        [41112] = { -- Marion Wormwing
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{32.81,46.53},{35.59,47.3},{36.53,44.72},{38.33,44.18},{49.77,46.3},{44.66,51.24}}},
        },
        [41185] = { -- Queen Silith
            [npcKeys.waypoints] = {[zoneIDs.STONETALON_MOUNTAINS] = {{{55.37,70.83},{55.59,70.52},{55.90,70.31},{56.21,69.93},{56.43,69.50},{56.72,69.17},{56.99,69.11},{57.28,69.14},{57.56,69.42},{57.86,69.56},{58.29,69.60},{58.47,69.82},{58.60,70.18},{58.64,70.30},{58.48,71.13},{58.30,71.72},{58.21,72.05},{58.05,72.64},{57.93,73.16},{57.82,73.62},{57.71,74.09},{57.41,74.50},{57.11,74.51},{56.84,74.43},{56.44,74.19},{56.04,73.87},{55.87,73.70},{55.66,73.14},{55.60,72.80},{55.40,72.14},{55.36,71.71},{55.37,70.83}}}},
        },
        [41186] = { -- Blue Steel
            [npcKeys.spawns] = {[zoneIDs.STONETALON_MOUNTAINS] = {{60.63,70.79}}},
        },
        [41224] = { -- Aviana's Egg
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{31.71,91.39},{31.29,87.79},{33,97.46},{29.89,77.07},{31.81,81.48},{32.3,76.77},{33.58,90.67},{30.87,78.87},{30.21,80.83},{33.61,94.26}}},
        },
        [41227] = { -- Azsh'ir Infantry
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{41.27,81.36},{41.18,81.36},{41.06,81.44},{41.32,81.44},{40.25,80.67},{39.85,81.52},{41.1,81.35},{40.33,81.03},{38.28,80.7},{38.44,79.32}}},
        },
        [41281] = { -- Injured Assault Volunteer
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{29,79.8},{29.4,77.2},{29.6,77.2},{30,80.6},{30,83},{31.4,79.4},{31.6,79.4},{32.2,84},{32.6,78},{32.8,79.4},{33.6,83.6},{34.4,78.4},{34.4,83.2},{35,79.4},{35.2,83},{35.6,81},{35.8,75.2},{35.8,76},{36.2,77.8},{36.2,79.4},{36.2,79.6},{36.4,83.8},{36.6,77},{36.6,84},{36.8,82.2},{37.2,74.8},{37.4,80},{37.6,82},{37.8,75.2}}},
        },
        [41294] = { -- Undersea Sanctuary
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{46.14,46.64}}},
        },
        [41299] = { -- Oil Drilling Rig
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{84.67,49.42},{85.8,45.04},{88.71,44.6},{91.19,46.62},{90.75,51.28},{87.42,49.7}}},
        },
        [41340] = { -- Private Pollard
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{63.98,59.8}}},
        },
        [41372] = { -- Frostmane Retreat North
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{64.51,54.25}}},
        },
        [41373] = { -- Frostmane Retreat South
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{63.12,57.27}}},
        },
        [41381] = { -- Nordu
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{27.4,55.56}}},
        },
        [41402] = { -- Abandoned Bloodwash Crate
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{62.95,64.27},{60.6,62.86},{61.55,63.07}}},
            [npcKeys.questEnds] = {},
        },
        [41455] = { -- Overseer Idra'kess
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{36.84,79.75}}},
        },
        [41457] = { -- Executioner Verathress
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{57.16,85.17,phases.VASHJIR_NORTHERN_GARDEN}}},
        },
        [41463] = { -- Captured Feralas Sentinel
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{45.24,50.17}}},
        },
        [41476] = { -- Naz'jar Honor Guard
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{46.33,78.57}}},
        },
        [41480] = { -- Arch Druid Hamuul Runetotem
            [npcKeys.questStarts] = {},
        },
        [41522] = { -- Calamoth Ashbeard
            [npcKeys.spawns] = {[zoneIDs.WETLANDS] = {{51.12,9.14}}},
        },
        [41535] = { -- Engineer Hexascrub
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{56.94,80.5}}},
        },
        [41540] = { -- Captain Taylor
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{62.68,49.88}}},
        },
        [41541] = { -- Admiral Dvorek
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{62.72,49.96}}},
        },
        [41548] = { -- Imprisoned Soldier
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{55.45,77.81},{56.07,79.59},{60.1,77.25},{60.46,76.83},{60.59,76.61},{57,77.92},{56.7,80.91},{60.35,73.85},{61.92,74.28},{58.88,79.88},{57.24,81.1},{59.37,79.45},{58.87,79.95},{56.25,77.39}}},
        },
        [41566] = { -- Muckskin Scrounger
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{61.58,86.23},{61.44,85.52},{61.44,84.98},{61.29,84.56},{61.57,86.1},{60.14,86.7},{60,84.56},{60.73,84.06},{60.86,85.18},{60.76,85.9},{61.16,86.56},{61.91,86.71},{61.92,86},{61.78,84.74},{61.46,84.14},{60.92,83.37},{61.8,83.28},{63.15,81.86},{63.32,82.69},{63.46,83.81},{63.43,84.67},{63.73,85.15},{63.91,85.85},{61.14,84.8},{61.37,85.52},{61.33,86.24},{49.31,87.6},{49.02,87.12},{48.73,86.49},{49.43,86.4},{50,87.06},{48.95,84.76},{48.37,83.89},{48.1,86.71},{47.99,85.06},{47.84,85.83},{48.32,86.2},{48.32,81.64},{48.43,82.75},{47.37,84.33},{47.76,81.81},{48.02,83.53},{47.12,82.38},{48.58,84.28},{48.99,84.62},{48.54,84.14},{49.35,84.72},{50.07,84.4},{49.34,83.62},{48.92,81.99},{47.52,83.02},{49.16,82.5},{48.5,84.99},{50.23,83.66},{49.55,85.51}}},
        },
        [41569] = { -- Kvaldir Fleshcarver
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{55.56,84.19},{54.59,85.54},{56.78,87.19},{56.23,85.92},{56.25,89.84},{56.4,88.78},{57.16,89.03},{57.8,88.41},{58.09,85.92},{59.49,86.88},{58.67,84.92},{53.51,85.48},{53.71,86.63},{47.86,77.94},{47.67,80.24},{47.9,79.49},{50.28,80.54},{51.69,82.29},{52.43,83.34},{53.69,82.48},{52.51,83.83},{51.56,86.17},{52.34,84.81},{50.6,84.64},{52.05,83.55},{50.97,84.61},{50.35,85.51}}},
        },
        [41598] = { -- Captain Taylor
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{43.03,37.34}}},
            [npcKeys.questEnds] = {25983,26070,26132},
        },
        [41606] = { -- Kvaldir Seahorror
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{55.64,87.82},{59.3,85.93},{58.68,86.56},{58.23,86.09},{58.67,89.55},{58.05,89.88},{57.26,89.96},{55.29,85.27},{55.55,86.19},{56.9,85.6},{57.38,84.79},{58.2,82.54},{50.32,82.84},{53.47,81.6},{51.11,81.45},{51.89,84.87},{50.66,85.73},{51.2,85.15},{50.3,83.61},{53.24,83.71},{52.34,85.7},{52.03,80.15}}},
        },
        [41636] = { -- Legionnaire Nazgrim
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{42.66,37.82}}},
            [npcKeys.questEnds] = {25984,26071,26133},
        },
        [41638] = { -- Houndmaster Jonathan
            [npcKeys.waypoints] = {[zoneIDs.STONETALON_MOUNTAINS] = {{{32.73,59.56},{33.08,59.49},{33.17,59.63},{33.17,59.68},{33.16,60.16},{33.15,60.24},{33.05,60.75},{33.02,60.85},{32.94,60.93},{32.80,61.04},{32.66,61.11},{32.39,61.18},{32.23,60.89},{32.24,60.76},{32.25,60.65},{32.26,60.50},{32.28,60.18},{32.37,60.03},{32.42,60.00},{32.58,59.89},{32.65,59.76},{32.72,59.58},{32.73,59.57}}}},
        },
        [41639] = { -- Wavespeaker Tulra
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {
                {51.63,60.93,phases.VASHJIR_ERANUK_AT_CAVERN},
                {42.73,37.93,phases.VASHJIR_ERANUK_AT_PROMONTORY_POINT},
            }},
        },
        [41657] = { -- Twilight Candidate
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{32.51,61.57},{32.13,62.64},{32.96,62.54},{32.63,63.62},{32.78,64.97},{32.54,66.07},{33.35,65.83},{34.59,64.6},{35.39,64.47},{35.14,65.56},{34.22,62.44},{34.54,61.33},{35.01,62.31},{28.75,55.76},{28.49,57.58},{28.8,54.53},{30.07,56.71},{29.89,55.49},{26.83,59.55},{26.93,58.42},{29.45,57.47},{29.29,58.7},{29.91,59.64},{30.22,57.91},{27.26,55.25},{28.07,55.04},{26.57,55.66},{27.1,56.53},{28.12,56.53},{27.5,60.3},{26.32,56.77},{27.66,57.51},{27.6,59.14},{28.69,62.22},{28.95,59.85},{28.28,61.18},{28.55,58.81},{33.01,60.63},{31.59,60.64},{32.23,60.44},{29.01,61.04}}},
        },
        [41666] = { -- Engineer Hexascrub
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{55.5,72.9}}},
        },
        [41731] = { -- Overseer Idra'kess
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{57.53,56.34}}},
        },
        [41750] = { -- Legionnaire Nazgrim
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{38.85,31.48}}},
        },
        [41759] = { -- Blood and Thunder Kill Credit
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{46.27,46.56}}},
        },
        [41770] = { -- Fiasco Sizzlegrin
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{50.35,78.99}}},
        },
        [41793] = { -- Legionnaire Nazgrim
            [npcKeys.questStarts] = {},
        },
        [41802] = { -- Wavespeaker Valoren
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{62.6,49.56}}},
        },
        [41810] = { -- Legionnaire Nazgrim
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{60.24,63.7}}},
        },
        [41982] = { -- Quel'Dormir Temple Credit Bunny
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{33.11,76.77}}},
            [npcKeys.zoneID] = zoneIDs.SHIMMERING_EXPANSE,
        },
        [42039] = { -- High Chieftain Cliffwalker
            [npcKeys.spawns] = {
                [zoneIDs.STONETALON_MOUNTAINS] = {
                    {45.04,32.76,phases.STONETALON_CLIFFWALKER_JUSTICE},
                    {45.61,34.21,phases.STONETALON_CLIFFWALKER_RAMP},
                    {45.53,33.71,phases.STONETALON_CLIFFWALKER_GARROSH},
                },
            },
        },
        [42074] = { -- Fathom-Stalker Azjentus
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{46.45,79.27}}},
        },
        [42076] = { -- Lady Naz'jar
            [npcKeys.spawns] = {
                [zoneIDs.SHIMMERING_EXPANSE] = {
                    {29,78.45},
                    {46.38,79.03,phases.VASHJIR_LADY_NAZ_JAR_AT_RIDGE},
                },
            },
        },
        [42077] = { -- Lady Naz'jar
            [npcKeys.spawns] = {
                [zoneIDs.SHIMMERING_EXPANSE] = {
                    {33.13,75.88,phases.VASHJIR_LADY_NAZ_JAR_AT_TEMPLE},
                    {42.51,78.62,phases.VASHJIR_LADY_NAZ_JAR_AT_BRIDGE},
                },
            },
        },
        [42114] = { -- Alliance Sea-Scout
            [npcKeys.questStarts] = {26124},
        },
        [42115] = { -- Hellscream Seadog
            [npcKeys.questStarts] = {26105},
        },
        [42135] = { -- Defend the Bridge Quad Credit
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{38.49,78.6}}},
            [npcKeys.zoneID] = zoneIDs.SHIMMERING_EXPANSE,
        },
        [42169] = { -- Amberstill Raid Controller
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{70.26,49.31}}},
        },
        [42197] = { -- L'ghorek
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{38.67,44.86},{38.75,44.75}}},
            [npcKeys.questEnds] = {26140,26141,26142,26143,26144,26149,26154},
        },
        [42225] = { -- Alliance Prisoner
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{31.5,65.62},{32.04,64.44},{33.6,64.37},{27.49,62.49},{28.55,63.23},{35.18,63.06},{34.29,59.9},{31.26,61},{31.2,59.36},{30.1,60.09},{27.21,60.92},{26.28,55.96},{28.27,56.05},{29.22,57.71},{30.11,55.01},{27.08,54.66}}},
        },
        [42234] = { -- Horde Prisoner
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{31.5,65.62},{32.04,64.44},{33.6,64.37},{27.49,62.49},{28.55,63.23},{35.18,63.06},{34.29,59.9},{31.26,61},{31.2,59.36},{30.1,60.09},{27.21,60.92},{26.28,55.96},{28.27,56.05},{29.22,57.71},{30.11,55.01},{27.08,54.66}}},
        },
        [42288] = { -- Robby Flay
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{50.56,71.89}}},
        },
        [42443] = { -- King Varian Wrynn
            [npcKeys.questStarts] = {26054,27207},
        },
        [42470] = { -- Ma'haat the Indomitable
            [npcKeys.questEnds] = {},
        },
        [42308] = { -- Lieutenant Horatio Laine
            [npcKeys.spawns] = {
                [zoneIDs.WESTFALL] = {
                    {60.04,19.28,phases.HORATIO_JANSEN_STEAD},
                    {56.26,47.48,phases.HORATIO_SENTINEL_HILL},
                },
            },
        },
        [42309] = { -- Stormwind Investigator
            [npcKeys.spawns] = {
                [zoneIDs.WESTFALL] = {
                    {60.04,19.28,phases.HORATIO_SENTINEL_HILL},
                    {60.04,19.28,phases.GRYAN_FP},
                },
            },
        },
        [42317] = { -- High Tinker Mekkatorque
            [npcKeys.questEnds] = {26208,26329,26331,26421,26422,26423,26424,26425},
        },
        [42340] = { -- Rescue Balloon
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{56.65,80.37}}},
            [npcKeys.zoneID] = zoneIDs.SHIMMERING_EXPANSE,
        },
        [42410] = { -- Legionnaire Nazgrim
            [npcKeys.questStarts] = {26221},
            [npcKeys.questEnds] = {26006},
        },
        [42411] = { -- Captain Taylor
            [npcKeys.questEnds] = {26005},
        },
        [42417] = { -- Furlbrow Murder Info 004
            [npcKeys.spawns] = {[zoneIDs.WESTFALL] = {{48.08,19.78}}},
        },
        [42463] = { -- Operation: Gnomeregan Recap Credit
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{33.54,36.52}}},
        },
        [42465] = { -- Therazane
            [npcKeys.questEnds] = {26709,26750,28824,29337},
            [npcKeys.spawns] = {
                [zoneIDs.DEEPHOLM] = {
                    {56.33,12.14,phases.THERAZANE_AT_THRONE_BEFORE_MARCH},
                    {56.33,12.14,phases.NPCS_AT_THERAZANES_THRONE},
                },
            },
        },
        [42466] = { -- Terrath the Steady
            [npcKeys.spawns] = {
                [zoneIDs.DEEPHOLM] = {
                    {39.94,19.39},
                    {33.14,24.23,phases.TERRATH_AT_AEOSERA},
                    {55.34,12.99,phases.NPCS_AT_THERAZANES_THRONE},
                },
            },
        },
        [42471] = { -- Boden the Imposing
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{48.94,40.26}}},
        },
        [42472] = { -- Gorsik the Tumultuous
            [npcKeys.spawns] = {
                [zoneIDs.DEEPHOLM] = {
                    {72.22,54.01},
                    {55.91,12.5,phases.NPCS_AT_THERAZANES_THRONE},
                },
            },
        },
        [42600] = { -- Cairne Bloodhoof
            [npcKeys.questStarts] = {26990,27209},
        },
        [42614] = { -- Terrath the Steady
            [npcKeys.questEnds] = {},
        },
        [42641] = { -- Warlord Krogg
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{59.88,50.39}}},
        },
        [42644] = { -- Smoot
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{55.28,49.89}}},
            [npcKeys.waypoints] = {[zoneIDs.AZSHARA] = {{{56.89,49.26},{56.84,49.43},{56.73,49.64},{56.65,49.86},{56.60,50.03},{56.58,50.19},{56.65,49.94},{56.72,49.70},{56.80,49.46},{56.89,49.26},{56.98,49.33},{57.12,49.49},{57.28,49.60},{57.45,49.67},{57.50,49.69},{57.58,49.85},{57.71,49.96},{57.85,49.79},{58.00,49.65},{58.13,49.77},{58.13,49.89},{58.17,49.70},{58.21,49.45},{58.06,49.42},{57.89,49.49},{57.73,49.60},{57.56,49.61},{57.51,49.57},{57.36,49.53},{57.19,49.47},{57.02,49.38},{56.90,49.20},{56.81,48.97},{56.70,48.75},{56.58,48.56},{56.45,48.37},{56.31,48.22},{56.27,48.18},{56.26,48.20},{56.13,48.38},{56.00,48.57},{55.87,48.75},{55.75,48.94},{55.63,49.14},{55.56,49.25},{55.51,49.32},{55.39,49.51},{55.27,49.71},{55.23,49.78},{55.22,49.92},{55.24,50.18},{55.36,50.32},{55.46,50.12},{55.37,49.90},{55.29,49.89},{55.22,50.09},{55.26,50.35},{55.33,50.60},{55.40,50.84},{55.50,51.06},{55.62,51.24},{55.76,51.41},{55.90,51.58},{56.07,51.64},{56.24,51.74},{56.33,51.86},{56.35,51.71},{56.40,51.45},{56.46,51.20},{56.54,50.96},{56.60,50.71},{56.61,50.45},{56.61,50.18},{56.47,50.20},{56.43,50.24},{56.51,50.46},{56.58,50.69},{56.53,50.95},{56.45,51.19},{56.35,51.41},{56.27,51.64},{56.25,51.72},{56.36,51.93},{56.38,52.02},{56.30,51.87},{56.17,51.70},{56.01,51.58},{55.95,51.54},{55.80,51.40},{55.66,51.24},{55.53,51.07},{55.41,50.87},{55.37,50.70},{55.36,50.67},{55.32,50.41},{55.22,50.20},{55.17,49.94},{55.29,49.81},{55.30,49.81},{55.35,49.89},{55.48,50.06},{55.62,50.22},{55.79,50.31},{55.94,50.19},{55.94,50.18},{55.95,50.15},{56.00,49.94},{56.15,50.09},{56.31,50.21},{56.47,50.23},{56.58,50.42},{56.60,50.68},{56.54,50.93},{56.52,51.04},{56.46,51.29},{56.47,51.30},{56.64,51.34},{56.82,51.36},{57.00,51.39},{57.17,51.41},{57.35,51.39},{57.48,51.23},{57.53,51.07},{57.61,50.88},{57.69,50.80},{57.83,50.93},{57.84,51.18},{57.72,51.36},{57.64,51.37},{57.46,51.38},{57.28,51.36},{57.22,51.36},{57.09,51.39},{56.91,51.38},{56.74,51.39},{56.56,51.36},{56.46,51.27},{56.50,51.15},{56.56,50.90},{56.63,50.65},{56.64,50.52},{56.60,50.36},{56.56,50.21},{56.56,50.20},{56.63,49.95},{56.72,49.73},{56.81,49.49},{56.89,49.36},{57.01,49.42},{57.17,49.54},{57.35,49.58},{57.42,49.60},{57.55,49.79},{57.66,49.99},{57.69,50.03},{57.69,50.05},{57.71,50.31},{57.67,50.56},{57.57,50.78},{57.52,50.94},{57.46,51.03},{57.32,51.19},{57.17,51.31},{56.99,51.36},{56.82,51.34},{56.64,51.30},{56.51,51.27},{56.51,51.16},{56.55,50.90},{56.61,50.65},{56.59,50.38},{56.57,50.19},{56.43,50.18},{56.25,50.18},{56.07,50.17},{55.90,50.22},{55.72,50.26},{55.59,50.21},{55.53,50.12},{55.39,49.95},{55.31,49.88},{55.32,49.89},{55.41,49.98},{55.42,49.99},{55.56,50.15},{55.71,50.29},{55.87,50.23},{56.03,50.16},{56.21,50.17},{56.39,50.20},{56.56,50.21},{56.58,50.21},{56.60,50.05},{56.66,49.80},{56.75,49.57},{56.86,49.36},{56.89,49.29}}}},
        },
        [42680] = { -- Shadowy Figure
            [npcKeys.spawns] = {[zoneIDs.WESTFALL] = {{43.92,69.27}}},
        },
        [42681] = { -- Slain Crew Member
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42682] = { -- Slain Crew Member
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42684] = { -- Stormcaller Mylra
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42716] = { -- Stormbeak
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42736] = { -- Lashtail Hatchling
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{33.73,37.18,phases.LASHTAIL_VISIBLE}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
        },
        [42747] = { -- Slain Crew Member's Spirit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42757] = { -- Slain Crew Member's Spirit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42801] = { -- Mor'norokk the Hateful
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42885] = { -- Twilight Saboteur
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [42938] = { -- Kurtok the Slayer
            [npcKeys.questStarts] = {},
        },
        [42964] = { -- Mor'norokk the Hateful
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [43006] = { -- Rhyanda
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{58.39,35.53}}},
            [npcKeys.questStarts] = {26940,28723},
        },
        [43010] = { -- Delios Silverblade
            [npcKeys.questStarts] = {27091},
            [npcKeys.questEnds] = {8329,27091},
        },
        [43019] = { -- Teldorae
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43082] = { -- First Mate Moody
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{64.01,45.93}}},
            [npcKeys.waypoints] = waypointPresets.ALLIANCE_GUNSHIP,
        },
        [43110] = { -- Gurubashi Arena Challenger
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{46.18,26.95}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
        },
        [43116] = { -- Pebble
            [npcKeys.spawns] = {
                [zoneIDs.DEEPHOLM] = {
                    {34.51,34.68,phases.PEBBLE_AT_KOR},
                    {30.22,46.62,phases.PEBBLE_AT_CRYSTALS},
                },
            },
        },
        [43164] = { -- Sealing the Way 01 Kill Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{27.47,70.3}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
        },
        [43165] = { -- Sealing the Way 02 Kill Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{25.99,70.13}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
        },
        [43166] = { -- Sealing the Way 03 Kill Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{25.62,68.89}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
        },
        [43167] = { -- Sealing the Way 04 Kill Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{27.48,67.49}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
        },
        [43170] = { -- Earthen Geomancer
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{26.16,69.85},{27.3,67.79},{25.97,68.78},{27.31,70.13}}},
        },
        [43190] = { -- Zaela
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {76.57,49.41},
                    {73.77,53.85,phases.DRAGONMAW_PORT_CHAPTER_1},
                },
            },
        },
        [43245] = { -- Zanzil the Outcast
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{61.13,43.34}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
        },
        [43257] = { -- High Priestess Jeklik
            [npcKeys.questStarts] = {},
        },
        [43278] = { -- Ashley Blank
            [npcKeys.questStarts] = {26917},
            [npcKeys.questEnds] = {26910,26917},
        },
        [43300] = { -- Messner
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{47.65,41.8}}},
        },
        [43302] = { -- Danforth
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{28.33,17.01}}},
        },
        [43303] = { -- Krakauer
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{26.22,10.41}}},
        },
        [43305] = { -- Jorgensen
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{33.65,11.65}}},
        },
        [43323] = { -- High Priest Venoxis
            [npcKeys.questStarts] = {},
        },
        [43344] = { -- Berracite
            [npcKeys.waypoints] = {[zoneIDs.DEEPHOLM] = {{{34.26,34.92},{34.49,34.58},{34.58,34.26},{34.60,33.95},{34.52,33.53},{34.52,33.30}}}},
        },
        [43376] = { -- Freewheelin' Juntz Fitztittle
            [npcKeys.waypoints] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{{56.68,53.83},{56.57,54.10},{56.48,54.32},{56.36,54.64},{56.33,55.08},{56.35,55.25},{56.39,55.62},{56.45,56.19},{56.50,56.87},{56.51,56.91},{56.51,57.01},{56.54,57.32},{56.55,57.65},{56.56,57.82},{56.33,57.93}}}},
        },
        [43377] = { -- Ephram "Midriff" Moonfall
            [npcKeys.waypoints] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{{55.62,51.89},{55.80,52.00},{55.97,52.11},{56.00,51.97},{55.92,51.71},{55.87,51.44},{55.87,51.16},{55.92,50.88},{55.98,50.61},{56.05,50.34},{56.19,50.15},{56.34,49.98},{56.51,49.86},{56.69,49.75},{56.87,49.66},{57.06,49.65},{57.25,49.66},{57.44,49.68},{57.62,49.63},{57.81,49.56},{57.97,49.44},{57.96,49.16},{57.93,48.88},{57.91,48.60},{57.84,48.39},{57.66,48.49},{57.48,48.59},{57.30,48.69},{57.13,48.81},{56.96,48.94},{56.79,49.06},{56.62,49.18},{56.45,49.32},{56.29,49.47},{56.16,49.68},{56.09,49.79},{56.02,49.92},{55.88,50.13},{55.77,50.35},{55.70,50.61},{55.63,50.88},{55.53,51.13},{55.43,51.36},{55.32,51.59},{55.14,51.69},{54.95,51.73},{54.79,51.68},{54.76,51.40},{54.66,51.17},{54.61,51.10},{54.49,50.92},{54.42,50.75},{54.32,50.57},{54.23,50.56},{54.41,50.66},{54.44,50.84},{54.45,51.08},{54.46,51.37},{54.48,51.65},{54.58,51.89},{54.63,51.93},{54.82,51.95},{54.94,51.89},{55.12,51.81},{55.30,51.80},{55.49,51.86},{55.59,51.87}}}},
        },
        [43379] = { -- Limiah Whitebranch
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43408] = { -- Aili Greenwillow
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43443] = { -- Keeshan's Riverboat
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{34.43,45.91}}},
            [npcKeys.zoneID] = zoneIDs.REDRIDGE_MOUNTAINS,
        },
        [43454] = { -- "Good-Boy" Bruce
            [npcKeys.questStarts] = {1036},
        },
        [43496] = { -- Darkblaze
            [npcKeys.questStarts] = {},
        },
        [43511] = { -- Deck Stain
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{44.67,92.92},{44.61,93.25},{44.39,92.59},{44.62,93.37},{44.87,93.36},{44.85,92.99},{44.68,93.09},{44.71,92.77},{44.61,92.64}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
        },
        [43513] = { -- Verlok Pillartumbler
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{69.89,24.77},{71.22,24.55},{69.03,24.15},{68.94,23.99},{69.36,23.92},{68.28,24.42},{68.52,25.9},{69.02,23.97},{68.38,25.91},{69.64,24.35},{67.69,24.36},{68.89,24.27},{71.22,24.57},{67.54,24.54},{67.59,24.48},{69.81,24.82},{69.85,24.76},{69.24,24.89},{68.45,25.92},{69.4,24.82},{68.97,25.43},{69.88,24.68},{67.69,24.49},{70.14,24.68},{69.46,24.21},{68.89,24.03},{68.95,24.04},{69.89,24.62},{70.59,24.71},{69.72,24.58},{68.71,24.25},{67.46,24.7},{70.8,24.69},{69.88,24.68},{69,25.34},{69.73,24.78},{68.91,24.46},{71.22,24.54},{70.93,24.69},{69.46,24.77},{68.58,25.8},{67.7,24.38},{68.34,25.84},{67.64,24.55},{69.6,26.39},{68.93,24},{68.68,24.19},{68.97,24.27},{69.13,24.74},{67.46,24.69},{67.49,24.6},{69.38,24.78},{69.35,24.77},{67.83,24},{67.74,24.3},{71.01,24.63},{69.08,24.26},{71.22,24.57},{68.28,25.85},{68.71,24.4},{68.52,25.82},{68.89,25.29},{68.46,25.84},{69.31,24.67},{67.59,24.61},{69.78,24.62}}},
        },
        [43589] = { -- Munitions Dump
            [npcKeys.questStarts] = {},
        },
        [43590] = { -- Blackrock Tower
            [npcKeys.questStarts] = {},
        },
        [43596] = { -- Venture Co. Oil Worker
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{63.14,61.85},{63.05,61.52},{62.57,61.92},{63.56,62.01},{63.44,61.5},{63.29,61.31},{62.6,61.16},{62.56,61.24},{63.06,61.42},{62.82,62.36},{62.85,62.47},{62.75,62.42},{62.7,62.21},{59.65,62.17},{59.64,62.06},{59.7,62.11},{59.69,62.23},{59.65,62.25},{59.61,62.11},{59.61,61.97},{62.49,53.58},{62.48,53.33},{62.4,53.4},{62.22,54.12},{62.29,54.1},{62.98,53.74},{62.51,52.94},{62.15,53.28},{62.02,53.06},{61.96,53.28},{62.41,53.25},{62.36,53.51},{62.37,53.77},{62.39,54.17},{62.23,54.04},{60.55,55.87},{60.46,55.83},{60.58,55.83},{60.53,55.84},{60.47,55.73},{60.44,55.61},{55.24,70.15},{55.09,70.16},{55.15,70.24},{58.1,67.86},{58.08,67.76},{58,66.98},{58.31,67.02},{58.03,67.22},{58.07,67.69},{58.02,67.07},{58.75,67.05},{58.65,66.84},{58.35,67.06},{58.82,67.4},{58.8,67.84},{58.49,66.82},{58.85,67.84},{58.1,67.38},{58.14,67.47},{58.09,67.46},{58.1,67.42},{57.96,67.54},{58.04,67.66},{57.95,67.37},{57.99,67.6},{58.11,67.66},{57.95,67.46},{55.31,70.25},{55.36,70.39},{55.26,70.33},{55.19,70.29},{55.23,70.29},{55.41,70.21},{55.41,70.28},{55.32,70.44},{55.21,70.43},{55.29,70.3},{55.34,70.31},{55.25,70.36},{55.43,70.35},{55.26,70.34},{55.32,70.3},{55.12,70.14}}},
        },
        [43611] = { -- John J. Keeshan
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{77.68,65.51}}},
        },
        [43617] = { -- Lursa
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43623] = { -- Sinking From Within: Grog Credit
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{50.56,91.52}}},
        },
        [43630] = { -- Drek
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43631] = { -- Sinking From Within: Gunpowder Credit
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{46.81,93.73}}},
        },
        [43632] = { -- Sinking From Within: Cannonball Credit
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{44.66,92.77}}},
        },
        [43729] = { -- Finale Credit
            [npcKeys.spawns] = {[zoneIDs.GILNEAS] = {{56.37,16.16}}},
        },
        [43733] = { -- Colonel Troteman
            [npcKeys.spawns] = {
                [zoneIDs.REDRIDGE_MOUNTAINS] = {
                    {77.29,66.29,phases.RAMBO_TEAM_CANYON},
                    {60.66,36.67,phases.RAMBO_TEAM_POST},
                },
            },
        },
        [43766] = { -- Roslyn Paxton
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43769] = { -- Bralla Cloudwing
            [npcKeys.questEnds] = {},
        },
        [43773] = { -- Stella Boomboom
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43778] = { -- Foe Reaper 5000
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {{10.2,82.6}},[zoneIDs.THE_DEADMINES] = {{-1,-1}}},
        },
        [43787] = { -- Blackrock Drake Rider
            [npcKeys.spawns] = {[zoneIDs.REDRIDGE_MOUNTAINS] = {{70.12,45.33}}},
        },
        [43792] = { -- Therazane
            [npcKeys.questStarts] = {26709,28824},
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{49.74,53.35,phases.THERAZANE_AT_TEMPLE}}},
        },
        [43804] = { -- Gorsik the Tumultuous
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{57.34,12.49}}},
            [npcKeys.waypoints] = {[zoneIDs.DEEPHOLM] = {{{59.31,14.23},{59.19,14.11},{59.04,14.00},{58.71,13.80},{58.57,13.64},{58.45,13.52},{58.32,13.42},{58.19,13.33},{58.06,13.22},{57.94,13.10},{57.81,12.98},{57.68,12.87},{57.56,12.75},{57.44,12.62},{57.35,12.52},{57.34,12.50}}}},
        },
        [43835] = { -- Earthcaller Torunscar
            [npcKeys.spawns] = {
                [zoneIDs.DEEPHOLM] = {
                    {49.27,52.81,phases.TORUNSCAR_START},
                    {49.59,52.94,phases.TORUNSCAR_END},
                },
            },
        },
        [43836] = { -- Windspeaker Lorvarius
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{47.97,53.7}}},
        },
        [43837] = { -- High Priestess Lorthuna
            [npcKeys.questStarts] = {},
        },
        [43861] = { -- Sven Yorgen
            [npcKeys.spawns] = {
                [zoneIDs.DUSKWOOD] = {
                    {18.35,58.06,phases.SVEN_YORGEN_VISIBLE},
                },
            },
        },
        [43870] = { -- Seer Beryl
            [npcKeys.questStarts] = {27331,27332,27334,27335,28164,28304,28307,28308,28309,28323},
        },
        [43875] = { -- Asaad
            [npcKeys.spawns] = {[zoneIDs.THE_VORTEX_PINNACLE] = {{29.9,37.89},{-1,-1}}},
        },
        [43877] = { -- Fina Stillgrove
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43878] = { -- Grand Vizier Ertan
            [npcKeys.spawns] = {[zoneIDs.THE_VORTEX_PINNACLE] = {{54.63,45.19},{-1,-1}}},
        },
        [43884] = { -- Osborn Obnoticus
            [npcKeys.spawns] = {
                [zoneIDs.STRANGLETHORN_VALE] = {
                    {56.37,20.3,phases.BERRIN_EMERINE_OSBORN_CAGE},
                    {47.13,10.55,phases.BERRIN_EMERINE_OSBORN_RESCUED},
                },
            },
        },
        [43885] = { -- Emerine Junis
            [npcKeys.spawns] = {
                [zoneIDs.STRANGLETHORN_VALE] = {
                    {56.41,20.3,phases.BERRIN_EMERINE_OSBORN_CAGE},
                    {47.67,10.34,phases.BERRIN_EMERINE_OSBORN_RESCUED},
                },
            },
        },
        [43886] = { -- Berrin Burnquill
            [npcKeys.spawns] = {
                [zoneIDs.STRANGLETHORN_VALE] = {
                    {56.45,20.3,phases.BERRIN_EMERINE_OSBORN_CAGE},
                    {47.98,12.01,phases.BERRIN_EMERINE_OSBORN_RESCUED},
                },
            },
        },
        [43912] = { -- Chief Esquivel
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{66.1,11.73}}},
        },
        [43929] = { -- Jeeves the Merciless
            [npcKeys.questStarts] = {},
            [npcKeys.questEnds] = {},
        },
        [43950] = { -- Lurking Worgen
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{18.57,57.26}}},
        },
        [43979] = { -- Gravin Steelbeard
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43982] = { -- Vernon Soursprye
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43988] = { -- Carthok
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [43994] = { -- Salustred
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44007] = { -- Shep Goldtend
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44009] = { -- Craig Amai
            [npcKeys.questEnds] = {26767},
        },
        [44025] = { -- Therazane
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{63.33,24.95}}},
        },
        [44057] = { -- Riverboat
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{72.99,65.56}}},
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
        },
        [44148] = { -- Stonescale Matriarch
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{50.92,85.28}}},
        },
        [44164] = { -- Sunscale Ravager
            [npcKeys.questStarts] = {},
        },
        [44165] = { -- Sunscale Consort
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS] = {{{64.17,55.87},{64.24,56.02},{64.32,56.18},{64.40,56.33},{64.48,56.49},{64.56,56.64},{64.64,56.80},{64.72,56.96},{64.72,56.96},{64.79,57.11},{64.87,57.26},{64.97,57.38},{65.06,57.45},{65.12,57.51},{65.24,57.61},{65.27,57.79},{65.29,57.99},{65.30,58.18},{65.30,58.23},{65.30,58.27},{65.32,58.47},{65.24,58.62},{65.20,58.68},{65.19,58.71},{65.10,58.86},{65.02,59.01},{64.96,59.18},{64.97,59.33},{64.97,59.38},{64.98,59.58},{64.99,59.77},{65.00,59.97},{65.04,60.15},{65.09,60.33},{65.12,60.40},{65.17,60.56},{65.20,60.64},{65.22,60.73},{65.25,60.92},{65.20,61.10},{65.14,61.27},{65.12,61.30},{65.07,61.44},{65.03,61.53},{64.97,61.70},{64.97,61.88},{65.02,62.06},{65.02,62.06},{65.07,62.24},{65.13,62.41},{65.13,62.60},{65.08,62.71},{65.04,62.79},{65.01,62.86},{65.00,62.89},{64.93,63.05},{64.88,63.15},{64.81,63.14},{64.68,63.11},{64.55,63.10},{64.46,63.10},{64.39,63.09},{64.26,63.08},{64.13,63.06},{64.05,62.96},{64.04,62.76},{64.04,62.57},{64.04,62.37},{64.04,62.34},{64.03,62.18},{64.06,62.01},{64.18,61.92},{64.29,61.82},{64.37,61.76},{64.44,61.71},{64.56,61.64},{64.69,61.62},{64.70,61.61},{64.79,61.60},{64.93,61.60},{65.05,61.62},{65.18,61.65},{65.31,61.69},{65.41,61.72},{65.47,61.74},{65.60,61.78},{65.68,61.73},{65.76,61.65},{65.85,61.57},{65.94,61.48},{66.05,61.37},{66.08,61.21},{66.06,61.02},{66.06,61.00},{66.04,60.83},{66.01,60.64},{65.99,60.44},{65.93,60.28},{65.84,60.13},{65.83,60.11},{65.78,60.03},{65.70,59.88},{65.61,59.73},{65.58,59.68},{65.52,59.55},{65.43,59.40},{65.36,59.27},{65.31,59.18},{65.26,59.09},{65.26,59.09},{65.17,58.94},{65.13,58.84},{65.06,58.68},{64.99,58.51},{64.94,58.35},{64.93,58.32},{64.87,58.14},{64.84,58.05},{64.79,57.92},{64.71,57.78},{64.63,57.66},{64.56,57.50},{64.56,57.48},{64.53,57.30},{64.49,57.11},{64.48,57.03},{64.44,56.84},{64.40,56.65},{64.36,56.47},{64.35,56.42},{64.31,56.24},{64.28,56.15},{64.22,56.02},{64.21,55.97},{64.12,55.77},{64.17,55.87}}}},
        },
        [44170] = { -- Hezrul's Bloodguard
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{39.24,70.23}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_BARRENS] = {{{39.24,70.23},{39.29,70.23},{39.38,70.22},{39.47,70.23},{39.55,70.28},{39.60,70.38},{39.66,70.48},{39.72,70.57},{39.73,70.58},{39.75,70.61},{39.82,70.70},{39.88,70.79},{39.89,70.81},{39.91,70.83},{39.97,70.92},{40.02,70.99},{40.04,71.03},{40.08,71.14},{40.12,71.26},{40.16,71.37},{40.18,71.45},{40.17,71.54},{40.15,71.67},{40.13,71.79},{40.11,71.92},{40.09,72.03},{40.10,72.06},{40.14,72.18},{40.14,72.18},{40.16,72.25},{40.20,72.37},{40.23,72.50},{40.25,72.58},{40.28,72.68},{40.31,72.80},{40.34,72.88},{40.39,72.96},{40.46,73.04},{40.52,73.13},{40.59,73.21},{40.62,73.24},{40.65,73.28},{40.71,73.36},{40.75,73.41},{40.79,73.45},{40.83,73.49},{40.85,73.51},{40.92,73.59},{40.98,73.66},{41.05,73.73},{41.12,73.81},{41.19,73.89},{41.26,73.97},{41.29,74.02},{41.35,74.11},{41.38,74.15},{41.40,74.17},{41.46,74.26},{41.51,74.33},{41.58,74.42},{41.63,74.44},{41.70,74.46},{41.75,74.47},{41.80,74.49},{41.89,74.52},{41.91,74.53},{41.96,74.55},{42.05,74.58},{42.13,74.62},{42.21,74.66},{42.30,74.70},{42.38,74.75},{42.45,74.78},{42.50,74.81},{42.58,74.86},{42.66,74.90},{42.74,74.93},{42.83,74.94},{42.87,74.94},{42.90,74.94},{42.98,74.95},{43.05,74.95},{43.10,74.96},{43.19,74.96},{43.27,74.96},{43.36,74.93},{43.39,74.91},{43.47,74.88},{43.55,74.85},{43.55,74.73},{43.55,74.60},{43.55,74.51},{43.55,74.38},{43.55,74.25},{43.51,74.22},{43.44,74.20},{43.40,74.19},{43.32,74.16},{43.24,74.11},{43.19,74.04},{43.15,73.98},{43.09,73.89},{43.02,73.80},{43.01,73.77},{42.99,73.72},{42.94,73.61},{42.90,73.49},{42.89,73.47},{42.87,73.43},{42.83,73.31},{42.81,73.26},{42.79,73.20},{42.74,73.09},{42.70,72.97},{42.67,72.85},{42.64,72.73},{42.61,72.60},{42.58,72.48},{42.56,72.38},{42.54,72.29},{42.51,72.17},{42.48,72.05},{42.41,71.97},{42.34,71.90},{42.29,71.87},{42.23,71.81},{42.16,71.75},{42.08,71.69},{42.00,71.63},{41.92,71.58},{41.84,71.53},{41.83,71.52},{41.82,71.51},{41.74,71.46},{41.66,71.41},{41.60,71.37},{41.58,71.37},{41.50,71.32},{41.42,71.28},{41.33,71.24},{41.25,71.20},{41.25,71.20},{41.22,71.19},{41.19,71.18},{41.12,71.15},{41.04,71.11},{40.95,71.07},{40.87,71.02},{40.81,70.99},{40.78,70.98},{40.70,70.93},{40.62,70.90},{40.56,71.00},{40.52,71.10},{40.49,71.21},{40.47,71.24},{40.46,71.27},{40.42,71.39},{40.39,71.51},{40.34,71.54},{40.25,71.56},{40.19,71.62},{40.17,71.68},{40.16,71.78},{40.16,71.79},{40.12,71.90},{40.09,71.99},{40.02,72.06},{39.96,72.14},{39.88,72.19},{39.79,72.21},{39.70,72.21},{39.64,72.22},{39.64,72.22},{39.56,72.23},{39.54,72.23},{39.49,72.25},{39.40,72.27},{39.32,72.29},{39.23,72.31},{39.21,72.31},{39.16,72.32},{39.11,72.32},{39.03,72.32},{38.97,72.29},{38.93,72.20},{38.89,72.08},{38.85,72.04},{38.80,72.04},{38.78,72.04},{38.70,72.07},{38.62,72.10},{38.54,72.14},{38.46,72.19},{38.39,72.27},{38.39,72.39},{38.43,72.51},{38.46,72.56},{38.49,72.60},{38.55,72.68},{38.62,72.76},{38.69,72.81},{38.76,72.76},{38.83,72.69},{38.90,72.61},{38.95,72.50},{38.97,72.44},{38.97,72.43},{39.04,72.34},{39.07,72.30},{39.06,72.28},{38.99,72.19},{38.92,72.13},{38.88,72.01},{38.87,71.88},{38.83,71.76},{38.80,71.71},{38.75,71.65},{38.71,71.60},{38.65,71.52},{38.63,71.46},{38.63,71.45},{38.64,71.32},{38.66,71.19},{38.69,71.07},{38.74,70.96},{38.80,70.87},{38.80,70.86},{38.82,70.82},{38.89,70.73},{38.95,70.65},{39.02,70.57},{39.09,70.49},{39.11,70.46},{39.15,70.42},{39.22,70.34},{39.23,70.32},{39.24,70.23}}}},
        },
        [44216] = { -- Bovaal Whitehorn
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{70.4,11.1},{-1,-1}}},
        },
        [44217] = { -- Stone Guard Kurjack
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{68.6,11.5},{-1,-1}}},
            [npcKeys.questEnds] = {26856,26858,26865,26866,26867,28003},
        },
        [44247] = { -- Wulf Hansreim
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{79.15,71.23}}},
        },
        [44269] = { -- Zen'Kiki
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{53.98,53.69}}},
        },
        [44281] = { -- Felsen the Enduring Speak Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{58.45,25.68}}},
        },
        [44282] = { -- Crumbling Depths Entrance Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{58.45,25.68}}},
        },
        [44293] = { -- Anduin Wrynn
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{85.72,31.56}}},
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
        },
        [44348] = { -- Carey Willis
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44354] = { -- Grantor
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44365] = { -- Lady Sylvanas Windrunner
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {57.36,10.19,phases.SILVERPINE_FOREST_HIGH_COMMAND},
                    {44.89,41.64,phases.SILVERPINE_FOREST_SEPULCHER},
                },
            },
        },
        [44367] = { -- Forest Ettin
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{39.15,28.26}}},
            [npcKeys.waypoints] = {[zoneIDs.SILVERPINE_FOREST] = {{{37.02,23.56},{37.25,25.65},{37.34,27.46},{38.23,27.79},{39.09,27.26},{39.26,28.98},{40.27,28.82},{41.55,29.70},{42.76,29.45},{43.70,28.99},{45.18,28.80},{46.17,28.65},{46.53,26.97},{46.88,25.92},{48.35,25.70},{49.27,25.69},{49.67,24.02},{49.18,22.23},{48.48,20.34},{47.68,19.11},{46.90,18.36},{45.68,17.33},{44.43,17.10},{43.40,17.38},{42.39,17.41},{41.09,17.20},{39.96,17.15},{39.26,16.37},{38.36,15.73},{37.50,15.78},{37.32,15.83},{36.53,16.40},{35.96,17.34},{35.50,18.06},{35.85,19.17},{36.18,19.69},{36.49,20.71},{36.76,22.08},{37.02,23.56}}}},
        },
        [44372] = { -- Avalanchion
            [npcKeys.questStarts] = {},
        },
        [44375] = { -- Zeya
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS] = {{48.2,13.09},{-1,-1}}},
        },
        [44378] = { -- Ajaye
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44382] = { -- Veir
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44384] = { -- Sora
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [44387] = { -- Flaming Eradicator
            [npcKeys.spawns] = {[zoneIDs.BLACKFATHOM_DEEPS_MOONSHRINE_SANCTUM] = {{31.83,67.03}},[zoneIDs.BLACKFATHOM_DEEPS] = {{-1,-1}}},
        },
        [44395] = { -- Celestine of the Harvest
            [npcKeys.questStarts] = {27273,28289,82948,88780,88783,88786,88790,88796},
            [npcKeys.questEnds] = {88776,88780,88783,88786,88790},
        },
        [44402] = { -- Auld Stonespire
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{68.17,82.96},{-1,-1}}},
        },
        [44415] = { -- Spirit of Agamaggan
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_KRAUL] = {{20.08,31.56},{-1,-1}}},
        },
        [44447] = { -- Andorhal Deathguard
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{46.29,69.43},{47.33,62.56},{47.93,67.13},{49.14,66.31},{41.92,65.51},{41.89,66.68},{43.51,64.96},{47.93,71.05}}},
        },
        [44453] = { -- Thassarian
            [npcKeys.spawns] = {
                [zoneIDs.WESTERN_PLAGUELANDS] = {
                    {41.06,70.44,phases.THASSARIAN_WPL_TOWER},
                    {39.91,69.47,phases.THASSARIAN_WPL_FP},
                },
            },
        },
        [44466] = { -- Lindsay Ravensun
            [npcKeys.spawns] = {
                [zoneIDs.WESTERN_PLAGUELANDS] = {
                    {47.58,65.56,phases.LINDSAY_WPL_TREE},
                    {40.69,52.00,phases.LINDSAY_WPL_TENT},
                    {49.04,63.71,phases.LINDSAY_WPL_INN},
                },
            },
        },
        [44467] = { -- Lang Loosegrip
            [npcKeys.spawns] = {
                [zoneIDs.WESTERN_PLAGUELANDS] = {
                    {41.26,70.07,phases.THASSARIAN_WPL_TOWER},
                    {40.03,69.24,phases.THASSARIAN_WPL_FP},
                },
            },
        },
        [44490] = { -- Captain Taylor
            [npcKeys.questEnds] = {26193},
        },
        [44540] = { -- Legionnaire Nazgrim
            [npcKeys.questEnds] = {26194},
        },
        [44556] = { -- Murd Doc
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN] = {{63.02,33.26},{-1,-1}}},
        },
        [44560] = { -- B.E Barechus
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN_THE_DORMITORY] = {{65.11,47.02}},[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [44561] = { -- Face
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN_LAUNCH_BAY] = {{23.88,39.05}},[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [44563] = { -- Hann Ibal
            [npcKeys.spawns] = {[zoneIDs.GNOMEREGAN_TINKERS_COURT] = {{34.57,19.78}},[zoneIDs.GNOMEREGAN] = {{-1,-1}}},
        },
        [44629] = { -- Garrosh Hellscream
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{57.28,10.28}}},
        },
        [44633] = { -- Stormcaller Jalara
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{51.39,52.21}}},
        },
        [44637] = { -- Dark Ranger Velonara
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{75.8,81.1},{-1,-1}}},
        },
        [44640] = { -- High Warlord Cromush
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {57.16,10.55,phases.SILVERPINE_FOREST_HIGH_COMMAND},
                    {44.83,41.1,phases.SILVERPINE_FOREST_SEPULCHER},
                },
            },
        },
        [44660] = { -- Dark Ranger Velonara
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_LIBRARY] = {{20.5,15}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44690] = { -- Dark Ranger Velonara
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{59.7,94.1}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44706] = { -- Dark Ranger Velonara
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_CATHEDRAL] = {{48.8,87.5}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44728] = { -- Joseph the Awakened
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{75.8,81.1},{-1,-1}}},
        },
        [44738] = { -- Joseph the Awakened
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_LIBRARY] = {{20.5,15}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44741] = { -- Joseph the Crazed
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{63.4,94.1}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44746] = { -- Joseph the Insane
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_CATHEDRAL] = {{48.8,74.1}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44800] = { -- Dominic
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_LIBRARY] = {{45.1,68.2}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44804] = { -- Dominic
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_ARMORY] = {{66.9,83.7}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44805] = { -- Dominic
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY_CATHEDRAL] = {{49,66}},[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
        },
        [44806] = { -- Fargo Flintlocke
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY] = {
                    {34.79,38.22,phases.FARGO_AT_CATAPULTS},
                    {26.12,47.3,phases.FARGO_AT_DOCKS},
                },
            },
        },
        [44837] = { -- Koristrasza
            [npcKeys.spawns] = {[zoneIDs.RAZORFEN_DOWNS] = {{24.47,23.67},{-1,-1}}},
            [npcKeys.questEnds] = {27009,27024,27029,27062,27063,28024,28025},
        },
        [44910] = { -- Anduin Farm Ambush Quest Tracker
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{43.6,4.62}}},
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
        },
        [44916] = { -- Admiral Hatchet
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {44.02,21.35,phases.SILVERPINE_FOREST_HIGH_COMMAND},
                    {45.81,41.94,phases.SILVERPINE_FOREST_SEPULCHER},
                },
            },
        },
        [44917] = { -- Warlord Torok
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {44,21.29,phases.SILVERPINE_FOREST_HIGH_COMMAND},
                    {45.76,41.92,phases.SILVERPINE_FOREST_SEPULCHER},
                },
            },
            [npcKeys.questStarts] = {27073,27095,27226},
        },
        [44919] = { -- Maztha
            [npcKeys.questEnds] = {},
        },
        [44929] = { -- Tran'rek
            [npcKeys.spawns] = {[zoneIDs.ZUL_FARRAK] = {{58.27,88.65},{-1,-1}}},
        },
        [44938] = { -- Eavesdropping Credit
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{74.91,64.81}}},
        },
        [44951] = { -- Agatha
            [npcKeys.questStarts] = {},
        },
        [44968] = { -- Ricket
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{61.38,26.16}}},
        },
        [44969] = { -- Furgus Warpwood
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_WARPWOOD_QUARTER] = {{11.21,38.89},{-1,-1}}},
        },
        [44971] = { -- "Ambassador" Dagg'thol
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_WARPWOOD_QUARTER] = {{7.06,36.05},{-1,-1}}},
        },
        [44991] = { -- Estulan
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_CAPITAL_GARDENS] = {{90.62,44.84},{-1,-1}}},
        },
        [44996] = { -- Magistrate Henry Maleb
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{65.71,23.79}}},
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
        },
        [44999] = { -- Shen'dralar Watcher
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_CAPITAL_GARDENS] = {{87.41,52.37},{-1,-1}}},
        },
        [45006] = { -- Aggra
            [npcKeys.questStarts] = {},
        },
        [45009] = { -- King Magni Bronzebeard
            [npcKeys.questStarts] = {27122},
        },
        [45034] = { -- Yuldris Smolderfury
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{47.92,49.95}}},
        },
        [45040] = { -- Druid of the Talon
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{71.67,91.91},{-1,-1}}},
        },
        [45042] = { -- Thrall
            [npcKeys.spawns] = {[5416] = {{33.37,50.17}}},
        },
        [45046] = { -- Garrosh Hellscream
            [npcKeys.questStarts] = {27127},
        },
        [45052] = { -- Stonemaul Ogre
            [npcKeys.spawns] = {[zoneIDs.DIRE_MAUL_GORDOK_COMMONS] = {{71.67,91.91},{-1,-1}}},
        },
        [45107] = { -- Eva Sarkhoff
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{46.23,51.66},{-1,-1}}},
        },
        [45108] = { -- Lucien Sarkhoff
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{47.38,51.66},{-1,-1}}},
        },
        [45109] = { -- Weldon Barov
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{46.02,58.46},{-1,-1}}},
        },
        [45110] = { -- Alexi Barov
            [npcKeys.spawns] = {[zoneIDs.SCHOLOMANCE] = {{47.25,58.46},{-1,-1}}},
        },
        [45115] = { -- Twilight Sermon Completion Credit
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{62.56,30.01}}},
        },
        [45148] = { -- Morris Vant
            [npcKeys.questStarts] = {},
        },
        [45149] = { -- Outfitter Mendelev
            [npcKeys.questStarts] = {},
        },
        [45150] = { -- Bree Ironstock
            [npcKeys.questStarts] = {},
        },
        [45151] = { -- High Cleric Alphus
            [npcKeys.questStarts] = {},
        },
        [45152] = { -- Magus Bisp
            [npcKeys.questStarts] = {},
        },
        [45155] = { -- Moldfang
            [npcKeys.questStarts] = {},
        },
        [45165] = { -- Thurman Grant
            [npcKeys.spawns] = {
                [zoneIDs.WESTERN_PLAGUELANDS] = {
                    {42.7,84.11,phases.THURMAN_AT_CHILLWIND},
                    {53.85,64.68,phases.THURMAN_AT_WRITHING},
                    {39.83,69.74,phases.THASSARIAN_WPL_FP}, -- we can use this
                },
            },
        },
        [45172] = { -- Thordun Hammerblow
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {67.66,65.96,phases.THORDUN_AT_TREE},
                    {79.22,78.29,phases.THORDUN_IN_KEEP},
                },
            },
        },
        [45195] = { -- Bloodfang Stalker
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{46.35,47.7},{48.26,55.84},{49.72,53.08},{47.58,55.65},{49.48,54.98},{48.94,52.19},{45.6,53.64},{46.3,55.76},{48.72,53.72},{47.96,54.45},{44.89,47.25},{47.27,53.98},{44.65,50.28},{44.95,51.35},{47.71,51.8},{48.63,50.31},{47.64,50.68},{47.04,49.83},{47.25,48.29},{45.03,49.19},{45.97,49.55},{46.3,51.28},{46.8,52.11}}},
        },
        [45200] = { -- Crusade Commander Eligor Dawnbringer
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME] = {
                    {66.26,86.59},
                    {21.63,80.68,phases.BALNAZZAR_DEAD},
                    {-1,-1},
                },
            },
        },
        [45201] = { -- Master Craftsman Wilhelm
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME] = {
                    {65.23,87.09},
                    {24.1,76.24,phases.BALNAZZAR_DEAD},
                    {-1,-1},
                },
            },
        },
        [45206] = { -- Crusade Commander Korfax
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME_THE_GAUNTLET] = {
                    {67.93,72},
                    {43.89,14.06,phases.RIVENDARE_DEAD},
                    {-1,-1},
                },
            },
        },
        [45212] = { -- Gory
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{54.07,65.78}}},
        },
        [45238] = { -- Harrison Jones
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{64.56,28.6}}},
        },
        [45277] = { -- Feralas Sentinel
            [npcKeys.spawns] ={[zoneIDs.THOUSAND_NEEDLES] = {{42.2,48.3}}},
        },
        [45278] = { -- Freewind Brave
            [npcKeys.spawns] ={[zoneIDs.THOUSAND_NEEDLES] = {{42.2,48.3}}},
        },
        [45297] = { -- Beast-Handler Rustclamp
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [45298] = { -- Mule Driver Ironshod
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [45301] = { -- Korok the Colossus
            [npcKeys.spawns] ={[zoneIDs.RUINS_OF_GILNEAS] = {{50.65,18.03}}},
        },
        [45312] = { -- Deathstalker Commander Belmont
            [npcKeys.spawns] = {
                [zoneIDs.RUINS_OF_GILNEAS] = {
                    {57.46,18.93,phases.RUINS_OF_GILNEAS_FFC},
                    {72.96,30.11,phases.RUINS_OF_GILNEAS_EMBERSTONE},
                    {79.75,75.75,phases.RUINS_OF_GILNEAS_TEMPESTS_REACH},
                },
            },
        },
        [45315] = { -- Forward Commander Onslaught
            [npcKeys.spawns] = {
                [zoneIDs.RUINS_OF_GILNEAS] = {
                    {57.54,18.24,phases.RUINS_OF_GILNEAS_FFC},
                    {57.54,18.24,phases.RUINS_OF_GILNEAS_EMBERSTONE},
                    {57.54,18.24,phases.RUINS_OF_GILNEAS_TEMPESTS_REACH},
                },
            },
            [npcKeys.questStarts] = {27333,27345,27349,27350,27364,27401,27405},
        },
        [45323] = { -- Packmaster Stonebruiser
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME] = {
                    {67.01,89.34},
                    {21.67,79.64,phases.BALNAZZAR_DEAD},
                    {-1,-1},
                },
            },
        },
        [45328] = { -- Packmaster Stonebruiser
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME_THE_GAUNTLET] = {
                    {67.59,82.24},
                    {49.75,22.34,phases.RIVENDARE_DEAD},
                    {-1,-1},
                },
            },
        },
        [45329] = { -- Crusade Commander Eligor Dawnbringer
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME_THE_GAUNTLET] = {
                    {68.05,72.61},
                    {44.8,20.37,phases.RIVENDARE_DEAD},
                    {-1,-1},
                },
            },
        },
        [45330] = { -- Archmage Angela Dosantos
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME_THE_GAUNTLET] = {
                    {67.08,72.54},
                    {42.44,12.62,phases.RIVENDARE_DEAD},
                    {-1,-1},
                },
            },
        },
        [45331] = { -- Master Craftsman Wilhelm
            [npcKeys.spawns] = {
                [zoneIDs.STRATHOLME_THE_GAUNTLET] = {
                    {68.65,73.08},
                    {49.84,18.39,phases.RIVENDARE_DEAD},
                    {-1,-1},
                },
            },
        },
        [45339] = { -- Dark Cleric Cecille
            [npcKeys.questStarts] = {27437,28474,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {27334,28304,28474,88778,88782,88785,88789},
        },
        [45341] = { -- Earthen Ring Emissary
            [npcKeys.questStarts] = {27473,27566},
        },
        [45362] = { -- Earthcaller Yevaa
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {44.21,18.13,phases.UNKNOWN},
                    {44.21,18.13,phases.TWILIGHT_GATE},
                },
            },
        },
        [45400] = { -- Fiona's Caravan
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {8.79,66.57,phases.CARAVAN_THONDRORIL},
                    {35,69.29,phases.CARAVAN_CROWNGUARD},
                    {53.02,53.2,phases.CARAVAN_LIGHTS_SHIELD},
                    {61.61,42.61,phases.CARAVAN_EASTWALL},
                    {50.59,20.09,phases.CARAVAN_NORTHPASS},
                    {73.62,51.87,phases.CARAVAN_LIGHTS_HOPE},
                },
            },
        },
        [45412] = { -- Lord Aurius Rivendare
            [npcKeys.spawns] = {[zoneIDs.STRATHOLME_THE_GAUNTLET] = {{37.21,19.94},{-1,-1}}},
        },
        [45417] = { -- Fiona
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {9.02,66.52,phases.CARAVAN_THONDRORIL},
                    {34.86,69.15,phases.CARAVAN_CROWNGUARD},
                    {52.92,53.06,phases.CARAVAN_LIGHTS_SHIELD},
                    {61.48,42.69,phases.CARAVAN_EASTWALL},
                    {50.54,20.16,phases.CARAVAN_NORTHPASS},
                    {73.71,52.1,phases.CARAVAN_LIGHTS_HOPE},
                },
            },
        },
        [45429] = { -- Tarenar Sunstrike
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {18.37,74.84,phases.CARAVAN_THONDRORIL},
                    {35.26,68.86,phases.CARAVAN_CROWNGUARD},
                    {74.19,53.34,phases.CARAVAN_LIGHTS_SHIELD},
                    {74.19,53.34,phases.CARAVAN_EASTWALL},
                    {73.8,51.99,phases.CARAVAN_LIGHTS_HOPE},
                },
            },
        },
        [45431] = { -- Gidwin Goldbraids
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {4.14,36.01,phases.CARAVAN_THONDRORIL},
                    {34.97,68.55,phases.CARAVAN_CROWNGUARD},
                    {74.36,53.32,phases.CARAVAN_LIGHTS_SHIELD},
                    {74.36,53.32,phases.CARAVAN_EASTWALL},
                    {73.75,52.18,phases.CARAVAN_LIGHTS_HOPE},
                },
            },
        },
        [45451] = { -- Argus Highbeacon
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {35.77,68.57}, -- it's permanent spawn at first tower
                    {53.97,53.63,phases.CARAVAN_LIGHTS_SHIELD},
                    {62.23,42.63,phases.CARAVAN_EASTWALL},
                    {50.49,20.22,phases.CARAVAN_NORTHPASS},
                    {73.96,51.65,phases.CARAVAN_LIGHTS_HOPE},
                },
            },
        },
        [45474] = { -- Deathstalker Commander Belmont
            [npcKeys.spawns] = {[zoneIDs.RUINS_OF_GILNEAS] = {{73.86,34.13}}},
            [npcKeys.questStarts] = {},
        },
        [45574] = { -- Vex'tul
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {52.77,51.35,phases.VEXTUL_SPAWN},
                    {53.97,53.63,phases.VEXTUL_FIONA},
                    {60.61,43.33,phases.CARAVAN_EASTWALL},
                    {52.62,20.48,phases.TARENAR_PLAGUEWOOD},
                },
            },
            [npcKeys.questEnds] = {27449,27481},
        },
        [45593] = { -- High Warlord Cromush
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {51.65,65.96,phases.SILVERPINE_FOREST_FORSAKEN_FRONT},
                },
            },
        },
        [45606] = { -- Lord Godfrey
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{51.36,64.96}}},
        },
        [45631] = { -- High Warlord Cromush
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {51.34,66.3,phases.SILVERPINE_FOREST_FORSAKEN_FRONT_2},
                },
            },
        },
        [45665] = { -- Lady Cozwynn
            [npcKeys.questStarts] = {27491,27497,27503,27609,27639},
        },
        [45669] = { -- Cassius the White
            [npcKeys.questStarts] = {27490,27496,27502,27608,27637},
        },
        [45702] = { -- Erunak Stonespeaker
            [npcKeys.questStarts] = {25180,27540,27546},
        },
        [45708] = { -- Lirastrasza
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{27.6,21.01}}},
        },
        [45729] = { -- Tarenar Sunstrike
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {75.77,52.41,phases.CARAVAN_LIGHTS_SHIELD},
                    {61.57,43.22,phases.CARAVAN_EASTWALL},
                    {50.44,20.13,phases.TARENAR_NORTHPASS},
                    {27.63,21.14,phases.TARENAR_PLAGUEWOOD},
                    {28.54,25.94,phases.TARENAR_SAVED_GIDWIN},
                    {73.8,51.99,phases.TARENAR_SAVED_GIDWIN},
                    {73.8,51.99,phases.TARENAR_GIDWIN_LHC},
                },
            },
        },
        [45730] = { -- Gidwin Goldbraids
            [npcKeys.spawns] = {
                [zoneIDs.EASTERN_PLAGUELANDS] = {
                    {75.75,52.31,phases.CARAVAN_LIGHTS_SHIELD},
                    {28.45,25.9,phases.TARENAR_PLAGUEWOOD},
                    {28.45,25.9,phases.TARENAR_SAVED_GIDWIN},
                    {73.75,52.17,phases.TARENAR_SAVED_GIDWIN},
                    {73.75,52.17,phases.TARENAR_GIDWIN_LHC},
                },
            },
        },
        [45734] = { -- Relios the Relic Keeper
            [npcKeys.waypoints] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{{31.51,43.40},{31.76,43.70},{32.09,44.06},{32.45,44.58},{32.74,44.36},{33.05,44.08},{33.35,43.75},{33.58,43.36},{33.78,42.91},{33.82,42.50},{33.70,42.14},{33.53,41.82},{33.29,41.37}}}},
        },
        [45736] = { -- Deacon Andaal
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{61,44.19}}},
            [npcKeys.waypoints] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{{62.14,43.58},{62.05,43.71},{61.97,43.84},{61.88,43.97},{61.79,44.10},{61.70,44.23},{61.61,44.37},{61.50,44.43},{61.37,44.46},{61.25,44.47},{61.14,44.38},{61.04,44.27},{61.02,44.09},{61.00,43.91},{61.00,43.72},{61.02,43.54},{61.03,43.35},{61.08,43.18},{61.15,43.03},{61.25,42.92},{61.35,42.83},{61.36,42.82}}}},
        },
        [45744] = { -- Ix'lar the Underlord
            [npcKeys.waypoints] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{{61.41,35.60},{61.23,35.60},{61.04,35.60},{60.73,35.59},{60.23,35.57},{60.05,35.55},{59.86,35.48},{59.79,35.45},{59.61,35.37},{59.43,35.28},{59.26,35.18},{59.09,35.06},{58.96,34.87},{58.88,34.62},{58.97,34.37},{59.08,34.15},{59.19,33.93},{59.22,33.88},{59.32,33.65},{59.37,33.39},{59.36,33.11},{59.36,32.83},{59.44,32.58},{59.56,32.37},{59.69,32.16},{59.81,31.95},{59.95,31.77},{60.11,31.64},{60.28,31.52},{60.46,31.42},{60.62,31.35},{60.71,31.35},{60.88,31.48},{61.02,31.66},{61.15,31.86},{61.31,31.96},{61.48,31.87},{61.61,31.77},{61.75,31.64},{61.85,31.52},{62.01,31.38},{62.20,31.38},{62.35,31.52},{62.42,31.71},{62.46,31.96},{62.32,32.15},{62.16,32.30},{62.06,32.52},{62.05,32.80},{62.06,32.91},{62.10,33.07},{62.15,33.19},{62.28,33.38},{62.35,33.64},{62.36,33.92},{62.35,34.18},{62.34,34.20},{62.33,34.48},{62.31,34.76},{62.27,35.03},{62.16,35.26},{62.02,35.44},{61.86,35.56},{61.67,35.59},{61.53,35.59},{61.41,35.60}}}},
        },
        [45757] = { -- Floor Kill Credit
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{64.48,29.87}}},
        },
        [45759] = { -- Southern Kill Credit
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{65.62,33.97},{63.38,33.97}}},
        },
        [45760] = { -- Northern Kill Credit
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{65.62,25.68},{63.38,25.68}}},
        },
        [45765] = { -- Tormented Tomb-Robber
            [npcKeys.questStarts] = {27517},
        },
        [45796] = { -- Master Mathias Shaw
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{36.37,65.95}}},
        },
        [45817] = { -- Hierophant Theodora Mulvadania
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{46.86,66.09}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [45818] = { -- Lexlort
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{44.3,77.8},{-1,-1}}},
        },
        [45820] = { -- Razal'blade
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{40.94,67.13},{-1,-1}}},
        },
        [45821] = { -- Thal'trak Proudtusk
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{36.18,77.28},{-1,-1}}},
        },
        [45823] = { -- High Executioner Nuzrak
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{36.03,77.63},{-1,-1}}},
        },
        [45824] = { -- Thunderheart
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{50.77,52.65}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [45839] = { -- Galamav the Marksman
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{36.71,74.52},{-1,-1}}},
        },
        [45840] = { -- Warlord Goretooth
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{58.08,22.23}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [45849] = { -- Tinkee Steamboil
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{37.36,80.04},{-1,-1}}},
        },
        [45850] = { -- Maxwort Uberglint
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{35.97,80.95},{-1,-1}}},
        },
        [45862] = { -- "Call in the Artillery" Southern Building Bunny
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{41.51,72.6}}},
        },
        [45865] = { -- "Call in the Artillery" Northern Building Bunny
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{39.21,62.05}}},
        },
        [45874] = { -- Schnottz Scout
            [npcKeys.questStarts] = {27541,27549},
        },
        [45878] = { -- Lord Godfrey
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{47.91,72.22}}},
        },
        [45879] = { -- Lord Walden
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{47.91,72.22}}},
        },
        [45880] = { -- Baron Ashbury
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{47.91,72.22}}},
        },
        [45888] = { -- Mayara Brightwing
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{46.86,66.09}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [45890] = { -- Marshal Maxwell
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{58.08,22.23}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [45891] = { -- Oralius
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{36.71,74.52},{-1,-1}}},
        },
        [45892] = { -- Jalinda Sprig
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{36.18,77.28},{-1,-1}}},
        },
        [45894] = { -- Prospector Seymour
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{40.94,67.13},{-1,-1}}},
        },
        [45898] = { -- Kevin Dawson
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{44.3,77.8},{-1,-1}}},
        },
        [45899] = { -- Mountaineer Orfus
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS_SHADOWFORGE_CITY] = {{50.77,52.65}},[zoneIDs.BLACKROCK_DEPTHS] = {{-1,-1}}},
        },
        [45903] = { -- Morgan
            [npcKeys.spawns] = {[zoneIDs.BLACKROCK_DEPTHS] = {{36.03,77.63},{-1,-1}}},
        },
        [45945] = { -- Earthen Ring Emissary
            [npcKeys.questStarts] = {27473,27566},
        },
        [45946] = { -- Earthen Ring Emissary
            [npcKeys.questStarts] = {27566},
        },
        [46019] = { -- Cities in Dust Quest Credit
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{45.32,84.45}}},
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
        },
        [46076] = { -- SI:7 Squad Commander
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{38.93,64.01}}},
        },
        [46077] = { -- Lord Itharius
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{49.96,17.21},{-1,-1}}},
        },
        [46121] = { -- "Up to the Citadel" Kill Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{37.65,65.93}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [46125] = { -- High Warlord Cromush
            [npcKeys.spawns] = {
                [zoneIDs.SILVERPINE_FOREST] = {
                    {45.34,84.34,phases.SILVERPINE_FOREST_BATTLEFRONT},
                },
            },
        },
        [46126] = { -- Turquoise Scarab
            [npcKeys.questStarts] = {27627},
        },
        [46127] = { -- Sapphire Scarab
            [npcKeys.questStarts] = {27627},
        },
        [46128] = { -- Emerald Scarab
            [npcKeys.questStarts] = {27627},
        },
        [46129] = { -- Amethyst Scarab
            [npcKeys.questStarts] = {27627},
        },
        [46174] = { -- Cayden Dunwald
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {45.78,71.73,phases.CAYDEN_START_AMBUSH},
                    {47.88,74.55,phases.CAYDEN_FINISH_AMBUSH},
                },
            },
        },
        [46180] = { -- Ithurian Whitespire
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [46181] = { -- Enchanter Farendin
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [46233] = { -- Olga Runesworn
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{63.93,72.94},{-1,-1}}},
        },
        [46234] = { -- Lead Prospector Durdin
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{63.72,72.54},{-1,-1}}},
        },
        [46235] = { -- Lidia Sunglow
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{63.93,72.94},{-1,-1}}},
        },
        [46236] = { -- High Examiner Tae'thelan Bloodwatcher
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{63.72,72.54},{-1,-1}}},
        },
        [46241] = { -- Aoren Sunglow
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{63.94,72.08},{-1,-1}}},
        },
        [46247] = { -- Kand Sandseeker
            [npcKeys.spawns] = {[zoneIDs.ULDAMAN] = {{63.94,72.08},{-1,-1}}},
        },
        [46254] = { -- Hogger
            [npcKeys.spawns] = {[zoneIDs.THE_STOCKADE] = {{19.4,24.9},{-1,-1}}},
        },
        [46264] = { -- Lord Overheat
            [npcKeys.spawns] = {[zoneIDs.THE_STOCKADE] = {{81.1,48},{-1,-1}}},
        },
        [46268] = { -- Survivor
            [npcKeys.questStarts] = {},
        },
        [46283] = { -- Chamber of Stars Kill Credit
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{64.48,29.87}}},
        },
        [46316] = { -- Gimme Shelter Kill Credit 00
            [npcKeys.spawns] = {},
        },
        [46339] = { -- Warden's Game Controller
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{50.25,54.27}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questStarts] = {},
            [npcKeys.questEnds] = {},
        },
        [46383] = { -- Randolph Moloch
            [npcKeys.spawns] = {[zoneIDs.THE_STOCKADE] = {{50.8,19.1},{-1,-1}}},
        },
        [46398] = { -- Sentinel's Pawn
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{47.88,53.22}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questStarts] = {},
            [npcKeys.questEnds] = {},
        },
        [46409] = { -- Warden Thelwater
            [npcKeys.spawns] = {
                [zoneIDs.THE_STOCKADE] = {
                    {42.3,54,phases.DEADMINES_HOGGER_ALIVE},
                    {22.1,27.2,phases.DEADMINES_HOGGER_DEAD},
                    {-1,-1},
                },
            },
        },
        [46410] = { -- Nurse Lillian
            [npcKeys.spawns] = {[zoneIDs.THE_STOCKADE] = {{56.6,53.8},{-1,-1}}},
        },
        [46417] = { -- Rifle Commander Coe
            [npcKeys.spawns] = {[zoneIDs.THE_STOCKADE] = {{50,58.2},{-1,-1}}},
        },
        [46424] = { -- Priestess Udum'bra
            [npcKeys.questStarts] = {},
        },
        [46425] = { -- Ramkahen Prisoner
            [npcKeys.questEnds] = {},
        },
        [46459] = { -- "Mr. Goldmine's Wild Ride" Kill Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{38.35,93.88}}},
        },
        [46471] = { -- Deathwing
            [npcKeys.spawns] = {
                [zoneIDs.BADLANDS] = {
                    {41.94,43.65,phases.DEATHWING_TELDURIN},
                    {39.3,38.76,phases.DEATHWING_MARTEK},
                },
            },
        },
        [46496] = { -- Tahet
            [npcKeys.questStarts] = {},
        },
        [46513] = { -- Initiate Goldmine
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{38.32,93.92}}},
        },
        [46585] = { -- Eoin Dunwald
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{46,65.55}}},
        },
        [46591] = { -- Colin Thundermar
            [npcKeys.questStarts] = {27754,28216,28294,28369,28860,28864},
        },
        [46599] = { -- Dunwald Hovel, South Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{45.42,60.06}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [46600] = { -- Dunwald Hovel, Northwest Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{46.25,54.08}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [46601] = { -- Dunwald Hovel, East Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{48.4,52.56}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [46612] = { -- Lieutenant Horatio Laine
            [npcKeys.spawns] = {
                [zoneIDs.THE_DEADMINES] = {{30.2,28.5},{-1,-1}},
                [zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {
                    {60.3,38.8,phases.HORATIO_IRONCLAD_COVE},
                },
            },
        },
        [46623] = { -- Gomora the Bloodletter
            [npcKeys.questStarts] = {},
        },
        [46626] = { -- Donnelly Dunwald
            [npcKeys.questStarts] = {},
        },
        [46627] = { -- Eoin Dunwald
            [npcKeys.questEnds] = {},
        },
        [46628] = { -- Flynn Dunwald
            [npcKeys.questStarts] = {},
            [npcKeys.questEnds] = {27651},
        },
        [46654] = { -- Rhea
            [npcKeys.spawns] = {
                [zoneIDs.BADLANDS] = {
                    {66.39,55.49,phases.RHEA_LETHLOR_RAVINE},
                    {21.16,57.77,phases.RHEA_DRAGONS_MOUTH},
                    {18.15,42.51,phases.RHEA_NEW_KARGATH},
                    {15.96,33.39,phases.RHEA_HIDDEN_CLUTCH},
                },
            },
            [npcKeys.questEnds] = {27764,27765,27766,27770,27771,27826,27829,27830,27831,27832,27889,27894,27895,27896,27897},
        },
        [46655] = { -- Rheastrasza
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{66.52,55.57}}},
        },
        [46656] = { -- Jammal'an the Prophet
            [npcKeys.questStarts] = {},
        },
        [46664] = { -- Dr. Hieronymus Blam
            [npcKeys.spawns] = {
                [zoneIDs.BADLANDS] = { -- we'll use these phases
                    {46.82,56.29,phases.RHEA_LETHLOR_RAVINE},
                    {46.82,56.29,phases.RHEA_DRAGONS_MOUTH},
                    --{46.82,56.29,phases.RHEA_NEW_KARGATH},
                    {17.98,30.55,phases.RHEA_HIDDEN_CLUTCH},
                },
            },
        },
        [46682] = { -- Fallen Stonard Warrior
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS] = {{55.4,46.4},{55.4,46.8},{55.8,46.4},{56,46.6},{56.8,45.4},{57,45.6},{57.2,42.2},{57.2,47.8},{57.2,48.6},{57.4,42.8},{57.6,42},{57.6,47.8},{57.8,48.6},{58.2,40.8},{58.2,43},{58.4,40.4},{58.4,44.2},{58.6,42.6},{58.6,43.8},{58.8,40.2},{58.8,41},{58.8,42.4},{59.8,48.4},{60,42.2},{60,46.6},{60.2,42.6},{60.2,45.8},{60.2,48.6},{60.8,46.4},{61,40.4},{61,46.6},{61.2,40.6},{61.2,47.6},{61.4,43.6},{61.4,44.6},{61.6,44.2},{61.6,44.6},{62,46.4},{62.2,42.2},{62.2,42.8},{62.2,46.8},{63.2,41.8},{63.4,41},{63.6,41.2}}},
        },
        [46768] = { -- The Warden
            [npcKeys.questStarts] = {},
        },
        [46769] = { -- The Sentinel
            [npcKeys.questStarts] = {},
        },
        [46855] = { -- Eric "The Swift"
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{20.58,56.08}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [46856] = { -- Baelog
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{20.63,56.2}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [46857] = { -- Olaf
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{20.58,56.3}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [46859] = { -- Kalaran the Annihilator
            [npcKeys.questStarts] = {},
            [npcKeys.waypoints] = {[zoneIDs.BADLANDS] = {{{26.27,45.28},{26.11,44.51},{26.15,43.62},{26.25,42.88},{26.42,42.03},{26.70,41.35},{27.06,40.92},{27.59,40.58},{28.02,40.36},{28.73,40.06},{29.31,39.86},{29.76,39.73},{30.22,39.60},{30.83,39.49},{31.21,39.48},{31.82,39.56},{32.16,40.01},{32.41,40.56},{32.54,41.28},{32.46,42.14},{32.23,43.11},{32.09,43.51},{31.77,44.33},{31.32,44.95},{30.59,45.52},{30.08,45.87},{29.58,46.22},{29.01,46.46},{28.41,46.59},{27.96,46.50},{27.43,46.36},{27.00,46.14},{26.54,45.71},{26.27,45.28}}}},
        },
        [46860] = { -- General Jirakka
            [npcKeys.questStarts] = {},
        },
        [46861] = { -- Nyxondra
            [npcKeys.questStarts] = {},
            [npcKeys.waypoints] = {[zoneIDs.BADLANDS] = {{{9.48,40.11},{9.69,39.81},{9.83,39.58},{9.89,39.37},{10.01,39.03},{10.01,38.75},{9.95,38.31},{9.85,38.01},{9.71,37.75},{9.48,37.52},{9.29,37.42},{9.08,37.39},{8.85,37.43},{8.68,37.56},{8.40,37.75},{8.24,38.05},{8.15,38.31},{8.12,38.61},{8.11,39.05},{8.22,39.48},{8.32,39.72},{8.50,40.00},{8.76,40.20},{9.05,40.31},{9.24,40.29},{9.48,40.11}}}},
        },
        [46889] = { -- Kagtha
            [npcKeys.spawns] = {
                [zoneIDs.THE_DEADMINES] = {{29.29,27.21},{-1,-1}},
                [zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {
                    {64.24,39.86,phases.HORATIO_IRONCLAD_COVE},
                },
            },
        },
        [46901] = { -- Cheerful Goblin Spirit
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{47.34,18.02}}},
        },
        [46902] = { -- Miss Mayhem
            [npcKeys.spawns] = {
                [zoneIDs.THE_DEADMINES] = {{29.62,24.72},{-1,-1}},
                [zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {
                    {61.73,37.61,phases.HORATIO_IRONCLAD_COVE},
                },
            },
        },
        [46906] = { -- Slinky Sharpshiv
            [npcKeys.spawns] = {
                [zoneIDs.THE_DEADMINES] = {{28.81,27.3},{-1,-1}},
                [zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {
                    {57.56,39.66,phases.HORATIO_IRONCLAD_COVE},
                },
            },
        },
        [46915] = { -- Darkflight Soldier
            [npcKeys.questStarts] = {},
        },
        [46916] = { -- Nyxondra's Broodling
            [npcKeys.questStarts] = {},
        },
        [46917] = { -- Darkflight Flameblade
            [npcKeys.questStarts] = {},
        },
        [46920] = { -- Cursed Expedition Member
            [npcKeys.name] = "Cursed Expedition Member",
        },
        [46936] = { -- Wodin the Troll-Servant
            [npcKeys.questEnds] = {27861,27862,27863,27864,27865,27866,27867,27868,28038},
        },
        [46938] = { -- Moldarr
            [npcKeys.questStarts] = {},
        },
        [46939] = { -- Mullan Gryphon
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{58.22,62.52},{62.13,61.74},{56,65.2},{56.2,68.4},{57,74.2},{57.4,68.4},{57.6,68.4},{60,64}}},
        },
        [46962] = { -- Baron Ashbury
            [npcKeys.spawns] = {[zoneIDs.SHADOWFANG_KEEP] = {{67.66,72.68},{-1,-1}}},
        },
        [46963] = { -- Lord Walden
            [npcKeys.spawns] = {[zoneIDs.SHADOWFANG_KEEP_LOWER_OBSERVATORY] = {{47.32,49.56}},[zoneIDs.SHADOWFANG_KEEP] = {{-1,-1}}},
        },
        [46964] = { -- Lord Godfrey
            [npcKeys.spawns] = {[zoneIDs.SHADOWFANG_KEEP_LORD_GOFREYS_CHAMBER] = {{61.35,24.59}},[zoneIDs.SHADOWFANG_KEEP] = {{-1,-1}}},
        },
        [46968] = { -- Mullan Gryphon
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{59.82,62.08},{61.45,62.85},{53.8,68.8},{54,65.6},{54.8,63.2},{56.8,64},{56.8,71.8}}},
        },
        [46969] = { -- Mullan Gryphon
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{54.2,73.16},{57.48,70.39},{55.91,69.84},{53.8,66.6},{58.2,65.2}}},
        },
        [46987] = { -- Vision of Ysera
            [npcKeys.spawns] = {
                [zoneIDs.MOUNT_HYJAL] = {
                    {28.41,29.81,phases.MOUNT_HYJAL_VISION_YSERA_1},
                },
            },
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [46998] = { -- Vision of Ysera
            [npcKeys.spawns] = {
                [zoneIDs.MOUNT_HYJAL] = {
                    {27.03,63.11,phases.MOUNT_HYJAL_VISION_YSERA_2},
                },
            },
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
            [npcKeys.questStarts] = {25830,27874},
        },
        [47002] = { -- Vision of Ysera
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{43.8,45.95}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
        },
        [47004] = { -- Magtoor
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS] = {{26.94,33.57}}},
            [npcKeys.zoneID] = zoneIDs.SWAMP_OF_SORROWS,
        },
        [47006] = { -- Packleader Ivar Bloodfang
            [npcKeys.spawns] = {
                [zoneIDs.SHADOWFANG_KEEP] = {
                    {-1,-1},
                    {62.16,57.2,phases.SHADOWFANG_KEEP_ENTRANCE_A},
                    {59.35,61.13,phases.SHADOWFANG_KEEP_ASHBURY_DEAD_A},
                },
                [zoneIDs.SHADOWFANG_KEEP_THE_WALL_WALK] = {
                    {48.79,82.54,phases.SHADOWFANG_KEEP_SPRINGVALE_DEAD_A},
                },
                [zoneIDs.SHADOWFANG_KEEP_LOWER_OBSERVATORY] = {
                    {60.31,40.93,phases.SHADOWFANG_KEEP_WALDEN_DEAD_A},
                },
                [zoneIDs.SHADOWFANG_KEEP_LORD_GOFREYS_CHAMBER] = {
                    {58.61,53.29,phases.SHADOWFANG_KEEP_GODFREY_DEAD_A},
                },
            },
        },
        [47021] = { -- Amakkar, Jack of All Trades
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{18.87,42.97}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47022] = { -- Gargal, the Behemoth
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{18.96,42.86}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47024] = { -- Jurrix Whitemane
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{18.88,42.74}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47080] = { -- Lucien Tosselwrench
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{26.49,62.3}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47097] = { -- Cloud
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{49.13,57.28},{54.02,46.75},{17.07,65.65},{14.32,53.07},{22.85,47.96},{35.5,50.75},{27.27,38.97},{33.84,36.98},{28.34,58.8},{39.33,59.84},{44.18,35.91}}},
        },
        [47123] = { -- Night Elf Admirer
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{26.38,62.2}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47124] = { -- Human Admirer
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{26.43,62.33}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47125] = { -- Orc Admirer
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{26.26,62.14}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47126] = { -- Blood Elf Admirer
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{26.43,62.5}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47159] = { -- Commander Schnottz
            [npcKeys.questEnds] = {27939,27942,27943,27969},
        },
        [47162] = { -- Glubtok
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES] = {{38,61},{-1,-1}}},
        },
        [47178] = { -- TDDC 3 Canyon Credit
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{41.56,44.15}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
        },
        [47241] = { -- Mullan Gryphon Mount
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{60.87,58.14},{60.63,57.78},{60.82,58.06},{60.78,57.98},{60.7,57.94}}},
        },
        [47246] = { -- Ureda
            [npcKeys.questStarts] = {27400,28458,82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {27277,28300,28458,88778,88782,88785,88789},
        },
        [47255] = { -- Gobbles
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{24.49,64.46}}},
        },
        [47280] = { -- Lunk
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{59.09,57.98}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
        },
        [47293] = { -- Deathstalker Commander Belmont
            [npcKeys.spawns] = {
                [zoneIDs.SHADOWFANG_KEEP] = {
                    {-1,-1},
                    {64.3,57.82,phases.SHADOWFANG_KEEP_ENTRANCE_H},
                    {60.36,57.19,phases.SHADOWFANG_KEEP_ASHBURY_DEAD_H},
                    {27.94,60.61,phases.SHADOWFANG_KEEP_SPRINGVALE_DEAD_H},
                },
                [zoneIDs.SHADOWFANG_KEEP_LOWER_OBSERVATORY] = {
                    {60.19,40.99,phases.SHADOWFANG_KEEP_WALDEN_DEAD_H},
                },
                [zoneIDs.SHADOWFANG_KEEP_LORD_GOFREYS_CHAMBER] = {
                    {58.84,52.46,phases.SHADOWFANG_KEEP_GODFREY_DEAD_H},
                },
            },
        },
        [47296] = { -- Helix Gearbreaker
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES] = {{49.8,90.6},{-1,-1}}},
        },
        [47332] = { -- Lunk
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{41.12,39.5}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
        },
        [47374] = { -- Patch
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {29.58,41.07,phases.TWILIGHT_CARAVAN_AMBUSH_HORDE},
                    {29.31,52.39,phases.GRIM_BATOL_ATTACK_HORDE},
                },
            },
        },
        [47393] = { -- Mountain-Lord Rendan
            [npcKeys.spawns] = {
                [zoneIDs.SEARING_GORGE] = {
                    {39.43,67.87,phases.SEARING_GORGE_NPCS_TOWERS},
                    {40.8,51.65,phases.SEARING_GORGE_CAVE_ASSAULT},
                },
            },
        },
        [47385] = { -- Decrepit Watcher
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{23.65,56.57},{18.93,64.06},{17.37,63.04},{16.25,60.62},{18.16,58.97},{19.73,56.2},{22.56,54.46},{25.38,54.72},{26.14,57.43},{25.39,61.82},{23.83,61.42},{21.14,59.25},{22.4,61.11},{20.03,62.27}}},
        },
        [47422] = { -- Baited Black Drake
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{47.91,59.48},{49.55,63.06},{49.94,64.4},{47.66,61.35},{47.89,61.89},{49.34,63.3},{46.14,64.25},{47.18,60.64},{47.65,58.8},{46.82,61.18}}},
        },
        [47429] = { -- Lunk
            [npcKeys.spawns] = {
                [zoneIDs.SEARING_GORGE] = {
                    {39.83,67.9,phases.LUNK_IRON_SUMMIT},
                    {38.98,26.01,phases.LUNK_THORIUM_POINT},
                },
            },
        },
        [47467] = { -- Brotherhood Flying Machine
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{41.44,55.72}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
        },
        [47484] = { -- Yetimus the Yeti Lord
            [npcKeys.waypoints] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{{47.33,50.21},{47.60,52.35},{47.74,54.12},{47.24,55.72},{46.43,56.85},{45.60,57.74},{44.32,57.47},{42.86,57.13},{41.88,56.26},{41.45,55.05},{41.43,53.60},{41.51,52.12}}}},
        },
        [47493] = { -- Warlord Krogg
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{29.63,40.98}}},
        },
        [47553] = { -- Rasha'krak
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{37.14,42.31}}},
            [npcKeys.waypoints] = {[zoneIDs.SEARING_GORGE] = {{{30.75,43.55},{30.93,43.62},{30.95,43.63},{31.29,43.73},{31.62,43.82},{31.96,43.88},{32.30,43.94},{32.64,43.97},{32.98,43.96},{33.32,43.94},{33.66,43.92},{33.99,43.86},{34.03,43.85},{34.31,43.75},{34.55,43.61},{34.83,43.55},{35.16,43.46},{35.36,43.40},{35.70,43.31},{35.95,43.16},{36.10,42.98},{36.16,42.90},{36.42,42.61},{36.50,42.55},{36.82,42.36},{37.13,42.18},{37.43,42.01},{37.63,41.89},{37.79,41.80},{38.02,41.66},{38.10,41.61},{38.32,41.49},{38.44,41.42},{38.42,41.43},{38.56,41.35},{38.87,41.17},{39.19,40.99},{39.50,40.76},{39.80,40.52},{40.09,40.28},{40.38,40.02},{40.41,39.99},{40.45,39.94},{40.73,39.65},{40.93,39.42},{41.07,39.30},{41.15,39.23},{41.35,39.02},{41.63,38.74},{41.92,38.46},{42.01,38.40},{42.50,37.77},{42.57,37.52}}}},
        },
        [47580] = { -- Lakota Windsong
            [npcKeys.questStarts] = {28125,28127,28136,28139,28140,28143},
        },
        [47581] = { -- Archmage Aranhir Starsinger
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47582] = { -- Erdunor Whitespire
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47584] = { -- Aladrel Whitespire
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47586] = { -- Karabrel Moonlance
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47587] = { -- Archmage Pratt
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47588] = { -- Enchantress Fira
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47589] = { -- Enchantress Herim
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [47591] = { -- Baradin Crocolisk
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{44.78,55.45},{37.67,51.43},{39.25,47.63},{37.78,52.88},{43.23,50.08},{38.76,53.22},{43.35,44.55},{36.99,48.26},{36.89,42.55},{35.6,42.25},{34.66,46.94},{38.67,47.15},{34.98,51.4},{40.58,43.79},{39.3,40.69},{45,42.88},{37.32,49.52},{41.7,53.48},{40.63,48.52},{37.72,55.84},{39.04,45.1},{38.93,42.14},{38.03,42.54},{43.62,44.08},{38.3,43.78}}},
        },
        [47592] = { -- Master Mathias Shaw
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{25.99,38.78}}},
        },
        [47593] = { -- Problim
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{50.94,36.89}}},
            [npcKeys.waypoints] = {[zoneIDs.TOL_BARAD] = {{{50.99,36.90},{50.62,36.77},{49.88,36.47},{49.14,36.16},{48.38,36.02},{47.62,36.01},{46.88,36.30},{46.15,36.62},{45.39,36.75},{44.64,36.56},{43.92,36.17},{43.24,35.66},{42.57,35.10},{41.88,34.61},{41.12,34.48},{40.38,34.72},{39.68,35.18},{39.03,35.78},{38.42,36.48},{37.86,37.25},{37.27,37.97},{36.56,38.40},{35.82,38.71},{35.07,38.94},{34.32,39.09},{33.95,39.17},{33.60,39.21},{33.24,39.31},{32.97,39.53},{32.83,39.81},{32.67,40.47},{32.60,41.13},{32.52,41.94},{32.37,42.69},{32.07,43.40},{31.75,43.99},{31.32,44.57},{30.98,45.05},{30.88,45.84},{30.91,46.52},{30.86,46.64},{30.91,47.78},{31.00,48.92},{31.19,50.02},{31.65,50.93},{32.16,51.80},{32.68,52.64},{33.24,53.42},{33.80,54.20},{34.16,55.20},{34.40,56.28},{34.63,57.38},{35.09,58.26},{35.80,58.68},{36.55,58.87},{37.19,59.48},{37.67,60.37},{37.93,61.44},{38.16,62.53},{38.74,63.24},{39.49,63.25},{40.21,62.87},{40.90,62.36},{41.53,61.72},{42.09,60.93},{42.64,60.14},{43.26,59.47},{43.97,59.05},{44.71,58.76},{45.46,58.59},{46.23,58.60},{46.99,58.69},{47.74,58.85},{48.49,59.10},{49.24,59.14},{49.91,58.58},{50.62,58.22},{51.07,58.28},{51.44,58.36},{52.19,58.53},{52.95,58.67},{53.72,58.75},{54.48,58.86},{55.22,59.13},{55.94,59.43},{56.25,59.40},{56.43,59.42},{56.62,59.40},{56.81,59.37},{57.15,59.32},{57.52,59.17},{57.89,58.99},{58.14,58.88},{58.70,58.78},{59.46,58.69},{60.22,58.74},{60.96,59.04},{61.66,59.46},{62.34,59.21},{62.42,58.09},{62.36,56.95},{62.42,55.81},{62.85,54.87},{63.41,54.10},{63.94,53.29},{64.08,52.17},{64.09,51.02},{63.80,49.98},{63.27,49.16},{62.81,48.25},{62.47,47.20},{62.18,46.15},{61.97,45.05},{61.54,44.18},{60.79,44.00},{60.06,43.69},{59.50,42.93},{59.24,41.86},{59.13,40.72},{59.14,39.58},{59.10,38.44},{58.78,37.41},{58.19,36.69},{57.49,36.23},{56.73,36.10},{55.98,36.29},{55.27,36.72},{54.52,36.85},{53.77,36.71},{53.03,36.42},{52.29,36.66},{51.57,37.03},{50.94,36.89}}}},
        },
        [47595] = { -- Alliance Hunter Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47598] = { -- Alliance Mage Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47599] = { -- Alliance Warrior Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47600] = { -- Alliance Paladin Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47607] = { -- Horde Druid Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47608] = { -- Horde Mage Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47609] = { -- Horde Rogue Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47610] = { -- Horde Shaman Infantry
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.74,20.97},{51.09,20.51},{53.6,20.37},{54.09,29.27},{53.86,24.05},{51.43,24.07},{49.14,24.26},{49.24,26.41},{48.69,29.94},{51.13,28.64},{51.22,30.18},{34.79,64.19},{34.2,72.8},{33.57,68.16},{33.11,66.55},{31.34,69.65},{30.59,69.59},{33.62,74.83},{36.79,72.08},{38.62,69.74},{36.83,66.02},{65.72,70.05},{66.68,71.3},{67.98,68.56},{69.26,64.66},{67.51,64.89},{64.57,61.4},{65.97,60.7},{67.53,62.23},{66.49,63.61},{64.55,66.71},{63.86,63.17},{62.45,66.21}}},
        },
        [47611] = { -- Highbank Lieutenant
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {25.93,38.83,phases.TWILIGHT_CARAVAN_AMBUSH_ALLIANCE},
                    {29.31,52.39,phases.GRIM_BATOL_ATTACK_ALLIANCE},
                },
            },
        },
        [47626] = { -- Admiral Ripsnarl
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {{64.2,39.7}},[zoneIDs.THE_DEADMINES] = {{-1,-1}}},
        },
        [47670] = { -- Belloc Brightblade
            [npcKeys.questEnds] = {27926,27928,27941,28002,28132},
        },
        [47684] = { -- King Phaoris
            [npcKeys.questEnds] = {27628,28112,28134,28520,28533,28555},
        },
        [47739] = { -- "Captain" Cookie
            [npcKeys.spawns] = {[zoneIDs.THE_DEADMINES_IRONCLAD_COVE] = {{60.7,38.8}},[zoneIDs.THE_DEADMINES] = {{-1,-1}}},
        },
        [47788] = { -- Guldor
            [npcKeys.questStarts] = {82949,88782,88785,88789,88800},
            [npcKeys.questEnds] = {88778,88782,88785,88789},
        },
        [47789] = { -- Clerk Horrace Whitesteed
            [npcKeys.waypoints] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{{37.29,63.27},{37.77,63.16},{37.81,63.17},{37.89,63.17},{38.03,63.17},{38.16,63.07},{38.38,62.80},{38.49,62.63},{38.67,62.40},{38.80,62.29},{38.80,62.29},{39.10,62.19},{39.47,62.13},{39.68,62.15},{39.94,62.46},{39.85,62.43},{39.65,62.26},{39.54,62.22},{39.32,62.22},{39.05,62.25},{38.88,62.29},{38.71,62.41},{38.71,62.41},{38.49,62.72},{38.48,62.74},{38.29,63.02},{38.18,63.18},{38.08,63.36},{38.02,63.57},{37.86,63.79},{37.73,63.83},{37.64,63.76},{37.52,63.60},{37.38,63.43},{37.23,63.36},{36.94,63.34},{37.29,63.27}}}},
        },
        [47838] = { -- Shrine 1 Cleansed
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{34.18,35.74}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [47839] = { -- Shrine 2 Cleansed
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{33.59,37.76}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [47840] = { -- Shrine 3 Cleansed
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{34.33,37.75}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [47869] = { -- Johnny Awesome
            [npcKeys.spawns] = {
                [zoneIDs.HILLSBRAD_FOOTHILLS] = {
                    {40.32,59.4,phases.LYDON_AWESOME_CAGE},
                    {36.64,61.04,phases.LYDON_AWESOME_MAIN_BUILDING},
                },
            },
        },
        [47872] = { -- Human Seedling
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{39.36,62.91},{39.01,63.11},{38.68,63.29},{38.5,63.79},{38.41,64.49},{38.64,64.65},{38.77,64.32},{38.92,63.91},{39.13,63.7},{39.39,63.56},{39.6,63.54},{39.85,63.58},{40.02,63.74},{39.9,63.96},{39.73,64.1},{39.48,64.15},{39.25,64.25},{39.15,64.43},{39.19,64.69},{39.38,64.83},{39.68,64.62}}},
        },
        [47874] = { -- Obsidian Lair Pathing Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{49.82,85.49}}},
        },
        [47876] = { -- Obsidian Flower Bunny
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{64.07,78.04}}},
        },
        [47900] = { -- Master Apothecary Lydon
            [npcKeys.spawns] = {
                [zoneIDs.HILLSBRAD_FOOTHILLS] = {
                    {40.35,59.31,phases.LYDON_AWESOME_CAGE},
                    {36.65,61.2,phases.LYDON_AWESOME_MAIN_BUILDING},
                },
            },
        },
        [47905] = { -- Baleflame
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{44.91,90.91}}},
        },
        [47929] = { -- Obsidia
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{45.15,91.73}}},
        },
        [47934] = { -- Karn Cragcare
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [47940] = { -- Commander Schnottz
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{24.41,64.09}}},
        },
        [47970] = { -- Schnottz Guests
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{21.91,64.1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUM,
        },
        [48020] = { -- Master Apothecary Lydon
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{40.23,59.24}}},
        },
        [48021] = { -- Johnny Awesome
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{40.22,59.41}}},
        },
        [48022] = { -- Salhet
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{54.07,58.14}}},
            [npcKeys.zoneID] = zoneIDs.ULDUM,
        },
        [48032] = { -- Seedling Protector
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{48.7,25.07}}},
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.questStarts] = {28219,28220},
        },
        [48039] = { -- Commander Stevens
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{54.37,45.63}}},
        },
        [48042] = { -- Sapling Protector
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{48.34,28.73}}},
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.questStarts] = {28221,28222},
        },
        [48044] = { -- Flourishing Protector
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{49.48,21.79}}},
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.questStarts] = {28224,28228},
        },
        [48051] = { -- Thrall
            [npcKeys.spawns] = {[zoneIDs.THE_MAELSTROM] = {{33.35,50.39}}},
            [npcKeys.zoneID] = zoneIDs.THE_MAELSTROM,
        },
        [48055] = { -- Deedee Dropbolt
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [48061] = { -- 2nd Lieutenant Wansworth
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{53.11,46.41}}},
        },
        [48062] = { -- Staff Sergeant Lazgar
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.72,53.65}}},
        },
        [48066] = { -- Sergeant Parker
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{54.56,46.34}}},
        },
        [48069] = { -- Commander Zanoth
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.02,54.79}}},
        },
        [48070] = { -- Drillmaster Razgoth
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{49.23,53.85}}},
        },
        [48071] = { -- Private Garnoth
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{48.47,55.23}}},
        },
        [48074] = { -- Marshal Fallows
            [npcKeys.spawns] = {[zoneIDs.TOL_BARAD] = {{53.53,47.01}}},
        },
        [48095] = { -- Katrina Lyons
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [48108] = { -- Iso'rath Nightmare Credit
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{48.27,14.49}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
        },
        [48173] = { -- Colin Thundermar
            [npcKeys.questEnds] = {28001,28216,28281,28282},
        },
        [48175] = { -- Low Shaman Blundy
            [npcKeys.questEnds] = {28243,28244},
        },
        [48189] = { -- Firing Squad Kill Credit
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{23.67,60.99}}},
        },
        [48199] = { -- Bloodsnarl Scavenger
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{56.27,63.32},{56.1,62.7}}},
        },
        [48200] = { -- Sunbeam Bunny for Singin' in the Sun
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{52.25,23.49},{51.79,23.86},{52.16,24.86},{52.30,26.30},{50.98,25.39},{50.40,22.16},{51.59,21.49},{51.24,20.31},{48.19,23.64}}},
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
        },
        [48216] = { -- Hurah
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [48218] = { -- Kingslayer Orkus
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{49.57,74.4}}},
            [npcKeys.spawns] = {
                [zoneIDs.HILLSBRAD_FOOTHILLS] = {
                    {49.57,74.4,phases.ORKUS_IN_WATER},
                    {50.03,74.34,phases.ORKUS_ON_LAND},
                },
            },
        },
        [48241] = { -- Flourishing Protector
            [npcKeys.questEnds] = {},
        },
        [48257] = { -- Narkrall Rakeclaw
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{48.7,29.79}}},
        },
        [48264] = { -- Golluck Rockfist
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {44.08,10.54,phases.UNKNOWN},
                    {44.08,10.54,phases.ISORATH_NIGHTMARE},
                },
            },
        },
        [48265] = { -- Lauriel Trueblade
            [npcKeys.spawns] = {
                [zoneIDs.TWILIGHT_HIGHLANDS] = {
                    {44.08,10.54,phases.UNKNOWN},
                    {44.08,10.54,phases.ISORATH_NIGHTMARE},
                },
            },
        },
        [48307] = { -- Colonel Troteman
            [npcKeys.questStarts] = {28311,28312,28313,28317,28318,28319,28321,28322,28326,28327},
        },
        [48312] = { -- High Warlock Xi'lun
            [npcKeys.spawns] = {
                [zoneIDs.BURNING_STEPPES] = {
                    {69.63,42.89,phases.BS_PRE_ASSAULT},
                    {70.16,47.25,phases.BS_POST_ASSAULT},
                },
            },
        },
        [48314] = { -- Dragon-Lord Neeralak
            [npcKeys.spawns] = {
                [zoneIDs.BURNING_STEPPES] = {
                    {70.17,47.3,phases.BS_PRE_ASSAULT},
                    {69.68,42.95,phases.BS_POST_ASSAULT},
                },
            },
        },
        [48322] = { -- Chet the Slime-Breeder
            [npcKeys.questStarts] = {},
        },
        [48346] = { -- John J. Keeshan
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{73.55,67.24}}},
        },
        [48470] = { -- Kingslayer Orkus
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{29.22,83.98}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
        },
        [48490] = { -- Greater Colossus
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{66.61,41.73}}},
        },
        [48499] = { -- Fanny Thundermar
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{34.96,31.14}}},
        },
        [48503] = { -- Kingslayer Orkus
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{27.35,87.34}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
        },
        [48513] = { -- Revi Ramrod
            [npcKeys.questEnds] = {},
        },
        [48515] = { -- Stormpike Battle Master
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{27.20,86.37}}},
        },
        [48529] = { -- Lunar Crystal
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{39.51,24.3},{39.81,23.65},{40.11,23}}},
        },
        [48533] = { -- Enormous Gyreworm
            [npcKeys.spawns] = {},
        },
        [48568] = { -- Eitrigg
            [npcKeys.questEnds] = {28428,28429,28430,28431,28434,28440,28441},
        },
        [48569] = { -- Eitrigg
            [npcKeys.questStarts] = {28443,28444,28445,28450,28451,28452,28453,28455,28456},
        },
        [48836] = { -- Tamed Seahorse
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{40.59,74.94}}},
        },
        [48866] = { -- Tamed Seahorse
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{40.59,74.94}}},
        },
        [48878] = { -- Stormpike Soldier
            [npcKeys.questStarts] = {},
        },
        [48880] = { -- Captain Iceheart
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{49.40,46.73}}},
            [npcKeys.questStarts] = {},
        },
        [48887] = { -- Darwishi
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49000] = { -- Patch
            [npcKeys.questStarts] = {28593,28594,28595},
        },
        [48901] = { -- Tamed Seahorse
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{29.51,79.01}}},
        },
        [48922] = { -- Instructor Rufus
            [npcKeys.questStarts] = {},
        },
        [48923] = { -- Drill Sergeant Magnus
            [npcKeys.questStarts] = {},
        },
        [48924] = { -- Captain Crudbeard
            [npcKeys.questStarts] = {},
        },
        [49035] = { -- Lilith
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{50.2,40.31}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
            [npcKeys.questStarts] = {28604},
        },
        [49116] = { -- Stormpike Engineer
            [npcKeys.questStarts] = {},
        },
        [49135] = { -- Skyshredder Turret
            [npcKeys.waypoints] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{{81.33,80.21},{80.80,80.52},{80.19,80.70},{79.57,80.72},{79.01,80.58},{78.49,80.22},{78.05,79.59},{77.70,78.84},{77.44,78.08},{77.23,77.28},{77.11,76.40},{77.15,75.46},{77.32,74.70},{77.58,73.89},{77.90,73.09},{78.26,72.37},{78.64,71.72},{79.10,71.10},{79.59,70.56},{80.11,70.20},{80.66,70.09},{81.24,70.24},{81.82,70.57},{82.35,71.05},{82.78,71.61},{83.14,72.31},{83.45,73.12},{83.68,73.98},{83.80,74.80},{83.79,75.67},{83.65,76.54},{83.40,77.36},{83.08,78.11},{82.70,78.74},{82.24,79.35},{81.74,79.87},{81.33,80.21}}}},
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{77.17,75.31}}},
        },
        [49177] = { -- Winterfall Earth Totem
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{66.12,49.23},{66.52,48.21},{65.9,47.83},{67.04,47.7}}},
        },
        [49178] = { -- Grolnar the Berserk
            [npcKeys.questStarts] = {28656},
        },
        [49212] = { -- Skyshredder Bomb Controller Bunny
            [npcKeys.waypoints] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{{81.33,80.21},{80.80,80.52},{80.19,80.70},{79.57,80.72},{79.01,80.58},{78.49,80.22},{78.05,79.59},{77.70,78.84},{77.44,78.08},{77.23,77.28},{77.11,76.40},{77.15,75.46},{77.32,74.70},{77.58,73.89},{77.90,73.09},{78.26,72.37},{78.64,71.72},{79.10,71.10},{79.59,70.56},{80.11,70.20},{80.66,70.09},{81.24,70.24},{81.82,70.57},{82.35,71.05},{82.78,71.61},{83.14,72.31},{83.45,73.12},{83.68,73.98},{83.80,74.80},{83.79,75.67},{83.65,76.54},{83.40,77.36},{83.08,78.11},{82.70,78.74},{82.24,79.35},{81.74,79.87},{81.33,80.21}}}},
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{77.17,75.31}}},
        },
        [49230] = { -- Marshal Redpath
            [npcKeys.questStarts] = {},
        },
        [49231] = { -- Valdred Moray
            [npcKeys.questStarts] = {},
        },
        [49235] = { -- Icewhomp
            [npcKeys.questStarts] = {28656},
        },
        [49264] = { -- Bloodvenom
            [npcKeys.questStarts] = {},
        },
        [49265] = { -- Teracula
            [npcKeys.questStarts] = {},
        },
        [49266] = { -- Infernus
            [npcKeys.questStarts] = {},
        },
        [49268] = { -- D-1000
            [npcKeys.questStarts] = {},
        },
        [49336] = { -- Jez Goodgrind
            [npcKeys.questEnds] = {28642},
        },
        [49340] = { -- Scarlet Corpse
            [npcKeys.questStarts] = {},
        },
        [49358] = { -- Kurdran Wildhammer
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{55.25,17.33}}},
        },
        [49378] = { -- Patch
            [npcKeys.waypoints] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{{81.33,80.21},{80.80,80.52},{80.19,80.70},{79.57,80.72},{79.01,80.58},{78.49,80.22},{78.05,79.59},{77.70,78.84},{77.44,78.08},{77.23,77.28},{77.11,76.40},{77.15,75.46},{77.32,74.70},{77.58,73.89},{77.90,73.09},{78.26,72.37},{78.64,71.72},{79.10,71.10},{79.59,70.56},{80.11,70.20},{80.66,70.09},{81.24,70.24},{81.82,70.57},{82.35,71.05},{82.78,71.61},{83.14,72.31},{83.45,73.12},{83.68,73.98},{83.80,74.80},{83.79,75.67},{83.65,76.54},{83.40,77.36},{83.08,78.11},{82.70,78.74},{82.24,79.35},{81.74,79.87},{81.33,80.21}}}},
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{77.17,75.31}}},
            [npcKeys.questStarts] = {28591,28593,28594,28595},
        },
        [49379] = { -- Ticker
            [npcKeys.waypoints] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{{81.33,80.21},{80.80,80.52},{80.19,80.70},{79.57,80.72},{79.01,80.58},{78.49,80.22},{78.05,79.59},{77.70,78.84},{77.44,78.08},{77.23,77.28},{77.11,76.40},{77.15,75.46},{77.32,74.70},{77.58,73.89},{77.90,73.09},{78.26,72.37},{78.64,71.72},{79.10,71.10},{79.59,70.56},{80.11,70.20},{80.66,70.09},{81.24,70.24},{81.82,70.57},{82.35,71.05},{82.78,71.61},{83.14,72.31},{83.45,73.12},{83.68,73.98},{83.80,74.80},{83.79,75.67},{83.65,76.54},{83.40,77.36},{83.08,78.11},{82.70,78.74},{82.24,79.35},{81.74,79.87},{81.33,80.21}}}},
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{77.17,75.31}}},
        },
        [49395] = { -- Shannon Lamb
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49408] = { -- Farah Tamina
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49431] = { -- Ansel Tunsleworth
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49444] = { -- Pip Quickwit
            [npcKeys.name] = "Pip Quickwit",
        },
        [49456] = { -- Pip's Mole Machine
            [npcKeys.name] = "Pip's Mole Machine",
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{26.74,26.92}}},
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [49476] = { -- Pip Quickwit
            [npcKeys.name] = "Pip Quickwit",
            [npcKeys.questStarts] = {28735,28737,28738,28740,28741},
        },
        [49748] = { -- Hero's Herald
            [npcKeys.questStarts] = {},
        },
        [49537] = { -- Jeb Guthrie
            [npcKeys.questStarts] = {28638,28745,28782},
        },
        [49577] = { -- Baird Darkfeather
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49593] = { -- Tarm Deepgale
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49600] = { -- Matthew Churchill
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49689] = { -- Bonnie Hennigan
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49749] = { -- Priestess Cocoa Anderson
            [npcKeys.questStarts] = {5628},
        },
        [49750] = { -- Warchief's Herald
            [npcKeys.questEnds] = {82949,82985,82989,88798,88800,88801},
        },
        [49755] = { -- Zay'hana
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49767] = { -- Rukh Zumtarg
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49803] = { -- Kennen
            [npcKeys.npcFlags] = npcFlags.STABLEMASTER,
        },
        [49893] = { -- Lisa McKeever
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{51.62,72.38}}},
        },
        [49943] = { -- Itesh
            [npcKeys.spawns] = {[zoneIDs.THE_VORTEX_PINNACLE] = {{54.46,15.84},{-1,-1}}},
        },
        [49956] = { -- Pebble
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{63.07,20.88}}},
        },
        [50044] = { -- Hell-Hoot
            [npcKeys.waypoints] = {[zoneIDs.WINTERSPRING] = {{{52.40,32.36},{52.05,33.17},{52.01,33.64},{52.45,35.00},{52.67,36.69},{52.88,36.25},{52.88,36.25},{52.41,35.52},{52.41,35.52},{53.00,34.77},{52.81,34.79}}}},
            [npcKeys.questStarts] = {},
        },
        [50081] = { -- Morthis Whisperwing
            [npcKeys.questStarts] = {},
        },
        [50258] = { -- Frostmaul Tumbler
            [npcKeys.questStarts] = {28656},
        },
        [50482] = { -- Marith Lazuria
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{72.6,34.4}}},
        },
        [50815] = { -- Skarr
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{32.94,52.17},{-1,-1}}},
        },
        [50959] = { -- Karkin
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{37.43,35.36},{-1,-1}}},
        },
        [51314] = { -- Azshara Event Credit
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{32.89,84.09}}},
        },
        [51665] = { -- Celestine of the Harvest
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{32.04,50.51}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [51677] = { -- Winterspring Cub
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{46.59,17.7}}},
            [npcKeys.zoneID] = zoneIDs.WINTERSPRING,
            [npcKeys.questStarts] = {29039,29051,29052,29053},
        },
        [51934] = { -- Gretchen Fenlow
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{32.35,50.88}}},
        },
        [51988] = { -- Orphan Matron Nightingale
            [npcKeys.questStarts] = {1468},
        },
        [51989] = { -- Orphan Matron Battlewail
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{57.96,57.62}}},
            [npcKeys.questStarts] = {172},
        },
        [52059] = { -- High Priestess Kilnara
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{47.88,20.97},{-1,-1}}},
        },
        [52064] = { -- Keira
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{32.09,50.59}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [52122] = { -- Druid of the Flame
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{67.47,35.23},{-1,-1}}},
        },
        [52134] = { -- Commander Jarod Shadowsong
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.65,85.53},{-1,-1}}},
        },
        [52135] = { -- Malfurion Stormrage
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{47.02,91.37},{-1,-1}}},
            [npcKeys.questEnds] = {29203,29218,29311},
        },
        [52165] = { -- Sludge Beast
            [npcKeys.questStarts] = {},
        },
        [52189] = { -- Rental Chopper
            [npcKeys.spawns] = {[zoneIDs.WESTFALL] = {{57.78,53.06},{57.71,53.28}}},
            [npcKeys.zoneID] = zoneIDs.WESTFALL,
        },
        [52209] = { -- Chief Caravan Kodo
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{50.16,57.2}}},
            [npcKeys.zoneID] = zoneIDs.THE_BARRENS,
        },
        [52224] = { -- Jungle Serpent
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{44.2,54.6},{44.6,55.2},{44.6,55.6},{44.8,53.6},{45,53.2},{45.4,50.4},{45.8,50.8},{46,49},{46,53.2},{46.2,49.8},{46.4,51.8},{46.4,54},{46.6,54.2},{47,50.2},{47,52.6},{47,57.4},{47.4,59.2},{47.6,52},{47.6,58.6},{47.8,51.2},{47.8,53.2},{48,57},{48.6,57.4},{49.2,58},{49.4,58.6},{49.6,58.2},{49.6,59},{50.2,59.6},{50.6,56.8},{50.8,54.2},{51,56.2},{51.2,51.4},{51.2,51.6},{51.2,65.8},{51.2,67},{51.4,65.2},{51.4,69.4},{51.4,70},{51.6,66.4},{51.6,68.6},{51.8,50},{51.8,59.8},{51.8,60.8},{51.8,63.8},{51.8,64.8},{51.8,66.8},{52,52.6},{52,57.2},{52,59.4},{52.2,54.6},{52.4,52},{52.4,53.8},{52.4,56},{52.4,68.4},{52.6,54.6},{52.6,56.2},{52.6,69.2},{52.6,69.8},{52.8,57.6},{52.8,67.4},{52.8,68},{53,56.6},{53,59.4},{53,60.2},{53,64.2},{53.4,50.2},{53.4,65.2},{53.6,60.4},{53.8,60.8},{54,57.4},{54,57.6},{54,67.2},{54.2,64.4},{54.2,65},{54.2,65.8},{54.4,53.4},{54.4,53.6},{54.4,58.6},{54.4,62.4},{54.4,62.6},{54.6,29},{54.6,57.4},{54.6,59.2},{54.6,60.4},{54.6,62.4},{54.6,64},{54.8,61},{54.8,63.4},{55,31.6},{55,52.4},{55.2,39},{55.2,40.4},{55.2,58.4},{55.4,32.6},{55.4,33.8},{55.6,57.4},{55.6,58.4},{55.8,59},{56,29},{56,33.8},{56,40.2},{56.2,38},{56.4,39},{56.6,33.2},{56.8,55.8},{57,35.4},{57,36.8},{57,39.6},{57.2,32.4},{57.2,39.2},{57.2,40.8},{57.2,56.6},{57.2,70.4},{57.4,33.8},{57.4,45},{57.4,58.4},{57.4,58.6},{57.4,71},{57.6,31.8},{57.6,40.8},{57.6,71},{57.8,34.2},{57.8,45},{57.8,64.8},{58,35.2},{58,59.8},{58,68.4},{58,68.6},{58.2,37.8},{58.2,42.4},{58.2,58.8},{58.2,65.6},{58.4,33},{58.4,36.2},{58.4,37},{58.4,54.2},{58.4,57.4},{58.4,57.8},{58.4,71.8},{58.6,33.6},{58.6,41.2},{58.6,42.8},{58.6,68.4},{58.6,71.6},{58.8,35.4},{58.8,55.8},{58.8,70},{58.8,71},{58.8,72.8},{59,35.6},{59,37.8},{59,40.4},{59,41.8},{59,56.6},{59,57.6},{59.2,37.4},{59.2,55.4},{59.4,32.4},{59.4,38.6},{59.4,58.6},{59.6,35},{59.6,57.6},{59.8,34.4},{59.8,37.4},{59.8,40.6},{59.8,41.6},{60,36.4},{60,39},{60,47.4},{60,55.6},{60.2,40.4},{60.2,57.4},{60.2,71.4},{60.4,53.8},{60.4,55.4},{60.4,72.2},{60.6,38},{60.6,53.8},{60.6,65.6},{60.8,40},{60.8,57.4},{61,36.2},{61,37.4},{61.2,39.4},{61.2,41},{61.2,55.2},{61.2,71.6},{61.4,41.8},{61.4,55.8},{61.6,36.4},{61.6,42},{61.8,36.6},{61.8,69.4},{62,44.2},{62,44.6},{62,69.6},{62.2,38.8},{62.4,40},{62.4,42.6},{62.4,66.6},{62.4,73.8},{62.6,41.4},{62.6,42.8},{62.6,66.8},{62.6,72.8},{62.8,73.6},{63,42.4},{63.2,35.2},{63.2,36},{63.2,37.6},{63.2,46},{63.6,34.6},{63.6,46.2},{64,34.2},{64.2,36.6},{64.2,46.8},{64.4,35.8},{64.4,38.4},{64.8,35.4},{64.8,35.6},{64.8,36.8},{64.8,38.4},{64.8,39.2},{64.8,43.2},{65.2,43.8},{65.4,45},{65.6,36.4},{65.6,36.6},{65.6,44.8},{65.6,48.8},{66,38.4},{66,42},{66.2,42.6},{66.2,43.6},{66.4,39},{66.4,45.6},{66.4,53.6},{66.6,38.6},{66.6,53.6},{67,46.4},{67.2,37.6}}},
        },
        [52225] = { -- Fort Livingston Adventurer
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{46.42,54.01},{47.66,52.02},{49,58.2},{50,59.8},{50.2,54},{50.4,56.6},{50.6,56.6},{50.6,65.2},{51,50.4},{51.6,63},{52,61.2},{52,65.4},{52,69.2},{52.4,52},{52.4,54.4},{52.6,54.6},{52.8,57.6},{52.8,64.2},{53,70.8},{53.8,60.4},{53.8,60.6},{54.2,62.4},{54.4,59.4},{54.6,53.6},{55.4,65.2},{55.6,67.6},{55.8,67.4},{56.2,53.8},{56.2,58.8},{56.44,50.79},{56.8,55.8},{57,62.8},{57,72.2},{57.2,67.4},{57.2,70.4},{57.4,60},{57.4,67.6},{57.4,71.4},{57.6,60},{58,65.2},{58,68.4},{58,70.8},{58.2,68.6},{58.8,58.4},{58.8,58.6},{58.8,70},{58.8,72.8},{59,56.8},{59.4,55.4},{60,55.6},{60,68.8},{60,71},{60,72.6},{60.2,55.4},{60.2,61.8},{60.4,58},{60.4,72},{60.6,65.8},{60.6,71.8},{61.2,55.2},{61.2,64},{61.8,66.6},{62,68.2},{62.4,73.4},{62.4,74.6},{62.6,67.6},{63,73},{63.2,71.8},{63.6,69.4}}},
        },
        [52314] = { -- Master Caravan Kodo
            [npcKeys.spawns] = {[zoneIDs.THE_BARRENS] = {{47.81,39.53}}},
        },
        [52341] = { -- Druid of the Talon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{42.93,81.58},{43.53,81.55},{-1,-1}}},
        },
        [52374] = { -- Panther Cub
            [npcKeys.questStarts] = {29267,29268},
        },
        [52383] = { -- Nemesis
            [npcKeys.questStarts] = {},
        },
        [52392] = { -- Gurubashi Master Chef
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{57.59,27.47},{-1,-1}}},
        },
        [52399] = { -- Galenges
            [npcKeys.questStarts] = {},
        },
        [52405] = { -- Mor'Lek the Dismantler
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{47.88,20.97},{-1,-1}}},
        },
        [52408] = { -- Coridormi
            [npcKeys.questStarts] = {29132,30095},
        },
        [52422] = { -- Kaulema the Mover
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{54.07,62.89},{-1,-1}}},
        },
        [52442] = { -- Florawing Hive Queen
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{31.57,39.15},{-1,-1}}},
        },
        [52444] = { -- Thisalee Crow
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{42.53,59.69},{-1,-1}}},
        },
        [52467] = { -- Rayne Feathersong
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{48.52,86.25},{-1,-1}}},
        },
        [52476] = { -- Keeper Krothis
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.93,87.35},{-1,-1}}},
        },
        [52477] = { -- Tholo Whitehoof
            [npcKeys.spawns] = {
                [zoneIDs.MOLTEN_FRONT] = {
                    {51.56,85.5,phases.MOLTEN_FRONT_CAMP},
                    {41.56,61.36,phases.MOLTEN_FRONT_DRUIDS},
                    {35.98,58.96,phases.MOLTEN_FRONT_DRUIDS},
                    {66.25,66.16,phases.MOLTEN_FRONT_WARDENS},
                    {-1,-1},
                },
            },
        },
        [52478] = { -- Anren Shadowseeker
            [npcKeys.spawns] = {
                [zoneIDs.MOLTEN_FRONT] = {
                    {51.3,85.81,phases.MOLTEN_FRONT_CAMP},
                    {41.91,61.54,phases.MOLTEN_FRONT_DRUIDS},
                    {35.8,59.35,phases.MOLTEN_FRONT_DRUIDS},
                    {66.03,66.09,phases.MOLTEN_FRONT_WARDENS},
                    {-1,-1},
                },
            },
        },
        [52488] = { -- Elderlimb
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{43.79,89},{-1,-1}}},
        },
        [52489] = { -- Avrilla
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.65,87.26},{-1,-1}}},
            [npcKeys.questStarts] = {29249,29255,29257,29299},
        },
        [52490] = { -- Skylord Omnuron
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{43.03,80.6},{-1,-1}}},
        },
        [52491] = { -- Morthis Whisperwing
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{34.5,56.21},{-1,-1}}},
        },
        [52492] = { -- Choluna
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{36.3,56.34},{-1,-1}}},
        },
        [52493] = { -- Captain Saynna Stormrunner
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{47.58,90.56},{-1,-1}}},
        },
        [52494] = { -- Marin Bladewing
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{64.88,67.28},{-1,-1}}},
        },
        [52495] = { -- Shalis Darkhunter
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{51.72,81.63},{-1,-1}}},
        },
        [52500] = { -- Hyjal Defender
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.65,82.6},{48.26,82.55},{45.29,76.53},{51.11,70.1},{45.82,68.61},{47.54,76.28},{45.53,67.99},{45.07,72.65},{47.42,72.18},{44.82,72.38},{52.97,76.67},{48.68,65.58},{53.19,78.35},{46.59,73.4},{43.9,72.82},{50.08,77.81},{51.75,76.93},{47.08,72.31},{44.11,76.28},{52.27,73.3},{53.08,77.18},{50.74,70.1},{42.3,72.32},{49.89,75.87},{50.98,69.76},{46.89,62.11},{52.92,77.74},{52.36,75.75},{42.99,73.21},{50.67,70.16},{52.83,76.35},{48.06,74.25},{46.01,74.01},{47.58,72.83},{50.04,77.85},{52.29,78.23},{52.1,76.28},{46.65,73.44},{54.65,75.52},{52.27,77.18},{-1,-1}}},
        },
        [52501] = { -- Hyjal Druid
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.08,81.59},{47.67,74.7},{48.51,83},{49.44,86.05},{49.19,85.07},{46.82,86.52},{46.36,85.09},{46.71,82.9},{48.15,82.99},{47.79,64.17},{45.48,68.65},{50.95,70.56},{45.23,73.8},{51.28,78.29},{-1,-1}}},
        },
        [52502] = { -- Hyjal Marksman
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.39,82.92},{48.87,82.93},{45.46,75.03},{45.92,81.38},{44.06,79.69},{49.16,74.28},{47.72,74},{52.65,76.17},{47.64,73.65},{49.65,74.86},{45.33,73.23},{44.7,78.25},{51.58,76.58},{52.2,77.29},{51.48,76.34},{45.5,74.27},{-1,-1}}},
        },
        [52503] = { -- Charred Vanquisher
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{52.82,77.47},{54.9,79.53},{44.5,72.32},{52.7,76.08},{48.77,65.5},{47.96,78.7},{50.94,69.91},{47.26,72.05},{45.73,67.99},{51.36,72.62},{49.35,68.12},{47.78,80.45},{42.2,68.83},{42.79,64.41},{48.78,64.69},{50.08,62.1},{54.68,73.86},{44.27,65.33},{47.24,86.59},{48.39,72.94},{47.64,74.22},{47.76,84.82},{47.99,79.23},{47.9,81.15},{51.89,77.38},{47.55,73.98},{-1,-1}}},
        },
        [52504] = { -- Charred Soldier
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.45,83.53},{48.18,82.3},{46.95,86.53},{46.94,67.64},{50.55,78.16},{46.18,77.45},{47.87,78.74},{42.52,72.38},{47.48,80},{47.45,71.81},{48.37,75.89},{47.74,76.73},{47.06,81.1},{47.05,73.8},{51.63,77.34},{47.6,61.54},{55.6,72.99},{43.55,71.43},{46.07,69.38},{51.12,69.56},{53.46,78.4},{43.21,71.25},{52.47,72.46},{43.94,66.14},{45.78,62.99},{45.98,63},{48.16,61.56},{43.3,66.56},{49.12,62.94},{45.38,64.21},{45.54,64.93},{53.96,75.89},{54.22,68.58},{44.86,62.75},{45.54,66.53},{50.29,65.3},{43.21,66.92},{48.33,62.32},{45.36,64.62},{47.84,62.02},{47.04,59.98},{49.71,61.84},{47.18,79.56},{47.87,78.74},{49.02,78.98},{47.9,81.46},{49.19,79.72},{50.2,77.54},{43.74,73.12},{51.91,77.49},{47.55,76.89},{48.28,77.44},{46.95,73.43},{50.98,77.14},{49.73,78.87},{53.2,77.04},{-1,-1}}},
        },
        [52531] = { -- Fire Attacker Portal
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{42.15,68.55},{47.23,67.32},{52.61,70.66},{50.11,61.82},{54.16,66.39},{47.23,57.79},{42.6,64.18},{51.59,64.77},{56.43,72.57},{55.24,78.23},{-1,-1}}},
        },
        [52548] = { -- Gertrude Fenlow
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{32.21,50.76}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [52552] = { -- Molten Behemoth
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{40.89,57.83},{-1,-1}}},
        },
        [52633] = { -- Lava Burster
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{45.38,54.13},{-1,-1}}},
        },
        [52648] = { -- Cinderweb Creeper
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{60.34,61.56},{59.22,61.24},{61.18,64.03},{-1,-1}}},
        },
        [52649] = { -- Millagazor
            [npcKeys.questStarts] = {},
        },
        [52654] = { -- Bwemba
            [npcKeys.questStarts] = {29100,29102,29158},
        },
        [52660] = { -- Fire Hawk
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{19.76,33.19},{30.84,30.21},{20.32,40.21},{20.69,29.09},{29.61,47.12},{26.24,38.31},{28.92,34.68},{24.45,51.54},{21.35,52.29},{20.85,51.48},{-1,-1}}},
        },
        [52661] = { -- Druid of the Flame
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{60.27,62.39},{68.1,56.15},{63,53.1},{64.2,44.2},{64.6,37.1},{69.3,34.1},{72.8,40.1},{76.5,40.9},{-1,-1}}},
        },
        [52683] = { -- Pyrelord
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{33.68,67.51},{-1,-1}}},
        },
        [52704] = { -- Cinderweb Egg
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{64.62,61.14},{-1,-1}}},
        },
        [52705] = { -- Captured Hyjal Druid
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{66.03,48.25},{-1,-1}}},
        },
        [52749] = { -- Pyrachnis
            [npcKeys.questStarts] = {},
        },
        [52751] = { -- Cinderweb Cocoon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{64.57,46.04},{61.32,47.69},{64.37,56.29},{65.08,53.99},{63.34,41.52},{61.1,40.75},{59.39,58.79},{-1,-1}}},
        },
        [52766] = { -- Lylagar
            [npcKeys.questStarts] = {},
        },
        [52767] = { -- Vol'jin
            [npcKeys.spawns] = {[5287] = {{41.03,73.13,phases.VOLJIN_BOOTY_BAY}}},
        },
        [52771] = { -- Lava Burster
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{42.51,68.12},{-1,-1}}},
        },
        [52783] = { -- Cinderweb Cocoon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{65.87,48.26},{61,56.4},{62.99,39.97},{67.42,53.53},{69.08,46.19},{-1,-1}}},
        },
        [52784] = { -- Cinderweb Cocoon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{59.16,60.95},{-1,-1}}},
        },
        [52793] = { -- Ysera
            [npcKeys.spawns] = {
                [zoneIDs.MOUNT_HYJAL] = {
                    {60.3,29.86,phases.THRALL_AGGRA_PROPOSAL},
                },
            },
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
            [npcKeys.questStarts] = {},
        },
        [52822] = { -- Zen'Vorka
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.78,90.46},{-1,-1}}},
        },
        [52823] = { -- Theresa Barkskin
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{57.74,49.51},{-1,-1}}},
        },
        [52824] = { -- General Taldris Moonfall
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{45.59,85.83},{-1,-1}}},
        },
        [52825] = { -- Theresa Barkskin
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{52.99,90.96},{-1,-1}}},
        },
        [52834] = { -- Wounded Hyjal Defender
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{42.94,66.38},{42.95,72.14},{45.32,68.24},{45.84,64.86},{44.66,70.85},{49.64,72.23},{49.58,69.36},{43.41,69.89},{45.32,75.42},{44.08,67.1},{48.23,73.53},{51.46,76.78},{47.03,76.26},{47.18,78.83},{45.82,73.56},{52.57,78.7},{46.3,66.84},{45.27,76.33},{55.19,74.41},{53.87,68.93},{50.67,72.99},{52.35,65.44},{46.92,60.56},{54.51,75.66},{52.25,68.85},{50.46,65.53},{43.44,74.85},{52,74.2},{53.47,71.28},{50.23,76.5},{48.19,66.05},{55.53,74.21},{53.1,80.01},{-1,-1}}},
        },
        [52835] = { -- Tarecgosa
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{34.39,25.18}}},
            [npcKeys.questEnds] = {29193},
        },
        [52838] = { -- Arch Druid Hamuul Runetotem
            [npcKeys.spawns] = {
                [zoneIDs.MOUNT_HYJAL] = {
                    {27.08,54.49,phases.MOUNT_HYJAL_INVASION_START},
                    {19.53,37.81,phases.MOUNT_HYJAL_INVASION_START},
                    {27.17,62.6,phases.MOUNT_HYJAL_INVASION_SANCTUARY_ATTACK},
                    {27.11,62.82,phases.MOUNT_HYJAL_INVASION_SANCTUARY},
                },
            },
        },
        [52844] = { -- Captain Saynna Stormrunner
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{26.8,62.15}}},
        },
        [52845] = { -- Malfurion Stormrage
            [npcKeys.spawns] = {
                [zoneIDs.MOUNT_HYJAL] = {
                    {27.36,55.23,phases.MOUNT_HYJAL_INVASION_START},
                    {26.98,62.91,phases.MOUNT_HYJAL_INVASION_SANCTUARY_ATTACK},
                    {27.02,62.69,phases.MOUNT_HYJAL_INVASION_SANCTUARY},
                },
            },
        },
        [52854] = { -- Captain Saynna Stormrunner
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{54.67,70.88},{-1,-1}}},
        },
        [52871] = { -- Druid of the Flame
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{74.62,43.41},{69.03,41.58},{67.71,35.23},{68.02,33.18},{70.83,43.45},{73.03,40.95},{70.01,39.42},{70.24,33.19},{-1,-1}}},
        },
        [52872] = { -- Druid of the Flame
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{71.6,37},{69.45,38.74},{66.4,43.54},{74.62,43.41},{71.55,39.31},{70.01,39.42},{68.12,42.16},{72.14,41.01},{-1,-1}}},
        },
        [52884] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{61.39,48.46},{-1,-1}}},
        },
        [52885] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{66.35,52.19},{-1,-1}}},
        },
        [52886] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{68.86,58.33},{-1,-1}}},
        },
        [52887] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{64.16,66.06},{-1,-1}}},
        },
        [52888] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{60.54,60.02},{-1,-1}}},
        },
        [52889] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{61.61,52.94},{-1,-1}}},
        },
        [52890] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{64.73,59.3},{-1,-1}}},
        },
        [52903] = { -- Tholo Whitehoof
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{41.66,56.36}}},
        },
        [52904] = { -- Anren Shadowseeker
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{41.66,56.33}}},
        },
        [52906] = { -- Elderlimb
            [npcKeys.spawns] = {
                [zoneIDs.MOUNT_HYJAL] = {
                    {33.94,57.54,phases.MOUNT_HYJAL_INVASION_SANCTUARY_ATTACK},
                    {26,61.3,phases.MOUNT_HYJAL_INVASION_SANCTUARY},
                },
            },
        },
        [52907] = { -- Thisalee Crow
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{24.47,55.74}}},
        },
        [52911] = { -- [DND] Follow that Cat
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{77.34,69}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
        },
        [52980] = { -- Kil'karil
            [npcKeys.waypoints] = {[zoneIDs.STRANGLETHORN_VALE] = {{{64.64,39.72},{64.72,40.22},{64.75,40.48},{64.69,40.06},{64.58,39.61},{64.24,39.65},{63.90,39.74},{63.57,39.84},{63.24,39.99},{62.93,40.20},{62.79,40.28}}}},
        },
        [53009] = { -- Kalecgos
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{46.53,35.51}}},
        },
        [52921] = { -- Deldren Ravenelm
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{66.1,63.93},{-1,-1}}},
        },
        [52935] = { -- Marin Bladewing
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{55.07,70.42},{-1,-1}}},
        },
        [52953] = { -- Deldren Ravenelm
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{66.01,63.83},{-1,-1}}},
        },
        [52954] = { -- Shalis Darkhunter
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{65.82,63.85},{-1,-1}}},
        },
        [52955] = { -- Sira Moonwarden
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{55.19,69.69},{-1,-1}}},
        },
        [52964] = { -- Turak Runetotem
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{54.54,70.53},{-1,-1}}},
        },
        [52965] = { -- Keeper Taldros
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{55.35,68.07},{-1,-1}}},
        },
        [52981] = { -- Cinderweb Spinner
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{59.08,57.93},{65.26,54.16},{65.47,57.76},{66.14,56.06},{64.6,56.95},{61.43,43.51},{61.24,41.88},{61.58,41.2},{72.09,50.58},{71.98,51.85},{61.96,41.39},{61.62,59.83},{59.97,51.42},{60.62,50.76},{71.45,50.63},{68.66,46.91},{61.41,46.65},{60.15,49.93},{64.52,45.09},{62.66,43.72},{62.82,42.5},{65.11,58.81},{67.68,54.35},{66.11,53.06},{64.56,57.99},{66.95,53},{65.54,56.14},{66.58,53.68},{66.11,58.64},{67.19,54.81},{67.27,57},{67.73,56},{67.04,58.16},{65.46,53.18},{66.63,56.55},{66.18,56.89},{66.51,55.97},{65.15,49.28},{64.96,55.02},{64.61,55.26},{65.16,47.48},{-1,-1}}},
        },
        [52989] = { -- Cinderweb Cocoon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{61.87,41.2},{67.86,45.33},{66.32,57.15},{63.08,42.33},{60.07,51.16},{61.74,43.56},{66.31,56.57},{-1,-1}}},
        },
        [52990] = { -- Captured Hyjal Druid
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{65.42,54.95},{60.06,51.43},{59.96,50.47},{60.49,50.3},{67.49,56.59},{-1,-1}}},
        },
        [52991] = { -- Cinderweb Cocoon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{61.45,41.27},{60.46,50.48},{-1,-1}}},
        },
        [52992] = { -- Cinderweb Cocoon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{65.97,57.39},{62.35,42.11},{-1,-1}}},
        },
        [52998] = { -- Pyrelord
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{66.34,65.16},{-1,-1}}},
        },
        [53023] = { -- Bloodslayer Zala
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{30.73,47.08},{-1,-1}}},
        },
        [53024] = { -- Bloodslayer Zala
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{30.56,47.29},{-1,-1}}},
        },
        [53043] = { -- Briney Boltcutter
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{30.5,50.92},{-1,-1}}},
        },
        [53055] = { -- Ancient Charscale
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.35,19.55},{-1,-1}}},
        },
        [53056] = { -- Shalis Darkhunter
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{57.51,49.47},{-1,-1}}},
        },
        [53074] = { -- Witherbranch
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{47.75,27.61},{-1,-1}}},
        },
        [53079] = { -- Crimson Lasher
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{53.53,90.74},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MOLTEN_FRONT,
            [npcKeys.questStarts] = {29254},
        },
        [53080] = { -- Captain Irontree
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{45.63,86.15},{-1,-1}}},
        },
        [53085] = { -- Flamewaker Sentinel
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{45.04,46.1},{53.83,50.79},{54.24,49.75},{51.38,56.19},{47.33,63.71},{49.21,68.79},{51.64,65.11},{47.47,65.07},{-1,-1}}},
        },
        [53090] = { -- Lava Burster
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{55.2,54.42},{49.36,60.01},{46.68,61.75},{55.4,47.65},{53.21,51.75},{53.92,42.39},{53.18,43.3},{-1,-1}}},
        },
        [53093] = { -- Flamewaker Shaman
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{53.02,54.38},{51.3,62.81},{46.13,49.66},{53.99,56.6},{50.43,68.07},{-1,-1}}},
        },
        [53107] = { -- Smothervine
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{54.42,70.63},{50.81,68.38},{50.06,64.45},{49.18,65.2},{-1,-1}}},
        },
        [53112] = { -- Subterranean Magma Worm
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{52.36,52.25},{49.99,46.46},{55.54,55.48},{47.12,48.81},{-1,-1}}},
        },
        [53131] = { -- Lava Bubbles
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{52.36,52.25},{49.99,46.46},{55.54,55.48},{47.12,48.81},{-1,-1}}},
        },
        [53143] = { -- Flamewaker Hunter
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{52.89,56.97},{53.27,52.5},{41.62,46.56},{48.83,66.7},{49.23,66.19},{-1,-1}}},
        },
        [53149] = { -- Kalecgos
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{30.93,24.01}}},
        },
        [53151] = { -- Overseer Blingbang
            [npcKeys.spawns] = {[zoneIDs.ZUL_GURUB] = {{30.81,47.56},{-1,-1}}},
        },
        [53152] = { -- Charhound
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.4,65.97},{-1,-1}}},
        },
        [53190] = { -- Northwestern Pool Credit
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{21.48,29.82},{-1,-1}}},
        },
        [53191] = { -- Northeastern Pool Credit
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{30.83,31.55},{-1,-1}}},
        },
        [53192] = { -- Central Pool Credit
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{23.11,41.55},{-1,-1}}},
        },
        [53196] = { -- Ricket
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.76,90.16},{-1,-1}}},
        },
        [53214] = { -- Damek Bloombeard
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{46.92,89.99},{-1,-1}}},
        },
        [53215] = { -- Kalecgos
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{23.17,30.79}}},
        },
        [53217] = { -- Windcaller Voramus
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{43.01,80.2},{-1,-1}}},
        },
        [53233] = { -- Anren Shadowseeker
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{51.9,30.93},{-1,-1}}},
        },
        [53234] = { -- Anren Shadowseeker
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{42.62,59.91},{-1,-1}}},
        },
        [53240] = { -- Emberspit Scorpion
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{55,69},{47.24,53.26},{41.18,60.14},{54.33,61.61},{47.7,54.61},{50.11,57.35},{55.5,69.8},{49.28,68.68},{47.65,61.84},{40.41,55.57},{42.66,65.26},{-1,-1}}},
        },
        [53243] = { -- Injured Druid of the Talon
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{26.81,43.07},{22.29,31.37},{26.38,36.46},{32.62,31.12},{21,23.32},{19.36,29.67},{28.23,46.66},{29.65,36.82},{26.25,50.2},{28.51,33.04},{26.57,30.77},{24.47,29.88},{25.36,27.75},{19.62,50.24},{16.67,39.42},{21.82,37.11},{19.44,42.19},{22.22,47.23},{-1,-1}}},
        },
        [53245] = { -- Fire Hawk
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{25.51,49.83},{23.67,54.18},{32.25,44.18},{24.43,50.62},{-1,-1}}},
        },
        [53256] = { -- Ember Pool Bunny
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{47.24,53.26},{41.18,60.14},{54.33,61.61},{47.7,54.61},{50.11,57.35},{55.5,69.8},{49.28,68.68},{47.65,61.84},{40.41,55.57},{42.66,65.26},{-1,-1}}},
        },
        [53259] = { -- Arthorn Windsong
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{34.3,56.42},{-1,-1}}},
        },
        [53296] = { -- Locket A Event Controller
            [npcKeys.spawns] = {[zoneIDs.MOONGLADE] = {{51.67,44.62}}},
        },
        [53297] = { -- Trained Fire Hawk
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{33.91,57.2},{-1,-1}}},
        },
        [53302] = { -- Locket C Event Controller
            [npcKeys.questStarts] = {},
        },
        [53304] = { -- Ricket
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{36.25,56.57},{-1,-1}}},
        },
        [53349] = { -- Kalecgos
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{23.29,22.97}}},
        },
        [53355] = { -- Windcaller Nordrala
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{43.12,80.09},{-1,-1}}},
        },
        [53364] = { -- Malfurion Stormrage
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.04,85.53},{-1,-1}}},
        },
        [53365] = { -- General Taldris Moonfall
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.64,84.12},{-1,-1}}},
        },
        [53366] = { -- Leyara
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{63.59,59.88},{-1,-1}}},
        },
        [53371] = { -- Hallegosa
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{48.79,70.24}}},
            [npcKeys.questEnds] = {29308},
        },
        [53373] = { -- Magnetic Stone
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.94,50.62},{45.11,51.05},{46.73,44.09},{54.55,44.48},{41.72,48.89},{-1,-1}}},
        },
        [53381] = { -- Obsidian Slaglord
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.71,84.94},{-1,-1}}},
        },
        [53385] = { -- Malfurion Stormrage
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{47.16,90.58},{-1,-1}}},
        },
        [53390] = { -- Dragon Disc
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{50.71,79.84}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [53439] = { -- Tarecgosa
            [npcKeys.spawns] = {[5786] = {{36.2,81.4}},[zoneIDs.THE_NEXUS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_NEXUS,
        },
        [53446] = { -- Keeper Taldros
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{67.71,64.41},{-1,-1}}},
        },
        [53447] = { -- Turak Runetotem
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{67.36,64.51},{-1,-1}}},
        },
        [53448] = { -- Sira Moonwarden
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{63.35,66.7},{-1,-1}}},
        },
        [53466] = { -- Hallegosa
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{54.79,55.81}}},
            [npcKeys.questEnds] = {29307},
        },
        [53468] = { -- Dragon Disc
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{53.08,55.49}}},
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
        },
        [53477] = { -- Cinderweb Skitterer
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{98.8,90.89},{99.07,90.29},{96.48,98.84},{96.37,97.11},{94.63,92.43},{94.53,97.3},{96.25,92.02},{94.88,97.63},{94.62,95.37},{99.15,93.4},{99.33,94.06},{97.73,93.91},{99.64,94.25},{97.35,93.76},{97.91,95.73},{94.44,98.78},{99.73,92.07},{99.5,91.96},{99.34,91.69},{98.99,91.55},{98.77,91.09},{97.28,98.71},{-1,-1}}},
        },
        [53478] = { -- Cinderweb Clutchkeeper
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{95.59,92.92},{93.71,98.29},{94.72,99.02},{98.1,94.44},{99.63,91.46},{-1,-1}}},
        },
        [53479] = { -- Cinderweb Matriarch
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{99.79,96.81},{97.78,93.11},{-1,-1}}},
        },
        [53480] = { -- Sira Moonwarden
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.99,23.44},{-1,-1}}},
        },
        [53481] = { -- Thisalee Crow
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.8,27.9},{-1,-1}}},
        },
        [53517] = { -- Squirming Slime Mold
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY] = {{44,34.8},{48.1,44.7},{48.2,43.6},{48.3,45.5},{49.6,55},{50.5,30.4},{50.6,44.8},{50.7,41.8},{50.9,45.6},{51.3,41.3},{52,52.6},{52.3,35.8},{52.5,26},{52.7,31.7},{53,31.4},{53.2,57.3},{53.9,24.7},{55,60.4},{55,60.9},{55.1,64.4},{55.7,64.2},{56.3,21.6},{56.6,21.5},{56.6,62.4},{56.6,62.8},{57.3,64.9},{58,21.5},{58.4,21.1},{58.5,20.9},{58.6,68},{58.7,68.6},{59.7,18.9},{63.6,47},{63.7,39.7},{63.9,46.1},{64,48},{64,71.2},{64.1,21.7},{64.7,21.1},{64.7,66.9},{64.8,17.6},{64.9,21.8},{65,40.9},{65.3,70.6},{65.5,17.2},{65.5,39.9},{65.8,47.4},{65.9,21.1},{66,40.9},{66.3,47.5},{66.4,17.8},{66.6,40.5},{66.8,47.7},{67,71},{67.1,22.2},{67.9,40.3},{68.1,21.4},{68.4,47},{71.7,65.2},{72.9,68.5},{73,24.2},{73.3,68.4},{73.9,24.1},{74.3,65.4},{74.4,24.5},{74.5,24.4},{75.8,26.9},{75.9,66.2},{76.5,65.8},{77.3,23.3},{77.4,60.3},{77.5,26.6},{77.5,60.2},{77.6,24.2},{77.8,30.6},{77.9,29.6},{78.7,60.1},{78.9,31.1},{79,26.3},{79.1,32.1},{79.4,26.5},{79.4,61.6},{79.5,33.5},{79.8,27.4},{79.8,35.3},{79.9,27.6},{79.9,35.8},{80,36.6},{80,57.1},{80.3,59.4},{80.5,59.2},{80.7,28.4},{80.7,28.9},{80.7,45.5},{81,29.6},{81,46.5},{81.1,31.4},{81.1,32},{81.2,44.2},{81.2,44.9},{81.4,43},{81.6,31.5},{81.6,33.6},{81.7,56},{81.8,31.3},{82.7,33.9},{82.8,34.5},{83.6,41.9},{83.6,42.8},{83.7,40.1},{83.7,41.4},{83.7,44.9},{83.7,45.5},{83.8,43.6}}},
        },
        [53540] = { -- Cold Water Crayfish
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{83.97,51.69}}},
        },
        [53567] = { -- Tarecgosa
            [npcKeys.spawns] = {[5786] = {{60.7,21.4}},[zoneIDs.THE_NEXUS] = {{-1,-1}}},
        },
        [53670] = { -- Aggra
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{69.82,34.2}}},
            [npcKeys.zoneID] = zoneIDs.ABYSSAL_DEPTHS,
        },
        [53738] = { -- Aggra
            [npcKeys.spawns] = {
                [zoneIDs.DEEPHOLM] = {
                    {56.52,12.5,phases.AGGRA_THRONE},
                    {64.05,46.09,phases.AGGRA_PRECIPICE},
                },
            },
        },
        [53759] = { -- Cinderweb Queen
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.35,19.55},{-1,-1}}},
        },
        [53763] = { -- Candace Fenlow
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.42,66.72}}},
            [npcKeys.zoneID] = zoneIDs.TIRISFAL_GLADES,
        },
        [53764] = { -- Crina Fenlow
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.12,67.02}}},
            [npcKeys.zoneID] = zoneIDs.TIRISFAL_GLADES,
        },
        [53771] = { -- Ancient Smoldering Behemoth
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.35,19.55},{-1,-1}}},
        },
        [53834] = { -- Devout Harbinger
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.35,19.55},{-1,-1}}},
        },
        [53864] = { -- Ancient Firelord
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.35,19.55},{-1,-1}}},
        },
        [53865] = { -- Orphan Matron Nanee
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{62.42,66.51}}},
            [npcKeys.zoneID] = zoneIDs.TIRISFAL_GLADES,
            [npcKeys.questStarts] = {},
        },
        [53869] = { -- Orphan Matron Seacole
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{31.93,50.35}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
            [npcKeys.questStarts] = {},
        },
        [53881] = { -- Ayla Shadowstorm
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{44.08,86.33},{-1,-1}}},
        },
        [53882] = { -- Varlan Highbough
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{44.43,88.79},{-1,-1}}},
        },
        [53886] = { -- Igneous Depths Area Credit
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{57.78,49.7},{-1,-1}}},
        },
        [53887] = { -- Flame Protection Rune
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{68.12,66.5},{-1,-1}}},
        },
        [53905] = { -- Thrall
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{52.96,28.22},{-1,-1}}},
        },
        [53911] = { -- Shadow Warden
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{57.04,50.35},{56.87,49.15},{-1,-1}}},
        },
        [53915] = { -- Aggra's Fire Totem
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.41,25.38},{-1,-1}}},
        },
        [53916] = { -- Aggra's Air Totem
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{43.56,22.95},{-1,-1}}},
        },
        [53917] = { -- Aggra's Water Totem
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{50.27,16.98},{-1,-1}}},
        },
        [53918] = { -- Aggra's Earth Totem
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{57.29,25.79},{-1,-1}}},
        },
        [53925] = { -- Aggra
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{51.46,25.8},{-1,-1}}},
        },
        [53949] = { -- Anson Hastings
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{60.04,75.13}}},
        },
        [53950] = { -- Hired Courier
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{24.03,44.82}}},
        },
        [54014] = { -- Aggra
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.61,31.75},{-1,-1}}},
        },
        [54021] = { -- Hudson Barnes
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{64.17,46.29}}},
        },
        [54118] = { -- Hudson Barnes
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{65.17,33.47}}},
        },
        [54123] = { -- Echo of Sylvanas
            [npcKeys.spawns] = {[zoneIDs.END_TIME_RUBY_DRAGONSHRINE] = {{56.77,39.94}},[zoneIDs.END_TIME] = {{-1,-1}}},
        },
        [54142] = { -- Hired Courier
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{57.33,9.01}}},
        },
        [54163] = { -- Ricket
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{66.61,65.22},{-1,-1}}},
        },
        [54170] = { -- Delian Sunshade
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{71.77,49.78}}},
        },
        [54256] = { -- Heatflayer
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{93.72,93.41},{-1,-1}}},
        },
        [54312] = { -- Aggra
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{60.22,30.11}}},
        },
        [54321] = { -- Solix
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{57.19,50.29},{-1,-1}}},
        },
        [54322] = { -- Deth'tilac
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{67.42,73},{-1,-1}}},
        },
        [54323] = { -- Kirix
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{31.05,56.09},{-1,-1}}},
        },
        [54324] = { -- Skitterflame
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{20.06,48.16},{-1,-1}}},
        },
        [54334] = { -- Darkmoon Faire Mystic Mage
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY] = {{62.1,32.17},{62.26,72.96}},
                [zoneIDs.IRONFORGE] = {{27.5,73.35}},
                [zoneIDs.DARNASSUS] = {{38.56,49.4}},
                --[zoneIDs.THE_EXODAR] = {{51.33,42.02}}, -- currently MIA
                [zoneIDs.SHATTRATH_CITY] = {{52.02,29.16}},
                [zoneIDs.DALARAN] = {{49.88,50.37}},
            },
        },
        [54338] = { -- Anthriss
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{54.84,38.62},{-1,-1}}},
        },
        [54339] = { -- Ancient Charhound
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{55.51,62.78},{39.2,57.18},{46.52,62.83},{52.26,77.71},{47.4,79.5},{43.26,72.62},{46.93,72.98},{51.46,72.44},{54.43,72.63},{42.48,69.01},{49.05,68.2},{44.57,65.67},{55.21,69.35},{49.56,63.19},{47.67,69.88},{45.05,60.91},{51.74,62.9},{51.96,78.6},{47.86,60.46},{49.07,79.22},{48.47,82.57},{48.08,83.65},{52.55,75.78},{46.78,72.44},{44.31,76.38},{-1,-1}}},
        },
        [54343] = { -- Druid of the Flame
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{49.03,76.94},{43.86,72.57},{51.06,79.2},{48.94,83.38},{47.96,75.08},{44.67,77.02},{53.7,75.48},{46.25,70.12},{49.56,61.95},{42.6,69.04},{47.53,85.44},{53.73,78.6},{55.14,69.51},{53.21,77.17},{56.79,67.92},{48.29,63.17},{46.54,84.03},{50.56,65.03},{45.06,61.58},{51.58,68.97},{52.84,76.85},{52.55,75.79},{48.05,74.19},{48.23,62.77},{52.62,61.21},{47.56,81.61},{47.49,72.63},{42.95,70.3},{43.21,67.59},{43.55,65.3},{51.28,63.71},{51.6,68.93},{54.74,70.54},{52.11,62.23},{50.22,78.3},{48.45,69.57},{-1,-1}}},
        },
        [54431] = { -- Echo of Baine
            [npcKeys.spawns] = {[zoneIDs.END_TIME_OBSIDIAN_DRAGONSHRINE] = {{36.56,52.09}},[zoneIDs.END_TIME] = {{-1,-1}}},
        },
        [54432] = { -- Murozond
            [npcKeys.spawns] = {[zoneIDs.END_TIME_BRONZE_DRAGONSHRINE] = {{49.33,29.31}},[zoneIDs.END_TIME] = {{-1,-1}}},
        },
        [54441] = { -- Thaumaturge Vashreen
            [npcKeys.friendlyToFaction] = "A",
        },
        [54442] = { -- Warpweaver Hashom
            [npcKeys.friendlyToFaction] = "A",
        },
        [54445] = { -- Echo of Jaina
            [npcKeys.spawns] = {[zoneIDs.END_TIME_AZURE_DRAGONSHRINE] = {{49.37,66.48}},[zoneIDs.END_TIME] = {{-1,-1}}},
        },
        [54471] = { -- Thaumaturge Zajir
            [npcKeys.friendlyToFaction] = "H",
        },
        [54473] = { -- Warpweaver Dushar
            [npcKeys.friendlyToFaction] = "H",
        },
        [54476] = { -- Nozdormu
            [npcKeys.spawns] = {[zoneIDs.END_TIME] = {{79.54,44.94},{-1,-1}}},
        },
        [54485] = { -- Jessica Rogers
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{51.65,77.84},{-1,-1}}},
        },
        [54490] = { -- Dubenko
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{52.35,78.53},{-1,-1}}},
        },
        [54601] = { -- Mola
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{53.29,54.36},{-1,-1}}},
        },
        [54603] = { -- Advance Scout Chadwick
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{48.41,68.05},{-1,-1}}},
        },
        [54510] = { -- Baby
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{51.29,82.06},{-1,-1}}},
        },
        [54544] = { -- Echo of Tyrande
            [npcKeys.spawns] = {[zoneIDs.END_TIME_EMERALD_DRAGONSHRINE] = {{50.79,44.29}},[zoneIDs.END_TIME] = {{-1,-1}}},
        },
        [54548] = { -- Thrall
            [npcKeys.spawns] = {
                [zoneIDs.HOUR_OF_TWILIGHT] = {
                    {48.7,19.71,phases.HOT_THRALL_START},
                    {-1,-1},
                },
                [zoneIDs.HOUR_OF_TWILIGHT_WYRMREST_TEMPLE] = {
                    {46.73,44.77,phases.HOT_THRALL_TEMPLE},
                },
            },
            [npcKeys.questEnds] = {30102,30103},
        },
        [54590] = { -- Arcurion
            [npcKeys.spawns] = {[zoneIDs.HOUR_OF_TWILIGHT] = {{56.81,27.68},{-1,-1}}},
        },
        [54605] = { -- Finlay Coolshot
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{50.7,65.15},{-1,-1}}},
        },
        [54606] = { -- Stone Guard Stok'ton
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{48.41,68.05},{-1,-1}}},
        },
        [54629] = { -- Gunny
            [npcKeys.spawns] = {[zoneIDs.THE_BLOOD_FURNACE] = {{50.94,90.15},{-1,-1}}},
        },
        [54634] = { -- Thrall
            [npcKeys.spawns] = {
                [zoneIDs.HOUR_OF_TWILIGHT] = {
                    {48.7,19.71,phases.HOT_THRALL_START},
                    {-1,-1},
                },
                [zoneIDs.HOUR_OF_TWILIGHT_WYRMREST_TEMPLE] = {
                    {46.73,44.77,phases.HOT_THRALL_TEMPLE},
                },
            },
            [npcKeys.questEnds] = {30102,30103},
        },
        [54636] = { -- Caza'rez
            [npcKeys.spawns] = {[zoneIDs.THE_BLOOD_FURNACE] = {{51.48,90.03},{-1,-1}}},
        },
        [54645] = { -- Royal Handmaiden
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{43.46,27.33},{43.81,27.02},{-1,-1}}},
        },
        [54667] = { -- Watcher Jhang
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{18.8,11.16},{-1,-1}}},
        },
        [54668] = { -- Nahuud
            [npcKeys.spawns] = {[zoneIDs.THE_SLAVE_PENS] = {{17.8,12},{-1,-1}}},
        },
        [54674] = { -- T'shu
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{31.56,65.26},{-1,-1}}},
        },
        [54675] = { -- Watcher Jhang
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{30.83,65.17},{-1,-1}}},
        },
        [54678] = { -- Naturalist Bite
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBOG] = {{29.51,64.39},{-1,-1}}},
        },
        [54692] = { -- Artificer Morphalius
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{34.38,19.46},{-1,-1}}},
        },
        [54694] = { -- Mamdy the "Ologist"
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{32.7,19.42},{-1,-1}}},
        },
        [54698] = { -- Tormented Soulpriest
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{46.22,23.1}},[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.AUCHENAI_CRYPTS_BRIDGE_OF_SOULS] = {{{46.22,23.1},{46.23,21.76},{50.05,18.29},{51.26,17.82}}}},
        },
        [54725] = { -- Draenei Spirit
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS] = {{44.11,71.73},{-1,-1}}},
        },
        [54751] = { -- Nozdormu
            [npcKeys.spawns] = {
                [zoneIDs.END_TIME] = {{-1,-1}},
                [zoneIDs.END_TIME_BRONZE_DRAGONSHRINE] = {{52.14,44.46,phases.ET_MUROZOND_DEAD}},
            },
        },
        [54840] = { -- Isfar
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{72.07,35.47},{-1,-1}}},
        },
        [54847] = { -- Dealer Vijaad
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{48.14,67.7},{-1,-1}}},
        },
        [54848] = { -- Watcher Jhang
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{17.87,27.22},{-1,-1}}},
        },
        [54849] = { -- Naturalist Bite
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{17.44,25.85},{-1,-1}}},
        },
        [54851] = { -- Windcaller Claw
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{18.82,27.53},{-1,-1}}},
        },
        [54853] = { -- Queen Azshara
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{47.09,36.78},{-1,-1}}},
        },
        [54890] = { -- Field Commander Mahfuun
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{21.24,13.08},{-1,-1}}},
        },
        [54891] = { -- Spy Grik'tha
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{22.56,12.45},{-1,-1}}},
        },
        [54931] = { -- Stone Guard Stok'ton
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{58.62,88.4},{-1,-1}}},
        },
        [54932] = { -- Caza'rez
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{58.59,88.59},{-1,-1}}},
        },
        [54933] = { -- Advance Scout Chadwick
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{58.62,88.4},{-1,-1}}},
        },
        [54934] = { -- Gunny
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{58.59,88.59},{-1,-1}}},
        },
        [54938] = { -- Archbishop Benedictus
            [npcKeys.spawns] = {[zoneIDs.HOUR_OF_TWILIGHT_WYRMREST_TEMPLE] = {{47.24,50.86}},[zoneIDs.HOUR_OF_TWILIGHT] = {{-1,-1}}},
        },
        [54968] = { -- Asira Dawnslayer
            [npcKeys.spawns] = {[zoneIDs.HOUR_OF_TWILIGHT] = {{39.08,51.26},{-1,-1}}},
        },
        [54969] = { -- Mannoroth
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{86.64,49.7},{-1,-1}}},
        },
        [54971] = { -- Thrall
            [npcKeys.spawns] = {
                [zoneIDs.HOUR_OF_TWILIGHT] = {
                    {48.7,19.71,phases.HOT_THRALL_START},
                    {-1,-1},
                },
                [zoneIDs.HOUR_OF_TWILIGHT_WYRMREST_TEMPLE] = {
                    {46.73,44.77,phases.HOT_THRALL_TEMPLE},
                },
            },
            [npcKeys.questEnds] = {30102,30103},
        },
        [54972] = { -- Thrall
            [npcKeys.spawns] = {
                [zoneIDs.HOUR_OF_TWILIGHT] = {
                    {48.7,19.71,phases.HOT_THRALL_START},
                    {-1,-1},
                },
                [zoneIDs.HOUR_OF_TWILIGHT_WYRMREST_TEMPLE] = {
                    {46.73,44.77,phases.HOT_THRALL_TEMPLE},
                },
            },
            [npcKeys.questEnds] = {30102,30103},
        },
        [55007] = { -- Exarch Larethor
            [npcKeys.spawns] = {
                [zoneIDs.MAGISTERS_TERRACE] = {{42.61,87.16},{-1,-1}},
                [zoneIDs.MAGISTERS_TERRACE_GRAND_MAGISTERS_ASYLUM] = {
                    {13.39,49.82,phases.MGT_KT_DEAD},
                },
            },
        },
        [55085] = { -- Peroth'arn
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{19.5,51.47},{-1,-1}}},
        },
        [55136] = { -- Stone Guard Stok'ton
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{67.19,51.69,phases.KARGATH_DEAD},{-1,-1}}},
        },
        [55138] = { -- Advance Scout Chadwick
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS] = {{67.19,51.69,phases.KARGATH_DEAD},{-1,-1}}},
        },
        [55210] = { -- Elder Sekhemi
            [npcKeys.questStarts] = {29741},
        },
        [55211] = { -- Elder Menkhaf
            [npcKeys.questStarts] = {29742},
        },
        [55216] = { -- Elder Deepforge
            [npcKeys.questStarts] = {29734},
        },
        [55217] = { -- Elder Stonebrand
            [npcKeys.questStarts] = {29735},
        },
        [55218] = { -- Elder Darkfeather
            [npcKeys.questStarts] = {29736},
        },
        [55219] = { -- Elder Firebeard
            [npcKeys.questStarts] = {29737},
        },
        [55224] = { -- Elder Windsong
            [npcKeys.questStarts] = {29739},
        },
        [55227] = { -- Elder Evershade
            [npcKeys.questStarts] = {29740},
        },
        [55228] = { -- Elder Moonlance
            [npcKeys.questStarts] = {29738},
        },
        [55382] = { -- Darkmoon Faire Mystic Mage
            [npcKeys.spawns] = {
                [zoneIDs.UNDERCITY] = {{61.87,47.34}},
                [zoneIDs.ORGRIMMAR] = {{48.23,62.17}},
                [zoneIDs.THUNDER_BLUFF] = {{43.93,52.6}},
                [zoneIDs.SILVERMOON_CITY] = {{74.32,81.88}},
                [zoneIDs.SHATTRATH_CITY] = {{51.8,29.26}},
                [zoneIDs.DALARAN] = {{50.29,50.38}},
            },
        },
        [55402] = { -- Korgol Crushskull
            [npcKeys.spawns] = {[zoneIDs.DARKMOON_FAIRE_ISLAND] = {{47.37,78.91},{-1,-1}}},
        },
        [55419] = { -- Captain Varo'then
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{85.19,53.69},{-1,-1}}},
        },
        [55503] = { -- Legion Demon
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{23.41,68.34},{-1,-1}}},
        },
        [55532] = { -- Illidan Stormrage
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{84.49,56.01},{-1,-1}}},
        },
        [55624] = { -- Nozdormu/Image of Nozdormu
            [npcKeys.spawns] = {
                [zoneIDs.WELL_OF_ETERNITY] = {
                    {-1,-1},
                    {27.19,64.15,phases.WOT_NOZDORMU_1},
                    {29.32,39.92,phases.WOT_NOZDORMU_2},
                    {71.61,80.54,phases.WOT_NOZDORMU_3},
                },
            },
        },
        [55677] = { -- Kurzel
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP] = {{35.48,83.14},{-1,-1}}},
        },
        [55779] = { -- Thrall
            [npcKeys.spawns] = {
                [zoneIDs.HOUR_OF_TWILIGHT] = {
                    {48.7,19.71,phases.HOT_THRALL_START},
                    {-1,-1},
                },
                [zoneIDs.HOUR_OF_TWILIGHT_WYRMREST_TEMPLE] = {
                    {46.73,44.77,phases.HOT_THRALL_TEMPLE},
                },
            },
            [npcKeys.questEnds] = {30102,30103},
        },
        [56375] = { -- Mostrasz
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{67.83,45.13}}},
        },
        [57770] = { -- Zazzo Twinklefingers
            [npcKeys.spawns] = {
                [zoneIDs.RUINS_OF_GILNEAS] = {{70.07,40.73,phases.ZAZZO_GILNEAS}},
                [zoneIDs.DEADWIND_PASS] = {{52.48,77.73,phases.ZAZZO_DEADWIND}},
            },
            [npcKeys.questStarts] = {30093,30106,30109,30113},
        },
        [57777] = { -- Wrathion
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{71.42,45.56}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
            [npcKeys.questStarts] = {30092,30107,30108,30116,30118},
        },
        [57864] = { -- Alurmi
            [npcKeys.spawns] = {
                [zoneIDs.END_TIME] = {{79.63,45.1,phases.ET_ALURMI_ENTRANCE},{79.63,45.1,phases.ET_ALURMI_MUROZOND_DEAD},{-1,-1,phases.ET_ALURMI_ENTRANCE},{-1,-1,phases.ET_ALURMI_MUROZOND_DEAD}},
                [zoneIDs.END_TIME_BRONZE_DRAGONSHRINE] = {{51.01,43.49,phases.ET_ALURMI_MUROZOND_DEAD}},
                [zoneIDs.WELL_OF_ETERNITY] = {
                    {-1,-1,phases.WOT_MUROZOND_DEAD},
                    {-1,-1,phases.WOT_MANNOROTH_DEAD},
                    {25.99,62.87,phases.WOT_MUROZOND_DEAD},
                    {87.85,49.84,phases.WOT_MANNOROTH_DEAD},
                },
            },
        },
        [57910] = { -- Nalice
            [npcKeys.spawns] = {[zoneIDs.DEADWIND_PASS] = {{54.05,90.88}}},
            [npcKeys.zoneID] = zoneIDs.DEADWIND_PASS,
        },
        [57913] = { -- Chromie
            [npcKeys.spawns] = {[zoneIDs.WELL_OF_ETERNITY] = {{87.32,49.23},{-1,-1}}},
        },
        [58038] = { -- Wrathion
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{70.53,46.79}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
        },
        [58149] = { -- Image of Drakuru
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP] = {{37.08,80.56},{-1,-1}}},
        },
        [80001] = { -- Maintain a Trot for 8 seconds
            [npcKeys.name] = "Maintain a Trot for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{53.73,40.41}}}
        },
        [80002] = { -- Maintain a Canter for 8 seconds
            [npcKeys.name] = "Maintain a Canter for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{53.73,40.41}}}
        },
        [80003] = { -- Maintain a Gallop for 8 seconds
            [npcKeys.name] = "Maintain a Gallop for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{53.73,40.41}}}
        },
        [80004] = { -- Maintain a Trot for 8 seconds
            [npcKeys.name] = "Maintain a Trot for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{42.25,17.96}}}
        },
        [80005] = { -- Maintain a Canter for 8 seconds
            [npcKeys.name] = "Maintain a Canter for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{42.25,17.96}}}
        },
        [80006] = { -- Maintain a Gallop for 8 seconds
            [npcKeys.name] = "Maintain a Gallop for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{42.25,17.96}}}
        },
        -- Fake NPCs for Auto Accept and Auto Turn in
        [100000] = { -- With Great Power, Comes Great Responsibility
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR] = {{49.39,81.87},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_MECHANAR,
            [npcKeys.questStarts] = {29657},
        },
        [100001] = { -- A'dal -- REUSE
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY] = {{53.99,44.75}}},
            [npcKeys.zoneID] = zoneIDs.SHATTRATH_CITY,
        },
        [100002] = { -- A Personal Summons - Stormwind
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{63.5,72.6}}},
            [npcKeys.zoneID] = zoneIDs.STORMWIND_CITY,
            [npcKeys.questStarts] = {28825},
        },
        [100003] = { -- A Personal Summons - Orgrimmar
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{48.28,64.53}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.questStarts] = {28790},
        },
        [100004] = { -- Once More, With Eeling
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{47.22,21.56}}},
            [npcKeys.zoneID] = zoneIDs.KELP_THAR_FOREST,
            [npcKeys.questEnds] = {27729},
        },
        [100005] = { -- Necessary Roughness
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{47.7,57.74}}},
            [npcKeys.zoneID] = zoneIDs.KEZAN,
            [npcKeys.questEnds] = {24502},
        },
        [100006] = { -- Fourth and Goal
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.KEZAN] = {{47.7,57.74}}},
            [npcKeys.zoneID] = zoneIDs.KEZAN,
            [npcKeys.questStarts] = {24503,28414},
        },
        [100007] = { -- Defend the Gates!
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.AZSHARA] = {{26.8,77.27}}},
            [npcKeys.zoneID] = zoneIDs.AZSHARA,
            [npcKeys.questEnds] = {14146},
        },
        [100008] = { -- Decryption Made Easy
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{39.6,73.1}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
            [npcKeys.questEnds] = {27040,27041},
        },
        [100009] = { -- Lady La-La's Medallion
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.KELP_THAR_FOREST] = {{54,55.6}}},
            [npcKeys.zoneID] = zoneIDs.KELP_THAR_FOREST,
            [npcKeys.questEnds] = {25419},
        },
        [100010] = { -- One With the Ground
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{47.11,90.17}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
            [npcKeys.questEnds] = {27934},
        },
        [100011] = { -- Bring Down the Avalanche
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.DEEPHOLM] = {{47.11,90.17}}},
            [npcKeys.zoneID] = zoneIDs.DEEPHOLM,
            [npcKeys.questStarts] = {27935},
        },
        [100012] = { -- Do the World a Favor
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{64.43,28.49}}},
            [npcKeys.zoneID] = zoneIDs.ULDUM,
            [npcKeys.questEnds] = {27187,27627},
        },
        [100013] = { -- Neferset Prison
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{71.2,73.79}}},
            [npcKeys.zoneID] = zoneIDs.ULDUM,
            [npcKeys.questEnds] = {27707},
        },
        [100014] = { -- Gobbles!
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{24.46,64.25}}},
            [npcKeys.zoneID] = zoneIDs.ULDUM,
            [npcKeys.questEnds] = {27950},
        },
        [100015] = { -- Dirty Birds
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.ULDUM] = {{42.54,68.42}}},
            [npcKeys.zoneID] = zoneIDs.ULDUM,
            [npcKeys.questEnds] = {27940},
        },
        [100016] = { -- Move the Mountain
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{37.95,66.19}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
            [npcKeys.questEnds] = {27494,27495},
        },
        [100017] = { -- Signal the Attack
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{37.95,66.19}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
            [npcKeys.questStarts] = {27498,27499},
        },
        [100018] = { -- Signal the Attack
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{42.33,68.8},{40.62,62.21}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
            [npcKeys.questEnds] = {27498,27499,27588,27590},
        },
        [100019] = { -- Four Heads are Better than None
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{42.33,68.8},{40.62,62.21}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
            [npcKeys.questStarts] = {27500,27501},
        },
        [100020] = { -- Up to the Citadel
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{37.63,65.84}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
            [npcKeys.questEnds] = {27502,27503},
        },
        [100021] = { -- Just You and Mathias, Just You and Garona
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.TWILIGHT_HIGHLANDS] = {{37.63,65.84}}},
            [npcKeys.zoneID] = zoneIDs.TWILIGHT_HIGHLANDS,
            [npcKeys.questStarts] = {27636,27638},
        },
        [100022] = { -- The Hunter's Revenge
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{64.11,20.16}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questEnds] = {29115,29227},
        },
        [100023] = { -- Follow That Cat
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{64.11,20.16}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questStarts] = {29116,29228},
        },
        [100024] = { -- Tragedy and Family
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{40.5,53.37}}},
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.questEnds] = {29303},
        },
        [100025] = { -- Tipping Point
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{40.5,53.37}}},
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.questStarts] = {29310},
        },
        [100026] = { -- Tipping Point
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{7.64,34.62}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
            [npcKeys.questEnds] = {29310},
        },
        [100027] = { -- The Rest is History
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{7.64,34.62}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
            [npcKeys.questStarts] = {29311},
        },
        [100028] = { -- The Fallen Guardian
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.MOUNT_HYJAL] = {{49.07,19.47}}},
            [npcKeys.zoneID] = zoneIDs.MOUNT_HYJAL,
            [npcKeys.questEnds] = {29437},
        },
        [100029] = { -- Elemental Bonds: Fury
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.MOLTEN_FRONT] = {{51.29,26.1},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MOLTEN_FRONT,
            [npcKeys.questEnds] = {29330},
        },
        [100030] = { -- Into the Flames
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{67.34,9.1}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
            [npcKeys.questEnds] = {27482},
        },
        [100031] = { -- Champion of the Tournament
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.TRIAL_OF_THE_CHAMPION] = {{51.1,32.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.TRIAL_OF_THE_CHAMPION,
            [npcKeys.questStarts] = {29851},
        },
        [100032] = { -- Champion of the Tournament
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.TRIAL_OF_THE_CHAMPION] = {{51.1,32.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.TRIAL_OF_THE_CHAMPION,
            [npcKeys.questEnds] = {29851},
        },
        [100033] = { -- The Sentinel's Game
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{48.03,53.22}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questEnds] = {27709,27886},
        },
        [100034] = { -- The Warden's Game
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{50.25,54.27}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questEnds] = {27693,27885},
        },
        [100035] = { -- Ancient Protectors
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{50.3,52.1}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questEnds] = {27793,27887},
        },
        [100036] = { -- The Titans' Trove
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{50.3,52.1}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questStarts] = {27912,27913},
        },
        [100037] = { -- Rheastrasza's Gift
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{15.96,33.39}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questEnds] = {27858},
        },
        [100038] = { -- Devastation
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.BADLANDS] = {{15.96,33.39}}},
            [npcKeys.zoneID] = zoneIDs.BADLANDS,
            [npcKeys.questStarts] = {27930},
        },
        [100039] = { -- Lunk's Adventure: Spider Rider
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{59.09,57.98}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.questEnds] = {27959},
        },
        [100040] = { -- Lunk's Adventure: Cranky Little Dwarfs
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{41.12,39.5}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.questEnds] = {27983},
        },
        [100041] = { -- Prayer to Elune
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{23.12,35.43}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.questEnds] = {27985},
        },
        [100042] = { -- Minions of Calcinder, From Whence He Came
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{43.36,28.59}}},
            [npcKeys.zoneID] = zoneIDs.SEARING_GORGE,
            [npcKeys.questEnds] = {28061,28062},
        },
        [100043] = { -- The Kodocaller's Horn
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{44.62,61.12}}},
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
            [npcKeys.questEnds] = {28252,28436},
        },
        [100044] = { -- Step Two: The Bloodletter
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.SWAMP_OF_SORROWS] = {{77.3,46.3}}},
            [npcKeys.zoneID] = zoneIDs.SWAMP_OF_SORROWS,
            [npcKeys.questEnds] = {27768},
        },
        [100045] = { -- The Future of the Rockpool
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{72.6,63.1},{73.1,71},{70.7,78.9},{56.9,85.3},{65.2,85.3}}},
            [npcKeys.zoneID] = zoneIDs.BLASTED_LANDS,
            [npcKeys.questEnds] = {25707},
        },
        [100046] = { -- Eliminate the Outcast
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{61.21,44.29}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
            [npcKeys.questEnds] = {26551,26810},
        },
        [100047] = { -- Through the Troll Hole
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{61.21,44.29}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
            [npcKeys.questStarts] = {26552,26811},
        },
        [100048] = { -- Through the Troll Hole
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{78.51,35.68}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questEnds] = {26552,26811},
        },
        [100049] = { -- High Priestess Jeklik
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{78.51,35.68}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questStarts] = {26553,26812},
        },
        [100050] = { -- High Priestess Jeklik
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{78.32,43.86}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questEnds] = {26553,26812},
        },
        [100051] = { -- Plunging Into Zul'Gurub
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{78.32,43.86}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questStarts] = {26554,26813},
        },
        [100052] = { -- Plunging Into Zul'Gurub
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{82.1,35.37}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questEnds] = {26554,26813},
        },
        [100053] = { -- High Priest Venoxis
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{82.1,35.37}}},
            [npcKeys.zoneID] = zoneIDs.STRANGLETHORN_VALE,
            [npcKeys.questStarts] = {26555,26814},
        },
        [100054] = { -- A Trip to the Moonwell
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{53.72,46.02}}},
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.questEnds] = {13919},
        },
        [100055] = { -- He Who Would Be Forgiven
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{53.72,46.02}}},
            [npcKeys.zoneID] = zoneIDs.ASHENVALE,
            [npcKeys.questStarts] = {13921},
        },
        [100056] = { -- Pirate Accuracy Increasing
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{79.63,75.82}}},
            [npcKeys.waypoints] = {[zoneIDs.THOUSAND_NEEDLES] = {{{79.63,75.82},{79.98,75.18},{80.36,74.36},{80.59,73.50},{80.74,72.60},{80.80,71.66},{80.67,70.85},{80.34,70.17},{79.86,69.54},{79.31,69.09},{78.78,68.91},{78.20,69.00},{77.59,69.25},{76.99,69.56},{76.41,69.88},{75.85,70.22},{75.32,70.66},{74.88,71.24},{74.52,71.95},{74.20,72.80},{73.99,73.67},{73.95,74.48},{74.11,75.29},{74.44,76.09},{74.86,76.78},{75.33,77.26},{75.90,77.58},{76.54,77.79},{77.16,77.88},{77.72,77.80},{78.32,77.41},{78.85,76.85},{79.30,76.37},{79.63,75.82}}}},
            [npcKeys.zoneID] = zoneIDs.THOUSAND_NEEDLES,
            [npcKeys.questEnds] = {25532,25533},
        },
        [100057] = { -- Circle the Wagons... er, Boats
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{79.63,75.82}}},
            [npcKeys.waypoints] = {[zoneIDs.THOUSAND_NEEDLES] = {{{79.63,75.82},{79.98,75.18},{80.36,74.36},{80.59,73.50},{80.74,72.60},{80.80,71.66},{80.67,70.85},{80.34,70.17},{79.86,69.54},{79.31,69.09},{78.78,68.91},{78.20,69.00},{77.59,69.25},{76.99,69.56},{76.41,69.88},{75.85,70.22},{75.32,70.66},{74.88,71.24},{74.52,71.95},{74.20,72.80},{73.99,73.67},{73.95,74.48},{74.11,75.29},{74.44,76.09},{74.86,76.78},{75.33,77.26},{75.90,77.58},{76.54,77.79},{77.16,77.88},{77.72,77.80},{78.32,77.41},{78.85,76.85},{79.30,76.37},{79.63,75.82}}}},
            [npcKeys.zoneID] = zoneIDs.THOUSAND_NEEDLES,
            [npcKeys.questStarts] = {25542,25543},
        },
        [100058] = { -- The Elder Crone
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{35.87,60.66}}},
            [npcKeys.zoneID] = zoneIDs.THOUSAND_NEEDLES,
            [npcKeys.questEnds] = {28140},
        },
        [100059] = { -- To the Withering
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THOUSAND_NEEDLES] = {{35.87,60.66}}},
            [npcKeys.zoneID] = zoneIDs.THOUSAND_NEEDLES,
            [npcKeys.questStarts] = {28142},
        },
        [100060] = { -- Nature and Nurture
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.FELWOOD] = {{48.66,25.16}}},
            [npcKeys.zoneID] = zoneIDs.FELWOOD,
            [npcKeys.questEnds] = {28229,28228},
        },
        [100061] = { -- The Owls Have It
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{55.57,30.42}}},
            [npcKeys.zoneID] = zoneIDs.WINTERSPRING,
            [npcKeys.questEnds] = {28638},
        },
        [100062] = { -- Screechy Keen
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{55.03,32.98}}},
            [npcKeys.zoneID] = zoneIDs.WINTERSPRING,
            [npcKeys.questEnds] = {28745},
        },
        [100063] = { -- The Mighty U'cha
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.UN_GORO_CRATER] = {{64.89,16.64}}},
            [npcKeys.zoneID] = zoneIDs.UN_GORO_CRATER,
            [npcKeys.questStarts] = {24718},
        },
        [100064] = { -- Deeper into Darkness
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{34.87,7.82}}},
            [npcKeys.zoneID] = zoneIDs.SILVERPINE_FOREST,
            [npcKeys.questStarts] = {27094},
        },
        [100065] = { -- Resistance is Futile
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.RUINS_OF_GILNEAS] = {{73.86,34.13}}},
            [npcKeys.zoneID] = zoneIDs.RUINS_OF_GILNEAS,
            [npcKeys.questStarts] = {27423},
        },
        [100066] = { -- Do the Right Thing
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{39.18,63.69}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
            [npcKeys.questEnds] = {28189},
        },
        [100067] = { -- Terrible Little Creatures
            [npcKeys.name] = "?",
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{58.47,73.76}}},
            [npcKeys.zoneID] = zoneIDs.HILLSBRAD_FOOTHILLS,
            [npcKeys.questEnds] = {28355},
        },
        [100068] = { -- Princess Theradras
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.MARAUDON_ZAETARS_GRAVE] = {{28.44,43.13}},[zoneIDs.MARAUDON] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.questStarts] = {27692},
        },
        [100069] = { -- Servants of Theradras
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{63.33,20.31},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.questStarts] = {27698},
        },
        [100070] = { -- Corruption in Maraudon
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.MARAUDON] = {{76.9,67.21},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MARAUDON,
            [npcKeys.questStarts] = {27697},
        },
        [100071] = { -- Saving the Botanica
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{86.83,45.12},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BOTANICA,
            [npcKeys.questStarts] = {29660},
        },
        [100072] = { -- Unbound Darkness
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{41.2,80.47},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
            [npcKeys.questStarts] = {29674},
        },
        [100073] = { -- Culling the Herd
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{42.96,15.95},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BOTANICA,
            [npcKeys.questStarts] = {29667},
        },
        [100074] = { -- A Most Somber Task
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{34.03,68.78},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BOTANICA,
            [npcKeys.questStarts] = {29669},
        },
        [100075] = { -- Hey There Dalliah
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{65.07,35.59},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
            [npcKeys.questStarts] = {29675},
        },
        [100076] = { -- Maximum Security Breakout
            [npcKeys.name] = "!",
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ_STASIS_BLOCK_MAXIMUS] = {{35.15,57.13}},[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
            [npcKeys.questStarts] = {29681},
        },
    }
end

-- This should allow manual fix for NPC availability
function CataNpcFixes:LoadFactionFixes()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local phases = Phasing.phases

    local npcFixesHorde = {
        [7783] = { -- Loramus Thalipedes
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{39.36,35.78}}},
        },
        [15898] = { -- Lunar Festival Vendor
            [npcKeys.spawns] = {
                [zoneIDs.THUNDER_BLUFF] = {{70.56,27.83}},
                [zoneIDs.UNDERCITY] = {{66.45,36.02}},
                [zoneIDs.MOONGLADE] = {{36.58,58.1},{36.3,58.53}},
                [zoneIDs.SHATTRATH_CITY] = {{52.63,33.25},{48.64,36.29}},
                [zoneIDs.SILVERMOON_CITY] = {{73.41,82.17}},
                [zoneIDs.DALARAN] = {{47.93,43.32}},
            },
        },
        [23537] = { -- Headless Horseman - Fire (DND)
            [npcKeys.spawns] = {
                [zoneIDs.TIRISFAL_GLADES] = {{56.98,53.02},{56.84,53.36},{56.67,53.21},{56.44,53.33},{56.32,53.05}},
                [zoneIDs.DUROTAR] = {{49.28,43.08},{49.24,42.9},{49.1,42.99},{49.16,43.16},{49.3,43.41}},
                [zoneIDs.EVERSONG_WOODS] = {{46.25,55.3},{46.36,55.33},{46.49,55.34},{46.55,55.19},{46.61,55.02}},
            },
        },
        [24108] = { -- Self-Turning and Oscillating Utility Target
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{41.74,17.2}}},
        },
        [24202] = { -- [DND] Brewfest Barker Bunny 1
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{51.41,78.7}}},
        },
        [24203] = { -- [DND] Brewfest Barker Bunny 2
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{67.64,47.83}}},
        },
        [24204] = { -- [DND] Brewfest Barker Bunny 3
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{44.18,48.95}}},
        },
        [24205] = { -- [DND] Brewfest Barker Bunny 4
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{37.68,75.58}}},
        },
        [26221] = { -- Earthen Ring Elder
            [npcKeys.spawns] = {
                [zoneIDs.TIRISFAL_GLADES] = {{62.01,67.92}},
                [zoneIDs.ORGRIMMAR] = {{47.26,37.89}},
                [zoneIDs.THUNDER_BLUFF] = {{21.21,24.06}},
                [zoneIDs.SHATTRATH_CITY] = {{60.68,30.62}},
                [zoneIDs.SILVERMOON_CITY] = {{68.67,42.94}},
            },
        },
        --[[[34806] = { -- Spirit of Sharing
            [npcKeys.name] = "Spirit of Sharing",
            [npcKeys.spawns] = {
                [zoneIDs.STORM_PEAKS] = {{40.38,85.5}},
                [zoneIDs.ZUL_DRAK] = {{41.2,68.25}},
                [zoneIDs.GRIZZLY_HILLS] = {{22.43,65.94}},
                [zoneIDs.HOWLING_FJORD] = {{49.14,13.05}},
                [zoneIDs.DRAGONBLIGHT] = {{37.25,47.11}},
                [zoneIDs.BOREAN_TUNDRA] = {{40.95,52.44},{40.62,52.88}},
                [zoneIDs.SHOLAZAR_BASIN] = {{47.59,60.92}},
                [zoneIDs.SHATTRATH_CITY] = {{43.42,51.93},{43.17,50.29},{42.96,48.61},{42.7,46.84}},
                [zoneIDs.SHADOWMOON_VALLEY] = {{29.97,28.77}},
                [zoneIDs.NAGRAND] = {{56.65,33.94}},
                [zoneIDs.ZANGARMARSH] = {{32.75,51.19}},
                [zoneIDs.BLADES_EDGE_MOUNTAINS] = {{52.28,54.96}},
                [zoneIDs.NETHERSTORM] = {{33.9,64.43}},
                [zoneIDs.HELLFIRE_PENINSULA] = {{56.44,38.39},{56.02,37.74}},
                [zoneIDs.WINTERSPRING] = {{60.26,36.41}},
                [zoneIDs.TANARIS] = {{51.95,25.55}},
                [zoneIDs.SILITHUS] = {{51.89,37.71}},
                [zoneIDs.FERALAS] = {{74.88,43.33}},
                [zoneIDs.THOUSAND_NEEDLES] = {{45.54,51.59}},
                [zoneIDs.STRANGLETHORN_VALE] = {{32.35,28.3}},
                [zoneIDs.SWAMP_OF_SORROWS] = {{46.2,56.66}},
                [zoneIDs.BURNING_STEPPES] = {{63.96,31.66}},
                [zoneIDs.BADLANDS] = {{5.02,48.98}},
                [zoneIDs.ARATHI_HIGHLANDS] = {{74.86,36.88}},
                [zoneIDs.HILLSBRAD_FOOTHILLS] = {{61.03,20.84}},
                [zoneIDs.THE_HINTERLANDS] = {{79,80.76}},
                [zoneIDs.EASTERN_PLAGUELANDS] = {{74.11,52.14}},
                [zoneIDs.DUROTAR] = {{46.32,14.58},{46.37,15.08},{46.66,15.02},{46.64,14.58},{52.98,43.89},{52.99,43.54}},
                [zoneIDs.GHOSTLANDS] = {{44.85,30.98}},
                [zoneIDs.EVERSONG_WOODS] = {{55.65,53.15},{55.61,53.53},{55.3,53.18},{55.29,53.64},{46.52,46.64},{46.5,46.94},{46.46,47.27}},
                [zoneIDs.UNDERCITY] = {{64.1,14.23},{67.82,14.3},{67.98,7.85},{64.37,7.86}},
                [zoneIDs.TIRISFAL_GLADES] = {{58.81,51.17},{59.12,51.21},{59.38,51.26}},
                [zoneIDs.SILVERPINE_FOREST] = {{44.33,42.33}},
                [zoneIDs.THUNDER_BLUFF] = {{29.83,62.24},{31.24,66.99},{30.21,67.43},{28.76,62.4}},
                [zoneIDs.MULGORE] = {{46.43,59.57},{46.23,59.77}},
                [zoneIDs.THE_BARRENS] = {{51.52,29.52},{51.62,29.42},{62.48,38.22}},
                [zoneIDs.STONETALON_MOUNTAINS] = {{46.25,59.98}},
                [zoneIDs.ASHENVALE] = {{73.9,60.47}},
                [zoneIDs.DUSTWALLOW_MARSH] = {{35.68,31.53}},
                [zoneIDs.DESOLACE] = {{25.41,72.09}},
            },
        },
        [37214] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{40.3,15.8},{40.1,15.5},{40.5,15.5},{40.5,15.2},{40.3,15.0}}},
        },
        [37917] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST] = {{55.2,61.0},{55.3,62.0},{54.9,63.1},{54.6,62.3}}},
        },]]
        [29579] = { -- Brann Bronzebeard
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{36.62,49.27}}},
        },
        [34907] = { -- Kvaldir Harpooner
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING] = {{43.43,53.57},{43.1,53.5},{42.94,53.83},{43.92,54.36},{44.07,54.44},{43.82,54.64},{42.62,53.3},{42.85,53.33},{44.23,54.41},{43.36,53.87}}},
        },
        [34947] = { -- Kvaldir Berserker
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING] = {{43.43,53.57},{43.1,53.5},{42.94,53.83},{43.92,54.36},{44.07,54.44},{43.82,54.64},{42.62,53.3},{42.85,53.33},{44.23,54.41},{43.36,53.87}}},
        },
        [35060] = { -- North Sea Thresher
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35061] = { -- North Sea Blue Shark
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35071] = { -- North Sea Mako
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [37715] = { -- Snivel Rustrocket
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{51.66,56.75}}},
        },
        [37984] = { -- Crown Duster
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{33.33,58.2},{33.78,57.52},{34.02,57.36},{34.09,58.03},{34.39,57.9},{34.89,58.18},{34.63,58.19},{34.26,58.86},{33.72,58.19},{33.5,58.69},{33.58,59.36},{34.24,59.29},{34.52,59.58},{34.89,58.98},{35.1,58.43}}},
        },
        [38340] = { -- [DND] Holiday - Love - Bank Bunny
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{49.3,81.99}}},
        },
        [38341] = { -- [DND] Holiday - AH - Bank Bunny
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{52.91,74.82}}},
        },
        [38342] = { -- [DND] Holiday - Barber - Bank Bunny
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{40.61,60.74}}},
        },
        [39237] = { -- x3 JC Quest Stardust Applied
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{72.5,36.2}}},
        },
        [41600] = { -- Erunak Stonespeaker
            [npcKeys.spawns] = {
                [zoneIDs.ABYSSAL_DEPTHS] = {
                    {51.57,60.9,phases.VASHJIR_ERANUK_AT_CAVERN},
                    {42.69,37.91,phases.VASHJIR_ERANUK_AT_PROMONTORY_POINT},
                },
            },
        },
        [41814] = { -- Merciless One in Control of You
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{51.49,60.85}}},
        },
        [42486] = { -- Boarding Submarine Credit Bunny
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{50.72,66.47}}},
        },
        [42790] = { -- Bloodlord Mandokir
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{38.4,48.6}}},
        },
        [48416] = { -- Ozumat
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{53.83,61.91}}},
        },
        [52234] = { -- Bwemba
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{64.3,39.7}}},
        },
        [52762] = { -- [DND] At the Digsite
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{35.13,29.33}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
        },
        [53422] = { -- Dragonwrath, Tarecgosa's Rest
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{48.27,71.74}}},
        },
        [54114] = { -- Unleashed Void
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{65.77,74.8}}},
        },
    }

    local npcFixesAlliance = {
        [7783] = { -- Loramus Thalipedes
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{62.31,26.09}}},
        },
        [15898] = { -- Lunar Festival Vendor
            [npcKeys.spawns] = {
                [zoneIDs.ELWYNN_FOREST] = {{34.81,50.33}},
                [zoneIDs.IRONFORGE] = {{29.92,14.21}},
                [zoneIDs.DARNASSUS] = {{39.93,30.82}},
                [zoneIDs.MOONGLADE] = {{36.58,58.1},{36.3,58.53}},
                [zoneIDs.SHATTRATH_CITY] = {{52.63,33.25},{48.64,36.29}},
                [zoneIDs.THE_EXODAR] = {{74.02,58.23}},
                [zoneIDs.DALARAN] = {{47.93,43.32}},
            },
        },
        [23537] = { -- Headless Horseman - Fire (DND)
            [npcKeys.spawns] = {
                [zoneIDs.ELWYNN_FOREST] = {{42.63,60},{42.39,59.71},{42.55,59.3},{42.74,59.34},{42.9,59.36}},
                [zoneIDs.DUN_MOROGH] = {{54.42,55.31},{54.54,55.48},{54.41,55.51},{54.43,55.75},{54.3,55.64}},
                [zoneIDs.AZUREMYST_ISLE] = {{43.44,51.52},{43.79,51.92},{43.64,52.07},{43.5,51.92},{43.35,51.74}},
            },
        },
        [24108] = { -- Self-Turning and Oscillating Utility Target
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{54.8,37.54}}},
        },
        [24202] = { -- [DND] Brewfest Barker Bunny 1
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{30.2,66.5}}},
        },
        [24203] = { -- [DND] Brewfest Barker Bunny 2
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{64,78.2}}},
        },
        [24204] = { -- [DND] Brewfest Barker Bunny 3
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{64.3,24.3}}},
        },
        [24205] = { -- [DND] Brewfest Barker Bunny 4
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{32.2,21}}},
        },
        [26221] = { -- Earthen Ring Elder
            [npcKeys.spawns] = {
                [zoneIDs.DARNASSUS] = {{62.11,49.13}},
                [zoneIDs.SHATTRATH_CITY] = {{60.68,30.62}},
                [zoneIDs.IRONFORGE] = {{65.14,27.71}},
                [zoneIDs.STORMWIND_CITY] = {{49.31,72.29}},
                [zoneIDs.THE_EXODAR] = {{43.27,26.26}},
            },
        },
        --[[[34806] = { -- Spirit of Sharing
            [npcKeys.name] = "Spirit of Sharing",
            [npcKeys.spawns] = {
                [zoneIDs.STORM_PEAKS] = {{40.38,85.5}},
                [zoneIDs.ZUL_DRAK] = {{41.2,68.25}},
                [zoneIDs.GRIZZLY_HILLS] = {{31.3,59.59}},
                [zoneIDs.HOWLING_FJORD] = {{60.45,16.74}},
                [zoneIDs.DRAGONBLIGHT] = {{77.78,50.85}},
                [zoneIDs.BOREAN_TUNDRA] = {{56.93,67.48},{56.92,67.82}},
                [zoneIDs.SHOLAZAR_BASIN] = {{47.59,60.92}},
                [zoneIDs.SHATTRATH_CITY] = {{43.42,51.93},{43.17,50.29},{42.96,48.61},{42.7,46.84}},
                [zoneIDs.SHADOWMOON_VALLEY] = {{37.78,55.62}},
                [zoneIDs.NAGRAND] = {{54.03,75.49}},
                [zoneIDs.ZANGARMARSH] = {{67.72,51.16}},
                [zoneIDs.BLADES_EDGE_MOUNTAINS] = {{37.9,61.97}},
                [zoneIDs.NETHERSTORM] = {{33.9,64.43}},
                [zoneIDs.HELLFIRE_PENINSULA] = {{55.07,63.22},{56.45,63.92}},
                [zoneIDs.THE_EXODAR] = {{75.74,52.29},{75.75,50.51},{76.95,51.26},{77.21,53.08}},
                [zoneIDs.AZUREMYST_ISLE] = {{51.71,52.11},{51.69,51.14}},
                [zoneIDs.BLOODMYST_ISLE] = {{56.03,58.75}},
                [zoneIDs.DARKSHORE] = {{36.91,43.65}},
                [zoneIDs.WINTERSPRING] = {{62.17,37.03}},
                [zoneIDs.DARNASSUS] = {{69.56,38.23},{67.85,38.08},{67.81,36.09},{69.47,36.08}},
                [zoneIDs.TELDRASSIL] = {{56.44,58.4},{56.36,56.92}},
                [zoneIDs.TANARIS] = {{51.2,29.42}},
                [zoneIDs.SILITHUS] = {{51.89,37.71}},
                [zoneIDs.FERALAS] = {{29.96,43.41}},
                [zoneIDs.ELWYNN_FOREST] = {{34.33,51.18},{34.58,50.81},{34.81,50.45},{41.52,64.04},{41.43,64.65},{41.67,64.83}},
                [zoneIDs.DUN_MOROGH] = {{52.77,36.41},{52.76,36.74},{52.76,37.03},{46.69,55.41},{46.66,55.12},{46.64,54.75},{46.19,52.91}},
                [zoneIDs.WESTFALL] = {{53.21,52.61}},
                [zoneIDs.STRANGLETHORN_VALE] = {{37.87,3.78}},
                [zoneIDs.DUSKWOOD] = {{77.64,43.85}},
                [zoneIDs.BLASTED_LANDS] = {{66.54,23.66}},
                [zoneIDs.REDRIDGE_MOUNTAINS] = {{32.23,53.35}},
                [zoneIDs.BURNING_STEPPES] = {{85.83,69.78}},
                [zoneIDs.LOCH_MODAN] = {{32.16,48.4}},
                [zoneIDs.WETLANDS] = {{9.19,60.77},},
                [zoneIDs.ARATHI_HIGHLANDS] = {{46,45.97}},
                [zoneIDs.HILLSBRAD_FOOTHILLS] = {{49.61,61.05}},
                [zoneIDs.THE_HINTERLANDS] = {{13.91,46.87}},
                [zoneIDs.EASTERN_PLAGUELANDS] = {{74.81,54.22}},
                [zoneIDs.WESTERN_PLAGUELANDS] = {{43.73,84.72}},
                [zoneIDs.THE_BARRENS] = {{62.64,38.23}},
                [zoneIDs.DUSTWALLOW_MARSH] = {{68,50.78}},
                [zoneIDs.DESOLACE] = {{65.19,8.73}},
                [zoneIDs.ASHENVALE] = {{35.26,50.41}},
            },
        },
        [37214] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST] = {{29.1,66.5},{28.8,66.2},{29.5,65.7},{28.8,65.7},{29.2,65.2}}},
        },]]
        [29579] = { -- Brann Bronzebeard
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{30.1,73.9}}},
        },
        [34907] = { -- Kvaldir Harpooner
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING] = {{50.21,49.08},{50.14,49.47},{49.75,49.51},{50.06,49.08},{50.63,48.98},{51.18,48.81},{50.43,49.05},{49.9,49.59},{50.3,49.61},{51,48.53}}},
        },
        [34947] = { -- Kvaldir Berserker
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING] = {{50.21,49.08},{50.14,49.47},{49.75,49.51},{50.06,49.08},{50.63,48.98},{51.18,48.81},{50.43,49.05},{49.9,49.59},{50.3,49.61},{51,48.53}}},
        },
        [35060] = { -- North Sea Thresher
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35061] = { -- North Sea Blue Shark
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35071] = { -- North Sea Mako
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [37715] = { -- Snivel Rustrocket
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{27.43,34.83}}},
        },
        [37917] = { -- Crown Thug
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE] = {{44.14,78.16},{44.25,77.89},{44.05,76.85},{44.45,77.31},{44.24,77.52},{44.08,77.41},{43.82,77.39},{43.97,77.78},{43.82,78.18},{44.01,78.57},{44.32,78.54},{44.7,78.26},{44.49,78.09},{44.68,77.6}}},
        },
        [37984] = { -- Crown Duster
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{76.82,57.21},{77.56,55.72},{78.01,54.3},{77.98,53.45},{77.43,52.17},{77.02,52.95},{76.67,53.68},{76.2,52.75},{75.82,51.86},{75.46,52.83},{75.61,53.77},{75.63,54.5},{75.76,55.79},{75.37,56.55}}},
        },
        [38340] = { -- [DND] Holiday - Love - Bank Bunny
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{63.02,78.73}}},
        },
        [38341] = { -- [DND] Holiday - AH - Bank Bunny
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{61.39,71.61}}},
        },
        [38342] = { -- [DND] Holiday - Barber - Bank Bunny
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{61.32,65.57}}},
        },
        [39237] = { -- x3 JC Quest Stardust Applied
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{63.8,60.8}}},
        },
        [41600] = { -- Erunak Stonespeaker
            [npcKeys.spawns] = {
                [zoneIDs.ABYSSAL_DEPTHS] = {
                    {55.71,72.98,phases.VASHJIR_ERANUK_AT_CAVERN},
                    {42.69,37.91,phases.VASHJIR_ERANUK_AT_PROMONTORY_POINT},
                },
            },
        },
        [41814] = { -- Merciless One in Control of You
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{55.51,72.9}}},
        },
        [42486] = { -- Boarding Submarine Credit Bunny
            [npcKeys.spawns] = {[zoneIDs.SHIMMERING_EXPANSE] = {{56.68,76.62}}},
        },
        [42790] = { -- Bloodlord Mandokir
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{47.2,10.6}}},
        },
        [48416] = { -- Ozumat
            [npcKeys.spawns] = {[zoneIDs.ABYSSAL_DEPTHS] = {{55.83,76.21}}},
        },
        [52234] = { -- Bwemba
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{52.82,66.71}}},
        },
        [52762] = { -- [DND] At the Digsite
            [npcKeys.spawns] = {[zoneIDs.THE_CAPE_OF_STRANGLETHORN] = {{55.5,41.26}}},
            [npcKeys.zoneID] = zoneIDs.THE_CAPE_OF_STRANGLETHORN,
        },
        [53422] = { -- Dragonwrath, Tarecgosa's Rest
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{57.24,59.26}}},
        },
        [54114] = { -- Unleashed Void
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{55.39,43.41}}},
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return npcFixesHorde
    else
        return npcFixesAlliance
    end
end
