---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- If you want to add something to uiMapIdToAreaId overwrite the data in this table.
--- We map continent zone to 0, because they can be returned from C_Map.GetBestMapForUnit("player") when
--- the player is in a cave for example.
---@type table<AreaId, UiMapId>
ZoneDB.private.uiMapIdToAreaIdOverride = [[return {
    [113] = 0, -- Northrend
    [1414] = 10073, -- Kalimdor - the continent map
    [1415] = 10074, -- Eastern Kingdoms - the continent map
    [947] = 10089, -- Azeroth - the world map
    [1945] = 0, -- Outland
    [246] = 3713, -- The Blood Furnace
    [174] = 4720, -- The Lost Isles
    [370] = 5786, -- The Nexus Legendary

    [281] = 10000, -- Maraudon - Zaetar's Grave (fake ID for Maraudon)
    [318] = 10001, -- Stratholme - The Gauntlet (fake ID for Stratholme)
    [243] = 10002, -- Blackrock Depths - Shadowforge City (fake ID for Blackrock Depths)
    [250] = 10003, -- Blackrock Spire - Tazz'Alor (fake ID for Blackrock Spire)
    [251] = 10004, -- Blackrock Spire - Skitterweb Tunnels (fake ID for Blackrock Spire)
    [252] = 10005, -- Blackrock Spire - Hordemar City (fake ID for Blackrock Spire)
    [254] = 10006, -- Blackrock Spire - Halycon's Lair (fake ID for Blackrock Spire)
    [255] = 10007, -- Blackrock Spire - Chamber of Battle (fake ID for Blackrock Spire)
    [303] = 10008, -- Scarlet Monastery - Library (fake ID for Scarlet Monastery)
    [304] = 10009, -- Scarlet Monastery - Armory (fake ID for Scarlet Monastery)
    [305] = 10010, -- Scarlet Monastery - Cathedral (fake ID for Scarlet Monastery)
    [307] = 10011, -- Scholomance - Chamber of Summoning (fake ID for Scholomance)
    [308] = 10012, -- Scholomance - The Upper Study (fake ID for Scholomance)
    [309] = 10013, -- Scholomance - Headmaster's Study (fake ID for Scholomance)
    [311] = 10014, -- Shadowfang Keep - Dining Hall (fake ID for Shadowfang Keep)
    [312] = 10015, -- Shadowfang Keep - The Vacant Den (fake ID for Shadowfang Keep)
    [313] = 10016, -- Shadowfang Keep - Lower Observatory (fake ID for Shadowfang Keep)
    [314] = 10017, -- Shadowfang Keep - Upper Observatory (fake ID for Shadowfang Keep)
    [315] = 10018, -- Shadowfang Keep - Lord Godfrey's Chamber (fake ID for Shadowfang Keep)
    [316] = 10019, -- Shadowfang Keep - The Wall Walk (fake ID for Shadowfang Keep)
    [235] = 10022, -- Dire Maul - Gordok Commons (fake ID for Dire Maul North)
    [236] = 10023, -- Dire Maul - Capital Gardens (fake ID for Dire Maul West)
    [237] = 10024, -- Dire Maul - Court of the Highborne (fake ID for Dire Maul West)
    [238] = 10025, -- Dire Maul - Prison of Immol'Thar (fake ID for Dire Maul West)
    [239] = 10026, -- Dire Maul - Warpwood Quarter (fake ID for Dire Maul East)
    [240] = 10027, -- Dire Maul - The Shrine of Eldretharr (fake ID for Dire Maul East)
    [348] = 10028, -- Magisters' Terrace - Grand Magister's Asylum (fake ID for Magisters' Terrace)
    [292] = 10029, -- The Deadmines - Dungeon - Ironclad Cove (fake ID for The Deadmines)
    [222] = 10020, -- Blackfathom Deeps - Moonshrine Sanctum
    [223] = 10021, -- Blackfathom Deeps - The Forgotten Pool
    [227] = 10030, -- Gnomeregan - Dungeon - The Dormitory
    [228] = 10031, -- Gnomeregan - Dungeon - Launch Bay
    [229] = 10032, -- Gnomeregan - Dungeon - Tinkers' Court
    [231] = 10033, -- Uldaman - Dungeon - Khaz'Goroth's Seat
    [400] = 10039, -- Hour of Twilight - Wyrmrest Temple
    [319] = 10040, -- Ahn'Qiraj - Raid - The Hive Undergrounds
    [321] = 10041, -- Ahn'Qiraj - Raid - Vault of C'thun
    [259] = 10042, -- Sethekk Halls - Dungeon - Halls of Mourning
    [257] = 10043, -- Auchenai Crypts - Dungeon - Bridge of Souls
    [268] = 10044, -- The Mechanar - Dungeon - Calculation Chamber
    [270] = 10045, -- The Arcatraz - Dungeon - Stasis Block: Maximus
    [271] = 10046, -- The Arcatraz - Dungeon - Containment Core
    [144] = 10047, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
    [145] = 10048, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
    [146] = 10049, -- The Oculus - Band of Alignment (fake ID for The Oculus)
    [149] = 10052, -- Ulduar - The Inner Sanctum of Ulduar (fake ID for Ulduar)
    [150] = 10050, -- Ulduar - The Descent of Madness (fake ID for Ulduar)
    [151] = 10051, -- Ulduar - The Spark of Imagination (fake ID for Ulduar)
    [136] = 10053, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
    [139] = 10054, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
    [157] = 10055, -- Azjol-Nerub - The Brood Pit (fake ID for Azjol-Nerub)
    [158] = 10056, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
    [134] = 10057, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
    [135] = 10058, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
    [131] = 10059, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
    [161] = 10060, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
    [153] = 10061, -- Gundrak - Lower Level (fake ID for Gundrak) -- does not exist in Cata+
    [162] = 10062, -- Naxxramas - Construct Quarter (fake ID for Naxxramas)
    [163] = 10063, -- Naxxramas - Arachnid Quarter (fake ID for Naxxramas)
    [164] = 10064, -- Naxxramas - Military Quarter (fake ID for Naxxramas)
    [165] = 10065, -- Naxxramas - Plague Quarter (fake ID for Naxxramas)
    [167] = 10066, -- Naxxramas - Frostwyrm Lair (fake ID for Naxxramas)
    [187] = 10067, -- Icecrown Citadel - Rampart of Skulls (fake ID for ICC)
    [188] = 10068, -- Icecrown Citadel - Deathbringer's Rise (fake ID for ICC)
    [189] = 10069, -- Icecrown Citadel - Sindragosa (fake ID for ICC)
    [190] = 10070, -- Icecrown Citadel - Upper Spire (fake ID for ICC)
    [191] = 10071, -- Icecrown Citadel - Queen Lana'thel (fake ID for ICC)
    [192] = 10072, -- Icecrown Citadel - The Frozen Throne (fake ID for ICC)
    [350] = 10102, -- Karazhan - Servant's Quarters (Dungeon/Raid)
    [351] = 10103, -- Karazhan - Upper Livery Stables (Dungeon/Raid)
    [352] = 10104, -- Karazhan - The Banquet Hall (Dungeon/Raid)
    [353] = 10105, -- Karazhan - The Guest Chambers (Dungeon/Raid)
    [354] = 10106, -- Karazhan - Opera Hall Balcony (Dungeon/Raid)
    [355] = 10107, -- Karazhan - Master's Terrace (Dungeon/Raid)
    [356] = 10108, -- Karazhan - Lower Broken Stair (Dungeon/Raid)
    [357] = 10109, -- Karazhan - Upper Broken Stair (Dungeon/Raid)
    [358] = 10110, -- Karazhan - The Menagerie (Dungeon/Raid)
    [359] = 10111, -- Karazhan - Guardian's Library (Dungeon/Raid)
    [360] = 10112, -- Karazhan - The Repository (Dungeon/Raid)
    [361] = 10113, -- Karazhan - Upper Library (Dungeon/Raid)
    [362] = 10114, -- Karazhan - The Celestial Watch (Dungeon/Raid)
    [363] = 10115, -- Karazhan - Gamesman's Hall (Dungeon/Raid)
    [364] = 10116, -- Karazhan - Medivh's Chambers (Dungeon/Raid)
    [365] = 10117, -- Karazhan - The Power Station (Dungeon/Raid)
    [366] = 10118, -- Karazhan - Netherspace (Dungeon/Raid)
}]]

--- This table is generated by the generate_zone_tables.py script - use the table above to add new entries.
--- This table is the inverse of areaIdToUiMapId, without duplicated uiMapId entries.
---@type table<UiMapId, AreaId>
ZoneDB.private.uiMapIdToAreaId = [[return {
    [1426] = 1, -- Dun Morogh
    [1418] = 3, -- Badlands
    [1419] = 4, -- Blasted Lands
    [1435] = 8, -- Swamp of Sorrows
    [1431] = 10, -- Duskwood
    [1437] = 11, -- Wetlands
    [1429] = 12, -- Elwynn Forest
    [1411] = 14, -- Durotar
    [1445] = 15, -- Dustwallow Marsh
    [1447] = 16, -- Azshara
    [1413] = 17, -- The Barrens
    [1422] = 28, -- Western Plaguelands
    [1434] = 33, -- Stranglethorn Vale
    [1416] = 36, -- Alterac Mountains
    [1432] = 38, -- Loch Modan
    [1436] = 40, -- Westfall
    [1430] = 41, -- Deadwind Pass
    [1433] = 44, -- Redridge Mountains
    [1417] = 45, -- Arathi Highlands
    [1428] = 46, -- Burning Steppes
    [1425] = 47, -- The Hinterlands
    [1427] = 51, -- Searing Gorge
    [115]  = 65, -- Dragonblight
    [121]  = 66, -- Zul'Drak
    [120]  = 67, -- The Storm Peaks
    [1420] = 85, -- Tirisfal Glades
    [1421] = 130, -- Silverpine Forest
    [1423] = 139, -- Eastern Plaguelands
    [1438] = 141, -- Teldrassil
    [1439] = 148, -- Darkshore
    [310]  = 209, -- Shadowfang Keep - Dungeon - The Courtyard
    [118]  = 210, -- Icecrown
    [1412] = 215, -- Mulgore
    [1424] = 267, -- Hillsbrad Foothills
    [1440] = 331, -- Ashenvale
    [1444] = 357, -- Feralas
    [1448] = 361, -- Felwood
    [116]  = 394, -- Grizzly Hills
    [1441] = 400, -- Thousand Needles
    [1443] = 405, -- Desolace
    [1442] = 406, -- Stonetalon Mountains
    [1446] = 440, -- Tanaris
    [1449] = 490, -- Un'Goro Crater
    [301]  = 491, -- Razorfen Kraul - Dungeon
    [1450] = 493, -- Moonglade
    [117]  = 495, -- Howling Fjord
    [1452] = 618, -- Winterspring
    [225]  = 717, -- The Stockade - Dungeon
    [279]  = 718, -- Wailing Caverns - Dungeon
    [221]  = 719, -- Blackfathom Deeps - Dungeon - The Pool of Ask'Ar
    [226]  = 721, -- Gnomeregan - Dungeon - The Hall of Gears
    [300]  = 722, -- Razorfen Downs - Dungeon
    [302]  = 796, -- Scarlet Monastery - Dungeon -- Graveyard
    [219]  = 1176, -- Zul'Farrak - Dungeon
    [230]  = 1337, -- Uldaman - Dungeon - Hall of the Explorers
    [1451] = 1377, -- Silithus
    [220]  = 1477, -- The Temple of Atal'Hakkar - Dungeon
    [1458] = 1497, -- Undercity
    [1453] = 1519, -- Stormwind City
    [1455] = 1537, -- Ironforge
    [291]  = 1581, -- The Deadmines - Dungeon -- The Deadmines
    [253]  = 1583, -- Blackrock Spire - Dungeon -- Hall of Blackhand
    [242]  = 1584, -- Blackrock Depths - Dungeon -- Detention Block
    [1454] = 1637, -- Orgrimmar
    [1456] = 1638, -- Thunder Bluff
    [1457] = 1657, -- Darnassus
    [233]  = 1977, -- Zul'Gurub - Raid
    [337]  = 1977, -- Zul'Gurub - Raid
    [317]  = 2017, -- Stratholme - Dungeon - Crusader's Square
    [280]  = 2100, -- Maraudon - Dungeon - Caverns of Maraudon
    [248]  = 2159, -- Onyxia's Lair - Dungeon?
    [273]  = 2366, -- The Black Morass - Dungeon
    [274]  = 2367, -- Old Hillsbrad Foothills - Dungeon
    [213]  = 2437, -- Ragefire Chasm - Dungeon
    [234]  = 2557, -- Dire Maul - Dungeon - "default" id with no actual map. The long tunnel.
    [1459] = 2597, -- Alterac Valley - Battleground
    [287]  = 2677, -- Blackwing Lair - Raid
    [288]  = 2677, -- Blackwing Lair - Raid
    [289]  = 2677, -- Blackwing Lair - Raid
    [290]  = 2677, -- Blackwing Lair - Raid
    [232]  = 2717, -- Molten Core - Raid
    [127]  = 2817, -- Crystalsong Forest
    [1460] = 3277, -- Warsong Gulch - Battleground
    [1461] = 3358, -- Arathi Basin - Battleground
    [320]  = 3428, -- Ahn'Qiraj - Raid - The Temple Gates
    [247]  = 3429, -- Ruins of Ahn'Qiraj - Raid
    [1941] = 3430, -- Eversong Woods
    [1942] = 3433, -- Ghostlands
    [1944] = 3483, -- Hellfire Peninsula
    [1954] = 3487, -- Silvermoon City
    [1951] = 3518, -- Nagrand
    [1952] = 3519, -- Terokkar Forest
    [1948] = 3520, -- Shadowmoon Valley
    [1946] = 3521, -- Zangarmarsh
    [1949] = 3522, -- Blade's Edge Mountains
    [1953] = 3523, -- Netherstorm
    [1943] = 3524, -- Azuremyst Isle
    [1950] = 3525, -- Bloodmyst Isle
    [114] = 3537, -- Borean Tundra
    [1947] = 3557, -- The Exodar
    [347] = 3562, -- Hellfire Ramparts - Dungeon
    [329] = 3606, -- Hyjal Summit - Raid
    [332] = 3607, -- Serpentshrine Cavern - Raid
    [1554] = 3607, -- Serpentshrine Cavern - Raid
    [1955] = 3703, -- Shattrath City
    [119] = 3711, -- Sholazar Basin
    [261] = 3713, -- The Blood Furnace - Dungeon
    [246] = 3714, -- The Shattered Halls - Dungeon
    [263] = 3715, -- The Steamvault - Dungeon
    [264] = 3715, -- The Steamvault - Dungeon
    [262] = 3716, -- The Underbog - Dungeon
    [265] = 3717, -- The Slave Pens - Dungeon
    [260] = 3789, -- Shadow Labyrinth - Dungeon
    [256] = 3790, -- Auchenai Crypts - Dungeon
    [258] = 3791, -- Sethekk Halls - Dungeon
    [259] = 3791, -- Sethekk Halls - Dungeon
    [272] = 3792, -- Mana-Tombs - Dungeon
    [333] = 3805, -- Zul'Aman - Raid
    [1956] = 3820, -- Eye of the Storm - Battleground
    [331] = 3836, -- Magtheridon's Lair - Raid
    [334] = 3845, -- Tempest Keep - Raid
    [1555] = 3845, -- Tempest Keep - Raid
    [266] = 3847, -- The Botanica - Dungeon
    [269] = 3848, -- The Arcatraz - Dungeon
    [267] = 3849, -- The Mechanar - Dungeon
    [330] = 3923, -- Gruul's Lair - Raid
    [339] = 3959, -- Black Temple - Raid
    [113] = 3979, -- The Frozen Sea
    [335] = 4075, -- Sunwell Plateau - Raid
    [336] = 4075, -- Sunwell Plateau - Raid
    [1957] = 4080, -- Isle of Quel'Danas
    [349] = 4131, -- Magisters' Terrace - Dungeon
    [123] = 4197, -- Wintergrasp
    [2104] = 4197, -- Wintergrasp
    [143] = 4228, -- The Oculus - Dungeon
    [1375] = 4264, -- Halls of Stone - Dungeon
    [129] = 4265, -- The Nexus - Dungeon
    [130] = 4100, -- The Culling of Stratholme
    [133] = 206, -- Utgarde Keep - Dungeon
    [137] = 1196, -- Utgarde Pinnacle - Dungeon
    [138] = 4272, -- Halls of Lightning - Dungeon
    [147] = 4273, -- Ulduar - Raid
    [152] = 4273, -- Ulduar - Raid
    [154] = 4416, -- Gundrak
    [159] = 4277, -- Azjol-Nerub
    [124] = 4298, -- Plaguelands: The Scarlet Enclave
    [128] = 4384, -- Strand of the Ancients - Battleground
    [125] = 4395, -- Dalaran - Dungeon?
    [168] = 4415, -- The Violet Hold - Dungeon
    [132] = 4494, -- Ahn'kahet: The Old Kingdom - Dungeon
    [155] = 4493, -- The Obsidian Sanctum - Raid
    [140] = 4264, -- Halls of Stone - Dungeon
    [141] = 4500, -- The Eye of Eternity - Raid
    [126] = 4560, -- The Underbelly - Sub zone of Dalaran
    [156] = 4603, -- Vault of Archavon - Raid
    [148] = 4657, -- Ulduar - The Antechamber of Ulduar
    [160] = 4196, -- Drak'Tharon Keep - Dungeon
    [166] = 3456, -- Naxxramas - Raid
    [169] = 4710, -- Isle of Conquest - Battleground
    [172] = 4722, -- Trial of the Crusader - Raid
    [173] = 4722, -- Trial of the Crusader - Raid
    [171] = 4723, -- Trial of the Champion - Dungeon
    [170] = 4742, -- Hrothgar's Landing
    [183] = 4809, -- The Forge of Souls - Dungeon
    [184] = 4813, -- Pit of Saron - Dungeon
    [185] = 4820, -- Halls of Reflection - Dungeon
    [186] = 4812, -- Icecrown Citadel - Raid
    [193] = 4812, -- Icecrown Citadel - Raid
    [200] = 4987, -- The Ruby Sanctum - Raid
    [401] = 5789, -- End Time
    [402] = 5793, -- End Time - Dungeon - Azure Dragonshrine
    [403] = 5790, -- End Time - Dungeon - Ruby Dragonshrine
    [404] = 5792, -- End Time - Dungeon - Obsidian Dragonshrine
    [405] = 5794, -- End Time - Dungeon - Emerald Dragonshrine
    [406] = 5795, -- End Time - Dungeon - Bronze Dragonshrine

    -- TODO: Sort these in
    [194] = 4737, -- Kezan
    [199] = 4709, -- Southern Barrens
    [210] = 5287, -- The Cape of Stranglethorn
    [179] = 4714, -- Gilneas
    --[349] = 4095, -- Magisters' Terrace
    [293] = 1037, -- Grim Batol
    [294] = 5334, -- The Bastion of Twilight
    [295] = 5334, -- The Bastion of Twilight
    [296] = 5334, -- The Bastion of Twilight
    [297] = 4945, -- Halls of Origination
    [298] = 4945, -- Halls of Origination
    [299] = 4945, -- Halls of Origination
    [286] = 5094, -- Blackwing Descent
    [285] = 5094, -- Blackwing Descent
    [284] = 4926, -- Blackrock Caverns
    [367] = 5723, -- Firelands
    [368] = 5723, -- Firelands
    [369] = 5723, -- Firelands
    [370] = 4120, -- The Nexus
    [283] = 4926, -- Blackrock Caverns
    [245] = 5389, -- Tol Barad Peninsula
    [282] = 5399, -- Baradin Hold
    [244] = 5095, -- Tol Barad
    [174] = 4707, -- The Lost Isles
    [241] = 4922, -- Twilight Highlands
    [275] = 5449, -- The Battle for Gilneas
    [218] = 5351, -- Ruins of Gilneas City
    [217] = 4706, -- Ruins of Gilneas
    [205] = 5144, -- Shimmering Expanse
    [224] = 5339, -- Stranglethorn Vale
    [203] = 5146, -- Vashj'ir
    [204] = 5145, -- Abyssal Depths
    [201] = 4815, -- Kelp'thar Forest
    [322] = 5004, -- Throne of the Tides
    [323] = 5004, -- Throne of the Tides
    [324] = 5088, -- The Stonecore
    [325] = 5035, -- The Vortex Pinnacle
    [202] = 4755, -- Gilneas City
    [327] = 5695, -- Ahn'Qiraj: The Fallen Kingdom
    [328] = 5638, -- Throne of the Four Winds
    [198] = 616, -- Mount Hyjal
    [410] = 5892, -- Dragon Soul
    [398] = 5788, -- Well of Eternity
    [399] = 5844, -- Hour of Twilight
    [338] = 5733, -- Molten Front
    [276] = 5416, -- The Maelstrom
    [277] = 5396, -- Lost City of the Tol'vir
    [407] = 5861, -- Darkmoon Island
    [206] = 5031, -- Twin Peaks
    [409] = 5892, -- Dragon Soul
    [207] = 5042, -- Deepholm
    [411] = 5892, -- Dragon Soul
    [412] = 5892, -- Dragon Soul
    [413] = 5892, -- Dragon Soul
    [414] = 5892, -- Dragon Soul
    [415] = 5892, -- Dragon Soul
    [249] = 5034, -- Uldum
    [306] = 2057, -- Scholomance - The Reliquary

    -- Starting areas
    [425] = 6170, -- Northshire
    [427] = 6176, -- Coldridge Valley
    [460] = 6450, -- Shadowglen
    [461] = 6451, -- Valley of Trials
    [462] = 6452, -- Camp Narache
    [463] = 6453, -- Echo Isles
    [465] = 6454, -- Deathknell
    [467] = 6455, -- Sunstrider Isle
    [468] = 6456, -- Ammen Vale
    [469] = 6457, -- New Tinkertown

    --[293] = 4950, -- Grim Batol
}]]
