---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local autoOptionsLocales = {
    ["Auto Complete Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests automatisch abschließen",
        ["esES"] = "Entregar misiones",
        ["esMX"] = "Entregar misiones",
        ["frFR"] = "Remettre des quêtes",
        ["koKR"] = "퀘스트 자동 완료",
        ["ptBR"] = "Entregar missões",
        ["ruRU"] = "Вкл/выкл",
        ["zhCN"] = "自动交回任务",
        ["zhTW"] = "自動回任務",
    },
    ["When enabled, Questie will automatically hand in finished quests when talking to NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn aktiviert, wird Questie automatisch Quests abgeben.",
        ["esES"] = "Si está activado, Questie entregará automáticamente las misiones completadas cuando hables con los PNJ.",
        ["esMX"] = "Si está activado, Questie entregará automáticamente las misiones completadas cuando hables con los PNJ.",
        ["frFR"] = "Si cette option est activée, Questie remettra automatiquement les quêtes terminées en parlant aux PNJ.",
        ["koKR"] = "활성화되면 Questie는 NPC와 대화할 때 완료된 퀘스트를 자동으로 제출합니다.",
        ["ptBR"] = "Se ativado, o Questie entregará automaticamente missões concluídas ao falar com NPCs.",
        ["ruRU"] = "Когда включено, задания будут завершаться автоматически при разговоре с NPC",
        ["zhCN"] = "启用后，与NPC对话时自动交回任务",
        ["zhTW"] = "啟用時，和 NPC 對話會自動交回已完成的任務。",
    },
    ["Auto Accept"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests automatisch annehmen",
        ["esES"] = "Aceptación automática",
        ["esMX"] = "Aceptación automática",
        ["frFR"] = "Acceptation automatique",
        ["koKR"] = "자동 수락",
        ["ptBR"] = "Aceitação automática",
        ["ruRU"] = "Автопринятие",
        ["zhCN"] = "自动接任务",
        ["zhTW"] = "自動接任務",
    },
    ["When enabled, Questie will automatically accept quest dialogs when they appear, depending on the rules below."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn aktiviert, wird Questie automatisch Quests annehmen, abhängig von den unten stehenden Regeln.",
        ["esES"] = "Si está activado, Questie aceptará automáticamente las misiones cuando aparezcan, dependiendo de las reglas a continuación.",
        ["esMX"] = "Si está activado, Questie aceptará automáticamente las misiones cuando aparezcan, dependiendo de las reglas a continuación.",
        ["frFR"] = "Si cette option est activée, Questie acceptera automatiquement les quêtes lorsqu'elles apparaissent, en fonction des règles ci-dessous.",
        ["koKR"] = "활성화되면 Questie는 아래 규칙에 따라 퀘스트 대화 상자가 나타날 때 자동으로 수락합니다.",
        ["ptBR"] = "Se ativado, Questie aceitará automaticamente as missões quando aparecerem, dependendo das regras abaixo.",
        ["ruRU"] = "Когда включено, задания будут приниматься автоматически в зависимости от правил ниже",
        ["zhCN"] = "启动后，会根据下列规则，在任务对话框出现时自动接任务",
        ["zhTW"] = "啟用時，會根據下方的規則，在任務對話框出現時自動接受任務。",
    },
    ["Rules for NPCs"] = {
        ["enUS"] = true,
        ["deDE"] = "Regeln für NPCs",
        ["esES"] = "Reglas para PNJ",
        ["esMX"] = "Reglas para PNJ",
        ["frFR"] = "Règles pour les PNJ",
        ["koKR"] = "NPC에 대한 규칙",
        ["ptBR"] = "Regras para NPCs",
        ["ruRU"] = "Правила для NPC",
        ["zhCN"] = "NPC接任务规则",
        ["zhTW"] = "NPC 相關規則",
    },
    ["Rules for players"] = {
        ["enUS"] = true,
        ["deDE"] = "Regeln für Spieler",
        ["esES"] = "Reglas para jugadores",
        ["esMX"] = "Reglas para jugadores",
        ["frFR"] = "Règles pour les joueurs",
        ["koKR"] = "플레이어에 대한 규칙",
        ["ptBR"] = "Regras para jogadores",
        ["ruRU"] = "Правила для игроков",
        ["zhCN"] = "玩家共享任务规则",
        ["zhTW"] = "玩家相關規則",
    },
    ["Automatically accept normal quests from NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "Normale Quests automatisch von NPCs annehmen.",
        ["esES"] = "Acepta automáticamente misiones normales de PNJ.",
        ["esMX"] = "Acepta automáticamente misiones normales de PNJ.",
        ["frFR"] = "Accepte automatiquement les quêtes normales des PNJ.",
        ["koKR"] = "NPC로부터 일반 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões normais de NPCs.",
        ["ruRU"] = "Автопринятие обычных заданий от NPC.",
        ["zhCN"] = "自动接受 NPC 提供的一般任务。",
        ["zhTW"] = "自動接受 NPC 提供的一般任務。",
    },
    ["Automatically accept repeatable quests (including dailies) from NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "Wiederholbare Quests (inkl. Dailies) automatisch von NPCs annehmen.",
        ["esES"] = "Acepta automáticamente misiones repetibles (incluidas las diarias) de PNJ.",
        ["esMX"] = "Acepta automáticamente misiones repetibles (incluidas las diarias) de PNJ.",
        ["frFR"] = "Accepte automatiquement les quêtes répétables (y compris les quêtes quotidiennes) des PNJ.",
        ["koKR"] = "NPC로부터 반복 가능한 퀘스트(일일 퀘스트 포함)를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões repetíveis (incluindo diárias) de NPCs.",
        ["ruRU"] = "Автопринятие повторяемых (включая ежедневные) заданий от NPC.",
        ["zhCN"] = "自动接受 NPC 提供的可重复任务（包括每日任务）。",
        ["zhTW"] = "自動接受 NPC 提供的可重複任務（包括每日任務）。",
    },
    ["Automatically accept dungeon and raid quests from NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "Instanz- und Raid Quests automatisch von NPCs annehmen.",
        ["esES"] = "Acepta automáticamente misiones de mazmorras y bandas de PNJ.",
        ["esMX"] = "Acepta automáticamente misiones de calabozos y bandas de PNJ.",
        ["frFR"] = "Accepte automatiquement les quêtes de donjons et de raids des PNJ.",
        ["koKR"] = "NPC로부터 던전 및 레이드 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões de masmorras e raides de NPCs.",
        ["ruRU"] = "Автопринятие заданий подземелий и рейдов от NPC.",
        ["zhCN"] = "自动接受 NPC 提供的地下城和团队副本任务。",
        ["zhTW"] = "自動接受 NPC 提供的地下城與團隊任務。",
    },
    ["Automatically accept PvP quests from NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "PvP Quests automatisch von NPCs annehmen.",
        ["esES"] = "Acepta automáticamente misiones de JcJ de PNJ.",
        ["esMX"] = "Acepta automáticamente misiones de JcJ de PNJ.",
        ["frFR"] = "Accepte automatiquement les quêtes JcJ des PNJ.",
        ["koKR"] = "NPC로부터 PvP 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões de JxJ de NPCs.",
        ["ruRU"] = "Автопринятие PVP-заданий от NPC.",
        ["zhCN"] = "自动接受 NPC 提供的 PvP 任务。",
        ["zhTW"] = "自動接受 NPC 提供的 PvP 任務。",
    },
    ["Automatically accept event quests (including event dailies) from NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "Event Quests (inkl. Event Dailies) automatisch von NPCs annehmen.",
        ["esES"] = "Acepta automáticamente misiones de eventos (incluidas las diarias de evento) de PNJ.",
        ["esMX"] = "Acepta automáticamente misiones de eventos (incluidas las diarias de evento) de PNJ.",
        ["frFR"] = "Accepte automatiquement les quêtes d’événement (y compris les quêtes quotidiennes d’événement) des PNJ.",
        ["koKR"] = "NPC로부터 이벤트 퀘스트(이벤트 일일 퀘스트 포함)를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões de eventos (incluindo diárias de evento) de NPCs.",
        ["ruRU"] = "Автопринятие заданий игровых событий (включая ежедневные) от NPC.",
        ["zhCN"] = "自动接受 NPC 提供的活动任务（包括活动每日任务）。",
        ["zhTW"] = "自動接受 NPC 提供的活動任務（包括活動每日任務）。",
    },
    ["Automatically accept trivial (low-level) quests from NPCs."] = {
        ["enUS"] = true,
        ["deDE"] = "Triviale (niedrigstufige) Quests automatisch von NPCs annehmen.",
        ["esES"] = "Acepta automáticamente misiones triviales (de bajo nivel) de PNJ.",
        ["esMX"] = "Acepta automáticamente misiones triviales (de bajo nivel) de PNJ.",
        ["frFR"] = "Accepte automatiquement les quêtes triviales (de bas niveau) des PNJ.",
        ["koKR"] = "NPC로부터 저레벨 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões triviais (de baixo nível) de NPCs.",
        ["ruRU"] = "Автопринятие простых (низкоуровневых) заданий от NPC",
        ["zhCN"] = "自动接受 NPC 提供的琐碎（低等级）任务。",
        ["zhTW"] = "自動接受來自 NPC 的低等級任務。",
    },
    ["Automatically accept normal quests from players."] = {
        ["enUS"] = true,
        ["deDE"] = "Normale Quests automatisch von Spielern annehmen.",
        ["esES"] = "Acepta automáticamente las misiones normales de los jugadores.",
        ["esMX"] = "Acepta automáticamente las misiones normales de los jugadores.",
        ["frFR"] = "Accepter automatiquement les quêtes normales des joueurs",
        ["koKR"] = "플레이어로부터 일반 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceitar automaticamente missões normais dos jogadores",
        ["ruRU"] = "Автопринятие обычных заданий от игроков",
        ["zhCN"] = "自动接受来自玩家的普通任务",
        ["zhTW"] = "自動接受來自玩家的一般任務。",
    },
    ["Automatically accept repeatable quests (including dailies) from players."] = {
        ["enUS"] = true,
        ["deDE"] = "Wiederholbare Quests (inkl. Dailies) automatisch von Spielern annehmen.",
        ["esES"] = "Acepta automáticamente misiones repetibles (incluidas las diarias) de los jugadores.",
        ["esMX"] = "Acepta automáticamente misiones repetibles (incluidas las diarias) de los jugadores.",
        ["frFR"] = "Accepter automatiquement les quêtes répétables (y compris les quotidiennes) des joueurs",
        ["koKR"] = "플레이어로부터 반복 가능한 퀘스트(일일 퀘스트 포함)를 자동으로 수락합니다.",
        ["ptBR"] = "Aceitar automaticamente missões repetíveis (incluindo diárias) dos jogadores",
        ["ruRU"] = "Автопринятие повторяемых заданий (включая ежедневные) от игроков",
        ["zhCN"] = "自动接受来自玩家的可重复任务（包括日常）",
        ["zhTW"] = "自動接受來自玩家的可重覆任務 (包含每日)。",
    },
    ["Automatically accept dungeon and raid quests from players."] = {
        ["enUS"] = true,
        ["deDE"] = "Dungeon- und Schlachtzug-Quests automatisch von Spielern annehmen.",
        ["esES"] = "Acepta automáticamente misiones de mazmorra y banda de los jugadores.",
        ["esMX"] = "Acepta automáticamente misiones de calabozo y banda de los jugadores.",
        ["frFR"] = "Accepte automatiquement les quêtes de donjon et de raid des joueurs.",
        ["koKR"] = "플레이어로부터 던전 및 레이드 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões de masmorra e raide dos jogadores.",
        ["ruRU"] = "Автопринятие заданий подземелий и рейдов от игроков",
        ["zhCN"] = "自动接受来自玩家的地下城和团队任务",
        ["zhTW"] = "自動接受來自玩家的地下城和團隊任務。",
    },
    ["Automatically accept PvP quests from players."] = {
        ["enUS"] = true,
        ["deDE"] = "PvP-Quests automatisch von Spielern annehmen.",
        ["esES"] = "Acepta automáticamente las misiones de JcJ de los jugadores.",
        ["esMX"] = "Acepta automáticamente las misiones de JcJ de los jugadores.",
        ["frFR"] = "Accepter automatiquement les quêtes JcJ des joueurs",
        ["koKR"] = "플레이어로부터 PvP 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceitar automaticamente missões JxJ dos jogadores",
        ["ruRU"] = "Автопринятие PVP-заданий от игроков",
        ["zhCN"] = "自动接受来自玩家的PVP任务",
        ["zhTW"] = "自動接受來自玩家的 PvP 任務。",
    },
    ["Automatically accept event quests (including event dailies) from players."] = {
        ["enUS"] = true,
        ["deDE"] = "Event-Quests (inkl. Event-Dailies) automatisch von Spielern annehmen.",
        ["esES"] = "Acepta automáticamente misiones de evento (incluidos los diarios de eventos) de los jugadores.",
        ["esMX"] = "Acepta automáticamente misiones de evento (incluidos los diarios de eventos) de los jugadores.",
        ["frFR"] = "Accepte automatiquement les quêtes d'événement (y compris les quotidiennes d'événement) des joueurs.",
        ["koKR"] = "플레이어로부터 이벤트 퀘스트(이벤트 일일 퀘스트 포함)를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões de evento (incluindo diárias de evento) dos jogadores.",
        ["ruRU"] = "Автопринятие заданий игровых событий (включая ежедневные) от игроков",
        ["zhCN"] = "自动接受来自玩家的节日任务（包括节日日常）",
        ["zhTW"] = "自動接受來自玩家的節慶任務 (包括節慶每日)。",
    },
    ["Automatically accept trivial (low-level) quests from players."] = {
        ["enUS"] = true,
        ["deDE"] = "Triviale (niedrigstufige) Quests automatisch von Spielern annehmen.",
        ["esES"] = "Acepta automáticamente misiones triviales (de bajo nivel) de los jugadores.",
        ["esMX"] = "Acepta automáticamente misiones triviales (de bajo nivel) de los jugadores.",
        ["frFR"] = "Accepte automatiquement les quêtes triviales (de bas niveau) des joueurs.",
        ["koKR"] = "플레이어로부터 저레벨 퀘스트를 자동으로 수락합니다.",
        ["ptBR"] = "Aceita automaticamente missões triviais (de baixo nível) dos jogadores.",
        ["ruRU"] = "Автопринятие простых (низкоуровневых) заданий от игроков",
        ["zhCN"] = "自动接受来自玩家的低等级任务",
        ["zhTW"] = "自動接受來自玩家的低等級任務。",
    },
    ["Dungeon/Raid Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Dungeon-/Schlachtzug-Quests",
        ["esES"] = "Misiones de mazmorra y banda",
        ["esMX"] = "Misiones de calabozo y banda",
        ["frFR"] = "Quêtes de donjon/raid",
        ["koKR"] = "던전/레이드 퀘스트",
        ["ptBR"] = "Missões de masmorra/raide",
        ["ruRU"] = "Подземелья/рейды",
        ["zhCN"] = "副本任务",
        ["zhTW"] = "地下城/團隊任務",
    },
    ["Trivial Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Triviale Quests",
        ["esES"] = "Misiones triviales",
        ["esMX"] = "Misiones triviales",
        ["frFR"] = "Quêtes triviales",
        ["koKR"] = "사소한 퀘스트",
        ["ptBR"] = "Missões triviais",
        ["ruRU"] = "Простые задания",
        ["zhCN"] = "低等级任务",
        ["zhTW"] = "低等級任務",
    },
    ["Auto Reject"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests automatisch ablehnen",
        ["esES"] = "Rechazo automático",
        ["esMX"] = "Rechazo automático",
        ["frFR"] = "Rejet automatique",
        ["koKR"] = "자동 거절",
        ["ptBR"] = "Rejeição automática",
        ["ruRU"] = "Автоотклонение",
        ["zhCN"] = "自动拒绝",
        ["zhTW"] = "自動拒絕",
    },
    ["Reject quests shared in battlegrounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests in Schlachtfeldern automatisch ablehnen",
        ["esES"] = "Rechazar misiones compartidas en campos de batalla",
        ["esMX"] = "Rechazar misiones compartidas en campos de batalla",
        ["frFR"] = "Rejeter les quêtes partagées dans les champs de bataille",
        ["koKR"] = "전장에서 공유된 퀘스트 거절",
        ["ptBR"] = "Rejeitar missões compartilhadas em campos de batalha",
        ["ruRU"] = "Отклонять на полях боя",
        ["zhCN"] = "拒绝在战场中共享的任务",
        ["zhTW"] = "拒絕在戰場中分享的任務",
    },
    ["Automatically reject quests shared by players while in a battleground instance. This feature overrides autoaccept behavior."] = {
        ["enUS"] = true,
        ["deDE"] = "Quests, die in Schlachtfeldern geteilt werden, automatisch ablehnen.",
        ["esES"] = "Rechaza automáticamente las misiones compartidas por los jugadores mientras estás en un campo de batalla. Esta característica anula la aceptación automática.",
        ["esMX"] = "Rechaza automáticamente las misiones compartidas por los jugadores mientras estás en un campo de batalla. Esta característica anula la aceptación automática.",
        ["frFR"] = "Rejette automatiquement les quêtes partagées par les joueurs pendant une instance de champ de bataille. Cette fonctionnalité remplace le comportement d'acceptation automatique.",
        ["koKR"] = "전장 인스턴스에서 플레이어가 공유한 퀘스트를 자동으로 거절합니다. 이 기능은 자동 수락 동작을 무시합니다.",
        ["ptBR"] = "Rejeita automaticamente missões compartilhadas por jogadores enquanto estiver em uma instância de campo de batalha. Esta funcionalidade substitui o comportamento de aceitação automática.",
        ["ruRU"] = "Автоматически отклонять задания, предлагаемые другими игроками, находясь на поле боя. Эта настройка отменяет поведение автопринятия",
        ["zhCN"] = "在战场中，自动拒绝其他玩家分享的任务。此选项会覆盖自动接受行为。",
        ["zhTW"] = "在戰場中時，自動拒絕其他玩家分享的任務。此選項會取代自動接受。",
    },
    ["Reject quests shared by non-friends"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests von Nicht-Freunden automatisch ablehnen",
        ["esES"] = "Rechazar misiones compartidas por no amigos",
        ["esMX"] = "Rechazar misiones compartidas por no amigos",
        ["frFR"] = "Rejeter les quêtes partagées par des non-amis",
        ["koKR"] = "친구 목록에 없는 플레이어가 공유한 퀘스트 거절",
        ["ptBR"] = "Rejeitar missões compartilhadas por não-amigos",
        ["ruRU"] = "Отклонять от не-друзей",
        ["zhCN"] = "拒绝非好友分享的任务",
        ["zhTW"] = "拒絕非好友分享的任務",
    },
    ["Automatically reject quests shared by players that aren't on your friends list. This feature overrides autoaccept behavior."] = {
        ["enUS"] = true,
        ["deDE"] = "Quests, die von Nicht-Freunden geteilt werden, automatisch ablehnen.",
        ["esES"] = "Rechaza automáticamente misiones compartidas por jugadores que no están en tu lista de amigos. Esta característica anula la aceptación automática.",
        ["esMX"] = "Rechaza automáticamente misiones compartidas por jugadores que no están en tu lista de amigos. Esta característica anula la aceptación automática.",
        ["frFR"] = "Rejette automatiquement les quêtes partagées par des joueurs qui ne sont pas dans votre liste d'amis. Cette fonctionnalité remplace le comportement d'acceptation automatique.",
        ["koKR"] = "친구 목록에 없는 플레이어가 공유한 퀘스트를 자동으로 거절합니다. 이 기능은 자동 수락 동작을 무시합니다.",
        ["ptBR"] = "Rejeita automaticamente missões compartilhadas por jogadores que não estão na sua lista de amigos. Esta funcionalidade substitui o comportamento de aceitação automática.",
        ["ruRU"] = "Автоматически отклонять задания, предлагаемые другими игроками, которые не в списке ваших друзей. Эта настройка отменяет поведение автопринятия",
        ["zhCN"] = "自动拒绝非好友分享的任务。此选项会覆盖自动接受行为。",
        ["zhTW"] = "自動拒絕由不在你的好友名單中的玩家所分享的任務。此選項會取代自動接受。",
    },
    ["Further Auto customization is coming in a future Questie update."] = {
        ["enUS"] = true,
        ["deDE"] = "Weitere Anpassungsmöglichkeiten werden in einem zukünftigen Questie-Update kommen.",
        ["esES"] = "Una mayor personalización automática llegará en una futura actualización de Questie.",
        ["esMX"] = "Una mayor personalización automática llegará en una futura actualización de Questie.",
        ["frFR"] = "Des personnalisations automatiques supplémentaires arriveront dans une future mise à jour de Questie.",
        ["koKR"] = "추후 Questie 업데이트에서 더 많은 자동화 커스터마이징 기능이 제공될 예정입니다.",
        ["ptBR"] = "Mais personalizações automáticas estão chegando em uma futura atualização de Questie.",
        ["ruRU"] = "Другие настройки автоматизации будут добавлены в будущих версиях Questie",
        ["zhCN"] = "未来版本会提供更多自定义功能",
        ["zhTW"] = "未來的版本會提供更多自訂自動的功能。",
    },
}

for k, v in pairs(autoOptionsLocales) do
    l10n.translations[k] = v
end
