---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local professionLocals = {
    ["First Aid"] = {
        ["enUS"] = true,
        ["deDE"] = "Erste Hilfe",
        ["esES"] = "Primeros auxilios",
        ["esMX"] = "Primeros auxilios",
        ["frFR"] = "Secourisme",
        ["koKR"] = "응급치료",
        ["ptBR"] = "Primeiros Socorros",
        ["ruRU"] = "Первая помощь",
        ["zhCN"] = "急救",
        ["zhTW"] = "急救",
    },
    ["First Aid Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Lehrer für Erste Hilfe",
        ["esES"] = "Instructor de primeros auxilios",
        ["esMX"] = "Instructor de primeros auxilios",
        ["frFR"] = "Maître des secouristes",
        ["koKR"] = "전문 응급치료사",
        ["ptBR"] = "Treinamento de Primeiros Socorros",
        ["ruRU"] = "Учитель первой помощи",
        ["zhCN"] = "急救训练师",
        ["zhTW"] = "外科醫療隊",
    },
    ["Blacksmithing"] = {
        ["enUS"] = true,
        ["deDE"] = "Schmiedekunst",
        ["esES"] = "Herrería",
        ["esMX"] = "Herrería",
        ["frFR"] = "Forge",
        ["koKR"] = "대장기술",
        ["ptBR"] = "Ferraria",
        ["ruRU"] = "Кузнечное дело",
        ["zhCN"] = "锻造",
        ["zhTW"] = "鍛造",
    },
    ["Blacksmithing Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Schmiedekunstlehrer",
        ["esES"] = "Instructor de herrería",
        ["esMX"] = "Instructor de herrería",
        ["frFR"] = "Maître des forgerons",
        ["koKR"] = "전문 대장장이",
        ["ptBR"] = "Treinamento de Ferraria",
        ["ruRU"] = "Учитель кузнечного дела",
        ["zhCN"] = "锻造训练师",
        ["zhTW"] = "大師級鍛造訓練師",
    },
    ["Leatherworking"] = {
        ["enUS"] = true,
        ["deDE"] = "Lederverarbeitung",
        ["esES"] = "Peletería",
        ["esMX"] = "Peletería",
        ["frFR"] = "Travail du cuir",
        ["koKR"] = "가죽세공",
        ["ptBR"] = "Couraria",
        ["ruRU"] = "Кожевничество",
        ["zhCN"] = "制皮",
        ["zhTW"] = "製皮",
    },
    ["Leatherworking Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Lederverarbeitungslehrer",
        ["esES"] = "Instructor de peletería",
        ["esMX"] = "Instructor de peletería",
        ["frFR"] = "Maître des travailleurs du cuir",
        ["koKR"] = "전문 가죽세공인",
        ["ptBR"] = "Treinamento de Couraria",
        ["ruRU"] = "Учитель кожевничества",
        ["zhCN"] = "制皮训练师",
        ["zhTW"] = "製皮訓練師",
    },
    ["Alchemy"] = {
        ["enUS"] = true,
        ["deDE"] = "Alchemie",
        ["esES"] = "Alquimia",
        ["esMX"] = "Alquimia",
        ["frFR"] = "Alchimie",
        ["koKR"] = "연금술",
        ["ptBR"] = "Alquimia",
        ["ruRU"] = "Алхимия",
        ["zhCN"] = "炼金术",
        ["zhTW"] = "鍊金術",
    },
    ["Alchemy Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Alchemielehrer",
        ["esES"] = "Instructor de alquimia",
        ["esMX"] = "Instructor de alquimia",
        ["frFR"] = "Maître des alchimistes",
        ["koKR"] = "전문 연금술사",
        ["ptBR"] = "Treinamento de Alquimia",
        ["ruRU"] = "Учитель алхимии",
        ["zhCN"] = "炼金术训练师",
        ["zhTW"] = "鍊金術訓練師",
    },
    ["Herbalism"] = {
        ["enUS"] = true,
        ["deDE"] = "Kräuterkunde",
        ["esES"] = "Herboristería",
        ["esMX"] = "Herboristería",
        ["frFR"] = "Herboristerie",
        ["koKR"] = "약초채집",
        ["ptBR"] = "Herborismo",
        ["ruRU"] = "Травничество",
        ["zhCN"] = "草药学",
        ["zhTW"] = "草藥學",
    },
    ["Herbalism Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Kräuterkundelehrer",
        ["esES"] = "Instructor de herboristería",
        ["esMX"] = "Instructor de herboristería",
        ["frFR"] = "Maître des herboristes",
        ["koKR"] = "전문 약초채집사",
        ["ptBR"] = "Treinamento de Herborismo",
        ["ruRU"] = "Учитель травничества",
        ["zhCN"] = "草药学训练师",
        ["zhTW"] = "草藥學訓練師",
    },
    ["Cooking"] = {
        ["enUS"] = true,
        ["deDE"] = "Kochkunst",
        ["esES"] = "Cocina",
        ["esMX"] = "Cocina",
        ["frFR"] = "Cuisine",
        ["koKR"] = "요리",
        ["ptBR"] = "Culinária",
        ["ruRU"] = "Кулинария",
        ["zhCN"] = "烹饪",
        ["zhTW"] = "烹飪",
    },
    ["Cooking Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Kochkunstlehrer",
        ["esES"] = "Instructor de cocina",
        ["esMX"] = "Instructor de cocina",
        ["frFR"] = "Maître des cuisiniers",
        ["koKR"] = "전문 요리사",
        ["ptBR"] = "Treinamento de Culinária",
        ["ruRU"] = "Учитель кулинарии",
        ["zhCN"] = "烹饪训练师",
        ["zhTW"] = "烹飪訓練師",
    },
    ["Mining"] = {
        ["enUS"] = true,
        ["deDE"] = "Bergbau",
        ["esES"] = "Minería",
        ["esMX"] = "Minería",
        ["frFR"] = "Minage",
        ["koKR"] = "채광",
        ["ptBR"] = "Mineração",
        ["ruRU"] = "Горное дело",
        ["zhCN"] = "采矿",
        ["zhTW"] = "採礦",
    },
    ["Mining Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Bergbaulehrer",
        ["esES"] = "Instructor de minería",
        ["esMX"] = "Instructor de minería",
        ["frFR"] = "Maître des mineurs",
        ["koKR"] = "전문 채광사",
        ["ptBR"] = "Treinamento de Mineração",
        ["ruRU"] = "Учитель горного дела",
        ["zhCN"] = "采矿训练师",
        ["zhTW"] = "採礦訓練師",
    },
    ["Tailoring"] = {
        ["enUS"] = true,
        ["deDE"] = "Schneiderei",
        ["esES"] = "Sastrería",
        ["esMX"] = "Sastrería",
        ["frFR"] = "Couture",
        ["koKR"] = "재봉술",
        ["ptBR"] = "Alfaiataria",
        ["ruRU"] = "Портняжное дело",
        ["zhCN"] = "裁缝",
        ["zhTW"] = "裁縫",
    },
    ["Tailoring Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Schneiderlehrer",
        ["esES"] = "Instructor de sastrería",
        ["esMX"] = "Instructor de sastrería",
        ["frFR"] = "Maître des tailleurs",
        ["koKR"] = "전문 재봉사",
        ["ptBR"] = "Treinamento de Alfaiataria",
        ["ruRU"] = "Учитель портняжного дела",
        ["zhCN"] = "裁缝训练师",
        ["zhTW"] = "裁縫訓練師",
    },
    ["Engineering"] = {
        ["enUS"] = true,
        ["deDE"] = "Ingenieurskunst",
        ["esES"] = "Ingeniería",
        ["esMX"] = "Ingeniería",
        ["frFR"] = "Ingénierie",
        ["koKR"] = "기계공학",
        ["ptBR"] = "Engenharia",
        ["ruRU"] = "Инженерное дело",
        ["zhCN"] = "工程学",
        ["zhTW"] = "工程學",
    },
    ["Engineering Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Ingenieurskunstlehrer",
        ["esES"] = "Instructor de ingeniería",
        ["esMX"] = "Instructor de ingeniería",
        ["frFR"] = "Maître des ingénieurs",
        ["koKR"] = "전문 기계공학자",
        ["ptBR"] = "Treinamento de Engenharia",
        ["ruRU"] = "Учитель инженерного дела",
        ["zhCN"] = "工程学训练师",
        ["zhTW"] = "工程學訓練師",
    },
    ["Enchanting"] = {
        ["enUS"] = true,
        ["deDE"] = "Verzauberkunst",
        ["esES"] = "Encantamiento",
        ["esMX"] = "Encantamiento",
        ["frFR"] = "Enchantement",
        ["koKR"] = "마법부여",
        ["ptBR"] = "Encantamento",
        ["ruRU"] = "Наложение чар",
        ["zhCN"] = "附魔",
        ["zhTW"] = "附魔",
    },
    ["Enchanting Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Verzauberkunstlehrer",
        ["esES"] = "Instructor de encantamiento",
        ["esMX"] = "Instructor de encantamiento",
        ["frFR"] = "Maître des enchanteurs",
        ["koKR"] = "전문 마법부여사",
        ["ptBR"] = "Treinamento de Encantamento",
        ["ruRU"] = "Учитель наложения чар",
        ["zhCN"] = "附魔训练师",
        ["zhTW"] = "附魔訓練師",
    },
    ["Fishing"] = {
        ["enUS"] = true,
        ["deDE"] = "Angeln",
        ["esES"] = "Pesca",
        ["esMX"] = "Pesca",
        ["frFR"] = "Pêche",
        ["koKR"] = "낚시",
        ["ptBR"] = "Pescaria",
        ["ruRU"] = "Рыбная ловля",
        ["zhCN"] = "钓鱼",
        ["zhTW"] = "釣魚",
    },
    ["Fishing Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Angellehrer",
        ["esES"] = "Instructor de pesca",
        ["esMX"] = "Instructor de pesca",
        ["frFR"] = "Maître des pêcheurs",
        ["koKR"] = "전문 낚시꾼",
        ["ptBR"] = "Treinamento de Pescaria",
        ["ruRU"] = "Учитель рыбной ловли",
        ["zhCN"] = "钓鱼训练师",
        ["zhTW"] = "釣魚訓練師",
    },
    ["Skinning"] = {
        ["enUS"] = true,
        ["deDE"] = "Kürschnerei",
        ["esES"] = "Desuello",
        ["esMX"] = "Desuello",
        ["frFR"] = "Dépeçage",
        ["koKR"] = "무두질",
        ["ptBR"] = "Esfolamento",
        ["ruRU"] = "Снятие шкур",
        ["zhCN"] = "剥皮",
        ["zhTW"] = "剝皮",
    },
    ["Skinning Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Kürschnereilehrer",
        ["esES"] = "Instructor de desuello",
        ["esMX"] = "Instructor de desuello",
        ["frFR"] = "Maître des dépeceurs",
        ["koKR"] = "전문 무두장이",
        ["ptBR"] = "Treinamento de Esfolamento",
        ["ruRU"] = "Учитель снятия шкур",
        ["zhCN"] = "剥皮训练师",
        ["zhTW"] = "剝皮訓練師",
    },
    ["Jewelcrafting"] = {
        ["enUS"] = true,
        ["deDE"] = "Juwelierskunst",
        ["esES"] = "Joyería",
        ["esMX"] = "Joyería",
        ["frFR"] = "Joaillerie",
        ["koKR"] = "보석세공",
        ["ptBR"] = "Joalheria",
        ["ruRU"] = "Ювелирное дело",
        ["zhCN"] = "珠宝加工",
        ["zhTW"] = "珠寶設計",
    },
    ["Jewelcrafting Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Juwelierskunstlehrer",
        ["esES"] = "Instructor de joyería",
        ["esMX"] = "Instructor de joyería",
        ["frFR"] = "Maître des joailliers",
        ["koKR"] = "전문 보석세공인",
        ["ptBR"] = "Treinamento de Joalheria",
        ["ruRU"] = "Учитель ювелирного дела",
        ["zhCN"] = "珠宝加工训练师",
        ["zhTW"] = "珠寶設計訓練師",
    },
    ["Riding"] = {
        ["enUS"] = true,
        ["deDE"] = "Reiten",
        ["esES"] = "Equitación",
        ["esMX"] = "Equitación",
        ["frFR"] = "Monte",
        ["koKR"] = "탈것 타기",
        ["ptBR"] = "Montaria",
        ["ruRU"] = "Верховая езда",
        ["zhCN"] = "骑术",
        ["zhTW"] = "騎術",
    },
    ["Riding Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Reitlehrer",
        ["esES"] = "Instructor de equitación",
        ["esMX"] = "Instructor de equitación",
        ["frFR"] = "Instructeur de monte",
        ["koKR"] = "전문 탈것 조련사",
        ["ptBR"] = "Treinamento de Montaria",
        ["ruRU"] = "Учитель верховой езды",
        ["zhCN"] = "骑术训练师",
        ["zhTW"] = "騎術訓練師",
    },
    ["Inscription"] = {
        ["enUS"] = true,
        ["deDE"] = "Inschriftenkunde",
        ["esES"] = "Inscripción",
        ["esMX"] = "Inscripción",
        ["frFR"] = "Calligraphie",
        ["koKR"] = "주문각인",
        ["ptBR"] = "Escrivania",
        ["ruRU"] = "Начертание",
        ["zhCN"] = "铭文",
        ["zhTW"] = "銘文學",
    },
    ["Inscription Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Inschriftenkundelehrer",
        ["esES"] = "Instructor de inscripción",
        ["esMX"] = "Instructor de inscripción",
        ["frFR"] = "Maître des calligraphes",
        ["koKR"] = "전문 주문각인사",
        ["ptBR"] = "Treinamento de Escrivania",
        ["ruRU"] = "Учитель начертания",
        ["zhCN"] = "铭文训练师",
        ["zhTW"] = "銘文學訓練師",
    },
    ["Archaeology"] = {
        ["enUS"] = true,
        ["deDE"] = "Archäologie",
        ["esES"] = "Arqueología",
        ["esMX"] = "Arqueología",
        ["frFR"] = "Archéologie",
        ["koKR"] = "고고학",
        ["ptBR"] = "Arqueologia",
        ["ruRU"] = "Археология",
        ["zhCN"] = "考古学",
        ["zhTW"] = "考古學",
    },
    ["Archaeology Trainer"] = {
        ["enUS"] = true,
        ["deDE"] = "Archäologielehrer",
        ["esES"] = "Instructor de arqueología",
        ["esMX"] = "Instructor de arqueología",
        ["frFR"] = "Maître des archéologues",
        ["koKR"] = "전문 고고학자",
        ["ptBR"] = "Treinamento de Arqueologia",
        ["ruRU"] = "Учитель археологии",
        ["zhCN"] = "考古学训练师",
        ["zhTW"] = "考古學訓練師",
    },
}

for k, v in pairs(professionLocals) do
    l10n.translations[k] = v
end
