---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")


local pandariaLocales = {
    ["The Jade Forest"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Jadewald",
        ["esES"] = "El Bosque de Jade",
        ["esMX"] = "El Bosque de Jade",
        ["frFR"] = "La forêt de Jade",
        ["koKR"] = "비취 숲",
        ["ptBR"] = "Floresta de Jade",
        ["ruRU"] = "Нефритовый лес",
        ["zhCN"] = "翡翠林",
        ["zhTW"] = "翠玉林",
    },
    ["Valley of the Four Winds"] = {
        ["enUS"] = true,
        ["deDE"] = "Tal der Vier Winde",
        ["esES"] = "Valle de los Cuatro Vientos",
        ["esMX"] = "Valle de los Cuatro Vientos",
        ["frFR"] = "Vallée des Quatre vents",
        ["koKR"] = "네 바람의 계곡",
        ["ptBR"] = "Vale dos Quatro Ventos",
        ["ruRU"] = "Долина Четырех Ветров",
        ["zhCN"] = "四风谷",
        ["zhTW"] = "四風峽",
    },
    ["Krasarang Wilds"] = {
        ["enUS"] = true,
        ["deDE"] = "Krasarangwildnis",
        ["esES"] = "Espesura Krasarang",
        ["esMX"] = "Espesura Krasarang",
        ["frFR"] = "Étendues sauvages de Krasarang",
        ["koKR"] = "크라사랑 밀림",
        ["ptBR"] = "Selva de Krasarang",
        ["ruRU"] = "Красарангские джунгли",
        ["zhCN"] = "卡桑琅丛林",
        ["zhTW"] = "喀撒朗蠻荒",
    },
    ["Kun-Lai Summit"] = {
        ["enUS"] = true,
        ["deDE"] = "Kun-Lai-Gipfel",
        ["esES"] = "Cima Kun-Lai",
        ["esMX"] = "Cima Kun-Lai",
        ["frFR"] = "Sommet de Kun-Lai",
        ["koKR"] = "쿤라이 봉우리",
        ["ptBR"] = "Monte Kun-Lai",
        ["ruRU"] = "Вершина Кунь-Лай",
        ["zhCN"] = "昆莱山",
        ["zhTW"] = "崑萊峰",
    },
    ["Townlong Steppes"] = {
        ["enUS"] = true,
        ["deDE"] = "Tonlongsteppe",
        ["esES"] = "Estepas de Tong Long",
        ["esMX"] = "Estepas de Tong Long",
        ["frFR"] = "Steppes de Tanglong",
        ["koKR"] = "탕랑 평원",
        ["ptBR"] = "Estepes de Taolong",
        ["ruRU"] = "Танлунские степи",
        ["zhCN"] = "螳螂高原",
        ["zhTW"] = "螳螂荒原",
    },
    ["Dread Wastes"] = {
        ["enUS"] = true,
        ["deDE"] = "Schreckensöde",
        ["esES"] = "Desierto del Pavor",
        ["esMX"] = "Desierto del Pavor",
        ["frFR"] = "Terres de l’Angoisse",
        ["koKR"] = "공포의 황무지",
        ["ptBR"] = "Ermo do Medo",
        ["ruRU"] = "Жуткие пустоши",
        ["zhCN"] = "恐惧废土",
        ["zhTW"] = "悚然荒野",
    },
    ["The Veiled Stair"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Verhüllte Treppe",
        ["esES"] = "La Escalera Velada",
        ["esMX"] = "La Escalera Velada",
        ["frFR"] = "L’escalier Dérobé",
        ["koKR"] = "장막의 계단",
        ["ptBR"] = "Escadaria Oculta",
        ["ruRU"] = "Сокрытая лестница",
        ["zhCN"] = "雾纱栈道",
        ["zhTW"] = "朦朧天梯",
    },
    ["Vale of Eternal Blossoms"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Tal der Ewigen Blüten",
        ["esES"] = "Valle de la Flor Eterna",
        ["esMX"] = "Valle de la Flor Eterna",
        ["frFR"] = "Val de l’Éternel printemps",
        ["koKR"] = "영원꽃 골짜기",
        ["ptBR"] = "Vale das Flores Eternas",
        ["ruRU"] = "Вечноцветущий дол",
        ["zhCN"] = "锦绣谷",
        ["zhTW"] = "恆春谷",
    },
    ["Timeless Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeitlose Insel",
        ["esES"] = "Isla Intemporal",
        ["esMX"] = "Isla Intemporal",
        ["frFR"] = "Île du Temps figé",
        ["koKR"] = "영원의 섬",
        ["ptBR"] = "Ilha Perene",
        ["ruRU"] = "Вневременный остров",
        ["zhCN"] = "永恒岛",
        ["zhTW"] = "永恆之島",
    },
    ["Isle of Thunder"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel des Donners",
        ["esES"] = "Isla del Trueno",
        ["esMX"] = "Isla del Trueno",
        ["frFR"] = "Île du Tonnerre",
        ["koKR"] = "천둥의 섬",
        ["ptBR"] = "Ilha do Trovão",
        ["ruRU"] = "Остров Грома",
        ["zhCN"] = "雷神岛",
        ["zhTW"] = "雷王島",
    },
    ["Isle of Giants"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel der Riesen",
        ["esES"] = "Isla de los Gigantes",
        ["esMX"] = "Isla de los Gigantes",
        ["frFR"] = "Île des Géants",
        ["koKR"] = "괴수의 섬",
        ["ptBR"] = "Ilha de Gigantes",
        ["ruRU"] = "Остров Великанов",
        ["zhCN"] = "巨兽岛",
        ["zhTW"] = "巨獸島",
    },
    ["Shrine of Seven Stars"] = {
        ["enUS"] = true,
        ["deDE"] = "Schrein der Sieben Sterne",
        ["esES"] = "Santuario de las Siete Estrellas",
        ["esMX"] = "Santuario de las Siete Estrellas",
        ["frFR"] = "Sanctuaire des Sept-Étoiles",
        ["koKR"] = "일곱 별의 제단",
        ["ptBR"] = "Santuário das Sete Estrelas",
        ["ruRU"] = "Святилище Семи Звезд",
        ["zhCN"] = "七星殿",
        ["zhTW"] = "七星廟",
    },
    ["Shrine of Two Moons"] = {
        ["enUS"] = true,
        ["deDE"] = "Schrein der Zwei Monde",
        ["esES"] = "Santuario de las Dos Lunas",
        ["esMX"] = "Santuario de las Dos Lunas",
        ["frFR"] = "Sanctuaire des Deux-Lunes",
        ["koKR"] = "두 달의 제단",
        ["ptBR"] = "Santuário das Duas Luas",
        ["ruRU"] = "Святилище Двух Лун",
        ["zhCN"] = "双月殿",
        ["zhTW"] = "雙月廟",
    },
    ["Landfall"] = {
        ["enUS"] = true,
        ["deDE"] = "Landung",
        ["esES"] = "Desembarco",
        ["esMX"] = "Desembarco",
        ["frFR"] = "Accostage",
        ["koKR"] = "상륙지",
        ["ptBR"] = "Desembarque",
        ["ruRU"] = "Высадка",
        ["zhCN"] = "登陆",
        ["zhTW"] = "登陸",
    },
    ["Pandaren Campaign"] = {
        ["enUS"] = true,
        ["deDE"] = "Pandarenkampagne",
        ["esES"] = "Campaña pandaren",
        ["esMX"] = "Campaña pandaren",
        ["frFR"] = "Campagne pandarène",
        ["koKR"] = "판다리아 대장정",
        ["ptBR"] = "Campanha Pandarênica",
        ["ruRU"] = "Пандаренская кампания",
        ["zhCN"] = "熊猫人战役",
        ["zhTW"] = "熊貓人戰役",
    },
    ["Pandaren Brewmasters"] = {
        ["enUS"] = true,
        ["deDE"] = "Pandarische Braumeister",
        ["esES"] = "Maestros cerveceros pandaren",
        ["esMX"] = "Maestros cerveceros pandaren",
        ["frFR"] = "Maîtres brasseurs pandarens",
        ["koKR"] = "판다렌 양조사",
        ["ptBR"] = "Mestres Cervejeiros Pandaren",
        ["ruRU"] = "Пандарены-пивовары",
        ["zhCN"] = "熊猫人酒仙",
        ["zhTW"] = "熊貓人釀酒大師",
    },
    ["The Halfhill Market"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Halbhügelmarkt",
        ["esES"] = "El Mercado del Alcor",
        ["esMX"] = "El Mercado del Alcor",
        ["frFR"] = "Marché de Micolline",
        ["koKR"] = "언덕골 시장",
        ["ptBR"] = "Mercado da Meia Colina",
        ["ruRU"] = "Рынок Полугорья",
        ["zhCN"] = "半山市集",
        ["zhTW"] = "半丘市集",
    },
    ["Jade Temple Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Anlagen des Jadetempels",
        ["esES"] = "Tierras del Templo de Jade",
        ["esMX"] = "Tierras del Templo de Jade",
        ["frFR"] = "Jardins du Temple de jade",
        ["koKR"] = "옥룡사 정원",
        ["ptBR"] = "Pátio do Templo de Jade",
        ["ruRU"] = "Земли Нефритового храма",
        ["zhCN"] = "青龙寺庭院",
        ["zhTW"] = "玉廟庭",
    },
    ["Peak of Serenity"] = {
        ["enUS"] = true,
        ["deDE"] = "Gipfel der Ruhe",
        ["esES"] = "Pico de la Serenidad",
        ["esMX"] = "Pico de la Serenidad",
        ["frFR"] = "Pic de la Sérénité",
        ["koKR"] = "평온의 봉우리",
        ["ptBR"] = "Pico da Serenidade",
        ["ruRU"] = "Пик Безмятежности",
        ["zhCN"] = "晴日峰",
        ["zhTW"] = "寂靜峰",
    },
    ["The Arboretum"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Arboretum",
        ["esES"] = "El Arboretum",
        ["esMX"] = "El Arboretum",
        ["frFR"] = "L’Arboretum",
        ["koKR"] = "도원",
        ["ptBR"] = "Arboreto",
        ["ruRU"] = "Дендрарий",
        ["zhCN"] = "百木园",
        ["zhTW"] = "落英園",
    },
    ["The Wandering Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Wandernde Insel",
        ["esES"] = "La Isla Errante",
        ["esMX"] = "La Isla Errante",
        ["frFR"] = "L’île Vagabonde",
        ["koKR"] = "유랑도",
        ["ptBR"] = "Ilha Errante",
        ["ruRU"] = "Скитающийся остров",
        ["zhCN"] = "迷踪岛",
        ["zhTW"] = "漂流島",
    },
    ["Niuzao Catacombs"] = {
        ["enUS"] = true,
        ["deDE"] = "Niuzaokatakomben",
        ["esES"] = "Catacumbas de Niuzao",
        ["esMX"] = "Catacumbas de Niuzao",
        ["frFR"] = "Catacombes de Niuzao",
        ["koKR"] = "니우짜오 지하묘지",
        ["ptBR"] = "Catacumbas Niuzao",
        ["ruRU"] = "Катакомбы Нюцзао",
        ["zhCN"] = "砮皂陵",
        ["zhTW"] = "怒兆地下墓穴",
    },
    ["The Thunder Forges"] = {
        ["enUS"] = true,
        ["deDE"] = false,
        ["esES"] = false,
        ["esMX"] = false,
        ["frFR"] = false,
        ["koKR"] = false,
        ["ptBR"] = false,
        ["ruRU"] = false,
        ["zhCN"] = "雷霆熔炉",
        ["zhTW"] = false,
    },
}

for k, v in pairs(pandariaLocales) do
    l10n.translations[k] = v
end
