--[[	handler functions for Auras.

------------------]]

local _G = _G
local maxUnitAuras = 14
local maxBossAuras = 5
local maxPartyAuras = 4
local maxReactiveAuras = 10

local function GetColor(perc)
	local r,g,b

	if perc then
		if perc > 0.5 then
			return 0+(1-perc)*2,1,0
		else
			return 1,0+perc*2,0
		end
	else
		return 1,1,1
	end
end

local function SetAuraInfo(self,icon,charge,duration,expire,spellID)
	local timeLeft = duration - expire + GetTime()
	
	self.spellID = spellID
	self.timer = GetTime() - timeLeft
	self.Cooldown:SetCooldown(GetTime() - timeLeft, duration)
	self.Icon:SetTexture(icon)
	
	if charge > 1 then
		self.Charge:SetText(charge)
	else
		self.Charge:SetText("")
	end
	
	self:Show()
end

local function GetAuraIndex(self,unitID,type)
	for index = 1, 40 do
		local spellID;
		
		if type == "Buff" then
			spellID = select(11, UnitBuff(unitID,index))
		elseif type == "Debuff" then
			spellID = select(11, UnitDebuff(unitID,index))
		end
		
		if self.spellID == spellID then return index end
	end
end


local function SetUnitAura(frame,unitID)
	for index = 1, maxUnitAuras do
		local buff = _G[frame.."Buff"..index]
		local debuff = _G[frame.."Debuff"..index]
		
		-- buffs
		if unitID ~= "player" and buff then
			buff:Hide()

			local _,_,icon,charge,_,duration,expire,caster,_,isRaidBuff,spellID = UnitBuff(unitID,index)
			
			if spellID then
				SetAuraInfo(buff,icon,charge,duration,expire,spellID)
			end
		end

		-- debuffs
		if debuff then
			debuff:Hide()

			local _,_,icon,charge,_,duration,expire,caster,_,_,spellID,_,isBossDebuff,isCastByPlayers = UnitDebuff(unitID,index)

			if spellID then
				SetAuraInfo(debuff,icon,charge,duration,expire,spellID)
				
				if caster == "player" or caster == "pet" then
					debuff.Icon:SetDesaturated(false)
				elseif unitID ~= "player" then
					debuff.Icon:SetDesaturated(true)
				end
			end
		end
	end
end

local function SetBossAura(frame,unitID,index,max)
	local _, _, icon, charge, debuffType, duration, expire, _, isStealable, _, spellID = UnitDebuff(unitID,index,"PLAYER")
	
	if spellID then
		for i = 1, maxBossAuras do
			local debuff = _G[frame.."Debuff"..i]
			
			if debuff.spellID == nil then
				SetAuraInfo(debuff,icon,charge,duration,expire,spellID)
				
				max = max + 1
				return max
			end
		end
	end		
	return max
end

local function SetPartyAura(frame,unitID,type,index,max)
	if type == "debuff" then
		local _, _, icon, charge, debuffType, duration, expire, _, isStealable, _, spellID = UnitDebuff(unitID,index)
		
		if spellID then
			for i = 1, maxBossAuras do
				local debuff = _G[frame.."Debuff"..i]
				
				if debuff.spellID == nil then
					SetAuraInfo(debuff,icon,charge,duration,expire,spellID)
					
					max = max + 1
					return max
				end
			end
		end		
		return max
	end
	
	if type == "buff" then
		local _,_,icon,charge,_,duration,expire,caster,_,isRaidBuff,spellID = UnitBuff(unitID,index)
		
		if spellID and caster == "player" and not isRaidBuff then
			for i = 1, maxPartyAuras do
				local buff = _G[frame.."Buff"..i]
				
				if buff.spellID == nil then
					SetAuraInfo(buff,icon,charge,duration,expire,spellID)
					
					max = max + 1
					return max
				end
			end
		end		
		return max	
	end
end

local function SetReactiveAura(frame,unitID,index,max)
	local _, _, icon, charge, debuffType, duration, expire, _, isStealable, _, spellID = UnitBuff(unitID,index)
	
	if spellID then
		if not SyncUI_CharData["WeakAuras"] then return end
		
		for _, AuraFilterID in pairs(SyncUI_CharData["WeakAuras"]) do
			if spellID == tonumber(AuraFilterID) then
				for i = 1, maxReactiveAuras do
					local aura = _G[frame.."Aura"..i]
					
					if aura.spellID == nil then
						SetAuraInfo(aura,icon,charge,duration,expire,spellID)
						
						max = max + 1
						return max
					end
				end
			end
		end
	end		
	return max
end

local function SetPlayerBuffs(frame,unitID,index,max)
	local _,_,icon,charge,_,duration,expire,_,_,isRaidBuff,spellID = UnitBuff(unitID,index)
	
	if GetNumGroupMembers() > 0 then
		if spellID and not isRaidBuff then
			for i = 1, maxUnitAuras do
				local buff = _G[frame.."Buff"..i]
				
				if buff.spellID == nil then
					SetAuraInfo(buff,icon,charge,duration,expire,spellID)
					
					max = max + 1
					return max
				end
			end
		end
	else
		if spellID then
			for i = 1, maxUnitAuras do
				local buff = _G[frame.."Buff"..i]
				
				if buff.spellID == nil then
					SetAuraInfo(buff,icon,charge,duration,expire,spellID)
					
					max = max + 1
					return max
				end
			end
		end
	end
	return max
end


function SyncUI_Aura_OnLoad(self)
	self.Cooldown:SetReverse(true)
	self.Cooldown:SetHideCountdownNumbers(true) 
	self.spellID = nil
	self.timer = 0
	
	SyncUI_Cooldown_OnRegister(self.Cooldown)
end

function SyncUI_Aura_OnEnter(self)
	local frame = _G[self:GetName()]
	local unitID = self:GetParent().unitID
	local auraIndex = GetAuraIndex(self,unitID,"Buff") or GetAuraIndex(self,unitID,"Debuff")
	
	-- buffs
	if strfind(self:GetName(),"Buff") then
		local spellID = select(11, UnitBuff(unitID,auraIndex))
		GameTooltip:SetOwner(frame, "ANCHOR_BOTTOMRIGHT",-35,0)
		GameTooltip:SetUnitBuff(unitID, auraIndex)
		GameTooltip:AddLine("|cFF00FF00SpellID: |r"..spellID)
		GameTooltip:Show()
	end

	-- debuffs
	if strfind(self:GetName(),"Debuff") then
		local spellID = select(11, UnitDebuff(unitID,auraIndex))
		GameTooltip:SetOwner(frame, "ANCHOR_TOPLEFT",0,0)
		GameTooltip:SetUnitDebuff(unitID, auraIndex)
		GameTooltip:AddLine("|cFF00FF00SpellID: |r"..spellID)
		GameTooltip:Show()
	end

	-- reactive Auras
	if strfind(self:GetName(),"Aura") then
		local spellID = select(11, UnitBuff(unitID,auraIndex))
		GameTooltip:SetOwner(frame, "ANCHOR_TOPLEFT",0,0)
		GameTooltip:SetUnitBuff(unitID, auraIndex)
		GameTooltip:AddLine("|cFF00FF00SpellID: |r"..spellID)
		GameTooltip:Show()
	end
end

function SyncUI_Aura_OnUpdate(self)
	if not self.timer then return end

	local duration = self.Cooldown:GetCooldownDuration() / 1000
	local timer = self.timer + duration - GetTime()

	
	if timer then
		local perc = timer/duration
		local r,g,b = GetColor(perc)
		
		self.Time:SetVertexColor(r,g,b)
		
		if  timer >= 60 then 
			self.Time:SetText(math.ceil(timer/60).."m")
		elseif timer > 0 then
			self.Time:SetText(math.ceil(timer))
		else
			self.timer = 0
			self.Time:SetText("")
		end
	else
		self.timer = 0
		self.Time:SetText("")
	end
end

function SyncUI_AuraFrame_OnEvent(self)
	local unitID = self.unitID
	local frame = self:GetName()
	
	if unitID then
		if unitID:find("raid") then
			-- Heal Frame Buffs & Boss Debuffs
		end
		
		if unitID:find("boss") then
			local max = 0
			
			for i = 1, maxBossAuras do
				local debuff = _G[frame.."Debuff"..i]
				debuff.spellID = nil
				debuff:Hide()			
			end

			for index = 1, 40 do
				max = SetBossAura(frame,unitID,index,max)
			end
		end
		
		if unitID:find("party") then
			do	-- debuffs
				local max = 0

				for i = 1, maxBossAuras do
					local debuff = _G[frame.."Debuff"..i]

					debuff.spellID = nil
					debuff:Hide()
				end
				
				for index = 1, 40 do
					max = SetPartyAura(frame,unitID,"debuff",index,max)
				end
			end
			
			do	-- buffs
				local max = 0

				for i = 1, maxPartyAuras do
					local buff = _G[frame.."Buff"..i]
					
					buff.spellID = nil
					buff:Hide()			
				end

				for index = 1, 40 do
					max = SetPartyAura(frame,unitID,"buff",index,max)
				end		
			end
		end
		
		if unitID == "player" then
			local max, max2 = 0, 0
			
			-- Reactive Auras
			for i = 1, maxReactiveAuras do
				local aura = _G[frame.."Aura"..i]
				aura.spellID = nil
				aura:Hide()		
			end

			-- Player Buffs
			for i = 1, maxUnitAuras do
				local buff = _G[frame.."Buff"..i]
				buff.spellID = nil
				buff:Hide()			
			end

			for index = 1, 40 do
				max = SetReactiveAura(frame,unitID,index,max)
				max2 = SetPlayerBuffs(frame,unitID,index,max2)
			end
			
			SetUnitAura(frame,unitID)
		end

		if unitID == "target" or unitID == "focus" then
			SetUnitAura(frame,unitID)
		end
	end
end

function SyncUI_RegisterUnitAura(self,unitID)
	if not self.AuraFrame then
		self.AuraFrame = CreateFrame("Frame")
	end
	
	self.AuraFrame:RegisterUnitEvent("UNIT_AURA", unitID)
	
	if unitID == "target" then
		self.AuraFrame:RegisterEvent("PLAYER_TARGET_CHANGED")
	elseif unitID == "focus" then
		self.AuraFrame:RegisterEvent("PLAYER_FOCUS_CHANGED")
	end
	
	self.AuraFrame:SetScript("OnEvent", function()
		SyncUI_AuraFrame_OnEvent(self)
	end)
end
