
local L = {}
local locale = GetLocale()

if locale == "deDE" then
	L.Quest = "Quest"
	L.Consumable = "Verbrauchbar"
	L.TradeGoods = "Handwerkswaren"
	L.Armor = "Rüstung"
	L.Weapon = "Waffe"
	L.Gem = "Edelstein"
	L.ItemEnh = "Gegenstandsverbesserung"
	L.Other = "Verschiedenes"
	L.Devices = "Geräte"
	
elseif locale == "ptBR" then
	L.Quest = "Missão"
	L.Consumable = "Consumível"
	L.TradeGoods = "Mercadorias"
	L.Armor = "Armadura"
	L.Weapon = "Arma"
	L.Gem = "Gema"
	L.ItemEnh = "Aperfeiçoamento de Item"
	L.Other = "Diversos"
	L.Devices = "Dispositivos"
	
elseif locale == "esES" then
	L.Quest = "Misión"
	L.Consumable = "Consumible"
	L.TradeGoods = "Objeto comerciable"
	L.Armor = "Armadura"
	L.Weapon = "Arma"
	L.Gem = "Gema"
	L.ItemEnh = "Mejora de objetos"
	L.Other = "Miscelánea"
	L.Devices = "Instrumentos"
	
elseif locale == "itIT" then
	L.Quest = "Missione"
	L.Consumable = "Consumabili"
	L.TradeGoods = "Beni commerciali"
	L.Armor = "Armature"
	L.Weapon = "Armi"
	L.Gem = "Gemme"
	L.ItemEnh = "Potenziamenti"
	L.Other = "Varie"
	L.Devices = "Congegni"
	
elseif locale == "frFR" then
	L.Quest = "Quête"
	L.Consumable = "Consommable"
	L.TradeGoods = "Artisanat"
	L.Armor = "Armure"
	L.Weapon = "Arme"
	L.Gem = "Gemme"
	L.ItemEnh = "Amélioration d'objet"
	L.Other = "Autre"
	L.Devices = "Appareils"
	
else
	L.Quest = "Quest"
	L.Consumable = "Consumable"
	L.TradeGoods = "Trade Goods"
	L.Armor = "Armor"
	L.Weapon = "Weapon"
	L.Gem = "Gem"
	L.ItemEnh = "Item Enhancement"
	L.Other = "Other"
	L.Devices = "Devices"
end


--[[	a bag mod with categorized containers

------------------]]


local _G = _G
local tinsert, tremove, rowMaxBag, rowMaxBank, maxBagSlots = table.insert, table.remove, 7, 10, 36
local ItemCategories = {
	[1] = "Inventory",
	[2] = "Quest",
	[3] = "Follower Upgrades",
	[4] = "Trade Goods",
	[5] = "Consumable",
	[6] = "Item Enhancement",
	[7] = "Equip",
	[8] = "Equip Set",
	[9] = "Misc",
}
local FollowerItemList = {
	-- Follower Retraining
	[118354] = "Follower Retraining Certificate",
	[122272] = "Follower Ability Retraining Manual",
	[122273] = "Follower Trait Retraining Guide",
	[123858] = "Follower Retraining Scroll Case",
	
	-- Specific Traits
	[122582] = "Guide to Arakkoa Relations",
	[118474] = "Supreme Manual of Dance",
	[118475] = "Hearthstone Strategy Guide",
	[122584] = "Winning with Wildlings",
	[122583] = "Grease Monkey Guide",
	[122580] = "Ogre Buddy Handbook",
	[122275] = "Sun-touched Feather of Rukhmar",
	
	-- Special
	[120313] = "Sanketsu",
	[120311] = "The Blademaster's Necklace",

	-- Weapon Upgrades
	[120302] = "Weapon Enhancement Token",
	[114128] = "Balanced Weapon Enhancement",
	[114129] = "Striking Weapon Enhancement",
	[114131] = "Power Overrun Weapon Enhancement",
	[114616] = "War Ravaged Weaponry",
	[114081] = "Blackrock Weaponry",
	[114622] = "Goredrenched Weaponry",
	
	-- Armor Upgrades
	[120301] = "Armor Enhancement Token",
	[114745] = "Braced Armor Enhancement",
	[114808] = "Fortified Armor Enhancement",
	[114822] = "Heavy Reinforced Armor Enhancement",
	[114807] = "War Ravaged Armor Set",
	[114806] = "Blackrock Armor Set",
	[114746] = "Goredrenched Armor Set",
}


-- Misc functions
local function SellGreyItems()
	local sold, price = 0, 0

	for bagID = 0, NUM_BAG_SLOTS do
		local numSlots = GetContainerNumSlots(bagID)
		for slot = 1, numSlots do
			local itemLink = GetContainerItemLink(bagID,slot)
			
			if itemLink then
				local quality = select(3, GetItemInfo(itemLink))
				if quality and quality == 0 then
					local soldPrice = select(11, GetItemInfo(itemLink))
					UseContainerItem(bagID,slot)

					sold = sold + 1
					price = price + soldPrice
				end
			end
		end
	end
	
	if sold > 0 then
		print("|cFF00FF99Sync|rBags: |cFFFFFF00|r" .. sold .. " items are selled for: "..GetCoinTextureString(price))
	end
end

local function SortContainer(a,b)
	if a == nil or b == nil then return false end
	
	if a.rarity ~= b.rarity then
		if a.rarity and b.rarity then
			return a.rarity > b.rarity
		elseif a.rarity == nil or b.rarity == nil then
			return a.rarity and true or false
		else
			return false
		end
	elseif a.ilvl ~= b.ilvl then
		if a.ilvl and b.ilvl then
			return a.ilvl > b.ilvl
		elseif a.ilvl == nil or b.ilvl == nil then
			return a.ilvl and true or false
		else
			return false
		end
	elseif a.name ~= b.name then
		return a.name < b.name
	else
		return a.stack < b.stack
	end
end

local function SortInventoryFreeSlot(self)
	if not self.freeSlot then return end
	
	for k, v in pairs(self.buttons) do
		if v == self.freeSlot then
			tremove(self.buttons,k)
		end
	end
	
	tinsert(self.buttons,self.freeSlot)
end

local function isBank(bagID)
	for _, value in pairs({-1,5,6,7,8,9,10,11}) do
		if bagID == value then
			return true
		end
	end
	
	return false
end

local function isEnabled(container,button)
	if container.buttons then
		for _, ref in pairs(container.buttons) do
			if ref == button then
				return false
			end
		end

		return true
	end
end


-- Category Search Functions
local function isTrash(itemID)
	if select(3, GetItemInfo(itemID)) == 0 then
		return true
	end
end

local function isQuest(type)
	if type == L.Quest then
		return true
	end
end

local function isFollowerEquip(itemID)
	for item in pairs(FollowerItemList) do
		if item == itemID then
			return true
		end
	end
end

local function isMisc(itemID,subType)
	if itemID == 110560 or itemID == 6948 or subType == L.Devices then
		return true
	end
end

local function isTradeGoods(type)
	if type == L.TradeGoods then 
		return true
	end
end

local function isEquip(type)
	if type == L.Armor or type == L.Weapon then
		return true
	end
end

local function isItemEnhancement(type,subType)
	if type == L.Gem or ( type == L.Consumable and subType == L.ItemEnh ) then
		return true
	end
end

local function isConsumable(type)
	if type == L.Consumable then
		return true
	end
end


-- Assign / Remove Functions
local function AddButtonToContainer(container,button)
	table.insert(container.buttons,button)
	button.container = container
end

local function RemoveButtonFromContainer(container,button)
	for i, ref in pairs(container.buttons) do
		if button == ref then
			table.remove(container.buttons,i)
		end
	end
end


-- Get Info Functions
local function GetCategoryByItem(itemID,type,subType)
	if not itemID then return "Inventory" end

	local sortType;

	if isTrash(itemID) then
		sortType = "Inventory"
	elseif isQuest(type) then
		sortType = "Quest"
	elseif isFollowerEquip(itemID) then
		sortType = "Follower Upgrades"
	elseif isMisc(itemID,subType) then
		sortType = "Misc"
	elseif isTradeGoods(type) then
		sortType = "Trade Goods"
	elseif isEquip(type) then
		sortType = "Equip"
	elseif isItemEnhancement(type,subType) then
		sortType = "Item Enhancement"
	elseif isConsumable(type) then
		sortType = "Consumable"
	else
		sortType = "Inventory"
	end
	
	return sortType
end

local function GetContainerByCategory(category,isBank)
	local index
	
	for key, value in pairs(ItemCategories) do
		if category == value then
			index = key
			break
		end
	end
	
	if not index then
		index = 1
	end
	
	if isBank then
		return _G["SyncUI_BankFrame_Container" .. index]
	else
		return _G["SyncUI_BagFrame_Container" .. index]
	end
end

local function GetContainerForItem(bagID,slot)
	local itemLink = GetContainerItemLink(bagID,slot)
	local itemID = GetContainerItemID(bagID,slot)	
	
	if itemID == 82800 then
		return GetContainerByCategory("Inventory",isBank(bagID))
	elseif GetContainerItemEquipmentSetInfo(bagID,slot) then
		return GetContainerByCategory("Equip Set",isBank(bagID))
	elseif itemLink then
		local type = select(6, GetItemInfo(itemLink))
		local subType = select(7, GetItemInfo(itemLink))
		local category = GetCategoryByItem(itemID,type,subType)
		local container = GetContainerByCategory(category,isBank(bagID))
	
		return container
	end
end

local function GetNumFreeSlots(isBank)
	totalFreeSlots = 0
	
	if isBank then
		for bagID = 5, 11 do
			totalFreeSlots = totalFreeSlots + GetContainerNumFreeSlots(bagID)
		end
		
		totalFreeSlots = totalFreeSlots + GetContainerNumFreeSlots(BANK_CONTAINER)
	else
		for bagID = 0, 4 do
			totalFreeSlots = totalFreeSlots + GetContainerNumFreeSlots(bagID)
		end
	end
	
	return totalFreeSlots
end

local function GetPrevContainer(self,containerID,isBank)
	local index = containerID - 1
	local container;
	
	if index < 1 then return end
	
	repeat
		if isBank then
			container = _G["SyncUI_BankFrame_Container"..index]
		else
			container = _G["SyncUI_BagFrame_Container"..index]
		end
		
		if container:IsShown() then
			return container:GetName()
		else
			index = index - 1
		end

	until index == 0
end

local function GetButton(bagID,slot)
	if bagID and slot then
		if isBank(bagID) then
			if bagID == -1 then
				return _G["SyncUI_BankFrame_Bag1_Slot"..slot]
			else
				return _G["SyncUI_BankFrame_Bag"..bagID-3 .."_Slot"..slot]
			end
		else
			return _G["SyncUI_BagFrame_Bag"..bagID+1 .."_Slot"..slot]
		end
	end
end


-- Update Functions
local function UpdateSlot(bagID,slot)
	local button = GetButton(bagID,slot)
	local container = GetContainerForItem(bagID,slot)
	
	if button then
		SyncUI_ItemSlot_ForceUpdate(button,bagID,slot)
	end
		
	if container then
		if button then
			local isEnabled = isEnabled(container,button)		
			
			if button.container and button.container ~= container then
				RemoveButtonFromContainer(button.container,button)
				SyncUI_ItemContainer_ForceUpdate(button.container)
			end
			
			if isEnabled then
				AddButtonToContainer(container,button)
				SyncUI_ItemContainer_ForceUpdate(container)
			end
		end
	elseif button and button.container then
		RemoveButtonFromContainer(button.container,button)
		SyncUI_ItemContainer_ForceUpdate(button.container)
	end
end

local function UpdateBag(bagID)
	local numSlots = GetContainerNumSlots(bagID)
	
	for slot = 1, numSlots do
		UpdateSlot(bagID,slot)
	end
end

local function UpdateAllBags(isBank)
	if isBank then
		for _, bagID in pairs({-1,5,6,7,8,9,10,11}) do
			UpdateBag(bagID)
		end
	else
		for bagID = 0, 4 do
			UpdateBag(bagID)
		end
	end
end

local function UpdateAllContainers(isBank)
	for i, category in pairs(ItemCategories) do
		local container;
		
		if isBank then
			container = _G["SyncUI_BankFrame_Container"..i]
		else
			container = _G["SyncUI_BagFrame_Container"..i]
		end
		
		SyncUI_ItemContainer_ForceUpdate(container)
	end
end

local function UpdateBankBagSlots()
	local numSlots, full = GetNumBankSlots()
	local cost = GetBankSlotCost(numSlots)
	local purchaseButton = SyncUI_BankFrame_BagBar_PurchaseButton
	
	for i = 1, NUM_BANKBAGSLOTS, 1 do
		local button = _G["SyncUI_BankFrame_BagBar_Bag"..i]

		local textureName = GetInventoryItemTexture("player",button:GetInventorySlot())
		local slotTextureName = select(2, GetInventorySlotInfo("Bag"..i))
		
		if textureName then
			button.icon:SetTexture(textureName)
			button.icon:Show()
			SetItemButtonCount(button,GetInventoryItemCount("player", button:GetInventorySlot()))
			button.hasItem = 1
		elseif slotTextureName and button.isBag then
			button.icon:SetTexture(slotTextureName)

			SetItemButtonCount(button,0)
			button.icon:Show()
		end
		
		if i <= numSlots then
			SetItemButtonTextureVertexColor(button, 1.0,1.0,1.0)
			button.tooltipText = BANK_BAG
		else
			SetItemButtonTextureVertexColor(button, 1.0,0.1,0.1)
			button.tooltipText = BANK_BAG_PURCHASE
		end
	end
	
	BankFrame.nextSlotCost = cost
	
	if full then
		purchaseButton:Hide()
		SyncUI_BankFrame_BagBar.border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Bags\\Bank_BagBar_Border2")
	else
		purchaseButton:Show()
	end
end

local function UpdateInventoryFreeSlot(self,isBank)
	local container = _G[self:GetName().."_Container1"]
	container.freeSlot.text:SetText(GetNumFreeSlots(isBank))	
end

local function UpdateSearchResults(frame)
	local bagID = frame:GetID()
	local numSlots = GetContainerNumSlots(bagID)
	
	for slot = 1, numSlots do
		local button = _G[frame:GetName().."_Slot"..slot]
		local isFiltered = select(8, GetContainerItemInfo(bagID, slot))
		if isFiltered then
			button.searchOverlay:Show()
		else
			button.searchOverlay:Hide()
		end
	end
end

local function UpdateFrameSize(self,height,isBank)
	local scrollFrame = self:GetParent():GetParent()
	local width, topEdge, bottomEdge, minHeight, maxHeight
	
	if isBank then
		width, topEdge, bottomEdge, minHeight, maxHeight = 464, 28, 50, 263,448
	else
		width, topEdge, bottomEdge, minHeight, maxHeight = 353, 28, 41, 254,439
	end
	
	height = height + topEdge + bottomEdge
	
	if height > maxHeight then
		height = maxHeight
	elseif height < minHeight then
		height = minHeight
	end
	
	scrollFrame:SetSize(width,height)
end

local function UpdateScrollChild(self,isBank)
	local scrollChild = self:GetParent()
	local container;
	local height = 0
	
	for i = 1, #ItemCategories do
		if isBank then
			container = _G["SyncUI_BankFrame_Container"..i]
		else
			container = _G["SyncUI_BagFrame_Container"..i]
		end
		
		if container:IsShown() then
			height = height + select(2, container:GetSize())
		end
	end

	-- Result is always divisible by 37
	height = math.ceil(height)
	height = 37 * (math.floor(height / 37))

	scrollChild:SetHeight(height)
	UpdateFrameSize(scrollChild,height,isBank)
end

local function UpdateContainerAnchors(isBank)
	local container, containerID, containerAnchor;
	
	for i = 1, #ItemCategories do
		if isBank then
			container = _G["SyncUI_BankFrame_Container"..i]
		else
			container = _G["SyncUI_BagFrame_Container"..i]
		end
		
		if container:IsShown() then
			containerID = container:GetID()
			
			if containerID ~= 1 then
				containerAnchor = GetPrevContainer(container,containerID,isBank)

				container:ClearAllPoints()
				container:SetPoint("TOPLEFT",containerAnchor,"BOTTOMLEFT")
			end
		end
	end
end

local function UpdateNewItems()
	for bagID = 0, 4 do
		for slot = 1, GetContainerNumSlots(bagID) do
			local button = GetButton(bagID,slot)

			SyncUI_ItemSlot_ForceUpdate(button,bagID,slot)
		end
	end
end

local function RemoveNewItems()
	for bagID = 0, 4 do
		for slot = 1, GetContainerNumSlots(bagID) do
			local button = GetButton(bagID,slot)
			local texture = button.NewItem
			local flash = button.flashAnim
			local anim = button.newitemglowAnim

			texture:Hide()

			if flash:IsPlaying() or anim:IsPlaying() then
				flash:Stop()
				anim:Stop()
			end
  
			C_NewItems.RemoveNewItem(bagID,slot)
		end
	end
end


-- Global Functions
function SyncUI_ItemSlot_SetStyle(self)
	local bagID = self:GetParent():GetID()
	local slot = self:GetID()

	self:SetSize(37,37)
	self:SetNormalTexture("")
	self.IconBorder:SetTexture("")
	
	if self.BattlepayItemTexture then
		self.BattlepayItemTexture:Hide()
	end

	self.icon:SetSize(33,33)
	self.icon:SetDrawLayer("BACKGROUND")
	self.icon:ClearAllPoints()
	self.icon:SetPoint("CENTER")
	self.icon:SetTexCoord(0.05,0.95,0.05,0.95)

	self.Count:SetFontObject(SyncUI_GameFontNormal_Medium)
	self.Count:ClearAllPoints()
	self.Count:SetPoint("BOTTOMRIGHT",-2,4)
	
	self.searchOverlay:SetSize(33,33)
	self.searchOverlay:SetDrawLayer("OVERLAY")
	self.searchOverlay:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Bags\\ItemSlot_ItemSearch")
	self.searchOverlay:SetTexCoord(0,0.578125,0,0.578125)
	
	-- Create New Textures
	self.iconTex = self:CreateTexture(nil,"BORDER")
	self.iconTex:SetSize(37,37)
	self.iconTex:SetPoint("CENTER")
	self.iconTex:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Bags\\ItemSlot_ItemBorder")
	self.iconTex:SetTexCoord(0,0.578125,0,0.578125)
	
	self.quality = self:CreateTexture(nil,"ARTWORK")
	self.quality:SetSize(37,37)
	self.quality:SetPoint("CENTER")
	self.quality:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Bags\\ItemSlot_ItemQuality")
	self.quality:SetTexCoord(0,0.578125,0,0.578125)
	
	self.quest = self:CreateTexture(nil,"ARTWORK")
	self.quest:SetSize(37,37)
	self.quest:SetPoint("CENTER")
	self.quest:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Bags\\ItemSlot_ItemQuest")
	self.quest:SetTexCoord(0,0.578125,0,0.578125)
	self.quest:Hide()
	
	if not self.cooldown then
		self.cooldown = _G[self:GetName().."Cooldown"]
		SyncUI_Cooldown_OnRegister(self.cooldown)
	end
	
	if bagID == BANK_CONTAINER then
		self.GetInventorySlot = ButtonInventorySlot
		self.UpdateTooltip = SyncUI_BankSlot_OnEnter
		self:SetScript("OnEnter",SyncUI_BankSlot_OnEnter)
	end
	
	self.container = GetContainerForItem(bagID,slot)
	
	
	self:HookScript("OnClick", function(self,button)
		if IsControlKeyDown() and IsAltKeyDown() then
			local itemLink = select(7, GetContainerItemInfo(bagID,slot))
			local itemID = GetContainerItemID(bagID,slot)
			
			local type = select(6, GetItemInfo(itemLink))
			local subType = select(7, GetItemInfo(itemLink))
			
			print(itemLink)
			print("ItemID: "..itemID)
			print("Type: "..type)
			print("SubType: "..subType)
		end
	end)
end

function SyncUI_ItemSlot_ForceUpdate(self,bagID,slot)
	local texture, itemCount, locked, quality, readable, lootable, itemLink = GetContainerItemInfo(bagID, slot)
	SetItemButtonTexture(self, texture)
	SetItemButtonCount(self, itemCount)
	SetItemButtonDesaturated(self, locked)

	if itemLink then
		do	-- update Item Quality
			local type = select(6, GetItemInfo(itemLink))
			
			if isQuest(type) then
				self.quality:SetVertexColor(0.8,0.6,0)
				self.quality:Show()			
			elseif not quality or quality <= 1 then
				self.quality:Hide()
			else
				local c = ITEM_QUALITY_COLORS[quality]
				self.quality:SetVertexColor(c.r,c.g,c.b)
				self.quality:Show()
			end
		end
		do	-- update Sorting References
			self.rarity = quality
			self.stack = itemCount
			self.name = select(1, GetItemInfo(itemLink))
			self.ilvl = select(4, GetItemInfo(itemLink))
			self.type = select(7, GetItemInfo(itemLink))
		end
	
		if bagID ~= REAGENTBANK_CONTAINER then
			do	-- update Quest Icon
				isQuestItem, questID, isActive = GetContainerItemQuestInfo(bagID,slot)
				if questID then
					if isActive then
						self.quest:Hide()
					else
						self.quest:Show()
					end
				end
			end
			do	-- update Item Level
				local isEquip = select(9, GetItemInfo(itemLink))
				local itemLevel = select(4, GetItemInfo(itemLink))
				
				if isEquip ~= "" and isEquip ~= "INVTYPE_BAG" then
					SetItemButtonCount(self, itemLevel)
					self.Count:SetVertexColor(1,0.8,0)
				else
					self.Count:SetVertexColor(1,1,1)
				end
			end
			do	-- update New Items
				local isNewItem = C_NewItems.IsNewItem(bagID, slot)
				local texture = self.NewItem
				local flash = self.flashAnim
				local anim = self.newitemglowAnim

				if isNewItem then
					texture:Show()

					if not flash:IsPlaying() and not anim:IsPlaying() then
						flash:Play()
						anim:Play()
					end
				end
			end
		end

		self:Show()
	else
		self:Hide()
	end
end

function SyncUI_ItemBag_OnLoad(self)
	for i = 1, self:GetNumChildren() do
		local button = _G[self:GetName().."_Slot"..i]
		
		SyncUI_ItemSlot_SetStyle(button)
	end
end

function SyncUI_ItemContainer_OnLoad(self)
	self.buttons = {}
	self.text:SetWidth(self.text:GetStringWidth())
	self.text:SetText(ItemCategories[self:GetID()])

	if self:GetID() ~= 1 then self:Hide() end
end

function SyncUI_ItemContainer_ForceUpdate(self)
	local isBank = self:GetName():find("Bank")
	local buttonSize, rowMax = 37, rowMaxBag
	local numSlots = #self.buttons
	
	table.sort(self.buttons,SortContainer)
	SortInventoryFreeSlot(self)
	
	if isBank then
		rowMax = rowMaxBank
	end
		
	for i, button in pairs(self.buttons) do
		local pos = i % rowMax
		if pos == 0 then pos = rowMax end
		local row = math.ceil(i / rowMax)
			
		button:ClearAllPoints()
		button:SetPoint("TOPLEFT",self,buttonSize*(pos-1),-buttonSize-(buttonSize*(row-1)))
	end

	if (numSlots == 0 or numSlots == nil) and self:GetID() ~= 1 then
		self:Hide()
	elseif numSlots > 0 then
		local width = self:GetParent():GetSize()
		local numRows = math.ceil(numSlots / rowMax)
		local height = (numRows + 1) * buttonSize
		
		self:SetSize(width,height)
		self:Show()
	end

	UpdateContainerAnchors(isBank)
	UpdateScrollChild(self,isBank)
end

function SyncUI_ItemContainer_FreeSlot_OnReceiveItem(self)
	local container = self:GetParent():GetName()
	local containerID = self:GetParent():GetID()
	local isBank = (container:find("Bank") and container:find("Container1"))
		
	if isBank then
		for _, bagID in pairs({-1,5,6,7,8,9,10,11}) do
			for slot = 1, GetContainerNumSlots(bagID) do
				if not GetContainerItemInfo(bagID,slot) then
					return PickupContainerItem(bagID, slot)
				end
			end
		end	
	elseif containerID == REAGENTBANK_CONTAINER then
		for slot = 1, GetContainerNumSlots(containerID) do
			if not GetContainerItemInfo(containerID,slot) then
				return PickupContainerItem(containerID,slot)
			end
		end
	else
		for bagID = 0, 4 do
			for slot = 1, GetContainerNumSlots(bagID) do
				if not GetContainerItemInfo(bagID,slot) then
					return PickupContainerItem(bagID, slot)
				end
			end
		end
	end
end


if IsAddOnLoaded("Bagnon") or IsAddOnLoaded("ArkInventory") or IsAddOnLoaded("cargBags_Nivaya") then return end


-- Bag Functions
function SyncUI_BagFrame_Toggle()
	if SyncUI_BagFrame:IsShown() and not BankFrame:IsShown() then
		SyncUI_BagFrame:Hide()
	else
		SyncUI_BagFrame:Show()
	end
end

function SyncUI_BagFrame_OnShow(self)
	self:RegisterEvent("ITEM_LOCKED")
	self:RegisterEvent("ITEM_UNLOCKED")
	
	if not self.firstTime then
		UpdateAllBags()
		UpdateAllContainers()
		UpdateInventoryFreeSlot(self)
		
		self.firstTime = true
	end
end

function SyncUI_BagFrame_OnHide(self)
	self:UnregisterEvent("ITEM_LOCKED")
	self:UnregisterEvent("ITEM_UNLOCKED")
	
	RemoveNewItems()
end

function SyncUI_BagFrame_OnLoad(self)
	tinsert(UISpecialFrames,self:GetName())
	
	hooksecurefunc("ToggleAllBags",SyncUI_BagFrame_Toggle)

	self:SetScale(SyncUI_UIScale)
	self:SetMinResize(353,200)
	self:SetMaxResize(353,439)
	
	self:RegisterEvent("INVENTORY_SEARCH_UPDATE")
	self:RegisterEvent("MERCHANT_SHOW")
	self:RegisterEvent("MERCHANT_CLOSED")
	self:RegisterEvent("MAIL_SHOW")
	self:RegisterEvent("MAIL_CLOSED")
	self:RegisterEvent("QUEST_ACCEPTED")
	self:RegisterEvent("QUEST_REMOVED")
	self:RegisterEvent("BAG_UPDATE")
	self:RegisterEvent("BAG_NEW_ITEMS_UPDATED")
	
	for i = 1, 12 do
		SyncUI_DisableFrame("ContainerFrame"..i)
	end
end

function SyncUI_BagFrame_OnEvent(self,event,...)
	if event == "INVENTORY_SEARCH_UPDATE" then
		for i = 1, 5 do
			local bag = _G[self:GetName().."_Bag"..i]
			UpdateSearchResults(bag)
		end
		
		for i = 1, 8 do
			local bag = _G["SyncUI_BankFrame_Bag"..i]
			UpdateSearchResults(bag)
		end

		UpdateSearchResults(SyncUI_BankFrame_ReagentBank)
	end
	
	if event == "MERCHANT_SHOW" or event == "MAIL_SHOW" then
		SyncUI_BagFrame:Show()
		
		if event == "MERCHANT_SHOW" then SellGreyItems() end
	end
	
	if event == "MERCHANT_CLOSED" or event == "MAIL_CLOSED" then
		SyncUI_BagFrame:Hide()
	end

	if event == "QUEST_ACCEPTED" or event == "QUEST_REMOVED" then
		UpdateAllBags()
	end
	
	if event == "ITEM_LOCKED" then
		local button = GetButton(...)
		if button then
			button.icon:SetDesaturated(true)
		end
	end

	if event == "ITEM_UNLOCKED" then
		local button = GetButton(...)
		if button then
			button.icon:SetDesaturated(false)
		end
	end	

	if event == "BAG_UPDATE" then
		local bagID = ...
		
		UpdateBag(bagID)
		UpdateInventoryFreeSlot(self)
		
		if bagID < 0 or bagID > 4 then
			UpdateInventoryFreeSlot(self,isBank)
		end
	end

	if event == "BAG_NEW_ITEMS_UPDATED" then
		UpdateAllBags()
	end
		
end

function SyncUI_BagFrame_CurrencyButton_OnEnter(self)
	local spacer
	
	GameTooltip:SetOwner(self, "ANCHOR_LEFT",-14,-26)

	-- watched list
	for index = 1, GetCurrencyListSize() do
		local name, isHeader, _, isUnused, isWatched, count, icon = GetCurrencyListInfo(index)
		
		if not isHeader and not isUnused and isWatched then
			if not spacer then
				spacer = true
			end
			
			GameTooltip:AddDoubleLine(name, count.." |T"..icon..":14:14:0:0:64:64:5:59:5:59|t",0,1,0.5,1,1,1)
		end
	end

	-- unwatched list
	for index = 1, GetCurrencyListSize() do
		local name, isHeader, _, isUnused, isWatched, count, icon = GetCurrencyListInfo(index)
		
		if not isHeader and not isWatched and not isUnused then
			if spacer then
				GameTooltip:AddLine(" ")
				spacer = false
			end
			
			GameTooltip:AddDoubleLine(name, count.." |T"..icon..":14:14:0:0:64:64:5:59:5:59|t",0.8,0.4,0.4,1,1,1)
		end
	end
	
	GameTooltip:Show()
end


-- Bank Functions
function SyncUI_BankSlot_OnEnter(self)
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
	GameTooltip:SetInventoryItem("player", self:GetInventorySlot())
	GameTooltip:Show()
end

function SyncUI_BankFrame_OnShow(self)
	BankFrame:Show()
	BankFrame:UnregisterAllEvents()
	BankFrame.selectedTab = 1
	SyncUI_BagFrame:Show()
	
	self.bank:Show()
	self.reagentBank:Hide()
	
	if not self.firstTime then
		UpdateAllContainers(isBank)
		UpdateAllBags(isBank)
		UpdateAllContainers(isBank)
		UpdateBankBagSlots()
		UpdateInventoryFreeSlot(self,isBank)
		
		self.firstTime = true
	end
end

function SyncUI_BankFrame_OnLoad(self)
	BankFrame:UnregisterAllEvents()
	BankFrame:SetPoint("TOPRIGHT",UIParent,"TOPLEFT")

	self:SetScale(SyncUI_UIScale)	
	self:RegisterEvent("BANKFRAME_OPENED")
	self:RegisterEvent("BANKFRAME_CLOSED")
	self:RegisterEvent("PLAYERBANKSLOTS_CHANGED")
	self:RegisterEvent("PLAYERBANKBAGSLOTS_CHANGED")

	UIPanelWindows[self:GetName()] = { area = "left", pushable = 0, width = 464 }
end

function SyncUI_BankFrame_OnEvent(self,event,...)
	if event == "BANKFRAME_OPENED" then		
		ShowUIPanel(self)
	end
	
	if event == "BANKFRAME_CLOSED" then
		HideUIPanel(self)
	end
	
	if event == "PLAYERBANKSLOTS_CHANGED" then
		UpdateAllBags(isBank)
		UpdateBankBagSlots()
		UpdateInventoryFreeSlot(self,isBank)
	end
	
	if event == "PLAYERBANKBAGSLOTS_CHANGED" then
		UpdateBankBagSlots()
		UpdateInventoryFreeSlot(self,isBank)
	end
end


-- Scroll Frame Fix
function SyncUI_ItemContainer_ScrollFrame_OnLoad(self)
	self.ScrollBar.scrollStep = 37

	ScrollFrame_OnLoad(self)
	ScrollFrame_OnScrollRangeChanged(self)
end

function SyncUI_ItemContainer_ScrollFrame_OnScrollRangeChanged(self,xRange,yRange)
	local scrollBar = self.ScrollBar or _G[self:GetName().."ScrollBar"]
	local scrollDown = _G[scrollBar:GetName().."ScrollDownButton"]
	local scrollUp = _G[scrollBar:GetName().."ScrollUpButton"]
	local scrollThumb = _G[scrollBar:GetName().."ThumbTexture"]
	local value = scrollBar:GetValue()
	
	if not yRange then
		yRange = self:GetVerticalScrollRange()
	end

	yRange = yRange - 26.5	-- mysterious value to fix
	
	if yRange < 0 then
		yRange = 0
	end

	if value > yRange then
		value = yRange
	end
	
	scrollBar:SetMinMaxValues(0, yRange)
	scrollBar:SetValue(value)

	if floor(yRange) == 0 then
		scrollBar:Hide()
		scrollDown:Hide()
		scrollUp:Hide()
	else
		scrollBar:Show()
		scrollDown:Show()
		scrollUp:Show()
		scrollThumb:Show()

		if yRange - value > 0.005 then
			scrollDown:Enable()
		else
			scrollDown:Disable()
		end
	end
end
