--[[	TalentUI 2.0
	
	This is a whole Talent/Glyph/Spec  all-in-one replacement for the Blizzard's default frames!

------------------]]

local _G, glyphSpells, selectedGlyphs = _G, {}, {}

local function OverrideTalentKeyBind()
	local key = GetBindingKey("TOGGLETALENTS")

	if key then
		SetOverrideBinding(TalentMicroButton,true,key,"CLICK SyncUI_TalentMicroButton:LeftButton")
	else
		ClearOverrideBindings(TalentMicroButton)
	end
end

local function CheckMissingGlyphs(self)
	local count = 0
	if not IsGlyphFlagSet(1) then ToggleGlyphFilter(1) end
	if not IsGlyphFlagSet(2) then ToggleGlyphFilter(2) end
	
	for index = 1, GetNumGlyphs() do
		local isKnown = select(3, GetGlyphInfo(index))
		
		if not isKnown then
			count = count + 1
		end
	end
	
	if count == 0 then
		self.Missing:Hide()
	end
end


function SyncUI_TalentUI_OnLoad(self)
	LoadAddOn('Blizzard_TalentUI')
	SyncUI_DisableFrame("PlayerTalentFrame")
	
	self:SetScale(SyncUI_UIScale)
	self:RegisterEvent("UPDATE_BINDINGS")

	UIPanelWindows[self:GetName()] = { area = "left", pushable = 1, whileDead = 1, width = 272, height = 345 }
	ShowUIPanel(self)	-- have to use this in order to prevent taint while reloading in combat..
	
	OverrideTalentKeyBind()
end

function SyncUI_TalentUI_OnEvent(self,event,...)
	if event == "UPDATE_BINDINGS" then
		OverrideTalentKeyBind()
	end
end

function SyncUI_TalentUI_Switch_OnEnter(self)
	local activeSpec, specID = GetActiveSpecGroup(), nil
	
	if activeSpec == 1 and GetNumSpecGroups() > 1 then specID = 2 end
	if activeSpec == 2 then specID = 1 end

	specID = GetSpecialization(nil,nil,specID)
	
	GameTooltip:SetOwner(SyncUI_TalentUI, "ANCHOR_RIGHT",-51,-34)
	
	if GetNumSpecGroups() > 1 then
		local colors = SYNCUI_CLASS_COLORS[select(2, UnitClass("player"))]
		local r, g, b = colors.r, colors.g, colors.b
			
		if specID then
			local id, name, description, icon, background, role = GetSpecializationInfo(specID)

			GameTooltip:AddLine("|cFF00FF99Click|r |cFFFFFFFFto activate|r "..name,r,g,b)
		else
			GameTooltip:AddLine("|cFF00FF99Click|r |cFFFFFFFFto activate|r ".."unselected",r,g,b)
		end
	else
		GameTooltip:AddLine("You have not learned Dual Spec",1,0,0)
	end
	
	GameTooltip:Show()
end

function SyncUI_TalentUI_Switch_OnUpdate(self)
	local activeSpec, specID = GetActiveSpecGroup(), nil
	
	if activeSpec == 1 and GetNumSpecGroups() > 1 then specID = 2 end
	if activeSpec == 2 then specID = 1 end

	specID = GetSpecialization(nil,nil,specID)
	
	if GetNumSpecGroups() > 1 then
		if specID then
			local id, name, description, icon, background, role = 
			
			self.Icon:SetTexture(select(4, GetSpecializationInfo(specID)))
		else
			self.Icon:SetTexture("Interface\\Icons\\inv_misc_questionmark")
		end
	else
		self.Icon:SetTexture("Interface\\Icons\\trade_engineering")
	end
end


function SyncUI_SpecButton_OnLoad(self)
	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("PLAYER_SPECIALIZATION_CHANGED")
	self:SetAttribute("type1","macro")
	self:SetAttribute("macrotext",
		"/stopmacro [combat]\n"..
		"/click SyncUI_SpecButtonInit\n"..
		"/click PlayerTalentFrameSpecializationSpecButton"..self:GetID().."\n"..
		"/click PlayerTalentFrameSpecializationLearnButton\n"..
		"/click StaticPopup1Button1\n"..
		"/click StaticPopup2Button1\n"..
		"/click StaticPopup3Button1\n"..
		"/click StaticPopup4Button1\n"
	)
end

function SyncUI_SpecButton_OnEvent(self,event,...)
	local buttonID = self:GetID()
	local specID = GetSpecialization()
	local numSpecs = GetNumSpecializations()
	local icon = select(4, GetSpecializationInfo(buttonID, false, false, nil, UnitSex("player")))
	
	self.icon:SetTexture(icon)
	
	if specID == buttonID then
		self.icon:SetDesaturated(false)
		self.selection:Show()
		self.isSelected = true
	else
		self.icon:SetDesaturated(true)
		self.selection:Hide()
		self.isSelected = false
	end
	
	if InCombatLockdown() then return end
	
	if event == "PLAYER_LOGIN" then
		if buttonID == numSpecs then
			self:Show()
		end
	end
end

function SyncUI_SpecButton_OnEnter(self)
	local _, name, text = GetSpecializationInfo(self:GetID(),false,false,nil,UnitSex("player"))
	
	GameTooltip:SetOwner(SyncUI_TalentUI, "ANCHOR_RIGHT",-51,-34)
	GameTooltip:AddLine(name)
	GameTooltip:AddLine(text,1,1,1,true)
	
	if not self.isSelected then
		GameTooltip:AddLine(TALENT_SPEC_CHANGE_AT_CLASS_TRAINER,1,0,0)
	end
	
	GameTooltip:Show()
end


function SyncUI_TalentButton_OnLoad(self)
	local buttonID = self:GetID()
	local talentRow = math.ceil(buttonID/3)
	local talentID = ((buttonID-1)%3+1)

	self:RegisterForDrag("LeftButton")
	self:SetAttribute("type1","macro")
	self:SetAttribute("macrotext",
		"/stopmacro [combat]\n"..
		"/click SyncUI_TalentButtonInit\n"..
		"/click PlayerTalentFrameTalentsTalentRow"..talentRow.."Talent"..talentID.."\n"..
		"/click StaticPopup1Button1\n"..
		"/click StaticPopup2Button1\n"..
		"/click StaticPopup3Button1\n"..
		"/click StaticPopup4Button1\n"..
		"/run SyncUI_TalentButton_LearnTalent("..buttonID..")\n"
	)
end

function SyncUI_TalentButton_OnUpdate(self)
	local buttonID = self:GetID()
	local talentRow, talentID = math.ceil(buttonID/3), ((buttonID-1)%3+1)
	local specID = GetActiveSpecGroup()
	local _,_,texture,selected = GetTalentInfo(talentRow,talentID,specID)
	local level = UnitLevel("player")
	local unlockLvL;
	
	self.icon:SetTexture(texture)

	if talentRow == 7 then
		unlockLvL = 100
	else
		unlockLvL = talentRow * 15
	end
		
	if selected or level < unlockLvL then
		self.icon:SetDesaturated(false)
		self.selection:Show()
	else
		self.icon:SetDesaturated(true)
		self.selection:Hide()
	end

	if level < unlockLvL then
		self.locked:Show()
		self.selection:Hide()
	else
		self.locked:Hide()
	end
end

function SyncUI_TalentButton_LearnTalent(buttonID)
	local talentRow, talentID = math.ceil(buttonID/3), ((buttonID-1)%3+1)
	local isFree, currID = GetTalentRowSelectionInfo(talentRow)
	local specID = GetActiveSpecGroup()
	local spellID = GetTalentInfo(talentRow,talentID,specID)
	
	if spellID == currID then return end

	C_Timer.After( isFree and 0 or 0.1, function()
		LearnTalents(spellID)
	end)
end

function SyncUI_TalentButton_OnEnter(self)
	local buttonID = self:GetID()
	local talentRow, talentID = math.ceil(buttonID/3), ((buttonID-1)%3+1)
	local specID = GetActiveSpecGroup()
	local spellID = GetTalentInfo(talentRow,talentID,specID)
	
	GameTooltip:SetOwner(SyncUI_TalentUI, "ANCHOR_RIGHT",-51,-34)
	GameTooltip:SetTalent(spellID)
	
	do	-- change tooltip if talent is not available by lvl
		local level, unlockLvL = UnitLevel("player"), nil
		
		if talentRow == 7 then
			unlockLvL = 100
		else
			unlockLvL = talentRow * 15
		end
		
		if level < unlockLvL then
			local num = GameTooltip:NumLines()
			local line = _G["GameTooltipTextLeft"..num]
			local text = gsub(line:GetText(),"Left click to select this talent.","<Available at level "..unlockLvL..">")
			line:SetText(text)
			line:SetVertexColor(0.5,0.5,0.5)
		end
	end
	
	GameTooltip:Show()
end


function SyncUI_GlyphFrame_OnLoad(self)
	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	
	if UnitLevel("player") < 25 then
		self:Hide()
		self:RegisterEvent("PLAYER_LEVEL_UP")
	end
end

function SyncUI_GlyphFrame_OnEvent(self,event,...)
	if event == "PLAYER_LOGIN" then
		CheckMissingGlyphs(self)
	end
	
	if event == "ACTIVE_TALENT_GROUP_CHANGED" then
		if not InCombatLockdown() then
			SyncUI_GlyphSelectFrame:Hide()
		end
	end
	
	if event == "PLAYER_LEVEL_UP" then
		if UnitLevel("player") == 14 then
			if InCombatLockdown() then
				self:RegisterEvent("PLAYER_REGEN_ENABLED")
			else
				self:Show()
			end
			
			self:UnregisterEvent("PLAYER_LEVEL_UP")
		end
	end
	
	if event == "PLAYER_REGEN_ENABLED" then
		self:UnregisterEvent("PLAYER_REGEN_ENABLED")
		self:Show()
	end
end

function SyncUI_GlyphFrame_Missing_OnEnter(self)
	-- apply glyph filters
	if not IsGlyphFlagSet(1) then ToggleGlyphFilter(1) end
	if not IsGlyphFlagSet(2) then ToggleGlyphFilter(2) end

	local numMinor, numMayor = 0, 0
	local spacerMinor, spacerMayor;
	local isHeader;
	
	-- Mayor Glyphs
	for index = 1, GetNumGlyphs() do
		local name, type, isKnown, icon, glyphID, glyphLink = GetGlyphInfo(index)
		
		if not isKnown and type == 1 then
			numMayor = numMayor + 1
			
			if not isHeader then
				isHeader = true
				
				GameTooltip:SetOwner(SyncUI_TalentUI, "ANCHOR_BOTTOMRIGHT",0,310)
				GameTooltip:AddLine("Missing Glyphs",0,1,0.6)
			end
			
			if not spacerMayor then
				GameTooltip:AddLine(" ")
				GameTooltip:AddLine("Mayor Glyphs:")
				spacerMayor = true
			end
			
			GameTooltip:AddLine("|T"..icon..":25:25:0:0:64:64:4:60:4:60|t "..name,1,1,1)
		end
	end
	
	-- Minor Glyphs
	for index = 1, GetNumGlyphs() do
		local name, type, isKnown, icon, glyphID, glyphLink = GetGlyphInfo(index)
		
		if not isKnown and type == 2 then
			numMinor = numMinor + 1
			
			if not isHeader then
				isHeader = true
				
				GameTooltip:SetOwner(SyncUI_TalentUI, "ANCHOR_BOTTOMRIGHT",0,310)
				GameTooltip:AddLine("Missing Glyphs",0,1,0.6)
			end
			
			if not spacerMinor then
				GameTooltip:AddLine(" ")
				GameTooltip:AddLine("Minor Glyphs:")
				spacerMinor = true
			end
			
			GameTooltip:AddLine("|T"..icon..":25:25:0:0:64:64:4:60:4:60|t "..name,1,1,1)
		end
	end
	
	if SyncUI_GlyphSelectFrame:IsShown() then
		SyncUI_GlyphSelectFrame:Hide()
	end
	
	GameTooltip:Show()
end


function SyncUI_GlyphButton_OnLoad(self)
	self:RegisterForClicks("LeftButtonUp")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
end

function SyncUI_GlyphButton_OnEvent(self,event,...)
	if event == "PLAYER_REGEN_ENABLED" then
		self.icon:SetDesaturated(false)
	end
	
	if event == "PLAYER_REGEN_DISABLED" then
		self.icon:SetDesaturated(true)
	end
end

function SyncUI_GlyphButton_OnUpdate(self)
	local buttonID = self:GetID()
	local specID = GetActiveSpecGroup()
	local enabled,glyphType,_,glyphID,icon = GetGlyphSocketInfo(buttonID, specID)
	
	self.glyphID = glyphID
	self.icon:SetTexture(icon)
	self.type = glyphType
	
	selectedGlyphs[buttonID] = select(1, GetSpellInfo(glyphID))
	
	if not enabled then
		self.locked:Show()
	else
		self.locked:Hide()
	end
end

function SyncUI_GlyphButton_OnClick(self)
	if InCombatLockdown() then return end
	
	-- clear the table
	glyphSpells = {}
	
	-- set info for select frame
	local buttonID = self:GetID()
	local numShownGlyphs = 0
	
	-- toggle glyph filters first
	if buttonID == 2 or buttonID == 4 or buttonID == 6 then
		-- major glyphs:
		if not IsGlyphFlagSet(1) then ToggleGlyphFilter(1) end
		if IsGlyphFlagSet(2) then ToggleGlyphFilter(2) end
	elseif buttonID == 1 or buttonID == 3 or buttonID == 5 then
		-- minor glyphs:
		if not IsGlyphFlagSet(2) then ToggleGlyphFilter(2) end
		if IsGlyphFlagSet(1) then ToggleGlyphFilter(1) end
	end
	
	-- set glyph spells
	for index = 1, GetNumGlyphs() do
		local name, glyphType, isKnown, icon, glyphID, glyphLink, glyphSpec = GetGlyphInfo(index)
		local specID, currSpec = GetActiveSpecGroup(), GetSpecialization()
		local specName, isUsed = "unknown", nil

		glyphSpec = tostring(glyphSpec):lower()

		if currSpec then
			specName = select(2, GetSpecializationInfo(currSpec)):lower()
			
			if specName == "équilibre" then
				specName = "equilibre"
			end
		end
		
		-- filter used glyphs
		for _, newName in pairs(selectedGlyphs) do
			if newName:lower():find(name:lower()) then
				isUsed = true
			end
		end
		
		-- filter glyphs that are...
			-- not learnt
			-- not usable by current spec
			-- not fit with the minor/major behavior
			-- already used
		 
		if isKnown and (self.type == glyphType) and (glyphSpec == "" or glyphSpec:find(specName)) and not isUsed then
			local i = #glyphSpells + 1
			glyphSpells[i] = {icon,glyphID}
			
			local button = _G["SyncUI_GlyphSelectFrameSlot"..i]
			if button then
				button.icon:SetTexture(glyphSpells[i][1])
				button.glyphID = glyphSpells[i][2]
				button:RegisterForClicks("LeftButtonUp")
				button:SetAttribute("type","glyph")
				button:SetAttribute("glyph",name)
				button:SetAttribute("slot",buttonID)
				button:HookScript("OnClick",function()
					if InCombatLockdown() then
						return
					end
					
					SyncUI_GlyphSelectFrame:Hide()
				end)
				
				numShownGlyphs = numShownGlyphs + 1
			end
		end
	end

	
	do	-- update frame size
		-- INFO: local buttonSize, buttonsPerRow, numButtons, edgeSize == 40, 5, 20, 10
		local width = 40*5+10
		local height = 40*(math.ceil(numShownGlyphs / 5)) + 10
		
		if numShownGlyphs < 5 then
			width = 40*numShownGlyphs+10
		end
		
		for i = 1, 20 do
			local button = _G["SyncUI_GlyphSelectFrameSlot"..i]
			
			if i <= numShownGlyphs then
				button:Show()
			else
				button:Hide()
			end
		end

		SyncUI_GlyphSelectFrame:SetSize(width,height)
	end
	
	-- toggle select frame
	if SyncUI_GlyphSelectFrame.openID == buttonID and SyncUI_GlyphSelectFrame:IsShown() or numShownGlyphs <= 0 then
		SyncUI_GlyphSelectFrame:Hide()
	else
		SyncUI_GlyphSelectFrame:ClearAllPoints()
		SyncUI_GlyphSelectFrame:SetPoint("TOPLEFT",self,"TOPRIGHT",17,5)
		SyncUI_GlyphSelectFrame.openID = buttonID
		
		if not SyncUI_GlyphSelectFrame:IsShown() then
			SyncUI_GlyphSelectFrame:Show()
		end
	end
end


function SyncUI_PetTalentButton_OnLoad(self)
	self:SetAttribute("type1","macro")
	self:SetAttribute("macrotext",
		"/stopmacro [combat]\n"..
		"/click SyncUI_PetTalentFrame\n"..
		"/click PlayerTalentFramePetSpecializationSpecButton"..self:GetID().."\n"..
		"/click PlayerTalentFramePetSpecializationLearnButton\n"..
		"/click StaticPopup1Button1\n"..
		"/click StaticPopup2Button1\n"..
		"/click StaticPopup3Button1\n"..
		"/click StaticPopup4Button1\n"
	)
end

function SyncUI_PetTalentButton_OnUpdate(self)
	local specID = GetSpecialization(_,true)
	local icon = select(4, GetSpecializationInfo(self:GetID(), false, true, nil))
	
	if self.icon:GetTexture() ~= icon then self.icon:SetTexture(icon) end
	if specID == self:GetID() then
		self.icon:SetDesaturated(false)
		self.selection:Show()
	else
		self.icon:SetDesaturated(true)
		self.selection:Hide()
	end
end

function SyncUI_PetTalentButton_OnEnter(self)
	local _, name, description = GetSpecializationInfo(self:GetID(), false, true, nil)
	
	GameTooltip:SetOwner(SyncUI_TalentUI, "ANCHOR_RIGHT",-51,-34)
	GameTooltip:AddLine(name)
	GameTooltip:AddLine(description,1,1,1,true)
	GameTooltip:Show()
end
