--[[	handler functions for the afk mode

------------------]]

local awayTime, fadeTime, camSpeed = 0, 0.5, 0.05
local framesToFade = {}
local isFlightMode, prevAFKState

local function FadeIn(frame,duration)
	if not InCombatLockdown() then frame:Show() end
	frame:SetAlpha(0)
	frame.duration = duration
	frame.fadeMode = "fadeIn"
	tinsert(framesToFade, frame)
end

local function FadeOut(frame,duration)
	frame:SetAlpha(1)
	frame.duration = duration
	frame.fadeMode = "fadeOut"
	tinsert(framesToFade, frame)
end

local function SetAwayMode(status)
	if status == true then
		FadeOut(UIParent,fadeTime)
		FadeOut(SyncUI_UIParent,fadeTime)
		FadeIn(SyncUI_AwayStatusFrame,fadeTime)
		MoveViewLeftStart(camSpeed)
		SetView(4)
		awayTime = 0

		if isFlightMode then
			CameraZoomOut(15)
			SyncUI_AwayStatusFrame.Title:SetText("FLIGHT-Mode")
			SyncUI_AwayStatusFrame.anim1:Hide()
			SyncUI_AwayStatusFrame.anim2:Hide()
			SyncUI_AwayStatusFrame.FlightStop:Show()
		else
			SyncUI_AwayStatusFrame.Title:SetText("AFK-Mode")
			SyncUI_AwayStatusFrame.anim1:Show()
			SyncUI_AwayStatusFrame.anim2:Show()
			SyncUI_AwayStatusFrame.FlightStop:Hide()
		end
		
		do	-- Open Music Player
			if SyncUI_MusicPlayer and not SyncUI_MusicPlayer:IsShown() then
				SyncUI_ToggleMusicPlayer()
			end
		end

		do	-- Open Chat
			SyncUI_ChatFrame:SetParent(SyncUI_AwayMode)
			
			if not SyncUI_ChatFrame:IsShown() then
				SyncUI_ToggleChatWindowButton:Click()
			end
		end
	elseif status == false and SyncUI_AwayStatusFrame:IsVisible() then
		FadeIn(UIParent,fadeTime)
		FadeIn(SyncUI_UIParent,fadeTime)
		FadeOut(SyncUI_AwayStatusFrame,fadeTime)
		MoveViewLeftStop()
		
		do	-- Close Music Player
			if SyncUI_MusicPlayer then
				SyncUI_ToggleMusicPlayer()
			end
		end

		SyncUI_ChatFrame:SetParent(SyncUI_UIParent)
	end
	
	SetCVar("AutoClearAFK", 1)
end


function SyncUI_AwayMode_OnLoad(self)
	self:RegisterEvent("PLAYER_FLAGS_CHANGED")
	self:RegisterEvent("UPDATE_BATTLEFIELD_STATUS")
	self:RegisterEvent("LFG_PROPOSAL_SHOW")
	self:RegisterEvent("TAXIMAP_OPENED")
	SetCVar("autoClearAFK", "1")
end

function SyncUI_AwayMode_OnEvent(self,event,...)
	if InCombatLockdown() then return end

	if event == "PLAYER_FLAGS_CHANGED" then
		local isAFK = UnitIsAFK("player")
		if not prevAFKState and isAFK then
			prevAFKState = true
			SetAwayMode(true)
		elseif prevAFKState and not isAFK then
			prevAFKState = false
			SetAwayMode(false)
		end
	end

	if event == "LFG_PROPOSAL_SHOW" then
		SetAwayMode(false)
	end
	if event == "UPDATE_BATTLEFIELD_STATUS" then
		local status = GetBattlefieldStatus(...)
		if status == "confirm" then
			SetAwayMode(false)
		end
	end

	if event == "TAXIMAP_OPENED" then
		self:RegisterEvent("PLAYER_CONTROL_LOST")
	end
	if event == "PLAYER_CONTROL_LOST" then
		self:RegisterEvent("PLAYER_CONTROL_GAINED")
		self:UnregisterEvent("PLAYER_CONTROL_LOST")
		isFlightMode = true
		SetAwayMode(true)
	end
	if event == "PLAYER_CONTROL_GAINED" then
		self:UnregisterEvent("PLAYER_CONTROL_GAINED")
		isFlightMode = false
		SetAwayMode(false)
	end
end

function SyncUI_AwayMode_OnUpdate(self,elapsed)
	local index = 1
	while framesToFade[index] do
		local frame = framesToFade[index]
		local mode = frame.fadeMode
		local duration = frame.duration
		local alpha = frame:GetAlpha()
		
		if mode == "fadeIn" then
			if alpha < 1 then
				alpha = alpha + (elapsed / duration)
				frame:SetAlpha(alpha)
			else
				tremove(framesToFade, index)
			end
		elseif mode == "fadeOut" then
			if alpha > 0 then
				alpha = alpha - (elapsed / duration)
				frame:SetAlpha(alpha)
			else
				if not InCombatLockdown() then frame:Hide() end
				tremove(framesToFade, index)
			end
		end
		
		index = index + 1
	end
end

function SyncUI_AwayStatusFrame_OnUpdate(self,elapsed)
	awayTime = awayTime + elapsed
	local minutes = math.floor(awayTime / 60)
	local seconds = math.floor(awayTime) - (minutes * 60)

	self.isFlightMode = isFlightMode
	
	if minutes < 10 then
		if seconds >= 10 then
			self.Time:SetText("0"..minutes..":"..seconds)
		else
			self.Time:SetText("0"..minutes..":0"..seconds)
		end
	else
		if seconds >= 10 then
			self.Time:SetText(minutes..":"..seconds)
		else
			self.Time:SetText(minutes..":0"..seconds)
		end
	end
end

function SyncUI_CancelAwayMode(self,button)
	SetAwayMode(false)
end


--ScreenSaver
local Sky = {
	{"NexusRaid_RuneEffects_Nebula",3,0,0,-3,0},
	{"NexusRaid_RuneEffects_Starry",1.5,0,0.6,0},
}
function SyncUI_RunicScreen_OnSetAnimation(self)
	local num = self:GetID()
	local path, camZoom, zPos, xPos, yPos = unpack(Sky[num])

	self:SetModel("ENVIRONMENTS/STARS/"..path)
	self:SetCamDistanceScale(camZoom)
	self:SetPosition(zPos,xPos,yPos)
	self:SetAlpha(0.3/num)
end