--[[	handler functions for arena frames

------------------]]

local numDiminish, diminishReset = 4, 18

local CrowdControl = {
	["IMMUNE"] = {
		[   642] = "Divine Shield",
		[ 19263] = "Deterrence",
		[ 31224] = "Cloak of Shadows",
		[ 45438] = "Ice Block",
		[ 46924] = "Bladestorm",
		[ 47585] = "Dispersion",
		[ 48792] = "Icebound Fortitude",
		[ 49039] = "Lichborne",
		[110617] = "Deterrence (Symbiosis)",
		[110696] = "Ice Block (Symbiosis)",
		[110700] = "Divine Shield (Symbiosis)",
		[110715] = "Dispersion (Symbiosis)",
		[115018] = "Desecrated Ground",
		[122465] = "Dematerialize",
	},
	["CROWD"] = {
	--Stuns
		[108194] = "Asphyxiate",
		[ 91800] = "Gnaw",
		[ 91797] = "Monstrous Blow",
		[115001] = "Remorseless Winter",
		[ 22570] = "Maim",
		[  9005] = "Pounce",
		[  5211] = "Mighty Bash",
		[102795] = "Bear Hug",
		[113801] = "Bash",
		[110698] = "Hammer of Justice (Symbiosis)",
		-- Bash (Force of Nature)
		[ 24394] = "Intimidation",
		[ 50519] = "Sonic Blast",
		[ 90337] = "Bad Manner",
		--[ 96201] = "Web Wrap",
		[117526] = "Binding Shot",
		[ 44572] = "Deep Freeze",
		[118271] = "Combustion Impact",
		[119392] = "Charging Ox Wave",
		[119381] = "Leg Sweep",
		[122242] = "Clash",
		[120086] = "Fists of Fury",
		[   853] = "Hammer of Justice",
		[119072] = "Holy Wrath",
		[105593] = "Fist of Justice",
		-- Blinding Light (Glyphed)
		[  1833] = "Cheap Shot",
		[   408] = "Kidney Shot",
		[118905] = "Capacitor Totem",
		-- Pulverize (Earth Elemental)	
		[ 30283] = "Shadowfury",
		[ 89766] = "Axe Toss",
		[132168] = "Shockwave",
		[105771] = "Warbringer",
		[132169] = "Storm Bolt", 
		[ 20549] = "War Stomp",
	--Disorient
		[  2637] = "Hibernate",
		[    99] = "Disorienting Roar",
		[  3355] = "Freezing Trap",
		[ 19386] = "Wyvern Sting",
		[   118] = "Polymorph",
		[ 28272] = "Polymorph (pig)",
		[ 28271] = "Polymorph (turtle)",
		[ 61305] = "Polymorph (black cat)",
		[ 61025] = "Polymorph (serpent)",
		[ 61721] = "Polymorph (rabbit)",
		[ 61780] = "Polymorph (turkey)",
		[ 82691] = "Ring of Frost",
		[115078] = "Paralysis",
		[105421] = "Blinding Light",
		[ 20066] = "Repentance",
		[  9484] = "Shackle Undead",
		[ 88625] = "Holy Word: Chastise",
		[  1776] = "Gouge",
		[  6770] = "Sap",
		[ 51514] = "Hex",
		[107079] = "Quaking Palm",
	--Fear
		[  1513] = "Scare Beast",
		-- Intimidating Shout (Symbiosis)
		[ 10326] = "Turn Evil",
		[  8122] = "Psychic Scream",
		[113792] = "Psychic Terror",
		[  2094] = "Blind",
		[118699] = "Fear",
		[130616] = "Fear (glyphed)",
		[  5484] = "Howl of Terror",
		[  6358] = "Seduction (Succubus)",
		[115268] = "Mesmerize (Shivarra)",
		[104045] = "Sleep (Metamorphosis)",
		[  5246] = "Intimidating Shout (Aoe)",
		[ 20511] = "Intimidating Shout (Single)",
	--Horror 
		[ 64044] = "Psychic Horror",
		[ 87204] = "Sin and Punishment",
		[  6789] = "Mortal Coil",
		[137143] = "Blood Horror",
	--Others
		[33786] = "Cyclone",
		--Cyclone (Symbiosis)
		[605] = "Dominate Mind",
	},
	["SILENCE"] = {
		[ 47476] = "Strangulate",
		[ 81261] = "Solar Beam",
		[114238] = "Fae Silence",	
		[ 34490] = "Silencing Shot",
		[ 55021] = "Improved Counterspell",
		[102051] = "Frostjaw",
		[116709] = "Spear Hand Strike",
		[137460] = "Ring of Peace",
		[ 31935] = "Avenger's Shield",
		[ 15487] = "Silence",
		[  1330] = "Garrote",		
		[113287] = "Solar Beam (Symbiosis)",
		[ 24259] = "Spell Lock",
		[ 31117] = "Unstable Affliction",
		[115782] = "Optical Blast",
		[132409] = "Spell Lock (Grimoire of Sacrifice)",		
		[ 25046] = "Arcane Torrent (Energy)", 
		[ 28730] = "Arcane Torrent (Mana)",
		[ 50613] = "Arcane Torrent (Runic Power)",
		[ 69179] = "Arcane Torrent (Rage)",
		[ 80483] = "Arcane Torrent (Focus)",
		[129597] = "Arcane Torrent (Chi)",
	},
	["RANDOM"] = {
	--Stun
		[113953] = "Paralytic Poison",	
		[ 77505] = "Earthquake",	
		[118895] = "Dragon Roar",		
		[  7922] = "Charge",
	--Confuse
		[ 19503] = "Scatter Shot",
		[ 31661] = "Dragon's Breath",
	},
};

local DiminishingReturns = {
	["STUN"] = {
		[108194] = "Asphyxiate",
		[ 91800] = "Gnaw",
		[ 91797] = "Monstrous Blow",
		[115001] = "Remorseless Winter",

		[ 22570] = "Maim",
		[  5211] = "Mighty Bash",
		[  9005] = "Pounce",

		[117526] = "Binding Shot",
		[ 24394] = "Intimidation",

		[ 44572] = "Deep Freeze",

		[119392] = "Charging Ox Wave",
		[120086] = "Fists of Fury",
		[119381] = "Leg Sweep",

		[105593] = "Fist of Justice",
		[   853] = "Hammer of Justice",
		[119072] = "Holy Wrath",
		[115752] = "Blinding Light (Glyphed)",

		[  1833] = "Cheap Shot",
		[   408] = "Kidney Shot",

		[118345] = "Pulverize (Primal Earth Elemental)",
		[118905] = "Capacitor Totem",
		
		[ 30283] = "Shadowfury",
		[ 89766] = "Axe Toss",

		[132168] = "Shockwave",
		[132169] = "Storm Bolt", 

		[ 20549] = "War Stomp",
	},
	["INCAPACITATE"] = {
		[    99] = "Incapacitating Roar",
		
		[  3355] = "Freezing Trap",
		[ 19386] = "Wyvern Sting",

		[ 31661] = "Dragon's Breath",
		[   118] = "Polymorph",
		[ 28272] = "Polymorph (pig)",
		[ 28271] = "Polymorph (turtle)",
		[ 61305] = "Polymorph (black cat)",
		[ 61025] = "Polymorph (serpent)",
		[ 61721] = "Polymorph (rabbit)",
		[ 61780] = "Polymorph (turkey)",
		[ 82691] = "Ring of Frost",

		[115078] = "Paralysis",
		--[] = "Breath of Fire (Glyphed)",
		[137460] = "Ring of Peace",
		
		[ 20066] = "Repentance",

		[   605] = "Dominate Mind",
		[ 88625] = "Holy Word: Chastise",
		[ 64044] = "Psychic Horror",

		[  1776] = "Gouge",
		[  6770] = "Sap",
		
		[ 51514] = "Hex",
		
		[   710] = "Banish",
		[  6789] = "Mortal Coil", -- unsure
		[137143] = "Blood Horror",
		
		[107079] = "Quaking Palm",
	},
	["DISORIENT"] = {
		[ 33786] = "Cyclone",

		[ 10326] = "Turn Evil",
		
		[  8122] = "Psychic Scream",
		
		[  2094] = "Blind",
		
		[118699] = "Fear",
		[130616] = "Fear (glyphed)",
		[  5484] = "Howl of Terror",
		[115268] = "Mesmerize (Shivarra)",
		[  6358] = "Seduction (Succubus)",
		
		[  5246] = "Intimidating Shout (Aoe)",
		[ 20511] = "Intimidating Shout (Single)",
	},
	["SILENCE"] = {
		[ 47476] = "Strangulate",
		
		[ 81261] = "Solar Beam",
		[114238] = "Fae Silence",
		
		[102051] = "Frostjaw",
		
		[ 31935] = "Avenger's Shield",
		
		[ 15487] = "Silence",

		[  1330] = "Garrote",
		
		[ 25046] = "Arcane Torrent (Energy)", 
		[ 28730] = "Arcane Torrent (Mana)",
		[ 50613] = "Arcane Torrent (Runic Power)",
		[ 69179] = "Arcane Torrent (Rage)",
		[ 80483] = "Arcane Torrent (Focus)",
		[129597] = "Arcane Torrent (Chi)",
	},
};

local TotemIcons = {
	["Capacitor Totem"] = "Interface\\Icons\\spell_nature_brilliance",
	["Earth Elemental Totem"] = "Interface\\Icons\\spell_nature_earthelemental_totem",	
	["Earthbind Totem"] = "Interface\\Icons\\Spell_nature_strengthofearthtotem02",
	["Fire Elemental Totem"] = "Interface\\Icons\\spell_fire_elemental_totem",	
	["Grounding Totem"] = "Interface\\Icons\\Spell_nature_groundingtotem",
	["Healing Stream Totem"] = "Interface\\Icons\\Inv_spear_04",
	["Healing Tide Totem"] = "Interface\\Icons\\ability_shaman_healingtide",
	["Magma Totem"] = "Interface\\Icons\\Spell_fire_selfdestruct",
	["Searing Totem"] = "Interface\\Icons\\Spell_fire_searingtotem",
	["Stormlash Totem"] = "Interface\\Icons\\ability_shaman_tranquilmindtotem",	
	["Tremor Totem"] = "Interface\\Icons\\Spell_nature_tremortotem",	
	----
	["Mana Tide Totem"] = "Interface\\Icons\\Spell_frost_summonwaterelemental",	
	["Spirit Link Totem"] = "Interface\\Icons\\spell_shaman_spiritlink",
	----
	["Earthgrab Totem"] = "Interface\\Icons\\spell_nature_stranglevines",
	["Stone Bulwark Totem"] = "Interface\\Icons\\ability_shaman_stoneBulwark",
	["Windwalk Totem"] = "Interface\\Icons\\ability_shaman_windwalktotem",
}

local PetIcons = {
	["Basilisk"] = "Interface\\Icons\\Ability_Hunter_Pet_Crocolisk",
	["Bat"] = "Interface\\Icons\\Ability_Hunter_Pet_bat",
	["Bear"] = "Interface\\Icons\\ability_hunter_pet_bear",
	["Beetle"] = "Interface\\Icons\\inv_misc_ahnqirajtrinket_01",
	["Bird of Prey"] = "Interface\\Icons\\ability_hunter_pet_owl",
	["Boar"] = "Interface\\Icons\\ability_hunter_pet_boar",
	["Carrion Bird"] = "Interface\\Icons\\ability_hunter_pet_vulture",
	["Cat"] = "Interface\\Icons\\ability_hunter_pet_cat",
	["Chimaera"] = "Interface\\Icons\\ability_hunter_pet_chimera",
	["Core Hound"] = "Interface\\Icons\\ability_hunter_pet_corehound",
	["Crab"] = "Interface\\Icons\\ability_hunter_pet_crab",
	["Crane"] = "Interface\\Icons\\ability_mount_cranemountblue",
	["Crocolisk"] = "Interface\\Icons\\Ability_Hunter_Pet_Crocolisk",
	["Devilsaur"] = "Interface\\Icons\\ability_hunter_pet_devilsaur",
	["Direhorn"] = "Interface\\Icons\\ability_mount_triceratopsmount",
	["Dog"] = "Interface\\Icons\\inv_jewelry_necklace_22",
	["Dragonhawk"] = "Interface\\Icons\\ability_hunter_pet_dragonhawk",
	["Fox"] = "Interface\\Icons\\ability_hunter_aspectofthefox",
	["Goat"] = "Interface\\Icons\\ability_mount_mountainram",
	["Gorilla"] = "Interface\\Icons\\ability_hunter_pet_gorilla",
	["Hyena"] = "Interface\\Icons\\ability_hunter_pet_hyena",
	["Monkey"] = "Interface\\Icons\\ability_hunter_aspectofthemonkey",
	["Moth"] = "Interface\\Icons\\ability_hunter_pet_moth",
	["Nether Ray"] = "Interface\\Icons\\ability_hunter_pet_netherray",
	["Porcupine"] = "Interface\\Icons\\inv_pet_porcupine",
	["Quilen"] = "Interface\\Icons\\achievement_moguraid_01",
	["Raptor"] = "Interface\\Icons\\ability_hunter_pet_raptor",
	["Ravager"] = "Interface\\Icons\\ability_hunter_pet_ravager",
	["Rhino"] = "Interface\\Icons\\ability_hunter_pet_rhino",
	["Scorpid"] = "Interface\\Icons\\ability_hunter_pet_scorpid",
	["Serpent"] = "Interface\\Icons\\spell_nature_guardianward",
	["Shale Spider"] = "Interface\\Icons\\ability_hunter_pet_spider",
	["Silithid"] = "Interface\\Icons\\ability_hunter_pet_silithid",
	["Spider"] = "Interface\\Icons\\ability_hunter_pet_spider",
	["Spirit Beast"] = "Interface\\Icons\\ability_druid_primalprecision",
	["Sporebat"] = "Interface\\Icons\\ability_hunter_pet_sporebat",
	["Tallstrider"] = "Interface\\Icons\\ability_hunter_pet_tallstrider",
	["Turtle"] = "Interface\\Icons\\ability_hunter_pet_turtle",
	["Warp Stalker"] = "Interface\\Icons\\ability_hunter_pet_warpstalker",
	["Wasp"] = "Interface\\Icons\\ability_hunter_pet_wasp",
	["Water Strider"] = "Interface\\Icons\\inv_pet_waterstrider",
	["Wind Serpent"] = "Interface\\Icons\\ability_hunter_pet_windserpent",
	["Wolf"] = "Interface\\Icons\\ability_hunter_pet_wolf",
	["Worm"] = "Interface\\Icons\\ability_hunter_pet_worm",

	["Ghoul"] = "Interface\\Icons\\spell_deathknight_armyofthedead",
	["Water Elemental"] = "Interface\\Icons\\spell_frost_summonwaterelemental_2",
	["Felguard"] = "Interface\\Icons\\spell_shadow_summonfelguard",
	["Felhunter"] = "Interface\\Icons\\spell_shadow_summonfelhunter",
	["Fel Imp"] = "Interface\\Icons\\spell_warlock_summonimpoutland",
	["Imp"] = "Interface\\Icons\\spell_shadow_summonimp",
	["Observer"] = "Interface\\Icons\\warlock_summon_ beholder",
	["Shivarra"] = "Interface\\Icons\\warlock_summon_ shivan",
	["Succubus"] = "Interface\\Icons\\spell_shadow_summonsuccubus",
	["Voidlord"] = "Interface\\Icons\\warlock_summon_ voidlord",
	["Voidwalker"] = "Interface\\Icons\\spell_shadow_summonvoidwalker",
	["Wrathguard"] = "Interface\\Icons\\spell_warlock_summonwrathguard",
}


local function GetPriority(type)
	if type == "IMMUNE" then return 5 end
	if type == "CROWD" then	return 4 end
	if type == "SILENCE" then return 3 end
	if type == "RANDOM" then return 2 end
	return
end

local function UpdateTrinket(self)
	if not self.start then return end
	local start, duration = self.start, self.duration
	local timer = math.ceil(start + duration - GetTime())
	
	if timer > 60 then
		self.Text:SetText(math.ceil(timer/60).."m")
	elseif timer == 60 then
		self.Text:SetText("2m")
	elseif timer >= 1 then
		self.Text:SetText(timer)
	else
		self.Text:SetText("")
	end
end

local function UpdateDiminish(self)
	for i = 1, numDiminish do
		local max = self.Diminish.max
		
		for type = 1, max do
			local frame = self.frames[type]
			local size = select(1, frame:GetSize())
			local duration = math.ceil(frame.getTime + diminishReset - GetTime())

			-- set duration
			if frame.getTime == 0 then
				frame.Timer:SetText("...")
			elseif duration > 0 then
				frame.Timer:SetText(duration)
			else --[[if duration == 0 then --]]
				local newpos = type

				repeat
					local frame = self.frames[newpos]
					local nextFrame = self.frames[newpos+1]
					frame.type = nextFrame.type
					frame.getTime = nextFrame.getTime
					frame.iconTex = nextFrame.iconTex
					frame.drcount = nextFrame.drcount
					
					frame.Icon:SetTexture(frame.icon)
					frame.Cooldown:SetCooldown(frame.getTime,diminishReset)

					newpos = newpos + 1
				until newpos == max

				--reset the last frame
				local frame = self.frames[max-1]
				if frame then
					frame.type = 0
					frame.getTime = 0
					frame.iconTex = 0
					frame.drcount = 0
					frame:Hide()
				end

				self.Diminish.max = self.Diminish.max - 1
			end

			-- set count
			if frame.drcount == 0 or frame.drcount == 1 then
				frame.Count:SetText("½")
				frame.Count:SetTextColor(0,1,0)
			elseif frame.drcount == 2 then
				frame.Count:SetText("¼")
				frame.Count:SetTextColor(1,1,0)
			elseif frame.drcount >= 3 then
				frame.Count:SetText("ø")
				frame.Count:SetTextColor(1,0,0)
			end
		end

	end
end


function SyncUI_ArenaFrame_OnLoad(self)
	LoadAddOn("Blizzard_ArenaUI")
	SyncUI_DisableFrame("ArenaEnemyFrame"..self:GetID())
	SyncUI_DisableFrame("ArenaPrepFrame"..self:GetID())
	
	self.unitID = "arena"..self:GetID()
	self:SetAttribute("unit", self.unitID)
	self:SetAttribute("type1", "target")
	self:SetAttribute("type2", "focus")
	self:RegisterForClicks("AnyUp")
	
	self.Spec = self.ArtFrame.Spec
	self.Name = self.ArtFrame.Name
	self.Health = self.ArtFrame.Health
	self.StatusIcon = self.ArtFrame.StatusIcon
	self.Faction = self.ArtFrame.Faction
	
	self.frames = {
		[1] = self.Diminish1,
		[2] = self.Diminish2,
		[3] = self.Diminish3,
		[4] = self.Diminish4,
	}

	RegisterUnitWatch(self)
	SyncUI_RegisterUnitClickCasting(self)
end

function SyncUI_ArenaFrame_OnShow(self)
	local name, class = select(1, UnitName(self.unitID)), select(2, UnitClass(self.unitID))
	local instanceType = select(2, GetInstanceInfo())
	local faction = UnitFactionGroup(self.unitID)
	
	self.Name:SetText(name)
	
	if instanceType == "arena" then
		self.Spec:SetTexture(select(4, GetSpecializationInfoByID(GetArenaOpponentSpec(self:GetID()))))
		self.Spec:SetTexCoord(0.05,0.95,0.05,0.95)
	else
		local left, right, top, bottom = unpack(CLASS_ICON_TCOORDS[strupper(class)])
		
		self.Spec:SetTexture("Interface\\GLUES\\CHARACTERCREATE\\UI-CHARACTERCREATE-CLASSES")
		self.Spec:SetTexCoord(left+0.02, right-0.02, top+0.02, bottom-0.02)
	end
	
	if class then
		local color = SYNCUI_CLASS_COLORS[class]
		local r,g,b = color.r, color.g, color.b
		
		self.HealthBar:SetStatusBarColor(r,g,b,0)
	end

	if faction and faction ~= "Neutral" and instanceType ~= "arena" then
		self.Faction:SetTexture("Interface\\TargetingFrame\\UI-PVP-"..faction)
		self.Faction:Show()
	end
		
	self.Crowd:RegisterUnitEvent("UNIT_AURA",self.unitID)
	self.Trinket:RegisterUnitEvent("UNIT_SPELLCAST_SUCCEEDED",self.unitID)
	self.Diminish:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
end

function SyncUI_ArenaFrame_OnHide(self)
	self.StatusIcon:Hide()
	self.Trinket.start = nil
	self.Trinket.Text:SetText("")
	self.Faction:Hide()
	
	self.Crowd:UnregisterAllEvents()
	self.Trinket:UnregisterAllEvents()
	self.Diminish:UnregisterAllEvents()
end

function SyncUI_ArenaFrame_OnUpdate(self, elapsed)
	local unitID = "arena"..self:GetID()

	if UnitExists(unitID) then
		local name, class = select(1, UnitName(unitID)), select(2, UnitClass(unitID))
		local health, maxHealth = UnitHealth(unitID), UnitHealthMax(unitID)
		local mana, maxMana = UnitMana(unitID), UnitManaMax(unitID)
		local absorb = UnitGetTotalAbsorbs(unitID) or 0
		local barWidth, barHeight = self.HealthBar:GetSize()
		
		-- Values
		self.HealthBar:SetMinMaxValues(0, maxHealth)
		self.ManaBar:SetMinMaxValues(0, maxMana)
		SmoothBar(self.HealthBar,health)		
		SmoothBar(self.ManaBar,mana)
		
		-- Set Name
		self.Name:SetText(name)

		-- Health Bar Text
		if UnitIsDeadOrGhost(unitID) then
			self.Health:SetText("")
			self.HealthBar:SetValue(0)
		else
			if health >= 10000000 then
				self.Health:SetText(string.format("%.0f",(health)/1000000).."m".." | "..string.format("%.0f",math.ceil((health)*100/maxHealth)).."%")
			elseif health >= 10000 then
				self.Health:SetText(string.format("%.0f",(health)/1000).."k".." | "..string.format("%.0f",math.ceil((health)*100/maxHealth)).."%")
			elseif health > 0 then
				self.Health:SetText(health.." | "..string.format("%.0f",math.ceil((health)*100/maxHealth)).."%")
			end
		end

		-- AbsorbBar		
		if health + absorb > maxHealth then
			self.AbsorbBar:SetSize((barWidth-(health*barWidth/maxHealth))+0.1,barHeight)
		else
			self.AbsorbBar:SetSize((absorb * barWidth / maxHealth),barHeight)
		end
		if absorb == 0 then
			self.AbsorbBar:SetAlpha(0)
		else
			self.AbsorbBar:SetPoint("TOPLEFT", self.HealthBar:GetStatusBarTexture(), "TOPRIGHT")
			self.AbsorbBar:SetAlpha(1)
		end

		-- Update Status
		if not UnitIsConnected(unitID) then
			self.StatusIcon:SetTexture("Interface\\CHARACTERFRAME\\Disconnect-Icon")
			self.StatusIcon:SetTexCoord(0.2,0.8,0.2,0.8)
			self.StatusIcon:Show()
		elseif UnitHasIncomingResurrection(unitID) then
			self.StatusIcon:SetTexture("Interface\\RaidFrame\\Raid-Icon-Rez")
			self.StatusIcon:SetTexCoord(0,1,0,1)
			self.StatusIcon:Show()		
		elseif UnitIsDeadOrGhost(unitID) then
			self.StatusIcon:SetTexture("Interface\\WorldStateFrame\\SkullBones")
			self.StatusIcon:SetTexCoord(0,0.5,0,0.5)
			self.StatusIcon:Show()
		else
			self.StatusIcon:Hide()
		end
	end

	-- Update Trinket
	UpdateTrinket(self.Trinket)
	UpdateDiminish(self)
	
end

function SyncUI_ArenaFrame_OnTrinketUse(self,event, ...)
	local unitID, spell, rank, lineID, spellID = ...
	if spellID == 59752 or spellID == 42292 then
		PlaySound("AlarmClockWarning3")
		self.start, self.duration = GetTime(), 120
		self.cooldown:SetCooldown(GetTime(),120)
	elseif spellID == 7744 then
		if GetTime() - self.start > 90 or not self.start then
			self.start, self.duration = GetTime(), 30
			self.cooldown:SetCooldown(GetTime(),30)
		end
	end
end

function SyncUI_ArenaFrame_SetCrowdControl(self)
	local parent = self:GetParent()
	local unitID = "arena"..parent:GetID()
	
	local maxPriority = 1
	local getExpire = 0
	local Icon, Duration
	
	--Debuffs
	for i = 1, 40 do
		local name, _, icon, _, _, duration, expire, _, _, _, spellID = UnitDebuff(unitID, i)
		if not spellID then break end

		--Exception
		if spellID == 81261 then
			expire = GetTime() + 1 
		end
		
		for type in pairs(CrowdControl) do
			if CrowdControl[type][spellID] then
				local Priority = GetPriority(type)
				if Priority then
					if Priority > maxPriority then maxPriority = Priority end
					
					getExpire = expire
					Duration = duration
					Icon = icon
				end
			end
		end
	end

	--Buffs
	for i = 1, 40 do
		local name, _, icon, _, _, duration, expire, _, _, _, spellID = UnitBuff(unitID, i)
		if not spellID then break end
		
		for type in pairs(CrowdControl) do
			if CrowdControl[type][spellID] then
				local Priority = GetPriority(type)
				if Priority then
					if Priority == maxPriority and expire > getExpire then
						getExpire = expire
						Duration = duration
						Icon = icon
					elseif Priority > maxPriority then
						maxPriority = Priority
						getExpire = expire
						Duration = duration
						Icon = icon
					end
				end
			end
		end
	end

	--Update Icon
	if getExpire == 0 then
		self:Hide()
	elseif getExpire ~= self.getExpire then
		self:Show()
		self.Icon:SetTexture(Icon)
		if Duration > 0 then
			self.cooldown:SetCooldown(getExpire - Duration, Duration)
		end
	end
end

function SyncUI_ArenaFrame_Diminish_OnEvent(self,event,...)
	local affectedGUID = select(8, ...)
	local spellID = select(12, ...)
	local unitID = self:GetParent().unitID
	local parent = self:GetParent()
	
	if affectedGUID == UnitGUID(unitID) then
		for category in pairs(DiminishingReturns) do
			if DiminishingReturns[category][spellID] then
				for pos = 1, self.max do
					local frame = parent.frames[pos]
					
					if (select(2, ...)=="SPELL_AURA_APPLIED") or (select(2, ...)=="SPELL_AURA_REFRESH") then
						if frame.type == DiminishingReturns[category] then
							frame.getTime = 0
							frame.Cooldown:SetCooldown(0,0)
						end
					end
					
					if (select(2, ...)=="SPELL_AURA_REMOVED") then
						if frame.type == DiminishingReturns[category] then
							frame.getTime = GetTime()
							frame.drcount = frame.drcount + 1
							frame.Cooldown:SetCooldown(frame.getTime,diminishReset)
						break

						elseif frame.type == 0 then
							frame:Show()
							frame.type = DiminishingReturns[category]
							frame.getTime = GetTime()
							frame.iconTex = select(3, GetSpellInfo(spellID))
							frame.drcount = frame.drcount + 1
							frame.Icon:SetTexture(frame.iconTex)
							frame.Cooldown:SetCooldown(frame.getTime,diminishReset)

							self.max = self.max + 1
						end
					end
				end
			end
		end
	end
end


-- Prep Frame
local function UpdatePrepFrames(self)
	local numOpps = GetNumArenaOpponentSpecs()
	
	for index = 1, MAX_ARENA_ENEMIES do
		local prepFrame = _G["SyncUI_ArenaPrepFrame"..index]
		local unitID = "arena"..index
		
		if index <= numOpps then
			local spec = select(4, GetSpecializationInfoByID(GetArenaOpponentSpec(index)))
			local class = select(7, GetSpecializationInfoByID(GetArenaOpponentSpec(index)))
			local classColor = RAID_CLASS_COLORS[class]
			local r,g,b = classColor.r, classColor.g, classColor.b

			prepFrame.HealthBar:SetStatusBarColor(r,g,b)
			prepFrame.Spec:SetTexture(spec)
			prepFrame:Show()
		else
			prepFrame:Hide()
		end
	end
end

function SyncUI_ArenaPrepFrame_OnLoad(self)
	self:RegisterEvent("ARENA_OPPONENT_UPDATE")
	self:RegisterEvent("ARENA_PREP_OPPONENT_SPECIALIZATIONS")
	
	if GetNumArenaOpponentSpecs() and GetNumArenaOpponentSpecs() > 0 then
		SyncUI_ArenaPrepFrame_OnEvent(self, "ARENA_PREP_OPPONENT_SPECIALIZATIONS")
	end
end

function SyncUI_ArenaPrepFrame_OnEvent(self,event,arg1,arg2)
	if event == "ARENA_PREP_OPPONENT_SPECIALIZATIONS" then
		UpdatePrepFrames(self)
		self:Show()
	end
	
	if event == "ARENA_OPPONENT_UPDATE" then
		if arg2 == "seen" or arg2 == "destroyed" then
			for index = 1, MAX_ARENA_ENEMIES do
				if UnitGUID(arg1) then
					_G["SyncUI_ArenaPrepFrame"..index]:Hide()
				end
			end
		elseif arg2 == "cleared" then
			if select(2, IsInInstance()) ~= "arena" then
				self:Hide()
			end
		end
	end
end
