--[[	handler functions for consolidating raidbuffs

------------------]]

local _G = _G

local RaidBuffInfo = {
	[1] = {"Stats", "Interface\\Icons\\spell_nature_regeneration"},
	[2] = {"Stamina", "Interface\\Icons\\spell_shadow_bloodboil"},
	[3] = {"Attack Power", "Interface\\Icons\\ability_warrior_battleshout"},
	[4] = {"Haste", "Interface\\Icons\\ability_rogue_disembowel"},
	[5] = {"Spell Power", "Interface\\Icons\\spell_holy_magicalsentry"},
	[6] = {"Critical Strike", "Interface\\Icons\\ability_monk_prideofthetiger"},
	[7] = {"Mastery", "Interface\\Icons\\spell_nature_moonglow"},
	[8] = {"Multistrike", "Interface\\Icons\\inv_elemental_mote_air01"},
	[9] = {"Versatility", "Interface\\Icons\\warrior_talent_icon_skirmisher"},
}

function SyncUI_RaidBuffFrame_OnLoad(self)
	self:RegisterUnitEvent("UNIT_AURA","player")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("RAID_ROOSTER_UPDATE")
	self:RegisterEvent("GROUP_ROSTER_CHANGED")
	self:SetScale(0.8)

	for i = 1, NUM_LE_RAID_BUFF_TYPES do
		local button = _G["RaidBuffButton"..i]
		local icon = select(2, unpack(RaidBuffInfo[i]))
		button.Icon:SetTexture(icon)
		SyncUI_Cooldown_OnRegister(button.Cooldown)
	end

	WorldStateAlwaysUpFrame:ClearAllPoints()
	WorldStateAlwaysUpFrame:SetPoint("TOP",self,"BOTTOM")
end

function SyncUI_RaidBuffFrame_OnEvent(self)
	if GetNumGroupMembers() > 0 then
		self:Show()
	else
		self:Hide()
	end
	
	for i = 1, NUM_LE_RAID_BUFF_TYPES do
		local button = _G["RaidBuffButton"..i]
		local spellName, rank, texture, duration, expire, spellID, slot = GetRaidBuffTrayAuraInfo(i)
		if spellID then
			local timeLeft = duration - expire + GetTime()
			button.spellID = spellID
			button.Icon:SetDesaturated(false)
			button.Cooldown:SetCooldown(GetTime() - timeLeft, duration)
		else		
			button.Icon:SetDesaturated(true)
			button.Cooldown:SetCooldown(0,0)
		end
	end
end

function SyncUI_RaidBuffButton_OnEnter(self)
	local frame = _G[self:GetName()]
	local buffType = select(1, unpack(RaidBuffInfo[self:GetID()]))
	
	GameTooltip:SetOwner(frame, "ANCHOR_BOTTOMRIGHT",-35,0)
	GameTooltip:AddLine(buffType)
	GameTooltip:Show()
end
